import { RemoteTextRenderer } from './RemoteTextRenderer.mjs';
import { jsx } from 'react/jsx-runtime';

/**
 * Renders a remote node to the host using React.
 *
 * @param node The remote node to render using React
 */
function renderRemoteNode(node, {
  receiver,
  components
}) {
  switch (node.type) {
    case 1:
      {
        const Component = components.get(node.element);
        if (Component == null) {
          throw new Error(`No component found for remote element: ${node.element}`);
        }
        return /*#__PURE__*/jsx(Component, {
          element: node,
          receiver: receiver,
          components: components
        }, node.id);
      }
    case 3:
      {
        return /*#__PURE__*/jsx(RemoteTextRenderer, {
          remote: node,
          receiver: receiver
        }, node.id);
      }
    case 8:
      {
        return null;
      }
    default:
      {
        throw new Error(`Unknown remote node type: ${String(node)}`);
      }
  }
}

export { renderRemoteNode };
