import { default as React } from 'react';
import { EmbeddedResource } from '@modelcontextprotocol/sdk/types.js';
import { UIActionResult } from '../types';

export type HTMLResourceRendererProps = {
    resource: Partial<EmbeddedResource['resource']>;
    onUIAction?: (result: UIActionResult) => Promise<unknown>;
    style?: React.CSSProperties;
    proxy?: string;
    iframeRenderData?: Record<string, unknown>;
    autoResizeIframe?: boolean | {
        width?: boolean;
        height?: boolean;
    };
    sandboxPermissions?: string;
    iframeProps?: Omit<React.HTMLAttributes<HTMLIFrameElement>, 'src' | 'srcDoc' | 'style'> & {
        ref?: React.RefObject<HTMLIFrameElement>;
    };
};
export declare const InternalMessageType: {
    readonly UI_MESSAGE_RECEIVED: "ui-message-received";
    readonly UI_MESSAGE_RESPONSE: "ui-message-response";
    readonly UI_SIZE_CHANGE: "ui-size-change";
    readonly UI_LIFECYCLE_IFRAME_READY: "ui-lifecycle-iframe-ready";
    readonly UI_LIFECYCLE_IFRAME_RENDER_DATA: "ui-lifecycle-iframe-render-data";
    readonly UI_REQUEST_RENDER_DATA: "ui-request-render-data";
    readonly UI_PROXY_IFRAME_READY: "ui-proxy-iframe-ready";
    readonly UI_HTML_CONTENT: "ui-html-content";
};
export declare const ReservedUrlParams: {
    readonly WAIT_FOR_RENDER_DATA: "waitForRenderData";
};
export declare const HTMLResourceRenderer: {
    ({ resource, onUIAction, style, proxy, iframeRenderData, autoResizeIframe, sandboxPermissions, iframeProps, }: HTMLResourceRendererProps): import("react/jsx-runtime").JSX.Element | null;
    displayName: string;
};
export declare function postToFrame(type: (typeof InternalMessageType)[keyof typeof InternalMessageType], source: Window | null, origin: string, originalMessageId?: string, payload?: unknown): void;
//# sourceMappingURL=HTMLResourceRenderer.d.ts.map