'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.cjs');
const Node = require('./Node.cjs');

class Attr extends Node.Node {
  nodeType = (() => constants.NodeType.ATTRIBUTE_NODE)();
  [constants.NS] = null;
  [constants.NEXT] = null;
  [constants.OWNER_ELEMENT] = null;
  constructor(name, value, namespace) {
    super();
    this[constants.NAME] = name;
    this[constants.VALUE] = value;
    if (namespace) this[constants.NS] = namespace;
  }
  get nodeName() {
    return this[constants.NAME];
  }
  set nodeName(_readonly) {}
  get name() {
    return this[constants.NAME];
  }
  set name(_readonly) {}
  get value() {
    return this[constants.VALUE];
  }
  set value(value) {
    const str = String(value);
    this[constants.VALUE] = str;
    const ownerElement = this[constants.OWNER_ELEMENT];
    if (!ownerElement) return;
    this[constants.HOOKS].setAttribute?.(ownerElement, this[constants.NAME], str, this[constants.NS]);
  }
  get nodeValue() {
    return this.value;
  }
  set nodeValue(value) {
    this.value = value;
  }
  get ownerElement() {
    return this[constants.OWNER_ELEMENT];
  }
  get namespaceURI() {
    return this[constants.NS];
  }
  get specified() {
    return true;
  }
}

exports.Attr = Attr;
