'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.cjs');
const ChildNode = require('./ChildNode.cjs');

class CharacterData extends ChildNode.ChildNode {
  [constants.DATA] = '';
  constructor(data) {
    super();
    this[constants.DATA] = data == null ? '' : String(data);
  }
  setData(data) {
    let str = '';
    if (data != null) {
      str = typeof data === 'string' ? data : String(data);
    }
    this[constants.DATA] = str;
    this[constants.HOOKS].setText?.(this, str);
  }
  get data() {
    return this[constants.DATA];
  }
  set data(data) {
    this.setData(data);
  }
}

exports.CharacterData = CharacterData;
