'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.cjs');
const ParentNode = require('./ParentNode.cjs');

class DocumentFragment extends ParentNode.ParentNode {
  nodeType = (() => constants.NodeType.DOCUMENT_FRAGMENT_NODE)();
  [constants.NAME] = '#document-fragment';
  [constants.OWNER_DOCUMENT] = (() => typeof window !== 'undefined' ? window.document : null)();
}

exports.DocumentFragment = DocumentFragment;
