'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.cjs');

class NamedNodeMap {
  [constants.CHILD] = null;
  constructor(ownerElement) {
    this[constants.OWNER_ELEMENT] = ownerElement;
  }
  getNamedItem(name) {
    return this.getNamedItemNS(null, name);
  }
  getNamedItemNS(namespaceURI, name) {
    let attr = this[constants.CHILD];
    while (attr) {
      if (attr.name === name && attr[constants.NS] == namespaceURI) {
        return attr;
      }
      attr = attr[constants.NEXT];
    }
    return null;
  }
  item(index) {
    let attr = this[constants.CHILD];
    let i = 0;
    while (attr) {
      if (i++ === index) return attr;
      attr = attr[constants.NEXT];
    }
    return null;
  }
  get length() {
    let index = 0;
    let attr = this[constants.CHILD];
    while (attr) {
      index++;
      attr = attr[constants.NEXT];
    }
    return index;
  }
  removeNamedItem(name) {
    return this.removeNamedItemNS(null, name);
  }
  removeNamedItemNS(namespaceURI, name) {
    const ownerElement = this[constants.OWNER_ELEMENT];
    let attr = this[constants.CHILD];
    let prev = null;
    while (attr != null) {
      if (attr.name === name && attr[constants.NS] == namespaceURI) {
        if (prev) prev[constants.NEXT] = attr[constants.NEXT];
        if (this[constants.CHILD] === attr) this[constants.CHILD] = attr[constants.NEXT];
        updateElementAttribute(ownerElement, attr.name, attr.value, null);
        ownerElement[constants.HOOKS].removeAttribute?.(ownerElement, name, namespaceURI);
        return attr;
      }
      prev = attr;
      attr = attr[constants.NEXT];
    }
    return null;
  }
  setNamedItem(attr) {
    const ownerElement = this[constants.OWNER_ELEMENT];
    let old = null;
    let child = this[constants.CHILD];
    attr[constants.OWNER_ELEMENT] = ownerElement;
    if (child == null) {
      this[constants.CHILD] = attr;
      // return null;
    } else {
      let prev;
      while (child) {
        if (child.name === attr.name && child[constants.NS] == attr[constants.NS]) {
          if (prev) prev[constants.NEXT] = attr;else this[constants.CHILD] = attr;
          attr[constants.NEXT] = child[constants.NEXT];
          child[constants.NEXT] = null;
          old = child;
          break;
          // return child;
        }
        prev = child;
        child = child[constants.NEXT];
      }
      if (prev) prev[constants.NEXT] = attr;else this[constants.CHILD] = attr;
      // return null;
    }

    // only invoke the protocol if the value changed
    if (!old || old.value !== attr.value) {
      updateElementAttribute(ownerElement, attr.name, old?.value ?? null, attr.value);
      ownerElement[constants.HOOKS].setAttribute?.(ownerElement, attr.name, attr.value, attr[constants.NS]);
    }
    return old;
  }
  setNamedItemNS(attr) {
    return this.setNamedItem(attr);
  }
  *[Symbol.iterator]() {
    let attr = this[constants.CHILD];
    while (attr) {
      yield attr;
      attr = attr[constants.NEXT];
    }
  }
}
function updateElementAttribute(element, name, oldValue, newValue) {
  const {
    observedAttributes
  } = element.constructor;
  const {
    attributeChangedCallback
  } = element;
  if (name === 'slot') {
    element.slot = newValue ?? '';
  }
  if (attributeChangedCallback == null || observedAttributes == null || !observedAttributes.includes(name)) {
    return;
  }
  return attributeChangedCallback.call(element, name, oldValue, newValue);
}

exports.NamedNodeMap = NamedNodeMap;
