'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const NAME = Symbol('name');
const VALUE = Symbol('value');
const NS = Symbol('ns');
const OWNER_ELEMENT = Symbol('owner');
const OWNER_DOCUMENT = Symbol('owner_document');
const ATTRIBUTES = Symbol('attributes');
const PREV = Symbol('prev');
const NEXT = Symbol('next');
const CHILD = Symbol('child');
const PARENT = Symbol('parent');
const DATA = Symbol('data');
const LISTENERS = Symbol('listeners');
const IS_TRUSTED = Symbol('isTrusted');
const PATH = Symbol('path');
const STOP_IMMEDIATE_PROPAGATION = Symbol('stop_immediate_propagation');
const CONTENT = Symbol('content');
const HOOKS = Symbol('hooks');
const IS_CONNECTED = Symbol('is_connected');

// @TODO remove explicit values
let NodeType = /*#__PURE__*/function (NodeType) {
  NodeType[NodeType["NODE"] = 0] = "NODE";
  NodeType[NodeType["ELEMENT_NODE"] = 1] = "ELEMENT_NODE";
  NodeType[NodeType["ATTRIBUTE_NODE"] = 2] = "ATTRIBUTE_NODE";
  NodeType[NodeType["TEXT_NODE"] = 3] = "TEXT_NODE";
  NodeType[NodeType["CDATA_SECTION_NODE"] = 4] = "CDATA_SECTION_NODE";
  NodeType[NodeType["ENTITY_REFERENCE_NODE"] = 5] = "ENTITY_REFERENCE_NODE";
  NodeType[NodeType["ENTITY_NODE"] = 6] = "ENTITY_NODE";
  NodeType[NodeType["PROCESSING_INSTRUCTION_NODE"] = 7] = "PROCESSING_INSTRUCTION_NODE";
  NodeType[NodeType["COMMENT_NODE"] = 8] = "COMMENT_NODE";
  NodeType[NodeType["DOCUMENT_NODE"] = 9] = "DOCUMENT_NODE";
  NodeType[NodeType["DOCUMENT_TYPE_NODE"] = 10] = "DOCUMENT_TYPE_NODE";
  NodeType[NodeType["DOCUMENT_FRAGMENT_NODE"] = 11] = "DOCUMENT_FRAGMENT_NODE";
  return NodeType;
}({});
let NamespaceURI = /*#__PURE__*/function (NamespaceURI) {
  NamespaceURI["XHTML"] = "http://www.w3.org/1999/xhtml";
  NamespaceURI["SVG"] = "http://www.w3.org/2000/svg";
  return NamespaceURI;
}({});

exports.ATTRIBUTES = ATTRIBUTES;
exports.CHILD = CHILD;
exports.CONTENT = CONTENT;
exports.DATA = DATA;
exports.HOOKS = HOOKS;
exports.IS_CONNECTED = IS_CONNECTED;
exports.IS_TRUSTED = IS_TRUSTED;
exports.LISTENERS = LISTENERS;
exports.NAME = NAME;
exports.NEXT = NEXT;
exports.NS = NS;
exports.NamespaceURI = NamespaceURI;
exports.NodeType = NodeType;
exports.OWNER_DOCUMENT = OWNER_DOCUMENT;
exports.OWNER_ELEMENT = OWNER_ELEMENT;
exports.PARENT = PARENT;
exports.PATH = PATH;
exports.PREV = PREV;
exports.STOP_IMMEDIATE_PROPAGATION = STOP_IMMEDIATE_PROPAGATION;
exports.VALUE = VALUE;
