'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const node = require('./node.cjs');
const remoteReceived = require('./hooks/remote-received.cjs');
const jsxRuntime = require('react/jsx-runtime');

/**
 * A component that can be used to render a list of children elements, without any
 * additional wrapping elements. This is typically used on the host to render the `remote-root`
 * element, which is a special element rendered by Remote DOM to translate between React
 * elements passed as properties and slotted elements.
 */
const RemoteFragmentRenderer = function RemoteFragmentRenderer({
  element,
  receiver,
  components
}) {
  const fragments = remoteReceived.useRemoteReceived(element, receiver);
  if (!fragments) return null;
  const renderOptions = {
    receiver,
    components
  };
  return /*#__PURE__*/jsxRuntime.jsx(jsxRuntime.Fragment, {
    children: fragments.children.map(child => node.renderRemoteNode(child, renderOptions))
  });
};

exports.RemoteFragmentRenderer = RemoteFragmentRenderer;
