'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const RemoteTextRenderer = require('./RemoteTextRenderer.cjs');
const jsxRuntime = require('react/jsx-runtime');

/**
 * Renders a remote node to the host using React.
 *
 * @param node The remote node to render using React
 */
function renderRemoteNode(node, {
  receiver,
  components
}) {
  switch (node.type) {
    case 1:
      {
        const Component = components.get(node.element);
        if (Component == null) {
          throw new Error(`No component found for remote element: ${node.element}`);
        }
        return /*#__PURE__*/jsxRuntime.jsx(Component, {
          element: node,
          receiver: receiver,
          components: components
        }, node.id);
      }
    case 3:
      {
        return /*#__PURE__*/jsxRuntime.jsx(RemoteTextRenderer.RemoteTextRenderer, {
          remote: node,
          receiver: receiver
        }, node.id);
      }
    case 8:
      {
        return null;
      }
    default:
      {
        throw new Error(`Unknown remote node type: ${String(node)}`);
      }
  }
}

exports.renderRemoteNode = renderRemoteNode;
