import { useRemoteReceived } from './hooks/remote-received.mjs';
import { renderRemoteNode } from './node.mjs';
import { jsx, Fragment } from 'react/jsx-runtime';

/**
 * A component that can be used to render a tree of UI elements from a remote
 * environment.
 */
function RemoteRootRenderer(props) {
  const {
    receiver
  } = props;
  const {
    children
  } = useRemoteReceived(receiver.root, receiver);
  return /*#__PURE__*/jsx(Fragment, {
    children: children.map(child => renderRemoteNode(child, props))
  });
}

export { RemoteRootRenderer };
