import { TRANSFERABLE } from './constants.mjs';

/**
 * Marks the value as being transferable between threads. The memory for this object
 * will be moved to the target thread once the object is sent.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API/Transferable_objects
 */
function markAsTransferable(value) {
  Object.assign(value, {
    [TRANSFERABLE]: true
  });
  return value;
}

export { markAsTransferable };
