<!-- -*- mode: markdown; -*- vim: set tw=78 ts=4 sts=0 sw=4 noet ft=markdown norl: -->

# Port—`mod_tile`

## Initial Configuration and Setup

This port primarily contains two applications, a daemon, `renderd`, which
renders map tiles from the database; and an Apache module, `mod_tile`, which
serves those tiles.

The port includes a shell script, `/opt/local/share/mod_tile/osm_setup_db.sh`
which largely automates the process of downloading and importing OpenStreetMap
data into a PostgreSQL database.  There are some notes at the beginning of the
script on how to use it.  Note the section that requires a small modification
to the PostgreSQL database configuration to provide the `nobody` system user
with database access permission.

By default the script imports the country of Monaco, situated on the
Mediterranean coast to the south of France.  It is recommended you experiment
with a small area until you are satisfied with the processes involved.
Depending on the power of the machine employed, processing data for larger
areas can take considerable time and resources.  Generally, SSD disks are
recommended to reduce processing times.

The script sources variables from
`/opt/local/etc/mod_tile/osm-tiles-update.conf`.  Update that configuration
file appropriately.

To enable the `mod_tile` module in Apache, install it with:

	$ cd /opt/local/lib/apache2/modules/
	$ sudo /opt/local/bin/apxs -a -e -n "tile" mod_tile.so
	$ sudo port reload apache2

You should complete the import process before starting the `renderd` daemon
process, otherwise it is simply going to report errors.  The `renderd` process
is started with:

	$ sudo port load mod_tile

Optionally, you can download and apply incremental updates to the database by
running an import script which can be scheduled with:

	$ sudo launchctl load -w \
	/Library/LaunchDaemons/org.macports.fetch-osm-db-updates.plist

This script downloads an hourly snapshot, so it has to be run at least that
frequently to keep up-to-date.  The default installation runs it more
frequently to allow it to catch up, allowing for a little downtime.  Depending
on your requirements, it may be better not to run this process at all and just
refresh the entire region every few months or so.

If the daemon is loaded you can use the following command to immediately
initiate the process before the next scheduled session.

	$ sudo launchctl kickstart -p system/org.macports.fetch-osm-db-updates

The output of the various scripts and utilities are written to log files under
`/opt/local/var/log/renderd`.  A configuration file for `logrotate` is
deployed to `/opt/local/etc/logrotate.d/renderd`.  Please see the `logrotate`
man pages for further information.

## Cleanup and Starting Afresh

To delete the imported data and start afresh, delete the database and the
`mod_tile` tile cache.

1.  As a PostgreSQL super user, drop the database (default `gis`):

		$ dropdb gis

2.  Remove the tile cache with:

		$ sudo rm -rf /opt/local/var/lib/mod_tile/*

3.  Remove the state files for incremental updates with:

		$ sudo rm -rf /opt/local/var/lib/mod_tile/.osmosis

Optionally, re-create the `mapnik.xml` file in order to use the latest
stylesheets from the `openstreetmap-carto` port.  e.g.

1.  Rename the current `mapnik.xml`

		$ cd /opt/local/etc/renderd/
		$ sudo mv mapnik.xml mapnik.xml~

2.  If necessary, install the `carto` port:

		$ sudo port install carto

3.  Use `carto` to create an updated version of `mapnik.xml`:

		$ carto /opt/local/share/openstreetmap-carto/project.mml | \
		sudo tee /opt/local/etc/renderd/mapnik.xml

## Noto Fonts

The `mapnik.xml` configuration file attempts to use Google Noto Fonts if they
are available under `/opt/local/lib/mapnik/fonts`.  Download the fonts and
create a symbolic to their installed location:

1.	Download a zip containing the fonts from
    <https://github.com/google/fonts> - there is a link under `Download All
    Google Fonts` - or from <https://github.com/notofonts/notofonts.github.io/releases>.

		$ sudo mkdir -p /usr/local/share/fonts/noto
		$ sudo chown $USER /usr/local/share/fonts/noto
		$ cd /usr/local/share/fonts/noto
		$ unzip ~/Downloads/Noto-unhinted.zip
		$ chmod +r *.?tf
		$ sudo ln -s /usr/local/share/fonts/noto /opt/local/lib/mapnik/fonts

The debug information written to `/opt/local/var/lib/renderd/renderd.log`
during the daemon startup reports whether fonts are loaded successfully or
not.  The configuration is fundamentally a priority preference for normal,
bold and oblique fonts.  It is expected some font varieties will not be found.

**Note:** sorting out the fonts you want from the downloads is cumbersome.
Installing the `findutils` package and using `gfind` (needed for using
extended regular expresssions) can ease the process.

E.g. list how many files the release from
[notofonts releases](https://github.com/notofonts/notofonts.github.io/releases)
contain:

	$ gfind ~/Downloads/notofonts.github.io-noto-monthly-release-2025.02.01/ \
	-type f -regextype posix-extended \
	-regex '.*/googlefonts/ttf/Noto(Sans|Serif).*\.ttf' | \
	wc -l

and copying those files to the font folder:

	$ gfind ~/Downloads/notofonts.github.io-noto-monthly-release-2025.02.01/
	-type f -regextype posix-extended -regex
	'.*/googlefonts/ttf/Noto(Sans|Serif).*\.ttf' \
	-exec cp '{}' /usr/local/share/fonts/noto/ \;

## Changing the Default Database name

To use a different database name, it is necessary to modify a number of
configuration files:

- `/opt/local/etc/mod_tile/osm-tiles-update.conf`
- `/opt/local/etc/openstreetmap-carto/external-data.yml`
- `/opt/local/etc/renderd/mapnik.xml`

The `mapnik.xml` configuration file repeatedly defines the database name for
every style.  It may be easier to re-create the entire configuration file from
its original source file as follows:

1.  Make a copy of `/opt/local/share/openstreetmap-carto/project.mml` and edit
    the `dbname` attribute appropriately in the copy.

2.  Use `carto` to re-create `mapnik.xml` using the copy of the `project.mml`
    source file:

		$ sudo port install carto
		$ carto project.mml | sudo tee /opt/local/etc/renderd/mapnik.xml

## Useful Resources

- [mod_tile][]
- [mod_tile_switch2osm][]
- [Osmosis][]
- [OpenStreetMap][]
- [openstreetmap-carto][]
- [OSM Tile Calculator][]
- [PostGIS][]
- [PostgreSQL][]
- [switch2osm][]

[mod_tile]: https://github.com/openstreetmap/mod_tile "an Apache 2 module to deliver map tiles"
[mod_tile_switch2osm]: https://github.com/SomeoneElseOSM/mod_tile "an Apache 2 module to deliver map tiles"
[Osmosis]: https://github.com/openstreetmap/osmosis "a command line Java application for processing Open Street Map data"
[OpenStreetMap]: http://www.openstreetmap.org/ "OpenStreetMap"
[openstreetmap-carto]: https://github.com/gravitystorm/openstreetmap-carto "a general-purpose OpenStreetMap mapnik style, in CartoCSS"
[OSM Tile Calculator]: https://tools.geofabrik.de/calc/#type=geofabrik_standard&bbox=7.405088,43.720716,7.447488,43.753832 "Calculates tile size and number of tiles in given bounding box"
[PostGIS]: https://postgis.net. "Spatial and Geographic objects for PostgreSQL"
[PostgreSQL]: https://www.postgresql.org "A powerful, open source object-relational database system"
[switch2osm]: https://switch2osm.org/ "Switch2OSM—Take back control of your maps"
