" Name:         darkblue
" Description:  For those who prefer dark background
" Author:       Original author Bohdan Vlasyuk <bohdan@vstu.edu.ua>
" URL:          https://github.com/vim/colorschemes
" License:      Same as Vim
" Last Change:  2025 Oct 08

" Generated by Colortemplate v3.0.0-beta10

set background=dark

" hi clear
source $VIMRUNTIME/colors/vim.lua " Nvim: revert to Vim default color scheme
let g:colors_name = 'darkblue'

let s:t_Co = &t_Co
let s:tgc = has('termguicolors') && &termguicolors

let g:terminal_ansi_colors = ['#000000', '#8b0000', '#90f020', '#ffa500', '#00008b', '#8b008b', '#008b8b', '#c0c0c0', '#808080', '#ffa0a0', '#90f020', '#ffff60', '#0030ff', '#ff00ff', '#90fff0', '#ffffff']
" Nvim uses g:terminal_color_{0-15} instead
for i in range(g:terminal_ansi_colors->len())
  let g:terminal_color_{i} = g:terminal_ansi_colors[i]
endfor

hi! link Added String
hi! link Boolean Constant
hi! link Character Constant
hi! link Conditional Statement
hi! link CurSearch Search
hi! link CursorIM Cursor
hi! link CursorLineFold CursorLine
hi! link CursorLineSign CursorLine
hi! link Debug Special
hi! link Define PreProc
hi! link Delimiter Special
hi! link EndOfBuffer NonText
hi! link ErrorMsg Error
hi! link Exception Statement
hi! link Float Constant
hi! link Function Identifier
hi! link Include PreProc
hi! link Keyword Statement
hi! link Label Statement
hi! link LineNrAbove LineNr
hi! link LineNrBelow LineNr
hi! link Macro PreProc
hi! link MessageWindow Pmenu
hi! link Number Constant
hi! link Operator Statement
hi! link PopupNotification Todo
hi! link PreCondit PreProc
hi! link PreInsert NonText
hi! link Removed WarningMsg
hi! link Repeat Statement
hi! link SpecialChar Special
hi! link SpecialComment Special
hi! link StatusLineTerm StatusLine
hi! link StatusLineTermNC StatusLineNC
hi! link StorageClass Type
hi! link String Constant
hi! link Structure Type
hi! link TabLineFill TabLine
hi! link TabPanel Normal
hi! link TabPanelFill Normal
hi! link Tag Special
hi! link Terminal Normal
hi! link Typedef Type
hi! link diffBDiffer WarningMsg
hi! link diffCommon WarningMsg
hi! link diffDiffer WarningMsg
hi! link diffIdentical WarningMsg
hi! link diffIsA WarningMsg
hi! link diffNoEOL WarningMsg
hi! link diffOnly WarningMsg
hi! link lCursor Cursor

hi Normal guifg=#c0c0c0 guibg=#000040 guisp=NONE gui=NONE ctermfg=252 ctermbg=17 cterm=NONE term=NONE
hi ColorColumn guifg=#c0c0c0 guibg=#8b0000 guisp=NONE gui=NONE ctermfg=252 ctermbg=88 cterm=NONE term=reverse
hi Comment guifg=#80a0ff guibg=NONE guisp=NONE gui=NONE ctermfg=111 ctermbg=NONE cterm=NONE term=bold
hi Conceal guifg=#008b8b guibg=NONE guisp=NONE gui=NONE ctermfg=30 ctermbg=NONE cterm=NONE term=NONE
hi Constant guifg=#ffa0a0 guibg=NONE guisp=NONE gui=NONE ctermfg=217 ctermbg=NONE cterm=NONE term=NONE
hi Cursor guifg=#000000 guibg=#ffff60 guisp=NONE gui=NONE ctermfg=16 ctermbg=227 cterm=NONE term=reverse
hi CursorColumn guifg=NONE guibg=#666666 guisp=NONE gui=NONE ctermfg=NONE ctermbg=59 cterm=NONE term=NONE
hi CursorLine guifg=NONE guibg=#666666 guisp=NONE gui=NONE ctermfg=NONE ctermbg=59 cterm=NONE term=underline
hi CursorLineNr guifg=#ffff60 guibg=#666666 guisp=NONE gui=NONE ctermfg=227 ctermbg=59 cterm=NONE term=bold
hi DiffAdd guifg=#ffffff guibg=#5f875f guisp=NONE gui=NONE ctermfg=231 ctermbg=65 cterm=NONE term=reverse
hi DiffChange guifg=#ffffff guibg=#5f87af guisp=NONE gui=NONE ctermfg=231 ctermbg=67 cterm=NONE term=NONE
hi DiffDelete guifg=#ffffff guibg=#af5faf guisp=NONE gui=NONE ctermfg=231 ctermbg=133 cterm=NONE term=reverse
hi DiffText guifg=#000000 guibg=#c6c6c6 guisp=NONE gui=NONE ctermfg=16 ctermbg=251 cterm=NONE term=reverse
hi Directory guifg=#008b8b guibg=NONE guisp=NONE gui=NONE ctermfg=30 ctermbg=NONE cterm=NONE term=NONE
hi Error guifg=#ffa0a0 guibg=NONE guisp=NONE gui=reverse ctermfg=217 ctermbg=NONE cterm=reverse term=bold,reverse
hi FoldColumn guifg=#808080 guibg=NONE guisp=NONE gui=bold ctermfg=102 ctermbg=NONE cterm=NONE term=NONE
hi Folded guifg=#808080 guibg=NONE guisp=NONE gui=bold ctermfg=102 ctermbg=NONE cterm=NONE term=NONE
hi Identifier guifg=#90fff0 guibg=NONE guisp=NONE gui=NONE ctermfg=123 ctermbg=NONE cterm=NONE term=NONE
hi Ignore guifg=#000040 guibg=#c0c0c0 guisp=NONE gui=NONE ctermfg=17 ctermbg=252 cterm=NONE term=NONE
hi IncSearch guifg=#ffffff guibg=#0030ff guisp=NONE gui=reverse ctermfg=231 ctermbg=27 cterm=reverse term=bold,reverse,underline
hi LineNr guifg=#90f020 guibg=NONE guisp=NONE gui=NONE ctermfg=118 ctermbg=NONE cterm=NONE term=NONE
hi MatchParen guifg=NONE guibg=NONE guisp=NONE gui=reverse ctermfg=NONE ctermbg=NONE cterm=reverse term=bold,underline
hi ModeMsg guifg=#90fff0 guibg=NONE guisp=NONE gui=NONE ctermfg=123 ctermbg=NONE cterm=NONE term=bold
hi MoreMsg guifg=#006400 guibg=NONE guisp=NONE gui=NONE ctermfg=22 ctermbg=NONE cterm=NONE term=NONE
hi NonText guifg=#0030ff guibg=NONE guisp=NONE gui=NONE ctermfg=27 ctermbg=NONE cterm=NONE term=NONE
hi Pmenu guifg=#ffffff guibg=#0030ff guisp=NONE gui=NONE ctermfg=231 ctermbg=27 cterm=NONE term=reverse
hi PmenuMatch guifg=#ff80ff guibg=#0030ff guisp=NONE gui=NONE ctermfg=213 ctermbg=27 cterm=NONE term=NONE
hi PmenuMatchSel guifg=#ff00ff guibg=#ffffff guisp=NONE gui=NONE ctermfg=201 ctermbg=231 cterm=NONE term=NONE
hi PmenuSbar guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
hi PmenuSel guifg=#0030ff guibg=#ffffff guisp=NONE gui=NONE ctermfg=27 ctermbg=231 cterm=NONE term=bold
hi PmenuThumb guifg=NONE guibg=#ffffff guisp=NONE gui=NONE ctermfg=NONE ctermbg=231 cterm=NONE term=NONE
hi PreProc guifg=#ff80ff guibg=NONE guisp=NONE gui=NONE ctermfg=213 ctermbg=NONE cterm=NONE term=NONE
hi Question guifg=#90f020 guibg=NONE guisp=NONE gui=NONE ctermfg=118 ctermbg=NONE cterm=NONE term=standout
hi QuickFixLine guifg=#000000 guibg=#ff80ff guisp=NONE gui=NONE ctermfg=16 ctermbg=213 cterm=NONE term=NONE
hi Search guifg=#90fff0 guibg=#0030ff guisp=NONE gui=NONE ctermfg=123 ctermbg=27 cterm=NONE term=reverse
hi SignColumn guifg=#808080 guibg=NONE guisp=NONE gui=NONE ctermfg=102 ctermbg=NONE cterm=NONE term=reverse
hi Special guifg=#ffa500 guibg=NONE guisp=NONE gui=NONE ctermfg=214 ctermbg=NONE cterm=NONE term=NONE
hi SpecialKey guifg=#008b8b guibg=NONE guisp=NONE gui=NONE ctermfg=30 ctermbg=NONE cterm=NONE term=bold
hi SpellBad guifg=#ff0000 guibg=NONE guisp=#ff0000 gui=undercurl ctermfg=196 ctermbg=NONE cterm=underline term=underline
hi SpellCap guifg=#90f020 guibg=NONE guisp=#90f020 gui=undercurl ctermfg=118 ctermbg=NONE cterm=underline term=underline
hi SpellLocal guifg=#90fff0 guibg=NONE guisp=#90fff0 gui=undercurl ctermfg=123 ctermbg=NONE cterm=underline term=underline
hi SpellRare guifg=#ff00ff guibg=NONE guisp=#ff00ff gui=undercurl ctermfg=201 ctermbg=NONE cterm=underline term=underline
hi Statement guifg=#ffff60 guibg=NONE guisp=NONE gui=NONE ctermfg=227 ctermbg=NONE cterm=NONE term=NONE
hi StatusLine guifg=#000040 guibg=#c0c0c0 guisp=NONE gui=NONE ctermfg=17 ctermbg=252 cterm=NONE term=bold,reverse
hi StatusLineNC guifg=#000000 guibg=#808080 guisp=NONE gui=NONE ctermfg=16 ctermbg=102 cterm=NONE term=bold,underline
hi TabLine guifg=#000000 guibg=#808080 guisp=NONE gui=NONE ctermfg=16 ctermbg=102 cterm=NONE term=bold,underline
hi TabLineSel guifg=#000040 guibg=#c0c0c0 guisp=NONE gui=NONE ctermfg=17 ctermbg=252 cterm=NONE term=bold,reverse
hi Title guifg=#ff00ff guibg=NONE guisp=NONE gui=NONE ctermfg=201 ctermbg=NONE cterm=NONE term=NONE
hi TitleBar guifg=#c0c0c0 guibg=#3c3c66 guisp=NONE gui=NONE ctermfg=252 ctermbg=237 cterm=NONE term=NONE
hi TitleBarNC guifg=#808080 guibg=#2c2c56 guisp=NONE gui=NONE ctermfg=102 ctermbg=236 cterm=NONE term=NONE
hi Todo guifg=NONE guibg=NONE guisp=NONE gui=reverse ctermfg=NONE ctermbg=NONE cterm=reverse term=bold,reverse
hi ToolbarButton guifg=#ffffff guibg=#0030ff guisp=NONE gui=NONE ctermfg=231 ctermbg=27 cterm=NONE term=bold,reverse
hi ToolbarLine guifg=NONE guibg=NONE guisp=NONE gui=NONE ctermfg=NONE ctermbg=NONE cterm=NONE term=reverse
hi Type guifg=#90f020 guibg=NONE guisp=NONE gui=NONE ctermfg=118 ctermbg=NONE cterm=NONE term=NONE
hi Underlined guifg=#80a0ff guibg=NONE guisp=NONE gui=underline ctermfg=111 ctermbg=NONE cterm=underline term=underline
hi VertSplit guifg=#000000 guibg=#808080 guisp=NONE gui=NONE ctermfg=16 ctermbg=102 cterm=NONE term=NONE
hi Visual guifg=#8080ff guibg=#ffffff guisp=NONE gui=reverse ctermfg=105 ctermbg=231 cterm=reverse term=reverse
hi VisualNOS guifg=#8080ff guibg=#c0c0c0 guisp=NONE gui=reverse,underline ctermfg=105 ctermbg=252 cterm=reverse,underline term=NONE
hi WarningMsg guifg=#ff0000 guibg=NONE guisp=NONE gui=NONE ctermfg=196 ctermbg=NONE cterm=NONE term=standout
hi WildMenu guifg=#ffff60 guibg=#000000 guisp=NONE gui=NONE ctermfg=227 ctermbg=16 cterm=NONE term=bold
hi debugBreakpoint guifg=#90f020 guibg=#00008b guisp=NONE gui=reverse ctermfg=118 ctermbg=18 cterm=reverse term=reverse
hi debugPC guifg=#90fff0 guibg=#00008b guisp=NONE gui=reverse ctermfg=123 ctermbg=18 cterm=reverse term=reverse

if s:tgc || s:t_Co >= 256
  finish
endif

if s:t_Co >= 16
  hi Normal ctermfg=grey ctermbg=black cterm=NONE
  hi ColorColumn ctermfg=grey ctermbg=darkred cterm=NONE
  hi Comment ctermfg=blue ctermbg=NONE cterm=NONE
  hi Conceal ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi Constant ctermfg=red ctermbg=NONE cterm=NONE
  hi Cursor ctermfg=black ctermbg=yellow cterm=NONE
  hi CursorColumn ctermfg=NONE ctermbg=NONE cterm=underline
  hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
  hi CursorLineNr ctermfg=yellow ctermbg=NONE cterm=underline
  hi DiffAdd ctermfg=white ctermbg=darkgreen cterm=NONE
  hi DiffChange ctermfg=white ctermbg=blue cterm=NONE
  hi DiffDelete ctermfg=white ctermbg=magenta cterm=NONE
  hi DiffText ctermfg=black ctermbg=grey cterm=NONE
  hi Directory ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi Error ctermfg=red ctermbg=NONE cterm=reverse
  hi FoldColumn ctermfg=darkgrey ctermbg=NONE cterm=NONE
  hi Folded ctermfg=darkgrey ctermbg=NONE cterm=NONE
  hi Identifier ctermfg=cyan ctermbg=NONE cterm=NONE
  hi Ignore ctermfg=black ctermbg=grey cterm=NONE
  hi IncSearch ctermfg=white ctermbg=blue cterm=reverse
  hi LineNr ctermfg=green ctermbg=NONE cterm=NONE
  hi MatchParen ctermfg=NONE ctermbg=NONE cterm=reverse
  hi ModeMsg ctermfg=cyan ctermbg=NONE cterm=NONE
  hi MoreMsg ctermfg=darkgreen ctermbg=NONE cterm=NONE
  hi NonText ctermfg=blue ctermbg=NONE cterm=NONE
  hi Pmenu ctermfg=white ctermbg=blue cterm=NONE
  hi PmenuMatch ctermfg=magenta ctermbg=blue cterm=NONE
  hi PmenuMatchSel ctermfg=darkmagenta ctermbg=white cterm=NONE
  hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
  hi PmenuSel ctermfg=blue ctermbg=white cterm=NONE
  hi PmenuThumb ctermfg=NONE ctermbg=white cterm=NONE
  hi PreProc ctermfg=magenta ctermbg=NONE cterm=NONE
  hi Question ctermfg=green ctermbg=NONE cterm=NONE
  hi QuickFixLine ctermfg=black ctermbg=magenta cterm=NONE
  hi Search ctermfg=white ctermbg=blue cterm=NONE
  hi SignColumn ctermfg=darkgrey ctermbg=NONE cterm=NONE
  hi Special ctermfg=darkyellow ctermbg=NONE cterm=NONE
  hi SpecialKey ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi SpellBad ctermfg=red ctermbg=NONE cterm=underline
  hi SpellCap ctermfg=green ctermbg=NONE cterm=underline
  hi SpellLocal ctermfg=cyan ctermbg=NONE cterm=underline
  hi SpellRare ctermfg=darkmagenta ctermbg=NONE cterm=underline
  hi Statement ctermfg=yellow ctermbg=NONE cterm=NONE
  hi StatusLine ctermfg=black ctermbg=grey cterm=NONE
  hi StatusLineNC ctermfg=black ctermbg=darkgrey cterm=NONE
  hi TabLine ctermfg=black ctermbg=darkgrey cterm=NONE
  hi TabLineSel ctermfg=white ctermbg=black cterm=NONE
  hi Title ctermfg=darkmagenta ctermbg=NONE cterm=NONE
  hi TitleBar ctermfg=grey ctermbg=black cterm=NONE
  hi TitleBarNC ctermfg=darkgrey ctermbg=black cterm=NONE
  hi Todo ctermfg=NONE ctermbg=NONE cterm=reverse
  hi ToolbarButton ctermfg=white ctermbg=blue cterm=NONE
  hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Type ctermfg=green ctermbg=NONE cterm=NONE
  hi Underlined ctermfg=blue ctermbg=NONE cterm=underline
  hi VertSplit ctermfg=black ctermbg=darkgrey cterm=NONE
  hi Visual ctermfg=blue ctermbg=white cterm=reverse
  hi VisualNOS ctermfg=blue ctermbg=grey cterm=reverse,underline
  hi WarningMsg ctermfg=red ctermbg=NONE cterm=NONE
  hi WildMenu ctermfg=yellow ctermbg=black cterm=NONE
  hi debugBreakpoint ctermfg=green ctermbg=darkblue cterm=reverse
  hi debugPC ctermfg=cyan ctermbg=darkblue cterm=reverse
  finish
endif

if s:t_Co >= 8
  hi Normal ctermfg=grey ctermbg=black cterm=NONE
  hi ColorColumn ctermfg=grey ctermbg=darkred cterm=NONE
  hi Comment ctermfg=darkblue ctermbg=NONE cterm=bold
  hi Conceal ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Constant ctermfg=darkred ctermbg=NONE cterm=bold
  hi Cursor ctermfg=black ctermbg=yellow cterm=NONE
  hi CursorColumn ctermfg=NONE ctermbg=NONE cterm=underline
  hi CursorLine ctermfg=NONE ctermbg=NONE cterm=underline
  hi CursorLineNr ctermfg=darkyellow ctermbg=NONE cterm=bold
  hi DiffAdd ctermfg=white ctermbg=darkgreen cterm=NONE
  hi DiffChange ctermfg=white ctermbg=darkblue cterm=NONE
  hi DiffDelete ctermfg=white ctermbg=darkmagenta cterm=NONE
  hi DiffText ctermfg=black ctermbg=grey cterm=NONE
  hi Directory ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi Error ctermfg=darkred ctermbg=grey cterm=reverse
  hi FoldColumn ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Folded ctermfg=darkblue ctermbg=NONE cterm=bold,reverse
  hi Identifier ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi Ignore ctermfg=NONE ctermbg=NONE cterm=NONE
  hi IncSearch ctermfg=grey ctermbg=darkblue cterm=reverse
  hi LineNr ctermfg=green ctermbg=NONE cterm=bold
  hi MatchParen ctermfg=NONE ctermbg=NONE cterm=reverse
  hi ModeMsg ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi MoreMsg ctermfg=darkgreen ctermbg=NONE cterm=NONE
  hi NonText ctermfg=blue ctermbg=NONE cterm=NONE
  hi Pmenu ctermfg=grey ctermbg=blue cterm=NONE
  hi PmenuMatch ctermfg=grey ctermbg=blue cterm=bold
  hi PmenuMatchSel ctermfg=blue ctermbg=grey cterm=bold
  hi PmenuSbar ctermfg=NONE ctermbg=NONE cterm=NONE
  hi PmenuSel ctermfg=blue ctermbg=grey cterm=NONE
  hi PmenuThumb ctermfg=NONE ctermbg=grey cterm=NONE
  hi PreProc ctermfg=darkmagenta ctermbg=NONE cterm=bold
  hi Question ctermfg=darkgreen ctermbg=NONE cterm=bold
  hi QuickFixLine ctermfg=grey ctermbg=darkmagenta cterm=NONE
  hi Search ctermfg=darkcyan ctermbg=blue cterm=NONE
  hi SignColumn ctermfg=grey ctermbg=NONE cterm=NONE
  hi Special ctermfg=darkyellow ctermbg=NONE cterm=NONE
  hi SpecialKey ctermfg=darkcyan ctermbg=NONE cterm=NONE
  hi SpellBad ctermfg=darkred ctermbg=darkyellow cterm=reverse
  hi SpellCap ctermfg=darkgreen ctermbg=NONE cterm=reverse
  hi SpellLocal ctermfg=darkcyan ctermbg=NONE cterm=reverse
  hi SpellRare ctermfg=darkmagenta ctermbg=darkyellow cterm=reverse
  hi Statement ctermfg=darkyellow ctermbg=NONE cterm=bold
  hi StatusLine ctermfg=darkblue ctermbg=grey cterm=bold,reverse
  hi StatusLineNC ctermfg=grey ctermbg=black cterm=reverse
  hi TabLine ctermfg=grey ctermbg=black cterm=reverse
  hi TabLineSel ctermfg=darkblue ctermbg=grey cterm=bold,reverse
  hi Title ctermfg=darkmagenta ctermbg=NONE cterm=NONE
  hi TitleBar ctermfg=grey ctermbg=black cterm=NONE
  hi TitleBarNC ctermfg=darkgrey ctermbg=black cterm=NONE
  hi Todo ctermfg=NONE ctermbg=NONE cterm=reverse
  hi ToolbarButton ctermfg=darkblue ctermbg=grey cterm=bold,reverse
  hi ToolbarLine ctermfg=NONE ctermbg=NONE cterm=NONE
  hi Type ctermfg=darkgreen ctermbg=NONE cterm=NONE
  hi Underlined ctermfg=NONE ctermbg=NONE cterm=underline
  hi VertSplit ctermfg=grey ctermbg=black cterm=reverse
  hi Visual ctermfg=blue ctermbg=grey cterm=reverse
  hi VisualNOS ctermfg=blue ctermbg=grey cterm=reverse,underline
  hi WarningMsg ctermfg=darkred ctermbg=NONE cterm=NONE
  hi WildMenu ctermfg=yellow ctermbg=black cterm=NONE
  hi debugBreakpoint ctermfg=darkgreen ctermbg=darkblue cterm=reverse
  hi debugPC ctermfg=darkcyan ctermbg=darkblue cterm=reverse
  finish
endif

if s:t_Co >= 0
  hi CurSearch term=reverse
  hi CursorIM term=NONE
  hi CursorLineFold term=underline
  hi CursorLineSign term=underline
  hi EndOfBuffer term=NONE
  hi ErrorMsg term=bold,reverse
  hi Float term=NONE
  hi Function term=NONE
  hi Number term=NONE
  hi StatusLineTerm term=bold,reverse
  hi StatusLineTermNC term=bold,underline
  hi TabLineFill term=NONE
  hi Terminal term=NONE
  finish
endif

" vim: et ts=8 sw=2 sts=2
