module type S = sig
(*

type !'a t = 'a Stack.t

(*
type 'a t = 'a Stack.t
*)

*)

(*
type 'a t
*)


type !'a t = 'a Stack.t

(*
type 'a t = 'a Stack.t
*)




(** @since 5.1.0: type !'a t
@since 3.07.0: type !'a t
 *)

exception Empty 
(** Alias for {!Stack.Empty} *)

val drop : 'a t -> unit
(** @since 5.1.0: val drop : 'a t -> unit *)

(*
val to_seq : 'a t -> 'a Seq.t
*)

(*
val to_seq : 'a t -> 'a Stdcompat__seq.t
*)


val to_seq : 'a t -> 'a Seq.t

(*
val to_seq : 'a t -> 'a Stdcompat__seq.t
*)




(** @since 5.1.0: val to_seq : 'a t -> 'a Seq.t
@since 4.07.0: val to_seq : 'a t -> 'a Seq.t
 *)

(*
val add_seq : 'a t -> 'a Seq.t -> unit
*)

(*
val add_seq : 'a t -> 'a Stdcompat__seq.t -> unit
*)


val add_seq : 'a t -> 'a Seq.t -> unit

(*
val add_seq : 'a t -> 'a Stdcompat__seq.t -> unit
*)




(** @since 5.1.0: val add_seq : 'a t -> 'a Seq.t -> unit
@since 4.07.0: val add_seq : 'a t -> 'a Seq.t -> unit
 *)

(*
val of_seq : 'a Seq.t -> 'a t
*)

(*
val of_seq : 'a Stdcompat__seq.t -> 'a t
*)


val of_seq : 'a Seq.t -> 'a t

(*
val of_seq : 'a Stdcompat__seq.t -> 'a t
*)




(** @since 5.1.0: val of_seq : 'a Seq.t -> 'a t
@since 4.07.0: val of_seq : 'a Seq.t -> 'a t
 *)

val pop_opt : 'a t -> 'a option
(** @since 4.08.0: val pop_opt : 'a t -> 'a option *)

val top_opt : 'a t -> 'a option
(** @since 4.08.0: val top_opt : 'a t -> 'a option *)

(*
val fold : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc
*)


val fold : ('b -> 'a -> 'b) -> 'b -> 'a t -> 'b

(*
val fold : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc
*)


(** @since 5.1.0: val fold : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc
@since 4.03.0: val fold : ('b -> 'a -> 'b) -> 'b -> 'a t -> 'b
 *)

val create : unit -> 'a t
(** Alias for {!Stack.create} *)

val push : 'a -> 'a t -> unit
(** Alias for {!Stack.push} *)

val pop : 'a t -> 'a
(** Alias for {!Stack.pop} *)

val top : 'a t -> 'a
(** Alias for {!Stack.top} *)

val clear : 'a t -> unit
(** Alias for {!Stack.clear} *)

val copy : 'a t -> 'a t
(** Alias for {!Stack.copy} *)

val is_empty : 'a t -> bool
(** Alias for {!Stack.is_empty} *)

val length : 'a t -> int
(** Alias for {!Stack.length} *)

val iter : ('a -> unit) -> 'a t -> unit
(** Alias for {!Stack.iter} *)

end
