module type S = sig

type !'a t = 'a Weak.t

(*
type 'a t = 'a Weak.t
*)

(** Alias for {!Weak.t} *)

(*
module type S =
sig type data type t val create : int -> t val clear : t -> unit
val merge : t -> data -> data val add : t -> data -> unit
val remove : t -> data -> unit val find : t -> data -> data
val find_opt : t -> data -> data option val find_all : t -> data -> data list
val mem : t -> data -> bool val iter : (data -> unit) -> t -> unit
val fold : (data -> 'acc -> 'acc) -> t -> 'acc -> 'acc val count : t -> int
val stats : t -> (int * int * int * int * int * int) end
*)


module type S =
sig type data type t val create : int -> t val clear : t -> unit
val merge : t -> data -> data val add : t -> data -> unit
val remove : t -> data -> unit val find : t -> data -> data
val find_opt : t -> data -> data option val find_all : t -> data -> data list
val mem : t -> data -> bool val iter : (data -> unit) -> t -> unit
val fold : (data -> 'a -> 'a) -> t -> 'a -> 'a val count : t -> int
val stats : t -> (int * int * int * int * int * int) end

(*
module type S =
sig type data type t val create : int -> t val clear : t -> unit
val merge : t -> data -> data val add : t -> data -> unit
val remove : t -> data -> unit val find : t -> data -> data
val find_opt : t -> data -> data option val find_all : t -> data -> data list
val mem : t -> data -> bool val iter : (data -> unit) -> t -> unit
val fold : (data -> 'acc -> 'acc) -> t -> 'acc -> 'acc val count : t -> int
val stats : t -> (int * int * int * int * int * int) end
*)


(** @since 5.1.0:
    module type S  =
      sig
        type data
        type t
        val create : int -> t
        val clear : t -> unit
        val merge : t -> data -> data
        val add : t -> data -> unit
        val remove : t -> data -> unit
        val find : t -> data -> data
        val find_opt : t -> data -> data option
        val find_all : t -> data -> data list
        val mem : t -> data -> bool
        val iter : (data -> unit) -> t -> unit
        val fold : (data -> 'acc -> 'acc) -> t -> 'acc -> 'acc
        val count : t -> int
        val stats : t -> (int * int * int * int * int * int)
      end
@since 4.05.0:
module type S  =
  sig
    type data
    type t
    val create : int -> t
    val clear : t -> unit
    val merge : t -> data -> data
    val add : t -> data -> unit
    val remove : t -> data -> unit
    val find : t -> data -> data
    val find_opt : t -> data -> data option
    val find_all : t -> data -> data list
    val mem : t -> data -> bool
    val iter : (data -> unit) -> t -> unit
    val fold : (data -> 'a -> 'a) -> t -> 'a -> 'a
    val count : t -> int
    val stats : t -> (int * int * int * int * int * int)
  end
 *)


module Make = Weak.Make

(*
module Make :
functor (H : Hashtbl.HashedType) ->
sig type data = H.t type t = Weak.Make(H).t val create : int -> t
val clear : t -> unit val merge : t -> data -> data
val add : t -> data -> unit val remove : t -> data -> unit
val find : t -> data -> data val find_opt : t -> data -> data option
val find_all : t -> data -> data list val mem : t -> data -> bool
val iter : (data -> unit) -> t -> unit
val fold : (data -> 'acc -> 'acc) -> t -> 'acc -> 'acc val count : t -> int
val stats : t -> (int * int * int * int * int * int) end
*)
(** @since 4.05.0: module Make = Weak.Make
 *)

val create : int -> 'a t
(** Alias for {!Weak.create} *)

val length : 'a t -> int
(** Alias for {!Weak.length} *)

val set : 'a t -> int -> 'a option -> unit
(** Alias for {!Weak.set} *)

val get : 'a t -> int -> 'a option
(** Alias for {!Weak.get} *)

val get_copy : 'a t -> int -> 'a option
(** Alias for {!Weak.get_copy} *)

val check : 'a t -> int -> bool
(** Alias for {!Weak.check} *)

val fill : 'a t -> int -> int -> 'a option -> unit
(** Alias for {!Weak.fill} *)

val blit : 'a t -> int -> 'a t -> int -> int -> unit
(** Alias for {!Weak.blit} *)

end
