# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _pixeldifferentiator
else:
    import _pixeldifferentiator

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import ooflib.SWIG.common.burn
import ooflib.SWIG.common.statgroups
import ooflib.SWIG.common.cmicrostructure
import ooflib.SWIG.common.coord
import ooflib.SWIG.common.pixelgroup
import ooflib.SWIG.common.pixelattribute
import ooflib.SWIG.common.timestamp
import ooflib.SWIG.image.oofimage
import ooflib.SWIG.common.IO.bitoverlay
import ooflib.SWIG.common.ccolor
import ooflib.SWIG.common.abstractimage
import ooflib.SWIG.common.boolarray
import ooflib.SWIG.common.doublearray
import ooflib.SWIG.common.ooferror
class CColorDifferentiator3(ooflib.SWIG.common.burn.CPixelDifferentiator3):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, arg2, arg3, arg4, arg5):
        _pixeldifferentiator.CColorDifferentiator3_swiginit(self, _pixeldifferentiator.new_CColorDifferentiator3(arg2, arg3, arg4, arg5))
    __swig_destroy__ = _pixeldifferentiator.delete_CColorDifferentiator3

# Register CColorDifferentiator3 in _pixeldifferentiator:
_pixeldifferentiator.CColorDifferentiator3_swigregister(CColorDifferentiator3)
class CColorDifferentiator2(ooflib.SWIG.common.burn.CPixelDifferentiator2):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, arg2, arg3, arg4):
        _pixeldifferentiator.CColorDifferentiator2_swiginit(self, _pixeldifferentiator.new_CColorDifferentiator2(arg2, arg3, arg4))
    __swig_destroy__ = _pixeldifferentiator.delete_CColorDifferentiator2

# Register CColorDifferentiator2 in _pixeldifferentiator:
_pixeldifferentiator.CColorDifferentiator2_swigregister(CColorDifferentiator2)
class ColorPixelDistFactory(ooflib.SWIG.common.statgroups.PixelDistributionFactory):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, arg2, arg3):
        _pixeldifferentiator.ColorPixelDistFactory_swiginit(self, _pixeldifferentiator.new_ColorPixelDistFactory(arg2, arg3))
    __swig_destroy__ = _pixeldifferentiator.delete_ColorPixelDistFactory

# Register ColorPixelDistFactory in _pixeldifferentiator:
_pixeldifferentiator.ColorPixelDistFactory_swigregister(ColorPixelDistFactory)
# -*- python -*-

# This software was produced by NIST, an agency of the U.S. government,
# and by statute is not subject to copyright in the United States.
# Recipients of this software assume all responsibilities associated
# with its operation, modification and maintenance. However, to
# facilitate maintenance we ask that before distributing modified
# versions of this software, you first contact the authors at
# oof_manager@nist.gov.

from ooflib.SWIG.common import burn
from ooflib.SWIG.common import statgroups
from ooflib.common import debug
from ooflib.common import enum
from ooflib.common import registeredclass
from ooflib.common import utils
from ooflib.common.IO import parameter
from ooflib.common.IO import whoville
from ooflib.common.IO import xmlmenudump

class ColorNorm(enum.EnumClass(
    ('L1', 'The sum of the absolute values of the RGB differences.'),
    ('L2',
     'The square root of the sum of the squares of the RGB differences.'))):
    tip="Ways of measuring the difference between two colors."
    discussion=xmlmenudump.loadFile('DISCUSSIONS/image/enum/colornorm.xml')

L1 = ColorNorm('L1')
L2 = ColorNorm('L2')
utils.OOFdefine('ColorNorm', ColorNorm)

#=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=#

class ColorDifferentiator3(burn.PixelDifferentiator):
    def __init__(self, image, local_color_delta, global_color_delta,
                 color_space_norm):
        self.image = image      # path 
        self.local_color_delta = local_color_delta
        self.global_color_delta = global_color_delta
        self.color_space_norm = color_space_norm
        immidge = whoville.getClass('Image')[image]
        burn.PixelDifferentiator.__init__(
            self,
            immidge.getParent(),
            CColorDifferentiator3(immidge.getObject(), local_color_delta,
                                 global_color_delta,
                                 color_space_norm=="L2"))

registeredclass.Registration(
    'Color',
    burn.PixelDifferentiator,
    ColorDifferentiator3,
    ordering=1,
    contiguities=("Nearest neighbor", "Next-nearest neighbor"),
    params=[
        whoville.WhoParameter(
            'image', whoville.getClass('Image'),
            tip="Find grains in this image"),
        parameter.FloatRangeParameter(
            'local_color_delta',
            range=(0, 1, 0.001), value=0.1,
            tip="Maximum difference in neighboring pixel colors across which a burn will extend."),
        parameter.FloatRangeParameter(
            'global_color_delta',
            range=(0, 1, 0.001), value=0.2,
            tip="Difference from initial pixel color beyond which a burn will not spread."),
        enum.EnumParameter(
            'color_space_norm', ColorNorm, value=L1,
            tip="How to compute the difference between two colors in RGB space.")
        ],
    tip="Create pixel groups containing similarly colored contiguous"
    " pixels (as in the Burn method.  All pixels will be grouped."
)

#=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=#

class ColorDifferentiator2(burn.PixelDifferentiator):
    def __init__(self, image, color_delta, color_space_norm):
        self.image = image
        self.color_delta = color_delta
        self.color_space_norm = color_space_norm
        immidge = whoville.getClass('Image')[image]
        burn.PixelDifferentiator.__init__(
            self,
            immidge.getParent(),
            CColorDifferentiator2(immidge.getObject(), color_delta,
                                  color_space_norm=="L2"))

registeredclass.Registration(
    'Color',
    burn.PixelDifferentiator,
    ColorDifferentiator2,
    ordering=1.1,
    contiguities=("Disconnected",),
    params=[
        whoville.WhoParameter(
            'image', whoville.getClass('Image'),
            tip="Group pixels in this image"),
        parameter.FloatRangeParameter(
            'color_delta',
            range=(0, 1, 0.001), value=0.1,
            tip="Maximum difference in color between the initial,"
            " randomly chosen pixel and other pixels in the group."),
        enum.EnumParameter(
            'color_space_norm', ColorNorm, value=L1,
            tip="How to compute the difference between two colors in RGB space."
            )
        ],
    tip="Create pixel groups containing similarly colored pixels,"
    " without regard to location.  All pixels will be grouped."
)

#=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=##=--=#


## TODO: Allow user to specify the color space norm?

class ColorGrouper(statgroups.PixelGrouper):
    def __init__(self, image, sigma0):
        self.image = image
        self.sigma0 = sigma0
        immidge = whoville.getClass('Image')[image]
        statgroups.PixelGrouper.__init__(
            self,
            immidge.getParent(),
            ColorPixelDistFactory(immidge.getObject(), sigma0))

registeredclass.Registration(
    'Color',
    statgroups.PixelGrouper,
    ColorGrouper,
    ordering=1,
    params=[
        whoville.WhoParameter(
            'image', whoville.getClass('Image'),
            tip="Base groups on the colors in this image"),
        parameter.FloatParameter(
            'sigma0', value=0.002,
            tip="Standard deviation in RGB values to assume for initial distributions")
    ],
    tip="Group pixels by examining RGB distributions.",

    discussion="""
    <para> This is used by <xref
    linkend="MenuItem-OOF.PixelGroup.AutoGroup"/> to automatically
    create &pixelgroups; based on pixel color.  Given two pixels, it
    computes the distance between them by treating their RGB values as
    coordinates in a 3D Euclidean space. </para>

    <para> <varname>sigma0</varname> is the initial standard deviation
    assigned to a group containing a single pixel.  It sets the scale
    for how far apart colors have to be in RGB space in order to
    considered to be significantly different.  Using a small
    <varname>sigma0</varname> will lead to many small pixel groups
    with little color variation within each group.  Using a large
    <varname>sigma0</varname> will lead to fewer pixel groups with
    more variation within each group.  </para> """
)











