/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage;

import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import jdk.internal.jimage.BasicImageReader;
import jdk.internal.jimage.ImageStrings;

public class ImageStringsReader
implements ImageStrings {
    public static final int HASH_MULTIPLIER = 16777619;
    public static final int POSITIVE_MASK = Integer.MAX_VALUE;
    private final BasicImageReader reader;

    ImageStringsReader(BasicImageReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    @Override
    public String get(int offset) {
        return this.reader.getString(offset);
    }

    @Override
    public int match(int offset, String string, int stringOffset) {
        return this.reader.match(offset, string, stringOffset);
    }

    @Override
    public int add(String string) {
        throw new InternalError("Can not add strings at runtime");
    }

    public static int hashCode(String s) {
        return ImageStringsReader.hashCode(s, 16777619);
    }

    public static int hashCode(String s, int seed) {
        return ImageStringsReader.unmaskedHashCode(s, seed) & Integer.MAX_VALUE;
    }

    public static int hashCode(String module, String name) {
        return ImageStringsReader.hashCode(module, name, 16777619);
    }

    public static int hashCode(String module, String name, int seed) {
        seed = seed * 16777619 ^ 0x2F;
        seed = ImageStringsReader.unmaskedHashCode(module, seed);
        seed = seed * 16777619 ^ 0x2F;
        seed = ImageStringsReader.unmaskedHashCode(name, seed);
        return seed & Integer.MAX_VALUE;
    }

    public static int unmaskedHashCode(String s, int seed) {
        int slen = s.length();
        byte[] buffer = null;
        for (int i = 0; i < slen; ++i) {
            int uch = s.charAt(i);
            if ((uch & 0xFFFFFF80) != 0) {
                if (buffer == null) {
                    buffer = new byte[8];
                }
                int mask = -64;
                int n = 0;
                do {
                    buffer[n++] = (byte)(0x80 | uch & 0x3F);
                } while (((uch >>= 6) & (mask >>= 1)) != 0);
                buffer[n] = (byte)(mask << 1 | uch);
                do {
                    seed = seed * 16777619 ^ buffer[n--] & 0xFF;
                } while (0 <= n);
                continue;
            }
            if (uch == 0) {
                seed = seed * 16777619 ^ 0xC0;
                seed = seed * 16777619 ^ 0x80;
                continue;
            }
            seed = seed * 16777619 ^ uch;
        }
        return seed;
    }

    static int charsFromMUTF8Length(byte[] bytes, int offset, int count) {
        byte ch;
        int length = 0;
        for (int i = offset; i < offset + count && (ch = bytes[i]) != 0; ++i) {
            if ((ch & 0xC0) == 128) continue;
            ++length;
        }
        return length;
    }

    static void charsFromMUTF8(char[] chars, byte[] bytes, int offset, int count) throws UTFDataFormatException {
        byte ch;
        int j = 0;
        for (int i = offset; i < offset + count && (ch = bytes[i]) != 0; ++i) {
            boolean is_unicode = (ch & 0x80) != 0;
            int uch = ch & 0x7F;
            if (is_unicode) {
                int mask = 64;
                while ((uch & mask) != 0) {
                    if (((ch = bytes[++i]) & 0xC0) != 128) {
                        throw new UTFDataFormatException("bad continuation 0x" + Integer.toHexString(ch));
                    }
                    uch = (uch & ~mask) << 6 | ch & 0x3F;
                    mask <<= 5;
                }
                if ((uch & 0xFFFF) != uch) {
                    throw new UTFDataFormatException("character out of range \\u" + Integer.toHexString(uch));
                }
            }
            chars[j++] = (char)uch;
        }
    }

    public static String stringFromMUTF8(byte[] bytes, int offset, int count) {
        int length = ImageStringsReader.charsFromMUTF8Length(bytes, offset, count);
        char[] chars = new char[length];
        try {
            ImageStringsReader.charsFromMUTF8(chars, bytes, offset, count);
        }
        catch (UTFDataFormatException ex) {
            throw new InternalError("Attempt to convert non modified UTF-8 byte sequence", ex);
        }
        return new String(chars);
    }

    public static String stringFromMUTF8(byte[] bytes) {
        return ImageStringsReader.stringFromMUTF8(bytes, 0, bytes.length);
    }

    private static int charsFromByteBufferLength(ByteBuffer buffer, int offset) {
        int length = 0;
        int limit = buffer.limit();
        boolean asciiOnly = true;
        while (offset < limit) {
            byte ch;
            if ((ch = buffer.get(offset++)) < 0) {
                asciiOnly = false;
            } else if (ch == 0) {
                return asciiOnly ? length : -length;
            }
            if ((ch & 0xC0) == 128) continue;
            ++length;
        }
        throw new InternalError("No terminating zero byte for modified UTF-8 byte sequence");
    }

    private static void charsFromByteBuffer(char[] chars, ByteBuffer buffer, int offset) {
        int j = 0;
        int limit = buffer.limit();
        while (offset < limit) {
            byte ch;
            if ((ch = buffer.get(offset++)) == 0) {
                return;
            }
            boolean is_unicode = (ch & 0x80) != 0;
            int uch = ch & 0x7F;
            if (is_unicode) {
                int mask = 64;
                while ((uch & mask) != 0) {
                    if (((ch = buffer.get(offset++)) & 0xC0) != 128) {
                        throw new InternalError("Bad continuation in modified UTF-8 byte sequence: " + ch);
                    }
                    uch = (uch & ~mask) << 6 | ch & 0x3F;
                    mask <<= 5;
                }
            }
            if ((uch & 0xFFFF) != uch) {
                throw new InternalError("UTF-32 char in modified UTF-8 byte sequence: " + uch);
            }
            chars[j++] = (char)uch;
        }
        throw new InternalError("No terminating zero byte for modified UTF-8 byte sequence");
    }

    public static String stringFromByteBuffer(ByteBuffer buffer) {
        return ImageStringsReader.stringFromByteBuffer(buffer, 0);
    }

    static String stringFromByteBuffer(ByteBuffer buffer, int offset) {
        int length = ImageStringsReader.charsFromByteBufferLength(buffer, offset);
        if (length > 0) {
            byte[] asciiBytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                asciiBytes[i] = buffer.get(offset++);
            }
            return new String(asciiBytes, StandardCharsets.US_ASCII);
        }
        char[] chars = new char[-length];
        ImageStringsReader.charsFromByteBuffer(chars, buffer, offset);
        return new String(chars);
    }

    static int stringFromByteBufferMatches(ByteBuffer buffer, int offset, String string, int stringOffset) {
        int current;
        int limit = buffer.limit();
        int slen = string.length();
        for (current = offset; current < limit; ++current) {
            byte ch = buffer.get(current);
            if (ch <= 0) {
                if (ch != 0) break;
                return current - offset;
            }
            if (slen <= stringOffset || string.charAt(stringOffset) != (char)ch) {
                return -1;
            }
            ++stringOffset;
        }
        int length = -ImageStringsReader.charsFromByteBufferLength(buffer, current);
        char[] chars = new char[length];
        ImageStringsReader.charsFromByteBuffer(chars, buffer, current);
        for (int i = 0; i < length; ++i) {
            if (string.charAt(stringOffset++) == chars[i]) continue;
            return -1;
        }
        return current - offset + length;
    }

    static int mutf8FromStringLength(String s) {
        int length = 0;
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char ch = s.charAt(i);
            int uch = ch & 0xFFFF;
            if ((uch & 0xFFFFFF80) != 0) {
                int mask = -64;
                int n = 0;
                do {
                    ++n;
                } while (((uch >>= 6) & (mask >>= 1)) != 0);
                length += n + 1;
                continue;
            }
            if (uch == 0) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    static void mutf8FromString(byte[] bytes, int offset, String s) {
        int j = offset;
        byte[] buffer = null;
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char ch = s.charAt(i);
            int uch = ch & 0xFFFF;
            if ((uch & 0xFFFFFF80) != 0) {
                if (buffer == null) {
                    buffer = new byte[8];
                }
                int mask = -64;
                int n = 0;
                do {
                    buffer[n++] = (byte)(0x80 | uch & 0x3F);
                } while (((uch >>= 6) & (mask >>= 1)) != 0);
                buffer[n] = (byte)(mask << 1 | uch);
                do {
                    bytes[j++] = buffer[n--];
                } while (0 <= n);
                continue;
            }
            if (uch == 0) {
                bytes[j++] = -64;
                bytes[j++] = -128;
                continue;
            }
            bytes[j++] = (byte)uch;
        }
    }

    public static byte[] mutf8FromString(String string) {
        int length = ImageStringsReader.mutf8FromStringLength(string);
        byte[] bytes = new byte[length];
        ImageStringsReader.mutf8FromString(bytes, 0, string);
        return bytes;
    }
}

