/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.ss;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;

public final class LoadEmbedded {
    private LoadEmbedded() {
    }

    public static void main(String[] args) throws IOException, EncryptedDocumentException, OpenXML4JException, XmlException {
        Workbook wb = WorkbookFactory.create((File)new File(args[0]));
        LoadEmbedded.loadEmbedded(wb);
    }

    public static void loadEmbedded(Workbook wb) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        if (wb instanceof HSSFWorkbook) {
            LoadEmbedded.loadEmbedded((HSSFWorkbook)wb);
        } else if (wb instanceof XSSFWorkbook) {
            LoadEmbedded.loadEmbedded((XSSFWorkbook)wb);
        } else {
            throw new IllegalArgumentException(wb.getClass().getName());
        }
    }

    public static void loadEmbedded(HSSFWorkbook workbook) throws IOException {
        block10: for (HSSFObjectData obj : workbook.getAllEmbeddedObjects()) {
            DirectoryNode dn;
            String oleName;
            switch (oleName = obj.getOLE2ClassName()) {
                case "Worksheet": {
                    dn = (DirectoryNode)obj.getDirectory();
                    HSSFWorkbook embeddedWorkbook = new HSSFWorkbook(dn, false);
                    embeddedWorkbook.close();
                    continue block10;
                }
                case "Document": {
                    dn = (DirectoryNode)obj.getDirectory();
                    HWPFDocument embeddedWordDocument = new HWPFDocument(dn);
                    embeddedWordDocument.close();
                    continue block10;
                }
                case "Presentation": {
                    dn = (DirectoryNode)obj.getDirectory();
                    HSLFSlideShow embeddedSlieShow = new HSLFSlideShow(dn);
                    embeddedSlieShow.close();
                    continue block10;
                }
            }
            if (obj.hasDirectoryEntry()) {
                dn = (DirectoryNode)obj.getDirectory();
                for (Entry entry : dn) {
                }
                continue;
            }
            byte[] byArray = obj.getObjectData();
        }
    }

    public static void loadEmbedded(XSSFWorkbook workbook) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        block46: for (PackagePart pPart : workbook.getAllEmbeddedParts()) {
            String contentType;
            switch (contentType = pPart.getContentType()) {
                case "application/vnd.ms-excel": {
                    HSSFWorkbook embeddedWorkbook;
                    InputStream stream = pPart.getInputStream();
                    try {
                        embeddedWorkbook = new HSSFWorkbook(stream);
                        embeddedWorkbook.close();
                        continue block46;
                    }
                    finally {
                        if (stream == null) continue block46;
                        stream.close();
                        continue block46;
                    }
                }
                case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                    HSSFWorkbook embeddedWorkbook;
                    InputStream stream = pPart.getInputStream();
                    try {
                        embeddedWorkbook = new XSSFWorkbook(stream);
                        embeddedWorkbook.close();
                        continue block46;
                    }
                    finally {
                        if (stream == null) continue block46;
                        stream.close();
                        continue block46;
                    }
                }
                case "application/msword": {
                    HWPFDocument document;
                    InputStream stream = pPart.getInputStream();
                    try {
                        document = new HWPFDocument(stream);
                        document.close();
                        continue block46;
                    }
                    finally {
                        if (stream == null) continue block46;
                        stream.close();
                        continue block46;
                    }
                }
                case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
                    HWPFDocument document;
                    InputStream stream = pPart.getInputStream();
                    try {
                        document = new XWPFDocument(stream);
                        document.close();
                        continue block46;
                    }
                    finally {
                        if (stream == null) continue block46;
                        stream.close();
                        continue block46;
                    }
                }
                case "application/vnd.ms-powerpoint": {
                    HSLFSlideShow slideShow;
                    InputStream stream = pPart.getInputStream();
                    try {
                        slideShow = new HSLFSlideShow(stream);
                        slideShow.close();
                        continue block46;
                    }
                    finally {
                        if (stream == null) continue block46;
                        stream.close();
                        continue block46;
                    }
                }
                case "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
                    HSLFSlideShow slideShow;
                    InputStream stream = pPart.getInputStream();
                    try {
                        slideShow = new XMLSlideShow(stream);
                        slideShow.close();
                        continue block46;
                    }
                    finally {
                        if (stream == null) continue block46;
                        stream.close();
                        continue block46;
                    }
                }
                default: {
                    System.out.println("Unknown Embedded Document: " + contentType);
                    InputStream inputStream = pPart.getInputStream();
                    if (inputStream == null) continue block46;
                    inputStream.close();
                }
            }
        }
    }
}

