# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.4.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.


import collections

from sys import version_info as _version_info
if _version_info < (3, 7, 0):
    raise RuntimeError("Python 3.7 or later required")

from . import _ITKCommonPython


from . import _ITKBridgeNumPyPython



from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or __package__ or "." in __name__:
    from . import _itkPyBufferPython
else:
    import _itkPyBufferPython

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


if _swig_python_version_info[0:2] >= (3, 3):
    import collections.abc
else:
    import collections

import itk.vnl_matrixPython
import itk.stdcomplexPython
import itk.pyBasePython
import itk.vnl_vectorPython
import itk.itkImagePython
import itk.itkPointPython
import itk.itkVectorPython
import itk.itkFixedArrayPython
import itk.vnl_vector_refPython
import itk.itkCovariantVectorPython
import itk.itkImageRegionPython
import itk.ITKCommonBasePython
import itk.itkMatrixPython
import itk.vnl_matrix_fixedPython
import itk.itkSizePython
import itk.itkIndexPython
import itk.itkOffsetPython
import itk.itkSymmetricSecondRankTensorPython
import itk.itkRGBAPixelPython
import itk.itkRGBPixelPython
import itk.itkVectorImagePython
import itk.itkVariableLengthVectorPython


import numpy as np
class NDArrayITKBase(np.ndarray):
  """A numpy array that provides a view on the data associated with an optional itk "base" object."""

  def __new__(cls, input_array, itk_base=None):
      obj = np.asarray(input_array).view(cls)
      obj.itk_base = itk_base
      return obj

  def __array_finalize__(self, obj):
      if obj is None: return
      self.itk_base = getattr(obj, 'itk_base', None)

try:
    from distributed.protocol import dask_serialize, dask_deserialize
    from typing import Dict, List, Tuple
except (ImportError, RuntimeError):
    pass
else:
    @dask_serialize.register(NDArrayITKBase)
    def serialize(ndarray_itk_base: NDArrayITKBase) -> Tuple[Dict, List[bytes]]:
        dumps = dask_serialize.dispatch(np.ndarray)
        return dumps(ndarray_itk_base)

    @dask_deserialize.register(NDArrayITKBase)
    def deserialize(header: Dict, frames: List[bytes]) -> NDArrayITKBase:
        loads = dask_deserialize.dispatch(np.ndarray)
        return NDArrayITKBase(loads(header, frames))

def _get_numpy_pixelid(itk_Image_type) -> np.dtype:
    """Returns a ITK PixelID given a numpy array."""

# This is a Mapping from numpy array types to itk pixel types.
    _np_itk = {"UC":np.dtype(np.uint8),
               "US":np.dtype(np.uint16),
               "UI":np.dtype(np.uint32),
               "UL":np.dtype(np.uint64),
               "ULL":np.dtype(np.uint64),
               "SC":np.dtype(np.int8),
               "SS":np.dtype(np.int16),
               "SI":np.dtype(np.int32),
               "SL":np.dtype(np.int64),
               "SLL":np.dtype(np.int64),
               "F":np.dtype(np.float32),
               "D":np.dtype(np.float64),
               "PF2":np.dtype(np.float32),
               "PF3":np.dtype(np.float32),
                }
    import os
    if os.name == 'nt':
        _np_itk['UL'] = np.dtype(np.uint32)
        _np_itk['SL'] = np.dtype(np.int32)
    try:
        return _np_itk[itk_Image_type]
    except KeyError as e:
        raise e

class itkPyBufferICVD22(object):
    r"""Proxy of C++ itkPyBufferICVD22 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVD22 *

        """
        return _itkPyBufferPython.itkPyBufferICVD22__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVD22_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVD22__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVD22
        __init__(self, arg0) -> itkPyBufferICVD22

        Parameters
        ----------
        arg0: itkPyBufferICVD22 const &

        """
        _itkPyBufferPython.itkPyBufferICVD22_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVD22(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVD22


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVD22._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVD22.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVD22._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVD22._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVD22._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVD22.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVD22 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVD22_swigregister(itkPyBufferICVD22)
class itkPyBufferICVD23(object):
    r"""Proxy of C++ itkPyBufferICVD23 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVD23 *

        """
        return _itkPyBufferPython.itkPyBufferICVD23__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVD23_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVD23__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVD23
        __init__(self, arg0) -> itkPyBufferICVD23

        Parameters
        ----------
        arg0: itkPyBufferICVD23 const &

        """
        _itkPyBufferPython.itkPyBufferICVD23_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVD23(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVD23


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVD23._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVD23.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVD23._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVD23._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVD23._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVD23.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVD23 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVD23_swigregister(itkPyBufferICVD23)
class itkPyBufferICVD32(object):
    r"""Proxy of C++ itkPyBufferICVD32 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVD32 *

        """
        return _itkPyBufferPython.itkPyBufferICVD32__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVD32_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVD32__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVD32
        __init__(self, arg0) -> itkPyBufferICVD32

        Parameters
        ----------
        arg0: itkPyBufferICVD32 const &

        """
        _itkPyBufferPython.itkPyBufferICVD32_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVD32(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVD32


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVD32._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVD32.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVD32._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVD32._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVD32._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVD32.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVD32 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVD32_swigregister(itkPyBufferICVD32)
class itkPyBufferICVD33(object):
    r"""Proxy of C++ itkPyBufferICVD33 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVD33 *

        """
        return _itkPyBufferPython.itkPyBufferICVD33__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVD33_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVD33__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVD33
        __init__(self, arg0) -> itkPyBufferICVD33

        Parameters
        ----------
        arg0: itkPyBufferICVD33 const &

        """
        _itkPyBufferPython.itkPyBufferICVD33_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVD33(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVD33


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVD33._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVD33.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVD33._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVD33._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVD33._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVD33.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVD33 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVD33_swigregister(itkPyBufferICVD33)
class itkPyBufferICVD42(object):
    r"""Proxy of C++ itkPyBufferICVD42 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVD42 *

        """
        return _itkPyBufferPython.itkPyBufferICVD42__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVD42_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVD42__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVD42
        __init__(self, arg0) -> itkPyBufferICVD42

        Parameters
        ----------
        arg0: itkPyBufferICVD42 const &

        """
        _itkPyBufferPython.itkPyBufferICVD42_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVD42(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVD42


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVD42._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVD42.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVD42._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVD42._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVD42._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVD42.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVD42 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVD42_swigregister(itkPyBufferICVD42)
class itkPyBufferICVD43(object):
    r"""Proxy of C++ itkPyBufferICVD43 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVD43 *

        """
        return _itkPyBufferPython.itkPyBufferICVD43__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVD43_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVD43__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVD43
        __init__(self, arg0) -> itkPyBufferICVD43

        Parameters
        ----------
        arg0: itkPyBufferICVD43 const &

        """
        _itkPyBufferPython.itkPyBufferICVD43_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVD43(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVD43


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVD43._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVD43.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVD43._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVD43._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVD43._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVD43.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVD43 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVD43_swigregister(itkPyBufferICVD43)
class itkPyBufferICVF22(object):
    r"""Proxy of C++ itkPyBufferICVF22 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVF22 *

        """
        return _itkPyBufferPython.itkPyBufferICVF22__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVF22_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVF22__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVF22
        __init__(self, arg0) -> itkPyBufferICVF22

        Parameters
        ----------
        arg0: itkPyBufferICVF22 const &

        """
        _itkPyBufferPython.itkPyBufferICVF22_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVF22(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVF22


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVF22._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVF22.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVF22._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVF22._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVF22._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVF22.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVF22 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVF22_swigregister(itkPyBufferICVF22)
class itkPyBufferICVF23(object):
    r"""Proxy of C++ itkPyBufferICVF23 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVF23 *

        """
        return _itkPyBufferPython.itkPyBufferICVF23__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVF23_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVF23__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVF23
        __init__(self, arg0) -> itkPyBufferICVF23

        Parameters
        ----------
        arg0: itkPyBufferICVF23 const &

        """
        _itkPyBufferPython.itkPyBufferICVF23_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVF23(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVF23


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVF23._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVF23.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVF23._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVF23._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVF23._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVF23.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVF23 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVF23_swigregister(itkPyBufferICVF23)
class itkPyBufferICVF32(object):
    r"""Proxy of C++ itkPyBufferICVF32 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVF32 *

        """
        return _itkPyBufferPython.itkPyBufferICVF32__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVF32_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVF32__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVF32
        __init__(self, arg0) -> itkPyBufferICVF32

        Parameters
        ----------
        arg0: itkPyBufferICVF32 const &

        """
        _itkPyBufferPython.itkPyBufferICVF32_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVF32(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVF32


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVF32._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVF32.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVF32._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVF32._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVF32._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVF32.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVF32 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVF32_swigregister(itkPyBufferICVF32)
class itkPyBufferICVF33(object):
    r"""Proxy of C++ itkPyBufferICVF33 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVF33 *

        """
        return _itkPyBufferPython.itkPyBufferICVF33__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVF33_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVF33__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVF33
        __init__(self, arg0) -> itkPyBufferICVF33

        Parameters
        ----------
        arg0: itkPyBufferICVF33 const &

        """
        _itkPyBufferPython.itkPyBufferICVF33_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVF33(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVF33


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVF33._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVF33.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVF33._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVF33._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVF33._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVF33.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVF33 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVF33_swigregister(itkPyBufferICVF33)
class itkPyBufferICVF42(object):
    r"""Proxy of C++ itkPyBufferICVF42 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVF42 *

        """
        return _itkPyBufferPython.itkPyBufferICVF42__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVF42_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVF42__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVF42
        __init__(self, arg0) -> itkPyBufferICVF42

        Parameters
        ----------
        arg0: itkPyBufferICVF42 const &

        """
        _itkPyBufferPython.itkPyBufferICVF42_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVF42(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVF42


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVF42._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVF42.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVF42._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVF42._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVF42._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVF42.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVF42 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVF42_swigregister(itkPyBufferICVF42)
class itkPyBufferICVF43(object):
    r"""Proxy of C++ itkPyBufferICVF43 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageCVF43 *

        """
        return _itkPyBufferPython.itkPyBufferICVF43__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageCVF43_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferICVF43__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferICVF43
        __init__(self, arg0) -> itkPyBufferICVF43

        Parameters
        ----------
        arg0: itkPyBufferICVF43 const &

        """
        _itkPyBufferPython.itkPyBufferICVF43_swiginit(self, _itkPyBufferPython.new_itkPyBufferICVF43(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferICVF43


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferICVF43._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferICVF43.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferICVF43._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferICVF43._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferICVF43._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferICVF43.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferICVF43 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferICVF43_swigregister(itkPyBufferICVF43)
class itkPyBufferID2(object):
    r"""Proxy of C++ itkPyBufferID2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageD2 *

        """
        return _itkPyBufferPython.itkPyBufferID2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageD2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferID2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferID2
        __init__(self, arg0) -> itkPyBufferID2

        Parameters
        ----------
        arg0: itkPyBufferID2 const &

        """
        _itkPyBufferPython.itkPyBufferID2_swiginit(self, _itkPyBufferPython.new_itkPyBufferID2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferID2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferID2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferID2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferID2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferID2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferID2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferID2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferID2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferID2_swigregister(itkPyBufferID2)
class itkPyBufferID3(object):
    r"""Proxy of C++ itkPyBufferID3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageD3 *

        """
        return _itkPyBufferPython.itkPyBufferID3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageD3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferID3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferID3
        __init__(self, arg0) -> itkPyBufferID3

        Parameters
        ----------
        arg0: itkPyBufferID3 const &

        """
        _itkPyBufferPython.itkPyBufferID3_swiginit(self, _itkPyBufferPython.new_itkPyBufferID3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferID3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferID3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferID3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferID3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferID3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferID3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferID3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferID3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferID3_swigregister(itkPyBufferID3)
class itkPyBufferIF2(object):
    r"""Proxy of C++ itkPyBufferIF2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageF2 *

        """
        return _itkPyBufferPython.itkPyBufferIF2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageF2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIF2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIF2
        __init__(self, arg0) -> itkPyBufferIF2

        Parameters
        ----------
        arg0: itkPyBufferIF2 const &

        """
        _itkPyBufferPython.itkPyBufferIF2_swiginit(self, _itkPyBufferPython.new_itkPyBufferIF2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIF2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIF2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIF2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIF2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIF2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIF2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIF2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIF2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIF2_swigregister(itkPyBufferIF2)
class itkPyBufferIF3(object):
    r"""Proxy of C++ itkPyBufferIF3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageF3 *

        """
        return _itkPyBufferPython.itkPyBufferIF3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageF3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIF3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIF3
        __init__(self, arg0) -> itkPyBufferIF3

        Parameters
        ----------
        arg0: itkPyBufferIF3 const &

        """
        _itkPyBufferPython.itkPyBufferIF3_swiginit(self, _itkPyBufferPython.new_itkPyBufferIF3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIF3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIF3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIF3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIF3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIF3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIF3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIF3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIF3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIF3_swigregister(itkPyBufferIF3)
class itkPyBufferIRGBAUC2(object):
    r"""Proxy of C++ itkPyBufferIRGBAUC2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageRGBAUC2 *

        """
        return _itkPyBufferPython.itkPyBufferIRGBAUC2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageRGBAUC2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIRGBAUC2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIRGBAUC2
        __init__(self, arg0) -> itkPyBufferIRGBAUC2

        Parameters
        ----------
        arg0: itkPyBufferIRGBAUC2 const &

        """
        _itkPyBufferPython.itkPyBufferIRGBAUC2_swiginit(self, _itkPyBufferPython.new_itkPyBufferIRGBAUC2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIRGBAUC2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIRGBAUC2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIRGBAUC2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIRGBAUC2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIRGBAUC2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIRGBAUC2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIRGBAUC2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIRGBAUC2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIRGBAUC2_swigregister(itkPyBufferIRGBAUC2)
class itkPyBufferIRGBAUC3(object):
    r"""Proxy of C++ itkPyBufferIRGBAUC3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageRGBAUC3 *

        """
        return _itkPyBufferPython.itkPyBufferIRGBAUC3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageRGBAUC3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIRGBAUC3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIRGBAUC3
        __init__(self, arg0) -> itkPyBufferIRGBAUC3

        Parameters
        ----------
        arg0: itkPyBufferIRGBAUC3 const &

        """
        _itkPyBufferPython.itkPyBufferIRGBAUC3_swiginit(self, _itkPyBufferPython.new_itkPyBufferIRGBAUC3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIRGBAUC3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIRGBAUC3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIRGBAUC3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIRGBAUC3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIRGBAUC3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIRGBAUC3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIRGBAUC3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIRGBAUC3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIRGBAUC3_swigregister(itkPyBufferIRGBAUC3)
class itkPyBufferIRGBUC2(object):
    r"""Proxy of C++ itkPyBufferIRGBUC2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageRGBUC2 *

        """
        return _itkPyBufferPython.itkPyBufferIRGBUC2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageRGBUC2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIRGBUC2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIRGBUC2
        __init__(self, arg0) -> itkPyBufferIRGBUC2

        Parameters
        ----------
        arg0: itkPyBufferIRGBUC2 const &

        """
        _itkPyBufferPython.itkPyBufferIRGBUC2_swiginit(self, _itkPyBufferPython.new_itkPyBufferIRGBUC2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIRGBUC2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIRGBUC2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIRGBUC2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIRGBUC2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIRGBUC2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIRGBUC2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIRGBUC2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIRGBUC2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIRGBUC2_swigregister(itkPyBufferIRGBUC2)
class itkPyBufferIRGBUC3(object):
    r"""Proxy of C++ itkPyBufferIRGBUC3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageRGBUC3 *

        """
        return _itkPyBufferPython.itkPyBufferIRGBUC3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageRGBUC3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIRGBUC3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIRGBUC3
        __init__(self, arg0) -> itkPyBufferIRGBUC3

        Parameters
        ----------
        arg0: itkPyBufferIRGBUC3 const &

        """
        _itkPyBufferPython.itkPyBufferIRGBUC3_swiginit(self, _itkPyBufferPython.new_itkPyBufferIRGBUC3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIRGBUC3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIRGBUC3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIRGBUC3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIRGBUC3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIRGBUC3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIRGBUC3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIRGBUC3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIRGBUC3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIRGBUC3_swigregister(itkPyBufferIRGBUC3)
class itkPyBufferISI2(object):
    r"""Proxy of C++ itkPyBufferISI2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageSI2 *

        """
        return _itkPyBufferPython.itkPyBufferISI2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageSI2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferISI2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferISI2
        __init__(self, arg0) -> itkPyBufferISI2

        Parameters
        ----------
        arg0: itkPyBufferISI2 const &

        """
        _itkPyBufferPython.itkPyBufferISI2_swiginit(self, _itkPyBufferPython.new_itkPyBufferISI2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferISI2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "SI"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferISI2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferISI2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferISI2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferISI2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferISI2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferISI2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferISI2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferISI2_swigregister(itkPyBufferISI2)
class itkPyBufferISI3(object):
    r"""Proxy of C++ itkPyBufferISI3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageSI3 *

        """
        return _itkPyBufferPython.itkPyBufferISI3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageSI3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferISI3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferISI3
        __init__(self, arg0) -> itkPyBufferISI3

        Parameters
        ----------
        arg0: itkPyBufferISI3 const &

        """
        _itkPyBufferPython.itkPyBufferISI3_swiginit(self, _itkPyBufferPython.new_itkPyBufferISI3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferISI3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "SI"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferISI3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferISI3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferISI3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferISI3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferISI3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferISI3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferISI3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferISI3_swigregister(itkPyBufferISI3)
class itkPyBufferISS2(object):
    r"""Proxy of C++ itkPyBufferISS2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageSS2 *

        """
        return _itkPyBufferPython.itkPyBufferISS2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageSS2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferISS2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferISS2
        __init__(self, arg0) -> itkPyBufferISS2

        Parameters
        ----------
        arg0: itkPyBufferISS2 const &

        """
        _itkPyBufferPython.itkPyBufferISS2_swiginit(self, _itkPyBufferPython.new_itkPyBufferISS2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferISS2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "SS"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferISS2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferISS2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferISS2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferISS2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferISS2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferISS2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferISS2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferISS2_swigregister(itkPyBufferISS2)
class itkPyBufferISS3(object):
    r"""Proxy of C++ itkPyBufferISS3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageSS3 *

        """
        return _itkPyBufferPython.itkPyBufferISS3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageSS3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferISS3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferISS3
        __init__(self, arg0) -> itkPyBufferISS3

        Parameters
        ----------
        arg0: itkPyBufferISS3 const &

        """
        _itkPyBufferPython.itkPyBufferISS3_swiginit(self, _itkPyBufferPython.new_itkPyBufferISS3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferISS3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "SS"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferISS3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferISS3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferISS3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferISS3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferISS3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferISS3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferISS3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferISS3_swigregister(itkPyBufferISS3)
class itkPyBufferISSRTD22(object):
    r"""Proxy of C++ itkPyBufferISSRTD22 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageSSRTD22 *

        """
        return _itkPyBufferPython.itkPyBufferISSRTD22__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageSSRTD22_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferISSRTD22__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferISSRTD22
        __init__(self, arg0) -> itkPyBufferISSRTD22

        Parameters
        ----------
        arg0: itkPyBufferISSRTD22 const &

        """
        _itkPyBufferPython.itkPyBufferISSRTD22_swiginit(self, _itkPyBufferPython.new_itkPyBufferISSRTD22(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferISSRTD22


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferISSRTD22._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferISSRTD22.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferISSRTD22._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferISSRTD22._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferISSRTD22._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferISSRTD22.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferISSRTD22 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferISSRTD22_swigregister(itkPyBufferISSRTD22)
class itkPyBufferISSRTD33(object):
    r"""Proxy of C++ itkPyBufferISSRTD33 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageSSRTD33 *

        """
        return _itkPyBufferPython.itkPyBufferISSRTD33__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageSSRTD33_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferISSRTD33__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferISSRTD33
        __init__(self, arg0) -> itkPyBufferISSRTD33

        Parameters
        ----------
        arg0: itkPyBufferISSRTD33 const &

        """
        _itkPyBufferPython.itkPyBufferISSRTD33_swiginit(self, _itkPyBufferPython.new_itkPyBufferISSRTD33(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferISSRTD33


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferISSRTD33._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferISSRTD33.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferISSRTD33._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferISSRTD33._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferISSRTD33._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferISSRTD33.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferISSRTD33 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferISSRTD33_swigregister(itkPyBufferISSRTD33)
class itkPyBufferISSRTF22(object):
    r"""Proxy of C++ itkPyBufferISSRTF22 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageSSRTF22 *

        """
        return _itkPyBufferPython.itkPyBufferISSRTF22__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageSSRTF22_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferISSRTF22__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferISSRTF22
        __init__(self, arg0) -> itkPyBufferISSRTF22

        Parameters
        ----------
        arg0: itkPyBufferISSRTF22 const &

        """
        _itkPyBufferPython.itkPyBufferISSRTF22_swiginit(self, _itkPyBufferPython.new_itkPyBufferISSRTF22(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferISSRTF22


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferISSRTF22._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferISSRTF22.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferISSRTF22._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferISSRTF22._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferISSRTF22._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferISSRTF22.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferISSRTF22 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferISSRTF22_swigregister(itkPyBufferISSRTF22)
class itkPyBufferISSRTF33(object):
    r"""Proxy of C++ itkPyBufferISSRTF33 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageSSRTF33 *

        """
        return _itkPyBufferPython.itkPyBufferISSRTF33__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageSSRTF33_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferISSRTF33__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferISSRTF33
        __init__(self, arg0) -> itkPyBufferISSRTF33

        Parameters
        ----------
        arg0: itkPyBufferISSRTF33 const &

        """
        _itkPyBufferPython.itkPyBufferISSRTF33_swiginit(self, _itkPyBufferPython.new_itkPyBufferISSRTF33(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferISSRTF33


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferISSRTF33._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferISSRTF33.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferISSRTF33._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferISSRTF33._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferISSRTF33._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferISSRTF33.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferISSRTF33 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferISSRTF33_swigregister(itkPyBufferISSRTF33)
class itkPyBufferIUC2(object):
    r"""Proxy of C++ itkPyBufferIUC2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageUC2 *

        """
        return _itkPyBufferPython.itkPyBufferIUC2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageUC2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIUC2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIUC2
        __init__(self, arg0) -> itkPyBufferIUC2

        Parameters
        ----------
        arg0: itkPyBufferIUC2 const &

        """
        _itkPyBufferPython.itkPyBufferIUC2_swiginit(self, _itkPyBufferPython.new_itkPyBufferIUC2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIUC2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIUC2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIUC2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIUC2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIUC2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIUC2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIUC2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIUC2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIUC2_swigregister(itkPyBufferIUC2)
class itkPyBufferIUC3(object):
    r"""Proxy of C++ itkPyBufferIUC3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageUC3 *

        """
        return _itkPyBufferPython.itkPyBufferIUC3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageUC3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIUC3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIUC3
        __init__(self, arg0) -> itkPyBufferIUC3

        Parameters
        ----------
        arg0: itkPyBufferIUC3 const &

        """
        _itkPyBufferPython.itkPyBufferIUC3_swiginit(self, _itkPyBufferPython.new_itkPyBufferIUC3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIUC3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIUC3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIUC3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIUC3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIUC3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIUC3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIUC3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIUC3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIUC3_swigregister(itkPyBufferIUC3)
class itkPyBufferIUI2(object):
    r"""Proxy of C++ itkPyBufferIUI2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageUI2 *

        """
        return _itkPyBufferPython.itkPyBufferIUI2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageUI2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIUI2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIUI2
        __init__(self, arg0) -> itkPyBufferIUI2

        Parameters
        ----------
        arg0: itkPyBufferIUI2 const &

        """
        _itkPyBufferPython.itkPyBufferIUI2_swiginit(self, _itkPyBufferPython.new_itkPyBufferIUI2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIUI2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UI"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIUI2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIUI2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIUI2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIUI2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIUI2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIUI2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIUI2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIUI2_swigregister(itkPyBufferIUI2)
class itkPyBufferIUI3(object):
    r"""Proxy of C++ itkPyBufferIUI3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageUI3 *

        """
        return _itkPyBufferPython.itkPyBufferIUI3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageUI3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIUI3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIUI3
        __init__(self, arg0) -> itkPyBufferIUI3

        Parameters
        ----------
        arg0: itkPyBufferIUI3 const &

        """
        _itkPyBufferPython.itkPyBufferIUI3_swiginit(self, _itkPyBufferPython.new_itkPyBufferIUI3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIUI3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UI"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIUI3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIUI3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIUI3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIUI3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIUI3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIUI3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIUI3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIUI3_swigregister(itkPyBufferIUI3)
class itkPyBufferIUL2(object):
    r"""Proxy of C++ itkPyBufferIUL2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageUL2 *

        """
        return _itkPyBufferPython.itkPyBufferIUL2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageUL2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIUL2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIUL2
        __init__(self, arg0) -> itkPyBufferIUL2

        Parameters
        ----------
        arg0: itkPyBufferIUL2 const &

        """
        _itkPyBufferPython.itkPyBufferIUL2_swiginit(self, _itkPyBufferPython.new_itkPyBufferIUL2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIUL2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIUL2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIUL2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIUL2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIUL2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIUL2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIUL2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIUL2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIUL2_swigregister(itkPyBufferIUL2)
class itkPyBufferIUL3(object):
    r"""Proxy of C++ itkPyBufferIUL3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageUL3 *

        """
        return _itkPyBufferPython.itkPyBufferIUL3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageUL3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIUL3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIUL3
        __init__(self, arg0) -> itkPyBufferIUL3

        Parameters
        ----------
        arg0: itkPyBufferIUL3 const &

        """
        _itkPyBufferPython.itkPyBufferIUL3_swiginit(self, _itkPyBufferPython.new_itkPyBufferIUL3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIUL3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIUL3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIUL3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIUL3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIUL3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIUL3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIUL3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIUL3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIUL3_swigregister(itkPyBufferIUL3)
class itkPyBufferIULL2(object):
    r"""Proxy of C++ itkPyBufferIULL2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageULL2 *

        """
        return _itkPyBufferPython.itkPyBufferIULL2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageULL2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIULL2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIULL2
        __init__(self, arg0) -> itkPyBufferIULL2

        Parameters
        ----------
        arg0: itkPyBufferIULL2 const &

        """
        _itkPyBufferPython.itkPyBufferIULL2_swiginit(self, _itkPyBufferPython.new_itkPyBufferIULL2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIULL2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "ULL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIULL2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIULL2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIULL2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIULL2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIULL2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIULL2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIULL2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIULL2_swigregister(itkPyBufferIULL2)
class itkPyBufferIULL3(object):
    r"""Proxy of C++ itkPyBufferIULL3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageULL3 *

        """
        return _itkPyBufferPython.itkPyBufferIULL3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageULL3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIULL3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIULL3
        __init__(self, arg0) -> itkPyBufferIULL3

        Parameters
        ----------
        arg0: itkPyBufferIULL3 const &

        """
        _itkPyBufferPython.itkPyBufferIULL3_swiginit(self, _itkPyBufferPython.new_itkPyBufferIULL3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIULL3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "ULL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIULL3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIULL3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIULL3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIULL3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIULL3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIULL3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIULL3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIULL3_swigregister(itkPyBufferIULL3)
class itkPyBufferIVD22(object):
    r"""Proxy of C++ itkPyBufferIVD22 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVD22 *

        """
        return _itkPyBufferPython.itkPyBufferIVD22__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVD22_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVD22__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVD22
        __init__(self, arg0) -> itkPyBufferIVD22

        Parameters
        ----------
        arg0: itkPyBufferIVD22 const &

        """
        _itkPyBufferPython.itkPyBufferIVD22_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVD22(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVD22


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVD22._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVD22.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVD22._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVD22._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVD22._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVD22.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVD22 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVD22_swigregister(itkPyBufferIVD22)
class itkPyBufferIVD23(object):
    r"""Proxy of C++ itkPyBufferIVD23 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVD23 *

        """
        return _itkPyBufferPython.itkPyBufferIVD23__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVD23_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVD23__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVD23
        __init__(self, arg0) -> itkPyBufferIVD23

        Parameters
        ----------
        arg0: itkPyBufferIVD23 const &

        """
        _itkPyBufferPython.itkPyBufferIVD23_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVD23(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVD23


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVD23._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVD23.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVD23._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVD23._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVD23._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVD23.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVD23 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVD23_swigregister(itkPyBufferIVD23)
class itkPyBufferIVD32(object):
    r"""Proxy of C++ itkPyBufferIVD32 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVD32 *

        """
        return _itkPyBufferPython.itkPyBufferIVD32__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVD32_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVD32__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVD32
        __init__(self, arg0) -> itkPyBufferIVD32

        Parameters
        ----------
        arg0: itkPyBufferIVD32 const &

        """
        _itkPyBufferPython.itkPyBufferIVD32_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVD32(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVD32


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVD32._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVD32.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVD32._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVD32._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVD32._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVD32.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVD32 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVD32_swigregister(itkPyBufferIVD32)
class itkPyBufferIVD33(object):
    r"""Proxy of C++ itkPyBufferIVD33 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVD33 *

        """
        return _itkPyBufferPython.itkPyBufferIVD33__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVD33_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVD33__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVD33
        __init__(self, arg0) -> itkPyBufferIVD33

        Parameters
        ----------
        arg0: itkPyBufferIVD33 const &

        """
        _itkPyBufferPython.itkPyBufferIVD33_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVD33(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVD33


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVD33._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVD33.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVD33._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVD33._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVD33._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVD33.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVD33 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVD33_swigregister(itkPyBufferIVD33)
class itkPyBufferIVD42(object):
    r"""Proxy of C++ itkPyBufferIVD42 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVD42 *

        """
        return _itkPyBufferPython.itkPyBufferIVD42__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVD42_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVD42__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVD42
        __init__(self, arg0) -> itkPyBufferIVD42

        Parameters
        ----------
        arg0: itkPyBufferIVD42 const &

        """
        _itkPyBufferPython.itkPyBufferIVD42_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVD42(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVD42


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVD42._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVD42.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVD42._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVD42._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVD42._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVD42.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVD42 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVD42_swigregister(itkPyBufferIVD42)
class itkPyBufferIVD43(object):
    r"""Proxy of C++ itkPyBufferIVD43 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVD43 *

        """
        return _itkPyBufferPython.itkPyBufferIVD43__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVD43_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVD43__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVD43
        __init__(self, arg0) -> itkPyBufferIVD43

        Parameters
        ----------
        arg0: itkPyBufferIVD43 const &

        """
        _itkPyBufferPython.itkPyBufferIVD43_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVD43(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVD43


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVD43._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVD43.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVD43._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVD43._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVD43._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVD43.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVD43 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVD43_swigregister(itkPyBufferIVD43)
class itkPyBufferIVF22(object):
    r"""Proxy of C++ itkPyBufferIVF22 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVF22 *

        """
        return _itkPyBufferPython.itkPyBufferIVF22__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVF22_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVF22__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVF22
        __init__(self, arg0) -> itkPyBufferIVF22

        Parameters
        ----------
        arg0: itkPyBufferIVF22 const &

        """
        _itkPyBufferPython.itkPyBufferIVF22_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVF22(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVF22


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVF22._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVF22.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVF22._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVF22._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVF22._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVF22.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVF22 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVF22_swigregister(itkPyBufferIVF22)
class itkPyBufferIVF23(object):
    r"""Proxy of C++ itkPyBufferIVF23 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVF23 *

        """
        return _itkPyBufferPython.itkPyBufferIVF23__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVF23_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVF23__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVF23
        __init__(self, arg0) -> itkPyBufferIVF23

        Parameters
        ----------
        arg0: itkPyBufferIVF23 const &

        """
        _itkPyBufferPython.itkPyBufferIVF23_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVF23(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVF23


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVF23._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVF23.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVF23._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVF23._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVF23._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVF23.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVF23 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVF23_swigregister(itkPyBufferIVF23)
class itkPyBufferIVF32(object):
    r"""Proxy of C++ itkPyBufferIVF32 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVF32 *

        """
        return _itkPyBufferPython.itkPyBufferIVF32__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVF32_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVF32__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVF32
        __init__(self, arg0) -> itkPyBufferIVF32

        Parameters
        ----------
        arg0: itkPyBufferIVF32 const &

        """
        _itkPyBufferPython.itkPyBufferIVF32_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVF32(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVF32


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVF32._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVF32.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVF32._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVF32._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVF32._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVF32.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVF32 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVF32_swigregister(itkPyBufferIVF32)
class itkPyBufferIVF33(object):
    r"""Proxy of C++ itkPyBufferIVF33 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVF33 *

        """
        return _itkPyBufferPython.itkPyBufferIVF33__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVF33_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVF33__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVF33
        __init__(self, arg0) -> itkPyBufferIVF33

        Parameters
        ----------
        arg0: itkPyBufferIVF33 const &

        """
        _itkPyBufferPython.itkPyBufferIVF33_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVF33(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVF33


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVF33._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVF33.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVF33._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVF33._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVF33._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVF33.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVF33 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVF33_swigregister(itkPyBufferIVF33)
class itkPyBufferIVF42(object):
    r"""Proxy of C++ itkPyBufferIVF42 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVF42 *

        """
        return _itkPyBufferPython.itkPyBufferIVF42__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVF42_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVF42__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVF42
        __init__(self, arg0) -> itkPyBufferIVF42

        Parameters
        ----------
        arg0: itkPyBufferIVF42 const &

        """
        _itkPyBufferPython.itkPyBufferIVF42_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVF42(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVF42


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVF42._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVF42.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVF42._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVF42._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVF42._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVF42.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVF42 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVF42_swigregister(itkPyBufferIVF42)
class itkPyBufferIVF43(object):
    r"""Proxy of C++ itkPyBufferIVF43 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkImageVF43 *

        """
        return _itkPyBufferPython.itkPyBufferIVF43__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkImageVF43_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferIVF43__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferIVF43
        __init__(self, arg0) -> itkPyBufferIVF43

        Parameters
        ----------
        arg0: itkPyBufferIVF43 const &

        """
        _itkPyBufferPython.itkPyBufferIVF43_swiginit(self, _itkPyBufferPython.new_itkPyBufferIVF43(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferIVF43


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferIVF43._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferIVF43.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferIVF43._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferIVF43._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferIVF43._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferIVF43.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferIVF43 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferIVF43_swigregister(itkPyBufferIVF43)
class itkPyBufferVIF2(object):
    r"""Proxy of C++ itkPyBufferVIF2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkVectorImageF2 *

        """
        return _itkPyBufferPython.itkPyBufferVIF2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkVectorImageF2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferVIF2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferVIF2
        __init__(self, arg0) -> itkPyBufferVIF2

        Parameters
        ----------
        arg0: itkPyBufferVIF2 const &

        """
        _itkPyBufferPython.itkPyBufferVIF2_swiginit(self, _itkPyBufferPython.new_itkPyBufferVIF2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferVIF2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferVIF2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferVIF2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferVIF2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferVIF2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferVIF2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferVIF2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferVIF2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferVIF2_swigregister(itkPyBufferVIF2)
class itkPyBufferVIF3(object):
    r"""Proxy of C++ itkPyBufferVIF3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkVectorImageF3 *

        """
        return _itkPyBufferPython.itkPyBufferVIF3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkVectorImageF3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferVIF3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferVIF3
        __init__(self, arg0) -> itkPyBufferVIF3

        Parameters
        ----------
        arg0: itkPyBufferVIF3 const &

        """
        _itkPyBufferPython.itkPyBufferVIF3_swiginit(self, _itkPyBufferPython.new_itkPyBufferVIF3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferVIF3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferVIF3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferVIF3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferVIF3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferVIF3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferVIF3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferVIF3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferVIF3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferVIF3_swigregister(itkPyBufferVIF3)
class itkPyBufferVISS2(object):
    r"""Proxy of C++ itkPyBufferVISS2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkVectorImageSS2 *

        """
        return _itkPyBufferPython.itkPyBufferVISS2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkVectorImageSS2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferVISS2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferVISS2
        __init__(self, arg0) -> itkPyBufferVISS2

        Parameters
        ----------
        arg0: itkPyBufferVISS2 const &

        """
        _itkPyBufferPython.itkPyBufferVISS2_swiginit(self, _itkPyBufferPython.new_itkPyBufferVISS2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferVISS2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "SS"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferVISS2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferVISS2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferVISS2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferVISS2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferVISS2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferVISS2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferVISS2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferVISS2_swigregister(itkPyBufferVISS2)
class itkPyBufferVISS3(object):
    r"""Proxy of C++ itkPyBufferVISS3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkVectorImageSS3 *

        """
        return _itkPyBufferPython.itkPyBufferVISS3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkVectorImageSS3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferVISS3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferVISS3
        __init__(self, arg0) -> itkPyBufferVISS3

        Parameters
        ----------
        arg0: itkPyBufferVISS3 const &

        """
        _itkPyBufferPython.itkPyBufferVISS3_swiginit(self, _itkPyBufferPython.new_itkPyBufferVISS3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferVISS3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "SS"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferVISS3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferVISS3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferVISS3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferVISS3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferVISS3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferVISS3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferVISS3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferVISS3_swigregister(itkPyBufferVISS3)
class itkPyBufferVIUC2(object):
    r"""Proxy of C++ itkPyBufferVIUC2 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkVectorImageUC2 *

        """
        return _itkPyBufferPython.itkPyBufferVIUC2__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkVectorImageUC2_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferVIUC2__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferVIUC2
        __init__(self, arg0) -> itkPyBufferVIUC2

        Parameters
        ----------
        arg0: itkPyBufferVIUC2 const &

        """
        _itkPyBufferPython.itkPyBufferVIUC2_swiginit(self, _itkPyBufferPython.new_itkPyBufferVIUC2(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferVIUC2


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferVIUC2._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferVIUC2.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferVIUC2._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferVIUC2._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferVIUC2._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferVIUC2.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferVIUC2 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferVIUC2_swigregister(itkPyBufferVIUC2)
class itkPyBufferVIUC3(object):
    r"""Proxy of C++ itkPyBufferVIUC3 class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromImage(image):
        r"""
        _GetArrayViewFromImage(image) -> PyObject *

        Parameters
        ----------
        image: itkVectorImageUC3 *

        """
        return _itkPyBufferPython.itkPyBufferVIUC3__GetArrayViewFromImage(image)

    @staticmethod
    def _GetImageViewFromArray(arr, shape, numOfComponent):
        r"""
        _GetImageViewFromArray(arr, shape, numOfComponent) -> itkVectorImageUC3_Pointer const

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *
        numOfComponent: PyObject *

        """
        return _itkPyBufferPython.itkPyBufferVIUC3__GetImageViewFromArray(arr, shape, numOfComponent)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyBufferVIUC3
        __init__(self, arg0) -> itkPyBufferVIUC3

        Parameters
        ----------
        arg0: itkPyBufferVIUC3 const &

        """
        _itkPyBufferPython.itkPyBufferVIUC3_swiginit(self, _itkPyBufferPython.new_itkPyBufferVIUC3(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyBufferVIUC3


    def GetArrayViewFromImage(image, keep_axes=False, update=True):
        """Get a NumPy array view of a ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.
        """
        import itk

        if image.GetBufferPointer() is None:
            return None

        if update:
    # Ensure the image regions and image pixel buffer have been updated
    # correctly
            source = image.GetSource()
            if source:
                source.UpdateLargestPossibleRegion()

        itksize = image.GetBufferedRegion().GetSize()
        dim     = len(itksize)
        shape   = [int(itksize[idx]) for idx in range(dim)]

        if image.GetNumberOfComponentsPerPixel() > 1 or isinstance(image, itk.VectorImage):
            shape = [image.GetNumberOfComponentsPerPixel(), ] + shape

        if keep_axes == False:
            shape.reverse()

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyBufferVIUC3._GetArrayViewFromImage(image)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, image)

        return itk_view

    GetArrayViewFromImage = staticmethod(GetArrayViewFromImage)

    def GetArrayFromImage(image, keep_axes=False, update=True):
        """Get a NumPy ndarray from an ITK Image.

        When *keep_axes* is *False*, the NumPy array will have C-order
        indexing. This is the reverse of how indices are specified in ITK,
        i.e. k,j,i versus i,j,k. However C-order indexing is expected by most
        algorithms in NumPy / SciPy.

        This is a deep copy of the image buffer and is completely safe and without potential side effects.
        """
        if image.GetBufferPointer() is None:
            return None

        arrayView = itkPyBufferVIUC3.GetArrayViewFromImage(image, keep_axes, update)

    # perform deep copy of the image buffer
        arr = np.array(arrayView, copy=True)

        return arr


    GetArrayFromImage = staticmethod(GetArrayFromImage)

    def GetImageViewFromArray(ndarr, is_vector=False, need_contiguous=True):
        """Get an ITK Image view of a NumPy array.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.

        By default, a warning is issued if this function is called on a non-contiguous
        array, since a copy is performed and care must be taken to keep a reference
        to the copied array. This warning can be suppressed with need_contiguous=False
        """

        assert ndarr.ndim in (1, 2, 3, 4, 5), \
            "Only arrays of 1, 2, 3, 4 or 5 dimensions are supported."
        if not ndarr.flags['C_CONTIGUOUS'] and not ndarr.flags['F_CONTIGUOUS']:
            ndarr = np.ascontiguousarray(ndarr)
            if need_contiguous:
                import warnings
                msg = """Because the input array was not contiguous, the returned
                image is not a view of the array passed to this function. Instead,
                it is a view of the member "base" of the returned image! If that
                member is ever garbage collected, this view becomes invalid."""
                warnings.warn(msg)

        if is_vector:
            if ndarr.flags['C_CONTIGUOUS']:
                imgview = itkPyBufferVIUC3._GetImageViewFromArray(ndarr, ndarr.shape[-2::-1], ndarr.shape[-1])
            else:
                imgview = itkPyBufferVIUC3._GetImageViewFromArray(ndarr, ndarr.shape[-1:0:-1], ndarr.shape[0])
        else:
            imgview = itkPyBufferVIUC3._GetImageViewFromArray(ndarr, ndarr.shape[::-1], 1)

    # Keep a reference
        imgview._SetBase(ndarr)

        return imgview

    GetImageViewFromArray = staticmethod(GetImageViewFromArray)

    def GetImageFromArray(ndarr, is_vector=False):
        """Get an ITK Image of a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.

        If is_vector is True, then a 3D array will be treated as a 2D vector image,
        otherwise it will be treated as a 3D image.

        If the array uses Fortran-order indexing, i.e. i,j,k, the Image Size
        will have the same dimensions as the array shape. If the array uses
        C-order indexing, i.e. k,j,i, the image Size will have the dimensions
        reversed from the array shape.

        Therefore, since the *np.transpose* operator on a 2D array simply
        inverts the indexing scheme, the Image representation will be the
        same for an array and its transpose. If flipping is desired, see
        *np.reshape*.
        """

    # Create a temporary image view of the array
        imageView = itkPyBufferVIUC3.GetImageViewFromArray(ndarr, is_vector, need_contiguous=False)

    # Duplicate the image to let it manage its own memory buffer
        import itk
        duplicator = itk.ImageDuplicator.New(imageView)
        duplicator.Update()
        return duplicator.GetOutput()

    GetImageFromArray = staticmethod(GetImageFromArray)



# Register itkPyBufferVIUC3 in _itkPyBufferPython:
_itkPyBufferPython.itkPyBufferVIUC3_swigregister(itkPyBufferVIUC3)
class itkPyVnlD(object):
    r"""Proxy of C++ itkPyVnlD class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorD *

        """
        return _itkPyBufferPython.itkPyVnlD__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorD

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlD__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixD *

        """
        return _itkPyBufferPython.itkPyVnlD__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixD

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlD__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlD
        __init__(self, arg0) -> itkPyVnlD

        Parameters
        ----------
        arg0: itkPyVnlD const &

        """
        _itkPyBufferPython.itkPyVnlD_swiginit(self, _itkPyBufferPython.new_itkPyVnlD(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlD


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlD._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlD.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlD._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "D"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlD._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlD.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlD._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlD in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlD_swigregister(itkPyVnlD)
class itkPyVnlF(object):
    r"""Proxy of C++ itkPyVnlF class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorF *

        """
        return _itkPyBufferPython.itkPyVnlF__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorF

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlF__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixF *

        """
        return _itkPyBufferPython.itkPyVnlF__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixF

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlF__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlF
        __init__(self, arg0) -> itkPyVnlF

        Parameters
        ----------
        arg0: itkPyVnlF const &

        """
        _itkPyBufferPython.itkPyVnlF_swiginit(self, _itkPyBufferPython.new_itkPyVnlF(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlF


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlF._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlF.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlF._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "F"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlF._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlF.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlF._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlF in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlF_swigregister(itkPyVnlF)
class itkPyVnlSC(object):
    r"""Proxy of C++ itkPyVnlSC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorSC *

        """
        return _itkPyBufferPython.itkPyVnlSC__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorSC

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSC__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixSC *

        """
        return _itkPyBufferPython.itkPyVnlSC__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixSC

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSC__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlSC
        __init__(self, arg0) -> itkPyVnlSC

        Parameters
        ----------
        arg0: itkPyVnlSC const &

        """
        _itkPyBufferPython.itkPyVnlSC_swiginit(self, _itkPyBufferPython.new_itkPyVnlSC(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlSC


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "SC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSC._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSC.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlSC._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "SC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSC._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSC.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlSC._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlSC in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlSC_swigregister(itkPyVnlSC)
class itkPyVnlSI(object):
    r"""Proxy of C++ itkPyVnlSI class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorSI *

        """
        return _itkPyBufferPython.itkPyVnlSI__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorSI

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSI__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixSI *

        """
        return _itkPyBufferPython.itkPyVnlSI__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixSI

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSI__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlSI
        __init__(self, arg0) -> itkPyVnlSI

        Parameters
        ----------
        arg0: itkPyVnlSI const &

        """
        _itkPyBufferPython.itkPyVnlSI_swiginit(self, _itkPyBufferPython.new_itkPyVnlSI(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlSI


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "SI"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSI._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSI.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlSI._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "SI"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSI._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSI.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlSI._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlSI in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlSI_swigregister(itkPyVnlSI)
class itkPyVnlSL(object):
    r"""Proxy of C++ itkPyVnlSL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorSL *

        """
        return _itkPyBufferPython.itkPyVnlSL__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorSL

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSL__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixSL *

        """
        return _itkPyBufferPython.itkPyVnlSL__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixSL

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSL__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlSL
        __init__(self, arg0) -> itkPyVnlSL

        Parameters
        ----------
        arg0: itkPyVnlSL const &

        """
        _itkPyBufferPython.itkPyVnlSL_swiginit(self, _itkPyBufferPython.new_itkPyVnlSL(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlSL


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "SL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSL._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSL.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlSL._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "SL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSL._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSL.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlSL._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlSL in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlSL_swigregister(itkPyVnlSL)
class itkPyVnlSLL(object):
    r"""Proxy of C++ itkPyVnlSLL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorSLL *

        """
        return _itkPyBufferPython.itkPyVnlSLL__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorSLL

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSLL__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixSLL *

        """
        return _itkPyBufferPython.itkPyVnlSLL__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixSLL

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSLL__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlSLL
        __init__(self, arg0) -> itkPyVnlSLL

        Parameters
        ----------
        arg0: itkPyVnlSLL const &

        """
        _itkPyBufferPython.itkPyVnlSLL_swiginit(self, _itkPyBufferPython.new_itkPyVnlSLL(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlSLL


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "SLL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSLL._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSLL.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlSLL._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "SLL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSLL._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSLL.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlSLL._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlSLL in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlSLL_swigregister(itkPyVnlSLL)
class itkPyVnlSS(object):
    r"""Proxy of C++ itkPyVnlSS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorSS *

        """
        return _itkPyBufferPython.itkPyVnlSS__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorSS

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSS__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixSS *

        """
        return _itkPyBufferPython.itkPyVnlSS__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixSS

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlSS__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlSS
        __init__(self, arg0) -> itkPyVnlSS

        Parameters
        ----------
        arg0: itkPyVnlSS const &

        """
        _itkPyBufferPython.itkPyVnlSS_swiginit(self, _itkPyBufferPython.new_itkPyVnlSS(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlSS


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "SS"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSS._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSS.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlSS._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "SS"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlSS._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlSS.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlSS._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlSS in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlSS_swigregister(itkPyVnlSS)
class itkPyVnlUC(object):
    r"""Proxy of C++ itkPyVnlUC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorUC *

        """
        return _itkPyBufferPython.itkPyVnlUC__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorUC

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlUC__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixUC *

        """
        return _itkPyBufferPython.itkPyVnlUC__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixUC

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlUC__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlUC
        __init__(self, arg0) -> itkPyVnlUC

        Parameters
        ----------
        arg0: itkPyVnlUC const &

        """
        _itkPyBufferPython.itkPyVnlUC_swiginit(self, _itkPyBufferPython.new_itkPyVnlUC(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlUC


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlUC._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlUC.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlUC._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "UC"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlUC._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlUC.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlUC._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlUC in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlUC_swigregister(itkPyVnlUC)
class itkPyVnlUI(object):
    r"""Proxy of C++ itkPyVnlUI class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorUI *

        """
        return _itkPyBufferPython.itkPyVnlUI__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorUI

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlUI__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixUI *

        """
        return _itkPyBufferPython.itkPyVnlUI__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixUI

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlUI__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlUI
        __init__(self, arg0) -> itkPyVnlUI

        Parameters
        ----------
        arg0: itkPyVnlUI const &

        """
        _itkPyBufferPython.itkPyVnlUI_swiginit(self, _itkPyBufferPython.new_itkPyVnlUI(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlUI


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "UI"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlUI._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlUI.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlUI._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "UI"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlUI._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlUI.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlUI._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlUI in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlUI_swigregister(itkPyVnlUI)
class itkPyVnlUL(object):
    r"""Proxy of C++ itkPyVnlUL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorUL *

        """
        return _itkPyBufferPython.itkPyVnlUL__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorUL

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlUL__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixUL *

        """
        return _itkPyBufferPython.itkPyVnlUL__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixUL

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlUL__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlUL
        __init__(self, arg0) -> itkPyVnlUL

        Parameters
        ----------
        arg0: itkPyVnlUL const &

        """
        _itkPyBufferPython.itkPyVnlUL_swiginit(self, _itkPyBufferPython.new_itkPyVnlUL(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlUL


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "UL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlUL._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlUL.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlUL._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "UL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlUL._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlUL.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlUL._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlUL in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlUL_swigregister(itkPyVnlUL)
class itkPyVnlULL(object):
    r"""Proxy of C++ itkPyVnlULL class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorULL *

        """
        return _itkPyBufferPython.itkPyVnlULL__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorULL

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlULL__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixULL *

        """
        return _itkPyBufferPython.itkPyVnlULL__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixULL

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlULL__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlULL
        __init__(self, arg0) -> itkPyVnlULL

        Parameters
        ----------
        arg0: itkPyVnlULL const &

        """
        _itkPyBufferPython.itkPyVnlULL_swiginit(self, _itkPyBufferPython.new_itkPyVnlULL(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlULL


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "ULL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlULL._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlULL.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlULL._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "ULL"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlULL._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlULL.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlULL._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlULL in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlULL_swigregister(itkPyVnlULL)
class itkPyVnlUS(object):
    r"""Proxy of C++ itkPyVnlUS class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def _GetArrayViewFromVnlVector(vector):
        r"""
        _GetArrayViewFromVnlVector(vector) -> PyObject *

        Parameters
        ----------
        vector: vnl_vectorUS *

        """
        return _itkPyBufferPython.itkPyVnlUS__GetArrayViewFromVnlVector(vector)

    @staticmethod
    def _GetVnlVectorFromArray(arr, shape):
        r"""
        _GetVnlVectorFromArray(arr, shape) -> vnl_vectorUS

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlUS__GetVnlVectorFromArray(arr, shape)

    @staticmethod
    def _GetArrayViewFromVnlMatrix(matrix):
        r"""
        _GetArrayViewFromVnlMatrix(matrix) -> PyObject *

        Parameters
        ----------
        matrix: vnl_matrixUS *

        """
        return _itkPyBufferPython.itkPyVnlUS__GetArrayViewFromVnlMatrix(matrix)

    @staticmethod
    def _GetVnlMatrixFromArray(arr, shape):
        r"""
        _GetVnlMatrixFromArray(arr, shape) -> vnl_matrixUS

        Parameters
        ----------
        arr: PyObject *
        shape: PyObject *

        """
        return _itkPyBufferPython.itkPyVnlUS__GetVnlMatrixFromArray(arr, shape)

    def __init__(self, *args):
        r"""
        __init__(self) -> itkPyVnlUS
        __init__(self, arg0) -> itkPyVnlUS

        Parameters
        ----------
        arg0: itkPyVnlUS const &

        """
        _itkPyBufferPython.itkPyVnlUS_swiginit(self, _itkPyBufferPython.new_itkPyVnlUS(*args))
    __swig_destroy__ = _itkPyBufferPython.delete_itkPyVnlUS


    def GetArrayViewFromVnlVector(vnl_vector):
        """Get a NumPy array view of a VNL vector."""

        itksize = vnl_vector.size()
        shape   = [itksize]

        pixelType     = "US"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlUS._GetArrayViewFromVnlVector(vnl_vector)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)
        itk_view = NDArrayITKBase(ndarr_view, vnl_vector)

        return itk_view

    GetArrayViewFromVnlVector = staticmethod(GetArrayViewFromVnlVector)

    def GetArrayFromVnlVector(vnl_vector):
        """Get a NumPy ndarray from VNL Vector.

        This is a deep copy of the VNL vector and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlUS.GetArrayViewFromVnlVector(vnl_vector)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlVector = staticmethod(GetArrayFromVnlVector)

    def GetVnlVectorFromArray(ndarr):
        """Get a VNL vector from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects.  It is not possible to have a view of a numpy array in a VNL vector since
        there is no VNL vector constructor that allows sharing data.
        """

        assert ndarr.ndim == 1 , \
            "Only arrays of 1 dimension are supported."

        ndarr = np.ascontiguousarray(ndarr)
        vec = itkPyVnlUS._GetVnlVectorFromArray( ndarr, ndarr.shape)

        return vec

    GetVnlVectorFromArray = staticmethod(GetVnlVectorFromArray)

    def GetArrayViewFromVnlMatrix(vnl_matrix):
        """Get a NumPy array view of a VNL matrix."""

        cols = vnl_matrix.columns()
        rows = vnl_matrix.rows()
        dim     = 2
        shape   = [rows,cols]

        pixelType     = "US"
        numpy_dtype = _get_numpy_pixelid(pixelType)
        memview       = itkPyVnlUS._GetArrayViewFromVnlMatrix(vnl_matrix)
        ndarr_view  = np.asarray(memview).view(dtype = numpy_dtype).reshape(shape).view(np.ndarray)

        itk_view = NDArrayITKBase(ndarr_view, vnl_matrix)

        return itk_view

    GetArrayViewFromVnlMatrix = staticmethod(GetArrayViewFromVnlMatrix)

    def GetArrayFromVnlMatrix(vnl_matrix):
        """Get a NumPy ndarray from VNL matrix.

        This is a deep copy of the VNL matrix and is completely safe and without potential side effects.
        """

        arrayView = itkPyVnlUS.GetArrayViewFromVnlMatrix(vnl_matrix)

    # perform deep copy of the buffer
        return np.array(arrayView, copy=True)

    GetArrayFromVnlMatrix = staticmethod(GetArrayFromVnlMatrix)


    def GetVnlMatrixFromArray(ndarr):
        """Get a VNL Matrix from a NumPy array.

        This is a deep copy of the NumPy array buffer and is completely safe without potential
        side effects. It is not possible to have a view of a numpy array in a VNL matrix since there is no
        VNL matrix constructor that allows sharing data.
        """

        assert ndarr.ndim == 2 , \
            "Only arrays of 2 dimensions are supported."

        ndarr = np.ascontiguousarray(ndarr)
        mat = itkPyVnlUS._GetVnlMatrixFromArray( ndarr, ndarr.shape)

        return mat

    GetVnlMatrixFromArray = staticmethod(GetVnlMatrixFromArray)



# Register itkPyVnlUS in _itkPyBufferPython:
_itkPyBufferPython.itkPyVnlUS_swigregister(itkPyVnlUS)

