from _typeshed import FileDescriptorOrPath
from typing import Final, Literal, Protocol, overload, type_check_only
from xml.etree.ElementTree import Element

@type_check_only
class _Loader(Protocol):
    @overload
    def __call__(self, href: FileDescriptorOrPath, parse: Literal["xml"], encoding: str | None = None) -> Element: ...
    @overload
    def __call__(self, href: FileDescriptorOrPath, parse: Literal["text"], encoding: str | None = None) -> str: ...

XINCLUDE: Final = "{http://www.w3.org/2001/XInclude}"

XINCLUDE_INCLUDE: Final = "{http://www.w3.org/2001/XInclude}include"
XINCLUDE_FALLBACK: Final = "{http://www.w3.org/2001/XInclude}fallback"

DEFAULT_MAX_INCLUSION_DEPTH: Final = 6

class FatalIncludeError(SyntaxError): ...

@overload
def default_loader(href: FileDescriptorOrPath, parse: Literal["xml"], encoding: str | None = None) -> Element: ...
@overload
def default_loader(href: FileDescriptorOrPath, parse: Literal["text"], encoding: str | None = None) -> str: ...
def include(elem: Element, loader: _Loader | None = None, base_url: str | None = None, max_depth: int | None = 6) -> None: ...

class LimitedRecursiveIncludeError(FatalIncludeError): ...
