/**
 * MapLibre GL JS
 * @license 3-Clause BSD. Full text of license: https://github.com/maplibre/maplibre-gl-js/blob/v5.13.0/LICENSE.txt
 */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.maplibregl = factory());
})(this, (function () { 'use strict';

/* eslint-disable */

var maplibregl = {};
var modules = {};
function define(moduleName, _dependencies, moduleFactory) {
    modules[moduleName] = moduleFactory;

    // to get the list of modules see generated dist/maplibre-gl-dev.js file (look for `define(` calls)
    if (moduleName !== 'index') {
        return;
    }

    // we assume that when an index module is initializing then other modules are loaded already
    var workerBundleString = 'var sharedModule = {}; (' + modules.shared + ')(sharedModule); (' + modules.worker + ')(sharedModule);'

    var sharedModule = {};
    // the order of arguments of a module factory depends on rollup (it decides who is whose dependency)
    // to check the correct order, see dist/maplibre-gl-dev.js file (look for `define(` calls)
    // we assume that for our 3 chunks it will generate 3 modules and their order is predefined like the following
    modules.shared(sharedModule);
    modules.index(maplibregl, sharedModule);

    if (typeof window !== 'undefined') {
        maplibregl.setWorkerUrl(window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' })));
    }

    return maplibregl;
};



define("shared",["exports"],(function(e){"use strict";function t(e,t,r,n){return new(r||(r=Promise))((function(i,s){function o(e){try{l(n.next(e));}catch(e){s(e);}}function a(e){try{l(n.throw(e));}catch(e){s(e);}}function l(e){var t;e.done?i(e.value):(t=e.value,t instanceof r?t:new r((function(e){e(t);}))).then(o,a);}l((n=n.apply(e,t||[])).next());}))}function r(e,t){this.x=e,this.y=t;}function n(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var i,s;"function"==typeof SuppressedError&&SuppressedError,r.prototype={clone(){return new r(this.x,this.y)},add(e){return this.clone()._add(e)},sub(e){return this.clone()._sub(e)},multByPoint(e){return this.clone()._multByPoint(e)},divByPoint(e){return this.clone()._divByPoint(e)},mult(e){return this.clone()._mult(e)},div(e){return this.clone()._div(e)},rotate(e){return this.clone()._rotate(e)},rotateAround(e,t){return this.clone()._rotateAround(e,t)},matMult(e){return this.clone()._matMult(e)},unit(){return this.clone()._unit()},perp(){return this.clone()._perp()},round(){return this.clone()._round()},mag(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals(e){return this.x===e.x&&this.y===e.y},dist(e){return Math.sqrt(this.distSqr(e))},distSqr(e){const t=e.x-this.x,r=e.y-this.y;return t*t+r*r},angle(){return Math.atan2(this.y,this.x)},angleTo(e){return Math.atan2(this.y-e.y,this.x-e.x)},angleWith(e){return this.angleWithSep(e.x,e.y)},angleWithSep(e,t){return Math.atan2(this.x*t-this.y*e,this.x*e+this.y*t)},_matMult(e){const t=e[2]*this.x+e[3]*this.y;return this.x=e[0]*this.x+e[1]*this.y,this.y=t,this},_add(e){return this.x+=e.x,this.y+=e.y,this},_sub(e){return this.x-=e.x,this.y-=e.y,this},_mult(e){return this.x*=e,this.y*=e,this},_div(e){return this.x/=e,this.y/=e,this},_multByPoint(e){return this.x*=e.x,this.y*=e.y,this},_divByPoint(e){return this.x/=e.x,this.y/=e.y,this},_unit(){return this._div(this.mag()),this},_perp(){const e=this.y;return this.y=this.x,this.x=-e,this},_rotate(e){const t=Math.cos(e),r=Math.sin(e),n=r*this.x+t*this.y;return this.x=t*this.x-r*this.y,this.y=n,this},_rotateAround(e,t){const r=Math.cos(e),n=Math.sin(e),i=t.y+n*(this.x-t.x)+r*(this.y-t.y);return this.x=t.x+r*(this.x-t.x)-n*(this.y-t.y),this.y=i,this},_round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},constructor:r},r.convert=function(e){if(e instanceof r)return e;if(Array.isArray(e))return new r(+e[0],+e[1]);if(void 0!==e.x&&void 0!==e.y)return new r(+e.x,+e.y);throw new Error("Expected [x, y] or {x, y} point format")};var o=function(){if(s)return i;function e(e,t,r,n){this.cx=3*e,this.bx=3*(r-e)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*t,this.by=3*(n-t)-this.cy,this.ay=1-this.cy-this.by,this.p1x=e,this.p1y=t,this.p2x=r,this.p2y=n;}return s=1,i=e,e.prototype={sampleCurveX:function(e){return ((this.ax*e+this.bx)*e+this.cx)*e},sampleCurveY:function(e){return ((this.ay*e+this.by)*e+this.cy)*e},sampleCurveDerivativeX:function(e){return (3*this.ax*e+2*this.bx)*e+this.cx},solveCurveX:function(e,t){if(void 0===t&&(t=1e-6),e<0)return 0;if(e>1)return 1;for(var r=e,n=0;n<8;n++){var i=this.sampleCurveX(r)-e;if(Math.abs(i)<t)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var o=0,a=1;for(r=e,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-e)<t));n++)e>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(e,t){return this.sampleCurveY(this.solveCurveX(e,t))}},i}(),a=n(o);let l,u;function c(){return null==l&&(l="undefined"!=typeof OffscreenCanvas&&new OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof createImageBitmap),l}function h(){if(null==u&&(u=!1,c())){const e=5,t=new OffscreenCanvas(e,e).getContext("2d",{willReadFrequently:!0});if(t){for(let r=0;r<e*e;r++){const n=4*r;t.fillStyle=`rgb(${n},${n+1},${n+2})`,t.fillRect(r%e,Math.floor(r/e),1,1);}const r=t.getImageData(0,0,e,e).data;for(let t=0;t<e*e*4;t++)if(t%4!=3&&r[t]!==t){u=!0;break}}}return u||!1}var p=1e-6,f="undefined"!=typeof Float32Array?Float32Array:Array;function d(){var e=new f(9);return f!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[5]=0,e[6]=0,e[7]=0),e[0]=1,e[4]=1,e[8]=1,e}function y(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e}function m(){var e=new f(3);return f!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0),e}function g(e){var t=e[0],r=e[1],n=e[2];return Math.sqrt(t*t+r*r+n*n)}function x(e,t,r){var n=new f(3);return n[0]=e,n[1]=t,n[2]=r,n}function v(e,t,r){return e[0]=t[0]+r[0],e[1]=t[1]+r[1],e[2]=t[2]+r[2],e}function b(e,t,r){return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e}function w(e,t,r){var n=t[0],i=t[1],s=t[2],o=r[0],a=r[1],l=r[2];return e[0]=i*l-s*a,e[1]=s*o-n*l,e[2]=n*a-i*o,e}var _,S=g;function A(e,t,r){var n=t[0],i=t[1],s=t[2],o=t[3];return e[0]=r[0]*n+r[4]*i+r[8]*s+r[12]*o,e[1]=r[1]*n+r[5]*i+r[9]*s+r[13]*o,e[2]=r[2]*n+r[6]*i+r[10]*s+r[14]*o,e[3]=r[3]*n+r[7]*i+r[11]*s+r[15]*o,e}function T(){var e=new f(4);return f!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0),e[3]=1,e}function I(e,t,r,n){var i=arguments.length>4&&void 0!==arguments[4]?arguments[4]:"zyx",s=Math.PI/360;t*=s,n*=s,r*=s;var o=Math.sin(t),a=Math.cos(t),l=Math.sin(r),u=Math.cos(r),c=Math.sin(n),h=Math.cos(n);switch(i){case "xyz":e[0]=o*u*h+a*l*c,e[1]=a*l*h-o*u*c,e[2]=a*u*c+o*l*h,e[3]=a*u*h-o*l*c;break;case "xzy":e[0]=o*u*h-a*l*c,e[1]=a*l*h-o*u*c,e[2]=a*u*c+o*l*h,e[3]=a*u*h+o*l*c;break;case "yxz":e[0]=o*u*h+a*l*c,e[1]=a*l*h-o*u*c,e[2]=a*u*c-o*l*h,e[3]=a*u*h+o*l*c;break;case "yzx":e[0]=o*u*h+a*l*c,e[1]=a*l*h+o*u*c,e[2]=a*u*c-o*l*h,e[3]=a*u*h-o*l*c;break;case "zxy":e[0]=o*u*h-a*l*c,e[1]=a*l*h+o*u*c,e[2]=a*u*c+o*l*h,e[3]=a*u*h-o*l*c;break;case "zyx":e[0]=o*u*h-a*l*c,e[1]=a*l*h+o*u*c,e[2]=a*u*c-o*l*h,e[3]=a*u*h+o*l*c;break;default:throw new Error("Unknown angle order "+i)}return e}function E(){var e=new f(2);return f!=Float32Array&&(e[0]=0,e[1]=0),e}function M(e,t){var r=new f(2);return r[0]=e,r[1]=t,r}m(),_=new f(4),f!=Float32Array&&(_[0]=0,_[1]=0,_[2]=0,_[3]=0),m(),x(1,0,0),x(0,1,0),T(),T(),d(),E();const k=8192;function F(e,t,r){return t*(k/(e.tileSize*Math.pow(2,r-e.tileID.overscaledZ)))}function D(e,t){return (e%t+t)%t}function P(e,t,r){return e*(1-r)+t*r}function B(e){if(e<=0)return 0;if(e>=1)return 1;const t=e*e,r=t*e;return 4*(e<.5?r:3*(e-t)+r-.75)}function z(e,t,r,n){const i=new a(e,t,r,n);return e=>i.solve(e)}const V=z(.25,.1,.25,1);function C(e,t,r){return Math.min(r,Math.max(t,e))}function L(e,t,r){const n=r-t,i=((e-t)%n+n)%n+t;return i===t?r:i}function O(e,...t){for(const r of t)for(const t in r)e[t]=r[t];return e}let R=1;function N(e,t,r){const n={};for(const r in e)n[r]=t.call(this,e[r],r,e);return n}function $(e,t,r){const n={};for(const r in e)t.call(this,e[r],r,e)&&(n[r]=e[r]);return n}function U(e){return Array.isArray(e)?e.map(U):"object"==typeof e&&e?N(e,U):e}const q={};function j(e){q[e]||("undefined"!=typeof console&&console.warn(e),q[e]=!0);}function G(e,t,r){return (r.y-e.y)*(t.x-e.x)>(t.y-e.y)*(r.x-e.x)}function X(e){return "undefined"!=typeof WorkerGlobalScope&&void 0!==e&&e instanceof WorkerGlobalScope}let Y=null;function Z(e){return "undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap}const H="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";function K(e,r,n,i,s){return t(this,void 0,void 0,(function*(){if("undefined"==typeof VideoFrame)throw new Error("VideoFrame not supported");const t=new VideoFrame(e,{timestamp:0});try{const o=null==t?void 0:t.format;if(!o||!o.startsWith("BGR")&&!o.startsWith("RGB"))throw new Error(`Unrecognized format ${o}`);const a=o.startsWith("BGR"),l=new Uint8ClampedArray(i*s*4);if(yield t.copyTo(l,function(e,t,r,n,i){const s=4*Math.max(-t,0),o=(Math.max(0,r)-r)*n*4+s,a=4*n,l=Math.max(0,t),u=Math.max(0,r);return {rect:{x:l,y:u,width:Math.min(e.width,t+n)-l,height:Math.min(e.height,r+i)-u},layout:[{offset:o,stride:a}]}}(e,r,n,i,s)),a)for(let e=0;e<l.length;e+=4){const t=l[e];l[e]=l[e+2],l[e+2]=t;}return l}finally{t.close();}}))}let W,J;function Q(e,t,r,n){return e.addEventListener(t,r,n),{unsubscribe:()=>{e.removeEventListener(t,r,n);}}}function ee(e){return e*Math.PI/180}function te(e){return e/Math.PI*180}const re={touchstart:!0,touchmove:!0,touchmoveWindow:!0,touchend:!0,touchcancel:!0},ne={dblclick:!0,click:!0,mouseover:!0,mouseout:!0,mousedown:!0,mousemove:!0,mousemoveWindow:!0,mouseup:!0,mouseupWindow:!0,contextmenu:!0,wheel:!0},ie="AbortError";function se(){return new Error(ie)}const oe={MAX_PARALLEL_IMAGE_REQUESTS:16,MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:8,MAX_TILE_CACHE_ZOOM_LEVELS:5,REGISTERED_PROTOCOLS:{},WORKER_URL:""};function ae(e){return oe.REGISTERED_PROTOCOLS[e.substring(0,e.indexOf("://"))]}const le="global-dispatcher";class ue extends Error{constructor(e,t,r,n){super(`AJAXError: ${t} (${e}): ${r}`),this.status=e,this.statusText=t,this.url=r,this.body=n;}}const ce=()=>X(self)?self.worker&&self.worker.referrer:("blob:"===window.location.protocol?window.parent:window).location.href,he=function(e,r){if(/:\/\//.test(e.url)&&!/^https?:|^file:/.test(e.url)){const t=ae(e.url);if(t)return t(e,r);if(X(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,targetMapId:le},r)}if(!(/^file:/.test(n=e.url)||/^file:/.test(ce())&&!/^\w+:/.test(n))){if(fetch&&Request&&AbortController&&Object.prototype.hasOwnProperty.call(Request.prototype,"signal"))return function(e,r){return t(this,void 0,void 0,(function*(){const t=new Request(e.url,{method:e.method||"GET",body:e.body,credentials:e.credentials,headers:e.headers,cache:e.cache,referrer:ce(),signal:r.signal});let n,i;"json"!==e.type||t.headers.has("Accept")||t.headers.set("Accept","application/json");try{n=yield fetch(t);}catch(t){throw new ue(0,t.message,e.url,new Blob)}if(!n.ok){const t=yield n.blob();throw new ue(n.status,n.statusText,e.url,t)}i="arrayBuffer"===e.type||"image"===e.type?n.arrayBuffer():"json"===e.type?n.json():n.text();const s=yield i;if(r.signal.aborted)throw se();return {data:s,cacheControl:n.headers.get("Cache-Control"),expires:n.headers.get("Expires")}}))}(e,r);if(X(self)&&self.worker&&self.worker.actor)return self.worker.actor.sendAsync({type:"GR",data:e,mustQueue:!0,targetMapId:le},r)}var n;return function(e,t){return new Promise(((r,n)=>{var i;const s=new XMLHttpRequest;s.open(e.method||"GET",e.url,!0),"arrayBuffer"!==e.type&&"image"!==e.type||(s.responseType="arraybuffer");for(const t in e.headers)s.setRequestHeader(t,e.headers[t]);"json"===e.type&&(s.responseType="text",(null===(i=e.headers)||void 0===i?void 0:i.Accept)||s.setRequestHeader("Accept","application/json")),s.withCredentials="include"===e.credentials,s.onerror=()=>{n(new Error(s.statusText));},s.onload=()=>{if(!t.signal.aborted)if((s.status>=200&&s.status<300||0===s.status)&&null!==s.response){let t=s.response;if("json"===e.type)try{t=JSON.parse(s.response);}catch(e){return void n(e)}r({data:t,cacheControl:s.getResponseHeader("Cache-Control"),expires:s.getResponseHeader("Expires")});}else {const t=new Blob([s.response],{type:s.getResponseHeader("Content-Type")});n(new ue(s.status,s.statusText,e.url,t));}},t.signal.addEventListener("abort",(()=>{s.abort(),n(se());})),s.send(e.body);}))}(e,r)};function pe(e){if(!e||e.indexOf("://")<=0||0===e.indexOf("data:image/")||0===e.indexOf("blob:"))return !0;const t=new URL(e),r=window.location;return t.protocol===r.protocol&&t.host===r.host}function fe(e,t,r){r[e]&&-1!==r[e].indexOf(t)||(r[e]=r[e]||[],r[e].push(t));}function de(e,t,r){if(r&&r[e]){const n=r[e].indexOf(t);-1!==n&&r[e].splice(n,1);}}class ye{constructor(e,t={}){O(this,t),this.type=e;}}class me extends ye{constructor(e,t={}){super("error",O({error:e},t));}}class ge{on(e,t){return this._listeners=this._listeners||{},fe(e,t,this._listeners),{unsubscribe:()=>{this.off(e,t);}}}off(e,t){return de(e,t,this._listeners),de(e,t,this._oneTimeListeners),this}once(e,t){return t?(this._oneTimeListeners=this._oneTimeListeners||{},fe(e,t,this._oneTimeListeners),this):new Promise((t=>this.once(e,t)))}fire(e,t){"string"==typeof e&&(e=new ye(e,t||{}));const r=e.type;if(this.listens(r)){e.target=this;const t=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of t)r.call(this,e);const n=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const t of n)de(r,t,this._oneTimeListeners),t.call(this,e);const i=this._eventedParent;i&&(O(e,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),i.fire(e));}else e instanceof me&&console.error(e.error);return this}listens(e){return this._listeners&&this._listeners[e]&&this._listeners[e].length>0||this._oneTimeListeners&&this._oneTimeListeners[e]&&this._oneTimeListeners[e].length>0||this._eventedParent&&this._eventedParent.listens(e)}setEventedParent(e,t){return this._eventedParent=e,this._eventedParentData=t,this}}var xe={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},centerAltitude:{type:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},roll:{type:"number",default:0,units:"degrees"},state:{type:"state",default:{}},light:{type:"light"},sky:{type:"sky"},projection:{type:"projection"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"sprite"},glyphs:{type:"string"},"font-faces":{type:"array",value:"fontFaces"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},encoding:{type:"enum",values:{mvt:{},mlt:{}},default:"mvt"},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{},custom:{}},default:"mapbox"},redFactor:{type:"number",default:1},blueFactor:{type:"number",default:1},greenFactor:{type:"number",default:1},baseShift:{type:"number",default:0},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{required:!0,type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},"color-relief":{},background:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_color-relief","layout_background"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image",{"!":"icon-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"padding",default:[2],units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},"viewport-glyph":{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-variable-anchor-offset":{type:"variableAnchorOffsetCollection",requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field",{"!":"text-overlap"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-overlap":{type:"enum",values:{never:{},always:{},cooperative:{}},requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_color-relief":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},sky:{"sky-color":{type:"color","property-type":"data-constant",default:"#88C6FC",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-color":{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"fog-ground-blend":{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"horizon-fog-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"sky-horizon-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0},"atmosphere-blend":{type:"number","property-type":"data-constant",default:.8,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number",minimum:0,default:1}},projection:{type:{type:"projectionDefinition",default:"mercator","property-type":"data-constant",transition:!1,expression:{interpolated:!0,parameters:["zoom"]}}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_color-relief","paint_background"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"numberArray",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-altitude":{type:"numberArray",default:45,minimum:0,maximum:90,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"colorArray",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"colorArray",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-method":{type:"enum",values:{standard:{},basic:{},combined:{},igor:{},multidirectional:{}},default:"standard",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},"paint_color-relief":{"color-relief-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"color-relief-color":{type:"color",transition:!1,expression:{interpolated:!0,parameters:["elevation"]},"property-type":"color-ramp"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};const ve=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function be(e,t){const r={};for(const t in e)"ref"!==t&&(r[t]=e[t]);return ve.forEach((e=>{e in t&&(r[e]=t[e]);})),r}function we(e,t){if(Array.isArray(e)){if(!Array.isArray(t)||e.length!==t.length)return !1;for(let r=0;r<e.length;r++)if(!we(e[r],t[r]))return !1;return !0}if("object"==typeof e&&null!==e&&null!==t){if("object"!=typeof t)return !1;if(Object.keys(e).length!==Object.keys(t).length)return !1;for(const r in e)if(!we(e[r],t[r]))return !1;return !0}return e===t}function _e(e,t){e.push(t);}function Se(e,t,r){_e(r,{command:"addSource",args:[e,t[e]]});}function Ae(e,t,r){_e(t,{command:"removeSource",args:[e]}),r[e]=!0;}function Te(e,t,r,n){Ae(e,r,n),Se(e,t,r);}function Ie(e,t,r){let n;for(n in e[r])if(Object.prototype.hasOwnProperty.call(e[r],n)&&"data"!==n&&!we(e[r][n],t[r][n]))return !1;for(n in t[r])if(Object.prototype.hasOwnProperty.call(t[r],n)&&"data"!==n&&!we(e[r][n],t[r][n]))return !1;return !0}function Ee(e,t,r,n,i,s){e=e||{},t=t||{};for(const o in e)Object.prototype.hasOwnProperty.call(e,o)&&(we(e[o],t[o])||r.push({command:s,args:[n,o,t[o],i]}));for(const o in t)Object.prototype.hasOwnProperty.call(t,o)&&!Object.prototype.hasOwnProperty.call(e,o)&&(we(e[o],t[o])||r.push({command:s,args:[n,o,t[o],i]}));}function Me(e){return e.id}function ke(e,t){return e[t.id]=t,e}class Fe{constructor(e,t,r,n){this.message=(e?`${e}: `:"")+r,n&&(this.identifier=n),null!=t&&t.__line__&&(this.line=t.__line__);}}function De(e,...t){for(const r of t)for(const t in r)e[t]=r[t];return e}class Pe extends Error{constructor(e,t){super(t),this.message=t,this.key=e;}}class Be{constructor(e,t=[]){this.parent=e,this.bindings={};for(const[e,r]of t)this.bindings[e]=r;}concat(e){return new Be(this,e)}get(e){if(this.bindings[e])return this.bindings[e];if(this.parent)return this.parent.get(e);throw new Error(`${e} not found in scope.`)}has(e){return !!this.bindings[e]||!!this.parent&&this.parent.has(e)}}const ze={kind:"null"},Ve={kind:"number"},Ce={kind:"string"},Le={kind:"boolean"},Oe={kind:"color"},Re={kind:"projectionDefinition"},Ne={kind:"object"},$e={kind:"value"},Ue={kind:"collator"},qe={kind:"formatted"},je={kind:"padding"},Ge={kind:"colorArray"},Xe={kind:"numberArray"},Ye={kind:"resolvedImage"},Ze={kind:"variableAnchorOffsetCollection"};function He(e,t){return {kind:"array",itemType:e,N:t}}function Ke(e){if("array"===e.kind){const t=Ke(e.itemType);return "number"==typeof e.N?`array<${t}, ${e.N}>`:"value"===e.itemType.kind?"array":`array<${t}>`}return e.kind}const We=[ze,Ve,Ce,Le,Oe,Re,qe,Ne,He($e),je,Xe,Ge,Ye,Ze];function Je(e,t){if("error"===t.kind)return null;if("array"===e.kind){if("array"===t.kind&&(0===t.N&&"value"===t.itemType.kind||!Je(e.itemType,t.itemType))&&("number"!=typeof e.N||e.N===t.N))return null}else {if(e.kind===t.kind)return null;if("value"===e.kind)for(const e of We)if(!Je(e,t))return null}return `Expected ${Ke(e)} but found ${Ke(t)} instead.`}function Qe(e,t){return t.some((t=>t.kind===e.kind))}function et(e,t){return t.some((t=>"null"===t?null===e:"array"===t?Array.isArray(e):"object"===t?e&&!Array.isArray(e)&&"object"==typeof e:t===typeof e))}function tt(e,t){return "array"===e.kind&&"array"===t.kind?e.itemType.kind===t.itemType.kind&&"number"==typeof e.N:e.kind===t.kind}const rt=.96422,nt=.82521,it=4/29,st=6/29,ot=3*st*st,at=st*st*st,lt=Math.PI/180,ut=180/Math.PI;function ct(e){return (e%=360)<0&&(e+=360),e}function ht([e,t,r,n]){let i,s;const o=ft((.2225045*(e=pt(e))+.7168786*(t=pt(t))+.0606169*(r=pt(r)))/1);e===t&&t===r?i=s=o:(i=ft((.4360747*e+.3850649*t+.1430804*r)/rt),s=ft((.0139322*e+.0971045*t+.7141733*r)/nt));const a=116*o-16;return [a<0?0:a,500*(i-o),200*(o-s),n]}function pt(e){return e<=.04045?e/12.92:Math.pow((e+.055)/1.055,2.4)}function ft(e){return e>at?Math.pow(e,1/3):e/ot+it}function dt([e,t,r,n]){let i=(e+16)/116,s=isNaN(t)?i:i+t/500,o=isNaN(r)?i:i-r/200;return i=1*mt(i),s=rt*mt(s),o=nt*mt(o),[yt(3.1338561*s-1.6168667*i-.4906146*o),yt(-.9787684*s+1.9161415*i+.033454*o),yt(.0719453*s-.2289914*i+1.4052427*o),n]}function yt(e){return (e=e<=.00304?12.92*e:1.055*Math.pow(e,1/2.4)-.055)<0?0:e>1?1:e}function mt(e){return e>st?e*e*e:ot*(e-it)}const gt=Object.hasOwn||function(e,t){return Object.prototype.hasOwnProperty.call(e,t)};function xt(e,t){return gt(e,t)?e[t]:void 0}function vt(e){return parseInt(e.padEnd(2,e),16)/255}function bt(e,t){return wt(t?e/100:e,0,1)}function wt(e,t,r){return Math.min(Math.max(t,e),r)}function _t(e){return !e.some(Number.isNaN)}const St={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};function At(e,t,r){return e+r*(t-e)}function Tt(e,t,r){return e.map(((e,n)=>At(e,t[n],r)))}class It{constructor(e,t,r,n=1,i=!0){this.r=e,this.g=t,this.b=r,this.a=n,i||(this.r*=n,this.g*=n,this.b*=n,n||this.overwriteGetter("rgb",[e,t,r,n]));}static parse(e){if(e instanceof It)return e;if("string"!=typeof e)return;const t=function(e){if("transparent"===(e=e.toLowerCase().trim()))return [0,0,0,0];const t=xt(St,e);if(t){const[e,r,n]=t;return [e/255,r/255,n/255,1]}if(e.startsWith("#")&&/^#(?:[0-9a-f]{3,4}|[0-9a-f]{6}|[0-9a-f]{8})$/.test(e)){const t=e.length<6?1:2;let r=1;return [vt(e.slice(r,r+=t)),vt(e.slice(r,r+=t)),vt(e.slice(r,r+=t)),vt(e.slice(r,r+t)||"ff")]}if(e.startsWith("rgb")){const t=e.match(/^rgba?\(\s*([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s+|\s*(,)\s*)([\de.+-]+)(%)?(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(t){const[e,r,n,i,s,o,a,l,u,c,h,p]=t,f=[i||" ",a||" ",c].join("");if("  "===f||"  /"===f||",,"===f||",,,"===f){const e=[n,o,u].join(""),t="%%%"===e?100:""===e?255:0;if(t){const e=[wt(+r/t,0,1),wt(+s/t,0,1),wt(+l/t,0,1),h?bt(+h,p):1];if(_t(e))return e}}return}}const r=e.match(/^hsla?\(\s*([\de.+-]+)(?:deg)?(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s+|\s*(,)\s*)([\de.+-]+)%(?:\s*([,\/])\s*([\de.+-]+)(%)?)?\s*\)$/);if(r){const[e,t,n,i,s,o,a,l,u]=r,c=[n||" ",s||" ",a].join("");if("  "===c||"  /"===c||",,"===c||",,,"===c){const e=[+t,wt(+i,0,100),wt(+o,0,100),l?bt(+l,u):1];if(_t(e))return function([e,t,r,n]){function i(n){const i=(n+e/30)%12,s=t*Math.min(r,1-r);return r-s*Math.max(-1,Math.min(i-3,9-i,1))}return e=ct(e),t/=100,r/=100,[i(0),i(8),i(4),n]}(e)}}}(e);return t?new It(...t,!1):void 0}get rgb(){const{r:e,g:t,b:r,a:n}=this,i=n||1/0;return this.overwriteGetter("rgb",[e/i,t/i,r/i,n])}get hcl(){return this.overwriteGetter("hcl",function(e){const[t,r,n,i]=ht(e),s=Math.sqrt(r*r+n*n);return [Math.round(1e4*s)?ct(Math.atan2(n,r)*ut):NaN,s,t,i]}(this.rgb))}get lab(){return this.overwriteGetter("lab",ht(this.rgb))}overwriteGetter(e,t){return Object.defineProperty(this,e,{value:t}),t}toString(){const[e,t,r,n]=this.rgb;return `rgba(${[e,t,r].map((e=>Math.round(255*e))).join(",")},${n})`}static interpolate(e,t,r,n="rgb"){switch(n){case "rgb":{const[n,i,s,o]=Tt(e.rgb,t.rgb,r);return new It(n,i,s,o,!1)}case "hcl":{const[n,i,s,o]=e.hcl,[a,l,u,c]=t.hcl;let h,p;if(isNaN(n)||isNaN(a))isNaN(n)?isNaN(a)?h=NaN:(h=a,1!==s&&0!==s||(p=l)):(h=n,1!==u&&0!==u||(p=i));else {let e=a-n;a>n&&e>180?e-=360:a<n&&n-a>180&&(e+=360),h=n+r*e;}const[f,d,y,m]=function([e,t,r,n]){return e=isNaN(e)?0:e*lt,dt([r,Math.cos(e)*t,Math.sin(e)*t,n])}([h,null!=p?p:At(i,l,r),At(s,u,r),At(o,c,r)]);return new It(f,d,y,m,!1)}case "lab":{const[n,i,s,o]=dt(Tt(e.lab,t.lab,r));return new It(n,i,s,o,!1)}}}}It.black=new It(0,0,0,1),It.white=new It(1,1,1,1),It.transparent=new It(0,0,0,0),It.red=new It(1,0,0,1);class Et{constructor(e,t,r){this.sensitivity=e?t?"variant":"case":t?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(e,t){return this.collator.compare(e,t)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}const Mt=["bottom","center","top"];class kt{constructor(e,t,r,n,i,s){this.text=e,this.image=t,this.scale=r,this.fontStack=n,this.textColor=i,this.verticalAlign=s;}}class Ft{constructor(e){this.sections=e;}static fromString(e){return new Ft([new kt(e,null,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((e=>0!==e.text.length||e.image&&0!==e.image.name.length))}static factory(e){return e instanceof Ft?e:Ft.fromString(e)}toString(){return 0===this.sections.length?"":this.sections.map((e=>e.text)).join("")}}class Dt{constructor(e){this.values=e.slice();}static parse(e){if(e instanceof Dt)return e;if("number"==typeof e)return new Dt([e,e,e,e]);if(Array.isArray(e)&&!(e.length<1||e.length>4)){for(const t of e)if("number"!=typeof t)return;switch(e.length){case 1:e=[e[0],e[0],e[0],e[0]];break;case 2:e=[e[0],e[1],e[0],e[1]];break;case 3:e=[e[0],e[1],e[2],e[1]];}return new Dt(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,r){return new Dt(Tt(e.values,t.values,r))}}class Pt{constructor(e){this.values=e.slice();}static parse(e){if(e instanceof Pt)return e;if("number"==typeof e)return new Pt([e]);if(Array.isArray(e)){for(const t of e)if("number"!=typeof t)return;return new Pt(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,r){return new Pt(Tt(e.values,t.values,r))}}class Bt{constructor(e){this.values=e.slice();}static parse(e){if(e instanceof Bt)return e;if("string"==typeof e){const t=It.parse(e);if(!t)return;return new Bt([t])}if(!Array.isArray(e))return;const t=[];for(const r of e){if("string"!=typeof r)return;const e=It.parse(r);if(!e)return;t.push(e);}return new Bt(t)}toString(){return JSON.stringify(this.values)}static interpolate(e,t,r,n="rgb"){const i=[];if(e.values.length!=t.values.length)throw new Error(`colorArray: Arrays have mismatched length (${e.values.length} vs. ${t.values.length}), cannot interpolate.`);for(let s=0;s<e.values.length;s++)i.push(It.interpolate(e.values[s],t.values[s],r,n));return new Bt(i)}}class zt extends Error{constructor(e){super(e),this.name="RuntimeError";}toJSON(){return this.message}}const Vt=new Set(["center","left","right","top","bottom","top-left","top-right","bottom-left","bottom-right"]);class Ct{constructor(e){this.values=e.slice();}static parse(e){if(e instanceof Ct)return e;if(Array.isArray(e)&&!(e.length<1)&&e.length%2==0){for(let t=0;t<e.length;t+=2){const r=e[t],n=e[t+1];if("string"!=typeof r||!Vt.has(r))return;if(!Array.isArray(n)||2!==n.length||"number"!=typeof n[0]||"number"!=typeof n[1])return}return new Ct(e)}}toString(){return JSON.stringify(this.values)}static interpolate(e,t,r){const n=e.values,i=t.values;if(n.length!==i.length)throw new zt(`Cannot interpolate values of different length. from: ${e.toString()}, to: ${t.toString()}`);const s=[];for(let e=0;e<n.length;e+=2){if(n[e]!==i[e])throw new zt(`Cannot interpolate values containing mismatched anchors. from[${e}]: ${n[e]}, to[${e}]: ${i[e]}`);s.push(n[e]);const[t,o]=n[e+1],[a,l]=i[e+1];s.push([At(t,a,r),At(o,l,r)]);}return new Ct(s)}}class Lt{constructor(e){this.name=e.name,this.available=e.available;}toString(){return this.name}static fromString(e){return e?new Lt({name:e,available:!1}):null}}class Ot{constructor(e,t,r){this.from=e,this.to=t,this.transition=r;}static interpolate(e,t,r){return new Ot(e,t,r)}static parse(e){return e instanceof Ot?e:Array.isArray(e)&&3===e.length&&"string"==typeof e[0]&&"string"==typeof e[1]&&"number"==typeof e[2]?new Ot(e[0],e[1],e[2]):"object"==typeof e&&"string"==typeof e.from&&"string"==typeof e.to&&"number"==typeof e.transition?new Ot(e.from,e.to,e.transition):"string"==typeof e?new Ot(e,e,1):void 0}}function Rt(e,t,r,n){return "number"==typeof e&&e>=0&&e<=255&&"number"==typeof t&&t>=0&&t<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===n||"number"==typeof n&&n>=0&&n<=1?null:`Invalid rgba value [${[e,t,r,n].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof n?[e,t,r,n]:[e,t,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Nt(e){if(null===e||"string"==typeof e||"boolean"==typeof e||"number"==typeof e||e instanceof Ot||e instanceof It||e instanceof Et||e instanceof Ft||e instanceof Dt||e instanceof Pt||e instanceof Bt||e instanceof Ct||e instanceof Lt)return !0;if(Array.isArray(e)){for(const t of e)if(!Nt(t))return !1;return !0}if("object"==typeof e){for(const t in e)if(!Nt(e[t]))return !1;return !0}return !1}function $t(e){if(null===e)return ze;if("string"==typeof e)return Ce;if("boolean"==typeof e)return Le;if("number"==typeof e)return Ve;if(e instanceof It)return Oe;if(e instanceof Ot)return Re;if(e instanceof Et)return Ue;if(e instanceof Ft)return qe;if(e instanceof Dt)return je;if(e instanceof Pt)return Xe;if(e instanceof Bt)return Ge;if(e instanceof Ct)return Ze;if(e instanceof Lt)return Ye;if(Array.isArray(e)){const t=e.length;let r;for(const t of e){const e=$t(t);if(r){if(r===e)continue;r=$e;break}r=e;}return He(r||$e,t)}return Ne}function Ut(e){const t=typeof e;return null===e?"":"string"===t||"number"===t||"boolean"===t?String(e):e instanceof It||e instanceof Ot||e instanceof Ft||e instanceof Dt||e instanceof Pt||e instanceof Bt||e instanceof Ct||e instanceof Lt?e.toString():JSON.stringify(e)}class qt{constructor(e,t){this.type=e,this.value=t;}static parse(e,t){if(2!==e.length)return t.error(`'literal' expression requires exactly one argument, but found ${e.length-1} instead.`);if(!Nt(e[1]))return t.error("invalid value");const r=e[1];let n=$t(r);const i=t.expectedType;return "array"!==n.kind||0!==n.N||!i||"array"!==i.kind||"number"==typeof i.N&&0!==i.N||(n=i),new qt(n,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}}const jt={string:Ce,number:Ve,boolean:Le,object:Ne};class Gt{constructor(e,t){this.type=e,this.args=t;}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");let r,n=1;const i=e[0];if("array"===i){let i,s;if(e.length>2){const r=e[1];if("string"!=typeof r||!(r in jt)||"object"===r)return t.error('The item type argument of "array" must be one of string, number, boolean',1);i=jt[r],n++;}else i=$e;if(e.length>3){if(null!==e[2]&&("number"!=typeof e[2]||e[2]<0||e[2]!==Math.floor(e[2])))return t.error('The length argument to "array" must be a positive integer literal',2);s=e[2],n++;}r=He(i,s);}else {if(!jt[i])throw new Error(`Types doesn't contain name = ${i}`);r=jt[i];}const s=[];for(;n<e.length;n++){const r=t.parse(e[n],n,$e);if(!r)return null;s.push(r);}return new Gt(r,s)}evaluate(e){for(let t=0;t<this.args.length;t++){const r=this.args[t].evaluate(e);if(!Je(this.type,$t(r)))return r;if(t===this.args.length-1)throw new zt(`Expected value to be of type ${Ke(this.type)}, but found ${Ke($t(r))} instead.`)}throw new Error}eachChild(e){this.args.forEach(e);}outputDefined(){return this.args.every((e=>e.outputDefined()))}}const Xt={"to-boolean":Le,"to-color":Oe,"to-number":Ve,"to-string":Ce};class Yt{constructor(e,t){this.type=e,this.args=t;}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const r=e[0];if(!Xt[r])throw new Error(`Can't parse ${r} as it is not part of the known types`);if(("to-boolean"===r||"to-string"===r)&&2!==e.length)return t.error("Expected one argument.");const n=Xt[r],i=[];for(let r=1;r<e.length;r++){const n=t.parse(e[r],r,$e);if(!n)return null;i.push(n);}return new Yt(n,i)}evaluate(e){switch(this.type.kind){case "boolean":return Boolean(this.args[0].evaluate(e));case "color":{let t,r;for(const n of this.args){if(t=n.evaluate(e),r=null,t instanceof It)return t;if("string"==typeof t){const r=e.parseColor(t);if(r)return r}else if(Array.isArray(t)&&(r=t.length<3||t.length>4?`Invalid rgba value ${JSON.stringify(t)}: expected an array containing either three or four numeric values.`:Rt(t[0],t[1],t[2],t[3]),!r))return new It(t[0]/255,t[1]/255,t[2]/255,t[3])}throw new zt(r||`Could not parse color from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case "padding":{let t;for(const r of this.args){t=r.evaluate(e);const n=Dt.parse(t);if(n)return n}throw new zt(`Could not parse padding from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case "numberArray":{let t;for(const r of this.args){t=r.evaluate(e);const n=Pt.parse(t);if(n)return n}throw new zt(`Could not parse numberArray from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case "colorArray":{let t;for(const r of this.args){t=r.evaluate(e);const n=Bt.parse(t);if(n)return n}throw new zt(`Could not parse colorArray from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case "variableAnchorOffsetCollection":{let t;for(const r of this.args){t=r.evaluate(e);const n=Ct.parse(t);if(n)return n}throw new zt(`Could not parse variableAnchorOffsetCollection from value '${"string"==typeof t?t:JSON.stringify(t)}'`)}case "number":{let t=null;for(const r of this.args){if(t=r.evaluate(e),null===t)return 0;const n=Number(t);if(!isNaN(n))return n}throw new zt(`Could not convert ${JSON.stringify(t)} to number.`)}case "formatted":return Ft.fromString(Ut(this.args[0].evaluate(e)));case "resolvedImage":return Lt.fromString(Ut(this.args[0].evaluate(e)));case "projectionDefinition":return this.args[0].evaluate(e);default:return Ut(this.args[0].evaluate(e))}}eachChild(e){this.args.forEach(e);}outputDefined(){return this.args.every((e=>e.outputDefined()))}}const Zt=["Unknown","Point","LineString","Polygon"];class Ht{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache=new Map,this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Zt[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(e){let t=this._parseColorCache.get(e);return t||(t=It.parse(e),this._parseColorCache.set(e,t)),t}}class Kt{constructor(e,t,r=[],n,i=new Be,s=[]){this.registry=e,this.path=r,this.key=r.map((e=>`[${e}]`)).join(""),this.scope=i,this.errors=s,this.expectedType=n,this._isConstant=t;}parse(e,t,r,n,i={}){return t?this.concat(t,r,n)._parse(e,i):this._parse(e,i)}_parse(e,t){function r(e,t,r){return "assert"===r?new Gt(t,[e]):"coerce"===r?new Yt(t,[e]):e}if(null!==e&&"string"!=typeof e&&"boolean"!=typeof e&&"number"!=typeof e||(e=["literal",e]),Array.isArray(e)){if(0===e.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const n=e[0];if("string"!=typeof n)return this.error(`Expression name must be a string, but found ${typeof n} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const i=this.registry[n];if(i){let n=i.parse(e,this);if(!n)return null;if(this.expectedType){const e=this.expectedType,i=n.type;if("string"!==e.kind&&"number"!==e.kind&&"boolean"!==e.kind&&"object"!==e.kind&&"array"!==e.kind||"value"!==i.kind){if("projectionDefinition"===e.kind&&["string","array"].includes(i.kind)||["color","formatted","resolvedImage"].includes(e.kind)&&["value","string"].includes(i.kind)||["padding","numberArray"].includes(e.kind)&&["value","number","array"].includes(i.kind)||"colorArray"===e.kind&&["value","string","array"].includes(i.kind)||"variableAnchorOffsetCollection"===e.kind&&["value","array"].includes(i.kind))n=r(n,e,t.typeAnnotation||"coerce");else if(this.checkSubtype(e,i))return null}else n=r(n,e,t.typeAnnotation||"assert");}if(!(n instanceof qt)&&"resolvedImage"!==n.type.kind&&this._isConstant(n)){const e=new Ht;try{n=new qt(n.type,n.evaluate(e));}catch(e){return this.error(e.message),null}}return n}return this.error(`Unknown expression "${n}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===e?"'undefined' value invalid. Use null instead.":"object"==typeof e?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof e} instead.`)}concat(e,t,r){const n="number"==typeof e?this.path.concat(e):this.path,i=r?this.scope.concat(r):this.scope;return new Kt(this.registry,this._isConstant,n,t||null,i,this.errors)}error(e,...t){const r=`${this.key}${t.map((e=>`[${e}]`)).join("")}`;this.errors.push(new Pe(r,e));}checkSubtype(e,t){const r=Je(e,t);return r&&this.error(r),r}}class Wt{constructor(e,t){this.type=t.type,this.bindings=[].concat(e),this.result=t;}evaluate(e){return this.result.evaluate(e)}eachChild(e){for(const t of this.bindings)e(t[1]);e(this.result);}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found ${e.length-1} instead.`);const r=[];for(let n=1;n<e.length-1;n+=2){const i=e[n];if("string"!=typeof i)return t.error(`Expected string, but found ${typeof i} instead.`,n);if(/[^a-zA-Z0-9_]/.test(i))return t.error("Variable names must contain only alphanumeric characters or '_'.",n);const s=t.parse(e[n+1],n+1);if(!s)return null;r.push([i,s]);}const n=t.parse(e[e.length-1],e.length-1,t.expectedType,r);return n?new Wt(r,n):null}outputDefined(){return this.result.outputDefined()}}class Jt{constructor(e,t){this.type=t.type,this.name=e,this.boundExpression=t;}static parse(e,t){if(2!==e.length||"string"!=typeof e[1])return t.error("'var' expression requires exactly one string literal argument.");const r=e[1];return t.scope.has(r)?new Jt(r,t.scope.get(r)):t.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(e){return this.boundExpression.evaluate(e)}eachChild(){}outputDefined(){return !1}}class Qt{constructor(e,t,r){this.type=e,this.index=t,this.input=r;}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const r=t.parse(e[1],1,Ve),n=t.parse(e[2],2,He(t.expectedType||$e));return r&&n?new Qt(n.type.itemType,r,n):null}evaluate(e){const t=this.index.evaluate(e),r=this.input.evaluate(e);if(t<0)throw new zt(`Array index out of bounds: ${t} < 0.`);if(t>=r.length)throw new zt(`Array index out of bounds: ${t} > ${r.length-1}.`);if(t!==Math.floor(t))throw new zt(`Array index must be an integer, but found ${t} instead.`);return r[t]}eachChild(e){e(this.index),e(this.input);}outputDefined(){return !1}}class er{constructor(e,t){this.type=Le,this.needle=e,this.haystack=t;}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const r=t.parse(e[1],1,$e),n=t.parse(e[2],2,$e);return r&&n?Qe(r.type,[Le,Ce,Ve,ze,$e])?new er(r,n):t.error(`Expected first argument to be of type boolean, string, number or null, but found ${Ke(r.type)} instead`):null}evaluate(e){const t=this.needle.evaluate(e),r=this.haystack.evaluate(e);if(!r)return !1;if(!et(t,["boolean","string","number","null"]))throw new zt(`Expected first argument to be of type boolean, string, number or null, but found ${Ke($t(t))} instead.`);if(!et(r,["string","array"]))throw new zt(`Expected second argument to be of type array or string, but found ${Ke($t(r))} instead.`);return r.indexOf(t)>=0}eachChild(e){e(this.needle),e(this.haystack);}outputDefined(){return !0}}class tr{constructor(e,t,r){this.type=Ve,this.needle=e,this.haystack=t,this.fromIndex=r;}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 2 or 3 arguments, but found ${e.length-1} instead.`);const r=t.parse(e[1],1,$e),n=t.parse(e[2],2,$e);if(!r||!n)return null;if(!Qe(r.type,[Le,Ce,Ve,ze,$e]))return t.error(`Expected first argument to be of type boolean, string, number or null, but found ${Ke(r.type)} instead`);if(4===e.length){const i=t.parse(e[3],3,Ve);return i?new tr(r,n,i):null}return new tr(r,n)}evaluate(e){const t=this.needle.evaluate(e),r=this.haystack.evaluate(e);if(!et(t,["boolean","string","number","null"]))throw new zt(`Expected first argument to be of type boolean, string, number or null, but found ${Ke($t(t))} instead.`);let n;if(this.fromIndex&&(n=this.fromIndex.evaluate(e)),et(r,["string"])){const e=r.indexOf(t,n);return -1===e?-1:[...r.slice(0,e)].length}if(et(r,["array"]))return r.indexOf(t,n);throw new zt(`Expected second argument to be of type array or string, but found ${Ke($t(r))} instead.`)}eachChild(e){e(this.needle),e(this.haystack),this.fromIndex&&e(this.fromIndex);}outputDefined(){return !1}}class rr{constructor(e,t,r,n,i,s){this.inputType=e,this.type=t,this.input=r,this.cases=n,this.outputs=i,this.otherwise=s;}static parse(e,t){if(e.length<5)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if(e.length%2!=1)return t.error("Expected an even number of arguments.");let r,n;t.expectedType&&"value"!==t.expectedType.kind&&(n=t.expectedType);const i={},s=[];for(let o=2;o<e.length-1;o+=2){let a=e[o];const l=e[o+1];Array.isArray(a)||(a=[a]);const u=t.concat(o);if(0===a.length)return u.error("Expected at least one branch label.");for(const e of a){if("number"!=typeof e&&"string"!=typeof e)return u.error("Branch labels must be numbers or strings.");if("number"==typeof e&&Math.abs(e)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof e&&Math.floor(e)!==e)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,$t(e)))return null}else r=$t(e);if(void 0!==i[String(e)])return u.error("Branch labels must be unique.");i[String(e)]=s.length;}const c=t.parse(l,o,n);if(!c)return null;n=n||c.type,s.push(c);}const o=t.parse(e[1],1,$e);if(!o)return null;const a=t.parse(e[e.length-1],e.length-1,n);return a?"value"!==o.type.kind&&t.concat(1).checkSubtype(r,o.type)?null:new rr(r,n,o,i,s,a):null}evaluate(e){const t=this.input.evaluate(e);return ($t(t)===this.inputType&&this.outputs[this.cases[t]]||this.otherwise).evaluate(e)}eachChild(e){e(this.input),this.outputs.forEach(e),e(this.otherwise);}outputDefined(){return this.outputs.every((e=>e.outputDefined()))&&this.otherwise.outputDefined()}}class nr{constructor(e,t,r){this.type=e,this.branches=t,this.otherwise=r;}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found only ${e.length-1}.`);if(e.length%2!=0)return t.error("Expected an odd number of arguments.");let r;t.expectedType&&"value"!==t.expectedType.kind&&(r=t.expectedType);const n=[];for(let i=1;i<e.length-1;i+=2){const s=t.parse(e[i],i,Le);if(!s)return null;const o=t.parse(e[i+1],i+1,r);if(!o)return null;n.push([s,o]),r=r||o.type;}const i=t.parse(e[e.length-1],e.length-1,r);if(!i)return null;if(!r)throw new Error("Can't infer output type");return new nr(r,n,i)}evaluate(e){for(const[t,r]of this.branches)if(t.evaluate(e))return r.evaluate(e);return this.otherwise.evaluate(e)}eachChild(e){for(const[t,r]of this.branches)e(t),e(r);e(this.otherwise);}outputDefined(){return this.branches.every((([e,t])=>t.outputDefined()))&&this.otherwise.outputDefined()}}class ir{constructor(e,t,r,n){this.type=e,this.input=t,this.beginIndex=r,this.endIndex=n;}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 2 or 3 arguments, but found ${e.length-1} instead.`);const r=t.parse(e[1],1,$e),n=t.parse(e[2],2,Ve);if(!r||!n)return null;if(!Qe(r.type,[He($e),Ce,$e]))return t.error(`Expected first argument to be of type array or string, but found ${Ke(r.type)} instead`);if(4===e.length){const i=t.parse(e[3],3,Ve);return i?new ir(r.type,r,n,i):null}return new ir(r.type,r,n)}evaluate(e){const t=this.input.evaluate(e),r=this.beginIndex.evaluate(e);let n;if(this.endIndex&&(n=this.endIndex.evaluate(e)),et(t,["string"]))return [...t].slice(r,n).join("");if(et(t,["array"]))return t.slice(r,n);throw new zt(`Expected first argument to be of type array or string, but found ${Ke($t(t))} instead.`)}eachChild(e){e(this.input),e(this.beginIndex),this.endIndex&&e(this.endIndex);}outputDefined(){return !1}}function sr(e,t){const r=e.length-1;let n,i,s=0,o=r,a=0;for(;s<=o;)if(a=Math.floor((s+o)/2),n=e[a],i=e[a+1],n<=t){if(a===r||t<i)return a;s=a+1;}else {if(!(n>t))throw new zt("Input is not a number.");o=a-1;}return 0}class or{constructor(e,t,r){this.type=e,this.input=t,this.labels=[],this.outputs=[];for(const[e,t]of r)this.labels.push(e),this.outputs.push(t);}static parse(e,t){if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");const r=t.parse(e[1],1,Ve);if(!r)return null;const n=[];let i=null;t.expectedType&&"value"!==t.expectedType.kind&&(i=t.expectedType);for(let r=1;r<e.length;r+=2){const s=1===r?-1/0:e[r],o=e[r+1],a=r,l=r+1;if("number"!=typeof s)return t.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',a);if(n.length&&n[n.length-1][0]>=s)return t.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',a);const u=t.parse(o,l,i);if(!u)return null;i=i||u.type,n.push([s,u]);}return new or(i,r,n)}evaluate(e){const t=this.labels,r=this.outputs;if(1===t.length)return r[0].evaluate(e);const n=this.input.evaluate(e);if(n<=t[0])return r[0].evaluate(e);const i=t.length;return n>=t[i-1]?r[i-1].evaluate(e):r[sr(t,n)].evaluate(e)}eachChild(e){e(this.input);for(const t of this.outputs)e(t);}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}}function ar(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var lr,ur,cr=function(){if(ur)return lr;function e(e,t,r,n){this.cx=3*e,this.bx=3*(r-e)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*t,this.by=3*(n-t)-this.cy,this.ay=1-this.cy-this.by,this.p1x=e,this.p1y=t,this.p2x=r,this.p2y=n;}return ur=1,lr=e,e.prototype={sampleCurveX:function(e){return ((this.ax*e+this.bx)*e+this.cx)*e},sampleCurveY:function(e){return ((this.ay*e+this.by)*e+this.cy)*e},sampleCurveDerivativeX:function(e){return (3*this.ax*e+2*this.bx)*e+this.cx},solveCurveX:function(e,t){if(void 0===t&&(t=1e-6),e<0)return 0;if(e>1)return 1;for(var r=e,n=0;n<8;n++){var i=this.sampleCurveX(r)-e;if(Math.abs(i)<t)return r;var s=this.sampleCurveDerivativeX(r);if(Math.abs(s)<1e-6)break;r-=i/s;}var o=0,a=1;for(r=e,n=0;n<20&&(i=this.sampleCurveX(r),!(Math.abs(i-e)<t));n++)e>i?o=r:a=r,r=.5*(a-o)+o;return r},solve:function(e,t){return this.sampleCurveY(this.solveCurveX(e,t))}},lr}(),hr=ar(cr);class pr{constructor(e,t,r,n,i){this.type=e,this.operator=t,this.interpolation=r,this.input=n,this.labels=[],this.outputs=[];for(const[e,t]of i)this.labels.push(e),this.outputs.push(t);}static interpolationFactor(e,t,r,n){let i=0;if("exponential"===e.name)i=fr(t,e.base,r,n);else if("linear"===e.name)i=fr(t,1,r,n);else if("cubic-bezier"===e.name){const s=e.controlPoints;i=new hr(s[0],s[1],s[2],s[3]).solve(fr(t,1,r,n));}return i}static parse(e,t){let[r,n,i,...s]=e;if(!Array.isArray(n)||0===n.length)return t.error("Expected an interpolation type expression.",1);if("linear"===n[0])n={name:"linear"};else if("exponential"===n[0]){const e=n[1];if("number"!=typeof e)return t.error("Exponential interpolation requires a numeric base.",1,1);n={name:"exponential",base:e};}else {if("cubic-bezier"!==n[0])return t.error(`Unknown interpolation type ${String(n[0])}`,1,0);{const e=n.slice(1);if(4!==e.length||e.some((e=>"number"!=typeof e||e<0||e>1)))return t.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);n={name:"cubic-bezier",controlPoints:e};}}if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");if(i=t.parse(i,2,Ve),!i)return null;const o=[];let a=null;"interpolate-hcl"!==r&&"interpolate-lab"!==r||t.expectedType==Ge?t.expectedType&&"value"!==t.expectedType.kind&&(a=t.expectedType):a=Oe;for(let e=0;e<s.length;e+=2){const r=s[e],n=s[e+1],i=e+3,l=e+4;if("number"!=typeof r)return t.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',i);if(o.length&&o[o.length-1][0]>=r)return t.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',i);const u=t.parse(n,l,a);if(!u)return null;a=a||u.type,o.push([r,u]);}return tt(a,Ve)||tt(a,Re)||tt(a,Oe)||tt(a,je)||tt(a,Xe)||tt(a,Ge)||tt(a,Ze)||tt(a,He(Ve))?new pr(a,r,n,i,o):t.error(`Type ${Ke(a)} is not interpolatable.`)}evaluate(e){const t=this.labels,r=this.outputs;if(1===t.length)return r[0].evaluate(e);const n=this.input.evaluate(e);if(n<=t[0])return r[0].evaluate(e);const i=t.length;if(n>=t[i-1])return r[i-1].evaluate(e);const s=sr(t,n),o=pr.interpolationFactor(this.interpolation,n,t[s],t[s+1]),a=r[s].evaluate(e),l=r[s+1].evaluate(e);switch(this.operator){case "interpolate":switch(this.type.kind){case "number":return At(a,l,o);case "color":return It.interpolate(a,l,o);case "padding":return Dt.interpolate(a,l,o);case "colorArray":return Bt.interpolate(a,l,o);case "numberArray":return Pt.interpolate(a,l,o);case "variableAnchorOffsetCollection":return Ct.interpolate(a,l,o);case "array":return Tt(a,l,o);case "projectionDefinition":return Ot.interpolate(a,l,o)}case "interpolate-hcl":switch(this.type.kind){case "color":return It.interpolate(a,l,o,"hcl");case "colorArray":return Bt.interpolate(a,l,o,"hcl")}case "interpolate-lab":switch(this.type.kind){case "color":return It.interpolate(a,l,o,"lab");case "colorArray":return Bt.interpolate(a,l,o,"lab")}}}eachChild(e){e(this.input);for(const t of this.outputs)e(t);}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}}function fr(e,t,r,n){const i=n-r,s=e-r;return 0===i?0:1===t?s/i:(Math.pow(t,s)-1)/(Math.pow(t,i)-1)}const dr={color:It.interpolate,number:At,padding:Dt.interpolate,numberArray:Pt.interpolate,colorArray:Bt.interpolate,variableAnchorOffsetCollection:Ct.interpolate,array:Tt};class yr{constructor(e,t){this.type=e,this.args=t;}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");let r=null;const n=t.expectedType;n&&"value"!==n.kind&&(r=n);const i=[];for(const n of e.slice(1)){const e=t.parse(n,1+i.length,r,void 0,{typeAnnotation:"omit"});if(!e)return null;r=r||e.type,i.push(e);}if(!r)throw new Error("No output type");const s=n&&i.some((e=>Je(n,e.type)));return new yr(s?$e:r,i)}evaluate(e){let t,r=null,n=0;for(const i of this.args)if(n++,r=i.evaluate(e),r&&r instanceof Lt&&!r.available&&(t||(t=r.name),r=null,n===this.args.length&&(r=t)),null!==r)break;return r}eachChild(e){this.args.forEach(e);}outputDefined(){return this.args.every((e=>e.outputDefined()))}}function mr(e,t){return "=="===e||"!="===e?"boolean"===t.kind||"string"===t.kind||"number"===t.kind||"null"===t.kind||"value"===t.kind:"string"===t.kind||"number"===t.kind||"value"===t.kind}function gr(e,t,r,n){return 0===n.compare(t,r)}function xr(e,t,r){const n="=="!==e&&"!="!==e;return class i{constructor(e,t,r){this.type=Le,this.lhs=e,this.rhs=t,this.collator=r,this.hasUntypedArgument="value"===e.type.kind||"value"===t.type.kind;}static parse(e,t){if(3!==e.length&&4!==e.length)return t.error("Expected two or three arguments.");const r=e[0];let s=t.parse(e[1],1,$e);if(!s)return null;if(!mr(r,s.type))return t.concat(1).error(`"${r}" comparisons are not supported for type '${Ke(s.type)}'.`);let o=t.parse(e[2],2,$e);if(!o)return null;if(!mr(r,o.type))return t.concat(2).error(`"${r}" comparisons are not supported for type '${Ke(o.type)}'.`);if(s.type.kind!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return t.error(`Cannot compare types '${Ke(s.type)}' and '${Ke(o.type)}'.`);n&&("value"===s.type.kind&&"value"!==o.type.kind?s=new Gt(o.type,[s]):"value"!==s.type.kind&&"value"===o.type.kind&&(o=new Gt(s.type,[o])));let a=null;if(4===e.length){if("string"!==s.type.kind&&"string"!==o.type.kind&&"value"!==s.type.kind&&"value"!==o.type.kind)return t.error("Cannot use collator to compare non-string types.");if(a=t.parse(e[3],3,Ue),!a)return null}return new i(s,o,a)}evaluate(i){const s=this.lhs.evaluate(i),o=this.rhs.evaluate(i);if(n&&this.hasUntypedArgument){const t=$t(s),r=$t(o);if(t.kind!==r.kind||"string"!==t.kind&&"number"!==t.kind)throw new zt(`Expected arguments for "${e}" to be (string, string) or (number, number), but found (${t.kind}, ${r.kind}) instead.`)}if(this.collator&&!n&&this.hasUntypedArgument){const e=$t(s),r=$t(o);if("string"!==e.kind||"string"!==r.kind)return t(i,s,o)}return this.collator?r(i,s,o,this.collator.evaluate(i)):t(i,s,o)}eachChild(e){e(this.lhs),e(this.rhs),this.collator&&e(this.collator);}outputDefined(){return !0}}}const vr=xr("==",(function(e,t,r){return t===r}),gr),br=xr("!=",(function(e,t,r){return t!==r}),(function(e,t,r,n){return !gr(0,t,r,n)})),wr=xr("<",(function(e,t,r){return t<r}),(function(e,t,r,n){return n.compare(t,r)<0})),_r=xr(">",(function(e,t,r){return t>r}),(function(e,t,r,n){return n.compare(t,r)>0})),Sr=xr("<=",(function(e,t,r){return t<=r}),(function(e,t,r,n){return n.compare(t,r)<=0})),Ar=xr(">=",(function(e,t,r){return t>=r}),(function(e,t,r,n){return n.compare(t,r)>=0}));class Tr{constructor(e,t,r){this.type=Ue,this.locale=r,this.caseSensitive=e,this.diacriticSensitive=t;}static parse(e,t){if(2!==e.length)return t.error("Expected one argument.");const r=e[1];if("object"!=typeof r||Array.isArray(r))return t.error("Collator options argument must be an object.");const n=t.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,Le);if(!n)return null;const i=t.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,Le);if(!i)return null;let s=null;return r.locale&&(s=t.parse(r.locale,1,Ce),!s)?null:new Tr(n,i,s)}evaluate(e){return new Et(this.caseSensitive.evaluate(e),this.diacriticSensitive.evaluate(e),this.locale?this.locale.evaluate(e):null)}eachChild(e){e(this.caseSensitive),e(this.diacriticSensitive),this.locale&&e(this.locale);}outputDefined(){return !1}}class Ir{constructor(e,t,r,n,i){this.type=Ce,this.number=e,this.locale=t,this.currency=r,this.minFractionDigits=n,this.maxFractionDigits=i;}static parse(e,t){if(3!==e.length)return t.error("Expected two arguments.");const r=t.parse(e[1],1,Ve);if(!r)return null;const n=e[2];if("object"!=typeof n||Array.isArray(n))return t.error("NumberFormat options argument must be an object.");let i=null;if(n.locale&&(i=t.parse(n.locale,1,Ce),!i))return null;let s=null;if(n.currency&&(s=t.parse(n.currency,1,Ce),!s))return null;let o=null;if(n["min-fraction-digits"]&&(o=t.parse(n["min-fraction-digits"],1,Ve),!o))return null;let a=null;return n["max-fraction-digits"]&&(a=t.parse(n["max-fraction-digits"],1,Ve),!a)?null:new Ir(r,i,s,o,a)}evaluate(e){return new Intl.NumberFormat(this.locale?this.locale.evaluate(e):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(e):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(e):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(e):void 0}).format(this.number.evaluate(e))}eachChild(e){e(this.number),this.locale&&e(this.locale),this.currency&&e(this.currency),this.minFractionDigits&&e(this.minFractionDigits),this.maxFractionDigits&&e(this.maxFractionDigits);}outputDefined(){return !1}}class Er{constructor(e){this.type=qe,this.sections=e;}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const r=e[1];if(!Array.isArray(r)&&"object"==typeof r)return t.error("First argument must be an image or text section.");const n=[];let i=!1;for(let r=1;r<=e.length-1;++r){const s=e[r];if(i&&"object"==typeof s&&!Array.isArray(s)){i=!1;let e=null;if(s["font-scale"]&&(e=t.parse(s["font-scale"],1,Ve),!e))return null;let r=null;if(s["text-font"]&&(r=t.parse(s["text-font"],1,He(Ce)),!r))return null;let o=null;if(s["text-color"]&&(o=t.parse(s["text-color"],1,Oe),!o))return null;let a=null;if(s["vertical-align"]){if("string"==typeof s["vertical-align"]&&!Mt.includes(s["vertical-align"]))return t.error(`'vertical-align' must be one of: 'bottom', 'center', 'top' but found '${s["vertical-align"]}' instead.`);if(a=t.parse(s["vertical-align"],1,Ce),!a)return null}const l=n[n.length-1];l.scale=e,l.font=r,l.textColor=o,l.verticalAlign=a;}else {const s=t.parse(e[r],1,$e);if(!s)return null;const o=s.type.kind;if("string"!==o&&"value"!==o&&"null"!==o&&"resolvedImage"!==o)return t.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");i=!0,n.push({content:s,scale:null,font:null,textColor:null,verticalAlign:null});}}return new Er(n)}evaluate(e){return new Ft(this.sections.map((t=>{const r=t.content.evaluate(e);return $t(r)===Ye?new kt("",r,null,null,null,t.verticalAlign?t.verticalAlign.evaluate(e):null):new kt(Ut(r),null,t.scale?t.scale.evaluate(e):null,t.font?t.font.evaluate(e).join(","):null,t.textColor?t.textColor.evaluate(e):null,t.verticalAlign?t.verticalAlign.evaluate(e):null)})))}eachChild(e){for(const t of this.sections)e(t.content),t.scale&&e(t.scale),t.font&&e(t.font),t.textColor&&e(t.textColor),t.verticalAlign&&e(t.verticalAlign);}outputDefined(){return !1}}class Mr{constructor(e){this.type=Ye,this.input=e;}static parse(e,t){if(2!==e.length)return t.error("Expected two arguments.");const r=t.parse(e[1],1,Ce);return r?new Mr(r):t.error("No image name provided.")}evaluate(e){const t=this.input.evaluate(e),r=Lt.fromString(t);return r&&e.availableImages&&(r.available=e.availableImages.indexOf(t)>-1),r}eachChild(e){e(this.input);}outputDefined(){return !1}}class kr{constructor(e){this.type=Ve,this.input=e;}static parse(e,t){if(2!==e.length)return t.error(`Expected 1 argument, but found ${e.length-1} instead.`);const r=t.parse(e[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?t.error(`Expected argument of type string or array, but found ${Ke(r.type)} instead.`):new kr(r):null}evaluate(e){const t=this.input.evaluate(e);if("string"==typeof t)return [...t].length;if(Array.isArray(t))return t.length;throw new zt(`Expected value to be of type string or array, but found ${Ke($t(t))} instead.`)}eachChild(e){e(this.input);}outputDefined(){return !1}}const Fr=8192;function Dr(e,t){const r=(180+e[0])/360,n=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e[1]*Math.PI/360)))/360,i=Math.pow(2,t.z);return [Math.round(r*i*Fr),Math.round(n*i*Fr)]}function Pr(e,t){const r=Math.pow(2,t.z);return [(i=(e[0]/Fr+t.x)/r,360*i-180),(n=(e[1]/Fr+t.y)/r,360/Math.PI*Math.atan(Math.exp((180-360*n)*Math.PI/180))-90)];var n,i;}function Br(e,t){e[0]=Math.min(e[0],t[0]),e[1]=Math.min(e[1],t[1]),e[2]=Math.max(e[2],t[0]),e[3]=Math.max(e[3],t[1]);}function zr(e,t){return !(e[0]<=t[0]||e[2]>=t[2]||e[1]<=t[1]||e[3]>=t[3])}function Vr(e,t,r){const n=e[0]-t[0],i=e[1]-t[1],s=e[0]-r[0],o=e[1]-r[1];return n*o-s*i==0&&n*s<=0&&i*o<=0}function Cr(e,t,r,n){return 0!=(i=[n[0]-r[0],n[1]-r[1]])[0]*(s=[t[0]-e[0],t[1]-e[1]])[1]-i[1]*s[0]&&!(!Ur(e,t,r,n)||!Ur(r,n,e,t));var i,s;}function Lr(e,t,r){for(const n of r)for(let r=0;r<n.length-1;++r)if(Cr(e,t,n[r],n[r+1]))return !0;return !1}function Or(e,t,r=!1){let n=!1;for(const a of t)for(let t=0;t<a.length-1;t++){if(Vr(e,a[t],a[t+1]))return r;(s=a[t])[1]>(i=e)[1]!=(o=a[t+1])[1]>i[1]&&i[0]<(o[0]-s[0])*(i[1]-s[1])/(o[1]-s[1])+s[0]&&(n=!n);}var i,s,o;return n}function Rr(e,t){for(const r of t)if(Or(e,r))return !0;return !1}function Nr(e,t){for(const r of e)if(!Or(r,t))return !1;for(let r=0;r<e.length-1;++r)if(Lr(e[r],e[r+1],t))return !1;return !0}function $r(e,t){for(const r of t)if(Nr(e,r))return !0;return !1}function Ur(e,t,r,n){const i=n[0]-r[0],s=n[1]-r[1],o=(e[0]-r[0])*s-i*(e[1]-r[1]),a=(t[0]-r[0])*s-i*(t[1]-r[1]);return o>0&&a<0||o<0&&a>0}function qr(e,t,r){const n=[];for(let i=0;i<e.length;i++){const s=[];for(let n=0;n<e[i].length;n++){const o=Dr(e[i][n],r);Br(t,o),s.push(o);}n.push(s);}return n}function jr(e,t,r){const n=[];for(let i=0;i<e.length;i++){const s=qr(e[i],t,r);n.push(s);}return n}function Gr(e,t,r,n){if(e[0]<r[0]||e[0]>r[2]){const t=.5*n;let i=e[0]-r[0]>t?-n:r[0]-e[0]>t?n:0;0===i&&(i=e[0]-r[2]>t?-n:r[2]-e[0]>t?n:0),e[0]+=i;}Br(t,e);}function Xr(e,t,r,n){const i=Math.pow(2,n.z)*Fr,s=[n.x*Fr,n.y*Fr],o=[];for(const n of e)for(const e of n){const n=[e.x+s[0],e.y+s[1]];Gr(n,t,r,i),o.push(n);}return o}function Yr(e,t,r,n){const i=Math.pow(2,n.z)*Fr,s=[n.x*Fr,n.y*Fr],o=[];for(const r of e){const e=[];for(const n of r){const r=[n.x+s[0],n.y+s[1]];Br(t,r),e.push(r);}o.push(e);}if(t[2]-t[0]<=i/2){(a=t)[0]=a[1]=1/0,a[2]=a[3]=-1/0;for(const e of o)for(const n of e)Gr(n,t,r,i);}var a;return o}class Zr{constructor(e,t){this.type=Le,this.geojson=e,this.geometries=t;}static parse(e,t){if(2!==e.length)return t.error(`'within' expression requires exactly one argument, but found ${e.length-1} instead.`);if(Nt(e[1])){const t=e[1];if("FeatureCollection"===t.type){const e=[];for(const r of t.features){const{type:t,coordinates:n}=r.geometry;"Polygon"===t&&e.push(n),"MultiPolygon"===t&&e.push(...n);}if(e.length)return new Zr(t,{type:"MultiPolygon",coordinates:e})}else if("Feature"===t.type){const e=t.geometry.type;if("Polygon"===e||"MultiPolygon"===e)return new Zr(t,t.geometry)}else if("Polygon"===t.type||"MultiPolygon"===t.type)return new Zr(t,t)}return t.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(e){if(null!=e.geometry()&&null!=e.canonicalID()){if("Point"===e.geometryType())return function(e,t){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=e.canonicalID();if("Polygon"===t.type){const s=qr(t.coordinates,n,i),o=Xr(e.geometry(),r,n,i);if(!zr(r,n))return !1;for(const e of o)if(!Or(e,s))return !1}if("MultiPolygon"===t.type){const s=jr(t.coordinates,n,i),o=Xr(e.geometry(),r,n,i);if(!zr(r,n))return !1;for(const e of o)if(!Rr(e,s))return !1}return !0}(e,this.geometries);if("LineString"===e.geometryType())return function(e,t){const r=[1/0,1/0,-1/0,-1/0],n=[1/0,1/0,-1/0,-1/0],i=e.canonicalID();if("Polygon"===t.type){const s=qr(t.coordinates,n,i),o=Yr(e.geometry(),r,n,i);if(!zr(r,n))return !1;for(const e of o)if(!Nr(e,s))return !1}if("MultiPolygon"===t.type){const s=jr(t.coordinates,n,i),o=Yr(e.geometry(),r,n,i);if(!zr(r,n))return !1;for(const e of o)if(!$r(e,s))return !1}return !0}(e,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}}let Hr=class{constructor(e=[],t=(e,t)=>e<t?-1:e>t?1:0){if(this.data=e,this.length=this.data.length,this.compare=t,this.length>0)for(let e=(this.length>>1)-1;e>=0;e--)this._down(e);}push(e){this.data.push(e),this._up(this.length++);}pop(){if(0===this.length)return;const e=this.data[0],t=this.data.pop();return --this.length>0&&(this.data[0]=t,this._down(0)),e}peek(){return this.data[0]}_up(e){const{data:t,compare:r}=this,n=t[e];for(;e>0;){const i=e-1>>1,s=t[i];if(r(n,s)>=0)break;t[e]=s,e=i;}t[e]=n;}_down(e){const{data:t,compare:r}=this,n=this.length>>1,i=t[e];for(;e<n;){let n=1+(e<<1);const s=n+1;if(s<this.length&&r(t[s],t[n])<0&&(n=s),r(t[n],i)>=0)break;t[e]=t[n],e=n;}t[e]=i;}};function Kr(e,t,r=0,n=e.length-1,i=Jr){for(;n>r;){if(n-r>600){const s=n-r+1,o=t-r+1,a=Math.log(s),l=.5*Math.exp(2*a/3),u=.5*Math.sqrt(a*l*(s-l)/s)*(o-s/2<0?-1:1);Kr(e,t,Math.max(r,Math.floor(t-o*l/s+u)),Math.min(n,Math.floor(t+(s-o)*l/s+u)),i);}const s=e[t];let o=r,a=n;for(Wr(e,r,t),i(e[n],s)>0&&Wr(e,r,n);o<a;){for(Wr(e,o,a),o++,a--;i(e[o],s)<0;)o++;for(;i(e[a],s)>0;)a--;}0===i(e[r],s)?Wr(e,r,a):(a++,Wr(e,a,n)),a<=t&&(r=a+1),t<=a&&(n=a-1);}}function Wr(e,t,r){const n=e[t];e[t]=e[r],e[r]=n;}function Jr(e,t){return e<t?-1:e>t?1:0}function Qr(e,t){if(e.length<=1)return [e];const r=[];let n,i;for(const t of e){const e=tn(t);0!==e&&(t.area=Math.abs(e),void 0===i&&(i=e<0),i===e<0?(n&&r.push(n),n=[t]):n.push(t));}if(n&&r.push(n),t>1)for(let e=0;e<r.length;e++)r[e].length<=t||(Kr(r[e],t,1,r[e].length-1,en),r[e]=r[e].slice(0,t));return r}function en(e,t){return t.area-e.area}function tn(e){let t=0;for(let r,n,i=0,s=e.length,o=s-1;i<s;o=i++)r=e[i],n=e[o],t+=(n.x-r.x)*(r.y+n.y);return t}const rn=1/298.257223563,nn=rn*(2-rn),sn=Math.PI/180;class on{constructor(e){const t=6378.137*sn*1e3,r=Math.cos(e*sn),n=1/(1-nn*(1-r*r)),i=Math.sqrt(n);this.kx=t*i*r,this.ky=t*i*n*(1-nn);}distance(e,t){const r=this.wrap(e[0]-t[0])*this.kx,n=(e[1]-t[1])*this.ky;return Math.sqrt(r*r+n*n)}pointOnLine(e,t){let r,n,i,s,o=1/0;for(let a=0;a<e.length-1;a++){let l=e[a][0],u=e[a][1],c=this.wrap(e[a+1][0]-l)*this.kx,h=(e[a+1][1]-u)*this.ky,p=0;0===c&&0===h||(p=(this.wrap(t[0]-l)*this.kx*c+(t[1]-u)*this.ky*h)/(c*c+h*h),p>1?(l=e[a+1][0],u=e[a+1][1]):p>0&&(l+=c/this.kx*p,u+=h/this.ky*p)),c=this.wrap(t[0]-l)*this.kx,h=(t[1]-u)*this.ky;const f=c*c+h*h;f<o&&(o=f,r=l,n=u,i=a,s=p);}return {point:[r,n],index:i,t:Math.max(0,Math.min(1,s))}}wrap(e){for(;e<-180;)e+=360;for(;e>180;)e-=360;return e}}function an(e,t){return t[0]-e[0]}function ln(e){return e[1]-e[0]+1}function un(e,t){return e[1]>=e[0]&&e[1]<t}function cn(e,t){if(e[0]>e[1])return [null,null];const r=ln(e);if(t){if(2===r)return [e,null];const t=Math.floor(r/2);return [[e[0],e[0]+t],[e[0]+t,e[1]]]}if(1===r)return [e,null];const n=Math.floor(r/2)-1;return [[e[0],e[0]+n],[e[0]+n+1,e[1]]]}function hn(e,t){if(!un(t,e.length))return [1/0,1/0,-1/0,-1/0];const r=[1/0,1/0,-1/0,-1/0];for(let n=t[0];n<=t[1];++n)Br(r,e[n]);return r}function pn(e){const t=[1/0,1/0,-1/0,-1/0];for(const r of e)for(const e of r)Br(t,e);return t}function fn(e){return e[0]!==-1/0&&e[1]!==-1/0&&e[2]!==1/0&&e[3]!==1/0}function dn(e,t,r){if(!fn(e)||!fn(t))return NaN;let n=0,i=0;return e[2]<t[0]&&(n=t[0]-e[2]),e[0]>t[2]&&(n=e[0]-t[2]),e[1]>t[3]&&(i=e[1]-t[3]),e[3]<t[1]&&(i=t[1]-e[3]),r.distance([0,0],[n,i])}function yn(e,t,r){const n=r.pointOnLine(t,e);return r.distance(e,n.point)}function mn(e,t,r,n,i){const s=Math.min(yn(e,[r,n],i),yn(t,[r,n],i)),o=Math.min(yn(r,[e,t],i),yn(n,[e,t],i));return Math.min(s,o)}function gn(e,t,r,n,i){if(!un(t,e.length)||!un(n,r.length))return 1/0;let s=1/0;for(let o=t[0];o<t[1];++o){const t=e[o],a=e[o+1];for(let e=n[0];e<n[1];++e){const n=r[e],o=r[e+1];if(Cr(t,a,n,o))return 0;s=Math.min(s,mn(t,a,n,o,i));}}return s}function xn(e,t,r,n,i){if(!un(t,e.length)||!un(n,r.length))return NaN;let s=1/0;for(let o=t[0];o<=t[1];++o)for(let t=n[0];t<=n[1];++t)if(s=Math.min(s,i.distance(e[o],r[t])),0===s)return s;return s}function vn(e,t,r){if(Or(e,t,!0))return 0;let n=1/0;for(const i of t){const t=i[0],s=i[i.length-1];if(t!==s&&(n=Math.min(n,yn(e,[s,t],r)),0===n))return n;const o=r.pointOnLine(i,e);if(n=Math.min(n,r.distance(e,o.point)),0===n)return n}return n}function bn(e,t,r,n){if(!un(t,e.length))return NaN;for(let n=t[0];n<=t[1];++n)if(Or(e[n],r,!0))return 0;let i=1/0;for(let s=t[0];s<t[1];++s){const t=e[s],o=e[s+1];for(const e of r)for(let r=0,s=e.length,a=s-1;r<s;a=r++){const s=e[a],l=e[r];if(Cr(t,o,s,l))return 0;i=Math.min(i,mn(t,o,s,l,n));}}return i}function wn(e,t){for(const r of e)for(const e of r)if(Or(e,t,!0))return !0;return !1}function _n(e,t,r,n=1/0){const i=pn(e),s=pn(t);if(n!==1/0&&dn(i,s,r)>=n)return n;if(zr(i,s)){if(wn(e,t))return 0}else if(wn(t,e))return 0;let o=1/0;for(const n of e)for(let e=0,i=n.length,s=i-1;e<i;s=e++){const i=n[s],a=n[e];for(const e of t)for(let t=0,n=e.length,s=n-1;t<n;s=t++){const n=e[s],l=e[t];if(Cr(i,a,n,l))return 0;o=Math.min(o,mn(i,a,n,l,r));}}return o}function Sn(e,t,r,n,i,s){if(!s)return;const o=dn(hn(n,s),i,r);o<t&&e.push([o,s,[0,0]]);}function An(e,t,r,n,i,s,o){if(!s||!o)return;const a=dn(hn(n,s),hn(i,o),r);a<t&&e.push([a,s,o]);}function Tn(e,t,r,n,i=1/0){let s=Math.min(n.distance(e[0],r[0][0]),i);if(0===s)return s;const o=new Hr([[0,[0,e.length-1],[0,0]]],an),a=pn(r);for(;o.length>0;){const i=o.pop();if(i[0]>=s)continue;const l=i[1],u=t?50:100;if(ln(l)<=u){if(!un(l,e.length))return NaN;if(t){const t=bn(e,l,r,n);if(isNaN(t)||0===t)return t;s=Math.min(s,t);}else for(let t=l[0];t<=l[1];++t){const i=vn(e[t],r,n);if(s=Math.min(s,i),0===s)return 0}}else {const r=cn(l,t);Sn(o,s,n,e,a,r[0]),Sn(o,s,n,e,a,r[1]);}}return s}function In(e,t,r,n,i,s=1/0){let o=Math.min(s,i.distance(e[0],r[0]));if(0===o)return o;const a=new Hr([[0,[0,e.length-1],[0,r.length-1]]],an);for(;a.length>0;){const s=a.pop();if(s[0]>=o)continue;const l=s[1],u=s[2],c=t?50:100,h=n?50:100;if(ln(l)<=c&&ln(u)<=h){if(!un(l,e.length)&&un(u,r.length))return NaN;let s;if(t&&n)s=gn(e,l,r,u,i),o=Math.min(o,s);else if(t&&!n){const t=e.slice(l[0],l[1]+1);for(let e=u[0];e<=u[1];++e)if(s=yn(r[e],t,i),o=Math.min(o,s),0===o)return o}else if(!t&&n){const t=r.slice(u[0],u[1]+1);for(let r=l[0];r<=l[1];++r)if(s=yn(e[r],t,i),o=Math.min(o,s),0===o)return o}else s=xn(e,l,r,u,i),o=Math.min(o,s);}else {const s=cn(l,t),c=cn(u,n);An(a,o,i,e,r,s[0],c[0]),An(a,o,i,e,r,s[0],c[1]),An(a,o,i,e,r,s[1],c[0]),An(a,o,i,e,r,s[1],c[1]);}}return o}function En(e){return "MultiPolygon"===e.type?e.coordinates.map((e=>({type:"Polygon",coordinates:e}))):"MultiLineString"===e.type?e.coordinates.map((e=>({type:"LineString",coordinates:e}))):"MultiPoint"===e.type?e.coordinates.map((e=>({type:"Point",coordinates:e}))):[e]}class Mn{constructor(e,t){this.type=Ve,this.geojson=e,this.geometries=t;}static parse(e,t){if(2!==e.length)return t.error(`'distance' expression requires exactly one argument, but found ${e.length-1} instead.`);if(Nt(e[1])){const t=e[1];if("FeatureCollection"===t.type)return new Mn(t,t.features.map((e=>En(e.geometry))).flat());if("Feature"===t.type)return new Mn(t,En(t.geometry));if("type"in t&&"coordinates"in t)return new Mn(t,En(t))}return t.error("'distance' expression requires valid geojson object that contains polygon geometry type.")}evaluate(e){if(null!=e.geometry()&&null!=e.canonicalID()){if("Point"===e.geometryType())return function(e,t){const r=e.geometry(),n=r.flat().map((t=>Pr([t.x,t.y],e.canonical)));if(0===r.length)return NaN;const i=new on(n[0][1]);let s=1/0;for(const e of t){switch(e.type){case "Point":s=Math.min(s,In(n,!1,[e.coordinates],!1,i,s));break;case "LineString":s=Math.min(s,In(n,!1,e.coordinates,!0,i,s));break;case "Polygon":s=Math.min(s,Tn(n,!1,e.coordinates,i,s));}if(0===s)return s}return s}(e,this.geometries);if("LineString"===e.geometryType())return function(e,t){const r=e.geometry(),n=r.flat().map((t=>Pr([t.x,t.y],e.canonical)));if(0===r.length)return NaN;const i=new on(n[0][1]);let s=1/0;for(const e of t){switch(e.type){case "Point":s=Math.min(s,In(n,!0,[e.coordinates],!1,i,s));break;case "LineString":s=Math.min(s,In(n,!0,e.coordinates,!0,i,s));break;case "Polygon":s=Math.min(s,Tn(n,!0,e.coordinates,i,s));}if(0===s)return s}return s}(e,this.geometries);if("Polygon"===e.geometryType())return function(e,t){const r=e.geometry();if(0===r.length||0===r[0].length)return NaN;const n=Qr(r,0).map((t=>t.map((t=>t.map((t=>Pr([t.x,t.y],e.canonical))))))),i=new on(n[0][0][0][1]);let s=1/0;for(const e of t)for(const t of n){switch(e.type){case "Point":s=Math.min(s,Tn([e.coordinates],!1,t,i,s));break;case "LineString":s=Math.min(s,Tn(e.coordinates,!0,t,i,s));break;case "Polygon":s=Math.min(s,_n(t,e.coordinates,i,s));}if(0===s)return s}return s}(e,this.geometries)}return NaN}eachChild(){}outputDefined(){return !0}}class kn{constructor(e){this.type=$e,this.key=e;}static parse(e,t){if(2!==e.length)return t.error(`Expected 1 argument, but found ${e.length-1} instead.`);const r=e[1];return null==r?t.error("Global state property must be defined."):"string"!=typeof r?t.error(`Global state property must be string, but found ${typeof e[1]} instead.`):new kn(r)}evaluate(e){var t;const r=null===(t=e.globals)||void 0===t?void 0:t.globalState;return r&&0!==Object.keys(r).length?xt(r,this.key):null}eachChild(){}outputDefined(){return !1}}const Fn={"==":vr,"!=":br,">":_r,"<":wr,">=":Ar,"<=":Sr,array:Gt,at:Qt,boolean:Gt,case:nr,coalesce:yr,collator:Tr,format:Er,image:Mr,in:er,"index-of":tr,interpolate:pr,"interpolate-hcl":pr,"interpolate-lab":pr,length:kr,let:Wt,literal:qt,match:rr,number:Gt,"number-format":Ir,object:Gt,slice:ir,step:or,string:Gt,"to-boolean":Yt,"to-color":Yt,"to-number":Yt,"to-string":Yt,var:Jt,within:Zr,distance:Mn,"global-state":kn};class Dn{constructor(e,t,r,n){this.name=e,this.type=t,this._evaluate=r,this.args=n;}evaluate(e){return this._evaluate(e,this.args)}eachChild(e){this.args.forEach(e);}outputDefined(){return !1}static parse(e,t){const r=e[0],n=Dn.definitions[r];if(!n)return t.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const i=Array.isArray(n)?n[0]:n.type,s=Array.isArray(n)?[[n[1],n[2]]]:n.overloads,o=s.filter((([t])=>!Array.isArray(t)||t.length===e.length-1));let a=null;for(const[n,s]of o){a=new Kt(t.registry,Cn,t.path,null,t.scope);const o=[];let l=!1;for(let t=1;t<e.length;t++){const r=e[t],i=Array.isArray(n)?n[t-1]:n.type,s=a.parse(r,1+o.length,i);if(!s){l=!0;break}o.push(s);}if(!l)if(Array.isArray(n)&&n.length!==o.length)a.error(`Expected ${n.length} arguments, but found ${o.length} instead.`);else {for(let e=0;e<o.length;e++){const t=Array.isArray(n)?n[e]:n.type,r=o[e];a.concat(e+1).checkSubtype(t,r.type);}if(0===a.errors.length)return new Dn(r,i,s,o)}}if(1===o.length)t.errors.push(...a.errors);else {const r=(o.length?o:s).map((([e])=>{return t=e,Array.isArray(t)?`(${t.map(Ke).join(", ")})`:`(${Ke(t.type)}...)`;var t;})).join(" | "),n=[];for(let r=1;r<e.length;r++){const i=t.parse(e[r],1+n.length);if(!i)return null;n.push(Ke(i.type));}t.error(`Expected arguments of type ${r}, but found (${n.join(", ")}) instead.`);}return null}static register(e,t){Dn.definitions=t;for(const r in t)e[r]=Dn;}}function Pn(e,[t,r,n,i]){t=t.evaluate(e),r=r.evaluate(e),n=n.evaluate(e);const s=i?i.evaluate(e):1,o=Rt(t,r,n,s);if(o)throw new zt(o);return new It(t/255,r/255,n/255,s,!1)}function Bn(e,t){return e in t}function zn(e,t){const r=t[e];return void 0===r?null:r}function Vn(e){return {type:e}}function Cn(e){if(e instanceof Jt)return Cn(e.boundExpression);if(e instanceof Dn&&"error"===e.name)return !1;if(e instanceof Tr)return !1;if(e instanceof Zr)return !1;if(e instanceof Mn)return !1;if(e instanceof kn)return !1;const t=e instanceof Yt||e instanceof Gt;let r=!0;return e.eachChild((e=>{r=t?r&&Cn(e):r&&e instanceof qt;})),!!r&&Ln(e)&&Rn(e,["zoom","heatmap-density","elevation","line-progress","accumulated","is-supported-script"])}function Ln(e){if(e instanceof Dn){if("get"===e.name&&1===e.args.length)return !1;if("feature-state"===e.name)return !1;if("has"===e.name&&1===e.args.length)return !1;if("properties"===e.name||"geometry-type"===e.name||"id"===e.name)return !1;if(/^filter-/.test(e.name))return !1}if(e instanceof Zr)return !1;if(e instanceof Mn)return !1;let t=!0;return e.eachChild((e=>{t&&!Ln(e)&&(t=!1);})),t}function On(e){if(e instanceof Dn&&"feature-state"===e.name)return !1;let t=!0;return e.eachChild((e=>{t&&!On(e)&&(t=!1);})),t}function Rn(e,t){if(e instanceof Dn&&t.indexOf(e.name)>=0)return !1;let r=!0;return e.eachChild((e=>{r&&!Rn(e,t)&&(r=!1);})),r}function Nn(e){return {result:"success",value:e}}function $n(e){return {result:"error",value:e}}function Un(e){return "data-driven"===e["property-type"]||"cross-faded-data-driven"===e["property-type"]}function qn(e){return !!e.expression&&e.expression.parameters.indexOf("zoom")>-1}function jn(e){return !!e.expression&&e.expression.interpolated}function Gn(e){return e instanceof Number?"number":e instanceof String?"string":e instanceof Boolean?"boolean":Array.isArray(e)?"array":null===e?"null":typeof e}function Xn(e){return "object"==typeof e&&null!==e&&!Array.isArray(e)&&$t(e)===Ne}function Yn(e){return e}function Zn(e,t){const r=e.stops&&"object"==typeof e.stops[0][0],n=r||!(r||void 0!==e.property),i=e.type||(jn(t)?"exponential":"interval"),s=function(e){switch(e.type){case "color":return It.parse;case "padding":return Dt.parse;case "numberArray":return Pt.parse;case "colorArray":return Bt.parse;default:return null}}(t);if(s&&((e=De({},e)).stops&&(e.stops=e.stops.map((e=>[e[0],s(e[1])]))),e.default=s(e.default?e.default:t.default)),e.colorSpace&&"rgb"!==(o=e.colorSpace)&&"hcl"!==o&&"lab"!==o)throw new Error(`Unknown color space: "${e.colorSpace}"`);var o;const a=function(e){switch(e){case "exponential":return Jn;case "interval":return Wn;case "categorical":return Kn;case "identity":return Qn;default:throw new Error(`Unknown function type "${e}"`)}}(i);let l,u;if("categorical"===i){l=Object.create(null);for(const t of e.stops)l[t[0]]=t[1];u=typeof e.stops[0][0];}if(r){const r={},n=[];for(let t=0;t<e.stops.length;t++){const i=e.stops[t],s=i[0].zoom;void 0===r[s]&&(r[s]={zoom:s,type:e.type,property:e.property,default:e.default,stops:[]},n.push(s)),r[s].stops.push([i[0].value,i[1]]);}const i=[];for(const e of n)i.push([r[e].zoom,Zn(r[e],t)]);const s={name:"linear"};return {kind:"composite",interpolationType:s,interpolationFactor:pr.interpolationFactor.bind(void 0,s),zoomStops:i.map((e=>e[0])),evaluate:({zoom:r},n)=>Jn({stops:i,base:e.base},t,r).evaluate(r,n)}}if(n){const r="exponential"===i?{name:"exponential",base:void 0!==e.base?e.base:1}:null;return {kind:"camera",interpolationType:r,interpolationFactor:pr.interpolationFactor.bind(void 0,r),zoomStops:e.stops.map((e=>e[0])),evaluate:({zoom:r})=>a(e,t,r,l,u)}}return {kind:"source",evaluate(r,n){const i=n&&n.properties?n.properties[e.property]:void 0;return void 0===i?Hn(e.default,t.default):a(e,t,i,l,u)}}}function Hn(e,t,r){return void 0!==e?e:void 0!==t?t:void 0!==r?r:void 0}function Kn(e,t,r,n,i){return Hn(typeof r===i?n[r]:void 0,e.default,t.default)}function Wn(e,t,r){if("number"!==Gn(r))return Hn(e.default,t.default);const n=e.stops.length;if(1===n)return e.stops[0][1];if(r<=e.stops[0][0])return e.stops[0][1];if(r>=e.stops[n-1][0])return e.stops[n-1][1];const i=sr(e.stops.map((e=>e[0])),r);return e.stops[i][1]}function Jn(e,t,r){const n=void 0!==e.base?e.base:1;if("number"!==Gn(r))return Hn(e.default,t.default);const i=e.stops.length;if(1===i)return e.stops[0][1];if(r<=e.stops[0][0])return e.stops[0][1];if(r>=e.stops[i-1][0])return e.stops[i-1][1];const s=sr(e.stops.map((e=>e[0])),r),o=function(e,t,r,n){const i=n-r,s=e-r;return 0===i?0:1===t?s/i:(Math.pow(t,s)-1)/(Math.pow(t,i)-1)}(r,n,e.stops[s][0],e.stops[s+1][0]),a=e.stops[s][1],l=e.stops[s+1][1],u=dr[t.type]||Yn;return "function"==typeof a.evaluate?{evaluate(...t){const r=a.evaluate.apply(void 0,t),n=l.evaluate.apply(void 0,t);if(void 0!==r&&void 0!==n)return u(r,n,o,e.colorSpace)}}:u(a,l,o,e.colorSpace)}function Qn(e,t,r){switch(t.type){case "color":r=It.parse(r);break;case "formatted":r=Ft.fromString(r.toString());break;case "resolvedImage":r=Lt.fromString(r.toString());break;case "padding":r=Dt.parse(r);break;case "colorArray":r=Bt.parse(r);break;case "numberArray":r=Pt.parse(r);break;default:Gn(r)===t.type||"enum"===t.type&&t.values[r]||(r=void 0);}return Hn(r,e.default,t.default)}Dn.register(Fn,{error:[{kind:"error"},[Ce],(e,[t])=>{throw new zt(t.evaluate(e))}],typeof:[Ce,[$e],(e,[t])=>Ke($t(t.evaluate(e)))],"to-rgba":[He(Ve,4),[Oe],(e,[t])=>{const[r,n,i,s]=t.evaluate(e).rgb;return [255*r,255*n,255*i,s]}],rgb:[Oe,[Ve,Ve,Ve],Pn],rgba:[Oe,[Ve,Ve,Ve,Ve],Pn],has:{type:Le,overloads:[[[Ce],(e,[t])=>Bn(t.evaluate(e),e.properties())],[[Ce,Ne],(e,[t,r])=>Bn(t.evaluate(e),r.evaluate(e))]]},get:{type:$e,overloads:[[[Ce],(e,[t])=>zn(t.evaluate(e),e.properties())],[[Ce,Ne],(e,[t,r])=>zn(t.evaluate(e),r.evaluate(e))]]},"feature-state":[$e,[Ce],(e,[t])=>zn(t.evaluate(e),e.featureState||{})],properties:[Ne,[],e=>e.properties()],"geometry-type":[Ce,[],e=>e.geometryType()],id:[$e,[],e=>e.id()],zoom:[Ve,[],e=>e.globals.zoom],"heatmap-density":[Ve,[],e=>e.globals.heatmapDensity||0],elevation:[Ve,[],e=>e.globals.elevation||0],"line-progress":[Ve,[],e=>e.globals.lineProgress||0],accumulated:[$e,[],e=>void 0===e.globals.accumulated?null:e.globals.accumulated],"+":[Ve,Vn(Ve),(e,t)=>{let r=0;for(const n of t)r+=n.evaluate(e);return r}],"*":[Ve,Vn(Ve),(e,t)=>{let r=1;for(const n of t)r*=n.evaluate(e);return r}],"-":{type:Ve,overloads:[[[Ve,Ve],(e,[t,r])=>t.evaluate(e)-r.evaluate(e)],[[Ve],(e,[t])=>-t.evaluate(e)]]},"/":[Ve,[Ve,Ve],(e,[t,r])=>t.evaluate(e)/r.evaluate(e)],"%":[Ve,[Ve,Ve],(e,[t,r])=>t.evaluate(e)%r.evaluate(e)],ln2:[Ve,[],()=>Math.LN2],pi:[Ve,[],()=>Math.PI],e:[Ve,[],()=>Math.E],"^":[Ve,[Ve,Ve],(e,[t,r])=>Math.pow(t.evaluate(e),r.evaluate(e))],sqrt:[Ve,[Ve],(e,[t])=>Math.sqrt(t.evaluate(e))],log10:[Ve,[Ve],(e,[t])=>Math.log(t.evaluate(e))/Math.LN10],ln:[Ve,[Ve],(e,[t])=>Math.log(t.evaluate(e))],log2:[Ve,[Ve],(e,[t])=>Math.log(t.evaluate(e))/Math.LN2],sin:[Ve,[Ve],(e,[t])=>Math.sin(t.evaluate(e))],cos:[Ve,[Ve],(e,[t])=>Math.cos(t.evaluate(e))],tan:[Ve,[Ve],(e,[t])=>Math.tan(t.evaluate(e))],asin:[Ve,[Ve],(e,[t])=>Math.asin(t.evaluate(e))],acos:[Ve,[Ve],(e,[t])=>Math.acos(t.evaluate(e))],atan:[Ve,[Ve],(e,[t])=>Math.atan(t.evaluate(e))],min:[Ve,Vn(Ve),(e,t)=>Math.min(...t.map((t=>t.evaluate(e))))],max:[Ve,Vn(Ve),(e,t)=>Math.max(...t.map((t=>t.evaluate(e))))],abs:[Ve,[Ve],(e,[t])=>Math.abs(t.evaluate(e))],round:[Ve,[Ve],(e,[t])=>{const r=t.evaluate(e);return r<0?-Math.round(-r):Math.round(r)}],floor:[Ve,[Ve],(e,[t])=>Math.floor(t.evaluate(e))],ceil:[Ve,[Ve],(e,[t])=>Math.ceil(t.evaluate(e))],"filter-==":[Le,[Ce,$e],(e,[t,r])=>e.properties()[t.value]===r.value],"filter-id-==":[Le,[$e],(e,[t])=>e.id()===t.value],"filter-type-==":[Le,[Ce],(e,[t])=>e.geometryType()===t.value],"filter-<":[Le,[Ce,$e],(e,[t,r])=>{const n=e.properties()[t.value],i=r.value;return typeof n==typeof i&&n<i}],"filter-id-<":[Le,[$e],(e,[t])=>{const r=e.id(),n=t.value;return typeof r==typeof n&&r<n}],"filter->":[Le,[Ce,$e],(e,[t,r])=>{const n=e.properties()[t.value],i=r.value;return typeof n==typeof i&&n>i}],"filter-id->":[Le,[$e],(e,[t])=>{const r=e.id(),n=t.value;return typeof r==typeof n&&r>n}],"filter-<=":[Le,[Ce,$e],(e,[t,r])=>{const n=e.properties()[t.value],i=r.value;return typeof n==typeof i&&n<=i}],"filter-id-<=":[Le,[$e],(e,[t])=>{const r=e.id(),n=t.value;return typeof r==typeof n&&r<=n}],"filter->=":[Le,[Ce,$e],(e,[t,r])=>{const n=e.properties()[t.value],i=r.value;return typeof n==typeof i&&n>=i}],"filter-id->=":[Le,[$e],(e,[t])=>{const r=e.id(),n=t.value;return typeof r==typeof n&&r>=n}],"filter-has":[Le,[$e],(e,[t])=>t.value in e.properties()],"filter-has-id":[Le,[],e=>null!==e.id()&&void 0!==e.id()],"filter-type-in":[Le,[He(Ce)],(e,[t])=>t.value.indexOf(e.geometryType())>=0],"filter-id-in":[Le,[He($e)],(e,[t])=>t.value.indexOf(e.id())>=0],"filter-in-small":[Le,[Ce,He($e)],(e,[t,r])=>r.value.indexOf(e.properties()[t.value])>=0],"filter-in-large":[Le,[Ce,He($e)],(e,[t,r])=>function(e,t,r,n){for(;r<=n;){const i=r+n>>1;if(t[i]===e)return !0;t[i]>e?n=i-1:r=i+1;}return !1}(e.properties()[t.value],r.value,0,r.value.length-1)],all:{type:Le,overloads:[[[Le,Le],(e,[t,r])=>t.evaluate(e)&&r.evaluate(e)],[Vn(Le),(e,t)=>{for(const r of t)if(!r.evaluate(e))return !1;return !0}]]},any:{type:Le,overloads:[[[Le,Le],(e,[t,r])=>t.evaluate(e)||r.evaluate(e)],[Vn(Le),(e,t)=>{for(const r of t)if(r.evaluate(e))return !0;return !1}]]},"!":[Le,[Le],(e,[t])=>!t.evaluate(e)],"is-supported-script":[Le,[Ce],(e,[t])=>{const r=e.globals&&e.globals.isSupportedScript;return !r||r(t.evaluate(e))}],upcase:[Ce,[Ce],(e,[t])=>t.evaluate(e).toUpperCase()],downcase:[Ce,[Ce],(e,[t])=>t.evaluate(e).toLowerCase()],concat:[Ce,Vn($e),(e,t)=>t.map((t=>Ut(t.evaluate(e)))).join("")],"resolved-locale":[Ce,[Ue],(e,[t])=>t.evaluate(e).resolvedLocale()]});class ei{constructor(e,t,r){this.expression=e,this._warningHistory={},this._evaluator=new Ht,this._defaultValue=t?function(e){if("color"===e.type&&Xn(e.default))return new It(0,0,0,0);switch(e.type){case "color":return It.parse(e.default)||null;case "padding":return Dt.parse(e.default)||null;case "numberArray":return Pt.parse(e.default)||null;case "colorArray":return Bt.parse(e.default)||null;case "variableAnchorOffsetCollection":return Ct.parse(e.default)||null;case "projectionDefinition":return Ot.parse(e.default)||null;default:return void 0===e.default?null:e.default}}(t):null,this._enumValues=t&&"enum"===t.type?t.values:null,this._globalState=r;}evaluateWithoutErrorHandling(e,t,r,n,i,s){return this._globalState&&(e=ui(e,this._globalState)),this._evaluator.globals=e,this._evaluator.feature=t,this._evaluator.featureState=r,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(e,t,r,n,i,s){this._globalState&&(e=ui(e,this._globalState)),this._evaluator.globals=e,this._evaluator.feature=t||null,this._evaluator.featureState=r||null,this._evaluator.canonical=n,this._evaluator.availableImages=i||null,this._evaluator.formattedSection=s||null;try{const e=this.expression.evaluate(this._evaluator);if(null==e||"number"==typeof e&&e!=e)return this._defaultValue;if(this._enumValues&&!(e in this._enumValues))throw new zt(`Expected value to be one of ${Object.keys(this._enumValues).map((e=>JSON.stringify(e))).join(", ")}, but found ${JSON.stringify(e)} instead.`);return e}catch(e){return this._warningHistory[e.message]||(this._warningHistory[e.message]=!0,"undefined"!=typeof console&&console.warn(e.message)),this._defaultValue}}}function ti(e){return Array.isArray(e)&&e.length>0&&"string"==typeof e[0]&&e[0]in Fn}function ri(e,t,r){const n=new Kt(Fn,Cn,[],t?function(e){const t={color:Oe,string:Ce,number:Ve,enum:Ce,boolean:Le,formatted:qe,padding:je,numberArray:Xe,colorArray:Ge,projectionDefinition:Re,resolvedImage:Ye,variableAnchorOffsetCollection:Ze};return "array"===e.type?He(t[e.value]||$e,e.length):t[e.type]}(t):void 0),i=n.parse(e,void 0,void 0,void 0,t&&"string"===t.type?{typeAnnotation:"coerce"}:void 0);return i?Nn(new ei(i,t,r)):$n(n.errors)}class ni{constructor(e,t,r){this.kind=e,this._styleExpression=t,this.isStateDependent="constant"!==e&&!On(t.expression),this.globalStateRefs=li(t.expression),this._globalState=r;}evaluateWithoutErrorHandling(e,t,r,n,i,s){return this._globalState&&(e=ui(e,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(e,t,r,n,i,s)}evaluate(e,t,r,n,i,s){return this._globalState&&(e=ui(e,this._globalState)),this._styleExpression.evaluate(e,t,r,n,i,s)}}class ii{constructor(e,t,r,n,i){this.kind=e,this.zoomStops=r,this._styleExpression=t,this.isStateDependent="camera"!==e&&!On(t.expression),this.globalStateRefs=li(t.expression),this.interpolationType=n,this._globalState=i;}evaluateWithoutErrorHandling(e,t,r,n,i,s){return this._globalState&&(e=ui(e,this._globalState)),this._styleExpression.evaluateWithoutErrorHandling(e,t,r,n,i,s)}evaluate(e,t,r,n,i,s){return this._globalState&&(e=ui(e,this._globalState)),this._styleExpression.evaluate(e,t,r,n,i,s)}interpolationFactor(e,t,r){return this.interpolationType?pr.interpolationFactor(this.interpolationType,e,t,r):0}}function si(e,t,r){const n=ri(e,t,r);if("error"===n.result)return n;const i=n.value.expression,s=Ln(i);if(!s&&!Un(t))return $n([new Pe("","data expressions not supported")]);const o=Rn(i,["zoom"]);if(!o&&!qn(t))return $n([new Pe("","zoom expressions not supported")]);const a=ai(i);return a||o?a instanceof Pe?$n([a]):a instanceof pr&&!jn(t)?$n([new Pe("",'"interpolate" expressions cannot be used with this property')]):Nn(a?new ii(s?"camera":"composite",n.value,a.labels,a instanceof pr?a.interpolation:void 0,r):new ni(s?"constant":"source",n.value,r)):$n([new Pe("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class oi{constructor(e,t){this._parameters=e,this._specification=t,De(this,Zn(this._parameters,this._specification));}static deserialize(e){return new oi(e._parameters,e._specification)}static serialize(e){return {_parameters:e._parameters,_specification:e._specification}}}function ai(e){let t=null;if(e instanceof Wt)t=ai(e.result);else if(e instanceof yr){for(const r of e.args)if(t=ai(r),t)break}else (e instanceof or||e instanceof pr)&&e.input instanceof Dn&&"zoom"===e.input.name&&(t=e);return t instanceof Pe||e.eachChild((e=>{const r=ai(e);r instanceof Pe?t=r:!t&&r?t=new Pe("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):t&&r&&t!==r&&(t=new Pe("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));})),t}function li(e,t=new Set){return e instanceof kn&&t.add(e.key),e.eachChild((e=>{li(e,t);})),t}function ui(e,t){const{zoom:r,heatmapDensity:n,elevation:i,lineProgress:s,isSupportedScript:o,accumulated:a}=null!=e?e:{};return {zoom:r,heatmapDensity:n,elevation:i,lineProgress:s,isSupportedScript:o,accumulated:a,globalState:t}}function ci(e){if(!0===e||!1===e)return !0;if(!Array.isArray(e)||0===e.length)return !1;switch(e[0]){case "has":return e.length>=2&&"$id"!==e[1]&&"$type"!==e[1];case "in":return e.length>=3&&("string"!=typeof e[1]||Array.isArray(e[2]));case "!in":case "!has":case "none":return !1;case "==":case "!=":case ">":case ">=":case "<":case "<=":return 3!==e.length||Array.isArray(e[1])||Array.isArray(e[2]);case "any":case "all":for(const t of e.slice(1))if(!ci(t)&&"boolean"!=typeof t)return !1;return !0;default:return !0}}const hi={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function pi(e,t){if(null==e)return {filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set};ci(e)||(e=yi(e));const r=ri(e,hi,t);if("error"===r.result)throw new Error(r.value.map((e=>`${e.key}: ${e.message}`)).join(", "));return {filter:(e,t,n)=>r.value.evaluate(e,t,{},n),needGeometry:di(e),getGlobalStateRefs:()=>li(r.value.expression)}}function fi(e,t){return e<t?-1:e>t?1:0}function di(e){if(!Array.isArray(e))return !1;if("within"===e[0]||"distance"===e[0])return !0;for(let t=1;t<e.length;t++)if(di(e[t]))return !0;return !1}function yi(e){if(!e)return !0;const t=e[0];return e.length<=1?"any"!==t:"=="===t?mi(e[1],e[2],"=="):"!="===t?vi(mi(e[1],e[2],"==")):"<"===t||">"===t||"<="===t||">="===t?mi(e[1],e[2],t):"any"===t?(r=e.slice(1),["any"].concat(r.map(yi))):"all"===t?["all"].concat(e.slice(1).map(yi)):"none"===t?["all"].concat(e.slice(1).map(yi).map(vi)):"in"===t?gi(e[1],e.slice(2)):"!in"===t?vi(gi(e[1],e.slice(2))):"has"===t?xi(e[1]):"!has"!==t||vi(xi(e[1]));var r;}function mi(e,t,r){switch(e){case "$type":return [`filter-type-${r}`,t];case "$id":return [`filter-id-${r}`,t];default:return [`filter-${r}`,e,t]}}function gi(e,t){if(0===t.length)return !1;switch(e){case "$type":return ["filter-type-in",["literal",t]];case "$id":return ["filter-id-in",["literal",t]];default:return t.length>200&&!t.some((e=>typeof e!=typeof t[0]))?["filter-in-large",e,["literal",t.sort(fi)]]:["filter-in-small",e,["literal",t]]}}function xi(e){switch(e){case "$type":return !0;case "$id":return ["filter-has-id"];default:return ["filter-has",e]}}function vi(e){return ["!",e]}function bi(e){const t=typeof e;if("number"===t||"boolean"===t||"string"===t||null==e)return JSON.stringify(e);if(Array.isArray(e)){let t="[";for(const r of e)t+=`${bi(r)},`;return `${t}]`}const r=Object.keys(e).sort();let n="{";for(let t=0;t<r.length;t++)n+=`${JSON.stringify(r[t])}:${bi(e[r[t]])},`;return `${n}}`}function wi(e){let t="";for(const r of ve)t+=`/${bi(e[r])}`;return t}function _i(e){const t=e.value;return t?[new Fe(e.key,t,"constants have been deprecated as of v8")]:[]}function Si(e){return e instanceof Number||e instanceof String||e instanceof Boolean?e.valueOf():e}function Ai(e){if(Array.isArray(e))return e.map(Ai);if(e instanceof Object&&!(e instanceof Number||e instanceof String||e instanceof Boolean)){const t={};for(const r in e)t[r]=Ai(e[r]);return t}return Si(e)}function Ti(e){const t=e.key,r=e.value,n=e.valueSpec||{},i=e.objectElementValidators||{},s=e.style,o=e.styleSpec,a=e.validateSpec;let l=[];const u=Gn(r);if("object"!==u)return [new Fe(t,r,`object expected, ${u} found`)];for(const e in r){const u=e.split(".")[0],c=xt(n,u)||n["*"];let h;if(xt(i,u))h=i[u];else if(xt(n,u))h=a;else if(i["*"])h=i["*"];else {if(!n["*"]){l.push(new Fe(t,r[e],`unknown property "${e}"`));continue}h=a;}l=l.concat(h({key:(t?`${t}.`:t)+e,value:r[e],valueSpec:c,style:s,styleSpec:o,object:r,objectKey:e,validateSpec:a},r));}for(const e in n)i[e]||n[e].required&&void 0===n[e].default&&void 0===r[e]&&l.push(new Fe(t,r,`missing required property "${e}"`));return l}function Ii(e){const t=e.value,r=e.valueSpec,n=e.style,i=e.styleSpec,s=e.key,o=e.arrayElementValidator||e.validateSpec;if("array"!==Gn(t))return [new Fe(s,t,`array expected, ${Gn(t)} found`)];if(r.length&&t.length!==r.length)return [new Fe(s,t,`array length ${r.length} expected, length ${t.length} found`)];if(r["min-length"]&&t.length<r["min-length"])return [new Fe(s,t,`array length at least ${r["min-length"]} expected, length ${t.length} found`)];let a={type:r.value,values:r.values};i.$version<7&&(a.function=r.function),"object"===Gn(r.value)&&(a=r.value);let l=[];for(let r=0;r<t.length;r++)l=l.concat(o({array:t,arrayIndex:r,value:t[r],valueSpec:a,validateSpec:e.validateSpec,style:n,styleSpec:i,key:`${s}[${r}]`}));return l}function Ei(e){const t=e.key,r=e.value,n=e.valueSpec;let i=Gn(r);return "number"===i&&r!=r&&(i="NaN"),"number"!==i?[new Fe(t,r,`number expected, ${i} found`)]:"minimum"in n&&r<n.minimum?[new Fe(t,r,`${r} is less than the minimum value ${n.minimum}`)]:"maximum"in n&&r>n.maximum?[new Fe(t,r,`${r} is greater than the maximum value ${n.maximum}`)]:[]}function Mi(e){const t=e.valueSpec,r=Si(e.value.type);let n,i,s,o={};const a="categorical"!==r&&void 0===e.value.property,l=!a,u="array"===Gn(e.value.stops)&&"array"===Gn(e.value.stops[0])&&"object"===Gn(e.value.stops[0][0]),c=Ti({key:e.key,value:e.value,valueSpec:e.styleSpec.function,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{stops:function(e){if("identity"===r)return [new Fe(e.key,e.value,'identity function may not have a "stops" property')];let t=[];const n=e.value;return t=t.concat(Ii({key:e.key,value:n,valueSpec:e.valueSpec,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,arrayElementValidator:h})),"array"===Gn(n)&&0===n.length&&t.push(new Fe(e.key,n,"array must have at least one stop")),t},default:function(e){return e.validateSpec({key:e.key,value:e.value,valueSpec:t,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec})}}});return "identity"===r&&a&&c.push(new Fe(e.key,e.value,'missing required property "property"')),"identity"===r||e.value.stops||c.push(new Fe(e.key,e.value,'missing required property "stops"')),"exponential"===r&&e.valueSpec.expression&&!jn(e.valueSpec)&&c.push(new Fe(e.key,e.value,"exponential functions not supported")),e.styleSpec.$version>=8&&(l&&!Un(e.valueSpec)?c.push(new Fe(e.key,e.value,"property functions not supported")):a&&!qn(e.valueSpec)&&c.push(new Fe(e.key,e.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==e.value.property||c.push(new Fe(e.key,e.value,'"property" property is required')),c;function h(e){let r=[];const n=e.value,a=e.key;if("array"!==Gn(n))return [new Fe(a,n,`array expected, ${Gn(n)} found`)];if(2!==n.length)return [new Fe(a,n,`array length 2 expected, length ${n.length} found`)];if(u){if("object"!==Gn(n[0]))return [new Fe(a,n,`object expected, ${Gn(n[0])} found`)];if(void 0===n[0].zoom)return [new Fe(a,n,"object stop key must have zoom")];if(void 0===n[0].value)return [new Fe(a,n,"object stop key must have value")];if(s&&s>Si(n[0].zoom))return [new Fe(a,n[0].zoom,"stop zoom values must appear in ascending order")];Si(n[0].zoom)!==s&&(s=Si(n[0].zoom),i=void 0,o={}),r=r.concat(Ti({key:`${a}[0]`,value:n[0],valueSpec:{zoom:{}},validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{zoom:Ei,value:p}}));}else r=r.concat(p({key:`${a}[0]`,value:n[0],validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec},n));return ti(Ai(n[1]))?r.concat([new Fe(`${a}[1]`,n[1],"expressions are not allowed in function stops.")]):r.concat(e.validateSpec({key:`${a}[1]`,value:n[1],valueSpec:t,validateSpec:e.validateSpec,style:e.style,styleSpec:e.styleSpec}))}function p(e,s){const a=Gn(e.value),l=Si(e.value),u=null!==e.value?e.value:s;if(n){if(a!==n)return [new Fe(e.key,u,`${a} stop domain type must match previous stop domain type ${n}`)]}else n=a;if("number"!==a&&"string"!==a&&"boolean"!==a)return [new Fe(e.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==a&&"categorical"!==r){let n=`number expected, ${a} found`;return Un(t)&&void 0===r&&(n+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Fe(e.key,u,n)]}return "categorical"!==r||"number"!==a||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===a&&void 0!==i&&l<i?[new Fe(e.key,u,"stop domain values must appear in ascending order")]:(i=l,"categorical"===r&&l in o?[new Fe(e.key,u,"stop domain values must be unique")]:(o[l]=!0,[])):[new Fe(e.key,u,`integer expected, found ${l}`)]}}function ki(e){const t=("property"===e.expressionContext?si:ri)(Ai(e.value),e.valueSpec);if("error"===t.result)return t.value.map((t=>new Fe(`${e.key}${t.key}`,e.value,t.message)));const r=t.value.expression||t.value._styleExpression.expression;if("property"===e.expressionContext&&"text-font"===e.propertyKey&&!r.outputDefined())return [new Fe(e.key,e.value,`Invalid data expression for "${e.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===e.expressionContext&&"layout"===e.propertyType&&!On(r))return [new Fe(e.key,e.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===e.expressionContext&&!On(r))return [new Fe(e.key,e.value,'"feature-state" data expressions are not supported with filters.')];if(e.expressionContext&&0===e.expressionContext.indexOf("cluster")){if(!Rn(r,["zoom","feature-state"]))return [new Fe(e.key,e.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===e.expressionContext&&!Ln(r))return [new Fe(e.key,e.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function Fi(e){const t=e.key,r=e.value,n=Gn(r);return "string"!==n?[new Fe(t,r,`color expected, ${n} found`)]:It.parse(String(r))?[]:[new Fe(t,r,`color expected, "${r}" found`)]}function Di(e){const t=e.key,r=e.value,n=e.valueSpec,i=[];return Array.isArray(n.values)?-1===n.values.indexOf(Si(r))&&i.push(new Fe(t,r,`expected one of [${n.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(n.values).indexOf(Si(r))&&i.push(new Fe(t,r,`expected one of [${Object.keys(n.values).join(", ")}], ${JSON.stringify(r)} found`)),i}function Pi(e){return ci(Ai(e.value))?ki(De({},e,{expressionContext:"filter",valueSpec:{value:"boolean"}})):Bi(e)}function Bi(e){const t=e.value,r=e.key;if("array"!==Gn(t))return [new Fe(r,t,`array expected, ${Gn(t)} found`)];const n=e.styleSpec;let i,s=[];if(t.length<1)return [new Fe(r,t,"filter array must have at least 1 element")];switch(s=s.concat(Di({key:`${r}[0]`,value:t[0],valueSpec:n.filter_operator,style:e.style,styleSpec:e.styleSpec})),Si(t[0])){case "<":case "<=":case ">":case ">=":t.length>=2&&"$type"===Si(t[1])&&s.push(new Fe(r,t,`"$type" cannot be use with operator "${t[0]}"`));case "==":case "!=":3!==t.length&&s.push(new Fe(r,t,`filter array for operator "${t[0]}" must have 3 elements`));case "in":case "!in":t.length>=2&&(i=Gn(t[1]),"string"!==i&&s.push(new Fe(`${r}[1]`,t[1],`string expected, ${i} found`)));for(let o=2;o<t.length;o++)i=Gn(t[o]),"$type"===Si(t[1])?s=s.concat(Di({key:`${r}[${o}]`,value:t[o],valueSpec:n.geometry_type,style:e.style,styleSpec:e.styleSpec})):"string"!==i&&"number"!==i&&"boolean"!==i&&s.push(new Fe(`${r}[${o}]`,t[o],`string, number, or boolean expected, ${i} found`));break;case "any":case "all":case "none":for(let n=1;n<t.length;n++)s=s.concat(Bi({key:`${r}[${n}]`,value:t[n],style:e.style,styleSpec:e.styleSpec}));break;case "has":case "!has":i=Gn(t[1]),2!==t.length?s.push(new Fe(r,t,`filter array for "${t[0]}" operator must have 2 elements`)):"string"!==i&&s.push(new Fe(`${r}[1]`,t[1],`string expected, ${i} found`));}return s}function zi(e,t){const r=e.key,n=e.validateSpec,i=e.style,s=e.styleSpec,o=e.value,a=e.objectKey,l=s[`${t}_${e.layerType}`];if(!l)return [];const u=a.match(/^(.*)-transition$/);if("paint"===t&&u&&l[u[1]]&&l[u[1]].transition)return n({key:r,value:o,valueSpec:s.transition,style:i,styleSpec:s});const c=e.valueSpec||l[a];if(!c)return [new Fe(r,o,`unknown property "${a}"`)];let h;if("string"===Gn(o)&&Un(c)&&!c.tokens&&(h=/^{([^}]+)}$/.exec(o)))return [new Fe(r,o,`"${a}" does not support interpolation syntax\nUse an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(h[1])} }\`.`)];const p=[];return "symbol"===e.layerType&&"text-font"===a&&Xn(Ai(o))&&"identity"===Si(o.type)&&p.push(new Fe(r,o,'"text-font" does not support identity functions')),p.concat(n({key:e.key,value:o,valueSpec:c,style:i,styleSpec:s,expressionContext:"property",propertyType:t,propertyKey:a}))}function Vi(e){return zi(e,"paint")}function Ci(e){return zi(e,"layout")}function Li(e){let t=[];const r=e.value,n=e.key,i=e.style,s=e.styleSpec;if("object"!==Gn(r))return [new Fe(n,r,`object expected, ${Gn(r)} found`)];r.type||r.ref||t.push(new Fe(n,r,'either "type" or "ref" is required'));let o=Si(r.type);const a=Si(r.ref);if(r.id){const s=Si(r.id);for(let o=0;o<e.arrayIndex;o++){const e=i.layers[o];Si(e.id)===s&&t.push(new Fe(n,r.id,`duplicate layer id "${r.id}", previously used at line ${e.id.__line__}`));}}if("ref"in r){let e;["type","source","source-layer","filter","layout"].forEach((e=>{e in r&&t.push(new Fe(n,r[e],`"${e}" is prohibited for ref layers`));})),i.layers.forEach((t=>{Si(t.id)===a&&(e=t);})),e?e.ref?t.push(new Fe(n,r.ref,"ref cannot reference another ref layer")):o=Si(e.type):t.push(new Fe(n,r.ref,`ref layer "${a}" not found`));}else if("background"!==o)if(r.source){const e=i.sources&&i.sources[r.source],s=e&&Si(e.type);e?"vector"===s&&"raster"===o?t.push(new Fe(n,r.source,`layer "${r.id}" requires a raster source`)):"raster-dem"!==s&&"hillshade"===o||"raster-dem"!==s&&"color-relief"===o?t.push(new Fe(n,r.source,`layer "${r.id}" requires a raster-dem source`)):"raster"===s&&"raster"!==o?t.push(new Fe(n,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==o&&"color-relief"!==o?t.push(new Fe(n,r.source,"raster-dem source can only be used with layer type 'hillshade' or 'color-relief'.")):"line"!==o||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&e.lineMetrics||t.push(new Fe(n,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):t.push(new Fe(n,r,`layer "${r.id}" must specify a "source-layer"`)):t.push(new Fe(n,r.source,`source "${r.source}" not found`));}else t.push(new Fe(n,r,'missing required property "source"'));return t=t.concat(Ti({key:n,value:r,valueSpec:s.layer,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":()=>[],type:()=>e.validateSpec({key:`${n}.type`,value:r.type,valueSpec:s.layer.type,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,object:r,objectKey:"type"}),filter:Pi,layout:e=>Ti({layer:r,key:e.key,value:e.value,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":e=>Ci(De({layerType:o},e))}}),paint:e=>Ti({layer:r,key:e.key,value:e.value,style:e.style,styleSpec:e.styleSpec,validateSpec:e.validateSpec,objectElementValidators:{"*":e=>Vi(De({layerType:o},e))}})}})),t}function Oi(e){const t=e.value,r=e.key,n=Gn(t);return "string"!==n?[new Fe(r,t,`string expected, ${n} found`)]:[]}const Ri={promoteId:function({key:e,value:t}){if("string"===Gn(t))return Oi({key:e,value:t});{const r=[];for(const n in t)r.push(...Oi({key:`${e}.${n}`,value:t[n]}));return r}}};function Ni(e){const t=e.value,r=e.key,n=e.styleSpec,i=e.style,s=e.validateSpec;if(!t.type)return [new Fe(r,t,'"type" is required')];const o=Si(t.type);let a;switch(o){case "vector":case "raster":return a=Ti({key:r,value:t,valueSpec:n[`source_${o.replace("-","_")}`],style:e.style,styleSpec:n,objectElementValidators:Ri,validateSpec:s}),a;case "raster-dem":return a=function(e){var t;const r=null!==(t=e.sourceName)&&void 0!==t?t:"",n=e.value,i=e.styleSpec,s=i.source_raster_dem,o=e.style;let a=[];const l=Gn(n);if(void 0===n)return a;if("object"!==l)return a.push(new Fe("source_raster_dem",n,`object expected, ${l} found`)),a;const u="custom"===Si(n.encoding),c=["redFactor","greenFactor","blueFactor","baseShift"],h=e.value.encoding?`"${e.value.encoding}"`:"Default";for(const t in n)!u&&c.includes(t)?a.push(new Fe(t,n[t],`In "${r}": "${t}" is only valid when "encoding" is set to "custom". ${h} encoding found`)):s[t]?a=a.concat(e.validateSpec({key:t,value:n[t],valueSpec:s[t],validateSpec:e.validateSpec,style:o,styleSpec:i})):a.push(new Fe(t,n[t],`unknown property "${t}"`));return a}({sourceName:r,value:t,style:e.style,styleSpec:n,validateSpec:s}),a;case "geojson":if(a=Ti({key:r,value:t,valueSpec:n.source_geojson,style:i,styleSpec:n,validateSpec:s,objectElementValidators:Ri}),t.cluster)for(const e in t.clusterProperties){const[n,i]=t.clusterProperties[e],s="string"==typeof n?[n,["accumulated"],["get",e]]:n;a.push(...ki({key:`${r}.${e}.map`,value:i,expressionContext:"cluster-map"})),a.push(...ki({key:`${r}.${e}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return a;case "video":return Ti({key:r,value:t,valueSpec:n.source_video,style:i,validateSpec:s,styleSpec:n});case "image":return Ti({key:r,value:t,valueSpec:n.source_image,style:i,validateSpec:s,styleSpec:n});case "canvas":return [new Fe(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Di({key:`${r}.type`,value:t.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]}})}}function $i(e){const t=e.value,r=e.styleSpec,n=r.light,i=e.style;let s=[];const o=Gn(t);if(void 0===t)return s;if("object"!==o)return s=s.concat([new Fe("light",t,`object expected, ${o} found`)]),s;for(const o in t){const a=o.match(/^(.*)-transition$/);s=s.concat(a&&n[a[1]]&&n[a[1]].transition?e.validateSpec({key:o,value:t[o],valueSpec:r.transition,validateSpec:e.validateSpec,style:i,styleSpec:r}):n[o]?e.validateSpec({key:o,value:t[o],valueSpec:n[o],validateSpec:e.validateSpec,style:i,styleSpec:r}):[new Fe(o,t[o],`unknown property "${o}"`)]);}return s}function Ui(e){const t=e.value,r=e.styleSpec,n=r.sky,i=e.style,s=Gn(t);if(void 0===t)return [];if("object"!==s)return [new Fe("sky",t,`object expected, ${s} found`)];let o=[];for(const s in t)o=o.concat(n[s]?e.validateSpec({key:s,value:t[s],valueSpec:n[s],style:i,styleSpec:r}):[new Fe(s,t[s],`unknown property "${s}"`)]);return o}function qi(e){const t=e.value,r=e.styleSpec,n=r.terrain,i=e.style;let s=[];const o=Gn(t);if(void 0===t)return s;if("object"!==o)return s=s.concat([new Fe("terrain",t,`object expected, ${o} found`)]),s;for(const o in t)s=s.concat(n[o]?e.validateSpec({key:o,value:t[o],valueSpec:n[o],validateSpec:e.validateSpec,style:i,styleSpec:r}):[new Fe(o,t[o],`unknown property "${o}"`)]);return s}function ji(e){let t=[];const r=e.value,n=e.key;if(Array.isArray(r)){const i=[],s=[];for(const o in r)r[o].id&&i.includes(r[o].id)&&t.push(new Fe(n,r,`all the sprites' ids must be unique, but ${r[o].id} is duplicated`)),i.push(r[o].id),r[o].url&&s.includes(r[o].url)&&t.push(new Fe(n,r,`all the sprites' URLs must be unique, but ${r[o].url} is duplicated`)),s.push(r[o].url),t=t.concat(Ti({key:`${n}[${o}]`,value:r[o],valueSpec:{id:{type:"string",required:!0},url:{type:"string",required:!0}},validateSpec:e.validateSpec}));return t}return Oi({key:n,value:r})}function Gi(e){return t=e.value,Boolean(t)&&t.constructor===Object?[]:[new Fe(e.key,e.value,`object expected, ${Gn(e.value)} found`)];var t;}const Xi={"*":()=>[],array:Ii,boolean:function(e){const t=e.value,r=e.key,n=Gn(t);return "boolean"!==n?[new Fe(r,t,`boolean expected, ${n} found`)]:[]},number:Ei,color:Fi,constants:_i,enum:Di,filter:Pi,function:Mi,layer:Li,object:Ti,source:Ni,light:$i,sky:Ui,terrain:qi,projection:function(e){const t=e.value,r=e.styleSpec,n=r.projection,i=e.style,s=Gn(t);if(void 0===t)return [];if("object"!==s)return [new Fe("projection",t,`object expected, ${s} found`)];let o=[];for(const s in t)o=o.concat(n[s]?e.validateSpec({key:s,value:t[s],valueSpec:n[s],style:i,styleSpec:r}):[new Fe(s,t[s],`unknown property "${s}"`)]);return o},projectionDefinition:function(e){const t=e.key;let r=e.value;r=r instanceof String?r.valueOf():r;const n=Gn(r);return "array"!==n||function(e){return Array.isArray(e)&&3===e.length&&"string"==typeof e[0]&&"string"==typeof e[1]&&"number"==typeof e[2]}(r)||function(e){return !!["interpolate","step","literal"].includes(e[0])}(r)?["array","string"].includes(n)?[]:[new Fe(t,r,`projection expected, invalid type "${n}" found`)]:[new Fe(t,r,`projection expected, invalid array ${JSON.stringify(r)} found`)]},string:Oi,formatted:function(e){return 0===Oi(e).length?[]:ki(e)},resolvedImage:function(e){return 0===Oi(e).length?[]:ki(e)},padding:function(e){const t=e.key,r=e.value;if("array"===Gn(r)){if(r.length<1||r.length>4)return [new Fe(t,r,`padding requires 1 to 4 values; ${r.length} values found`)];const n={type:"number"};let i=[];for(let s=0;s<r.length;s++)i=i.concat(e.validateSpec({key:`${t}[${s}]`,value:r[s],validateSpec:e.validateSpec,valueSpec:n}));return i}return Ei({key:t,value:r,valueSpec:{}})},numberArray:function(e){const t=e.key,r=e.value;if("array"===Gn(r)){const n={type:"number"};if(r.length<1)return [new Fe(t,r,"array length at least 1 expected, length 0 found")];let i=[];for(let s=0;s<r.length;s++)i=i.concat(e.validateSpec({key:`${t}[${s}]`,value:r[s],validateSpec:e.validateSpec,valueSpec:n}));return i}return Ei({key:t,value:r,valueSpec:{}})},colorArray:function(e){const t=e.key,r=e.value;if("array"===Gn(r)){if(r.length<1)return [new Fe(t,r,"array length at least 1 expected, length 0 found")];let e=[];for(let n=0;n<r.length;n++)e=e.concat(Fi({key:`${t}[${n}]`,value:r[n]}));return e}return Fi({key:t,value:r})},variableAnchorOffsetCollection:function(e){const t=e.key,r=e.value,n=Gn(r),i=e.styleSpec;if("array"!==n||r.length<1||r.length%2!=0)return [new Fe(t,r,"variableAnchorOffsetCollection requires a non-empty array of even length")];let s=[];for(let n=0;n<r.length;n+=2)s=s.concat(Di({key:`${t}[${n}]`,value:r[n],valueSpec:i.layout_symbol["text-anchor"]})),s=s.concat(Ii({key:`${t}[${n+1}]`,value:r[n+1],valueSpec:{length:2,value:"number"},validateSpec:e.validateSpec,style:e.style,styleSpec:i}));return s},sprite:ji,state:Gi};function Yi(e){const t=e.value,r=e.valueSpec,n=e.styleSpec;return e.validateSpec=Yi,r.expression&&Xn(Si(t))?Mi(e):r.expression&&ti(Ai(t))?ki(e):r.type&&Xi[r.type]?Xi[r.type](e):Ti(De({},e,{valueSpec:r.type?n[r.type]:r}))}function Zi(e){const t=e.value,r=e.key,n=Oi(e);return n.length||(-1===t.indexOf("{fontstack}")&&n.push(new Fe(r,t,'"glyphs" url must include a "{fontstack}" token')),-1===t.indexOf("{range}")&&n.push(new Fe(r,t,'"glyphs" url must include a "{range}" token'))),n}function Hi(e,t=xe){let r=[];return r=r.concat(Yi({key:"",value:e,valueSpec:t.$root,styleSpec:t,style:e,validateSpec:Yi,objectElementValidators:{glyphs:Zi,"*":()=>[]}})),e.constants&&(r=r.concat(_i({key:"constants",value:e.constants}))),Wi(r)}function Ki(e){return function(t){return e(Object.assign({},t,{validateSpec:Yi}))}}function Wi(e){return [].concat(e).sort(((e,t)=>e.line-t.line))}function Ji(e){return function(...t){return Wi(e.apply(this,t))}}Hi.source=Ji(Ki(Ni)),Hi.sprite=Ji(Ki(ji)),Hi.glyphs=Ji(Ki(Zi)),Hi.light=Ji(Ki($i)),Hi.sky=Ji(Ki(Ui)),Hi.terrain=Ji(Ki(qi)),Hi.state=Ji(Ki(Gi)),Hi.layer=Ji(Ki(Li)),Hi.filter=Ji(Ki(Pi)),Hi.paintProperty=Ji(Ki(Vi)),Hi.layoutProperty=Ji(Ki(Ci));const Qi=xe,es=Hi,ts=es.light,rs=es.sky,ns=es.paintProperty,is=es.layoutProperty;function ss(e,t){let r=!1;if(t&&t.length)for(const n of t)e.fire(new me(new Error(n.message))),r=!0;return r}class os{constructor(e,t,r){const n=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;const i=new Int32Array(this.arrayBuffer);e=i[0],this.d=(t=i[1])+2*(r=i[2]);for(let e=0;e<this.d*this.d;e++){const t=i[3+e],r=i[3+e+1];n.push(t===r?null:i.subarray(t,r));}const s=i[3+n.length+1];this.keys=i.subarray(i[3+n.length],s),this.bboxes=i.subarray(s),this.insert=this._insertReadonly;}else {this.d=t+2*r;for(let e=0;e<this.d*this.d;e++)n.push([]);this.keys=[],this.bboxes=[];}this.n=t,this.extent=e,this.padding=r,this.scale=t/e,this.uid=0;const i=r/t*e;this.min=-i,this.max=e+i;}insert(e,t,r,n,i){this._forEachCell(t,r,n,i,this._insertCell,this.uid++,void 0,void 0),this.keys.push(e),this.bboxes.push(t),this.bboxes.push(r),this.bboxes.push(n),this.bboxes.push(i);}_insertReadonly(){throw new Error("Cannot insert into a GridIndex created from an ArrayBuffer.")}_insertCell(e,t,r,n,i,s){this.cells[i].push(s);}query(e,t,r,n,i){const s=this.min,o=this.max;if(e<=s&&t<=s&&o<=r&&o<=n&&!i)return Array.prototype.slice.call(this.keys);{const s=[];return this._forEachCell(e,t,r,n,this._queryCell,s,{},i),s}}_queryCell(e,t,r,n,i,s,o,a){const l=this.cells[i];if(null!==l){const i=this.keys,u=this.bboxes;for(let c=0;c<l.length;c++){const h=l[c];if(void 0===o[h]){const l=4*h;(a?a(u[l+0],u[l+1],u[l+2],u[l+3]):e<=u[l+2]&&t<=u[l+3]&&r>=u[l+0]&&n>=u[l+1])?(o[h]=!0,s.push(i[h])):o[h]=!1;}}}}_forEachCell(e,t,r,n,i,s,o,a){const l=this._convertToCellCoord(e),u=this._convertToCellCoord(t),c=this._convertToCellCoord(r),h=this._convertToCellCoord(n);for(let p=l;p<=c;p++)for(let l=u;l<=h;l++){const u=this.d*l+p;if((!a||a(this._convertFromCellCoord(p),this._convertFromCellCoord(l),this._convertFromCellCoord(p+1),this._convertFromCellCoord(l+1)))&&i.call(this,e,t,r,n,u,s,o,a))return}}_convertFromCellCoord(e){return (e-this.padding)/this.scale}_convertToCellCoord(e){return Math.max(0,Math.min(this.d-1,Math.floor(e*this.scale)+this.padding))}toArrayBuffer(){if(this.arrayBuffer)return this.arrayBuffer;const e=this.cells,t=3+this.cells.length+1+1;let r=0;for(let e=0;e<this.cells.length;e++)r+=this.cells[e].length;const n=new Int32Array(t+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;let i=t;for(let t=0;t<e.length;t++){const r=e[t];n[3+t]=i,n.set(r,i),i+=r.length;}return n[3+e.length]=i,n.set(this.keys,i),i+=this.keys.length,n[3+e.length+1]=i,n.set(this.bboxes,i),i+=this.bboxes.length,n.buffer}static serialize(e,t){const r=e.toArrayBuffer();return t&&t.push(r),{buffer:r}}static deserialize(e){return new os(e.buffer)}}const as={};function ls(e,t,r={}){if(as[e])throw new Error(`${e} is already registered.`);Object.defineProperty(t,"_classRegistryKey",{value:e,writeable:!1}),as[e]={klass:t,omit:r.omit||[],shallow:r.shallow||[]};}ls("Object",Object),ls("Set",Set),ls("TransferableGridIndex",os),ls("Color",It),ls("Error",Error),ls("AJAXError",ue),ls("ResolvedImage",Lt),ls("StylePropertyFunction",oi),ls("StyleExpression",ei,{omit:["_evaluator"]}),ls("ZoomDependentExpression",ii),ls("ZoomConstantExpression",ni),ls("CompoundExpression",Dn,{omit:["_evaluate"]});for(const e in Fn)Fn[e]._classRegistryKey||ls(`Expression_${e}`,Fn[e]);function us(e){return e&&"undefined"!=typeof ArrayBuffer&&(e instanceof ArrayBuffer||e.constructor&&"ArrayBuffer"===e.constructor.name)}function cs(e){return e.$name||e.constructor._classRegistryKey}function hs(e){return !function(e){if(null===e||"object"!=typeof e)return !1;const t=cs(e);return !(!t||"Object"===t)}(e)&&(null==e||"boolean"==typeof e||"number"==typeof e||"string"==typeof e||e instanceof Boolean||e instanceof Number||e instanceof String||e instanceof Date||e instanceof RegExp||e instanceof Blob||e instanceof Error||us(e)||Z(e)||ArrayBuffer.isView(e)||e instanceof ImageData)}function ps(e,t){if(hs(e))return (us(e)||Z(e))&&t&&t.push(e),ArrayBuffer.isView(e)&&t&&t.push(e.buffer),e instanceof ImageData&&t&&t.push(e.data.buffer),e;if(Array.isArray(e)){const r=[];for(const n of e)r.push(ps(n,t));return r}if("object"!=typeof e)throw new Error("can't serialize object of type "+typeof e);const r=cs(e);if(!r)throw new Error(`can't serialize object of unregistered class ${e.constructor.name}`);if(!as[r])throw new Error(`${r} is not registered.`);const{klass:n}=as[r],i=n.serialize?n.serialize(e,t):{};if(n.serialize){if(t&&i===t[t.length-1])throw new Error("statically serialized object won't survive transfer of $name property")}else {for(const n in e){if(!e.hasOwnProperty(n))continue;if(as[r].omit.indexOf(n)>=0)continue;const s=e[n];i[n]=as[r].shallow.indexOf(n)>=0?s:ps(s,t);}e instanceof Error&&(i.message=e.message);}if(i.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==r&&(i.$name=r),i}function fs(e){if(hs(e))return e;if(Array.isArray(e))return e.map(fs);if("object"!=typeof e)throw new Error("can't deserialize object of type "+typeof e);const t=cs(e)||"Object";if(!as[t])throw new Error(`can't deserialize unregistered class ${t}`);const{klass:r}=as[t];if(!r)throw new Error(`can't deserialize unregistered class ${t}`);if(r.deserialize)return r.deserialize(e);const n=Object.create(r.prototype);for(const r of Object.keys(e)){if("$name"===r)continue;const i=e[r];n[r]=as[t].shallow.indexOf(r)>=0?i:fs(i);}return n}class ds{constructor(){this.first=!0;}update(e,t){const r=Math.floor(e);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=e,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=t):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=t),e!==this.lastZoom&&(this.lastZoom=e,this.lastFloorZoom=r,!0))}}function ys(e){return /[\u02EA\u02EB\u2E80-\u2FDF\u2FF0-\u303F\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FD-\u30FF\u3105-\u312F\u31A0-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE4F\uFF00-\uFFEF]|\uD81B[\uDFE0-\uDFFF]|[\uD81C-\uD822\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFFF]|\uD82C[\uDC00-\uDEFB]|\uD83C[\uDE00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(e))}function ms(e){return /[\u02EA\u02EB\u1100-\u11FF\u1400-\u167F\u18B0-\u18F5\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u3007\u3012\u3013\u3020-\u302F\u3031-\u303F\u3041-\u3096\u309D-\u30FB\u30FD-\u30FF\u3105-\u312F\u3131-\u318E\u3190-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE48\uFE50-\uFE57\uFE5F-\uFE62\uFE67-\uFE6F\uFF00-\uFF07\uFF0A-\uFF0C\uFF0E-\uFF19\uFF1F-\uFF3A\uFF3C\uFF3E\uFF40-\uFF5A\uFFE0-\uFFE2\uFFE4-\uFFE7]|\uD802[\uDD80-\uDD9F]|\uD805[\uDD80-\uDDFF]|\uD806[\uDE00-\uDEBF]|\uD811[\uDC00-\uDE7F]|\uD81B[\uDFE0-\uDFE4\uDFF0-\uDFF6]|[\uD81C-\uD822\uD83D\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD30-\uDEFB]|\uD833[\uDEC0-\uDFCF]|\uD834[\uDC00-\uDDFF\uDEE0-\uDF7F]|\uD836[\uDC00-\uDEAF]|\uD83C[\uDC00-\uDE00\uDF00-\uDFFF]|\uD83E[\uDD00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(e))}function gs(e){return /\s/u.test(String.fromCodePoint(e))}function xs(e){for(const t of e)if(ms(t.codePointAt(0)))return !0;return !1}function vs(e){for(const t of e)if(!_s(t.codePointAt(0)))return !1;return !0}function bs(e){const t=e.map((e=>{try{return new RegExp(`\\p{sc=${e}}`,"u").source}catch(e){return null}})).filter((e=>e));return new RegExp(t.join("|"),"u")}const ws=bs(["Arab","Dupl","Mong","Ougr","Syrc"]);function _s(e){return !ws.test(String.fromCodePoint(e))}function Ss(e){return !(ms(e)||(t=e,/[\xA7\xA9\xAE\xB1\xBC-\xBE\xD7\xF7\u2016\u2020\u2021\u2030\u2031\u203B\u203C\u2042\u2047-\u2049\u2051\u2100-\u218F\u221E\u2234\u2235\u2300-\u2307\u230C-\u231F\u2324-\u2328\u232B\u237D-\u239A\u23BE-\u23CD\u23CF\u23D1-\u23DB\u23E2-\u2422\u2424-\u24FF\u25A0-\u2619\u2620-\u2767\u2776-\u2793\u2B12-\u2B2F\u2B50-\u2B59\u2BB8-\u2BEB\u3000-\u303F\u30A0-\u30FF\uE000-\uF8FF\uFE30-\uFE6F\uFF00-\uFFEF\uFFFC\uFFFD]|[\uDB80-\uDBFF][\uDC00-\uDFFF]/gim.test(String.fromCodePoint(t))));var t;}const As=bs(["Adlm","Arab","Armi","Avst","Chrs","Cprt","Egyp","Elym","Gara","Hatr","Hebr","Hung","Khar","Lydi","Mand","Mani","Mend","Merc","Mero","Narb","Nbat","Nkoo","Orkh","Palm","Phli","Phlp","Phnx","Prti","Rohg","Samr","Sarb","Sogo","Syrc","Thaa","Todr","Yezi"]);function Ts(e){return As.test(String.fromCodePoint(e))}function Is(e,t){return !(!t&&Ts(e)||/[\u0900-\u0DFF\u0F00-\u109F\u1780-\u17FF]/gim.test(String.fromCodePoint(e)))}function Es(e){for(const t of e)if(Ts(t.codePointAt(0)))return !0;return !1}const Ms=new class{constructor(){this.TIMEOUT=5e3,this.applyArabicShaping=null,this.processBidirectionalText=null,this.processStyledBidirectionalText=null,this.pluginStatus="unavailable",this.pluginURL=null,this.loadScriptResolve=()=>{};}setState(e){this.pluginStatus=e.pluginStatus,this.pluginURL=e.pluginURL;}getState(){return {pluginStatus:this.pluginStatus,pluginURL:this.pluginURL}}setMethods(e){if(Ms.isParsed())throw new Error("RTL text plugin already registered.");this.applyArabicShaping=e.applyArabicShaping,this.processBidirectionalText=e.processBidirectionalText,this.processStyledBidirectionalText=e.processStyledBidirectionalText,this.loadScriptResolve();}isParsed(){return null!=this.applyArabicShaping&&null!=this.processBidirectionalText&&null!=this.processStyledBidirectionalText}getRTLTextPluginStatus(){return this.pluginStatus}syncState(e,r){return t(this,void 0,void 0,(function*(){if(this.isParsed())return this.getState();if("loading"!==e.pluginStatus)return this.setState(e),e;const t=e.pluginURL,n=new Promise((e=>{this.loadScriptResolve=e;}));r(t);const i=new Promise((e=>setTimeout((()=>e()),this.TIMEOUT)));if(yield Promise.race([n,i]),this.isParsed()){const e={pluginStatus:"loaded",pluginURL:t};return this.setState(e),e}throw this.setState({pluginStatus:"error",pluginURL:""}),new Error(`RTL Text Plugin failed to import scripts from ${t}`)}))}};class ks{constructor(e,t){this.isSupportedScript=Fs,this.zoom=e,t?(this.now=t.now||0,this.fadeDuration=t.fadeDuration||0,this.zoomHistory=t.zoomHistory||new ds,this.transition=t.transition||{}):(this.now=0,this.fadeDuration=0,this.zoomHistory=new ds,this.transition={});}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const e=this.zoom,t=e-Math.floor(e),r=this.crossFadingFactor();return e>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:t+(1-t)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*t}}}function Fs(e){return function(e,t){for(const r of e)if(!Is(r.codePointAt(0),t))return !1;return !0}(e,"loaded"===Ms.getRTLTextPluginStatus())}const Ds="-transition";class Ps{constructor(e,t,r){this.property=e,this.value=t,this.expression=function(e,t,r){if(Xn(e))return new oi(e,t);if(ti(e)){const n=si(e,t,r);if("error"===n.result)throw new Error(n.value.map((e=>`${e.key}: ${e.message}`)).join(", "));return n.value}{let r=e;return "color"===t.type&&"string"==typeof e?r=It.parse(e):"padding"!==t.type||"number"!=typeof e&&!Array.isArray(e)?"numberArray"!==t.type||"number"!=typeof e&&!Array.isArray(e)?"colorArray"!==t.type||"string"!=typeof e&&!Array.isArray(e)?"variableAnchorOffsetCollection"===t.type&&Array.isArray(e)?r=Ct.parse(e):"projectionDefinition"===t.type&&"string"==typeof e&&(r=Ot.parse(e)):r=Bt.parse(e):r=Pt.parse(e):r=Dt.parse(e),{globalStateRefs:new Set,_globalState:null,kind:"constant",evaluate:()=>r}}}(void 0===t?e.specification.default:t,e.specification,r);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}getGlobalStateRefs(){return this.expression.globalStateRefs||new Set}possiblyEvaluate(e,t,r){return this.property.possiblyEvaluate(this,e,t,r)}}class Bs{constructor(e,t){this.property=e,this.value=new Ps(e,void 0,t);}transitioned(e,t){return new Vs(this.property,this.value,t,O({},e.transition,this.transition),e.now)}untransitioned(){return new Vs(this.property,this.value,null,{},0)}}class zs{constructor(e,t){this._properties=e,this._values=Object.create(e.defaultTransitionablePropertyValues),this._globalState=t;}getValue(e){return U(this._values[e].value.value)}setValue(e,t){Object.prototype.hasOwnProperty.call(this._values,e)||(this._values[e]=new Bs(this._values[e].property,this._globalState)),this._values[e].value=new Ps(this._values[e].property,null===t?void 0:U(t),this._globalState);}getTransition(e){return U(this._values[e].transition)}setTransition(e,t){Object.prototype.hasOwnProperty.call(this._values,e)||(this._values[e]=new Bs(this._values[e].property,this._globalState)),this._values[e].transition=U(t)||void 0;}serialize(){const e={};for(const t of Object.keys(this._values)){const r=this.getValue(t);void 0!==r&&(e[t]=r);const n=this.getTransition(t);void 0!==n&&(e[`${t}${Ds}`]=n);}return e}transitioned(e,t){const r=new Cs(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].transitioned(e,t._values[n]);return r}untransitioned(){const e=new Cs(this._properties);for(const t of Object.keys(this._values))e._values[t]=this._values[t].untransitioned();return e}}class Vs{constructor(e,t,r,n,i){this.property=e,this.value=t,this.begin=i+n.delay||0,this.end=this.begin+n.duration||0,e.specification.transition&&(n.delay||n.duration)&&(this.prior=r);}possiblyEvaluate(e,t,r){const n=e.now||0,i=this.value.possiblyEvaluate(e,t,r),s=this.prior;if(s){if(n>this.end)return this.prior=null,i;if(this.value.isDataDriven())return this.prior=null,i;if(n<this.begin)return s.possiblyEvaluate(e,t,r);{const o=(n-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(e,t,r),i,B(o))}}return i}}class Cs{constructor(e){this._properties=e,this._values=Object.create(e.defaultTransitioningPropertyValues);}possiblyEvaluate(e,t,r){const n=new Rs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(e,t,r);return n}hasTransition(){for(const e of Object.keys(this._values))if(this._values[e].prior)return !0;return !1}}class Ls{constructor(e,t){this._properties=e,this._values=Object.create(e.defaultPropertyValues),this._globalState=t;}hasValue(e){return void 0!==this._values[e].value}getValue(e){return U(this._values[e].value)}setValue(e,t){this._values[e]=new Ps(this._values[e].property,null===t?void 0:U(t),this._globalState);}serialize(){const e={};for(const t of Object.keys(this._values)){const r=this.getValue(t);void 0!==r&&(e[t]=r);}return e}possiblyEvaluate(e,t,r){const n=new Rs(this._properties);for(const i of Object.keys(this._values))n._values[i]=this._values[i].possiblyEvaluate(e,t,r);return n}}class Os{constructor(e,t,r){this.property=e,this.value=t,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(e){return "constant"===this.value.kind?this.value.value:e}evaluate(e,t,r,n){return this.property.evaluate(this.value,this.parameters,e,t,r,n)}}class Rs{constructor(e){this._properties=e,this._values=Object.create(e.defaultPossiblyEvaluatedValues);}get(e){return this._values[e]}}class Ns{constructor(e){this.specification=e;}possiblyEvaluate(e,t){if(e.isDataDriven())throw new Error("Value should not be data driven");return e.expression.evaluate(t)}interpolate(e,t,r){const n=dr[this.specification.type];return n?n(e,t,r):e}}class $s{constructor(e,t){this.specification=e,this.overrides=t;}possiblyEvaluate(e,t,r,n){return new Os(this,"constant"===e.expression.kind||"camera"===e.expression.kind?{kind:"constant",value:e.expression.evaluate(t,null,{},r,n)}:e.expression,t)}interpolate(e,t,r){if("constant"!==e.value.kind||"constant"!==t.value.kind)return e;if(void 0===e.value.value||void 0===t.value.value)return new Os(this,{kind:"constant",value:void 0},e.parameters);const n=dr[this.specification.type];if(n){const i=n(e.value.value,t.value.value,r);return new Os(this,{kind:"constant",value:i},e.parameters)}return e}evaluate(e,t,r,n,i,s){return "constant"===e.kind?e.value:e.evaluate(t,r,n,i,s)}}class Us extends $s{possiblyEvaluate(e,t,r,n){if(void 0===e.value)return new Os(this,{kind:"constant",value:void 0},t);if("constant"===e.expression.kind){const i=e.expression.evaluate(t,null,{},r,n),s="resolvedImage"===e.property.specification.type&&"string"!=typeof i?i.name:i,o=this._calculate(s,s,s,t);return new Os(this,{kind:"constant",value:o},t)}if("camera"===e.expression.kind){const r=this._calculate(e.expression.evaluate({zoom:t.zoom-1}),e.expression.evaluate({zoom:t.zoom}),e.expression.evaluate({zoom:t.zoom+1}),t);return new Os(this,{kind:"constant",value:r},t)}return new Os(this,e.expression,t)}evaluate(e,t,r,n,i,s){if("source"===e.kind){const o=e.evaluate(t,r,n,i,s);return this._calculate(o,o,o,t)}return "composite"===e.kind?this._calculate(e.evaluate({zoom:Math.floor(t.zoom)-1},r,n),e.evaluate({zoom:Math.floor(t.zoom)},r,n),e.evaluate({zoom:Math.floor(t.zoom)+1},r,n),t):e.value}_calculate(e,t,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:e,to:t}:{from:r,to:t}}interpolate(e){return e}}class qs{constructor(e){this.specification=e;}possiblyEvaluate(e,t,r,n){if(void 0!==e.value){if("constant"===e.expression.kind){const i=e.expression.evaluate(t,null,{},r,n);return this._calculate(i,i,i,t)}return this._calculate(e.expression.evaluate(new ks(Math.floor(t.zoom-1),t)),e.expression.evaluate(new ks(Math.floor(t.zoom),t)),e.expression.evaluate(new ks(Math.floor(t.zoom+1),t)),t)}}_calculate(e,t,r,n){return n.zoom>n.zoomHistory.lastIntegerZoom?{from:e,to:t}:{from:r,to:t}}interpolate(e){return e}}class js{constructor(e){this.specification=e;}possiblyEvaluate(e,t,r,n){return !!e.expression.evaluate(t,null,{},r,n)}interpolate(){return !1}}class Gs{constructor(e){this.properties=e,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const t in e){const r=e[t];r.specification.overridable&&this.overridableProperties.push(t);const n=this.defaultPropertyValues[t]=new Ps(r,void 0,void 0),i=this.defaultTransitionablePropertyValues[t]=new Bs(r,void 0);this.defaultTransitioningPropertyValues[t]=i.untransitioned(),this.defaultPossiblyEvaluatedValues[t]=n.possiblyEvaluate({});}}}ls("DataDrivenProperty",$s),ls("DataConstantProperty",Ns),ls("CrossFadedDataDrivenProperty",Us),ls("CrossFadedProperty",qs),ls("ColorRampProperty",js);class Xs extends ge{constructor(e,t,r){if(super(),this.id=e.id,this.type=e.type,this._globalState=r,this._featureFilter={filter:()=>!0,needGeometry:!1,getGlobalStateRefs:()=>new Set},"custom"!==e.type&&(this.metadata=e.metadata,this.minzoom=e.minzoom,this.maxzoom=e.maxzoom,"background"!==e.type&&(this.source=e.source,this.sourceLayer=e["source-layer"],this.filter=e.filter,this._featureFilter=pi(e.filter,r)),t.layout&&(this._unevaluatedLayout=new Ls(t.layout,r)),t.paint)){this._transitionablePaint=new zs(t.paint,r);for(const t in e.paint)this.setPaintProperty(t,e.paint[t],{validate:!1});for(const t in e.layout)this.setLayoutProperty(t,e.layout[t],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Rs(t.paint);}}setFilter(e){this.filter=e,this._featureFilter=pi(e,this._globalState);}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(e){return "visibility"===e?this.visibility:this._unevaluatedLayout.getValue(e)}getLayoutAffectingGlobalStateRefs(){const e=new Set;if(this._unevaluatedLayout)for(const t in this._unevaluatedLayout._values){const r=this._unevaluatedLayout._values[t];for(const t of r.getGlobalStateRefs())e.add(t);}for(const t of this._featureFilter.getGlobalStateRefs())e.add(t);return e}getPaintAffectingGlobalStateRefs(){var e;const t=new globalThis.Map;if(this._transitionablePaint)for(const r in this._transitionablePaint._values){const n=this._transitionablePaint._values[r].value;for(const i of n.getGlobalStateRefs()){const s=null!==(e=t.get(i))&&void 0!==e?e:[];s.push({name:r,value:n.value}),t.set(i,s);}}return t}setLayoutProperty(e,t,r={}){null!=t&&this._validate(is,`layers.${this.id}.layout.${e}`,e,t,r)||("visibility"!==e?this._unevaluatedLayout.setValue(e,t):this.visibility=t);}getPaintProperty(e){return e.endsWith(Ds)?this._transitionablePaint.getTransition(e.slice(0,-11)):this._transitionablePaint.getValue(e)}setPaintProperty(e,t,r={}){if(null!=t&&this._validate(ns,`layers.${this.id}.paint.${e}`,e,t,r))return !1;if(e.endsWith(Ds))return this._transitionablePaint.setTransition(e.slice(0,-11),t||void 0),!1;{const r=this._transitionablePaint._values[e],n="cross-faded-data-driven"===r.property.specification["property-type"],i=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(e,t),this._handleSpecialPaintPropertyUpdate(e);const o=this._transitionablePaint._values[e].value;return o.isDataDriven()||i||n||this._handleOverridablePaintPropertyUpdate(e,s,o)}}_handleSpecialPaintPropertyUpdate(e){}_handleOverridablePaintPropertyUpdate(e,t,r){return !1}isHidden(e,t=!1){return !!(this.minzoom&&e<(t?Math.floor(this.minzoom):this.minzoom))||!!(this.maxzoom&&e>=this.maxzoom)||"none"===this.visibility}updateTransitions(e){this._transitioningPaint=this._transitionablePaint.transitioned(e,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(e,t){e.getCrossfadeParameters&&(this._crossfadeParameters=e.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(e,void 0,t)),this.paint=this._transitioningPaint.possiblyEvaluate(e,void 0,t);}serialize(){const e={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(e.layout=e.layout||{},e.layout.visibility=this.visibility),$(e,((e,t)=>!(void 0===e||"layout"===t&&!Object.keys(e).length||"paint"===t&&!Object.keys(e).length)))}_validate(e,t,r,n,i={}){return (!i||!1!==i.validate)&&ss(this,e.call(es,{key:t,layerType:this.type,objectKey:r,value:n,styleSpec:xe,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const e in this.paint._values){const t=this.paint.get(e);if(t instanceof Os&&Un(t.property.specification)&&("source"===t.value.kind||"composite"===t.value.kind)&&t.value.isStateDependent)return !0}return !1}}let Ys;var Zs={get paint(){return Ys=Ys||new Gs({"raster-opacity":new Ns(xe.paint_raster["raster-opacity"]),"raster-hue-rotate":new Ns(xe.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Ns(xe.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Ns(xe.paint_raster["raster-brightness-max"]),"raster-saturation":new Ns(xe.paint_raster["raster-saturation"]),"raster-contrast":new Ns(xe.paint_raster["raster-contrast"]),"raster-resampling":new Ns(xe.paint_raster["raster-resampling"]),"raster-fade-duration":new Ns(xe.paint_raster["raster-fade-duration"])})}};class Hs extends Xs{constructor(e,t){super(e,Zs,t);}}const Ks={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Ws{constructor(e,t){this._structArray=e,this._pos1=t*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class Js{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(e,t){return e._trim(),t&&(e.isTransferred=!0,t.push(e.arrayBuffer)),{length:e.length,arrayBuffer:e.arrayBuffer}}static deserialize(e){const t=Object.create(this.prototype);return t.arrayBuffer=e.arrayBuffer,t.length=e.length,t.capacity=e.arrayBuffer.byteLength/t.bytesPerElement,t._refreshViews(),t}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(e){this.reserve(e),this.length=e;}reserve(e){if(e>this.capacity){this.capacity=Math.max(e,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const t=this.uint8;this._refreshViews(),t&&this.uint8.set(t);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function Qs(e,t=1){let r=0,n=0;return {members:e.map((e=>{const i=Ks[e.type].BYTES_PER_ELEMENT,s=r=eo(r,Math.max(t,i)),o=e.components||1;return n=Math.max(n,i),r+=i*o,{name:e.name,type:e.type,components:o,offset:s}})),size:eo(r,Math.max(n,t)),alignment:t}}function eo(e,t){return Math.ceil(e/t)*t}class to extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(e,t){const r=this.length;return this.resize(r+1),this.emplace(r,e,t)}emplace(e,t,r){const n=2*e;return this.int16[n+0]=t,this.int16[n+1]=r,e}}to.prototype.bytesPerElement=4,ls("StructArrayLayout2i4",to);class ro extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=3*e;return this.int16[i+0]=t,this.int16[i+1]=r,this.int16[i+2]=n,e}}ro.prototype.bytesPerElement=6,ls("StructArrayLayout3i6",ro);class no extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(e,t,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,e,t,r,n)}emplace(e,t,r,n,i){const s=4*e;return this.int16[s+0]=t,this.int16[s+1]=r,this.int16[s+2]=n,this.int16[s+3]=i,e}}no.prototype.bytesPerElement=8,ls("StructArrayLayout4i8",no);class io extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,r,n,i,s)}emplace(e,t,r,n,i,s,o){const a=6*e;return this.int16[a+0]=t,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,e}}io.prototype.bytesPerElement=12,ls("StructArrayLayout2i4i12",io);class so extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,r,n,i,s)}emplace(e,t,r,n,i,s,o){const a=4*e,l=8*e;return this.int16[a+0]=t,this.int16[a+1]=r,this.uint8[l+4]=n,this.uint8[l+5]=i,this.uint8[l+6]=s,this.uint8[l+7]=o,e}}so.prototype.bytesPerElement=8,ls("StructArrayLayout2i4ub8",so);class oo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(e,t){const r=this.length;return this.resize(r+1),this.emplace(r,e,t)}emplace(e,t,r){const n=2*e;return this.float32[n+0]=t,this.float32[n+1]=r,e}}oo.prototype.bytesPerElement=8,ls("StructArrayLayout2f8",oo);class ao extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s,o,a,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,e,t,r,n,i,s,o,a,l,u)}emplace(e,t,r,n,i,s,o,a,l,u,c){const h=10*e;return this.uint16[h+0]=t,this.uint16[h+1]=r,this.uint16[h+2]=n,this.uint16[h+3]=i,this.uint16[h+4]=s,this.uint16[h+5]=o,this.uint16[h+6]=a,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,e}}ao.prototype.bytesPerElement=20,ls("StructArrayLayout10ui20",ao);class lo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s,o,a){const l=this.length;return this.resize(l+1),this.emplace(l,e,t,r,n,i,s,o,a)}emplace(e,t,r,n,i,s,o,a,l){const u=8*e;return this.uint16[u+0]=t,this.uint16[u+1]=r,this.uint16[u+2]=n,this.uint16[u+3]=i,this.uint16[u+4]=s,this.uint16[u+5]=o,this.uint16[u+6]=a,this.uint16[u+7]=l,e}}lo.prototype.bytesPerElement=16,ls("StructArrayLayout8ui16",lo);class uo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s,o,a,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,e,t,r,n,i,s,o,a,l,u,c,h)}emplace(e,t,r,n,i,s,o,a,l,u,c,h,p){const f=12*e;return this.int16[f+0]=t,this.int16[f+1]=r,this.int16[f+2]=n,this.int16[f+3]=i,this.uint16[f+4]=s,this.uint16[f+5]=o,this.uint16[f+6]=a,this.uint16[f+7]=l,this.int16[f+8]=u,this.int16[f+9]=c,this.int16[f+10]=h,this.int16[f+11]=p,e}}uo.prototype.bytesPerElement=24,ls("StructArrayLayout4i4ui4i24",uo);class co extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=3*e;return this.float32[i+0]=t,this.float32[i+1]=r,this.float32[i+2]=n,e}}co.prototype.bytesPerElement=12,ls("StructArrayLayout3f12",co);class ho extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint32[1*e+0]=t,e}}ho.prototype.bytesPerElement=4,ls("StructArrayLayout1ul4",ho);class po extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s,o,a,l){const u=this.length;return this.resize(u+1),this.emplace(u,e,t,r,n,i,s,o,a,l)}emplace(e,t,r,n,i,s,o,a,l,u){const c=10*e,h=5*e;return this.int16[c+0]=t,this.int16[c+1]=r,this.int16[c+2]=n,this.int16[c+3]=i,this.int16[c+4]=s,this.int16[c+5]=o,this.uint32[h+3]=a,this.uint16[c+8]=l,this.uint16[c+9]=u,e}}po.prototype.bytesPerElement=20,ls("StructArrayLayout6i1ul2ui20",po);class fo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,r,n,i,s)}emplace(e,t,r,n,i,s,o){const a=6*e;return this.int16[a+0]=t,this.int16[a+1]=r,this.int16[a+2]=n,this.int16[a+3]=i,this.int16[a+4]=s,this.int16[a+5]=o,e}}fo.prototype.bytesPerElement=12,ls("StructArrayLayout2i2i2i12",fo);class yo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,r,n,i)}emplace(e,t,r,n,i,s){const o=4*e,a=8*e;return this.float32[o+0]=t,this.float32[o+1]=r,this.float32[o+2]=n,this.int16[a+6]=i,this.int16[a+7]=s,e}}yo.prototype.bytesPerElement=16,ls("StructArrayLayout2f1f2i16",yo);class mo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,r,n,i,s)}emplace(e,t,r,n,i,s,o){const a=16*e,l=4*e,u=8*e;return this.uint8[a+0]=t,this.uint8[a+1]=r,this.float32[l+1]=n,this.float32[l+2]=i,this.int16[u+6]=s,this.int16[u+7]=o,e}}mo.prototype.bytesPerElement=16,ls("StructArrayLayout2ub2f2i16",mo);class go extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=3*e;return this.uint16[i+0]=t,this.uint16[i+1]=r,this.uint16[i+2]=n,e}}go.prototype.bytesPerElement=6,ls("StructArrayLayout3ui6",go);class xo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m)}emplace(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g){const x=24*e,v=12*e,b=48*e;return this.int16[x+0]=t,this.int16[x+1]=r,this.uint16[x+2]=n,this.uint16[x+3]=i,this.uint32[v+2]=s,this.uint32[v+3]=o,this.uint32[v+4]=a,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=f,this.uint8[b+37]=d,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,e}}xo.prototype.bytesPerElement=48,ls("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",xo);class vo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,T,I,E){const M=this.length;return this.resize(M+1),this.emplace(M,e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,T,I,E)}emplace(e,t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,T,I,E,M){const k=32*e,F=16*e;return this.int16[k+0]=t,this.int16[k+1]=r,this.int16[k+2]=n,this.int16[k+3]=i,this.int16[k+4]=s,this.int16[k+5]=o,this.int16[k+6]=a,this.int16[k+7]=l,this.uint16[k+8]=u,this.uint16[k+9]=c,this.uint16[k+10]=h,this.uint16[k+11]=p,this.uint16[k+12]=f,this.uint16[k+13]=d,this.uint16[k+14]=y,this.uint16[k+15]=m,this.uint16[k+16]=g,this.uint16[k+17]=x,this.uint16[k+18]=v,this.uint16[k+19]=b,this.uint16[k+20]=w,this.uint16[k+21]=_,this.uint16[k+22]=S,this.uint32[F+12]=A,this.float32[F+13]=T,this.float32[F+14]=I,this.uint16[k+30]=E,this.uint16[k+31]=M,e}}vo.prototype.bytesPerElement=64,ls("StructArrayLayout8i15ui1ul2f2ui64",vo);class bo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.float32[1*e+0]=t,e}}bo.prototype.bytesPerElement=4,ls("StructArrayLayout1f4",bo);class wo extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=3*e;return this.uint16[6*e+0]=t,this.float32[i+1]=r,this.float32[i+2]=n,e}}wo.prototype.bytesPerElement=12,ls("StructArrayLayout1ui2f12",wo);class _o extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(e,t,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,r)}emplace(e,t,r,n){const i=4*e;return this.uint32[2*e+0]=t,this.uint16[i+2]=r,this.uint16[i+3]=n,e}}_o.prototype.bytesPerElement=8,ls("StructArrayLayout1ul2ui8",_o);class So extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(e,t){const r=this.length;return this.resize(r+1),this.emplace(r,e,t)}emplace(e,t,r){const n=2*e;return this.uint16[n+0]=t,this.uint16[n+1]=r,e}}So.prototype.bytesPerElement=4,ls("StructArrayLayout2ui4",So);class Ao extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint16[1*e+0]=t,e}}Ao.prototype.bytesPerElement=2,ls("StructArrayLayout1ui2",Ao);class To extends Js{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(e,t,r,n){const i=this.length;return this.resize(i+1),this.emplace(i,e,t,r,n)}emplace(e,t,r,n,i){const s=4*e;return this.float32[s+0]=t,this.float32[s+1]=r,this.float32[s+2]=n,this.float32[s+3]=i,e}}To.prototype.bytesPerElement=16,ls("StructArrayLayout4f16",To);class Io extends Ws{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.int16[this._pos2+2]}get y1(){return this._structArray.int16[this._pos2+3]}get x2(){return this._structArray.int16[this._pos2+4]}get y2(){return this._structArray.int16[this._pos2+5]}get featureIndex(){return this._structArray.uint32[this._pos4+3]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+8]}get bucketIndex(){return this._structArray.uint16[this._pos2+9]}get anchorPoint(){return new r(this.anchorPointX,this.anchorPointY)}}Io.prototype.size=20;class Eo extends po{get(e){return new Io(this,e)}}ls("CollisionBoxArray",Eo);class Mo extends Ws{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(e){this._structArray.uint8[this._pos1+37]=e;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(e){this._structArray.uint8[this._pos1+38]=e;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(e){this._structArray.uint32[this._pos4+10]=e;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Mo.prototype.size=48;class ko extends xo{get(e){return new Mo(this,e)}}ls("PlacedSymbolArray",ko);class Fo extends Ws{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(e){this._structArray.uint32[this._pos4+12]=e;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+14]}get textAnchorOffsetStartIndex(){return this._structArray.uint16[this._pos2+30]}get textAnchorOffsetEndIndex(){return this._structArray.uint16[this._pos2+31]}}Fo.prototype.size=64;class Do extends vo{get(e){return new Fo(this,e)}}ls("SymbolInstanceArray",Do);class Po extends bo{getoffsetX(e){return this.float32[1*e+0]}}ls("GlyphOffsetArray",Po);class Bo extends ro{getx(e){return this.int16[3*e+0]}gety(e){return this.int16[3*e+1]}gettileUnitDistanceFromAnchor(e){return this.int16[3*e+2]}}ls("SymbolLineVertexArray",Bo);class zo extends Ws{get textAnchor(){return this._structArray.uint16[this._pos2+0]}get textOffset0(){return this._structArray.float32[this._pos4+1]}get textOffset1(){return this._structArray.float32[this._pos4+2]}}zo.prototype.size=12;class Vo extends wo{get(e){return new zo(this,e)}}ls("TextAnchorOffsetArray",Vo);class Co extends Ws{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}}Co.prototype.size=8;class Lo extends _o{get(e){return new Co(this,e)}}ls("FeatureIndexArray",Lo);class Oo extends to{}class Ro extends to{}class No extends to{}class $o extends io{}class Uo extends so{}class qo extends oo{}class jo extends ao{}class Go extends lo{}class Xo extends uo{}class Yo extends co{}class Zo extends ho{}class Ho extends fo{}class Ko extends mo{}class Wo extends go{}class Jo extends So{}const Qo=Qs([{name:"a_pos",components:2,type:"Int16"}],4),{members:ea}=Qo;class ta{constructor(e=[]){this._forceNewSegmentOnNextPrepare=!1,this.segments=e;}prepareSegment(e,t,r,n){const i=this.segments[this.segments.length-1];return e>ta.MAX_VERTEX_ARRAY_LENGTH&&j(`Max vertices per segment is ${ta.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${e}. Consider using the \`fillLargeMeshArrays\` function if you require meshes with more than ${ta.MAX_VERTEX_ARRAY_LENGTH} vertices.`),this._forceNewSegmentOnNextPrepare||!i||i.vertexLength+e>ta.MAX_VERTEX_ARRAY_LENGTH||i.sortKey!==n?this.createNewSegment(t,r,n):i}createNewSegment(e,t,r){const n={vertexOffset:e.length,primitiveOffset:t.length,vertexLength:0,primitiveLength:0,vaos:{}};return void 0!==r&&(n.sortKey=r),this._forceNewSegmentOnNextPrepare=!1,this.segments.push(n),n}getOrCreateLatestSegment(e,t,r){return this.prepareSegment(0,e,t,r)}forceNewSegmentOnNextPrepare(){this._forceNewSegmentOnNextPrepare=!0;}get(){return this.segments}destroy(){for(const e of this.segments)for(const t in e.vaos)e.vaos[t].destroy();}static simpleSegment(e,t,r,n){return new ta([{vertexOffset:e,primitiveOffset:t,vertexLength:r,primitiveLength:n,vaos:{},sortKey:0}])}}function ra(e,t){return 256*(e=C(Math.floor(e),0,255))+C(Math.floor(t),0,255)}ta.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,ls("SegmentVector",ta);const na=Qs([{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"}]),ia=Qs([{name:"a_dasharray_from",components:4,type:"Uint16"},{name:"a_dasharray_to",components:4,type:"Uint16"}]);var sa,oa,aa,la={exports:{}},ua={exports:{}},ca={exports:{}},ha=function(){if(aa)return la.exports;aa=1;var e=(sa||(sa=1,ua.exports=function(e,t){var r,n,i,s,o,a,l,u;for(n=e.length-(r=3&e.length),i=t,o=3432918353,a=461845907,u=0;u<n;)l=255&e.charCodeAt(u)|(255&e.charCodeAt(++u))<<8|(255&e.charCodeAt(++u))<<16|(255&e.charCodeAt(++u))<<24,++u,i=27492+(65535&(s=5*(65535&(i=(i^=l=(65535&(l=(l=(65535&l)*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<13|i>>>19))+((5*(i>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&e.charCodeAt(u+2))<<16;case 2:l^=(255&e.charCodeAt(u+1))<<8;case 1:i^=l=(65535&(l=(l=(65535&(l^=255&e.charCodeAt(u)))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<15|l>>>17))*a+(((l>>>16)*a&65535)<<16)&4294967295;}return i^=e.length,i=2246822507*(65535&(i^=i>>>16))+((2246822507*(i>>>16)&65535)<<16)&4294967295,i=3266489909*(65535&(i^=i>>>13))+((3266489909*(i>>>16)&65535)<<16)&4294967295,(i^=i>>>16)>>>0}),ua.exports),t=(oa||(oa=1,ca.exports=function(e,t){for(var r,n=e.length,i=t^n,s=0;n>=4;)r=1540483477*(65535&(r=255&e.charCodeAt(s)|(255&e.charCodeAt(++s))<<8|(255&e.charCodeAt(++s))<<16|(255&e.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),i=1540483477*(65535&i)+((1540483477*(i>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),n-=4,++s;switch(n){case 3:i^=(255&e.charCodeAt(s+2))<<16;case 2:i^=(255&e.charCodeAt(s+1))<<8;case 1:i=1540483477*(65535&(i^=255&e.charCodeAt(s)))+((1540483477*(i>>>16)&65535)<<16);}return i=1540483477*(65535&(i^=i>>>13))+((1540483477*(i>>>16)&65535)<<16),(i^=i>>>15)>>>0}),ca.exports);return la.exports=e,la.exports.murmur3=e,la.exports.murmur2=t,la.exports}(),pa=n(ha);class fa{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(e,t,r,n){this.ids.push(da(e)),this.positions.push(t,r,n);}getPositions(e){if(!this.indexed)throw new Error("Trying to get index, but feature positions are not indexed");const t=da(e);let r=0,n=this.ids.length-1;for(;r<n;){const e=r+n>>1;this.ids[e]>=t?n=e:r=e+1;}const i=[];for(;this.ids[r]===t;)i.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return i}static serialize(e,t){const r=new Float64Array(e.ids),n=new Uint32Array(e.positions);return ya(r,n,0,r.length-1),t&&t.push(r.buffer,n.buffer),{ids:r,positions:n}}static deserialize(e){const t=new fa;return t.ids=e.ids,t.positions=e.positions,t.indexed=!0,t}}function da(e){const t=+e;return !isNaN(t)&&t<=Number.MAX_SAFE_INTEGER?t:pa(String(e))}function ya(e,t,r,n){for(;r<n;){const i=e[r+n>>1];let s=r-1,o=n+1;for(;;){do{s++;}while(e[s]<i);do{o--;}while(e[o]>i);if(s>=o)break;ma(e,s,o),ma(t,3*s,3*o),ma(t,3*s+1,3*o+1),ma(t,3*s+2,3*o+2);}o-r<n-o?(ya(e,t,r,o),r=o+1):(ya(e,t,o+1,n),n=o);}}function ma(e,t,r){const n=e[t];e[t]=e[r],e[r]=n;}ls("FeaturePositionMap",fa);class ga{constructor(e,t){this.gl=e.gl,this.location=t;}}class xa extends ga{constructor(e,t){super(e,t),this.current=0;}set(e){this.current!==e&&(this.current=e,this.gl.uniform1f(this.location,e));}}class va extends ga{constructor(e,t){super(e,t),this.current=[0,0,0,0];}set(e){e[0]===this.current[0]&&e[1]===this.current[1]&&e[2]===this.current[2]&&e[3]===this.current[3]||(this.current=e,this.gl.uniform4f(this.location,e[0],e[1],e[2],e[3]));}}class ba extends ga{constructor(e,t){super(e,t),this.current=It.transparent;}set(e){e.r===this.current.r&&e.g===this.current.g&&e.b===this.current.b&&e.a===this.current.a||(this.current=e,this.gl.uniform4f(this.location,e.r,e.g,e.b,e.a));}}const wa=new Float32Array(16);function _a(e){return [ra(255*e.r,255*e.g),ra(255*e.b,255*e.a)]}class Sa{constructor(e,t,r){this.value=e,this.uniformNames=t.map((e=>`u_${e}`)),this.type=r;}setUniform(e,t,r){e.set(r.constantOr(this.value));}getBinding(e,t,r){return "color"===this.type?new ba(e,t):new xa(e,t)}}class Aa{constructor(e,t){this.uniformNames=t.map((e=>`u_${e}`)),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(e,t){this.pixelRatioFrom=t.pixelRatio,this.pixelRatioTo=e.pixelRatio,this.patternFrom=t.tlbr,this.patternTo=e.tlbr;}setConstantDashPositions(e,t){this.dashTo=[0,e.y,e.height,e.width],this.dashFrom=[0,t.y,t.height,t.width];}setUniform(e,t,r,n){let i=null;"u_pattern_to"===n?i=this.patternTo:"u_pattern_from"===n?i=this.patternFrom:"u_dasharray_to"===n?i=this.dashTo:"u_dasharray_from"===n?i=this.dashFrom:"u_pixel_ratio_to"===n?i=this.pixelRatioTo:"u_pixel_ratio_from"===n&&(i=this.pixelRatioFrom),null!==i&&e.set(i);}getBinding(e,t,r){return "u_pattern"===r.substr(0,9)||"u_dasharray_"===r.substr(0,12)?new va(e,t):new xa(e,t)}}class Ta{constructor(e,t,r,n){this.expression=e,this.type=r,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===r?2:1,offset:0}))),this.paintVertexArray=new n;}populatePaintArray(e,t,r){const n=this.paintVertexArray.length,i=this.expression.evaluate(new ks(0,r),t,{},r.canonical,[],r.formattedSection);this.paintVertexArray.resize(e),this._setPaintValue(n,e,i);}updatePaintArray(e,t,r,n,i){const s=this.expression.evaluate(new ks(0,i),r,n);this._setPaintValue(e,t,s);}_setPaintValue(e,t,r){if("color"===this.type){const n=_a(r);for(let r=e;r<t;r++)this.paintVertexArray.emplace(r,n[0],n[1]);}else {for(let n=e;n<t;n++)this.paintVertexArray.emplace(n,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class Ia{constructor(e,t,r,n,i,s){this.expression=e,this.uniformNames=t.map((e=>`u_${e}_t`)),this.type=r,this.useIntegerZoom=n,this.zoom=i,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===r?4:2,offset:0}))),this.paintVertexArray=new s;}populatePaintArray(e,t,r){const n=this.expression.evaluate(new ks(this.zoom,r),t,{},r.canonical,[],r.formattedSection),i=this.expression.evaluate(new ks(this.zoom+1,r),t,{},r.canonical,[],r.formattedSection),s=this.paintVertexArray.length;this.paintVertexArray.resize(e),this._setPaintValue(s,e,n,i);}updatePaintArray(e,t,r,n,i){const s=this.expression.evaluate(new ks(this.zoom,i),r,n),o=this.expression.evaluate(new ks(this.zoom+1,i),r,n);this._setPaintValue(e,t,s,o);}_setPaintValue(e,t,r,n){if("color"===this.type){const i=_a(r),s=_a(n);for(let r=e;r<t;r++)this.paintVertexArray.emplace(r,i[0],i[1],s[0],s[1]);}else {for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,r,n);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(n));}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(e,t){const r=this.useIntegerZoom?Math.floor(t.zoom):t.zoom,n=C(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);e.set(n);}getBinding(e,t,r){return new xa(e,t)}}class Ea{constructor(e,t,r,n,i,s){this.expression=e,this.type=t,this.useIntegerZoom=r,this.zoom=n,this.layerId=s,this.zoomInPaintVertexArray=new i,this.zoomOutPaintVertexArray=new i;}populatePaintArray(e,t,r){const n=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(e),this.zoomOutPaintVertexArray.resize(e),this._setPaintValues(n,e,this.getPositionIds(t),r);}updatePaintArray(e,t,r,n,i){this._setPaintValues(e,t,this.getPositionIds(r),i);}_setPaintValues(e,t,r,n){const i=this.getPositions(n);if(!i||!r)return;const s=i[r.min],o=i[r.mid],a=i[r.max];if(s&&o&&a)for(let r=e;r<t;r++)this.emplace(this.zoomInPaintVertexArray,r,o,s),this.emplace(this.zoomOutPaintVertexArray,r,o,a);}upload(e){if(this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer){const t=this.getVertexAttributes();this.zoomInPaintVertexBuffer=e.createVertexBuffer(this.zoomInPaintVertexArray,t,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=e.createVertexBuffer(this.zoomOutPaintVertexArray,t,this.expression.isStateDependent);}}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class Ma extends Ea{getPositions(e){return e.imagePositions}getPositionIds(e){return e.patterns&&e.patterns[this.layerId]}getVertexAttributes(){return na.members}emplace(e,t,r,n){e.emplace(t,r.tlbr[0],r.tlbr[1],r.tlbr[2],r.tlbr[3],n.tlbr[0],n.tlbr[1],n.tlbr[2],n.tlbr[3],r.pixelRatio,n.pixelRatio);}}class ka extends Ea{getPositions(e){return e.dashPositions}getPositionIds(e){return e.dashes&&e.dashes[this.layerId]}getVertexAttributes(){return ia.members}emplace(e,t,r,n){e.emplace(t,0,r.y,r.height,r.width,0,n.y,n.height,n.width);}}class Fa{constructor(e,t,r){this.binders={},this._buffers=[];const n=[];for(const i in e.paint._values){if(!r(i))continue;const s=e.paint.get(i);if(!(s instanceof Os&&Un(s.property.specification)))continue;const o=Pa(i,e.type),a=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===a.kind)this.binders[i]=h?new Aa(a.value,o):new Sa(a.value,o,l),n.push(`/u_${i}`);else if("source"===a.kind||h){const r=Ba(i,l,"source");this.binders[i]=h?"line-dasharray"===i?new ka(a,l,u,t,r,e.id):new Ma(a,l,u,t,r,e.id):new Ta(a,o,l,r),n.push(`/a_${i}`);}else {const e=Ba(i,l,"composite");this.binders[i]=new Ia(a,o,l,u,t,e),n.push(`/z_${i}`);}}this.cacheKey=n.sort().join("");}getMaxValue(e){const t=this.binders[e];return t instanceof Ta||t instanceof Ia?t.maxValue:0}populatePaintArrays(e,t,r){for(const n in this.binders){const i=this.binders[n];(i instanceof Ta||i instanceof Ia||i instanceof Ea)&&i.populatePaintArray(e,t,r);}}setConstantPatternPositions(e,t){for(const r in this.binders){const n=this.binders[r];n instanceof Aa&&n.setConstantPatternPositions(e,t);}}setConstantDashPositions(e,t){for(const r in this.binders){const n=this.binders[r];n instanceof Aa&&n.setConstantDashPositions(e,t);}}updatePaintArrays(e,t,r,n,i){let s=!1;for(const o in e){const a=t.getPositions(o);for(const t of a){const a=r.feature(t.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof Ta||l instanceof Ia||l instanceof Ea)&&!0===l.expression.isStateDependent){const u=n.paint.get(r);l.expression=u.value,l.updatePaintArray(t.start,t.end,a,e[o],i),s=!0;}}}}return s}defines(){const e=[];for(const t in this.binders){const r=this.binders[t];(r instanceof Sa||r instanceof Aa)&&e.push(...r.uniformNames.map((e=>`#define HAS_UNIFORM_${e}`)));}return e}getBinderAttributes(){const e=[];for(const t in this.binders){const r=this.binders[t];if(r instanceof Ta||r instanceof Ia)for(let t=0;t<r.paintVertexAttributes.length;t++)e.push(r.paintVertexAttributes[t].name);else if(r instanceof Ea){const t=r.getVertexAttributes();for(const r of t)e.push(r.name);}}return e}getBinderUniforms(){const e=[];for(const t in this.binders){const r=this.binders[t];if(r instanceof Sa||r instanceof Aa||r instanceof Ia)for(const t of r.uniformNames)e.push(t);}return e}getPaintVertexBuffers(){return this._buffers}getUniforms(e,t){const r=[];for(const n in this.binders){const i=this.binders[n];if(i instanceof Sa||i instanceof Aa||i instanceof Ia)for(const s of i.uniformNames)if(t[s]){const o=i.getBinding(e,t[s],s);r.push({name:s,property:n,binding:o});}}return r}setUniforms(e,t,r,n){for(const{name:e,property:i,binding:s}of t)this.binders[i].setUniform(s,n,r.get(i),e);}updatePaintBuffers(e){this._buffers=[];for(const t in this.binders){const r=this.binders[t];if(e&&r instanceof Ea){const t=2===e.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;t&&this._buffers.push(t);}else (r instanceof Ta||r instanceof Ia)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(e){for(const t in this.binders){const r=this.binders[t];(r instanceof Ta||r instanceof Ia||r instanceof Ea)&&r.upload(e);}this.updatePaintBuffers();}destroy(){for(const e in this.binders){const t=this.binders[e];(t instanceof Ta||t instanceof Ia||t instanceof Ea)&&t.destroy();}}}class Da{constructor(e,t,r=()=>!0){this.programConfigurations={};for(const n of e)this.programConfigurations[n.id]=new Fa(n,t,r);this.needsUpload=!1,this._featureMap=new fa,this._bufferOffset=0;}populatePaintArrays(e,t,r,n){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(e,t,n);void 0!==t.id&&this._featureMap.add(t.id,r,this._bufferOffset,e),this._bufferOffset=e,this.needsUpload=!0;}updatePaintArrays(e,t,r,n){for(const i of r)this.needsUpload=this.programConfigurations[i.id].updatePaintArrays(e,this._featureMap,t,i,n)||this.needsUpload;}get(e){return this.programConfigurations[e]}upload(e){if(this.needsUpload){for(const t in this.programConfigurations)this.programConfigurations[t].upload(e);this.needsUpload=!1;}}destroy(){for(const e in this.programConfigurations)this.programConfigurations[e].destroy();}}function Pa(e,t){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-dasharray":["dasharray_to","dasharray_from"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[e]||[e.replace(`${t}-`,"").replace(/-/g,"_")]}function Ba(e,t,r){const n={color:{source:oo,composite:To},number:{source:bo,composite:oo}},i=function(e){return {"line-pattern":{source:jo,composite:jo},"fill-pattern":{source:jo,composite:jo},"fill-extrusion-pattern":{source:jo,composite:jo},"line-dasharray":{source:Go,composite:Go}}[e]}(e);return i&&i[r]||n[t][r]}ls("ConstantBinder",Sa),ls("CrossFadedConstantBinder",Aa),ls("SourceExpressionBinder",Ta),ls("CrossFadedPatternBinder",Ma),ls("CrossFadedDasharrayBinder",ka),ls("CompositeExpressionBinder",Ia),ls("ProgramConfiguration",Fa,{omit:["_buffers"]}),ls("ProgramConfigurationSet",Da);const za=Math.pow(2,14)-1,Va=-za-1;function Ca(e){const t=k/e.extent,r=e.loadGeometry();for(let e=0;e<r.length;e++){const n=r[e];for(let e=0;e<n.length;e++){const r=n[e],i=Math.round(r.x*t),s=Math.round(r.y*t);r.x=C(i,Va,za),r.y=C(s,Va,za),(i<r.x||i>r.x+1||s<r.y||s>r.y+1)&&j("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function La(e,t){return {type:e.type,id:e.id,properties:e.properties,geometry:t?Ca(e):[]}}const Oa=-32768;function Ra(e,t,r,n,i){e.emplaceBack(Oa+8*t+n,Oa+8*r+i);}class Na{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.layoutVertexArray=new Ro,this.indexArray=new Wo,this.segments=new ta,this.programConfigurations=new Da(e.layers,e.zoom),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id));}populate(e,t,r){const n=this.layers[0],i=[];let s=null,o=!1,a="heatmap"===n.type;if("circle"===n.type){const e=n;s=e.layout.get("circle-sort-key"),o=!s.isConstant(),a=a||"map"===e.paint.get("circle-pitch-alignment");}const l=a?t.subdivisionGranularity.circle:1;for(const{feature:t,id:n,index:a,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,u=La(t,e);if(!this.layers[0]._featureFilter.filter(new ks(this.zoom),u,r))continue;const c=o?s.evaluate(u,{},r):void 0,h={id:n,properties:t.properties,type:t.type,sourceLayerIndex:l,index:a,geometry:e?u.geometry:Ca(t),patterns:{},sortKey:c};i.push(h);}o&&i.sort(((e,t)=>e.sortKey-t.sortKey));for(const n of i){const{geometry:i,index:s,sourceLayerIndex:o}=n,a=e[s].feature;this.addFeature(n,i,s,r,l),t.featureIndex.insert(a,i,s,o,this.index);}}update(e,t,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:r});}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,ea),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(e,t,r,n,i=1){let s;switch(i){case 1:s=[0,7];break;case 3:s=[0,2,5,7];break;case 5:s=[0,1,3,4,6,7];break;case 7:s=[0,1,2,3,4,5,6,7];break;default:throw new Error(`Invalid circle bucket granularity: ${i}; valid values are 1, 3, 5, 7.`)}const o=s.length;for(const r of t)for(const t of r){const r=t.x,n=t.y;if(r<0||r>=k||n<0||n>=k)continue;const i=this.segments.prepareSegment(o*o,this.layoutVertexArray,this.indexArray,e.sortKey),a=i.vertexLength;for(let e=0;e<o;e++)for(let t=0;t<o;t++)Ra(this.layoutVertexArray,r,n,s[t],s[e]);for(let e=0;e<o-1;e++)for(let t=0;t<o-1;t++){const r=a+e*o+t,n=a+(e+1)*o+t;this.indexArray.emplaceBack(r,n+1,r+1),this.indexArray.emplaceBack(r,n,n+1);}i.vertexLength+=o*o,i.primitiveLength+=(o-1)*(o-1)*2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,r,{imagePositions:{},canonical:n});}}function $a(e,t){for(let r=0;r<e.length;r++)if(Ka(t,e[r]))return !0;for(let r=0;r<t.length;r++)if(Ka(e,t[r]))return !0;return !!Ga(e,t)}function Ua(e,t,r){return !!Ka(e,t)||!!Ya(t,e,r)}function qa(e,t){if(1===e.length)return Ha(t,e[0]);for(let r=0;r<t.length;r++){const n=t[r];for(let t=0;t<n.length;t++)if(Ka(e,n[t]))return !0}for(let r=0;r<e.length;r++)if(Ha(t,e[r]))return !0;for(let r=0;r<t.length;r++)if(Ga(e,t[r]))return !0;return !1}function ja(e,t,r){if(e.length>1){if(Ga(e,t))return !0;for(let n=0;n<t.length;n++)if(Ya(t[n],e,r))return !0}for(let n=0;n<e.length;n++)if(Ya(e[n],t,r))return !0;return !1}function Ga(e,t){if(0===e.length||0===t.length)return !1;for(let r=0;r<e.length-1;r++){const n=e[r],i=e[r+1];for(let e=0;e<t.length-1;e++)if(Xa(n,i,t[e],t[e+1]))return !0}return !1}function Xa(e,t,r,n){return G(e,r,n)!==G(t,r,n)&&G(e,t,r)!==G(e,t,n)}function Ya(e,t,r){const n=r*r;if(1===t.length)return e.distSqr(t[0])<n;for(let r=1;r<t.length;r++)if(Za(e,t[r-1],t[r])<n)return !0;return !1}function Za(e,t,r){const n=t.distSqr(r);if(0===n)return e.distSqr(t);const i=((e.x-t.x)*(r.x-t.x)+(e.y-t.y)*(r.y-t.y))/n;return e.distSqr(i<0?t:i>1?r:r.sub(t)._mult(i)._add(t))}function Ha(e,t){let r,n,i,s=!1;for(let o=0;o<e.length;o++){r=e[o];for(let e=0,o=r.length-1;e<r.length;o=e++)n=r[e],i=r[o],n.y>t.y!=i.y>t.y&&t.x<(i.x-n.x)*(t.y-n.y)/(i.y-n.y)+n.x&&(s=!s);}return s}function Ka(e,t){let r=!1;for(let n=0,i=e.length-1;n<e.length;i=n++){const s=e[n],o=e[i];s.y>t.y!=o.y>t.y&&t.x<(o.x-s.x)*(t.y-s.y)/(o.y-s.y)+s.x&&(r=!r);}return r}function Wa(e,t,r){const n=r[0],i=r[2];if(e.x<n.x&&t.x<n.x||e.x>i.x&&t.x>i.x||e.y<n.y&&t.y<n.y||e.y>i.y&&t.y>i.y)return !1;const s=G(e,t,r[0]);return s!==G(e,t,r[1])||s!==G(e,t,r[2])||s!==G(e,t,r[3])}function Ja(e,t,r){const n=t.paint.get(e).value;return "constant"===n.kind?n.value:r.programConfigurations.get(t.id).getMaxValue(e)}function Qa(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])}function el(e,t,n,i,s){if(!t[0]&&!t[1])return e;const o=r.convert(t)._mult(s);"viewport"===n&&o._rotate(-i);const a=[];for(let t=0;t<e.length;t++)a.push(e[t].sub(o));return a}function tl({queryGeometry:e,size:t},r){return Ua(e,r,t)}function rl({queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i},s){return Ua(e,s,t*(r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera/r.cameraToCenterDistance))}function nl({queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i},s){const o=r.projectTileCoordinates(s.x,s.y,n,i).signedDistanceFromCamera,a=t*(r.cameraToCenterDistance/o);return Ua(e,ol(s,r,n,i),a)}function il({queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i},s){return Ua(e,ol(s,r,n,i),t)}function sl({queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i,pitchAlignment:s="map",pitchScale:o="map"},a){const l="map"===s?"map"===o?tl:rl:"map"===o?nl:il,u={queryGeometry:e,size:t,transform:r,unwrappedTileID:n,getElevation:i};for(const e of a)for(const t of e)if(l(u,t))return !0;return !1}function ol(e,t,n,i){const s=t.projectTileCoordinates(e.x,e.y,n,i).point;return new r((.5*s.x+.5)*t.width,(.5*-s.y+.5)*t.height)}let al,ll;ls("CircleBucket",Na,{omit:["layers"]});var ul={get paint(){return ll=ll||new Gs({"circle-radius":new $s(xe.paint_circle["circle-radius"]),"circle-color":new $s(xe.paint_circle["circle-color"]),"circle-blur":new $s(xe.paint_circle["circle-blur"]),"circle-opacity":new $s(xe.paint_circle["circle-opacity"]),"circle-translate":new Ns(xe.paint_circle["circle-translate"]),"circle-translate-anchor":new Ns(xe.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Ns(xe.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Ns(xe.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new $s(xe.paint_circle["circle-stroke-width"]),"circle-stroke-color":new $s(xe.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new $s(xe.paint_circle["circle-stroke-opacity"])})},get layout(){return al=al||new Gs({"circle-sort-key":new $s(xe.layout_circle["circle-sort-key"])})}};class cl extends Xs{constructor(e,t){super(e,ul,t);}createBucket(e){return new Na(e)}queryRadius(e){const t=e;return Ja("circle-radius",this,t)+Ja("circle-stroke-width",this,t)+Qa(this.paint.get("circle-translate"))}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){const l=el(e,this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),-i.bearingInRadians,s),u=this.paint.get("circle-radius").evaluate(t,r)+this.paint.get("circle-stroke-width").evaluate(t,r),c=this.paint.get("circle-pitch-scale"),h=this.paint.get("circle-pitch-alignment");let p,f;return "map"===h?(p=l,f=u*s):(p=function(e,t,r,n){return e.map((e=>ol(e,t,r,n)))}(l,i,o,a),f=u),sl({queryGeometry:p,size:f,transform:i,unwrappedTileID:o,getElevation:a,pitchAlignment:h,pitchScale:c},n)}}class hl extends Na{}let pl;ls("HeatmapBucket",hl,{omit:["layers"]});var fl={get paint(){return pl=pl||new Gs({"heatmap-radius":new $s(xe.paint_heatmap["heatmap-radius"]),"heatmap-weight":new $s(xe.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Ns(xe.paint_heatmap["heatmap-intensity"]),"heatmap-color":new js(xe.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Ns(xe.paint_heatmap["heatmap-opacity"])})}};function dl(e,{width:t,height:r},n,i){if(i){if(i instanceof Uint8ClampedArray)i=new Uint8Array(i.buffer);else if(i.length!==t*r*n)throw new RangeError(`mismatched image size. expected: ${i.length} but got: ${t*r*n}`)}else i=new Uint8Array(t*r*n);return e.width=t,e.height=r,e.data=i,e}function yl(e,{width:t,height:r},n){if(t===e.width&&r===e.height)return;const i=dl({},{width:t,height:r},n);ml(e,i,{x:0,y:0},{x:0,y:0},{width:Math.min(e.width,t),height:Math.min(e.height,r)},n),e.width=t,e.height=r,e.data=i.data;}function ml(e,t,r,n,i,s){if(0===i.width||0===i.height)return t;if(i.width>e.width||i.height>e.height||r.x>e.width-i.width||r.y>e.height-i.height)throw new RangeError("out of range source coordinates for image copy");if(i.width>t.width||i.height>t.height||n.x>t.width-i.width||n.y>t.height-i.height)throw new RangeError("out of range destination coordinates for image copy");const o=e.data,a=t.data;if(o===a)throw new Error("srcData equals dstData, so image is already copied");for(let l=0;l<i.height;l++){const u=((r.y+l)*e.width+r.x)*s,c=((n.y+l)*t.width+n.x)*s;for(let e=0;e<i.width*s;e++)a[c+e]=o[u+e];}return t}class gl{constructor(e,t){dl(this,e,1,t);}resize(e){yl(this,e,1);}clone(){return new gl({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,r,n,i){ml(e,t,r,n,i,1);}}class xl{constructor(e,t){dl(this,e,4,t);}resize(e){yl(this,e,4);}replace(e,t){t?this.data.set(e):this.data=e instanceof Uint8ClampedArray?new Uint8Array(e.buffer):e;}clone(){return new xl({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,r,n,i){ml(e,t,r,n,i,4);}setPixel(e,t,r){const n=4*(e*this.width+t);this.data[n+0]=Math.round(255*r.r/r.a),this.data[n+1]=Math.round(255*r.g/r.a),this.data[n+2]=Math.round(255*r.b/r.a),this.data[n+3]=Math.round(255*r.a);}}function vl(e){const t={},r=e.resolution||256,n=e.clips?e.clips.length:1,i=e.image||new xl({width:r,height:n});if(Math.log(r)/Math.LN2%1!=0)throw new Error(`width is not a power of 2 - ${r}`);const s=(n,s,o)=>{t[e.evaluationKey]=o;const a=e.expression.evaluate(t);i.setPixel(n/4/r,s/4,a);};if(e.clips)for(let t=0,i=0;t<n;++t,i+=4*r)for(let n=0,o=0;n<r;n++,o+=4){const a=n/(r-1),{start:l,end:u}=e.clips[t];s(i,o,l*(1-a)+u*a);}else for(let e=0,t=0;e<r;e++,t+=4)s(0,t,e/(r-1));return i}ls("AlphaImage",gl),ls("RGBAImage",xl);const bl="big-fb";class wl extends Xs{createBucket(e){return new hl(e)}constructor(e,t){super(e,fl,t),this.heatmapFbos=new Map,this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(e){"heatmap-color"===e&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=vl({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbos.has(bl)&&this.heatmapFbos.delete(bl);}queryRadius(e){return Ja("heatmap-radius",this,e)}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:r,geometry:n,transform:i,pixelsToTileUnits:s,unwrappedTileID:o,getElevation:a}){return sl({queryGeometry:e,size:this.paint.get("heatmap-radius").evaluate(t,r)*s,transform:i,unwrappedTileID:o,getElevation:a},n)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}}let _l;var Sl={get paint(){return _l=_l||new Gs({"hillshade-illumination-direction":new Ns(xe.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-altitude":new Ns(xe.paint_hillshade["hillshade-illumination-altitude"]),"hillshade-illumination-anchor":new Ns(xe.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Ns(xe.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Ns(xe.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Ns(xe.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Ns(xe.paint_hillshade["hillshade-accent-color"]),"hillshade-method":new Ns(xe.paint_hillshade["hillshade-method"])})}};class Al extends Xs{constructor(e,t){super(e,Sl,t),this.recalculate({zoom:0,zoomHistory:{}},void 0);}getIlluminationProperties(){let e=this.paint.get("hillshade-illumination-direction").values,t=this.paint.get("hillshade-illumination-altitude").values,r=this.paint.get("hillshade-highlight-color").values,n=this.paint.get("hillshade-shadow-color").values;const i=Math.max(e.length,t.length,r.length,n.length);e=e.concat(Array(i-e.length).fill(e.at(-1))),t=t.concat(Array(i-t.length).fill(t.at(-1))),r=r.concat(Array(i-r.length).fill(r.at(-1))),n=n.concat(Array(i-n.length).fill(n.at(-1)));const s=t.map(ee);return {directionRadians:e.map(ee),altitudeRadians:s,shadowColor:n,highlightColor:r}}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}}let Tl;var Il={get paint(){return Tl=Tl||new Gs({"color-relief-opacity":new Ns(xe["paint_color-relief"]["color-relief-opacity"]),"color-relief-color":new js(xe["paint_color-relief"]["color-relief-color"])})}};class El{constructor(e,t,r,n){this.context=e,this.format=r,this.texture=e.gl.createTexture(),this.update(t,n);}update(e,t,r){const{width:n,height:i}=e,s=!(this.size&&this.size[0]===n&&this.size[1]===i||r),{context:o}=this,{gl:a}=o;if(this.useMipmap=Boolean(t&&t.useMipmap),a.bindTexture(a.TEXTURE_2D,this.texture),o.pixelStoreUnpackFlipY.set(!1),o.pixelStoreUnpack.set(1),o.pixelStoreUnpackPremultiplyAlpha.set(this.format===a.RGBA&&(!t||!1!==t.premultiply)),s)this.size=[n,i],e instanceof HTMLImageElement||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof ImageData||Z(e)?a.texImage2D(a.TEXTURE_2D,0,this.format,this.format,a.UNSIGNED_BYTE,e):a.texImage2D(a.TEXTURE_2D,0,this.format,n,i,0,this.format,a.UNSIGNED_BYTE,e.data);else {const{x:t,y:s}=r||{x:0,y:0};e instanceof HTMLImageElement||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof ImageData||Z(e)?a.texSubImage2D(a.TEXTURE_2D,0,t,s,a.RGBA,a.UNSIGNED_BYTE,e):a.texSubImage2D(a.TEXTURE_2D,0,t,s,n,i,a.RGBA,a.UNSIGNED_BYTE,e.data);}this.useMipmap&&this.isSizePowerOfTwo()&&a.generateMipmap(a.TEXTURE_2D),o.pixelStoreUnpackFlipY.setDefault(),o.pixelStoreUnpack.setDefault(),o.pixelStoreUnpackPremultiplyAlpha.setDefault();}bind(e,t,r){const{context:n}=this,{gl:i}=n;i.bindTexture(i.TEXTURE_2D,this.texture),r!==i.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=i.LINEAR),e!==this.filter&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MAG_FILTER,e),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_MIN_FILTER,r||e),this.filter=e),t!==this.wrap&&(i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_S,t),i.texParameteri(i.TEXTURE_2D,i.TEXTURE_WRAP_T,t),this.wrap=t);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:e}=this.context;e.deleteTexture(this.texture),this.texture=null;}}class Ml{constructor(e,t,r,n=1,i=1,s=1,o=0){if(this.uid=e,t.height!==t.width)throw new RangeError("DEM tiles must be square");if(r&&!["mapbox","terrarium","custom"].includes(r))return void j(`"${r}" is not a valid encoding type. Valid types include "mapbox", "terrarium" and "custom".`);this.stride=t.height;const a=this.dim=t.height-2;switch(this.data=new Uint32Array(t.data.buffer),r){case "terrarium":this.redFactor=256,this.greenFactor=1,this.blueFactor=1/256,this.baseShift=32768;break;case "custom":this.redFactor=n,this.greenFactor=i,this.blueFactor=s,this.baseShift=o;break;default:this.redFactor=6553.6,this.greenFactor=25.6,this.blueFactor=.1,this.baseShift=1e4;}for(let e=0;e<a;e++)this.data[this._idx(-1,e)]=this.data[this._idx(0,e)],this.data[this._idx(a,e)]=this.data[this._idx(a-1,e)],this.data[this._idx(e,-1)]=this.data[this._idx(e,0)],this.data[this._idx(e,a)]=this.data[this._idx(e,a-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(a,-1)]=this.data[this._idx(a-1,0)],this.data[this._idx(-1,a)]=this.data[this._idx(0,a-1)],this.data[this._idx(a,a)]=this.data[this._idx(a-1,a-1)],this.min=Number.MAX_SAFE_INTEGER,this.max=Number.MIN_SAFE_INTEGER;for(let e=0;e<a;e++)for(let t=0;t<a;t++){const r=this.get(e,t);r>this.max&&(this.max=r),r<this.min&&(this.min=r);}}get(e,t){const r=new Uint8Array(this.data.buffer),n=4*this._idx(e,t);return this.unpack(r[n],r[n+1],r[n+2])}getUnpackVector(){return [this.redFactor,this.greenFactor,this.blueFactor,this.baseShift]}_idx(e,t){if(e<-1||e>=this.dim+1||t<-1||t>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (t+1)*this.stride+(e+1)}unpack(e,t,r){return e*this.redFactor+t*this.greenFactor+r*this.blueFactor-this.baseShift}pack(e){return kl(e,this.getUnpackVector())}getPixels(){return new xl({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(e,t,r){if(this.dim!==e.dim)throw new Error("dem dimension mismatch");let n=t*this.dim,i=t*this.dim+this.dim,s=r*this.dim,o=r*this.dim+this.dim;switch(t){case -1:n=i-1;break;case 1:i=n+1;}switch(r){case -1:s=o-1;break;case 1:o=s+1;}const a=-t*this.dim,l=-r*this.dim;for(let t=s;t<o;t++)for(let r=n;r<i;r++)this.data[this._idx(r,t)]=e.data[this._idx(r+a,t+l)];}}function kl(e,t){const r=t[0],n=t[1],i=t[2],s=t[3],o=Math.min(r,n,i),a=Math.round((e+s)/o);return {r:Math.floor(a*o/r)%256,g:Math.floor(a*o/n)%256,b:Math.floor(a*o/i)%256}}ls("DEMData",Ml);class Fl extends Xs{constructor(e,t){super(e,Il,t);}_createColorRamp(e){const t={elevationStops:[],colorStops:[]},r=this._transitionablePaint._values["color-relief-color"].value.expression;if(r instanceof ni&&r._styleExpression.expression instanceof pr){this.colorRampExpression=r;const e=r._styleExpression.expression;t.elevationStops=e.labels,t.colorStops=[];for(const r of t.elevationStops)t.colorStops.push(e.evaluate({globals:{elevation:r}}));}if(t.elevationStops.length<1&&(t.elevationStops=[0],t.colorStops=[It.transparent]),t.elevationStops.length<2&&(t.elevationStops.push(t.elevationStops[0]+1),t.colorStops.push(t.colorStops[0])),t.elevationStops.length<=e)return t;const n={elevationStops:[],colorStops:[]},i=(t.elevationStops.length-1)/(e-1);for(let e=0;e<t.elevationStops.length-.5;e+=i)n.elevationStops.push(t.elevationStops[Math.round(e)]),n.colorStops.push(t.colorStops[Math.round(e)]);return j(`Too many colors in specification of ${this.id} color-relief layer, may not render properly. Max possible colors: ${e}, provided: ${t.elevationStops.length}`),n}_colorRampChanged(){return this.colorRampExpression!=this._transitionablePaint._values["color-relief-color"].value.expression}getColorRampTextures(e,t,r){if(this.colorRampTextures&&!this._colorRampChanged())return this.colorRampTextures;const n=this._createColorRamp(t),i=new xl({width:n.colorStops.length,height:1}),s=new xl({width:n.colorStops.length,height:1});for(let e=0;e<n.elevationStops.length;e++){const t=kl(n.elevationStops[e],r);s.setPixel(0,e,new It(t.r/255,t.g/255,t.b/255,1)),i.setPixel(0,e,n.colorStops[e]);}return this.colorRampTextures={elevationTexture:new El(e,s,e.gl.RGBA),colorTexture:new El(e,i,e.gl.RGBA)},this.colorRampTextures}hasOffscreenPass(){return "none"!==this.visibility&&!!this.colorRampTextures}}const Dl=Qs([{name:"a_pos",components:2,type:"Int16"}],4),{members:Pl}=Dl;function Bl(e,t,r){const n=r.patternDependencies;let i=!1;for(const r of t){const t=r.paint.get(`${e}-pattern`);t.isConstant()||(i=!0);const s=t.constantOr(null);s&&(i=!0,n[s.to]=!0,n[s.from]=!0);}return i}function zl(e,t,r,n,i){const{zoom:s}=n,o=i.patternDependencies;for(const n of t){const t=n.paint.get(`${e}-pattern`).value;if("constant"!==t.kind){let e=t.evaluate({zoom:s-1},r,{},i.availableImages),a=t.evaluate({zoom:s},r,{},i.availableImages),l=t.evaluate({zoom:s+1},r,{},i.availableImages);e=e&&e.name?e.name:e,a=a&&a.name?a.name:a,l=l&&l.name?l.name:l,o[e]=!0,o[a]=!0,o[l]=!0,r.patterns[n.id]={min:e,mid:a,max:l};}}return r}function Vl(e,t,r,n,i){let s;if(i===function(e,t,r,n){let i=0;for(let s=t,o=r-n;s<r;s+=n)i+=(e[o]-e[s])*(e[s+1]+e[o+1]),o=s;return i}(e,t,r,n)>0)for(let i=t;i<r;i+=n)s=nu(i/n|0,e[i],e[i+1],s);else for(let i=r-n;i>=t;i-=n)s=nu(i/n|0,e[i],e[i+1],s);return s&&Wl(s,s.next)&&(iu(s),s=s.next),s}function Cl(e,t){if(!e)return e;t||(t=e);let r,n=e;do{if(r=!1,n.steiner||!Wl(n,n.next)&&0!==Kl(n.prev,n,n.next))n=n.next;else {if(iu(n),n=t=n.prev,n===n.next)break;r=!0;}}while(r||n!==t);return t}function Ll(e,t,r,n,i,s,o){if(!e)return;!o&&s&&function(e,t,r,n){let i=e;do{0===i.z&&(i.z=Gl(i.x,i.y,t,r,n)),i.prevZ=i.prev,i.nextZ=i.next,i=i.next;}while(i!==e);i.prevZ.nextZ=null,i.prevZ=null,function(e){let t,r=1;do{let n,i=e;e=null;let s=null;for(t=0;i;){t++;let o=i,a=0;for(let e=0;e<r&&(a++,o=o.nextZ,o);e++);let l=r;for(;a>0||l>0&&o;)0!==a&&(0===l||!o||i.z<=o.z)?(n=i,i=i.nextZ,a--):(n=o,o=o.nextZ,l--),s?s.nextZ=n:e=n,n.prevZ=s,s=n;i=o;}s.nextZ=null,r*=2;}while(t>1)}(i);}(e,n,i,s);let a=e;for(;e.prev!==e.next;){const l=e.prev,u=e.next;if(s?Rl(e,n,i,s):Ol(e))t.push(l.i,e.i,u.i),iu(e),e=u.next,a=u.next;else if((e=u)===a){o?1===o?Ll(e=Nl(Cl(e),t),t,r,n,i,s,2):2===o&&$l(e,t,r,n,i,s):Ll(Cl(e),t,r,n,i,s,1);break}}}function Ol(e){const t=e.prev,r=e,n=e.next;if(Kl(t,r,n)>=0)return !1;const i=t.x,s=r.x,o=n.x,a=t.y,l=r.y,u=n.y,c=Math.min(i,s,o),h=Math.min(a,l,u),p=Math.max(i,s,o),f=Math.max(a,l,u);let d=n.next;for(;d!==t;){if(d.x>=c&&d.x<=p&&d.y>=h&&d.y<=f&&Zl(i,a,s,l,o,u,d.x,d.y)&&Kl(d.prev,d,d.next)>=0)return !1;d=d.next;}return !0}function Rl(e,t,r,n){const i=e.prev,s=e,o=e.next;if(Kl(i,s,o)>=0)return !1;const a=i.x,l=s.x,u=o.x,c=i.y,h=s.y,p=o.y,f=Math.min(a,l,u),d=Math.min(c,h,p),y=Math.max(a,l,u),m=Math.max(c,h,p),g=Gl(f,d,t,r,n),x=Gl(y,m,t,r,n);let v=e.prevZ,b=e.nextZ;for(;v&&v.z>=g&&b&&b.z<=x;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==o&&Zl(a,c,l,h,u,p,v.x,v.y)&&Kl(v.prev,v,v.next)>=0)return !1;if(v=v.prevZ,b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==o&&Zl(a,c,l,h,u,p,b.x,b.y)&&Kl(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}for(;v&&v.z>=g;){if(v.x>=f&&v.x<=y&&v.y>=d&&v.y<=m&&v!==i&&v!==o&&Zl(a,c,l,h,u,p,v.x,v.y)&&Kl(v.prev,v,v.next)>=0)return !1;v=v.prevZ;}for(;b&&b.z<=x;){if(b.x>=f&&b.x<=y&&b.y>=d&&b.y<=m&&b!==i&&b!==o&&Zl(a,c,l,h,u,p,b.x,b.y)&&Kl(b.prev,b,b.next)>=0)return !1;b=b.nextZ;}return !0}function Nl(e,t){let r=e;do{const n=r.prev,i=r.next.next;!Wl(n,i)&&Jl(n,r,r.next,i)&&tu(n,i)&&tu(i,n)&&(t.push(n.i,r.i,i.i),iu(r),iu(r.next),r=e=i),r=r.next;}while(r!==e);return Cl(r)}function $l(e,t,r,n,i,s){let o=e;do{let e=o.next.next;for(;e!==o.prev;){if(o.i!==e.i&&Hl(o,e)){let a=ru(o,e);return o=Cl(o,o.next),a=Cl(a,a.next),Ll(o,t,r,n,i,s,0),void Ll(a,t,r,n,i,s,0)}e=e.next;}o=o.next;}while(o!==e)}function Ul(e,t){let r=e.x-t.x;return 0===r&&(r=e.y-t.y,0===r)&&(r=(e.next.y-e.y)/(e.next.x-e.x)-(t.next.y-t.y)/(t.next.x-t.x)),r}function ql(e,t){const r=function(e,t){let r=t;const n=e.x,i=e.y;let s,o=-1/0;if(Wl(e,r))return r;do{if(Wl(e,r.next))return r.next;if(i<=r.y&&i>=r.next.y&&r.next.y!==r.y){const e=r.x+(i-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(e<=n&&e>o&&(o=e,s=r.x<r.next.x?r:r.next,e===n))return s}r=r.next;}while(r!==t);if(!s)return null;const a=s,l=s.x,u=s.y;let c=1/0;r=s;do{if(n>=r.x&&r.x>=l&&n!==r.x&&Yl(i<u?n:o,i,l,u,i<u?o:n,i,r.x,r.y)){const t=Math.abs(i-r.y)/(n-r.x);tu(r,e)&&(t<c||t===c&&(r.x>s.x||r.x===s.x&&jl(s,r)))&&(s=r,c=t);}r=r.next;}while(r!==a);return s}(e,t);if(!r)return t;const n=ru(r,e);return Cl(n,n.next),Cl(r,r.next)}function jl(e,t){return Kl(e.prev,e,t.prev)<0&&Kl(t.next,e,e.next)<0}function Gl(e,t,r,n,i){return (e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-r)*i|0)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-n)*i|0)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function Xl(e){let t=e,r=e;do{(t.x<r.x||t.x===r.x&&t.y<r.y)&&(r=t),t=t.next;}while(t!==e);return r}function Yl(e,t,r,n,i,s,o,a){return (i-o)*(t-a)>=(e-o)*(s-a)&&(e-o)*(n-a)>=(r-o)*(t-a)&&(r-o)*(s-a)>=(i-o)*(n-a)}function Zl(e,t,r,n,i,s,o,a){return !(e===o&&t===a)&&Yl(e,t,r,n,i,s,o,a)}function Hl(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!function(e,t){let r=e;do{if(r.i!==e.i&&r.next.i!==e.i&&r.i!==t.i&&r.next.i!==t.i&&Jl(r,r.next,e,t))return !0;r=r.next;}while(r!==e);return !1}(e,t)&&(tu(e,t)&&tu(t,e)&&function(e,t){let r=e,n=!1;const i=(e.x+t.x)/2,s=(e.y+t.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&i<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(n=!n),r=r.next;}while(r!==e);return n}(e,t)&&(Kl(e.prev,e,t.prev)||Kl(e,t.prev,t))||Wl(e,t)&&Kl(e.prev,e,e.next)>0&&Kl(t.prev,t,t.next)>0)}function Kl(e,t,r){return (t.y-e.y)*(r.x-t.x)-(t.x-e.x)*(r.y-t.y)}function Wl(e,t){return e.x===t.x&&e.y===t.y}function Jl(e,t,r,n){const i=eu(Kl(e,t,r)),s=eu(Kl(e,t,n)),o=eu(Kl(r,n,e)),a=eu(Kl(r,n,t));return i!==s&&o!==a||!(0!==i||!Ql(e,r,t))||!(0!==s||!Ql(e,n,t))||!(0!==o||!Ql(r,e,n))||!(0!==a||!Ql(r,t,n))}function Ql(e,t,r){return t.x<=Math.max(e.x,r.x)&&t.x>=Math.min(e.x,r.x)&&t.y<=Math.max(e.y,r.y)&&t.y>=Math.min(e.y,r.y)}function eu(e){return e>0?1:e<0?-1:0}function tu(e,t){return Kl(e.prev,e,e.next)<0?Kl(e,t,e.next)>=0&&Kl(e,e.prev,t)>=0:Kl(e,t,e.prev)<0||Kl(e,e.next,t)<0}function ru(e,t){const r=su(e.i,e.x,e.y),n=su(t.i,t.x,t.y),i=e.next,s=t.prev;return e.next=t,t.prev=e,r.next=i,i.prev=r,n.next=r,r.prev=n,s.next=n,n.prev=s,n}function nu(e,t,r,n){const i=su(e,t,r);return n?(i.next=n.next,i.prev=n,n.next.prev=i,n.next=i):(i.prev=i,i.next=i),i}function iu(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ);}function su(e,t,r){return {i:e,x:t,y:r,prev:null,next:null,z:0,prevZ:null,nextZ:null,steiner:!1}}class ou{constructor(e,t){if(t>e)throw new Error("Min granularity must not be greater than base granularity.");this._baseZoomGranularity=e,this._minGranularity=t;}getGranularityForZoomLevel(e){return Math.max(Math.floor(this._baseZoomGranularity/(1<<e)),this._minGranularity,1)}}class au{constructor(e){this.fill=e.fill,this.line=e.line,this.tile=e.tile,this.stencil=e.stencil,this.circle=e.circle;}}au.noSubdivision=new au({fill:new ou(0,0),line:new ou(0,0),tile:new ou(0,0),stencil:new ou(0,0),circle:1}),ls("SubdivisionGranularityExpression",ou),ls("SubdivisionGranularitySetting",au);const lu=-32768,uu=32767;class cu{constructor(e,t){this._vertexBuffer=[],this._vertexDictionary=new Map,this._used=!1,this._granularity=e,this._granularityCellSize=k/e,this._canonical=t;}_getKey(e,t){return (e+=32768)<<16|t+32768}_vertexToIndex(e,t){if(e<-32768||t<-32768||e>32767||t>32767)throw new Error("Vertex coordinates are out of signed 16 bit integer range.");const r=0|Math.round(e),n=0|Math.round(t),i=this._getKey(r,n);if(this._vertexDictionary.has(i))return this._vertexDictionary.get(i);const s=this._vertexBuffer.length/2;return this._vertexDictionary.set(i,s),this._vertexBuffer.push(r,n),s}_subdivideTrianglesScanline(e){if(this._granularity<2)return function(e,t){const r=[];for(let n=0;n<t.length;n+=3){const i=t[n],s=t[n+1],o=t[n+2],a=e[2*i],l=e[2*i+1];(e[2*s]-a)*(e[2*o+1]-l)-(e[2*s+1]-l)*(e[2*o]-a)>0?(r.push(i),r.push(o),r.push(s)):(r.push(i),r.push(s),r.push(o));}return r}(this._vertexBuffer,e);const t=[],r=e.length;for(let n=0;n<r;n+=3){const r=[e[n+0],e[n+1],e[n+2]],i=[this._vertexBuffer[2*e[n+0]+0],this._vertexBuffer[2*e[n+0]+1],this._vertexBuffer[2*e[n+1]+0],this._vertexBuffer[2*e[n+1]+1],this._vertexBuffer[2*e[n+2]+0],this._vertexBuffer[2*e[n+2]+1]];let s=1/0,o=1/0,a=-1/0,l=-1/0;for(let e=0;e<3;e++){const t=i[2*e],r=i[2*e+1];s=Math.min(s,t),a=Math.max(a,t),o=Math.min(o,r),l=Math.max(l,r);}if(s===a||o===l)continue;const u=Math.floor(s/this._granularityCellSize),c=Math.ceil(a/this._granularityCellSize),h=Math.floor(o/this._granularityCellSize),p=Math.ceil(l/this._granularityCellSize);if(u!==c||h!==p)for(let e=h;e<p;e++){const n=this._scanlineGenerateVertexRingForCellRow(e,i,r);fu(this._vertexBuffer,n,t);}else t.push(...r);}return t}_scanlineGenerateVertexRingForCellRow(e,t,r){const n=e*this._granularityCellSize,i=n+this._granularityCellSize,s=[];for(let e=0;e<3;e++){const o=t[2*e],a=t[2*e+1],l=t[2*(e+1)%6],u=t[(2*(e+1)+1)%6],c=t[2*(e+2)%6],h=t[(2*(e+2)+1)%6],p=l-o,f=u-a,d=0===p,y=0===f,m=(n-a)/f,g=(i-a)/f,x=Math.min(m,g),v=Math.max(m,g);if(!y&&(x>=1||v<=0)||y&&(a<n||a>i)){u>=n&&u<=i&&s.push(r[(e+1)%3]);continue}!y&&x>0&&s.push(this._vertexToIndex(o+p*x,a+f*x));const b=o+p*Math.max(x,0),w=o+p*Math.min(v,1);d||this._generateIntraEdgeVertices(s,o,a,l,u,b,w),!y&&v<1&&s.push(this._vertexToIndex(o+p*v,a+f*v)),(y||u>=n&&u<=i)&&s.push(r[(e+1)%3]),!y&&(u<=n||u>=i)&&this._generateInterEdgeVertices(s,o,a,l,u,c,h,w,n,i);}return s}_generateIntraEdgeVertices(e,t,r,n,i,s,o){const a=n-t,l=i-r,u=0===l,c=u?Math.min(t,n):Math.min(s,o),h=u?Math.max(t,n):Math.max(s,o),p=Math.floor(c/this._granularityCellSize)+1,f=Math.ceil(h/this._granularityCellSize)-1;if(u?t<n:s<o)for(let n=p;n<=f;n++){const i=n*this._granularityCellSize;e.push(this._vertexToIndex(i,r+l*(i-t)/a));}else for(let n=f;n>=p;n--){const i=n*this._granularityCellSize;e.push(this._vertexToIndex(i,r+l*(i-t)/a));}}_generateInterEdgeVertices(e,t,r,n,i,s,o,a,l,u){const c=i-r,h=s-n,p=o-i,f=(l-i)/p,d=(u-i)/p,y=Math.min(f,d),m=Math.max(f,d),g=n+h*y;let x=Math.floor(Math.min(g,a)/this._granularityCellSize)+1,v=Math.ceil(Math.max(g,a)/this._granularityCellSize)-1,b=a<g;const w=0===p;if(w&&(o===l||o===u))return;if(w||y>=1||m<=0){const e=r-o,n=s+(t-s)*Math.min((l-o)/e,(u-o)/e);x=Math.floor(Math.min(n,a)/this._granularityCellSize)+1,v=Math.ceil(Math.max(n,a)/this._granularityCellSize)-1,b=a<n;}const _=c>0?u:l;if(b)for(let t=x;t<=v;t++)e.push(this._vertexToIndex(t*this._granularityCellSize,_));else for(let t=v;t>=x;t--)e.push(this._vertexToIndex(t*this._granularityCellSize,_));}_generateOutline(e){const t=[];for(const r of e){const e=pu(r,this._granularity,!0),n=this._pointArrayToIndices(e),i=[];for(let e=1;e<n.length;e++)i.push(n[e-1]),i.push(n[e]);t.push(i);}return t}_handlePoles(e){let t=!1,r=!1;this._canonical&&(0===this._canonical.y&&(t=!0),this._canonical.y===(1<<this._canonical.z)-1&&(r=!0)),(t||r)&&this._fillPoles(e,t,r);}_ensureNoPoleVertices(){const e=this._vertexBuffer;for(let t=0;t<e.length;t+=2){const r=e[t+1];r===lu&&(e[t+1]=-32767),r===uu&&(e[t+1]=32766);}}_generatePoleQuad(e,t,r,n,i,s){n>i!=(s===lu)?(e.push(t),e.push(r),e.push(this._vertexToIndex(n,s)),e.push(r),e.push(this._vertexToIndex(i,s)),e.push(this._vertexToIndex(n,s))):(e.push(r),e.push(t),e.push(this._vertexToIndex(n,s)),e.push(this._vertexToIndex(i,s)),e.push(r),e.push(this._vertexToIndex(n,s)));}_fillPoles(e,t,r){const n=this._vertexBuffer,i=k,s=e.length;for(let o=2;o<s;o+=3){const s=e[o-2],a=e[o-1],l=e[o],u=n[2*s],c=n[2*s+1],h=n[2*a],p=n[2*a+1],f=n[2*l],d=n[2*l+1];t&&(0===c&&0===p&&this._generatePoleQuad(e,s,a,u,h,lu),0===p&&0===d&&this._generatePoleQuad(e,a,l,h,f,lu),0===d&&0===c&&this._generatePoleQuad(e,l,s,f,u,lu)),r&&(c===i&&p===i&&this._generatePoleQuad(e,s,a,u,h,uu),p===i&&d===i&&this._generatePoleQuad(e,a,l,h,f,uu),d===i&&c===i&&this._generatePoleQuad(e,l,s,f,u,uu));}}_initializeVertices(e){for(let t=0;t<e.length;t+=2)this._vertexToIndex(e[t],e[t+1]);}subdividePolygonInternal(e,t){if(this._used)throw new Error("Subdivision: multiple use not allowed.");this._used=!0;const{flattened:r,holeIndices:n}=function(e){const t=[],r=[];for(const n of e)if(0!==n.length){n!==e[0]&&t.push(r.length/2);for(let e=0;e<n.length;e++)r.push(n[e].x),r.push(n[e].y);}return {flattened:r,holeIndices:t}}(e);let i;this._initializeVertices(r);try{const e=function(e,t,r=2){const n=t&&t.length,i=n?t[0]*r:e.length;let s=Vl(e,0,i,r,!0);const o=[];if(!s||s.next===s.prev)return o;let a,l,u;if(n&&(s=function(e,t,r,n){const i=[];for(let r=0,s=t.length;r<s;r++){const o=Vl(e,t[r]*n,r<s-1?t[r+1]*n:e.length,n,!1);o===o.next&&(o.steiner=!0),i.push(Xl(o));}i.sort(Ul);for(let e=0;e<i.length;e++)r=ql(i[e],r);return r}(e,t,s,r)),e.length>80*r){a=e[0],l=e[1];let t=a,n=l;for(let s=r;s<i;s+=r){const r=e[s],i=e[s+1];r<a&&(a=r),i<l&&(l=i),r>t&&(t=r),i>n&&(n=i);}u=Math.max(t-a,n-l),u=0!==u?32767/u:0;}return Ll(s,o,r,a,l,u,0),o}(r,n),t=this._convertIndices(r,e);i=this._subdivideTrianglesScanline(t);}catch(e){console.error(e);}let s=[];return t&&(s=this._generateOutline(e)),this._ensureNoPoleVertices(),this._handlePoles(i),{verticesFlattened:this._vertexBuffer,indicesTriangles:i,indicesLineList:s}}_convertIndices(e,t){const r=[];for(let n=0;n<t.length;n++)r.push(this._vertexToIndex(e[2*t[n]],e[2*t[n]+1]));return r}_pointArrayToIndices(e){const t=[];for(let r=0;r<e.length;r++){const n=e[r];t.push(this._vertexToIndex(n.x,n.y));}return t}}function hu(e,t,r,n=!0){return new cu(r,t).subdividePolygonInternal(e,n)}function pu(e,t,n=!1){if(!e||e.length<1)return [];if(e.length<2)return [];const i=e[0],s=e[e.length-1],o=n&&(i.x!==s.x||i.y!==s.y);if(t<2)return o?[...e,e[0]]:[...e];const a=Math.floor(k/t),l=[];l.push(new r(e[0].x,e[0].y));const u=e.length,c=o?u:u-1;for(let t=0;t<c;t++){const n=e[t],i=t<u-1?e[t+1]:e[0],s=n.x,o=n.y,c=i.x,h=i.y,p=s!==c,f=o!==h;if(!p&&!f)continue;const d=c-s,y=h-o,m=Math.abs(d),g=Math.abs(y);let x=s,v=o;for(;;){const e=d>0?(Math.floor(x/a)+1)*a:(Math.ceil(x/a)-1)*a,t=y>0?(Math.floor(v/a)+1)*a:(Math.ceil(v/a)-1)*a,n=Math.abs(x-e),i=Math.abs(v-t),s=Math.abs(x-c),o=Math.abs(v-h),u=p?n/m:Number.POSITIVE_INFINITY,b=f?i/g:Number.POSITIVE_INFINITY;if((s<=n||!p)&&(o<=i||!f))break;if(u<b&&p||!f){x=e,v+=y*u;const t=new r(x,Math.round(v));l[l.length-1].x===t.x&&l[l.length-1].y===t.y||l.push(t);}else {x+=d*b,v=t;const e=new r(Math.round(x),v);l[l.length-1].x===e.x&&l[l.length-1].y===e.y||l.push(e);}}const b=new r(c,h);l[l.length-1].x===b.x&&l[l.length-1].y===b.y||l.push(b);}return l}function fu(e,t,r){if(0===t.length)throw new Error("Subdivision vertex ring is empty.");let n=0,i=e[2*t[0]];for(let r=1;r<t.length;r++){const s=e[2*t[r]];s<i&&(i=s,n=r);}const s=t.length;let o=n,a=(o+1)%s;for(;;){const n=o-1>=0?o-1:s-1,i=(a+1)%s,l=e[2*t[n]],u=e[2*t[i]],c=e[2*t[o]],h=e[2*t[o]+1],p=e[2*t[a]+1];let f=!1;if(l<u)f=!0;else if(l>u)f=!1;else {const r=p-h,s=-(e[2*t[a]]-c),o=h<p?1:-1;((l-c)*r+(e[2*t[n]+1]-h)*s)*o>((u-c)*r+(e[2*t[i]+1]-h)*s)*o&&(f=!0);}if(f){const e=t[n],i=t[o],l=t[a];e!==i&&e!==l&&i!==l&&r.push(l,i,e),o--,o<0&&(o=s-1);}else {const e=t[i],n=t[o],l=t[a];e!==n&&e!==l&&n!==l&&r.push(l,n,e),a++,a>=s&&(a=0);}if(n===i)break}}function du(e,t,r,n,i,s,o,a,l){const u=i.length/2,c=o&&a&&l;if(u<ta.MAX_VERTEX_ARRAY_LENGTH){const h=t.prepareSegment(u,r,n),p=h.vertexLength;for(let e=0;e<s.length;e+=3)n.emplaceBack(p+s[e],p+s[e+1],p+s[e+2]);let f,d;h.vertexLength+=u,h.primitiveLength+=s.length/3,c&&(d=o.prepareSegment(u,r,a),f=d.vertexLength,d.vertexLength+=u);for(let t=0;t<i.length;t+=2)e(i[t],i[t+1]);if(c)for(let e=0;e<l.length;e++){const t=l[e];for(let e=1;e<t.length;e+=2)a.emplaceBack(f+t[e-1],f+t[e]);d.primitiveLength+=t.length/2;}}else !function(e,t,r,n,i,s){const o=[];for(let e=0;e<n.length/2;e++)o.push(-1);const a={count:0};let l=0,u=e.getOrCreateLatestSegment(t,r),c=u.vertexLength;for(let h=2;h<i.length;h+=3){const p=i[h-2],f=i[h-1],d=i[h];let y=o[p]<l,m=o[f]<l,g=o[d]<l;u.vertexLength+((y?1:0)+(m?1:0)+(g?1:0))>ta.MAX_VERTEX_ARRAY_LENGTH&&(u=e.createNewSegment(t,r),l=a.count,y=!0,m=!0,g=!0,c=0);const x=yu(o,n,s,a,p,y,u),v=yu(o,n,s,a,f,m,u),b=yu(o,n,s,a,d,g,u);r.emplaceBack(c+x-l,c+v-l,c+b-l),u.primitiveLength++;}}(t,r,n,i,s,e),c&&function(e,t,r,n,i,s){const o=[];for(let e=0;e<n.length/2;e++)o.push(-1);const a={count:0};let l=0,u=e.getOrCreateLatestSegment(t,r),c=u.vertexLength;for(let h=0;h<i.length;h++){const p=i[h];for(let f=1;f<i[h].length;f+=2){const i=p[f-1],h=p[f];let d=o[i]<l,y=o[h]<l;u.vertexLength+((d?1:0)+(y?1:0))>ta.MAX_VERTEX_ARRAY_LENGTH&&(u=e.createNewSegment(t,r),l=a.count,d=!0,y=!0,c=0);const m=yu(o,n,s,a,i,d,u),g=yu(o,n,s,a,h,y,u);r.emplaceBack(c+m-l,c+g-l),u.primitiveLength++;}}}(o,r,a,i,l,e),t.forceNewSegmentOnNextPrepare(),null==o||o.forceNewSegmentOnNextPrepare();}function yu(e,t,r,n,i,s,o){if(s){const s=n.count;return r(t[2*i],t[2*i+1]),e[i]=n.count,n.count++,o.vertexLength++,s}return e[i]}class mu{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.patternFeatures=[],this.layoutVertexArray=new No,this.indexArray=new Wo,this.indexArray2=new Jo,this.programConfigurations=new Da(e.layers,e.zoom),this.segments=new ta,this.segments2=new ta,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id));}populate(e,t,r){this.hasDependencies=Bl("fill",this.layers,t);const n=this.layers[0].layout.get("fill-sort-key"),i=!n.isConstant(),s=[];for(const{feature:o,id:a,index:l,sourceLayerIndex:u}of e){const e=this.layers[0]._featureFilter.needGeometry,c=La(o,e);if(!this.layers[0]._featureFilter.filter(new ks(this.zoom),c,r))continue;const h=i?n.evaluate(c,{},r,t.availableImages):void 0,p={id:a,properties:o.properties,type:o.type,sourceLayerIndex:u,index:l,geometry:e?c.geometry:Ca(o),patterns:{},sortKey:h};s.push(p);}i&&s.sort(((e,t)=>e.sortKey-t.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;if(this.hasDependencies){const e=zl("fill",this.layers,n,{zoom:this.zoom},t);this.patternFeatures.push(e);}else this.addFeature(n,i,s,r,{},t.subdivisionGranularity);t.featureIndex.insert(e[s].feature,i,s,o,this.index);}}update(e,t,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:r});}addFeatures(e,t,r){for(const n of this.patternFeatures)this.addFeature(n,n.geometry,n.index,t,r,e.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,Pl),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.indexBuffer2=e.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(e),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(e,t,r,n,i,s){for(const e of Qr(t,500)){const t=hu(e,n,s.fill.getGranularityForZoomLevel(n.z)),r=this.layoutVertexArray;du(((e,t)=>{r.emplaceBack(e,t);}),this.segments,this.layoutVertexArray,this.indexArray,t.verticesFlattened,t.indicesTriangles,this.segments2,this.indexArray2,t.indicesLineList);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,r,{imagePositions:i,canonical:n});}}let gu,xu;ls("FillBucket",mu,{omit:["layers","patternFeatures"]});var vu={get paint(){return xu=xu||new Gs({"fill-antialias":new Ns(xe.paint_fill["fill-antialias"]),"fill-opacity":new $s(xe.paint_fill["fill-opacity"]),"fill-color":new $s(xe.paint_fill["fill-color"]),"fill-outline-color":new $s(xe.paint_fill["fill-outline-color"]),"fill-translate":new Ns(xe.paint_fill["fill-translate"]),"fill-translate-anchor":new Ns(xe.paint_fill["fill-translate-anchor"]),"fill-pattern":new Us(xe.paint_fill["fill-pattern"])})},get layout(){return gu=gu||new Gs({"fill-sort-key":new $s(xe.layout_fill["fill-sort-key"])})}};class bu extends Xs{constructor(e,t){super(e,vu,t);}recalculate(e,t){super.recalculate(e,t);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(e){return new mu(e)}queryRadius(){return Qa(this.paint.get("fill-translate"))}queryIntersectsFeature({queryGeometry:e,geometry:t,transform:r,pixelsToTileUnits:n}){return qa(el(e,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),-r.bearingInRadians,n),t)}isTileClipped(){return !0}}const wu=Qs([{name:"a_pos",components:2,type:"Int16"},{name:"a_normal_ed",components:4,type:"Int16"}],4),_u=Qs([{name:"a_centroid",components:2,type:"Int16"}],4),{members:Su}=wu;class Au{constructor(e,t,r,n,i){this.properties={},this.extent=r,this.type=0,this.id=void 0,this._pbf=e,this._geometry=-1,this._keys=n,this._values=i,e.readFields(Tu,this,t);}loadGeometry(){const e=this._pbf;e.pos=this._geometry;const t=e.readVarint()+e.pos,n=[];let i,s=1,o=0,a=0,l=0;for(;e.pos<t;){if(o<=0){const t=e.readVarint();s=7&t,o=t>>3;}if(o--,1===s||2===s)a+=e.readSVarint(),l+=e.readSVarint(),1===s&&(i&&n.push(i),i=[]),i&&i.push(new r(a,l));else {if(7!==s)throw new Error(`unknown command ${s}`);i&&i.push(i[0].clone());}}return i&&n.push(i),n}bbox(){const e=this._pbf;e.pos=this._geometry;const t=e.readVarint()+e.pos;let r=1,n=0,i=0,s=0,o=1/0,a=-1/0,l=1/0,u=-1/0;for(;e.pos<t;){if(n<=0){const t=e.readVarint();r=7&t,n=t>>3;}if(n--,1===r||2===r)i+=e.readSVarint(),s+=e.readSVarint(),i<o&&(o=i),i>a&&(a=i),s<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error(`unknown command ${r}`)}return [o,l,a,u]}toGeoJSON(e,t,r){const n=this.extent*Math.pow(2,r),i=this.extent*e,s=this.extent*t,o=this.loadGeometry();function a(e){return [360*(e.x+i)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(e.y+s)/n)*Math.PI))-90]}function l(e){return e.map(a)}let u;if(1===this.type){const e=[];for(const t of o)e.push(t[0]);const t=l(e);u=1===e.length?{type:"Point",coordinates:t[0]}:{type:"MultiPoint",coordinates:t};}else if(2===this.type){const e=o.map(l);u=1===e.length?{type:"LineString",coordinates:e[0]}:{type:"MultiLineString",coordinates:e};}else {if(3!==this.type)throw new Error("unknown feature type");{const e=function(e){const t=e.length;if(t<=1)return [e];const r=[];let n,i;for(let s=0;s<t;s++){const t=Iu(e[s]);0!==t&&(void 0===i&&(i=t<0),i===t<0?(n&&r.push(n),n=[e[s]]):n&&n.push(e[s]));}return n&&r.push(n),r}(o),t=[];for(const r of e)t.push(r.map(l));u=1===t.length?{type:"Polygon",coordinates:t[0]}:{type:"MultiPolygon",coordinates:t};}}const c={type:"Feature",geometry:u,properties:this.properties};return null!=this.id&&(c.id=this.id),c}}function Tu(e,t,r){1===e?t.id=r.readVarint():2===e?function(e,t){const r=e.readVarint()+e.pos;for(;e.pos<r;){const r=t._keys[e.readVarint()],n=t._values[e.readVarint()];t.properties[r]=n;}}(r,t):3===e?t.type=r.readVarint():4===e&&(t._geometry=r.pos);}function Iu(e){let t=0;for(let r,n,i=0,s=e.length,o=s-1;i<s;o=i++)r=e[i],n=e[o],t+=(n.x-r.x)*(r.y+n.y);return t}Au.types=["Unknown","Point","LineString","Polygon"];class Eu{constructor(e,t){this.version=1,this.name="",this.extent=4096,this.length=0,this._pbf=e,this._keys=[],this._values=[],this._features=[],e.readFields(Mu,this,t),this.length=this._features.length;}feature(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];const t=this._pbf.readVarint()+this._pbf.pos;return new Au(this._pbf,t,this.extent,this._keys,this._values)}}function Mu(e,t,r){15===e?t.version=r.readVarint():1===e?t.name=r.readString():5===e?t.extent=r.readVarint():2===e?t._features.push(r.pos):3===e?t._keys.push(r.readString()):4===e&&t._values.push(function(e){let t=null;const r=e.readVarint()+e.pos;for(;e.pos<r;){const r=e.readVarint()>>3;t=1===r?e.readString():2===r?e.readFloat():3===r?e.readDouble():4===r?e.readVarint64():5===r?e.readVarint():6===r?e.readSVarint():7===r?e.readBoolean():null;}if(null==t)throw new Error("unknown feature value");return t}(r));}class ku{constructor(e,t){this.layers=e.readFields(Fu,{},t);}}function Fu(e,t,r){if(3===e){const e=new Eu(r,r.readVarint()+r.pos);e.length&&(t[e.name]=e);}}const Du=Math.pow(2,13);function Pu(e,t,r,n,i,s,o,a){e.emplaceBack(t,r,2*Math.floor(n*Du)+o,i*Du*2,s*Du*2,Math.round(a));}class Bu{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.layoutVertexArray=new $o,this.centroidVertexArray=new Oo,this.indexArray=new Wo,this.programConfigurations=new Da(e.layers,e.zoom),this.segments=new ta,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id));}populate(e,t,r){this.features=[],this.hasDependencies=Bl("fill-extrusion",this.layers,t);for(const{feature:n,id:i,index:s,sourceLayerIndex:o}of e){const e=this.layers[0]._featureFilter.needGeometry,a=La(n,e);if(!this.layers[0]._featureFilter.filter(new ks(this.zoom),a,r))continue;const l={id:i,sourceLayerIndex:o,index:s,geometry:e?a.geometry:Ca(n),properties:n.properties,type:n.type,patterns:{}};this.hasDependencies?this.features.push(zl("fill-extrusion",this.layers,l,{zoom:this.zoom},t)):this.addFeature(l,l.geometry,s,r,{},t.subdivisionGranularity),t.featureIndex.insert(n,l.geometry,s,o,this.index,!0);}}addFeatures(e,t,r){for(const n of this.features){const{geometry:i}=n;this.addFeature(n,i,n.index,t,r,e.subdivisionGranularity);}}update(e,t,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:r});}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.centroidVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,Su),this.centroidVertexBuffer=e.createVertexBuffer(this.centroidVertexArray,_u.members,!0),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.centroidVertexBuffer.destroy());}addFeature(e,t,r,n,i,s){for(const r of Qr(t,500)){const t={x:0,y:0,sampleCount:0},i=this.layoutVertexArray.length;this.processPolygon(t,n,e,r,s);const o=this.layoutVertexArray.length-i,a=Math.floor(t.x/t.sampleCount),l=Math.floor(t.y/t.sampleCount);for(let e=0;e<o;e++)this.centroidVertexArray.emplaceBack(a,l);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,r,{imagePositions:i,canonical:n});}processPolygon(e,t,r,n,i){if(n.length<1)return;if(Cu(n[0]))return;for(const t of n)0!==t.length&&zu(e,t);const s={segment:this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray)},o=i.fill.getGranularityForZoomLevel(t.z),a="Polygon"===Au.types[r.type];for(const e of n){if(0===e.length)continue;if(Cu(e))continue;const t=pu(e,o,a);this._generateSideFaces(t,s);}if(!a)return;const l=hu(n,t,o,!1),u=this.layoutVertexArray;du(((e,t)=>{Pu(u,e,t,0,0,1,1,0);}),this.segments,this.layoutVertexArray,this.indexArray,l.verticesFlattened,l.indicesTriangles);}_generateSideFaces(e,t){let r=0;for(let n=1;n<e.length;n++){const i=e[n],s=e[n-1];if(Vu(i,s))continue;t.segment.vertexLength+4>ta.MAX_VERTEX_ARRAY_LENGTH&&(t.segment=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const o=i.sub(s)._perp()._unit(),a=s.dist(i);r+a>32768&&(r=0),Pu(this.layoutVertexArray,i.x,i.y,o.x,o.y,0,0,r),Pu(this.layoutVertexArray,i.x,i.y,o.x,o.y,0,1,r),r+=a,Pu(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,0,r),Pu(this.layoutVertexArray,s.x,s.y,o.x,o.y,0,1,r);const l=t.segment.vertexLength;this.indexArray.emplaceBack(l,l+2,l+1),this.indexArray.emplaceBack(l+1,l+2,l+3),t.segment.vertexLength+=4,t.segment.primitiveLength+=2;}}}function zu(e,t){for(let r=0;r<t.length;r++){const n=t[r];r===t.length-1&&t[0].x===n.x&&t[0].y===n.y||(e.x+=n.x,e.y+=n.y,e.sampleCount++);}}function Vu(e,t){return e.x===t.x&&(e.x<0||e.x>k)||e.y===t.y&&(e.y<0||e.y>k)}function Cu(e){return e.every((e=>e.x<0))||e.every((e=>e.x>k))||e.every((e=>e.y<0))||e.every((e=>e.y>k))}let Lu;ls("FillExtrusionBucket",Bu,{omit:["layers","features"]});var Ou={get paint(){return Lu=Lu||new Gs({"fill-extrusion-opacity":new Ns(xe["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new $s(xe["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Ns(xe["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Ns(xe["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Us(xe["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new $s(xe["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new $s(xe["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Ns(xe["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})}};class Ru extends Xs{constructor(e,t){super(e,Ou,t);}createBucket(e){return new Bu(e)}queryRadius(){return Qa(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:n,geometry:i,transform:s,pixelsToTileUnits:o,pixelPosMatrix:a}){const l=el(e,this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),-s.bearingInRadians,o),u=this.paint.get("fill-extrusion-height").evaluate(t,n),c=this.paint.get("fill-extrusion-base").evaluate(t,n),h=function(e,t){const n=[];for(const i of e){const e=[i.x,i.y,0,1];A(e,e,t),n.push(new r(e[0]/e[3],e[1]/e[3]));}return n}(l,a),p=function(e,t,n,i){const s=[],o=[],a=i[8]*t,l=i[9]*t,u=i[10]*t,c=i[11]*t,h=i[8]*n,p=i[9]*n,f=i[10]*n,d=i[11]*n;for(const t of e){const e=[],n=[];for(const s of t){const t=s.x,o=s.y,y=i[0]*t+i[4]*o+i[12],m=i[1]*t+i[5]*o+i[13],g=i[2]*t+i[6]*o+i[14],x=i[3]*t+i[7]*o+i[15],v=g+u,b=x+c,w=y+h,_=m+p,S=g+f,A=x+d,T=new r((y+a)/b,(m+l)/b);T.z=v/b,e.push(T);const I=new r(w/A,_/A);I.z=S/A,n.push(I);}s.push(e),o.push(n);}return [s,o]}(i,c,u,a);return function(e,t,r){let n=1/0;qa(r,t)&&(n=$u(r,t[0]));for(let i=0;i<t.length;i++){const s=t[i],o=e[i];for(let e=0;e<s.length-1;e++){const t=s[e],i=[t,s[e+1],o[e+1],o[e],t];$a(r,i)&&(n=Math.min(n,$u(r,i)));}}return n!==1/0&&n}(p[0],p[1],h)}}function Nu(e,t){return e.x*t.x+e.y*t.y}function $u(e,t){if(1===e.length){let r=0;const n=t[r++];let i;for(;!i||n.equals(i);)if(i=t[r++],!i)return 1/0;for(;r<t.length;r++){const s=t[r],o=e[0],a=i.sub(n),l=s.sub(n),u=o.sub(n),c=Nu(a,a),h=Nu(a,l),p=Nu(l,l),f=Nu(u,a),d=Nu(u,l),y=c*p-h*h,m=(p*f-h*d)/y,g=(c*d-h*f)/y,x=n.z*(1-m-g)+i.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let e=1/0;for(const r of t)e=Math.min(e,r.z);return e}}const Uu=Qs([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"}],4),{members:qu}=Uu,ju=Qs([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Gu}=ju,Xu=Math.cos(Math.PI/180*37.5),Yu=Math.pow(2,14)/.5;class Zu{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=e.index,this.hasDependencies=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((e=>{this.gradients[e.id]={};})),this.layoutVertexArray=new Uo,this.layoutVertexArray2=new qo,this.indexArray=new Wo,this.programConfigurations=new Da(e.layers,e.zoom),this.segments=new ta,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id));}populate(e,t,r){this.hasDependencies=Bl("line",this.layers,t)||this.hasLineDasharray(this.layers);const n=this.layers[0].layout.get("line-sort-key"),i=!n.isConstant(),s=[];for(const{feature:t,id:o,index:a,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,u=La(t,e);if(!this.layers[0]._featureFilter.filter(new ks(this.zoom),u,r))continue;const c=i?n.evaluate(u,{},r):void 0,h={id:o,properties:t.properties,type:t.type,sourceLayerIndex:l,index:a,geometry:e?u.geometry:Ca(t),patterns:{},dashes:{},sortKey:c};s.push(h);}i&&s.sort(((e,t)=>e.sortKey-t.sortKey));for(const n of s){const{geometry:i,index:s,sourceLayerIndex:o}=n;this.hasDependencies?(Bl("line",this.layers,t)?zl("line",this.layers,n,{zoom:this.zoom},t):this.hasLineDasharray(this.layers)&&this.addLineDashDependencies(this.layers,n,this.zoom,t),this.patternFeatures.push(n)):this.addFeature(n,i,s,r,{},{},t.subdivisionGranularity),t.featureIndex.insert(e[s].feature,i,s,o,this.index);}}update(e,t,r,n){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(e,t,this.stateDependentLayers,{imagePositions:r,dashPositions:n});}addFeatures(e,t,r,n){for(const i of this.patternFeatures)this.addFeature(i,i.geometry,i.index,t,r,n,e.subdivisionGranularity);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=e.createVertexBuffer(this.layoutVertexArray2,Gu)),this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,qu),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(e){if(e.properties&&Object.prototype.hasOwnProperty.call(e.properties,"mapbox_clip_start")&&Object.prototype.hasOwnProperty.call(e.properties,"mapbox_clip_end"))return {start:+e.properties.mapbox_clip_start,end:+e.properties.mapbox_clip_end}}addFeature(e,t,r,n,i,s,o){const a=this.layers[0].layout,l=a.get("line-join").evaluate(e,{}),u=a.get("line-cap"),c=a.get("line-miter-limit"),h=a.get("line-round-limit");this.lineClips=this.lineFeatureClips(e);for(const r of t)this.addLine(r,e,l,u,c,h,n,o);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,r,{imagePositions:i,dashPositions:s,canonical:n});}addLine(e,t,r,n,i,s,o,a){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,e=pu(e,o?a.line.getGranularityForZoomLevel(o.z):1),this.lineClips){this.lineClipsArray.push(this.lineClips);for(let t=0;t<e.length-1;t++)this.totalDistance+=e[t].dist(e[t+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const l="Polygon"===Au.types[t.type];let u=e.length;for(;u>=2&&e[u-1].equals(e[u-2]);)u--;let c=0;for(;c<u-1&&e[c].equals(e[c+1]);)c++;if(u<(l?3:2))return;"bevel"===r&&(i=1.05);const h=this.overscaling<=16?122880/(512*this.overscaling):0,p=this.segments.prepareSegment(10*u,this.layoutVertexArray,this.indexArray);let f,d,y,m,g;this.e1=this.e2=-1,l&&(f=e[u-2],g=e[c].sub(f)._unit()._perp());for(let t=c;t<u;t++){if(y=t===u-1?l?e[c+1]:void 0:e[t+1],y&&e[t].equals(y))continue;g&&(m=g),f&&(d=f),f=e[t],g=y?y.sub(f)._unit()._perp():m,m=m||g;let o=m.add(g);0===o.x&&0===o.y||o._unit();const a=m.x*g.x+m.y*g.y,x=o.x*g.x+o.y*g.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<Xu&&d&&y,_=m.x*g.y-m.y*g.x>0;if(w&&t>c){const e=f.dist(d);if(e>2*h){const t=f.sub(f.sub(d)._mult(h/e)._round());this.updateDistance(d,t),this.addCurrentVertex(t,m,0,0,p),d=t;}}const S=d&&y;let A=S?r:l?"butt":n;if(S&&"round"===A&&(v<s?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>i&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<i&&(A="miter")),d&&this.updateDistance(d,f),"miter"===A)o._mult(v),this.addCurrentVertex(f,o,0,0,p);else if("flipbevel"===A){if(v>100)o=g.mult(-1);else {const e=v*m.add(g).mag()/m.sub(g).mag();o._perp()._mult(e*(_?-1:1));}this.addCurrentVertex(f,o,0,0,p),this.addCurrentVertex(f,o.mult(-1),0,0,p);}else if("bevel"===A||"fakeround"===A){const e=-Math.sqrt(v*v-1),t=_?e:0,r=_?0:e;if(d&&this.addCurrentVertex(f,m,t,r,p),"fakeround"===A){const e=Math.round(180*b/Math.PI/20);for(let t=1;t<e;t++){let r=t/e;if(.5!==r){const e=r-.5;r+=r*e*(r-1)*((1.0904+a*(a*(3.55645-1.43519*a)-3.2452))*e*e+(.848013+a*(.215638*a-1.06021)));}const n=g.sub(m)._mult(r)._add(m)._unit()._mult(_?-1:1);this.addHalfVertex(f,n.x,n.y,!1,_,0,p);}}y&&this.addCurrentVertex(f,g,-t,-r,p);}else if("butt"===A)this.addCurrentVertex(f,o,0,0,p);else if("square"===A){const e=d?1:-1;this.addCurrentVertex(f,o,e,e,p);}else "round"===A&&(d&&(this.addCurrentVertex(f,m,0,0,p),this.addCurrentVertex(f,m,1,1,p,!0)),y&&(this.addCurrentVertex(f,g,-1,-1,p,!0),this.addCurrentVertex(f,g,0,0,p)));if(w&&t<u-1){const e=f.dist(y);if(e>2*h){const t=f.add(y.sub(f)._mult(h/e)._round());this.updateDistance(f,t),this.addCurrentVertex(t,g,0,0,p),f=t;}}}}addCurrentVertex(e,t,r,n,i,s=!1){const o=t.y*n-t.x,a=-t.y-t.x*n;this.addHalfVertex(e,t.x+t.y*r,t.y-t.x*r,s,!1,r,i),this.addHalfVertex(e,o,a,s,!0,-n,i),this.distance>Yu/2&&0===this.totalDistance&&(this.distance=0,this.updateScaledDistance(),this.addCurrentVertex(e,t,r,n,i,s));}addHalfVertex({x:e,y:t},r,n,i,s,o,a){const l=.5*(this.lineClips?this.scaledDistance*(Yu-1):this.scaledDistance);this.layoutVertexArray.emplaceBack((e<<1)+(i?1:0),(t<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*n)+128,1+(0===o?0:o<0?-1:1)|(63&l)<<2,l>>6),this.lineClips&&this.layoutVertexArray2.emplaceBack((this.scaledDistance-this.lineClips.start)/(this.lineClips.end-this.lineClips.start),this.lineClipsArray.length);const u=a.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,u,this.e2),a.primitiveLength++),s?this.e2=u:this.e1=u;}updateScaledDistance(){this.scaledDistance=this.lineClips?this.lineClips.start+(this.lineClips.end-this.lineClips.start)*this.distance/this.totalDistance:this.distance;}updateDistance(e,t){this.distance+=e.dist(t),this.updateScaledDistance();}hasLineDasharray(e){for(const t of e){const e=t.paint.get("line-dasharray");if(e&&!e.isConstant())return !0}return !1}addLineDashDependencies(e,t,r,n){for(const i of e){const e=i.paint.get("line-dasharray");if(!e||"constant"===e.value.kind)continue;const s="round"===i.layout.get("line-cap"),o={dasharray:e.value.evaluate({zoom:r-1},t,{}),round:s},a={dasharray:e.value.evaluate({zoom:r},t,{}),round:s},l={dasharray:e.value.evaluate({zoom:r+1},t,{}),round:s},u=`${o.dasharray.join(",")},${o.round}`,c=`${a.dasharray.join(",")},${a.round}`,h=`${l.dasharray.join(",")},${l.round}`;n.dashDependencies[u]=o,n.dashDependencies[c]=a,n.dashDependencies[h]=l,t.dashes[i.id]={min:u,mid:c,max:h};}}}let Hu,Ku;ls("LineBucket",Zu,{omit:["layers","patternFeatures"]});var Wu={get paint(){return Ku=Ku||new Gs({"line-opacity":new $s(xe.paint_line["line-opacity"]),"line-color":new $s(xe.paint_line["line-color"]),"line-translate":new Ns(xe.paint_line["line-translate"]),"line-translate-anchor":new Ns(xe.paint_line["line-translate-anchor"]),"line-width":new $s(xe.paint_line["line-width"]),"line-gap-width":new $s(xe.paint_line["line-gap-width"]),"line-offset":new $s(xe.paint_line["line-offset"]),"line-blur":new $s(xe.paint_line["line-blur"]),"line-dasharray":new Us(xe.paint_line["line-dasharray"]),"line-pattern":new Us(xe.paint_line["line-pattern"]),"line-gradient":new js(xe.paint_line["line-gradient"])})},get layout(){return Hu=Hu||new Gs({"line-cap":new Ns(xe.layout_line["line-cap"]),"line-join":new $s(xe.layout_line["line-join"]),"line-miter-limit":new Ns(xe.layout_line["line-miter-limit"]),"line-round-limit":new Ns(xe.layout_line["line-round-limit"]),"line-sort-key":new $s(xe.layout_line["line-sort-key"])})}};class Ju extends $s{possiblyEvaluate(e,t){return t=new ks(Math.floor(t.zoom),{now:t.now,fadeDuration:t.fadeDuration,zoomHistory:t.zoomHistory,transition:t.transition}),super.possiblyEvaluate(e,t)}evaluate(e,t,r,n){return t=O({},t,{zoom:Math.floor(t.zoom)}),super.evaluate(e,t,r,n)}}let Qu;class ec extends Xs{constructor(e,t){super(e,Wu,t),this.gradientVersion=0,Qu||(Qu=new Ju(Wu.paint.properties["line-width"].specification),Qu.useIntegerZoom=!0);}_handleSpecialPaintPropertyUpdate(e){if("line-gradient"===e){const e=this.gradientExpression();this.stepInterpolant=!!function(e){return void 0!==e._styleExpression}(e)&&e._styleExpression.expression instanceof or,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER;}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(e,t){super.recalculate(e,t),this.paint._values["line-floorwidth"]=Qu.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,e);}createBucket(e){return new Zu(e)}queryRadius(e){const t=e,r=tc(Ja("line-width",this,t),Ja("line-gap-width",this,t)),n=Ja("line-offset",this,t);return r/2+Math.abs(n)+Qa(this.paint.get("line-translate"))}queryIntersectsFeature({queryGeometry:e,feature:t,featureState:n,geometry:i,transform:s,pixelsToTileUnits:o}){const a=el(e,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),-s.bearingInRadians,o),l=o/2*tc(this.paint.get("line-width").evaluate(t,n),this.paint.get("line-gap-width").evaluate(t,n)),u=this.paint.get("line-offset").evaluate(t,n);return u&&(i=function(e,t){const n=[];for(let i=0;i<e.length;i++){const s=e[i],o=[];for(let e=0;e<s.length;e++){const n=s[e-1],i=s[e],a=s[e+1],l=0===e?new r(0,0):i.sub(n)._unit()._perp(),u=e===s.length-1?new r(0,0):a.sub(i)._unit()._perp(),c=l._add(u)._unit(),h=c.x*u.x+c.y*u.y;0!==h&&c._mult(1/h),o.push(c._mult(t)._add(i));}n.push(o);}return n}(i,u*o)),function(e,t,r){for(let n=0;n<t.length;n++){const i=t[n];if(e.length>=3)for(let t=0;t<i.length;t++)if(Ka(e,i[t]))return !0;if(ja(e,i,r))return !0}return !1}(a,i,l)}isTileClipped(){return !0}}function tc(e,t){return t>0?t+2*e:e}const rc=Qs([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),nc=Qs([{name:"a_projected_pos",components:3,type:"Float32"}],4);Qs([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const ic=Qs([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"},{name:"a_box_real",components:2,type:"Int16"}]);Qs([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Int16",name:"x1"},{type:"Int16",name:"y1"},{type:"Int16",name:"x2"},{type:"Int16",name:"y2"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const sc=Qs([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),oc=Qs([{name:"a_pos",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function ac(e,t,r){return e.sections.forEach((e=>{e.text=function(e,t,r){const n=t.layout.get("text-transform").evaluate(r,{});return "uppercase"===n?e=e.toLocaleUpperCase():"lowercase"===n&&(e=e.toLocaleLowerCase()),Ms.applyArabicShaping&&(e=Ms.applyArabicShaping(e)),e}(e.text,t,r);})),e}Qs([{name:"triangle",components:3,type:"Uint16"}]),Qs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),Qs([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Uint16",name:"textAnchorOffsetStartIndex"},{type:"Uint16",name:"textAnchorOffsetEndIndex"}]),Qs([{type:"Float32",name:"offsetX"}]),Qs([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]),Qs([{type:"Uint16",name:"textAnchor"},{type:"Float32",components:2,name:"textOffset"}]);var lc=24;const uc={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","⋯":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"},cc={10:!0,32:!0,38:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0},hc={40:!0};function pc(e,t,r,n,i,s){if("fontStack"in t){const n=r[t.fontStack],s=n&&n[e];return s?s.metrics.advance*t.scale+i:0}{const e=n[t.imageName];return e?e.displaySize[0]*t.scale*lc/s+i:0}}function fc(e,t,r,n){const i=Math.pow(e-t,2);return n?e<t?i/2:2*i:i+Math.abs(r)*r}function dc(e,t,r){let n=0;return 10===e&&(n-=1e4),r&&(n+=150),40!==e&&65288!==e||(n+=50),41!==t&&65289!==t||(n+=50),n}function yc(e,t,r,n,i,s){let o=null,a=fc(t,r,i,s);for(const e of n){const n=fc(t-e.x,r,i,s)+e.badness;n<=a&&(o=e,a=n);}return {index:e,x:t,priorBreak:o,badness:a}}function mc(e){return e?mc(e.priorBreak).concat(e.index):[]}class gc{constructor(e="",t=[],r=[]){this.text=e,this.sections=t,this.sectionIndex=r,this.imageSectionID=null;}static fromFeature(e,t){const r=new gc;for(let n=0;n<e.sections.length;n++){const i=e.sections[n];i.image?r.addImageSection(i):r.addTextSection(i,t);}return r}length(){return [...this.text].length}getSection(e){return this.sections[this.sectionIndex[e]]}getSectionIndex(e){return this.sectionIndex[e]}verticalizePunctuation(){this.text=function(e){let t="",r={premature:!0,value:void 0};const n=e[Symbol.iterator]();let i=n.next();const s=e[Symbol.iterator]();s.next();let o=s.next();for(;!i.done;)t+=!o.done&&Ss(o.value.codePointAt(0))&&!uc[o.value]||!r.premature&&Ss(r.value.codePointAt(0))&&!uc[r.value]||!uc[i.value]?i.value:uc[i.value],r={value:i.value,premature:!1},i=n.next(),o=s.next();return t}(this.text);}hasZeroWidthSpaces(){return this.text.includes("​")}trim(){const e=this.text.match(/^\s*/),t=e?e[0].length:0,r=this.text.match(/\S\s*$/),n=r?r[0].length-1:0;this.text=this.text.substring(t,this.text.length-n),this.sectionIndex=this.sectionIndex.slice(t,this.sectionIndex.length-n);}substring(e,t){const r=[...this.text].slice(e,t).join(""),n=this.sectionIndex.slice(e,t);return new gc(r,this.sections,n)}toCodeUnitIndex(e){return [...this.text].slice(0,e).join("").length}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce(((e,t)=>Math.max(e,this.sections[t].scale)),0)}getMaxImageSize(e){let t=0,r=0;for(let n=0;n<this.length();n++){const i=this.getSection(n);if("imageName"in i){const n=e[i.imageName];if(!n)continue;const s=n.displaySize;t=Math.max(t,s[0]),r=Math.max(r,s[1]);}}return {maxImageWidth:t,maxImageHeight:r}}addTextSection(e,t){this.text+=e.text,this.sections.push({scale:e.scale||1,verticalAlign:e.verticalAlign||"bottom",fontStack:e.fontStack||t});const r=this.sections.length-1;this.sectionIndex.push(...[...e.text].map((()=>r)));}addImageSection(e){const t=e.image?e.image.name:"";if(0===t.length)return void j("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push({scale:1,verticalAlign:e.verticalAlign||"bottom",imageName:t}),this.sectionIndex.push(this.sections.length-1)):j("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}determineLineBreaks(e,t,r,n,i){const s=[],o=this.determineAverageLineWidth(e,t,r,n,i),a=this.hasZeroWidthSpaces();let l=0,u=0;const c=this.text[Symbol.iterator]();let h=c.next();const p=this.text[Symbol.iterator]();p.next();let f=p.next();const d=this.text[Symbol.iterator]();d.next(),d.next();let y=d.next();for(;!h.done;){const t=this.getSection(u),m=h.value.codePointAt(0);if(gs(m)||(l+=pc(m,t,r,n,e,i)),!f.done){const e=ys(m),r=f.value.codePointAt(0);(cc[m]||e||"imageName"in t||!y.done&&hc[r])&&s.push(yc(u+1,l,o,s,dc(m,r,e&&a),!1));}u++,h=c.next(),f=p.next(),y=d.next();}return mc(yc(this.length(),l,o,s,0,!0))}determineAverageLineWidth(e,t,r,n,i){let s=0,o=0;for(const t of this.text){const a=this.getSection(o);s+=pc(t.codePointAt(0),a,r,n,e,i),o++;}return s/Math.max(1,Math.ceil(s/t))}}const xc=4294967296,vc=1/xc,bc="undefined"==typeof TextDecoder?null:new TextDecoder("utf-8");class wc{constructor(e=new Uint8Array(16)){this.buf=ArrayBuffer.isView(e)?e:new Uint8Array(e),this.dataView=new DataView(this.buf.buffer),this.pos=0,this.type=0,this.length=this.buf.length;}readFields(e,t,r=this.length){for(;this.pos<r;){const r=this.readVarint(),n=r>>3,i=this.pos;this.type=7&r,e(n,t,this),this.pos===i&&this.skip(r);}return t}readMessage(e,t){return this.readFields(e,t,this.readVarint()+this.pos)}readFixed32(){const e=this.dataView.getUint32(this.pos,!0);return this.pos+=4,e}readSFixed32(){const e=this.dataView.getInt32(this.pos,!0);return this.pos+=4,e}readFixed64(){const e=this.dataView.getUint32(this.pos,!0)+this.dataView.getUint32(this.pos+4,!0)*xc;return this.pos+=8,e}readSFixed64(){const e=this.dataView.getUint32(this.pos,!0)+this.dataView.getInt32(this.pos+4,!0)*xc;return this.pos+=8,e}readFloat(){const e=this.dataView.getFloat32(this.pos,!0);return this.pos+=4,e}readDouble(){const e=this.dataView.getFloat64(this.pos,!0);return this.pos+=8,e}readVarint(e){const t=this.buf;let r,n;return n=t[this.pos++],r=127&n,n<128?r:(n=t[this.pos++],r|=(127&n)<<7,n<128?r:(n=t[this.pos++],r|=(127&n)<<14,n<128?r:(n=t[this.pos++],r|=(127&n)<<21,n<128?r:(n=t[this.pos],r|=(15&n)<<28,function(e,t,r){const n=r.buf;let i,s;if(s=n[r.pos++],i=(112&s)>>4,s<128)return _c(e,i,t);if(s=n[r.pos++],i|=(127&s)<<3,s<128)return _c(e,i,t);if(s=n[r.pos++],i|=(127&s)<<10,s<128)return _c(e,i,t);if(s=n[r.pos++],i|=(127&s)<<17,s<128)return _c(e,i,t);if(s=n[r.pos++],i|=(127&s)<<24,s<128)return _c(e,i,t);if(s=n[r.pos++],i|=(1&s)<<31,s<128)return _c(e,i,t);throw new Error("Expected varint not more than 10 bytes")}(r,e,this)))))}readVarint64(){return this.readVarint(!0)}readSVarint(){const e=this.readVarint();return e%2==1?(e+1)/-2:e/2}readBoolean(){return Boolean(this.readVarint())}readString(){const e=this.readVarint()+this.pos,t=this.pos;return this.pos=e,e-t>=12&&bc?bc.decode(this.buf.subarray(t,e)):function(e,t,r){let n="",i=t;for(;i<r;){const t=e[i];let s,o,a,l=null,u=t>239?4:t>223?3:t>191?2:1;if(i+u>r)break;1===u?t<128&&(l=t):2===u?(s=e[i+1],128==(192&s)&&(l=(31&t)<<6|63&s,l<=127&&(l=null))):3===u?(s=e[i+1],o=e[i+2],128==(192&s)&&128==(192&o)&&(l=(15&t)<<12|(63&s)<<6|63&o,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=e[i+1],o=e[i+2],a=e[i+3],128==(192&s)&&128==(192&o)&&128==(192&a)&&(l=(15&t)<<18|(63&s)<<12|(63&o)<<6|63&a,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u;}return n}(this.buf,t,e)}readBytes(){const e=this.readVarint()+this.pos,t=this.buf.subarray(this.pos,e);return this.pos=e,t}readPackedVarint(e=[],t){const r=this.readPackedEnd();for(;this.pos<r;)e.push(this.readVarint(t));return e}readPackedSVarint(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSVarint());return e}readPackedBoolean(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readBoolean());return e}readPackedFloat(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFloat());return e}readPackedDouble(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readDouble());return e}readPackedFixed32(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFixed32());return e}readPackedSFixed32(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSFixed32());return e}readPackedFixed64(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readFixed64());return e}readPackedSFixed64(e=[]){const t=this.readPackedEnd();for(;this.pos<t;)e.push(this.readSFixed64());return e}readPackedEnd(){return 2===this.type?this.readVarint()+this.pos:this.pos+1}skip(e){const t=7&e;if(0===t)for(;this.buf[this.pos++]>127;);else if(2===t)this.pos=this.readVarint()+this.pos;else if(5===t)this.pos+=4;else {if(1!==t)throw new Error(`Unimplemented type: ${t}`);this.pos+=8;}}writeTag(e,t){this.writeVarint(e<<3|t);}realloc(e){let t=this.length||16;for(;t<this.pos+e;)t*=2;if(t!==this.length){const e=new Uint8Array(t);e.set(this.buf),this.buf=e,this.dataView=new DataView(e.buffer),this.length=t;}}finish(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)}writeFixed32(e){this.realloc(4),this.dataView.setInt32(this.pos,e,!0),this.pos+=4;}writeSFixed32(e){this.realloc(4),this.dataView.setInt32(this.pos,e,!0),this.pos+=4;}writeFixed64(e){this.realloc(8),this.dataView.setInt32(this.pos,-1&e,!0),this.dataView.setInt32(this.pos+4,Math.floor(e*vc),!0),this.pos+=8;}writeSFixed64(e){this.realloc(8),this.dataView.setInt32(this.pos,-1&e,!0),this.dataView.setInt32(this.pos+4,Math.floor(e*vc),!0),this.pos+=8;}writeVarint(e){(e=+e||0)>268435455||e<0?function(e,t){let r,n;if(e>=0?(r=e%4294967296|0,n=e/4294967296|0):(r=~(-e%4294967296),n=~(-e/4294967296),4294967295^r?r=r+1|0:(r=0,n=n+1|0)),e>=0x10000000000000000||e<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");t.realloc(10),function(e,t,r){r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,e>>>=7,r.buf[r.pos++]=127&e|128,r.buf[r.pos]=127&(e>>>=7);}(r,0,t),function(e,t){const r=(7&e)<<4;t.buf[t.pos++]|=r|((e>>>=3)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e)))));}(n,t);}(e,this):(this.realloc(4),this.buf[this.pos++]=127&e|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=e>>>7&127))));}writeSVarint(e){this.writeVarint(e<0?2*-e-1:2*e);}writeBoolean(e){this.writeVarint(+e);}writeString(e){e=String(e),this.realloc(4*e.length),this.pos++;const t=this.pos;this.pos=function(e,t,r){for(let n,i,s=0;s<t.length;s++){if(n=t.charCodeAt(s),n>55295&&n<57344){if(!i){n>56319||s+1===t.length?(e[r++]=239,e[r++]=191,e[r++]=189):i=n;continue}if(n<56320){e[r++]=239,e[r++]=191,e[r++]=189,i=n;continue}n=i-55296<<10|n-56320|65536,i=null;}else i&&(e[r++]=239,e[r++]=191,e[r++]=189,i=null);n<128?e[r++]=n:(n<2048?e[r++]=n>>6|192:(n<65536?e[r++]=n>>12|224:(e[r++]=n>>18|240,e[r++]=n>>12&63|128),e[r++]=n>>6&63|128),e[r++]=63&n|128);}return r}(this.buf,e,this.pos);const r=this.pos-t;r>=128&&Sc(t,r,this),this.pos=t-1,this.writeVarint(r),this.pos+=r;}writeFloat(e){this.realloc(4),this.dataView.setFloat32(this.pos,e,!0),this.pos+=4;}writeDouble(e){this.realloc(8),this.dataView.setFloat64(this.pos,e,!0),this.pos+=8;}writeBytes(e){const t=e.length;this.writeVarint(t),this.realloc(t);for(let r=0;r<t;r++)this.buf[this.pos++]=e[r];}writeRawMessage(e,t){this.pos++;const r=this.pos;e(t,this);const n=this.pos-r;n>=128&&Sc(r,n,this),this.pos=r-1,this.writeVarint(n),this.pos+=n;}writeMessage(e,t,r){this.writeTag(e,2),this.writeRawMessage(t,r);}writePackedVarint(e,t){t.length&&this.writeMessage(e,Ac,t);}writePackedSVarint(e,t){t.length&&this.writeMessage(e,Tc,t);}writePackedBoolean(e,t){t.length&&this.writeMessage(e,Mc,t);}writePackedFloat(e,t){t.length&&this.writeMessage(e,Ic,t);}writePackedDouble(e,t){t.length&&this.writeMessage(e,Ec,t);}writePackedFixed32(e,t){t.length&&this.writeMessage(e,kc,t);}writePackedSFixed32(e,t){t.length&&this.writeMessage(e,Fc,t);}writePackedFixed64(e,t){t.length&&this.writeMessage(e,Dc,t);}writePackedSFixed64(e,t){t.length&&this.writeMessage(e,Pc,t);}writeBytesField(e,t){this.writeTag(e,2),this.writeBytes(t);}writeFixed32Field(e,t){this.writeTag(e,5),this.writeFixed32(t);}writeSFixed32Field(e,t){this.writeTag(e,5),this.writeSFixed32(t);}writeFixed64Field(e,t){this.writeTag(e,1),this.writeFixed64(t);}writeSFixed64Field(e,t){this.writeTag(e,1),this.writeSFixed64(t);}writeVarintField(e,t){this.writeTag(e,0),this.writeVarint(t);}writeSVarintField(e,t){this.writeTag(e,0),this.writeSVarint(t);}writeStringField(e,t){this.writeTag(e,2),this.writeString(t);}writeFloatField(e,t){this.writeTag(e,5),this.writeFloat(t);}writeDoubleField(e,t){this.writeTag(e,1),this.writeDouble(t);}writeBooleanField(e,t){this.writeVarintField(e,+t);}}function _c(e,t,r){return r?4294967296*t+(e>>>0):4294967296*(t>>>0)+(e>>>0)}function Sc(e,t,r){const n=t<=16383?1:t<=2097151?2:t<=268435455?3:Math.floor(Math.log(t)/(7*Math.LN2));r.realloc(n);for(let t=r.pos-1;t>=e;t--)r.buf[t+n]=r.buf[t];}function Ac(e,t){for(let r=0;r<e.length;r++)t.writeVarint(e[r]);}function Tc(e,t){for(let r=0;r<e.length;r++)t.writeSVarint(e[r]);}function Ic(e,t){for(let r=0;r<e.length;r++)t.writeFloat(e[r]);}function Ec(e,t){for(let r=0;r<e.length;r++)t.writeDouble(e[r]);}function Mc(e,t){for(let r=0;r<e.length;r++)t.writeBoolean(e[r]);}function kc(e,t){for(let r=0;r<e.length;r++)t.writeFixed32(e[r]);}function Fc(e,t){for(let r=0;r<e.length;r++)t.writeSFixed32(e[r]);}function Dc(e,t){for(let r=0;r<e.length;r++)t.writeFixed64(e[r]);}function Pc(e,t){for(let r=0;r<e.length;r++)t.writeSFixed64(e[r]);}function Bc(e,t,r){1===e&&r.readMessage(zc,t);}function zc(e,t,r){if(3===e){const{id:e,bitmap:n,width:i,height:s,left:o,top:a,advance:l}=r.readMessage(Vc,{});t.push({id:e,bitmap:new gl({width:i+6,height:s+6},n),metrics:{width:i,height:s,left:o,top:a,advance:l}});}}function Vc(e,t,r){1===e?t.id=r.readVarint():2===e?t.bitmap=r.readBytes():3===e?t.width=r.readVarint():4===e?t.height=r.readVarint():5===e?t.left=r.readSVarint():6===e?t.top=r.readSVarint():7===e&&(t.advance=r.readVarint());}function Cc(e){let t=0,r=0;for(const n of e)t+=n.w*n.h,r=Math.max(r,n.w);e.sort(((e,t)=>t.h-e.h));const n=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(t/.95)),r),h:1/0}];let i=0,s=0;for(const t of e)for(let e=n.length-1;e>=0;e--){const r=n[e];if(!(t.w>r.w||t.h>r.h)){if(t.x=r.x,t.y=r.y,s=Math.max(s,t.y+t.h),i=Math.max(i,t.x+t.w),t.w===r.w&&t.h===r.h){const t=n.pop();t&&e<n.length&&(n[e]=t);}else t.h===r.h?(r.x+=t.w,r.w-=t.w):t.w===r.w?(r.y+=t.h,r.h-=t.h):(n.push({x:r.x+t.w,y:r.y,w:r.w-t.w,h:t.h}),r.y+=t.h,r.h-=t.h);break}}return {w:i,h:s,fill:t/(i*s)||0}}class Lc{constructor(e,{pixelRatio:t,version:r,stretchX:n,stretchY:i,content:s,textFitWidth:o,textFitHeight:a}){this.paddedRect=e,this.pixelRatio=t,this.stretchX=n,this.stretchY=i,this.content=s,this.version=r,this.textFitWidth=o,this.textFitHeight=a;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Oc{constructor(e,t){const r={},n={};this.haveRenderCallbacks=[];const i=[];this.addImages(e,r,i),this.addImages(t,n,i);const{w:s,h:o}=Cc(i),a=new xl({width:s||1,height:o||1});for(const t in e){const n=e[t],i=r[t].paddedRect;xl.copy(n.data,a,{x:0,y:0},{x:i.x+1,y:i.y+1},n.data);}for(const e in t){const r=t[e],i=n[e].paddedRect,s=i.x+1,o=i.y+1,l=r.data.width,u=r.data.height;xl.copy(r.data,a,{x:0,y:0},{x:s,y:o},r.data),xl.copy(r.data,a,{x:0,y:u-1},{x:s,y:o-1},{width:l,height:1}),xl.copy(r.data,a,{x:0,y:0},{x:s,y:o+u},{width:l,height:1}),xl.copy(r.data,a,{x:l-1,y:0},{x:s-1,y:o},{width:1,height:u}),xl.copy(r.data,a,{x:0,y:0},{x:s+l,y:o},{width:1,height:u});}this.image=a,this.iconPositions=r,this.patternPositions=n;}addImages(e,t,r){for(const n in e){const i=e[n],s={x:0,y:0,w:i.data.width+2,h:i.data.height+2};r.push(s),t[n]=new Lc(s,i),i.hasRenderCallback&&this.haveRenderCallbacks.push(n);}}patchUpdatedImages(e,t){e.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in e.updatedImages)this.patchUpdatedImage(this.iconPositions[r],e.getImage(r),t),this.patchUpdatedImage(this.patternPositions[r],e.getImage(r),t);}patchUpdatedImage(e,t,r){if(!e||!t)return;if(e.version===t.version)return;e.version=t.version;const[n,i]=e.tl;r.update(t.data,void 0,{x:n,y:i});}}var Rc;function Nc(t,r,n,i,s,o,a,l,u,c,h,p,f,d,y){const m=gc.fromFeature(t,s);let g;p===e.ay.vertical&&m.verticalizePunctuation();let x=m.determineLineBreaks(c,o,r,i,d);const{processBidirectionalText:v,processStyledBidirectionalText:b}=Ms;if(v&&1===m.sections.length){g=[],x=x.map((e=>m.toCodeUnitIndex(e)));const e=v(m.toString(),x);for(const t of e){const e=[...t].map((()=>0));g.push(new gc(t,m.sections,e));}}else if(b){g=[],x=x.map((e=>m.toCodeUnitIndex(e)));let e=0;const t=[];for(const r of m.text)t.push(...Array(r.length).fill(m.sectionIndex[e])),e++;const r=b(m.text,t,x);for(const e of r){const t=[];let r="";for(const n of e[0])t.push(e[1][r.length]),r+=n;g.push(new gc(e[0],m.sections,t));}}else g=function(e,t){const r=[];let n=0;for(const i of t)r.push(e.substring(n,i)),n=i;return n<e.length()&&r.push(e.substring(n,e.length())),r}(m,x);const w=[],_={positionedLines:w,text:m.toString(),top:h[1],bottom:h[1],left:h[0],right:h[0],writingMode:p,iconsInText:!1,verticalizable:!1};return function(e,t,r,n,i,s,o,a,l,u,c,h){let p=0,f=0,d=0,y=0;const m="right"===a?1:"left"===a?0:.5,g=lc/h;let x=0;for(const o of i){o.trim();const i=o.getMaxScale(),a={positionedGlyphs:[],lineOffset:0};e.positionedLines[x]=a;const h=a.positionedGlyphs;let v=0;if(!o.length()){f+=s,++x;continue}const b=Uc(n,o,g);let w=0;for(const s of o.text){const a=o.getSection(w),d=s.codePointAt(0),y=jc(l,c,d),m={glyph:d,imageName:null,x:p,y:f+-17,vertical:y,scale:1,fontStack:"",sectionIndex:o.getSectionIndex(w),metrics:null,rect:null};let x;if("fontStack"in a){if(x=Gc(a,d,y,b,t,r),!x)continue;m.fontStack=a.fontStack;}else {if(e.iconsInText=!0,a.scale*=g,x=Xc(a,y,i,b,n),!x)continue;v=Math.max(v,x.imageOffset),m.imageName=a.imageName;}const{rect:_,metrics:S,baselineOffset:A}=x;m.y+=A,m.scale=a.scale,m.metrics=S,m.rect=_,h.push(m),y?(e.verticalizable=!0,p+=("imageName"in a?S.advance:lc)*a.scale+u):p+=S.advance*a.scale+u,w++;}0!==h.length&&(d=Math.max(p-u,d),Yc(h,0,h.length-1,m)),p=0,a.lineOffset=Math.max(v,(i-1)*lc);const _=s*i+v;f+=_,y=Math.max(_,y),++x;}const{horizontalAlign:v,verticalAlign:b}=$c(o);((function(e,t,r,n,i,s,o,a,l){const u=(t-r)*i;let c=0;c=s!==o?-a*n- -17:-n*l*o+.5*o;for(const t of e)for(const e of t.positionedGlyphs)e.x+=u,e.y+=c;}))(e.positionedLines,m,v,b,d,y,s,f,i.length),e.top+=-b*f,e.bottom=e.top+f,e.left+=-v*d,e.right=e.left+d;}(_,r,n,i,g,a,l,u,p,c,f,y),!function(e){for(const t of e)if(0!==t.positionedGlyphs.length)return !1;return !0}(w)&&_}function $c(e){let t=.5,r=.5;switch(e){case "right":case "top-right":case "bottom-right":t=1;break;case "left":case "top-left":case "bottom-left":t=0;}switch(e){case "bottom":case "bottom-right":case "bottom-left":r=1;break;case "top":case "top-right":case "top-left":r=0;}return {horizontalAlign:t,verticalAlign:r}}function Uc(e,t,r){const n=t.getMaxScale()*lc,{maxImageWidth:i,maxImageHeight:s}=t.getMaxImageSize(e),o=Math.max(n,s*r);return {verticalLineContentWidth:Math.max(n,i*r),horizontalLineContentHeight:o}}function qc(e){switch(e){case "top":return 0;case "center":return .5;default:return 1}}function jc(t,r,n){return !(t===e.ay.horizontal||!r&&!ms(n)||r&&(gs(n)||(i=n,/\p{sc=Arab}/u.test(String.fromCodePoint(i)))));var i;}function Gc(e,t,r,n,i,s){const o=s[e.fontStack],a=function(e,t,r,n){if(e&&e.rect)return e;const i=t[r.fontStack],s=i&&i[n];return s?{rect:null,metrics:s.metrics}:null}(o&&o[t],i,e,t);if(null===a)return null;let l;if(r)l=n.verticalLineContentWidth-e.scale*lc;else {const t=qc(e.verticalAlign);l=(n.horizontalLineContentHeight-e.scale*lc)*t;}return {rect:a.rect,metrics:a.metrics,baselineOffset:l}}function Xc(e,t,r,n,i){const s=i[e.imageName];if(!s)return null;const o=s.paddedRect,a=s.displaySize,l={width:a[0],height:a[1],left:1,top:-3,advance:t?a[1]:a[0]};let u;if(t)u=n.verticalLineContentWidth-a[1]*e.scale;else {const t=qc(e.verticalAlign);u=(n.horizontalLineContentHeight-a[1]*e.scale)*t;}return {rect:o,metrics:l,baselineOffset:u,imageOffset:(t?a[0]:a[1])*e.scale-lc*r}}function Yc(e,t,r,n){if(0===n)return;const i=e[r],s=(e[r].x+i.metrics.advance*i.scale)*n;for(let n=t;n<=r;n++)e[n].x-=s;}function Zc(e,t,r){const{horizontalAlign:n,verticalAlign:i}=$c(r),s=t[0]-e.displaySize[0]*n,o=t[1]-e.displaySize[1]*i;return {image:e,top:o,bottom:o+e.displaySize[1],left:s,right:s+e.displaySize[0]}}function Hc(e){var t,r;let n=e.left,i=e.top,s=e.right-n,o=e.bottom-i;const a=null!==(t=e.image.textFitWidth)&&void 0!==t?t:"stretchOrShrink",l=null!==(r=e.image.textFitHeight)&&void 0!==r?r:"stretchOrShrink",u=(e.image.content[2]-e.image.content[0])/(e.image.content[3]-e.image.content[1]);if("proportional"===l){if("stretchOnly"===a&&s/o<u||"proportional"===a){const e=Math.ceil(o*u);n*=e/s,s=e;}}else if("proportional"===a&&"stretchOnly"===l&&0!==u&&s/o>u){const e=Math.ceil(s/u);i*=e/o,o=e;}return {x1:n,y1:i,x2:n+s,y2:i+o}}function Kc(e,t,r,n,i,s){const o=e.image;let a;if(o.content){const e=o.content,t=o.pixelRatio||1;a=[e[0]/t,e[1]/t,o.displaySize[0]-e[2]/t,o.displaySize[1]-e[3]/t];}const l=t.left*s,u=t.right*s;let c,h,p,f;"width"===r||"both"===r?(f=i[0]+l-n[3],h=i[0]+u+n[1]):(f=i[0]+(l+u-o.displaySize[0])/2,h=f+o.displaySize[0]);const d=t.top*s,y=t.bottom*s;return "height"===r||"both"===r?(c=i[1]+d-n[0],p=i[1]+y+n[2]):(c=i[1]+(d+y-o.displaySize[1])/2,p=c+o.displaySize[1]),{image:o,top:c,right:h,bottom:p,left:f,collisionPadding:a}}ls("ImagePosition",Lc),ls("ImageAtlas",Oc),e.ay=void 0,(Rc=e.ay||(e.ay={}))[Rc.none=0]="none",Rc[Rc.horizontal=1]="horizontal",Rc[Rc.vertical=2]="vertical",Rc[Rc.horizontalOnly=3]="horizontalOnly";const Wc=128,Jc=32640;function Qc(e,t){const{expression:r}=t;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new ks(e+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:t,interpolationType:n}=r;let i=0;for(;i<t.length&&t[i]<=e;)i++;i=Math.max(0,i-1);let s=i;for(;s<t.length&&t[s]<e+1;)s++;s=Math.min(t.length-1,s);const o=t[i],a=t[s];return "composite"===r.kind?{kind:"composite",minZoom:o,maxZoom:a,interpolationType:n}:{kind:"camera",minZoom:o,maxZoom:a,minSize:r.evaluate(new ks(o)),maxSize:r.evaluate(new ks(a)),interpolationType:n}}}function eh(e,t,r){let n="never";const i=e.get(t);return i?n=i:e.get(r)&&(n="always"),n}const th=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function rh(e,t,r,n,i,s,o,a,l,u,c,h,p){const f=a?Math.min(Jc,Math.round(a[0])):0,d=a?Math.min(Jc,Math.round(a[1])):0;e.emplaceBack(t,r,Math.round(32*n),Math.round(32*i),s,o,(f<<1)+(l?1:0),d,16*u,16*c,256*h,256*p);}function nh(e,t,r){e.emplaceBack(t.x,t.y,r),e.emplaceBack(t.x,t.y,r),e.emplaceBack(t.x,t.y,r),e.emplaceBack(t.x,t.y,r);}function ih(e){for(const t of e.sections)if(Es(t.text))return !0;return !1}class sh{constructor(e){this.layoutVertexArray=new Xo,this.indexArray=new Wo,this.programConfigurations=e,this.segments=new ta,this.dynamicLayoutVertexArray=new Yo,this.opacityVertexArray=new Zo,this.hasVisibleVertices=!1,this.placedSymbolArray=new ko;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(e,t,r,n){this.isEmpty()||(r&&(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,rc.members),this.indexBuffer=e.createIndexBuffer(this.indexArray,t),this.dynamicLayoutVertexBuffer=e.createVertexBuffer(this.dynamicLayoutVertexArray,nc.members,!0),this.opacityVertexBuffer=e.createVertexBuffer(this.opacityVertexArray,th,!0),this.opacityVertexBuffer.itemSize=1),(r||n)&&this.programConfigurations.upload(e));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}ls("SymbolBuffers",sh);class oh{constructor(e,t,r){this.layoutVertexArray=new e,this.layoutAttributes=t,this.indexArray=new r,this.segments=new ta,this.collisionVertexArray=new Ko;}upload(e){this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=e.createVertexBuffer(this.collisionVertexArray,ic.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy());}}ls("CollisionBuffers",oh);class ah{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map((e=>e.id)),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasDependencies=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[];const r=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Qc(this.zoom,r["text-size"]),this.iconSizeData=Qc(this.zoom,r["icon-size"]);const n=this.layers[0].layout,i=n.get("symbol-sort-key"),s=n.get("symbol-z-order");this.canOverlap="never"!==eh(n,"text-overlap","text-allow-overlap")||"never"!==eh(n,"icon-overlap","icon-allow-overlap")||n.get("text-ignore-placement")||n.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==s&&!i.isConstant(),this.sortFeaturesByY=("viewport-y"===s||"auto"===s&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===n.get("symbol-placement")&&(this.writingModes=n.get("text-writing-mode").map((t=>e.ay[t]))),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.sourceID=t.sourceID;}createArrays(){this.text=new sh(new Da(this.layers,this.zoom,(e=>/^text/.test(e)))),this.icon=new sh(new Da(this.layers,this.zoom,(e=>/^icon/.test(e)))),this.glyphOffsetArray=new Po,this.lineVertexArray=new Bo,this.symbolInstances=new Do,this.textAnchorOffsets=new Vo;}calculateGlyphDependencies(e,t,r,n,i){for(const s of e)if(t[s.codePointAt(0)]=!0,(r||n)&&i){const e=uc[s];e&&(t[e.codePointAt(0)]=!0);}}populate(t,r,n){const i=this.layers[0],s=i.layout,o=s.get("text-font"),a=s.get("text-field"),l=s.get("icon-image"),u=("constant"!==a.value.kind||a.value.value instanceof Ft&&!a.value.value.isEmpty()||a.value.value.toString().length>0)&&("constant"!==o.value.kind||o.value.value.length>0),c="constant"!==l.value.kind||!!l.value.value||Object.keys(l.parameters).length>0,h=s.get("symbol-sort-key");if(this.features=[],!u&&!c)return;const p=r.iconDependencies,f=r.glyphDependencies,d=r.availableImages,y=new ks(this.zoom);for(const{feature:r,id:a,index:l,sourceLayerIndex:m}of t){const t=i._featureFilter.needGeometry,g=La(r,t);if(!i._featureFilter.filter(y,g,n))continue;let x,v;if(t||(g.geometry=Ca(r)),u){const e=i.getValueAndResolveTokens("text-field",g,n,d),t=Ft.factory(e),r=this.hasRTLText=this.hasRTLText||ih(t);(!r||"unavailable"===Ms.getRTLTextPluginStatus()||r&&Ms.isParsed())&&(x=ac(t,i,g));}if(c){const e=i.getValueAndResolveTokens("icon-image",g,n,d);v=e instanceof Lt?e:Lt.fromString(e);}if(!x&&!v)continue;const b=this.sortFeaturesByKey?h.evaluate(g,{},n):void 0;if(this.features.push({id:a,text:x,icon:v,index:l,sourceLayerIndex:m,geometry:g.geometry,properties:r.properties,type:Au.types[r.type],sortKey:b}),v&&(p[v.name]=!0),x){const t=o.evaluate(g,{},n).join(","),r="viewport"!==s.get("text-rotation-alignment")&&"point"!==s.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(e.ay.vertical)>=0;for(const e of x.sections)if(e.image)p[e.image.name]=!0;else {const n=xs(x.toString()),i=e.fontStack||t,s=f[i]=f[i]||{};this.calculateGlyphDependencies(e.text,s,r,this.allowVerticalPlacement,n);}}}"line"===s.get("symbol-placement")&&(this.features=function(e){const t={},r={},n=[];let i=0;function s(t){n.push(e[t]),i++;}function o(e,t,i){const s=r[e];return delete r[e],r[t]=s,n[s].geometry[0].pop(),n[s].geometry[0]=n[s].geometry[0].concat(i[0]),s}function a(e,r,i){const s=t[r];return delete t[r],t[e]=s,n[s].geometry[0].shift(),n[s].geometry[0]=i[0].concat(n[s].geometry[0]),s}function l(e,t,r){const n=r?t[0][t[0].length-1]:t[0][0];return `${e}:${n.x}:${n.y}`}for(let u=0;u<e.length;u++){const c=e[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const f=l(p,h),d=l(p,h,!0);if(f in r&&d in t&&r[f]!==t[d]){const e=a(f,d,h),i=o(f,d,n[e].geometry);delete t[f],delete r[d],r[l(p,n[i].geometry,!0)]=i,n[e].geometry=null;}else f in r?o(f,d,h):d in t?a(f,d,h):(s(u),t[f]=i-1,r[d]=i-1);}return n.filter((e=>e.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((e,t)=>e.sortKey-t.sortKey));}update(e,t,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(e,t,this.layers,{imagePositions:r}),this.icon.programConfigurations.updatePaintArrays(e,t,this.layers,{imagePositions:r}));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(e){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(e),this.iconCollisionBox.upload(e)),this.text.upload(e,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(e,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(e,t){const r=this.lineVertexArray.length;if(void 0!==e.segment){let r=e.dist(t[e.segment+1]),n=e.dist(t[e.segment]);const i={};for(let n=e.segment+1;n<t.length;n++)i[n]={x:t[n].x,y:t[n].y,tileUnitDistanceFromAnchor:r},n<t.length-1&&(r+=t[n+1].dist(t[n]));for(let r=e.segment||0;r>=0;r--)i[r]={x:t[r].x,y:t[r].y,tileUnitDistanceFromAnchor:n},r>0&&(n+=t[r-1].dist(t[r]));for(let e=0;e<t.length;e++){const t=i[e];this.lineVertexArray.emplaceBack(t.x,t.y,t.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,r,n,i,s,o,a,l,u,c,h,p){const f=t.indexArray,d=t.layoutVertexArray,y=t.segments.prepareSegment(4*r.length,d,f,this.canOverlap?o.sortKey:void 0),m=this.glyphOffsetArray.length,g=y.vertexLength,x=this.allowVerticalPlacement&&a===e.ay.vertical?Math.PI/2:0,v=o.text&&o.text.sections;for(let e=0;e<r.length;e++){const{tl:i,tr:s,bl:a,br:u,tex:c,pixelOffsetTL:h,pixelOffsetBR:m,minFontScaleX:g,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:S}=r[e],A=y.vertexLength,T=w[1];rh(d,l.x,l.y,i.x,T+i.y,c.x,c.y,n,_,h.x,h.y,g,b),rh(d,l.x,l.y,s.x,T+s.y,c.x+c.w,c.y,n,_,m.x,h.y,g,b),rh(d,l.x,l.y,a.x,T+a.y,c.x,c.y+c.h,n,_,h.x,m.y,g,b),rh(d,l.x,l.y,u.x,T+u.y,c.x+c.w,c.y+c.h,n,_,m.x,m.y,g,b),nh(t.dynamicLayoutVertexArray,l,x),f.emplaceBack(A,A+2,A+1),f.emplaceBack(A+1,A+2,A+3),y.vertexLength+=4,y.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),e!==r.length-1&&S===r[e+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,o,o.index,{imagePositions:{},canonical:p,formattedSection:v&&v[S]});}t.placedSymbolArray.emplaceBack(l.x,l.y,m,this.glyphOffsetArray.length-m,g,u,c,l.segment,n?n[0]:0,n?n[1]:0,i[0],i[1],a,0,!1,0,h);}_addCollisionDebugVertex(e,t,r,n,i,s){return t.emplaceBack(0,0),e.emplaceBack(r.x,r.y,n,i,Math.round(s.x),Math.round(s.y))}addCollisionDebugVertices(e,t,n,i,s,o,a){const l=s.segments.prepareSegment(4,s.layoutVertexArray,s.indexArray),u=l.vertexLength,c=s.layoutVertexArray,h=s.collisionVertexArray,p=a.anchorX,f=a.anchorY;this._addCollisionDebugVertex(c,h,o,p,f,new r(e,t)),this._addCollisionDebugVertex(c,h,o,p,f,new r(n,t)),this._addCollisionDebugVertex(c,h,o,p,f,new r(n,i)),this._addCollisionDebugVertex(c,h,o,p,f,new r(e,i)),l.vertexLength+=4;const d=s.indexArray;d.emplaceBack(u,u+1),d.emplaceBack(u+1,u+2),d.emplaceBack(u+2,u+3),d.emplaceBack(u+3,u),l.primitiveLength+=4;}addDebugCollisionBoxes(e,t,r,n){for(let i=e;i<t;i++){const e=this.collisionBoxArray.get(i);this.addCollisionDebugVertices(e.x1,e.y1,e.x2,e.y2,n?this.textCollisionBox:this.iconCollisionBox,e.anchorPoint,r);}}generateCollisionDebugBuffers(){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new oh(Ho,sc.members,Jo),this.iconCollisionBox=new oh(Ho,sc.members,Jo);for(let e=0;e<this.symbolInstances.length;e++){const t=this.symbolInstances.get(e);this.addDebugCollisionBoxes(t.textBoxStartIndex,t.textBoxEndIndex,t,!0),this.addDebugCollisionBoxes(t.verticalTextBoxStartIndex,t.verticalTextBoxEndIndex,t,!0),this.addDebugCollisionBoxes(t.iconBoxStartIndex,t.iconBoxEndIndex,t,!1),this.addDebugCollisionBoxes(t.verticalIconBoxStartIndex,t.verticalIconBoxEndIndex,t,!1);}}_deserializeCollisionBoxesForSymbol(e,t,r,n,i,s,o,a,l){const u={};for(let n=t;n<r;n++){const t=e.get(n);u.textBox={x1:t.x1,y1:t.y1,x2:t.x2,y2:t.y2,anchorPointX:t.anchorPointX,anchorPointY:t.anchorPointY},u.textFeatureIndex=t.featureIndex;break}for(let t=n;t<i;t++){const r=e.get(t);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let t=s;t<o;t++){const r=e.get(t);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let t=a;t<l;t++){const r=e.get(t);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(e){this.collisionArrays=[];for(let t=0;t<this.symbolInstances.length;t++){const r=this.symbolInstances.get(t);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(e,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(e,t){const r=e.placedSymbolArray.get(t),n=r.vertexStartIndex+4*r.numGlyphs;for(let t=r.vertexStartIndex;t<n;t+=4)e.indexArray.emplaceBack(t,t+2,t+1),e.indexArray.emplaceBack(t+1,t+2,t+3);}getSortedSymbolIndexes(e){if(this.sortedAngle===e&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const t=Math.sin(e),r=Math.cos(e),n=[],i=[],s=[];for(let e=0;e<this.symbolInstances.length;++e){s.push(e);const o=this.symbolInstances.get(e);n.push(0|Math.round(t*o.anchorX+r*o.anchorY)),i.push(o.featureIndex);}return s.sort(((e,t)=>n[e]-n[t]||i[t]-i[e])),s}addToSortKeyRanges(e,t){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===t?r.symbolInstanceEnd=e+1:this.sortKeyRanges.push({sortKey:t,symbolInstanceStart:e,symbolInstanceEnd:e+1});}sortFeatures(e){if(this.sortFeaturesByY&&this.sortedAngle!==e&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(e),this.sortedAngle=e,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const e of this.symbolInstanceIndexes){const t=this.symbolInstances.get(e);this.featureSortOrder.push(t.featureIndex),[t.rightJustifiedTextSymbolIndex,t.centerJustifiedTextSymbolIndex,t.leftJustifiedTextSymbolIndex].forEach(((e,t,r)=>{e>=0&&r.indexOf(e)===t&&this.addIndicesForPlacedSymbol(this.text,e);})),t.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,t.verticalPlacedTextSymbolIndex),t.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,t.placedIconSymbolIndex),t.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,t.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}let lh,uh;ls("SymbolBucket",ah,{omit:["layers","collisionBoxArray","features","compareText"]}),ah.MAX_GLYPHS=65535,ah.addDynamicAttributes=nh;var ch={get paint(){return uh=uh||new Gs({"icon-opacity":new $s(xe.paint_symbol["icon-opacity"]),"icon-color":new $s(xe.paint_symbol["icon-color"]),"icon-halo-color":new $s(xe.paint_symbol["icon-halo-color"]),"icon-halo-width":new $s(xe.paint_symbol["icon-halo-width"]),"icon-halo-blur":new $s(xe.paint_symbol["icon-halo-blur"]),"icon-translate":new Ns(xe.paint_symbol["icon-translate"]),"icon-translate-anchor":new Ns(xe.paint_symbol["icon-translate-anchor"]),"text-opacity":new $s(xe.paint_symbol["text-opacity"]),"text-color":new $s(xe.paint_symbol["text-color"],{runtimeType:Oe,getOverride:e=>e.textColor,hasOverride:e=>!!e.textColor}),"text-halo-color":new $s(xe.paint_symbol["text-halo-color"]),"text-halo-width":new $s(xe.paint_symbol["text-halo-width"]),"text-halo-blur":new $s(xe.paint_symbol["text-halo-blur"]),"text-translate":new Ns(xe.paint_symbol["text-translate"]),"text-translate-anchor":new Ns(xe.paint_symbol["text-translate-anchor"])})},get layout(){return lh=lh||new Gs({"symbol-placement":new Ns(xe.layout_symbol["symbol-placement"]),"symbol-spacing":new Ns(xe.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Ns(xe.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new $s(xe.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Ns(xe.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Ns(xe.layout_symbol["icon-allow-overlap"]),"icon-overlap":new Ns(xe.layout_symbol["icon-overlap"]),"icon-ignore-placement":new Ns(xe.layout_symbol["icon-ignore-placement"]),"icon-optional":new Ns(xe.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Ns(xe.layout_symbol["icon-rotation-alignment"]),"icon-size":new $s(xe.layout_symbol["icon-size"]),"icon-text-fit":new Ns(xe.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Ns(xe.layout_symbol["icon-text-fit-padding"]),"icon-image":new $s(xe.layout_symbol["icon-image"]),"icon-rotate":new $s(xe.layout_symbol["icon-rotate"]),"icon-padding":new $s(xe.layout_symbol["icon-padding"]),"icon-keep-upright":new Ns(xe.layout_symbol["icon-keep-upright"]),"icon-offset":new $s(xe.layout_symbol["icon-offset"]),"icon-anchor":new $s(xe.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Ns(xe.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Ns(xe.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Ns(xe.layout_symbol["text-rotation-alignment"]),"text-field":new $s(xe.layout_symbol["text-field"]),"text-font":new $s(xe.layout_symbol["text-font"]),"text-size":new $s(xe.layout_symbol["text-size"]),"text-max-width":new $s(xe.layout_symbol["text-max-width"]),"text-line-height":new Ns(xe.layout_symbol["text-line-height"]),"text-letter-spacing":new $s(xe.layout_symbol["text-letter-spacing"]),"text-justify":new $s(xe.layout_symbol["text-justify"]),"text-radial-offset":new $s(xe.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Ns(xe.layout_symbol["text-variable-anchor"]),"text-variable-anchor-offset":new $s(xe.layout_symbol["text-variable-anchor-offset"]),"text-anchor":new $s(xe.layout_symbol["text-anchor"]),"text-max-angle":new Ns(xe.layout_symbol["text-max-angle"]),"text-writing-mode":new Ns(xe.layout_symbol["text-writing-mode"]),"text-rotate":new $s(xe.layout_symbol["text-rotate"]),"text-padding":new Ns(xe.layout_symbol["text-padding"]),"text-keep-upright":new Ns(xe.layout_symbol["text-keep-upright"]),"text-transform":new $s(xe.layout_symbol["text-transform"]),"text-offset":new $s(xe.layout_symbol["text-offset"]),"text-allow-overlap":new Ns(xe.layout_symbol["text-allow-overlap"]),"text-overlap":new Ns(xe.layout_symbol["text-overlap"]),"text-ignore-placement":new Ns(xe.layout_symbol["text-ignore-placement"]),"text-optional":new Ns(xe.layout_symbol["text-optional"])})}};class hh{constructor(e){if(void 0===e.property.overrides)throw new Error("overrides must be provided to instantiate FormatSectionOverride class");this.type=e.property.overrides?e.property.overrides.runtimeType:ze,this.defaultValue=e;}evaluate(e){if(e.formattedSection){const t=this.defaultValue.property.overrides;if(t&&t.hasOverride(e.formattedSection))return t.getOverride(e.formattedSection)}return e.feature&&e.featureState?this.defaultValue.evaluate(e.feature,e.featureState):this.defaultValue.property.specification.default}eachChild(e){this.defaultValue.isConstant()||e(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}ls("FormatSectionOverride",hh,{omit:["defaultValue"]});class ph extends Xs{constructor(e,t){super(e,ch,t);}recalculate(e,t){if(super.recalculate(e,t),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]="map"===this.layout.get("text-rotation-alignment")?"map":"viewport"),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const e=this.layout.get("text-writing-mode");if(e){const t=[];for(const r of e)t.indexOf(r)<0&&t.push(r);this.layout._values["text-writing-mode"]=t;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(e,t,r,n){const i=this.layout.get(e).evaluate(t,{},r,n),s=this._unevaluatedLayout._values[e];return s.isDataDriven()||ti(s.value)||!i?i:function(e,t){return t.replace(/{([^{}]+)}/g,((t,r)=>e&&r in e?String(e[r]):""))}(t.properties,i)}createBucket(e){return new ah(e)}queryRadius(){return 0}queryIntersectsFeature(){throw new Error("Should take a different path in FeatureIndex")}_setPaintOverrides(){for(const e of ch.paint.overridableProperties){if(!ph.hasPaintOverride(this.layout,e))continue;const t=this.paint.get(e),r=new hh(t),n=new ei(r,t.property.specification);let i=null;i="constant"===t.value.kind||"source"===t.value.kind?new ni("source",n):new ii("composite",n,t.value.zoomStops),this.paint._values[e]=new Os(t.property,i,t.parameters);}}_handleOverridablePaintPropertyUpdate(e,t,r){return !(!this.layout||t.isDataDriven()||r.isDataDriven())&&ph.hasPaintOverride(this.layout,e)}static hasPaintOverride(e,t){const r=e.get("text-field"),n=ch.paint.properties[t];let i=!1;const s=e=>{for(const t of e)if(n.overrides&&n.overrides.hasOverride(t))return void(i=!0)};if("constant"===r.value.kind&&r.value.value instanceof Ft)s(r.value.value.sections);else if("source"===r.value.kind||"composite"===r.value.kind){const e=t=>{i||(t instanceof qt&&$t(t.value)===qe?s(t.value.sections):t instanceof Er?s(t.sections):t.eachChild(e));},t=r.value;t._styleExpression&&e(t._styleExpression.expression);}return i}}let fh;var dh={get paint(){return fh=fh||new Gs({"background-color":new Ns(xe.paint_background["background-color"]),"background-pattern":new qs(xe.paint_background["background-pattern"]),"background-opacity":new Ns(xe.paint_background["background-opacity"])})}};class yh extends Xs{constructor(e,t){super(e,dh,t);}}class mh extends Xs{constructor(e,t){super(e,{},t),this.onAdd=e=>{this.implementation.onAdd&&this.implementation.onAdd(e,e.painter.context.gl);},this.onRemove=e=>{this.implementation.onRemove&&this.implementation.onRemove(e,e.painter.context.gl);},this.implementation=e;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){return !1}serialize(){throw new Error("Custom layers cannot be serialized")}}class gh{constructor(e){this._methodToThrottle=e,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._methodToThrottle();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._methodToThrottle();}),0));}remove(){delete this._channel,this._methodToThrottle=()=>{};}}const xh={once:!0},vh=6371008.8;class bh{constructor(e,t){if(isNaN(e)||isNaN(t))throw new Error(`Invalid LngLat object: (${e}, ${t})`);if(this.lng=+e,this.lat=+t,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new bh(L(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(e){const t=Math.PI/180,r=this.lat*t,n=e.lat*t,i=Math.sin(r)*Math.sin(n)+Math.cos(r)*Math.cos(n)*Math.cos((e.lng-this.lng)*t);return vh*Math.acos(Math.min(i,1))}static convert(e){if(e instanceof bh)return e;if(Array.isArray(e)&&(2===e.length||3===e.length))return new bh(Number(e[0]),Number(e[1]));if(!Array.isArray(e)&&"object"==typeof e&&null!==e)return new bh(Number("lng"in e?e.lng:e.lon),Number(e.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const wh=2*Math.PI*vh;function _h(e){return wh*Math.cos(e*Math.PI/180)}function Sh(e){return (180+e)/360}function Ah(e){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e*Math.PI/360)))/360}function Th(e,t){return e/_h(t)}function Ih(e){return 360*e-180}function Eh(e){return 360/Math.PI*Math.atan(Math.exp((180-360*e)*Math.PI/180))-90}function Mh(e,t){return e*_h(Eh(t))}class kh{constructor(e,t,r=0){this.x=+e,this.y=+t,this.z=+r;}static fromLngLat(e,t=0){const r=bh.convert(e);return new kh(Sh(r.lng),Ah(r.lat),Th(t,r.lat))}toLngLat(){return new bh(Ih(this.x),Eh(this.y))}toAltitude(){return Mh(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/wh*(e=Eh(this.y),1/Math.cos(e*Math.PI/180));var e;}}function Fh(e,t,r){var n=2*Math.PI*6378137/256/Math.pow(2,r);return [e*n-2*Math.PI*6378137/2,t*n-2*Math.PI*6378137/2]}class Dh{constructor(e,t,r){if(!function(e,t,r){return !(e<0||e>25||r<0||r>=Math.pow(2,e)||t<0||t>=Math.pow(2,e))}(e,t,r))throw new Error(`x=${t}, y=${r}, z=${e} outside of bounds. 0<=x<${Math.pow(2,e)}, 0<=y<${Math.pow(2,e)} 0<=z<=25 `);this.z=e,this.x=t,this.y=r,this.key=zh(0,e,e,t,r);}equals(e){return this.z===e.z&&this.x===e.x&&this.y===e.y}url(e,t,r){const n=(s=this.y,o=this.z,a=Fh(256*(i=this.x),256*(s=Math.pow(2,o)-s-1),o),l=Fh(256*(i+1),256*(s+1),o),a[0]+","+a[1]+","+l[0]+","+l[1]);var i,s,o,a,l;const u=function(e,t,r){let n,i="";for(let s=e;s>0;s--)n=1<<s-1,i+=(t&n?1:0)+(r&n?2:0);return i}(this.z,this.x,this.y);return e[(this.x+this.y)%e.length].replace(/{prefix}/g,(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===r?Math.pow(2,this.z)-this.y-1:this.y)).replace(/{ratio}/g,t>1?"@2x":"").replace(/{quadkey}/g,u).replace(/{bbox-epsg-3857}/g,n)}isChildOf(e){const t=this.z-e.z;return t>0&&e.x===this.x>>t&&e.y===this.y>>t}getTilePoint(e){const t=Math.pow(2,this.z);return new r((e.x*t-this.x)*k,(e.y*t-this.y)*k)}toString(){return `${this.z}/${this.x}/${this.y}`}}class Ph{constructor(e,t){this.wrap=e,this.canonical=t,this.key=zh(e,t.z,t.z,t.x,t.y);}}class Bh{constructor(e,t,r,n,i){if(this.terrainRttPosMatrix32f=null,e<r)throw new Error(`overscaledZ should be >= z; overscaledZ = ${e}; z = ${r}`);this.overscaledZ=e,this.wrap=t,this.canonical=new Dh(r,+n,+i),this.key=zh(t,e,r,n,i);}clone(){return new Bh(this.overscaledZ,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)}equals(e){return this.overscaledZ===e.overscaledZ&&this.wrap===e.wrap&&this.canonical.equals(e.canonical)}scaledTo(e){if(e>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${e}; overscaledZ = ${this.overscaledZ}`);const t=this.canonical.z-e;return e>this.canonical.z?new Bh(e,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new Bh(e,this.wrap,e,this.canonical.x>>t,this.canonical.y>>t)}isOverscaled(){return this.overscaledZ>this.canonical.z}calculateScaledKey(e,t){if(e>this.overscaledZ)throw new Error(`targetZ > this.overscaledZ; targetZ = ${e}; overscaledZ = ${this.overscaledZ}`);const r=this.canonical.z-e;return e>this.canonical.z?zh(this.wrap*+t,e,this.canonical.z,this.canonical.x,this.canonical.y):zh(this.wrap*+t,e,e,this.canonical.x>>r,this.canonical.y>>r)}isChildOf(e){if(e.wrap!==this.wrap)return !1;if(this.overscaledZ-e.overscaledZ<=0)return !1;if(0===e.overscaledZ)return this.overscaledZ>0;const t=this.canonical.z-e.canonical.z;return !(t<0)&&e.canonical.x===this.canonical.x>>t&&e.canonical.y===this.canonical.y>>t}children(e){if(this.overscaledZ>=e)return [new Bh(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const t=this.canonical.z+1,r=2*this.canonical.x,n=2*this.canonical.y;return [new Bh(t,this.wrap,t,r,n),new Bh(t,this.wrap,t,r+1,n),new Bh(t,this.wrap,t,r,n+1),new Bh(t,this.wrap,t,r+1,n+1)]}isLessThan(e){return this.wrap<e.wrap||!(this.wrap>e.wrap)&&(this.overscaledZ<e.overscaledZ||!(this.overscaledZ>e.overscaledZ)&&(this.canonical.x<e.canonical.x||!(this.canonical.x>e.canonical.x)&&this.canonical.y<e.canonical.y))}wrapped(){return new Bh(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(e){return new Bh(this.overscaledZ,e,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new Ph(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(e){return this.canonical.getTilePoint(new kh(e.x-this.wrap,e.y))}}function zh(e,t,r,n,i){(e*=2)<0&&(e=-1*e-1);const s=1<<r;return (s*s*e+s*i+n).toString(36)+r.toString(36)+t.toString(36)}function Vh(e,t){return t?e.properties[t]:e.id}function Ch(e,t){const r={id:e.id};if(t.removeAllProperties&&(delete e.removeProperties,delete e.addOrUpdateProperties,delete t.removeProperties),t.removeProperties)for(const r of t.removeProperties){const t=e.addOrUpdateProperties.findIndex((e=>e.key===r));t>-1&&e.addOrUpdateProperties.splice(t,1);}return (e.removeAllProperties||t.removeAllProperties)&&(r.removeAllProperties=!0),(e.removeProperties||t.removeProperties)&&(r.removeProperties=[...e.removeProperties||[],...t.removeProperties||[]]),(e.addOrUpdateProperties||t.addOrUpdateProperties)&&(r.addOrUpdateProperties=[...e.addOrUpdateProperties||[],...t.addOrUpdateProperties||[]]),(e.newGeometry||t.newGeometry)&&(r.newGeometry=t.newGeometry||e.newGeometry),r}function Lh(e){var t,r;if(!e)return {};const n={};return n.removeAll=e.removeAll,n.remove=new Set(e.remove||[]),n.add=new Map(null===(t=e.add)||void 0===t?void 0:t.map((e=>[e.id,e]))),n.update=new Map(null===(r=e.update)||void 0===r?void 0:r.map((e=>[e.id,e]))),n}ls("CanonicalTileID",Dh),ls("OverscaledTileID",Bh,{omit:["terrainRttPosMatrix32f"]});class Oh{constructor(e){this._stringToNumber={},this._numberToString=[];for(let t=0;t<e.length;t++){const r=e[t];this._stringToNumber[r]=t,this._numberToString[t]=r;}}encode(e){return this._stringToNumber[e]}decode(e){if(e>=this._numberToString.length)throw new Error(`Out of bounds. Index requested n=${e} can't be >= this._numberToString.length ${this._numberToString.length}`);return this._numberToString[e]}}class Rh{constructor(e,t,r,n,i){this.type="Feature",this._vectorTileFeature=e,e._z=t,e._x=r,e._y=n,this.properties=e.properties,this.id=i;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(e){this._geometry=e;}toJSON(){const e={geometry:this.geometry};for(const t in this)"_geometry"!==t&&"_vectorTileFeature"!==t&&(e[t]=this[t]);return e}}class Nh{_name;dataBuffer;nullabilityBuffer;_size;constructor(e,t,r){this._name=e,this.dataBuffer=t,"number"==typeof r?this._size=r:(this.nullabilityBuffer=r,this._size=r.size());}getValue(e){return this.nullabilityBuffer&&!this.nullabilityBuffer.get(e)?null:this.getValueFromBuffer(e)}has(e){return this.nullabilityBuffer&&this.nullabilityBuffer.get(e)||!this.nullabilityBuffer}get name(){return this._name}get size(){return this._size}}class $h extends Nh{}class Uh extends $h{getValueFromBuffer(e){return this.dataBuffer[e]}}class qh extends $h{getValueFromBuffer(e){return this.dataBuffer[e]}}class jh extends Nh{delta;constructor(e,t,r,n){super(e,t,n),this.delta=r;}}class Gh extends jh{constructor(e,t,r,n){super(e,Int32Array.of(t),r,n);}getValueFromBuffer(e){return this.dataBuffer[0]+e*this.delta}}class Xh extends Nh{constructor(e,t,r){super(e,Int32Array.of(t),r);}getValueFromBuffer(e){return this.dataBuffer[0]}}class Yh{_name;_geometryVector;_idVector;_propertyVectors;_extent;propertyVectorsMap;constructor(e,t,r,n,i=4096){this._name=e,this._geometryVector=t,this._idVector=r,this._propertyVectors=n,this._extent=i;}get name(){return this._name}get idVector(){return this._idVector}get geometryVector(){return this._geometryVector}get propertyVectors(){return this._propertyVectors}getPropertyVector(e){return this.propertyVectorsMap||(this.propertyVectorsMap=new Map(this._propertyVectors.map((e=>[e.name,e])))),this.propertyVectorsMap.get(e)}*[Symbol.iterator](){const e=this.geometryVector[Symbol.iterator]();let t=0;for(;t<this.numFeatures;){let r;this.idVector&&(r=this.containsMaxSaveIntegerValues(this.idVector)?Number(this.idVector.getValue(t)):this.idVector.getValue(t));const n=e?.next().value,i={};for(const e of this.propertyVectors){if(!e)continue;const r=e.name,n=e.getValue(t);null!==n&&(i[r]=n);}t++,yield {id:r,geometry:n,properties:i};}}get numFeatures(){return this.geometryVector.numGeometries}get extent(){return this._extent}getFeatures(){const e=[],t=this.geometryVector.getGeometries();for(let r=0;r<this.numFeatures;r++){let n;this.idVector&&(n=this.containsMaxSaveIntegerValues(this.idVector)?Number(this.idVector.getValue(r)):this.idVector.getValue(r));const i={coordinates:t[r],type:this.geometryVector.geometryType(r)},s={};for(const e of this.propertyVectors){if(!e)continue;const t=e.name,n=e.getValue(r);null!==n&&(s[t]=n);}e.push({id:n,geometry:i,properties:s});}return e}containsMaxSaveIntegerValues(e){return e instanceof Uh||e instanceof Xh&&e instanceof Gh||e instanceof qh}}class Zh{value;constructor(e){this.value=e;}get(){return this.value}set(e){this.value=e;}increment(){return this.value++}add(e){this.value+=e;}}var Hh,Kh,Wh,Jh,Qh,ep,tp,rp,np,ip;!function(e){e.PRESENT="PRESENT",e.DATA="DATA",e.OFFSET="OFFSET",e.LENGTH="LENGTH";}(Hh||(Hh={}));class sp{_dictionaryType;_offsetType;_lengthType;constructor(e,t,r){this._dictionaryType=e,this._offsetType=t,this._lengthType=r;}get dictionaryType(){return this._dictionaryType}get offsetType(){return this._offsetType}get lengthType(){return this._lengthType}}function op(e,t,r){const n=new Int32Array(r);let i=0,s=t.get();for(let t=0;t<n.length;t++){let t=e[s++],r=127&t;t<128||(t=e[s++],r|=(127&t)<<7,t<128||(t=e[s++],r|=(127&t)<<14,t<128||(t=e[s++],r|=(127&t)<<21,t<128||(t=e[s++],r|=(15&t)<<28)))),n[i++]=r;}return t.set(s),n}function ap(e,t,r){const n=new BigInt64Array(r);for(let r=0;r<n.length;r++)n[r]=pp(e,t);return n}function lp(e,t){let r,n;return n=e[t.get()],t.increment(),r=127&n,n<128?r:(n=e[t.get()],t.increment(),r|=(127&n)<<7,n<128?r:(n=e[t.get()],t.increment(),r|=(127&n)<<14,n<128?r:(n=e[t.get()],t.increment(),r|=(127&n)<<21,n<128?r:(n=e[t.get()],r|=(15&n)<<28,function(e,t,r){let n,i;if(i=t[r.get()],r.increment(),n=(112&i)>>4,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(127&i)<<3,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(127&i)<<10,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(127&i)<<17,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(127&i)<<24,i<128)return 4294967296*n+(e>>>0);if(i=t[r.get()],r.increment(),n|=(1&i)<<31,i<128)return 4294967296*n+(e>>>0);throw new Error("Expected varint not more than 10 bytes")}(r,e,t)))))}function up(e,t,r,n){throw new Error("FastPFor is not implemented yet.")}function cp(e){return e>>>1^-(1&e)}function hp(e){return e>>1n^-(1n&e)}function pp(e,t){let r=0n,n=0,i=t.get();for(;i<e.length;){const t=e[i++];if(r|=BigInt(127&t)<<BigInt(n),!(128&t))break;if(n+=7,n>=64)throw new Error("Varint too long")}return t.set(i),r}function fp(e,t,r){const n=new Int32Array(r);let i=0;for(let r=0;r<t;r++){const s=e[r];n.fill(e[r+t],i,i+s),i+=s;}return n}function dp(e,t,r){const n=new BigInt64Array(r);let i=0;for(let r=0;r<t;r++){const s=Number(e[r]);n.fill(e[r+t],i,i+s),i+=s;}return n}function yp(e,t,r){const n=new Float64Array(r);let i=0;for(let r=0;r<t;r++){const s=e[r];n.fill(e[r+t],i,i+s),i+=s;}return n}function mp(e){const t=e.length/4*4;let r=1;if(t>=4)for(let n=e[0];r<t-4;r+=4)n=e[r]+=n,n=e[r+1]+=n,n=e[r+2]+=n,n=e[r+3]+=n;for(;r!=e.length;)e[r]+=e[r-1],++r;}function gp(e){e[0]=e[0]>>>1^-(1&e[0]),e[1]=e[1]>>>1^-(1&e[1]);const t=e.length/4*4;let r=2;if(t>=4)for(;r<t-4;r+=4){const t=e[r],n=e[r+1],i=e[r+2],s=e[r+3];e[r]=(t>>>1^-(1&t))+e[r-2],e[r+1]=(n>>>1^-(1&n))+e[r-1],e[r+2]=(i>>>1^-(1&i))+e[r],e[r+3]=(s>>>1^-(1&s))+e[r+1];}for(;r!=e.length;r+=2)e[r]=(e[r]>>>1^-(1&e[r]))+e[r-2],e[r+1]=(e[r+1]>>>1^-(1&e[r+1]))+e[r-1];}function xp(e,t,r){return Math.min(r,Math.max(t,e))}!function(e){e.NONE="NONE",e.DELTA="DELTA",e.COMPONENTWISE_DELTA="COMPONENTWISE_DELTA",e.RLE="RLE",e.MORTON="MORTON",e.PDE="PDE";}(Kh||(Kh={})),function(e){e.NONE="NONE",e.FAST_PFOR="FAST_PFOR",e.VARINT="VARINT",e.ALP="ALP";}(Wh||(Wh={})),function(e){e.NONE="NONE",e.SINGLE="SINGLE",e.SHARED="SHARED",e.VERTEX="VERTEX",e.MORTON="MORTON",e.FSST="FSST";}(Jh||(Jh={})),function(e){e.VERTEX="VERTEX",e.INDEX="INDEX",e.STRING="STRING",e.KEY="KEY";}(Qh||(Qh={})),function(e){e.VAR_BINARY="VAR_BINARY",e.GEOMETRIES="GEOMETRIES",e.PARTS="PARTS",e.RINGS="RINGS",e.TRIANGLES="TRIANGLES",e.SYMBOL="SYMBOL",e.DICTIONARY="DICTIONARY";}(ep||(ep={}));class vp{_physicalStreamType;_logicalStreamType;_logicalLevelTechnique1;_logicalLevelTechnique2;_physicalLevelTechnique;_numValues;_byteLength;constructor(e,t,r,n,i,s,o){this._physicalStreamType=e,this._logicalStreamType=t,this._logicalLevelTechnique1=r,this._logicalLevelTechnique2=n,this._physicalLevelTechnique=i,this._numValues=s,this._byteLength=o;}static decode(e,t){const r=e[t.get()],n=Object.values(Hh)[r>>4];let i=null;switch(n){case Hh.DATA:i=new sp(Object.values(Jh)[15&r]);break;case Hh.OFFSET:i=new sp(null,Object.values(Qh)[15&r]);break;case Hh.LENGTH:i=new sp(null,null,Object.values(ep)[15&r]);}t.increment();const s=e[t.get()],o=Object.values(Kh)[s>>5],a=Object.values(Kh)[s>>2&7],l=Object.values(Wh)[3&s];t.increment();const u=op(e,t,2);return new vp(n,i,o,a,l,u[0],u[1])}get physicalStreamType(){return this._physicalStreamType}get logicalStreamType(){return this._logicalStreamType}get logicalLevelTechnique1(){return this._logicalLevelTechnique1}get logicalLevelTechnique2(){return this._logicalLevelTechnique2}get physicalLevelTechnique(){return this._physicalLevelTechnique}get numValues(){return this._numValues}get byteLength(){return this._byteLength}getDecompressedCount(){return this._numValues}}class bp extends vp{num_bits;coordinate_shift;constructor(e,t,r,n,i,s,o,a,l){super(e,t,r,n,i,s,o),this.num_bits=a,this.coordinate_shift=l;}static decode(e,t){const r=vp.decode(e,t),n=op(e,t,2);return new bp(r.physicalStreamType,r.logicalStreamType,r.logicalLevelTechnique1,r.logicalLevelTechnique2,r.physicalLevelTechnique,r.numValues,r.byteLength,n[0],n[1])}static decodePartial(e,t,r){const n=op(t,r,2);return new bp(e.physicalStreamType,e.logicalStreamType,e.logicalLevelTechnique1,e.logicalLevelTechnique2,e.physicalLevelTechnique,e.numValues,e.byteLength,n[0],n[1])}numBits(){return this.num_bits}coordinateShift(){return this.coordinate_shift}}class wp extends vp{_runs;_numRleValues;constructor(e,t,r,n,i,s,o,a,l){super(e,t,r,n,i,s,o),this._runs=a,this._numRleValues=l;}static decode(e,t){const r=vp.decode(e,t),n=op(e,t,2);return new wp(r.physicalStreamType,r.logicalStreamType,r.logicalLevelTechnique1,r.logicalLevelTechnique2,r.physicalLevelTechnique,r.numValues,r.byteLength,n[0],n[1])}static decodePartial(e,t,r){const n=op(t,r,2);return new wp(e.physicalStreamType,e.logicalStreamType,e.logicalLevelTechnique1,e.logicalLevelTechnique2,e.physicalLevelTechnique,e.numValues,e.byteLength,n[0],n[1])}get runs(){return this._runs}get numRleValues(){return this._numRleValues}getDecompressedCount(){return this._numRleValues}}class _p{static decode(e,t){const r=vp.decode(e,t);return r.logicalLevelTechnique1===Kh.MORTON?bp.decodePartial(r,e,t):Kh.RLE!==r.logicalLevelTechnique1&&Kh.RLE!==r.logicalLevelTechnique2||Wh.NONE===r.physicalLevelTechnique?r:wp.decodePartial(r,e,t)}}!function(e){e[e.FLAT=0]="FLAT",e[e.CONST=1]="CONST",e[e.SEQUENCE=2]="SEQUENCE",e[e.DICTIONARY=3]="DICTIONARY",e[e.FSST_DICTIONARY=4]="FSST_DICTIONARY";}(tp||(tp={}));class Sp{values;_size;constructor(e,t){this.values=e,this._size=t;}get(e){const t=Math.floor(e/8);return 1==(this.values[t]>>e%8&1)}set(e,t){const r=Math.floor(e/8);this.values[r]=this.values[r]|(t?1:0)<<e%8;}getInt(e){const t=Math.floor(e/8);return this.values[t]>>e%8&1}size(){return this._size}getBuffer(){return this.values}}class Ap{constructor(){}static decodeIntStream(e,t,r,n,i){const s=Ap.decodePhysicalLevelTechnique(e,t,r);return this.decodeIntBuffer(s,r,n,i)}static decodeLengthStreamToOffsetBuffer(e,t,r){const n=Ap.decodePhysicalLevelTechnique(e,t,r);return this.decodeLengthToOffsetBuffer(n,r)}static decodePhysicalLevelTechnique(e,t,r){const n=r.physicalLevelTechnique;if(n===Wh.FAST_PFOR)return up();if(n===Wh.VARINT)return op(e,t,r.numValues);if(n===Wh.NONE){const n=t.get();t.add(r.byteLength);const i=e.subarray(n,t.get());return new Int32Array(i)}throw new Error("Specified physicalLevelTechnique is not supported (yet).")}static decodeConstIntStream(e,t,r,n){const i=Ap.decodePhysicalLevelTechnique(e,t,r);if(1===i.length){const e=i[0];return n?cp(e):e}return n?function(e){return cp(e[1])}(i):function(e){return e[1]}(i)}static decodeSequenceIntStream(e,t,r){return function(e){if(2==e.length){const t=cp(e[1]);return [t,t]}return [cp(e[2]),cp(e[3])]}(Ap.decodePhysicalLevelTechnique(e,t,r))}static decodeSequenceLongStream(e,t,r){return function(e){if(2==e.length){const t=hp(e[1]);return [t,t]}return [hp(e[2]),hp(e[3])]}(ap(e,t,r.numValues))}static decodeLongStream(e,t,r,n){const i=ap(e,t,r.numValues);return this.decodeLongBuffer(i,r,n)}static decodeLongFloat64Stream(e,t,r,n){const i=function(e,t,r){const n=new Float64Array(t);for(let i=0;i<t;i++)n[i]=lp(e,r);return n}(e,r.numValues,t);return this.decodeFloat64Buffer(i,r,n)}static decodeConstLongStream(e,t,r,n){const i=ap(e,t,r.numValues);if(1===i.length){const e=i[0];return n?hp(e):e}return n?function(e){return hp(e[1])}(i):function(e){return e[1]}(i)}static decodeIntBuffer(e,t,r,n){switch(t.logicalLevelTechnique1){case Kh.DELTA:return t.logicalLevelTechnique2===Kh.RLE?function(e,t,r){const n=new Int32Array(r);let i=0,s=0;for(let r=0;r<t;r++){const o=e[r],a=cp(e[r+t]);for(let e=0;e<o;e++)s+=a,n[i++]=s;}return n}(e,t.runs,t.numRleValues):(function(e){e[0]=e[0]>>>1^-(1&e[0]);const t=e.length/4*4;let r=1;if(t>=4)for(;r<t-4;r+=4){const t=e[r],n=e[r+1],i=e[r+2],s=e[r+3];e[r]=(t>>>1^-(1&t))+e[r-1],e[r+1]=(n>>>1^-(1&n))+e[r],e[r+2]=(i>>>1^-(1&i))+e[r+1],e[r+3]=(s>>>1^-(1&s))+e[r+2];}for(;r!=e.length;++r)e[r]=(e[r]>>>1^-(1&e[r]))+e[r-1];}(e),e);case Kh.RLE:return function(e,t,r){return r?function(e,t,r){const n=new Int32Array(r);let i=0;for(let r=0;r<t;r++){const s=e[r];let o=e[r+t];o=o>>>1^-(1&o),n.fill(o,i,i+s),i+=s;}return n}(e,t.runs,t.numRleValues):fp(e,t.runs,t.numRleValues)}(e,t,r);case Kh.MORTON:return mp(e),e;case Kh.COMPONENTWISE_DELTA:return n?(function(e,t,r,n){let i=e[0]>>>1^-(1&e[0]),s=e[1]>>>1^-(1&e[1]);e[0]=xp(Math.round(i*t),r,n),e[1]=xp(Math.round(s*t),r,n);const o=e.length/16;let a=2;if(o>=4)for(;a<o-4;a+=4){const o=e[a],l=e[a+1],u=(o>>>1^-(1&o))+i,c=(l>>>1^-(1&l))+s;e[a]=xp(Math.round(u*t),r,n),e[a+1]=xp(Math.round(c*t),r,n);const h=e[a+2],p=e[a+3];i=(h>>>1^-(1&h))+u,s=(p>>>1^-(1&p))+c,e[a+2]=xp(Math.round(i*t),r,n),e[a+3]=xp(Math.round(s*t),r,n);}for(;a!=e.length;a+=2)i+=e[a]>>>1^-(1&e[a]),s+=e[a+1]>>>1^-(1&e[a+1]),e[a]=xp(Math.round(i*t),r,n),e[a+1]=xp(Math.round(s*t),r,n);}(e,n.scale,n.min,n.max),e):(gp(e),e);case Kh.NONE:return r&&function(e){for(let t=0;t<e.length;t++){const r=e[t];e[t]=r>>>1^-(1&r);}}(e),e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}static decodeLongBuffer(e,t,r){switch(t.logicalLevelTechnique1){case Kh.DELTA:return t.logicalLevelTechnique2===Kh.RLE?function(e,t,r){const n=new BigInt64Array(r);let i=0,s=0n;for(let r=0;r<t;r++){const o=Number(e[r]),a=hp(e[r+t]);for(let e=0;e<o;e++)s+=a,n[i++]=s;}return n}(e,t.runs,t.numRleValues):(function(e){e[0]=e[0]>>1n^-(1n&e[0]);const t=e.length/4*4;let r=1;if(t>=4)for(;r<t-4;r+=4){const t=e[r],n=e[r+1],i=e[r+2],s=e[r+3];e[r]=(t>>1n^-(1n&t))+e[r-1],e[r+1]=(n>>1n^-(1n&n))+e[r],e[r+2]=(i>>1n^-(1n&i))+e[r+1],e[r+3]=(s>>1n^-(1n&s))+e[r+2];}for(;r!=e.length;++r)e[r]=(e[r]>>1n^-(1n&e[r]))+e[r-1];}(e),e);case Kh.RLE:return function(e,t,r){return r?function(e,t,r){const n=new BigInt64Array(r);let i=0;for(let r=0;r<t;r++){const s=Number(e[r]);let o=e[r+t];o=o>>1n^-(1n&o),n.fill(o,i,i+s),i+=s;}return n}(e,t.runs,t.numRleValues):dp(e,t.runs,t.numRleValues)}(e,t,r);case Kh.NONE:return r&&function(e){for(let t=0;t<e.length;t++){const r=e[t];e[t]=r>>1n^-(1n&r);}}(e),e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}static decodeFloat64Buffer(e,t,r){switch(t.logicalLevelTechnique1){case Kh.DELTA:return t.logicalLevelTechnique2===Kh.RLE&&(e=yp(e,t.runs,t.numRleValues)),function(e){e[0]=e[0]%2==1?(e[0]+1)/-2:e[0]/2;const t=e.length/4*4;let r=1;if(t>=4)for(;r<t-4;r+=4){const t=e[r],n=e[r+1],i=e[r+2],s=e[r+3];e[r]=(t%2==1?(t+1)/-2:t/2)+e[r-1],e[r+1]=(n%2==1?(n+1)/-2:n/2)+e[r],e[r+2]=(i%2==1?(i+1)/-2:i/2)+e[r+1],e[r+3]=(s%2==1?(s+1)/-2:s/2)+e[r+2];}for(;r!=e.length;++r)e[r]=(e[r]%2==1?(e[r]+1)/-2:e[r]/2)+e[r-1];}(e),e;case Kh.RLE:return function(e,t,r){return r?function(e,t,r){const n=new Float64Array(r);let i=0;for(let r=0;r<t;r++){const s=e[r];let o=e[r+t];o=o%2==1?(o+1)/-2:o/2,n.fill(o,i,i+s),i+=s;}return n}(e,t.runs,t.numRleValues):yp(e,t.runs,t.numRleValues)}(e,t,r);case Kh.NONE:return r&&function(e){for(let t=0;t<e.length;t++){const r=e[t];e[t]=r%2==1?(r+1)/-2:r/2;}}(e),e;default:throw new Error(`The specified Logical level technique is not supported: ${t.logicalLevelTechnique1}`)}}static decodeLengthToOffsetBuffer(e,t){if(t.logicalLevelTechnique1===Kh.DELTA&&t.logicalLevelTechnique2===Kh.NONE)return function(e){const t=new Int32Array(e.length+1);t[0]=0,t[1]=cp(e[0]);let r=t[1],n=2;for(;n!=t.length;++n){const i=e[n-1];r+=i>>>1^-(1&i),t[n]=t[n-1]+r;}return t}(e);if(t.logicalLevelTechnique1===Kh.RLE&&t.logicalLevelTechnique2===Kh.NONE)return function(e,t,r){const n=new Int32Array(r+1);n[0]=0;let i=1,s=n[0];for(let r=0;r<t;r++){const o=e[r],a=e[r+t];for(let e=i;e<i+o;e++)n[e]=a+s,s=n[e];i+=o;}return n}(e,t.runs,t.numRleValues);if(t.logicalLevelTechnique1===Kh.NONE&&t.logicalLevelTechnique2===Kh.NONE){!function(e){let t=0;for(let r=0;r<e.length;r++)e[r]+=t,t=e[r];}(e);const r=new Int32Array(t.numValues+1);return r[0]=0,r.set(e,1),r}if(t.logicalLevelTechnique1===Kh.DELTA&&t.logicalLevelTechnique2===Kh.RLE){const r=function(e,t,r){const n=new Int32Array(r+1);n[0]=0;let i=1,s=n[0];for(let r=0;r<t;r++){const o=e[r];let a=e[r+t];a=a>>>1^-(1&a);for(let e=i;e<i+o;e++)n[e]=a+s,s=n[e];i+=o;}return n}(e,t.runs,t.numRleValues);return mp(r),r}throw new Error("Only delta encoding is supported for transforming length to offset streams yet.")}static decodeNullableIntStream(e,t,r,n,i){const s=r.physicalLevelTechnique===Wh.FAST_PFOR?up():op(e,t,r.numValues);return this.decodeNullableIntBuffer(s,r,n,i)}static decodeNullableLongStream(e,t,r,n,i){const s=ap(e,t,r.numValues);return this.decodeNullableLongBuffer(s,r,n,i)}static decodeNullableIntBuffer(e,t,r,n){switch(t.logicalLevelTechnique1){case Kh.DELTA:return t.logicalLevelTechnique2===Kh.RLE&&(e=fp(e,t.runs,t.numRleValues)),function(e,t){const r=new Int32Array(e.size());let n=0;e.get(0)?(r[0]=e.get(0)?t[0]>>>1^-(1&t[0]):0,n=1):r[0]=0;let i=1;for(;i!=r.length;++i)r[i]=e.get(i)?r[i-1]+(t[n]>>>1^-(1&t[n++])):r[i-1];return r}(n,e);case Kh.RLE:return function(e,t,r,n){const i=t;return r?function(e,t,r){const n=new Int32Array(e.size());let i=0;for(let s=0;s<r;s++){const o=t[s];let a=t[s+r];a=a>>>1^-(1&a);for(let t=i;t<i+o;t++)e.get(t)?n[t]=a:(n[t]=0,i++);i+=o;}return n}(n,e,i.runs):function(e,t,r){const n=new Int32Array(e.size());let i=0;for(let s=0;s<r;s++){const o=t[s],a=t[s+r];for(let t=i;t<i+o;t++)e.get(t)?n[t]=a:(n[t]=0,i++);i+=o;}return n}(n,e,i.runs)}(e,t,r,n);case Kh.MORTON:return mp(e),e;case Kh.COMPONENTWISE_DELTA:return gp(e),e;case Kh.NONE:return e=r?function(e,t){const r=new Int32Array(e.size());let n=0,i=0;for(;i!=r.length;++i)if(e.get(i)){const e=t[n++];r[i]=e>>>1^-(1&e);}else r[i]=0;return r}(n,e):function(e,t){const r=new Int32Array(e.size());let n=0,i=0;for(;i!=r.length;++i)r[i]=e.get(i)?t[n++]:0;return r}(n,e),e;default:throw new Error("The specified Logical level technique is not supported")}}static decodeNullableLongBuffer(e,t,r,n){switch(t.logicalLevelTechnique1){case Kh.DELTA:return t.logicalLevelTechnique2===Kh.RLE&&(e=dp(e,t.runs,t.numRleValues)),function(e,t){const r=new BigInt64Array(e.size());let n=0;e.get(0)?(r[0]=e.get(0)?t[0]>>1n^-(1n&t[0]):0n,n=1):r[0]=0n;let i=1;for(;i!=r.length;++i)r[i]=e.get(i)?r[i-1]+(t[n]>>1n^-(1n&t[n++])):r[i-1];return r}(n,e);case Kh.RLE:return function(e,t,r,n){const i=t;return r?function(e,t,r){const n=new BigInt64Array(e.size());let i=0;for(let s=0;s<r;s++){const o=Number(t[s]);let a=t[s+r];a=a>>1n^-(1n&a);for(let t=i;t<i+o;t++)e.get(t)?n[t]=a:(n[t]=0n,i++);i+=o;}return n}(n,e,i.runs):function(e,t,r){const n=new BigInt64Array(e.size());let i=0;for(let s=0;s<r;s++){const o=Number(t[s]),a=t[s+r];for(let t=i;t<i+o;t++)e.get(t)?n[t]=a:(n[t]=0n,i++);i+=o;}return n}(n,e,i.runs)}(e,t,r,n);case Kh.NONE:return e=r?function(e,t){const r=new BigInt64Array(e.size());let n=0,i=0;for(;i!=r.length;++i)if(e.get(i)){const e=t[n++];r[i]=e>>1n^-(1n&e);}else r[i]=0n;return r}(n,e):function(e,t){const r=new BigInt64Array(e.size());let n=0,i=0;for(;i!=r.length;++i)r[i]=e.get(i)?t[n++]:0n;return r}(n,e),e;default:throw new Error("The specified Logical level technique is not supported")}}static getVectorType(e,t,r,n){const i=e.logicalLevelTechnique1;if(i===Kh.RLE)return 1===e.runs?tp.CONST:tp.FLAT;const s=t instanceof Sp?t.size():t;if(i===Kh.DELTA&&e.logicalLevelTechnique2===Kh.RLE){const t=e.runs,i=2;if(e.numRleValues!==s)return tp.FLAT;if(1===t)return tp.SEQUENCE;if(2===t){const t=n.get();let s;if(e.physicalLevelTechnique===Wh.VARINT)s=op(r,n,4);else {const e=n.get();s=new Int32Array(r.buffer,r.byteOffset+e,4);}if(n.set(t),s[2]===i&&s[3]===i)return tp.SEQUENCE}}return 1===e.numValues?tp.CONST:tp.FLAT}}class Tp extends $h{getValueFromBuffer(e){return this.dataBuffer[e]}}class Ip extends jh{constructor(e,t,r,n){super(e,BigInt64Array.of(t),r,n);}getValueFromBuffer(e){return this.dataBuffer[0]+BigInt(e)*this.delta}}class Ep{_geometryOffsets;_partOffsets;_ringOffsets;constructor(e,t,r){this._geometryOffsets=e,this._partOffsets=t,this._ringOffsets=r;}get geometryOffsets(){return this._geometryOffsets}get partOffsets(){return this._partOffsets}get ringOffsets(){return this._ringOffsets}}class Mp{tileExtent;_numBits;_coordinateShift;minBound;maxBound;constructor(e,t){this._coordinateShift=e<0?Math.abs(e):0,this.tileExtent=t+this._coordinateShift,this._numBits=Math.ceil(Math.log2(this.tileExtent)),this.minBound=e,this.maxBound=t;}validateCoordinates(e){if(e.x<this.minBound||e.y<this.minBound||e.x>this.maxBound||e.y>this.maxBound)throw new Error("The specified tile buffer size is currently not supported.")}numBits(){return this._numBits}coordinateShift(){return this._coordinateShift}}class kp extends Mp{encode(e){this.validateCoordinates(e);const t=e.x+this._coordinateShift,r=e.y+this._coordinateShift;let n=0;for(let e=0;e<this._numBits;e++)n|=(t&1<<e)<<e|(r&1<<e)<<e+1;return n}decode(e){return {x:this.decodeMorton(e)-this._coordinateShift,y:this.decodeMorton(e>>1)-this._coordinateShift}}decodeMorton(e){let t=0;for(let r=0;r<this._numBits;r++)t|=(e&1<<2*r)>>r;return t}static decode(e,t,r){return {x:kp.decodeMorton(e,t)-r,y:kp.decodeMorton(e>>1,t)-r}}static decodeMorton(e,t){let r=0;for(let n=0;n<t;n++)r|=(e&1<<2*n)>>n;return r}}!function(e){e[e.POINT=0]="POINT",e[e.LINESTRING=1]="LINESTRING",e[e.POLYGON=2]="POLYGON",e[e.MULTIPOINT=3]="MULTIPOINT",e[e.MULTILINESTRING=4]="MULTILINESTRING",e[e.MULTIPOLYGON=5]="MULTIPOLYGON";}(rp||(rp={})),function(e){e[e.POINT=0]="POINT",e[e.LINESTRING=1]="LINESTRING",e[e.POLYGON=2]="POLYGON";}(np||(np={})),function(e){e[e.MORTON=0]="MORTON",e[e.VEC_2=1]="VEC_2",e[e.VEC_3=2]="VEC_3";}(ip||(ip={}));class Fp{createPoint(e){return [[e]]}createMultiPoint(e){return e.map((e=>[e]))}createLineString(e){return [e]}createMultiLineString(e){return e}createPolygon(e,t){return [e,...t]}createMultiPolygon(e){return e.flat()}}function Dp(e){const t=new Array(e.numGeometries);let n=1,i=1,s=1,o=0;const a=new Fp;let l=0,u=0;const c=e.mortonSettings,h=e.topologyVector,p=h.geometryOffsets,f=h.partOffsets,d=h.ringOffsets,y=e.vertexOffsets,m=e.containsPolygonGeometry(),g=e.vertexBuffer;for(let h=0;h<e.numGeometries;h++){const x=e.geometryType(h);if(x===rp.POINT){if(y&&0!==y.length)if(e.vertexBufferType===ip.VEC_2){const e=2*y[u++],n=new r(g[e],g[e+1]);t[o++]=a.createPoint(n);}else {const e=y[u++],n=kp.decode(g[e],c.numBits,c.coordinateShift),i=new r(n.x,n.y);t[o++]=a.createPoint(i);}else {const e=new r(g[l++],g[l++]);t[o++]=a.createPoint(e);}p&&s++,f&&n++,d&&i++;}else if(x===rp.MULTIPOINT){const e=p[s]-p[s-1];s++;const n=new Array(e);if(y&&0!==y.length){for(let t=0;t<e;t++){const e=2*y[u++];n[t]=new r(g[e],g[e+1]);}t[o++]=a.createMultiPoint(n);}else {for(let t=0;t<e;t++){const e=g[l++],i=g[l++];n[t]=new r(e,i);}t[o++]=a.createMultiPoint(n);}}else if(x===rp.LINESTRING){let r,h=0;m?(h=d[i]-d[i-1],i++):h=f[n]-f[n-1],n++,y&&0!==y.length?(r=e.vertexBufferType===ip.VEC_2?Cp(g,y,u,h,!1):Lp(g,y,u,h,!1,c),u+=h):(r=Vp(g,l,h,!1),l+=2*h),t[o++]=a.createLineString(r),p&&s++;}else if(x===rp.POLYGON){const r=f[n]-f[n-1];n++;const h=new Array(r-1);let m=d[i]-d[i-1];if(i++,y&&0!==y.length){const r=e.vertexBufferType===ip.VEC_2?Bp(g,y,u,m):zp(g,y,u,m,0,c);u+=m;for(let t=0;t<h.length;t++)m=d[i]-d[i-1],i++,h[t]=e.vertexBufferType===ip.VEC_2?Bp(g,y,u,m):zp(g,y,u,m,0,c),u+=m;t[o++]=a.createPolygon(r,h);}else {const e=Pp(g,l,m);l+=2*m;for(let e=0;e<h.length;e++)m=d[i]-d[i-1],i++,h[e]=Pp(g,l,m),l+=2*m;t[o++]=a.createPolygon(e,h);}p&&s++;}else if(x===rp.MULTILINESTRING){const r=p[s]-p[s-1];s++;const h=new Array(r);if(y&&0!==y.length){for(let t=0;t<r;t++){let r=0;m?(r=d[i]-d[i-1],i++):r=f[n]-f[n-1],n++;const s=e.vertexBufferType===ip.VEC_2?Cp(g,y,u,r,!1):Lp(g,y,u,r,!1,c);h[t]=s,u+=r;}t[o++]=a.createMultiLineString(h);}else {for(let e=0;e<r;e++){let t=0;m?(t=d[i]-d[i-1],i++):t=f[n]-f[n-1],n++,h[e]=Vp(g,l,t,!1),l+=2*t;}t[o++]=a.createMultiLineString(h);}}else {if(x!==rp.MULTIPOLYGON)throw new Error("The specified geometry type is currently not supported.");{const r=p[s]-p[s-1];s++;const h=new Array(r);let m=0;if(y&&0!==y.length){for(let t=0;t<r;t++){const r=f[n]-f[n-1];n++;const s=new Array(r-1);m=d[i]-d[i-1],i++;const o=e.vertexBufferType===ip.VEC_2?Bp(g,y,u,m):zp(g,y,u,m,0,c);u+=m;for(let t=0;t<s.length;t++)m=d[i]-d[i-1],i++,s[t]=e.vertexBufferType===ip.VEC_2?Bp(g,y,u,m):zp(g,y,u,m,0,c),u+=m;h[t]=a.createPolygon(o,s);}t[o++]=a.createMultiPolygon(h);}else {for(let e=0;e<r;e++){const t=f[n]-f[n-1];n++;const r=new Array(t-1);m=d[i]-d[i-1],i++;const s=Pp(g,l,m);l+=2*m;for(let e=0;e<r.length;e++){const t=d[i]-d[i-1];i++,r[e]=Pp(g,l,t),l+=2*t;}h[e]=a.createPolygon(s,r);}t[o++]=a.createMultiPolygon(h);}}}}return t}function Pp(e,t,r){return Vp(e,t,r,!0)}function Bp(e,t,r,n){return Cp(e,t,r,n,!0)}function zp(e,t,r,n,i,s){return Lp(e,t,r,n,!0,s)}function Vp(e,t,n,i){const s=new Array(i?n+1:n);for(let i=0;i<2*n;i+=2)s[i/2]=new r(e[t+i],e[t+i+1]);return i&&(s[s.length-1]=s[0]),s}function Cp(e,t,n,i,s){const o=new Array(s?i+1:i);for(let s=0;s<2*i;s+=2){const i=2*t[n+s/2];o[s/2]=new r(e[i],e[i+1]);}return s&&(o[o.length-1]=o[0]),o}function Lp(e,t,n,i,s,o){const a=new Array(s?i+1:i);for(let s=0;s<i;s++){const i=kp.decode(e[t[n+s]],o.numBits,o.coordinateShift);a[s]=new r(i.x,i.y);}return s&&(a[a.length-1]=a[0]),a}class Op{_vertexBufferType;_topologyVector;_vertexOffsets;_vertexBuffer;_mortonSettings;constructor(e,t,r,n,i){this._vertexBufferType=e,this._topologyVector=t,this._vertexOffsets=r,this._vertexBuffer=n,this._mortonSettings=i;}get vertexBufferType(){return this._vertexBufferType}get topologyVector(){return this._topologyVector}get vertexOffsets(){return this._vertexOffsets}get vertexBuffer(){return this._vertexBuffer}*[Symbol.iterator](){const e=Dp(this);let t=0;for(;t<this.numGeometries;)yield {coordinates:e[t],type:this.geometryType(t)},t++;}getSimpleEncodedVertex(e){const t=this.vertexOffsets?2*this.vertexOffsets[e]:2*e;return [this.vertexBuffer[t],this.vertexBuffer[t+1]]}getVertex(e){if(this.vertexOffsets&&this.mortonSettings){const t=kp.decode(this.vertexBuffer[this.vertexOffsets[e]],this.mortonSettings.numBits,this.mortonSettings.coordinateShift);return [t.x,t.y]}const t=this.vertexOffsets?2*this.vertexOffsets[e]:2*e;return [this.vertexBuffer[t],this.vertexBuffer[t+1]]}getGeometries(){return Dp(this)}get mortonSettings(){return this._mortonSettings}}class Rp extends Op{_numGeometries;_geometryType;constructor(e,t,r,n,i,s,o){super(r,n,i,s,o),this._numGeometries=e,this._geometryType=t;}static createMortonEncoded(e,t,r,n,i,s){return new Rp(e,t,ip.MORTON,r,n,i,s)}static create(e,t,r,n,i){return new Rp(e,t,ip.VEC_2,r,n,i)}geometryType(e){return this._geometryType}get numGeometries(){return this._numGeometries}containsPolygonGeometry(){return this._geometryType===rp.POLYGON||this._geometryType===rp.MULTIPOLYGON}containsSingleGeometryType(){return !0}}class Np extends Op{_geometryTypes;constructor(e,t,r,n,i,s){super(e,r,n,i,s),this._geometryTypes=t;}static createMortonEncoded(e,t,r,n,i){return new Np(ip.MORTON,e,t,r,n,i)}static create(e,t,r,n){return new Np(ip.VEC_2,e,t,r,n)}geometryType(e){return this._geometryTypes[e]}get numGeometries(){return this._geometryTypes.length}containsPolygonGeometry(){for(let e=0;e<this.numGeometries;e++)if(this.geometryType(e)===rp.POLYGON||this.geometryType(e)===rp.MULTIPOLYGON)return !0;return !1}containsSingleGeometryType(){return !1}}class $p{_triangleOffsets;_indexBuffer;_vertexBuffer;_topologyVector;constructor(e,t,r,n){this._triangleOffsets=e,this._indexBuffer=t,this._vertexBuffer=r,this._topologyVector=n;}get triangleOffsets(){return this._triangleOffsets}get indexBuffer(){return this._indexBuffer}get vertexBuffer(){return this._vertexBuffer}get topologyVector(){return this._topologyVector}getGeometries(){if(!this._topologyVector)throw new Error("Cannot convert GpuVector to coordinates without topology information");const e=new Array(this.numGeometries),t=this._topologyVector,n=t.partOffsets,i=t.ringOffsets,s=t.geometryOffsets;let o=0,a=1,l=1,u=1;for(let t=0;t<this.numGeometries;t++)switch(this.geometryType(t)){case rp.POLYGON:{const c=n[a]-n[a-1];a++;const h=[];for(let e=0;e<c;e++){const e=i[l]-i[l-1];l++;const t=[];for(let n=0;n<e;n++){const e=this._vertexBuffer[o++],n=this._vertexBuffer[o++];t.push(new r(e,n));}t.length>0&&t.push(t[0]),h.push(t);}e[t]=h,s&&u++;}break;case rp.MULTIPOLYGON:{const c=s[u]-s[u-1];u++;const h=[];for(let e=0;e<c;e++){const e=n[a]-n[a-1];a++;for(let t=0;t<e;t++){const e=i[l]-i[l-1];l++;const t=[];for(let n=0;n<e;n++){const e=this._vertexBuffer[o++],n=this._vertexBuffer[o++];t.push(new r(e,n));}t.length>0&&t.push(t[0]),h.push(t);}}e[t]=h;}}return e}[Symbol.iterator](){return null}}class Up extends $p{_numGeometries;_geometryType;constructor(e,t,r,n,i,s){super(r,n,i,s),this._numGeometries=e,this._geometryType=t;}static create(e,t,r,n,i,s){return new Up(e,t,r,n,i,s)}geometryType(e){return this._geometryType}get numGeometries(){return this._numGeometries}containsSingleGeometryType(){return !0}}class qp extends $p{_geometryTypes;constructor(e,t,r,n,i){super(t,r,n,i),this._geometryTypes=e;}static create(e,t,r,n,i){return new qp(e,t,r,n,i)}geometryType(e){return this._geometryTypes[e]}get numGeometries(){return this._geometryTypes.length}containsSingleGeometryType(){return !1}}function jp(e,t,r,n,i){const s=_p.decode(e,r);let o=null,a=null,l=null,u=null,c=null,h=null,p=null,f=null;if(Ap.getVectorType(s,n,e,r)===tp.CONST){const d=Ap.decodeConstIntStream(e,r,s,!1);for(let n=0;n<t-1;n++){const t=_p.decode(e,r);switch(t.physicalStreamType){case Hh.LENGTH:switch(t.logicalStreamType.lengthType){case ep.GEOMETRIES:o=Ap.decodeLengthStreamToOffsetBuffer(e,r,t);break;case ep.PARTS:a=Ap.decodeLengthStreamToOffsetBuffer(e,r,t);break;case ep.RINGS:l=Ap.decodeLengthStreamToOffsetBuffer(e,r,t);break;case ep.TRIANGLES:p=Ap.decodeLengthStreamToOffsetBuffer(e,r,t);}break;case Hh.OFFSET:switch(t.logicalStreamType.offsetType){case Qh.VERTEX:u=Ap.decodeIntStream(e,r,t,!1);break;case Qh.INDEX:f=Ap.decodeIntStream(e,r,t,!1);}break;case Hh.DATA:if(Jh.VERTEX===t.logicalStreamType.dictionaryType)c=Ap.decodeIntStream(e,r,t,!0,i);else {const n=t;h={numBits:n.numBits(),coordinateShift:n.coordinateShift()},c=Ap.decodeIntStream(e,r,t,!1,i);}}}if(null!==f){if(null!=o||null!=a){const e=new Ep(o,a,l);return Up.create(n,d,p,f,c,e)}return Up.create(n,d,p,f,c)}return null===h?Rp.create(n,d,new Ep(o,a,l),u,c):Rp.createMortonEncoded(n,d,new Ep(o,a,l),u,c,h)}const d=Ap.decodeIntStream(e,r,s,!1);for(let n=0;n<t-1;n++){const t=_p.decode(e,r);switch(t.physicalStreamType){case Hh.LENGTH:switch(t.logicalStreamType.lengthType){case ep.GEOMETRIES:o=Ap.decodeIntStream(e,r,t,!1);break;case ep.PARTS:a=Ap.decodeIntStream(e,r,t,!1);break;case ep.RINGS:l=Ap.decodeIntStream(e,r,t,!1);break;case ep.TRIANGLES:p=Ap.decodeLengthStreamToOffsetBuffer(e,r,t);}break;case Hh.OFFSET:switch(t.logicalStreamType.offsetType){case Qh.VERTEX:u=Ap.decodeIntStream(e,r,t,!1);break;case Qh.INDEX:f=Ap.decodeIntStream(e,r,t,!1);}break;case Hh.DATA:if(Jh.VERTEX===t.logicalStreamType.dictionaryType)c=Ap.decodeIntStream(e,r,t,!0,i);else {const n=t;h={numBits:n.numBits(),coordinateShift:n.coordinateShift()},c=Ap.decodeIntStream(e,r,t,!1,i);}}}return null!==f&&null===a?qp.create(d,p,f,c):(null!==o?(o=Gp(d,o,2),null!==a&&null!==l?(a=Xp(d,o,a,!1),l=function(e,t,r,n){const i=new Int32Array(r[r.length-1]+1);let s=0;i[0]=s;let o=1,a=1,l=0;for(let u=0;u<e.length;u++){const c=e[u],h=t[u+1]-t[u];if(0!==c&&3!==c)for(let e=0;e<h;e++){const e=r[o]-r[o-1];o++;for(let t=0;t<e;t++)s=i[a++]=s+n[l++];}else for(let e=0;e<h;e++)i[a++]=++s,o++;}return i}(d,o,a,l)):null!==a&&(a=function(e,t,r){const n=new Int32Array(t[t.length-1]+1);let i=0;n[0]=i;let s=1,o=0;for(let a=0;a<e.length;a++){const l=e[a],u=t[a+1]-t[a];if(4===l||1===l)for(let e=0;e<u;e++)i=n[s++]=i+r[o++];else for(let e=0;e<u;e++)n[s++]=++i;}return n}(d,o,a))):null!==a&&null!==l?(a=Gp(d,a,1),l=Xp(d,a,l,!0)):null!==a&&(a=Gp(d,a,0)),null!==f?qp.create(d,p,f,c,new Ep(o,a,l)):null===h?Np.create(d,new Ep(o,a,l),u,c):Np.createMortonEncoded(d,new Ep(o,a,l),u,c,h))}function Gp(e,t,r){const n=new Int32Array(e.length+1);let i=0;n[0]=i;let s=0;for(let o=0;o<e.length;o++)i=n[o+1]=i+(e[o]>r?t[s++]:1);return n}function Xp(e,t,r,n){const i=new Int32Array(t[t.length-1]+1);let s=0;i[0]=s;let o=1,a=0;for(let l=0;l<e.length;l++){const u=e[l],c=t[l+1]-t[l];if(5===u||2===u||n&&(4===u||1===u))for(let e=0;e<c;e++)s=i[o++]=s+r[a++];else for(let e=0;e<c;e++)i[o++]=++s;}return i}class Yp extends Nh{dataVector;constructor(e,t,r){super(e,t.getBuffer(),r),this.dataVector=t;}getValueFromBuffer(e){return this.dataVector.get(e)}}class Zp extends $h{getValueFromBuffer(e){return this.dataBuffer[e]}}class Hp extends Nh{constructor(e,t,r){super(e,BigInt64Array.of(t),r);}getValueFromBuffer(e){return this.dataBuffer[0]}}function Kp(e,t,r){for(let n=0;n<e;n++){const e=_p.decode(t,r);r.add(e.byteLength);}}function Wp(e,t,r){return Jp(e,Math.ceil(t/8),r)}function Jp(e,t,r){const n=new Uint8Array(t);let i=0;for(;i<t;){const t=e[r.increment()];if(t<=127){const s=t+3,o=e[r.increment()],a=i+s;n.fill(o,i,a),i=a;}else {const s=256-t;for(let t=0;t<s;t++)n[i++]=e[r.increment()];}}return n}const Qp=new TextDecoder;function ef(e,t,r){return r-t>=12?Qp.decode(e.subarray(t,r)):function(e,t,r){let n="",i=t;for(;i<r;){const t=e[i];let s,o,a,l=null,u=t>239?4:t>223?3:t>191?2:1;if(i+u>r)break;1===u?t<128&&(l=t):2===u?(s=e[i+1],128==(192&s)&&(l=(31&t)<<6|63&s,l<=127&&(l=null))):3===u?(s=e[i+1],o=e[i+2],128==(192&s)&&128==(192&o)&&(l=(15&t)<<12|(63&s)<<6|63&o,(l<=2047||l>=55296&&l<=57343)&&(l=null))):4===u&&(s=e[i+1],o=e[i+2],a=e[i+3],128==(192&s)&&128==(192&o)&&128==(192&a)&&(l=(15&t)<<18|(63&s)<<12|(63&o)<<6|63&a,(l<=65535||l>=1114112)&&(l=null))),null===l?(l=65533,u=1):l>65535&&(l-=65536,n+=String.fromCharCode(l>>>10&1023|55296),l=56320|1023&l),n+=String.fromCharCode(l),i+=u;}return n}(e,t,r)}class tf extends Nh{offsetBuffer;constructor(e,t,r,n){super(e,r,n),this.offsetBuffer=t;}}class rf extends tf{textEncoder;constructor(e,t,r,n){super(e,t,r,n??t.length-1),this.textEncoder=new TextEncoder;}getValueFromBuffer(e){return ef(this.dataBuffer,this.offsetBuffer[e],this.offsetBuffer[e+1])}}class nf extends tf{indexBuffer;textEncoder;constructor(e,t,r,n,i){super(e,r,n,i??t.length),this.indexBuffer=t,this.indexBuffer=t,this.textEncoder=new TextEncoder;}getValueFromBuffer(e){const t=this.indexBuffer[e];return ef(this.dataBuffer,this.offsetBuffer[t],this.offsetBuffer[t+1])}}class sf extends tf{indexBuffer;symbolOffsetBuffer;symbolTableBuffer;textEncoder;symbolLengthBuffer;lengthBuffer;decodedDictionary;constructor(e,t,r,n,i,s,o){super(e,r,n,o),this.indexBuffer=t,this.symbolOffsetBuffer=i,this.symbolTableBuffer=s,this.textEncoder=new TextEncoder;}getValueFromBuffer(e){null==this.decodedDictionary&&(null==this.symbolLengthBuffer&&(this.symbolLengthBuffer=this.offsetToLengthBuffer(this.symbolOffsetBuffer),this.lengthBuffer=this.offsetToLengthBuffer(this.offsetBuffer)),this.decodedDictionary=function(e,t,r){const n=[],i=new Array(t.length).fill(0);for(let e=1;e<t.length;e++)i[e]=i[e-1]+t[e-1];for(let s=0;s<r.length;s++)if(255===r[s])n.push(r[++s]);else {const o=t[r[s]],a=i[r[s]];for(let t=0;t<o;t++)n.push(e[a+t]);}return new Uint8Array(n)}(this.symbolTableBuffer,this.symbolLengthBuffer,this.dataBuffer));const t=this.indexBuffer[e];return ef(this.decodedDictionary,this.offsetBuffer[t],this.offsetBuffer[t+1])}offsetToLengthBuffer(e){const t=new Uint32Array(e.length-1);let r=e[0];for(let n=1;n<e.length;n++){const i=e[n];t[n-1]=i-r,r=i;}return t}}class of{static ROOT_COLUMN_NAME="default";static NESTED_COLUMN_SEPARATOR=":";constructor(){}static decode(e,t,r,n,i){let s=null,o=null,a=null,l=null,u=null,c=null,h=null,p=null;for(let e=0;e<n;e++){const e=_p.decode(t,r);if(0!==e.byteLength)switch(e.physicalStreamType){case Hh.PRESENT:{const n=Wp(t,e.numValues,r);c=new Sp(n,e.numValues);break}case Hh.OFFSET:o=null!=i||null!=c?Ap.decodeNullableIntStream(t,r,e,!1,i??c):Ap.decodeIntStream(t,r,e,!1);break;case Hh.LENGTH:{const n=Ap.decodeLengthStreamToOffsetBuffer(t,r,e);ep.DICTIONARY===e.logicalStreamType.lengthType?s=n:ep.SYMBOL===e.logicalStreamType.lengthType?l=n:h=n;break}case Hh.DATA:{const n=t.subarray(r.get(),r.get()+e.byteLength);r.add(e.byteLength);const i=e.logicalStreamType.dictionaryType;Jh.FSST===i?u=n:Jh.SINGLE===i||Jh.SHARED===i?a=n:Jh.NONE===i&&(p=n);break}}}return this.decodeFsstDictionaryVector(e,u,o,s,a,l,i??c)??this.decodeDictionaryVector(e,a,o,s,i??c)??this.decodePlainStringVector(e,h,p,o,i??c)}static decodeFsstDictionaryVector(e,t,r,n,i,s,o){return t?new sf(e,r,n,i,s,t,o):null}static decodeDictionaryVector(e,t,r,n,i){return t?i?new nf(e,r,n,t,i):new nf(e,r,n,t):null}static decodePlainStringVector(e,t,r,n,i){if(!t||!r)return null;if(n)return i?new nf(e,n,t,r,i):new nf(e,n,t,r);if(i&&i.size()!==t.length-1){const n=new Int32Array(i.size());let s=0;for(let e=0;e<i.size();e++)n[e]=i.get(e)?s++:0;return new nf(e,n,t,r,i)}return i?new rf(e,t,r,i):new rf(e,t,r)}static decodeSharedDictionary(e,t,r,n,i){let s=null,o=null,a=null,l=null,u=!1;for(;!u;){const r=_p.decode(e,t);switch(r.physicalStreamType){case Hh.LENGTH:ep.DICTIONARY===r.logicalStreamType.lengthType?s=Ap.decodeLengthStreamToOffsetBuffer(e,t,r):a=Ap.decodeLengthStreamToOffsetBuffer(e,t,r);break;case Hh.DATA:Jh.SINGLE===r.logicalStreamType.dictionaryType||Jh.SHARED===r.logicalStreamType.dictionaryType?(o=e.subarray(t.get(),t.get()+r.byteLength),u=!0):l=e.subarray(t.get(),t.get()+r.byteLength),t.add(r.byteLength);}}const c=r.complexType.children,h=[];let p=0;for(const u of c){const c=op(e,t,1)[0];if(0==c)continue;const f=`${r.name}${u.name===of.ROOT_COLUMN_NAME?"":of.NESTED_COLUMN_SEPARATOR+u.name}`;if(i&&!i.has(f)){Kp(c,e,t);continue}if(2!==c||"scalarField"!==u.type||9!==u.scalarField.physicalType)throw new Error("Currently only optional string fields are implemented for a struct.");const d=_p.decode(e,t),y=Wp(e,d.numValues,t),m=_p.decode(e,t),g=(m instanceof wp?m.numRleValues:m.numValues)!==n?Ap.decodeNullableIntStream(e,t,m,!1,new Sp(y,d.numValues)):Ap.decodeIntStream(e,t,m,!1);h[p++]=l?new sf(f,g,s,o,a,l,new Sp(y,d.numValues)):new nf(f,g,s,o,new Sp(y,d.numValues));}return h}}function af(e,t,r,n,i,s){return "scalarType"===r.type?function(e,t,r,n,i,s){let o=null,a=0;if(0===e)return null;if(s.nullable){const e=_p.decode(t,r);a=e.numValues;const n=r.get(),i=Wp(t,a,r);r.set(n+e.byteLength),o=new Sp(i,e.numValues);}const l=o??n;switch(i.physicalType){case 4:case 3:return function(e,t,r,n,i){const s=_p.decode(e,t),o=Ap.getVectorType(s,i,e,t),a=3===n.physicalType;if(o===tp.FLAT){const n=lf(i)?Ap.decodeNullableIntStream(e,t,s,a,i):Ap.decodeIntStream(e,t,s,a);return new Uh(r.name,n,i)}if(o===tp.SEQUENCE){const n=Ap.decodeSequenceIntStream(e,t,s);return new Gh(r.name,n[0],n[1],s.numRleValues)}{const n=Ap.decodeConstIntStream(e,t,s,a);return new Xh(r.name,n,i)}}(t,r,s,i,l);case 9:return of.decode(s.name,t,r,s.nullable?e-1:e,o);case 0:return function(e,t,r,n,i){const s=_p.decode(e,t),o=s.numValues,a=t.get(),l=lf(i)?function(e,t,r,n){const i=Jp(e,Math.ceil(t/8),r),s=new Sp(i,t),o=n.size(),a=new Sp(new Uint8Array(o),o);let l=0;for(let e=0;e<n.size();e++){const t=!!n.get(e)&&s.get(l++);a.set(e,t);}return a.getBuffer()}(e,o,t,i):Wp(e,o,t);t.set(a+s.byteLength);const u=new Sp(l,o);return new Yp(r.name,u,i)}(t,r,s,0,l);case 6:case 5:return function(e,t,r,n,i){const s=_p.decode(e,t),o=Ap.getVectorType(s,n,e,t),a=5===i.physicalType;if(o===tp.FLAT){const i=lf(n)?Ap.decodeNullableLongStream(e,t,s,a,n):Ap.decodeLongStream(e,t,s,a);return new Tp(r.name,i,n)}if(o===tp.SEQUENCE){const n=Ap.decodeSequenceLongStream(e,t,s);return new Ip(r.name,n[0],n[1],s.numRleValues)}{const i=Ap.decodeConstLongStream(e,t,s,a);return new Hp(r.name,i,n)}}(t,r,s,l,i);case 7:return function(e,t,r,n){const i=_p.decode(e,t),s=lf(n)?function(e,t,r,n){const i=t.get(),s=i+n*Float32Array.BYTES_PER_ELEMENT,o=new Uint8Array(e.subarray(i,s)).buffer,a=new Float32Array(o);t.set(s);const l=r.size(),u=new Float32Array(l);let c=0;for(let e=0;e<l;e++)u[e]=r.get(e)?a[c++]:0;return u}(e,t,n,i.numValues):function(e,t,r){const n=t.get(),i=n+r*Float32Array.BYTES_PER_ELEMENT,s=new Uint8Array(e.subarray(n,i)).buffer,o=new Float32Array(s);return t.set(i),o}(e,t,i.numValues);return new Zp(r.name,s,n)}(t,r,s,l);case 8:return function(e,t,r,n){const i=_p.decode(e,t),s=lf(n)?function(e,t,r,n){const i=t.get(),s=i+n*Float64Array.BYTES_PER_ELEMENT,o=new Uint8Array(e.subarray(i,s)).buffer,a=new Float64Array(o);t.set(s);const l=r.size(),u=new Float64Array(l);let c=0;for(let e=0;e<l;e++)u[e]=r.get(e)?a[c++]:0;return u}(e,t,n,i.numValues):function(e,t,r){const n=t.get(),i=n+r*Float64Array.BYTES_PER_ELEMENT,s=new Uint8Array(e.subarray(n,i)).buffer,o=new Float64Array(s);return t.set(i),o}(e,t,i.numValues);return new qh(r.name,s,n)}(t,r,s,l);default:throw new Error(`The specified data type for the field is currently not supported: ${i}`)}}(n,e,t,i,r.scalarType,r):1!=n?null:of.decodeSharedDictionary(e,t,r,i,s)}function lf(e){return e instanceof Sp}class uf{static decodeColumnType(e){switch(e){case 0:case 1:case 2:case 3:{const t={};t.nullable=!!(1&e),t.columnScope=0;const r={};return r.physicalType=e>1?6:4,r.type="physicalType",t.scalarType=r,t.type="scalarType",t}case 4:{const e={nullable:!1,columnScope:0},t={type:"physicalType",physicalType:0};return e.type="complexType",e.complexType=t,e}case 30:{const e={nullable:!1,columnScope:0},t={type:"physicalType",physicalType:1};return e.type="complexType",e.complexType=t,e}default:return this.mapScalarType(e)}}static columnTypeHasName(e){return e>=10}static columnTypeHasChildren(e){return 30===e}static hasStreamCount(e){if("id"===e.name)return !1;if("scalarType"===e.type){const t=e.scalarType;if("physicalType"===t.type)switch(t.physicalType){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:default:return !1;case 9:return !0}else if("logicalType"===t.type)return !1}else if("complexType"===e.type){const t=e.complexType;if("physicalType"===t.type)switch(t.physicalType){case 0:case 1:return !0;default:return !1}}return console.warn("Unexpected column type in hasStreamCount",e),!1}static mapScalarType(e){let t=null;switch(e){case 10:case 11:t=0;break;case 12:case 13:t=1;break;case 14:case 15:t=2;break;case 16:case 17:t=3;break;case 18:case 19:t=4;break;case 20:case 21:t=5;break;case 22:case 23:t=6;break;case 24:case 25:t=7;break;case 26:case 27:t=8;break;case 28:case 29:t=9;break;default:return null}const r={};r.nullable=!!(1&e),r.columnScope=0;const n={type:"physicalType"};return n.physicalType=t,r.type="scalarType",r.scalarType=n,r}}const cf=new TextDecoder;function hf(e,t){const r=op(e,t,1)[0];if(0===r)return "";const n=t.get(),i=e.subarray(n,n+r);return t.add(r),cf.decode(i)}function pf(e,t){const r=op(e,t,1)[0]>>>0,n=!!(4&r),i=!!(2&r),s=op(e,t,1)[0]>>>0,o={};if(1&r&&(o.nullable=!0),i){const i={};if(n?(i.type="logicalType",i.logicalType=s):(i.type="physicalType",i.physicalType=s),8&r){const r=op(e,t,1)[0]>>>0;i.children=new Array(r);for(let n=0;n<r;n++)i.children[n]=pf(e,t);}o.type="complexField",o.complexField=i;}else {const e={};n?(e.type="logicalType",e.logicalType=s):(e.type="physicalType",e.physicalType=s),o.type="scalarField",o.scalarField=e;}return o}function ff(e,t){const r=op(e,t,1)[0]>>>0,n=uf.decodeColumnType(r);if(!n)throw new Error(`Unsupported column type code: ${r}`);if(uf.columnTypeHasName(r)?n.name=hf(e,t):r>=0&&r<=3?n.name="id":4===r&&(n.name="geometry"),uf.columnTypeHasChildren(r)){const r=op(e,t,1)[0]>>>0,i=n.complexType;i.children=new Array(r);for(let n=0;n<r;n++)i.children[n]=pf(e,t);}return n}function df(e,t){const r={featureTables:[]},n={};n.name=hf(e,t);const i=op(e,t,1)[0]>>>0,s=op(e,t,1)[0]>>>0;n.columns=new Array(s);for(let r=0;r<s;r++)n.columns[r]=ff(e,t);return r.featureTables.push(n),[r,i]}function yf(e,t,r,n,i,s,o=!1){const a=t.scalarType.physicalType,l=Ap.getVectorType(i,s,e,r);if(4===a)switch(l){case tp.FLAT:{const t=Ap.decodeIntStream(e,r,i,!1);return new Uh(n,t,s)}case tp.SEQUENCE:{const t=Ap.decodeSequenceIntStream(e,r,i);return new Gh(n,t[0],t[1],i.numRleValues)}case tp.CONST:{const t=Ap.decodeConstIntStream(e,r,i,!1);return new Xh(n,t,s)}}else switch(l){case tp.FLAT:{if(o){const t=Ap.decodeLongFloat64Stream(e,r,i,!1);return new qh(n,t,s)}const t=Ap.decodeLongStream(e,r,i,!1);return new Tp(n,t,s)}case tp.SEQUENCE:{const t=Ap.decodeSequenceLongStream(e,r,i);return new Ip(n,t[0],t[1],i.numRleValues)}case tp.CONST:{const t=Ap.decodeConstLongStream(e,r,i,!1);return new Hp(n,t,s)}}throw new Error("Vector type not supported for id column.")}class mf{constructor(e,t){var r;switch(this._featureData=e,this.properties=this._featureData.properties||{},null===(r=this._featureData.geometry)||void 0===r?void 0:r.type){case rp.POINT:case rp.MULTIPOINT:this.type=1;break;case rp.LINESTRING:case rp.MULTILINESTRING:this.type=2;break;case rp.POLYGON:case rp.MULTIPOLYGON:this.type=3;break;default:this.type=0;}this.extent=t,this.id=Number(this._featureData.id);}projectPoint(e,t,r,n){return [360*(e.x+t)/n-180,360/Math.PI*Math.atan(Math.exp((1-2*(e.y+r)/n)*Math.PI))-90]}projectLine(e,t,r,n){return e.map((e=>this.projectPoint(e,t,r,n)))}toGeoJSON(e,t,r){const n=this.extent*Math.pow(2,r),i=this.extent*e,s=this.extent*t,o=this.loadGeometry();let a;switch(this.type){case 1:{const e=[];for(const t of o)e.push(t[0]);const t=this.projectLine(e,i,s,n);a=1===e.length?{type:"Point",coordinates:t[0]}:{type:"MultiPoint",coordinates:t};break}case 2:{const e=o.map((e=>this.projectLine(e,i,s,n)));a=1===e.length?{type:"LineString",coordinates:e[0]}:{type:"MultiLineString",coordinates:e};break}case 3:{const e=Qr(o),t=[];for(const r of e)t.push(r.map((e=>this.projectLine(e,i,s,n))));a=1===t.length?{type:"Polygon",coordinates:t[0]}:{type:"MultiPolygon",coordinates:t};break}default:throw new Error(`unknown feature type: ${this.type}`)}const l={type:"Feature",geometry:a,properties:this.properties};return null!=this.id&&(l.id=this.id),l}loadGeometry(){const e=[];for(const t of this._featureData.geometry.coordinates){const n=[];for(const e of t)n.push(new r(e.x,e.y));e.push(n);}return e}bbox(){return [0,0,0,0]}}class gf{constructor(e){this.features=[],this.featureTable=e,this.name=e.name,this.extent=e.extent,this.version=2,this.features=e.getFeatures(),this.length=this.features.length;}feature(e){return new mf(this.features[e],this.extent)}}class xf{constructor(e){this.layers={};const t=function(e,t,r=!0){const n=new Zh(0),i=[];for(;n.get()<e.length;){const s=op(e,n,1)[0]>>>0,o=n.get()+s;if(o>e.length)throw new Error(`Block overruns tile: ${o} > ${e.length}`);if(1!=op(e,n,1)[0]>>>0){n.set(o);continue}const a=df(e,n),l=a[1],u=a[0].featureTables[0];let c=null,h=null;const p=[];let f=0;for(const i of u.columns){const s=i.name;if("id"===s){let t=null;if(i.nullable){const r=_p.decode(e,n),i=n.get(),s=Wp(e,r.numValues,n);n.set(i+r.byteLength),t=new Sp(s,r.numValues);}const o=_p.decode(e,n);f=o.getDecompressedCount(),c=yf(e,i,n,s,o,t??f,r);}else if("geometry"===s){const r=op(e,n,1)[0];if(0===f){const t=n.get();f=_p.decode(e,n).getDecompressedCount(),n.set(t);}h=jp(e,r,n,f,t);}else {const t=uf.hasStreamCount(i)?op(e,n,1)[0]:1;if(0===t&&"scalarType"===i.type)continue;const r=af(e,n,i,t,f,void 0);r&&(Array.isArray(r)?p.push(...r):p.push(r));}}const d=new Yh(u.name,h,c,p,l);i.push(d),n.set(o);}return i}(new Uint8Array(e));this.layers=t.reduce(((e,t)=>Object.assign(Object.assign({},e),{[t.name]:new gf(t)})),{});}}class vf{constructor(){this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0;}extend(e){return this.minX=Math.min(this.minX,e.x),this.minY=Math.min(this.minY,e.y),this.maxX=Math.max(this.maxX,e.x),this.maxY=Math.max(this.maxY,e.y),this}expandBy(e){return this.minX-=e,this.minY-=e,this.maxX+=e,this.maxY+=e,(this.minX>this.maxX||this.minY>this.maxY)&&(this.minX=1/0,this.maxX=-1/0,this.minY=1/0,this.maxY=-1/0),this}shrinkBy(e){return this.expandBy(-e)}map(e){const t=new vf;return t.extend(e(new r(this.minX,this.minY))),t.extend(e(new r(this.maxX,this.minY))),t.extend(e(new r(this.minX,this.maxY))),t.extend(e(new r(this.maxX,this.maxY))),t}static fromPoints(e){const t=new vf;for(const r of e)t.extend(r);return t}contains(e){return e.x>=this.minX&&e.x<=this.maxX&&e.y>=this.minY&&e.y<=this.maxY}empty(){return this.minX>this.maxX}width(){return this.maxX-this.minX}height(){return this.maxY-this.minY}covers(e){return !this.empty()&&!e.empty()&&e.minX>=this.minX&&e.maxX<=this.maxX&&e.minY>=this.minY&&e.maxY<=this.maxY}intersects(e){return !this.empty()&&!e.empty()&&e.minX<=this.maxX&&e.maxX>=this.minX&&e.minY<=this.maxY&&e.maxY>=this.minY}}const bf="_geojsonTileLayer";class wf{constructor(e,t){this.tileID=e,this.x=e.canonical.x,this.y=e.canonical.y,this.z=e.canonical.z,this.grid=new os(k,16,0),this.grid3D=new os(k,16,0),this.featureIndexArray=new Lo,this.promoteId=t;}insert(e,t,r,n,i,s){const o=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,n,i);const a=s?this.grid3D:this.grid;for(let e=0;e<t.length;e++){const r=t[e],n=[1/0,1/0,-1/0,-1/0];for(let e=0;e<r.length;e++){const t=r[e];n[0]=Math.min(n[0],t.x),n[1]=Math.min(n[1],t.y),n[2]=Math.max(n[2],t.x),n[3]=Math.max(n[3],t.y);}n[0]<k&&n[1]<k&&n[2]>=0&&n[3]>=0&&a.insert(o,n[0],n[1],n[2],n[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers="mlt"!==this.encoding?new ku(new wc(this.rawTileData)).layers:new xf(this.rawTileData).layers,this.sourceLayerCoder=new Oh(this.vtLayers?Object.keys(this.vtLayers).sort():[bf])),this.vtLayers}query(e,t,n,i){this.loadVTLayers();const s=e.params,o=k/e.tileSize/e.scale,a=pi(s.filter,s.globalState),l=e.queryGeometry,u=e.queryPadding*o,c=vf.fromPoints(l),h=this.grid.query(c.minX-u,c.minY-u,c.maxX+u,c.maxY+u),p=vf.fromPoints(e.cameraQueryGeometry).expandBy(u),f=this.grid3D.query(p.minX,p.minY,p.maxX,p.maxY,((t,n,i,s)=>function(e,t,n,i,s){for(const r of e)if(t<=r.x&&n<=r.y&&i>=r.x&&s>=r.y)return !0;const o=[new r(t,n),new r(t,s),new r(i,s),new r(i,n)];if(e.length>2)for(const t of o)if(Ka(e,t))return !0;for(let t=0;t<e.length-1;t++)if(Wa(e[t],e[t+1],o))return !0;return !1}(e.cameraQueryGeometry,t-u,n-u,i+u,s+u)));for(const e of f)h.push(e);h.sort(Sf);const d={};let y;for(let r=0;r<h.length;r++){const u=h[r];if(u===y)continue;y=u;const c=this.featureIndexArray.get(u);let p=null;this.loadMatchingFeature(d,c.bucketIndex,c.sourceLayerIndex,c.featureIndex,a,s.layers,s.availableImages,t,n,i,((t,r,n)=>(p||(p=Ca(t)),r.queryIntersectsFeature({queryGeometry:l,feature:t,featureState:n,geometry:p,zoom:this.z,transform:e.transform,pixelsToTileUnits:o,pixelPosMatrix:e.pixelPosMatrix,unwrappedTileID:this.tileID.toUnwrapped(),getElevation:e.getElevation}))));}return d}loadMatchingFeature(e,t,r,n,i,s,o,a,l,u,c){const h=this.bucketLayerIDs[t];if(s&&!h.some((e=>s.has(e))))return;const p=this.sourceLayerCoder.decode(r),f=this.vtLayers[p].feature(n);if(i.needGeometry){const e=La(f,!0);if(!i.filter(new ks(this.tileID.overscaledZ),e,this.tileID.canonical))return}else if(!i.filter(new ks(this.tileID.overscaledZ),f))return;const d=this.getId(f,p);for(let t=0;t<h.length;t++){const r=h[t];if(s&&!s.has(r))continue;const i=a[r];if(!i)continue;let p={};d&&u&&(p=u.getState(i.sourceLayer||bf,d));const y=O({},l[r]);y.paint=_f(y.paint,i.paint,f,p,o),y.layout=_f(y.layout,i.layout,f,p,o);const m=!c||c(f,i,p);if(!m)continue;const g=new Rh(f,this.z,this.x,this.y,d);g.layer=y;let x=e[r];void 0===x&&(x=e[r]=[]),x.push({featureIndex:n,feature:g,intersectionZ:m});}}lookupSymbolFeatures(e,t,r,n,i,s,o,a){const l={};this.loadVTLayers();const u=pi(i.filterSpec,i.globalState);for(const i of e)this.loadMatchingFeature(l,r,n,i,u,s,o,a,t);return l}hasLayer(e){for(const t of this.bucketLayerIDs)for(const r of t)if(e===r)return !0;return !1}getId(e,t){var r;let n=e.id;return this.promoteId&&(n=e.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[t]],"boolean"==typeof n&&(n=Number(n)),void 0===n&&(null===(r=e.properties)||void 0===r?void 0:r.cluster)&&this.promoteId&&(n=Number(e.properties.cluster_id))),n}}function _f(e,t,r,n,i){return N(e,((e,s)=>{const o=t instanceof Rs?t.get(s):null;return o&&o.evaluate?o.evaluate(r,n,i):o}))}function Sf(e,t){return t-e}function Af(e,t,n,i,s){const o=[];for(let a=0;a<e.length;a++){const l=e[a];let u;for(let e=0;e<l.length-1;e++){let a=l[e],c=l[e+1];a.x<t&&c.x<t||(a.x<t?a=new r(t,a.y+(t-a.x)/(c.x-a.x)*(c.y-a.y))._round():c.x<t&&(c=new r(t,a.y+(t-a.x)/(c.x-a.x)*(c.y-a.y))._round()),a.y<n&&c.y<n||(a.y<n?a=new r(a.x+(n-a.y)/(c.y-a.y)*(c.x-a.x),n)._round():c.y<n&&(c=new r(a.x+(n-a.y)/(c.y-a.y)*(c.x-a.x),n)._round()),a.x>=i&&c.x>=i||(a.x>=i?a=new r(i,a.y+(i-a.x)/(c.x-a.x)*(c.y-a.y))._round():c.x>=i&&(c=new r(i,a.y+(i-a.x)/(c.x-a.x)*(c.y-a.y))._round()),a.y>=s&&c.y>=s||(a.y>=s?a=new r(a.x+(s-a.y)/(c.y-a.y)*(c.x-a.x),s)._round():c.y>=s&&(c=new r(a.x+(s-a.y)/(c.y-a.y)*(c.x-a.x),s)._round()),u&&a.equals(u[u.length-1])||(u=[a],o.push(u)),u.push(c)))));}}return o}function Tf(e,t,r,n,i){switch(t){case 1:return function(e,t,r,n){const i=[];for(const s of e)for(const e of s){const s=0===n?e.x:e.y;s>=t&&s<=r&&i.push([e]);}return i}(e,r,n,i);case 2:return Ef(e,r,n,i,!1);case 3:return Ef(e,r,n,i,!0)}return []}function If(e,t,n,i,s){const o=0===i?Mf:kf;let a=[];const l=[];for(let r=0;r<e.length-1;r++){const u=e[r],c=e[r+1],h=0===i?u.x:u.y,p=0===i?c.x:c.y;let f=!1;h<t?p>t&&a.push(o(u,c,t)):h>n?p<n&&a.push(o(u,c,n)):a.push(u),p<t&&h>=t&&(a.push(o(u,c,t)),f=!0),p>n&&h<=n&&(a.push(o(u,c,n)),f=!0),!s&&f&&(l.push(a),a=[]);}const u=e.length-1,c=0===i?e[u].x:e[u].y;return c>=t&&c<=n&&a.push(e[u]),s&&a.length>0&&!a[0].equals(a[a.length-1])&&a.push(new r(a[0].x,a[0].y)),a.length>0&&l.push(a),l}function Ef(e,t,r,n,i){const s=[];for(const o of e){const e=If(o,t,r,n,i);e.length>0&&s.push(...e);}return s}function Mf(e,t,n){return new r(n,e.y+(n-e.x)/(t.x-e.x)*(t.y-e.y))}function kf(e,t,n){return new r(e.x+(n-e.y)/(t.y-e.y)*(t.x-e.x),n)}ls("FeatureIndex",wf,{omit:["rawTileData","sourceLayerCoder"]});class Ff extends r{constructor(e,t,r,n){super(e,t),this.angle=r,void 0!==n&&(this.segment=n);}clone(){return new Ff(this.x,this.y,this.angle,this.segment)}}function Df(e,t,r,n,i){if(void 0===t.segment||0===r)return !0;let s=t,o=t.segment+1,a=0;for(;a>-r/2;){if(o--,o<0)return !1;a-=e[o].dist(s),s=e[o];}a+=e[o].dist(e[o+1]),o++;const l=[];let u=0;for(;a<r/2;){const t=e[o],r=e[o+1];if(!r)return !1;let s=e[o-1].angleTo(t)-t.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:a,angleDelta:s}),u+=s;a-l[0].distance>n;)u-=l.shift().angleDelta;if(u>i)return !1;o++,a+=t.dist(r);}return !0}function Pf(e){let t=0;for(let r=0;r<e.length-1;r++)t+=e[r].dist(e[r+1]);return t}function Bf(e,t,r){return e?.6*t*r:0}function zf(e,t){return Math.max(e?e.right-e.left:0,t?t.right-t.left:0)}function Vf(e,t,r,n,i,s){const o=Bf(r,i,s),a=zf(r,n)*s;let l=0;const u=Pf(e)/2;for(let r=0;r<e.length-1;r++){const n=e[r],i=e[r+1],s=n.dist(i);if(l+s>u){const c=(u-l)/s,h=dr.number(n.x,i.x,c),p=dr.number(n.y,i.y,c),f=new Ff(h,p,i.angleTo(n),r);return f._round(),!o||Df(e,f,a,o,t)?f:void 0}l+=s;}}function Cf(e,t,r,n,i,s,o,a,l){const u=Bf(n,s,o),c=zf(n,i),h=c*o,p=0===e[0].x||e[0].x===l||0===e[0].y||e[0].y===l;return t-h<t/4&&(t=h+t/4),Lf(e,p?t/2*a%t:(c/2+2*s)*o*a%t,t,u,r,h,p,!1,l)}function Lf(e,t,r,n,i,s,o,a,l){const u=s/2,c=Pf(e);let h=0,p=t-r,f=[];for(let t=0;t<e.length-1;t++){const o=e[t],a=e[t+1],d=o.dist(a),y=a.angleTo(o);for(;p+r<h+d;){p+=r;const m=(p-h)/d,g=dr.number(o.x,a.x,m),x=dr.number(o.y,a.y,m);if(g>=0&&g<l&&x>=0&&x<l&&p-u>=0&&p+u<=c){const r=new Ff(g,x,y,t);r._round(),n&&!Df(e,r,s,n,i)||f.push(r);}}h+=d;}return a||f.length||o||(f=Lf(e,h/2,r,n,i,s,o,!0,l)),f}function Of(e,t,n,i){const s=[],o=e.image,a=o.pixelRatio,l=o.paddedRect.w-2,u=o.paddedRect.h-2;let c={x1:e.left,y1:e.top,x2:e.right,y2:e.bottom};const h=o.stretchX||[[0,l]],p=o.stretchY||[[0,u]],f=(e,t)=>e+t[1]-t[0],d=h.reduce(f,0),y=p.reduce(f,0),m=l-d,g=u-y;let x=0,v=d,b=0,w=y,_=0,S=m,A=0,T=g;if(o.content&&i){const t=o.content,r=t[2]-t[0],n=t[3]-t[1];(o.textFitWidth||o.textFitHeight)&&(c=Hc(e)),x=Rf(h,0,t[0]),b=Rf(p,0,t[1]),v=Rf(h,t[0],t[2]),w=Rf(p,t[1],t[3]),_=t[0]-x,A=t[1]-b,S=r-v,T=n-w;}const I=c.x1,E=c.y1,M=c.x2-I,k=c.y2-E,F=(e,i,s,l)=>{const u=$f(e.stretch-x,v,M,I),c=Uf(e.fixed-_,S,e.stretch,d),h=$f(i.stretch-b,w,k,E),p=Uf(i.fixed-A,T,i.stretch,y),f=$f(s.stretch-x,v,M,I),m=Uf(s.fixed-_,S,s.stretch,d),g=$f(l.stretch-b,w,k,E),F=Uf(l.fixed-A,T,l.stretch,y),D=new r(u,h),P=new r(f,h),B=new r(f,g),z=new r(u,g),V=new r(c/a,p/a),C=new r(m/a,F/a),L=t*Math.PI/180;if(L){const e=Math.sin(L),t=Math.cos(L),r=[t,-e,e,t];D._matMult(r),P._matMult(r),z._matMult(r),B._matMult(r);}const O=e.stretch+e.fixed,R=i.stretch+i.fixed;return {tl:D,tr:P,bl:z,br:B,tex:{x:o.paddedRect.x+1+O,y:o.paddedRect.y+1+R,w:s.stretch+s.fixed-O,h:l.stretch+l.fixed-R},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:V,pixelOffsetBR:C,minFontScaleX:S/a/M,minFontScaleY:T/a/k,isSDF:n}};if(i&&(o.stretchX||o.stretchY)){const e=Nf(h,m,d),t=Nf(p,g,y);for(let r=0;r<e.length-1;r++){const n=e[r],i=e[r+1];for(let e=0;e<t.length-1;e++)s.push(F(n,t[e],i,t[e+1]));}}else s.push(F({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function Rf(e,t,r){let n=0;for(const i of e)n+=Math.max(t,Math.min(r,i[1]))-Math.max(t,Math.min(r,i[0]));return n}function Nf(e,t,r){const n=[{fixed:-1,stretch:0}];for(const[t,r]of e){const e=n[n.length-1];n.push({fixed:t-e.stretch,stretch:e.stretch}),n.push({fixed:t-e.stretch,stretch:e.stretch+(r-t)});}return n.push({fixed:t+1,stretch:r}),n}function $f(e,t,r,n){return e/t*r+n}function Uf(e,t,r,n){return e-t*r/n}ls("Anchor",Ff);class qf{constructor(e,t,n,i,s,o,a,l,u,c){var h;if(this.boxStartIndex=e.length,u){let e=o.top,t=o.bottom;const r=o.collisionPadding;r&&(e-=r[1],t+=r[3]);let n=t-e;n>0&&(n=Math.max(10,n),this.circleDiameter=n);}else {const u=(null===(h=o.image)||void 0===h?void 0:h.content)&&(o.image.textFitWidth||o.image.textFitHeight)?Hc(o):{x1:o.left,y1:o.top,x2:o.right,y2:o.bottom};u.y1=u.y1*a-l[0],u.y2=u.y2*a+l[2],u.x1=u.x1*a-l[3],u.x2=u.x2*a+l[1];const p=o.collisionPadding;if(p&&(u.x1-=p[0]*a,u.y1-=p[1]*a,u.x2+=p[2]*a,u.y2+=p[3]*a),c){const e=new r(u.x1,u.y1),t=new r(u.x2,u.y1),n=new r(u.x1,u.y2),i=new r(u.x2,u.y2),s=c*Math.PI/180;e._rotate(s),t._rotate(s),n._rotate(s),i._rotate(s),u.x1=Math.min(e.x,t.x,n.x,i.x),u.x2=Math.max(e.x,t.x,n.x,i.x),u.y1=Math.min(e.y,t.y,n.y,i.y),u.y2=Math.max(e.y,t.y,n.y,i.y);}e.emplaceBack(t.x,t.y,u.x1,u.y1,u.x2,u.y2,n,i,s);}this.boxEndIndex=e.length;}}class jf{constructor(e=[],t=(e,t)=>e<t?-1:e>t?1:0){if(this.data=e,this.length=this.data.length,this.compare=t,this.length>0)for(let e=(this.length>>1)-1;e>=0;e--)this._down(e);}push(e){this.data.push(e),this._up(this.length++);}pop(){if(0===this.length)return;const e=this.data[0],t=this.data.pop();return --this.length>0&&(this.data[0]=t,this._down(0)),e}peek(){return this.data[0]}_up(e){const{data:t,compare:r}=this,n=t[e];for(;e>0;){const i=e-1>>1,s=t[i];if(r(n,s)>=0)break;t[e]=s,e=i;}t[e]=n;}_down(e){const{data:t,compare:r}=this,n=this.length>>1,i=t[e];for(;e<n;){let n=1+(e<<1);const s=n+1;if(s<this.length&&r(t[s],t[n])<0&&(n=s),r(t[n],i)>=0)break;t[e]=t[n],e=n;}t[e]=i;}}function Gf(e,t=1,n=!1){const i=vf.fromPoints(e[0]),s=Math.min(i.width(),i.height());let o=s/2;const a=new jf([],Xf),{minX:l,minY:u,maxX:c,maxY:h}=i;if(0===s)return new r(l,u);for(let t=l;t<c;t+=s)for(let r=u;r<h;r+=s)a.push(new Yf(t+o,r+o,o,e));let p=function(e){let t=0,r=0,n=0;const i=e[0];for(let e=0,s=i.length,o=s-1;e<s;o=e++){const s=i[e],a=i[o],l=s.x*a.y-a.x*s.y;r+=(s.x+a.x)*l,n+=(s.y+a.y)*l,t+=3*l;}return new Yf(r/t,n/t,0,e)}(e),f=a.length;for(;a.length;){const r=a.pop();(r.d>p.d||!p.d)&&(p=r,n&&console.log("found best %d after %d probes",Math.round(1e4*r.d)/1e4,f)),r.max-p.d<=t||(o=r.h/2,a.push(new Yf(r.p.x-o,r.p.y-o,o,e)),a.push(new Yf(r.p.x+o,r.p.y-o,o,e)),a.push(new Yf(r.p.x-o,r.p.y+o,o,e)),a.push(new Yf(r.p.x+o,r.p.y+o,o,e)),f+=4);}return n&&(console.log(`num probes: ${f}`),console.log(`best distance: ${p.d}`)),p.p}function Xf(e,t){return t.max-e.max}function Yf(e,t,n,i){this.p=new r(e,t),this.h=n,this.d=function(e,t){let r=!1,n=1/0;for(let i=0;i<t.length;i++){const s=t[i];for(let t=0,i=s.length,o=i-1;t<i;o=t++){const i=s[t],a=s[o];i.y>e.y!=a.y>e.y&&e.x<(a.x-i.x)*(e.y-i.y)/(a.y-i.y)+i.x&&(r=!r),n=Math.min(n,Za(e,i,a));}}return (r?1:-1)*Math.sqrt(n)}(this.p,i),this.max=this.d+this.h*Math.SQRT2;}var Zf;e.aO=void 0,(Zf=e.aO||(e.aO={}))[Zf.center=1]="center",Zf[Zf.left=2]="left",Zf[Zf.right=3]="right",Zf[Zf.top=4]="top",Zf[Zf.bottom=5]="bottom",Zf[Zf["top-left"]=6]="top-left",Zf[Zf["top-right"]=7]="top-right",Zf[Zf["bottom-left"]=8]="bottom-left",Zf[Zf["bottom-right"]=9]="bottom-right";const Hf=Number.POSITIVE_INFINITY;function Kf(e,t){return t[1]!==Hf?function(e,t,r){let n=0,i=0;switch(t=Math.abs(t),r=Math.abs(r),e){case "top-right":case "top-left":case "top":i=r-7;break;case "bottom-right":case "bottom-left":case "bottom":i=7-r;}switch(e){case "top-right":case "bottom-right":case "right":n=-t;break;case "top-left":case "bottom-left":case "left":n=t;}return [n,i]}(e,t[0],t[1]):function(e,t){let r=0,n=0;t<0&&(t=0);const i=t/Math.SQRT2;switch(e){case "top-right":case "top-left":n=i-7;break;case "bottom-right":case "bottom-left":n=7-i;break;case "bottom":n=7-t;break;case "top":n=t-7;}switch(e){case "top-right":case "bottom-right":r=-i;break;case "top-left":case "bottom-left":r=i;break;case "left":r=t;break;case "right":r=-t;}return [r,n]}(e,t[0])}function Wf(e,t,r){var n;const i=e.layout,s=null===(n=i.get("text-variable-anchor-offset"))||void 0===n?void 0:n.evaluate(t,{},r);if(s){const e=s.values,t=[];for(let r=0;r<e.length;r+=2){const n=t[r]=e[r],i=e[r+1].map((e=>e*lc));n.startsWith("top")?i[1]-=7:n.startsWith("bottom")&&(i[1]+=7),t[r+1]=i;}return new Ct(t)}const o=i.get("text-variable-anchor");if(o){let n;n=void 0!==e._unevaluatedLayout.getValue("text-radial-offset")?[i.get("text-radial-offset").evaluate(t,{},r)*lc,Hf]:i.get("text-offset").evaluate(t,{},r).map((e=>e*lc));const s=[];for(const e of o)s.push(e,Kf(e,n));return new Ct(s)}return null}function Jf(e){switch(e){case "right":case "top-right":case "bottom-right":return "right";case "left":case "top-left":case "bottom-left":return "left"}return "center"}function Qf(t,r,n,i,s,o,a,l,u,c,h,p){let f=o.textMaxSize.evaluate(r,{});void 0===f&&(f=a);const d=t.layers[0].layout,y=d.get("icon-offset").evaluate(r,{},h),m=td(n.horizontal),g=a/24,x=t.tilePixelRatio*g,v=t.tilePixelRatio*f/24,b=t.tilePixelRatio*l,w=t.tilePixelRatio*d.get("symbol-spacing"),_=d.get("text-padding")*t.tilePixelRatio,S=function(e,t,r,n=1){const i=e.get("icon-padding").evaluate(t,{},r),s=i&&i.values;return [s[0]*n,s[1]*n,s[2]*n,s[3]*n]}(d,r,h,t.tilePixelRatio),A=d.get("text-max-angle")/180*Math.PI,T="viewport"!==d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),I="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),E=d.get("symbol-placement"),M=w/2,F=d.get("icon-text-fit");let D;i&&"none"!==F&&(t.allowVerticalPlacement&&n.vertical&&(D=Kc(i,n.vertical,F,d.get("icon-text-fit-padding"),y,g)),m&&(i=Kc(i,m,F,d.get("icon-text-fit-padding"),y,g)));const P=h?p.line.getGranularityForZoomLevel(h.z):1,B=(l,p)=>{p.x<0||p.x>=k||p.y<0||p.y>=k||function(t,r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v,b,w,_,S,A,T){const I=t.addToLineVertexArray(r,n);let E,M,k,F,D=0,P=0,B=0,z=0,V=-1,C=-1;const L={};let O=pa("");if(t.allowVerticalPlacement&&i.vertical){const e=l.layout.get("text-rotate").evaluate(w,{},A)+90;k=new qf(u,r,c,h,p,i.vertical,f,d,y,e),a&&(F=new qf(u,r,c,h,p,a,g,x,y,e));}if(s){const n=l.layout.get("icon-rotate").evaluate(w,{}),i="none"!==l.layout.get("icon-text-fit"),o=Of(s,n,S,i),f=a?Of(a,n,S,i):void 0;M=new qf(u,r,c,h,p,s,g,x,!1,n),D=4*o.length;const d=t.iconSizeData;let y=null;"source"===d.kind?(y=[Wc*l.layout.get("icon-size").evaluate(w,{})],y[0]>Jc&&j(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(y=[Wc*_.compositeIconSizes[0].evaluate(w,{},A),Wc*_.compositeIconSizes[1].evaluate(w,{},A)],(y[0]>Jc||y[1]>Jc)&&j(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,o,y,b,v,w,e.ay.none,r,I.lineStartIndex,I.lineLength,-1,A),V=t.icon.placedSymbolArray.length-1,f&&(P=4*f.length,t.addSymbols(t.icon,f,y,b,v,w,e.ay.vertical,r,I.lineStartIndex,I.lineLength,-1,A),C=t.icon.placedSymbolArray.length-1);}const R=Object.keys(i.horizontal);for(const n of R){const s=i.horizontal[n];if(!E){O=pa(s.text);const e=l.layout.get("text-rotate").evaluate(w,{},A);E=new qf(u,r,c,h,p,s,f,d,y,e);}const a=1===s.positionedLines.length;if(B+=ed(t,r,s,o,l,y,w,m,I,i.vertical?e.ay.horizontal:e.ay.horizontalOnly,a?R:[n],L,V,_,A),a)break}i.vertical&&(z+=ed(t,r,i.vertical,o,l,y,w,m,I,e.ay.vertical,["vertical"],L,C,_,A));const N=E?E.boxStartIndex:t.collisionBoxArray.length,$=E?E.boxEndIndex:t.collisionBoxArray.length,U=k?k.boxStartIndex:t.collisionBoxArray.length,q=k?k.boxEndIndex:t.collisionBoxArray.length,G=M?M.boxStartIndex:t.collisionBoxArray.length,X=M?M.boxEndIndex:t.collisionBoxArray.length,Y=F?F.boxStartIndex:t.collisionBoxArray.length,Z=F?F.boxEndIndex:t.collisionBoxArray.length;let H=-1;const K=(e,t)=>e&&e.circleDiameter?Math.max(e.circleDiameter,t):t;H=K(E,H),H=K(k,H),H=K(M,H),H=K(F,H);const W=H>-1?1:0;W&&(H*=T/lc),t.glyphOffsetArray.length>=ah.MAX_GLYPHS&&j("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==w.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,w.sortKey);const J=Wf(l,w,A),[Q,ee]=function(t,r){const n=t.length,i=null==r?void 0:r.values;if((null==i?void 0:i.length)>0)for(let r=0;r<i.length;r+=2){const n=i[r+1];t.emplaceBack(e.aO[i[r]],n[0],n[1]);}return [n,t.length]}(t.textAnchorOffsets,J);t.symbolInstances.emplaceBack(r.x,r.y,L.right>=0?L.right:-1,L.center>=0?L.center:-1,L.left>=0?L.left:-1,L.vertical||-1,V,C,O,N,$,U,q,G,X,Y,Z,c,B,z,D,P,W,0,f,H,Q,ee);}(t,p,l,n,i,s,D,t.layers[0],t.collisionBoxArray,r.index,r.sourceLayerIndex,t.index,x,[_,_,_,_],T,u,b,S,I,y,r,o,c,h,a);};if("line"===E)for(const e of Af(r.geometry,0,0,k,k)){const r=pu(e,P),s=Cf(r,w,A,n.vertical||m,i,24,v,t.overscaling,k);for(const e of s)m&&rd(t,m.text,M,e)||B(r,e);}else if("line-center"===E){for(const e of r.geometry)if(e.length>1){const t=pu(e,P),r=Vf(t,A,n.vertical||m,i,24,v);r&&B(t,r);}}else if("Polygon"===r.type)for(const e of Qr(r.geometry,0)){const t=Gf(e,16);B(pu(e[0],P,!0),new Ff(t.x,t.y,0));}else if("LineString"===r.type)for(const e of r.geometry){const t=pu(e,P);B(t,new Ff(t[0].x,t[0].y,0));}else if("Point"===r.type)for(const e of r.geometry)for(const t of e)B([t],new Ff(t.x,t.y,0));}function ed(e,t,n,i,s,o,a,l,u,c,h,p,f,d,y){const m=function(e,t,n,i,s,o,a,l){const u=i.layout.get("text-rotate").evaluate(o,{})*Math.PI/180,c=[];for(const e of t.positionedLines)for(const i of e.positionedGlyphs){if(!i.rect)continue;const o=i.rect||{};let h=4,p=!0,f=1,d=0;const y=(s||l)&&i.vertical,m=i.metrics.advance*i.scale/2;if(l&&t.verticalizable&&(d=e.lineOffset/2-(i.imageName?-(lc-i.metrics.width*i.scale)/2:(i.scale-1)*lc)),i.imageName){const e=a[i.imageName];p=e.sdf,f=e.pixelRatio,h=1/f;}const g=s?[i.x+m,i.y]:[0,0];let x=s?[0,0]:[i.x+m+n[0],i.y+n[1]-d],v=[0,0];y&&(v=x,x=[0,0]);const b=i.metrics.isDoubleResolution?2:1,w=(i.metrics.left-h)*i.scale-m+x[0],_=(-i.metrics.top-h)*i.scale+x[1],S=w+o.w/b*i.scale/f,A=_+o.h/b*i.scale/f,T=new r(w,_),I=new r(S,_),E=new r(w,A),M=new r(S,A);if(y){const e=new r(-m,m- -17),t=-Math.PI/2,n=12-m,s=new r(22-n,-(i.imageName?n:0)),o=new r(...v);T._rotateAround(t,e)._add(s)._add(o),I._rotateAround(t,e)._add(s)._add(o),E._rotateAround(t,e)._add(s)._add(o),M._rotateAround(t,e)._add(s)._add(o);}if(u){const e=Math.sin(u),t=Math.cos(u),r=[t,-e,e,t];T._matMult(r),I._matMult(r),E._matMult(r),M._matMult(r);}const k=new r(0,0),F=new r(0,0);c.push({tl:T,tr:I,bl:E,br:M,tex:o,writingMode:t.writingMode,glyphOffset:g,sectionIndex:i.sectionIndex,isSDF:p,pixelOffsetTL:k,pixelOffsetBR:F,minFontScaleX:0,minFontScaleY:0});}return c}(0,n,l,s,o,a,i,e.allowVerticalPlacement),g=e.textSizeData;let x=null;"source"===g.kind?(x=[Wc*s.layout.get("text-size").evaluate(a,{})],x[0]>Jc&&j(`${e.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[Wc*d.compositeTextSizes[0].evaluate(a,{},y),Wc*d.compositeTextSizes[1].evaluate(a,{},y)],(x[0]>Jc||x[1]>Jc)&&j(`${e.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),e.addSymbols(e.text,m,x,l,o,a,c,t,u.lineStartIndex,u.lineLength,f,y);for(const t of h)p[t]=e.text.placedSymbolArray.length-1;return 4*m.length}function td(e){for(const t in e)return e[t];return null}function rd(e,t,r,n){const i=e.compareText;if(t in i){const e=i[t];for(let t=e.length-1;t>=0;t--)if(n.dist(e[t])<r)return !0}else i[t]=[];return i[t].push(n),!1}const nd=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class id{static from(e){if(!(e instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[t,r]=new Uint8Array(e,0,2);if(219!==t)throw new Error("Data does not appear to be in a KDBush format.");const n=r>>4;if(1!==n)throw new Error(`Got v${n} data when expected v1.`);const i=nd[15&r];if(!i)throw new Error("Unrecognized array type.");const[s]=new Uint16Array(e,2,1),[o]=new Uint32Array(e,4,1);return new id(o,s,i,e)}constructor(e,t=64,r=Float64Array,n){if(isNaN(e)||e<0)throw new Error(`Unpexpected numItems value: ${e}.`);this.numItems=+e,this.nodeSize=Math.min(Math.max(+t,2),65535),this.ArrayType=r,this.IndexArrayType=e<65536?Uint16Array:Uint32Array;const i=nd.indexOf(this.ArrayType),s=2*e*this.ArrayType.BYTES_PER_ELEMENT,o=e*this.IndexArrayType.BYTES_PER_ELEMENT,a=(8-o%8)%8;if(i<0)throw new Error(`Unexpected typed array class: ${r}.`);n&&n instanceof ArrayBuffer?(this.data=n,this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+o+a,2*e),this._pos=2*e,this._finished=!0):(this.data=new ArrayBuffer(8+s+o+a),this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+o+a,2*e),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+i]),new Uint16Array(this.data,2,1)[0]=t,new Uint32Array(this.data,4,1)[0]=e);}add(e,t){const r=this._pos>>1;return this.ids[r]=r,this.coords[this._pos++]=e,this.coords[this._pos++]=t,r}finish(){const e=this._pos>>1;if(e!==this.numItems)throw new Error(`Added ${e} items when expected ${this.numItems}.`);return sd(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(e,t,r,n){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:i,coords:s,nodeSize:o}=this,a=[0,i.length-1,0],l=[];for(;a.length;){const u=a.pop()||0,c=a.pop()||0,h=a.pop()||0;if(c-h<=o){for(let o=h;o<=c;o++){const a=s[2*o],u=s[2*o+1];a>=e&&a<=r&&u>=t&&u<=n&&l.push(i[o]);}continue}const p=h+c>>1,f=s[2*p],d=s[2*p+1];f>=e&&f<=r&&d>=t&&d<=n&&l.push(i[p]),(0===u?e<=f:t<=d)&&(a.push(h),a.push(p-1),a.push(1-u)),(0===u?r>=f:n>=d)&&(a.push(p+1),a.push(c),a.push(1-u));}return l}within(e,t,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:i,nodeSize:s}=this,o=[0,n.length-1,0],a=[],l=r*r;for(;o.length;){const u=o.pop()||0,c=o.pop()||0,h=o.pop()||0;if(c-h<=s){for(let r=h;r<=c;r++)ud(i[2*r],i[2*r+1],e,t)<=l&&a.push(n[r]);continue}const p=h+c>>1,f=i[2*p],d=i[2*p+1];ud(f,d,e,t)<=l&&a.push(n[p]),(0===u?e-r<=f:t-r<=d)&&(o.push(h),o.push(p-1),o.push(1-u)),(0===u?e+r>=f:t+r>=d)&&(o.push(p+1),o.push(c),o.push(1-u));}return a}}function sd(e,t,r,n,i,s){if(i-n<=r)return;const o=n+i>>1;od(e,t,o,n,i,s),sd(e,t,r,n,o-1,1-s),sd(e,t,r,o+1,i,1-s);}function od(e,t,r,n,i,s){for(;i>n;){if(i-n>600){const o=i-n+1,a=r-n+1,l=Math.log(o),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(o-u)/o)*(a-o/2<0?-1:1);od(e,t,r,Math.max(n,Math.floor(r-a*u/o+c)),Math.min(i,Math.floor(r+(o-a)*u/o+c)),s);}const o=t[2*r+s];let a=n,l=i;for(ad(e,t,n,r),t[2*i+s]>o&&ad(e,t,n,i);a<l;){for(ad(e,t,a,l),a++,l--;t[2*a+s]<o;)a++;for(;t[2*l+s]>o;)l--;}t[2*n+s]===o?ad(e,t,n,l):(l++,ad(e,t,l,i)),l<=r&&(n=l+1),r<=l&&(i=l-1);}}function ad(e,t,r,n){ld(e,r,n),ld(t,2*r,2*n),ld(t,2*r+1,2*n+1);}function ld(e,t,r){const n=e[t];e[t]=e[r],e[r]=n;}function ud(e,t,r,n){const i=e-r,s=t-n;return i*i+s*s}var cd;e.cG=void 0,(cd=e.cG||(e.cG={})).create="create",cd.load="load",cd.fullLoad="fullLoad";let hd=null,pd=[];const fd=1e3/60,dd="loadTime",yd="fullLoadTime",md={mark(e){performance.mark(e);},frame(e){const t=e;null!=hd&&pd.push(t-hd),hd=t;},clearMetrics(){hd=null,pd=[],performance.clearMeasures(dd),performance.clearMeasures(yd);for(const t in e.cG)performance.clearMarks(e.cG[t]);},getPerformanceMetrics(){performance.measure(dd,e.cG.create,e.cG.load),performance.measure(yd,e.cG.create,e.cG.fullLoad);const t=performance.getEntriesByName(dd)[0].duration,r=performance.getEntriesByName(yd)[0].duration,n=pd.length,i=1/(pd.reduce(((e,t)=>e+t),0)/n/1e3),s=pd.filter((e=>e>fd)).reduce(((e,t)=>e+(t-fd)/fd),0);return {loadTime:t,fullLoadTime:r,fps:i,percentDroppedFrames:s/(n+s)*100,totalFrames:n}}};e.$=h,e.A=f,e.B=ss,e.C=es,e.D=Ns,e.E=ge,e.F=function([e,t,r]){return t+=90,t*=Math.PI/180,r*=Math.PI/180,{x:e*Math.cos(t)*Math.sin(r),y:e*Math.sin(t)*Math.sin(r),z:e*Math.cos(r)}},e.G=dr,e.H=ks,e.I=Lc,e.J=rs,e.K=function(e){if(null==Y){const t=e.navigator?e.navigator.userAgent:null;Y=!!e.safari||!(!t||!(/\b(iPad|iPhone|iPod)\b/.test(t)||t.match("Safari")&&!t.match("Chrome")));}return Y},e.L=class{constructor(e,t){this.target=e,this.mapId=t,this.resolveRejects={},this.tasks={},this.taskQueue=[],this.abortControllers={},this.messageHandlers={},this.invoker=new gh((()=>this.process())),this.subscription=Q(this.target,"message",(e=>this.receive(e)),!1),this.globalScope=X(self)?e:window;}registerMessageHandler(e,t){this.messageHandlers[e]=t;}unregisterMessageHandler(e){delete this.messageHandlers[e];}sendAsync(e,t){return new Promise(((r,n)=>{const i=Math.round(1e18*Math.random()).toString(36).substring(0,10),s=t?Q(t.signal,"abort",(()=>{null==s||s.unsubscribe(),delete this.resolveRejects[i];const t={id:i,type:"<cancel>",origin:location.origin,targetMapId:e.targetMapId,sourceMapId:this.mapId};this.target.postMessage(t);}),xh):null;this.resolveRejects[i]={resolve:e=>{null==s||s.unsubscribe(),r(e);},reject:e=>{null==s||s.unsubscribe(),n(e);}};const o=[],a=Object.assign(Object.assign({},e),{id:i,sourceMapId:this.mapId,origin:location.origin,data:ps(e.data,o)});this.target.postMessage(a,{transfer:o});}))}receive(e){const t=e.data,r=t.id;if(!("file://"!==t.origin&&"file://"!==location.origin&&"resource://android"!==t.origin&&"resource://android"!==location.origin&&t.origin!==location.origin||t.targetMapId&&this.mapId!==t.targetMapId)){if("<cancel>"===t.type){delete this.tasks[r];const e=this.abortControllers[r];return delete this.abortControllers[r],void(e&&e.abort())}if(X(self)||t.mustQueue)return this.tasks[r]=t,this.taskQueue.push(r),void this.invoker.trigger();this.processTask(r,t);}}process(){if(0===this.taskQueue.length)return;const e=this.taskQueue.shift(),t=this.tasks[e];delete this.tasks[e],this.taskQueue.length>0&&this.invoker.trigger(),t&&this.processTask(e,t);}processTask(e,r){return t(this,void 0,void 0,(function*(){if("<response>"===r.type){const t=this.resolveRejects[e];if(delete this.resolveRejects[e],!t)return;return void(r.error?t.reject(fs(r.error)):t.resolve(fs(r.data)))}if(!this.messageHandlers[r.type])return void this.completeTask(e,new Error(`Could not find a registered handler for ${r.type}, map ID: ${this.mapId}, available handlers: ${Object.keys(this.messageHandlers).join(", ")}`));const t=fs(r.data),n=new AbortController;this.abortControllers[e]=n;try{const i=yield this.messageHandlers[r.type](r.sourceMapId,t,n);this.completeTask(e,null,i);}catch(t){this.completeTask(e,t);}}))}completeTask(e,t,r){const n=[];delete this.abortControllers[e];const i={id:e,type:"<response>",sourceMapId:this.mapId,origin:location.origin,error:t?ps(t):null,data:ps(r,n)};this.target.postMessage(i,{transfer:n});}remove(){this.invoker.remove(),this.subscription.unsubscribe();}},e.M=le,e.N=function(){var e=new f(16);return f!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0),e[0]=1,e[5]=1,e[10]=1,e[15]=1,e},e.O=function(e,t,r){var n,i,s,o,a,l,u,c,h,p,f,d,y=r[0],m=r[1],g=r[2];return t===e?(e[12]=t[0]*y+t[4]*m+t[8]*g+t[12],e[13]=t[1]*y+t[5]*m+t[9]*g+t[13],e[14]=t[2]*y+t[6]*m+t[10]*g+t[14],e[15]=t[3]*y+t[7]*m+t[11]*g+t[15]):(i=t[1],s=t[2],o=t[3],a=t[4],l=t[5],u=t[6],c=t[7],h=t[8],p=t[9],f=t[10],d=t[11],e[0]=n=t[0],e[1]=i,e[2]=s,e[3]=o,e[4]=a,e[5]=l,e[6]=u,e[7]=c,e[8]=h,e[9]=p,e[10]=f,e[11]=d,e[12]=n*y+a*m+h*g+t[12],e[13]=i*y+l*m+p*g+t[13],e[14]=s*y+u*m+f*g+t[14],e[15]=o*y+c*m+d*g+t[15]),e},e.P=r,e.Q=function(e,t,r){var n=r[0],i=r[1],s=r[2];return e[0]=t[0]*n,e[1]=t[1]*n,e[2]=t[2]*n,e[3]=t[3]*n,e[4]=t[4]*i,e[5]=t[5]*i,e[6]=t[6]*i,e[7]=t[7]*i,e[8]=t[8]*s,e[9]=t[9]*s,e[10]=t[10]*s,e[11]=t[11]*s,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},e.R=xl,e.S=function(e,t,r){var n=t[0],i=t[1],s=t[2],o=t[3],a=t[4],l=t[5],u=t[6],c=t[7],h=t[8],p=t[9],f=t[10],d=t[11],y=t[12],m=t[13],g=t[14],x=t[15],v=r[0],b=r[1],w=r[2],_=r[3];return e[0]=v*n+b*a+w*h+_*y,e[1]=v*i+b*l+w*p+_*m,e[2]=v*s+b*u+w*f+_*g,e[3]=v*o+b*c+w*d+_*x,e[4]=(v=r[4])*n+(b=r[5])*a+(w=r[6])*h+(_=r[7])*y,e[5]=v*i+b*l+w*p+_*m,e[6]=v*s+b*u+w*f+_*g,e[7]=v*o+b*c+w*d+_*x,e[8]=(v=r[8])*n+(b=r[9])*a+(w=r[10])*h+(_=r[11])*y,e[9]=v*i+b*l+w*p+_*m,e[10]=v*s+b*u+w*f+_*g,e[11]=v*o+b*c+w*d+_*x,e[12]=(v=r[12])*n+(b=r[13])*a+(w=r[14])*h+(_=r[15])*y,e[13]=v*i+b*l+w*p+_*m,e[14]=v*s+b*u+w*f+_*g,e[15]=v*o+b*c+w*d+_*x,e},e.T=El,e.U=function(e,t){const r={};for(let n=0;n<t.length;n++){const i=t[n];i in e&&(r[i]=e[i]);}return r},e.V=bh,e.W=L,e.X=Ah,e.Y=Sh,e.Z=c,e._=t,e.a=oe,e.a$=v,e.a0=K,e.a1=Bh,e.a2=Ih,e.a3=Eh,e.a4=k,e.a5=function(e,t,r){if(!e)return t||{};if(!t)return e||{};const n=Lh(e),i=Lh(t);!function(e,t){t.removeAll&&(e.add.clear(),e.update.clear(),e.remove.clear(),t.remove.clear());for(const r of t.remove)e.add.delete(r),e.update.delete(r);for(const[r,n]of t.update){const i=e.update.get(r);i&&(t.update.set(r,Ch(i,n)),e.update.delete(r));}}(n,i);const s={};if((n.removeAll||i.removeAll)&&(s.removeAll=!0),s.remove=new Set([...n.remove,...i.remove]),s.add=new Map([...n.add,...i.add]),s.update=new Map([...n.update,...i.update]),s.remove.size&&s.add.size)for(const e of s.add.keys())s.remove.delete(e);return function(e){const t={};return e.removeAll&&(t.removeAll=e.removeAll),e.remove&&(t.remove=Array.from(e.remove)),e.add&&(t.add=Array.from(e.add.values())),e.update&&(t.update=Array.from(e.update.values())),t}(s)},e.a6=function(e,t){if(null==e)return !0;if("Feature"===e.type)return null!=Vh(e,t);if("FeatureCollection"===e.type){const r=new Set;for(const n of e.features){const e=Vh(n,t);if(null==e)return !1;if(r.has(e))return !1;r.add(e);}return !0}return !1},e.a7=function(e,t){const r=new Map;if(null==e);else if("Feature"===e.type)r.set(Vh(e,t),e);else for(const n of e.features)r.set(Vh(n,t),n);return r},e.a8=function(e,t,r){var n,i;if(t.removeAll)e.clear();else if(t.remove)for(const r of t.remove)e.delete(r);if(t.add)for(const n of t.add){const t=Vh(n,r);null!=t&&e.set(t,n);}if(t.update)for(const r of t.update){let t=e.get(r.id);if(!t)continue;const s=!!r.newGeometry,o=r.removeAllProperties||(null===(n=r.removeProperties)||void 0===n?void 0:n.length)>0||(null===(i=r.addOrUpdateProperties)||void 0===i?void 0:i.length)>0;if((s||o)&&(t=Object.assign({},t),e.set(r.id,t),s&&(t.geometry=r.newGeometry),o)){if(t.properties=r.removeAllProperties?{}:Object.assign({},t.properties||{}),r.removeProperties)for(const e of r.removeProperties)delete t.properties[e];if(r.addOrUpdateProperties)for(const{key:e,value:n}of r.addOrUpdateProperties)t.properties[e]=n;}}},e.a9=bf,e.aA=function(e,t){var r=t[0],n=t[1],i=t[2],s=t[3],o=t[4],a=t[5],l=t[6],u=t[7],c=t[8],h=t[9],p=t[10],f=t[11],d=t[12],y=t[13],m=t[14],g=t[15],x=r*a-n*o,v=r*l-i*o,b=r*u-s*o,w=n*l-i*a,_=n*u-s*a,S=i*u-s*l,A=c*y-h*d,T=c*m-p*d,I=c*g-f*d,E=h*m-p*y,M=h*g-f*y,k=p*g-f*m,F=x*k-v*M+b*E+w*I-_*T+S*A;return F?(e[0]=(a*k-l*M+u*E)*(F=1/F),e[1]=(i*M-n*k-s*E)*F,e[2]=(y*S-m*_+g*w)*F,e[3]=(p*_-h*S-f*w)*F,e[4]=(l*I-o*k-u*T)*F,e[5]=(r*k-i*I+s*T)*F,e[6]=(m*b-d*S-g*v)*F,e[7]=(c*S-p*b+f*v)*F,e[8]=(o*M-a*I+u*A)*F,e[9]=(n*I-r*M-s*A)*F,e[10]=(d*_-y*b+g*x)*F,e[11]=(h*b-c*_-f*x)*F,e[12]=(a*T-o*E-l*A)*F,e[13]=(r*E-n*T+i*A)*F,e[14]=(y*v-d*w-m*x)*F,e[15]=(c*w-h*v+p*x)*F,e):null},e.aB=E,e.aC=function(e){var t=e[0],r=e[1];return Math.sqrt(t*t+r*r)},e.aD=function(e){return e[0]=0,e[1]=0,e},e.aE=function(e,t,r){return e[0]=t[0]*r,e[1]=t[1]*r,e},e.aF=nh,e.aG=A,e.aH=function(e,t,n,i){const s=t.y-e.y,o=t.x-e.x,a=i.y-n.y,l=i.x-n.x,u=a*o-l*s;if(0===u)return null;const c=(l*(e.y-n.y)-a*(e.x-n.x))/u;return new r(e.x+c*o,e.y+c*s)},e.aI=Af,e.aJ=$a,e.aK=function(e){let t=1/0,r=1/0,n=-1/0,i=-1/0;for(const s of e)t=Math.min(t,s.x),r=Math.min(r,s.y),n=Math.max(n,s.x),i=Math.max(i,s.y);return [t,r,n,i]},e.aL=lc,e.aM=F,e.aN=function(e,t,r,n,i=!1){if(!r[0]&&!r[1])return [0,0];const s=i?"map"===n?-e.bearingInRadians:0:"viewport"===n?e.bearingInRadians:0;if(s){const e=Math.sin(s),t=Math.cos(s);r=[r[0]*t-r[1]*e,r[0]*e+r[1]*t];}return [i?r[0]:F(t,r[0],e.zoom),i?r[1]:F(t,r[1],e.zoom)]},e.aP=eh,e.aQ=Jf,e.aR=$c,e.aS=id,e.aT=Qs,e.aU=au,e.aV=Oo,e.aW=ta,e.aX=Wo,e.aY=te,e.aZ=Mh,e.a_=b,e.aa=kh,e.ab=vf,e.ac=25,e.ad=Dh,e.ae=e=>{const t=window.document.createElement("video");return t.muted=!0,new Promise((r=>{t.onloadstart=()=>{r(t);};for(const r of e){const e=window.document.createElement("source");pe(r)||(t.crossOrigin="Anonymous"),e.src=r,t.appendChild(e);}}))},e.af=Fe,e.ag=function(){return R++},e.ah=Eo,e.ai=ah,e.aj=pi,e.ak=La,e.al=Rh,e.am=function(e){const t={};if(e.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((e,r,n,i)=>{const s=n||i;return t[r]=!s||s.toLowerCase(),""})),t["max-age"]){const e=parseInt(t["max-age"],10);isNaN(e)?delete t["max-age"]:t["max-age"]=e;}return t},e.an=C,e.ao=85.051129,e.ap=ee,e.aq=function(e){return Math.pow(2,e)},e.ar=y,e.as=Th,e.at=function(e){return Math.log(e)/Math.LN2},e.au=function(e){var t=e[0],r=e[1];return t*t+r*r},e.av=class{constructor(e,t){this.max=e,this.onRemove=t,this.reset();}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,r){const n=e.wrapped().key;void 0===this.data[n]&&(this.data[n]=[]);const i={value:t,timeout:void 0};if(void 0!==r&&(i.timeout=setTimeout((()=>{this.remove(e,i);}),r)),this.data[n].push(i),this.order.push(n),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const r=e.wrapped().key,n=void 0===t?0:this.data[r].indexOf(t),i=this.data[r][n];return this.data[r].splice(n,1),i.timeout&&clearTimeout(i.timeout),0===this.data[r].length&&delete this.data[r],this.onRemove(i.value),this.order.splice(this.order.indexOf(r),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e);}return this}filter(e){const t=[];for(const r in this.data)for(const n of this.data[r])e(n.value)||t.push(n);for(const e of t)this.remove(e.value.tileID,e);}},e.aw=function(e){if(!e.length)return new Set;const t=Math.max(...e.map((e=>e.canonical.z)));let r=1/0,n=-1/0,i=1/0,s=-1/0;const o=[];for(const a of e){const{x:e,y:l,z:u}=a.canonical,c=Math.pow(2,t-u),h=e*c,p=l*c;o.push({id:a,x:h,y:p}),h<r&&(r=h),h>n&&(n=h),p<i&&(i=p),p>s&&(s=p);}const a=new Set;for(const e of o)e.x!==r&&e.x!==n&&e.y!==i&&e.y!==s||a.add(e.id);return a},e.ax=function(e,t){let r=0,n=0;if("constant"===e.kind)n=e.layoutSize;else if("source"!==e.kind){const{interpolationType:i,minZoom:s,maxZoom:o}=e,a=i?C(pr.interpolationFactor(i,t,s,o),0,1):0;"camera"===e.kind?n=dr.number(e.minSize,e.maxSize,a):r=a;}return {uSizeT:r,uSize:n}},e.az=function(e,{uSize:t,uSizeT:r},{lowerSize:n,upperSize:i}){return "source"===e.kind?n/Wc:"composite"===e.kind?dr.number(n/Wc,i/Wc,r):t},e.b=Z,e.b$=class extends ga{constructor(e,t){super(e,t),this.current=wa;}set(e){if(e[12]!==this.current[12]||e[0]!==this.current[0])return this.current=e,void this.gl.uniformMatrix4fv(this.location,!1,e);for(let t=1;t<16;t++)if(e[t]!==this.current[t]){this.current=e,this.gl.uniformMatrix4fv(this.location,!1,e);break}}},e.b0=function(e){var t=new f(3);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t},e.b1=function(e,t,r){return e[0]=t[0]-r[0],e[1]=t[1]-r[1],e[2]=t[2]-r[2],e},e.b2=function(e,t){var r=t[0],n=t[1],i=t[2],s=r*r+n*n+i*i;return s>0&&(s=1/Math.sqrt(s)),e[0]=t[0]*s,e[1]=t[1]*s,e[2]=t[2]*s,e},e.b3=w,e.b4=function(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]},e.b5=function(e,t,r){return e[0]=t[0]*r[0],e[1]=t[1]*r[1],e[2]=t[2]*r[2],e[3]=t[3]*r[3],e},e.b6=g,e.b7=function(e,t,r){const n=t[0]*r[0]+t[1]*r[1]+t[2]*r[2];return 0===n?null:(-(e[0]*r[0]+e[1]*r[1]+e[2]*r[2])-r[3])/n},e.b8=S,e.b9=function(e,t,r){return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e[3]=t[3]*r,e},e.bA=I,e.bB=function(e,t,r){var n=r[0],i=r[1],s=r[2],o=r[3],a=t[0],l=t[1],u=t[2],c=i*u-s*l,h=s*a-n*u,p=n*l-i*a;return e[0]=a+o*(c+=c)+i*(p+=p)-s*(h+=h),e[1]=l+o*h+s*c-n*p,e[2]=u+o*p+n*h-i*c,e},e.bC=function(e,t,r){const n=(i=[e[0],e[1],e[2],t[0],t[1],t[2],r[0],r[1],r[2]])[0]*((c=i[8])*(o=i[4])-(a=i[5])*(u=i[7]))+i[1]*(-c*(s=i[3])+a*(l=i[6]))+i[2]*(u*s-o*l);var i,s,o,a,l,u,c;if(0===n)return null;const h=w([],[t[0],t[1],t[2]],[r[0],r[1],r[2]]),p=w([],[r[0],r[1],r[2]],[e[0],e[1],e[2]]),f=w([],[e[0],e[1],e[2]],[t[0],t[1],t[2]]),d=b([],h,-e[3]);return v(d,d,b([],p,-t[3])),v(d,d,b([],f,-r[3])),b(d,d,1/n),d},e.bD=vh,e.bE=function(){return new Float64Array(4)},e.bF=function(e,t,r,n){var i=[],s=[];return i[0]=t[0]-r[0],i[1]=t[1]-r[1],i[2]=t[2]-r[2],s[0]=i[0]*Math.cos(n)-i[1]*Math.sin(n),s[1]=i[0]*Math.sin(n)+i[1]*Math.cos(n),s[2]=i[2],e[0]=s[0]+r[0],e[1]=s[1]+r[1],e[2]=s[2]+r[2],e},e.bG=function(e,t,r,n){var i=[],s=[];return i[0]=t[0]-r[0],i[1]=t[1]-r[1],i[2]=t[2]-r[2],s[0]=i[0],s[1]=i[1]*Math.cos(n)-i[2]*Math.sin(n),s[2]=i[1]*Math.sin(n)+i[2]*Math.cos(n),e[0]=s[0]+r[0],e[1]=s[1]+r[1],e[2]=s[2]+r[2],e},e.bH=function(e,t,r,n){var i=[],s=[];return i[0]=t[0]-r[0],i[1]=t[1]-r[1],i[2]=t[2]-r[2],s[0]=i[2]*Math.sin(n)+i[0]*Math.cos(n),s[1]=i[1],s[2]=i[2]*Math.cos(n)-i[0]*Math.sin(n),e[0]=s[0]+r[0],e[1]=s[1]+r[1],e[2]=s[2]+r[2],e},e.bI=function(e,t,r){var n=Math.sin(r),i=Math.cos(r),s=t[0],o=t[1],a=t[2],l=t[3],u=t[8],c=t[9],h=t[10],p=t[11];return t!==e&&(e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[0]=s*i-u*n,e[1]=o*i-c*n,e[2]=a*i-h*n,e[3]=l*i-p*n,e[8]=s*n+u*i,e[9]=o*n+c*i,e[10]=a*n+h*i,e[11]=l*n+p*i,e},e.bJ=function(e,t){const r=D(e,360),n=D(t,360),i=n-r,s=n>r?i-360:i+360;return Math.abs(i)<Math.abs(s)?i:s},e.bK=function(e){return e[0]=0,e[1]=0,e[2]=0,e},e.bL=function(e,t,r,n){const i=Math.sqrt(e*e+t*t),s=Math.sqrt(r*r+n*n);e/=i,t/=i,r/=s,n/=s;const o=Math.acos(e*r+t*n);return -t*r+e*n>0?o:-o},e.bM=function(e,t){const r=D(e,2*Math.PI),n=D(t,2*Math.PI);return Math.min(Math.abs(r-n),Math.abs(r-n+2*Math.PI),Math.abs(r-n-2*Math.PI))},e.bN=function(){const e={},t=xe.$version;for(const r in xe.$root){const n=xe.$root[r];if(n.required){let i=null;i="version"===r?t:"array"===n.type?[]:{},null!=i&&(e[r]=i);}}return e},e.bO=ce,e.bP=ds,e.bQ=function e(t,r){if(Array.isArray(t)){if(!Array.isArray(r)||t.length!==r.length)return !1;for(let n=0;n<t.length;n++)if(!e(t[n],r[n]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==r){if("object"!=typeof r)return !1;if(Object.keys(t).length!==Object.keys(r).length)return !1;for(const n in t)if(!e(t[n],r[n]))return !1;return !0}return t===r},e.bR=function(e){e=e.slice();const t=Object.create(null);for(let r=0;r<e.length;r++)t[e[r].id]=e[r];for(let r=0;r<e.length;r++)"ref"in e[r]&&(e[r]=be(e[r],t[e[r].ref]));return e},e.bS=function(e,t){if("custom"===e.type)return new mh(e,t);switch(e.type){case "background":return new yh(e,t);case "circle":return new cl(e,t);case "color-relief":return new Fl(e,t);case "fill":return new bu(e,t);case "fill-extrusion":return new Ru(e,t);case "heatmap":return new wl(e,t);case "hillshade":return new Al(e,t);case "line":return new ec(e,t);case "raster":return new Hs(e,t);case "symbol":return new ph(e,t)}},e.bT=e=>"raster"===e.type,e.bU=U,e.bV=function(e,t){if(!e)return [{command:"setStyle",args:[t]}];let r=[];try{if(!we(e.version,t.version))return [{command:"setStyle",args:[t]}];we(e.center,t.center)||r.push({command:"setCenter",args:[t.center]}),we(e.state,t.state)||r.push({command:"setGlobalState",args:[t.state]}),we(e.centerAltitude,t.centerAltitude)||r.push({command:"setCenterAltitude",args:[t.centerAltitude]}),we(e.zoom,t.zoom)||r.push({command:"setZoom",args:[t.zoom]}),we(e.bearing,t.bearing)||r.push({command:"setBearing",args:[t.bearing]}),we(e.pitch,t.pitch)||r.push({command:"setPitch",args:[t.pitch]}),we(e.roll,t.roll)||r.push({command:"setRoll",args:[t.roll]}),we(e.sprite,t.sprite)||r.push({command:"setSprite",args:[t.sprite]}),we(e.glyphs,t.glyphs)||r.push({command:"setGlyphs",args:[t.glyphs]}),we(e.transition,t.transition)||r.push({command:"setTransition",args:[t.transition]}),we(e.light,t.light)||r.push({command:"setLight",args:[t.light]}),we(e.terrain,t.terrain)||r.push({command:"setTerrain",args:[t.terrain]}),we(e.sky,t.sky)||r.push({command:"setSky",args:[t.sky]}),we(e.projection,t.projection)||r.push({command:"setProjection",args:[t.projection]});const n={},i=[];!function(e,t,r,n){let i;for(i in t=t||{},e=e||{})Object.prototype.hasOwnProperty.call(e,i)&&(Object.prototype.hasOwnProperty.call(t,i)||Ae(i,r,n));for(i in t)Object.prototype.hasOwnProperty.call(t,i)&&(Object.prototype.hasOwnProperty.call(e,i)?we(e[i],t[i])||("geojson"===e[i].type&&"geojson"===t[i].type&&Ie(e,t,i)?_e(r,{command:"setGeoJSONSourceData",args:[i,t[i].data]}):Te(i,t,r,n)):Se(i,t,r));}(e.sources,t.sources,i,n);const s=[];e.layers&&e.layers.forEach((e=>{"source"in e&&n[e.source]?r.push({command:"removeLayer",args:[e.id]}):s.push(e);})),r=r.concat(i),function(e,t,r){t=t||[];const n=(e=e||[]).map(Me),i=t.map(Me),s=e.reduce(ke,{}),o=t.reduce(ke,{}),a=n.slice(),l=Object.create(null);let u,c,h,p,f;for(let e=0,t=0;e<n.length;e++)u=n[e],Object.prototype.hasOwnProperty.call(o,u)?t++:(_e(r,{command:"removeLayer",args:[u]}),a.splice(a.indexOf(u,t),1));for(let e=0,t=0;e<i.length;e++)u=i[i.length-1-e],a[a.length-1-e]!==u&&(Object.prototype.hasOwnProperty.call(s,u)?(_e(r,{command:"removeLayer",args:[u]}),a.splice(a.lastIndexOf(u,a.length-t),1)):t++,p=a[a.length-e],_e(r,{command:"addLayer",args:[o[u],p]}),a.splice(a.length-e,0,u),l[u]=!0);for(let e=0;e<i.length;e++)if(u=i[e],c=s[u],h=o[u],!l[u]&&!we(c,h))if(we(c.source,h.source)&&we(c["source-layer"],h["source-layer"])&&we(c.type,h.type)){for(f in Ee(c.layout,h.layout,r,u,null,"setLayoutProperty"),Ee(c.paint,h.paint,r,u,null,"setPaintProperty"),we(c.filter,h.filter)||_e(r,{command:"setFilter",args:[u,h.filter]}),we(c.minzoom,h.minzoom)&&we(c.maxzoom,h.maxzoom)||_e(r,{command:"setLayerZoomRange",args:[u,h.minzoom,h.maxzoom]}),c)Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Ee(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):we(c[f],h[f])||_e(r,{command:"setLayerProperty",args:[u,f,h[f]]}));for(f in h)Object.prototype.hasOwnProperty.call(h,f)&&!Object.prototype.hasOwnProperty.call(c,f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?Ee(c[f],h[f],r,u,f.slice(6),"setPaintProperty"):we(c[f],h[f])||_e(r,{command:"setLayerProperty",args:[u,f,h[f]]}));}else _e(r,{command:"removeLayer",args:[u]}),p=a[a.lastIndexOf(u)+1],_e(r,{command:"addLayer",args:[h,p]});}(s,t.layers,r);}catch(e){console.warn("Unable to compute style diff:",e),r=[{command:"setStyle",args:[t]}];}return r},e.bW=function(e){const t=[],r=e.id;return void 0===r&&t.push({message:`layers.${r}: missing required property "id"`}),void 0===e.render&&t.push({message:`layers.${r}: missing required method "render"`}),e.renderingMode&&"2d"!==e.renderingMode&&"3d"!==e.renderingMode&&t.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),t},e.bX=N,e.bY=$,e.bZ=class extends ga{constructor(e,t){super(e,t),this.current=0;}set(e){this.current!==e&&(this.current=e,this.gl.uniform1i(this.location,e));}},e.b_=ba,e.ba=function(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]},e.bb=Ph,e.bc=zh,e.bd=function(e,t,r,n,i){var s=1/Math.tan(t/2);if(e[0]=s/r,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=s,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=-1,e[12]=0,e[13]=0,e[15]=0,null!=i&&i!==1/0){var o=1/(n-i);e[10]=(i+n)*o,e[14]=2*i*n*o;}else e[10]=-1,e[14]=-2*n;return e},e.be=function(e){var t=new f(16);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},e.bf=function(e,t,r){var n=Math.sin(r),i=Math.cos(r),s=t[0],o=t[1],a=t[2],l=t[3],u=t[4],c=t[5],h=t[6],p=t[7];return t!==e&&(e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[0]=s*i+u*n,e[1]=o*i+c*n,e[2]=a*i+h*n,e[3]=l*i+p*n,e[4]=u*i-s*n,e[5]=c*i-o*n,e[6]=h*i-a*n,e[7]=p*i-l*n,e},e.bg=function(e,t,r){var n=Math.sin(r),i=Math.cos(r),s=t[4],o=t[5],a=t[6],l=t[7],u=t[8],c=t[9],h=t[10],p=t[11];return t!==e&&(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[4]=s*i+u*n,e[5]=o*i+c*n,e[6]=a*i+h*n,e[7]=l*i+p*n,e[8]=u*i-s*n,e[9]=c*i-o*n,e[10]=h*i-a*n,e[11]=p*i-l*n,e},e.bh=function(){const e=new Float32Array(16);return y(e),e},e.bi=function(){const e=new Float64Array(16);return y(e),e},e.bj=function(){return new Float64Array(16)},e.bk=function(e,t,r){const n=new Float64Array(4);return I(n,e,t-90,r),n},e.bl=function(e,t,r,n){var i,s,o,a,l,u=t[0],c=t[1],h=t[2],f=t[3],d=r[0],y=r[1],m=r[2],g=r[3];return (s=u*d+c*y+h*m+f*g)<0&&(s=-s,d=-d,y=-y,m=-m,g=-g),1-s>p?(i=Math.acos(s),o=Math.sin(i),a=Math.sin((1-n)*i)/o,l=Math.sin(n*i)/o):(a=1-n,l=n),e[0]=a*u+l*d,e[1]=a*c+l*y,e[2]=a*h+l*m,e[3]=a*f+l*g,e},e.bm=function(e){const t=new Float64Array(9);var r,n,i,s,o,a,l,u,c,h,p,f,d,y,m,g,x,v;h=(i=(n=e)[0])*(l=i+i),p=(s=n[1])*l,d=(o=n[2])*l,y=o*(u=s+s),g=(a=n[3])*l,x=a*u,v=a*(c=o+o),(r=t)[0]=1-(f=s*u)-(m=o*c),r[3]=p-v,r[6]=d+x,r[1]=p+v,r[4]=1-h-m,r[7]=y-g,r[2]=d-x,r[5]=y+g,r[8]=1-h-f;const b=te(-Math.asin(C(t[2],-1,1)));let w,_;return Math.hypot(t[5],t[8])<.001?(w=0,_=-te(Math.atan2(t[3],t[4]))):(w=te(0===t[5]&&0===t[8]?0:Math.atan2(t[5],t[8])),_=te(0===t[1]&&0===t[0]?0:Math.atan2(t[1],t[0]))),{roll:w,pitch:b+90,bearing:_}},e.bn=function(e,t){return e.roll==t.roll&&e.pitch==t.pitch&&e.bearing==t.bearing},e.bo=It,e.bp=xa,e.bq=lu,e.br=uu,e.bs=ou,e.bt=P,e.bu=B,e.bv=Ot,e.bw=function(e,t,r,n,i){return P(n,i,C((e-t)/(r-t),0,1))},e.bx=D,e.by=function(){return new Float64Array(3)},e.bz=function(e,t,r,n){return e[0]=t[0]+r[0]*n,e[1]=t[1]+r[1]*n,e[2]=t[2]+r[2]*n,e},e.c=se,e.c$=class{constructor(e){this._marks={start:[e.url,"start"].join("#"),end:[e.url,"end"].join("#"),measure:e.url.toString()},performance.mark(this._marks.start);}finish(){performance.mark(this._marks.end);let e=performance.getEntriesByName(this._marks.measure);return 0===e.length&&(performance.measure(this._marks.measure,this._marks.start,this._marks.end),e=performance.getEntriesByName(this._marks.measure),performance.clearMarks(this._marks.start),performance.clearMarks(this._marks.end),performance.clearMeasures(this._marks.measure)),e}},e.c0=va,e.c1=class extends ga{constructor(e,t){super(e,t),this.current=[0,0,0];}set(e){e[0]===this.current[0]&&e[1]===this.current[1]&&e[2]===this.current[2]||(this.current=e,this.gl.uniform3f(this.location,e[0],e[1],e[2]));}},e.c2=class extends ga{constructor(e,t){super(e,t),this.current=[0,0];}set(e){e[0]===this.current[0]&&e[1]===this.current[1]||(this.current=e,this.gl.uniform2f(this.location,e[0],e[1]));}},e.c3=d,e.c4=function(e,t){var r=Math.sin(t),n=Math.cos(t);return e[0]=n,e[1]=r,e[2]=0,e[3]=-r,e[4]=n,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e},e.c5=function(e,t,r){var n=t[0],i=t[1],s=t[2];return e[0]=n*r[0]+i*r[3]+s*r[6],e[1]=n*r[1]+i*r[4]+s*r[7],e[2]=n*r[2]+i*r[5]+s*r[8],e},e.c6=function(e,t,r,n,i,s,o){var a=1/(t-r),l=1/(n-i),u=1/(s-o);return e[0]=-2*a,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=-2*l,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=2*u,e[11]=0,e[12]=(t+r)*a,e[13]=(i+n)*l,e[14]=(o+s)*u,e[15]=1,e},e.c7=class extends ga{constructor(e,t){super(e,t),this.current=new Array;}set(e){if(e!=this.current){this.current=e;const t=new Float32Array(4*e.length);for(let r=0;r<e.length;r++)t[4*r]=e[r].r,t[4*r+1]=e[r].g,t[4*r+2]=e[r].b,t[4*r+3]=e[r].a;this.gl.uniform4fv(this.location,t);}}},e.c8=class extends ga{constructor(e,t){super(e,t),this.current=new Array;}set(e){if(e!=this.current){this.current=e;const t=new Float32Array(e);this.gl.uniform1fv(this.location,t);}}},e.c9=class extends yo{},e.cA=function(e){return re[e]||ne[e]},e.cB=function(e,t,r){var n=t[0],i=t[1];return e[0]=r[0]*n+r[4]*i+r[12],e[1]=r[1]*n+r[5]*i+r[13],e},e.cC=function(e,t){const{x:r,y:n}=kh.fromLngLat(t);return !(e<0||e>25||n<0||n>=1||r<0||r>=1)},e.cD=function(e,t){return e[0]=t[0],e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t[1],e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t[2],e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},e.cE=class extends ro{},e.cF=md,e.cH=function(e){return e.message===ie},e.cI=ue,e.cJ=function(e,t){oe.REGISTERED_PROTOCOLS[e]=t;},e.cK=function(e){delete oe.REGISTERED_PROTOCOLS[e];},e.cL=function(e,t){const r={};for(let n=0;n<e.length;n++){const i=t&&t[e[n].id]||wi(e[n]);t&&(t[e[n].id]=i);let s=r[i];s||(s=r[i]=[]),s.push(e[n]);}const n=[];for(const e in r)n.push(r[e]);return n},e.cM=ls,e.cN=Oh,e.cO=wf,e.cP=Oc,e.cQ=function(t){t.bucket.createArrays(),t.bucket.tilePixelRatio=k/(512*t.bucket.overscaling),t.bucket.compareText={},t.bucket.iconsNeedLinear=!1;const r=t.bucket.layers[0],n=r.layout,i=r._unevaluatedLayout._values,s={layoutIconSize:i["icon-size"].possiblyEvaluate(new ks(t.bucket.zoom+1),t.canonical),layoutTextSize:i["text-size"].possiblyEvaluate(new ks(t.bucket.zoom+1),t.canonical),textMaxSize:i["text-size"].possiblyEvaluate(new ks(18))};if("composite"===t.bucket.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.bucket.textSizeData;s.compositeTextSizes=[i["text-size"].possiblyEvaluate(new ks(e),t.canonical),i["text-size"].possiblyEvaluate(new ks(r),t.canonical)];}if("composite"===t.bucket.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.bucket.iconSizeData;s.compositeIconSizes=[i["icon-size"].possiblyEvaluate(new ks(e),t.canonical),i["icon-size"].possiblyEvaluate(new ks(r),t.canonical)];}const o=n.get("text-line-height")*lc,a="viewport"!==n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement"),l=n.get("text-keep-upright"),u=n.get("text-size");for(const i of t.bucket.features){const c=n.get("text-font").evaluate(i,{},t.canonical).join(","),h=u.evaluate(i,{},t.canonical),p=s.layoutTextSize.evaluate(i,{},t.canonical),f=s.layoutIconSize.evaluate(i,{},t.canonical),d={horizontal:{},vertical:void 0},y=i.text;let m,g=[0,0];if(y){const s=y.toString(),u=n.get("text-letter-spacing").evaluate(i,{},t.canonical)*lc,f=vs(s)?u:0,m=n.get("text-anchor").evaluate(i,{},t.canonical),x=Wf(r,i,t.canonical);if(!x){const e=n.get("text-radial-offset").evaluate(i,{},t.canonical);g=e?Kf(m,[e*lc,Hf]):n.get("text-offset").evaluate(i,{},t.canonical).map((e=>e*lc));}let v=a?"center":n.get("text-justify").evaluate(i,{},t.canonical);const b="point"===n.get("symbol-placement")?n.get("text-max-width").evaluate(i,{},t.canonical)*lc:1/0,w=()=>{t.bucket.allowVerticalPlacement&&xs(s)&&(d.vertical=Nc(y,t.glyphMap,t.glyphPositions,t.imagePositions,c,b,o,m,"left",f,g,e.ay.vertical,!0,p,h));};if(!a&&x){const r=new Set;if("auto"===v)for(let e=0;e<x.values.length;e+=2)r.add(Jf(x.values[e]));else r.add(v);let n=!1;for(const i of r)if(!d.horizontal[i])if(n)d.horizontal[i]=d.horizontal[0];else {const r=Nc(y,t.glyphMap,t.glyphPositions,t.imagePositions,c,b,o,"center",i,f,g,e.ay.horizontal,!1,p,h);r&&(d.horizontal[i]=r,n=1===r.positionedLines.length);}w();}else {"auto"===v&&(v=Jf(m));const r=Nc(y,t.glyphMap,t.glyphPositions,t.imagePositions,c,b,o,m,v,f,g,e.ay.horizontal,!1,p,h);r&&(d.horizontal[v]=r),w(),xs(s)&&a&&l&&(d.vertical=Nc(y,t.glyphMap,t.glyphPositions,t.imagePositions,c,b,o,m,v,f,g,e.ay.vertical,!1,p,h));}}let x=!1;if(i.icon&&i.icon.name){const e=t.imageMap[i.icon.name];e&&(m=Zc(t.imagePositions[i.icon.name],n.get("icon-offset").evaluate(i,{},t.canonical),n.get("icon-anchor").evaluate(i,{},t.canonical)),x=!!e.sdf,void 0===t.bucket.sdfIcons?t.bucket.sdfIcons=x:t.bucket.sdfIcons!==x&&j("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.bucket.pixelRatio||0!==n.get("icon-rotate").constantOr(1))&&(t.bucket.iconsNeedLinear=!0));}const v=td(d.horizontal)||d.vertical;t.bucket.iconsInText=!!v&&v.iconsInText,(v||m)&&Qf(t.bucket,i,d,m,t.imageMap,s,p,f,g,x,t.canonical,t.subdivisionGranularity);}t.showCollisionBoxes&&t.bucket.generateCollisionDebugBuffers();},e.cR=mu,e.cS=Bu,e.cT=Zu,e.cU=Eu,e.cV=wc,e.cW=Au,e.cX=function(e,t,r,n,i,s){let o=Tf(e,t,r,i,0);return o=Tf(o,t,n,s,1),o},e.cY=class{constructor(e){this.maxEntries=e,this.map=new Map;}get(e){const t=this.map.get(e);return void 0!==t&&(this.map.delete(e),this.map.set(e,t)),t}set(e,t){if(this.map.has(e))this.map.delete(e);else if(this.map.size>=this.maxEntries){const e=this.map.keys().next().value;this.map.delete(e);}this.map.set(e,t);}clear(){this.map.clear();}},e.cZ=ku,e.c_=xf,e.ca=oc,e.cb=class extends go{},e.cc=bl,e.cd=function(e){return e<=1?1:Math.pow(2,Math.ceil(Math.log(e)/Math.LN2))},e.ce=vl,e.cf=function(e,t,r){var n=t[0],i=t[1],s=t[2],o=r[3]*n+r[7]*i+r[11]*s+r[15];return e[0]=(r[0]*n+r[4]*i+r[8]*s+r[12])/(o=o||1),e[1]=(r[1]*n+r[5]*i+r[9]*s+r[13])/o,e[2]=(r[2]*n+r[6]*i+r[10]*s+r[14])/o,e},e.cg=class extends no{},e.ch=class extends Ao{},e.ci=function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[11]===t[11]&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[15]===t[15]},e.cj=function(e,t){var r=e[0],n=e[1],i=e[2],s=e[3],o=e[4],a=e[5],l=e[6],u=e[7],c=e[8],h=e[9],f=e[10],d=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=t[0],b=t[1],w=t[2],_=t[3],S=t[4],A=t[5],T=t[6],I=t[7],E=t[8],M=t[9],k=t[10],F=t[11],D=t[12],P=t[13],B=t[14],z=t[15];return Math.abs(r-v)<=p*Math.max(1,Math.abs(r),Math.abs(v))&&Math.abs(n-b)<=p*Math.max(1,Math.abs(n),Math.abs(b))&&Math.abs(i-w)<=p*Math.max(1,Math.abs(i),Math.abs(w))&&Math.abs(s-_)<=p*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(o-S)<=p*Math.max(1,Math.abs(o),Math.abs(S))&&Math.abs(a-A)<=p*Math.max(1,Math.abs(a),Math.abs(A))&&Math.abs(l-T)<=p*Math.max(1,Math.abs(l),Math.abs(T))&&Math.abs(u-I)<=p*Math.max(1,Math.abs(u),Math.abs(I))&&Math.abs(c-E)<=p*Math.max(1,Math.abs(c),Math.abs(E))&&Math.abs(h-M)<=p*Math.max(1,Math.abs(h),Math.abs(M))&&Math.abs(f-k)<=p*Math.max(1,Math.abs(f),Math.abs(k))&&Math.abs(d-F)<=p*Math.max(1,Math.abs(d),Math.abs(F))&&Math.abs(y-D)<=p*Math.max(1,Math.abs(y),Math.abs(D))&&Math.abs(m-P)<=p*Math.max(1,Math.abs(m),Math.abs(P))&&Math.abs(g-B)<=p*Math.max(1,Math.abs(g),Math.abs(B))&&Math.abs(x-z)<=p*Math.max(1,Math.abs(x),Math.abs(z))},e.ck=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},e.cl=e=>"symbol"===e.type,e.cm=e=>"circle"===e.type,e.cn=e=>"heatmap"===e.type,e.co=e=>"line"===e.type,e.cp=e=>"fill"===e.type,e.cq=e=>"fill-extrusion"===e.type,e.cr=e=>"hillshade"===e.type,e.cs=e=>"color-relief"===e.type,e.ct=e=>"background"===e.type,e.cu=e=>"custom"===e.type,e.cv=z,e.cw=function(e,t,r){const n=M(t.x-r.x,t.y-r.y),i=M(e.x-r.x,e.y-r.y);var s,o;return te(Math.atan2(n[0]*i[1]-n[1]*i[0],(s=n)[0]*(o=i)[0]+s[1]*o[1]))},e.cx=V,e.cy=function(e,t){return ne[t]&&(e instanceof MouseEvent||e instanceof WheelEvent)},e.cz=function(e,t){return re[t]&&"touches"in e},e.d=pe,e.d0=function(e,r,n,i,s){return t(this,void 0,void 0,(function*(){if(h())try{return yield K(e,r,n,i,s)}catch(e){}return function(e,t,r,n,i){const s=e.width,o=e.height;W&&J||(W=new OffscreenCanvas(s,o),J=W.getContext("2d",{willReadFrequently:!0})),W.width=s,W.height=o,J.drawImage(e,0,0,s,o);const a=J.getImageData(t,r,n,i);return J.clearRect(0,0,s,o),a.data}(e,r,n,i,s)}))},e.d1=Ml,e.d2=n,e.d3=ri,e.d4=Ms,e.e=O,e.f=e=>t(void 0,void 0,void 0,(function*(){if(0===e.byteLength)return createImageBitmap(new ImageData(1,1));const t=new Blob([new Uint8Array(e)],{type:"image/png"});try{return createImageBitmap(t)}catch(e){throw new Error(`Could not load image because of ${e.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`)}})),e.g=ae,e.h=e=>new Promise(((t,r)=>{const n=new Image;n.onload=()=>{t(n),URL.revokeObjectURL(n.src),n.onload=null,window.requestAnimationFrame((()=>{n.src=H;}));},n.onerror=()=>r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const i=new Blob([new Uint8Array(e)],{type:"image/png"});n.src=e.byteLength?URL.createObjectURL(i):H;})),e.i=X,e.j=(e,t)=>he(O(e,{type:"json"}),t),e.k=me,e.l=ye,e.m=he,e.n=(e,t)=>he(O(e,{type:"arrayBuffer"}),t),e.o=function(e){return new wc(e).readFields(Bc,[])},e.p=Cc,e.q=function(e){return /[\u02EA\u02EB\u1100-\u11FF\u2E80-\u2FDF\u3000-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFE10-\uFE1F\uFE30-\uFE4F\uFF00-\uFFEF]|\uD81B[\uDFE0-\uDFFF]|[\uD81C-\uD822\uD840-\uD868\uD86A-\uD86D\uD86F-\uD872\uD874-\uD879\uD880-\uD883\uD885-\uD88C][\uDC00-\uDFFF]|\uD823[\uDC00-\uDCD5\uDCFF-\uDD1E\uDD80-\uDDF2]|\uD82B[\uDFF0-\uDFFF]|\uD82C[\uDC00-\uDEFB]|\uD83C[\uDE00-\uDEFF]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEAD\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0\uDFF0-\uDFFF]|\uD87B[\uDC00-\uDE5D]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A\uDF50-\uDFFF]|\uD88D[\uDC00-\uDC79]/gim.test(String.fromCodePoint(e))},e.r=gl,e.s=Q,e.t=Gs,e.u=xe,e.v=Qi,e.w=j,e.x=zs,e.y=ts,e.z=Ds;}));

define("worker",["./shared"],(function(e){"use strict";class t{constructor(e,t){this.keyCache={},e&&this.replace(e,t);}replace(e,t){this._layerConfigs={},this._layers={},this.update(e,[],t);}update(t,i,o){for(const i of t){this._layerConfigs[i.id]=i;const t=this._layers[i.id]=e.bS(i,o);t._featureFilter=e.aj(t.filter,o),this.keyCache[i.id]&&delete this.keyCache[i.id];}for(const e of i)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const s=e.cL(Object.values(this._layerConfigs),this.keyCache);for(const t of s){const i=t.map((e=>this._layers[e.id])),o=i[0];if("none"===o.visibility)continue;const s=o.source||"";let n=this.familiesBySource[s];n||(n=this.familiesBySource[s]={});const r=o.sourceLayer||e.a9;let a=n[r];a||(a=n[r]=[]),a.push(i);}}}class i{constructor(t){const i={},o=[];for(const e in t){const s=t[e],n=i[e]={};for(const e in s){const t=s[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const i={x:0,y:0,w:t.bitmap.width+2,h:t.bitmap.height+2};o.push(i),n[e]={rect:i,metrics:t.metrics};}}const{w:s,h:n}=e.p(o),r=new e.r({width:s||1,height:n||1});for(const o in t){const s=t[o];for(const t in s){const n=s[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const a=i[o][t].rect;e.r.copy(n.bitmap,r,{x:0,y:0},{x:a.x+1,y:a.y+1},n.bitmap);}}this.image=r,this.positions=i;}}e.cM("GlyphAtlas",i);class o{constructor(t){this.tileID=new e.a1(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.inFlightDependencies=[];}parse(t,o,n,r,a){return e._(this,void 0,void 0,(function*(){this.status="parsing",this.data=t,this.collisionBoxArray=new e.ah;const l=new e.cN(Object.keys(t.layers).sort()),c=new e.cO(this.tileID,this.promoteId);c.bucketLayerIDs=[];const h={},u={featureIndex:c,iconDependencies:{},patternDependencies:{},glyphDependencies:{},dashDependencies:{},availableImages:n,subdivisionGranularity:a},d=o.familiesBySource[this.source];for(const i in d){const o=t.layers[i];if(!o)continue;1===o.version&&e.w(`Vector tile source "${this.source}" layer "${i}" does not use vector tile spec v2 and therefore may have some rendering errors.`);const r=l.encode(i),a=[];for(let e=0;e<o.length;e++){const t=o.feature(e),s=c.getId(t,i);a.push({feature:t,id:s,index:e,sourceLayerIndex:r});}for(const t of d[i]){const i=t[0];i.source!==this.source&&e.w(`layer.source = ${i.source} does not equal this.source = ${this.source}`),i.isHidden(this.zoom,!0)||(s(t,this.zoom,n),(h[i.id]=i.createBucket({index:c.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:r,sourceID:this.source})).populate(a,u,this.tileID.canonical),c.bucketLayerIDs.push(t.map((e=>e.id))));}}const f=e.bX(u.glyphDependencies,(e=>Object.keys(e).map(Number)));this.inFlightDependencies.forEach((e=>null==e?void 0:e.abort())),this.inFlightDependencies=[];let g=Promise.resolve({});if(Object.keys(f).length){const e=new AbortController;this.inFlightDependencies.push(e),g=r.sendAsync({type:"GG",data:{stacks:f,source:this.source,tileID:this.tileID,type:"glyphs"}},e);}const p=Object.keys(u.iconDependencies);let m=Promise.resolve({});if(p.length){const e=new AbortController;this.inFlightDependencies.push(e),m=r.sendAsync({type:"GI",data:{icons:p,source:this.source,tileID:this.tileID,type:"icons"}},e);}const y=Object.keys(u.patternDependencies);let v=Promise.resolve({});if(y.length){const e=new AbortController;this.inFlightDependencies.push(e),v=r.sendAsync({type:"GI",data:{icons:y,source:this.source,tileID:this.tileID,type:"patterns"}},e);}const w=u.dashDependencies;let x=Promise.resolve({});if(Object.keys(w).length){const e=new AbortController;this.inFlightDependencies.push(e),x=r.sendAsync({type:"GDA",data:{dashes:w}},e);}const[_,S,b,M]=yield Promise.all([g,m,v,x]),I=new i(_),P=new e.cP(S,b);for(const t in h){const i=h[t];i instanceof e.ai?(s(i.layers,this.zoom,n),e.cQ({bucket:i,glyphMap:_,glyphPositions:I.positions,imageMap:S,imagePositions:P.iconPositions,showCollisionBoxes:this.showCollisionBoxes,canonical:this.tileID.canonical,subdivisionGranularity:u.subdivisionGranularity})):i.hasDependencies&&(i instanceof e.cR||i instanceof e.cS||i instanceof e.cT)&&(s(i.layers,this.zoom,n),i.addFeatures(u,this.tileID.canonical,P.patternPositions,M));}return this.status="done",{buckets:Object.values(h).filter((e=>!e.isEmpty())),featureIndex:c,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:I.image,imageAtlas:P,dashPositions:M,glyphMap:this.returnDependencies?_:null,iconMap:this.returnDependencies?S:null,glyphPositions:this.returnDependencies?I.positions:null}}))}}function s(t,i,o){const s=new e.H(i);for(const e of t)e.recalculate(s,o);}class n extends e.cW{constructor(t,i){super(new e.cV,0,i,[],[]),this.feature=t,this.type=t.type,this.properties=t.tags?t.tags:{},"id"in t&&("string"==typeof t.id?this.id=parseInt(t.id,10):"number"!=typeof t.id||isNaN(t.id)||(this.id=t.id));}loadGeometry(){const t=[],i=1===this.feature.type?[this.feature.geometry]:this.feature.geometry;for(const o of i){const i=[];for(const t of o)i.push(new e.P(t[0],t[1]));t.push(i);}return t}}class r extends e.cU{constructor(t,i){super(new e.cV),this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.version=i?i.version:1,this.extent=i?i.extent:4096,this.length=t.length,this.features=t;}feature(e){return new n(this.features[e],this.extent)}}function a(e,t){t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);const i={keys:[],values:[],keycache:{},valuecache:{}};for(let o=0;o<e.length;o++)i.feature=e.feature(o),t.writeMessage(2,l,i);const o=i.keys;for(const e of o)t.writeStringField(3,e);const s=i.values;for(const e of s)t.writeMessage(4,f,e);}function l(e,t){if(!e.feature)return;const i=e.feature;void 0!==i.id&&t.writeVarintField(1,i.id),t.writeMessage(2,c,e),t.writeVarintField(3,i.type),t.writeMessage(4,d,i);}function c(e,t){for(const i in e.feature?.properties){let o=e.feature.properties[i],s=e.keycache[i];if(null===o)continue;void 0===s&&(e.keys.push(i),s=e.keys.length-1,e.keycache[i]=s),t.writeVarint(s),"string"!=typeof o&&"boolean"!=typeof o&&"number"!=typeof o&&(o=JSON.stringify(o));const n=typeof o+":"+o;let r=e.valuecache[n];void 0===r&&(e.values.push(o),r=e.values.length-1,e.valuecache[n]=r),t.writeVarint(r);}}function h(e,t){return (t<<3)+(7&e)}function u(e){return e<<1^e>>31}function d(e,t){const i=e.loadGeometry(),o=e.type;let s=0,n=0;for(const r of i){let i=1;1===o&&(i=r.length),t.writeVarint(h(1,i));const a=3===o?r.length-1:r.length;for(let e=0;e<a;e++){1===e&&1!==o&&t.writeVarint(h(2,a-1));const i=r[e].x-s,l=r[e].y-n;t.writeVarint(u(i)),t.writeVarint(u(l)),s+=i,n+=l;}3===e.type&&t.writeVarint(h(7,1));}}function f(e,t){const i=typeof e;"string"===i?t.writeStringField(1,e):"boolean"===i?t.writeBooleanField(7,e):"number"===i&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}class g extends e.cW{constructor(t,i,o,s,n){super(new e.cV,0,n,[],[]),this.type=t,this.properties=o||{},this.extent=n,this.pointsArray=i,this.id=s;}loadGeometry(){return this.pointsArray.map((t=>t.map((t=>new e.P(t.x,t.y)))))}}class p extends e.cU{constructor(t,i,o){super(new e.cV),this.version=2,this._myFeatures=t,this.name=i,this.length=t.length,this.extent=o;}feature(e){return this._myFeatures[e]}}class m{constructor(){this.layers={};}addLayer(e){this.layers[e.name]=e;}}function y(t){let i=function(t){const i=new e.cV;return function(e,t){for(const i in e.layers)t.writeMessage(3,a,e.layers[i]);}(t,i),i.finish()}(t);return 0===i.byteOffset&&i.byteLength===i.buffer.byteLength||(i=new Uint8Array(i)),{vectorTile:t,rawData:i.buffer}}function v(t,i,o){const{extent:s}=t,n=Math.pow(2,o.z-i.z),r=(o.x-i.x*n)*s,a=(o.y-i.y*n)*s,l=[];for(let i=0;i<t.length;i++){const o=t.feature(i);let c=o.loadGeometry();for(const e of c)for(const t of e)t.x=t.x*n-r,t.y=t.y*n-a;const h=128;c=e.cX(c,o.type,-h,-h,s+h,s+h),0!==c.length&&l.push(new g(o.type,c,o.properties,o.id,s));}return new p(l,t.name,s)}class w{constructor(t,i,o){this.actor=t,this.layerIndex=i,this.availableImages=o,this.fetching={},this.loading={},this.loaded={},this.overzoomedTileResultCache=new e.cY(1e3);}loadVectorTile(t,i){return e._(this,void 0,void 0,(function*(){const o=yield e.n(t.request,i);try{return {vectorTile:"mlt"!==t.encoding?new e.cZ(new e.cV(o.data)):new e.c_(o.data),rawData:o.data,cacheControl:o.cacheControl,expires:o.expires}}catch(e){const i=new Uint8Array(o.data);let s=`Unable to parse the tile at ${t.request.url}, `;throw s+=31===i[0]&&139===i[1]?"please make sure the data is not gzipped and that you have configured the relevant header in the server":`got error: ${e.message}`,new Error(s)}}))}loadTile(t){return e._(this,void 0,void 0,(function*(){const{uid:i,overzoomParameters:s}=t;s&&(t.request=s.overzoomRequest);const n=!!(t&&t.request&&t.request.collectResourceTiming)&&new e.c$(t.request),r=new o(t);this.loading[i]=r;const a=new AbortController;r.abort=a;try{const o=yield this.loadVectorTile(t,a);if(delete this.loading[i],!o)return null;if(s){const e=this._getOverzoomTile(t,o.vectorTile);o.rawData=e.rawData,o.vectorTile=e.vectorTile;}const l=o.rawData,c={};o.expires&&(c.expires=o.expires),o.cacheControl&&(c.cacheControl=o.cacheControl);const h={};if(n){const e=n.finish();e&&(h.resourceTiming=JSON.parse(JSON.stringify(e)));}r.vectorTile=o.vectorTile;const u=r.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);this.loaded[i]=r,this.fetching[i]={rawTileData:l,cacheControl:c,resourceTiming:h};try{const i=yield u;return e.e({rawTileData:l.slice(0),encoding:t.encoding},i,c,h)}finally{delete this.fetching[i];}}catch(e){throw delete this.loading[i],r.status="done",this.loaded[i]=r,e}}))}_getOverzoomTile(e,t){const{tileID:i,source:o,overzoomParameters:s}=e,{maxZoomTileID:n}=s,r=`${n.key}_${i.key}`,a=this.overzoomedTileResultCache.get(r);if(a)return a;const l=new m,c=this.layerIndex.familiesBySource[o];for(const e in c){const o=t.layers[e];if(!o)continue;const s=v(o,n,i.canonical);s.length>0&&l.addLayer(s);}const h=y(l);return this.overzoomedTileResultCache.set(r,h),h}reloadTile(t){return e._(this,void 0,void 0,(function*(){const i=t.uid;if(!this.loaded||!this.loaded[i])throw new Error("Should not be trying to reload a tile that was never loaded or has been removed");const o=this.loaded[i];if(o.showCollisionBoxes=t.showCollisionBoxes,"parsing"===o.status){const s=yield o.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity);let n;if(this.fetching[i]){const{rawTileData:o,cacheControl:r,resourceTiming:a}=this.fetching[i];delete this.fetching[i],n=e.e({rawTileData:o.slice(0),encoding:t.encoding},s,r,a);}else n=s;return n}if("done"===o.status&&o.vectorTile)return o.parse(o.vectorTile,this.layerIndex,this.availableImages,this.actor,t.subdivisionGranularity)}))}abortTile(t){return e._(this,void 0,void 0,(function*(){const e=this.loading,i=t.uid;e&&e[i]&&e[i].abort&&(e[i].abort.abort(),delete e[i]);}))}removeTile(t){return e._(this,void 0,void 0,(function*(){this.loaded&&this.loaded[t.uid]&&delete this.loaded[t.uid];}))}}class x{constructor(){this.loaded={};}loadTile(t){return e._(this,void 0,void 0,(function*(){const{uid:i,encoding:o,rawImageData:s,redFactor:n,greenFactor:r,blueFactor:a,baseShift:l}=t,c=s.width+2,h=s.height+2,u=e.b(s)?new e.R({width:c,height:h},yield e.d0(s,-1,-1,c,h)):s,d=new e.d1(i,u,o,n,r,a,l);return this.loaded=this.loaded||{},this.loaded[i]=d,d}))}removeTile(e){const t=this.loaded,i=e.uid;t&&t[i]&&delete t[i];}}var _,S,b=function(){if(S)return _;function e(e,i){if(0!==e.length){t(e[0],i);for(var o=1;o<e.length;o++)t(e[o],!i);}}function t(e,t){for(var i=0,o=0,s=0,n=e.length,r=n-1;s<n;r=s++){var a=(e[s][0]-e[r][0])*(e[r][1]+e[s][1]),l=i+a;o+=Math.abs(i)>=Math.abs(a)?i-l+a:a-l+i,i=l;}i+o>=0!=!!t&&e.reverse();}return S=1,_=function t(i,o){var s,n=i&&i.type;if("FeatureCollection"===n)for(s=0;s<i.features.length;s++)t(i.features[s],o);else if("GeometryCollection"===n)for(s=0;s<i.geometries.length;s++)t(i.geometries[s],o);else if("Feature"===n)t(i.geometry,o);else if("Polygon"===n)e(i.coordinates,o);else if("MultiPolygon"===n)for(s=0;s<i.coordinates.length;s++)e(i.coordinates[s],o);return i}}(),M=e.d2(b);const I={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},P=Math.fround||(k=new Float32Array(1),e=>(k[0]=+e,k[0]));var k;class D{constructor(e){this.options=Object.assign(Object.create(I),e),this.trees=new Array(this.options.maxZoom+1),this.stride=this.options.reduce?7:6,this.clusterProps=[];}load(e){const{log:t,minZoom:i,maxZoom:o}=this.options;t&&console.time("total time");const s=`prepare ${e.length} points`;t&&console.time(s),this.points=e;const n=[];for(let t=0;t<e.length;t++){const i=e[t];if(!i.geometry)continue;const[o,s]=i.geometry.coordinates,r=P(L(o)),a=P(O(s));n.push(r,a,1/0,t,-1,1),this.options.reduce&&n.push(0);}let r=this.trees[o+1]=this._createTree(n);t&&console.timeEnd(s);for(let e=o;e>=i;e--){const i=+Date.now();r=this.trees[e]=this._createTree(this._cluster(r,e)),t&&console.log("z%d: %d clusters in %dms",e,r.numItems,+Date.now()-i);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let i=((e[0]+180)%360+360)%360-180;const o=Math.max(-90,Math.min(90,e[1]));let s=180===e[2]?180:((e[2]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)i=-180,s=180;else if(i>s){const e=this.getClusters([i,o,180,n],t),r=this.getClusters([-180,o,s,n],t);return e.concat(r)}const r=this.trees[this._limitZoom(t)],a=r.range(L(i),O(n),L(s),O(o)),l=r.data,c=[];for(const e of a){const t=this.stride*e;c.push(l[t+5]>1?T(l,t,this.clusterProps):this.points[l[t+3]]);}return c}getChildren(e){const t=this._getOriginId(e),i=this._getOriginZoom(e),o="No cluster with the specified id.",s=this.trees[i];if(!s)throw new Error(o);const n=s.data;if(t*this.stride>=n.length)throw new Error(o);const r=this.options.radius/(this.options.extent*Math.pow(2,i-1)),a=s.within(n[t*this.stride],n[t*this.stride+1],r),l=[];for(const t of a){const i=t*this.stride;n[i+4]===e&&l.push(n[i+5]>1?T(n,i,this.clusterProps):this.points[n[i+3]]);}if(0===l.length)throw new Error(o);return l}getLeaves(e,t,i){const o=[];return this._appendLeaves(o,e,t=t||10,i=i||0,0),o}getTile(e,t,i){const o=this.trees[this._limitZoom(e)],s=Math.pow(2,e),{extent:n,radius:r}=this.options,a=r/n,l=(i-a)/s,c=(i+1+a)/s,h={features:[]};return this._addTileFeatures(o.range((t-a)/s,l,(t+1+a)/s,c),o.data,t,i,s,h),0===t&&this._addTileFeatures(o.range(1-a/s,l,1,c),o.data,s,i,s,h),t===s-1&&this._addTileFeatures(o.range(0,l,a/s,c),o.data,-1,i,s,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const i=this.getChildren(e);if(t++,1!==i.length)break;e=i[0].properties.cluster_id;}return t}_appendLeaves(e,t,i,o,s){const n=this.getChildren(t);for(const t of n){const n=t.properties;if(n&&n.cluster?s+n.point_count<=o?s+=n.point_count:s=this._appendLeaves(e,n.cluster_id,i,o,s):s<o?s++:e.push(t),e.length===i)break}return s}_createTree(t){const i=new e.aS(t.length/this.stride|0,this.options.nodeSize,Float32Array);for(let e=0;e<t.length;e+=this.stride)i.add(t[e],t[e+1]);return i.finish(),i.data=t,i}_addTileFeatures(e,t,i,o,s,n){for(const r of e){const e=r*this.stride,a=t[e+5]>1;let l,c,h;if(a)l=C(t,e,this.clusterProps),c=t[e],h=t[e+1];else {const i=this.points[t[e+3]];l=i.properties;const[o,s]=i.geometry.coordinates;c=L(o),h=O(s);}const u={type:1,geometry:[[Math.round(this.options.extent*(c*s-i)),Math.round(this.options.extent*(h*s-o))]],tags:l};let d;d=a||this.options.generateId?t[e+3]:this.points[t[e+3]].id,void 0!==d&&(u.id=d),n.features.push(u);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(Math.floor(+e),this.options.maxZoom+1))}_cluster(e,t){const{radius:i,extent:o,reduce:s,minPoints:n}=this.options,r=i/(o*Math.pow(2,t)),a=e.data,l=[],c=this.stride;for(let i=0;i<a.length;i+=c){if(a[i+2]<=t)continue;a[i+2]=t;const o=a[i],h=a[i+1],u=e.within(a[i],a[i+1],r),d=a[i+5];let f=d;for(const e of u){const i=e*c;a[i+2]>t&&(f+=a[i+5]);}if(f>d&&f>=n){let e,n=o*d,r=h*d,g=-1;const p=(i/c<<5)+(t+1)+this.points.length;for(const o of u){const l=o*c;if(a[l+2]<=t)continue;a[l+2]=t;const h=a[l+5];n+=a[l]*h,r+=a[l+1]*h,a[l+4]=p,s&&(e||(e=this._map(a,i,!0),g=this.clusterProps.length,this.clusterProps.push(e)),s(e,this._map(a,l)));}a[i+4]=p,l.push(n/f,r/f,1/0,p,-1,f),s&&l.push(g);}else {for(let e=0;e<c;e++)l.push(a[i+e]);if(f>1)for(const e of u){const i=e*c;if(!(a[i+2]<=t)){a[i+2]=t;for(let e=0;e<c;e++)l.push(a[i+e]);}}}}return l}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t,i){if(e[t+5]>1){const o=this.clusterProps[e[t+6]];return i?Object.assign({},o):o}const o=this.points[e[t+3]].properties,s=this.options.map(o);return i&&s===o?Object.assign({},s):s}}function T(e,t,i){return {type:"Feature",id:e[t+3],properties:C(e,t,i),geometry:{type:"Point",coordinates:[(o=e[t],360*(o-.5)),F(e[t+1])]}};var o;}function C(e,t,i){const o=e[t+5],s=o>=1e4?`${Math.round(o/1e3)}k`:o>=1e3?Math.round(o/100)/10+"k":o,n=e[t+6],r=-1===n?{}:Object.assign({},i[n]);return Object.assign(r,{cluster:!0,cluster_id:e[t+3],point_count:o,point_count_abbreviated:s})}function L(e){return e/360+.5}function O(e){const t=Math.sin(e*Math.PI/180),i=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return i<0?0:i>1?1:i}function F(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function z(e,t,i,o){let s=o;const n=t+(i-t>>1);let r,a=i-t;const l=e[t],c=e[t+1],h=e[i],u=e[i+1];for(let o=t+3;o<i;o+=3){const t=G(e[o],e[o+1],l,c,h,u);if(t>s)r=o,s=t;else if(t===s){const e=Math.abs(o-n);e<a&&(r=o,a=e);}}s>o&&(r-t>3&&z(e,t,r,o),e[r+2]=s,i-r>3&&z(e,r,i,o));}function G(e,t,i,o,s,n){let r=s-i,a=n-o;if(0!==r||0!==a){const l=((e-i)*r+(t-o)*a)/(r*r+a*a);l>1?(i=s,o=n):l>0&&(i+=r*l,o+=a*l);}return r=e-i,a=t-o,r*r+a*a}function A(e,t,i,o){const s={id:null==e?null:e,type:t,geometry:i,tags:o,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};if("Point"===t||"MultiPoint"===t||"LineString"===t)Z(s,i);else if("Polygon"===t)Z(s,i[0]);else if("MultiLineString"===t)for(const e of i)Z(s,e);else if("MultiPolygon"===t)for(const e of i)Z(s,e[0]);return s}function Z(e,t){for(let i=0;i<t.length;i+=3)e.minX=Math.min(e.minX,t[i]),e.minY=Math.min(e.minY,t[i+1]),e.maxX=Math.max(e.maxX,t[i]),e.maxY=Math.max(e.maxY,t[i+1]);}function N(e,t,i,o){if(!t.geometry)return;const s=t.geometry.coordinates;if(s&&0===s.length)return;const n=t.geometry.type,r=Math.pow(i.tolerance/((1<<i.maxZoom)*i.extent),2);let a=[],l=t.id;if(i.promoteId?l=t.properties[i.promoteId]:i.generateId&&(l=o||0),"Point"===n)R(s,a);else if("MultiPoint"===n)for(const e of s)R(e,a);else if("LineString"===n)j(s,a,r,!1);else if("MultiLineString"===n){if(i.lineMetrics){for(const i of s)a=[],j(i,a,r,!1),e.push(A(l,"LineString",a,t.properties));return}E(s,a,r,!1);}else if("Polygon"===n)E(s,a,r,!0);else {if("MultiPolygon"!==n){if("GeometryCollection"===n){for(const s of t.geometry.geometries)N(e,{id:l,geometry:s,properties:t.properties},i,o);return}throw new Error("Input data is not a valid GeoJSON object.")}for(const e of s){const t=[];E(e,t,r,!0),a.push(t);}}e.push(A(l,n,a,t.properties));}function R(e,t){t.push(W(e[0]),J(e[1]),0);}function j(e,t,i,o){let s,n,r=0;for(let i=0;i<e.length;i++){const a=W(e[i][0]),l=J(e[i][1]);t.push(a,l,0),i>0&&(r+=o?(s*l-a*n)/2:Math.sqrt(Math.pow(a-s,2)+Math.pow(l-n,2))),s=a,n=l;}const a=t.length-3;t[2]=1,z(t,0,a,i),t[a+2]=1,t.size=Math.abs(r),t.start=0,t.end=t.size;}function E(e,t,i,o){for(let s=0;s<e.length;s++){const n=[];j(e[s],n,i,o),t.push(n);}}function W(e){return e/360+.5}function J(e){const t=Math.sin(e*Math.PI/180),i=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return i<0?0:i>1?1:i}function Y(e,t,i,o,s,n,r,a){if(o/=t,n>=(i/=t)&&r<o)return e;if(r<i||n>=o)return null;const l=[];for(const t of e){const e=t.geometry;let n=t.type;const r=0===s?t.minX:t.minY,c=0===s?t.maxX:t.maxY;if(r>=i&&c<o){l.push(t);continue}if(c<i||r>=o)continue;let h=[];if("Point"===n||"MultiPoint"===n)V(e,h,i,o,s);else if("LineString"===n)H(e,h,i,o,s,!1,a.lineMetrics);else if("MultiLineString"===n)X(e,h,i,o,s,!1);else if("Polygon"===n)X(e,h,i,o,s,!0);else if("MultiPolygon"===n)for(const t of e){const e=[];X(t,e,i,o,s,!0),e.length&&h.push(e);}if(h.length){if(a.lineMetrics&&"LineString"===n){for(const e of h)l.push(A(t.id,n,e,t.tags));continue}"LineString"!==n&&"MultiLineString"!==n||(1===h.length?(n="LineString",h=h[0]):n="MultiLineString"),"Point"!==n&&"MultiPoint"!==n||(n=3===h.length?"Point":"MultiPoint"),l.push(A(t.id,n,h,t.tags));}}return l.length?l:null}function V(e,t,i,o,s){for(let n=0;n<e.length;n+=3){const r=e[n+s];r>=i&&r<=o&&B(t,e[n],e[n+1],e[n+2]);}}function H(e,t,i,o,s,n,r){let a=q(e);const l=0===s?$:U;let c,h,u=e.start;for(let d=0;d<e.length-3;d+=3){const f=e[d],g=e[d+1],p=e[d+2],m=e[d+3],y=e[d+4],v=0===s?f:g,w=0===s?m:y;let x=!1;r&&(c=Math.sqrt(Math.pow(f-m,2)+Math.pow(g-y,2))),v<i?w>i&&(h=l(a,f,g,m,y,i),r&&(a.start=u+c*h)):v>o?w<o&&(h=l(a,f,g,m,y,o),r&&(a.start=u+c*h)):B(a,f,g,p),w<i&&v>=i&&(h=l(a,f,g,m,y,i),x=!0),w>o&&v<=o&&(h=l(a,f,g,m,y,o),x=!0),!n&&x&&(r&&(a.end=u+c*h),t.push(a),a=q(e)),r&&(u+=c);}let d=e.length-3;const f=e[d],g=e[d+1],p=0===s?f:g;p>=i&&p<=o&&B(a,f,g,e[d+2]),d=a.length-3,n&&d>=3&&(a[d]!==a[0]||a[d+1]!==a[1])&&B(a,a[0],a[1],a[2]),a.length&&t.push(a);}function q(e){const t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function X(e,t,i,o,s,n){for(const r of e)H(r,t,i,o,s,n,!1);}function B(e,t,i,o){e.push(t,i,o);}function $(e,t,i,o,s,n){const r=(n-t)/(o-t);return B(e,n,i+(s-i)*r,1),r}function U(e,t,i,o,s,n){const r=(n-i)/(s-i);return B(e,t+(o-t)*r,n,1),r}function K(e,t){const i=[];for(let o=0;o<e.length;o++){const s=e[o],n=s.type;let r;if("Point"===n||"MultiPoint"===n||"LineString"===n)r=Q(s.geometry,t);else if("MultiLineString"===n||"Polygon"===n){r=[];for(const e of s.geometry)r.push(Q(e,t));}else if("MultiPolygon"===n){r=[];for(const e of s.geometry){const i=[];for(const o of e)i.push(Q(o,t));r.push(i);}}i.push(A(s.id,n,r,s.tags));}return i}function Q(e,t){const i=[];i.size=e.size,void 0!==e.start&&(i.start=e.start,i.end=e.end);for(let o=0;o<e.length;o+=3)i.push(e[o]+t,e[o+1],e[o+2]);return i}function ee(e,t){if(e.transformed)return e;const i=1<<e.z,o=e.x,s=e.y;for(const n of e.features){const e=n.geometry,r=n.type;if(n.geometry=[],1===r)for(let r=0;r<e.length;r+=2)n.geometry.push(te(e[r],e[r+1],t,i,o,s));else for(let r=0;r<e.length;r++){const a=[];for(let n=0;n<e[r].length;n+=2)a.push(te(e[r][n],e[r][n+1],t,i,o,s));n.geometry.push(a);}}return e.transformed=!0,e}function te(e,t,i,o,s,n){return [Math.round(i*(e*o-s)),Math.round(i*(t*o-n))]}function ie(e,t,i,o,s){const n=t===s.maxZoom?0:s.tolerance/((1<<t)*s.extent),r={features:[],numPoints:0,numSimplified:0,numFeatures:e.length,source:null,x:i,y:o,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0};for(const t of e)oe(r,t,n,s);return r}function oe(e,t,i,o){const s=t.geometry,n=t.type,r=[];if(e.minX=Math.min(e.minX,t.minX),e.minY=Math.min(e.minY,t.minY),e.maxX=Math.max(e.maxX,t.maxX),e.maxY=Math.max(e.maxY,t.maxY),"Point"===n||"MultiPoint"===n)for(let t=0;t<s.length;t+=3)r.push(s[t],s[t+1]),e.numPoints++,e.numSimplified++;else if("LineString"===n)se(r,s,e,i,!1,!1);else if("MultiLineString"===n||"Polygon"===n)for(let t=0;t<s.length;t++)se(r,s[t],e,i,"Polygon"===n,0===t);else if("MultiPolygon"===n)for(let t=0;t<s.length;t++){const o=s[t];for(let t=0;t<o.length;t++)se(r,o[t],e,i,!0,0===t);}if(r.length){let i=t.tags||null;if("LineString"===n&&o.lineMetrics){i={};for(const e in t.tags)i[e]=t.tags[e];i.mapbox_clip_start=s.start/s.size,i.mapbox_clip_end=s.end/s.size;}const a={geometry:r,type:"Polygon"===n||"MultiPolygon"===n?3:"LineString"===n||"MultiLineString"===n?2:1,tags:i};null!==t.id&&(a.id=t.id),e.features.push(a);}}function se(e,t,i,o,s,n){const r=o*o;if(o>0&&t.size<(s?r:o))return void(i.numPoints+=t.length/3);const a=[];for(let e=0;e<t.length;e+=3)(0===o||t[e+2]>r)&&(i.numSimplified++,a.push(t[e],t[e+1])),i.numPoints++;s&&function(e,t){let i=0;for(let t=0,o=e.length,s=o-2;t<o;s=t,t+=2)i+=(e[t]-e[s])*(e[t+1]+e[s+1]);if(i>0===t)for(let t=0,i=e.length;t<i/2;t+=2){const o=e[t],s=e[t+1];e[t]=e[i-2-t],e[t+1]=e[i-1-t],e[i-2-t]=o,e[i-1-t]=s;}}(a,n),e.push(a);}const ne={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0};class re{constructor(e,t){const i=(t=this.options=function(e,t){for(const i in t)e[i]=t[i];return e}(Object.create(ne),t)).debug;if(i&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");let o=function(e,t){const i=[];if("FeatureCollection"===e.type)for(let o=0;o<e.features.length;o++)N(i,e.features[o],t,o);else N(i,"Feature"===e.type?e:{geometry:e},t);return i}(e,t);this.tiles={},this.tileCoords=[],i&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),o=function(e,t){const i=t.buffer/t.extent;let o=e;const s=Y(e,1,-1-i,i,0,-1,2,t),n=Y(e,1,1-i,2+i,0,-1,2,t);return (s||n)&&(o=Y(e,1,-i,1+i,0,-1,2,t)||[],s&&(o=K(s,1).concat(o)),n&&(o=o.concat(K(n,-1)))),o}(o,t),o.length&&this.splitTile(o,0,0,0),i&&(o.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}splitTile(e,t,i,o,s,n,r){const a=[e,t,i,o],l=this.options,c=l.debug;for(;a.length;){o=a.pop(),i=a.pop(),t=a.pop(),e=a.pop();const h=1<<t,u=ae(t,i,o);let d=this.tiles[u];if(!d&&(c>1&&console.time("creation"),d=this.tiles[u]=ie(e,t,i,o,l),this.tileCoords.push({z:t,x:i,y:o}),c)){c>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,i,o,d.numFeatures,d.numPoints,d.numSimplified),console.timeEnd("creation"));const e=`z${t}`;this.stats[e]=(this.stats[e]||0)+1,this.total++;}if(d.source=e,null==s){if(t===l.indexMaxZoom||d.numPoints<=l.indexMaxPoints)continue}else {if(t===l.maxZoom||t===s)continue;if(null!=s){const e=s-t;if(i!==n>>e||o!==r>>e)continue}}if(d.source=null,0===e.length)continue;c>1&&console.time("clipping");const f=.5*l.buffer/l.extent,g=.5-f,p=.5+f,m=1+f;let y=null,v=null,w=null,x=null,_=Y(e,h,i-f,i+p,0,d.minX,d.maxX,l),S=Y(e,h,i+g,i+m,0,d.minX,d.maxX,l);e=null,_&&(y=Y(_,h,o-f,o+p,1,d.minY,d.maxY,l),v=Y(_,h,o+g,o+m,1,d.minY,d.maxY,l),_=null),S&&(w=Y(S,h,o-f,o+p,1,d.minY,d.maxY,l),x=Y(S,h,o+g,o+m,1,d.minY,d.maxY,l),S=null),c>1&&console.timeEnd("clipping"),a.push(y||[],t+1,2*i,2*o),a.push(v||[],t+1,2*i,2*o+1),a.push(w||[],t+1,2*i+1,2*o),a.push(x||[],t+1,2*i+1,2*o+1);}}getTile(e,t,i){e=+e,t=+t,i=+i;const o=this.options,{extent:s,debug:n}=o;if(e<0||e>24)return null;const r=1<<e,a=ae(e,t=t+r&r-1,i);if(this.tiles[a])return ee(this.tiles[a],s);n>1&&console.log("drilling down to z%d-%d-%d",e,t,i);let l,c=e,h=t,u=i;for(;!l&&c>0;)c--,h>>=1,u>>=1,l=this.tiles[ae(c,h,u)];return l&&l.source?(n>1&&(console.log("found parent tile z%d-%d-%d",c,h,u),console.time("drilling down")),this.splitTile(l.source,c,h,u,e,t,i),n>1&&console.timeEnd("drilling down"),this.tiles[a]?ee(this.tiles[a],s):null):null}}function ae(e,t,i){return 32*((1<<e)*i+t)+e}class le extends w{constructor(e,t,i,o=ce){super(e,t,i),this._dataUpdateable=new Map,this._createGeoJSONIndex=o;}loadVectorTile(t,i){return e._(this,void 0,void 0,(function*(){const i=t.tileID.canonical;if(!this._geoJSONIndex)throw new Error("Unable to parse the data into a cluster or geojson");const o=this._geoJSONIndex.getTile(i.z,i.x,i.y);return o?y(new r(o.features,{version:2,extent:e.a4})):null}))}loadData(t){return e._(this,void 0,void 0,(function*(){var i;null===(i=this._pendingRequest)||void 0===i||i.abort();const o=this._startPerformance(t);this._pendingRequest=new AbortController;try{(!this._pendingData||t.request||t.data||t.dataDiff)&&(this._pendingData=this.loadAndProcessGeoJSON(t,this._pendingRequest));const i=yield this._pendingData;this._geoJSONIndex=this._createGeoJSONIndex(i,t),this.loaded={};const s=t.dataDiff&&e.a6(i)?{applyDiff:!0}:{data:i};return this._finishPerformance(o,t,s),s}catch(t){if(delete this._pendingRequest,e.cH(t))return {abandoned:!0};throw t}}))}_startPerformance(t){var i;if(null===(i=null==t?void 0:t.request)||void 0===i?void 0:i.collectResourceTiming)return new e.c$(t.request)}_finishPerformance(e,t,i){if(!e)return;const o=e.finish();o&&(i.resourceTiming={},i.resourceTiming[t.source]=JSON.parse(JSON.stringify(o)));}getData(){return e._(this,void 0,void 0,(function*(){return this._pendingData}))}reloadTile(e){const t=this.loaded;return t&&t[e.uid]?super.reloadTile(e):this.loadTile(e)}loadAndProcessGeoJSON(t,i){return e._(this,void 0,void 0,(function*(){let e;if(t.request?e=yield this.loadGeoJSONFromUrl(t.request,t.promoteId,i):t.data?e=this._loadGeoJSONFromObject(t.data,t.promoteId):t.dataDiff&&(e=this._loadGeoJSONFromDiff(t.dataDiff,t.promoteId,t.source)),delete this._pendingRequest,"object"!=typeof e)throw new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`);return M(e,!0),t.filter&&(e=this._filterGeoJSON(e,t.filter)),e}))}loadGeoJSONFromUrl(t,i,o){return e._(this,void 0,void 0,(function*(){const s=yield e.j(t,o);return this._dataUpdateable=e.a6(s.data,i)?e.a7(s.data,i):void 0,s.data}))}_loadGeoJSONFromObject(t,i){return this._dataUpdateable=e.a6(t,i)?e.a7(t,i):void 0,t}_loadGeoJSONFromDiff(t,i,o){if(!this._dataUpdateable)throw new Error(`Cannot update existing geojson data in ${o}`);e.a8(this._dataUpdateable,t,i);const s=Array.from(this._dataUpdateable.values());return this._toFeatureCollection(s)}_filterGeoJSON(t,i){const o=e.d3(i,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===o.result)throw new Error(o.value.map((e=>`${e.key}: ${e.message}`)).join(", "));const s=t.features.filter((e=>o.value.evaluate({zoom:0},e)));return this._toFeatureCollection(s)}_toFeatureCollection(e){return {type:"FeatureCollection",features:e}}removeSource(t){return e._(this,void 0,void 0,(function*(){this._pendingRequest&&this._pendingRequest.abort();}))}getClusterExpansionZoom(e){return this._geoJSONIndex.getClusterExpansionZoom(e.clusterId)}getClusterChildren(e){return this._geoJSONIndex.getChildren(e.clusterId)}getClusterLeaves(e){return this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset)}}function ce(t,i){return i.cluster?new D(function({superclusterOptions:t,clusterProperties:i}){if(!i||!t)return t;const o={},s={},n={accumulated:null,zoom:0},r={properties:null},a=Object.keys(i);for(const t of a){const[n,r]=i[t],a=e.d3(r),l=e.d3("string"==typeof n?[n,["accumulated"],["get",t]]:n);o[t]=a.value,s[t]=l.value;}return t.map=e=>{r.properties=e;const t={};for(const e of a)t[e]=o[e].evaluate(n,r);return t},t.reduce=(e,t)=>{r.properties=t;for(const t of a)n.accumulated=e[t],e[t]=s[t].evaluate(n,r);},t}(i)).load(t.features):function(e,t){return new re(e,t)}(t,i.geojsonVtOptions)}class he{constructor(t){this.self=t,this.actor=new e.L(t),this.layerIndexes={},this.availableImages={},this.workerSources={},this.demWorkerSources={},this.externalWorkerSourceTypes={},this.globalStates=new Map,this.self.registerWorkerSource=(e,t)=>{if(this.externalWorkerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.externalWorkerSourceTypes[e]=t;},this.self.addProtocol=e.cJ,this.self.removeProtocol=e.cK,this.self.registerRTLTextPlugin=t=>{e.d4.setMethods(t);},this.actor.registerMessageHandler("LDT",((e,t)=>this._getDEMWorkerSource(e,t.source).loadTile(t))),this.actor.registerMessageHandler("RDT",((t,i)=>e._(this,void 0,void 0,(function*(){this._getDEMWorkerSource(t,i.source).removeTile(i);})))),this.actor.registerMessageHandler("GCEZ",((t,i)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,i.type,i.source).getClusterExpansionZoom(i)})))),this.actor.registerMessageHandler("GCC",((t,i)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,i.type,i.source).getClusterChildren(i)})))),this.actor.registerMessageHandler("GCL",((t,i)=>e._(this,void 0,void 0,(function*(){return this._getWorkerSource(t,i.type,i.source).getClusterLeaves(i)})))),this.actor.registerMessageHandler("LD",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadData(t))),this.actor.registerMessageHandler("GD",((e,t)=>this._getWorkerSource(e,t.type,t.source).getData())),this.actor.registerMessageHandler("LT",((e,t)=>this._getWorkerSource(e,t.type,t.source).loadTile(t))),this.actor.registerMessageHandler("RT",((e,t)=>this._getWorkerSource(e,t.type,t.source).reloadTile(t))),this.actor.registerMessageHandler("AT",((e,t)=>this._getWorkerSource(e,t.type,t.source).abortTile(t))),this.actor.registerMessageHandler("RMT",((e,t)=>this._getWorkerSource(e,t.type,t.source).removeTile(t))),this.actor.registerMessageHandler("RS",((t,i)=>e._(this,void 0,void 0,(function*(){if(!this.workerSources[t]||!this.workerSources[t][i.type]||!this.workerSources[t][i.type][i.source])return;const e=this.workerSources[t][i.type][i.source];delete this.workerSources[t][i.type][i.source],void 0!==e.removeSource&&e.removeSource(i);})))),this.actor.registerMessageHandler("RM",(t=>e._(this,void 0,void 0,(function*(){delete this.layerIndexes[t],delete this.availableImages[t],delete this.workerSources[t],delete this.demWorkerSources[t],this.globalStates.delete(t);})))),this.actor.registerMessageHandler("SR",((t,i)=>e._(this,void 0,void 0,(function*(){this.referrer=i;})))),this.actor.registerMessageHandler("SRPS",((e,t)=>this._syncRTLPluginState(e,t))),this.actor.registerMessageHandler("IS",((t,i)=>e._(this,void 0,void 0,(function*(){this.self.importScripts(i);})))),this.actor.registerMessageHandler("SI",((e,t)=>this._setImages(e,t))),this.actor.registerMessageHandler("UL",((t,i)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).update(i.layers,i.removedIds,this._getGlobalState(t));})))),this.actor.registerMessageHandler("UGS",((t,i)=>e._(this,void 0,void 0,(function*(){const e=this._getGlobalState(t);for(const t in i)e[t]=i[t];})))),this.actor.registerMessageHandler("SL",((t,i)=>e._(this,void 0,void 0,(function*(){this._getLayerIndex(t).replace(i,this._getGlobalState(t));}))));}_getGlobalState(e){let t=this.globalStates.get(e);return t||(t={},this.globalStates.set(e,t)),t}_setImages(t,i){return e._(this,void 0,void 0,(function*(){this.availableImages[t]=i;for(const e in this.workerSources[t]){const o=this.workerSources[t][e];for(const e in o)o[e].availableImages=i;}}))}_syncRTLPluginState(t,i){return e._(this,void 0,void 0,(function*(){return yield e.d4.syncState(i,this.self.importScripts)}))}_getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}_getLayerIndex(e){let i=this.layerIndexes[e];return i||(i=this.layerIndexes[e]=new t),i}_getWorkerSource(e,t,i){if(this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),!this.workerSources[e][t][i]){const o={sendAsync:(t,i)=>(t.targetMapId=e,this.actor.sendAsync(t,i))};switch(t){case "vector":this.workerSources[e][t][i]=new w(o,this._getLayerIndex(e),this._getAvailableImages(e));break;case "geojson":this.workerSources[e][t][i]=new le(o,this._getLayerIndex(e),this._getAvailableImages(e));break;default:this.workerSources[e][t][i]=new this.externalWorkerSourceTypes[t](o,this._getLayerIndex(e),this._getAvailableImages(e));}}return this.workerSources[e][t][i]}_getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new x),this.demWorkerSources[e][t]}}return e.i(self)&&(self.worker=new he(self)),he}));

define("index",["exports","./shared"],(function(e,t){"use strict";var i="5.13.0";function a(){var e=new t.A(4);return t.A!=Float32Array&&(e[1]=0,e[2]=0),e[0]=1,e[3]=1,e}let r,o,s;const n={frame(e,i,a){const r=requestAnimationFrame((e=>{o(),i(e);})),{unsubscribe:o}=t.s(e.signal,"abort",(()=>{o(),cancelAnimationFrame(r),a(t.c());}),!1);},frameAsync(e){return new Promise(((t,i)=>{this.frame(e,t,i);}))},getImageData(e,t=0){return this.getImageCanvasContext(e).getImageData(-t,-t,e.width+2*t,e.height+2*t)},getImageCanvasContext(e){const t=window.document.createElement("canvas"),i=t.getContext("2d",{willReadFrequently:!0});if(!i)throw new Error("failed to create canvas 2d context");return t.width=e.width,t.height=e.height,i.drawImage(e,0,0,e.width,e.height),i},resolveURL:e=>(r||(r=document.createElement("a")),r.href=e,r.href),hardwareConcurrency:"undefined"!=typeof navigator&&navigator.hardwareConcurrency||4,get prefersReducedMotion(){return void 0!==s?s:!!matchMedia&&(null==o&&(o=matchMedia("(prefers-reduced-motion: reduce)")),o.matches)},set prefersReducedMotion(e){s=e;}},l=new class{constructor(){this._realTime="undefined"!=typeof performance&&performance&&performance.now?performance.now.bind(performance):Date.now.bind(Date),this._frozenAt=null;}getCurrentTime(){return null!==this._frozenAt?this._frozenAt:this._realTime()}setNow(e){this._frozenAt=e;}restoreNow(){this._frozenAt=null;}isFrozen(){return null!==this._frozenAt}};function c(){return l.getCurrentTime()}class h{static testProp(e){if(!h.docStyle)return e[0];for(let t=0;t<e.length;t++)if(e[t]in h.docStyle)return e[t];return e[0]}static create(e,t,i){const a=window.document.createElement(e);return void 0!==t&&(a.className=t),i&&i.appendChild(a),a}static createNS(e,t){return window.document.createElementNS(e,t)}static disableDrag(){h.docStyle&&h.selectProp&&(h.userSelect=h.docStyle[h.selectProp],h.docStyle[h.selectProp]="none");}static enableDrag(){h.docStyle&&h.selectProp&&(h.docStyle[h.selectProp]=h.userSelect);}static setTransform(e,t){e.style[h.transformProp]=t;}static addEventListener(e,t,i,a={}){e.addEventListener(t,i,"passive"in a?a:a.capture);}static removeEventListener(e,t,i,a={}){e.removeEventListener(t,i,"passive"in a?a:a.capture);}static suppressClickInternal(e){e.preventDefault(),e.stopPropagation(),window.removeEventListener("click",h.suppressClickInternal,!0);}static suppressClick(){window.addEventListener("click",h.suppressClickInternal,!0),window.setTimeout((()=>{window.removeEventListener("click",h.suppressClickInternal,!0);}),0);}static getScale(e){const t=e.getBoundingClientRect();return {x:t.width/e.offsetWidth||1,y:t.height/e.offsetHeight||1,boundingClientRect:t}}static getPoint(e,i,a){const r=i.boundingClientRect;return new t.P((a.clientX-r.left)/i.x-e.clientLeft,(a.clientY-r.top)/i.y-e.clientTop)}static mousePos(e,t){const i=h.getScale(e);return h.getPoint(e,i,t)}static touchPos(e,t){const i=[],a=h.getScale(e);for(let r=0;r<t.length;r++)i.push(h.getPoint(e,a,t[r]));return i}static mouseButton(e){return e.button}static remove(e){e.parentNode&&e.parentNode.removeChild(e);}static sanitize(e){const t=(new DOMParser).parseFromString(e,"text/html").body||document.createElement("body"),i=t.querySelectorAll("script");for(const e of i)e.remove();return h.clean(t),t.innerHTML}static isPossiblyDangerous(e,t){const i=t.replace(/\s+/g,"").toLowerCase();return !(!["src","href","xlink:href"].includes(e)||!i.includes("javascript:")&&!i.includes("data:"))||!!e.startsWith("on")||void 0}static clean(e){const t=e.children;for(const e of t)h.removeAttributes(e),h.clean(e);}static removeAttributes(e){for(const{name:t,value:i}of e.attributes)h.isPossiblyDangerous(t,i)&&e.removeAttribute(t);}}h.docStyle="undefined"!=typeof window&&window.document&&window.document.documentElement.style,h.selectProp=h.testProp(["userSelect","MozUserSelect","WebkitUserSelect","msUserSelect"]),h.transformProp=h.testProp(["transform","WebkitTransform"]);const u={supported:!1,testSupport:function(e){!p&&_&&(m?f(e):d=e);}};let d,_,p=!1,m=!1;function f(e){const t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);try{if(e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,_),e.isContextLost())return;u.supported=!0;}catch(e){}e.deleteTexture(t),p=!0;}var g;"undefined"!=typeof document&&(_=document.createElement("img"),_.onload=()=>{d&&f(d),d=null,m=!0;},_.onerror=()=>{p=!0,d=null;},_.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA="),function(e){let i,a,r,o;e.resetRequestQueue=()=>{i=[],a=0,r=0,o={};},e.addThrottleControl=e=>{const t=r++;return o[t]=e,t},e.removeThrottleControl=e=>{delete o[e],n();},e.getImage=(e,a,r=!0)=>new Promise(((o,s)=>{u.supported&&(e.headers||(e.headers={}),e.headers.accept="image/webp,*/*"),t.e(e,{type:"image"}),i.push({abortController:a,requestParameters:e,supportImageRefresh:r,state:"queued",onError:e=>{s(e);},onSuccess:e=>{o(e);}}),n();}));const s=e=>t._(this,void 0,void 0,(function*(){e.state="running";const{requestParameters:i,supportImageRefresh:r,onError:o,onSuccess:s,abortController:c}=e,h=!1===r&&!t.i(self)&&!t.g(i.url)&&(!i.headers||Object.keys(i.headers).reduce(((e,t)=>e&&"accept"===t),!0));a++;const u=h?l(i,c):t.m(i,c);try{const i=yield u;delete e.abortController,e.state="completed",i.data instanceof HTMLImageElement||t.b(i.data)?s(i):i.data&&s({data:yield(d=i.data,"function"==typeof createImageBitmap?t.f(d):t.h(d)),cacheControl:i.cacheControl,expires:i.expires});}catch(t){delete e.abortController,o(t);}finally{a--,n();}var d;})),n=()=>{const e=(()=>{for(const e of Object.keys(o))if(o[e]())return !0;return !1})()?t.a.MAX_PARALLEL_IMAGE_REQUESTS_PER_FRAME:t.a.MAX_PARALLEL_IMAGE_REQUESTS;for(let t=a;t<e&&i.length>0;t++){const e=i.shift();e.abortController.signal.aborted?t--:s(e);}},l=(e,i)=>new Promise(((a,r)=>{const o=new Image,s=e.url,n=e.credentials;n&&"include"===n?o.crossOrigin="use-credentials":(n&&"same-origin"===n||!t.d(s))&&(o.crossOrigin="anonymous"),i.signal.addEventListener("abort",(()=>{o.src="",r(t.c());})),o.fetchPriority="high",o.onload=()=>{o.onerror=o.onload=null,a({data:o});},o.onerror=()=>{o.onerror=o.onload=null,i.signal.aborted||r(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));},o.src=s;}));}(g||(g={})),g.resetRequestQueue();class v{constructor(e){this._transformRequestFn=null!=e?e:null;}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}setTransformRequest(e){this._transformRequestFn=e;}}function x(e){const t=[];if("string"==typeof e)t.push({id:"default",url:e});else if(e&&e.length>0){const i=[];for(const{id:a,url:r}of e){const e=`${a}${r}`;-1===i.indexOf(e)&&(i.push(e),t.push({id:a,url:r}));}}return t}function b(e,t,i){try{const a=new URL(e);return a.pathname+=`${t}${i}`,a.toString()}catch(t){throw new Error(`Invalid sprite URL "${e}", must be absolute. Modify style specification directly or use TransformStyleFunction to correct the issue dynamically`)}}function y(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class w extends t.E{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new t.R({width:1,height:1}),this.dirty=!0;}destroy(){this.atlasTexture&&(this.atlasTexture.destroy(),this.atlasTexture=null);for(const e of Object.keys(this.images))this.removeImage(e);this.patterns={},this.atlasImage=new t.R({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,promiseResolve:t}of this.requestors)t(this._getImagesForIds(e));this.requestors=[];}}getImage(e){const i=this.images[e];if(i&&!i.data&&i.spriteData){const e=i.spriteData;i.data=new t.R({width:e.width,height:e.height},e.context.getImageData(e.x,e.y,e.width,e.height).data),i.spriteData=null;}return i}addImage(e,t){if(this.images[e])throw new Error(`Image id ${e} already exist, use updateImage instead`);this._validate(e,t)&&(this.images[e]=t);}_validate(e,i){let a=!0;const r=i.data||i.spriteData;return this._validateStretch(i.stretchX,r&&r.width)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "stretchX" value`))),a=!1),this._validateStretch(i.stretchY,r&&r.height)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "stretchY" value`))),a=!1),this._validateContent(i.content,i)||(this.fire(new t.k(new Error(`Image "${e}" has invalid "content" value`))),a=!1),a}_validateStretch(e,t){if(!e)return !0;let i=0;for(const a of e){if(a[0]<i||a[1]<a[0]||t<a[1])return !1;i=a[1];}return !0}_validateContent(e,t){if(!e)return !0;if(4!==e.length)return !1;const i=t.spriteData,a=i&&i.width||t.data.width,r=i&&i.height||t.data.height;return !(e[0]<0||a<e[0]||e[1]<0||r<e[1]||e[2]<0||a<e[2]||e[3]<0||r<e[3]||e[2]<e[0]||e[3]<e[1])}updateImage(e,t,i=!0){const a=this.getImage(e);if(i&&(a.data.width!==t.data.width||a.data.height!==t.data.height))throw new Error(`size mismatch between old image (${a.data.width}x${a.data.height}) and new image (${t.data.width}x${t.data.height}).`);t.version=a.version+1,this.images[e]=t,this.updatedImages[e]=!0;}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(e){return new Promise(((t,i)=>{let a=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(a=!1);this.isLoaded()||a?t(this._getImagesForIds(e)):this.requestors.push({ids:e,promiseResolve:t});}))}_getImagesForIds(e){const i={};for(const a of e){let e=this.getImage(a);e||(this.fire(new t.l("styleimagemissing",{id:a})),e=this.getImage(a)),e?i[a]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,textFitWidth:e.textFitWidth,textFitHeight:e.textFitHeight,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:t.w(`Image "${a}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}return i}getPixelSize(){const{width:e,height:t}=this.atlasImage;return {width:e,height:t}}getPattern(e){const i=this.patterns[e],a=this.getImage(e);if(!a)return null;if(i&&i.position.version===a.version)return i.position;if(i)i.position.version=a.version;else {const i={w:a.data.width+2,h:a.data.height+2,x:0,y:0},r=new t.I(i,a);this.patterns[e]={bin:i,position:r};}return this._updatePatternAtlas(),this.patterns[e].position}bind(e){const i=e.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new t.T(e,this.atlasImage,i.RGBA),this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const e=[];for(const t in this.patterns)e.push(this.patterns[t].bin);const{w:i,h:a}=t.p(e),r=this.atlasImage;r.resize({width:i||1,height:a||1});for(const e in this.patterns){const{bin:i}=this.patterns[e],a=i.x+1,o=i.y+1,s=this.getImage(e).data,n=s.width,l=s.height;t.R.copy(s,r,{x:0,y:0},{x:a,y:o},{width:n,height:l}),t.R.copy(s,r,{x:0,y:l-1},{x:a,y:o-1},{width:n,height:1}),t.R.copy(s,r,{x:0,y:0},{x:a,y:o+l},{width:n,height:1}),t.R.copy(s,r,{x:n-1,y:0},{x:a-1,y:o},{width:1,height:l}),t.R.copy(s,r,{x:0,y:0},{x:a+n,y:o},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(e){for(const i of e){if(this.callbackDispatchedThisFrame[i])continue;this.callbackDispatchedThisFrame[i]=!0;const e=this.getImage(i);e||t.w(`Image with ID: "${i}" was not found`),y(e)&&this.updateImage(i,e);}}cloneImages(){const e={};for(const t in this.images){const i=this.images[t];e[t]=Object.assign(Object.assign({},i),{data:i.data?i.data.clone():null});}return e}}const T=1e20;function P(e,t,i,a,r,o,s,n,l){for(let c=t;c<t+a;c++)C(e,i*o+c,o,r,s,n,l);for(let c=i;c<i+r;c++)C(e,c*o+t,1,a,s,n,l);}function C(e,t,i,a,r,o,s){o[0]=0,s[0]=-T,s[1]=T,r[0]=e[t];for(let n=1,l=0,c=0;n<a;n++){r[n]=e[t+n*i];const a=n*n;do{const e=o[l];c=(r[n]-r[e]+a-e*e)/(n-e)/2;}while(c<=s[l]&&--l>-1);l++,o[l]=n,s[l]=c,s[l+1]=T;}for(let n=0,l=0;n<a;n++){for(;s[l+1]<n;)l++;const a=o[l],c=n-a;e[t+n*i]=r[a]+c*c;}}const M=t.v.layout_symbol["text-font"].default.join(",");class I{constructor(e,t,i){this.requestManager=e,this.localIdeographFontFamily=t,this.entries={},this.lang=i;}setURL(e){this.url=e;}getGlyphs(e){return t._(this,void 0,void 0,(function*(){const t=[];for(const i in e)for(const a of e[i])t.push(this._getAndCacheGlyphsPromise(i,a));const i=yield Promise.all(t),a={};for(const{stack:e,id:t,glyph:r}of i)a[e]||(a[e]={}),a[e][t]=r&&{id:r.id,bitmap:r.bitmap.clone(),metrics:r.metrics};return a}))}_getAndCacheGlyphsPromise(e,i){return t._(this,void 0,void 0,(function*(){let t=this.entries[e];t||(t=this.entries[e]={glyphs:{},requests:{},ranges:{}});let a=t.glyphs[i];return void 0!==a?{stack:e,id:i,glyph:a}:!this.url||this._charUsesLocalIdeographFontFamily(i)?(a=t.glyphs[i]=this._drawGlyph(t,e,i),{stack:e,id:i,glyph:a}):yield this._downloadAndCacheRangePromise(e,i)}))}_downloadAndCacheRangePromise(e,i){return t._(this,void 0,void 0,(function*(){const t=this.entries[e],a=Math.floor(i/256);if(t.ranges[a])return {stack:e,id:i,glyph:null};if(!t.requests[a]){const i=I.loadGlyphRange(e,a,this.url,this.requestManager);t.requests[a]=i;}try{const r=yield t.requests[a];for(const e in r)t.glyphs[+e]=r[+e];return t.ranges[a]=!0,{stack:e,id:i,glyph:r[i]||null}}catch(r){const o=t.glyphs[i]=this._drawGlyph(t,e,i);return this._warnOnMissingGlyphRange(o,a,i,r),{stack:e,id:i,glyph:o}}}))}_warnOnMissingGlyphRange(e,i,a,r){const o=256*i,s=o+255,n=a.toString(16).padStart(4,"0").toUpperCase();t.w(`Unable to load glyph range ${i}, ${o}-${s}. Rendering codepoint U+${n} locally instead. ${r}`);}_charUsesLocalIdeographFontFamily(e){return !!this.localIdeographFontFamily&&t.q(e)}_drawGlyph(e,i,a){const r=i===M&&""!==this.localIdeographFontFamily&&this._charUsesLocalIdeographFontFamily(a),o=r?"ideographTinySDF":"tinySDF";e[o]||(e[o]=this._createTinySDF(r?this.localIdeographFontFamily:i));const s=e[o].draw(String.fromCodePoint(a));return {id:a,bitmap:new t.r({width:s.width||60,height:s.height||60},s.data),metrics:{width:s.glyphWidth/2||24,height:s.glyphHeight/2||24,left:s.glyphLeft/2+.5||0,top:s.glyphTop/2-27.5||-8,advance:s.glyphAdvance/2||24,isDoubleResolution:!0}}}_createTinySDF(e){const t=e?e.split(","):[];t.push("sans-serif");const i=t.map((e=>/[-\w]+/.test(e)?e:`'${CSS.escape(e)}'`)).join(",");return new I.TinySDF({fontSize:48,buffer:6,radius:16,cutoff:.25,fontFamily:i,fontWeight:this._fontWeight(t[0]),fontStyle:this._fontStyle(t[0]),lang:this.lang})}_fontStyle(e){return /italic/i.test(e)?"italic":/oblique/i.test(e)?"oblique":"normal"}_fontWeight(e){const t={thin:100,hairline:100,"extra light":200,"ultra light":200,light:300,normal:400,regular:400,medium:500,semibold:600,demibold:600,bold:700,"extra bold":800,"ultra bold":800,black:900,heavy:900,"extra black":950,"ultra black":950};let i;for(const[a,r]of Object.entries(t))new RegExp(`\\b${a}\\b`,"i").test(e)&&(i=`${r}`);return i}destroy(){for(const e in this.entries){const t=this.entries[e];t.tinySDF&&(t.tinySDF=null),t.ideographTinySDF&&(t.ideographTinySDF=null),t.glyphs={},t.requests={},t.ranges={};}this.entries={};}}I.loadGlyphRange=function(e,i,a,r){return t._(this,void 0,void 0,(function*(){const o=256*i,s=o+255,n=r.transformRequest(a.replace("{fontstack}",e).replace("{range}",`${o}-${s}`),"Glyphs"),l=yield t.n(n,new AbortController);if(!l||!l.data)throw new Error(`Could not load glyph range. range: ${i}, ${o}-${s}`);const c={};for(const e of t.o(l.data))c[e.id]=e;return c}))},I.TinySDF=class{constructor({fontSize:e=24,buffer:t=3,radius:i=8,cutoff:a=.25,fontFamily:r="sans-serif",fontWeight:o="normal",fontStyle:s="normal",lang:n=null}={}){this.buffer=t,this.cutoff=a,this.radius=i,this.lang=n;const l=this.size=e+4*t,c=this._createCanvas(l),h=this.ctx=c.getContext("2d",{willReadFrequently:!0});h.font=`${s} ${o} ${e}px ${r}`,h.textBaseline="alphabetic",h.textAlign="left",h.fillStyle="black",this.gridOuter=new Float64Array(l*l),this.gridInner=new Float64Array(l*l),this.f=new Float64Array(l),this.z=new Float64Array(l+1),this.v=new Uint16Array(l);}_createCanvas(e){const t=document.createElement("canvas");return t.width=t.height=e,t}draw(e){const{width:t,actualBoundingBoxAscent:i,actualBoundingBoxDescent:a,actualBoundingBoxLeft:r,actualBoundingBoxRight:o}=this.ctx.measureText(e),s=Math.ceil(i),n=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(o-r))),l=Math.min(this.size-this.buffer,s+Math.ceil(a)),c=n+2*this.buffer,h=l+2*this.buffer,u=Math.max(c*h,0),d=new Uint8ClampedArray(u),_={data:d,width:c,height:h,glyphWidth:n,glyphHeight:l,glyphTop:s,glyphLeft:0,glyphAdvance:t};if(0===n||0===l)return _;const{ctx:p,buffer:m,gridInner:f,gridOuter:g}=this;this.lang&&(p.lang=this.lang),p.clearRect(m,m,n,l),p.fillText(e,m,m+s);const v=p.getImageData(m,m,n,l);g.fill(T,0,u),f.fill(0,0,u);for(let e=0;e<l;e++)for(let t=0;t<n;t++){const i=v.data[4*(e*n+t)+3]/255;if(0===i)continue;const a=(e+m)*c+t+m;if(1===i)g[a]=0,f[a]=T;else {const e=.5-i;g[a]=e>0?e*e:0,f[a]=e<0?e*e:0;}}P(g,0,0,c,h,c,this.f,this.v,this.z),P(f,m,m,n,l,c,this.f,this.v,this.z);for(let e=0;e<u;e++){const t=Math.sqrt(g[e])-Math.sqrt(f[e]);d[e]=Math.round(255-255*(t/this.radius+this.cutoff));}return _}};class E{constructor(){this.specification=t.u.light.position;}possiblyEvaluate(e,i){return t.F(e.expression.evaluate(i))}interpolate(e,i,a){return {x:t.G.number(e.x,i.x,a),y:t.G.number(e.y,i.y,a),z:t.G.number(e.z,i.z,a)}}}let S;class R extends t.E{constructor(e){super(),S=S||new t.t({anchor:new t.D(t.u.light.anchor),position:new E,color:new t.D(t.u.light.color),intensity:new t.D(t.u.light.intensity)}),this._transitionable=new t.x(S,void 0),this.setLight(e),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(e,i={}){if(!this._validate(t.y,e,i))for(const i in e){const a=e[i];i.endsWith(t.z)?this._transitionable.setTransition(i.slice(0,-t.z.length),a):this._transitionable.setValue(i,a);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,a){return (!a||!1!==a.validate)&&t.B(this,e.call(t.C,{value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.u}))}}const D=new t.t({"sky-color":new t.D(t.u.sky["sky-color"]),"horizon-color":new t.D(t.u.sky["horizon-color"]),"fog-color":new t.D(t.u.sky["fog-color"]),"fog-ground-blend":new t.D(t.u.sky["fog-ground-blend"]),"horizon-fog-blend":new t.D(t.u.sky["horizon-fog-blend"]),"sky-horizon-blend":new t.D(t.u.sky["sky-horizon-blend"]),"atmosphere-blend":new t.D(t.u.sky["atmosphere-blend"])});class z extends t.E{constructor(e){super(),this._transitionable=new t.x(D,void 0),this.setSky(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.H(0));}setSky(e,i={}){if(!this._validate(t.J,e,i)){e||(e={"sky-color":"transparent","horizon-color":"transparent","fog-color":"transparent","fog-ground-blend":1,"atmosphere-blend":0});for(const i in e){const a=e[i];i.endsWith(t.z)?this._transitionable.setTransition(i.slice(0,-t.z.length),a):this._transitionable.setValue(i,a);}}}getSky(){return this._transitionable.serialize()}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(e,i,a={}){return !1!==(null==a?void 0:a.validate)&&t.B(this,e.call(t.C,t.e({value:i,style:{glyphs:!0,sprite:!0},styleSpec:t.u})))}calculateFogBlendOpacity(e){return e<60?0:e<70?(e-60)/10:1}}class A{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(e,t){const i=e.join(",")+String(t);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(e,t)),this.dashEntry[i]}getDashRanges(e,t,i){const a=[];let r=e.length%2==1?-e[e.length-1]*i:0,o=e[0]*i,s=!0;a.push({left:r,right:o,isDash:s,zeroLength:0===e[0]});let n=e[0];for(let t=1;t<e.length;t++){s=!s;const l=e[t];r=n*i,n+=l,o=n*i,a.push({left:r,right:o,isDash:s,zeroLength:0===l});}return a}addRoundDash(e,t,i){const a=t/2;for(let t=-i;t<=i;t++){const r=this.width*(this.nextRow+i+t);let o=0,s=e[o];for(let n=0;n<this.width;n++){n/s.right>1&&(s=e[++o]);const l=Math.abs(n-s.left),c=Math.abs(n-s.right),h=Math.min(l,c);let u;const d=t/i*(a+1);if(s.isDash){const e=a-Math.abs(d);u=Math.sqrt(h*h+e*e);}else u=a-Math.sqrt(h*h+d*d);this.data[r+n]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(e){for(let t=e.length-1;t>=0;--t){const i=e[t],a=e[t+1];i.zeroLength?e.splice(t,1):a&&a.isDash===i.isDash&&(a.left=i.left,e.splice(t,1));}const t=e[0],i=e[e.length-1];t.isDash===i.isDash&&(t.left=i.left-this.width,i.right=t.right+this.width);const a=this.width*this.nextRow;let r=0,o=e[r];for(let t=0;t<this.width;t++){t/o.right>1&&(o=e[++r]);const i=Math.abs(t-o.left),s=Math.abs(t-o.right),n=Math.min(i,s);this.data[a+t]=Math.max(0,Math.min(255,(o.isDash?n:-n)+128));}}addDash(e,i){const a=i?7:0,r=2*a+1;if(this.nextRow+r>this.height)return t.w("LineAtlas out of space"),null;let o=0;for(let t=0;t<e.length;t++)o+=e[t];if(0!==o){const t=this.width/o,r=this.getDashRanges(e,this.width,t);i?this.addRoundDash(r,t,a):this.addRegularDash(r);}const s={y:this.nextRow+a,height:2*a,width:o};return this.nextRow+=r,this.dirty=!0,s}bind(e){const t=e.gl;this.texture?(t.bindTexture(t.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,t.texSubImage2D(t.TEXTURE_2D,0,0,0,this.width,this.height,t.ALPHA,t.UNSIGNED_BYTE,this.data))):(this.texture=t.createTexture(),t.bindTexture(t.TEXTURE_2D,this.texture),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texImage2D(t.TEXTURE_2D,0,t.ALPHA,this.width,this.height,0,t.ALPHA,t.UNSIGNED_BYTE,this.data));}}const L="maplibre_preloaded_worker_pool";class k{constructor(){this.active={};}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<k.workerCount;)this.workers.push(new Worker(t.a.WORKER_URL));return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach((e=>{e.terminate();})),this.workers=null);}isPreloaded(){return !!this.active[L]}numActive(){return Object.keys(this.active).length}}const F=Math.floor(n.hardwareConcurrency/2);let B,O;function j(){return B||(B=new k),B}k.workerCount=t.K(globalThis)?Math.max(Math.min(F,3),1):1;class N{constructor(e,i){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=i;const a=this.workerPool.acquire(i);for(let e=0;e<a.length;e++){const r=new t.L(a[e],i);r.name=`Worker ${e}`,this.actors.push(r);}if(!this.actors.length)throw new Error("No actors found")}broadcast(e,t){const i=[];for(const a of this.actors)i.push(a.sendAsync({type:e,data:t}));return Promise.all(i)}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(e=!0){this.actors.forEach((e=>{e.remove();})),this.actors=[],e&&this.workerPool.release(this.id);}registerMessageHandler(e,t){for(const i of this.actors)i.registerMessageHandler(e,t);}unregisterMessageHandler(e){for(const t of this.actors)t.unregisterMessageHandler(e);}}function Z(){return O||(O=new N(j(),t.M),O.registerMessageHandler("GR",((e,i,a)=>t.m(i,a)))),O}function G(e,i){const a=t.N();return t.O(a,a,[1,1,0]),t.Q(a,a,[.5*e.width,.5*e.height,1]),e.calculatePosMatrix?t.S(a,a,e.calculatePosMatrix(i.toUnwrapped())):a}function U(e,t,i,a,r,o,s){var n;const l=function(e,t,i){if(e)for(const a of e){const e=t[a];if(e&&e.source===i&&"fill-extrusion"===e.type)return !0}else for(const e in t){const a=t[e];if(a.source===i&&"fill-extrusion"===a.type)return !0}return !1}(null!==(n=null==r?void 0:r.layers)&&void 0!==n?n:null,t,e.id),c=o.maxPitchScaleFactor(),h=e.tilesIn(a,c,l);h.sort(V);const u=[];for(const a of h)u.push({wrappedTileID:a.tileID.wrapped().key,queryResults:a.tile.queryRenderedFeatures(t,i,e.getState(),a.queryGeometry,a.cameraQueryGeometry,a.scale,r,o,c,G(o,a.tileID),s?(e,t)=>s(a.tileID,e,t):void 0)});return function(e,t){for(const i in e)for(const a of e[i])q(a,t);return e}(function(e){const t={},i={};for(const a of e){const e=a.queryResults,r=a.wrappedTileID,o=i[r]=i[r]||{};for(const i in e){const a=e[i],r=o[i]=o[i]||{},s=t[i]=t[i]||[];for(const e of a)r[e.featureIndex]||(r[e.featureIndex]=!0,s.push(e));}}return t}(u),e)}function V(e,t){const i=e.tileID,a=t.tileID;return i.overscaledZ-a.overscaledZ||i.canonical.y-a.canonical.y||i.wrap-a.wrap||i.canonical.x-a.canonical.x}function q(e,t){const i=e.feature,a=t.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=a;}function W(e,i,a){return t._(this,void 0,void 0,(function*(){let r=e;if(e.url?r=(yield t.j(i.transformRequest(e.url,"Source"),a)).data:yield n.frameAsync(a),!r)return null;const o=t.U(t.e(r,e),["tiles","minzoom","maxzoom","attribution","bounds","scheme","tileSize","encoding"]);return "vector_layers"in r&&r.vector_layers&&(o.vectorLayerIds=r.vector_layers.map((e=>e.id))),o}))}class ${constructor(e,t){e&&(t?this.setSouthWest(e).setNorthEast(t):Array.isArray(e)&&(4===e.length?this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]):this.setSouthWest(e[0]).setNorthEast(e[1])));}setNorthEast(e){return this._ne=e instanceof t.V?new t.V(e.lng,e.lat):t.V.convert(e),this}setSouthWest(e){return this._sw=e instanceof t.V?new t.V(e.lng,e.lat):t.V.convert(e),this}extend(e){const i=this._sw,a=this._ne;let r,o;if(e instanceof t.V)r=e,o=e;else {if(!(e instanceof $))return Array.isArray(e)?4===e.length||e.every(Array.isArray)?this.extend($.convert(e)):this.extend(t.V.convert(e)):e&&("lng"in e||"lon"in e)&&"lat"in e?this.extend(t.V.convert(e)):this;if(r=e._sw,o=e._ne,!r||!o)return this}return i||a?(i.lng=Math.min(r.lng,i.lng),i.lat=Math.min(r.lat,i.lat),a.lng=Math.max(o.lng,a.lng),a.lat=Math.max(o.lat,a.lat)):(this._sw=new t.V(r.lng,r.lat),this._ne=new t.V(o.lng,o.lat)),this}getCenter(){return new t.V((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new t.V(this.getWest(),this.getNorth())}getSouthEast(){return new t.V(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(e){const{lng:i,lat:a}=t.V.convert(e);let r=this._sw.lng<=i&&i<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=i&&i>=this._ne.lng),this._sw.lat<=a&&a<=this._ne.lat&&r}intersects(e){if((e=$.convert(e)).getNorth()<this.getSouth()||e.getSouth()>this.getNorth())return !1;const i=t.W(this.getWest(),-180,180),a=t.W(this.getEast(),-180,180),r=t.W(e.getWest(),-180,180),o=t.W(e.getEast(),-180,180),s=i>a,n=r>o;return !(!s||!n)||(s?o>=i||r<=a:n?a>=r||i<=o:!(r>a||o<i))}static convert(e){return e instanceof $?e:e?new $(e):e}static fromLngLat(e,i=0){const a=360*i/40075017,r=a/Math.cos(Math.PI/180*e.lat);return new $(new t.V(e.lng-r,e.lat-a),new t.V(e.lng+r,e.lat+a))}adjustAntiMeridian(){const e=new t.V(this._sw.lng,this._sw.lat),i=new t.V(this._ne.lng,this._ne.lat);return new $(e,e.lng>i.lng?new t.V(i.lng+360,i.lat):i)}}class H{constructor(e,t,i){this.bounds=$.convert(this.validateBounds(e)),this.minzoom=t||0,this.maxzoom=i||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(e){const i=Math.pow(2,e.z),a=Math.floor(t.Y(this.bounds.getWest())*i),r=Math.floor(t.X(this.bounds.getNorth())*i),o=Math.ceil(t.Y(this.bounds.getEast())*i),s=Math.ceil(t.X(this.bounds.getSouth())*i);return e.x>=a&&e.x<o&&e.y>=r&&e.y<s}}class X extends t.E{constructor(e,i,a,r){if(super(),this.id=e,this.dispatcher=a,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,t.e(this,t.U(i,["url","scheme","tileSize","promoteId","encoding"])),this._options=t.e({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r);}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const e=yield W(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,this.map.style.tileManagers[this.id].clearTiles(),e&&(t.e(this,e),e.bounds&&(this.tileBounds=new H(e.bounds,this.minzoom,this.maxzoom)),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.l("data",{dataType:"source",sourceDataType:"content"})));}catch(e){this._tileJSONRequest=null,this._loaded=!0,this.fire(new t.k(e));}}))}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}setSourceProperty(e){this._tileJSONRequest&&this._tileJSONRequest.abort(),e(),this.load();}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}serialize(){return t.e({},this._options)}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),i={request:this.map._requestManager.transformRequest(t,"Tile"),uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity,encoding:this.encoding,overzoomParameters:this._getOverzoomParameters(e)};i.request.collectResourceTiming=this._collectResourceTiming;let a="RT";if(e.actor&&"expired"!==e.state){if("loading"===e.state)return new Promise(((t,i)=>{e.reloadPromise={resolve:t,reject:i};}))}else e.actor=this.dispatcher.getActor(),a="LT";e.abortController=new AbortController;try{const t=yield e.actor.sendAsync({type:a,data:i},e.abortController);if(delete e.abortController,e.aborted)return;this._afterTileLoadWorkerResponse(e,t);}catch(t){if(delete e.abortController,e.aborted)return;if(t&&404!==t.status)throw t;this._afterTileLoadWorkerResponse(e,null);}}))}_getOverzoomParameters(e){if(e.tileID.canonical.z<=this.maxzoom)return;if(void 0===this.map._zoomLevelsToOverscale)return;const t=e.tileID.scaledTo(this.maxzoom).canonical,i=t.url(this.tiles,this.map.getPixelRatio(),this.scheme);return {maxZoomTileID:t,overzoomRequest:this.map._requestManager.transformRequest(i,"Tile")}}_afterTileLoadWorkerResponse(e,t){if(t&&t.resourceTiming&&(e.resourceTiming=t.resourceTiming),t&&this.map._refreshExpiredTiles&&e.setExpiryData(t),e.loadVectorData(t,this.map.painter),e.reloadPromise){const t=e.reloadPromise;e.reloadPromise=null,this.loadTile(e).then(t.resolve).catch(t.reject);}}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.actor&&(yield e.actor.sendAsync({type:"AT",data:{uid:e.uid,type:this.type,source:this.id}}));}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.unloadVectorData(),e.actor&&(yield e.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}}));}))}hasTransition(){return !1}}class K extends t.E{constructor(e,i,a,r){super(),this.id=e,this.dispatcher=a,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=t.e({type:"raster"},i),t.e(this,t.U(i,["url","scheme","tileSize"]));}load(){return t._(this,arguments,void 0,(function*(e=!1){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this._tileJSONRequest=new AbortController;try{const i=yield W(this._options,this.map._requestManager,this._tileJSONRequest);this._tileJSONRequest=null,this._loaded=!0,i&&(t.e(this,i),i.bounds&&(this.tileBounds=new H(i.bounds,this.minzoom,this.maxzoom)),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new t.l("data",{dataType:"source",sourceDataType:"content",sourceDataChanged:e})));}catch(e){this._tileJSONRequest=null,this._loaded=!0,this.fire(new t.k(e));}}))}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null);}setSourceProperty(e){this._tileJSONRequest&&(this._tileJSONRequest.abort(),this._tileJSONRequest=null),e(),this.load(!0);}setTiles(e){return this.setSourceProperty((()=>{this._options.tiles=e;})),this}setUrl(e){return this.setSourceProperty((()=>{this.url=e,this._options.url=e;})),this}serialize(){return t.e({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e){return t._(this,void 0,void 0,(function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme);e.abortController=new AbortController;try{const a=yield g.getImage(this.map._requestManager.transformRequest(i,"Tile"),e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(a&&a.data){this.map._refreshExpiredTiles&&(a.cacheControl||a.expires)&&e.setExpiryData({cacheControl:a.cacheControl,expires:a.expires});const i=this.map.painter.context,r=i.gl,o=a.data;e.texture=this.map.painter.getTileTexture(o.width),e.texture?e.texture.update(o,{useMipmap:!0}):(e.texture=new t.T(i,o,r.RGBA,{useMipmap:!0}),e.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST)),e.state="loaded";}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController);}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.texture&&this.map.painter.saveTileTexture(e.texture);}))}hasTransition(){return !1}}class Y extends K{constructor(e,i,a,r){super(e,i,a,r),this.type="raster-dem",this.maxzoom=22,this._options=t.e({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox",this.redFactor=i.redFactor,this.greenFactor=i.greenFactor,this.blueFactor=i.blueFactor,this.baseShift=i.baseShift;}loadTile(e){return t._(this,void 0,void 0,(function*(){const i=e.tileID.canonical.url(this.tiles,this.map.getPixelRatio(),this.scheme),a=this.map._requestManager.transformRequest(i,"Tile");e.neighboringTiles=this._getNeighboringTiles(e.tileID),e.abortController=new AbortController;try{const i=yield g.getImage(a,e.abortController,this.map._refreshExpiredTiles);if(delete e.abortController,e.aborted)return void(e.state="unloaded");if(i&&i.data){const a=i.data;this.map._refreshExpiredTiles&&(i.cacheControl||i.expires)&&e.setExpiryData({cacheControl:i.cacheControl,expires:i.expires});const r=t.b(a)&&t.Z()?a:yield this.readImageNow(a),o={type:this.type,uid:e.uid,source:this.id,rawImageData:r,encoding:this.encoding,redFactor:this.redFactor,greenFactor:this.greenFactor,blueFactor:this.blueFactor,baseShift:this.baseShift};if(!e.actor||"expired"===e.state){e.actor=this.dispatcher.getActor();const t=yield e.actor.sendAsync({type:"LDT",data:o});e.dem=t,e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0,e.state="loaded";}}}catch(t){if(delete e.abortController,e.aborted)e.state="unloaded";else if(t)throw e.state="errored",t}}))}readImageNow(e){return t._(this,void 0,void 0,(function*(){if("undefined"!=typeof VideoFrame&&t.$()){const i=e.width+2,a=e.height+2;try{return new t.R({width:i,height:a},yield t.a0(e,-1,-1,i,a))}catch(e){}}return n.getImageData(e,1)}))}_getNeighboringTiles(e){const i=e.canonical,a=Math.pow(2,i.z),r=(i.x-1+a)%a,o=0===i.x?e.wrap-1:e.wrap,s=(i.x+1+a)%a,n=i.x+1===a?e.wrap+1:e.wrap,l={};return l[new t.a1(e.overscaledZ,o,i.z,r,i.y).key]={backfilled:!1},l[new t.a1(e.overscaledZ,n,i.z,s,i.y).key]={backfilled:!1},i.y>0&&(l[new t.a1(e.overscaledZ,o,i.z,r,i.y-1).key]={backfilled:!1},l[new t.a1(e.overscaledZ,e.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new t.a1(e.overscaledZ,n,i.z,s,i.y-1).key]={backfilled:!1}),i.y+1<a&&(l[new t.a1(e.overscaledZ,o,i.z,r,i.y+1).key]={backfilled:!1},l[new t.a1(e.overscaledZ,e.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new t.a1(e.overscaledZ,n,i.z,s,i.y+1).key]={backfilled:!1}),l}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded",e.actor&&(yield e.actor.sendAsync({type:"RDT",data:{type:this.type,uid:e.uid,source:this.id}}));}))}}function Q(e){return "GeometryCollection"===e.type?e.geometries.map((e=>e.coordinates)).flat(1/0):e.coordinates.flat(1/0)}function J(e){const t=new $;let i;switch(e.type){case "FeatureCollection":i=e.features.map((e=>Q(e.geometry))).flat(1/0);break;case "Feature":i=Q(e.geometry);break;default:i=Q(e);}if(0==i.length)return t;for(let e=0;e<i.length-1;e+=2)t.extend([i[e],i[e+1]]);return t}class ee extends t.E{constructor(e,i,a,r){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._isUpdatingWorker=!1,this._pendingWorkerUpdate={data:i.data},this.actor=a.getActor(),this.setEventedParent(r),this._data="string"==typeof i.data?{url:i.data}:{geojson:i.data},this._options=t.e({},i),this._collectResourceTiming=i.collectResourceTiming,void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId,void 0!==i.clusterMaxZoom&&this.maxzoom<=i.clusterMaxZoom&&t.w(`The maxzoom value "${this.maxzoom}" is expected to be greater than the clusterMaxZoom value "${i.clusterMaxZoom}".`),this.workerOptions=t.e({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:this._pixelsToTileUnits(void 0!==i.buffer?i.buffer:128),tolerance:this._pixelsToTileUnits(void 0!==i.tolerance?i.tolerance:.375),extent:t.a4,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:this._getClusterMaxZoom(i.clusterMaxZoom),minPoints:Math.max(2,i.clusterMinPoints||2),extent:t.a4,radius:this._pixelsToTileUnits(i.clusterRadius||50),log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions),"string"==typeof this.promoteId&&(this.workerOptions.promoteId=this.promoteId);}_hasPendingWorkerUpdate(){return void 0!==this._pendingWorkerUpdate.data||void 0!==this._pendingWorkerUpdate.diff||this._pendingWorkerUpdate.optionsChanged}_pixelsToTileUnits(e){return e*(t.a4/this.tileSize)}_getClusterMaxZoom(e){const i=e?Math.round(e):this.maxzoom-1;return Number.isInteger(e)||void 0===e||t.w(`Integer expected for option 'clusterMaxZoom': provided value "${e}" rounded to "${i}"`),i}load(){return t._(this,void 0,void 0,(function*(){yield this._updateWorkerData();}))}onAdd(e){this.map=e,this.load();}setData(e,t){this._data="string"==typeof e?{url:e}:{geojson:e},this._pendingWorkerUpdate={data:e};const i=this._updateWorkerData();return t?i:this}updateData(e,i){this._pendingWorkerUpdate.diff=t.a5(this._pendingWorkerUpdate.diff,e);const a=this._updateWorkerData();return i?a:this}getData(){return t._(this,void 0,void 0,(function*(){const e=t.e({type:this.type},this.workerOptions);return this.actor.sendAsync({type:"GD",data:e})}))}getBounds(){return t._(this,void 0,void 0,(function*(){return J(yield this.getData())}))}setClusterOptions(e){return this.workerOptions.cluster=e.cluster,void 0!==e.clusterRadius&&(this.workerOptions.superclusterOptions.radius=this._pixelsToTileUnits(e.clusterRadius)),void 0!==e.clusterMaxZoom&&(this.workerOptions.superclusterOptions.maxZoom=this._getClusterMaxZoom(e.clusterMaxZoom)),this._pendingWorkerUpdate.optionsChanged=!0,this._updateWorkerData(),this}getClusterExpansionZoom(e){return this.actor.sendAsync({type:"GCEZ",data:{type:this.type,clusterId:e,source:this.id}})}getClusterChildren(e){return this.actor.sendAsync({type:"GCC",data:{type:this.type,clusterId:e,source:this.id}})}getClusterLeaves(e,t,i){return this.actor.sendAsync({type:"GCL",data:{type:this.type,source:this.id,clusterId:e,limit:t,offset:i}})}_updateWorkerData(){return t._(this,void 0,void 0,(function*(){if(this._isUpdatingWorker)return;if(!this._hasPendingWorkerUpdate())return void t.w(`No pending worker updates for GeoJSONSource ${this.id}.`);const{data:e,diff:i}=this._pendingWorkerUpdate,a=t.e({type:this.type},this.workerOptions);e?("string"==typeof e?(a.request=this.map._requestManager.transformRequest(n.resolveURL(e),"Source"),a.request.collectResourceTiming=this._collectResourceTiming):a.data=e,this._pendingWorkerUpdate.data=void 0):i&&(a.dataDiff=i,this._pendingWorkerUpdate.diff=void 0),this._pendingWorkerUpdate.optionsChanged=void 0,this._isUpdatingWorker=!0,this.fire(new t.l("dataloading",{dataType:"source"}));try{const e=yield this.actor.sendAsync({type:"LD",data:a});if(this._isUpdatingWorker=!1,this._removed||e.abandoned)return void this.fire(new t.l("dataabort",{dataType:"source"}));e.applyDiff?this._applyDiff(i):this._data={geojson:e.data};let r=null;e.resourceTiming&&e.resourceTiming[this.id]&&(r=e.resourceTiming[this.id].slice(0));const o={dataType:"source"};this._collectResourceTiming&&r&&r.length>0&&t.e(o,{resourceTiming:r}),this.fire(new t.l("data",Object.assign(Object.assign({},o),{sourceDataType:"metadata"}))),this.fire(new t.l("data",Object.assign(Object.assign({},o),{sourceDataType:"content",shouldReloadTileOptions:this._getShouldReloadTileOptions(i)})));}catch(e){if(this._isUpdatingWorker=!1,this._removed)return void this.fire(new t.l("dataabort",{dataType:"source"}));this.fire(new t.k(e));}finally{this._hasPendingWorkerUpdate()&&this._updateWorkerData();}}))}_applyDiff(e){const i="string"==typeof this.promoteId?this.promoteId:void 0;this._data.url||this._data.updateable||!t.a6(this._data.geojson,i)||(this._data={updateable:t.a7(this._data.geojson,i)}),e&&this._data.updateable?t.a8(this._data.updateable,e,i):t.w("Cannot apply GeoJSONSource#updateData due to internal error");}_getShouldReloadTileOptions(e){if(this._options.cluster||!e||e.removeAll)return;const{add:i=[],update:a=[],remove:r=[]}=e||{},o=new Set([...a.map((e=>e.id)),...r]);for(const e of o.values())if("number"!=typeof e&&null==this.promoteId)return void t.w(`GeoJSONSource "${this.id}": updateData is slower when using string GeoJSON feature IDs (e.g. "${e}"). Consider using promoteId or numeric IDs for better performance.`);return {nextBounds:[...a.map((e=>e.newGeometry)),...i.map((e=>e.geometry))].filter(Boolean).map((e=>J(e))),prevIds:o}}shouldReloadTile(e,{nextBounds:i,prevIds:a}){if(!e.latestFeatureIndex)return "unloaded"!==e.state;const r=e.latestFeatureIndex.loadVTLayers();for(let i=0;i<e.latestFeatureIndex.featureIndexArray.length;i++){const o=e.latestFeatureIndex.featureIndexArray.get(i),s=r[t.a9].feature(o.featureIndex),n=e.latestFeatureIndex.getId(s,t.a9);if(a.has(n))return !0}const{buffer:o,extent:s}=this.workerOptions.geojsonVtOptions,n=function({x:e,y:i,z:a},r=0){const o=t.a2((e-r)/Math.pow(2,a)),s=t.a3((i+1+r)/Math.pow(2,a)),n=t.a2((e+1+r)/Math.pow(2,a)),l=t.a3((i-r)/Math.pow(2,a));return new $([o,s],[n,l])}(e.tileID.canonical,o/s);for(const e of i)if(n.intersects(e))return !0;return !1}loaded(){return !this._isUpdatingWorker&&!this._hasPendingWorkerUpdate()}loadTile(e){return t._(this,void 0,void 0,(function*(){const t=e.actor?"RT":"LT";e.actor=this.actor;const i={type:this.type,uid:e.uid,tileID:e.tileID,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:this.map.getPixelRatio(),showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,subdivisionGranularity:this.map.style.projection.subdivisionGranularity};e.abortController=new AbortController;const a=yield this.actor.sendAsync({type:t,data:i},e.abortController);delete e.abortController,e.unloadVectorData(),e.aborted||e.loadVectorData(a,this.map.painter,"RT"===t);}))}abortTile(e){return t._(this,void 0,void 0,(function*(){e.abortController&&(e.abortController.abort(),delete e.abortController),e.aborted=!0;}))}unloadTile(e){return t._(this,void 0,void 0,(function*(){e.unloadVectorData(),yield this.actor.sendAsync({type:"RMT",data:{uid:e.uid,type:this.type,source:this.id}});}))}onRemove(){this._removed=!0,this.actor.sendAsync({type:"RS",data:{type:this.type,source:this.id}});}serialize(){return t.e({},this._options,{type:this.type,data:this._data.updateable?{type:"FeatureCollection",features:Array.from(this._data.updateable.values())}:this._data.url||this._data.geojson})}hasTransition(){return !1}}class te extends t.E{constructor(e,t,i,a){super(),this.flippedWindingOrder=!1,this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(a),this.options=t;}load(e){return t._(this,void 0,void 0,(function*(){this._loaded=!1,this.fire(new t.l("dataloading",{dataType:"source"})),this.url=this.options.url,this._request=new AbortController;try{const t=yield g.getImage(this.map._requestManager.transformRequest(this.url,"Image"),this._request);this._request=null,this._loaded=!0,t&&t.data&&(this.image=t.data,e&&(this.coordinates=e),this._finishLoading());}catch(e){this._request=null,this._loaded=!0,this.fire(new t.k(e));}}))}loaded(){return this._loaded}updateImage(e){return e.url?(this._request&&(this._request.abort(),this._request=null),this.options.url=e.url,this.load(e.coordinates).finally((()=>{this.texture=null;})),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new t.l("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(e){this.map=e,this.load();}onRemove(){this._request&&(this._request.abort(),this._request=null);}setCoordinates(e){this.coordinates=e;const i=e.map(t.aa.fromLngLat);var a;return this.tileID=function(e){const i=t.ab.fromPoints(e),a=i.width(),r=i.height(),o=Math.max(a,r),s=Math.max(0,Math.floor(-Math.log(o)/Math.LN2)),n=Math.pow(2,s);return new t.ad(s,Math.floor((i.minX+i.maxX)/2*n),Math.floor((i.minY+i.maxY)/2*n))}(i),this.terrainTileRanges=this._getOverlappingTileRanges(i),this.minzoom=this.maxzoom=this.tileID.z,this.tileCoords=i.map((e=>this.tileID.getTilePoint(e)._round())),this.flippedWindingOrder=((a=this.tileCoords)[1].x-a[0].x)*(a[2].y-a[0].y)-(a[1].y-a[0].y)*(a[2].x-a[0].x)<0,this.fire(new t.l("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const e=this.map.painter.context,i=e.gl;this.texture||(this.texture=new t.T(e,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let a=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,a=!0);}a&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}loadTile(e){return t._(this,void 0,void 0,(function*(){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={}):e.state="errored";}))}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}_getOverlappingTileRanges(e){const{minX:i,minY:a,maxX:r,maxY:o}=t.ab.fromPoints(e),s={};for(let e=0;e<=t.ac;e++){const t=Math.pow(2,e),n=Math.floor(i*t),l=Math.floor(a*t),c=Math.floor(r*t),h=Math.floor(o*t);s[e]={minTileX:n,minTileY:l,maxTileX:c,maxTileY:h};}return s}}class ie extends te{constructor(e,t,i,a){super(e,t,i,a),this.roundZoom=!0,this.type="video",this.options=t;}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!1;const e=this.options;this.urls=[];for(const t of e.urls)this.urls.push(this.map._requestManager.transformRequest(t,"Source").url);try{const e=yield t.ae(this.urls);if(this._loaded=!0,!e)return;this.video=e,this.video.loop=!0,this.video.addEventListener("playing",(()=>{this.map.triggerRepaint();})),this.map&&this.video.play(),this._finishLoading();}catch(e){this.fire(new t.k(e));}}))}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(e){if(this.video){const i=this.video.seekable;e<i.start(0)||e>i.end(0)?this.fire(new t.k(new t.af(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=e;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,i=e.gl;this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new t.T(e,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));let a=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,a=!0);}a&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}}class ae extends te{constructor(e,i,a,r){super(e,i,a,r),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new t.k(new t.af(`sources.${e}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new t.k(new t.af(`sources.${e}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new t.k(new t.af(`sources.${e}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof HTMLCanvasElement||this.fire(new t.k(new t.af(`sources.${e}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new t.k(new t.af(`sources.${e}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){return t._(this,void 0,void 0,(function*(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof HTMLCanvasElement?this.options.canvas:document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new t.k(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}))}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,a=i.gl;this.texture?(e||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new t.T(i,this.canvas,a.RGBA,{premultiply:!0});let r=!1;for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture,r=!0);}r&&this.fire(new t.l("data",{dataType:"source",sourceDataType:"idle",sourceId:this.id}));}serialize(){return {type:"canvas",animate:this.animate,canvas:this.options.canvas,coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}}const re={},oe=e=>{switch(e){case "geojson":return ee;case "image":return te;case "raster":return K;case "raster-dem":return Y;case "vector":return X;case "video":return ie;case "canvas":return ae}return re[e]},se="RTLPluginLoaded";class ne extends t.E{constructor(){super(...arguments),this.status="unavailable",this.url=null,this.dispatcher=Z();}_syncState(e){return this.status=e,this.dispatcher.broadcast("SRPS",{pluginStatus:e,pluginURL:this.url}).catch((e=>{throw this.status="error",e}))}getRTLTextPluginStatus(){return this.status}clearRTLTextPlugin(){this.status="unavailable",this.url=null;}setRTLTextPlugin(e){return t._(this,arguments,void 0,(function*(e,t=!1){if(this.url)throw new Error("setRTLTextPlugin cannot be called multiple times.");if(this.url=n.resolveURL(e),!this.url)throw new Error(`requested url ${e} is invalid`);if("unavailable"===this.status){if(!t)return this._requestImport();this.status="deferred",this._syncState(this.status);}else if("requested"===this.status)return this._requestImport()}))}_requestImport(){return t._(this,void 0,void 0,(function*(){yield this._syncState("loading"),this.status="loaded",this.fire(new t.l(se));}))}lazyLoad(){"unavailable"===this.status?this.status="requested":"deferred"===this.status&&this._requestImport();}}let le=null;function ce(){return le||(le=new ne),le}var he,ue;!function(e){e[e.Base=0]="Base",e[e.Parent=1]="Parent";}(he||(he={})),function(e){e[e.Departing=0]="Departing",e[e.Incoming=1]="Incoming";}(ue||(ue={}));class de{constructor(e,i){this.timeAdded=0,this.fadeEndTime=0,this.fadeOpacity=1,this.tileID=e,this.uid=t.ag(),this.uses=0,this.tileSize=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.rtt=[],this.rttCoords={},this.expiredRequestCount=0,this.state="loading";}isRenderable(e){return this.hasData()&&(!this.fadeEndTime||this.fadeOpacity>0)&&(e||!this.holdingForSymbolFade())}setCrossFadeLogic({fadingRole:e,fadingDirection:t,fadingParentID:i,fadeEndTime:a}){this.resetFadeLogic(),this.fadingRole=e,this.fadingDirection=t,this.fadingParentID=i,this.fadeEndTime=a;}setSelfFadeLogic(e){this.resetFadeLogic(),this.selfFading=!0,this.fadeEndTime=e;}resetFadeLogic(){this.fadingRole=null,this.fadingDirection=null,this.fadingParentID=null,this.selfFading=!1,this.timeAdded=c(),this.fadeEndTime=0,this.fadeOpacity=1;}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}clearTextures(e){this.demTexture&&e.saveTileTexture(this.demTexture),this.demTexture=null;}loadVectorData(e,i,a){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",e){e.featureIndex&&(this.latestFeatureIndex=e.featureIndex,e.rawTileData?(this.latestRawTileData=e.rawTileData,this.latestFeatureIndex.rawTileData=e.rawTileData,this.latestFeatureIndex.encoding=e.encoding):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData,this.latestFeatureIndex.encoding=this.latestEncoding)),this.collisionBoxArray=e.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const a of e){const e=a.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){a.layers=e,a.stateDependentLayerIds&&(a.stateDependentLayers=a.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.id]=a;}}return i}(e.buckets,null==i?void 0:i.style),this.hasSymbolBuckets=!1;for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.ai){if(this.hasSymbolBuckets=!0,!a)break;i.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const e in this.buckets){const i=this.buckets[e];if(i instanceof t.ai&&i.hasRTLText){this.hasRTLText=!0,ce().lazyLoad();break}}this.queryPadding=0;for(const e in this.buckets){const t=this.buckets[e];this.queryPadding=Math.max(this.queryPadding,i.style.getLayer(e).queryRadius(t));}e.imageAtlas&&(this.imageAtlas=e.imageAtlas),e.glyphAtlasImage&&(this.glyphAtlasImage=e.glyphAtlasImage),this.dashPositions=e.dashPositions;}else this.collisionBoxArray=new t.ah;}unloadVectorData(){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.dashPositions&&(this.dashPositions=null),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(e){return this.buckets[e.id]}upload(e){for(const t in this.buckets){const i=this.buckets[t];i.uploadPending()&&i.upload(e);}const i=e.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new t.T(e,this.imageAtlas.image,i.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new t.T(e,this.glyphAtlasImage,i.ALPHA),this.glyphAtlasImage=null);}prepare(e){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture);}queryRenderedFeatures(e,t,i,a,r,o,s,n,l,c,h){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({queryGeometry:a,cameraQueryGeometry:r,scale:o,tileSize:this.tileSize,pixelPosMatrix:c,transform:n,params:s,queryPadding:this.queryPadding*l,getElevation:h},e,t,i):{}}querySourceFeatures(e,i){const a=this.latestFeatureIndex;if(!a||!a.rawTileData)return;const r=a.loadVTLayers(),o=i&&i.sourceLayer?i.sourceLayer:"",s=r[t.a9]||r[o];if(!s)return;const n=t.aj(null==i?void 0:i.filter,null==i?void 0:i.globalState),{z:l,x:c,y:h}=this.tileID.canonical,u={z:l,x:c,y:h};for(let i=0;i<s.length;i++){const r=s.feature(i);if(n.needGeometry){const e=t.ak(r,!0);if(!n.filter(new t.H(this.tileID.overscaledZ),e,this.tileID.canonical))continue}else if(!n.filter(new t.H(this.tileID.overscaledZ),r))continue;const d=a.getId(r,o),_=new t.al(r,l,c,h,d);_.tile=u,e.push(_);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(e){const i=this.expirationTime;if(e.cacheControl){const i=t.am(e.cacheControl);i["max-age"]&&(this.expirationTime=Date.now()+1e3*i["max-age"]);}else e.expires&&(this.expirationTime=new Date(e.expires).getTime());if(this.expirationTime){const e=Date.now();let t=!1;if(this.expirationTime>e)t=!1;else if(i)if(this.expirationTime<i)t=!0;else {const a=this.expirationTime-i;a?this.expirationTime=e+Math.max(a,3e4):t=!0;}else t=!0;t?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(e,i){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(e).length)return;const a=this.latestFeatureIndex.loadVTLayers();for(const r in this.buckets){if(!i.style.hasLayer(r))continue;const o=this.buckets[r],s=o.layers[0].sourceLayer||t.a9,n=a[s],l=e[s];if(!n||!l||0===Object.keys(l).length)continue;o.update(l,n,this.imageAtlas&&this.imageAtlas.patternPositions||{},this.dashPositions||{});const c=i&&i.style&&i.style.getLayer(r);c&&(this.queryPadding=Math.max(this.queryPadding,c.queryRadius(o)));}}holdingForSymbolFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<c()}clearSymbolFadeHold(){this.symbolFadeHoldUntil=void 0;}setSymbolHoldDuration(e){this.symbolFadeHoldUntil=c()+e;}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i;}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return !0}return !1}}class _e{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(e,i,a){const r=String(i);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][r]=this.stateChanges[e][r]||{},t.e(this.stateChanges[e][r],a),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==r&&(this.deletedStates[e][t]=null);}else if(this.deletedStates[e]&&null===this.deletedStates[e][r]){this.deletedStates[e][r]={};for(const t in this.state[e][r])a[t]||(this.deletedStates[e][r][t]=null);}else for(const t in a)this.deletedStates[e]&&this.deletedStates[e][r]&&null===this.deletedStates[e][r][t]&&delete this.deletedStates[e][r][t];}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const a=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][a]&&(this.deletedStates[e][a]=this.deletedStates[e][a]||{},this.deletedStates[e][a][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][a])for(i in this.deletedStates[e][a]={},this.stateChanges[e][a])this.deletedStates[e][a][i]=null;else this.deletedStates[e][a]=null;else this.deletedStates[e]=null;}getState(e,i){const a=String(i),r=t.e({},(this.state[e]||{})[a],(this.stateChanges[e]||{})[a]);if(null===this.deletedStates[e])return {};if(this.deletedStates[e]){const t=this.deletedStates[e][i];if(null===t)return {};for(const e in t)delete r[e];}return r}initializeTileState(e,t){e.setFeatureState(this.state,t);}coalesceChanges(e,i){const a={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const i={};for(const a in this.stateChanges[e])this.state[e][a]||(this.state[e][a]={}),t.e(this.state[e][a],this.stateChanges[e][a]),i[a]=this.state[e][a];a[e]=i;}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const i={};if(null===this.deletedStates[e])for(const t in this.state[e])i[t]={},this.state[e][t]={};else for(const t in this.deletedStates[e]){if(null===this.deletedStates[e][t])this.state[e][t]={};else for(const i of Object.keys(this.deletedStates[e][t]))delete this.state[e][t][i];i[t]=this.state[e][t];}a[e]=a[e]||{},t.e(a[e],i);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(a).length)for(const t in e)e[t].setFeatureState(a,i);}}const pe=89.25;function me(e,i){const a=t.an(i.lat,-t.ao,t.ao);return new t.P(t.Y(i.lng)*e,t.X(a)*e)}function fe(e,i){return new t.aa(i.x/e,i.y/e).toLngLat()}function ge(e){return e.cameraToCenterDistance*Math.min(.85*Math.tan(t.ap(90-e.pitch)),Math.tan(t.ap(pe-e.pitch)))}function ve(e,i){const a=e.canonical,r=i/t.aq(a.z),o=a.x+Math.pow(2,a.z)*e.wrap,s=t.ar(new Float64Array(16));return t.O(s,s,[o*r,a.y*r,0]),t.Q(s,s,[r/t.a4,r/t.a4,1]),s}function xe(e,i,a,r,o){const s=t.aa.fromLngLat(e,i),n=o*t.as(1,e.lat),l=n*Math.cos(t.ap(a)),c=Math.sqrt(n*n-l*l),h=c*Math.sin(t.ap(-r)),u=c*Math.cos(t.ap(-r));return new t.aa(s.x+h,s.y+u,s.z+l)}function be(e,t,i){const a=t.intersectsFrustum(e);if(!i||0===a)return a;const r=t.intersectsPlane(i);return 0===r?0:2===a&&2===r?2:1}function ye(e,t,i){let a=0;const r=(i-t)/10;for(let o=0;o<10;o++)a+=r*Math.pow(Math.cos(t+(o+.5)/10*(i-t)),e);return a}function we(e,i){return function(a,r,o,s,n){const l=2*((e-1)/t.at(Math.cos(t.ap(pe-n))/Math.cos(t.ap(pe)))-1),c=Math.acos(o/s),h=2*ye(l-1,0,t.ap(n/2)),u=Math.min(t.ap(pe),c+t.ap(n/2)),d=ye(l-1,Math.min(u,c-t.ap(n/2)),u),_=Math.atan(r/o),p=Math.hypot(r,o);let m=a;return m+=t.at(s/p/Math.max(.5,Math.cos(t.ap(n/2)))),m+=l*t.at(Math.cos(_))/2,m-=t.at(Math.max(1,d/h/i))/2,m}}const Te=we(9.314,3);function Pe(e,i){const a=(i.roundZoom?Math.round:Math.floor)(e.zoom+t.at(e.tileSize/i.tileSize));return Math.max(0,a)}function Ce(e,i){const a=e.getCameraFrustum(),r=e.getClippingPlane(),o=e.screenPointToMercatorCoordinate(e.getCameraPoint()),s=t.aa.fromLngLat(e.center,e.elevation);o.z=s.z+Math.cos(e.pitchInRadians)*e.cameraToCenterDistance/e.worldSize;const n=e.getCoveringTilesDetailsProvider(),l=n.allowVariableZoom(e,i),c=Pe(e,i),h=i.minzoom||0,u=void 0!==i.maxzoom?i.maxzoom:e.maxZoom,d=Math.min(Math.max(0,c),u),_=Math.pow(2,d),p=[_*o.x,_*o.y,0],m=[_*s.x,_*s.y,0],f=Math.hypot(s.x-o.x,s.y-o.y),g=Math.abs(s.z-o.z),v=Math.hypot(f,g),x=e=>({zoom:0,x:0,y:0,wrap:e,fullyVisible:!1}),b=[],y=[];if(e.renderWorldCopies&&n.allowWorldCopies())for(let e=1;e<=3;e++)b.push(x(-e)),b.push(x(e));for(b.push(x(0));b.length>0;){const _=b.pop(),f=_.x,x=_.y;let w=_.fullyVisible;const T={x:f,y:x,z:_.zoom},P=n.getTileBoundingVolume(T,_.wrap,e.elevation,i);if(!w){const e=be(a,P,r);if(0===e)continue;w=2===e;}const C=n.distanceToTile2d(o.x,o.y,T,P);let M=c;l&&(M=(i.calculateTileZoom||Te)(e.zoom+t.at(e.tileSize/i.tileSize),C,g,v,e.fov)),M=(i.roundZoom?Math.round:Math.floor)(M),M=Math.max(0,M);const I=Math.min(M,u);if(_.wrap=n.getWrap(s,T,_.wrap),_.zoom>=I){if(_.zoom<h)continue;const e=d-_.zoom,a=p[0]-.5-(f<<e),r=p[1]-.5-(x<<e),o=i.reparseOverscaled?Math.max(_.zoom,M):_.zoom;y.push({tileID:new t.a1(_.zoom===u?o:_.zoom,_.wrap,_.zoom,f,x),distanceSq:t.au([m[0]-.5-f,m[1]-.5-x]),tileDistanceToCamera:Math.sqrt(a*a+r*r)});}else for(let e=0;e<4;e++)b.push({zoom:_.zoom+1,x:(f<<1)+e%2,y:(x<<1)+(e>>1),wrap:_.wrap,fullyVisible:w});}return y.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}const Me=t.ab.fromPoints([new t.P(0,0),new t.P(t.a4,t.a4)]);class Ie extends t.E{constructor(e,i,a){super(),this.id=e,this.dispatcher=a,this.on("data",(e=>this._dataHandler(e))),this.on("dataloading",(()=>{this._sourceErrored=!1;})),this.on("error",(()=>{this._sourceErrored=this._source.loaded();})),this._source=((e,t,i,a)=>{const r=new(oe(t.type))(e,t,i,a);if(r.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${r.id}`);return r})(e,i,a,this),this._tiles={},this._cache=new t.av(0,(e=>this._unloadTile(e))),this._timers={},this._maxTileCacheSize=null,this._maxTileCacheZoomLevels=null,this._rasterFadeDuration=0,this._maxFadingAncestorLevels=5,this._state=new _e,this._didEmitContent=!1,this._updated=!1;}onAdd(e){this.map=e,this._maxTileCacheSize=e?e._maxTileCacheSize:null,this._maxTileCacheZoomLevels=e?e._maxTileCacheZoomLevels:null,this._source&&this._source.onAdd&&this._source.onAdd(e);}onRemove(e){this.clearTiles(),this._source&&this._source.onRemove&&this._source.onRemove(e);}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;if(!(void 0===this.used&&void 0===this.usedForTerrain||this.used||this.usedForTerrain))return !0;if(!this._updated)return !1;for(const e in this._tiles){const t=this._tiles[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}return !0}getSource(){return this._source}getState(){return this._state}pause(){this._paused=!0;}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform,this.terrain);}_loadTile(e,i,a){return t._(this,void 0,void 0,(function*(){try{yield this._source.loadTile(e),this._tileLoaded(e,i,a);}catch(i){e.state="errored",404!==i.status?this._source.fire(new t.k(i,{tile:e})):this.update(this.transform,this.terrain);}}))}_unloadTile(e){this._source.unloadTile&&this._source.unloadTile(e);}_abortTile(e){this._source.abortTile&&this._source.abortTile(e),this._source.fire(new t.l("dataabort",{tile:e,coord:e.tileID,dataType:"source"}));}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager);}}getIds(){return Object.values(this._tiles).map((e=>e.tileID)).sort(Ee).map((e=>e.key))}getRenderableIds(e){const i=[];for(const t in this._tiles)this._isIdRenderable(t,e)&&i.push(this._tiles[t]);return e?i.sort(((e,i)=>{const a=e.tileID,r=i.tileID,o=new t.P(a.canonical.x,a.canonical.y)._rotate(-this.transform.bearingInRadians),s=new t.P(r.canonical.x,r.canonical.y)._rotate(-this.transform.bearingInRadians);return a.overscaledZ-r.overscaledZ||s.y-o.y||s.x-o.x})).map((e=>e.tileID.key)):i.map((e=>e.tileID)).sort(Ee).map((e=>e.key))}hasRenderableParent(e){const t=e.overscaledZ-1;if(t>=this._source.minzoom){const i=this.getLoadedTile(e.scaledTo(t));if(i)return this._isIdRenderable(i.tileID.key)}return !1}_isIdRenderable(e,t=!1){var i;return null===(i=this._tiles[e])||void 0===i?void 0:i.isRenderable(t)}reload(e,t=void 0){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const i in this._tiles)t&&this._source.shouldReloadTile&&!this._source.shouldReloadTile(this._tiles[i],t)||(e?this._reloadTile(i,"expired"):"errored"!==this._tiles[i].state&&this._reloadTile(i,"reloading"));}}_reloadTile(e,i){return t._(this,void 0,void 0,(function*(){const t=this._tiles[e];t&&("loading"!==t.state&&(t.state=i),yield this._loadTile(t,e,i));}))}_tileLoaded(e,i,a){e.timeAdded=c(),e.selfFading&&(e.fadeEndTime=e.timeAdded+this._rasterFadeDuration),"expired"===a&&(e.refreshedUponExpiration=!0),this._setTileReloadTimer(i,e),"raster-dem"===this.getSource().type&&e.dem&&this._backfillDEM(e),this._state.initializeTileState(e,this.map?this.map.painter:null),e.aborted||this._source.fire(new t.l("data",{dataType:"source",tile:e,coord:e.tileID}));}_backfillDEM(e){const t=this.getRenderableIds();for(let a=0;a<t.length;a++){const r=t[a];if(e.neighboringTiles&&e.neighboringTiles[r]){const t=this.getTileByID(r);i(e,t),i(t,e);}}function i(e,t){e.needsHillshadePrepare=!0,e.needsTerrainPrepare=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const a=t.tileID.canonical.y-e.tileID.canonical.y,r=Math.pow(2,e.tileID.canonical.z),o=t.tileID.key;0===i&&0===a||Math.abs(a)>1||(Math.abs(i)>1&&(1===Math.abs(i+r)?i+=r:1===Math.abs(i-r)&&(i-=r)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,a),e.neighboringTiles&&e.neighboringTiles[o]&&(e.neighboringTiles[o].backfilled=!0)));}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t){const i=this._getLoadedDescendents(t),a=new Set;for(const r of t){const t=i[r.key];if(!(null==t?void 0:t.length)){a.add(r);continue}const o=r.overscaledZ+Ie.maxOverzooming,s=t.filter((e=>e.tileID.overscaledZ<=o));if(!s.length){a.add(r);continue}const n=Math.min(...s.map((e=>e.tileID.overscaledZ))),l=s.filter((e=>e.tileID.overscaledZ===n)).map((e=>e.tileID));for(const t of l)e[t.key]=t;this._areDescendentsComplete(l,n,r.overscaledZ)||a.add(r);}return a}_getLoadedDescendents(e){var t;const i={};for(const a in this._tiles){const r=this._tiles[a];if(r.hasData())for(const a of e)r.tileID.isChildOf(a)&&(i[t=a.key]||(i[t]=[])).push(r);}return i}_areDescendentsComplete(e,t,i){return 1===e.length&&e[0].isOverscaled()?e[0].overscaledZ===t:Math.pow(4,t-i)===e.length}getLoadedTile(e){const t=this._tiles[e.key];return (null==t?void 0:t.hasData())?t:null}updateCacheSize(e){const i=Math.ceil(e.width/this._source.tileSize)+1,a=Math.ceil(e.height/this._source.tileSize)+1,r=Math.floor(i*a*(null===this._maxTileCacheZoomLevels?t.a.MAX_TILE_CACHE_ZOOM_LEVELS:this._maxTileCacheZoomLevels)),o="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,r):r;this._cache.setMaxSize(o);}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const a=this._tiles[i];a.tileID=a.tileID.unwrapTo(a.tileID.wrap+t),e[a.tileID.key]=a;}this._tiles=e,this._resetTileReloadTimers();}}update(e,i){if(!this._sourceLoaded||this._paused)return;let a;this.transform=e,this.terrain=i,this.updateCacheSize(e),this.handleWrapJump(this.transform.center.lng),this.used||this.usedForTerrain?this._source.tileID?a=e.getVisibleUnwrappedCoordinates(this._source.tileID).map((e=>new t.a1(e.canonical.z,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y))):(a=Ce(e,{tileSize:this.usedForTerrain?this.tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:"vector"===this._source.type&&void 0!==this.map._zoomLevelsToOverscale?e.maxZoom-this.map._zoomLevelsToOverscale:this._source.maxzoom,roundZoom:!this.usedForTerrain&&this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,terrain:i,calculateTileZoom:this._source.calculateTileZoom}),this._source.hasTile&&(a=a.filter((e=>this._source.hasTile(e))))):a=[],this.usedForTerrain&&(a=this._addTerrainIdealTiles(a));const r=0===a.length&&!this._updated&&this._didEmitContent;this._updated=!0,r&&this.fire(new t.l("data",{sourceDataType:"idle",dataType:"source",sourceId:this.id}));const o=Pe(e,this._source),s=this._updateRetainedTiles(a,o),n=Se(this._source.type);n&&this._rasterFadeDuration>0&&!i&&this._updateFadingTiles(a,s),n?this._cleanUpRasterTiles(s):this._cleanUpVectorTiles(s);}_cleanUpRasterTiles(e){for(const t in this._tiles)e[t]||this._removeTile(t);}_cleanUpVectorTiles(e){for(const t in this._tiles){const i=this._tiles[t];e[t]?i.clearSymbolFadeHold():i.hasSymbolBuckets?i.holdingForSymbolFade()?i.symbolFadeFinished()&&this._removeTile(t):i.setSymbolHoldDuration(this.map._fadeDuration):this._removeTile(t);}}_addTerrainIdealTiles(e){const t=[];for(const i of e)if(i.canonical.z>this._source.minzoom){const e=i.scaledTo(i.canonical.z-1);t.push(e);const a=i.scaledTo(Math.max(this._source.minzoom,Math.min(i.canonical.z,5)));t.push(a);}return e.concat(t)}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForSymbolFade()&&this._removeTile(e);}_updateRetainedTiles(e,t){var i;const a=new Set;for(const t of e)this._addTile(t).hasData()||a.add(t);const r=e.reduce(((e,t)=>(e[t.key]=t,e)),{}),o=this._retainLoadedChildren(r,a),s={},n=Math.max(t-Ie.maxUnderzooming,this._source.minzoom);for(const e of o){let t=this._tiles[e.key],a=null==t?void 0:t.wasRequested();for(let o=e.overscaledZ-1;o>=n;--o){const n=e.scaledTo(o);if(s[n.key])break;if(s[n.key]=!0,t=this.getTile(n),!t&&a&&(t=this._addTile(n)),t){const e=t.hasData();if((e||!(null===(i=this.map)||void 0===i?void 0:i.cancelPendingTileRequestsWhileZooming)||a)&&(r[n.key]=n),a=t.wasRequested(),e)break}}}return r}_updateFadingTiles(e,i){const a=c(),r=t.aw(e);for(const t of e){const e=this._tiles[t.key];e.fadingDirection!==ue.Departing&&0!==e.fadeOpacity||e.resetFadeLogic(),this._updateFadingAncestor(e,i,a)||this._updateFadingDescendents(e,i,a)||this._updateFadingEdge(e,r,a)||e.resetFadeLogic();}}_updateFadingAncestor(e,t,i){if(!e.hasData())return !1;const{tileID:a,fadingRole:r,fadingDirection:o,fadingParentID:s}=e;if(r===he.Base&&o===ue.Incoming&&s)return t[s.key]=s,!0;const n=Math.max(a.overscaledZ-this._maxFadingAncestorLevels,this._source.minzoom);for(let r=a.overscaledZ-1;r>=n;r--){const o=a.scaledTo(r),s=this.getLoadedTile(o);if(s)return e.setCrossFadeLogic({fadingRole:he.Base,fadingDirection:ue.Incoming,fadingParentID:s.tileID,fadeEndTime:i+this._rasterFadeDuration}),s.setCrossFadeLogic({fadingRole:he.Parent,fadingDirection:ue.Departing,fadeEndTime:i+this._rasterFadeDuration}),t[o.key]=o,!0}return !1}_updateFadingDescendents(e,t,i){if(!e.hasData())return !1;const a=e.tileID.children(this._source.maxzoom);let r=this._updateFadingChildren(e,a,t,i);if(r)return !0;for(const o of a){const a=o.children(this._source.maxzoom);this._updateFadingChildren(e,a,t,i)&&(r=!0);}return r}_updateFadingChildren(e,t,i,a){if(t[0].overscaledZ>=this._source.maxzoom)return !1;let r=!1;for(const o of t){const t=this.getLoadedTile(o);if(!t)continue;const{fadingRole:s,fadingDirection:n,fadingParentID:l}=t;s===he.Base&&n===ue.Departing&&l||(t.setCrossFadeLogic({fadingRole:he.Base,fadingDirection:ue.Departing,fadingParentID:e.tileID,fadeEndTime:a+this._rasterFadeDuration}),e.setCrossFadeLogic({fadingRole:he.Parent,fadingDirection:ue.Incoming,fadeEndTime:a+this._rasterFadeDuration})),i[o.key]=o,r=!0;}return r}_updateFadingEdge(e,t,i){const a=e.tileID;return !!e.selfFading||!e.hasData()&&!!t.has(a)&&(e.setSelfFadeLogic(i+this._rasterFadeDuration),!0)}_addTile(e){let i=this._tiles[e.key];if(i)return i;i=this._cache.getAndRemove(e),i&&(i.resetFadeLogic(),this._setTileReloadTimer(e.key,i),i.tileID=e,this._state.initializeTileState(i,this.map?this.map.painter:null));const a=i;return i||(i=new de(e,this._source.tileSize*e.overscaleFactor()),this._loadTile(i,e.key,i.state)),i.uses++,this._tiles[e.key]=i,a||this._source.fire(new t.l("dataloading",{tile:i,coord:i.tileID,dataType:"source"})),i}_setTileReloadTimer(e,t){this._clearTileReloadTimer(e);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e];}),i));}_clearTileReloadTimer(e){const t=this._timers[e];t&&(clearTimeout(t),delete this._timers[e]);}_resetTileReloadTimers(){for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(e,this._tiles[e]);}refreshTiles(e){for(const t in this._tiles)(this._isIdRenderable(t)||"errored"==this._tiles[t].state)&&e.some((e=>e.equals(this._tiles[t].tileID.canonical)))&&this._reloadTile(t,"expired");}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._clearTileReloadTimer(e),t.uses>0||(t.hasData()&&"reloading"!==t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))));}_dataHandler(e){"source"===e.dataType&&("metadata"!==e.sourceDataType?"content"===e.sourceDataType&&this._sourceLoaded&&!this._paused&&(this.reload(e.sourceDataChanged,e.shouldReloadTileOptions),this.transform&&this.update(this.transform,this.terrain),this._didEmitContent=!0):this._sourceLoaded=!0);}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(e);this._cache.reset();}tilesIn(e,i,a){const r=[],o=this.transform;if(!o)return r;const s=o.getCoveringTilesDetailsProvider().allowWorldCopies(),n=a?o.getCameraQueryGeometry(e):e,l=e=>o.screenPointToMercatorCoordinate(e,this.terrain),c=this.transformBbox(e,l,!s),h=this.transformBbox(n,l,!s),u=this.getIds(),d=t.ab.fromPoints(h);for(let e=0;e<u.length;e++){const a=this._tiles[u[e]];if(a.holdingForSymbolFade())continue;const n=s?[a.tileID]:[a.tileID.unwrapTo(-1),a.tileID.unwrapTo(0)],l=Math.pow(2,o.zoom-a.tileID.overscaledZ),_=i*a.queryPadding*t.a4/a.tileSize/l;for(const e of n){const i=d.map((i=>e.getTilePoint(new t.aa(i.x,i.y))));if(i.expandBy(_),i.intersects(Me)){const t=c.map((t=>e.getTilePoint(t))),i=h.map((t=>e.getTilePoint(t)));r.push({tile:a,tileID:s?e:e.unwrapTo(0),queryGeometry:t,cameraQueryGeometry:i,scale:l});}}}return r}transformBbox(e,i,a){let r=e.map(i);if(a){const a=t.ab.fromPoints(e);a.shrinkBy(.001*Math.min(a.width(),a.height()));const o=a.map(i);t.ab.fromPoints(r).covers(o)||(r=r.map((e=>e.x>.5?new t.aa(e.x-1,e.y,e.z):e)));}return r}getVisibleCoordinates(e){const t=this.getRenderableIds(e).map((e=>this._tiles[e].tileID));return this.transform&&this.transform.populateCache(t),t}hasTransition(){if(this._source.hasTransition())return !0;if(Se(this._source.type)&&this._rasterFadeDuration>0){const e=c();for(const t in this._tiles)if(this._tiles[t].fadeEndTime>=e)return !0}return !1}setRasterFadeDuration(e){this._rasterFadeDuration=e;}setFeatureState(e,i,a){this._state.updateState(e=e||t.a9,i,a);}removeFeatureState(e,i,a){this._state.removeFeatureState(e=e||t.a9,i,a);}getFeatureState(e,i){return this._state.getState(e=e||t.a9,i)}setDependencies(e,t,i){const a=this._tiles[e];a&&a.setDependencies(t,i);}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)));}}function Ee(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),a=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||a-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function Se(e){return "raster"===e||"image"===e||"video"===e}Ie.maxUnderzooming=10,Ie.maxOverzooming=3;class Re{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(e){if(1===this.points.length)return this.points[0];e=t.an(e,0,1);let i=1,a=this._distances[i];const r=e*this.paddedLength+this.padding;for(;a<r&&i<this._distances.length;)a=this._distances[++i];const o=i-1,s=this._distances[o],n=a-s,l=n>0?(r-s)/n:0;return this.points[o].mult(1-l).add(this.points[i].mult(l))}}function De(e,t){let i=!0;return "always"===e||"never"!==e&&"never"!==t||(i=!1),i}class ze{constructor(e,t,i){const a=this.boxCells=[],r=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)a.push([]),r.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,a,r){this._forEachCell(t,i,a,r,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(a),this.bboxes.push(r);}insertCircle(e,t,i,a){this._forEachCell(t-a,i-a,t+a,i+a,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(a);}_insertBoxCell(e,t,i,a,r,o){this.boxCells[r].push(o);}_insertCircleCell(e,t,i,a,r,o){this.circleCells[r].push(o);}_query(e,t,i,a,r,o,s){if(i<0||e>this.width||a<0||t>this.height)return [];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=a){if(r)return [{key:null,x1:e,y1:t,x2:i,y2:a}];for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],a=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-a,y1:i-a,x2:t+a,y2:i+a});}}else this._forEachCell(e,t,i,a,this._queryCell,n,{hitTest:r,overlapMode:o,seenUids:{box:{},circle:{}}},s);return n}query(e,t,i,a){return this._query(e,t,i,a,!1,null)}hitTest(e,t,i,a,r,o){return this._query(e,t,i,a,!0,r,o).length>0}hitTestCircle(e,t,i,a,r){const o=e-i,s=e+i,n=t-i,l=t+i;if(s<0||o>this.width||l<0||n>this.height)return !1;const c=[];return this._forEachCell(o,n,s,l,this._queryCellCircle,c,{hitTest:!0,overlapMode:a,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},r),c.length>0}_queryCell(e,t,i,a,r,o,s,n){const{seenUids:l,hitTest:c,overlapMode:h}=s,u=this.boxCells[r];if(null!==u){const r=this.bboxes;for(const s of u)if(!l.box[s]){l.box[s]=!0;const u=4*s,d=this.boxKeys[s];if(e<=r[u+2]&&t<=r[u+3]&&i>=r[u+0]&&a>=r[u+1]&&(!n||n(d))&&(!c||!De(h,d.overlapMode))&&(o.push({key:d,x1:r[u],y1:r[u+1],x2:r[u+2],y2:r[u+3]}),c))return !0}}const d=this.circleCells[r];if(null!==d){const r=this.circles;for(const s of d)if(!l.circle[s]){l.circle[s]=!0;const u=3*s,d=this.circleKeys[s];if(this._circleAndRectCollide(r[u],r[u+1],r[u+2],e,t,i,a)&&(!n||n(d))&&(!c||!De(h,d.overlapMode))){const e=r[u],t=r[u+1],i=r[u+2];if(o.push({key:d,x1:e-i,y1:t-i,x2:e+i,y2:t+i}),c)return !0}}}return !1}_queryCellCircle(e,t,i,a,r,o,s,n){const{circle:l,seenUids:c,overlapMode:h}=s,u=this.boxCells[r];if(null!==u){const e=this.bboxes;for(const t of u)if(!c.box[t]){c.box[t]=!0;const i=4*t,a=this.boxKeys[t];if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!n||n(a))&&!De(h,a.overlapMode))return o.push(!0),!0}}const d=this.circleCells[r];if(null!==d){const e=this.circles;for(const t of d)if(!c.circle[t]){c.circle[t]=!0;const i=3*t,a=this.circleKeys[t];if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!n||n(a))&&!De(h,a.overlapMode))return o.push(!0),!0}}}_forEachCell(e,t,i,a,r,o,s,n){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(a);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(r.call(this,e,t,i,a,this.xCellCount*l+d,o,s,n))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,a,r,o){const s=a-e,n=r-t,l=i+o;return l*l>s*s+n*n}_circleAndRectCollide(e,t,i,a,r,o,s){const n=(o-a)/2,l=Math.abs(e-(a+n));if(l>n+i)return !1;const c=(s-r)/2,h=Math.abs(t-(r+c));if(h>c+i)return !1;if(l<=n||h<=c)return !0;const u=l-n,d=h-c;return u*u+d*d<=i*i}}function Ae(e,i,r){const o=t.N();if(!e){const{vecSouth:e,vecEast:t}=ke(i),r=a();r[0]=t[0],r[1]=t[1],r[2]=e[0],r[3]=e[1],s=r,(d=(l=(n=r)[0])*(u=n[3])-(h=n[2])*(c=n[1]))&&(s[0]=u*(d=1/d),s[1]=-c*d,s[2]=-h*d,s[3]=l*d),o[0]=r[0],o[1]=r[1],o[4]=r[2],o[5]=r[3];}var s,n,l,c,h,u,d;return t.Q(o,o,[1/r,1/r,1]),o}function Le(e,i,a,r){if(e){const e=t.N();if(!i){const{vecSouth:t,vecEast:i}=ke(a);e[0]=i[0],e[1]=i[1],e[4]=t[0],e[5]=t[1];}return t.Q(e,e,[r,r,1]),e}return a.pixelsToClipSpaceMatrix}function ke(e){const i=Math.cos(e.rollInRadians),a=Math.sin(e.rollInRadians),r=Math.cos(e.pitchInRadians),o=Math.cos(e.bearingInRadians),s=Math.sin(e.bearingInRadians),n=t.aB();n[0]=-o*r*a-s*i,n[1]=-s*r*a+o*i;const l=t.aC(n);l<1e-9?t.aD(n):t.aE(n,n,1/l);const c=t.aB();c[0]=o*r*i-s*a,c[1]=s*r*i+o*a;const h=t.aC(c);return h<1e-9?t.aD(c):t.aE(c,c,1/h),{vecEast:c,vecSouth:n}}function Fe(e,i,a,r){let o;r?(o=[e,i,r(e,i),1],t.aG(o,o,a)):(o=[e,i,0,1],Je(o,o,a));const s=o[3];return {point:new t.P(o[0]/s,o[1]/s),signedDistanceFromCamera:s,isOccluded:!1}}function Be(e,t){return .5+e/t*.5}function Oe(e,t){return e.x>=-t[0]&&e.x<=t[0]&&e.y>=-t[1]&&e.y<=t[1]}function je(e,i,a,r,o,s,n,l,c,h,u,d,_){const p=a?e.textSizeData:e.iconSizeData,m=t.ax(p,i.transform.zoom),f=[256/i.width*2+1,256/i.height*2+1],g=a?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;g.clear();const v=e.lineVertexArray,x=a?e.text.placedSymbolArray:e.icon.placedSymbolArray,b=i.transform.width/i.transform.height;let y=!1;for(let a=0;a<x.length;a++){const w=x.get(a);if(w.hidden||w.writingMode===t.ay.vertical&&!y){Qe(w.numGlyphs,g);continue}y=!1;const T=new t.P(w.anchorX,w.anchorY),P={getElevation:_,pitchedLabelPlaneMatrix:r,lineVertexArray:v,pitchWithMap:s,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:i.transform,tileAnchorPoint:T,unwrappedTileID:c,width:h,height:u,translation:d},C=$e(w.anchorX,w.anchorY,P);if(!Oe(C.point,f)){Qe(w.numGlyphs,g);continue}const M=Be(i.transform.cameraToCenterDistance,C.signedDistanceFromCamera),I=t.az(p,m,w),E=s?I*i.transform.getPitchedTextCorrection(w.anchorX,w.anchorY,c)/M:I*M,S=Ge({projectionContext:P,pitchedLabelPlaneMatrixInverse:o,symbol:w,fontSize:E,flip:!1,keepUpright:n,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:b,rotateToLine:l});y=S.useVertical,(S.notEnoughRoom||y||S.needsFlipping&&Ge({projectionContext:P,pitchedLabelPlaneMatrixInverse:o,symbol:w,fontSize:E,flip:!0,keepUpright:n,glyphOffsetArray:e.glyphOffsetArray,dynamicLayoutVertexArray:g,aspectRatio:b,rotateToLine:l}).notEnoughRoom)&&Qe(w.numGlyphs,g);}a?e.text.dynamicLayoutVertexBuffer.updateData(g):e.icon.dynamicLayoutVertexBuffer.updateData(g);}function Ne(e,t,i,a,r,o,s,n){const l=o.glyphStartIndex+o.numGlyphs,c=o.lineStartIndex,h=o.lineStartIndex+o.lineLength,u=t.getoffsetX(o.glyphStartIndex),d=t.getoffsetX(l-1),_=Ke(e*u,i,a,r,o.segment,c,h,n,s);if(!_)return null;const p=Ke(e*d,i,a,r,o.segment,c,h,n,s);return p?n.projectionCache.anyProjectionOccluded?null:{first:_,last:p}:null}function Ze(e,i,a,r){return e===t.ay.horizontal&&Math.abs(a.y-i.y)>Math.abs(a.x-i.x)*r?{useVertical:!0}:(e===t.ay.vertical?i.y<a.y:i.x>a.x)?{needsFlipping:!0}:null}function Ge(e){const{projectionContext:i,pitchedLabelPlaneMatrixInverse:a,symbol:r,fontSize:o,flip:s,keepUpright:n,glyphOffsetArray:l,dynamicLayoutVertexArray:c,aspectRatio:h,rotateToLine:u}=e,d=o/24,_=r.lineOffsetX*d,p=r.lineOffsetY*d;let m;if(r.numGlyphs>1){const e=r.glyphStartIndex+r.numGlyphs,t=r.lineStartIndex,o=r.lineStartIndex+r.lineLength,c=Ne(d,l,_,p,s,r,u,i);if(!c)return {notEnoughRoom:!0};const f=We(c.first.point.x,c.first.point.y,i,a),g=We(c.last.point.x,c.last.point.y,i,a);if(n&&!s){const e=Ze(r.writingMode,f,g,h);if(e)return e}m=[c.first];for(let a=r.glyphStartIndex+1;a<e-1;a++){const e=Ke(d*l.getoffsetX(a),_,p,s,r.segment,t,o,i,u);if(!e)return {notEnoughRoom:!0};m.push(e);}m.push(c.last);}else {if(n&&!s){const e=qe(i.tileAnchorPoint.x,i.tileAnchorPoint.y,i).point,o=r.lineStartIndex+r.segment+1,s=new t.P(i.lineVertexArray.getx(o),i.lineVertexArray.gety(o)),n=qe(s.x,s.y,i),l=n.signedDistanceFromCamera>0?n.point:Ue(i.tileAnchorPoint,s,e,1,i),c=We(e.x,e.y,i,a),u=We(l.x,l.y,i,a),d=Ze(r.writingMode,c,u,h);if(d)return d}const e=Ke(d*l.getoffsetX(r.glyphStartIndex),_,p,s,r.segment,r.lineStartIndex,r.lineStartIndex+r.lineLength,i,u);if(!e||i.projectionCache.anyProjectionOccluded)return {notEnoughRoom:!0};m=[e];}for(const e of m)t.aF(c,e.point,e.angle);return {}}function Ue(e,t,i,a,r){const o=e.add(e.sub(t)._unit()),s=qe(o.x,o.y,r).point,n=i.sub(s);return i.add(n._mult(a/n.mag()))}function Ve(e,i,a){const r=i.projectionCache;if(r.projections[e])return r.projections[e];const o=new t.P(i.lineVertexArray.getx(e),i.lineVertexArray.gety(e)),s=qe(o.x,o.y,i);if(s.signedDistanceFromCamera>0)return r.projections[e]=s.point,r.anyProjectionOccluded=r.anyProjectionOccluded||s.isOccluded,s.point;const n=e-a.direction;return Ue(0===a.distanceFromAnchor?i.tileAnchorPoint:new t.P(i.lineVertexArray.getx(n),i.lineVertexArray.gety(n)),o,a.previousVertex,a.absOffsetX-a.distanceFromAnchor+1,i)}function qe(e,t,i){const a=e+i.translation[0],r=t+i.translation[1];let o;return i.pitchWithMap?(o=Fe(a,r,i.pitchedLabelPlaneMatrix,i.getElevation),o.isOccluded=!1):(o=i.transform.projectTileCoordinates(a,r,i.unwrappedTileID,i.getElevation),o.point.x=(.5*o.point.x+.5)*i.width,o.point.y=(.5*-o.point.y+.5)*i.height),o}function We(e,i,a,r){if(a.pitchWithMap){const o=[e,i,0,1];return t.aG(o,o,r),a.transform.projectTileCoordinates(o[0]/o[3],o[1]/o[3],a.unwrappedTileID,a.getElevation).point}return {x:e/a.width*2-1,y:1-i/a.height*2}}function $e(e,t,i){return i.transform.projectTileCoordinates(e,t,i.unwrappedTileID,i.getElevation)}function He(e,t,i){return e._unit()._perp()._mult(t*i)}function Xe(e,i,a,r,o,s,n,l,c){if(l.projectionCache.offsets[e])return l.projectionCache.offsets[e];const h=a.add(i);if(e+c.direction<r||e+c.direction>=o)return l.projectionCache.offsets[e]=h,h;const u=Ve(e+c.direction,l,c),d=He(u.sub(a),n,c.direction),_=a.add(d),p=u.add(d);return l.projectionCache.offsets[e]=t.aH(s,h,_,p)||h,l.projectionCache.offsets[e]}function Ke(e,t,i,a,r,o,s,n,l){const c=a?e-t:e+t;let h=c>0?1:-1,u=0;a&&(h*=-1,u=Math.PI),h<0&&(u+=Math.PI);let d,_=h>0?o+r:o+r+1;n.projectionCache.cachedAnchorPoint?d=n.projectionCache.cachedAnchorPoint:(d=qe(n.tileAnchorPoint.x,n.tileAnchorPoint.y,n).point,n.projectionCache.cachedAnchorPoint=d);let p,m,f=d,g=d,v=0,x=0;const b=Math.abs(c),y=[];let w;for(;v+x<=b;){if(_+=h,_<o||_>=s)return null;v+=x,g=f,m=p;const e={absOffsetX:b,direction:h,distanceFromAnchor:v,previousVertex:g};if(f=Ve(_,n,e),0===i)y.push(g),w=f.sub(g);else {let t;const a=f.sub(g);t=0===a.mag()?He(Ve(_+h,n,e).sub(f),i,h):He(a,i,h),m||(m=g.add(t)),p=Xe(_,t,f,o,s,m,i,n,e),y.push(m),w=p.sub(m);}x=w.mag();}const T=w._mult((b-v)/x)._add(m||g),P=u+Math.atan2(f.y-g.y,f.x-g.x);return y.push(T),{point:T,angle:l?P:0,path:y}}const Ye=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function Qe(e,t){for(let i=0;i<e;i++){const e=t.length;t.resize(e+4),t.float32.set(Ye,3*e);}}function Je(e,t,i){const a=t[0],r=t[1];return e[0]=i[0]*a+i[4]*r+i[12],e[1]=i[1]*a+i[5]*r+i[13],e[3]=i[3]*a+i[7]*r+i[15],e}const et=100;class tt{constructor(e,t=new ze(e.width+200,e.height+200,25),i=new ze(e.width+200,e.height+200,25)){this.transform=e,this.grid=t,this.ignoredGrid=i,this.pitchFactor=Math.cos(e.pitch*Math.PI/180)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+et,this.screenBottomBoundary=e.height+et,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.perspectiveRatioCutoff=.6;}placeCollisionBox(e,t,i,a,r,o,s,n,l,c,h,u){const d=this.projectAndGetPerspectiveRatio(e.anchorPointX+n[0],e.anchorPointY+n[1],r,c,u),_=i*d.perspectiveRatio;let p;if(o||s)p=this._projectCollisionBox(e,_,a,r,o,s,n,d,c,h,u);else {const t=d.x+(h?h.x*_:0),i=d.y+(h?h.y*_:0);p={allPointsOccluded:!1,box:[t+e.x1*_,i+e.y1*_,t+e.x2*_,i+e.y2*_]};}const[m,f,g,v]=p.box,x=o?p.allPointsOccluded:d.isOccluded;let b=x;return b||(b=d.perspectiveRatio<this.perspectiveRatioCutoff),b||(b=!this.isInsideGrid(m,f,g,v)),b||"always"!==t&&this.grid.hitTest(m,f,g,v,t,l)?{box:[m,f,g,v],placeable:!1,offscreen:!1,occluded:x}:{box:[m,f,g,v],placeable:!0,offscreen:this.isOffscreen(m,f,g,v),occluded:x}}placeCollisionCircles(e,i,a,r,o,s,n,l,c,h,u,d,_,p){const m=[],f=new t.P(i.anchorX,i.anchorY),g=this.getPerspectiveRatio(f.x,f.y,s,p),v=(c?o*this.transform.getPitchedTextCorrection(i.anchorX,i.anchorY,s)/g:o*g)/t.aL,x={getElevation:p,pitchedLabelPlaneMatrix:n,lineVertexArray:a,pitchWithMap:c,projectionCache:{projections:{},offsets:{},cachedAnchorPoint:void 0,anyProjectionOccluded:!1},transform:this.transform,tileAnchorPoint:f,unwrappedTileID:s,width:this.transform.width,height:this.transform.height,translation:_},b=Ne(v,r,i.lineOffsetX*v,i.lineOffsetY*v,!1,i,!1,x);let y=!1,w=!1,T=!0;if(b){const i=.5*u*g+d,a=new t.P(-100,-100),r=new t.P(this.screenRightBoundary,this.screenBottomBoundary),o=new Re,s=b.first,n=b.last;let _=[];for(let e=s.path.length-1;e>=1;e--)_.push(s.path[e]);for(let e=1;e<n.path.length;e++)_.push(n.path[e]);const p=2.5*i;if(c){const e=this.projectPathToScreenSpace(_,x);_=e.some((e=>e.signedDistanceFromCamera<=0))?[]:e.map((e=>e.point));}let f=[];if(_.length>0){const e=_[0].clone(),i=_[0].clone();for(let t=1;t<_.length;t++)e.x=Math.min(e.x,_[t].x),e.y=Math.min(e.y,_[t].y),i.x=Math.max(i.x,_[t].x),i.y=Math.max(i.y,_[t].y);f=e.x>=a.x&&i.x<=r.x&&e.y>=a.y&&i.y<=r.y?[_]:i.x<a.x||e.x>r.x||i.y<a.y||e.y>r.y?[]:t.aI([_],a.x,a.y,r.x,r.y);}for(const t of f){o.reset(t,.25*i);let a=0;a=o.length<=.5*i?1:Math.ceil(o.paddedLength/p)+1;for(let t=0;t<a;t++){const r=t/Math.max(a-1,1),s=o.lerp(r),n=s.x+et,c=s.y+et;m.push(n,c,i,0);const u=n-i,d=c-i,_=n+i,p=c+i;if(T=T&&this.isOffscreen(u,d,_,p),w=w||this.isInsideGrid(u,d,_,p),"always"!==e&&this.grid.hitTestCircle(n,c,i,e,h)&&(y=!0,!l))return {circles:[],offscreen:!1,collisionDetected:y}}}}return {circles:!l&&y||!w||g<this.perspectiveRatioCutoff?[]:m,offscreen:T,collisionDetected:y}}projectPathToScreenSpace(e,i){const a=function(e,i){const a=t.N();return t.aA(a,i.pitchedLabelPlaneMatrix),e.map((e=>{const t=Fe(e.x,e.y,a,i.getElevation),r=i.transform.projectTileCoordinates(t.point.x,t.point.y,i.unwrappedTileID,i.getElevation);return r.point.x=(.5*r.point.x+.5)*i.width,r.point.y=(.5*-r.point.y+.5)*i.height,r}))}(e,i);return function(e){let t=0,i=0,a=0,r=0;for(let o=0;o<e.length;o++)e[o].isOccluded?(a=o+1,r=0):(r++,r>i&&(i=r,t=a));return e.slice(t,t+i)}(a)}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[],a=new t.ab;for(const r of e){const e=new t.P(r.x+et,r.y+et);a.extend(e),i.push(e);}const{minX:r,minY:o,maxX:s,maxY:n}=a,l=this.grid.query(r,o,s,n).concat(this.ignoredGrid.query(r,o,s,n)),c={},h={};for(const e of l){const a=e.key;if(void 0===c[a.bucketInstanceId]&&(c[a.bucketInstanceId]={}),c[a.bucketInstanceId][a.featureIndex])continue;const r=[new t.P(e.x1,e.y1),new t.P(e.x2,e.y1),new t.P(e.x2,e.y2),new t.P(e.x1,e.y2)];t.aJ(i,r)&&(c[a.bucketInstanceId][a.featureIndex]=!0,void 0===h[a.bucketInstanceId]&&(h[a.bucketInstanceId]=[]),h[a.bucketInstanceId].push(a.featureIndex));}return h}insertCollisionBox(e,t,i,a,r,o){(i?this.ignoredGrid:this.grid).insert({bucketInstanceId:a,featureIndex:r,collisionGroupID:o,overlapMode:t},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,a,r,o){const s=i?this.ignoredGrid:this.grid,n={bucketInstanceId:a,featureIndex:r,collisionGroupID:o,overlapMode:t};for(let t=0;t<e.length;t+=4)s.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(e,i,a,r,o){if(o){let a;r?(a=[e,i,r(e,i),1],t.aG(a,a,o)):(a=[e,i,0,1],Je(a,a,o));const s=a[3];return {x:(a[0]/s+1)/2*this.transform.width+et,y:(-a[1]/s+1)/2*this.transform.height+et,perspectiveRatio:.5+this.transform.cameraToCenterDistance/s*.5,isOccluded:!1,signedDistanceFromCamera:s}}{const t=this.transform.projectTileCoordinates(e,i,a,r);return {x:(t.point.x+1)/2*this.transform.width+et,y:(1-t.point.y)/2*this.transform.height+et,perspectiveRatio:.5+this.transform.cameraToCenterDistance/t.signedDistanceFromCamera*.5,isOccluded:t.isOccluded,signedDistanceFromCamera:t.signedDistanceFromCamera}}}getPerspectiveRatio(e,t,i,a){const r=this.transform.projectTileCoordinates(e,t,i,a);return .5+this.transform.cameraToCenterDistance/r.signedDistanceFromCamera*.5}isOffscreen(e,t,i,a){return i<et||e>=this.screenRightBoundary||a<et||t>this.screenBottomBoundary}isInsideGrid(e,t,i,a){return i>=0&&e<this.gridRightBoundary&&a>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const e=t.ar([]);return t.O(e,e,[-100,-100,0]),e}_projectCollisionBox(e,i,a,r,o,s,n,l,c,h,u){let d=1,_=0,p=0,m=1;const f=e.anchorPointX+n[0],g=e.anchorPointY+n[1];if(s&&!o){const e=this.projectAndGetPerspectiveRatio(f+1,g,r,c,u),t=e.x-l.x,i=Math.atan((e.y-l.y)/t)+(t<0?Math.PI:0),a=Math.sin(i),o=Math.cos(i);d=o,_=a,p=-a,m=o;}else if(!s&&o){const e=ke(this.transform);d=e.vecEast[0],_=e.vecEast[1],p=e.vecSouth[0],m=e.vecSouth[1];}let v=l.x,x=l.y,b=i;o&&(v=f,x=g,b=Math.pow(2,-(this.transform.zoom-a.overscaledZ)),b*=this.transform.getPitchedTextCorrection(f,g,r),h||(b*=t.an(.5+l.signedDistanceFromCamera/this.transform.cameraToCenterDistance*.5,0,4))),h&&(v+=d*h.x*b+p*h.y*b,x+=_*h.x*b+m*h.y*b);const y=e.x1*b,w=e.x2*b,T=(y+w)/2,P=e.y1*b,C=e.y2*b,M=(P+C)/2,I=[{offsetX:y,offsetY:P},{offsetX:T,offsetY:P},{offsetX:w,offsetY:P},{offsetX:w,offsetY:M},{offsetX:w,offsetY:C},{offsetX:T,offsetY:C},{offsetX:y,offsetY:C},{offsetX:y,offsetY:M}];let E=[];for(const{offsetX:e,offsetY:i}of I)E.push(new t.P(v+d*e+p*i,x+_*e+m*i));let S=!1;if(o){const e=E.map((e=>this.projectAndGetPerspectiveRatio(e.x,e.y,r,c,u)));S=e.some((e=>!e.isOccluded)),E=e.map((e=>new t.P(e.x,e.y)));}else S=!0;return {box:t.aK(E),allPointsOccluded:!S}}}class it{constructor(e,t,i,a){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):a&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class at{constructor(e,t,i,a,r){this.text=new it(e?e.text:null,t,i,r),this.icon=new it(e?e.icon:null,t,a,r);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class rt{constructor(e,t,i){this.text=e,this.icon=t,this.skipFade=i;}}class ot{constructor(e,t,i,a,r){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=a,this.tileID=r;}}class st{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function nt(e,i,a,r,o){const{horizontalAlign:s,verticalAlign:n}=t.aR(e);return new t.P(-(s-.5)*i+r[0]*o,-(n-.5)*a+r[1]*o)}class lt{constructor(e,t,i,a,r){this.transform=e.clone(),this.terrain=t,this.collisionIndex=new tt(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=i,this.retainedQueryData={},this.collisionGroups=new st(a),this.collisionCircleArrays={},this.collisionBoxArrays=new Map,this.prevPlacement=r,r&&(r.prevPlacement=void 0),this.placedOrientations={};}_getTerrainElevationFunc(e){const t=this.terrain;return t?(i,a)=>t.getElevation(e,i,a):null}getBucketParts(e,i,a,r){const o=a.getBucket(i),s=a.latestFeatureIndex;if(!o||!s||i.id!==o.layerIds[0])return;const n=a.collisionBoxArray,l=o.layers[0].layout,c=o.layers[0].paint,h=Math.pow(2,this.transform.zoom-a.tileID.overscaledZ),u=a.tileSize/t.a4,d=a.tileID.toUnwrapped(),_="map"===l.get("text-rotation-alignment"),p=t.aM(a,1,this.transform.zoom),m=t.aN(this.collisionIndex.transform,a,c.get("text-translate"),c.get("text-translate-anchor")),f=t.aN(this.collisionIndex.transform,a,c.get("icon-translate"),c.get("icon-translate-anchor")),g=Ae(_,this.transform,p);this.retainedQueryData[o.bucketInstanceId]=new ot(o.bucketInstanceId,s,o.sourceLayerIndex,o.index,a.tileID);const v={bucket:o,layout:l,translationText:m,translationIcon:f,unwrappedTileID:d,pitchedLabelPlaneMatrix:g,scale:h,textPixelRatio:u,holdingForFade:a.holdingForSymbolFade(),collisionBoxArray:n,partiallyEvaluatedTextSize:t.ax(o.textSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(o.sourceID)};if(r)for(const t of o.sortKeyRanges){const{sortKey:i,symbolInstanceStart:a,symbolInstanceEnd:r}=t;e.push({sortKey:i,symbolInstanceStart:a,symbolInstanceEnd:r,parameters:v});}else e.push({symbolInstanceStart:0,symbolInstanceEnd:o.symbolInstances.length,parameters:v});}attemptAnchorPlacement(e,i,a,r,o,s,n,l,c,h,u,d,_,p,m,f,g,v,x,b){const y=t.aO[e.textAnchor],w=[e.textOffset0,e.textOffset1],T=nt(y,a,r,w,o),P=this.collisionIndex.placeCollisionBox(i,d,l,c,h,n,s,f,u.predicate,x,T,b);if((!v||this.collisionIndex.placeCollisionBox(v,d,l,c,h,n,s,g,u.predicate,x,T,b).placeable)&&P.placeable){let e;if(this.prevPlacement&&this.prevPlacement.variableOffsets[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID]&&this.prevPlacement.placements[_.crossTileID].text&&(e=this.prevPlacement.variableOffsets[_.crossTileID].anchor),0===_.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");return this.variableOffsets[_.crossTileID]={textOffset:w,width:a,height:r,anchor:y,textBoxScale:o,prevAnchor:e},this.markUsedJustification(p,y,_,m),p.allowVerticalPlacement&&(this.markUsedOrientation(p,m,_),this.placedOrientations[_.crossTileID]=m),{shift:T,placedGlyphBoxes:P}}}placeLayerBucketPart(e,i,a){const{bucket:r,layout:o,translationText:s,translationIcon:n,unwrappedTileID:l,pitchedLabelPlaneMatrix:c,textPixelRatio:h,holdingForFade:u,collisionBoxArray:d,partiallyEvaluatedTextSize:_,collisionGroup:p}=e.parameters,m=o.get("text-optional"),f=o.get("icon-optional"),g=t.aP(o,"text-overlap","text-allow-overlap"),v="always"===g,x=t.aP(o,"icon-overlap","icon-allow-overlap"),b="always"===x,y="map"===o.get("text-rotation-alignment"),w="map"===o.get("text-pitch-alignment"),T="none"!==o.get("icon-text-fit"),P="viewport-y"===o.get("symbol-z-order"),C=v&&(b||!r.hasIconData()||f),M=b&&(v||!r.hasTextData()||m);!r.collisionArrays&&d&&r.deserializeCollisionBoxes(d);const I=this.retainedQueryData[r.bucketInstanceId].tileID,E=this._getTerrainElevationFunc(I),S=this.transform.getFastPathSimpleProjectionMatrix(I),R=(e,d,b)=>{var P,R;if(i[e.crossTileID])return;if(u)return void(this.placements[e.crossTileID]=new rt(!1,!1,!1));let D=!1,z=!1,A=!0,L=null,k={box:null,placeable:!1,offscreen:null,occluded:!1},F={placeable:!1},B=null,O=null,j=null,N=0,Z=0,G=0;d.textFeatureIndex?N=d.textFeatureIndex:e.useRuntimeCollisionCircles&&(N=e.featureIndex),d.verticalTextFeatureIndex&&(Z=d.verticalTextFeatureIndex);const U=d.textBox;if(U){const i=i=>{let a=t.ay.horizontal;if(r.allowVerticalPlacement&&!i&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[e.crossTileID];t&&(this.placedOrientations[e.crossTileID]=t,a=t,this.markUsedOrientation(r,a,e));}return a},o=(i,a)=>{if(r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&d.verticalTextBox){for(const e of r.writingModes)if(e===t.ay.vertical?(k=a(),F=k):k=i(),k&&k.placeable)break}else k=i();},c=e.textAnchorOffsetStartIndex,u=e.textAnchorOffsetEndIndex;if(u===c){const a=(t,i)=>{const a=this.collisionIndex.placeCollisionBox(t,g,h,I,l,w,y,s,p.predicate,E,void 0,S);return a&&a.placeable&&(this.markUsedOrientation(r,i,e),this.placedOrientations[e.crossTileID]=i),a};o((()=>a(U,t.ay.horizontal)),(()=>{const i=d.verticalTextBox;return r.allowVerticalPlacement&&e.numVerticalGlyphVertices>0&&i?a(i,t.ay.vertical):{box:null,offscreen:null}})),i(k&&k.placeable);}else {let _=t.aO[null===(R=null===(P=this.prevPlacement)||void 0===P?void 0:P.variableOffsets[e.crossTileID])||void 0===R?void 0:R.anchor];const m=(t,i,o)=>{const d=t.x2-t.x1,m=t.y2-t.y1,f=e.textBoxScale,v=T&&"never"===x?i:null;let b=null,P="never"===g?1:2,C="never";_&&P++;for(let i=0;i<P;i++){for(let i=c;i<u;i++){const a=r.textAnchorOffsets.get(i);if(_&&a.textAnchor!==_)continue;const c=this.attemptAnchorPlacement(a,t,d,m,f,y,w,h,I,l,p,C,e,r,o,s,n,v,E);if(c&&(b=c.placedGlyphBoxes,b&&b.placeable))return D=!0,L=c.shift,b}_?_=null:C=g;}return a&&!b&&(b={box:this.collisionIndex.placeCollisionBox(U,"always",h,I,l,w,y,s,p.predicate,E,void 0,S).box,offscreen:!1,placeable:!1,occluded:!1}),b};o((()=>m(U,d.iconBox,t.ay.horizontal)),(()=>{const i=d.verticalTextBox;return r.allowVerticalPlacement&&(!k||!k.placeable)&&e.numVerticalGlyphVertices>0&&i?m(i,d.verticalIconBox,t.ay.vertical):{box:null,occluded:!0,offscreen:null}})),k&&(D=k.placeable,A=k.offscreen);const f=i(k&&k.placeable);if(!D&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[e.crossTileID];t&&(this.variableOffsets[e.crossTileID]=t,this.markUsedJustification(r,t.anchor,e,f));}}}if(B=k,D=B&&B.placeable,A=B&&B.offscreen,e.useRuntimeCollisionCircles&&e.centerJustifiedTextSymbolIndex>=0){const i=r.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex),n=t.az(r.textSizeData,_,i),h=o.get("text-padding");O=this.collisionIndex.placeCollisionCircles(g,i,r.lineVertexArray,r.glyphOffsetArray,n,l,c,a,w,p.predicate,e.collisionCircleDiameter,h,s,E),O.circles.length&&O.collisionDetected&&!a&&t.w("Collisions detected, but collision boxes are not shown"),D=v||O.circles.length>0&&!O.collisionDetected,A=A&&O.offscreen;}if(d.iconFeatureIndex&&(G=d.iconFeatureIndex),d.iconBox){const e=e=>this.collisionIndex.placeCollisionBox(e,x,h,I,l,w,y,n,p.predicate,E,T&&L?L:void 0,S);F&&F.placeable&&d.verticalIconBox?(j=e(d.verticalIconBox),z=j.placeable):(j=e(d.iconBox),z=j.placeable),A=A&&j.offscreen;}const V=m||0===e.numHorizontalGlyphVertices&&0===e.numVerticalGlyphVertices,q=f||0===e.numIconVertices;V||q?q?V||(z=z&&D):D=z&&D:z=D=z&&D;const W=z&&j.placeable;if(D&&B.placeable&&this.collisionIndex.insertCollisionBox(B.box,g,o.get("text-ignore-placement"),r.bucketInstanceId,F&&F.placeable&&Z?Z:N,p.ID),W&&this.collisionIndex.insertCollisionBox(j.box,x,o.get("icon-ignore-placement"),r.bucketInstanceId,G,p.ID),O&&D&&this.collisionIndex.insertCollisionCircles(O.circles,g,o.get("text-ignore-placement"),r.bucketInstanceId,N,p.ID),a&&this.storeCollisionData(r.bucketInstanceId,b,d,B,j,O),0===e.crossTileID)throw new Error("symbolInstance.crossTileID can't be 0");if(0===r.bucketInstanceId)throw new Error("bucket.bucketInstanceId can't be 0");this.placements[e.crossTileID]=new rt((D||C)&&!(null==B?void 0:B.occluded),(z||M)&&!(null==j?void 0:j.occluded),A||r.justReloaded),i[e.crossTileID]=!0;};if(P){if(0!==e.symbolInstanceStart)throw new Error("bucket.bucketInstanceId should be 0");const t=r.getSortedSymbolIndexes(-this.transform.bearingInRadians);for(let e=t.length-1;e>=0;--e){const i=t[e];R(r.symbolInstances.get(i),r.collisionArrays[i],i);}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)R(r.symbolInstances.get(t),r.collisionArrays[t],t);r.justReloaded=!1;}storeCollisionData(e,t,i,a,r,o){if(i.textBox||i.iconBox){let o,s;this.collisionBoxArrays.has(e)?o=this.collisionBoxArrays.get(e):(o=new Map,this.collisionBoxArrays.set(e,o)),o.has(t)?s=o.get(t):(s={text:null,icon:null},o.set(t,s)),i.textBox&&(s.text=a.box),i.iconBox&&(s.icon=r.box);}if(o){let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=[]);for(let e=0;e<o.circles.length;e+=4)t.push(o.circles[e+0]-et),t.push(o.circles[e+1]-et),t.push(o.circles[e+2]),t.push(o.collisionDetected?1:0);}}markUsedJustification(e,i,a,r){let o;o=r===t.ay.vertical?a.verticalPlacedTextSymbolIndex:{left:a.leftJustifiedTextSymbolIndex,center:a.centerJustifiedTextSymbolIndex,right:a.rightJustifiedTextSymbolIndex}[t.aQ(i)];const s=[a.leftJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.rightJustifiedTextSymbolIndex,a.verticalPlacedTextSymbolIndex];for(const t of s)t>=0&&(e.text.placedSymbolArray.get(t).crossTileID=o>=0&&t!==o?0:a.crossTileID);}markUsedOrientation(e,i,a){const r=i===t.ay.horizontal||i===t.ay.horizontalOnly?i:0,o=i===t.ay.vertical?i:0,s=[a.leftJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.rightJustifiedTextSymbolIndex];for(const t of s)e.text.placedSymbolArray.get(t).placedOrientation=r;a.verticalPlacedTextSymbolIndex&&(e.text.placedSymbolArray.get(a.verticalPlacedTextSymbolIndex).placedOrientation=o);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const a=t?t.symbolFadeChange(e):1,r=t?t.opacities:{},o=t?t.variableOffsets:{},s=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],o=r[e];o?(this.opacities[e]=new at(o,a,t.text,t.icon),i=i||t.text!==o.text.placed||t.icon!==o.icon.placed):(this.opacities[e]=new at(null,a,t.text,t.icon,t.skipFade),i=i||t.text||t.icon);}for(const e in r){const t=r[e];if(!this.opacities[e]){const r=new at(t,a,!1,!1);r.isHidden()||(this.opacities[e]=r,i=i||t.text.placed||t.icon.placed);}}for(const e in o)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=o[e]);for(const e in s)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=s[e]);if(t&&void 0===t.lastPlacementChangeTime)throw new Error("Last placement time for previous placement is not defined");i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t){const i={};for(const a of t){const t=a.getBucket(e);t&&a.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,a.tileID,i,a.collisionBoxArray);}}updateBucketOpacities(e,i,a,r){e.hasTextData()&&(e.text.opacityVertexArray.clear(),e.text.hasVisibleVertices=!1),e.hasIconData()&&(e.icon.opacityVertexArray.clear(),e.icon.hasVisibleVertices=!1),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const o=e.layers[0],s=o.layout,n=new at(null,0,!1,!1,!0),l=s.get("text-allow-overlap"),c=s.get("icon-allow-overlap"),h=o._unevaluatedLayout.hasValue("text-variable-anchor")||o._unevaluatedLayout.hasValue("text-variable-anchor-offset"),u="map"===s.get("text-rotation-alignment"),d="map"===s.get("text-pitch-alignment"),_="none"!==s.get("icon-text-fit"),p=new at(null,0,l&&(c||!e.hasIconData()||s.get("icon-optional")),c&&(l||!e.hasTextData()||s.get("text-optional")),!0);!e.collisionArrays&&r&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(r);const m=(e,t,i)=>{for(let a=0;a<t/4;a++)e.opacityVertexArray.emplaceBack(i);e.hasVisibleVertices=e.hasVisibleVertices||i!==vt;},f=this.collisionBoxArrays.get(e.bucketInstanceId);for(let i=0;i<e.symbolInstances.length;i++){const r=e.symbolInstances.get(i),{numHorizontalGlyphVertices:o,numVerticalGlyphVertices:s,crossTileID:l}=r;let c=this.opacities[l];a[l]?c=n:c||(c=p,this.opacities[l]=c),a[l]=!0;const g=r.numIconVertices>0,v=this.placedOrientations[r.crossTileID],x=v===t.ay.vertical,b=v===t.ay.horizontal||v===t.ay.horizontalOnly;if(o>0||s>0){const t=gt(c.text);m(e.text,o,x?vt:t),m(e.text,s,b?vt:t);const i=c.text.isHidden();[r.rightJustifiedTextSymbolIndex,r.centerJustifiedTextSymbolIndex,r.leftJustifiedTextSymbolIndex].forEach((t=>{t>=0&&(e.text.placedSymbolArray.get(t).hidden=i||x?1:0);})),r.verticalPlacedTextSymbolIndex>=0&&(e.text.placedSymbolArray.get(r.verticalPlacedTextSymbolIndex).hidden=i||b?1:0);const a=this.variableOffsets[r.crossTileID];a&&this.markUsedJustification(e,a.anchor,r,v);const n=this.placedOrientations[r.crossTileID];n&&(this.markUsedJustification(e,"left",r,n),this.markUsedOrientation(e,n,r));}if(g){const t=gt(c.icon),i=!(_&&r.verticalPlacedIconSymbolIndex&&x);r.placedIconSymbolIndex>=0&&(m(e.icon,r.numIconVertices,i?t:vt),e.icon.placedSymbolArray.get(r.placedIconSymbolIndex).hidden=c.icon.isHidden()),r.verticalPlacedIconSymbolIndex>=0&&(m(e.icon,r.numVerticalIconVertices,i?vt:t),e.icon.placedSymbolArray.get(r.verticalPlacedIconSymbolIndex).hidden=c.icon.isHidden());}const y=f&&f.has(i)?f.get(i):{text:null,icon:null};if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const a=e.collisionArrays[i];if(a){let i=new t.P(0,0);if(a.textBox||a.verticalTextBox){let t=!0;if(h){const e=this.variableOffsets[l];e?(i=nt(e.anchor,e.width,e.height,e.textOffset,e.textBoxScale),u&&i._rotate(d?-this.transform.bearingInRadians:this.transform.bearingInRadians)):t=!1;}if(a.textBox||a.verticalTextBox){let r;a.textBox&&(r=x),a.verticalTextBox&&(r=b),ct(e.textCollisionBox.collisionVertexArray,c.text.placed,!t||r,y.text,i.x,i.y);}}if(a.iconBox||a.verticalIconBox){const t=Boolean(!b&&a.verticalIconBox);let r;a.iconBox&&(r=t),a.verticalIconBox&&(r=!t),ct(e.iconCollisionBox.collisionVertexArray,c.icon.placed,r,y.icon,_?i.x:0,_?i.y:0);}}}}if(e.sortFeatures(-this.transform.bearingInRadians),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.text.opacityVertexArray.length!==e.text.layoutVertexArray.length/4)throw new Error(`bucket.text.opacityVertexArray.length (= ${e.text.opacityVertexArray.length}) !== bucket.text.layoutVertexArray.length (= ${e.text.layoutVertexArray.length}) / 4`);if(e.icon.opacityVertexArray.length!==e.icon.layoutVertexArray.length/4)throw new Error(`bucket.icon.opacityVertexArray.length (= ${e.icon.opacityVertexArray.length}) !== bucket.icon.layoutVertexArray.length (= ${e.icon.layoutVertexArray.length}) / 4`);e.bucketInstanceId in this.collisionCircleArrays&&(e.collisionCircleArray=this.collisionCircleArrays[e.bucketInstanceId],delete this.collisionCircleArrays[e.bucketInstanceId]);}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function ct(e,t,i,a,r,o){a&&0!==a.length||(a=[0,0,0,0]);const s=a[0]-et,n=a[1]-et,l=a[2]-et,c=a[3]-et;e.emplaceBack(t?1:0,i?1:0,r||0,o||0,s,n),e.emplaceBack(t?1:0,i?1:0,r||0,o||0,l,n),e.emplaceBack(t?1:0,i?1:0,r||0,o||0,l,c),e.emplaceBack(t?1:0,i?1:0,r||0,o||0,s,c);}const ht=Math.pow(2,25),ut=Math.pow(2,24),dt=Math.pow(2,17),_t=Math.pow(2,16),pt=Math.pow(2,9),mt=Math.pow(2,8),ft=Math.pow(2,1);function gt(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*ht+t*ut+i*dt+t*_t+i*pt+t*mt+i*ft+t}const vt=0;class xt{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&!e.layout.get("symbol-sort-key").isConstant(),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(e,t,i,a,r){const o=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(o,a,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,r())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,o.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<o.length;)if(t.placeLayerBucketPart(o[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,r())return !0;return !1}}class bt{constructor(e,t,i,a,r,o,s,n){this.placement=new lt(e,t,o,s,n),this._currentPlacementIndex=i.length-1,this._forceFullPlacement=a,this._showCollisionBoxes=r,this._done=!1;}isDone(){return this._done}continuePlacement(e,t,i){const a=c(),r=()=>!this._forceFullPlacement&&c()-a>2;for(;this._currentPlacementIndex>=0;){const a=t[e[this._currentPlacementIndex]],o=this.placement.collisionIndex.transform.zoom;if("symbol"===a.type&&(!a.minzoom||a.minzoom<=o)&&(!a.maxzoom||a.maxzoom>o)){if(this._inProgressLayer||(this._inProgressLayer=new xt(a)),this._inProgressLayer.continuePlacement(i[a.source],this.placement,this._showCollisionBoxes,a,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const yt=512/t.a4/2;class wt{constructor(e,i,a){this.tileID=e,this.bucketInstanceId=a,this._symbolsByKey={};const r=new Map;for(let e=0;e<i.length;e++){const t=i.get(e),a=t.key,o=r.get(a);o?o.push(t):r.set(a,[t]);}for(const[e,i]of r){const a={positions:i.map((e=>({x:Math.floor(e.anchorX*yt),y:Math.floor(e.anchorY*yt)}))),crossTileIDs:i.map((e=>e.crossTileID))};if(a.positions.length>128){const e=new t.aS(a.positions.length,16,Uint16Array);for(const{x:t,y:i}of a.positions)e.add(t,i);e.finish(),delete a.positions,a.index=e;}this._symbolsByKey[e]=a;}}getScaledCoordinates(e,i){const{x:a,y:r,z:o}=this.tileID.canonical,{x:s,y:n,z:l}=i.canonical,c=yt/Math.pow(2,l-o),h=(n*t.a4+e.anchorY)*c,u=r*t.a4*yt;return {x:Math.floor((s*t.a4+e.anchorX)*c-a*t.a4*yt),y:Math.floor(h-u)}}findMatches(e,t,i){const a=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z);for(let r=0;r<e.length;r++){const o=e.get(r);if(o.crossTileID)continue;const s=this._symbolsByKey[o.key];if(!s)continue;const n=this.getScaledCoordinates(o,t);if(s.index){const e=s.index.range(n.x-a,n.y-a,n.x+a,n.y+a).sort();for(const t of e){const e=s.crossTileIDs[t];if(!i[e]){i[e]=!0,o.crossTileID=e;break}}}else if(s.positions)for(let e=0;e<s.positions.length;e++){const t=s.positions[e],r=s.crossTileIDs[e];if(Math.abs(t.x-n.x)<=a&&Math.abs(t.y-n.y)<=a&&!i[r]){i[r]=!0,o.crossTileID=r;break}}}}getCrossTileIDsLists(){return Object.values(this._symbolsByKey).map((({crossTileIDs:e})=>e))}}class Tt{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class Pt{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],a={};for(const e in i){const r=i[e];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),a[r.tileID.key]=r;}this.indexes[e]=a;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]={});const a=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const r=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in r){const o=r[i];o.tileID.isChildOf(e)&&o.findMatches(t.symbolInstances,e,a);}else {const o=r[e.scaledTo(Number(i)).key];o&&o.findMatches(t.symbolInstances,e,a);}}for(let e=0;e<t.symbolInstances.length;e++){const r=t.symbolInstances.get(e);r.crossTileID||(r.crossTileID=i.generate(),a[r.crossTileID]=!0);}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new wt(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.getCrossTileIDsLists())for(const t of i)delete this.usedCrossTileIDs[e][t];}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const a=this.indexes[i];for(const r in a)e[a[r].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,a[r]),delete a[r],t=!0);}return t}}class Ct{constructor(){this.layerIndexes={},this.crossTileIDs=new Tt,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i){let a=this.layerIndexes[e.id];void 0===a&&(a=this.layerIndexes[e.id]=new Pt);let r=!1;const o={};a.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),a.addBucket(i.tileID,t,this.crossTileIDs)&&(r=!0),o[t.bucketInstanceId]=!0);}return a.removeStaleBuckets(o)&&(r=!0),r}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0;}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}var Mt="void main() {fragColor=vec4(1.0);}";const It={prelude:Et("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nout highp vec4 fragColor;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(unpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}mat3 rotationMatrixFromAxisAngle(vec3 u,float angle) {float c=cos(angle);float s=sin(angle);float c2=1.0-c;return mat3(u.x*u.x*c2+      c,u.x*u.y*c2-u.z*s,u.x*u.z*c2+u.y*s,u.y*u.x*c2+u.z*s,u.y*u.y*c2+    c,u.y*u.z*c2-u.x*s,u.z*u.x*c2-u.y*s,u.z*u.y*c2+u.x*s,u.z*u.z*c2+    c\n);}\n#ifdef TERRAIN3D\nuniform sampler2D u_terrain;uniform float u_terrain_dim;uniform mat4 u_terrain_matrix;uniform vec4 u_terrain_unpack;uniform float u_terrain_exaggeration;uniform highp sampler2D u_depth;\n#endif\nconst highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitShifts=vec4(1.)/bitSh;highp float unpack(highp vec4 color) {return dot(color,bitShifts);}highp float depthOpacity(vec3 frag) {\n#ifdef TERRAIN3D\nhighp float d=unpack(texture(u_depth,frag.xy*0.5+0.5))+0.0001-frag.z;return 1.0-max(0.0,min(1.0,-d*500.0));\n#else\nreturn 1.0;\n#endif\n}float calculate_visibility(vec4 pos) {\n#ifdef TERRAIN3D\nvec3 frag=pos.xyz/pos.w;highp float d=depthOpacity(frag);if (d > 0.95) return 1.0;return (d+depthOpacity(frag+vec3(0.0,0.01,0.0)))/2.0;\n#else\nreturn 1.0;\n#endif\n}float ele(vec2 pos) {\n#ifdef TERRAIN3D\nvec4 rgb=(texture(u_terrain,pos)*255.0)*u_terrain_unpack;return rgb.r+rgb.g+rgb.b-u_terrain_unpack.a;\n#else\nreturn 0.0;\n#endif\n}float get_elevation(vec2 pos) {\n#ifdef TERRAIN3D\n#ifdef GLOBE\nif ((pos.y <-32767.5) || (pos.y > 32766.5)) {return 0.0;}\n#endif\nvec2 coord=(u_terrain_matrix*vec4(pos,0.0,1.0)).xy*u_terrain_dim+1.0;vec2 f=fract(coord);vec2 c=(floor(coord)+0.5)/(u_terrain_dim+2.0);float d=1.0/(u_terrain_dim+2.0);float tl=ele(c);float tr=ele(c+vec2(d,0.0));float bl=ele(c+vec2(0.0,d));float br=ele(c+vec2(d,d));float elevation=mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);return elevation*u_terrain_exaggeration;\n#else\nreturn 0.0;\n#endif\n}const float PI=3.141592653589793;uniform mat4 u_projection_matrix;"),projectionMercator:Et("","float projectLineThickness(float tileY) {return 1.0;}float projectCircleRadius(float tileY) {return 1.0;}vec4 projectTile(vec2 p) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);return result;}vec4 projectTile(vec2 p,vec2 rawPos) {vec4 result=u_projection_matrix*vec4(p,0.0,1.0);if (rawPos.y <-32767.5 || rawPos.y > 32766.5) {result.z=-10000000.0;}return result;}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return u_projection_matrix*vec4(posInTile,elevation,1.0);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {return projectTileWithElevation(posInTile,elevation);}"),projectionGlobe:Et("","#define GLOBE_RADIUS 6371008.8\nuniform highp vec4 u_projection_tile_mercator_coords;uniform highp vec4 u_projection_clipping_plane;uniform highp float u_projection_transition;uniform mat4 u_projection_fallback_matrix;vec3 globeRotateVector(vec3 vec,vec2 angles) {vec3 axisRight=vec3(vec.z,0.0,-vec.x);vec3 axisUp=cross(axisRight,vec);axisRight=normalize(axisRight);axisUp=normalize(axisUp);vec2 t=tan(angles);return normalize(vec+axisRight*t.x+axisUp*t.y);}mat3 globeGetRotationMatrix(vec3 spherePos) {vec3 axisRight=vec3(spherePos.z,0.0,-spherePos.x);vec3 axisDown=cross(axisRight,spherePos);axisRight=normalize(axisRight);axisDown=normalize(axisDown);return mat3(axisRight,axisDown,spherePos\n);}float circumferenceRatioAtTileY(float tileY) {float mercator_pos_y=u_projection_tile_mercator_coords.y+u_projection_tile_mercator_coords.w*tileY;float spherical_y=2.0*atan(exp(PI-(mercator_pos_y*PI*2.0)))-PI*0.5;return cos(spherical_y);}float projectLineThickness(float tileY) {float thickness=1.0/circumferenceRatioAtTileY(tileY); \nif (u_projection_transition < 0.999) {return mix(1.0,thickness,u_projection_transition);} else {return thickness;}}vec3 projectToSphere(vec2 translatedPos,vec2 rawPos) {vec2 mercator_pos=u_projection_tile_mercator_coords.xy+u_projection_tile_mercator_coords.zw*translatedPos;vec2 spherical;spherical.x=mercator_pos.x*PI*2.0+PI;spherical.y=2.0*atan(exp(PI-(mercator_pos.y*PI*2.0)))-PI*0.5;float len=cos(spherical.y);vec3 pos=vec3(sin(spherical.x)*len,sin(spherical.y),cos(spherical.x)*len\n);if (rawPos.y <-32767.5) {pos=vec3(0.0,1.0,0.0);}if (rawPos.y > 32766.5) {pos=vec3(0.0,-1.0,0.0);}return pos;}vec3 projectToSphere(vec2 posInTile) {return projectToSphere(posInTile,vec2(0.0,0.0));}float globeComputeClippingZ(vec3 spherePos) {return (1.0-(dot(spherePos,u_projection_clipping_plane.xyz)+u_projection_clipping_plane.w));}vec4 interpolateProjection(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);globePosition.z=globeComputeClippingZ(elevatedPos)*globePosition.w;if (u_projection_transition > 0.999) {return globePosition;}vec4 flatPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);const float z_globeness_threshold=0.2;vec4 result=globePosition;result.z=mix(0.0,globePosition.z,clamp((u_projection_transition-z_globeness_threshold)/(1.0-z_globeness_threshold),0.0,1.0));result.xyw=mix(flatPosition.xyw,globePosition.xyw,u_projection_transition);if ((posInTile.y <-32767.5) || (posInTile.y > 32766.5)) {result=globePosition;const float poles_hidden_anim_percentage=0.02;result.z=mix(globePosition.z,100.0,pow(max((1.0-u_projection_transition)/poles_hidden_anim_percentage,0.0),8.0));}return result;}vec4 interpolateProjectionFor3D(vec2 posInTile,vec3 spherePos,float elevation) {vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);vec4 globePosition=u_projection_matrix*vec4(elevatedPos,1.0);if (u_projection_transition > 0.999) {return globePosition;}vec4 fallbackPosition=u_projection_fallback_matrix*vec4(posInTile,elevation,1.0);return mix(fallbackPosition,globePosition,u_projection_transition);}vec4 projectTile(vec2 posInTile) {return interpolateProjection(posInTile,projectToSphere(posInTile),0.0);}vec4 projectTile(vec2 posInTile,vec2 rawPos) {return interpolateProjection(posInTile,projectToSphere(posInTile,rawPos),0.0);}vec4 projectTileWithElevation(vec2 posInTile,float elevation) {return interpolateProjection(posInTile,projectToSphere(posInTile),elevation);}vec4 projectTileFor3D(vec2 posInTile,float elevation) {vec3 spherePos=projectToSphere(posInTile,posInTile);return interpolateProjectionFor3D(posInTile,spherePos,elevation);}"),background:Et("uniform vec4 u_color;uniform float u_opacity;void main() {fragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),backgroundPattern:Et("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;void main() {gl_Position=projectTile(a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),circle:Et("in vec3 v_data;in float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);float antialiased_blur=v_data.z;float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(antialiased_blur,0.0,extrude_length-radius/(radius+stroke_width));fragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);const float epsilon=0.5/255.0;if (fragColor.r < epsilon && fragColor.g < epsilon && fragColor.b < epsilon && fragColor.a < epsilon) {discard;}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform bool u_scale_with_map;uniform bool u_pitch_with_map;uniform vec2 u_extrude_scale;uniform highp float u_globe_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;uniform vec2 u_translate;in vec2 a_pos;out vec3 v_data;out float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 pos_raw=a_pos+32768.0;vec2 extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);vec2 circle_center=floor(pos_raw/8.0)+u_translate;float ele=get_elevation(circle_center);v_visibility=calculate_visibility(projectTileWithElevation(circle_center,ele));if (u_pitch_with_map) {\n#ifdef GLOBE\nvec3 center_vector=projectToSphere(circle_center);\n#endif\nfloat angle_scale=u_globe_extrude_scale;vec2 corner_position=circle_center;if (u_scale_with_map) {angle_scale*=(radius+stroke_width);corner_position+=extrude*u_extrude_scale*(radius+stroke_width);} else {\n#ifdef GLOBE\nvec4 projected_center=interpolateProjection(circle_center,center_vector,ele);\n#else\nvec4 projected_center=projectTileWithElevation(circle_center,ele);\n#endif\ncorner_position+=extrude*u_extrude_scale*(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);angle_scale*=(radius+stroke_width)*(projected_center.w/u_camera_to_center_distance);}\n#ifdef GLOBE\nvec2 angles=extrude*angle_scale;vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(corner_position,corner_vector,ele);\n#else\ngl_Position=projectTileWithElevation(corner_position,ele);\n#endif\n} else {gl_Position=projectTileWithElevation(circle_center,ele);if (gl_Position.z/gl_Position.w > 1.0) {gl_Position.xy=vec2(10000.0);}if (u_scale_with_map) {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*u_camera_to_center_distance;} else {gl_Position.xy+=extrude*(radius+stroke_width)*u_extrude_scale*gl_Position.w;}}float antialiasblur=-max(1.0/u_device_pixel_ratio/(radius+stroke_width),blur);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),clippingMask:Et(Mt,"in vec2 a_pos;void main() {gl_Position=projectTile(a_pos);}"),heatmap:Et("uniform highp float u_intensity;in vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);fragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;uniform highp float u_globe_extrude_scale;in vec2 a_pos;out vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 pos_raw=a_pos+32768.0;vec2 unscaled_extrude=vec2(mod(pos_raw,8.0)/7.0*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 circle_center=floor(pos_raw/8.0);\n#ifdef GLOBE\nvec2 angles=v_extrude*radius*u_globe_extrude_scale;vec3 center_vector=projectToSphere(circle_center);vec3 corner_vector=globeRotateVector(center_vector,angles);gl_Position=interpolateProjection(circle_center+extrude,corner_vector,0.0);\n#else\ngl_Position=projectTileFor3D(circle_center+extrude,get_elevation(circle_center));\n#endif\n}"),heatmapTexture:Et("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;in vec2 v_pos;void main() {float t=texture(u_image,v_pos).r;vec4 color=texture(u_color_ramp,vec2(t,0.5));fragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),collisionBox:Et("in float v_placed;in float v_notUsed;void main() {float alpha=0.5;fragColor=vec4(1.0,0.0,0.0,1.0)*alpha;if (v_placed > 0.5) {fragColor=vec4(0.0,0.0,1.0,0.5)*alpha;}if (v_notUsed > 0.5) {fragColor*=.1;}}","in vec2 a_anchor_pos;in vec2 a_placed;in vec2 a_box_real;uniform vec2 u_pixel_extrude_scale;out float v_placed;out float v_notUsed;void main() {gl_Position=projectTileWithElevation(a_anchor_pos,get_elevation(a_anchor_pos));gl_Position.xy=((a_box_real+0.5)*u_pixel_extrude_scale*2.0-1.0)*vec2(1.0,-1.0)*gl_Position.w;if (gl_Position.z/gl_Position.w < 1.1) {gl_Position.z=0.5;}v_placed=a_placed.x;v_notUsed=a_placed.y;}"),collisionCircle:Et("in float v_radius;in vec2 v_extrude;in float v_collision;void main() {float alpha=0.5;float stroke_radius=0.9;float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);fragColor=color*alpha*opacity_t;}","in vec2 a_pos;in float a_radius;in vec2 a_flags;uniform vec2 u_viewport_size;out float v_radius;out vec2 v_extrude;out float v_collision;void main() {float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(mix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_collision=collision;gl_Position=vec4((a_pos/u_viewport_size*2.0-1.0)*vec2(1.0,-1.0),0.0,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),colorRelief:Et("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;uniform vec4 u_unpack;uniform sampler2D u_elevation_stops;uniform sampler2D u_color_stops;uniform int u_color_ramp_size;uniform float u_opacity;in vec2 v_pos;float getElevation(vec2 coord) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}float getElevationStop(int stop) {float x=(float(stop)+0.5)/float(u_color_ramp_size);vec4 data=texture(u_elevation_stops,vec2(x,0))*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {float el=getElevation(v_pos);int r=(u_color_ramp_size-1);int l=0;float el_l=getElevationStop(l);float el_r=getElevationStop(r);while(r-l > 1){int m=(r+l)/2;float el_m=getElevationStop(m);if(el < el_m){r=m;el_r=el_m;}else\n{l=m;el_l=el_m;}}float x=(float(l)+(el-el_l)/(el_r-el_l)+0.5)/float(u_color_ramp_size);fragColor=u_opacity*texture(u_color_stops,vec2(x,0));\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_dimension;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_pos/8192.0)*scale+epsilon;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),debug:Et("uniform highp vec4 u_color;uniform sampler2D u_overlay;in vec2 v_uv;void main() {vec4 overlay_color=texture(u_overlay,v_uv);fragColor=mix(u_color,overlay_color,overlay_color.a);}","in vec2 a_pos;out vec2 v_uv;uniform float u_overlay_scale;void main() {v_uv=a_pos/8192.0;gl_Position=projectTileWithElevation(a_pos*u_overlay_scale,get_elevation(a_pos));}"),depth:Et(Mt,"in vec2 a_pos;void main() {\n#ifdef GLOBE\ngl_Position=projectTileFor3D(a_pos,0.0);\n#else\ngl_Position=u_projection_matrix*vec4(a_pos,0.0,1.0);\n#endif\n}"),fill:Et("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nfragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_fill_translate;in vec2 a_pos;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);}"),fillOutline:Et("in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=outline_color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillOutlinePattern:Et("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;in vec2 v_pos_a;in vec2 v_pos_b;in vec2 v_pos;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);fragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;out vec2 v_pos;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n}"),fillPattern:Et("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);fragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;uniform vec2 u_fill_translate;in vec2 a_pos;out vec2 v_pos_a;out vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=projectTile(a_pos+u_fill_translate,a_pos);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),fillExtrusion:Et("in vec4 v_color;void main() {fragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\nout vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 normal=a_normal_ed.xyz;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;vec3 normalForLighting=normal/16384.0;float directional=clamp(dot(normalForLighting,u_lightpos),0.0,1.0);\n#ifdef GLOBE\nmat3 rotMatrix=globeGetRotationMatrix(spherePos);normalForLighting=rotMatrix*normalForLighting;directional=mix(directional,clamp(dot(normalForLighting,u_lightpos_globe),0.0,1.0),u_projection_transition);\n#endif\ndirectional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),fillExtrusionPattern:Et("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;in vec2 v_pos_a;in vec2 v_pos_b;in vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);fragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec2 u_fill_translate;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp vec3 u_lightpos_globe;uniform lowp float u_lightintensity;in vec2 a_pos;in vec4 a_normal_ed;\n#ifdef TERRAIN3D\nin vec2 a_centroid;\n#endif\n#ifdef GLOBE\nout vec3 v_sphere_pos;\n#endif\nout vec2 v_pos_a;out vec2 v_pos_b;out vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 normal=a_normal_ed.xyz;float edgedistance=a_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;\n#ifdef TERRAIN3D\nfloat height_terrain3d_offset=get_elevation(a_centroid);float base_terrain3d_offset=height_terrain3d_offset-(base > 0.0 ? 0.0 : 10.0);\n#else\nfloat height_terrain3d_offset=0.0;float base_terrain3d_offset=0.0;\n#endif\nbase=max(0.0,base)+base_terrain3d_offset;height=max(0.0,height)+height_terrain3d_offset;float t=mod(normal.x,2.0);float elevation=t > 0.0 ? height : base;vec2 posInTile=a_pos+u_fill_translate;\n#ifdef GLOBE\nvec3 spherePos=projectToSphere(posInTile,a_pos);vec3 elevatedPos=spherePos*(1.0+elevation/GLOBE_RADIUS);v_sphere_pos=elevatedPos;gl_Position=interpolateProjectionFor3D(posInTile,spherePos,elevation);\n#else\ngl_Position=u_projection_matrix*vec4(posInTile,elevation,1.0);\n#endif\nvec2 pos=normal.x==1.0 && normal.y==0.0 && normal.z==16384.0\n? a_pos\n: vec2(edgedistance,elevation*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal/16383.0,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=((1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),hillshadePrepare:Et("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack);}void main() {vec2 epsilon=1.0/u_dimension;float tileSize=u_dimension.x-2.0;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2((c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c))*tileSize/pow(2.0,exaggeration+(28.2562-u_zoom));fragColor=clamp(vec4(deriv.x/8.0+0.5,deriv.y/8.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;in vec2 a_pos;in vec2 a_texture_pos;out vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Et("uniform sampler2D u_image;in vec2 v_pos;uniform vec2 u_latrange;uniform float u_exaggeration;uniform vec4 u_accent;uniform int u_method;uniform float u_altitudes[NUM_ILLUMINATION_SOURCES];uniform float u_azimuths[NUM_ILLUMINATION_SOURCES];uniform vec4 u_shadows[NUM_ILLUMINATION_SOURCES];uniform vec4 u_highlights[NUM_ILLUMINATION_SOURCES];\n#define PI 3.141592653589793\n#define STANDARD 0\n#define COMBINED 1\n#define IGOR 2\n#define MULTIDIRECTIONAL 3\n#define BASIC 4\nfloat get_aspect(vec2 deriv){return deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);}void igor_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float aspect=get_aspect(deriv);float azimuth=u_azimuths[0]+PI;float slope_stength=atan(length(deriv))*2.0/PI;float aspect_strength=1.0-abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);float shadow_strength=slope_stength*aspect_strength;float highlight_strength=slope_stength*(1.0-aspect_strength);fragColor=u_shadows[0]*shadow_strength+u_highlights[0]*highlight_strength;}void standard_hillshade(vec2 deriv){float azimuth=u_azimuths[0]+PI;float slope=atan(0.625*length(deriv));float aspect=get_aspect(deriv);float intensity=u_exaggeration;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadows[0],u_highlights[0],shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);fragColor=accent_color*(1.0-shade_color.a)+shade_color;}void basic_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor=u_highlights[0]*(2.0*shade-1.0);}else\n{fragColor=u_shadows[0]*(1.0-2.0*shade);}}void multidirectional_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;fragColor=vec4(0,0,0,0);for(int i=0; i < NUM_ILLUMINATION_SOURCES; i++){float cos_alt=cos(u_altitudes[i]);float sin_alt=sin(u_altitudes[i]);float cos_az=-cos(u_azimuths[i]);float sin_az=-sin(u_azimuths[i]);float cang=(sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv));float shade=clamp(cang,0.0,1.0);if(shade > 0.5){fragColor+=u_highlights[i]*(2.0*shade-1.0)/float(NUM_ILLUMINATION_SOURCES);}else\n{fragColor+=u_shadows[i]*(1.0-2.0*shade)/float(NUM_ILLUMINATION_SOURCES);}}}void combined_hillshade(vec2 deriv){deriv=deriv*u_exaggeration*2.0;float azimuth=u_azimuths[0]+PI;float cos_az=cos(azimuth);float sin_az=sin(azimuth);float cos_alt=cos(u_altitudes[0]);float sin_alt=sin(u_altitudes[0]);float cang=acos((sin_alt-(deriv.y*cos_az*cos_alt-deriv.x*sin_az*cos_alt))/sqrt(1.0+dot(deriv,deriv)));cang=clamp(cang,0.0,PI/2.0);float shade=cang*atan(length(deriv))*4.0/PI/PI;float highlight=(PI/2.0-cang)*atan(length(deriv))*4.0/PI/PI;fragColor=u_shadows[0]*shade+u_highlights[0]*highlight;}void main() {vec4 pixel=texture(u_image,v_pos);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));vec2 deriv=((pixel.rg*8.0)-4.0)/scaleFactor;if (u_method==BASIC) {basic_hillshade(deriv);} else if (u_method==COMBINED) {combined_hillshade(deriv);} else if (u_method==IGOR) {igor_hillshade(deriv);} else if (u_method==MULTIDIRECTIONAL) {multidirectional_hillshade(deriv);} else if (u_method==STANDARD) {standard_hillshade(deriv);} else {standard_hillshade(deriv);}\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;in vec2 a_pos;out vec2 v_pos;void main() {gl_Position=projectTile(a_pos,a_pos);v_pos=a_pos/8192.0;if (a_pos.y <-32767.5) {v_pos.y=0.0;}if (a_pos.y > 32766.5) {v_pos.y=1.0;}}"),line:Et("uniform lowp float u_device_pixel_ratio;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp float v_linesofar;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;v_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*2.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),lineGradient:Et("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;in vec2 v_width2;in vec2 v_normal;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_width2=vec2(outset,inset);}"),linePattern:Et("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;in vec2 v_normal;in vec2 v_width2;in float v_linesofar;in float v_gamma_scale;in float v_width;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture(u_image,pos_a),texture(u_image,pos_b),u_fade);fragColor=color*alpha*opacity;\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;out vec2 v_normal;out vec2 v_width2;out float v_linesofar;out float v_gamma_scale;out float v_width;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),lineSDF:Et("uniform lowp float u_device_pixel_ratio;uniform lowp float u_lineatlas_width;uniform sampler2D u_image;uniform float u_mix;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture(u_image,v_tex_a).a;float sdfdist_b=texture(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfgamma=(u_lineatlas_width/256.0/u_device_pixel_ratio)/min(dasharray_from.w,dasharray_to.w);alpha*=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_tileratio;uniform float u_crossfade_from;uniform float u_crossfade_to;uniform float u_lineatlas_height;out vec2 v_normal;out vec2 v_width2;out vec2 v_tex_a;out vec2 v_tex_b;out float v_gamma_scale;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nfloat u_patternscale_a_x=u_tileratio/dasharray_from.w/u_crossfade_from;float u_patternscale_a_y=-dasharray_from.z/2.0/u_lineatlas_height;float u_patternscale_b_x=u_tileratio/dasharray_to.w/u_crossfade_to;float u_patternscale_b_y=-dasharray_to.z/2.0/u_lineatlas_height;v_tex_a=vec2(a_linesofar*u_patternscale_a_x/floorwidth,normal.y*u_patternscale_a_y+(float(dasharray_from.y)+0.5)/u_lineatlas_height);v_tex_b=vec2(a_linesofar*u_patternscale_b_x/floorwidth,normal.y*u_patternscale_b_y+(float(dasharray_to.y)+0.5)/u_lineatlas_height);v_width2=vec2(outset,inset);}"),lineGradientSDF:Et("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform sampler2D u_image_dash;uniform float u_mix;uniform lowp float u_lineatlas_width;in vec2 v_normal;in vec2 v_width2;in vec2 v_tex_a;in vec2 v_tex_b;in float v_gamma_scale;in highp vec2 v_uv;\n#ifdef GLOBE\nin float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture(u_image,v_uv);float sdfdist_a=texture(u_image_dash,v_tex_a).a;float sdfdist_b=texture(u_image_dash,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);float sdfgamma=(u_lineatlas_width/256.0)/min(dasharray_from.w,dasharray_to.w);float dash_alpha=smoothstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);fragColor=color*(alpha*dash_alpha*opacity);\n#ifdef GLOBE\nif (v_depth > 1.0) {discard;}\n#endif\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\n#define LINE_DISTANCE_SCALE 2.0\nin vec2 a_pos_normal;in vec4 a_data;in float a_uv_x;in float a_split_index;uniform vec2 u_translation;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;uniform float u_tileratio;uniform float u_crossfade_from;uniform float u_crossfade_to;uniform float u_lineatlas_height;out vec2 v_normal;out vec2 v_width2;out float v_gamma_scale;out highp vec2 v_uv;out vec2 v_tex_a;out vec2 v_tex_b;\n#ifdef GLOBE\nout float v_depth;\n#endif\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define mediump vec4 dasharray_from\n#pragma mapbox: define mediump vec4 dasharray_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 dasharray_from\n#pragma mapbox: initialize mediump vec4 dasharray_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;float a_linesofar=(floor(a_data.z/4.0)+a_data.w*64.0)*LINE_DISTANCE_SCALE;float texel_height=1.0/u_image_height;float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);float adjustedThickness=projectLineThickness(pos.y);vec4 projected_no_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation);vec4 projected_with_extrude=projectTile(pos+offset2/u_ratio*adjustedThickness+u_translation+dist/u_ratio*adjustedThickness);gl_Position=projected_with_extrude;\n#ifdef GLOBE\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef TERRAIN3D\nv_gamma_scale=1.0;\n#else\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length((projected_with_extrude.xy-projected_no_extrude.xy)/projected_with_extrude.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#endif\nfloat u_patternscale_a_x=u_tileratio/dasharray_from.w/u_crossfade_from;float u_patternscale_a_y=-dasharray_from.z/2.0/u_lineatlas_height;float u_patternscale_b_x=u_tileratio/dasharray_to.w/u_crossfade_to;float u_patternscale_b_y=-dasharray_to.z/2.0/u_lineatlas_height;v_tex_a=vec2(a_linesofar*u_patternscale_a_x/floorwidth,normal.y*u_patternscale_a_y+(float(dasharray_from.y)+0.5)/u_lineatlas_height);v_tex_b=vec2(a_linesofar*u_patternscale_b_x/floorwidth,normal.y*u_patternscale_b_y+(float(dasharray_to.y)+0.5)/u_lineatlas_height);v_width2=vec2(outset,inset);}"),raster:Et("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;in vec2 v_pos0;in vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture(u_image0,v_pos0);vec4 color1=texture(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(dot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);fragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;uniform vec4 u_coords_top;uniform vec4 u_coords_bottom;in vec2 a_pos;out vec2 v_pos0;out vec2 v_pos1;void main() {vec2 fractionalPos=a_pos/8192.0;vec2 position=mix(mix(u_coords_top.xy,u_coords_top.zw,fractionalPos.x),mix(u_coords_bottom.xy,u_coords_bottom.zw,fractionalPos.x),fractionalPos.y);gl_Position=projectTile(position,position);v_pos0=((fractionalPos-0.5)/u_buffer_scale)+0.5;\n#ifdef GLOBE\nif (a_pos.y <-32767.5) {v_pos0.y=0.0;}if (a_pos.y > 32766.5) {v_pos0.y=1.0;}\n#endif\nv_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),symbolIcon:Et("uniform sampler2D u_texture;in vec2 v_tex;in float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;fragColor=texture(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_tex;out float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}gl_Position=finalPos;v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float visibility=calculate_visibility(projectedPoint);v_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));}"),symbolSDF:Et("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;in vec2 v_data0;in vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float inner_edge=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);inner_edge=inner_edge+gamma*gamma_scale;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(inner_edge-gamma_scaled,inner_edge+gamma_scaled,dist);if (u_is_halo) {lowp float halo_edge=(6.0-halo_width/fontScale)/SDF_PX;alpha=min(smoothstep(halo_edge-gamma_scaled,halo_edge+gamma_scaled,dist),1.0-alpha);}fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec4 a_pixeloffset;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_translation;uniform float u_pitched_scale;out vec2 v_data0;out vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),symbolTextAndIcon:Et("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;in vec4 v_data0;in vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;fragColor=texture(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);fragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\nfragColor=vec4(1.0);\n#endif\n}","in vec4 a_pos_offset;in vec4 a_data;in vec3 a_projected_pos;in float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;uniform bool u_is_along_line;uniform bool u_is_variable_anchor;uniform vec2 u_translation;uniform float u_pitched_scale;out vec4 v_data0;out vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;float ele=get_elevation(a_pos);highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 translated_a_pos=a_pos+u_translation;vec4 projectedPoint=projectTileWithElevation(translated_a_pos,ele);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(0.5+0.5*distance_ratio,0.0,4.0);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=projectTileWithElevation(translated_a_pos+vec2(1,0),ele);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos;if (u_is_along_line || u_is_variable_anchor) {projected_pos=vec4(a_projected_pos.xy,ele,1.0);} else if (u_pitch_with_map) {projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy+u_translation,ele,1.0);} else {projected_pos=u_label_plane_matrix*projectTileWithElevation(a_projected_pos.xy+u_translation,ele);}float z=float(u_pitch_with_map)*projected_pos.z/projected_pos.w;float projectionScaling=1.0;\n#ifdef GLOBE\nif(u_pitch_with_map && !u_is_along_line) {float anchor_pos_tile_y=(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w,z,1.0)).y;projectionScaling=mix(projectionScaling,1.0/circumferenceRatioAtTileY(anchor_pos_tile_y)*u_pitched_scale,u_projection_transition);}\n#endif\nvec4 finalPos=u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+rotation_matrix*(a_offset/32.0*fontScale)*projectionScaling,z,1.0);if(u_pitch_with_map) {finalPos=projectTileWithElevation(finalPos.xy,finalPos.z);}float gamma_scale=finalPos.w;gl_Position=finalPos;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float visibility=calculate_visibility(projectedPoint);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(visibility,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),terrain:Et("uniform sampler2D u_texture;uniform vec4 u_fog_color;uniform vec4 u_horizon_color;uniform float u_fog_ground_blend;uniform float u_fog_ground_blend_opacity;uniform float u_horizon_fog_blend;uniform bool u_is_globe_mode;in vec2 v_texture_pos;in float v_fog_depth;const float gamma=2.2;vec4 gammaToLinear(vec4 color) {return pow(color,vec4(gamma));}vec4 linearToGamma(vec4 color) {return pow(color,vec4(1.0/gamma));}void main() {vec4 surface_color=texture(u_texture,vec2(v_texture_pos.x,1.0-v_texture_pos.y));if (!u_is_globe_mode && v_fog_depth > u_fog_ground_blend) {vec4 surface_color_linear=gammaToLinear(surface_color);float blend_color=smoothstep(0.0,1.0,max((v_fog_depth-u_horizon_fog_blend)/(1.0-u_horizon_fog_blend),0.0));vec4 fog_horizon_color_linear=mix(gammaToLinear(u_fog_color),gammaToLinear(u_horizon_color),blend_color);float factor_fog=max(v_fog_depth-u_fog_ground_blend,0.0)/(1.0-u_fog_ground_blend);fragColor=linearToGamma(mix(surface_color_linear,fog_horizon_color_linear,pow(factor_fog,2.0)*u_fog_ground_blend_opacity));} else {fragColor=surface_color;}}","in vec3 a_pos3d;uniform mat4 u_fog_matrix;uniform float u_ele_delta;out vec2 v_texture_pos;out float v_fog_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,get_elevation(a_pos3d.xy)-ele_delta);vec4 pos=u_fog_matrix*vec4(a_pos3d.xy,ele,1.0);v_fog_depth=pos.z/pos.w*0.5+0.5;}"),terrainDepth:Et("in float v_depth;const highp vec4 bitSh=vec4(256.*256.*256.,256.*256.,256.,1.);const highp vec4 bitMsk=vec4(0.,vec3(1./256.0));highp vec4 pack(highp float value) {highp vec4 comp=fract(value*bitSh);comp-=comp.xxyz*bitMsk;return comp;}void main() {fragColor=pack(v_depth);}","in vec3 a_pos3d;uniform float u_ele_delta;out float v_depth;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);v_depth=gl_Position.z/gl_Position.w;}"),terrainCoords:Et("precision mediump float;uniform sampler2D u_texture;uniform float u_terrain_coords_id;in vec2 v_texture_pos;void main() {vec4 rgba=texture(u_texture,v_texture_pos);fragColor=vec4(rgba.r,rgba.g,rgba.b,u_terrain_coords_id);}","in vec3 a_pos3d;uniform float u_ele_delta;out vec2 v_texture_pos;void main() {float ele=get_elevation(a_pos3d.xy);float ele_delta=a_pos3d.z==1.0 ? u_ele_delta : 0.0;v_texture_pos=a_pos3d.xy/8192.0;gl_Position=projectTileFor3D(a_pos3d.xy,ele-ele_delta);}"),projectionErrorMeasurement:Et("in vec4 v_output_error_encoded;void main() {fragColor=v_output_error_encoded;}","in vec2 a_pos;uniform highp float u_input;uniform highp float u_output_expected;out vec4 v_output_error_encoded;void main() {float real_output=2.0*atan(exp(PI-(u_input*PI*2.0)))-PI*0.5;float error=real_output-u_output_expected;float abs_error=abs(error)*128.0;v_output_error_encoded.x=min(floor(abs_error*256.0),255.0)/255.0;abs_error-=v_output_error_encoded.x;v_output_error_encoded.y=min(floor(abs_error*65536.0),255.0)/255.0;abs_error-=v_output_error_encoded.x/255.0;v_output_error_encoded.z=min(floor(abs_error*16777216.0),255.0)/255.0;v_output_error_encoded.w=error >=0.0 ? 1.0 : 0.0;gl_Position=vec4(a_pos,0.0,1.0);}"),atmosphere:Et("in vec3 view_direction;uniform vec3 u_sun_pos;uniform vec3 u_globe_position;uniform float u_globe_radius;uniform float u_atmosphere_blend;/**Shader use from https:*Made some change to adapt to MapLibre Globe geometry*/const float PI=3.141592653589793;const int iSteps=5;const int jSteps=3;/*radius of the planet*/const float EARTH_RADIUS=6371e3;/*radius of the atmosphere*/const float ATMOS_RADIUS=6471e3;vec2 rsi(vec3 r0,vec3 rd,float sr) {float a=dot(rd,rd);float b=2.0*dot(rd,r0);float c=dot(r0,r0)-(sr*sr);float d=(b*b)-4.0*a*c;if (d < 0.0) return vec2(1e5,-1e5);return vec2((-b-sqrt(d))/(2.0*a),(-b+sqrt(d))/(2.0*a));}vec4 atmosphere(vec3 r,vec3 r0,vec3 pSun,float iSun,float rPlanet,float rAtmos,vec3 kRlh,float kMie,float shRlh,float shMie,float g) {pSun=normalize(pSun);r=normalize(r);vec2 p=rsi(r0,r,rAtmos);if (p.x > p.y) {return vec4(0.0,0.0,0.0,1.0);}if (p.x < 0.0) {p.x=0.0;}vec3 pos=r0+r*p.x;vec2 p2=rsi(r0,r,rPlanet);if (p2.x <=p2.y && p2.x > 0.0) {p.y=min(p.y,p2.x);}float iStepSize=(p.y-p.x)/float(iSteps);float iTime=p.x+iStepSize*0.5;vec3 totalRlh=vec3(0,0,0);vec3 totalMie=vec3(0,0,0);float iOdRlh=0.0;float iOdMie=0.0;float mu=dot(r,pSun);float mumu=mu*mu;float gg=g*g;float pRlh=3.0/(16.0*PI)*(1.0+mumu);float pMie=3.0/(8.0*PI)*((1.0-gg)*(mumu+1.0))/(pow(1.0+gg-2.0*mu*g,1.5)*(2.0+gg));for (int i=0; i < iSteps; i++) {vec3 iPos=r0+r*iTime;float iHeight=length(iPos)-rPlanet;float odStepRlh=exp(-iHeight/shRlh)*iStepSize;float odStepMie=exp(-iHeight/shMie)*iStepSize;iOdRlh+=odStepRlh;iOdMie+=odStepMie;float jStepSize=rsi(iPos,pSun,rAtmos).y/float(jSteps);float jTime=jStepSize*0.5;float jOdRlh=0.0;float jOdMie=0.0;for (int j=0; j < jSteps; j++) {vec3 jPos=iPos+pSun*jTime;float jHeight=length(jPos)-rPlanet;jOdRlh+=exp(-jHeight/shRlh)*jStepSize;jOdMie+=exp(-jHeight/shMie)*jStepSize;jTime+=jStepSize;}vec3 attn=exp(-(kMie*(iOdMie+jOdMie)+kRlh*(iOdRlh+jOdRlh)));totalRlh+=odStepRlh*attn;totalMie+=odStepMie*attn;iTime+=iStepSize;}float opacity=exp(-(length(kRlh)*length(totalRlh)+kMie*length(totalMie)));vec3 color=iSun*(pRlh*kRlh*totalRlh+pMie*kMie*totalMie);return vec4(color,opacity);}void main() {vec3 scale_camera_pos=-u_globe_position*EARTH_RADIUS/u_globe_radius;vec4 color=atmosphere(normalize(view_direction),scale_camera_pos,u_sun_pos,22.0,EARTH_RADIUS,ATMOS_RADIUS,vec3(5.5e-6,13.0e-6,22.4e-6),21e-6,8e3,1.2e3,0.758\n);color.rgb=1.0-exp(-1.0*color.rgb);color=pow(color,vec4(1.0/2.2));fragColor=vec4(color.rgb,1.0-color.a)*u_atmosphere_blend;}","in vec2 a_pos;uniform mat4 u_inv_proj_matrix;out vec3 view_direction;void main() {view_direction=(u_inv_proj_matrix*vec4(a_pos,0.0,1.0)).xyz;gl_Position=vec4(a_pos,0.0,1.0);}"),sky:Et("uniform vec4 u_sky_color;uniform vec4 u_horizon_color;uniform vec2 u_horizon;uniform vec2 u_horizon_normal;uniform float u_sky_horizon_blend;uniform float u_sky_blend;void main() {float x=gl_FragCoord.x;float y=gl_FragCoord.y;float blend=(y-u_horizon.y)*u_horizon_normal.y+(x-u_horizon.x)*u_horizon_normal.x;if (blend > 0.0) {if (blend < u_sky_horizon_blend) {fragColor=mix(u_sky_color,u_horizon_color,pow(1.0-blend/u_sky_horizon_blend,2.0));} else {fragColor=u_sky_color;}}fragColor=mix(fragColor,vec4(vec3(0.0),0.0),u_sky_blend);}","in vec2 a_pos;void main() {gl_Position=vec4(a_pos,1.0,1.0);}")};function Et(e,t){const i=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,a=t.match(/in ([\w]+) ([\w]+)/g),r=e.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),o=t.match(/uniform ([\w]+) ([\w]+)([\s]*)([\w]*)/g),s=o?o.concat(r):r,n={};return {fragmentSource:e=e.replace(i,((e,t,i,a,r)=>(n[r]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nin ${i} ${a} ${r};\n#else\nuniform ${i} ${a} u_${r};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${r}\n    ${i} ${a} ${r} = u_${r};\n#endif\n`))),vertexSource:t=t.replace(i,((e,t,i,a,r)=>{const o="float"===a?"vec2":"vec4",s=r.match(/color/)?"color":o;return n[r]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nin ${i} ${o} a_${r};\nout ${i} ${a} ${r};\n#else\nuniform ${i} ${a} u_${r};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = a_${r};\n#else\n    ${i} ${a} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${r} = unpack_mix_${s}(a_${r}, u_${r}_t);\n#else\n    ${i} ${a} ${r} = u_${r};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${r}\nuniform lowp float u_${r}_t;\nin ${i} ${o} a_${r};\n#else\nuniform ${i} ${a} u_${r};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${a} ${r} = a_${r};\n#else\n    ${i} ${a} ${r} = u_${r};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${r}\n    ${i} ${a} ${r} = unpack_mix_${s}(a_${r}, u_${r}_t);\n#else\n    ${i} ${a} ${r} = u_${r};\n#endif\n`})),staticAttributes:a,staticUniforms:s}}class St{constructor(e,t,i){this.vertexBuffer=e,this.indexBuffer=t,this.segments=i;}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.vertexBuffer=null,this.indexBuffer=null,this.segments=null;}}var Rt=t.aT([{name:"a_pos",type:"Int16",components:2}]);const Dt="#define PROJECTION_MERCATOR",zt="mercator";class At{constructor(){this._cachedMesh=null;}get name(){return "mercator"}get useSubdivision(){return !1}get shaderVariantName(){return zt}get shaderDefine(){return Dt}get shaderPreludeCode(){return It.projectionMercator}get vertexShaderPreludeCode(){return It.projectionMercator.vertexSource}get subdivisionGranularity(){return t.aU.noSubdivision}get useGlobeControls(){return !1}get transitionState(){return 0}get latitudeErrorCorrectionRadians(){return 0}destroy(){}updateGPUdependent(e){}getMeshFromTileID(e,i,a,r,o){if(this._cachedMesh)return this._cachedMesh;const s=new t.aV;s.emplaceBack(0,0),s.emplaceBack(t.a4,0),s.emplaceBack(0,t.a4),s.emplaceBack(t.a4,t.a4);const n=e.createVertexBuffer(s,Rt.members),l=t.aW.simpleSegment(0,0,4,2),c=new t.aX;c.emplaceBack(1,0,2),c.emplaceBack(1,2,3);const h=e.createIndexBuffer(c);return this._cachedMesh=new St(n,h,l),this._cachedMesh}recalculate(){}hasTransition(){return !1}setErrorQueryLatitudeDegrees(e){}}class Lt{constructor(e=0,t=0,i=0,a=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(a)||a<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=a;}interpolate(e,i,a){return null!=i.top&&null!=e.top&&(this.top=t.G.number(e.top,i.top,a)),null!=i.bottom&&null!=e.bottom&&(this.bottom=t.G.number(e.bottom,i.bottom,a)),null!=i.left&&null!=e.left&&(this.left=t.G.number(e.left,i.left,a)),null!=i.right&&null!=e.right&&(this.right=t.G.number(e.right,i.right,a)),this}getCenter(e,i){const a=t.an((this.left+e-this.right)/2,0,e),r=t.an((this.top+i-this.bottom)/2,0,i);return new t.P(a,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Lt(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function kt(e,t){if(!e.renderWorldCopies||e.lngRange)return;const i=t.lng-e.center.lng;t.lng+=i>180?-360:i<-180?360:0;}function Ft(e){return Math.max(0,Math.floor(e))}class Bt{constructor(e,i){var a;this.applyConstrain=(e,t)=>null!==this._constrainOverride?this._constrainOverride(e,t):this._callbacks.defaultConstrain(e,t),this._callbacks=e,this._tileSize=512,this._renderWorldCopies=void 0===(null==i?void 0:i.renderWorldCopies)||!!(null==i?void 0:i.renderWorldCopies),this._minZoom=(null==i?void 0:i.minZoom)||0,this._maxZoom=(null==i?void 0:i.maxZoom)||22,this._minPitch=null==(null==i?void 0:i.minPitch)?0:null==i?void 0:i.minPitch,this._maxPitch=null==(null==i?void 0:i.maxPitch)?60:null==i?void 0:i.maxPitch,this._constrainOverride=null!==(a=null==i?void 0:i.constrainOverride)&&void 0!==a?a:null,this.setMaxBounds(),this._width=0,this._height=0,this._center=new t.V(0,0),this._elevation=0,this._zoom=0,this._tileZoom=Ft(this._zoom),this._scale=t.aq(this._zoom),this._bearingInRadians=0,this._fovInRadians=.6435011087932844,this._pitchInRadians=0,this._rollInRadians=0,this._unmodified=!0,this._edgeInsets=new Lt,this._minElevationForCurrentTile=0,this._autoCalculateNearFarZ=!0;}apply(e,i,a){this._constrainOverride=e.constrainOverride,this._latRange=e.latRange,this._lngRange=e.lngRange,this._width=e.width,this._height=e.height,this._center=e.center,this._elevation=e.elevation,this._minElevationForCurrentTile=e.minElevationForCurrentTile,this._zoom=e.zoom,this._tileZoom=Ft(this._zoom),this._scale=t.aq(this._zoom),this._bearingInRadians=e.bearingInRadians,this._fovInRadians=e.fovInRadians,this._pitchInRadians=e.pitchInRadians,this._rollInRadians=e.rollInRadians,this._unmodified=e.unmodified,this._edgeInsets=new Lt(e.padding.top,e.padding.bottom,e.padding.left,e.padding.right),this._minZoom=e.minZoom,this._maxZoom=e.maxZoom,this._minPitch=e.minPitch,this._maxPitch=e.maxPitch,this._renderWorldCopies=e.renderWorldCopies,this._cameraToCenterDistance=e.cameraToCenterDistance,this._nearZ=e.nearZ,this._farZ=e.farZ,this._autoCalculateNearFarZ=!a&&e.autoCalculateNearFarZ,i&&this.constrainInternal(),this._calcMatrices();}get pixelsToClipSpaceMatrix(){return this._pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._clipSpaceToPixelsMatrix}get minElevationForCurrentTile(){return this._minElevationForCurrentTile}setMinElevationForCurrentTile(e){this._minElevationForCurrentTile=e;}get tileSize(){return this._tileSize}get tileZoom(){return this._tileZoom}get scale(){return this._scale}get width(){return this._width}get height(){return this._height}get bearingInRadians(){return this._bearingInRadians}get lngRange(){return this._lngRange}get latRange(){return this._latRange}get pixelsToGLUnits(){return this._pixelsToGLUnits}get minZoom(){return this._minZoom}setMinZoom(e){this._minZoom!==e&&(this._minZoom=e,this.setZoom(this.applyConstrain(this._center,this.zoom).zoom));}get maxZoom(){return this._maxZoom}setMaxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.setZoom(this.applyConstrain(this._center,this.zoom).zoom));}get minPitch(){return this._minPitch}setMinPitch(e){this._minPitch!==e&&(this._minPitch=e,this.setPitch(Math.max(this.pitch,e)));}get maxPitch(){return this._maxPitch}setMaxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.setPitch(Math.min(this.pitch,e)));}get renderWorldCopies(){return this._renderWorldCopies}setRenderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get constrainOverride(){return this._constrainOverride}setConstrainOverride(e){void 0===e&&(e=null),this._constrainOverride!==e&&(this._constrainOverride=e,this.constrainInternal(),this._calcMatrices());}get worldSize(){return this._tileSize*this._scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new t.P(this._width,this._height)}get bearing(){return this._bearingInRadians/Math.PI*180}setBearing(e){const i=t.W(e,-180,180)*Math.PI/180;var r,o,s,n,l,c,h,u,d;this._bearingInRadians!==i&&(this._unmodified=!1,this._bearingInRadians=i,this._calcMatrices(),this._rotationMatrix=a(),r=this._rotationMatrix,s=-this._bearingInRadians,n=(o=this._rotationMatrix)[0],l=o[1],c=o[2],h=o[3],u=Math.sin(s),d=Math.cos(s),r[0]=n*d+c*u,r[1]=l*d+h*u,r[2]=n*-u+c*d,r[3]=l*-u+h*d);}get rotationMatrix(){return this._rotationMatrix}get pitchInRadians(){return this._pitchInRadians}get pitch(){return this._pitchInRadians/Math.PI*180}setPitch(e){const i=t.an(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitchInRadians!==i&&(this._unmodified=!1,this._pitchInRadians=i,this._calcMatrices());}get rollInRadians(){return this._rollInRadians}get roll(){return this._rollInRadians/Math.PI*180}setRoll(e){const t=e/180*Math.PI;this._rollInRadians!==t&&(this._unmodified=!1,this._rollInRadians=t,this._calcMatrices());}get fovInRadians(){return this._fovInRadians}get fov(){return t.aY(this._fovInRadians)}setFov(e){e=t.an(e,.1,150),this.fov!==e&&(this._unmodified=!1,this._fovInRadians=t.ap(e),this._calcMatrices());}get zoom(){return this._zoom}setZoom(e){const i=this.applyConstrain(this._center,e).zoom;this._zoom!==i&&(this._unmodified=!1,this._zoom=i,this._tileZoom=Math.max(0,Math.floor(i)),this._scale=t.aq(i),this.constrainInternal(),this._calcMatrices());}get center(){return this._center}setCenter(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this.constrainInternal(),this._calcMatrices());}get elevation(){return this._elevation}setElevation(e){e!==this._elevation&&(this._elevation=e,this.constrainInternal(),this._calcMatrices());}get padding(){return this._edgeInsets.toJSON()}setPadding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}get centerPoint(){return this._edgeInsets.getCenter(this._width,this._height)}get pixelsPerMeter(){return this._pixelPerMeter}get unmodified(){return this._unmodified}get cameraToCenterDistance(){return this._cameraToCenterDistance}get nearZ(){return this._nearZ}get farZ(){return this._farZ}get autoCalculateNearFarZ(){return this._autoCalculateNearFarZ}overrideNearFarZ(e,t){this._autoCalculateNearFarZ=!1,this._nearZ=e,this._farZ=t,this._calcMatrices();}clearNearFarZOverride(){this._autoCalculateNearFarZ=!0,this._calcMatrices();}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this.constrainInternal(),this._calcMatrices();}resize(e,t,i=!0){this._width=e,this._height=t,i&&this.constrainInternal(),this._calcMatrices();}getMaxBounds(){return this._latRange&&2===this._latRange.length&&this._lngRange&&2===this._lngRange.length?new $([this._lngRange[0],this._latRange[0]],[this._lngRange[1],this._latRange[1]]):null}setMaxBounds(e){e?(this._lngRange=[e.getWest(),e.getEast()],this._latRange=[e.getSouth(),e.getNorth()],this.constrainInternal()):(this._lngRange=null,this._latRange=[-t.ao,t.ao]);}getCameraQueryGeometry(e,i){if(1===i.length)return [i[0],e];{const{minX:a,minY:r,maxX:o,maxY:s}=t.ab.fromPoints(i).extend(e);return [new t.P(a,r),new t.P(o,r),new t.P(o,s),new t.P(a,s),new t.P(a,r)]}}constrainInternal(){if(!this.center||!this._width||!this._height||this._constraining)return;this._constraining=!0;const e=this._unmodified,{center:t,zoom:i}=this.applyConstrain(this.center,this.zoom);this.setCenter(t),this.setZoom(i),this._unmodified=e,this._constraining=!1;}_calcMatrices(){if(this._width&&this._height){this._pixelsToGLUnits=[2/this._width,-2/this._height];let e=t.ar(new Float64Array(16));t.Q(e,e,[this._width/2,-this._height/2,1]),t.O(e,e,[1,-1,0]),this._clipSpaceToPixelsMatrix=e,e=t.ar(new Float64Array(16)),t.Q(e,e,[1,-1,1]),t.O(e,e,[-1,-1,0]),t.Q(e,e,[2/this._width,2/this._height,1]),this._pixelsToClipSpaceMatrix=e,this._cameraToCenterDistance=.5/Math.tan(this.fovInRadians/2)*this._height;}this._callbacks.calcMatrices();}calculateCenterFromCameraLngLatAlt(e,i,a,r){const o=void 0!==a?a:this.bearing,s=r=void 0!==r?r:this.pitch,n=t.aa.fromLngLat(e,i),l=-Math.cos(t.ap(s)),c=Math.sin(t.ap(s)),h=c*Math.sin(t.ap(o)),u=-c*Math.cos(t.ap(o));let d=this.elevation;const _=i-d;let p;l*_>=0||Math.abs(l)<.1?(p=1e4,d=i+p*l):p=-_/l;let m,f,g=t.aZ(1,n.y),v=0;do{if(v+=1,v>10)break;f=p/g,m=new t.aa(n.x+h*f,n.y+u*f),g=1/m.meterInMercatorCoordinateUnits();}while(Math.abs(p-f*g)>1e-12);return {center:m.toLngLat(),elevation:d,zoom:t.at(this.height/2/Math.tan(this.fovInRadians/2)/f/this.tileSize)}}recalculateZoomAndCenter(e){if(this.elevation-e==0)return;const i=t.as(1,this.center.lat)*this.worldSize,a=this.cameraToCenterDistance/i,r=t.aa.fromLngLat(this.center,this.elevation),o=xe(this.center,this.elevation,this.pitch,this.bearing,a);this._elevation=e;const s=this.calculateCenterFromCameraLngLatAlt(o.toLngLat(),t.aZ(o.z,r.y),this.bearing,this.pitch);this._elevation=s.elevation,this._center=s.center,this.setZoom(s.zoom);}getCameraPoint(){const e=Math.tan(this.pitchInRadians)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new t.P(e*Math.sin(this.rollInRadians),e*Math.cos(this.rollInRadians)))}getCameraAltitude(){return Math.cos(this.pitchInRadians)*this._cameraToCenterDistance/this._pixelPerMeter+this.elevation}getCameraLngLat(){const e=t.as(1,this.center.lat)*this.worldSize;return xe(this.center,this.elevation,this.pitch,this.bearing,this.cameraToCenterDistance/e).toLngLat()}getMercatorTileCoordinates(e){if(!e)return [0,0,1,1];const i=e.canonical.z>=0?1<<e.canonical.z:Math.pow(2,e.canonical.z);return [e.canonical.x/i,e.canonical.y/i,1/i/t.a4,1/i/t.a4]}}class Ot{constructor(e,i){this.min=e,this.max=i,this.center=t.a_([],t.a$([],this.min,this.max),.5);}quadrant(e){const i=[e%2==0,e<2],a=t.b0(this.min),r=t.b0(this.max);for(let e=0;e<i.length;e++)a[e]=i[e]?this.min[e]:this.center[e],r[e]=i[e]?this.center[e]:this.max[e];return r[2]=this.max[2],new Ot(a,r)}distanceX(e){return Math.max(Math.min(this.max[0],e[0]),this.min[0])-e[0]}distanceY(e){return Math.max(Math.min(this.max[1],e[1]),this.min[1])-e[1]}intersectsFrustum(e){let t=!0;for(let i=0;i<e.planes.length;i++){const a=this.intersectsPlane(e.planes[i]);if(0===a)return 0;1===a&&(t=!1);}return t?2:e.aabb.min[0]>this.max[0]||e.aabb.min[1]>this.max[1]||e.aabb.min[2]>this.max[2]||e.aabb.max[0]<this.min[0]||e.aabb.max[1]<this.min[1]||e.aabb.max[2]<this.min[2]?0:1}intersectsPlane(e){let t=e[3],i=e[3];for(let a=0;a<3;a++)e[a]>0?(t+=e[a]*this.min[a],i+=e[a]*this.max[a]):(i+=e[a]*this.min[a],t+=e[a]*this.max[a]);return t>=0?2:i<0?0:1}}class jt{distanceToTile2d(e,t,i,a){const r=a.distanceX([e,t]),o=a.distanceY([e,t]);return Math.hypot(r,o)}getWrap(e,t,i){return i}getTileBoundingVolume(e,i,a,r){var o,s;let n=0,l=0;if(null==r?void 0:r.terrain){const c=new t.a1(e.z,i,e.z,e.x,e.y),h=r.terrain.getMinMaxElevation(c);n=null!==(o=h.minElevation)&&void 0!==o?o:Math.min(0,a),l=null!==(s=h.maxElevation)&&void 0!==s?s:Math.max(0,a);}const c=1<<e.z;return new Ot([i+e.x/c,e.y/c,n],[i+(e.x+1)/c,(e.y+1)/c,l])}allowVariableZoom(e,i){const a=e.fov*(Math.abs(Math.cos(e.rollInRadians))*e.height+Math.abs(Math.sin(e.rollInRadians))*e.width)/e.height,r=t.an(78.5-a/2,0,60);return !!i.terrain||e.pitch>r}allowWorldCopies(){return !0}prepareNextFrame(){}}class Nt{constructor(e,t,i){this.points=e,this.planes=t,this.aabb=i;}static fromInvProjectionMatrix(e,i=1,a=0,r,o){const s=o?[[6,5,4],[0,1,2],[0,3,7],[2,1,5],[3,2,6],[0,4,5]]:[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]],n=Math.pow(2,a),l=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((a=>function(e,i,a,r){const o=t.aG([],e,i),s=1/o[3]/a*r;return t.b5(o,o,[s,s,1/o[3],s])}(a,e,i,n)));r&&function(e,i,a,r){const o=r?4:0,s=r?0:4;let n=0;const l=[],c=[];for(let i=0;i<4;i++){const a=t.b1([],e[i+s],e[i+o]),r=t.b6(a);t.a_(a,a,1/r),l.push(r),c.push(a);}for(let i=0;i<4;i++){const r=t.b7(e[i+o],c[i],a);n=null!==r&&r>=0?Math.max(n,r):Math.max(n,l[i]);}const h=function(e,i){const a=t.b1([],e[i[0]],e[i[1]]),r=t.b1([],e[i[2]],e[i[1]]),o=[0,0,0,0];return t.b2(o,t.b3([],a,r)),o[3]=-t.b4(o,e[i[0]]),o}(e,i),u=function(e,i){const a=t.b8(e),r=t.b9([],e,1/a),o=t.b1([],i,t.a_([],r,t.b4(i,r))),s=t.b8(o);if(s>0){const e=Math.sqrt(1-r[3]*r[3]),a=t.a_([],r,-r[3]),n=t.a$([],a,t.a_([],o,e/s));return t.ba(i,n)}return null}(a,h);if(null!==u){const e=u/t.b4(c[0],h);n=Math.min(n,e);}for(let t=0;t<4;t++){const i=Math.min(n,l[t]);e[t+s]=[e[t+o][0]+c[t][0]*i,e[t+o][1]+c[t][1]*i,e[t+o][2]+c[t][2]*i,1];}}(l,s[0],r,o);const c=s.map((e=>{const i=t.b1([],l[e[0]],l[e[1]]),a=t.b1([],l[e[2]],l[e[1]]),r=t.b2([],t.b3([],i,a)),o=-t.b4(r,l[e[1]]);return r.concat(o)})),h=[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY],u=[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY];for(const e of l)for(let t=0;t<3;t++)h[t]=Math.min(h[t],e[t]),u[t]=Math.max(u[t],e[t]);return new Nt(l,c,new Ot(h,u))}}class Zt{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}setConstrainOverride(e){this._helper.setConstrainOverride(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e,t){}constructor(e){this._posMatrixCache=new Map,this._alignedPosMatrixCache=new Map,this._fogMatrixCacheF32=new Map,this.defaultConstrain=(e,i)=>{i=t.an(+i,this.minZoom,this.maxZoom);const a={center:new t.V(e.lng,e.lat),zoom:i};let r=this._helper._lngRange;if(!this._helper._renderWorldCopies&&null===r){const e=180-1e-10;r=[-e,e];}const o=this.tileSize*t.aq(a.zoom);let s=0,n=o,l=0,c=o,h=0,u=0;const{x:d,y:_}=this.size;if(this._helper._latRange){const e=this._helper._latRange;s=t.X(e[1])*o,n=t.X(e[0])*o,n-s<_&&(h=_/(n-s));}r&&(l=t.W(t.Y(r[0])*o,0,o),c=t.W(t.Y(r[1])*o,0,o),c<l&&(c+=o),c-l<d&&(u=d/(c-l)));const{x:p,y:m}=me(o,e);let f,g;const v=Math.max(u||0,h||0);if(v){const e=new t.P(u?(c+l)/2:p,h?(n+s)/2:m);return a.center=fe(o,e).wrap(),a.zoom+=t.at(v),a}if(this._helper._latRange){const e=_/2;m-e<s&&(g=s+e),m+e>n&&(g=n-e);}if(r){const e=(l+c)/2;let i=p;this._helper._renderWorldCopies&&(i=t.W(p,e-o/2,e+o/2));const a=d/2;i-a<l&&(f=l+a),i+a>c&&(f=c-a);}if(void 0!==f||void 0!==g){const e=new t.P(null!=f?f:p,null!=g?g:m);a.center=fe(o,e).wrap();}return a},this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new Bt({calcMatrices:()=>{this._calcMatrices();},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._coveringTilesDetailsProvider=new jt;}clone(){const e=new Zt;return e.apply(this),e}apply(e,t,i){this._helper.apply(e,t,i);}get cameraPosition(){return this._cameraPosition}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._viewProjMatrix}get inverseProjectionMatrix(){return this._invProjMatrix}get mercatorMatrix(){return this._mercatorMatrix}getVisibleUnwrappedCoordinates(e){const i=[new t.bb(0,e)];if(this._helper._renderWorldCopies){const a=this.screenPointToMercatorCoordinate(new t.P(0,0)),r=this.screenPointToMercatorCoordinate(new t.P(this._helper._width,0)),o=this.screenPointToMercatorCoordinate(new t.P(this._helper._width,this._helper._height)),s=this.screenPointToMercatorCoordinate(new t.P(0,this._helper._height)),n=Math.floor(Math.min(a.x,r.x,o.x,s.x)),l=Math.floor(Math.max(a.x,r.x,o.x,s.x)),c=1;for(let a=n-c;a<=l+c;a++)0!==a&&i.push(new t.bb(a,e));}return i}getCameraFrustum(){return Nt.fromInvProjectionMatrix(this._invViewProjMatrix,this.worldSize)}getClippingPlane(){return null}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){const t=this.screenPointToLocation(this.centerPoint,e),i=e?e.getElevationForLngLatZoom(t,this._helper._tileZoom):0;this._helper.recalculateZoomAndCenter(i);}setLocationAtPoint(e,i){const a=t.as(this.elevation,this.center.lat),r=this.screenPointToMercatorCoordinateAtZ(i,a),o=this.screenPointToMercatorCoordinateAtZ(this.centerPoint,a),s=t.aa.fromLngLat(e),n=new t.aa(s.x-(r.x-o.x),s.y-(r.y-o.y));this.setCenter(null==n?void 0:n.toLngLat()),this._helper._renderWorldCopies&&this.setCenter(this.center.wrap());}locationToScreenPoint(e,i){return i?this.coordinatePoint(t.aa.fromLngLat(e),i.getElevationForLngLatZoom(e,this._helper._tileZoom),this._pixelMatrix3D):this.coordinatePoint(t.aa.fromLngLat(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}screenPointToMercatorCoordinate(e,t){if(t){const i=t.pointCoordinate(e);if(null!=i)return i}return this.screenPointToMercatorCoordinateAtZ(e)}screenPointToMercatorCoordinateAtZ(e,i){const a=i||0,r=[e.x,e.y,0,1],o=[e.x,e.y,1,1];t.aG(r,r,this._pixelMatrixInverse),t.aG(o,o,this._pixelMatrixInverse);const s=r[3],n=o[3],l=r[1]/s,c=o[1]/n,h=r[2]/s,u=o[2]/n,d=h===u?0:(a-h)/(u-h);return new t.aa(t.G.number(r[0]/s,o[0]/n,d)/this.worldSize,t.G.number(l,c,d)/this.worldSize,a)}coordinatePoint(e,i=0,a=this._pixelMatrix){const r=[e.x*this.worldSize,e.y*this.worldSize,i,1];return t.aG(r,r,a),new t.P(r[0]/r[3],r[1]/r[3])}getBounds(){const e=Math.max(0,this._helper._height/2-ge(this));return (new $).extend(this.screenPointToLocation(new t.P(0,e))).extend(this.screenPointToLocation(new t.P(this._helper._width,e))).extend(this.screenPointToLocation(new t.P(this._helper._width,this._helper._height))).extend(this.screenPointToLocation(new t.P(0,this._helper._height)))}isPointOnMapSurface(e,t){return t?null!=t.pointCoordinate(e):e.y>this.height/2-ge(this)}calculatePosMatrix(e,i=!1,a){var r;const o=null!==(r=e.key)&&void 0!==r?r:t.bc(e.wrap,e.canonical.z,e.canonical.z,e.canonical.x,e.canonical.y),s=i?this._alignedPosMatrixCache:this._posMatrixCache;if(s.has(o)){const e=s.get(o);return a?e.f32:e.f64}const n=ve(e,this.worldSize);t.S(n,i?this._alignedProjMatrix:this._viewProjMatrix,n);const l={f64:n,f32:new Float32Array(n)};return s.set(o,l),a?l.f32:l.f64}calculateFogMatrix(e){const i=e.key,a=this._fogMatrixCacheF32;if(a.has(i))return a.get(i);const r=ve(e,this.worldSize);return t.S(r,this._fogMatrix,r),a.set(i,new Float32Array(r)),a.get(i)}calculateCenterFromCameraLngLatAlt(e,t,i,a){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,a)}_calculateNearFarZIfNeeded(e,i,a){if(!this._helper.autoCalculateNearFarZ)return;const r=Math.min(this.elevation,this.minElevationForCurrentTile,this.getCameraAltitude()-100),o=e-r*this._helper._pixelPerMeter/Math.cos(i),s=r<0?o:e,n=Math.PI/2+this.pitchInRadians,l=t.ap(this.fov)*(Math.abs(Math.cos(t.ap(this.roll)))*this.height+Math.abs(Math.sin(t.ap(this.roll)))*this.width)/this.height*(.5+a.y/this.height),c=Math.sin(l)*s/Math.sin(t.an(Math.PI-n-l,.01,Math.PI-.01)),h=ge(this),u=Math.atan(h/this._helper.cameraToCenterDistance),d=t.ap(.75),_=u>d?2*u*(.5+a.y/(2*h)):d,p=Math.sin(_)*s/Math.sin(t.an(Math.PI-n-_,.01,Math.PI-.01)),m=Math.min(c,p);this._helper._farZ=1.01*(Math.cos(Math.PI/2-i)*m+s),this._helper._nearZ=this._helper._height/50;}_calcMatrices(){if(!this._helper._height)return;const e=this.centerOffset,i=me(this.worldSize,this.center),a=i.x,r=i.y;this._helper._pixelPerMeter=t.as(1,this.center.lat)*this.worldSize;const o=t.ap(Math.min(this.pitch,pe)),s=Math.max(this._helper.cameraToCenterDistance/2,this._helper.cameraToCenterDistance+this._helper._elevation*this._helper._pixelPerMeter/Math.cos(o));let n;this._calculateNearFarZIfNeeded(s,o,e),n=new Float64Array(16),t.bd(n,this.fovInRadians,this._helper._width/this._helper._height,this._helper._nearZ,this._helper._farZ),this._invProjMatrix=new Float64Array(16),t.aA(this._invProjMatrix,n),n[8]=2*-e.x/this._helper._width,n[9]=2*e.y/this._helper._height,this._projectionMatrix=t.be(n),t.Q(n,n,[1,-1,1]),t.O(n,n,[0,0,-this._helper.cameraToCenterDistance]),t.bf(n,n,-this.rollInRadians),t.bg(n,n,this.pitchInRadians),t.bf(n,n,-this.bearingInRadians),t.O(n,n,[-a,-r,0]),this._mercatorMatrix=t.Q([],n,[this.worldSize,this.worldSize,this.worldSize]),t.Q(n,n,[1,1,this._helper._pixelPerMeter]),this._pixelMatrix=t.S(new Float64Array(16),this.clipSpaceToPixelsMatrix,n),t.O(n,n,[0,0,-this.elevation]),this._viewProjMatrix=n,this._invViewProjMatrix=t.aA([],n);const l=[0,0,-1,1];t.aG(l,l,this._invViewProjMatrix),this._cameraPosition=[l[0]/l[3],l[1]/l[3],l[2]/l[3]],this._fogMatrix=new Float64Array(16),t.bd(this._fogMatrix,this.fovInRadians,this.width/this.height,s,this._helper._farZ),this._fogMatrix[8]=2*-e.x/this.width,this._fogMatrix[9]=2*e.y/this.height,t.Q(this._fogMatrix,this._fogMatrix,[1,-1,1]),t.O(this._fogMatrix,this._fogMatrix,[0,0,-this.cameraToCenterDistance]),t.bf(this._fogMatrix,this._fogMatrix,-this.rollInRadians),t.bg(this._fogMatrix,this._fogMatrix,this.pitchInRadians),t.bf(this._fogMatrix,this._fogMatrix,-this.bearingInRadians),t.O(this._fogMatrix,this._fogMatrix,[-a,-r,0]),t.Q(this._fogMatrix,this._fogMatrix,[1,1,this._helper._pixelPerMeter]),t.O(this._fogMatrix,this._fogMatrix,[0,0,-this.elevation]),this._pixelMatrix3D=t.S(new Float64Array(16),this.clipSpaceToPixelsMatrix,n);const c=this._helper._width%2/2,h=this._helper._height%2/2,u=Math.cos(this.bearingInRadians),d=Math.sin(-this.bearingInRadians),_=a-Math.round(a)+u*c+d*h,p=r-Math.round(r)+u*h+d*c,m=new Float64Array(n);if(t.O(m,m,[_>.5?_-1:_,p>.5?p-1:p,0]),this._alignedProjMatrix=m,n=t.aA(new Float64Array(16),this._pixelMatrix),!n)throw new Error("failed to invert matrix");this._pixelMatrixInverse=n,this._clearMatrixCaches();}_clearMatrixCaches(){this._posMatrixCache.clear(),this._alignedPosMatrixCache.clear(),this._fogMatrixCacheF32.clear();}maxPitchScaleFactor(){if(!this._pixelMatrixInverse)return 1;const e=this.screenPointToMercatorCoordinate(new t.P(0,0)),i=[e.x*this.worldSize,e.y*this.worldSize,0,1];return t.aG(i,i,this._pixelMatrix)[3]/this._helper.cameraToCenterDistance}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){const e=t.as(1,this.center.lat)*this.worldSize;return xe(this.center,this.elevation,this.pitch,this.bearing,this._helper.cameraToCenterDistance/e).toLngLat()}lngLatToCameraDepth(e,i){const a=t.aa.fromLngLat(e),r=[a.x*this.worldSize,a.y*this.worldSize,i,1];return t.aG(r,r,this._viewProjMatrix),r[2]/r[3]}getProjectionData(e){const{overscaledTileID:i,aligned:a,applyTerrainMatrix:r}=e,o=this._helper.getMercatorTileCoordinates(i),s=i?this.calculatePosMatrix(i,a,!0):null;let n;return n=i&&i.terrainRttPosMatrix32f&&r?i.terrainRttPosMatrix32f:s||t.bh(),{mainMatrix:n,tileMercatorCoords:o,clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:n}}isLocationOccluded(e){return !1}getPixelScale(){return 1}getCircleRadiusCorrection(){return 1}getPitchedTextCorrection(e,t,i){return 1}transformLightDirection(e){return t.b0(e)}getRayDirectionFromPixel(e){throw new Error("Not implemented.")}projectTileCoordinates(e,i,a,r){const o=this.calculatePosMatrix(a);let s;r?(s=[e,i,r(e,i),1],t.aG(s,s,o)):(s=[e,i,0,1],Je(s,s,o));const n=s[3];return {point:new t.P(s[0]/n,s[1]/n),signedDistanceFromCamera:n,isOccluded:!1}}populateCache(e){for(const t of e)this.calculatePosMatrix(t);}getMatrixForModel(e,i){const a=t.aa.fromLngLat(e,i),r=a.meterInMercatorCoordinateUnits(),o=t.bi();return t.O(o,o,[a.x,a.y,a.z]),t.bf(o,o,Math.PI),t.bg(o,o,Math.PI/2),t.Q(o,o,[-r,r,r]),o}getProjectionDataForCustomLayer(e=!0){const i=new t.a1(0,0,0,0,0),a=this.getProjectionData({overscaledTileID:i,applyGlobeMatrix:e}),r=ve(i,this.worldSize);t.S(r,this._viewProjMatrix,r),a.tileMercatorCoords=[0,0,1,1];const o=[t.a4,t.a4,this.worldSize/this._helper.pixelsPerMeter],s=t.bj();return t.Q(s,r,o),a.fallbackMatrix=s,a.mainMatrix=s,a}getFastPathSimpleProjectionMatrix(e){return this.calculatePosMatrix(e)}}function Gt(){t.w("Map cannot fit within canvas with the given bounds, padding, and/or offset.");}function Ut(e){if(e.useSlerp)if(e.k<1){const i=t.bk(e.startEulerAngles.roll,e.startEulerAngles.pitch,e.startEulerAngles.bearing),a=t.bk(e.endEulerAngles.roll,e.endEulerAngles.pitch,e.endEulerAngles.bearing),r=new Float64Array(4);t.bl(r,i,a,e.k);const o=t.bm(r);e.tr.setRoll(o.roll),e.tr.setPitch(o.pitch),e.tr.setBearing(o.bearing);}else e.tr.setRoll(e.endEulerAngles.roll),e.tr.setPitch(e.endEulerAngles.pitch),e.tr.setBearing(e.endEulerAngles.bearing);else e.tr.setRoll(t.G.number(e.startEulerAngles.roll,e.endEulerAngles.roll,e.k)),e.tr.setPitch(t.G.number(e.startEulerAngles.pitch,e.endEulerAngles.pitch,e.k)),e.tr.setBearing(t.G.number(e.startEulerAngles.bearing,e.endEulerAngles.bearing,e.k));}function Vt(e,i,a,r,o){const s=o.padding,n=me(o.worldSize,a.getNorthWest()),l=me(o.worldSize,a.getNorthEast()),c=me(o.worldSize,a.getSouthEast()),h=me(o.worldSize,a.getSouthWest()),u=t.ap(-r),d=n.rotate(u),_=l.rotate(u),p=c.rotate(u),m=h.rotate(u),f=new t.P(Math.max(d.x,_.x,m.x,p.x),Math.max(d.y,_.y,m.y,p.y)),g=new t.P(Math.min(d.x,_.x,m.x,p.x),Math.min(d.y,_.y,m.y,p.y)),v=f.sub(g),x=(o.width-(s.left+s.right+i.left+i.right))/v.x,b=(o.height-(s.top+s.bottom+i.top+i.bottom))/v.y;if(b<0||x<0)return void Gt();const y=Math.min(t.at(o.scale*Math.min(x,b)),e.maxZoom),w=t.P.convert(e.offset),T=new t.P((i.left-i.right)/2,(i.top-i.bottom)/2).rotate(t.ap(r)),P=w.add(T).mult(o.scale/t.aq(y));return {center:fe(o.worldSize,n.add(c).div(2).sub(P)),zoom:y,bearing:r}}class qt{get useGlobeControls(){return !1}handlePanInertia(e,t){const i=e.mag(),a=Math.abs(ge(t));return {easingOffset:e.mult(Math.min(.75*a/i,1)),easingCenter:t.center}}handleMapControlsRollPitchBearingZoom(e,t){e.bearingDelta&&t.setBearing(t.bearing+e.bearingDelta),e.pitchDelta&&t.setPitch(t.pitch+e.pitchDelta),e.rollDelta&&t.setRoll(t.roll+e.rollDelta),e.zoomDelta&&t.setZoom(t.zoom+e.zoomDelta);}handleMapControlsPan(e,t,i){e.around.distSqr(t.centerPoint)<.01||t.setLocationAtPoint(i,e.around);}cameraForBoxAndBearing(e,t,i,a,r){return Vt(e,t,i,a,r)}handleJumpToCenterZoom(e,i){e.zoom!==(void 0!==i.zoom?+i.zoom:e.zoom)&&e.setZoom(+i.zoom),void 0!==i.center&&e.setCenter(t.V.convert(i.center));}handleEaseTo(e,i){const a=e.zoom,r=e.padding,o={roll:e.roll,pitch:e.pitch,bearing:e.bearing},s={roll:void 0===i.roll?e.roll:i.roll,pitch:void 0===i.pitch?e.pitch:i.pitch,bearing:void 0===i.bearing?e.bearing:i.bearing},n=void 0!==i.zoom,l=!e.isPaddingEqual(i.padding);let c=!1;const h=n?+i.zoom:e.zoom;let u=e.centerPoint.add(i.offsetAsPoint);const d=e.screenPointToLocation(u),{center:_,zoom:p}=e.applyConstrain(t.V.convert(i.center||d),null!=h?h:a);kt(e,_);const m=me(e.worldSize,d),f=me(e.worldSize,_).sub(m),g=t.aq(p-a);return c=p!==a,{easeFunc:n=>{if(c&&e.setZoom(t.G.number(a,p,n)),t.bn(o,s)||Ut({startEulerAngles:o,endEulerAngles:s,tr:e,k:n,useSlerp:o.roll!=s.roll}),l&&(e.interpolatePadding(r,i.padding,n),u=e.centerPoint.add(i.offsetAsPoint)),i.around)e.setLocationAtPoint(i.around,i.aroundPoint);else {const i=t.aq(e.zoom-a),r=p>a?Math.min(2,g):Math.max(.5,g),o=Math.pow(r,1-n),s=fe(e.worldSize,m.add(f.mult(n*o)).mult(i));e.setLocationAtPoint(e.renderWorldCopies?s.wrap():s,u);}},isZooming:c,elevationCenter:_}}handleFlyTo(e,i){const a=void 0!==i.zoom,r=e.zoom,o=e.applyConstrain(t.V.convert(i.center||i.locationAtOffset),a?+i.zoom:r),s=o.center,n=o.zoom;kt(e,s);const l=me(e.worldSize,i.locationAtOffset),c=me(e.worldSize,s).sub(l),h=c.mag(),u=t.aq(n-r);let d;if(void 0!==i.minZoom){const a=Math.min(+i.minZoom,r,n),o=e.applyConstrain(s,a).zoom;d=t.aq(o-r);}return {easeFunc:(i,a,o,h)=>{e.setZoom(1===i?n:r+t.at(a));const u=1===i?s:fe(e.worldSize,l.add(c.mult(o)).mult(a));e.setLocationAtPoint(e.renderWorldCopies?u.wrap():u,h);},scaleOfZoom:u,targetCenter:s,scaleOfMinZoom:d,pixelPathLength:h}}}class Wt{constructor(e,t,i){this.blendFunction=e,this.blendColor=t,this.mask=i;}}Wt.Replace=[1,0],Wt.disabled=new Wt(Wt.Replace,t.bo.transparent,[!1,!1,!1,!1]),Wt.unblended=new Wt(Wt.Replace,t.bo.transparent,[!0,!0,!0,!0]),Wt.alphaBlended=new Wt([1,771],t.bo.transparent,[!0,!0,!0,!0]);const $t=2305;class Ht{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i;}}Ht.disabled=new Ht(!1,1029,$t),Ht.backCCW=new Ht(!0,1029,$t),Ht.frontCCW=new Ht(!0,1028,$t);class Xt{constructor(e,t,i){this.func=e,this.mask=t,this.range=i;}}Xt.ReadOnly=!1,Xt.ReadWrite=!0,Xt.disabled=new Xt(519,Xt.ReadOnly,[0,1]);const Kt=7680;class Yt{constructor(e,t,i,a,r,o){this.test=e,this.ref=t,this.mask=i,this.fail=a,this.depthFail=r,this.pass=o;}}Yt.disabled=new Yt({func:519,mask:0},0,0,Kt,Kt,Kt);const Qt=new WeakMap;function Jt(e){var t;if(Qt.has(e))return Qt.get(e);{const i=null===(t=e.getParameter(e.VERSION))||void 0===t?void 0:t.startsWith("WebGL 2.0");return Qt.set(e,i),i}}class ei{get awaitingQuery(){return !!this._readbackQueue}constructor(e){this._readbackWaitFrames=4,this._measureWaitFrames=6,this._texWidth=1,this._texHeight=1,this._measuredError=0,this._updateCount=0,this._lastReadbackFrame=-1e3,this._readbackQueue=null,this._cachedRenderContext=e;const i=e.context,a=i.gl;this._texFormat=a.RGBA,this._texType=a.UNSIGNED_BYTE;const r=new t.aV;r.emplaceBack(-1,-1),r.emplaceBack(2,-1),r.emplaceBack(-1,2);const o=new t.aX;o.emplaceBack(0,1,2),this._fullscreenTriangle=new St(i.createVertexBuffer(r,Rt.members),i.createIndexBuffer(o),t.aW.simpleSegment(0,0,r.length,o.length)),this._resultBuffer=new Uint8Array(4),i.activeTexture.set(a.TEXTURE1);const s=a.createTexture();a.bindTexture(a.TEXTURE_2D,s),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_S,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_WRAP_T,a.CLAMP_TO_EDGE),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MIN_FILTER,a.NEAREST),a.texParameteri(a.TEXTURE_2D,a.TEXTURE_MAG_FILTER,a.NEAREST),a.texImage2D(a.TEXTURE_2D,0,this._texFormat,this._texWidth,this._texHeight,0,this._texFormat,this._texType,null),this._fbo=i.createFramebuffer(this._texWidth,this._texHeight,!1,!1),this._fbo.colorAttachment.set(s),Jt(a)&&(this._pbo=a.createBuffer(),a.bindBuffer(a.PIXEL_PACK_BUFFER,this._pbo),a.bufferData(a.PIXEL_PACK_BUFFER,4,a.STREAM_READ),a.bindBuffer(a.PIXEL_PACK_BUFFER,null));}destroy(){const e=this._cachedRenderContext.context.gl;this._fullscreenTriangle.destroy(),this._fbo.destroy(),e.deleteBuffer(this._pbo),this._fullscreenTriangle=null,this._fbo=null,this._pbo=null,this._resultBuffer=null;}updateErrorLoop(e,t){const i=this._updateCount;return this._readbackQueue?i>=this._readbackQueue.frameNumberIssued+this._readbackWaitFrames&&this._tryReadback():i>=this._lastReadbackFrame+this._measureWaitFrames&&this._renderErrorTexture(e,t),this._updateCount++,this._measuredError}_bindFramebuffer(){const e=this._cachedRenderContext.context,t=e.gl;e.activeTexture.set(t.TEXTURE1),t.bindTexture(t.TEXTURE_2D,this._fbo.colorAttachment.get()),e.bindFramebuffer.set(this._fbo.framebuffer);}_renderErrorTexture(e,i){const a=this._cachedRenderContext.context,r=a.gl;if(this._bindFramebuffer(),a.viewport.set([0,0,this._texWidth,this._texHeight]),a.clear({color:t.bo.transparent}),this._cachedRenderContext.useProgram("projectionErrorMeasurement").draw(a,r.TRIANGLES,Xt.disabled,Yt.disabled,Wt.unblended,Ht.disabled,((e,t)=>({u_input:e,u_output_expected:t}))(e,i),null,null,"$clipping",this._fullscreenTriangle.vertexBuffer,this._fullscreenTriangle.indexBuffer,this._fullscreenTriangle.segments),this._pbo&&Jt(r)){r.bindBuffer(r.PIXEL_PACK_BUFFER,this._pbo),r.readBuffer(r.COLOR_ATTACHMENT0),r.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,0),r.bindBuffer(r.PIXEL_PACK_BUFFER,null);const e=r.fenceSync(r.SYNC_GPU_COMMANDS_COMPLETE,0);r.flush(),this._readbackQueue={frameNumberIssued:this._updateCount,sync:e};}else this._readbackQueue={frameNumberIssued:this._updateCount,sync:null};}_tryReadback(){const e=this._cachedRenderContext.context.gl;if(this._pbo&&this._readbackQueue&&Jt(e)){const i=e.clientWaitSync(this._readbackQueue.sync,0,0);if(i===e.WAIT_FAILED)return t.w("WebGL2 clientWaitSync failed."),this._readbackQueue=null,void(this._lastReadbackFrame=this._updateCount);if(i===e.TIMEOUT_EXPIRED)return;e.bindBuffer(e.PIXEL_PACK_BUFFER,this._pbo),e.getBufferSubData(e.PIXEL_PACK_BUFFER,0,this._resultBuffer,0,4),e.bindBuffer(e.PIXEL_PACK_BUFFER,null);}else this._bindFramebuffer(),e.readPixels(0,0,this._texWidth,this._texHeight,this._texFormat,this._texType,this._resultBuffer);this._readbackQueue=null,this._measuredError=ei._parseRGBA8float(this._resultBuffer),this._lastReadbackFrame=this._updateCount;}static _parseRGBA8float(e){let t=0;return t+=e[0]/256,t+=e[1]/65536,t+=e[2]/16777216,e[3]<127&&(t=-t),t/128}}const ti=t.a4/128;function ii(e,i){const a=void 0!==e.granularity?Math.max(e.granularity,1):1,r=a+(e.generateBorders?2:0),o=a+(e.extendToNorthPole||e.generateBorders?1:0)+(e.extendToSouthPole||e.generateBorders?1:0),s=r+1,n=o+1,l=e.generateBorders?-1:0,c=e.generateBorders||e.extendToNorthPole?-1:0,h=a+(e.generateBorders?1:0),u=a+(e.generateBorders||e.extendToSouthPole?1:0),d=s*n,_=r*o*6,p=s*n>65536;if(p&&"16bit"===i)throw new Error("Granularity is too large and meshes would not fit inside 16 bit vertex indices.");const m=p||"32bit"===i,f=new Int16Array(2*d);let g=0;for(let i=c;i<=u;i++)for(let r=l;r<=h;r++){let o=r/a*t.a4;-1===r&&(o=-ti),r===a+1&&(o=t.a4+ti);let s=i/a*t.a4;-1===i&&(s=e.extendToNorthPole?t.bq:-ti),i===a+1&&(s=e.extendToSouthPole?t.br:t.a4+ti),f[g++]=o,f[g++]=s;}const v=m?new Uint32Array(_):new Uint16Array(_);let x=0;for(let e=0;e<o;e++)for(let t=0;t<r;t++){const i=t+1+e*s,a=t+(e+1)*s,r=t+1+(e+1)*s;v[x++]=t+e*s,v[x++]=a,v[x++]=i,v[x++]=i,v[x++]=a,v[x++]=r;}return {vertices:f.buffer.slice(0),indices:v.buffer.slice(0),uses32bitIndices:m}}const ai=new t.aU({fill:new t.bs(128,2),line:new t.bs(512,0),tile:new t.bs(128,32),stencil:new t.bs(128,1),circle:3});class ri{constructor(){this._tileMeshCache={},this._errorCorrectionUsable=0,this._errorMeasurementLastValue=0,this._errorCorrectionPreviousValue=0,this._errorMeasurementLastChangeTime=-1e3;}get name(){return "vertical-perspective"}get transitionState(){return 1}get useSubdivision(){return !0}get shaderVariantName(){return "globe"}get shaderDefine(){return "#define GLOBE"}get shaderPreludeCode(){return It.projectionGlobe}get vertexShaderPreludeCode(){return It.projectionMercator.vertexSource}get subdivisionGranularity(){return ai}get useGlobeControls(){return !0}get latitudeErrorCorrectionRadians(){return this._errorCorrectionUsable}destroy(){this._errorMeasurement&&this._errorMeasurement.destroy();}updateGPUdependent(e){this._errorMeasurement||(this._errorMeasurement=new ei(e));const i=t.X(this._errorQueryLatitudeDegrees),a=2*Math.atan(Math.exp(Math.PI-i*Math.PI*2))-.5*Math.PI,r=this._errorMeasurement.updateErrorLoop(i,a),o=c();r!==this._errorMeasurementLastValue&&(this._errorCorrectionPreviousValue=this._errorCorrectionUsable,this._errorMeasurementLastValue=r,this._errorMeasurementLastChangeTime=o);const s=Math.min(Math.max((o-this._errorMeasurementLastChangeTime)/1e3/.5,0),1);this._errorCorrectionUsable=t.bt(this._errorCorrectionPreviousValue,-this._errorMeasurementLastValue,t.bu(s));}_getMeshKey(e){return `${e.granularity.toString(36)}_${e.generateBorders?"b":""}${e.extendToNorthPole?"n":""}${e.extendToSouthPole?"s":""}`}getMeshFromTileID(e,t,i,a,r){const o=("stencil"===r?ai.stencil:ai.tile).getGranularityForZoomLevel(t.z);return this._getMesh(e,{granularity:o,generateBorders:i,extendToNorthPole:0===t.y&&a,extendToSouthPole:t.y===(1<<t.z)-1&&a})}_getMesh(e,i){const a=this._getMeshKey(i);if(a in this._tileMeshCache)return this._tileMeshCache[a];const r=function(e,i){const a=ii(i,"16bit"),r=t.aV.deserialize({arrayBuffer:a.vertices,length:a.vertices.byteLength/2/2}),o=t.aX.deserialize({arrayBuffer:a.indices,length:a.indices.byteLength/2/3});return new St(e.createVertexBuffer(r,Rt.members),e.createIndexBuffer(o),t.aW.simpleSegment(0,0,r.length,o.length))}(e,i);return this._tileMeshCache[a]=r,r}recalculate(e){}hasTransition(){const e=c();let t=!1;return t=t||(e-this._errorMeasurementLastChangeTime)/1e3<.7,t=t||this._errorMeasurement&&this._errorMeasurement.awaitingQuery,t}setErrorQueryLatitudeDegrees(e){this._errorQueryLatitudeDegrees=e;}}const oi=new t.t({type:new t.D(t.u.projection.type)});class si extends t.E{constructor(e){super(),this._transitionable=new t.x(oi,void 0),this.setProjection(e),this._transitioning=this._transitionable.untransitioned(),this.recalculate(new t.H(0)),this._mercatorProjection=new At,this._verticalPerspectiveProjection=new ri;}get transitionState(){const e=this.properties.get("type");if("string"==typeof e&&"mercator"===e)return 0;if("string"==typeof e&&"vertical-perspective"===e)return 1;if(e instanceof t.bv){if("vertical-perspective"===e.from&&"mercator"===e.to)return 1-e.transition;if("mercator"===e.from&&"vertical-perspective"===e.to)return e.transition}return 1}get useGlobeRendering(){return this.transitionState>0}get latitudeErrorCorrectionRadians(){return this._verticalPerspectiveProjection.latitudeErrorCorrectionRadians}get currentProjection(){return this.useGlobeRendering?this._verticalPerspectiveProjection:this._mercatorProjection}get name(){return "globe"}get useSubdivision(){return this.currentProjection.useSubdivision}get shaderVariantName(){return this.currentProjection.shaderVariantName}get shaderDefine(){return this.currentProjection.shaderDefine}get shaderPreludeCode(){return this.currentProjection.shaderPreludeCode}get vertexShaderPreludeCode(){return this.currentProjection.vertexShaderPreludeCode}get subdivisionGranularity(){return this.currentProjection.subdivisionGranularity}get useGlobeControls(){return this.transitionState>0}destroy(){this._mercatorProjection.destroy(),this._verticalPerspectiveProjection.destroy();}updateGPUdependent(e){this._mercatorProjection.updateGPUdependent(e),this._verticalPerspectiveProjection.updateGPUdependent(e);}getMeshFromTileID(e,t,i,a,r){return this.currentProjection.getMeshFromTileID(e,t,i,a,r)}setProjection(e){this._transitionable.setValue("type",(null==e?void 0:e.type)||"mercator");}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()||this.currentProjection.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}setErrorQueryLatitudeDegrees(e){this._verticalPerspectiveProjection.setErrorQueryLatitudeDegrees(e),this._mercatorProjection.setErrorQueryLatitudeDegrees(e);}}function ni(e){const t=hi(e.worldSize,e.center.lat);return 2*Math.PI*t}function li(e,i,a,r,o){const s=1/(1<<o),n=i/t.a4*s+r*s,l=t.bx((e/t.a4*s+a*s)*Math.PI*2+Math.PI,2*Math.PI),c=2*Math.atan(Math.exp(Math.PI-n*Math.PI*2))-.5*Math.PI,h=Math.cos(c),u=new Float64Array(3);return u[0]=Math.sin(l)*h,u[1]=Math.sin(c),u[2]=Math.cos(l)*h,u}function ci(e){return function(e,t){const i=Math.cos(t),a=new Float64Array(3);return a[0]=Math.sin(e)*i,a[1]=Math.sin(t),a[2]=Math.cos(e)*i,a}(e.lng*Math.PI/180,e.lat*Math.PI/180)}function hi(e,t){return e/(2*Math.PI)/Math.cos(t*Math.PI/180)}function ui(e){const i=Math.asin(e[1])/Math.PI*180,a=Math.sqrt(e[0]*e[0]+e[2]*e[2]);if(a>1e-6){const r=e[0]/a,o=Math.acos(e[2]/a),s=(r>0?o:-o)/Math.PI*180;return new t.V(t.W(s,-180,180),i)}return new t.V(0,i)}function di(e){return Math.cos(e*Math.PI/180)}function _i(e,i){const a=di(e),r=di(i);return t.at(r/a)}function pi(e,i){const a=e.rotate(i.bearingInRadians),r=i.zoom+_i(i.center.lat,0),o=t.bt(1/di(i.center.lat),1/di(Math.min(Math.abs(i.center.lat),60)),t.bw(r,7,3,0,1)),s=360/ni({worldSize:i.worldSize,center:{lat:i.center.lat}});return new t.V(i.center.lng-a.x*s*o,t.an(i.center.lat+a.y*s,-t.ao,t.ao))}function mi(e){const t=.5*e,i=Math.sin(t),a=Math.cos(t);return Math.log(i+a)-Math.log(a-i)}function fi(e,i,a,r){const o=e.lat+a*r;if(Math.abs(a)>1){const s=(Math.sign(e.lat+a)!==Math.sign(e.lat)?-Math.abs(e.lat):Math.abs(e.lat))*Math.PI/180,n=Math.abs(e.lat+a)*Math.PI/180,l=mi(s+r*(n-s)),c=mi(s),h=mi(n);return new t.V(e.lng+i*((l-c)/(h-c)),o)}return new t.V(e.lng+i*r,o)}class gi{constructor(e){this._cachePrevious=new Map,this._cache=new Map,this._hadAnyChanges=!1,this._boundingVolumeFactory=e;}swapBuffers(){if(!this._hadAnyChanges)return;const e=this._cachePrevious;this._cachePrevious=this._cache,this._cache=e,this._cache.clear(),this._hadAnyChanges=!1;}getTileBoundingVolume(e,t,i,a){const r=`${e.z}_${e.x}_${e.y}_${(null==a?void 0:a.terrain)?"t":""}`,o=this._cache.get(r);if(o)return o;const s=this._cachePrevious.get(r);if(s)return this._cache.set(r,s),s;const n=this._boundingVolumeFactory(e,t,i,a);return this._cache.set(r,n),this._hadAnyChanges=!0,n}}class vi{constructor(e,t,i,a){this.min=i,this.max=a,this.points=e,this.planes=t;}static fromAabb(e,t){const i=[];for(let a=0;a<8;a++)i.push([1&~a?e[0]:t[0],1==(a>>1&1)?t[1]:e[1],1==(a>>2&1)?t[2]:e[2]]);return new vi(i,[[-1,0,0,t[0]],[1,0,0,-e[0]],[0,-1,0,t[1]],[0,1,0,-e[1]],[0,0,-1,t[2]],[0,0,1,-e[2]]],e,t)}static fromCenterSizeAngles(e,i,a){const r=t.bA([],a[0],a[1],a[2]),o=t.bB([],[i[0],0,0],r),s=t.bB([],[0,i[1],0],r),n=t.bB([],[0,0,i[2]],r),l=[...e],c=[...e];for(let t=0;t<8;t++)for(let i=0;i<3;i++){const a=e[i]+o[i]*(1&~t?-1:1)+s[i]*(1==(t>>1&1)?1:-1)+n[i]*(1==(t>>2&1)?1:-1);l[i]=Math.min(l[i],a),c[i]=Math.max(c[i],a);}const h=[];for(let i=0;i<8;i++){const a=[...e];t.a$(a,a,t.a_([],o,1&~i?-1:1)),t.a$(a,a,t.a_([],s,1==(i>>1&1)?1:-1)),t.a$(a,a,t.a_([],n,1==(i>>2&1)?1:-1)),h.push(a);}return new vi(h,[[...o,-t.b4(o,h[0])],[...s,-t.b4(s,h[0])],[...n,-t.b4(n,h[0])],[-o[0],-o[1],-o[2],-t.b4(o,h[7])],[-s[0],-s[1],-s[2],-t.b4(s,h[7])],[-n[0],-n[1],-n[2],-t.b4(n,h[7])]],l,c)}intersectsFrustum(e){let t=!0;const i=this.points.length,a=this.planes.length,r=e.planes.length,o=e.points.length;for(let a=0;a<r;a++){const r=e.planes[a];let o=0;for(let e=0;e<i;e++){const t=this.points[e];r[0]*t[0]+r[1]*t[1]+r[2]*t[2]+r[3]>=0&&o++;}if(0===o)return 0;o<i&&(t=!1);}if(t)return 2;for(let t=0;t<a;t++){const i=this.planes[t];let a=0;for(let t=0;t<o;t++){const r=e.points[t];i[0]*r[0]+i[1]*r[1]+i[2]*r[2]+i[3]>=0&&a++;}if(0===a)return 0}return 1}intersectsPlane(e){const t=this.points.length;let i=0;for(let a=0;a<t;a++){const t=this.points[a];e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]>=0&&i++;}return i===t?2:0===i?0:1}}function xi(e,t,i){const a=e-t;return a<0?-a:Math.max(0,a-i)}function bi(e,t,i,a,r){const o=e-i;let s;return s=o<0?Math.min(-o,1+o-r):o>1?Math.min(Math.max(o-r,0),1-o):0,Math.max(s,xi(t,a,r))}class yi{constructor(){this._boundingVolumeCache=new gi(this._computeTileBoundingVolume);}prepareNextFrame(){this._boundingVolumeCache.swapBuffers();}distanceToTile2d(e,t,i,a){const r=1<<i.z,o=1/r,s=i.x/r,n=i.y/r;let l=2;return l=Math.min(l,bi(e,t,s,n,o)),l=Math.min(l,bi(e,t,s+.5,-n-o,o)),l=Math.min(l,bi(e,t,s+.5,2-n-o,o)),l}getWrap(e,t,i){const a=1<<t.z,r=1/a,o=t.x/a,s=xi(e.x,o,r),n=xi(e.x,o-1,r),l=xi(e.x,o+1,r),c=Math.min(s,n,l);return c===l?1:c===n?-1:0}allowVariableZoom(e,t){return Pe(e,t)>4}allowWorldCopies(){return !1}getTileBoundingVolume(e,t,i,a){return this._boundingVolumeCache.getTileBoundingVolume(e,t,i,a)}_computeTileBoundingVolume(e,i,a,r){var o,s;let n=0,l=0;if(null==r?void 0:r.terrain){const c=new t.a1(e.z,i,e.z,e.x,e.y),h=r.terrain.getMinMaxElevation(c);n=null!==(o=h.minElevation)&&void 0!==o?o:Math.min(0,a),l=null!==(s=h.maxElevation)&&void 0!==s?s:Math.max(0,a);}if(n/=t.bD,l/=t.bD,n+=1,l+=1,e.z<=0)return vi.fromAabb([-l,-l,-l],[l,l,l]);if(1===e.z)return vi.fromAabb([0===e.x?-l:0,0===e.y?0:-l,-l],[0===e.x?0:l,0===e.y?l:0,l]);{const i=[li(0,0,e.x,e.y,e.z),li(t.a4,0,e.x,e.y,e.z),li(t.a4,t.a4,e.x,e.y,e.z),li(0,t.a4,e.x,e.y,e.z)],a=[];for(const e of i)a.push(t.a_([],e,l));if(l!==n)for(const e of i)a.push(t.a_([],e,n));0===e.y&&a.push([0,1,0]),e.y===(1<<e.z)-1&&a.push([0,-1,0]);const r=[1,1,1],o=[-1,-1,-1];for(const e of a)for(let t=0;t<3;t++)r[t]=Math.min(r[t],e[t]),o[t]=Math.max(o[t],e[t]);const s=li(t.a4/2,t.a4/2,e.x,e.y,e.z),c=t.b3([],[0,1,0],s);t.b2(c,c);const h=t.b3([],s,c);t.b2(h,h);const u=t.b3([],i[2],i[1]);t.b2(u,u);const d=t.b3([],i[0],i[3]);t.b2(d,d),a.push(t.a_([],s,l)),e.y>=(1<<e.z)/2&&a.push(t.a_([],li(t.a4/2,0,e.x,e.y,e.z),l)),e.y<(1<<e.z)/2&&a.push(t.a_([],li(t.a4/2,t.a4,e.x,e.y,e.z),l));const _=wi(s,a),p=wi(h,a),m=[-s[0],-s[1],-s[2],_.max],f=[s[0],s[1],s[2],-_.min],g=[-h[0],-h[1],-h[2],p.max],v=[h[0],h[1],h[2],-p.min],x=[...u,0],b=[...d,0],y=[];return 0===e.y?y.push(t.bC(b,x,m),t.bC(b,x,f)):y.push(t.bC(g,x,m),t.bC(g,x,f),t.bC(g,b,m),t.bC(g,b,f)),e.y===(1<<e.z)-1?y.push(t.bC(b,x,m),t.bC(b,x,f)):y.push(t.bC(v,x,m),t.bC(v,x,f),t.bC(v,b,m),t.bC(v,b,f)),new vi(y,[m,f,g,v,x,b],r,o)}}}function wi(e,i){let a=1/0,r=-1/0;for(const o of i){const i=t.b4(e,o);a=Math.min(a,i),r=Math.max(r,i);}return {min:a,max:r}}class Ti{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t){this._helper.resize(e,t);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}setConstrainOverride(e){this._helper.setConstrainOverride(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}setTransitionState(e){}constructor(e){this._cachedClippingPlane=t.bE(),this._projectionMatrix=t.bi(),this._globeViewProjMatrix32f=t.bh(),this._globeViewProjMatrixNoCorrection=t.bi(),this._globeViewProjMatrixNoCorrectionInverted=t.bi(),this._globeProjMatrixInverted=t.bi(),this._cameraPosition=t.by(),this._globeLatitudeErrorCorrectionRadians=0,this.defaultConstrain=(e,i)=>{const a=t.an(e.lat,-t.ao,t.ao),r=t.an(+i,this.minZoom+_i(0,a),this.maxZoom);return {center:new t.V(e.lng,a),zoom:r}},this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new Bt({calcMatrices:()=>{this._calcMatrices();},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._coveringTilesDetailsProvider=new yi;}clone(){const e=new Ti;return e.apply(this),e}apply(e,t){this._globeLatitudeErrorCorrectionRadians=t||0,this._helper.apply(e);}get projectionMatrix(){return this._projectionMatrix}get modelViewProjectionMatrix(){return this._globeViewProjMatrixNoCorrection}get inverseProjectionMatrix(){return this._globeProjMatrixInverted}get cameraPosition(){const e=t.by();return e[0]=this._cameraPosition[0],e[1]=this._cameraPosition[1],e[2]=this._cameraPosition[2],e}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}getProjectionData(e){const{overscaledTileID:t,applyGlobeMatrix:i}=e,a=this._helper.getMercatorTileCoordinates(t);return {mainMatrix:this._globeViewProjMatrix32f,tileMercatorCoords:a,clippingPlane:this._cachedClippingPlane,projectionTransition:i?1:0,fallbackMatrix:this._globeViewProjMatrix32f}}_computeClippingPlane(e){const i=this.pitchInRadians,a=this.cameraToCenterDistance/e,r=Math.sin(i)*a,o=Math.cos(i)*a+1,s=1/Math.sqrt(r*r+o*o)*1;let n=-r,l=o;const c=Math.sqrt(n*n+l*l);n/=c,l/=c;const h=[0,n,l];t.bF(h,h,[0,0,0],-this.bearingInRadians),t.bG(h,h,[0,0,0],-1*this.center.lat*Math.PI/180),t.bH(h,h,[0,0,0],this.center.lng*Math.PI/180);const u=1/t.b6(h);return t.a_(h,h,u),[...h,-s*u]}isLocationOccluded(e){return !this.isSurfacePointVisible(ci(e))}transformLightDirection(e){const i=this._helper._center.lng*Math.PI/180,a=this._helper._center.lat*Math.PI/180,r=Math.cos(a),o=[Math.sin(i)*r,Math.sin(a),Math.cos(i)*r],s=[o[2],0,-o[0]],n=[0,0,0];t.b3(n,s,o),t.b2(s,s),t.b2(n,n);const l=[0,0,0];return t.b2(l,[s[0]*e[0]+n[0]*e[1]+o[0]*e[2],s[1]*e[0]+n[1]*e[1]+o[1]*e[2],s[2]*e[0]+n[2]*e[1]+o[2]*e[2]]),l}getPixelScale(){return 1/Math.cos(this._helper._center.lat*Math.PI/180)}getCircleRadiusCorrection(){return Math.cos(this._helper._center.lat*Math.PI/180)}getPitchedTextCorrection(e,i,a){const r=function(e,i,a){const r=1/(1<<a.z);return new t.aa(e/t.a4*r+a.x*r,i/t.a4*r+a.y*r)}(e,i,a.canonical),o=(s=r.y,[t.bx(r.x*Math.PI*2+Math.PI,2*Math.PI),2*Math.atan(Math.exp(Math.PI-s*Math.PI*2))-.5*Math.PI]);var s;return this.getCircleRadiusCorrection()/Math.cos(o[1])}projectTileCoordinates(e,i,a,r){const o=a.canonical,s=li(e,i,o.x,o.y,o.z),n=1+(r?r(e,i):0)/t.bD,l=[s[0]*n,s[1]*n,s[2]*n,1];t.aG(l,l,this._globeViewProjMatrixNoCorrection);const c=this._cachedClippingPlane,h=c[0]*s[0]+c[1]*s[1]+c[2]*s[2]+c[3]<0;return {point:new t.P(l[0]/l[3],l[1]/l[3]),signedDistanceFromCamera:l[3],isOccluded:h}}_calcMatrices(){if(!this._helper._width||!this._helper._height)return;const e=hi(this.worldSize,this.center.lat),i=t.bj(),a=t.bj();this._helper.autoCalculateNearFarZ&&(this._helper._nearZ=.5,this._helper._farZ=this.cameraToCenterDistance+2*e),t.bd(i,this.fovInRadians,this.width/this.height,this._helper._nearZ,this._helper._farZ);const r=this.centerOffset;i[8]=2*-r.x/this._helper._width,i[9]=2*r.y/this._helper._height,this._projectionMatrix=t.be(i),this._globeProjMatrixInverted=t.bj(),t.aA(this._globeProjMatrixInverted,i),t.O(i,i,[0,0,-this.cameraToCenterDistance]),t.bf(i,i,this.rollInRadians),t.bg(i,i,-this.pitchInRadians),t.bf(i,i,this.bearingInRadians),t.O(i,i,[0,0,-e]);const o=t.by();o[0]=e,o[1]=e,o[2]=e,t.bg(a,i,this.center.lat*Math.PI/180),t.bI(a,a,-this.center.lng*Math.PI/180),t.Q(a,a,o),this._globeViewProjMatrixNoCorrection=a,t.bg(i,i,this.center.lat*Math.PI/180-this._globeLatitudeErrorCorrectionRadians),t.bI(i,i,-this.center.lng*Math.PI/180),t.Q(i,i,o),this._globeViewProjMatrix32f=new Float32Array(i),this._globeViewProjMatrixNoCorrectionInverted=t.bj(),t.aA(this._globeViewProjMatrixNoCorrectionInverted,a);const s=t.by();this._cameraPosition=t.by(),this._cameraPosition[2]=this.cameraToCenterDistance/e,t.bF(this._cameraPosition,this._cameraPosition,s,-this.rollInRadians),t.bG(this._cameraPosition,this._cameraPosition,s,this.pitchInRadians),t.bF(this._cameraPosition,this._cameraPosition,s,-this.bearingInRadians),t.a$(this._cameraPosition,this._cameraPosition,[0,0,1]),t.bG(this._cameraPosition,this._cameraPosition,s,-this.center.lat*Math.PI/180),t.bH(this._cameraPosition,this._cameraPosition,s,this.center.lng*Math.PI/180),this._cachedClippingPlane=this._computeClippingPlane(e);const n=t.be(this._globeViewProjMatrixNoCorrectionInverted);t.Q(n,n,[1,1,-1]),this._cachedFrustum=Nt.fromInvProjectionMatrix(n,1,0,this._cachedClippingPlane,!0);}calculateFogMatrix(e){t.w("calculateFogMatrix is not supported on globe projection.");const i=t.bj();return t.ar(i),i}getVisibleUnwrappedCoordinates(e){return [new t.bb(0,e)]}getCameraFrustum(){return this._cachedFrustum}getClippingPlane(){return this._cachedClippingPlane}getCoveringTilesDetailsProvider(){return this._coveringTilesDetailsProvider}recalculateZoomAndCenter(e){e&&t.w("terrain is not fully supported on vertical perspective projection."),this._helper.recalculateZoomAndCenter(0);}maxPitchScaleFactor(){return 1}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,i){if(!this._globeViewProjMatrixNoCorrection)return 1;const a=ci(e);t.a_(a,a,1+i/t.bD);const r=t.bE();return t.aG(r,[a[0],a[1],a[2],1],this._globeViewProjMatrixNoCorrection),r[2]/r[3]}populateCache(e){}getBounds(){const e=.5*this.width,i=.5*this.height,a=[new t.P(0,0),new t.P(e,0),new t.P(this.width,0),new t.P(this.width,i),new t.P(this.width,this.height),new t.P(e,this.height),new t.P(0,this.height),new t.P(0,i)],r=[];for(const e of a)r.push(this.unprojectScreenPoint(e));let o=0,s=0,n=0,l=0;const c=this.center;for(const e of r){const i=t.bJ(c.lng,e.lng),a=t.bJ(c.lat,e.lat);i<s&&(s=i),i>o&&(o=i),a<l&&(l=a),a>n&&(n=a);}const h=[c.lng+s,c.lat+l,c.lng+o,c.lat+n];return this.isSurfacePointOnScreen([0,1,0])&&(h[3]=90,h[0]=-180,h[2]=180),this.isSurfacePointOnScreen([0,-1,0])&&(h[1]=-90,h[0]=-180,h[2]=180),new $(h)}calculateCenterFromCameraLngLatAlt(e,t,i,a){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,a)}setLocationAtPoint(e,i){const a=ci(this.unprojectScreenPoint(i)),r=ci(e),o=t.by();t.bK(o);const s=t.by();t.bH(s,a,o,-this.center.lng*Math.PI/180),t.bG(s,s,o,this.center.lat*Math.PI/180);const n=r[0]*r[0]+r[2]*r[2],l=s[0]*s[0];if(n<l)return;const c=Math.sqrt(n-l),h=-c,u=t.bL(r[0],r[2],s[0],c),d=t.bL(r[0],r[2],s[0],h),_=t.by();t.bH(_,r,o,-u);const p=t.bL(_[1],_[2],s[1],s[2]),m=t.by();t.bH(m,r,o,-d);const f=t.bL(m[1],m[2],s[1],s[2]),g=.5*Math.PI,v=p>=-g&&p<=g,x=f>=-g&&f<=g;let b,y;if(v&&x){const e=this.center.lng*Math.PI/180,i=this.center.lat*Math.PI/180;t.bM(u,e)+t.bM(p,i)<t.bM(d,e)+t.bM(f,i)?(b=u,y=p):(b=d,y=f);}else if(v)b=u,y=p;else {if(!x)return;b=d,y=f;}const w=b/Math.PI*180,T=y/Math.PI*180,P=this.center.lat;this.setCenter(new t.V(w,t.an(T,-90,90))),this.setZoom(this.zoom+_i(P,this.center.lat));}locationToScreenPoint(e,i){const a=ci(e);if(i){const r=i.getElevationForLngLatZoom(e,this._helper._tileZoom);t.a_(a,a,1+r/t.bD);}return this._projectSurfacePointToScreen(a)}_projectSurfacePointToScreen(e){const i=t.bE();return t.aG(i,[...e,1],this._globeViewProjMatrixNoCorrection),i[0]/=i[3],i[1]/=i[3],new t.P((.5*i[0]+.5)*this.width,(.5*-i[1]+.5)*this.height)}screenPointToMercatorCoordinate(e,i){if(i){const t=i.pointCoordinate(e);if(t)return t}return t.aa.fromLngLat(this.unprojectScreenPoint(e))}screenPointToLocation(e,t){var i;return null===(i=this.screenPointToMercatorCoordinate(e,t))||void 0===i?void 0:i.toLngLat()}isPointOnMapSurface(e,t){const i=this._cameraPosition,a=this.getRayDirectionFromPixel(e);return !!this.rayPlanetIntersection(i,a)}getRayDirectionFromPixel(e){const i=t.bE();i[0]=e.x/this.width*2-1,i[1]=-1*(e.y/this.height*2-1),i[2]=1,i[3]=1,t.aG(i,i,this._globeViewProjMatrixNoCorrectionInverted),i[0]/=i[3],i[1]/=i[3],i[2]/=i[3];const a=t.by();a[0]=i[0]-this._cameraPosition[0],a[1]=i[1]-this._cameraPosition[1],a[2]=i[2]-this._cameraPosition[2];const r=t.by();return t.b2(r,a),r}isSurfacePointVisible(e){const t=this._cachedClippingPlane;return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]+t[3]>=0}isSurfacePointOnScreen(e){if(!this.isSurfacePointVisible(e))return !1;const i=t.bE();return t.aG(i,[...e,1],this._globeViewProjMatrixNoCorrection),i[0]/=i[3],i[1]/=i[3],i[2]/=i[3],i[0]>-1&&i[0]<1&&i[1]>-1&&i[1]<1&&i[2]>-1&&i[2]<1}rayPlanetIntersection(e,i){const a=t.b4(e,i),r=t.by(),o=t.by();t.a_(o,i,a),t.b1(r,e,o);const s=1-t.b4(r,r);if(s<0)return null;const n=t.b4(e,e)-1,l=-a+(a<0?1:-1)*Math.sqrt(s),c=n/l,h=l;return {tMin:Math.min(c,h),tMax:Math.max(c,h)}}unprojectScreenPoint(e){const i=this._cameraPosition,a=this.getRayDirectionFromPixel(e),r=this.rayPlanetIntersection(i,a);if(r){const e=t.by();t.a$(e,i,[a[0]*r.tMin,a[1]*r.tMin,a[2]*r.tMin]);const o=t.by();return t.b2(o,e),ui(o)}const o=this._cachedClippingPlane,s=o[0]*a[0]+o[1]*a[1]+o[2]*a[2],n=-t.ba(o,i)/s,l=t.by();if(n>0)t.a$(l,i,[a[0]*n,a[1]*n,a[2]*n]);else {const e=t.by();t.a$(e,i,[2*a[0],2*a[1],2*a[2]]);const r=t.ba(this._cachedClippingPlane,e);t.b1(l,e,[this._cachedClippingPlane[0]*r,this._cachedClippingPlane[1]*r,this._cachedClippingPlane[2]*r]);}const c=function(e){const i=t.by();return i[0]=e[0]*-e[3],i[1]=e[1]*-e[3],i[2]=e[2]*-e[3],{center:i,radius:Math.sqrt(1-e[3]*e[3])}}(o);return ui(function(e,i,a){const r=t.by();t.b1(r,a,e);const o=t.by();return t.bz(o,e,r,i/t.b8(r)),o}(c.center,c.radius,l))}getMatrixForModel(e,i){const a=t.V.convert(e),r=1/t.bD,o=t.bi();return t.bI(o,o,a.lng/180*Math.PI),t.bg(o,o,-a.lat/180*Math.PI),t.O(o,o,[0,0,1+i/t.bD]),t.bg(o,o,.5*Math.PI),t.Q(o,o,[r,r,r]),o}getProjectionDataForCustomLayer(e=!0){const i=this.getProjectionData({overscaledTileID:new t.a1(0,0,0,0,0),applyGlobeMatrix:e});return i.tileMercatorCoords=[0,0,1,1],i}getFastPathSimpleProjectionMatrix(e){}}class Pi{get pixelsToClipSpaceMatrix(){return this._helper.pixelsToClipSpaceMatrix}get clipSpaceToPixelsMatrix(){return this._helper.clipSpaceToPixelsMatrix}get pixelsToGLUnits(){return this._helper.pixelsToGLUnits}get centerOffset(){return this._helper.centerOffset}get size(){return this._helper.size}get rotationMatrix(){return this._helper.rotationMatrix}get centerPoint(){return this._helper.centerPoint}get pixelsPerMeter(){return this._helper.pixelsPerMeter}setMinZoom(e){this._helper.setMinZoom(e);}setMaxZoom(e){this._helper.setMaxZoom(e);}setMinPitch(e){this._helper.setMinPitch(e);}setMaxPitch(e){this._helper.setMaxPitch(e);}setRenderWorldCopies(e){this._helper.setRenderWorldCopies(e);}setBearing(e){this._helper.setBearing(e);}setPitch(e){this._helper.setPitch(e);}setRoll(e){this._helper.setRoll(e);}setFov(e){this._helper.setFov(e);}setZoom(e){this._helper.setZoom(e);}setCenter(e){this._helper.setCenter(e);}setElevation(e){this._helper.setElevation(e);}setMinElevationForCurrentTile(e){this._helper.setMinElevationForCurrentTile(e);}setPadding(e){this._helper.setPadding(e);}interpolatePadding(e,t,i){return this._helper.interpolatePadding(e,t,i)}isPaddingEqual(e){return this._helper.isPaddingEqual(e)}resize(e,t,i=!0){this._helper.resize(e,t,i);}getMaxBounds(){return this._helper.getMaxBounds()}setMaxBounds(e){this._helper.setMaxBounds(e);}setConstrainOverride(e){this._helper.setConstrainOverride(e);}overrideNearFarZ(e,t){this._helper.overrideNearFarZ(e,t);}clearNearFarZOverride(){this._helper.clearNearFarZOverride();}getCameraQueryGeometry(e){return this._helper.getCameraQueryGeometry(this.getCameraPoint(),e)}get tileSize(){return this._helper.tileSize}get tileZoom(){return this._helper.tileZoom}get scale(){return this._helper.scale}get worldSize(){return this._helper.worldSize}get width(){return this._helper.width}get height(){return this._helper.height}get lngRange(){return this._helper.lngRange}get latRange(){return this._helper.latRange}get minZoom(){return this._helper.minZoom}get maxZoom(){return this._helper.maxZoom}get zoom(){return this._helper.zoom}get center(){return this._helper.center}get minPitch(){return this._helper.minPitch}get maxPitch(){return this._helper.maxPitch}get pitch(){return this._helper.pitch}get pitchInRadians(){return this._helper.pitchInRadians}get roll(){return this._helper.roll}get rollInRadians(){return this._helper.rollInRadians}get bearing(){return this._helper.bearing}get bearingInRadians(){return this._helper.bearingInRadians}get fov(){return this._helper.fov}get fovInRadians(){return this._helper.fovInRadians}get elevation(){return this._helper.elevation}get minElevationForCurrentTile(){return this._helper.minElevationForCurrentTile}get padding(){return this._helper.padding}get unmodified(){return this._helper.unmodified}get renderWorldCopies(){return this._helper.renderWorldCopies}get cameraToCenterDistance(){return this._helper.cameraToCenterDistance}get constrainOverride(){return this._helper.constrainOverride}get nearZ(){return this._helper.nearZ}get farZ(){return this._helper.farZ}get autoCalculateNearFarZ(){return this._helper.autoCalculateNearFarZ}get isGlobeRendering(){return this._globeness>0}setTransitionState(e,t){this._globeness=e,this._globeLatitudeErrorCorrectionRadians=t,this._calcMatrices(),this._verticalPerspectiveTransform.getCoveringTilesDetailsProvider().prepareNextFrame(),this._mercatorTransform.getCoveringTilesDetailsProvider().prepareNextFrame();}get currentTransform(){return this.isGlobeRendering?this._verticalPerspectiveTransform:this._mercatorTransform}constructor(e){this._globeLatitudeErrorCorrectionRadians=0,this._globeness=1,this.defaultConstrain=(e,t)=>this.currentTransform.defaultConstrain(e,t),this.applyConstrain=(e,t)=>this._helper.applyConstrain(e,t),this._helper=new Bt({calcMatrices:()=>{this._calcMatrices();},defaultConstrain:(e,t)=>this.defaultConstrain(e,t)},e),this._globeness=1,this._mercatorTransform=new Zt,this._verticalPerspectiveTransform=new Ti;}clone(){const e=new Pi;return e._globeness=this._globeness,e._globeLatitudeErrorCorrectionRadians=this._globeLatitudeErrorCorrectionRadians,e.apply(this),e}apply(e){this._helper.apply(e),this._mercatorTransform.apply(this),this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians);}get projectionMatrix(){return this.currentTransform.projectionMatrix}get modelViewProjectionMatrix(){return this.currentTransform.modelViewProjectionMatrix}get inverseProjectionMatrix(){return this.currentTransform.inverseProjectionMatrix}get cameraPosition(){return this.currentTransform.cameraPosition}getProjectionData(e){const t=this._mercatorTransform.getProjectionData(e),i=this._verticalPerspectiveTransform.getProjectionData(e);return {mainMatrix:this.isGlobeRendering?i.mainMatrix:t.mainMatrix,clippingPlane:i.clippingPlane,tileMercatorCoords:i.tileMercatorCoords,projectionTransition:e.applyGlobeMatrix?this._globeness:0,fallbackMatrix:t.fallbackMatrix}}isLocationOccluded(e){return this.currentTransform.isLocationOccluded(e)}transformLightDirection(e){return this.currentTransform.transformLightDirection(e)}getPixelScale(){return t.bt(this._mercatorTransform.getPixelScale(),this._verticalPerspectiveTransform.getPixelScale(),this._globeness)}getCircleRadiusCorrection(){return t.bt(this._mercatorTransform.getCircleRadiusCorrection(),this._verticalPerspectiveTransform.getCircleRadiusCorrection(),this._globeness)}getPitchedTextCorrection(e,i,a){const r=this._mercatorTransform.getPitchedTextCorrection(e,i,a),o=this._verticalPerspectiveTransform.getPitchedTextCorrection(e,i,a);return t.bt(r,o,this._globeness)}projectTileCoordinates(e,t,i,a){return this.currentTransform.projectTileCoordinates(e,t,i,a)}_calcMatrices(){this._helper._width&&this._helper._height&&(this._verticalPerspectiveTransform.apply(this,this._globeLatitudeErrorCorrectionRadians),this._helper._nearZ=this._verticalPerspectiveTransform.nearZ,this._helper._farZ=this._verticalPerspectiveTransform.farZ,this._mercatorTransform.apply(this,!0,this.isGlobeRendering),this._helper._nearZ=this._mercatorTransform.nearZ,this._helper._farZ=this._mercatorTransform.farZ);}calculateFogMatrix(e){return this.currentTransform.calculateFogMatrix(e)}getVisibleUnwrappedCoordinates(e){return this.currentTransform.getVisibleUnwrappedCoordinates(e)}getCameraFrustum(){return this.currentTransform.getCameraFrustum()}getClippingPlane(){return this.currentTransform.getClippingPlane()}getCoveringTilesDetailsProvider(){return this.currentTransform.getCoveringTilesDetailsProvider()}recalculateZoomAndCenter(e){this._mercatorTransform.recalculateZoomAndCenter(e),this._verticalPerspectiveTransform.recalculateZoomAndCenter(e);}maxPitchScaleFactor(){return this._mercatorTransform.maxPitchScaleFactor()}getCameraPoint(){return this._helper.getCameraPoint()}getCameraAltitude(){return this._helper.getCameraAltitude()}getCameraLngLat(){return this._helper.getCameraLngLat()}lngLatToCameraDepth(e,t){return this.currentTransform.lngLatToCameraDepth(e,t)}populateCache(e){this._mercatorTransform.populateCache(e),this._verticalPerspectiveTransform.populateCache(e);}getBounds(){return this.currentTransform.getBounds()}calculateCenterFromCameraLngLatAlt(e,t,i,a){return this._helper.calculateCenterFromCameraLngLatAlt(e,t,i,a)}setLocationAtPoint(e,t){if(!this.isGlobeRendering)return this._mercatorTransform.setLocationAtPoint(e,t),void this.apply(this._mercatorTransform);this._verticalPerspectiveTransform.setLocationAtPoint(e,t),this.apply(this._verticalPerspectiveTransform);}locationToScreenPoint(e,t){return this.currentTransform.locationToScreenPoint(e,t)}screenPointToMercatorCoordinate(e,t){return this.currentTransform.screenPointToMercatorCoordinate(e,t)}screenPointToLocation(e,t){return this.currentTransform.screenPointToLocation(e,t)}isPointOnMapSurface(e,t){return this.currentTransform.isPointOnMapSurface(e,t)}getRayDirectionFromPixel(e){return this._verticalPerspectiveTransform.getRayDirectionFromPixel(e)}getMatrixForModel(e,t){return this.currentTransform.getMatrixForModel(e,t)}getProjectionDataForCustomLayer(e=!0){const t=this._mercatorTransform.getProjectionDataForCustomLayer(e);if(!this.isGlobeRendering)return t;const i=this._verticalPerspectiveTransform.getProjectionDataForCustomLayer(e);return i.fallbackMatrix=t.mainMatrix,i}getFastPathSimpleProjectionMatrix(e){return this.currentTransform.getFastPathSimpleProjectionMatrix(e)}}class Ci{get useGlobeControls(){return !0}handlePanInertia(e,i){const a=pi(e,i);return Math.abs(a.lng-i.center.lng)>180&&(a.lng=i.center.lng+179.5*Math.sign(a.lng-i.center.lng)),{easingCenter:a,easingOffset:new t.P(0,0)}}handleMapControlsRollPitchBearingZoom(e,i){const a=e.around,r=i.screenPointToLocation(a);e.bearingDelta&&i.setBearing(i.bearing+e.bearingDelta),e.pitchDelta&&i.setPitch(i.pitch+e.pitchDelta),e.rollDelta&&i.setRoll(i.roll+e.rollDelta);const o=i.zoom;e.zoomDelta&&i.setZoom(i.zoom+e.zoomDelta);const s=i.zoom-o;if(0===s)return;const n=t.bJ(i.center.lng,r.lng),l=n/(Math.abs(n/180)+1),c=t.bJ(i.center.lat,r.lat),h=i.getRayDirectionFromPixel(a),u=i.cameraPosition,d=-1*t.b4(u,h),_=t.by();t.a$(_,u,[h[0]*d,h[1]*d,h[2]*d]);const p=t.b6(_)-1,m=Math.exp(.5*-Math.max(p-.3,0)),f=hi(i.worldSize,i.center.lat)/Math.min(i.width,i.height),g=t.bw(f,.9,.5,1,.25),v=(1-t.aq(-s))*Math.min(m,g),x=i.center.lat,b=i.zoom,y=new t.V(i.center.lng+l*v,t.an(i.center.lat+c*v,-t.ao,t.ao));i.setLocationAtPoint(r,a);const w=i.center,T=t.bw(Math.abs(n),45,85,0,1),P=t.bw(f,.75,.35,0,1),C=Math.pow(Math.max(T,P),.25),M=t.bJ(w.lng,y.lng),I=t.bJ(w.lat,y.lat);i.setCenter(new t.V(w.lng+M*C,w.lat+I*C).wrap()),i.setZoom(b+_i(x,i.center.lat));}handleMapControlsPan(e,t,i){if(!e.panDelta)return;const a=t.center.lat,r=t.zoom;t.setCenter(pi(e.panDelta,t).wrap()),t.setZoom(r+_i(a,t.center.lat));}cameraForBoxAndBearing(e,i,a,r,o){const s=Vt(e,i,a,r,o),n=i.left/o.width*2-1,l=(o.width-i.right)/o.width*2-1,c=i.top/o.height*-2+1,h=(o.height-i.bottom)/o.height*-2+1,u=t.bJ(a.getWest(),a.getEast())<0,d=u?a.getEast():a.getWest(),_=u?a.getWest():a.getEast(),p=Math.max(a.getNorth(),a.getSouth()),m=Math.min(a.getNorth(),a.getSouth()),f=d+.5*t.bJ(d,_),g=p+.5*t.bJ(p,m),v=o.clone();v.setCenter(s.center),v.setBearing(s.bearing),v.setPitch(0),v.setRoll(0),v.setZoom(s.zoom);const x=v.modelViewProjectionMatrix,b=[ci(a.getNorthWest()),ci(a.getNorthEast()),ci(a.getSouthWest()),ci(a.getSouthEast()),ci(new t.V(_,g)),ci(new t.V(d,g)),ci(new t.V(f,p)),ci(new t.V(f,m))],y=ci(s.center);let w=Number.POSITIVE_INFINITY;for(const e of b)n<0&&(w=Ci.getLesserNonNegativeNonNull(w,Ci.solveVectorScale(e,y,x,"x",n))),l>0&&(w=Ci.getLesserNonNegativeNonNull(w,Ci.solveVectorScale(e,y,x,"x",l))),c>0&&(w=Ci.getLesserNonNegativeNonNull(w,Ci.solveVectorScale(e,y,x,"y",c))),h<0&&(w=Ci.getLesserNonNegativeNonNull(w,Ci.solveVectorScale(e,y,x,"y",h)));if(Number.isFinite(w)&&0!==w)return s.zoom=v.zoom+t.at(w),s;Gt();}handleJumpToCenterZoom(e,i){const a=e.center.lat,r=e.applyConstrain(i.center?t.V.convert(i.center):e.center,e.zoom).center;e.setCenter(r.wrap());const o=void 0!==i.zoom?+i.zoom:e.zoom+_i(a,r.lat);e.zoom!==o&&e.setZoom(o);}handleEaseTo(e,i){const a=e.zoom,r=e.center,o=e.padding,s={roll:e.roll,pitch:e.pitch,bearing:e.bearing},n={roll:void 0===i.roll?e.roll:i.roll,pitch:void 0===i.pitch?e.pitch:i.pitch,bearing:void 0===i.bearing?e.bearing:i.bearing},l=void 0!==i.zoom,c=!e.isPaddingEqual(i.padding);let h=!1;const u=i.center?t.V.convert(i.center):r,d=e.applyConstrain(u,a).center;kt(e,d);const _=e.clone();_.setCenter(d),_.setZoom(l?+i.zoom:a+_i(r.lat,u.lat)),_.setBearing(i.bearing);const p=new t.P(t.an(e.centerPoint.x+i.offsetAsPoint.x,0,e.width),t.an(e.centerPoint.y+i.offsetAsPoint.y,0,e.height));_.setLocationAtPoint(d,p);const m=(i.offset&&i.offsetAsPoint.mag())>0?_.center:d,f=l?+i.zoom:a+_i(r.lat,m.lat),g=a+_i(r.lat,0),v=f+_i(m.lat,0),x=t.bJ(r.lng,m.lng),b=t.bJ(r.lat,m.lat),y=t.aq(v-g);return h=f!==a,{easeFunc:a=>{if(t.bn(s,n)||Ut({startEulerAngles:s,endEulerAngles:n,tr:e,k:a,useSlerp:s.roll!=n.roll}),c&&e.interpolatePadding(o,i.padding,a),i.around)t.w("Easing around a point is not supported under globe projection."),e.setLocationAtPoint(i.around,i.aroundPoint);else {const t=v>g?Math.min(2,y):Math.max(.5,y),i=Math.pow(t,1-a),o=fi(r,x,b,a*i);e.setCenter(o.wrap());}if(h){const i=t.G.number(g,v,a)+_i(0,e.center.lat);e.setZoom(i);}},isZooming:h,elevationCenter:m}}handleFlyTo(e,i){const a=void 0!==i.zoom,r=e.center,o=e.zoom,s=e.padding,n=!e.isPaddingEqual(i.padding),l=e.applyConstrain(t.V.convert(i.center||i.locationAtOffset),o).center,c=a?+i.zoom:e.zoom+_i(e.center.lat,l.lat),h=e.clone();h.setCenter(l),h.setZoom(c),h.setBearing(i.bearing);const u=new t.P(t.an(e.centerPoint.x+i.offsetAsPoint.x,0,e.width),t.an(e.centerPoint.y+i.offsetAsPoint.y,0,e.height));h.setLocationAtPoint(l,u);const d=h.center;kt(e,d);const _=function(e,i,a){const r=ci(i),o=ci(a),s=t.b4(r,o),n=Math.acos(s),l=ni(e);return n/(2*Math.PI)*l}(e,r,d),p=o+_i(r.lat,0),m=c+_i(d.lat,0),f=t.aq(m-p);let g;if("number"==typeof i.minZoom){const a=+i.minZoom+_i(d.lat,0),r=Math.min(a,p,m)+_i(0,d.lat),o=e.applyConstrain(d,r).zoom+_i(d.lat,0);g=t.aq(o-p);}const v=t.bJ(r.lng,d.lng),x=t.bJ(r.lat,d.lat);return {easeFunc:(a,o,l,h)=>{const u=fi(r,v,x,l);n&&e.interpolatePadding(s,i.padding,a);const _=1===a?d:u;e.setCenter(_.wrap());const m=p+t.at(o);e.setZoom(1===a?c:m+_i(0,_.lat));},scaleOfZoom:f,targetCenter:d,scaleOfMinZoom:g,pixelPathLength:_}}static solveVectorScale(e,t,i,a,r){const o="x"===a?[i[0],i[4],i[8],i[12]]:[i[1],i[5],i[9],i[13]],s=[i[3],i[7],i[11],i[15]],n=e[0]*o[0]+e[1]*o[1]+e[2]*o[2],l=e[0]*s[0]+e[1]*s[1]+e[2]*s[2],c=t[0]*o[0]+t[1]*o[1]+t[2]*o[2],h=t[0]*s[0]+t[1]*s[1]+t[2]*s[2];return c+r*l===n+r*h||s[3]*(n-c)+o[3]*(h-l)+n*h==c*l?null:(c+o[3]-r*h-r*s[3])/(c-n-r*h+r*l)}static getLesserNonNegativeNonNull(e,t){return null!==t&&t>=0&&t<e?t:e}}class Mi{constructor(e){this._globe=e,this._mercatorCameraHelper=new qt,this._verticalPerspectiveCameraHelper=new Ci;}get useGlobeControls(){return this._globe.useGlobeRendering}get currentHelper(){return this.useGlobeControls?this._verticalPerspectiveCameraHelper:this._mercatorCameraHelper}handlePanInertia(e,t){return this.currentHelper.handlePanInertia(e,t)}handleMapControlsRollPitchBearingZoom(e,t){return this.currentHelper.handleMapControlsRollPitchBearingZoom(e,t)}handleMapControlsPan(e,t,i){this.currentHelper.handleMapControlsPan(e,t,i);}cameraForBoxAndBearing(e,t,i,a,r){return this.currentHelper.cameraForBoxAndBearing(e,t,i,a,r)}handleJumpToCenterZoom(e,t){this.currentHelper.handleJumpToCenterZoom(e,t);}handleEaseTo(e,t){return this.currentHelper.handleEaseTo(e,t)}handleFlyTo(e,t){return this.currentHelper.handleFlyTo(e,t)}}const Ii=(e,i)=>t.B(e,i&&i.filter((e=>"source.canvas"!==e.identifier))),Ei=t.bN();class Si extends t.E{constructor(e,i={}){var a,r;super(),this._rtlPluginLoaded=()=>{for(const e in this.tileManagers){const t=this.tileManagers[e].getSource().type;"vector"!==t&&"geojson"!==t||this.tileManagers[e].reload();}},this.map=e,this.dispatcher=new N(j(),e._getMapId()),this.dispatcher.registerMessageHandler("GG",((e,t)=>this.getGlyphs(e,t))),this.dispatcher.registerMessageHandler("GI",((e,t)=>this.getImages(e,t))),this.dispatcher.registerMessageHandler("GDA",((e,t)=>this.getDashes(e,t))),this.imageManager=new w,this.imageManager.setEventedParent(this);const o=(null===(a=e._container)||void 0===a?void 0:a.lang)||"undefined"!=typeof document&&(null===(r=document.documentElement)||void 0===r?void 0:r.lang)||void 0;this.glyphManager=new I(e._requestManager,i.localIdeographFontFamily,o),this.lineAtlas=new A(256,512),this.crossTileSymbolIndex=new Ct,this._setInitialValues(),this._resetUpdates(),this.dispatcher.broadcast("SR",t.bO()),ce().on(se,this._rtlPluginLoaded),this.on("data",(e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.tileManagers[e.sourceId];if(!t)return;const i=t.getSource();if(i&&i.vectorLayerIds)for(const e in this._layers){const t=this._layers[e];t.source===i.id&&this._validateLayer(t);}}));}_setInitialValues(){var e;this._spritesImagesIds={},this._layers={},this._order=[],this.tileManagers={},this.zoomHistory=new t.bP,this._availableImages=[],this._globalState={},this._serializedLayers={},this.stylesheet=null,this.light=null,this.sky=null,this.projection&&(this.projection.destroy(),delete this.projection),this._loaded=!1,this._changed=!1,this._updatedLayers={},this._updatedSources={},this._changedImages={},this._glyphsDidChange=!1,this._updatedPaintProps={},this._layerOrderChanged=!1,this.crossTileSymbolIndex=new((null===(e=this.crossTileSymbolIndex)||void 0===e?void 0:e.constructor)||Object),this.pauseablePlacement=void 0,this.placement=void 0,this.z=0;}setGlobalStateProperty(e,i){var a,r,o;this._checkLoaded();const s=null===i?null!==(o=null===(r=null===(a=this.stylesheet.state)||void 0===a?void 0:a[e])||void 0===r?void 0:r.default)&&void 0!==o?o:null:i;if(t.bQ(s,this._globalState[e]))return this;this._globalState[e]=s,this._applyGlobalStateChanges([e]);}getGlobalState(){return this._globalState}setGlobalState(e){this._checkLoaded();const i=[];for(const a in e)!t.bQ(this._globalState[a],e[a].default)&&(i.push(a),this._globalState[a]=e[a].default);this._applyGlobalStateChanges(i);}_applyGlobalStateChanges(e){if(0===e.length)return;const t=new Set,i={};for(const a of e){i[a]=this._globalState[a];for(const e in this._layers){const i=this._layers[e],r=i.getLayoutAffectingGlobalStateRefs(),o=i.getPaintAffectingGlobalStateRefs();if(r.has(a)&&t.add(i.source),o.has(a))for(const{name:e,value:t}of o.get(a))this._updatePaintProperty(i,e,t);}}this.dispatcher.broadcast("UGS",i);for(const e in this.tileManagers)t.has(e)&&(this._reloadSource(e),this._changed=!0);}loadURL(e,i={},a){this.fire(new t.l("dataloading",{dataType:"style"})),i.validate="boolean"!=typeof i.validate||i.validate;const r=this.map._requestManager.transformRequest(e,"Style");this._loadStyleRequest=new AbortController;const o=this._loadStyleRequest;t.j(r,this._loadStyleRequest).then((e=>{this._loadStyleRequest=null,this._load(e.data,i,a);})).catch((e=>{this._loadStyleRequest=null,e&&!o.signal.aborted&&this.fire(new t.k(e));}));}loadJSON(e,i={},a){this.fire(new t.l("dataloading",{dataType:"style"})),this._frameRequest=new AbortController,n.frameAsync(this._frameRequest).then((()=>{this._frameRequest=null,i.validate=!1!==i.validate,this._load(e,i,a);})).catch((()=>{}));}loadEmpty(){this.fire(new t.l("dataloading",{dataType:"style"})),this._load(Ei,{validate:!1});}_load(e,i,a){var r,o;let s=i.transformStyle?i.transformStyle(a,e):e;if(!i.validate||!Ii(this,t.C(s))){s=Object.assign({},s),this._loaded=!0,this.stylesheet=s;for(const e in s.sources)this.addSource(e,s.sources[e],{validate:!1});s.sprite?this._loadSprite(s.sprite):this.imageManager.setLoaded(!0),this.glyphManager.setURL(s.glyphs),this._createLayers(),this.light=new R(this.stylesheet.light),this._setProjectionInternal((null===(r=this.stylesheet.projection)||void 0===r?void 0:r.type)||"mercator"),this.sky=new z(this.stylesheet.sky),this.map.setTerrain(null!==(o=this.stylesheet.terrain)&&void 0!==o?o:null),this.fire(new t.l("data",{dataType:"style"})),this.fire(new t.l("style.load"));}}_createLayers(){var e,i,a;const r=t.bR(this.stylesheet.layers);this.setGlobalState(null!==(e=this.stylesheet.state)&&void 0!==e?e:null),this.dispatcher.broadcast("SL",r),this._order=r.map((e=>e.id)),this._layers={},this._serializedLayers=null;for(const e of r){const r=t.bS(e,this._globalState);if(r.setEventedParent(this,{layer:{id:e.id}}),this._layers[e.id]=r,t.bT(r)&&this.tileManagers[r.source]){const t=null!==(a=null===(i=e.paint)||void 0===i?void 0:i["raster-fade-duration"])&&void 0!==a?a:r.paint.get("raster-fade-duration");this.tileManagers[r.source].setRasterFadeDuration(t);}}}_loadSprite(e,i=!1,a=void 0){let r;this.imageManager.setLoaded(!1),this._spriteRequest=new AbortController,function(e,i,a,r){return t._(this,void 0,void 0,(function*(){const o=x(e),s=a>1?"@2x":"",l={},c={};for(const{id:e,url:a}of o){const o=i.transformRequest(b(a,s,".json"),"SpriteJSON");l[e]=t.j(o,r);const n=i.transformRequest(b(a,s,".png"),"SpriteImage");c[e]=g.getImage(n,r);}return yield Promise.all([...Object.values(l),...Object.values(c)]),function(e,i){return t._(this,void 0,void 0,(function*(){const t={};for(const a in e){t[a]={};const r=n.getImageCanvasContext((yield i[a]).data),o=(yield e[a]).data;for(const e in o){const{width:i,height:s,x:n,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m}=o[e];t[a][e]={data:null,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_,textFitWidth:p,textFitHeight:m,spriteData:{width:i,height:s,x:n,y:l,context:r}};}}return t}))}(l,c)}))}(e,this.map._requestManager,this.map.getPixelRatio(),this._spriteRequest).then((e=>{if(this._spriteRequest=null,e)for(const t in e){this._spritesImagesIds[t]=[];const a=this._spritesImagesIds[t]?this._spritesImagesIds[t].filter((t=>!(t in e))):[];for(const e of a)this.imageManager.removeImage(e),this._changedImages[e]=!0;for(const a in e[t]){const r="default"===t?a:`${t}:${a}`;this._spritesImagesIds[t].push(r),r in this.imageManager.images?this.imageManager.updateImage(r,e[t][a],!1):this.imageManager.addImage(r,e[t][a]),i&&(this._changedImages[r]=!0);}}})).catch((e=>{this._spriteRequest=null,r=e,this.fire(new t.k(r));})).finally((()=>{this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),i&&(this._changed=!0),this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"})),a&&a(r);}));}_unloadSprite(){for(const e of Object.values(this._spritesImagesIds).flat())this.imageManager.removeImage(e),this._changedImages[e]=!0;this._spritesImagesIds={},this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}_validateLayer(e){const i=this.tileManagers[e.source];if(!i)return;const a=e.sourceLayer;if(!a)return;const r=i.getSource();("geojson"===r.type||r.vectorLayerIds&&-1===r.vectorLayerIds.indexOf(a))&&this.fire(new t.k(new Error(`Source layer "${a}" does not exist on source "${r.id}" as specified by style layer "${e.id}".`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const e in this.tileManagers)if(!this.tileManagers[e].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeByIds(e,i=!1){const a=this._serializedAllLayers();if(!e||0===e.length)return Object.values(i?t.bU(a):a);const r=[];for(const o of e)if(a[o]){const e=i?t.bU(a[o]):a[o];r.push(e);}return r}_serializedAllLayers(){let e=this._serializedLayers;if(e)return e;e=this._serializedLayers={};const t=Object.keys(this._layers);for(const i of t){const t=this._layers[i];"custom"!==t.type&&(e[i]=t.serialize());}return e}hasTransitions(){var e,t,i;if(null===(e=this.light)||void 0===e?void 0:e.hasTransition())return !0;if(null===(t=this.sky)||void 0===t?void 0:t.hasTransition())return !0;if(null===(i=this.projection)||void 0===i?void 0:i.hasTransition())return !0;for(const e in this.tileManagers)if(this.tileManagers[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading.")}update(e){if(!this._loaded)return;const i=this._changed;if(i){const t=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(t.length||i.length)&&this._updateWorkerLayers(t,i);for(const e in this._updatedSources){const t=this._updatedSources[e];if("reload"===t)this._reloadSource(e);else {if("clear"!==t)throw new Error(`Invalid action ${t}`);this._clearSource(e);}}this._updateTilesForChangedImages(),this._updateTilesForChangedGlyphs();for(const t in this._updatedPaintProps)this._layers[t].updateTransitions(e);this.light.updateTransitions(e),this.sky.updateTransitions(e),this._resetUpdates();}const a={};for(const e in this.tileManagers){const t=this.tileManagers[e];a[e]=t.used,t.used=!1;}for(const t of this._order){const i=this._layers[t];i.recalculate(e,this._availableImages),!i.isHidden(e.zoom)&&i.source&&(this.tileManagers[i.source].used=!0);}for(const e in a){const i=this.tileManagers[e];!!a[e]!=!!i.used&&i.fire(new t.l("data",{sourceDataType:"visibility",dataType:"source",sourceId:e}));}this.light.recalculate(e),this.sky.recalculate(e),this.projection.recalculate(e),this.z=e.zoom,i&&this.fire(new t.l("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this.tileManagers)this.tileManagers[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={};}}_updateTilesForChangedGlyphs(){if(this._glyphsDidChange){for(const e in this.tileManagers)this.tileManagers[e].reloadTilesForDependencies(["glyphs"],[""]);this._glyphsDidChange=!1;}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("UL",{layers:this._serializeByIds(e,!1),removedIds:t});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={},this._glyphsDidChange=!1;}setState(e,i={}){var a;this._checkLoaded();const r=this.serialize();if(e=i.transformStyle?i.transformStyle(r,e):e,(null===(a=i.validate)||void 0===a||a)&&Ii(this,t.C(e)))return !1;(e=t.bU(e)).layers=t.bR(e.layers);const o=t.bV(r,e),s=this._getOperationsToPerform(o);if(s.unimplemented.length>0)throw new Error(`Unimplemented: ${s.unimplemented.join(", ")}.`);if(0===s.operations.length)return !1;for(const e of s.operations)e();return this.stylesheet=e,this._serializedLayers=null,!0}_getOperationsToPerform(e){const t=[],i=[];for(const a of e)switch(a.command){case "setCenter":case "setZoom":case "setBearing":case "setPitch":case "setRoll":continue;case "addLayer":t.push((()=>this.addLayer.apply(this,a.args)));break;case "removeLayer":t.push((()=>this.removeLayer.apply(this,a.args)));break;case "setPaintProperty":t.push((()=>this.setPaintProperty.apply(this,a.args)));break;case "setLayoutProperty":t.push((()=>this.setLayoutProperty.apply(this,a.args)));break;case "setFilter":t.push((()=>this.setFilter.apply(this,a.args)));break;case "addSource":t.push((()=>this.addSource.apply(this,a.args)));break;case "removeSource":t.push((()=>this.removeSource.apply(this,a.args)));break;case "setLayerZoomRange":t.push((()=>this.setLayerZoomRange.apply(this,a.args)));break;case "setLight":t.push((()=>this.setLight.apply(this,a.args)));break;case "setGeoJSONSourceData":t.push((()=>this.setGeoJSONSourceData.apply(this,a.args)));break;case "setGlyphs":t.push((()=>this.setGlyphs.apply(this,a.args)));break;case "setSprite":t.push((()=>this.setSprite.apply(this,a.args)));break;case "setTerrain":t.push((()=>this.map.setTerrain.apply(this,a.args)));break;case "setSky":t.push((()=>this.setSky.apply(this,a.args)));break;case "setProjection":this.setProjection.apply(this,a.args);break;case "setGlobalState":t.push((()=>this.setGlobalState.apply(this,a.args)));break;case "setTransition":t.push((()=>{}));break;default:i.push(a.command);}return {operations:t,unimplemented:i}}addImage(e,i){if(this.getImage(e))return this.fire(new t.k(new Error(`An image named "${e}" already exists.`)));this.imageManager.addImage(e,i),this._afterImageUpdated(e);}updateImage(e,t){this.imageManager.updateImage(e,t);}getImage(e){return this.imageManager.getImage(e)}removeImage(e){if(!this.getImage(e))return this.fire(new t.k(new Error(`An image named "${e}" does not exist.`)));this.imageManager.removeImage(e),this._afterImageUpdated(e);}_afterImageUpdated(e){this._availableImages=this.imageManager.listImages(),this._changedImages[e]=!0,this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(e,i,a={}){if(this._checkLoaded(),void 0!==this.tileManagers[e])throw new Error(`Source "${e}" already exists.`);if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(t.C.source,`sources.${e}`,i,null,a))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const r=this.tileManagers[e]=new Ie(e,i,this.dispatcher);r.style=this,r.setEventedParent(this,(()=>({isSourceLoaded:r.loaded(),source:r.serialize(),sourceId:e}))),r.onAdd(this.map),this._changed=!0;}removeSource(e){if(this._checkLoaded(),void 0===this.tileManagers[e])throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===e)return this.fire(new t.k(new Error(`Source "${e}" cannot be removed while layer "${i}" is using it.`)));const i=this.tileManagers[e];delete this.tileManagers[e],delete this._updatedSources[e],i.fire(new t.l("data",{sourceDataType:"metadata",dataType:"source",sourceId:e})),i.setEventedParent(null),i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(e,t){if(this._checkLoaded(),void 0===this.tileManagers[e])throw new Error(`There is no source with this ID=${e}`);const i=this.tileManagers[e].getSource();if("geojson"!==i.type)throw new Error(`geojsonSource.type is ${i.type}, which is !== 'geojson`);i.setData(t),this._changed=!0;}getSource(e){return this.tileManagers[e]&&this.tileManagers[e].getSource()}addLayer(e,i,a={}){this._checkLoaded();const r=e.id;if(this.getLayer(r))return void this.fire(new t.k(new Error(`Layer "${r}" already exists on this map.`)));let o;if("custom"===e.type){if(Ii(this,t.bW(e)))return;o=t.bS(e,this._globalState);}else {if("source"in e&&"object"==typeof e.source&&(this.addSource(r,e.source),e=t.bU(e),e=t.e(e,{source:r})),this._validate(t.C.layer,`layers.${r}`,e,{arrayIndex:-1},a))return;o=t.bS(e,this._globalState),this._validateLayer(o),o.setEventedParent(this,{layer:{id:r}});}const s=i?this._order.indexOf(i):this._order.length;if(i&&-1===s)this.fire(new t.k(new Error(`Cannot add layer "${r}" before non-existing layer "${i}".`)));else {if(this._order.splice(s,0,r),this._layerOrderChanged=!0,this._layers[r]=o,this._removedLayers[r]&&o.source&&"custom"!==o.type){const e=this._removedLayers[r];delete this._removedLayers[r],e.type!==o.type?this._updatedSources[o.source]="clear":(this._updatedSources[o.source]="reload",this.tileManagers[o.source].pause());}this._updateLayer(o),o.onAdd&&o.onAdd(this.map);}}moveLayer(e,i){if(this._checkLoaded(),this._changed=!0,!this._layers[e])return void this.fire(new t.k(new Error(`The layer '${e}' does not exist in the map's style and cannot be moved.`)));if(e===i)return;const a=this._order.indexOf(e);this._order.splice(a,1);const r=i?this._order.indexOf(i):this._order.length;i&&-1===r?this.fire(new t.k(new Error(`Cannot move layer "${e}" before non-existing layer "${i}".`))):(this._order.splice(r,0,e),this._layerOrderChanged=!0);}removeLayer(e){this._checkLoaded();const i=this._layers[e];if(!i)return void this.fire(new t.k(new Error(`Cannot remove non-existing layer "${e}".`)));i.setEventedParent(null);const a=this._order.indexOf(e);this._order.splice(a,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[e]=i,delete this._layers[e],this._serializedLayers&&delete this._serializedLayers[e],delete this._updatedLayers[e],delete this._updatedPaintProps[e],i.onRemove&&i.onRemove(this.map);}getLayer(e){return this._layers[e]}getLayersOrder(){return [...this._order]}hasLayer(e){return e in this._layers}setLayerZoomRange(e,i,a){this._checkLoaded();const r=this.getLayer(e);r?r.minzoom===i&&r.maxzoom===a||(null!=i&&(r.minzoom=i),null!=a&&(r.maxzoom=a),this._updateLayer(r)):this.fire(new t.k(new Error(`Cannot set the zoom range of non-existing layer "${e}".`)));}setFilter(e,i,a={}){this._checkLoaded();const r=this.getLayer(e);if(r){if(!t.bQ(r.filter,i))return null==i?(r.setFilter(void 0),void this._updateLayer(r)):void(this._validate(t.C.filter,`layers.${r.id}.filter`,i,null,a)||(r.setFilter(t.bU(i)),this._updateLayer(r)))}else this.fire(new t.k(new Error(`Cannot filter non-existing layer "${e}".`)));}getFilter(e){return t.bU(this.getLayer(e).filter)}setLayoutProperty(e,i,a,r={}){this._checkLoaded();const o=this.getLayer(e);o?t.bQ(o.getLayoutProperty(i),a)||(o.setLayoutProperty(i,a,r),this._updateLayer(o)):this.fire(new t.k(new Error(`Cannot style non-existing layer "${e}".`)));}getLayoutProperty(e,i){const a=this.getLayer(e);if(a)return a.getLayoutProperty(i);this.fire(new t.k(new Error(`Cannot get style of non-existing layer "${e}".`)));}setPaintProperty(e,i,a,r={}){this._checkLoaded();const o=this.getLayer(e);o?t.bQ(o.getPaintProperty(i),a)||this._updatePaintProperty(o,i,a,r):this.fire(new t.k(new Error(`Cannot style non-existing layer "${e}".`)));}_updatePaintProperty(e,i,a,r={}){e.setPaintProperty(i,a,r)&&this._updateLayer(e),t.bT(e)&&"raster-fade-duration"===i&&this.tileManagers[e.source].setRasterFadeDuration(a),this._changed=!0,this._updatedPaintProps[e.id]=!0,this._serializedLayers=null;}getPaintProperty(e,t){return this.getLayer(e).getPaintProperty(t)}setFeatureState(e,i){this._checkLoaded();const a=e.source,r=e.sourceLayer,o=this.tileManagers[a];if(void 0===o)return void this.fire(new t.k(new Error(`The source '${a}' does not exist in the map's style.`)));const s=o.getSource().type;"geojson"===s&&r?this.fire(new t.k(new Error("GeoJSON sources cannot have a sourceLayer parameter."))):"vector"!==s||r?(void 0===e.id&&this.fire(new t.k(new Error("The feature id parameter must be provided."))),o.setFeatureState(r,e.id,i)):this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));}removeFeatureState(e,i){this._checkLoaded();const a=e.source,r=this.tileManagers[a];if(void 0===r)return void this.fire(new t.k(new Error(`The source '${a}' does not exist in the map's style.`)));const o=r.getSource().type,s="vector"===o?e.sourceLayer:void 0;"vector"!==o||s?i&&"string"!=typeof e.id&&"number"!=typeof e.id?this.fire(new t.k(new Error("A feature id is required to remove its specific state property."))):r.removeFeatureState(s,e.id,i):this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));}getFeatureState(e){this._checkLoaded();const i=e.source,a=e.sourceLayer,r=this.tileManagers[i];if(void 0!==r)return "vector"!==r.getSource().type||a?(void 0===e.id&&this.fire(new t.k(new Error("The feature id parameter must be provided."))),r.getFeatureState(a,e.id)):void this.fire(new t.k(new Error("The sourceLayer parameter must be provided for vector source types.")));this.fire(new t.k(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return t.e({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){if(!this._loaded)return;const e=t.bX(this.tileManagers,(e=>e.serialize())),i=this._serializeByIds(this._order,!0),a=this.map.getTerrain()||void 0,r=this.stylesheet;return t.bY({version:r.version,name:r.name,metadata:r.metadata,light:r.light,sky:r.sky,center:r.center,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,sprite:r.sprite,glyphs:r.glyphs,transition:r.transition,projection:r.projection,sources:e,layers:i,terrain:a},(e=>void 0!==e))}_updateLayer(e){this._updatedLayers[e.id]=!0,e.source&&!this._updatedSources[e.source]&&"raster"!==this.tileManagers[e.source].getSource().type&&(this._updatedSources[e.source]="reload",this.tileManagers[e.source].pause()),this._serializedLayers=null,this._changed=!0;}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},a=[];for(let r=this._order.length-1;r>=0;r--){const o=this._order[r];if(t(o)){i[o]=r;for(const t of e){const e=t[o];if(e)for(const t of e)a.push(t);}}}a.sort(((e,t)=>t.intersectionZ-e.intersectionZ));const r=[];for(let o=this._order.length-1;o>=0;o--){const s=this._order[o];if(t(s))for(let e=a.length-1;e>=0;e--){const t=a[e].feature;if(i[t.layer.id]<o)break;r.push(t),a.pop();}else for(const t of e){const e=t[s];if(e)for(const t of e)r.push(t.feature);}}return r}queryRenderedFeatures(e,i,a){i&&i.filter&&this._validate(t.C.filter,"queryRenderedFeatures.filter",i.filter,null,i);const r={};if(i&&i.layers){if(!(Array.isArray(i.layers)||i.layers instanceof Set))return this.fire(new t.k(new Error("parameters.layers must be an Array or a Set of strings"))),[];for(const e of i.layers){const i=this._layers[e];if(!i)return this.fire(new t.k(new Error(`The layer '${e}' does not exist in the map's style and cannot be queried for features.`))),[];r[i.source]=!0;}}const o=[];i.availableImages=this._availableImages;const s=this._serializedAllLayers(),n=i.layers instanceof Set?i.layers:Array.isArray(i.layers)?new Set(i.layers):null,l=Object.assign(Object.assign({},i),{layers:n,globalState:this._globalState});for(const t in this.tileManagers)i.layers&&!r[t]||o.push(U(this.tileManagers[t],this._layers,s,e,l,a,this.map.terrain?(e,t,i)=>this.map.terrain.getElevation(e,t,i):void 0));return this.placement&&o.push(function(e,t,i,a,r,o,s){const n={},l=o.queryRenderedSymbols(a),c=[];for(const e of Object.keys(l).map(Number))c.push(s[e]);c.sort(V);for(const i of c){const a=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,{filterSpec:r.filter,globalState:r.globalState},r.layers,r.availableImages,e);for(const e in a){const t=n[e]=n[e]||[],r=a[e];r.sort(((e,t)=>{const a=i.featureSortOrder;if(a){const i=a.indexOf(e.featureIndex);return a.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex}));for(const e of r)t.push(e);}}return function(e,t,i){for(const a in e)for(const r of e[a])q(r,i[t[a].source]);return e}(n,e,i)}(this._layers,s,this.tileManagers,e,l,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(o)}querySourceFeatures(e,i){(null==i?void 0:i.filter)&&this._validate(t.C.filter,"querySourceFeatures.filter",i.filter,null,i);const a=this.tileManagers[e];return a?function(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),a=[],r={};for(let e=0;e<i.length;e++){const o=i[e],s=o.tileID.canonical.key;r[s]||(r[s]=!0,o.querySourceFeatures(a,t));}return a}(a,i?Object.assign(Object.assign({},i),{globalState:this._globalState}):{globalState:this._globalState}):[]}getLight(){return this.light.getLight()}setLight(e,i={}){this._checkLoaded();const a=this.light.getLight();let r=!1;for(const i in e)if(!t.bQ(e[i],a[i])){r=!0;break}if(!r)return;const o={now:c(),transition:t.e({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(e,i),this.light.updateTransitions(o);}getProjection(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.projection}setProjection(e){if(this._checkLoaded(),this.projection){if(this.projection.name===e.type)return;this.projection.destroy(),delete this.projection;}this.stylesheet.projection=e,this._setProjectionInternal(e.type);}getSky(){var e;return null===(e=this.stylesheet)||void 0===e?void 0:e.sky}setSky(e,i={}){this._checkLoaded();const a=this.getSky();let r=!1;if(!e&&!a)return;if(e&&!a)r=!0;else if(!e&&a)r=!0;else for(const i in e)if(!t.bQ(e[i],a[i])){r=!0;break}if(!r)return;const o={now:c(),transition:t.e({duration:300,delay:0},this.stylesheet.transition)};this.stylesheet.sky=e,this.sky.setSky(e,i),this.sky.updateTransitions(o);}_setProjectionInternal(e){const i=function(e,i){const a={constrainOverride:i};if(Array.isArray(e)){const t=new si({type:e});return {projection:t,transform:new Pi(a),cameraHelper:new Mi(t)}}switch(e){case "mercator":return {projection:new At,transform:new Zt(a),cameraHelper:new qt};case "globe":{const e=new si({type:["interpolate",["linear"],["zoom"],11,"vertical-perspective",12,"mercator"]});return {projection:e,transform:new Pi(a),cameraHelper:new Mi(e)}}case "vertical-perspective":return {projection:new ri,transform:new Ti(a),cameraHelper:new Ci};default:return t.w(`Unknown projection name: ${e}. Falling back to mercator projection.`),{projection:new At,transform:new Zt(a),cameraHelper:new qt}}}(e,this.map.transformConstrain);this.projection=i.projection,this.map.migrateProjection(i.transform,i.cameraHelper);for(const e in this.tileManagers)this.tileManagers[e].reload();}_validate(e,i,a,r,o={}){return (!o||!1!==o.validate)&&Ii(this,e.call(t.C,t.e({key:i,style:this.serialize(),value:a,styleSpec:t.u},r)))}_remove(e=!0){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null),ce().off(se,this._rtlPluginLoaded);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this.tileManagers){const t=this.tileManagers[e];t.setEventedParent(null),t.onRemove(this.map);}this.imageManager.setEventedParent(null),this.setEventedParent(null),e&&this.dispatcher.broadcast("RM",void 0),this.dispatcher.remove(e);}_clearSource(e){this.tileManagers[e].clearTiles();}_reloadSource(e){this.tileManagers[e].resume(),this.tileManagers[e].reload();}_updateSources(e){for(const t in this.tileManagers)this.tileManagers[t].update(e,this.map.terrain);}_generateCollisionBoxes(){for(const e in this.tileManagers)this._reloadSource(e);}_updatePlacement(e,t,i,a,r=!1){let o=!1,s=!1;const n={};for(const t of this._order){const i=this._layers[t];if("symbol"!==i.type)continue;if(!n[i.source]){const e=this.tileManagers[i.source];n[i.source]=e.getRenderableIds(!0).map((t=>e.getTileByID(t))).sort(((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1)));}const a=this.crossTileSymbolIndex.addLayer(i,n[i.source],e.center.lng);o=o||a;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),((r=r||this._layerOrderChanged||0===i)||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(c(),e.zoom))&&(this.pauseablePlacement=new bt(e,this.map.terrain,this._order,r,t,i,a,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,n),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(c()),s=!0),o&&this.pauseablePlacement.placement.setStale()),s||o)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,n[t.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(c())}_releaseSymbolFadeTiles(){for(const e in this.tileManagers)this.tileManagers[e].releaseSymbolFadeTiles();}getImages(e,i){return t._(this,void 0,void 0,(function*(){const e=yield this.imageManager.getImages(i.icons);this._updateTilesForChangedImages();const t=this.tileManagers[i.source];return t&&t.setDependencies(i.tileID.key,i.type,i.icons),e}))}getGlyphs(e,i){return t._(this,void 0,void 0,(function*(){const e=yield this.glyphManager.getGlyphs(i.stacks),t=this.tileManagers[i.source];return t&&t.setDependencies(i.tileID.key,i.type,[""]),e}))}getGlyphsUrl(){return this.stylesheet.glyphs||null}setGlyphs(e,i={}){this._checkLoaded(),e&&this._validate(t.C.glyphs,"glyphs",e,null,i)||(this._glyphsDidChange=!0,this.stylesheet.glyphs=e,this.glyphManager.entries={},this.glyphManager.setURL(e));}getDashes(e,i){return t._(this,void 0,void 0,(function*(){const e={};for(const[t,a]of Object.entries(i.dashes))e[t]=this.lineAtlas.getDash(a.dasharray,a.round);return e}))}addSprite(e,i,a={},r){this._checkLoaded();const o=[{id:e,url:i}],s=[...x(this.stylesheet.sprite),...o];this._validate(t.C.sprite,"sprite",s,null,a)||(this.stylesheet.sprite=s,this._loadSprite(o,!0,r));}removeSprite(e){this._checkLoaded();const i=x(this.stylesheet.sprite);if(i.find((t=>t.id===e))){if(this._spritesImagesIds[e])for(const t of this._spritesImagesIds[e])this.imageManager.removeImage(t),this._changedImages[t]=!0;i.splice(i.findIndex((t=>t.id===e)),1),this.stylesheet.sprite=i.length>0?i:void 0,delete this._spritesImagesIds[e],this._availableImages=this.imageManager.listImages(),this._changed=!0,this.dispatcher.broadcast("SI",this._availableImages),this.fire(new t.l("data",{dataType:"style"}));}else this.fire(new t.k(new Error(`Sprite "${e}" doesn't exists on this map.`)));}getSprite(){return x(this.stylesheet.sprite)}setSprite(e,i={},a){this._checkLoaded(),e&&this._validate(t.C.sprite,"sprite",e,null,i)||(this.stylesheet.sprite=e,e?this._loadSprite(e,!0,a):(this._unloadSprite(),a&&a(null)));}destroy(){this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this._loadStyleRequest&&(this._loadStyleRequest.abort(),this._loadStyleRequest=null),this._spriteRequest&&(this._spriteRequest.abort(),this._spriteRequest=null);for(const e in this.tileManagers){const t=this.tileManagers[e];if(t.setEventedParent(null),t._tiles){for(const e in t._tiles)t._tiles[e].unloadVectorData();t._tiles={};}t._cache.reset(),t.onRemove(this.map);}this.tileManagers={},this.imageManager&&(this.imageManager.setEventedParent(null),this.imageManager.destroy(),this._availableImages=[],this._spritesImagesIds={}),this.glyphManager&&this.glyphManager.destroy();for(const e in this._layers){const t=this._layers[e];t.setEventedParent(null),t.onRemove&&t.onRemove(this.map);}this._setInitialValues(),this.setEventedParent(null),this.dispatcher.unregisterMessageHandler("GG"),this.dispatcher.unregisterMessageHandler("GI"),this.dispatcher.unregisterMessageHandler("GDA"),this.dispatcher.remove(!0),this._listeners={},this._oneTimeListeners={};}}var Ri=t.aT([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class Di{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(e,t,i,a,r,o,s,n,l){this.context=e;let c=this.boundPaintVertexBuffers.length!==a.length;for(let e=0;!c&&e<a.length;e++)this.boundPaintVertexBuffers[e]!==a[e]&&(c=!0);!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||c||this.boundIndexBuffer!==r||this.boundVertexOffset!==o||this.boundDynamicVertexBuffer!==s||this.boundDynamicVertexBuffer2!==n||this.boundDynamicVertexBuffer3!==l?this.freshBind(t,i,a,r,o,s,n,l):(e.bindVertexArray.set(this.vao),s&&s.bind(),r&&r.dynamicDraw&&r.bind(),n&&n.bind(),l&&l.bind());}freshBind(e,t,i,a,r,o,s,n){const l=e.numAttributes,c=this.context,h=c.gl;this.vao&&this.destroy(),this.vao=c.createVertexArray(),c.bindVertexArray.set(this.vao),this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=a,this.boundVertexOffset=r,this.boundDynamicVertexBuffer=o,this.boundDynamicVertexBuffer2=s,this.boundDynamicVertexBuffer3=n,t.enableAttributes(h,e);for(const t of i)t.enableAttributes(h,e);o&&o.enableAttributes(h,e),s&&s.enableAttributes(h,e),n&&n.enableAttributes(h,e),t.bind(),t.setVertexAttribPointers(h,e,r);for(const t of i)t.bind(),t.setVertexAttribPointers(h,e,r);o&&(o.bind(),o.setVertexAttribPointers(h,e,r)),a&&a.bind(),s&&(s.bind(),s.setVertexAttribPointers(h,e,r)),n&&(n.bind(),n.setVertexAttribPointers(h,e,r)),c.currentNumAttributes=l;}destroy(){this.vao&&(this.context.deleteVertexArray(this.vao),this.vao=null);}}const zi=(e,i,a,r,o)=>({u_texture:0,u_ele_delta:e,u_fog_matrix:i,u_fog_color:a?a.properties.get("fog-color"):t.bo.white,u_fog_ground_blend:a?a.properties.get("fog-ground-blend"):1,u_fog_ground_blend_opacity:o?0:a?a.calculateFogBlendOpacity(r):0,u_horizon_color:a?a.properties.get("horizon-color"):t.bo.white,u_horizon_fog_blend:a?a.properties.get("horizon-fog-blend"):1,u_is_globe_mode:o?1:0}),Ai={mainMatrix:"u_projection_matrix",tileMercatorCoords:"u_projection_tile_mercator_coords",clippingPlane:"u_projection_clipping_plane",projectionTransition:"u_projection_transition",fallbackMatrix:"u_projection_fallback_matrix"};function Li(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const a=e[i].split(" ");t.push(a.pop());}return t}class ki{constructor(e,i,a,r,o,s,n,l,c=[]){const h=e.gl;this.program=h.createProgram();const u=Li(i.staticAttributes),d=a?a.getBinderAttributes():[],_=u.concat(d),p=It.prelude.staticUniforms?Li(It.prelude.staticUniforms):[],m=n.staticUniforms?Li(n.staticUniforms):[],f=i.staticUniforms?Li(i.staticUniforms):[],g=a?a.getBinderUniforms():[],v=p.concat(m).concat(f).concat(g),x=[];for(const e of v)x.indexOf(e)<0&&x.push(e);const b=a?a.defines():[];Jt(h)&&b.unshift("#version 300 es"),o&&b.push("#define OVERDRAW_INSPECTOR;"),s&&b.push("#define TERRAIN3D;"),l&&b.push(l),c&&b.push(...c);let y=b.concat(It.prelude.fragmentSource,n.fragmentSource,i.fragmentSource).join("\n"),w=b.concat(It.prelude.vertexSource,n.vertexSource,i.vertexSource).join("\n");Jt(h)||(y=function(e){return e.replace(/\bin\s/g,"varying ").replace("out highp vec4 fragColor;","").replace(/fragColor/g,"gl_FragColor").replace(/texture\(/g,"texture2D(")}(y),w=function(e){return e.replace(/\bin\s/g,"attribute ").replace(/\bout\s/g,"varying ").replace(/texture\(/g,"texture2D(")}(w));const T=h.createShader(h.FRAGMENT_SHADER);if(h.isContextLost())return void(this.failedToCreate=!0);if(h.shaderSource(T,y),h.compileShader(T),!h.getShaderParameter(T,h.COMPILE_STATUS))throw new Error(`Could not compile fragment shader: ${h.getShaderInfoLog(T)}`);h.attachShader(this.program,T);const P=h.createShader(h.VERTEX_SHADER);if(h.isContextLost())return void(this.failedToCreate=!0);if(h.shaderSource(P,w),h.compileShader(P),!h.getShaderParameter(P,h.COMPILE_STATUS))throw new Error(`Could not compile vertex shader: ${h.getShaderInfoLog(P)}`);h.attachShader(this.program,P),this.attributes={};const C={};this.numAttributes=_.length;for(let e=0;e<this.numAttributes;e++)_[e]&&(h.bindAttribLocation(this.program,e,_[e]),this.attributes[_[e]]=e);if(h.linkProgram(this.program),!h.getProgramParameter(this.program,h.LINK_STATUS))throw new Error(`Program failed to link: ${h.getProgramInfoLog(this.program)}`);h.deleteShader(P),h.deleteShader(T);for(let e=0;e<x.length;e++){const t=x[e];if(t&&!C[t]){const e=h.getUniformLocation(this.program,t);e&&(C[t]=e);}}this.fixedUniforms=r(e,C),this.terrainUniforms=((e,i)=>({u_depth:new t.bZ(e,i.u_depth),u_terrain:new t.bZ(e,i.u_terrain),u_terrain_dim:new t.bp(e,i.u_terrain_dim),u_terrain_matrix:new t.b$(e,i.u_terrain_matrix),u_terrain_unpack:new t.c0(e,i.u_terrain_unpack),u_terrain_exaggeration:new t.bp(e,i.u_terrain_exaggeration)}))(e,C),this.projectionUniforms=((e,i)=>({u_projection_matrix:new t.b$(e,i.u_projection_matrix),u_projection_tile_mercator_coords:new t.c0(e,i.u_projection_tile_mercator_coords),u_projection_clipping_plane:new t.c0(e,i.u_projection_clipping_plane),u_projection_transition:new t.bp(e,i.u_projection_transition),u_projection_fallback_matrix:new t.b$(e,i.u_projection_fallback_matrix)}))(e,C),this.binderUniforms=a?a.getUniforms(e,C):[];}draw(e,t,i,a,r,o,s,n,l,c,h,u,d,_,p,m,f,g,v){const x=e.gl;if(this.failedToCreate)return;if(e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(a),e.setColorMode(r),e.setCullFace(o),n){e.activeTexture.set(x.TEXTURE2),x.bindTexture(x.TEXTURE_2D,n.depthTexture),e.activeTexture.set(x.TEXTURE3),x.bindTexture(x.TEXTURE_2D,n.texture);for(const e in this.terrainUniforms)this.terrainUniforms[e].set(n[e]);}if(l)for(const e in l)this.projectionUniforms[Ai[e]].set(l[e]);if(s)for(const e in this.fixedUniforms)this.fixedUniforms[e].set(s[e]);m&&m.setUniforms(e,this.binderUniforms,_,{zoom:p});let b=0;switch(t){case x.LINES:b=2;break;case x.TRIANGLES:b=3;break;case x.LINE_STRIP:b=1;}for(const i of d.get()){const a=i.vaos||(i.vaos={});(a[c]||(a[c]=new Di)).bind(e,this,h,m?m.getPaintVertexBuffers():[],u,i.vertexOffset,f,g,v),x.drawElements(t,i.primitiveLength*b,x.UNSIGNED_SHORT,i.primitiveOffset*b*2);}}}function Fi(e,i,a){const r=1/t.aM(a,1,i.transform.tileZoom),o=Math.pow(2,a.tileID.overscaledZ),s=a.tileSize*Math.pow(2,i.transform.tileZoom)/o,n=s*(a.tileID.canonical.x+a.tileID.wrap*o),l=s*a.tileID.canonical.y;return {u_image:0,u_texsize:a.imageAtlasTexture.size,u_scale:[r,e.fromScale,e.toScale],u_fade:e.t,u_pixel_coord_upper:[n>>16,l>>16],u_pixel_coord_lower:[65535&n,65535&l]}}const Bi=(e,i,a,r)=>{const o=e.style.light,s=o.properties.get("position"),n=[s.x,s.y,s.z],l=t.c3();"viewport"===o.properties.get("anchor")&&t.c4(l,e.transform.bearingInRadians),t.c5(n,n,l);const c=e.transform.transformLightDirection(n),h=o.properties.get("color");return {u_lightpos:n,u_lightpos_globe:c,u_lightintensity:o.properties.get("intensity"),u_lightcolor:[h.r,h.g,h.b],u_vertical_gradient:+i,u_opacity:a,u_fill_translate:r}},Oi=(e,i,a,r,o,s,n)=>t.e(Bi(e,i,a,r),Fi(s,e,n),{u_height_factor:-Math.pow(2,o.overscaledZ)/n.tileSize/8}),ji=(e,i,a,r)=>t.e(Fi(i,e,a),{u_fill_translate:r}),Ni=(e,t)=>({u_world:e,u_fill_translate:t}),Zi=(e,i,a,r,o)=>t.e(ji(e,i,a,o),{u_world:r}),Gi=(e,i,a,r,o)=>{const s=e.transform;let n,l,c=0;if("map"===a.paint.get("circle-pitch-alignment")){const e=t.aM(i,1,s.zoom);n=!0,l=[e,e],c=e/(t.a4*Math.pow(2,i.tileID.overscaledZ))*2*Math.PI*o;}else n=!1,l=s.pixelsToGLUnits;return {u_camera_to_center_distance:s.cameraToCenterDistance,u_scale_with_map:+("map"===a.paint.get("circle-pitch-scale")),u_pitch_with_map:+n,u_device_pixel_ratio:e.pixelRatio,u_extrude_scale:l,u_globe_extrude_scale:c,u_translate:r}},Ui=e=>({u_pixel_extrude_scale:[1/e.width,1/e.height]}),Vi=e=>({u_viewport_size:[e.width,e.height]}),qi=(e,t=1)=>({u_color:e,u_overlay:0,u_overlay_scale:t}),Wi=(e,i,a,r)=>{const o=t.aM(e,1,i)/(t.a4*Math.pow(2,e.tileID.overscaledZ))*2*Math.PI*r;return {u_extrude_scale:t.aM(e,1,i),u_intensity:a,u_globe_extrude_scale:o}},$i=(e,i,a,r)=>{const o=t.N();t.c6(o,0,e.width,e.height,0,0,1);const s=e.context.gl;return {u_matrix:o,u_world:[s.drawingBufferWidth,s.drawingBufferHeight],u_image:a,u_color_ramp:r,u_opacity:i.paint.get("heatmap-opacity")}},Hi=(e,t,i)=>{const a=i.paint.get("hillshade-accent-color");let r;switch(i.paint.get("hillshade-method")){case "basic":r=4;break;case "combined":r=1;break;case "igor":r=2;break;case "multidirectional":r=3;break;default:r=0;}const o=i.getIlluminationProperties();for(let t=0;t<o.directionRadians.length;t++)"viewport"===i.paint.get("hillshade-illumination-anchor")&&(o.directionRadians[t]+=e.transform.bearingInRadians);return {u_image:0,u_latrange:Ki(0,t.tileID),u_exaggeration:i.paint.get("hillshade-exaggeration"),u_altitudes:o.altitudeRadians,u_azimuths:o.directionRadians,u_accent:a,u_method:r,u_highlights:o.highlightColor,u_shadows:o.shadowColor}},Xi=(e,i)=>{const a=i.stride,r=t.N();return t.c6(r,0,t.a4,-t.a4,0,0,1),t.O(r,r,[0,-t.a4,0]),{u_matrix:r,u_image:1,u_dimension:[a,a],u_zoom:e.overscaledZ,u_unpack:i.getUnpackVector()}};function Ki(e,i){const a=Math.pow(2,i.canonical.z),r=i.canonical.y;return [new t.aa(0,r/a).toLngLat().lat,new t.aa(0,(r+1)/a).toLngLat().lat]}const Yi=(e,t,i=0)=>({u_image:0,u_unpack:t.getUnpackVector(),u_dimension:[t.stride,t.stride],u_elevation_stops:1,u_color_stops:4,u_color_ramp_size:i,u_opacity:e.paint.get("color-relief-opacity")}),Qi=(e,i,a,r)=>{const o=e.transform;return {u_translation:ra(e,i,a),u_ratio:r/t.aM(i,1,o.zoom),u_device_pixel_ratio:e.pixelRatio,u_units_to_pixels:[1/o.pixelsToGLUnits[0],1/o.pixelsToGLUnits[1]]}},Ji=(e,i,a,r,o)=>t.e(Qi(e,i,a,r),{u_image:0,u_image_height:o}),ea=(e,i,a,r,o)=>{const s=e.transform,n=aa(i,s);return {u_translation:ra(e,i,a),u_texsize:i.imageAtlasTexture.size,u_ratio:r/t.aM(i,1,s.zoom),u_device_pixel_ratio:e.pixelRatio,u_image:0,u_scale:[n,o.fromScale,o.toScale],u_fade:o.t,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]]}},ta=(e,i,a,r,o)=>{const s=aa(i,e.transform);return t.e(Qi(e,i,a,r),{u_tileratio:s,u_crossfade_from:o.fromScale,u_crossfade_to:o.toScale,u_image:0,u_mix:o.t,u_lineatlas_width:e.lineAtlas.width,u_lineatlas_height:e.lineAtlas.height})},ia=(e,i,a,r,o,s)=>{const n=aa(i,e.transform);return t.e(Qi(e,i,a,r),{u_image:0,u_image_height:s,u_tileratio:n,u_crossfade_from:o.fromScale,u_crossfade_to:o.toScale,u_image_dash:1,u_mix:o.t,u_lineatlas_width:e.lineAtlas.width,u_lineatlas_height:e.lineAtlas.height})};function aa(e,i){return 1/t.aM(e,1,i.tileZoom)}function ra(e,i,a){return t.aN(e.transform,i,a.paint.get("line-translate"),a.paint.get("line-translate-anchor"))}const oa=(e,t,i,a,r)=>{return {u_tl_parent:e,u_scale_parent:t,u_buffer_scale:1,u_fade_t:i.mix,u_opacity:i.opacity*a.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:a.paint.get("raster-brightness-min"),u_brightness_high:a.paint.get("raster-brightness-max"),u_saturation_factor:(s=a.paint.get("raster-saturation"),s>0?1-1/(1.001-s):-s),u_contrast_factor:(o=a.paint.get("raster-contrast"),o>0?1/(1-o):1+o),u_spin_weights:sa(a.paint.get("raster-hue-rotate")),u_coords_top:[r[0].x,r[0].y,r[1].x,r[1].y],u_coords_bottom:[r[3].x,r[3].y,r[2].x,r[2].y]};var o,s;};function sa(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return [(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const na=(e,t,i,a,r,o,s,n,l,c,h,u,d)=>{const _=s.transform;return {u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:_.cameraToCenterDistance,u_pitch:_.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:_.width/_.height,u_fade_change:s.options.fadeDuration?s.symbolFadeChange:1,u_label_plane_matrix:n,u_coord_matrix:l,u_is_text:+h,u_pitch_with_map:+a,u_is_along_line:r,u_is_variable_anchor:o,u_texsize:u,u_texture:0,u_translation:c,u_pitched_scale:d}},la=(e,i,a,r,o,s,n,l,c,h,u,d,_,p)=>{const m=n.transform;return t.e(na(e,i,a,r,o,s,n,l,c,h,u,d,p),{u_gamma_scale:r?Math.cos(m.pitch*Math.PI/180)*m.cameraToCenterDistance:1,u_device_pixel_ratio:n.pixelRatio,u_is_halo:1})},ca=(e,i,a,r,o,s,n,l,c,h,u,d,_)=>t.e(la(e,i,a,r,o,s,n,l,c,h,!0,u,0,_),{u_texsize_icon:d,u_texture_icon:1}),ha=(e,t)=>({u_opacity:e,u_color:t}),ua=(e,i,a,r,o)=>t.e(function(e,i,a,r){const o=a.imageManager.getPattern(e.from.toString()),s=a.imageManager.getPattern(e.to.toString()),{width:n,height:l}=a.imageManager.getPixelSize(),c=Math.pow(2,r.tileID.overscaledZ),h=r.tileSize*Math.pow(2,a.transform.tileZoom)/c,u=h*(r.tileID.canonical.x+r.tileID.wrap*c),d=h*r.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:o.tl,u_pattern_br_a:o.br,u_pattern_tl_b:s.tl,u_pattern_br_b:s.br,u_texsize:[n,l],u_mix:i.t,u_pattern_size_a:o.displaySize,u_pattern_size_b:s.displaySize,u_scale_a:i.fromScale,u_scale_b:i.toScale,u_tile_units_to_pixels:1/t.aM(r,1,a.transform.tileZoom),u_pixel_coord_upper:[u>>16,d>>16],u_pixel_coord_lower:[65535&u,65535&d]}}(a,o,i,r),{u_opacity:e}),da=(e,t)=>{},_a={fillExtrusion:(e,i)=>({u_lightpos:new t.c1(e,i.u_lightpos),u_lightpos_globe:new t.c1(e,i.u_lightpos_globe),u_lightintensity:new t.bp(e,i.u_lightintensity),u_lightcolor:new t.c1(e,i.u_lightcolor),u_vertical_gradient:new t.bp(e,i.u_vertical_gradient),u_opacity:new t.bp(e,i.u_opacity),u_fill_translate:new t.c2(e,i.u_fill_translate)}),fillExtrusionPattern:(e,i)=>({u_lightpos:new t.c1(e,i.u_lightpos),u_lightpos_globe:new t.c1(e,i.u_lightpos_globe),u_lightintensity:new t.bp(e,i.u_lightintensity),u_lightcolor:new t.c1(e,i.u_lightcolor),u_vertical_gradient:new t.bp(e,i.u_vertical_gradient),u_height_factor:new t.bp(e,i.u_height_factor),u_opacity:new t.bp(e,i.u_opacity),u_fill_translate:new t.c2(e,i.u_fill_translate),u_image:new t.bZ(e,i.u_image),u_texsize:new t.c2(e,i.u_texsize),u_pixel_coord_upper:new t.c2(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.c2(e,i.u_pixel_coord_lower),u_scale:new t.c1(e,i.u_scale),u_fade:new t.bp(e,i.u_fade)}),fill:(e,i)=>({u_fill_translate:new t.c2(e,i.u_fill_translate)}),fillPattern:(e,i)=>({u_image:new t.bZ(e,i.u_image),u_texsize:new t.c2(e,i.u_texsize),u_pixel_coord_upper:new t.c2(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.c2(e,i.u_pixel_coord_lower),u_scale:new t.c1(e,i.u_scale),u_fade:new t.bp(e,i.u_fade),u_fill_translate:new t.c2(e,i.u_fill_translate)}),fillOutline:(e,i)=>({u_world:new t.c2(e,i.u_world),u_fill_translate:new t.c2(e,i.u_fill_translate)}),fillOutlinePattern:(e,i)=>({u_world:new t.c2(e,i.u_world),u_image:new t.bZ(e,i.u_image),u_texsize:new t.c2(e,i.u_texsize),u_pixel_coord_upper:new t.c2(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.c2(e,i.u_pixel_coord_lower),u_scale:new t.c1(e,i.u_scale),u_fade:new t.bp(e,i.u_fade),u_fill_translate:new t.c2(e,i.u_fill_translate)}),circle:(e,i)=>({u_camera_to_center_distance:new t.bp(e,i.u_camera_to_center_distance),u_scale_with_map:new t.bZ(e,i.u_scale_with_map),u_pitch_with_map:new t.bZ(e,i.u_pitch_with_map),u_extrude_scale:new t.c2(e,i.u_extrude_scale),u_device_pixel_ratio:new t.bp(e,i.u_device_pixel_ratio),u_globe_extrude_scale:new t.bp(e,i.u_globe_extrude_scale),u_translate:new t.c2(e,i.u_translate)}),collisionBox:(e,i)=>({u_pixel_extrude_scale:new t.c2(e,i.u_pixel_extrude_scale)}),collisionCircle:(e,i)=>({u_viewport_size:new t.c2(e,i.u_viewport_size)}),debug:(e,i)=>({u_color:new t.b_(e,i.u_color),u_overlay:new t.bZ(e,i.u_overlay),u_overlay_scale:new t.bp(e,i.u_overlay_scale)}),depth:da,clippingMask:da,heatmap:(e,i)=>({u_extrude_scale:new t.bp(e,i.u_extrude_scale),u_intensity:new t.bp(e,i.u_intensity),u_globe_extrude_scale:new t.bp(e,i.u_globe_extrude_scale)}),heatmapTexture:(e,i)=>({u_matrix:new t.b$(e,i.u_matrix),u_world:new t.c2(e,i.u_world),u_image:new t.bZ(e,i.u_image),u_color_ramp:new t.bZ(e,i.u_color_ramp),u_opacity:new t.bp(e,i.u_opacity)}),hillshade:(e,i)=>({u_image:new t.bZ(e,i.u_image),u_latrange:new t.c2(e,i.u_latrange),u_exaggeration:new t.bp(e,i.u_exaggeration),u_altitudes:new t.c8(e,i.u_altitudes),u_azimuths:new t.c8(e,i.u_azimuths),u_accent:new t.b_(e,i.u_accent),u_method:new t.bZ(e,i.u_method),u_shadows:new t.c7(e,i.u_shadows),u_highlights:new t.c7(e,i.u_highlights)}),hillshadePrepare:(e,i)=>({u_matrix:new t.b$(e,i.u_matrix),u_image:new t.bZ(e,i.u_image),u_dimension:new t.c2(e,i.u_dimension),u_zoom:new t.bp(e,i.u_zoom),u_unpack:new t.c0(e,i.u_unpack)}),colorRelief:(e,i)=>({u_image:new t.bZ(e,i.u_image),u_unpack:new t.c0(e,i.u_unpack),u_dimension:new t.c2(e,i.u_dimension),u_elevation_stops:new t.bZ(e,i.u_elevation_stops),u_color_stops:new t.bZ(e,i.u_color_stops),u_color_ramp_size:new t.bZ(e,i.u_color_ramp_size),u_opacity:new t.bp(e,i.u_opacity)}),line:(e,i)=>({u_translation:new t.c2(e,i.u_translation),u_ratio:new t.bp(e,i.u_ratio),u_device_pixel_ratio:new t.bp(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.c2(e,i.u_units_to_pixels)}),lineGradient:(e,i)=>({u_translation:new t.c2(e,i.u_translation),u_ratio:new t.bp(e,i.u_ratio),u_device_pixel_ratio:new t.bp(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.c2(e,i.u_units_to_pixels),u_image:new t.bZ(e,i.u_image),u_image_height:new t.bp(e,i.u_image_height)}),linePattern:(e,i)=>({u_translation:new t.c2(e,i.u_translation),u_texsize:new t.c2(e,i.u_texsize),u_ratio:new t.bp(e,i.u_ratio),u_device_pixel_ratio:new t.bp(e,i.u_device_pixel_ratio),u_image:new t.bZ(e,i.u_image),u_units_to_pixels:new t.c2(e,i.u_units_to_pixels),u_scale:new t.c1(e,i.u_scale),u_fade:new t.bp(e,i.u_fade)}),lineSDF:(e,i)=>({u_translation:new t.c2(e,i.u_translation),u_ratio:new t.bp(e,i.u_ratio),u_device_pixel_ratio:new t.bp(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.c2(e,i.u_units_to_pixels),u_image:new t.bZ(e,i.u_image),u_mix:new t.bp(e,i.u_mix),u_tileratio:new t.bp(e,i.u_tileratio),u_crossfade_from:new t.bp(e,i.u_crossfade_from),u_crossfade_to:new t.bp(e,i.u_crossfade_to),u_lineatlas_width:new t.bp(e,i.u_lineatlas_width),u_lineatlas_height:new t.bp(e,i.u_lineatlas_height)}),lineGradientSDF:(e,i)=>({u_translation:new t.c2(e,i.u_translation),u_ratio:new t.bp(e,i.u_ratio),u_device_pixel_ratio:new t.bp(e,i.u_device_pixel_ratio),u_units_to_pixels:new t.c2(e,i.u_units_to_pixels),u_image:new t.bZ(e,i.u_image),u_image_height:new t.bp(e,i.u_image_height),u_tileratio:new t.bp(e,i.u_tileratio),u_crossfade_from:new t.bp(e,i.u_crossfade_from),u_crossfade_to:new t.bp(e,i.u_crossfade_to),u_image_dash:new t.bZ(e,i.u_image_dash),u_mix:new t.bp(e,i.u_mix),u_lineatlas_width:new t.bp(e,i.u_lineatlas_width),u_lineatlas_height:new t.bp(e,i.u_lineatlas_height)}),raster:(e,i)=>({u_tl_parent:new t.c2(e,i.u_tl_parent),u_scale_parent:new t.bp(e,i.u_scale_parent),u_buffer_scale:new t.bp(e,i.u_buffer_scale),u_fade_t:new t.bp(e,i.u_fade_t),u_opacity:new t.bp(e,i.u_opacity),u_image0:new t.bZ(e,i.u_image0),u_image1:new t.bZ(e,i.u_image1),u_brightness_low:new t.bp(e,i.u_brightness_low),u_brightness_high:new t.bp(e,i.u_brightness_high),u_saturation_factor:new t.bp(e,i.u_saturation_factor),u_contrast_factor:new t.bp(e,i.u_contrast_factor),u_spin_weights:new t.c1(e,i.u_spin_weights),u_coords_top:new t.c0(e,i.u_coords_top),u_coords_bottom:new t.c0(e,i.u_coords_bottom)}),symbolIcon:(e,i)=>({u_is_size_zoom_constant:new t.bZ(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bZ(e,i.u_is_size_feature_constant),u_size_t:new t.bp(e,i.u_size_t),u_size:new t.bp(e,i.u_size),u_camera_to_center_distance:new t.bp(e,i.u_camera_to_center_distance),u_pitch:new t.bp(e,i.u_pitch),u_rotate_symbol:new t.bZ(e,i.u_rotate_symbol),u_aspect_ratio:new t.bp(e,i.u_aspect_ratio),u_fade_change:new t.bp(e,i.u_fade_change),u_label_plane_matrix:new t.b$(e,i.u_label_plane_matrix),u_coord_matrix:new t.b$(e,i.u_coord_matrix),u_is_text:new t.bZ(e,i.u_is_text),u_pitch_with_map:new t.bZ(e,i.u_pitch_with_map),u_is_along_line:new t.bZ(e,i.u_is_along_line),u_is_variable_anchor:new t.bZ(e,i.u_is_variable_anchor),u_texsize:new t.c2(e,i.u_texsize),u_texture:new t.bZ(e,i.u_texture),u_translation:new t.c2(e,i.u_translation),u_pitched_scale:new t.bp(e,i.u_pitched_scale)}),symbolSDF:(e,i)=>({u_is_size_zoom_constant:new t.bZ(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bZ(e,i.u_is_size_feature_constant),u_size_t:new t.bp(e,i.u_size_t),u_size:new t.bp(e,i.u_size),u_camera_to_center_distance:new t.bp(e,i.u_camera_to_center_distance),u_pitch:new t.bp(e,i.u_pitch),u_rotate_symbol:new t.bZ(e,i.u_rotate_symbol),u_aspect_ratio:new t.bp(e,i.u_aspect_ratio),u_fade_change:new t.bp(e,i.u_fade_change),u_label_plane_matrix:new t.b$(e,i.u_label_plane_matrix),u_coord_matrix:new t.b$(e,i.u_coord_matrix),u_is_text:new t.bZ(e,i.u_is_text),u_pitch_with_map:new t.bZ(e,i.u_pitch_with_map),u_is_along_line:new t.bZ(e,i.u_is_along_line),u_is_variable_anchor:new t.bZ(e,i.u_is_variable_anchor),u_texsize:new t.c2(e,i.u_texsize),u_texture:new t.bZ(e,i.u_texture),u_gamma_scale:new t.bp(e,i.u_gamma_scale),u_device_pixel_ratio:new t.bp(e,i.u_device_pixel_ratio),u_is_halo:new t.bZ(e,i.u_is_halo),u_translation:new t.c2(e,i.u_translation),u_pitched_scale:new t.bp(e,i.u_pitched_scale)}),symbolTextAndIcon:(e,i)=>({u_is_size_zoom_constant:new t.bZ(e,i.u_is_size_zoom_constant),u_is_size_feature_constant:new t.bZ(e,i.u_is_size_feature_constant),u_size_t:new t.bp(e,i.u_size_t),u_size:new t.bp(e,i.u_size),u_camera_to_center_distance:new t.bp(e,i.u_camera_to_center_distance),u_pitch:new t.bp(e,i.u_pitch),u_rotate_symbol:new t.bZ(e,i.u_rotate_symbol),u_aspect_ratio:new t.bp(e,i.u_aspect_ratio),u_fade_change:new t.bp(e,i.u_fade_change),u_label_plane_matrix:new t.b$(e,i.u_label_plane_matrix),u_coord_matrix:new t.b$(e,i.u_coord_matrix),u_is_text:new t.bZ(e,i.u_is_text),u_pitch_with_map:new t.bZ(e,i.u_pitch_with_map),u_is_along_line:new t.bZ(e,i.u_is_along_line),u_is_variable_anchor:new t.bZ(e,i.u_is_variable_anchor),u_texsize:new t.c2(e,i.u_texsize),u_texsize_icon:new t.c2(e,i.u_texsize_icon),u_texture:new t.bZ(e,i.u_texture),u_texture_icon:new t.bZ(e,i.u_texture_icon),u_gamma_scale:new t.bp(e,i.u_gamma_scale),u_device_pixel_ratio:new t.bp(e,i.u_device_pixel_ratio),u_is_halo:new t.bZ(e,i.u_is_halo),u_translation:new t.c2(e,i.u_translation),u_pitched_scale:new t.bp(e,i.u_pitched_scale)}),background:(e,i)=>({u_opacity:new t.bp(e,i.u_opacity),u_color:new t.b_(e,i.u_color)}),backgroundPattern:(e,i)=>({u_opacity:new t.bp(e,i.u_opacity),u_image:new t.bZ(e,i.u_image),u_pattern_tl_a:new t.c2(e,i.u_pattern_tl_a),u_pattern_br_a:new t.c2(e,i.u_pattern_br_a),u_pattern_tl_b:new t.c2(e,i.u_pattern_tl_b),u_pattern_br_b:new t.c2(e,i.u_pattern_br_b),u_texsize:new t.c2(e,i.u_texsize),u_mix:new t.bp(e,i.u_mix),u_pattern_size_a:new t.c2(e,i.u_pattern_size_a),u_pattern_size_b:new t.c2(e,i.u_pattern_size_b),u_scale_a:new t.bp(e,i.u_scale_a),u_scale_b:new t.bp(e,i.u_scale_b),u_pixel_coord_upper:new t.c2(e,i.u_pixel_coord_upper),u_pixel_coord_lower:new t.c2(e,i.u_pixel_coord_lower),u_tile_units_to_pixels:new t.bp(e,i.u_tile_units_to_pixels)}),terrain:(e,i)=>({u_texture:new t.bZ(e,i.u_texture),u_ele_delta:new t.bp(e,i.u_ele_delta),u_fog_matrix:new t.b$(e,i.u_fog_matrix),u_fog_color:new t.b_(e,i.u_fog_color),u_fog_ground_blend:new t.bp(e,i.u_fog_ground_blend),u_fog_ground_blend_opacity:new t.bp(e,i.u_fog_ground_blend_opacity),u_horizon_color:new t.b_(e,i.u_horizon_color),u_horizon_fog_blend:new t.bp(e,i.u_horizon_fog_blend),u_is_globe_mode:new t.bp(e,i.u_is_globe_mode)}),terrainDepth:(e,i)=>({u_ele_delta:new t.bp(e,i.u_ele_delta)}),terrainCoords:(e,i)=>({u_texture:new t.bZ(e,i.u_texture),u_terrain_coords_id:new t.bp(e,i.u_terrain_coords_id),u_ele_delta:new t.bp(e,i.u_ele_delta)}),projectionErrorMeasurement:(e,i)=>({u_input:new t.bp(e,i.u_input),u_output_expected:new t.bp(e,i.u_output_expected)}),atmosphere:(e,i)=>({u_sun_pos:new t.c1(e,i.u_sun_pos),u_atmosphere_blend:new t.bp(e,i.u_atmosphere_blend),u_globe_position:new t.c1(e,i.u_globe_position),u_globe_radius:new t.bp(e,i.u_globe_radius),u_inv_proj_matrix:new t.b$(e,i.u_inv_proj_matrix)}),sky:(e,i)=>({u_sky_color:new t.b_(e,i.u_sky_color),u_horizon_color:new t.b_(e,i.u_horizon_color),u_horizon:new t.c2(e,i.u_horizon),u_horizon_normal:new t.c2(e,i.u_horizon_normal),u_sky_horizon_blend:new t.bp(e,i.u_sky_horizon_blend),u_sky_blend:new t.bp(e,i.u_sky_blend)})};class pa{constructor(e,t,i){this.context=e;const a=e.gl;this.buffer=a.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),a.bufferData(a.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?a.DYNAMIC_DRAW:a.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(e){const t=this.context.gl;if(!this.dynamicDraw)throw new Error("Attempted to update data while not in dynamic mode.");this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const ma={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class fa{constructor(e,t,i,a){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=a,this.context=e;const r=e.gl;this.buffer=r.createBuffer(),e.bindVertexBuffer.set(this.buffer),r.bufferData(r.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?r.DYNAMIC_DRAW:r.STATIC_DRAW),this.dynamicDraw||delete t.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(e){if(e.length!==this.length)throw new Error(`Length of new data is ${e.length}, which doesn't match current length of ${this.length}`);const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer);}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const a=t.attributes[this.attributes[i].name];void 0!==a&&e.enableVertexAttribArray(a);}}setVertexAttribPointers(e,t,i){for(let a=0;a<this.attributes.length;a++){const r=this.attributes[a],o=t.attributes[r.name];void 0!==o&&e.vertexAttribPointer(o,r.components,e[ma[r.type]],!1,this.itemSize,r.offset+this.itemSize*(i||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class ga{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class va extends ga{getDefault(){return t.bo.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class xa extends ga{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1);}}class ba extends ga{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1);}}class ya extends ga{getDefault(){return [!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class wa extends ga{getDefault(){return !0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1);}}class Ta extends ga{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1);}}class Pa extends ga{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1);}}class Ca extends ga{getDefault(){const e=this.gl;return [e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1);}}class Ma extends ga{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1;}}class Ia extends ga{getDefault(){return [0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1);}}class Ea extends ga{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1;}}class Sa extends ga{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1);}}class Ra extends ga{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1;}}class Da extends ga{getDefault(){const e=this.gl;return [e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.blendFunc(e[0],e[1]),this.current=e,this.dirty=!1);}}class za extends ga{getDefault(){return t.bo.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1);}}class Aa extends ga{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquation(e),this.current=e,this.dirty=!1);}}class La extends ga{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1;}}class ka extends ga{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1);}}class Fa extends ga{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1);}}class Ba extends ga{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1);}}class Oa extends ga{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1);}}class ja extends ga{getDefault(){const e=this.gl;return [0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1);}}class Na extends ga{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1;}}class Za extends ga{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class Ga extends ga{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1;}}class Ua extends ga{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class Va extends ga{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1;}}class qa extends ga{getDefault(){return null}set(e){var t;if(e===this.current&&!this.dirty)return;const i=this.gl;Jt(i)?i.bindVertexArray(e):null===(t=i.getExtension("OES_vertex_array_object"))||void 0===t||t.bindVertexArrayOES(e),this.current=e,this.dirty=!1;}}class Wa extends ga{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1;}}class $a extends ga{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1;}}class Ha extends ga{getDefault(){return !1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1;}}class Xa extends ga{constructor(e,t){super(e),this.context=e,this.parent=t;}getDefault(){return null}}class Ka extends Xa{setDirty(){this.dirty=!0;}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1;}}class Ya extends Xa{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}class Qa extends Xa{set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e),this.current=e,this.dirty=!1;}}const Ja="Framebuffer is not complete";class er{constructor(e,t,i,a,r){this.context=e,this.width=t,this.height=i;const o=e.gl,s=this.framebuffer=o.createFramebuffer();if(this.colorAttachment=new Ka(e,s),a)this.depthAttachment=r?new Qa(e,s):new Ya(e,s);else if(r)throw new Error("Stencil cannot be set without depth");if(o.checkFramebufferStatus(o.FRAMEBUFFER)!==o.FRAMEBUFFER_COMPLETE)throw new Error(Ja)}destroy(){const e=this.context.gl,t=this.colorAttachment.get();if(t&&e.deleteTexture(t),this.depthAttachment){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t);}e.deleteFramebuffer(this.framebuffer);}}class tr{constructor(e){var t,i;if(this.gl=e,this.clearColor=new va(this),this.clearDepth=new xa(this),this.clearStencil=new ba(this),this.colorMask=new ya(this),this.depthMask=new wa(this),this.stencilMask=new Ta(this),this.stencilFunc=new Pa(this),this.stencilOp=new Ca(this),this.stencilTest=new Ma(this),this.depthRange=new Ia(this),this.depthTest=new Ea(this),this.depthFunc=new Sa(this),this.blend=new Ra(this),this.blendFunc=new Da(this),this.blendColor=new za(this),this.blendEquation=new Aa(this),this.cullFace=new La(this),this.cullFaceSide=new ka(this),this.frontFace=new Fa(this),this.program=new Ba(this),this.activeTexture=new Oa(this),this.viewport=new ja(this),this.bindFramebuffer=new Na(this),this.bindRenderbuffer=new Za(this),this.bindTexture=new Ga(this),this.bindVertexBuffer=new Ua(this),this.bindElementBuffer=new Va(this),this.bindVertexArray=new qa(this),this.pixelStoreUnpack=new Wa(this),this.pixelStoreUnpackPremultiplyAlpha=new $a(this),this.pixelStoreUnpackFlipY=new Ha(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE),Jt(e)){this.HALF_FLOAT=e.HALF_FLOAT;const a=e.getExtension("EXT_color_buffer_half_float");this.RGBA16F=null!==(t=e.RGBA16F)&&void 0!==t?t:null==a?void 0:a.RGBA16F_EXT,this.RGB16F=null!==(i=e.RGB16F)&&void 0!==i?i:null==a?void 0:a.RGB16F_EXT,e.getExtension("EXT_color_buffer_float");}else {e.getExtension("EXT_color_buffer_half_float"),e.getExtension("OES_texture_half_float_linear");const t=e.getExtension("OES_texture_half_float");this.HALF_FLOAT=null==t?void 0:t.HALF_FLOAT_OES;}}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArray.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(e,t){return new pa(this,e,t)}createVertexBuffer(e,t,i){return new fa(this,e,t,i)}createRenderbuffer(e,t,i){const a=this.gl,r=a.createRenderbuffer();return this.bindRenderbuffer.set(r),a.renderbufferStorage(a.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),r}createFramebuffer(e,t,i,a){return new er(this,e,t,i,a)}clear({color:e,depth:t,stencil:i}){const a=this.gl;let r=0;e&&(r|=a.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set([!0,!0,!0,!0])),void 0!==t&&(r|=a.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(r|=a.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),a.clear(r);}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace));}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1);}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1);}setColorMode(e){t.bQ(e.blendFunction,Wt.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor)),this.colorMask.set(e.mask);}createVertexArray(){var e;return Jt(this.gl)?this.gl.createVertexArray():null===(e=this.gl.getExtension("OES_vertex_array_object"))||void 0===e?void 0:e.createVertexArrayOES()}deleteVertexArray(e){var t;return Jt(this.gl)?this.gl.deleteVertexArray(e):null===(t=this.gl.getExtension("OES_vertex_array_object"))||void 0===t?void 0:t.deleteVertexArrayOES(e)}unbindVAO(){this.bindVertexArray.set(null);}}let ir;function ar(e,i,a,r,o){const s=e.context,n=e.transform,l=s.gl,c=e.useProgram("collisionBox"),h=[];let u=0,d=0;for(let t=0;t<r.length;t++){const _=r[t],p=i.getTile(_).getBucket(a);if(!p)continue;const m=o?p.textCollisionBox:p.iconCollisionBox,f=p.collisionCircleArray;f.length>0&&(h.push({circleArray:f,circleOffset:d,coord:_}),u+=f.length/4,d=u),m&&c.draw(s,l.LINES,Xt.disabled,Yt.disabled,e.colorModeForRenderPass(),Ht.disabled,Ui(e.transform),e.style.map.terrain&&e.style.map.terrain.getTerrainData(_),n.getProjectionData({overscaledTileID:_,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),a.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,null,e.transform.zoom,null,null,m.collisionVertexBuffer);}if(!o||!h.length)return;const _=e.useProgram("collisionCircle"),p=new t.c9;p.resize(4*u),p._trim();let m=0;for(const e of h)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,a=e.circleArray[i+0],r=e.circleArray[i+1],o=e.circleArray[i+2],s=e.circleArray[i+3];p.emplace(m++,a,r,o,s,0),p.emplace(m++,a,r,o,s,1),p.emplace(m++,a,r,o,s,2),p.emplace(m++,a,r,o,s,3);}(!ir||ir.length<2*u)&&(ir=function(e){const i=2*e,a=new t.cb;a.resize(i),a._trim();for(let e=0;e<i;e++){const t=6*e;a.uint16[t+0]=4*e+0,a.uint16[t+1]=4*e+1,a.uint16[t+2]=4*e+2,a.uint16[t+3]=4*e+2,a.uint16[t+4]=4*e+3,a.uint16[t+5]=4*e+0;}return a}(u));const f=s.createIndexBuffer(ir,!0),g=s.createVertexBuffer(p,t.ca.members,!0);for(const i of h){const r=Vi(e.transform);_.draw(s,l.TRIANGLES,Xt.disabled,Yt.disabled,e.colorModeForRenderPass(),Ht.disabled,r,e.style.map.terrain&&e.style.map.terrain.getTerrainData(i.coord),null,a.id,g,f,t.aW.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,e.transform.zoom,null,null,null);}g.destroy(),f.destroy();}const rr=t.ar(new Float32Array(16));function or(e,i,a,r,o,s){const{horizontalAlign:n,verticalAlign:l}=t.aR(e);return new t.P((-(n-.5)*i/o+r[0])*s,(-(l-.5)*a/o+r[1])*s)}function sr(e,i,a,r,o,s){const n=i.tileAnchorPoint.add(new t.P(i.translation[0],i.translation[1]));if(i.pitchWithMap){let e=r.mult(s);a||(e=e.rotate(-o));const t=n.add(e);return Fe(t.x,t.y,i.pitchedLabelPlaneMatrix,i.getElevation).point}if(a){const t=qe(i.tileAnchorPoint.x+1,i.tileAnchorPoint.y,i).point.sub(e),a=Math.atan(t.y/t.x)+(t.x<0?Math.PI:0);return e.add(r.rotate(a))}return e.add(r)}function nr(e,i,a,r,o,s,n,l,c,h,u,d){const _=e.text.placedSymbolArray,p=e.text.dynamicLayoutVertexArray,m=e.icon.dynamicLayoutVertexArray,f={};p.clear();for(let m=0;m<_.length;m++){const g=_.get(m),v=g.hidden||!g.crossTileID||e.allowVerticalPlacement&&!g.placedOrientation?null:r[g.crossTileID];if(v){const r=new t.P(g.anchorX,g.anchorY),_={getElevation:d,width:o.width,height:o.height,pitchedLabelPlaneMatrix:s,pitchWithMap:a,transform:o,tileAnchorPoint:r,translation:h,unwrappedTileID:u},m=a?$e(r.x,r.y,_):qe(r.x,r.y,_),x=Be(o.cameraToCenterDistance,m.signedDistanceFromCamera);let b=t.az(e.textSizeData,l,g)*x/t.aL;a&&(b*=e.tilePixelRatio/n);const{width:y,height:w,anchor:T,textOffset:P,textBoxScale:C}=v,M=or(T,y,w,P,C,b),I=o.getPitchedTextCorrection(r.x+h[0],r.y+h[1],u),E=sr(m.point,_,i,M,-o.bearingInRadians,I),S=e.allowVerticalPlacement&&g.placedOrientation===t.ay.vertical?Math.PI/2:0;for(let e=0;e<g.numGlyphs;e++)t.aF(p,E,S);c&&g.associatedIconIndex>=0&&(f[g.associatedIconIndex]={shiftedAnchor:E,angle:S});}else Qe(g.numGlyphs,p);}if(c){m.clear();const i=e.icon.placedSymbolArray;for(let e=0;e<i.length;e++){const a=i.get(e);if(a.hidden)Qe(a.numGlyphs,m);else {const i=f[e];if(i)for(let e=0;e<a.numGlyphs;e++)t.aF(m,i.shiftedAnchor,i.angle);else Qe(a.numGlyphs,m);}}e.icon.dynamicLayoutVertexBuffer.updateData(m);}e.text.dynamicLayoutVertexBuffer.updateData(p);}function lr(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function cr(e,i,a,r,o,s,n,l,c,h,u,d,_){const p=e.context,m=p.gl,f=e.transform,g="map"===l,v="map"===c,x="viewport"!==l&&"point"!==a.layout.get("symbol-placement"),b=g&&!v&&!x,y=!a.layout.get("symbol-sort-key").isConstant();let w=!1;const T=e.getDepthModeForSublayer(0,Xt.ReadOnly),P=a._unevaluatedLayout.hasValue("text-variable-anchor")||a._unevaluatedLayout.hasValue("text-variable-anchor-offset"),C=[],M=f.getCircleRadiusCorrection();for(const l of r){const r=i.getTile(l),c=r.getBucket(a);if(!c)continue;const u=o?c.text:c.icon;if(!u||!u.segments.get().length||!u.hasVisibleVertices)continue;const d=u.programConfigurations.get(a.id),p=o||c.sdfIcons,T=o?c.textSizeData:c.iconSizeData,I=v||0!==f.pitch,E=e.useProgram(lr(p,o,c),d),S=t.ax(T,f.zoom),R=e.style.map.terrain&&e.style.map.terrain.getTerrainData(l);let D,z,A,L,k=[0,0],F=null;if(o)z=r.glyphAtlasTexture,A=m.LINEAR,D=r.glyphAtlasTexture.size,c.iconsInText&&(k=r.imageAtlasTexture.size,F=r.imageAtlasTexture,L=I||e.options.rotating||e.options.zooming||"composite"===T.kind||"camera"===T.kind?m.LINEAR:m.NEAREST);else {const t=1!==a.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;z=r.imageAtlasTexture,A=p||e.options.rotating||e.options.zooming||t||I?m.LINEAR:m.NEAREST,D=r.imageAtlasTexture.size;}const B=t.aM(r,1,e.transform.zoom),O=Ae(g,e.transform,B),j=t.N();t.aA(j,O);const N=Le(v,g,e.transform,B),Z=t.aN(f,r,s,n),G=f.getProjectionData({overscaledTileID:l,applyGlobeMatrix:!_,applyTerrainMatrix:!0}),U=P&&c.hasTextData(),V="none"!==a.layout.get("icon-text-fit")&&U&&c.hasIconData();if(x){const t=e.style.map.terrain?(t,i)=>e.style.map.terrain.getElevation(l,t,i):null,i="map"===a.layout.get("text-rotation-alignment");je(c,e,o,O,j,v,h,i,l.toUnwrapped(),f.width,f.height,Z,t);}const q=o&&P||V,W=x||q?rr:v?O:e.transform.clipSpaceToPixelsMatrix,$=p&&0!==a.paint.get(o?"text-halo-width":"icon-halo-width").constantOr(1);let H;H=p?c.iconsInText?ca(T.kind,S,b,v,x,q,e,W,N,Z,D,k,M):la(T.kind,S,b,v,x,q,e,W,N,Z,o,D,0,M):na(T.kind,S,b,v,x,q,e,W,N,Z,o,D,M);const X={program:E,buffers:u,uniformValues:H,projectionData:G,atlasTexture:z,atlasTextureIcon:F,atlasInterpolation:A,atlasInterpolationIcon:L,isSDF:p,hasHalo:$};if(y&&c.canOverlap){w=!0;const e=u.segments.get();for(const i of e)C.push({segments:new t.aW([i]),sortKey:i.sortKey,state:X,terrainData:R});}else C.push({segments:u.segments,sortKey:0,state:X,terrainData:R});}w&&C.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of C){const i=t.state;if(p.activeTexture.set(m.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,m.CLAMP_TO_EDGE),i.atlasTextureIcon&&(p.activeTexture.set(m.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,m.CLAMP_TO_EDGE)),i.isSDF){const r=i.uniformValues;i.hasHalo&&(r.u_is_halo=1,hr(i.buffers,t.segments,a,e,i.program,T,u,d,r,i.projectionData,t.terrainData)),r.u_is_halo=0;}hr(i.buffers,t.segments,a,e,i.program,T,u,d,i.uniformValues,i.projectionData,t.terrainData);}}function hr(e,t,i,a,r,o,s,n,l,c,h){const u=a.context;r.draw(u,u.gl.TRIANGLES,o,s,n,Ht.backCCW,l,h,c,i.id,e.layoutVertexBuffer,e.indexBuffer,t,i.paint,a.transform.zoom,e.programConfigurations.get(i.id),e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer);}function ur(e,i,a,r,o){const s=e.context,n=s.gl,l=Yt.disabled,c=new Wt([n.ONE,n.ONE],t.bo.transparent,[!0,!0,!0,!0]),h=i.getBucket(a);if(!h)return;const u=r.key;let d=a.heatmapFbos.get(u);d||(d=_r(s,i.tileSize,i.tileSize),a.heatmapFbos.set(u,d)),s.bindFramebuffer.set(d.framebuffer),s.viewport.set([0,0,i.tileSize,i.tileSize]),s.clear({color:t.bo.transparent});const _=h.programConfigurations.get(a.id),p=e.useProgram("heatmap",_,!o),m=e.transform.getProjectionData({overscaledTileID:i.tileID,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),f=e.style.map.terrain.getTerrainData(r);p.draw(s,n.TRIANGLES,Xt.disabled,l,c,Ht.disabled,Wi(i,e.transform.zoom,a.paint.get("heatmap-intensity"),1),f,m,a.id,h.layoutVertexBuffer,h.indexBuffer,h.segments,a.paint,e.transform.zoom,_);}function dr(e,t,i,a,r){const o=e.context,s=o.gl,n=e.transform;o.setColorMode(e.colorModeForRenderPass());const l=pr(o,t),c=i.key,h=t.heatmapFbos.get(c);if(!h)return;o.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,h.colorAttachment.get()),o.activeTexture.set(s.TEXTURE1),l.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=n.getProjectionData({overscaledTileID:i,applyTerrainMatrix:r,applyGlobeMatrix:!a});e.useProgram("heatmapTexture").draw(o,s.TRIANGLES,Xt.disabled,Yt.disabled,e.colorModeForRenderPass(),Ht.disabled,$i(e,t,0,1),null,u,t.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments,t.paint,n.zoom),h.destroy(),t.heatmapFbos.delete(c);}function _r(e,t,i){var a,r;const o=e.gl,s=o.createTexture();o.bindTexture(o.TEXTURE_2D,s),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,o.LINEAR),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,o.LINEAR);const n=null!==(a=e.HALF_FLOAT)&&void 0!==a?a:o.UNSIGNED_BYTE,l=null!==(r=e.RGBA16F)&&void 0!==r?r:o.RGBA;o.texImage2D(o.TEXTURE_2D,0,l,t,i,0,o.RGBA,n,null);const c=e.createFramebuffer(t,i,!1,!1);return c.colorAttachment.set(s),c}function pr(e,i){return i.colorRampTexture||(i.colorRampTexture=new t.T(e,i.colorRamp,e.gl.RGBA)),i.colorRampTexture}function mr(e,i,a,r,o,s,n,l){let c=256;if(o.stepInterpolant){const r=i.getSource().maxzoom,o=n.canonical.z===r?Math.ceil(1<<e.transform.maxZoom-n.canonical.z):1;c=t.an(t.cd(s.maxLineLength/t.a4*1024*o),256,a.maxTextureSize);}return l.gradient=t.ce({expression:o.gradientExpression(),evaluationKey:"lineProgress",resolution:c,image:l.gradient||void 0,clips:s.lineClipsArray}),l.texture?l.texture.update(l.gradient):l.texture=new t.T(a,l.gradient,r.RGBA),l.version=o.gradientVersion,l.texture}function fr(e,t,i,a,r){e.activeTexture.set(t.TEXTURE0),i.imageAtlasTexture.bind(t.LINEAR,t.CLAMP_TO_EDGE),a.updatePaintBuffers(r);}function gr(e,t,i,a,r,o){(r||e.lineAtlas.dirty)&&(t.activeTexture.set(i.TEXTURE0),e.lineAtlas.bind(t)),a.updatePaintBuffers(o);}function vr(e,t,i,a,r,o,s){const n=o.gradients[r.id];let l=n.texture;r.gradientVersion!==n.version&&(l=mr(e,t,i,a,r,o,s,n)),i.activeTexture.set(a.TEXTURE0),l.bind(r.stepInterpolant?a.NEAREST:a.LINEAR,a.CLAMP_TO_EDGE);}function xr(e,t,i,a,r,o,s,n,l){const c=o.gradients[r.id];let h=c.texture;r.gradientVersion!==c.version&&(h=mr(e,t,i,a,r,o,s,c)),i.activeTexture.set(a.TEXTURE0),h.bind(r.stepInterpolant?a.NEAREST:a.LINEAR,a.CLAMP_TO_EDGE),i.activeTexture.set(a.TEXTURE1),e.lineAtlas.bind(i),n.updatePaintBuffers(l);}function br(e,t,i,a,r){if(!i||!a||!a.imageAtlas)return;const o=a.imageAtlas.patternPositions;let s=o[i.to.toString()],n=o[i.from.toString()];if(!s&&n&&(s=n),!n&&s&&(n=s),!s||!n){const e=r.getPaintProperty(t);s=o[e],n=o[e];}s&&n&&e.setConstantPatternPositions(s,n);}function yr(e,i,a,r,o,s,n,l){const c=e.context.gl,h="fill-pattern",u=a.paint.get(h),d=u&&u.constantOr(1),_=a.getCrossfadeParameters();let p,m,f,g,v;const x=e.transform,b=a.paint.get("fill-translate"),y=a.paint.get("fill-translate-anchor");n?(m=d&&!a.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",p=c.LINES):(m=d?"fillPattern":"fill",p=c.TRIANGLES);const w=u.constantOr(null);for(const u of r){const r=i.getTile(u);if(d&&!r.patternsLoaded())continue;const T=r.getBucket(a);if(!T)continue;const P=T.programConfigurations.get(a.id),C=e.useProgram(m,P),M=e.style.map.terrain&&e.style.map.terrain.getTerrainData(u);d&&(e.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),P.updatePaintBuffers(_)),br(P,h,w,r,a);const I=x.getProjectionData({overscaledTileID:u,applyGlobeMatrix:!l,applyTerrainMatrix:!0}),E=t.aN(x,r,b,y);if(n){g=T.indexBuffer2,v=T.segments2;const t=[c.drawingBufferWidth,c.drawingBufferHeight];f="fillOutlinePattern"===m&&d?Zi(e,_,r,t,E):Ni(t,E);}else g=T.indexBuffer,v=T.segments,f=d?ji(e,_,r,E):{u_fill_translate:E};const S=e.stencilModeForClipping(u);C.draw(e.context,p,o,S,s,Ht.backCCW,f,M,I,a.id,T.layoutVertexBuffer,g,v,a.paint,e.transform.zoom,P);}}function wr(e,i,a,r,o,s,n,l){const c=e.context,h=c.gl,u="fill-extrusion-pattern",d=a.paint.get(u),_=d.constantOr(1),p=a.getCrossfadeParameters(),m=a.paint.get("fill-extrusion-opacity"),f=d.constantOr(null),g=e.transform;for(const d of r){const r=i.getTile(d),v=r.getBucket(a);if(!v)continue;const x=e.style.map.terrain&&e.style.map.terrain.getTerrainData(d),b=v.programConfigurations.get(a.id),y=e.useProgram(_?"fillExtrusionPattern":"fillExtrusion",b);_&&(e.context.activeTexture.set(h.TEXTURE0),r.imageAtlasTexture.bind(h.LINEAR,h.CLAMP_TO_EDGE),b.updatePaintBuffers(p));const w=g.getProjectionData({overscaledTileID:d,applyGlobeMatrix:!l,applyTerrainMatrix:!0});br(b,u,f,r,a);const T=t.aN(g,r,a.paint.get("fill-extrusion-translate"),a.paint.get("fill-extrusion-translate-anchor")),P=a.paint.get("fill-extrusion-vertical-gradient"),C=_?Oi(e,P,m,T,d,p,r):Bi(e,P,m,T);y.draw(c,c.gl.TRIANGLES,o,s,n,Ht.backCCW,C,x,w,a.id,v.layoutVertexBuffer,v.indexBuffer,v.segments,a.paint,e.transform.zoom,b,e.style.map.terrain&&v.centroidVertexBuffer);}}function Tr(e,t,i,a,r,o,s,n,l){var c;const h=e.style.projection,u=e.context,d=e.transform,_=u.gl,p=[`#define NUM_ILLUMINATION_SOURCES ${i.paint.get("hillshade-highlight-color").values.length}`],m=e.useProgram("hillshade",null,!1,p),f=!e.options.moving;for(const p of a){const a=t.getTile(p),g=a.fbo;if(!g)continue;const v=h.getMeshFromTileID(u,p.canonical,n,!0,"raster"),x=null===(c=e.style.map.terrain)||void 0===c?void 0:c.getTerrainData(p);u.activeTexture.set(_.TEXTURE0),_.bindTexture(_.TEXTURE_2D,g.colorAttachment.get());const b=d.getProjectionData({overscaledTileID:p,aligned:f,applyGlobeMatrix:!l,applyTerrainMatrix:!0});m.draw(u,_.TRIANGLES,o,r[p.overscaledZ],s,Ht.backCCW,Hi(e,a,i),x,b,i.id,v.vertexBuffer,v.indexBuffer,v.segments);}}function Pr(e,i,a,r,o,s,n,l,c){var h;const u=e.style.projection,d=e.context,_=e.transform,p=d.gl,m=e.useProgram("colorRelief"),f=!e.options.moving;let g=!0,v=0;for(const x of r){const r=i.getTile(x),b=r.dem;if(g){const e=p.getParameter(p.MAX_TEXTURE_SIZE),{elevationTexture:t,colorTexture:i}=a.getColorRampTextures(d,e,b.getUnpackVector());d.activeTexture.set(p.TEXTURE1),t.bind(p.NEAREST,p.CLAMP_TO_EDGE),d.activeTexture.set(p.TEXTURE4),i.bind(p.LINEAR,p.CLAMP_TO_EDGE),g=!1,v=t.size[0];}if(!b||!b.data)continue;const y=b.stride,w=b.getPixels();if(d.activeTexture.set(p.TEXTURE0),d.pixelStoreUnpackPremultiplyAlpha.set(!1),r.demTexture=r.demTexture||e.getTileTexture(y),r.demTexture){const e=r.demTexture;e.update(w,{premultiply:!1}),e.bind(p.LINEAR,p.CLAMP_TO_EDGE);}else r.demTexture=new t.T(d,w,p.RGBA,{premultiply:!1}),r.demTexture.bind(p.LINEAR,p.CLAMP_TO_EDGE);const T=u.getMeshFromTileID(d,x.canonical,l,!0,"raster"),P=null===(h=e.style.map.terrain)||void 0===h?void 0:h.getTerrainData(x),C=_.getProjectionData({overscaledTileID:x,aligned:f,applyGlobeMatrix:!c,applyTerrainMatrix:!0});m.draw(d,p.TRIANGLES,s,o[x.overscaledZ],n,Ht.backCCW,Yi(a,r.dem,v),P,C,a.id,T.vertexBuffer,T.indexBuffer,T.segments);}}const Cr=[new t.P(0,0),new t.P(t.a4,0),new t.P(t.a4,t.a4),new t.P(0,t.a4)];function Mr(e,t,i,a,r,o,s,n,l=!1,c=!1){const h=a[a.length-1].overscaledZ,u=e.context,d=u.gl,_=e.useProgram("raster"),p=e.transform,m=e.style.projection,f=e.colorModeForRenderPass(),g=!e.options.moving,v=i.paint.get("raster-opacity"),x=i.paint.get("raster-resampling"),b=i.paint.get("raster-fade-duration"),y=!!e.style.map.terrain;for(const w of a){const a=e.getDepthModeForSublayer(w.overscaledZ-h,1===v?Xt.ReadWrite:Xt.ReadOnly,d.LESS),T=t.getTile(w),P="nearest"===x?d.NEAREST:d.LINEAR;u.activeTexture.set(d.TEXTURE0),T.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),u.activeTexture.set(d.TEXTURE1);const{parentTile:C,parentScaleBy:M,parentTopLeft:I,fadeValues:E}=Ir(T,t,b,y);T.fadeOpacity=E.tileOpacity,C?(C.fadeOpacity=E.parentTileOpacity,C.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST)):T.texture.bind(P,d.CLAMP_TO_EDGE,d.LINEAR_MIPMAP_NEAREST),T.texture.useMipmap&&u.extTextureFilterAnisotropic&&e.transform.pitch>20&&d.texParameterf(d.TEXTURE_2D,u.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,u.extTextureFilterAnisotropicMax);const S=e.style.map.terrain&&e.style.map.terrain.getTerrainData(w),R=p.getProjectionData({overscaledTileID:w,aligned:g,applyGlobeMatrix:!c,applyTerrainMatrix:!0}),D=oa(I,M,E.fadeMix,i,n),z=m.getMeshFromTileID(u,w.canonical,o,s,"raster");_.draw(u,d.TRIANGLES,a,r?r[w.overscaledZ]:Yt.disabled,f,l?Ht.frontCCW:Ht.backCCW,D,S,R,i.id,z.vertexBuffer,z.indexBuffer,z.segments);}}function Ir(e,i,a,r){const o={parentTile:null,parentScaleBy:1,parentTopLeft:[0,0],fadeValues:{tileOpacity:1,parentTileOpacity:1,fadeMix:{opacity:1,mix:0}}};if(0===a||r)return o;if(e.fadingParentID){const r=i.getLoadedTile(e.fadingParentID);if(!r)return o;const s=Math.pow(2,r.tileID.overscaledZ-e.tileID.overscaledZ),n=[e.tileID.canonical.x*s%1,e.tileID.canonical.y*s%1],l=function(e,i,a){const r=c(),o=(r-i.timeAdded)/a,s=e.fadingDirection===ue.Incoming,n=t.an((r-e.timeAdded)/a,0,1),l=t.an(1-o,0,1),h=s?n:l;return {tileOpacity:h,parentTileOpacity:s?l:n,fadeMix:{opacity:1,mix:1-h}}}(e,r,a);return {parentTile:r,parentScaleBy:s,parentTopLeft:n,fadeValues:l}}if(e.selfFading){const i=function(e,i){const a=(c()-e.timeAdded)/i,r=t.an(a,0,1);return {tileOpacity:r,fadeMix:{opacity:r,mix:0}}}(e,a);return {parentTile:null,parentScaleBy:1,parentTopLeft:[0,0],fadeValues:i}}return o}const Er=new t.bo(1,0,0,1),Sr=new t.bo(0,1,0,1),Rr=new t.bo(0,0,1,1),Dr=new t.bo(1,0,1,1),zr=new t.bo(0,1,1,1);function Ar(e,t,i,a){kr(e,0,t+i/2,e.transform.width,i,a);}function Lr(e,t,i,a){kr(e,t-i/2,0,i,e.transform.height,a);}function kr(e,t,i,a,r,o){const s=e.context,n=s.gl;n.enable(n.SCISSOR_TEST),n.scissor(t*e.pixelRatio,i*e.pixelRatio,a*e.pixelRatio,r*e.pixelRatio),s.clear({color:o}),n.disable(n.SCISSOR_TEST);}function Fr(e,i,a){const r=e.context,o=r.gl,s=e.useProgram("debug"),n=Xt.disabled,l=Yt.disabled,c=e.colorModeForRenderPass(),h="$debug",u=e.style.map.terrain&&e.style.map.terrain.getTerrainData(a);r.activeTexture.set(o.TEXTURE0);const d=i.getTileByID(a.key).latestRawTileData,_=Math.floor((d&&d.byteLength||0)/1024),p=i.getTile(a).tileSize,m=512/Math.min(p,512)*(a.overscaledZ/e.transform.zoom)*.5;let f=a.canonical.toString();a.overscaledZ!==a.canonical.z&&(f+=` => ${a.overscaledZ}`),function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,a=e.context.gl,r=e.debugOverlayCanvas.getContext("2d");r.clearRect(0,0,i.width,i.height),r.shadowColor="white",r.shadowBlur=2,r.lineWidth=1.5,r.strokeStyle="white",r.textBaseline="top",r.font="bold 36px Open Sans, sans-serif",r.fillText(t,5,5),r.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(a.LINEAR,a.CLAMP_TO_EDGE);}(e,`${f} ${_}kB`);const g=e.transform.getProjectionData({overscaledTileID:a,applyGlobeMatrix:!0,applyTerrainMatrix:!0});s.draw(r,o.TRIANGLES,n,l,Wt.alphaBlended,Ht.disabled,qi(t.bo.transparent,m),null,g,h,e.debugBuffer,e.quadTriangleIndexBuffer,e.debugSegments),s.draw(r,o.LINE_STRIP,n,l,c,Ht.disabled,qi(t.bo.red),u,g,h,e.debugBuffer,e.tileBorderIndexBuffer,e.debugSegments);}function Br(e,t,i,a){const{isRenderingGlobe:r}=a,o=e.context,s=o.gl,n=e.transform,l=e.colorModeForRenderPass(),c=e.getDepthModeFor3D(),h=e.useProgram("terrain");o.bindFramebuffer.set(null),o.viewport.set([0,0,e.width,e.height]);for(const a of i){const i=t.getTerrainMesh(a.tileID),u=e.renderToTexture.getTexture(a),d=t.getTerrainData(a.tileID);o.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,u.texture);const _=t.getMeshFrameDelta(n.zoom),p=n.calculateFogMatrix(a.tileID.toUnwrapped()),m=zi(_,p,e.style.sky,n.pitch,r),f=n.getProjectionData({overscaledTileID:a.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(o,s.TRIANGLES,c,Yt.disabled,l,Ht.backCCW,m,d,f,"terrain",i.vertexBuffer,i.indexBuffer,i.segments);}}function Or(e,i){if(!i.mesh){const a=new t.aV;a.emplaceBack(-1,-1),a.emplaceBack(1,-1),a.emplaceBack(1,1),a.emplaceBack(-1,1);const r=new t.aX;r.emplaceBack(0,1,2),r.emplaceBack(0,2,3),i.mesh=new St(e.createVertexBuffer(a,Rt.members),e.createIndexBuffer(r),t.aW.simpleSegment(0,0,a.length,r.length));}return i.mesh}class jr{constructor(e,i){this.context=new tr(e),this.transform=i,this._tileTextures={},this.terrainFacilitator={dirty:!0,matrix:t.ar(new Float64Array(16)),renderTime:0},this.setup(),this.numSublayers=Ie.maxOverzooming+Ie.maxUnderzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new Ct;}resize(e,t,i){if(this.width=Math.floor(e*i),this.height=Math.floor(t*i),this.pixelRatio=i,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style._order)this.style._layers[e].resize();}setup(){const e=this.context,i=new t.aV;i.emplaceBack(0,0),i.emplaceBack(t.a4,0),i.emplaceBack(0,t.a4),i.emplaceBack(t.a4,t.a4),this.tileExtentBuffer=e.createVertexBuffer(i,Rt.members),this.tileExtentSegments=t.aW.simpleSegment(0,0,4,2);const a=new t.aV;a.emplaceBack(0,0),a.emplaceBack(t.a4,0),a.emplaceBack(0,t.a4),a.emplaceBack(t.a4,t.a4),this.debugBuffer=e.createVertexBuffer(a,Rt.members),this.debugSegments=t.aW.simpleSegment(0,0,4,5);const r=new t.cg;r.emplaceBack(0,0,0,0),r.emplaceBack(t.a4,0,t.a4,0),r.emplaceBack(0,t.a4,0,t.a4),r.emplaceBack(t.a4,t.a4,t.a4,t.a4),this.rasterBoundsBuffer=e.createVertexBuffer(r,Ri.members),this.rasterBoundsSegments=t.aW.simpleSegment(0,0,4,2);const o=new t.aV;o.emplaceBack(0,0),o.emplaceBack(t.a4,0),o.emplaceBack(0,t.a4),o.emplaceBack(t.a4,t.a4),this.rasterBoundsBufferPosOnly=e.createVertexBuffer(o,Rt.members),this.rasterBoundsSegmentsPosOnly=t.aW.simpleSegment(0,0,4,5);const s=new t.aV;s.emplaceBack(0,0),s.emplaceBack(1,0),s.emplaceBack(0,1),s.emplaceBack(1,1),this.viewportBuffer=e.createVertexBuffer(s,Rt.members),this.viewportSegments=t.aW.simpleSegment(0,0,4,2);const n=new t.ch;n.emplaceBack(0),n.emplaceBack(1),n.emplaceBack(3),n.emplaceBack(2),n.emplaceBack(0),this.tileBorderIndexBuffer=e.createIndexBuffer(n);const l=new t.aX;l.emplaceBack(1,0,2),l.emplaceBack(1,2,3),this.quadTriangleIndexBuffer=e.createIndexBuffer(l);const c=this.context.gl;this.stencilClearMode=new Yt({func:c.ALWAYS,mask:0},0,255,c.ZERO,c.ZERO,c.ZERO),this.tileExtentMesh=new St(this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}clearStencil(){const e=this.context,i=e.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const a=t.N();t.c6(a,0,this.width,this.height,0,0,1),t.Q(a,a,[i.drawingBufferWidth,i.drawingBufferHeight,0]);const r={mainMatrix:a,tileMercatorCoords:[0,0,1,1],clippingPlane:[0,0,0,0],projectionTransition:0,fallbackMatrix:a};this.useProgram("clippingMask",null,!0).draw(e,i.TRIANGLES,Xt.disabled,this.stencilClearMode,Wt.disabled,Ht.disabled,null,null,r,"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(e,t,i){if(this.currentStencilSource===e.source||!e.isTileClipped()||!t||!t.length)return;this.currentStencilSource=e.source,this.nextStencilID+t.length>256&&this.clearStencil();const a=this.context;a.setColorMode(Wt.disabled),a.setDepthMode(Xt.disabled);const r={};for(const e of t)r[e.key]=this.nextStencilID++;this._renderTileMasks(r,t,i,!0),this._renderTileMasks(r,t,i,!1),this._tileClippingMaskIDs=r;}_renderTileMasks(e,t,i,a){const r=this.context,o=r.gl,s=this.style.projection,n=this.transform,l=this.useProgram("clippingMask");for(const c of t){const t=e[c.key],h=this.style.map.terrain&&this.style.map.terrain.getTerrainData(c),u=s.getMeshFromTileID(this.context,c.canonical,a,!0,"stencil"),d=n.getProjectionData({overscaledTileID:c,applyGlobeMatrix:!i,applyTerrainMatrix:!0});l.draw(r,o.TRIANGLES,Xt.disabled,new Yt({func:o.ALWAYS,mask:0},t,255,o.KEEP,o.KEEP,o.REPLACE),Wt.disabled,i?Ht.disabled:Ht.backCCW,null,h,d,"$clipping",u.vertexBuffer,u.indexBuffer,u.segments);}}_renderTilesDepthBuffer(){const e=this.context,t=e.gl,i=this.style.projection,a=this.transform,r=this.useProgram("depth"),o=this.getDepthModeFor3D(),s=Ce(a,{tileSize:a.tileSize});for(const n of s){const s=this.style.map.terrain&&this.style.map.terrain.getTerrainData(n),l=i.getMeshFromTileID(this.context,n.canonical,!0,!0,"raster"),c=a.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!0,applyTerrainMatrix:!0});r.draw(e,t.TRIANGLES,o,Yt.disabled,Wt.disabled,Ht.backCCW,null,s,c,"$clipping",l.vertexBuffer,l.indexBuffer,l.segments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const e=this.nextStencilID++,t=this.context.gl;return new Yt({func:t.NOTEQUAL,mask:255},e,255,t.KEEP,t.KEEP,t.REPLACE)}stencilModeForClipping(e){const t=this.context.gl;return new Yt({func:t.EQUAL,mask:255},this._tileClippingMaskIDs[e.key],0,t.KEEP,t.KEEP,t.REPLACE)}getStencilConfigForOverlapAndUpdateStencilID(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),a=i[i.length-1].overscaledZ,r=i[0].overscaledZ-a+1;if(r>1){this.currentStencilSource=void 0,this.nextStencilID+r>256&&this.clearStencil();const e={};for(let i=0;i<r;i++)e[i+a]=new Yt({func:t.GEQUAL,mask:255},i+this.nextStencilID,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID+=r,[e,i]}return [{[a]:Yt.disabled},i]}stencilConfigForOverlapTwoPass(e){const t=this.context.gl,i=e.sort(((e,t)=>t.overscaledZ-e.overscaledZ)),a=i[i.length-1].overscaledZ,r=i[0].overscaledZ-a+1;if(this.clearStencil(),r>1){const e={},o={};for(let i=0;i<r;i++)e[i+a]=new Yt({func:t.GREATER,mask:255},r+1+i,255,t.KEEP,t.KEEP,t.REPLACE),o[i+a]=new Yt({func:t.GREATER,mask:255},1+i,255,t.KEEP,t.KEEP,t.REPLACE);return this.nextStencilID=2*r+1,[e,o,i]}return this.nextStencilID=3,[{[a]:new Yt({func:t.GREATER,mask:255},2,255,t.KEEP,t.KEEP,t.REPLACE)},{[a]:new Yt({func:t.GREATER,mask:255},1,255,t.KEEP,t.KEEP,t.REPLACE)},i]}colorModeForRenderPass(){const e=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new Wt([e.CONSTANT_COLOR,e.ONE],new t.bo(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?Wt.unblended:Wt.alphaBlended}getDepthModeForSublayer(e,t,i){if(!this.opaquePassEnabledForLayer())return Xt.disabled;const a=1-((1+this.currentLayer)*this.numSublayers+e)*this.depthEpsilon;return new Xt(i||this.context.gl.LEQUAL,t,[a,a])}getDepthModeFor3D(){return new Xt(this.context.gl.LEQUAL,Xt.ReadWrite,this.depthRangeFor3D)}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(e,i){var a,r;this.style=e,this.options=i,this.lineAtlas=e.lineAtlas,this.imageManager=e.imageManager,this.glyphManager=e.glyphManager,this.symbolFadeChange=e.placement.symbolFadeChange(c()),this.imageManager.beginFrame();const o=this.style._order,s=this.style.tileManagers,n={},l={},h={},u={isRenderingToTexture:!1,isRenderingGlobe:(null===(a=e.projection)||void 0===a?void 0:a.transitionState)>0};for(const e in s){const t=s[e];t.used&&t.prepare(this.context),n[e]=t.getVisibleCoordinates(!1),l[e]=n[e].slice().reverse(),h[e]=t.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let e=0;e<o.length;e++)if(this.style._layers[o[e]].is3D()){this.opaquePassCutoff=e;break}this.maybeDrawDepthAndCoords(!1),this.renderToTexture&&(this.renderToTexture.prepareForRender(this.style,this.transform.zoom),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const e of o){const t=this.style._layers[e];if(!t.hasOffscreenPass()||t.isHidden(this.transform.zoom))continue;const i=l[t.source];("custom"===t.type||i.length)&&this.renderLayer(this,s[t.source],t,i,u);}if(null===(r=this.style.projection)||void 0===r||r.updateGPUdependent({context:this.context,useProgram:e=>this.useProgram(e)}),this.context.viewport.set([0,0,this.width,this.height]),this.context.bindFramebuffer.set(null),this.context.clear({color:i.showOverdrawInspector?t.bo.black:t.bo.transparent,depth:1}),this.clearStencil(),this.style.sky&&function(e,t){const i=e.context,a=i.gl,r=((e,t,i)=>{const a=Math.cos(t.rollInRadians),r=Math.sin(t.rollInRadians),o=ge(t),s=t.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}).projectionTransition;return {u_sky_color:e.properties.get("sky-color"),u_horizon_color:e.properties.get("horizon-color"),u_horizon:[(t.width/2-o*r)*i,(t.height/2+o*a)*i],u_horizon_normal:[-r,a],u_sky_horizon_blend:e.properties.get("sky-horizon-blend")*t.height/2*i,u_sky_blend:s}})(t,e.style.map.transform,e.pixelRatio),o=new Xt(a.LEQUAL,Xt.ReadWrite,[0,1]),s=Yt.disabled,n=e.colorModeForRenderPass(),l=e.useProgram("sky"),c=Or(i,t);l.draw(i,a.TRIANGLES,o,s,n,Ht.disabled,r,null,void 0,"sky",c.vertexBuffer,c.indexBuffer,c.segments);}(this,this.style.sky),this._showOverdrawInspector=i.showOverdrawInspector,this.depthRangeFor3D=[0,1-(e._order.length+2)*this.numSublayers*this.depthEpsilon],!this.renderToTexture)for(this.renderPass="opaque",this.currentLayer=o.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[o[this.currentLayer]],t=s[e.source],i=n[e.source];this._renderTileClippingMasks(e,i,!1),this.renderLayer(this,t,e,i,u);}this.renderPass="translucent";let d=!1;for(this.currentLayer=0;this.currentLayer<o.length;this.currentLayer++){const e=this.style._layers[o[this.currentLayer]],t=s[e.source];if(this.renderToTexture&&this.renderToTexture.renderLayer(e,u))continue;this.opaquePassEnabledForLayer()||d||(d=!0,u.isRenderingGlobe&&!this.style.map.terrain&&this._renderTilesDepthBuffer());const i=("symbol"===e.type?h:l)[e.source];this._renderTileClippingMasks(e,n[e.source],!!this.renderToTexture),this.renderLayer(this,t,e,i,u);}if(u.isRenderingGlobe&&function(e,i,a){const r=e.context,o=r.gl,s=e.useProgram("atmosphere"),n=new Xt(o.LEQUAL,Xt.ReadOnly,[0,1]),l=e.transform,c=function(e,i){const a=e.properties.get("position"),r=[-a.x,-a.y,-a.z],o=t.ar(new Float64Array(16));return "map"===e.properties.get("anchor")&&(t.bf(o,o,i.rollInRadians),t.bg(o,o,-i.pitchInRadians),t.bf(o,o,i.bearingInRadians),t.bg(o,o,i.center.lat*Math.PI/180),t.bI(o,o,-i.center.lng*Math.PI/180)),t.cf(r,r,o),r}(a,e.transform),h=l.getProjectionData({overscaledTileID:null,applyGlobeMatrix:!0,applyTerrainMatrix:!0}),u=i.properties.get("atmosphere-blend")*h.projectionTransition;if(0===u)return;const d=hi(l.worldSize,l.center.lat),_=l.inverseProjectionMatrix,p=new Float64Array(4);p[3]=1,t.aG(p,p,l.modelViewProjectionMatrix),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1,t.aG(p,p,_),p[0]/=p[3],p[1]/=p[3],p[2]/=p[3],p[3]=1;const m=((e,t,i,a,r)=>({u_sun_pos:e,u_atmosphere_blend:t,u_globe_position:i,u_globe_radius:a,u_inv_proj_matrix:r}))(c,u,[p[0],p[1],p[2]],d,_),f=Or(r,i);s.draw(r,o.TRIANGLES,n,Yt.disabled,Wt.alphaBlended,Ht.disabled,m,null,null,"atmosphere",f.vertexBuffer,f.indexBuffer,f.segments);}(this,this.style.sky,this.style.light),this.options.showTileBoundaries){const e=function(e,t){let i=null;const a=Object.values(e._layers).flatMap((i=>i.source&&!i.isHidden(t)?[e.tileManagers[i.source]]:[])),r=a.filter((e=>"vector"===e.getSource().type)),o=a.filter((e=>"vector"!==e.getSource().type)),s=e=>{(!i||i.getSource().maxzoom<e.getSource().maxzoom)&&(i=e);};return r.forEach((e=>s(e))),i||o.forEach((e=>s(e))),i}(this.style,this.transform.zoom);e&&function(e,t,i){for(let a=0;a<i.length;a++)Fr(e,t,i[a]);}(this,e,e.getVisibleCoordinates());}this.options.showPadding&&function(e){const t=e.transform.padding;Ar(e,e.transform.height-(t.top||0),3,Er),Ar(e,t.bottom||0,3,Sr),Lr(e,t.left||0,3,Rr),Lr(e,e.transform.width-(t.right||0),3,Dr);const i=e.transform.centerPoint;!function(e,t,i,a){kr(e,t-1,i-10,2,20,a),kr(e,t-10,i-1,20,2,a);}(e,i.x,e.transform.height-i.y,zr);}(this),this.context.setDefault();}maybeDrawDepthAndCoords(e){if(!this.style||!this.style.map||!this.style.map.terrain)return;const i=this.terrainFacilitator.matrix,a=this.transform.modelViewProjectionMatrix;let r=this.terrainFacilitator.dirty;r||(r=e?!t.ci(i,a):!t.cj(i,a)),r||(r=this.style.map.terrain.tileManager.anyTilesAfterTime(this.terrainFacilitator.renderTime)),r&&(t.ck(i,a),this.terrainFacilitator.renderTime=Date.now(),this.terrainFacilitator.dirty=!1,function(e,i){const a=e.context,r=a.gl,o=e.transform,s=Wt.unblended,n=new Xt(r.LEQUAL,Xt.ReadWrite,[0,1]),l=i.tileManager.getRenderableTiles(),c=e.useProgram("terrainDepth");a.bindFramebuffer.set(i.getFramebuffer("depth").framebuffer),a.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),a.clear({color:t.bo.transparent,depth:1});for(const e of l){const t=i.getTerrainMesh(e.tileID),l=i.getTerrainData(e.tileID),h=o.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0}),u={u_ele_delta:i.getMeshFrameDelta(o.zoom)};c.draw(a,r.TRIANGLES,n,Yt.disabled,s,Ht.backCCW,u,l,h,"terrain",t.vertexBuffer,t.indexBuffer,t.segments);}a.bindFramebuffer.set(null),a.viewport.set([0,0,e.width,e.height]);}(this,this.style.map.terrain),function(e,i){const a=e.context,r=a.gl,o=e.transform,s=Wt.unblended,n=new Xt(r.LEQUAL,Xt.ReadWrite,[0,1]),l=i.getCoordsTexture(),c=i.tileManager.getRenderableTiles(),h=e.useProgram("terrainCoords");a.bindFramebuffer.set(i.getFramebuffer("coords").framebuffer),a.viewport.set([0,0,e.width/devicePixelRatio,e.height/devicePixelRatio]),a.clear({color:t.bo.transparent,depth:1}),i.coordsIndex=[];for(const e of c){const t=i.getTerrainMesh(e.tileID),c=i.getTerrainData(e.tileID);a.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,l.texture);const u={u_terrain_coords_id:(255-i.coordsIndex.length)/255,u_texture:0,u_ele_delta:i.getMeshFrameDelta(o.zoom)},d=o.getProjectionData({overscaledTileID:e.tileID,applyTerrainMatrix:!1,applyGlobeMatrix:!0});h.draw(a,r.TRIANGLES,n,Yt.disabled,s,Ht.backCCW,u,c,d,"terrain",t.vertexBuffer,t.indexBuffer,t.segments),i.coordsIndex.push(e.tileID.key);}a.bindFramebuffer.set(null),a.viewport.set([0,0,e.width,e.height]);}(this,this.style.map.terrain));}renderLayer(e,i,a,r,o){a.isHidden(this.transform.zoom)||("background"===a.type||"custom"===a.type||(r||[]).length)&&(this.id=a.id,t.cl(a)?function(e,i,a,r,o,s){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:n}=s,l=Yt.disabled,c=e.colorModeForRenderPass();(a._unevaluatedLayout.hasValue("text-variable-anchor")||a._unevaluatedLayout.hasValue("text-variable-anchor-offset"))&&function(e,i,a,r,o,s,n,l,c){const h=i.transform,u=i.style.map.terrain,d="map"===o,_="map"===s;for(const o of e){const e=r.getTile(o),s=e.getBucket(a);if(!s||!s.text||!s.text.segments.get().length)continue;const p=t.ax(s.textSizeData,h.zoom),m=t.aM(e,1,i.transform.zoom),f=Ae(d,i.transform,m),g="none"!==a.layout.get("icon-text-fit")&&s.hasIconData();if(p){const i=Math.pow(2,h.zoom-e.tileID.overscaledZ),a=u?(e,t)=>u.getElevation(o,e,t):null;nr(s,d,_,c,h,f,i,p,g,t.aN(h,e,n,l),o.toUnwrapped(),a);}}}(r,e,a,i,a.layout.get("text-rotation-alignment"),a.layout.get("text-pitch-alignment"),a.paint.get("text-translate"),a.paint.get("text-translate-anchor"),o),0!==a.paint.get("icon-opacity").constantOr(1)&&cr(e,i,a,r,!1,a.paint.get("icon-translate"),a.paint.get("icon-translate-anchor"),a.layout.get("icon-rotation-alignment"),a.layout.get("icon-pitch-alignment"),a.layout.get("icon-keep-upright"),l,c,n),0!==a.paint.get("text-opacity").constantOr(1)&&cr(e,i,a,r,!0,a.paint.get("text-translate"),a.paint.get("text-translate-anchor"),a.layout.get("text-rotation-alignment"),a.layout.get("text-pitch-alignment"),a.layout.get("text-keep-upright"),l,c,n),i.map.showCollisionBoxes&&(ar(e,i,a,r,!0),ar(e,i,a,r,!1));}(e,i,a,r,this.style.placement.variableOffsets,o):t.cm(a)?function(e,i,a,r,o){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=o,n=a.paint.get("circle-opacity"),l=a.paint.get("circle-stroke-width"),c=a.paint.get("circle-stroke-opacity"),h=!a.layout.get("circle-sort-key").isConstant();if(0===n.constantOr(1)&&(0===l.constantOr(1)||0===c.constantOr(1)))return;const u=e.context,d=u.gl,_=e.transform,p=e.getDepthModeForSublayer(0,Xt.ReadOnly),m=Yt.disabled,f=e.colorModeForRenderPass(),g=[],v=_.getCircleRadiusCorrection();for(let o=0;o<r.length;o++){const n=r[o],l=i.getTile(n),c=l.getBucket(a);if(!c)continue;const u=a.paint.get("circle-translate"),d=a.paint.get("circle-translate-anchor"),p=t.aN(_,l,u,d),m=c.programConfigurations.get(a.id),f=e.useProgram("circle",m),x=c.layoutVertexBuffer,b=c.indexBuffer,y=e.style.map.terrain&&e.style.map.terrain.getTerrainData(n),w={programConfiguration:m,program:f,layoutVertexBuffer:x,indexBuffer:b,uniformValues:Gi(e,l,a,p,v),terrainData:y,projectionData:_.getProjectionData({overscaledTileID:n,applyGlobeMatrix:!s,applyTerrainMatrix:!0})};if(h){const e=c.segments.get();for(const i of e)g.push({segments:new t.aW([i]),sortKey:i.sortKey,state:w});}else g.push({segments:c.segments,sortKey:0,state:w});}h&&g.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of g){const{programConfiguration:i,program:r,layoutVertexBuffer:o,indexBuffer:s,uniformValues:n,terrainData:l,projectionData:c}=t.state;r.draw(u,d.TRIANGLES,p,m,f,Ht.backCCW,n,l,c,a.id,o,s,t.segments,a.paint,e.transform.zoom,i);}}(e,i,a,r,o):t.cn(a)?function(e,i,a,r,o){if(0===a.paint.get("heatmap-opacity"))return;const s=e.context,{isRenderingToTexture:n,isRenderingGlobe:l}=o;if(e.style.map.terrain){for(const t of r){const r=i.getTile(t);i.hasRenderableParent(t)||("offscreen"===e.renderPass?ur(e,r,a,t,l):"translucent"===e.renderPass&&dr(e,a,t,n,l));}s.viewport.set([0,0,e.width,e.height]);}else "offscreen"===e.renderPass?function(e,i,a,r){const o=e.context,s=o.gl,n=e.transform,l=Yt.disabled,c=new Wt([s.ONE,s.ONE],t.bo.transparent,[!0,!0,!0,!0]);((function(e,i,a){const r=e.gl;e.activeTexture.set(r.TEXTURE1),e.viewport.set([0,0,i.width/4,i.height/4]);let o=a.heatmapFbos.get(t.cc);o?(r.bindTexture(r.TEXTURE_2D,o.colorAttachment.get()),e.bindFramebuffer.set(o.framebuffer)):(o=_r(e,i.width/4,i.height/4),a.heatmapFbos.set(t.cc,o));}))(o,e,a),o.clear({color:t.bo.transparent});for(let t=0;t<r.length;t++){const h=r[t];if(i.hasRenderableParent(h))continue;const u=i.getTile(h),d=u.getBucket(a);if(!d)continue;const _=d.programConfigurations.get(a.id),p=e.useProgram("heatmap",_),m=n.getProjectionData({overscaledTileID:h,applyGlobeMatrix:!0,applyTerrainMatrix:!1}),f=n.getCircleRadiusCorrection();p.draw(o,s.TRIANGLES,Xt.disabled,l,c,Ht.backCCW,Wi(u,n.zoom,a.paint.get("heatmap-intensity"),f),null,m,a.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,a.paint,n.zoom,_);}o.viewport.set([0,0,e.width,e.height]);}(e,i,a,r):"translucent"===e.renderPass&&function(e,i){const a=e.context,r=a.gl;a.setColorMode(e.colorModeForRenderPass());const o=i.heatmapFbos.get(t.cc);o&&(a.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,o.colorAttachment.get()),a.activeTexture.set(r.TEXTURE1),pr(a,i).bind(r.LINEAR,r.CLAMP_TO_EDGE),e.useProgram("heatmapTexture").draw(a,r.TRIANGLES,Xt.disabled,Yt.disabled,e.colorModeForRenderPass(),Ht.disabled,$i(e,i,0,1),null,null,i.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,i.paint,e.transform.zoom));}(e,a);}(e,i,a,r,o):t.co(a)?function(e,t,i,a,r){if("translucent"!==e.renderPass)return;const{isRenderingToTexture:o}=r,s=i.paint.get("line-opacity"),n=i.paint.get("line-width");if(0===s.constantOr(1)||0===n.constantOr(1))return;const l=e.getDepthModeForSublayer(0,Xt.ReadOnly),c=e.colorModeForRenderPass(),h=i.paint.get("line-dasharray"),u=h.constantOr(1),d=i.paint.get("line-pattern"),_=d.constantOr(1),p=i.paint.get("line-gradient"),m=i.getCrossfadeParameters();let f;f=_?"linePattern":u&&p?"lineGradientSDF":u?"lineSDF":p?"lineGradient":"line";const g=e.context,v=g.gl,x=e.transform;let b=!0;for(const r of a){const a=t.getTile(r);if(_&&!a.patternsLoaded())continue;const s=a.getBucket(i);if(!s)continue;const n=s.programConfigurations.get(i.id),y=e.context.program.get(),w=e.useProgram(f,n),T=b||w.program!==y,P=e.style.map.terrain&&e.style.map.terrain.getTerrainData(r),C=d.constantOr(null),M=h&&h.constantOr(null);if(C&&a.imageAtlas){const e=a.imageAtlas,t=e.patternPositions[C.to.toString()],i=e.patternPositions[C.from.toString()];t&&i&&n.setConstantPatternPositions(t,i);}else if(M){const t="round"===i.layout.get("line-cap"),a=e.lineAtlas.getDash(M.to,t),r=e.lineAtlas.getDash(M.from,t);n.setConstantDashPositions(a,r);}const I=x.getProjectionData({overscaledTileID:r,applyGlobeMatrix:!o,applyTerrainMatrix:!0}),E=x.getPixelScale();let S;_?(S=ea(e,a,i,E,m),fr(g,v,a,n,m)):u&&p?(S=ia(e,a,i,E,m,s.lineClipsArray.length),xr(e,t,g,v,i,s,r,n,m)):u?(S=ta(e,a,i,E,m),gr(e,g,v,n,T,m)):p?(S=Ji(e,a,i,E,s.lineClipsArray.length),vr(e,t,g,v,i,s,r)):S=Qi(e,a,i,E);const R=e.stencilModeForClipping(r);w.draw(g,v.TRIANGLES,l,R,c,Ht.disabled,S,P,I,i.id,s.layoutVertexBuffer,s.indexBuffer,s.segments,i.paint,e.transform.zoom,n,s.layoutVertexBuffer2),b=!1;}}(e,i,a,r,o):t.cp(a)?function(e,i,a,r,o){const s=a.paint.get("fill-color"),n=a.paint.get("fill-opacity");if(0===n.constantOr(1))return;const{isRenderingToTexture:l}=o,c=e.colorModeForRenderPass(),h=a.paint.get("fill-pattern"),u=e.opaquePassEnabledForLayer()&&!h.constantOr(1)&&1===s.constantOr(t.bo.transparent).a&&1===n.constantOr(0)?"opaque":"translucent";if(e.renderPass===u){const t=e.getDepthModeForSublayer(1,"opaque"===e.renderPass?Xt.ReadWrite:Xt.ReadOnly);yr(e,i,a,r,t,c,!1,l);}if("translucent"===e.renderPass&&a.paint.get("fill-antialias")){const t=e.getDepthModeForSublayer(a.getPaintProperty("fill-outline-color")?2:0,Xt.ReadOnly);yr(e,i,a,r,t,c,!0,l);}}(e,i,a,r,o):t.cq(a)?function(e,t,i,a,r){const o=i.paint.get("fill-extrusion-opacity");if(0===o)return;const{isRenderingToTexture:s}=r;if("translucent"===e.renderPass){const r=new Xt(e.context.gl.LEQUAL,Xt.ReadWrite,e.depthRangeFor3D);if(1!==o||i.paint.get("fill-extrusion-pattern").constantOr(1))wr(e,t,i,a,r,Yt.disabled,Wt.disabled,s),wr(e,t,i,a,r,e.stencilModeFor3D(),e.colorModeForRenderPass(),s);else {const o=e.colorModeForRenderPass();wr(e,t,i,a,r,Yt.disabled,o,s);}}}(e,i,a,r,o):t.cr(a)?function(e,i,a,r,o){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const{isRenderingToTexture:s}=o,n=e.context,l=e.style.projection.useSubdivision,c=e.getDepthModeForSublayer(0,Xt.ReadOnly),h=e.colorModeForRenderPass();if("offscreen"===e.renderPass)!function(e,i,a,r,o,s,n){const l=e.context,c=l.gl;for(const h of a){const a=i.getTile(h),u=a.dem;if(!u||!u.data)continue;if(!a.needsHillshadePrepare)continue;const d=u.dim,_=u.stride,p=u.getPixels();if(l.activeTexture.set(c.TEXTURE1),l.pixelStoreUnpackPremultiplyAlpha.set(!1),a.demTexture=a.demTexture||e.getTileTexture(_),a.demTexture){const e=a.demTexture;e.update(p,{premultiply:!1}),e.bind(c.NEAREST,c.CLAMP_TO_EDGE);}else a.demTexture=new t.T(l,p,c.RGBA,{premultiply:!1}),a.demTexture.bind(c.NEAREST,c.CLAMP_TO_EDGE);l.activeTexture.set(c.TEXTURE0);let m=a.fbo;if(!m){const e=new t.T(l,{width:d,height:d,data:null},c.RGBA);e.bind(c.LINEAR,c.CLAMP_TO_EDGE),m=a.fbo=l.createFramebuffer(d,d,!0,!1),m.colorAttachment.set(e.texture);}l.bindFramebuffer.set(m.framebuffer),l.viewport.set([0,0,d,d]),e.useProgram("hillshadePrepare").draw(l,c.TRIANGLES,o,s,n,Ht.disabled,Xi(a.tileID,u),null,null,r.id,e.rasterBoundsBuffer,e.quadTriangleIndexBuffer,e.rasterBoundsSegments),a.needsHillshadePrepare=!1;}}(e,i,r,a,c,Yt.disabled,h),n.viewport.set([0,0,e.width,e.height]);else if("translucent"===e.renderPass)if(l){const[t,o,n]=e.stencilConfigForOverlapTwoPass(r);Tr(e,i,a,n,t,c,h,!1,s),Tr(e,i,a,n,o,c,h,!0,s);}else {const[t,o]=e.getStencilConfigForOverlapAndUpdateStencilID(r);Tr(e,i,a,o,t,c,h,!1,s);}}(e,i,a,r,o):t.cs(a)?function(e,t,i,a,r){if("translucent"!==e.renderPass)return;if(!a.length)return;const{isRenderingToTexture:o}=r,s=e.style.projection.useSubdivision,n=e.getDepthModeForSublayer(0,Xt.ReadOnly),l=e.colorModeForRenderPass();if(s){const[r,s,c]=e.stencilConfigForOverlapTwoPass(a);Pr(e,t,i,c,r,n,l,!1,o),Pr(e,t,i,c,s,n,l,!0,o);}else {const[r,s]=e.getStencilConfigForOverlapAndUpdateStencilID(a);Pr(e,t,i,s,r,n,l,!1,o);}}(e,i,a,r,o):t.bT(a)?function(e,t,i,a,r){if("translucent"!==e.renderPass)return;if(0===i.paint.get("raster-opacity"))return;if(!a.length)return;const{isRenderingToTexture:o}=r,s=t.getSource(),n=e.style.projection.useSubdivision;if(s instanceof te)Mr(e,t,i,a,null,!1,!1,s.tileCoords,s.flippedWindingOrder,o);else if(n){const[r,s,n]=e.stencilConfigForOverlapTwoPass(a);Mr(e,t,i,n,r,!1,!0,Cr,!1,o),Mr(e,t,i,n,s,!0,!0,Cr,!1,o);}else {const[r,s]=e.getStencilConfigForOverlapAndUpdateStencilID(a);Mr(e,t,i,s,r,!1,!0,Cr,!1,o);}}(e,i,a,r,o):t.ct(a)?function(e,t,i,a,r){const o=i.paint.get("background-color"),s=i.paint.get("background-opacity");if(0===s)return;const{isRenderingToTexture:n}=r,l=e.context,c=l.gl,h=e.style.projection,u=e.transform,d=u.tileSize,_=i.paint.get("background-pattern");if(e.isPatternMissing(_))return;const p=!_&&1===o.a&&1===s&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==p)return;const m=Yt.disabled,f=e.getDepthModeForSublayer(0,"opaque"===p?Xt.ReadWrite:Xt.ReadOnly),g=e.colorModeForRenderPass(),v=e.useProgram(_?"backgroundPattern":"background"),x=a||Ce(u,{tileSize:d,terrain:e.style.map.terrain});_&&(l.activeTexture.set(c.TEXTURE0),e.imageManager.bind(e.context));const b=i.getCrossfadeParameters();for(const t of x){const a=u.getProjectionData({overscaledTileID:t,applyGlobeMatrix:!n,applyTerrainMatrix:!0}),r=_?ua(s,e,_,{tileID:t,tileSize:d},b):ha(s,o),p=e.style.map.terrain&&e.style.map.terrain.getTerrainData(t),x=h.getMeshFromTileID(l,t.canonical,!1,!0,"raster");v.draw(l,c.TRIANGLES,f,m,g,Ht.backCCW,r,p,a,i.id,x.vertexBuffer,x.indexBuffer,x.segments);}}(e,0,a,r,o):t.cu(a)&&function(e,t,i,a){const{isRenderingGlobe:r}=a,o=e.context,s=i.implementation,n=e.style.projection,l=e.transform,c=l.getProjectionDataForCustomLayer(r),h={farZ:l.farZ,nearZ:l.nearZ,fov:l.fov*Math.PI/180,modelViewProjectionMatrix:l.modelViewProjectionMatrix,projectionMatrix:l.projectionMatrix,shaderData:{variantName:n.shaderVariantName,vertexShaderPrelude:`const float PI = 3.141592653589793;\nuniform mat4 u_projection_matrix;\n${n.shaderPreludeCode.vertexSource}`,define:n.shaderDefine},defaultProjectionData:c},u=s.renderingMode?s.renderingMode:"2d";if("offscreen"===e.renderPass){const t=s.prerender;t&&(e.setCustomLayerDefaults(),o.setColorMode(e.colorModeForRenderPass()),t.call(s,o.gl,h),o.setDirty(),e.setBaseState());}else if("translucent"===e.renderPass){e.setCustomLayerDefaults(),o.setColorMode(e.colorModeForRenderPass()),o.setStencilMode(Yt.disabled);const t="3d"===u?e.getDepthModeFor3D():e.getDepthModeForSublayer(0,Xt.ReadOnly);o.setDepthMode(t),s.render(o.gl,h),o.setDirty(),e.setBaseState(),o.bindFramebuffer.set(null);}}(e,0,a,o));}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e];}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){if(!e)return !1;if(!e.from||!e.to)return !0;const t=this.imageManager.getPattern(e.from.toString()),i=this.imageManager.getPattern(e.to.toString());return !t||!i}useProgram(e,t,i=!1,a=[]){this.cache=this.cache||{};const r=!!this.style.map.terrain,o=this.style.projection,s=i?It.projectionMercator:o.shaderPreludeCode,n=i?Dt:o.shaderDefine,l=e+(t?t.cacheKey:"")+`/${i?zt:o.shaderVariantName}`+(this._showOverdrawInspector?"/overdraw":"")+(r?"/terrain":"")+(a?`/${a.join("/")}`:"");return this.cache[l]||(this.cache[l]=new ki(this.context,It[e],t,_a[e],this._showOverdrawInspector,r,s,n,a)),this.cache[l]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new t.T(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){var e,t;if(this._tileTextures){for(const e in this._tileTextures){const t=this._tileTextures[e];if(t)for(const e of t)e.destroy();}this._tileTextures={};}if(this.tileExtentBuffer&&this.tileExtentBuffer.destroy(),this.debugBuffer&&this.debugBuffer.destroy(),this.rasterBoundsBuffer&&this.rasterBoundsBuffer.destroy(),this.rasterBoundsBufferPosOnly&&this.rasterBoundsBufferPosOnly.destroy(),this.viewportBuffer&&this.viewportBuffer.destroy(),this.tileBorderIndexBuffer&&this.tileBorderIndexBuffer.destroy(),this.quadTriangleIndexBuffer&&this.quadTriangleIndexBuffer.destroy(),this.tileExtentMesh&&(null===(e=this.tileExtentMesh.vertexBuffer)||void 0===e||e.destroy()),this.tileExtentMesh&&(null===(t=this.tileExtentMesh.indexBuffer)||void 0===t||t.destroy()),this.debugOverlayTexture&&this.debugOverlayTexture.destroy(),this.cache){for(const e in this.cache){const t=this.cache[e];t&&t.program&&this.context.gl.deleteProgram(t.program);}this.cache={};}this.context&&this.context.setDefault();}overLimit(){const{drawingBufferWidth:e,drawingBufferHeight:t}=this.context.gl;return this.width!==e||this.height!==t}}function Nr(e,t){let i,a=!1,r=null,o=null;const s=()=>{r=null,a&&(e.apply(o,i),r=setTimeout(s,t),a=!1);};return (...e)=>(a=!0,o=this,i=e,r||s(),r)}class Zr{constructor(e){this._getCurrentHash=()=>{const e=window.location.hash.replace("#","");if(this._hashName){let t;return e.split("&").map((e=>e.split("="))).forEach((e=>{e[0]===this._hashName&&(t=e);})),(t&&t[1]||"").split("/")}return e.split("/")},this._onHashChange=()=>{const e=this._getCurrentHash();if(!this._isValidHash(e))return !1;const t=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(e[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+e[2],+e[1]],zoom:+e[0],bearing:t,pitch:+(e[4]||0)}),!0},this._updateHashUnthrottled=()=>{const e=window.location.href.replace(/(#.*)?$/,this.getHashString());window.history.replaceState(window.history.state,null,e);},this._removeHash=()=>{const e=this._getCurrentHash();if(0===e.length)return;const t=e.join("/");let i=t;i.split("&").length>0&&(i=i.split("&")[0]),this._hashName&&(i=`${this._hashName}=${t}`);let a=window.location.hash.replace(i,"");a.startsWith("#&")?a=a.slice(0,1)+a.slice(2):"#"===a&&(a="");let r=window.location.href.replace(/(#.+)?$/,a);r=r.replace("&&","&"),window.history.replaceState(window.history.state,null,r);},this._updateHash=Nr(this._updateHashUnthrottled,300),this._hashName=e&&encodeURIComponent(e);}addTo(e){return this._map=e,addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),this._removeHash(),delete this._map,this}getHashString(e){const t=this._map.getCenter(),i=Math.round(100*this._map.getZoom())/100,a=Math.ceil((i*Math.LN2+Math.log(512/360/.5))/Math.LN10),r=Math.pow(10,a),o=Math.round(t.lng*r)/r,s=Math.round(t.lat*r)/r,n=this._map.getBearing(),l=this._map.getPitch();let c="";if(c+=e?`/${o}/${s}/${i}`:`${i}/${s}/${o}`,(n||l)&&(c+="/"+Math.round(10*n)/10),l&&(c+=`/${Math.round(l)}`),this._hashName){const e=this._hashName;let t=!1;const i=window.location.hash.slice(1).split("&").map((i=>{const a=i.split("=")[0];return a===e?(t=!0,`${a}=${c}`):i})).filter((e=>e));return t||i.push(`${e}=${c}`),`#${i.join("&")}`}return `#${c}`}_isValidHash(e){if(e.length<3||e.some(isNaN))return !1;try{new t.V(+e[2],+e[1]);}catch(e){return !1}const i=+e[0],a=+(e[3]||0),r=+(e[4]||0);return i>=this._map.getMinZoom()&&i<=this._map.getMaxZoom()&&a>=-180&&a<=180&&r>=this._map.getMinPitch()&&r<=this._map.getMaxPitch()}}const Gr={linearity:.3,easing:t.cv(0,0,.3,1)},Ur=t.e({deceleration:2500,maxSpeed:1400},Gr),Vr=t.e({deceleration:20,maxSpeed:1400},Gr),qr=t.e({deceleration:1e3,maxSpeed:360},Gr),Wr=t.e({deceleration:1e3,maxSpeed:90},Gr),$r=t.e({deceleration:1e3,maxSpeed:360},Gr);class Hr{constructor(e){this._map=e,this.clear();}clear(){this._inertiaBuffer=[];}record(e){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:c(),settings:e});}_drainInertiaBuffer(){const e=this._inertiaBuffer,t=c();for(;e.length>0&&t-e[0].time>160;)e.shift();}_onMoveEnd(e){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,roll:0,pan:new t.P(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)i.zoom+=e.zoomDelta||0,i.bearing+=e.bearingDelta||0,i.pitch+=e.pitchDelta||0,i.roll+=e.rollDelta||0,e.panDelta&&i.pan._add(e.panDelta),e.around&&(i.around=e.around),e.pinchAround&&(i.pinchAround=e.pinchAround);const a=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,r={};if(i.pan.mag()){const o=Kr(i.pan.mag(),a,t.e({},Ur,e||{})),s=i.pan.mult(o.amount/i.pan.mag()),n=this._map.cameraHelper.handlePanInertia(s,this._map.transform);r.center=n.easingCenter,r.offset=n.easingOffset,Xr(r,o);}if(i.zoom){const e=Kr(i.zoom,a,Vr);r.zoom=this._map.transform.zoom+e.amount,Xr(r,e);}if(i.bearing){const e=Kr(i.bearing,a,qr);r.bearing=this._map.transform.bearing+t.an(e.amount,-179,179),Xr(r,e);}if(i.pitch){const e=Kr(i.pitch,a,Wr);r.pitch=this._map.transform.pitch+e.amount,Xr(r,e);}if(i.roll){const e=Kr(i.roll,a,$r);r.roll=this._map.transform.roll+t.an(e.amount,-179,179),Xr(r,e);}if(r.zoom||r.bearing){const e=void 0===i.pinchAround?i.around:i.pinchAround;r.around=e?this._map.unproject(e):this._map.getCenter();}return this.clear(),t.e(r,{noMoveStart:!0})}}function Xr(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing);}function Kr(e,i,a){const{maxSpeed:r,linearity:o,deceleration:s}=a,n=t.an(e*o/(i/1e3),-r,r),l=Math.abs(n)/(s*o);return {easing:a.easing,duration:1e3*l,amount:n*(l/2)}}class Yr extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,a,r={}){a=a instanceof MouseEvent?a:new MouseEvent(e,a);const o=h.mousePos(i.getCanvas(),a),s=i.unproject(o);super(e,t.e({point:o,lngLat:s,originalEvent:a},r)),this._defaultPrevented=!1,this.target=i;}}class Qr extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,i,a){const r="touchend"===e?a.changedTouches:a.touches,o=h.touchPos(i.getCanvasContainer(),r),s=o.map((e=>i.unproject(e))),n=o.reduce(((e,t,i,a)=>e.add(t.div(a.length))),new t.P(0,0));super(e,{points:o,point:n,lngLats:s,lngLat:i.unproject(n),originalEvent:a}),this._defaultPrevented=!1;}}class Jr extends t.l{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1;}}class eo{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance;}reset(){delete this._mousedownPos;}wheel(e){return this._firePreventable(new Jr(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new Yr(e.type,this._map,e))}mouseup(e){this._map.fire(new Yr(e.type,this._map,e));}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||this._map.fire(new Yr(e.type,this._map,e));}dblclick(e){return this._firePreventable(new Yr(e.type,this._map,e))}mouseover(e){this._map.fire(new Yr(e.type,this._map,e));}mouseout(e){this._map.fire(new Yr(e.type,this._map,e));}touchstart(e){return this._firePreventable(new Qr(e.type,this._map,e))}touchmove(e){this._map.fire(new Qr(e.type,this._map,e));}touchend(e){this._map.fire(new Qr(e.type,this._map,e));}touchcancel(e){this._map.fire(new Qr(e.type,this._map,e));}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class to{constructor(e){this._map=e;}reset(){this._delayContextMenu=!1,this._ignoreContextMenu=!0,delete this._contextMenuEvent;}mousemove(e){this._map.fire(new Yr(e.type,this._map,e));}mousedown(){this._delayContextMenu=!0,this._ignoreContextMenu=!1;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new Yr("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._ignoreContextMenu||this._map.fire(new Yr(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class io{constructor(e){this._map=e;}get transform(){return this._map._requestedCameraState||this._map.transform}get center(){return {lng:this.transform.center.lng,lat:this.transform.center.lat}}get zoom(){return this.transform.zoom}get pitch(){return this.transform.pitch}get bearing(){return this.transform.bearing}unproject(e){return this.transform.screenPointToLocation(t.P.convert(e),this._map.terrain)}}class ao{constructor(e,t){this._map=e,this._tr=new io(e),this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(h.disableDrag(),this._startPos=this._lastPos=t,this._active=!0);}mousemoveWindow(e,t){if(!this._active)return;const i=t;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const a=this._startPos;this._lastPos=i,this._box||(this._box=h.create("div","maplibregl-boxzoom",this._container),this._container.classList.add("maplibregl-crosshair"),this._fireEvent("boxzoomstart",e));const r=Math.min(a.x,i.x),o=Math.max(a.x,i.x),s=Math.min(a.y,i.y),n=Math.max(a.y,i.y);h.setTransform(this._box,`translate(${r}px,${s}px)`),this._box.style.width=o-r+"px",this._box.style.height=n-s+"px";}mouseupWindow(e,i){if(!this._active)return;if(0!==e.button)return;const a=this._startPos,r=i;if(this.reset(),h.suppressClick(),a.x!==r.x||a.y!==r.y)return this._map.fire(new t.l("boxzoomend",{originalEvent:e})),{cameraAnimation:e=>e.fitScreenCoordinates(a,r,this._tr.bearing,{linear:!0})};this._fireEvent("boxzoomcancel",e);}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e));}reset(){this._active=!1,this._container.classList.remove("maplibregl-crosshair"),this._box&&(h.remove(this._box),this._box=null),h.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(e,i){return this._map.fire(new t.l(e,{originalEvent:i}))}}function ro(e,t){if(e.length!==t.length)throw new Error(`The number of touches and points are not equal - touches ${e.length}, points ${t.length}`);const i={};for(let a=0;a<e.length;a++)i[e[a].identifier]=t[a];return i}class oo{constructor(e){this.reset(),this.numTouches=e.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(e,i,a){(this.centroid||a.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=e.timeStamp),a.length===this.numTouches&&(this.centroid=function(e){const i=new t.P(0,0);for(const t of e)i._add(t);return i.div(e.length)}(i),this.touches=ro(a,i)));}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const a=ro(i,t);for(const e in this.touches){const t=a[e];(!t||t.dist(this.touches[e])>30)&&(this.aborted=!0);}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class so{constructor(e){this.singleTap=new oo(e),this.numTaps=e.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(e,t,i){this.singleTap.touchstart(e,t,i);}touchmove(e,t,i){this.singleTap.touchmove(e,t,i);}touchend(e,t,i){const a=this.singleTap.touchend(e,t,i);if(a){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(a)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=a,this.count===this.numTaps)return this.reset(),a}}}class no{constructor(e){this._tr=new io(e),this._zoomIn=new so({numTouches:1,numTaps:2}),this._zoomOut=new so({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i);}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i);}touchend(e,t,i){const a=this._zoomIn.touchend(e,t,i),r=this._zoomOut.touchend(e,t,i),o=this._tr;return a?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:o.zoom+1,around:o.unproject(a)},{originalEvent:e})}):r?(this._active=!0,e.preventDefault(),setTimeout((()=>this.reset()),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:o.zoom-1,around:o.unproject(r)},{originalEvent:e})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class lo{constructor(e){this._enabled=!!e.enable,this._moveStateManager=e.moveStateManager,this._clickTolerance=e.clickTolerance||1,this._moveFunction=e.move,this._activateOnStart=!!e.activateOnStart,e.assignEvents(this),this.reset();}reset(e){this._active=!1,this._moved=!1,delete this._lastPoint,this._moveStateManager.endMove(e);}_move(...e){const t=this._moveFunction(...e);if(t.bearingDelta||t.pitchDelta||t.rollDelta||t.around||t.panDelta)return this._active=!0,t}dragStart(e,t){this.isEnabled()&&!this._lastPoint&&this._moveStateManager.isValidStartEvent(e)&&(this._moveStateManager.startMove(e),this._lastPoint=Array.isArray(t)?t[0]:t,this._activateOnStart&&this._lastPoint&&(this._active=!0));}dragMove(e,t){if(!this.isEnabled())return;const i=this._lastPoint;if(!i)return;if(e.preventDefault(),!this._moveStateManager.isValidMoveEvent(e))return void this.reset(e);const a=Array.isArray(t)?t[0]:t;return !this._moved&&a.dist(i)<this._clickTolerance?void 0:(this._moved=!0,this._lastPoint=a,this._move(i,a))}dragEnd(e){this.isEnabled()&&this._lastPoint&&this._moveStateManager.isValidEndEvent(e)&&(this._moved&&h.suppressClick(),this.reset(e));}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}getClickTolerance(){return this._clickTolerance}}const co=0,ho=2,uo={[co]:1,[ho]:2};class _o{constructor(e){this._correctEvent=e.checkCorrectEvent;}startMove(e){const t=h.mouseButton(e);this._eventButton=t;}endMove(e){delete this._eventButton;}isValidStartEvent(e){return this._correctEvent(e)}isValidMoveEvent(e){return !function(e,t){const i=uo[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton)}isValidEndEvent(e){return h.mouseButton(e)===this._eventButton}}class po{constructor(){this._firstTouch=void 0;}_isOneFingerTouch(e){return 1===e.targetTouches.length}_isSameTouchEvent(e){return e.targetTouches[0].identifier===this._firstTouch}startMove(e){this._firstTouch=e.targetTouches[0].identifier;}endMove(e){delete this._firstTouch;}isValidStartEvent(e){return this._isOneFingerTouch(e)}isValidMoveEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}isValidEndEvent(e){return this._isOneFingerTouch(e)&&this._isSameTouchEvent(e)}}class mo{constructor(e=new _o({checkCorrectEvent:()=>!0}),t=new po){this.mouseMoveStateManager=e,this.oneFingerTouchMoveStateManager=t;}_executeRelevantHandler(e,t,i){return e instanceof MouseEvent?t(e):"undefined"!=typeof TouchEvent&&e instanceof TouchEvent?i(e):void 0}startMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.startMove(e)),(e=>this.oneFingerTouchMoveStateManager.startMove(e)));}endMove(e){this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.endMove(e)),(e=>this.oneFingerTouchMoveStateManager.endMove(e)));}isValidStartEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidStartEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidStartEvent(e)))}isValidMoveEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidMoveEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidMoveEvent(e)))}isValidEndEvent(e){return this._executeRelevantHandler(e,(e=>this.mouseMoveStateManager.isValidEndEvent(e)),(e=>this.oneFingerTouchMoveStateManager.isValidEndEvent(e)))}}const fo=e=>{e.mousedown=e.dragStart,e.mousemoveWindow=e.dragMove,e.mouseup=e.dragEnd,e.contextmenu=e=>{e.preventDefault();};};class go{constructor(e,t){this._clickTolerance=e.clickTolerance||1,this._map=t,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new t.P(0,0);}_shouldBePrevented(e){return e<(this._map.cooperativeGestures.isEnabled()?2:1)}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(e,t,i){if(this._active){if(!this._shouldBePrevented(i.length))return e.preventDefault(),this._calculateTransform(e,t,i);this._map.cooperativeGestures.notifyGestureBlocked("touch_pan",e);}}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&this._shouldBePrevented(i.length)&&this.reset();}touchcancel(){this.reset();}_calculateTransform(e,i,a){a.length>0&&(this._active=!0);const r=ro(a,i),o=new t.P(0,0),s=new t.P(0,0);let n=0;for(const e in r){const t=r[e],i=this._touches[e];i&&(o._add(t),s._add(t.sub(i)),n++,r[e]=t);}if(this._touches=r,this._shouldBePrevented(n)||!s.mag())return;const l=s.div(n);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:o.div(n),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class vo{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]));}touchmove(e,t,i){if(!this._firstTwoTouches)return;e.preventDefault();const[a,r]=this._firstTwoTouches,o=xo(i,t,a),s=xo(i,t,r);if(!o||!s)return;const n=this._aroundCenter?null:o.add(s).div(2);return this._move([o,s],n,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[a,r]=this._firstTwoTouches,o=xo(i,t,a),s=xo(i,t,r);o&&s||(this._active&&h.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return !!this._enabled}isActive(){return !!this._active}}function xo(e,t,i){for(let a=0;a<e.length;a++)if(e[a].identifier===i)return t[a]}function bo(e,t){return Math.log(e/t)/Math.LN2}class yo extends vo{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(e){this._startDistance=this._distance=e[0].dist(e[1]);}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(bo(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:bo(this._distance,i),pinchAround:t}}}function wo(e,t){return 180*e.angleWith(t)/Math.PI}class To extends vo{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1]);}_move(e,t,i){const a=this._vector;if(this._vector=e[0].sub(e[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:wo(this._vector,a),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=wo(e,this._startVector);return Math.abs(i)<t}}function Po(e){return Math.abs(e.y)>Math.abs(e.x)}class Co extends vo{constructor(e){super(),this._currentTouchCount=0,this._map=e;}reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}touchstart(e,t,i){super.touchstart(e,t,i),this._currentTouchCount=i.length;}_start(e){this._lastPoints=e,Po(e[0].sub(e[1]))&&(this._valid=!1);}_move(e,t,i){if(this._map.cooperativeGestures.isEnabled()&&this._currentTouchCount<3)return;const a=e[0].sub(this._lastPoints[0]),r=e[1].sub(this._lastPoints[1]);return this._valid=this.gestureBeginsVertically(a,r,i.timeStamp),this._valid?(this._lastPoints=e,this._active=!0,{pitchDelta:(a.y+r.y)/2*-.5}):void 0}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const a=e.mag()>=2,r=t.mag()>=2;if(!a&&!r)return;if(!a||!r)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const o=e.y>0==t.y>0;return Po(e)&&Po(t)&&o}}const Mo={panStep:100,bearingStep:15,pitchStep:10};class Io{constructor(e){this._tr=new io(e);const t=Mo;this._panStep=t.panStep,this._bearingStep=t.bearingStep,this._pitchStep=t.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,a=0,r=0,o=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),r=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),r=1);break;case 38:e.shiftKey?a=1:(e.preventDefault(),o=-1);break;case 40:e.shiftKey?a=-1:(e.preventDefault(),o=1);break;default:return}return this._rotationDisabled&&(i=0,a=0),{cameraAnimation:s=>{const n=this._tr;s.easeTo({duration:300,easeId:"keyboardHandler",easing:Eo,zoom:t?Math.round(n.zoom)+t*(e.shiftKey?2:1):n.zoom,bearing:n.bearing+i*this._bearingStep,pitch:n.pitch+a*this._pitchStep,offset:[-r*this._panStep,-o*this._panStep],center:n.center},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function Eo(e){return e*(2-e)}const So=4.000244140625,Ro=1/450;class Do{constructor(e,t){this._onTimeout=e=>{this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e);},this._map=e,this._tr=new io(e),this._triggerRenderFrame=t,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=Ro;}setZoomRate(e){this._defaultZoomRate=e;}setWheelZoomRate(e){this._wheelZoomRate=e;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around);}disable(){this.isEnabled()&&(this._enabled=!1);}_shouldBePrevented(e){return !!this._map.cooperativeGestures.isEnabled()&&!(e.ctrlKey||this._map.cooperativeGestures.isBypassed(e))}wheel(e){if(!this.isEnabled())return;if(this._shouldBePrevented(e))return void this._map.cooperativeGestures.notifyGestureBlocked("wheel_zoom",e);let t=e.deltaMode===WheelEvent.DOM_DELTA_LINE?40*e.deltaY:e.deltaY;const i=c(),a=i-(this._lastWheelEventTime||0);this._lastWheelEventTime=i,0!==t&&t%So==0?this._type="wheel":0!==t&&Math.abs(t)<4?this._type="trackpad":a>400?(this._type=null,this._lastValue=t,this._timeout=setTimeout(this._onTimeout,40,e)):this._type||(this._type=Math.abs(a*t)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,t+=this._lastValue)),e.shiftKey&&t&&(t/=4),this._type&&(this._lastWheelEvent=e,this._delta-=t,this._active||this._start(e)),e.preventDefault();}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const i=h.mousePos(this._map.getCanvas(),e),a=this._tr;this._aroundPoint=this._aroundCenter?a.transform.locationToScreenPoint(t.V.convert(a.center)):i,this._frameId||(this._frameId=!0,this._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const e=this._tr.transform;if("number"==typeof this._lastExpectedZoom){const t=e.zoom-this._lastExpectedZoom;"number"==typeof this._startZoom&&(this._startZoom+=t),"number"==typeof this._targetZoom&&(this._targetZoom+=t);}if(0!==this._delta){const i="wheel"===this._type&&Math.abs(this._delta)>So?this._wheelZoomRate:this._defaultZoomRate;let a=2/(1+Math.exp(-Math.abs(this._delta*i)));this._delta<0&&0!==a&&(a=1/a);const r="number"!=typeof this._targetZoom?e.scale:t.aq(this._targetZoom);this._targetZoom=e.applyConstrain(e.getCameraLngLat(),t.at(r*a)).zoom,"wheel"===this._type&&(this._startZoom=e.zoom,this._easing=this._smoothOutEasing(200)),this._delta=0;}const i="number"!=typeof this._targetZoom?e.zoom:this._targetZoom,a=this._startZoom,r=this._easing;let o,s=!1;if("wheel"===this._type&&a&&r){const e=c()-this._lastWheelEventTime,n=Math.min((e+5)/200,1),l=r(n);o=t.G.number(a,i,l),n<1?this._frameId||(this._frameId=!0):s=!0;}else o=i,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout((()=>{this._zooming=!1,this._triggerRenderFrame(),delete this._targetZoom,delete this._lastExpectedZoom,delete this._finishTimeout;}),200)),this._lastExpectedZoom=o,{noInertia:!0,needsRenderFrame:!s,zoomDelta:o-e.zoom,around:this._aroundPoint,originalEvent:this._lastWheelEvent}}_smoothOutEasing(e){let i=t.cx;if(this._prevEase){const e=this._prevEase,a=(c()-e.start)/e.duration,r=e.easing(a+.01)-e.easing(a),o=.27/Math.sqrt(r*r+1e-4)*.01,s=Math.sqrt(.0729-o*o);i=t.cv(o,s,.25,1);}return this._prevEase={start:c(),duration:e,easing:i},i}reset(){this._active=!1,this._zooming=!1,delete this._targetZoom,delete this._lastExpectedZoom,this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);}}class zo{constructor(e,t){this._clickZoom=e,this._tapZoom=t;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class Ao{constructor(e){this._tr=new io(e),this.reset();}reset(){this._active=!1;}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:this._tr.zoom+(e.shiftKey?-1:1),around:this._tr.unproject(t)},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Lo{constructor(){this._tap=new so({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,delete this._tapPoint,this._tap.reset();}touchstart(e,t,i){if(!this._swipePoint)if(this._tapTime){const a=t[0],r=e.timeStamp-this._tapTime<500,o=this._tapPoint.dist(a)<30;r&&o?i.length>0&&(this._swipePoint=a,this._swipeTouch=i[0].identifier):this.reset();}else this._tap.touchstart(e,t,i);}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const a=t[0],r=a.y-this._swipePoint.y;return this._swipePoint=a,e.preventDefault(),this._active=!0,{zoomDelta:r/128}}}else this._tap.touchmove(e,t,i);}touchend(e,t,i){if(this._tapTime)this._swipePoint&&0===i.length&&this.reset();else {const a=this._tap.touchend(e,t,i);a&&(this._tapTime=e.timeStamp,this._tapPoint=a);}}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class ko{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i;}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("maplibregl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("maplibregl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class Fo{constructor(e,t,i,a){this._pitchWithRotate=e.pitchWithRotate,this._rollEnabled=e.rollEnabled,this._mouseRotate=t,this._mousePitch=i,this._mouseRoll=a;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable(),this._rollEnabled&&this._mouseRoll.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable(),this._mouseRoll.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())&&(!this._rollEnabled||this._mouseRoll.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()||this._mouseRoll.isActive()}}class Bo{constructor(e,t,i,a){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=a,this._rotationDisabled=!1,this._enabled=!0;}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("maplibregl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("maplibregl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}class Oo{constructor(e,t){this._bypassKey=-1!==navigator.userAgent.indexOf("Mac")?"metaKey":"ctrlKey",this._map=e,this._options=t,this._enabled=!1;}isActive(){return !1}reset(){}_setupUI(){if(this._container)return;const e=this._map.getCanvasContainer();e.classList.add("maplibregl-cooperative-gestures"),this._container=h.create("div","maplibregl-cooperative-gesture-screen",e);let t=this._map._getUIString("CooperativeGesturesHandler.WindowsHelpText");"metaKey"===this._bypassKey&&(t=this._map._getUIString("CooperativeGesturesHandler.MacHelpText"));const i=this._map._getUIString("CooperativeGesturesHandler.MobileHelpText"),a=document.createElement("div");a.className="maplibregl-desktop-message",a.textContent=t,this._container.appendChild(a);const r=document.createElement("div");r.className="maplibregl-mobile-message",r.textContent=i,this._container.appendChild(r),this._container.setAttribute("aria-hidden","true");}_destroyUI(){this._container&&(h.remove(this._container),this._map.getCanvasContainer().classList.remove("maplibregl-cooperative-gestures")),delete this._container;}enable(){this._setupUI(),this._enabled=!0;}disable(){this._enabled=!1,this._destroyUI();}isEnabled(){return this._enabled}isBypassed(e){return e[this._bypassKey]}notifyGestureBlocked(e,i){this._enabled&&(this._map.fire(new t.l("cooperativegestureprevented",{gestureType:e,originalEvent:i})),this._container.classList.add("maplibregl-show"),setTimeout((()=>{this._container.classList.remove("maplibregl-show");}),100));}}const jo=e=>e.zoom||e.drag||e.roll||e.pitch||e.rotate;class No extends t.l{}function Zo(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta||e.rollDelta}class Go{constructor(e,i){this.handleWindowEvent=e=>{this.handleEvent(e,`${e.type}Window`);},this.handleEvent=(e,i)=>{if("blur"===e.type)return void this.stop(!0);this._updatingCamera=!0;const a="renderFrame"===e.type?void 0:e,r={needsRenderFrame:!1},o={},s={};for(const{handlerName:n,handler:l,allowed:c}of this._handlers){if(!l.isEnabled())continue;let u;if(this._blockedByActive(s,c,n))l.reset();else if(l[i||e.type]){if(t.cy(e,i||e.type)){const t=h.mousePos(this._map.getCanvas(),e);u=l[i||e.type](e,t);}else if(t.cz(e,i||e.type)){const t=this._getMapTouches(e.touches),a=h.touchPos(this._map.getCanvas(),t);u=l[i||e.type](e,a,t);}else t.cA(i||e.type)||(u=l[i||e.type](e));this.mergeHandlerResult(r,o,u,n,a),u&&u.needsRenderFrame&&this._triggerRenderFrame();}(u||l.isActive())&&(s[n]=l);}const n={};for(const e in this._previousActiveHandlers)s[e]||(n[e]=a);this._previousActiveHandlers=s,(Object.keys(n).length||Zo(r))&&(this._changes.push([r,o,n]),this._triggerRenderFrame()),(Object.keys(s).length||Zo(r))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:l}=r;l&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],l(this._map));},this._map=e,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new Hr(e),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._eventsInProgress={},this._addDefaultHandlers(i);const a=this._el;this._listeners=[[a,"touchstart",{passive:!0}],[a,"touchmove",{passive:!1}],[a,"touchend",void 0],[a,"touchcancel",void 0],[a,"mousedown",void 0],[a,"mousemove",void 0],[a,"mouseup",void 0],[document,"mousemove",{capture:!0}],[document,"mouseup",void 0],[a,"mouseover",void 0],[a,"mouseout",void 0],[a,"dblclick",void 0],[a,"click",void 0],[a,"keydown",{capture:!1}],[a,"keyup",void 0],[a,"wheel",{passive:!1}],[a,"contextmenu",void 0],[window,"blur",void 0]];for(const[e,t,i]of this._listeners)h.addEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i);}destroy(){for(const[e,t,i]of this._listeners)h.removeEventListener(e,t,e===document?this.handleWindowEvent:this.handleEvent,i);}_addDefaultHandlers(e){const i=this._map,a=i.getCanvasContainer();this._add("mapEvent",new eo(i,e));const r=i.boxZoom=new ao(i,e);this._add("boxZoom",r),e.interactive&&e.boxZoom&&r.enable();const o=i.cooperativeGestures=new Oo(i,e.cooperativeGestures);this._add("cooperativeGestures",o),e.cooperativeGestures&&o.enable();const s=new no(i),n=new Ao(i);i.doubleClickZoom=new zo(n,s),this._add("tapZoom",s),this._add("clickZoom",n),e.interactive&&e.doubleClickZoom&&i.doubleClickZoom.enable();const l=new Lo;this._add("tapDragZoom",l);const c=i.touchPitch=new Co(i);this._add("touchPitch",c),e.interactive&&e.touchPitch&&i.touchPitch.enable(e.touchPitch);const u=()=>i.project(i.getCenter()),d=function({enable:e,clickTolerance:i,aroundCenter:a=!0,minPixelCenterThreshold:r=100,rotateDegreesPerPixelMoved:o=.8},s){const n=new _o({checkCorrectEvent:e=>0===h.mouseButton(e)&&e.ctrlKey||2===h.mouseButton(e)&&!e.ctrlKey});return new lo({clickTolerance:i,move:(e,i)=>{const n=s();if(a&&Math.abs(n.y-e.y)>r)return {bearingDelta:t.cw(new t.P(e.x,i.y),i,n)};let l=(i.x-e.x)*o;return a&&i.y<n.y&&(l=-l),{bearingDelta:l}},moveStateManager:n,enable:e,assignEvents:fo})}(e,u),_=function({enable:e,clickTolerance:t,pitchDegreesPerPixelMoved:i=-.5}){const a=new _o({checkCorrectEvent:e=>0===h.mouseButton(e)&&e.ctrlKey||2===h.mouseButton(e)});return new lo({clickTolerance:t,move:(e,t)=>({pitchDelta:(t.y-e.y)*i}),moveStateManager:a,enable:e,assignEvents:fo})}(e),p=function({enable:e,clickTolerance:t,rollDegreesPerPixelMoved:i=.3},a){const r=new _o({checkCorrectEvent:e=>2===h.mouseButton(e)&&e.ctrlKey});return new lo({clickTolerance:t,move:(e,t)=>{const r=a();let o=(t.x-e.x)*i;return t.y<r.y&&(o=-o),{rollDelta:o}},moveStateManager:r,enable:e,assignEvents:fo})}(e,u);i.dragRotate=new Fo(e,d,_,p),this._add("mouseRotate",d,["mousePitch"]),this._add("mousePitch",_,["mouseRotate","mouseRoll"]),this._add("mouseRoll",p,["mousePitch"]),e.interactive&&e.dragRotate&&i.dragRotate.enable();const m=function({enable:e,clickTolerance:t}){const i=new _o({checkCorrectEvent:e=>0===h.mouseButton(e)&&!e.ctrlKey});return new lo({clickTolerance:t,move:(e,t)=>({around:t,panDelta:t.sub(e)}),activateOnStart:!0,moveStateManager:i,enable:e,assignEvents:fo})}(e),f=new go(e,i);i.dragPan=new ko(a,m,f),this._add("mousePan",m),this._add("touchPan",f,["touchZoom","touchRotate"]),e.interactive&&e.dragPan&&i.dragPan.enable(e.dragPan);const g=new To,v=new yo;i.touchZoomRotate=new Bo(a,v,g,l),this._add("touchRotate",g,["touchPan","touchZoom"]),this._add("touchZoom",v,["touchPan","touchRotate"]),e.interactive&&e.touchZoomRotate&&i.touchZoomRotate.enable(e.touchZoomRotate),this._add("blockableMapEvent",new to(i));const x=i.scrollZoom=new Do(i,(()=>this._triggerRenderFrame()));this._add("scrollZoom",x,["mousePan"]),e.interactive&&e.scrollZoom&&i.scrollZoom.enable(e.scrollZoom);const b=i.keyboard=new Io(i);this._add("keyboard",b),e.interactive&&e.keyboard&&i.keyboard.enable();}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t;}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[];}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(jo(this._eventsInProgress))||this.isZooming()}_blockedByActive(e,t,i){for(const a in e)if(a!==i&&(!t||t.indexOf(a)<0))return !0;return !1}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}mergeHandlerResult(e,i,a,r,o){if(!a)return;t.e(e,a);const s={handlerName:r,originalEvent:a.originalEvent||o};void 0!==a.zoomDelta&&(i.zoom=s),void 0!==a.panDelta&&(i.drag=s),void 0!==a.rollDelta&&(i.roll=s),void 0!==a.pitchDelta&&(i.pitch=s),void 0!==a.bearingDelta&&(i.rotate=s);}_applyChanges(){const e={},i={},a={};for(const[r,o,s]of this._changes)r.panDelta&&(e.panDelta=(e.panDelta||new t.P(0,0))._add(r.panDelta)),r.zoomDelta&&(e.zoomDelta=(e.zoomDelta||0)+r.zoomDelta),r.bearingDelta&&(e.bearingDelta=(e.bearingDelta||0)+r.bearingDelta),r.pitchDelta&&(e.pitchDelta=(e.pitchDelta||0)+r.pitchDelta),r.rollDelta&&(e.rollDelta=(e.rollDelta||0)+r.rollDelta),void 0!==r.around&&(e.around=r.around),void 0!==r.pinchAround&&(e.pinchAround=r.pinchAround),r.noInertia&&(e.noInertia=r.noInertia),t.e(i,o),t.e(a,s);this._updateMapTransform(e,i,a),this._changes=[];}_updateMapTransform(e,t,i){const a=this._map,r=a._getTransformForUpdate(),o=a.terrain;if(!(Zo(e)||o&&this._terrainMovement))return this._fireEvents(t,i,!0);a._stop(!0);let{panDelta:s,zoomDelta:n,bearingDelta:l,pitchDelta:c,rollDelta:h,around:u,pinchAround:d}=e;void 0!==d&&(u=d),u=u||a.transform.centerPoint,o&&!r.isPointOnMapSurface(u)&&(u=r.centerPoint);const _={panDelta:s,zoomDelta:n,rollDelta:h,pitchDelta:c,bearingDelta:l,around:u};this._map.cameraHelper.useGlobeControls&&!r.isPointOnMapSurface(u)&&(u=r.centerPoint);const p=u.distSqr(r.centerPoint)<.01?r.center:r.screenPointToLocation(s?u.sub(s):u);this._handleMapControls({terrain:o,tr:r,deltasForHelper:_,preZoomAroundLoc:p,combinedEventsInProgress:t,panDelta:s}),a._applyUpdatedTransform(r),this._map._update(),e.noInertia||this._inertia.record(e),this._fireEvents(t,i,!0);}_handleMapControls({terrain:e,tr:t,deltasForHelper:i,preZoomAroundLoc:a,combinedEventsInProgress:r,panDelta:o}){const s=this._map.cameraHelper;if(s.handleMapControlsRollPitchBearingZoom(i,t),e)return s.useGlobeControls?(this._terrainMovement||!r.drag&&!r.zoom||(this._terrainMovement=!0,this._map._elevationFreeze=!0),void s.handleMapControlsPan(i,t,a)):this._terrainMovement||!r.drag&&!r.zoom?void(r.drag&&this._terrainMovement&&o?t.setCenter(t.screenPointToLocation(t.centerPoint.sub(o))):s.handleMapControlsPan(i,t,a)):(this._terrainMovement=!0,this._map._elevationFreeze=!0,void s.handleMapControlsPan(i,t,a));s.handleMapControlsPan(i,t,a);}_fireEvents(e,i,a){const r=jo(this._eventsInProgress),o=jo(e),s={};for(const t in e){const{originalEvent:i}=e[t];this._eventsInProgress[t]||(s[`${t}start`]=i),this._eventsInProgress[t]=e[t];}!r&&o&&this._fireEvent("movestart",o.originalEvent);for(const e in s)this._fireEvent(e,s[e]);o&&this._fireEvent("move",o.originalEvent);for(const t in e){const{originalEvent:i}=e[t];this._fireEvent(t,i);}const l={};let c;for(const e in this._eventsInProgress){const{handlerName:t,originalEvent:a}=this._eventsInProgress[e];this._handlersById[t].isActive()||(delete this._eventsInProgress[e],c=i[t]||a,l[`${e}end`]=c);}for(const e in l)this._fireEvent(e,l[e]);const h=jo(this._eventsInProgress),u=(r||o)&&!h;if(u&&this._terrainMovement){this._map._elevationFreeze=!1,this._terrainMovement=!1;const e=this._map._getTransformForUpdate();this._map.getCenterClampedToGround()&&e.recalculateZoomAndCenter(this._map.terrain),this._map._applyUpdatedTransform(e);}if(a&&u){this._updatingCamera=!0;const e=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;!e||!e.essential&&n.prefersReducedMotion?(this._map.fire(new t.l("moveend",{originalEvent:c})),i(this._map.getBearing())&&this._map.resetNorth()):(i(e.bearing||this._map.getBearing())&&(e.bearing=0),e.freezeElevation=!0,this._map.easeTo(e,{originalEvent:c})),this._updatingCamera=!1;}}_fireEvent(e,i){this._map.fire(new t.l(e,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add((e=>{delete this._frameId,this.handleEvent(new No("renderFrame",{timeStamp:e})),this._applyChanges();}))}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class Uo extends t.E{constructor(e,t,i){super(),this._renderFrameCallback=()=>{const e=Math.min((c()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(e)),e<1&&this._easeFrameId?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();},this._moving=!1,this._zooming=!1,this.transform=e,this._bearingSnap=i.bearingSnap,this.cameraHelper=t,this.on("moveend",(()=>{delete this._requestedCameraState;}));}migrateProjection(e,t){e.apply(this.transform),this.transform=e,this.cameraHelper=t;}getCenter(){return new t.V(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}getCenterElevation(){return this.transform.elevation}setCenterElevation(e,t){return this.jumpTo({elevation:e},t),this}getCenterClampedToGround(){return this._centerClampedToGround}setCenterClampedToGround(e){this._centerClampedToGround=e;}panBy(e,i,a){return e=t.P.convert(e).mult(-1),this.panTo(this.transform.center,t.e({offset:e},i),a)}panTo(e,i,a){return this.easeTo(t.e({center:e},i),a)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(e,i,a){return this.easeTo(t.e({zoom:e},i),a)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getVerticalFieldOfView(){return this.transform.fov}setVerticalFieldOfView(e,i){return e!=this.transform.fov&&(this.transform.setFov(e),this.fire(new t.l("movestart",i)).fire(new t.l("move",i)).fire(new t.l("moveend",i))),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(e,i,a){return this.easeTo(t.e({bearing:e},i),a)}resetNorth(e,i){return this.rotateTo(0,t.e({duration:1e3},e),i),this}resetNorthPitch(e,i){return this.easeTo(t.e({bearing:0,pitch:0,roll:0,duration:1e3},e),i),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}getRoll(){return this.transform.roll}setRoll(e,t){return this.jumpTo({roll:e},t),this}cameraForBounds(e,t){e=$.convert(e).adjustAntiMeridian();const i=t&&t.bearing||0;return this._cameraForBoxAndBearing(e.getNorthWest(),e.getSouthEast(),i,t)}_cameraForBoxAndBearing(e,i,a,r){const o={top:0,bottom:0,right:0,left:0};if("number"==typeof(r=t.e({padding:o,offset:[0,0],maxZoom:this.transform.maxZoom},r)).padding){const e=r.padding;r.padding={top:e,bottom:e,right:e,left:e};}const s=t.e(o,r.padding);r.padding=s;const n=this.transform,l=new $(e,i);return this.cameraHelper.cameraForBoxAndBearing(r,s,l,a,n)}fitBounds(e,t,i){return this._fitInternal(this.cameraForBounds(e,t),t,i)}fitScreenCoordinates(e,i,a,r,o){return this._fitInternal(this._cameraForBoxAndBearing(this.transform.screenPointToLocation(t.P.convert(e)),this.transform.screenPointToLocation(t.P.convert(i)),a,r),r,o)}_fitInternal(e,i,a){return e?(delete(i=t.e(e,i)).padding,i.linear?this.easeTo(i,a):this.flyTo(i,a)):this}jumpTo(e,i){this.stop();const a=this._getTransformForUpdate();let r=!1,o=!1,s=!1;const n=a.zoom;this.cameraHelper.handleJumpToCenterZoom(a,e);const l=a.zoom!==n;return "elevation"in e&&a.elevation!==+e.elevation&&a.setElevation(+e.elevation),"bearing"in e&&a.bearing!==+e.bearing&&(r=!0,a.setBearing(+e.bearing)),"pitch"in e&&a.pitch!==+e.pitch&&(o=!0,a.setPitch(+e.pitch)),"roll"in e&&a.roll!==+e.roll&&(s=!0,a.setRoll(+e.roll)),null==e.padding||a.isPaddingEqual(e.padding)||a.setPadding(e.padding),this._applyUpdatedTransform(a),this.fire(new t.l("movestart",i)).fire(new t.l("move",i)),l&&this.fire(new t.l("zoomstart",i)).fire(new t.l("zoom",i)).fire(new t.l("zoomend",i)),r&&this.fire(new t.l("rotatestart",i)).fire(new t.l("rotate",i)).fire(new t.l("rotateend",i)),o&&this.fire(new t.l("pitchstart",i)).fire(new t.l("pitch",i)).fire(new t.l("pitchend",i)),s&&this.fire(new t.l("rollstart",i)).fire(new t.l("roll",i)).fire(new t.l("rollend",i)),this.fire(new t.l("moveend",i))}calculateCameraOptionsFromTo(e,i,a,r=0){const o=t.aa.fromLngLat(e,i),s=t.aa.fromLngLat(a,r),n=s.x-o.x,l=s.y-o.y,c=s.z-o.z,h=Math.hypot(n,l,c);if(0===h)throw new Error("Can't calculate camera options with same From and To");const u=Math.hypot(n,l),d=t.at(this.transform.cameraToCenterDistance/h/this.transform.tileSize),_=180*Math.atan2(n,-l)/Math.PI;let p=180*Math.acos(u/h)/Math.PI;return p=c<0?90-p:90+p,{center:s.toLngLat(),elevation:r,zoom:d,pitch:p,bearing:_}}calculateCameraOptionsFromCameraLngLatAltRotation(e,t,i,a,r){const o=this.transform.calculateCenterFromCameraLngLatAlt(e,t,i,a);return {center:o.center,elevation:o.elevation,zoom:o.zoom,bearing:i,pitch:a,roll:r}}easeTo(e,i){this._stop(!1,e.easeId),(!1===(e=t.e({offset:[0,0],duration:500,easing:t.cx},e)).animate||!e.essential&&n.prefersReducedMotion)&&(e.duration=0);const a=this._getTransformForUpdate(),r=this.getBearing(),o=a.pitch,s=a.roll,l="bearing"in e?this._normalizeBearing(e.bearing,r):r,c="pitch"in e?+e.pitch:o,h="roll"in e?this._normalizeBearing(e.roll,s):s,u="padding"in e?e.padding:a.padding,d=t.P.convert(e.offset);let _,p;e.around&&(_=t.V.convert(e.around),p=a.locationToScreenPoint(_));const m={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching,rolling:this._rolling},f=this.cameraHelper.handleEaseTo(a,{bearing:l,pitch:c,roll:h,padding:u,around:_,aroundPoint:p,offsetAsPoint:d,offset:e.offset,zoom:e.zoom,center:e.center});return this._rotating=this._rotating||r!==l,this._pitching=this._pitching||c!==o,this._rolling=this._rolling||h!==s,this._padding=!a.isPaddingEqual(u),this._zooming=this._zooming||f.isZooming,this._easeId=e.easeId,this._prepareEase(i,e.noMoveStart,m),this.terrain&&this._prepareElevation(f.elevationCenter),this._ease((t=>{f.easeFunc(t),this.terrain&&!e.freezeElevation&&this._updateElevation(t),this._applyUpdatedTransform(a),this._fireMoveEvents(i);}),(t=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(i,t);}),e),this}_prepareEase(e,i,a={}){this._moving=!0,i||a.moving||this.fire(new t.l("movestart",e)),this._zooming&&!a.zooming&&this.fire(new t.l("zoomstart",e)),this._rotating&&!a.rotating&&this.fire(new t.l("rotatestart",e)),this._pitching&&!a.pitching&&this.fire(new t.l("pitchstart",e)),this._rolling&&!a.rolling&&this.fire(new t.l("rollstart",e));}_prepareElevation(e){this._elevationCenter=e,this._elevationStart=this.transform.elevation,this._elevationTarget=this.terrain.getElevationForLngLatZoom(e,this.transform.tileZoom),this._elevationFreeze=!0;}_updateElevation(e){void 0!==this._elevationStart&&void 0!==this._elevationCenter||this._prepareElevation(this.transform.center),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom));const i=this.terrain.getElevationForLngLatZoom(this._elevationCenter,this.transform.tileZoom);if(e<1&&i!==this._elevationTarget){const t=this._elevationTarget-this._elevationStart;this._elevationStart+=e*(t-(i-(t*e+this._elevationStart))/(1-e)),this._elevationTarget=i;}this.transform.setElevation(t.G.number(this._elevationStart,this._elevationTarget,e));}_finalizeElevation(){this._elevationFreeze=!1,this.getCenterClampedToGround()&&this.transform.recalculateZoomAndCenter(this.terrain);}_getTransformForUpdate(){return this.transformCameraUpdate||this.terrain?(this._requestedCameraState||(this._requestedCameraState=this.transform.clone()),this._requestedCameraState):this.transform}_elevateCameraIfInsideTerrain(e){if(!this.terrain&&e.elevation>=0&&e.pitch<=90)return {};const t=e.getCameraLngLat(),i=e.getCameraAltitude(),a=this.terrain?this.terrain.getElevationForLngLatZoom(t,e.zoom):0;if(i<a){const i=this.calculateCameraOptionsFromTo(t,a,e.center,e.elevation);return {pitch:i.pitch,zoom:i.zoom}}return {}}_applyUpdatedTransform(e){const t=[];if(t.push((e=>this._elevateCameraIfInsideTerrain(e))),this.transformCameraUpdate&&t.push((e=>this.transformCameraUpdate(e))),!t.length)return;const i=e.clone();for(const e of t){const t=i.clone(),{center:a,zoom:r,roll:o,pitch:s,bearing:n,elevation:l}=e(t);a&&t.setCenter(a),void 0!==l&&t.setElevation(l),void 0!==r&&t.setZoom(r),void 0!==o&&t.setRoll(o),void 0!==s&&t.setPitch(s),void 0!==n&&t.setBearing(n),i.apply(t);}this.transform.apply(i);}_fireMoveEvents(e){this.fire(new t.l("move",e)),this._zooming&&this.fire(new t.l("zoom",e)),this._rotating&&this.fire(new t.l("rotate",e)),this._pitching&&this.fire(new t.l("pitch",e)),this._rolling&&this.fire(new t.l("roll",e));}_afterEase(e,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId;const a=this._zooming,r=this._rotating,o=this._pitching,s=this._rolling;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._rolling=!1,this._padding=!1,a&&this.fire(new t.l("zoomend",e)),r&&this.fire(new t.l("rotateend",e)),o&&this.fire(new t.l("pitchend",e)),s&&this.fire(new t.l("rollend",e)),this.fire(new t.l("moveend",e));}flyTo(e,i){if(!e.essential&&n.prefersReducedMotion){const a=t.U(e,["center","zoom","bearing","pitch","roll","elevation","padding"]);return this.jumpTo(a,i)}this.stop(),e=t.e({offset:[0,0],speed:1.2,curve:1.42,easing:t.cx},e);const a=this._getTransformForUpdate(),r=a.bearing,o=a.pitch,s=a.roll,l=a.padding,c="bearing"in e?this._normalizeBearing(e.bearing,r):r,h="pitch"in e?+e.pitch:o,u="roll"in e?this._normalizeBearing(e.roll,s):s,d="padding"in e?e.padding:a.padding,_=t.P.convert(e.offset);let p=a.centerPoint.add(_);const m=a.screenPointToLocation(p),f=this.cameraHelper.handleFlyTo(a,{bearing:c,pitch:h,roll:u,padding:d,locationAtOffset:m,offsetAsPoint:_,center:e.center,minZoom:e.minZoom,zoom:e.zoom});let g=e.curve;const v=Math.max(a.width,a.height),x=v/f.scaleOfZoom,b=f.pixelPathLength;"number"==typeof f.scaleOfMinZoom&&(g=Math.sqrt(v/f.scaleOfMinZoom/b*2));const y=g*g;function w(e){const t=(x*x-v*v+(e?-1:1)*y*y*b*b)/(2*(e?x:v)*y*b);return Math.log(Math.sqrt(t*t+1)-t)}function T(e){return (Math.exp(e)-Math.exp(-e))/2}function P(e){return (Math.exp(e)+Math.exp(-e))/2}const C=w(!1);let M=function(e){return P(C)/P(C+g*e)},I=function(e){return v*((P(C)*(T(t=C+g*e)/P(t))-T(C))/y)/b;var t;},E=(w(!0)-C)/g;if(Math.abs(b)<2e-6||!isFinite(E)){if(Math.abs(v-x)<1e-6)return this.easeTo(e,i);const t=x<v?-1:1;E=Math.abs(Math.log(x/v))/g,I=()=>0,M=e=>Math.exp(t*g*e);}return e.duration="duration"in e?+e.duration:1e3*E/("screenSpeed"in e?+e.screenSpeed/g:+e.speed),e.maxDuration&&e.duration>e.maxDuration&&(e.duration=0),this._zooming=!0,this._rotating=r!==c,this._pitching=h!==o,this._rolling=u!==s,this._padding=!a.isPaddingEqual(d),this._prepareEase(i,!1),this.terrain&&this._prepareElevation(f.targetCenter),this._ease((n=>{const m=n*E,g=1/M(m),v=I(m);this._rotating&&a.setBearing(t.G.number(r,c,n)),this._pitching&&a.setPitch(t.G.number(o,h,n)),this._rolling&&a.setRoll(t.G.number(s,u,n)),this._padding&&(a.interpolatePadding(l,d,n),p=a.centerPoint.add(_)),f.easeFunc(n,g,v,p),this.terrain&&!e.freezeElevation&&this._updateElevation(n),this._applyUpdatedTransform(a),this._fireMoveEvents(i);}),(()=>{this.terrain&&e.freezeElevation&&this._finalizeElevation(),this._afterEase(i);}),e),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(e,t){var i;if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const e=this._onEaseEnd;delete this._onEaseEnd,e.call(this,t);}return e||null===(i=this.handlers)||void 0===i||i.stop(!1),this}_ease(e,t,i){!1===i.animate||0===i.duration?(e(1),t()):(this._easeStart=c(),this._easeOptions=i,this._onEaseFrame=e,this._onEaseEnd=t,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_normalizeBearing(e,i){e=t.W(e,-180,180);const a=Math.abs(e-i);return Math.abs(e-360-i)<a&&(e-=360),Math.abs(e+360-i)<a&&(e+=360),e}queryTerrainElevation(e){return this.terrain?this.terrain.getElevationForLngLatZoom(t.V.convert(e),this.transform.tileZoom):null}}const Vo={compact:!0,customAttribution:'<a href="https://maplibre.org/" target="_blank">MapLibre</a>'};class qo{constructor(e=Vo){this._toggleAttribution=()=>{this._container.classList.contains("maplibregl-compact")&&(this._container.classList.contains("maplibregl-compact-show")?(this._container.setAttribute("open",""),this._container.classList.remove("maplibregl-compact-show")):(this._container.classList.add("maplibregl-compact-show"),this._container.removeAttribute("open")));},this._updateData=e=>{!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType&&"terrain"!==e.type||this._updateAttributions();},this._updateCompact=()=>{this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1===this._compact?this._container.setAttribute("open",""):this._container.classList.contains("maplibregl-compact")||this._container.classList.contains("maplibregl-attrib-empty")||(this._container.setAttribute("open",""),this._container.classList.add("maplibregl-compact","maplibregl-compact-show")):(this._container.setAttribute("open",""),this._container.classList.contains("maplibregl-compact")&&this._container.classList.remove("maplibregl-compact","maplibregl-compact-show"));},this._updateCompactMinimize=()=>{this._container.classList.contains("maplibregl-compact")&&this._container.classList.contains("maplibregl-compact-show")&&this._container.classList.remove("maplibregl-compact-show");},this.options=e;}getDefaultPosition(){return "bottom-right"}onAdd(e){return this._map=e,this._compact=this.options.compact,this._container=h.create("details","maplibregl-ctrl maplibregl-ctrl-attrib"),this._compactButton=h.create("summary","maplibregl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=h.create("div","maplibregl-ctrl-attrib-inner",this._container),this._updateAttributions(),this._updateCompact(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("terrain",this._updateData),this._map.on("resize",this._updateCompact),this._map.on("drag",this._updateCompactMinimize),this._container}onRemove(){h.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("terrain",this._updateData),this._map.off("resize",this._updateCompact),this._map.off("drag",this._updateCompactMinimize),this._map=void 0,this._compact=void 0,this._attribHTML=void 0;}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.title=i,e.setAttribute("aria-label",i);}_updateAttributions(){if(!this._map.style)return;let e=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=e.concat(this.options.customAttribution.map((e=>"string"!=typeof e?"":e))):"string"==typeof this.options.customAttribution&&e.push(this.options.customAttribution)),this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id;}const t=this._map.style.tileManagers;for(const i in t){const a=t[i];if(a.used||a.usedForTerrain){const t=a.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution);}}e=e.filter((e=>String(e).trim())),e.sort(((e,t)=>e.length-t.length)),e=e.filter(((t,i)=>{for(let a=i+1;a<e.length;a++)if(e[a].indexOf(t)>=0)return !1;return !0}));const i=e.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,e.length?(this._innerContainer.innerHTML=h.sanitize(i),this._container.classList.remove("maplibregl-attrib-empty")):this._container.classList.add("maplibregl-attrib-empty"),this._updateCompact(),this._editLink=null);}}class Wo{constructor(e={}){this._updateCompact=()=>{const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<=640||this._compact?!1!==this._compact&&t.classList.add("maplibregl-compact"):t.classList.remove("maplibregl-compact");}},this.options=e;}getDefaultPosition(){return "bottom-left"}onAdd(e){this._map=e,this._compact=this.options&&this.options.compact,this._container=h.create("div","maplibregl-ctrl");const t=h.create("a","maplibregl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://maplibre.org/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="block",this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){h.remove(this._container),this._map.off("resize",this._updateCompact),this._map=void 0,this._compact=void 0;}}class $o{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){if(this._currentlyRunning)throw new Error("Attempting to run(), but is already running.");const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}var Ho=t.aT([{name:"a_pos3d",type:"Int16",components:3}]);class Xo extends t.E{constructor(e){super(),this._lastTilesetChange=c(),this.tileManager=e,this._tiles={},this._renderableTilesKeys=[],this._sourceTileCache={},this.minzoom=0,this.maxzoom=22,this.deltaZoom=1,this.tileSize=e._source.tileSize*2**this.deltaZoom,e.usedForTerrain=!0,e.tileSize=this.tileSize;}destruct(){this.tileManager.usedForTerrain=!1,this.tileManager.tileSize=null;}getSource(){return this.tileManager._source}update(e,i){this.tileManager.update(e,i),this._renderableTilesKeys=[];const a={};for(const r of Ce(e,{tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,reparseOverscaled:!1,terrain:i,calculateTileZoom:this.tileManager._source.calculateTileZoom}))a[r.key]=!0,this._renderableTilesKeys.push(r.key),this._tiles[r.key]||(r.terrainRttPosMatrix32f=new Float64Array(16),t.c6(r.terrainRttPosMatrix32f,0,t.a4,t.a4,0,0,1),this._tiles[r.key]=new de(r,this.tileSize),this._lastTilesetChange=c());for(const e in this._tiles)a[e]||delete this._tiles[e];}freeRtt(e){for(const t in this._tiles){const i=this._tiles[t];(!e||i.tileID.equals(e)||i.tileID.isChildOf(e)||e.isChildOf(i.tileID))&&(i.rtt=[]);}}getRenderableTiles(){return this._renderableTilesKeys.map((e=>this.getTileByID(e)))}getTileByID(e){return this._tiles[e]}getTerrainCoords(e,t){return t?this._getTerrainCoordsForTileRanges(e,t):this._getTerrainCoordsForRegularTile(e)}_getTerrainCoordsForRegularTile(e){const i={};for(const a of this._renderableTilesKeys){const r=this._tiles[a].tileID,o=e.clone(),s=t.bj();if(r.canonical.equals(e.canonical))t.c6(s,0,t.a4,t.a4,0,0,1);else if(r.canonical.isChildOf(e.canonical)){const i=r.canonical.z-e.canonical.z,a=r.canonical.x-(r.canonical.x>>i<<i),o=r.canonical.y-(r.canonical.y>>i<<i),n=t.a4>>i;t.c6(s,0,n,n,0,0,1),t.O(s,s,[-a*n,-o*n,0]);}else {if(!e.canonical.isChildOf(r.canonical))continue;{const i=e.canonical.z-r.canonical.z,a=e.canonical.x-(e.canonical.x>>i<<i),o=e.canonical.y-(e.canonical.y>>i<<i),n=t.a4>>i;t.c6(s,0,t.a4,t.a4,0,0,1),t.O(s,s,[a*n,o*n,0]),t.Q(s,s,[1/2**i,1/2**i,0]);}}o.terrainRttPosMatrix32f=new Float32Array(s),i[a]=o;}return i}_getTerrainCoordsForTileRanges(e,i){const a={};for(const r of this._renderableTilesKeys){const o=this._tiles[r].tileID;if(!this._isWithinTileRanges(o,i))continue;const s=e.clone(),n=t.bj();if(o.canonical.z===e.canonical.z){const i=e.canonical.x-o.canonical.x,a=e.canonical.y-o.canonical.y;t.c6(n,0,t.a4,t.a4,0,0,1),t.O(n,n,[i*t.a4,a*t.a4,0]);}else if(o.canonical.z>e.canonical.z){const i=o.canonical.z-e.canonical.z,a=o.canonical.x-(o.canonical.x>>i<<i),r=o.canonical.y-(o.canonical.y>>i<<i),s=e.canonical.x-(o.canonical.x>>i),l=e.canonical.y-(o.canonical.y>>i),c=t.a4>>i;t.c6(n,0,c,c,0,0,1),t.O(n,n,[-a*c+s*t.a4,-r*c+l*t.a4,0]);}else {const i=e.canonical.z-o.canonical.z,a=e.canonical.x-(e.canonical.x>>i<<i),r=e.canonical.y-(e.canonical.y>>i<<i),s=(e.canonical.x>>i)-o.canonical.x,l=(e.canonical.y>>i)-o.canonical.y,c=t.a4<<i;t.c6(n,0,c,c,0,0,1),t.O(n,n,[a*t.a4+s*c,r*t.a4+l*c,0]);}s.terrainRttPosMatrix32f=new Float32Array(n),a[r]=s;}return a}getSourceTile(e,t){const i=this.tileManager._source;let a=e.overscaledZ-this.deltaZoom;if(a>i.maxzoom&&(a=i.maxzoom),a<i.minzoom)return null;this._sourceTileCache[e.key]||(this._sourceTileCache[e.key]=e.scaledTo(a).key);let r=this.tileManager.getTileByID(this._sourceTileCache[e.key]);if((!r||!r.dem)&&t)for(;a>=i.minzoom&&(!r||!r.dem);)r=this.tileManager.getTileByID(e.scaledTo(a--).key);return r}anyTilesAfterTime(e=Date.now()){return this._lastTilesetChange>=e}_isWithinTileRanges(e,t){return t[e.canonical.z]&&e.canonical.x>=t[e.canonical.z].minTileX&&e.canonical.x<=t[e.canonical.z].maxTileX&&e.canonical.y>=t[e.canonical.z].minTileY&&e.canonical.y<=t[e.canonical.z].maxTileY}}class Ko{constructor(e,t,i){this._meshCache={},this.painter=e,this.tileManager=new Xo(t),this.options=i,this.exaggeration="number"==typeof i.exaggeration?i.exaggeration:1,this.qualityFactor=2,this.meshSize=128,this._demMatrixCache={},this.coordsIndex=[],this._coordsTextureSize=1024;}getDEMElevation(e,i,a,r=t.a4){var o;if(!(i>=0&&i<r&&a>=0&&a<r))return 0;const s=this.getTerrainData(e),n=null===(o=s.tile)||void 0===o?void 0:o.dem;if(!n)return 0;const l=t.cB([],[i/r*t.a4,a/r*t.a4],s.u_terrain_matrix),c=[l[0]*n.dim,l[1]*n.dim],h=Math.floor(c[0]),u=Math.floor(c[1]),d=c[0]-h,_=c[1]-u;return n.get(h,u)*(1-d)*(1-_)+n.get(h+1,u)*d*(1-_)+n.get(h,u+1)*(1-d)*_+n.get(h+1,u+1)*d*_}getElevationForLngLatZoom(e,i){if(!t.cC(i,e.wrap()))return 0;const{tileID:a,mercatorX:r,mercatorY:o}=this._getOverscaledTileIDFromLngLatZoom(e,i);return this.getElevation(a,r%t.a4,o%t.a4,t.a4)}getElevation(e,i,a,r=t.a4){return this.getDEMElevation(e,i,a,r)*this.exaggeration}getTerrainData(e){if(!this._emptyDemTexture){const e=this.painter.context,i=new t.R({width:1,height:1},new Uint8Array(4));this._emptyDepthTexture=new t.T(e,i,e.gl.RGBA,{premultiply:!1}),this._emptyDemUnpack=[0,0,0,0],this._emptyDemTexture=new t.T(e,new t.R({width:1,height:1}),e.gl.RGBA,{premultiply:!1}),this._emptyDemTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._emptyDemMatrix=t.ar([]);}const i=this.tileManager.getSourceTile(e,!0);if(i&&i.dem&&(!i.demTexture||i.needsTerrainPrepare)){const e=this.painter.context;i.demTexture=this.painter.getTileTexture(i.dem.stride),i.demTexture?i.demTexture.update(i.dem.getPixels(),{premultiply:!1}):i.demTexture=new t.T(e,i.dem.getPixels(),e.gl.RGBA,{premultiply:!1}),i.demTexture.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),i.needsTerrainPrepare=!1;}const a=i&&i+i.tileID.key+e.key;if(a&&!this._demMatrixCache[a]){const a=this.tileManager.getSource().maxzoom;let r=e.canonical.z-i.tileID.canonical.z;e.overscaledZ>e.canonical.z&&(e.canonical.z>=a?r=e.canonical.z-a:t.w("cannot calculate elevation if elevation maxzoom > source.maxzoom"));const o=e.canonical.x-(e.canonical.x>>r<<r),s=e.canonical.y-(e.canonical.y>>r<<r),n=t.cD(new Float64Array(16),[1/(t.a4<<r),1/(t.a4<<r),0]);t.O(n,n,[o*t.a4,s*t.a4,0]),this._demMatrixCache[e.key]={matrix:n,coord:e};}return {u_depth:2,u_terrain:3,u_terrain_dim:i&&i.dem&&i.dem.dim||1,u_terrain_matrix:a?this._demMatrixCache[e.key].matrix:this._emptyDemMatrix,u_terrain_unpack:i&&i.dem&&i.dem.getUnpackVector()||this._emptyDemUnpack,u_terrain_exaggeration:this.exaggeration,texture:(i&&i.demTexture||this._emptyDemTexture).texture,depthTexture:(this._fboDepthTexture||this._emptyDepthTexture).texture,tile:i}}getFramebuffer(e){const i=this.painter,a=i.width/devicePixelRatio,r=i.height/devicePixelRatio;return !this._fbo||this._fbo.width===a&&this._fbo.height===r||(this._fbo.destroy(),this._fboCoordsTexture.destroy(),this._fboDepthTexture.destroy(),delete this._fbo,delete this._fboDepthTexture,delete this._fboCoordsTexture),this._fboCoordsTexture||(this._fboCoordsTexture=new t.T(i.context,{width:a,height:r,data:null},i.context.gl.RGBA,{premultiply:!1}),this._fboCoordsTexture.bind(i.context.gl.NEAREST,i.context.gl.CLAMP_TO_EDGE)),this._fboDepthTexture||(this._fboDepthTexture=new t.T(i.context,{width:a,height:r,data:null},i.context.gl.RGBA,{premultiply:!1}),this._fboDepthTexture.bind(i.context.gl.NEAREST,i.context.gl.CLAMP_TO_EDGE)),this._fbo||(this._fbo=i.context.createFramebuffer(a,r,!0,!1),this._fbo.depthAttachment.set(i.context.createRenderbuffer(i.context.gl.DEPTH_COMPONENT16,a,r))),this._fbo.colorAttachment.set("coords"===e?this._fboCoordsTexture.texture:this._fboDepthTexture.texture),this._fbo}getCoordsTexture(){const e=this.painter.context;if(this._coordsTexture)return this._coordsTexture;const i=new Uint8Array(this._coordsTextureSize*this._coordsTextureSize*4);for(let e=0,t=0;e<this._coordsTextureSize;e++)for(let a=0;a<this._coordsTextureSize;a++,t+=4)i[t+0]=255&a,i[t+1]=255&e,i[t+2]=a>>8<<4|e>>8,i[t+3]=0;const a=new t.R({width:this._coordsTextureSize,height:this._coordsTextureSize},new Uint8Array(i.buffer)),r=new t.T(e,a,e.gl.RGBA,{premultiply:!1});return r.bind(e.gl.NEAREST,e.gl.CLAMP_TO_EDGE),this._coordsTexture=r,r}pointCoordinate(e){this.painter.maybeDrawDepthAndCoords(!0);const i=new Uint8Array(4),a=this.painter.context,r=a.gl,o=Math.round(e.x*this.painter.pixelRatio/devicePixelRatio),s=Math.round(e.y*this.painter.pixelRatio/devicePixelRatio),n=Math.round(this.painter.height/devicePixelRatio);a.bindFramebuffer.set(this.getFramebuffer("coords").framebuffer),r.readPixels(o,n-s-1,1,1,r.RGBA,r.UNSIGNED_BYTE,i),a.bindFramebuffer.set(null);const l=i[0]+(i[2]>>4<<8),c=i[1]+((15&i[2])<<8),h=this.coordsIndex[255-i[3]],u=h&&this.tileManager.getTileByID(h);if(!u)return null;const d=this._coordsTextureSize,_=(1<<u.tileID.canonical.z)*d;return new t.aa((u.tileID.canonical.x*d+l)/_+u.tileID.wrap,(u.tileID.canonical.y*d+c)/_,this.getElevation(u.tileID,l,c,d))}depthAtPoint(e){const t=new Uint8Array(4),i=this.painter.context,a=i.gl;return i.bindFramebuffer.set(this.getFramebuffer("depth").framebuffer),a.readPixels(e.x,this.painter.height/devicePixelRatio-e.y-1,1,1,a.RGBA,a.UNSIGNED_BYTE,t),i.bindFramebuffer.set(null),(t[0]/16777216+t[1]/65536+t[2]/256+t[3])/256}getTerrainMesh(e){var i;const a=(null===(i=this.painter.style.projection)||void 0===i?void 0:i.transitionState)>0,r=a&&0===e.canonical.y,o=a&&e.canonical.y===(1<<e.canonical.z)-1,s=`m_${r?"n":""}_${o?"s":""}`;if(this._meshCache[s])return this._meshCache[s];const n=this.painter.context,l=new t.cE,c=new t.aX,h=this.meshSize,u=t.a4/h,d=h*h;for(let e=0;e<=h;e++)for(let t=0;t<=h;t++)l.emplaceBack(t*u,e*u,0);for(let e=0;e<d;e+=h+1)for(let t=0;t<h;t++)c.emplaceBack(t+e,h+t+e+1,h+t+e+2),c.emplaceBack(t+e,h+t+e+2,t+e+1);const _=l.length,p=_+(h+1),m=(h+1)*h,f=r?t.bq:0,g=r?0:1,v=o?t.br:t.a4,x=o?0:1;for(let e=0;e<=h;e++)l.emplaceBack(e*u,f,g);for(let e=0;e<=h;e++)l.emplaceBack(e*u,v,x);for(let e=0;e<h;e++)c.emplaceBack(m+e,p+e,p+e+1),c.emplaceBack(m+e,p+e+1,m+e+1),c.emplaceBack(0+e,_+e+1,_+e),c.emplaceBack(0+e,0+e+1,_+e+1);const b=l.length,y=b+2*(h+1);for(const e of [0,1])for(let i=0;i<=h;i++)for(const a of [0,1])l.emplaceBack(e*t.a4,i*u,a);for(let e=0;e<2*h;e+=2)c.emplaceBack(b+e,b+e+1,b+e+3),c.emplaceBack(b+e,b+e+3,b+e+2),c.emplaceBack(y+e,y+e+3,y+e+1),c.emplaceBack(y+e,y+e+2,y+e+3);const w=new St(n.createVertexBuffer(l,Ho.members),n.createIndexBuffer(c),t.aW.simpleSegment(0,0,l.length,c.length));return this._meshCache[s]=w,w}getMeshFrameDelta(e){return 2*Math.PI*t.bD/Math.pow(2,Math.max(e,0))/5}getMinTileElevationForLngLatZoom(e,t){var i;const{tileID:a}=this._getOverscaledTileIDFromLngLatZoom(e,t);return null!==(i=this.getMinMaxElevation(a).minElevation)&&void 0!==i?i:0}getMinMaxElevation(e){const t=this.getTerrainData(e).tile,i={minElevation:null,maxElevation:null};return t&&t.dem&&(i.minElevation=t.dem.min*this.exaggeration,i.maxElevation=t.dem.max*this.exaggeration),i}_getOverscaledTileIDFromLngLatZoom(e,i){const a=t.aa.fromLngLat(e.wrap()),r=(1<<i)*t.a4,o=a.x*r,s=a.y*r,n=Math.floor(o/t.a4),l=Math.floor(s/t.a4);return {tileID:new t.a1(i,0,i,n,l),mercatorX:o,mercatorY:s}}}class Yo{constructor(e,t,i){this._context=e,this._size=t,this._tileSize=i,this._objects=[],this._recentlyUsed=[],this._stamp=0;}destruct(){for(const e of this._objects)e.texture.destroy(),e.fbo.destroy();}_createObject(e){const i=this._context.createFramebuffer(this._tileSize,this._tileSize,!0,!0),a=new t.T(this._context,{width:this._tileSize,height:this._tileSize,data:null},this._context.gl.RGBA);return a.bind(this._context.gl.LINEAR,this._context.gl.CLAMP_TO_EDGE),this._context.extTextureFilterAnisotropic&&this._context.gl.texParameterf(this._context.gl.TEXTURE_2D,this._context.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,this._context.extTextureFilterAnisotropicMax),i.depthAttachment.set(this._context.createRenderbuffer(this._context.gl.DEPTH_STENCIL,this._tileSize,this._tileSize)),i.colorAttachment.set(a.texture),{id:e,fbo:i,texture:a,stamp:-1,inUse:!1}}getObjectForId(e){return this._objects[e]}useObject(e){e.inUse=!0,this._recentlyUsed=this._recentlyUsed.filter((t=>e.id!==t)),this._recentlyUsed.push(e.id);}stampObject(e){e.stamp=++this._stamp;}getOrCreateFreeObject(){for(const e of this._recentlyUsed)if(!this._objects[e].inUse)return this._objects[e];if(this._objects.length>=this._size)throw new Error("No free RenderPool available, call freeAllObjects() required!");const e=this._createObject(this._objects.length);return this._objects.push(e),e}freeObject(e){e.inUse=!1;}freeAllObjects(){for(const e of this._objects)this.freeObject(e);}isFull(){return !(this._objects.length<this._size)&&!1===this._objects.some((e=>!e.inUse))}}const Qo={background:!0,fill:!0,line:!0,raster:!0,hillshade:!0,"color-relief":!0};class Jo{constructor(e,t){this.painter=e,this.terrain=t,this.pool=new Yo(e.context,30,t.tileManager.tileSize*t.qualityFactor);}destruct(){this.pool.destruct();}getTexture(e){return this.pool.getObjectForId(e.rtt[this._stacks.length-1].id).texture}prepareForRender(e,t){this._stacks=[],this._prevType=null,this._rttTiles=[],this._renderableTiles=this.terrain.tileManager.getRenderableTiles(),this._renderableLayerIds=e._order.filter((i=>!e._layers[i].isHidden(t))),this._coordsAscending={};for(const t in e.tileManagers){this._coordsAscending[t]={};const i=e.tileManagers[t].getVisibleCoordinates(),a=e.tileManagers[t].getSource(),r=a instanceof te?a.terrainTileRanges:null;for(const e of i){const i=this.terrain.tileManager.getTerrainCoords(e,r);for(const e in i)this._coordsAscending[t][e]||(this._coordsAscending[t][e]=[]),this._coordsAscending[t][e].push(i[e]);}}this._coordsAscendingStr={};for(const t of e._order){const i=e._layers[t],a=i.source;if(Qo[i.type]&&!this._coordsAscendingStr[a]){this._coordsAscendingStr[a]={};for(const e in this._coordsAscending[a])this._coordsAscendingStr[a][e]=this._coordsAscending[a][e].map((e=>e.key)).sort().join();}}for(const e of this._renderableTiles)for(const t in this._coordsAscendingStr){const i=this._coordsAscendingStr[t][e.tileID.key];i&&i!==e.rttCoords[t]&&(e.rtt=[]);}}renderLayer(e,i){if(e.isHidden(this.painter.transform.zoom))return !1;const a=Object.assign(Object.assign({},i),{isRenderingToTexture:!0}),r=e.type,o=this.painter,s=this._renderableLayerIds[this._renderableLayerIds.length-1]===e.id;if(Qo[r]&&(this._prevType&&Qo[this._prevType]||this._stacks.push([]),this._prevType=r,this._stacks[this._stacks.length-1].push(e.id),!s))return !0;if(Qo[this._prevType]||Qo[r]&&s){this._prevType=r;const e=this._stacks.length-1,i=this._stacks[e]||[];for(const r of this._renderableTiles){if(this.pool.isFull()&&(Br(this.painter,this.terrain,this._rttTiles,a),this._rttTiles=[],this.pool.freeAllObjects()),this._rttTiles.push(r),r.rtt[e]){const t=this.pool.getObjectForId(r.rtt[e].id);if(t.stamp===r.rtt[e].stamp){this.pool.useObject(t);continue}}const s=this.pool.getOrCreateFreeObject();this.pool.useObject(s),this.pool.stampObject(s),r.rtt[e]={id:s.id,stamp:s.stamp},o.context.bindFramebuffer.set(s.fbo.framebuffer),o.context.clear({color:t.bo.transparent,stencil:0}),o.currentStencilSource=void 0;for(let e=0;e<i.length;e++){const t=o.style._layers[i[e]],n=t.source?this._coordsAscending[t.source][r.tileID.key]:[r.tileID];o.context.viewport.set([0,0,s.fbo.width,s.fbo.height]),o._renderTileClippingMasks(t,n,!0),o.renderLayer(o,o.style.tileManagers[t.source],t,n,a),t.source&&(r.rttCoords[t.source]=this._coordsAscendingStr[t.source][r.tileID.key]);}}return Br(this.painter,this.terrain,this._rttTiles,a),this._rttTiles=[],this.pool.freeAllObjects(),Qo[r]}return !1}}const es={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"MapLibre logo","Map.Title":"Map","Marker.Title":"Map marker","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","Popup.Close":"Close popup","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm","GlobeControl.Enable":"Enable globe","GlobeControl.Disable":"Disable globe","TerrainControl.Enable":"Enable terrain","TerrainControl.Disable":"Disable terrain","CooperativeGesturesHandler.WindowsHelpText":"Use Ctrl + scroll to zoom the map","CooperativeGesturesHandler.MacHelpText":"Use ⌘ + scroll to zoom the map","CooperativeGesturesHandler.MobileHelpText":"Use two fingers to move the map"},ts=i,is={hash:!1,interactive:!0,bearingSnap:7,attributionControl:Vo,maplibreLogo:!1,refreshExpiredTiles:!0,canvasContextAttributes:{antialias:!1,preserveDrawingBuffer:!1,powerPreference:"high-performance",failIfMajorPerformanceCaveat:!1,desynchronized:!1,contextType:void 0},scrollZoom:!0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:60,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,cooperativeGestures:!1,trackResize:!0,center:[0,0],elevation:0,zoom:0,bearing:0,pitch:0,roll:0,renderWorldCopies:!0,maxTileCacheSize:null,maxTileCacheZoomLevels:t.a.MAX_TILE_CACHE_ZOOM_LEVELS,transformRequest:null,transformCameraUpdate:null,transformConstrain:null,fadeDuration:300,crossSourceCollisions:!0,clickTolerance:3,localIdeographFontFamily:"sans-serif",pitchWithRotate:!0,rollEnabled:!1,reduceMotion:void 0,validateStyle:!0,maxCanvasSize:[4096,4096],cancelPendingTileRequestsWhileZooming:!0,centerClampedToGround:!0,experimentalZoomLevelsToOverscale:void 0},as={showCompass:!0,showZoom:!0,visualizePitch:!1,visualizeRoll:!0};class rs{constructor(e,i,a=!1){this.mousedown=e=>{this.startMove(e,h.mousePos(this.element,e)),h.addEventListener(window,"mousemove",this.mousemove),h.addEventListener(window,"mouseup",this.mouseup);},this.mousemove=e=>{this.move(e,h.mousePos(this.element,e));},this.mouseup=e=>{this._rotatePitchHandler.dragEnd(e),this.offTemp();},this.touchstart=e=>{1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=h.touchPos(this.element,e.targetTouches)[0],this.startMove(e,this._startPos),h.addEventListener(window,"touchmove",this.touchmove,{passive:!1}),h.addEventListener(window,"touchend",this.touchend));},this.touchmove=e=>{1!==e.targetTouches.length?this.reset():(this._lastPos=h.touchPos(this.element,e.targetTouches)[0],this.move(e,this._lastPos));},this.touchend=e=>{0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),delete this._startPos,delete this._lastPos,this.offTemp();},this.reset=()=>{this._rotatePitchHandler.reset(),delete this._startPos,delete this._lastPos,this.offTemp();},this._clickTolerance=10,this.element=i;const r=new mo;this._rotatePitchHandler=new lo({clickTolerance:3,move:(e,r)=>{const o=i.getBoundingClientRect(),s=new t.P((o.bottom-o.top)/2,(o.right-o.left)/2);return {bearingDelta:t.cw(new t.P(e.x,r.y),r,s),pitchDelta:a?-.5*(r.y-e.y):void 0}},moveStateManager:r,enable:!0,assignEvents:()=>{}}),this.map=e,h.addEventListener(i,"mousedown",this.mousedown),h.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),h.addEventListener(i,"touchcancel",this.reset);}startMove(e,t){this._rotatePitchHandler.dragStart(e,t),h.disableDrag();}move(e,t){const i=this.map,{bearingDelta:a,pitchDelta:r}=this._rotatePitchHandler.dragMove(e,t)||{};a&&i.setBearing(i.getBearing()+a),r&&i.setPitch(i.getPitch()+r);}off(){const e=this.element;h.removeEventListener(e,"mousedown",this.mousedown),h.removeEventListener(e,"touchstart",this.touchstart,{passive:!1}),h.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),h.removeEventListener(window,"touchend",this.touchend),h.removeEventListener(e,"touchcancel",this.reset),this.offTemp();}offTemp(){h.enableDrag(),h.removeEventListener(window,"mousemove",this.mousemove),h.removeEventListener(window,"mouseup",this.mouseup),h.removeEventListener(window,"touchmove",this.touchmove,{passive:!1}),h.removeEventListener(window,"touchend",this.touchend);}}let os;function ss(e,i,a,r=!1){if(r||!a.getCoveringTilesDetailsProvider().allowWorldCopies())return null==e?void 0:e.wrap();const o=new t.V(e.lng,e.lat);if(e=new t.V(e.lng,e.lat),i){const r=new t.V(e.lng-360,e.lat),o=new t.V(e.lng+360,e.lat),s=a.locationToScreenPoint(e).distSqr(i);a.locationToScreenPoint(r).distSqr(i)<s?e=r:a.locationToScreenPoint(o).distSqr(i)<s&&(e=o);}for(;Math.abs(e.lng-a.center.lng)>180;){const t=a.locationToScreenPoint(e);if(t.x>=0&&t.y>=0&&t.x<=a.width&&t.y<=a.height)break;e.lng>a.center.lng?e.lng-=360:e.lng+=360;}return e.lng!==o.lng&&a.isPointOnMapSurface(a.locationToScreenPoint(e))?e:o}const ns={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function ls(e,t,i){const a=e.classList;for(const e in ns)a.remove(`maplibregl-${i}-anchor-${e}`);a.add(`maplibregl-${i}-anchor-${t}`);}class cs extends t.E{constructor(e){if(super(),this._onKeyPress=e=>{const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup();},this._onMapClick=e=>{const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup();},this._update=e=>{if(!this._map)return;const t=this._map.loaded()&&!this._map.isMoving();("terrain"===(null==e?void 0:e.type)||"render"===(null==e?void 0:e.type)&&!t)&&this._map.once("render",this._update),this._lngLat=ss(this._lngLat,this._flatPos,this._map.transform),this._flatPos=this._pos=this._map.project(this._lngLat)._add(this._offset),this._map.terrain&&(this._flatPos=this._map.transform.locationToScreenPoint(this._lngLat)._add(this._offset));let i="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?i=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(i=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let a="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?a="rotateX(0deg)":"map"===this._pitchAlignment&&(a=`rotateX(${this._map.getPitch()}deg)`),this._subpixelPositioning||e&&"moveend"!==e.type||(this._pos=this._pos.round()),h.setTransform(this._element,`${ns[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${a} ${i}`),n.frameAsync(new AbortController).then((()=>{this._updateOpacity(e&&"moveend"===e.type);})).catch((()=>{}));},this._onMove=e=>{if(!this._isDragging){const t=this._clickTolerance||this._map._clickTolerance;this._isDragging=e.point.dist(this._pointerdownPos)>=t;}this._isDragging&&(this._pos=e.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new t.l("dragstart"))),this.fire(new t.l("drag")));},this._onUp=()=>{this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new t.l("dragend")),this._state="inactive";},this._addDragHandler=e=>{this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(this._pos).add(this._offset),this._pointerdownPos=e.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));},this._anchor=e&&e.anchor||"center",this._color=e&&e.color||"#3FB1CE",this._scale=e&&e.scale||1,this._draggable=e&&e.draggable||!1,this._clickTolerance=e&&e.clickTolerance||0,this._subpixelPositioning=e&&e.subpixelPositioning||!1,this._isDragging=!1,this._state="inactive",this._rotation=e&&e.rotation||0,this._rotationAlignment=e&&e.rotationAlignment||"auto",this._pitchAlignment=e&&e.pitchAlignment&&"auto"!==e.pitchAlignment?e.pitchAlignment:this._rotationAlignment,this.setOpacity(null==e?void 0:e.opacity,null==e?void 0:e.opacityWhenCovered),e&&e.element)this._element=e.element,this._offset=t.P.convert(e&&e.offset||[0,0]);else {this._defaultMarker=!0,this._element=h.create("div");const i=h.createNS("http://www.w3.org/2000/svg","svg"),a=41,r=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${a}px`),i.setAttributeNS(null,"width",`${r}px`),i.setAttributeNS(null,"viewBox",`0 0 ${r} ${a}`);const o=h.createNS("http://www.w3.org/2000/svg","g");o.setAttributeNS(null,"stroke","none"),o.setAttributeNS(null,"stroke-width","1"),o.setAttributeNS(null,"fill","none"),o.setAttributeNS(null,"fill-rule","evenodd");const s=h.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const n=h.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"transform","translate(3.0, 29.0)"),n.setAttributeNS(null,"fill","#000000");const l=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const e of l){const t=h.createNS("http://www.w3.org/2000/svg","ellipse");t.setAttributeNS(null,"opacity","0.04"),t.setAttributeNS(null,"cx","10.5"),t.setAttributeNS(null,"cy","5.80029008"),t.setAttributeNS(null,"rx",e.rx),t.setAttributeNS(null,"ry",e.ry),n.appendChild(t);}const c=h.createNS("http://www.w3.org/2000/svg","g");c.setAttributeNS(null,"fill",this._color);const u=h.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),c.appendChild(u);const d=h.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=h.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const p=h.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(6.0, 7.0)"),p.setAttributeNS(null,"fill","#FFFFFF");const m=h.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=h.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=h.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),m.appendChild(f),m.appendChild(g),s.appendChild(n),s.appendChild(c),s.appendChild(d),s.appendChild(p),s.appendChild(m),i.appendChild(s),i.setAttributeNS(null,"height",a*this._scale+"px"),i.setAttributeNS(null,"width",r*this._scale+"px"),this._element.appendChild(i),this._offset=t.P.convert(e&&e.offset||[0,-14]);}if(this._element.classList.add("maplibregl-marker"),this._element.addEventListener("dragstart",(e=>{e.preventDefault();})),this._element.addEventListener("mousedown",(e=>{e.preventDefault();})),ls(this._element,this._anchor,"marker"),e&&e.className)for(const t of e.className.split(" "))this._element.classList.add(t);this._popup=null;}addTo(e){return this.remove(),this._map=e,this._element.hasAttribute("aria-label")||this._element.setAttribute("aria-label",e._getUIString("Marker.Title")),this._element.hasAttribute("role")||this._element.setAttribute("role","button"),e.getCanvasContainer().appendChild(this._element),e.on("move",this._update),e.on("moveend",this._update),e.on("terrain",this._update),e.on("projectiontransition",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._opacityTimeout&&(clearTimeout(this._opacityTimeout),delete this._opacityTimeout),this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("terrain",this._update),this._map.off("projectiontransition",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),h.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(e){return this._lngLat=t.V.convert(e),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,a=Math.abs(i)/Math.SQRT2;e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-t],"bottom-left":[a,-1*(t-i+a)],"bottom-right":[-a,-1*(t-i+a)],left:[i,-1*(t-i)],right:[-i,-1*(t-i)]}:this._offset;}this._popup=e,this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}setSubpixelPositioning(e){return this._subpixelPositioning=e,this}getPopup(){return this._popup}togglePopup(){const e=this._popup;return this._element.style.opacity===this._opacityWhenCovered?this:e?(e.isOpen()?e.remove():(e.setLngLat(this._lngLat),e.addTo(this._map)),this):this}_updateOpacity(e=!1){var i,a;const r=null===(i=this._map)||void 0===i?void 0:i.terrain,o=this._map.transform.isLocationOccluded(this._lngLat);if(!r||o){const e=o?this._opacityWhenCovered:this._opacity;return void(this._element.style.opacity!==e&&(this._element.style.opacity=e))}if(e)this._opacityTimeout=null;else {if(this._opacityTimeout)return;this._opacityTimeout=setTimeout((()=>{this._opacityTimeout=null;}),100);}const s=this._map,n=s.terrain.depthAtPoint(this._pos),l=s.terrain.getElevationForLngLatZoom(this._lngLat,s.transform.tileZoom);if(s.transform.lngLatToCameraDepth(this._lngLat,l)-n<.006)return void(this._element.style.opacity=this._opacity);const c=-this._offset.y/s.transform.pixelsPerMeter,h=Math.sin(s.getPitch()*Math.PI/180)*c,u=s.terrain.depthAtPoint(new t.P(this._pos.x,this._pos.y-this._offset.y)),d=s.transform.lngLatToCameraDepth(this._lngLat,l+h)-u>.006;(null===(a=this._popup)||void 0===a?void 0:a.isOpen())&&d&&this._popup.remove(),this._element.style.opacity=d?this._opacityWhenCovered:this._opacity;}getOffset(){return this._offset}setOffset(e){return this._offset=t.P.convert(e),this._update(),this}addClassName(e){this._element.classList.add(e);}removeClassName(e){this._element.classList.remove(e);}toggleClassName(e){return this._element.classList.toggle(e)}setDraggable(e){return this._draggable=!!e,this._map&&(e?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e&&"auto"!==e?e:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}setOpacity(e,t){return (void 0===this._opacity||void 0===e&&void 0===t)&&(this._opacity="1",this._opacityWhenCovered="0.2"),void 0!==e&&(this._opacity=e),void 0!==t&&(this._opacityWhenCovered=t),this._map&&this._updateOpacity(!0),this}}const hs={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let us=0,ds=!1;const _s={maxWidth:100,unit:"metric"};function ps(e,t,i){const a=i&&i.maxWidth||100,r=e._container.clientHeight/2,o=e._container.clientWidth/2,s=e.unproject([o-a/2,r]),n=e.unproject([o+a/2,r]),l=Math.round(e.project(n).x-e.project(s).x),c=Math.min(a,l,e._container.clientWidth),h=s.distanceTo(n);if(i&&"imperial"===i.unit){const i=3.2808*h;i>5280?ms(t,c,i/5280,e._getUIString("ScaleControl.Miles")):ms(t,c,i,e._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?ms(t,c,h/1852,e._getUIString("ScaleControl.NauticalMiles")):h>=1e3?ms(t,c,h/1e3,e._getUIString("ScaleControl.Kilometers")):ms(t,c,h,e._getUIString("ScaleControl.Meters"));}function ms(e,t,i,a){const r=function(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}(i);e.style.width=t*(r/i)+"px",e.innerHTML=`${r}&nbsp;${a}`;}const fs={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px",subpixelPositioning:!1,locationOccludedOpacity:void 0},gs=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", ");function vs(e){if(e){if("number"==typeof e){const i=Math.round(Math.abs(e)/Math.SQRT2);return {center:new t.P(0,0),top:new t.P(0,e),"top-left":new t.P(i,i),"top-right":new t.P(-i,i),bottom:new t.P(0,-e),"bottom-left":new t.P(i,-i),"bottom-right":new t.P(-i,-i),left:new t.P(e,0),right:new t.P(-e,0)}}if(e instanceof t.P||Array.isArray(e)){const i=t.P.convert(e);return {center:i,top:i,"top-left":i,"top-right":i,bottom:i,"bottom-left":i,"bottom-right":i,left:i,right:i}}return {center:t.P.convert(e.center||[0,0]),top:t.P.convert(e.top||[0,0]),"top-left":t.P.convert(e["top-left"]||[0,0]),"top-right":t.P.convert(e["top-right"]||[0,0]),bottom:t.P.convert(e.bottom||[0,0]),"bottom-left":t.P.convert(e["bottom-left"]||[0,0]),"bottom-right":t.P.convert(e["bottom-right"]||[0,0]),left:t.P.convert(e.left||[0,0]),right:t.P.convert(e.right||[0,0])}}return vs(new t.P(0,0))}const xs=i;e.AJAXError=t.cI,e.Event=t.l,e.Evented=t.E,e.LngLat=t.V,e.MercatorCoordinate=t.aa,e.Point=t.P,e.addProtocol=t.cJ,e.config=t.a,e.removeProtocol=t.cK,e.AttributionControl=qo,e.BoxZoomHandler=ao,e.CanvasSource=ae,e.CooperativeGesturesHandler=Oo,e.DoubleClickZoomHandler=zo,e.DragPanHandler=ko,e.DragRotateHandler=Fo,e.EdgeInsets=Lt,e.FullscreenControl=class extends t.E{constructor(e={}){super(),this._onFullscreenChange=()=>{var e;let t=window.document.fullscreenElement||window.document.mozFullScreenElement||window.document.webkitFullscreenElement||window.document.msFullscreenElement;for(;null===(e=null==t?void 0:t.shadowRoot)||void 0===e?void 0:e.fullscreenElement;)t=t.shadowRoot.fullscreenElement;t===this._container!==this._fullscreen&&this._handleFullscreenChange();},this._onClickFullscreen=()=>{this._isFullscreen()?this._exitFullscreen():this._requestFullscreen();},this._fullscreen=!1,e&&e.container&&(e.container instanceof HTMLElement?this._container=e.container:t.w("Full screen control 'container' must be a DOM element.")),"onfullscreenchange"in document?this._fullscreenchange="fullscreenchange":"onmozfullscreenchange"in document?this._fullscreenchange="mozfullscreenchange":"onwebkitfullscreenchange"in document?this._fullscreenchange="webkitfullscreenchange":"onmsfullscreenchange"in document&&(this._fullscreenchange="MSFullscreenChange");}onAdd(e){return this._map=e,this._container||(this._container=this._map.getContainer()),this._controlContainer=h.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),this._controlContainer}onRemove(){h.remove(this._controlContainer),this._map=null,window.document.removeEventListener(this._fullscreenchange,this._onFullscreenChange);}_setupUI(){const e=this._fullscreenButton=h.create("button","maplibregl-ctrl-fullscreen",this._controlContainer);h.create("span","maplibregl-ctrl-icon",e).setAttribute("aria-hidden","true"),e.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),window.document.addEventListener(this._fullscreenchange,this._onFullscreenChange);}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.title=e;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_handleFullscreenChange(){this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("maplibregl-ctrl-shrink"),this._fullscreenButton.classList.toggle("maplibregl-ctrl-fullscreen"),this._updateTitle(),this._fullscreen?(this.fire(new t.l("fullscreenstart")),this._prevCooperativeGesturesEnabled=this._map.cooperativeGestures.isEnabled(),this._map.cooperativeGestures.disable()):(this.fire(new t.l("fullscreenend")),this._prevCooperativeGesturesEnabled&&this._map.cooperativeGestures.enable());}_exitFullscreen(){window.document.exitFullscreen?window.document.exitFullscreen():window.document.mozCancelFullScreen?window.document.mozCancelFullScreen():window.document.msExitFullscreen?window.document.msExitFullscreen():window.document.webkitCancelFullScreen?window.document.webkitCancelFullScreen():this._togglePseudoFullScreen();}_requestFullscreen(){this._container.requestFullscreen?this._container.requestFullscreen():this._container.mozRequestFullScreen?this._container.mozRequestFullScreen():this._container.msRequestFullscreen?this._container.msRequestFullscreen():this._container.webkitRequestFullscreen?this._container.webkitRequestFullscreen():this._togglePseudoFullScreen();}_togglePseudoFullScreen(){this._container.classList.toggle("maplibregl-pseudo-fullscreen"),this._handleFullscreenChange(),this._map.resize();}},e.GeoJSONSource=ee,e.GeolocateControl=class extends t.E{constructor(e){super(),this._onSuccess=e=>{if(this._map){if(this._isOutOfMapMaxBounds(e))return this._setErrorState(),this.fire(new t.l("outofmaxbounds",e)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=e,this._watchState){case "WAITING_ACTIVE":case "ACTIVE_LOCK":case "ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "BACKGROUND":case "BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background");break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(e),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(e),this.options.showUserLocation&&this._dotElement.classList.remove("maplibregl-user-location-dot-stale"),this.fire(new t.l("geolocate",e)),this._finish();}},this._updateCamera=e=>{const i=new t.V(e.coords.longitude,e.coords.latitude),a=e.coords.accuracy,r=this._map.getBearing(),o=t.e({bearing:r},this.options.fitBoundsOptions),s=$.fromLngLat(i,a);this._map.fitBounds(s,o,{geolocateSource:!0});},this._updateMarker=e=>{if(e){const i=new t.V(e.coords.longitude,e.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=e.coords.accuracy,this._updateCircleRadiusIfNeeded();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();},this._onUpdate=()=>{this._updateCircleRadiusIfNeeded();},this._onError=e=>{if(this._map){if(1===e.code){this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===e.code&&ds)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("maplibregl-user-location-dot-stale"),this.fire(new t.l("error",e)),this._finish();}},this._finish=()=>{this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;},this._setupUI=()=>{this._map&&(this._container.addEventListener("contextmenu",(e=>e.preventDefault())),this._geolocateButton=h.create("button","maplibregl-ctrl-geolocate",this._container),h.create("span","maplibregl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden","true"),this._geolocateButton.type="button",this._geolocateButton.disabled=!0);},this._finishSetupUI=e=>{if(this._map){if(!1===e){t.w("Geolocation support is not available so the GeolocateControl will be disabled.");const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}else {const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.disabled=!1,this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=h.create("div","maplibregl-user-location-dot"),this._userLocationDotMarker=new cs({element:this._dotElement}),this._circleElement=h.create("div","maplibregl-user-location-accuracy-circle"),this._accuracyCircleMarker=new cs({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onUpdate),this._map.on("move",this._onUpdate),this._map.on("rotate",this._onUpdate),this._map.on("pitch",this._onUpdate)),this._geolocateButton.addEventListener("click",(()=>this.trigger())),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",(e=>{const i=(null==e?void 0:e[0])instanceof ResizeObserverEntry;e.geolocateSource||"ACTIVE_LOCK"!==this._watchState||i||this._map.isZooming()||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this.fire(new t.l("trackuserlocationend")),this.fire(new t.l("userlocationlostfocus")));}));}},this.options=t.e({},hs,e);}onAdd(e){return this._map=e,this._container=h.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._setupUI(),function(){return t._(this,arguments,void 0,(function*(e=!1){if(void 0!==os&&!e)return os;if(void 0===window.navigator.permissions)return os=!!window.navigator.geolocation,os;try{const e=yield window.navigator.permissions.query({name:"geolocation"});os="denied"!==e.state;}catch(e){os=!!window.navigator.geolocation;}return os}))}().then((e=>this._finishSetupUI(e))),this._container}onRemove(){void 0!==this._geolocationWatchID&&(window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),h.remove(this._container),this._map.off("zoom",this._onUpdate),this._map.off("move",this._onUpdate),this._map.off("rotate",this._onUpdate),this._map.off("pitch",this._onUpdate),this._map=void 0,us=0,ds=!1;}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case "WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error");break;case "ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case "BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting");break;case "ACTIVE_ERROR":case "BACKGROUND_ERROR":case "OFF":case void 0:break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}}_updateCircleRadiusIfNeeded(){const e=this._userLocationDotMarker.getLngLat();if(!(this.options.showUserLocation&&this.options.showAccuracyCircle&&this._accuracy&&e))return;const t=this._map.project(e),i=this._map.unproject([t.x+100,t.y]),a=e.distanceTo(i)/100,r=2*this._accuracy/a;this._circleElement.style.width=`${r.toFixed(2)}px`,this._circleElement.style.height=`${r.toFixed(2)}px`;}trigger(){if(!this._setup)return t.w("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case "OFF":this._watchState="WAITING_ACTIVE",this.fire(new t.l("trackuserlocationstart"));break;case "WAITING_ACTIVE":case "ACTIVE_LOCK":case "ACTIVE_ERROR":case "BACKGROUND_ERROR":us--,ds=!1,this._watchState="OFF",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background-error"),this.fire(new t.l("trackuserlocationend"));break;case "BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new t.l("trackuserlocationstart")),this.fire(new t.l("userlocationfocus"));break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}switch(this._watchState){case "WAITING_ACTIVE":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "ACTIVE_LOCK":this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-active");break;case "OFF":break;default:throw new Error(`Unexpected watchState ${this._watchState}`)}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let e;this._geolocateButton.classList.add("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),us++,us>1?(e={maximumAge:6e5,timeout:0},ds=!0):(e=this.options.positionOptions,ds=!1),this._geolocationWatchID=window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,e);}}else window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("maplibregl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},e.GlobeControl=class{constructor(){this._toggleProjection=()=>{var e;const t=null===(e=this._map.getProjection())||void 0===e?void 0:e.type;this._map.setProjection("mercator"!==t&&t?{type:"mercator"}:{type:"globe"}),this._updateGlobeIcon();},this._updateGlobeIcon=()=>{var e;this._globeButton.classList.remove("maplibregl-ctrl-globe"),this._globeButton.classList.remove("maplibregl-ctrl-globe-enabled"),"globe"===(null===(e=this._map.getProjection())||void 0===e?void 0:e.type)?(this._globeButton.classList.add("maplibregl-ctrl-globe-enabled"),this._globeButton.title=this._map._getUIString("GlobeControl.Disable")):(this._globeButton.classList.add("maplibregl-ctrl-globe"),this._globeButton.title=this._map._getUIString("GlobeControl.Enable"));};}onAdd(e){return this._map=e,this._container=h.create("div","maplibregl-ctrl maplibregl-ctrl-group"),this._globeButton=h.create("button","maplibregl-ctrl-globe",this._container),h.create("span","maplibregl-ctrl-icon",this._globeButton).setAttribute("aria-hidden","true"),this._globeButton.type="button",this._globeButton.addEventListener("click",this._toggleProjection),this._updateGlobeIcon(),this._map.on("styledata",this._updateGlobeIcon),this._container}onRemove(){h.remove(this._container),this._map.off("styledata",this._updateGlobeIcon),this._globeButton.removeEventListener("click",this._toggleProjection),this._map=void 0;}},e.Hash=Zr,e.ImageSource=te,e.KeyboardHandler=Io,e.LngLatBounds=$,e.LogoControl=Wo,e.Map=class extends Uo{constructor(e){var i,a;t.cF.mark(t.cG.create);const r=Object.assign(Object.assign(Object.assign({},is),e),{canvasContextAttributes:Object.assign(Object.assign({},is.canvasContextAttributes),e.canvasContextAttributes)});if(null!=r.minZoom&&null!=r.maxZoom&&r.minZoom>r.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=r.minPitch&&null!=r.maxPitch&&r.minPitch>r.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=r.minPitch&&r.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=r.maxPitch&&r.maxPitch>180)throw new Error("maxPitch must be less than or equal to 180");const o=new Zt,s=new qt;if(void 0!==r.minZoom&&o.setMinZoom(r.minZoom),void 0!==r.maxZoom&&o.setMaxZoom(r.maxZoom),void 0!==r.minPitch&&o.setMinPitch(r.minPitch),void 0!==r.maxPitch&&o.setMaxPitch(r.maxPitch),void 0!==r.renderWorldCopies&&o.setRenderWorldCopies(r.renderWorldCopies),null!==r.transformConstrain&&o.setConstrainOverride(r.transformConstrain),super(o,s,{bearingSnap:r.bearingSnap}),this._idleTriggered=!1,this._crossFadingFactor=1,this._renderTaskQueue=new $o,this._controls=[],this._mapId=t.ag(),this._lostContextStyle={style:null,images:null},this._contextLost=e=>{e.preventDefault(),this._frameRequest&&(this._frameRequest.abort(),this._frameRequest=null),this.painter.destroy();for(const e of Object.values(this.style._layers))if("custom"===e.type&&console.warn(`Custom layer with id '${e.id}' cannot be restored after WebGL context loss. You will need to re-add it manually after context restoration.`),e._listeners)for(const[t]of Object.entries(e._listeners))console.warn(`Custom layer with id '${e.id}' had event listeners for event '${t}' which cannot be restored after WebGL context loss. You will need to re-add them manually after context restoration.`);this._lostContextStyle=this._getStyleAndImages(),this.style.destroy(),this.style=null,this.fire(new t.l("webglcontextlost",{originalEvent:e}));},this._contextRestored=e=>{this._lostContextStyle.style&&this.setStyle(this._lostContextStyle.style,{diff:!1}),this._lostContextStyle.images&&(this.style.imageManager.images=this._lostContextStyle.images),this._setupPainter(),this.resize(),this._update(),this.fire(new t.l("webglcontextrestored",{originalEvent:e}));},this._onMapScroll=e=>{if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1},this._onWindowOnline=()=>{this._update();},this._interactive=r.interactive,this._maxTileCacheSize=r.maxTileCacheSize,this._maxTileCacheZoomLevels=r.maxTileCacheZoomLevels,this._canvasContextAttributes=Object.assign({},r.canvasContextAttributes),this._trackResize=!0===r.trackResize,this._bearingSnap=r.bearingSnap,this._centerClampedToGround=r.centerClampedToGround,this._refreshExpiredTiles=!0===r.refreshExpiredTiles,this._fadeDuration=r.fadeDuration,this._crossSourceCollisions=!0===r.crossSourceCollisions,this._collectResourceTiming=!0===r.collectResourceTiming,this._locale=Object.assign(Object.assign({},es),r.locale),this._clickTolerance=r.clickTolerance,this._overridePixelRatio=r.pixelRatio,this._maxCanvasSize=r.maxCanvasSize,this._zoomLevelsToOverscale=r.experimentalZoomLevelsToOverscale,this.transformCameraUpdate=r.transformCameraUpdate,this.transformConstrain=r.transformConstrain,this.cancelPendingTileRequestsWhileZooming=!0===r.cancelPendingTileRequestsWhileZooming,void 0!==r.reduceMotion&&(n.prefersReducedMotion=r.reduceMotion),this._imageQueueHandle=g.addThrottleControl((()=>this.isMoving())),this._requestManager=new v(r.transformRequest),"string"==typeof r.container){if(this._container=document.getElementById(r.container),!this._container)throw new Error(`Container '${r.container}' not found.`)}else {if(!(r.container instanceof HTMLElement))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=r.container;}if(r.maxBounds&&this.setMaxBounds(r.maxBounds),this._setupContainer(),this._setupPainter(),this.on("move",(()=>this._update(!1))),this.on("moveend",(()=>this._update(!1))),this.on("zoom",(()=>this._update(!0))),this.on("terrain",(()=>{this.painter.terrainFacilitator.dirty=!0,this._update(!0);})),this.once("idle",(()=>{this._idleTriggered=!0;})),"undefined"!=typeof window){addEventListener("online",this._onWindowOnline,!1);let e=!1;const t=Nr((e=>{this._trackResize&&!this._removed&&(this.resize(e),this.redraw());}),50);this._resizeObserver=new ResizeObserver((i=>{e?t(i):e=!0;})),this._resizeObserver.observe(this._container);}this.handlers=new Go(this,r),this._hash=r.hash&&new Zr("string"==typeof r.hash&&r.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:r.center,elevation:r.elevation,zoom:r.zoom,bearing:r.bearing,pitch:r.pitch,roll:r.roll}),r.bounds&&(this.resize(),this.fitBounds(r.bounds,t.e({},r.fitBoundsOptions,{duration:0}))));const l="string"==typeof r.style||!("globe"===(null===(a=null===(i=r.style)||void 0===i?void 0:i.projection)||void 0===a?void 0:a.type));this.resize(null,l),this._localIdeographFontFamily=r.localIdeographFontFamily,this._validateStyle=r.validateStyle,r.style&&this.setStyle(r.style,{localIdeographFontFamily:r.localIdeographFontFamily}),r.attributionControl&&this.addControl(new qo("boolean"==typeof r.attributionControl?void 0:r.attributionControl)),r.maplibreLogo&&this.addControl(new Wo,r.logoPosition),this.on("style.load",(()=>{if(l||this._resizeTransform(),this.transform.unmodified){const e=t.U(this.style.stylesheet,["center","zoom","bearing","pitch","roll"]);this.jumpTo(e);}})),this.on("data",(e=>{this._update("style"===e.dataType),this.fire(new t.l(`${e.dataType}data`,e));})),this.on("dataloading",(e=>{this.fire(new t.l(`${e.dataType}dataloading`,e));})),this.on("dataabort",(e=>{this.fire(new t.l("sourcedataabort",e));}));}_getMapId(){return this._mapId}setGlobalStateProperty(e,t){return this.style.setGlobalStateProperty(e,t),this._update(!0)}getGlobalState(){return this.style.getGlobalState()}addControl(e,i){if(void 0===i&&(i=e.getDefaultPosition?e.getDefaultPosition():"top-right"),!e||!e.onAdd)return this.fire(new t.k(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const a=e.onAdd(this);this._controls.push(e);const r=this._controlPositions[i];return -1!==i.indexOf("bottom")?r.insertBefore(a,r.firstChild):r.appendChild(a),this}removeControl(e){if(!e||!e.onRemove)return this.fire(new t.k(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(e);return i>-1&&this._controls.splice(i,1),e.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}coveringTiles(e){return Ce(this.transform,e)}calculateCameraOptionsFromTo(e,t,i,a){return null==a&&this.terrain&&(a=this.terrain.getElevationForLngLatZoom(i,this.transform.tileZoom)),super.calculateCameraOptionsFromTo(e,t,i,a)}resize(e,i=!0){const[a,r]=this._containerDimensions(),o=this._getClampedPixelRatio(a,r);if(this._resizeCanvas(a,r,o),this.painter.resize(a,r,o),this.painter.overLimit()){const e=this.painter.context.gl;this._maxCanvasSize=[e.drawingBufferWidth,e.drawingBufferHeight];const t=this._getClampedPixelRatio(a,r);this._resizeCanvas(a,r,t),this.painter.resize(a,r,t);}this._resizeTransform(i);const s=!this._moving;return s&&(this.stop(),this.fire(new t.l("movestart",e)).fire(new t.l("move",e))),this.fire(new t.l("resize",e)),s&&this.fire(new t.l("moveend",e)),this}_resizeTransform(e=!0){var t;const[i,a]=this._containerDimensions();this.transform.resize(i,a,e),null===(t=this._requestedCameraState)||void 0===t||t.resize(i,a,e);}_getClampedPixelRatio(e,t){const{0:i,1:a}=this._maxCanvasSize,r=this.getPixelRatio(),o=e*r,s=t*r;return Math.min(o>i?i/o:1,s>a?a/s:1)*r}getPixelRatio(){var e;return null!==(e=this._overridePixelRatio)&&void 0!==e?e:devicePixelRatio}setPixelRatio(e){this._overridePixelRatio=e,this.resize();}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(e){return this.transform.setMaxBounds($.convert(e)),this._update()}setMinZoom(e){if((e=null==e?-2:e)>=-2&&e<=this.transform.maxZoom)return this.transform.setMinZoom(e),this._update(),this.getZoom()<e&&this.setZoom(e),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(e){if((e=null==e?22:e)>=this.transform.minZoom)return this.transform.setMaxZoom(e),this._update(),this.getZoom()>e&&this.setZoom(e),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(e){if((e=null==e?0:e)<0)throw new Error("minPitch must be greater than or equal to 0");if(e>=0&&e<=this.transform.maxPitch)return this.transform.setMinPitch(e),this._update(),this.getPitch()<e&&this.setPitch(e),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(e){if((e=null==e?60:e)>180)throw new Error("maxPitch must be less than or equal to 180");if(e>=this.transform.minPitch)return this.transform.setMaxPitch(e),this._update(),this.getPitch()>e&&this.setPitch(e),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.setRenderWorldCopies(e),this._update()}setTransformConstrain(e){return this.transform.setConstrainOverride(e),this._update()}project(e){return this.transform.locationToScreenPoint(t.V.convert(e),this.style&&this.terrain)}unproject(e){return this.transform.screenPointToLocation(t.P.convert(e),this.terrain)}isMoving(){var e;return this._moving||(null===(e=this.handlers)||void 0===e?void 0:e.isMoving())}isZooming(){var e;return this._zooming||(null===(e=this.handlers)||void 0===e?void 0:e.isZooming())}isRotating(){var e;return this._rotating||(null===(e=this.handlers)||void 0===e?void 0:e.isRotating())}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let a=!1;const r=r=>{const o=t.filter((e=>this.getLayer(e))),s=0!==o.length?this.queryRenderedFeatures(r.point,{layers:o}):[];s.length?a||(a=!0,i.call(this,new Yr(e,this,r.originalEvent,{features:s}))):a=!1;};return {layers:t,listener:i,delegates:{mousemove:r,mouseout:()=>{a=!1;}}}}if("mouseleave"===e||"mouseout"===e){let a=!1;const r=r=>{const o=t.filter((e=>this.getLayer(e)));(0!==o.length?this.queryRenderedFeatures(r.point,{layers:o}):[]).length?a=!0:a&&(a=!1,i.call(this,new Yr(e,this,r.originalEvent)));},o=t=>{a&&(a=!1,i.call(this,new Yr(e,this,t.originalEvent)));};return {layers:t,listener:i,delegates:{mousemove:r,mouseout:o}}}{const a=e=>{const a=t.filter((e=>this.getLayer(e))),r=0!==a.length?this.queryRenderedFeatures(e.point,{layers:a}):[];r.length&&(e.features=r,i.call(this,e),delete e.features);};return {layers:t,listener:i,delegates:{[e]:a}}}}_saveDelegatedListener(e,t){this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(t);}_removeDelegatedListener(e,t,i){if(!this._delegatedListeners||!this._delegatedListeners[e])return;const a=this._delegatedListeners[e];for(let e=0;e<a.length;e++){const r=a[e];if(r.listener===i&&r.layers.length===t.length&&r.layers.every((e=>t.includes(e)))){for(const e in r.delegates)this.off(e,r.delegates[e]);return void a.splice(e,1)}}}on(e,t,i){if(void 0===i)return super.on(e,t);const a="string"==typeof t?[t]:t,r=this._createDelegatedListener(e,a,i);this._saveDelegatedListener(e,r);for(const e in r.delegates)this.on(e,r.delegates[e]);return {unsubscribe:()=>{this._removeDelegatedListener(e,a,i);}}}once(e,t,i){if(void 0===i)return super.once(e,t);const a="string"==typeof t?[t]:t,r=this._createDelegatedListener(e,a,i);for(const t in r.delegates){const o=r.delegates[t];r.delegates[t]=(...t)=>{this._removeDelegatedListener(e,a,i),o(...t);};}this._saveDelegatedListener(e,r);for(const e in r.delegates)this.once(e,r.delegates[e]);return this}off(e,t,i){return void 0===i?super.off(e,t):(this._removeDelegatedListener(e,"string"==typeof t?[t]:t,i),this)}queryRenderedFeatures(e,i){if(!this.style)return [];let a;const r=e instanceof t.P||Array.isArray(e),o=r?e:[[0,0],[this.transform.width,this.transform.height]];if(i=i||(r?{}:e)||{},o instanceof t.P||"number"==typeof o[0])a=[t.P.convert(o)];else {const e=t.P.convert(o[0]),i=t.P.convert(o[1]);a=[e,new t.P(i.x,e.y),i,new t.P(e.x,i.y),e];}return this.style.queryRenderedFeatures(a,i,this.transform)}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}setStyle(e,i){return !1!==(i=t.e({},{localIdeographFontFamily:this._localIdeographFontFamily,validate:this._validateStyle},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&this.style&&e?(this._diffStyle(e,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._updateStyle(e,i))}setTransformRequest(e){return this._requestManager.setTransformRequest(e),this}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){var i,a;if(t.transformStyle&&this.style&&!this.style._loaded)return void this.style.once("style.load",(()=>this._updateStyle(e,t)));const r=this.style&&t.transformStyle?this.style.serialize():void 0;return this.style&&(this.style.setEventedParent(null),this.style._remove(!e)),e?(this.style=new Si(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e,t,r):this.style.loadJSON(e,t,r),this):(null===(a=null===(i=this.style)||void 0===i?void 0:i.projection)||void 0===a||a.destroy(),delete this.style,this)}_lazyInitEmptyStyle(){this.style||(this.style=new Si(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(e,i){if("string"==typeof e){const a=this._requestManager.transformRequest(e,"Style");t.j(a,new AbortController).then((e=>{this._updateDiff(e.data,i);})).catch((e=>{e&&this.fire(new t.k(e));}));}else "object"==typeof e&&this._updateDiff(e,i);}_updateDiff(e,i){try{this.style.setState(e,i)&&this._update(!0);}catch(a){t.w(`Unable to perform style diff: ${a.message||a.error||a}.  Rebuilding the style from scratch.`),this._updateStyle(e,i);}}getStyle(){if(this.style)return this.style.serialize()}_getStyleAndImages(){return this.style?{style:this.style.serialize(),images:this.style.imageManager.cloneImages()}:{style:null,images:{}}}isStyleLoaded(){return this.style?this.style.loaded():t.w("There is no style added to the map.")}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(e){const i=this.style&&this.style.tileManagers[e];if(void 0!==i)return i.loaded();this.fire(new t.k(new Error(`There is no tile manager with ID '${e}'`)));}setTerrain(e){if(this.style._checkLoaded(),this._terrainDataCallback&&this.style.off("data",this._terrainDataCallback),e){const i=this.style.tileManagers[e.source];if(!i)throw new Error(`cannot load terrain, because there exists no source with ID: ${e.source}`);null===this.terrain&&i.reload();for(const i in this.style._layers){const a=this.style._layers[i];"hillshade"===a.type&&a.source===e.source&&t.w("You are using the same source for a hillshade layer and for 3D terrain. Please consider using two separate sources to improve rendering quality."),"color-relief"===a.type&&a.source===e.source&&t.w("You are using the same source for a color-relief layer and for 3D terrain. Please consider using two separate sources to improve rendering quality.");}this.terrain=new Ko(this.painter,i,e),this.painter.renderToTexture=new Jo(this.painter,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._terrainDataCallback=t=>{var i;"style"===t.dataType?this.terrain.tileManager.freeRtt():"source"===t.dataType&&t.tile&&(t.sourceId!==e.source||this._elevationFreeze||(this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))),"image"===(null===(i=t.source)||void 0===i?void 0:i.type)?this.terrain.tileManager.freeRtt():this.terrain.tileManager.freeRtt(t.tile.tileID));},this.style.on("data",this._terrainDataCallback);}else this.terrain&&this.terrain.tileManager.destruct(),this.terrain=null,this.painter.renderToTexture&&this.painter.renderToTexture.destruct(),this.painter.renderToTexture=null,this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0);return this.fire(new t.l("terrain",{terrain:e})),this}getTerrain(){var e,t;return null!==(t=null===(e=this.terrain)||void 0===e?void 0:e.options)&&void 0!==t?t:null}areTilesLoaded(){const e=this.style&&this.style.tileManagers;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}removeSource(e){return this.style.removeSource(e),this._update(!0)}getSource(e){return this.style.getSource(e)}setSourceTileLodParams(e,t,i){if(i){const a=this.getSource(i);if(!a)throw new Error(`There is no source with ID "${i}", cannot set LOD parameters`);a.calculateTileZoom=we(Math.max(1,e),Math.max(1,t));}else for(const i in this.style.tileManagers)this.style.tileManagers[i].getSource().calculateTileZoom=we(Math.max(1,e),Math.max(1,t));return this._update(!0),this}refreshTiles(e,i){const a=this.style.tileManagers[e];if(!a)throw new Error(`There is no tile manager with ID "${e}", cannot refresh tile`);void 0===i?a.reload(!0):a.refreshTiles(i.map((e=>new t.ad(e.z,e.x,e.y))));}addImage(e,i,a={}){const{pixelRatio:r=1,sdf:o=!1,stretchX:s,stretchY:l,content:c,textFitWidth:h,textFitHeight:u}=a;if(this._lazyInitEmptyStyle(),!(i instanceof HTMLImageElement||t.b(i))){if(void 0===i.width||void 0===i.height)return this.fire(new t.k(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:a,height:n,data:d}=i,_=i;return this.style.addImage(e,{data:new t.R({width:a,height:n},new Uint8Array(d)),pixelRatio:r,stretchX:s,stretchY:l,content:c,textFitWidth:h,textFitHeight:u,sdf:o,version:0,userImage:_}),_.onAdd&&_.onAdd(this,e),this}}{const{width:a,height:d,data:_}=n.getImageData(i);this.style.addImage(e,{data:new t.R({width:a,height:d},_),pixelRatio:r,stretchX:s,stretchY:l,content:c,textFitWidth:h,textFitHeight:u,sdf:o,version:0});}}updateImage(e,i){const a=this.style.getImage(e);if(!a)return this.fire(new t.k(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const r=i instanceof HTMLImageElement||t.b(i)?n.getImageData(i):i,{width:o,height:s,data:l}=r;if(void 0===o||void 0===s)return this.fire(new t.k(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));if(o!==a.data.width||s!==a.data.height)return this.fire(new t.k(new Error("The width and height of the updated image must be that same as the previous version of the image")));const c=!(i instanceof HTMLImageElement||t.b(i));return a.data.replace(l,c),this.style.updateImage(e,a),this}getImage(e){return this.style.getImage(e)}hasImage(e){return e?!!this.style.getImage(e):(this.fire(new t.k(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e);}loadImage(e){return g.getImage(this._requestManager.transformRequest(e,"Image"),new AbortController)}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}getLayersOrder(){return this.style.getLayersOrder()}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,a={}){return this.style.setPaintProperty(e,t,i,a),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,a={}){return this.style.setLayoutProperty(e,t,i,a),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setGlyphs(e,t={}){return this._lazyInitEmptyStyle(),this.style.setGlyphs(e,t),this._update(!0)}getGlyphs(){return this.style.getGlyphsUrl()}addSprite(e,t,i={}){return this._lazyInitEmptyStyle(),this.style.addSprite(e,t,i,(e=>{e||this._update(!0);})),this}removeSprite(e){return this._lazyInitEmptyStyle(),this.style.removeSprite(e),this._update(!0)}getSprite(){return this.style.getSprite()}setSprite(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSprite(e,t,(e=>{e||this._update(!0);})),this}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setSky(e,t={}){return this._lazyInitEmptyStyle(),this.style.setSky(e,t),this._update(!0)}getSky(){return this.style.getSky()}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let e=0,t=0;return this._container&&(e=this._container.clientWidth||400,t=this._container.clientHeight||300),[e,t]}_setupContainer(){const e=this._container;e.classList.add("maplibregl-map");const t=this._canvasContainer=h.create("div","maplibregl-canvas-container",e);this._interactive&&t.classList.add("maplibregl-interactive"),this._canvas=h.create("canvas","maplibregl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex",this._interactive?"0":"-1"),this._canvas.setAttribute("aria-label",this._getUIString("Map.Title")),this._canvas.setAttribute("role","region");const i=this._containerDimensions(),a=this._getClampedPixelRatio(i[0],i[1]);this._resizeCanvas(i[0],i[1],a);const r=this._controlContainer=h.create("div","maplibregl-control-container",e),o=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach((e=>{o[e]=h.create("div",`maplibregl-ctrl-${e} `,r);})),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(e,t,i){this._canvas.width=Math.floor(i*e),this._canvas.height=Math.floor(i*t),this._canvas.style.width=`${e}px`,this._canvas.style.height=`${t}px`;}_setupPainter(){const e=Object.assign(Object.assign({},this._canvasContextAttributes),{alpha:!0,depth:!0,stencil:!0,premultipliedAlpha:!0});let t=null;this._canvas.addEventListener("webglcontextcreationerror",(i=>{t={requestedAttributes:e},i&&(t.statusMessage=i.statusMessage,t.type=i.type);}),{once:!0});let i=null;if(i=this._canvasContextAttributes.contextType?this._canvas.getContext(this._canvasContextAttributes.contextType,e):this._canvas.getContext("webgl2",e)||this._canvas.getContext("webgl",e),!i){const e="Failed to initialize WebGL";throw t?(t.message=e,new Error(JSON.stringify(t))):new Error(e)}this.painter=new jr(i,this.transform),u.testSupport(i);}migrateProjection(e,i){super.migrateProjection(e,i),this.painter.transform=e,this.fire(new t.l("projectiontransition",{newProjection:this.style.projection.name}));}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style&&this.style._loaded?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e);}_render(e){var i,a,r,o,s;const n=this._idleTriggered?this._fadeDuration:0,l=(null===(i=this.style.projection)||void 0===i?void 0:i.transitionState)>0;if(this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(e),this._removed)return;let h=!1;if(this.style&&this._styleDirty){this._styleDirty=!1;const e=this.transform.zoom,i=c();this.style.zoomHistory.update(e,i);const a=new t.H(e,{now:i,fadeDuration:n,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),r=a.crossFadingFactor();1===r&&r===this._crossFadingFactor||(h=!0,this._crossFadingFactor=r),this.style.update(a);}const u=(null===(a=this.style.projection)||void 0===a?void 0:a.transitionState)>0!==l;null===(r=this.style.projection)||void 0===r||r.setErrorQueryLatitudeDegrees(this.transform.center.lat),this.transform.setTransitionState(null===(o=this.style.projection)||void 0===o?void 0:o.transitionState,null===(s=this.style.projection)||void 0===s?void 0:s.latitudeErrorCorrectionRadians),this.style&&(this._sourcesDirty||u)&&(this._sourcesDirty=!1,this.style._updateSources(this.transform)),this.terrain?(this.terrain.tileManager.update(this.transform,this.terrain),this.transform.setMinElevationForCurrentTile(this.terrain.getMinTileElevationForLngLatZoom(this.transform.center,this.transform.tileZoom)),!this._elevationFreeze&&this._centerClampedToGround&&this.transform.setElevation(this.terrain.getElevationForLngLatZoom(this.transform.center,this.transform.tileZoom))):(this.transform.setMinElevationForCurrentTile(0),this._centerClampedToGround&&this.transform.setElevation(0)),this._placementDirty=this.style&&this.style._updatePlacement(this.transform,this.showCollisionBoxes,n,this._crossSourceCollisions,u),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeD