from _typeshed import Incomplete
from collections import OrderedDict
from typing import Protocol, TypeVar, overload, type_check_only

_T = TypeVar("_T")
_VT = TypeVar("_VT")

@type_check_only
class _SupportsCasefold(Protocol):
    def casefold(self) -> str: ...

@type_check_only
class _SupportsLower(Protocol):
    def lower(self) -> str: ...

class CaseFoldedOrderedDict(OrderedDict[str, _VT]):
    def __getitem__(self, key: _SupportsCasefold | _SupportsLower) -> _VT: ...
    def __setitem__(self, key: _SupportsCasefold | _SupportsLower, value: _VT) -> None: ...
    def __contains__(self, key: _SupportsCasefold | _SupportsLower) -> bool: ...  # type: ignore[override]
    # See overloads for dict class:
    @overload
    def get(self, key: _SupportsCasefold | _SupportsLower, default: None = None) -> _VT | None: ...
    @overload
    def get(self, key: _SupportsCasefold | _SupportsLower, default: _VT) -> _VT: ...
    @overload
    def get(self, key: _SupportsCasefold | _SupportsLower, default: _T) -> _VT | _T: ...
    @overload  # type: ignore[override]
    def pop(self, key: _SupportsCasefold | _SupportsLower, default: None = None) -> _VT | None: ...
    @overload
    def pop(self, key: _SupportsCasefold | _SupportsLower, default: _VT) -> _VT: ...
    @overload
    def pop(self, key: _SupportsCasefold | _SupportsLower, default: _T) -> _VT | _T: ...

def parse(value: str) -> CaseFoldedOrderedDict[Incomplete]: ...
