
#line 1 "../gen/tmpl/lib.c"
/*
  gsl_Pdf.c
  Ruby/Numo::GSL - GSL wrapper for Ruby/Numo::NArray

  created on: 2017-03-11
  Copyright (C) 2017 Masahiro Tanaka
*/

#include <ruby.h>
#include <assert.h>
#include "numo/narray.h"
#include "numo/template.h"
#include "../numo_gsl.h"
#line 15 "../gen/tmpl/lib.c"
#include <gsl/gsl_randist.h>

#line 18 "../gen/tmpl/lib.c"
static VALUE mG;



#line 1 "../gen/tmpl/module.c"
/*
  module definition: Numo::GSL::Pdf
*/

#line 6 "../gen/tmpl/module.c"
static VALUE mPdf;


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_gaussian(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //sigma

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_gaussian_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload gaussian(x,sigma)
  
  @param [Numo::DFloat] x
  @param [Float] sigma
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Gaussian distribution with standard deviation sigma, using
the formula given above.
*/
static VALUE
pdf_s_gaussian(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_gaussian,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //sigma
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_ugaussian(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c1 = gsl_ran_ugaussian_pdf(c0);
    
    *(double*)GET_PTR(lp,1) = c1; //return
}

/*
  @overload ugaussian(x)
  
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  These functions compute results for the unit Gaussian distribution.  They
are equivalent to the functions above with a standard deviation of one,
sigma = 1.
*/
static VALUE
pdf_s_ugaussian(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_ugaussian,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_gaussian_tail(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //sigma
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_gaussian_tail_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload gaussian_tail(x,a,sigma)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] sigma
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Gaussian tail distribution with standard deviation sigma and
lower limit a, using the formula given above.
*/
static VALUE
pdf_s_gaussian_tail(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_gaussian_tail,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //sigma
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_ugaussian_tail(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //a

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_ugaussian_tail_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload ugaussian_tail(x,a)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @return [Numo::DFloat]  return

  These functions compute results for the tail of a unit Gaussian
distribution.  They are equivalent to the functions above with a standard
deviation of one, sigma = 1.
*/
static VALUE
pdf_s_ugaussian_tail(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_ugaussian_tail,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //a
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_bivariate_gaussian(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    double c4;
    double c5;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c2 = *(double*)(opt[0]); //sigma_x
    c3 = *(double*)(opt[1]); //sigma_y
    c4 = *(double*)(opt[2]); //rho
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    c1 = *(double*)GET_PTR(lp,1); //y
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c5 = gsl_ran_bivariate_gaussian_pdf(c0,c1,c2,c3,c4);
    
    *(double*)GET_PTR(lp,2) = c5; //return
}

/*
  @overload bivariate_gaussian(x,y,sigma_x,sigma_y,rho)
  
  @param [Numo::DFloat] x
  @param [Numo::DFloat] y
  @param [Float] sigma_x
  @param [Float] sigma_y
  @param [Float] rho
  @return [Numo::DFloat]  return

  This function computes the probability density p(x,y) at
(x,y) for a bivariate Gaussian distribution with standard
deviations sigma_x, sigma_y and correlation coefficient
rho, using the formula given above.
*/
static VALUE
pdf_s_bivariate_gaussian(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3,VALUE v4)
{
    
    double c2;
    double c3;
    double c4;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[2] = {{cDF,0},{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_bivariate_gaussian,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    2,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[3];
    
    c2 = NUM2DBL(v2); opt[0] = &c2; //sigma_x
    c3 = NUM2DBL(v3); opt[1] = &c3; //sigma_y
    c4 = NUM2DBL(v4); opt[2] = &c4; //rho
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,2,v0,v1); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_exponential(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //mu

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_exponential_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload exponential(x,mu)
  
  @param [Numo::DFloat] x
  @param [Float] mu
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for an exponential distribution with mean mu, using the formula
given above.
*/
static VALUE
pdf_s_exponential(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_exponential,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //mu
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_laplace(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //a

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_laplace_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload laplace(x,a)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Laplace distribution with width a, using the formula
given above.
*/
static VALUE
pdf_s_laplace(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_laplace,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //a
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_exppow(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //b
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_exppow_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload exppow(x,a,b)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] b
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for an exponential power distribution with scale parameter a
and exponent b, using the formula given above.
*/
static VALUE
pdf_s_exppow(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_exppow,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //b
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_cauchy(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //a

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_cauchy_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload cauchy(x,a)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Cauchy distribution with scale parameter a, using the formula
given above.
*/
static VALUE
pdf_s_cauchy(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_cauchy,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //a
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_rayleigh(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //sigma

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_rayleigh_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload rayleigh(x,sigma)
  
  @param [Numo::DFloat] x
  @param [Float] sigma
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Rayleigh distribution with scale parameter sigma, using the
formula given above.
*/
static VALUE
pdf_s_rayleigh(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_rayleigh,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //sigma
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_rayleigh_tail(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //sigma
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_rayleigh_tail_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload rayleigh_tail(x,a,sigma)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] sigma
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Rayleigh tail distribution with scale parameter sigma and
lower limit a, using the formula given above.
*/
static VALUE
pdf_s_rayleigh_tail(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_rayleigh_tail,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //sigma
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_landau(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c1 = gsl_ran_landau_pdf(c0);
    
    *(double*)GET_PTR(lp,1) = c1; //return
}

/*
  @overload landau(x)
  
  @param [Numo::DFloat] x
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for the Landau distribution using an approximation to the formula given
above.
*/
static VALUE
pdf_s_landau(VALUE mod,VALUE v0)
{
    
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_landau,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    
#line 52 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop(&ndf,1,v0); 
#line 54 "../gen/tmpl/mod_func_noloop.c"
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_gamma(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //b
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_gamma_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload gamma(x,a,b)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] b
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a gamma distribution with parameters a and b, using the
formula given above.
*/
static VALUE
pdf_s_gamma(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_gamma,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //b
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_flat(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //b
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_flat_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload flat(x,a,b)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] b
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a uniform distribution from a to b, using the formula
given above.
*/
static VALUE
pdf_s_flat(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_flat,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //b
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_lognormal(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //zeta
    c2 = *(double*)(opt[1]); //sigma
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_lognormal_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload lognormal(x,zeta,sigma)
  
  @param [Numo::DFloat] x
  @param [Float] zeta
  @param [Float] sigma
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a lognormal distribution with parameters zeta and sigma,
using the formula given above.
*/
static VALUE
pdf_s_lognormal(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_lognormal,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //zeta
    c2 = NUM2DBL(v2); opt[1] = &c2; //sigma
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_chisq(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //nu

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_chisq_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload chisq(x,nu)
  
  @param [Numo::DFloat] x
  @param [Float] nu
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a chi-squared distribution with nu degrees of freedom, using
the formula given above.
*/
static VALUE
pdf_s_chisq(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_chisq,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //nu
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_fdist(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //nu1
    c2 = *(double*)(opt[1]); //nu2
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_fdist_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload fdist(x,nu1,nu2)
  
  @param [Numo::DFloat] x
  @param [Float] nu1
  @param [Float] nu2
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for an F-distribution with nu1 and nu2 degrees of freedom,
using the formula given above.
*/
static VALUE
pdf_s_fdist(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_fdist,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //nu1
    c2 = NUM2DBL(v2); opt[1] = &c2; //nu2
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_tdist(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //nu

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_tdist_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload tdist(x,nu)
  
  @param [Numo::DFloat] x
  @param [Float] nu
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a t-distribution with nu degrees of freedom, using the formula
given above.
*/
static VALUE
pdf_s_tdist(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_tdist,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //nu
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_beta(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //b
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_beta_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload beta(x,a,b)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] b
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a beta distribution with parameters a and b, using the
formula given above.
*/
static VALUE
pdf_s_beta(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_beta,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //b
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_logistic(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //a

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
    c2 = gsl_ran_logistic_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload logistic(x,a)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a logistic distribution with scale parameter a, using the
formula given above.
*/
static VALUE
pdf_s_logistic(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_logistic,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //a
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_pareto(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //b
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_pareto_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload pareto(x,a,b)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] b
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Pareto distribution with exponent a and scale b, using
the formula given above.
*/
static VALUE
pdf_s_pareto(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_pareto,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //b
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_weibull(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //b
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_weibull_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload weibull(x,a,b)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] b
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Weibull distribution with scale a and exponent b,
using the formula given above.
*/
static VALUE
pdf_s_weibull(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_weibull,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //b
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_gumbel1(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //b
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_gumbel1_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload gumbel1(x,a,b)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] b
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Type-1 Gumbel distribution with parameters a and b,
using the formula given above.
*/
static VALUE
pdf_s_gumbel1(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_gumbel1,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //b
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_gumbel2(na_loop_t *const lp)
{
    
    double c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //a
    c2 = *(double*)(opt[1]); //b
    

    
    c0 = *(double*)GET_PTR(lp,0); //x
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_gumbel2_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload gumbel2(x,a,b)
  
  @param [Numo::DFloat] x
  @param [Float] a
  @param [Float] b
  @return [Numo::DFloat]  return

  This function computes the probability density p(x) at x
for a Type-2 Gumbel distribution with parameters a and b,
using the formula given above.
*/
static VALUE
pdf_s_gumbel2(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cDF,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_gumbel2,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //a
    c2 = NUM2DBL(v2); opt[1] = &c2; //b
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "tmpl/dirichlet.c"
static void
iter_pdf_s_dirichlet(na_loop_t *const lp)
{
    size_t   n;
    char    *p1, *p2, *p3;

    INIT_COUNTER(lp, n);
    p1 = lp->args[0].ptr + lp->args[0].iter[0].pos;
    p2 = lp->args[1].ptr + lp->args[1].iter[0].pos;
    p3 = lp->args[2].ptr + lp->args[2].iter[0].pos;

    *(double*)p3 = gsl_ran_dirichlet_pdf(n,(double*)p1,(double*)p2);
}

/*
  @overload dirichlet(alpha[],theta[], axis:nil, keepdims:false)
  
  @param [Numo::DFloat] alpha[]
  @param [Numo::DFloat] theta[]
  @return [Numo::DFloat]  return
  @param [Numeric,Array,Range] axis (keyword) Axes along which the operation is performed.
  @param [TrueClass] keepdims (keyword) If true, the reduced axes are left in the result array as dimensions with size one.

  This function computes the probability density 
$p(\theta_1, \ldots , \theta_K)$
p(\theta_1, ... , \theta_K)
at theta[K] for a Dirichlet distribution with parameters 
alpha[K], using the formula given above.
*/
static VALUE
pdf_s_dirichlet(int argc, VALUE *argv, VALUE mod)
{
    VALUE reduce;
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{sym_reduce,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = { iter_pdf_s_dirichlet, NDF_HAS_LOOP|NDF_FLAT_REDUCE|NDF_EXTRACT,
                     3, 1, ain, aout };

    if (argc<2) {
        rb_raise(rb_eArgError,"wrong number of argument (%d for >=2)",argc);
    }

    reduce = nary_reduce_dimension(argc-2, argv+2, 2, argv, &ndf, 0);
    return na_ndloop(&ndf, 3, argv[0], argv[1], reduce);
}


#line 1 "tmpl/dirichlet.c"
static void
iter_pdf_s_dirichlet_ln(na_loop_t *const lp)
{
    size_t   n;
    char    *p1, *p2, *p3;

    INIT_COUNTER(lp, n);
    p1 = lp->args[0].ptr + lp->args[0].iter[0].pos;
    p2 = lp->args[1].ptr + lp->args[1].iter[0].pos;
    p3 = lp->args[2].ptr + lp->args[2].iter[0].pos;

    *(double*)p3 = gsl_ran_dirichlet_lnpdf(n,(double*)p1,(double*)p2);
}

/*
  @overload dirichlet_ln(alpha[],theta[], axis:nil, keepdims:false)
  
  @param [Numo::DFloat] alpha[]
  @param [Numo::DFloat] theta[]
  @return [Numo::DFloat]  return
  @param [Numeric,Array,Range] axis (keyword) Axes along which the operation is performed.
  @param [TrueClass] keepdims (keyword) If true, the reduced axes are left in the result array as dimensions with size one.

  This function computes the logarithm of the probability density 
$p(\theta_1, \ldots , \theta_K)$
p(\theta_1, ... , \theta_K)
for a Dirichlet distribution with parameters 
alpha[K].
*/
static VALUE
pdf_s_dirichlet_ln(int argc, VALUE *argv, VALUE mod)
{
    VALUE reduce;
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cDF,0},{sym_reduce,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = { iter_pdf_s_dirichlet_ln, NDF_HAS_LOOP|NDF_FLAT_REDUCE|NDF_EXTRACT,
                     3, 1, ain, aout };

    if (argc<2) {
        rb_raise(rb_eArgError,"wrong number of argument (%d for >=2)",argc);
    }

    reduce = nary_reduce_dimension(argc-2, argv+2, 2, argv, &ndf, 0);
    return na_ndloop(&ndf, 3, argv[0], argv[1], reduce);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_poisson(na_loop_t *const lp)
{
    
    unsigned int c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //mu

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //k
    
    
    c2 = gsl_ran_poisson_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload poisson(k,mu)
  
  @param [Numo::UInt] k
  @param [Float] mu
  @return [Numo::DFloat]  return

  This function computes the probability p(k) of obtaining  k
from a Poisson distribution with mean mu, using the formula
given above.
*/
static VALUE
pdf_s_poisson(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_poisson,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //mu
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_bernoulli(na_loop_t *const lp)
{
    
    unsigned int c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //p

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //k
    
    
    c2 = gsl_ran_bernoulli_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload bernoulli(k,p)
  
  @param [Numo::UInt] k
  @param [Float] p
  @return [Numo::DFloat]  return

  This function computes the probability p(k) of obtaining
k from a Bernoulli distribution with probability parameter
p, using the formula given above.
*/
static VALUE
pdf_s_bernoulli(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_bernoulli,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //p
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_binomial(na_loop_t *const lp)
{
    
    unsigned int c0;
    double c1;
    unsigned int c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //p
    c2 = *(unsigned int*)(opt[1]); //n
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //k
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_binomial_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload binomial(k,p,n)
  
  @param [Numo::UInt] k
  @param [Float] p
  @param [Integer] n
  @return [Numo::DFloat]  return

  This function computes the probability p(k) of obtaining k
from a binomial distribution with parameters p and n, using
the formula given above.
*/
static VALUE
pdf_s_binomial(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    unsigned int c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_binomial,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //p
    c2 = NUM2UINT(v2); opt[1] = &c2; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "tmpl/multinomial.c"
static void
iter_pdf_s_multinomial(na_loop_t *const lp)
{
    size_t   n;
    char    *p1, *p2, *p3;

    INIT_COUNTER(lp, n);
    p1 = lp->args[0].ptr + lp->args[0].iter[0].pos;
    p2 = lp->args[1].ptr + lp->args[1].iter[0].pos;
    p3 = lp->args[2].ptr + lp->args[2].iter[0].pos;

    *(double*)p3 = gsl_ran_multinomial_pdf(n,(double*)p1,(unsigned int *)p2);
}

/*
  @overload multinomial(p[],n[],[axis0,axis1,..])
  
  @param [Numo::DFloat] p[]
  @param [Numo::UInt] n[]
  @return [Numo::DFloat]  return
  @param [Numeric,Array,Range] axis (keyword) Axes along which the operation is performed.
  @param [TrueClass] keepdims (keyword) If true, the reduced axes are left in the result array as dimensions with size one.

  This function computes the probability 
$P(n_1, n_2, \ldots, n_K)$
P(n_1, n_2, ..., n_K)
of sampling n[K] from a multinomial distribution 
with parameters p[K], using the formula given above.
*/
static VALUE
pdf_s_multinomial(int argc, VALUE *argv, VALUE mod)
{
    VALUE reduce;
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cUI,0},{sym_reduce,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = { iter_pdf_s_multinomial, NDF_HAS_LOOP|NDF_FLAT_REDUCE|NDF_EXTRACT,
                     3, 1, ain, aout };

    if (argc<2) {
        rb_raise(rb_eArgError,"wrong number of argument (%d for >=2)",argc);
    }

    reduce = nary_reduce_dimension(argc-2, argv+2, 2, argv, &ndf, 0);
    return na_ndloop(&ndf, 3, argv[0], argv[1], reduce);
}


#line 1 "tmpl/multinomial.c"
static void
iter_pdf_s_multinomial_ln(na_loop_t *const lp)
{
    size_t   n;
    char    *p1, *p2, *p3;

    INIT_COUNTER(lp, n);
    p1 = lp->args[0].ptr + lp->args[0].iter[0].pos;
    p2 = lp->args[1].ptr + lp->args[1].iter[0].pos;
    p3 = lp->args[2].ptr + lp->args[2].iter[0].pos;

    *(double*)p3 = gsl_ran_multinomial_lnpdf(n,(double*)p1,(unsigned int *)p2);
}

/*
  @overload multinomial_ln(p[],n[],[axis0,axis1,..])
  
  @param [Numo::DFloat] p[]
  @param [Numo::UInt] n[]
  @return [Numo::DFloat]  return
  @param [Numeric,Array,Range] axis (keyword) Axes along which the operation is performed.
  @param [TrueClass] keepdims (keyword) If true, the reduced axes are left in the result array as dimensions with size one.

  This function returns the logarithm of the probability for the
multinomial distribution $P(n_1, n_2, \ldots, n_K)$
P(n_1, n_2, ..., n_K) with parameters p[K].
*/
static VALUE
pdf_s_multinomial_ln(int argc, VALUE *argv, VALUE mod)
{
    VALUE reduce;
    ndfunc_arg_in_t ain[3] = {{cDF,0},{cUI,0},{sym_reduce,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = { iter_pdf_s_multinomial_ln, NDF_HAS_LOOP|NDF_FLAT_REDUCE|NDF_EXTRACT,
                     3, 1, ain, aout };

    if (argc<2) {
        rb_raise(rb_eArgError,"wrong number of argument (%d for >=2)",argc);
    }

    reduce = nary_reduce_dimension(argc-2, argv+2, 2, argv, &ndf, 0);
    return na_ndloop(&ndf, 3, argv[0], argv[1], reduce);
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_negative_binomial(na_loop_t *const lp)
{
    
    unsigned int c0;
    double c1;
    double c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //p
    c2 = *(double*)(opt[1]); //n
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //k
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_negative_binomial_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload negative_binomial(k,p,n)
  
  @param [Numo::UInt] k
  @param [Float] p
  @param [Float] n
  @return [Numo::DFloat]  return

  This function computes the probability p(k) of obtaining k
from a negative binomial distribution with parameters p and
n, using the formula given above.
*/
static VALUE
pdf_s_negative_binomial(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    double c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_negative_binomial,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //p
    c2 = NUM2DBL(v2); opt[1] = &c2; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_pascal(na_loop_t *const lp)
{
    
    unsigned int c0;
    double c1;
    unsigned int c2;
    double c3;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(double*)(opt[0]); //p
    c2 = *(unsigned int*)(opt[1]); //n
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //k
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c3 = gsl_ran_pascal_pdf(c0,c1,c2);
    
    *(double*)GET_PTR(lp,1) = c3; //return
}

/*
  @overload pascal(k,p,n)
  
  @param [Numo::UInt] k
  @param [Float] p
  @param [Integer] n
  @return [Numo::DFloat]  return

  This function computes the probability p(k) of obtaining k
from a Pascal distribution with parameters p and
n, using the formula given above.
*/
static VALUE
pdf_s_pascal(VALUE mod,VALUE v0,VALUE v1,VALUE v2)
{
    
    double c1;
    unsigned int c2;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_pascal,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[2];
    
    c1 = NUM2DBL(v1); opt[0] = &c1; //p
    c2 = NUM2UINT(v2); opt[1] = &c2; //n
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_geometric(na_loop_t *const lp)
{
    
    unsigned int c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //p

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //k
    
    
    c2 = gsl_ran_geometric_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload geometric(k,p)
  
  @param [Numo::UInt] k
  @param [Float] p
  @return [Numo::DFloat]  return

  This function computes the probability p(k) of obtaining k
from a geometric distribution with probability parameter p, using
the formula given above.
*/
static VALUE
pdf_s_geometric(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_geometric,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //p
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_hypergeometric(na_loop_t *const lp)
{
    
    unsigned int c0;
    unsigned int c1;
    unsigned int c2;
    unsigned int c3;
    double c4;
    
#line 7 "../gen/tmpl/mod_func_noloop.c"
    void **opt = (void**)(lp->opt_ptr);
    
    c1 = *(unsigned int*)(opt[0]); //n1
    c2 = *(unsigned int*)(opt[1]); //n2
    c3 = *(unsigned int*)(opt[2]); //t
    

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //k
    
    
#line 18 "../gen/tmpl/mod_func_noloop.c"
    c4 = gsl_ran_hypergeometric_pdf(c0,c1,c2,c3);
    
    *(double*)GET_PTR(lp,1) = c4; //return
}

/*
  @overload hypergeometric(k,n1,n2,t)
  
  @param [Numo::UInt] k
  @param [Integer] n1
  @param [Integer] n2
  @param [Integer] t
  @return [Numo::DFloat]  return

  This function computes the probability p(k) of obtaining k
from a hypergeometric distribution with parameters n1, n2,
t, using the formula given above.
*/
static VALUE
pdf_s_hypergeometric(VALUE mod,VALUE v0,VALUE v1,VALUE v2,VALUE v3)
{
    
    unsigned int c1;
    unsigned int c2;
    unsigned int c3;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_hypergeometric,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
#line 46 "../gen/tmpl/mod_func_noloop.c"
    void *opt[3];
    
    c1 = NUM2UINT(v1); opt[0] = &c1; //n1
    c2 = NUM2UINT(v2); opt[1] = &c2; //n2
    c3 = NUM2UINT(v3); opt[2] = &c3; //t
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 1 "../gen/tmpl/mod_func_noloop.c"
static void
iter_pdf_s_logarithmic(na_loop_t *const lp)
{
    
    unsigned int c0;
    double c1;
    double c2;
    
#line 11 "../gen/tmpl/mod_func_noloop.c"
    void *opt = (void*)(lp->opt_ptr);
    c1 = *(double*)(opt); //p

    
    c0 = *(unsigned int*)GET_PTR(lp,0); //k
    
    
    c2 = gsl_ran_logarithmic_pdf(c0,c1);
    
    *(double*)GET_PTR(lp,1) = c2; //return
}

/*
  @overload logarithmic(k,p)
  
  @param [Numo::UInt] k
  @param [Float] p
  @return [Numo::DFloat]  return

  This function computes the probability p(k) of obtaining k
from a logarithmic distribution with probability parameter p,
using the formula given above.
*/
static VALUE
pdf_s_logarithmic(VALUE mod,VALUE v0,VALUE v1)
{
    
    double c1;
    

#line 38 "../gen/tmpl/mod_func_noloop.c"
    ndfunc_arg_in_t ain[1] = {{cUI,0}};
    ndfunc_arg_out_t aout[1] = {{cDF,0}};
    ndfunc_t ndf = {iter_pdf_s_logarithmic,NO_LOOP|NDF_INPLACE|NDF_EXTRACT,
                    1,1,ain,aout};
    
    void *opt;
    c1 = NUM2DBL(v1); opt = &c1; //p
    
    
#line 53 "../gen/tmpl/mod_func_noloop.c"
    return na_ndloop3(&ndf,opt,1,v0); 
}


#line 28 "../gen/tmpl/lib.c"
void
Init_pdf(void)
{
    VALUE mN;
    mN = rb_define_module("Numo");
    mG = rb_define_module_under(mN, "GSL");

    


#line 1 "../gen/tmpl/init_module.c"

    /*
      Document-module: Numo::GSL::Pdf
      
    */
    {
    
    mPdf = rb_define_module_under(mG, "Pdf");
    
    
    rb_define_module_function(mPdf, "gaussian", pdf_s_gaussian, 2);
    rb_define_module_function(mPdf, "ugaussian", pdf_s_ugaussian, 1);
    rb_define_module_function(mPdf, "gaussian_tail", pdf_s_gaussian_tail, 3);
    rb_define_module_function(mPdf, "ugaussian_tail", pdf_s_ugaussian_tail, 2);
    rb_define_module_function(mPdf, "bivariate_gaussian", pdf_s_bivariate_gaussian, 5);
    rb_define_module_function(mPdf, "exponential", pdf_s_exponential, 2);
    rb_define_module_function(mPdf, "laplace", pdf_s_laplace, 2);
    rb_define_module_function(mPdf, "exppow", pdf_s_exppow, 3);
    rb_define_module_function(mPdf, "cauchy", pdf_s_cauchy, 2);
    rb_define_module_function(mPdf, "rayleigh", pdf_s_rayleigh, 2);
    rb_define_module_function(mPdf, "rayleigh_tail", pdf_s_rayleigh_tail, 3);
    rb_define_module_function(mPdf, "landau", pdf_s_landau, 1);
    rb_define_module_function(mPdf, "gamma", pdf_s_gamma, 3);
    rb_define_module_function(mPdf, "flat", pdf_s_flat, 3);
    rb_define_module_function(mPdf, "lognormal", pdf_s_lognormal, 3);
    rb_define_module_function(mPdf, "chisq", pdf_s_chisq, 2);
    rb_define_module_function(mPdf, "fdist", pdf_s_fdist, 3);
    rb_define_module_function(mPdf, "tdist", pdf_s_tdist, 2);
    rb_define_module_function(mPdf, "beta", pdf_s_beta, 3);
    rb_define_module_function(mPdf, "logistic", pdf_s_logistic, 2);
    rb_define_module_function(mPdf, "pareto", pdf_s_pareto, 3);
    rb_define_module_function(mPdf, "weibull", pdf_s_weibull, 3);
    rb_define_module_function(mPdf, "gumbel1", pdf_s_gumbel1, 3);
    rb_define_module_function(mPdf, "gumbel2", pdf_s_gumbel2, 3);
    rb_define_module_function(mPdf, "dirichlet", pdf_s_dirichlet, -1);
    rb_define_module_function(mPdf, "dirichlet_ln", pdf_s_dirichlet_ln, -1);
    rb_define_module_function(mPdf, "poisson", pdf_s_poisson, 2);
    rb_define_module_function(mPdf, "bernoulli", pdf_s_bernoulli, 2);
    rb_define_module_function(mPdf, "binomial", pdf_s_binomial, 3);
    rb_define_module_function(mPdf, "multinomial", pdf_s_multinomial, -1);
    rb_define_module_function(mPdf, "multinomial_ln", pdf_s_multinomial_ln, -1);
    rb_define_module_function(mPdf, "negative_binomial", pdf_s_negative_binomial, 3);
    rb_define_module_function(mPdf, "pascal", pdf_s_pascal, 3);
    rb_define_module_function(mPdf, "geometric", pdf_s_geometric, 2);
    rb_define_module_function(mPdf, "hypergeometric", pdf_s_hypergeometric, 4);
    rb_define_module_function(mPdf, "logarithmic", pdf_s_logarithmic, 2);
#line 12 "../gen/tmpl/init_module.c"
    }
#line 41 "../gen/tmpl/lib.c"
}
