private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "__fsetlocking"
		size = 32
	strings:
		$1 = { 03 68 02 46 13 F4 00 4F 0C BF 01 20 02 20 31 B1 23 F4 00 43 02 29 08 BF 43 F4 00 43 13 60 70 47 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "prefixcmp"
		size = 22
	strings:
		$1 = { 03 69 0A 69 93 42 04 D3 0C BF 00 20 6F F0 00 00 70 47 01 20 70 47 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "scopecmp"
		size = 22
	strings:
		$1 = { 43 68 4A 68 93 42 03 D8 0C BF 00 20 01 20 70 47 4F F0 FF 30 70 47 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "match_prefix"
		size = 170
	strings:
		$1 = { 03 88 2D E9 F0 03 02 2B 88 B0 07 D0 0A 2B 18 BF 10 46 16 D0 08 B0 BD E8 F0 03 70 47 46 88 00 23 42 68 01 A8 0A 25 05 93 4F F6 FF 74 02 93 03 93 04 93 07 93 AD F8 06 60 06 92 AD F8 04 50 AD F8 16 40 0B 69 00 F1 08 08 01 F1 01 0C 4F F4 7F 49 07 2B 22 D9 1C F8 01 4C 02 7A 94 42 17 D1 08 F1 01 04 62 46 03 E0 2F 78 35 78 AF 42 0F D1 08 3B 15 46 07 2B 26 46 02 F1 01 02 04 F1 01 04 F2 D8 34 78 49 FA 03 F3 2A 78 62 40 1A 42 08 D0 18 31 0B 69 0C F1 18 0C 07 2B DC D8 46 46 0D 46 EF E7 48 69 08 B0 BD E8 F0 03 70 47 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "gaiconf_init"
		size = 2148
		refs = "0004 .LC0 000a .LC1 0028 _IO_new_fopen 0034 fileno 003e __fxstat64 0074 __getline 0084 strchr 01a2 .LC5 01aa strcmp 01ea inet_pton 0204 strtoul 0222 .LC4 02bc malloc 0304 .LC3 032e .LANCHOR0 034e .LC2 03a8 __libc_tsd_CTYPE_B 03ac __libc_errno 03cc free 03d2 _IO_new_fclose 03de .LANCHOR1 045a prefixcmp 046a qsort 04f2 scopecmp 0656 fini"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? AF B0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 24 09 94 0A 94 8D F8 22 40 0B 94 0C 94 8D F8 23 40 ?? ?? ?? ?? 06 46 00 28 00 F0 1A 83 ?? ?? ?? ?? 14 AA 01 46 03 20 ?? ?? ?? ?? 00 28 40 F0 48 83 DF F8 68 83 DF F8 68 93 34 68 03 90 0D 90 44 F4 00 44 0E 90 04 90 34 60 07 90 14 F0 10 04 4F F0 00 07 40 F0 AC 81 0D A8 0E A9 32 46 ?? ?? ?? ?? 00 28 40 F3 A4 81 0D 9D 23 21 28 46 ?? ?? ?? ?? 00 28 00 F0 3D 82 04 70 0D 98 43 46 1D EE 70 BF 7B 44 1B 68 01 78 5B F8 03 30 33 F8 11 20 95 04 07 D5 42 1C 10 46 12 F8 01 1B 33 F8 11 40 A4 04 F8 D4 00 29 00 F0 D0 82 45 1C 04 E0 33 F8 12 20 92 04 00 F1 5C 81 2C 46 01 35 22 78 00 2A F5 D1 1A 88 C0 EB 04 0C 02 F4 00 52 92 B2 00 21 3A B1 62 1C 14 46 12 F8 01 1B 33 F8 11 50 AD 04 F8 D4 00 29 00 F0 07 82 33 F8 11 20 95 04 00 F1 02 82 04 F1 01 0E 03 E0 33 F8 11 20 92 04 04 D4 75 46 1E F8 01 1B 00 29 F6 D1 85 42 00 F0 4B 81 1A 46 39 B1 00 22 2A 70 9E 4A 01 35 7A 44 12 68 5B F8 02 20 2F 78 0F FA 87 FE 32 F8 1E 10 89 04 09 D5 69 1C 0D 46 11 F8 01 7B 0F FA 87 FE 32 F8 1E 30 9B 04 F6 D4 00 2F 00 F0 D7 81 32 F8 1E 10 8B 04 00 F1 D2 81 69 1C 03 E0 32 F8 13 30 9F 04 04 D4 8E 46 11 F8 01 3B 00 2B F6 D1 AC F1 05 0C 00 22 8E F8 00 20 BC F1 05 0F 45 D8 DF E8 1C F0 DC 00 B7 00 46 00 44 00 44 00 06 00 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 35 D1 0D F1 23 01 0C AA 0B AB 06 91 05 92 02 93 7A 4F 20 46 2F 21 00 22 7F 44 3F 68 4B F8 07 20 10 AF 01 92 ?? ?? ?? ?? 01 9A 82 46 00 28 00 F0 8F 82 02 70 21 46 3A 46 0A 20 ?? ?? ?? ?? B0 B1 1A F1 01 00 00 F0 8C 82 0D F1 3C 0C 0A 22 61 46 CD F8 04 C0 ?? ?? ?? ?? DD F8 04 C0 42 1C 04 46 05 D0 0F 9A 12 78 12 B9 80 28 40 F2 81 82 34 68 1F E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 07 46 00 28 F4 D1 5E 4A 20 46 2F 21 7A 44 12 68 4B F8 02 70 ?? ?? ?? ?? 00 28 00 F0 C4 82 07 70 47 1C 0A 20 21 46 10 AA ?? ?? ?? ?? 00 28 00 F0 06 82 10 9A 00 2A DB D1 11 9A 00 2A D8 D1 12 9A 12 F5 80 3F D4 D1 00 2F 00 F0 D0 82 38 46 0F A9 0A 22 ?? ?? ?? ?? 04 46 01 30 00 F0 A6 82 0F 9A 12 78 00 2A C4 D1 A4 F1 60 02 20 2A C0 D8 28 46 0F A9 0A 22 ?? ?? ?? ?? 41 1C 05 46 00 F0 AD 82 0F 9B 1B 78 00 2B B3 D1 00 2D B1 DB 10 20 ?? ?? ?? ?? 00 28 00 F0 BE 82 60 2C 08 BF 00 23 06 D0 4F F0 FF 32 C4 F1 80 03 02 FA 03 F3 1B BA 03 99 13 9A 60 2C 08 BF 41 F0 01 01 43 60 0C 46 07 99 13 40 85 60 E4 B2 07 90 C1 60 04 99 03 94 01 31 03 60 04 91 8C E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 84 D1 23 78 D3 F1 79 02 29 D1 62 78 D2 F1 65 02 25 D1 A2 78 D2 F1 73 02 21 D1 E2 78 ?? ?2 0? 0? ?? ?2 0? 0? D2 F1 01 02 38 BF 00 22 DA 60 00 2A 3F F4 6C AF 01 22 34 68 1A 61 89 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 7F F4 5F AF 0D F1 22 02 0A AB 09 A8 06 92 05 93 02 90 27 E7 ?? ?2 0? 0? D2 F1 01 02 ?? ?2 0? 0? 38 BF 00 22 34 68 DA 60 6D E6 4B 46 27 70 7B 44 1B 68 61 78 C0 EB 04 0C 2C 46 5B F8 03 30 33 F8 11 20 02 F4 00 52 92 B2 9F E6 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 34 68 14 F0 10 04 3F F4 54 AE 0D 98 DD F8 1C A0 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 0A 9B 00 2B 40 F0 9B 80 ?? ?2 0? 0? 0C 9B ?? ?2 0? 0? C8 46 00 2B 00 F0 DB 80 9D F8 23 40 1D 46 00 2C 00 F0 77 81 05 EB 45 00 C0 00 ?? ?? ?? ?? 02 90 00 28 00 F0 EE 81 AC 46 00 2C 00 F0 CC 81 BC F1 00 0F 0B 9F 19 DD AC EB 8C 0B 02 9D 0C EB 4C 0C BE 46 00 26 4F EA CB 0B 05 EB CC 0C 3D 46 0C EB 06 04 18 3C 18 3E 0F CD 5E 45 0F C4 95 E8 03 00 84 E8 03 00 BF 69 F1 D1 77 46 38 46 00 2F 40 F0 D0 80 ?? ?2 0? 0? 02 98 ?? ?2 0? 0? 0C 99 18 22 A2 4D ?? ?? ?? ?? 04 98 00 28 00 F0 9E 80 03 99 09 B9 01 30 04 90 04 9A 02 EB 42 00 80 00 ?? ?? ?? ?? 04 46 00 28 00 F0 BA 80 03 98 DD F8 10 E0 48 B9 0E F1 FF 3E 0E 21 0E EB 4E 02 92 00 A3 18 A0 50 58 60 99 60 BE F1 00 0F 13 DD AE EB 8E 0C 0E EB 4E 0E 53 46 00 26 4F EA 8C 0C 04 EB 8E 0E 93 E8 07 00 0E EB 06 07 0C 3E 66 45 07 E9 07 00 DB 68 F5 D1 50 46 BA F1 00 0F 01 D1 05 E0 30 46 C6 68 ?? ?? ?? ?? 00 2E F9 D1 ?? ?2 0? 0? 04 99 ?? ?2 0? 0? 20 46 0C 22 7D 4F ?? ?? ?? ?? 56 E0 28 46 C2 E5 25 46 07 E6 AE 46 36 E6 9D F8 22 40 1D 46 00 2C 00 F0 E1 80 05 EB 45 00 C0 00 ?? ?? ?? ?? 80 46 00 28 75 D0 AC 46 00 2C 00 F0 28 81 BC F1 00 0F 09 9F 18 DD AC EB 8C 09 0C EB 4C 0C BE 46 00 26 4F EA C9 09 08 EB CC 0C 3D 46 0C EB 06 04 18 3C 18 3E 0F CD 4E 45 0F C4 95 E8 03 00 84 E8 03 00 BF 69 F1 D1 77 46 38 46 0F B9 05 E0 20 46 84 69 ?? ?? ?? ?? 00 2C F9 D1 ?? ?2 0? 0? 40 46 ?? ?2 0? 0? 0A 99 18 22 ?? ?2 0? 0? ?? ?? ?? ?? 0C 9B ?? ?2 0? 0? 00 2B 7F F4 25 AF 53 4D 04 98 02 95 00 28 7F F4 62 AF 51 4F 3C 46 ?? ?2 0? 0? ?? ?2 0? 0? 30 68 C6 F8 00 80 48 45 01 D0 ?? ?? ?? ?? 70 68 02 9A A8 42 72 60 01 D0 ?? ?? ?? ?? B0 68 B4 60 B8 42 01 D0 ?? ?? ?? ?? 28 AA 44 4B 92 E8 03 00 83 E8 03 00 2F B0 BD E8 F0 8F 20 46 84 69 ?? ?? ?? ?? 00 2C F9 D1 29 E7 C8 45 02 D0 40 46 ?? ?? ?? ?? 02 9B AB 42 02 D0 18 46 ?? ?? ?? ?? 09 98 08 B9 05 E0 20 46 84 69 ?? ?? ?? ?? 00 2C F9 D1 0B 98 08 B9 05 E0 20 46 84 69 ?? ?? ?? ?? 00 2C F9 D1 50 46 BA F1 00 0F 01 D1 05 E0 20 46 C4 68 ?? ?? ?? ?? 00 2C F9 D1 ?? ?? ?? ?? 2F B0 BD E8 F0 8F 0A 46 04 46 8C 46 3D E5 82 46 D7 E7 21 46 02 20 13 AA ?? ?? ?? ?? 00 28 3F F4 D1 AD 00 2F 00 F0 D7 80 0D F1 3C 0C 0A 22 61 46 38 46 CD F8 04 C0 ?? ?? ?? ?? DD F8 04 C0 42 1C 04 46 3F F4 BF AD 0F 9A 12 78 00 2A 7F F4 BA AD 20 28 3F F6 B7 AD 28 46 61 46 0A 22 ?? ?? ?? ?? 43 1C 05 46 00 F0 AE 80 0F 9B 1B 78 00 2B 7F F4 A9 AD 00 2D A8 BF 60 34 BF F6 F2 AD A2 E5 30 46 A2 46 ?? ?? ?? ?? 9C E7 01 33 0A 93 1D 46 1A E7 01 33 0C 93 1D 46 84 E6 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 21 46 3A 46 0A 20 ?? ?? ?? ?? 00 28 3F F4 87 AD 0F 9A 80 24 0D F1 3C 0C 12 78 00 2A 7F F4 7F AD 28 46 61 46 0A 22 ?? ?? ?? ?? 43 1C 05 46 63 D0 0F 9B 1B 78 00 2B 7F F4 72 AD 00 2D FF F6 6F AD 1C 20 ?? ?? ?? ?? 86 46 00 28 7A D0 97 E8 0F 00 CE F8 14 50 02 9D CE F8 10 40 8E E8 0F 00 2B 68 05 9D CE F8 18 30 2A 68 06 9D 01 32 29 78 05 9D 00 2C 14 BF 0C 46 41 F0 01 04 2A 60 02 9D C5 F8 00 E0 06 9D 2C 70 4A E5 05 F1 FF 3C 01 20 0C EB 4C 01 C9 00 08 EB 01 03 03 F1 08 02 48 F8 01 40 5C 60 42 F8 04 4B 14 60 1C 61 58 61 C4 E6 05 F1 FF 3C 02 9B 02 9D 28 20 0C EB 4C 01 C9 00 0B 44 03 F1 08 02 6C 50 5C 60 42 F8 04 4B 14 60 1C 61 58 61 20 E6 07 46 3B E5 1E 4A 7A 44 12 68 5B F8 02 20 22 2A 7F F4 52 AD 19 E5 C8 45 3F F4 16 AF 40 46 ?? ?? ?? ?? 11 E7 17 4A 7A 44 12 68 5B F8 02 30 22 2B 94 D1 0A E5 14 4A 7A 44 12 68 5B F8 02 30 22 2B 7F F4 4B AD 01 E5 80 24 36 E5 10 4A 7A 44 12 68 5B F8 02 30 22 2B 7F F4 4A AF F6 E4 0F 9A 12 78 00 2A 7F F4 F2 AC 20 24 0D F1 3C 0C 36 E7 0D 98 DD F8 1C A0 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? E3 E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "gaih_inet_serv.isra.2"
		size = 126
		refs = "0036 __getservbyname_r"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 02 AF 89 46 80 46 93 46 9A 46 01 F1 0A 06 4F F4 80 64 3D 1D 04 F1 0E 03 40 46 23 F0 07 03 31 46 AD EB 03 0D 07 F1 08 02 02 AB 00 94 64 00 01 95 ?? ?? ?? ?? A8 B9 7B 68 AB B1 D9 F8 00 20 8A E8 05 00 99 F8 08 20 92 07 13 D5 DB F8 00 20 9B 68 00 20 CA F8 08 20 1C 37 CA F8 0C 30 BD 46 BD E8 F0 8F 22 28 D6 D0 4F F4 84 70 1C 37 BD 46 BD E8 F0 8F D9 F8 04 20 EA E7 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "gaih_inet"
		size = 6080
		refs = "0134 __idna_to_ascii_lz 0160 __inet_aton 01b2 free 025c malloc 034e strchr 036c inet_pton 03bc strtoul 0530 __idna_to_unicode_lzlz 05ec __nss_not_use_nscd_hosts 0608 __nss_database_custom 0618 __nss_hosts_database 062c _res_hconf 0656 __res_maybe_init 06d2 .LC10 06de __nss_lookup_function 073e .LC8 07a6 _dl_mcount_wrapper_check 07e0 realloc 08e0 __libc_resp 08e8 __libc_errno 08ec __libc_h_errno 0c06 in6addr_loopback 0cdc __gethostbyname2_r 0d08 .LC9 0d38 if_nametoindex 0d60 __nscd_getai 0e86 memcpy 0eba strlen 0f34 __libc_alloca_cutoff 1092 __strdup 1248 __gethostbyaddr_r 12b2 .LC6 12b6 .LC7 12c6 __nss_database_lookup 13de .LC11 1522 _res_hconf_init 1530 .LC12 1534 .LC13 1538 __PRETTY_FUNCTION__.16002 154c __assert_fail 1668 mempcpy 171a __strndup"
	strings:
		$1 = { 2D E9 F0 4F A9 B0 88 4C 06 AF 9B 46 D6 68 00 23 B8 64 92 46 0D 46 FC 65 3B 66 90 68 06 B9 40 B3 82 4B A3 F1 14 01 70 B1 53 F8 14 2C 82 42 0A D0 14 33 13 F8 0A 2C 00 2A F3 D1 40 F2 07 10 8C 37 BD 46 BD E8 F0 8F AE B1 13 F8 0C 2C 92 07 11 D4 53 F8 10 2C 96 42 0D D0 14 33 13 F8 0A 2C 00 2A DF D1 00 28 E9 D1 4F F4 84 70 8C 37 BD 46 BD E8 F0 8F 6F 49 65 B1 0B 7A DB 07 F4 D4 6B 68 00 2B A2 BF C3 F3 07 22 42 EA 03 23 9D B2 C0 F2 1B 81 08 BB 06 BB 8B 7F 00 2B 00 F0 15 85 28 31 34 46 07 F1 5C 00 05 E0 14 31 11 F8 0A 3C 00 2B 00 F0 84 80 11 F8 0B 3C 00 2B F5 D0 51 F8 14 2C 86 B0 06 AB 10 36 06 94 07 92 51 F8 10 2C 09 95 08 92 03 60 18 46 E7 E7 86 B0 08 7A 06 AA 00 24 0B 68 14 60 84 07 FA 65 4F F0 30 04 58 BF 4E 68 53 60 FC 62 96 60 D5 60 BD 6C 00 2D 00 F0 AE 81 8A B0 DA F8 00 10 06 AB 00 22 3B 66 9A 60 DA 61 1A 60 11 F0 40 02 00 F0 D2 80 07 F1 88 04 88 05 C1 F3 00 22 4F F0 00 03 48 BF 42 F0 02 02 44 F8 14 3D B8 6C 21 46 ?? ?? ?? ?? 78 66 38 B1 C9 28 00 F0 2D 82 CA 28 14 BF 69 20 0B 20 8E E7 7C 6F BD 6C 39 6E 2D 1B 7C 63 18 BF 01 25 7D 62 0C 31 78 6B ?? ?? ?? ?? 00 28 2B D0 DA F8 04 30 33 F0 02 05 00 F0 31 81 0A 2B 1E BF 00 25 4F F0 09 09 7D 64 00 F0 7D 84 3D 63 BD 63 BD 62 FD 63 3D 64 7C 6A 00 2C 40 F0 4E 81 3D 6C 00 2D 40 F0 46 81 BC 6A 00 2C 40 F0 3E 81 3D 6B 48 46 00 2D 3F F4 5D AF 78 6C ?? ?? ?? ?? 48 46 57 E7 20 36 FE 62 9A E7 3E 6E D6 F8 08 80 B8 F1 00 0F 00 F0 BE 80 F8 64 B1 46 00 24 7C 64 3C 63 BC 63 BC 62 FC 63 3C 64 3C 62 FE 6C 4D 46 4F F0 00 08 C7 F8 54 90 7C 6D A5 42 00 F0 86 81 7C 6D B4 F8 08 90 B9 F1 0A 0F 1C BF 10 25 3D 65 00 F0 1C 81 FD 6D 00 2D 00 F0 F3 80 3C 6D 5B 46 4A 46 D3 46 20 34 B1 46 FC 64 16 46 9A 46 19 E0 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 68 D7 F8 54 A0 63 84 DA F8 0C 00 C4 F8 28 80 C4 F8 2C 80 60 62 2D 68 04 F1 1C 0A 00 2D 00 F0 CD 80 4F F0 00 09 F8 6C ?? ?? ?? ?? 04 46 CA F8 00 00 00 28 00 F0 D3 80 DB F8 00 10 0A 2E 6A 68 00 F1 20 00 AB 68 84 E8 42 00 39 6D A2 60 E3 60 21 61 C4 F8 18 90 26 84 C4 F8 1C 80 60 61 CF D1 EA 68 04 F1 28 09 7B 6D C4 F8 24 80 62 84 53 F8 0C 0F D7 F8 54 A0 59 68 9A 68 DB 68 A9 E8 0F 00 DA F8 1C 30 A3 63 C6 E7 BC 6C 19 46 7A 62 7C 63 4A E7 8B 7A 00 2B 40 F0 57 81 8A 7F 00 2A 3F F4 C8 AE 0A F1 0C 0C 07 F1 5C 00 C7 F8 50 B0 01 F1 28 06 78 65 A8 46 9B 46 E1 46 09 E0 56 F8 14 0C 82 42 0F D0 14 36 16 F8 0A 3C 00 2B 00 F0 30 81 16 F8 0C 3C A6 F1 14 01 DA 07 F3 D4 DA F8 08 20 00 2A EB D1 DA F8 0C 20 2A B1 9B 07 03 D4 56 F8 10 3C 9A 42 E6 D1 86 B0 D8 F8 00 00 06 AD 4A 46 2B 46 0B F1 10 0B FF F7 21 FE 78 66 00 28 7A D0 C5 05 D7 D4 8F E6 78 6B 25 21 ?? ?? ?? ?? 05 1C 04 46 18 BF 01 25 00 2D 41 F0 4B 81 D7 F8 34 80 06 F1 0C 02 41 46 0A 20 ?? ?? ?? ?? 06 46 00 2E 40 F3 96 83 DA F8 04 30 00 2B 18 BF 0A 2B 14 BF 00 21 01 21 40 F0 0A 81 3B 6E 0A 22 1E 46 9A 60 00 2D 00 F0 10 81 F2 68 4C F2 FF 03 48 F2 FE 01 13 40 8B 42 00 F0 C4 84 33 7B FF 2B 00 F0 BA 84 60 1C 07 F1 74 01 0A 22 ?? ?? ?? ?? 7B 6F F0 61 1B 78 00 2B 00 F0 F6 80 00 25 4F F4 81 79 7D 64 D6 E6 3B 6E 02 22 DA F8 00 10 1E 46 9A 60 7C 6B 11 F0 02 0F 08 BF 00 24 FC 64 EF E6 53 46 2E 46 DA 46 9B 46 D7 F8 B0 00 03 68 01 33 03 60 7C 6D 24 68 7C 65 00 2C 00 F0 4E 87 3D 6E ED E6 48 46 C7 F8 4C 90 4F F0 0A 09 ?? ?? ?? ?? B5 E6 B8 6B ?? ?? ?? ?? BD E6 F8 6B ?? ?? ?? ?? B5 E6 78 6B ?? ?? ?? ?? AD E6 79 6D 7D 65 0D 60 5A E7 3D 6A 00 2D 59 D0 DA F8 00 30 03 F0 18 03 08 2B 4A D0 1C 25 3D 65 D7 E6 8A B0 B8 6C 06 AC DA F8 04 50 23 46 3C 66 43 F8 04 0B 04 33 60 60 43 F8 04 0B 43 F8 04 0B 43 F8 04 0B 43 F8 04 0B 43 F8 04 0B 18 60 00 2D 00 F0 AB 82 00 2D 18 BF 0A 2D 18 BF 23 46 07 D1 DA F8 00 30 0A 22 A2 60 D9 07 40 F1 B0 83 23 68 35 F0 02 05 18 D1 DA F8 00 20 02 21 99 60 12 F0 01 02 12 D1 FA 64 A1 46 FC 6C 7F 22 C0 F2 00 12 DA 60 25 46 7C 63 7D 64 3D 63 BD 63 BD 62 FD 63 3D 64 7D 62 3D 62 80 E6 00 25 FD 64 A1 46 7D 63 F1 E7 E3 68 33 B9 23 69 00 2B AF D1 63 69 13 F5 80 3F 82 D0 1C 24 3C 65 83 E6 DA F8 00 30 9A 07 7F F5 75 AE 00 24 A4 46 00 2E 00 F0 7A 86 18 06 1D D5 99 05 C3 F3 00 22 48 BF 42 F0 02 02 30 46 07 F1 74 01 C7 F8 08 C0 ?? ?? ?? ?? D7 F8 08 C0 00 28 41 F0 27 80 7B 6F B3 42 18 BF 1E 46 06 D0 00 2C 3F F4 54 AE 60 46 ?? ?? ?? ?? 4F E6 BD 6A 00 2D 00 F0 97 85 00 25 BD 62 F1 E7 FB 6D D9 46 D7 F8 50 B0 A3 42 3F F4 7A AD 09 F1 20 09 C7 F8 2C 90 BC E5 86 B0 28 68 06 AC 0A F1 0C 02 23 46 FC 65 FF F7 F9 FC 78 66 00 28 7F F4 6A AD 30 24 FC 62 AC E5 0A 20 64 E5 02 2B 00 F0 46 83 79 64 4F F0 09 09 39 63 B9 63 B9 62 F9 63 39 64 EA E5 3E 6E DA F8 00 30 13 F0 02 03 0B BF FB 64 7C 6B B3 68 B3 68 18 BF FC 64 00 2B 7F F4 FD AD DA F8 00 20 51 07 00 F1 07 81 DA F8 04 20 BB 66 02 2A 00 F0 37 83 ?? ?2 0? 0? ?? ?2 0? 0? 22 68 00 2A 40 F3 E2 82 01 32 64 2A D4 BF 22 60 23 60 07 DD ?? ?2 0? 0? ?? ?2 0? 0? 1B 79 00 2B 00 F0 9C 83 ?? ?2 0? 0? ?? ?2 0? 0? 19 68 00 29 00 F0 45 86 00 24 B9 66 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 00 2B 00 F0 73 87 1D EE 70 5F FD 61 FD 6A 00 21 A6 4B 05 F5 84 65 3D 64 FD 69 7B 44 1B 68 E8 58 ?? ?? ?? ?? A2 4B 7B 44 1B 68 EE 58 B5 68 7D 61 25 F4 00 55 B5 60 B0 F1 FF 3F 08 BF 01 24 38 6C B0 F5 80 5F 00 F2 34 87 AD F5 85 6D 00 21 06 AA 39 63 7A 64 00 2C 41 F0 21 80 07 F1 60 05 C7 F8 3C A0 4F F4 84 69 C7 F8 00 90 A9 46 FD 6B 4F F0 FF 3C 7E 6C C7 F8 10 B0 6D 68 B8 6E BC 63 BC 62 3C 62 C7 F8 2C C0 BC 61 D7 F8 30 B0 7D 64 00 2D 3A D0 FD 6B 2B 68 9C 07 00 F1 1B 83 ?? ?2 0? 0? C7 F8 08 C0 ?? ?2 0? 0? ?? ?? ?? ?? D7 F8 08 C0 80 46 00 28 40 F0 03 81 7E 4B FD 69 7B 44 1B 68 EB 58 33 F0 02 03 00 F0 FF 84 7A 4A 4F F0 FF 33 D7 F8 1C A0 05 46 7A 44 12 68 9C 46 01 24 7C 64 4A F8 02 30 7C 6C BB 6E 03 EB 84 02 52 68 01 2A 00 F0 DA 84 18 68 00 28 00 F0 6E 81 FD 6B B8 66 6D 68 7D 64 00 2D C4 D1 ?? ?2 0? 0? C7 F8 08 C0 ?? ?2 0? 0? ?? ?? ?? ?? D7 F8 08 C0 05 46 00 28 00 F0 D7 87 07 F1 74 0A 07 F1 64 04 C7 F8 50 A0 7C 65 D7 F8 44 80 3C 68 D7 F8 34 A0 15 E0 3A 6C 63 00 1A 44 B2 F5 80 5F 00 F2 B5 87 0F 33 23 F0 0F 03 03 F1 08 01 AD EB 01 0D 06 A8 C1 18 8E 42 00 F0 8C 80 1C 46 3A 64 06 46 28 46 C7 F8 64 80 ?? ?? ?? ?? 78 6D 39 6D 32 46 CD F8 08 80 23 46 00 90 50 46 01 91 49 46 A8 47 01 28 31 D0 81 1C 29 D1 7B 6E 22 2B 22 D1 7B 6F 5A 1C 15 D1 BB F1 00 0F CC D0 64 00 30 46 21 46 ?? ?? ?? ?? 00 28 67 D0 4F F0 01 0B D7 E7 7B 64 4F F4 81 79 3B 63 BB 63 BB 62 FB 63 3B 64 C6 E4 84 46 3C 60 02 2B 00 F0 5B 81 1A 1F 55 42 55 41 BD 61 82 E7 84 46 3C 60 7B 6F F3 E7 85 1C 84 46 3C 60 7B 6F 7D 64 F0 E7 D7 F8 3C A0 84 46 3C 60 DA F8 00 30 9B 07 00 F1 3A 81 D9 F8 00 30 00 20 3C 68 01 25 CF F6 FF 70 4F F0 00 08 6B B3 99 68 D7 F8 3C A0 02 29 DA F8 04 20 06 D0 BA B1 8A 42 19 D0 1B 68 C9 F8 00 30 F0 E7 0A 2A F6 D1 DA F8 00 10 09 07 F5 D5 D9 68 99 46 9A 60 00 25 58 61 C3 F8 10 80 99 61 C3 F8 0C 80 1B 68 DE E7 99 46 15 46 1B 68 DA E7 0A 2A 99 46 08 BF 01 21 1B 68 4F F0 00 05 08 BF 39 62 D0 E7 3C 60 03 24 7C 64 AE E7 1C 44 3A 64 72 E7 0D 4B 4F F0 0A 09 FD 69 C7 F8 30 B0 7E 64 F8 63 7B 44 1B 68 7C 69 EB 58 04 F4 00 52 38 64 99 68 0A 43 9A 60 57 E4 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D7 F8 3C A0 DA F8 04 30 0A 2B 18 BF 00 2B 14 BF 00 25 01 25 4B D1 07 F1 6C 04 00 25 7C 64 07 F1 74 0A 07 F1 70 04 C7 F8 30 90 3C 65 07 F1 64 04 3D 67 7C 65 D7 F8 34 90 3C 68 12 E0 FB 6E 59 1C 40 F0 E2 82 63 00 0F 33 23 F0 0F 03 03 F1 08 02 AD EB 02 0D 06 AA D1 18 8E 42 16 46 08 BF 1B 19 1C 46 40 46 7D 66 ?? ?? ?? ?? 78 6D 79 6C 52 46 3B 6D 01 90 48 46 02 91 0A 21 04 93 33 46 00 94 03 95 C0 47 7B 6E 22 2B D8 D0 01 28 D7 F8 30 90 84 46 3C 60 F8 62 00 F0 91 83 00 2B 40 F0 19 86 1D 46 F8 62 D7 F8 3C A0 BD 61 DA F8 04 30 33 F0 02 00 00 F0 B2 80 0A 2B 00 F0 A4 80 D7 F8 2C A0 BA F1 01 0F 18 BF BC F1 01 0F 14 BF 00 23 01 23 40 F0 83 80 FC 6B 23 68 9C 07 03 D5 FC 6C 00 2C 00 F0 03 85 03 24 4F F0 01 0C 7C 64 9B E6 8A B0 DA F8 04 50 06 AA 22 60 13 46 43 F8 04 0B 04 33 07 90 43 F8 04 0B 43 F8 04 0B 43 F8 04 0B 43 F8 04 0B 43 F8 04 0B 18 60 3E E5 9F 4B FC 69 C7 F8 30 B0 7E 64 7B 44 1B 68 D7 F8 18 80 E3 58 D7 F8 3C A0 D7 F8 10 B0 98 68 7C 69 98 4A 04 F4 00 51 FC 69 01 43 99 60 7A 44 12 68 A3 58 01 33 00 F0 B5 84 B8 F1 00 0F 18 BF 00 2D 0C BF 00 22 01 22 00 F0 A5 84 15 F1 03 0F 08 BF 18 F1 03 0F 14 BF 4F F0 00 0B 4F F0 01 0B 40 F0 A7 84 00 25 4F F0 03 09 FD 63 3D 64 FF F7 88 BB DA F8 00 10 11 F0 08 02 00 F0 CA 80 3A 6E 00 24 20 46 CF F6 FF 74 16 46 D5 68 93 60 54 61 95 61 10 61 D0 60 9E E4 3E 6E 00 24 FC 64 B3 68 90 E5 FC 6C D9 F8 00 30 00 2C 7F F4 C2 AE 5D 68 FD 64 BE E6 6F F0 02 05 A4 E6 20 24 FC 62 FF F7 14 BB D7 F8 2C A0 1A F1 02 0F 00 F0 3F 82 1A F1 01 03 18 BF 01 23 BC F1 FF 3F 18 BF 00 23 00 2B 40 F0 18 82 0C F1 02 04 7C 64 10 E6 FC 6B 23 68 1C 07 7F F5 57 AF D8 06 03 D4 3C 6A 00 2C 7F F4 51 AF 07 F1 6C 04 00 25 7C 64 07 F1 74 0A 07 F1 70 04 C7 F8 30 90 3C 65 07 F1 64 04 3D 67 7C 65 D7 F8 34 90 3C 68 11 E0 FB 6E 59 1C 45 D1 63 00 0F 33 23 F0 0F 03 03 F1 08 02 AD EB 02 0D 06 AA D1 18 8E 42 16 46 08 BF 1B 19 1C 46 40 46 7D 66 ?? ?? ?? ?? 78 6D 79 6C 52 46 3B 6D 01 90 48 46 02 91 02 21 04 93 33 46 00 94 03 95 C0 47 7B 6E 22 2B D9 D0 01 28 D7 F8 30 90 78 65 84 46 3C 60 00 F0 F6 81 1D 46 43 B3 FB 6E 5A 1C 40 F0 02 86 3D 49 FD 69 79 44 09 68 3C 4A 7C 69 6B 50 7A 44 12 68 04 F4 00 50 AB 58 9A 68 02 43 9A 60 0B 20 FF F7 55 BA 7F F4 2A AD 20 E5 D7 F8 30 90 84 46 78 65 3C 60 02 2B 08 BF 6F F0 02 05 05 D0 B3 F1 04 08 D8 F1 00 05 55 EB 08 05 D7 F8 3C A0 FC 6A DA F8 04 30 D7 F8 54 A0 02 2B 08 BF 54 46 FC 62 BC 69 08 BF 2C 46 BC 61 D4 E6 ?? ?2 0? 0? 04 F1 0C 06 ?? ?2 0? 0? DA F8 04 50 0F CB 86 E8 0F 00 43 E4 7A 64 4F F0 09 09 3A 63 BA 63 BA 62 FA 63 3A 64 FF F7 AE BA 3A 6E D0 68 00 28 7F F4 B5 AC 11 69 00 29 40 F0 67 82 50 69 10 F5 80 3F 7F F4 AC AC 91 69 16 46 93 60 D1 60 FF F7 9D BB FD 6A AD F5 36 7D 06 AC 4F F4 34 76 7C 64 07 F1 74 04 05 F5 34 75 C7 F8 54 A0 FD 62 B2 46 3B 63 26 46 07 F1 6C 08 07 F1 70 05 D7 F8 44 90 1C 46 1E E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FB 6A 4F EA 4A 02 13 44 B3 F5 80 5F 00 F2 97 84 0F 32 22 F0 0F 02 02 F1 08 01 AD EB 01 0D 06 A8 81 18 89 45 00 F0 24 82 92 46 FB 62 81 46 CD F8 00 A0 02 21 78 6B 32 46 CD F8 04 80 4B 46 02 95 ?? ?? ?? ?? 22 28 40 F0 20 82 3B 6F 5A 1C 40 F0 84 82 00 2C D4 D0 4F EA 4A 0A 48 46 51 46 ?? ?? ?? ?? 00 28 00 F0 6D 82 01 24 DF E7 ?? ?2 0? 0? C7 F8 08 C0 ?? ?2 0? 0? ?? ?? ?? ?? D7 F8 08 C0 80 46 00 28 7F F4 E8 AD B8 6E D4 E4 73 7B 03 F0 0F 03 02 2B 7F F4 40 AB 01 34 20 46 ?? ?? ?? ?? 3B 6E F0 61 1E 46 DA 69 00 2A 7F F4 38 AC 20 46 FF F7 33 BB 07 F1 88 05 78 6B 07 F1 74 02 45 F8 18 3D 29 46 ?? ?? ?? ?? 3E 6F 00 2E 00 F0 8E 83 F5 68 34 68 F8 6A 3D 63 65 01 DA F8 00 30 28 44 78 65 B0 F5 80 5F 83 F0 02 03 C3 F3 40 03 3B 65 00 F2 6D 83 08 35 00 20 AD EB 05 0D 38 64 06 AD FD 63 00 2C 40 F3 5E 83 FC 6B 4F F0 00 08 C7 F8 1C B0 07 F1 60 09 D7 F8 30 B0 43 46 CF F6 FF 73 C7 F8 38 80 C7 F8 28 80 C7 F8 20 80 FB 62 7C 64 B3 68 D9 F8 00 40 13 F8 08 50 02 2D 14 BF 10 25 04 25 00 2C 62 D0 3B 6D 00 20 20 60 3E 6F 00 2B 3E D1 71 68 39 63 00 29 3A D0 BB 6B 00 2B 5D D0 B3 68 13 F8 08 E0 DA F8 04 30 BE F1 02 0F 1A D0 00 2B 32 D0 9E 45 30 D0 33 68 08 F1 01 08 AB 44 43 45 D5 DC D7 F8 1C B0 30 46 ?? ?? ?? ?? 3B 6E 9A 68 00 2A 40 F0 97 80 4F F4 81 79 00 25 7D 64 3D 63 FF F7 A6 B9 0A 2B E2 D1 DA F8 00 20 12 07 E2 D5 D9 F8 00 20 00 20 01 21 39 65 91 46 93 60 FA 6A DB F8 00 30 20 61 62 61 A3 61 E0 60 D3 E7 D9 F8 00 30 00 22 5A 60 C2 E7 D9 F8 00 30 04 F1 0C 00 59 46 2A 46 C3 F8 08 E0 ?? ?? ?? ?? 3E 6F D9 F8 00 90 B3 68 13 F8 08 30 0A 2B 0B BF 01 24 01 23 3C 62 3B 65 08 BF 3C 65 B5 E7 7B 6C C9 F8 00 30 DC 61 1C 46 20 33 7B 64 94 E7 38 6B ?? ?? ?? ?? DA F8 00 30 19 06 00 F1 01 02 3A D5 7B 6D 13 44 B3 F5 80 5F 2C D8 02 F1 0E 01 7B 65 21 F0 07 03 AD EB 03 0D 06 A8 B8 63 D9 F8 00 30 39 6B B8 6B 7B 60 ?? ?? ?? ?? 7B 68 F8 64 58 60 7F E7 D7 F8 30 90 84 46 3C 60 F8 62 02 2B 08 BF 6F F0 02 05 3F F4 43 AD B3 F1 04 0A DA F1 00 05 55 EB 0A 05 3B E5 FC 6A D7 F8 2C C0 02 34 7C 64 FF F7 F6 BB 18 46 BA 60 7B 60 ?? ?? ?? ?? BA 68 7B 68 00 28 C9 D1 10 46 BA 60 ?? ?? ?? ?? BA 68 B8 63 00 28 00 F0 EC 82 01 20 B8 62 C6 E7 7B 64 D7 F8 2C C0 FF F7 DC BB 7D 6D 00 24 7C 64 3C 63 FD 62 99 46 00 2A 7F F4 37 A9 4F F4 81 79 FF F7 09 B9 00 2B 7F F4 09 AE D7 F8 84 20 12 68 00 2A 57 D0 3C 68 00 25 CF F6 FF 75 9A 46 98 46 3D 65 7C 64 15 E0 D7 F8 84 20 D9 F8 00 10 52 F8 0A 40 88 60 20 68 3C 6D 2B 61 A8 61 6C 61 EB 60 08 F1 01 08 89 46 52 F8 28 20 4F EA 88 0A 00 2A 36 D0 D9 F8 00 50 00 2D 55 D0 2B 60 00 22 D9 F8 00 40 B8 F1 00 0F 13 D0 F9 6B 48 68 62 60 0A 28 D9 D0 D7 F8 84 10 02 20 D9 F8 00 20 51 F8 0A 10 90 60 0A 68 EA 60 D7 F8 }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "get_scope"
		size = 138
		refs = "004c .LANCHOR0"
	strings:
		$1 = { 03 88 30 B4 0A 2B 05 D0 02 2B 18 BF 0F 20 1D D0 30 BC 70 47 03 7A FF 2B 31 D0 82 68 4C F2 FF 03 48 F2 FE 01 13 40 8B 42 27 D0 3A B9 C2 68 2A B9 02 69 1A B9 42 69 B2 F1 80 7F 1E D0 4C F2 FE 00 83 42 14 BF 0E 20 05 20 30 BC 70 47 ?? ?2 0? 0? 44 68 ?? ?2 0? 0? 9B 68 59 68 1A 68 21 40 91 42 11 D0 18 69 03 F1 0C 02 D9 68 15 46 20 40 13 46 88 42 F6 D1 A8 68 30 BC 70 47 02 20 C8 E7 40 7A 00 F0 0F 00 C4 E7 1D 46 F4 E7 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "rfc3484_sort"
		size = 1180
		refs = "00c4 .LANCHOR0 01e8 __check_native 03dc .LC14 03e0 .LC13 03e4 __PRETTY_FUNCTION__.16268 03f8 __assert_fail 03fc .LC15 041c .LC19 043c .LC18 045c .LC17 047c .LC16"
	strings:
		$1 = { 00 68 2D E9 F0 4F 2C 25 09 68 8B B0 05 FB 00 F7 14 68 05 FB 01 F5 02 90 E6 19 91 46 03 91 96 F8 21 30 04 EB 05 0B 00 2B 00 F0 8E 80 9B F8 21 30 00 2B 00 F0 2C 81 E3 59 06 F1 04 0C CD F8 10 C0 0B F1 04 0C CD F8 1C C0 D3 F8 14 A0 50 46 FF F7 91 FF 63 59 06 90 58 69 FF F7 8C FF 05 90 04 98 FF F7 88 FF 80 46 07 98 FF F7 84 FF DD F8 14 C0 06 99 BC EB 00 03 18 BF 01 23 41 45 18 BF 00 23 00 2B 40 F0 04 81 DD F8 14 C0 06 99 BC EB 00 0C DC F1 00 00 50 EB 0C 00 41 45 08 BF 00 20 00 28 40 F0 EA 80 96 F8 22 30 9B F8 22 20 D8 07 00 F1 E7 80 D1 07 00 F1 EB 80 99 07 40 F1 ED 80 93 07 40 F1 E5 80 ?? ?2 0? 0? 50 46 ?? ?2 0? 0? 6F F0 00 42 D8 F8 00 A0 51 46 FD F7 A4 FE 51 46 6F F0 00 42 03 46 04 98 00 93 FD F7 9C FE 51 46 6F F0 00 42 04 90 60 59 40 69 FD F7 94 FE 51 46 6F F0 00 42 84 46 07 98 CD F8 04 C0 FD F7 8B FE 9D E8 08 10 04 99 BC EB 00 02 18 BF 01 22 8B 42 18 BF 00 22 00 2A 40 F0 B3 80 BC EB 00 0A DA F1 00 00 50 EB 0A 00 8B 42 08 BF 00 20 00 28 40 F0 9C 80 E3 59 D3 F8 14 A0 14 E0 9B F8 21 30 00 2B 40 F0 93 80 E3 59 ?? ?2 0? 0? ?? ?2 0? 0? D3 F8 14 A0 50 46 FF F7 07 FF 63 59 06 90 58 69 FF F7 02 FF 05 90 D8 F8 04 80 50 46 00 22 41 46 FD F7 52 FE 63 59 41 46 00 22 82 46 58 69 FD F7 4B FE 82 45 7D DC 71 DB 96 F8 21 30 00 2B 56 D0 D6 F8 24 80 DB F8 24 A0 D0 45 50 D0 B3 6A DB F8 28 20 B3 F1 FF 3C DC F1 00 00 08 93 50 EB 0C 00 B2 F1 FF 3C DC F1 00 01 09 92 51 EB 0C 01 51 EA 00 0C 3A D0 00 28 74 D1 4F F0 FF 38 00 29 6D D1 4F F0 FF 3A 40 46 08 A9 52 46 09 AB ?? ?? ?? ?? D9 F8 04 00 00 28 40 F3 CD 80 DD F8 20 C0 00 22 D9 F8 00 30 DD F8 24 90 61 46 A4 46 4C 46 A9 46 25 46 0C 46 05 E0 8A 45 47 D0 01 32 2C 33 82 42 0B D0 59 6A 41 45 F6 D1 99 6A B1 F1 FF 3F 02 D0 A1 42 40 F0 D5 80 9C 62 EF E7 23 46 2A 46 64 46 4D 46 9C 46 91 46 63 46 4A 46 5B BB B2 B9 DD F8 14 C0 06 99 8C 45 1C DC 10 DB 96 F8 21 30 A3 B1 E2 59 61 59 53 68 48 68 83 42 0E D1 02 2B 2B D0 0A 2B 6B D0 00 23 1A 46 93 42 06 DD 01 20 0B B0 BD E8 F0 8F D0 07 F9 D5 18 E7 02 9A 03 9B 9A 42 F4 D2 4F F0 FF 30 0B B0 BD E8 F0 8F 92 07 7F F5 13 AF EB E7 00 2A D2 D1 F3 E7 99 6A B1 F1 FF 3F 02 D0 A9 42 40 F0 A4 80 9D 62 AE E7 00 23 09 93 90 E7 00 23 08 93 89 E7 B3 88 02 2B 40 F0 D8 80 BB F8 04 30 02 2B 40 F0 C3 80 52 69 4F F0 FF 34 B0 68 96 F8 23 30 52 68 00 BA C3 F1 20 03 12 BA 04 FA 03 F3 50 40 03 40 18 BF 00 22 09 D1 1A 46 4F F0 00 43 03 E0 01 32 5B 08 20 2A 01 D0 03 42 F9 D0 49 69 4F F0 FF 34 DB F8 08 00 9B F8 23 30 49 68 00 BA C3 F1 20 03 09 BA 04 FA 03 F3 48 40 03 40 2D D1 4F F0 00 41 03 E0 01 33 49 08 20 2B 9A D0 01 42 F9 D0 9A 42 96 DD A2 E7 B3 88 0A 2B 76 D1 BB F8 04 30 0A 2B 62 D1 04 36 00 23 55 69 0B F1 04 07 4C 69 B4 46 19 46 04 96 E8 18 0C EB 03 02 80 68 92 68 90 42 12 D1 E6 18 FA 18 B6 68 92 68 96 42 0B D1 01 31 04 33 04 29 EE D1 71 E7 00 23 D8 E7 DD F8 20 C0 DD F8 24 90 53 E7 02 46 50 40 4F F0 00 43 00 22 00 BA 03 E0 01 32 5B 08 20 2A 01 D0 03 42 F9 D0 88 1C 00 23 4F F0 00 41 0B EB 80 05 54 F8 20 00 6C 68 60 40 00 BA 04 E0 01 33 49 08 20 2B 3F F4 4F AF 01 42 F8 D0 B2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 CD 62 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 D3 62 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 E2 62 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 0F 72 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 F1 62 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 DE 62 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "freeaddrinfo"
		size = 30
		refs = "000e free"
	strings:
		$1 = { 38 B5 04 46 08 B9 09 E0 2C 46 E5 69 A0 69 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 00 2D F5 D1 38 BD }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "getaddrinfo"
		size = 1824
		refs = "00c2 .LANCHOR0 00c6 __pthread_once 00de gaiconf_init 0122 in6aicmp 012e qsort 0190 __connect 0228 __socket 024c __libc_do_syscall 0256 memcmp 0268 memcpy 029c __getsockname 02f4 __libc_errno 03d4 __check_pf 0432 rfc3484_sort 0446 qsort_r 0494 __free_in6ai 04dc strtoul 054c .LC21 0550 .LC13 0554 __PRETTY_FUNCTION__.16538 0568 __assert_fail 0572 freeaddrinfo 0590 free 05f8 .LC20 0638 __lll_lock_wait_private 06aa .LC0 06b8 __xstat64 06f4 __libc_alloca_cutoff 0700 malloc"
	strings:
		$1 = { 2D E9 F0 4F C3 B0 02 AF 15 46 80 46 7B 61 0E 46 00 23 01 22 BB 65 20 B1 03 78 2A 2B 00 F0 52 82 00 22 00 2E 00 F0 46 82 33 78 2A 2B 00 F0 3E 82 AF 4B 00 2D 08 BF 1D 46 2C 68 24 F4 FF 63 33 F0 07 03 BB 62 40 F0 C9 82 A1 07 02 D5 00 2A 40 F0 B9 82 14 F0 20 04 4F F0 00 03 FB 65 3B 66 87 F8 56 30 87 F8 57 30 40 F0 AD 81 00 2E 00 F0 6C 82 31 78 00 29 40 F0 2D 82 6B 68 00 22 7A 66 33 F0 02 00 02 D0 0A 2B 40 F0 AE 82 2A 46 40 46 07 F1 64 05 07 F1 58 03 00 95 FE F7 2E F9 05 46 00 28 40 F0 64 82 BB 6D 00 2B 00 F0 8A 82 02 46 78 63 DB 69 01 32 00 2B FB D1 7A 63 7B 6E 01 2B 40 F2 E8 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? FA 62 D0 6A 78 60 00 2B 00 F0 FE 82 ?? ?2 0? 0? 02 F1 2C 00 ?? ?2 0? 0? ?? ?? ?? ?? 7B 6B 03 EB 43 05 2D 01 B5 F5 80 5F 00 F2 FA 82 08 35 00 20 AD EB 05 0D B8 60 02 A9 39 63 7A 6B 2C 23 38 6B 03 FB 02 03 7B 62 00 2C 00 F0 F0 81 F8 6D 38 B1 ?? ?2 0? 0? 39 6E ?? ?2 0? 0? 18 22 ?? ?? ?? ?? BD 6D 00 2D 00 F0 5D 82 3A 6B 00 23 39 6B 18 46 0C 32 FA 60 FA 63 04 31 7A 6A CF F6 FF 70 B9 64 4F F0 FF 39 04 31 04 3A BB 63 9A 46 39 64 1E 46 FB 64 38 61 7A 64 3C 6B 41 E0 BB 6B 02 2B 02 D1 6B 68 0A 2B 66 D0 48 46 07 F1 98 01 10 22 C7 F8 98 60 C7 F8 9C 60 C7 F8 A0 60 C7 F8 A4 60 ?? ?? ?? ?? 1C 23 3B 67 48 46 69 69 2A 69 ?? ?? ?? ?? 00 28 76 D0 53 4B 1D EE 70 2F 7B 44 1B 68 D3 58 61 2B 41 D0 84 F8 20 60 AB 69 33 B1 FA 6C 00 2A 40 F0 19 82 F8 6C FB 64 A8 61 B9 6C 0A F1 01 0A FB 6B 2C 34 38 6C 2C 31 EA 69 2C 33 2C 30 B9 64 FB 63 38 64 00 2A 00 F0 12 81 2B 46 15 46 79 6C 4F F0 FF 30 25 60 A0 62 41 F8 04 AF 79 64 1B B1 1A 69 29 69 8A 42 23 D0 4F F0 FF 32 84 F8 21 60 91 45 84 F8 22 60 84 F8 23 60 62 62 A5 D1 68 68 02 21 00 22 B8 63 ?? ?? ?? ?? 1C 23 3B 67 B0 F1 FF 3F 81 46 B6 D0 AE E7 B9 6B 0A 29 BA D1 6B 68 02 2B B7 D1 48 46 4F F0 06 0C ?? ?? ?? ?? E6 E7 58 69 69 69 ?? ?? ?? ?? 00 28 D5 D1 A4 F1 28 01 14 F8 0C 2C 20 1D ?? ?? ?? ?? 14 F8 0C EC 14 F8 0B 0C 14 F8 0A 1C 14 F8 09 2C 54 F8 08 3C 84 F8 20 E0 84 F8 21 00 84 F8 22 10 84 F8 23 20 63 62 92 E7 48 46 21 1D 07 F1 70 02 ?? ?? ?? ?? 00 28 80 D1 3B 6F 4F F0 01 01 D7 F8 5C B0 84 F8 21 10 84 F8 20 30 BB F1 00 0F 46 D0 6B 68 02 2B 71 D0 23 46 07 F1 A0 0E 53 F8 0C 0F 59 68 9A 68 DB 68 AE E8 0F 00 D7 F8 60 C0 00 23 FD 61 BC 61 65 46 1C 46 C7 F8 20 90 AC 42 08 D3 52 E0 00 BF ?? ?? ?? ?? ?? ?? ?? ?? A0 45 4B D9 45 46 05 EB 04 08 07 F1 98 00 4F EA 58 08 08 EB 48 09 0B EB C9 09 49 46 FD F7 22 FB 00 28 ED DB 02 D0 08 F1 01 04 E1 E7 CB 46 FD 69 BC 69 D7 F8 20 90 BB F1 00 0F 0A D0 9B F8 00 30 84 F8 22 30 9B F8 01 30 84 F8 23 30 DB F8 04 30 63 62 6B 68 02 2B 7F F4 34 AF B9 6B 0A 29 7F F4 30 AF F9 6B 38 6B 0A 1A F8 68 02 44 52 F8 0C 1C 00 29 40 F0 EF 80 52 F8 08 1C 00 29 40 F0 EA 80 52 F8 04 2C 12 F5 80 3F 40 F0 E4 80 BA 6C 13 80 10 22 A3 69 84 F8 20 20 A3 60 12 E7 07 F1 18 04 94 E8 30 02 6B 68 02 2B 7F F4 0B AF D5 E7 BA 6B 02 2A 8A D1 C7 F8 A0 00 C7 F8 A4 00 3B 69 38 6C C7 F8 A8 30 03 68 C7 F8 AC 30 88 E7 07 F1 60 03 07 F1 56 00 07 F1 57 01 07 F1 5C 02 ?? ?? ?? ?? 6B 68 00 2B 40 F0 9E 80 97 F8 56 30 00 2B 00 F0 D6 80 97 F8 57 30 00 2B 40 F0 A6 80 AE 46 07 F1 78 05 2C 46 4F F0 02 0C BE E8 0F 00 0F C4 9E E8 0F 00 84 E8 0F 00 D3 E0 B9 F1 FF 3F 04 D0 48 46 4F F0 06 0C ?? ?? ?? ?? F9 6A 3A 6B 78 6B 0B 69 3A 67 78 67 00 2B 40 F0 F3 80 ?? ?2 0? 0? 07 F1 70 02 ?? ?2 0? 0? 00 92 78 6A 04 22 79 6B ?? ?? ?? ?? 79 6A 2C 24 3A 6B 0B 68 04 FB 03 F3 D0 58 7B 6B 01 2B B8 65 40 F3 C0 80 0B 46 79 6B 16 46 03 EB 81 05 01 46 04 3D 00 E0 11 46 53 F8 04 2F AB 42 04 FB 02 F2 B2 58 CA 61 F6 D1 00 23 D3 61 FA 6C BB 68 82 61 00 2B 7D D1 F8 6D ?? ?? ?? ?? BB 6D 7B B1 78 69 03 60 B8 6A 07 F5 82 77 BD 46 BD E8 F0 8F 73 78 00 2B 7F F4 BE AD 16 46 00 2A 3F F4 BA AD 6F F0 01 00 B8 62 ED E7 43 78 00 2B 7F F4 AA AD 98 46 01 22 A7 E5 30 46 07 F1 98 01 0A 22 BE 66 ?? ?? ?? ?? D7 F8 98 30 F8 66 1B 78 33 B1 2B 68 5B 05 5C BF 4F F0 FF 33 FB 66 69 D4 07 F1 68 01 BC E5 07 F1 56 00 07 F1 57 01 07 F1 5C 02 07 F1 60 03 ?? ?? ?? ?? F8 6D 00 28 7F F4 04 AE 0A E6 02 2B 0B D0 0A 2B 0D D1 97 F8 57 30 53 B9 F8 6D 6F F0 01 01 B9 62 ?? ?? ?? ?? B3 E7 97 F8 56 30 00 2B F4 D0 01 24 00 2E 7F F4 94 AD 31 46 95 E5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F6 48 22 ?? ?? ?? ?? B8 6D 25 F4 80 75 ?? ?? ?? ?? F8 6D ?? ?? ?? ?? 6D 42 BD 62 07 F5 82 77 57 F8 DC 0C BD 46 BD E8 F0 8F 38 6B ?? ?? ?? ?? 7D E7 97 F8 57 30 00 2B D0 D0 AE 46 07 F1 78 05 2C 46 4F F0 0A 0C BE E8 0F 00 0F C4 9E E8 0F 00 84 E8 0F 00 C7 F8 7C C0 01 24 54 E5 7B 63 7A E5 4F F0 FF 32 BA 62 69 E7 F8 6D 6F F0 01 02 BA 62 ?? ?? ?? ?? 62 E7 4F F0 FF 31 B9 62 5E E7 02 46 4E E7 F8 6D 6F F0 05 01 B9 62 ?? ?? ?? ?? 55 E7 FD 64 13 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F6 63 22 ?? ?? ?? ?? 40 4C 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 13 B1 20 46 ?? ?? ?? ?? 7A 68 32 B1 F8 6A ?? ?2 0? 0? ?? ?2 0? 0? C3 68 6B BB ?? ?2 0? 0? 07 F1 70 02 ?? ?2 0? 0? 00 92 78 6A 04 22 79 6B ?? ?? ?? ?? 00 22 F9 6A 0B 6B BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 7F F7 DE AE 1D EE 70 1F 01 22 A1 F5 98 61 20 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? CF E6 ?? ?2 0? 0? 03 20 ?? ?2 0? 0? 07 F1 98 02 ?? ?? ?? ?? 20 B9 D7 F8 E8 20 6B 69 9A 42 02 D0 FD F7 A4 F9 BF E7 AA 69 D7 F8 EC 30 93 42 F7 D1 B9 E7 79 68 00 29 7F F4 06 AD FD F7 97 F9 FA 6A D3 6A 43 F0 02 03 D3 62 FD E4 28 46 ?? ?? ?? ?? 00 28 7F F4 00 AD 28 46 ?? ?? ?? ?? 38 63 10 B1 01 23 BB 60 FE E4 F8 6D 6F F0 09 01 B9 62 ?? ?? ?? ?? C1 E6 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_11_0 {
	meta:
		name = "fini"
		size = 88
		refs = "0002 .LANCHOR0 000a .LANCHOR1 001a free"
	strings:
		$1 = { 10 B5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 20 68 98 42 02 D0 23 60 ?? ?? ?? ?? 60 68 ?? ?2 0? 0? 0A 4A ?? ?2 0? 0? 90 42 02 D0 5A 60 ?? ?? ?? ?? A0 68 ?? ?2 0? 0? 06 4A ?? ?2 0? 0? 90 42 04 D0 BD E8 10 40 9A 60 ?? ?? ?? ?? 10 BD ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "bcopy"
		size = 214
		refs = "003c _wordcopy_fwd_dest_aligned 0096 _wordcopy_bwd_dest_aligned 00c2 _wordcopy_fwd_aligned 00c8 _wordcopy_bwd_aligned"
	strings:
		$1 = { 0B 1A 93 42 2D E9 F0 41 0C 46 05 46 29 D3 0F 2A 1C D9 4B 42 03 F0 03 03 C3 EB 02 08 00 2B 58 D0 CF 18 15 F8 01 6B 04 F8 01 6B BC 42 F9 D1 C5 18 AC 07 38 46 29 46 4F EA 98 02 42 D0 ?? ?? ?? ?? 28 F0 03 04 08 F0 03 02 25 44 3C 44 6A B3 23 46 14 44 E8 1A C1 5C 03 F8 01 1B A3 42 FA D1 BD E8 F0 81 0F 2A 00 EB 02 03 01 EB 02 08 1F D9 08 F0 03 01 54 1A 59 B3 5F 1A 45 46 13 F8 01 6D BB 42 05 F8 01 6D F9 D1 C1 EB 08 08 BB 07 40 46 39 46 4F EA 94 02 18 D0 ?? ?? ?? ?? 24 F0 03 02 BB 1A C2 EB 08 08 14 F0 03 02 01 D1 BD E8 F0 81 9A 1A 41 46 13 F8 01 0D 93 42 01 F8 01 0D F9 D1 BD E8 F0 81 ?? ?? ?? ?? BB E7 ?? ?? ?? ?? E5 E7 1F 46 DB E7 0F 46 AC E7 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__atomic_pwritev64_replacement"
		size = 232
		refs = "007a mempcpy 0090 __pwrite64 0098 free 00c8 __libc_alloca_cutoff 00d2 malloc 00e4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F B2 F1 00 09 85 B0 80 46 8A 46 02 AF 57 DD 4E 68 B6 F1 00 4F 3E BF 00 25 8C 46 2C 46 04 D3 40 E0 DC F8 04 60 B3 42 3C D3 01 35 4F F6 FF 73 4D 45 C7 F6 FF 73 34 44 0C F1 08 0C C4 EB 03 03 EF D1 B4 F5 80 5F 3D D8 04 F1 0E 03 B9 F1 00 0F 23 F0 07 03 AD EB 03 0D 4F F0 00 03 02 AE 7B 60 0E DD 00 25 30 46 AB 46 0A EB 05 02 5A F8 05 10 0B F1 01 0B 08 35 52 68 ?? ?? ?? ?? CB 45 F3 D1 D7 E9 0C 01 22 46 CD E9 00 01 40 46 31 46 ?? ?? ?? ?? 04 46 78 68 ?? ?? ?? ?? 20 46 0C 37 BD 46 BD E8 F0 8F 0F 4B 1D EE 70 2F 4F F0 FF 34 16 21 7B 44 1B 68 20 46 0C 37 D1 50 BD 46 BD E8 F0 8F 00 24 C1 E7 20 46 ?? ?? ?? ?? 00 28 BC D1 20 46 ?? ?? ?? ?? 06 46 78 60 00 28 C2 D1 4F F0 FF 34 D8 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_1_0 {
	meta:
		name = "pwritev64"
		size = 184
		refs = "0004 __libc_multiple_threads 0024 __libc_do_syscall 005c __libc_enable_asynccancel 007e __libc_disable_asynccancel 00ac __libc_errno"
	strings:
		$1 = { 2D E9 F8 4F ?? ?2 0? 0? ?? ?2 0? 0? 81 46 88 46 17 46 23 68 0A 9E DD F8 2C A0 FB B9 33 46 54 46 4F F4 B5 7C ?? ?? ?? ?? 10 F5 80 5F 2A D8 05 46 00 2D 02 DB 28 46 BD E8 F8 8F 1C 4B 1D EE 70 2F 7B 44 1B 68 D3 58 26 2B F4 D1 0A 96 48 46 CD F8 2C A0 41 46 3A 46 BD E8 F8 4F 5D E7 ?? ?? ?? ?? 54 46 41 46 3A 46 33 46 4F F4 B5 7C 83 46 48 46 ?? ?? ?? ?? 10 F5 80 5F 05 46 0D D8 58 46 ?? ?? ?? ?? D5 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 CA E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 35 7B 44 1B 68 D1 50 E7 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "decode_name"
		size = 134
	strings:
		$1 = { F0 B4 42 1C 0A 27 03 46 09 26 20 25 05 E0 02 F8 01 1C 19 78 01 32 01 33 A1 B1 19 78 5C 29 F6 D1 5C 78 30 2C 10 D0 5C 2C 21 D0 31 2C EF D1 9C 78 33 2C EC D1 DC 78 34 2C 04 BF 02 F8 01 1C 03 33 E5 D1 E6 E7 F0 BC 70 47 9C 78 34 2C 13 D0 31 2C DD D1 DC 78 31 2C 04 BF 02 F8 01 6C 03 33 D8 D0 32 2C 04 BF 02 F8 01 7C 03 33 D0 D1 D1 E7 02 F8 01 4C 01 33 CD E7 DC 78 30 2C 04 BF 02 F8 01 5C 03 33 C4 D1 C5 E7 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__setmntent"
		size = 76
		refs = "000a strlen 0020 mempcpy 0024 .LC0 003a _IO_new_fopen"
	strings:
		$1 = { B0 B5 05 46 00 AF 08 46 0C 46 ?? ?? ?? ?? 21 46 00 F1 0A 03 02 46 23 F0 07 03 AD EB 03 0D 68 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 69 46 1C 88 9B 78 02 46 28 46 14 80 93 70 ?? ?? ?? ?? 18 B1 03 68 43 F4 00 43 03 60 BD 46 B0 BD }
	condition:
		$1
}

rule file_6_3_0 {
	meta:
		name = "__getmntent_r"
		size = 526
		refs = "001a fgets_unlocked 0026 strchr 0072 .LC2 01e2 .LC1 01f4 sscanf"
	strings:
		$1 = { 2D E9 F0 4F 80 46 AD F2 04 4D 8B 46 17 46 99 46 4F F0 00 0A 38 46 49 46 42 46 ?? ?? ?? ?? 00 28 70 D0 38 46 0A 21 ?? ?? ?? ?? 70 B3 80 F8 00 A0 3C 46 26 46 14 F8 01 5B 20 2D FA D0 09 2D F8 D0 00 2D 18 BF 23 2D E5 D0 20 2D 30 46 5E D0 09 2D 18 BF 72 1C 04 D1 59 E0 20 2B 57 D0 09 2B 55 D0 16 46 12 F8 01 3B 00 2B F6 D1 FF F7 59 FF CB F8 00 00 ?? ?2 0? 0? ?? ?2 0? 0? CB F8 04 30 70 E0 68 46 ?? ?? ?? ?? 00 28 D2 D1 4F F4 80 61 68 46 42 46 ?? ?? ?? ?? 0A 21 00 28 F1 D1 C8 E7 00 23 0B 70 4C 1C FF F7 3C FF ?? ?2 0? 0? ?? ?2 0? 0? CB F8 08 00 00 2C 00 F0 88 80 23 46 19 46 13 F8 01 2B 20 2A FA D0 09 2A F8 D0 08 46 7A B1 20 2A 7E D0 09 2A 18 BF 4A 1C 04 D1 79 E0 20 2B 77 D0 09 2B 75 D0 11 46 12 F8 01 3B 00 2B F6 D1 FF F7 17 FF CB F8 0C 00 00 23 CB F8 10 30 58 46 00 23 CB F8 14 30 0D F2 04 4D BD E8 F0 8F 00 23 33 70 FF F7 06 FF 01 36 CB F8 00 00 00 2E A9 D0 33 46 19 46 13 F8 01 2B 20 2A FA D0 09 2A F8 D0 08 46 7A B1 20 2A 18 D0 09 2A 18 BF 4A 1C 04 D1 13 E0 20 2B 11 D0 09 2B 0F D0 11 46 12 F8 01 3B 00 2B F6 D1 FF F7 E5 FE ?? ?2 0? 0? ?? ?2 0? 0? CB F8 04 00 CB F8 08 30 30 E0 00 23 0B 70 4C 1C FF F7 D7 FE ?? ?2 0? 0? ?? ?2 0? 0? CB F8 04 00 00 2C EF D0 23 46 19 46 13 F8 01 2B 20 2A FA D0 09 2A F8 D0 08 46 8A B1 20 2A 81 D0 09 2A 18 BF 4A 1C 06 D1 7C E7 20 2B 3F F4 7A AF 09 2B 3F F4 77 AF 11 46 12 F8 01 3B 00 2B F4 D1 FF F7 B1 FE ?? ?2 0? 0? ?? ?2 0? 0? CB F8 08 00 CB F8 0C 30 92 E7 00 23 0B 70 4C 1C FF F7 A3 FE CB F8 0C 00 00 2C 89 D0 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 0B F1 10 02 0B F1 14 03 ?? ?? ?? ?? 00 28 3F F4 7C AF 01 28 3F F4 7C AF 58 46 0D F2 04 4D BD E8 F0 8F }
	condition:
		$1
}

rule file_6_4_0 {
	meta:
		name = "__addmntent"
		size = 1046
		refs = "0026 fseek 0150 .LC3 0166 fprintf 0170 fflush 0194 strlen"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 0B 46 04 AF 02 22 5D 68 00 21 1E 69 04 46 D3 F8 00 90 3D 60 D3 F8 08 80 DD 68 5B 69 7E 60 BB 60 ?? ?? ?? ?? 00 28 40 F0 A9 80 99 F8 00 A0 BA F1 00 0F 00 F0 EA 81 AA F1 09 03 BA F1 20 0F 18 BF 01 2B 40 F2 A1 80 BA F1 5C 0F 00 F0 9D 80 49 46 3E 68 07 E0 20 2B 18 BF 01 2A 40 F2 94 80 5C 2B 00 F0 91 80 11 F8 01 3F A3 F1 09 02 00 2B F1 D1 3E 60 C7 F8 0C 90 3B 68 93 F8 00 90 B9 F1 00 0F 00 F0 C1 81 A9 F1 09 03 B9 F1 20 0F 18 BF 01 2B 40 F2 43 81 B9 F1 5C 0F 00 F0 3F 81 39 68 0E 46 07 E0 20 2B 18 BF 01 2A 40 F2 36 81 5C 2B 00 F0 33 81 11 F8 01 3F A3 F1 09 02 00 2B F1 D1 3E 60 98 F8 00 90 B9 F1 00 0F 1B D0 A9 F1 09 03 B9 F1 20 0F 18 BF 01 2B 40 F2 A9 80 B9 F1 5C 0F 00 F0 A5 80 42 46 07 E0 20 2B 18 BF 01 29 40 F2 9E 80 5C 2B 00 F0 9B 80 12 F8 01 3F A3 F1 09 01 00 2B F1 D1 95 F8 00 90 B9 F1 00 0F 1B D0 A9 F1 09 03 B9 F1 20 0F 18 BF 01 2B 40 F2 C5 80 B9 F1 5C 0F 00 F0 C1 80 2A 46 07 E0 20 2B 18 BF 01 29 40 F2 BA 80 5C 2B 00 F0 B7 80 12 F8 01 3F A3 F1 09 01 00 2B F1 D1 01 95 33 46 7D 68 ?? ?2 0? 0? BE 68 ?? ?2 0? 0? CD F8 00 80 20 46 FA 68 02 95 03 96 ?? ?? ?? ?? 00 28 09 DB 20 46 ?? ?? ?? ?? 14 37 00 30 18 BF 01 20 BD 46 BD E8 F0 8F 01 20 14 37 BD 46 BD E8 F0 8F 3E 60 48 46 4F F0 32 0B ?? ?? ?? ?? 09 F1 FF 3E 53 46 4F F0 5C 0C 30 21 4F F0 31 09 4F F0 34 0A 3E 68 80 00 00 F1 0F 02 22 F0 07 02 AD EB 02 0D 04 AA FA 60 12 E0 09 2B 21 D0 0A 2B 29 D0 5C 2B 15 BF 13 70 10 46 01 32 00 F8 02 3B 04 BF 53 70 02 46 1E F8 01 3F 83 B1 9E F8 01 30 20 2B EA D1 82 F8 00 C0 04 32 02 F8 03 1C 02 F8 02 AC 02 F8 01 1C 1E F8 01 3F 00 2B EE D1 3E 60 38 E7 82 F8 00 C0 04 32 02 F8 03 1C 02 F8 02 9C 02 F8 01 9C DF E7 82 F8 00 C0 04 32 02 F8 03 1C 02 F8 02 9C 02 F8 01 BC D5 E7 40 46 4F F0 32 0B ?? ?? ?? ?? 08 F1 FF 33 49 46 4F F0 5C 0C 4F F0 30 0E 4F F0 31 09 4F F0 34 0A 80 00 00 F1 0F 02 22 F0 07 02 AD EB 02 0D 0D F1 10 08 42 46 15 E0 09 29 00 F0 93 80 0A 29 00 F0 AE 80 5C 29 15 BF 11 70 10 46 01 32 00 F8 02 1B 04 BF 51 70 02 46 13 F8 01 1F 00 29 3F F4 3B AF 59 78 20 29 E7 D1 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 AC 02 F8 01 EC ED E7 28 46 4F F0 32 0B ?? ?? ?? ?? 6B 1E 49 46 4F F0 5C 0C 4F F0 30 0E 4F F0 31 09 4F F0 34 0A 80 00 00 F1 0F 02 22 F0 07 02 AD EB 02 0D 04 AD 2A 46 13 E0 09 29 62 D0 0A 29 7E D0 5C 29 15 BF 11 70 10 46 01 32 00 F8 02 1B 04 BF 51 70 02 46 13 F8 01 1F 00 29 3F F4 23 AF 59 78 20 29 E9 D1 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 AC 02 F8 01 EC ED E7 3E 60 38 68 4F F0 32 0B ?? ?? ?? ?? 3B 68 4F F0 5C 0C 4F F0 30 0E 59 1E 4F F0 34 0A 4B 46 4F F0 31 09 80 00 00 F1 0F 02 22 F0 07 02 AD EB 02 0D 04 AE 32 46 13 E0 09 2B 31 D0 0A 2B 4D D0 5C 2B 15 BF 13 70 10 46 01 32 00 F8 02 3B 04 BF 53 70 02 46 11 F8 01 3F 00 2B 3F F4 A6 AE 4B 78 20 2B E9 D1 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 AC 02 F8 01 EC ED E7 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 9C 02 F8 01 9C 6F E7 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 9C 02 F8 01 9C 9E E7 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 9C 02 F8 01 9C CF E7 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 9C 02 F8 01 BC 51 E7 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 9C 02 F8 01 BC 80 E7 82 F8 00 C0 04 32 02 F8 03 EC 02 F8 02 9C 02 F8 01 BC B1 E7 3E 68 5A E6 C7 F8 0C 90 32 E6 }
	condition:
		$1
}

rule file_6_5_0 {
	meta:
		name = "__hasmntopt"
		size = 72
		refs = "0008 strlen 0012 strchr 001e strstr"
	strings:
		$1 = { 70 B5 04 46 08 46 0D 46 ?? ?? ?? ?? E4 68 06 46 03 E0 ?? ?? ?? ?? A8 B1 44 1C 29 46 20 46 ?? ?? ?? ?? 2C 21 03 46 73 B1 A3 42 03 D0 13 F8 01 2C 2C 2A EE D1 9A 5D 00 2A 18 BF 3D 2A 01 D0 2C 2A E7 D1 18 46 70 BD 70 BD }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__setitimer"
		size = 20
		refs = "0010 __syscall_error"
		altNames = "__access __adjtimex __bind __chdir __chmod __chown __dup __dup2 __dup3 __fchdir __fchmod __flock __fstatfs __ftruncate __getitimer __getpeername __getpgid __getrusage __getsockname __gettimeofday __ioctl __kill __libc_lseek __link __listen __madvise __mkdir __mprotect __msgget __munmap __new_getrlimit __personality __pipe __pipe2 __readlink __rmdir __sched_get_priority_max __sched_get_priority_min __sched_getparam __sched_getscheduler __sched_rr_get_interval __sched_setparam __sched_setscheduler __sched_yield __semget __semop __setpgid __setsid __settimeofday __shmat __shmdt __shmget __shutdown __sigaltstack __socket __socketpair __statfs __swapoff __swapon __symlink __truncate __umount2 __uname __unlink __wait4 acct bdflush capget capset chroot clock_adjtime delete_module epoll_create epoll_create1 epoll_ctl fanotify_init fgetxattr flistxattr fremovexattr getsid getxattr inotify_add_watch inotify_init inotify_init1 inotify_rm_watch klogctl lgetxattr listxattr llistxattr lremovexattr mincore mlock mlockall munlock munlockall nfsservctl pivot_root prlimit64 quotactl removexattr rename semtimedop sendfile sendfile64 setdomainname sethostname setns setpriority sync syncfs sysinfo timerfd_create timerfd_gettime timerfd_settime unshare uselib vhangup"
	strings:
		$1 = { 80 B4 04 4F 00 DF 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__isoc99_vwscanf"
		size = 312
		refs = "0004 stdin 0066 _IO_vfwscanf 00b8 __lll_lock_wait_private 00d2 __libc_do_syscall 0134 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? ?? ?2 0? 0? 0E 46 07 46 2C 68 23 68 19 04 4D D4 A0 6C 1D EE 70 8F A8 F5 98 68 82 68 42 45 43 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 00 2A 38 D1 A2 6C 2D 68 10 46 C2 F8 08 80 42 68 01 32 42 60 EB 6B 32 46 39 46 28 46 43 F0 10 06 00 23 EE 63 ?? ?? ?? ?? E2 6B 05 46 23 68 22 F0 14 02 E2 63 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 09 DC 28 46 BD E8 F0 81 25 46 CD E7 25 46 CE E7 ?? ?? ?? ?? C3 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E8 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1169_0_0 {
	meta:
		name = "__isoc99_vscanf"
		size = 312
		refs = "0004 stdin 0066 _IO_vfscanf 00b8 __lll_lock_wait_private 00d2 __libc_do_syscall 0134 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? ?? ?2 0? 0? 0E 46 07 46 2C 68 23 68 19 04 4D D4 A0 6C 1D EE 70 8F A8 F5 98 68 82 68 42 45 43 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 00 2A 38 D1 A2 6C 2D 68 10 46 C2 F8 08 80 42 68 01 32 42 60 EB 6B 32 46 39 46 28 46 43 F0 10 06 00 23 EE 63 ?? ?? ?? ?? E2 6B 05 46 23 68 22 F0 14 02 E2 63 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 09 DC 28 46 BD E8 F0 81 25 46 CD E7 25 46 CE E7 ?? ?? ?? ?? C3 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E8 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "allocate"
		size = 22
		refs = "0006 malloc 000a .LANCHOR0"
	strings:
		$1 = { 08 B5 4F F4 80 60 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 18 60 08 BD }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "getnetgrent"
		size = 144
		refs = "0000 __pthread_once 0014 .LANCHOR1 0018 allocate 0028 .LANCHOR0 0040 __getnetgrent_r 0076 malloc 008c __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? F0 B5 05 46 83 B0 0C 46 16 46 1B B3 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 4B B1 21 46 28 46 4F F4 80 64 32 46 00 94 ?? ?? ?? ?? 03 B0 F0 BD 10 4B 1D EE 70 2F 0C 21 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 ?? ?2 0? 0? ?? ?2 0? 0? 3B 68 23 B1 ?? ?2 0? 0? ?? ?2 0? 0? DE E7 4F F4 80 60 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 22 3A 60 18 60 D2 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "putwc"
		size = 282
		refs = "00aa __libc_do_syscall 00b4 __woverflow 00bc __lll_lock_wait_private 0116 _Unwind_Resume"
	strings:
		$1 = { 0B 68 70 B5 0C 46 19 04 05 46 1C D4 A0 6C 1D EE 70 6F A6 F5 98 66 83 68 B3 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 D1 A3 6C 18 46 9E 60 43 68 01 33 43 60 E3 6D 00 2B 31 D0 1A 69 59 69 8A 42 3E BF 11 1D 19 61 15 60 29 D2 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 01 DC 28 46 70 BD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? F0 E7 29 46 20 46 ?? ?? ?? ?? 05 46 CF E7 ?? ?? ?? ?? BB E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "parse_printf_format"
		size = 158
		refs = "0010 __strchrnul 001a __printf_arginfo_table 0038 __parse_one_specmb"
	strings:
		$1 = { 2D E9 F0 46 8F B0 8A 46 25 21 15 46 00 24 00 94 ?? ?? ?? ?? 03 78 00 2B 3F D0 ?? ?2 0? 0? 27 46 ?? ?2 0? 0? 05 E0 0B 9B 45 F8 22 30 07 98 03 78 63 B3 21 46 6B 46 01 AA ?? ?? ?? ?? 09 9B 59 1C 04 44 03 D0 53 45 38 BF 45 F8 23 70 08 9B 5A 1C 03 D0 9A 45 88 BF 45 F8 23 70 0A 9A 92 45 E5 D9 0C 9B 00 2B E2 D0 01 2B DD D0 D9 F8 00 60 C2 EB 0A 01 DD F8 0C E0 0D AB 01 A8 05 EB 82 02 56 F8 2E 60 B0 47 07 98 03 78 00 2B D2 D1 00 98 84 42 28 BF 20 46 0F B0 BD E8 F0 86 18 46 FA E7 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "getwchar_unlocked"
		size = 34
		refs = "0000 _IO_stdin 001e __wuflow"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 18 68 C3 6D 3B B1 1A 68 59 68 8A 42 03 D2 11 1D 10 68 19 60 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__mmap"
		size = 48
		refs = "0026 __syscall_error"
	strings:
		$1 = { 20 B4 02 9D 10 B4 02 9C 5F EA 05 5C 0D D1 4F EA 15 35 80 B4 06 4F 00 DF 80 BC 10 BC 20 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? 6F F0 15 00 F4 E7 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__nl_langinfo_l"
		size = 56
		refs = "0026 .LC0"
	strings:
		$1 = { 03 14 06 2B 0F D0 0C 2B 0D D8 80 B2 4F F6 FF 72 90 42 0D D0 51 F8 23 30 1A 6A 90 42 03 D2 03 EB 80 00 40 6A 70 47 ?? ?2 0? 0? ?? ?2 0? 0? 70 47 10 33 51 F8 23 00 70 47 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "strerror_l"
		size = 168
		refs = "000a _sys_nerr_internal 0018 _sys_errlist_internal 0028 __uselocale 0032 _libc_intl_domainname 003a __dcgettext 0058 free 0062 .LC0 0082 .LC1 0090 __asprintf 00a4 .LANCHOR0"
	strings:
		$1 = { 2D E9 F8 43 04 1E 0E 46 20 DB ?? ?2 0? 0? ?? ?2 0? 0? 13 68 9C 42 19 DA ?? ?2 0? 0? ?? ?2 0? 0? 52 F8 24 50 95 B1 30 46 ?? ?? ?? ?? 29 46 05 22 04 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 05 46 20 46 ?? ?? ?? ?? 28 46 BD E8 F8 83 15 4D 1D EE 70 7F 07 EB 05 08 E8 59 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 06 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 81 46 30 46 ?? ?? ?? ?? ?? ?2 0? 0? 40 46 4A 46 23 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 30 12 BF 78 59 00 20 78 51 BD E8 F8 83 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "strerror_thread_freeres"
		size = 16
		refs = "000c .LANCHOR0 0008 free"
	strings:
		$1 = { 02 4A 1D EE 70 3F D0 58 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__scanf"
		size = 42
		refs = "0002 stdin 001c _IO_vfscanf"
	strings:
		$1 = { 0F B4 ?? ?2 0? 0? 10 B5 82 B0 04 AC ?? ?2 0? 0? 00 23 54 F8 04 1B 10 68 22 46 01 94 ?? ?? ?? ?? 02 B0 BD E8 10 40 04 B0 70 47 }
	condition:
		$1
}

rule file_936_0_0 {
	meta:
		name = "__wscanf"
		size = 42
		refs = "0002 stdin 001c _IO_vfwscanf"
	strings:
		$1 = { 0F B4 ?? ?2 0? 0? 10 B5 82 B0 04 AC ?? ?2 0? 0? 00 23 54 F8 04 1B 10 68 22 46 01 94 ?? ?? ?? ?? 02 B0 BD E8 10 40 04 B0 70 47 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "fstatvfs"
		size = 62
		refs = "000a __fstatfs 001a __fxstat64 002e __internal_statvfs"
	strings:
		$1 = { 70 B5 AA B0 0D 46 69 46 06 46 ?? ?? ?? ?? 00 28 12 DB 10 AC 31 46 22 46 03 20 ?? ?? ?? ?? 29 46 6A 46 B0 F1 FF 3F 14 BF 23 46 00 23 00 20 ?? ?? ?? ?? 00 20 2A B0 70 BD 4F F0 FF 30 FA E7 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "syscall"
		size = 32
		refs = "001c __syscall_error"
	strings:
		$1 = { EC 46 F0 B4 07 46 08 46 11 46 1A 46 9C E8 78 00 00 DF F0 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__strverscmp"
		size = 190
		refs = "0024 .LANCHOR0"
	strings:
		$1 = { 88 42 70 B4 54 D0 06 78 42 1C 0B 78 01 31 A6 F1 30 04 09 2C 8C BF 00 24 01 24 30 2E 08 BF 01 34 F5 1A 1C BF ?? ?2 0? 0? ?? ?2 0? 0? 18 D1 00 2E 43 D0 ?? ?2 0? 0? ?? ?2 0? 0? 00 E0 20 B3 12 F8 01 0B 35 5D A0 F1 30 04 11 F8 01 3B 09 2C 8C BF 00 24 01 24 30 28 08 BF 01 34 2C 44 C5 1A ED D0 04 EB 44 04 A3 F1 30 00 26 44 30 2B 14 BF 33 46 73 1C 09 28 98 BF 01 33 93 F9 0C 00 02 28 08 BF 28 46 01 D0 03 28 06 D0 70 BC 70 47 11 F8 01 3B 30 3B 09 2B 0F D8 12 F8 01 3B 30 3B 09 2B F5 D9 08 78 30 38 09 28 8C BF 28 46 4F F0 FF 30 EB E7 00 20 70 BC 70 47 01 20 E6 E7 30 46 E4 E7 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "getnetent"
		size = 208
		refs = "0002 .LANCHOR0 0032 __getnetent_r 0036 .LANCHOR1 0054 __nss_getent 009c __lll_lock_wait_private 00ba __libc_do_syscall 00c4 __libc_h_errno 00c8 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 83 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 34 D1 25 4E 1D EE 70 5F 24 4B ?? ?2 0? 0? ?? ?2 0? 0? A6 F1 10 01 00 96 7B 44 1B 68 2B 44 ?? ?2 0? 0? 01 93 ?? ?2 0? 0? 4F F4 80 63 ?? ?? ?? ?? 1B 4B 00 21 7B 44 1B 68 EF 58 06 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0D DC 11 4B 30 46 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C3 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__wctrans"
		size = 76
		refs = "0020 __rawmemchr 002e strcmp 0048 _nl_current_LC_CTYPE"
	strings:
		$1 = { F8 B5 1D EE 70 2F 10 4B 06 46 7B 44 1B 68 D3 58 1F 68 3C 6D 20 78 A0 B1 00 25 06 E0 20 46 01 35 ?? ?? ?? ?? 43 78 44 1C 63 B1 21 46 30 46 ?? ?? ?? ?? 00 21 00 28 F1 D1 FB 6E 2B 44 07 EB 83 07 78 6A F8 BD 18 46 F8 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "critical_factorization"
		size = 240
		refs = "00e8 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 39 4B 1D EE 70 CF 2D E9 F0 07 7B 44 1B 68 4F F0 01 08 00 25 5C F8 03 70 44 46 4F F0 FF 36 63 19 00 EB 06 09 8B 42 12 D2 19 F8 04 90 10 F8 03 A0 17 F8 29 90 17 F8 2A A0 CA 45 38 D2 1D 46 01 24 C6 EB 03 08 63 19 8B 42 00 EB 06 09 EC D3 27 4B 4F F0 01 09 C2 F8 00 80 4C 46 7B 44 1B 68 00 25 4F F0 FF 37 5C F8 03 C0 63 19 00 EB 07 08 99 42 12 D9 18 F8 04 80 10 F8 03 A0 1C F8 28 80 1C F8 2A A0 C2 45 1A D9 1D 46 01 24 C7 EB 03 09 63 19 99 42 00 EB 07 08 EC D8 01 37 01 36 B7 42 26 BF C2 F8 00 90 38 46 30 46 BD E8 F0 07 70 47 0C D0 4F F0 01 08 2E 46 44 46 45 44 B0 E7 0C D0 4F F0 01 09 2F 46 4C 46 4D 44 CE E7 44 45 04 F1 01 04 A5 D1 1D 46 01 24 A2 E7 4C 45 04 F1 01 04 C3 D1 1D 46 01 24 C0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 756
		refs = "006a __strncasecmp 00c8 memchr 02e8 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 2D E9 F0 4F AD F2 2C 4D 06 46 8B 46 01 92 10 46 19 46 09 AA 1C 46 FF F7 7B FF 09 AB 0D F2 24 42 02 90 43 F8 04 4F 93 42 FB D1 00 2C 00 F0 53 81 AD 4A 1D EE 70 5F DD F8 04 C0 04 F1 FF 3E 7A 44 12 68 00 23 0A AF A8 58 1C F8 03 20 C3 EB 0E 01 01 33 A3 42 50 F8 22 20 47 F8 22 10 F4 D1 01 98 09 9B 01 46 02 9A 19 44 03 93 ?? ?? ?? ?? 00 28 40 F0 A9 80 80 46 9D 4B 02 98 C2 46 01 99 67 1E 01 38 04 90 7B 44 1B 68 01 44 B1 46 06 91 ED 58 5A 46 03 9B E3 1A 05 93 02 9B C3 F1 01 03 07 93 23 46 44 46 98 46 09 E0 2C B1 03 98 DD F8 14 B0 98 42 88 BF 5B 46 9A 44 00 24 32 46 0A EB 08 06 09 EB 02 00 00 21 B2 1A ?? ?? ?? ?? 00 28 72 D1 00 2E 70 D0 09 EB 06 03 0D F1 28 0B 13 F8 01 3C 55 F8 23 30 5B F8 23 30 00 2B DD D1 02 9B 01 99 9C 42 28 BF 23 46 BB 42 03 EB 0A 02 19 44 09 EB 02 0C 1C D2 DD F8 04 B0 19 F8 02 00 1B F8 03 20 55 F8 20 00 55 F8 22 20 82 42 46 D1 62 46 A4 46 09 E0 11 F8 01 4F 12 F8 01 0F 55 F8 24 40 55 F8 20 00 84 42 39 D1 01 33 BB 42 F2 D3 64 46 DD F8 08 B0 04 9B 5C 45 53 44 09 EB 03 01 28 BF 5B 46 23 D2 DD F8 18 B0 19 F8 03 30 9B F8 00 20 55 F8 23 30 55 F8 22 20 9A 42 40 F0 B8 80 5A 46 04 9B A4 46 B3 46 0A E0 12 F8 01 6D 11 F8 01 4D 55 F8 26 60 55 F8 24 40 A6 42 1A D1 03 46 63 45 03 F1 FF 30 F0 D1 64 46 5E 46 63 46 01 34 9C 42 00 F2 9F 80 03 9B 05 9C 9A 44 87 E7 DD F8 1C B0 00 24 DA 44 9A 44 81 E7 00 20 0D F2 2C 4D BD E8 F0 8F 64 46 5E 46 E9 E7 02 9B 4F F0 00 09 02 98 67 1E E2 1A 47 4B 82 42 38 BF 02 46 41 1E 01 32 06 92 09 92 C0 F1 01 00 01 9A 03 91 7B 44 1B 68 0A 44 04 92 DD F8 10 A0 02 9A 01 99 82 44 ED 58 90 46 11 44 5A 46 D3 46 A2 46 05 90 01 91 09 EB 0A 04 B0 18 00 21 A2 1A ?? ?? ?? ?? 00 28 CB D1 00 2C C9 D0 33 19 0A A8 13 F8 01 3C 55 F8 23 30 50 F8 23 30 00 2B 45 D1 B8 45 09 EB 08 03 06 EB 03 01 1A D2 01 98 F3 5C 02 78 55 F8 23 30 55 F8 22 20 9A 42 3E D1 02 46 43 46 A4 46 09 E0 12 F8 01 4F 11 F8 01 0F 55 F8 24 40 55 F8 20 00 84 42 2B D1 01 33 BB 42 F2 D3 64 46 03 98 03 9B 01 30 4B 44 06 EB 03 02 16 D0 04 98 F3 5C 01 78 55 F8 23 30 55 F8 21 10 99 42 13 D1 03 46 09 E0 13 F8 01 0D 12 F8 01 1D 55 F8 20 00 55 F8 21 10 88 42 07 D1 5B 45 F3 D1 06 EB 09 00 0D F2 2C 4D BD E8 F0 8F 06 9B 99 44 22 46 A1 E7 64 46 05 99 89 44 99 44 F8 E7 43 46 F9 E7 1D EE 70 5F C0 E6 02 9B 5C E7 09 EB 0A 00 68 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "__strcasestr"
		size = 786
		refs = "0096 __strncasecmp 00d2 memchr 02e8 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 2D E9 F0 4F 89 46 03 78 8B B0 00 2B 00 F0 7A 81 0A 78 8A B3 B4 4C 1D EE 70 5F 06 46 01 31 7C 44 24 68 4F F0 01 08 2C 59 02 E0 11 F8 01 2B 92 B1 54 F8 23 70 0D 46 54 F8 22 20 16 F8 01 3F 97 42 14 BF 4F F0 00 08 08 F0 01 08 00 2B ED D1 2B 78 00 2B 40 F0 B6 80 B8 F1 00 0F 0D D1 C9 EB 05 05 00 F1 01 0A 1F 2D 05 F1 FF 36 08 D9 50 46 31 46 4A 46 2B 46 FF F7 4A FE 0B B0 BD E8 F0 8F 29 46 09 AA 48 46 FF F7 CA FD 09 9B 19 46 49 44 04 93 01 90 02 46 48 46 ?? ?? ?? ?? 00 28 76 D1 93 4B 1D EE 70 2F 01 98 C3 46 04 99 01 38 02 90 7B 44 1B 68 48 44 69 1A 03 90 D4 58 32 46 01 9B 06 91 C3 F1 01 03 05 93 0B EB 05 07 0A EB 02 00 00 21 BA 1A ?? ?? ?? ?? 00 28 73 D1 00 2F 71 D0 01 9B 98 45 28 BF 43 46 9D 42 03 EB 0B 00 09 EB 03 01 0A EB 00 02 17 D9 1A F8 00 00 19 F8 03 60 54 F8 20 00 54 F8 26 60 86 42 0A D0 5E E0 11 F8 01 6F 12 F8 01 0F 54 F8 26 60 54 F8 20 00 86 42 54 D1 01 33 9D 42 F2 D8 01 98 02 9B 40 45 5B 44 0A EB 03 01 40 F2 E5 80 03 98 1A F8 03 30 02 78 54 F8 23 30 54 F8 22 20 9A 42 40 F0 DA 80 02 46 02 9B AC 46 0A E0 12 F8 01 5D 11 F8 01 6D 54 F8 25 50 54 F8 26 60 B5 42 36 D1 03 46 43 45 03 F1 FF 30 F0 D1 65 46 43 46 08 F1 01 08 98 45 00 F2 C6 80 04 9B DD F8 18 80 9B 44 3A 46 9C E7 58 4B 1D EE 70 1F 01 98 7B 44 1B 68 00 F1 01 0B 19 F8 00 20 5E 45 CC 58 50 44 03 90 14 F8 22 70 16 D2 01 9B C5 F1 02 02 0A EB 06 00 41 46 1A 44 ?? ?? ?? ?? 58 B1 00 20 0B B0 BD E8 F0 8F 05 98 4F F0 00 08 83 44 9B 44 D8 E7 65 46 CD E7 5E 46 01 98 41 1E 2B 1A 04 91 49 44 C0 F1 01 02 88 46 83 42 38 BF 03 46 05 91 01 33 D9 44 06 92 90 44 07 93 CD F8 08 90 09 93 03 99 02 E0 00 2B DA D0 49 46 0B 78 01 F1 01 09 14 F8 23 30 9F 42 F5 D1 03 9B 5D 45 C3 EB 09 09 09 F1 FF 39 1C D9 4B 78 88 1C 02 99 14 F8 23 30 0A 78 54 F8 22 20 9A 42 1C BF 1A 46 5B 46 34 D1 02 99 5B 46 09 E0 10 F8 01 CB 11 F8 01 2F 14 F8 2C C0 54 F8 22 20 62 45 26 D1 01 33 9D 42 F2 D8 04 98 04 9B 01 30 4B 44 0A EB 03 02 19 D0 05 98 1A F8 03 30 01 78 14 F8 23 30 54 F8 21 10 99 42 18 BF 19 46 34 D1 05 9B 09 E0 12 F8 01 1D 13 F8 01 0D 14 F8 21 10 54 F8 20 00 88 42 28 D1 43 45 F3 D1 0A EB 09 00 E5 E6 62 46 00 2A 87 D0 06 99 89 44 4B 44 03 EB 05 09 0A EB 06 00 C6 EB 09 02 00 21 00 93 ?? ?? ?? ?? 00 9B 00 28 7F F4 77 AF B9 F1 00 0F 3F F4 73 AF 01 9A 4E 46 13 44 0A EB 03 09 91 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 29 3F F4 64 AF 07 9B 4B 44 DB E7 01 9B 38 E7 0D 46 4F F0 01 08 A0 E6 0A EB 0B 00 B2 E6 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__libc_csu_init"
		size = 126
		refs = "0004 __preinit_array_end 0008 __preinit_array_start 003e __init_array_end 0042 __init_array_start 0052 _init"
	strings:
		$1 = { 2D E9 F8 43 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 46 C8 EB 09 09 0E 46 17 46 5F EA A9 09 1C BF A8 F1 04 08 00 24 08 D0 01 34 58 F8 04 3F 28 46 31 46 3A 46 98 47 4C 45 F6 D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? C8 EB 09 09 ?? ?? ?? ?? 5F EA A9 09 1C BF A8 F1 04 08 00 24 0A D0 01 34 58 F8 04 3F 28 46 31 46 3A 46 98 47 4C 45 F6 D1 BD E8 F8 83 BD E8 F8 83 }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "__libc_csu_fini"
		size = 48
		refs = "0002 __fini_array_end 0006 __fini_array_start 002c _fini"
	strings:
		$1 = { 38 B5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 64 1B A4 10 18 BF 05 EB 84 05 04 D0 55 F8 04 3D 98 47 01 3C FA D1 BD E8 38 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "xdr_rmtcallres"
		size = 66
		refs = "0006 xdr_u_long 001a xdr_reference"
	strings:
		$1 = { 70 B5 0C 46 82 B0 ?? ?2 0? 0? 25 68 02 A9 04 22 ?? ?2 0? 0? 06 46 41 F8 04 5D ?? ?? ?? ?? 10 B9 00 20 02 B0 70 BD 30 46 21 1D ?? ?? ?? ?? 00 28 F6 D0 01 9B 30 46 E2 68 A1 68 23 60 90 47 02 B0 70 BD }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "xdr_rmtcall_args"
		size = 154
		refs = "000a xdr_u_long"
	strings:
		$1 = { 2D E9 F0 41 82 B0 04 46 0D 46 ?? ?? ?? ?? 18 B9 00 20 02 B0 BD E8 F0 81 20 46 29 1D ?? ?? ?? ?? 00 28 F5 D0 20 46 05 F1 08 01 ?? ?? ?? ?? 00 28 EE D0 63 68 02 AE 00 22 20 46 46 F8 04 2D 1B 69 98 47 31 46 07 46 20 46 ?? ?? ?? ?? 00 28 DF D0 63 68 20 46 1B 69 98 47 6B 69 29 69 06 46 20 46 98 47 00 28 D4 D0 63 68 20 46 1B 69 98 47 63 68 39 46 5B 69 86 1B 80 46 45 F8 0C 6F 20 46 98 47 20 46 29 46 ?? ?? ?? ?? 00 28 C1 D0 63 68 41 46 20 46 5B 69 98 47 01 20 BB E7 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "pmap_rmtcall"
		size = 176
		refs = "0004 .LANCHOR0 0038 clntudp_create 0054 xdr_rmtcallres 005a xdr_rmtcall_args"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 B0 10 AD 8A 46 67 68 48 F2 A0 61 91 46 98 46 4F F0 FF 32 23 68 00 97 4F F4 DE 44 45 F8 2C 2D C0 F2 01 01 01 95 02 22 44 80 06 46 ?? ?? ?? ?? 10 25 04 46 00 28 2F D0 1A 9F 1E AB D0 F8 04 E0 0D F1 08 0B 93 E8 03 00 ?? ?2 0? 0? 0F 97 ?? ?2 0? 0? 20 9F ?? ?2 0? 0? 1B 9B 0D F1 18 0C CD F8 28 A0 ?? ?2 0? 0? 06 97 1D 9F 0E 93 0A AB 8D E8 20 10 08 97 1C 9F CD F8 2C 90 CD F8 30 80 09 97 8B E8 03 00 20 46 DE F8 00 50 05 21 A8 47 63 68 1B 69 05 46 20 46 98 47 28 46 00 23 73 80 11 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "clnt_broadcast"
		size = 960
		refs = "0012 authunix_create_default 0022 __socket 0034 __setsockopt 0046 getifaddrs 00a2 _libc_intl_domainname 00a6 .LC1 00b6 __dcgettext 00ba perror 00c0 __close 00dc .LC0 00fc freeifaddrs 012c _create_xid 01a0 xdrmem_create 01a8 xdr_callmsg 01b6 xdr_rmtcall_args 01d6 _null_auth 01e0 xdr_rmtcallres 021c __sendto 022c .LC3 0248 .LC2 0266 xdr_void 0286 __poll 02ca __recvfrom 02ec xdr_replymsg 034a .LC4 036a .LC5 03b8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F AD F5 23 5D 8F B0 8A 46 91 46 98 46 83 46 ?? ?? ?? ?? 11 22 01 26 0C 96 04 46 02 20 01 46 ?? ?? ?? ?? 05 1E 56 DB 04 22 0C AB 00 92 31 46 06 22 ?? ?? ?? ?? 00 28 32 DB 0D F5 D3 60 0E 95 AD F8 3C 60 ?? ?? ?? ?? 00 28 40 F0 FC 80 DD F8 98 66 00 2E 4E D0 01 46 33 46 09 E0 1B 68 13 29 CC BF 00 22 01 22 00 2B 08 BF 00 22 00 2A 42 D0 9A 68 02 F0 03 02 03 2A F0 D1 DA 68 00 2A ED D0 12 88 02 2A EA D1 5A 69 0D F5 23 57 38 37 07 EB 81 00 01 31 52 68 A0 F5 20 50 40 F8 28 2C DD E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 03 26 ?? ?? ?? ?? ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 23 6A 20 46 1B 69 98 47 30 46 0D F5 23 5D 0F B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 03 26 ?? ?? ?? ?? ?? ?? ?? ?? E3 E7 31 46 30 46 05 91 ?? ?? ?? ?? 4F F0 00 0C 4F F4 DE 43 CD F8 44 C0 2E AE AD F8 42 30 02 23 CD F8 48 C0 0D F5 24 57 CD F8 4C C0 20 37 AD F8 40 30 02 93 CD F8 0C C0 ?? ?? ?? ?? 02 9B 48 F2 A0 62 C0 F2 01 02 2B 92 3F 68 04 F1 0C 0E 2C 93 2A 93 05 23 2D 93 DD F8 0C C0 63 46 04 90 46 F8 18 0C 94 E8 07 00 CD F8 A4 C0 06 F1 0C 0C 46 F8 30 BC CD F8 8C A0 86 E8 07 00 9E E8 07 00 26 97 0D F5 24 57 24 37 CD F8 90 90 CD F8 9C 80 3F 68 8C E8 07 00 1C A8 1B 97 0D F5 24 57 28 37 48 A9 4F F4 AF 62 3F 68 1A 97 0D AF 18 97 ?? ?? ?? ?? 1C A8 28 A9 ?? ?? ?? ?? 08 B9 01 26 85 E7 22 A9 1C A8 ?? ?? ?? ?? 00 28 F7 D0 1D 9B 1C A8 1B 69 98 47 1D 9B DB 69 81 46 0B B1 1C A8 98 47 DD F8 14 A0 ?? ?2 0? 0? ?? ?2 0? 0? 06 97 ?? ?2 0? 0? 09 94 ?? ?2 0? 0? 07 97 4F F4 7A 67 08 97 BA F1 00 0F 30 D0 4F F0 00 08 0D F1 CC 0B 10 24 01 E0 D0 45 28 D0 5B F8 04 7F 10 AA 28 46 00 92 48 A9 01 94 4A 46 00 23 11 97 ?? ?? ?? ?? 08 F1 01 08 81 45 ED D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 09 9C 03 26 ?? ?? ?? ?? ?? ?? ?? ?? 3A E7 ?? ?2 0? 0? 00 22 ?? ?2 0? 0? 05 92 ?? ?? ?? ?? 52 E7 0D F5 24 53 2C 33 1B 68 00 2B 64 D0 ?? ?2 0? 0? ?? ?2 0? 0? 06 9F 18 AB 2F 93 97 E8 07 00 07 9F 06 E9 07 00 0E A8 01 21 08 9A 30 97 ?? ?? ?? ?? 43 1C 53 D0 48 B9 08 9F 07 F5 FA 67 08 97 B7 F5 7A 5F A9 D1 09 9C 05 26 0C E7 10 24 05 E0 43 4A 7A 44 12 68 9B 58 04 2B 58 D1 14 AA 0B AB 00 92 28 46 01 93 0D F5 D3 61 00 23 42 F2 60 22 0B 94 ?? ?? ?? ?? 1D EE 70 3F 00 28 E8 DB 03 28 C9 D9 02 46 0D F5 D3 61 1C A8 01 23 ?? ?? ?? ?? 1C A8 28 A9 ?? ?? ?? ?? 04 46 20 B1 28 9B 04 9F 9F 42 44 D0 00 24 28 A9 1C A8 02 23 0D F5 24 57 1C 93 28 37 CD F8 C0 80 ?? ?? ?? ?? 0D F5 24 52 1C A8 24 32 39 68 12 68 90 47 1D 9B DB 69 0B B1 1C A8 98 47 00 2C 9E D0 09 9C 00 26 C3 E6 21 4B 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 93 D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 09 9C 04 26 ?? ?? ?? ?? ?? ?? ?? ?? AB E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 09 9C 04 26 ?? ?? ?? ?? ?? ?? ?? ?? 9B E6 2A 9C 00 2C B7 D1 2E 9B 00 2B B5 D1 0D F5 24 52 0D 9B 28 32 14 A9 10 68 C3 F3 07 22 42 EA 03 23 AD F8 52 30 0D F5 24 53 2C 33 1B 68 98 47 04 46 A2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "compute_tzname_max"
		size = 62
		refs = "0000 .LANCHOR0 000a __tzname_cur_max"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 30 B4 ?? ?2 0? 0? 1C 68 ?? ?2 0? 0? 20 44 23 78 7B B1 62 1C 13 46 01 32 19 78 00 29 FA D1 2A 68 1C 1B A2 42 38 BF 2C 60 5C 1C 84 42 EF D3 30 BC 70 47 23 46 F8 E7 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__tzfile_read"
		size = 2156
		refs = "0004 __use_tzfile 002e __libc_enable_secure 0046 .LC2 004e getenv 005e default_tzdir.8272 006e strlen 008a mempcpy 0098 memcpy 00aa __xstat64 00b2 .LC3 00bc _IO_new_fopen 00c6 fileno 00d2 __fxstat64 00dc .LANCHOR1 00e0 .LANCHOR0 00f0 free 0122 fread_unlocked 012a .LC4 0138 memcmp 0144 _IO_new_fclose 014e .LC1 0158 strstr 01da .LC0 0290 malloc 0364 __uflow 0562 __tzstring 056c __tzname 05f4 __timezone 05f8 __daylight 0702 fseek 070e ftello 0816 .LC5 081a .LC6 081e __PRETTY_FUNCTION__.8436 0832 __assert_fail"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? B3 B0 ?? ?2 0? 0? 00 23 00 AF 89 46 D8 F8 00 A0 93 46 04 46 C8 F8 00 30 00 28 00 F0 EE 80 05 78 00 2D 00 F0 9A 80 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 00 2B 40 F0 86 80 2F 2D 08 BF 26 46 2A D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 05 46 18 B1 03 78 00 2B 40 F0 B9 80 ?? ?2 0? 0? 14 23 ?? ?2 0? 0? 13 26 20 46 7B 60 ?? ?? ?? ?? 7B 68 29 46 32 46 45 1C 2B 44 0E 33 23 F0 07 03 AD EB 03 0D 68 46 6E 46 ?? ?? ?? ?? 2F 23 2A 46 21 46 00 F8 01 3B ?? ?? ?? ?? BA F1 00 0F 07 D0 03 20 31 46 07 F1 60 02 ?? ?? ?? ?? 00 28 6E D0 ?? ?2 0? 0? 30 46 ?? ?2 0? 0? ?? ?? ?? ?? 38 60 00 28 4D D0 ?? ?? ?? ?? 07 F1 60 02 01 46 03 20 ?? ?? ?? ?? 05 46 00 28 51 D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? DA F8 00 00 ?? ?? ?? ?? D7 F8 B0 40 D7 E9 30 23 D7 E9 18 01 B4 61 3C 68 C6 E9 02 23 01 22 C6 E9 04 01 07 F1 34 00 23 68 2C 21 CA F8 00 50 43 F4 00 43 23 60 23 46 ?? ?? ?? ?? 01 28 0B D1 ?? ?2 0? 0? 07 F1 34 00 ?? ?2 0? 0? 04 22 ?? ?? ?? ?? 78 62 00 28 64 D0 38 68 ?? ?? ?? ?? 0F E0 2F 2D 45 D0 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 3F F4 6E AF ?? ?2 0? 0? ?? ?2 0? 0? DA F8 00 00 ?? ?? ?? ?? 00 23 CA F8 00 30 CC 37 BD 46 BD E8 F0 8F 38 68 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? EC E7 ?? ?2 0? 0? D7 E9 30 45 ?? ?2 0? 0? D1 E9 02 23 9D 42 08 BF 94 42 84 D1 D7 E9 18 45 D1 E9 04 23 9D 42 08 BF 94 42 7F F4 7C AF D7 F8 B0 30 8A 69 93 42 04 BF 01 23 C8 F8 00 30 7F F4 72 AF D3 E7 ?? ?? ?? ?? 06 46 43 1C 47 E7 ?? ?2 0? 0? 0F 22 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 B0 D0 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 13 22 ?? ?? ?? ?? 00 28 A6 D0 AF E7 ?? ?2 0? 0? ?? ?2 0? 0? 47 E7 7B 6D B9 6D 93 FA 83 FC 3A 6D F8 6D BC F1 33 3F FD 6C 09 BA BB 6C 12 BA 00 BA 2D BA 1B BA F8 61 C6 F8 1C C0 3D 61 31 62 7B 61 72 62 83 D2 4F EA 8C 05 BD 61 2B 46 63 44 03 33 23 F0 03 03 D8 43 B1 EB D0 0F 3F F6 77 AF C9 00 FC 69 39 62 19 44 C8 43 A0 42 FF F4 6F AF 21 44 08 1D 3F F6 6B AF 03 31 21 F0 03 05 E9 43 B2 EB D1 0F 3F F6 63 AF D4 00 60 19 C2 43 4A 45 FF F4 5D AF 48 44 7B 60 C7 F8 08 C0 ?? ?? ?? ?? 7B 68 D7 F8 08 C0 CA F8 00 00 00 28 3F F4 4F AF BA 69 03 44 39 6A 05 44 02 44 F3 62 19 44 B2 62 00 23 31 60 35 63 73 63 B9 F1 00 0F 02 D0 25 44 CB F8 00 50 62 46 3B 68 05 21 ?? ?? ?? ?? F3 69 ?? ?2 0? 0? ?? ?2 0? 0? 98 42 7F F4 30 AF 00 28 00 F0 7D 82 93 6A 15 6A 1A 78 95 42 7F F6 27 AF 59 1E 3C 68 01 44 04 E0 13 F8 01 2F 95 42 40 F2 AA 80 8B 42 F8 D1 DA F8 00 30 42 1E 3C 60 03 EB 80 03 53 F8 04 1C 01 3A 09 BA 43 F8 04 1D 51 1C F7 D1 3C 60 07 F1 2B 01 C7 F8 20 A0 3C 68 4F F0 00 09 D7 F8 1C A0 07 F1 2F 05 8B 46 C7 F8 18 80 63 68 D8 46 A1 68 99 42 09 D9 5A 1C 62 60 18 78 08 F8 01 0F A8 45 0C D0 13 46 99 42 F5 D8 20 46 ?? ?? ?? ?? 43 1C 40 F0 64 82 3C 60 D7 F8 20 A0 E5 E6 91 42 40 F2 49 82 53 1C 63 60 10 78 01 28 F3 D8 F3 6A 4F EA C9 08 43 44 18 71 62 68 A3 68 9A 42 80 F0 36 82 53 1C 63 60 10 78 50 45 E4 D8 F3 6A 09 F1 01 09 31 6A FA 6A 03 EB 08 0C 49 45 12 BA 8C F8 05 00 43 F8 08 20 C1 D8 D7 F8 18 80 D7 F8 20 A0 3C 60 3B 68 01 21 30 68 FA 69 ?? ?? ?? ?? FD 69 ?? ?2 0? 0? ?? ?2 0? 0? A8 42 38 62 7F F4 AD AE 5B 6A 00 2B 43 D0 07 F1 2B 01 3C 68 4F F0 00 0B 07 F1 2F 05 89 46 A0 68 4A 46 63 68 83 42 80 F0 F3 81 59 1C 61 60 1B 78 02 F8 01 3F AA 42 F4 D1 32 6B 4F EA CB 0C F9 6A 4B 46 09 BA 42 F8 3B 10 62 68 82 42 0A D2 51 1C 61 60 10 78 03 F8 01 0F 9D 42 10 D0 A0 68 62 68 82 42 F4 D3 20 46 7B 60 C7 F8 08 C0 ?? ?? ?? ?? 7B 68 D7 F8 08 C0 41 1C EC D1 3C 60 71 E6 33 6B 0B F1 01 0B FA 6A 9C 44 73 6A 12 BA 5B 45 CC F8 04 20 C4 D8 3C 60 3C 69 00 2C 00 F0 B7 81 3C 68 00 25 D7 F8 10 90 63 68 A2 68 93 42 80 F0 E7 81 5A 1C 62 60 18 78 F3 6A 00 30 18 BF 01 20 03 EB C5 03 01 35 4D 45 98 71 ED D1 3C 60 31 6A ?? ?2 0? 0? ?? ?2 0? 0? A9 42 0B D9 DB 6A 00 22 3C 68 03 EB C5 05 03 EB C1 03 AA 71 08 35 9D 42 FB D1 3C 60 7D 69 0B 46 DD B1 3C 68 00 25 D7 F8 14 90 63 68 A2 68 93 42 80 F0 B3 81 5A 1C 62 60 18 78 F2 6A 00 30 18 BF 01 20 ?? ?2 0? 0? 02 EB C5 02 01 35 4D 45 ?? ?2 0? 0? D0 71 E9 D1 1B 6A 3C 60 AB 42 0B D9 F1 6A 00 22 3C 68 01 EB C5 05 01 EB C3 03 EA 71 08 35 9D 42 FB D1 3C 60 97 F8 38 30 00 2B 40 F0 B2 80 72 6B ?? ?2 0? 0? ?? ?2 0? 0? 12 B1 12 78 02 B9 5A 63 38 68 00 24 ?? ?? ?? ?? 33 6A 5B B1 F2 6A 33 68 02 EB C4 02 01 34 50 79 18 44 ?? ?? ?? ?? 33 6A A3 42 F3 D8 ?? ?2 0? 0? F4 69 ?? ?2 0? 0? 00 23 C9 F8 00 30 C9 F8 04 30 00 2C 00 F0 21 81 ?? ?2 0? 0? C7 F8 1C 80 ?? ?2 0? 0? CB 46 D0 46 B2 6A 01 3C F3 6A ?? ?2 0? 0? ?? ?2 0? 0? 12 5D 03 EB C2 02 92 F8 04 A0 59 F8 2A 30 7B B3 00 2C EE D1 D7 F8 1C 80 D9 F8 00 30 00 2B 00 F0 01 81 D9 F8 04 20 ?? ?2 0? 0? ?? ?2 0? 0? 00 2A 00 F0 F5 80 38 6A FF F7 F1 FC F3 69 ?? ?2 0? 0? ?? ?2 0? 0? 33 BB C3 6A 1B 68 19 46 83 63 C3 63 ?? ?2 0? 0? ?? ?2 0? 0? 7D 6A ?? ?2 0? 0? ?? ?2 0? 0? 49 42 01 20 11 60 1D 60 C8 F8 00 00 B1 E5 D8 F8 00 30 50 79 18 44 ?? ?? ?? ?? CA F1 01 03 4B F8 2A 00 5B F8 23 30 00 2B C1 D0 D7 F8 1C 80 2B 68 C3 E7 4F F0 00 0A 85 6A D1 46 C0 F8 38 A0 C0 F8 3C A0 52 46 C4 6A 30 46 51 46 01 3B AA 46 4E 46 84 46 89 B9 1A F8 03 00 04 EB C0 05 2D 79 5D B9 54 F8 30 60 01 21 0A 42 40 F0 9B 80 58 1E 00 2B 00 F0 86 80 03 46 EC E7 52 B9 1A F8 03 00 04 EB C0 05 2D 79 00 2D F1 D0 54 F8 30 90 01 22 EA E7 01 22 E8 E7 07 F1 34 00 2C 21 01 22 3B 68 ?? ?? ?? ?? 01 28 05 46 7F F4 49 AD ?? ?2 0? 0? 07 F1 34 00 ?? ?2 0? 0? 04 22 ?? ?? ?? ?? 00 28 7F F4 3D AD BC 6D 2A 46 F9 6D FB 6C 94 FA 84 FE BC 6C 09 BA 7D 6D 1B BA 0B 44 21 BA 3C 6D 2D BA 0B 44 0E EB 4E 0E 94 FA 84 FC 05 EB C5 05 2B 44 38 68 0C EB 4C 0C 03 EB 4E 01 01 EB 8C 01 ?? ?? ?? ?? 00 28 7F F4 1B AD 38 68 ?? ?? ?? ?? B0 F1 00 0B FF F6 14 AD 0B F1 02 00 D7 E9 24 23 C1 17 82 42 73 EB 01 05 FF F6 0A AD CB EB 02 0B 3C 68 0B F1 0D 01 21 F0 07 01 AD EB 01 0D 63 68 A2 68 68 46 93 42 4F EA D0 05 4F EA C5 09 74 D2 3C 68 5A 1C 62 60 18 78 0A 28 7F F4 F1 AC AB F1 02 0B 48 46 5A 46 01 21 3B 68 ?? ?? ?? ?? 83 45 7F F4 E6 AC 00 23 48 46 0B F8 35 30 ?? ?? ?? ?? 70 63 D7 E6 63 46 B4 46 1E 46 ?? ?2 0? 0? ?? ?2 0? 0? 61 46 C6 F8 3C C0 C6 F8 38 90 00 2A 50 D1 C3 F8 38 C0 25 E7 63 46 B4 46 BC EB 09 05 61 46 18 BF 01 25 C3 F8 3C C0 C3 F8 38 90 7D 62 18 E7 1A 68 5A 60 07 E7 32 6A ?? ?2 0? 0? ?? ?2 0? 0? 01 2A 1F D1 18 68 ?? ?? ?? ?? C9 F8 00 00 F1 E6 13 6A 00 2B 7F F4 9F AD EE E5 3D 69 5D E6 20 46 BA 60 ?? ?? ?? ?? BA 68 03 46 01 30 3F F4 2C AE A0 68 04 E6 20 46 ?? ?? ?? ?? C8 E5 20 46 ?? ?? ?? ?? B5 E5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 F5 72 ?? ?? ?? ?? 62 68 A1 68 8B E5 20 46 ?? ?? ?? ?? 8A E7 BC EB 09 04 18 BF 01 24 7C 62 D1 E6 20 46 ?? ?? ?? ?? 43 1C 3F F4 FF AD 48 E6 20 46 ?? ?? ?? ?? 42 1C 7F F4 16 AE F6 E5 }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "__tzfile_default"
		size = 316
		refs = "000e strlen 001e .LC7 002c __tzfile_read 0030 __use_tzfile 003e .LANCHOR0 005a mempcpy 0062 memcpy 007a .LANCHOR1 00fc __timezone 0102 __tzname"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 0E 46 9A 46 91 46 01 90 ?? ?? ?? ?? 47 1C 30 46 ?? ?? ?? ?? 05 AA 44 1C ?? ?2 0? 0? 04 EB 07 08 ?? ?2 0? 0? 41 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1A 68 00 2A 78 D0 ?? ?2 0? 0? ?? ?2 0? 0? DB F8 20 20 01 2A 9C BF 00 22 1A 60 6D D9 01 99 3A 46 05 98 ?? ?? ?? ?? 22 46 31 46 ?? ?? ?? ?? 05 9B DB F8 1C 00 02 22 CB F8 20 20 CB F8 00 30 00 28 5D D0 ?? ?2 0? 0? DB F8 3C 30 DB F8 38 20 ?? ?2 0? 0? DB F8 28 40 00 25 C3 EB 09 03 C2 EB 0A 02 03 96 04 EB 00 0E 02 92 AC 46 09 68 1E 46 DB F8 2C 20 0C E0 98 79 B0 B9 48 59 DD F8 08 C0 60 44 48 51 74 45 05 F1 04 05 93 F8 04 C0 14 D0 23 78 02 EB C3 03 18 79 04 F8 01 0B D8 79 00 28 F0 D1 BC F1 00 0F E6 D1 48 59 74 45 30 44 48 51 05 F1 04 05 93 F8 04 C0 EA D1 03 9E C2 F8 00 90 00 24 C2 F8 08 A0 ?? ?2 0? 0? 57 73 ?? ?2 0? 0? 54 71 01 27 14 71 ?? ?2 0? 0? 17 73 ?? ?2 0? 0? 01 9A 40 46 C9 F1 00 05 CB F8 3C 90 CB F8 38 A0 0D 60 83 E8 44 00 FF F7 12 FB 07 B0 BD E8 F0 8F DB F8 2C 20 DA E7 }
	condition:
		$1
}

rule file_28_3_0 {
	meta:
		name = "__tzfile_compute"
		size = 1208
		refs = "000c .LANCHOR0 0046 __tzname 0060 .LANCHOR1 00e0 __tzstring 0174 __daylight 0178 __timezone 01d6 strcmp 0316 .LC5 031a .LC6 031e __PRETTY_FUNCTION__.8473 0332 __assert_fail 0342 __tzset_parse_tz 034c __offtime 035a __tz_compute 0380 strlen 040a .LC8 0438 .LC9"
	strings:
		$1 = { 2D E9 F0 4F 85 B0 17 46 98 46 03 90 ?? ?2 0? 0? B9 B9 ?? ?2 0? 0? 73 6A 35 6B 00 21 03 9C 39 60 05 EB C3 02 C8 F8 00 10 05 E0 52 F8 08 0D A0 42 40 F3 08 81 0B 46 59 1E 00 2B F6 D1 05 B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 21 F2 69 CA F8 00 10 CA F8 04 10 00 2A 00 F0 9A 81 ?? ?2 0? 0? ?? ?2 0? 0? 1D 68 2B 68 83 42 00 F3 91 81 02 F1 80 43 01 3B 55 F8 23 30 98 42 80 F2 5A 81 42 F2 EF 2E 1B 1A C8 F6 1A 0E 54 1E 4F EA E3 7C 8E FB 03 9E 73 44 CC EB E3 53 9A 42 00 F2 AB 80 01 F1 01 0E 74 45 09 D9 63 18 5B 08 55 F8 23 20 90 42 80 F2 9E 80 1C 46 74 45 F5 D8 B1 6A 04 F1 FF 39 F2 6A ?? ?2 0? 0? 33 68 ?? ?2 0? 0? 11 F8 09 10 02 EB C1 02 50 79 92 F8 04 B0 18 44 ?? ?? ?? ?? F3 69 9C 42 4A F8 2B 00 80 F0 0B 81 ?? ?2 0? 0? A8 6A ?? ?2 0? 0? 29 46 03 E0 F3 69 01 34 A3 42 26 D9 10 F8 04 E0 ?? ?2 0? 0? F3 6A ?? ?2 0? 0? 03 EB CE 03 93 F8 04 B0 93 F8 05 E0 5A F8 2B 30 00 2B EA D1 08 68 01 91 70 44 02 92 ?? ?? ?? ?? 02 9A CB F1 01 03 01 99 42 F8 2B 00 52 F8 23 30 00 2B 40 F0 DE 80 F3 69 01 34 88 6A A3 42 D8 D8 DA F8 00 E0 ?? ?2 0? 0? ?? ?2 0? 0? BE F1 00 0F 00 F0 63 81 10 F8 09 40 F3 6A 03 EB C4 04 F0 6B ?? ?2 0? 0? ?? ?2 0? 0? B2 6B ?? ?2 0? 0? ?? ?2 0? 0? 82 1A ?? ?2 0? 0? C0 F1 00 0C 18 BF 01 22 C1 F8 00 C0 ?? ?2 0? 0? 1A 60 BE F1 00 0F 00 F0 A7 80 DA F8 04 20 ?? ?2 0? 0? ?? ?2 0? 0? 00 2A 00 F0 9B 80 22 79 ?? ?2 0? 0? DD F8 38 90 ?? ?2 0? 0? 33 68 C9 F8 20 20 5A F8 22 90 60 79 49 46 18 44 ?? ?? ?? ?? 00 28 40 F0 2C 81 0E 9B 22 68 C3 F8 28 90 DD F8 38 90 6B 6A C9 F8 24 20 11 E7 19 46 54 E7 C3 EB 02 09 09 F1 FF 3E 55 F8 2E 30 4F EA 8E 0C 98 42 5E DA BE F1 09 0F 05 D9 05 EB 0C 03 53 F8 28 3C 98 42 75 DB AC F1 04 03 EB 58 98 42 A8 BF 74 46 BF F6 48 AF 0C F1 04 0C 74 46 65 44 04 3D 55 F8 08 3C 01 3C 98 42 F9 DB 3C E7 50 68 38 60 10 68 84 42 7F F4 F6 AE 52 68 31 B9 00 2A C4 BF 01 23 C8 F8 00 30 3F F7 ED AE 03 F1 00 53 98 1E 05 EB C0 03 5B 68 93 42 BF F6 E4 AE 01 26 C8 F8 00 60 00 29 3F F4 DE AE 55 F8 30 00 30 44 A0 42 7F F4 D8 AE 33 44 93 42 7F F4 D4 AE 05 EB C1 03 02 22 31 44 0F E0 53 F8 10 5C 53 F8 08 4C 01 35 AC 42 0B D1 53 F8 0C 5C 01 32 53 F8 04 4C 08 3B 68 1C 84 42 28 D1 8A 42 16 46 EC D1 C8 F8 00 20 B8 E6 09 F1 09 01 AC 44 8A 42 04 D9 DC F8 28 30 98 42 BF F6 E2 AE 63 46 74 46 53 F8 04 2F 01 34 90 42 FA DA E7 E6 1A 68 5A 60 61 E7 2B 6A 01 2B 0D D1 28 68 ?? ?? ?? ?? CA F8 00 00 4F E7 A8 6A 24 E7 A9 F1 0B 04 C8 E6 C8 F8 00 60 92 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 15 32 ?? ?? ?? ?? 70 6B 14 46 00 28 3F F4 BF AE 01 91 ?? ?? ?? ?? 01 99 03 A8 0E 9A ?? ?? ?? ?? 00 28 6A D0 03 98 01 22 0E 99 ?? ?? ?? ?? 73 6A 30 6B 32 68 00 EB C3 00 90 42 7F F4 55 AE 33 6A 02 2B 4A D1 ?? ?? ?? ?? 34 68 CA F8 00 00 20 46 ?? ?? ?? ?? 01 30 20 44 ?? ?? ?? ?? 73 6A CA F8 04 00 41 E6 32 6A ?? ?2 0? 0? ?? ?2 0? 0? 00 2A 2F D0 DA 6A 11 79 A9 B1 00 21 1C 46 0D 46 00 29 5B D0 31 6A 01 35 ?? ?2 0? 0? A9 42 ?? ?2 0? 0? 4A D9 E3 6A 03 EB C5 02 10 79 00 28 45 D0 DA F8 04 10 EC E7 89 46 13 46 0D 46 4B 44 32 68 ?? ?2 0? 0? 58 79 ?? ?2 0? 0? 10 44 ?? ?? ?? ?? DA F8 04 30 86 46 CA F8 00 00 00 2B 3E D0 E4 6A 4C 44 B7 E6 91 46 DB 6A 15 46 E7 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 B7 22 ?? ?? ?? ?? F4 69 47 E6 D3 F8 04 E0 C3 F8 00 E0 97 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 47 72 ?? ?? ?? ?? D3 6A A9 42 18 BF 4F EA C5 09 BA D1 00 25 A9 46 B7 E7 50 79 33 68 18 44 ?? ?? ?? ?? CA F8 04 00 9B E7 22 6A 95 42 BD D2 E3 6A 03 EB 09 04 03 EB C5 03 21 79 41 B9 01 35 95 42 BF F4 6E AE 08 33 19 79 00 29 F7 D0 1C 46 60 79 33 68 18 44 ?? ?? ?? ?? F4 6A DA F8 00 E0 4C 44 CA F8 04 00 5C E6 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "fgetpwent"
		size = 388
		refs = "000a _IO_new_fgetpos 0014 .LANCHOR0 003c .LANCHOR1 006c _IO_new_fsetpos 0090 __fgetpwent_r 00a6 realloc 00c0 free 0136 malloc 015a __libc_do_syscall 0168 __lll_lock_wait_private 0174 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 05 A9 07 46 ?? ?? ?? ?? 00 28 40 F0 89 80 ?? ?2 0? 0? 01 22 ?? ?2 0? 0? BF F3 5F 8F 58 E8 00 3F 00 2B 03 D1 48 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 92 80 ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 00 2B 71 D0 ?? ?2 0? 0? ?? ?2 0? 0? 1D EE 70 1F ?? ?2 0? 0? ?? ?2 0? 0? 03 91 0D F1 10 0A 08 E0 38 46 05 A9 2B 60 ?? ?? ?? ?? 00 28 54 D1 D9 F8 00 30 ?? ?2 0? 0? 1A 46 38 46 3B 49 ?? ?2 0? 0? 3B B3 D8 F8 04 30 CD F8 00 A0 ?? ?? ?? ?? 22 28 1D D1 71 68 D5 F8 00 B0 01 F5 80 61 71 60 58 46 ?? ?? ?? ?? 03 46 00 28 DA D1 30 4A 58 46 03 99 7A 44 12 68 51 F8 02 B0 02 93 ?? ?? ?? ?? 2C 4A 03 98 7A 44 12 68 02 9B 40 F8 02 B0 C8 E7 2B 68 0B B9 00 23 04 93 27 4B 00 22 03 99 7B 44 1B 68 CC 58 D8 F8 00 30 BF F3 5F 8F 58 E8 00 1F 99 42 03 D1 48 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 19 DC 1C 4B 03 9A 7B 44 1B 68 04 98 D4 50 09 B0 BD E8 F0 8F 00 22 22 60 13 46 A8 E7 00 20 09 B0 BD E8 F0 8F 4F F4 80 60 C8 F8 04 00 ?? ?? ?? ?? 03 46 28 60 84 E7 03 99 01 22 ?? ?2 0? 0? 4F F0 F0 0C A1 F5 98 63 ?? ?2 0? 0? 99 68 00 23 11 43 ?? ?? ?? ?? D5 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 66 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "fgetsgent"
		size = 388
		refs = "000a _IO_new_fgetpos 0014 .LANCHOR0 003c .LANCHOR1 006c _IO_new_fsetpos 0090 __fgetsgent_r 00a6 realloc 00c0 free 0136 malloc 015a __libc_do_syscall 0168 __lll_lock_wait_private 0174 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 05 A9 07 46 ?? ?? ?? ?? 00 28 40 F0 89 80 ?? ?2 0? 0? 01 22 ?? ?2 0? 0? BF F3 5F 8F 58 E8 00 3F 00 2B 03 D1 48 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 92 80 ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 00 2B 71 D0 ?? ?2 0? 0? ?? ?2 0? 0? 1D EE 70 1F ?? ?2 0? 0? ?? ?2 0? 0? 03 91 0D F1 10 0A 08 E0 38 46 05 A9 2B 60 ?? ?? ?? ?? 00 28 54 D1 D9 F8 00 30 ?? ?2 0? 0? 1A 46 38 46 3B 49 ?? ?2 0? 0? 3B B3 D8 F8 04 30 CD F8 00 A0 ?? ?? ?? ?? 22 28 1D D1 71 68 D5 F8 00 B0 01 F5 80 61 71 60 58 46 ?? ?? ?? ?? 03 46 00 28 DA D1 30 4A 58 46 03 99 7A 44 12 68 51 F8 02 B0 02 93 ?? ?? ?? ?? 2C 4A 03 98 7A 44 12 68 02 9B 40 F8 02 B0 C8 E7 2B 68 0B B9 00 23 04 93 27 4B 00 22 03 99 7B 44 1B 68 CC 58 D8 F8 00 30 BF F3 5F 8F 58 E8 00 1F 99 42 03 D1 48 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 19 DC 1C 4B 03 9A 7B 44 1B 68 04 98 D4 50 09 B0 BD E8 F0 8F 00 22 22 60 13 46 A8 E7 00 20 09 B0 BD E8 F0 8F 4F F4 80 60 C8 F8 04 00 ?? ?? ?? ?? 03 46 28 60 84 E7 03 99 01 22 ?? ?2 0? 0? 4F F0 F0 0C A1 F5 98 63 ?? ?2 0? 0? 99 68 00 23 11 43 ?? ?? ?? ?? D5 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 66 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_861_0_0 {
	meta:
		name = "fgetspent"
		size = 388
		refs = "000a _IO_new_fgetpos 0014 .LANCHOR0 003c .LANCHOR1 006c _IO_new_fsetpos 0090 __fgetspent_r 00a6 realloc 00c0 free 0136 malloc 015a __libc_do_syscall 0168 __lll_lock_wait_private 0174 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 05 A9 07 46 ?? ?? ?? ?? 00 28 40 F0 89 80 ?? ?2 0? 0? 01 22 ?? ?2 0? 0? BF F3 5F 8F 58 E8 00 3F 00 2B 03 D1 48 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 92 80 ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 00 2B 71 D0 ?? ?2 0? 0? ?? ?2 0? 0? 1D EE 70 1F ?? ?2 0? 0? ?? ?2 0? 0? 03 91 0D F1 10 0A 08 E0 38 46 05 A9 2B 60 ?? ?? ?? ?? 00 28 54 D1 D9 F8 00 30 ?? ?2 0? 0? 1A 46 38 46 3B 49 ?? ?2 0? 0? 3B B3 D8 F8 04 30 CD F8 00 A0 ?? ?? ?? ?? 22 28 1D D1 71 68 D5 F8 00 B0 01 F5 80 61 71 60 58 46 ?? ?? ?? ?? 03 46 00 28 DA D1 30 4A 58 46 03 99 7A 44 12 68 51 F8 02 B0 02 93 ?? ?? ?? ?? 2C 4A 03 98 7A 44 12 68 02 9B 40 F8 02 B0 C8 E7 2B 68 0B B9 00 23 04 93 27 4B 00 22 03 99 7B 44 1B 68 CC 58 D8 F8 00 30 BF F3 5F 8F 58 E8 00 1F 99 42 03 D1 48 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 19 DC 1C 4B 03 9A 7B 44 1B 68 04 98 D4 50 09 B0 BD E8 F0 8F 00 22 22 60 13 46 A8 E7 00 20 09 B0 BD E8 F0 8F 4F F4 80 60 C8 F8 04 00 ?? ?? ?? ?? 03 46 28 60 84 E7 03 99 01 22 ?? ?2 0? 0? 4F F0 F0 0C A1 F5 98 63 ?? ?2 0? 0? 99 68 00 23 11 43 ?? ?? ?? ?? D5 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 66 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__getclktck"
		size = 18
		refs = "0000 _dl_clktck"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 18 68 00 28 08 BF 64 20 70 47 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__pause_nocancel"
		size = 20
		refs = "0010 __syscall_error"
	strings:
		$1 = { 80 B4 1A 4F 00 DF 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "__libc_pause"
		size = 76
		refs = "0026 __libc_enable_asynccancel 0034 __libc_disable_asynccancel 0020 __syscall_error"
	strings:
		$1 = { DF F8 4C C0 FC 44 DC F8 00 C0 9C F0 00 0F 80 B4 08 D1 0E 4F 00 DF 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? 00 B5 ?? ?? ?? ?? 84 46 07 4F 00 DF 07 46 60 46 ?? ?? ?? ?? 38 46 5D F8 04 EB 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "getsubopt"
		size = 170
		refs = "0018 __strchrnul 0026 memchr 0044 strncmp"
	strings:
		$1 = { 2D E9 F0 4F 83 B0 07 68 81 46 0D 46 01 92 3B 78 00 2B 47 D0 2C 21 38 46 ?? ?? ?? ?? 3D 21 80 46 38 46 C7 EB 08 02 ?? ?? ?? ?? 2C 68 00 28 14 BF 82 46 C2 46 84 B1 AB 46 C7 EB 0A 06 00 25 38 46 21 46 32 46 ?? ?? ?? ?? 08 B9 A2 5D B2 B1 5B F8 04 4F 01 35 00 2C F2 D1 01 9B 1F 60 98 F8 00 30 33 B9 4F F0 FF 30 C9 F8 00 80 03 B0 BD E8 F0 8F 00 23 08 F1 01 08 08 F8 01 3C F2 E7 01 9B C2 45 18 BF 0A F1 01 02 1A 60 98 F8 00 30 23 B1 00 23 08 F1 01 08 08 F8 01 3C 28 46 C9 F8 00 80 03 B0 BD E8 F0 8F 4F F0 FF 30 DF E7 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "day_of_the_week"
		size = 172
		refs = "0002 __mon_yday"
	strings:
		$1 = { 42 69 ?? ?2 0? 0? 2D E9 F0 07 02 F2 6C 73 04 69 ?? ?2 0? 0? 48 F2 1F 55 46 3A 01 2C D8 BF 01 3B C5 F2 EB 15 DF 1C 31 F8 14 C0 33 EA 23 01 28 BF 39 46 DF 17 85 FB 03 43 8C 10 4F EA E1 7A 40 F2 6D 18 85 FB 04 95 C6 68 08 FB 02 48 6F F4 EC 72 A7 EB 63 19 C7 EB E3 13 42 F2 93 41 CA EB E5 05 90 44 C8 44 C9 F2 49 21 05 EB 85 05 05 EB 85 05 62 1B 08 EB D2 72 1A 44 62 44 32 44 01 3A 81 FB 02 43 D4 17 13 44 C4 EB A3 03 C3 EB C3 03 D3 1A 07 33 81 FB 03 91 DA 17 BD E8 F0 07 19 44 C2 EB A1 01 C1 EB C1 01 5B 1A 83 61 70 47 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "__strptime_internal"
		size = 9366
		refs = "004e _nl_C_LC_TIME 02e8 __strptime_internal 049a __localtime_r 04be strlen 04ce __strncasecmp_l 04ec strcmp 06e8 _nl_select_era_entry 08d2 .LC0 0d28 .LC1 121c _nl_parse_alt_digit 19de __mon_yday 20d2 .LC2 20d6 .LC3 20da __PRETTY_FUNCTION__.10345 20ee __assert_fail"
	strings:
		$1 = { 2D E9 F0 4F A3 B0 88 46 DD F8 B0 90 05 93 13 90 D9 F8 08 40 09 92 08 94 00 2B 00 F0 A1 81 05 9F 0D F1 54 0C 09 9D 17 AC A2 46 CD F8 18 C0 97 E8 03 00 8C E8 03 00 0F CD 0F C4 0F CD 0F C4 95 E8 07 00 84 E8 07 00 44 F6 25 15 4A F6 AB 27 ?? ?2 0? 0? 48 F2 1F 5B C2 F2 92 45 ?? ?2 0? 0? CA F6 AA 27 07 96 C5 F2 EB 1B 2E 46 98 F8 00 30 D3 B1 D9 F8 34 10 31 F8 13 20 94 04 2D D5 13 9B 1A 78 31 F8 12 20 90 04 48 BF 01 33 06 D5 13 93 13 F8 01 2B 31 F8 12 20 92 04 F8 D4 08 F1 01 08 98 F8 00 30 00 2B E4 D1 05 9C 00 2C 01 F0 6F 83 06 9D 17 AE 05 9F 13 9C 95 E8 03 00 09 9D 87 E8 03 00 0F CE 0F C5 0F CE 0F C5 96 E8 07 00 85 E8 07 00 20 46 23 B0 BD E8 F0 8F 25 2B 0C D0 13 9A 08 F1 01 08 51 1C 13 91 12 78 9A 42 BE D0 00 24 20 46 23 B0 BD E8 F0 8F 05 9C 08 F1 01 00 02 46 00 2C 00 F0 2B 81 10 46 12 F8 01 3B 2D 2B FA D0 30 2B F8 D0 A3 F1 5E 04 01 2C F4 D9 23 2B F2 D0 A3 F1 30 02 09 2A 07 D8 42 1C 10 46 01 32 03 78 A3 F1 30 04 09 2C F8 D9 25 3B 13 9C 00 F1 01 08 55 2B D4 D8 01 A5 55 F8 23 F0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9D F8 55 30 C3 F3 C1 03 02 2B 11 D0 08 9D D5 F8 CC 10 0A 78 00 2A 41 F0 83 85 01 2B 3F F4 16 AF 9D F8 55 30 02 22 13 94 62 F3 C4 03 8D F8 55 30 07 9D D5 F8 CC 10 0B 78 00 2B 3F F4 07 AF 13 98 52 46 CD F8 00 90 06 9B ?? ?? ?? ?? 13 90 00 28 7F F4 BB AE FA E6 9D F8 55 30 C3 F3 C1 03 02 2B 11 D0 08 9D D5 F8 C8 10 0A 78 00 2A 41 F0 CE 84 01 2B 3F F4 EB AE 9D F8 55 30 02 22 13 94 62 F3 C4 03 8D F8 55 30 DD F8 1C C0 DC F8 C8 10 0B 78 00 2B 3F F4 DB AE 13 98 CD F8 00 90 52 46 06 9B ?? ?? ?? ?? 13 90 00 28 3F F4 D0 AE 9D F8 55 30 43 F0 04 03 8D F8 55 30 87 E6 98 F8 01 30 EA E6 15 93 15 AD 92 46 4F F0 FF 33 FF 22 06 95 8D F8 57 20 16 93 67 E6 43 78 00 F1 02 08 43 3B 36 2B 3F F6 B4 AE 01 A0 50 F8 23 F0 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 22 14 92 23 78 30 3B 09 2B 01 D9 3A E6 1C 46 63 1C 02 EB 82 02 13 93 52 00 14 92 13 F8 01 1C 30 39 0A 44 14 92 61 78 30 39 09 29 EF D9 14 A8 51 46 ?? ?? ?? ?? 00 28 7F F4 E3 AD 22 E6 9D F8 55 30 C3 F3 C1 03 02 2B 01 F0 50 82 08 9D D5 F8 BC 30 18 46 04 93 ?? ?? ?? ?? 04 9B 21 46 05 46 18 46 2A 46 4B 46 ?? ?? ?? ?? 00 28 41 F0 25 82 DD F8 20 C0 07 9C 13 9B DC F8 BC 00 D4 F8 BC 10 2B 44 13 93 ?? ?? ?? ?? 30 B1 9D F8 55 30 01 22 62 F3 C4 03 8D F8 55 30 9D F8 54 30 6F F3 C7 13 8D F8 54 30 AD E5 23 78 31 F8 13 30 9B 04 48 BF 01 34 7F F5 A6 AD 13 94 14 F8 01 3B 31 F8 13 30 98 04 F8 D4 9D E5 9D F8 55 30 C3 F3 C1 03 02 2B 11 D0 08 9D D5 F8 D0 10 0A 78 00 2A 41 F0 18 84 01 2B 3F F4 CF AD 9D F8 55 30 02 22 13 94 62 F3 C4 03 8D F8 55 30 DD F8 1C C0 DC F8 D0 10 0B 78 00 2B 3F F4 BF AD 13 98 52 46 CD F8 00 90 06 9B ?? ?? ?? ?? 13 90 00 28 7F F4 73 AD B2 E5 23 78 31 F8 13 20 95 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 95 04 F7 D4 30 3B 09 2B 3F F6 9F AD 43 1C 13 93 03 78 30 3B 03 EB 83 02 52 00 35 2A 09 D8 41 78 30 39 09 29 9F BF 83 1C 13 93 43 78 30 3B 98 BF 9B 18 35 2B 7F F6 48 AD 87 E5 23 78 31 F8 13 20 90 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 95 04 F7 D4 30 3B 09 2B 3F F6 74 AD 43 1C 13 93 02 78 A2 F1 30 03 03 EB 83 01 49 00 0C 29 0A D8 44 78 30 3C 09 2C 9F BF 83 1C 13 93 42 78 52 18 98 BF A2 F1 30 03 31 3A 0B 2A 3F F6 5B AD A7 FB 03 02 9D F8 54 10 41 F0 01 01 8D F8 54 10 D2 08 02 EB 42 02 A3 EB 82 03 CA F8 08 30 09 E5 23 78 31 F8 13 20 95 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 92 04 F7 D4 30 3B 09 2B 3F F6 37 AD 43 1C 13 93 03 78 A3 F1 30 02 02 EB 82 02 52 00 0C 2A 07 D8 41 78 30 39 09 29 9F BF 83 1C 13 93 43 78 9B 18 31 3B 0B 2B 3F F6 21 AD CA F8 10 30 9D F8 54 20 9D F8 55 30 42 F0 08 02 8D F8 54 20 43 F0 04 03 8D F8 55 30 D0 E4 08 9C 00 20 16 90 D4 F8 EC C0 84 45 05 DC 3B E0 16 98 01 30 16 90 84 45 36 DD 08 99 CD F8 10 C0 ?? ?? ?? ?? DD F8 10 C0 00 28 F1 D0 DA F8 14 20 43 68 01 6B D3 1A 01 FB 03 F3 00 2B 0C 93 E7 DB 45 69 0A 46 0C 9C CB 17 80 68 CD E9 0A 23 2A 46 EB 17 E5 17 CD E9 02 45 12 1A 63 EB E0 73 0B 9D 02 FB 05 F0 01 FB 03 00 A2 FB 01 23 03 44 DD E9 02 01 90 42 99 41 CB DA 16 98 01 22 9D F8 55 30 62 F3 C4 03 8D F8 55 30 84 45 7F F4 8A AC 9D F8 55 30 4F F0 FF 32 16 92 C3 F3 C1 02 01 2A 3F F4 C1 AC 13 9C 02 22 D9 F8 34 10 62 F3 C4 03 8D F8 55 30 22 78 31 F8 12 30 9D 04 08 D5 63 1C 13 93 1C 46 13 F8 01 2B 31 F8 12 00 80 04 F7 D4 30 3A 09 2A 3F F6 A7 AC 63 1C 13 93 22 78 A2 F1 30 03 03 EB 83 01 49 00 63 29 0A D8 60 78 30 38 09 28 9F BF A3 1C 13 93 62 78 52 18 98 BF A2 F1 30 03 63 2B 3F F6 8F AC 44 2B 98 BF 02 F1 34 03 9D F8 55 20 CA F8 14 30 42 F0 05 03 8D F8 55 30 40 E4 23 78 31 F8 13 20 90 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 92 04 F7 D4 30 3B 09 2B 3F F6 6E AC 43 1C 13 93 03 78 30 3B 06 2B 3F F6 67 AC 9D F8 54 20 CA F8 18 30 42 F0 02 03 8D F8 54 30 1C E4 23 78 31 F8 13 20 92 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 95 04 F7 D4 30 3B 09 2B 3F F6 4A AC 43 1C 13 93 03 78 A3 F1 31 02 30 3B 06 2A 3F F6 41 AC A6 FB 03 C2 9D F8 54 00 99 1A 40 F0 02 00 8D F8 54 00 02 EB 51 02 92 08 C2 EB C2 02 9B 1A CA F8 18 30 FF F7 ED BB 9D F8 55 30 C3 F3 C1 03 02 2B 12 D0 DD F8 20 C0 DC F8 C4 10 0A 78 00 2A 41 F0 48 82 01 2B 3F F4 1D AC 9D F8 55 30 02 22 13 94 62 F3 C4 03 8D F8 55 30 07 9C D4 F8 C4 10 0B 78 00 2B 7F F4 33 AD 0C E4 ?? ?2 0? 0? CD F8 00 90 20 46 ?? ?2 0? 0? 2C E5 08 9D ?? ?2 0? 0? 9D F8 55 30 4F F0 00 0C ?? ?2 0? 0? 0D 90 0F 95 4F F0 FF 30 C3 F3 C1 03 CD F8 44 80 12 96 65 46 DD F8 3C 80 0D 9E 0F 97 67 46 CD F8 34 B0 83 46 0A 93 CD F8 30 C0 0E 90 CD F8 40 A0 3C E0 54 44 9D F8 55 30 A7 42 C3 F3 C1 03 7E D2 00 2B 40 F0 E9 87 D8 F8 24 00 27 46 71 6A AB 46 ?? ?? ?? ?? 13 9C 18 B1 4F F0 01 0C CD F8 28 C0 33 6C 18 46 04 93 ?? ?? ?? ?? 04 9B 21 46 82 46 18 46 52 46 4B 46 ?? ?? ?? ?? 00 28 40 F0 EC 86 54 44 BC 42 40 F2 E8 86 27 46 AB 46 4F F0 02 0C CD F8 28 C0 01 35 04 36 07 2D 08 F1 04 08 00 F0 5B 87 9D F8 55 30 13 9C C3 F3 C1 03 02 2B D7 D0 05 F1 07 0A 08 99 1F FA 8A FA 01 EB 8A 0A DA F8 24 30 18 46 04 93 ?? ?? ?? ?? 04 9B 21 46 84 46 18 46 62 46 4B 46 CD F8 10 C0 ?? ?? ?? ?? DD F8 10 C0 B0 B9 64 44 BC 42 13 D9 9D F8 55 30 13 F0 18 0F 1C BF 27 46 AB 46 0B D1 DA F8 24 00 27 46 31 6C AB 46 ?? ?? ?? ?? 0A 9C 00 28 18 BF 01 24 0A 94 D8 F8 24 30 13 9C 18 46 04 93 ?? ?? ?? ?? 04 9B 21 46 82 46 18 46 52 46 4B 46 ?? ?? ?? ?? 00 28 3F F4 7E AF 9D F8 55 30 C3 F3 C1 03 01 2B A8 D0 13 9C 8C E7 63 1C 13 93 23 78 25 2B 3F F4 12 AB FF F7 51 BB 23 78 31 F8 13 20 95 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 95 04 F7 D4 2D 2B 18 BF 2B 2B 0C BF 00 23 01 23 7F F4 39 AB 1A 46 43 1C 13 93 19 46 04 78 13 46 11 F8 01 0B 30 38 09 28 01 F2 4D 81 03 EB 83 03 01 32 13 91 04 2A 11 F8 01 0C 4F EA 43 03 A3 F1 30 03 03 44 EC D1 AB FB 03 02 64 21 52 09 01 FB 02 F2 9B 1A 3B 2B 3F F6 16 AB 32 20 48 F6 89 01 C8 F6 88 01 00 FB 03 F3 A1 FB 03 53 02 EB 13 13 B3 F5 96 6F 3F F6 07 AB 4F F4 61 62 2D 2C 02 FB 03 F3 AB FB 03 C3 4F EA 53 13 08 BF 5B 42 CA F8 24 30 FF F7 B7 BA 23 78 31 F8 13 20 92 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 92 04 F7 D4 30 3B 09 2B 3F F6 E4 AA 43 1C 13 93 03 78 30 3B 03 EB 83 02 52 00 17 2A 09 D8 41 78 30 39 09 29 9F BF 83 1C 13 93 43 78 30 3B 98 BF 9B 18 17 2B 3F F6 CE AA 9D F8 54 20 CA F8 08 30 6F F3 00 02 8D F8 54 20 FF F7 83 BA 23 78 31 F8 13 20 92 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 92 04 F7 D4 30 3B 09 2B 3F F6 B0 AA 43 1C 13 93 03 78 30 3B 03 EB 83 02 52 00 63 2A 09 D8 41 78 30 39 09 29 9F BF 83 1C 13 93 43 78 30 3B 98 BF 9B 18 63 2B 7F F6 59 AA FF F7 98 BA 23 78 31 F8 13 20 95 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 95 04 F7 D4 30 3B 09 2B 3F F6 84 AA 43 1C 13 93 03 78 30 3B 03 EB 83 02 52 00 3B 2A 09 D8 41 78 30 39 09 29 9F BF 83 1C 13 93 43 78 30 3B 98 BF 9B 18 3B 2B 3F F6 6E AA CA F8 04 30 FF F7 29 BA 23 78 30 3B 09 2B 02 D9 FF F7 64 BA 1C 46 63 1C 13 93 62 78 30 3A 09 2A F8 D9 FF F7 1A BA 23 78 31 F8 13 20 90 04 48 BF 01 34 06 D5 13 94 14 F8 01 3B 31 F8 13 20 90 04 F8 D4 30 3B 09 2B 3F F6 49 AA 13 9B 02 24 19 46 01 33 13 93 0A 78 A2 F1 30 00 00 EB 80 00 40 00 B0 F5 B7 7F 0C D8 49 78 30 39 09 29 08 D8 19 46 01 33 13 93 01 3C 0A 78 02 44 A2 F1 30 00 EC D1 31 3A B2 F5 B7 7F BF F4 29 AA 9D F8 54 30 CA F8 1C 20 43 F0 04 03 8D F8 54 30 FF F7 DE B9 23 78 31 F8 13 20 95 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 95 04 F7 D4 30 3B 09 2B 3F F6 0B AA 43 1C 13 93 02 78 A2 F1 30 03 03 EB 83 01 49 00 1F 29 0A D8 44 78 30 3C 09 2C 9F BF 83 1C 13 93 42 78 52 18 98 BF A2 F1 30 03 31 3A 1E 2A 3F F6 F2 A9 9D F8 54 20 CA F8 0C 30 9D F8 55 30 42 F0 10 02 8D F8 54 20 43 F0 04 03 8D F8 55 30 FF F7 A1 B9 ?? ?2 0? 0? CD F8 00 90 20 46 ?? ?2 0? 0? 52 46 06 9B ?? ?? ?? ?? 13 90 00 28 7F F4 92 A9 FF F7 D1 B9 23 78 31 F8 13 20 90 04 48 BF 01 34 06 D5 13 94 14 F8 01 3B 31 F8 13 20 92 04 F8 D4 30 3B 09 2B 3F F6 BF A9 13 9B 03 24 42 F2 0F 7C 18 46 01 33 13 93 01 78 A1 F1 30 02 02 EB 82 05 6D 00 65 45 0C D8 40 78 30 38 09 28 08 D8 18 46 01 33 13 93 01 3C 01 78 29 44 A1 F1 30 02 ED D1 42 F2 0F 73 9A 42 3F F6 9E A9 9D F8 55 30 A1 F2 9C 71 CA F8 14 10 03 F0 FE 03 43 F0 04 03 8D F8 55 30 FF F7 4F B9 23 78 31 F8 13 20 92 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 92 04 F7 D4 30 3B 09 2B 3F F6 7C A9 43 1C 13 93 03 78 30 3B 03 EB 83 02 52 00 35 2A 09 D8 41 78 30 39 09 29 9F BF 83 1C 13 93 43 78 30 3B 98 BF 9B 18 35 2B 3F F6 66 A9 9D F8 54 20 8D F8 56 30 42 F0 40 03 8D F8 54 30 FF F7 1B B9 DD F8 20 C0 00 20 16 90 DC F8 EC 50 85 42 24 DD 08 99 ?? ?? ?? ?? 00 28 01 F0 65 81 03 6A 18 46 04 93 ?? ?? ?? ?? 04 9B 13 99 84 46 18 46 62 46 4B 46 CD F8 10 C0 ?? ?? ?? ?? DD F8 10 C0 00 28 41 F0 51 81 16 98 01 21 13 9A 9D F8 55 30 62 44 13 92 61 F3 C4 03 8D F8 55 30 A8 42 7F F4 EB A8 9D F8 55 30 4F F0 FF 32 16 92 C3 F3 C1 02 01 2A 3F F4 22 A9 D9 F8 34 10 02 22 13 9C 62 F3 C4 03 8D F8 55 30 22 78 31 F8 12 30 9D 04 08 D5 63 1C 13 93 1C 46 13 F8 01 2B 31 F8 12 00 80 04 F7 D4 30 3A 09 2A 3F F6 08 A9 63 1C 13 93 23 78 30 3B 03 EB 83 02 52 00 63 2A 09 D8 61 78 30 39 09 29 9F BF A3 1C 13 93 63 78 30 3B 98 BF 9B 18 63 2B 3F F6 F2 A8 9D F8 55 20 8D F8 57 30 42 F0 04 03 8D F8 55 30 FF F7 A7 B8 23 78 31 F8 13 20 92 04 58 BF 20 46 08 D5 01 34 13 94 20 46 14 F8 01 3B 31 F8 13 20 92 04 F7 D4 30 3B 09 2B 3F F6 D4 A8 43 1C 13 93 03 78 30 3B 03 EB 83 02 52 00 3D 2A 09 D8 41 78 30 39 09 29 9F BF 83 1C 13 93 43 78 30 3B 98 BF 9B 18 3D 2B 3F F6 BE A8 CA F8 00 30 FF F7 79 B8 43 78 00 F1 02 08 48 3B 31 2B 3F F6 B3 A8 0F F2 08 0C 5C F8 23 F0 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "__strptime_l"
		size = 18
		refs = "0008 __strptime_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_1506_1_0 {
	meta:
		name = "__strtol_l"
		size = 18
		refs = "0008 ____strtol_l_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_1401_1_0 {
	meta:
		name = "__strtoll_l"
		size = 18
		refs = "0008 ____strtoll_l_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_834_1_0 {
	meta:
		name = "__strtoul_l"
		size = 18
		refs = "0008 ____strtoul_l_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_1308_1_0 {
	meta:
		name = "__strtoull_l"
		size = 18
		refs = "0008 ____strtoull_l_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_1420_1_0 {
	meta:
		name = "__wcstol_l"
		size = 18
		refs = "0008 ____wcstol_l_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_399_1_0 {
	meta:
		name = "__wcstoll_l"
		size = 18
		refs = "0008 ____wcstoll_l_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_1248_1_0 {
	meta:
		name = "__wcstoul_l"
		size = 18
		refs = "0008 ____wcstoul_l_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_550_1_0 {
	meta:
		name = "__wcstoull_l"
		size = 18
		refs = "0008 ____wcstoull_l_internal"
	strings:
		$1 = { 00 B5 83 B0 00 93 00 23 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "jrand48"
		size = 26
		refs = "0002 __libc_drand48_data 000e __jrand48_r"
	strings:
		$1 = { 00 B5 ?? ?2 0? 0? 83 B0 ?? ?2 0? 0? 01 AA ?? ?? ?? ?? 01 98 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "nrand48"
		size = 26
		refs = "0002 __libc_drand48_data 000e __nrand48_r"
	strings:
		$1 = { 00 B5 ?? ?2 0? 0? 83 B0 ?? ?2 0? 0? 01 AA ?? ?? ?? ?? 01 98 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_longjmp_unwind"
		size = 36
		refs = "0000 __pthread_cleanup_upto"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 80 B4 00 AF 33 B1 A7 F1 0C 01 BD 46 5D F8 04 7B ?? ?? ?? ?? BD 46 5D F8 04 7B 70 47 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "mabort"
		size = 136
		refs = "000e _libc_intl_domainname 0012 .LC2 0020 __dcgettext 0024 __libc_fatal 002c .LC1 0044 .LC3 005c .LC0 0074 .LC4"
	strings:
		$1 = { 08 B5 03 28 34 D8 DF E8 00 F0 27 1B 0F 02 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? F1 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? E5 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? D9 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? CD E7 }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "checkhdr.part.0"
		size = 96
		refs = "0024 .LANCHOR0"
	strings:
		$1 = { 01 1D 38 B5 45 F2 09 33 16 C9 CD F6 67 03 22 44 4A 40 9A 42 22 D0 4B F6 EB 63 CF F6 DA 63 9A 42 0D D0 02 25 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? 00 22 63 68 22 60 98 47 01 23 23 60 28 46 38 BD 03 68 03 44 1B 7E D7 2B 18 BF 03 25 EB D1 01 69 43 69 4B 40 93 42 08 BF 00 25 E3 D1 EE E7 01 25 E1 E7 }
	condition:
		$1
}

rule file_36_2_0 {
	meta:
		name = "unlink_blk.isra.1"
		size = 68
		refs = "0034 .LANCHOR0"
	strings:
		$1 = { 10 B4 49 B1 02 68 4B F6 EB 63 CC 68 CF F6 DA 63 14 44 8A 60 63 40 4B 60 03 68 5B B1 98 68 4B F6 EB 62 CF F6 DA 62 D9 60 01 44 5D F8 04 4B 4A 40 5A 60 70 47 ?? ?2 0? 0? 5D F8 04 4B ?? ?2 0? 0? 99 60 70 47 }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "memalignhook"
		size = 216
		refs = "0002 .LANCHOR0 0024 __memalign_hook 003c memalignhook 0098 memset 00a6 mcheck_check_all 00b0 memalign 00d4 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 0E 46 E3 68 00 2B 46 D1 00 F1 17 03 47 42 1F 40 7B 1C DB 43 B3 42 49 D3 ?? ?2 0? 0? 23 69 ?? ?2 0? 0? 71 1C 39 44 2B 60 00 2B 3B D0 98 47 02 46 ?? ?2 0? 0? ?? ?2 0? 0? 2B 60 00 2A 41 D0 A5 68 18 3F D3 19 4B F6 EB 61 CF F6 DA 61 D6 51 00 20 69 40 98 60 59 60 DD 60 A3 60 45 B1 E8 68 4B F6 EB 61 CF F6 DA 61 AB 60 18 44 41 40 69 60 9D 19 4B F6 EB 61 03 F1 18 04 CF F6 DA 61 1A 61 51 40 20 46 59 61 32 46 D7 23 93 21 2B 76 ?? ?? ?? ?? 20 46 03 B0 F0 BD 01 90 00 92 ?? ?? ?? ?? 00 9A 01 98 B1 E7 ?? ?? ?? ?? 02 46 C1 E7 06 4B 1D EE 70 2F 00 24 0C 21 7B 44 1B 68 20 46 D1 50 03 B0 F0 BD 14 46 E4 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "mallochook"
		size = 200
		refs = "0002 .LANCHOR0 001a __malloc_hook 0032 mallochook 008a memset 0096 mcheck_check_all 00b8 malloc 00c4 __libc_errno"
	strings:
		$1 = { 70 B5 ?? ?2 0? 0? ?? ?2 0? 0? 82 B0 05 46 E3 68 00 2B 3F D1 15 F1 1A 0F 43 D8 ?? ?2 0? 0? 63 69 ?? ?2 0? 0? 05 F1 19 00 33 60 00 2B 44 D0 98 47 03 46 ?? ?2 0? 0? ?? ?2 0? 0? 32 60 00 2B 3F D0 A1 68 4B F6 EB 62 CF F6 DA 62 1D 60 4A 40 A3 60 5A 60 00 22 D9 60 9A 60 41 B1 C8 68 4B F6 EB 62 CF F6 DA 62 8B 60 18 44 42 40 4A 60 5E 19 4B F6 EB 61 03 F1 18 04 CF F6 DA 61 59 40 1B 61 59 61 2A 46 D7 23 20 46 33 76 93 21 ?? ?? ?? ?? 20 46 02 B0 70 BD 01 91 ?? ?? ?? ?? 15 F1 1A 0F 01 99 BB D9 08 4B 1D EE 70 2F 00 24 0C 21 7B 44 1B 68 20 46 D1 50 02 B0 70 BD ?? ?? ?? ?? 03 46 B8 E7 1C 46 E4 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "freehook"
		size = 142
		refs = "0002 .LANCHOR0 0046 memset 0050 __free_hook 0062 freehook 006e mcheck_check_all 007e free"
	strings:
		$1 = { 70 B5 ?? ?2 0? 0? ?? ?2 0? 0? 04 46 0E 46 EB 68 6B BB E4 B1 2B 68 6B BB 45 F2 09 33 A4 F1 10 00 CD F6 67 03 54 F8 0C 1C 44 F8 14 3C 44 F8 04 3C FF F7 DC FE 00 23 20 46 44 F8 0C 3C 44 F8 10 3C 95 21 54 F8 18 2C ?? ?? ?? ?? 54 F8 08 4C AB 69 ?? ?2 0? 0? ?? ?2 0? 0? 20 46 2B 60 7B B1 31 46 98 47 ?? ?2 0? 0? ?? ?2 0? 0? 2B 60 70 BD ?? ?? ?? ?? CE E7 A4 F1 18 00 FF F7 88 FE CC E7 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 2B 60 70 BD }
	condition:
		$1
}

rule file_36_6_0 {
	meta:
		name = "reallochook"
		size = 392
		refs = "0012 .LANCHOR0 0050 __free_hook 0054 __malloc_hook 005a __memalign_hook 0060 __realloc_hook 009a freehook 009e mallochook 00a2 memalignhook 00a6 reallochook 011c mcheck_check_all 012e memset 0152 realloc 0184 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 0E 46 83 B0 93 46 04 46 00 29 00 F0 B2 80 ?? ?2 0? 0? ?? ?2 0? 0? EB 68 00 2B 7D D1 16 F1 1A 0F 00 F2 9E 80 00 2C 00 F0 98 80 2B 68 A4 F1 18 0A 54 F8 18 9C 00 2B 40 F0 82 80 A4 F1 10 00 54 F8 0C 1C FF F7 89 FE 4E 45 72 D3 A8 69 ?? ?2 0? 0? ?? ?2 0? 0? 69 69 ?? ?2 0? 0? 2A 69 ?? ?2 0? 0? EC 69 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CC F8 00 00 50 46 19 60 C8 F8 00 20 3C 60 00 2C 60 D0 8D E8 08 10 5A 46 06 F1 19 01 A0 47 9D E8 08 10 04 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CC F8 00 A0 18 60 C8 F8 00 10 3A 60 00 2C 5A D0 AB 68 4B F6 EB 62 CF F6 DA 62 26 60 5A 40 AC 60 62 60 00 22 E3 60 A2 60 43 B1 D9 68 4B F6 EB 62 CF F6 DA 62 9C 60 21 44 4A 40 5A 60 4B F6 EB 63 A1 19 B1 45 CF F6 DA 63 24 61 84 EA 03 03 4F F0 D7 02 63 61 0A 76 07 D3 04 F1 18 00 03 B0 BD E8 F0 8F ?? ?? ?? ?? 7E E7 09 F1 18 00 C9 EB 06 02 20 44 93 21 ?? ?? ?? ?? EE E7 A0 19 95 21 C6 EB 09 02 ?? ?? ?? ?? 85 E7 50 46 FF F7 DA FD 79 E7 06 F1 19 01 8D E8 08 10 ?? ?? ?? ?? 9D E8 08 10 04 46 9D E7 A1 46 A2 46 74 E7 07 4B 1D EE 70 2F 0C 21 00 20 7B 44 1B 68 D1 50 CF E7 11 46 FF F7 FA FE 30 46 CA E7 20 46 C8 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "mcheck_check_all"
		size = 48
		refs = "0002 .LANCHOR0"
	strings:
		$1 = { 38 B5 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 AC 68 EB 60 14 B9 0A E0 E4 68 44 B1 2B 68 00 2B FA D0 20 46 FF F7 9C FF E4 68 00 2C F6 D1 01 23 EB 60 38 BD }
	condition:
		$1
}

rule file_36_8_0 {
	meta:
		name = "mcheck"
		size = 186
		refs = "0000 __libc_malloc_initialized 0004 mabort 0014 .LANCHOR0 0048 mallochook 004c malloc 0050 memalignhook 005c freehook 0060 reallochook 0070 free 0074 __free_hook 007c __malloc_hook 0080 __memalign_hook 0084 __realloc_hook"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 4C ?? ?2 0? 0? 12 68 00 28 08 BF 18 46 ?? ?2 0? 0? 83 B0 00 2A 60 60 08 DD 20 68 00 28 14 BF 00 20 6F F0 00 00 03 B0 BD E8 F0 8C 25 68 00 20 00 2D F8 D1 28 46 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 01 90 01 98 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 28 46 DC F8 00 50 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CC F8 00 B0 A5 61 0D 68 C1 F8 00 A0 11 68 17 60 1A 68 21 61 01 21 65 61 E2 61 1E 60 21 60 BE E7 }
	condition:
		$1
}

rule file_36_9_0 {
	meta:
		name = "mcheck_pedantic"
		size = 22
		refs = "0002 mcheck 0008 .LANCHOR0"
	strings:
		$1 = { 08 B5 ?? ?? ?? ?? 28 B9 ?? ?2 0? 0? 01 22 ?? ?2 0? 0? DA 60 08 BD }
	condition:
		$1
}

rule file_36_10_0 {
	meta:
		name = "mprobe"
		size = 22
		refs = "0000 .LANCHOR0"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 0B B1 18 38 47 E5 4F F0 FF 30 70 47 }
	condition:
		$1
}

rule file_52_0_2 {
	meta:
		name = "__scalbf"
		size = 20
		refs = "0000 _LIB_VERSION 000c __ieee754_scalbf 0010 sysv_scalbf"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 0B B1 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_create_xid"
		size = 188
		refs = "0002 .LANCHOR0 0028 getpid 0040 __gettimeofday 0050 __srand48_r 005a lrand48_r 0090 __lll_lock_wait_private 00b2 __libc_do_syscall"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 83 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 7B BB ?? ?? ?? ?? 63 68 ?? ?2 0? 0? ?? ?2 0? 0? 83 42 06 46 0C D0 00 21 68 46 ?? ?? ?? ?? 01 98 00 9B 05 F1 08 01 58 40 70 40 ?? ?? ?? ?? 6E 60 69 46 17 48 ?? ?? ?? ?? 00 21 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 09 DC 00 98 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C8 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? E4 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "lrand48"
		size = 28
		refs = "0000 __libc_drand48_data 0010 __nrand48_r"
	strings:
		$1 = { ?? ?2 0? 0? 00 B5 ?? ?2 0? 0? 83 B0 01 46 01 AA ?? ?? ?? ?? 01 98 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_1316_0_0 {
	meta:
		name = "mrand48"
		size = 28
		refs = "0000 __libc_drand48_data 0010 __jrand48_r"
	strings:
		$1 = { ?? ?2 0? 0? 00 B5 ?? ?2 0? 0? 83 B0 01 46 01 AA ?? ?? ?? ?? 01 98 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__realpath_chk"
		size = 20
		refs = "0010 __chk_fail 000c __realpath"
	strings:
		$1 = { B2 F5 80 5F 08 B5 03 D3 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "psignal"
		size = 176
		refs = "000c .LC1 0018 _libc_intl_domainname 001e _sys_siglist 0032 __dcgettext 0036 .LC2 0046 __fxprintf 004e .LC0 0060 .LC3 007c __asprintf 0084 .LC5 0096 free 00a2 .LC4"
	strings:
		$1 = { 70 B5 0D 46 84 B0 06 46 09 B3 0B 78 ?? ?2 0? 0? ?? ?2 0? 0? DB B1 40 2E ?? ?2 0? 0? 20 D8 ?? ?2 0? 0? ?? ?2 0? 0? 53 F8 26 10 C9 B1 ?? ?2 0? 0? 05 22 ?? ?? ?? ?? ?? ?2 0? 0? 2A 46 23 46 ?? ?2 0? 0? 00 90 00 20 ?? ?? ?? ?? 04 B0 70 BD ?? ?2 0? 0? 40 2E ?? ?2 0? 0? ?? ?2 0? 0? 25 46 DE D9 ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 96 2A 46 23 46 01 46 03 A8 ?? ?? ?? ?? 00 28 0C DB ?? ?2 0? 0? 03 9A ?? ?2 0? 0? 00 20 ?? ?? ?? ?? 03 98 ?? ?? ?? ?? 04 B0 70 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? BF E7 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__lcong48_r"
		size = 54
	strings:
		$1 = { F0 B4 00 22 04 68 00 25 4F F0 01 0C 0C 60 84 88 8C 80 07 89 43 89 C4 88 86 89 1D 43 14 43 3F 04 10 46 2B 46 44 EA 07 02 8E 81 A1 F8 0E C0 C1 E9 04 23 F0 BC 70 47 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "grantpt"
		size = 452
		refs = "0028 realloc 003e __ptsname_internal 004e memchr 0058 __getuid 0066 .LANCHOR0 0080 __chown 00a0 __chmod 00b0 free 00c4 malloc 00f0 __libc_fcntl 0144 __sysconf 0160 .LC0 017a __getgrnam_r 018e __getgid 01ac __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 AD F5 84 5D 83 B0 4F F4 80 54 02 AF 07 F1 80 06 81 46 35 46 07 F1 18 08 5C B9 80 24 B5 42 28 46 21 46 4C D0 ?? ?? ?? ?? 00 28 4D D0 05 46 00 2C F3 D0 29 46 22 46 43 46 48 46 ?? ?? ?? ?? 22 46 03 46 28 46 19 46 00 2B 68 D1 ?? ?? ?? ?? 64 00 00 28 E3 D0 ?? ?? ?? ?? D8 F8 18 30 83 42 81 46 51 D1 ?? ?2 0? 0? ?? ?2 0? 0? 22 68 50 1C 66 D0 D8 F8 1C 30 9A 42 05 D0 49 46 28 46 ?? ?? ?? ?? 00 28 48 DB D8 F8 10 30 C3 F3 08 03 B3 F5 C8 7F 08 BF 00 24 05 D0 28 46 4F F4 C8 71 ?? ?? ?? ?? C4 17 B5 42 08 BF 20 46 03 D0 28 46 ?? ?? ?? ?? 20 46 07 F5 84 57 04 37 BD 46 BD E8 F0 83 20 46 ?? ?? ?? ?? 00 28 B1 D1 37 4B 1D EE 70 4F 0C 22 7B 44 1B 68 E2 50 B5 42 02 D0 28 46 ?? ?? ?? ?? 32 4B 48 46 01 21 7B 44 1B 68 E5 58 ?? ?? ?? ?? 43 1C 1D D0 19 2D 4C D0 2D 4B 4F F0 FF 30 7B 44 1B 68 E5 50 D5 E7 28 46 49 46 D8 F8 1C 20 ?? ?? ?? ?? 00 28 A5 DA 4F F0 FF 34 C2 E7 25 4A 1D EE 70 4F 19 2B 08 BF 16 23 7A 44 12 68 A3 50 D2 E7 21 4B 7B 44 1B 68 E3 58 09 2B DB D1 B9 E7 45 20 ?? ?? ?? ?? 07 F1 20 03 A3 F1 18 01 07 F1 04 0E B0 F1 FF 3F 14 BF 03 46 4F F4 80 63 ?? ?2 0? 0? 03 F1 0E 02 ?? ?2 0? 0? 22 F0 07 02 AD EB 02 0D 02 AA CD F8 00 E0 ?? ?? ?? ?? 7B 68 8B B1 9B 68 1A 46 23 60 51 1C 7F F4 73 AF ?? ?? ?? ?? 02 46 6E E7 0A 4B 16 22 4F F0 FF 30 7B 44 1B 68 E2 50 87 E7 22 68 EE E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__getpwuid_r"
		size = 348
		refs = "0004 __nss_not_use_nscd_passwd 002a .LANCHOR0 005e _dl_mcount_wrapper_check 0078 .LC0 00a6 __nss_next2 00ce __nss_database_custom 00e8 __nscd_getpwuid_r 0122 __nss_passwd_lookup2 014c __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 9A 46 87 B0 80 46 23 68 0F 46 91 46 00 2B 57 DD 01 33 64 2B D2 BF 23 60 00 23 23 60 51 DC ?? ?2 0? 0? ?? ?2 0? 0? 22 78 00 2A 6E D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 5A D1 DF F8 00 B1 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 C8 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 36 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 1E D0 10 9F 3C 60 1D D9 24 4B 7B 44 1B 68 F0 58 22 28 39 D0 07 B0 BD E8 F0 8F AD D1 ?? ?2 0? 0? ?? ?2 0? 0? 1B 7A 00 2B A6 D1 10 9A 40 46 39 46 53 46 00 92 4A 46 ?? ?? ?? ?? 00 28 EA DA 9B E7 10 9A 17 60 16 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 D1 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 88 E7 02 35 C3 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "__getpwnam_r"
		size = 348
		refs = "0004 __nss_not_use_nscd_passwd 002a .LANCHOR0 005e _dl_mcount_wrapper_check 0078 .LC0 00a6 __nss_next2 00ce __nss_database_custom 00e8 __nscd_getpwnam_r 0122 __nss_passwd_lookup2 014c __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 9A 46 87 B0 80 46 23 68 0F 46 91 46 00 2B 57 DD 01 33 64 2B D2 BF 23 60 00 23 23 60 51 DC ?? ?2 0? 0? ?? ?2 0? 0? 22 78 00 2A 6E D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 5A D1 DF F8 00 B1 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 C8 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 36 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 1E D0 10 9F 3C 60 1D D9 24 4B 7B 44 1B 68 F0 58 22 28 39 D0 07 B0 BD E8 F0 8F AD D1 ?? ?2 0? 0? ?? ?2 0? 0? 1B 7A 00 2B A6 D1 10 9A 40 46 39 46 53 46 00 92 4A 46 ?? ?? ?? ?? 00 28 EA DA 9B E7 10 9A 17 60 16 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 D1 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 88 E7 02 35 C3 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__futimes"
		size = 388
		refs = "0026 .LANCHOR0 0052 __libc_do_syscall 0088 _itoa_word 008c selffd.9454 0164 __libc_errno"
	strings:
		$1 = { F0 B5 0C 46 8D B0 06 46 00 29 00 F0 83 80 44 F2 3F 23 4A 68 C0 F2 0F 03 9A 42 21 D8 C9 68 99 42 1E D8 4F F4 7A 73 ?? ?2 0? 0? ?? ?2 0? 0? 27 68 03 FB 02 F2 28 68 03 FB 01 F1 A3 68 01 97 03 93 02 92 04 91 C0 B9 01 AA 00 21 30 46 0B 46 4F F4 AE 7C ?? ?? ?? ?? 10 F5 80 5F 4B D8 0D B0 F0 BD 40 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 01 23 2B 60 00 25 0D F1 2E 01 2B 46 30 46 0A 22 8D F8 2E 50 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 0D 1C 05 46 07 CB 1B 88 45 F8 0E 0C A5 F1 0E 00 45 F8 0A 1C 21 46 25 F8 02 3C 45 F8 06 2C ?? ?? ?? ?? 10 F5 80 5F CE D9 2A 49 1D EE 70 3F 29 4A 40 42 79 44 09 68 58 50 7A 44 12 68 9A 58 14 2A 05 D0 37 DC 02 2A 23 D0 0D 2A 15 D1 A4 B1 22 4A 26 21 4F F0 FF 30 7A 44 12 68 99 50 B3 E7 1F 4A 1D EE 70 1F 1F 4B 40 42 7A 44 12 68 88 50 7B 44 1B 68 CB 58 26 2B B2 D0 4F F0 FF 30 A3 E7 ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 2B 68 00 2B 91 D0 A8 E7 30 46 01 21 00 22 4F F0 37 0C ?? ?? ?? ?? 10 F5 80 5F 0C D8 10 4A 26 21 4F F0 FF 30 7A 44 12 68 99 50 88 E7 24 2A CA D0 28 2A DD D1 C7 E7 0A 4A 41 42 4F F0 FF 30 7A 44 12 68 99 50 7B E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "wmemset"
		size = 66
	strings:
		$1 = { 03 2A 03 46 10 B4 11 D9 14 46 04 3C 19 60 03 2C 59 60 99 60 03 F1 10 03 43 F8 04 1C F5 D8 13 1F 02 F0 03 02 9B 08 01 33 00 EB 03 13 32 B1 01 2A 19 60 03 D0 03 2A 59 60 08 BF 99 60 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__fdatasync_nocancel"
		size = 20
		refs = "0010 __syscall_error"
		altNames = "__accept_nocancel __close_nocancel __connect_nocancel __creat_nocancel __epoll_wait_nocancel __fsync_nocancel __msgsnd_nocancel __msync_nocancel __nanosleep_nocancel __open_by_handle_at_nocancel __open_nocancel __poll_nocancel __read_nocancel __recv_nocancel __recvmsg_nocancel __send_nocancel __sendmsg_nocancel __tee_nocancel __vmsplice_nocancel __write_nocancel"
	strings:
		$1 = { 80 B4 1B 4F 00 DF 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "fdatasync"
		size = 80
		refs = "0026 __libc_enable_asynccancel 0038 __libc_disable_asynccancel 0020 __syscall_error"
		altNames = "__libc_close __libc_fsync"
	strings:
		$1 = { DF F8 50 C0 FC 44 DC F8 00 C0 9C F0 00 0F 80 B4 08 D1 0F 4F 00 DF 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? 03 B5 ?? ?? ?? ?? 84 46 5D F8 08 0B 07 4F 00 DF 07 46 60 46 ?? ?? ?? ?? 38 46 5D F8 04 EB 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_dl_add_to_namespace_list"
		size = 134
		refs = "0002 __pthread_mutex_lock 0010 _dl_load_write_lock 001e _dl_ns 003e _dl_load_adds 0052 __pthread_mutex_unlock"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? ?? ?2 0? 0? 05 46 0F 46 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 4C 23 ?? ?2 0? 0? ?? ?2 0? 0? 03 FB 07 F3 E2 58 0A B9 27 E0 1A 46 D3 68 00 2B FB D1 2A 61 D5 60 4C 21 ?? ?2 0? 0? ?? ?2 0? 0? 05 F5 14 70 01 FB 07 41 D6 E9 00 23 ?? ?2 0? 0? 54 1C ?? ?2 0? 0? 43 F1 00 05 C0 E9 00 23 C6 E9 00 45 4B 68 01 33 4B 60 4F B1 ?? ?2 0? 0? ?? ?2 0? 0? BD E8 F8 40 ?? ?? ?? ?? E5 50 DB E7 F8 BD }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_dl_new_object"
		size = 436
		refs = "0010 strlen 0022 calloc 0044 memcpy 0048 _dl_debug_mask 006a _dl_ns 00ea __getcwd 010a realloc 0124 free 015a strchr 0176 mempcpy 019a malloc 01b0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 81 46 83 B0 08 46 0E 46 90 46 1D 46 ?? ?? ?? ?? 01 21 0D 9F 03 46 00 F2 69 20 03 EB 01 0A ?? ?? ?? ?? 04 46 00 28 7F D0 04 F5 17 73 60 61 31 46 52 46 00 F5 16 70 E3 61 C4 F8 64 01 04 F5 1A 70 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 94 F8 94 21 01 21 C4 F8 04 90 1B 68 68 F3 01 02 84 F8 94 21 DA 05 4F F0 4C 02 ?? ?2 0? 0? C4 F8 64 12 02 FB 07 F2 ?? ?2 0? 0? 58 BF C4 F8 FC 11 04 F5 DC 71 C4 F8 6C 51 A7 61 C4 F8 CC 11 9B 58 C4 F8 5C 02 04 20 C4 F8 C8 01 23 B1 03 F5 AE 72 01 23 C4 F8 B8 21 0D B9 51 E0 15 46 D5 F8 6C 21 00 2A FA D1 00 2B 3D D1 05 F5 AE 75 CD 50 04 F5 AE 73 C4 F8 D0 31 99 F8 00 50 7D B3 48 46 ?? ?? ?? ?? 2F 2D 00 F1 01 02 80 46 01 92 5C D0 DF F8 D0 A0 4F F0 00 0B 01 9D 0B E0 ?? ?? ?? ?? BB 46 1D EE 70 2F 78 BB 51 46 79 44 09 68 52 58 22 2A 48 D1 05 F1 80 06 58 46 31 46 ?? ?? ?? ?? 05 F1 7F 01 C8 EB 01 01 35 46 07 46 00 28 E5 D1 58 46 4F F0 FF 37 ?? ?? ?? ?? C4 F8 A8 71 20 46 03 B0 BD E8 F0 8F D4 F8 B8 21 05 F5 AE 75 AA 42 BE D0 0C 9B 1B 07 31 D5 00 23 C4 F8 BC 21 B6 E7 25 46 00 2B B1 D0 EE E7 38 46 00 21 ?? ?? ?? ?? 10 F8 01 2C 03 46 2F 2A 08 BF 00 46 02 D0 58 1C 2F 22 1A 70 49 46 01 9A ?? ?? ?? ?? 02 46 01 38 12 F8 01 1C 2F 29 F9 D1 87 42 14 BF 03 46 13 46 00 22 1A 70 C9 E7 BB 46 C2 E7 10 46 ?? ?? ?? ?? 07 46 00 2F E6 D1 4F F0 FF 37 BE E7 04 23 86 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__atfct_seterrno_2"
		size = 348
		refs = "003a __fxstat64 006e .LC0 007a __xstat64 009e strchr 00b0 __lxstat64 0150 __libc_errno"
	strings:
		$1 = { F0 B5 9D B0 15 1C 04 46 22 9F 18 BF 01 25 3E 1C 18 BF 01 26 55 EA 06 00 03 D0 14 2C 09 D0 02 2C 38 D0 1D EE 70 5F 4A 4B 7B 44 1B 68 EC 50 1D B0 F0 BD 6D B1 03 20 02 AA 01 93 ?? ?? ?? ?? 01 9B 00 28 F4 D1 06 9A 02 F4 70 42 B2 F5 80 4F 63 D0 00 2E E6 D0 19 46 02 AA 03 20 ?? ?? ?? ?? 00 28 E5 D1 06 9B 03 F4 70 43 B3 F5 80 4F D9 D1 ?? ?2 0? 0? 02 AA ?? ?2 0? 0? 03 20 ?? ?? ?? ?? 28 B9 06 9B 03 F4 70 43 B3 F5 80 4F CA D0 26 24 1D EE 70 5F C8 E7 CD B1 02 F1 0E 00 2F 21 01 92 ?? ?? ?? ?? 01 9A 11 46 00 22 03 46 03 20 1A 70 02 AA ?? ?? ?? ?? 42 1C 41 D0 38 B9 06 9B 03 F4 70 43 B3 F5 20 4F 18 BF 09 24 AB D1 1D EE 70 5F 00 2E A9 D0 2F 21 07 F1 0E 00 ?? ?? ?? ?? 00 22 39 46 03 46 03 20 1A 70 02 AA ?? ?? ?? ?? 43 1C 0A D0 00 28 98 D1 06 9C 04 F4 70 44 B4 F5 20 4F 0C BF 02 24 09 24 8F E7 13 4B 7B 44 1B 68 EC 58 02 2C 14 BF 02 24 09 24 86 E7 ?? ?2 0? 0? 02 AA ?? ?2 0? 0? 03 20 ?? ?? ?? ?? 01 9B 00 28 AE D1 06 9A 02 F4 70 42 B2 F5 80 4F A8 D1 89 E7 06 4B 1D EE 70 5F 7B 44 1B 68 EB 58 02 2B C0 D1 09 24 6A E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "renameat"
		size = 320
		refs = "0004 __have_atfcts 0022 __libc_do_syscall 0048 strlen 0054 procfd.10590 0072 __snprintf 00d0 __atfct_seterrno_2 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? 82 B0 ?? ?2 0? 0? 81 46 02 AF 88 46 26 68 92 46 1D 46 00 2E 0C DB 40 F2 49 1C ?? ?? ?? ?? 10 F5 80 5F 5D D8 BD 46 BD E8 F0 87 4F F0 FF 33 23 60 19 F1 64 0F 4D D0 98 F8 00 30 2F 2B 49 D0 40 46 ?? ?? ?? ?? 00 28 65 D0 00 F1 2E 03 ?? ?2 0? 0? 23 F0 07 03 00 F1 20 01 AD EB 03 0D ?? ?2 0? 0? 02 AC 4B 46 CD F8 00 80 20 46 ?? ?? ?? ?? 1A F1 64 0F A0 46 32 D0 2B 78 2F 2B 2F D0 28 46 ?? ?? ?? ?? 00 28 3C D0 00 F1 2E 03 ?? ?2 0? 0? 23 F0 07 03 00 F1 20 01 AD EB 03 0D ?? ?2 0? 0? 02 AE 53 46 00 95 30 46 ?? ?? ?? ?? 35 46 40 46 29 46 4F F0 26 0C ?? ?? ?? ?? 10 F5 80 5F B2 D9 40 42 00 94 51 46 32 46 4B 46 ?? ?? ?? ?? 4F F0 FF 30 A8 E7 1A F1 64 0F 4F F0 00 04 CC D1 00 26 E5 E7 11 4A 1D EE 70 1F 11 4B 40 42 7A 44 12 68 88 50 7B 44 1B 68 CB 58 26 2B 97 D0 4F F0 FF 30 91 E7 0B 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 D1 50 87 E7 07 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 D1 50 7D E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__getdate_r"
		size = 984
		refs = "0008 .LC0 0014 getenv 0032 __xstat64 0054 __access 0060 .LC1 006a _IO_new_fopen 00a6 strlen 0100 memcpy 0150 strptime 016e __getline 017c free 0190 _IO_new_fclose 01be time 01ca __localtime_r 026a __aeabi_idivmod 0292 mktime 02c8 __libc_alloca_cutoff 02d6 malloc 02f8 __libc_tsd_CTYPE_B 0320 memset"
	strings:
		$1 = { 2D E9 F0 4F 06 46 B7 B0 ?? ?2 0? 0? ?? ?2 0? 0? 00 AF 0D 46 ?? ?? ?? ?? 04 46 08 B1 03 78 23 B9 01 20 DC 37 BD 46 BD E8 F0 8F 03 20 21 46 07 F1 70 02 ?? ?? ?? ?? 00 28 B8 BF 03 20 F1 DB D7 F8 80 30 03 F4 70 43 B3 F5 00 4F 18 BF 04 20 E8 D1 20 46 04 21 ?? ?? ?? ?? 00 28 01 DA 02 20 E0 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 80 46 00 28 F3 D0 02 68 1D EE 70 1F 9F 4B 42 F4 00 42 02 60 7B 44 1B 68 32 78 51 F8 03 90 39 F8 12 30 98 04 07 D5 73 1C 1E 46 13 F8 01 2B 39 F8 12 20 91 04 F8 D4 30 46 ?? ?? ?? ?? 00 28 00 F0 83 80 44 1E 33 5D 39 F8 13 30 03 F4 00 53 9B B2 33 B9 6B E0 F2 5C 39 F8 12 20 92 04 03 D5 1C 46 63 1E 00 2C F6 D1 A0 42 5F D9 04 F1 01 09 B9 F5 80 5F 00 F2 F1 80 09 F1 0E 03 31 46 23 F0 07 03 22 46 AD EB 03 0D 6B 46 4F EA D3 09 4F EA C9 06 30 46 ?? ?? ?? ?? 00 23 7B 60 04 F8 39 30 00 22 4F F0 00 44 93 46 91 46 4F F0 FF 3A FA 60 3A 61 21 E0 FB 68 19 46 98 5C 0A 28 30 46 08 BF 03 F8 02 90 2A 46 08 BF F9 68 AC 61 EC 60 2C 61 6C 61 6C 60 2C 60 AC 60 C5 F8 20 A0 C5 F8 24 90 C5 F8 28 90 ?? ?? ?? ?? 83 46 08 B1 02 78 72 B1 D8 F8 00 20 D0 06 0A D4 42 46 07 F1 0C 00 07 F1 10 01 ?? ?? ?? ?? 00 28 00 F1 FF 32 D2 DA 78 68 ?? ?? ?? ?? F8 68 ?? ?? ?? ?? D8 F8 00 20 40 46 91 06 06 D5 ?? ?? ?? ?? 05 20 44 E7 00 23 7B 60 B6 E7 ?? ?? ?? ?? BB F1 00 0F 04 D0 9B F8 00 80 B8 F1 00 0F 03 D0 07 20 35 E7 78 60 A8 E7 07 F1 14 00 ?? ?? ?? ?? 07 F1 14 00 07 F1 18 01 ?? ?? ?? ?? D5 F8 18 90 B9 F1 06 0F 64 D8 6E 69 B6 F1 00 4F 64 D0 2C 69 43 46 0B 2C 04 D8 EA 68 B2 F1 00 4F 00 F0 85 80 A9 68 68 68 B1 F1 00 4F 2A 68 5B D0 B0 F1 00 4F 04 BF 00 20 68 60 B2 F1 00 4F 04 BF 00 22 2A 60 17 29 03 D8 B4 F1 00 4F 00 F0 98 80 B6 F1 00 4F 04 BF FA 6A 6A 61 B4 F1 00 4F 04 BF BA 6A 2A 61 6B BB 2B 69 6E 69 0B 2B EC 68 23 D8 01 21 40 F6 D5 22 01 FA 03 F3 1A 40 F2 B9 13 F4 A5 6F 40 F0 AC 80 9A 07 16 D5 00 2C 14 DD 06 F2 6C 76 B3 07 40 F0 A8 80 30 46 64 21 ?? ?? ?? ?? 41 BB 30 46 4F F4 C8 71 ?? ?? ?? ?? 00 29 0C BF 1D 21 1C 21 8C 42 04 DD 08 20 CB E6 01 3C 1E 2C FA D8 28 46 ?? ?? ?? ?? B0 F1 FF 3F 0C BF 08 20 00 20 BF E6 43 46 6E 69 2C 69 9C E7 2C 69 B4 F1 00 4F 62 D0 43 46 96 E7 B0 F1 00 4F 7E D0 00 21 A9 60 9D E7 1D 21 DD E7 48 46 ?? ?? ?? ?? 82 46 00 28 7F F4 08 AF 48 46 ?? ?? ?? ?? 78 60 38 B1 31 46 22 46 ?? ?? ?? ?? 7E 68 06 F8 04 A0 0E E7 40 46 ?? ?? ?? ?? 06 20 94 E6 ?? ?? ?? ?? B6 F1 00 4F 01 BF BA 6A FB 6A C2 EB 04 02 03 EB D2 76 08 BF 6E 61 B9 F1 00 4F 35 D0 00 21 2C 22 07 F1 44 00 ?? ?? ?? ?? 07 F1 44 00 01 23 BE 65 7C 65 3B 65 ?? ?? ?? ?? FB 6D 07 21 C3 EB 09 00 08 44 ?? ?? ?? ?? 6E 69 2C 69 01 31 E9 60 01 23 51 E7 EA 68 B2 F1 00 4F 7F F4 63 AF AA 69 B2 F1 00 4F 7F F4 5E AF 38 6A 01 23 BA 6A 09 1A 78 6A 14 46 00 EB D1 70 2A 61 E8 60 52 E7 EB 68 B3 F1 00 4F 03 D0 43 46 36 E7 01 21 DF E7 FA 6A 07 21 BB 6A 38 6B 16 46 6A 61 1C 46 C0 EB 09 00 2B 61 08 44 ?? ?? ?? ?? 7A 6A 01 23 11 44 E9 60 1B E7 01 3C 1D 2C 3F F6 69 AF 6C E7 1C 21 63 E7 B2 F1 00 4F 7F F4 7D AF 39 6A F8 69 BA 69 B1 F1 00 4F A9 60 68 60 2A 60 3F F4 73 AF 12 E7 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "getdate"
		size = 44
		refs = "0000 .LANCHOR0 000a __getdate_r 001c getdate_err"
	strings:
		$1 = { ?? ?2 0? 0? 08 B5 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 08 B9 18 46 08 BD ?? ?2 0? 0? 00 23 ?? ?2 0? 0? 10 60 18 46 08 BD }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__nss_ethers_lookup2"
		size = 76
		refs = "0004 __nss_ethers_database 002c .LC0 0038 __nss_database_lookup 0028 __nss_lookup"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 89 46 06 46 90 46 21 68 1F 46 0D 46 41 B1 35 60 30 46 49 46 42 46 3B 46 BD E8 F0 47 ?? ?? ?? ?? ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 23 46 ?? ?? ?? ?? 00 28 01 DB 25 68 EA E7 4F F0 FF 30 BD E8 F0 87 }
	condition:
		$1
}

rule file_883_0_0 {
	meta:
		name = "__nss_aliases_lookup2"
		size = 76
		refs = "0004 __nss_aliases_database 002c .LC0 0038 __nss_database_lookup 0028 __nss_lookup"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 89 46 06 46 90 46 21 68 1F 46 0D 46 41 B1 35 60 30 46 49 46 42 46 3B 46 BD E8 F0 47 ?? ?? ?? ?? ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 23 46 ?? ?? ?? ?? 00 28 01 DB 25 68 EA E7 4F F0 FF 30 BD E8 F0 87 }
	condition:
		$1
}

rule file_831_0_0 {
	meta:
		name = "__nss_netgroup_lookup2"
		size = 76
		refs = "0004 __nss_netgroup_database 002c .LC0 0038 __nss_database_lookup 0028 __nss_lookup"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 89 46 06 46 90 46 21 68 1F 46 0D 46 41 B1 35 60 30 46 49 46 42 46 3B 46 BD E8 F0 47 ?? ?? ?? ?? ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 23 46 ?? ?? ?? ?? 00 28 01 DB 25 68 EA E7 4F F0 FF 30 BD E8 F0 87 }
	condition:
		$1
}

rule file_665_0_0 {
	meta:
		name = "__nss_protocols_lookup2"
		size = 76
		refs = "0004 __nss_protocols_database 002c .LC0 0038 __nss_database_lookup 0028 __nss_lookup"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 89 46 06 46 90 46 21 68 1F 46 0D 46 41 B1 35 60 30 46 49 46 42 46 3B 46 BD E8 F0 47 ?? ?? ?? ?? ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 23 46 ?? ?? ?? ?? 00 28 01 DB 25 68 EA E7 4F F0 FF 30 BD E8 F0 87 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__nss_rpc_lookup2"
		size = 76
		refs = "0004 __nss_rpc_database 002c .LC0 0038 __nss_database_lookup 0028 __nss_lookup"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 89 46 06 46 90 46 21 68 1F 46 0D 46 41 B1 35 60 30 46 49 46 42 46 3B 46 BD E8 F0 47 ?? ?? ?? ?? ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 23 46 ?? ?? ?? ?? 00 28 01 DB 25 68 EA E7 4F F0 FF 30 BD E8 F0 87 }
	condition:
		$1
}

rule file_661_0_0 {
	meta:
		name = "__nss_services_lookup2"
		size = 76
		refs = "0004 __nss_services_database 002c .LC0 0038 __nss_database_lookup 0028 __nss_lookup"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 89 46 06 46 90 46 21 68 1F 46 0D 46 41 B1 35 60 30 46 49 46 42 46 3B 46 BD E8 F0 47 ?? ?? ?? ?? ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 23 46 ?? ?? ?? ?? 00 28 01 DB 25 68 EA E7 4F F0 FF 30 BD E8 F0 87 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__setstate_r"
		size = 164
		refs = "0038 .LANCHOR0 0068 __aeabi_idivmod 00a0 __libc_errno"
	strings:
		$1 = { 00 29 18 BF 00 28 F8 B5 0C 46 00 F1 04 05 3D D0 CB 68 8A 68 9B BB 42 F8 04 3C 46 F2 67 66 02 68 C6 F2 66 66 86 FB 02 31 D3 17 C3 EB 61 03 03 EB 83 03 D3 1A 04 2B 29 D8 ?? ?2 0? 0? E3 60 ?? ?2 0? 0? 02 EB 83 01 52 F8 23 20 4F 69 62 61 27 61 7B B1 03 68 39 46 86 FB 03 06 DB 17 C3 EB 66 06 B0 18 05 EB 86 06 66 60 ?? ?? ?? ?? 05 EB 81 01 21 60 05 EB 87 07 A5 60 A7 61 00 20 F8 BD 49 68 89 1A 89 10 01 EB 81 01 0B 44 C4 E7 04 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 F8 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__random_r"
		size = 132
		refs = "0080 __libc_errno"
	strings:
		$1 = { 00 29 18 BF 00 28 03 46 F0 B4 2E D0 C0 68 9A 68 D8 B1 93 E8 30 00 9E 69 20 46 27 68 2C 68 3C 44 40 F8 04 4B 86 42 4F EA 54 04 98 BF 10 46 0C 60 98 BF 2A 1D 04 D8 18 60 00 20 5A 60 F0 BC 70 47 04 35 AE 42 88 BF 2A 46 F5 E7 14 68 44 F6 6D 63 C4 F2 C6 13 03 FB 04 F3 F0 BC 03 F5 40 53 39 33 23 F0 00 43 13 60 0B 60 70 47 05 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 DE E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_2_0 {
	meta:
		name = "__srandom_r"
		size = 174
		refs = "0098 __random_r"
	strings:
		$1 = { 2D E9 F0 47 0F 46 82 B0 00 29 4D D0 CA 68 04 2A 4A D8 D1 F8 08 90 00 28 14 BF 03 46 01 23 C9 F8 00 30 00 2A 3C D0 0C 69 01 2C 27 DD 40 F6 5F 3C 4F F2 1D 30 4F F2 EC 41 C8 F2 4E 3C C0 F2 01 00 CF F6 FF 71 4E 46 01 22 44 F2 A7 18 8C FB 03 A5 4F EA E3 7A 01 32 1D 44 CA EB 25 45 00 FB 15 33 01 FB 05 F5 08 FB 03 53 00 2B BC BF 03 F1 00 43 03 F1 FF 33 A2 42 46 F8 04 3F E7 D1 04 EB 84 04 7B 69 C7 F8 04 90 64 00 01 3C 09 EB 83 03 3B 60 06 D4 01 3C 38 46 01 A9 ?? ?? ?? ?? 63 1C F8 D1 00 20 02 B0 BD E8 F0 87 4F F0 FF 30 F9 E7 }
	condition:
		$1
}

rule file_57_3_0 {
	meta:
		name = "__initstate_r"
		size = 180
		refs = "0034 __srandom_r 0046 .LANCHOR0 00b0 __libc_errno"
	strings:
		$1 = { F8 B5 1C 46 0F 46 00 2B 47 D0 9B 68 23 B1 E1 68 00 29 36 D1 43 F8 04 1C 7F 2A 10 D8 1F 2A 37 D8 07 2A 3A D9 00 25 3B 1D E5 60 21 46 65 61 25 61 A3 61 A3 60 ?? ?? ?? ?? 28 46 3D 60 F8 BD FF 2A 94 BF 03 25 04 25 ?? ?2 0? 0? 3E 1D ?? ?2 0? 0? E5 60 03 EB 85 0E A6 60 53 F8 25 20 21 46 DE F8 14 30 62 61 23 61 06 EB 83 03 A3 61 ?? ?? ?? ?? 63 68 00 20 9E 1B B6 10 06 EB 86 06 35 44 3D 60 F8 BD 65 68 ED 1A AD 10 05 EB 85 05 29 44 C1 E7 3F 2A 8C BF 02 25 01 25 D5 E7 05 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 F8 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "fputwc"
		size = 300
		refs = "004a _IO_fwide 00bc __libc_do_syscall 00c6 __woverflow 00ce __lll_lock_wait_private 0128 _Unwind_Resume"
	strings:
		$1 = { 0B 68 70 B5 0C 46 19 04 05 46 1C D4 A0 6C 1D EE 70 6F A6 F5 98 66 82 68 B2 42 11 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 00 2A 49 D1 A2 6C 10 46 96 60 42 68 01 32 42 60 20 46 01 21 ?? ?? ?? ?? 00 28 27 DB E3 6D 00 2B 34 D0 1A 69 59 69 8A 42 3E BF 11 1D 19 61 15 60 2C D2 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 04 DC 28 46 70 BD 4F F0 FF 35 DF E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? ED E7 29 46 20 46 ?? ?? ?? ?? 05 46 CC E7 ?? ?? ?? ?? B2 E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__towctrans_l"
		size = 60
		altNames = "__towctrans"
	strings:
		$1 = { 10 B4 C1 B1 0B 68 4A 68 20 FA 03 F3 93 42 12 D2 05 33 51 F8 23 30 73 B1 8C 68 CA 68 20 FA 04 F4 22 40 03 EB 82 03 CB 58 2B B1 0A 69 02 40 03 EB 82 03 CB 58 18 44 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "wcscmp"
		size = 28
	strings:
		$1 = { 51 F8 04 3B 50 F8 04 2B 33 B1 9A 42 F8 D0 34 BF 4F F0 FF 30 01 20 70 47 10 46 70 47 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__iswalnum_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 1B 6D 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F0 08 00 80 B2 70 47 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__iswalpha_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 DB 6A 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F4 80 60 80 B2 70 47 }
	condition:
		$1
}

rule file_61_2_0 {
	meta:
		name = "__iswblank_l"
		size = 112
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 5B 6C 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F0 01 00 70 47 }
	condition:
		$1
}

rule file_61_3_0 {
	meta:
		name = "__iswcntrl_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 9B 6C 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F0 02 00 80 B2 70 47 }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__iswdigit_l"
		size = 112
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 1B 6B 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 30 38 5D F8 04 4B 09 28 8C BF 00 20 01 20 70 47 }
	condition:
		$1
}

rule file_61_5_0 {
	meta:
		name = "__iswlower_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 9B 6A 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F4 00 70 80 B2 70 47 }
	condition:
		$1
}

rule file_61_6_0 {
	meta:
		name = "__iswgraph_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 1B 6C 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F4 00 40 80 B2 70 47 }
	condition:
		$1
}

rule file_61_7_0 {
	meta:
		name = "__iswprint_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 DB 6B 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F4 80 40 80 B2 70 47 }
	condition:
		$1
}

rule file_61_8_0 {
	meta:
		name = "__iswpunct_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 DB 6C 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F0 04 00 80 B2 70 47 }
	condition:
		$1
}

rule file_61_9_0 {
	meta:
		name = "__iswspace_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 9B 6B 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F4 00 50 80 B2 70 47 }
	condition:
		$1
}

rule file_61_10_0 {
	meta:
		name = "__iswupper_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 5B 6A 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F4 80 70 80 B2 70 47 }
	condition:
		$1
}

rule file_61_11_0 {
	meta:
		name = "__iswxdigit_l"
		size = 114
	strings:
		$1 = { 30 F0 7F 03 10 B4 2B D0 0B 68 9A 6E 03 EB 82 03 5B 6B 1A 68 59 68 20 FA 02 F2 8A 42 28 BF 00 20 17 D2 05 32 53 F8 22 20 B2 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 6A B1 19 69 00 F0 1F 04 01 EA 50 10 02 EB 80 02 98 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 10 46 5D F8 04 4B 70 47 4B 6B 5D F8 04 4B 33 F8 10 00 00 F4 80 50 80 B2 70 47 }
	condition:
		$1
}

rule file_61_12_0 {
	meta:
		name = "__towlower_l"
		size = 68
	strings:
		$1 = { 0B 68 10 B4 DA 6E 03 EB 82 03 9B 6A 1A 68 59 68 20 FA 02 F2 8A 42 12 D2 05 32 53 F8 22 20 72 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 2A B1 19 69 01 40 02 EB 81 02 9B 58 18 44 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_61_13_0 {
	meta:
		name = "__towupper_l"
		size = 68
	strings:
		$1 = { 0B 68 10 B4 DA 6E 03 EB 82 03 5B 6A 1A 68 59 68 20 FA 02 F2 8A 42 12 D2 05 32 53 F8 22 20 72 B1 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 2A B1 19 69 01 40 02 EB 81 02 9B 58 18 44 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__strnlen"
		size = 134
	strings:
		$1 = { 30 B4 00 29 32 D0 41 18 28 BF 4F F0 FF 31 83 07 35 D0 03 78 00 2B 34 D0 43 1C 01 E0 14 78 EC B1 13 F0 03 0F 1A 46 03 F1 01 03 F7 D1 91 42 15 D9 13 1F 53 F8 04 5F 14 1D A5 F1 01 35 15 F0 80 3F 08 D0 14 F8 04 5C 4D B1 5D 78 95 B1 9D 78 95 B1 DD 78 95 B1 A1 42 22 46 EB D8 0A 46 8A 42 94 BF C0 EB 02 00 C0 EB 01 00 30 BC 70 47 08 46 30 BC 70 47 01 32 F2 E7 02 32 F0 E7 03 32 EE E7 02 46 D4 E7 02 46 EA E7 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__posix_spawnp"
		size = 24
		refs = "0010 __spawni"
	strings:
		$1 = { 70 B5 84 B0 01 26 08 9D 09 9C 02 96 00 95 01 94 ?? ?? ?? ?? 04 B0 70 BD }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "wait_on_socket"
		size = 184
		refs = "0016 __poll 003c __gettimeofday 005a __aeabi_idiv 00b0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 85 B0 0A 46 0C 46 00 90 01 21 68 46 19 23 AD F8 04 30 ?? ?? ?? ?? 41 1C 03 46 03 D0 18 46 05 B0 BD E8 F0 83 21 4A 1D EE 70 5F 7A 44 12 68 AA 58 04 2A F3 D1 00 21 02 A8 ?? ?? ?? ?? 02 9A 03 98 4F F4 7A 73 19 46 44 F6 D3 57 00 F5 FA 70 4F F6 18 46 03 FB 02 49 ?? ?? ?? ?? DF F8 54 80 C1 F2 62 07 CF F6 FF 76 81 44 14 E0 42 46 7A 44 12 68 AA 58 04 2A D2 D1 ?? ?? ?? ?? 03 9B 02 9A 03 F5 FA 73 87 FB 03 01 DB 17 A3 EB A1 13 06 FB 02 32 02 EB 09 04 22 46 01 21 68 46 ?? ?? ?? ?? 00 21 03 46 02 A8 5A 1C E0 D0 B8 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "open_socket"
		size = 452
		refs = "0004 __have_sock_cloexec 0028 __socket 005e .LC0 009c __connect 00be memcpy 00cc __send 0112 __libc_do_syscall 013c __gettimeofday 0162 __poll 0190 __fcntl 01b0 __aeabi_idiv 01b8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? A5 B0 ?? ?2 0? 0? 00 AF 8A 46 16 46 23 68 78 60 00 2B 68 DB 40 F6 01 01 01 20 C0 F2 08 01 00 22 ?? ?? ?? ?? 23 68 05 46 00 2B 56 D0 00 2B 5A DB 00 2D C0 F2 AC 80 06 F1 0F 02 23 68 22 F0 03 02 06 F1 0C 08 0A 32 00 2B 22 F0 07 02 AD EB 02 0D 6C 46 C0 F2 95 80 ?? ?2 0? 0? 07 F1 90 09 ?? ?2 0? 0? 4F F0 01 0B 29 F8 70 BD BE E8 0F 00 C7 F8 22 00 DE F8 00 00 9E F8 04 E0 C7 F8 26 10 49 46 C7 F8 2A 20 6E 22 C7 F8 32 00 28 46 C7 F8 2E 30 87 F8 36 E0 ?? ?? ?? ?? 00 28 2B DB 7B 68 4F F0 01 0B DF F8 14 91 51 46 32 46 04 F1 0C 00 63 60 02 23 A6 60 23 60 ?? ?? ?? ?? 4F F4 80 43 28 46 21 46 42 46 ?? ?? ?? ?? 43 1C 23 D0 40 45 19 D1 28 46 94 37 BD 46 BD E8 F0 8F 42 1C 18 BF 01 23 42 D0 23 60 A2 E7 01 20 00 22 01 46 ?? ?? ?? ?? 05 46 9D E7 2E 4B 1D EE 70 2F 7B 44 1B 68 D3 58 73 2B CB D0 28 46 4F F0 06 0C ?? ?? ?? ?? 4F F0 FF 30 DE E7 4B 46 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B CA D0 B8 F1 FF 3F D2 D0 0B 2B EA D1 07 F1 10 00 00 21 ?? ?? ?? ?? BB F1 00 0F 2A D0 79 69 41 F2 88 32 3B 69 F9 60 05 33 BB 60 07 F1 18 00 01 21 4F F0 1C 03 BD 61 BB 83 ?? ?? ?? ?? 00 28 D0 DD 4F F0 00 0B A8 E7 12 4B 1D EE 70 2F 7B 44 1B 68 D3 58 16 2B 0C BF 4F F0 FF 33 01 23 B0 E7 28 46 04 21 40 F6 02 02 ?? ?? ?? ?? 63 E7 4F F0 FF 30 9E E7 BA 68 4F F4 7A 71 3E 69 7B 69 F8 68 96 1B C0 1A 01 FB 06 F6 ?? ?? ?? ?? 32 18 CD E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_2_0 {
	meta:
		name = "__readall"
		size = 120
		refs = "001e __read 0070 __libc_errno"
	strings:
		$1 = { 2D E9 F8 4F 90 46 DF F8 68 B0 07 46 DF F8 64 A0 0E 46 15 46 1D EE 70 9F 38 46 31 46 2A 46 ?? ?? ?? ?? 43 1C 04 46 08 D0 00 28 12 DD 2D 1A 06 44 F2 D1 C5 EB 08 00 BD E8 F8 8F 53 46 7B 44 1B 68 59 F8 03 30 04 2B E7 D0 0B 2B 09 D0 20 46 BD E8 F8 8F EE D0 5B 46 7B 44 1B 68 59 F8 03 30 F3 E7 38 46 C8 21 FF F7 8E FE 00 28 D5 DC EE E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_3_0 {
	meta:
		name = "__readvall"
		size = 280
		refs = "0024 __readv 006e memcpy 0108 __libc_errno"
	strings:
		$1 = { 2D E9 F8 4F 80 46 00 AF DF F8 08 91 0D 46 16 46 05 E0 4A 46 7A 44 12 68 9B 58 04 2B 61 D1 32 46 40 46 29 46 ?? ?? ?? ?? 1D EE 70 3F 42 1C 04 46 EF D0 00 28 4E DD 00 2E 0A DD 00 23 F1 00 99 46 EA 18 08 33 8B 42 52 68 91 44 F9 D1 4C 45 03 D3 20 46 BD 46 BD E8 F8 8F 03 F1 0A 02 EA 46 22 F0 07 02 29 46 AD EB 02 0D 1A 46 68 46 A3 46 ?? ?? ?? ?? 05 46 6A 68 5A 45 17 D9 29 68 CB EB 02 02 6A 60 01 EB 0B 03 2B 60 40 46 29 46 32 46 ?? ?? ?? ?? B0 F1 FF 3F 83 46 0C D0 00 28 16 DC 24 D1 20 46 D5 46 BD 46 BD E8 F8 8F C2 EB 0B 0B 01 3E 08 35 DF E7 14 4A 1D EE 70 1F 7A 44 12 68 8A 58 04 2A E1 D0 0B 2A 17 D0 5C 46 E9 E7 04 44 4C 45 D0 D3 E5 E7 BC D0 0D 4B 1D EE 70 2F 7B 44 1B 68 D3 58 0B 2B B4 D1 00 24 A5 E7 09 4A 1D EE 70 1F 7A 44 12 68 8A 58 E5 E7 40 46 C8 21 FF F7 06 FE 00 28 C1 DC E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_4_0 {
	meta:
		name = "__nscd_unmap"
		size = 58
		refs = "000c __munmap 001a .LC1 001e .LC2 0022 __PRETTY_FUNCTION__.13282 0036 __assert_fail 0016 free"
	strings:
		$1 = { C3 68 10 B5 04 46 43 B9 A1 68 00 68 ?? ?? ?? ?? 20 46 BD E8 10 40 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 88 72 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_5_0 {
	meta:
		name = "__nscd_get_mapping"
		size = 564
		refs = "0010 strlen 00a2 __close 0102 __recvmsg 0128 strcmp 0136 __fxstat64 014e __nscd_unmap 0160 __munmap 0192 __mmap 01de malloc 020a time 0228 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F B7 B0 05 46 02 AF 08 46 88 46 92 46 ?? ?? ?? ?? 84 4B 1D EE 70 4F 41 46 7B 44 1B 68 E3 58 7B 61 00 F1 08 02 00 F1 01 0B 22 F0 07 02 81 46 AD EB 02 0D 28 46 5A 46 02 AD BD 61 FF F7 17 FE 05 1E B8 BF 4F F0 FF 38 2C DB BB 69 41 F2 88 31 07 F1 20 02 4F F0 02 0E 7A 63 07 F1 3C 06 FB 62 07 F1 2C 02 08 23 7A 65 BB 63 10 22 00 23 FE 65 FB 64 4F F0 FF 36 3B 65 7B 66 01 23 BE 64 C7 F8 30 B0 C7 F8 58 E0 3A 66 FA 63 3B 64 7B 64 FF F7 92 FD 00 28 C8 BF 64 4E 2D DC 4F F0 FF 38 28 46 ?? ?? ?? ?? 62 4B 7D 69 DA F8 00 00 7B 44 1B 68 E5 50 CA F8 00 80 98 B1 00 F1 0C 02 C3 68 BF F3 5F 8F 5C 1E 52 E8 00 1F 99 42 03 D1 42 E8 00 45 00 2D F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 35 D0 40 46 D4 37 BD 46 BD E8 F0 8F 33 46 7B 44 1B 68 E3 58 04 2B 08 D1 4F F0 80 42 28 46 07 F1 4C 01 ?? ?? ?? ?? 42 1C F0 D0 3B 6E 0B 2B C5 D9 FB 6D 00 2B C2 D0 1B 68 10 2B BF D1 BB 6C 83 45 3B 61 25 D1 B8 69 41 46 ?? ?? ?? ?? D0 B9 03 20 39 69 07 F1 68 02 ?? ?? ?? ?? 98 B9 D7 E9 26 23 78 2A 73 F1 00 00 0D DB C7 E9 08 23 1A E0 ?? ?? ?? ?? 40 46 D4 37 BD 46 BD E8 F0 8F B9 69 30 46 ?? ?? ?? ?? 4F F0 FF 38 38 69 ?? ?? ?? ?? 97 E7 09 F1 09 09 48 45 F5 D1 B8 69 41 46 ?? ?? ?? ?? 00 28 EF D1 3B 69 01 22 00 20 39 6A 01 90 00 93 13 46 ?? ?? ?? ?? 43 1C 06 46 E3 D0 03 68 02 2B 40 D1 43 68 78 2B 3D D1 83 6A 00 2B 3A D0 C0 68 48 B3 9B 00 D6 F8 2C 90 0F 33 D7 E9 08 01 23 F0 0F 0C 09 F1 78 0B E3 44 00 23 5A 46 C7 E9 06 01 99 42 08 BF 90 42 C1 D3 14 20 C7 F8 0C C0 ?? ?? ?? ?? D7 F8 0C C0 80 46 00 28 B7 D0 71 68 01 22 06 60 0C EB 01 03 C0 F8 08 B0 1E 44 C0 F8 10 90 46 60 C2 60 B0 E7 D6 E9 04 89 ?? ?? ?? ?? 18 F5 96 78 49 F1 00 09 C1 17 89 45 08 BF 80 45 01 D3 B3 6A C6 E7 39 6A 9A E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_64_6_0 {
	meta:
		name = "__nscd_get_map_ref"
		size = 232
		refs = "009e __nscd_get_mapping 00c8 time"
	strings:
		$1 = { 2D E9 F0 4F 9A 46 53 68 85 B0 91 46 83 46 01 33 52 D0 06 20 01 23 BF F3 5F 8F 59 E8 00 2F 00 2A 03 D1 49 E8 00 34 00 2C F7 D1 BF F3 5F 8F 03 92 03 9A 00 2A 3E D1 D9 F8 04 80 B8 F1 FF 3F 36 D0 B8 F1 00 0F 28 D0 D8 F8 00 30 D8 68 00 28 38 D0 D8 6A D8 F8 10 20 90 42 1E D8 9B 68 CA F8 00 30 DB 07 24 D4 08 F1 0C 02 D8 F8 0C 30 BF F3 5F 8F 58 1C 52 E8 00 1F 99 42 03 D1 42 E8 00 04 00 2C F7 D1 8B 42 BF F3 5F 8F EE D1 40 46 00 23 C9 F8 00 30 05 B0 BD E8 F0 8F 58 46 09 F1 04 02 ?? ?? ?? ?? B0 F1 FF 3F 80 46 18 BF 03 68 D5 D1 4F F0 FF 38 EA E7 01 38 AE D1 4F F0 FF 30 05 B0 BD E8 F0 8F D3 E9 04 45 01 91 ?? ?? ?? ?? 14 F5 96 74 01 99 45 F1 00 05 06 46 C7 17 BD 42 08 BF B4 42 DA D3 D8 F8 00 30 B3 E7 }
	condition:
		$1
}

rule file_64_7_0 {
	meta:
		name = "__nscd_cache_search"
		size = 248
		refs = "0012 __nis_hash 0024 __aeabi_uidivmod 00b0 memcmp"
	strings:
		$1 = { 2D E9 F0 4F 1D 46 8A 46 83 B0 11 46 81 46 50 46 93 46 ?? ?? ?? ?? 2C 68 2F 69 4C F6 CD 46 CC F6 CC 46 A1 6A ?? ?? ?? ?? A6 FB 07 26 76 09 1E 31 54 F8 21 40 61 1C 5B D0 04 F1 1C 03 9F 42 57 D3 D5 F8 04 80 08 EB 04 03 13 F0 03 05 50 D1 0C 9A 01 3E 02 F1 18 0C 1A E0 1B 69 9C 42 48 D0 71 1C 46 D0 45 B1 08 EB 04 02 12 F0 03 00 40 D1 1C 34 A7 42 3A D3 14 69 5A 1C C5 F1 01 05 38 D0 03 F1 1C 02 97 42 34 D3 43 44 01 3E 9A 07 30 D1 1A 78 4A 45 E1 D1 5A 68 5A 45 DE D1 99 68 01 EB 0B 02 97 42 D9 D3 41 44 50 46 5A 46 01 93 CD F8 00 C0 ?? ?? ?? ?? 01 9B DD F8 00 C0 00 28 CC D1 5A 69 02 F1 18 01 8F 42 C7 D3 08 EB 02 01 11 F0 07 0F 0B D1 88 7C 00 28 BF D0 58 F8 02 00 10 44 87 42 BA D3 62 44 97 42 B7 D3 08 46 03 B0 BD E8 F0 8F 00 20 03 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_64_8_0 {
	meta:
		name = "__nscd_open_socket"
		size = 148
		refs = "0052 __read 006a __libc_do_syscall 0088 __libc_errno"
	strings:
		$1 = { 2D E9 F0 47 0C 46 B4 F5 80 6F 01 46 98 46 08 9D 36 D8 1D 4B 1D EE 70 7F 10 46 22 46 7B 44 1B 68 57 F8 03 A0 FF F7 1A FC 06 1E 20 DB 41 F2 88 31 FF F7 B8 FB 00 28 C8 BF DF F8 54 90 06 DC 11 E0 4B 46 7B 44 1B 68 FC 58 04 2C 06 D1 30 46 41 46 2A 46 ?? ?? ?? ?? 43 1C F2 D0 A8 42 02 D1 30 46 BD E8 F0 87 30 46 4F F0 06 0C ?? ?? ?? ?? 07 4B 4F F0 FF 30 7B 44 1B 68 47 F8 03 A0 BD E8 F0 87 4F F0 FF 30 BD E8 F0 87 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "convert_and_print"
		size = 186
		refs = "0010 strlen 0050 realloc 006c __mbsrtowcs 0074 stderr 0078 .LC0 0090 __vfwprintf 00a0 .LC1 00ae fputws_unlocked"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 00 AF 80 46 79 60 00 28 41 D0 ?? ?? ?? ?? 00 24 25 46 40 F6 9F 79 00 F1 01 0B 4F EA 8B 06 06 F1 0E 0A 2A F0 07 0A BB F5 FA 6F 31 46 3C BF AD EB 0A 0D 6C 46 0D D3 20 1C 18 BF 01 20 CB 45 88 BF 00 20 00 28 0C BF 20 46 00 20 ?? ?? ?? ?? 04 46 08 B3 07 F1 18 01 20 46 5A 46 07 F1 10 03 41 F8 0C 8D 3D 61 7D 61 ?? ?? ?? ?? 83 45 DB D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? B0 F1 FF 3F 18 BF 21 46 7A 68 18 68 ?? ?? ?? ?? 1C 37 BD 46 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 19 68 ?? ?? ?? ?? 1C 37 BD 46 BD E8 F0 8F }
	condition:
		$1
}

rule file_66_1_0 {
	meta:
		name = "vwarnx"
		size = 128
		refs = "0002 stderr 0016 __progname 001a .LC2 0028 __fwprintf 0044 .LC3 0052 fprintf 005e vfprintf 003c putwc_unlocked 007c __overflow"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? ?? ?2 0? 0? 06 46 0F 46 20 68 C3 6E 00 2B 14 DD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2A 68 ?? ?? ?? ?? 30 46 39 46 FF F7 88 FF 21 68 0A 20 BD E8 F8 40 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 ?? ?? ?? ?? 26 B1 31 46 3A 46 20 68 ?? ?? ?? ?? 20 68 43 69 82 69 93 42 04 D2 59 1C 0A 22 41 61 1A 70 F8 BD 0A 21 BD E8 F8 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_2_0 {
	meta:
		name = "vwarn"
		size = 200
		refs = "0004 stderr 0024 __progname 002e .LC2 0038 __fwprintf 0046 .LC4 0050 fputws_unlocked 0056 .LC5 0074 .LC3 007e fprintf 008a vfprintf 008e .LC6 009c fwrite_unlocked 00a2 .LC7 00bc __libc_errno"
	strings:
		$1 = { 2D E9 B0 43 ?? ?2 0? 0? ?? ?2 0? 0? 2B 4B 07 46 1D EE 70 5F 20 68 7B 44 1B 68 89 46 55 F8 03 80 C3 6E 00 2B ?? ?2 0? 0? 22 DD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 1A 68 ?? ?? ?? ?? 57 B1 38 46 49 46 FF F7 3F FF ?? ?2 0? 0? ?? ?2 0? 0? 21 68 ?? ?? ?? ?? 1A 4B ?? ?2 0? 0? 20 68 ?? ?2 0? 0? 7B 44 1B 68 45 F8 03 80 BD E8 B0 43 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 1A 68 ?? ?? ?? ?? 6F B1 39 46 4A 46 20 68 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 01 21 02 22 23 68 ?? ?? ?? ?? 08 4B ?? ?2 0? 0? 20 68 ?? ?2 0? 0? 7B 44 1B 68 45 F8 03 80 BD E8 B0 43 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_3_0 {
	meta:
		name = "warn"
		size = 30
		refs = "0010 vwarn"
		altNames = "warnx"
	strings:
		$1 = { 0F B4 00 B5 83 B0 04 AB 53 F8 04 0B 19 46 01 93 ?? ?? ?? ?? 03 B0 5D F8 04 EB 04 B0 70 47 }
	condition:
		$1
}

rule file_66_5_0 {
	meta:
		name = "verr"
		size = 18
		refs = "0008 vwarn 000e exit"
	strings:
		$1 = { 10 B5 04 46 08 46 11 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_15_4 {
	meta:
		name = ".LTHUNK1"
		size = 18
		refs = "0004 _ZNSt10istrstreamD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_54_17_4 {
	meta:
		name = ".LTHUNK3"
		size = 18
		refs = "0004 _ZNSt10ostrstreamD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_54_20_4 {
	meta:
		name = ".LTHUNK7"
		size = 18
		refs = "0004 _ZNSt9strstreamD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_528_8_0 {
	meta:
		name = "_IO_new_file_setbuf"
		size = 28
		refs = "0004 _IO_default_setbuf"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 38 B1 E3 69 20 46 A3 61 63 61 23 61 E3 60 63 60 A3 60 10 BD }
	condition:
		$1
}

rule file_33_8_4 {
	meta:
		name = "_ZN10__cxxabiv115__forced_unwindD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv115__forced_unwindD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_85_1_4 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv116__enum_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_129_1_4 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv117__array_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_126_3_4 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv117__class_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_87_2_4 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv117__pbase_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_33_9_4 {
	meta:
		name = "_ZN10__cxxabiv119__foreign_exceptionD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv119__foreign_exceptionD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_36_2_4 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv119__pointer_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_27_2_4 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv120__function_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_84_1_4 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv120__si_class_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_43_1_4 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv121__vmi_class_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_112_1_4 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv123__fundamental_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_7_1_4 {
	meta:
		name = "_ZN10__cxxabiv129__pointer_to_member_type_infoD0Ev"
		size = 18
		refs = "0004 _ZN10__cxxabiv129__pointer_to_member_type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_40_1_4 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEED0Ev"
		size = 18
		refs = "0004 _ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_40_3_4 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIwSt11char_traitsIwEED0Ev"
		size = 18
		refs = "0004 _ZN9__gnu_cxx13stdio_filebufIwSt11char_traitsIwEED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_28_1_4 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD0Ev"
		size = 18
		refs = "0004 _ZN9__gnu_cxx20recursive_init_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_102_86_4 {
	meta:
		name = "_ZNSbIwSt11char_traitsIwESaIwEEC2EjwRKS1_"
		size = 20
		refs = "000a _ZNSbIwSt11char_traitsIwESaIwEE12_S_constructEjwRKS1_"
	strings:
		$1 = { 10 B5 04 46 08 46 11 46 1A 46 ?? ?? ?? ?? 20 60 20 46 10 BD }
	condition:
		$1
}

rule file_56_85_4 {
	meta:
		name = "_ZNSsC2EjcRKSaIcE"
		size = 20
		refs = "000a _ZNSs12_S_constructEjcRKSaIcE"
	strings:
		$1 = { 10 B5 04 46 08 46 11 46 1A 46 ?? ?? ?? ?? 20 60 20 46 10 BD }
	condition:
		$1
}

rule file_51_2_4 {
	meta:
		name = "_ZNSt10bad_typeidD0Ev"
		size = 18
		refs = "0004 _ZNSt10bad_typeidD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_4_3_4 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EED0Ev"
		size = 18
		refs = "0004 _ZNSt10moneypunctIcLb0EED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_4_1_4 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED0Ev"
		size = 18
		refs = "0004 _ZNSt10moneypunctIcLb1EED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_4_7_4 {
	meta:
		name = "_ZNSt10moneypunctIwLb0EED0Ev"
		size = 18
		refs = "0004 _ZNSt10moneypunctIwLb0EED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_4_5_4 {
	meta:
		name = "_ZNSt10moneypunctIwLb1EED0Ev"
		size = 18
		refs = "0004 _ZNSt10moneypunctIwLb1EED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_57_62_4 {
	meta:
		name = "_ZNSt11__timepunctIcED0Ev"
		size = 18
		refs = "0004 _ZNSt11__timepunctIcED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_20_62_4 {
	meta:
		name = "_ZNSt11__timepunctIwED0Ev"
		size = 18
		refs = "0004 _ZNSt11__timepunctIwED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_3_4 {
	meta:
		name = "_ZNSt11logic_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt11logic_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_15_4 {
	meta:
		name = "_ZNSt11range_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt11range_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_108_1_4 {
	meta:
		name = "_ZNSt11regex_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt11regex_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_80_2_4 {
	meta:
		name = "_ZNSt12bad_weak_ptrD0Ev"
		size = 18
		refs = "0004 _ZNSt12bad_weak_ptrD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_48_5_4 {
	meta:
		name = "_ZNSt12ctype_bynameIcED0Ev"
		size = 18
		refs = "0004 _ZNSt12ctype_bynameIcED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_101_8_4 {
	meta:
		name = "_ZNSt12ctype_bynameIwED0Ev"
		size = 18
		refs = "0004 _ZNSt12ctype_bynameIwED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_5_4 {
	meta:
		name = "_ZNSt12domain_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt12domain_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_125_5_4 {
	meta:
		name = "_ZNSt12future_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt12future_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_9_4 {
	meta:
		name = "_ZNSt12length_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt12length_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_11_4 {
	meta:
		name = "_ZNSt12out_of_rangeD0Ev"
		size = 18
		refs = "0004 _ZNSt12out_of_rangeD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_54_13_4 {
	meta:
		name = "_ZNSt12strstreambufD0Ev"
		size = 18
		refs = "0004 _ZNSt12strstreambufD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_76_12_4 {
	meta:
		name = "_ZNSt12system_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt12system_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_125_9_4 {
	meta:
		name = "_ZNSt13__future_base11_State_baseD0Ev"
		size = 18
		refs = "0004 _ZNSt13__future_base11_State_baseD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_125_7_4 {
	meta:
		name = "_ZNSt13__future_base12_Result_baseD0Ev"
		size = 18
		refs = "0004 _ZNSt13__future_base12_Result_baseD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_33_7_4 {
	meta:
		name = "_ZNSt13bad_exceptionD0Ev"
		size = 18
		refs = "0004 _ZNSt13bad_exceptionD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_13_4 {
	meta:
		name = "_ZNSt13runtime_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt13runtime_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_76_8_4 {
	meta:
		name = "_ZNSt14error_categoryD0Ev"
		size = 18
		refs = "0004 _ZNSt14error_categoryD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_17_4 {
	meta:
		name = "_ZNSt14overflow_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt14overflow_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_19_4 {
	meta:
		name = "_ZNSt15underflow_errorD0Ev"
		size = 18
		refs = "0004 _ZNSt15underflow_errorD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_57_44_4 {
	meta:
		name = "_ZNSt16__numpunct_cacheIcED0Ev"
		size = 18
		refs = "0004 _ZNSt16__numpunct_cacheIcED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_20_44_4 {
	meta:
		name = "_ZNSt16__numpunct_cacheIwED0Ev"
		size = 18
		refs = "0004 _ZNSt16__numpunct_cacheIwED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_100_7_4 {
	meta:
		name = "_ZNSt16invalid_argumentD0Ev"
		size = 18
		refs = "0004 _ZNSt16invalid_argumentD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_13_1_4 {
	meta:
		name = "_ZNSt16nested_exceptionD0Ev"
		size = 18
		refs = "0004 _ZNSt16nested_exceptionD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_57_47_4 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED0Ev"
		size = 18
		refs = "0004 _ZNSt17__timepunct_cacheIcED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_20_47_4 {
	meta:
		name = "_ZNSt17__timepunct_cacheIwED0Ev"
		size = 18
		refs = "0004 _ZNSt17__timepunct_cacheIwED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_68_2_4 {
	meta:
		name = "_ZNSt17bad_function_callD0Ev"
		size = 18
		refs = "0004 _ZNSt17bad_function_callD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_57_40_4 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIcLb0EED0Ev"
		size = 18
		refs = "0004 _ZNSt18__moneypunct_cacheIcLb0EED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_57_41_4 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIcLb1EED0Ev"
		size = 18
		refs = "0004 _ZNSt18__moneypunct_cacheIcLb1EED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_20_40_4 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb0EED0Ev"
		size = 18
		refs = "0004 _ZNSt18__moneypunct_cacheIwLb0EED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_20_41_4 {
	meta:
		name = "_ZNSt18__moneypunct_cacheIwLb1EED0Ev"
		size = 18
		refs = "0004 _ZNSt18__moneypunct_cacheIwLb1EED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_101_9_4 {
	meta:
		name = "_ZNSt5ctypeIcED0Ev"
		size = 18
		refs = "0004 _ZNSt5ctypeIcED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_101_7_4 {
	meta:
		name = "_ZNSt5ctypeIwED0Ev"
		size = 18
		refs = "0004 _ZNSt5ctypeIwED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_106_3_4 {
	meta:
		name = "_ZNSt6locale5facetD0Ev"
		size = 18
		refs = "0004 _ZNSt6locale5facetD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_96_10_4 {
	meta:
		name = "_ZNSt7codecvtIcc11__mbstate_tED0Ev"
		size = 18
		refs = "0004 _ZNSt7codecvtIcc11__mbstate_tED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_96_12_4 {
	meta:
		name = "_ZNSt7codecvtIwc11__mbstate_tED0Ev"
		size = 18
		refs = "0004 _ZNSt7codecvtIwc11__mbstate_tED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_14_2_4 {
	meta:
		name = "_ZNSt8bad_castD0Ev"
		size = 18
		refs = "0004 _ZNSt8bad_castD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_50_2_4 {
	meta:
		name = "_ZNSt8ios_base7failureD0Ev"
		size = 18
		refs = "0004 _ZNSt8ios_base7failureD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_103_7_4 {
	meta:
		name = "_ZNSt8ios_baseD0Ev"
		size = 18
		refs = "0004 _ZNSt8ios_baseD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_57_64_4 {
	meta:
		name = "_ZNSt8messagesIcED0Ev"
		size = 18
		refs = "0004 _ZNSt8messagesIcED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_20_64_4 {
	meta:
		name = "_ZNSt8messagesIwED0Ev"
		size = 18
		refs = "0004 _ZNSt8messagesIwED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_62_1_4 {
	meta:
		name = "_ZNSt8numpunctIcED0Ev"
		size = 18
		refs = "0004 _ZNSt8numpunctIcED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_62_3_4 {
	meta:
		name = "_ZNSt8numpunctIwED0Ev"
		size = 18
		refs = "0004 _ZNSt8numpunctIwED1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_78_2_4 {
	meta:
		name = "_ZNSt9bad_allocD0Ev"
		size = 18
		refs = "0004 _ZNSt9bad_allocD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_33_6_4 {
	meta:
		name = "_ZNSt9exceptionD0Ev"
		size = 18
		refs = "0004 _ZNSt9exceptionD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_60_4_4 {
	meta:
		name = "_ZNSt9type_infoD0Ev"
		size = 18
		refs = "0004 _ZNSt9type_infoD1Ev 000a _ZdlPv"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 20 46 10 BD }
	condition:
		$1
}

rule file_41_0_2 {
	meta:
		name = "__significandf"
		size = 26
		refs = "0004 __ilogbf 000a __aeabi_i2f 0016 __ieee754_scalbf"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 40 42 ?? ?? ?? ?? 01 46 20 46 BD E8 10 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_6_0 {
	meta:
		name = "verrx"
		size = 18
		refs = "0008 vwarnx 000e exit"
	strings:
		$1 = { 10 B5 04 46 08 46 11 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_66_7_0 {
	meta:
		name = "err"
		size = 20
		refs = "0010 verr"
		altNames = "errx"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "_IO_obstack_printf"
		size = 30
		refs = "0010 _IO_obstack_vprintf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_1407_0_0 {
	meta:
		name = "___asprintf"
		size = 30
		refs = "0010 _IO_vasprintf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_1268_0_0 {
	meta:
		name = "__dprintf"
		size = 30
		refs = "0010 _IO_vdprintf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_885_0_0 {
	meta:
		name = "__fprintf"
		size = 30
		refs = "0010 vfprintf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_1281_0_0 {
	meta:
		name = "__fscanf"
		size = 30
		refs = "0010 __vfscanf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_870_0_0 {
	meta:
		name = "__fwprintf"
		size = 30
		refs = "0010 __vfwprintf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_897_0_0 {
	meta:
		name = "__fwscanf"
		size = 30
		refs = "0010 __vfwscanf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_552_0_0 {
	meta:
		name = "__isoc99_sscanf"
		size = 30
		refs = "0010 __isoc99_vsscanf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_1068_0_0 {
	meta:
		name = "__isoc99_swscanf"
		size = 30
		refs = "0010 __isoc99_vswscanf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_626_0_0 {
	meta:
		name = "__sprintf"
		size = 30
		refs = "0010 _IO_vsprintf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__sscanf"
		size = 30
		refs = "0010 _IO_vsscanf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_869_0_0 {
	meta:
		name = "__swscanf"
		size = 30
		refs = "0010 vswscanf"
	strings:
		$1 = { 0E B4 00 B5 82 B0 03 AB 53 F8 04 1B 1A 46 01 93 ?? ?? ?? ?? 02 B0 5D F8 04 EB 03 B0 70 47 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__scandir64"
		size = 28
		refs = "0014 scandirat64"
		altNames = "scandir"
	strings:
		$1 = { 30 B5 83 B0 0D 46 14 46 01 46 00 93 2A 46 23 46 6F F0 63 00 ?? ?? ?? ?? 03 B0 30 BD }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "ether_ntohost"
		size = 196
		refs = "0004 .LANCHOR0 0052 .LC0 0066 __nss_next2 0082 strcpy 00a0 __nss_ethers_lookup 00c0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? AD F2 24 4D 83 46 0F 46 D8 F8 00 30 00 2B 39 D0 03 AE D8 F8 04 50 04 AC 33 60 01 33 25 60 22 D0 DF F8 90 A0 1D EE 70 9F 4F F0 00 08 00 E0 25 68 53 46 05 A9 7B 44 1B 68 08 AA 4B 44 38 46 00 93 4F F4 80 63 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 00 22 23 46 05 46 30 46 8D E8 20 01 ?? ?? ?? ?? 00 28 E5 D0 01 2D 05 D0 4F F0 FF 30 0D F2 24 4D BD E8 F0 8F 58 46 05 99 ?? ?? ?? ?? 00 20 0D F2 24 4D BD E8 F0 8F 03 AE 04 AC ?? ?2 0? 0? 30 46 22 46 ?? ?2 0? 0? ?? ?? ?? ?? 20 B1 4F F0 FF 33 C8 F8 00 30 E0 E7 23 68 32 68 1D 46 C8 F8 04 30 C8 F8 00 20 B5 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "clnttcp_freeres"
		size = 18
	strings:
		$1 = { 80 68 0B 46 10 B5 11 46 02 24 40 F8 4C 4F 98 47 10 BD }
	condition:
		$1
}

rule file_69_3_0 {
	meta:
		name = "clnttcp_destroy"
		size = 46
		refs = "0018 free 0028 __close"
	strings:
		$1 = { 38 B5 05 46 84 68 63 68 6B B9 23 6D DB 69 13 B1 04 F1 4C 00 98 47 20 46 ?? ?? ?? ?? 28 46 BD E8 38 40 ?? ?? ?? ?? 20 68 ?? ?? ?? ?? ED E7 }
	condition:
		$1
}

rule file_69_4_0 {
	meta:
		name = "clnttcp_control"
		size = 216
	strings:
		$1 = { 01 39 83 68 30 B4 14 46 82 B0 0E 29 62 D8 DF E8 01 F0 16 20 27 61 61 2D 61 31 34 38 46 52 54 5F 08 00 20 68 02 AA 01 25 00 90 00 99 09 BA 42 F8 04 1D 10 68 D8 63 28 46 02 B0 30 BC 70 47 94 E8 03 00 03 F1 08 04 01 22 15 46 84 E8 03 00 1A 61 F1 E7 08 33 01 25 93 E8 03 00 84 E8 03 00 EA E7 14 33 01 25 0F CB 84 E8 0F 00 E4 E7 1B 68 01 25 23 60 E0 E7 01 25 5D 60 DD E7 00 22 01 25 5A 60 D9 E7 18 6B 01 90 02 AB 01 9A 01 25 12 BA 43 F8 08 2D 18 68 20 60 28 46 02 B0 30 BC 70 47 20 68 02 AA 01 25 00 90 00 99 01 39 09 BA 42 F8 04 1D 10 68 18 63 BF E7 18 6C E4 E7 20 68 02 AA 01 25 00 90 00 99 09 BA 42 F8 04 1D 10 68 18 64 B2 E7 D8 6B D7 E7 00 25 AE E7 }
	condition:
		$1
}

rule file_69_5_0 {
	meta:
		name = "clnttcp_call"
		size = 418
		refs = "0030 _null_auth 0034 xdr_void 00a0 xdrrec_endofrecord 00cc xdrrec_skiprecord 00d6 xdr_replymsg 00f4 _seterr_reply 0182 xdr_opaque_auth"
	strings:
		$1 = { 2D E9 F0 4F 93 B0 84 68 82 46 03 93 05 91 04 F1 4C 06 23 69 02 92 33 B9 1E AA 04 F1 08 03 92 E8 03 00 83 E8 03 00 1C 9B 00 2B 7E D0 01 23 00 93 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F0 00 08 04 F1 30 03 01 93 03 23 04 93 22 6D 30 46 23 6B 01 99 01 3B D7 68 C4 F8 4C 80 93 FA 83 FB C4 F8 24 80 23 63 A2 6C B8 47 00 28 66 D0 23 6D 30 46 05 A9 5B 68 98 47 00 28 5F D0 DA F8 00 30 31 46 18 46 1B 6A 5B 68 98 47 00 28 56 D0 30 46 03 99 02 9B 98 47 00 28 50 D0 30 46 00 99 ?? ?? ?? ?? 00 28 54 D0 00 9B 00 2B 54 D0 A3 68 00 2B 34 D0 09 AF 01 23 E3 64 95 E8 07 00 CD F8 34 80 CD F8 38 90 87 E8 07 00 30 46 ?? ?? ?? ?? 06 A9 00 B3 30 46 ?? ?? ?? ?? 28 B9 60 6A 00 28 EB D0 13 B0 BD E8 F0 8F 06 9B 5B 45 E5 D1 06 A8 04 F1 24 01 ?? ?? ?? ?? 60 6A 00 28 2E D0 04 9B 01 3B 04 93 ED D0 DA F8 00 30 18 46 1B 6A DB 68 98 47 00 28 9B D1 60 6A 13 B0 BD E8 F0 8F E3 68 00 2B C7 D1 05 20 60 62 DB E7 A3 68 00 2B 7F F4 7D AF E3 68 00 33 18 BF 01 23 00 93 78 E7 63 6A 0B B9 01 23 63 62 30 46 01 21 ?? ?? ?? ?? 60 6A C7 E7 03 20 60 62 C4 E7 00 98 C2 E7 DA F8 00 30 39 46 18 46 1B 6A 9B 68 98 47 70 B9 07 22 06 23 62 62 A3 62 0A 9B 00 2B CD D0 02 23 30 46 39 46 E3 64 ?? ?? ?? ?? 60 6A AB E7 30 46 1D 99 1C 9B 98 47 00 28 EE D1 63 6A 00 2B EB D1 02 23 63 62 E8 E7 }
	condition:
		$1
}

rule file_69_6_0 {
	meta:
		name = "writetcp"
		size = 68
		refs = "001a __write 0040 __libc_errno"
	strings:
		$1 = { F8 B5 17 1E 06 46 0D 46 C8 BF 3C 46 02 DC 15 E0 00 2C 13 DD 29 46 22 46 30 68 ?? ?? ?? ?? 43 1C C0 EB 04 04 05 44 F3 D1 05 4B 1D EE 70 2F 03 21 7B 44 1B 68 71 62 D3 58 B3 62 F8 BD 38 46 F8 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_7_0 {
	meta:
		name = "readtcp"
		size = 176
		refs = "0044 __poll 0062 __read 00a8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 04 46 86 68 82 B0 C3 68 15 46 0F 46 10 46 02 B3 44 F6 D3 50 4F EA E3 7E C1 F2 62 00 4F F4 7A 71 22 68 80 FB 03 C3 DF F8 80 80 00 92 01 22 AD F8 04 20 CE EB A3 13 01 FB 06 36 32 46 68 46 01 21 ?? ?? ?? ?? 42 1C 17 D0 30 B9 4F F0 FF 30 05 23 63 62 02 B0 BD E8 F0 81 39 46 2A 46 20 68 ?? ?? ?? ?? 43 1C 14 D0 00 28 F3 D1 68 22 04 23 A2 62 4F F0 FF 30 63 62 EC E7 43 46 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B D8 D0 A3 62 04 23 63 62 E0 E7 04 4B 1D EE 70 2F 04 21 7B 44 1B 68 61 62 D3 58 A3 62 D6 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_8_0 {
	meta:
		name = "clnttcp_create"
		size = 444
		refs = "0010 malloc 005c _create_xid 007a xdrmem_create 0082 xdr_callhdr 009e readtcp 00a2 writetcp 00ba xdrrec_create 00be .LANCHOR0 00ca authnone_create 00e2 pmap_getport 00fc free 0116 __socket 0120 bindresvport 0130 __connect 0146 __close 014c __rpc_thread_createerr 0150 .LC0 015c _libc_intl_domainname 0164 __dcgettext 0168 .LC1 016c __func__.15703 017c __fxprintf 01b8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 05 46 8F B0 0C 20 8B 46 92 46 99 46 ?? ?? ?? ?? 06 46 64 20 ?? ?? ?? ?? 00 2E 18 BF 00 28 04 46 00 F0 92 80 6B 88 00 2B 55 D0 D9 F8 00 30 00 2B A4 BF 00 22 62 60 69 DB 4F F0 00 08 23 60 C4 F8 0C 80 04 F1 14 0E C4 F8 10 80 04 F1 4C 07 95 E8 0F 00 02 25 8E E8 0F 00 ?? ?? ?? ?? 04 F1 30 01 43 46 18 22 CD F8 0C 80 CD F8 14 B0 CD F8 18 A0 04 95 02 90 38 46 ?? ?? ?? ?? 38 46 02 A9 ?? ?? ?? ?? 00 28 35 D0 23 6D 38 46 1B 69 98 47 23 6D DB 69 A0 64 0B B1 38 46 98 47 ?? ?2 0? 0? ?? ?2 0? 0? 38 46 ?? ?2 0? 0? ?? ?2 0? 0? 18 99 8D E8 0C 00 23 46 19 9A ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? B4 60 73 60 ?? ?? ?? ?? 33 46 30 60 18 46 0F B0 BD E8 F0 8F 28 46 59 46 52 46 06 23 ?? ?? ?? ?? 07 46 00 28 5D D0 03 02 43 EA 10 27 6F 80 9B E7 63 68 1B BB 20 46 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 00 23 18 46 0F B0 BD E8 F0 8F 01 21 06 22 02 20 ?? ?? ?? ?? 00 21 C9 F8 00 00 ?? ?? ?? ?? D9 F8 00 00 00 28 2D DB 29 46 10 22 ?? ?? ?? ?? 00 28 27 DB 01 23 63 60 D9 F8 00 30 7C E7 D9 F8 00 00 ?? ?? ?? ?? D6 E7 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 05 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 03 46 00 20 ?? ?? ?? ?? 0C 23 2B 60 AB 60 B8 E7 ?? ?? ?? ?? 0A 4B 0C 21 1D EE 70 2F 01 60 7B 44 1B 68 D3 58 83 60 D9 F8 00 00 00 28 CF DA A8 E7 20 46 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 3B 46 8C E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__libc_siglongjmp"
		size = 44
		refs = "0006 _longjmp_unwind 001a __longjmp 0026 __sigprocmask"
	strings:
		$1 = { 38 B5 04 46 0D 46 ?? ?? ?? ?? D4 F8 00 31 33 B9 20 46 00 2D 14 BF 29 46 01 21 ?? ?? ?? ?? 04 F5 82 71 00 22 02 20 ?? ?? ?? ?? F1 E7 }
	condition:
		$1
}

rule file_1418_0_0 {
	meta:
		name = "__longjmp_chk"
		size = 44
		refs = "0006 _longjmp_unwind 001a ____longjmp_chk 0026 __sigprocmask"
	strings:
		$1 = { 38 B5 04 46 0D 46 ?? ?? ?? ?? D4 F8 00 31 33 B9 20 46 00 2D 14 BF 29 46 01 21 ?? ?? ?? ?? 04 F5 82 71 00 22 02 20 ?? ?? ?? ?? F1 E7 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__getgrnam_r"
		size = 348
		refs = "0004 __nss_not_use_nscd_group 002a .LANCHOR0 005e _dl_mcount_wrapper_check 0078 .LC0 00a6 __nss_next2 00ce __nss_database_custom 00e8 __nscd_getgrnam_r 0122 __nss_group_lookup2 014c __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 9A 46 87 B0 80 46 23 68 0F 46 91 46 00 2B 57 DD 01 33 64 2B D2 BF 23 60 00 23 23 60 51 DC ?? ?2 0? 0? ?? ?2 0? 0? 22 78 00 2A 6E D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 5A D1 DF F8 00 B1 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 C8 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 36 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 1E D0 10 9F 3C 60 1D D9 24 4B 7B 44 1B 68 F0 58 22 28 39 D0 07 B0 BD E8 F0 8F AD D1 ?? ?2 0? 0? ?? ?2 0? 0? 9B 78 00 2B A6 D1 10 9A 40 46 39 46 53 46 00 92 4A 46 ?? ?? ?? ?? 00 28 EA DA 9B E7 10 9A 17 60 16 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 D1 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 88 E7 02 35 C3 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "__getgrgid_r"
		size = 348
		refs = "0004 __nss_not_use_nscd_group 002a .LANCHOR0 005e _dl_mcount_wrapper_check 0078 .LC0 00a6 __nss_next2 00ce __nss_database_custom 00e8 __nscd_getgrgid_r 0122 __nss_group_lookup2 014c __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 9A 46 87 B0 80 46 23 68 0F 46 91 46 00 2B 57 DD 01 33 64 2B D2 BF 23 60 00 23 23 60 51 DC ?? ?2 0? 0? ?? ?2 0? 0? 22 78 00 2A 6E D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 5A D1 DF F8 00 B1 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 C8 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 36 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 1E D0 10 9F 3C 60 1D D9 24 4B 7B 44 1B 68 F0 58 22 28 39 D0 07 B0 BD E8 F0 8F AD D1 ?? ?2 0? 0? ?? ?2 0? 0? 9B 78 00 2B A6 D1 10 9A 40 46 39 46 53 46 00 92 4A 46 ?? ?? ?? ?? 00 28 EA DA 9B E7 10 9A 17 60 16 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 D1 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 88 E7 02 35 C3 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__vwprintf"
		size = 18
		refs = "0000 stdout 000e __vfwprintf"
	strings:
		$1 = { ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 01 46 18 68 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1275_0_0 {
	meta:
		name = "_IO_vscanf"
		size = 20
		refs = "0000 _IO_stdin 0010 _IO_vfscanf"
	strings:
		$1 = { ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 01 46 18 68 00 23 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_825_0_0 {
	meta:
		name = "__vprintf"
		size = 18
		refs = "0000 stdout 000e vfprintf"
	strings:
		$1 = { ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 01 46 18 68 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1474_0_0 {
	meta:
		name = "__vwscanf"
		size = 20
		refs = "0000 _IO_stdin 0010 _IO_vfwscanf"
	strings:
		$1 = { ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 01 46 18 68 00 23 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "getpass"
		size = 308
		refs = "0004 .LC1 000a .LC0 0018 _IO_new_fopen 0030 fileno 0036 __tcgetattr 003e .LC2 004a __fxprintf 0050 fflush_unlocked 0054 .LANCHOR0 0060 __getline 0086 stdin 0096 _IO_new_fclose 00cc tcsetattr 00e2 .LC3 0104 stderr 0130 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? 82 46 ?? ?2 0? 0? 9E B0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 04 46 00 28 6E D0 03 68 80 46 81 46 43 F4 00 43 03 60 20 46 ?? ?? ?? ?? 0F A9 ?? ?? ?? ?? 00 26 88 B3 ?? ?2 0? 0? 52 46 ?? ?2 0? 0? 40 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? ?? ?2 0? 0? 22 46 ?? ?2 0? 0? 01 1D ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 43 B1 00 28 BC BF 00 22 1A 70 03 DB 01 38 1A 5C 0A 2A 2B D0 00 2E 34 D1 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 9C 42 02 D0 20 46 ?? ?? ?? ?? 28 68 1E B0 BD E8 F0 87 0F AE 6D 46 12 9F 0F CE 27 F0 09 07 12 97 0F C5 0F CE 0F C5 0F CE 0F C5 96 E8 07 00 85 E8 07 00 20 46 ?? ?? ?? ?? 0F AA 02 21 ?? ?? ?? ?? D0 F1 01 06 38 BF 00 26 B1 E7 00 22 1A 54 00 2E D1 D0 ?? ?2 0? 0? 40 46 ?? ?2 0? 0? ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 02 21 6A 46 ?? ?? ?? ?? C2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 14 68 D3 F8 00 80 44 45 0C BF C1 46 81 46 86 E7 04 46 B9 F1 00 0F 02 D0 48 46 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__isoc99_fscanf"
		size = 302
		refs = "005e _IO_vfscanf 00c2 __libc_do_syscall 00c8 __lll_lock_wait_private 012a _Unwind_Resume"
	strings:
		$1 = { 0E B4 03 68 70 B5 19 04 83 B0 04 46 07 9E 1C D4 80 6C 1D EE 70 5F A5 F5 98 65 83 68 AB 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 44 D1 A3 6C 18 46 9D 60 43 68 01 33 43 60 E3 6B 08 AD 31 46 2A 46 43 F0 10 03 20 46 E3 63 00 23 01 95 ?? ?? ?? ?? E2 6B 05 46 23 68 22 F0 14 02 E2 63 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 05 DC 28 46 03 B0 BD E8 70 40 03 B0 70 47 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EC E7 ?? ?? ?? ?? B7 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_829_0_0 {
	meta:
		name = "__isoc99_fwscanf"
		size = 302
		refs = "005e _IO_vfwscanf 00c2 __libc_do_syscall 00c8 __lll_lock_wait_private 012a _Unwind_Resume"
	strings:
		$1 = { 0E B4 03 68 70 B5 19 04 83 B0 04 46 07 9E 1C D4 80 6C 1D EE 70 5F A5 F5 98 65 83 68 AB 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 44 D1 A3 6C 18 46 9D 60 43 68 01 33 43 60 E3 6B 08 AD 31 46 2A 46 43 F0 10 03 20 46 E3 63 00 23 01 95 ?? ?? ?? ?? E2 6B 05 46 23 68 22 F0 14 02 E2 63 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 05 DC 28 46 03 B0 BD E8 70 40 03 B0 70 47 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EC E7 ?? ?? ?? ?? B7 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__mktemp"
		size = 26
		refs = "000a __gen_tempname"
	strings:
		$1 = { 00 21 02 23 10 B5 0A 46 04 46 ?? ?? ?? ?? 00 28 20 46 BC BF 00 23 23 70 10 BD }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "__strcasecmp"
		size = 68
		refs = "0040 __libc_tsd_LOCALE"
	strings:
		$1 = { 0F 4B 1D EE 70 2F 70 B4 88 42 7B 44 1B 68 D3 58 13 D0 9E 6B 45 1E 00 E0 64 B1 15 F8 01 4F 11 F8 01 2B 56 F8 24 30 56 F8 22 20 9B 1A F4 D0 18 46 70 BC 70 47 20 46 70 BC 70 47 00 20 70 BC 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "strftime"
		size = 32
		refs = "0012 __strftime_l 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_938_0_0 {
	meta:
		name = "__strtol_internal"
		size = 32
		refs = "0012 ____strtol_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1305_0_0 {
	meta:
		name = "__strtoll_internal"
		size = 32
		refs = "0012 ____strtoll_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_804_0_0 {
	meta:
		name = "__strtoul_internal"
		size = 32
		refs = "0012 ____strtoul_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_819_0_0 {
	meta:
		name = "__strtoull_internal"
		size = 32
		refs = "0012 ____strtoull_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__wcstol_internal"
		size = 32
		refs = "0012 ____wcstol_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_724_0_0 {
	meta:
		name = "__wcstoll_internal"
		size = 32
		refs = "0012 ____wcstoll_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__wcstoul_internal"
		size = 32
		refs = "0012 ____wcstoul_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_859_0_0 {
	meta:
		name = "__wcstoull_internal"
		size = 32
		refs = "0012 ____wcstoull_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "wcsftime"
		size = 32
		refs = "0012 __wcsftime_l 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "wcstol"
		size = 32
		refs = "0014 ____wcstol_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "strptime"
		size = 32
		refs = "0014 __strptime_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_938_1_0 {
	meta:
		name = "strtol"
		size = 32
		refs = "0014 ____strtol_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1305_1_0 {
	meta:
		name = "strtoll"
		size = 32
		refs = "0014 ____strtoll_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_804_1_0 {
	meta:
		name = "strtoul"
		size = 32
		refs = "0014 ____strtoul_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_819_1_0 {
	meta:
		name = "strtoull"
		size = 32
		refs = "0014 ____strtoull_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_724_1_0 {
	meta:
		name = "wcstoll"
		size = 32
		refs = "0014 ____wcstoll_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "wcstoul"
		size = 32
		refs = "0014 ____wcstoul_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_859_1_0 {
	meta:
		name = "wcstoull"
		size = 32
		refs = "0014 ____wcstoull_l_internal 001c __libc_tsd_LOCALE"
	strings:
		$1 = { 30 B5 1D EE 70 5F 05 4C 83 B0 00 23 7C 44 24 68 2C 59 00 94 ?? ?? ?? ?? 03 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "memfrob"
		size = 24
	strings:
		$1 = { 49 B1 01 44 03 46 13 F8 01 2B 8B 42 82 F0 2A 02 03 F8 01 2C F7 D1 70 47 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "sigignore"
		size = 42
		refs = "0014 memset 0022 __sigaction"
	strings:
		$1 = { 30 B5 A5 B0 24 AC 05 46 00 21 02 A8 80 22 01 23 44 F8 8C 3D ?? ?? ?? ?? 00 23 21 46 28 46 1A 46 22 93 ?? ?? ?? ?? 25 B0 30 BD }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "seteuid"
		size = 112
		refs = "000a __nptl_setxid 0048 __libc_do_syscall 0068 __libc_errno"
	strings:
		$1 = { 43 1C 01 46 00 B5 87 B0 11 D0 ?? ?2 0? 0? ?? ?2 0? 0? A3 B1 01 A8 4F F0 FF 33 D0 22 03 91 01 92 02 93 04 93 ?? ?? ?? ?? 07 B0 5D F8 04 FB 0E 4B 1D EE 70 2F 16 21 7B 44 1B 68 D1 50 F4 E7 4F F0 FF 30 4F F0 D0 0C 02 46 ?? ?? ?? ?? 10 F5 80 5F EA D9 06 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__libc_init_secure"
		size = 64
		refs = "0000 __libc_enable_secure_decided 0010 __geteuid 0016 __getuid 0022 .LANCHOR0 002e __getegid 0034 __getgid"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 10 B5 1B 68 03 B1 10 BD ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 84 42 18 BF 01 20 05 D0 ?? ?2 0? 0? ?? ?2 0? 0? 18 60 10 BD ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 20 1A 18 BF 01 20 F0 E7 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "fchmodat"
		size = 276
		refs = "0018 __have_atfcts 002a __libc_do_syscall 0050 strlen 005c procfd.11202 0078 __snprintf 0096 __atfct_seterrno 0100 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 33 F4 80 74 83 B0 80 46 0D 46 02 AF 91 46 47 D1 DB 05 4F D4 ?? ?2 0? 0? ?? ?2 0? 0? 26 68 00 2E 0D DB 40 F2 4D 1C ?? ?? ?? ?? 10 F5 80 5F 4B D8 04 37 BD 46 BD E8 F0 83 4F F0 FF 33 23 60 18 F1 64 0F 2B D0 2B 78 2F 2B 28 D0 28 46 ?? ?? ?? ?? 00 28 49 D0 00 F1 2E 03 ?? ?2 0? 0? 23 F0 07 03 00 F1 20 01 AD EB 03 0D ?? ?2 0? 0? 02 AC 43 46 00 95 20 46 ?? ?? ?? ?? 25 46 28 46 49 46 4F F0 0F 0C ?? ?? ?? ?? 10 F5 80 5F D1 D9 40 42 41 46 22 46 ?? ?? ?? ?? 4F F0 FF 30 C9 E7 00 24 EC E7 16 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 BD E7 12 4B 1D EE 70 2F 5F 21 4F F0 FF 30 7B 44 1B 68 D1 50 B3 E7 0E 4A 1D EE 70 1F 0E 4B 40 42 7A 44 12 68 88 50 7B 44 1B 68 CB 58 26 2B AA D0 4F F0 FF 30 A3 E7 08 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 D1 50 99 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "__dlclose"
		size = 26
		refs = "0002 dlclose_doit 000c _dlerror_run"
	strings:
		$1 = { 01 46 ?? ?2 0? 0? 08 B5 ?? ?2 0? 0? ?? ?? ?? ?? 00 38 18 BF 6F F0 00 00 08 BD }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__ptsname_internal"
		size = 568
		refs = "001c __isatty 0052 __ioctl 006c __xstat64 00b8 _itoa_word 0106 .LC0 0124 memcpy 0130 __fxstat64 017e __libc_ptyname1 019a strlen 01d6 __libc_ptyname2 01da .LC1 0208 __libc_errno"
	strings:
		$1 = { 2D E9 F0 47 1D EE 70 5F 7F 4C 88 B0 0E 46 91 46 7C 44 24 68 1F 46 80 46 2C 59 59 B1 ?? ?? ?? ?? 88 B9 7A 4B 19 22 10 46 7B 44 1B 68 EA 50 08 B0 BD E8 F0 87 76 4B 16 22 10 46 7B 44 1B 68 EA 50 08 B0 BD E8 F0 87 45 F2 30 41 40 46 C8 F2 04 01 01 AA ?? ?? ?? ?? 84 46 40 B3 6E 4B 7B 44 1B 68 EB 58 16 2B 13 D0 31 46 03 20 3A 46 ?? ?? ?? ?? 00 28 16 DB 3B 69 03 F4 70 43 B3 F5 00 5F 2C D0 65 4B 19 22 10 46 7B 44 1B 68 EA 50 CF E7 B9 F1 0A 0F 4A D8 61 4B 22 22 10 46 7B 44 1B 68 EA 50 C5 E7 5F 4B 7B 44 1B 68 E8 58 C0 E7 03 46 07 A9 0A 22 01 98 8D F8 1C C0 ?? ?? ?? ?? 0D F1 1D 02 12 1A 03 46 02 F1 09 01 49 45 1C D9 55 4B 22 22 10 46 7B 44 1B 68 EA 50 A9 E7 79 6A 3A 6A 21 F4 7F 60 20 F0 0F 00 C2 F3 0B 23 03 43 03 2B 04 D0 04 2B 38 D0 88 3B 07 2B C2 D8 4B 4B 00 20 7B 44 1B 68 EC 50 93 E7 ?? ?2 0? 0? ?? ?2 0? 0? BE E8 03 00 BE F8 00 E0 30 60 06 F1 09 00 71 60 19 46 A6 F8 08 E0 ?? ?? ?? ?? 9D E7 41 46 03 20 3A 46 ?? ?? ?? ?? 00 28 3D DB 7A 6A 3B 6A 22 F4 7F 60 20 F0 0F 00 C3 F3 0B 21 01 43 02 29 16 D0 04 29 35 D0 80 39 07 29 11 D9 34 4B 19 22 10 46 7B 44 1B 68 EA 50 63 E7 13 0B D2 B2 43 EA 01 53 23 F0 FF 03 13 43 C0 3B 3F 2B 82 D8 BE E7 19 0B ?? ?2 0? 0? 41 EA 02 52 ?? ?2 0? 0? DB B2 22 F0 FF 09 40 46 49 EA 03 09 CD F8 04 90 ?? ?? ?? ?? 4F EA 19 1A 82 45 17 D3 22 4B 19 22 10 46 7B 44 1B 68 EA 50 3C E7 1F 4B 7B 44 1B 68 E8 58 37 E7 19 0B D8 B2 41 EA 02 5C 2C F0 FF 0C 4C EA 00 00 80 38 3F 28 C1 D8 D3 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 09 F0 0F 09 ?? ?2 0? 0? 18 F8 0A C0 12 F8 09 E0 00 22 03 CB 86 F8 08 C0 86 F8 09 E0 30 60 71 60 B2 72 2F E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "ptsname"
		size = 42
		refs = "0002 .LANCHOR0 0010 __ptsname_internal"
	strings:
		$1 = { 00 B5 ?? ?2 0? 0? 9B B0 1E 22 6B 46 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 28 0C BF 18 46 00 20 1B B0 5D F8 04 FB }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "__ptsname_r"
		size = 16
		refs = "0006 __ptsname_internal"
	strings:
		$1 = { 00 B5 9B B0 6B 46 ?? ?? ?? ?? 1B B0 5D F8 04 FB }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "cbc_crypt"
		size = 248
		refs = "00c0 _des_crypt"
	strings:
		$1 = { 2D E9 F0 4F 8F B0 82 46 00 20 18 9C 01 93 06 90 50 07 94 F8 00 B0 94 F8 01 90 94 F8 02 80 94 F8 03 C0 27 79 66 79 A5 79 E3 79 8D F8 1C B0 8D F8 1D 90 8D F8 1E 80 8D F8 1F C0 8D F8 20 70 8D F8 21 60 8D F8 22 50 8D F8 23 30 0F D0 03 20 84 F8 00 B0 84 F8 01 90 84 F8 02 80 84 F8 03 C0 27 71 66 71 A5 71 E3 71 0F B0 BD E8 F0 8F B2 F5 00 5F EC D8 01 9D 08 46 9A F8 00 C0 11 46 9A F8 01 80 05 F0 01 03 9A F8 02 90 03 AA 9A F8 03 E0 9A F8 04 70 9A F8 05 60 9A F8 06 50 9A F8 07 A0 8D F8 0C C0 8D F8 0D 80 8D F8 0E 90 8D F8 0F E0 8D F8 10 70 8D F8 11 60 8D F8 12 50 8D F8 13 A0 05 93 ?? ?? ?? ?? 88 B9 02 20 9D F8 1C B0 9D F8 1D 90 9D F8 1E 80 9D F8 1F C0 9D F8 20 70 9D F8 21 60 9D F8 22 50 9D F8 23 30 B1 E7 01 9B 13 F0 02 0F 14 BF 00 20 01 20 E7 E7 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "ecb_crypt"
		size = 126
		refs = "0066 _des_crypt"
	strings:
		$1 = { 2D E9 F0 47 05 46 8E B0 50 07 4F F0 01 04 06 94 03 D0 03 20 0E B0 BD E8 F0 87 B2 F5 00 5F F8 D8 95 F8 00 80 08 46 95 F8 01 90 11 46 95 F8 02 A0 03 AA 95 F8 03 C0 1C 40 95 F8 04 E0 6F 79 AE 79 ED 79 8D F8 0C 80 01 93 8D F8 0D 90 8D F8 0E A0 8D F8 0F C0 8D F8 10 E0 8D F8 11 70 8D F8 12 60 8D F8 13 50 05 94 ?? ?? ?? ?? 01 9B 08 B9 02 20 D0 E7 13 F0 02 0F 14 BF 00 20 01 20 CA E7 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "strxfrm"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0012 __strxfrm_l"
	strings:
		$1 = { 05 4B 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1112_0_0 {
	meta:
		name = "__strtod_internal"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0012 ____strtod_l_internal"
	strings:
		$1 = { 05 4B 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_746_0_0 {
	meta:
		name = "__strtof_internal"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0012 ____strtof_l_internal"
	strings:
		$1 = { 05 4B 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_566_0_0 {
	meta:
		name = "__strtold_internal"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0012 ____strtold_l_internal"
	strings:
		$1 = { 05 4B 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1101_0_0 {
	meta:
		name = "__wcstod_internal"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0012 ____wcstod_l_internal"
	strings:
		$1 = { 05 4B 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1034_0_0 {
	meta:
		name = "__wcstof_internal"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0012 ____wcstof_l_internal"
	strings:
		$1 = { 05 4B 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_956_0_0 {
	meta:
		name = "__wcstold_internal"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0012 ____wcstold_l_internal"
	strings:
		$1 = { 05 4B 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "wcsxfrm"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0012 __wcsxfrm_l"
	strings:
		$1 = { 05 4B 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "endnetgrent_hook"
		size = 40
		refs = "000e .LC0 0016 __nss_lookup_function"
	strings:
		$1 = { 10 B5 04 46 80 6A 43 1E 03 33 00 D9 10 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 03 46 08 B1 20 46 98 47 00 23 A3 62 10 BD }
	condition:
		$1
}

rule file_95_1_0 {
	meta:
		name = "setup"
		size = 86
		refs = "0002 .LANCHOR0 0018 .LC1 003a __nss_netgroup_lookup 002a __nss_lookup"
	strings:
		$1 = { 70 B5 ?? ?2 0? 0? ?? ?2 0? 0? 0D 46 03 46 21 78 69 B1 64 68 62 1C 1C D0 ?? ?2 0? 0? 2C 60 28 46 ?? ?2 0? 0? 00 22 BD E8 70 40 ?? ?? ?? ?? ?? ?2 0? 0? 02 46 ?? ?2 0? 0? 28 46 ?? ?? ?? ?? 4F F0 FF 33 00 B9 2B 68 63 60 BF F3 5F 8F 01 23 23 70 70 BD 01 20 70 BD }
	condition:
		$1
}

rule file_95_2_0 {
	meta:
		name = "__internal_setnetgrent_reuse"
		size = 252
		refs = "0036 _dl_mcount_wrapper_check 0042 .LC1 005a __nss_next2 006e .LC0 0078 __nss_lookup_function 0092 strlen 009e malloc 00b0 memcpy 00d8 .LC2 00dc .LC3 00e0 __PRETTY_FUNCTION__.13761 00f2 __assert_fail 00f8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 47 01 F1 28 07 84 B0 06 46 08 46 0C 46 91 46 FF F7 B5 FF 39 46 03 A8 FF F7 C5 FF 00 28 34 D1 23 69 98 46 2B B1 56 E0 00 2B 30 D0 23 69 00 2B 51 D1 03 98 ?? ?? ?? ?? 03 9B 21 46 30 46 98 47 ?? ?2 0? 0? 03 AB ?? ?2 0? 0? 00 22 05 46 38 46 8D E8 20 01 D4 F8 28 A0 ?? ?? ?? ?? D0 F1 01 03 38 BF 00 23 01 2D 08 BF 00 28 DD D1 ?? ?2 0? 0? 50 46 ?? ?2 0? 0? ?? ?? ?? ?? 05 46 00 28 D5 D0 ?? ?? ?? ?? 20 46 A8 47 D0 E7 4F F0 FF 35 30 46 ?? ?? ?? ?? 02 46 05 30 02 F1 01 08 ?? ?? ?? ?? 07 46 68 B1 23 6A 31 46 42 46 40 F8 04 3B ?? ?? ?? ?? 6B 1E 58 42 27 62 58 41 04 B0 BD E8 F0 87 0D 4B 1D EE 70 2F 7B 44 1B 68 D3 58 C9 F8 00 30 04 B0 BD E8 F0 87 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 88 22 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_3_0 {
	meta:
		name = "nscd_getnetgrent"
		size = 68
		refs = "0018 __rawmemchr"
	strings:
		$1 = { 38 B5 04 46 02 69 43 69 80 69 13 44 98 42 16 D2 00 25 60 60 29 46 25 60 ?? ?? ?? ?? 29 46 01 30 A0 61 A0 60 ?? ?? ?? ?? 29 46 01 30 A0 61 E0 60 ?? ?? ?? ?? 01 23 18 44 A0 61 18 46 38 BD 4F F0 FF 33 FA E7 }
	condition:
		$1
}

rule file_95_4_0 {
	meta:
		name = "free_memory.isra.0"
		size = 46
		refs = "000e free"
	strings:
		$1 = { 38 B5 05 46 00 68 0C 46 30 B1 03 68 2B 60 ?? ?? ?? ?? 28 68 00 28 F8 D1 20 68 38 B1 03 68 23 60 ?? ?? ?? ?? 20 68 00 28 F8 D1 38 BD 38 BD }
	condition:
		$1
}

rule file_95_5_0 {
	meta:
		name = "__internal_setnetgrent"
		size = 44
		refs = "0028 __libc_errno"
	strings:
		$1 = { 38 B5 0C 46 05 46 24 31 04 F1 20 00 FF F7 E0 FF 05 4B 1D EE 70 2F 28 46 7B 44 1B 68 21 46 1A 44 BD E8 38 40 34 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_6_0 {
	meta:
		name = "setnetgrent"
		size = 196
		refs = "0024 __nss_not_use_nscd_netgroup 0040 __nss_database_custom 0050 __nscd_setnetgrent 0058 .LANCHOR0 008e __internal_setnetgrent 00ac __libc_do_syscall 00b4 __lll_lock_wait_private"
	strings:
		$1 = { 70 B5 01 22 2D 4C 06 46 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 46 D1 ?? ?2 0? 0? ?? ?2 0? 0? 1A 68 00 2A 2A DD 01 32 64 2A D2 BF 1A 60 00 22 1A 60 24 DD ?? ?2 0? 0? ?? ?2 0? 0? 9B 79 F3 B9 30 46 1C 49 ?? ?? ?? ?? 05 1E 18 DB ?? ?2 0? 0? 00 20 ?? ?2 0? 0? 93 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 06 00 2E F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 08 DC 28 46 70 BD DA D0 30 46 0C 49 ?? ?? ?? ?? 05 46 E0 E7 1D EE 70 1F 01 22 A1 F5 98 61 06 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E8 E7 20 46 ?? ?? ?? ?? B4 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_7_0 {
	meta:
		name = "__internal_endnetgrent"
		size = 22
	strings:
		$1 = { 10 B5 04 46 FF F7 8C FE 04 F1 20 00 04 F1 24 01 BD E8 10 40 64 E7 }
	condition:
		$1
}

rule file_95_8_0 {
	meta:
		name = "endnetgrent"
		size = 140
		refs = "002e .LANCHOR0 005e __lll_lock_wait_private 007a __libc_do_syscall"
	strings:
		$1 = { 38 B5 01 22 1E 4C BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F EB B9 18 48 FF F7 71 FE 18 48 01 1D FF F7 4D FF ?? ?2 0? 0? ?? ?2 0? 0? 00 20 93 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 05 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 04 DC 38 BD 20 46 ?? ?? ?? ?? DD E7 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EC E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_9_0 {
	meta:
		name = "__internal_getnetgrent_r"
		size = 284
		refs = "001a .LC4 0022 __nss_lookup_function 0036 _dl_mcount_wrapper_check 0062 strcmp 0090 strlen 0098 malloc 00aa memcpy 00f4 nscd_getnetgrent 0118 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 85 B0 1C 46 01 90 98 6A 02 91 03 92 10 9E 00 28 6A D0 43 1C 6C D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 82 46 00 28 5F D0 DF F8 E8 90 1D EE 70 8F 50 46 ?? ?? ?? ?? 4B 46 7B 44 1B 68 20 46 43 44 0E 99 0F 9A D0 47 02 28 31 D0 01 28 4C D1 23 68 01 2B 52 D1 25 6A 67 68 45 B1 38 46 29 1D ?? ?? ?? ?? 00 28 E4 D0 2D 68 00 2D F6 D1 D4 F8 24 B0 BB F1 00 0F 09 D0 5D 46 38 46 29 1D ?? ?? ?? ?? 00 28 D5 D0 2D 68 00 2D F6 D1 38 46 ?? ?? ?? ?? 07 46 05 30 ?? ?? ?? ?? 05 46 28 B3 28 46 7A 1C 40 F8 04 BB 61 68 ?? ?? ?? ?? 65 62 C0 E7 63 6A 0B B9 19 E0 68 B9 1F 68 18 1D 25 6A 21 46 32 46 67 62 1D 60 23 62 FF F7 17 FE 63 6A 00 2B F1 D1 50 B1 A0 6A 40 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 82 46 00 28 A3 D1 00 20 05 B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? 96 E7 63 68 01 9A 13 60 02 9A A3 68 13 60 03 9A E3 68 13 60 05 B0 BD E8 F0 8F 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_10_0 {
	meta:
		name = "__getnetgrent_r"
		size = 176
		refs = "0040 __internal_getnetgrent_r 0044 .LANCHOR0 0080 __lll_lock_wait_private 009e __libc_do_syscall 00a8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 88 B0 27 4C 80 46 0E 9F 01 25 BF F3 5F 8F 54 E8 00 0F 00 28 03 D1 44 E8 00 56 00 2E F7 D1 BF F3 5F 8F 38 BB 1F 4D 1D EE 70 6F 00 93 40 46 01 97 7D 44 2D 68 35 44 1C 4B 02 95 00 25 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 07 46 93 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 50 00 28 F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 0D DC 38 46 08 B0 BD E8 F0 81 20 46 07 91 06 92 05 93 ?? ?? ?? ?? 05 9B 06 9A 07 99 CD E7 A6 F5 98 66 01 22 04 48 00 23 B1 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? E5 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_11_0 {
	meta:
		name = "innetgr"
		size = 552
		refs = "0004 __nss_not_use_nscd_netgroup 0060 _dl_mcount_wrapper_check 0076 .LC0 0080 __nss_lookup_function 0096 .LC1 00a8 __nss_next2 00ca __nss_database_custom 00e0 __nscd_innetgr 00f6 .LC4 013c __strcasecmp 0150 strcmp 01b6 strlen 01c2 malloc 01d2 memcpy 0202 .LC5 0206 .LC3 020a __PRETTY_FUNCTION__.13980 021e __assert_fail 0224 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 9A 46 AD F2 4C 4D 0E 46 23 68 91 46 05 90 00 2B 54 DD 01 33 64 2B D2 BF 23 60 00 23 23 60 4E DC 05 99 00 22 DF F8 F0 81 07 92 08 92 04 91 09 92 0A 92 0B 92 0C 92 0D 92 0E 92 0F 92 10 92 11 92 06 A8 11 A9 FF F7 42 FD 60 BB 0B 9B 00 2B 40 F0 D2 80 06 98 ?? ?? ?? ?? 06 9B 04 98 07 A9 98 47 01 28 04 46 18 BF 00 25 3F D0 ?? ?2 0? 0? 11 98 ?? ?2 0? 0? ?? ?? ?? ?? 07 46 18 B1 ?? ?? ?? ?? 07 A8 B8 47 00 2D 40 F0 A5 80 ?? ?2 0? 0? 8D E8 30 00 2A 46 ?? ?2 0? 0? 11 A8 06 AB ?? ?? ?? ?? 00 28 D2 D0 10 9B 00 2B 00 F0 A0 80 19 68 1A 1D 04 92 0F 9A 10 91 1A 60 0F 93 C1 E7 B0 D1 ?? ?2 0? 0? ?? ?2 0? 0? 9B 79 00 2B A9 D1 05 98 31 46 4A 46 53 46 ?? ?? ?? ?? 00 28 A8 BF 05 46 9F DB 28 46 0D F2 4C 4D BD E8 F0 8F ?? ?2 0? 0? 11 98 ?? ?2 0? 0? ?? ?? ?? ?? 05 46 00 28 B5 D0 1D EE 70 2F 03 92 28 46 ?? ?? ?? ?? 03 99 43 46 07 A8 7B 44 1B 68 4F F4 80 62 0B 44 12 A9 A8 47 01 28 56 D1 07 9B 01 2B 1E D0 08 98 28 B1 26 B1 31 46 ?? ?? ?? ?? 00 28 E5 D1 09 98 38 B1 B9 F1 00 0F 04 D0 49 46 ?? ?? ?? ?? 00 28 DB D1 0A 98 38 B1 BA F1 00 0F 04 D0 51 46 ?? ?? ?? ?? 00 28 D1 D1 01 25 02 24 81 E7 0F 9F 08 9C 47 B1 20 46 39 1D ?? ?? ?? ?? 00 28 C5 D0 3F 68 00 2F F6 D1 10 9F 67 B1 BB 46 20 46 0B F1 04 01 ?? ?? ?? ?? 00 28 B8 D0 DB F8 00 B0 BB F1 00 0F F3 D1 05 98 21 46 ?? ?? ?? ?? 00 28 AD D0 20 46 ?? ?? ?? ?? 03 46 05 30 5A 1C 02 92 ?? ?? ?? ?? 02 9A 83 46 B8 B1 21 46 40 F8 04 7B ?? ?? ?? ?? CD F8 40 B0 99 E7 00 25 C6 E7 6B 1E 5D 42 5D 41 0F A8 10 A9 FF F7 41 FD 28 46 0D F2 4C 4D BD E8 F0 8F 1D 46 F4 E7 4F F0 FF 35 B5 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 A7 12 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__getsgnam_r"
		size = 280
		refs = "0004 .LANCHOR0 0042 _dl_mcount_wrapper_check 005c .LC0 008a __nss_next2 00e0 __nss_gshadow_lookup2 0108 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 46 87 B0 80 46 22 78 0F 46 9A 46 00 2A 5B D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 47 D1 DF F8 D8 B0 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 A0 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 23 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 0B D0 10 9A 14 60 0A D9 1A 4B 7B 44 1B 68 F0 58 22 28 26 D0 07 B0 BD E8 F0 8F 10 9B 1F 60 15 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 E4 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 9B E7 02 35 D6 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_811_0_0 {
	meta:
		name = "__getaliasbyname_r"
		size = 280
		refs = "0004 .LANCHOR0 0042 _dl_mcount_wrapper_check 005c .LC0 008a __nss_next2 00e0 __nss_aliases_lookup2 0108 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 46 87 B0 80 46 22 78 0F 46 9A 46 00 2A 5B D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 47 D1 DF F8 D8 B0 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 A0 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 23 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 0B D0 10 9A 14 60 0A D9 1A 4B 7B 44 1B 68 F0 58 22 28 26 D0 07 B0 BD E8 F0 8F 10 9B 1F 60 15 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 E4 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 9B E7 02 35 D6 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1417_0_0 {
	meta:
		name = "__getprotobyname_r"
		size = 280
		refs = "0004 .LANCHOR0 0042 _dl_mcount_wrapper_check 005c .LC0 008a __nss_next2 00e0 __nss_protocols_lookup2 0108 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 46 87 B0 80 46 22 78 0F 46 9A 46 00 2A 5B D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 47 D1 DF F8 D8 B0 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 A0 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 23 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 0B D0 10 9A 14 60 0A D9 1A 4B 7B 44 1B 68 F0 58 22 28 26 D0 07 B0 BD E8 F0 8F 10 9B 1F 60 15 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 E4 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 9B E7 02 35 D6 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1279_0_0 {
	meta:
		name = "__getprotobynumber_r"
		size = 280
		refs = "0004 .LANCHOR0 0042 _dl_mcount_wrapper_check 005c .LC0 008a __nss_next2 00e0 __nss_protocols_lookup2 0108 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 46 87 B0 80 46 22 78 0F 46 9A 46 00 2A 5B D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 47 D1 DF F8 D8 B0 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 A0 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 23 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 0B D0 10 9A 14 60 0A D9 1A 4B 7B 44 1B 68 F0 58 22 28 26 D0 07 B0 BD E8 F0 8F 10 9B 1F 60 15 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 E4 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 9B E7 02 35 D6 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "__getrpcbyname_r"
		size = 280
		refs = "0004 .LANCHOR0 0042 _dl_mcount_wrapper_check 005c .LC0 008a __nss_next2 00e0 __nss_rpc_lookup2 0108 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 46 87 B0 80 46 22 78 0F 46 9A 46 00 2A 5B D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 47 D1 DF F8 D8 B0 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 A0 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 23 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 0B D0 10 9A 14 60 0A D9 1A 4B 7B 44 1B 68 F0 58 22 28 26 D0 07 B0 BD E8 F0 8F 10 9B 1F 60 15 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 E4 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 9B E7 02 35 D6 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1505_0_0 {
	meta:
		name = "__getrpcbynumber_r"
		size = 280
		refs = "0004 .LANCHOR0 0042 _dl_mcount_wrapper_check 005c .LC0 008a __nss_next2 00e0 __nss_rpc_lookup2 0108 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 46 87 B0 80 46 22 78 0F 46 9A 46 00 2A 5B D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 47 D1 DF F8 D8 B0 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 A0 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 23 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 0B D0 10 9A 14 60 0A D9 1A 4B 7B 44 1B 68 F0 58 22 28 26 D0 07 B0 BD E8 F0 8F 10 9B 1F 60 15 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 E4 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 9B E7 02 35 D6 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_852_0_0 {
	meta:
		name = "__getspnam_r"
		size = 280
		refs = "0004 .LANCHOR0 0042 _dl_mcount_wrapper_check 005c .LC0 008a __nss_next2 00e0 __nss_shadow_lookup2 0108 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 46 87 B0 80 46 22 78 0F 46 9A 46 00 2A 5B D0 63 68 A2 68 B3 F1 FF 3C DC F1 00 00 04 93 50 EB 0C 00 05 92 00 28 47 D1 DF F8 D8 B0 1D EE 70 6F 03 97 05 98 00 24 ?? ?? ?? ?? 5B 46 7B 44 1B 68 05 9D 33 44 03 99 00 93 4A 46 53 46 40 46 A8 47 ?? ?2 0? 0? ?? ?2 0? 0? 22 46 05 AB 05 46 04 A8 AF 1C 09 D1 DF F8 A0 C0 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F 23 D0 00 27 00 95 01 97 ?? ?? ?? ?? 00 28 D5 D0 01 2D 03 9F 0B D0 10 9A 14 60 0A D9 1A 4B 7B 44 1B 68 F0 58 22 28 26 D0 07 B0 BD E8 F0 8F 10 9B 1F 60 15 4B 20 46 7B 44 1B 68 F4 50 07 B0 BD E8 F0 8F 4F F0 FF 35 1D EE 70 6F 10 9F 00 23 3B 60 E4 E7 ?? ?2 0? 0? 04 A8 ?? ?2 0? 0? 05 AB ?? ?? ?? ?? 60 B9 05 9A 04 9B A2 60 63 60 BF F3 5F 8F 01 23 23 70 9B E7 02 35 D6 D0 16 24 D9 E7 4F F0 FF 33 63 60 F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__openat64_2"
		size = 26
		refs = "000e .LC0 0016 __fortify_fail 000a __openat64"
		altNames = "__openat_2"
	strings:
		$1 = { 08 B5 53 06 03 D4 BD E8 08 40 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1015_6_0 {
	meta:
		name = "free_mem"
		size = 18
		refs = "0002 __rpc_thread_variables 000e free"
	strings:
		$1 = { 08 B5 ?? ?? ?? ?? BD E8 08 40 D0 F8 98 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__getlogin_r_chk"
		size = 18
		refs = "000e __chk_fail 000a getlogin_r"
	strings:
		$1 = { 91 42 08 B5 03 D8 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1450_0_0 {
	meta:
		name = "__getcwd_chk"
		size = 18
		refs = "000e __chk_fail 000a __getcwd"
	strings:
		$1 = { 91 42 08 B5 03 D8 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_855_0_0 {
	meta:
		name = "__getdomainname_chk"
		size = 18
		refs = "000e __chk_fail 000a getdomainname"
	strings:
		$1 = { 91 42 08 B5 03 D8 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_850_0_0 {
	meta:
		name = "__gethostname_chk"
		size = 18
		refs = "000e __chk_fail 000a __gethostname"
	strings:
		$1 = { 91 42 08 B5 03 D8 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__vswprintf_chk"
		size = 128
		refs = "0018 _IO_wstrn_jumps 002c _IO_no_init 0034 _IO_fwide 0052 _IO_wstr_init_static 005c _IO_vfwprintf 007c __chk_fail"
	strings:
		$1 = { 8B 42 F0 B5 0C 46 AD F5 1D 7D 06 46 17 46 35 D3 00 25 44 95 00 29 2E D0 ?? ?2 0? 0? 2A 46 32 A8 ?? ?2 0? 0? 4F F4 00 41 00 93 03 AB ?? ?? ?? ?? 01 21 32 A8 ?? ?? ?? ?? 00 2F 31 46 04 F1 FF 32 C8 BF 41 9B 32 A8 35 60 C4 BF 43 F0 04 03 41 93 33 46 ?? ?? ?? ?? A2 99 A3 9A 32 A8 ?? ?? ?? ?? 49 9B 5C A9 9A 69 8A 42 05 D0 1B 69 00 22 1A 60 0D F5 1D 7D F0 BD 4F F0 FF 30 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "read_int"
		size = 76
	strings:
		$1 = { 03 68 70 B4 4C F6 CC 46 13 F8 01 2B C0 F6 CC 46 30 3A 13 E0 00 2A 10 DB 02 EB 82 05 4F F6 FF 74 B2 42 C7 F6 FF 74 4F EA 45 02 C1 EB 04 04 02 DC A2 42 0A 44 01 DD 4F F0 FF 32 01 33 03 60 19 78 30 39 09 29 E6 D9 10 46 70 BC 70 47 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__parse_one_specmb"
		size = 1204
		refs = "00c8 __printf_modifier_table 01a6 __printf_function_table 0352 __strchrnul 0476 __handle_registered_modifier_mb 0486 __printf_arginfo_table"
	strings:
		$1 = { 2D E9 F0 41 14 46 92 F8 0C C0 05 46 52 7B 82 B0 0E 46 0C F0 87 01 02 F0 F6 02 4F F0 FF 37 20 20 05 F1 01 08 67 62 6F F3 82 02 6F F3 C7 11 62 73 20 61 1F 46 21 73 CD F8 04 80 68 78 A0 F1 30 03 09 2B 88 BF 42 46 40 F2 FE 80 30 23 20 38 29 28 20 D8 DF E8 00 F0 9B 1F 1F 96 1F 1F 1F 91 1F 1F 1F 8C 1F 87 1F 1F 85 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 1F 15 61 7B 41 F0 08 01 61 73 55 1C 01 95 50 78 2A 46 00 28 DB D1 23 7B 00 25 65 60 98 06 44 BF 20 23 23 61 4F F0 FF 33 23 62 13 78 2A 2B 00 F0 EF 80 30 3B 09 2B 40 F2 F8 80 4F F0 FF 33 E3 61 23 60 13 78 2E 2B 00 F0 CD 80 ?? ?2 0? 0? 61 7B ?? ?2 0? 0? 20 7B 6F F3 41 01 61 73 19 68 00 F0 FC 03 6F F3 82 03 00 20 23 73 E0 81 00 29 40 F0 BB 81 51 1C 01 91 13 78 4C 3B 2E 2B 00 F2 6F 81 DF E8 13 F0 DB 00 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 4A 00 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 6D 01 E2 00 6D 01 F4 00 6D 01 FB 00 6D 01 6D 01 6D 01 6D 01 DB 00 6D 01 6D 01 4A 00 6D 01 6D 01 6D 01 6D 01 6D 01 4A 00 23 61 91 E7 21 7B 41 F0 20 01 21 73 8C E7 21 7B 41 F0 40 01 21 73 87 E7 21 7B 41 F0 80 01 21 73 82 E7 21 7B 41 F0 08 01 21 73 7D E7 21 7B 41 F0 10 01 21 73 78 E7 23 7B 90 1C 0A 46 03 F0 FE 03 6F F3 82 03 23 73 ?? ?2 0? 0? 01 90 ?? ?2 0? 0? 12 78 4F F0 FF 31 21 63 1B 68 A2 60 00 2B 40 F0 62 81 13 46 A3 F1 41 02 01 21 E1 62 37 2A 00 F2 07 81 DF E8 12 F0 E4 00 05 01 E1 00 05 01 E4 00 E4 00 E4 00 05 01 05 01 05 01 05 01 05 01 05 01 05 01 05 01 05 01 05 01 05 01 DE 00 05 01 05 01 05 01 05 01 9C 00 05 01 05 01 05 01 05 01 05 01 05 01 05 01 05 01 E4 00 05 01 B4 00 9C 00 E4 00 E4 00 E4 00 05 01 9C 00 05 01 05 01 05 01 05 01 D7 00 9C 00 D4 00 05 01 05 01 DB 00 05 01 9C 00 05 01 05 01 9C 00 01 A8 FF F7 B4 FE 20 B1 01 9B 1A 78 24 2A 00 F0 DD 80 CD F8 04 80 42 46 68 78 F3 E6 51 1C 01 91 53 78 2A 2B 00 F0 C3 80 30 3B 09 2B 82 BF 00 23 0A 46 23 60 3F F6 25 AF 01 A8 FF F7 98 FE 43 1C 18 BF 20 60 01 9A 1C E7 55 1C 01 95 53 78 30 3B 09 2B 40 F2 8B 80 26 62 2A 46 01 95 01 36 01 25 07 E7 01 A8 FF F7 83 FE 01 9A 43 1C 18 BF 60 60 FF E6 0A 46 23 7B 50 1C 43 F0 01 03 23 73 6F E7 53 78 68 2B 17 BF 90 1C D0 1C 23 7B 0A 46 05 BF 63 7B 02 32 43 F0 02 03 43 F0 02 03 14 BF 23 73 63 73 5D E7 23 7B 90 1C 0A 46 43 F0 05 03 23 73 56 E7 23 7B 43 F0 04 03 23 73 53 78 6C 2B 00 F0 93 80 90 1C 0A 46 4B E7 22 7B D7 07 44 BF 4F F4 80 72 A2 62 12 D4 50 07 44 BF 4F F4 00 72 A2 62 0C D4 91 07 44 BF 4F F4 80 62 A2 62 06 D4 62 7B C2 F3 40 02 00 2A 37 D0 01 22 A2 62 62 6A 01 32 0B D0 8B B1 01 9B 25 21 18 46 63 61 ?? ?? ?? ?? A0 61 28 46 02 B0 BD E8 F0 81 E2 6A 00 2A F0 D0 15 44 66 62 00 2B ED D1 01 9B 28 46 01 3B A3 61 63 61 02 B0 BD E8 F0 81 05 22 A2 62 DE E7 4F F4 00 62 A2 62 DA E7 03 22 A2 62 D7 E7 04 22 A2 62 D4 E7 02 22 A2 62 D1 E7 22 7B D2 07 5C BF 07 22 A2 62 CB D5 40 F2 07 12 A2 62 C7 E7 01 A8 FF F7 FE FD A8 B1 01 9A 13 78 24 2B 11 D1 41 1C 06 D0 43 1E 23 62 3B 68 83 42 2C BF 3B 60 38 60 01 32 23 6A 01 92 05 E0 08 46 E2 E6 00 22 E2 62 AD E7 23 6A 00 2B FF F6 57 AF 01 9A 00 25 61 E6 02 F1 02 08 CD F8 04 80 93 78 30 3B 09 2B 16 D9 E6 61 01 35 CD F8 04 80 42 46 01 36 5A E6 45 1C 03 F1 01 02 01 92 06 D0 41 1E 61 62 39 68 81 42 2C BF 39 60 38 60 58 78 0D E6 02 32 43 E7 01 A8 FF F7 BE FD 18 B1 01 9A 13 78 24 2B 04 D0 E3 69 00 2B BF F6 20 AF DB E7 41 1C 06 D0 43 1E E3 61 3B 68 83 42 2C BF 3B 60 38 60 01 32 E3 69 01 92 EE E7 13 78 51 F8 23 30 00 2B 3F F4 3F AE 01 A8 21 46 ?? ?? ?? ?? 01 9A 00 28 7F F4 37 AE 50 1C 8F E6 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 53 F8 22 70 00 2F 3F F4 94 AE 04 F1 30 03 20 46 01 21 04 F1 28 02 B8 47 A3 68 00 28 E0 62 BF F6 48 AF 87 E6 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "putgrent"
		size = 524
		refs = "0066 .LC0 0070 .LC3 0080 fprintf 0096 .LC2 009a .LC1 0166 __libc_do_syscall 0178 .LC4 01f8 __overflow 0200 __lll_lock_wait_private 0208 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 06 46 82 B0 0D 46 00 28 00 F0 C0 80 00 29 00 F0 BD 80 0B 68 18 04 1D D4 88 6C 1D EE 70 4F A4 F5 98 64 83 68 A3 42 12 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 F0 DA 80 AB 6C 18 46 9C 60 43 68 01 33 43 60 32 68 13 78 2B 2B 18 BF 2D 2B 40 F0 83 80 ?? ?2 0? 0? 73 68 ?? ?2 0? 0? ?? ?2 0? 0? 00 2B 08 BF 03 46 ?? ?2 0? 0? 28 46 ?? ?? ?? ?? 00 28 C0 F2 8D 80 F3 68 00 2B 3B D0 1A 68 00 2A 38 D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 24 03 E0 F3 68 53 F8 24 20 52 B3 00 2C 14 BF 41 46 39 46 28 46 ?? ?? ?? ?? 01 34 00 28 F1 DA 2B 68 1A 04 17 D4 A8 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 25 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 6E DC 4F F0 FF 34 20 46 02 B0 BD E8 F0 81 6B 69 AA 69 93 42 71 D2 00 24 59 1C 0A 22 69 61 1A 70 2B 68 1B 04 EF D4 A8 6C 43 68 01 3B 43 60 00 2B E9 D1 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 25 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B D6 DD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? C9 E7 B4 68 ?? ?2 0? 0? 73 68 ?? ?2 0? 0? ?? ?2 0? 0? 00 2B 08 BF 03 46 00 94 ?? ?2 0? 0? 28 46 ?? ?? ?? ?? 79 E7 1D 4B 1D EE 70 2F 16 21 4F F0 FF 34 7B 44 1B 68 D1 50 AD E7 2B 68 19 04 A8 D4 A8 6C 43 68 01 3B 43 60 00 2B A2 D1 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F 8F D0 EF E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 83 E7 28 46 0A 21 ?? ?? ?? ?? C4 17 8C E7 ?? ?? ?? ?? 22 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "svc_exit"
		size = 26
		refs = "0002 __rpc_thread_svc_pollfd 000c free 0012 __rpc_thread_svc_max_pollfd"
	strings:
		$1 = { 38 B5 ?? ?? ?? ?? 00 24 05 46 00 68 ?? ?? ?? ?? 2C 60 ?? ?? ?? ?? 04 60 38 BD }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "svc_run"
		size = 220
		refs = "0004 __rpc_thread_svc_max_pollfd 001a __rpc_thread_svc_pollfd 002c realloc 0066 __poll 0076 svc_getreq_poll 0090 _libc_intl_domainname 0094 .LC1 00a2 __dcgettext 00a6 perror 00b8 .LC0 00d8 __libc_errno 00b0 free"
	strings:
		$1 = { 2D E9 F8 4F ?? ?? ?? ?? 00 27 DF F8 CC 90 3C 46 BA 46 80 46 D8 F8 00 50 25 B9 ?? ?? ?? ?? 03 68 00 2B 42 D0 AF 42 29 D0 20 46 E9 00 ?? ?? ?? ?? 00 28 3F D0 04 46 AB 46 2F 46 00 2D 0F DD ?? ?? ?? ?? E9 00 00 23 05 68 EE 58 E8 18 E2 18 E6 50 08 33 80 88 8B 42 A2 F8 06 A0 90 80 F4 D1 59 46 20 46 4F F0 FF 32 ?? ?? ?? ?? 43 1C 08 D0 00 28 D0 D0 01 46 20 46 ?? ?? ?? ?? CB E7 BB 46 DC E7 4B 46 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B C1 D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?? ?? ?? 20 46 BD E8 F8 4F ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?? ?? ?? 20 46 BD E8 F8 4F ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "_dl_important_hwcaps"
		size = 1596
		refs = "0004 _dl_hwcap 0010 _dl_hwcap_mask 00e0 _dl_sysinfo_map 016e .LC0 0178 memcmp 01ba _dl_arm_cap_flags 021c strlen 0286 .LC1 0318 malloc 0372 mempcpy 060e .LC4 061a _dl_signal_error 061e .LC2 0622 .LC3 0626 __PRETTY_FUNCTION__.11588 0638 __assert_fail"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? 99 B0 ?? ?2 0? 0? 00 AF ?? ?2 0? 0? ?? ?2 0? 0? C7 F8 44 A0 D6 E9 00 AB BE 64 06 1C B8 63 18 BF 01 26 C7 E9 0C AB D7 F8 44 B0 39 62 D7 E9 0C 01 DB E9 00 AB FE 63 FA 61 C7 E9 0A AB 0A EA 00 0A 0B EA 01 0B 7B 62 5A EA 0B 01 3E 64 C7 E9 16 AB 42 D0 00 26 D7 F8 40 E0 31 46 01 20 D7 F8 5C B0 C6 F1 20 08 D7 F8 58 A0 A6 F1 20 0C 4F F0 00 09 01 31 0B FA 08 F8 2B FA 0C FC 2A FA 06 F4 2B FA 06 F5 44 EA 08 04 4F F0 01 08 44 EA 0C 04 09 EA 05 09 08 EA 04 08 C1 F1 20 06 58 EA 09 0C A1 F1 20 0C 20 FA 06 F6 00 FA 0C F3 D7 E9 16 AB 43 EA 06 03 00 FA 01 F2 18 BF 0E F1 01 0E D2 F1 00 08 63 EB 43 09 0E 46 08 EA 0A 08 09 EA 0B 09 58 EA 09 0B C3 D1 C7 F8 40 E0 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 FB 64 00 2B 4D D0 B3 F8 58 B1 D3 F8 50 21 BB F1 00 0F 46 D0 91 46 4F F0 00 0A 05 E0 0A F1 01 0A 09 F1 20 09 D3 45 3C D9 D9 F8 00 30 04 2B F5 D1 D7 F8 4C C0 D9 F8 14 60 D9 F8 08 50 DC F8 00 30 0C 2E 1D 44 2C 46 05 F1 0C 00 10 D8 E6 E7 94 E8 0C 00 03 32 03 33 22 F0 03 02 23 F0 03 03 13 44 0C 33 1C 44 04 F1 0C 00 43 1B 9E 42 D6 D9 A3 68 02 2B EC D1 D4 F8 00 80 B8 F1 04 0F 02 D0 42 46 63 68 E6 E7 ?? ?2 0? 0? 42 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 F3 D1 63 68 0A 2B 00 F2 D7 81 42 46 D7 E7 D7 F8 40 A0 01 23 0A F1 01 06 4F F0 00 0A F2 00 08 32 AD EB 02 0D C7 F8 4C D0 D7 E9 16 01 01 43 00 F0 1D 82 00 25 BE 64 4F F0 01 09 2E 46 ?? ?2 0? 0? D0 46 ?? ?2 0? 0? D7 E9 16 AB BC 65 C6 F1 20 01 2A FA 06 F4 0B FA 01 FE A6 F1 20 00 44 EA 0E 04 2B FA 00 FE 44 EA 0E 04 2B FA 06 F5 01 22 00 23 22 40 2B 40 52 EA 03 0C 27 D0 FB 6C 06 EB 86 0E BA 6D 09 FA 00 F0 78 65 03 EB C8 0C 02 EB 4E 00 43 F8 38 00 79 60 08 F1 01 08 C7 F8 00 C0 ?? ?? ?? ?? 79 68 09 FA 06 FE 7B 6D 29 FA 01 F2 C7 F8 50 E0 1A 43 7A 65 D7 E9 14 23 D7 F8 00 C0 8A EA 02 0A 8B EA 03 0B CC F8 04 00 5A EA 0B 03 06 F1 01 06 BB D1 C2 46 BE 6C 08 F1 01 05 BD 64 FD 6B 00 2D 00 F0 65 81 D7 F8 4C 80 BD 6B 08 EB CA 03 48 F8 3A 50 D7 F8 48 80 3D 6A 08 F1 01 02 5D 60 D7 F8 48 80 96 42 F9 6C ?? ?2 0? 0? D7 F8 4C A0 ?? ?2 0? 0? 4F EA C8 04 4F F0 03 00 21 44 4A F8 38 30 48 60 40 F0 BC 81 01 2E 00 F0 06 81 FB 6C 02 2E 5B 68 03 F1 05 00 BB 65 23 D9 41 00 02 23 01 20 FD 6C 01 E0 18 46 13 46 05 EB C0 00 5A 1C 96 42 40 68 00 F1 01 00 01 44 F4 D1 03 2E 0B D0 1F 2E 00 F2 94 81 BD 6C 01 F1 40 02 C5 F1 22 03 32 FA 03 F3 40 F0 8B 81 D7 F8 48 80 A8 F1 02 03 01 FA 03 F0 01 25 D7 F8 1C 80 05 FA 06 F3 7B 64 C8 F8 00 30 4F EA C3 08 40 44 ?? ?? ?? ?? 81 46 00 28 00 F0 74 81 02 2E 09 EB 08 00 C9 F8 00 00 C9 F8 08 00 00 F0 5C 81 D7 F8 4C A0 4F F0 2F 08 D7 F8 48 B0 54 44 D7 F8 48 C0 DA F8 00 30 05 FA 0B FA C7 F8 40 90 AB 46 99 46 55 46 A2 46 0C F1 FF 3C FE 63 C7 F8 50 C0 ?? ?2 0? 0? 03 22 ?? ?2 0? 0? 02 3D ?? ?? ?? ?? 56 46 3C 6D 00 F8 01 8B 03 E0 01 3C A6 F1 08 06 0C D0 0B FA 04 F3 2B 42 F7 D0 16 E9 06 00 08 3E ?? ?? ?? ?? 01 3C 00 F8 01 8B F2 D1 49 46 BA 6D ?? ?? ?? ?? 00 F8 01 8B 00 2D D9 D1 D7 F8 40 90 FE 6B 01 23 13 FA 06 F0 1E BF 00 23 C0 00 19 46 05 D0 09 EB 03 02 08 33 83 42 51 60 F9 D1 D7 F8 4C 80 4F F0 01 0C 08 EB C6 05 D7 F8 44 80 01 3E 09 F1 08 02 0C FA 06 F1 43 46 B8 F1 00 0F 13 D0 01 3B 19 42 0D D0 55 F8 04 4C 01 3B 52 F8 04 0C 19 42 04 F1 01 04 02 F1 08 02 20 44 42 F8 0C 0C F1 D1 08 32 00 2B EB D1 08 3D 00 2E DF D1 01 24 7D 6C BE 6C 09 F1 10 08 AB 1E B4 40 A3 42 23 D0 09 F1 18 01 42 46 09 F1 08 0C 4E 46 01 3B C9 EB 02 00 DD 07 02 F1 08 02 4C BF 80 19 60 44 01 F1 08 01 45 BF 50 F8 10 5C 50 F8 0C 0C 50 F8 10 0C 40 19 A3 42 41 F8 10 0C E8 D1 7D 6C 05 F1 00 52 02 3A D2 1A 08 EB C2 08 6F F0 07 01 BE 6C 08 F1 08 08 B1 40 08 EB 01 02 01 3B 08 F1 08 08 52 F8 08 2C 02 F1 04 02 48 F8 10 2C F3 D1 D7 F8 24 80 48 46 D9 F8 04 30 64 37 C8 F8 00 30 BD 46 BD E8 F0 8F D7 F8 4C B0 02 25 D7 F8 1C C0 DB F8 04 40 CC F8 00 50 04 F1 11 00 66 1C ?? ?? ?? ?? 81 46 00 28 00 F0 98 80 D7 F8 1C A0 22 46 46 60 00 F1 10 04 D7 F8 4C B0 00 21 DA F8 00 30 C1 60 DA F8 00 00 09 EB C3 03 DB F8 00 10 C9 F8 08 30 C9 F8 00 40 09 EB C0 00 ?? ?? ?? ?? D7 F8 24 C0 2F 23 64 37 03 70 48 46 CA F8 00 50 D9 F8 04 30 CC F8 00 30 BD 46 BD E8 F0 8F BA 6C C7 F8 48 A0 A3 E6 3D 6C 1A 46 23 69 08 3A 6E 1C 65 69 1E 44 18 34 04 EB 02 08 D7 F8 48 C0 F3 00 4F EA 55 3B 08 33 4F EA C5 4A AD EB 03 0D D7 E9 0C 23 44 45 C7 F8 4C D0 42 EA 0A 02 43 EA 0B 03 C7 E9 02 23 D7 E9 0A 23 43 EA 0B 03 42 EA 0A 02 D7 E9 02 AB CC E9 00 AB D7 F8 44 A0 CA E9 00 23 82 46 28 BF 01 23 BF F4 06 AE D7 F8 4C B0 4F F0 01 09 BE 64 66 1C 30 46 ?? ?? ?? ?? 22 78 09 FA 02 F2 2A 42 1D BF 4B F8 3A 60 0B EB CA 02 0A F1 01 0A B9 6C 00 F1 01 04 08 BF 01 F1 FF 31 34 44 14 BF 50 60 B9 64 A0 45 E4 D8 D7 E9 16 01 0A F1 01 03 BE 6C 01 43 7F F4 E3 AD BB 64 36 E6 FB 6C 2F 24 99 68 DA 68 ?? ?? ?? ?? FD 6C BA 6D 29 68 00 F8 01 4B ?? ?? ?? ?? 04 70 D5 E6 00 21 ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 0C 20 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A6 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 30
		refs = "0000 _IO_stdin 001a __uflow"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 18 68 43 68 82 68 93 42 03 D2 5A 1C 42 60 18 78 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__mpn_mul"
		size = 542
		refs = "001e __mpn_mul_1 003a __mpn_addmul_1 0068 __mpn_add_n 00a6 __mpn_impn_mul_n 0118 __mpn_mul"
	strings:
		$1 = { 2D E9 F0 4F 8B B0 02 AF 9A 46 80 46 BC 6C 8B 46 15 46 1F 2C 34 DC 74 B3 1B 68 01 2B 58 D9 ?? ?? ?? ?? 4F EA 85 09 01 2C C1 44 48 F8 25 00 08 F1 04 06 21 DD 08 EB 84 08 07 E0 ?? ?? ?? ?? 04 46 04 36 49 F8 04 4F 46 45 15 D0 5A F8 04 4F 30 46 59 46 2A 46 01 2C 23 46 4F F0 00 04 ED D8 EF D1 31 46 5A 46 2B 46 04 36 ?? ?? ?? ?? 46 45 04 46 49 F8 04 4F E9 D1 20 46 24 37 BD 46 BD E8 F0 8F 4F EA C4 09 4F EA 84 0C 09 F1 08 09 1A 46 AD EB 09 0D 23 46 02 AE BE 61 2E 1B FE 61 BE 69 E3 44 C7 F8 00 C0 00 96 ?? ?? ?? ?? FA 69 D7 F8 00 C0 94 42 08 EB 0C 06 61 DD FA 69 2A BB 2C 44 24 37 04 F1 80 44 01 3C 58 F8 24 00 BD 46 BD E8 F0 8F 4F EA 82 09 0C D0 00 2A C2 BF 03 46 00 EB 09 01 00 22 03 DD 43 F8 04 2B 8B 42 FB D1 00 20 9A E7 00 2A C8 BF 00 23 F9 DD 5B F8 03 20 48 F8 03 20 04 33 4B 45 F8 D1 F1 E7 FB 69 51 46 22 46 B8 69 C7 F8 00 C0 00 93 5B 46 ?? ?? ?? ?? 31 46 BA 69 23 46 30 46 ?? ?? ?? ?? BA 69 D7 F8 00 C0 52 F8 24 30 06 EB 0C 01 62 44 04 31 04 32 18 44 46 F8 24 00 83 42 0A D9 FB 69 01 3B B7 D0 52 F8 04 0B 01 30 41 F8 04 0B 00 28 F6 D0 FB 61 91 42 AD D0 FE 69 01 2E AA DD 06 F1 80 46 00 23 01 3E B6 00 D0 58 C8 50 04 33 B3 42 FA D1 9F E7 AD EB 09 0D 7D 60 02 AB FB 61 FD 69 63 44 C7 F8 08 80 E0 46 C4 EB 02 09 7B 61 62 42 04 33 3A 61 FB 60 BA 69 28 46 59 46 23 46 00 92 52 46 ?? ?? ?? ?? 31 46 30 46 2A 46 23 46 46 44 ?? ?? ?? ?? 7A 69 F9 68 13 68 32 1D 18 44 30 60 83 42 20 46 24 D8 8A 42 0D D0 01 28 0B DD 00 F1 80 40 00 23 01 38 A4 46 80 00 CC 58 D4 50 04 33 83 42 FA D1 64 46 3B 69 4A 46 C3 44 99 44 04 EB 09 03 9C 42 CF DD C4 46 FA 61 D7 F8 08 80 7D 68 56 E7 51 F8 04 3B 01 33 42 F8 04 3B 00 2B DA D1 01 38 F6 D1 E7 E7 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__gets_chk"
		size = 396
		refs = "000e _IO_stdin 005a _IO_getline 0100 __uflow 010c __chk_fail 0162 __libc_do_syscall 0168 _Unwind_Resume 0186 __lll_lock_wait_private"
	strings:
		$1 = { 2D E9 F0 43 0F 46 83 B0 06 46 00 29 7E D0 ?? ?2 0? 0? ?? ?2 0? 0? 25 68 2B 68 1A 04 4B D5 2A 46 53 68 91 68 8B 42 6A D2 59 1C 51 60 18 78 0A 28 61 D0 D4 F8 00 C0 31 46 4F F0 00 09 7A 1E 0A 23 DC F8 00 E0 2E F0 20 08 CC F8 00 80 01 F8 01 0B 0E F0 20 08 20 68 CD F8 00 90 ?? ?? ?? ?? 23 68 01 30 1A 68 91 06 4F D4 48 EA 02 02 1A 60 B8 42 3C BF 00 23 33 54 4B D2 2B 68 1A 04 17 D4 A8 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 5E DC 30 46 03 B0 BD E8 F0 83 A8 6C 1D EE 70 8F A8 F5 98 68 83 68 43 45 19 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 50 D1 AB 6C 22 68 18 46 C3 F8 08 80 43 68 01 33 43 60 94 E7 00 20 B9 E7 2A 46 F7 E7 10 46 ?? ?? ?? ?? 43 1C 92 D1 00 26 B5 E7 ?? ?? ?? ?? ?? ?? ?? ?? 2B 68 04 46 1B 04 24 D4 AB 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 15 00 2D F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 93 E7 ?? ?? ?? ?? AB E7 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__ftruncate64"
		size = 48
		refs = "0008 __libc_do_syscall 002c __libc_errno"
	strings:
		$1 = { 00 B5 00 21 4F F0 C2 0C ?? ?? ?? ?? 10 F5 80 5F 01 D8 5D F8 04 FB 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__libc_fork"
		size = 556
		refs = "0000 __fork_handlers 008e _IO_list_lock 00ba __libc_do_syscall 00d4 __fork_generation_pointer 00e6 __nptl_set_robust 00fa _IO_iter_begin 0108 _IO_iter_file 011c _IO_iter_next 0122 _IO_iter_end 012a _IO_list_resetlock 012e _dl_load_lock 015a __fork_lock 018a _IO_list_unlock 01ec .LC2 01f0 .LC1 01f4 __PRETTY_FUNCTION__.13209 0206 __assert_fail 020a .LC0 0228 __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? 2D E9 F8 4F ?? ?2 0? 0? 00 AF 0C 68 ?? ?2 0? 0? ?? ?2 0? 0? 00 2C 00 F0 E5 80 BF F3 5F 8F 62 69 00 2A F2 D0 1B 68 55 1C BF F3 5F 8F 14 33 53 E8 00 0F 90 42 03 D1 43 E8 00 56 00 2E F7 D1 82 42 BF F3 5F 8F E1 D1 00 26 13 E0 04 F1 14 02 63 69 BF F3 5F 8F 58 1C 52 E8 00 1F 99 42 04 D1 42 E8 00 0C BC F1 00 0F F6 D1 8B 42 BF F3 5F 8F EE D1 2E 46 63 68 03 B1 98 47 84 B0 6D 46 00 94 24 68 01 96 00 2C E1 D1 1D EE 70 9F ?? ?? ?? ?? A9 F5 98 68 00 21 11 20 A9 F5 8B 64 D8 F8 6C A0 C0 F2 20 10 D8 F8 68 B0 0A 46 CA F1 00 06 0B 46 C8 F8 6C 60 4F F0 78 0C ?? ?? ?? ?? 10 F5 80 5F 06 46 53 D8 00 28 59 D1 D8 F8 68 20 5A 45 00 F0 9B 80 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 13 B1 19 68 04 31 19 60 ?? ?2 0? 0? C8 F8 6C 20 ?? ?2 0? 0? 13 B1 40 46 ?? ?? ?? ?? ?? ?? ?? ?? 4F F0 00 08 04 46 0D E0 20 46 ?? ?? ?? ?? 83 6C 20 46 C3 F8 00 80 C3 F8 04 80 C3 F8 08 80 ?? ?? ?? ?? 04 46 ?? ?? ?? ?? 84 42 ED D1 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 22 01 24 1A 60 5A 60 9A 60 1A 61 5A 61 DC 60 45 B1 2B 68 DA 68 0A B1 90 47 2B 68 6D 68 5C 61 00 2D F6 D1 ?? ?2 0? 0? 00 22 ?? ?2 0? 0? 1A 60 30 46 BD 46 BD E8 F8 8F 2E 4B 4F F0 FF 36 42 42 7B 44 1B 68 49 F8 03 20 D8 F8 68 30 5B 45 32 D1 C8 F8 6C A0 ?? ?? ?? ?? 85 B9 E9 E7 2B 68 99 69 49 B1 D8 F8 08 10 4F F0 F0 0C 58 69 00 23 41 F0 01 01 ?? ?? ?? ?? 6D 68 00 2D D9 D0 2B 68 9A 68 0A B1 90 47 2B 68 03 F1 14 01 5A 69 BF F3 5F 8F 54 1E 51 E8 00 0F 90 42 04 D1 41 E8 00 4C BC F1 00 0F F6 D1 82 42 BF F3 5F 8F EE D1 01 2A E2 D1 D4 E7 25 46 4E E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? D3 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8D 22 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_IO_vasprintf"
		size = 208
		refs = "000e malloc 002a _IO_no_init 002e _IO_str_jumps 0040 _IO_str_init_static_internal 0050 free 0066 _IO_vfprintf 0090 memcpy 00ae realloc"
	strings:
		$1 = { 2D E9 F0 41 06 46 AC B0 64 20 88 46 17 46 ?? ?? ?? ?? 05 46 00 28 58 D0 00 24 02 A8 23 46 00 94 4F F4 00 41 4F F0 FF 32 14 94 ?? ?? ?? ?? ?? ?2 0? 0? 29 46 2B 46 02 A8 64 22 ?? ?2 0? 0? 28 94 ?? ?? ?? ?? 02 9D 3A 46 02 A8 41 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 25 F0 01 05 ?? ?2 0? 0? 02 95 2A 94 2B 93 ?? ?? ?? ?? 07 1E 28 DB 06 9B 07 9C 08 9A E4 1A D3 1A 65 1C B5 EB 53 0F 14 D2 28 46 ?? ?? ?? ?? 30 60 78 B1 09 9D 22 46 29 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 33 68 6B B1 38 46 00 22 1A 55 2C B0 BD E8 F0 81 29 46 09 98 ?? ?? ?? ?? 03 46 30 60 00 2B F1 D1 09 9B 33 60 EE E7 09 98 ?? ?? ?? ?? 38 46 EC E7 4F F0 FF 30 E9 E7 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "getservbyport"
		size = 308
		refs = "0006 .LANCHOR0 0032 .LANCHOR1 0064 __getservbyport_r 0082 realloc 0090 free 00ec malloc 0102 __lll_lock_wait_private 0124 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 80 46 ?? ?2 0? 0? 89 46 03 94 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 63 D1 ?? ?2 0? 0? ?? ?2 0? 0? 33 68 00 2B 50 D0 03 99 4C 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 E0 38 60 05 AA 00 94 01 92 40 46 49 46 32 4A ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 22 28 32 D1 6C 68 D6 F8 00 A0 64 00 50 46 21 46 6C 60 ?? ?? ?? ?? 03 46 00 28 E4 D1 50 46 02 93 ?? ?? ?? ?? 26 4A 02 9B 1D EE 70 0F 7A 44 12 68 0C 21 CB F8 00 30 81 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1A DC 05 98 07 B0 BD E8 F0 8F 33 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 30 60 00 28 D8 D0 03 46 A4 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 94 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "getservbyname"
		size = 308
		refs = "0006 .LANCHOR0 0032 .LANCHOR1 0064 __getservbyname_r 0082 realloc 0090 free 00ec malloc 0102 __lll_lock_wait_private 0124 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 80 46 ?? ?2 0? 0? 89 46 03 94 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 63 D1 ?? ?2 0? 0? ?? ?2 0? 0? 33 68 00 2B 50 D0 03 99 4C 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 E0 38 60 05 AA 00 94 01 92 40 46 49 46 32 4A ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 22 28 32 D1 6C 68 D6 F8 00 A0 64 00 50 46 21 46 6C 60 ?? ?? ?? ?? 03 46 00 28 E4 D1 50 46 02 93 ?? ?? ?? ?? 26 4A 02 9B 1D EE 70 0F 7A 44 12 68 0C 21 CB F8 00 30 81 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1A DC 05 98 07 B0 BD E8 F0 8F 33 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 30 60 00 28 D8 D0 03 46 A4 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 94 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_IO_helper_overflow"
		size = 102
		refs = "0042 __wmemmove 005c __woverflow"
	strings:
		$1 = { F8 B5 0D 46 C3 6D 04 46 D0 F8 5C 01 D9 68 1A 69 52 1A 96 10 08 D1 1A 69 59 69 8A 42 1A D2 11 1D 28 46 19 61 15 60 F8 BD D0 F8 98 30 32 46 DB 69 98 47 43 1E 03 33 13 D8 E3 6D 87 00 32 1A D8 68 C1 19 ?? ?? ?? ?? E2 6D 13 46 11 69 CF 1B 17 61 00 2A E0 D1 20 46 29 46 BD E8 F8 40 ?? ?? ?? ?? 4F F0 FF 30 F8 BD }
	condition:
		$1
}

rule file_120_1_0 {
	meta:
		name = "buffered_vfprintf"
		size = 348
		refs = "0010 _IO_fwide 0052 _IO_vfwprintf 0056 _pthread_cleanup_push_defer 006a _IO_funlockfile 00e8 _pthread_cleanup_pop_restore 013c __libc_do_syscall 0150 __lll_lock_wait_private"
	strings:
		$1 = { F0 B5 AD F5 01 4D A1 B0 0D 46 01 21 17 46 04 46 ?? ?? ?? ?? 01 28 03 46 18 BF 4F F0 FF 30 66 D1 29 46 48 F2 04 05 CF F6 AD 35 04 95 0D F5 01 45 49 4E 80 35 31 95 2C AD 1B 95 E5 6B 3A 46 04 A8 1F 93 5B 94 00 23 13 95 16 93 60 AB 2A 96 30 93 2F 93 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1F 1C 18 BF 01 27 05 46 00 2F 6B D0 ?? ?2 0? 0? 68 46 ?? ?2 0? 0? 22 46 ?? ?? ?? ?? 23 68 1A 04 1C D4 A0 6C 1D EE 70 6F A6 F5 98 66 83 68 B3 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 50 D1 A3 6C 18 46 9E 60 43 68 01 33 43 60 1B 9B D9 68 1E 69 76 1A B6 10 00 2E 09 DD D4 F8 98 30 20 46 32 46 DB 69 98 47 B0 42 18 BF 4F F0 FF 35 23 68 1B 04 09 D5 1F B1 68 46 00 21 ?? ?? ?? ?? 28 46 0D F5 01 4D 21 B0 F0 BD A0 6C 43 68 01 3B 43 60 00 2B EF D1 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B DC DD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? CF E7 ?? ?2 0? 0? 01 94 ?? ?2 0? 0? 00 93 94 E7 ?? ?? ?? ?? AB E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "_IO_vfwprintf"
		size = 14430
		refs = "0028 _IO_fwide 0066 __wcschrnul 007c _pthread_cleanup_push_defer 008a _IO_funlockfile 0184 __printf_function_table 0198 __printf_modifier_table 01a8 __printf_va_arg_table 022a .LANCHOR0 025c _pthread_cleanup_pop_restore 0334 __libc_errno 0614 _IO_wpadn 0670 free 0706 read_int 07aa __parse_one_specwc 07f6 memmove 0928 __printf_fphex 0bdc __strerror_r 0c0e __strnlen 0c44 __mbsrtowcs 0d90 __btowc 10be _itowa_lower_digits 10e2 __aeabi_uidivmod 10fc __aeabi_uidiv 13f6 memset 1542 __printf_fp 1914 __printf_arginfo_table 19f0 .LC9 19f4 .LC6 19f8 __PRETTY_FUNCTION__.14147 1a0c __assert_fail 1af0 .LC10 1af8 __libc_fatal 1d04 _nl_current_LC_NUMERIC 208a _itowa 20b2 _i18n_number_rewrite 20f0 __wcsnlen 2100 __lll_lock_wait_private 224c _itowa_upper_digits 245c .LC2 24a6 group_number 2516 __woverflow 2596 __libc_alloca_cutoff 25a2 malloc 25da .LC7 26a0 .LC5 28a4 null 2980 strlen 29c0 .LC3 2a3c __wcslen 3390 __readonly_area 339c .LC8 3524 __libc_do_syscall"
	strings:
		$1 = { 2D E9 F0 4F AD F5 86 5D 85 B0 CA 4B 1D EE 70 9F 7B 44 1B 68 02 AF 8A 46 01 21 59 F8 03 30 04 46 C7 F8 C4 20 C7 F8 BC 30 ?? ?? ?? ?? 01 28 40 F0 9C 80 23 68 1D 07 01 F1 1F 84 BA F1 00 0F 01 F0 3F 85 01 46 20 46 ?? ?? ?? ?? 01 28 06 46 40 F0 8C 80 25 68 15 F0 02 08 7B D1 D7 F8 C4 20 50 46 25 21 C7 F8 D0 20 ?? ?? ?? ?? C7 F8 C0 00 C7 F8 CC 00 28 04 48 BF C7 F8 B8 80 30 D4 ?? ?2 0? 0? ?? ?2 0? 0? 00 2B 01 F0 E6 87 ?? ?2 0? 0? 07 F1 E8 00 ?? ?2 0? 0? 22 46 C7 F8 B8 60 ?? ?? ?? ?? 25 68 29 04 1B D4 A0 6C A9 F5 98 65 83 68 AB 42 12 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 26 00 2E F7 D1 BF F3 5F 8F 00 2B 42 F0 17 80 A3 6C 18 46 9D 60 43 68 01 33 43 60 D7 F8 C0 50 20 46 D4 F8 98 30 51 46 CA EB 05 02 4F EA A2 0B DB 69 5A 46 98 47 83 45 18 BF 4F F0 FF 3B 3B D0 23 68 1B 04 18 D4 A0 6C 43 68 01 3B 43 60 9B B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 03 F3 ED 81 D7 F8 B8 50 00 2D 40 F0 89 80 07 F5 86 57 58 46 0C 37 BD 46 BD E8 F0 8F 20 46 51 46 D7 F8 C4 20 03 F0 81 FB 07 F5 86 57 0C 37 BD 46 BD E8 F0 8F 07 F5 86 57 4F F0 FF 30 0C 37 BD 46 BD E8 F0 8F D7 F8 CC 30 1A 68 00 2A BE D0 ?? ?2 0? 0? ?? ?2 0? 0? C7 F8 B0 60 30 68 00 28 43 F0 AF 81 ?? ?2 0? 0? ?? ?2 0? 0? 11 68 00 29 43 F0 99 81 ?? ?2 0? 0? ?? ?2 0? 0? 12 68 00 2A 42 F0 E0 81 4F F0 FF 36 C7 F8 B4 20 7A 67 C7 F8 90 20 C7 F8 80 20 C7 F8 9C 60 5D 68 07 F5 86 56 4F F0 00 08 04 33 A5 F1 20 02 C7 F8 CC 30 5A 2A C7 F8 98 50 C7 F8 58 80 4F F0 FF 35 C7 F8 5C 80 06 F1 08 06 C7 F8 84 50 4F F0 20 05 C7 F8 64 80 C7 F8 6C 80 C7 F8 50 80 C7 F8 70 80 C7 F8 54 80 C7 F8 94 80 C7 F8 4C 80 C7 F8 78 80 C7 F8 48 80 BD 66 44 4B 08 D8 ?? ?2 0? 0? ?? ?2 0? 0? 1A 44 92 F8 78 20 53 F8 22 30 ?? ?2 0? 0? 4F F6 DE 71 ?? ?2 0? 0? C1 F6 FF 71 C7 F8 A0 10 43 F0 01 03 18 47 07 F1 E8 00 00 21 ?? ?? ?? ?? 70 E7 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 02 F2 43 80 2B 44 01 22 FA 65 93 F8 78 30 55 F8 23 30 C7 F8 98 10 43 F0 01 03 18 47 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 02 F2 36 80 2B 44 01 20 F8 66 93 F8 78 30 55 F8 23 30 E7 E7 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 02 F2 1E 80 2B 44 01 22 BA 65 93 F8 78 30 55 F8 23 30 D4 E7 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 02 F2 15 80 2B 44 20 22 01 20 BA 66 93 F8 78 30 78 66 55 F8 23 30 BF E7 D7 F8 CC 30 B8 6E 79 6E 00 29 08 BF 30 20 19 1D C7 F8 CC 10 59 68 B8 66 A1 F1 20 03 5A 2B 01 F2 E3 84 2B 44 93 F8 78 30 55 F8 23 30 A8 E7 ?? ?? ?? ?? ?? ?? ?? ?? D7 F8 9C 20 01 32 02 F0 5D 83 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 02 F2 18 80 2B 44 01 20 38 65 93 F8 78 30 55 F8 23 30 8C E7 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 01 F2 11 87 2B 44 01 20 93 F8 78 30 C7 F8 94 00 38 67 05 EB 83 03 D3 F8 3C 32 75 E7 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 01 F2 B3 86 2B 44 00 22 93 F8 78 30 C7 F8 94 20 3A 67 05 EB 83 03 D3 F8 3C 32 5E E7 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 2A 29 02 F0 B7 85 30 39 09 29 42 F2 8B 85 00 23 C7 F8 84 30 D7 F8 CC 30 19 68 A1 F1 20 03 5A 2B 01 F2 7B 84 2B 44 93 F8 78 30 05 EB 83 03 D3 F8 4C 31 3E E7 E3 6D 00 2B 02 F0 44 86 1A 69 59 69 8A 42 82 F0 3F 86 11 1D 19 61 25 23 13 60 6F F0 00 43 9B 45 00 F0 18 81 D7 F8 C4 50 0B F1 01 06 C7 F8 A0 50 B8 F1 00 0F 42 F0 B4 86 D7 F8 CC 50 25 21 04 35 C7 F8 CC 50 28 46 ?? ?? ?? ?? 00 2E C7 F8 CC 00 C2 F2 96 86 D4 F8 98 30 42 1B 29 46 20 46 92 10 DB 69 98 47 D7 F8 CC 30 5D 1B B0 EB A5 0F 01 F0 61 86 4F F0 00 08 ED E0 3D 6F 00 2D 02 F0 FA 86 D7 F8 C4 50 EB 1D 23 F0 07 03 03 F1 08 05 C7 F8 A0 50 D3 E9 00 23 DD 0F C7 F8 C4 50 02 D0 52 42 63 EB 43 03 0A 25 C7 E9 0A 23 C7 F8 94 50 D7 F8 84 50 00 2D C2 F2 D9 86 41 F0 D5 85 D7 E9 0A 01 01 43 41 F0 D0 85 BD 6D 00 2D 02 F0 4F 86 D7 F8 94 50 08 2D 42 F0 4A 86 35 1F 30 23 20 20 46 F8 04 3C B8 66 BA 6A FB 6A 1A 43 0C BF 00 20 01 20 B8 62 73 1B D7 F8 84 10 B1 EB A3 0F 0D DC BA 6A 5A B1 B8 6D 48 B1 D7 F8 94 10 08 29 01 BF 30 23 45 F8 04 3C 04 3D C5 EB 06 03 D7 F8 84 00 9E 10 73 42 79 6E 3B 67 03 44 23 EA E3 73 C7 F8 84 30 00 29 41 F0 EB 83 38 6F B9 6F C2 1A BB 6A 0A 44 33 B1 B8 6D 20 B1 D7 F8 94 10 10 29 08 BF 02 3A F8 6D D7 F8 C4 10 40 EA 01 03 F8 6E B9 6E 18 43 18 BF 02 F1 FF 32 20 29 02 F0 CF 86 D7 F8 C4 30 00 2B 01 F0 9F 85 E3 6D 00 2B 02 F0 2E 86 19 69 58 69 81 42 82 F0 29 86 08 1D 18 61 2D 23 0B 60 6F F0 00 43 9B 45 5D D0 0B F1 01 0B BB 6A 73 B3 B8 6D 60 B3 D7 F8 94 10 10 29 28 D1 E3 6D 00 2B 02 F0 A0 86 19 69 58 69 81 42 82 F0 9B 86 08 1D 18 61 30 23 0B 60 6F F0 00 43 9B 45 42 D0 E3 6D 00 2B 02 F0 83 86 19 69 58 69 81 42 82 F0 7E 86 08 1D 18 61 D7 F8 98 30 0B 60 01 33 32 D0 4F F6 FE 73 C7 F6 FF 73 9B 45 2C D0 0B F1 02 0B D7 F8 84 30 1A 44 00 2A 17 DD 20 46 30 21 ?? ?? ?? ?? 42 1C 1F D0 4F F6 FE 73 C7 F6 FF 73 9B 45 02 F2 CC 85 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 98 42 98 BF 83 44 02 F2 B9 85 BB F1 00 0F C2 F2 18 85 D4 F8 98 30 29 46 20 46 32 46 DB 69 98 47 86 42 02 F0 E0 80 4F F0 FF 3B D7 F8 B4 60 3E B9 B8 F1 00 0F 3F F4 4A AD 40 46 ?? ?? ?? ?? 45 E5 30 46 ?? ?? ?? ?? F3 E7 D7 F8 CC 10 0B 1D C7 F8 CC 30 49 68 C7 F8 F8 30 A1 F1 30 03 09 2B 42 F2 27 85 D7 F8 C4 30 D7 F8 C4 00 1B 68 04 30 C7 F8 C4 00 00 2B BB 67 C2 F2 2C 85 B8 6F D7 F8 A0 10 88 42 02 F2 D6 84 BA 6F B2 F5 72 7F 0E D3 02 F1 20 06 B6 00 B6 F5 80 5F 02 F2 24 85 06 F1 0E 03 23 F0 07 03 AD EB 03 0D 02 AB 1E 44 D7 F8 CC 30 19 68 A1 F1 20 03 5A 2B 01 F2 FE 82 2B 44 93 F8 78 30 05 EB 83 03 D3 F8 D4 30 C1 E5 07 F1 CC 00 ?? ?? ?? ?? D7 F8 A0 30 98 42 B8 67 02 F2 61 86 B8 6F B0 F5 72 7F 0E D3 00 F1 20 06 B6 00 B6 F5 80 5F 02 F2 89 80 06 F1 0E 03 23 F0 07 03 AD EB 03 0D 02 AB 1E 44 D7 F8 CC 30 19 68 24 29 D0 D1 AD F5 D1 6D 00 23 02 AE C7 F8 D4 30 C7 F8 88 60 B8 F1 00 0F 42 F0 38 86 D7 F8 9C 50 01 35 01 F0 CA 81 D7 F8 C0 60 35 68 C7 F8 CC 60 00 2D 01 F0 B0 82 00 26 4F F4 D0 65 C7 F8 A8 B0 B0 46 AB 46 C7 F8 A4 90 D7 F8 C0 00 B1 46 C7 F8 8C 60 D7 F8 88 50 C7 F8 AC 40 00 E0 20 46 2E 44 41 46 07 F1 D4 03 32 46 ?? ?? ?? ?? B4 69 09 F1 01 09 23 68 C7 F8 CC 40 80 44 00 2B 01 F0 68 80 4F F0 34 0E 0E FB 09 F6 B3 45 E7 D8 4F EA 4B 0E 29 46 0E F1 0F 0E 2E F0 0F 0E 0E F1 08 03 AD EB 03 0D 02 AB 03 EB 0E 02 18 46 95 42 32 46 08 BF DE 44 F3 46 ?? ?? ?? ?? 05 46 CF E7 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 01 F2 7A 84 2B 44 01 22 00 20 FA 64 93 F8 78 30 78 65 05 EB 83 03 D3 F8 3C 32 2C E5 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 01 F2 77 84 2B 44 01 22 C7 F8 94 20 93 F8 78 30 05 EB 83 03 D3 F8 B4 32 16 E5 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 01 F2 5C 84 2B 44 01 22 BA 64 93 F8 78 30 55 F8 23 30 03 E5 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 01 F2 4B 85 2B 44 01 20 78 65 93 F8 78 30 05 EB 83 03 D3 F8 C4 31 EE E4 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 01 F2 BB 84 2B 44 00 20 60 E5 10 25 C7 F8 94 50 3D 6F 00 2D 01 F0 31 85 D7 F8 C4 50 EB 1D 00 25 23 F0 07 03 FD 66 FD 65 03 F1 08 05 D3 E9 00 01 C7 F8 A0 50 00 25 C7 F8 C4 50 C7 E9 0A 01 DD E5 0A 25 C7 F8 94 50 E3 E7 D7 F8 90 60 34 21 D7 F8 88 50 01 FB 06 51 00 29 01 F0 D5 86 4B 6A 07 F1 DC 02 FD 6F 20 46 05 EB C3 03 C7 F8 DC 30 ?? ?? ?? ?? 00 28 FF F6 95 AE 4F F6 FE 73 C7 F6 FF 73 9B 45 01 F2 B0 86 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 98 42 02 F2 45 81 83 44 B8 F1 00 0F 42 F0 3B 81 BB F1 00 0F C2 F2 27 81 D7 F8 90 60 34 25 D7 F8 88 E0 20 46 D4 F8 98 30 05 FB 06 E5 DB 69 6E 69 AA 69 31 46 92 1B 92 10 98 47 AA 69 6B 69 D3 1A B0 EB A3 0F 01 F0 3E 80 4F F0 00 08 60 E6 D7 F8 90 50 34 23 D7 F8 88 00 03 FB 05 03 00 2B 01 F0 EB 86 5B 6A FD 6F 55 F8 33 30 00 2B 01 F0 D5 86 00 25 3B 63 7D 61 3D 66 78 25 7D 64 01 25 3D 62 10 25 C7 F8 A0 50 D7 F8 A4 50 00 2D C1 F2 8D 84 41 F0 31 84 38 6B 00 28 41 F0 2D 84 3D 6A 00 2D 02 F0 75 82 D7 F8 A0 50 08 2D 42 F0 70 82 35 1F 30 23 20 20 08 21 46 F8 04 3C F8 63 C7 F8 A0 10 73 1B D7 F8 A4 10 B1 EB A3 0F 0D DC 3A 6B 5A B1 38 6A 48 B1 D7 F8 A0 10 08 29 01 BF 30 23 45 F8 04 3C 04 3D C5 EB 06 03 D7 F8 A4 00 9E 10 73 42 79 6A BB 63 03 44 23 EA E3 73 C7 F8 A4 30 00 29 41 F0 13 82 BA 6B D7 F8 AC C0 D3 1A 9C 44 3B 6B 3B B1 38 6A 28 B1 D7 F8 A0 10 10 29 08 BF AC F1 02 0C 3A 6C 38 6E D7 F8 A8 10 42 EA 00 03 FA 6B 19 43 18 BF 0C F1 FF 3C 20 2A 02 F0 DD 81 3B 6E 00 2B 01 F0 75 83 E3 6D 00 2B 01 F0 EE 85 1A 69 59 69 8A 42 81 F0 E9 85 11 1D 19 61 2D 23 13 60 6F F0 00 43 9B 45 3F F4 D3 AD 0B F1 01 0B 3A 6B 82 B3 3B 6A 73 B3 D7 F8 A0 00 10 28 2A D1 E3 6D 00 2B 02 F0 D8 81 1A 69 59 69 8A 42 82 F0 D3 81 11 1D 19 61 30 23 13 60 6F F0 00 43 9B 45 3F F4 B7 AD E3 6D 00 2B 02 F0 4A 81 1A 69 59 69 8A 42 82 F0 45 81 11 1D 19 61 79 6C 11 60 01 31 3F F4 A7 AD 4F F6 FE 73 C7 F6 FF 73 9B 45 3F F4 A0 AD 0B F1 02 0B D7 F8 A4 20 62 44 00 2A 18 DD 20 46 30 21 ?? ?? ?? ?? 42 1C 3F F4 92 AD 4F F6 FE 73 C7 F6 FF 73 9B 45 01 F2 AD 85 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 98 42 98 BF 83 44 01 F2 9A 85 BB F1 00 0F C2 F2 91 80 D4 F8 98 30 29 46 20 46 32 46 DB 69 98 47 86 42 7F F4 72 AD 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 9E 42 02 F3 0C 80 B3 44 E2 E6 E3 6B 58 07 03 D5 7D 6F 00 2D 02 F0 F4 83 D7 F8 90 60 34 23 D7 F8 88 50 03 FB 06 53 00 2B 02 F0 30 80 3D 6E 00 2D 02 F0 22 80 5B 6A 5A 46 FE 6F 56 F8 33 10 4F EA EB 73 C1 E9 00 23 C3 E6 D7 F8 BC 00 07 F5 94 71 4F F4 7A 62 00 26 BE 61 ?? ?? ?? ?? 05 46 00 2D 01 F0 D1 86 7E 6C 53 2E 01 F0 BF 83 BE 69 00 2E 41 F0 BB 83 D7 F8 A4 00 07 F1 E0 06 35 60 01 30 28 46 01 F0 BB 86 D7 F8 A4 10 ?? ?? ?? ?? 02 46 95 00 B5 F5 80 5F 01 F2 9B 86 05 F1 0E 03 00 25 23 F0 07 03 C7 F8 A8 50 AD EB 03 0D 02 AD 31 46 07 F1 F8 03 28 46 00 26 C7 F8 F8 60 C7 F8 FC 60 ?? ?? ?? ?? 41 1C 06 46 3F F4 06 AD D7 F8 AC 00 B0 EB 06 0C 01 F1 46 86 79 6A 01 BB BC F1 00 0F 1D D0 62 46 20 46 20 21 C7 F8 08 C0 ?? ?? ?? ?? D7 F8 08 C0 43 1C 3F F4 EF AC 4F F6 FE 73 C7 F6 FF 73 9B 45 01 F2 85 85 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 98 42 98 BF 83 44 01 F2 5A 85 BB F1 00 0F C1 F2 0F 86 D4 F8 98 30 20 46 29 46 32 46 DB 69 C7 F8 08 C0 98 47 D7 F8 08 C0 86 42 7F F4 CB AC 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 9E 42 01 F2 F0 85 B3 44 7E 6A E6 B1 BC F1 00 0F 19 D0 62 46 20 46 20 21 ?? ?? ?? ?? 46 1C 3F F4 B4 AC 4F F6 FE 73 C7 F6 FF 73 9B 45 01 F2 4A 85 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 98 42 98 BF 83 44 01 F2 06 86 D7 F8 A8 60 00 2E 3F F4 19 AE 28 46 ?? ?? ?? ?? 14 E6 BD 69 00 2D 40 F0 AB 82 D7 F8 AC 50 6E 1E 7D 6A DD B9 00 2E 19 DD 20 21 20 46 32 46 ?? ?? ?? ?? 41 1C 3F F4 86 AC 4F F6 FE 73 C7 F6 FF 73 9B 45 01 F2 1C 85 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 98 42 98 BF 83 44 01 F2 89 86 D7 F8 90 50 34 23 D7 F8 88 E0 03 FB 05 E3 00 2B 02 F0 3C 81 5B 6A FD 6F 15 F8 33 00 ?? ?? ?? ?? E3 6D 01 46 00 2B 02 F0 29 81 1A 69 58 69 82 42 82 F0 24 81 10 1D 18 61 11 60 01 31 3F F4 54 AC 6F F0 00 43 9B 45 3F F4 4F AC 0B F1 01 0B 7D 6A 00 2D 3F F4 C5 AD 00 2E 7F F7 C2 AD 32 46 20 46 20 21 ?? ?? ?? ?? 42 1C 3F F4 3E AC 4F F6 FE 73 C7 F6 FF 73 9B 45 01 F2 D4 84 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 98 42 7F F6 A9 AD 73 4B 4B 22 7B 44 1B 68 49 F8 03 20 26 E4 D7 F8 CC 30 19 1D C7 F8 CC 10 59 68 A1 F1 20 03 5A 2B 01 F2 9D 82 2B 44 01 22 FF F7 C4 BA D7 F8 C4 60 D7 F8 C4 50 04 35 C7 F8 A0 50 35 68 00 2D 01 F0 2A 85 D7 F8 98 60 53 2E 01 F0 4B 81 D7 F8 94 60 00 2E 41 F0 46 81 D7 F8 84 00 07 F1 E0 06 35 60 01 30 28 46 02 F0 8B 81 D7 F8 84 10 ?? ?? ?? ?? 02 46 95 00 B5 F5 80 5F 01 F2 DF 83 05 F1 0E 03 00 25 23 F0 07 03 C7 F8 C4 50 AD EB 03 0D 02 AD 31 46 07 F1 F8 03 28 46 00 26 C7 F8 F8 60 C7 F8 FC 60 ?? ?? ?? ?? 06 46 01 30 3F F4 D7 AB B8 6F B0 EB 06 0C 01 F1 A9 83 79 6E 01 BB BC F1 00 0F 1D D0 62 46 20 46 20 21 C7 F8 08 C0 ?? ?? ?? ?? D7 F8 08 C0 42 1C 3F F4 C1 AB 4F F6 FE 73 C7 F6 FF 73 9B 45 01 F2 7C 85 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 98 42 98 BF 83 44 01 F2 69 85 BB F1 00 0F C1 F2 6A 83 D4 F8 98 30 20 46 29 46 32 46 DB 69 C7 F8 08 C0 98 47 D7 F8 08 C0 86 42 7F F4 9D AB 4F F6 FF 73 C7 F6 FF 73 CB EB 03 03 9E 42 02 F2 67 82 7A 6E 5E 44 DA B1 BC F1 00 0F 18 D0 62 46 20 46 20 21 ?? ?? ?? ?? 43 1C 3F F4 86 AB 4F F6 FE 73 C7 F6 FF 73 9E 42 01 F2 41 85 4F F6 FF 73 C7 F6 FF 73 9B 1B 98 42 98 BF 36 18 01 F2 44 83 D7 F8 C4 30 00 2B 3F F4 5E AA 28 46 ?? ?? ?? ?? FF F7 59 BA 08 25 C7 F8 94 50 9D E4 D7 F8 90 60 34 23 D7 F8 88 50 03 FB 06 53 00 2B 02 F0 38 82 5B 6A FE 6F 56 F8 33 50 1A E6 D7 F8 88 00 34 22 D7 F8 90 50 00 23 02 FB 05 06 F2 6A 91 00 0E 31 21 F0 07 01 AD EB 01 0D 02 A8 0A E0 00 BF ?? ?? ?? ?? 71 6A FD 6F 19 44 05 EB C1 01 40 F8 23 10 01 33 93 42 F5 D1 E3 6D 00 2B 01 F0 E3 82 1A 69 59 69 8A 42 81 F0 DE 82 11 1D 19 61 25 23 }
	condition:
		$1
}

rule file_120_3_0 {
	meta:
		name = "read_int"
		size = 76
	strings:
		$1 = { 02 68 F0 B4 4C F6 CC 46 52 F8 04 3B C0 F6 CC 46 0A 27 30 3B 11 68 30 39 09 29 13 D8 00 2B 0F DB 4F F6 FF 74 B3 42 C7 F6 FF 74 07 FB 03 F5 C1 EB 04 04 03 DC AC 42 05 EB 01 03 01 DA 4F F0 FF 33 04 32 E7 E7 02 60 18 46 F0 BC 70 47 }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "group_number"
		size = 144
		refs = "0030 mempcpy"
	strings:
		$1 = { 2D E9 F0 43 83 B0 91 46 00 AF 0D 46 14 78 62 1E D2 B2 FD 2A 38 D8 0A 1A 01 46 02 F1 0E 00 7B 60 20 F0 07 00 09 F1 01 09 AD EB 00 0D 68 46 E8 46 ?? ?? ?? ?? 7B 68 29 46 40 45 A1 F1 04 05 22 D9 50 F8 04 6D 01 3C 41 F8 04 6C 1A D1 40 45 18 D9 41 F8 08 3C A1 F1 08 05 99 F8 00 60 FF 2E 34 46 09 D1 A1 F1 0C 03 50 F8 04 2D 19 46 80 45 43 F8 04 29 F8 D3 07 E0 16 B1 09 F1 01 09 01 E0 19 F8 01 4C 29 46 D8 E7 08 46 0C 37 BD 46 BD E8 F0 83 }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "_i18n_number_rewrite"
		size = 228
		refs = "0008 .LC0 0016 __wctrans 0024 __towctrans 0040 __libc_alloca_cutoff 0060 malloc 0070 mempcpy 00c8 free 00e0 _nl_current_LC_CTYPE"
	strings:
		$1 = { 2D E9 F0 4F 05 46 83 B0 ?? ?2 0? 0? ?? ?2 0? 0? 00 AF 0E 46 14 46 ?? ?? ?? ?? C5 EB 06 08 82 46 2E 20 51 46 ?? ?? ?? ?? 51 46 78 60 2C 20 ?? ?? ?? ?? B8 F5 80 5F 81 46 98 BF 01 20 05 D9 40 46 ?? ?? ?? ?? 00 30 18 BF 01 20 83 46 38 B1 08 F1 0E 03 23 F0 07 03 AD EB 03 0D 6E 46 05 E0 40 46 ?? ?? ?? ?? 06 46 00 28 32 D0 29 46 42 46 30 46 ?? ?? ?? ?? 1A 4A 1D EE 70 1F 7A 44 12 68 03 46 88 58 04 3B B3 42 1B D3 1A 68 A2 F1 30 05 09 2D 06 D8 01 68 01 EB 82 02 12 6B 44 F8 04 2C 0D E0 BA F1 00 0F 08 D0 22 F0 02 01 2C 29 04 D1 79 68 2E 2A 18 BF 49 46 0A 46 44 F8 04 2C 04 3C E0 E7 BB F1 00 0F 06 D1 30 46 ?? ?? ?? ?? 20 46 02 E0 28 46 00 E0 20 46 0C 37 BD 46 BD E8 F0 8F 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__vswscanf"
		size = 74
		refs = "0006 _IO_wstr_jumps 0022 _IO_no_init 002a _IO_fwide 0036 _IO_wstr_init_static 0042 _IO_vfwscanf"
	strings:
		$1 = { F0 B5 DD B0 00 24 ?? ?2 0? 0? 07 46 0E 46 15 46 02 A8 22 46 ?? ?2 0? 0? 4F F4 00 41 00 93 2D AB 14 94 ?? ?? ?? ?? 02 A8 01 21 ?? ?? ?? ?? 02 A8 39 46 22 46 23 46 ?? ?? ?? ?? 02 A8 31 46 2A 46 23 46 ?? ?? ?? ?? 5D B0 F0 BD }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "insque"
		size = 22
	strings:
		$1 = { 31 B1 0B 68 08 60 03 B1 58 60 03 60 41 60 70 47 01 60 41 60 70 47 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "strcat"
		size = 38
	strings:
		$1 = { 10 B4 02 46 00 E0 1A 46 13 46 13 F8 01 4B 00 2C F9 D1 01 3A 11 F8 01 3B 02 F8 01 3F 00 2B F9 D1 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__libc_tcdrain"
		size = 128
		refs = "0002 __libc_multiple_threads 001a __libc_do_syscall 0026 __libc_enable_asynccancel 0046 __libc_disable_asynccancel 0078 __libc_errno"
	strings:
		$1 = { 38 B5 ?? ?2 0? 0? ?? ?2 0? 0? 04 46 1B 68 53 B9 45 F2 09 41 01 22 4F F0 36 0C ?? ?? ?? ?? 10 F5 80 5F 14 D8 38 BD ?? ?? ?? ?? 45 F2 09 41 01 22 4F F0 36 0C 05 46 20 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0E D8 28 46 ?? ?? ?? ?? 20 46 EA E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 38 BD 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E6 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_0_3 {
	meta:
		name = "__libc_tcdrain"
		size = 128
		refs = "0002 __pthread_multiple_threads 001a __libc_do_syscall 0026 __pthread_enable_asynccancel 0046 __pthread_disable_asynccancel 0078 errno"
	strings:
		$1 = { 38 B5 ?? ?2 0? 0? ?? ?2 0? 0? 04 46 1B 68 53 B9 45 F2 09 41 01 22 4F F0 36 0C ?? ?? ?? ?? 10 F5 80 5F 14 D8 38 BD ?? ?? ?? ?? 45 F2 09 41 01 22 4F F0 36 0C 05 46 20 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0E D8 28 46 ?? ?? ?? ?? 20 46 EA E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 38 BD 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E6 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "fileno"
		size = 40
		refs = "0024 __libc_errno"
	strings:
		$1 = { 03 68 9B 04 03 D5 80 6B 00 28 00 DB 70 47 05 4B 1D EE 70 2F 09 21 4F F0 FF 30 7B 44 1B 68 D1 50 F4 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__default_morecore"
		size = 16
		refs = "0002 __sbrk"
	strings:
		$1 = { 08 B5 ?? ?? ?? ?? B0 F1 FF 3F 08 BF 00 20 08 BD }
	condition:
		$1
}

rule file_892_0_1 {
	meta:
		name = "__gnu_fractsfda"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2lz"
	strings:
		$1 = { 08 B5 4F F0 9E 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_723_0_1 {
	meta:
		name = "__gnu_fractsfdq"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2lz"
	strings:
		$1 = { 08 B5 4F F0 BE 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_1075_0_1 {
	meta:
		name = "__gnu_fractsfha"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2iz"
	strings:
		$1 = { 08 B5 4F F0 86 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_120_0_1 {
	meta:
		name = "__gnu_fractsfhq"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2iz"
	strings:
		$1 = { 08 B5 4F F0 8E 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_515_0_1 {
	meta:
		name = "__gnu_fractsfqq"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2iz"
	strings:
		$1 = { 08 B5 4F F0 86 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_263_0_1 {
	meta:
		name = "__gnu_fractsfsa"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2iz"
	strings:
		$1 = { 08 B5 4F F0 8E 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_137_0_1 {
	meta:
		name = "__gnu_fractsfsq"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2iz"
	strings:
		$1 = { 08 B5 4F F0 9E 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_1413_0_1 {
	meta:
		name = "__gnu_fractsfuda"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2ulz"
	strings:
		$1 = { 08 B5 4F F0 9F 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_1224_0_1 {
	meta:
		name = "__gnu_fractsfudq"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2ulz"
	strings:
		$1 = { 08 B5 4F F0 BF 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_1651_0_1 {
	meta:
		name = "__gnu_fractsfuha"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2uiz"
	strings:
		$1 = { 08 B5 4F F0 87 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_65_0_1 {
	meta:
		name = "__gnu_fractsfuhq"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2uiz"
	strings:
		$1 = { 08 B5 4F F0 8F 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_1322_0_1 {
	meta:
		name = "__gnu_fractsfuqq"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2uiz"
	strings:
		$1 = { 08 B5 4F F0 87 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_134_0_1 {
	meta:
		name = "__gnu_fractsfusa"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2uiz"
	strings:
		$1 = { 08 B5 4F F0 8F 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_950_0_1 {
	meta:
		name = "__gnu_fractsfusq"
		size = 16
		refs = "0006 __aeabi_fmul 000a __aeabi_f2uiz"
	strings:
		$1 = { 08 B5 4F F0 9F 41 ?? ?? ?? ?? ?? ?? ?? ?? 08 BD }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "setsgent"
		size = 192
		refs = "0002 .LANCHOR0 002a .LC0 002e __nss_gshadow_lookup2 004e __nss_setent 0090 __lll_lock_wait_private 00ae __libc_do_syscall 00b8 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 7B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 25 01 95 02 95 1D EE 70 6F 03 95 ?? ?? ?? ?? 19 4B 7B 44 1B 68 F7 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 0F 4B 7B 44 1B 68 F7 50 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C8 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1083_0_0 {
	meta:
		name = "setaliasent"
		size = 192
		refs = "0002 .LANCHOR0 002a .LC0 002e __nss_aliases_lookup2 004e __nss_setent 0090 __lll_lock_wait_private 00ae __libc_do_syscall 00b8 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 7B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 25 01 95 02 95 1D EE 70 6F 03 95 ?? ?? ?? ?? 19 4B 7B 44 1B 68 F7 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 0F 4B 7B 44 1B 68 F7 50 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C8 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1131_0_0 {
	meta:
		name = "setgrent"
		size = 192
		refs = "0002 .LANCHOR0 002a .LC0 002e __nss_group_lookup2 004e __nss_setent 0090 __lll_lock_wait_private 00ae __libc_do_syscall 00b8 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 7B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 25 01 95 02 95 1D EE 70 6F 03 95 ?? ?? ?? ?? 19 4B 7B 44 1B 68 F7 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 0F 4B 7B 44 1B 68 F7 50 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C8 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_738_0_0 {
	meta:
		name = "setpwent"
		size = 192
		refs = "0002 .LANCHOR0 002a .LC0 002e __nss_passwd_lookup2 004e __nss_setent 0090 __lll_lock_wait_private 00ae __libc_do_syscall 00b8 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 7B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 25 01 95 02 95 1D EE 70 6F 03 95 ?? ?? ?? ?? 19 4B 7B 44 1B 68 F7 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 0F 4B 7B 44 1B 68 F7 50 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C8 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_541_0_0 {
	meta:
		name = "setspent"
		size = 192
		refs = "0002 .LANCHOR0 002a .LC0 002e __nss_shadow_lookup2 004e __nss_setent 0090 __lll_lock_wait_private 00ae __libc_do_syscall 00b8 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 7B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 25 01 95 02 95 1D EE 70 6F 03 95 ?? ?? ?? ?? 19 4B 7B 44 1B 68 F7 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 0F 4B 7B 44 1B 68 F7 50 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C8 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "endsgent"
		size = 196
		refs = "0002 .LANCHOR0 0030 .LC1 0034 __nss_gshadow_lookup2 004c __nss_endent 0092 __lll_lock_wait_private 00b0 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 A3 68 00 2B 39 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 6B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 26 01 96 ?? ?? ?? ?? 1A 4B 1D EE 70 5F 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 10 4B 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? CA E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1083_1_0 {
	meta:
		name = "endaliasent"
		size = 196
		refs = "0002 .LANCHOR0 0030 .LC1 0034 __nss_aliases_lookup2 004c __nss_endent 0092 __lll_lock_wait_private 00b0 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 A3 68 00 2B 39 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 6B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 26 01 96 ?? ?? ?? ?? 1A 4B 1D EE 70 5F 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 10 4B 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? CA E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1131_1_0 {
	meta:
		name = "endgrent"
		size = 196
		refs = "0002 .LANCHOR0 0030 .LC1 0034 __nss_group_lookup2 004c __nss_endent 0092 __lll_lock_wait_private 00b0 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 A3 68 00 2B 39 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 6B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 26 01 96 ?? ?? ?? ?? 1A 4B 1D EE 70 5F 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 10 4B 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? CA E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1029_1_0 {
	meta:
		name = "endprotoent"
		size = 196
		refs = "0002 .LANCHOR0 0030 .LC1 0034 __nss_protocols_lookup2 004c __nss_endent 0092 __lll_lock_wait_private 00b0 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 A3 68 00 2B 39 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 6B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 26 01 96 ?? ?? ?? ?? 1A 4B 1D EE 70 5F 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 10 4B 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? CA E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_738_1_0 {
	meta:
		name = "endpwent"
		size = 196
		refs = "0002 .LANCHOR0 0030 .LC1 0034 __nss_passwd_lookup2 004c __nss_endent 0092 __lll_lock_wait_private 00b0 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 A3 68 00 2B 39 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 6B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 26 01 96 ?? ?? ?? ?? 1A 4B 1D EE 70 5F 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 10 4B 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? CA E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_1_0 {
	meta:
		name = "endrpcent"
		size = 196
		refs = "0002 .LANCHOR0 0030 .LC1 0034 __nss_rpc_lookup2 004c __nss_endent 0092 __lll_lock_wait_private 00b0 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 A3 68 00 2B 39 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 6B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 26 01 96 ?? ?? ?? ?? 1A 4B 1D EE 70 5F 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 10 4B 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? CA E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1398_1_0 {
	meta:
		name = "endservent"
		size = 196
		refs = "0002 .LANCHOR0 0030 .LC1 0034 __nss_services_lookup2 004c __nss_endent 0092 __lll_lock_wait_private 00b0 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 A3 68 00 2B 39 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 6B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 26 01 96 ?? ?? ?? ?? 1A 4B 1D EE 70 5F 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 10 4B 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? CA E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_541_1_0 {
	meta:
		name = "endspent"
		size = 196
		refs = "0002 .LANCHOR0 0030 .LC1 0034 __nss_shadow_lookup2 004c __nss_endent 0092 __lll_lock_wait_private 00b0 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 A3 68 00 2B 39 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 6B BB 22 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 1F A5 F1 08 02 00 95 ?? ?2 0? 0? 00 26 01 96 ?? ?? ?? ?? 1A 4B 1D EE 70 5F 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 10 4B 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? CA E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_2_0 {
	meta:
		name = "__getsgent_r"
		size = 240
		refs = "0004 .LANCHOR0 0036 .LC2 003a .LC0 003e __nss_gshadow_lookup2 0072 __nss_getent_r 00be __lll_lock_wait_private 00dc __libc_do_syscall 00e8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 17 46 8B B0 81 46 88 46 1E 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 D1 2B 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 F1 04 0E 2B 1F CD F8 14 80 ?? ?2 0? 0? 06 97 ?? ?2 0? 0? 07 96 ?? ?2 0? 0? 00 95 00 25 CD F8 10 90 1D EE 70 6F CD F8 04 E0 02 95 03 95 08 95 ?? ?? ?? ?? 1C 4B 7B 44 1B 68 56 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 46 F8 03 80 0B B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B7 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1083_2_0 {
	meta:
		name = "__getaliasent_r"
		size = 240
		refs = "0004 .LANCHOR0 0036 .LC2 003a .LC0 003e __nss_aliases_lookup2 0072 __nss_getent_r 00be __lll_lock_wait_private 00dc __libc_do_syscall 00e8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 17 46 8B B0 81 46 88 46 1E 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 D1 2B 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 F1 04 0E 2B 1F CD F8 14 80 ?? ?2 0? 0? 06 97 ?? ?2 0? 0? 07 96 ?? ?2 0? 0? 00 95 00 25 CD F8 10 90 1D EE 70 6F CD F8 04 E0 02 95 03 95 08 95 ?? ?? ?? ?? 1C 4B 7B 44 1B 68 56 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 46 F8 03 80 0B B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B7 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1131_2_0 {
	meta:
		name = "__getgrent_r"
		size = 240
		refs = "0004 .LANCHOR0 0036 .LC2 003a .LC0 003e __nss_group_lookup2 0072 __nss_getent_r 00be __lll_lock_wait_private 00dc __libc_do_syscall 00e8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 17 46 8B B0 81 46 88 46 1E 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 D1 2B 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 F1 04 0E 2B 1F CD F8 14 80 ?? ?2 0? 0? 06 97 ?? ?2 0? 0? 07 96 ?? ?2 0? 0? 00 95 00 25 CD F8 10 90 1D EE 70 6F CD F8 04 E0 02 95 03 95 08 95 ?? ?? ?? ?? 1C 4B 7B 44 1B 68 56 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 46 F8 03 80 0B B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B7 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_738_2_0 {
	meta:
		name = "__getpwent_r"
		size = 240
		refs = "0004 .LANCHOR0 0036 .LC2 003a .LC0 003e __nss_passwd_lookup2 0072 __nss_getent_r 00be __lll_lock_wait_private 00dc __libc_do_syscall 00e8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 17 46 8B B0 81 46 88 46 1E 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 D1 2B 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 F1 04 0E 2B 1F CD F8 14 80 ?? ?2 0? 0? 06 97 ?? ?2 0? 0? 07 96 ?? ?2 0? 0? 00 95 00 25 CD F8 10 90 1D EE 70 6F CD F8 04 E0 02 95 03 95 08 95 ?? ?? ?? ?? 1C 4B 7B 44 1B 68 56 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 46 F8 03 80 0B B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B7 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_541_2_0 {
	meta:
		name = "__getspent_r"
		size = 240
		refs = "0004 .LANCHOR0 0036 .LC2 003a .LC0 003e __nss_shadow_lookup2 0072 __nss_getent_r 00be __lll_lock_wait_private 00dc __libc_do_syscall 00e8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 17 46 8B B0 81 46 88 46 1E 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 D1 2B 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 F1 04 0E 2B 1F CD F8 14 80 ?? ?2 0? 0? 06 97 ?? ?2 0? 0? 07 96 ?? ?2 0? 0? 00 95 00 25 CD F8 10 90 1D EE 70 6F CD F8 04 E0 02 95 03 95 08 95 ?? ?? ?? ?? 1C 4B 7B 44 1B 68 56 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 46 F8 03 80 0B B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B7 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "__gethostname"
		size = 88
		refs = "000a uname 0016 strlen 002a memcpy 0054 __libc_errno"
	strings:
		$1 = { F0 B5 E3 B0 07 46 68 46 0D 46 ?? ?? ?? ?? 04 46 90 B9 0D F1 41 00 ?? ?? ?? ?? 0D F1 41 01 46 1C 38 46 AE 42 34 BF 32 46 2A 46 ?? ?? ?? ?? AE 42 05 D8 20 46 63 B0 F0 BD 4F F0 FF 34 F9 E7 05 4B 1D EE 70 2F 24 21 4F F0 FF 34 7B 44 1B 68 D1 50 EF E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "fchflags"
		size = 52
		refs = "002c __libc_errno"
	strings:
		$1 = { 00 28 09 DB 09 4B 1D EE 70 2F 26 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 05 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "open_translit"
		size = 146
		refs = "000c __libc_dlopen_mode 0016 .LC0 001e __libc_dlsym 003a __libc_dlclose 0046 .LC1 005a .LC2 0078 .LC3"
	strings:
		$1 = { 01 21 38 B5 C8 F2 00 01 04 46 00 6A ?? ?? ?? ?? 01 25 60 62 A8 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 03 46 38 B1 21 46 04 F1 0C 02 51 F8 08 0B 98 47 05 46 38 B1 01 25 60 6A ?? ?? ?? ?? 00 23 63 62 28 46 38 BD ?? ?2 0? 0? 60 6A ?? ?2 0? 0? ?? ?? ?? ?? 20 61 00 28 ED D0 ?? ?2 0? 0? 60 6A ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? A0 61 60 6A ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 60 61 60 6A ?? ?? ?? ?? 01 23 A3 62 E0 61 28 46 38 BD }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "__gconv_transliterate"
		size = 664
		refs = "011a __aeabi_uidivmod 01be _dl_mcount_wrapper_check 0290 _nl_current_LC_CTYPE"
	strings:
		$1 = { 2D E9 F0 4F 95 B0 A2 4B 1D EE 70 2F 0B 90 0C 92 7B 44 1B 68 47 69 D6 58 1E 9B 0E 91 DD F8 80 90 1B 68 07 93 33 68 D3 F8 18 01 05 90 00 28 51 D0 07 99 D3 F8 1C 01 0A 1D D3 F8 20 11 D3 F8 28 A1 0D 90 0A 91 1F 99 D3 F8 24 01 91 42 0F 90 C0 F0 88 80 1F 98 00 21 0D 46 09 91 C3 1C 9A 1A 96 08 01 36 09 9B 00 24 05 9A 0D 98 1A 44 07 9B 52 08 08 92 50 F8 22 00 0A 9A 06 90 02 EB 80 08 52 F8 20 10 06 E0 58 F8 04 1F 01 34 00 29 76 D0 B4 42 6A D0 1A 46 04 33 10 68 88 42 F3 D0 00 2C 6B D1 1F 98 90 42 64 D9 06 99 0A 98 0C 44 13 68 50 F8 24 20 9A 42 5C D3 08 9A 05 92 09 98 05 9B 98 42 CF D3 74 4B 0C 99 7B 44 1B 68 51 F8 03 A0 DA F8 00 B0 01 E0 9B 46 B2 46 DB F8 34 61 36 B9 DB F8 2C 31 06 20 5B BB 15 B0 BD E8 F0 8F 1E 9A 07 98 1F 99 12 68 03 1D 99 42 DB F8 38 41 05 92 D2 F8 00 80 78 D3 00 2E C8 BF 00 25 0F DC E7 E7 63 68 C0 EB 08 00 98 45 05 D8 A1 68 ?? ?? ?? ?? 00 29 00 F0 AB 80 AE 42 04 F1 0C 04 D8 D0 20 68 01 35 80 45 EC D2 DB F8 2C 31 06 20 00 2B D3 D0 DB F8 30 51 07 9B 1F 98 1A 1D 12 95 DA F8 00 30 90 42 D3 F8 2C 61 6E D2 07 99 81 42 0C BF 04 20 07 20 C1 E7 07 9A 8A 42 4A D0 07 20 15 B0 BD E8 F0 8F 08 99 01 31 09 91 A0 E7 00 29 F5 D1 08 9B 0F 98 11 96 DD F8 2C B0 50 F8 23 20 0E 9E 90 46 10 94 5A F8 22 30 0A EB 88 01 00 2B 2A D0 08 F1 01 08 0A 46 00 E0 80 46 53 68 14 1D 08 F1 01 00 22 46 00 2B F7 D1 D9 F8 00 20 38 46 12 91 13 92 ?? ?? ?? ?? 13 A9 23 46 00 91 58 46 01 95 31 46 02 95 12 AA 03 95 B8 47 06 28 13 D1 08 F1 01 08 5A F8 28 30 00 2B D6 D1 10 9C 07 9B 11 9E 03 EB 84 02 56 E7 0C 46 DE E7 07 9A 1F 9B 9A 42 B4 D1 04 20 71 E7 04 28 10 9C 08 D0 05 28 3F F4 6C AF 13 9B C9 F8 00 30 15 B0 BD E8 F0 8F 1E 9A 00 20 21 99 13 68 0A 68 1E 99 03 EB 84 03 0B 60 53 1C 21 9A 13 60 EC E7 D9 F8 00 30 38 46 00 24 13 93 ?? ?? ?? ?? 05 EB 86 03 0B 98 0E 99 13 AD 01 94 12 AA 00 95 02 94 03 94 B8 47 06 28 3F F4 44 AF 04 28 D5 D1 21 9A 20 46 1E 99 13 68 0A 68 21 99 01 33 0B 60 13 1D 1E 9A 13 60 C9 E7 21 98 03 68 05 98 01 33 02 1D 08 46 1E 99 0A 60 21 9A 13 60 2A E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "__gconv_translit_find"
		size = 524
		refs = "0010 .LANCHOR0 0038 trans_compare 0044 __tfind 0090 __gconv_path_elem 0094 strlen 00b8 .LC6 00c4 memcmp 00ce __gconv_max_path_elem_len 00de malloc 0120 mempcpy 014a stpcpy 0176 __tsearch 01b0 __gconv_get_path 01d4 __libc_do_syscall 01e2 __lll_lock_wait_private 01e8 .LC4 01ec .LC5 01f0 __PRETTY_FUNCTION__.11206 0204 __assert_fail"
	strings:
		$1 = { 03 68 2D E9 F0 47 05 46 82 B0 00 2B 00 F0 EC 80 ?? ?2 0? 0? 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 D1 80 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? 71 49 ?? ?? ?? ?? 07 46 00 B3 00 68 43 6A DB B1 01 33 18 BF 00 26 00 F0 95 80 00 21 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 00 F3 9B 80 30 46 02 B0 BD E8 F0 87 01 26 E6 E7 28 68 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? D8 F8 00 30 00 F1 01 09 00 2B 00 F0 82 80 B9 F1 04 0F 98 BF 01 26 0C D9 2B 68 03 38 ?? ?2 0? 0? 03 22 18 44 ?? ?2 0? 0? ?? ?? ?? ?? 06 1C 18 BF 01 26 ?? ?2 0? 0? ?? ?2 0? 0? 18 68 2F 30 00 EB 49 00 ?? ?? ?? ?? 07 46 00 28 D0 D0 00 F1 08 03 00 F1 2C 0E 00 21 70 46 79 60 4A 46 43 F8 04 1B 43 F8 04 1B 43 F8 04 1B 43 F8 04 1B 43 F8 04 1B 43 F8 04 1B 43 F8 04 1B 43 F8 04 1B 19 60 C7 F8 00 E0 29 68 ?? ?? ?? ?? D8 F8 00 30 19 68 38 62 D1 B1 ?? ?2 0? 0? 98 46 ?? ?2 0? 0? 07 E0 38 46 FF F7 CA FD F8 B1 58 F8 08 1F 69 B1 38 6A ?? ?? ?? ?? 29 68 4A 46 ?? ?? ?? ?? 03 46 00 2E EE D0 DA F8 00 00 18 60 EA E7 01 26 00 23 3B 62 ?? ?2 0? 0? 38 46 ?? ?2 0? 0? 24 49 ?? ?? ?? ?? 00 28 08 BF 01 26 6C E7 06 46 F1 E7 FF F7 A5 FD 00 28 7F F4 7D AF D7 F8 00 C0 06 46 BC E8 0F 00 0F C5 9C E8 0F 00 85 E8 0F 00 3B 68 9A 6A 01 32 9A 62 56 E7 01 90 ?? ?? ?? ?? 01 98 78 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? 53 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 27 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 A6 72 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_itoa_word"
		size = 176
		refs = "0004 _itoa_lower_digits 0008 _itoa_upper_digits 0034 __aeabi_uidivmod 0044 __aeabi_uidiv"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 17 46 00 2B 18 BF 2E 46 0A 2A 04 46 30 D0 10 2A 22 D0 08 2A 18 BF 01 F1 FF 38 11 D0 20 46 39 46 ?? ?? ?? ?? 45 46 20 46 73 5C 39 46 08 F8 01 39 ?? ?? ?? ?? 04 46 00 28 F0 D1 28 46 BD E8 F0 81 01 39 04 F0 07 03 E4 08 0D 46 F3 5C 01 F8 01 39 F7 D1 28 46 BD E8 F0 81 01 39 04 F0 0F 03 24 09 0D 46 F3 5C 01 F8 01 39 F7 D1 28 46 BD E8 F0 81 4C F6 CD 40 01 39 CC F6 CC 40 A0 FB 04 23 0D 46 DB 08 03 EB 83 02 A4 EB 42 02 1C 46 B3 5C 01 F8 01 39 00 2C F1 D1 28 46 BD E8 F0 81 }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "_itoa"
		size = 902
		refs = "0006 _itoa_lower_digits 000a _itoa_upper_digits 004e .LANCHOR0"
	strings:
		$1 = { 2D E9 F0 0F 8C B0 ?? ?2 0? 0? ?? ?2 0? 0? 14 9C ?? ?2 0? 0? ?? ?2 0? 0? 00 2C 18 BF A8 46 08 2B 7B D0 10 2B 11 D1 00 29 40 F0 A1 80 01 46 01 3A 01 F0 0F 03 09 09 10 46 18 F8 03 30 02 F8 01 39 F6 D1 0C B0 BD E8 F0 0F 70 47 A3 F1 02 0C ?? ?2 0? 0? ?? ?2 0? 0? 0C EB 8C 0C 04 EB 8C 0C 00 29 40 F0 91 80 07 46 4F F0 01 0B 09 90 0C AE 08 A8 06 EB 8B 0B 9C F8 04 60 03 90 AB F1 14 0B 10 46 4F F0 30 0A DC F8 00 90 6E BB 41 1E 00 2F 00 F0 1A 81 A7 FB 09 45 9C F8 05 40 08 46 01 36 25 FA 04 F4 03 FB 14 75 27 46 18 F8 05 50 01 F8 01 59 00 2C EE D1 03 99 8B 45 00 F0 5C 81 9C F8 09 10 8E 42 08 DA 41 1E 08 46 01 F8 01 A9 9C F8 09 40 01 36 B4 42 F7 DC 9C F8 04 60 5B F8 04 79 DC F8 00 90 00 2E D1 D0 00 2F 00 F0 ED 80 44 1E 00 26 A7 FB 09 01 9C F8 05 50 01 36 78 1A 01 3D 01 EB 50 01 20 46 E9 40 03 FB 11 75 0F 46 18 F8 05 50 04 F8 01 59 00 29 EB D1 CC E7 03 46 C9 B1 14 46 A2 F1 0A 05 00 F0 07 03 C0 08 18 F8 03 30 04 F8 01 3D AC 42 F6 D1 01 F0 01 03 49 08 08 BF 22 46 40 EA 83 03 1F BF 18 F8 03 00 0B 46 02 F8 0B 0C 0B 3A 01 3A 03 F0 07 01 DB 08 10 46 18 F8 01 10 02 F8 01 19 F6 D1 0C B0 BD E8 F0 0F 70 47 A2 F1 08 04 00 F0 0F 03 00 09 18 F8 03 30 02 F8 01 3D A2 42 F6 D1 53 E7 DC F8 0C 40 9C F8 08 90 A1 42 04 FA 09 FA C0 F0 99 80 B9 F1 00 0F 00 F0 C5 80 C9 F1 40 05 00 27 C5 F1 20 06 20 FA 05 F4 01 FA 06 F6 20 3D 34 43 21 FA 05 F5 2C 43 05 94 26 46 CD E9 00 67 DC F8 10 70 C9 F1 20 04 00 9E 04 94 C4 F1 20 04 04 9D 01 FA 04 F4 03 97 A6 FB 07 67 20 FA 05 FB 4B EA 04 0B A5 F1 20 04 21 FA 04 F4 03 99 4B EA 04 0B 01 9C 05 9D CD E9 06 67 01 FB 04 76 05 99 2E 44 A6 FB 0A 45 BB EB 04 07 61 EB 05 04 44 B1 B7 EB 0A 05 64 F1 00 04 2F 46 00 2C 40 F0 A1 80 01 36 57 45 03 99 28 BF CA EB 07 07 00 FA 09 FB 28 BF 01 36 A7 FB 01 45 7C 19 A4 FB 0A 01 BB EB 00 05 67 EB 01 00 38 B1 B5 EB 0A 07 60 F1 00 00 3D 46 00 28 6E D1 01 34 55 45 24 BF CA EB 05 05 01 34 25 FA 09 F7 0B 97 B9 F1 00 0F 05 D0 04 9D 06 FA 09 F6 24 FA 05 F1 0E 43 03 9D 04 FA 09 F4 A6 FB 05 01 06 EB 01 0B AB FB 0A 01 25 1A 66 EB 01 00 40 B1 B5 EB 0A 06 60 F1 00 00 35 46 00 28 4F D1 0B F1 01 0B 55 45 24 BF CA EB 05 05 0B F1 01 0B CD F8 24 B0 4F F0 03 0B 25 FA 09 F5 0A 95 D2 E6 3E 46 F4 E6 A9 F1 20 04 01 FA 09 F1 00 FA 04 F4 C9 F1 20 05 20 FA 05 F5 21 43 DC F8 10 40 29 43 00 FA 09 F0 A1 FB 04 45 01 EB 05 0B AB FB 0A 45 06 1B 61 EB 05 01 39 B1 B6 EB 0A 04 61 F1 00 01 26 46 29 BB 0B F1 01 0B 56 45 24 BF CA EB 06 06 0B F1 01 0B CD F8 24 B0 4F F0 02 0B 26 FA 09 F7 0A 97 A0 E6 00 24 00 25 CD F8 14 90 CD E9 00 45 45 E7 B7 EB 0A 01 60 F1 00 00 02 34 0D 46 8A E7 B6 EB 0A 01 60 F1 00 00 0B F1 02 0B 0D 46 A9 E7 B4 EB 0A 05 61 F1 00 01 0B F1 02 0B 2E 46 D3 E7 B5 EB 0A 01 64 F1 00 04 02 36 0F 46 58 E7 90 42 01 46 7F F4 63 AE 30 23 01 38 01 F8 01 3C 5D E6 }
	condition:
		$1
}

rule file_135_2_0 {
	meta:
		name = "_fitoa_word"
		size = 46
		refs = "0008 _itoa_word"
	strings:
		$1 = { 30 B5 85 B0 0D 46 04 A9 ?? ?? ?? ?? 04 A9 88 42 0A D2 03 46 2A 46 13 F8 01 4B 04 A9 8B 42 02 F8 01 4B F8 D1 08 1A 05 44 28 46 05 B0 30 BD }
	condition:
		$1
}

rule file_135_3_0 {
	meta:
		name = "_fitoa"
		size = 50
		refs = "000c _itoa"
	strings:
		$1 = { 30 B5 8B B0 15 46 0A AA 0E 9C 00 94 ?? ?? ?? ?? 0A AA 90 42 0A D2 03 46 29 46 13 F8 01 4B 0A AA 93 42 01 F8 01 4B F8 D1 10 1A 05 44 28 46 0B B0 30 BD }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__nscd_getgrouplist"
		size = 602
		refs = "000e strlen 0012 .LC0 0016 __gr_map_handle 0024 __nss_not_use_nscd_group 003c __nscd_get_map_ref 0052 __nscd_cache_search 00be __libc_do_syscall 0150 __nscd_open_socket 0180 memcpy 01ac __nscd_unmap 01c0 realloc 01e2 __readall 020a .LC1 020e .LC2 0212 __PRETTY_FUNCTION__.14904 0224 __assert_fail 0238 .LC3"
	strings:
		$1 = { 2D E9 F0 4F 8B B0 0D 46 93 46 99 46 04 90 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 06 AB ?? ?2 0? 0? 07 AF ?? ?2 0? 0? 02 97 05 94 4F F0 00 0A 01 30 03 90 0C 20 ?? ?? ?? ?? 04 46 61 1C 7E D0 0C 22 0F 20 00 92 23 46 04 99 03 9A ?? ?? ?? ?? 06 46 00 28 73 D0 00 F1 18 03 D6 F8 04 C0 27 68 06 F1 24 08 93 E8 07 00 63 44 DD F8 08 C0 BE 68 8C E8 07 00 06 9A 96 42 40 F0 B9 80 09 99 08 EB 81 01 8B 42 C0 F0 B6 80 08 9E 4F F0 FF 37 01 2E 65 D0 72 1C 00 F0 C9 80 DB F8 00 30 00 2B 40 F3 C8 80 D9 F8 00 00 00 23 5E 1C 40 F8 23 50 7B 1C 04 D0 38 46 4F F0 06 0C ?? ?? ?? ?? 67 1C 18 D0 27 68 06 9A BB 68 9A 42 17 D1 04 F1 0C 02 E3 68 BF F3 5F 8F 58 1E 52 E8 00 1F 99 42 03 D1 42 E8 00 05 00 2D F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 58 D0 30 46 0B B0 BD E8 F0 8F D8 07 06 93 06 D4 0A F1 01 0A BA F1 05 0F 01 D0 71 1C 96 D1 04 F1 0C 02 E3 68 BF F3 5F 8F 58 1E 52 E8 00 1F 99 42 03 D1 42 E8 00 07 00 2F F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 75 D0 72 1C DB D0 4F F0 FF 34 0C 22 07 AB 00 92 0F 22 04 98 03 99 ?? ?? ?? ?? 43 1C 07 46 52 D0 08 9E 4F F0 00 08 01 2E 99 D1 09 9E 00 2E 4F DB DB F8 00 30 9E 42 22 DA D9 F8 00 00 B8 F1 00 0F 2F D0 41 46 B2 00 ?? ?? ?? ?? 00 2E 95 DB D9 F8 00 00 63 D0 03 68 AB 42 8F D0 02 46 00 23 03 E0 52 F8 04 1F A9 42 88 D0 01 33 B3 42 F8 D1 81 E7 20 46 ?? ?? ?? ?? 30 46 0B B0 BD E8 F0 8F 71 1C D9 F8 00 00 89 00 ?? ?? ?? ?? 03 46 90 B1 09 9A C9 F8 00 30 16 46 01 32 CB F8 00 20 B8 F1 00 0F CF D1 01 46 B2 00 38 46 ?? ?? ?? ?? 09 9E B0 EB 86 0F CA D0 4F F0 FF 36 5F E7 6F F0 01 06 67 E7 4F F0 FF 36 64 E7 05 9B 01 22 3E 46 1A 60 5B E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 64 22 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 85 E7 05 9B 01 22 1A 60 3D E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8F 22 ?? ?? ?? ?? 33 46 29 E7 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "__uselocale"
		size = 428
		refs = "000e _nl_global_locale 0020 _nl_current_LC_COLLATE_used 004a _nl_current_LC_CTYPE_used 005c _nl_current_LC_MONETARY_used 0072 _nl_current_LC_NUMERIC_used 0086 _nl_current_LC_TIME_used 009c _nl_current_LC_MESSAGES_used 00b2 _nl_current_LC_PAPER_used 00c8 _nl_current_LC_NAME_used 00de _nl_current_LC_ADDRESS_used 00f4 _nl_current_LC_TELEPHONE_used 010a _nl_current_LC_MEASUREMENT_used 0120 _nl_current_LC_IDENTIFICATION_used 0168 __libc_tsd_LOCALE 0170 _nl_current_LC_COLLATE 0174 _nl_current_LC_CTYPE 0178 _nl_current_LC_MONETARY 017c _nl_current_LC_NUMERIC 0180 _nl_current_LC_TIME 0184 _nl_current_LC_MESSAGES 0188 _nl_current_LC_PAPER 018c _nl_current_LC_NAME 0190 _nl_current_LC_ADDRESS 0194 _nl_current_LC_TELEPHONE 0198 _nl_current_LC_MEASUREMENT 019c _nl_current_LC_IDENTIFICATION 01a0 __libc_tsd_CTYPE_B 01a4 __libc_tsd_CTYPE_TOLOWER 01a8 __libc_tsd_CTYPE_TOUPPER"
	strings:
		$1 = { 59 49 1D EE 70 3F F0 B4 79 44 09 68 5E 58 ?? ?2 0? 0? 00 28 00 F0 A5 80 54 4C 42 1C 18 BF 02 46 ?? ?2 0? 0? 7C 44 24 68 08 BF ?? ?2 0? 0? ?? ?2 0? 0? 0C BF 0A 46 ?? ?2 0? 0? 1A 51 28 B1 4C 48 02 F1 0C 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 18 B1 47 48 78 44 00 68 1A 50 ?? ?2 0? 0? ?? ?2 0? 0? 28 B1 44 48 02 F1 10 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 20 B1 3F 48 14 1D 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 28 B1 3B 48 02 F1 08 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 28 B1 37 48 02 F1 14 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 28 B1 32 48 02 F1 1C 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 2C B1 2E 48 02 F1 20 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 2C B1 29 48 02 F1 24 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 2C B1 25 48 02 F1 28 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 2C B1 20 48 02 F1 2C 04 78 44 00 68 1C 50 ?? ?2 0? 0? ?? ?2 0? 0? 2C B1 1C 48 02 F1 30 04 78 44 00 68 1C 50 1A 4C 50 6B 7C 44 24 68 19 4D 97 6B 18 51 7D 44 2D 68 17 4C D2 6B 5F 51 7C 44 24 68 1A 51 8E 42 14 BF 30 46 4F F0 FF 30 F0 BC 70 47 ?? ?2 0? 0? F5 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "xdr_int64_t"
		size = 110
		altNames = "xdr_uint64_t"
	strings:
		$1 = { 70 B5 04 46 05 68 82 B0 0E 46 01 2D 05 D0 0C D3 AB 1E 58 42 58 41 02 B0 70 BD 43 68 69 46 1B 6A 98 47 A8 B9 00 20 02 B0 70 BD 0D 68 69 46 72 68 43 68 8D E8 24 00 5B 6A 98 47 00 28 F2 D0 63 68 20 46 01 A9 5B 6A 98 47 00 30 18 BF 01 20 E2 E7 63 68 20 46 01 A9 1B 6A 98 47 00 28 E2 D0 00 9B 00 22 01 99 28 46 0A 43 C6 E9 00 23 D3 E7 }
	condition:
		$1
}

rule file_140_4_0 {
	meta:
		name = "xdr_int32_t"
		size = 34
		altNames = "xdr_uint32_t"
	strings:
		$1 = { 02 68 08 B5 01 2A 04 D0 07 D3 93 1E 58 42 58 41 08 BD 43 68 1B 6A 98 47 08 BD 43 68 5B 6A 98 47 08 BD }
	condition:
		$1
}

rule file_140_6_0 {
	meta:
		name = "xdr_int16_t"
		size = 66
	strings:
		$1 = { 30 B5 0D 46 04 68 83 B0 01 2C 05 D0 0F D3 A3 1E 58 42 58 41 03 B0 30 BD 43 68 01 A9 1B 6A 98 47 00 28 F7 D0 01 9B 20 46 2B 80 03 B0 30 BD B1 F9 00 20 02 A9 43 68 41 F8 04 2D 5B 6A 98 47 03 B0 30 BD }
	condition:
		$1
}

rule file_140_7_0 {
	meta:
		name = "xdr_uint16_t"
		size = 64
	strings:
		$1 = { 30 B5 0D 46 04 68 83 B0 01 2C 05 D0 0F D3 A3 1E 58 42 58 41 03 B0 30 BD 43 68 01 A9 1B 6A 98 47 00 28 F7 D0 01 9B 20 46 2B 80 03 B0 30 BD 0A 88 02 A9 43 68 41 F8 04 2D 5B 6A 98 47 03 B0 30 BD }
	condition:
		$1
}

rule file_140_8_0 {
	meta:
		name = "xdr_int8_t"
		size = 66
	strings:
		$1 = { 30 B5 0D 46 04 68 83 B0 01 2C 05 D0 0F D3 A3 1E 58 42 58 41 03 B0 30 BD 43 68 01 A9 1B 6A 98 47 00 28 F7 D0 01 9B 20 46 2B 70 03 B0 30 BD 91 F9 00 20 02 A9 43 68 41 F8 04 2D 5B 6A 98 47 03 B0 30 BD }
	condition:
		$1
}

rule file_140_9_0 {
	meta:
		name = "xdr_uint8_t"
		size = 64
	strings:
		$1 = { 30 B5 0D 46 04 68 83 B0 01 2C 05 D0 0F D3 A3 1E 58 42 58 41 03 B0 30 BD 43 68 01 A9 1B 6A 98 47 00 28 F7 D0 01 9B 20 46 2B 70 03 B0 30 BD 0A 78 02 A9 43 68 41 F8 04 2D 5B 6A 98 47 03 B0 30 BD }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__remap_file_pages"
		size = 22
		refs = "0012 __syscall_error"
		altNames = "__getsockopt __mount __mremap __prctl __setsockopt fsetxattr init_module lsetxattr name_to_handle_at setxattr"
	strings:
		$1 = { 90 B4 02 9C 04 4F 00 DF 90 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "___vfprintf_chk"
		size = 308
		refs = "0060 vfprintf 00c8 __libc_do_syscall 00ce __lll_lock_wait_private 0130 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F0 41 1D 46 03 68 0E 46 04 46 17 46 19 04 1D D4 80 6C 1D EE 70 8F A8 F5 98 68 83 68 43 45 12 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 46 D1 A3 6C 18 46 C3 F8 08 80 43 68 01 33 43 60 00 2E 39 46 2A 46 20 46 C2 BF E3 6B 43 F0 04 03 E3 63 ?? ?? ?? ?? E3 6B 00 2E 22 68 05 46 C4 BF 23 F0 04 03 E3 63 12 04 23 F0 14 03 E3 63 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 02 DC 28 46 BD E8 F0 81 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? B5 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1269_0_0 {
	meta:
		name = "__vfwprintf_chk"
		size = 308
		refs = "0060 _IO_vfwprintf 00c8 __libc_do_syscall 00ce __lll_lock_wait_private 0130 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F0 41 1D 46 03 68 0E 46 04 46 17 46 19 04 1D D4 80 6C 1D EE 70 8F A8 F5 98 68 83 68 43 45 12 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 46 D1 A3 6C 18 46 C3 F8 08 80 43 68 01 33 43 60 00 2E 39 46 2A 46 20 46 C2 BF E3 6B 43 F0 04 03 E3 63 ?? ?? ?? ?? E3 6B 00 2E 22 68 05 46 C4 BF 23 F0 04 03 E3 63 12 04 23 F0 14 03 E3 63 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 02 DC 28 46 BD E8 F0 81 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? B5 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "sigemptyset"
		size = 40
		refs = "0008 memset 0024 __libc_errno"
	strings:
		$1 = { 08 B5 28 B1 00 21 80 22 ?? ?? ?? ?? 00 20 08 BD 04 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 08 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "w_addword"
		size = 104
		refs = "0014 realloc 003e calloc 0060 free"
	strings:
		$1 = { F8 B5 0D 46 04 46 C1 B1 02 68 83 68 40 68 13 44 99 1C 89 00 ?? ?? ?? ?? 07 46 18 B3 26 68 00 23 A2 68 18 46 71 1C 67 60 16 44 21 60 0A 44 47 F8 26 50 64 68 44 F8 22 30 F8 BD 01 20 01 46 ?? ?? ?? ?? 06 46 05 46 68 B1 22 68 A3 68 60 68 13 44 99 1C 89 00 ?? ?? ?? ?? 07 46 00 28 DE D1 30 46 ?? ?? ?? ?? 01 20 F8 BD }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "w_addchar"
		size = 102
		refs = "0030 realloc 0042 free 0048 .LC0 004c .LC1 0050 __PRETTY_FUNCTION__.13234 0062 __assert_fail"
	strings:
		$1 = { 70 B5 0D 46 04 46 09 68 10 68 1E 46 81 42 08 D0 2C B1 66 54 00 22 2B 68 01 33 2B 60 E2 54 20 46 70 BD 04 B1 81 B1 01 F1 64 03 20 46 13 60 65 31 ?? ?? ?? ?? 03 46 10 B1 04 46 29 68 E9 E7 20 46 1C 46 ?? ?? ?? ?? EA E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 66 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_2_0 {
	meta:
		name = "parse_backslash"
		size = 52
	strings:
		$1 = { 70 B5 06 46 04 9C 25 68 01 35 5B 5D 73 B1 0A 2B 09 D0 00 68 FF F7 C0 FF 30 60 48 B1 23 68 00 20 01 33 23 60 70 BD 25 60 00 20 70 BD 05 20 70 BD 01 20 70 BD }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "parse_qtd_backslash"
		size = 138
	strings:
		$1 = { 2D E9 F0 47 1E 46 08 9D 80 46 8A 46 91 46 2B 68 5F 1C F4 5D 22 2C 27 D0 09 D8 2C B1 0A 2C 0C D1 2F 60 00 20 BD E8 F0 87 05 20 BD E8 F0 87 5C 2C 1A D0 60 2C 18 D0 24 2C 16 D0 F3 5C 51 46 D8 F8 00 00 4A 46 FF F7 8E FF C8 F8 00 00 48 B1 2B 68 51 46 4A 46 1E 44 73 78 FF F7 84 FF C8 F8 00 00 68 B9 01 20 BD E8 F0 87 51 46 4A 46 23 46 D8 F8 00 00 FF F7 77 FF C8 F8 00 00 00 28 F1 D0 2B 68 00 20 01 33 2B 60 BD E8 F0 87 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "w_addmem"
		size = 134
		refs = "002e realloc 0040 mempcpy 0062 free 0068 .LC0 006c .LC1 0070 __PRETTY_FUNCTION__.13243 0082 __assert_fail"
	strings:
		$1 = { 2D E9 F0 41 04 46 06 9D 0E 46 08 68 98 46 17 68 00 EB 05 0C BC 45 1D D9 04 B1 2F B3 6B 00 20 46 64 2B 2C BF F9 18 07 F1 64 01 11 60 01 31 ?? ?? ?? ?? 03 46 98 B1 04 46 30 68 2A 46 20 44 41 46 ?? ?? ?? ?? 00 23 03 70 33 68 1D 44 35 60 20 46 BD E8 F0 81 00 2C F0 D1 20 46 BD E8 F0 81 20 46 1C 46 ?? ?? ?? ?? F2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 81 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "exec_comm"
		size = 1222
		refs = "0022 __have_pipe2 003c __pipe2 0068 __pipe 007c __fork 0098 __close 00b4 __read 00ce strchr 0156 __kill 0176 __waitpid 0344 .LC3 0352 .LC2 036e __dup2 0384 .LC4 038e __open 03aa __fxstat64 03d0 _exit 03ec __libc_errno 044c .LC6 0462 .LC5 046a __unsetenv 0476 __environ 048a __execve 048e abort 0494 free 04c0 __fcntl"
	strings:
		$1 = { 2D E9 F0 4F CD B0 0E 46 93 46 04 93 00 23 08 90 0B 93 00 28 00 F0 CF 80 08 9A 13 78 00 2B 00 F0 CA 80 ?? ?2 0? 0? ?? ?2 0? 0? 09 93 1B 68 00 2B 17 DB 0C AA 4F F4 00 21 10 46 06 92 ?? ?? ?? ?? 09 99 0B 68 33 B9 44 1C 18 BF 01 23 00 F0 6A 81 09 9A 13 60 00 2B 40 F3 EC 80 00 28 08 DA 01 20 92 E0 0C A9 06 91 06 98 ?? ?? ?? ?? 00 28 F6 DB 00 25 DD F8 60 A1 A9 46 CD F8 14 B0 ?? ?? ?? ?? 00 28 07 90 C0 F2 A6 81 00 F0 58 81 00 2D 40 F0 AA 81 06 99 2C AF 48 68 ?? ?? ?? ?? 06 9A 4F F0 FF 33 53 60 57 9B 00 2B 00 F0 C6 80 06 99 80 22 08 68 39 46 ?? ?? ?? ?? B0 F1 FF 3F 80 46 7E D0 00 28 40 F3 85 80 00 24 18 E0 59 98 59 46 ?? ?? ?? ?? 00 28 2F D1 02 2D 05 46 0C D0 57 98 31 68 FF F7 82 FE 01 28 34 D0 00 22 04 9B 05 99 91 46 1A 60 0A 60 32 60 01 34 A0 45 D7 DD 17 F8 04 B0 50 46 59 46 ?? ?? ?? ?? 02 46 00 28 DD D1 03 2D 41 D0 32 68 BB F1 0A 0F 10 46 5B 46 05 99 04 9A 0C BF 09 F1 01 09 4F F0 00 09 FF F7 91 FE 30 60 78 B1 01 25 DF E7 BB F1 0A 0F 28 D0 25 F0 02 03 01 2B D8 D1 57 98 02 25 31 68 FF F7 4D FE 01 28 CA D1 07 98 09 21 ?? ?? ?? ?? A4 4C 07 9D 07 E0 23 46 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 06 D1 00 21 28 46 0A 46 ?? ?? ?? ?? 01 30 F0 D0 06 9A 10 68 ?? ?? ?? ?? 01 20 4D B0 BD E8 F0 8F 01 2D 08 BF 03 25 AF E7 31 68 57 98 03 92 FF F7 24 FE 03 9A 01 28 D5 D0 04 9B 05 99 17 F8 04 B0 1A 60 0A 60 32 60 AE E7 00 20 4D B0 BD E8 F0 8F 8C 4B 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 3F F4 6E AF 18 F1 00 08 07 9C 18 BF 4F F0 01 08 07 E0 85 4B 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 09 D1 42 46 20 46 0B A9 ?? ?? ?? ?? 42 1C F0 D0 00 28 3F F4 55 AF 06 9C 08 E0 7C 4B 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 40 F0 84 80 20 68 39 46 80 22 ?? ?? ?? ?? 43 1C EF D0 00 28 80 46 06 94 3F F7 4B AF 50 E0 BF F6 1D AF 16 E7 07 9D DD F8 18 80 80 22 D8 F8 00 00 39 46 ?? ?? ?? ?? 42 1C 04 46 0D D0 00 28 13 DD 30 68 3B 46 05 99 A1 44 00 94 04 9A FF F7 8A FE 30 60 00 28 E9 D1 72 E7 63 4B 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B E0 D0 00 34 18 BF 01 24 07 E0 5E 4B 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 11 D1 28 46 0B A9 22 46 ?? ?? ?? ?? 43 1C F0 D0 00 28 CB D0 07 E0 56 4B 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 0B D1 39 46 D8 F8 00 00 80 22 ?? ?? ?? ?? 41 1C EF D0 00 28 04 46 C2 DC 01 E0 CD F8 18 80 09 F1 FF 39 00 20 05 9A 0F E0 13 68 83 B1 31 68 01 3B CC 5C 0A 2C 0B D1 13 60 09 F1 FF 35 C8 54 14 68 00 2C 00 F0 CB 80 A9 46 B9 F1 FF 3F EC D1 06 99 08 68 ?? ?? ?? ?? 06 99 0B 9B 4F F0 FF 32 0A 60 00 2B 3F F4 4D AF 01 25 AD E6 06 94 D7 E7 38 4B 1D EE 70 2F 7B 44 1B 68 D3 58 26 2B 0C BF 4F F0 FF 33 01 23 89 E6 00 2D 40 F0 81 80 56 9A ?? ?2 0? 0? 08 99 ?? ?2 0? 0? 02 F0 10 04 ?? ?2 0? 0? ?? ?2 0? 0? 11 95 10 91 0E 92 0F 93 06 9A 50 68 01 28 00 F0 A3 80 01 21 ?? ?? ?? ?? 06 9B 58 68 ?? ?? ?? ?? 00 2C 71 D1 02 20 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 01 21 ?? ?? ?? ?? 83 1E 04 46 18 BF 01 23 00 28 B8 BF 00 23 00 2B 7F D1 03 20 02 21 12 AA ?? ?? ?? ?? 70 B9 16 9B 03 F4 70 43 B3 F5 00 5F 08 D1 DD E9 1A 23 40 F2 03 10 00 21 8B 42 08 BF 82 42 49 D0 5A 20 ?? ?? ?? ?? 06 9B 18 68 ?? ?? ?? ?? 06 99 48 68 ?? ?? ?? ?? 3B E6 09 4C 07 9D 1A E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 23 46 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 7F F4 CA AE 0B A9 28 46 00 22 ?? ?? ?? ?? 41 1C EF D0 07 9B 83 42 7F F4 BF AE 0B 98 00 28 14 BF 05 20 00 20 A1 E6 08 99 ?? ?2 0? 0? 07 9C ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 10 91 11 94 0E 92 0F 93 7F E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 06 9A 10 68 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0E A9 ?? ?2 0? 0? 1A 68 ?? ?? ?? ?? ?? ?? ?? ?? 30 68 ?? ?? ?? ?? 04 9A 05 9B 14 60 1C 60 34 60 2F E7 02 21 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 78 E7 09 99 0B 68 00 2B 7F F7 5F AF 02 21 00 22 ?? ?? ?? ?? 59 E7 }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "parse_backtick"
		size = 206
		refs = "0052 free"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 1F 46 83 46 12 9E 00 23 8A 46 91 46 06 93 35 68 05 93 07 93 7C 5D 00 2C 54 D0 98 46 5C 2C 2F D0 60 2C 17 D0 27 2C 01 D1 C8 F1 01 08 23 46 07 98 05 A9 06 AA FF F7 A5 FC 07 90 00 28 40 D0 35 68 01 35 35 60 7C 5D 00 2C E8 D1 07 98 ?? ?? ?? ?? 05 20 12 E0 15 9C 59 46 13 9A 14 9B 02 94 16 9C 00 92 52 46 01 93 4B 46 03 94 07 98 FF F7 61 FD 04 46 07 98 ?? ?? ?? ?? 20 46 09 B0 BD E8 F0 8F B8 F1 00 0F 0B D0 00 96 07 A8 05 A9 06 AA 3B 46 FF F7 C5 FC 04 46 70 B9 4F F0 01 08 CF E7 00 96 01 35 07 A8 35 60 05 A9 06 AA 3B 46 FF F7 9D FC 04 46 00 28 C3 D0 07 98 ?? ?? ?? ?? 20 46 DC E7 01 20 DA E7 20 46 C1 E7 }
	condition:
		$1
}

rule file_144_7_0 {
	meta:
		name = "eval_expr_multdiv"
		size = 184
		refs = "0088 __aeabi_idiv 00b0 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 47 82 B0 81 46 0E 46 00 F0 AD F8 80 46 28 B1 4F F0 05 08 40 46 02 B0 BD E8 F0 87 24 4F DF F8 90 A0 D9 F8 00 30 1A 78 00 2A F3 D0 39 46 1D EE 70 0F 79 44 09 68 41 58 31 F8 12 10 89 04 13 D5 5C 1C 0B E0 14 F8 01 2B 00 2A E3 D0 51 46 79 44 09 68 45 58 35 F8 12 50 AD 04 05 D5 23 46 C9 F8 00 40 00 2C EE D1 22 78 2A 2A 10 D0 2F 2A D1 D1 01 33 48 46 C9 F8 00 30 01 A9 00 F0 74 F8 00 28 C6 D1 30 68 01 99 ?? ?? ?? ?? 30 60 C9 E7 01 33 48 46 C9 F8 00 30 01 A9 00 F0 65 F8 00 28 B7 D1 33 68 01 9A 02 FB 03 F3 33 60 BA E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_8_0 {
	meta:
		name = "eval_expr_val"
		size = 172
		refs = "0072 strtol 00a8 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 41 88 46 01 68 07 46 B9 B1 0A 78 62 B3 25 4B 1D EE 70 0F 7B 44 1B 68 C6 58 36 F8 12 30 9C 04 3F D5 4B 1C 06 E0 13 F8 01 2B F2 B1 36 F8 12 40 A0 04 05 D5 1D 46 00 2B F5 D1 00 23 1D 46 1A 78 28 2A 12 D1 0A 78 29 2A 18 BF 00 2A 25 D0 4B 1C 3B 60 1C 46 13 F8 01 2B 29 2A 18 BF 00 2A F7 D1 82 B9 05 20 BD E8 F0 81 0D 46 28 46 39 46 00 22 ?? ?? ?? ?? 3B 68 AB 42 C8 F8 00 00 F1 D0 00 20 BD E8 F0 81 62 1C 00 23 3A 60 68 1C 41 46 23 70 FF F7 5D FF 00 28 E4 D1 F1 E7 0C 46 00 2A E0 D0 F0 E7 0D 46 CC E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_9_0 {
	meta:
		name = "eval_expr"
		size = 176
		refs = "00ac __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 47 84 B0 04 AF 8A 46 DF F8 A0 80 47 F8 0C 0D 38 46 FF F7 98 FF 81 46 C0 B1 4F F0 05 09 48 46 04 B0 BD E8 F0 87 1A 78 2B 2A 2F D0 2D 2A F6 D1 38 46 03 A9 01 33 01 93 FF F7 85 FF 00 28 EC D1 DA F8 00 20 03 9B D3 1A CA F8 00 30 01 9B 1A 78 00 2A E4 D0 41 46 1D EE 70 0F 79 44 09 68 45 58 35 F8 12 10 89 04 DF D5 01 33 07 E0 13 F8 01 2B 00 2A D4 D0 35 F8 12 40 A0 04 04 D5 01 93 1E 46 00 2B F3 D1 CF E7 2B 2A 33 46 CF D1 38 46 03 A9 01 33 01 93 FF F7 57 FF 00 28 BE D1 DA F8 00 20 03 9B 13 44 CA F8 00 30 D0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_10_0 {
	meta:
		name = "w_addstr"
		size = 68
		refs = "0010 strlen 0026 .LC7 002a .LC1 002e __PRETTY_FUNCTION__.13251 0040 __assert_fail"
	strings:
		$1 = { F0 B5 1C 46 83 B0 05 46 0F 46 16 46 5B B1 18 46 ?? ?? ?? ?? 39 46 32 46 23 46 00 90 28 46 FF F7 D5 FB 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 9B 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_11_0 {
	meta:
		name = "parse_tilde"
		size = 616
		refs = "002a strchr 0092 __strnlen 00c4 memcpy 00fc __getpwnam_r 018c .LC8 0194 getenv 01d6 __getuid 0220 __getpwuid_r 0260 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 8F B0 1D 46 02 AF 0B 68 B9 60 F8 60 7A 60 9B B1 04 68 23 44 13 F8 01 3C 3D 2B 09 D0 3A 2B 40 F0 8F 80 20 46 3D 21 ?? ?? ?? ?? 00 28 00 F0 88 80 FA 6D 00 2A 40 F0 84 80 BC 6D 21 68 48 1C 2E 18 2B 5C 13 F0 DF 0F 00 F0 9F 80 2F 2B 18 BF 3A 2B 00 F0 9A 80 09 2B 00 F0 97 80 5C 2B 18 BF 83 46 0A D1 A5 E0 3A 2B 18 BF 2F 2B 0B D0 09 2B 09 D0 5C 2B A3 46 00 F0 9C 80 0B F1 01 04 2B 5D 13 F0 DF 0F EF D1 A0 42 7F D0 C1 EB 0B 01 30 46 ?? ?? ?? ?? 00 25 31 46 4F F4 7A 74 07 F1 14 08 07 F1 10 06 DF F8 B8 A1 00 F1 0F 03 02 46 23 F0 07 03 AD EB 03 0D 0D F1 0F 03 DB 08 00 F8 33 50 D8 00 ?? ?? ?? ?? AD F5 7C 7D 02 AD 81 46 0F E0 51 46 79 44 09 68 5B 58 22 2B 43 D1 AD EB 02 0D 02 AB 03 EB 0E 02 95 42 1D 46 0C BF 74 44 74 46 2A 46 23 46 00 96 48 46 41 46 ?? ?? ?? ?? 04 F2 F7 3E 2E F0 0F 0E 1D EE 70 3F 0E F1 08 02 00 28 DE D1 3B 69 33 B3 BB 6A 23 B3 FC 68 B9 68 7A 68 20 68 FF F7 4A FF 03 46 20 60 BC 6D C4 F8 00 B0 D3 F1 01 00 07 F1 34 07 38 BF 00 20 BD 46 BD E8 F0 8F 20 46 7E 23 B9 68 7A 68 FF F7 88 FA FC 68 03 46 D0 F1 01 00 38 BF 00 20 23 60 34 37 BD 46 BD E8 F0 8F FC 68 7E 23 B9 68 7A 68 20 68 FF F7 76 FA 03 46 20 60 00 28 D7 D0 4B 46 B9 68 7A 68 FF F7 1B FF 03 46 20 60 CF E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? E8 B1 B9 68 03 46 7A 68 FC 68 20 68 FF F7 0A FF 03 46 20 60 00 28 C0 D1 01 20 D4 E7 FC 68 7E 23 B9 68 7A 68 20 68 FF F7 4F FA 34 37 03 46 D0 F1 01 00 38 BF 00 20 23 60 BD 46 BD E8 F0 8F ?? ?? ?? ?? AD F5 7C 7D 0D F1 08 09 4F F4 7A 74 07 F1 14 08 07 F1 10 06 DF F8 74 A0 05 46 0F E0 51 46 79 44 09 68 5B 58 22 2B 21 D1 AD EB 02 0D 02 AB 03 EB 0E 02 91 45 99 46 0C BF 74 44 74 46 4A 46 23 46 00 96 28 46 41 46 ?? ?? ?? ?? 04 F2 F7 3E 2E F0 0F 0E 1D EE 70 3F 0E F1 08 02 00 28 DE D1 3B 69 23 B1 BB 6A 13 B1 B9 68 7A 68 AC E7 FC 68 7E 23 B9 68 7A 68 20 68 FF F7 06 FA 03 46 20 60 00 28 7F F4 6A AF A7 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_144_12_0 {
	meta:
		name = "parse_arith"
		size = 534
		refs = "006c free 0156 _itoa_word 01b2 _itoa"
	strings:
		$1 = { 2D E9 F0 4F 93 B0 98 46 07 46 1C 9D 89 46 07 92 00 22 09 92 2B 68 08 92 0A 92 18 F8 03 40 00 2C 00 F0 DF 80 01 26 92 46 B3 46 3B 2C 00 F0 81 80 22 D8 24 2C 64 D0 40 F2 83 80 28 2C 5E D0 29 2C 02 D1 01 3E 00 F0 9B 80 23 46 0A 98 08 A9 09 AA FF F7 D2 F9 0A 90 00 28 00 F0 C1 80 2B 68 01 33 2B 60 18 F8 03 40 00 2C DF D1 0A 98 ?? ?? ?? ?? 05 20 13 B0 BD E8 F0 8F 60 2C 1B D0 55 D8 5C 2C 31 D0 5D 2C E0 D1 73 1E 1E 9A 5E 42 0A 98 5E 41 00 2A 08 BF 00 26 00 2E E8 D0 00 23 0B 93 03 78 00 2B 50 D0 0B A9 FF F7 A7 FD 00 28 40 F0 92 80 0B 98 49 E0 1D 9A 01 33 00 95 0A A8 2B 60 08 A9 01 92 43 46 CD F8 08 A0 09 AA CD F8 0C A0 CD F8 10 A0 FF F7 CD FC 04 46 00 28 BF D0 0A 98 ?? ?? ?? ?? 20 46 29 E0 00 95 0A A8 08 A9 09 AA 43 46 FF F7 D0 F9 04 46 00 28 B0 D0 EF E7 01 36 A3 E7 1D 99 0A A8 00 95 09 AA CD F8 08 A0 43 46 01 91 08 A9 CD F8 0C A0 CD F8 10 A0 CD F8 14 B0 00 F0 7B F8 04 46 00 28 99 D0 D8 E7 7B 2C 01 D0 7D 2C 8A D1 0A 98 ?? ?? ?? ?? 02 20 13 B0 BD E8 F0 8F 0A 2C F6 D0 80 E7 18 46 12 A9 00 22 13 46 3C 68 01 F8 04 2D 0A 22 ?? ?? ?? ?? 49 46 07 9A 03 46 20 46 FF F7 F7 FD 38 60 0A 98 ?? ?? ?? ?? 38 68 D0 F1 01 00 38 BF 00 20 13 B0 BD E8 F0 8F 1E 99 0B 96 0A 98 00 29 7F F4 71 AF 01 33 18 F8 03 20 29 2A 7F F4 6B AF 2B 60 00 24 03 78 1B BB E5 17 12 AA 29 46 20 46 3D 68 00 24 0A 23 02 F8 04 4D 00 94 ?? ?? ?? ?? 07 9A 49 46 03 46 28 46 FF F7 C9 FD 38 60 0A 98 ?? ?? ?? ?? 38 68 02 1B 50 42 50 41 B2 E7 0A 98 ?? ?? ?? ?? 05 20 AD E7 01 20 AB E7 20 46 42 E7 0B A9 FF F7 06 FD 00 28 F1 D1 0B 9C 00 2C D3 DA 38 68 49 46 07 9A 2D 23 FF F7 FB F8 64 42 E5 17 38 60 00 28 C9 D1 0A 98 ?? ?? ?? ?? 01 20 91 E7 }
	condition:
		$1
}

rule file_144_13_0 {
	meta:
		name = "parse_dollars"
		size = 3884
		refs = "0152 free 02b6 .LC11 02ba .LC1 02be __PRETTY_FUNCTION__.13637 02d2 __assert_fail 02ec .LC9 02f8 strchr 037c __libc_tsd_CTYPE_B 043e strtol 0442 __libc_argc 0464 getenv 05d2 .LC12 062a strlen 0634 _itoa_word 0702 fnmatch 070e malloc 071e mempcpy 0746 .LC15 0752 __fxprintf 099c __libc_argv 09ba .LC10 0a22 stpcpy 0a7a __strdup 0a9e strspn 0ab2 strcspn 0b50 __getpid 0b78 pthread_setcancelstate 0d3a __setenv 0d82 _libc_intl_domainname 0d86 .LC14 0d94 __dcgettext 0dec .LC13 0e9a .LC16"
	strings:
		$1 = { 2D E9 F0 4F A3 B0 1D 46 2C 9C 08 90 09 91 26 68 0A 92 77 1C 07 97 DF 5D 27 2F 00 F0 A4 80 3B D9 28 2F 0F D0 5B 2F 3B D1 2D 9D 02 36 00 94 26 60 01 24 01 95 02 94 FF F7 D7 FE 06 46 30 46 23 B0 BD E8 F0 8F B0 1C 1B 5C 28 2B 00 F0 CB 80 2D 9F 17 F0 04 06 18 BF 04 26 F0 D1 20 60 DD F8 B8 90 DD F8 C4 C0 2B 5C BC F1 00 0F 18 BF 4F F0 00 09 16 96 15 96 00 2B 00 F0 D4 85 4F F0 01 08 37 46 30 46 A3 F1 22 02 07 2A 00 F2 85 80 DF E8 02 F0 97 83 83 83 83 A3 9E 7E 00 2F 64 D0 22 2F 62 D0 07 9F 00 22 10 92 0F 92 27 60 EB 5D 12 92 B3 F1 7B 07 11 92 78 42 78 41 0B 90 00 28 00 F0 0F 81 B7 1C 27 60 EB 5D 23 2B 11 BF 0C 92 F3 1C 01 27 23 60 02 BF 0C 97 1F 46 EB 5C A8 4A 1D EE 70 9F 19 B2 7A 44 12 68 59 F8 02 20 32 F8 11 A0 0A F4 80 6A 1F FA 8A FA BA F1 00 0F 40 F0 8F 80 5F 2B 00 F0 8C 80 A3 F1 30 02 09 2A 00 F2 EF 80 10 AF 50 46 0D F1 3C 08 A2 46 B9 46 0B 9C 0D E0 00 2C 00 F0 22 84 DA F8 00 70 01 37 CA F8 00 70 EB 5D A3 F1 30 02 09 2A 00 F2 23 84 41 46 4A 46 FF F7 4F F8 00 28 EB D1 4F F0 00 08 01 25 C3 46 58 46 2E 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 30 46 23 B0 BD E8 F0 8F 26 60 DD F8 20 C0 24 23 09 99 0A 9A DC F8 00 00 FF F7 34 F8 08 9C D0 F1 01 06 20 60 38 BF 00 26 30 46 23 B0 BD E8 F0 8F 1F B9 B8 F1 01 08 00 F0 ED 84 15 A9 16 AA FF F7 21 F8 00 28 00 F0 C7 80 23 68 01 33 23 60 EB 5C 00 2B 7F F4 68 AF 82 46 50 46 05 26 ?? ?? ?? ?? 3E E7 00 2F 00 F0 89 80 02 3F 18 BF 01 27 E4 E7 00 2F E2 D1 08 F1 01 08 DF E7 00 2F 7F D0 01 2F 14 BF 02 27 00 27 D8 E7 03 36 32 46 AB 5D 00 2B 3F F4 2F AF 31 46 00 27 37 B9 29 2B 00 F0 0C 81 28 2B 07 D1 01 37 05 E0 28 2B FB D0 29 2B 08 BF 07 F1 FF 37 01 32 11 46 AB 5C 00 2B EC D1 18 E7 4F F0 00 0B DF F8 5C A1 0D F1 3C 08 10 AF 58 46 41 46 3A 46 FE F7 D6 FF 00 28 86 D0 22 68 53 46 7B 44 1B 68 01 32 59 F8 03 10 22 60 AB 5C 31 F8 13 10 01 F0 08 01 89 B2 00 29 E9 D1 5F 2B E7 D0 83 46 17 46 8A 46 0B 9A 00 2A 66 D1 0B 98 80 46 0D 90 01 3F 27 60 07 9F EB 5D 7B 2B 53 D0 BB F1 00 0F 00 F0 5F 83 9B F8 00 30 A3 F1 30 02 09 2A 40 F2 D4 80 BA F1 00 0F 00 F0 E5 80 24 2B 00 F0 55 84 B3 F1 2A 01 4A 42 4A 41 B3 F1 40 00 43 42 43 41 53 EA 02 05 40 F0 C4 82 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 DF 52 ?? ?? ?? ?? 02 27 5D E7 01 27 5B E7 23 2B 00 F0 94 85 0B 99 07 9F 0C 91 F6 E6 ?? ?2 0? 0? 19 46 ?? ?2 0? 0? 06 93 ?? ?? ?? ?? 06 9B 00 28 00 F0 43 83 50 46 0F A9 10 AA FE F7 69 FF 83 46 00 28 3F F4 18 AF 27 68 4F F0 01 0A 57 44 27 60 9F E7 23 68 EB 5C 7D 2B 18 BF 05 25 7F F4 0F AF A3 E7 01 26 82 E6 EB 5D 2D 2B 00 F0 92 83 00 F2 6A 82 25 2B 00 F0 80 83 2B 2B 00 F0 8A 83 23 2B 40 F0 8D 83 7A 1C A9 18 A8 5C 23 28 00 F0 64 84 00 27 0D 93 0B 97 22 60 0B 78 00 2B 00 F0 05 85 4F F0 00 08 C1 46 47 46 40 46 1C E0 ?? ?? ?? ?? ?? ?? ?? ?? 22 2B 26 D0 27 2B 05 D1 00 2F 3F D0 01 2F 0C BF 00 27 02 27 23 68 11 A9 12 AA EB 5C FE F7 1E FF 00 28 2E D0 22 68 01 32 22 60 AB 5C 00 2B 00 F0 FB 82 5C 2B 17 D0 E3 D9 7B 2B 0F D0 7D 2B E9 D1 00 2F E7 D1 B9 F1 00 0F 00 F0 BC 84 09 F1 FF 39 E0 E7 CF B1 02 3F 18 BF 01 27 DB E7 00 2F D9 D1 09 F1 01 09 D6 E7 00 2F D4 D1 01 32 22 60 AA 5C 00 2A 00 F0 EB 82 11 A9 12 AA FE F7 EF FE 00 28 C8 D1 80 46 01 25 A0 E6 02 27 C3 E7 01 27 C1 E7 29 44 4B 78 29 2B 7F F4 18 AE 26 60 2B 46 2D 9E 08 98 00 94 01 96 09 99 0A 9A 02 97 FF F7 DA FC 06 46 01 E6 58 46 00 21 0A 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 98 42 C0 F2 A5 82 2D 98 10 F0 20 0A 08 BF 54 46 09 D0 03 25 75 E6 58 46 ?? ?? ?? ?? 04 46 4F F0 00 0A 00 2C EF D0 0D 9D 00 2D 00 F0 95 81 A5 F1 23 06 2F 2E 00 F2 A7 80 DF E8 06 F0 21 A5 21 A5 A5 A5 A5 A5 18 A5 69 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 69 A5 69 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 A5 21 A5 A5 A5 A5 A5 21 00 2C 00 F0 4C 81 23 78 1B B9 0B 9F 00 2F 40 F0 46 81 00 22 15 92 14 92 13 92 B8 F1 00 0F 00 F0 45 83 98 F8 00 30 00 2B 00 F0 40 83 91 46 32 46 47 46 4E 46 91 46 1A E0 24 2B 00 F0 0D 82 27 2B 00 F0 03 82 22 2B 00 F0 E7 81 13 98 3B 78 3D 46 14 A9 15 AA FE F7 68 FE 13 90 00 28 00 F0 F3 81 6F 1C 00 F0 22 83 6B 78 00 2B 00 F0 1E 83 2A 2B 08 D0 E1 D9 5C 2B 00 F0 D8 81 7E 2B 00 F0 B0 81 3F 2B E2 D1 13 98 00 2E E0 D0 14 A9 15 AA 5C 23 FE F7 4A FE 13 90 00 28 00 F0 D5 81 3B 78 3D 46 D6 E7 00 2C B5 D0 23 78 13 B9 0B 9D 00 2D B0 D1 2F 2E 00 F2 FC 80 DF E8 16 F0 9F 00 FA 00 9F 00 FA 00 FA 00 FA 00 FA 00 FA 00 27 03 FA 00 88 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 78 00 FA 00 40 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 FA 00 9F 00 FA 00 FA 00 FA 00 FA 00 FA 00 9F 00 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 2E 62 ?? ?? ?? ?? 00 2C 00 F0 A1 80 23 78 00 2B 00 F0 9B 80 58 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 0C 9D 00 2D 00 F0 D5 80 DD F8 20 C0 00 25 8D F8 84 50 DC F8 00 60 00 2C 00 F0 27 84 20 46 ?? ?? ?? ?? 2B 46 21 A9 0A 22 ?? ?? ?? ?? 09 99 0A 9A 03 46 30 46 FF F7 7C FA 08 9D 28 60 BA F1 00 0F 04 D0 20 46 ?? ?? ?? ?? 08 9E 30 68 D0 F1 01 06 38 BF 00 26 EC E4 00 2C 00 F0 58 83 25 78 00 2D C8 D1 0B 9E 00 2E 40 F0 51 83 BA F1 00 0F 40 F0 8F 83 55 46 65 E5 14 B1 23 78 00 2B BA D1 BA F1 00 0F 02 D0 20 46 ?? ?? ?? ?? 0B 9E 86 F0 01 03 00 2C 0C BF 00 24 03 F0 01 04 00 2C 00 F0 99 82 00 25 4E E5 00 2C 18 BF B8 F1 00 0F 14 BF 4F F0 00 09 4F F0 01 09 6F D0 98 F8 00 30 00 2B 99 D0 20 46 ?? ?? ?? ?? 0D 9E 25 2E 04 EB 00 05 00 F0 99 80 40 F2 62 83 0D 9F 4C 2F 5B D0 52 2F 89 D1 A5 42 28 BF 26 46 03 D2 84 E7 01 36 B5 42 81 D3 40 46 31 46 00 22 ?? ?? ?? ?? 01 28 F5 D0 36 1B 70 1C ?? ?? ?? ?? 05 46 00 28 00 F0 FB 83 32 46 21 46 ?? ?? ?? ?? 00 23 03 70 BA F1 00 0F 40 F0 91 83 2C 46 4F F0 01 0A 64 E7 0B 9D 6D B1 98 F8 00 30 00 2B 00 F0 1F 83 43 46 ?? ?2 0? 0? 00 20 ?? ?2 0? 0? 5A 46 ?? ?? ?? ?? BA F1 00 0F 90 D0 20 46 00 25 ?? ?? ?? ?? F3 E4 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 7B 72 ?? ?? ?? ?? 2F 78 2E 46 40 46 05 F8 01 99 21 46 00 22 ?? ?? ?? ?? 01 28 40 F0 9E 83 6F 70 A5 42 F0 D2 58 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 0C 9F 00 2F 7F F4 2E AF 00 2C 00 F0 AA 82 2E 9F DD F8 C4 C0 D7 F1 01 03 38 BF 00 23 BC F1 00 0F 18 BF 43 F0 01 03 00 2B 00 F0 4E 81 08 9D 23 46 09 99 0A 9A 28 68 FF F7 A9 F9 28 60 BA F1 00 0F 3F F4 32 AF 20 46 ?? ?? ?? ?? 28 68 2C E7 40 46 29 46 00 22 ?? ?? ?? ?? 01 28 40 F0 0C 83 01 3D A5 42 F4 D2 C6 E7 3D 2B 00 F0 23 81 40 F2 C9 80 3F 2B 00 F0 1E 81 7D 2B 40 F0 21 81 DD F8 1C C0 00 27 B8 46 0B 97 0D 97 15 F8 0C 30 1B E5 0C 9E 00 2E 00 F0 CB 80 ?? ?2 0? 0? 00 20 ?? ?2 0? 0? 8D F8 6C 00 1B A9 0A 22 1B 68 83 42 C8 BF 03 F1 FF 30 00 23 ?? ?? ?? ?? DD F8 20 C0 09 99 0A 9A 03 46 DC F8 00 00 FF F7 61 F9 08 9C 20 60 58 46 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 26 68 D6 F1 01 06 38 BF 00 26 FF F7 D2 BB 00 2E 7F F4 32 AE 14 9B 00 2B 7F F4 2E AE 1C A8 01 96 00 90 14 A9 13 A8 15 AA 3B 46 1C 96 FF F7 63 F9 00 28 3D D0 05 46 BA F1 00 0F 40 F0 A9 81 13 98 ?? ?? ?? ?? 3E E4 02 2E 00 F0 81 80 00 2E 7F F4 13 AE 02 26 3D 46 1A E6 13 98 14 A9 15 AA 7D 1C FE F7 79 FC 13 90 7B 78 00 2B 00 F0 7A 82 00 28 7F F4 05 AE 01 25 25 E4 01 2E 68 D0 00 2E 7F F4 FB AD 01 26 E6 E7 2D 99 00 22 1C A8 01 25 00 23 00 90 01 91 13 A8 02 92 14 A9 03 92 15 AA 04 93 3B 46 05 95 00 25 1C 95 FF F7 65 FB 00 28 C1 D1 1C 9B 1F 44 CE E7 0C 9D 00 2D 3F F4 0E AC ?? ?2 0? 0? 22 A9 ?? ?2 0? 0? 00 23 0A 22 01 F8 1C BD 00 68 0C 93 01 38 ?? ?? ?? ?? 04 46 80 E5 0B 9F 54 46 DD F8 1C C0 83 46 B8 46 4F F0 01 0A 0D 97 15 F8 0C 30 7A E4 54 46 83 46 4F F0 01 0A D6 E4 0B 99 00 29 40 F0 D6 80 8A 46 8B 46 0D 91 88 46 68 E4 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 53 F8 20 40 5E E5 80 46 17 46 5D E4 3A 2B 5B D1 07 F1 01 09 ?? ?2 0? 0? ?? ?2 0? 0? 15 F8 09 10 ?? ?? ?? ?? 00 28 40 F0 C8 81 80 46 05 25 FF F7 BB BB 00 26 80 E7 00 2A 00 F0 34 81 ?? ?2 0? 0? ?? ?2 0? 0? 1D 68 6B 68 1C 46 53 B1 2E 1D 00 24 18 46 ?? ?? ?? ?? 56 F8 04 3F 01 30 04 44 00 2B F6 D1 20 46 ?? ?? ?? ?? 04 46 00 28 3F F4 74 AF 00 23 03 70 69 68 89 B1 05 F1 08 06 ?? ?? ?? ?? 20 25 56 F8 04 3B 4B B1 05 70 01 30 56 F8 04 1C ?? ?? ?? ?? 56 F8 04 3B 00 2B F5 D1 4F F0 01 0A 14 E5 7A 1C A9 18 A8 5C 25 28 7F F4 86 AC BA 1C 00 27 A9 18 0B 97 52 27 0D 97 81 E4 7A 1C 0D 93 00 27 A9 18 0B 97 7B E4 05 25 4F F0 00 08 FF F7 6B BB 20 46 ?? ?? ?? ?? 06 46 BA F1 00 0F 55 D1 00 2E 00 F0 65 81 00 27 DD F8 20 80 DD F8 28 B0 34 46 B9 46 20 46 30 99 ?? ?? ?? ?? 25 18 1F B9 23 5C 00 2B 00 F0 B0 80 2F 99 28 46 ?? ?? ?? ?? 30 99 2F 18 82 46 38 46 ?? ?? ?? ?? 39 5C 3C 18 0F 46 31 B1 2F 98 ?? ?? ?? ?? 07 46 08 B1 01 34 01 27 05 F8 0A 90 5A 46 09 99 2B 46 D8 F8 00 00 FF F7 29 F8 C8 F8 00 00 B0 B1 1F BB 23 78 00 2B 00 F0 8A 80 A6 42 CD D0 01 46 2E 98 FE F7 39 FB 01 28 00 F0 96 80 DD F8 24 C0 CB F8 00 90 CC F8 00 90 C8 F8 00 90 BD E7 2B 78 00 2B E5 D0 01 46 30 46 88 46 ?? ?? ?? ?? C3 46 E5 E6 20 46 ?? ?? ?? ?? A5 E7 01 27 DD E7 80 46 05 25 83 46 FF F7 03 BB 22 AC 00 25 04 F8 1C 5D ?? ?? ?? ?? 21 46 2B 46 0A 22 ?? ?? ?? ?? 04 46 83 E4 4E 46 40 46 ?? ?? ?? ?? DD F8 4C 80 FB E4 82 46 00 28 3F F4 62 AA ?? ?2 0? 0? CD F8 70 80 ?? ?2 0? 0? 00 2B 00 F0 98 81 1C A9 01 20 ?? ?? ?? ?? 2D 9A 2F 9B 50 46 30 9C 8D E8 04 02 08 99 02 93 09 9A 03 94 0A 9B FE F7 F2 FB 41 46 06 46 1C 98 ?? ?? ?? ?? 50 46 ?? ?? ?? ?? FF F7 3E BA 00 2C 3F F4 C8 AD 23 78 1B B9 0B 9F 00 2F 7F F4 C2 AD BA F1 00 0F 02 D0 20 46 ?? ?? ?? ?? B8 F1 00 0F 00 F0 18 81 40 46 ?? ?? ?? ?? 04 46 00 28 3F F4 85 AE 58 46 4F F0 01 0A ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 0C 9E 00 2E 7F F4 04 AD D7 E5 30 46 00 26 ?? ?? ?? ?? FF F7 11 BA 20 46 ?? ?? ?? ?? 52 E6 9A 46 FF F7 C6 BA BA 1C 00 27 A9 18 0B 97 4C 27 0D 97 FF F7 97 BB 05 46 4F F0 00 08 30 46 C3 46 ?? ?? ?? ?? FF F7 82 BA 00 2B 3F F4 33 AB 31 9D 00 2D 3F F4 C5 AE ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 02 2B 4D D0 02 2B 42 DD ?? ?2 0? 0? DD F8 20 C0 ?? ?2 0? 0? 09 99 0A 9A 33 68 DC F8 00 00 5B 68 FE F7 5B FF 00 28 3F F4 39 AE 01 46 2E 98 FE F7 72 FA 00 28 7F F4 32 AE 33 68 DA 68 00 2A 00 F0 DE 80 02 24 10 25 22 46 53 F8 22 00 ?? ?? ?? ?? 00 28 3F F4 23 AE 01 46 2E 98 FE F7 5C FA 00 28 7F F4 1C AE 33 68 01 34 22 46 59 59 04 35 00 29 EA D1 0A 9C 00 23 09 9D DD F8 20 C0 23 60 2B 60 CC F8 00 30 33 68 53 F8 22 40 FF F7 BD BB 58 46 00 26 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? FF F7 9D B9 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 5C 68 FF F7 AC BB 26 46 FF F7 92 B9 BA F1 00 0F 10 D1 B8 F1 00 0F 28 D0 40 46 ?? ?? ?? ?? 04 46 00 28 3F F4 E6 AD 01 22 58 46 21 46 92 46 ?? ?? ?? ?? 31 E5 20 46 ?? ?? ?? ?? EA E7 DD F8 1C C0 80 46 15 F8 0C 30 FF F7 90 BA B0 46 01 25 B3 46 FF F7 F7 B9 BA 1C C4 F8 00 90 15 F8 09 70 A9 18 0D 97 01 27 0B 97 FF F7 F8 BA 44 46 DB E7 17 46 98 46 FF F7 76 BA ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?? ?? ?? 03 46 D4 E4 20 46 ?? ?? ?? ?? FF F7 D4 B9 23 2E 7F F4 2A AC A5 42 FF F4 27 AC 4B 46 26 46 04 E0 B5 42 06 F8 01 9C FF F4 1F AC 96 F8 00 90 37 46 40 46 06 F8 01 3B 21 46 00 22 06 93 ?? ?? ?? ?? 06 9B 01 28 EC D0 87 F8 00 90 BA F1 00 0F 7F D1 3C 46 09 E4 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 8D 62 ?? ?? ?? ?? 0B 9C A0 46 A3 46 0D 94 98 E5 58 46 ?? ?? ?? ?? 0C 9D 0D BB 2E 46 FF F7 0B B9 2D 1B 68 1C ?? ?? ?? ?? 06 46 00 28 6D D0 2A 46 21 46 ?? ?? ?? ?? 00 23 03 70 BA F1 00 0F 6A D1 34 46 4F F0 01 0A FF F7 D8 BB 20 46 4F F0 01 0A ?? ?? ?? ?? 2C 46 FF F7 D0 BB 02 22 37 E7 DD F8 20 C0 4F F0 01 0A 00 23 8D F8 84 30 DC F8 00 60 00 20 21 A9 03 46 0A 22 ?? ?? ?? ?? 09 99 0A 9A 03 46 30 46 FE F7 57 FE 08 9C 20 60 BA F1 00 0F 3F F4 DF AB ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 8D 72 ?? ?? ?? ?? 2D 9E 30 98 2F 9F 00 96 03 90 50 46 08 99 CD F8 04 90 09 9A 02 97 0A 9B FE F7 5D FA 06 46 6D E6 37 70 BA F1 00 0F 0E D1 34 46 FF F7 8C BB 38 46 ?? ?? ?? ?? 05 46 20 46 00 2D AD D1 01 25 ?? ?? ?? ?? FF F7 27 B9 30 46 ?? ?? ?? ?? 05 46 20 46 00 2D A1 D1 F2 E7 BA F1 00 0F 3F F4 F3 AC 20 46 EC E7 20 46 4F F0 01 0A ?? ?? ?? ?? 34 46 FF F7 6A BB }
	condition:
		$1
}

rule file_144_14_0 {
	meta:
		name = "wordfree"
		size = 48
		refs = "0016 free"
	strings:
		$1 = { 38 B5 05 46 98 B1 43 68 8B B1 84 68 53 F8 24 00 03 EB 84 04 30 B1 ?? ?? ?? ?? 54 F8 04 0F 00 28 F9 D1 6B 68 18 46 ?? ?? ?? ?? 00 23 6B 60 38 BD }
	condition:
		$1
}

rule file_144_15_0 {
	meta:
		name = "wordexp"
		size = 1648
		refs = "0040 calloc 0050 .LC5 0058 getenv 011c free 01be strchr 024a glob 02ac globfree 0362 .LC19 0402 wordfree 0486 __strdup 0578 .LC17 057c .LC1 0580 __PRETTY_FUNCTION__.13342 0594 __assert_fail 05d0 .LC20 0648 .LC18"
	strings:
		$1 = { 2D E9 F0 4F 90 46 0E 46 04 46 07 C9 A1 B0 11 AD 18 F0 08 0F 4F F0 00 03 07 95 0E 93 0D 93 0B 91 0F 93 85 E8 07 00 40 F0 E7 82 18 F0 02 05 0A 95 0E D1 18 F0 01 0F 35 60 40 F0 92 82 01 20 04 21 ?? ?? ?? ?? 70 60 00 28 00 F0 E1 81 0A 9D B5 60 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 07 46 00 28 00 F0 CF 82 00 78 10 AD BC 46 08 95 A9 46 F8 B1 A0 F1 09 03 20 28 18 BF 01 2B 15 D8 4D 45 40 F2 9A 82 9D F8 40 30 83 42 00 F0 95 82 0D F1 41 03 03 E0 19 78 01 33 81 42 02 D0 AB 42 1A 46 F8 D1 AA 42 04 BF 10 70 01 35 1C F8 01 0F 00 28 DF D1 00 23 2B 70 94 F8 00 A0 00 25 AC 46 0C 95 55 46 BA F1 00 0F 00 F0 79 82 3F 2D 5E D0 3A D8 24 2D 00 F0 AC 81 40 F2 FA 80 27 2D 40 F0 19 82 0C F1 01 03 0C 93 E3 5C 00 2B 00 F0 23 81 27 2B 00 F0 32 82 0F 98 09 E0 0C 9B 01 33 0C 93 E3 5C 00 2B 00 F0 18 81 27 2B 00 F0 26 82 0D A9 0E AA FE F7 B9 F8 0F 90 00 28 EE D1 4F F0 01 0A ?? ?? ?? ?? BA F1 01 0F 0A D0 0A 9C 00 2C 00 F0 74 82 0B 9D 07 9C 12 95 94 E8 07 00 86 E8 07 00 50 46 21 B0 BD E8 F0 8F 5C 2D 00 F0 3D 81 40 F2 07 81 60 2D 00 F0 1D 81 7E 2D 40 F0 04 81 33 68 0C AA 0F A8 00 92 0D A9 0E AA 01 93 23 46 FE F7 5B FD 82 46 00 28 40 F0 25 81 0C 9B 01 33 0C 93 E5 5C 00 2D 00 F0 1B 82 3F 2D 9C 46 A0 D1 0C 9D 00 22 14 92 15 92 14 F8 05 90 16 92 B9 F1 00 0F 00 F0 4A 82 4F F0 00 0B 14 AA 5B 46 09 92 2A 46 BB 46 4D 46 4F F0 01 0A A1 46 1F 46 14 46 58 46 29 46 ?? ?? ?? ?? 28 BB 27 2D 00 F0 2B 81 22 2D 00 F0 07 81 01 2F 00 F0 49 82 24 2D 00 F0 A0 81 5C 2D 40 F0 03 81 00 2F 00 F0 88 81 0C AA 0F A8 00 92 0D A9 0E AA 4B 46 FE F7 94 F8 82 46 BA F1 00 0F 40 F0 4B 81 0C 9C 01 34 0C 94 19 F8 04 50 00 2D D4 D1 25 46 5F 46 4C 46 09 98 6A 1E 0F 99 00 25 0C 92 FD F7 FC FF 0E 95 0D 95 0F 95 82 46 00 28 40 F0 33 81 14 9B 00 2B 00 F0 BA 81 4F F0 01 0B 15 98 10 21 00 22 17 AB 50 F8 0A 00 ?? ?? ?? ?? 05 46 00 28 40 F0 8F 81 3B 78 00 2B 40 F0 FC 80 18 9B 1B 68 00 2B 00 F0 F0 81 0F 98 0D A9 0E AA FE F7 B7 FC 17 9B 01 2B 0F 90 17 D9 B0 B1 01 25 01 E0 0F 98 90 B1 0D A9 0E AA 20 23 FD F7 FB FF 0F 90 38 B1 18 9B 0D A9 0E AA 53 F8 25 30 FE F7 A0 FC 0F 90 17 9B 01 35 9D 42 EA D3 17 A8 ?? ?? ?? ?? 0F 9B 00 2B 00 F0 EE 80 14 9B 0A F1 04 0A 0B F1 01 02 9B 45 80 F0 73 81 93 46 B8 E7 22 2D 48 D1 0C F1 01 02 0C 92 A3 5C 5B B3 08 F0 04 0B B9 46 0C AD 5F 46 A3 46 14 46 24 2B 00 F0 F1 80 24 D9 5C 2B 00 F0 E0 80 60 2B 40 F0 D3 80 00 2F 40 F0 9C 81 00 95 0F A8 CD F8 04 80 0D A9 02 97 0E AA 03 97 5B 46 04 97 01 34 0C 94 FE F7 EF FA 00 28 40 F0 D3 80 0C 9A 54 1C 0C 94 1B F8 04 30 00 2B DA D1 0F 98 4F F0 05 0A F0 E6 22 2B 40 F0 B1 80 0D 99 4F 46 5C 46 00 29 7F F4 15 AF 30 46 FD F7 65 FF 00 28 3F F4 0F AF 82 46 EF E6 5B 2D 3F F4 14 AF ?? ?2 0? 0? 29 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 00 F0 2D 81 0F 99 21 B1 30 46 FD F7 4E FF 82 46 E8 B9 00 22 0E 92 0D 92 0F 92 F3 E6 18 F0 04 0F 40 F0 49 81 08 9D 0C AB CD F8 04 80 0F A8 00 93 0D A9 04 95 0E AA 02 96 23 46 03 97 0C F1 01 05 0C 95 FE F7 A2 FA 82 46 00 28 3F F4 DB AE 0F 98 AB E6 0C AB 0F A8 00 93 0D A9 0E AA 23 46 FD F7 8C FF 82 46 00 28 3F F4 CD AE F0 E7 00 2F 00 F0 9A 80 02 2F 1F D0 2B 46 0F 98 0D A9 0E AA FD F7 48 FF 0F 90 00 28 7F F4 03 AF 09 98 5F 46 4C 46 ?? ?? ?? ?? BA F1 00 0F 3F F4 B4 AE 0F 98 ?? ?? ?? ?? 4F F0 01 0A 50 46 21 B0 BD E8 F0 8F 00 2F 73 D0 01 2F DF D1 07 46 EB E6 08 9A 00 23 CD F8 04 80 0C AD 05 93 0F A8 04 92 0D A9 02 96 0E AA 03 97 23 46 00 95 FE F7 2C FE 82 46 00 28 3F F4 91 AE B4 E7 0F 98 20 B1 ?? ?? ?? ?? 0E 95 0D 95 0F 95 17 9B 00 25 53 B9 95 E0 01 46 30 46 FD F7 D4 FE 58 B9 17 9B 01 35 9D 42 80 F0 8C 80 18 9B 53 F8 25 00 ?? ?? ?? ?? 00 28 EE D1 17 A8 ?? ?? ?? ?? 4F F0 01 0A 09 98 ?? ?? ?? ?? 0F 98 3C E6 0F 98 0D A9 0E AA FD F7 EC FE 0F 90 00 28 7F F4 38 AF 30 E6 00 95 0F A8 0D A9 0E AA 5B 46 FD F7 2E FF 00 28 3F F4 2D AF 82 46 0F 98 25 E6 08 9C 0F A8 00 95 0D A9 CD F8 04 80 0E AA 04 94 5B 46 01 24 02 96 CD F8 0C 90 05 94 FE F7 DA FD 00 28 3F F4 17 AF E8 E7 0C AB 0F A8 00 93 0D A9 0E AA 4B 46 FD F7 F2 FE 82 46 76 E6 01 27 79 E6 2A 2D 3F F4 3A AE 24 E7 02 27 73 E6 09 9D 0C AB 00 93 BB 1E 5C 42 CD F8 04 80 02 95 5C 41 08 9D 0F A8 0D A9 CD F8 0C B0 0E AA 4B 46 04 95 05 94 FE F7 B0 FD 82 46 00 28 3F F4 5B AE 09 98 ?? ?? ?? ?? 0F 98 E2 E5 0D 99 00 29 7F F4 0C AE F5 E6 B0 68 04 21 01 30 ?? ?? ?? ?? 70 60 00 28 7F F4 6F AD 4C E7 01 28 8D D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 C6 72 ?? ?? ?? ?? 17 A8 0A F1 04 0A ?? ?? ?? ?? 14 9B 0B F1 01 02 9B 45 FF F4 8D AE 09 98 ?? ?? ?? ?? DF E5 4A 46 72 E5 0F 99 00 29 2E D0 30 46 FD F7 2B FE 82 46 50 46 21 B0 BD E8 F0 8F ?? ?2 0? 0? 29 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 2F D1 2B 46 0F 98 0D A9 0E AA FD F7 4B FE 0F 90 00 28 7F F4 C0 AD 0B E7 30 46 0B 93 ?? ?? ?? ?? 13 E5 20 AD 4F F4 12 63 C0 F2 0A 03 45 F8 40 3D 2F 46 08 95 4E E5 30 46 ?? ?? ?? ?? 87 E5 8A 46 50 46 21 B0 BD E8 F0 8F 4F F0 04 0A 0F 98 ?? ?? ?? ?? 78 E5 14 AB 09 93 ED E5 0F 98 4F F0 04 0A 6C E5 4F F0 02 0A F1 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 93 12 ?? ?? ?? ?? 5C 2D 7F F4 BD AE BB E5 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__wcrtomb_chk"
		size = 40
		refs = "001e __chk_fail 0024 _nl_current_LC_CTYPE 001a __wcrtomb"
	strings:
		$1 = { 38 B5 1D EE 70 5F 07 4C 7C 44 24 68 2C 59 24 68 A4 6D 9C 42 03 D8 BD E8 38 40 ?? ?? ?? ?? ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "critical_factorization"
		size = 186
	strings:
		$1 = { 4F F0 01 0C 2D E9 F0 03 64 46 00 25 4F F0 FF 36 63 19 87 19 8B 42 0D D2 3F 5D 10 F8 03 80 B8 45 2F D2 1D 46 01 24 C6 EB 03 0C 63 19 8B 42 00 EB 06 07 F1 D3 4F F0 01 09 00 25 4C 46 4F F0 FF 37 C2 F8 00 C0 63 19 00 EB 07 0C 99 42 0E D9 1C F8 04 C0 10 F8 03 80 E0 45 1A D9 1D 46 01 24 C7 EB 03 09 63 19 99 42 00 EB 07 0C F0 D8 01 37 01 36 B7 42 26 BF C2 F8 00 90 38 46 30 46 BD E8 F0 03 70 47 0C D0 4F F0 01 0C 2E 46 64 46 65 44 BF E7 0C D0 4F F0 01 09 2F 46 4C 46 4D 44 D2 E7 64 45 04 F1 01 04 B4 D1 1D 46 01 24 B1 E7 4C 45 04 F1 01 04 C7 D1 1D 46 01 24 C4 E7 }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 548
		refs = "004e memcmp 0096 memchr"
	strings:
		$1 = { 2D E9 F0 4F AD F2 24 4D 91 46 05 46 8B 46 10 46 19 46 07 AA 1C 46 FF F7 95 FF 07 AB 0D F2 1C 42 01 90 43 F8 04 4F 93 42 FB D1 66 1E 00 23 08 A8 3C B1 19 F8 03 20 F1 1A 01 33 A3 42 40 F8 22 10 F7 D1 07 9B 48 46 01 9A 19 46 49 44 00 93 ?? ?? ?? ?? 00 28 77 D1 01 9B 07 46 82 46 66 1E 01 3B 02 93 4B 44 04 93 00 9B 5A 46 A0 46 E3 1A 03 93 01 9B C3 F1 01 03 05 93 08 E0 27 B1 00 99 03 9A 99 42 88 BF 13 46 9A 44 00 27 22 46 0A EB 08 04 A8 18 00 21 A2 1A ?? ?? ?? ?? 00 28 4E D1 00 2C 4C D0 2B 19 08 A8 13 F8 01 3C 50 F8 23 30 00 2B E3 D1 01 9B 9F 42 28 BF 3B 46 B3 42 03 EB 0A 00 09 EB 03 01 05 EB 00 02 0E D2 28 5C 19 F8 03 C0 84 45 06 D0 2D E0 11 F8 01 CF 12 F8 01 0F 84 45 27 D1 01 33 B3 42 F6 D3 01 98 02 9B 87 42 53 44 05 EB 03 01 28 BF 03 46 14 D2 04 98 EB 5C 02 78 9A 42 40 F0 8A 80 02 46 02 9B 06 E0 12 F8 01 BD 11 F8 01 CD E3 45 05 D1 03 46 BB 42 03 F1 FF 30 F4 D1 3B 46 01 37 9F 42 79 D8 00 9B 03 9F 9A 44 AB E7 05 99 00 27 8A 44 9A 44 A6 E7 00 20 0D F2 24 4D BD E8 F0 8F 01 98 66 1E 0D F1 20 08 41 1E 02 91 49 44 C0 F1 01 02 8A 46 23 1A 92 44 04 92 5A 46 D3 46 A2 46 01 9C 83 42 38 BF 03 46 48 44 4F F0 00 09 01 33 03 91 05 93 00 90 07 93 09 EB 0A 07 A8 18 00 21 BA 1A ?? ?? ?? ?? 00 28 D5 D1 00 2F D3 D0 EB 19 13 F8 01 3C 58 F8 23 30 00 2B 33 D1 B4 42 09 EB 04 03 05 EB 03 01 10 D2 00 98 EB 5C 02 78 9A 42 2B D1 02 46 23 46 05 E0 12 F8 01 CF 11 F8 01 0F 84 45 23 D1 01 33 B3 42 F6 D3 02 98 02 9B 01 30 4B 44 05 EB 03 02 0E D0 03 98 EB 5C 01 78 99 42 0F D1 03 46 05 E0 13 F8 01 0D 12 F8 01 1D 88 42 07 D1 5B 45 F7 D1 05 EB 09 00 0D F2 24 4D BD E8 F0 8F 05 9B 99 44 3A 46 B6 E7 23 46 04 99 89 44 99 44 F8 E7 01 9B 82 E7 05 EB 0A 00 8C E7 }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "strstr"
		size = 666
		refs = "0048 strchr 00a8 memcmp 00d6 memchr"
	strings:
		$1 = { 2D E9 F0 4F 80 46 03 78 8B B0 0C 46 00 2B 00 F0 36 81 0A 78 00 2A 35 D0 84 46 4E 1C 01 25 02 E0 16 F8 01 2B 62 B1 93 42 14 BF 00 25 05 F0 01 05 1C F8 01 3F B3 46 00 2B F2 D1 9B F8 00 30 EB B9 05 BB 21 78 08 F1 01 00 ?? ?? ?? ?? C4 EB 0B 04 07 46 D8 B1 01 2C 0E D0 A0 44 C4 EB 0B 0B 40 45 94 BF C0 EB 08 05 01 25 1F 2C 11 D9 29 46 5A 46 23 46 FF F7 B3 FE 0B B0 BD E8 F0 8F 00 20 0B B0 BD E8 F0 8F 40 46 0B B0 BD E8 F0 8F 28 46 F2 E7 21 46 09 AA 58 46 FF F7 43 FE 09 9B 19 46 59 44 04 93 81 46 02 46 58 46 ?? ?? ?? ?? 00 28 5D D1 09 F1 FF 33 06 46 02 93 80 46 5B 44 2A 46 03 93 04 9B E3 1A 06 93 C9 F1 01 03 05 93 08 EB 04 05 B8 18 00 21 AA 1A ?? ?? ?? ?? 00 28 CE D1 00 2D CC D0 4E 45 2C BF 33 46 4B 46 9C 42 03 EB 08 00 0B EB 03 01 07 EB 00 02 0E D9 38 5C 1B F8 03 C0 84 45 06 D0 2D E0 11 F8 01 CF 12 F8 01 0F 84 45 27 D1 01 33 9C 42 F6 D8 02 9B B1 45 43 44 07 EB 03 01 40 F2 9E 80 03 98 FB 5C 02 78 9A 42 40 F0 98 80 02 46 02 9B 06 E0 12 F8 01 AD 11 F8 01 CD E2 45 05 D1 03 46 B3 42 03 F1 FF 30 F4 D1 33 46 01 36 B3 42 C0 F0 96 80 04 9B 06 9E 98 44 2A 46 B4 E7 05 9A 00 26 90 44 98 44 F8 E7 09 F1 01 08 07 EB 09 03 45 45 02 93 1B F8 09 60 73 D3 09 F1 FF 30 C9 EB 04 03 4B 45 38 BF 4B 46 03 90 58 44 C9 F1 01 02 01 33 07 93 09 93 03 46 13 44 04 90 CD F8 14 90 C3 44 06 92 99 46 02 98 03 E0 00 2B 3F F4 64 AF 50 46 03 78 00 F1 01 0A 9E 42 F6 D1 02 9B 44 45 C3 EB 0A 0A 0A F1 FF 3A 13 D9 41 78 00 F1 02 0C 9B F8 00 30 8B 42 04 BF 58 46 43 46 06 D0 52 E0 10 F8 01 2F 1C F8 01 1B 8A 42 4D D1 01 33 9C 42 F6 D8 03 98 03 9B 01 30 53 44 07 EB 03 01 0F D0 04 98 FA 5C 03 78 93 42 08 BF 04 9B 06 D0 0A E0 13 F8 01 0D 11 F8 01 2D 90 42 04 D1 4B 45 F7 D1 07 EB 0A 00 25 E7 00 2A 3F F4 26 AF 07 9B 53 44 03 EB 04 0A 78 19 C5 EB 0A 02 00 21 01 93 ?? ?? ?? ?? 01 9B 00 28 7F F4 17 AF BA F1 00 0F 3F F4 13 AF 05 98 55 46 03 44 07 EB 03 0A A8 E7 4B 46 74 E7 C5 F1 01 02 78 19 4A 44 00 21 ?? ?? ?? ?? 00 28 7F F4 01 AF 45 46 7F E7 8B 46 01 25 DA E6 07 EB 08 00 F5 E6 43 46 00 29 3F F4 F5 AE 06 9A 92 44 53 44 CC E7 }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "__libc_allocate_rtsig"
		size = 48
		refs = "0000 .LANCHOR0"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 1A 68 51 1C 0E D0 59 68 8A 42 08 DC 18 B1 51 1C 10 46 19 60 70 47 4A 1E 08 46 5A 60 70 47 4F F0 FF 30 70 47 10 46 70 47 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "_IO_ftell"
		size = 404
		refs = "0054 _IO_seekoff_unlocked 0122 __libc_do_syscall 0128 __lll_lock_wait_private 0182 _Unwind_Resume 0188 __libc_errno"
	strings:
		$1 = { 03 68 70 B5 06 46 18 04 82 B0 1C D4 B0 6C 1D EE 70 4F A4 F5 98 64 83 68 A3 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 76 D1 B3 6C 18 46 9C 60 43 68 01 33 43 60 01 22 00 23 00 92 30 46 01 93 00 22 00 23 ?? ?? ?? ?? 33 68 0D 46 04 46 D9 05 08 D5 B5 F1 FF 3F 08 BF B4 F1 FF 3F 02 D0 F2 6E 00 2A 3B DD 1A 04 17 D4 B0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 26 00 2E F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 32 DC B5 F1 FF 3F 08 BF B4 F1 FF 3F 08 D0 22 46 E3 17 AB 42 08 BF A2 42 20 46 1B D1 02 B0 70 BD 30 4B 1D EE 70 2F 4F F0 FF 30 7B 44 1B 68 D3 58 00 2B F3 D1 2C 4B 05 21 4F F0 FF 30 7B 44 1B 68 D1 50 02 B0 70 BD F1 6A 72 6A 8A 1A A4 1A 65 EB E2 75 BC E7 25 4B 1D EE 70 2F 4B 21 4F F0 FF 30 7B 44 1B 68 D1 50 D9 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? BF E7 ?? ?? ?? ?? 85 E7 33 68 04 46 1B 04 24 D4 B3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 15 00 2D F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__new_exitfn"
		size = 320
		refs = "0004 .LANCHOR0 0082 __new_exitfn_called 00de calloc 00f2 .LC0 00f6 .LC1 00fa __PRETTY_FUNCTION__.9142 010c __assert_fail 0118 __lll_lock_wait_private 013a __libc_do_syscall"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 80 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 56 E8 00 3F 00 2B 03 D1 46 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 71 D1 D8 F8 00 70 00 2F 5E D0 4F F0 00 0C 3D 46 60 46 6A 68 82 B1 53 1E 05 EB 03 11 89 68 91 B9 05 EB 02 12 08 32 3B B1 10 3A 52 F8 10 1C 5C 1E 51 B9 23 46 00 2B F7 D1 2B 68 AC 46 68 60 00 2B 2F D0 1D 46 E5 E7 13 46 20 2B 1F BF 05 EB 03 14 01 33 08 34 6B 60 21 D0 ?? ?2 0? 0? 01 23 ?? ?2 0? 0? 23 60 D1 E9 00 23 01 32 43 F1 00 03 C1 E9 00 23 00 22 33 68 BF F3 5F 8F 56 E8 00 1F 99 42 03 D1 46 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 2E DC 20 46 BD E8 F0 81 BC F1 00 0F 05 D0 01 23 0C F1 08 04 CC F8 04 30 D4 E7 01 20 4F F4 02 71 ?? ?? ?? ?? 84 46 04 46 00 28 D8 D0 07 60 C8 F8 00 00 EC E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 64 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 86 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? BF E7 }
	condition:
		$1
}

rule file_151_1_0 {
	meta:
		name = "__internal_atexit"
		size = 42
		refs = "000a __new_exitfn"
	strings:
		$1 = { 70 B5 04 46 18 46 0E 46 15 46 ?? ?? ?? ?? 03 46 40 B1 44 60 04 22 86 60 00 20 DD 60 BF F3 5F 8F 1A 60 70 BD 4F F0 FF 30 70 BD }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "putmsg"
		size = 24
		refs = "0014 __libc_errno"
		altNames = "__sigreturn _no_syscall fattach fdetach getmsg getpmsg lchmod putpmsg revoke setlogin sstk"
	strings:
		$1 = { 04 4B 1D EE 70 2F 26 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__wcscat_chk"
		size = 56
		refs = "0034 __chk_fail"
	strings:
		$1 = { 70 B5 01 3A 04 46 01 E0 32 46 1C 46 53 1C 11 D0 23 46 56 1E 53 F8 04 5B 00 2D F5 D1 04 3C 02 E0 53 1E 3A B1 1A 46 51 F8 04 3B 44 F8 04 3F 00 2B F6 D1 70 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__readlinkat_chk"
		size = 20
		refs = "0010 __chk_fail 000c readlinkat"
	strings:
		$1 = { 10 B5 02 9C A3 42 03 D8 BD E8 10 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_IO_wpadn"
		size = 128
		refs = "006c .LANCHOR0"
	strings:
		$1 = { 20 29 2D E9 F0 41 06 46 90 B0 14 46 2E D0 30 29 31 D0 6A 46 10 AB 43 F8 04 1D 93 42 FB D1 E8 46 00 25 0A E0 D6 F8 98 70 30 46 41 46 10 22 10 3C FF 69 B8 47 10 28 05 44 0F D1 0F 2C F2 DC 00 2C 07 DD D6 F8 98 30 41 46 22 46 30 46 DB 69 98 47 05 44 28 46 10 B0 BD E8 F0 81 B0 F1 FF 3F 14 BF 28 46 4F F0 FF 30 10 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? D4 E7 DF F8 04 80 D1 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "mkostemps"
		size = 36
		refs = "0020 __libc_errno 0006 __gen_tempname"
	strings:
		$1 = { 00 29 02 DB 00 23 ?? ?? ?? ?? 05 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "fgets_unlocked"
		size = 112
		refs = "0030 _IO_getline 006c __libc_errno"
	strings:
		$1 = { 00 29 70 B5 05 46 82 B0 14 46 2C DD 01 29 02 BF 00 23 00 46 2B 70 13 D0 16 68 20 46 4A 1E 01 21 26 F0 20 03 00 91 23 60 29 46 0A 23 06 F0 20 06 ?? ?? ?? ?? 30 B9 23 68 05 46 28 46 1E 43 26 60 02 B0 70 BD 23 68 9A 06 09 D5 08 4A 1D EE 70 1F 7A 44 12 68 8A 58 0B 2A 18 BF 00 25 ED D1 00 23 2B 54 23 68 E9 E7 00 20 EA E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "enlarge_userbuf.part.0"
		size = 338
		refs = "005c __wmemcpy 007c _IO_wsetb 00d2 wmemset 0134 .LC0 0138 .LC1 013c __PRETTY_FUNCTION__.13049 014e __assert_fail"
	strings:
		$1 = { 2D E9 F0 4F 14 46 C2 6B 1D 46 C6 6D 83 B0 12 F0 08 09 07 46 73 69 D6 F8 0C B0 05 D0 4F F0 01 09 48 46 03 B0 BD E8 F0 8F 04 F1 64 01 D0 F8 A0 20 D6 F8 18 A0 89 00 00 93 08 46 01 91 90 47 00 9B 80 46 00 28 EA D0 BA F1 00 0F 10 D0 FA 6D 51 46 D2 F8 1C E0 92 69 C2 EB 0E 02 92 10 ?? ?? ?? ?? D7 F8 A4 20 50 46 90 47 00 9B C6 F8 18 90 01 9A CB EB 03 0B 41 46 38 46 42 44 01 23 ?? ?? ?? ?? 0C 99 4F EA AB 0B 51 B3 F2 68 33 69 CA EB 02 07 71 69 32 68 CA EB 03 00 F3 69 CA EB 01 01 CA EB 02 0A 41 44 08 EB 0A 02 71 61 86 E8 0C 00 5A 46 4F EA EB 73 47 44 94 42 75 EB 03 01 40 44 C6 F8 08 80 F7 60 30 61 35 DB 08 EB 8B 00 CB EB 04 02 00 21 ?? ?? ?? ?? 48 46 03 B0 BD E8 F0 8F 33 68 71 68 B2 68 CA EB 03 00 F3 69 CA EB 01 01 CA EB 02 07 40 44 32 69 41 44 30 60 58 46 71 60 4F EA EB 71 73 61 84 42 75 EB 01 03 CA EB 02 0A 47 44 08 EB 0A 02 C6 F8 0C 80 B7 60 32 61 0A DB 08 EB 8B 00 CB EB 04 02 0C 99 ?? ?? ?? ?? 48 46 03 B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? E6 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "_IO_wstr_underflow"
		size = 60
	strings:
		$1 = { C2 6D 30 B4 13 69 51 68 8B 42 88 BF 53 60 04 68 88 BF 19 46 04 F4 40 65 B5 F5 40 6F 05 BF 24 F4 00 64 55 69 13 68 04 60 04 BF 15 61 13 60 99 42 94 BF 4F F0 FF 30 18 68 30 BC 70 47 }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "_IO_wstr_overflow"
		size = 278
		refs = "0098 __wmemcpy 00b4 wmemset 00c2 _IO_wsetb"
	strings:
		$1 = { B1 F1 FF 33 02 68 2D E9 F0 4F 5E 42 5E 41 0D 46 11 07 04 46 48 BF 86 F0 01 06 83 B0 48 BF 70 42 23 D4 02 F4 40 63 B3 F5 80 6F E3 6D 02 BF 42 F4 00 62 22 60 59 68 D3 F8 18 80 DF 69 0C BF 1A 68 1A 69 C8 EB 07 07 08 BF 19 60 D9 68 4F EA A7 07 08 BF 1A 61 B8 19 52 1A B0 EB A2 0F 4C D8 E3 6B 13 F0 08 09 04 D0 4F F0 FF 30 03 B0 BD E8 F0 8F 07 F1 32 03 4F EA 43 0B 5F 45 F4 D8 DB 00 01 93 01 98 D4 F8 A0 30 98 47 82 46 00 28 EB D0 B8 F1 00 0F 0A D0 41 46 3A 46 ?? ?? ?? ?? D4 F8 A4 30 40 46 98 47 E3 6D C3 F8 18 90 C7 EB 0B 02 0A EB 87 00 00 21 ?? ?? ?? ?? 01 9A 20 46 51 46 52 44 01 23 ?? ?? ?? ?? E3 6D 99 68 1A 68 58 68 C8 EB 01 07 C8 EB 02 04 19 69 DA 69 C8 EB 00 00 C8 EB 01 01 57 44 54 44 50 44 51 44 C3 F8 0C A0 9F 60 1C 60 58 60 19 61 5A 61 46 B1 1A 69 59 68 28 46 91 42 38 BF 5A 60 03 B0 BD E8 F0 8F 19 69 0A 1D 1A 61 0D 60 F2 E7 }
	condition:
		$1
}

rule file_159_3_0 {
	meta:
		name = "_IO_wstr_pbackfail"
		size = 20
		refs = "0010 _IO_wdefault_pbackfail"
	strings:
		$1 = { 03 68 1A 07 04 D5 4B 1C 02 D0 4F F0 FF 30 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "_IO_wstr_finish"
		size = 38
		refs = "0022 _IO_wdefault_finish"
	strings:
		$1 = { C3 6D 10 B5 04 46 98 69 30 B1 E2 6B 12 07 03 D4 D4 F8 A4 30 98 47 E3 6D 00 21 20 46 99 61 BD E8 10 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_5_0 {
	meta:
		name = "_IO_wstr_seekoff"
		size = 374
	strings:
		$1 = { 2D E9 F0 41 82 B0 06 46 14 46 09 9F 1D 46 00 2F 2E D1 03 68 5A 05 72 D5 1F 05 43 D5 C3 6D 58 68 19 69 9A 68 88 42 2C BF C2 EB 00 02 C2 EB 01 02 4F EA A2 08 08 99 01 29 7C D0 02 29 03 D1 14 EB 08 04 45 EB E8 75 00 2C 75 F1 00 02 C0 F2 8E 80 A0 45 04 DA 31 6A F2 69 8A 1A A2 42 7C DB DA 68 20 46 29 46 02 EB 84 04 1C 61 02 B0 BD E8 F0 81 C3 6D 9A 68 18 69 59 68 88 42 2C BF C2 EB 00 01 C2 EB 01 01 4F EA A1 08 F9 07 18 D4 4F F0 FF 3C 07 F0 02 07 62 46 60 46 11 46 00 2F CA D1 02 B0 BD E8 F0 81 C3 6D 01 27 9A 68 58 68 19 69 88 42 2C BF C2 EB 00 01 C2 EB 01 01 4F EA A1 08 08 99 01 29 30 D0 02 29 03 D1 14 EB 08 04 45 EB E8 75 00 2C 75 F1 00 02 49 DB A0 45 04 DA 31 6A F2 69 8A 1A A2 42 2E DB 99 68 07 F0 02 07 A4 46 2A 46 01 EB 84 00 01 EB 88 01 83 E8 03 00 CB E7 18 07 08 D5 F3 6D 18 68 9B 68 C0 1A 80 10 C1 17 02 B0 BD E8 F0 81 F3 6D 18 69 DB 68 C0 1A 80 10 C1 17 02 B0 BD E8 F0 81 19 68 8A 1A 92 10 A4 18 45 EB E2 75 CD E7 19 69 DA 68 8A 1A 92 10 A4 18 45 EB E2 75 80 E7 01 23 30 46 00 93 22 46 2B 46 FF F7 AD FE 58 B9 F3 6D C6 E7 00 23 30 46 00 93 22 46 2B 46 FF F7 A3 FE 08 B9 F3 6D 78 E7 4F F0 FF 30 4F F0 FF 31 93 E7 }
	condition:
		$1
}

rule file_159_6_0 {
	meta:
		name = "_IO_wstr_init_static"
		size = 88
		refs = "000c __wcslen 001c _IO_wsetb"
	strings:
		$1 = { F8 B5 05 46 0C 46 1E 46 B2 B9 08 46 ?? ?? ?? ?? 04 EB 80 07 21 46 28 46 3A 46 00 23 ?? ?? ?? ?? E9 6D CC 60 8C 60 0C 60 7E B1 0E 61 00 23 4F 61 4E 60 C5 F8 A0 30 F8 BD 01 EB 82 07 B9 42 22 BF CF 43 27 F0 03 07 7F 18 E4 E7 0C 61 00 23 4C 61 4F 60 C5 F8 A0 30 F8 BD }
	condition:
		$1
}

rule file_159_7_0 {
	meta:
		name = "_IO_wstr_count"
		size = 24
	strings:
		$1 = { C3 6D 18 69 5A 68 9B 68 90 42 2C BF C3 EB 00 00 C3 EB 02 00 80 10 70 47 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "_IO_ungetc"
		size = 254
		refs = "004c _IO_sputbackc 008c __lll_lock_wait_private 00a6 __libc_do_syscall 00fa _Unwind_Resume"
	strings:
		$1 = { 70 B5 05 46 01 30 0C 46 3E D0 0B 68 19 04 1B D4 A0 6C 1D EE 70 6F A6 F5 98 66 82 68 B2 42 10 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 3A BB A2 6C 10 46 96 60 42 68 01 32 42 60 E9 B2 20 46 ?? ?? ?? ?? 23 68 1A 04 05 46 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 04 DC 28 46 70 BD ?? ?? ?? ?? D4 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 28 46 70 BD 23 68 05 46 1B 04 20 D4 A3 6C 5A 68 01 3A 5A 60 DA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 08 DD B1 68 01 22 18 46 4F F0 F0 0C 00 23 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__dladdr1"
		size = 44
		refs = "0010 _dl_addr"
	strings:
		$1 = { 01 2B 10 B4 0C D0 02 2B 04 D1 00 23 5D F8 04 4B ?? ?? ?? ?? 00 22 5D F8 04 4B 13 46 ?? ?? ?? ?? 13 46 5D F8 04 4B 00 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__fxprintf"
		size = 170
		refs = "0024 strlen 0062 __vfwprintf 0078 _IO_vfprintf 007e stderr 008c .LC0 0090 .LC1 0094 __PRETTY_FUNCTION__.13686 00a6 __assert_fail"
	strings:
		$1 = { 0E B4 2D E9 B0 43 83 B0 00 AF 80 46 7D 6A 00 28 35 D0 D8 F8 6C 30 07 F1 28 02 7A 60 00 2B 29 DD 28 46 E9 46 ?? ?? ?? ?? 01 30 83 00 0A 33 23 F0 07 03 AD EB 03 0D 69 46 88 B1 2B 78 33 F0 7F 02 08 BF AD F1 04 04 05 D0 20 E0 15 F8 01 3F 13 F0 80 0F 1B D1 01 32 44 F8 04 3F 90 42 F5 D1 40 46 7A 68 ?? ?? ?? ?? CD 46 0C 37 BD 46 BD E8 B0 43 03 B0 70 47 40 46 29 46 ?? ?? ?? ?? F4 E7 ?? ?2 0? 0? ?? ?2 0? 0? D3 F8 00 80 C2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2E 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__vdprintf_chk"
		size = 140
		refs = "0008 _IO_wfile_jumps 0026 _IO_file_jumps 002a _IO_no_init 0036 _IO_file_init 003e _IO_file_attach 0068 _IO_vfprintf 0082 _IO_un_link"
	strings:
		$1 = { 2D E9 F0 43 DB B0 00 25 ?? ?2 0? 0? 06 46 ?? ?2 0? 0? 02 A8 00 94 89 46 90 46 4F F4 00 41 2A 46 1F 46 2B AB 14 95 ?? ?2 0? 0? ?? ?? ?? ?? 02 A8 ?? ?2 0? 0? 28 94 ?? ?? ?? ?? 02 A8 31 46 ?? ?? ?? ?? E8 B1 02 9B B9 F1 00 0F 41 46 3A 46 23 F4 80 53 02 A8 23 F0 0C 03 43 F0 44 03 02 93 C2 BF 11 9B 43 F0 04 03 11 93 ?? ?? ?? ?? 28 9B 00 21 9B 68 04 46 02 A8 98 47 20 46 5B B0 BD E8 F0 83 02 A8 ?? ?? ?? ?? 4F F0 FF 30 F6 E7 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__tcgetattr"
		size = 164
		refs = "0012 __libc_do_syscall 004c mempcpy 00a0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 8A B0 0B 46 01 AA 45 F2 01 41 4F F0 36 0C ?? ?? ?? ?? 10 F5 80 5F 04 46 36 D8 88 BB 03 9E 41 F2 0F 05 01 9F 03 F1 11 00 35 40 5D 63 9D 63 0D F1 15 01 02 9D 13 22 9D F8 14 80 9E 60 5D 60 04 9D 1F 60 83 F8 10 80 DD 60 ?? ?? ?? ?? 03 46 03 F8 01 4B 01 33 44 70 03 F8 01 4B 03 F8 01 4B 03 F8 01 4B 03 F8 01 4B 03 F8 01 4B 03 F8 01 4B 03 F8 01 4B 03 F8 01 4B 03 F8 01 4B 03 F8 01 4B 1C 70 20 46 0A B0 BD E8 F0 81 04 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 F1 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "ptrace"
		size = 112
		refs = "0020 __libc_do_syscall 0068 __libc_errno"
	strings:
		$1 = { 0F B4 4F F0 1A 0C 10 B5 82 B0 04 AB 05 99 53 F8 04 0B 44 1E 02 2C 01 93 5A 68 9B 68 98 BF 6B 46 ?? ?? ?? ?? 10 F5 80 5F 14 D8 02 2C 8C BF 00 24 01 24 00 28 B8 BF 00 24 3C B1 0B 4B 1D EE 70 2F 00 98 00 21 7B 44 1B 68 D1 50 02 B0 BD E8 10 40 04 B0 70 47 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F0 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__inet_aton"
		size = 232
		refs = "003e strtoul 008a .LANCHOR0 00d0 __libc_errno 00e0 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 33 4B 34 4A 2D E9 F0 4F 83 46 7B 44 1B 68 1D EE 70 4F 7A 44 12 68 00 20 E6 58 83 B0 A0 50 89 46 9B F8 00 30 00 90 30 3B 09 2B 1C D8 DF F8 B4 80 6F 46 EA 46 0D F1 03 05 58 46 01 A9 00 22 ?? ?? ?? ?? 43 1C 17 D0 01 9B 1A 78 2E 2A 1A D1 AA 45 03 F1 01 0B 07 D0 FF 28 05 D8 0A F8 01 0B 5B 78 30 3B 09 2B E8 D9 1C 4B 00 20 7B 44 1B 68 E6 50 03 B0 BD E8 F0 8F 43 46 7B 44 1B 68 E3 58 22 2B E1 D1 F0 E7 CA B9 5B 45 ED D0 ?? ?2 0? 0? C7 EB 0A 07 ?? ?2 0? 0? 53 F8 27 30 83 42 E3 D3 B9 F1 00 0F 04 D0 00 9B 00 BA 03 43 C9 F8 00 30 0B 4B 01 20 7B 44 1B 68 E6 50 DA E7 11 06 D3 D4 08 49 79 44 09 68 61 58 31 F8 12 20 92 04 CB D5 DA E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "inet_addr"
		size = 30
		refs = "0006 __inet_aton"
	strings:
		$1 = { 00 B5 83 B0 01 A9 ?? ?? ?? ?? 20 B9 4F F0 FF 30 03 B0 5D F8 04 FB 01 98 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "svcunix_freeargs"
		size = 18
		altNames = "svctcp_freeargs"
	strings:
		$1 = { C0 6A 0B 46 10 B5 11 46 02 24 40 F8 08 4F 98 47 10 BD }
	condition:
		$1
}

rule file_167_3_0 {
	meta:
		name = "svcunix_destroy"
		size = 54
		refs = "0006 xprt_unregister 000c __close 0022 free"
		altNames = "svctcp_destroy"
	strings:
		$1 = { 38 B5 04 46 C5 6A ?? ?? ?? ?? 20 68 ?? ?? ?? ?? A3 88 6B B9 EB 68 DB 69 13 B1 05 F1 08 00 98 47 28 46 ?? ?? ?? ?? 20 46 BD E8 38 40 ?? ?? ?? ?? 00 23 A3 80 F4 E7 }
	condition:
		$1
}

rule file_167_5_0 {
	meta:
		name = "makefd_xprt"
		size = 192
		refs = "0010 malloc 0030 readunix 0034 writeunix 0052 xdrrec_create 0058 .LANCHOR0 0072 xprt_register 007e _libc_intl_domainname 0082 .LC0 0090 __dcgettext 0094 .LC1 0098 .LC2 00a8 __fxprintf 00ae free"
	strings:
		$1 = { 2D E9 F0 47 80 46 82 B0 4F F4 9A 70 8A 46 91 46 ?? ?? ?? ?? 04 46 4F F4 D8 70 ?? ?? ?? ?? 00 2C 18 BF 00 28 05 46 14 BF 00 26 01 26 27 D0 86 46 ?? ?2 0? 0? ?? ?2 0? 0? 51 46 4A 46 02 20 ?? ?2 0? 0? 4E F8 08 0B ?? ?2 0? 0? 70 46 00 93 23 46 01 97 ?? ?? ?? ?? 20 46 ?? ?2 0? 0? E5 62 ?? ?2 0? 0? 26 63 20 35 E6 60 65 62 A6 80 C4 F8 00 80 A3 60 ?? ?? ?? ?? 20 46 02 B0 BD E8 F0 87 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 03 46 00 20 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 00 20 02 B0 BD E8 F0 87 }
	condition:
		$1
}

rule file_837_5_0 {
	meta:
		name = "makefd_xprt"
		size = 192
		refs = "0010 malloc 0030 readtcp 0034 writetcp 0052 xdrrec_create 0058 .LANCHOR0 0072 xprt_register 007e _libc_intl_domainname 0082 .LC0 0090 __dcgettext 0094 .LC1 0098 .LC2 00a8 __fxprintf 00ae free"
	strings:
		$1 = { 2D E9 F0 47 80 46 82 B0 4F F4 9A 70 8A 46 91 46 ?? ?? ?? ?? 04 46 4F F4 D8 70 ?? ?? ?? ?? 00 2C 18 BF 00 28 05 46 14 BF 00 26 01 26 27 D0 86 46 ?? ?2 0? 0? ?? ?2 0? 0? 51 46 4A 46 02 20 ?? ?2 0? 0? 4E F8 08 0B ?? ?2 0? 0? 70 46 00 93 23 46 01 97 ?? ?? ?? ?? 20 46 ?? ?2 0? 0? E5 62 ?? ?2 0? 0? 26 63 20 35 E6 60 65 62 A6 80 C4 F8 00 80 A3 60 ?? ?? ?? ?? 20 46 02 B0 BD E8 F0 87 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 03 46 00 20 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 00 20 02 B0 BD E8 F0 87 }
	condition:
		$1
}

rule file_167_6_0 {
	meta:
		name = "readunix"
		size = 212
		refs = "0020 __poll 0046 .LANCHOR1 0074 __setsockopt 0090 __recvmsg 00cc __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 06 46 31 4F 8F B0 04 68 89 46 90 46 01 25 01 21 03 A8 48 F6 B8 02 03 94 AD F8 10 50 ?? ?? ?? ?? 41 1C 45 D0 00 28 3B D0 BD F8 12 30 13 F0 38 0F 36 D1 DA 07 EB D5 0E AB 01 25 04 22 29 46 43 F8 30 5D ?? ?2 0? 0? 00 92 20 46 10 22 ?? ?2 0? 0? 0D F1 14 0E 0A 95 0B 97 00 25 1C 27 CD F8 14 90 CD F8 18 80 CD F8 24 E0 07 95 08 95 0D 95 0C 97 ?? ?? ?? ?? A0 B9 15 4D 05 E0 2A 46 7A 44 12 68 9B 58 04 2B 0C D1 20 46 07 A9 00 22 ?? ?? ?? ?? 1D EE 70 3F 00 28 F0 DB 0D 9B 1B 07 00 D4 20 B9 F3 6A 4F F0 FF 30 00 22 1A 60 0F B0 BD E8 F0 83 3B 46 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B EF D1 BD F8 12 30 B5 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_7_0 {
	meta:
		name = "writeunix"
		size = 172
		refs = "0010 .LANCHOR1 0022 __getpid 0028 __geteuid 002e __getegid 0076 __sendmsg 00a8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 00 2A 8D B0 89 46 00 90 01 92 3E DD ?? ?2 0? 0? 24 4D ?? ?2 0? 0? 90 46 00 27 00 9B 1C 68 ?? ?? ?? ?? 82 46 ?? ?? ?? ?? 83 46 ?? ?? ?? ?? 01 22 02 23 18 21 C6 F8 0C A0 86 E8 0E 00 03 AB 01 22 07 93 C6 F8 10 B0 18 23 CD F8 0C 90 CD F8 10 80 08 92 05 97 06 97 09 96 0A 93 0B 97 70 61 05 E0 2A 46 7A 44 12 68 9B 58 04 2B 12 D1 20 46 05 A9 00 22 ?? ?? ?? ?? 1D EE 70 3F 00 28 F0 DB C0 EB 08 08 81 44 B8 F1 00 0F C7 DC 01 98 0D B0 BD E8 F0 8F 00 9A 4F F0 FF 30 D3 6A 00 22 1A 60 0D B0 BD E8 F0 8F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_8_0 {
	meta:
		name = "rendezvous_request"
		size = 108
		refs = "0022 accept 005e __svc_accept_failed 0068 __libc_errno"
	strings:
		$1 = { F0 B5 04 46 A3 B0 18 4E C7 6A 6E 25 05 E0 32 46 7A 44 12 68 9B 58 04 2B 21 D1 20 68 06 A9 01 AA 01 95 ?? ?? ?? ?? 1D EE 70 3F 00 28 EF DB 97 E8 06 00 00 23 01 24 02 93 03 93 04 93 05 93 AD F8 08 40 FF F7 7D FF 02 AC 01 9F 05 46 0F CC EF 60 28 61 00 20 69 61 AA 61 EB 61 23 B0 F0 BD ?? ?? ?? ?? 00 20 23 B0 F0 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_9_0 {
	meta:
		name = "svcunix_reply"
		size = 36
		refs = "0012 xdr_replymsg 001c xdrrec_endofrecord"
		altNames = "svctcp_reply"
	strings:
		$1 = { 38 B5 00 25 C3 6A 03 F1 08 04 5A 68 20 46 9D 60 0A 60 ?? ?? ?? ?? 01 21 05 46 20 46 ?? ?? ?? ?? 28 46 38 BD }
	condition:
		$1
}

rule file_167_10_0 {
	meta:
		name = "svcunix_stat"
		size = 26
		refs = "000c xdrrec_eof"
		altNames = "svctcp_stat"
	strings:
		$1 = { 08 B5 C3 6A 18 68 38 B1 03 F1 08 00 ?? ?? ?? ?? 00 28 14 BF 02 20 01 20 08 BD }
	condition:
		$1
}

rule file_167_11_0 {
	meta:
		name = "svcunix_recv"
		size = 60
		refs = "0010 xdrrec_skiprecord 0018 xdr_callmsg 0026 .LANCHOR1"
	strings:
		$1 = { F8 B5 0D 46 C4 6A 01 27 04 F1 08 06 30 46 A7 60 ?? ?? ?? ?? 30 46 29 46 ?? ?? ?? ?? 03 46 08 B9 23 60 F8 BD 2A 68 ?? ?2 0? 0? ?? ?2 0? 0? 1C 21 38 46 62 60 6F 62 AB 62 E9 62 F8 BD }
	condition:
		$1
}

rule file_167_12_0 {
	meta:
		name = "svcunix_create"
		size = 368
		refs = "0020 memset 002c strlen 003e memcpy 004c __bind 0056 __getsockname 005c _libc_intl_domainname 0060 .LC4 006e __dcgettext 0072 perror 0086 __listen 0092 malloc 00b0 _null_auth 00e4 xprt_register 00f6 __socket 0106 .LC3 0120 __close 0130 .LC0 0142 .LC1 0146 __func__.12731 0156 __fxprintf 015c free"
	strings:
		$1 = { 2D E9 F0 43 9F B0 1D 46 10 23 01 93 43 1C 04 46 89 46 90 46 18 BF 00 27 6A D0 00 21 6E 22 02 A8 ?? ?? ?? ?? 28 46 01 23 AD F8 08 30 ?? ?? ?? ?? 29 46 1E AD 06 46 42 1C 03 36 0D F1 0A 00 ?? ?? ?? ?? 32 46 02 A9 20 46 45 F8 74 6D ?? ?? ?? ?? 20 46 02 A9 2A 46 ?? ?? ?? ?? 90 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?? ?? ?? 00 2F 51 D1 00 20 1F B0 BD E8 F0 83 20 46 80 21 ?? ?? ?? ?? 05 46 00 28 E5 D1 08 20 ?? ?? ?? ?? 06 46 4F F4 9A 70 ?? ?? ?? ?? 00 2E 18 BF 00 28 07 46 14 BF 00 22 01 22 3D D0 ?? ?2 0? 0? 02 63 ?? ?2 0? 0? 00 F1 20 05 DF F8 AC C0 4F F6 FF 7E 93 E8 07 00 FE 62 C6 F8 00 90 C6 F8 04 80 85 E8 07 00 38 46 3C 60 C7 F8 08 C0 A7 F8 04 E0 ?? ?? ?? ?? 38 46 1F B0 BD E8 F0 83 01 20 00 22 01 46 ?? ?? ?? ?? 04 1E A8 BF 01 27 8B DA ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?? ?? ?? AD E7 20 46 ?? ?? ?? ?? 00 20 1F B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 03 46 28 46 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? 28 46 88 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "strerror"
		size = 112
		refs = "0008 __strerror_r 0010 .LANCHOR0 0046 malloc 004e _libc_intl_domainname 0052 .LC0 0068 __libc_errno 0064 __dcgettext"
	strings:
		$1 = { 00 21 F8 B5 0A 46 04 46 ?? ?? ?? ?? 00 B1 F8 BD ?? ?2 0? 0? 14 4B ?? ?2 0? 0? 1D EE 70 6F 7B 44 1B 68 2A 68 F7 58 62 B1 10 4B 29 68 7B 44 1B 68 F7 50 61 B1 20 46 4F F4 80 62 BD E8 F8 40 ?? ?? ?? ?? 4F F4 80 60 ?? ?? ?? ?? 28 60 EC E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 BD E8 F8 40 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__syscall_error"
		size = 28
		refs = "0018 errno"
	strings:
		$1 = { C0 F1 00 00 01 46 1D EE 70 0F 03 4A 7A 44 12 68 81 50 6F F0 00 00 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "___fprintf_chk"
		size = 316
		refs = "0062 vfprintf 00d0 __libc_do_syscall 00d6 __lll_lock_wait_private 0138 _Unwind_Resume"
	strings:
		$1 = { 0C B4 03 68 F0 B5 0E 46 83 B0 19 04 04 46 08 9D 1C D4 80 6C 1D EE 70 7F A7 F5 98 67 83 68 BB 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 4A D1 A3 6C 18 46 9F 60 43 68 01 33 43 60 00 2E 29 46 20 46 C2 BF E3 6B 43 F0 04 03 E3 63 09 AB 1A 46 01 93 ?? ?? ?? ?? E3 6B 00 2E 22 68 05 46 C4 BF 23 F0 04 03 E3 63 12 04 23 F0 14 03 E3 63 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 05 DC 28 46 03 B0 BD E8 F0 40 02 B0 70 47 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EC E7 ?? ?? ?? ?? B1 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "__fwprintf_chk"
		size = 316
		refs = "0062 _IO_vfwprintf 00d0 __libc_do_syscall 00d6 __lll_lock_wait_private 0138 _Unwind_Resume"
	strings:
		$1 = { 0C B4 03 68 F0 B5 0E 46 83 B0 19 04 04 46 08 9D 1C D4 80 6C 1D EE 70 7F A7 F5 98 67 83 68 BB 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 4A D1 A3 6C 18 46 9F 60 43 68 01 33 43 60 00 2E 29 46 20 46 C2 BF E3 6B 43 F0 04 03 E3 63 09 AB 1A 46 01 93 ?? ?? ?? ?? E3 6B 00 2E 22 68 05 46 C4 BF 23 F0 04 03 E3 63 12 04 23 F0 14 03 E3 63 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 05 DC 28 46 03 B0 BD E8 F0 40 02 B0 70 47 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EC E7 ?? ?? ?? ?? B1 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "gethostid"
		size = 296
		refs = "0004 .LC0 001a __libc_do_syscall 0056 __gethostname 00b2 __gethostbyname_r 00ea memcpy 011c __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 9C B0 4F F4 00 31 ?? ?2 0? 0? 02 AF 00 22 4F F0 05 0C ?? ?? ?? ?? 10 F5 80 5F 03 46 67 D8 00 28 12 DB 39 1D 04 22 4F F0 03 0C ?? ?? ?? ?? 10 F5 80 5F 02 46 63 D8 18 46 4F F0 06 0C ?? ?? ?? ?? 04 2A 08 BF 78 68 0A D0 40 21 07 F1 24 00 ?? ?? ?? ?? 00 28 02 DB 97 F8 24 30 23 B9 00 20 68 37 BD 46 BD E8 F0 81 AD F5 81 6D 4F F4 80 64 02 AD 07 F1 0C 06 DF F8 A4 80 0E E0 43 46 7B 44 1B 68 D3 58 22 2B EA D1 AD EB 00 0D 02 AB 5A 18 95 42 1D 46 08 BF 09 19 0C 46 3B 1C 07 F1 10 01 00 93 2A 46 07 F1 24 00 01 96 23 46 ?? ?? ?? ?? 61 00 1D EE 70 2F 0F 31 08 B9 3B 68 3B B9 FB 68 21 F0 0F 01 01 F1 08 00 01 33 D7 D0 C7 E7 1C 69 07 F1 68 01 DA 68 41 F8 60 0D 08 46 04 2A A8 BF 04 22 21 68 ?? ?? ?? ?? B8 68 4F EA 30 40 B7 E7 09 4A 1D EE 70 1F 43 42 7A 44 12 68 8B 50 A4 E7 06 49 44 42 1D EE 70 0F 4F F0 FF 32 79 44 09 68 44 50 91 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__atomic_writev_replacement"
		size = 264
		refs = "0084 mempcpy 0094 __write 009c free 00cc __libc_alloca_cutoff 00d6 malloc 00ec _Unwind_Resume 0104 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F B2 F1 00 08 83 B0 82 46 89 46 00 AF 59 DD 4E 68 B6 F1 00 4F 3E BF 00 25 0A 46 2C 46 09 D3 42 E0 08 32 4F F6 FF 73 C7 F6 FF 73 56 68 1B 1B B3 42 39 D3 01 35 34 44 45 45 F2 D1 B4 F5 80 5F 42 D8 04 F1 0E 03 B8 F1 00 0F 23 F0 07 03 AD EB 03 0D 4F F0 00 03 C7 F8 04 D0 3B 60 16 DD 4E 46 78 68 25 46 4F F0 00 0B 04 E0 0B F1 01 0B 08 36 C3 45 0B D0 96 E8 06 00 95 42 34 BF A9 46 91 46 4A 46 ?? ?? ?? ?? B5 EB 09 05 EE D1 50 46 79 68 22 46 ?? ?? ?? ?? 04 46 38 68 ?? ?? ?? ?? 20 46 0C 37 BD 46 BD E8 F0 8F 16 4B 1D EE 70 2F 4F F0 FF 34 16 21 7B 44 1B 68 20 46 0C 37 D1 50 BD 46 BD E8 F0 8F 00 24 BC E7 20 46 ?? ?? ?? ?? 00 28 B7 D1 20 46 ?? ?? ?? ?? 78 60 40 B1 38 60 BE E7 04 46 38 68 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 7B 68 4F F0 FF 34 3B 60 CF E7 00 23 04 46 3B 60 F0 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_174_1_0 {
	meta:
		name = "__libc_writev"
		size = 168
		refs = "0000 __libc_multiple_threads 001a __libc_do_syscall 0050 __libc_enable_asynccancel 006e __libc_disable_asynccancel 009c __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 41 07 46 1B 68 0E 46 15 46 E3 B9 4F F0 92 0C ?? ?? ?? ?? 10 F5 80 5F 27 D8 04 46 00 2C 02 DB 20 46 BD E8 F0 81 1A 4B 1D EE 70 2F 7B 44 1B 68 D3 58 16 2B F4 D1 08 2D F2 DD 38 46 31 46 2A 46 BD E8 F0 41 53 E7 ?? ?? ?? ?? 31 46 2A 46 4F F0 92 0C 80 46 38 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0D D8 40 46 ?? ?? ?? ?? D8 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 CD E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E7 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "fexecve"
		size = 152
		refs = "0018 .LC0 0026 __snprintf 0030 __execve 003a .LC1 004c __xstat 0088 __libc_errno"
	strings:
		$1 = { D1 F1 01 03 38 BF 00 23 30 B5 53 EA D0 73 9F B0 0C 46 15 46 2C D1 5A B3 ?? ?2 0? 0? 03 46 ?? ?2 0? 0? 1B 21 01 A8 ?? ?? ?? ?? 21 46 2A 46 01 A8 ?? ?? ?? ?? 14 4B 1D EE 70 4F ?? ?2 0? 0? 7B 44 1B 68 ?? ?2 0? 0? 03 20 08 AA E5 58 ?? ?? ?? ?? 30 B1 0E 4B 7B 44 1B 68 E3 58 02 2B 08 BF 26 25 0B 4B 4F F0 FF 30 7B 44 1B 68 E5 50 1F B0 30 BD 08 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 1F B0 30 BD 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__getdtablesize"
		size = 28
		refs = "0008 __getrlimit"
	strings:
		$1 = { 00 B5 83 B0 69 46 07 20 ?? ?? ?? ?? 00 28 B4 BF 4F F4 80 70 00 98 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__frexp"
		size = 116
		refs = "0038 __aeabi_dmul"
	strings:
		$1 = { 2D E9 F8 43 90 46 4F F6 FF 72 21 F0 00 43 C7 F6 EF 72 4F F0 00 0C 93 42 06 46 0F 46 89 46 C8 F8 00 C0 23 DC 53 EA 00 02 20 D0 B3 F5 80 1F 0B DA 00 23 00 22 C4 F2 50 33 ?? ?? ?? ?? 6F F0 35 0C 06 46 89 46 21 F0 00 43 29 F0 FF 49 1B 15 29 F4 E0 09 A3 F2 FE 33 49 F0 7F 59 63 44 49 F4 00 17 30 46 39 46 C8 F8 00 30 BD E8 F8 83 30 46 39 46 BD E8 F8 83 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "getgrent"
		size = 204
		refs = "0004 .LANCHOR0 002c __getgrent_r 0030 .LANCHOR1 004a __nss_getent 009a __lll_lock_wait_private 00b8 __libc_do_syscall 00c4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 82 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 9B BB 25 4B ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A3 F1 10 01 ?? ?2 0? 0? 00 93 00 26 4F F4 80 63 01 96 ?? ?? ?? ?? 1D 4B 1D EE 70 5F 7B 44 1B 68 55 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 45 F8 03 80 02 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C4 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "getaliasent"
		size = 204
		refs = "0004 .LANCHOR0 002c __getaliasent_r 0030 .LANCHOR1 004a __nss_getent 009a __lll_lock_wait_private 00b8 __libc_do_syscall 00c4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 82 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 9B BB 25 4B ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A3 F1 10 01 ?? ?2 0? 0? 00 93 00 26 4F F4 80 63 01 96 ?? ?? ?? ?? 1D 4B 1D EE 70 5F 7B 44 1B 68 55 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 45 F8 03 80 02 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C4 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1037_0_0 {
	meta:
		name = "getservent"
		size = 204
		refs = "0004 .LANCHOR0 002c __getservent_r 0030 .LANCHOR1 004a __nss_getent 009a __lll_lock_wait_private 00b8 __libc_do_syscall 00c4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 82 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 9B BB 25 4B ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A3 F1 10 01 ?? ?2 0? 0? 00 93 00 26 4F F4 80 63 01 96 ?? ?? ?? ?? 1D 4B 1D EE 70 5F 7B 44 1B 68 55 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 45 F8 03 80 02 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C4 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1289_0_0 {
	meta:
		name = "getsgent"
		size = 204
		refs = "0004 .LANCHOR0 002c __getsgent_r 0030 .LANCHOR1 004a __nss_getent 009a __lll_lock_wait_private 00b8 __libc_do_syscall 00c4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 82 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 9B BB 25 4B ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A3 F1 10 01 ?? ?2 0? 0? 00 93 00 26 4F F4 80 63 01 96 ?? ?? ?? ?? 1D 4B 1D EE 70 5F 7B 44 1B 68 55 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 45 F8 03 80 02 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C4 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__posix_spawn_file_actions_realloc"
		size = 34
		refs = "0010 realloc"
	strings:
		$1 = { 38 B5 04 46 05 68 80 68 08 35 05 EB 85 01 89 00 ?? ?? ?? ?? 18 B1 A0 60 00 20 25 60 38 BD 0C 20 38 BD }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "_IO_getwc"
		size = 274
		refs = "00a4 __libc_do_syscall 00ac __wuflow 00b4 __lll_lock_wait_private 010e _Unwind_Resume"
	strings:
		$1 = { 38 B5 04 46 03 68 19 04 1C D4 80 6C 1D EE 70 5F A5 F5 98 65 83 68 AB 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 3D D1 A3 6C 18 46 9D 60 43 68 01 33 43 60 E3 6D 83 B3 1A 68 59 68 8A 42 2C D2 15 68 04 32 1A 60 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 01 DC 28 46 38 BD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? F0 E7 20 46 ?? ?? ?? ?? 05 46 D0 E7 ?? ?? ?? ?? BE E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "round_and_return"
		size = 776
		refs = "0000 _dl_hwcap 0088 __aeabi_dmul 010e __mpn_rshift 0176 __mpn_construct_double 02b4 abort 02fc __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 4D 14 46 1D 46 D1 E9 00 23 4F F0 40 0A 4F F0 00 0B 0A EA 02 0A 0B EA 03 0B 82 B0 80 46 5A EA 0B 00 0D 9E 08 BF 4F F0 00 0A 03 D0 F1 EE 10 AA 0A F4 40 0A 4F F6 02 42 4F F0 FF 33 CF F6 FF 72 94 42 75 EB 03 01 1F DA 4F F6 CD 32 4F F0 FF 33 CF F6 FF 72 94 42 75 EB 03 00 34 DA A5 4B 1D EE 70 2F 0A 9C 22 21 7B 44 1B 68 00 20 D1 50 4F F4 80 11 00 2C 4B D0 00 23 00 22 C8 F2 10 03 ?? ?? ?? ?? 02 B0 BD E8 F0 8D 4F F4 80 62 00 23 A2 42 73 EB 05 00 42 DA 97 4B 1D EE 70 2F 0A 9C 22 21 7B 44 1B 68 4F F0 FF 30 D1 50 4F F6 FF 71 C7 F6 EF 71 64 B3 4F F0 FF 32 6F F4 80 13 ?? ?? ?? ?? 02 B0 BD E8 F0 8D 0C 9D 01 23 C4 F1 7F 44 03 FA 05 F7 04 F5 7F 04 0B 9D 04 F5 7C 44 01 3F 02 34 2F 42 18 BF 46 F0 01 06 35 2C 42 D0 1F 2C 00 F3 AD 80 23 46 01 3C 0C 94 40 46 D8 F8 00 40 41 46 02 22 0B 94 ?? ?? ?? ?? D8 F8 00 B0 46 E0 02 46 0B 46 ?? ?? ?? ?? 02 B0 BD E8 F0 8D 0B 99 0C 9A D8 F8 00 B0 21 FA 02 FC 0C F0 01 07 0A 98 39 46 01 22 03 1C 18 BF 01 23 46 B9 0C 98 02 FA 00 F7 0B 9A 01 3F 17 42 0C BF 00 22 01 22 BA F5 80 0F 00 F0 A4 80 4A DD BA F5 00 0F 00 F0 A8 80 BA F5 40 0F 40 F0 A2 80 21 46 40 46 0A 9A ?? ?? ?? ?? A6 E7 D8 F8 04 40 14 25 D8 F8 00 B0 0C 95 BB F1 00 0F 08 BF 00 2C 0B 94 0C BF 00 23 01 23 4F F0 00 0B 1E 43 C8 F8 00 B0 C8 F8 04 B0 0B 9D 0C 9C 25 FA 04 FC 1C F0 01 07 05 D1 26 B9 01 23 A3 40 01 3B 2B 42 13 D0 50 4C 1D EE 70 5F 00 20 4F F4 80 11 7C 44 24 68 4F F0 22 0E 02 46 0B 46 45 F8 04 E0 ?? ?? ?? ?? CD E9 00 01 DD E9 00 23 4F F6 01 44 4F F0 FF 35 CF F6 FF 74 9F E7 BA F1 00 0F 5B D1 00 29 B7 D0 0B F0 01 0C 42 EA 0C 01 00 29 B1 D0 0B F1 01 03 D8 F8 04 10 9B 45 C8 F8 00 30 84 BF 01 31 C8 F8 04 10 8B 02 4F D4 4F F6 01 42 4F F0 FF 33 CF F6 FF 72 9D 42 08 BF 94 42 9A D1 4F F6 01 44 4F F6 02 43 11 F4 80 1F CF F6 FF 74 CF F6 FF 73 0C BF 21 46 19 46 8D E7 63 1E 03 F0 1F 05 0C 95 5B 11 01 2B 58 F8 23 50 0B 95 05 D1 D8 F8 00 30 00 2B 18 BF 46 F0 01 06 01 21 0C 9D 04 F0 1F 03 0A 46 01 FA 05 F4 0B 9D 01 3C 40 46 25 42 08 F1 04 01 18 BF 46 F0 01 06 ?? ?? ?? ?? 00 23 D8 F8 00 B0 C8 F8 04 30 7F E7 42 EA 01 0C 5F FA 8C F1 00 2B AA D0 5D E7 ?? ?? ?? ?? 1B B1 42 EA 01 0C 5F FA 8C F3 19 46 A0 E7 01 34 41 46 4F F0 02 02 4F F0 01 03 40 46 45 F1 00 05 ?? ?? ?? ?? 40 F2 01 42 00 23 D8 F8 04 10 9D 42 08 BF 94 42 41 F4 80 11 C8 F8 04 10 3F F4 D4 AE 3A E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "str_to_mpn.isra.0"
		size = 560
		refs = "00b4 __mpn_mul_1 0132 _tens_in_limb 01c6 .LC2 01ca .LC1 01ce __PRETTY_FUNCTION__.13517 01e2 __assert_fail 01f0 .LC0"
	strings:
		$1 = { 2D E9 F8 4F 0C 1E 92 46 9B 46 4F F0 00 02 80 46 1A 60 0B 9F 0C 9D 40 F3 EB 80 21 46 01 26 13 46 14 46 89 46 00 E0 63 46 98 F8 00 10 A1 F1 30 00 09 28 06 D9 15 B1 28 78 88 42 1B D0 B8 44 98 F8 00 10 04 EB 84 04 B9 F1 01 09 08 F1 01 08 03 F1 01 0C 01 EB 44 04 A4 F1 30 04 5A D0 BC F1 09 0F E1 D1 0A BB CA F8 00 40 00 24 CB F8 00 60 A4 46 01 22 D8 E7 69 78 00 29 00 F0 B5 80 98 F8 01 00 88 42 DB D1 4F F0 01 0C 03 E0 18 F8 0C 00 88 42 D4 D1 0C F1 01 0C 60 46 15 F8 0C 10 00 29 F4 D1 80 44 98 F8 00 10 CC E7 4F F4 4A 43 50 46 C3 F6 9A 33 51 46 ?? ?? ?? ?? DA F8 00 20 DB F8 00 30 14 44 CA F8 00 40 A2 42 1C D9 0A F1 04 02 05 E0 52 F8 04 1B 01 31 42 F8 04 1C 99 B9 01 3B F7 D1 01 24 24 18 11 D0 DB F8 00 30 72 2B 00 F3 90 80 4A F8 23 40 00 24 DB F8 00 20 A4 46 01 32 CB F8 00 20 90 E7 00 24 24 18 ED D1 DB F8 00 20 A4 46 89 E7 0A 9E A1 46 D6 E9 00 45 01 2C 75 F1 00 01 21 DB C3 F1 08 03 1E 46 DF 17 A6 42 77 EB 05 03 19 DB ?? ?2 0? 0? 0A 9E 25 46 ?? ?2 0? 0? 00 21 00 20 C6 E9 00 01 64 44 53 F8 25 10 53 F8 24 30 01 FB 09 F9 7A B9 CA F8 00 90 01 23 CB F8 00 30 40 46 BD E8 F8 8F ?? ?2 0? 0? ?? ?2 0? 0? 53 F8 2C 30 00 2A EF D0 51 46 50 46 ?? ?? ?? ?? DA F8 00 10 DB F8 00 30 09 EB 01 02 CA F8 00 20 91 42 0C D9 0A F1 04 02 05 E0 52 F8 04 1B 01 31 42 F8 04 1C 19 B9 01 3B F7 D1 01 23 00 E0 00 23 1B 18 D6 D0 DB F8 00 20 72 2A DE BF 51 1C CB F8 00 10 4A F8 22 30 CC DD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 B3 12 ?? ?? ?? ?? 01 20 80 44 98 F8 00 10 28 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 B5 72 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 7B 12 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "____strtod_l_internal"
		size = 7348
		refs = "0020 strlen 029c _nl_C_locobj 0374 __aeabi_ldivmod 05ac __tens 0628 memcpy 0652 __mpn_mul 06c0 __mpn_lshift 072c __aeabi_uidiv 0736 __aeabi_uidivmod 0890 _fpioconst_pow10 095e .LANCHOR0 0b38 __correctly_grouped_prefixmb 0b8e .LC6 0b9c __strncasecmp_l 0bc6 .LC4 0be4 .LC5 0e06 __mpn_rshift 0e7a __mpn_cmp 12c8 __mpn_submul_1 12dc __mpn_add_n 14c4 .LC17 14c8 .LC1 14cc __PRETTY_FUNCTION__.13567 14e0 __assert_fail 16d8 ____strtoull_l_internal 170a .LC13 1784 .LC8 17a4 .LC11 17e0 .LC18 181e .LC19 183e .LC21 18b0 .LC10 1910 __aeabi_dmul 191c .LC12 193c .LC20 195c .LC7 1a34 .LC9 1a54 .LC3 1b00 .LC16 1bf8 __libc_errno 1c18 .LC15 1c6c .LC14"
	strings:
		$1 = { 2D E9 F0 4F AD F2 24 4D 82 46 0C 93 0E 91 5B 68 00 2A 41 F0 F9 84 90 46 11 92 D3 F8 24 B0 58 46 ?? ?? ?? ?? 0F 90 00 28 01 F0 14 85 0C 9D 0D F5 84 66 51 46 00 22 00 23 66 E9 EA 23 68 6B 0B 96 0E 46 01 31 34 78 30 F8 14 30 03 F4 00 53 9B B2 00 2B F5 D1 2D 2C 32 46 00 F0 E1 81 2B 2C 14 93 04 BF 0E 46 54 78 9B F8 00 30 00 2B 00 F0 07 86 32 78 9A 42 40 F0 0D 81 58 46 35 46 00 22 04 E0 15 F8 01 7F B9 42 40 F0 04 81 10 F8 01 1F 01 32 17 46 00 29 F4 D1 F2 5D 30 3A 09 2A 00 F2 F9 80 30 2C 00 F0 DD 83 11 9F DD F8 30 C0 D7 F1 01 07 38 BF 00 27 10 97 DC F8 38 50 00 2F 01 F0 98 84 B1 46 4F F0 0A 0C CD F8 20 C0 A4 F1 30 02 55 F8 24 00 D1 B2 09 29 2D D9 C0 B2 06 90 08 98 06 9F 10 38 18 BF 01 20 12 90 08 98 A7 F1 61 01 05 29 98 BF 10 28 1E D0 7B B1 31 78 99 42 40 F0 03 85 58 46 37 46 04 E0 17 F8 01 CF 61 45 40 F0 FB 84 10 F8 01 1F 00 29 F6 D1 08 9F B1 45 08 BF 10 2F 08 D1 DD F8 3C C0 16 F8 0C 10 A1 F1 30 00 09 28 01 F2 19 80 00 21 B4 46 0F 46 06 91 D2 B2 09 2A 40 F2 CB 80 08 98 10 28 00 F0 C0 80 10 99 00 29 01 F0 90 84 06 97 B8 F1 00 0F 41 F0 A4 84 06 98 00 28 14 BF 4F F0 00 09 6F F0 00 09 83 B1 9C F8 00 20 9A 42 40 F0 B9 80 5A 46 61 46 04 E0 11 F8 01 0F 83 42 40 F0 B1 80 12 F8 01 3F 00 2B F6 D1 0F 9C DD F8 18 A0 20 46 08 99 1C F8 04 30 60 44 54 46 12 E0 A2 F1 61 07 05 2F 00 F2 A2 80 B9 F1 FF 37 7A 42 7A 41 30 2B 08 BF 00 22 0A B1 C4 EB 0A 09 10 F8 01 3F 0A F1 01 0A A3 F1 30 02 84 46 09 2A EC D9 10 29 15 F8 23 20 E3 D0 00 24 10 94 DD F8 20 C0 B2 F1 65 07 7A 42 7A 41 BC F1 10 0F 08 BF 00 22 84 46 9A B1 9C F8 01 80 B8 F1 2D 0F 40 F0 8D 80 9C F8 02 80 01 24 0C F1 02 07 15 94 A8 F1 30 08 5F FA 88 F3 09 2B 40 F2 96 80 60 46 06 9C A2 45 13 D9 1C F8 01 3C 30 2B 0B D1 63 46 01 3B 13 F8 01 2C 03 EB 0A 01 30 2A CC EB 01 01 F6 D0 8A 46 9C 46 06 9D AA 45 C1 F0 F3 83 06 9C B4 EB 0A 05 6B 42 6B 41 BA F1 00 0F 08 BF 00 23 3B B1 0B 9D D5 E9 00 23 00 2A 73 F1 00 07 C0 F2 11 83 0E 9C 04 B1 20 60 BA F1 00 0F 40 F0 D4 80 14 9D ED B1 00 20 4F F0 00 41 0D F2 24 4D BD E8 F0 8F A4 F1 30 02 09 2A 7F F6 02 AF ?? ?2 0? 0? ?? ?2 0? 0? AB 6B 13 F8 24 30 69 2B 00 F0 8B 84 6E 2B 00 F0 6C 84 0E 9D 15 B1 0E 9E C6 F8 00 A0 00 20 00 21 0D F2 24 4D BD E8 F0 8F 55 F8 24 20 61 3A D2 B2 05 2A 3F F6 39 AF 01 37 9C F8 01 40 0C F1 01 0C A4 F1 30 02 28 E7 15 F8 24 20 DD F8 18 A0 08 9C B4 F1 10 08 D8 F1 00 03 53 EB 08 03 70 2A 14 BF 00 25 03 F0 01 05 10 95 00 2D 00 F0 F6 83 9C F8 01 80 B8 F1 2D 0F 3F F4 73 AF B8 F1 2B 0F 13 BF 00 25 00 24 9C F8 02 80 0C F1 01 07 14 BF 15 95 0C F1 02 07 A8 F1 30 08 08 BF 15 94 5F FA 88 F3 09 2B 3F F6 6A AF 10 9D 15 9C 00 2D 40 F0 B3 83 00 2C 00 F0 00 84 06 98 00 21 0A 22 00 23 0D 46 10 F5 B4 74 45 F1 00 05 20 46 29 46 CD F8 14 C0 ?? ?? ?? ?? DD F8 14 C0 CD E9 12 01 DD F8 2C E0 20 46 29 46 0A 22 00 23 DE E9 00 45 CD F8 14 C0 ?? ?? ?? ?? DD F8 14 C0 0A 21 CD F8 60 90 19 96 46 46 CD F8 68 A0 E0 46 CD F8 6C B0 BC 46 DD E9 12 AB DD F8 2C 90 CD E9 16 23 00 E0 84 46 A2 45 7B EB 05 00 C1 F2 D0 83 AB 45 08 BF A2 45 4F EA E6 77 01 F0 C3 83 A4 FB 01 23 0C F1 01 00 94 19 01 FB 05 33 43 EB 07 05 C9 E9 00 45 9C F8 01 60 30 3E F3 B2 09 2B E1 D9 19 AE 15 9F DD F8 60 90 C4 46 96 E8 40 0C 00 2F 3F F4 08 AF 0B 99 64 42 65 EB 45 05 C1 E9 00 45 00 E7 01 27 0E 46 54 78 14 97 1E E6 B9 F1 00 0F 3F D0 9B F8 00 00 33 78 9B F8 01 40 00 E0 01 36 98 42 18 BF 73 78 FA D1 6C B1 73 78 A3 42 F6 D1 01 23 03 E0 F1 5C 91 42 40 F0 4B 83 01 33 1B F8 03 20 00 2A F6 D1 08 9D 10 2D 01 F0 3D 80 0B 9C D4 E9 00 01 00 30 41 F1 00 41 4A 46 00 23 99 42 08 BF 90 42 C1 F0 16 82 08 9C C9 EB 0A 0A 0B 9D 10 2C 0F 9C 04 BF 4F EA 99 73 4F EA 89 02 D5 E9 00 01 4C 44 0B 9D 26 44 82 1A 61 EB 03 03 C5 E9 00 23 08 9C 10 2C 00 F0 2C 82 DD F8 2C C0 06 9C DC E9 00 01 00 28 71 F1 00 0E C0 F2 BB 84 BA EB 04 02 6A EB 0A 03 90 42 71 EB 03 05 01 DA 02 46 0B 46 DD F8 18 B0 40 F2 35 14 00 25 DD F8 2C C0 93 44 82 1A 61 EB 03 03 58 46 00 21 24 1A 65 EB 01 05 CD E9 0C 01 94 42 75 EB 03 0E CC E9 00 23 C1 F2 36 82 6F F4 A1 70 4F F0 FF 31 82 42 73 EB 01 05 C1 F2 8B 83 5C 46 BB F1 00 0F 40 F0 AC 83 DA 45 41 F2 9D 83 DD F8 2C C0 40 F2 43 12 00 23 DC E9 00 89 18 EB 02 00 49 EB 03 01 8B 42 08 BF 82 42 C1 F0 8D 83 00 2C 40 F3 8A 87 BB F1 00 0F 01 F0 5C 83 58 EA 09 0E 04 BF C4 F1 36 08 4F F0 00 09 41 F0 53 83 42 46 4F EA E8 73 CD E9 12 23 50 46 DD E9 0C 23 00 21 CD E9 08 01 80 1A 61 EB 03 01 DD E9 12 23 90 42 71 EB 03 03 06 DA CB EB 0A 08 40 46 4F EA E8 71 CD E9 12 01 DD E9 0C 01 ?? ?2 0? 0? DD E9 12 23 ?? ?2 0? 0? 0D F5 15 7C CD F8 18 C0 12 18 0E 94 43 EB 01 03 DD E9 08 01 CD F8 20 E0 82 42 73 EB 01 01 33 46 BC BF 08 EB 0B 0A 01 25 CB EB 0A 0B 4F F0 00 0A C9 EB 0B 09 AC BF 00 27 15 95 0D F1 88 08 A8 BF 15 97 56 46 CD F8 30 B0 4C 46 A3 4F 01 25 DD F8 18 B0 F1 46 CD F8 40 80 9A 46 0E E0 57 F8 0C 6C 58 46 57 F8 10 3C 02 3E 99 1C B2 00 09 EB 81 01 ?? ?? ?? ?? 6D 00 10 37 04 B3 2C 42 FA D0 6C 40 00 2E EB D0 57 F8 10 1C 5B 46 57 F8 0C 2C 40 46 02 31 00 96 02 3A 09 EB 81 01 ?? ?? ?? ?? 57 F8 0C 3C 02 3B 1E 44 5B 46 00 28 40 F0 49 82 C3 46 01 3E 98 46 6D 00 10 37 00 2C DE D1 DD F8 40 80 53 46 0E 9C B2 46 C3 45 1E 46 01 F0 36 80 0B 98 1D AD 11 9F 2B 46 0C 99 42 46 00 90 30 46 0F 9E 0A F1 FF 3C 02 97 CD F8 20 C0 01 96 FF F7 94 FB DD F8 20 C0 06 9F 57 F8 2C 60 B6 FA 86 F6 76 B1 06 98 52 46 33 46 01 46 ?? ?? ?? ?? 40 46 41 46 33 46 2A 68 ?? ?? ?? ?? 00 28 40 F0 01 85 2A 68 DD F8 2C C0 BA F1 01 0F 20 46 4F EA E4 71 CC E9 00 01 00 F0 39 84 BA F1 02 0F 40 F0 B2 83 06 9D 01 2A 2E 68 6D 68 40 F3 3A 85 98 E8 80 04 0D F1 80 09 4F F0 00 0C CD F8 18 C0 4F EA 15 4B 1F FA 85 FC 72 42 CD F8 20 C0 0C 92 AA 45 00 F0 5C 86 59 46 50 46 ?? ?? ?? ?? 59 46 80 46 50 46 ?? ?? ?? ?? DD F8 20 C0 38 0C 0C FB 08 F2 40 EA 01 41 8A 42 0A D9 49 19 08 F1 FF 30 05 D2 8A 42 84 BF A8 F1 02 08 49 19 00 D8 80 46 8A 1A 59 46 10 46 05 92 ?? ?? ?? ?? 05 9A 59 46 BF B2 82 46 10 46 ?? ?? ?? ?? 08 9B 03 FB 0A F2 47 EA 01 41 8A 42 0A D9 49 19 0A F1 FF 30 05 D2 8A 42 84 BF AA F1 02 0A 49 19 00 D8 82 46 4A EA 08 40 89 1A A0 FB 06 23 92 46 8B 42 07 D8 1A F1 00 02 18 BF 01 22 8B 42 18 BF 00 22 42 B1 BA EB 06 07 63 F1 00 03 49 19 00 F1 FF 30 BA 46 EC D3 4F F0 00 0C BC EB 0A 07 61 EB 03 0A 00 2C 40 F0 F3 85 00 28 00 F0 2B 86 0B 9C B0 FA 80 F1 DD F8 2C C0 D4 E9 00 23 C1 F1 20 04 52 1A 63 EB E1 73 35 2C CC E9 00 23 40 F3 AC 87 80 46 4F F6 EB 70 CF F6 FF 70 01 F1 35 04 40 1A 06 94 28 FA 00 F0 C9 F8 00 00 15 98 06 9D BA F1 00 0F 18 BF 40 F0 01 00 12 F1 FF 32 43 F1 FF 33 C5 F1 1F 01 00 28 40 F0 5C 86 00 37 18 BF 01 27 14 9E 48 46 CD F8 04 80 02 91 00 96 03 97 FF F7 35 F9 31 E5 DD F8 30 C0 72 78 11 98 DC F8 38 50 D0 F1 01 00 38 BF 00 20 10 90 55 F8 22 20 78 2A 00 F0 E1 81 00 28 01 F0 B5 80 B1 46 0A 26 08 96 E5 E1 00 BF ?? ?? ?? ?? 10 9C CD F8 48 90 81 46 15 96 06 9D DD F8 30 80 0B 9E 3C BB 1C F8 01 3C 30 3B 09 2B 94 BF 00 23 01 23 DB B9 1C F8 01 3C 30 2B 40 F0 A9 81 0A F1 FF 3A 01 3D 00 2C 40 F0 12 81 01 20 00 21 D6 E9 00 23 1A F1 00 07 18 BF 01 27 12 18 43 EB 01 03 C6 E9 00 23 17 EA D3 77 00 F0 92 81 0C F1 FF 3C 00 2C D7 D0 1C F8 01 2C D8 F8 34 30 33 F8 12 30 83 F4 80 53 C3 F3 00 33 D3 E7 0C 9D 33 78 68 6B 30 F8 13 20 D4 04 07 D4 72 1C 16 46 01 32 33 78 30 F8 13 10 C9 04 F8 D5 30 2B 40 F0 94 86 73 1C 1E 46 13 F8 01 2B 30 2A FA D0 A2 F1 30 03 09 2B 89 BF 12 B2 06 F1 01 0E DD F8 30 C0 06 F1 01 0E 84 BF DC F8 38 30 53 F8 22 30 ?? ?2 0? 0? ?? ?2 0? 0? 88 BF 57 3B 52 F8 23 70 00 2F 00 F0 18 87 0B 9D 0D F1 80 09 C7 F1 15 02 C7 F1 14 01 93 40 C9 F8 04 30 D5 E9 00 45 CD E9 08 45 00 25 DD E9 08 23 06 9C 00 2A 73 F1 00 03 4F F0 FF 32 6F F0 00 43 CD E9 06 45 C0 F2 AB 85 DD E9 08 45 12 1B 63 EB 05 03 D2 1B 63 EB E7 73 54 1C 43 F1 00 05 CD E9 16 45 EC 17 00 25 22 46 E3 17 03 24 22 40 2B 40 DD E9 16 45 CD E9 12 23 12 19 43 EB 05 03 92 08 42 EA 83 74 9D 10 DD E9 06 23 9D 42 08 BF 94 42 C0 F0 91 87 DD E9 06 45 14 F1 FF 34 45 F1 FF 35 CD E9 06 45 07 9E 7D 1E 06 9F 01 24 B3 00 BA 00 43 EA 97 73 56 19 43 EB E5 77 DD E9 08 23 0B 9D 92 19 76 46 43 EB 07 03 DD F8 30 E0 CD E9 06 23 C5 E9 00 23 0F 9F 0A E0 A1 F1 03 0C 59 F8 24 30 04 39 02 FA 0C F2 13 43 49 F8 24 30 AA 46 BA F1 01 05 00 F0 E3 80 33 78 30 F8 13 20 D2 04 57 BF F6 19 1A 46 32 78 13 46 A3 F1 30 0C BC F1 09 0F 99 BF 01 36 30 3A DE F8 38 20 01 36 84 BF 52 F8 23 20 57 3A 02 29 D7 DC 59 F8 24 30 C1 F1 03 08 22 FA 08 F8 01 F1 1D 0C 48 EA 03 03 02 FA 0C F2 49 F8 24 30 00 2C 00 F0 D8 85 1C 31 00 24 C9 F8 00 20 CB E7 00 2C 40 F0 13 83 06 9C 00 2C 00 F0 2E 85 B9 F1 00 0F 40 F0 46 87 06 9D 4F F4 80 72 00 23 52 1B 63 F1 00 03 9D 00 94 00 45 EA 92 75 03 34 45 F1 00 05 44 E0 23 46 A3 E4 04 20 00 21 EC E6 C3 46 98 46 96 E5 10 93 60 46 FF F7 6D BB 12 98 00 28 00 F0 4C 85 DD F8 20 C0 06 98 BC F1 10 0C DC F1 00 07 57 EB 0C 07 65 28 0C BF 39 46 47 F0 01 01 00 29 3F F4 02 AB 11 9A 43 46 48 46 31 46 ?? ?? ?? ?? 0E 9C 34 B1 81 45 18 BF 06 46 00 F0 C3 86 0E 9D 2E 60 14 9E 00 2E 3F F4 B5 AB FF F7 95 BB 06 9C 00 2C 00 F0 AE 82 B9 F1 00 0F 40 F0 0D 86 06 98 40 F2 35 14 00 25 24 1A 65 F1 00 05 00 2C 75 F1 00 01 80 F2 F3 85 00 24 00 25 CD E9 12 45 FF F7 F9 BB ?? ?2 0? 0? 2B 46 ?? ?2 0? 0? 30 46 03 22 ?? ?? ?? ?? 00 28 7F F4 88 AB F3 78 F7 1C 28 2B 00 F0 76 85 00 21 00 20 C7 F6 F8 71 0E 9C 00 2C 3F F4 82 AB 27 60 FF F7 7F BB ?? ?2 0? 0? 30 46 ?? ?2 0? 0? 03 22 2B 46 ?? ?? ?? ?? 00 28 7F F4 6C AB 0E 9C 74 B1 F4 1C ?? ?2 0? 0? 2B 46 20 46 ?? ?2 0? 0? 05 22 ?? ?? ?? ?? 08 B9 06 F1 08 04 0E 9D 2C 60 14 9E 00 20 00 21 00 2E 40 F0 88 84 C7 F6 F0 71 FF F7 58 BB 48 46 15 9E DD F8 48 90 06 95 FF F7 28 BB 0C B1 C9 F8 00 50 14 9F 00 21 48 46 DD E9 06 23 01 91 00 97 02 91 03 91 FE F7 45 FF FF F7 41 BB 06 F1 02 09 B4 78 00 28 00 F0 AD 86 30 2C 0C D1 4F F0 00 08 10 24 08 94 09 F1 01 02 16 46 12 F8 01 4B 30 2C FA D0 FF F7 2F BA 4F F0 10 0C 4E 46 4F F0 00 08 CD F8 20 C0 FF F7 26 BA 1F 46 FF F7 09 BA 0B 9C 30 46 11 9F 1D AD 0F 9E 0D F1 88 08 42 46 2B 46 02 97 59 46 01 96 00 94 FF F7 97 F8 D4 E9 00 23 01 2A 73 F1 00 0C B8 BF 2F 68 06 46 7E DB 2F 68 95 AC DF F8 28 9C ?? ?2 0? 0? 0E 94 ?? ?2 0? 0? 06 94 10 46 CD F8 20 C0 19 46 CD F8 48 A0 01 24 CD F8 54 B0 CA 46 DD F8 38 C0 C3 46 10 96 3A 46 CD F8 38 80 1F E0 08 9F 02 33 60 46 00 96 59 46 07 EB 83 03 CD F8 14 C0 ?? ?? ?? ?? 2A 68 DD F8 14 C0 32 44 2A 60 00 28 34 D0 5B 46 E3 46 DD F8 2C C0 DC E9 00 01 9C 46 50 EA 01 03 4F EA 44 04 0A F1 10 0A 31 D0 E7 17 04 EA 00 08 07 EA 01 09 58 EA 09 0E F0 D0 0B 9E 60 40 5A F8 0C 3C 79 40 C6 E9 00 01 9E 1E 96 42 5A F8 10 3C CB DD 99 1C 08 9F 60 46 00 92 5B 46 32 46 07 EB 81 01 CD F8 14 C0 ?? ?? ?? ?? 2A 68 DD F8 14 C0 32 44 2A 60 00 28 CA D1 DD F8 2C E0 5E 46 53 1E E3 46 1A 46 B4 46 DE E9 00 01 2B 60 C6 E7 06 9C DC 46 10 9E 17 46 A4 45 DD F8 48 A0 DD F8 54 B0 DD F8 38 80 04 D1 61 46 40 46 92 00 ?? ?? ?? ?? 78 1E 58 F8 20 30 B3 FA 83 F3 C3 EB 47 14 B4 F5 80 6F 00 F3 90 85 35 2C 00 F3 97 81 DA 45 40 F0 0F 84 01 3C E3 17 DB 0E E2 18 02 F0 1F 02 D3 1A 14 2B 00 F0 3B 85 13 2B 40 F3 9E 84 01 2F 00 F3 8B 84 C7 F1 02 00 0D F1 80 09 14 3B 41 46 3A 46 09 EB 80 00 ?? ?? ?? ?? 2B 68 C3 F1 01 03 00 2B 49 F8 23 00 06 DD 00 22 01 2B C9 F8 00 20 18 BF C9 F8 04 20 14 9D 00 21 48 46 22 46 E3 17 01 91 00 95 02 91 03 91 FE F7 46 FE FF F7 42 BA 00 25 22 46 2B 46 52 42 63 EB 43 03 82 42 73 EB 01 05 BF F6 44 AB FF F7 40 BB C2 EB 0A 01 06 9F DD F8 20 C0 AA F1 02 0B DD F8 18 E0 07 EB 81 01 40 46 57 F8 2B 70 5E F8 2C 60 ?? ?? ?? ?? 00 28 C5 BF 00 22 2B 68 29 68 59 1C C4 BF 29 60 48 F8 23 20 51 45 80 F2 93 81 00 2C C1 EB 0A 0C 40 F3 CE 83 04 EB 4C 10 0C 90 35 28 00 F3 B0 83 BC F1 01 0F 40 F0 B4 84 20 9A 00 23 0F 93 20 93 21 92 00 29 C4 BF 08 EB 81 01 4F EA 8C 00 05 DD 51 F8 04 2D 0B 18 41 45 5A 60 F9 D1 BC F1 00 0F A2 BF 08 EB 8C 0C 21 AB 00 22 03 DB 43 F8 04 2F 63 45 FB D1 06 9C 00 25 58 F8 2A C0 44 F8 2A 50 0C 9C 35 2C 40 F3 73 81 0B 9E 60 46 0D F1 80 09 D6 E9 00 23 70 B9 BA F1 00 0F 0B DB 08 EB 8A 08 08 99 02 E0 4C 1C 05 D0 01 39 58 F8 04 0D 8A 46 00 28 F7 D0 15 99 14 9E 0F 9C BA F1 00 0F A8 BF 41 F0 01 01 12 F1 FF 32 03 91 C4 F1 1F 00 43 F1 FF 33 02 90 48 46 00 96 01 95 FE F7 B6 FD FF F7 B2 B9 06 9D 01 2A D8 F8 00 60 2F 68 40 F0 39 84 BE 42 3E BF 3D 0C 1F FA 87 F8 0D F1 80 09 80 F0 30 84 30 46 29 46 ?? ?? ?? ?? 30 46 8A 46 29 46 ?? ?? ?? ?? 4F EA 0A 43 08 FB 00 F2 83 46 9A 42 0A D9 DB 19 00 F1 FF 31 05 D2 9A 42 84 BF A0 F1 02 0B DB 19 00 D8 8B 46 9E 1A 29 46 30 46 ?? ?? ?? ?? 30 46 8A 46 29 46 ?? ?? ?? ?? 4F EA 0A 43 08 FB 00 F6 9E 42 09 D9 DB 19 00 F1 FF 32 04 D2 9E 42 84 BF 02 38 DB 19 00 D8 10 46 9E 1B 40 EA 0B 40 00 2C 31 D1 00 28 37 D0 DD F8 2C C0 B0 FA 80 F1 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__xpg_basename"
		size = 134
		refs = "000c strrchr 0044 .LC0"
	strings:
		$1 = { 10 B5 04 46 F0 B1 03 78 E3 B1 2F 21 ?? ?? ?? ?? 03 46 F0 B1 42 78 D2 B9 84 42 30 D2 10 F8 01 2C 2F 2A 05 D0 17 E0 10 F8 01 2C 03 46 2F 2A 12 D1 58 1E A0 42 F7 D1 1B 78 23 B3 01 30 43 78 00 2B FB D1 10 BD ?? ?2 0? 0? ?? ?2 0? 0? 10 BD 01 30 10 BD 20 46 10 BD 43 1E 00 22 9C 42 02 70 0E D2 10 F8 02 2C 18 46 2F 2A 04 D1 0A E0 10 F8 01 3C 2F 2B 03 D0 01 38 A0 42 F8 D1 10 BD 10 BD 18 46 FB E7 10 BD 10 BD }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__ppoll_chk"
		size = 22
		refs = "0012 __chk_fail 000e ppoll"
	strings:
		$1 = { 10 B5 02 9C B1 EB D4 0F 03 D8 BD E8 10 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "execl"
		size = 206
		refs = "005a realloc 0064 __environ 0072 __execve 0082 free 00c8 memcpy"
	strings:
		$1 = { 0E B4 2D E9 F0 4F AD F5 80 5D 82 B0 83 46 0D F5 81 55 0D F1 08 0A 0C 35 55 F8 04 3B CA F8 00 30 4A F8 04 5C 00 2B 36 D0 10 26 01 24 57 46 4F F4 80 68 00 E0 08 36 04 35 55 F8 04 3C 4F EA 84 09 01 95 47 F8 24 30 01 34 63 B1 A0 45 F2 D1 57 45 38 46 31 46 4F EA 48 08 2C D0 ?? ?? ?? ?? 18 B3 07 46 E7 E7 ?? ?2 0? 0? 58 46 ?? ?2 0? 0? 39 46 1A 68 ?? ?? ?? ?? 57 45 04 46 08 BF 00 46 03 D0 38 46 ?? ?? ?? ?? 20 46 0D F5 80 5D 02 B0 BD E8 F0 4F 03 B0 70 47 ?? ?2 0? 0? 51 46 ?? ?2 0? 0? 1A 68 ?? ?? ?? ?? EF E7 38 46 ?? ?? ?? ?? 4F F0 FF 30 E9 E7 31 46 00 20 ?? ?? ?? ?? 51 46 09 F1 04 02 07 46 00 28 F2 D0 ?? ?? ?? ?? B2 E7 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_rpc_dtablesize"
		size = 24
		refs = "0002 .LANCHOR0 000e __getdtablesize"
	strings:
		$1 = { 10 B5 ?? ?2 0? 0? ?? ?2 0? 0? 20 68 18 B9 ?? ?? ?? ?? 03 46 23 60 10 BD }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__mpn_mod_1"
		size = 1126
		refs = "0044 __aeabi_uidivmod 0052 __aeabi_uidiv"
	strings:
		$1 = { 2D E9 F0 4F 04 46 87 B0 0D 46 90 46 08 46 00 29 00 F0 A7 80 58 23 03 FB 01 F3 64 2B 40 F3 A4 80 B2 FA 82 F9 B9 F1 00 0F 00 F0 40 81 02 FA 09 F7 78 00 08 BF 4F F0 FF 30 34 D0 C7 F1 00 08 3E 0C 40 46 31 46 ?? ?? ?? ?? 40 46 1F FA 87 FA 8B 46 31 46 ?? ?? ?? ?? 4F EA 0B 43 80 46 0A FB 00 F0 98 42 0A D9 DB 19 08 F1 FF 32 05 D2 98 42 84 BF A8 F1 02 08 DB 19 00 D8 90 46 C0 EB 03 0B 31 46 58 46 ?? ?? ?? ?? 58 46 0B 46 31 46 00 93 ?? ?? ?? ?? 00 9B 19 04 0A FB 00 FA 8A 45 00 F2 C8 81 40 EA 08 40 05 F1 80 4B 01 2D 0B F1 FF 3B C9 F1 20 08 54 F8 2B 10 4F EA 8B 0B D8 BF 0C 46 21 FA 08 F6 32 DD AD 00 0B F1 04 0B C5 F1 04 0A A3 44 4F F0 00 0C CD F8 04 80 A6 FB 00 23 0B EB 0C 04 DD F8 04 80 01 FA 09 F5 54 F8 08 4C F2 18 AC F1 04 0C 21 46 24 FA 08 F3 1D 43 A2 FB 07 23 B5 EB 02 08 66 EB 03 02 46 46 4A B1 B8 EB 07 03 62 F1 00 02 1E 46 1A B1 DD 1B 62 F1 00 02 2E 46 BE 42 28 BF C7 EB 06 06 D4 45 D6 D1 A6 FB 00 01 04 FA 09 F4 72 18 A2 FB 07 23 A0 1A 66 EB 03 02 52 B1 B0 EB 07 08 62 F1 00 02 40 46 22 B1 B8 EB 07 03 62 F1 00 02 18 46 B8 42 28 BF C7 EB 00 00 20 FA 09 F0 07 B0 BD E8 F0 8F B2 FA 82 F2 02 92 00 2A 00 F0 0C 81 01 F1 80 43 C2 F1 20 02 01 3B 03 92 02 9A 01 29 54 F8 23 90 08 FA 02 F8 4F EA 83 02 03 9B D8 BF 4E 46 CD F8 04 80 D8 BF 4F EA 18 44 29 FA 03 FB D8 BF 1F FA 88 F8 4D DD 8D 00 04 32 C5 F1 04 05 05 95 01 9D A2 18 DA 46 04 92 2C 0C 1F FA 85 F8 00 25 04 9A 21 46 50 46 2A 44 04 3D 52 F8 08 6C ?? ?? ?? ?? 21 46 08 FB 00 F7 50 46 ?? ?? ?? ?? 02 9A 03 98 09 FA 02 F3 B1 46 26 FA 00 F2 42 EA 03 0B 4F EA 1B 43 43 EA 01 43 21 46 9F 42 05 D9 01 9A 9B 18 02 D2 9F 42 88 BF 9B 18 DF 1B 38 46 ?? ?? ?? ?? 21 46 08 FB 00 FA 38 46 ?? ?? ?? ?? 1F FA 8B F2 42 EA 01 41 8A 45 05 D9 01 9B C9 18 02 D2 8A 45 88 BF C9 18 05 9A CA EB 01 0A 95 42 BF D1 D3 46 21 46 58 46 ?? ?? ?? ?? 02 9B 21 46 9E 40 08 FB 00 F5 58 46 ?? ?? ?? ?? 33 0C 43 EA 01 41 8D 42 03 D9 01 9A 89 18 C0 F0 F6 80 4D 1B 21 46 28 46 B6 B2 ?? ?? ?? ?? 21 46 08 FB 00 F8 28 46 ?? ?? ?? ?? 46 EA 01 41 88 45 05 D9 01 9B C9 18 02 D2 88 45 88 BF C9 18 C8 EB 01 00 02 9D E8 40 07 B0 BD E8 F0 8F 50 00 08 BF 4F F0 FF 31 32 D0 57 42 16 0C 38 46 31 46 ?? ?? ?? ?? 38 46 1F FA 88 F9 8A 46 31 46 ?? ?? ?? ?? 4F EA 0A 43 07 46 09 FB 00 F0 98 42 0A D9 13 EB 08 03 07 F1 FF 32 04 D2 98 42 84 BF 02 3F 43 44 00 D8 17 46 C0 EB 03 0A 31 46 50 46 ?? ?? ?? ?? 50 46 8B 46 31 46 ?? ?? ?? ?? 4F EA 0B 41 09 FB 00 F9 89 45 00 F2 97 80 40 EA 07 41 05 F1 FF 39 54 F8 29 00 80 45 8C BF A5 F1 02 09 00 20 B9 F1 00 0F FF F6 16 AF 4F EA 89 0C 00 23 8C F0 03 0C 04 EB 89 09 1E 46 6F EA 0C 0C A0 FB 01 45 59 F8 06 40 04 3E 42 19 A2 FB 08 23 A5 1A 60 EB 03 02 28 46 52 B1 B5 EB 08 03 62 F1 00 02 18 46 22 B1 B3 EB 08 05 62 F1 00 02 28 46 40 45 28 BF C8 EB 00 00 66 45 E1 D1 07 B0 BD E8 F0 8F 4B 1E 54 F8 23 90 C8 45 8C BF 8B 1E DD F8 08 90 00 2B 43 DB 9A 00 04 EB 83 04 01 94 82 F0 03 04 4F EA 18 47 1F FA 88 FB 00 26 4D 46 E4 43 39 46 28 46 ?? ?? ?? ?? 01 9A 39 46 52 F8 06 A0 04 3E 0B FB 00 F9 28 46 ?? ?? ?? ?? 4F EA 1A 42 42 EA 01 42 39 46 91 45 05 D9 12 EB 08 02 02 D2 91 45 88 BF 42 44 C9 EB 02 05 28 46 ?? ?? ?? ?? 39 46 0B FB 00 F9 28 46 ?? ?? ?? ?? 1F FA 8A F3 43 EA 01 41 89 45 05 D9 11 EB 08 01 02 D2 89 45 88 BF 41 44 A6 42 C9 EB 01 05 C9 D1 A9 46 48 46 07 B0 BD E8 F0 8F C9 19 00 F1 FF 33 04 D2 8A 45 88 BF 02 38 3F F6 2F AE 18 46 2C E6 11 EB 08 01 00 F1 FF 33 04 D2 89 45 88 BF 02 38 3F F6 5F AF 18 46 5C E7 8D 42 88 BF 89 18 05 E7 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "fputc"
		size = 278
		refs = "00a6 __libc_do_syscall 00b0 __overflow 00b8 __lll_lock_wait_private 0112 _Unwind_Resume"
		altNames = "_IO_putc"
	strings:
		$1 = { 0B 68 70 B5 0C 46 19 04 06 46 1C D4 A0 6C 1D EE 70 5F A5 F5 98 65 82 68 AA 42 11 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 00 2A 3E D1 A2 6C 10 46 95 60 42 68 01 32 42 60 63 69 A2 69 93 42 3F BF 5A 1C F5 B2 62 61 1E 70 29 D2 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 01 DC 28 46 70 BD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? F0 E7 F1 B2 20 46 ?? ?? ?? ?? 05 46 CF E7 ?? ?? ?? ?? BD E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_nl_intern_locale_data"
		size = 700
		refs = "0026 .LANCHOR0 0046 malloc 00d6 free 00f2 .LC10 00f6 .LC1 00fa __PRETTY_FUNCTION__.11063 010c __assert_fail 0114 .LC9 0136 .LC8 0158 .LC7 017a .LC6 019c .LC5 01c0 .LC4 01e4 .LC3 0208 .LC2 022c .LC0 0254 .LC11 0294 .LC12 02b4 __libc_errno"
	strings:
		$1 = { 07 2A 2D E9 F0 47 90 46 04 46 0E 46 40 F2 31 81 03 28 0A 68 22 D0 4F F4 E4 63 C2 F2 09 03 B8 B9 93 42 40 F0 26 81 ?? ?2 0? 0? 77 68 ?? ?2 0? 0? 55 F8 24 30 9F 42 C0 F0 1C 81 B8 1C 80 00 80 45 40 F2 17 81 1C 30 ?? ?? ?? ?? 60 B9 BD E8 F0 87 41 F2 15 13 C2 F2 03 03 43 40 E1 E7 41 F2 17 03 C2 F2 05 03 DC E7 00 23 46 60 C0 F8 08 80 07 62 43 61 03 61 83 61 C3 61 00 2F E7 D0 B2 68 90 45 21 BF 05 EB 84 05 B1 46 84 46 04 F1 FF 3A 22 D3 BA F1 0B 0F 00 F2 D9 80 DF E8 0A F0 C5 B3 A1 8F 7E D7 6D 5C 4B 3A 29 06 0F 2B 00 F2 D3 80 69 6B 51 F8 23 10 05 29 00 F0 E6 80 32 44 CC F8 24 20 01 33 BB 42 C2 D0 D9 F8 0C 20 0C F1 04 0C 09 F1 04 09 90 45 DC D2 ?? ?? ?? ?? 76 4B 1D EE 70 2F 16 21 7B 44 1B 68 00 20 D1 50 BD E8 F0 87 01 2B DD D9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 89 22 ?? ?? ?? ?? 04 2B CC D9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 88 22 ?? ?? ?? ?? 0C 2B BB D9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 87 22 ?? ?? ?? ?? 06 2B AA D9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 86 22 ?? ?? ?? ?? 02 2B 99 D9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 85 22 ?? ?? ?? ?? 04 2B 88 D9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 84 22 ?? ?? ?? ?? 2D 2B 7F F6 77 AF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 83 22 ?? ?? ?? ?? 12 2B 7F F6 65 AF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 82 22 ?? ?? ?? ?? 6E 2B 7F F6 53 AF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 81 22 ?? ?? ?? ?? 05 2B 7F F6 41 AF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 80 22 ?? ?? ?? ?? 1C BB 46 2B 3F F6 34 AF 2C E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8A 22 ?? ?? ?? ?? 11 4B 1D EE 70 2F 16 21 00 20 7B 44 1B 68 D1 50 BD E8 F0 87 91 07 7F F4 25 AF B2 58 CC F8 24 20 15 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8C 22 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_1_0 {
	meta:
		name = "_nl_load_locale"
		size = 572
		refs = "001e __libc_do_syscall 0036 __fxstat64 006a __mmap 008a _nl_intern_locale_data 00bc __munmap 00d8 malloc 014a strlen 014e _nl_category_name_sizes 016e mempcpy 0172 .LC13 0180 _nl_category_name_idxs 0188 _nl_category_names 0198 memcpy 01f2 free 0220 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 9F B0 05 46 8A 46 01 22 00 23 42 60 83 60 02 AF 4F F4 00 21 4F F0 05 0C 00 68 ?? ?? ?? ?? 10 F5 80 5F 04 46 3B D8 00 28 35 DB 03 20 07 F1 08 02 21 46 ?? ?? ?? ?? 00 28 C0 F2 C5 80 BB 69 03 F4 70 43 B3 F5 80 4F 77 D0 74 4B 1D EE 70 9F 4F F0 00 08 B9 6B 7B 44 1B 68 40 46 01 22 59 F8 03 B0 02 23 8D E8 10 01 ?? ?? ?? ?? 43 1C 06 46 26 D0 4F F0 01 08 20 46 4F F0 06 0C ?? ?? ?? ?? 56 B1 50 46 31 46 BA 6B ?? ?? ?? ?? 80 B1 C0 F8 0C 80 00 22 02 60 A8 60 74 37 BD 46 BD E8 F0 8F 60 4B 1D EE 70 2F 44 42 7B 44 1B 68 D4 50 F3 E7 B8 F1 01 0F F0 D1 30 46 B9 6B ?? ?? ?? ?? EB E7 59 4B 7B 44 1B 68 59 F8 03 30 26 2B 40 F0 8C 80 D7 F8 38 80 40 46 ?? ?? ?? ?? 06 46 00 28 79 D0 B8 F1 00 03 21 DD 20 46 31 46 1A 46 4F F0 03 0C ?? ?? ?? ?? 10 F5 80 5F 01 46 00 F2 85 80 00 28 C8 BF B0 46 08 DC 71 E0 ?? ?? ?? ?? 10 F5 80 5F 01 46 79 D8 00 28 69 DD 5B 1A 88 44 00 2B 20 46 1A 46 4F F0 03 0C 41 46 EE DC 3F 4B 4F F0 00 08 7B 44 1B 68 49 F8 03 B0 9D E7 20 46 4F F0 06 0C ?? ?? ?? ?? 2C 68 20 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 21 46 13 F8 0A 60 33 18 02 46 14 33 23 F0 07 03 AD EB 03 0D 02 AC 20 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 72 1C 11 F8 0A 10 19 44 ?? ?? ?? ?? 20 46 4F F4 00 21 4F F0 05 0C ?? ?? ?? ?? 10 F5 80 5F 04 46 13 D8 00 28 FF F6 71 AF 07 F1 08 02 03 20 21 46 ?? ?? ?? ?? 00 28 BF F6 41 AF 20 46 4F F0 06 0C ?? ?? ?? ?? 61 E7 80 46 4E E7 15 4B 1D EE 70 2F 44 42 7B 44 1B 68 D4 50 57 E7 46 46 42 E7 30 46 79 60 ?? ?? ?? ?? 79 68 00 29 E6 D1 0D 4B 16 22 7B 44 1B 68 49 F8 03 20 DF E7 0B 4B 30 46 49 42 7B 44 1B 68 49 F8 03 10 ?? ?? ?? ?? D5 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_2_0 {
	meta:
		name = "_nl_unload_locale"
		size = 60
		refs = "0018 free 002a __munmap"
	strings:
		$1 = { 03 69 10 B5 04 46 03 B1 98 47 E3 68 8B B1 01 2B 09 D0 02 2B 02 D0 20 68 ?? ?? ?? ?? 20 46 BD E8 10 40 ?? ?? ?? ?? 60 68 A1 68 ?? ?? ?? ?? E3 68 EF E7 60 68 ?? ?? ?? ?? E3 68 EA E7 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__sysv_signal"
		size = 96
		refs = "0024 memset 0034 __sigaction 005c __libc_errno"
	strings:
		$1 = { 0B 46 41 1E 10 B5 04 46 B3 F1 FF 30 C6 B0 42 42 42 41 3F 29 94 BF 11 46 42 F0 01 01 99 B9 01 A8 80 22 00 93 ?? ?? ?? ?? 20 46 69 46 23 AA 4F F0 60 43 21 93 ?? ?? ?? ?? 00 28 B4 BF 4F F0 FF 30 23 98 46 B0 10 BD 05 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 46 B0 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "erand48"
		size = 28
		refs = "0002 __libc_drand48_data 000e __erand48_r"
	strings:
		$1 = { 00 B5 ?? ?2 0? 0? 83 B0 ?? ?2 0? 0? 6A 46 ?? ?? ?? ?? DD E9 00 01 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_IO_obstack_xsputn"
		size = 94
		refs = "002c memcpy 004a _obstack_newchunk 0052 mempcpy"
	strings:
		$1 = { 2D E9 F0 41 05 46 40 69 16 46 AB 69 88 46 87 18 D5 F8 A0 40 BB 42 1C D2 E1 68 C0 1A 22 69 08 44 E0 60 83 19 9A 42 0E D3 41 46 32 46 ?? ?? ?? ?? A2 68 23 69 30 46 E1 68 2A 61 AB 61 8A 19 6A 61 E3 60 BD E8 F0 81 20 46 31 46 ?? ?? ?? ?? E0 68 EA E7 ?? ?? ?? ?? 68 61 30 46 BD E8 F0 81 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "_IO_obstack_overflow"
		size = 88
		refs = "001c _obstack_newchunk 003a .LC0 003e .LC1 0042 __PRETTY_FUNCTION__.12554 0054 __assert_fail"
	strings:
		$1 = { 4B 1C 70 B5 05 46 0E 46 D0 F8 A0 40 15 D0 E3 68 21 69 5A 1C 8A 42 05 D9 20 46 01 21 ?? ?? ?? ?? E3 68 5A 1C 04 F1 08 01 E2 60 1E 70 30 46 0E C9 29 61 6A 61 AB 61 E3 60 70 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2F 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "_IO_obstack_vprintf"
		size = 242
		refs = "001e _IO_no_init 0026 .LANCHOR0 0044 _IO_str_init_static_internal 006c _IO_vfprintf 008c _obstack_newchunk 0098 .LC2 009c .LC1 00a0 __PRETTY_FUNCTION__.12589 00b2 __assert_fail 00b6 .LC4 00d4 .LC3"
	strings:
		$1 = { 2D E9 F0 43 AD B0 04 46 00 25 2B 46 00 95 88 46 17 46 4F F4 00 41 4F F0 FF 32 02 A8 14 95 ?? ?? ?? ?? 26 69 E3 68 ?? ?2 0? 0? A1 68 ?? ?2 0? 0? F5 1A 28 92 76 1A 24 D1 3F 2D 25 DD A1 68 A9 46 2A 46 02 A8 ?? ?? ?? ?? 06 9B 08 9A D2 1A AA 42 40 D1 E2 68 A0 68 07 99 10 1A 03 44 99 42 2A D1 4A 44 41 46 E2 60 02 A8 3A 46 2A 94 ?? ?? ?? ?? 07 99 08 9A E3 68 8A 1A 13 44 E3 60 2D B0 BD E8 F0 83 A9 46 35 46 DB E7 20 46 40 21 ?? ?? ?? ?? E3 68 25 69 ED 1A D1 D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 97 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A2 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 9F 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "skip"
		size = 176
		refs = "0066 .LANCHOR0"
	strings:
		$1 = { 30 B4 03 78 00 2B 51 D0 02 46 00 21 0F E0 05 78 23 2B 02 F1 01 04 15 70 3C D0 A3 F1 09 02 20 2B 18 BF 01 2A 1F D9 22 46 43 78 01 30 7B B1 22 2B 08 BF 81 F0 01 01 F7 D0 01 29 E8 D1 5C 2B 0C D0 03 78 13 70 01 30 03 78 01 32 00 2B EF D1 14 46 00 23 04 F8 01 3C 30 BC 70 47 43 78 22 2B 08 BF 01 30 ED D1 ED E7 ?? ?2 0? 0? 02 46 ?? ?2 0? 0? 00 20 02 F8 01 0B 0B 70 10 46 12 F8 01 3B A3 F1 09 01 01 29 F8 D9 20 2B F6 D0 00 23 04 F8 01 3C 30 BC 70 47 ?? ?2 0? 0? 00 21 ?? ?2 0? 0? 01 70 13 70 00 23 04 F8 01 3C 30 BC 70 47 04 46 CF E7 }
	condition:
		$1
}

rule file_203_1_0 {
	meta:
		name = "setttyent"
		size = 62
		refs = "0002 .LANCHOR0 000e rewind 0016 .LC0 001a .LC1 0026 _IO_new_fopen"
	strings:
		$1 = { 10 B5 ?? ?2 0? 0? ?? ?2 0? 0? 60 68 18 B1 ?? ?? ?? ?? 01 20 10 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 03 46 60 60 28 B1 02 68 01 20 42 F4 00 42 1A 60 10 BD 10 BD }
	condition:
		$1
}

rule file_203_2_0 {
	meta:
		name = "getttyent"
		size = 556
		refs = "0004 .LANCHOR0 0024 fgets_unlocked 002e strchr 009a __uflow 0106 .LC2 0112 strncmp 011a .LC3 0148 .LC4 0176 .LC5 01f4 setttyent 0218 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F8 43 ?? ?2 0? 0? ?? ?2 0? 0? 72 68 00 2A 00 F0 F0 80 ?? ?2 0? 0? DF F8 04 82 ?? ?2 0? 0? 7B 48 64 21 ?? ?? ?? ?? 28 B3 79 48 0A 21 ?? ?? ?? ?? 18 B3 43 46 1D EE 70 5F 7B 44 1B 68 3A 7A EC 58 34 F8 12 30 9B 04 58 BF DF F8 C4 E1 07 D5 70 4B 9E 46 13 F8 01 2B 34 F8 12 10 88 04 F8 D4 23 2A 18 BF 00 2A 1C D1 72 68 64 21 68 48 ?? ?? ?? ?? 00 28 D9 D1 00 20 BD E8 F8 83 7A 68 03 E0 0A 28 CD D0 01 30 CB D0 53 68 91 68 58 1C 8B 42 3C BF 50 60 18 78 F3 D3 10 46 ?? ?? ?? ?? 72 68 EE E7 70 46 00 23 C6 F8 6C E0 ?? ?2 0? 0? 33 70 FF F7 2E FF ?? ?2 0? 0? 30 67 04 46 03 78 00 2B 40 F0 90 80 7B 67 3B 67 00 23 B3 67 F3 67 27 78 00 2F 7D D0 DF F8 4C 91 DF F8 4C 81 13 E0 4E 4B E2 78 7B 44 1B 68 EB 58 33 F8 12 30 99 04 14 D5 B3 6F 23 F0 01 03 B3 67 20 46 FF F7 09 FF 07 78 04 46 00 2F 64 D0 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 03 22 ?? ?? ?? ?? 00 28 E1 D0 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 02 22 ?? ?? ?? ?? 68 B9 43 46 A2 78 7B 44 1B 68 EB 58 33 F8 12 30 9A 04 04 D5 B3 6F 43 F0 01 03 B3 67 D7 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 06 22 ?? ?? ?? ?? 68 B9 4B 46 A2 79 7B 44 1B 68 EB 58 33 F8 12 30 9B 04 04 D5 B3 6F 43 F0 02 03 B3 67 C0 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 06 22 ?? ?? ?? ?? 48 B9 A1 79 3D 29 06 D1 20 46 ?? ?? ?? ?? 00 B1 01 30 F0 67 AD E7 33 78 23 2B 19 D0 23 2F 17 D0 C6 F8 80 40 ?? ?2 0? 0? 22 78 ?? ?2 0? 0? 0A B9 C3 F8 80 20 20 46 0A 21 ?? ?? ?? ?? 03 46 E8 B1 00 22 14 48 1A 70 BD E8 F8 83 33 78 23 2B E7 D1 14 F8 01 3F 20 2B FB D0 09 2B F9 D0 E0 E7 FF F7 94 FE 78 67 04 46 03 78 5B B9 7B 67 69 E7 ?? ?? ?? ?? 00 28 3F F4 3C AF 72 68 08 E7 06 48 BD E8 F8 83 FF F7 82 FE 04 46 5B E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_203_3_0 {
	meta:
		name = "endttyent"
		size = 34
		refs = "0002 .LANCHOR0 000e _IO_new_fclose"
	strings:
		$1 = { 10 B5 ?? ?2 0? 0? ?? ?2 0? 0? 60 68 38 B1 ?? ?? ?? ?? 00 23 63 60 01 30 18 BF 01 20 10 BD 01 20 10 BD }
	condition:
		$1
}

rule file_203_4_0 {
	meta:
		name = "getttynam"
		size = 38
		refs = "0004 setttyent 000c strcmp 0012 getttyent 001e endttyent"
	strings:
		$1 = { 38 B5 05 46 ?? ?? ?? ?? 03 E0 21 68 ?? ?? ?? ?? 28 B1 ?? ?? ?? ?? 04 46 28 46 00 2C F5 D1 ?? ?? ?? ?? 20 46 38 BD }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "__strchrnul"
		size = 162
	strings:
		$1 = { 2D E9 F0 01 84 07 C9 B2 0E D0 03 78 8B 42 3F D0 00 2B 3D D0 43 1C 04 E0 13 F8 01 2B 8A 42 37 D0 B2 B3 9A 07 18 46 F7 D1 41 EA 01 27 02 1F 47 EA 07 47 0D E0 63 B3 53 78 8B 42 2C D0 5B B3 93 78 8B 42 2A D0 4B B3 D3 78 8B 42 28 D0 3B B3 30 46 52 F8 04 4F 4F F4 80 73 C8 F2 01 13 06 1D 87 EA 04 05 A4 F1 01 3C A5 F1 01 38 0C F1 00 4C 08 F1 00 48 E4 43 85 EA 08 05 84 EA 0C 04 64 EA 05 05 44 1C 2B 40 00 2B E2 D0 16 F8 04 3C 8B 42 D1 D1 BD E8 F0 01 70 47 20 46 FA E7 02 30 F8 E7 03 30 F6 E7 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__waitid"
		size = 136
		refs = "0004 __libc_multiple_threads 001c __libc_do_syscall 002e __libc_enable_asynccancel 0050 __libc_disable_asynccancel 0080 __libc_errno"
	strings:
		$1 = { 2D E9 F8 43 ?? ?2 0? 0? ?? ?2 0? 0? 80 46 0F 46 16 46 24 68 1D 46 54 B9 4F F4 8C 7C ?? ?? ?? ?? 10 F5 80 5F 17 D8 04 46 20 46 BD E8 F8 83 ?? ?? ?? ?? 00 24 39 46 32 46 2B 46 4F F4 8C 7C 81 46 40 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0D D8 48 46 ?? ?? ?? ?? E8 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 DD E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E7 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__snprintf"
		size = 30
		refs = "0010 _IO_vsnprintf"
	strings:
		$1 = { 0C B4 10 B5 82 B0 04 AC 54 F8 04 2B 23 46 01 94 ?? ?? ?? ?? 02 B0 BD E8 10 40 02 B0 70 47 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__asprintf_chk"
		size = 30
		refs = "0010 __vasprintf_chk"
	strings:
		$1 = { 0C B4 10 B5 82 B0 04 AC 54 F8 04 2B 23 46 01 94 ?? ?? ?? ?? 02 B0 BD E8 10 40 02 B0 70 47 }
	condition:
		$1
}

rule file_1075_0_0 {
	meta:
		name = "__dprintf_chk"
		size = 30
		refs = "0010 __vdprintf_chk"
	strings:
		$1 = { 0C B4 10 B5 82 B0 04 AC 54 F8 04 2B 23 46 01 94 ?? ?? ?? ?? 02 B0 BD E8 10 40 02 B0 70 47 }
	condition:
		$1
}

rule file_1397_1_0 {
	meta:
		name = "__obstack_printf_chk"
		size = 30
		refs = "0010 __obstack_vprintf_chk"
	strings:
		$1 = { 0C B4 10 B5 82 B0 04 AC 54 F8 04 2B 23 46 01 94 ?? ?? ?? ?? 02 B0 BD E8 10 40 02 B0 70 47 }
	condition:
		$1
}

rule file_1434_0_0 {
	meta:
		name = "__swprintf"
		size = 30
		refs = "0010 __vswprintf"
	strings:
		$1 = { 0C B4 10 B5 82 B0 04 AC 54 F8 04 2B 23 46 01 94 ?? ?? ?? ?? 02 B0 BD E8 10 40 02 B0 70 47 }
	condition:
		$1
}

rule file_896_5_0 {
	meta:
		name = "__syslog_chk"
		size = 30
		refs = "0010 __vsyslog_chk"
	strings:
		$1 = { 0C B4 10 B5 82 B0 04 AC 54 F8 04 2B 23 46 01 94 ?? ?? ?? ?? 02 B0 BD E8 10 40 02 B0 70 47 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "wcwidth"
		size = 96
		refs = "005c _nl_current_LC_CTYPE"
	strings:
		$1 = { 16 4B 1D EE 70 2F 10 B4 7B 44 1B 68 D3 58 1B 68 5B 6D 1A 68 59 68 20 FA 02 F2 8A 42 03 D2 05 32 53 F8 22 20 22 B9 4F F0 FF 30 5D F8 04 4B 70 47 9C 68 D9 68 20 FA 04 F4 21 40 02 EB 81 02 9A 58 00 2A F0 D0 19 69 13 44 5D F8 04 4B 08 40 18 5C FF 28 08 BF 4F F0 FF 30 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "__fcvt"
		size = 120
		refs = "0004 .LANCHOR1 0030 __fcvt_r 003e .LANCHOR0 006a malloc"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? ?? ?2 0? 0? 85 B0 04 46 0D 46 37 68 91 46 98 46 87 B1 3B 46 0C 9F 20 46 01 93 29 46 4A 46 43 46 00 97 4F F4 A4 74 02 94 ?? ?? ?? ?? 30 68 05 B0 BD E8 F0 83 0C 9F ?? ?2 0? 0? ?? ?2 0? 0? CD F8 04 E0 00 97 14 27 02 97 ?? ?? ?? ?? 01 30 06 D0 ?? ?2 0? 0? ?? ?2 0? 0? 05 B0 BD E8 F0 83 4F F4 A4 70 ?? ?? ?? ?? 30 60 00 28 F1 D0 03 46 D1 E7 }
	condition:
		$1
}

rule file_210_1_0 {
	meta:
		name = "__ecvt"
		size = 32
		refs = "0010 __ecvt_r"
	strings:
		$1 = { 70 B5 84 B0 05 4C 14 26 08 9D 02 96 01 94 00 95 ?? ?? ?? ?? 20 46 04 B0 70 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_2_0 {
	meta:
		name = "__gcvt"
		size = 36
		refs = "0010 .LC0 001a sprintf"
		altNames = "__qgcvt"
	strings:
		$1 = { 10 B5 82 B0 11 2A A8 BF 11 22 1C 46 CD E9 00 01 ?? ?2 0? 0? 18 46 ?? ?2 0? 0? ?? ?? ?? ?? 20 46 02 B0 10 BD }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "ualarm"
		size = 56
		refs = "0014 __setitimer"
	strings:
		$1 = { 00 B5 89 B0 00 23 04 AA 03 90 18 46 01 91 69 46 02 93 00 93 ?? ?? ?? ?? 00 28 A9 BF 44 F2 40 23 4F F0 FF 30 06 98 C0 F2 0F 03 A4 BF 07 9A 03 FB 00 20 09 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "svcraw_freeargs"
		size = 34
		refs = "0006 __rpc_thread_variables"
	strings:
		$1 = { 38 B5 0C 46 15 46 ?? ?? ?? ?? D0 F8 B8 00 38 B1 00 F5 0E 53 02 22 29 46 03 F1 14 00 5A 61 A0 47 38 BD }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "svcraw_getargs"
		size = 28
		refs = "0006 __rpc_thread_variables"
	strings:
		$1 = { 38 B5 0C 46 15 46 ?? ?? ?? ?? D0 F8 B8 00 20 B1 00 F5 0E 50 29 46 14 30 A0 47 38 BD }
	condition:
		$1
}

rule file_212_4_0 {
	meta:
		name = "svcraw_reply"
		size = 62
		refs = "0004 __rpc_thread_variables 0028 xdr_replymsg"
	strings:
		$1 = { 38 B5 0D 46 ?? ?? ?? ?? D0 F8 B8 30 7B B1 03 F5 0E 53 00 22 03 F1 14 04 11 46 5A 61 20 46 9B 69 5B 69 98 47 20 46 29 46 ?? ?? ?? ?? 08 B9 00 20 38 BD 63 68 20 46 1B 69 98 47 01 20 38 BD }
	condition:
		$1
}

rule file_212_5_0 {
	meta:
		name = "svcraw_recv"
		size = 52
		refs = "0004 __rpc_thread_variables 0028 xdr_callmsg"
	strings:
		$1 = { 38 B5 0D 46 ?? ?? ?? ?? D0 F8 B8 00 88 B1 00 F5 0E 50 01 23 00 F1 14 04 00 21 43 61 20 46 63 68 5B 69 98 47 20 46 29 46 ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_212_6_0 {
	meta:
		name = "svcraw_create"
		size = 84
		refs = "0002 __rpc_thread_variables 0018 .LANCHOR0 003a xdrmem_create 0048 calloc"
	strings:
		$1 = { E0 B5 ?? ?? ?? ?? D0 F8 B8 10 D1 B1 01 F5 09 53 01 F5 0A 57 01 F5 0E 50 ?? ?2 0? 0? 00 25 03 F1 20 06 1D 62 ?? ?2 0? 0? 9D 84 9A 62 00 F1 2C 02 02 23 7A 60 14 30 42 F2 60 22 ?? ?? ?? ?? 30 46 E0 BD 42 F2 3C 51 01 20 ?? ?? ?? ?? 01 46 00 28 DC D1 E0 BD }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "raise"
		size = 84
		refs = "0016 __libc_do_syscall 0050 __libc_errno"
	strings:
		$1 = { 10 B5 1D EE 70 4F A4 F5 98 63 02 46 99 6E D8 6E 69 B9 4F F0 E0 0C ?? ?? ?? ?? 01 46 98 66 4F F4 86 7C ?? ?? ?? ?? 10 F5 80 5F 07 D8 10 BD 00 28 F5 DC 20 F0 00 43 4B B1 40 42 F0 E7 04 4B 42 42 4F F0 FF 30 7B 44 1B 68 E2 50 EF E7 08 46 E6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "plural_eval"
		size = 246
		refs = "00e0 __aeabi_uidivmod 00ea __aeabi_uidiv"
	strings:
		$1 = { F8 B5 04 46 0D 46 23 68 03 2B 46 D8 DF E8 03 F0 22 19 0D 02 A0 68 29 46 FF F7 F2 FF 00 28 14 BF 03 20 04 20 54 F8 20 40 ED E7 A0 68 29 46 FF F7 E7 FF 66 68 0F 2E 07 46 14 D0 0E 2E 1D D1 A0 B9 F8 BD A0 68 29 46 FF F7 DB FF D0 F1 01 00 38 BF 00 20 F8 BD 63 68 1B B1 01 2B 1E D1 A0 68 F8 BD 28 46 F8 BD 08 B1 01 20 F8 BD E0 68 29 46 FF F7 C7 FF 00 30 18 BF 01 20 F8 BD 29 46 E0 68 FF F7 BF FF 03 3E 01 46 0A 2E 07 D8 DF E8 06 F0 31 2D 28 26 24 1F 1A 15 10 0C 08 00 00 20 F8 BD 38 1A 18 BF 01 20 F8 BD 3B 1A 58 42 58 41 F8 BD 87 42 34 BF 00 20 01 20 F8 BD 87 42 8C BF 00 20 01 20 F8 BD 87 42 94 BF 00 20 01 20 F8 BD 87 42 2C BF 00 20 01 20 F8 BD 38 1A F8 BD 38 44 F8 BD 38 46 ?? ?? ?? ?? 08 46 F8 BD 38 46 ?? ?? ?? ?? F8 BD 07 FB 00 F0 F8 BD }
	condition:
		$1
}

rule file_215_1_0 {
	meta:
		name = "transcmp"
		size = 62
		refs = "0014 strcmp"
	strings:
		$1 = { 38 B5 05 46 03 69 0C 46 1C 30 B3 B1 23 69 04 F1 1C 01 83 B1 ?? ?? ?? ?? 60 B9 28 68 21 68 ?? ?? ?? ?? 38 B9 A8 68 A1 68 ?? ?? ?? ?? 10 B9 68 68 63 68 C0 1A 38 BD E1 69 EC E7 E8 69 E6 E7 }
	condition:
		$1
}

rule file_215_2_0 {
	meta:
		name = "plural_lookup.isra.1"
		size = 58
		refs = "001c __rawmemchr"
	strings:
		$1 = { F8 B5 04 46 00 6E 17 46 D6 18 FF F7 5D FF 65 6E 3C 46 A8 42 34 BF 05 46 00 25 05 E0 ?? ?? ?? ?? 01 3D 44 1C B4 42 05 D2 20 46 00 21 00 2D F5 D1 20 46 F8 BD 3C 46 20 46 F8 BD }
	condition:
		$1
}

rule file_215_3_0 {
	meta:
		name = "_nl_find_msg"
		size = 2044
		refs = "0030 strlen 0038 __hash_string 0042 __aeabi_uidivmod 00a6 strcmp 0114 __pthread_rwlock_rdlock 0158 __pthread_rwlock_unlock 0246 _nl_load_domain 0254 .LANCHOR1 0282 __pthread_rwlock_wrlock 02da .LC0 02e2 getenv 030e realloc 0320 __strdup 0332 .LC1 0354 _nl_find_msg 0364 .LC2 036c strstr 03b6 mempcpy 03f4 _nl_C_locobj 047e __gconv_open 0494 _nl_current_LC_CTYPE 0554 __gconv 0572 malloc 05a0 free 061c __libc_do_syscall 069e memcpy 06d8 .LC3 073e __lll_lock_wait_private 079e calloc"
	strings:
		$1 = { 2D E9 F0 4F 8F B0 02 AF 91 46 FB 60 43 68 38 61 00 2B B9 60 40 F3 17 81 3C 69 A6 68 00 2E 00 F0 EC 80 33 6B D6 F8 14 80 00 2B 00 F0 C3 80 48 46 ?? ?? ?? ?? 82 46 48 46 ?? ?? ?? ?? F4 6A 21 46 83 46 ?? ?? ?? ?? 58 46 0D 46 A1 1E ?? ?? ?? ?? 72 6B FA 61 32 6B 13 46 4A 46 99 46 01 31 B9 61 C1 EB 04 0B 0C 1B 7C 61 FB 69 59 F8 25 40 03 B1 24 BA 00 2C 00 F0 C1 80 01 3C A0 45 40 F2 8D 80 B0 69 F3 68 50 F8 34 10 03 B1 09 BA 51 45 1A D3 31 68 00 EB C4 00 00 2B 00 F0 8A 80 43 68 1B BA 19 44 10 46 7A 60 ?? ?? ?? ?? 7A 68 D0 F1 01 00 38 BF 00 20 03 46 50 B9 5D 45 2B BF 7C 69 BB 69 2D 19 ED 18 D0 E7 00 20 03 46 00 28 F4 D0 44 45 80 F0 98 80 F3 68 32 68 00 2B 00 F0 A9 80 F3 69 03 EB C4 00 53 F8 34 10 43 68 91 FA 81 FA 93 FA 83 FB 0A F1 01 00 93 44 FA 68 F8 61 00 2A 00 F0 8F 80 BB 68 00 2B 00 F0 A5 80 9B 68 00 2B 00 F0 A1 80 99 46 ?? ?2 0? 0? ?? ?2 0? 0? 1B B1 06 F1 40 00 ?? ?? ?? ?? D6 F8 3C A0 BA F1 00 0F 12 D0 0A EB 4A 02 B1 6B 55 46 01 EB 82 02 00 E0 5D B1 52 F8 0C 0C 49 46 A2 F1 0C 0A ?? ?? ?? ?? 01 3D 52 46 00 28 F3 D1 55 46 ?? ?2 0? 0? ?? ?2 0? 0? B8 61 18 B1 06 F1 40 00 ?? ?? ?? ?? 00 2D 00 F0 88 80 6B 68 01 33 53 D0 AB 68 00 2B 00 F0 CE 82 5A 1C 00 F0 28 82 53 F8 24 30 00 2B 00 F0 84 81 1E 68 03 F1 04 0B FE 61 42 E0 73 6A C8 EB 04 01 03 EB C1 00 53 F8 31 30 9A 45 8C D2 41 68 78 E7 43 68 75 E7 9A 46 C7 F8 18 80 B3 46 C7 F8 1C 90 02 E0 43 D0 04 F1 01 0A D0 45 16 D9 DB F8 00 60 DB F8 0C 50 DB F8 18 90 08 EB 0A 04 64 08 09 EB C4 03 59 68 05 B1 09 BA F8 69 31 44 ?? ?? ?? ?? 00 28 E6 DA 54 45 A0 46 EE D8 00 20 34 37 BD 46 BD E8 F0 8F C8 EB 04 02 B3 6A 03 EB C2 01 53 F8 32 30 D1 F8 04 B0 FB 61 FA 68 00 2A 7F F4 71 AF FC 69 58 46 BE 6D 34 37 34 60 BD 46 BD E8 F0 8F F3 69 03 EB C4 00 53 F8 34 10 43 68 01 31 F9 61 02 EB 03 0B E8 E7 ?? ?? ?? ?? E5 E6 5E 46 D7 F8 18 80 3C E7 ?? ?2 0? 0? ?? ?2 0? 0? D9 F8 08 30 00 2B 3A D0 D9 F8 0C 30 00 2B 7F F4 52 AF 89 4B 1D EE 70 2F 7B 44 1B 68 D3 58 1B 68 D3 F8 5C 90 48 E7 ?? ?2 0? 0? ?? ?2 0? 0? 1B B1 06 F1 40 00 ?? ?? ?? ?? F2 6B 7A 61 82 B3 B2 6B FA 60 7A 69 F8 68 15 46 02 EB 42 03 00 EB 83 03 00 E0 3D B3 53 F8 0C 0C 49 46 A3 F1 0C 0A ?? ?? ?? ?? 01 3D 53 46 00 28 F3 D1 55 46 B8 69 00 28 3F F4 51 AF 06 F1 40 00 ?? ?? ?? ?? 4B E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 18 B1 03 78 00 2B 40 F0 CB 81 D9 F8 0C 30 01 22 C9 F8 08 20 B5 E7 B3 6B FB 60 7A 69 F8 68 55 1C 05 EB 45 05 AD 00 29 46 ?? ?? ?? ?? 03 46 00 28 00 F0 E9 81 B0 63 48 46 7B 60 ?? ?? ?? ?? 7B 68 82 46 00 28 00 F0 DF 81 A5 F1 0C 01 ?? ?2 0? 0? 5D 18 ?? ?2 0? 0? 43 F8 01 A0 07 F1 2C 0E 4F F0 FF 33 38 69 6B 60 00 23 B9 68 CD F8 00 E0 ?? ?? ?? ?? 42 1C 00 F0 3C 81 00 28 00 F0 92 80 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 00 F0 89 80 03 7A 00 F1 08 01 13 F0 DF 02 10 D0 09 3B 00 22 01 2B 05 D8 0B E0 20 2B 09 D0 BE F1 01 0F 06 D9 01 32 83 18 1B 7A A3 F1 09 0E 00 2B F3 D1 02 F1 0F 03 23 F0 07 03 AD EB 03 0D 0D F1 08 09 48 46 ?? ?? ?? ?? 4F F0 00 0E 53 46 80 F8 00 E0 03 E0 2F 2A 08 BF 0E F1 01 0E 19 46 13 F8 01 2B 00 2A F6 D1 CA EB 01 02 9A F8 00 30 19 32 22 F0 07 02 AD EB 02 0D 02 A8 78 61 00 2B 00 F0 6E 81 ?? ?2 0? 0? 52 46 ?? ?2 0? 0? C9 6B 51 F8 23 30 00 F8 01 3B 12 F8 01 3F 00 2B F7 D1 BE F1 01 0F 40 F2 49 81 00 22 4B 46 02 70 02 E0 2F 29 08 BF 01 32 18 46 13 F8 01 1B 00 29 F7 D1 C9 EB 00 01 99 F8 00 30 11 31 21 F0 07 01 AD EB 01 0D 0D F1 08 0C 00 2B 00 F0 44 81 ?? ?2 0? 0? E6 46 ?? ?2 0? 0? C9 6B 51 F8 23 30 0E F8 01 3B 19 F8 01 3F 00 2B F7 D1 01 2A 40 F2 25 81 61 46 78 69 4F F0 00 0C 2A 1D 01 23 8E F8 00 C0 ?? ?? ?? ?? 00 28 40 F0 3B 81 F3 6B 00 22 AA 60 01 33 F3 63 19 E7 ?? ?? ?? ?? BE 4E 01 22 7E 61 BF F3 5F 8F 56 E8 00 3F 00 2B 03 D1 46 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 99 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 26 C7 F8 24 B0 ?? ?2 0? 0? D9 F8 18 30 D9 F8 14 20 03 2B 3C 61 02 F1 04 02 C7 F8 18 B0 BA 62 D7 F8 1C A0 24 D8 00 2E 3B D0 01 36 D9 F8 04 B0 C6 EB 06 23 58 46 1C 01 C9 F8 18 40 21 46 ?? ?? ?? ?? 00 28 43 D0 ?? ?2 0? 0? 23 1F ?? ?2 0? 0? 48 60 03 2B ?? ?2 0? 0? 00 F1 04 02 C9 F8 18 30 00 F1 08 00 C9 F8 14 20 B8 62 ?? ?2 0? 0? DA D9 BC 6A 04 3B 7A 6A 07 F1 24 01 68 68 23 44 52 44 00 93 07 F1 2C 03 01 93 07 F1 28 03 ?? ?? ?? ?? 30 F0 04 03 62 D0 05 28 3C D1 BC 69 7C 62 00 2E C3 D1 4F F4 7F 60 C9 F8 18 00 ?? ?? ?? ?? A8 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 01 26 5A 68 40 F6 EC 73 60 60 02 60 C1 E7 DB F8 00 30 58 46 C8 F8 04 30 ?? ?? ?? ?? 00 23 C9 F8 14 30 C9 F8 18 30 D9 F8 10 20 7C 69 BF F3 5F 8F 54 E8 00 1F 91 42 03 D1 44 E8 00 36 00 2E F7 D1 8A 42 BF F3 5F 8F EE D1 01 2A 00 F3 FC 80 4F F0 FF 30 0F E6 00 22 D9 F8 10 30 7E 69 BF F3 5F 8F 56 E8 00 1F 99 42 03 D1 46 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F EE D1 01 2B 7F F7 FA AD 1D EE 70 1F 01 22 A1 F5 98 61 60 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 00 20 EB E5 D9 F8 14 20 9C 46 B9 6A A8 68 3C 69 89 1A 04 39 11 60 40 F8 24 20 A6 00 B9 6A D9 F8 18 00 52 1A 02 44 02 F0 03 00 22 F0 03 02 01 44 C9 F8 18 20 C9 F8 14 10 D9 F8 10 20 7C 69 BF F3 5F 8F 54 E8 00 1F 91 42 03 D1 44 E8 00 C3 00 2B F7 D1 8A 42 BF F3 5F 8F EE D1 01 2A 00 F3 99 80 AB 68 9B 59 84 E5 78 60 ?? ?? ?? ?? 00 F1 01 0A 50 46 ?? ?? ?? ?? 79 68 05 46 10 B1 52 46 ?? ?? ?? ?? 2B 46 C9 F8 0C 50 24 E6 2F 23 03 70 BE F1 00 0F 11 D0 01 30 AF E6 2F 23 8E F8 00 30 22 B9 8E F8 01 30 0E F1 02 0E D1 E6 0E F1 01 0E CE E6 78 69 9D E6 E6 46 C7 E6 ?? ?2 0? 0? 43 70 ?? ?2 0? 0? 08 22 02 30 ?? ?? ?? ?? 95 E6 BC 69 00 2C 3F F4 71 AF 06 F1 40 00 ?? ?? ?? ?? 6B E7 41 1C 0A D0 BC 69 1C B1 06 F1 40 00 ?? ?? ?? ?? 50 46 ?? ?? ?? ?? 00 20 71 E5 68 60 B5 E6 1D 49 01 22 79 61 BF F3 5F 8F 51 E8 00 3F 00 2B 03 D1 41 E8 00 20 00 28 F7 D1 BF F3 5F 8F 13 B1 08 46 ?? ?? ?? ?? AB 68 43 B3 ?? ?2 0? 0? 00 22 ?? ?2 0? 0? D9 F8 10 30 78 69 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 26 00 2E F7 D1 8B 42 BF F3 5F 8F EE D1 01 2B 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? AB 68 F5 E4 ?? ?? ?? ?? 30 6A 04 21 40 44 ?? ?? ?? ?? A8 60 00 28 7F F4 89 AE 4F F0 FF 33 AB 60 C9 E7 1D EE 70 1F 01 22 A1 F5 98 61 0E 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 58 E7 1D EE 70 1F 01 22 A1 F5 98 61 07 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 4F F0 FF 30 06 E5 30 46 ?? ?? ?? ?? 62 E6 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_4_0 {
	meta:
		name = "__dcigettext"
		size = 1408
		refs = "002e __pthread_rwlock_rdlock 0038 __libc_setlocale_lock 0064 __current_locale_name 006a strlen 0080 memcpy 0090 .LANCHOR1 0094 transcmp 0098 __pthread_rwlock_unlock 00ae __tfind 00c0 _nl_msg_cat_cntr 00da _nl_domain_bindings 010a strcmp 011e .LC5 0174 __getcwd 018e __rawmemchr 01a4 strcpy 01ac _nl_category_name_idxs 01b4 _nl_category_names 01b8 .LC4 01ca getenv 0210 __libc_enable_secure 0232 stpcpy 0240 mempcpy 0244 .LC6 0284 .LC7 029e _nl_find_domain 02b2 _nl_find_msg 0328 __libc_errno 03aa strchr 0418 _nl_default_dirname 046c .LANCHOR0 04c0 malloc 0502 __pthread_rwlock_wrlock 0542 __tsearch 0564 free"
	strings:
		$1 = { 2D E9 F0 4F 9B B0 02 AF 89 46 78 62 7A 61 FB 61 00 29 00 F0 B2 81 D7 F8 8C 40 A0 1F 43 42 43 41 0C 2C 88 BF 43 F0 01 03 00 2B 40 F0 85 81 ?? ?2 0? 0? ?? ?2 0? 0? 44 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B6 48 ?? ?? ?? ?? 7D 6A 00 2D 00 F0 0D 82 7D 6A 00 23 D7 F8 8C 00 3B 65 3D 64 C7 F8 5C 90 78 64 ?? ?? ?? ?? 05 46 ?? ?? ?? ?? 29 46 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 02 A8 ?? ?? ?? ?? F8 60 B8 64 14 B1 A6 48 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 07 F1 40 00 ?? ?2 0? 0? 3C 62 ?? ?? ?? ?? B8 61 14 B1 9B 48 ?? ?? ?? ?? BD 69 4D B1 ?? ?2 0? 0? 28 68 ?? ?2 0? 0? C2 68 1B 68 9A 42 00 F0 B7 81 94 4B 1D EE 70 4F ?? ?2 0? 0? 3C 61 7B 44 1B 68 ?? ?2 0? 0? E3 58 15 68 7B 60 00 2D 00 F0 92 81 7C 6A 05 E0 C0 F2 98 81 2D 68 00 2D 00 F0 8A 81 20 46 05 F1 0C 01 ?? ?? ?? ?? 00 28 F2 D1 6C 68 06 46 23 78 3C 63 2F 2B 04 BF ?? ?2 0? 0? ?? ?2 0? 0? 3F D0 38 6B 41 F2 02 0B ?? ?? ?? ?? DF F8 FC 81 C7 F8 34 90 D9 46 DF F8 F4 A1 FD 62 44 1C A3 46 3C 69 06 E0 52 46 7A 44 12 68 A2 58 22 2A 40 F0 FB 80 09 EB 0B 02 40 46 0E 32 78 44 00 68 22 F0 07 02 49 46 AD EB 02 0D 26 50 02 AD 28 46 ?? ?? ?? ?? 09 EB 59 03 03 F1 20 09 00 28 E2 D0 3D 63 00 21 38 6B ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? FD 6A 33 88 D7 F8 34 90 20 F8 01 3B 69 68 ?? ?? ?? ?? D7 F8 8C 40 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 F8 04 80 ?? ?2 0? 0? 98 44 ?? ?? ?? ?? 82 46 00 28 00 F0 1B 81 03 78 00 2B 00 F0 17 81 D7 F8 8C 00 ?? ?? ?? ?? 03 78 04 46 43 2B 18 BF 54 46 03 D1 63 78 00 2B 18 BF 54 46 78 6A 07 F1 3C 0A ?? ?? ?? ?? B8 60 40 46 ?? ?? ?? ?? BB 68 41 46 ?? ?2 0? 0? ?? ?2 0? 0? BA 62 18 44 00 F1 13 03 23 F0 07 03 AD EB 03 0D 0D F1 08 0E C7 F8 2C E0 70 46 ?? ?? ?? ?? 33 88 BA 68 79 6A 20 F8 01 3B ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 18 68 10 60 20 46 ?? ?? ?? ?? 0F 30 20 F0 07 03 AD EB 03 0D 02 AE 23 78 3A 2B 00 F0 A9 80 62 1C B4 46 00 2B 40 F0 87 80 4F F0 43 00 73 70 30 70 73 78 00 2B 66 D0 ?? ?2 0? 0? 30 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 5D D0 38 6B 31 46 FA 6A 2B 46 ?? ?? ?? ?? 78 63 00 28 DD D0 CD F8 00 A0 29 46 4A 46 01 23 ?? ?? ?? ?? 00 28 00 F0 83 80 42 1C 03 46 47 D0 BD 69 00 2D 00 F0 EC 80 BC 69 ?? ?2 0? 0? 7D 6B ?? ?2 0? 0? F8 6B 21 68 12 68 0D 61 25 46 24 68 CA 60 63 61 2A 68 90 61 10 4A 7C 68 3D 69 7A 44 12 68 AC 50 FC 69 00 2C 40 F0 C8 80 3C 6A 00 2C 00 F0 33 81 ?? ?2 0? 0? 3B 60 ?? ?2 0? 0? ?? ?? ?? ?? 02 48 ?? ?? ?? ?? 3B 68 18 46 12 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 69 F5 B1 D7 F8 88 00 01 28 1A D0 78 69 64 37 BD 46 BD E8 F0 8F D7 F8 34 90 3D 6A 45 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 84 48 ?? ?? ?? ?? 83 4B 7C 68 3D 69 7B 44 1B 68 EC 50 FC 69 00 2C E0 D1 48 46 64 37 BD 46 BD E8 F0 8F 14 46 0C F8 01 3B 01 32 23 78 3A 2B 18 BF 00 2B 0C BF 00 21 01 21 F3 D1 BA 6A 8C F8 00 10 13 68 33 B1 30 46 2F 21 ?? ?? ?? ?? 00 28 7F F4 58 AF 33 78 43 2B 7F F4 64 AF 5F E7 01 34 50 E7 79 6B 0B 69 00 2B 3F F4 4C AF 83 46 88 46 18 46 06 E0 D8 F8 10 00 0B F1 01 0B 00 28 3F F4 41 AF 29 46 CD F8 00 A0 4A 46 01 23 ?? ?? ?? ?? 08 F1 04 08 41 1C AC D0 00 28 EB D0 7C 6B 0B F1 04 0C 03 46 54 F8 2C 40 7C 63 5A E7 D7 F8 8C 00 ?? ?? ?? ?? 04 46 F0 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 3C 63 BD E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 3D 63 00 25 B2 E6 FC 69 CC B9 44 69 3D 6A 00 2D 00 F0 90 80 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 45 48 ?? ?? ?? ?? 20 46 64 37 BD 46 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 7B 62 EB E5 04 69 42 69 83 69 D7 F8 88 10 A0 68 FF F7 9F F9 04 46 DC E7 7D 6B 1A 46 D7 F8 88 10 FB 6B A8 68 FF F7 95 F9 03 46 2D E7 48 46 3B 60 ?? ?? ?? ?? 45 1C F8 68 ?? ?? ?? ?? D7 F8 08 E0 04 46 0E F1 1E 00 20 44 28 44 ?? ?? ?? ?? 3B 68 06 46 00 28 3F F4 0E AF D7 F8 08 E0 2A 46 49 46 1C 30 0E F1 01 05 ?? ?? ?? ?? 2A 46 79 6A 05 44 80 46 ?? ?? ?? ?? 62 1C F9 68 28 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 3B 68 F8 6B ?? ?2 0? 0? B5 60 ?? ?2 0? 0? 09 68 D7 F8 8C 40 7D 6B C6 F8 00 80 74 60 35 61 73 61 F1 60 B0 61 22 B1 15 48 3B 60 ?? ?? ?? ?? 3B 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 30 46 3B 60 ?? ?? ?? ?? 3D 6A 3B 68 04 46 1D B1 0B 48 ?? ?? ?? ?? 3B 68 1C B1 22 68 96 42 3F F4 C5 AE 30 46 3B 60 ?? ?? ?? ?? 3B 68 BE E6 18 46 EA E6 20 46 E8 E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_215_5_0 {
	meta:
		name = "free_mem"
		size = 130
		refs = "0002 _nl_domain_bindings 000a _nl_default_dirname 0022 free 0038 .LANCHOR0 003c _nl_default_default_domain 0052 .LANCHOR1 0064 __tdestroy"
	strings:
		$1 = { 70 B5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2C 68 84 B1 94 E8 0C 00 B3 42 18 46 2A 60 01 D0 ?? ?? ?? ?? A0 68 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 2C 68 00 2C EE D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 10 68 98 42 01 D0 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 28 68 ?? ?? ?? ?? 68 68 00 23 2B 60 08 B9 06 E0 20 46 04 68 6C 60 ?? ?? ?? ?? 00 2C F8 D1 70 BD }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__gconv"
		size = 362
		refs = "008e _dl_mcount_wrapper_check 012e .LC2 0132 .LC1 0136 __PRETTY_FUNCTION__.11031 0148 __assert_fail 014c .LC0"
	strings:
		$1 = { 2D E9 F0 4F 9B 46 89 B0 43 1C 05 46 0E 46 90 46 DD F8 4C C0 59 D0 03 68 01 3B 05 93 BC F1 00 0F 00 F0 94 80 00 23 59 46 CC F8 00 30 BB F1 00 0F 01 D0 DB F8 00 10 05 98 6A 68 C0 00 07 90 03 46 05 98 57 69 03 44 12 9A 05 EB 83 03 99 60 DA 60 00 2E 3E D0 D6 F8 00 90 B9 F1 00 0F 39 D0 BB F1 00 0F 64 D0 DB F8 00 30 00 2B 60 D0 CD F8 18 B0 05 F1 08 0A 00 24 E3 46 08 E0 33 68 4B 45 14 D0 6A 68 52 6A 1A 44 90 45 0F D3 99 46 38 46 ?? ?? ?? ?? 68 68 51 46 00 94 CD F8 04 B0 32 46 02 94 43 46 03 94 B8 47 04 28 E7 D0 DD F8 18 B0 DB F8 00 30 3B B1 07 9B 05 9A 13 44 05 EB 83 05 AB 68 CB F8 00 30 09 B0 BD E8 F0 8F 08 20 09 B0 BD E8 F0 8F 38 46 CD F8 10 C0 ?? ?? ?? ?? 05 9B 07 99 00 24 DD F8 10 C0 22 46 19 44 68 68 23 46 05 EB 81 01 8E 68 05 F1 08 01 CD F8 04 C0 A6 42 14 BF 01 26 02 26 00 94 02 96 03 94 B8 47 48 B9 05 9C 2A 46 03 46 01 46 01 33 51 61 9C 42 02 F1 24 02 F9 D2 BB F1 00 0F C2 D1 09 B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4A 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2C 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "_IO_getdelim"
		size = 560
		refs = "0076 malloc 0092 __underflow 00a8 memchr 00e8 realloc 0102 memcpy 0178 __libc_do_syscall 021e _Unwind_Resume 0222 __lll_lock_wait_private 0228 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 00 29 18 BF 00 28 83 B0 80 46 89 46 1D 46 01 92 00 F0 C4 80 1B 68 1C 04 1A 46 1F D4 A8 6C 1D EE 70 4F A4 F5 98 64 82 68 A2 42 13 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 F0 E9 80 AA 6C 2B 68 10 46 94 60 41 68 1A 46 01 31 41 60 98 06 62 D4 D8 F8 00 30 13 B1 D9 F8 00 30 43 B9 78 20 C9 F8 00 00 ?? ?? ?? ?? C8 F8 00 00 00 28 7E D0 6E 68 AC 68 A4 1B 00 2C 7D DD 00 27 08 E0 28 46 ?? ?? ?? ?? 01 30 3B D0 6E 68 5F 46 AC 68 A4 1B 30 46 01 99 22 46 ?? ?? ?? ?? 82 46 08 B1 84 1B 01 34 4F F6 FF 73 C7 F6 FF 73 DB 1B 9C 42 78 DA 07 EB 04 0B D9 F8 00 20 0B F1 01 03 93 42 98 BF D8 F8 00 00 11 D9 52 00 D8 F8 00 00 93 42 38 BF 13 46 00 93 19 46 ?? ?? ?? ?? 00 9B 00 28 46 D0 C8 F8 00 00 6E 68 C9 F8 00 30 22 46 38 44 31 46 ?? ?? ?? ?? 6B 68 1C 44 6C 60 BA F1 00 0F BE D0 D8 F8 00 30 00 22 03 F8 0B 20 2A 68 12 04 07 D5 58 46 03 B0 BD E8 F0 8F 4F F0 FF 3B 12 04 F7 D4 A8 6C 43 68 01 3B 43 60 00 2B F1 D1 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B DE DD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 58 46 D1 E7 2A 68 4F F0 FF 3B D2 E7 28 46 ?? ?? ?? ?? 41 1C 03 D0 6E 68 AC 68 A4 1B 78 E7 83 46 2A 68 C6 E7 21 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 B7 E7 1D 4B 1D EE 70 1F 4B 20 2A 68 7B 44 1B 68 4F F0 FF 3B C8 50 B1 E7 2B 68 04 46 1B 04 24 D4 AB 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 15 00 2D F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? ?? ?? ?? ?? 13 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "check_match.12851"
		size = 238
		refs = "003e strcmp 00c8 _dl_name_match_p 00d0 .LC0 00d4 .LC1 00d8 __PRETTY_FUNCTION__.12854 00ea __assert_fail"
	strings:
		$1 = { F8 B5 05 46 02 7B 64 46 43 68 02 F0 0F 01 00 2B 54 D0 EA 89 63 6A 00 2A 14 BF 00 23 03 F0 01 03 00 2B 40 D1 40 F2 67 42 42 FA 01 F1 C9 07 3A D5 23 6A 9D 42 07 D0 E0 69 2B 68 A1 69 18 44 ?? ?? ?? ?? 00 28 2F D1 61 69 26 69 D1 F8 A4 31 AE B1 00 2B 36 D0 E0 68 D1 F8 70 21 71 68 33 F8 10 70 C7 F3 0E 03 1B 01 D0 18 44 68 8C 42 1D D0 B3 68 CB B9 C4 B9 3A 04 16 D4 28 46 F8 BD 00 2B FB D0 E1 68 A2 68 33 F8 11 30 12 F0 02 0F 0C BF 03 21 02 21 C3 F3 0E 02 91 42 EE DC 1B 04 03 D4 60 68 43 1C 63 60 40 B1 00 20 F8 BD D0 58 31 68 ?? ?? ?? ?? 00 28 E0 D0 DA E7 25 60 F8 BD 06 29 A8 D0 F1 E7 F0 68 00 28 D7 D0 ?? ?? ?? ?? 00 28 D3 D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A7 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "do_lookup_x"
		size = 1416
		refs = "0030 _dl_argv 0038 _dl_debug_mask 0044 _dl_dynamic_weak 0058 .LC2 0104 _dl_name_match_p 014c __pthread_mutex_lock 017e __aeabi_uidivmod 01c4 strcmp 01e8 __pthread_mutex_unlock 0296 _dl_higher_prime_number 02a0 calloc 0330 free 0428 _dl_ns 0444 .LC3 0450 _dl_debug_printf 0468 .LC4 0472 _dl_dprintf 0478 _exit"
	strings:
		$1 = { 2D E9 F0 4F 95 B0 8A 46 1F 9C 21 99 09 92 24 9E 22 9A 65 68 10 90 A9 46 12 93 0E 91 0C 92 13 96 20 9D 05 F1 80 43 4F EA 5A 17 22 68 01 3B 07 97 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 97 57 46 DD F8 8C A0 ?? ?2 0? 0? 02 EB 83 08 ?? ?2 0? 0? 00 26 ?? ?2 0? 0? 04 94 ?? ?2 0? 0? ?? ?2 0? 0? 06 94 58 F8 04 3F 0B 96 0A 96 5C 69 54 45 0F 94 4D D0 13 9B 98 07 03 D5 94 F8 94 31 99 07 46 D0 94 F8 95 31 9A 06 42 D4 DB F8 00 30 1B 07 00 F1 CD 81 D4 F8 78 11 00 29 39 D0 62 6B A3 6B D4 F8 84 01 52 68 5B 68 11 92 08 93 00 28 00 F0 16 82 DD F8 1C C0 07 F0 1F 02 D4 F8 7C 31 01 92 0C EA 03 03 02 93 DD F8 08 C0 D4 F8 80 21 27 FA 02 F3 50 F8 2C 20 DD F8 04 C0 03 F0 1F 03 22 FA 03 F3 22 FA 0C FC 03 EA 0C 03 D8 07 00 F1 CC 81 0D 96 0B 9B 01 2B 12 D0 0D 9B 4B B9 0E 9B 3B B1 D8 68 28 B1 0F 99 ?? ?? ?? ?? 00 28 40 F0 B7 81 01 35 A9 45 A6 D8 00 20 15 B0 BD E8 F0 8F 0A 98 00 28 E9 D0 03 7B 1B 09 02 2B 6A D0 0A 2B 0A D0 01 2B E1 D1 07 46 1E 9D 01 20 0F 9B 2F 60 6B 60 15 B0 BD E8 F0 8F 0F 9A 4F F0 4C 08 B7 49 ?? ?2 0? 0? ?? ?2 0? 0? BA 46 92 69 07 46 08 FB 02 11 04 91 13 B1 08 46 ?? ?? ?? ?? 04 9A 04 9B 92 69 D3 F8 1C 80 05 92 00 2A 00 F0 1D 81 50 46 41 46 ?? ?? ?? ?? 50 46 06 91 A8 F1 02 01 ?? ?? ?? ?? 10 9B 06 9D 07 97 01 F1 01 0B 4F EA 0B 19 4F 46 99 46 05 9A 02 EB 05 14 94 E8 48 00 53 45 08 D0 00 2E 33 D0 5D 44 3C 44 A8 45 F5 D8 C8 EB 05 05 EF E7 49 46 30 46 ?? ?? ?? ?? 00 28 F0 D1 13 9B 07 9F 9A 07 47 BF 0F 9B 1E 9C E3 68 A2 68 53 BF 1E 9D 63 60 27 60 85 E8 0C 00 ?? ?2 0? 0? ?? ?2 0? 0? 00 2B 00 F0 46 81 04 98 ?? ?? ?? ?? 01 20 9E E7 04 9C 23 68 00 2B 94 D0 1E 9C 23 68 00 2B 7F F4 72 AF 0F 9B 84 E8 09 00 6D E7 DD F8 10 C0 08 EB 48 01 07 9F DC F8 20 00 B1 EB 80 0F 31 D9 5A 46 DD F8 18 B0 13 99 16 01 11 9D 8B 07 3C 68 40 F1 90 80 2C 44 12 9B 05 9D 05 EB 0B 19 04 E0 93 44 B1 44 D8 45 40 F2 AB 80 D9 F8 04 10 00 29 F6 D1 25 9D C9 F8 00 A0 C9 F8 04 40 C9 F8 08 30 C9 F8 0C 50 DD F8 10 C0 ?? ?2 0? 0? ?? ?2 0? 0? 01 30 CC F8 20 00 00 2B 3F F4 55 AF 60 46 ?? ?? ?? ?? 50 E7 08 F1 01 00 ?? ?? ?? ?? 01 46 05 46 10 20 ?? ?? ?? ?? 83 46 00 28 00 F0 D6 80 B8 F1 00 0F 00 F0 B7 80 05 9B AC 1E CD F8 24 A0 82 46 1E 46 03 EB 08 18 07 94 CD F8 18 80 08 97 D6 F8 04 80 B8 F1 00 0F 1C D0 37 68 29 46 D6 F8 08 90 38 46 D6 F8 0C B0 ?? ?? ?? ?? 38 46 0C 46 07 99 ?? ?? ?? ?? 01 31 4F EA 01 1E 0A EB 04 13 03 E0 0C 44 73 44 A5 42 2B D9 5A 68 00 2A F8 D1 83 E8 80 0B 06 9F 10 36 BE 42 D9 D1 D3 46 08 9F DD F8 24 A0 DD F8 10 C0 A8 46 05 98 DC F8 24 30 98 47 04 9A ?? ?2 0? 0? 50 46 ?? ?2 0? 0? 29 46 C2 F8 18 B0 53 62 D5 61 CD F8 14 B0 ?? ?? ?? ?? 50 46 8B 46 07 99 ?? ?? ?? ?? 04 9B 18 6A 4A 1C 6A E7 64 1B CA E7 2C 44 0F 99 05 9D 05 EB 0B 19 03 E0 93 44 B1 44 D8 45 18 D9 D9 F8 04 30 00 2B F7 D1 91 F8 94 31 C9 F8 00 A0 03 F0 03 03 C9 F8 04 40 02 2B C9 F8 08 70 C9 F8 0C 10 02 BF D1 F8 04 32 43 F0 08 03 C1 F8 04 32 64 E7 C8 EB 0B 0B DC E7 C8 EB 0B 0B 49 E7 10 20 1F 21 ?? ?? ?? ?? 05 90 00 28 4A D0 4C F6 09 32 41 F2 85 00 C8 F6 3D 52 C0 F6 42 00 DD F8 10 C0 ?? ?2 0? 0? A2 FB 0A 42 ?? ?2 0? 0? A0 FB 0A 40 CC F8 24 10 05 9D 1F 23 C0 EB 0A 0B 12 09 CC F8 1C 30 98 46 00 EB 5B 0B C2 EB C2 01 CC F8 18 50 4F EA 1B 1B 02 EB 81 02 C2 EB 0A 02 DC F8 20 00 CB EB 4B 1B 01 32 CB EB 0A 0B 08 E7 AA 1E 07 92 7B E7 ?? ?? ?? ?? 62 68 13 78 43 B9 DD F8 14 C0 06 99 DC F8 00 30 1A 68 00 2A 08 BF 0A 46 ?? ?2 0? 0? A3 69 ?? ?2 0? 0? 10 99 ?? ?? ?? ?? 0F 9C 1C E6 ?? ?2 0? 0? ?? ?2 0? 0? 13 B1 04 98 ?? ?? ?? ?? ?? ?2 0? 0? 02 20 ?? ?2 0? 0? ?? ?? ?? ?? 7F 20 ?? ?? ?? ?? 4F F0 FF 30 5D E6 01 20 5B E6 38 46 ?? ?? ?? ?? D4 F8 88 31 53 F8 21 30 00 2B 3F F4 2A AE D4 F8 8C 21 02 EB 83 03 1C 1F 02 E0 DA 07 3F F5 21 AE 54 F8 04 3F 87 EA 03 02 52 08 F6 D1 0F 9B 0D F1 28 0C 08 9A D3 F8 8C 01 20 1A 80 10 0D 90 02 EB 00 10 FF F7 1F FD 00 28 7F F4 25 AE 23 68 E4 E7 09 9B 18 68 43 1C 1C D0 ?? ?? ?? ?? 89 00 D4 F8 8C 31 58 58 0D 90 50 B9 FC E5 0F 9A 0D 9B D2 F8 88 21 52 F8 23 00 0D 90 00 28 3F F4 F3 AD 08 9A 0D F1 28 0C 02 EB 00 10 FF F7 FC FC 00 28 EC D0 01 E6 10 9A 13 78 5B B3 50 78 10 B3 92 F8 02 E0 00 EB 03 13 BE F1 00 0F 1B D0 D0 78 0E EB 03 13 B8 B1 92 F8 04 E0 00 EB 03 13 BE F1 00 0F 10 D0 50 79 0E EB 03 13 05 32 48 B1 00 EB 03 13 12 F8 01 0F 03 F0 70 4E 83 EA 1E 63 00 28 F5 D1 23 F0 70 43 18 46 03 93 ?? ?? ?? ?? 03 9B 89 00 00 E0 19 46 DD F8 24 C0 CC F8 00 30 B0 E7 }
	condition:
		$1
}

rule file_219_2_0 {
	meta:
		name = "_dl_lookup_symbol_x"
		size = 2110
		refs = "00f2 _dl_debug_mask 01de _dl_argv 01e2 .LC2 01fe .LC6 0206 .LC5 0222 .LC13 0226 .LC14 022c .LC7 0232 .LC8 0268 strlen 0294 stpcpy 029c .LC15 02aa _dl_signal_cerror 02d4 .LC12 02d8 .LC1 02dc __PRETTY_FUNCTION__.13034 02f0 __assert_fail 03a2 .LC10 03aa .LC18 03b6 .LC9 03cc _dl_debug_printf 03da .LC19 03e4 _dl_debug_printf_c 0466 undefined_msg 0518 __pthread_mutex_lock 0522 _dl_load_lock 0534 _dl_ns 05be __libc_do_syscall 0640 __pthread_mutex_unlock 067e _dl_lookup_symbol_x 0684 .LC11 06a8 .LC16 0706 .LC20 07ba .LC17 07dc malloc 0804 memcpy 0830 _dl_scope_free"
	strings:
		$1 = { 2D E9 F0 4F 9F B0 08 AF 80 46 89 46 7B 62 15 46 03 78 D7 F8 8C 60 00 2B 00 F0 BE 80 02 46 41 F2 05 5B 0B EB 4B 1B 9B 44 12 F8 01 3F 00 2B F8 D1 D7 F8 80 40 00 23 4F F0 FF 32 3B 63 FA 62 7B 63 2C B1 D7 F8 88 40 34 F0 05 04 40 F0 1B 83 7C 6A 22 68 00 2E 40 F0 2F 81 00 2A 00 F0 C7 81 3E 62 C7 F8 1C 90 07 F1 30 0A 7C 6A A9 46 D7 F8 20 E0 06 E0 40 F0 9F 80 54 F8 04 2F E2 B1 4F F0 00 0E D7 F8 80 50 40 46 D9 F8 00 30 59 46 01 92 07 F1 2C 02 03 95 D7 F8 88 50 CD F8 00 A0 CD F8 08 E0 04 95 D7 F8 84 50 05 96 06 95 FD 69 07 95 FF F7 E3 FC 00 28 DD DD 4B 46 D7 F8 1C 90 1D 46 3B 6B 00 2B 00 F0 93 81 2B 68 23 B1 5A 7B 02 F0 03 02 03 2A 20 D0 7C 6B 4F F0 00 0A 94 F8 94 31 03 F0 03 03 02 2B 00 F0 0E 81 D4 F8 FC 31 00 2B 00 F0 05 81 ?? ?2 0? 0? 40 F6 04 03 ?? ?2 0? 0? 12 68 13 40 00 2B 40 F0 26 81 3B 6B 20 46 2B 60 5C 37 BD 46 BD E8 F0 8F D7 F8 84 40 01 2C 3F D0 7C 6A 00 21 B9 63 F9 63 22 68 00 2A 00 F0 BB 82 8A 46 A4 46 39 6A 04 E0 5C F8 04 2F EA B1 2B 68 01 46 D7 F8 80 40 07 F1 38 00 02 91 59 46 8D E8 05 00 40 46 03 94 07 F1 2C 02 D7 F8 88 40 05 96 CD F8 1C A0 04 94 01 24 06 94 C7 F8 08 C0 FF F7 84 FC D7 F8 08 C0 00 28 DE D0 BB 6B 00 2B 00 F0 92 82 FB 6B 4B 45 00 F0 8E 82 2B 68 4C 46 C7 F8 34 90 3B 63 4F F0 01 0A A0 E7 41 F2 05 5B 48 E7 7A 6B 4A 45 00 F0 A7 80 3B 63 4C 46 C7 F8 34 90 D7 F8 84 A0 92 E7 00 2E 7F F4 5E AF D7 F8 80 40 4B 46 1D 46 D7 F8 1C 90 00 2C 00 F0 84 80 4A 46 B9 F1 00 0F 01 D0 D9 F8 04 20 13 78 91 46 6B B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 12 68 00 2A 14 BF 91 46 99 46 D7 F8 80 10 ?? ?2 0? 0? D7 F8 80 20 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 09 68 10 F1 02 0F 18 BF E6 46 D2 68 4F F0 07 0B ?? ?2 0? 0? ?? ?2 0? 0? 79 64 ?? ?2 0? 0? FA 64 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 38 65 07 F1 38 06 07 F1 54 0A 01 24 C7 F8 3C 80 58 46 C7 F8 54 E0 B9 63 3A 64 BB 64 03 E0 56 F8 04 0F ?? ?? ?? ?? 56 45 04 44 F8 D1 04 F1 0E 03 ?? ?2 0? 0? 23 F0 07 03 07 F1 38 04 AD EB 03 0D ?? ?2 0? 0? 08 AE 30 46 01 E0 54 F8 04 1F ?? ?? ?? ?? A2 45 F9 D1 ?? ?2 0? 0? 33 46 00 20 49 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 23 18 46 2B 60 2B E7 13 68 00 24 3C 62 19 68 B1 42 3F F4 CE AE 21 46 53 F8 04 0F 01 31 B0 42 FA D1 39 62 C5 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 3B 72 ?? ?? ?? ?? 4C 46 D7 F8 84 A0 EE E6 01 23 C4 F8 FC 31 F6 E6 D7 F8 88 00 C2 07 7F F5 ED AE A1 45 00 F0 F2 80 D4 F8 04 32 1B 07 3F F5 E5 AE D9 F8 F4 11 BF F3 5F 8F D9 F8 F0 21 39 62 FA 61 00 2A 00 F0 CD 80 13 68 00 2B 00 F0 C9 80 9C 42 07 D0 13 46 53 F8 04 2F 00 2A 00 F0 C1 80 A2 42 F8 D1 7C 6B C9 E6 53 07 D9 F8 04 10 7F F5 D5 AE 0B 78 63 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 11 68 00 29 08 BF 19 46 63 68 D9 F8 18 E0 18 78 60 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 1B 68 00 2B 08 BF 03 46 A4 69 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CD F8 08 80 72 46 00 94 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? BA F1 00 0F 08 BF 34 46 01 94 ?? ?? ?? ?? D7 F8 80 40 00 2C 00 F0 96 81 ?? ?2 0? 0? 21 68 ?? ?2 0? 0? ?? ?? ?? ?? 7C 6B 8D E6 2B 68 1B B1 1B 7B 1B 09 02 2B 00 D0 16 B1 00 20 28 60 86 E6 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 D9 05 F5 D4 B9 F1 00 0F 39 D0 D9 F8 04 10 ?? ?2 0? 0? D7 F8 80 40 ?? ?2 0? 0? 1A 46 3C B1 D7 F8 80 40 ?? ?2 0? 0? 22 68 72 B3 ?? ?2 0? 0? 08 78 0C 46 60 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 09 68 0C 68 00 2C 08 BF 04 46 07 F1 44 06 07 F1 38 0A 12 20 4F F0 01 09 ?? ?2 0? 0? C7 F8 3C 80 ?? ?2 0? 0? 3B 64 7A 64 B9 63 B2 45 81 44 10 D0 5A F8 04 0F ?? ?? ?? ?? F7 E7 ?? ?2 0? 0? ?? ?2 0? 0? C2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CB E7 09 F1 0E 03 ?? ?2 0? 0? 23 F0 07 03 07 F1 38 08 AD EB 03 0D ?? ?2 0? 0? 0D F1 20 09 48 46 ?? ?? ?? ?? 46 45 00 F0 F0 80 58 F8 04 1F F7 E7 3B 6A A3 B1 D3 F8 00 B0 1A 1D BB F1 00 0F 10 D0 5B 68 A3 42 3F F4 35 AF 00 23 01 33 5B 45 08 D0 52 F8 04 1F A1 42 F8 D1 2B E7 4C 46 F5 E5 D7 F8 20 B0 04 F5 14 73 D3 E9 00 01 C7 E9 04 01 D7 F8 88 10 11 F0 04 01 B9 61 32 D1 ?? ?2 0? 0? ?? ?2 0? 0? 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? D9 F8 18 20 4C 21 ?? ?2 0? 0? ?? ?2 0? 0? 01 FB 02 F2 9B 58 A3 42 18 BF 00 2B 04 D0 DB 68 A3 42 18 BF 00 2B FA D1 00 2B 00 F0 ED 80 04 F5 14 73 D7 E9 04 01 D3 E9 00 23 99 42 08 BF 90 42 5E D1 D4 F8 04 22 10 07 40 F1 D1 80 4F F0 00 0B 60 E0 1D EE 70 2F 7A 60 A2 F2 BC 40 03 68 00 22 BF F3 5F 8F 50 E8 00 CF 9C 45 03 D1 40 E8 00 21 00 29 F7 D1 63 45 BF F3 5F 8F EF D1 02 2B 7A 68 09 D1 A2 F5 98 61 01 22 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? D9 F8 F0 31 FA 69 9A 42 08 D0 3B B1 1A 68 2A B1 94 42 1B D0 53 F8 04 2F 00 2A F9 D1 D9 F8 F4 31 00 2B 98 D0 38 6A 98 42 6C D0 D3 F8 00 B0 1A 1D BB F1 00 0F 8F D0 5B 68 9C 42 07 D0 00 23 01 33 5B 45 88 D0 52 F8 04 1F 8C 42 F8 D1 04 F5 14 74 D4 E9 00 23 D7 E9 04 01 8B 42 08 BF 82 42 0C BF 4F F0 00 0B 6F F0 00 0B ?? ?2 0? 0? ?? ?2 0? 0? 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? BC 69 84 BB BB F1 FF 3F 7F F4 77 AE 7B 6A D7 F8 80 40 40 46 49 46 2A 46 03 96 00 94 D7 F8 84 40 01 94 D7 F8 88 40 02 94 ?? ?? ?? ?? 44 E5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 D6 22 ?? ?? ?? ?? 7C 6B 74 E5 ?? ?2 0? 0? 21 46 4B 46 ?? ?2 0? 0? 00 20 ?? ?? ?? ?? 9E E6 1D EE 70 3F BB F1 FF 3F A3 F5 98 63 4F F0 01 02 5A 60 BF F3 5F 8F 7F F4 3D AE D9 F8 CC 31 C3 E7 39 6A 0B 68 5B 45 7F F6 24 AF 04 31 01 EB 8B 02 51 F8 2B 10 8C 42 97 D0 0B F1 01 0B 5B 45 0C D9 52 F8 04 1F 8C 42 F7 D1 8E E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 7C 6B F8 E4 9B 46 09 E7 99 F8 94 31 03 F0 03 03 02 2B 09 D0 42 F0 08 02 4F F0 00 0B C4 F8 04 22 85 E7 4F F0 FF 3B 82 E7 D9 F8 04 32 19 07 F1 D4 D9 F8 F8 31 5B 45 41 D9 D9 F8 F4 31 0B F1 01 02 03 EB 8B 03 5C 60 BF F3 5F 8F D9 F8 F4 31 1A 60 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 5A 06 7F F5 03 AF 61 68 0B 78 63 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 11 68 00 29 08 BF 19 46 D9 F8 04 30 A2 69 18 78 60 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 68 00 68 00 28 18 BF 03 46 D9 F8 18 40 ?? ?2 0? 0? ?? ?2 0? 0? 4F F0 00 0B 00 94 ?? ?? ?? ?? 38 E7 00 2B 31 D0 5B 00 3B 62 58 1C 80 00 FA 60 ?? ?? ?? ?? FA 68 03 46 00 28 9E D0 DC 46 BB F1 00 0F 0E D0 D9 F8 F4 11 4F EA 8B 0C 62 46 04 30 04 31 FB 60 C7 F8 08 C0 ?? ?? ?? ?? D7 F8 08 C0 FB 68 9C 44 0B F1 01 02 CC F8 04 40 1A 60 BF F3 5F 8F 38 6A C9 F8 F8 01 D9 F8 F4 01 C9 F8 F4 31 00 28 98 D0 ?? ?? ?? ?? 95 E7 0A 23 2C 20 3B 62 CD E7 }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "_dl_setup_hash"
		size = 126
		refs = "005e .LC21 0062 .LC1 0066 __PRETTY_FUNCTION__.13084 007a __assert_fail"
	strings:
		$1 = { D0 F8 4C 31 70 B5 E3 B1 5B 68 1C 68 C0 F8 78 41 9A 68 5E 68 55 1E 15 42 21 D1 03 F1 10 01 C0 F8 7C 51 01 EB 82 02 DB 68 02 EB 84 04 C0 F8 88 21 C0 F8 84 11 A4 EB 86 04 C0 F8 80 31 C0 F8 8C 41 70 BD 03 6B 53 B1 5B 68 53 F8 08 2B C0 F8 78 21 03 EB 82 02 C0 F8 8C 31 C0 F8 88 21 70 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 67 32 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__strftime_internal"
		size = 4610
		refs = "003e __tzname 006a .LC3 0284 memset 02ee memcpy 02f6 .LC4 03ba strlen 05de mktime 0828 .LC0 0c20 .LC1 0e52 .LC2 0e7e _nl_get_alt_digit 10fc .LC5 110e _nl_get_era_entry 11f2 __tzset"
	strings:
		$1 = { 2D E9 F0 4F A1 B0 82 46 98 68 DD F8 AC 90 0E 46 15 46 99 6A 0C 28 08 90 D9 F8 08 20 C8 BF 0C 38 09 93 10 91 0E 92 C8 BF 08 90 04 DC 08 9B 00 2B 08 BF 0C 23 08 93 2B 78 00 2B 00 F0 9F 87 ?? ?2 0? 0? 4F F0 00 0B ?? ?2 0? 0? CD F8 2C C0 48 F2 1F 5C 57 46 C5 F2 EB 1C CD F8 34 C0 42 F2 93 4C 05 96 C9 F2 49 2C CD F8 30 C0 ?? ?2 0? 0? ?? ?2 0? 0? CD F8 28 C0 10 E0 05 9E CB EB 06 02 01 2A 40 F2 D6 80 0F B1 07 F8 01 3B 0B F1 01 0B 2B 46 5B 78 01 35 00 2B 00 F0 0F 81 25 2B 02 BF 00 21 07 91 06 91 E8 D1 15 F8 01 3F 30 2B 30 D0 28 D8 23 2B 08 BF 01 21 F6 D0 2D 2B 29 D0 A3 F1 30 02 09 2A 88 BF 4F F0 FF 34 24 D8 4C F6 CC 46 6A 1C C0 F6 CC 46 00 24 0F E0 12 F8 01 3C 00 F0 A2 80 04 EB 84 04 30 3B 03 EB 44 04 15 46 01 32 2B 78 A3 F1 30 00 09 28 0D D8 B4 42 ED DD 6F F0 00 44 F3 E7 5E 2B 04 BF 01 26 07 96 CC D0 5F 2B D5 D1 06 93 C8 E7 45 2B 00 F0 8F 80 4F 2B 18 BF 00 26 00 F0 8A 80 7A 2B 00 F2 8E 80 DF E8 13 F0 89 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 A9 04 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 52 04 FB 03 CB 04 7A 03 8C 00 76 05 F5 04 84 06 F0 03 8C 00 8C 00 8C 00 98 06 8C 00 8C 00 32 01 8C 00 92 06 E8 04 E4 00 B1 05 F5 04 8B 05 7F 05 1E 06 C0 05 8C 00 8C 00 8C 00 8C 00 8C 00 8C 00 31 06 25 03 1A 03 0D 03 00 03 8C 00 F5 04 25 03 8C 00 F1 02 E4 02 D2 02 C3 02 A4 02 8C 00 A1 02 8C 00 76 02 45 02 81 02 2D 02 8C 00 97 01 8C 01 CD 03 82 03 37 2B 7F F7 5B AF 6F F0 00 44 5C E7 00 20 21 B0 BD E8 F0 8F 1E 46 01 35 2B 78 71 E7 15 F8 01 3C 01 3D 25 2B 44 D1 A8 46 01 26 DD F8 14 C0 A4 1B 00 2C AC BF 06 EB 04 0A 06 F1 00 0A CB EB 0C 03 9A 45 E3 D2 FF B1 00 2C 0C DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 27 44 ?? ?? ?? ?? 07 99 69 B3 B0 44 73 1E BA 19 18 F8 01 0D 01 3B D9 F8 3C 10 51 F8 20 10 02 F8 01 1D 59 1C F4 D1 37 44 D3 44 2B 46 01 35 5B 78 00 2B 7F F4 F1 AE 05 9E BA 46 BA F1 00 0F 18 BF 00 2E 58 46 1C BF 00 23 8A F8 00 30 21 B0 BD E8 F0 8F 6B 1E 01 26 98 46 01 36 01 3B 98 F8 00 20 25 2A F8 D1 B2 E7 41 46 38 46 32 46 ?? ?? ?? ?? 37 44 D9 E7 ?? ?2 0? 0? ?? ?2 0? 0? 2A 98 4F F0 FF 31 09 9B 32 46 CD F8 04 90 00 90 00 20 FF F7 76 FE DD F8 14 C0 CB EB 0C 03 24 1A 80 46 00 2C AC BF 00 EB 04 0A 00 F1 00 0A 9A 45 BF F4 7F AF 00 2F B9 D0 00 2C D8 BF 3C 46 0C DD 06 98 22 46 04 93 3C 44 30 28 0B BF 01 46 38 46 38 46 20 21 ?? ?? ?? ?? 04 9B 2A 99 32 46 20 46 CD F8 04 90 D3 44 44 44 00 91 19 46 09 9B FF F7 48 FE 07 9E 00 2E 00 F0 CD 85 BC 42 40 F2 CA 85 3A 78 D9 F8 3C 30 53 F8 22 30 07 F8 01 3B A7 42 F6 D1 8C E7 4F F0 01 08 09 9E 00 29 18 BF 4F F0 01 08 B3 68 07 9E 18 BF 00 26 07 96 0E 9E 0B 2B CC BF BC 22 B8 22 32 44 50 68 04 93 ?? ?? ?? ?? DD F8 14 C0 04 9B CB EB 0C 02 24 1A 06 46 00 2C AC BF 00 EB 04 0A 00 F1 00 0A 92 45 BF F4 29 AF 00 2F 3F F4 63 AF 00 2C 10 DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 ?? ?? ?? ?? DD F8 24 C0 27 44 DC F8 08 30 B8 F1 00 0F 00 F0 98 85 0E 98 0B 2B D4 BF B8 22 BC 22 73 1E 02 44 52 68 00 2E 3F F4 41 AF 37 44 16 44 3A 46 16 F8 01 0D 01 3B D9 F8 38 10 51 F8 20 10 02 F8 01 1D 59 1C F4 D1 31 E7 4F 2E 3F F4 44 AF 45 2E 00 F0 31 86 DD F8 38 C0 DC F8 C8 60 50 E7 45 2E 3F F4 39 AF DD F8 24 C0 01 2C AC BF 22 46 01 22 0F 92 DC F8 18 80 B8 F1 00 0F A8 BF 4F 2E 00 F0 FD 84 43 46 5F EA D8 71 0D F1 53 00 18 BF C8 F1 00 03 4C F6 CD 48 CC F6 CC 48 A8 FB 03 62 06 46 01 38 D2 08 02 EB 82 0C A3 EB 4C 0C 13 46 0C F1 30 02 32 70 00 2B F0 D1 0D F1 54 08 11 B1 2D 23 01 3E 33 70 06 98 2D 28 23 D0 0F 9A C8 EB 06 0A 92 44 BA F1 00 0F 1C DD DD F8 14 C0 5F 28 CB EB 0C 03 00 F0 1B 85 0F 9A 9A 42 BF F4 A2 AE 39 B1 01 36 1F B1 2D 23 01 37 07 F8 01 3C 0B F1 01 0B 2F B1 38 46 30 21 52 46 57 44 ?? ?? ?? ?? D3 44 00 24 C6 EB 08 08 DD F8 14 C0 C8 EB 04 04 CB EB 0C 03 00 2C AC BF 08 EB 04 0A 08 F1 00 0A 9A 45 BF F4 7F AE 00 2F 3F F4 B9 AE 00 2C 0C DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 27 44 ?? ?? ?? ?? 07 99 00 29 00 F0 D2 84 08 F1 FF 33 B8 F1 00 0F 3F F4 A0 AE 47 44 B0 44 3A 46 18 F8 01 0D 01 3B D9 F8 3C 10 51 F8 20 10 58 1C 02 F8 01 1D F4 D1 90 E6 DD F8 24 C0 01 2C AC BF 22 46 01 22 0F 92 DC F8 18 30 DD F8 30 C0 06 33 8C FB 03 C1 DA 17 19 44 C2 EB A1 02 C2 EB C2 02 9B 1A 03 F1 01 08 5D E7 DD F8 24 E0 15 AE B0 46 46 F2 67 6A C6 F2 66 6A BE E8 0F 00 0F C6 BE E8 0F 00 0F C6 9E E8 07 00 86 E8 07 00 40 46 ?? ?? ?? ?? 0D F1 53 0C C1 0F 8A FB 00 32 C3 17 66 46 0C F1 FF 3C C3 EB A2 02 13 46 02 EB 82 02 A0 EB 42 02 18 46 01 B1 52 42 30 32 32 70 00 2B EB D1 4F F0 01 0C CD F8 3C C0 4F E7 DD F8 38 C0 DC F8 D0 60 DD F8 28 C0 33 78 00 2B 08 BF 66 46 66 E6 05 9E 01 3C CB EB 06 03 24 EA E4 76 01 36 9E 42 BF F4 F6 AD 8F B1 00 2C 0C DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 27 44 ?? ?? ?? ?? 09 23 07 F8 01 3B B3 44 2B 46 0F E5 4F F0 00 08 8F E6 05 9E 01 3C CB EB 06 03 24 EA E4 76 01 36 9E 42 BF F4 D3 AD 00 2F ED D0 00 2C 0C DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 27 44 ?? ?? ?? ?? 0A 23 07 F8 01 3B DA E7 45 2E 3F F4 0D AE DD F8 24 C0 02 2C AC BF 22 46 02 22 0F 92 DC F8 10 30 03 F1 01 08 D0 E6 45 2E 3F F4 FE AD DD F8 20 80 02 2C AC BF 22 46 02 22 0F 92 06 9B 2D 2B 18 BF 30 2B 18 BF 5F 23 06 93 BE E6 45 2E 3F F4 EC AD DD F8 24 C0 02 2C AC BF 23 46 02 23 0F 93 DC F8 08 80 EA E7 45 2E 3F F4 DF AD DD F8 24 C0 03 2C AC BF 22 46 03 22 0F 92 DC F8 1C 30 03 F1 01 08 A2 E6 45 2E 3F F4 D0 AD DD F8 24 C0 02 2C AC BF 22 46 02 22 0F 92 DC F8 0C 80 CE E7 45 2E 3F F4 C3 AD DD F8 24 C0 02 2C AC BF 22 46 02 22 0F 92 DC F8 0C 80 88 E6 4F 2E 3F F4 B6 AD 45 2E 00 F0 58 84 DD F8 38 C0 DC F8 C4 60 C2 E5 07 9A 00 29 18 BF 01 22 07 92 00 2E 7F F4 A6 AD 09 9E 33 69 0E 9E 0E 33 9B B2 06 EB 83 03 D3 F8 24 A0 50 46 ?? ?? ?? ?? DD F8 14 C0 CB EB 0C 03 24 1A 06 46 00 2C AC BF 00 EB 04 08 00 F1 00 08 98 45 BF F4 39 AD 6F B3 00 2C 17 DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 ?? ?? ?? ?? DD F8 24 C0 0E 98 27 44 DC F8 10 30 0E 33 9B B2 00 EB 83 03 D3 F8 24 A0 07 99 00 29 00 F0 C3 83 73 1E 6E B1 37 44 56 44 3A 46 16 F8 01 0D 01 3B D9 F8 3C 10 51 F8 20 10 58 1C 02 F8 01 1D F4 D1 C3 44 2B 46 36 E4 00 2E 7F F4 56 AD ?? ?2 0? 0? ?? ?2 0? 0? 65 E5 DD F8 24 C0 DC F8 20 30 00 2B FF F6 36 AD DC F8 24 80 63 1E DD F8 14 C0 23 EA E3 7A B8 F1 00 0F 0A F1 01 0A CB EB 0C 02 C0 F2 35 84 92 45 BF F4 E6 AC 7F B1 00 2B 0A DD 06 98 1A 46 30 28 38 46 18 BF 20 21 1F 44 08 BF 06 99 ?? ?? ?? ?? 2B 23 07 F8 01 3B D3 44 48 F6 89 02 4F EA E8 73 C8 F6 88 02 64 20 82 FB 08 C1 04 2C AC BF A4 46 4F F0 04 0C CD F8 3C C0 41 44 C3 EB 61 13 82 FB 03 12 D9 17 1A 44 C1 EB 62 12 C2 EB 02 11 A3 EB 81 03 00 FB 02 38 D5 E5 45 2E 00 F0 1E 84 DD F8 24 C0 64 22 DC F8 14 30 02 2C AC BF A4 46 4F F0 02 0C CD F8 3C C0 DD F8 34 C0 D9 17 8C FB 03 C0 DD F8 34 C0 C1 EB 60 11 02 FB 11 33 13 44 8C FB 03 C8 D9 17 C1 EB 68 18 02 FB 18 38 B2 E5 45 2E 3F F4 E0 AC 02 2C AC BF 22 46 02 22 DD F8 20 80 0F 92 A7 E5 00 2E 7F F4 D5 AC 09 9E 33 69 07 9E 1A 33 00 29 18 BF 01 26 07 96 9B B2 0E 9E 06 EB 83 03 D3 F8 24 A0 50 46 ?? ?? ?? ?? DD F8 14 C0 CB EB 0C 03 24 1A 06 46 00 2C AC BF 00 EB 04 08 00 F1 00 08 98 45 BF F4 63 AC 00 2F 3F F4 56 AF 00 2C 17 DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 ?? ?? ?? ?? DD F8 24 C0 0E 98 27 44 DC F8 10 30 1A 33 9B B2 00 EB 83 03 D3 F8 24 A0 07 99 00 29 00 F0 EB 82 73 1E 00 2E 3F F4 34 AF 37 44 56 44 3A 46 16 F8 01 0D 01 3B D9 F8 3C 10 51 F8 20 10 02 F8 01 1D 59 1C F4 D1 24 E7 00 2E 7F F4 7E AC 09 9E B3 69 07 9E 07 33 00 29 18 BF 01 26 07 96 9B B2 0E 9E 06 EB 83 03 D3 F8 24 A0 50 46 ?? ?? ?? ?? DD F8 14 C0 CB EB 0C 03 24 1A 06 46 00 2C AC BF 00 EB 04 08 00 F1 00 08 98 45 BF F4 0C AC 00 2F 3F F4 FF AE 00 2C 17 DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 ?? ?? ?? ?? DD F8 24 C0 0E 98 27 44 DC F8 18 30 07 33 9B B2 00 EB 83 03 D3 F8 24 A0 07 99 00 29 00 F0 94 82 73 1E 00 2E 3F F4 DD AE 37 44 56 44 3A 46 16 F8 01 0D 01 3B D9 F8 3C 10 5C 1C 51 F8 20 10 02 F8 01 1D F4 D1 CD E6 00 2E 7F F4 E2 AB 05 9E 01 3C CB EB 06 02 24 EA E4 76 01 36 96 42 BF F4 CB AB 00 2F 3F F4 E5 AD 00 2C 7F F7 E0 AD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 ?? ?? ?? ?? 27 44 2B 78 D0 E5 45 2E 00 F0 39 83 DD F8 24 C0 64 22 DC F8 14 30 01 2C AC BF A4 46 4F F0 01 0C CD F8 3C C0 DD F8 34 C0 03 F2 6C 73 D9 17 8C FB 03 C0 C1 EB 60 11 02 FB 11 33 A1 EB D3 78 BA E4 45 2E 3F F4 E8 AB DD F8 24 C0 02 2C AC BF 22 46 02 22 0F 92 DC F8 00 80 AD E4 45 2E 3F F4 DB AB DD F8 24 C0 09 98 0C 99 DC F8 1C A0 DC F8 18 C0 40 69 CC EB 0A 02 02 F5 BF 72 00 F2 6C 78 0F 90 81 FB 02 10 D1 17 10 44 C1 EB A0 01 C1 EB C1 01 52 1A C2 EB 0A 02 03 32 11 92 00 F1 6B 82 18 F0 03 0F 18 BF 6F F4 B6 72 1E D1 0D 98 80 FB 08 10 4F EA E8 71 C1 EB 60 12 02 90 64 20 00 FB 12 80 4F F6 92 62 CF F6 FF 72 70 B9 02 9A 4F F4 C8 70 C1 EB E2 11 4F F6 92 62 CF F6 FF 72 00 FB 11 81 00 29 18 BF 6F F4 B6 72 0A EB 02 01 0C 98 CC EB 01 02 02 F5 BF 72 80 FB 02 0C D0 17 94 44 C0 EB AC 00 C0 EB C0 00 12 1A 8A 1A 03 32 56 BF 0F 99 11 9A 01 F2 6D 78 47 2B 00 F0 1B 82 67 2B 40 F0 05 82 DD F8 34 C0 4F EA E8 73 64 21 8C FB 08 C2 02 2C AC BF A4 46 4F F0 02 0C CD F8 3C C0 DD F8 34 C0 C3 EB 62 13 01 FB 13 83 0B 44 8C FB 03 C8 DA 17 C2 EB 68 18 01 FB 18 38 2C E4 00 2E 7F F4 5A AB ?? ?2 0? 0? ?? ?2 0? 0? FF F7 69 BB 4F 2E 3F F4 51 AB 45 2E 00 F0 35 82 DD F8 38 C0 DC F8 CC 60 FF F7 5D BB 45 2E 3F F4 45 AB DD F8 24 C0 02 2C AC BF 22 46 02 22 0F 92 DC F8 18 30 DC F8 1C 20 DD F8 30 C0 06 33 D9 17 8C FB 03 C0 18 44 C1 EB A0 01 C1 EB C1 01 5B 1A D3 1A DD F8 30 C0 07 33 8C FB 03 C1 DA 17 0B 44 C2 EB A3 08 FF F7 F2 BB 45 2E 3F F4 1F AB DD F8 24 C0 02 2C AC BF 23 46 02 23 0F 93 DC F8 1C 20 DC F8 18 30 E4 E7 07 9E 00 29 0C BF 4F F0 00 0A 4F F0 01 0A 18 BF 00 26 07 96 10 9E 0E B1 33 78 9B B9 DD F8 24 C0 DC F8 20 30 00 2B 09 DB 2A 98 02 78 00 2A 00 F0 89 82 DD F8 2C C0 5C F8 23 30 10 93 10 9E 00 2E 00 F0 04 82 10 98 ?? ?? ?? ?? 06 46 DD F8 14 C0 24 1A 00 2C AC BF 00 EB 04 08 00 F1 00 08 CB EB 0C 03 98 45 BF F4 8D AA 00 2F 3F F4 80 AD 00 2C 0C DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 27 44 ?? ?? ?? ?? BA F1 00 0F 00 F0 3C 81 73 1E 00 2E 3F F4 69 AD 10 99 37 44 3A 46 0E 44 16 F8 01 0D 01 3B D9 F8 38 10 5C 1C 51 F8 20 10 02 F8 01 1D F4 D1 58 E5 45 2E 00 F0 2F 82 4F 2E 3F F4 AF AA DD F8 24 C0 01 2C AC BF 22 46 01 22 0F 92 DC F8 14 30 03 F2 6C 78 FF F7 72 BB 00 2E 7F F4 9F AA 09 9E 33 8B 07 9E 00 29 18 BF 01 26 07 96 0E 9E 06 EB 83 03 D3 F8 24 A0 50 46 ?? ?? ?? ?? DD F8 14 C0 CB EB 0C 03 24 1A 06 46 00 2C AC BF 00 EB 04 08 00 F1 00 08 98 45 BF F4 2F AA 00 2F 3F F4 22 AD 00 2C 15 DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 ?? ?? ?? ?? DD F8 24 C0 0E 98 27 44 BC F8 18 30 00 EB 83 03 D3 F8 24 A0 07 99 00 29 00 F0 B9 80 73 1E 00 2E 3F F4 02 AD 37 44 56 44 3A 46 16 F8 01 0D 01 3B D9 F8 3C 10 51 F8 20 10 02 F8 01 1D 59 1C F4 D1 F2 E4 45 2E 3F F4 4C AA DD F8 24 C0 02 2C AC BF 22 46 02 22 0F 92 DC F8 08 80 FF F7 11 BB ?? ?2 0? 0? ?? ?2 0? 0? FF F7 50 BA 45 2E 3F F4 38 AA DD F8 24 C0 02 2C AC BF 23 46 02 23 0F 93 DC F8 04 80 FF F7 FD BA 40 46 0E 99 ?? ?? ?? ?? 06 46 00 28 3F F4 FB AA ?? ?? ?? ?? 82 46 00 28 3F F4 F5 AA DD F8 14 C0 24 1A 00 2C AC BF 00 EB 04 08 00 F1 00 08 CB EB 0C 03 98 45 BF F4 BF A9 00 2F 3F F4 B2 AC 00 2C 0C DD 06 98 30 28 09 BF 01 46 38 46 38 46 22 46 1C BF 22 46 20 21 27 44 ?? ?? ?? ?? 07 99 00 29 67 D0 57 44 56 44 3B 46 0A F1 FF 3A 16 F8 01 1D 0A F1 FF 3A D9 F8 3C 20 BA F1 FF 3F 52 F8 21 20 03 F8 01 2D F2 D1 8C E4 38 46 31 46 42 46 47 44 ?? ?? ?? ?? FF F7 CC B9 27 46 2B 46 FF F7 BB B8 9A 45 BF F4 88 A9 2F B1 38 46 20 21 52 46 57 44 ?? ?? ?? ?? 54 45 D3 44 C8 BF CA EB 04 04 3F F7 EA AA 00 24 FF F7 E7 BA 07 99 21 B3 0E 98 0B 2B D4 BF B8 22 BC 22 73 1E 02 44 52 68 00 2E 3F F4 A7 A9 37 44 16 44 39 46 16 F8 01 0D 01 3B D9 F8 3C 20 52 F8 20 20 01 F8 01 2D 5A 1C F4 D1 FF F7 97 B9 9B 46 FF F7 9D B9 38 46 51 46 32 46 37 44 ?? ?? ?? ?? 45 E4 0E 99 0B 2B D4 BF B8 23 BC 23 38 46 32 46 0B 44 37 44 59 68 ?? ?? ?? ?? FF F7 7F B9 38 46 31 46 52 46 57 44 ?? ?? ?? ?? 30 E4 07 9A 00 2A 00 F0 10 81 73 1E 00 2E 3F F4 29 AC 10 98 37 44 39 46 06 44 16 F8 01 0D 01 3B D9 F8 3C 20 52 F8 20 20 58 1C 01 F8 01 2D F4 D1 18 E4 DD F8 30 C0 D3 17 8C FB 02 C1 02 2C AC BF A4 46 4F F0 02 0C CD F8 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "__strftime_l"
		size = 26
	strings:
		$1 = { 70 B5 84 B0 04 AC 00 26 08 9D 04 F8 01 6D 8D E8 30 00 FE F7 F3 FE 04 B0 70 BD }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__atomic_preadv64_replacement"
		size = 256
		refs = "0068 __libc_pread64 009c memcpy 00a6 free 00d4 __libc_alloca_cutoff 00e2 malloc 00fc __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F B2 F1 00 08 85 B0 82 46 89 46 02 AF 71 DD 4D 68 B5 F1 00 4F 3E BF 00 24 0E 46 22 46 03 D3 47 E0 75 68 AB 42 44 D3 01 34 4F F6 FF 73 44 45 C7 F6 FF 73 2A 44 06 F1 08 06 C2 EB 03 03 F0 D1 B2 F5 80 5F 43 D8 02 F1 0E 03 00 21 23 F0 07 03 79 60 AD EB 03 0D 0D F1 08 0B D7 E9 0C 01 CD E9 00 01 50 46 59 46 ?? ?? ?? ?? B0 F1 00 0A 3E DB B8 F1 00 0F 55 46 14 DD 00 26 01 E0 46 45 10 D0 D9 F8 04 40 59 46 D9 F8 00 00 01 36 A5 42 38 BF 2C 46 09 F1 08 09 22 46 A3 44 ?? ?? ?? ?? 2D 1B EC D1 78 68 ?? ?? ?? ?? 50 46 0C 37 BD 46 BD E8 F0 8F 11 4B 1D EE 70 2F 4F F0 FF 3A 16 21 7B 44 1B 68 50 46 0C 37 D1 50 BD 46 BD E8 F0 8F 10 46 3A 60 ?? ?? ?? ?? 3A 68 00 28 B4 D1 10 46 3A 60 ?? ?? ?? ?? 3A 68 83 46 78 60 00 28 B5 D1 4F F0 FF 3A D6 E7 00 22 A6 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "preadv64"
		size = 184
		refs = "0004 __libc_multiple_threads 0024 __libc_do_syscall 005c __libc_enable_asynccancel 007e __libc_disable_asynccancel 00ac __libc_errno"
	strings:
		$1 = { 2D E9 F8 4F ?? ?2 0? 0? ?? ?2 0? 0? 81 46 88 46 17 46 23 68 0A 9E DD F8 2C A0 FB B9 33 46 54 46 40 F2 69 1C ?? ?? ?? ?? 10 F5 80 5F 2A D8 05 46 00 2D 02 DB 28 46 BD E8 F8 8F 1C 4B 1D EE 70 2F 7B 44 1B 68 D3 58 26 2B F4 D1 0A 96 48 46 CD F8 2C A0 41 46 3A 46 BD E8 F8 4F 51 E7 ?? ?? ?? ?? 54 46 41 46 3A 46 33 46 40 F2 69 1C 83 46 48 46 ?? ?? ?? ?? 10 F5 80 5F 05 46 0D D8 58 46 ?? ?? ?? ?? D5 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 CA E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 35 7B 44 1B 68 D1 50 E7 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "__wcsncpy"
		size = 136
	strings:
		$1 = { 03 2A A0 F1 04 03 30 B4 20 D9 95 08 0D E0 4C 68 9C 60 5C B3 8C 68 10 31 DC 60 74 B3 51 F8 04 4C 43 F8 10 4F 34 B1 01 3D 10 D0 0C 68 5C 60 00 2C ED D1 04 33 01 3A 19 1A B2 EB A1 02 04 D0 00 21 01 3A 43 F8 04 1F FB D1 30 BC 70 47 12 F0 03 02 FA D0 1C 1D 01 E0 00 2D F1 D0 51 F8 04 5B 01 3A 23 46 44 F8 04 5B F6 D1 30 BC 70 47 08 33 01 3A 19 1A B2 EB A1 02 E2 D1 E6 E7 0C 33 01 3A 19 1A B2 EB A1 02 DB D1 DF E7 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__wcschrnul"
		size = 28
	strings:
		$1 = { 03 68 53 B1 8B 42 08 D0 03 1D 01 E0 8A 42 04 D0 18 46 53 F8 04 2B 00 2A F8 D1 70 47 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "lrand48_r"
		size = 16
		refs = "0006 __nrand48_r"
	strings:
		$1 = { 0A 46 01 46 08 B1 ?? ?? ?? ?? 4F F0 FF 30 70 47 }
	condition:
		$1
}

rule file_1030_0_0 {
	meta:
		name = "mrand48_r"
		size = 16
		refs = "0006 __jrand48_r"
	strings:
		$1 = { 0A 46 01 46 08 B1 ?? ?? ?? ?? 4F F0 FF 30 70 47 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "getw"
		size = 34
		refs = "000e _IO_fread"
	strings:
		$1 = { 00 B5 04 21 83 B0 03 46 01 22 0D EB 01 00 ?? ?? ?? ?? 01 28 14 BF 4F F0 FF 30 01 98 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "__dcgettext"
		size = 22
		refs = "000c __dcigettext"
	strings:
		$1 = { 00 B5 83 B0 00 23 01 92 1A 46 00 93 ?? ?? ?? ?? 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "tcsendbreak"
		size = 50
		refs = "0022 __ioctl"
	strings:
		$1 = { 00 29 30 B4 0F DD 48 F2 1F 53 01 F1 63 04 C5 F2 EB 13 45 F2 25 41 E2 17 83 FB 04 53 30 BC C2 EB 63 12 ?? ?? ?? ?? 45 F2 09 41 00 22 30 BC ?? ?? ?? ?? }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_IO_mem_sync"
		size = 58
		refs = "002e _IO_str_overflow"
	strings:
		$1 = { 82 69 43 69 10 B5 93 42 18 BF 00 22 04 46 18 BF 1A 70 0B D0 D4 F8 A8 30 00 20 22 69 1A 60 D4 F8 AC 30 61 69 22 69 8A 1A 1A 60 10 BD 00 21 ?? ?? ?? ?? 63 69 01 3B 63 61 EC E7 }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "_IO_mem_finish"
		size = 68
		refs = "0012 realloc 0040 _IO_str_finish"
	strings:
		$1 = { 38 B5 04 46 03 69 41 69 18 46 D4 F8 A8 50 C9 1A 01 31 ?? ?? ?? ?? 28 60 D4 F8 A8 30 1B 68 5B B1 60 69 00 22 21 69 41 1A 5A 54 D4 F8 AC 30 60 69 21 69 41 1A 19 60 E2 61 20 46 00 21 BD E8 38 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_234_2_0 {
	meta:
		name = "open_memstream"
		size = 120
		refs = "000a malloc 001e calloc 002a _IO_init 002e .LANCHOR0 0044 _IO_str_init_static_internal 004e free"
	strings:
		$1 = { F8 B5 07 46 4F F4 BC 70 0E 46 ?? ?? ?? ?? 04 46 80 B3 00 F1 B0 03 4F F4 00 51 01 20 A3 64 ?? ?? ?? ?? 05 46 30 B3 20 46 00 21 ?? ?? ?? ?? ?? ?2 0? 0? 29 46 2B 46 20 46 ?? ?2 0? 0? C4 F8 98 20 4F F4 00 52 ?? ?? ?? ?? 21 68 ?? ?2 0? 0? ?? ?2 0? 0? 21 F0 01 01 ?? ?2 0? 0? ?? ?2 0? 0? 20 46 C4 F8 A8 70 C4 F8 AC 60 21 60 C4 F8 A0 20 C4 F8 A4 30 F8 BD 00 20 F8 BD }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "profil_count"
		size = 200
		refs = "0002 .LANCHOR0"
	strings:
		$1 = { F0 B4 ?? ?2 0? 0? ?? ?2 0? 0? 8C 46 BB 68 1A 69 90 42 04 D3 5A 69 90 42 38 BF 1C 46 17 D3 3D 68 00 22 7E 68 01 3D 05 E0 61 69 5A 1C 88 42 24 D3 95 42 0B D3 53 19 5B 08 03 EB 43 04 06 EB C4 04 21 69 88 42 F0 D2 5D 1E 95 42 F3 D2 FB 68 1D 68 9B 68 40 1B BC F1 00 0F 12 D0 82 08 61 68 A2 FB 03 23 12 0C 42 EA 03 42 8A 42 24 D3 FB 68 DB 68 1A 68 01 32 1A 60 F0 BC 70 47 BC 60 FB 68 E6 E7 42 08 61 68 A2 FB 03 23 12 0C 42 EA 03 42 8A 42 0A D2 E1 68 4F F6 FF 70 31 F8 12 30 83 42 1C BF 01 33 21 F8 12 30 E6 E7 FB 68 F0 BC DB 68 1A 88 01 32 1A 80 70 47 E1 68 51 F8 22 30 58 1C 1C BF 01 33 41 F8 22 30 D6 E7 }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "pcmp"
		size = 26
	strings:
		$1 = { 03 68 09 68 9A 68 8B 68 9A 42 04 D3 94 BF 00 20 6F F0 00 00 70 47 01 20 70 47 }
	condition:
		$1
}

rule file_236_2_0 {
	meta:
		name = "insert.part.0"
		size = 206
		refs = "0004 .LANCHOR0 001c malloc 0054 __aeabi_uidiv 0094 realloc 00bc memmove"
	strings:
		$1 = { 2D E9 F8 4F ?? ?2 0? 0? ?? ?2 0? 0? 1E 46 05 46 8A 46 23 68 91 46 00 2B 37 D1 18 20 ?? ?? ?? ?? 07 46 00 2F 4F D0 D4 F8 00 80 ?? ?2 0? 0? ?? ?2 0? 0? B8 EB 05 02 35 D1 05 EB 45 05 07 EB C5 05 D6 F8 08 B0 0A 9A 70 68 00 2A 0C BF 02 21 04 21 C5 F8 00 B0 ?? ?? ?? ?? 31 68 F2 68 ?? ?2 0? 0? 08 F1 01 06 C5 F8 10 A0 26 60 ?? ?2 0? 0? AA 60 E9 60 C5 F8 14 90 68 60 67 60 BB F1 00 0F 01 D1 02 2A 0B D0 00 20 BD E8 F8 8F 01 33 60 68 03 EB 43 01 C9 00 ?? ?? ?? ?? 07 46 C2 E7 DF 60 58 46 BD E8 F8 8F 01 35 02 EB 42 02 05 EB 45 05 D2 00 E8 00 A0 F1 18 05 38 44 3D 44 29 46 ?? ?? ?? ?? DB F8 00 80 BC E7 4F F0 FF 30 BD E8 F8 8F }
	condition:
		$1
}

rule file_236_5_0 {
	meta:
		name = "__sprofil"
		size = 772
		refs = "0020 __profile_frequency 002e __aeabi_idiv 0050 .LANCHOR0 0062 .LANCHOR1 008e pcmp 00a6 qsort 00e4 __aeabi_uldivmod 00ec __aeabi_uidiv 019a free 0200 profil_counter_uint 0204 profil_counter_ushort 023a __sigaction 0260 __setitimer 02de .LC0 02e2 .LC1 02e6 __PRETTY_FUNCTION__.7670 02f8 __assert_fail"
	strings:
		$1 = { 2D E9 F0 4F B1 B0 02 AF 14 46 06 46 7B 60 8B 00 0A 33 F9 60 23 F0 07 03 AD EB 03 0D 02 AD BA B1 ?? ?? ?? ?? 01 46 44 F2 40 20 C0 F2 0F 00 ?? ?? ?? ?? 4D F6 83 62 C4 F2 1B 32 44 F2 40 23 C0 F2 0F 03 A2 FB 00 12 92 0C 22 60 03 FB 12 03 63 60 ?? ?2 0? 0? ?? ?2 0? 0? DB F8 00 10 00 29 40 F0 12 81 ?? ?2 0? 0? CB F8 04 10 ?? ?2 0? 0? CB F8 0C 20 FA 68 00 2A 40 F3 25 81 2C 1F 06 EB 02 11 33 46 22 46 42 F8 04 3F 10 33 8B 42 FA D1 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? F9 68 04 22 ?? ?2 0? 0? ?? ?2 0? 0? 3C 61 ?? ?? ?? ?? BD 60 7D 68 05 F0 01 08 00 25 7D 61 3D 69 55 F8 04 6F D6 F8 0C 90 3D 61 B9 F1 01 0F 40 F2 83 80 71 68 B8 F1 00 0F 00 F0 CC 80 4F EA 91 0A 4A 46 09 0C 00 23 4F EA 8A 40 B4 68 ?? ?? ?? ?? 04 21 05 19 ?? ?? ?? ?? A0 FB 09 01 03 0C E0 43 43 EA 01 43 9A 45 88 BF 01 35 B8 F1 00 0F 0C BF 02 21 04 21 28 44 ?? ?? ?? ?? A0 FB 09 01 03 0C 43 EA 01 43 9A 45 40 F2 DE 80 B8 F1 00 0F 0C BF 02 21 04 21 28 1B ?? ?? ?? ?? A0 FB 09 01 03 0C 43 EA 01 43 9A 45 00 F2 CE 80 DB F8 00 30 18 46 00 2B 36 D0 BA 68 4F F0 00 09 51 68 0B 46 21 46 44 46 0A E0 DB F8 04 30 03 EB 0A 00 DB F8 00 20 09 F1 01 09 41 69 91 45 20 D2 09 EB 49 0A 4F EA CA 0A 03 EB 0A 00 02 69 91 42 EF D2 AA 42 15 D8 00 94 48 46 33 46 FF F7 CF FE 00 28 E2 DA DB F8 04 00 ?? ?? ?? ?? 4F F0 FF 30 00 23 CB F8 00 30 CB F8 04 30 BC 37 BD 46 BD E8 F0 8F A0 46 48 46 0C 46 AC 42 08 D2 CD F8 00 80 21 46 2A 46 33 46 FF F7 B2 FE 00 28 E2 DB 7D 69 F9 68 01 35 7D 61 8D 42 7F F4 6C AF DB F8 00 00 ?? ?2 0? 0? ?? ?2 0? 0? 00 28 DE D0 5A 68 07 F1 30 01 7D 68 4F F0 80 50 9A 60 EB 07 4B BF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F0 FF 32 FB 62 07 F1 B8 03 43 F8 08 0D 43 F8 04 2D 8B 42 FB D1 D7 F8 B0 30 1B 20 07 F1 2C 01 32 4A 43 F0 04 03 C7 F8 B0 30 ?? ?? ?? ?? 00 28 4A DB 07 F1 24 02 00 21 01 23 79 62 BB 62 07 F1 1C 03 92 E8 03 00 2A 4A 83 E8 03 00 19 46 02 20 ?? ?? ?? ?? BC 37 BD 46 BD E8 F0 8F 4F EA 51 0A 4A 46 09 0C 43 46 4F EA 4A 40 B4 68 ?? ?? ?? ?? 02 21 05 19 32 E7 02 20 0B F1 10 01 00 22 ?? ?? ?? ?? 00 28 20 DB DB F8 A4 30 1B 20 0B F1 20 01 00 22 43 F0 04 03 CB F8 A4 30 ?? ?? ?? ?? 00 28 12 DB DB F8 04 00 ?? ?? ?? ?? 00 20 BC 37 BD 46 BD E8 F0 8F ?? ?2 0? 0? 28 46 F9 68 ?? ?2 0? 0? 04 22 ?? ?? ?? ?? 82 E7 4F F0 FF 30 66 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 65 22 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__memrchr"
		size = 170
	strings:
		$1 = { F0 B4 C9 B2 10 44 7A B1 84 07 1A D0 10 F8 01 3C 01 38 8B 42 06 D1 12 E0 83 07 12 D0 10 F8 01 3D 8B 42 0C D0 01 3A F7 D1 00 22 82 1A 04 E0 10 F8 01 3C 01 38 8B 42 02 D0 90 42 F8 D1 00 20 F0 BC 70 47 41 EA 01 2C 03 2A 4C EA 0C 4C ED D9 04 1F 05 46 0A E0 AB 78 8B 42 21 D0 6B 78 8B 42 21 D0 23 79 8B 42 EB D0 03 2A DF D9 55 F8 04 6D 4F F4 80 73 C8 F2 01 13 20 46 86 EA 0C 06 04 3A A6 F1 01 37 04 3C 07 F1 00 47 F6 43 7E 40 33 40 00 2B E9 D0 EB 78 8B 42 DD D1 03 30 F0 BC 70 47 02 30 F0 BC 70 47 01 30 F0 BC 70 47 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "rewinddir"
		size = 126
		refs = "0028 __lseek 005c __lll_lock_wait_private 0078 __libc_do_syscall"
	strings:
		$1 = { 38 B5 01 22 04 46 05 1D BF F3 5F 8F 55 E8 00 3F 00 2B 03 D1 45 E8 00 20 00 28 F7 D1 BF F3 5F 8F DB B9 00 21 20 68 0A 46 ?? ?? ?? ?? 00 23 19 46 63 61 23 61 E3 60 63 68 BF F3 5F 8F 55 E8 00 2F 9A 42 03 D1 45 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 04 DC 38 BD 28 46 ?? ?? ?? ?? DF E7 1D EE 70 1F 01 22 A1 F5 98 61 28 46 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EC E7 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "__fgets_unlocked_chk"
		size = 116
		refs = "002c _IO_getline 006a __chk_fail 0070 __libc_errno"
	strings:
		$1 = { 00 2A F0 B5 05 46 83 B0 0F 46 1C 46 2B DD 1E 68 01 3A 8A 42 28 BF 0A 46 20 46 26 F0 20 03 01 21 00 91 29 46 23 60 0A 23 06 F0 20 06 ?? ?? ?? ?? 30 B9 23 68 05 46 28 46 1E 43 26 60 03 B0 F0 BD 23 68 9A 06 09 D5 0A 4A 1D EE 70 1F 7A 44 12 68 8A 58 0B 2A 18 BF 00 25 ED D1 87 42 05 D9 00 23 2B 54 23 68 E7 E7 00 20 E8 E7 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "ntp_gettimex"
		size = 58
		refs = "0010 __adjtimex"
	strings:
		$1 = { F0 B5 A1 B0 20 AB 04 46 68 46 00 25 43 F8 80 5D ?? ?? ?? ?? 09 AB 03 9E 04 9A 65 61 A5 61 E5 61 25 62 A6 60 E2 60 07 46 93 E8 03 00 14 9B 84 E8 03 00 38 46 23 61 21 B0 F0 BD }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_dl_build_local_scope"
		size = 76
	strings:
		$1 = { 70 B5 01 22 01 60 06 46 91 F8 94 31 05 1D D1 F8 F0 41 62 F3 46 13 81 F8 94 31 A4 B1 61 68 04 34 19 B9 10 E0 54 F8 04 1F 69 B1 91 F8 94 31 13 F0 60 0F F7 D1 28 46 FF F7 E3 FF 54 F8 04 1F 05 EB 80 05 00 29 F1 D1 A8 1B 80 10 70 BD }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "openaux"
		size = 44
		refs = "0022 _dl_map_object"
	strings:
		$1 = { 30 B5 83 B0 03 68 04 46 85 68 01 69 18 46 93 F8 94 21 00 95 9D 69 12 F0 03 02 63 68 08 BF 01 22 01 95 ?? ?? ?? ?? 60 61 03 B0 30 BD }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "_dl_map_object_deps"
		size = 3174
		refs = "009e _dl_argv 00ba _dl_debug_mask 00d0 .LC0 0142 strchr 014c openaux 0168 _dl_catch_error 01aa malloc 01c6 memcpy 02c0 __libc_errno 02ce strlen 0516 memset 05c6 memmove 0638 _dl_scope_free 0758 _dl_dst_count 0764 __libc_enable_secure 078e _dl_platformlen 07c4 _dl_dst_substitute 086c .LC4 0876 _dl_debug_printf 0884 _dl_get_origin 089a .LC1 08a6 _dl_signal_error 08b4 .LC9 08b8 .LC3 08bc __PRETTY_FUNCTION__.11586 08d0 __assert_fail 08e4 .LC8 08f8 .LC2 0982 free 09a2 .LC7 09ca .LC13 09ea _dl_ns 0ad4 .LC12 0af4 .LC11 0b06 .LC10 0bc8 .LC6 0c18 .LC5"
	strings:
		$1 = { 2D E9 F0 4F 02 EB 42 0E 9F B0 01 24 02 AF 4F EA 8E 0E 00 26 7B 62 0E F1 26 03 23 F0 07 03 90 F8 94 51 AD EB 03 0D F8 62 02 A8 B8 62 D7 F8 28 B0 64 F3 46 15 F8 6A 05 AB CB F8 00 60 CB F8 04 00 CB F8 08 30 80 F8 94 51 00 2A 00 F0 43 84 08 46 A4 46 01 EB 82 05 0B F1 18 03 50 F8 04 1B 43 F8 0C 6C A8 42 43 F8 04 3C 91 F8 94 41 03 F1 0C 03 43 F8 14 1C 6C F3 46 14 81 F8 94 41 ED D1 D7 F8 28 B0 01 32 3A 64 DB F8 04 A0 D7 F8 28 C0 1D EE 70 4F 8B 49 00 23 7C 61 F4 44 D7 F8 14 B0 ?? ?2 0? 0? C7 F8 44 C0 ?? ?2 0? 0? CC F8 08 30 79 44 09 68 84 4A 56 46 5B F8 01 10 ?? ?2 0? 0? 3B 65 7A 44 12 68 3C 61 ?? ?2 0? 0? BC 6A 4B F8 02 30 ?? ?2 0? 0? ?? ?2 0? 0? FB 61 B9 60 C7 F8 3C C0 BB 61 C7 F8 0C B0 7C 63 D7 F8 34 C0 01 22 D6 F8 5C 31 4F F0 00 09 CC F8 00 20 00 2B 00 F0 AC 80 73 6A 00 2B 00 F0 9C 80 B5 68 73 6B 7C 6A BE 65 D3 F8 04 A0 2B 68 FC 65 D7 F8 98 40 C7 F8 64 A0 3C 66 00 2B 00 F0 96 80 7C 6B 08 35 4F F0 00 08 3C 63 01 2B 40 F0 89 82 55 F8 04 4C 24 21 54 44 20 46 ?? ?? ?? ?? 00 28 40 F0 05 83 ?? ?2 0? 0? BC 66 ?? ?2 0? 0? 07 F1 58 02 07 F1 54 00 00 92 07 F1 50 01 07 F1 4F 02 ?? ?? ?? ?? 3B 6D 00 2B 40 F0 AA 80 FB 6E 93 F8 94 21 C2 F3 41 12 00 2A 43 D0 B9 F1 00 0F 03 D0 49 F8 28 30 08 F1 01 08 55 F8 08 3B 00 2B CC D1 B9 F1 00 0F 26 D0 4F EA C8 00 00 23 0C 30 49 F8 28 30 ?? ?? ?? ?? 4F EA 88 08 04 46 00 28 00 F0 93 83 08 F1 04 05 49 46 2A 46 40 F8 04 6B ?? ?? ?? ?? 08 F1 08 00 2A 46 20 44 21 46 ?? ?? ?? ?? BF F3 5F 8F C6 F8 F0 41 96 F8 96 31 43 F0 01 03 86 F8 96 31 D7 F8 34 C0 DC F8 00 30 FB B1 7B 6B 01 E0 1A 68 D2 B1 9B 68 00 2B FA D1 7B 63 1C 46 8B E0 86 B0 D7 F8 44 B0 93 F8 94 01 02 A9 3C 6C 02 92 04 92 01 22 03 93 01 34 CB F8 08 10 62 F3 46 10 3C 64 79 64 83 F8 94 01 A6 E7 7B 63 D7 F8 34 B0 DB F8 04 60 53 E7 D6 F8 F0 30 00 2B 7F F4 5F AF D6 F8 E8 30 00 2B 7F F4 5A AF 98 46 9F E7 D6 F8 F0 21 0A B1 99 46 4E E7 FC 6A B4 42 08 BF 91 46 3F F4 49 AF B6 F8 5A 31 00 2B F3 D0 D7 F8 1C B0 9B 00 5B 45 98 BF D7 F8 18 90 7F F6 3C AF 0F 33 EC 46 23 F0 0F 03 BC 69 03 F1 0E 02 D2 08 AC EB C2 0C E5 46 0D F1 08 09 09 EB 03 02 94 42 02 BF C7 F8 18 90 9B 44 C7 F8 1C B0 3F F4 24 AF FB 61 C7 F8 18 90 1F E7 ?? ?? ?? ?? ?? ?? ?? ?? 04 46 18 46 7B 60 ?? ?? ?? ?? 7B 68 00 F1 0F 01 42 1C 21 F0 07 00 19 46 AD EB 00 0D 02 A8 ?? ?? ?? ?? 7E 6D 05 46 30 46 ?? ?? ?? ?? 31 46 00 F1 0F 02 22 F0 07 06 42 1C AD EB 06 0D 02 A8 ?? ?? ?? ?? 97 F8 4F 20 7B 68 78 65 00 2A 40 F0 0B 84 00 2C 08 BF 4F F0 FF 34 3D 65 B6 4B D7 F8 14 C0 7B 44 1B 68 5C F8 03 30 33 B9 B8 68 20 B1 B2 4B 7B 44 1B 68 4C F8 03 00 FB 6A D3 F8 F0 31 3B 63 5B B1 D7 F8 2C B0 9B F8 94 31 03 F0 03 03 02 2B 1C BF 00 23 3B 63 00 F0 A4 82 39 6C C8 00 04 30 ?? ?? ?? ?? 78 64 00 28 00 F0 D3 83 38 6C 00 25 D7 F8 2C B0 43 1C BA 6A 7E 6A CB F8 60 01 78 6C 00 EB 83 03 58 46 CB F8 5C 31 53 68 00 2E 40 F0 49 83 D0 F8 5C 11 41 F8 25 30 01 35 53 68 93 F8 94 11 92 68 6F F3 46 11 83 F8 94 11 00 2A EC D1 ?? ?2 0? 0? BA 62 ?? ?2 0? 0? 1B 68 1B 05 00 F1 10 83 D7 F8 2C B0 DB F8 5C 11 0B 68 5B 45 BB 63 40 F0 F7 82 D7 F8 2C B0 DB F8 F4 21 00 2A 00 F0 E4 82 01 2D 40 F2 BA 83 4F EA 85 0B 0E 1F 0B 46 4F F0 01 0E 5E 44 C7 F8 3C B0 53 F8 04 1F B3 42 91 F8 94 01 6E F3 46 10 81 F8 94 01 F5 D1 13 68 02 F1 04 09 00 2B 4B D0 3C 64 00 26 BC 6B 05 E0 D4 F8 F4 01 01 36 03 68 B3 42 40 D9 59 F8 26 30 4F EA 86 0B 09 EB 0B 0A 93 F8 94 31 13 F0 60 0F EE D0 D4 F8 F8 31 58 1C 80 00 ?? ?? ?? ?? 80 46 00 28 E5 D0 5A 46 04 30 49 46 ?? ?? ?? ?? D4 F8 F4 01 06 F1 01 0C D0 F8 00 B0 DC 45 80 F0 73 83 09 EB 8B 02 53 46 31 46 A2 F1 04 0A 53 F8 04 2F 92 F8 94 E1 1E F0 60 0F 02 BF 08 EB 81 0E 01 31 CE F8 04 20 53 45 F1 D1 0B F1 FF 3B DC 44 C6 EB 0C 06 C8 F8 00 10 01 36 03 68 B3 42 BE D8 3C 6C 01 2D 40 F2 47 83 BB 6B D7 F8 3C B0 D3 F8 5C 11 0E 1F 0B 46 5E 44 53 F8 04 2F B3 42 92 F8 94 01 6F F3 46 10 82 F8 94 01 F5 D1 78 6C FA 6B ?? ?? ?? ?? 6A 00 C7 F8 20 D0 02 F1 08 03 00 21 23 F0 07 03 4F F0 01 0A AD EB 03 0D 02 23 0D F1 08 0B 9C 46 58 46 3B 64 C7 F8 04 C0 6B 1E FB 62 ?? ?? ?? ?? D7 F8 04 C0 FB 6B 78 6C FC 61 64 46 18 44 04 23 78 62 7B 63 D7 F8 40 C0 78 6C 7B 6C 3B F8 0C 20 DC 44 C7 F8 28 C0 D7 F8 34 C0 01 32 63 44 50 F8 0C 60 D7 F8 40 C0 2B F8 0C 20 D7 F8 2C C0 E2 45 15 D2 78 6A E0 46 50 F8 04 2C A0 F1 04 09 48 46 D2 F8 F0 11 39 B1 04 39 01 E0 96 42 19 D0 51 F8 04 2F 00 2A F9 D1 08 F1 FF 38 C2 45 EB D3 A5 42 A2 46 3A D0 4F EA 44 0C 2A 1B 60 46 00 21 58 44 52 00 A3 00 C7 F8 40 C0 7B 63 01 34 ?? ?? ?? ?? C0 E7 D7 F8 34 E0 CA EB 08 0C 7A 6C 18 46 0E F1 04 01 C7 F8 04 C0 11 44 4F EA 8C 02 ?? ?? ?? ?? 3B F8 14 10 CA EB 05 02 C9 F8 00 60 91 42 D7 F8 04 C0 88 BF A2 46 D5 D8 BB 6A 4F EA 4C 02 38 6C 0B EB 44 01 1E 88 58 44 ?? ?? ?? ?? 2B F8 18 60 98 E7 ?? ?? ?? ?? ?? ?? ?? ?? FC 69 D7 F8 20 B0 DD 46 D7 F8 44 B0 00 23 D7 F8 3C C0 4B F8 0C 30 BF F3 5F 8F BB 6B C3 F8 F0 B1 9B 46 93 F8 96 31 43 F0 01 03 8B F8 96 31 3B 6B 13 B1 18 46 ?? ?? ?? ?? 00 2C 40 F0 7B 82 74 37 BD 46 BD E8 F0 8F 4F F6 FD 72 23 F0 02 03 C7 F6 FF 72 93 42 7F F4 9A AD 55 F8 04 4C 24 21 54 44 20 46 ?? ?? ?? ?? 00 28 40 F0 B1 80 55 F8 08 2C 4F F6 FD 73 C7 F6 FF 73 BC 66 9A 42 00 F0 73 82 D7 F8 3C B0 DB F8 00 30 D8 07 00 F1 7B 81 ?? ?2 0? 0? 07 F1 58 02 ?? ?2 0? 0? 00 92 07 F1 54 00 07 F1 50 01 07 F1 4F 02 ?? ?? ?? ?? 3B 6D 00 2B 40 F0 3E 81 3C 6B 86 B0 D7 F8 30 C0 4F F0 00 0E FB 6E 61 68 DC F8 00 00 0D F1 08 0C A2 68 64 46 D7 F8 30 B0 07 C4 CB F8 04 30 CB F8 00 E0 B9 F1 00 0F 04 D0 49 F8 28 30 08 F1 01 08 FB 6E 93 F8 94 21 12 F0 60 0F 18 BF 62 46 40 F0 0F 81 D7 F8 30 B0 01 24 93 F8 94 21 19 69 38 6C 64 F3 46 12 CB F8 08 C0 00 EB 04 0E 83 F8 94 21 09 B1 DA 68 CA 60 DA 68 02 B1 11 61 DC F8 04 20 11 69 19 61 13 61 19 69 01 B1 CB 60 C7 F8 40 E0 DA 60 3C 6B D7 F8 44 B0 C7 F8 30 C0 5C 45 04 BF 64 46 7C 64 1C E5 00 21 ?? ?? ?? ?? B8 63 00 28 3F F4 F4 AC ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 00 2B 40 F0 92 80 20 46 ?? ?? ?? ?? 83 46 D6 F8 A8 01 00 28 7B D0 43 1C 00 F0 85 80 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 03 2B 38 BF 03 23 83 42 28 BF 18 46 00 23 04 28 82 BF 04 38 B9 6B 01 FB 00 BB 30 46 21 46 0B F1 0E 02 22 F0 07 02 AD EB 02 0D 02 AA ?? ?? ?? ?? 03 78 00 2B 47 D0 04 46 BC E4 00 21 ?? ?? ?? ?? B8 63 00 28 3F F4 48 AF ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 00 2B 54 D1 20 46 ?? ?? ?? ?? 83 46 D6 F8 A8 01 00 28 00 F0 16 82 41 1C 00 F0 1E 82 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 03 2B 38 BF 03 23 83 42 28 BF 18 46 04 28 82 BF 04 38 B9 6B 01 FB 00 BB 30 46 21 46 0B F1 0E 03 23 F0 07 03 AD EB 03 0D 00 23 02 AA ?? ?? ?? ?? 03 78 00 2B 40 F0 EE 81 4F F6 FD 72 55 F8 08 1C C7 F6 FF 72 91 42 00 F0 DC 81 D7 F8 3C B0 DB F8 00 30 DA 07 7F F5 92 AC ?? ?2 0? 0? 21 46 ?? ?2 0? 0? ?? ?? ?? ?? 89 E4 73 68 1B 78 00 2B 39 D1 ?? ?? ?? ?? 41 1E C6 F8 A8 01 03 31 7F F6 7B AF 00 20 7A E7 00 20 ?? ?2 0? 0? 21 46 02 46 ?? ?2 0? 0? ?? ?? ?? ?? DB F8 5C 31 00 2B 3F F4 57 AD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 F9 12 ?? ?? ?? ?? 96 46 3C 64 D7 F8 2C A0 FF F7 D5 BB D7 F8 2C B0 ?? ?2 0? 0? 02 46 ?? ?2 0? 0? 0C 20 DB F8 04 10 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? F9 22 ?? ?? ?? ?? 48 68 98 42 00 F0 5D 81 0A 46 91 68 00 29 F7 D1 BC E8 07 00 3C 6B 20 60 61 60 A2 60 2D E4 04 46 18 46 9B 46 ?? ?? ?? ?? 59 46 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 02 A8 ?? ?? ?? ?? 7E 6D 05 46 30 46 ?? ?? ?? ?? 31 46 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 02 A8 ?? ?? ?? ?? 97 F8 4F 30 78 65 00 2B 3F F4 CC AC 58 46 ?? ?? ?? ?? C7 E4 72 68 13 78 4B B9 D7 F8 10 C0 D7 F8 0C B0 DC F8 00 30 1A 68 00 2A 08 BF 5A 46 ?? ?2 0? 0? 21 46 ?? ?2 0? 0? ?? ?? ?? ?? 6F E6 4F EA 85 0C 78 6C 62 46 C7 F8 3C C0 ?? ?? ?? ?? 01 2D 7F F6 22 AE 8F E5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 4A 22 ?? ?? ?? ?? ?? ?2 0? 0? F9 6A ?? ?2 0? 0? D3 F8 00 80 88 45 7F F4 E6 AC 00 2D 3F F4 E3 AC D7 F8 28 90 A3 46 D8 F8 5C 31 53 F8 29 60 B0 45 04 D0 D6 F8 D0 31 93 B1 5B 68 83 B1 09 F1 01 09 A9 45 F0 D1 5C 46 CE E4 93 F8 95 11 89 07 7F F5 B2 AC D0 F8 60 11 01 39 C0 F8 60 11 B1 E4 D6 F8 F0 30 00 2B 54 D1 D6 F8 E8 A0 BA F1 00 0F 4F D1 78 6C 31 46 FF F7 96 FA A8 42 04 46 38 D8 10 B3 7B 6C 51 46 53 F8 04 0B 90 F8 94 E1 6A F3 46 1E 80 F8 94 E1 01 31 8C 42 15 D0 53 F8 04 2B 92 F8 94 01 6F F3 46 10 82 F8 94 01 00 29 F2 D0 53 F8 04 2C 12 6E 00 2A ED D0 96 F8 95 21 42 F0 80 02 86 F8 95 21 E6 E7 A2 1C 4F EA 82 0A 50 46 ?? ?? ?? ?? 03 46 C6 F8 D0 01 18 B3 00 F1 08 06 AA F1 08 02 30 46 79 6C 5C 60 1E 60 ?? ?? ?? ?? A5 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 31 22 ?? ?? ?? ?? ?? ?2 0? 0? 71 68 ?? ?2 0? 0? 16 20 00 22 ?? ?? ?? ?? ?? ?2 0? 0? 02 46 D8 F8 04 10 ?? ?2 0? 0? 0C 20 ?? ?? ?? ?? FC 6A ?? ?2 0? 0? 02 46 ?? ?2 0? 0? 0C 20 61 68 ?? ?? ?? ?? 18 46 ?? ?? ?? ?? FF F7 F0 BB B4 F1 FF 3F 14 BF 20 46 00 20 79 6D 00 22 3B 6D ?? ?? ?? ?? D7 F8 38 C0 78 6C FA 6B DC F8 5C 11 ?? ?? ?? ?? 56 E5 31 46 66 46 A2 E4 AB 00 FB 63 55 E4 D7 F8 3C C0 DC F8 00 30 DB 07 1B D4 ?? ?2 0? 0? 07 F1 58 02 ?? ?2 0? 0? 00 92 07 F1 54 00 07 F1 50 01 07 F1 4F 02 ?? ?? ?? ?? 38 6D 00 28 3F F4 8E AD 97 F8 4F 30 00 2B 3F F4 F5 AA ?? ?? ?? ?? FF F7 F1 BA 72 68 13 78 4B B9 D7 F8 10 B0 D7 F8 0C C0 DB F8 00 30 1A 68 00 2A 08 BF 62 46 ?? ?2 0? 0? 21 46 ?? ?2 0? 0? ?? ?? ?? ?? CE E7 D7 F8 30 B0 14 46 18 69 CB F8 08 C0 91 68 D7 F8 44 B0 59 45 18 BF 5A 46 89 68 A1 60 08 B1 D9 68 C1 60 D9 68 01 B1 08 61 DC F8 04 00 01 69 19 61 03 61 19 69 01 B1 CB 60 D8 60 7A 64 95 E5 18 46 ?? ?2 0? 0? 21 46 02 46 ?? ?2 0? 0? ?? ?? ?? ?? 04 46 21 E5 73 68 1B 78 4B B9 ?? ?? ?? ?? 42 1E C6 F8 A8 01 03 32 7F F6 E2 AD 00 20 E1 E5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 2D 12 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "dlinfo_doit"
		size = 138
		refs = "0072 .LC0 007e _dl_signal_error 0084 _dl_tls_get_addr_soft 0042 _dl_rtld_di_serinfo 005e strcpy"
	strings:
		$1 = { 83 68 10 B5 01 3B 04 46 42 68 09 2B 30 D8 DF E8 03 F0 0C 10 2F 13 1A 21 2F 2F 28 05 D2 F8 40 02 00 28 2E D1 E3 68 18 60 10 BD 92 69 C3 68 1A 60 10 BD C3 68 1A 60 10 BD 10 46 E1 68 00 22 BD E8 10 40 ?? ?? ?? ?? 10 46 E1 68 01 22 BD E8 10 40 ?? ?? ?? ?? C0 68 D2 F8 A8 11 BD E8 10 40 ?? ?? ?? ?? C3 68 00 21 19 60 D2 F8 40 22 1A 60 10 BD 00 20 ?? ?2 0? 0? 01 46 02 46 ?? ?2 0? 0? ?? ?? ?? ?? 10 46 ?? ?? ?? ?? CC E7 }
	condition:
		$1
}

rule file_243_1_0 {
	meta:
		name = "__dlinfo"
		size = 40
		refs = "0006 dlinfo_doit 0016 _dlerror_run"
	strings:
		$1 = { 00 B5 85 B0 01 90 ?? ?2 0? 0? 02 91 ?? ?2 0? 0? 69 46 00 93 03 92 ?? ?? ?? ?? 00 38 18 BF 6F F0 00 00 05 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_nl_init_alt_digit"
		size = 116
		refs = "001a malloc 002e __rawmemchr 004c _nl_cleanup_time"
	strings:
		$1 = { 70 B5 05 46 46 69 D6 B1 74 69 BC B9 D5 F8 E0 50 01 23 73 61 95 B1 4F F4 C8 70 ?? ?? ?? ?? F0 60 08 B9 0B E0 F0 68 05 51 00 21 28 46 04 34 ?? ?? ?? ?? B4 F5 C8 7F 00 F1 01 05 F3 D1 70 BD 1C 20 ?? ?? ?? ?? 68 61 00 28 F8 D0 03 46 ?? ?2 0? 0? ?? ?2 0? 0? 2A 61 43 F8 04 6B 04 33 46 60 43 F8 04 6B 43 F8 04 6B 43 F8 04 6B 43 F8 04 6B 1E 60 06 46 C9 E7 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_nl_get_alt_digit"
		size = 106
		refs = "0012 __pthread_rwlock_wrlock 001c __libc_setlocale_lock 0038 __pthread_rwlock_unlock"
	strings:
		$1 = { 63 28 38 B5 05 46 0C 46 2D D8 D1 F8 E0 30 18 78 00 B3 ?? ?2 0? 0? ?? ?2 0? 0? 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 63 69 A3 B1 5A 69 92 B1 DB 68 B3 B1 53 F8 25 40 ?? ?2 0? 0? ?? ?2 0? 0? 3B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 20 46 38 BD 20 46 38 BD 20 46 FF F7 98 FF 63 69 00 2B E6 D1 00 24 E8 E7 00 20 38 BD }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "_nl_get_walt_digit"
		size = 198
		refs = "0014 __pthread_rwlock_wrlock 001e __libc_setlocale_lock 0040 malloc 0056 wcschr 006c __pthread_rwlock_unlock 009e _nl_cleanup_time"
	strings:
		$1 = { 63 28 F8 B5 07 46 0D 46 46 D8 D1 F8 AC 31 18 68 00 28 39 D0 ?? ?2 0? 0? ?? ?2 0? 0? 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 6E 69 6E B3 B4 69 C4 B9 D5 F8 AC 51 01 23 B3 61 9D B1 4F F4 C8 70 ?? ?? ?? ?? 30 61 28 B3 03 46 00 E0 33 69 1D 51 28 46 00 21 04 34 ?? ?? ?? ?? B4 F5 C8 7F 00 F1 04 05 F3 D1 33 69 AB B1 53 F8 27 40 ?? ?2 0? 0? ?? ?2 0? 0? 3B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 20 46 F8 BD 20 46 F8 BD 1C 20 ?? ?? ?? ?? 68 61 18 B9 00 24 E9 E7 00 20 F8 BD 03 46 ?? ?2 0? 0? ?? ?2 0? 0? 2A 61 43 F8 04 6B 04 33 46 60 43 F8 04 6B 43 F8 04 6B 43 F8 04 6B 43 F8 04 6B 1E 60 06 46 B3 E7 }
	condition:
		$1
}

rule file_245_3_0 {
	meta:
		name = "_nl_parse_alt_digit"
		size = 184
		refs = "0016 __pthread_rwlock_wrlock 0020 __libc_setlocale_lock 004e strlen 005e strncmp 0072 __pthread_rwlock_unlock"
	strings:
		$1 = { 2D E9 F8 4F 0C 46 D1 F8 AC 31 83 46 D0 F8 00 A0 1B 68 00 2B 4D D0 ?? ?2 0? 0? ?? ?2 0? 0? 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 63 69 00 2B 35 D0 5A 69 9A B3 DB 68 00 2B 36 D0 00 27 A3 F1 04 08 3C 46 4F F0 FF 39 58 F8 04 6F 30 46 ?? ?? ?? ?? 51 46 05 46 30 46 BD 42 2A 46 06 D9 ?? ?? ?? ?? 00 28 08 BF A1 46 08 BF 2F 46 01 34 64 2C EA D1 ?? ?2 0? 0? ?? ?2 0? 0? 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B9 F1 FF 3F 04 D0 DB F8 00 30 3B 44 CB F8 00 30 48 46 BD E8 F8 8F 20 46 FF F7 DA FE 63 69 00 2B C5 D1 00 27 4F F0 FF 39 DF E7 4F F0 FF 39 EF E7 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "is_dst"
		size = 168
	strings:
		$1 = { F0 B4 0C 78 16 78 7B 2C 09 BF 4F F0 01 0C 4F F0 00 0C 4C 78 61 44 A6 42 2C D1 6C B3 0E 46 00 25 00 E0 54 B3 16 F8 01 4F 01 35 12 F8 01 7F BC 42 F7 D0 BC F1 00 0F 08 D0 7D 2C 04 BF 01 F1 FF 31 02 35 06 D0 00 20 F0 BC 70 47 2F 2C 18 BF 00 2C 04 D1 04 9A AA B9 28 46 F0 BC 70 47 43 B1 3A 2C 18 BF 60 46 EF D1 F4 E7 01 30 81 42 F3 D0 A3 B9 18 46 E8 E7 00 25 DC E7 25 46 BC F1 00 0F E1 D1 E7 E7 4A 5D 2F 2A 18 BF 00 2A ED D0 00 2B EF D0 3A 2A D7 D1 01 30 81 42 DD D0 11 F8 02 0C 3A 28 0C BF 28 46 00 20 CE E7 }
	condition:
		$1
}

rule file_248_1_0 {
	meta:
		name = "is_trusted_path_normalize"
		size = 244
		refs = "0058 .LANCHOR0 0064 memcmp"
	strings:
		$1 = { B0 B5 00 AF 00 29 58 D0 02 78 3A 2A 08 BF 01 F1 FF 31 01 F1 10 01 08 BF 42 78 21 F0 07 01 08 BF 01 30 AD EB 01 0D 6D 46 6B 46 42 B1 2F 2A 44 78 29 D0 1A 70 22 46 01 30 01 33 00 2A F6 D1 AB 42 1A 46 03 D0 13 F8 01 1C 2F 29 02 D0 01 33 2F 21 11 70 5C 1B 04 2C 22 D9 ?? ?2 0? 0? 29 46 ?? ?2 0? 0? 05 22 ?? ?? ?? ?? 00 28 3F D0 08 2C 16 D9 29 46 09 22 1E 48 ?? ?? ?? ?? D0 F1 01 00 38 BF 00 20 BD 46 B0 BD 2E 2C 0C D0 AB 42 D1 D9 13 F8 01 1C 2F 29 04 BF 01 30 22 46 CA D1 C5 E7 00 20 BD 46 B0 BD 81 78 2E 29 0A D0 2F 29 18 BF 00 29 04 BF 02 30 0A 46 B8 D0 E7 E7 08 46 BD 46 B0 BD C1 78 2F 29 18 BF 00 29 DF D1 AB 42 0B D9 13 F8 01 2C 01 3B 2F 2A 04 D1 05 E0 13 F8 01 2D 2F 2A 01 D0 AB 42 F9 D1 03 30 0A 46 9E E7 01 20 D7 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_2_0 {
	meta:
		name = "local_strdup"
		size = 32
		refs = "0004 strlen 000c malloc 001a memcpy"
		altNames = "__strdup"
	strings:
		$1 = { 38 B5 05 46 ?? ?? ?? ?? 44 1C 20 46 ?? ?? ?? ?? 28 B1 29 46 22 46 BD E8 38 40 ?? ?? ?? ?? 38 BD }
	condition:
		$1
}

rule file_248_3_0 {
	meta:
		name = "fillin_rpath"
		size = 496
		refs = "0004 _dl_all_dirs 000a .LANCHOR1 0020 .LANCHOR2 0036 __strsep_g 0042 strlen 0080 curwd.12769 00a4 memcmp 00fc malloc 0112 mempcpy 015c memcpy 01b6 .LANCHOR0 01da .LC0 01e8 _dl_signal_error"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? 8B B0 ?? ?2 0? 0? 0D F1 28 08 8B 46 ?? ?2 0? 0? 00 26 ?? ?2 0? 0? 08 94 ?? ?2 0? 0? 03 92 ?? ?2 0? 0? 04 93 48 F8 04 0D 07 94 40 46 03 99 ?? ?? ?? ?? 05 46 00 28 00 F0 B1 80 ?? ?? ?? ?? 04 46 B8 B1 01 28 0C D9 43 1E EA 5C 2F 2A 06 D0 8E E0 5A 1E A9 5C 2F 29 40 F0 8B 80 13 46 01 2B F7 D1 2B 78 2F 2B 40 F0 AF 80 04 9C 00 2C DD D1 01 24 06 E0 04 9B 00 2B D8 D1 ?? ?2 0? 0? ?? ?2 0? 0? D9 F8 00 30 02 93 13 B3 1F 46 01 E0 3F 68 F7 B1 3B 69 A3 42 FA D1 28 46 F9 68 22 46 ?? ?? ?? ?? 00 28 F3 D1 00 2E 7F D0 DB F8 00 30 BB 42 BC D0 5B 46 01 30 B0 42 05 D0 53 F8 04 2F BA 42 F8 D1 86 42 B2 D1 83 00 46 1C 4B F8 03 70 AD E7 15 9B 00 2B 61 D0 15 98 ?? ?? ?? ?? 01 30 05 90 08 9B 1F 68 7A 1D 92 00 01 92 53 1C 06 93 18 46 05 9B 20 44 18 44 ?? ?? ?? ?? 01 9A 82 46 00 28 68 D0 10 44 29 46 22 46 CA F8 0C 00 ?? ?? ?? ?? 07 9B 00 21 1A 68 A2 42 4F F0 00 02 38 BF 1C 60 01 70 51 46 CA F8 10 40 28 78 2F 28 14 BF 02 20 00 20 2F B1 01 32 48 61 BA 42 01 F1 04 01 F9 D1 14 9B CA F8 04 30 15 9B 00 2B 3F D0 06 98 05 9A 20 44 15 99 50 44 ?? ?? ?? ?? CA F8 08 00 02 9B C9 F8 00 A0 CA F8 00 30 4B F8 26 A0 01 36 5D E7 03 46 2F 22 5C 1C EA 54 04 9B 00 2B 81 D0 05 2C 16 D0 09 2C 7F F4 52 AF 17 48 29 46 22 46 ?? ?? ?? ?? 00 28 7F F4 4A AF 73 E7 05 93 A0 E7 4B F8 26 00 58 46 0B B0 BD E8 F0 8F 33 46 01 26 8C E7 ?? ?2 0? 0? 29 46 ?? ?2 0? 0? 22 46 ?? ?? ?? ?? 00 28 7F F4 33 AF 5C E7 01 23 D2 E7 15 9C CA F8 08 40 C4 E7 ?? ?2 0? 0? 01 46 02 46 ?? ?2 0? 0? 0C 20 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_4_0 {
	meta:
		name = "add_name_to_object.isra.2"
		size = 142
		refs = "0016 strcmp 0024 strlen 0030 malloc 003e memcpy 005c .LC2 0060 .LC3 0064 __PRETTY_FUNCTION__.12750 0078 __assert_fail 007c .LC1 008a _dl_signal_error"
	strings:
		$1 = { 2D E9 F0 41 04 46 0E 46 18 B9 20 E0 65 68 45 B1 2C 46 30 46 21 68 ?? ?? ?? ?? 00 28 F6 D1 BD E8 F0 81 30 46 ?? ?? ?? ?? 02 46 0D 30 02 F1 01 08 ?? ?? ?? ?? 07 46 08 B3 31 46 42 46 0C 30 ?? ?? ?? ?? 7D 60 BD 60 38 60 67 60 BD E8 F0 81 08 46 ?? ?? ?? ?? 0D 30 ?? ?? ?? ?? 78 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 D5 12 ?? ?? ?? ?? ?? ?2 0? 0? 31 46 ?? ?2 0? 0? 0C 20 00 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_5_0 {
	meta:
		name = "lose.isra.3"
		size = 72
		refs = "0014 __close 0022 free 0038 _dl_debug_state 0044 _dl_signal_error"
	strings:
		$1 = { 90 46 4A 1C 08 B5 81 46 9A 46 02 9C 03 9E 04 9D 02 D0 08 46 ?? ?? ?? ?? 2C B1 D4 F8 A8 01 43 1C 01 D0 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 50 46 ?? ?? ?? ?? 1D B1 00 23 EB 60 ?? ?? ?? ?? 48 46 41 46 33 46 00 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_6_0 {
	meta:
		name = "_dl_map_object_from_fd"
		size = 2756
		refs = "0016 _dl_debug_initialize 0024 __fxstat64 0034 _dl_ns 007c __close 0082 free 00a2 _dl_debug_mask 00e2 _dl_new_object 0152 _dl_tls_dtv_slotinfo_list 0156 _dl_tls_max_dtv_idx 015a _dl_pagesize 0220 _dl_use_load_bias 0244 __mmap 02d6 memset 0326 .LC18 0422 _dl_next_tls_modid 0570 _dl_stack_flags 05c6 _dl_setup_hash 05de _dl_profile 05f2 _dl_initfirst 061e _dl_add_to_namespace_list 0698 __mprotect 06a2 _dl_debug_state 06c0 __lseek 06ca __libc_read 071a .LC20 0772 .LC9 07a6 .LC17 07be malloc 07cc memcpy 07e2 .LC13 07ee .LC12 080e __munmap 0824 .LC10 084e .LC27 0856 _dl_debug_printf 08a8 memmove 08be .LC28 08ea .LC8 0900 .LANCHOR1 0904 _dl_make_stack_executable_hook 0926 .LC11 0930 .LC7 0956 .LC19 0976 .LC23 097a .LC24 097e __PRETTY_FUNCTION__.12634 0990 __assert_fail 0994 .LC25 09b2 .LC26 09d2 .LC4 09e0 .LC21 09f6 .LC22 09fa .LC3 09fe __PRETTY_FUNCTION__.12889 0a16 .LC5 0a5a _dl_tls_setup 0a60 _dl_allocate_tls 0a70 __libc_do_syscall 0a7e _dl_deallocate_tls 0a82 .LC15 0a8e .LC6 0a98 .LC16 0ab4 .LC14 0ac0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F BD B0 0A AF B8 62 00 20 F9 63 D7 F8 00 11 3A 64 7B 62 ?? ?? ?? ?? F9 6B 07 F1 60 02 F8 62 03 20 ?? ?? ?? ?? 00 28 C0 F2 D1 84 D7 F8 00 41 4C 22 ?? ?2 0? 0? ?? ?2 0? 0? 02 FB 04 F2 9E 58 4E B3 D7 E9 30 45 D7 E9 18 89 01 E0 F6 68 16 B3 96 F8 95 31 9B 06 F9 D4 06 F5 F0 73 D3 E9 00 23 AB 42 08 BF A2 42 F1 D1 06 F5 EC 73 D3 E9 00 23 4B 45 08 BF 42 45 E9 D1 F8 6B ?? ?? ?? ?? 78 6A ?? ?? ?? ?? B9 6A F0 69 FF F7 4D FF 30 46 CC 37 BD 46 BD E8 F0 8F D7 F8 F8 60 70 07 00 F1 7A 83 ?? ?2 0? 0? ?? ?2 0? 0? BC 63 23 68 59 06 00 F1 96 84 FE 6A F3 68 00 2B 00 F0 F0 82 01 2B 04 BF 00 24 7C 61 40 F0 96 84 D7 F8 F8 60 00 96 D7 F8 00 41 78 6A 01 94 B9 6A D7 F8 F4 20 D7 F8 F0 30 ?? ?? ?? ?? 05 46 00 28 00 F0 94 84 3E 6C D7 F8 40 C0 33 8E 31 6A 30 68 5C 01 F2 69 BC F8 14 C0 66 18 86 42 A5 F8 58 31 C5 F8 54 21 C7 F8 1C C0 00 F2 CA 82 3E 6C 31 44 01 F1 04 0B 03 EB 43 03 C7 F8 18 D0 5C 44 DB 00 A3 45 03 F1 08 03 AD EB 03 0D 0D F1 2B 03 4F EA 93 03 3B 62 4F EA 83 08 80 F0 30 83 4E F2 51 59 00 24 4E F2 52 56 FC 64 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 46 F2 40 24 C6 F2 74 49 C6 F2 74 46 C7 F2 51 34 BE 65 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? BC 64 07 26 C7 F8 50 80 4F F0 00 0A 39 63 7A 63 0B F1 20 04 7B 65 C8 46 7E 64 10 E0 43 45 00 F0 50 81 B9 6D 8B 42 00 F0 43 81 07 2B 00 F0 1E 81 B5 F8 58 31 20 34 0B EB 43 13 9E 42 1A D2 54 F8 20 3C 26 46 06 2B 00 F0 B5 80 E7 D8 01 2B 00 F0 B6 80 02 2B EC D1 54 F8 0C 3C 20 34 54 F8 38 2C DB 08 A5 F8 5A 31 B5 F8 58 31 AA 60 0B EB 43 13 9E 42 E4 D3 D7 F8 50 80 BA F1 00 0F 00 F0 D5 82 0A F1 FF 36 FC 69 D8 F8 00 00 06 EB 46 06 03 2C 4F EA C6 06 08 EB 06 03 DB 68 C0 EB 03 03 FB 65 40 F0 00 84 ?? ?2 0? 0? D8 F8 14 20 ?? ?2 0? 0? 19 46 40 F6 02 03 D4 F8 00 E0 FC 6B 00 EA 0E 00 00 94 D8 F8 10 40 01 94 ?? ?? ?? ?? 42 1C C5 F8 AC 01 6A D0 D8 F8 00 30 FA 6D FC 6C 02 44 C0 1A C5 F8 B0 21 28 60 00 2C 40 F0 10 82 95 F8 95 31 44 46 43 F0 40 03 85 F8 95 31 62 69 53 07 41 BF 2B 68 61 68 5B 18 C5 F8 B4 31 D5 F8 50 31 00 2B 00 F0 4A 82 E3 68 A6 68 B3 42 2B D9 ?? ?2 0? 0? 29 68 ?? ?2 0? 0? 0E 44 0B 44 DC F8 00 10 01 F1 FF 39 48 42 B1 44 09 EA 00 09 99 45 28 BF 99 46 B1 45 14 D9 12 F0 02 0F 00 F0 39 83 C6 EB 09 02 30 46 00 21 FB 60 C7 F8 10 C0 ?? ?? ?? ?? 62 69 FB 68 12 F0 02 0F D7 F8 10 C0 00 F0 3D 83 99 45 C0 F0 05 82 18 34 0A EB 4A 03 08 EB C3 03 9C 42 80 F0 AA 80 94 E8 03 00 81 42 B6 D9 FE 6B 09 1A D5 F8 00 E0 40 F6 12 03 62 69 00 96 70 44 26 69 01 96 ?? ?? ?? ?? 01 30 A7 D1 ?? ?2 0? 0? ?? ?2 0? 0? 16 E3 54 F8 18 3C C5 F8 50 31 38 E7 7A 6D 54 F8 04 0C 11 68 01 F1 FF 3C 10 EA 0C 0C 40 F0 50 82 54 F8 18 3C 01 38 54 F8 1C EC BB 60 CE EB 03 03 18 42 40 F0 3F 82 54 F8 10 3C 0A EB 4A 09 BA 68 08 46 0A F1 01 0C 01 38 1A 44 FA 65 D7 F8 5C A0 49 42 3A 6D BC F1 01 0F 82 44 B8 68 02 EB C9 03 BA 68 00 EA 01 00 78 60 54 F8 0C 0C 0E EA 01 0E 0A EA 01 01 02 44 38 6D BA 60 7A 68 40 F8 39 20 FA 6D B8 68 C3 F8 10 E0 9A 60 D8 60 59 60 07 D9 F9 6C 53 F8 14 2C 78 68 90 42 18 BF 01 21 F9 64 54 F8 08 2C E2 46 B9 6C 02 F0 07 02 92 00 41 FA 02 F2 02 F0 0F 02 5A 61 E1 E6 54 F8 0C 3C 00 2B 3F F4 DD AE 54 F8 04 2C C5 F8 30 32 C5 F8 34 22 12 BB 54 F8 18 1C C5 F8 38 22 95 F8 94 21 54 F8 10 3C 02 F0 03 02 C5 F8 28 12 01 2A C5 F8 2C 32 40 F0 17 83 ?? ?? ?? ?? C5 F8 40 02 BF E6 54 F8 18 3C 54 F8 0C 2C C5 F8 48 32 C5 F8 4C 22 B6 E6 54 F8 08 3C 7B 64 B2 E6 54 F8 18 1C 01 3A 0A 40 C5 F8 38 22 D9 E7 BC 69 A9 68 A5 46 00 29 00 F0 86 81 2C 68 0A 19 AA 60 00 2A 00 F0 7D 81 0B 59 05 F1 20 00 00 2B 40 F0 E4 80 00 2C 2E D0 2B 6B 13 B1 5A 68 22 44 5A 60 EB 6A 13 B1 5A 68 22 44 5A 60 6B 6B 13 B1 5A 68 22 44 5A 60 AB 6B 13 B1 5A 68 22 44 5A 60 EB 6B 13 B1 5A 68 22 44 5A 60 6B 6E 13 B1 5A 68 22 44 5A 60 EB 6F 13 B1 5A 68 22 44 5A 60 D5 F8 E4 30 13 B1 5A 68 22 44 5A 60 D5 F8 4C 31 13 B1 5A 68 22 44 5A 60 2B 6F 2B B1 5B 68 07 2B 18 BF 11 2B 40 F0 46 82 EB 6B 23 B1 6B 6C 5B 68 0C 2B 40 F0 4E 82 6B 6E 23 B1 EB 6E 5B 68 08 2B 40 F0 56 82 D5 F8 98 20 62 B1 53 68 9C 07 48 BF 2A 66 C5 F8 08 32 58 07 48 BF AA 67 19 07 48 BF C5 F8 80 20 D5 F8 B8 30 00 2B 00 F0 18 81 BC 6B 5A 68 23 68 C5 F8 04 22 5B 06 00 F1 81 81 13 46 D6 07 44 BF D5 F8 B8 20 C5 F8 80 20 D5 F8 94 20 0A B1 00 22 EA 65 5C 06 00 F1 4E 81 D5 F8 50 31 00 2B 00 F0 27 81 2A 68 13 44 C5 F8 50 31 ?? ?2 0? 0? 7C 6C ?? ?2 0? 0? 1B 68 24 EA 03 03 D8 07 00 F1 BD 81 D5 F8 28 32 1B B1 2A 68 13 44 C5 F8 28 32 F8 6B ?? ?? ?? ?? 00 28 40 F0 A5 81 95 F8 94 31 03 F0 03 02 01 2A 00 F0 D1 80 BC 6B D5 F8 54 31 28 68 22 68 03 44 C5 F8 54 31 51 06 00 F1 7A 81 28 46 ?? ?? ?? ?? D7 F8 F8 60 32 07 03 D4 2B 6E 00 2B 40 F0 50 81 D5 F8 04 32 ?? ?2 0? 0? ?? ?2 0? 0? D7 E9 30 01 9B 06 05 F5 EC 7E 48 BF ?? ?2 0? 0? 05 F5 F0 76 48 BF ?? ?2 0? 0? 24 68 48 BF 1D 60 D7 E9 18 23 CE E9 00 23 C6 E9 00 01 00 2C 40 F0 25 81 28 46 D7 F8 00 11 ?? ?? ?? ?? 28 46 CC 37 BD 46 BD E8 F0 8F C3 F1 E0 43 21 33 40 F8 23 20 52 F8 08 3F 00 2B 3F F4 1C AF 21 2B F6 D9 4F F6 FF 71 C6 F6 FF 71 C9 1A 0F 29 EC D9 43 F3 1E 01 0E 1D 07 D9 8B 00 83 F0 03 03 DB 43 03 44 C3 F8 C8 20 E5 E7 4F F6 FF 51 C6 F6 FF 71 C9 1A 0B 29 31 D8 A0 EB 83 03 03 F1 40 43 A3 F5 E6 63 1A 60 D6 E7 3C 6A 00 22 D8 F8 04 30 56 F8 24 10 18 44 C9 1A ?? ?? ?? ?? E4 E5 01 24 F4 60 ?? ?? ?? ?? 7C 61 0F E5 04 F1 0E 03 EC 46 00 22 F8 6B DB 08 AC EB C3 0C E5 46 0D F1 28 0B ?? ?? ?? ?? F8 6B 59 46 22 46 ?? ?? ?? ?? A0 42 40 F0 DD 81 B5 F8 58 31 5C 01 20 E5 4F F6 FF 61 C6 F6 FF 71 C9 1A 0A 29 9F BF A0 EB 83 03 03 F1 40 43 A3 F5 40 73 1A 60 9D E7 62 69 C9 EB 03 01 4F F0 00 0E 4F F0 FF 33 48 46 8D E8 08 40 32 23 ?? ?? ?? ?? 01 30 7F F4 EB AD ?? ?2 0? 0? ?? ?2 0? 0? 1C E1 3E 6C 23 69 30 6A 83 42 3F F6 B0 AD B6 F8 30 E0 61 68 26 68 19 44 00 EB 4E 1E 89 1B 71 45 22 BF 80 19 C3 EB 00 03 C5 F8 50 31 9F E5 FE 69 02 2E 04 BF 60 F3 01 03 85 F8 94 31 26 E7 D5 F8 04 32 F3 E6 D5 F8 04 32 F5 E6 FE 69 03 2E F9 D1 ?? ?2 0? 0? 08 46 ?? ?2 0? 0? FA 6A 7E 69 00 95 01 93 00 2E 08 BF 00 22 02 92 F9 6B BA 6A 7B 6A FF F7 11 FC 78 6A ?? ?? ?? ?? F8 6B ?? ?? ?? ?? 00 20 3E E7 ?? ?2 0? 0? 00 20 ?? ?2 0? 0? BE 69 B5 46 E2 E7 3E 6C 34 8E 64 01 20 46 ?? ?? ?? ?? 00 28 00 F0 B4 80 59 46 22 46 ?? ?? ?? ?? 95 F8 94 31 43 F0 80 03 85 F8 94 31 C5 F8 50 01 C6 E6 ?? ?2 0? 0? 60 46 ?? ?2 0? 0? E0 E7 ?? ?2 0? 0? 00 20 ?? ?2 0? 0? DA E7 D7 F8 F8 60 00 2E BF F6 AD AE D5 F8 AC 01 D5 F8 B0 11 09 1A ?? ?? ?? ?? E8 69 83 68 0B B9 ?? ?? ?? ?? 95 F8 94 31 D8 09 04 BF ?? ?2 0? 0? ?? ?2 0? 0? A6 D0 D5 F8 50 01 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 20 9C E7 22 F4 0E 63 33 F0 09 01 3F F4 79 AE ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? D5 F8 04 32 1A 46 6F E6 AB 6D 00 2B 3F F4 D7 AE 6A 6B 5B 68 E8 69 51 68 19 44 FF F7 58 FB CE E6 D5 F8 CC 31 05 F5 AE 71 1A 68 8A 42 3F F4 A8 AE D5 F8 64 31 01 20 D5 F8 C8 21 02 F1 80 42 1D 60 01 3A D5 F8 CC 11 C5 F8 68 01 92 00 08 1D ?? ?? ?? ?? D5 F8 CC 31 05 F5 B2 72 1A 60 90 E6 AA 68 08 26 00 90 ?? ?2 0? 0? FC 6D 31 46 04 93 ?? ?2 0? 0? 01 96 33 46 02 94 03 96 05 96 D5 F8 50 41 07 96 06 94 B5 F8 58 41 08 94 ?? ?? ?? ?? 6C E6 ?? ?2 0? 0? ?? ?2 0? 0? 73 4A 1D EE 70 1F 7A 44 12 68 88 58 3D E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? D7 F8 FC 00 59 68 12 68 41 F0 07 01 59 60 90 47 00 28 3F F4 30 AE ?? ?2 0? 0? ?? ?2 0? 0? 25 E7 ?? ?2 0? 0? ?? ?2 0? 0? DB E7 30 40 42 F0 02 02 FB 60 C7 F8 10 C0 ?? ?? ?? ?? FB 68 D7 F8 10 C0 00 28 BF F6 B9 AC ?? ?2 0? 0? ?? ?2 0? 0? BC 69 A5 46 C6 E7 DC F8 00 10 FB 60 48 42 30 40 ?? ?? ?? ?? FB 68 B9 E4 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 73 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 78 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 7C 22 ?? ?? ?? ?? 00 24 ?? ?2 0? 0? 7C 61 25 46 ?? ?2 0? 0? 88 E7 ?? ?2 0? 0? B9 6A ?? ?2 0? 0? D7 F8 00 21 ?? ?? ?? ?? FF F7 5F BB ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 1A 42 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 68 E7 D7 F8 F8 60 16 F0 00 52 36 D0 FC 6C 2A 68 95 F8 95 31 84 F0 01 01 FE 6D 10 44 61 F3 86 13 C5 F8 AC 01 85 F8 95 31 30 44 44 46 C5 F8 B0 01 50 E4 3A 6B 13 68 00 2B 7F F4 E4 AC ?? ?? ?? ?? 48 BB ?? ?? ?? ?? 03 46 28 B3 4F F0 05 0C C0 F2 0F 0C ?? ?? ?? ?? 10 F5 80 5F 14 D9 18 46 01 21 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 20 90 E6 ?? ?2 0? 0? ?? ?2 0? 0? 2C E7 ?? ?2 0? 0? 10 46 ?? ?2 0? 0? 85 E6 79 6B 0B 68 01 33 0B 60 C5 F8 40 32 FF F7 7C BB ?? ?2 0? 0? 0C 20 ?? ?2 0? 0? 77 E6 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_7_0 {
	meta:
		name = "open_verify.isra.4"
		size = 932
		refs = "0014 __open 0040 __libc_read 0064 memcmp 0158 _dl_osversion 01ac __close 01dc __lseek 01f0 .LC6 0242 .LC34 0298 .LC37 02a4 .LC38 02b0 .LC29 02c2 .LC30 02ce .LC39 02dc strlen 02f2 memcpy 02fc free 0304 __libc_errno 032e .LC31 0346 .LC32 035a .LC33 0380 .LC36 0388 .LC35"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 04 AF 0E 46 4F F4 00 21 15 46 7B 60 B8 60 ?? ?? ?? ?? B0 F1 FF 3F 81 46 00 F0 AA 80 B8 49 00 23 1D EE 70 0F 1A 46 F8 60 79 44 09 68 43 50 33 60 B1 18 48 46 C2 F5 00 72 04 31 ?? ?? ?? ?? 34 68 00 28 04 DD 04 44 34 60 33 2C 40 F2 20 81 33 2C 40 F3 F0 80 06 F1 04 08 AA 49 40 46 08 22 ?? ?? ?? ?? 00 28 40 F0 02 81 B2 6A 4F F4 80 63 C0 F2 00 53 02 F0 FF 22 22 F4 7B 42 9A 42 00 F0 82 80 33 7B 00 2B 79 D1 06 F1 0D 00 9E 49 07 22 ?? ?? ?? ?? 00 28 76 D1 B3 69 01 2B 40 F0 FA 80 F3 8A 28 2B 7D D1 B3 8A 02 3B 9B B2 01 2B 00 F2 F7 80 F3 8D 20 2B 40 F0 08 81 35 8E 31 6A 6B 01 5A 18 A2 42 00 F2 9B 80 31 44 01 F1 04 08 43 44 98 45 4E D2 08 F1 20 04 04 E0 08 EB 45 13 20 34 9B 45 46 D2 54 F8 20 3C A3 46 04 2B F5 D1 54 F8 10 AC BA F1 1F 0F F0 D9 54 F8 04 2C 03 2A EC D9 54 F8 1C 1C 32 68 01 EB 0A 00 90 42 5B D8 31 44 0D 1D 10 E0 2A 68 AA F1 20 00 69 68 03 32 03 31 22 F0 03 02 21 F0 03 01 0A 44 0C 32 82 42 48 D8 C2 EB 0A 0A 15 44 28 46 74 49 10 22 ?? ?? ?? ?? 00 28 E7 D1 BA F1 00 0F 3B D0 05 F1 14 00 2B 69 07 C8 33 BB ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 43 B1 C0 B2 C9 B2 D2 B2 01 EB 00 21 02 EB 01 22 9A 42 17 D8 48 46 14 37 BD 46 BD E8 F0 8F F2 7A 03 2A 01 D1 01 2B 80 D9 44 F2 7F 53 72 68 C4 F2 4C 63 9A 42 40 F0 8B 80 33 7A 01 2B 00 F0 8D 80 01 23 2B 70 48 46 4F F0 FF 39 ?? ?? ?? ?? 58 4B FD 68 02 22 7B 44 1B 68 48 46 14 37 EA 50 BD 46 BD E8 F0 8F 35 8E 89 E7 0A F1 0E 02 48 46 22 F0 07 02 AD EB 02 0D 00 22 04 AD ?? ?? ?? ?? 48 46 29 46 52 46 ?? ?? ?? ?? 82 45 A5 D0 4A 4B ?? ?2 0? 0? F8 68 ?? ?2 0? 0? 7B 44 1B 68 C5 58 2B E0 03 F1 0E 04 6D 46 02 46 48 46 E4 08 3B 60 A5 EB C4 05 AD 46 ?? ?? ?? ?? 3B 68 0D F1 10 08 48 46 1A 46 41 46 ?? ?? ?? ?? 3B 68 83 42 04 BF 35 8E 6B 01 3F F4 4D AF D9 E7 38 4A ?? ?2 0? 0? F9 68 ?? ?2 0? 0? 7A 44 12 68 ?? ?2 0? 0? ?? ?2 0? 0? 8D 58 00 2D 08 BF 1C 46 7B 68 00 2B 3C D1 01 94 00 23 BA 68 28 46 49 46 00 93 02 93 FF F7 41 F9 40 46 2A 49 08 22 ?? ?? ?? ?? 00 28 3F F4 F6 AE 40 46 27 49 08 22 ?? ?? ?? ?? 00 28 3F F4 EE AE 7A E7 22 46 CE E6 ?? ?2 0? 0? 05 46 ?? ?2 0? 0? DA E7 ?? ?2 0? 0? 05 46 ?? ?2 0? 0? D4 E7 ?? ?2 0? 0? 00 25 ?? ?2 0? 0? CE E7 73 7A 01 2B 32 D0 ?? ?2 0? 0? 00 25 ?? ?2 0? 0? C5 E7 ?? ?2 0? 0? 05 46 ?? ?2 0? 0? BF E7 B8 68 ?? ?? ?? ?? B9 68 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 04 A8 ?? ?? ?? ?? 03 46 B8 68 BB 60 ?? ?? ?? ?? AE E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B3 7A 01 2B 05 D0 ?? ?2 0? 0? 00 25 ?? ?2 0? 0? 8F E7 F2 7A 12 F0 BF 05 07 D0 03 2A 0E D0 ?? ?2 0? 0? 00 25 ?? ?2 0? 0? 83 E7 33 7B 83 B1 03 2A 06 D0 ?? ?2 0? 0? ?? ?2 0? 0? 7A E7 33 7B 3B B1 01 2B 05 D9 ?? ?2 0? 0? 00 25 ?? ?2 0? 0? 70 E7 06 F1 0D 00 08 49 07 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 00 25 ?? ?2 0? 0? ?? ?2 0? 0? A8 42 18 BF 1C 46 5D E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_8_0 {
	meta:
		name = "open_path.isra.5"
		size = 980
		refs = "0018 .LANCHOR2 0024 .LANCHOR1 0032 _dl_debug_mask 004e .LC40 005c .LC41 0070 _dl_argv 008c mempcpy 009c __libc_enable_secure 00a0 _dl_ns 01ba __xstat64 01dc malloc 01f0 memcpy 0206 .LC46 0210 _dl_debug_printf 022a __fxstat64 0242 __close 0264 .LC43 02f2 _dl_debug_printf_c 035e .LC42 036e .LC44 0392 .LC45 03b2 free 03c8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F AD B0 00 AF 7B 61 1B 68 F8 63 39 64 BA 63 00 2B 00 F0 A7 80 ?? ?2 0? 0? FB 62 ?? ?2 0? 0? 79 62 ?? ?2 0? 0? 00 22 0B 68 ?? ?2 0? 0? F9 6A ?? ?2 0? 0? BA 62 ?? ?2 0? 0? B2 68 B3 46 51 F8 04 AB 13 44 00 22 55 46 3A 61 F9 62 ?? ?2 0? 0? 39 6C ?? ?2 0? 0? FA 61 0B 44 ?? ?2 0? 0? 0E 33 ?? ?2 0? 0? 23 F0 07 03 39 62 AD EB 03 0D ?? ?2 0? 0? E9 46 ?? ?2 0? 0? BB 61 D8 F8 00 30 D8 07 00 F1 E9 80 48 46 E9 68 2A 69 ?? ?? ?? ?? DB F8 00 60 00 2E 5A D0 43 46 00 24 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? DA 46 26 46 39 63 80 46 7A 63 9B 46 33 E0 DA F8 0C 30 40 46 03 EB C4 02 53 F8 34 10 52 68 ?? ?? ?? ?? F9 6B 3A 6C ?? ?? ?? ?? DB F8 00 30 D9 07 C9 EB 00 00 78 64 00 F1 90 80 D7 F8 E4 20 00 23 48 46 D7 F8 DC 10 FF F7 B3 FD 6A 69 03 46 00 2A 39 D1 42 1C 3F D0 01 26 02 22 6A 61 B9 6B 00 29 40 F0 83 80 5A 1C 04 F1 01 04 5F D1 DA F8 00 30 04 35 A3 42 08 D9 6B 69 01 2B C8 D1 01 34 DA F8 00 30 04 35 A3 42 F6 D8 D8 46 D3 46 4E B1 A3 4B 1D EE 70 2F 7B 44 1B 68 D3 58 02 2B 01 D0 0D 2B 0B D1 FA 6A BB 6A 52 F8 04 5B 33 43 BB 62 FA 62 00 2D 8D D1 00 2B 00 F0 22 81 4F F0 FF 30 B4 37 BD 46 BD E8 F0 8F 01 2A 18 BF 46 F0 01 06 01 30 C4 D1 01 34 D3 E7 D7 F8 E0 30 5B B1 9B 69 4C 22 79 6B 02 FB 03 F3 CB 58 93 F8 95 31 1B 07 48 BF 01 23 18 D4 3A 6C 03 20 D7 F8 44 E0 49 46 CE 44 D3 43 4F F0 00 02 0E F8 03 20 07 F1 48 02 ?? ?? ?? ?? 28 B9 BB 6D 03 F4 70 43 B3 F5 80 4F 18 D0 01 23 6B 61 00 23 1E 43 01 34 A8 E7 78 6C 9B 46 ?? ?? ?? ?? D7 F8 D8 30 18 60 00 28 00 F0 DB 80 7A 6C 49 46 ?? ?? ?? ?? 58 46 B4 37 BD 46 BD E8 F0 8F 02 23 6B 61 01 23 E5 E7 ?? ?2 0? 0? 49 46 ?? ?2 0? 0? ?? ?? ?? ?? 67 E7 39 6B 0A 68 00 2A 3F F4 78 AF 19 46 03 20 07 F1 48 02 7B 60 ?? ?? ?? ?? 7B 68 18 B9 BA 6D 11 05 3F F5 6B AF 18 46 4F F0 FF 33 7B 60 ?? ?? ?? ?? 61 4A 1D EE 70 1F 02 20 7B 68 7A 44 12 68 88 50 5B E7 6C 68 39 69 8C 42 3F F4 12 AF 79 6A ?? ?2 0? 0? DB F8 08 20 ?? ?2 0? 0? C7 F8 0C D0 0B 68 A9 68 13 44 07 33 23 F0 07 03 79 63 AD EB 03 0D ?? ?? ?? ?? FA 6A C7 F8 44 D0 52 F8 04 3C 00 2B 5B D0 5A 68 94 42 58 D1 D7 F8 2C A0 01 21 0D EB 01 02 C7 F8 10 90 BA 60 D9 46 1A 46 C3 46 A0 46 54 46 AA 46 39 63 D1 68 78 6C 12 69 ?? ?? ?? ?? D9 F8 00 20 00 2A 34 D0 25 46 00 26 04 46 16 E0 BB 68 98 42 53 D0 4F F0 00 02 00 F8 01 2C FB 69 39 6B 38 6A 00 29 18 BF 18 46 79 6C ?? ?? ?? ?? 00 23 3B 63 D9 F8 00 20 01 36 96 42 18 D2 55 F8 04 2C 20 46 02 EB 86 02 52 69 01 2A F2 D0 D9 F8 0C 20 02 EB C6 0E 52 F8 36 10 DE F8 04 20 ?? ?? ?? ?? 7B 6C 83 42 D3 D1 4F F0 00 01 01 70 D6 E7 2C 46 54 F8 04 2B 12 B1 51 68 88 45 BB D0 44 46 D8 46 CB 46 D7 F8 10 90 55 46 7B 6B F3 B1 79 6B 0B 78 CB B9 BB 69 1A 68 ?? ?2 0? 0? ?? ?2 0? 0? 12 68 00 2A 08 BF 1A 46 ?? ?2 0? 0? 21 46 ?? ?2 0? 0? ?? ?? ?? ?? 3C 61 FB 68 9D 46 80 E6 7B 6C 1A 78 2F 2A A7 D1 CF E7 7A 6B ED E7 ?? ?2 0? 0? 21 46 ?? ?2 0? 0? ?? ?? ?? ?? EC E7 58 46 ?? ?? ?? ?? DD E6 79 69 4B 68 13 B1 08 68 ?? ?? ?? ?? 06 4B 7A 69 9A 42 3F F4 D3 AE 4F F0 FF 30 10 60 D0 E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_9_0 {
	meta:
		name = "add_path.13094.isra.1.constprop.7"
		size = 132
		refs = "0058 mempcpy"
	strings:
		$1 = { 2D E9 F8 43 43 1C 64 46 32 D0 03 68 05 46 4F F0 00 08 0D E0 A2 68 18 69 92 E8 0A 00 01 33 53 60 55 F8 04 3F 02 28 2C BF 09 18 02 31 11 60 FB B1 22 7B 00 2A EE D1 94 E8 42 10 1F 69 01 36 01 2F 66 60 08 46 0C EB C6 09 4C F8 36 10 07 F1 FF 32 01 F1 01 06 0E D9 D9 68 ?? ?? ?? ?? 43 1C 23 60 80 F8 00 80 55 F8 04 3F C9 F8 04 80 00 2B DF D1 BD E8 F8 83 26 60 00 2F 0C BF 2E 27 2F 27 0F 70 20 68 EB E7 }
	condition:
		$1
}

rule file_248_10_0 {
	meta:
		name = "expand_dynamic_string_token"
		size = 180
		refs = "000e strchr 0020 _dl_dst_count 002c strlen 0040 _dl_platformlen 0062 malloc 007e _dl_get_origin 0090 .LC51 0094 .LC3 0098 __PRETTY_FUNCTION__.12728 00ac __assert_fail 0074 _dl_dst_substitute"
	strings:
		$1 = { 2D E9 F0 41 0C 46 05 46 24 21 20 46 16 46 ?? ?? ?? ?? 20 B9 20 46 BD E8 F0 41 FE F7 0B BC 31 46 ?? ?? ?? ?? 80 46 00 28 F4 D0 20 46 ?? ?? ?? ?? 07 46 D5 F8 A8 01 F8 B1 43 1C 27 D0 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 03 2B 38 BF 03 23 83 42 28 BF 18 46 04 28 84 BF 04 38 08 FB 00 77 78 1C ?? ?? ?? ?? 02 46 10 B3 28 46 21 46 33 46 BD E8 F0 41 ?? ?? ?? ?? 6B 68 1B 78 43 B9 ?? ?? ?? ?? 42 1E C5 F8 A8 01 03 32 D7 D9 00 20 D7 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 D8 72 ?? ?? ?? ?? BD E8 F0 81 }
	condition:
		$1
}

rule file_248_11_0 {
	meta:
		name = "cache_rpath.part.6"
		size = 262
		refs = "0016 _dl_inhibit_rpath 0054 malloc 005e .LC53 0076 free 009a __libc_enable_secure 00ea .LC0 00f8 _dl_signal_error 00fc .LC52"
	strings:
		$1 = { 08 32 2D E9 F0 43 0F 46 50 F8 22 40 83 B0 98 46 00 2C 3B D0 42 6B ?? ?2 0? 0? ?? ?2 0? 0? 61 68 D0 F8 04 90 52 68 1B 68 11 44 00 2B 35 D1 01 22 FF F7 8C FF 06 46 00 28 60 D0 04 78 02 46 00 25 14 B3 3A 2C 12 F8 01 4F 08 BF 01 35 00 2C F8 D1 A8 1C 80 00 ?? ?? ?? ?? 05 46 00 28 42 D0 ?? ?2 0? 0? 23 46 ?? ?2 0? 0? 29 46 8D E8 00 03 30 46 FE F7 96 FB 30 46 ?? ?? ?? ?? 01 23 18 46 3D 60 7B 60 03 B0 BD E8 F0 83 ?? ?? ?? ?? 20 46 4F F0 FF 33 3B 60 03 B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? 12 68 00 2A C2 D1 1A 78 4C 46 03 E0 A2 B1 5A 78 01 34 01 33 25 78 95 42 F8 D0 4D B1 00 2A B5 D0 01 33 3A 2A 1A 78 F9 D1 00 2A AF D0 4C 46 F1 E7 3A 2A 01 D0 00 2A F1 D1 4F F0 FF 33 00 20 3B 60 CE E7 30 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 21 0C 20 0A 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? F5 E7 }
	condition:
		$1
}

rule file_248_12_0 {
	meta:
		name = "_dl_dst_count"
		size = 126
		refs = "0000 __libc_enable_secure 001c .LC47 0032 .LC48 004a .LC49 006e strchr"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 43 06 46 D3 F8 00 90 83 B0 0F 46 4F F0 00 08 45 1C ?? ?2 0? 0? 29 46 ?? ?2 0? 0? 3B 46 CD F8 00 90 30 46 FE F7 45 FC ?? ?2 0? 0? 29 46 ?? ?2 0? 0? 3B 46 04 46 30 46 84 B9 00 94 FE F7 39 FC ?? ?2 0? 0? 29 46 ?? ?2 0? 0? 3B 46 04 46 30 46 24 B9 00 94 FE F7 2D FC 04 46 08 B1 08 F1 01 08 28 19 24 21 ?? ?? ?? ?? 00 28 D1 D1 40 46 03 B0 BD E8 F0 83 }
	condition:
		$1
}

rule file_248_13_0 {
	meta:
		name = "_dl_dst_substitute"
		size = 420
		refs = "0004 _dl_platform 000a __libc_enable_secure 0074 .LC47 00ea .LC48 0144 stpcpy 0158 .LC49 0178 .LC50"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? 90 46 ?? ?2 0? 0? 0A 78 89 B0 8A 46 1F 46 44 46 0D 46 ?? ?2 0? 0? ?? ?2 0? 0? 4F F0 00 09 06 90 CD F8 14 80 24 2A 1E D0 22 70 63 1C 6E 1C 27 B9 6A 78 72 B1 1C 46 35 46 F4 E7 6C 78 3A 2C 18 BF 22 46 F6 D1 22 46 B9 F1 00 0F 5C D1 05 93 F1 E7 05 9B B9 F1 00 0F 40 F0 90 80 00 22 40 46 1A 70 09 B0 BD E8 F0 8F DB F8 00 10 6E 1C ?? ?2 0? 0? 50 46 ?? ?2 0? 0? CD F8 0C C0 07 91 31 46 07 9B 00 93 3B 46 FE F7 D6 FB DD F8 0C C0 48 B3 06 9A 07 9B D2 F8 A8 11 00 2B 57 D0 92 F8 94 31 13 F0 03 0F 14 BF 4F F0 00 09 4F F0 01 09 4B 1E 03 33 40 D9 01 28 39 D9 32 5C 33 18 22 B9 C8 E7 5A 78 01 33 00 2A C4 D0 1E 46 00 2F F8 D0 3A 2A F6 D1 05 99 41 45 5F D1 5A 78 00 2A 59 D1 1A 78 0B 46 A7 E7 ?? ?2 0? 0? 00 90 ?? ?2 0? 0? 50 46 31 46 3B 46 CD F8 0C C0 FE F7 9D FB DD F8 0C C0 38 B3 DC F8 00 10 D2 E7 05 98 4F F0 00 09 04 93 19 1A CD F8 0C C0 FE F7 E2 FB 04 9B 05 99 22 46 DD F8 0C C0 48 45 08 BF 0B 46 90 E7 24 22 63 1C 22 70 6A 78 7E E7 06 44 20 46 CD F8 0C C0 ?? ?? ?? ?? 32 78 DD F8 0C C0 03 46 73 E7 DD F8 1C 90 AD E7 ?? ?2 0? 0? 00 90 ?? ?2 0? 0? 50 46 31 46 3B 46 CD F8 0C C0 FE F7 66 FB DD F8 0C C0 00 28 DC D0 ?? ?2 0? 0? ?? ?2 0? 0? 98 E7 05 98 04 93 19 1A FE F7 AC FB 04 9B 05 9A 00 28 08 BF 13 46 64 E7 5E 1C 43 46 5A E7 1A 78 05 9B 4A E7 }
	condition:
		$1
}

rule file_248_14_0 {
	meta:
		name = "_dl_init_paths"
		size = 448
		refs = "0004 _dl_platform 000a _dl_platformlen 0016 .LANCHOR1 002c _dl_important_hwcaps 0036 malloc 0072 _dl_all_dirs 0076 .LC55 007e .LANCHOR0 00da .LANCHOR2 010a strlen 0120 memcpy 0158 __libc_enable_secure 015c .LC57 0164 .LC56 0190 free 01a0 .LC0 01ae _dl_signal_error 01b2 .LC54"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? 82 B0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 02 AF 19 68 80 46 09 F1 08 03 10 68 4A 46 ?? ?? ?? ?? C9 F8 0C 00 0C 20 ?? ?? ?? ?? 82 46 C9 F8 10 00 00 28 00 F0 B6 80 D9 F8 00 50 4C F6 CD 43 CC F6 CC 43 AC 00 27 34 A3 FB 04 24 24 09 04 EB 84 04 A0 01 ?? ?? ?? ?? 06 46 CA F8 00 00 00 28 00 F0 97 80 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 1E 60 A1 00 00 23 F2 60 70 60 05 22 C9 F8 14 30 B3 60 32 61 3D B1 34 46 1A 46 01 33 62 61 AB 42 04 F1 04 04 F9 D1 DF F8 08 C1 74 18 00 23 34 60 09 22 CA F8 04 40 22 61 1A 46 60 60 C4 F8 0C C0 A3 60 2D B1 01 33 62 61 AB 42 04 F1 04 04 F9 D1 ?? ?2 0? 0? 00 22 ?? ?2 0? 0? 09 20 72 50 18 60 CA F8 08 20 B8 F1 00 0F 02 D0 98 F8 00 30 33 B9 4F F0 FF 33 C9 F8 18 30 BD 46 BD E8 F0 87 40 46 ?? ?? ?? ?? 41 46 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 02 A8 ?? ?? ?? ?? 98 F8 00 30 06 46 00 2B 36 D0 01 22 3A 3B 01 2B 18 F8 01 3F 98 BF 01 32 00 2B F7 D1 01 32 90 00 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 01 46 C9 F8 18 00 18 B3 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 30 46 1B 68 ?? ?2 0? 0? 00 95 00 25 01 95 FE F7 8D FA A0 69 03 68 2B B1 00 23 C9 F8 1C 30 BD 46 BD E8 F0 87 ?? ?? ?? ?? 4F F0 FF 33 A3 61 F3 E7 08 20 D1 E7 ?? ?2 0? 0? ?? ?2 0? 0? 00 21 0C 20 0A 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? F5 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_15_0 {
	meta:
		name = "_dl_map_object"
		size = 1568
		refs = "0018 _dl_nns 002e _dl_ns 005e _dl_name_match_p 0070 _dl_debug_mask 0090 strchr 00da __libc_stack_end 0124 strlen 0146 .LANCHOR1 01de .LC67 01e8 _dl_debug_printf 0200 .LC66 022c _dl_inhibit_cache 023a _dl_load_cache_lookup 0276 __close 037e .LC65 03c2 strcmp 03c8 .LC62 03dc .LC63 046c .LC59 0472 .LC58 0490 _dl_argv 0494 .LC42 04d4 __libc_enable_secure 04e6 .LC64 04f8 .LANCHOR0 0504 memcmp 0522 .LC61 0526 .LC3 052a __PRETTY_FUNCTION__.13038 053e __assert_fail 0542 .LC60 0566 free 0592 _dl_new_object 059e dummy_bucket.13083 05c6 _dl_add_to_namespace_list 05d6 .LC68 05e2 _dl_signal_error 05ec .LC5 0604 .LC69 061c __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F AD F5 13 7D 06 46 0C 46 9D 9D 93 46 08 93 00 2D C0 F2 95 82 ?? ?2 0? 0? 9D 9D ?? ?2 0? 0? 1B 68 9D 42 80 F0 7C 82 9D 9D 4C 23 ?? ?2 0? 0? ?? ?2 0? 0? 03 FB 05 F3 FD 58 3D B9 17 E0 95 F8 95 31 D9 07 40 F1 B1 81 ED 68 85 B1 95 F8 95 31 9A 07 F9 D4 98 06 F7 D4 20 46 29 46 ?? ?? ?? ?? 00 28 EC D0 28 46 0D F5 13 7D BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? D8 F8 00 90 19 F0 40 03 40 F0 F0 81 0D F1 3B 0A 20 46 2F 21 8A F8 00 30 ?? ?? ?? ?? 00 28 40 D0 00 2E 00 F0 A9 80 9C 9D 05 F0 80 55 07 95 30 46 21 46 00 22 FF F7 EA FD 0F 90 4F F0 FF 31 40 B1 11 A9 52 46 01 23 FF F7 D1 F8 45 1C 01 46 00 F0 4C 82 07 9D 00 2D 18 BF 00 26 48 1C 00 F0 4B 82 9C 9D ?? ?2 0? 0? ?? ?2 0? 0? 20 46 10 AF 0F 9B 14 68 11 AA 02 95 9D 9D 8D E8 40 08 03 97 04 95 10 94 FE F7 51 FB 0D F5 13 7D BD E8 F0 8F 0D F1 3B 0A 20 46 2F 21 8A F8 00 60 ?? ?? ?? ?? 00 28 6A D1 9C 9D 05 F0 80 55 07 95 20 46 ?? ?? ?? ?? 19 F0 01 0F 00 F1 01 00 0A 90 40 F0 D8 81 00 2E 00 F0 BD 80 D6 F8 94 30 00 2B 00 F0 E7 80 ?? ?2 0? 0? ?? ?2 0? 0? 09 95 A9 69 4B 1C 08 BF 4F F0 01 0C 19 D0 9C 9D 33 46 05 F0 80 62 00 2E 00 F0 6E 81 02 93 0F A9 11 AB CD F8 0C A0 8D E8 0A 00 20 46 0A 99 AA 4B FF F7 43 FA B0 F1 FF 3E 01 46 DE F1 00 0C 5C EB 0E 0C 16 F1 00 09 18 BF 4F F0 01 09 1C EA 09 0C 17 D0 D6 F8 E8 31 06 F5 F4 79 5D 1C 38 D0 43 B3 9C 9D 4B 46 0F A9 11 AA 02 96 20 46 8D E8 06 00 05 F0 80 62 0A 99 E1 46 CD F8 0C A0 FF F7 1D FA 01 46 48 1C 25 D0 D8 F8 00 30 DF 07 7F F5 76 AF ?? ?2 0? 0? 06 91 ?? ?2 0? 0? ?? ?? ?? ?? 06 99 6C E7 9C 9D 20 46 05 F0 80 55 07 95 FE F7 5D F9 57 E7 ?? ?2 0? 0? 30 46 ?? ?2 0? 0? 49 46 1D 22 CD F8 18 C0 FF F7 91 FD DD F8 18 C0 00 28 C7 D1 E1 46 9C 9D 15 F0 80 65 0B 95 40 F0 54 81 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 03 BB 20 46 ?? ?? ?? ?? 05 46 D8 B1 B9 F1 00 0F 04 D0 D6 F8 04 32 19 05 00 F1 53 81 11 A9 00 23 28 46 52 46 FF F7 03 F8 43 1C 01 46 0A D0 28 46 06 91 FE F7 26 F9 06 99 0F 90 00 28 AF D1 08 46 ?? ?? ?? ?? B9 F1 00 0F 00 F0 D7 80 D6 F8 04 22 33 46 12 05 00 F1 C9 80 09 9D 2A 69 01 32 00 F0 C4 80 02 93 0F A8 0A 99 11 AB 00 90 20 46 01 93 CD F8 0C A0 0B 9A 5F 4B FF F7 AB F9 01 46 8E E7 3D 68 09 95 09 9D 00 2D 3F F4 42 AF 95 F8 94 31 03 F0 03 03 02 2B 3F F4 3B AF D5 F8 98 31 59 1C 3F F4 36 AF 05 F5 CC 79 00 2B 00 F0 B3 80 09 9B 0F A9 9C 9D 11 AA 00 2E 18 BF 33 46 00 91 02 93 20 46 01 92 4B 46 0A 99 05 F0 80 62 CD F8 0C A0 FF F7 7F F9 42 1C 01 46 7F F4 61 AF 18 E7 3D 68 CD F8 2C B0 BB 46 CD F8 30 80 57 46 09 95 98 46 9C 9D DD F8 28 90 05 F0 80 65 0D 95 DD F8 34 A0 35 46 19 E0 0F A8 63 46 00 90 11 A9 20 46 01 91 02 96 49 46 03 97 52 46 FF F7 5B F9 43 1C 23 D1 09 9A 95 42 14 BF 43 46 48 F0 01 03 5F FA 83 F8 D5 F8 6C 51 00 2D 4C D0 D5 F8 98 31 05 F5 CC 7C 5A 1C F5 D0 00 2B DD D1 ?? ?2 0? 0? 61 46 28 46 ?? ?2 0? 0? 0F 22 CD F8 18 C0 FF F7 D2 FC DD F8 18 C0 00 28 E4 D0 CD E7 01 46 DD F8 2C B0 DD F8 30 80 BA 46 13 E7 AB 6D 00 2B 3F F4 4B AE 6A 6B 20 46 5B 68 52 68 02 EB 03 08 41 46 ?? ?? ?? ?? 98 B1 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 7F F4 37 AE ?? ?2 0? 0? 40 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 7F F4 2D AE E8 69 21 46 FE F7 68 F9 95 F8 95 31 28 46 43 F0 01 03 85 F8 95 31 2F E6 C4 46 BA 46 DD F8 30 80 5F 46 DD F8 2C B0 BC F1 00 0F 7F F4 94 AE 4C E7 4F F0 FF 31 D6 E6 00 BF ?? ?? ?? ?? ?? ?? ?? ?? 9D 9D 4C 23 03 FB 05 F3 FB 58 00 2B 3F F4 27 AF D3 F8 04 22 20 E7 3B 68 8F E6 ?? ?2 0? 0? 09 98 ?? ?2 0? 0? 49 46 0F 22 FF F7 6E FC 00 28 3F F4 72 AE 3F E7 00 2E 3F F4 4E AE 71 68 ?? ?2 0? 0? 9C 9D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 15 F0 80 55 07 95 0D 78 14 BF 10 46 18 46 0B 46 65 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 11 68 00 29 18 BF 0B 46 B5 69 21 46 9D 9A 0D F1 3B 0A 00 95 ?? ?? ?? ?? 20 46 2F 21 00 23 8A F8 00 30 ?? ?? ?? ?? 00 28 7F F4 EC AD D8 F8 00 90 26 E6 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 00 2B 7F F4 CB AE A2 E6 ?? ?2 0? 0? 21 46 ?? ?2 0? 0? 9D 9A ?? ?? ?? ?? 1E E6 ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 06 93 ?? ?? ?? ?? 06 9B 40 B1 28 46 42 49 09 22 ?? ?? ?? ?? 06 9B 00 28 7F F4 9A AE 1A 46 B1 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F6 26 02 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F6 25 02 ?? ?? ?? ?? 0F 98 06 91 ?? ?? ?? ?? 06 99 AD E5 08 9D 6D B3 D8 F8 00 30 1A 05 29 D4 20 46 FD F7 9C FF 07 46 80 B3 9C 9D 33 46 5A 46 21 46 00 95 9D 9D 01 95 ?? ?? ?? ?? 06 46 28 B3 90 F8 95 41 ?? ?2 0? 0? 90 F8 94 21 ?? ?2 0? 0? 9D 99 44 F0 02 04 C0 F8 8C 31 42 F0 04 02 80 F8 95 41 01 23 80 F8 94 21 C0 F8 78 31 ?? ?? ?? ?? 30 46 4C E5 9A F8 00 20 A2 B1 00 20 ?? ?2 0? 0? 21 46 02 46 ?? ?2 0? 0? ?? ?? ?? ?? 38 46 ?? ?? ?? ?? ?? ?2 0? 0? 21 46 ?? ?2 0? 0? 0C 20 00 22 ?? ?? ?? ?? 07 48 1D EE 70 5F ?? ?2 0? 0? 21 46 78 44 00 68 ?? ?2 0? 0? 28 58 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_16_0 {
	meta:
		name = "_dl_rtld_di_serinfo"
		size = 292
		refs = "0022 .LANCHOR1 009a _dl_ns 00ca .LC65 00e8 .LC66"
	strings:
		$1 = { 70 B5 84 B0 05 46 8D F8 0C 20 02 91 52 BB 4A 68 01 32 D5 F8 94 30 00 20 01 90 01 EB C2 01 00 91 53 B3 ?? ?2 0? 0? EC 46 ?? ?2 0? 0? A0 69 FF F7 C5 F9 D5 F8 E8 01 42 1C 04 D0 00 28 54 D0 EC 46 FF F7 BC F9 D5 F8 04 32 1B 05 10 D5 9D F8 0C 30 33 B1 02 9B 59 68 1A 68 01 31 02 EB C1 02 1A 60 04 B0 70 BD 00 23 4B 60 1A 46 0B 60 D0 E7 EC 46 20 69 FF F7 A3 F9 E9 E7 2C 46 D4 F8 98 31 58 1C 18 46 03 D0 0B B3 EC 46 FF F7 98 F9 D4 F8 6C 41 00 2C F2 D1 AB 69 00 2B C3 D1 ?? ?2 0? 0? ?? ?2 0? 0? 1C 68 00 2C BC D0 94 F8 94 31 03 F0 03 03 02 2B B6 D0 AC 42 B4 D0 D4 F8 98 01 41 1C B0 D0 08 B3 EC 46 FF F7 7A F9 AB E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 04 F5 CC 71 0F 22 FF F7 1D FB 00 28 D4 D0 D4 F8 98 01 CE E7 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? 05 F5 F4 71 1D 22 FF F7 0E FB 00 28 A1 D0 D5 F8 E8 01 9B E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 04 F5 CC 71 0F 22 FF F7 FF FA 00 28 81 D0 D4 F8 98 01 CE E7 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "ppoll"
		size = 344
		refs = "001e __libc_multiple_threads 0038 __libc_do_syscall 00ae __sigprocmask 00b8 __poll 00f8 __libc_enable_asynccancel 011a __libc_disable_asynccancel 0148 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 15 46 A5 B0 80 46 0F 46 1E 46 35 B1 02 AC 95 E8 03 00 22 46 25 46 84 E8 03 00 ?? ?2 0? 0? ?? ?2 0? 0? 23 68 00 2B 64 D1 40 46 39 46 33 46 08 24 4F F4 A8 7C ?? ?? ?? ?? 10 F5 80 5F 6E D8 04 46 63 1C 03 D0 20 46 25 B0 BD E8 F0 83 3D 4B 1D EE 70 1F 7B 44 1B 68 CB 58 26 2B F3 D1 0D B3 2B 68 00 2B 40 DB 68 68 4C F6 FF 12 C3 F6 9A 32 90 42 39 D8 4C F2 9B 42 C0 F2 20 02 93 42 11 DC 29 D0 00 F5 74 20 4D F6 83 62 00 F2 3F 20 C4 F2 1B 32 4F F4 7A 74 82 FB 00 12 C0 17 C0 EB A2 42 04 FB 03 24 86 B1 31 46 04 AA 02 20 ?? ?? ?? ?? 39 46 22 46 40 46 ?? ?? ?? ?? 04 A9 00 22 04 46 02 20 ?? ?? ?? ?? BE E7 22 46 40 46 39 46 ?? ?? ?? ?? 04 46 B7 E7 46 F6 C0 72 C2 F2 90 62 90 42 CF DD 00 2E DF D1 EF E7 18 4B 16 22 7B 44 1B 68 CA 50 A8 E7 01 92 ?? ?? ?? ?? 08 24 39 46 01 9A 33 46 4F F4 A8 7C 81 46 40 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0D D8 48 46 ?? ?? ?? ?? 91 E7 0B 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 86 E7 07 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E7 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "__atomic_readv_replacement"
		size = 260
		refs = "005c __read 0090 memcpy 009c free 00c8 __libc_alloca_cutoff 00d2 malloc 00f2 _Unwind_Resume 0100 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F B2 F1 00 08 83 B0 82 46 89 46 00 AF 68 DD 4E 68 B6 F1 00 4F 3E BF 00 25 0A 46 2C 46 09 D3 42 E0 08 32 4F F6 FF 73 C7 F6 FF 73 56 68 1B 1B B3 42 39 D3 01 35 34 44 45 45 F2 D1 B4 F5 80 5F 40 D8 04 F1 0E 03 00 22 23 F0 07 03 7A 60 AD EB 03 0D 6D 46 50 46 22 46 29 46 ?? ?? ?? ?? B0 F1 00 0B 3B DB B8 F1 00 0F DA 46 15 DD 00 26 04 E0 01 36 09 F1 08 09 46 45 0E D0 D9 F8 04 40 29 46 D9 F8 00 00 A2 45 38 BF 54 46 22 46 25 44 ?? ?? ?? ?? BA EB 04 0A EB D1 78 68 ?? ?? ?? ?? 58 46 0C 37 BD 46 BD E8 F0 8F 15 4B 1D EE 70 2F 4F F0 FF 3B 16 21 7B 44 1B 68 58 46 0C 37 D1 50 BD 46 BD E8 F0 8F 20 46 ?? ?? ?? ?? 00 28 B9 D1 20 46 ?? ?? ?? ?? 05 46 78 60 00 28 BB D1 4F F0 FF 3B DA E7 00 24 AD E7 04 46 78 68 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 00 22 04 46 7A 60 F5 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "__libc_readv"
		size = 168
		refs = "0000 __libc_multiple_threads 001a __libc_do_syscall 0050 __libc_enable_asynccancel 006e __libc_disable_asynccancel 009c __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 41 07 46 1B 68 0E 46 15 46 E3 B9 4F F0 91 0C ?? ?? ?? ?? 10 F5 80 5F 27 D8 04 46 00 2C 02 DB 20 46 BD E8 F0 81 1A 4B 1D EE 70 2F 7B 44 1B 68 D3 58 16 2B F4 D1 08 2D F2 DD 38 46 31 46 2A 46 BD E8 F0 41 55 E7 ?? ?? ?? ?? 31 46 2A 46 4F F0 91 0C 80 46 38 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0D D8 40 46 ?? ?? ?? ?? D8 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 CD E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E7 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__seed48_r"
		size = 64
	strings:
		$1 = { F0 B4 04 46 D1 F8 00 C0 0B 26 8F 88 01 25 0A A3 D3 E9 00 23 00 20 C1 F8 06 C0 4F 81 A7 88 8F 80 67 88 4F 80 24 88 8E 81 CD 81 0C 80 C1 E9 04 23 F0 BC 70 47 AF F3 00 80 6D E6 EC DE 05 00 00 00 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "iruserfopen"
		size = 302
		refs = "000e __lxstat64 0022 _libc_intl_domainname 0026 .LC1 0034 __dcgettext 003a __rcmd_errstr 0048 _IO_new_fclose 0056 .LC0 007c .LC2 0086 _IO_new_fopen 008e fileno 0098 __fxstat64 00ac .LC5 00d2 .LC7 00ea .LC6 0102 .LC3 011a .LC4"
	strings:
		$1 = { 70 B5 9A B0 05 46 0E 46 6A 46 01 46 03 20 ?? ?? ?? ?? 04 46 E8 B9 04 9B 03 F4 70 43 B3 F5 00 4F 2C D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?? ?? ?? C8 B1 ?? ?2 0? 0? ?? ?2 0? 0? 18 60 20 46 14 B1 ?? ?? ?? ?? 00 20 1A B0 70 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 00 24 ?? ?? ?? ?? 00 28 E5 D1 23 68 20 46 43 F4 00 43 23 60 1A B0 70 BD ?? ?2 0? 0? 28 46 ?? ?2 0? 0? ?? ?? ?? ?? 04 46 B8 B3 ?? ?? ?? ?? 6A 46 01 46 03 20 ?? ?? ?? ?? 00 28 3A DB 06 9B 6B B1 B3 42 0B D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? BB E7 04 9B 13 F0 12 0F 0E D1 05 9B 01 2B CF D9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? A8 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 9C E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 90 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 84 E7 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "__validuser2_sa"
		size = 810
		refs = "0024 __getline 00c0 .LC8 00cc strncmp 00d6 .LC9 0158 free 01ba getnameinfo 01c4 strcmp 01fe getaddrinfo 0230 memcmp 023e freeaddrinfo 0272 innetgr 02d4 __libc_tsd_CTYPE_TOLOWER 02d8 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 4F 80 46 DF F8 D8 92 A3 B0 B1 4E B2 4F 07 93 00 23 04 91 08 92 0B 93 0C 93 00 25 0B A8 0C A9 42 46 ?? ?? ?? ?? 00 28 40 F3 28 81 0B 9A 0C 9B 13 44 03 F8 01 5C DD F8 2C C0 9C F8 00 20 00 2A EC D0 4B 46 1D EE 70 EF 7B 44 1B 68 5E F8 03 40 34 F8 12 A0 0A F4 00 5A 1F FA 8A FA BA F1 00 0F 00 F0 46 81 61 46 11 F8 01 3F 00 2B D6 D0 34 F8 13 00 80 04 F7 D4 23 2B D0 D0 64 46 BA F1 00 0F 6F D1 0C F1 01 03 08 E0 39 46 79 44 09 68 5E F8 01 10 31 F8 12 10 89 04 63 D4 31 46 1C 46 79 44 09 68 5E F8 01 10 51 F8 22 20 03 F8 01 2C 13 F8 01 2B 00 2A E8 D1 20 46 00 23 03 70 0B 9D ?? ?2 0? 0? ?? ?2 0? 0? 02 22 29 46 ?? ?? ?? ?? 00 28 00 F0 CA 80 ?? ?2 0? 0? 29 46 ?? ?2 0? 0? 02 22 ?? ?? ?? ?? 00 28 00 F0 CC 80 2B 78 2D 2B 02 BF 4F F0 FF 31 01 35 06 91 55 D0 2B 2B 51 D1 6B 78 00 2B 40 F0 0C 81 07 99 ?? ?2 0? 0? 23 78 ?? ?2 0? 0? 02 22 00 2B 08 BF 0C 46 21 46 ?? ?? ?? ?? 00 28 00 F0 DE 80 ?? ?2 0? 0? 21 46 ?? ?2 0? 0? 02 22 ?? ?? ?? ?? 00 28 00 F0 DC 80 23 78 2D 2B 00 F0 E0 80 2B 2B 40 F0 AA 80 63 78 00 2B 40 F0 A6 80 00 24 0B 98 ?? ?? ?? ?? 20 46 23 B0 BD E8 F0 8F 20 2A 18 BF 09 2A A5 D1 63 78 00 22 60 1C 22 70 00 2B 00 F0 D6 80 58 4A 7A 44 12 68 5E F8 02 10 31 F8 13 30 9D 04 60 D5 A3 1C 03 E0 31 F8 12 20 90 04 5B D5 1C 46 13 F8 01 2B 00 2A F6 D1 89 E7 01 23 06 93 00 23 16 AA 00 93 01 93 01 23 04 98 02 93 2E 23 08 99 ?? ?? ?? ?? 28 B9 16 A8 29 46 ?? ?? ?? ?? 00 28 7A D0 04 99 4F F0 00 0B 28 46 0E AA 0D AB CD F8 38 B0 B1 F8 00 E0 59 46 CD F8 40 B0 CD F8 44 B0 CD F8 3C E0 CD F8 48 B0 CD F8 4C B0 CD F8 50 B0 CD F8 54 B0 ?? ?? ?? ?? 82 46 00 28 46 D1 0D 9B 05 93 B3 B1 04 99 1D 46 09 90 B1 F8 00 B0 DA 46 8B 46 02 E0 ED 69 00 2D 51 D0 6B 68 53 45 F9 D1 68 69 59 46 2A 69 ?? ?? ?? ?? 00 28 F2 D1 DD F8 18 A0 05 98 ?? ?? ?? ?? BA F1 00 0F 1A DB 3F F4 E8 AE 5C E7 04 46 63 1C 04 E0 31 F8 12 20 92 04 3F F5 2E AF 18 46 13 F8 01 2B 00 2A F5 D1 27 E7 02 46 2D 99 A8 1C 13 46 ?? ?? ?? ?? 82 46 BA F1 00 0F E4 DA 4F F0 FF 34 68 E7 02 46 2D 99 A8 1C 13 46 ?? ?? ?? ?? C0 F1 00 0A F0 E7 BB F1 00 0F 3F F4 BF AE 33 E7 21 46 2C 98 ?? ?? ?? ?? D0 F1 01 00 38 BF 00 20 00 28 3F F7 4F AF 00 28 3F F4 B0 AE 4F F0 FF 34 49 E7 DD F8 18 A0 D7 E7 05 98 DD F8 24 A0 ?? ?? ?? ?? B6 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 46 2C 9A A0 1C 0B 46 ?? ?? ?? ?? DE E7 13 46 C0 E6 01 46 2C 9A A0 1C 0B 46 ?? ?? ?? ?? 40 42 D4 E7 60 1C 2C 99 ?? ?? ?? ?? 00 28 14 BF 00 20 6F F0 00 00 00 28 3F F4 7F AE CD E7 01 22 06 92 40 E7 04 46 C6 E6 }
	condition:
		$1
}

rule file_254_2_0 {
	meta:
		name = "ruserok2_sa"
		size = 278
		refs = "001c .LANCHOR0 002e __sysconf 0048 __getpwnam_r 0064 strlen 007c mempcpy 0080 .LC11 0094 __geteuid 009e seteuid 00c6 _IO_new_fclose 00da .LC10"
	strings:
		$1 = { 2D E9 F0 4F 8B B0 02 AF 14 46 82 46 89 46 9B 46 D7 F8 48 80 00 2A 60 D0 4F F0 FF 36 ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 23 43 11 D0 46 20 3C 1C ?? ?? ?? ?? 39 1D 00 F1 0E 02 03 46 22 F0 07 02 40 46 AD EB 02 0D 02 AA 00 94 ?? ?? ?? ?? 28 B1 4F F0 FF 30 24 37 BD 46 BD E8 F0 8F 3B 68 00 2B F6 D0 5C 69 20 46 ?? ?? ?? ?? 21 46 00 F1 17 03 02 46 23 F0 07 03 AD EB 03 0D 02 AC 20 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 03 CB 1B 78 51 60 10 60 13 72 ?? ?? ?? ?? 3B 68 05 46 98 68 ?? ?? ?? ?? 3B 68 20 46 99 68 FF F7 7C FD 04 46 60 B1 FB 6C 51 46 CD F8 00 B0 4A 46 01 93 43 46 FF F7 09 FE 06 46 20 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 30 46 24 37 BD 46 BD E8 F0 8F ?? ?2 0? 0? 11 46 ?? ?2 0? 0? FF F7 5E FD 05 46 00 28 94 D0 FB 6C 51 46 4A 46 CD F8 00 B0 01 93 43 46 FF F7 EA FD 06 46 28 46 ?? ?? ?? ?? 30 46 00 2E 86 D1 24 37 BD 46 BD E8 F0 8F }
	condition:
		$1
}

rule file_254_3_0 {
	meta:
		name = "rresvport_af"
		size = 248
		refs = "001a __socket 0028 memset 008a __bind 00bc __close 00ec __libc_errno"
	strings:
		$1 = { 02 29 2D E9 F0 43 88 46 A1 B0 04 46 53 D0 0A 29 45 D1 1C 27 40 46 01 21 00 22 ?? ?? ?? ?? 06 1E 61 DB 00 21 68 46 80 22 ?? ?? ?? ?? 25 68 AD F8 00 80 B5 F5 00 7F BC BF 4F F4 00 75 25 60 05 DB B5 F5 80 6F A4 BF 40 F2 FF 35 25 60 DF F8 A4 80 2B 46 11 E0 43 46 7B 44 1B 68 59 F8 03 30 62 2B 2B D1 23 68 B3 F5 00 7F 03 F1 FF 33 08 BF 40 F2 FF 33 23 60 9D 42 28 D0 C3 F3 07 2E 30 46 69 46 3A 46 4E EA 03 23 AD F8 02 30 ?? ?? ?? ?? 1D EE 70 9F 00 28 DE DB 30 46 21 B0 BD E8 F0 83 13 4B 1D EE 70 2F 4F F0 FF 30 61 21 7B 44 1B 68 D1 50 21 B0 BD E8 F0 83 10 27 AC E7 30 46 ?? ?? ?? ?? 4F F0 FF 30 21 B0 BD E8 F0 83 30 46 ?? ?? ?? ?? 07 4B 0B 22 4F F0 FF 30 7B 44 1B 68 49 F8 03 20 21 B0 BD E8 F0 83 4F F0 FF 30 E1 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_4_0 {
	meta:
		name = "rcmd_af"
		size = 1660
		refs = "0022 __getpid 002c .LC12 0052 __snprintf 0060 getaddrinfo 007c .LANCHOR1 0086 free 008e __strdup 00a8 __sigblock 00c2 rresvport_af 00d0 __fcntl 00da __connect 00ea __close 0120 getnameinfo 0124 _libc_intl_domainname 0128 .LC19 0136 __dcgettext 0140 __asprintf 0148 .LC16 0154 __fxprintf 016a perror 0188 .LC20 01ce .LC13 020a __sleep 0226 .LC18 0236 __sigsetmask 023c freeaddrinfo 0272 __listen 028a strlen 0294 __write 02c4 __poll 02f4 accept 0378 __writev 039a __read 03c8 .LC17 040e gai_strerror 0412 .LC14 0434 __libc_errno 0458 .LC29 04ac __strerror_r 04b0 .LC21 04ce .LC22 0502 .LC23 055c .LC24 0586 .LC27 05c6 .LC25 05f6 .LC26 060e .LC15 0646 .LC28"
	strings:
		$1 = { 2D E9 F0 4F E1 B0 0F 46 BD F8 B0 61 06 90 0A 2E 07 92 08 93 05 D0 4F F6 FD 73 33 40 00 2B 40 F0 63 82 ?? ?? ?? ?? 3B 02 43 EA 17 23 ?? ?2 0? 0? ?? ?2 0? 0? 08 21 9B B2 00 25 02 24 1B 96 1A 94 01 26 1D 95 1E 95 1F 95 20 95 21 95 1C 96 81 46 0E A8 ?? ?? ?? ?? 06 9C 0E A9 1A AA 0A AB 20 68 ?? ?? ?? ?? 00 28 40 F0 AB 80 0A 9C AD F8 44 60 AD F8 4C 60 A3 69 00 2B 00 F0 D8 81 ?? ?2 0? 0? ?? ?2 0? 0? 20 68 ?? ?? ?? ?? 0A 9B 98 69 ?? ?? ?? ?? 05 46 20 60 00 28 00 F0 B7 82 06 9C 20 60 0A 9C 4F F4 80 00 00 26 ?? ?? ?? ?? DF F8 98 A3 B0 46 01 23 05 93 40 F2 FF 33 0B 93 09 90 0B A8 A1 88 ?? ?? ?? ?? 07 1E C0 F2 A4 80 08 21 4A 46 ?? ?? ?? ?? 38 46 61 69 22 69 ?? ?? ?? ?? 00 28 80 F2 B3 80 38 46 1D EE 70 5F ?? ?? ?? ?? 53 46 7B 44 1B 68 EF 58 62 2F 75 D0 E3 69 6F 2F 08 BF 4F F0 01 08 00 2B 72 D0 21 69 00 26 22 AA 2E 96 01 23 60 69 02 93 2E 23 00 96 0D F1 B8 0B 01 96 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 22 AA 01 46 58 46 ?? ?? ?? ?? B0 42 0A DB ?? ?2 0? 0? 30 46 ?? ?2 0? 0? 2E 9A ?? ?? ?? ?? 2E 98 ?? ?? ?? ?? B5 4B 00 20 06 46 7B 44 1B 68 EF 50 ?? ?? ?? ?? E4 69 2E 23 22 AA 01 25 21 69 60 69 00 96 01 96 02 95 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 22 AA 01 46 58 46 ?? ?? ?? ?? B0 42 8A DB ?? ?2 0? 0? 30 46 ?? ?2 0? 0? 2E 9A ?? ?? ?? ?? 2E 98 ?? ?? ?? ?? 7E E7 86 1C 40 F0 24 81 22 68 00 2A 00 F0 20 81 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? ?? ?? ?? ?? 4F F0 FF 30 61 B0 BD E8 F0 8F 0B 9B 01 3B 0B 93 67 E7 05 9C 18 F1 00 06 18 BF 01 26 10 2C C8 BF 00 26 00 2E 00 F0 49 81 20 46 98 46 64 00 ?? ?? ?? ?? 05 94 0A 9C 54 E7 88 4B 1D EE 70 2F 7B 44 1B 68 D3 58 0B 2B 00 F0 CF 80 ?? ?2 0? 0? 00 20 ?? ?2 0? 0? ?? ?? ?? ?? 09 98 ?? ?? ?? ?? 0A 98 ?? ?? ?? ?? 4F F0 FF 30 61 B0 BD E8 F0 8F 0B 9B 01 3B 0B 93 6B 9B 00 2B 00 F0 3B 81 A1 88 0B A8 ?? ?? ?? ?? 23 69 0C AC 23 60 B0 F1 00 08 C0 F2 10 81 01 21 14 AE ?? ?? ?? ?? ?? ?2 0? 0? 0B 9B ?? ?2 0? 0? 08 21 30 46 ?? ?? ?? ?? 30 46 ?? ?? ?? ?? 31 46 42 1C 38 46 ?? ?? ?? ?? 05 46 30 46 ?? ?? ?? ?? 01 30 85 42 40 F0 2A 81 64 4B 1D EE 70 5F 10 97 00 22 CD F8 48 80 7B 44 1B 68 10 A8 02 21 EA 50 4F F0 FF 32 ?? ?? ?? ?? 00 28 40 F3 3C 81 BD F8 4E 30 D8 07 44 BF 0D F1 B8 09 DF F8 70 A1 06 D4 31 E1 53 46 7B 44 1B 68 EB 58 04 2B 06 D1 49 46 40 46 22 46 ?? ?? ?? ?? 41 1C F2 D0 BD F8 B8 30 83 46 02 2B 02 D0 0A 2B 40 F0 DF 80 BD F8 BA 30 C3 F3 07 22 42 EA 03 23 9D B2 40 46 ?? ?? ?? ?? BB F1 00 0F C0 F2 67 81 A5 F5 00 75 6B 9B B5 F5 00 7F C3 F8 00 B0 80 F0 24 81 07 98 40 4D 30 60 ?? ?? ?? ?? 08 9A B2 60 43 1C 10 46 73 60 ?? ?? ?? ?? 6A 9B 33 61 43 1C 6A 98 F3 60 ?? ?? ?? ?? 01 30 70 61 05 E0 2A 46 7A 44 12 68 9B 58 04 2B 08 D1 38 46 31 46 03 22 ?? ?? ?? ?? 1D EE 70 3F 01 30 F0 D0 2F 4D 05 E0 2A 46 7A 44 12 68 9B 58 04 2B 5D D1 01 22 38 46 21 46 ?? ?? ?? ?? 1D EE 70 3F 42 1C F0 D0 01 28 40 F0 45 81 23 78 13 BB 09 98 ?? ?? ?? ?? 0A 98 ?? ?? ?? ?? 38 46 61 B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 00 20 ?? ?? ?? ?? 23 E7 ?? ?? ?? ?? 23 78 0A 2B 45 D0 21 46 01 22 38 46 ?? ?? ?? ?? 21 46 03 46 02 20 01 2B 1A 46 EF D0 39 E0 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 00 20 ?? ?? ?? ?? 4F F0 FF 30 61 B0 BD E8 F0 8F 06 9A 13 60 37 E6 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0D AC 00 23 23 60 06 9B ?? ?2 0? 0? ?? ?2 0? 0? 20 46 1A 68 ?? ?? ?? ?? 00 28 0A DB ?? ?2 0? 0? 00 20 ?? ?2 0? 0? 22 68 ?? ?? ?? ?? 20 68 ?? ?? ?? ?? 0B 9B 1B B1 6B 9C 20 68 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? CE E6 0A 98 ?? ?? ?? ?? 73 4B 06 9A 2E A9 7B 44 1B 68 14 68 C8 22 E8 58 ?? ?? ?? ?? ?? ?2 0? 0? 22 46 ?? ?2 0? 0? 03 46 30 46 ?? ?? ?? ?? 09 98 ?? ?? ?? ?? BA E6 00 25 25 E7 ?? ?2 0? 0? 01 22 38 46 ?? ?2 0? 0? ?? ?? ?? ?? 6B 9A 0C AC 14 AE 0B 92 28 E7 61 4B 1D EE 70 2F 61 21 4F F0 FF 30 7B 44 1B 68 D1 50 71 E6 60 AC ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?2 0? 0? 00 25 44 F8 C8 5D ?? ?? ?? ?? 01 46 20 46 ?? ?? ?? ?? A8 42 A4 BF ?? ?2 0? 0? 28 46 07 DB ?? ?2 0? 0? 2E 9A ?? ?? ?? ?? 2E 98 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? A3 E7 4B 4B 00 22 2E 92 7B 44 1B 68 EB 58 B3 BB 0D F1 B8 09 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 48 46 ?? ?? ?? ?? 00 28 E1 DB ?? ?2 0? 0? 00 20 D5 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 00 24 0D 94 ?? ?? ?? ?? 01 46 0D A8 ?? ?? ?? ?? A0 42 FF F6 6C AF ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 0D 9A ?? ?? ?? ?? 0D 98 ?? ?? ?? ?? 5F E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 0D F1 B8 09 ?? ?? ?? ?? 01 46 48 46 ?? ?? ?? ?? 00 28 C8 DA 23 4B 7B 44 1B 68 EB 58 00 2B A4 D1 B0 E7 ?? ?2 0? 0? 00 20 ?? ?2 0? 0? ?? ?? ?? ?? 00 23 0B 93 41 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 28 46 ?? ?? ?? ?? 4F F0 FF 30 D4 E5 0D AC 00 23 23 60 00 28 7F F4 0A AF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 06 9B 1A 68 01 46 20 46 ?? ?? ?? ?? 00 28 BF F6 01 AF 0A E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_5_0 {
	meta:
		name = "rcmd"
		size = 24
		refs = "0010 rcmd_af"
	strings:
		$1 = { 70 B5 84 B0 02 26 08 9D 09 9C 02 96 00 95 01 94 ?? ?? ?? ?? 04 B0 70 BD }
	condition:
		$1
}

rule file_331_1_0 {
	meta:
		name = "rexec"
		size = 24
		refs = "0010 rexec_af"
	strings:
		$1 = { 70 B5 84 B0 02 26 08 9D 09 9C 02 96 00 95 01 94 ?? ?? ?? ?? 04 B0 70 BD }
	condition:
		$1
}

rule file_254_7_0 {
	meta:
		name = "ruserok_af"
		size = 118
		refs = "002a getaddrinfo 0054 freeaddrinfo"
	strings:
		$1 = { 2D E9 F0 41 8C B0 00 24 0E 46 BD F8 48 50 17 46 98 46 21 46 04 AA 03 AB 05 95 05 46 04 94 06 94 07 94 08 94 09 94 0A 94 0B 94 ?? ?? ?? ?? F8 B9 03 9C 14 B9 18 E0 E4 69 94 B1 60 69 32 46 21 69 3B 46 CD F8 00 80 01 95 FF F7 84 FB 00 28 F2 D1 05 46 03 98 ?? ?? ?? ?? 28 46 0C B0 BD E8 F0 81 03 98 4F F0 FF 35 F5 E7 20 46 4F F0 FF 35 F1 E7 4F F0 FF 30 F1 E7 }
	condition:
		$1
}

rule file_254_8_0 {
	meta:
		name = "ruserok"
		size = 16
		refs = "0008 ruserok_af"
	strings:
		$1 = { 10 B5 82 B0 02 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_254_9_0 {
	meta:
		name = "iruserok_af"
		size = 110
		refs = "0018 memset 0038 .LC30"
	strings:
		$1 = { 2D E9 F0 43 A3 B0 05 46 88 46 BD F8 A8 40 17 46 02 A8 00 21 80 22 99 46 ?? ?? ?? ?? 02 2C 1F D0 0A 2C 19 D1 28 68 04 AE 69 68 4F F0 1C 0E AA 68 EB 68 AD F8 08 40 0F C6 ?? ?2 0? 0? CD F8 00 90 02 A8 71 46 42 46 3B 46 ?? ?2 0? 0? 01 94 FF F7 3D FB 23 B0 BD E8 F0 83 00 20 23 B0 BD E8 F0 83 28 68 4F F0 10 0E AD F8 08 40 03 90 E4 E7 }
	condition:
		$1
}

rule file_254_10_0 {
	meta:
		name = "iruserok"
		size = 24
		refs = "0010 iruserok_af"
	strings:
		$1 = { 30 B5 85 B0 04 AC 02 25 00 95 44 F8 04 0D 20 46 ?? ?? ?? ?? 05 B0 30 BD }
	condition:
		$1
}

rule file_254_11_0 {
	meta:
		name = "__ivaliduser"
		size = 46
		refs = "0004 .LC30"
	strings:
		$1 = { 30 B5 87 B0 ?? ?2 0? 0? 02 25 03 91 ?? ?2 0? 0? 00 93 02 A9 13 46 01 94 10 22 00 24 02 94 04 94 05 94 AD F8 08 50 FF F7 77 F9 07 B0 30 BD }
	condition:
		$1
}

rule file_255_1_0 {
	meta:
		name = "hsearch"
		size = 36
		refs = "0006 .LANCHOR0 001a hsearch_r"
	strings:
		$1 = { 30 B5 87 B0 02 AC ?? ?2 0? 0? ?? ?2 0? 0? 05 AB 84 E8 03 00 00 95 94 E8 03 00 ?? ?? ?? ?? 05 98 07 B0 30 BD }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "psiginfo"
		size = 756
		refs = "0002 .LC11 0018 fmemopen 0034 _sys_siglist 0046 _libc_intl_domainname 0050 __dcgettext 0054 .LC25 0060 fprintf 008a .LC2 0094 .LC19 00a4 .LANCHOR0 00e0 .LC18 010a .LC23 0122 .LC24 0140 _IO_new_fclose 0146 strlen 0154 __libc_do_syscall 0166 .LC13 0184 .LC7 0190 .LC20 01a8 .LC1 01b2 .LC12 01c0 __fxprintf 01ca .LC0 01d6 .LC22 01e8 .LC3 01f8 .LC4 0206 __libc_current_sigrtmin 0210 __libc_current_sigrtmax 023a .LC15 025a .LC17 026c .LC10 0276 .LC5 0280 .LC6 028a .LC8 0294 .LC9 02a0 .LC21 02b6 .LC16 02c4 fwrite 02ca .LC14 02f0 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? AD F5 03 7D 04 46 0E 46 02 A8 ?? ?2 0? 0? 4F F4 00 71 ?? ?? ?? ?? 05 46 00 28 00 F0 BF 80 1E B1 33 78 00 2B 40 F0 9C 80 26 68 40 2E 74 D8 ?? ?2 0? 0? ?? ?2 0? 0? 53 F8 26 10 00 29 00 F0 E0 80 ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 28 46 ?? ?? ?? ?? 23 68 04 3B 19 2B 1B D9 A2 68 D7 1C 00 F0 06 81 7F DD 53 1C 00 F0 0C 81 C0 F2 05 81 00 2A 00 F0 F3 80 80 2A 04 BF ?? ?2 0? 0? ?? ?2 0? 0? 1E D0 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? ?? ?? ?? ?? 25 E0 ?? ?2 0? 0? ?? ?2 0? 0? 02 EB 83 00 52 F8 23 10 83 6E D0 F8 D0 00 00 2B D6 D0 A2 68 00 2A D4 DD 82 42 D2 D8 13 44 13 F8 01 3C C9 18 E0 D0 ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 28 46 ?? ?? ?? ?? 23 68 04 2B 4C D0 0B 2B 4A D0 DA 1F 01 2A 47 D9 11 2B 00 F0 CC 80 1D 2B 65 D0 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? E2 68 23 69 ?? ?? ?? ?? 0F E0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 22 68 01 46 28 46 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 02 A8 ?? ?? ?? ?? 02 A9 4F F0 04 0C 02 46 02 20 ?? ?? ?? ?? 10 F5 80 5F 00 F2 BF 80 0D F5 03 7D F0 BD ?? ?2 0? 0? 32 46 ?? ?2 0? 0? ?? ?? ?? ?? 5B E7 96 1D 7D D0 3A DD 50 1D 33 D0 11 1D 04 BF ?? ?2 0? 0? ?? ?2 0? 0? A1 D0 81 E7 ?? ?2 0? 0? E2 68 ?? ?2 0? 0? 28 46 ?? ?? ?? ?? CD E7 96 B1 33 78 83 B1 ?? ?2 0? 0? ?? ?2 0? 0? 24 68 ?? ?2 0? 0? 32 46 ?? ?2 0? 0? 00 20 00 94 ?? ?? ?? ?? 0D F5 03 7D F0 BD ?? ?2 0? 0? ?? ?2 0? 0? 1E 46 EC E7 ?? ?2 0? 0? E2 68 ?? ?2 0? 0? 28 46 ?? ?? ?? ?? AA E7 ?? ?2 0? 0? ?? ?2 0? 0? 6F E7 12 F1 3C 0F 04 BF ?? ?2 0? 0? ?? ?2 0? 0? 3F F4 67 AF 46 E7 ?? ?? ?? ?? 86 42 87 DB 26 68 ?? ?? ?? ?? 86 42 82 DA 26 68 ?? ?? ?? ?? 37 1A ?? ?? ?? ?? 26 68 80 1B 87 42 0F DA ?? ?? ?? ?? 86 42 4A D0 26 68 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 32 1A 28 46 ?? ?? ?? ?? 0B E7 ?? ?? ?? ?? 86 42 30 D0 ?? ?? ?? ?? 22 68 ?? ?2 0? 0? ?? ?2 0? 0? 82 1A 28 46 ?? ?? ?? ?? FB E6 ?? ?2 0? 0? ?? ?2 0? 0? 2D E7 ?? ?2 0? 0? ?? ?2 0? 0? 28 E7 ?? ?2 0? 0? ?? ?2 0? 0? 23 E7 ?? ?2 0? 0? ?? ?2 0? 0? 1E E7 ?? ?2 0? 0? ?? ?2 0? 0? 19 E7 26 69 ?? ?2 0? 0? E2 68 ?? ?2 0? 0? 63 69 28 46 00 96 ?? ?? ?? ?? 43 E7 ?? ?2 0? 0? 01 21 0A 22 2B 46 ?? ?2 0? 0? ?? ?? ?? ?? CC E6 ?? ?2 0? 0? 01 21 0A 22 2B 46 ?? ?2 0? 0? ?? ?? ?? ?? C2 E6 04 4B 1D EE 70 2F 40 42 7B 44 1B 68 D0 50 38 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "__strndup"
		size = 36
		refs = "0004 __strnlen 000c malloc 001e memcpy"
	strings:
		$1 = { 38 B5 05 46 ?? ?? ?? ?? 04 46 01 30 ?? ?? ?? ?? 38 B1 29 46 22 46 00 25 05 55 BD E8 38 40 ?? ?? ?? ?? 38 BD }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "__libc_init_first"
		size = 122
		refs = "0000 _dl_starting_up 0018 __fpu_control 001c .LANCHOR0 002e __setfpucw 0032 __libc_argc 0036 __libc_argv 003a __environ 0052 __libc_init_secure 0056 _dl_non_dynamic_init 0060 __init_misc 0068 __ctype_init"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 41 06 46 0F 46 90 46 0B B1 1B 68 4B B3 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 21 10 68 19 60 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2E 60 C3 F8 00 80 27 60 ?? ?? ?? ?? ?? ?? ?? ?? 30 46 39 46 42 46 ?? ?? ?? ?? BD E8 F0 41 ?? ?? ?? ?? ?? ?2 0? 0? 01 22 ?? ?2 0? 0? 1A 60 DB E7 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "getspnam"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getspnam_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1358_0_0 {
	meta:
		name = "getaliasbyname"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getaliasbyname_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1036_0_0 {
	meta:
		name = "getgrgid"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getgrgid_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_523_0_0 {
	meta:
		name = "getgrnam"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getgrnam_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_441_0_0 {
	meta:
		name = "getprotobyname"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getprotobyname_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1460_0_0 {
	meta:
		name = "getprotobynumber"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getprotobynumber_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "getpwnam"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getpwnam_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1089_0_0 {
	meta:
		name = "getpwuid"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getpwuid_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_359_0_0 {
	meta:
		name = "getrpcbyname"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getrpcbyname_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_537_0_0 {
	meta:
		name = "getrpcbynumber"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getrpcbynumber_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_505_0_0 {
	meta:
		name = "getsgnam"
		size = 308
		refs = "0006 .LANCHOR0 0030 .LANCHOR1 006a __getsgnam_r 0084 realloc 0092 free 00ec malloc 0104 __lll_lock_wait_private 0126 __libc_do_syscall 0130 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 ?? ?2 0? 0? 81 46 ?? ?2 0? 0? 01 22 03 94 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3A 68 00 2A 51 D0 03 9C 63 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D F1 14 0A 02 E0 23 46 C8 F8 00 00 CD F8 00 A0 48 46 31 49 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 22 28 31 D1 74 68 D7 F8 00 B0 64 00 58 46 21 46 74 60 ?? ?? ?? ?? 02 46 00 28 E4 D1 58 46 02 92 ?? ?? ?? ?? 26 4B 02 9A 1D EE 70 0F 7B 44 1B 68 0C 21 2A 60 C1 50 00 23 05 93 00 22 03 9C 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 1B DC 05 98 07 B0 BD E8 F0 8F 3B 68 00 2B E5 D1 E2 E7 03 99 4F F4 80 64 20 46 4C 60 ?? ?? ?? ?? 38 60 00 28 D8 D0 02 46 23 46 A2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 92 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "print_errno_message"
		size = 40
		refs = "000c __strerror_r 0010 .LC0 001c __fxprintf"
	strings:
		$1 = { 00 B5 AD F2 04 4D 69 46 4F F4 80 62 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 00 20 ?? ?? ?? ?? 0D F2 04 4D 5D F8 04 FB }
	condition:
		$1
}

rule file_262_1_0 {
	meta:
		name = "error_tail"
		size = 324
		refs = "0004 stderr 0028 strlen 0068 __mbsrtowcs 007c __vfwprintf 0088 free 008c error_message_count 009e .LC2 00a8 __fxprintf 00b0 _IO_fflush 00c8 .LC3 00e8 vfprintf 00fa __libc_alloca_cutoff 0112 realloc 0126 .LC1 0132 fputws_unlocked 0140 exit"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? 89 B0 ?? ?2 0? 0? 00 AF 16 46 78 60 DA F8 00 00 B9 60 FB 60 C2 6E 00 2A 60 DD 30 46 4F F0 00 09 ?? ?? ?? ?? 4F F6 FE 78 CB 46 4D 46 C7 F6 FF 78 44 1C 02 E0 44 45 40 D8 64 00 A1 00 B1 F5 80 5F 55 D8 0E 31 21 F0 07 01 AD EB 01 0D EB 46 58 46 07 F1 14 01 22 46 07 F1 18 03 BD 61 FD 61 7E 61 ?? ?? ?? ?? 84 42 E5 D0 01 30 26 D0 DA F8 00 00 59 46 FA 68 ?? ?? ?? ?? B9 F1 00 0F 02 D0 58 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1A 68 01 32 1A 60 BB 68 F3 B9 ?? ?2 0? 0? 00 20 ?? ?2 0? 0? ?? ?? ?? ?? DA F8 00 00 ?? ?? ?? ?? 7B 68 00 2B 41 D1 24 37 BD 46 BD E8 F0 8F B9 F1 00 0F 12 D1 ?? ?2 0? 0? DA F8 00 00 ?? ?2 0? 0? FA 68 ?? ?? ?? ?? D7 E7 18 46 FF F7 7B FF DC E7 31 46 1A 46 ?? ?? ?? ?? CE E7 58 46 ?? ?? ?? ?? E8 E7 08 46 39 60 ?? ?? ?? ?? 39 68 00 28 A2 D1 B9 F1 00 0F 14 BF D9 46 4F F0 00 09 48 46 ?? ?? ?? ?? 83 46 10 B1 4F F0 01 09 9A E7 48 46 ?? ?? ?? ?? ?? ?2 0? 0? DA F8 00 10 ?? ?2 0? 0? ?? ?? ?? ?? 24 37 BD 46 BD E8 F0 8F 18 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_262_2_0 {
	meta:
		name = "__error"
		size = 124
		refs = "0008 pthread_setcancelstate 0024 stdout 002e _IO_fflush 0032 error_print_progname 0064 program_invocation_name 0068 .LC4 0076 __fxprintf"
	strings:
		$1 = { 0C B4 00 23 2D E9 F0 41 ?? ?2 0? 0? 82 B0 ?? ?2 0? 0? 80 46 0F 46 08 9D 01 93 1C B1 01 20 01 A9 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 18 68 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 18 68 90 B1 80 47 09 AE 40 46 39 46 2A 46 33 46 00 96 FF F7 36 FF 1C B1 01 98 00 21 ?? ?? ?? ?? 02 B0 BD E8 F0 41 02 B0 70 47 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 ?? ?? ?? ?? E1 E7 }
	condition:
		$1
}

rule file_262_3_0 {
	meta:
		name = "__error_at_line"
		size = 210
		refs = "0004 error_one_per_line 001a .LANCHOR0 002c pthread_setcancelstate 0042 stdout 004c _IO_fflush 0050 error_print_progname 0060 .LC6 0064 .LC5 007e __fxprintf 00b0 strcmp 00ba program_invocation_name 00be .LC7"
	strings:
		$1 = { 2D E9 F0 46 ?? ?2 0? 0? ?? ?2 0? 0? 1D 46 83 B0 82 46 23 68 89 46 17 46 43 B1 ?? ?2 0? 0? ?? ?2 0? 0? 23 68 AB 42 3B D0 84 E8 A0 00 ?? ?2 0? 0? 00 23 ?? ?2 0? 0? 01 93 1C B1 01 20 01 A9 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 18 68 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 18 68 00 28 2D D0 80 47 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 46 00 2F 08 BF 31 46 3A 46 0B AD 00 20 ?? ?? ?? ?? 50 46 49 46 2B 46 0A 9A 00 95 FF F7 D8 FE 1C B1 01 98 00 21 ?? ?? ?? ?? 03 B0 BD E8 F0 86 60 68 82 42 F9 D0 00 28 BE D0 00 2A BC D0 11 46 ?? ?? ?? ?? 00 28 F0 D0 B6 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 1A 68 ?? ?? ?? ?? C6 E7 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "object_compare"
		size = 60
	strings:
		$1 = { 8B 68 82 68 30 B4 9A 42 94 BF 00 23 01 23 38 BF 01 3B 83 B9 D0 E9 00 45 D1 E9 00 23 AB 42 08 BF A2 42 2C BF 00 20 01 20 9D 42 08 BF 94 42 38 BF 01 38 30 BC 70 47 18 46 30 BC 70 47 }
	condition:
		$1
}

rule file_264_1_0 {
	meta:
		name = "add_object.isra.1"
		size = 62
		refs = "000a malloc 0012 object_compare 0028 __tsearch"
	strings:
		$1 = { F8 B5 06 46 10 20 0C 46 15 46 ?? ?? ?? ?? 98 B1 2F 68 ?? ?2 0? 0? D4 E9 00 45 06 F1 30 01 ?? ?2 0? 0? 87 60 C0 E9 00 45 ?? ?? ?? ?? 00 28 14 BF 00 20 6F F0 00 00 F8 BD 4F F0 FF 30 F8 BD }
	condition:
		$1
}

rule file_264_2_0 {
	meta:
		name = "process_entry"
		size = 488
		refs = "0030 mempcpy 005c __fxstatat 00a6 realloc 00ca object_compare 00e0 __tfind 0118 __lxstat 0170 __xstat 01e4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 47 1D 46 13 78 9C B0 14 46 80 46 2E 2B 89 46 6B D0 D8 F8 14 00 D8 F8 10 30 81 1C 29 44 99 42 3B D8 D8 F8 0C 20 03 46 D0 18 21 46 2A 46 ?? ?? ?? ?? 00 23 03 70 D9 F8 04 10 48 1C 5E D0 D8 F8 1C 20 0D F1 18 0A 53 46 03 20 12 F0 01 0F 22 46 0C BF 00 25 4F F4 80 75 00 95 ?? ?? ?? ?? 00 28 5D DB 0A 9B 03 F4 70 43 B3 F5 80 4F 00 F0 87 80 B3 F5 20 4F D8 F8 1C 30 0C BF 04 22 00 22 99 07 1A D5 DD E9 06 67 D8 E9 0A 45 AF 42 08 BF A6 42 12 D0 00 20 1C B0 BD E8 F0 87 49 00 D8 F8 0C 00 C8 F8 10 10 ?? ?? ?? ?? 00 28 63 D0 D8 F8 14 30 02 46 C8 F8 0C 00 B7 E7 01 2A 40 F0 88 80 13 F0 01 06 7E D1 DD E9 06 45 ?? ?2 0? 0? 09 9B ?? ?2 0? 0? 02 A8 08 F1 30 01 CD E9 02 45 04 93 ?? ?? ?? ?? 00 28 66 D0 30 46 D4 E7 53 78 00 2B D0 D0 2E 2B 8E D1 93 78 00 2B 8B D1 CA E7 D8 F8 1C 30 0D F1 18 0A 03 20 5A 07 52 46 58 BF D8 F8 0C 40 DF 07 21 46 2B D5 ?? ?? ?? ?? 00 28 A1 DA 30 4B 1D EE 70 2F 7B 44 1B 68 D3 58 02 2B 18 BF 0D 2B D8 F8 1C 30 1E D1 DE 07 25 D4 24 9A 0A 2A 48 D0 D9 F8 04 10 4D 1C 46 D0 4F F4 80 73 22 46 00 93 03 20 53 46 ?? ?? ?? ?? A8 B9 0A 9B 03 F4 70 43 B3 F5 20 4F 0F D1 D8 F8 1C 30 06 22 87 E7 ?? ?? ?? ?? 74 E7 4F F0 FF 30 1C B0 BD E8 F0 87 D8 F8 1C 30 01 22 7B E7 0C 22 D8 F8 20 50 51 46 D8 F8 24 40 08 F1 14 03 D8 F8 0C 00 AA 58 A0 47 D8 F8 1C 30 DC 06 7F F5 76 AF 02 28 3F F4 72 AF 1C B0 BD E8 F0 87 40 46 51 46 09 AA FF F7 00 FF 00 28 ED D1 51 46 4A 46 40 46 00 F0 0D F8 E7 E7 92 00 DA E7 06 22 53 E7 21 46 52 46 03 20 ?? ?? ?? ?? BA E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_3_0 {
	meta:
		name = "ftw_dir"
		size = 1244
		refs = "002c malloc 004e strlen 006e realloc 0084 mempcpy 008e __readdir64 00c2 __closedir 0106 __openat64_nocancel 0116 __fdopendir 015a __rawmemchr 01f6 free 024c __fchdir 0266 __opendir 0282 .LC0 03b0 .LC6 03b8 __chdir 0412 .LC5 042c __libc_do_syscall 0446 .LC3 044a .LC2 044e __PRETTY_FUNCTION__.11068 0462 __assert_fail 0466 .LC4 0486 .LC1 048e __PRETTY_FUNCTION__.11034 04a8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 8D B0 07 46 03 92 42 69 03 9B 06 91 05 92 00 2B 00 F0 93 81 04 33 04 93 7A 68 3B 68 53 F8 22 50 00 2D 60 D0 4F F4 80 60 ?? ?? ?? ?? 80 46 00 28 00 F0 C6 81 00 24 D5 F8 00 90 A2 46 4F F4 80 66 07 97 21 E0 00 F1 13 0B 58 46 ?? ?? ?? ?? 07 19 05 46 BA 1C B2 42 0E D3 42 00 40 46 B2 F5 80 6F 2C BF B6 18 06 F5 80 66 31 46 ?? ?? ?? ?? 00 28 00 F0 4C 81 80 46 08 EB 04 00 59 46 2A 46 7C 1C ?? ?? ?? ?? 80 F8 00 A0 48 46 ?? ?? ?? ?? 00 28 D8 D1 07 9F 61 1C 08 F8 04 00 05 46 40 46 7A 68 3B 68 53 F8 22 40 ?? ?? ?? ?? 7A 68 3B 68 A0 60 53 F8 22 30 9B 68 00 2B 00 F0 9A 81 48 46 ?? ?? ?? ?? 97 E8 0C 00 4F F0 FF 30 52 F8 23 10 0D 60 52 F8 23 10 48 60 42 F8 23 50 3A 68 52 F8 23 30 00 2B 40 F0 CE 81 04 9B 00 2B 00 F0 B6 80 18 68 41 1C 00 F0 B2 80 FC 68 4F F4 90 42 79 69 00 23 21 44 ?? ?? ?? ?? 00 23 09 93 42 1C 04 46 00 F0 68 81 ?? ?? ?? ?? 09 90 00 28 00 F0 82 81 00 68 00 24 7A 68 09 AD 39 68 BE 68 53 1C 0A 90 B3 42 0B 94 41 F8 22 50 7B 60 FB 69 08 BF 7C 60 1A 07 40 F1 FE 80 5E 07 00 F1 06 81 BB 69 00 21 FC 68 01 33 BB 61 20 46 ?? ?? ?? ?? 84 42 00 F0 71 81 10 F8 01 3C 2F 2B 1F BF 2F 22 02 70 FC 68 43 1C 08 BF 03 46 1C 1B 7C 61 14 E0 ?? ?? ?? ?? 04 46 00 28 00 F0 88 80 04 F1 13 06 30 46 ?? ?? ?? ?? A4 7C 32 46 29 46 00 94 03 46 38 46 FF F7 3A FE 00 28 77 D1 09 98 00 28 E7 D1 0B 9E 34 78 00 2C 00 F0 45 81 4F F0 00 08 02 E0 99 F8 01 30 83 B1 30 46 00 21 ?? ?? ?? ?? 32 46 CD F8 00 80 29 46 81 46 83 1B 38 46 09 F1 01 06 FF F7 1B FE 00 28 EB D0 04 46 0B 98 AF 4B 1D EE 70 5F 7B 44 1B 68 EE 58 ?? ?? ?? ?? AC 4B 7B 44 1B 68 EE 50 FB 69 DD 06 01 D5 03 2C 69 D0 FA 68 00 21 7B 69 13 44 03 F8 01 1C 05 9A BB 69 7A 61 01 3B BB 61 00 2C 67 D0 03 9B AB B1 FB 69 58 07 12 D5 34 B1 D9 06 0F D5 B4 F1 FF 3F 18 BF 01 2C 0A D0 03 9A 13 68 00 2B 00 F0 B0 80 18 68 ?? ?? ?? ?? 00 28 40 F0 AA 80 20 46 0D B0 BD E8 F0 8F FB 69 5B 07 0D D4 F8 68 ?? ?? ?? ?? 09 90 00 28 7F F4 58 AF 8F 4B 1D EE 70 2F 7B 44 1B 68 D3 58 56 E0 F9 68 ?? ?2 0? 0? 7A 69 ?? ?2 0? 0? 88 18 8A 5C 00 2A 08 BF 18 46 E6 E7 04 46 09 98 00 28 00 F0 CC 80 84 4B 1D EE 70 5F 0B 9A 7B 44 1B 68 EE 58 00 2A 40 F0 D8 80 ?? ?? ?? ?? 7F 4B 4F F0 FF 31 7A 68 0A 91 7B 44 1B 68 51 18 79 60 EE 50 12 B9 B9 68 01 39 79 60 3B 68 00 22 43 F8 21 20 90 E7 FA 68 00 21 7B 69 13 44 03 F8 01 1C 05 9A BB 69 7A 61 01 3B BB 61 FC 69 14 F0 08 04 93 D0 7C 6A 05 22 06 99 07 F1 14 03 F8 68 A0 47 04 46 8A E7 6A 4B 1D EE 70 4F 40 46 07 9F 7B 44 1B 68 E5 58 ?? ?? ?? ?? 66 4A 2B 46 7A 44 12 68 A5 50 0D 2B 50 D0 4F F0 FF 34 20 46 0D B0 BD E8 F0 8F 03 9A 04 92 6B E6 7C 6A 01 22 06 99 07 F1 14 03 F8 68 A0 47 04 46 50 B9 FB 69 F6 E6 09 9B 18 68 ?? ?? ?? ?? 00 28 BF F6 F3 AE 4F F0 FF 34 55 4B 1D EE 70 5F 09 98 7B 44 1B 68 EE 58 ?? ?? ?? ?? 52 4B 4F F0 FF 31 7A 68 0A 91 7B 44 1B 68 51 18 79 60 EE 50 12 B9 B9 68 01 39 79 60 3B 68 00 22 20 46 43 F8 21 20 0D B0 BD E8 F0 8F 7B 69 01 2B 30 D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 BF F6 4A AF B6 E7 41 4B 1D EE 70 2F 7B 44 1B 68 D3 58 0D 2B AE D1 7C 6A 07 F1 14 03 06 99 02 22 F8 68 A0 47 04 46 37 E7 3A 4B 1D EE 70 2F 7B 44 1B 68 D3 58 9C E7 37 4B 1D EE 70 4F 40 46 7B 44 1B 68 E5 58 ?? ?? ?? ?? 34 4A 2B 46 7A 44 12 68 A5 50 8D E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 BF F6 19 AF 85 E7 20 46 4F F0 06 0C ?? ?? ?? ?? 09 98 00 28 7F F4 75 AE 1B E7 0B 9E 00 2C 3F F4 B7 AE 30 46 D1 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 1A 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 0C 72 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 A9 72 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_4_0 {
	meta:
		name = "ftw_startup"
		size = 880
		refs = "003e memset 0044 strlen 0056 malloc 0066 stpcpy 00d8 .LC0 00fa __lxstat 011e __open 0156 __chdir 018a free 01a0 __xstat 01ee __fchdir 01f8 __libc_do_syscall 0210 __tdestroy 0286 __getcwd 02e0 .LC5 0338 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F A5 B0 0D 46 00 AF 81 46 01 78 90 46 D7 F8 B8 60 00 29 00 F0 54 81 01 2B AC BF 1A 46 01 22 BA 60 00 20 78 60 92 00 01 46 02 F1 0E 03 23 F0 07 03 AD EB 03 0D C7 F8 00 D0 68 46 ?? ?? ?? ?? 48 46 ?? ?? ?? ?? 40 00 B0 F5 80 5F 38 BF 4F F4 80 50 38 61 ?? ?? ?? ?? 04 46 F8 60 00 28 00 F0 55 81 49 46 ?? ?? ?? ?? 62 1C 90 42 03 D8 06 E0 01 38 90 42 03 D0 10 F8 01 3C 2F 2B F8 D0 84 42 4F F0 00 03 03 70 BB 61 03 D3 06 E0 01 38 A0 42 03 D0 10 F8 01 3C 2F 2B F8 D1 A5 4B 4F F0 00 09 00 1B C7 F8 24 80 A3 F1 1C 02 C7 F8 30 90 4D 45 0C BF 1D 46 15 46 16 F0 04 03 FE 61 08 BF 99 46 78 61 08 BF 4F F0 FF 3A 3D 62 08 BF 1D EE 70 8F 1E D1 4B B1 7A 69 ?? ?2 0? 0? ?? ?2 0? 0? 14 44 22 78 00 2A 08 BF 1C 46 16 F0 01 05 07 F1 38 0B 52 D0 21 46 5A 46 03 20 ?? ?? ?? ?? 00 28 52 DA 8D 4B 4F F0 FF 35 7B 44 1B 68 58 F8 03 40 63 E0 ?? ?2 0? 0? 4F F4 80 41 ?? ?2 0? 0? ?? ?? ?? ?? B0 F1 FF 3F 82 46 00 F0 A0 80 BB 68 1D EE 70 8F 01 2B 84 BF 03 F1 FF 33 BB 60 7B 69 00 2B 40 F3 C9 80 01 2B 00 F0 CB 80 FA 68 01 3B 00 21 D4 5C D1 54 F8 68 ?? ?? ?? ?? FA 68 7B 69 13 44 03 F8 01 4C 05 46 00 2D 00 F0 B5 80 73 4B BA F1 FF 3F 7B 44 1B 68 58 F8 03 40 37 D1 B9 F1 00 0F 41 D0 48 46 ?? ?? ?? ?? 48 46 ?? ?? ?? ?? 6C 4B 7B 44 1B 68 48 F8 03 40 35 E0 03 20 5A 46 21 46 ?? ?? ?? ?? 00 28 42 DB B9 6C 01 F4 70 41 B1 F5 80 4F 75 D0 3A 6A B1 F5 20 4F 0C BF 10 25 00 25 7C 6A 07 F1 14 03 59 46 F8 68 52 59 A0 47 5D 4B 7B 44 1B 68 58 F8 03 40 05 46 F3 06 03 D5 AB 1E 01 2B 98 BF 00 25 BA F1 FF 3F C7 D0 50 46 ?? ?? ?? ?? 50 46 4F F0 06 0C ?? ?? ?? ?? 52 4B 7B 44 1B 68 48 F8 03 40 ?? ?2 0? 0? 38 6B ?? ?2 0? 0? ?? ?? ?? ?? F8 68 ?? ?? ?? ?? 4C 4B 28 46 7B 44 1B 68 48 F8 03 40 94 37 BD 46 BD E8 F0 8F 48 4A 7A 44 12 68 58 F8 02 20 02 2A 1C BF 14 46 4F F0 FF 35 CA D1 21 46 03 20 5A 46 ?? ?? ?? ?? 28 B9 BA 6C 02 F4 70 42 B2 F5 20 4F 5B D0 3D 4B 4F F0 FF 35 7B 44 1B 68 58 F8 03 40 B6 E7 3A 4B 1D EE 70 8F 7B 44 1B 68 58 F8 03 40 0D 2C 18 BF 4D 46 C1 D1 48 46 49 46 ?? ?? ?? ?? 81 46 00 28 7F F4 55 AF 32 4B 05 46 7B 44 1B 68 58 F8 03 40 B2 E7 D7 E9 0E 23 C7 E9 0A 23 15 B3 38 46 59 46 00 22 FF F7 38 FC 2A 4B 7B 44 1B 68 58 F8 03 40 05 46 8B E7 28 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 D1 50 A7 E7 FB 69 FC 68 03 F0 04 03 F9 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 05 46 3A E7 59 46 38 46 07 F1 44 02 FF F7 00 FB 05 46 00 28 D3 D0 19 4B 7B 44 1B 68 58 F8 03 40 65 E7 4F F0 FF 30 88 E7 3A 6A 07 F1 14 03 7C 6A 59 46 F8 68 92 69 A0 47 11 4B 7B 44 1B 68 58 F8 03 40 05 46 53 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_5_0 {
	meta:
		name = "ftw"
		size = 22
		altNames = "ftw64"
	strings:
		$1 = { 10 B5 82 B0 0C 46 13 46 00 21 22 46 00 91 FF F7 3F FE 02 B0 10 BD }
	condition:
		$1
}

rule file_264_6_0 {
	meta:
		name = "__new_nftw"
		size = 52
		refs = "0030 __libc_errno"
		altNames = "__new_nftw64"
	strings:
		$1 = { 10 B5 14 46 33 F0 1F 02 82 B0 07 D1 00 93 0A 46 23 46 01 21 FF F7 30 FE 02 B0 10 BD 04 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "pmap_getmaps"
		size = 216
		refs = "001c __get_socket 003a clnttcp_create 004c xdr_pmaplist 0054 xdr_void 008c __libc_do_syscall 00a2 _libc_intl_domainname 00a6 .LC0 00b4 __dcgettext 00bc clnt_perror 00d4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 88 B0 4F F4 DE 42 42 80 3C 23 05 46 00 26 06 93 04 96 4F F4 FA 74 07 96 ?? ?? ?? ?? 08 AB 48 F2 A0 61 32 22 C0 F2 01 01 07 46 28 46 43 F8 0C 7D 8D E8 14 00 02 22 ?? ?? ?? ?? 04 46 F8 B1 08 AB D0 F8 04 80 0D F1 08 0C ?? ?2 0? 0? 13 E9 03 00 ?? ?2 0? 0? 33 46 ?? ?2 0? 0? 04 AE CD F8 00 E0 01 96 ?? ?2 0? 0? 8C E8 03 00 20 46 D8 F8 00 60 04 21 B0 47 98 B9 63 68 20 46 1B 69 98 47 01 37 07 D0 05 98 4F F0 06 0C ?? ?? ?? ?? 10 F5 80 5F 15 D8 00 23 04 98 6B 80 08 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 20 46 ?? ?? ?? ?? DB E7 04 4B 1D EE 70 2F 40 42 7B 44 1B 68 D0 50 E1 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "fputws_unlocked"
		size = 54
		refs = "0006 __wcslen 0010 _IO_fwide"
	strings:
		$1 = { F8 B5 0C 46 07 46 ?? ?? ?? ?? 01 21 06 46 20 46 ?? ?? ?? ?? 01 28 05 46 0A D1 D4 F8 98 30 39 46 20 46 32 46 DB 69 98 47 B0 42 01 D1 28 46 F8 BD 4F F0 FF 30 F8 BD }
	condition:
		$1
}

rule file_267_1_0 {
	meta:
		name = "updwtmp_file"
		size = 360
		refs = "0012 __libc_do_syscall 002a alarm 0032 timeout_handler 0042 memset 004e __sigaction 006a __fcntl_nocancel 0086 __lseek64 0094 __aeabi_ldivmod 00c8 __ftruncate64 0160 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 88 46 01 21 CD B0 C0 F2 02 01 4F F0 05 0C ?? ?? ?? ?? 10 F5 80 5F 06 46 00 F2 8E 80 00 28 C0 F2 88 80 00 20 00 24 ?? ?? ?? ?? 00 21 80 22 ?? ?2 0? 0? ?? ?2 0? 0? 06 93 01 25 07 46 07 A8 ?? ?? ?? ?? 06 A9 29 AA 0E 20 27 94 ?? ?? ?? ?? 0A 20 ?? ?? ?? ?? 02 AA 30 46 07 21 02 94 03 94 04 94 05 94 AD F8 08 50 ?? ?? ?? ?? A0 42 B8 BF 4F F0 FF 34 31 DB 00 22 00 23 4F F0 02 09 30 46 CD F8 00 90 ?? ?? ?? ?? 4F F4 C0 72 00 23 04 46 0D 46 ?? ?? ?? ?? 52 EA 03 01 34 D1 41 46 30 46 4F F4 C0 72 4F F0 04 0C ?? ?? ?? ?? 10 F5 80 5F 4D D8 B0 F5 C0 7F 08 BF 00 24 06 D0 22 46 2B 46 30 46 4F F0 FF 34 ?? ?? ?? ?? 02 AA 30 46 07 21 02 23 AD F8 08 30 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 29 A9 0E 20 00 22 ?? ?? ?? ?? 47 B9 30 46 4F F0 06 0C ?? ?? ?? ?? 20 46 4D B0 BD E8 F0 83 38 46 ?? ?? ?? ?? F2 E7 A4 1A 65 EB 03 05 30 46 22 46 2B 46 ?? ?? ?? ?? 00 23 CD F8 00 90 30 46 00 22 ?? ?? ?? ?? 00 28 71 F1 00 03 B8 BF 4F F0 FF 34 B4 DA CA E7 4F F0 FF 30 DE E7 08 4B 1D EE 70 2F 46 42 4F F0 FF 30 7B 44 1B 68 D6 50 D4 E7 04 4B 1D EE 70 2F 40 42 7B 44 1B 68 D0 50 AE E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_2_0 {
	meta:
		name = "setutent_file"
		size = 412
		refs = "0002 .LANCHOR0 0012 .LANCHOR1 0026 __lseek64 003e __libc_utmp_file_name 0042 .LC2 0052 strcmp 005c .LC3 0070 .LC1 0084 .LC0 00ae __libc_do_syscall 00ba __have_o_cloexec 00ce __fcntl_nocancel 00f8 __access 0198 __libc_errno"
	strings:
		$1 = { 70 B5 ?? ?2 0? 0? ?? ?2 0? 0? 82 B0 2B 68 00 2B A4 BF ?? ?2 0? 0? ?? ?2 0? 0? 10 DB 18 46 00 21 00 22 00 23 00 91 ?? ?? ?? ?? 01 20 00 22 00 23 4F F6 FF 71 C4 E9 02 23 21 82 02 B0 70 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 26 68 30 46 ?? ?? ?? ?? 01 46 00 28 49 D0 ?? ?2 0? 0? 30 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 00 28 48 D0 ?? ?2 0? 0? 30 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 00 28 47 D0 ?? ?2 0? 0? 30 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 30 46 00 29 45 D0 ?? ?2 0? 0? 00 23 ?? ?2 0? 0? 4F F4 20 21 4F F0 05 0C 23 70 ?? ?? ?? ?? 10 F5 80 5F 03 46 61 D8 ?? ?2 0? 0? 28 60 ?? ?2 0? 0? 32 68 00 2A A8 DC 01 21 00 22 ?? ?? ?? ?? 00 28 4A DB 33 68 33 B9 10 F0 01 0F 0C BF 4F F0 FF 33 01 23 33 60 00 2B 39 DB 2B 68 95 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? E0 B1 26 68 AC E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C0 B1 26 68 AD E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? A0 B9 26 68 AE E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 80 B9 20 68 B0 E7 ?? ?2 0? 0? ?? ?2 0? 0? AB E7 ?? ?2 0? 0? ?? ?2 0? 0? A6 E7 ?? ?2 0? 0? ?? ?2 0? 0? A1 E7 ?? ?2 0? 0? ?? ?2 0? 0? 9C E7 40 F0 01 02 02 21 28 68 ?? ?? ?? ?? 01 30 BD D1 28 68 4F F0 06 0C ?? ?? ?? ?? 00 20 5D E7 06 4A 1D EE 70 1F 43 42 4F F0 FF 34 7A 44 12 68 00 20 2C 60 8B 50 51 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_3_0 {
	meta:
		name = "__utmp_equal"
		size = 78
		refs = "0028 strncmp"
	strings:
		$1 = { 08 B5 03 88 05 3B 9B B2 03 2B 14 D8 0B 88 05 3B 9B B2 03 2B 0F D8 90 F8 28 30 73 B1 91 F8 28 30 5B B1 28 31 04 22 28 30 ?? ?? ?? ?? D0 F1 01 00 38 BF 00 20 08 BD 00 20 08 BD 08 31 20 22 08 30 ?? ?? ?? ?? D0 F1 01 00 38 BF 00 20 08 BD }
	condition:
		$1
}

rule file_267_4_0 {
	meta:
		name = "getutline_r_file"
		size = 384
		refs = "0004 .LANCHOR0 001e .LANCHOR1 0046 timeout_handler 004a alarm 005e memset 006a __sigaction 0084 __fcntl_nocancel 00a4 __libc_do_syscall 00d6 strncmp 00e4 memcpy 0154 .LC4 0158 .LC5 015c __PRETTY_FUNCTION__.11801 0170 __assert_fail 017c __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 91 46 CD B0 80 46 DB F8 00 20 01 91 00 2A C0 F2 9B 80 ?? ?2 0? 0? ?? ?2 0? 0? D6 E9 02 45 B5 F1 FF 3F 08 BF B4 F1 FF 3F 02 BF 00 23 4F F0 FF 30 C9 F8 00 30 00 F0 81 80 00 20 ?? ?2 0? 0? ?? ?? ?? ?? 00 21 80 22 ?? ?2 0? 0? 06 94 00 24 82 46 07 A8 ?? ?? ?? ?? 06 A9 29 AA 0E 20 27 94 ?? ?? ?? ?? 0A 20 ?? ?? ?? ?? 02 AA DB F8 00 00 07 21 02 94 03 94 04 94 05 94 ?? ?? ?? ?? A0 42 B8 BF C9 F8 00 40 47 DB 08 F1 08 08 DB F8 00 00 4F F4 C0 72 35 49 4F F0 03 0C ?? ?? ?? ?? 10 F5 80 5F 07 46 1F D8 B0 F5 C0 7F 1C D1 32 8A D6 E9 02 45 06 3A 14 F5 C0 74 92 B2 45 F1 00 05 01 2A C6 E9 02 45 E2 D8 40 46 29 49 20 22 ?? ?? ?? ?? 00 28 DB D1 3A 46 01 98 24 49 ?? ?? ?? ?? 01 9B C9 F8 00 30 0F E0 22 4A 1D EE 70 7F 03 25 4F F0 FF 30 7A 44 12 68 4F F0 FF 31 00 24 C6 E9 02 01 BD 50 C9 F8 00 40 DB F8 00 00 02 AA 07 21 02 23 AD F8 08 30 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 29 A9 0E 20 00 22 ?? ?? ?? ?? BA F1 00 0F 09 D1 D9 F8 00 00 00 28 14 BF 00 20 6F F0 00 00 4D B0 BD E8 F0 8F 50 46 ?? ?? ?? ?? F1 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 59 12 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_5_0 {
	meta:
		name = "getutent_r_file"
		size = 328
		refs = "0004 .LANCHOR0 0018 .LANCHOR1 0034 alarm 003c timeout_handler 004a memset 0056 __sigaction 006e __fcntl_nocancel 0088 __libc_do_syscall 00d8 memcpy 010e .LC4 0112 .LC5 0116 __PRETTY_FUNCTION__.11732 0128 __assert_fail 0144 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? CB B0 06 46 0F 46 23 68 00 2B 7A DB ?? ?2 0? 0? ?? ?2 0? 0? D8 E9 02 23 B3 F1 FF 3F 08 BF B2 F1 FF 3F 67 D0 00 20 00 25 ?? ?? ?? ?? 00 21 80 22 ?? ?2 0? 0? ?? ?2 0? 0? 04 93 81 46 05 A8 ?? ?? ?? ?? 04 A9 27 AA 0E 20 25 95 ?? ?? ?? ?? 0A 20 ?? ?? ?? ?? 20 68 6A 46 07 21 00 95 01 95 02 95 03 95 ?? ?? ?? ?? A8 42 B8 BF 2C 46 15 DB 20 68 08 F1 10 01 4F F4 C0 72 4F F0 03 0C ?? ?? ?? ?? 10 F5 80 5F 82 46 4B D8 20 68 6A 46 07 21 02 23 54 46 AD F8 00 30 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 27 A9 0E 20 00 22 ?? ?? ?? ?? B9 F1 00 0F 14 D1 B4 F5 C0 7F 17 D1 D8 E9 02 AB 22 46 30 46 1D 49 1A F5 C0 74 4B F1 00 05 C8 E9 02 45 ?? ?? ?? ?? 00 20 3E 60 4B B0 BD E8 F0 8F 48 46 ?? ?? ?? ?? B4 F5 C0 7F E7 D0 2C B1 4F F0 FF 32 4F F0 FF 33 C8 E9 02 23 00 23 4F F0 FF 30 3B 60 4B B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CC 22 ?? ?? ?? ?? 05 4B 1D EE 70 2F 41 42 4F F0 FF 3A 7B 44 1B 68 D1 50 A9 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_6_0 {
	meta:
		name = "endutent_file"
		size = 64
		refs = "0002 .LANCHOR0 0014 __libc_do_syscall 0020 .LC4 0024 .LC5 0028 __PRETTY_FUNCTION__.11926 003c __assert_fail"
	strings:
		$1 = { 08 B5 ?? ?2 0? 0? ?? ?2 0? 0? 18 68 00 28 07 DB 4F F0 06 0C ?? ?? ?? ?? 4F F0 FF 32 1A 60 08 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 04 72 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_7_0 {
	meta:
		name = "internal_getut_r.constprop.2"
		size = 364
		refs = "000e alarm 0012 .LANCHOR0 001a timeout_handler 002e memset 003a __sigaction 0052 __fcntl_nocancel 006a .LANCHOR1 00a4 __libc_do_syscall 0164 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 80 46 CB B0 00 20 0D 46 91 46 ?? ?? ?? ?? ?? ?2 0? 0? 00 21 80 22 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 04 93 00 24 07 46 05 A8 ?? ?? ?? ?? 04 A9 27 AA 0E 20 25 94 ?? ?? ?? ?? 0A 20 ?? ?? ?? ?? 30 68 6A 46 07 21 00 94 01 94 02 94 03 94 ?? ?? ?? ?? A0 42 BE BF 01 23 4F F0 FF 35 89 F8 00 30 3E DB B8 F8 00 30 ?? ?2 0? 0? ?? ?2 0? 0? 01 3B 9B B2 03 2B 4F D8 0D E0 D4 E9 02 23 B8 F9 00 00 B5 F9 00 10 12 F5 C0 72 43 F1 00 03 C4 E9 02 23 88 42 62 D0 30 68 29 46 4F F4 C0 72 4F F0 03 0C ?? ?? ?? ?? 10 F5 80 5F 02 D8 B0 F5 C0 7F E3 D0 2B 49 1D EE 70 EF 4F F0 FF 35 03 20 79 44 09 68 4F F0 FF 32 4F F0 FF 33 C4 E9 02 23 4E F8 01 00 30 68 6A 46 07 21 02 23 AD F8 00 30 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 27 A9 0E 20 00 22 ?? ?? ?? ?? 17 B1 38 46 ?? ?? ?? ?? 28 46 4B B0 BD E8 F0 83 D4 E9 02 23 12 F5 C0 72 43 F1 00 03 C4 E9 02 23 FF F7 C8 FD 08 BB 30 68 29 46 4F F4 C0 72 4F F0 03 0C ?? ?? ?? ?? 03 46 41 46 13 F5 80 5F 28 46 02 D8 B3 F5 C0 7F E3 D0 0A 49 1D EE 70 EF 03 20 4F F0 FF 32 79 44 09 68 4F F0 FF 33 4F F0 FF 35 C4 E9 02 23 4E F8 01 00 BA E7 00 25 B8 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_8_0 {
	meta:
		name = "getutid_r_file"
		size = 146
		refs = "0000 .LANCHOR0 0018 .LANCHOR1 0062 memcpy 0072 .LC4 0076 .LC5 007a __PRETTY_FUNCTION__.11794 008e __assert_fail"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 41 0F 46 1B 68 82 B0 90 46 00 2B 2C DB ?? ?2 0? 0? ?? ?2 0? 0? D6 E9 02 45 B5 F1 FF 3F 08 BF B4 F1 FF 3F 02 BF 00 23 4F F0 FF 30 13 60 18 D0 02 AA 00 24 06 F1 10 01 02 F8 01 4D FF F7 25 FF A0 42 BC BF C8 F8 00 40 4F F0 FF 30 09 DB 06 F1 10 01 38 46 4F F4 C0 72 ?? ?? ?? ?? 20 46 C8 F8 00 70 02 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 3B 12 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_9_0 {
	meta:
		name = "pututline_file"
		size = 1112
		refs = "0004 .LANCHOR0 001a .LANCHOR1 0028 __libc_utmp_file_name 002c .LC2 003c strcmp 0048 .LC3 005e .LC1 0074 .LC0 0096 __libc_do_syscall 00a4 __have_o_cloexec 00c2 __lseek64 00ea __dup2 0158 alarm 0160 timeout_handler 0176 memset 0184 __sigaction 01a6 __fcntl_nocancel 02c6 __aeabi_ldivmod 02de __access 039a __ftruncate64 03ee .LC4 03f2 .LC5 03f6 __PRETTY_FUNCTION__.11837 040a __assert_fail 044c __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? AD F5 33 7D 80 46 33 68 00 2B C0 F2 EA 81 ?? ?2 0? 0? ?? ?2 0? 0? 3B 78 00 2B 6C D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 25 68 28 46 ?? ?? ?? ?? 01 46 00 28 00 F0 47 81 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 00 28 00 F0 69 81 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 00 28 00 F0 6A 81 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 28 46 00 29 00 F0 67 81 02 21 4F F0 05 0C C0 F2 0A 01 ?? ?? ?? ?? 10 F5 80 5F 04 46 00 F2 C9 81 ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 00 2B 40 F3 1B 81 01 21 00 22 00 23 30 68 00 91 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 02 46 0B 46 20 46 00 21 00 91 ?? ?? ?? ?? B1 F1 FF 3F 08 BF B0 F1 FF 3F 00 F0 49 81 29 68 20 46 ?? ?? ?? ?? 00 28 C0 F2 42 81 20 46 4F F0 06 0C ?? ?? ?? ?? 01 23 3B 70 D7 E9 02 23 ?? ?2 0? 0? ?? ?2 0? 0? 01 2A 73 F1 00 00 0C DB 0B 8A B8 F8 00 20 93 42 00 F0 8A 80 BB 48 41 46 FF F7 BF FC 00 28 40 F0 87 80 0D F1 BC 0A 40 46 52 46 52 A9 00 24 8A F8 00 40 FF F7 5E FE 9A F8 00 50 03 95 05 90 00 2D 40 F0 69 81 03 98 0D F1 20 0B ?? ?? ?? ?? 03 99 80 22 ?? ?2 0? 0? ?? ?2 0? 0? 0C 93 ?? ?2 0? 0? ?? ?2 0? 0? 04 90 0D A8 ?? ?? ?? ?? 03 9C 0C A9 52 46 0E 20 2D 94 ?? ?? ?? ?? 0A 20 ?? ?? ?? ?? 03 9D 5A 46 30 68 07 21 CB F8 00 40 09 94 0A 94 01 24 0B 95 AB F8 00 40 ?? ?? ?? ?? 00 28 C0 F2 C9 80 05 9C 00 2C 7A DB D7 E9 02 45 00 23 30 68 B4 F5 C0 74 00 93 45 F1 FF 35 22 46 2B 46 C7 E9 02 45 ?? ?? ?? ?? 30 68 41 46 4F F4 C0 72 4F F0 04 0C ?? ?? ?? ?? 10 F5 80 5F 00 F2 14 81 B0 F5 C0 7F 53 D0 05 9C 00 2C A8 BF 4F F0 00 08 C0 F2 C8 80 30 68 5A 46 07 21 02 23 AB F8 00 30 ?? ?? ?? ?? 00 20 ?? ?? ?? ?? 51 46 0E 20 00 22 ?? ?? ?? ?? 04 9D 25 B9 40 46 0D F5 33 7D BD E8 F0 8F 28 46 ?? ?? ?? ?? F6 E7 01 3B 03 2B 3F F6 72 AF 00 20 0D F1 BC 0A ?? ?? ?? ?? 00 21 80 22 ?? ?2 0? 0? ?? ?2 0? 0? 0C 93 00 24 0D F1 20 0B 01 25 04 90 0D A8 ?? ?? ?? ?? 0C A9 52 46 0E 20 2D 94 ?? ?? ?? ?? 0A 20 ?? ?? ?? ?? 21 46 10 22 58 46 ?? ?? ?? ?? 5A 46 30 68 07 21 AB F8 00 50 ?? ?? ?? ?? A0 42 C0 F2 D9 80 05 95 8D E7 D7 E9 02 23 12 F5 C0 72 43 F1 00 03 C7 E9 02 23 A9 E7 00 22 00 23 02 25 D9 F8 00 00 00 95 ?? ?? ?? ?? 4F F4 C0 72 00 23 04 46 0D 46 ?? ?? ?? ?? 52 EA 03 00 6C D1 C7 E9 02 45 7E E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 43 D0 25 68 AE E6 30 68 01 21 00 22 ?? ?? ?? ?? 00 28 11 DB 2B 68 33 B9 10 F0 01 0F 0C BF 4F F0 FF 33 01 23 2B 60 00 2B BF F6 D2 AE 40 F0 01 02 02 21 30 68 ?? ?? ?? ?? 01 30 7F F4 C9 AE 30 68 4F F0 06 0C ?? ?? ?? ?? 00 20 7A E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 18 B3 25 68 8D E6 DD F8 0C 80 63 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 20 BB 25 68 8C E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 3C D1 20 68 8E E6 ?? ?2 0? 0? ?? ?2 0? 0? 89 E6 20 46 4F F0 06 0C ?? ?? ?? ?? 00 20 4F E7 ?? ?2 0? 0? ?? ?2 0? 0? 7D E6 30 68 4F F0 00 08 D7 E9 02 23 ?? ?? ?? ?? 2F E7 ?? ?2 0? 0? ?? ?2 0? 0? 70 E6 20 46 29 46 80 1A 61 EB 03 01 C7 E9 02 01 D7 E9 02 23 D9 F8 00 00 ?? ?? ?? ?? 02 21 00 22 D9 F8 00 00 00 91 00 23 ?? ?? ?? ?? 00 28 71 F1 00 02 BF F6 FB AE DD F8 0C 80 0D E7 ?? ?2 0? 0? ?? ?2 0? 0? 4E E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 C8 72 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? 0D 4B 1D EE 70 2F 40 42 7B 44 1B 68 D0 50 E6 E6 0A 4B 1D EE 70 2F 0B 21 20 46 7B 44 1B 68 D1 50 F7 E6 07 4B 1D EE 70 2F 44 42 00 20 7B 44 1B 68 D4 50 EE E6 A0 46 E1 E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "cfsetspeed"
		size = 104
		refs = "0002 .LANCHOR0 0040 cfsetispeed 0048 cfsetospeed 0064 __libc_errno"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? ?? ?2 0? 0? 0C 46 07 46 31 46 00 23 F2 18 55 68 A5 42 10 D0 5A 58 08 33 A2 42 16 D0 B3 F5 80 7F F4 D1 0E 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 F8 BD 21 46 38 46 ?? ?? ?? ?? 38 46 21 46 ?? ?? ?? ?? 00 20 F8 BD 29 46 38 46 ?? ?? ?? ?? 38 46 29 46 ?? ?? ?? ?? 00 20 F8 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_269_1_0 {
	meta:
		name = "strcpy"
		size = 522
	strings:
		$1 = { 84 46 90 F8 00 F0 91 F8 00 F0 01 F0 07 03 C3 F1 10 03 11 F8 01 2B 01 3B 00 F8 01 2B 18 BF 00 2A F7 D1 00 2A 32 D0 F1 E8 02 23 90 F8 40 F0 91 F8 40 F0 F0 B4 40 F2 01 17 10 F0 03 0F C0 F2 01 17 2A D1 00 BF AF F3 00 80 AF F3 00 80 AF F3 00 80 C7 FA 52 F4 C7 FA 53 F5 91 F8 80 F0 00 2C 90 F8 80 F0 08 D1 40 F8 04 2B 00 2D 06 D1 40 F8 04 3B F1 E8 02 23 EC E7 A1 F1 04 01 A1 F1 04 01 11 F8 01 2B 00 2A 00 F8 01 2B F9 D1 F0 BC BC F1 00 0F 0C BF 01 38 60 46 70 47 10 F0 01 0F 3D D0 10 F0 02 0F 76 D1 C7 FA 52 F4 C7 FA 53 F5 E4 43 18 BF 08 39 E4 D1 00 F8 01 2B 4F EA 12 22 00 F8 01 2B 4F EA 12 22 00 F8 01 2B 4F EA 12 22 AF F3 00 80 ED 43 1B D1 42 EA 03 22 4F EA 13 66 40 F8 04 2B F1 E8 02 23 C7 FA 52 F4 91 F8 80 F0 C7 FA 53 F5 90 F8 80 F0 E4 43 06 D1 46 EA 02 26 4F EA 12 62 40 F8 04 6B E4 E7 A1 F1 04 01 32 46 A1 F1 04 01 00 F8 01 2B 4F EA 12 22 B1 E7 C7 FA 52 F4 C7 FA 53 F5 E4 43 18 BF 08 39 A9 D1 00 F8 01 2B 4F EA 12 22 00 F8 01 2B 4F EA 12 22 00 BF AF F3 00 80 ED 43 1B D1 42 EA 03 42 4F EA 13 46 40 F8 04 2B F1 E8 02 23 C7 FA 52 F4 91 F8 80 F0 C7 FA 53 F5 90 F8 80 F0 E4 43 06 D1 46 EA 02 46 4F EA 12 42 40 F8 04 6B E4 E7 A1 F1 04 01 32 46 A1 F1 04 01 00 F8 01 2B 4F EA 12 22 00 F8 01 2B 4F EA 12 22 75 E7 C7 FA 52 F4 C7 FA 53 F5 E4 43 18 BF 08 39 7F F4 6D AF 00 F8 01 2B 4F EA 12 22 AF F3 00 80 ED 43 1B D1 42 EA 03 62 4F EA 13 26 40 F8 04 2B F1 E8 02 23 C7 FA 52 F4 91 F8 80 F0 C7 FA 53 F5 90 F8 80 F0 E4 43 06 D1 46 EA 02 66 4F EA 12 22 40 F8 04 6B E4 E7 A1 F1 04 01 32 46 A1 F1 04 01 00 F8 01 2B 4F EA 12 22 00 F8 01 2B 4F EA 12 22 00 F8 01 2B 4F EA 12 22 39 E7 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "_IO_fflush"
		size = 276
		refs = "009c __lll_lock_wait_private 00b6 __libc_do_syscall 0110 _Unwind_Resume 0098 _IO_flush_all"
	strings:
		$1 = { 38 B5 04 46 00 28 45 D0 03 68 19 04 1C D4 80 6C 1D EE 70 5F A5 F5 98 65 83 68 AB 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 2F D1 A3 6C 18 46 9D 60 43 68 01 33 43 60 D4 F8 98 30 20 46 1B 6B 98 47 23 68 05 1E 18 BF 6F F0 00 05 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 08 DC 28 46 38 BD BD E8 38 40 ?? ?? ?? ?? ?? ?? ?? ?? CC E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E9 E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__setgid"
		size = 72
		refs = "0000 __nptl_setxid 0026 __libc_do_syscall 0044 __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? 02 46 ?? ?2 0? 0? 00 B5 87 B0 43 B1 01 A8 D6 23 02 92 01 93 ?? ?? ?? ?? 07 B0 5D F8 04 FB 4F F0 D6 0C ?? ?? ?? ?? 10 F5 80 5F F5 D9 04 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 EB E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "msort_with_tmp.part.0"
		size = 542
		refs = "0132 memcpy 01fe mempcpy"
	strings:
		$1 = { 2D E9 F0 4F 56 08 05 68 85 B0 01 2E 83 46 01 92 C6 EB 02 09 02 91 05 FB 06 15 02 D9 32 46 FF F7 EF FF B9 F1 01 0F 04 D9 58 46 29 46 4A 46 FF F7 E7 FF DB F8 08 30 DB F8 04 20 DB F8 10 40 DB F8 00 A0 00 93 DB F8 0C 80 03 2A 00 F2 C7 80 DF E8 02 F0 9B 73 3C 02 B9 F1 00 0F 18 BF 00 2E 00 F0 DC 80 02 9F 04 F1 04 0C CD F8 0C A0 64 46 BA 46 00 9F 42 46 DA F8 00 00 29 68 B8 47 00 28 D5 BF 06 F1 FF 36 09 F1 FF 39 5A F8 04 2B 55 F8 04 2B B9 F1 00 0F 18 BF 00 2E 44 F8 04 2C 22 46 04 F1 04 04 E6 D1 57 46 DD F8 0C A0 14 46 00 2E 3C D1 01 9B 02 98 C9 EB 03 02 DB F8 10 10 0A FB 02 F2 05 B0 BD E8 F0 4F ?? ?? ?? ?? B9 F1 00 0F 18 BF 00 2E CD F8 0C B0 02 9F D3 46 C2 46 A8 46 1F D0 52 46 38 46 41 46 00 9B 98 47 04 EB 0B 05 00 28 C9 BF 42 46 3A 46 09 F1 FF 39 D8 44 DC BF 06 F1 FF 36 5F 44 AC 42 05 D2 52 F8 04 3B 44 F8 04 3B A5 42 F9 D8 B9 F1 00 0F 18 BF 00 2E 2C 46 DF D1 DA 46 DD F8 0C B0 00 2E C2 D0 20 46 39 46 0A FB 06 F2 ?? ?? ?? ?? BB E7 B9 F1 00 0F 18 BF 00 2E 6B D0 02 9F 04 F1 08 0C CD F8 0C A0 64 46 BA 46 00 9F 0D E0 F5 E8 02 01 09 F1 FF 39 44 E9 02 01 B9 F1 00 0F 18 BF 00 2E 22 46 04 F1 08 04 99 D0 50 46 29 46 42 46 B8 47 00 28 EB DC FA E8 02 01 01 3E 44 E9 02 01 EB E7 B9 F1 00 0F 18 BF 00 2E 43 D0 02 9F 04 F1 04 0C CD F8 0C A0 64 46 BA 46 00 9F 42 46 50 46 29 46 B8 47 00 28 D5 BF 06 F1 FF 36 09 F1 FF 39 5A F8 04 2B 55 F8 04 2B B9 F1 00 0F 18 BF 00 2E 44 F8 04 2C 22 46 04 F1 04 04 E7 D1 57 46 14 46 DD F8 0C A0 67 E7 02 9F B9 F1 00 0F 18 BF 00 2E 29 46 42 46 38 46 3F F4 5E AF 00 9B 98 47 29 46 52 46 00 28 20 46 06 DD ?? ?? ?? ?? 55 44 09 F1 FF 39 04 46 E8 E7 39 46 01 3E ?? ?? ?? ?? 57 44 04 46 E1 E7 02 9F 46 E7 }
	condition:
		$1
}

rule file_272_1_0 {
	meta:
		name = "qsort_r"
		size = 496
		refs = "002a .LANCHOR0 003c __aeabi_uidiv 0054 malloc 00d8 memcpy 0132 free 014a _quicksort 019e __sysconf 01e8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 8F B0 20 2A 02 AF 16 46 98 BF 02 FB 01 F5 F9 60 88 BF FA 68 98 46 78 61 88 BF 06 EB C2 05 B5 F5 80 6F C0 F0 AE 80 ?? ?2 0? 0? ?? ?2 0? 0? 21 68 00 29 00 F0 B1 80 28 46 ?? ?? ?? ?? 63 68 98 42 7B D8 68 4B 1D EE 70 4F 28 46 7B 44 1B 68 E5 58 ?? ?? ?? ?? 64 4B 7B 44 1B 68 E5 50 38 60 00 28 6B D0 F8 62 BA 6D 20 2E 4F F0 04 03 FE 61 C7 F8 24 80 BA 62 3B 62 6C D9 FB 68 FD 6A 99 00 0D 44 6B 18 7B 60 9D 42 80 F0 AA 80 7B 69 2A 46 78 68 42 F8 04 3B 90 42 33 44 FA D8 FB 6A 19 44 04 22 FA 61 FA 68 03 23 3B 62 01 2A 40 F2 8C 80 07 F1 1C 00 FF F7 93 FE D7 F8 14 80 2B 1F BB 60 00 23 3B 61 BB 68 53 F8 04 4F 44 45 BB 60 27 D0 32 46 78 68 41 46 ?? ?? ?? ?? 33 46 D7 F8 10 B0 46 46 9A 46 00 E0 1C 46 7A 69 51 46 A0 1A ?? ?? ?? ?? 45 F8 2B 60 21 46 52 46 81 46 30 46 ?? ?? ?? ?? 26 46 55 F8 29 30 05 EB 89 00 CB 46 43 45 E9 D1 04 60 52 46 20 46 79 68 56 46 ?? ?? ?? ?? 3B 69 B0 44 FA 68 01 33 3B 61 93 42 CA D1 38 68 ?? ?? ?? ?? 34 37 BD 46 BD E8 F0 8F BB 6D 32 46 78 69 F9 68 00 93 43 46 ?? ?? ?? ?? 34 37 BD 46 BD E8 F0 8F B2 07 09 D1 7A 69 12 F0 03 03 05 D1 04 2E 02 D0 08 2E 34 D0 02 23 3B 62 FA 68 01 2A DD D9 07 F1 1C 00 79 69 FF F7 31 FE 38 68 ?? ?? ?? ?? D7 E7 05 F1 0E 03 00 22 23 F0 07 03 3A 60 AD EB 03 0D 02 AB FB 62 65 E7 55 20 ?? ?? ?? ?? 41 1C 08 BF 6F F0 60 43 05 D0 C3 1C 30 EA 20 00 28 BF 18 46 83 10 63 60 1E 20 BF F3 5F 8F ?? ?? ?? ?? 01 46 20 60 37 E7 FB 68 00 2B 7F F4 74 AF AD E7 7B 69 5B 07 04 BF 01 23 3B 62 C6 D0 C3 E7 29 46 5D E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_272_2_0 {
	meta:
		name = "qsort"
		size = 16
		refs = "0008 qsort_r"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_1330_0_1 {
	meta:
		name = "__gnu_divda3"
		size = 16
		refs = "0008 __gnu_divhelperda"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_997_0_1 {
	meta:
		name = "__gnu_divdq3"
		size = 16
		refs = "0008 __gnu_divhelperdq"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_1475_0_1 {
	meta:
		name = "__gnu_mulda3"
		size = 16
		refs = "0008 __gnu_mulhelperda"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_766_0_1 {
	meta:
		name = "__gnu_muldq3"
		size = 16
		refs = "0008 __gnu_mulhelperdq"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_983_0_1 {
	meta:
		name = "__gnu_muluda3"
		size = 16
		refs = "0008 __gnu_mulhelperuda"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_1156_0_1 {
	meta:
		name = "__gnu_muludq3"
		size = 16
		refs = "0008 __gnu_mulhelperudq"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_1287_0_1 {
	meta:
		name = "__gnu_udivuda3"
		size = 16
		refs = "0008 __gnu_divhelperuda"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_1549_0_1 {
	meta:
		name = "__gnu_udivudq3"
		size = 16
		refs = "0008 __gnu_divhelperudq"
	strings:
		$1 = { 10 B5 82 B0 00 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "__nrand48_r"
		size = 36
		refs = "0006 __drand48_iterate"
	strings:
		$1 = { 38 B5 15 46 04 46 ?? ?? ?? ?? 00 28 A9 BF 00 20 4F F0 FF 30 A3 88 62 88 A2 BF DB 03 43 EA 52 03 2B 60 38 BD }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__get_sol"
		size = 100
		refs = "0040 .LC0 0044 .LC1 0048 __PRETTY_FUNCTION__.9553 005a __assert_fail"
	strings:
		$1 = { 17 4B 70 B5 06 46 03 F1 54 05 4F F0 FF 30 02 E0 0C 33 AB 42 11 D0 53 F8 08 2C 54 1C 10 D0 1C 68 8C 42 F5 D1 53 F8 04 4C B4 42 07 D0 0C 33 B0 F1 FF 3F 08 BF 10 46 AB 42 ED D1 70 BD 10 46 70 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 45 22 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_275_1_0 {
	meta:
		name = "getsourcefilter"
		size = 236
		refs = "003a memcpy 004a __get_sol 0060 __getsockopt 0092 free 00ca __libc_alloca_cutoff 00d6 malloc 00e8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 02 AF 8B 46 90 46 FE 6B 9A 46 78 60 34 68 E4 01 8C 34 FC 60 B4 F5 80 5F 53 D8 0E 34 4F F0 01 09 24 F0 07 04 AD EB 04 0D 02 AC 20 46 41 46 52 46 40 F8 04 BB ?? ?? ?? ?? 32 68 B8 F8 00 00 51 46 C4 F8 88 20 ?? ?? ?? ?? 43 1C 01 46 11 D0 07 F1 0C 03 78 68 00 93 30 22 23 46 ?? ?? ?? ?? 05 46 D8 B1 28 46 B9 F1 00 0F 0F D0 14 37 BD 46 BD E8 F0 8F 1B 4B 1D EE 70 2F 05 46 16 21 7B 44 1B 68 28 46 D1 50 B9 F1 00 0F EF D1 20 46 ?? ?? ?? ?? 28 46 14 37 BD 46 BD E8 F0 8F D4 F8 84 30 04 F1 8C 01 BA 6B 38 6C 13 60 D4 F8 88 30 32 68 9A 42 28 BF 1A 46 D2 01 ?? ?? ?? ?? D4 F8 88 30 33 60 CF E7 20 46 ?? ?? ?? ?? 05 46 00 28 A5 D1 20 46 ?? ?? ?? ?? 04 46 08 B1 A9 46 A6 E7 4F F0 FF 30 C3 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "__strfmon"
		size = 48
		refs = "001c __vstrfmon_l 002c __libc_tsd_LOCALE"
	strings:
		$1 = { 0C B4 30 B5 85 B0 08 AC 08 4A 1D EE 70 5F 54 F8 04 3B 03 94 7A 44 12 68 AA 58 00 94 ?? ?? ?? ?? 05 B0 BD E8 30 40 02 B0 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "mknodat"
		size = 26
		refs = "0012 __xmknodat"
	strings:
		$1 = { 10 B5 82 B0 0C 46 13 46 01 46 22 46 04 A8 00 90 01 20 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_279_1_0 {
	meta:
		name = "__libc_msync"
		size = 78
		refs = "0026 __libc_enable_asynccancel 0036 __libc_disable_asynccancel 0020 __syscall_error"
		altNames = "__libc_accept __libc_connect __libc_open __libc_poll __libc_read __libc_recv __libc_recvmsg __libc_send __libc_sendmsg __libc_write __msgsnd epoll_wait open_by_handle_at tee vmsplice"
	strings:
		$1 = { DF F8 50 C0 FC 44 DC F8 00 C0 9C F0 00 0F 80 B4 08 D1 0F 4F 00 DF 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? 0F B5 ?? ?? ?? ?? 84 46 0F BC 08 4F 00 DF 07 46 60 46 ?? ?? ?? ?? 38 46 5D F8 04 EB 80 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "mkostemps64"
		size = 40
		refs = "0024 __libc_errno 000a __gen_tempname"
	strings:
		$1 = { 00 29 04 DB 42 F4 00 32 00 23 ?? ?? ?? ?? 05 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "__fdelt_chk"
		size = 16
		refs = "000c __chk_fail"
	strings:
		$1 = { B0 F5 80 6F 08 B5 01 D2 40 11 08 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "__wmemcpy_chk"
		size = 20
		refs = "0010 __chk_fail 000c memcpy"
	strings:
		$1 = { 93 42 08 B5 04 D3 92 00 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1013_0_0 {
	meta:
		name = "__wmemmove_chk"
		size = 20
		refs = "0010 __chk_fail 000c memmove"
	strings:
		$1 = { 93 42 08 B5 04 D3 92 00 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1067_0_0 {
	meta:
		name = "__wmempcpy_chk"
		size = 20
		refs = "0010 __chk_fail 000c mempcpy"
	strings:
		$1 = { 93 42 08 B5 04 D3 92 00 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "strcspn"
		size = 40
		refs = "0018 strchr"
	strings:
		$1 = { 70 B5 0E 46 01 78 69 B1 05 46 00 24 03 E0 15 F8 01 1F 01 34 21 B1 30 46 ?? ?? ?? ?? 00 28 F6 D0 20 46 70 BD 0C 46 FB E7 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__vwprintf_chk"
		size = 330
		refs = "0004 stdout 006c _IO_vfwprintf 00dc __libc_do_syscall 00e4 __lll_lock_wait_private 0146 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 89 46 07 46 90 46 2C 68 23 68 19 04 1F D4 A6 6C 1D EE 70 AF AA F5 98 6A B3 68 53 45 4C D0 01 22 BF F3 5F 8F 56 E8 00 3F 00 2B 03 D1 46 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 4C D1 A2 6C 28 68 16 46 C2 F8 08 A0 72 68 01 32 72 60 00 E0 20 46 00 2F 49 46 C2 BF C2 6B 42 F0 04 02 C2 63 42 46 ?? ?? ?? ?? 00 2F 06 46 C1 BF 2B 68 DA 6B 22 F0 04 02 DA 63 23 68 E2 6B 22 F0 14 02 E2 63 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 04 DC 30 46 BD E8 F0 87 20 46 C4 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? ED E7 30 46 ?? ?? ?? ?? AE E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "___vprintf_chk"
		size = 330
		refs = "0004 stdout 006c vfprintf 00dc __libc_do_syscall 00e4 __lll_lock_wait_private 0146 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 89 46 07 46 90 46 2C 68 23 68 19 04 1F D4 A6 6C 1D EE 70 AF AA F5 98 6A B3 68 53 45 4C D0 01 22 BF F3 5F 8F 56 E8 00 3F 00 2B 03 D1 46 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 4C D1 A2 6C 28 68 16 46 C2 F8 08 A0 72 68 01 32 72 60 00 E0 20 46 00 2F 49 46 C2 BF C2 6B 42 F0 04 02 C2 63 42 46 ?? ?? ?? ?? 00 2F 06 46 C1 BF 2B 68 DA 6B 22 F0 04 02 DA 63 23 68 E2 6B 22 F0 14 02 E2 63 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 04 DC 30 46 BD E8 F0 87 20 46 C4 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? ED E7 30 46 ?? ?? ?? ?? AE E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "getprotoent"
		size = 204
		refs = "0004 .LANCHOR0 002c __getprotoent_r 0030 .LANCHOR1 004a __nss_getent 009a __lll_lock_wait_private 00b8 __libc_do_syscall 00c4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 82 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 9B BB 25 4B ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A3 F1 0C 01 ?? ?2 0? 0? 00 93 00 26 4F F4 80 63 01 96 ?? ?? ?? ?? 1D 4B 1D EE 70 5F 7B 44 1B 68 55 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 45 F8 03 80 02 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C4 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_711_0_0 {
	meta:
		name = "getrpcent"
		size = 204
		refs = "0004 .LANCHOR0 002c __getrpcent_r 0030 .LANCHOR1 004a __nss_getent 009a __lll_lock_wait_private 00b8 __libc_do_syscall 00c4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 82 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 9B BB 25 4B ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A3 F1 0C 01 ?? ?2 0? 0? 00 93 00 26 4F F4 80 63 01 96 ?? ?? ?? ?? 1D 4B 1D EE 70 5F 7B 44 1B 68 55 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 45 F8 03 80 02 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C4 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__alloc_dir"
		size = 220
		refs = "0014 __fcntl 0032 malloc 004c __have_o_cloexec 00be __libc_do_syscall 00d4 __libc_errno"
	strings:
		$1 = { F8 B5 0F 46 04 46 1D 46 01 BB 13 03 1E D4 20 46 02 21 01 22 ?? ?? ?? ?? 00 28 44 DB 00 2D 34 D0 AD 6B B5 F5 80 1F 1A D3 18 20 4F F4 80 15 C0 F2 10 00 ?? ?? ?? ?? 03 46 60 B3 00 22 18 46 1C 60 9D 60 5A 60 DA 60 1A 61 5A 61 F8 BD ?? ?2 0? 0? ?? ?2 0? 0? 32 68 52 B1 00 2A D8 DD DE E7 B5 F5 00 4F 38 BF 4F F4 00 45 05 F1 18 00 E1 E7 20 46 01 21 ?? ?? ?? ?? 10 F0 01 0F 14 BF 01 22 4F F0 FF 32 32 60 00 2A C2 DD C8 E7 48 F2 18 00 4F F4 00 45 CE E7 42 F2 18 00 4F F4 00 55 ?? ?? ?? ?? 03 46 00 28 C9 D1 0F B9 38 46 F8 BD 09 4B 1D EE 70 2F 20 46 4F F0 06 0C 7B 44 1B 68 D2 58 ?? ?? ?? ?? 05 4B 1D EE 70 1F 00 20 7B 44 1B 68 CA 50 F8 BD 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "__opendirat"
		size = 60
		refs = "0010 __openat_nocancel 0038 __libc_errno 0022 __alloc_dir"
	strings:
		$1 = { 10 B5 0B 78 7B B1 4F F4 90 42 00 23 C0 F2 0A 02 ?? ?? ?? ?? 00 28 0D DB 00 22 01 21 13 46 BD E8 10 40 ?? ?? ?? ?? 04 4B 1D EE 70 2F 02 21 7B 44 1B 68 D1 50 00 20 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__updwtmp"
		size = 200
		refs = "0004 .LC2 000e strcmp 0016 .LC3 0028 .LC1 003a .LC0 004c __libc_utmp_file_functions 0066 __access"
	strings:
		$1 = { 38 B5 0D 46 ?? ?2 0? 0? 04 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 18 B3 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 38 B3 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 58 B3 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 01 46 78 B3 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 29 46 9B 69 98 47 38 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 D3 D1 ?? ?2 0? 0? ?? ?2 0? 0? E9 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 CF D1 ?? ?2 0? 0? ?? ?2 0? 0? DC E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 CB D0 ?? ?2 0? 0? ?? ?2 0? 0? CF E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 28 18 BF 1C 46 C1 E7 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__clock_gettime"
		size = 84
		refs = "000a __libc_do_syscall 004c __libc_errno"
	strings:
		$1 = { 01 28 40 F2 07 1C 00 B5 06 D8 ?? ?? ?? ?? 10 F5 80 5F 10 D8 5D F8 04 FB ?? ?? ?? ?? 10 F5 80 5F F8 D9 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 EE E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 5D F8 04 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__assert_fail_base"
		size = 276
		refs = "0004 pthread_setcancelstate 0022 __progname 0026 .LC1 002e .LC0 0062 __asprintf 006a .LC2 0076 __fxprintf 007a stderr 0084 _IO_fflush 0088 _dl_pagesize 00ae __mmap 00c0 strcpy 00c4 __abort_msg 00ee __munmap 00f4 free 00f8 abort 00fc errstr.13066 0108 __libc_write"
	strings:
		$1 = { 2D E9 80 48 ?? ?2 0? 0? 89 B0 ?? ?2 0? 0? 81 46 88 46 92 46 9B 46 0C 9F 1C B1 01 20 00 21 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 32 68 13 78 00 2B 0C BF 2B 46 23 46 00 2F 61 D0 03 94 49 46 CD F8 00 A0 07 AC CD F8 04 B0 06 A8 02 97 CD F8 10 80 05 94 ?? ?? ?? ?? 00 28 48 DB ?? ?2 0? 0? 06 9A ?? ?2 0? 0? 00 20 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 18 68 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 07 9C 00 22 4F F0 FF 31 1B 68 10 46 01 92 03 22 1C 44 5B 42 1C 40 00 91 22 23 21 46 07 94 ?? ?? ?? ?? 43 1C 04 46 1C D0 07 9B 06 99 40 F8 04 3B ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 18 68 BF F3 5F 8F 53 E8 00 1F 81 42 03 D1 43 E8 00 42 00 2A F7 D1 88 42 BF F3 5F 8F F0 D1 10 B1 01 68 ?? ?? ?? ?? 06 98 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?2 0? 0? 12 22 ?? ?2 0? 0? 02 20 ?? ?? ?? ?? F4 E7 2F 46 2C 46 9A E7 }
	condition:
		$1
}

rule file_295_1_0 {
	meta:
		name = "__assert_fail"
		size = 46
		refs = "0008 _libc_intl_domainname 000c .LC3 001e __dcgettext 002a __assert_fail_base"
	strings:
		$1 = { 80 B5 06 46 82 B0 0D 46 ?? ?2 0? 0? ?? ?2 0? 0? 14 46 ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 1F 46 ?? ?? ?? ?? 00 97 31 46 2A 46 23 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__lll_lock_wait_private"
		size = 86
		refs = "0034 __libc_do_syscall"
	strings:
		$1 = { 70 B5 1D EE 70 6F 04 46 A6 F5 98 66 02 25 BF F3 5F 8F 54 E8 00 3F 01 2B 03 D1 44 E8 00 52 00 2A F7 D1 BF F3 5F 8F 02 22 33 B1 20 46 B1 68 00 23 4F F0 F0 0C ?? ?? ?? ?? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 52 00 2A F7 D1 BF F3 5F 8F 00 2B DC D1 70 BD }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "setegid"
		size = 112
		refs = "000a __nptl_setxid 0048 __libc_do_syscall 0068 __libc_errno"
	strings:
		$1 = { 43 1C 01 46 00 B5 87 B0 11 D0 ?? ?2 0? 0? ?? ?2 0? 0? A3 B1 01 A8 4F F0 FF 33 D2 22 03 91 01 92 02 93 04 93 ?? ?? ?? ?? 07 B0 5D F8 04 FB 0E 4B 1D EE 70 2F 16 21 7B 44 1B 68 D1 50 F4 E7 4F F0 FF 30 4F F0 D2 0C 02 46 ?? ?? ?? ?? 10 F5 80 5F EA D9 06 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__printf_fphex"
		size = 3540
		refs = "0056 __isnan 0064 __isinf 0072 .LC2 0076 .LC0 007a .LC3 0082 .LC1 00ea _IO_padn 01b2 .LC4 01ba .LC6 01c6 .LC5 01ca .LC7 0230 __woverflow 0284 _nl_current_LC_NUMERIC 0288 __libc_tsd_CTYPE_B 028c _nl_current_LC_MONETARY 0298 __signbit 02c2 _itowa 02e2 _itoa 03d8 _dl_hwcap 043c _itoa_word 0450 _itowa_lower_digits 04b8 strlen 04f0 _IO_wpadn 0684 __overflow 0c04 abort 0c44 .LC8 0c48 .LC9 0c4c __PRETTY_FUNCTION__.15549 0c5e __assert_fail 0dc8 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 4B 7B 2D E9 F0 4F C3 F3 80 0B 0F 68 C3 B0 DB 07 88 46 06 46 D1 F8 04 90 07 97 00 F1 BB 80 99 4B 1D EE 70 AF 7B 44 1B 68 5A F8 03 30 1B 68 59 6A 1B 6B 06 91 05 93 06 99 0B 78 00 2B 00 F0 02 86 05 9F 00 2F 00 F0 FE 85 13 68 D3 E9 00 45 20 46 29 46 CD E9 10 45 ?? ?? ?? ?? 00 28 40 F0 A8 80 20 46 29 46 ?? ?? ?? ?? 07 46 00 28 00 F0 12 81 85 4B ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 7B 44 1B 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 5A F8 03 00 FB 0F D8 F8 08 70 ?? ?2 0? 0? ?? ?2 0? 0? 30 F8 17 00 00 F4 80 70 00 28 0C BF AA 46 A2 46 0C BF 0F 46 17 46 98 F8 0C 40 13 B9 14 F0 50 0F 01 D0 09 F1 FF 39 C4 F3 40 15 A9 F1 03 09 00 2D 40 F0 93 80 B9 F1 00 0F 0F DD 30 46 20 21 4A 46 03 93 BB F1 00 0F 40 F0 F8 82 ?? ?? ?? ?? 03 9B 48 45 08 BF 4D 46 40 F0 A6 80 00 2B 00 F0 81 80 BB F1 00 0F 00 F0 B2 82 F3 6D 00 2B 00 F0 C0 85 19 69 5A 69 91 42 3F BF 08 1D 2D 22 18 61 0A 60 80 F0 B6 85 01 35 BB F1 00 0F 00 F0 91 80 EF 1C 2C 46 F3 6D 5A F8 04 1B 00 2B 00 F0 98 85 1A 69 58 69 82 42 80 F0 93 85 B1 F1 FF 3C 15 1D DC F1 00 00 1D 61 50 EB 0C 00 11 60 00 28 73 D1 01 34 BC 42 E6 D1 98 F8 0C 30 9D 06 40 F1 86 80 B9 F1 00 0F 40 F3 82 80 30 46 20 21 4A 46 BB F1 00 0F 40 F0 A8 82 ?? ?? ?? ?? 48 45 5C D1 20 44 43 B0 BD E8 F0 8F 3D 4B 1D EE 70 AF 7B 44 1B 68 5A F8 03 30 1B 68 DF 6A D3 F8 D0 30 06 97 05 93 42 E7 37 4D ?? ?2 0? 0? D8 F8 08 10 ?? ?2 0? 0? 7D 44 2D 68 9D F8 47 30 ?? ?2 0? 0? ?? ?2 0? 0? 5A F8 05 50 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? DB 09 35 F8 11 10 01 F4 80 71 00 29 14 BF A2 46 82 46 08 BF 17 46 5D E7 00 25 00 2B 7F F4 7F AF 98 F8 0C 30 5A 06 40 F1 46 82 BB F1 00 0F 00 F0 67 82 F3 6D 4B B1 19 69 5A 69 91 42 3F BF 08 1D 2B 22 18 61 0A 60 FF F4 7C AF 30 46 2B 21 ?? ?? ?? ?? B0 F1 FF 3E DE F1 00 00 50 EB 0E 00 00 28 3F F4 6F AF 4F F0 FF 30 43 B0 BD E8 F0 8F 2C 46 03 35 3F 1B 73 69 B2 69 39 5D 93 42 3E BF 5A 1C 72 61 19 70 80 F0 0B 85 01 34 AC 42 F2 D1 98 F8 0C 30 9D 06 3F F5 7A AF 20 46 43 B0 BD E8 F0 8F 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 29 46 20 46 ?? ?? ?? ?? D8 F8 08 10 11 9B 3C 46 B1 F1 41 07 42 AA C3 F3 13 03 79 42 1D 46 79 41 10 23 00 91 29 46 09 90 10 98 04 43 20 46 ?? ?? ?? ?? D8 F8 08 70 29 46 10 23 B7 F1 41 0E 22 AA DE F1 00 07 57 EB 0E 07 00 97 08 90 20 46 ?? ?? ?? ?? 08 99 35 AB 99 42 84 46 17 D9 08 9A DF 43 01 38 63 46 17 44 11 46 30 22 BF 08 C0 1B 41 F8 04 2D 03 F8 01 2D 83 42 F9 D1 BB 00 FF 43 83 F0 03 03 BC 44 08 9F DB 43 1F 44 08 97 BD F8 46 E0 54 EA 05 01 14 BF 00 23 01 23 CE F3 0A 14 00 2C 40 F0 01 82 30 27 0C 97 00 2B 40 F0 14 83 40 F2 FE 3E 01 27 0D 97 41 9B 30 2B 40 F0 49 84 22 A9 41 AB 0A 46 0B 91 53 F8 04 1D 01 3A 30 29 FA D0 07 9F 0B 92 7C 1C 00 F0 71 83 0B 99 CC EB 01 03 9F 42 57 DA 07 9F 00 2F 07 9F CA BF 07 9A 0C 9D 62 44 1C F8 07 40 C8 BF 12 F8 01 5C A5 F1 41 02 D2 B2 05 2A 98 BF 37 3D 06 D9 A5 F1 61 02 D2 B2 05 2A 94 BF 57 3D 30 3D A4 F1 41 02 05 2A 98 BF 37 3C 05 D9 A4 F1 61 02 05 2A 94 BF 57 3C 30 3C 60 07 18 BF 01 27 05 D1 07 99 4F 1C BB 42 D4 BF 00 27 01 27 ?? ?2 0? 0? 40 22 ?? ?2 0? 0? 00 23 D1 E9 00 01 02 40 0B 40 52 EA 03 01 00 F0 7D 83 F1 EE 10 3A 09 99 07 2C 03 F4 40 03 D4 BF 00 24 01 24 0A 1C 18 BF 01 22 B3 F5 80 0F 00 F0 FA 83 40 F3 11 84 B3 F5 00 0F 00 F0 ED 83 B3 F5 40 0F 40 F0 EE 83 74 46 0D F1 3D 07 0A 22 39 46 20 46 00 23 04 97 CD F8 0C C0 ?? ?? ?? ?? 4C F6 CD 47 DD F8 0C C0 CC F6 CC 47 19 AA 82 46 ?? ?2 0? 0? ?? ?2 0? 0? A7 FB 04 13 15 46 04 3A DB 08 03 EB 83 01 A4 EB 41 01 1C 46 50 F8 21 30 2B 60 00 2C F0 D1 04 9F 6F F0 03 03 98 F8 0C 40 C7 EB 0A 02 09 9F 37 B9 14 F0 50 0F 14 BF 6F F0 03 03 6F F0 02 03 07 9F DB 1B 00 2F A3 F1 02 03 13 44 4B 44 0A 93 40 F3 5C 82 01 20 BB F1 00 0F 06 D1 06 98 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 0A 9B 1B 1A 0A 93 C4 F3 40 17 00 2F 40 F0 E5 81 D8 F8 10 30 30 2B 13 D0 0A 9B 00 2B 10 DD 30 46 20 21 BB F1 00 0F 00 F0 EE 82 1A 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 0A 9F B8 42 7F F4 A3 AE 09 99 00 29 00 F0 CB 81 BB F1 00 0F 00 F0 4F 82 F3 6D 00 2B 00 F0 27 84 1A 69 59 69 8A 42 3F BF 11 1D 19 61 2D 23 13 60 80 F0 1D 84 01 37 BB F1 00 0F 00 F0 DA 81 F3 6D 00 2B 00 F0 DB 83 1A 69 59 69 8A 42 3F BF 11 1D 19 61 30 23 13 60 80 F0 D1 83 D8 F8 08 10 17 31 BB F1 00 0F 00 F0 DF 81 F3 6D 00 2B 00 F0 02 84 1C 69 5A 69 94 42 80 F0 FD 83 B1 F1 FF 39 22 1D D9 F1 00 00 1A 61 50 EB 09 00 21 60 00 28 7F F4 5E AE 98 F8 0C 30 02 37 9C 06 04 D4 D8 F8 10 10 30 29 00 F0 51 81 BB F1 00 0F 00 F0 D4 81 F3 6D 00 2B 00 F0 F4 83 1A 69 59 69 8A 42 80 F0 EF 83 11 1D 19 61 0C 99 11 60 07 9B 7C 1C 00 2B 40 F3 CF 80 BB F1 00 0F 40 F0 4D 81 06 98 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 DD F8 18 90 07 46 70 B1 73 69 B2 69 19 F8 01 1B 93 42 3E BF 5A 1C 72 61 19 70 80 F0 88 83 01 3F 04 F1 01 04 F0 D1 07 9F 00 2F 40 F3 B2 80 0B 99 07 9A C1 EB 0C 07 CC EB 01 03 17 44 93 42 A8 BF 13 46 BB F1 00 0F 40 F0 CF 81 99 46 C4 EB 0C 0C 7B B1 73 69 B2 69 1C F8 04 10 93 42 3E BF 5A 1C 72 61 19 70 80 F0 B4 83 B9 F1 01 09 04 F1 01 04 EF D1 00 2F 40 F3 E7 81 30 46 30 21 3A 46 ?? ?? ?? ?? B8 42 7F F4 EF AD 04 44 82 E0 73 69 B2 69 93 42 3F BF 59 1C 2D 22 71 61 1A 70 FF F4 52 AD 2D 21 30 46 ?? ?? ?? ?? B0 F1 FF 31 48 42 48 41 00 28 7F F4 D8 AD 45 E5 D8 06 7F F5 44 AD BB F1 00 0F 34 D0 F3 6D 4B B1 19 69 5A 69 91 42 3F BF 08 1D 20 22 18 61 0A 60 FF F4 34 AD 20 21 30 46 ?? ?? ?? ?? B0 F1 FF 31 48 42 48 41 00 28 7F F4 BA AD 27 E5 ?? ?? ?? ?? 56 E5 ?? ?? ?? ?? 03 9B 06 E5 73 69 B2 69 93 42 3F BF 59 1C 2B 22 71 61 1A 70 FF F4 17 AD 30 46 2B 21 ?? ?? ?? ?? B0 F1 FF 34 60 42 60 41 00 28 7F F4 9D AD 0A E5 73 69 B2 69 93 42 3F BF 59 1C 20 22 71 61 1A 70 FF F4 01 AD 30 46 20 21 ?? ?? ?? ?? B0 F1 FF 32 50 42 50 41 00 28 7F F4 87 AD F4 E4 40 F2 FE 32 94 42 40 F3 15 81 A4 F2 FF 3E 00 27 0D 97 00 2B 00 F0 15 81 74 46 31 27 0C 97 07 9F CD F8 2C C0 01 37 04 BF 00 27 07 97 60 E6 98 F8 0C 30 1B 07 3F F5 2C AF D8 F8 08 10 0F 31 BB F1 00 0F 00 F0 56 81 F3 6D 00 2B 00 F0 A8 82 1F 69 5A 69 97 42 80 F0 A3 82 B1 F1 FF 3C 3A 1D DC F1 00 00 1A 61 50 EB 0C 00 39 60 00 28 7F F4 4E AD 0D 9F 00 2F 0C BF 2B 21 2D 21 BB F1 00 0F 00 F0 50 81 F3 6D 00 2B 00 F0 B1 82 18 69 5A 69 90 42 3E BF 02 1D 1A 61 01 60 80 F0 A8 82 04 99 02 34 CA EB 01 07 BB F1 00 0F 40 F0 4F 81 3D 46 77 B1 73 69 B2 69 1A F8 01 1B 93 42 3E BF 5A 1C 72 61 19 70 80 F0 C3 82 01 3D 04 F1 01 04 F0 D1 98 F8 0C 30 9B 06 7F F5 34 AD D8 F8 10 10 30 29 3F F4 2F AD 0A 9B 00 2B 7F F7 2B AD 30 46 BB F1 00 0F 00 F0 02 82 1A 46 ?? ?? ?? ?? 0A 9F B8 42 7F F4 05 AD 20 44 A6 E4 0A 9B 00 2B 7F F7 AB AE 30 46 BB F1 00 0F 00 F0 CC 81 1A 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 0A 9B 98 42 7F F4 EF AC 1F 44 98 E6 F3 6D 00 2B 00 F0 1B 82 1A 69 59 69 8A 42 80 F0 16 82 05 99 B1 F1 FF 31 48 42 48 41 11 1D 19 61 05 9B 13 60 00 28 7F F4 D8 AC BC 1C B5 E6 00 27 30 E6 98 F8 0C 30 5A 06 6D D5 BB F1 00 0F 00 F0 14 81 F3 6D 4B B1 1A 69 59 69 8A 42 3F BF 11 1D 19 61 2B 23 13 60 FF F4 33 AE 30 46 2B 21 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 3E DE F1 00 00 50 EB 0E 00 00 28 7F F4 AF AC 20 E6 B2 69 73 69 93 42 3F BF 5A 1C 72 61 30 22 1A 70 FF F4 2A AE 30 46 30 21 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 32 50 42 50 41 00 28 7F F4 95 AC 19 E6 73 69 B2 69 93 42 3E BF 5A 1C 72 61 19 70 FF F4 2D AE C9 B2 30 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 3E DE F1 00 00 50 EB 0E 00 1A E6 73 69 B2 69 93 42 80 F0 F7 81 5A 1C 72 61 0C 9A 1A 70 2E E6 21 07 7F F5 AF AD 9F E5 0D 94 F4 E6 C4 F5 7F 74 01 27 04 F1 03 0E 0D 97 E7 E6 31 27 0C 97 E3 E4 DB 06 7F F5 D3 AD BB F1 00 0F 00 F0 FD 80 F3 6D 4B B1 1A 69 59 69 8A 42 3F BF 11 1D 19 61 20 23 13 60 FF F4 C2 AD 30 46 20 21 8D E7 73 69 B2 69 93 42 24 BF 30 46 2D 21 80 F0 F2 80 5A 1C 72 61 2D 22 1A 70 B1 E5 23 B3 CD F8 14 B0 99 46 DD F8 20 B0 F3 6D 5B F8 04 1B 00 2B 00 F0 AB 81 18 69 5A 69 90 42 80 F0 A6 81 B1 F1 FF 3C DC F1 00 02 52 EB 0C 02 00 F1 04 0C C3 F8 10 C0 01 60 00 2A 7F F4 20 AC B9 F1 01 09 04 F1 01 04 E1 D1 DD F8 14 B0 00 2F 40 F3 69 81 30 46 30 21 3A 46 ?? ?? ?? ?? 1D E6 D8 F8 08 10 0F 31 73 69 B2 69 93 42 3E BF 5A 1C 72 61 19 70 FF F4 B6 AE C9 B2 30 46 ?? ?? ?? ?? B0 F1 FF 31 48 42 48 41 A9 E6 0B 9F 74 46 CC EB 07 07 07 97 E6 E4 73 69 B2 69 93 42 3E BF 5A 1C 72 61 19 70 FF F4 B4 AE 30 46 ?? ?? ?? ?? B0 F1 FF 33 58 42 58 41 00 28 7F F4 E2 AB A8 E6 00 2F 3F F4 BF AE F3 6D 55 F8 04 1B 00 2B 00 F0 17 81 1A 69 58 69 82 42 80 F0 12 81 B1 F1 FF 3C DC F1 00 00 50 EB 0C 00 02 F1 04 0C C3 F8 10 C0 11 60 00 28 7F F4 C5 AB 01 3F 04 F1 01 04 E2 D1 A0 E6 0A 9A CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 10 E5 73 69 B2 69 93 42 24 BF 30 46 2B 21 5E D2 5A 1C 72 61 2B 22 1A 70 1E E5 07 2C 05 F0 01 05 D4 BF 00 24 01 24 2F 43 00 2C 3F F4 93 AC 00 2F 3F F4 90 AC 07 9F 7B 1E 2D D4 1C F8 03 20 0C EB 03 00 39 2A 5B D0 AB 49 79 44 09 68 5A F8 01 10 51 F8 22 10 65 29 47 DD B9 1E CD F8 28 E0 30 24 61 44 A5 4F DD F8 20 E0 0D E0 08 46 11 F8 01 29 39 2A 42 D0 3D 46 7D 44 2D 68 5A F8 05 50 55 F8 22 50 65 2D 2E DD 04 70 4E F8 23 40 13 F1 FF 33 EB D2 DD F8 28 E0 99 4B 0C 9F 7B 44 1B 68 5A F8 03 30 53 F8 27 30 65 2B 48 DC 0C 9F 74 46 7B 1C DB B2 0C 93 4F E4 B2 69 73 69 93 42 3F BF 5A 1C 72 61 20 22 1A 70 FF F4 C7 AC 30 46 20 21 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 34 60 42 60 41 94 E6 DD F8 28 E0 08 99 01 32 02 70 51 F8 23 20 01 32 41 F8 23 20 2C E4 DD F8 28 E0 D8 F8 08 20 08 9F 47 F8 23 20 D8 F8 08 30 03 70 21 E4 22 AA FF F7 BD BB 0A 9A CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 32 E6 00 2A 3F F4 14 AC 27 43 7E E7 ?? ?? ?? ?? 00 2A 7F F4 0D AC F7 E7 0D 9F 37 B3 AE F1 04 04 00 2C CB BF 31 27 31 27 0C 97 64 42 CE BF 01 27 0C 97 00 27 0D 97 FF F7 FC BB 0A 9A ?? ?? ?? ?? FC E5 00 2B E2 D1 05 F0 01 05 5A E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A7 22 ?? ?? ?? ?? 31 27 0E F1 04 04 0C 97 FF F7 DE BB 30 46 ?? ?? ?? ?? B0 F1 FF 33 58 42 58 41 FF F7 6D BA 30 46 ?? ?? ?? ?? 01 30 7F F4 EF AA FF F7 DB BA 30 46 2D 21 ?? ?? ?? ?? B0 F1 FF 34 60 42 60 41 00 28 7F F4 D0 AA FF F7 3D BA 05 99 30 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 34 60 42 60 41 E5 E5 30 46 ?? ?? ?? ?? B0 F1 FF 39 D9 F1 00 00 50 EB 09 00 EE E6 30 46 ?? ?? ?? ?? B0 F1 FF 39 D9 F1 00 00 50 EB 09 00 5B E5 D8 F8 08 10 0F 31 45 E5 30 21 30 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 31 48 42 48 41 03 E6 30 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 42 1C 7F F4 6E AC FF F7 90 BA 30 46 ?? ?? ?? ?? B0 F1 FF 32 50 42 50 41 A2 E6 30 46 ?? ?? ?? ?? B0 F1 FF 33 5A 42 5A 41 5C E6 0C 99 30 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 32 50 42 50 41 00 28 7F F4 71 AA 2C E4 30 46 2D 21 AE E5 30 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 33 58 42 58 41 FF F7 FF BB 30 46 ?? ?? ?? ?? 01 30 7F F4 37 AD FF F7 58 BA 0C 99 30 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 B0 F1 FF 31 48 42 48 41 D6 E7 30 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 01 30 7F F4 42 AC FF F7 3F BA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "_dl_runtime_resolve"
		size = 36
		refs = "0014 _dl_fixup"
	strings:
		$1 = { 1F 00 2D E9 04 00 1E E5 0E 10 4C E0 04 10 41 E2 01 10 81 E0 ?? ?? ?? ?? 00 C0 A0 E1 1F 40 BD E8 1C FF 2F E1 }
	condition:
		$1
}

rule file_304_1_0 {
	meta:
		name = "_dl_runtime_profile"
		size = 192
		refs = "003c _dl_profile_fixup 007c memcpy 00a4 _dl_call_pltexit"
	strings:
		$1 = { C4 D0 4D E2 0F 00 8D E8 10 D0 4D E2 D8 00 8D E2 20 00 8D E5 D4 20 9D E5 24 20 8D E5 04 00 1E E5 0E 10 4C E0 04 10 41 E2 01 10 81 E0 08 30 8D E2 03 00 A3 E8 D0 C0 8D E2 00 C0 8D E5 ?? ?? ?? ?? D0 C0 9D E5 00 00 5C E3 03 00 00 AA 00 C0 A0 E1 10 D0 8D E2 0F 60 9D E8 1C FF 2F E1 D4 70 8D E5 38 70 4D E2 0C D0 4D E0 07 D0 CD E3 08 01 87 E5 0D 00 A0 E1 11 1E 87 E2 0C 20 A0 E1 ?? ?? ?? ?? 48 C0 87 E2 0F 00 9C E8 08 C1 97 E5 3C FF 2F E1 0F 00 87 E8 40 C0 87 E2 03 00 9C E8 48 20 87 E2 00 30 87 E2 ?? ?? ?? ?? 0F 00 97 E8 07 D0 A0 E1 0C 71 9D E5 5C E0 9D E5 11 DE 8D E2 1E FF 2F E1 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "__difftime"
		size = 32
		refs = "0004 __aeabi_i2d 001a __aeabi_dsub"
	strings:
		$1 = { 70 B5 0E 46 ?? ?? ?? ?? 04 46 30 46 0D 46 ?? ?? ?? ?? 02 46 0B 46 20 46 29 46 ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__correctly_grouped_prefixmb"
		size = 368
		refs = "0014 strlen"
	strings:
		$1 = { 2D E9 F0 4F 85 B0 80 46 91 46 03 93 01 91 00 2B 49 D0 10 46 ?? ?? ?? ?? 01 99 41 45 38 D9 00 F1 FF 3A 08 F1 FF 3B 01 9B 5C 1E A0 45 3B D8 1D 46 99 F8 00 70 55 44 03 E0 01 3C 01 3D 5C 45 32 D0 15 F8 01 3C BB 42 F7 D1 99 F8 01 30 83 B1 15 F8 02 2C 9A 42 F0 D1 09 F1 01 01 2B 46 03 E0 13 F8 02 0C 90 42 E8 D1 11 F8 01 2F 01 3B 00 2A F6 D1 A0 45 02 94 17 D8 03 99 0B 78 01 99 01 33 0A 1B 9A 42 14 D0 C8 BF E4 18 01 94 01 99 88 45 CA D3 01 98 40 45 38 BF 40 46 05 B0 BD E8 F0 8F 01 3E 01 3C B3 45 41 D1 01 98 05 B0 BD E8 F0 8F 03 9B 00 93 00 99 4B 78 00 2B 4E D0 9C 46 01 31 00 91 BC F1 FF 0F 04 F1 FF 36 2B D0 B0 45 4E D8 54 44 00 2F 45 D0 35 46 14 F8 01 3C BB 42 15 D1 49 46 23 46 03 E0 13 F8 01 0C 90 42 0E D1 11 F8 01 2F 01 3B 00 2A F6 D1 A8 45 2C 46 35 D8 75 1B 65 45 D7 D0 02 9B 01 3B 01 93 BF E7 01 3D 01 3C AB 45 E1 D1 CB EB 06 06 B4 45 C5 DA 02 9B 01 3B 01 93 B3 E7 B0 45 BF D8 54 44 7F B1 14 F8 01 3C BB 42 B5 D1 49 46 23 46 03 E0 13 F8 01 0C 90 42 AE D1 11 F8 01 2F 01 3B 00 2A F6 D1 B0 45 34 46 AA D8 00 99 4B 78 00 2B B0 D1 00 9A 92 F8 00 C0 AF E7 35 46 34 46 A8 45 C9 D9 36 1B D4 E7 00 26 D2 E7 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "add_pad"
		size = 66
		refs = "0036 memset"
	strings:
		$1 = { 03 68 01 29 70 B5 A3 F1 0C 02 08 BF 12 18 0D 46 04 46 04 BF 00 21 11 73 00 D0 15 B9 1D 44 25 60 70 BD 04 3B 02 44 03 44 A9 1E 98 1D 01 26 16 73 0A 46 59 71 00 21 ?? ?? ?? ?? 23 68 1D 44 25 60 70 BD }
	condition:
		$1
}

rule file_308_1_0 {
	meta:
		name = "option_alloc"
		size = 134
		refs = "0068 .LC0 006c .LC1 0070 __PRETTY_FUNCTION__.6224 0082 __assert_fail"
	strings:
		$1 = { 70 B5 55 1E 04 2A 18 BF 01 2D 04 46 0E 46 01 D9 08 2A 27 D1 07 2B 25 D8 20 68 B0 F1 0C 01 04 BF 02 21 40 18 01 EA 05 01 C1 EB 02 01 08 BF 20 60 29 40 20 46 19 44 FF F7 C1 FF 25 68 20 46 71 19 21 60 C1 F1 0C 01 01 F0 07 01 FF F7 B7 FF 23 68 0C 3B 5A 07 08 D1 DB 08 01 3B FF 2B 02 DC 60 19 63 73 70 BD 00 20 70 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? D4 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_308_2_0 {
	meta:
		name = "get_opt_end"
		size = 46
	strings:
		$1 = { 91 42 11 D2 0B 78 5B B1 8B 1C 9A 42 0C D3 4B 78 02 33 19 44 8A 42 07 D3 00 23 01 60 18 46 70 47 01 31 01 60 18 46 70 47 4F F0 FF 33 F6 E7 }
	condition:
		$1
}

rule file_308_4_0 {
	meta:
		name = "inet6_option_init"
		size = 42
	strings:
		$1 = { 03 46 3B 2A 18 BF 36 2A 10 B4 0C BF 00 20 01 20 03 BF 9A 60 29 24 0C 22 4F F0 FF 30 04 BF 83 E8 14 00 0B 60 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_308_5_0 {
	meta:
		name = "inet6_option_append"
		size = 40
		refs = "001a memcpy"
	strings:
		$1 = { 38 B5 0C 46 09 78 01 25 09 B1 65 78 02 35 29 46 FF F7 7E FF 28 B1 21 46 2A 46 ?? ?? ?? ?? 00 20 38 BD 4F F0 FF 30 38 BD }
	condition:
		$1
}

rule file_308_7_0 {
	meta:
		name = "inet6_option_next"
		size = 108
	strings:
		$1 = { 42 68 03 46 E0 B5 29 2A 82 B0 0D 46 24 D1 82 68 3B 2A 18 BF 36 2A 1F D1 00 68 0D 28 1C D9 5A 7B 01 32 D2 00 02 F1 0C 01 88 42 15 D3 29 68 1A 44 02 F1 0C 07 A1 B1 0E 33 99 42 0D D3 01 AE 3A 46 30 46 FF F7 93 FF 38 B9 01 99 29 60 30 46 3A 46 FF F7 8C FF 02 B0 E0 BD 4F F0 FF 30 02 B0 E0 BD 02 AE 0E 33 19 46 46 F8 04 3D EE E7 }
	condition:
		$1
}

rule file_308_8_0 {
	meta:
		name = "inet6_option_find"
		size = 128
	strings:
		$1 = { 43 68 2D E9 F0 41 29 2B 82 B0 88 46 17 46 27 D1 83 68 3B 2B 18 BF 36 2B 22 D1 03 68 0D 2B 1F D9 46 7B 01 36 F6 00 06 F1 0C 02 93 42 18 D3 09 68 06 44 0C 36 F1 B1 0E 30 81 42 11 D3 01 AD 32 46 28 46 FF F7 5D FF 18 B1 0A E0 23 78 BB 42 0C D0 01 9C 28 46 21 46 32 46 FF F7 52 FF 00 28 F4 D0 4F F0 FF 30 02 B0 BD E8 F0 81 C8 F8 00 40 02 B0 BD E8 F0 81 02 AD 0E 30 04 46 45 F8 04 0D E8 E7 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "wcsrchr"
		size = 28
	strings:
		$1 = { 03 46 00 20 10 B4 1C 46 53 F8 04 2B 8A 42 08 BF 20 46 00 2A F7 D1 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__getcontext"
		size = 112
		refs = "0028 __sigprocmask"
	strings:
		$1 = { 00 F1 30 01 81 E8 F0 0F C0 F8 54 D0 C0 F8 58 E0 C0 F8 5C E0 4F F0 00 02 02 62 04 46 4F F0 00 00 4F F0 00 01 04 F1 68 02 ?? ?? ?? ?? 10 4A 12 68 04 F1 E8 00 12 F0 40 0F 05 D0 A0 EC 10 8B F1 EE 10 1A 40 F8 04 1B 12 F4 00 7F 0B D0 E0 EC 02 A1 E0 EC 02 B1 E0 EC 02 C1 E0 EC 02 D1 E0 EC 02 E1 E0 EC 02 F1 D4 F8 58 E0 24 6B 4F F0 00 00 70 47 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "__splice_nocancel"
		size = 26
		refs = "0016 __syscall_error"
		altNames = "__recvfrom_nocancel __sendto_nocancel"
	strings:
		$1 = { EC 46 B0 B4 9C E8 30 00 1A 4F 00 DF B0 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_311_1_0 {
	meta:
		name = "splice"
		size = 84
		refs = "002c __libc_enable_asynccancel 003c __libc_disable_asynccancel 0026 __syscall_error"
		altNames = "__libc_recvfrom __libc_sendto"
	strings:
		$1 = { DF F8 54 C0 FC 44 DC F8 00 C0 9C F0 00 0F EC 46 B0 B4 9C E8 30 00 08 D1 0E 4F 00 DF B0 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? 0F B5 ?? ?? ?? ?? 84 46 0F BC 07 4F 00 DF 07 46 60 46 ?? ?? ?? ?? 38 46 5D F8 04 EB B0 BC 10 F5 80 5F 38 BF 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "__wcsrtombs"
		size = 500
		refs = "0004 .LANCHOR0 0052 __wcsnlen 0066 _dl_mcount_wrapper_check 00aa .LC4 00ae .LC1 00b2 __PRETTY_FUNCTION__.11592 00c4 __assert_fail 0114 __wcslen 0172 .LC0 0190 _nl_C_LC_CTYPE 019e __wcsmbs_load_conv 01a6 .LC2 01c4 .LC3 01e2 __wcsmbs_gconv_fcts_c 01ec _nl_current_LC_CTYPE 01f0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? D5 B0 ?? ?2 0? 0? 00 2B 08 BF 2B 46 75 4C 1D EE 70 5F 05 95 00 26 13 96 0E 96 0E 46 05 99 05 46 10 93 01 23 0F 93 90 46 0D 93 7C 44 24 68 0B 59 1C 68 63 69 00 2B 00 F0 A7 80 9F 68 7C 69 00 2D 5C D0 D6 F8 00 90 41 46 48 46 ?? ?? ?? ?? 05 EB 08 03 0C 93 0B 95 43 1C 20 46 09 EB 83 09 ?? ?? ?? ?? 00 22 4B 46 38 46 0D F1 50 0E 00 92 0B A9 02 92 01 27 CD F8 04 E0 32 46 03 97 A0 47 0B 9B C5 EB 03 0B 30 F0 04 01 2A D0 03 1C 18 BF 01 23 04 28 18 BF 00 28 13 D0 83 1F 01 2B 11 D9 05 28 1A D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8B 22 ?? ?? ?? ?? 53 B1 04 38 01 28 07 D9 47 4B 4F F0 FF 3B 05 9D 54 22 7B 44 1B 68 EA 50 58 46 55 B0 BD E8 F0 8F 13 F8 01 2C 00 2A D0 D1 9D 42 58 D0 10 9B 1B 68 00 2B 63 D1 0B F1 FF 3B 33 60 C6 E7 D6 F8 00 80 4F F0 01 09 AB 46 2E 46 40 46 14 AD ?? ?? ?? ?? 10 9A 09 AB CD F8 1C 80 0D F1 20 0A 00 EB 09 0E 92 E8 03 00 54 AA 10 93 08 EB 8E 08 0C 92 83 E8 03 00 20 46 0B 95 ?? ?? ?? ?? 07 AA 43 46 8D E8 40 04 38 46 02 96 0B A9 CD F8 0C 90 A0 47 0B 9B 5A 1B 93 44 05 28 EC D0 30 F0 04 05 95 D1 13 F8 01 3C 0B F1 FF 3B 00 2B 8F D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 63 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 9C 42 22 D0 20 46 ?? ?? ?? ?? 63 69 4D E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 7F 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 80 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 2A E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__brk"
		size = 96
		refs = "0008 __libc_do_syscall 0012 .LANCHOR0 0058 __libc_errno"
	strings:
		$1 = { 30 B5 02 46 4F F0 2D 0C ?? ?? ?? ?? 10 F5 80 5F 12 D8 ?? ?2 0? 0? 82 42 ?? ?2 0? 0? 18 60 01 D8 00 20 30 BD 0C 4B 1D EE 70 2F 0C 21 4F F0 FF 30 7B 44 1B 68 D1 50 30 BD 08 4A ?? ?2 0? 0? 1D EE 70 4F ?? ?2 0? 0? 7A 44 12 68 45 42 4F F0 FF 31 00 20 A5 50 19 60 30 BD ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "gethostent"
		size = 208
		refs = "0002 .LANCHOR0 0032 __gethostent_r 0036 .LANCHOR1 0054 __nss_getent 009c __lll_lock_wait_private 00ba __libc_do_syscall 00c4 __libc_h_errno 00c8 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 83 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 34 D1 25 4E 1D EE 70 5F 24 4B ?? ?2 0? 0? ?? ?2 0? 0? A6 F1 14 01 00 96 7B 44 1B 68 2B 44 ?? ?2 0? 0? 01 93 ?? ?2 0? 0? 4F F4 80 63 ?? ?? ?? ?? 1B 4B 00 21 7B 44 1B 68 EF 58 06 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0D DC 11 4B 30 46 7B 44 1B 68 EF 50 03 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C3 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "putw"
		size = 36
		refs = "0012 _IO_fwrite"
	strings:
		$1 = { 10 B5 82 B0 02 AC 0B 46 01 22 04 21 44 F8 04 0D 20 46 ?? ?? ?? ?? 00 28 14 BF 00 20 6F F0 00 00 02 B0 10 BD }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "__wctype_l"
		size = 86
		refs = "0008 strlen 0036 memcmp"
	strings:
		$1 = { 2D E9 F8 43 0C 46 80 46 ?? ?? ?? ?? D4 F8 00 90 00 26 D9 F8 4C 40 07 46 04 E0 01 35 01 36 2C 44 23 78 AB B1 20 46 ?? ?? ?? ?? 87 42 05 46 F4 D1 40 46 21 46 3A 46 ?? ?? ?? ?? 00 28 ED D1 D9 F8 68 30 33 44 09 EB 83 09 D9 F8 24 00 BD E8 F8 83 18 46 BD E8 F8 83 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "known_compare"
		size = 16
		refs = "0008 strcmp"
	strings:
		$1 = { 88 42 03 D0 00 68 09 68 ?? ?? ?? ?? 00 20 70 47 }
	condition:
		$1
}

rule file_317_1_0 {
	meta:
		name = "nss_parse_service_list"
		size = 696
		refs = "005c malloc 0072 mempcpy 0156 .LC2 0162 __strncasecmp 01d8 .LC5 0230 free 0246 .LC3 0260 .LC0 0272 .LC1 028c .LC4 02b0 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 4F 83 B0 02 AE A9 4B 00 22 1D EE 70 7F 46 F8 04 2D 7B 44 1B 68 05 46 FC 58 2B 78 34 F8 13 20 92 04 54 D4 00 2B 00 F0 04 81 5B 2B 00 F0 01 81 6A 1C 06 E0 34 F8 13 C0 1C F4 00 5F 06 D1 5B 2B 04 D0 91 46 12 F8 01 3B 00 2B F3 D1 4D 45 00 F0 F0 80 C5 EB 09 0A 0A F1 25 00 ?? ?? ?? ?? 83 46 00 28 00 F0 E6 80 24 30 29 46 52 46 CB F8 20 00 ?? ?? ?? ?? 00 23 01 22 03 70 CB F8 04 30 CB F8 08 30 CB F8 0C 30 CB F8 18 30 CB F8 1C 30 CB F8 00 30 CB F8 10 20 CB F8 14 20 99 F8 00 20 34 F8 12 30 9D 04 40 F1 00 81 09 F1 01 03 1D 46 13 F8 01 2B 34 F8 12 10 88 04 F8 D4 5B 2A 09 D0 C6 F8 00 B0 5E 46 2B 78 34 F8 13 20 92 04 AA D5 01 35 A3 E7 6B 1C 03 E0 34 F8 12 10 89 04 04 D5 1D 46 13 F8 01 2B 00 2A F6 D1 72 4B 7B 44 1B 68 FC 58 B2 F1 21 0E DE F1 00 09 59 EB 0E 09 B9 F1 00 0F 01 D0 6A 78 01 35 00 2A 00 F0 90 80 34 F8 12 30 98 04 00 F1 8B 80 3D 2A 00 F0 88 80 5D 2A 00 F0 85 80 6A 1C 07 E0 34 F8 13 10 89 04 09 D4 3D 2B 07 D0 5D 2B 05 D0 90 46 01 32 98 F8 00 30 00 2B F1 D1 C5 EB 08 0A BA F1 07 0F 00 F0 88 80 BA F1 08 0F 6B D1 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? 52 46 ?? ?? ?? ?? 00 28 6D D1 82 46 98 F8 00 20 34 F8 12 30 9D 04 48 BF 08 F1 01 03 06 D5 98 46 13 F8 01 2B 34 F8 12 10 88 04 F8 D4 3D 2A 4E D1 08 F1 01 0C 60 46 0C F1 01 0C 03 78 34 F8 13 20 91 04 F7 D4 00 2B 42 D0 3D 2B 40 D0 5D 2B 08 D1 3D E0 34 F8 13 20 92 04 09 D4 3D 2B 07 D0 5D 2B 05 D0 65 46 0C F1 01 0C 2B 78 00 2B F1 D1 2A 1A 06 2A 5B D0 08 2A 2A D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 18 BB B9 F1 00 0F 27 D0 0A F1 02 0A 0B EB 8A 0A DA F8 04 30 CB F8 04 00 CB F8 08 00 CB F8 0C 00 CB F8 10 00 CA F8 04 30 2A 78 34 F8 12 30 98 04 07 D5 6B 1C 1D 46 13 F8 01 2B 34 F8 12 10 89 04 F8 D4 5D 2A 3A D0 2A 78 61 E7 58 46 ?? ?? ?? ?? 01 98 03 B0 BD E8 F0 8F 0B EB 8A 0A CA F8 0C 00 E2 E7 ?? ?2 0? 0? 28 46 52 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 E9 D1 6F F0 01 0A 85 E7 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? 52 46 ?? ?? ?? ?? C0 B1 ?? ?2 0? 0? 28 46 52 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 D3 D1 4F F0 FF 3A 6F E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 00 28 C8 D1 01 20 A2 E7 01 35 0D E7 4F F0 01 0A 60 E7 4D 46 06 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_2_0 {
	meta:
		name = "free_database_entries"
		size = 62
		refs = "0010 free 001c __tdestroy"
	strings:
		$1 = { 70 B5 06 46 C8 B1 74 68 0C B9 0F E0 2C 46 E3 69 ?? ?2 0? 0? ?? ?2 0? 0? 18 46 0B B1 ?? ?? ?? ?? 25 68 20 46 ?? ?? ?? ?? 00 2D EF D1 34 68 30 46 ?? ?? ?? ?? 14 B1 26 46 E5 E7 70 BD 70 BD }
	condition:
		$1
}

rule file_317_3_0 {
	meta:
		name = "__nss_database_lookup"
		size = 740
		refs = "0032 .LANCHOR0 0090 strcmp 0100 .LC6 011c malloc 0128 .LC9 013e .LC7 0142 .LC8 014e _IO_new_fopen 01a0 __getline 01be __strchrnul 0228 strlen 0246 memcpy 026c free 0272 _IO_new_fclose 0296 __lll_lock_wait_private 02b2 __libc_do_syscall 02c0 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 4F 90 46 AD 4C 89 B0 06 46 0F 46 1D 46 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 32 81 2B 68 ?? ?2 0? 0? D3 B1 00 21 ?? ?2 0? 0? DB F8 08 20 BF F3 5F 8F 54 E8 00 3F 93 42 03 D1 44 E8 00 10 00 28 F7 D1 9A 42 BF F3 5F 8F EF D1 01 2A D8 BF 00 20 00 F3 1A 81 09 B0 BD E8 F0 8F ?? ?2 0? 0? DB F8 04 90 B9 F1 00 0F 60 D0 D9 F8 00 A0 BA F1 00 0F 0C D0 33 46 56 46 9A 46 50 46 B1 68 ?? ?? ?? ?? 08 B9 73 68 2B 60 36 68 00 2E F5 D1 2A 68 E2 B1 00 21 DB F8 08 20 BF F3 5F 8F 54 E8 00 3F 93 42 03 D1 44 E8 00 10 00 28 F7 D1 9A 42 BF F3 5F 8F EF D1 01 2A 00 F3 FC 80 28 68 00 28 14 BF 00 20 6F F0 00 00 09 B0 BD E8 F0 8F 7F B1 D9 F8 00 60 66 B1 38 46 B1 68 ?? ?? ?? ?? 08 B9 73 68 2B 60 36 68 00 2E F5 D1 2A 68 00 2A D1 D1 ?? ?2 0? 0? ?? ?2 0? 0? B8 F1 00 0F 18 BF 40 46 FF F7 FA FD 28 60 00 28 C4 D0 0D 20 ?? ?? ?? ?? 00 28 BF D0 DB F8 00 10 ?? ?2 0? 0? ?? ?2 0? 0? CB F8 00 00 01 60 29 68 82 60 41 60 B2 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 82 46 00 28 00 F0 99 80 02 68 08 20 42 F4 00 42 CA F8 00 20 ?? ?? ?? ?? 01 90 00 28 00 F0 8A 80 01 99 02 96 4E 46 CD F8 18 90 C1 F8 00 90 C1 F8 04 90 CD F8 1C 90 03 97 CD F8 10 80 05 95 03 E0 DA F8 00 30 DB 06 61 D4 06 A8 07 A9 52 46 ?? ?? ?? ?? 03 1E 5A DB 06 98 01 3B C2 5C 0A 2A 04 BF 00 21 C1 54 4F F0 23 01 08 BF 06 98 ?? ?? ?? ?? 4F F0 00 02 02 70 06 9D 2B 78 00 2B E0 D0 3B 4A 1D EE 70 0F 7A 44 12 68 80 58 30 F8 13 20 92 04 09 D5 6A 1C 15 46 01 32 2B 78 30 F8 13 10 8F 04 F8 D4 00 2B CC D0 3A 2B CA D0 6A 1C 01 E0 3A 2B 08 D0 91 46 12 F8 01 3B 00 2B C1 D0 30 F8 13 10 89 04 F4 D5 A9 45 BB D0 4F F0 00 03 28 46 89 F8 00 30 09 F1 01 09 ?? ?? ?? ?? 02 46 0D 30 02 F1 01 08 ?? ?? ?? ?? 07 46 00 28 A9 D0 29 46 0C 30 42 46 B8 60 ?? ?? ?? ?? 48 46 FF F7 5C FD 00 21 39 60 78 60 96 B1 37 60 3E 46 99 E7 02 AE 06 98 05 9D 96 E8 C0 01 DD F8 04 90 ?? ?? ?? ?? 50 46 ?? ?? ?? ?? 01 9B CB F8 04 30 FE E6 01 9B 3E 46 1F 60 85 E7 50 46 ?? ?? ?? ?? 00 22 CB F8 04 20 32 E7 20 46 ?? ?? ?? ?? C9 E6 1D EE 70 1F 01 22 A1 F5 98 61 05 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 00 20 D6 E6 00 BF ?? ?? ?? ?? ?? ?? ?? ?? 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? F5 E6 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_4_0 {
	meta:
		name = "__nss_configure_lookup"
		size = 248
		refs = "0004 .LANCHOR1 0018 strcmp 0072 __nss_database_custom 0076 .LANCHOR0 00ca __lll_lock_wait_private 00e6 __libc_do_syscall 00ec __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? ?? ?2 0? 0? 06 46 88 46 3C 46 00 25 21 46 30 46 ?? ?? ?? ?? 10 34 00 28 0F D0 05 F1 01 05 01 DB 0E 2D F3 D1 2F 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 BD E8 F0 81 07 EB 05 17 FF 68 87 B3 40 46 FF F7 EA FC 06 46 70 B3 26 4C 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 53 BB ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 20 3E 60 01 21 59 55 93 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 05 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 11 DC 00 20 BD E8 F0 81 10 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 BD E8 F0 81 20 46 ?? ?? ?? ?? D0 E7 1D EE 70 1F 01 22 A1 F5 98 61 05 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? DF E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_5_0 {
	meta:
		name = "__nss_lookup_function"
		size = 652
		refs = "0036 known_compare 0042 __tsearch 0052 .LANCHOR0 008e malloc 00c0 strlen 00cc .LC13 00f4 stpcpy 00f8 .LC14 0108 strcpy 0114 __libc_dlsym 0158 strcmp 0174 .LC10 01a8 .LC11 01d4 __libc_dlopen_mode 0220 __tdelete 0226 free 0262 __libc_do_syscall 026e __lll_lock_wait_private 0280 __libc_errno 0284 .LC12"
	strings:
		$1 = { 2D E9 F0 4F 83 B0 00 AF 9C 4C 81 46 79 60 01 23 BF F3 5F 8F 54 E8 00 2F 00 2A 03 D1 44 E8 00 30 00 28 F7 D1 BF F3 5F 8F 00 2A 40 F0 1F 81 09 F1 1C 0B 07 F1 04 08 ?? ?2 0? 0? 59 46 40 46 ?? ?2 0? 0? ?? ?? ?? ?? 06 46 00 28 6C D0 03 68 43 45 1C D0 ?? ?2 0? 0? 5E 68 ?? ?2 0? 0? 00 21 AB 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 00 F3 E5 80 30 46 0C 37 BD 46 BD E8 F0 8F 08 20 ?? ?? ?? ?? 82 46 00 28 00 F0 CA 80 30 60 ?? ?2 0? 0? 7B 68 03 60 D9 F8 18 60 00 2E 41 D0 ?? ?2 0? 0? 73 68 00 2B 57 D0 01 33 33 D0 D9 F8 20 00 E8 46 ?? ?? ?? ?? 06 46 78 68 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 9A 88 06 44 18 68 06 F1 0E 03 23 F0 07 03 AD EB 03 0D AD F8 04 20 00 90 0D F1 05 00 D9 F8 20 10 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1B 88 20 F8 01 3B 79 68 ?? ?? ?? ?? D9 F8 18 30 69 46 58 68 ?? ?? ?? ?? C5 46 06 46 CA F8 04 60 9C E7 00 26 FA E7 ?? ?2 0? 0? ?? ?2 0? 0? 95 E7 D9 F8 20 30 ?? ?2 0? 0? 05 F1 0C 02 3B 60 6B 68 00 2B 18 BF 1A 46 56 68 26 B9 8D E0 B2 68 00 2A 4C D0 16 46 30 68 39 68 ?? ?? ?? ?? 00 28 F5 D1 C9 F8 18 60 A4 E7 D9 F8 20 00 1D EE 70 8F ?? ?? ?? ?? 43 4A ?? ?2 0? 0? EB 46 7A 44 12 68 ?? ?2 0? 0? 40 4E 58 F8 02 20 3A 60 00 F1 14 02 03 CB 22 F0 07 03 AD EB 03 0D 00 90 0D F1 07 00 01 91 D9 F8 20 10 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 96 F8 02 C0 01 21 C8 F2 00 01 03 46 86 46 10 68 32 88 43 F8 03 0B 68 46 AE F8 03 20 83 F8 02 C0 D9 F8 18 60 ?? ?? ?? ?? 70 60 D9 F8 18 30 5A 68 52 B3 D9 F8 18 30 DD 46 5B 68 64 E7 08 36 0C 20 ?? ?? ?? ?? 30 60 00 28 3C D0 3B 68 00 22 03 60 31 68 4A 60 31 68 8A 60 36 68 C9 F8 18 60 00 2E 7F F4 4E AF ?? ?2 0? 0? 59 46 ?? ?2 0? 0? 40 46 ?? ?? ?? ?? 50 46 ?? ?? ?? ?? 00 26 16 E7 ?? ?2 0? 0? ?? ?2 0? 0? ED E7 13 4A 4F F0 FF 31 59 60 3B 68 7A 44 12 68 48 F8 02 30 CA E7 1D EE 70 1F 01 22 A1 F5 98 61 09 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 0C E7 16 1D C0 E7 20 46 ?? ?? ?? ?? DC E6 C9 F8 18 00 CC E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_6_0 {
	meta:
		name = "__nss_lookup"
		size = 106
		refs = "000e __nss_lookup_function"
	strings:
		$1 = { 2D E9 F0 41 05 46 00 68 1E 46 90 46 0F 46 ?? ?? ?? ?? 30 60 28 B3 B0 B9 2C 68 39 46 A0 68 A8 B9 24 68 20 46 D4 B1 2C 60 ?? ?? ?? ?? 30 60 00 28 F1 D1 B8 F1 00 0F EF D0 28 68 41 46 ?? ?? ?? ?? 30 60 00 28 E8 D0 00 20 BD E8 F0 81 20 68 00 28 14 BF 4F F0 FF 30 01 20 BD E8 F0 81 01 20 BD E8 F0 81 B8 F1 00 0F E7 D1 D5 E7 }
	condition:
		$1
}

rule file_317_7_0 {
	meta:
		name = "__nss_next2"
		size = 130
		refs = "001e __nss_lookup_function 0076 .LC15 007e __libc_fatal"
	strings:
		$1 = { F8 B5 1D 46 07 9B 04 46 0E 46 17 46 F3 B1 03 68 5A 68 01 2A 25 D0 18 68 A8 B1 20 60 31 46 ?? ?? ?? ?? 28 60 08 B1 00 20 F8 BD 37 B1 20 68 39 46 ?? ?? ?? ?? 28 60 00 28 F5 D1 20 68 83 68 13 B9 00 68 00 28 E9 D1 4F F0 FF 30 F8 BD 06 9B 9A 1C 04 2A 10 D8 03 68 03 EB 82 02 50 68 01 28 DA D1 F8 BD 9A 68 01 2A D6 D1 DA 68 01 2A D3 D1 18 69 01 28 D0 D1 F8 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_317_8_0 {
	meta:
		name = "free_defconfig"
		size = 22
		refs = "0000 .LANCHOR0 0010 free_database_entries"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 18 68 18 B1 00 22 1A 60 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_317_9_0 {
	meta:
		name = "free_mem"
		size = 78
		refs = "0000 .LANCHOR0 0014 free_database_entries 0022 free 0032 __libc_dlclose"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 70 B5 5E 68 F6 B1 30 68 00 22 5A 60 ?? ?? ?? ?? 74 68 34 B9 11 E0 A5 68 20 46 ?? ?? ?? ?? 65 B1 2C 46 60 68 43 1E 03 33 F5 D8 ?? ?? ?? ?? A5 68 20 46 ?? ?? ?? ?? 00 2D F2 D1 30 46 BD E8 70 40 ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_317_10_0 {
	meta:
		name = "__nss_next"
		size = 24
		refs = "0010 __nss_next2"
	strings:
		$1 = { 30 B5 83 B0 15 46 00 22 06 9C 00 93 2B 46 01 94 ?? ?? ?? ?? 03 B0 30 BD }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "__sleep"
		size = 404
		refs = "002a memset 0036 __sigaction 004a __sigprocmask 0052 __nanosleep 017c __pthread_unwind 0184 __libc_errno"
	strings:
		$1 = { F0 B5 04 46 E7 B0 00 28 00 F0 96 80 00 22 6F F0 00 47 13 46 4F F4 80 36 02 92 27 E0 23 99 11 F4 80 35 14 D1 29 46 80 22 03 A8 ?? ?? ?? ?? 11 20 29 46 43 AA 03 96 ?? ?? ?? ?? 00 28 69 DB 43 9B 01 2B 2A D0 2A 46 02 20 23 A9 ?? ?? ?? ?? 01 A8 01 46 ?? ?? ?? ?? D0 F1 01 03 05 46 38 BF 00 23 00 2C 08 BF 00 23 00 2B 42 D0 01 9B BC 42 94 BF 1B 19 DB 19 00 21 80 22 03 A8 01 93 E4 1A ?? ?? ?? ?? 00 20 03 A9 23 AA 03 96 ?? ?? ?? ?? 00 28 C4 D0 4F F0 FF 30 67 B0 F0 BD 4F F6 FE 76 C7 F6 FF 76 07 E0 02 9B B4 42 94 BF 22 46 6F F0 00 42 01 92 E4 1A 01 A8 01 46 ?? ?? ?? ?? D4 F1 01 03 38 BF 00 23 00 28 18 BF 43 F0 01 03 05 46 00 2B E8 D0 2C 4B 1D EE 70 6F 23 A9 02 20 7B 44 1B 68 00 22 F7 58 ?? ?? ?? ?? 27 4B 7B 44 1B 68 F7 50 65 B1 02 98 46 F2 FF 43 01 9A C1 F6 CD 53 98 42 D4 BF 13 46 53 1C 18 19 67 B0 F0 BD 00 20 67 B0 F0 BD 1E 4B 1D EE 70 4F 2A 46 23 A9 7B 44 1B 68 02 20 E5 58 ?? ?? ?? ?? 19 4B 4F F0 FF 30 7B 44 1B 68 E5 50 67 B0 F0 BD 1D EE 70 1F A1 F5 98 62 D2 F8 84 30 23 F0 46 00 08 28 DF D1 A1 F2 3C 41 4F F0 FF 30 C2 F8 20 02 43 F0 10 04 BF F3 5F 8F 51 E8 00 0F 98 42 03 D1 41 E8 00 45 00 2D F7 D1 98 42 BF F3 5F 8F 03 D1 D2 F8 80 00 ?? ?? ?? ?? 0B 68 E9 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "skip_string"
		size = 76
		refs = "0048 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 10 B4 03 78 E3 B1 10 4A 1D EE 70 1F 7A 44 12 68 8C 58 34 F8 13 20 92 04 12 D4 23 2B 10 D0 2C 2B 0E D0 42 1C 07 E0 34 F8 13 10 89 04 08 D4 23 2B 06 D0 2C 2B 04 D0 10 46 12 F8 01 3B 00 2B F2 D1 5D F8 04 4B 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_1_0 {
	meta:
		name = "arg_trimdomain_list"
		size = 316
		refs = "0004 _res_hconf 0036 __strndup 00bc _libc_intl_domainname 00c0 .LC0 00d0 __dcgettext 00de __asprintf 00e6 .LC1 00f2 __fxprintf 00f8 free 0112 .LC2 0138 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? DF F8 28 81 87 B0 83 46 92 46 3E 46 4F F0 01 09 03 91 50 46 FF F7 C8 FF BD 69 03 2D 04 46 CA EB 00 01 45 DC 50 46 6B 1C B3 61 ?? ?? ?? ?? 06 EB 85 05 42 46 1D EE 70 3F E8 61 7A 44 12 68 25 78 99 58 31 F8 15 30 9A 04 30 D5 01 34 A2 46 14 F8 01 5B 31 F8 15 30 9B 04 F8 D4 2C 3D ED B2 0F 2D 1A D8 09 FA 05 F5 4C F2 01 03 2B 40 A3 B1 9A F8 01 00 0A F1 01 04 31 F8 10 30 9D 04 3C D5 0A F1 02 03 9A 46 13 F8 01 0B 31 F8 10 40 A2 04 F8 D4 00 28 18 BF 23 28 34 D0 9A F8 00 30 23 2B 18 BF 00 2B B6 D1 50 46 07 B0 BD E8 F0 8F A2 46 D4 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? 04 24 ?? ?? ?? ?? 5A 46 03 9B 00 94 01 46 05 A8 ?? ?? ?? ?? 00 28 0A DB ?? ?2 0? 0? 00 20 ?? ?2 0? 0? 05 9A ?? ?? ?? ?? 05 98 ?? ?? ?? ?? 00 20 07 B0 BD E8 F0 8F 00 28 18 BF 23 28 A2 46 CA D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 5A 46 03 9B 01 46 05 A8 ?? ?? ?? ?? 00 28 D8 DA E2 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_2_0 {
	meta:
		name = "arg_spoof.isra.0"
		size = 118
		refs = "0010 _res_hconf 0032 .LC4 003c __strncasecmp 0046 .LC3"
	strings:
		$1 = { F8 B5 06 46 FF F7 38 FF 82 1B 05 46 03 2A 1A D0 ?? ?2 0? 0? 04 2A ?? ?2 0? 0? E7 6A 47 F0 06 03 E3 62 06 D0 27 F0 04 07 47 F0 02 07 E7 62 28 46 F8 BD ?? ?2 0? 0? 30 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 EF D1 F3 E7 ?? ?2 0? 0? 30 46 ?? ?2 0? 0? ?? ?? ?? ?? 28 B1 ?? ?2 0? 0? ?? ?2 0? 0? E7 6A E0 E7 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? DA 6A 22 F0 06 02 DA 62 F8 BD }
	condition:
		$1
}

rule file_320_3_0 {
	meta:
		name = "arg_bool"
		size = 156
		refs = "0004 .LC5 0018 __strncasecmp 001e _res_hconf 0032 .LC3 005a _libc_intl_domainname 005e .LC6 006c __dcgettext 007a __asprintf 0082 .LC1 008e __fxprintf 0094 free"
	strings:
		$1 = { F0 B5 0E 46 ?? ?2 0? 0? 85 B0 14 46 07 46 ?? ?2 0? 0? 10 46 02 22 1D 46 ?? ?? ?? ?? 48 B9 ?? ?2 0? 0? A0 1C ?? ?2 0? 0? D3 6A 1D 43 D5 62 05 B0 F0 BD ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 03 22 ?? ?? ?? ?? 50 B9 ?? ?2 0? 0? E0 1C ?? ?2 0? 0? D3 6A 23 EA 05 05 D5 62 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? 00 94 3A 46 33 46 01 46 03 A8 ?? ?? ?? ?? 00 28 0A DB ?? ?2 0? 0? 00 20 ?? ?2 0? 0? 03 9A ?? ?? ?? ?? 03 98 ?? ?? ?? ?? 00 20 C8 E7 }
	condition:
		$1
}

rule file_320_4_0 {
	meta:
		name = "do_init"
		size = 664
		refs = "0004 _res_hconf 000e .LC8 0032 getenv 0036 .LC7 003a .LC9 004e _IO_new_fopen 006c fgets_unlocked 0078 __strchrnul 00ba .LANCHOR0 00d2 __strncasecmp 00da strlen 00e8 _libc_intl_domainname 00ec .LC16 00fa __dcgettext 010a __asprintf 0112 .LC1 011e __fxprintf 0124 free 012c _IO_new_fclose 0130 .LC11 0142 .LC12 0162 .LC13 0182 .LC14 01a0 .LC15 025c .LC10 028c __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? C9 B0 ?? ?2 0? 0? 00 27 ?? ?2 0? 0? 27 60 67 60 A7 60 E7 60 27 61 67 61 A7 61 E7 61 27 62 67 62 A7 62 E7 62 03 94 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? B8 42 08 BF 18 46 05 90 ?? ?? ?? ?? 04 90 00 28 6B D0 DF F8 38 82 03 68 43 F4 00 43 03 60 08 A8 4F F4 80 71 04 9A ?? ?? ?? ?? 00 28 5A D0 08 A8 0A 21 ?? ?? ?? ?? 00 23 1D EE 70 AF 01 37 03 70 81 4B 9D F8 20 40 7B 44 1B 68 5A F8 03 60 36 F8 14 30 9D 04 40 F1 99 80 0D F1 21 02 91 46 12 F8 01 4B 36 F8 14 30 98 04 F8 D4 00 2C 18 BF 23 2C D5 D0 48 46 ?? ?2 0? 0? FF F7 51 FE ?? ?2 0? 0? 05 46 C9 EB 00 0B 48 46 21 46 5A 46 ?? ?? ?? ?? 20 B9 20 46 ?? ?? ?? ?? 83 45 7E D0 10 34 44 45 F1 D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?? ?? ?? CD F8 00 90 01 46 07 A8 05 9A 3B 46 ?? ?? ?? ?? 00 28 A8 DB ?? ?2 0? 0? 07 9A ?? ?2 0? 0? 00 20 ?? ?? ?? ?? 07 98 ?? ?? ?? ?? 9C E7 04 98 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 08 B1 FF F7 D5 FE ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 02 46 38 B1 ?? ?2 0? 0? 01 21 ?? ?2 0? 0? 10 23 FF F7 01 FF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 02 46 38 B1 ?? ?2 0? 0? 01 21 ?? ?2 0? 0? 08 23 FF F7 F1 FE ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 02 46 30 B1 ?? ?2 0? 0? 01 21 ?? ?2 0? 0? FF F7 08 FE ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 02 46 48 B1 03 9C ?? ?2 0? 0? ?? ?2 0? 0? 01 21 00 23 A3 61 FF F7 F6 FD 03 9C 01 23 23 60 49 B0 BD E8 F0 8F 00 2C 18 BF 23 2C 0D F1 20 09 3F F4 43 AF 6B E7 2B 78 36 F8 13 30 99 04 48 BF 6B 1C 06 D5 1D 46 13 F8 01 2B 36 F8 12 20 92 04 F8 D4 E3 7A 01 2B 38 D0 02 2B 3D D0 03 2B 7F F4 2C AF E3 68 2A 46 05 98 39 46 FF F7 A6 FE 04 46 00 2C 3F F4 22 AF 23 78 00 2B 3F F4 1E AF 19 4A 7A 44 12 68 5A F8 02 00 30 F8 13 20 95 04 48 BF 62 1C 09 D5 14 46 12 F8 01 3B 00 2B 3F F4 0D AF 30 F8 13 10 89 04 F5 D4 23 2B 3F F4 06 AF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?? ?? ?? 00 94 01 46 47 E7 2A 46 05 98 39 46 FF F7 99 FD 04 46 CB E7 28 46 FF F7 32 FE 04 46 C6 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_5_0 {
	meta:
		name = "_res_hconf_init"
		size = 62
		refs = "0000 __pthread_once 000c .LANCHOR1 0010 do_init"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 10 B5 5B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? BD E8 10 40 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 23 68 2B B9 FF F7 9A FE 23 68 43 F0 02 03 23 60 10 BD }
	condition:
		$1
}

rule file_320_6_0 {
	meta:
		name = "_res_hconf_reorder_addrs"
		size = 624
		refs = "0000 _res_hconf 0022 .LANCHOR2 003e .LANCHOR3 00b0 __socket 00e6 __close 00f8 __ifreq 011a malloc 0188 __ioctl 01be realloc 01ce free 01d4 .LANCHOR1 0224 __libc_do_syscall 023a .LC17 023e .LC18 0242 __PRETTY_FUNCTION__.15680 0256 __assert_fail 025c __lll_lock_wait_private 0264 __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 4F 04 46 DB 6A 8B B0 1B 07 02 D5 83 68 02 2B 02 D0 0B B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? 28 68 00 28 34 DD D4 F8 10 C0 DC F8 00 80 B8 F1 00 0F EE D0 ?? ?2 0? 0? 0C F1 04 09 ?? ?2 0? 0? 47 46 A3 46 1E 68 00 28 14 DD 3D 68 72 68 B3 68 6A 40 1A 42 14 D0 32 46 00 23 08 E0 11 46 14 69 0C 32 49 69 85 EA 04 0A 1A EA 01 0F 08 D0 01 33 83 42 F3 D1 CC 46 59 F8 04 7B 00 2F E3 D1 C8 E7 CC F8 00 80 DB F8 10 30 1F 60 0B B0 BD E8 F0 8F 72 4E 1D EE 70 9F 18 46 19 46 7E 44 36 68 00 22 59 F8 06 60 04 96 ?? ?? ?? ?? B0 F1 00 0B B0 DB DF F8 B0 A1 01 22 BF F3 5F 8F 5A E8 00 3F 00 2B 03 D1 4A E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 BE 80 2B 68 00 2B 06 DD 58 46 ?? ?? ?? ?? 28 68 00 28 95 D0 9E E7 08 A8 09 A9 5A 46 ?? ?? ?? ?? 08 9B 05 93 00 2B 00 F0 92 80 09 9B ?? ?2 0? 0? ?? ?2 0? 0? CD F8 0C C0 03 EB 43 00 80 00 ?? ?? ?? ?? DD F8 0C C0 01 46 CC F8 00 00 00 28 00 F0 81 80 09 98 00 28 7F DD 05 9E 4F F0 00 08 CD F8 18 90 47 46 06 F1 10 03 A1 46 01 93 07 95 06 E0 08 EB 48 04 A4 00 01 37 20 36 B8 42 28 DD 32 8A 02 2A F5 D1 05 9B 08 EB 48 04 58 46 F5 1A 01 9B 41 F8 24 20 A4 00 1D 44 01 EB 04 0E 32 46 48 F6 1B 11 6B 68 CE F8 04 30 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 DC F8 00 10 00 28 A1 BF 0A 19 08 F1 01 08 6D 68 0C 34 B2 BF 09 98 09 98 95 60 D2 E7 23 46 07 9D 4C 46 DD F8 18 90 08 46 19 46 CD F8 0C C0 ?? ?? ?? ?? DD F8 0C C0 CC F8 00 00 B0 B3 08 98 ?? ?? ?? ?? 25 4B ?? ?2 0? 0? 04 9E ?? ?2 0? 0? 7B 44 1B 68 00 21 C5 F8 00 80 49 F8 03 60 53 68 BF F3 5F 8F 5A E8 00 0F 98 42 03 D1 4A E8 00 16 00 2E F7 D1 83 42 BF F3 5F 8F F0 D1 01 2B 7F F7 6A AF A9 F5 98 69 01 22 15 48 00 23 D9 F8 08 10 4F F0 F0 0C 11 43 ?? ?? ?? ?? 5C E7 DD F8 14 80 D0 E7 80 46 CB E7 00 23 98 46 BD E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 E3 72 ?? ?? ?? ?? 50 46 ?? ?? ?? ?? 3D E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_320_7_0 {
	meta:
		name = "_res_hconf_trim_domain"
		size = 80
		refs = "0006 strlen 000a _res_hconf 003c __strcasecmp"
	strings:
		$1 = { 2D E9 F8 43 81 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? D7 F8 18 80 B8 F1 00 0F 06 46 13 DD 18 37 00 24 57 F8 04 5F 01 34 28 46 ?? ?? ?? ?? 29 46 32 1A 86 42 09 EB 02 05 28 46 02 D9 ?? ?? ?? ?? 18 B1 44 45 ED D1 BD E8 F8 83 28 70 BD E8 F8 83 }
	condition:
		$1
}

rule file_320_8_0 {
	meta:
		name = "_res_hconf_trim_domains"
		size = 50
		refs = "0002 _res_hconf 0014 _res_hconf_trim_domain"
	strings:
		$1 = { 38 B5 ?? ?2 0? 0? ?? ?2 0? 0? 05 46 9B 69 03 B9 38 BD 00 68 ?? ?? ?? ?? 6B 68 18 68 00 28 F7 D0 04 24 ?? ?? ?? ?? 6B 68 18 59 04 34 00 28 F8 D1 38 BD }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__isoc99_vswscanf"
		size = 82
		refs = "0006 _IO_wstr_jumps 0022 _IO_no_init 002a _IO_fwide 0036 _IO_wstr_init_static 004a _IO_vfwscanf"
	strings:
		$1 = { F0 B5 DD B0 00 24 ?? ?2 0? 0? 05 46 0F 46 16 46 02 A8 22 46 ?? ?2 0? 0? 4F F4 00 41 00 93 2D AB 14 94 ?? ?? ?? ?? 02 A8 01 21 ?? ?? ?? ?? 02 A8 29 46 22 46 23 46 ?? ?? ?? ?? 11 9D 39 46 32 46 23 46 02 A8 45 F0 10 05 11 95 ?? ?? ?? ?? 5D B0 F0 BD }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "flush_cleanup"
		size = 188
		refs = "0002 .LANCHOR0 0094 __libc_do_syscall"
	strings:
		$1 = { 30 B5 ?? ?2 0? 0? ?? ?2 0? 0? 23 68 13 B1 1A 68 12 04 1C D5 A2 68 ?? ?2 0? 0? ?? ?2 0? 0? 01 3A A2 60 9A B9 19 1D 10 46 DA 60 63 68 BF F3 5F 8F 51 E8 00 2F 9A 42 03 D1 41 E8 00 05 00 2D F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 26 DC 30 BD 98 6C 43 68 01 3B 43 60 00 2B DC D1 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 25 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B C9 DD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? BC E7 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? CA E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_1_0 {
	meta:
		name = "save_for_backup"
		size = 286
		refs = "006a malloc 0086 memcpy 0090 free 00d8 memmove 0106 mempcpy"
	strings:
		$1 = { 2D E9 F0 4F 06 46 D0 F8 0C A0 83 B0 03 6B 88 46 CA EB 01 07 00 2B 53 D0 3D 46 1C 46 A2 68 24 68 95 42 A8 BF 15 46 00 2C F8 D1 D6 F8 2C B0 7C 1B 70 6A C0 EB 0B 02 94 42 14 D8 00 2D C4 EB 02 09 46 DB 00 2C 2F D1 81 44 39 46 C6 F8 28 90 2B B1 9A 68 52 1A 9A 60 1B 68 00 2B F9 D1 00 20 03 B0 BD E8 F0 8F 04 F1 64 07 38 46 ?? ?? ?? ?? 03 46 00 28 51 D0 00 2D 00 F1 64 09 3F DB 0A EB 05 01 22 46 48 46 01 93 ?? ?? ?? ?? 01 9B 70 6A 01 93 ?? ?? ?? ?? 01 9B F1 68 1F 44 F7 62 73 62 C1 EB 08 01 33 6B D1 E7 48 44 0A EB 05 01 22 46 ?? ?? ?? ?? F1 68 70 6A 33 6B C1 EB 08 01 81 44 C4 E7 D0 F8 2C B0 00 2F 40 6A C0 EB 0B 09 BB DA 3D 46 48 44 0B EB 05 01 6A 42 ?? ?? ?? ?? F1 68 73 6A C5 EB 09 00 C1 EB 08 02 18 44 ?? ?? ?? ?? F1 68 72 6A C1 EB 08 01 33 6B 91 44 A6 E7 0B EB 05 01 6A 42 48 46 01 93 ?? ?? ?? ?? F1 68 C1 EB 08 02 ?? ?? ?? ?? 01 9B B9 E7 4F F0 FF 30 9F E7 }
	condition:
		$1
}

rule file_323_2_0 {
	meta:
		name = "_IO_un_link"
		size = 472
		refs = "000e _pthread_cleanup_push_defer 0022 flush_cleanup 0032 .LANCHOR0 00b6 _IO_list_all 0162 _pthread_cleanup_pop_restore 019c __libc_do_syscall 01a2 __lll_lock_wait_private"
	strings:
		$1 = { 03 68 F0 B5 1B 06 85 B0 04 46 40 F1 AC 80 ?? ?2 0? 0? ?? ?2 0? 0? 1F 1C 18 BF 01 27 00 2F 00 F0 D1 80 ?? ?2 0? 0? 68 46 ?? ?2 0? 0? 00 22 ?? ?? ?? ?? ?? ?2 0? 0? 1D EE 70 6F ?? ?2 0? 0? A6 F5 98 66 EB 68 B3 42 11 D0 29 1D 01 22 BF F3 5F 8F 51 E8 00 3F 00 2B 03 D1 41 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 A9 80 EE 60 21 68 AB 68 11 F4 00 4C 2C 60 03 F1 01 03 AB 60 1B D1 A0 6C 83 68 9E 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 7E D1 A3 6C 18 46 9E 60 21 68 43 68 01 F4 00 4C 01 33 43 60 ?? ?2 0? 0? ?? ?2 0? 0? 18 68 78 B1 84 42 5E D0 42 6B 5A B1 94 42 08 BF 00 F1 34 02 03 D1 4A E0 9C 42 47 D0 1A 46 53 6B 00 2B F9 D1 21 F0 80 01 21 60 BC F1 00 0F 18 D1 A0 6C 43 68 01 3B 43 60 9B B9 62 46 C0 F8 08 C0 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 37 DC AA 68 ?? ?2 0? 0? 00 21 ?? ?2 0? 0? 01 3A 29 60 AA 60 9A B9 19 1D 10 46 DA 60 6B 68 BF F3 5F 8F 51 E8 00 2F 9A 42 03 D1 41 E8 00 04 00 2C F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 25 DC 1F B1 68 46 00 21 ?? ?? ?? ?? 05 B0 F0 BD 34 32 60 6B 21 F0 80 01 AB 69 10 60 01 33 21 60 AB 61 BC F1 00 0F CE D1 B4 E7 60 6B AA 69 18 60 01 32 AA 61 A8 E7 B1 68 01 22 00 23 4F F0 F0 0C 11 43 ?? ?? ?? ?? BE E7 ?? ?? ?? ?? 7D E7 B1 68 01 22 09 48 00 23 11 43 4F F0 F0 0C ?? ?? ?? ?? CF E7 08 46 ?? ?? ?? ?? 52 E7 ?? ?2 0? 0? 01 97 ?? ?2 0? 0? 00 93 2F E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_3_0 {
	meta:
		name = "_IO_link_in"
		size = 424
		refs = "0010 _pthread_cleanup_push_defer 002a flush_cleanup 0038 .LANCHOR0 00b6 _IO_list_all 0112 __libc_do_syscall 0180 _pthread_cleanup_pop_restore 018a __lll_lock_wait_private"
	strings:
		$1 = { 03 68 F0 B5 13 F0 80 02 85 B0 05 46 40 F0 BA 80 ?? ?2 0? 0? 43 F0 80 03 ?? ?2 0? 0? 03 60 0F 1C 18 BF 01 27 00 2F 00 F0 B3 80 ?? ?2 0? 0? 68 46 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 1D EE 70 6F ?? ?2 0? 0? A6 F5 98 66 E3 68 B3 42 11 D0 21 1D 01 22 BF F3 5F 8F 51 E8 00 3F 00 2B 03 D1 41 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 8C 80 E6 60 A1 68 ?? ?2 0? 0? 2A 68 ?? ?2 0? 0? 01 31 A1 60 11 04 25 60 47 D4 A8 6C 83 68 9E 42 12 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 77 D1 AB 6C 2A 68 18 46 9E 60 ?? ?2 0? 0? 43 68 ?? ?2 0? 0? A1 69 01 33 43 60 DC F8 00 30 01 31 CC F8 00 50 A1 61 6B 63 13 04 29 D4 43 68 01 3B 43 60 2B BB 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 25 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 12 DD B1 68 01 22 00 23 4F F0 F0 0C 11 43 ?? ?? ?? ?? 09 E0 ?? ?2 0? 0? 99 69 ?? ?2 0? 0? 01 31 99 61 13 68 15 60 6B 63 A2 68 ?? ?2 0? 0? 00 21 ?? ?2 0? 0? 01 3A 21 60 A2 60 E2 B9 19 1D 10 46 DA 60 63 68 BF F3 5F 8F 51 E8 00 2F 9A 42 03 D1 41 E8 00 05 00 2D F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 08 DD B1 68 01 22 0D 48 00 23 11 43 4F F0 F0 0C ?? ?? ?? ?? 1F B1 68 46 00 21 ?? ?? ?? ?? 05 B0 F0 BD 08 46 ?? ?? ?? ?? 6F E7 ?? ?2 0? 0? 01 97 ?? ?2 0? 0? 00 93 4C E7 ?? ?? ?? ?? 84 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_4_0 {
	meta:
		name = "_IO_least_marker"
		size = 24
	strings:
		$1 = { C2 68 03 6B 88 1A 33 B1 9A 68 1B 68 90 42 A8 BF 10 46 00 2B F8 D1 70 47 }
	condition:
		$1
}

rule file_323_5_0 {
	meta:
		name = "_IO_switch_to_main_get_area"
		size = 32
	strings:
		$1 = { 30 B4 43 6A 85 68 C4 6A C2 68 01 68 84 60 21 F4 80 71 C5 62 01 60 42 62 C3 60 43 60 30 BC 70 47 }
	condition:
		$1
}

rule file_323_6_0 {
	meta:
		name = "_IO_switch_to_backup_area"
		size = 32
	strings:
		$1 = { 30 B4 C3 6A 84 68 C5 68 42 6A 01 68 C4 62 41 F4 80 71 45 62 83 60 80 E8 0A 00 C2 60 30 BC 70 47 }
	condition:
		$1
}

rule file_323_7_0 {
	meta:
		name = "_IO_switch_to_get_mode"
		size = 72
	strings:
		$1 = { 43 69 02 69 10 B5 93 42 04 46 13 D8 22 68 D1 05 0D D4 E0 69 A1 68 E0 60 99 42 38 BF A3 60 00 20 22 F4 00 62 A3 61 84 E8 0C 00 23 61 10 BD A1 6A E1 60 F4 E7 D0 F8 98 30 4F F0 FF 31 DB 68 98 47 43 1C F3 D0 63 69 E1 E7 }
	condition:
		$1
}

rule file_323_8_0 {
	meta:
		name = "_IO_free_backup_area"
		size = 54
		refs = "0024 free"
	strings:
		$1 = { 03 68 70 B5 DA 05 04 46 13 D5 C1 68 23 F4 80 73 42 6A 85 68 08 46 E6 6A 23 60 61 62 E2 60 62 60 E5 62 A6 60 ?? ?? ?? ?? 00 23 63 62 E3 62 A3 62 70 BD 40 6A F6 E7 }
	condition:
		$1
}

rule file_323_9_0 {
	meta:
		name = "__overflow"
		size = 22
	strings:
		$1 = { 08 B5 C3 6E 13 B9 4F F0 FF 33 C3 66 D0 F8 98 30 DB 68 98 47 08 BD }
	condition:
		$1
}

rule file_323_10_0 {
	meta:
		name = "__underflow"
		size = 130
		refs = "006a _IO_switch_to_get_mode 007c _IO_free_backup_area"
	strings:
		$1 = { 38 B5 04 46 C3 6E CB B9 4F F0 FF 33 C3 66 23 68 18 05 29 D4 63 68 A2 68 93 42 23 D3 23 68 D9 05 11 D4 23 6B 33 B3 20 46 A1 68 FF F7 21 FD 38 B9 D4 F8 98 30 20 46 1B 69 98 47 38 BD 01 33 E6 D0 4F F0 FF 30 38 BD 61 6A 23 F4 80 73 E0 6A E5 68 88 42 23 60 A0 60 E2 62 65 62 E1 60 61 60 E0 D9 08 78 38 BD 18 78 38 BD 20 46 ?? ?? ?? ?? 01 30 D0 D1 E5 E7 63 6A 00 2B DA D0 20 46 ?? ?? ?? ?? D6 E7 }
	condition:
		$1
}

rule file_323_11_0 {
	meta:
		name = "__uflow"
		size = 142
		refs = "0076 _IO_switch_to_get_mode 0088 _IO_free_backup_area"
	strings:
		$1 = { 38 B5 04 46 C3 6E D3 B9 4F F0 FF 33 C3 66 23 68 18 05 2F D4 63 68 A2 68 93 42 27 D3 23 68 D9 05 12 D4 23 6B 00 2B 2B D0 20 46 A1 68 FF F7 DE FC 38 B9 D4 F8 98 30 20 46 5B 69 98 47 38 BD 01 33 E5 D0 4F F0 FF 30 38 BD 61 6A 23 F4 80 73 E0 6A E5 68 88 42 23 60 A0 60 E2 62 65 62 E1 60 98 BF 61 60 DE D9 4B 1C 63 60 08 78 38 BD 5A 1C 62 60 18 78 38 BD 20 46 ?? ?? ?? ?? 01 30 CA D1 E0 E7 63 6A 00 2B D5 D0 20 46 ?? ?? ?? ?? D1 E7 }
	condition:
		$1
}

rule file_323_12_0 {
	meta:
		name = "_IO_setb"
		size = 78
		refs = "0042 __munmap"
	strings:
		$1 = { F0 B5 04 46 C6 69 83 B0 0F 46 05 68 0E B1 E9 07 0C D5 E7 61 22 62 23 B9 45 F0 01 05 25 60 03 B0 F0 BD 25 F0 01 05 25 60 03 B0 F0 BD 01 6A 30 46 01 92 89 1B 00 93 01 F6 FF 71 21 F4 7F 61 21 F0 0F 01 ?? ?? ?? ?? 25 68 00 9B 01 9A E1 E7 }
	condition:
		$1
}

rule file_323_13_0 {
	meta:
		name = "_IO_doallocbuf"
		size = 56
		refs = "0034 _IO_setb"
	strings:
		$1 = { C3 69 10 B5 04 46 03 B1 10 BD 03 68 9B 07 02 D5 C3 6E 00 2B 06 DD D4 F8 98 30 20 46 5B 6B 98 47 01 30 F1 D1 20 46 04 F1 47 01 04 F1 48 02 00 23 BD E8 10 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_15_0 {
	meta:
		name = "_IO_default_uflow"
		size = 26
	strings:
		$1 = { D0 F8 98 30 10 B5 04 46 1B 69 98 47 43 1C 1F BF 63 68 5A 1C 62 60 18 78 10 BD }
	condition:
		$1
}

rule file_323_16_0 {
	meta:
		name = "_IO_default_xsputn"
		size = 124
		refs = "0064 mempcpy"
	strings:
		$1 = { 2D E9 F8 43 90 46 05 46 0E 46 00 2A 33 D0 14 46 68 69 A9 69 88 42 17 D2 09 1A 8C 42 34 BF A1 46 89 46 B9 F1 14 0F 1B D8 B9 F1 00 0F 0A D0 00 EB 09 02 31 46 11 F8 01 7B 00 F8 01 7B 90 42 F9 D1 4E 44 68 61 C9 EB 04 04 8C B1 D5 F8 98 30 28 46 31 78 01 36 DB 68 98 47 01 30 08 D0 01 3C D7 E7 31 46 4A 46 ?? ?? ?? ?? 4E 44 68 61 EA E7 C4 EB 08 00 BD E8 F8 83 10 46 BD E8 F8 83 }
	condition:
		$1
}

rule file_323_18_0 {
	meta:
		name = "_IO_default_xsgetn"
		size = 106
		refs = "0048 __underflow 005c mempcpy"
	strings:
		$1 = { 2D E9 F8 43 90 46 05 46 0F 46 16 46 69 68 AB 68 99 42 17 D2 5B 1A 9E 42 34 BF B1 46 99 46 B9 F1 14 0F 19 D8 B9 F1 00 0F 0A D0 01 EB 09 02 3B 46 11 F8 01 4B 91 42 03 F8 01 4B F9 D1 4F 44 69 60 C9 EB 06 06 26 B1 28 46 ?? ?? ?? ?? 01 30 DD D1 C6 EB 08 00 BD E8 F8 83 38 46 4A 46 ?? ?? ?? ?? 6B 68 4B 44 6B 60 07 46 EA E7 }
	condition:
		$1
}

rule file_323_19_0 {
	meta:
		name = "_IO_default_setbuf"
		size = 100
		refs = "0030 _IO_setb"
	strings:
		$1 = { D0 F8 98 30 70 B5 04 46 1B 6B 0E 46 15 46 98 47 01 30 25 D0 00 2D 18 BF 00 2E 14 BF 00 23 01 23 11 D0 20 68 72 19 31 46 20 F0 02 05 20 46 25 60 ?? ?? ?? ?? 00 23 20 46 A3 61 63 61 23 61 A3 60 63 60 E3 60 70 BD 23 68 21 46 20 46 04 F1 48 02 43 F0 02 05 00 23 41 F8 47 5B ?? ?? ?? ?? E9 E7 00 20 70 BD }
	condition:
		$1
}

rule file_323_20_0 {
	meta:
		name = "_IO_default_seekpos"
		size = 24
	strings:
		$1 = { 30 B5 83 B0 D0 F8 98 40 00 25 06 99 00 95 01 91 61 6A 88 47 03 B0 30 BD }
	condition:
		$1
}

rule file_323_21_0 {
	meta:
		name = "_IO_default_doallocate"
		size = 54
		refs = "001a __mmap 002c _IO_setb"
	strings:
		$1 = { 10 B5 82 B0 00 23 04 46 01 93 18 46 4F F4 00 51 4F F0 FF 33 03 22 00 93 22 23 ?? ?? ?? ?? 43 1C 07 D0 01 46 01 23 20 46 01 F5 00 52 ?? ?? ?? ?? 01 20 02 B0 10 BD }
	condition:
		$1
}

rule file_323_22_0 {
	meta:
		name = "_IO_old_init"
		size = 56
	strings:
		$1 = { 82 6C 41 F0 7B 41 00 23 41 F4 2D 01 C3 63 01 60 C3 61 03 62 C3 60 43 60 83 60 03 61 43 61 83 61 43 63 43 62 83 62 C3 62 03 63 A0 F8 44 30 12 B1 13 60 53 60 93 60 70 47 }
	condition:
		$1
}

rule file_323_23_0 {
	meta:
		name = "_IO_init"
		size = 22
		refs = "0004 _IO_old_init"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 4F F0 FF 33 00 22 E3 66 22 66 E3 65 10 BD }
	condition:
		$1
}

rule file_323_24_0 {
	meta:
		name = "_IO_no_init"
		size = 68
		refs = "0008 _IO_old_init"
	strings:
		$1 = { 70 B5 16 46 05 46 1C 46 ?? ?? ?? ?? 00 2E EE 66 12 DB 04 9A 00 23 EC 65 A3 61 E3 61 A3 60 23 60 63 60 E3 60 23 61 63 61 23 62 63 62 A3 62 00 23 C4 F8 B8 20 2B 66 70 BD 4F F0 FF 33 EB 65 00 23 2B 66 70 BD }
	condition:
		$1
}

rule file_323_26_0 {
	meta:
		name = "_IO_default_finish"
		size = 80
		refs = "0022 free 0046 __munmap 0030 _IO_un_link"
	strings:
		$1 = { C2 69 38 B5 04 46 1A B1 03 68 13 F0 01 05 11 D0 23 6B 00 22 1B B1 5A 60 1B 68 00 2B FB D1 60 6A 18 B1 ?? ?? ?? ?? 00 23 63 62 20 46 BD E8 38 40 ?? ?? ?? ?? 03 6A 10 46 9B 1A 03 F6 FF 71 21 F4 7F 61 21 F0 0F 01 ?? ?? ?? ?? 25 62 E5 61 DF E7 }
	condition:
		$1
}

rule file_323_28_0 {
	meta:
		name = "_IO_sputbackc"
		size = 54
	strings:
		$1 = { 43 68 C2 68 10 B5 93 42 04 46 08 D9 13 F8 01 0C CA B2 90 42 04 BF 03 F1 FF 33 63 60 06 D0 D4 F8 98 30 20 46 9B 69 98 47 43 1C 03 D0 23 68 23 F0 10 03 23 60 10 BD }
	condition:
		$1
}

rule file_323_29_0 {
	meta:
		name = "_IO_sungetc"
		size = 48
	strings:
		$1 = { 43 68 C2 68 10 B5 93 42 04 46 08 D9 5A 1E 42 60 13 F8 01 0C 23 68 23 F0 10 03 23 60 10 BD D0 F8 98 30 4F F0 FF 31 9B 69 98 47 43 1C F2 D1 10 BD }
	condition:
		$1
}

rule file_323_30_0 {
	meta:
		name = "_IO_adjust_column"
		size = 58
	strings:
		$1 = { 70 B4 8E 18 B1 42 11 D2 16 F8 01 3C 74 1E 0A 2B 1C BF 01 F1 FF 31 B3 1E 03 D1 0A E0 25 78 0A 2D 07 D0 8B 42 1C 46 03 F1 FF 33 F7 D1 10 44 70 BC 70 47 30 1B 01 38 70 BC 70 47 }
	condition:
		$1
}

rule file_323_31_0 {
	meta:
		name = "_IO_flush_all_lockp"
		size = 512
		refs = "000e _pthread_cleanup_push_defer 001c flush_cleanup 0030 .LANCHOR0 0072 _IO_list_all 0188 _pthread_cleanup_pop_restore 01ae __lll_lock_wait_private 01c2 __libc_do_syscall"
	strings:
		$1 = { 2D E9 F0 4F 06 46 87 B0 00 28 00 F0 C8 80 ?? ?2 0? 0? ?? ?2 0? 0? 00 2B 00 F0 DA 80 ?? ?2 0? 0? 02 A8 ?? ?2 0? 0? 00 22 ?? ?? ?? ?? 01 24 01 94 ?? ?2 0? 0? 1D EE 70 4F ?? ?2 0? 0? A4 F5 98 64 EB 68 A3 42 1E BF 29 1D 01 22 BF F3 5F 8F 0D D0 51 E8 00 3F 00 2B 03 D1 41 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 AF 80 EC 60 AB 68 01 33 AB 60 ?? ?2 0? 0? AF 69 ?? ?2 0? 0? DA F8 00 40 00 2C 00 F0 92 80 4F F0 00 08 1D EE 70 BF C1 46 AB F5 98 6B 2C 60 E6 B1 23 68 1A 04 19 D4 A0 6C 83 68 5B 45 12 D0 01 21 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 12 00 2A F7 D1 BF F3 5F 8F 00 2B 74 D1 A3 6C 18 46 C3 F8 08 B0 43 68 01 33 43 60 E3 6E 00 2B 5D DD E3 6D 1A 69 DB 68 9A 42 0B D9 D4 F8 98 30 20 46 4F F0 FF 31 DB 68 98 47 B0 F1 FF 3F 08 BF 4F F0 FF 38 CE B1 23 68 1B 04 16 D4 A0 6C 43 68 01 3B 43 60 8B B9 83 60 03 68 BF F3 5F 8F 50 E8 00 2F 9A 42 03 D1 40 E8 00 91 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 41 DC AB 69 C5 F8 00 90 9F 42 1A BF 1F 46 DA F8 00 40 64 6B 00 2C A6 D1 DE B1 AA 68 ?? ?2 0? 0? ?? ?2 0? 0? 01 3A AA 60 9A B9 19 1D 10 46 DA 60 6B 68 BF F3 5F 8F 51 E8 00 2F 9A 42 03 D1 41 E8 00 04 00 2C F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 2F DC 01 9C 1C B1 02 A8 00 21 ?? ?? ?? ?? 40 46 07 B0 BD E8 F0 8F 62 69 23 69 9A 42 A2 D8 AD E7 ?? ?2 0? 0? 01 90 ?? ?2 0? 0? 63 E7 A0 46 CB E7 ?? ?? ?? ?? 87 E7 DB F8 08 10 01 22 00 23 4F F0 F0 0C 11 43 ?? ?? ?? ?? B3 E7 08 46 ?? ?? ?? ?? 4C E7 ?? ?2 0? 0? 03 93 ?? ?2 0? 0? 01 93 02 92 27 E7 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? C1 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_32_0 {
	meta:
		name = "_IO_cleanup"
		size = 280
		refs = "0006 _IO_flush_all_lockp 000a _IO_list_all 001e .LANCHOR0 00a6 __sched_yield 0112 __libc_do_syscall"
	strings:
		$1 = { 2D E9 F0 47 00 20 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1C 68 80 46 00 2C 40 D0 1D EE 70 6F ?? ?2 0? 0? A6 F5 98 66 ?? ?2 0? 0? 4F F0 00 09 01 27 23 68 13 F0 02 01 2B D1 41 F2 08 02 1A 40 08 2A 26 D0 E3 6E 23 B3 8A 46 A3 6C 93 B1 9A 68 96 42 2F D0 BF F3 5F 8F 53 E8 00 2F 00 2A 03 D1 43 E8 00 71 00 29 F7 D1 BF F3 5F 8F D2 B9 A3 6C 9E 60 5F 60 2B 7C 13 B9 23 68 DA 07 1E D5 D4 F8 98 30 00 21 0A 46 20 46 DB 6A 98 47 BA F1 02 0F 20 D1 4F F0 FF 33 E3 66 64 6B 00 2C C9 D1 40 46 BD E8 F0 87 0A F1 01 0A ?? ?? ?? ?? BA F1 02 0F E0 D0 CA E7 5A 68 01 32 5A 60 DB E7 E2 69 43 F0 01 03 69 69 20 6A 62 66 23 60 82 1A 21 66 A2 66 6C 61 D4 E7 A0 6C 00 28 DB D0 43 68 01 3B 43 60 00 2B D6 D1 83 60 03 68 BF F3 5F 8F 50 E8 00 2F 9A 42 03 D1 40 E8 00 91 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B C4 DD B1 68 01 22 00 23 4F F0 F0 0C 11 43 ?? ?? ?? ?? BB E7 }
	condition:
		$1
}

rule file_323_34_0 {
	meta:
		name = "_IO_flush_all_linebuffered"
		size = 448
		refs = "0004 _pthread_cleanup_push_defer 0020 flush_cleanup 0030 .LANCHOR0 006c _IO_list_all 016a _pthread_cleanup_pop_restore 0182 __libc_do_syscall 0188 __lll_lock_wait_private"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 85 B0 1B F1 00 0B 18 BF 4F F0 01 0B BB F1 00 0F 00 F0 BB 80 ?? ?2 0? 0? 68 46 ?? ?2 0? 0? 00 22 ?? ?? ?? ?? ?? ?2 0? 0? 1D EE 70 8F ?? ?2 0? 0? A8 F5 98 68 EB 68 43 45 12 D0 29 1D 01 22 BF F3 5F 8F 51 E8 00 3F 00 2B 03 D1 41 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 93 80 C5 F8 0C 80 ?? ?2 0? 0? AA 68 ?? ?2 0? 0? AE 69 01 32 AA 60 D9 F8 00 40 00 2C 52 D0 4F F0 01 0A 00 27 22 E0 23 68 1B 04 16 D4 A0 6C 43 68 01 3B 43 60 8B B9 83 60 03 68 BF F3 5F 8F 50 E8 00 2F 9A 42 03 D1 40 E8 00 71 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 59 DC AB 69 2F 60 9E 42 1A BF 1E 46 D9 F8 00 40 64 6B 54 B3 23 68 2C 60 1A 04 18 D4 A0 6C 83 68 98 45 11 D0 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 A1 00 29 F7 D1 BF F3 5F 8F 00 2B 44 D1 A3 6C 18 46 C3 F8 08 80 43 68 01 33 43 60 23 68 03 F4 02 73 B3 F5 00 7F B9 D1 D4 F8 98 30 20 46 4F F0 FF 31 DB 68 98 47 B1 E7 AA 68 01 3A ?? ?2 0? 0? AA 60 ?? ?2 0? 0? 9A B9 19 1D 10 46 DA 60 6B 68 BF F3 5F 8F 51 E8 00 2F 9A 42 03 D1 41 E8 00 04 00 2C F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 22 DC BB F1 00 0F 03 D0 68 46 00 21 ?? ?? ?? ?? 05 B0 BD E8 F0 8F D8 F8 08 10 01 22 00 23 4F F0 F0 0C 11 43 ?? ?? ?? ?? 9B E7 ?? ?? ?? ?? B7 E7 08 46 ?? ?? ?? ?? 68 E7 ?? ?2 0? 0? CD F8 04 B0 ?? ?2 0? 0? 00 93 44 E7 D8 F8 08 10 01 22 03 48 00 23 11 43 4F F0 F0 0C ?? ?? ?? ?? D1 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_35_0 {
	meta:
		name = "_IO_init_marker"
		size = 46
		refs = "0026 _IO_switch_to_get_mode"
	strings:
		$1 = { 38 B5 05 46 0B 68 0C 46 69 60 1A 05 0A D4 DB 05 62 68 4C BF A3 68 E3 68 D3 1A AB 60 23 6B 2B 60 25 63 38 BD 08 46 ?? ?? ?? ?? 23 68 EF E7 }
	condition:
		$1
}

rule file_323_36_0 {
	meta:
		name = "_IO_remove_marker"
		size = 38
	strings:
		$1 = { 43 68 1A 6B 5A B1 90 42 08 BF 03 F1 30 02 03 D1 06 E0 98 42 04 D0 1A 46 13 68 00 2B F9 D1 70 47 01 68 11 60 70 47 }
	condition:
		$1
}

rule file_323_38_0 {
	meta:
		name = "_IO_marker_delta"
		size = 32
	strings:
		$1 = { 43 68 53 B1 1A 68 80 68 12 F4 80 7F 5A 68 14 BF 9B 68 DB 68 D3 1A C0 1A 70 47 4F F0 FF 30 70 47 }
	condition:
		$1
}

rule file_323_39_0 {
	meta:
		name = "_IO_seekmark"
		size = 94
	strings:
		$1 = { 4B 68 70 B4 83 42 18 BF 4F F0 FF 30 13 D1 8A 68 19 68 00 2A 13 DB CC 05 0F D5 9C 68 21 F4 80 76 DD 6A D8 68 59 6A 1E 60 DC 62 9D 60 58 62 D9 60 00 20 0A 44 5A 60 70 BC 70 47 D9 68 F8 E7 C8 05 0B D4 9C 68 41 F4 80 76 D8 68 D9 6A 5D 6A 1E 60 DC 62 99 60 58 62 DD 60 EA E7 99 68 E8 E7 }
	condition:
		$1
}

rule file_323_40_0 {
	meta:
		name = "_IO_unsave_markers"
		size = 18
		refs = "000c _IO_free_backup_area"
	strings:
		$1 = { 03 6B 0B B1 00 23 03 63 43 6A 0B B1 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_1126_23_0 {
	meta:
		name = "_IO_unsave_wmarkers"
		size = 18
		refs = "000c _IO_free_wbackup_area"
	strings:
		$1 = { 03 6B 0B B1 00 23 03 63 43 6A 0B B1 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_323_41_0 {
	meta:
		name = "_IO_default_pbackfail"
		size = 188
		refs = "0074 malloc 0086 memcpy 008c free"
	strings:
		$1 = { 2D E9 F8 43 04 46 45 68 0E 46 C7 68 BD 42 16 D8 02 68 D3 05 29 D4 60 6A 00 28 40 D0 29 46 E5 6A A3 68 42 F4 80 72 E0 60 22 60 61 62 E3 62 A5 60 6B 1E 63 60 05 F8 01 6C F0 B2 BD E8 F8 83 03 68 DA 05 F5 D4 15 F8 01 3C 8B 42 04 BF 05 F1 FF 35 45 60 F1 D0 43 6A 13 B3 29 46 FE F7 9F FF 48 BB 61 68 22 68 E5 6A 60 6A DA E7 A3 68 C7 EB 03 08 4F EA 48 00 ?? ?? ?? ?? 81 46 D8 B1 00 EB 08 05 39 46 42 46 28 46 ?? ?? ?? ?? E0 68 ?? ?? ?? ?? 05 EB 08 03 A5 62 A3 60 C4 F8 0C 90 C8 E7 80 20 ?? ?? ?? ?? 30 B1 00 F1 80 03 29 46 22 68 1D 46 A3 62 B5 E7 4F F0 FF 30 BD E8 F8 83 }
	condition:
		$1
}

rule file_323_52_0 {
	meta:
		name = "_IO_list_lock"
		size = 72
		refs = "0002 .LANCHOR0 0042 __lll_lock_wait_private"
	strings:
		$1 = { 38 B5 ?? ?2 0? 0? ?? ?2 0? 0? 1D EE 70 5F A5 F5 98 65 E3 68 AB 42 0F D0 23 1D 01 21 BF F3 5F 8F 53 E8 00 2F 00 2A 03 D1 43 E8 00 10 00 28 F7 D1 BF F3 5F 8F 22 B9 E5 60 A3 68 01 33 A3 60 38 BD 18 46 ?? ?? ?? ?? F6 E7 }
	condition:
		$1
}

rule file_323_53_0 {
	meta:
		name = "_IO_list_unlock"
		size = 92
		refs = "0000 .LANCHOR0 0052 __libc_do_syscall"
		altNames = "unlock"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 30 B5 9A 68 01 3A 9A 60 9A B9 10 46 19 1D DA 60 5A 68 BF F3 5F 8F 51 E8 00 4F 94 42 03 D1 41 E8 00 05 00 2D F7 D1 A2 42 BF F3 5F 8F F0 D1 01 2A 00 DC 30 BD 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? F0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_323_54_0 {
	meta:
		name = "_IO_list_resetlock"
		size = 18
		refs = "0000 .LANCHOR0"
	strings:
		$1 = { ?? ?2 0? 0? 00 22 ?? ?2 0? 0? 5A 60 9A 60 DA 60 70 47 }
	condition:
		$1
}

rule file_323_55_0 {
	meta:
		name = "buffer_free"
		size = 52
		refs = "0002 .LANCHOR0 0022 __munmap"
	strings:
		$1 = { 10 B5 ?? ?2 0? 0? ?? ?2 0? 0? 01 23 62 69 23 74 7A B1 91 6E 50 6E 01 F6 FF 71 21 F4 7F 61 21 F0 0F 01 ?? ?? ?? ?? 63 69 1B 6E 1A 46 63 61 00 2B EF D1 10 BD }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "truncate64"
		size = 48
		refs = "0008 __libc_do_syscall 002c __libc_errno"
	strings:
		$1 = { 00 B5 00 21 4F F0 C1 0C ?? ?? ?? ?? 10 F5 80 5F 01 D8 5D F8 04 FB 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "wctomb"
		size = 96
		refs = "0004 __wctomb_state 003a _nl_C_LC_CTYPE 0048 __wcsmbs_load_conv 0050 __wcsmbs_gconv_fcts_c 005c _nl_current_LC_CTYPE 0010 __wcrtomb"
	strings:
		$1 = { 10 B5 38 B1 ?? ?2 0? 0? ?? ?2 0? 0? BD E8 10 40 ?? ?? ?? ?? 11 4B 1D EE 70 2F 7B 44 1B 68 D3 58 1C 68 62 69 4A B1 ?? ?2 0? 0? 00 21 ?? ?2 0? 0? 59 60 92 68 19 60 50 6B 10 BD ?? ?2 0? 0? ?? ?2 0? 0? 9C 42 04 D0 20 46 ?? ?? ?? ?? 62 69 EA E7 ?? ?2 0? 0? ?? ?2 0? 0? E5 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "sigrelse"
		size = 52
		refs = "000c __sigprocmask 0018 sigdelset"
	strings:
		$1 = { 10 B5 A0 B0 04 46 6A 46 02 20 00 21 ?? ?? ?? ?? 00 28 0C DB 21 46 68 46 ?? ?? ?? ?? 00 28 06 DB 69 46 02 20 00 22 ?? ?? ?? ?? 20 B0 10 BD 4F F0 FF 30 FA E7 }
	condition:
		$1
}

rule file_675_0_0 {
	meta:
		name = "sighold"
		size = 52
		refs = "000c __sigprocmask 0018 sigaddset"
	strings:
		$1 = { 10 B5 A0 B0 04 46 6A 46 02 20 00 21 ?? ?? ?? ?? 00 28 0C DB 21 46 68 46 ?? ?? ?? ?? 00 28 06 DB 69 46 02 20 00 22 ?? ?? ?? ?? 20 B0 10 BD 4F F0 FF 30 FA E7 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "l64a"
		size = 66
		refs = "0004 .LANCHOR0 0008 .LANCHOR1 0036 .LC0"
	strings:
		$1 = { 30 B4 C0 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 22 00 F0 3F 01 80 09 ?? ?2 0? 0? 61 5C ?? ?2 0? 0? A9 54 02 F1 01 02 F3 D1 98 54 18 46 30 BC 70 47 ?? ?2 0? 0? ?? ?2 0? 0? 30 BC 70 47 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "rexec_af"
		size = 844
		refs = "0014 .LC0 002c __snprintf 0052 getaddrinfo 0066 .LANCHOR0 0070 free 0078 __strdup 0096 ruserpass 00a2 __socket 00b0 __connect 00ce __close 00d4 __sleep 00e2 perror 00f0 .LC2 0122 __listen 0130 __getsockname 013e __libc_sa_len 015e getnameinfo 0172 .LC5 017c sprintf 0182 strlen 0190 __write 01ac accept 0210 __writev 0236 __read 0246 freeaddrinfo 0292 strtol 02aa .LC6 02cc .LC3 02fe .LC1 0318 .LC4 0338 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F C1 F3 07 24 E5 B0 44 EA 01 21 05 46 90 46 07 92 ?? ?2 0? 0? BD F8 C0 91 ?? ?2 0? 0? 06 93 1F 46 14 A8 8B B2 20 21 00 26 ?? ?? ?? ?? 28 68 14 A9 0C AA 09 AB 0F 96 10 96 02 24 8D F8 6F 60 11 96 12 96 13 96 01 26 CD F8 34 90 0E 96 0C 94 ?? ?? ?? ?? 00 28 40 F0 21 81 09 9B 9B 69 00 2B 00 F0 29 81 ?? ?2 0? 0? ?? ?2 0? 0? 20 68 ?? ?? ?? ?? 09 9B 98 69 ?? ?? ?? ?? 20 60 00 28 00 F0 3D 81 09 9B 07 A9 28 60 06 AA DF F8 B0 A2 B1 46 98 69 06 26 ?? ?? ?? ?? 09 9B 00 22 58 68 99 68 ?? ?? ?? ?? 04 1E 22 DB 09 9B 59 69 1A 69 ?? ?? ?? ?? 1D EE 70 3F 00 28 20 46 21 DA 52 46 7A 44 12 68 9B 58 6F 2B 09 D1 01 3E 07 D0 ?? ?? ?? ?? 48 46 ?? ?? ?? ?? 4F EA 49 09 DD E7 09 9B 98 69 ?? ?? ?? ?? 4F F0 FF 30 65 B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 4F F0 FF 30 F3 E7 6F 9A 00 2A 00 F0 E1 80 09 9B 00 22 58 68 99 68 ?? ?? ?? ?? B0 F1 00 09 C0 F2 07 81 01 21 44 AE ?? ?? ?? ?? 0A AA 31 46 48 46 80 23 0A 93 ?? ?? ?? ?? 00 28 C0 F2 EF 80 BD F8 10 01 ?? ?? ?? ?? 0A 9B 98 42 40 F0 CF 80 00 22 01 46 14 AB 20 20 00 93 13 46 01 90 02 20 02 90 30 46 ?? ?? ?? ?? 01 46 00 28 00 F0 92 80 00 22 05 92 0D F1 70 0B ?? ?2 0? 0? ?? ?2 0? 0? 58 46 ?? ?? ?? ?? 58 46 ?? ?? ?? ?? 59 46 DF F8 B8 A1 42 1C 20 46 ?? ?? ?? ?? 80 23 0B 93 05 E0 53 46 7B 44 1B 68 D3 58 04 2B 7E D1 24 A9 0B AA 48 46 ?? ?? ?? ?? 1D EE 70 2F 41 1C 03 46 EF D0 48 46 04 93 ?? ?? ?? ?? 04 9B 00 2B A4 BF 6F 9A 13 60 6D DB 07 9B DF F8 74 91 18 46 44 93 ?? ?? ?? ?? 06 9B 46 93 42 1C 18 46 45 92 ?? ?? ?? ?? 6E 9B 48 93 43 1C 6E 98 47 93 ?? ?? ?? ?? 01 30 49 90 05 E0 4A 46 7A 44 12 68 9B 58 04 2B 08 D1 20 46 31 46 03 22 ?? ?? ?? ?? 1D EE 70 3F 01 30 F0 D0 07 98 40 45 01 D0 ?? ?? ?? ?? 06 98 B8 42 01 D0 ?? ?? ?? ?? 20 46 59 46 01 22 ?? ?? ?? ?? 01 28 68 D1 9B F8 00 30 53 B9 09 98 ?? ?? ?? ?? 20 46 4D E7 ?? ?? ?? ?? 9B F8 00 30 0A 2B 0A D0 59 46 01 22 20 46 ?? ?? ?? ?? 59 46 03 46 02 20 01 2B 1A 46 EE D0 05 9B 1B B1 6F 9A 10 68 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 09 98 ?? ?? ?? ?? 4F F0 FF 30 2D E7 0A 22 14 A8 ?? ?? ?? ?? 80 B2 05 90 02 46 67 E7 4F F0 FF 30 22 E7 48 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? E1 E7 1F 4A 1D EE 70 1F 2B 60 4F F0 FF 30 7A 44 12 68 8C 50 0E E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? 01 22 ?? ?? ?? ?? 6F 9B 44 AE 0D F1 70 0B 05 93 72 E7 14 4B 1D EE 70 2F 48 46 16 21 7B 44 1B 68 D1 50 ?? ?? ?? ?? BE E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 4F F0 FF 30 EC E6 28 68 ?? ?? ?? ?? AB E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 48 46 ?? ?? ?? ?? A7 E7 20 46 ?? ?? ?? ?? 4F F0 FF 30 D8 E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "__posix_fadvise64_l64"
		size = 28
		refs = "000c __libc_do_syscall"
	strings:
		$1 = { 30 B5 4F F4 87 7C 05 99 03 9C 04 9D ?? ?? ?? ?? 10 F5 80 5F 8C BF 40 42 00 20 30 BD }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "__ctype_get_mb_cur_max"
		size = 24
		refs = "0014 _nl_current_LC_CTYPE"
		altNames = "__aeabi_MB_CUR_MAX"
	strings:
		$1 = { 04 4B 1D EE 70 2F 7B 44 1B 68 D3 58 1B 68 98 6D 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "map_newlink"
		size = 92
	strings:
		$1 = { 00 2B 70 B4 06 46 12 DD 10 68 44 1C 23 D0 B0 42 1F D0 04 32 00 24 06 E0 52 F8 04 5B B5 F1 FF 3F 0C D0 B5 42 07 D0 01 34 10 46 9C 42 F4 D1 4F F0 FF 30 70 BC 70 47 20 46 70 BC 70 47 00 2C 06 60 F9 DD 9C 23 20 46 03 FB 04 11 70 BC 41 F8 9C 1C 70 47 00 20 ED E7 00 20 16 60 EA E7 }
	condition:
		$1
}

rule file_335_1_0 {
	meta:
		name = "getifaddrs_internal"
		size = 1906
		refs = "001e __netlink_open 002e __netlink_request 00c4 __netlink_free_handle 00ce __libc_do_syscall 0148 calloc 017a memset 0298 memcpy 0344 mempcpy 0748 free 074e abort 0752 .LC0 0756 .LC1 075a __PRETTY_FUNCTION__.11284 076e __assert_fail"
	strings:
		$1 = { 2D E9 F0 4F 97 B0 00 AF 00 24 78 62 07 F1 44 00 7D 6A 7C 64 BC 64 2C 60 FC 64 3C 65 7C 65 ?? ?? ?? ?? A0 42 C0 F2 8A 83 07 F1 44 00 12 21 ?? ?? ?? ?? A0 42 77 DB FB 6C 07 F1 44 00 16 21 01 33 FB 64 ?? ?? ?? ?? 00 28 6D DB D7 F8 50 B0 BB F1 00 0F 6F D0 A4 46 D7 F8 48 E0 A0 46 5E 46 65 46 3C 63 73 68 B2 68 23 B3 0F 2A 22 D9 19 68 0F 29 1F D9 8A 42 0C D2 1C E0 03 31 21 F0 03 01 52 1A 0B 44 0F 2A 15 D9 19 68 0F 29 12 D9 91 42 10 D8 D8 68 70 45 F0 D1 9C 68 F0 68 84 42 EC D1 98 88 03 28 06 D0 10 28 19 D0 14 28 08 BF 08 F1 01 08 E2 E7 36 68 00 2E D4 D1 3D 63 15 EB 08 05 3B D1 07 F1 44 00 ?? ?? ?? ?? 78 6C 4F F0 06 0C ?? ?? ?? ?? 30 46 5C 37 BD 46 BD E8 F0 8F A1 F1 20 00 03 F1 20 09 03 28 1C D9 1C 8C 03 2C 19 D9 A0 42 17 D3 B3 F8 22 A0 BA F1 07 0F 0B D1 16 E0 B9 F8 00 40 03 2C 0D D9 84 42 0B D8 B9 F8 02 A0 BA F1 07 0F 0B D0 03 34 24 F0 03 04 00 1B A1 44 03 28 ED D8 01 35 A8 E7 4F F0 FF 36 C9 E7 04 3C 01 35 A4 44 A1 E7 5E 46 C3 E7 9C 24 01 20 04 FB 05 F5 AC 44 C7 F8 08 C0 61 46 ?? ?? ?? ?? F8 62 00 28 E9 D0 38 6B FF 21 BE 61 B2 46 D9 46 80 00 78 60 00 F1 0E 03 02 46 23 F0 07 03 AD EB 03 0D FB 6A 68 46 C7 F8 14 D0 2B 44 3B 61 ?? ?? ?? ?? D9 F8 04 80 D9 F8 08 B0 B8 F1 00 0F 00 F0 7C 81 BB F1 0F 0F 40 F2 78 81 D8 F8 00 50 0F 2D 40 F2 73 81 AB 45 C0 F0 70 81 4E 46 13 E0 D8 F8 00 30 03 33 23 F0 03 03 C3 EB 0B 0B 98 44 BB F1 0F 0F 40 F2 61 81 D8 F8 00 50 0F 2D 40 F2 5C 81 5D 45 00 F2 59 81 D8 F8 0C 20 BB 6C 9A 42 E6 D1 D8 F8 08 20 F3 68 9A 42 E1 D1 B8 F8 04 30 03 2B 00 F0 4A 81 10 2B 00 F0 BF 81 14 2B D7 D1 D8 F8 14 00 18 3D F9 6A 08 F1 18 04 7A 69 01 38 3B 6B FF F7 5A FD BB 69 39 6B 0B 44 42 1C 00 F0 93 82 FA 6A 9C 21 00 2B 01 FB 00 20 01 FB 03 29 82 68 C8 BF 49 F8 9C 9C 03 2D C9 F8 08 20 BA 69 02 F1 01 02 BA 61 3D D9 B8 F8 18 30 03 2B 39 D9 9D 42 37 D3 C7 F8 20 B0 C3 46 09 F1 88 00 09 F1 66 01 B8 63 09 F1 6C 02 09 F1 64 00 F9 60 BA 62 F8 63 FE 61 62 88 04 F1 04 08 A3 F1 04 0C 01 3A 03 2A 0E D8 DF E8 12 F0 C6 00 66 00 57 00 2D 01 BC F1 24 0F 05 D8 41 46 62 46 09 F1 1E 00 ?? ?? ?? ?? 23 88 03 33 23 F0 03 03 ED 1A 1C 44 03 2D 04 D9 23 88 03 2B 01 D9 AB 42 DB D9 D8 46 FE 69 D7 F8 20 B0 D9 F8 04 30 00 2B 00 F0 28 82 D9 F8 0C 30 00 2B 3F F4 6C AF 1A 88 00 2A 3F F4 68 AF 11 2A 3F F4 65 AF 02 2A 09 F1 40 03 C9 F8 10 30 00 F0 11 82 0A 2A 40 F0 0B 82 09 F1 48 03 80 21 A9 F8 40 20 98 F8 11 20 91 42 28 BF 11 46 CA 08 08 BF 1A 46 06 D0 1A 44 4F F0 FF 35 03 F8 01 5B 93 42 F9 D1 01 F0 07 03 FF 20 C3 F1 08 03 00 FA 03 F3 13 70 3C E7 03 3B 11 2B 00 F2 0B 82 B9 6B 62 46 B8 6B C9 F8 04 10 41 46 ?? ?? ?? ?? 80 F8 00 A0 A6 E7 D9 F8 0C 30 00 2B 00 F0 D0 81 09 F1 1C 0E C7 F8 34 E0 09 F1 64 06 BE E8 0F 00 0F C6 BE E8 0F 00 DE F8 00 E0 0F C6 FA 6B C6 F8 00 E0 C9 F8 1C A0 C9 F8 14 20 C9 F8 20 A0 C9 F8 24 A0 C9 F8 28 A0 C9 F8 2C A0 C9 F8 30 A0 C9 F8 34 A0 C9 F8 38 A0 C9 F8 3C A0 7B 6B C9 F8 0C 30 9B F8 10 30 A9 F8 1C 30 9B F8 10 30 02 2B 00 F0 90 81 0A 2B 7F F4 65 AF BC F1 10 0F 7F F4 6A AF D8 F8 00 00 09 F1 24 06 D8 F8 0C 30 4C F2 FF 0E D8 F8 04 10 D8 F8 08 20 0F C6 48 F2 FE 00 63 68 03 EA 0E 0E 86 45 09 D0 23 79 FF 2B 7F F4 52 AF 63 79 03 F0 0F 03 02 2B 7F F4 4C AF DB F8 14 30 C9 F8 34 30 46 E7 D9 F8 0C 30 00 2B 00 F0 74 81 FA 6B 16 46 C9 F8 14 20 9B F8 10 30 33 80 9B F8 10 30 02 2B 00 F0 5D 81 0A 2B 40 F0 48 81 BC F1 10 0F 7F F4 2F AF D8 F8 0C 30 06 F1 08 0E D8 F8 00 00 4C F2 FF 0C D8 F8 04 10 D8 F8 08 20 AE E8 0F 00 63 68 03 EA 0C 0C 48 F2 FE 03 9C 45 09 D0 23 79 FF 2B 7F F4 16 AF 63 79 03 F0 0F 03 02 2B 7F F4 10 AF DB F8 14 30 B3 61 0B E7 B1 46 D9 F8 00 90 B9 F1 00 0F 7F F4 76 AE BD 68 FB 6A 2B 44 3D 69 9D 42 00 F2 59 81 BD 69 B5 B1 3D 6B A5 B1 F9 6A 9C 24 7B 69 4A 46 78 68 04 FB 05 14 18 44 0D 46 53 F8 04 1B 01 31 08 BF A9 18 02 F1 9C 02 08 BF 41 F8 9C 4C 83 42 F3 D1 FD 6A 00 26 78 6A 05 60 F1 E5 D9 F8 14 30 9B B1 F9 6B BA 6A C1 F8 00 A0 C9 F8 68 A0 C2 F8 00 A0 C9 F8 70 A0 C9 F8 74 A0 C9 F8 78 A0 C9 F8 7C A0 C9 F8 80 A0 C9 F8 84 A0 FB 6B C9 F8 14 30 9B F8 10 30 A9 F8 64 30 9B F8 10 30 02 2B 00 F0 CA 80 0A 2B 40 F0 BD 80 BC F1 10 0F 7F F4 B6 AE D8 F8 00 00 4C F2 FF 0E D8 F8 0C 30 BE 6A D8 F8 04 10 D8 F8 08 20 0F C6 48 F2 FE 00 63 68 03 EA 0E 0E 86 45 09 D0 23 79 FF 2B 7F F4 9F AE 63 79 03 F0 0F 03 02 2B 7F F4 99 AE DB F8 14 30 C9 F8 7C 30 93 E6 D8 F8 14 00 20 3D F9 6A 08 F1 20 04 7A 69 01 38 3B 6B FF F7 9D FB 41 1C 00 F0 D9 80 F9 6A 9C 22 03 2D 02 FB 00 13 D8 F8 18 20 9A 60 7F F6 03 AE B8 F8 20 20 03 2A 7F F6 FE AD 95 42 FF F4 FB AD 7E 63 99 46 3E 69 03 F1 88 00 03 F1 70 01 F8 63 B9 62 03 F1 64 00 03 F1 28 01 38 62 F9 61 C7 F8 38 B0 60 88 21 1D A2 F1 04 0B 01 38 06 28 1E D8 DF E8 00 F0 04 3C 2F 1D 1D 1D 55 00 BB F1 24 0F 15 D8 4F F0 11 00 5A 46 A9 F8 1C 00 F8 69 ?? ?? ?? ?? 89 F8 27 B0 D8 F8 14 20 09 F1 1C 01 C9 F8 20 20 B8 F8 12 20 C9 F8 0C 10 A9 F8 24 20 22 88 03 32 22 F0 03 02 AD 1A 14 44 03 2D 04 D9 22 88 03 2A 01 D9 AA 42 CC D9 3E 61 D7 F8 38 B0 7E 6B B1 E5 03 3A 11 2A EA D8 FB 6B 5A 46 18 46 C9 F8 04 30 ?? ?? ?? ?? 80 F8 00 A0 E0 E7 BB F1 24 0F DD D8 4F F0 11 02 B8 6A A9 F8 64 20 5A 46 ?? ?? ?? ?? 89 F8 6F B0 D8 F8 14 20 3B 6A C9 F8 68 20 B8 F8 12 20 C9 F8 14 30 A9 F8 6C 20 C7 E7 C9 F8 18 60 30 46 5A 46 5E 44 ?? ?? ?? ?? BF E7 BC F1 24 0F 3F F6 F9 AD 41 46 62 46 F8 68 ?? ?? ?? ?? F2 E5 BC F1 04 0F 04 BF D8 F8 00 00 C9 F8 68 00 EA E5 BC F1 24 0F 3F F6 E7 AD B0 1C 41 46 62 46 ?? ?? ?? ?? E0 E5 BC F1 04 0F 04 BF D8 F8 00 00 C9 F8 20 00 D8 E5 BC F1 04 0F 04 BF D8 F8 00 00 70 60 D1 E5 09 F1 1C 00 78 63 50 E6 09 F1 1C 06 C9 F8 0C 60 8A E6 A9 F8 40 20 4C E5 09 F1 44 03 20 21 F0 E5 D8 F8 14 00 3B 6B F9 6A 01 38 7A 69 FF F7 CE FA 43 1C 0A D0 FD 6A 9C 21 01 FB 00 50 43 68 C9 F8 04 30 C5 E5 4F F0 FF 30 C8 E4 F8 6A 6F F0 0A 06 ?? ?? ?? ?? B8 E4 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 1A 32 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_2_0 {
	meta:
		name = "__netlink_free_handle"
		size = 52
		refs = "0018 free 002c __libc_errno"
	strings:
		$1 = { 0A 4B 70 B5 1D EE 70 5F 7B 44 1B 68 C0 68 EE 58 08 B9 05 E0 20 46 04 68 ?? ?? ?? ?? 00 2C F9 D1 03 4B 7B 44 1B 68 EE 50 70 BD 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_3_0 {
	meta:
		name = "__netlink_request"
		size = 564
		refs = "000c __getpagesize 0092 __sendto 00dc __recvmsg 0172 free 0198 malloc 01aa memcpy 01d2 time 0208 __libc_alloca_cutoff 0224 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 93 B0 02 AF 05 46 88 46 ?? ?? ?? ?? B0 F5 80 5F 04 46 00 F2 F7 80 04 F1 0E 03 00 20 23 F0 07 03 B8 60 AD EB 03 0D 02 AA FA 60 FA 68 A8 68 7C 61 3A 61 00 28 00 F0 CB 80 07 F1 40 0B 00 23 F8 62 14 21 10 20 BB 61 FB 61 40 F2 01 32 3B 62 0C 24 73 4E A7 F8 28 80 3B 63 87 F8 34 30 87 F8 35 30 87 F8 36 30 87 F8 37 30 2B F8 28 0D 79 62 7A 85 05 E0 32 46 7A 44 12 68 9B 58 04 2B 6E D1 28 68 07 F1 24 01 00 23 CD F8 00 B0 14 22 01 94 ?? ?? ?? ?? 1D EE 70 3F 41 1C EB D0 00 28 5E DB 61 4E 4F F0 00 0A 0C 23 07 F1 10 00 01 22 C7 F8 24 B0 BB 62 F8 62 3A 63 C7 F8 34 A0 C7 F8 38 A0 C7 F8 3C A0 05 E0 32 46 7A 44 12 68 9B 58 04 2B 45 D1 00 22 28 68 07 F1 24 01 ?? ?? ?? ?? 1D EE 70 3F 42 1C EF D0 00 28 80 46 38 DB FB 69 00 2B D9 D1 FB 6B 13 F0 20 09 31 D1 0F 28 D3 D9 FB 68 19 68 0F 29 CF D9 88 42 CD D3 D5 F8 04 C0 04 46 7D 60 07 E0 0F 2C 13 44 2D D9 19 68 0F 29 2A D9 A1 42 28 D8 D8 68 CA 1C 22 F0 03 02 84 45 C2 EB 04 04 EF D1 7D 68 98 68 AD 68 A8 42 EA D1 98 88 09 F1 01 09 03 28 4F D0 02 28 E3 D1 23 29 51 D8 36 4B 1D EE 70 2F 05 21 7B 44 1B 68 D1 50 BD 68 2D B9 4F F0 FF 30 44 37 BD 46 BD E8 F0 8F F8 68 ?? ?? ?? ?? F5 E7 7D 68 00 24 B9 F1 00 0F 08 D1 00 2C 90 D0 BD 68 5D BB 00 20 44 37 BD 46 BD E8 F0 8F 08 F1 10 00 ?? ?? ?? ?? 81 46 00 28 DE D0 42 46 F9 68 40 F8 10 AB ?? ?? ?? ?? AB 68 EA 68 C9 F8 08 80 C9 F8 0C 30 C9 F8 04 00 6A B1 2B 69 C3 F8 00 90 C5 F8 10 90 00 2C 3F F4 6C AF D9 E7 ?? ?? ?? ?? 03 46 AB 60 2F E7 C5 F8 0C 90 F1 E7 F8 68 ?? ?? ?? ?? CF E7 7D 68 01 24 B9 F1 00 0F C6 D0 CE E7 0E 4A 1D EE 70 0F 19 69 7A 44 12 68 49 42 81 50 AB E7 ?? ?? ?? ?? 00 28 7F F4 04 AF 20 46 ?? ?? ?? ?? F8 60 00 28 A2 D0 01 20 B8 60 04 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_4_0 {
	meta:
		name = "__netlink_close"
		size = 16
		refs = "0008 __libc_do_syscall"
	strings:
		$1 = { 00 B5 4F F0 06 0C 00 68 ?? ?? ?? ?? 5D F8 04 FB }
	condition:
		$1
}

rule file_335_5_0 {
	meta:
		name = "__netlink_open"
		size = 102
		refs = "000c __socket 0028 __bind 003e __getsockname 0056 __libc_do_syscall"
	strings:
		$1 = { 30 B5 03 21 05 46 85 B0 10 20 00 22 ?? ?? ?? ?? 00 28 28 60 24 DB 0C 22 01 A9 00 24 10 23 01 94 02 94 03 94 AD F8 04 30 ?? ?? ?? ?? A0 42 0F DB 04 AA 0C 23 01 A9 28 68 42 F8 10 3D 6A 46 ?? ?? ?? ?? 00 28 04 DB 02 9B 20 46 6B 60 05 B0 30 BD 28 68 4F F0 06 0C ?? ?? ?? ?? 4F F0 FF 30 F5 E7 4F F0 FF 30 F2 E7 }
	condition:
		$1
}

rule file_335_6_0 {
	meta:
		name = "getifaddrs"
		size = 18
	strings:
		$1 = { 10 B5 04 46 20 46 FF F7 41 FC 10 F1 0B 0F F9 D0 10 BD }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "putwchar"
		size = 300
		refs = "0002 _IO_stdout 00bc __libc_do_syscall 00c4 __woverflow 00ce __lll_lock_wait_private 0128 _Unwind_Resume"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? ?? ?2 0? 0? 06 46 2C 68 23 68 19 04 1E D4 A3 6C 1D EE 70 7F A7 F5 98 67 9A 68 BA 42 3F D0 01 21 BF F3 5F 8F 53 E8 00 2F 00 2A 03 D1 43 E8 00 10 00 28 F7 D1 BF F3 5F 8F 00 2A 44 D1 A2 6C 28 68 13 46 97 60 5A 68 01 32 5A 60 00 E0 20 46 C3 6D 00 2B 33 D0 1A 69 59 69 8A 42 3E BF 11 1D 19 61 16 60 2B D2 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 03 DC 30 46 F8 BD 20 46 D0 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EE E7 31 46 ?? ?? ?? ?? 06 46 CE E7 18 46 ?? ?? ?? ?? B6 E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "futimesat"
		size = 264
		refs = "0004 __have_atfcts 0024 __libc_do_syscall 0048 strlen 0054 procfd.10294 0070 __snprintf 008e __atfct_seterrno 009e __futimes 00a6 procfd.10291 00fc __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 83 B0 ?? ?2 0? 0? 80 46 02 AF 0D 46 26 68 91 46 00 2E 0C DB 00 29 3D D0 4F F4 A3 7C ?? ?? ?? ?? 10 F5 80 5F 47 D8 04 37 BD 46 BD E8 F0 83 00 29 34 D0 18 F1 64 0F 2B D0 2B 78 2F 2B 28 D0 28 46 ?? ?? ?? ?? 00 28 4A D0 00 F1 2E 03 ?? ?2 0? 0? 23 F0 07 03 00 F1 20 01 AD EB 03 0D ?? ?2 0? 0? 02 AC 43 46 00 95 20 46 ?? ?? ?? ?? 25 46 28 46 49 46 40 F2 0D 1C ?? ?? ?? ?? 10 F5 80 5F D2 D9 40 42 41 46 22 46 ?? ?? ?? ?? 4F F0 FF 30 CA E7 00 24 EC E7 11 46 ?? ?? ?? ?? C4 E7 8A B0 ?? ?2 0? 0? 02 AD ?? ?2 0? 0? 28 46 1D 21 43 46 2C 46 ?? ?? ?? ?? DB E7 0F 4A 1D EE 70 1F 0E 4B 40 42 7A 44 12 68 88 50 7B 44 1B 68 CB 58 26 2B 02 D0 4F F0 FF 30 A7 E7 4F F0 FF 33 23 60 A9 E7 07 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 D1 50 99 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "__lxstat"
		size = 112
		refs = "0012 __libc_do_syscall 004a __xstat32_conv 0068 __libc_errno"
	strings:
		$1 = { 10 B5 04 46 01 2C 9A B0 08 46 0A D0 69 46 4F F0 C4 0C ?? ?? ?? ?? 10 F5 80 5F 1A D8 98 B1 1A B0 10 BD 11 46 4F F0 6B 0C ?? ?? ?? ?? 10 F5 80 5F F5 D9 0D 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 EB E7 20 46 69 46 ?? ?? ?? ?? 1A B0 10 BD 06 4A 1D EE 70 1F 43 42 4F F0 FF 30 7A 44 12 68 8B 50 DB E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "do_sigpause"
		size = 66
		refs = "001a __sigsuspend 0028 __sigprocmask 0034 sigdelset"
	strings:
		$1 = { 30 B5 05 46 A1 B0 61 B9 0A 46 01 AB 00 90 20 A9 43 F8 04 2B 8B 42 FA D1 68 46 ?? ?? ?? ?? 21 B0 30 BD 00 20 6A 46 01 46 ?? ?? ?? ?? 00 28 05 DB 29 46 68 46 ?? ?? ?? ?? 00 28 ED DA 4F F0 FF 30 ED E7 }
	condition:
		$1
}

rule file_341_1_0 {
	meta:
		name = "__sigpause"
		size = 50
		refs = "0000 __libc_multiple_threads 0018 __libc_enable_asynccancel 002a __libc_disable_asynccancel"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 70 B5 05 46 1B 68 0C 46 13 B9 BD E8 70 40 D1 E7 ?? ?? ?? ?? 21 46 06 46 28 46 FF F7 CB FF 04 46 30 46 ?? ?? ?? ?? 20 46 70 BD }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "_nl_explode_name"
		size = 354
		refs = "0112 _nl_normalize_codeset 0122 strcmp 0134 __rawmemchr 014e free"
	strings:
		$1 = { 2D E9 F8 4F 00 24 0A 9E 91 46 14 60 9A 46 0B 9A 1C 60 34 60 14 60 08 60 03 78 13 F0 BF 0F 0C BF 00 22 01 22 5F 2B 0C BF 00 22 02 F0 01 02 00 2A 7E D0 2E 2B 7C D0 45 1C 03 E0 40 29 29 D0 2E 29 4E D0 2C 46 01 35 21 78 5F 29 18 BF 00 29 0C BF 00 27 01 27 F1 D1 A0 42 23 46 69 D0 40 29 1B D0 5F 29 25 D0 2E 29 3E D0 40 29 15 D0 DA F8 00 30 0B B1 1B 78 53 B1 33 68 2B B1 1B 78 1B B9 27 F0 02 00 BD E8 F8 8F 38 46 BD E8 F8 8F 27 F0 04 07 F1 E7 A0 42 4C D0 00 27 23 46 00 22 03 F8 01 2B C9 F8 00 30 63 78 00 2B E0 D0 47 F0 08 07 DD E7 27 70 2C 46 CA F8 00 50 59 78 00 29 18 BF 2E 29 0C D0 40 29 3B D0 98 1C 01 E0 40 29 37 D0 04 46 10 F8 01 1B 2E 29 18 BF 00 29 F6 D1 04 27 C1 E7 A0 42 25 D0 00 27 20 46 00 23 00 F8 01 3B 30 60 61 78 11 F0 BF 0F 24 D0 05 46 00 E0 25 46 69 78 6C 1C 11 F0 BF 0F F9 D1 A0 42 47 F0 02 0B 22 D0 21 1A ?? ?? ?? ?? 0B 9A 80 46 10 60 E8 B1 30 68 41 46 ?? ?? ?? ?? 80 B1 47 F0 03 07 69 78 9B E7 00 21 00 27 ?? ?? ?? ?? 04 46 01 78 94 E7 04 27 AA E7 47 F0 02 07 04 46 8E E7 40 46 5F 46 ?? ?? ?? ?? 69 78 88 E7 5F 46 86 E7 4F F0 FF 30 BD E8 F8 8F }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "fseeko"
		size = 284
		refs = "0056 _IO_seekoff_unlocked 00b8 __libc_do_syscall 00be __lll_lock_wait_private 0118 _Unwind_Resume"
		altNames = "fseek"
	strings:
		$1 = { 03 68 F0 B5 0D 46 19 04 83 B0 04 46 16 46 1C D4 80 6C 1D EE 70 7F A7 F5 98 67 83 68 BB 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 3F D1 A3 6C 18 46 9F 60 43 68 01 33 43 60 03 23 00 96 01 93 20 46 2A 46 EB 17 ?? ?? ?? ?? 23 68 01 40 B1 F1 FF 3F 14 BF 00 25 6F F0 00 05 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 02 DC 28 46 03 B0 F0 BD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? BC E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "_dl_discover_osversion"
		size = 168
		refs = "0006 __uname 006c .LC0 0076 __open 0082 __read 008a __close"
	strings:
		$1 = { 70 B5 F2 B0 10 A8 ?? ?? ?? ?? 0D F1 C2 01 68 BB 00 26 30 46 0A 78 30 3A D3 B2 09 2B 20 D8 4B 78 4D 1C A3 F1 30 04 09 2C 0C D8 02 31 02 EB 82 02 0D 46 03 EB 42 02 11 F8 01 3B 30 3A A3 F1 30 04 09 2C F3 D9 2E 2B 06 F1 01 06 42 EA 00 20 05 F1 01 01 03 D1 03 2E DD D1 72 B0 70 BD 03 2E FB D0 C6 F1 03 06 F6 00 B0 40 72 B0 70 BD ?? ?2 0? 0? 00 21 ?? ?2 0? 0? ?? ?? ?? ?? 05 1E 11 DB 40 22 69 46 ?? ?? ?? ?? 04 46 28 46 ?? ?? ?? ?? 00 2C 07 DD 3F 2C A8 BF 3F 24 00 23 69 46 0D F8 04 30 B6 E7 4F F0 FF 30 D7 E7 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__gconv_open"
		size = 1422
		refs = "0012 strchr 0078 strlen 0092 mempcpy 0096 .LC2 00cc __gconv_find_transform 00ec __gconv_translit_find 010c malloc 0126 memset 015c _nl_C_locobj 0172 __strcasecmp_l 027c __gconv_close_transform 02ca free 02ec _nl_current_LC_CTYPE 02f4 __libc_errno 0324 memcpy 0380 __gconv_transliterate 0384 .LANCHOR0 039e .LC0 0468 .LC1"
	strings:
		$1 = { 2D E9 F0 4F 8B B0 02 AF 88 46 2F 21 87 E8 0C 00 81 46 ?? ?? ?? ?? 00 28 00 F0 6B 82 01 30 2F 21 ?? ?? ?? ?? 00 28 00 F0 64 82 46 78 00 2E 40 F0 67 81 BE 60 40 46 2F 21 ?? ?? ?? ?? 40 B1 01 30 2F 21 ?? ?? ?? ?? 18 B1 43 78 00 2B 40 F0 F6 81 99 F8 00 30 2F 2B 26 D1 99 F8 01 30 2F 2B 22 D1 99 F8 02 30 FB B9 A1 4B 1D EE 70 2F 7B 44 1B 68 D3 58 1B 68 DC 6D 20 46 ?? ?? ?? ?? 21 46 00 F1 11 03 02 46 23 F0 07 03 AD EB 03 0D 0D F1 08 09 48 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1A 88 9B 78 02 80 83 70 98 F8 00 30 2F 2B 04 D1 98 F8 01 30 2F 2B 00 F0 B1 80 7B 68 48 46 41 46 07 F1 14 02 4F F0 00 0B 00 93 07 F1 18 03 ?? ?? ?? ?? 81 46 00 28 40 F0 99 80 00 2E 00 F0 23 82 04 46 35 46 00 E0 1E 46 33 68 30 46 23 B1 ?? ?? ?? ?? 00 28 40 F0 42 82 73 68 34 46 00 2B F2 D1 AA 46 BC 69 04 EB C4 05 AD 00 05 F1 08 00 ?? ?? ?? ?? 83 46 00 28 00 F0 A7 80 7B 69 2A 46 00 21 CB F8 04 30 40 F8 08 4B ?? ?? ?? ?? BB 69 00 2B 6C D0 00 24 0B F1 20 05 A0 46 C7 F8 04 90 45 F8 04 5C BA F1 00 0F 3D D0 56 46 F3 68 00 2B 36 D0 4F F0 00 09 02 E0 F3 68 4B 45 30 D9 79 69 ?? ?2 0? 0? B3 68 ?? ?2 0? 0? 08 19 53 F8 29 10 09 F1 01 09 C0 68 ?? ?? ?? ?? 00 28 EC D1 B3 69 F8 61 33 B1 7A 69 07 F1 1C 00 22 44 11 69 98 47 B0 B9 14 20 ?? ?? ?? ?? 00 28 7E D0 72 69 F3 69 31 69 80 E8 0E 00 00 22 FB 69 02 61 C3 60 AA 68 0A B9 6F E0 1A 46 13 69 00 2B FB D1 10 32 10 60 76 68 00 2E C2 D1 BE 69 73 1E 43 45 40 F2 C9 81 7B 69 BA 68 23 44 45 F8 10 2C 1B 6B C3 EB 03 23 4F EA 43 19 48 46 ?? ?? ?? ?? 45 F8 18 0C 00 28 53 D0 08 F1 01 08 00 EB 09 03 46 45 45 F8 14 3C 04 F1 3C 04 05 F1 24 05 9A D8 D7 F8 04 90 3A 68 48 46 24 37 C2 F8 00 B0 BD 46 BD E8 F0 8F 98 F8 02 30 00 2B 7F F4 4A AF 32 4B 1D EE 70 2F 7B 44 1B 68 D3 58 1B 68 DC 6D 20 46 ?? ?? ?? ?? 21 46 00 F1 11 03 02 46 23 F0 07 03 AD EB 03 0D 0D F1 08 08 40 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1A 88 9B 78 02 80 83 70 28 E7 23 4B 1D EE 70 5F 21 46 7B 44 1B 68 55 F8 03 A0 78 69 4F F0 03 09 ?? ?? ?? ?? 1D 4B 4F F0 00 0B 7B 44 1B 68 45 F8 03 A0 BC E7 05 F1 08 02 91 E7 19 4B 1D EE 70 5F 7B 44 1B 68 55 F8 03 A0 B8 F1 00 0F 1A D0 08 EB C8 09 0B EB 89 09 09 F1 08 09 59 F8 04 4C 54 B1 A3 68 26 69 00 2B 40 F0 35 81 20 46 34 46 ?? ?? ?? ?? 00 2E F4 D1 59 F8 24 0D ?? ?? ?? ?? B8 F1 01 08 EA D1 58 46 ?? ?? ?? ?? B9 69 C5 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 44 1C 49 46 C9 EB 04 09 00 23 09 F1 0F 00 4A 46 20 F0 07 00 AD EB 00 0D 0D F1 0F 00 C0 08 09 F8 30 30 C0 00 ?? ?? ?? ?? 81 46 20 46 ?? ?? ?? ?? 21 46 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 02 A8 ?? ?? ?? ?? 06 78 05 46 2C 2E 05 D1 43 1C 1D 46 13 F8 01 6B 2C 2E FA D0 6A 1C 00 2E 3F F4 68 AE 14 46 01 32 23 78 3B B1 2C 2B 00 F0 DC 80 14 46 01 32 23 78 00 2B F7 D1 00 2D 00 F0 FA 80 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? FB 60 5B 46 A2 46 AB 46 1D 46 00 26 BE 60 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 58 46 ?? ?? ?? ?? 00 28 57 D1 00 2E 00 F0 9D 80 33 69 AB 42 1E D0 33 46 03 E0 11 69 13 46 A9 42 18 D0 5A 68 00 2A F8 D1 8A B0 01 24 02 A8 01 46 41 F8 04 2B 08 31 03 92 41 F8 04 2B 41 F8 04 2B 41 F8 04 2B 41 F8 04 2B 0A 60 FA 68 06 95 05 94 04 92 58 60 9A F8 00 20 2C 2A 65 D1 0A F1 01 03 9B 46 13 F8 01 2B 2C 2A FA D0 00 2A 3F F4 0B AE 0B F1 01 02 01 E0 2C 2B 58 D0 92 46 01 32 9A F8 00 30 00 2B F7 D1 BB F1 00 0F B1 D1 FB E5 01 30 41 46 C8 EB 00 08 00 23 08 F1 0F 00 42 46 20 F0 07 00 AD EB 00 0D 0D F1 0F 00 C0 08 08 F8 30 30 C0 00 ?? ?? ?? ?? 80 46 F3 E5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 58 46 ?? ?? ?? ?? 00 28 34 D0 00 2E 57 D0 34 46 00 E0 1C 46 23 68 ?? ?2 0? 0? 58 46 ?? ?2 0? 0? 19 46 1B B1 ?? ?? ?? ?? 00 28 AE D0 63 68 00 2B EF D1 8A B0 04 AA 02 A9 03 93 42 F8 04 3B 42 F8 04 3B 42 F8 04 3B 42 F8 04 3B 42 F8 04 3B 13 60 CD F8 08 B0 61 60 9A F8 00 20 2C 2A 99 D0 D3 46 9E E7 00 23 8A F8 00 30 92 46 BB F1 00 0F 7F F4 5A AF A3 E5 02 22 BA 60 87 E7 06 46 B8 60 9D E5 8A B0 01 22 02 AE 33 46 43 F8 04 0B 08 33 70 60 43 F8 04 0B 43 F8 04 0B 43 F8 04 0B 43 F8 04 0B 18 60 FB 68 35 61 F2 60 B3 60 6E E7 82 46 EB E5 00 23 23 70 14 46 24 E7 E0 68 98 47 C7 E6 8A B0 00 22 02 AE 06 F1 08 03 72 60 43 F8 04 2B 43 F8 04 2B 43 F8 04 2B 43 F8 04 2B 43 F8 04 2B 1A 60 C6 F8 00 B0 51 E7 BB 68 08 EB C8 08 D7 F8 04 90 43 F0 01 02 0B EB 88 03 1A 61 4A E6 2E 46 BD 60 5C E5 24 B1 73 68 63 60 73 68 26 46 B8 E5 75 68 26 46 2B 46 B4 E5 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "setup_aeabi_stdio"
		size = 66
		refs = "0000 stdin 0004 stdout 0008 stderr 001c __aeabi_stderr 0022 __aeabi_stdin 0028 __aeabi_stdout"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 30 B4 18 68 ?? ?2 0? 0? 0D 68 ?? ?2 0? 0? 14 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0D 60 14 60 18 60 30 BC 70 47 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "atexit"
		size = 22
		refs = "0000 __dso_handle 000e __cxa_atexit"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 1B B1 1A 68 00 21 ?? ?? ?? ?? 1A 46 FA E7 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "utime"
		size = 30
		refs = "0016 __utimes"
	strings:
		$1 = { 10 B5 84 B0 39 B1 0C 68 00 23 4A 68 69 46 01 93 00 94 02 92 03 93 ?? ?? ?? ?? 04 B0 10 BD }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "strchr"
		size = 168
	strings:
		$1 = { 02 78 C9 B2 00 F0 07 03 C3 F1 0F 03 8A 42 18 BF 00 2A 45 D0 10 F8 01 2F 01 3B 18 BF 8A 42 18 BF 00 2A F7 D1 8A 42 18 BF 00 2A 39 D0 00 F1 01 00 F0 B4 F0 E8 02 23 41 EA 01 21 40 F2 01 1C 90 F8 40 F0 C0 F2 01 1C 41 EA 01 41 CC FA 52 F4 82 EA 01 06 CC FA 53 F5 83 EA 01 07 CC FA 56 F6 90 F8 80 F0 CC FA 57 F7 44 EA 06 04 45 EA 07 05 54 EA 05 06 08 BF F0 E8 02 23 E7 D0 00 2C A0 F1 04 00 06 BF 2C 46 1A 46 04 38 24 BA B4 FA 84 F3 A3 F1 07 03 22 FA 03 F2 C9 B2 D2 B2 00 EB D3 00 F0 BC 8A 42 18 BF 00 20 70 47 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "mbrtoc16"
		size = 424
		refs = "0004 .LANCHOR0 0068 _dl_mcount_wrapper_check 0122 .LC0 0130 .LC1 0134 .LC2 0138 __PRETTY_FUNCTION__.11610 014a __assert_fail 0158 _nl_C_LC_CTYPE 016a __wcsmbs_load_conv 0176 .LC3 0194 __wcsmbs_gconv_fcts_c 01a0 _nl_current_LC_CTYPE 01a4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 0C 46 00 2B 18 BF 1D 46 93 B0 06 46 29 68 00 29 64 DB 00 23 01 21 0E 95 0C 93 11 93 0D 91 0B 91 00 2C 78 D0 5B 49 0D F1 18 09 07 AF CD F8 24 90 0A 97 1D EE 70 8F 79 44 09 68 58 F8 01 30 19 68 4B 69 00 2B 00 F0 82 80 9A 46 A3 18 08 94 78 D2 DA F8 00 20 D2 F8 14 B0 05 93 58 46 ?? ?? ?? ?? DA F8 00 00 00 22 05 9B 01 97 09 A9 00 92 01 27 02 92 08 AA 03 97 D8 47 30 F0 04 03 19 D0 82 1F BA 42 16 D9 05 28 4D D1 06 9B 08 98 B3 F5 80 3F C4 EB 00 00 2E D2 06 B1 33 80 09 9A 4A 45 05 D0 23 B9 0E 9A 18 46 12 68 00 2A 5E D1 13 B0 BD E8 F0 8F 02 1F 00 28 18 BF 01 2A E5 D9 07 28 08 BF 6F F0 01 00 F2 D0 34 4B 54 22 4F F0 FF 30 7B 44 1B 68 48 F8 03 20 13 B0 BD E8 F0 8F 6B 68 21 F0 00 41 00 22 29 60 6F F0 02 00 33 80 6A 60 13 B0 BD E8 F0 8F 1E B1 9A 0A A2 F5 21 52 32 80 2A 68 C3 F3 09 03 03 F5 5C 43 6B 60 42 F0 00 42 2A 60 13 B0 BD E8 F0 8F ?? ?2 0? 0? 0A 46 1E 46 ?? ?2 0? 0? 7F E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 71 22 ?? ?? ?? ?? 63 1C BF D0 4F F0 FF 33 81 E7 ?? ?2 0? 0? ?? ?2 0? 0? 99 42 17 D0 08 46 05 91 04 92 ?? ?? ?? ?? 05 99 04 9A 4B 69 6E E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 80 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 5B E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__posix_openpt"
		size = 196
		refs = "0002 .LANCHOR0 0014 .LC0 001c __open 0034 .LC1 003e __statfs 004e .LC2 006a __close 00b8 __libc_errno"
	strings:
		$1 = { 30 B5 ?? ?2 0? 0? ?? ?2 0? 0? 91 B0 01 46 23 68 00 2B 46 D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 43 1C 05 46 2F D0 63 68 23 B1 28 46 01 23 63 60 11 B0 30 BD ?? ?2 0? 0? 69 46 ?? ?2 0? 0? ?? ?? ?? ?? 20 B9 00 9B 41 F6 D1 42 93 42 ED D0 ?? ?2 0? 0? 69 46 ?? ?2 0? 0? ?? ?? ?? ?? 20 B9 00 9B 41 F2 73 32 93 42 E0 D0 28 46 ?? ?? ?? ?? 12 4B 01 21 1D EE 70 2F 21 60 7B 44 1B 68 02 21 4F F0 FF 30 D1 50 D4 E7 0D 4B 1D EE 70 2F 7B 44 1B 68 D3 58 02 2B 18 BF 13 2B 04 BF 01 23 23 60 11 B0 30 BD 07 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 D1 50 BC E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_1_0 {
	meta:
		name = "__bsd_getpt"
		size = 120
		refs = "0002 .LC3 0010 mempcpy 0014 __libc_ptyname1 0026 __libc_ptyname2 004c __open 0070 __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 ?? ?2 0? 0? 01 A8 08 22 ?? ?? ?? ?? ?? ?2 0? 0? 15 4E ?? ?2 0? 0? 70 21 00 23 05 46 83 70 ?? ?2 0? 0? 30 23 ?? ?2 0? 0? 29 70 08 E0 33 46 7B 44 1B 68 D3 58 02 2B 0B D0 14 F8 01 3F 53 B1 6B 70 01 A8 02 21 ?? ?? ?? ?? 1D EE 70 2F 43 1C ED D0 05 B0 F0 BD 17 F8 01 1F 00 29 E0 D1 03 4B 02 21 7B 44 1B 68 D1 50 F3 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_2_0 {
	meta:
		name = "__getpt"
		size = 22
		refs = "0004 __posix_openpt 0012 __bsd_getpt"
	strings:
		$1 = { 08 B5 02 20 ?? ?? ?? ?? 43 1C 00 D0 08 BD BD E8 08 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "__bb_exit_func"
		size = 334
		refs = "0000 .LC0 0004 .LC1 0016 _IO_new_fopen 0044 fwrite_unlocked 0048 __bb_head 00f2 _IO_new_fclose 0104 perror 0114 __overflow"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 47 ?? ?2 0? 0? 88 B0 ?? ?2 0? 0? ?? ?? ?? ?? 04 46 00 28 6D D0 03 68 01 25 46 F6 67 56 2A 46 43 F4 00 43 03 A8 23 60 14 21 23 46 C6 F6 6F 66 01 95 4F F0 02 09 03 96 04 95 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? D3 F8 00 80 B8 F1 00 0F 4A D0 63 69 A2 69 D8 F8 0C 10 93 42 02 91 66 D2 5A 1C 62 61 83 F8 00 90 04 25 02 AA 63 69 56 1C A1 69 58 1C 8B 42 5F D2 12 78 60 61 1A 70 01 3D 32 46 F3 D1 02 9B 00 27 4B B3 D8 F8 14 50 4F EA 87 0A 04 26 55 44 01 35 63 69 A2 69 59 1C 93 42 31 D2 61 61 15 F8 01 2C 1A 70 01 3E 05 F1 01 05 F2 D1 D8 F8 08 50 04 26 55 44 01 35 63 69 A2 69 59 1C 93 42 27 D2 61 61 15 F8 01 2C 1A 70 01 3E 05 F1 01 05 F2 D1 02 9B 01 37 BB 42 D5 D8 D8 F8 10 80 B8 F1 00 0F B4 D1 20 46 ?? ?? ?? ?? 08 B0 BD E8 F0 87 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 08 B0 BD E8 F0 87 20 46 15 F8 01 1C ?? ?? ?? ?? 01 30 CE D0 C9 E7 20 46 15 F8 01 1C ?? ?? ?? ?? 01 30 D4 D1 02 9B 01 37 BB 42 AE D8 D7 E7 20 46 02 21 ?? ?? ?? ?? 97 E7 20 46 11 78 ?? ?? ?? ?? 01 30 9F D0 9B E7 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "accept4"
		size = 132
		refs = "0004 __libc_multiple_threads 001c __libc_do_syscall 002a __libc_enable_asynccancel 004a __libc_disable_asynccancel 007c __libc_errno"
	strings:
		$1 = { 2D E9 F8 43 ?? ?2 0? 0? ?? ?2 0? 0? 80 46 0F 46 16 46 24 68 1D 46 44 B9 4F F4 B7 7C ?? ?? ?? ?? 10 F5 80 5F 15 D8 BD E8 F8 83 ?? ?? ?? ?? 39 46 32 46 2B 46 4F F4 B7 7C 81 46 40 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0F D8 48 46 ?? ?? ?? ?? 20 46 E9 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 BD E8 F8 83 05 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E5 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "dysize"
		size = 80
	strings:
		$1 = { 83 07 10 B4 18 BF 40 F2 6D 10 19 D1 48 F2 1F 53 C2 17 C5 F2 EB 13 64 24 83 FB 00 13 C2 EB 63 11 04 FB 11 01 79 B9 C2 EB E3 13 4F F4 C8 72 40 F2 6D 11 02 FB 13 00 00 28 14 BF 08 46 4F F4 B7 70 5D F8 04 4B 70 47 4F F4 B7 70 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "__statvfs64"
		size = 56
		refs = "000a __statfs64 001a __xstat64 002e __internal_statvfs64"
	strings:
		$1 = { F0 B5 B1 B0 0E 46 69 46 05 46 ?? ?? ?? ?? 04 46 78 B9 16 AF 29 46 3A 46 03 20 ?? ?? ?? ?? 31 46 6A 46 B0 F1 FF 3F 14 BF 3B 46 00 23 28 46 ?? ?? ?? ?? 20 46 31 B0 F0 BD }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "__scalbn"
		size = 272
		refs = "0066 __aeabi_dmul 0098 __aeabi_dadd"
		altNames = "__scalbln"
	strings:
		$1 = { F8 B5 C1 F3 0A 53 16 46 0F 46 00 2B 49 D0 40 F2 FF 72 93 42 3E D0 43 F6 B0 42 CF F6 FF 72 96 42 26 DB 4C F2 50 32 96 42 10 DC 1E 44 40 F2 FE 73 9E 42 0B DC 00 2E 45 DD 27 F0 FF 47 04 46 27 F4 E0 07 47 EA 06 56 20 46 31 46 F8 BD 00 29 28 A3 D3 E9 00 23 02 DA 28 A3 D3 E9 00 23 10 46 19 46 23 A3 D3 E9 00 23 ?? ?? ?? ?? 04 46 0E 46 EA E7 00 29 23 A3 D3 E9 00 23 02 DA 23 A3 D3 E9 00 23 10 46 19 46 1E A3 D3 E9 00 23 ?? ?? ?? ?? 04 46 0E 46 D8 E7 02 46 0B 46 ?? ?? ?? ?? 04 46 0E 46 D1 E7 21 F0 00 43 04 46 03 43 1E D0 00 23 00 22 C4 F2 50 33 ?? ?? ?? ?? C1 F3 0A 52 0F 46 A2 F1 36 03 A8 E7 16 F1 35 0F D2 DB 36 36 27 F0 FF 47 27 F4 E0 03 00 22 43 EA 06 51 00 23 C3 F6 90 43 ?? ?? ?? ?? 04 46 0E 46 AD E7 0E 46 AB E7 00 BF 9C 75 00 88 3C E4 37 7E 9C 75 00 88 3C E4 37 FE 59 F3 F8 C2 1F 6E A5 01 59 F3 F8 C2 1F 6E A5 81 }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "svc_find"
		size = 60
		refs = "000a __rpc_thread_variables"
	strings:
		$1 = { 2D E9 F0 41 05 46 0F 46 90 46 ?? ?? ?? ?? D0 F8 B4 30 8B B1 00 26 03 E0 18 68 1E 46 40 B1 03 46 5C 68 AC 42 F8 D1 98 68 B8 42 F5 D1 18 46 33 46 C8 F8 00 30 BD E8 F0 81 18 46 F9 E7 }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "xprt_register"
		size = 214
		refs = "0006 __rpc_thread_variables 0016 _rpc_dtablesize 002c __rpc_thread_svc_max_pollfd 0032 __rpc_thread_svc_pollfd 0058 realloc 0082 __rpc_thread_svc_fdset 00c6 malloc"
	strings:
		$1 = { 2D E9 F0 41 05 46 ?? ?? ?? ?? 2E 68 D0 F8 B0 30 04 46 00 2B 54 D0 ?? ?? ?? ?? 86 42 49 DA D4 F8 B0 30 B6 F5 80 6F 43 F8 26 50 2A DB ?? ?? ?? ?? 07 46 ?? ?? ?? ?? 00 23 3C 68 80 46 00 68 02 46 03 E0 52 F8 08 1B 01 31 35 D0 A3 42 15 46 03 F1 01 03 F6 DB 61 1C C9 00 ?? ?? ?? ?? 78 B1 3B 68 C3 22 C8 F8 00 00 01 33 3B 60 03 F1 00 53 01 3B 40 F8 33 60 3B 68 00 EB C3 00 20 F8 04 2C BD E8 F0 81 ?? ?? ?? ?? F2 17 06 F1 1F 03 01 24 13 EA 26 03 38 BF 33 46 D2 0E B1 18 5B 11 01 F0 1F 01 8A 1A 04 FA 02 F2 50 F8 23 10 11 43 40 F8 23 10 BC E7 BD E8 F0 81 C3 23 2E 60 AB 80 BD E8 F0 81 ?? ?? ?? ?? 80 00 ?? ?? ?? ?? C4 F8 B0 00 00 28 A1 D1 BD E8 F0 81 }
	condition:
		$1
}

rule file_362_2_0 {
	meta:
		name = "xprt_unregister"
		size = 148
		refs = "0008 _rpc_dtablesize 0010 __rpc_thread_variables 0032 __rpc_thread_svc_fdset 0062 __rpc_thread_svc_max_pollfd 0072 __rpc_thread_svc_pollfd"
	strings:
		$1 = { 2D E9 F0 41 04 46 05 68 ?? ?? ?? ?? 85 42 07 DA ?? ?? ?? ?? D0 F8 B0 30 53 F8 25 20 A2 42 01 D0 BD E8 F0 81 B5 F5 80 6F 4F F0 00 02 43 F8 25 20 17 DA ?? ?? ?? ?? EA 17 05 F1 1F 03 01 24 13 EA 25 03 38 BF 2B 46 D2 0E A9 18 5B 11 01 F0 1F 01 8A 1A 04 FA 02 F2 50 F8 23 10 21 EA 02 01 40 F8 23 10 ?? ?? ?? ?? 00 24 4F F0 FF 38 07 46 06 68 0C E0 ?? ?? ?? ?? 03 68 53 F8 34 20 AA 42 08 BF 43 F8 34 80 04 F1 01 04 08 BF 3E 68 B4 42 F0 DB BD E8 F0 81 }
	condition:
		$1
}

rule file_362_3_0 {
	meta:
		name = "svc_register"
		size = 110
		refs = "002c malloc 003c __rpc_thread_variables 0060 pmap_set"
	strings:
		$1 = { 2D E9 F0 41 0E 46 82 B0 11 46 15 46 80 46 01 AA 30 46 1F 46 FF F7 20 FF 04 46 30 B1 C3 68 BB 42 15 D0 00 20 02 B0 BD E8 F0 81 14 20 ?? ?? ?? ?? 04 46 00 28 F5 D0 46 60 85 60 C7 60 ?? ?? ?? ?? 00 22 D0 F8 B4 30 22 61 23 60 C0 F8 B4 40 08 9B 01 20 00 2B E6 D0 30 46 29 46 B8 F8 04 30 08 9A ?? ?? ?? ?? 00 28 DC D0 01 20 20 61 DA E7 }
	condition:
		$1
}

rule file_362_4_0 {
	meta:
		name = "svc_unregister"
		size = 76
		refs = "0020 free 0038 pmap_unset 0040 __rpc_thread_variables"
	strings:
		$1 = { 70 B5 82 B0 6A 46 06 46 0D 46 FF F7 ED FE 04 46 A0 B1 00 9B A3 B1 02 68 1A 60 00 23 20 46 23 60 ?? ?? ?? ?? 30 46 29 46 01 AA FF F7 DD FE 08 B1 03 69 1B B9 30 46 29 46 ?? ?? ?? ?? 02 B0 70 BD ?? ?? ?? ?? 23 68 C0 F8 B4 30 E6 E7 }
	condition:
		$1
}

rule file_362_5_0 {
	meta:
		name = "svc_sendreply"
		size = 50
	strings:
		$1 = { 03 46 20 30 F0 B5 8E 46 16 46 8D B0 07 C8 03 AC 9F 68 00 25 07 96 01 26 CD F8 20 E0 06 95 84 E8 07 00 18 46 69 46 FB 68 02 95 01 96 98 47 0D B0 F0 BD }
	condition:
		$1
}

rule file_362_6_0 {
	meta:
		name = "svcerr_noproc"
		size = 48
	strings:
		$1 = { 00 F1 20 02 03 46 F0 B5 8D B0 85 68 03 AC 07 CA 4F F0 03 0E 01 27 CD F8 18 E0 00 26 01 97 02 96 84 E8 07 00 18 46 69 46 EB 68 98 47 0D B0 F0 BD }
	condition:
		$1
}

rule file_362_7_0 {
	meta:
		name = "svcerr_decode"
		size = 48
	strings:
		$1 = { 00 F1 20 02 03 46 F0 B5 8D B0 85 68 03 AC 07 CA 4F F0 04 0E 01 27 CD F8 18 E0 00 26 01 97 02 96 84 E8 07 00 18 46 69 46 EB 68 98 47 0D B0 F0 BD }
	condition:
		$1
}

rule file_362_8_0 {
	meta:
		name = "svcerr_systemerr"
		size = 48
	strings:
		$1 = { 00 F1 20 02 03 46 F0 B5 8D B0 85 68 03 AC 07 CA 4F F0 05 0E 01 27 CD F8 18 E0 00 26 01 97 02 96 84 E8 07 00 18 46 69 46 EB 68 98 47 0D B0 F0 BD }
	condition:
		$1
}

rule file_362_9_0 {
	meta:
		name = "svcerr_auth"
		size = 28
	strings:
		$1 = { 82 68 01 23 00 B5 8D B0 04 91 69 46 03 93 01 93 02 93 D3 68 98 47 0D B0 5D F8 04 FB }
	condition:
		$1
}

rule file_362_10_0 {
	meta:
		name = "svcerr_weakauth"
		size = 28
	strings:
		$1 = { 82 68 01 23 10 B5 8C B0 05 24 69 46 03 93 01 93 02 93 04 94 D3 68 98 47 0C B0 10 BD }
	condition:
		$1
}

rule file_362_11_0 {
	meta:
		name = "svcerr_noprog"
		size = 42
	strings:
		$1 = { 00 F1 20 02 03 46 F0 B5 8D B0 86 68 03 AC 07 CA 01 25 00 27 06 95 01 95 02 97 84 E8 07 00 18 46 69 46 F3 68 98 47 0D B0 F0 BD }
	condition:
		$1
}

rule file_362_12_0 {
	meta:
		name = "svcerr_progvers"
		size = 54
	strings:
		$1 = { 03 46 20 30 F0 B5 0E 46 15 46 8D B0 07 C8 03 AC 9F 68 4F F0 02 0E 07 96 01 26 08 95 00 25 CD F8 18 E0 84 E8 07 00 18 46 69 46 FB 68 01 96 02 95 98 47 0D B0 F0 BD }
	condition:
		$1
}

rule file_362_13_0 {
	meta:
		name = "svc_getreq_common"
		size = 278
		refs = "0012 __rpc_thread_variables 0026 _null_auth 00b0 svcerr_progvers 00ce svcerr_noprog 00d8 _authenticate"
	strings:
		$1 = { 2D E9 F0 4F AD F2 34 5D 84 AB 04 46 20 AA 12 93 0F 92 ?? ?? ?? ?? D0 F8 B0 30 80 46 53 F8 24 B0 BB F1 00 0F 4E D0 ?? ?2 0? 0? 0D F5 68 7A ?? ?2 0? 0? 03 AD 0E AC DB F8 08 30 58 46 08 A9 1B 68 98 47 00 28 36 D0 94 E8 07 00 0B 9F 0C 9E 0D 9B 85 E8 07 00 0E 9A CD F8 18 A0 CD F8 1C B0 00 97 01 96 02 93 00 2A 35 D1 D9 F8 00 30 CB F8 28 20 CB F8 20 30 D8 F8 B4 30 43 B3 00 27 9D E8 40 40 3A 46 4F F0 FF 31 01 E0 1B 68 7B B1 58 68 86 42 FA D1 98 68 01 27 70 45 2F D0 1B 68 81 42 28 BF 01 46 82 42 38 BF 02 46 00 2B EF D1 77 B1 58 46 ?? ?? ?? ?? DB F8 08 30 58 46 5B 68 98 47 08 B3 01 28 B8 D0 0D F2 34 5D BD E8 F0 8F 58 46 ?? ?? ?? ?? EF E7 68 46 08 A9 ?? ?? ?? ?? 03 46 00 28 C8 D0 01 22 18 93 17 92 14 A9 16 92 58 46 DB F8 08 30 15 92 DB 68 98 47 DC E7 DB 68 68 46 59 46 98 47 D7 E7 DB F8 08 30 58 46 5B 69 98 47 0D F2 34 5D BD E8 F0 8F }
	condition:
		$1
}

rule file_362_14_0 {
	meta:
		name = "svc_getreqset"
		size = 84
		refs = "0006 _rpc_dtablesize 0026 svc_getreq_common"
	strings:
		$1 = { 2D E9 F8 43 80 46 ?? ?? ?? ?? B0 F5 80 6F B4 BF 81 46 4F F4 80 69 B9 F1 00 0F 19 DD 00 26 01 27 58 F8 04 5B 04 E0 ?? ?? ?? ?? 07 FA 04 F4 65 40 95 FA A5 F4 B4 FA 84 F4 00 2D 08 BF 4F F0 FF 34 60 1C 30 44 00 F1 FF 30 ED D1 20 36 4E 45 E7 DB BD E8 F8 83 }
	condition:
		$1
}

rule file_362_15_0 {
	meta:
		name = "svc_getreq"
		size = 38
		refs = "001c svc_getreqset"
	strings:
		$1 = { 00 B5 A1 B0 AD F1 04 03 1F A9 00 22 43 F8 04 2F 8B 42 FB D1 20 AB 43 F8 80 0D 68 46 ?? ?? ?? ?? 21 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_362_16_0 {
	meta:
		name = "svc_getreq_poll"
		size = 90
		refs = "000a __rpc_thread_svc_max_pollfd 0018 __rpc_thread_variables 0026 xprt_unregister 004e svc_getreq_common"
	strings:
		$1 = { 2D E9 F8 43 88 46 04 46 29 B3 ?? ?? ?? ?? 00 25 2F 46 81 46 02 68 0E E0 ?? ?? ?? ?? 01 37 D0 F8 B0 30 53 F8 26 00 ?? ?? ?? ?? B8 45 13 DD D9 F8 00 20 01 35 08 34 95 42 0D DA 26 68 71 1C F8 D0 E3 88 00 2B F5 D0 9B 06 30 46 E5 D4 01 37 ?? ?? ?? ?? B8 45 EB DC BD E8 F8 83 }
	condition:
		$1
}

rule file_362_17_0 {
	meta:
		name = "__svc_accept_failed"
		size = 60
		refs = "002c __nanosleep 0038 __libc_errno"
	strings:
		$1 = { 0D 4B 1D EE 70 2F 00 B5 7B 44 1B 68 83 B0 D3 58 18 2B 02 D0 03 B0 5D F8 04 FB 00 22 68 46 11 46 4F F2 80 03 C0 F2 FA 23 8D E8 0C 00 ?? ?? ?? ?? 03 B0 5D F8 04 FB 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_18_0 {
	meta:
		name = "__rpc_thread_svc_cleanup"
		size = 28
		refs = "0002 __rpc_thread_variables 000e svc_unregister"
	strings:
		$1 = { 10 B5 ?? ?? ?? ?? 04 46 03 E0 58 68 99 68 ?? ?? ?? ?? D4 F8 B4 30 00 2B F7 D1 10 BD }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "__fxstatat64"
		size = 284
		refs = "0014 __have_atfcts 002e __libc_do_syscall 0074 strlen 0080 procfd.10306 009c __snprintf 00c2 __atfct_seterrno 010c __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 83 B0 03 28 02 AF 88 46 15 46 99 46 3E 6A 65 D1 ?? ?2 0? 0? ?? ?2 0? 0? 23 68 00 2B 1E DB 08 46 33 46 11 46 40 F2 47 1C 4A 46 ?? ?? ?? ?? 10 F5 80 5F 5D D9 10 F1 26 0F 04 BF 4F F0 FF 33 23 60 0C D0 31 4B 41 42 1D EE 70 2F 4F F0 FF 30 7B 44 1B 68 D1 50 04 37 BD 46 BD E8 F0 83 36 F4 80 74 32 D1 18 F1 64 0F 1A D0 2B 78 2F 2B 17 D0 28 46 ?? ?? ?? ?? 00 28 3D D0 00 F1 2E 03 ?? ?2 0? 0? 23 F0 07 03 00 F1 20 01 AD EB 03 0D ?? ?2 0? 0? 02 AC 43 46 00 95 20 46 ?? ?? ?? ?? 25 46 F3 05 28 46 49 46 4C BF 4F F0 C4 0C 4F F0 C3 0C ?? ?? ?? ?? 10 F5 80 5F CD D9 40 42 41 46 22 46 ?? ?? ?? ?? 4F F0 FF 30 C5 E7 10 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 BB E7 0C 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 B1 E7 00 20 AF E7 07 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 D1 50 A5 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "__posix_spawn"
		size = 24
		refs = "0010 __spawni"
	strings:
		$1 = { 70 B5 84 B0 00 26 08 9D 09 9C 02 96 00 95 01 94 ?? ?? ?? ?? 04 B0 70 BD }
	condition:
		$1
}

rule file_366_2_0 {
	meta:
		name = "svcudp_freeargs"
		size = 18
	strings:
		$1 = { 00 6B 0B 46 10 B5 11 46 02 24 40 F8 08 4F 98 47 10 BD }
	condition:
		$1
}

rule file_366_3_0 {
	meta:
		name = "svcudp_destroy"
		size = 50
		refs = "0006 xprt_unregister 000c __close 001e free"
	strings:
		$1 = { 38 B5 04 46 05 6B ?? ?? ?? ?? 20 68 ?? ?? ?? ?? EB 68 DB 69 13 B1 05 F1 08 00 98 47 E0 6A ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 20 46 BD E8 38 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_4_0 {
	meta:
		name = "svcudp_recv"
		size = 572
		refs = "0072 __recvmsg 00f2 xdr_callmsg 011e __aeabi_uidivmod 0160 memcmp 017e __sendto 01ae __recvfrom 01ce __svc_accept_failed 0228 __sendmsg 0238 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 83 46 0B F1 58 0A 87 B0 53 46 DF F8 28 82 DB F8 30 50 0B F1 3C 07 0B F1 10 06 DA 46 10 24 0D F1 14 09 9B 46 34 30 03 91 02 90 DA F8 48 00 4F F0 DC 0E 39 46 00 22 05 94 03 46 00 28 00 F0 AE 80 2B 68 DA F8 2C 00 CA F8 3C 60 CA F8 38 30 02 9B CA F8 34 00 01 20 CA F8 40 40 CA F8 48 00 CA F8 44 30 CA F8 4C B0 CA F8 50 E0 DA F8 00 00 ?? ?? ?? ?? 00 28 C0 F2 9B 80 DA F8 50 10 84 46 DA F8 40 20 D3 46 0B 29 05 92 19 D9 DA F8 4C 30 B3 B1 1C 68 0B 2C 77 D9 04 F1 03 09 19 44 29 F0 03 09 03 EB 09 08 08 F1 0C 0A 51 45 6C D3 53 F8 09 90 09 F1 03 09 29 F0 03 09 C8 44 41 45 63 D3 00 23 CB F8 4C 30 CB F8 50 30 CB F8 0C 20 BC F1 0F 0F 40 F3 81 80 EB 68 05 F1 08 04 00 21 20 46 4F F0 01 08 C5 F8 08 80 5B 69 98 47 20 46 03 99 ?? ?? ?? ?? 00 28 6F D0 03 9A 13 68 D5 F8 B0 21 6B 60 00 2A 3C D0 DB F8 30 30 D3 F8 B0 81 5D 68 08 F1 1C 09 D8 F8 00 10 28 46 89 00 ?? ?? ?? ?? D8 F8 04 30 53 F8 21 40 1C B9 59 E0 A4 6A 00 2C 56 D0 23 68 9D 42 F9 D1 62 68 D8 F8 18 30 9A 42 F4 D1 A2 68 D8 F8 14 30 9A 42 EF D1 E2 68 D8 F8 10 30 9A 42 EA D1 04 F1 10 00 49 46 10 22 ?? ?? ?? ?? 00 28 E2 D1 DB F8 48 30 21 6A 62 6A 00 2B 51 D1 05 9C DB F8 00 00 00 96 01 94 ?? ?? ?? ?? 01 20 07 B0 BD E8 F0 8F 59 68 00 29 98 D1 98 68 08 28 95 D1 17 2C 88 BF D9 60 96 D8 90 E7 DA F8 00 00 DA F8 2C 10 2A 68 8D E8 40 02 ?? ?? ?? ?? 05 9B 1D EE 70 2F CA F8 0C 30 43 1C 37 D1 43 46 7B 44 1B 68 D3 58 04 2B 3F F4 30 AF ?? ?? ?? ?? 00 20 07 B0 BD E8 F0 8F 00 20 07 B0 BD E8 F0 8F 03 98 03 9A 43 69 01 20 C8 F8 18 30 13 69 C8 F8 14 30 D3 68 C8 F8 10 30 34 68 71 68 B2 68 F3 68 C9 F8 00 40 C9 F8 04 10 C9 F8 08 20 C9 F8 0C 30 07 B0 BD E8 F0 8F CB F8 34 10 39 46 CB F8 38 20 02 46 DB F8 00 00 ?? ?? ?? ?? 01 20 D1 E7 84 46 D3 46 4C E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_366_5_0 {
	meta:
		name = "svcudp_reply"
		size = 492
		refs = "0028 xdr_replymsg 0058 __sendto 008a __aeabi_uidivmod 00ae _libc_intl_domainname 00b2 .LC3 00c0 __dcgettext 00c4 .LC1 00d0 __fxprintf 00ea __sendmsg 0112 xdrmem_create 0178 malloc 0194 free 019c .LC2 01c6 .LC0"
	strings:
		$1 = { 2D E9 F0 47 00 27 04 6B 88 46 82 B0 39 46 04 F1 08 06 05 46 E3 68 30 46 A7 60 5B 69 98 47 63 68 41 46 30 46 C8 F8 00 30 ?? ?? ?? ?? 18 B9 00 20 02 B0 BD E8 F0 87 E3 68 30 46 1B 69 98 47 AB 6C 06 46 00 2B 4A D1 EF 68 05 F1 10 0E 28 68 32 46 E9 6A 01 97 CD F8 00 E0 ?? ?? ?? ?? B0 42 E6 D1 D4 F8 B0 31 B3 B3 00 2E 34 DB D5 F8 30 90 D9 F8 B0 81 D8 F8 0C 20 D8 F8 08 30 53 F8 22 40 00 2C 79 D0 D8 F8 00 10 20 68 89 00 ?? ?? ?? ?? D8 F8 04 30 03 EB 81 00 53 F8 21 10 41 B1 8C 42 03 D1 28 E0 9C 42 24 D0 19 46 8B 6A 00 2B F9 D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 00 20 ?? ?? ?? ?? 01 20 02 B0 BD E8 F0 87 EB 6A 29 46 A8 63 3A 46 51 F8 3C 0B 6B 63 ?? ?? ?? ?? B5 E7 01 F1 28 00 A3 6A D9 F8 00 20 03 60 27 6A EB 6A 39 46 66 62 09 F1 08 00 04 F1 10 06 23 62 00 23 EF 62 ?? ?? ?? ?? D9 F8 04 70 D8 F8 18 00 08 F1 1C 03 D8 F8 14 10 D8 F8 10 20 27 60 60 60 A1 60 E2 60 0F CB 86 E8 0F 00 38 46 2B 6B D3 F8 B0 31 19 68 89 00 ?? ?? ?? ?? D8 F8 04 20 D8 F8 0C 30 58 1C 0D 46 D8 F8 00 10 52 F8 25 60 A6 62 42 F8 25 40 D8 F8 08 20 42 F8 23 40 ?? ?? ?? ?? 01 20 C8 F8 0C 10 5C E7 2C 20 ?? ?? ?? ?? 04 46 00 B3 D9 F8 00 A0 50 46 ?? ?? ?? ?? 52 46 07 46 00 28 B5 D1 20 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 38 46 ?? ?? ?? ?? 01 20 36 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 20 46 ?? ?? ?? ?? 01 20 21 E7 }
	condition:
		$1
}

rule file_366_6_0 {
	meta:
		name = "svcudp_bufcreate"
		size = 430
		refs = "002e bindresvport 003c __getsockname 0050 malloc 0090 xdrmem_create 009a .LANCHOR0 00ce __setsockopt 00e4 memset 00ea xprt_register 00f6 _libc_intl_domainname 00fa .LC5 0108 __dcgettext 010c perror 0118 __close 012e __bind 013a __socket 014c .LC4 016e .LC6 0180 .LC7 0184 .LC8 0194 __fxprintf 019a free"
	strings:
		$1 = { 2D E9 F0 47 88 B0 10 23 04 46 02 93 43 1C 88 46 91 46 18 BF 00 27 00 F0 8D 80 20 46 04 A9 00 25 02 23 04 95 05 95 06 95 07 95 AD F8 10 30 ?? ?? ?? ?? 00 28 76 D1 04 A9 20 46 02 AA ?? ?? ?? ?? 06 46 00 28 57 D1 4F F4 9A 70 C1 45 28 BF C8 46 ?? ?? ?? ?? 08 F1 03 08 28 F0 03 08 05 46 4F F4 DA 70 ?? ?? ?? ?? 07 46 40 46 ?? ?? ?? ?? 00 2F 18 BF 00 2D 82 46 78 D0 00 28 76 D0 38 46 42 46 51 46 01 23 40 F8 08 8B 07 F1 20 08 C5 F8 2C A0 ?? ?? ?? ?? BD F8 12 C0 08 AB ?? ?2 0? 0? CC F3 07 29 01 22 49 EA 0C 2C 43 F8 14 2D ?? ?2 0? 0? 04 22 20 46 00 92 31 46 08 22 C7 F8 B0 61 2F 63 C5 F8 24 80 2C 60 A5 F8 04 C0 C5 F8 08 E0 ?? ?? ?? ?? 00 28 47 D1 FF 26 03 96 31 46 4F F4 80 72 05 F1 34 00 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 28 46 08 B0 BD E8 F0 87 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?? ?? ?? 38 46 00 2F EC D0 20 46 ?? ?? ?? ?? 00 20 08 B0 BD E8 F0 87 20 46 04 A9 02 9A AD F8 12 50 ?? ?? ?? ?? 80 E7 02 20 11 22 01 46 ?? ?? ?? ?? 04 1E A8 BF 01 27 BF F6 69 AF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?? ?? ?? 00 20 C4 E7 03 96 B7 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 03 46 00 20 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? 50 46 ?? ?? ?? ?? 00 20 A0 E7 }
	condition:
		$1
}

rule file_366_8_0 {
	meta:
		name = "svcudp_enablecache"
		size = 248
		refs = "000c _libc_intl_domainname 0010 .LC9 001e __dcgettext 0022 .LC1 002e __fxprintf 0038 malloc 0048 calloc 006c .LC10 0094 free 009c .LC11 00d2 .LC12"
	strings:
		$1 = { F8 B5 0E 46 05 6B D5 F8 B0 41 A4 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 00 20 ?? ?? ?? ?? 00 20 F8 BD 2C 20 ?? ?? ?? ?? 07 46 98 B1 06 60 B1 00 FC 60 04 20 ?? ?? ?? ?? 04 46 78 60 F8 B1 31 46 04 20 ?? ?? ?? ?? 06 46 B8 60 80 B3 01 20 C5 F8 B0 71 F8 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 38 46 ?? ?? ?? ?? 38 46 F8 BD 38 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 20 46 ?? ?? ?? ?? 20 46 F8 BD 20 46 ?? ?? ?? ?? 38 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 30 46 ?? ?? ?? ?? 30 46 F8 BD }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "isfdtype"
		size = 64
		refs = "0018 __fxstat64 0038 __libc_errno"
	strings:
		$1 = { 0D 4B 70 B5 1D EE 70 4F 7B 44 1B 68 9A B0 0E 46 6A 46 01 46 03 20 E5 58 ?? ?? ?? ?? 07 4B 7B 44 1B 68 E5 50 28 B9 04 98 00 F4 70 40 83 1B 58 42 58 41 1A B0 70 BD 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "str_to_mpn"
		size = 494
		refs = "0074 __mpn_mul_1 00fe _tens_in_limb 018e .LC2 0192 .LC1 0196 __PRETTY_FUNCTION__.13714 01aa __assert_fail 01ce .LC0"
	strings:
		$1 = { 2D E9 F8 4F 0C 1E 92 46 9B 46 4F F0 00 02 80 46 1A 60 40 F3 DC 80 01 25 91 46 16 46 00 E0 1E 46 D8 F8 00 30 09 EB 89 09 A3 F1 30 01 09 29 98 BF 19 46 06 F1 01 03 84 BF D8 F8 04 10 08 F1 04 08 01 3C 08 F1 04 08 01 EB 49 09 A9 F1 30 09 46 D0 09 2B E4 D1 42 B9 CA F8 00 90 4F F0 00 09 CB F8 00 50 4B 46 01 22 DA E7 4F F4 4A 43 51 46 C3 F6 9A 33 50 46 ?? ?? ?? ?? DA F8 00 10 DB F8 00 30 09 EB 01 02 CA F8 00 20 91 42 1E D9 0A F1 04 02 05 E0 52 F8 04 1B 01 31 42 F8 04 1C A9 B9 01 3B F7 D1 4F F0 01 09 19 EB 00 02 13 D0 DB F8 00 30 11 2B 7C DC 4A F8 23 20 4F F0 00 09 DB F8 00 20 4B 46 01 32 CB F8 00 20 A9 E7 4F F0 00 09 19 EB 00 02 EB D1 91 46 DB F8 00 20 4B 46 9F E7 0A 99 D1 E9 00 45 01 2C 75 F1 00 01 20 DB C6 F1 08 06 F7 17 A6 42 77 EB 05 01 19 DB 26 46 23 44 ?? ?2 0? 0? 0A 9C ?? ?2 0? 0? 00 21 00 20 C4 E9 00 01 55 F8 26 10 55 F8 23 30 01 FB 09 F9 7A B9 CA F8 00 90 01 23 CB F8 00 30 40 46 BD E8 F8 8F ?? ?2 0? 0? ?? ?2 0? 0? 51 F8 23 30 00 2A EF D0 51 46 50 46 ?? ?? ?? ?? DA F8 00 10 DB F8 00 30 09 EB 01 02 CA F8 00 20 91 42 0C D9 0A F1 04 02 05 E0 52 F8 04 1B 01 31 42 F8 04 1C 19 B9 01 3B F7 D1 01 23 00 E0 00 23 1B 18 D6 D0 DB F8 00 20 11 2A DE BF 51 1C CB F8 00 10 4A F8 22 30 CC DD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 B3 12 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 7B 12 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 B5 72 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_370_1_0 {
	meta:
		name = "round_and_return"
		size = 568
		refs = "0000 _dl_hwcap 008e __mpn_rshift 00b8 __aeabi_fmul 00f2 __mpn_construct_float 01ce abort 022c __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 4B 14 46 1D 46 D1 E9 00 23 00 27 40 26 3B 40 32 40 82 B0 80 46 52 EA 03 00 0A 9F 08 BF 4F F0 00 09 03 D0 F1 EE 10 9A 09 F4 40 09 6F F0 7D 02 4F F0 FF 33 94 42 75 EB 03 01 69 DA 6F F0 95 02 4F F0 FF 33 94 42 75 EB 03 00 50 DB 01 22 0C 99 0B 9D C4 F1 FF 24 02 FA 01 F3 04 F5 7F 04 01 3B 82 34 2B 42 0D 9D 18 BF 45 F0 01 05 18 2C 0D 95 00 F0 C9 80 D8 F8 00 50 23 46 40 46 41 46 01 3C 0C 94 0B 95 ?? ?? ?? ?? D8 F8 00 60 0B 98 0C 99 20 FA 01 FB 1B F0 01 0B 5B D0 61 4B 1D EE 70 2F 4F F4 00 00 22 24 7B 44 1B 68 01 46 D4 50 ?? ?? ?? ?? 01 90 01 9B 6F F0 7E 04 4F F0 FF 35 0D 98 3A 1C 5B 46 18 BF 01 22 01 21 00 28 38 D0 B9 F5 80 0F 7E D0 4E DD B9 F5 00 0F 75 D0 B9 F5 40 0F 70 D1 21 46 40 46 3A 46 ?? ?? ?? ?? 0D E0 4D 4B 1D EE 70 2F 22 21 4F F4 00 00 7B 44 1B 68 D1 50 00 2F 2F D1 01 46 ?? ?? ?? ?? 02 B0 BD E8 F0 8B 81 2C 75 F1 00 00 4C DB 44 4B 1D EE 70 2F 4F F6 FF 70 22 21 7B 44 1B 68 C7 F6 7F 70 D1 50 00 2F E8 D0 6F F4 00 01 ?? ?? ?? ?? 02 B0 BD E8 F0 8B 0C 98 81 40 0B 98 01 39 01 42 0C BF 00 21 01 21 BD E7 0D 9D 00 2D A0 D1 01 23 8B 40 01 3B 03 42 A9 D0 9A E7 00 21 C8 F2 80 01 ?? ?? ?? ?? 02 B0 BD E8 F0 8B B9 F1 00 0F 24 D1 00 2B B1 D0 06 F0 01 03 0B 43 00 2B AC D0 71 1C C8 F8 00 10 CB 01 24 D4 6F F0 7E 02 4F F0 FF 33 9D 42 08 BF 94 42 9F D1 11 F4 00 0F 0C BF 6F F0 7E 01 6F F0 7D 01 98 E7 0B 99 0C 9A D8 F8 00 60 21 FA 02 FB 0B F0 01 0B 7C E7 ?? ?? ?? ?? 0A B1 0B 43 DA B2 13 46 D8 E7 0B 43 DB B2 00 2A D4 D0 82 E7 01 34 4F F0 01 02 13 46 45 F1 00 05 40 46 41 46 ?? ?? ?? ?? D8 F8 00 30 00 2D 08 BF 81 2C 43 F4 00 03 C8 F8 00 30 89 D0 6D E7 D8 F8 00 00 00 26 17 21 C8 F8 00 60 B0 42 18 BF 45 F0 01 05 0C 91 0B 90 0D 95 34 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_370_2_0 {
	meta:
		name = "____wcstof_l_internal"
		size = 6588
		refs = "003a __iswspace_l 009e __towlower_l 0184 __aeabi_ldivmod 0268 __correctly_grouped_prefixwc 04ba __tens 04f0 memcpy 051a __mpn_mul 0570 __mpn_lshift 05da __aeabi_uidiv 05e4 __aeabi_uidivmod 072c .LC9 0730 .LC1 0734 __PRETTY_FUNCTION__.13758 0748 __assert_fail 0782 _nl_C_locobj 07ac _fpioconst_pow10 08c4 __iswxdigit_l 08ee .LANCHOR0 0bd0 __mpn_rshift 0c24 __mpn_cmp 0ee0 .LC6 0ef4 __wcsncasecmp_l 1104 __mpn_submul_1 1118 __mpn_add_n 12e4 .LC17 1336 .LC4 135c .LC5 15c4 ____wcstoull_l_internal 163c __aeabi_fmul 169c .LC18 175e .LC7 177e .LC13 179e .LC20 17be .LC21 17e4 .LC19 180c .LC11 182c .LC12 184c .LC15 186c .LC16 188c .LC10 18ac .LC14 18cc .LC3 1960 __libc_errno 199c .LC8"
	strings:
		$1 = { 2D E9 F0 4F BF B0 92 46 17 46 0A 93 0C 90 0D 91 5B 68 00 2A 41 F0 AE 84 1B 6B 08 93 00 2B 01 F0 55 84 0C 9E 00 22 DD F8 28 80 00 23 CD E9 18 23 35 46 41 46 04 36 2C 68 20 46 ?? ?? ?? ?? 00 28 F6 D1 2D 2C 2B 46 00 F0 97 83 2B 2C 11 90 04 BF 35 46 5C 68 08 9E B4 42 00 F0 78 83 A4 F1 30 03 09 2B 00 F2 8E 83 30 2C 00 F0 78 83 0A 26 0B 96 3B 1C A8 46 18 BF 01 23 01 E0 58 F8 04 4F 30 2C FB D0 BC 42 14 BF 00 26 03 F0 01 06 00 2E F4 D1 20 46 0A 99 A4 F1 30 03 CD F8 3C 80 05 93 ?? ?? ?? ?? 05 9B 09 2B 83 46 00 F2 B4 80 09 2B C1 46 4F F0 00 00 CB 46 07 90 09 D8 07 9C 01 34 07 94 59 F8 04 4F A4 F1 30 03 CB 46 09 2B F5 D9 0B 98 10 28 00 F0 74 83 00 2F 41 F0 08 84 BA F1 00 0F 41 F0 09 84 07 9D DD F8 1C C0 00 2D 14 BF 00 25 6F F0 00 05 0C 95 08 9D AC 42 00 F0 C8 80 20 46 0A 99 CD F8 18 C0 ?? ?? ?? ?? 0B 9C DD F8 18 C0 B4 F1 10 07 7E 42 7E 41 70 28 14 BF 00 25 06 F0 01 05 0E 95 00 2D 00 F0 E7 80 DB F8 04 30 2D 2B 00 F0 3E 83 2B 2B 13 BF 0B F1 04 0A 0B F1 08 0A DB F8 08 30 00 26 0A BF 00 27 10 96 10 97 A3 F1 30 09 B9 F1 09 0F 00 F2 DB 80 0E 9C 00 2C 40 F0 51 83 10 9F 00 2F 00 F0 89 83 07 9E 00 27 0A 22 00 23 3D 46 16 F1 3D 04 45 F1 00 05 20 46 29 46 CD F8 18 C0 ?? ?? ?? ?? DD F8 18 C0 06 46 0F 46 20 46 29 46 0A 22 00 23 CD F8 18 C0 ?? ?? ?? ?? DD F8 18 C0 48 46 DD E9 18 45 0A 21 CD F8 50 B0 B9 46 E3 46 C4 46 B0 46 CD E9 12 23 A0 45 79 EB 05 02 C1 F2 26 82 4D 45 08 BF 44 45 06 46 4F F0 00 07 01 F0 18 82 A4 FB 01 23 DA F8 04 00 0A F1 04 0A 94 19 A0 F1 30 00 01 FB 05 33 43 EB 07 05 09 28 E3 D9 10 9E E0 46 CD E9 18 45 DC 46 DD F8 50 B0 00 2E 00 F0 85 80 64 42 65 EB 45 05 CD E9 18 45 7E E0 DD F8 2C E0 A0 F1 61 02 BE F1 10 01 70 46 18 BF 01 21 05 2A 98 BF 10 28 3F F4 3E AF 08 9A 94 42 00 F0 D0 82 00 29 00 F0 1E 86 DD F8 2C E0 BE F1 10 02 D2 F1 00 09 59 EB 02 09 BB F1 65 0F 0C BF 4A 46 49 F0 01 02 00 2A 3F F4 26 AF 3A 46 53 46 28 46 41 46 ?? ?? ?? ?? 0D 9C 34 B1 85 42 18 BF 03 46 01 F0 5A 81 0D 9D 2B 60 11 9E 00 2E 40 F0 F0 82 00 20 3F B0 BD E8 F0 8F 10 96 E2 46 59 F8 04 4F 65 46 0B 9F 0C 9E CD F8 38 80 DD F8 28 B0 16 E0 20 46 59 46 ?? ?? ?? ?? 61 38 05 28 00 F2 DD 82 B6 F1 FF 3E DE F1 00 03 53 EB 0E 03 30 2C 08 BF 00 23 0B B1 CA EB 05 06 59 F8 04 4F 01 35 A4 F1 30 03 09 2B EC D9 10 2F E2 D0 20 46 0A 99 0C 96 CB 46 10 9E DD F8 38 80 06 95 ?? ?? ?? ?? DD F8 18 C0 B0 F1 65 05 0B 9C 68 42 0E 96 68 41 10 2C 08 BF 00 20 00 28 7F F4 0D AF DA 46 07 9C A4 45 00 F2 01 82 07 9E B6 EB 0C 02 53 42 53 41 BC F1 00 0F 08 BF 00 23 33 B1 DD E9 18 23 00 2A 73 F1 00 07 C0 F2 5A 83 0D 9D 0D B1 C5 F8 00 A0 BC F1 00 0F 99 D0 0C 9C 00 2C 34 D0 D8 F8 00 30 08 9D AB 42 09 D0 08 F1 04 08 29 46 42 46 08 F1 04 08 13 68 8B 42 F9 D1 0F 92 0C 9E 00 25 2B 46 0F 9D 71 1C 32 46 0B 9E 05 EB 81 05 0F 95 10 2E DD E9 18 67 00 F0 BC 87 30 1C 47 F1 00 41 99 42 08 BF 90 42 C1 F0 78 82 0B 9C 10 2C 0C 9C 08 BF 0C 9D C4 EB 0C 0C 04 BF AB 0F AA 00 B2 1A 67 EB 03 03 CD E9 18 23 0B 9D 10 2D 00 F0 7A 82 DD E9 18 01 00 28 71 F1 00 06 C0 F2 34 82 07 9E BC EB 06 02 6C EB 0C 03 90 42 71 EB 03 07 01 DA 02 46 0B 46 DD F8 1C 90 00 27 27 24 00 25 91 44 82 1A 61 EB 03 03 4E 46 CD E9 08 67 A4 1B 65 EB 07 05 CD E9 18 23 94 42 75 EB 03 07 C1 F2 67 81 6F F0 2B 00 4F F0 FF 31 82 42 73 EB 01 05 C1 F2 4C 81 C8 46 B9 F1 00 0F 40 F0 18 83 CC 45 41 F2 3C 82 DD E9 18 45 14 F1 2C 02 45 F1 00 03 00 2B 08 BF 2D 2A 81 F0 31 82 B8 F1 00 0F 40 F3 24 87 B9 F1 00 0F 01 F0 F9 81 54 EA 05 06 04 BF C8 F1 19 04 00 25 41 F0 F1 81 DD E9 08 67 60 46 00 21 22 46 E3 17 86 1B 61 EB 07 07 96 42 77 EB 03 0E DD E9 08 67 BE BF C9 EB 0C 04 22 46 D3 17 92 19 43 EB 07 03 82 42 73 EB 01 07 BC BF 04 EB 09 0C 01 24 C9 EB 0C 09 CD F8 20 90 B8 BF 12 94 1A AC 07 94 A8 BF 00 26 08 9C ?? ?2 0? 0? A8 BF 12 96 2C AE 0A 96 67 1B B8 4E ?? ?2 0? 0? DD F8 1C A0 01 24 DD F8 28 B0 00 25 0E E0 56 F8 0C 5C 58 46 56 F8 10 3C 02 3D 99 1C AA 00 09 EB 81 01 ?? ?? ?? ?? 64 00 10 36 07 B3 27 42 FA D0 67 40 00 2D EB D0 56 F8 10 1C 5B 46 56 F8 0C 2C 50 46 02 31 00 95 02 3A 09 EB 81 01 ?? ?? ?? ?? 56 F8 0C 3C 02 3B 1D 44 5B 46 00 28 40 F0 92 81 D3 46 01 3D 9A 46 64 00 10 36 00 2F DE D1 07 9E B3 45 00 F0 C9 87 6C 1E 18 AB 0F 98 00 93 16 AB 08 99 A6 00 07 9A 0D 94 FF F7 3F FB 3E AB 33 44 53 F8 48 4C B4 FA 84 F4 74 B1 0A 98 2A 46 23 46 01 46 ?? ?? ?? ?? 07 98 23 46 16 9A 01 46 ?? ?? ?? ?? 00 28 40 F0 99 84 16 9A 01 2D 40 46 4F EA E8 71 CD E9 18 01 00 F0 C4 83 02 2D 40 F0 34 83 01 2A DD F8 B0 90 2D 9D 40 F3 EE 84 DD F8 6C C0 DD F8 68 A0 0D F1 5C 0B 00 26 0A 96 46 46 2C 0C D0 46 E2 46 AA B2 C9 F1 00 03 07 92 0B 93 CD F8 20 B0 AA 45 00 F0 0C 86 21 46 50 46 ?? ?? ?? ?? 21 46 07 46 50 46 ?? ?? ?? ?? 07 9A 4F EA 18 43 02 FB 07 F0 43 EA 01 41 88 42 09 D9 49 19 07 F1 FF 32 04 D2 88 42 84 BF 02 3F 49 19 00 D8 17 46 C0 EB 01 0B 21 46 58 46 1F FA 88 F8 ?? ?? ?? ?? 21 46 82 46 58 46 ?? ?? ?? ?? 07 9B 03 FB 0A F0 48 EA 01 48 40 45 0B D9 18 EB 05 08 0A F1 FF 33 05 D2 40 45 84 BF AA F1 02 0A A8 44 00 D8 9A 46 4A EA 07 41 C0 EB 08 00 A1 FB 09 23 92 46 83 42 07 D8 1A F1 00 02 18 BF 01 22 83 42 18 BF 00 22 42 B1 BA EB 09 07 63 F1 00 03 40 19 01 F1 FF 31 BA 46 EC D3 4F F0 00 0E BE EB 0A 08 60 EB 03 0A 00 2E 40 F0 BC 85 DD E9 18 67 00 29 00 F0 BD 85 B1 FA 81 F0 C0 F1 20 0E 32 1A 67 EB E0 73 BE F1 18 0F 16 46 1F 46 CD E9 18 67 41 F3 4F 80 DD F8 20 B0 D4 46 0C 46 C2 46 80 46 C8 F1 08 01 08 F1 18 08 24 FA 01 F1 CD F8 28 80 17 91 12 99 0A 9E BC F1 00 0F 18 BF 41 F0 01 01 12 F1 FF 32 43 F1 FF 33 C6 F1 1F 05 00 29 40 F0 9E 86 1A F1 00 01 18 BF 01 21 11 9F 58 46 01 94 02 95 00 97 03 91 FF F7 5B FB B9 E5 AB F1 04 0B 0C F1 FF 3C 5B F8 04 3C 30 2B F7 D0 07 9D AC 45 BF F4 F7 AD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 0D 42 ?? ?? ?? ?? 6B 68 30 3B 09 2B 3F F6 83 AC 30 2C 7F F4 88 AC 68 68 0A 99 ?? ?? ?? ?? 78 28 7F F4 81 AC AC 68 10 26 4F F0 00 0A 08 35 0B 96 7B E4 35 46 5C 68 01 26 11 96 68 E4 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 69 28 00 F0 D0 85 6E 28 00 F0 A2 83 0D 9D 00 2D 3F F4 71 AD 0C 9E 0D 9F 3E 60 6C E5 ?? ?? ?? ?? 01 25 0B F1 08 0A DB F8 08 30 10 95 C7 E4 20 46 0A 99 ?? ?? ?? ?? 61 38 05 28 7F F6 76 AC 00 2F 3F F4 84 AC 01 F0 8A B8 45 45 08 BF 10 28 7F F4 65 AC D8 F8 04 00 A0 F1 30 02 09 2A 7F F6 5E AC 0A 99 05 93 ?? ?? ?? ?? 05 9B 61 38 05 28 3F F6 1E AD 53 E4 10 9D 00 2D 40 F0 60 83 07 9C 00 2C 00 F0 14 86 0C 9D 00 2D 40 F0 A1 87 07 9E 20 22 00 23 92 1B 63 F1 00 03 9D 00 94 00 45 EA 92 75 03 34 45 F1 00 05 2F E0 07 9C 00 25 2B 46 22 46 52 42 63 EB 43 03 82 42 73 EB 01 05 BF F6 CB AD C7 E5 D3 46 9A 46 4D E6 0D 9F 07 B1 38 60 11 9C 00 2C 3F F4 10 AD 4F F0 00 40 3F B0 BD E8 F0 8F CB 46 0C 96 AC 46 DD F8 38 80 40 E4 07 9C 00 2C 00 F0 0B 83 0C 9D 00 2D 41 F0 88 80 07 9E 27 24 00 25 A4 1B 65 F1 00 05 00 2C 75 F1 00 07 BF BF 00 24 00 25 26 46 2F 46 FF F6 72 AC 20 46 29 46 0A 22 00 23 64 E4 0F 9D 67 46 0A 9E 2C 46 31 46 04 35 20 68 ?? ?? ?? ?? 00 28 F7 D0 20 68 BC 46 30 28 05 D1 2B 46 1C 46 53 F8 04 0B 30 28 FA D0 A0 F1 30 03 09 2B 98 BF 04 34 00 F2 88 85 ?? ?2 0? 0? ?? ?2 0? 0? 52 F8 23 60 00 2E 00 F0 86 87 DD E9 18 89 00 21 07 98 8B 46 B8 F1 00 0F 79 F1 00 01 C6 F1 18 02 03 FA 02 F3 C6 F1 17 05 17 93 82 46 C0 F2 78 85 4F F0 FF 32 6F F0 00 43 B2 EB 08 02 63 EB 09 03 92 1B 63 EB E6 73 50 1C 4F F0 03 02 43 F1 00 01 CD E9 12 01 CB 17 18 46 D9 17 00 23 10 40 19 40 DD E9 12 23 CD E9 08 01 80 18 41 EB 03 01 80 08 40 EA 81 72 8B 10 5B 45 08 BF 52 45 C0 F0 5B 87 1A F1 FF 30 06 F1 FF 36 4B F1 FF 31 82 00 92 19 4F EA 81 03 43 EA 90 73 43 EB E6 73 18 EB 02 08 49 EB 03 09 BC F1 01 06 CD E9 18 89 00 F0 E1 85 0A 9F 0E E0 02 2D 40 F3 F2 84 E9 1E 17 9A 01 3E 03 FA 01 F3 42 EA 03 02 A5 F1 04 05 17 92 00 F0 0E 85 20 68 39 46 ?? ?? ?? ?? 00 B9 04 34 20 68 A0 F1 30 03 09 2B 98 BF 04 34 E3 D9 39 46 04 34 ?? ?? ?? ?? A0 F1 57 03 DC E7 0E 9C 65 46 DD F8 28 90 5B F8 04 0C 0C BB 30 38 09 28 94 BF 00 20 01 20 A8 B9 5B F8 04 3C 30 2B 22 D1 01 3D 01 3E E4 B9 01 20 00 21 DD E9 18 23 2F 1C 18 BF 01 27 12 18 43 EB 01 03 CD E9 18 23 17 EA D3 77 10 D0 AB F1 04 0B 5B F8 04 0C 00 2C DD D0 49 46 ?? ?? ?? ?? D0 F1 01 00 38 BF 00 20 DA E7 04 20 00 21 E1 E7 07 96 AC 46 6E E4 1A AC 18 AB 22 46 00 93 0F 98 49 46 16 AB 07 94 CD F8 18 C0 FF F7 B1 F8 DD E9 18 AB DD F8 18 C0 BA F1 01 0F 7B F1 00 05 B8 BF 16 9C 0F 90 6F DB 2C AE 0A 96 16 9C ?? ?2 0? 0? DD F8 28 80 ?? ?2 0? 0? 22 46 0B 97 9D 4E 01 25 07 9F 44 46 CD F8 34 C0 CD F8 30 90 1B E0 DD F8 2C E0 02 33 CD F8 00 80 20 46 39 46 0E EB 83 03 ?? ?? ?? ?? 16 9A 42 44 16 92 00 28 31 D0 3B 46 DD E9 18 AB 27 46 1C 46 5A EA 0B 00 4F EA 45 05 06 F1 10 06 2E D0 E9 17 05 EA 0A 08 01 EA 0B 09 58 EA 09 0E F0 D0 56 F8 0C 3C 85 EA 0A 00 81 EA 0B 01 CD E9 18 01 A3 F1 02 08 56 F8 10 3C 90 45 CD DD 99 1C DD F8 2C E0 00 92 20 46 42 46 3B 46 0E EB 81 01 ?? ?? ?? ?? 16 9A 42 44 16 92 00 28 CD D1 39 46 53 1E 27 46 DD E9 18 AB 0C 46 1A 46 16 93 C9 E7 0A 9D 14 46 DD F8 34 C0 AF 42 DD F8 30 90 08 D1 39 46 07 98 92 00 CD F8 18 C0 ?? ?? ?? ?? DD F8 18 C0 61 1E 3E AE 06 EB 81 03 53 F8 90 3C B3 FA 83 F8 C8 EB 44 18 B8 F1 80 0F 00 F3 C3 85 B8 F1 18 0F 00 F3 C6 81 CC 45 40 F0 76 84 08 F1 FF 38 4F EA E8 73 DB 0E 08 EB 03 02 02 F0 1F 02 D3 1A 17 2B 00 F0 1B 85 16 2B 40 F3 C4 84 00 2C 00 F3 E0 85 C4 F1 01 00 0D F1 5C 0B 17 3B 22 46 07 99 0B EB 80 00 ?? ?? ?? ?? 16 9B 3E AF 5B 42 00 2B 07 EB 83 02 42 F8 9C 0C 01 DD 00 23 17 93 11 9C 00 21 58 46 42 46 4F EA E8 73 01 91 00 94 02 91 03 91 FF F7 E3 F8 FF F7 41 BB A9 1A 0A 9C AF 1E 3E AB 04 EB 81 01 3E AC BF 00 34 44 3B 44 07 98 54 F8 48 9C 53 F8 48 AC ?? ?? ?? ?? 00 28 C3 BF 0D F1 F8 0E 00 22 16 9B 16 99 C1 BF 59 1C 16 91 0E EB 83 03 43 F8 90 2C A9 42 80 F2 C5 81 B8 F1 00 0F C1 EB 05 04 40 F3 5E 84 08 EB 44 1E BE F1 18 0F 00 F3 26 84 01 2C 01 BF 00 23 F0 46 17 93 0F 93 40 F0 B9 85 00 29 0B DD 07 98 DD F8 1C E0 00 EB 81 01 A0 00 51 F8 04 2D 0B 18 71 45 5A 60 F9 D1 00 2C 08 DB 07 99 19 AB 00 22 01 EB 84 04 43 F8 04 2F A3 42 FB D1 AC 00 14 94 DD F8 50 E0 3E AB B8 F1 18 0F 4F F0 00 04 73 44 43 F8 48 4C 53 F8 90 CC 40 F3 A2 81 DD E9 18 23 61 46 0D F1 5C 0B 71 B9 00 2D 0C DB 07 99 14 9F 0D 98 39 44 02 E0 46 1C 05 D0 01 38 51 F8 04 6D 05 46 00 2E F7 D0 12 9F 58 46 0F 9E 00 2D A8 BF 47 F0 01 07 11 9D 12 F1 FF 32 C6 F1 1F 01 03 97 43 F1 FF 33 02 91 00 95 01 94 FF F7 59 F8 FF F7 B7 BA 00 BF ?? ?? ?? ?? 01 2A 1A 9D DD F8 B0 A0 40 F0 B8 84 55 45 3C BF 4F EA 1A 44 1F FA 8A FB 80 F0 B0 84 28 46 21 46 ?? ?? ?? ?? 28 46 0F 46 21 46 ?? ?? ?? ?? 39 04 06 46 0B FB 00 F0 88 42 0A D9 11 EB 0A 01 06 F1 FF 33 04 D2 88 42 84 BF 02 3E 51 44 00 D8 1E 46 0D 1A 21 46 28 46 ?? ?? ?? ?? 28 46 0F 46 21 46 ?? ?? ?? ?? 3B 04 02 46 0B FB 00 F0 98 42 0A D9 13 EB 0A 03 02 F1 FF 31 04 D2 98 42 84 BF 02 3A 53 44 00 D8 0A 46 1D 1A 42 EA 06 41 B8 F1 00 0F 32 D1 DD E9 18 67 00 29 35 D0 B1 FA 81 F8 C8 F1 20 00 B6 EB 08 02 67 EB E8 73 18 28 CD E9 18 23 16 46 1F 46 40 F3 03 85 89 46 0D F1 F8 0B C8 F1 08 01 08 F1 18 08 29 FA 01 F1 4B F8 9C 1D 12 9C C8 F1 1F 01 58 46 02 91 00 2D 18 BF 44 F0 01 04 11 9D 12 F1 FF 32 03 94 43 F1 FF 33 8D E8 20 02 FE F7 DA FF FF F7 38 BA 18 F1 07 0F 12 DA 17 91 08 F1 20 08 8A E7 20 3E 47 F1 FF 37 CD E9 18 67 B8 F1 18 0F 17 91 81 DD 89 46 4F F0 00 08 0D F1 5C 0B 17 E0 C8 F1 18 08 89 46 B8 F1 00 0F 40 F3 62 82 0D F1 5C 0B 01 22 43 46 58 46 59 46 ?? ?? ?? ?? DD E9 18 67 17 9B C8 F1 20 02 29 FA 02 F2 13 43 17 93 32 46 3B 46 B9 E7 B5 EB 08 0C DC F1 00 02 52 EB 0C 02 BB F1 70 0F 18 BF 42 F0 01 02 00 2A 3F F4 0B A9 FF F7 D2 B9 0C 9C 61 1C 00 F0 00 83 27 34 4F F0 00 07 47 F1 00 05 0A 22 00 23 20 46 29 46 FF F7 64 B9 16 9B 3E AF 5A 1C 16 92 07 EB 83 03 43 F8 90 0C FF F7 5E BB 07 9E 04 21 95 24 00 25 0A 22 00 23 E1 FB 06 45 FF F7 4E B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 28 46 03 22 ?? ?? ?? ?? 00 28 7F F4 4F AC EB 68 05 F1 0C 07 28 2B 00 F0 3F 83 00 20 C7 F6 C0 70 0D 9C 00 2C 3F F4 B8 A9 27 60 FF F7 B5 B9 A8 F1 18 02 53 11 12 F0 1F 02 40 F0 9D 82 58 1E 07 9C 3E AD 05 EB 80 02 54 F8 23 30 1F 24 52 F8 90 5C 17 93 1A 9B 00 2B 40 F0 4D 83 07 9A 52 F8 04 1F 01 33 00 29 FA D0 11 9E E1 45 08 F1 FF 32 2C BF 4F F0 00 0C 4F F0 01 0C 01 95 83 42 AC BF 63 46 4C F0 01 03 00 96 03 93 17 A8 D3 17 02 94 FE F7 23 FF FF F7 81 B9 DD F8 68 A0 55 45 40 F2 85 82 B8 F1 00 0F 40 F3 EB 82 D8 F1 18 07 0A 97 00 F0 1D 83 0D F1 5C 0B 3B 46 01 22 58 46 59 46 ?? ?? ?? ?? 1A 9B 08 F1 20 08 9C 46 B8 F1 18 0F D8 BF 4F F0 00 0A 7F F7 F9 AA 00 24 DD E9 18 23 A2 46 FF F7 83 BB 40 F0 E3 83 00 2D 4F EA 85 01 08 DD 07 9B 07 98 0B 44 53 F8 04 2C 43 F8 04 29 83 42 F9 D1 3E AA 00 23 11 44 1A 93 AC 00 0F 93 51 F8 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "mkstemps"
		size = 36
		refs = "0020 __libc_errno 0008 __gen_tempname"
	strings:
		$1 = { 00 29 03 DB 00 22 13 46 ?? ?? ?? ?? 04 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "setrpcent"
		size = 196
		refs = "0002 .LANCHOR0 002c .LC0 0030 __nss_rpc_lookup2 0052 __nss_setent 0094 __lll_lock_wait_private 00b2 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 05 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 83 BB 23 4B ?? ?2 0? 0? ?? ?2 0? 0? 01 95 A3 F1 08 02 1D 1D 00 93 ?? ?2 0? 0? 04 3B 02 95 ?? ?2 0? 0? 00 26 03 96 1D EE 70 5F ?? ?? ?? ?? 19 4B 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 0F 4B 7B 44 1B 68 EF 50 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C7 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1029_0_0 {
	meta:
		name = "setprotoent"
		size = 196
		refs = "0002 .LANCHOR0 002c .LC0 0030 __nss_protocols_lookup2 0052 __nss_setent 0094 __lll_lock_wait_private 00b2 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 05 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 83 BB 23 4B ?? ?2 0? 0? ?? ?2 0? 0? 01 95 A3 F1 08 02 1D 1D 00 93 ?? ?2 0? 0? 04 3B 02 95 ?? ?2 0? 0? 00 26 03 96 1D EE 70 5F ?? ?? ?? ?? 19 4B 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 0F 4B 7B 44 1B 68 EF 50 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C7 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1398_0_0 {
	meta:
		name = "setservent"
		size = 196
		refs = "0002 .LANCHOR0 002c .LC0 0030 __nss_services_lookup2 0052 __nss_setent 0094 __lll_lock_wait_private 00b2 __libc_do_syscall 00bc __libc_errno"
	strings:
		$1 = { F0 B5 ?? ?2 0? 0? 85 B0 05 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 83 BB 23 4B ?? ?2 0? 0? ?? ?2 0? 0? 01 95 A3 F1 08 02 1D 1D 00 93 ?? ?2 0? 0? 04 3B 02 95 ?? ?2 0? 0? 00 26 03 96 1D EE 70 5F ?? ?? ?? ?? 19 4B 7B 44 1B 68 EF 58 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0C DC 0F 4B 7B 44 1B 68 EF 50 05 B0 F0 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C7 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E3 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_2_0 {
	meta:
		name = "__getrpcent_r"
		size = 244
		refs = "0004 .LANCHOR0 0036 .LC2 003a .LC0 003e __nss_rpc_lookup2 0078 __nss_getent_r 00c4 __lll_lock_wait_private 00e2 __libc_do_syscall 00ec __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 17 46 8B B0 81 46 88 46 1E 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 43 D1 2C 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 F1 04 0C 05 F1 08 0E 2B 1F CD F8 14 80 06 97 ?? ?2 0? 0? 07 96 ?? ?2 0? 0? 00 95 ?? ?2 0? 0? 00 25 CD F8 10 90 CD F8 04 C0 1D EE 70 6F CD F8 08 E0 03 95 08 95 ?? ?? ?? ?? 1B 4B 7B 44 1B 68 56 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 46 F8 03 80 0B B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B4 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1029_2_0 {
	meta:
		name = "__getprotoent_r"
		size = 244
		refs = "0004 .LANCHOR0 0036 .LC2 003a .LC0 003e __nss_protocols_lookup2 0078 __nss_getent_r 00c4 __lll_lock_wait_private 00e2 __libc_do_syscall 00ec __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 17 46 8B B0 81 46 88 46 1E 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 43 D1 2C 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 F1 04 0C 05 F1 08 0E 2B 1F CD F8 14 80 06 97 ?? ?2 0? 0? 07 96 ?? ?2 0? 0? 00 95 ?? ?2 0? 0? 00 25 CD F8 10 90 CD F8 04 C0 1D EE 70 6F CD F8 08 E0 03 95 08 95 ?? ?? ?? ?? 1B 4B 7B 44 1B 68 56 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 46 F8 03 80 0B B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B4 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1398_2_0 {
	meta:
		name = "__getservent_r"
		size = 244
		refs = "0004 .LANCHOR0 0036 .LC2 003a .LC0 003e __nss_services_lookup2 0078 __nss_getent_r 00c4 __lll_lock_wait_private 00e2 __libc_do_syscall 00ec __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 17 46 8B B0 81 46 88 46 1E 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 43 D1 2C 4D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 F1 04 0C 05 F1 08 0E 2B 1F CD F8 14 80 06 97 ?? ?2 0? 0? 07 96 ?? ?2 0? 0? 00 95 ?? ?2 0? 0? 00 25 CD F8 10 90 CD F8 04 C0 1D EE 70 6F CD F8 08 E0 03 95 08 95 ?? ?? ?? ?? 1B 4B 7B 44 1B 68 56 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 51 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 46 F8 03 80 0B B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? B4 E7 A6 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "tmpfile64"
		size = 102
		refs = "0008 .LC0 001a __path_search 002a __gen_tempname 0034 __unlink 0038 .LC1 0042 _IO_fdopen 005e __close"
	strings:
		$1 = { 30 B5 AD F5 80 5D 83 B0 ?? ?2 0? 0? 00 22 02 A8 00 92 ?? ?2 0? 0? 4F F4 80 51 ?? ?? ?? ?? C0 B9 01 46 4F F4 00 32 02 A8 0B 46 ?? ?? ?? ?? 05 1E 0F DB 02 A8 ?? ?? ?? ?? ?? ?2 0? 0? 28 46 ?? ?2 0? 0? ?? ?? ?? ?? 04 46 44 B1 0D F5 80 5D 03 B0 30 BD 00 20 0D F5 80 5D 03 B0 30 BD 28 46 ?? ?? ?? ?? 20 46 F1 E7 }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "__fcntl_nocancel"
		size = 64
		refs = "0014 __libc_do_syscall 003c __libc_errno"
	strings:
		$1 = { 0E B4 4F F0 DD 0C 00 B5 82 B0 03 AB 04 9A 53 F8 04 1B 01 93 ?? ?? ?? ?? 10 F5 80 5F 04 D8 02 B0 5D F8 04 EB 03 B0 70 47 04 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_0_3 {
	meta:
		name = "__fcntl_nocancel"
		size = 64
		refs = "0014 __libc_do_syscall 003c errno"
	strings:
		$1 = { 0E B4 4F F0 DD 0C 00 B5 82 B0 03 AB 04 9A 53 F8 04 1B 01 93 ?? ?? ?? ?? 10 F5 80 5F 04 D8 02 B0 5D F8 04 EB 03 B0 70 47 04 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_376_1_0 {
	meta:
		name = "__libc_fcntl"
		size = 156
		refs = "0002 __libc_multiple_threads 0024 __libc_do_syscall 0044 __libc_enable_asynccancel 0062 __libc_disable_asynccancel 0094 __libc_errno"
	strings:
		$1 = { 0E B4 ?? ?2 0? 0? 30 B5 84 B0 07 AB ?? ?2 0? 0? 04 46 53 F8 04 1B 10 68 08 9A 03 93 60 B9 20 46 4F F0 DD 0C ?? ?? ?? ?? 10 F5 80 5F 1D D8 04 B0 BD E8 30 40 03 B0 70 47 0E 29 01 D0 07 29 EE D1 8D E8 06 00 ?? ?? ?? ?? 9D E8 06 00 4F F0 DD 0C 05 46 20 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0E D8 28 46 ?? ?? ?? ?? 20 46 E1 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 D7 E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E6 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_1_3 {
	meta:
		name = "__libc_fcntl"
		size = 156
		refs = "0002 __pthread_multiple_threads 0024 __libc_do_syscall 0044 __pthread_enable_asynccancel 0062 __pthread_disable_asynccancel 0094 errno"
	strings:
		$1 = { 0E B4 ?? ?2 0? 0? 30 B5 84 B0 07 AB ?? ?2 0? 0? 04 46 53 F8 04 1B 10 68 08 9A 03 93 60 B9 20 46 4F F0 DD 0C ?? ?? ?? ?? 10 F5 80 5F 1D D8 04 B0 BD E8 30 40 03 B0 70 47 0E 29 01 D0 07 29 EE D1 8D E8 06 00 ?? ?? ?? ?? 9D E8 06 00 4F F0 DD 0C 05 46 20 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0E D8 28 46 ?? ?? ?? ?? 20 46 E1 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 D7 E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E6 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "__aeabi_errno_addr"
		size = 20
		refs = "0010 __libc_errno"
		altNames = "__errno_location"
	strings:
		$1 = { 03 4B 1D EE 70 0F 7B 44 1B 68 18 44 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_946_0_0 {
	meta:
		name = "__ctype_b_loc"
		size = 20
		refs = "0010 .LANCHOR0"
	strings:
		$1 = { 03 4B 1D EE 70 0F 7B 44 1B 68 18 44 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_0_3 {
	meta:
		name = "__errno_location"
		size = 20
		refs = "0010 errno"
	strings:
		$1 = { 03 4B 1D EE 70 0F 7B 44 1B 68 18 44 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_934_0_0 {
	meta:
		name = "__h_errno_location"
		size = 20
		refs = "0010 __libc_h_errno"
	strings:
		$1 = { 03 4B 1D EE 70 0F 7B 44 1B 68 18 44 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_3 {
	meta:
		name = "__h_errno_location"
		size = 20
		refs = "0010 h_errno"
	strings:
		$1 = { 03 4B 1D EE 70 0F 7B 44 1B 68 18 44 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "xdr_pmap"
		size = 56
		refs = "0006 xdr_u_long"
	strings:
		$1 = { 38 B5 05 46 0C 46 ?? ?? ?? ?? 08 B9 00 20 38 BD 28 46 21 1D ?? ?? ?? ?? 00 28 F7 D0 28 46 04 F1 08 01 ?? ?? ?? ?? 00 28 F0 D0 28 46 04 F1 0C 01 BD E8 38 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "do_encoding"
		size = 26
	strings:
		$1 = { 43 6A 5A 6B 32 B9 58 6A 9B 6A 98 42 0C BF 18 46 00 20 70 47 4F F0 FF 30 70 47 }
	condition:
		$1
}

rule file_379_3_0 {
	meta:
		name = "do_in"
		size = 112
		refs = "0020 _dl_mcount_wrapper_check"
	strings:
		$1 = { 2D E9 F0 44 86 B0 04 46 06 AD 0D 9E 9A 46 0E 98 67 6A E1 63 E0 62 A6 62 7E 69 45 F8 04 2D 30 46 ?? ?? ?? ?? 2A 46 38 46 00 25 53 46 04 F1 28 01 04 AF 00 95 02 95 03 95 01 97 B0 47 05 9B 0C 9A 13 60 0F 9A A3 6A 13 60 07 28 0D D8 DF E8 00 F0 08 0C 0C 0C 08 04 0C 04 01 20 06 B0 BD E8 F0 84 00 20 06 B0 BD E8 F0 84 02 20 06 B0 BD E8 F0 84 }
	condition:
		$1
}

rule file_379_4_0 {
	meta:
		name = "do_unshift"
		size = 88
		refs = "0014 _dl_mcount_wrapper_check"
	strings:
		$1 = { F0 B5 04 46 07 6D 87 B0 42 65 05 AE 83 65 81 66 7D 69 28 46 ?? ?? ?? ?? 00 21 0A 46 0B 46 38 46 00 91 03 91 01 27 04 F1 54 01 01 96 02 97 A8 47 63 6D 0C 9A 13 60 07 28 0B D8 DF E8 00 F0 07 0A 0A 0A 07 04 0A 04 01 20 07 B0 F0 BD 00 20 07 B0 F0 BD 02 20 07 B0 F0 BD }
	condition:
		$1
}

rule file_379_5_0 {
	meta:
		name = "do_out"
		size = 112
		refs = "0020 _dl_mcount_wrapper_check"
	strings:
		$1 = { 2D E9 F0 44 86 B0 04 46 06 AD 0D 9E 9A 46 0E 98 27 6D A1 66 A0 65 66 65 7E 69 45 F8 04 2D 30 46 ?? ?? ?? ?? 2A 46 38 46 00 25 53 46 04 F1 54 01 04 AF 00 95 02 95 03 95 01 97 B0 47 05 9B 0C 9A 13 60 0F 9A 63 6D 13 60 07 28 0D D8 DF E8 00 F0 08 0C 0C 0C 08 04 0C 04 01 20 06 B0 BD E8 F0 84 00 20 06 B0 BD E8 F0 84 02 20 06 B0 BD E8 F0 84 }
	condition:
		$1
}

rule file_379_6_0 {
	meta:
		name = "do_length"
		size = 100
		refs = "003c _dl_mcount_wrapper_check"
	strings:
		$1 = { 2D E9 F0 47 86 B0 04 AF 9A 46 07 F1 08 05 BE 6A 90 46 D0 F8 24 90 04 46 45 F8 08 2D 3D 1D B6 00 C1 63 06 F1 0A 03 23 F0 07 03 AD EB 03 0D 04 AA 82 62 16 44 C6 62 D9 F8 14 60 30 46 ?? ?? ?? ?? 3A 46 04 F1 28 01 48 46 00 24 53 46 8D E8 30 00 02 94 03 94 B0 47 38 68 08 37 C8 EB 00 00 BD 46 BD E8 F0 87 }
	condition:
		$1
}

rule file_379_7_0 {
	meta:
		name = "_IO_fwide"
		size = 380
		refs = "0072 __wcsmbs_clone_conv 0088 .LANCHOR0 008c memset 009a do_unshift 00a6 do_out 00ac do_in 00b2 do_encoding 00ba do_always_noconv 00c8 do_length 00ce do_max_length 0136 .LC0 013a .LC1 013e __PRETTY_FUNCTION__.13885 0150 __assert_fail 0154 .LC2"
	strings:
		$1 = { 00 29 2D E9 F0 43 06 46 87 B0 C4 6E C0 F2 B1 80 00 2C 40 F0 8C 80 00 29 00 F0 89 80 C5 6D 02 A8 05 F1 3C 08 C6 F8 58 80 69 68 85 F8 2C 40 85 F8 2D 40 85 F8 2E 40 85 F8 2F 40 85 F8 30 40 85 F8 31 40 85 F8 32 40 85 F8 33 40 EA 68 F3 6D 29 60 2A 61 83 F8 34 40 83 F8 35 40 83 F8 36 40 83 F8 37 40 83 F8 38 40 83 F8 39 40 83 F8 3A 40 83 F8 3B 40 ?? ?? ?? ?? 03 9B 01 2B 5C D1 05 9F 01 2F 68 D1 21 46 40 46 78 22 ?? ?2 0? 0? ?? ?? ?? ?? 02 9B 04 9A ?? ?2 0? 0? EF 65 ?? ?2 0? 0? 2B 66 ?? ?2 0? 0? 6F 67 ?? ?2 0? 0? EF 66 ?? ?2 0? 0? F1 6D ?? ?2 0? 0? C5 F8 88 70 ?? ?2 0? 0? C5 F8 A0 70 2C 31 C5 F8 98 70 ?? ?2 0? 0? A9 67 ?? ?2 0? 0? C5 F8 8C 20 ?? ?2 0? 0? F2 6D ?? ?2 0? 0? C5 F8 B0 90 ?? ?2 0? 0? 2C 32 C5 F8 A4 20 F2 6D ?? ?2 0? 0? C5 F8 44 C0 ?? ?2 0? 0? ?? ?2 0? 0? C5 F8 40 80 D2 F8 B8 C0 00 22 A8 64 30 46 EB 64 00 23 6C 65 3C 46 A9 65 C5 F8 50 E0 C6 F8 98 C0 00 97 DC F8 40 10 88 47 C6 E9 14 01 F4 66 20 46 07 B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8A 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8B 22 ?? ?? ?? ?? 00 2C DB D1 4F F0 FF 34 D7 E7 }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "__libc_waitpid"
		size = 124
		refs = "0002 __libc_multiple_threads 0018 __libc_do_syscall 0024 __libc_enable_asynccancel 0044 __libc_disable_asynccancel 0074 __libc_errno"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? ?? ?2 0? 0? 06 46 0D 46 14 46 1B 68 3B B9 4F F0 72 0C ?? ?? ?? ?? 10 F5 80 5F 14 D8 F8 BD ?? ?? ?? ?? 29 46 22 46 00 23 4F F0 72 0C 07 46 30 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0E D8 38 46 ?? ?? ?? ?? 20 46 EA E7 09 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F8 BD 05 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E6 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_0_3 {
	meta:
		name = "__libc_waitpid"
		size = 124
		refs = "0002 __pthread_multiple_threads 0018 __libc_do_syscall 0024 __pthread_enable_asynccancel 0044 __pthread_disable_asynccancel 0074 errno"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? ?? ?2 0? 0? 06 46 0D 46 14 46 1B 68 3B B9 4F F0 72 0C ?? ?? ?? ?? 10 F5 80 5F 14 D8 F8 BD ?? ?? ?? ?? 29 46 22 46 00 23 4F F0 72 0C 07 46 30 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0E D8 38 46 ?? ?? ?? ?? 20 46 EA E7 09 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F8 BD 05 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E6 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "posix_spawn_file_actions_adddup2"
		size = 88
		refs = "000a __sysconf 004a __posix_spawn_file_actions_realloc"
	strings:
		$1 = { F8 B5 0C 46 15 46 06 46 04 20 ?? ?? ?? ?? 54 EA 05 03 01 D5 09 20 F8 BD 85 42 B8 BF 84 42 F9 DA 96 E8 0C 00 93 42 0F D0 03 EB 83 01 D6 F8 08 C0 5F 1C 00 20 89 00 01 23 0C EB 01 02 4C F8 01 30 54 60 95 60 77 60 F8 BD 30 46 ?? ?? ?? ?? 08 B1 0C 20 F8 BD 73 68 E7 E7 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "wcschr"
		size = 22
	strings:
		$1 = { 02 46 50 F8 04 3B 8B 42 03 D0 00 2B F8 D1 18 46 70 47 10 46 70 47 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "clnt_create"
		size = 448
		refs = "000a .LC0 001a strcmp 002a memset 003a strcpy 0056 clntunix_create 00a0 __gethostbyname_r 00c4 __rpc_thread_createerr 00fe memcpy 011e __getprotobyname_r 0188 clntudp_create 01a0 clnttcp_create 01b8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F AF B0 8B 46 02 AF ?? ?2 0? 0? 04 46 ?? ?2 0? 0? 18 46 99 46 7A 60 ?? ?? ?? ?? 05 46 08 BB 01 46 6E 22 07 F1 40 00 ?? ?? ?? ?? 21 46 07 F1 42 00 01 23 A7 F8 40 30 ?? ?? ?? ?? 07 F1 B0 03 00 95 01 95 07 F1 40 00 59 46 7A 68 4F F0 FF 34 43 F8 9C 4D ?? ?? ?? ?? 03 46 18 46 B4 37 BD 46 BD E8 F0 8F AD F5 81 6D 4F F4 80 6A 02 AA 07 F1 0C 06 07 F1 18 05 DF F8 3C 81 08 E0 43 46 7B 44 1B 68 CB 58 22 2B 1C D1 AD EB 02 0D 02 AA 53 46 07 F1 40 01 00 96 20 46 01 95 4F EA 4A 0A ?? ?? ?? ?? 0A F1 0E 02 1D EE 70 1F 22 F0 07 02 03 46 20 B9 D7 F8 0C E0 BE F1 00 0F 0C D1 BB 69 01 33 DC D0 ?? ?? ?? ?? 00 23 0D 22 B4 37 02 60 18 46 BD 46 BD E8 F0 8F DE F8 08 50 02 2D 39 D1 F8 63 07 F1 34 00 DE F8 10 10 4F F4 80 64 BB 63 07 F1 10 06 DE F8 0C 20 09 68 3D 86 7B 86 ?? ?? ?? ?? AD F5 81 6D DF F8 B4 80 02 AA 02 E0 AD EB 03 0D 02 AA 23 46 00 96 48 46 07 F1 24 01 ?? ?? ?? ?? 64 00 04 F1 0E 03 1D EE 70 2F 23 F0 07 03 05 46 08 B9 39 69 B1 B9 41 46 79 44 09 68 52 58 22 2A E4 D0 ?? ?? ?? ?? 11 23 60 22 03 60 00 23 82 60 83 E7 38 60 ?? ?? ?? ?? 3B 68 0C 21 61 22 01 60 82 60 7A E7 8B 68 4F F0 FF 32 7A 61 06 2B 0E D0 11 2B 18 D1 00 90 05 23 07 F1 14 00 59 46 01 90 07 F1 30 00 7A 68 ?? ?? ?? ?? 03 46 65 E7 00 90 07 F1 14 03 01 90 59 46 7A 68 07 F1 30 00 ?? ?? ?? ?? 03 46 59 E7 ?? ?? ?? ?? 0C 21 60 22 2B 46 01 60 82 60 51 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "__statvfs_getflags"
		size = 1212
		refs = "005a .LC6 009e .LC14 00dc .LC10 011a .LC22 0128 .LC26 012c .LC25 0138 __setmntent 016a .LC4 0196 .LC9 01c2 .LC8 01ce .LC24 01fe __getmntent_r 020e strcmp 023a __xstat64 0264 strchr 02a6 .LC5 02b6 .LC20 02c6 .LC11 02d6 .LC23 02e2 .LC0 02e6 .LC1 02ea .LC2 0300 .LC3 0310 .LC17 0320 .LC7 0330 .LC12 0340 .LC16 034c .LC27 0366 __endmntent 0374 .LC28 03a4 rewind 03aa .LC29 03cc .LC30 03e2 .LC31 03f8 .LC32 040e .LC33 0424 .LC34 044e .LC19 0462 .LC18 0472 .LC15 0482 .LC13 0492 .LC21 049e .LC35 04a2 .LC36 04a6 __PRETTY_FUNCTION__.10524 04b8 __assert_fail"
	strings:
		$1 = { 2D E9 F0 4E 93 46 AD F5 90 6D 06 46 00 2A 00 F0 98 80 49 F2 60 63 99 42 00 F0 29 82 25 DD 4F F4 3D 63 C0 F6 D0 33 99 42 00 F0 31 82 4F F4 3D 63 C0 F6 D0 33 99 42 3A DC 4E F6 53 73 99 42 00 F0 50 81 00 F3 83 80 49 F6 A0 73 99 42 00 F0 29 81 02 33 99 42 01 BF 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 00 F0 B3 80 9B E0 4E F6 49 03 CF F6 95 13 99 42 00 F0 03 82 37 DD 41 F6 D1 43 99 42 00 F0 3C 81 00 F3 92 80 40 F2 87 13 99 42 00 F0 45 81 41 F2 73 33 99 42 01 BF 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 00 F0 91 80 79 E0 45 F2 4E 43 C5 F2 46 33 99 42 00 F0 28 81 5C DC 44 F2 4A 63 C3 F2 53 13 99 42 00 F0 30 81 44 F6 73 13 C5 F2 65 23 99 42 01 BF 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 72 D0 5B E0 48 F2 68 13 CC F6 7E 13 99 42 00 F0 B3 81 40 F3 A1 81 48 F2 E4 13 CD F6 5E 63 99 42 00 F0 E4 80 42 F2 10 03 CF F2 F5 23 99 42 01 BF 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 53 D0 3C E0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 81 46 00 28 52 D1 00 20 0D F5 90 6D BD E8 F0 8E 4E F2 EB 03 C0 F2 27 03 99 42 00 F0 AC 80 41 F6 94 13 C0 F2 02 13 99 42 01 BF 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 2B D0 14 E0 45 F2 42 33 C5 F6 46 03 99 42 00 F0 9E 80 46 F2 72 53 C6 F2 65 23 99 42 01 BF 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 15 D0 4F F0 00 0A 57 46 55 46 10 E0 44 F6 44 53 99 42 00 F0 C3 80 46 F6 69 13 99 42 01 BF 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? E9 D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 81 46 00 28 9F D0 D9 F8 00 30 43 F4 00 43 C9 F8 00 30 48 46 69 46 20 AA 4F F4 80 63 ?? ?? ?? ?? 00 28 00 F0 C1 80 2E B1 30 46 01 99 ?? ?? ?? ?? 00 28 EE D1 6D B1 02 9C 28 46 21 46 ?? ?? ?? ?? 38 B1 00 2F 32 D0 38 46 21 46 ?? ?? ?? ?? 00 28 2C D1 03 20 01 99 06 AA ?? ?? ?? ?? 00 28 D8 DB DB E9 00 01 DD E9 06 23 99 42 08 BF 90 42 D0 D1 03 9C 26 46 00 2C 00 F0 84 80 00 26 37 46 20 46 2C 21 ?? ?? ?? ?? 05 46 08 B1 45 1C 07 70 23 78 72 2B 6A D1 63 78 6F 2B 67 D1 A3 78 00 2B 64 D1 46 F0 01 06 00 2D 6C D0 2C 46 E8 E7 BA F1 00 0F AF D0 21 46 50 46 ?? ?? ?? ?? 00 28 A9 D1 C8 E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 8D E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 85 E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 7D E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 75 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 68 E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 60 E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 58 E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 50 E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 48 E7 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 40 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 58 B9 46 F0 02 06 00 2D 92 D1 48 46 ?? ?? ?? ?? 30 46 0D F5 90 6D BD E8 F0 8E ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 90 B9 46 F0 08 06 7D E7 33 1C 18 BF 01 23 00 2D 0C BF 1E 46 43 F0 01 06 00 2E E2 D0 7B B1 48 46 00 26 ?? ?? ?? ?? 24 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 40 B9 46 F0 04 06 62 E7 00 2D 6C D0 9A 46 1F 46 1D 46 E9 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 10 B9 46 F0 10 06 51 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 10 B9 46 F0 40 06 46 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 10 B9 46 F4 80 66 3B E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 10 B9 46 F4 00 66 30 E7 ?? ?2 0? 0? 20 46 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 7F F4 27 AF 46 F4 80 56 23 E7 46 F6 3E 03 C9 F2 23 13 99 42 01 BF 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 3F F4 B9 AE A1 E6 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? AF E6 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? A7 E6 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 9F E6 4F F0 00 0A ?? ?2 0? 0? 57 46 ?? ?2 0? 0? 97 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CD 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_386_1_0 {
	meta:
		name = "__internal_statvfs"
		size = 122
		refs = "004e memset 0070 __statvfs_getflags"
	strings:
		$1 = { 2D E9 F0 47 0C 46 97 68 90 46 56 68 99 46 D8 F8 14 30 00 25 A7 60 82 46 D7 68 29 46 18 22 04 F1 30 00 E7 60 D8 F8 10 70 63 61 D8 F8 28 30 27 61 D8 F8 18 70 AB 42 08 BF 33 46 26 60 D8 F8 24 60 A7 61 D8 F8 1C 70 63 60 E6 62 27 62 65 62 ?? ?? ?? ?? A2 69 D8 F8 2C 30 E2 61 9A 06 04 D5 83 F0 20 03 A3 62 BD E8 F0 87 50 46 D8 F8 00 10 4A 46 ?? ?? ?? ?? A0 62 BD E8 F0 87 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "ftok"
		size = 48
		refs = "000e __xstat64"
	strings:
		$1 = { 03 46 03 20 10 B5 9A B0 0C 46 6A 46 19 46 ?? ?? ?? ?? 00 28 B1 BF 4F F0 FF 30 9D F8 00 00 BD F8 60 30 43 EA 00 40 A8 BF 40 EA 04 60 1A B0 10 BD }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "__funlockfile"
		size = 78
		refs = "0048 __libc_do_syscall"
	strings:
		$1 = { 80 6C 10 B5 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 00 DC 10 BD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? F1 E7 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "call_dl_lookup"
		size = 42
		refs = "0020 _dl_lookup_symbol_x"
	strings:
		$1 = { F0 B5 04 46 03 68 85 B0 86 68 00 25 C7 68 19 46 62 69 D3 F8 CC 31 40 68 00 96 02 97 01 95 03 95 ?? ?? ?? ?? 20 60 05 B0 F0 BD }
	condition:
		$1
}

rule file_389_1_0 {
	meta:
		name = "do_sym"
		size = 484
		refs = "0016 _dl_find_dso_for_object 0040 _dl_lookup_symbol_x 0064 _dl_ns 00d6 _dl_hwcap 00e8 call_dl_lookup 0120 _dl_catch_error 015c __libc_do_syscall 016c strlen 0182 memcpy 01ae free 01ba _dl_signal_error 01d4 .LC0"
	strings:
		$1 = { 2D E9 F0 4F 8F B0 04 AF 04 46 10 46 16 46 88 46 99 46 00 23 7B 60 ?? ?? ?? ?? 05 46 00 28 3D D0 00 2C 42 D0 63 1C 1D D0 3A 6D 21 46 04 F5 E8 73 CD F8 00 90 00 24 40 46 02 92 3A 1D 01 94 03 94 ?? ?? ?? ?? 7B 68 43 B1 00 B1 00 68 1A 7B 5B 68 02 F0 0F 02 0A 2A 03 44 3D D0 18 46 2C 37 BD 46 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 9D 42 00 F0 A5 80 2B 46 00 E0 13 46 D3 F8 6C 21 00 2A FA D1 01 92 40 46 02 92 29 46 CD F8 00 90 03 F5 E8 73 03 95 3A 1D ?? ?? ?? ?? D3 E7 ?? ?2 0? 0? ?? ?2 0? 0? 1D 68 00 2C BC D1 1D EE 70 AF AA F5 98 66 33 68 B3 B9 3A 6D 40 46 D5 F8 CC 31 29 46 01 94 03 94 42 F0 01 04 CD F8 00 90 3A 1D 02 94 ?? ?? ?? ?? B6 E7 ?? ?2 0? 0? ?? ?2 0? 0? 10 68 98 47 BB E7 39 6D B3 46 ?? ?2 0? 0? 3D 61 41 F0 05 02 C7 F8 14 80 FA 61 01 20 C7 F8 18 90 39 1D 4B F8 04 0F 07 F1 10 02 79 62 ?? ?2 0? 0? BF F3 5F 8F 07 F1 08 00 00 92 07 F1 0C 01 FA 1C FC 60 ?? ?? ?? ?? AA F2 BC 4A 05 46 DA F8 00 30 BF F3 5F 8F 5B E8 00 2F 9A 42 03 D1 4B E8 00 41 00 29 F7 D1 93 42 BF F3 5F 8F EF D1 02 2B 08 D1 B1 68 01 22 58 46 00 23 11 43 4F F0 F0 0C ?? ?? ?? ?? FC 68 38 69 00 2C 3F F4 6D AF 20 46 ?? ?? ?? ?? 21 46 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 04 A8 ?? ?? ?? ?? BE 68 80 46 30 46 ?? ?? ?? ?? 31 46 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 04 A8 ?? ?? ?? ?? FB 78 06 46 13 B1 20 46 ?? ?? ?? ?? 28 46 31 46 43 46 00 22 ?? ?? ?? ?? 45 B1 D5 F8 AC 31 9E 42 04 D3 D5 F8 B0 31 9E 42 FF F4 51 AF 00 20 ?? ?2 0? 0? 01 46 02 46 ?? ?2 0? 0? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_389_2_0 {
	meta:
		name = "_dl_vsym"
		size = 96
	strings:
		$1 = { 70 B5 86 B0 14 78 01 25 02 92 04 95 F4 B1 55 78 E5 B1 96 78 05 EB 04 14 C6 B1 D5 78 06 EB 04 14 A5 B1 16 79 05 EB 04 14 86 B1 55 79 06 EB 04 14 05 32 4D B1 05 EB 04 14 12 F8 01 5F 04 F0 70 46 84 EA 16 64 00 2D F5 D1 24 F0 70 44 1A 46 00 25 02 AB 00 95 03 94 05 95 FF F7 E0 FE 06 B0 70 BD }
	condition:
		$1
}

rule file_389_3_0 {
	meta:
		name = "_dl_sym"
		size = 18
	strings:
		$1 = { 10 B5 82 B0 02 24 00 23 00 94 FF F7 D7 FE 02 B0 10 BD }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "_openchild"
		size = 224
		refs = "000c __pipe 001e __fork 002a __close 002e stderr 0038 __dup 004a _IO_fflush 004e _rpc_dtablesize 0070 execlp 0074 .LC0 007c perror 0084 _exit 0088 .LC1 0092 _IO_fdopen 009e .LC2"
	strings:
		$1 = { F0 B5 85 B0 07 46 68 46 0E 46 15 46 ?? ?? ?? ?? 00 28 62 DB 02 A8 ?? ?? ?? ?? 00 28 53 DB ?? ?? ?? ?? 43 1C 04 46 48 D0 70 BB ?? ?? ?? ?? ?? ?2 0? 0? 00 98 ?? ?2 0? 0? ?? ?? ?? ?? 01 20 ?? ?? ?? ?? 03 98 ?? ?? ?? ?? 28 68 ?? ?? ?? ?? ?? ?? ?? ?? 44 1E 02 2C 05 DD 20 46 01 3C ?? ?? ?? ?? 02 2C F9 D1 28 68 ?? ?? ?? ?? 39 46 00 22 38 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 4F F0 FF 30 ?? ?? ?? ?? ?? ?2 0? 0? 01 98 ?? ?2 0? 0? ?? ?? ?? ?? 30 60 00 98 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 02 98 ?? ?? ?? ?? 28 60 03 98 ?? ?? ?? ?? 20 46 05 B0 F0 BD 02 98 ?? ?? ?? ?? 03 98 ?? ?? ?? ?? 00 98 ?? ?? ?? ?? 01 98 ?? ?? ?? ?? 4F F0 FF 30 05 B0 F0 BD 4F F0 FF 30 EA E7 }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "strrchr"
		size = 162
	strings:
		$1 = { 03 46 4F F0 00 00 C9 B2 13 F0 07 0F 0A D0 13 F8 01 2B 8A 42 08 BF 58 1E 00 2A 08 BF 70 47 13 F0 07 0F F4 D1 F0 B4 41 EA 01 21 40 F2 01 1C C0 F2 01 1C 41 EA 01 41 4F F0 00 02 F3 E8 02 45 CC FA 54 F6 CC FA 55 F7 84 EA 01 04 85 EA 01 05 CC FA 54 F4 CC FA 55 F5 00 2E 0F D1 00 2C 1C BF A3 F1 08 00 22 46 00 2F 04 D1 00 2D 1C BF 18 1F 2A 46 E3 E7 03 F1 04 03 2C 46 3E 46 A3 F1 08 03 A6 F1 01 07 86 EA 07 06 34 40 1C BF 22 46 18 46 F0 BC 00 2A B2 FA 82 F2 1C BF C2 F1 20 02 00 EB D2 00 70 47 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "__gettext_extract_plural"
		size = 188
		refs = "000e .LC0 0016 strstr 001a .LC1 0068 .LANCHOR0 008c strtoul 00a6 __gettextparse 00b8 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 47 89 46 84 B0 90 46 04 46 60 B3 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 82 46 20 46 ?? ?? ?? ?? BA F1 00 0F 18 BF 00 28 19 D0 43 7A 00 F1 09 06 AB B1 1E 4A 1D EE 70 1F 7A 44 12 68 8F 58 37 F8 13 20 91 04 17 D5 00 F1 0A 04 03 E0 37 F8 13 50 AA 04 10 D5 26 46 14 F8 01 3B 00 2B F6 D1 ?? ?2 0? 0? 02 22 ?? ?2 0? 0? C9 F8 00 30 C8 F8 00 20 04 B0 BD E8 F0 87 30 3B 09 2B F0 D8 30 46 01 A9 0A 22 ?? ?? ?? ?? 01 9B 9E 42 E8 D0 04 AB 0A F1 07 02 C8 F8 00 00 43 F8 08 2D 18 46 ?? ?? ?? ?? 00 28 DC D1 03 9B C9 F8 00 30 E1 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_394_0_0 {
	meta:
		name = "basename"
		size = 20
		refs = "0006 strrchr"
	strings:
		$1 = { 10 B5 2F 21 04 46 ?? ?? ?? ?? 08 B1 01 30 10 BD 20 46 10 BD }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "__gai_sigqueue"
		size = 88
		refs = "0010 memset 001e __getuid 0030 __libc_do_syscall 0054 __libc_errno"
	strings:
		$1 = { 70 B5 A0 B0 04 46 0D 46 16 46 00 21 80 22 68 46 ?? ?? ?? ?? 6F F0 3B 03 03 96 00 94 02 93 ?? ?? ?? ?? 05 95 21 46 6A 46 4F F0 B2 0C 04 90 03 98 ?? ?? ?? ?? 10 F5 80 5F 01 D8 20 B0 70 BD 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "____wcstoll_l_internal"
		size = 1088
		refs = "0036 __iswspace_l 0072 __strtol_ull_max_tab 0076 __strtol_ull_rem_tab 0086 __strtol_ul_max_tab 0178 __iswalpha_l 0188 __towupper_l 03ce __correctly_grouped_prefixwc 03e4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 8F B0 17 46 1D 46 DD F8 60 80 99 46 0A 90 05 91 D8 F8 04 20 00 2B 40 F0 A3 81 01 2F 00 F0 93 80 24 2F 00 F2 90 80 0A 9C A2 46 41 46 04 34 DA F8 00 00 ?? ?? ?? ?? 00 28 F6 D1 DA F8 00 30 52 46 00 2B 00 F0 45 81 2D 2B 00 F0 CA 80 2B 2B 0B 90 04 BF A2 46 53 68 30 2B 00 F0 AA 80 00 2F 7E D0 0A 2F 7C D0 B8 1E 00 22 0D 93 93 46 04 92 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 01 EB C0 01 ?? ?2 0? 0? 12 5C ?? ?2 0? 0? D1 E9 00 45 53 F8 20 C0 0C 92 CD E9 06 45 0D 9D 00 2D 00 F0 56 81 D3 45 00 F0 4D 81 00 22 55 46 CD F8 20 A0 92 46 CD F8 08 80 E0 46 0D 9C 0D E0 04 9B 4C 45 14 BF 00 23 03 F0 01 03 00 2B 51 D0 6C 68 35 46 9C B1 B3 45 00 F0 89 80 A4 F1 30 00 2E 1D 09 28 EC D8 B8 42 80 F2 8A 80 D0 45 40 F2 91 80 6C 68 35 46 07 FB 0A 0A 00 2C EB D1 52 46 DD F8 20 A0 DD F8 08 80 03 94 02 92 00 25 B2 45 00 F0 E2 80 05 9C 04 B1 26 60 00 2D 38 D1 0B 9D 00 2D 00 F0 74 81 DD E9 02 01 B1 F1 00 4F 08 BF 01 28 80 F0 61 81 DD E9 02 45 64 42 65 EB 45 05 20 46 29 46 0F B0 BD E8 F0 8F A6 4B 00 20 1D EE 70 2F 01 46 7B 44 1B 68 16 24 D4 50 0F B0 BD E8 F0 8F 0D 93 00 2D 40 F0 0E 81 04 95 08 20 AB 46 0A 27 7E E7 02 99 20 46 ?? ?? ?? ?? 02 99 03 46 20 46 00 2B 00 F0 D3 80 ?? ?? ?? ?? 37 38 AA E7 95 4B 1D EE 70 2F 0B 9C 22 21 7B 44 1B 68 4F F0 FF 30 D1 50 6F F0 00 41 00 2C D7 D0 00 20 4F F0 00 41 D3 E7 37 F0 10 00 7F F4 54 AF DA F8 04 00 41 46 ?? ?? ?? ?? 58 28 02 BF 0A F1 08 0A 0E 20 10 27 04 D0 00 2F 40 F0 17 81 06 20 08 27 DA F8 00 30 42 E7 A2 46 53 68 01 24 0B 94 35 E7 52 46 DD F8 08 80 00 20 DD F8 20 A0 02 92 03 90 85 E7 52 46 DD F8 08 80 00 21 DD F8 20 A0 02 92 2E 46 03 91 7B E7 52 46 DD F8 08 80 DD F8 20 A0 14 46 2E 46 00 25 CD E9 02 45 00 25 CD F8 34 A0 3A 46 DD F8 10 A0 FB 17 CD F8 10 80 A8 46 DD E9 02 45 CD E9 08 23 09 9B D4 46 08 99 CA 46 B9 46 04 FB 03 F2 01 FB 05 22 A4 FB 01 45 15 44 24 18 45 F1 00 05 56 F8 04 7F 00 2F 55 D0 5E 45 5B D0 A7 F1 30 00 09 28 15 D9 57 45 14 BF 00 23 0C F0 01 03 00 2B EE D1 38 46 04 99 CD F8 04 C0 ?? ?? ?? ?? 00 28 40 D0 38 46 04 99 ?? ?? ?? ?? DD F8 04 C0 37 38 48 45 37 DA DD E9 06 23 AB 42 08 BF A2 42 0D D3 9D 42 08 BF 94 42 0C 9A 14 BF 00 23 01 23 90 42 94 BF 00 23 03 F0 01 03 00 2B 37 D0 4F F0 01 08 C6 E7 DD F8 28 A0 05 9C 00 2C 3F D0 0A 9D C5 EB 0A 03 07 2B 05 DC 0A 9C 00 20 05 9D 01 46 2C 60 33 E7 41 46 5A F8 04 0C ?? ?? ?? ?? 58 28 F2 D1 5A F8 08 3C 30 2B EE D1 00 20 AA F1 04 03 01 46 23 60 22 E7 CD E9 02 45 45 46 DD F8 34 A0 DD F8 10 80 F3 E6 CD E9 02 45 45 46 F2 E6 52 46 88 46 DD F8 20 A0 2E 46 02 92 03 93 E6 E6 4F 46 D1 46 E2 46 7E E7 00 22 00 23 56 46 CD E9 02 23 DC E6 00 20 00 21 56 46 CD E9 02 01 D6 E6 00 20 01 46 FB E6 D5 6A 2B 78 01 3B DB B2 FD 2B 84 BF 00 25 A9 46 3F F6 53 AE D2 F8 34 90 B9 F1 00 0F 08 BF 00 25 4B E6 99 45 30 D0 DB B1 56 46 0D 9C 09 E0 20 46 ?? ?? ?? ?? 37 38 09 28 13 DC 74 68 37 1D 3E 46 7C B1 A4 F1 30 03 37 46 09 2B F6 D9 4C 45 41 46 20 46 F2 D0 ?? ?? ?? ?? 41 46 00 28 E7 D1 00 E0 57 46 39 46 4A 46 2B 46 50 46 ?? ?? ?? ?? DA F8 00 10 01 22 0A 27 04 92 0D 91 83 46 08 20 46 E6 ?? ?? ?? ?? ?? ?? ?? ?? 00 24 00 25 56 46 CD E9 02 45 89 E6 0F 4B 1D EE 70 2F 22 21 7B 44 1B 68 D1 50 D1 E6 DA F8 00 30 2A E6 DD E9 02 45 4F F0 FF 32 6F F0 00 43 AB 42 08 BF A2 42 BF F4 8E AE 05 4C 1D EE 70 5F 10 46 19 46 7C 44 24 68 22 22 2A 51 91 E6 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "allocate_dtv"
		size = 46
		refs = "0002 _dl_tls_max_dtv_idx 0018 calloc"
	strings:
		$1 = { 38 B5 ?? ?2 0? 0? ?? ?2 0? 0? 04 46 08 21 1B 68 03 F1 10 00 03 F1 0E 05 ?? ?? ?? ?? 28 B1 03 46 43 F8 08 5B 23 60 20 46 38 BD 04 46 FB E7 }
	condition:
		$1
}

rule file_400_1_0 {
	meta:
		name = "_dl_next_tls_modid"
		size = 180
		refs = "0000 _dl_tls_dtv_gaps 000e _dl_tls_max_dtv_idx 001e _dl_tls_static_nelem 002e _dl_tls_dtv_slotinfo_list 005e .LC0 0062 .LC1 0066 __PRETTY_FUNCTION__.11528 0078 __assert_fail 0096 .LC2"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? F8 B5 13 78 3B B9 ?? ?2 0? 0? ?? ?2 0? 0? 18 68 01 30 18 60 F8 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 68 ?? ?2 0? 0? 1F 68 01 30 09 68 B8 42 23 D8 0D 68 00 24 07 F1 01 0C 06 1B AE 42 15 D2 01 EB C6 06 F6 68 B6 B1 01 30 60 45 F5 D9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4B 22 ?? ?? ?? ?? 49 68 2C 44 09 B1 0D 68 E1 E7 B8 42 C8 D9 01 37 87 42 02 D1 00 21 11 70 BF E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 59 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_2_0 {
	meta:
		name = "_dl_get_tls_static_info"
		size = 26
		refs = "0000 _dl_tls_static_size 0004 _dl_tls_static_align"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 02 60 1B 68 0B 60 70 47 }
	condition:
		$1
}

rule file_400_3_0 {
	meta:
		name = "_dl_allocate_tls_storage"
		size = 90
		refs = "0000 _dl_tls_static_align 000a _dl_tls_static_size 0022 __libc_memalign 003a memset 004e free"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 70 B5 ?? ?2 0? 0? 18 68 ?? ?2 0? 0? 46 42 23 68 00 F2 BF 42 16 40 1E 44 31 46 ?? ?? ?? ?? 05 46 A8 B1 23 68 00 21 4F F4 99 62 F6 1A 06 44 A6 F5 98 60 ?? ?? ?? ?? 30 46 FF F7 5E FF 04 46 08 B1 20 46 70 BD 28 46 ?? ?? ?? ?? 20 46 70 BD 04 46 F6 E7 }
	condition:
		$1
}

rule file_400_4_0 {
	meta:
		name = "_dl_allocate_tls_init"
		size = 348
		refs = "000e _dl_tls_dtv_slotinfo_list 0012 _dl_tls_max_dtv_idx 0076 mempcpy 0086 memset 00f0 .LC5 00f4 .LC1 00f8 __PRETTY_FUNCTION__.11561 010c __assert_fail 011c .LC3 013c .LC4"
	strings:
		$1 = { 2D E9 F0 4F 83 B0 01 90 00 28 00 F0 83 80 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 27 D0 F8 00 B0 D2 F8 00 90 B8 46 DA F8 00 20 D8 F1 01 05 D9 F8 00 00 38 BF 00 25 85 42 50 D2 05 EB 08 01 91 42 64 D8 6E 1C 09 EB C6 06 04 36 28 E0 AA 42 63 D1 D4 F8 2C 22 D4 F8 30 12 91 42 6D D3 01 9B 0B EB C5 01 18 44 4F F0 01 03 4B F8 35 00 0B 71 D4 F8 28 12 ?? ?? ?? ?? D4 F8 30 32 D4 F8 2C 22 00 21 9A 1A ?? ?? ?? ?? D9 F8 00 00 01 35 DA F8 00 20 A8 42 23 D9 05 EB 08 01 08 36 8A 42 36 D3 34 68 00 2C F2 D0 D4 F8 3C 02 56 F8 04 2C 41 1C 97 42 38 BF 17 46 01 29 D4 F8 40 22 C7 D8 0B EB C2 01 4F F0 FF 33 4B F8 32 30 4F F0 00 03 0B 71 01 35 D9 F8 00 00 DA F8 00 20 A8 42 DB D8 A8 44 90 45 14 D2 D9 F8 04 90 B9 F1 00 0F 9E D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 DF 72 ?? ?? ?? ?? CB F8 00 70 01 98 03 B0 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 D3 72 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 A7 12 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_5_0 {
	meta:
		name = "_dl_allocate_tls"
		size = 28
		refs = "0010 _dl_allocate_tls_storage 000c _dl_allocate_tls_init"
	strings:
		$1 = { 08 B5 28 B1 FF F7 A0 FE BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? BD E8 08 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_6_0 {
	meta:
		name = "_dl_deallocate_tls"
		size = 108
		refs = "0020 free 004a _dl_tls_static_align 0068 _dl_static_dtv"
	strings:
		$1 = { 2D E9 F0 41 07 46 06 68 88 46 00 25 34 46 56 F8 08 2C 0A E0 23 7B 3B B9 A3 68 18 46 01 33 03 D0 ?? ?? ?? ?? 56 F8 08 2C 08 34 95 42 05 F1 01 05 F0 D3 0D 4B 9E 42 03 D0 A6 F1 08 00 ?? ?? ?? ?? B8 F1 00 0F 01 D1 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 58 42 03 F2 BF 43 18 40 38 1A BD E8 F0 41 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_7_0 {
	meta:
		name = "_dl_tls_get_addr_soft"
		size = 102
		refs = "000c _dl_tls_generation 003c _dl_tls_dtv_slotinfo_list"
	strings:
		$1 = { D0 F8 40 22 30 B4 9A B1 1D EE 70 1F ?? ?2 0? 0? ?? ?2 0? 0? 09 68 18 68 0B 68 83 42 0A D1 51 F8 32 20 B2 F1 FF 3F 14 BF 10 46 00 20 30 BC 70 47 10 46 FB E7 51 F8 08 0C 82 42 12 D2 ?? ?2 0? 0? 14 46 ?? ?2 0? 0? 00 68 05 68 AA 42 04 D3 40 68 64 1B 05 68 A5 42 FA D9 01 34 50 F8 34 00 83 42 DD D2 00 20 E2 E7 }
	condition:
		$1
}

rule file_400_8_0 {
	meta:
		name = "_dl_add_to_slotinfo"
		size = 164
		refs = "0002 _dl_tls_dtv_slotinfo_list 0022 _dl_tls_generation 003e malloc 0058 memset 005e .LC6 0062 .LC1 0066 __PRETTY_FUNCTION__.11597 007a __assert_fail 0082 .LC7 008a .LC8 00a0 _dl_signal_error"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? ?? ?2 0? 0? 06 46 D0 F8 40 42 1D 68 03 E0 6A 68 E4 1A 72 B1 15 46 2B 68 9C 42 F8 D2 ?? ?2 0? 0? 05 EB C4 04 ?? ?2 0? 0? E6 60 1B 68 01 33 A3 60 F8 BD 8C B9 4F F4 FC 70 ?? ?? ?? ?? 07 46 68 60 D0 B1 3E 23 08 30 21 46 4F F4 F8 72 7C 60 3D 46 3B 60 ?? ?? ?? ?? E1 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 5A 32 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 22 46 ?? ?2 0? 0? 2C 68 ?? ?2 0? 0? 0C 20 01 34 2C 60 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "ftello"
		size = 404
		refs = "0054 _IO_seekoff_unlocked 0124 __libc_do_syscall 012a __lll_lock_wait_private 0184 _Unwind_Resume 0188 __libc_errno"
	strings:
		$1 = { 03 68 70 B5 06 46 18 04 82 B0 1C D4 B0 6C 1D EE 70 4F A4 F5 98 64 83 68 A3 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 77 D1 B3 6C 18 46 9C 60 43 68 01 33 43 60 01 22 00 23 00 92 30 46 01 93 00 22 00 23 ?? ?? ?? ?? 33 68 0D 46 04 46 D9 05 08 D5 B5 F1 FF 3F 08 BF B4 F1 FF 3F 02 D0 F2 6E 00 2A 3C DD 1A 04 17 D4 B0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 26 00 2E F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 33 DC B5 F1 FF 3F 08 BF B4 F1 FF 3F 09 D0 22 46 E3 17 AB 42 08 BF A2 42 08 BF 20 46 1B D1 02 B0 70 BD 2F 4B 1D EE 70 2F 4F F0 FF 30 7B 44 1B 68 D3 58 00 2B F3 D1 2B 4B 05 21 4F F0 FF 30 7B 44 1B 68 D1 50 02 B0 70 BD F1 6A 72 6A 8A 1A A4 1A 65 EB E2 75 BB E7 24 4B 1D EE 70 2F 4B 21 4F F0 FF 30 7B 44 1B 68 D1 50 D9 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? BE E7 ?? ?? ?? ?? 84 E7 33 68 04 46 1B 04 24 D4 B3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 15 00 2D F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "time"
		size = 32
		refs = "000a __gettimeofday"
	strings:
		$1 = { 10 B5 82 B0 04 46 00 21 68 46 ?? ?? ?? ?? 20 B9 00 98 04 B1 20 60 02 B0 10 BD 4F F0 FF 30 F8 E7 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "_nl_init_era_entries.part.0"
		size = 414
		refs = "0000 __pthread_rwlock_wrlock 0012 __libc_setlocale_lock 003c free 004a __pthread_rwlock_unlock 007e realloc 00b6 __rawmemchr 00dc wcschr 0148 malloc 0156 _nl_cleanup_time"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 47 05 46 82 B0 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? D5 F8 14 A0 BA F1 00 0F 00 F0 8E 80 DA F8 08 30 63 B9 D5 F8 EC 70 CF B9 DA F8 00 00 18 B1 ?? ?? ?? ?? CA F8 00 70 01 23 CA F8 08 30 ?? ?2 0? 0? ?? ?2 0? 0? 00 2B 00 F0 A0 80 ?? ?2 0? 0? ?? ?2 0? 0? 02 B0 BD E8 F0 47 ?? ?? ?? ?? DA F8 04 20 DA F8 00 30 97 42 06 D0 34 21 18 46 01 FB 07 F1 ?? ?? ?? ?? 03 46 00 2B 7C D0 D5 F8 F0 50 1C 46 00 26 4F F0 FF 39 4F F0 01 08 8A E8 88 00 2A E0 48 D0 23 68 2B 2B 14 BF 43 46 4B 46 23 63 05 F1 20 00 00 21 20 62 01 36 ?? ?? ?? ?? 00 21 34 34 01 30 44 F8 10 0C ?? ?? ?? ?? 00 21 01 30 45 1B 03 35 ED 43 05 F0 03 05 28 44 44 F8 0C 0C ?? ?? ?? ?? 00 21 04 30 44 F8 08 0C ?? ?? ?? ?? BE 42 00 F1 04 05 A7 D0 D5 F8 00 E0 6B 68 A8 68 E9 68 C4 F8 00 E0 A0 60 63 60 E1 60 6B 69 D5 F8 10 E0 A8 69 E9 69 A2 68 63 61 63 69 C4 F8 10 E0 9A 42 A0 61 E1 61 BC DA 23 68 2B 2B 14 BF 4B 46 43 46 23 63 BC E7 E2 68 A3 69 9A 42 F4 DB B1 D1 22 69 E3 69 9A 42 AD DC EE E7 1C 20 ?? ?? ?? ?? 68 61 00 28 3F F4 7B AF 03 46 ?? ?2 0? 0? ?? ?2 0? 0? 2A 61 43 F8 04 AB 04 33 C0 F8 04 A0 43 F8 04 AB 43 F8 04 AB 43 F8 04 AB 43 F8 04 AB C3 F8 00 A0 82 46 53 E7 DA F8 00 00 01 93 ?? ?? ?? ?? 01 9B CA F8 04 30 CA F8 00 30 55 E7 02 B0 BD E8 F0 87 }
	condition:
		$1
}

rule file_404_1_0 {
	meta:
		name = "_nl_get_era_entry"
		size = 176
	strings:
		$1 = { F0 B5 04 46 4B 69 83 B0 43 B3 9A 68 32 B3 5E 68 62 69 27 69 D4 F8 0C C0 2E B3 1B 68 00 21 08 E0 2D D0 5D 69 AA 42 0D DC 31 D0 01 31 34 33 B1 42 19 D0 9C 68 18 46 A2 42 F2 DD 5D 69 AA 42 0B DB 14 D0 F2 DD A2 42 07 DB EF D1 DC 68 A7 42 03 DB EB D1 1C 69 A4 45 E8 DC 03 B0 F0 BD D1 F8 EC 20 EA B9 00 2B D3 D1 00 20 03 B0 F0 BD 9D 69 AF 42 F2 DB 0E D0 AF 42 E5 DC D7 D1 DD 69 0C E0 DD 68 AF 42 DA DC CD D1 1D 69 AC 45 CA DB D5 E7 9D 69 F0 E7 DD 69 AC 45 DF DD AC 45 C6 DB D2 E7 08 46 01 91 FF F7 DD FE 01 99 4B 69 00 2B AF D1 DA E7 }
	condition:
		$1
}

rule file_404_2_0 {
	meta:
		name = "_nl_select_era_entry"
		size = 58
	strings:
		$1 = { 10 B5 04 46 4B 69 82 B0 3B B1 9A 68 2A B1 1B 68 34 20 00 FB 04 30 02 B0 10 BD D1 F8 EC 20 1A B9 00 2B F4 D1 18 46 F6 E7 08 46 01 91 FF F7 C0 FE 01 99 4B 69 00 2B EA D1 F4 E7 }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "at_quick_exit"
		size = 20
		refs = "0000 __dso_handle 000c __cxa_at_quick_exit"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 13 B1 19 68 ?? ?? ?? ?? 19 46 FB E7 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "drand48"
		size = 30
		refs = "0000 __libc_drand48_data 0010 __erand48_r"
	strings:
		$1 = { ?? ?2 0? 0? 00 B5 ?? ?2 0? 0? 83 B0 01 46 6A 46 ?? ?? ?? ?? DD E9 00 01 03 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "lock_and_info"
		size = 72
		refs = "000a _dl_addr 003a __lll_lock_wait_private"
	strings:
		$1 = { 10 B5 0C 46 B8 B1 00 22 13 46 ?? ?? ?? ?? 0D 4B 01 22 BF F3 5F 8F 00 28 08 BF 00 24 53 E8 00 1F 00 29 03 D1 43 E8 00 20 00 28 F7 D1 BF F3 5F 8F 11 B9 20 46 10 BD 10 BD 18 46 ?? ?? ?? ?? 20 46 10 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_1_0 {
	meta:
		name = "tr_where"
		size = 240
		refs = "001a strlen 004a mempcpy 004e .LC1 0052 .LC0 007e _fitoa 0082 .LC4 008e .LANCHOR0 009c .LC3 00a4 .LC5 00b4 fprintf 00c0 .LC2 00da .LC6"
	strings:
		$1 = { 2D E9 F0 43 83 B0 80 46 02 AF 0E 46 00 28 53 D0 00 29 60 D0 88 68 00 28 52 D0 ?? ?? ?? ?? 28 23 00 F1 1C 01 02 46 21 F0 07 01 AD EB 01 0D 0D F1 08 09 89 F8 00 30 09 F1 01 00 F4 68 B1 68 A0 45 2C BF C4 EB 08 04 C8 EB 04 04 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? E5 17 4F F0 00 0E 02 46 F0 68 80 45 28 BF 19 46 10 23 08 68 29 46 42 F8 03 0B 20 46 CD F8 00 E0 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1B 88 03 80 ?? ?2 0? 0? 32 68 ?? ?2 0? 0? 18 68 B2 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CD F8 00 90 CD F8 04 80 ?? ?2 0? 0? ?? ?? ?? ?? 04 37 BD 46 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? E1 E7 ?? ?2 0? 0? ?? ?2 0? 0? 13 46 E6 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 02 46 ?? ?2 0? 0? 18 68 ?? ?? ?? ?? E3 E7 }
	condition:
		$1
}

rule file_407_2_0 {
	meta:
		name = "tr_memalignhook"
		size = 200
		refs = "0014 .LANCHOR0 0018 __memalign_hook 0020 __malloc_hook 0046 tr_memalignhook 004a tr_mallochook 005e .LC7 006c fprintf 009e memalign 00bc __libc_do_syscall"
	strings:
		$1 = { 2D E9 F0 47 84 B0 80 46 89 46 10 46 69 46 17 46 FF F7 5A FF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A3 68 49 46 E2 68 33 60 2A 60 82 46 40 46 83 B3 3A 46 98 47 80 46 38 46 51 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 32 60 2F 60 FF F7 59 FF ?? ?2 0? 0? 42 46 4B 46 ?? ?2 0? 0? 20 68 ?? ?? ?? ?? 14 4A 00 20 63 68 BF F3 5F 8F 52 E8 00 1F 99 42 03 D1 42 E8 00 05 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 07 DC 40 46 04 B0 BD E8 F0 87 ?? ?? ?? ?? 80 46 CD E7 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E9 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_3_0 {
	meta:
		name = "tr_mallochook"
		size = 172
		refs = "0012 .LANCHOR0 001a __malloc_hook 0036 tr_mallochook 0044 .LC7 0052 fprintf 0084 malloc 00a2 __libc_do_syscall"
	strings:
		$1 = { 2D E9 F0 43 0E 46 85 B0 80 46 69 46 30 46 FF F7 F7 FE ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? E2 68 2A 60 81 46 40 46 5A B3 31 46 90 47 07 46 30 46 49 46 ?? ?2 0? 0? ?? ?2 0? 0? 2E 60 FF F7 02 FF ?? ?2 0? 0? ?? ?2 0? 0? 43 46 20 68 3A 46 ?? ?? ?? ?? 14 49 00 20 63 68 BF F3 5F 8F 51 E8 00 2F 9A 42 03 D1 41 E8 00 05 00 2D F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 07 DC 38 46 05 B0 BD E8 F0 83 ?? ?? ?? ?? 07 46 D2 E7 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_4_0 {
	meta:
		name = "tr_reallochook"
		size = 328
		refs = "0014 .LANCHOR0 0018 __free_hook 0020 __malloc_hook 0024 __realloc_hook 0052 tr_freehook 0056 tr_mallochook 005a tr_reallochook 0088 .LC10 0094 fprintf 00a0 .LC11 00e6 .LC8 00fa realloc 0102 .LC7 0116 .LC9 013e __libc_do_syscall"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 81 46 8A 46 10 46 02 A9 17 46 FF F7 A0 FE ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 21 69 ?? ?2 0? 0? E2 68 ?? ?2 0? 0? 63 69 CB F8 00 10 51 46 32 60 2B 60 01 90 48 46 00 2B 56 D0 3A 46 98 47 80 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 38 46 01 99 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? CB F8 00 30 C6 F8 00 E0 2A 60 FF F7 90 FE B8 F1 00 0F 2E D0 B9 F1 00 0F 3C D0 ?? ?2 0? 0? 4A 46 ?? ?2 0? 0? 20 68 ?? ?? ?? ?? 38 46 01 99 FF F7 7E FE ?? ?2 0? 0? 53 46 ?? ?2 0? 0? 20 68 42 46 ?? ?? ?? ?? 24 4A 00 20 63 68 BF F3 5F 8F 52 E8 00 1F 99 42 03 D1 42 E8 00 05 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 27 DC 40 46 07 B0 BD E8 F0 8F BA F1 00 0F 17 D0 ?? ?2 0? 0? 4A 46 53 46 ?? ?2 0? 0? 20 68 ?? ?? ?? ?? DB E7 ?? ?? ?? ?? 80 46 A7 E7 ?? ?2 0? 0? 53 46 ?? ?2 0? 0? 20 68 42 46 ?? ?? ?? ?? CD E7 ?? ?2 0? 0? 4A 46 ?? ?2 0? 0? 20 68 ?? ?? ?? ?? C4 E7 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? C9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_5_0 {
	meta:
		name = "tr_freehook"
		size = 288
		refs = "0016 .LANCHOR0 002a .LC9 0036 fprintf 003a mallwatch 0048 __free_hook 0060 tr_freehook 00d6 __lll_lock_wait_private 00dc free 00f8 __libc_do_syscall"
	strings:
		$1 = { 2D E9 F0 41 05 46 84 B0 0F 46 00 28 3E D0 08 46 69 46 FF F7 FB FD ?? ?2 0? 0? ?? ?2 0? 0? 04 F1 04 08 01 46 38 46 FF F7 15 FE ?? ?2 0? 0? 2A 46 20 68 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 9D 42 24 D0 ?? ?2 0? 0? 23 69 ?? ?2 0? 0? 28 46 33 60 00 2B 40 D0 39 46 98 47 00 22 ?? ?2 0? 0? ?? ?2 0? 0? 33 60 63 68 BF F3 5F 8F 58 E8 00 1F 99 42 03 D1 48 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 2A DC 04 B0 BD E8 F0 81 00 22 63 68 BF F3 5F 8F 58 E8 00 1F 99 42 03 D1 48 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 23 DC 01 22 BF F3 5F 8F 58 E8 00 3F 00 2B 03 D1 48 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B B9 D0 11 48 ?? ?? ?? ?? B5 E7 ?? ?? ?? ?? BD E7 1D EE 70 1F 01 22 A1 F5 98 61 0B 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? C6 E7 1D EE 70 1F 01 22 A1 F5 98 61 04 48 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? CD E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_7_0 {
	meta:
		name = "mtrace"
		size = 346
		refs = "0004 .LANCHOR0 0014 mallenv 001c __libc_secure_getenv 0028 malloc 0036 mallwatch 0054 .LC12 005c .LC13 006c _IO_new_fopen 0076 fileno 007e __fcntl 00a2 _IO_setvbuf 00a6 .LC14 00b4 tr_freehook 00b8 fwrite 00bc __free_hook 00c4 __malloc_hook 00c8 __realloc_hook 00cc __memalign_hook 00de tr_mallochook 00e2 tr_reallochook 010e tr_memalignhook 0124 __dso_handle 0136 release_libc_mem 0144 __cxa_atexit 014e free"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 23 68 0B B1 BD E8 F0 87 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 05 46 40 B1 4F F4 00 70 ?? ?? ?? ?? 06 46 00 28 EE D0 28 46 12 E0 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 00 2B 00 F0 86 80 4F F4 00 70 ?? ?? ?? ?? 06 46 00 28 DD D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 20 60 00 28 68 D0 ?? ?? ?? ?? 01 21 00 22 ?? ?? ?? ?? 07 1E 07 DB 28 68 ?? ?? ?? ?? 47 F0 01 02 02 21 ?? ?? ?? ?? 31 46 00 22 4F F4 00 73 20 68 A6 61 ?? ?? ?? ?? ?? ?2 0? 0? 01 21 08 22 23 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 07 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? C0 F8 00 A0 ?? ?2 0? 0? 08 68 ?? ?2 0? 0? C1 F8 00 90 ?? ?2 0? 0? 11 68 16 60 1A 68 E5 69 27 61 ?? ?2 0? 0? ?? ?2 0? 0? E0 60 61 61 A2 60 1F 60 00 2D 7F F4 76 AF ?? ?2 0? 0? 01 22 ?? ?2 0? 0? C8 F8 1C 20 83 B1 1A 68 ?? ?2 0? 0? 00 21 ?? ?2 0? 0? BD E8 F0 47 ?? ?? ?? ?? 30 46 BD E8 F0 47 ?? ?? ?? ?? BD E8 F0 87 1A 46 ED E7 }
	condition:
		$1
}

rule file_407_8_0 {
	meta:
		name = "muntrace"
		size = 120
		refs = "0000 .LANCHOR0 0016 __realloc_hook 0026 __free_hook 002e __malloc_hook 0036 __memalign_hook 0046 .LC15 0066 fwrite 0070 _IO_new_fclose"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 4E DC F8 00 40 84 B3 DC F8 14 50 ?? ?2 0? 0? ?? ?2 0? 0? DC F8 10 70 DC F8 0C 60 ?? ?2 0? 0? C9 F8 00 50 ?? ?2 0? 0? DC F8 08 50 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 23 46 01 21 ?? ?2 0? 0? 06 22 CA F8 00 60 00 26 CB F8 00 70 CE F8 00 50 CC F8 00 60 ?? ?? ?? ?? 20 46 BD E8 F0 4E ?? ?? ?? ?? BD E8 F0 8E }
	condition:
		$1
}

rule file_407_9_0 {
	meta:
		name = "release_libc_mem"
		size = 18
		refs = "0000 .LANCHOR0 000c __libc_freeres"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 0B B1 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_514_6_0 {
	meta:
		name = "__gconv_release_cache"
		size = 18
		refs = "0000 .LANCHOR0 000c free"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 0B B1 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "bsearch"
		size = 68
	strings:
		$1 = { 2D E9 F8 4F 16 46 80 46 89 46 9A 46 DD F8 28 B0 00 25 2A B9 10 E0 04 F1 01 05 10 D0 B5 42 0B D2 74 19 40 46 64 08 0A FB 04 97 39 46 D8 47 00 28 F1 DA 26 46 B5 42 F3 D3 00 20 BD E8 F8 8F 38 46 BD E8 F8 8F }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "_dl_resolve_conflicts"
		size = 706
		refs = "0000 _dl_debug_mask 0026 _dl_num_cache_relocations 003c _dl_ns 0054 _dl_hwcap 0058 .LANCHOR0 006a _dl_pagesize 006e _dl_tlsdesc_lazy_resolver 00f2 _dl_reloc_bad_type 01be __mmap 01ee .LC6 01f2 .LC5 01f6 __PRETTY_FUNCTION__.12569 020a __assert_fail 020e .LC4 022e .LC2 0232 .LC3 0236 __PRETTY_FUNCTION__.12471 0252 _dl_argv 0256 .LC0 026c .LC1 0274 _dl_debug_printf 027c .LC9 028a _dl_signal_error 028e .LC8 0296 __PRETTY_FUNCTION__.12516 02b0 .LC7"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 4F 17 46 1B 68 87 B0 81 46 0E 46 9A 06 00 F1 18 81 D9 F8 18 00 00 28 40 F0 04 81 ?? ?2 0? 0? BD 1B ?? ?2 0? 0? 4A F6 AB 21 AD 10 CA F6 AA 21 1C 68 ?? ?2 0? 0? ?? ?2 0? 0? B7 42 01 FB 05 41 14 68 19 60 45 D9 4F F2 04 0C ?? ?2 0? 0? ?? ?2 0? 0? CE F2 1F 5C ?? ?2 0? 0? ?? ?2 0? 0? E3 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 05 93 04 90 31 79 35 68 17 29 00 F0 AD 80 29 B3 12 29 33 D0 28 D8 02 29 30 D0 32 D9 0D 29 01 D0 7F E0 E4 68 D4 F8 B0 31 9D 42 FA D8 D4 F8 AC 31 9D 42 F6 D3 D4 F8 48 21 23 68 69 68 52 68 1A 44 91 42 40 F0 A7 80 D4 F8 44 21 00 2A 00 F0 92 80 51 68 04 98 E2 6A C8 50 53 68 5C 60 0C 36 B7 42 D0 D8 07 B0 BD E8 F0 8F 16 29 4F D8 15 29 05 D2 13 29 F3 D0 48 46 00 22 ?? ?? ?? ?? B3 68 2B 60 EC E7 01 29 F6 D1 B3 68 C5 EB 03 0C 1C F0 7E 42 0C BF 00 23 01 23 B2 F1 7E 4F 0C BF 00 23 03 F0 01 03 53 B3 D8 F8 00 20 ?? ?2 0? 0? ?? ?2 0? 0? 00 2A 3C D0 ?? ?2 0? 0? 5B 68 ?? ?2 0? 0? 42 F8 03 B0 1A 44 09 68 08 33 94 44 00 20 8B 42 C8 F8 04 30 50 60 24 BF C8 F8 00 00 C8 F8 04 00 1C F0 7E 42 0C BF 00 23 01 23 B2 F1 7E 4F 0C BF 00 23 03 F0 01 03 00 2B 40 F0 83 80 2B 68 CC F3 97 0C 03 F0 7F 43 4C EA 03 03 2B 60 A7 E7 A0 29 B1 D1 B2 68 D9 F8 00 30 DA F8 00 00 13 44 98 47 28 60 9C E7 11 29 9A D0 48 46 00 22 ?? ?? ?? ?? 05 9B 10 46 19 68 4F F0 FF 33 01 92 07 22 00 93 22 23 CD F8 0C C0 ?? ?? ?? ?? ?? ?2 0? 0? DD F8 0C C0 ?? ?2 0? 0? 43 1C 6D D0 D8 F8 04 30 C8 F8 00 00 00 2B 57 D1 02 46 AA E7 B2 68 D9 F8 00 30 13 44 2B 60 73 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 13 72 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 4B 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 37 22 ?? ?? ?? ?? 41 68 0B 78 63 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 11 68 00 29 08 BF 19 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? D0 E6 00 20 ?? ?2 0? 0? D9 F8 04 10 02 46 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 9F 72 ?? ?? ?? ?? 00 20 ?? ?2 0? 0? D9 F8 04 10 02 46 ?? ?2 0? 0? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_410_1_0 {
	meta:
		name = "cfgetispeed"
		size = 18
	strings:
		$1 = { 03 68 00 2B A3 BF 83 68 41 F2 0F 00 18 40 00 20 70 47 }
	condition:
		$1
}

rule file_410_2_0 {
	meta:
		name = "cfsetospeed"
		size = 68
		refs = "0040 __libc_errno"
	strings:
		$1 = { 21 F4 80 52 03 46 22 F0 0F 02 22 B1 A1 F5 80 52 01 3A 0E 2A 09 D8 9A 68 00 20 99 63 22 F4 80 52 22 F0 0F 02 11 43 99 60 70 47 05 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_410_3_0 {
	meta:
		name = "cfsetispeed"
		size = 104
		refs = "0064 __libc_errno"
	strings:
		$1 = { 21 F4 80 52 03 46 22 F0 0F 02 10 B4 AA B1 A1 F5 80 52 01 3A 0E 2A 98 BF 41 63 19 D8 9C 68 00 20 1A 68 24 F4 80 54 24 F0 0F 04 22 F0 00 42 21 43 1A 60 99 60 5D F8 04 4B 70 47 41 63 00 29 ED D1 02 68 08 46 5D F8 04 4B 42 F0 00 42 1A 60 70 47 04 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 E7 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "__libc_pwrite64"
		size = 136
		refs = "0004 __libc_multiple_threads 001e __libc_do_syscall 002c __libc_enable_asynccancel 004c __libc_disable_asynccancel 0080 __libc_errno"
	strings:
		$1 = { 2D E9 F8 43 ?? ?2 0? 0? ?? ?2 0? 0? 80 46 0F 46 16 46 1B 68 08 9C 09 9D 43 B9 4F F0 B5 0C ?? ?? ?? ?? 10 F5 80 5F 15 D8 BD E8 F8 83 ?? ?? ?? ?? 39 46 32 46 00 23 4F F0 B5 0C 81 46 40 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0F D8 48 46 ?? ?? ?? ?? 20 46 E9 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 BD E8 F8 83 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E5 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_0_3 {
	meta:
		name = "__libc_pwrite64"
		size = 136
		refs = "0004 __pthread_multiple_threads 001e __libc_do_syscall 002c __pthread_enable_asynccancel 004c __pthread_disable_asynccancel 0080 errno"
	strings:
		$1 = { 2D E9 F8 43 ?? ?2 0? 0? ?? ?2 0? 0? 80 46 0F 46 16 46 1B 68 08 9C 09 9D 43 B9 4F F0 B5 0C ?? ?? ?? ?? 10 F5 80 5F 15 D8 BD E8 F8 83 ?? ?? ?? ?? 39 46 32 46 00 23 4F F0 B5 0C 81 46 40 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0F D8 48 46 ?? ?? ?? ?? 20 46 E9 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 BD E8 F8 83 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E5 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_413_0_0 {
	meta:
		name = "__read_chk"
		size = 52
		refs = "000a __libc_do_syscall 0016 __chk_fail 0030 __libc_errno"
	strings:
		$1 = { 9A 42 08 B5 07 D8 4F F0 03 0C ?? ?? ?? ?? 10 F5 80 5F 02 D8 08 BD ?? ?? ?? ?? 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F2 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "__dngettext"
		size = 16
		refs = "0008 __dcngettext"
	strings:
		$1 = { 10 B5 82 B0 05 24 00 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "nscd_getserv_r"
		size = 1438
		refs = "000c __serv_map_handle 0010 .LC1 002a __nscd_get_map_ref 0036 strlen 0068 __nss_not_use_nscd_services 006c mempcpy 0070 .LC0 0096 memcpy 00bc __nscd_cache_search 0160 __nscd_open_socket 01aa __libc_do_syscall 01be __nscd_unmap 01ca free 03d0 __readvall 042c __readall 0468 __libc_errno 04c2 __libc_alloca_cutoff 04d6 malloc 04f2 .LC2 04f6 .LC3 04fa __PRETTY_FUNCTION__.14070 050c __assert_fail"
	strings:
		$1 = { 2D E9 F0 4F A1 B0 02 AF 14 46 0D 46 ?? ?2 0? 0? ?? ?2 0? 0? 78 64 ?? ?2 0? 0? 7B 63 ?? ?2 0? 0? 12 20 07 F1 4C 03 D7 F8 A0 B0 ?? ?? ?? ?? A0 46 82 46 1C B1 20 46 ?? ?? ?? ?? 80 46 AB 1C 43 44 FB 63 B3 F5 80 5F 00 F2 96 82 FE 6B 06 F1 0E 03 23 F0 07 03 BE 62 AD EB 03 0D 01 26 7E 61 02 AE BE 63 79 6C 2A 46 B8 6B ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 2F 23 08 F1 01 02 00 2C 18 BF 21 46 ?? ?2 0? 0? 4F F0 00 08 BE 61 C7 F8 40 80 00 F8 01 3B ?? ?? ?? ?? D7 F8 A4 40 63 42 03 F0 03 03 3B 62 1C 44 FC 61 BA F1 FF 3F 50 D0 18 23 78 6B 00 93 53 46 B9 6B FA 6B ?? ?? ?? ?? 80 46 00 28 45 D0 00 F1 18 0C 07 F1 60 05 E1 46 DA F8 00 40 08 F1 30 06 D8 F8 04 80 B9 E8 0F 00 0F C5 99 E8 03 00 BA 6E FB 6E 06 EB 02 09 85 E8 03 00 99 44 A1 68 FB 6C 3A 6F 99 42 73 D0 6F F0 01 06 19 46 01 23 7B 64 A3 68 8B 42 40 F0 9A 81 0A F1 0C 02 DA F8 0C 30 BF F3 5F 8F 58 1E 52 E8 00 1F 99 42 04 D1 42 E8 00 08 B8 F1 00 0F F6 D1 8B 42 BF F3 5F 8F ED D1 01 2B 3F D0 7C 6C 00 2C 42 D0 7C 69 30 46 00 2C 45 D0 7C 37 BD 46 BD E8 F0 8F 18 23 B8 6B 00 93 07 F1 60 03 F9 6B 7A 6B ?? ?? ?? ?? B0 F1 FF 3F 84 46 00 F0 4A 81 00 25 4F F0 FF 34 A9 46 2E 46 3C 63 7D 64 7A 6E 00 23 D7 F8 AC 40 50 1C 23 60 00 F0 92 81 01 2A 50 D0 B5 4A 1D EE 70 1F 1E 46 7A 44 12 68 8B 50 BC F1 FF 3F 04 D0 60 46 4F F0 06 0C ?? ?? ?? ?? BA F1 FF 3F C3 D0 DA F8 00 40 F9 6C A5 E7 50 46 ?? ?? ?? ?? 7C 6C 00 2C BC D1 48 46 ?? ?? ?? ?? 7C 69 30 46 00 2C B9 D1 B8 6B ?? ?? ?? ?? 30 46 7C 37 BD 46 BD E8 F0 8F 92 00 C4 44 09 EB 02 05 C7 F8 30 C0 65 45 00 F2 78 81 19 F0 03 0F 00 F0 FE 80 D7 F8 28 80 90 44 B8 F5 80 5F 00 F2 58 81 02 F1 0E 03 01 24 23 F0 07 03 7C 64 AD EB 03 0D 02 A8 49 46 C7 F8 28 80 ?? ?? ?? ?? 81 46 4F F0 FF 3C A4 E7 B9 6E 3B 6F F8 6E 79 60 7B 62 01 44 0B 46 3C 6A F9 62 79 6A 23 44 D7 F8 A4 80 01 31 B9 60 98 44 C8 F1 00 04 89 00 04 F0 03 08 0B 44 D7 F8 A8 40 43 44 A3 42 07 D9 80 4B 1D EE 70 2F 22 26 7B 44 1B 68 D6 50 92 E7 FC 69 80 44 F8 69 7B 6F CB F8 04 40 08 44 7C 68 CB F8 00 00 04 44 CB F8 08 30 CB F8 0C 40 44 44 00 2E 72 D0 31 46 FA 6A C7 F8 0C C0 ?? ?? ?? ?? D7 F8 0C C0 38 6F 00 28 40 F3 B2 80 00 23 80 00 1E 46 DB F8 04 10 59 F8 03 20 CC 50 04 33 83 42 14 44 16 44 F5 D1 D7 F8 30 80 AA 19 DB F8 04 30 00 21 90 45 19 50 C0 F0 29 81 D7 F8 A4 30 D7 F8 A8 10 0B 44 9C 42 00 F2 13 81 00 2D 7B D0 DB F8 04 30 32 46 29 46 18 68 C7 F8 0C C0 ?? ?? ?? ?? DB F8 00 20 BB 6E D7 F8 0C C0 13 44 13 F8 01 3C 53 B1 DA F8 00 20 FB 6C 92 68 9A 42 14 BF 6F F0 01 06 4F F0 FF 36 36 E7 DB F8 0C 20 FB 6E 13 44 13 F8 01 3C 00 2B EC D1 3D 6F 00 2D 17 DD DB F8 04 10 D9 F8 00 30 0A 68 13 44 13 F8 01 3C 00 2B DF D1 4A 46 08 E0 51 F8 04 4F 52 F8 04 0F 20 44 10 F8 01 0C 00 28 D4 D1 01 33 AB 42 F3 D1 D7 F8 AC 80 00 26 C8 F8 00 B0 0D E7 7B 6A FE 6A 00 2B 38 65 7E 65 57 DD 7E 6C 00 2E 40 F0 AE 80 D7 F8 28 80 04 39 88 44 B8 F5 80 5F 00 F2 CB 80 01 F1 0E 03 01 26 23 F0 07 03 7E 64 AD EB 03 0D 0D F1 08 09 FE 6A 02 22 C7 F8 58 90 0E 44 F9 65 60 46 07 F1 50 01 C7 F8 0C C0 ?? ?? ?? ?? D7 F8 0C C0 B0 42 0C BF C7 F8 28 80 4F F0 FF 36 3F F4 62 AF C7 F8 28 80 D7 E6 B6 B9 D7 F8 AC 40 00 26 C4 F8 00 B0 D0 E6 01 23 7B 64 14 E7 D7 F8 18 80 4F F0 00 09 01 23 66 46 C7 F8 44 90 C8 F8 00 30 CA E6 00 20 06 46 57 E7 DB F8 04 30 60 46 32 46 19 68 C7 F8 0C C0 ?? ?? ?? ?? D7 F8 0C C0 B0 42 DB D0 4F F0 FF 36 AF E6 D7 F8 28 80 C0 E7 D9 07 FB 64 12 D4 3C 6C 01 34 3C 64 05 2C 0D D0 72 1C 0B D0 7B 6C 00 2B 7F F4 25 AE 48 46 ?? ?? ?? ?? 20 E6 ?? ?? ?? ?? ?? ?? ?? ?? 0A F1 0C 02 DA F8 0C 30 BF F3 5F 8F 58 1E 52 E8 00 1F 99 42 04 D1 42 E8 00 08 B8 F1 00 0F F6 D1 8B 42 BF F3 5F 8F ED D1 01 2B 05 D0 73 1C 3F F4 4D AE 4F F0 FF 3A D7 E7 50 46 ?? ?? ?? ?? F5 E7 D7 F8 18 80 01 23 16 46 C8 F8 00 30 6F E6 40 46 FA 60 ?? ?? ?? ?? FA 68 03 46 00 28 7F F4 9F AE 10 46 FA 60 3B 61 ?? ?? ?? ?? FA 68 3B 69 B8 B1 D7 F8 28 80 7B 64 9B E6 01 23 4F F0 FF 36 7B 64 0A E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? F9 22 ?? ?? ?? ?? 78 64 0C 26 F9 6C F7 E5 00 2D 3F F4 A5 AE DA F8 00 20 FB 6C 92 68 9A 42 18 BF 6F F0 01 06 7F F4 36 AE 99 E6 00 2D 7F F4 F0 AE 7D E7 40 46 39 61 C7 F8 0C C0 ?? ?? ?? ?? 39 69 D7 F8 0C C0 00 28 7F F4 29 AF 08 46 39 61 C7 F8 0C C0 ?? ?? ?? ?? 39 69 D7 F8 0C C0 D7 F8 28 80 81 46 00 28 7F F4 24 AF 0C 26 38 E7 18 46 ?? ?? ?? ?? 81 46 00 28 7F F4 63 AD F8 6B ?? ?? ?? ?? B8 63 20 B1 C7 F8 14 90 C7 F8 28 90 64 E5 4F F0 FF 30 D5 E5 }
	condition:
		$1
}

rule file_415_1_0 {
	meta:
		name = "__nscd_getservbyname_r"
		size = 48
		refs = "000e strlen"
	strings:
		$1 = { 2D E9 F0 42 84 B0 0F 46 14 46 1E 46 81 46 ?? ?? ?? ?? 0A 9D 0B 9B 3A 46 00 94 01 96 03 93 10 23 02 95 01 46 48 46 FF F7 1B FD 04 B0 BD E8 F0 82 }
	condition:
		$1
}

rule file_415_2_0 {
	meta:
		name = "__nscd_getservbyport_r"
		size = 62
		refs = "001e _itoa_word"
	strings:
		$1 = { 2D E9 F0 41 88 B0 08 AC 00 25 88 46 17 46 04 F8 03 5D 1E 46 21 46 2B 46 0A 22 0E 9D 0F 9C ?? ?? ?? ?? 0D F1 1E 01 00 97 01 96 42 46 02 95 11 23 03 94 09 1A FF F7 FC FC 08 B0 BD E8 F0 81 }
	condition:
		$1
}

rule file_415_3_0 {
	meta:
		name = "serv_map_free"
		size = 26
		refs = "0000 __serv_map_handle 0014 free"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 58 68 42 1C 04 D0 4F F0 FF 32 5A 60 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_778_3_0 {
	meta:
		name = "gr_map_free"
		size = 26
		refs = "0000 __gr_map_handle 0014 free"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 58 68 42 1C 04 D0 4F F0 FF 32 5A 60 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_828_5_0 {
	meta:
		name = "hst_map_free"
		size = 26
		refs = "0000 __hst_map_handle 0014 free"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 58 68 42 1C 04 D0 4F F0 FF 32 5A 60 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_460_3_0 {
	meta:
		name = "pw_map_free"
		size = 26
		refs = "0000 .LANCHOR0 0014 free"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 58 68 42 1C 04 D0 4F F0 FF 32 5A 60 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "inet_nsap_addr"
		size = 204
		refs = "00c4 __libc_tsd_CTYPE_TOUPPER 00c8 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 07 00 25 DF F8 BC 80 DF F8 BC C0 03 78 1D EE 70 6F 87 1C A3 F1 2E 04 00 2B 45 D0 95 42 43 D2 2B 2B 18 BF 01 2C 8C BF 00 24 01 24 98 BF 01 30 EC D9 13 F0 80 0F 05 F1 01 05 3D D1 44 46 E1 46 7C 44 24 68 F9 44 D9 F8 00 90 34 59 56 F8 09 60 14 F8 23 30 A3 F1 30 09 36 F8 13 A0 B9 F1 09 0F 8C BF 4F F0 37 09 4F F0 30 09 C9 EB 03 09 0A F4 80 53 5F FA 89 F9 9B B2 D3 B1 43 78 38 46 BB B1 14 F8 23 40 A4 F1 30 07 36 F8 14 30 09 2F 8C BF 37 26 30 26 A4 1B 03 F4 80 53 44 EA 09 14 9B B2 33 B1 0C 70 01 31 B1 E7 28 46 BD E8 F0 07 70 47 18 46 BD E8 F0 07 70 47 20 46 BD E8 F0 07 70 47 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_1_0 {
	meta:
		name = "inet_nsap_ntoa"
		size = 128
		refs = "0000 .LANCHOR0"
	strings:
		$1 = { ?? ?2 0? 0? 2D E9 F0 03 ?? ?2 0? 0? FF 28 B4 BF 80 46 4F F0 FF 08 00 2A 14 BF 10 46 18 46 B8 F1 00 0F 2B DD 03 46 00 26 4F F0 2E 09 05 E0 47 45 1F DA 83 F8 02 90 03 33 3E 46 0D 78 1C 46 77 1C 2D 09 09 2D CC BF 37 22 30 22 15 44 04 F8 02 5B 11 F8 01 5B 05 F0 0F 05 09 2D CC BF 4F F0 37 0C 4F F0 30 0C F2 07 65 44 5D 70 E0 D5 47 45 23 46 E2 DB 00 23 23 70 BD E8 F0 03 70 47 04 46 F8 E7 }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "read_int"
		size = 76
	strings:
		$1 = { 02 68 70 B4 4C F6 CC 46 52 F8 04 3B C0 F6 CC 46 30 3B 13 E0 00 2B 10 DB 03 EB 83 05 4F F6 FF 74 B3 42 C7 F6 FF 74 4F EA 45 03 C1 EB 04 04 02 DC A3 42 0B 44 01 DD 4F F0 FF 33 04 32 11 68 30 39 09 29 E7 D9 02 60 18 46 70 BC 70 47 }
	condition:
		$1
}

rule file_417_1_0 {
	meta:
		name = "__parse_one_specwc"
		size = 1236
		refs = "0100 __printf_modifier_table 01ac __printf_function_table 035e __wcschrnul 048e __handle_registered_modifier_wc 04a2 __printf_arginfo_table"
	strings:
		$1 = { 2D E9 F0 41 14 46 0F 46 05 46 26 7B 98 46 61 7B 4F F0 FF 30 06 F0 87 03 20 22 01 F0 F6 01 6F F3 C7 13 22 61 41 F0 04 01 23 73 82 B0 61 73 2E 1D 60 62 68 68 01 96 A0 F1 30 03 09 2B 88 BF 32 46 40 F2 03 81 01 9E 30 23 20 38 29 28 3D D8 DF E8 00 F0 37 3C 3C 32 3C 3C 3C 2D 3C 3C 3C 28 3C 23 3C 3C 21 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 3C 15 61 7B 41 F0 08 01 61 73 50 68 15 1D 2A 46 2E 46 00 28 DB D1 01 95 1B E0 23 61 F5 E7 21 7B 41 F0 20 01 21 73 F0 E7 21 7B 41 F0 40 01 21 73 EB E7 21 7B 41 F0 80 01 21 73 E6 E7 21 7B 41 F0 08 01 21 73 E1 E7 21 7B 41 F0 10 01 21 73 DC E7 01 96 23 7B 00 25 65 60 99 06 44 BF 20 23 23 61 4F F0 FF 33 23 62 13 68 2A 2B 00 F0 BE 80 30 3B 09 2B 40 F2 DD 80 4F F0 FF 33 E3 61 23 60 13 68 2E 2B 00 F0 BF 80 ?? ?2 0? 0? 61 7B ?? ?2 0? 0? 20 7B 6F F3 41 01 61 73 19 68 00 F0 FC 03 6F F3 82 03 00 20 23 73 E0 81 00 29 40 F0 AB 81 13 68 10 1D 01 90 A3 F1 4C 01 2E 29 00 F2 5B 81 DF E8 11 F0 CC 00 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 2F 00 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 59 01 DB 00 59 01 D3 00 59 01 BF 00 59 01 59 01 59 01 59 01 CC 00 59 01 59 01 2F 00 59 01 59 01 59 01 59 01 59 01 2F 00 23 7B 02 F1 08 06 03 F0 FE 03 6F F3 82 03 23 73 51 68 ?? ?2 0? 0? 4F F0 FF 32 ?? ?2 0? 0? 01 96 A1 60 1B 68 22 63 00 2B 40 F0 6B 81 0B 46 A3 F1 41 02 01 21 E1 62 37 2A 00 F2 0F 81 DF E8 12 F0 E8 00 0D 01 E5 00 0D 01 E8 00 E8 00 E8 00 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 E2 00 0D 01 0D 01 0D 01 0D 01 A0 00 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 0D 01 E8 00 0D 01 B8 00 A0 00 E8 00 E8 00 E8 00 0D 01 A0 00 0D 01 0D 01 0D 01 0D 01 DE 00 A0 00 DB 00 0D 01 0D 01 D8 00 0D 01 A0 00 0D 01 0D 01 A0 00 01 A8 FF F7 B2 FE 20 B1 01 9B 1A 68 24 2A 00 F0 E3 80 01 96 32 46 68 68 EF E6 53 68 15 1D 01 95 30 3B 09 2B 40 F2 A6 80 27 62 2A 46 01 95 01 37 01 25 38 E7 53 68 11 1D 01 91 2A 2B 00 F0 BF 80 30 3B 09 2B 82 BF 00 23 0A 46 23 60 3F F6 33 AF 01 A8 FF F7 8A FE 43 1C 18 BF 20 60 01 9A 2A E7 01 A8 FF F7 82 FE 01 9A 46 1C 18 BF 60 60 1A E7 23 7B 43 F0 04 03 23 73 51 68 6C 29 18 BF 02 F1 08 06 7F F4 6E AF 02 F1 08 00 23 7B 06 1D 43 F0 01 03 23 73 01 68 64 E7 23 7B 02 F1 08 06 43 F0 05 03 23 73 51 68 5C E7 53 68 68 2B 15 BF 02 F1 08 06 02 F1 0C 06 23 7B 63 7B 15 BF 43 F0 02 03 43 F0 02 03 23 73 63 73 14 BF 51 68 91 68 48 E7 22 7B D6 07 44 BF 4F F4 80 72 A2 62 12 D4 50 07 44 BF 4F F4 00 72 A2 62 0C D4 91 07 44 BF 4F F4 80 62 A2 62 06 D4 62 7B C2 F3 40 02 00 2A 37 D0 01 22 A2 62 62 6A 01 32 0B D0 8B B1 01 9B 25 21 18 46 63 61 ?? ?? ?? ?? A0 61 28 46 02 B0 BD E8 F0 81 E2 6A 00 2A F0 D0 15 44 67 62 00 2B ED D1 01 9B 28 46 04 3B A3 61 63 61 02 B0 BD E8 F0 81 03 22 A2 62 DE E7 05 22 A2 62 DB E7 4F F4 00 62 A2 62 D7 E7 04 22 A2 62 D4 E7 02 22 A2 62 D1 E7 22 7B D2 07 5C BF 07 22 A2 62 CB D5 40 F2 07 12 A2 62 C7 E7 01 A8 FF F7 F8 FD C8 B1 01 9A 13 68 24 2B 15 D1 43 1C 09 D0 43 1E 23 62 D8 F8 00 30 83 42 2C BF C8 F8 00 30 C8 F8 00 00 04 32 23 6A 01 92 06 E0 19 46 06 46 DB E6 00 22 E2 62 A9 E7 23 6A 00 2B FF F6 38 AF 01 9A 00 25 73 E6 93 68 02 F1 08 06 01 96 30 3B 09 2B 16 D9 E7 61 01 35 01 96 32 46 01 37 6E E6 45 1C 03 F1 04 02 01 92 09 D0 41 1E 61 62 D8 F8 00 10 81 42 2C BF C8 F8 00 10 C8 F8 00 00 58 68 FF E5 01 A8 FF F7 B5 FD 18 B1 01 9A 13 68 24 2B 04 D0 E3 69 00 2B BF F6 25 AF DB E7 41 1C 09 D0 43 1E E3 61 D8 F8 00 30 83 42 2C BF C8 F8 00 30 C8 F8 00 00 04 32 E3 69 01 92 EB E7 13 68 51 F8 23 30 00 2B 3F F4 4F AE 01 A8 21 46 ?? ?? ?? ?? E8 B9 01 9B 1E 1D 19 68 87 E6 FF 29 3F F6 92 AE ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 53 F8 21 60 00 2E 3F F4 88 AE 04 F1 30 03 20 46 01 21 04 F1 28 02 B0 47 A3 68 00 28 E0 62 BF F6 40 AF 7B E6 01 9A 29 E6 }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "ttyslot"
		size = 110
		refs = "0008 __sysconf 001e setttyent 002c __ttyname_r 0036 endttyent 0044 strrchr 0052 strcmp 005a getttyent"
	strings:
		$1 = { F8 B5 48 20 00 AF 00 24 ?? ?? ?? ?? 45 1C 08 BF 20 25 05 F1 0E 03 23 F0 07 03 AD EB 03 0D ?? ?? ?? ?? 6E 46 20 46 31 46 2A 46 01 34 ?? ?? ?? ?? 30 B1 03 2C F6 D1 ?? ?? ?? ?? 00 20 BD 46 F8 BD 30 46 2F 21 ?? ?? ?? ?? 00 B1 46 1C 01 24 04 E0 00 68 ?? ?? ?? ?? 30 B1 01 34 ?? ?? ?? ?? 31 46 00 28 F5 D1 E7 E7 ?? ?? ?? ?? 20 46 E6 E7 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "__atomic_pwritev_replacement"
		size = 232
		refs = "007c mempcpy 008c __pwrite 0094 free 00c4 __libc_alloca_cutoff 00ce malloc 00e4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F B2 F1 00 0B 83 B0 80 46 8A 46 00 AF 99 46 54 DD 4A 68 B2 F1 00 4F 3E BF 00 26 8C 46 35 46 04 D3 3D E0 DC F8 04 20 94 42 39 D3 01 36 4F F6 FF 74 5E 45 C7 F6 FF 74 15 44 0C F1 08 0C C5 EB 04 04 EF D1 B5 F5 80 5F 3A D8 05 F1 0E 03 BB F1 00 0F 23 F0 07 03 AD EB 03 0D 4F F0 00 03 C7 F8 04 D0 3B 60 0D DD 00 24 78 68 26 46 0A EB 04 02 5A F8 04 10 01 36 08 34 52 68 ?? ?? ?? ?? 5E 45 F4 D1 40 46 79 68 2A 46 4B 46 ?? ?? ?? ?? 04 46 38 68 ?? ?? ?? ?? 20 46 0C 37 BD 46 BD E8 F0 8F 10 4B 1D EE 70 2F 4F F0 FF 34 16 21 7B 44 1B 68 20 46 0C 37 D1 50 BD 46 BD E8 F0 8F 00 25 C4 E7 28 46 ?? ?? ?? ?? 00 28 BF D1 28 46 ?? ?? ?? ?? 78 60 08 B1 38 60 C6 E7 7B 68 4F F0 FF 34 3B 60 D6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_419_1_0 {
	meta:
		name = "pwritev"
		size = 180
		refs = "0004 __libc_multiple_threads 0020 __libc_do_syscall 0054 __libc_enable_asynccancel 0078 __libc_disable_asynccancel 00a8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 81 46 88 46 17 46 24 68 1E 46 EC B9 DD 17 4F F4 B5 7C 2C 46 ?? ?? ?? ?? 10 F5 80 5F 29 D8 04 46 00 2C 02 DB 20 46 BD E8 F0 87 1C 4B 1D EE 70 2F 7B 44 1B 68 D3 58 26 2B F4 D1 48 46 41 46 3A 46 33 46 BD E8 F0 47 61 E7 ?? ?? ?? ?? F5 17 41 46 3A 46 33 46 4F F4 B5 7C 2C 46 82 46 48 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0D D8 50 46 ?? ?? ?? ?? D6 E7 0B 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 CB E7 07 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E7 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_420_0_0 {
	meta:
		name = "fwide"
		size = 290
		refs = "005e _IO_fwide 00ae __libc_do_syscall 00cc __lll_lock_wait_private 011e _Unwind_Resume"
	strings:
		$1 = { 00 29 70 B5 04 46 59 DB 01 D1 C0 6E 70 BD 01 25 E0 6E 00 28 51 D1 23 68 18 04 1C D4 A0 6C 1D EE 70 6F A6 F5 98 66 83 68 B3 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 D1 A3 6C 18 46 9E 60 43 68 01 33 43 60 69 1C 33 D0 29 46 20 46 ?? ?? ?? ?? 05 46 23 68 1A 04 25 D4 A0 6C 43 68 01 3B 43 60 03 BB 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 0D DD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 28 46 70 BD 28 46 70 BD 70 BD 4F F0 FF 35 A6 E7 E0 6E 00 28 CC D1 E5 66 CB E7 ?? ?? ?? ?? BB E7 23 68 05 46 1B 04 20 D4 A3 6C 5A 68 01 3A 5A 60 DA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 08 DD B1 68 01 22 18 46 4F F0 F0 0C 00 23 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "calc_sizes"
		size = 120
	strings:
		$1 = { 38 B5 0C 46 03 68 05 69 00 2B 2C D0 89 68 00 22 01 31 A1 60 00 E0 01 32 18 33 53 F8 14 1C 00 29 F9 D1 53 F8 18 1C 00 29 F5 D1 53 F8 08 1C 00 29 F1 D1 53 F8 04 1C 00 29 ED D1 21 68 02 EB 42 00 63 68 01 44 21 60 13 44 63 60 A5 B1 28 68 90 B1 21 46 FF F7 D5 FF E3 68 55 F8 10 0F 01 33 E3 60 00 28 F5 D1 38 BD 43 68 00 2B EE D0 8B 68 01 33 8B 60 00 2D EA D1 38 BD }
	condition:
		$1
}

rule file_421_1_0 {
	meta:
		name = "argp_default_parser"
		size = 190
		refs = "001c __argp_state_help 0026 program_invocation_name 0036 strrchr 0048 program_invocation_short_name 0066 .LC0 0078 .LANCHOR0 007c strtol 008a __sleep"
	strings:
		$1 = { 30 B5 0D 46 C1 1C 83 B0 4D D0 2A DD 83 1C 0A D0 3F 28 45 D1 10 46 40 F2 7A 22 01 6B ?? ?? ?? ?? 00 20 03 B0 30 BD ?? ?2 0? 0? 28 46 ?? ?2 0? 0? 2F 21 1D 60 01 92 ?? ?? ?? ?? 01 9A 90 62 00 28 3A D0 01 30 90 62 11 69 ?? ?2 0? 0? ?? ?2 0? 0? 01 F0 03 01 01 29 18 60 1F D1 93 68 00 20 1D 60 DF E7 04 30 1C D1 ?? ?2 0? 0? 00 21 ?? ?2 0? 0? 0A 22 00 2D 18 BF 28 46 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 20 60 02 E0 01 20 ?? ?? ?? ?? 23 68 00 2B 03 F1 FF 32 22 60 F6 DC 00 20 03 B0 30 BD 07 20 03 B0 30 BD 10 46 40 F2 01 22 01 6B ?? ?? ?? ?? 00 20 03 B0 30 BD 28 46 95 62 C3 E7 }
	condition:
		$1
}

rule file_421_2_0 {
	meta:
		name = "convert_options"
		size = 456
		refs = "00c6 strcmp 01c4 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 06 68 1F 46 07 92 02 69 04 90 06 91 03 92 12 9D 00 2E 00 F0 98 80 06 F1 18 0B BA 46 A8 46 48 F6 39 63 C3 F6 E3 03 05 93 5B F8 14 2C AB F1 18 01 1A B9 5B F8 18 3C 00 2B 76 D0 5B F8 0C 3C 58 07 5C BF 0E 46 19 46 00 D5 F1 68 09 07 65 D4 1F 07 2A D4 53 1E FE 2B 27 D8 59 4B 1D EE 70 1F 7B 44 1B 68 CB 58 33 F8 12 30 5D 04 1D D5 D8 F8 04 30 59 1C C8 F8 04 10 1A 70 B3 68 83 B1 D8 F8 04 30 4F F0 3A 01 5A 1C C8 F8 04 20 19 70 F3 68 DC 07 41 BF D8 F8 04 30 5A 1C C8 F8 04 20 19 70 D8 F8 04 30 4F F0 00 02 1A 70 5B F8 18 5C 00 2D 34 D0 D8 F8 00 90 D9 F8 08 70 38 68 40 B1 3C 46 29 46 ?? ?? ?? ?? 60 B3 54 F8 10 0F 00 28 F7 D1 D8 F8 08 30 B2 68 1D 60 11 46 2A B1 F2 68 12 F0 01 0F 0C BF 01 21 02 21 5B F8 14 2C 00 24 59 60 9C 60 3A B3 D9 F8 34 00 22 F0 7F 42 05 9C 03 F1 10 01 C0 EB 0A 00 80 10 04 FB 00 F0 01 30 02 EB 00 62 DA 60 C8 F8 08 10 00 21 19 61 0B F1 18 0B 83 E7 E4 1B 0F 34 F9 DA D2 E7 5B F8 08 3C 00 2B 84 D1 5B F8 04 3C 00 2B 80 D1 04 9C 57 46 45 46 61 68 05 E0 72 68 D5 E7 04 9C 61 68 00 29 35 D0 04 9C 00 23 6A 68 39 60 7C 60 06 9C BA 60 07 9A 3C 61 03 9C 7A 61 FB 60 BB 61 3B 62 FB 61 64 B1 22 68 0A B3 22 46 52 F8 10 1F 01 33 00 29 FA D1 9B 00 EA 68 13 44 FA 61 EB 60 07 F1 24 03 03 9A 72 B1 10 68 60 B1 92 46 00 26 32 46 00 95 39 46 01 36 FF F7 2B FF 03 46 5A F8 10 0F 00 28 F4 D1 18 46 09 B0 BD E8 F0 8F 13 46 E2 E7 0F 46 E6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_421_3_0 {
	meta:
		name = "argp_version_parser"
		size = 102
		refs = "000c argp_program_version_hook 002a argp_program_version 0036 .LC1 0040 fprintf 0048 .LC2 0054 __dcgettext 005c __argp_error 0062 exit"
	strings:
		$1 = { 56 28 10 B5 14 46 01 D0 07 20 10 BD ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 43 B1 10 6B 11 46 98 47 23 69 13 F0 20 00 1D D0 00 20 10 BD ?? ?2 0? 0? ?? ?2 0? 0? 1A 68 3A B1 ?? ?2 0? 0? 20 6B ?? ?2 0? 0? ?? ?? ?? ?? EB E7 23 68 ?? ?2 0? 0? ?? ?2 0? 0? 05 22 98 69 ?? ?? ?? ?? 01 46 20 46 ?? ?? ?? ?? DD E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_421_4_0 {
	meta:
		name = "__argp_parse"
		size = 2548
		refs = "0072 malloc 00d6 memset 0130 stdout 0134 stderr 01b6 program_invocation_short_name 0216 _getopt_long_only_r 023e strchr 0324 argp_program_version 0328 .LANCHOR1 0590 bad_key_err.12166 059c __dcgettext 05a0 .LC4 05ae __argp_error 05d8 __argp_state_help 06aa free 06be _getopt_long_r 079a .LC3 07b4 .LC5 08fe strrchr 090c argp_program_version_hook 093e .LC6 0958 fprintf"
	strings:
		$1 = { 2D E9 F0 4F BB B0 13 F0 10 04 02 AF 1D 46 81 46 39 61 FA 60 00 F0 65 81 13 F0 04 04 4F F0 00 03 14 BF 00 20 01 20 BC 60 3B 64 B8 61 7B 64 BB 64 FB 64 3B 65 7B 65 BB 65 FB 65 FB 61 3B 62 7B 62 B9 F1 00 0F 00 F0 33 81 48 46 07 F1 18 01 FF F7 23 FE 3E 6A FB 69 01 36 7C 6A 01 33 B8 69 06 EB C6 0B 0B EB 83 03 7C 61 23 44 4F EA 83 0A 50 44 01 30 ?? ?? ?? ?? 80 46 C7 F8 DC 00 00 28 00 F0 2A 81 07 F1 38 0E 01 23 BB 63 07 F1 6C 04 FB 63 06 EB C6 06 BE E8 0F 00 08 EB 86 06 D7 F8 14 C0 C7 F8 94 80 DC 44 C7 F8 9C 60 0F C4 08 EB 8C 0C BE E8 0F 00 08 EB 0A 0B C7 F8 68 C0 C7 F8 64 B0 0F C4 79 69 8A 00 9E E8 03 00 84 E8 03 00 30 46 00 21 C7 F8 04 C0 ?? ?? ?? ?? D7 F8 04 C0 2C 07 07 F1 60 02 7E 63 C7 F8 30 C0 C7 F8 2C B0 BA 62 40 F1 E5 80 0B F1 01 03 2D 22 FB 62 08 F8 0A 20 3A 6B 00 21 19 70 D7 F8 94 30 11 60 C7 F8 60 90 B9 F1 00 0F 00 F0 89 81 0A 46 48 46 07 F1 28 04 00 94 FF F7 55 FE 3A 6E D7 F8 94 30 C7 F8 98 00 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 83 42 C7 F8 A4 20 09 68 4F F0 00 02 26 68 4F F0 01 04 C7 F8 B4 50 07 F1 60 05 C7 F8 D4 10 39 69 C7 F8 D8 50 C7 F8 D0 60 C7 F8 A8 10 F9 68 C7 F8 B0 20 C7 F8 B8 20 C7 F8 AC 10 C7 F8 BC 20 C7 F8 C0 20 C7 F8 C4 20 C7 F8 C8 20 C7 F8 CC 20 C7 F8 A0 40 C0 F0 F1 80 D7 F8 B4 30 98 07 00 F1 4A 81 D7 F8 A8 50 01 22 D7 F8 AC 30 2C 46 3A 67 F9 68 99 42 00 F0 9E 83 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 C7 F8 CC 30 4F F0 00 09 4F F0 FF 3A 20 46 D7 F8 BC 20 D7 F8 B0 30 1A B1 9A 42 C8 BF C7 F8 BC 90 D7 F8 A0 20 00 2A 00 F0 55 81 D7 F8 BC 60 00 2E 40 F0 50 81 D7 F8 B4 20 FB 66 12 F0 40 0F C7 F8 74 A0 D7 F8 AC 10 7A 6E BB 6E 00 96 00 F0 54 82 07 F1 6C 04 01 94 ?? ?? ?? ?? 04 46 FB 6E 61 1C C7 F8 B0 30 00 F0 1B 81 3F 2C 00 F0 C9 81 01 2C 00 F0 D7 82 26 16 40 F0 80 81 78 6E 21 46 ?? ?? ?? ?? 00 28 00 F0 A1 81 D7 F8 94 50 D7 F8 98 20 95 42 04 D3 99 E1 24 35 95 42 80 F0 96 81 AB 68 98 42 F8 D2 D5 F8 00 C0 B9 6F BC F1 00 0F 00 F0 8C 81 AB 69 07 F1 A4 02 20 46 90 46 C7 F8 C0 30 EB 69 C7 F8 C4 30 EB 68 C7 F8 B8 30 2B 6A C7 F8 C8 30 E0 47 D7 F8 C8 30 2B 62 07 28 00 F0 67 83 00 28 40 F0 6C 83 D7 F8 A8 50 28 46 8F E7 4F F0 34 0A C7 F8 14 90 4F F0 09 0B 01 26 D7 E6 BC 68 5B 46 00 2C 3F F4 1C AF 0B F1 01 03 2B 22 FB 62 8B F8 00 20 14 E7 0C 25 28 46 E4 37 BD 46 BD E8 F0 8F 92 B0 21 46 0D F1 08 08 8A B0 02 AE 40 46 33 46 40 22 43 F8 04 4B 04 33 74 60 43 F8 04 4B 43 F8 04 4B 43 F8 04 4B 43 F8 04 4B 1C 60 C6 F8 10 80 ?? ?? ?? ?? B9 F1 00 0F 03 D0 C8 F8 00 90 08 F1 10 08 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? C8 F8 00 20 1B 68 00 2B 00 F0 E6 82 9E 4B 08 F1 20 02 C8 F8 10 30 15 F0 04 04 4F F0 00 03 14 BF 00 21 01 21 BC 60 B1 46 B9 61 13 60 3B 64 7B 64 BB 64 FB 64 3B 65 7B 65 BB 65 FB 65 FB 61 3B 62 7B 62 67 E6 D7 F8 0C 11 03 F1 24 06 99 61 1F E0 56 F8 08 4C 56 F8 0C 5C C7 F8 C4 40 56 F8 18 4C C7 F8 B8 40 56 F8 04 4C C7 F8 C0 50 C7 F8 C8 40 98 47 D7 F8 C8 30 46 F8 04 3C 05 46 D7 F8 98 30 B3 42 06 F1 24 06 2F D9 00 2D 18 BF 07 2D 89 D1 56 F8 14 3C 03 20 C0 F2 00 10 00 21 07 F1 A4 02 33 B1 DB 69 56 F8 10 4C 53 F8 24 30 46 F8 0C 3C 56 F8 24 3C 00 2B CB D1 56 F8 20 3C 07 25 1B 69 00 2B DB D0 1B 68 00 2B D8 D0 56 F8 08 3C 56 F8 0C 4C 1C 60 56 F8 24 3C 00 2B B9 D1 D7 F8 98 30 B3 42 06 F1 24 06 CF D8 07 2D 3F F4 BA AE 00 2D 7F F4 58 AF B5 E6 4A 46 18 46 C7 F8 98 30 7D E6 13 F0 01 0F D7 F8 A8 50 D7 F8 AC 30 4F F0 00 02 18 BF 6C 1C 3A 67 17 BF 04 3B 2C 46 C7 F8 A8 40 25 46 18 BF C7 F8 AC 30 A7 E6 01 2B C7 F8 A0 90 40 F3 B9 81 D7 F8 AC 10 03 F1 80 42 01 3A 51 F8 22 20 11 78 2D 29 40 F0 AE 81 51 78 2D 29 40 F0 AA 81 92 78 D7 F8 A8 50 0A B9 C7 F8 BC 30 28 46 83 42 C0 F2 16 81 D7 F8 B0 30 AB 42 00 F0 A7 81 D7 F8 08 51 00 2D 00 F0 3C 82 2B 60 D7 F8 94 30 D7 F8 98 20 A2 F1 24 08 98 45 C0 F0 50 82 A2 F1 48 08 1F E0 D8 F8 40 30 D8 F8 44 60 D8 F8 3C 50 C7 F8 C4 30 D8 F8 30 30 C7 F8 C8 60 C7 F8 C0 50 C7 F8 B8 30 A0 47 D7 F8 94 30 D7 F8 C8 20 98 45 A8 F1 24 08 C8 F8 68 20 14 D3 00 28 18 BF 07 28 40 F0 6F 81 D8 F8 24 40 04 20 00 21 C0 F2 00 10 07 F1 A4 02 00 2C D5 D1 98 45 4F F0 07 00 A8 F1 24 08 EA D2 D7 F8 98 20 07 28 05 46 08 BF 00 25 A2 F1 24 08 86 E0 06 EB C6 03 D7 F8 94 20 B9 6F 9B 00 24 3B 02 EB 03 0B D3 58 00 2B 00 F0 15 81 DB F8 18 50 07 F1 A4 02 44 F3 17 00 90 46 C7 F8 C0 50 DB F8 1C 50 C7 F8 C4 50 DB F8 0C 50 C7 F8 B8 50 DB F8 20 50 C7 F8 C8 50 98 47 D7 F8 C8 30 CB F8 20 30 87 E6 07 F1 A4 06 3B 6E ?? ?2 0? 0? ?? ?2 0? 0? 05 22 98 69 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 22 46 03 46 30 46 ?? ?? ?? ?? 01 2C 08 D1 D7 F8 A8 50 6E E7 ?? ?? ?? ?? 7B 6F 01 33 3F F4 39 AE D7 F8 D0 40 07 25 21 46 07 F1 A4 00 4F F4 82 72 ?? ?? ?? ?? D7 F8 98 40 D7 F8 94 30 A3 42 28 BF A4 F1 24 08 2C D2 03 F1 24 09 A8 46 59 F8 24 5C 05 20 C0 F2 00 10 00 21 07 F1 A4 02 CA 46 B5 B1 59 F8 18 3C 59 F8 08 4C 59 F8 0C 6C C7 F8 B8 30 59 F8 04 3C C7 F8 C4 40 C7 F8 C0 60 C7 F8 C8 30 A8 47 D7 F8 C8 30 D7 F8 98 40 49 F8 04 3C A2 45 09 F1 24 09 DA D3 D7 F8 94 30 45 46 A4 F1 24 08 98 45 24 BF A8 F1 24 08 A9 46 25 D3 D8 F8 24 50 07 20 C0 F2 00 10 00 21 07 F1 A4 02 C2 46 B5 B1 D8 F8 30 30 D8 F8 3C 60 D8 F8 40 40 C7 F8 B8 30 D8 F8 44 30 C7 F8 C0 60 C7 F8 C4 40 C7 F8 C8 30 A8 47 D7 F8 C8 20 D7 F8 94 30 C8 F8 44 20 53 45 A8 F1 24 08 DA D9 4D 46 D7 F8 DC 00 07 2D 08 BF 16 25 ?? ?? ?? ?? 28 46 E4 37 BD 46 BD E8 F0 8F 07 F1 6C 05 01 95 ?? ?? ?? ?? 04 46 AA E5 D7 F8 B4 20 52 07 3F F5 E5 AE D7 F8 AC 20 52 F8 23 60 01 33 BE 67 D7 F8 94 20 03 F1 FF 38 D7 F8 98 50 C7 F8 B0 80 95 42 40 F2 FE 80 02 F1 24 0B 43 46 AE 46 5B F8 24 5C 5C 1C 31 46 07 F1 A4 02 00 20 C7 F8 B0 40 7D B3 5B F8 08 3C 5B F8 0C 4C C7 F8 C4 30 5B F8 18 3C C7 F8 B8 30 5B F8 04 3C C7 F8 C0 40 C7 F8 C8 30 A8 47 D7 F8 C8 30 4B F8 04 3C 07 28 00 F0 22 81 D7 F8 B0 30 70 B9 43 45 C9 BF 00 20 00 20 5B F8 18 2C C8 EB 03 03 D9 BF 01 21 C7 F8 A0 10 D2 18 4B F8 18 2C 07 28 4F F0 01 04 7F F4 9A AD 21 E7 C7 F8 B0 30 F3 45 80 F0 BB 80 0B F1 24 0B BD E7 07 F1 A4 06 BB 6E DA 68 A2 42 04 D1 1D E0 10 33 DA 68 A2 42 19 D0 1A 68 00 2A F8 D1 ?? ?2 0? 0? ?? ?2 0? 0? 3B 6E ?? ?2 0? 0? ?? ?2 0? 0? 05 22 98 69 ?? ?? ?? ?? ?? ?2 0? 0? 2A 46 ?? ?2 0? 0? 03 46 30 46 ?? ?? ?? ?? F4 E6 1D 68 ?? ?2 0? 0? ?? ?2 0? 0? 00 2D 08 BF 1D 46 E3 E7 D7 F8 A8 50 28 46 58 E6 BE 6F 7A E7 D7 F8 98 20 05 46 A2 F1 24 08 2A E7 D7 F8 94 30 D7 F8 98 40 A3 42 80 F0 B5 80 00 25 03 F1 24 06 28 46 1C E0 56 F8 0C 4C C7 F8 C0 40 56 F8 08 4C C7 F8 C4 40 56 F8 04 4C C7 F8 B8 50 C7 F8 C8 40 98 47 D7 F8 C8 30 D7 F8 98 40 46 F8 04 3C B4 42 06 F1 24 06 13 D9 00 28 18 BF 07 28 0F D1 56 F8 18 5C 00 2D F3 D1 56 F8 24 3C 02 20 29 46 C0 F2 00 10 07 F1 A4 02 00 2B D4 D1 07 20 E7 E7 D7 F8 94 30 05 46 A4 F1 24 02 93 42 2B D8 07 2D 18 BF 00 2D 2A D1 48 3C 19 E0 23 6C E6 6B C7 F8 C4 30 23 6B C7 F8 B8 30 63 6C C7 F8 C0 60 C7 F8 C8 30 A8 47 D7 F8 C8 20 D7 F8 94 30 62 64 9C 42 A4 F1 24 04 0E D3 00 28 18 BF 07 28 37 D1 65 6A 01 20 00 21 C0 F2 00 10 07 F1 A4 02 00 2D DC D1 07 20 EC E7 05 46 07 2D 08 BF 00 25 D7 F8 08 41 14 B1 D7 F8 B0 20 22 60 00 2D 3F F4 E9 AD 07 2D 7F F4 7A AE D7 F8 D0 40 6F E6 07 20 37 E7 0E 68 00 2E 3F F4 5E AC 30 46 2F 21 ?? ?? ?? ?? 80 B3 01 30 C7 F8 CC 00 5B E4 ?? ?2 0? 0? 08 F1 10 02 ?? ?2 0? 0? 1B 68 00 2B 7F F4 10 AD 13 E5 05 46 D4 E7 D7 F8 B4 30 9B 07 3F F5 4C AE D7 F8 D0 40 07 25 00 2C 3F F4 49 AE 3B 6E ?? ?2 0? 0? ?? ?2 0? 0? 05 22 07 25 98 69 ?? ?? ?? ?? D7 F8 CC 20 01 46 20 46 ?? ?? ?? ?? D7 F8 D0 40 35 E6 00 25 70 E6 30 46 CD E7 00 25 7D E7 43 46 B0 46 1E 46 B8 F1 00 0F 3F F4 09 AE 01 E7 05 46 AF E7 D7 F8 B0 30 5B F8 24 4C 01 3B C7 F8 B0 30 2C B3 5B F8 08 5C 06 20 5B F8 04 2C C0 F2 00 10 5B F8 0C 3C 00 21 C7 F8 C4 50 5B F8 18 5C C7 F8 C8 20 07 F1 A4 02 C7 F8 C0 30 C7 F8 B8 50 A0 47 D7 F8 98 E0 D7 F8 C8 30 DE 45 4B F8 04 3C 09 D9 07 28 07 D1 D7 F8 B0 30 0B F1 24 0B 8D E6 D7 F8 98 E0 C6 E6 00 28 7F F4 BC AE D7 F8 A8 30 C7 F8 B0 30 A7 E6 }
	condition:
		$1
}

rule file_421_5_0 {
	meta:
		name = "__argp_input"
		size = 38
	strings:
		$1 = { 79 B1 4A 6B 53 6B 91 6B 8B 42 03 D3 07 E0 24 33 8B 42 04 D2 5A 68 82 42 F9 D1 98 69 70 47 00 20 70 47 08 46 70 47 }
	condition:
		$1
}

rule file_422_1_0 {
	meta:
		name = "do_release_shlib"
		size = 100
		refs = "0012 .LANCHOR0 0034 __libc_dlclose 0046 .LC0 004a .LC1 004e __PRETTY_FUNCTION__.11218 0060 __assert_fail"
	strings:
		$1 = { 03 29 18 BF 00 29 38 B5 0C BF 00 25 01 25 04 68 13 D1 ?? ?2 0? 0? ?? ?2 0? 0? 5B 68 9C 42 63 68 0C D0 9A 1C 02 2A 08 D8 01 3B 63 60 03 33 04 D1 A0 68 10 B1 ?? ?? ?? ?? A5 60 38 BD 00 2B 02 DD 01 3B 63 60 38 BD ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? AD 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_422_2_0 {
	meta:
		name = "__gconv_find_shlib"
		size = 296
		refs = "0008 .LANCHOR0 0010 known_compare 0020 __tfind 0044 __libc_dlopen_mode 004e .LC3 0056 __libc_dlsym 0062 .LC4 0070 .LC5 00aa strlen 00b2 malloc 00c4 memcpy 00de __tsearch 00e8 free 00f6 do_release_shlib 0104 __twalk 010a .LC2 010e .LC1 0112 __PRETTY_FUNCTION__.11210 0124 __assert_fail"
	strings:
		$1 = { 2D E9 F0 43 83 B0 02 AB ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 43 F8 04 0D 29 46 18 46 ?? ?2 0? 0? ?? ?? ?? ?? 06 46 00 28 3C D0 04 68 00 2C 5D D0 63 68 9A 1C 2B DA A3 68 00 2B 66 D1 01 21 20 68 C8 F2 00 01 ?? ?? ?? ?? A0 60 00 28 4E D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 03 46 E0 60 00 28 49 D0 ?? ?2 0? 0? A0 68 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 20 61 A0 68 ?? ?? ?? ?? 01 23 63 60 60 61 20 46 03 B0 BD E8 F0 83 A2 68 22 B1 00 2B CC BF 01 33 01 23 63 60 20 46 03 B0 BD E8 F0 83 DD F8 04 90 48 46 ?? ?? ?? ?? 80 46 19 30 ?? ?? ?? ?? 07 46 04 46 B8 B1 49 46 08 F1 01 02 18 30 ?? ?? ?? ?? ?? ?2 0? 0? 6F F0 02 03 ?? ?2 0? 0? 29 46 BE 60 87 E8 09 00 38 46 ?? ?? ?? ?? 00 28 A4 D1 38 46 ?? ?? ?? ?? 00 24 20 46 03 B0 BD E8 F0 83 ?? ?2 0? 0? 28 68 ?? ?2 0? 0? 6C 60 1C 46 ?? ?? ?? ?? C8 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 73 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_422_3_0 {
	meta:
		name = "__gconv_release_shlib"
		size = 24
		refs = "0000 .LANCHOR0 0004 do_release_shlib 0014 __twalk"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 58 60 18 68 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_422_4_0 {
	meta:
		name = "do_release_all"
		size = 22
		refs = "0008 __libc_dlclose 0012 free"
	strings:
		$1 = { 10 B5 04 46 80 68 08 B1 ?? ?? ?? ?? 20 46 BD E8 10 40 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_422_5_0 {
	meta:
		name = "free_mem"
		size = 30
		refs = "0002 .LANCHOR0 000a do_release_all 0014 __tdestroy"
	strings:
		$1 = { 10 B5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 20 68 ?? ?? ?? ?? 00 23 23 60 10 BD }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "__fortify_fail"
		size = 48
		refs = "0002 __libc_argv 0006 .LC0 0016 .LC1 002a __libc_message"
	strings:
		$1 = { 70 B5 ?? ?2 0? 0? ?? ?2 0? 0? 06 46 ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 ?? ?2 0? 0? ?? ?2 0? 0? 02 20 32 46 1B 68 00 2B 08 BF 23 46 ?? ?? ?? ?? F1 E7 }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "__iswctype"
		size = 90
		altNames = "__iswctype_l"
	strings:
		$1 = { 10 B4 31 B3 0B 68 4A 68 20 FA 03 F3 93 42 28 BF 00 20 17 D2 05 33 51 F8 23 30 B3 B1 8C 68 CA 68 20 FA 04 F4 22 40 03 EB 82 03 CB 58 6B B1 0A 69 00 F0 1F 04 02 EA 50 10 03 EB 80 03 C8 58 E0 40 00 F0 01 00 5D F8 04 4B 70 47 18 46 5D F8 04 4B 70 47 08 46 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "memcpy_uppcase"
		size = 42
		refs = "0018 __towupper_l"
	strings:
		$1 = { 2D E9 F0 41 80 46 1F 46 62 B1 95 00 14 46 4E 19 05 44 56 F8 04 0D 39 46 ?? ?? ?? ?? 01 3C 45 F8 04 0D F6 D1 40 46 BD E8 F0 81 }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "__strftime_internal"
		size = 4598
		refs = "0040 .LC5 004e __tzname 006c .LC3 02b4 wmemset 02c2 __wmemcpy 0334 __wcslen 03bc __towlower_l 03d6 .LC4 0476 __towupper_l 0792 mktime 08f4 .LC2 0b60 .LC1 0b74 .LC0 0ca4 __mbsrtowcs_l 0eb2 _nl_get_walt_digit 1130 _nl_get_era_entry 11d0 __tzset"
	strings:
		$1 = { 2D E9 F0 4F AF B0 02 AF 06 46 92 46 9C 68 3B 64 F9 64 7C 64 9C 6A 3C 62 D7 F8 DC 40 A4 68 7C 62 7C 6C 0C 2C C4 BF 0C 3C 7C 64 04 DC 7C 6C 00 2C 08 BF 0C 24 7C 64 DA F8 00 30 00 2B 00 F0 B5 87 ?? ?2 0? 0? 4F F0 00 0B ?? ?2 0? 0? BC 63 ?? ?2 0? 0? ?? ?2 0? 0? 7C 63 48 F2 1F 54 C5 F2 EB 14 FC 62 42 F2 93 44 C9 F2 49 24 3C 63 ?? ?2 0? 0? ?? ?2 0? 0? FC 63 11 E0 FC 6C CB EB 04 02 01 2A 40 F2 DD 80 0E B1 46 F8 04 3B 0B F1 01 0B 53 46 5B 68 0A F1 04 0A 00 2B 00 F0 1F 81 25 2B 02 BF 00 21 B9 64 0D 46 E7 D1 5A F8 04 3F 30 2B 34 D0 2C D8 23 2B 08 BF 01 21 F6 D0 2D 2B 2D D0 A3 F1 30 02 09 2A 88 BF 4F F0 FF 34 28 D8 4C F6 CC 4C 00 24 0A F1 04 02 C0 F6 CC 4C FC 60 11 E0 52 F8 04 3C A3 F1 30 03 00 F0 A4 80 04 EB 84 04 03 EB 44 04 92 46 04 32 DA F8 00 30 A3 F1 30 00 09 28 0D D8 64 45 EB DD 6F F0 00 44 F2 E7 5E 2B 04 BF 01 24 BC 64 C8 D0 5F 2B D1 D1 1D 46 C4 E7 45 2B FC 60 00 F0 91 80 4F 2B 18 BF 4F F0 00 09 00 F0 8B 80 7A 2B 00 F2 92 80 DF E8 13 F0 8C 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 A9 03 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 90 00 5C 03 5C 06 42 06 1C 05 90 00 12 05 99 04 8C 04 EE 03 90 00 90 00 90 00 E1 03 90 00 90 00 E6 00 90 00 DC 03 CF 03 4D 01 FA 03 99 04 26 05 54 02 A6 01 81 05 90 00 90 00 90 00 90 00 90 00 90 00 3F 05 2A 04 1E 04 11 04 7A 04 90 00 99 04 2A 04 90 00 6C 04 35 06 29 06 A2 06 07 06 90 00 9E 06 90 00 52 03 19 03 F7 02 E2 02 90 00 8A 02 7E 02 60 02 97 02 07 2B 7F F6 59 AF 6F F0 00 44 59 E7 00 20 B4 37 BD 46 BD E8 F0 8F 99 46 0A F1 04 0A DA F8 00 30 6E E7 5A F8 04 3C AA F1 04 0A 25 2B 4F D0 FC 68 AA F1 04 03 4F F0 01 08 99 46 08 F1 01 08 04 3B D9 F8 00 20 25 2A F7 D1 FC 60 FC 68 C8 EB 04 03 FC 6C CB EB 04 02 00 2B AC BF 08 EB 03 04 08 F1 00 04 94 42 D2 D2 BE B1 00 2B 0C DD 30 2D 09 BF 30 46 30 46 29 46 1A 46 1C BF 1A 46 20 21 06 EB 83 06 ?? ?? ?? ?? B8 6C 49 46 C8 B9 30 46 42 46 ?? ?? ?? ?? 06 EB 88 06 53 46 A3 44 0A F1 04 0A 5B 68 00 2B 7F F4 E1 AE FC 6C 58 46 B4 37 00 2E 18 BF 00 2C 1C BF 00 23 33 60 BD 46 BD E8 F0 8F 30 46 42 46 D7 F8 DC 30 FF F7 6B FE E2 E7 D1 46 4F F0 01 08 B9 E7 4F F0 01 09 3C 6C 00 29 18 BF 4F F0 01 09 A3 68 BC 6C 18 BF 00 24 BC 64 7C 6A 0B 2B CC BF 4F F4 C6 72 4F F4 C4 72 22 44 50 68 7B 61 ?? ?? ?? ?? F9 6C 7B 69 CB EB 01 02 80 46 F8 68 C8 EB 00 04 00 2C AC BF 08 EB 04 00 08 F1 00 00 B8 62 90 42 BF F4 71 AF 00 2E 36 D0 00 2C 0E DD 30 2D 07 BF 30 46 22 46 30 46 22 46 0C BF 29 46 20 21 ?? ?? ?? ?? 06 EB 84 06 3C 6C A3 68 B9 F1 00 0F 00 F0 F8 85 7C 6A 0B 2B D4 BF 4F F4 C4 73 4F F4 C6 73 23 44 44 46 5B 68 B8 F1 00 0F 13 D0 4F EA 88 04 BC 64 03 EB 04 09 35 19 4C 46 D7 F8 DC 90 54 F8 04 0D 49 46 ?? ?? ?? ?? B8 F1 01 08 45 F8 04 0D F5 D1 BC 6C 26 44 BC 6A 53 46 A3 44 5C E6 ?? ?2 0? 0? ?? ?2 0? 0? D7 F8 D8 00 4F F0 FF 31 D7 F8 DC 40 42 46 3B 6C 00 90 00 20 01 94 FF F7 04 FE F9 6C CB EB 01 03 81 46 F8 68 C9 EB 00 04 00 2C AC BF 09 EB 04 0C 09 F1 00 0C 9C 45 BF F4 13 AF 00 2E 00 F0 DA 85 00 2C D8 BF 34 46 10 DD 30 2D 22 46 07 BF 29 46 30 46 30 46 20 21 7B 61 06 EB 84 04 C7 F8 10 C0 ?? ?? ?? ?? 7B 69 D7 F8 10 C0 D7 F8 D8 20 19 46 D7 F8 DC 30 20 46 E3 44 04 EB 89 04 00 92 42 46 01 93 3B 6C FF F7 CD FD B8 6C 58 B1 B4 42 09 D9 D7 F8 DC 50 30 68 29 46 ?? ?? ?? ?? 46 F8 04 0B B4 42 F7 D8 26 46 53 46 03 E6 B9 F1 45 0F 00 F0 4E 86 B9 F1 4F 0F 3F F4 E2 AE 3C 6C 63 69 FC 68 03 F2 6C 78 01 2C B8 BF 01 24 BC 62 B8 F1 00 0F A8 BF B9 F1 4F 0F 00 F0 FB 84 43 46 5F EA D8 79 4C F6 CD 4C FC 68 18 BF C8 F1 00 03 07 F1 AC 00 CC F6 CC 4C AC FB 03 12 80 46 D2 08 02 EB 82 01 A3 EB 41 01 13 46 01 F1 30 02 40 F8 04 29 00 2B F0 D1 FC 60 B9 F1 00 0F 04 D0 2D 23 A8 F1 04 08 C8 F8 00 30 2D 2D 00 F0 0F 85 07 F1 B0 03 BC 6A C8 EB 03 0C 1A 46 4F EA AC 0C CC EB 04 03 00 2B 2A DD 5F 2D FC 6C 00 F0 07 85 CB EB 04 01 BC 6A 8C 42 BF F4 85 AE B9 F1 00 0F 0C D0 08 F1 04 08 1E B1 2D 21 04 36 46 F8 04 1C C8 EB 02 0C 0B F1 01 0B 4F EA AC 0C 66 B1 30 46 1A 46 30 21 06 EB 83 06 7B 61 C7 F8 10 C0 ?? ?? ?? ?? D7 F8 10 C0 7B 69 9B 44 00 24 FC 60 F8 68 F9 6C CC EB 00 04 CB EB 01 03 00 2C AC BF 0C EB 04 09 0C F1 00 09 99 45 BF F4 55 AE 1E B3 00 2C 10 DD 30 2D C7 F8 10 C0 09 BF 30 46 30 46 29 46 22 46 1C BF 22 46 20 21 ?? ?? ?? ?? D7 F8 10 C0 06 EB 84 06 BC 6C 41 46 30 46 62 46 00 2C 00 F0 6A 84 D7 F8 DC 30 C7 F8 10 C0 FF F7 FF FC D7 F8 10 C0 06 EB 8C 06 CB 44 53 46 55 E5 B9 F1 4F 0F 3F F4 38 AE B9 F1 45 0F 00 F0 4B 85 7C 6A D4 F8 9C 81 F0 E6 B9 F1 45 0F 00 F0 9F 85 3C 6C 64 22 63 69 FC 68 02 2C B8 BF 02 24 BC 62 FC 6A D9 17 84 FB 03 40 FC 6A C1 EB 60 11 02 FB 11 33 13 44 84 FB 03 48 D9 17 C1 EB 68 18 02 FB 18 38 38 E7 B9 F1 4F 0F 3F F4 0E AE B9 F1 45 0F 00 F0 17 85 7C 6A D4 F8 98 81 C6 E6 B9 F1 45 0F 3F F4 02 AE FC 68 01 2C B8 BF 01 24 BC 62 3C 6C D4 F8 18 80 1F E7 3C 6C 23 6A 00 2B C0 F2 B0 84 D4 F8 24 80 FC 68 B8 F1 00 0F 04 F1 FF 33 FC 6C CB EB 04 02 C0 F2 DA 84 23 EA E3 7C 0C F1 01 0C 94 45 BF F4 D2 AD 96 B1 00 2B 0D DD 30 2D 30 46 1A 46 0C BF 29 46 20 21 C7 F8 10 C0 06 EB 83 06 ?? ?? ?? ?? D7 F8 10 C0 2B 23 46 F8 04 3B E3 44 48 F6 89 02 4F EA E8 73 C8 F6 88 02 64 21 82 FB 08 40 FC 68 40 44 04 2C B8 BF 04 24 BC 62 C3 EB 60 13 82 FB 03 02 D8 17 1A 44 C0 EB 62 12 C2 EB 02 10 A3 EB 80 03 01 FB 02 38 D4 E6 3C 6C A3 69 FC 68 06 33 01 2C B8 BF 01 24 BC 62 3C 6B DA 17 84 FB 03 41 19 44 C2 EB A1 02 C2 EB C2 02 9B 1A 03 F1 01 08 BF E6 F8 68 F9 6C 44 1E 24 EA E4 78 CB EB 01 03 08 F1 01 08 98 45 BF F4 7E AD 8E B1 00 2C 0C DD 30 2D 09 BF 30 46 30 46 29 46 22 46 1C BF 22 46 20 21 06 EB 84 06 ?? ?? ?? ?? 09 23 46 F8 04 3B C3 44 53 46 90 E4 D7 F8 40 C0 07 F1 54 0E BC E8 0F 00 AE E8 0F 00 BC E8 0F 00 AE E8 0F 00 9C E8 07 00 8E E8 07 00 07 F1 54 00 ?? ?? ?? ?? FB 68 46 F2 67 6C 07 F1 AC 01 C6 F2 66 6C 4F EA D0 79 4C 46 99 46 8C FB 00 32 C3 17 88 46 04 39 C3 EB A2 02 13 46 02 EB 82 02 A0 EB 42 02 18 46 04 B1 52 42 30 32 C8 F8 00 20 00 2B EB D1 4B 46 A1 46 FB 60 01 24 BC 62 88 E6 7C 6A D4 F8 A0 81 FC 6B D8 F8 00 30 00 2B 08 BF A0 46 F4 E5 B9 F1 00 0F 7F F4 30 AD 3C 6C A3 69 BC 6C 3B 33 00 29 18 BF 01 24 BC 64 9B B2 7C 6A 04 EB 83 03 59 6A 08 46 79 61 ?? ?? ?? ?? FA 6C 79 69 CB EB 02 03 80 46 F8 68 C8 EB 00 04 00 2C AC BF 08 EB 04 09 08 F1 00 09 99 45 BF F4 FF AC 00 2E 3F F4 CC AE 00 2C 14 DD 30 2D 03 BF 29 46 30 46 22 46 30 46 1C BF 22 46 20 21 ?? ?? ?? ?? 06 EB 84 06 3C 6C A3 69 7C 6A 3B 33 9B B2 04 EB 83 03 59 6A BC 6C 30 46 42 46 00 2C 00 F0 7A 83 D7 F8 DC 30 FF F7 A6 FB 06 EB 88 06 A7 E6 B9 F1 00 0F 7F F4 E3 AC F9 68 F8 6C 4C 1E 24 EA E4 78 CB EB 00 02 08 F1 01 08 90 45 BF F4 C8 AC 00 2E 3F F4 5A AF 00 2C 7F F7 55 AF 30 2D 09 BF 30 46 30 46 29 46 22 46 1C BF 22 46 20 21 ?? ?? ?? ?? 06 EB 84 06 DA F8 00 30 44 E7 B9 F1 45 0F 3F F4 BD AC FC 68 02 2C B8 BF 02 24 BC 62 3C 6C D4 F8 00 80 DA E5 ?? ?2 0? 0? ?? ?2 0? 0? 6F E5 B9 F1 45 0F 3F F4 AB AC FC 68 02 2C B8 BF 02 24 BC 62 3C 6C D4 F8 04 80 C8 E5 B9 F1 45 0F 3F F4 9E AC FC 68 D7 F8 44 80 02 2C B8 BF 02 24 BC 62 BC E5 B9 F1 45 0F 3F F4 92 AC 3C 6C E2 69 FC 68 02 2C B8 BF 02 24 BC 62 3C 6C A3 69 D3 1A 3C 6B 07 33 84 FB 03 41 DA 17 0B 44 C2 EB A3 08 A5 E5 B9 F1 45 0F 3F F4 7B AC FC 68 02 2C B8 BF 02 24 BC 62 3C 6C D4 F8 0C 80 98 E5 B9 F1 4F 0F 3F F4 6E AC B9 F1 45 0F 00 F0 8B 83 7C 6A D4 F8 94 81 26 E5 BC 6C 00 29 18 BF 01 24 BC 64 B9 F1 00 0F 7F F4 5F AC 3C 6C 23 69 7C 6A 42 33 9B B2 04 EB 83 03 59 6A 08 46 79 61 ?? ?? ?? ?? FA 6C 79 69 CB EB 02 03 80 46 F8 68 C8 EB 00 04 00 2C AC BF 08 EB 04 09 08 F1 00 09 99 45 BF F4 31 AC 00 2E 3F F4 FE AD 00 2C 7F F7 46 AF 30 2D 03 BF 29 46 30 46 22 46 30 46 1C BF 22 46 20 21 ?? ?? ?? ?? 06 EB 84 06 3C 6C 23 69 7C 6A 42 33 9B B2 04 EB 83 03 59 6A 2F E7 B9 F1 45 0F 3F F4 20 AC 3C 6C E3 69 FC 68 03 F1 01 08 03 2C B8 BF 03 24 BC 62 3C E5 B9 F1 45 0F 3F F4 12 AC 3C 6C D4 F8 0C 80 FC 68 02 2C B8 BF 02 24 BC 62 2D 2D 18 BF 30 2D 18 BF 5F 25 2A E5 B9 F1 45 0F 3F F4 00 AC FC 68 02 2C B8 BF 02 24 BC 62 3C 6C D4 F8 08 80 1D E5 B9 F1 45 0F 3F F4 F5 AB 3C 6C 38 6C 39 6B D4 F8 1C C0 A4 69 40 69 C4 EB 0C 02 02 F5 BF 72 00 F2 6C 78 F8 61 81 FB 02 10 D1 17 10 44 C1 EB A0 01 C1 EB C1 01 52 1A C2 EB 0C 02 03 32 BA 61 00 F1 00 83 18 F0 03 0F 18 BF 6F F4 B6 71 1D D1 F8 6A 80 FB 08 10 64 21 78 60 4F EA E8 70 7A 68 C0 EB 62 12 01 FB 12 81 00 29 40 F0 24 83 79 68 C0 EB E1 12 4F F4 C8 70 4F F6 92 61 00 FB 12 82 CF F6 FF 71 00 2A 18 BF 6F F4 B6 71 61 44 0A 1B 3C 6B 02 F5 BF 72 84 FB 02 4C D0 17 94 44 C0 EB AC 00 C0 EB C0 00 12 1A 8A 1A 03 32 56 BF F8 69 BA 69 00 F2 6D 78 47 2B 00 F0 85 82 67 2B 40 F0 72 82 FC 6A 4F EA E8 73 64 21 84 FB 08 42 FC 68 02 2C B8 BF 02 24 BC 62 FC 6A C3 EB 62 13 01 FB 13 83 0B 44 84 FB 03 48 DA 17 C2 EB 68 18 01 FB 18 38 A4 E4 ?? ?2 0? 0? ?? ?2 0? 0? B9 F1 00 0F 3F F4 37 AC FF F7 74 BB ?? ?2 0? 0? ?? ?2 0? 0? B9 F1 00 0F 3F F4 2D AC FF F7 6A BB B9 F1 45 0F 3F F4 66 AB 3C 6C A3 69 FC 68 06 33 02 2C B8 BF 02 24 BC 62 3C 6C D9 17 E2 69 3C 6B 84 FB 03 40 18 44 C1 EB A0 01 C1 EB C1 01 5B 1A C7 E6 B9 F1 00 0F 7F F4 4D AB 3C 6C A3 69 BC 6C 34 33 00 29 18 BF 01 24 BC 64 9B B2 7C 6A 04 EB 83 03 59 6A 08 46 79 61 ?? ?? ?? ?? FA 6C 79 69 CB EB 02 03 80 46 F8 68 C8 EB 00 04 00 2C AC BF 08 EB 04 09 08 F1 00 09 99 45 BF F4 1C AB 00 2E 3F F4 E9 AC 00 2C 7F F7 31 AE 30 2D 03 BF 29 46 30 46 22 46 30 46 1C BF 22 46 20 21 ?? ?? ?? ?? 06 EB 84 06 3C 6C A3 69 7C 6A 34 33 9B B2 04 EB 83 03 59 6A 1A E6 BC 6C 00 29 18 BF 00 24 BC 64 0C BF 00 24 01 24 BC 61 3C 6A 0C B1 23 78 A3 B9 3C 6C 23 6A 00 2B 0A DB D7 F8 D8 E0 9E F8 00 20 00 2A 00 F0 B1 82 7C 6B 54 F8 23 30 3B 62 3C 6A B9 6B 00 2C 08 BF 0C 46 3C 62 D7 F8 DC 40 4F F0 00 0E 72 46 70 46 07 F1 80 03 07 F1 54 01 00 94 3C 6A C7 F8 80 E0 C7 F8 84 E0 7C 65 ?? ?? ?? ?? D7 F8 0C E0 07 F1 54 01 07 F1 80 03 00 F1 01 09 02 46 80 46 C0 EB 0E 04 4F EA 89 09 00 2C AC BF 08 EB 04 0E 08 F1 00 0E 09 F1 0E 00 C7 F8 28 E0 20 F0 07 00 AD EB 00 0D 02 A8 F8 61 D7 F8 DC 00 00 90 F8 69 ?? ?? ?? ?? F9 6C BA 6A CB EB 01 03 9A 42 BF F4 A0 AA 00 2E 3F F4 65 AB 00 2C 0C DD 30 2D 09 BF 30 46 30 46 29 46 22 46 1C BF 22 46 20 21 06 EB 84 06 ?? ?? ?? ?? BC 69 00 2C 40 F0 58 81 BC 6C 42 46 F9 69 30 46 00 2C 00 F0 46 81 D7 F8 DC 30 A9 F1 04 09 FF F7 48 F9 4E 44 FF F7 42 BB F8 68 F9 6C 44 1E 24 EA E4 78 CB EB 01 03 08 F1 01 08 98 45 BF F4 6E AA 00 2E 3F F4 00 AD 00 2C 0C DD 30 2D 09 BF 30 46 30 46 29 46 22 46 1C BF 22 46 20 21 06 EB 84 06 ?? ?? ?? ?? 0A 23 46 F8 04 3B EC E4 B9 F1 45 0F 3F F4 63 AA FC 68 D7 F8 44 80 02 2C B8 BF 02 24 BC 62 50 E6 B9 F1 45 0F 3F F4 57 AA FC 68 02 2C B8 BF 02 24 BC 62 3C 6C D4 F8 08 80 43 E6 B9 F1 45 0F 00 F0 D4 81 3C 6C 64 22 63 69 FC 68 03 F2 6C 73 01 2C B8 BF 01 24 BC 62 FC 6A D9 17 84 FB 03 40 C1 EB 60 11 02 FB 11 33 A1 EB D3 78 FF F7 5B BB B9 F1 00 0F 7F F4 30 AA 3C 6C 23 69 BC 6C 4E 33 00 29 18 BF 01 24 BC 64 9B B2 7C 6A 04 EB 83 03 59 6A 08 46 79 61 ?? ?? ?? ?? FA 6C 79 69 CB EB 02 03 80 46 F8 68 C8 EB 00 04 00 2C AC BF 08 EB 04 09 08 F1 00 09 99 45 BF F4 FF A9 00 2E 3F F4 CC AB 00 2C 7F F7 14 AD 30 2D 03 BF 29 46 30 46 22 46 30 46 1C BF 22 46 20 21 ?? ?? ?? ?? 06 EB 84 06 3C 6C 23 69 7C 6A 4E 33 9B B2 04 EB 83 03 59 6A FD E4 4F F0 00 09 FF F7 46 BA B9 F1 45 0F 3F F4 EA A9 3C 6C 23 69 FC 68 03 F1 01 08 02 2C B8 BF 02 24 BC 62 FF F7 06 BB C7 F8 10 C0 ?? ?? ?? ?? D7 F8 10 C0 FF F7 96 BB 40 46 79 6A ?? ?? ?? ?? F8 61 00 28 3F F4 FD AA ?? ?? ?? ?? 81 46 00 28 3F F4 F7 AA F8 68 F9 6C C9 EB 00 04 CB EB 01 03 00 2C AC BF 09 EB 04 08 09 F1 00 08 98 45 BF F4 AB A9 00 2E 3F F4 3D AC 00 2C 0C DD 30 2D 09 BF 30 46 30 46 29 46 22 46 1C BF 22 46 20 21 06 EB 84 06 ?? ?? ?? ?? BC 6C 30 46 F9 69 4A 46 00 2C 45 D0 D7 F8 DC 30 FF F7 5A F8 06 EB 89 06 20 E4 07 F1 B0 02 C8 EB 02 0C 4F EA AC 0C FF F7 20 BB CB EB 04 02 93 42 BF F4 7F A9 66 B1 30 46 1A 46 20 21 06 EB 83 06 7B 61 C7 F8 10 C0 ?? ?? ?? ?? D7 F8 10 C0 7B 69 FC 68 9B 44 9C 42 DC BF 00 24 FC 60 7F F7 05 AB E4 1A FC 60 FF F7 01 BB ?? ?? ?? ?? 86 E4 BC 6C 0B 2B D4 BF 4F F4 C4 73 4F F4 C6 73 30 46 8C B1 79 6A 42 46 4F EA 88 04 19 44 D7 F8 DC 30 49 68 FF F7 1A F8 FF F7 14 BA ?? ?? ?? ?? BA E7 9B 46 FF F7 95 B9 7C 6A 42 46 23 44 4F EA 88 04 59 68 ?? ?? ?? ?? FF F7 04 BA A9 F1 04 09 ?? ?? ?? ?? 4E 44 FF F7 FE B9 E3 44 53 46 FF F7 5B B8 A9 F1 04 09 B8 F1 00 0F 3F F4 AF AE FD 69 06 EB 09 04 BE 64 4D 44 2E 46 D7 F8 DC 50 56 F8 04 0D 29 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_426_2_0 {
	meta:
		name = "__wcsftime_l"
		size = 26
	strings:
		$1 = { 70 B5 84 B0 04 AC 00 26 08 9D 04 F8 01 6D 8D E8 30 00 FE F7 F9 FE 04 B0 70 BD }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "_IO_new_fsetpos64"
		size = 364
		refs = "0052 _IO_seekpos_unlocked 00fe __libc_do_syscall 0104 __lll_lock_wait_private 015e _Unwind_Resume 0164 __libc_errno"
	strings:
		$1 = { 03 68 70 B5 0D 46 19 04 82 B0 04 46 1C D4 80 6C 1D EE 70 6F A6 F5 98 66 83 68 B3 42 11 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 63 D1 A3 6C 18 46 9E 60 43 68 01 33 43 60 D5 E9 00 23 03 21 20 46 00 91 ?? ?? ?? ?? B1 F1 FF 3F 08 BF B0 F1 FF 3F 27 D0 E3 6E 00 2B 05 DD A3 6D 18 46 1B 69 98 47 00 28 30 DB 00 25 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 1E DC 28 46 02 B0 70 BD 2C 4B 1D EE 70 2F 4F F0 FF 35 7B 44 1B 68 D3 58 00 2B D7 D1 28 4B 05 21 4F F0 FF 35 7B 44 1B 68 D1 50 CF E7 05 F1 08 02 E3 6D 00 25 92 E8 03 00 2C 33 83 E8 03 00 C5 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? D3 E7 ?? ?? ?? ?? 98 E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "div"
		size = 48
		refs = "000c __aeabi_idiv 0016 __aeabi_idivmod"
		altNames = "ldiv"
	strings:
		$1 = { F8 B5 0C 46 05 46 11 46 20 46 16 46 ?? ?? ?? ?? 31 46 07 46 20 46 ?? ?? ?? ?? 00 2C 04 DB 00 29 BC BF 01 37 C6 EB 01 01 2F 60 28 46 69 60 F8 BD }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "__mpn_add_n"
		size = 102
	strings:
		$1 = { 2D E9 F0 45 10 F1 00 0F 13 F0 01 0F 01 EB 83 0E 09 D0 51 F8 04 4B 52 F8 04 5B 6C 41 91 EA 0E 0F 40 F8 04 4B 19 D0 13 F0 02 0F 07 D0 30 C9 C0 CA 74 41 7D 41 91 EA 0E 0F 30 C0 0E D0 B1 E8 A8 04 B2 E8 50 11 63 41 75 41 57 EB 08 07 5A EB 0C 0A 91 EA 0E 0F A0 E8 A8 04 F0 D1 4F F0 00 00 40 EB 00 00 BD E8 F0 85 }
	condition:
		$1
}

rule file_430_1_0 {
	meta:
		name = "_dl_mcount_wrapper_check"
		size = 30
		refs = "0000 _dl_profile_map 0016 _dl_mcount"
	strings:
		$1 = { ?? ?2 0? 0? 01 46 ?? ?2 0? 0? 70 46 00 B5 1B 68 1B B1 5D F8 04 EB ?? ?? ?? ?? 5D F8 04 FB }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "__fbufsize"
		size = 30
	strings:
		$1 = { C3 6E 00 2B CD BF C3 6D 02 6A C3 69 D8 69 C3 BF 9B 69 C3 EB 00 00 80 10 C3 EB 02 00 70 47 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "check_one_fd"
		size = 172
		refs = "000c __libc_fcntl 003a .LC0 003e .LC1 005c __libc_do_syscall 0070 __fxstat64 00a4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 0F 46 9A B0 01 21 06 46 ?? ?? ?? ?? 01 30 02 D0 1A B0 BD E8 F0 81 22 4B 1D EE 70 8F 7B 44 1B 68 58 F8 03 30 09 2B F3 D1 07 F0 03 03 39 46 01 2B 4F F0 00 02 09 BF ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 07 14 00 25 0F BF ?? ?2 0? 0? 40 F2 03 14 00 25 ?? ?2 0? 0? 4F F0 05 0C ?? ?? ?? ?? 10 F5 80 5F 14 D8 86 42 11 D1 31 46 03 20 6A 46 ?? ?? ?? ?? 58 B9 04 9B 03 F4 70 43 B3 F5 00 5F 05 D1 DD E9 08 23 AB 42 08 BF A2 42 C2 D0 FE E7 05 4B 42 42 4F F0 FF 30 7B 44 1B 68 48 F8 03 20 E1 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_433_1_0 {
	meta:
		name = "__libc_check_standard_fds"
		size = 34
	strings:
		$1 = { 08 B5 00 20 48 F2 01 01 FF F7 A4 FF 01 20 4F F4 00 41 FF F7 9F FF 02 20 4F F4 00 41 BD E8 08 40 98 E7 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "tcsetattr"
		size = 180
		refs = "0080 __libc_do_syscall 00ac __libc_errno"
	strings:
		$1 = { 01 29 2D E9 F0 4F 14 46 8B B0 4B D0 02 29 46 D0 59 B1 26 4B 1D EE 70 2F 4F F0 FF 30 16 21 7B 44 1B 68 D1 50 0B B0 BD E8 F0 8F 45 F2 02 41 23 46 66 68 A5 68 01 AA 53 F8 11 AF 4F F0 36 0C E7 68 94 F8 10 E0 D3 F8 04 90 D3 F8 08 80 D3 F8 0C B0 CD F8 15 A0 B3 F8 10 A0 9B 7C 24 68 CD F8 19 90 24 F0 00 44 CD F8 1D 80 CD F8 21 B0 AD F8 25 A0 8D F8 27 30 01 94 02 96 03 95 04 97 8D F8 14 E0 ?? ?? ?? ?? 10 F5 80 5F CC D9 09 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 C2 E7 45 F2 04 41 C4 E7 45 F2 03 41 C1 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "__setresuid"
		size = 76
		refs = "0000 __nptl_setxid 0028 __libc_do_syscall 0048 __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 70 B5 06 46 86 B0 4B B1 01 A8 D0 23 02 96 03 91 04 92 01 93 ?? ?? ?? ?? 06 B0 70 BD 4F F0 D0 0C ?? ?? ?? ?? 10 F5 80 5F F6 D9 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 EC E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "__mbrlen"
		size = 32
		refs = "0000 .LANCHOR0 001c __mbrtowc"
	strings:
		$1 = { ?? ?2 0? 0? 10 B4 ?? ?2 0? 0? 0C 46 00 2A 18 BF 13 46 01 46 22 46 00 20 5D F8 04 4B ?? ?? ?? ?? }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "__fread_unlocked_chk"
		size = 86
		refs = "002a _IO_sgetn 0034 __aeabi_uidiv 0052 __chk_fail"
	strings:
		$1 = { 2D E9 F0 41 1E 46 13 43 15 46 B3 F5 80 3F 80 46 0F 46 06 FB 02 F4 14 D2 BC 42 1A D8 14 B9 20 46 BD E8 F0 81 41 46 06 98 22 46 ?? ?? ?? ?? 84 42 04 D0 29 46 ?? ?? ?? ?? BD E8 F0 81 30 46 BD E8 F0 81 00 2A E8 D0 20 46 11 46 ?? ?? ?? ?? B0 42 E2 D0 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_438_0_0 {
	meta:
		name = "add_padding"
		size = 46
		refs = "0026 memset"
	strings:
		$1 = { 01 2A 03 46 70 B4 04 BF 00 22 42 54 0D D0 00 2A 0B DD 02 3A 44 18 01 26 A0 1C D5 B2 5E 54 2A 46 65 70 00 21 70 BC ?? ?? ?? ?? 70 BC 70 47 }
	condition:
		$1
}

rule file_438_1_0 {
	meta:
		name = "inet6_opt_init"
		size = 36
	strings:
		$1 = { 03 46 50 B1 4A 1E B2 F5 00 6F 08 D2 4A 07 06 D1 C9 08 02 20 01 39 59 70 70 47 02 20 70 47 4F F0 FF 30 70 47 }
	condition:
		$1
}

rule file_438_2_0 {
	meta:
		name = "inet6_opt_append"
		size = 136
		refs = "003c __aeabi_idivmod"
	strings:
		$1 = { 01 2A 2D E9 F8 4F 16 46 07 46 8B 46 99 46 0A 9D 9D F8 2C 40 2F D9 01 2B 2D D9 FF 2D 2B D8 04 F1 FF 38 5F FA 88 F3 07 2B 25 D8 18 EA 04 0F 22 D1 A5 42 20 D3 02 F1 02 0A 21 46 50 46 ?? ?? ?? ?? 61 1A 01 EA 08 08 D7 B1 C2 44 AA 44 DA 45 12 D8 38 46 31 46 42 46 B0 44 FF F7 A8 FF 07 EB 08 03 07 F8 08 90 9A 1C 5D 70 46 46 0C 9B 02 35 A8 19 1A 60 BD E8 F8 8F 4F F0 FF 30 BD E8 F8 8F 46 44 02 35 A8 19 BD E8 F8 8F }
	condition:
		$1
}

rule file_438_3_0 {
	meta:
		name = "inet6_opt_finish"
		size = 44
	strings:
		$1 = { 01 2A 10 B5 0F D9 53 42 03 F0 07 03 40 B1 D4 18 8C 42 08 D8 11 46 1A 46 FF F7 84 FF 20 46 10 BD D4 18 20 46 10 BD 4F F0 FF 34 F7 E7 }
	condition:
		$1
}

rule file_438_4_0 {
	meta:
		name = "inet6_opt_set_val"
		size = 20
		refs = "000c memcpy"
	strings:
		$1 = { 38 B5 08 44 0C 46 1D 46 11 46 1A 46 ?? ?? ?? ?? 60 19 38 BD }
	condition:
		$1
}

rule file_438_5_0 {
	meta:
		name = "inet6_opt_next"
		size = 84
	strings:
		$1 = { 30 B4 AA B9 02 22 8A 42 00 EB 02 05 06 D2 84 5C 44 B9 01 32 8A 42 00 EB 02 05 F8 D3 4F F0 FF 30 30 BC 70 47 01 2C 06 D1 6C 78 02 34 22 44 EA E7 01 2A E8 D1 F2 E7 68 78 02 30 10 44 81 42 ED D3 1C 70 02 35 15 F8 01 3C 02 9A 13 60 03 9B 1D 60 30 BC 70 47 }
	condition:
		$1
}

rule file_438_6_0 {
	meta:
		name = "inet6_opt_find"
		size = 96
	strings:
		$1 = { 30 B4 F2 B9 02 22 8A 42 00 EB 02 05 15 D2 84 5C 54 B9 01 32 00 2B F6 D1 02 99 0B 60 83 18 10 46 03 9A 30 BC 13 60 70 47 9C 42 0D D0 6C 78 02 34 22 44 8A 42 00 EB 02 05 E9 D3 4F F0 FF 30 30 BC 70 47 01 2A DF D1 F8 E7 6B 78 98 1C 10 44 81 42 F3 D3 02 9C 02 35 03 99 23 60 0D 60 30 BC 70 47 }
	condition:
		$1
}

rule file_438_7_0 {
	meta:
		name = "inet6_opt_get_val"
		size = 20
		refs = "000c memcpy"
	strings:
		$1 = { 38 B5 0C 46 1D 46 41 18 10 46 1A 46 ?? ?? ?? ?? 60 19 38 BD }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "__nss_gshadow_lookup2"
		size = 88
		refs = "0004 __nss_gshadow_database 002a .LC0 002e .LC1 0032 .LC2 0044 __nss_database_lookup 0026 __nss_lookup"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? ?? ?2 0? 0? 05 46 88 46 17 46 20 68 1E 46 40 B1 28 60 41 46 28 46 3A 46 33 46 BD E8 F0 41 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 23 46 ?? ?? ?? ?? 00 28 01 DB 20 68 E3 E7 4F F0 FF 30 BD E8 F0 81 }
	condition:
		$1
}

rule file_482_0_0 {
	meta:
		name = "__nss_shadow_lookup2"
		size = 88
		refs = "0004 __nss_shadow_database 002a .LC0 002e .LC1 0032 .LC2 0044 __nss_database_lookup 0026 __nss_lookup"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? ?? ?2 0? 0? 05 46 88 46 17 46 20 68 1E 46 40 B1 28 60 41 46 28 46 3A 46 33 46 BD E8 F0 41 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 23 46 ?? ?? ?? ?? 00 28 01 DB 20 68 E3 E7 4F F0 FF 30 BD E8 F0 81 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "_nl_find_locale"
		size = 866
		refs = "0016 __libc_enable_secure 0028 _nl_C_name 0032 strcmp 003a _nl_POSIX_name 0052 _nl_load_locale_from_archive 0062 .LC0 006a getenv 0078 _nl_category_name_idxs 007c _nl_category_names 009a .LC1 00ac .LANCHOR0 00d4 strchr 00de _nl_default_locale_path 00ec _nl_expand_alias 00fa strlen 0110 memcpy 012c _nl_explode_name 0148 _nl_locale_file_list 018c _nl_make_l10nflist 01ee strip 0210 _nl_C_locobj 0242 __gconv_compare_alias 0258 .LC4 0268 __strcasecmp_l 02c4 _nl_load_locale 02cc free 02de strrchr 02fc __strndup 0344 .LC2 0348 .LC3 034c __PRETTY_FUNCTION__.11702 035e __assert_fail"
	strings:
		$1 = { 2D E9 F0 4F 91 B0 05 46 98 46 08 AF 18 68 0E 46 14 46 03 78 2B B3 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 00 2B 56 D1 D8 F8 00 90 ?? ?2 0? 0? ?? ?2 0? 0? 48 46 ?? ?? ?? ?? 00 28 38 D0 ?? ?2 0? 0? 48 46 ?? ?2 0? 0? ?? ?? ?? ?? 80 B3 00 2D 4C D1 20 46 41 46 ?? ?? ?? ?? 00 28 41 D0 24 37 BD 46 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C8 F8 00 00 08 B1 03 78 33 BB ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 10 5D 18 44 ?? ?? ?? ?? C8 F8 00 00 08 B1 03 78 AB B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C8 F8 00 00 70 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? C8 F8 00 20 53 F8 24 00 C9 E7 D8 F8 00 00 03 78 00 2B ED D0 A1 E7 2F 21 ?? ?? ?? ?? 00 28 E7 D1 A2 E7 ?? ?2 0? 0? 10 26 ?? ?2 0? 0? D8 F8 00 00 ?? ?? ?? ?? 81 46 00 28 00 F0 ED 80 48 46 ?? ?? ?? ?? 49 46 00 F1 0F 03 42 1C 23 F0 07 03 AD EB 03 0D 08 A8 ?? ?? ?? ?? 07 F1 18 02 07 F1 1C 03 07 F1 0C 01 8D E8 0C 00 07 F1 10 02 07 F1 14 03 ?? ?? ?? ?? B0 F1 FF 3F 80 46 00 F0 C1 80 BB 69 ?? ?2 0? 0? ?? ?2 0? 0? F9 68 7A 69 ?? ?2 0? 0? 02 93 ?? ?2 0? 0? FB 69 ?? ?2 0? 0? 10 F8 04 A0 4F EA 84 09 ?? ?2 0? 0? CB 44 03 93 0A EB 0E 0C 3B 69 4F F0 00 0E 00 91 58 46 01 92 29 46 CD F8 14 C0 32 46 04 93 43 46 CD F8 18 E0 C7 F8 04 C0 ?? ?? ?? ?? D7 F8 04 C0 82 46 00 28 78 D0 18 F0 01 0F 40 F0 94 80 DA F8 04 20 00 2A 00 F0 8A 80 DA F8 08 50 00 2D 00 F0 A7 80 BA 69 00 2A 46 D0 ?? ?2 0? 0? DA F8 08 10 ?? ?2 0? 0? 4A 44 52 6B 01 EB 82 01 4C 6A 00 2C 00 F0 B6 80 20 46 ?? ?? ?? ?? 21 46 11 30 20 F0 07 02 AD EB 02 0D 08 AE 30 46 ?? ?? ?? ?? BC 69 20 46 ?? ?? ?? ?? 21 46 11 30 20 F0 07 02 AD EB 02 0D 0D F1 20 08 40 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 42 46 CD 6B 12 F8 01 4B 15 F8 24 40 02 F8 01 4C 00 2C F7 D1 32 46 12 F8 01 4B 15 F8 24 40 02 F8 01 4C 00 2C F7 D1 40 46 31 46 ?? ?? ?? ?? 00 28 38 D1 DA F8 08 40 22 68 00 2A 41 D0 38 69 B0 B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? DA F8 08 40 08 B9 01 23 E3 61 A3 69 DA 1C 9D BF 01 33 20 46 A3 61 20 46 E9 E6 DA F8 08 40 F4 E7 32 46 FE 68 29 46 58 46 01 25 43 46 00 96 7E 69 CD F8 14 C0 06 95 01 96 BE 69 02 96 FE 69 03 96 3E 69 04 96 ?? ?? ?? ?? 82 46 00 28 7F F4 6F AF 00 20 CC E6 50 46 21 46 ?? ?? ?? ?? 70 E7 F8 69 ?? ?? ?? ?? 67 E7 D8 F8 00 90 0F E7 2F 21 DA F8 00 00 ?? ?? ?? ?? 01 46 42 1E 10 F8 02 0C 2F 28 04 D0 01 3A 12 F8 01 0C 2F 28 FA D1 10 46 89 1A ?? ?? ?? ?? 20 60 A7 E7 DA F8 10 00 78 B1 56 46 06 E0 32 69 92 68 5A B9 04 36 30 69 01 35 38 B1 42 68 00 2A F5 D1 21 46 ?? ?? ?? ?? F1 E7 05 46 0A EB 85 05 2A 69 CA F8 10 20 D5 F8 10 A0 BA F1 00 0F 7F F4 3A AF BB E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? E4 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_442_1_0 {
	meta:
		name = "_nl_remove_locale"
		size = 54
		refs = "000e _nl_locale_file_list 0030 _nl_unload_locale"
	strings:
		$1 = { 8B 69 01 3B 8B 61 AB B9 CB 68 02 2B 0F D0 ?? ?2 0? 0? ?? ?2 0? 0? 53 F8 20 30 9A 68 8A 42 03 D0 DB 68 9A 68 8A 42 FB D1 00 22 5A 60 9A 60 08 46 ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_442_2_0 {
	meta:
		name = "strip"
		size = 104
		refs = "0000 _nl_C_locobj"
	strings:
		$1 = { ?? ?2 0? 0? 01 39 ?? ?2 0? 0? F0 B4 00 27 5D 6B DE 6B 11 F8 01 3F BB B1 1A B2 35 F8 12 40 24 07 07 D4 5F 2B A3 F1 2C 04 03 D0 02 2C 01 D9 3A 2B 05 D1 56 F8 22 30 01 30 00 F8 01 3C E9 E7 2F 2B E7 D1 01 37 03 2F 02 D1 3A 1A 2F 21 02 E0 03 70 01 30 DE E7 83 18 01 2B 02 DC 00 F8 01 1B F9 E7 00 23 03 70 F0 BC 70 47 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "__xstat64_conv"
		size = 148
		refs = "0090 __libc_errno"
	strings:
		$1 = { 03 28 2D E9 F0 0F 38 D1 48 68 00 27 0E 88 00 23 B1 F8 08 B0 00 25 0C 8A 9C 46 B1 F8 0A A0 B1 F8 0C 90 B1 F8 0E 80 D0 60 48 69 C2 E9 00 67 8E 69 10 63 D0 68 96 63 4E 6A CF 69 10 66 08 6A D6 64 8E 6A C2 F8 10 B0 C2 F8 14 A0 16 65 CE 6A C2 F8 18 90 90 64 93 60 53 66 93 62 56 65 C2 F8 1C 80 C2 E9 08 45 17 64 53 63 08 6B 53 64 4B 6B 90 65 D3 65 60 46 BD E8 F0 0F 70 47 05 4B 1D EE 70 2F 16 21 4F F0 FF 3C 7B 44 1B 68 D1 50 F1 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_443_1_0 {
	meta:
		name = "__xstat32_conv"
		size = 248
		refs = "00e8 __libc_errno"
	strings:
		$1 = { 03 28 0B 46 2D E9 F0 03 64 D1 D1 E9 00 45 00 27 D1 E9 18 01 4F F0 00 0C A2 F8 08 C0 06 46 C2 E9 00 45 B9 42 08 BF B0 42 D0 60 35 D1 03 F1 10 04 D9 69 D3 E9 08 89 D0 CC D1 61 D3 E9 0C 01 C2 E9 08 89 14 61 04 46 C5 17 56 61 A9 42 08 BF A0 42 97 61 A2 F8 28 C0 D0 62 28 D1 D3 E9 10 01 9E 6B 04 46 C5 17 50 63 A9 42 08 BF A0 42 16 63 27 D1 9F 6C 60 46 DE 6C 1D 6D 5C 6D 99 6D DB 6D 97 63 D6 63 15 64 54 64 91 64 D3 64 C2 F8 50 C0 C2 F8 54 C0 BD E8 F0 03 70 47 13 4B 1D EE 70 2F 4B 21 4F F0 FF 30 7B 44 1B 68 D1 50 F2 E7 0F 4B 1D EE 70 2F 4B 21 4F F0 FF 30 7B 44 1B 68 D1 50 E8 E7 0B 4B 1D EE 70 2F 4B 21 4F F0 FF 30 7B 44 1B 68 D1 50 DE E7 07 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 D4 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "do_dlopen"
		size = 58
		refs = "0000 __libc_argc 0004 __libc_argv 0008 __environ 0030 _dl_open"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? F0 B5 85 B0 0F 68 04 46 1E 68 6F F0 01 03 15 68 07 C8 00 97 01 96 02 95 ?? ?? ?? ?? E0 60 05 B0 F0 BD }
	condition:
		$1
}

rule file_444_1_0 {
	meta:
		name = "dlerror_run"
		size = 60
		refs = "0014 _dl_catch_error 0032 free"
	strings:
		$1 = { 10 B5 86 B0 03 46 0D F1 0F 02 00 91 04 A8 05 A9 00 24 05 94 ?? ?? ?? ?? 04 46 28 B9 05 9B 13 B9 20 46 06 B0 10 BD 01 24 9D F8 0F 30 00 2B F7 D0 05 98 ?? ?? ?? ?? 20 46 06 B0 10 BD }
	condition:
		$1
}

rule file_444_2_0 {
	meta:
		name = "do_dlsym"
		size = 42
		refs = "0020 _dl_lookup_symbol_x"
	strings:
		$1 = { 70 B5 84 B0 00 25 04 46 00 95 00 F1 0C 02 01 68 02 26 40 68 01 F5 E8 73 E5 60 01 95 03 95 02 96 ?? ?? ?? ?? A0 60 04 B0 70 BD }
	condition:
		$1
}

rule file_444_4_0 {
	meta:
		name = "do_dlsym_private"
		size = 78
		refs = "0018 .LC0 0044 _dl_lookup_symbol_x"
	strings:
		$1 = { 03 68 00 F1 0C 02 F0 B5 04 46 89 B0 00 25 40 68 0D F1 10 0E E5 60 19 46 ?? ?2 0? 0? D3 F8 CC 31 4C F6 85 77 CD F8 00 E0 01 95 4F F0 01 0E 02 95 ?? ?2 0? 0? 03 95 C0 F6 63 17 04 96 05 97 07 95 CD F8 18 E0 ?? ?? ?? ?? A0 60 09 B0 F0 BD }
	condition:
		$1
}

rule file_444_5_0 {
	meta:
		name = "__libc_dlsym"
		size = 50
		refs = "0006 do_dlsym"
	strings:
		$1 = { 00 B5 85 B0 00 90 ?? ?2 0? 0? 01 91 ?? ?2 0? 0? 69 46 FF F7 D7 FF 40 B9 02 98 00 B1 00 68 03 9B 5B 68 18 44 05 B0 5D F8 04 FB 00 20 05 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_444_7_0 {
	meta:
		name = "__libc_dlsym_private"
		size = 50
		refs = "0006 do_dlsym_private"
	strings:
		$1 = { 00 B5 85 B0 00 90 ?? ?2 0? 0? 01 91 ?? ?2 0? 0? 69 46 FF F7 77 FF 40 B9 02 98 00 B1 00 68 03 9B 5B 68 18 44 05 B0 5D F8 04 FB 00 20 05 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_444_8_0 {
	meta:
		name = "__libc_dlopen_mode"
		size = 76
		refs = "0006 do_dlopen 001c .LC1 0026 __libc_dlsym_private 002c .LANCHOR0 0038 __libc_register_dlfcn_hook"
	strings:
		$1 = { 00 B5 85 B0 00 90 ?? ?2 0? 0? 01 91 ?? ?2 0? 0? 69 46 CD F8 08 E0 FF F7 5B FF 98 B9 ?? ?2 0? 0? 03 98 ?? ?2 0? 0? ?? ?? ?? ?? 20 B1 ?? ?2 0? 0? ?? ?2 0? 0? 03 60 03 98 ?? ?? ?? ?? 03 98 05 B0 5D F8 04 FB 00 20 05 B0 5D F8 04 FB }
	condition:
		$1
}

rule file_444_9_0 {
	meta:
		name = "__libc_register_dl_open_hook"
		size = 28
		refs = "0000 .LC1 000a __libc_dlsym_private 0010 .LANCHOR0"
	strings:
		$1 = { ?? ?2 0? 0? 08 B5 ?? ?2 0? 0? ?? ?? ?? ?? 20 B1 ?? ?2 0? 0? ?? ?2 0? 0? 03 60 08 BD }
	condition:
		$1
}

rule file_987_5_0 {
	meta:
		name = "__libc_register_dlfcn_hook"
		size = 28
		refs = "0000 .LC5 000a __libc_dlsym_private 0010 .LANCHOR1"
	strings:
		$1 = { ?? ?2 0? 0? 08 B5 ?? ?2 0? 0? ?? ?? ?? ?? 20 B1 ?? ?2 0? 0? ?? ?2 0? 0? 03 60 08 BD }
	condition:
		$1
}

rule file_444_10_0 {
	meta:
		name = "free_slotinfo"
		size = 64
		refs = "002e free"
	strings:
		$1 = { 70 B5 06 46 00 68 01 25 A8 B1 04 30 FF F7 F8 FF 05 46 80 B1 30 68 04 68 4C B1 C3 68 6B B9 02 46 01 E0 D1 68 49 B9 01 33 08 32 A3 42 F9 D1 ?? ?? ?? ?? 00 23 33 60 28 46 70 BD 00 25 28 46 70 BD }
	condition:
		$1
}

rule file_444_11_0 {
	meta:
		name = "free_mem"
		size = 210
		refs = "0002 _dl_all_dirs 0006 _dl_init_all_dirs 001e free 002a _dl_nns 0036 _dl_ns 0080 _dl_tls_dtv_slotinfo_list 0090 _dl_scope_free_list 00b0 _dl_initial_searchlist"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 2A 68 93 42 07 D0 18 46 1C 68 ?? ?? ?? ?? 2A 68 23 46 A2 42 F7 D1 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 23 B3 ?? ?2 0? 0? 00 26 ?? ?2 0? 0? 3D 68 BD B1 EB 69 58 68 5E 60 60 B1 83 68 44 68 2B B1 44 B1 20 46 83 68 44 68 00 2B F9 D1 ?? ?? ?? ?? 00 2C F6 D1 95 F8 96 31 DB 07 1B D4 ED 68 00 2D E7 D1 FA 68 ?? ?2 0? 0? ?? ?2 0? 0? BA B9 ?? ?2 0? 0? ?? ?2 0? 0? 18 68 04 30 FF F7 98 FF ?? ?2 0? 0? ?? ?2 0? 0? 00 22 18 68 1A 60 BD E8 F8 40 ?? ?? ?? ?? D5 F8 F0 01 ?? ?? ?? ?? DE E7 ?? ?2 0? 0? 99 68 ?? ?2 0? 0? 4C 68 50 68 84 42 DE D1 14 68 00 22 08 68 0C 60 DA 60 ?? ?? ?? ?? D6 E7 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "__strncat_chk"
		size = 192
		refs = "00b4 __chk_fail"
	strings:
		$1 = { F8 B5 00 EB 03 0C 06 46 01 E0 3B 46 2E 46 66 45 03 F1 FF 37 4E D0 35 46 15 F8 01 4B 00 2C F4 D1 03 2A 06 F1 FF 36 88 BF 95 08 3A D8 00 2A 43 D0 5D 1E 00 2B 3E D0 0C 78 06 F1 01 0C 74 70 A4 B1 0F 46 9A 1A 61 46 33 44 08 E0 99 42 05 F1 FF 35 30 D0 17 F8 01 4F 01 F8 01 4F 34 B1 95 42 0E 46 F3 D1 14 B1 35 B3 00 23 73 70 F8 BD 01 2B 21 D0 4C 78 B4 70 00 2C F8 D0 02 2B 1B D0 8C 78 F4 70 00 2C F2 D0 03 2B A3 F1 04 07 13 D0 04 31 11 F8 01 4C 06 F8 04 4F 00 2C E7 D0 01 3D 06 D0 4F B1 3B 46 0C 78 74 70 00 2C E0 D1 F8 BD 02 F0 03 02 3B 46 BB E7 ?? ?? ?? ?? 1D 46 00 2C D2 D1 D4 E7 }
	condition:
		$1
}

rule file_447_0_0 {
	meta:
		name = "_nl_postload_ctype"
		size = 100
		refs = "0000 _nl_global_locale 0054 __libc_tsd_LOCALE 0058 __libc_tsd_CTYPE_B 005c __libc_tsd_CTYPE_TOUPPER 0060 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { ?? ?2 0? 0? 13 4A ?? ?2 0? 0? 1D EE 70 0F 70 B4 19 68 4D 6A 05 F5 80 75 5D 63 0C 6B 04 F5 00 74 9C 63 89 6A 01 F5 00 71 D9 63 7A 44 12 68 82 58 9A 42 01 D0 70 BC 70 47 07 4E 08 4A 7E 44 36 68 07 4B 85 51 7A 44 12 68 81 50 7B 44 1B 68 C4 50 70 BC 70 47 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "_nss_files_parse_pwent"
		size = 384
		refs = "000a strchr 0098 strtoul"
	strings:
		$1 = { 70 B5 0D 46 82 B0 0A 21 04 46 ?? ?? ?? ?? 08 B1 00 23 03 70 2C 60 23 78 00 2B 18 BF 3A 2B 07 D0 62 1C 14 46 12 F8 01 3B 3A 2B 18 BF 00 2B F8 D1 13 B1 00 23 04 F8 01 3B 23 78 33 B9 2A 68 12 78 2B 2A 18 BF 2D 2A 00 F0 92 80 6C 60 23 78 3A 2B 18 BF 00 2B 07 D0 62 1C 14 46 12 F8 01 3B 3A 2B 18 BF 00 2B F8 D1 53 B9 2B 68 1B 78 2B 2B 18 BF 2D 2B 0D D1 23 78 3B BB 00 20 02 B0 70 BD 00 23 04 F8 01 3B 2B 68 1B 78 2B 2B 18 BF 2D 2B F1 D0 01 AE 20 46 31 46 0A 22 ?? ?? ?? ?? 01 9B A3 42 A8 60 E9 D0 1A 78 3A 2A 08 BF 5C 1C 02 D0 00 2A E2 D1 1C 46 31 46 20 46 0A 22 ?? ?? ?? ?? 01 99 A1 42 E8 60 24 D1 D7 E7 01 AE 0A 22 20 46 31 46 ?? ?? ?? ?? 01 9B A3 42 08 BF 00 22 A8 60 08 BF AA 60 1A 78 3A 2A 08 BF 5C 1C 02 D0 00 2A C3 D1 1C 46 23 78 00 2B BF D0 31 46 20 46 0A 22 ?? ?? ?? ?? 01 99 A1 42 08 BF 00 23 E8 60 08 BF EB 60 0B 78 3A 2B 08 BF 01 31 01 D0 00 2B AC D1 29 61 0B 78 00 2B 18 BF 3A 2B 07 D0 4A 1C 11 46 12 F8 01 3B 3A 2B 18 BF 00 2B F8 D1 13 B1 00 23 01 F8 01 3B 69 61 0B 78 00 2B 18 BF 3A 2B 07 D0 4A 1C 11 46 12 F8 01 3B 3A 2B 18 BF 00 2B F8 D1 13 B1 00 23 01 F8 01 3B 01 20 A9 61 02 B0 70 BD 01 20 6B 60 AB 60 EB 60 2B 61 6B 61 AB 61 02 B0 70 BD }
	condition:
		$1
}

rule file_448_1_0 {
	meta:
		name = "__fgetpwent_r"
		size = 500
		refs = "006e fgets_unlocked 00ba _nss_files_parse_pwent 0108 __libc_do_syscall 01c8 __lll_lock_wait_private 01e4 __libc_errno 01f0 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 4F 98 46 03 68 83 B0 05 46 8B 46 1C 04 17 46 48 BF 1D EE 70 6F 1D D4 80 6C 1D EE 70 6F A6 F5 98 64 83 68 A3 42 12 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 F0 BF 80 AB 6C 18 46 9C 60 43 68 01 33 43 60 08 F1 FF 34 DF F8 94 A1 3C 44 4F F0 FF 09 84 F8 00 90 38 46 41 46 2A 46 ?? ?? ?? ?? 00 28 4F D0 23 78 FF 2B 75 D1 52 46 03 78 7A 44 12 68 B1 58 31 F8 13 20 92 04 48 BF 00 F1 01 0E 06 D5 70 46 1E F8 01 3B 31 F8 13 20 92 04 F8 D4 00 2B 18 BF 23 2B DC D0 4E 4B 59 46 3A 46 7B 44 1B 68 33 44 00 93 43 46 ?? ?? ?? ?? 00 28 D0 D0 2B 68 1B 04 21 D4 A8 6C 43 68 01 3B 43 60 E3 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 09 DD A6 F5 98 66 01 22 00 23 4F F0 F0 0C B1 68 11 43 ?? ?? ?? ?? 0C 9C 00 20 C4 F8 00 B0 25 E0 2B 68 D8 06 27 D4 19 04 17 D4 A8 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 3E DC 0C 9C 00 22 24 4B 22 60 22 22 7B 44 1B 68 10 46 F2 50 03 B0 BD E8 F0 8F 2B 68 D7 E7 19 04 21 D4 A8 6C 43 68 01 3B 43 60 E3 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 09 DD A6 F5 98 61 01 22 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 0C 9C 00 22 0C 4B 22 60 7B 44 1B 68 02 22 10 46 F2 50 CC E7 ?? ?? ?? ?? 3D E7 A6 F5 98 61 01 22 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? B5 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_451_0_0 {
	meta:
		name = "__wcsncat_chk"
		size = 174
		refs = "00a2 __chk_fail"
	strings:
		$1 = { F8 B5 06 46 00 2B 4C D0 35 46 5F 1E 55 F8 04 4B 14 B1 3B 46 2E 46 F5 E7 03 2A A6 F1 04 06 88 BF 95 08 35 D8 00 2A 3E D0 5D 1E 00 2B 39 D0 0C 68 37 1D 74 60 84 B1 9B 1A 07 E0 00 2D 31 D0 51 F8 04 4F 01 3D 47 F8 04 4F 34 B1 9D 42 3E 46 F4 D1 14 B1 35 B3 00 23 73 60 F8 BD 01 2B 21 D0 4C 68 B4 60 00 2C F8 D0 02 2B 1B D0 8C 68 F4 60 00 2C F2 D0 03 2B A3 F1 04 07 13 D0 10 31 51 F8 04 4C 46 F8 10 4F 00 2C E7 D0 01 3D 06 D0 4F B1 3B 46 0C 68 74 60 00 2C E0 D1 F8 BD 02 F0 03 02 3B 46 C0 E7 ?? ?? ?? ?? 1D 46 00 2C D2 D1 D4 E7 }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "__wcsnrtombs"
		size = 468
		refs = "0006 .LANCHOR0 0040 __wcsnlen 006e _dl_mcount_wrapper_check 0152 _nl_C_LC_CTYPE 0160 __wcsmbs_load_conv 0168 .LC3 016c .LC1 0170 __PRETTY_FUNCTION__.11594 0182 __assert_fail 0186 __wcsmbs_gconv_fcts_c 0190 .LC2 01ae .LC0 01cc _nl_current_LC_CTYPE 01d0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F D5 B0 ?? ?2 0? 0? 06 46 5E 9F ?? ?2 0? 0? 0D 46 99 46 01 21 00 23 00 2F 08 BF 27 46 0E 93 10 97 10 46 13 93 0F 91 0D 91 12 B9 55 B0 BD E8 F0 8F 2C 68 51 1E 1D EE 70 2F 05 92 20 46 ?? ?? ?? ?? 61 4B 05 99 7B 44 1B 68 CB 58 1F 68 7B 69 01 30 04 EB 80 08 00 2B 7A D0 9F 68 7C 69 00 2E 47 D0 20 46 06 EB 09 03 0B 96 0C 93 ?? ?? ?? ?? 00 22 38 46 43 46 0D F1 50 0E 00 92 01 27 02 92 0B A9 2A 46 CD F8 04 E0 03 97 A0 47 0B 9B C6 EB 03 0B 30 F0 04 02 0C D1 13 F8 01 2C 4A B9 9E 42 00 F0 84 80 10 9B 1B 68 00 2B 70 D1 0B F1 FF 3B 2B 60 03 1C 18 BF 01 23 04 28 18 BF 00 28 08 D0 83 1F 01 2B 07 D9 05 28 4D D1 58 46 55 B0 BD E8 F0 8F 00 2B F9 D0 04 38 01 28 F6 D9 3C 4B 54 22 05 99 4F F0 FF 30 7B 44 1B 68 CA 50 55 B0 BD E8 F0 8F 10 99 09 AB D5 F8 00 E0 B3 46 14 AD 0D F1 20 0A 03 C9 4F F0 01 09 54 AA CD F8 1C E0 0C 92 83 E8 03 00 10 93 20 46 0B 95 ?? ?? ?? ?? 07 AA 43 46 8D E8 40 04 38 46 02 96 0B A9 CD F8 0C 90 A0 47 0B 9B 5A 1B 93 44 05 28 EC D0 30 F0 04 01 B7 D1 13 F8 01 3C 00 2B B3 D1 0B F1 FF 3B B0 E7 ?? ?2 0? 0? ?? ?2 0? 0? 9F 42 13 D0 38 46 ?? ?? ?? ?? 7B 69 79 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8E 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 65 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 83 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 82 22 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_0_0 {
	meta:
		name = "wcstok"
		size = 92
		refs = "000e wcsspn 0020 wcspbrk 0058 __libc_errno"
	strings:
		$1 = { 70 B5 04 46 0D 46 16 46 A0 B1 20 46 29 46 ?? ?? ?? ?? 54 F8 20 30 04 EB 80 04 D3 B1 29 46 20 46 ?? ?? ?? ?? 90 B1 03 46 00 22 20 46 43 F8 04 2B 33 60 70 BD 14 68 00 2C E7 D1 07 4B 1D EE 70 2F 16 21 20 46 7B 44 1B 68 D1 50 70 BD 30 60 20 46 70 BD 33 60 18 46 70 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "__dl_iterate_phdr"
		size = 188
		refs = "0000 __pthread_mutex_lock 0014 _dl_load_write_lock 0020 _dl_ns 0030 _dl_load_adds 0094 _dl_tls_get_addr_soft 009e __pthread_mutex_unlock"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 4D 06 46 8C B0 8A 46 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 17 68 53 68 00 2F 35 D0 ?? ?2 0? 0? 18 46 00 21 ?? ?2 0? 0? CD E9 00 01 4F F0 00 0B 07 E0 02 A8 28 21 52 46 B0 47 04 46 28 BB FF 68 17 B3 7B 69 D8 E9 00 01 DD E9 00 45 1A 68 B3 F8 58 C1 04 1B 61 EB 05 05 02 92 5A 68 CD F8 2C B0 AD F8 14 C0 03 92 D3 F8 50 21 CD E9 06 01 CD E9 08 45 04 92 D3 F8 40 22 0A 92 00 2A D9 D0 18 46 ?? ?? ?? ?? 0B 90 D4 E7 00 24 ?? ?2 0? 0? ?? ?2 0? 0? 2B B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 20 46 0C B0 BD E8 F0 8D }
	condition:
		$1
}

rule file_454_1_0 {
	meta:
		name = "dl_iterate_phdr"
		size = 112
		refs = "0000 _dl_phnum 0016 _dl_phdr 001a _dl_load_adds 0026 _dl_ns 002a .LC0 0066 __dl_iterate_phdr"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 41 80 46 1E 68 8A B0 0F 46 2E B3 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 ?? ?2 0? 0? D1 E9 00 45 68 46 28 21 ?? ?2 0? 0? 02 93 53 68 3A 46 CD E9 04 45 AD F8 0C 60 E4 1A 65 F1 00 05 00 23 CD E9 06 45 8D E8 08 40 C0 47 18 B9 40 46 39 46 ?? ?? ?? ?? 0A B0 BD E8 F0 81 }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "memchr"
		size = 156
	strings:
		$1 = { 01 F0 FF 01 10 2A 2A DB 10 F0 07 0F 07 D0 10 F8 01 3B 01 3A 8B 42 2C D0 10 F0 07 0F F7 D1 F0 B4 41 EA 01 21 41 EA 01 41 22 F0 07 06 7F F0 00 07 00 23 F0 E8 02 45 08 3E 84 EA 01 04 85 EA 01 05 84 FA 47 F4 A3 FA 87 F4 85 FA 47 F5 A4 FA 87 F5 8D B9 EE D1 F0 BC 01 F0 FF 01 02 F0 07 02 32 B1 10 F8 01 3B 01 3A 83 EA 01 03 13 B1 F8 D1 00 20 70 47 01 38 70 47 00 2C 06 BF 2C 46 03 38 07 38 14 F0 01 0F 07 D1 01 30 14 F4 80 7F 02 BF 01 30 14 F4 C0 3F 01 30 F0 BC 01 38 70 47 }
	condition:
		$1
}

rule file_457_0_0 {
	meta:
		name = "__pread64_chk"
		size = 28
		refs = "0018 __chk_fail 0014 __libc_pread64"
	strings:
		$1 = { 38 B5 06 9B DD E9 04 45 9A 42 05 D8 CD E9 04 45 BD E8 38 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "__mpn_divmod_1"
		size = 1354
		refs = "004a __aeabi_uidivmod 0058 __aeabi_uidiv"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 15 46 0E 46 04 90 98 46 10 46 00 2A 00 F0 BA 80 58 23 03 FB 02 F3 64 2B 40 F3 B7 80 B8 FA 88 FA BA F1 00 0F 00 F0 78 81 08 FA 0A F8 5F EA 48 01 08 BF 4F F0 FF 3B 35 D0 C8 F1 00 07 4F EA 18 44 38 46 21 46 ?? ?? ?? ?? 38 46 1F FA 88 F9 8B 46 21 46 ?? ?? ?? ?? 4F EA 0B 43 07 46 09 FB 00 F0 98 42 0A D9 13 EB 08 03 07 F1 FF 32 04 D2 98 42 84 BF 02 3F 43 44 00 D8 17 46 C0 EB 03 0B 21 46 58 46 ?? ?? ?? ?? 58 46 0B 46 21 46 01 93 ?? ?? ?? ?? 01 9B 19 04 09 FB 00 F9 89 45 00 F2 2D 82 40 EA 07 4B 05 F1 80 49 01 2D 09 F1 FF 39 CA F1 20 00 56 F8 29 40 4F EA 89 09 D8 BF 22 46 24 FA 00 F3 3D DD 04 9A 09 F1 04 09 AD 00 06 EB 09 01 C5 F1 04 05 91 44 02 95 4F F0 00 0C 03 91 0D E0 01 36 02 9D 43 45 AC F1 04 0C 24 BF 01 36 C8 EB 03 03 AC 45 14 46 49 F8 04 6D 21 D0 03 9A 04 FA 0A F4 A3 FB 0B 67 62 44 52 F8 08 2C DE 19 22 FA 00 F7 27 43 A6 FB 08 45 39 1B 63 EB 05 04 0B 46 00 2C DE D0 B1 EB 08 05 64 F1 00 04 2B 46 00 2C D6 D0 B5 EB 08 01 64 F1 00 04 02 36 0B 46 D0 E7 A3 FB 0B 01 02 FA 0A F2 19 44 A1 FB 08 45 10 1B 63 EB 05 03 6B B1 B0 EB 08 02 63 F1 00 03 10 46 00 2B 00 F0 C8 81 B2 EB 08 05 63 F1 00 03 02 31 28 46 40 45 04 9A 24 BF C8 EB 00 00 01 31 20 FA 0A F0 11 60 09 B0 BD E8 F0 8F B8 FA 88 F2 03 92 00 2A 00 F0 40 81 05 F1 80 4A C2 F1 20 03 0A F1 FF 3A 08 FA 02 F8 01 2D CD F8 08 80 51 F8 2A 20 4F EA 8A 0A 05 93 22 FA 03 F8 40 F3 BD 81 02 9B 0A F1 04 0A 04 99 56 44 4F F0 00 0B AD 00 8A 44 C5 F1 04 05 07 96 1C 0C 06 95 1F FA 83 F9 45 46 D8 46 D3 46 92 46 00 E0 BA 46 28 46 21 46 ?? ?? ?? ?? 07 9E 21 46 46 44 56 F8 08 7C 06 46 28 46 ?? ?? ?? ?? 03 9D 09 FB 06 FC 0A FA 05 F2 DD F8 14 A0 27 FA 0A F0 40 EA 02 0A 4F EA 1A 40 40 EA 01 41 8C 45 09 D9 02 9A 70 1E 89 18 04 D2 8C 45 84 BF 02 3E 89 18 00 D8 06 46 CC EB 01 0C 21 46 60 46 CD F8 04 C0 ?? ?? ?? ?? DD F8 04 C0 21 46 05 46 60 46 ?? ?? ?? ?? 1F FA 8A F2 09 FB 05 F0 42 EA 01 41 88 42 09 D9 02 9B 6A 1E C9 18 04 D2 88 42 84 BF 02 3D C9 18 00 D8 15 46 DD F8 18 A0 A8 F1 04 08 45 EA 06 46 0D 1A D0 45 4B F8 04 6D AA D1 A8 46 21 46 40 46 ?? ?? ?? ?? 21 46 05 46 40 46 ?? ?? ?? ?? 03 9A 09 FB 05 F0 97 40 3B 0C 43 EA 01 41 88 42 07 D9 DD F8 08 A0 6B 1E 11 EB 0A 01 C0 F0 32 81 1D 46 C0 EB 01 0A 21 46 50 46 BF B2 ?? ?? ?? ?? 21 46 06 46 50 46 ?? ?? ?? ?? 09 FB 06 F9 47 EA 01 41 89 45 0A D9 02 9A 73 1E 89 18 80 F0 FE 80 89 45 84 BF 02 3E 89 18 40 F2 F8 80 46 EA 05 46 04 9D C9 EB 01 00 03 9A 2E 60 D0 40 09 B0 BD E8 F0 8F 5F EA 48 03 08 BF 4F F0 FF 3C 34 D0 C8 F1 00 07 4F EA 18 44 38 46 21 46 ?? ?? ?? ?? 38 46 1F FA 88 F9 8A 46 21 46 ?? ?? ?? ?? 4F EA 0A 43 07 46 09 FB 00 F0 98 42 0A D9 13 EB 08 03 07 F1 FF 32 04 D2 98 42 84 BF 02 3F 43 44 00 D8 17 46 C0 EB 03 0A 21 46 50 46 ?? ?? ?? ?? 50 46 8B 46 21 46 ?? ?? ?? ?? 4F EA 0B 41 09 FB 00 F9 89 45 00 F2 C4 80 40 EA 07 4C 69 1E 56 F8 21 00 80 45 89 BF 00 23 00 20 DD F8 10 A0 4A F8 21 30 88 BF A9 1E 00 29 FF F6 EB AE 4F EA 81 09 04 9A 49 46 89 F0 03 09 0E 44 00 27 11 44 6F EA 09 09 0C E0 01 34 40 45 28 BF 01 34 CC 51 A7 F1 04 07 28 BF C8 EB 00 00 4F 45 3F F4 D2 AE A0 FB 0C 45 44 19 F5 59 A4 FB 08 23 B5 EB 02 0A 60 EB 03 02 50 46 00 2A E6 D0 BA EB 08 03 62 F1 00 02 18 46 00 2A DE D0 B3 EB 08 05 62 F1 00 02 02 34 28 46 D8 E7 6B 1E 51 F8 23 A0 D0 45 85 BF 03 9A 04 99 DD F8 0C A0 41 F8 23 20 88 BF AB 1E 00 2B 5A DB 4F EA 83 09 04 9A CB 46 4F EA 18 44 89 F0 03 09 1F FA 88 F7 00 25 5E 44 5A 44 6F EA 09 03 03 96 04 92 02 93 50 46 21 46 ?? ?? ?? ?? 21 46 06 46 50 46 ?? ?? ?? ?? DD F8 0C A0 07 FB 06 F0 5A F8 05 90 4F EA 19 42 42 EA 01 42 90 42 0A D9 12 EB 08 02 06 F1 FF 31 04 D2 90 42 84 BF 02 3E 42 44 00 D8 0E 46 C0 EB 02 0B 21 46 58 46 ?? ?? ?? ?? 21 46 82 46 58 46 ?? ?? ?? ?? 1F FA 89 F3 07 FB 0A F0 43 EA 01 41 88 42 0B D9 11 EB 08 01 0A F1 FF 32 05 D2 88 42 84 BF AA F1 02 0A 41 44 00 D8 92 46 04 9B 4A EA 06 42 C0 EB 01 0A 5A 51 04 3D 02 9A 95 42 B6 D1 50 46 09 B0 BD E8 F0 8F 1E 46 05 E7 01 31 3B E6 11 EB 08 01 00 F1 FF 33 04 D2 89 45 88 BF 02 38 3F F6 C9 AD 18 46 C6 E5 11 EB 08 01 00 F1 FF 33 04 D2 89 45 88 BF 02 38 3F F6 32 AF 18 46 2F E7 88 42 84 BF 02 3D 51 44 3F F6 C9 AE C6 E6 02 9D 17 46 2C 0C 1F FA 85 F9 A7 E6 }
	condition:
		$1
}

rule file_460_0_0 {
	meta:
		name = "nscd_getpw_r"
		size = 692
		refs = "0008 __nss_not_use_nscd_passwd 000e .LC0 0014 .LANCHOR0 0030 __nscd_get_map_ref 004a __nscd_cache_search 00b0 __libc_do_syscall 0150 __nscd_open_socket 01ce memcpy 0210 __nscd_unmap 0252 __readall 02a8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 97 B0 9A 46 ?? ?2 0? 0? 07 91 ?? ?2 0? 0? 08 92 ?? ?2 0? 0? 06 90 ?? ?2 0? 0? ?? ?2 0? 0? 0B 20 0C AB ?? ?2 0? 0? 00 27 0B 94 05 97 ?? ?? ?? ?? 83 46 BB F1 FF 3F 00 F0 84 80 24 21 08 98 00 91 5B 46 06 99 07 9A ?? ?? ?? ?? 06 46 00 28 78 D0 00 F1 18 07 DB F8 00 C0 0D AC 06 F1 18 09 0F CF 06 F1 3C 05 DC F8 08 80 76 68 0F C4 4E 44 0F CF 0F C4 0C 9A 3B 68 90 45 23 60 40 F0 CD 80 4F F0 FF 34 22 9F 00 23 0E 9A 3B 60 57 1C 00 F0 FA 80 01 2A 65 D0 83 4A 1D EE 70 1F 1D 46 7A 44 12 68 8B 50 66 1C 04 D0 20 46 4F F0 06 0C ?? ?? ?? ?? BB F1 FF 3F 1D D0 DB F8 00 C0 0C 9A DC F8 08 30 93 42 1A D1 0B F1 0C 02 DB F8 0C 30 BF F3 5F 8F 58 1E 52 E8 00 1F 99 42 04 D1 42 E8 00 0C BC F1 00 0F F6 D1 8B 42 BF F3 5F 8F ED D1 01 2B 00 F0 8C 80 28 46 17 B0 BD E8 F0 8F D8 07 0C 93 06 D4 05 9C 01 34 05 94 05 2C 01 D0 69 1C 91 D1 0B F1 0C 02 DB F8 0C 30 BF F3 5F 8F 58 1E 52 E8 00 1F 99 42 03 D1 42 E8 00 07 00 2F F7 D1 8B 42 BF F3 5F 8F EE D1 01 2B 00 F0 A1 80 6A 1C D9 D0 4F F0 FF 3B 06 A8 24 21 0D AB 00 91 07 C8 ?? ?? ?? ?? 43 1C 04 46 00 F0 8D 80 4F F0 FF 36 00 25 90 E7 13 9B DD F8 3C 80 1A 46 20 98 02 93 15 9B 40 44 14 9F DD F8 40 90 0A 93 3B 46 00 EB 09 01 09 97 0A 44 20 9F DD F8 28 C0 13 44 CA F8 10 10 9C 44 CA F8 00 70 C7 EB 0C 07 CA F8 14 20 39 46 12 9A 29 44 CA F8 18 30 11 9B 8E 42 03 97 CA F8 04 00 CA F8 08 30 CA F8 0C 20 71 D3 21 99 8F 42 66 D8 00 2D 41 D0 29 46 03 9A 20 98 ?? ?? ?? ?? DA F8 00 30 43 44 13 F8 01 3C 63 B9 DA F8 04 30 4B 44 13 F8 01 3C 33 B9 DA F8 10 30 02 9F 3B 44 13 F8 01 3C A3 B1 DB F8 00 20 0C 9B 92 68 9A 42 0C BF 4F F0 FF 35 6F F0 01 05 4B E7 58 46 ?? ?? ?? ?? 28 46 17 B0 BD E8 F0 8F 6F F0 01 05 4E E7 DA F8 14 30 09 9F 3B 44 13 F8 01 3C 00 2B E2 D1 DA F8 18 30 0A 9F 3B 44 13 F8 01 3C 00 2B DA D1 22 9F 00 25 C7 F8 00 A0 2C E7 20 46 20 99 03 9A ?? ?? ?? ?? 03 9B 83 42 04 BF 22 9F C7 F8 00 A0 3F F4 20 AF 11 4B 1D EE 70 2F 02 25 7B 44 1B 68 D5 50 17 E7 25 46 0B 9C 01 23 23 60 19 E7 58 46 ?? ?? ?? ?? 5A E7 0B 9F 01 23 15 46 3B 60 09 E7 07 4B 1D EE 70 2F 22 25 7B 44 1B 68 D5 50 01 E7 4F F0 FF 35 FE E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_460_1_0 {
	meta:
		name = "__nscd_getpwnam_r"
		size = 48
		refs = "000e strlen"
	strings:
		$1 = { F0 B5 0D 46 85 B0 16 46 1F 46 04 46 68 B1 ?? ?? ?? ?? 0A 9A 8D E8 C0 00 2B 46 02 92 00 22 41 1C 20 46 FF F7 93 FE 05 B0 F0 BD 4F F0 FF 30 FA E7 }
	condition:
		$1
}

rule file_460_2_0 {
	meta:
		name = "__nscd_getpwuid_r"
		size = 56
		refs = "001c _itoa_word"
	strings:
		$1 = { 2D E9 F0 41 88 B0 08 AC 00 25 88 46 17 46 04 F8 01 5D 1E 46 21 46 2B 46 0A 22 0E 9C ?? ?? ?? ?? 00 97 01 96 43 46 02 94 08 AC 01 22 21 1A FF F7 75 FE 08 B0 BD E8 F0 81 }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "__wcstombs_chk"
		size = 32
		refs = "0014 __wcsrtombs 001c __chk_fail"
	strings:
		$1 = { 10 B5 93 42 84 B0 01 91 08 D3 01 A9 02 AB 00 24 03 94 02 94 ?? ?? ?? ?? 04 B0 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1260_0_0 {
	meta:
		name = "__mbstowcs_chk"
		size = 32
		refs = "0014 __mbsrtowcs 001c __chk_fail"
	strings:
		$1 = { 10 B5 93 42 84 B0 01 91 08 D3 01 A9 02 AB 00 24 03 94 02 94 ?? ?? ?? ?? 04 B0 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_463_0_0 {
	meta:
		name = "fgetgrent"
		size = 388
		refs = "000a _IO_new_fgetpos 0014 .LANCHOR0 003c .LANCHOR1 006e __fgetgrent_r 0084 realloc 0094 _IO_new_fsetpos 0110 malloc 012a free 015c __libc_do_syscall 016a __lll_lock_wait_private 0174 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 05 A9 07 46 ?? ?? ?? ?? 00 28 40 F0 95 80 ?? ?2 0? 0? 01 22 ?? ?2 0? 0? BF F3 5F 8F 58 E8 00 3F 00 2B 03 D1 48 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 93 80 ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 00 2B 5E D0 ?? ?2 0? 0? ?? ?2 0? 0? 1D EE 70 1F ?? ?2 0? 0? ?? ?2 0? 0? 03 91 0D F1 10 0A 1C E0 D8 F8 04 30 CD F8 00 A0 ?? ?? ?? ?? 22 28 40 D1 71 68 D5 F8 00 B0 01 F5 80 61 71 60 58 46 ?? ?? ?? ?? 03 46 00 28 45 D0 38 46 05 A9 2B 60 ?? ?? ?? ?? 00 28 31 D1 D9 F8 00 30 ?? ?2 0? 0? 1A 46 38 46 31 49 ?? ?2 0? 0? 00 2B D9 D1 00 23 04 93 2F 4B 00 22 03 99 7B 44 1B 68 CC 58 D8 F8 00 30 BF F3 5F 8F 58 E8 00 1F 99 42 03 D1 48 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F EF D1 01 2B 2D DC 24 4B 03 9A 04 98 7B 44 1B 68 D4 50 09 B0 BD E8 F0 8F 2B 68 00 2B DB D1 D8 E7 00 22 22 60 13 46 CB E7 4F F4 80 60 C8 F8 04 00 ?? ?? ?? ?? 03 46 28 60 97 E7 18 4A 58 46 03 99 7A 44 12 68 51 F8 02 B0 02 93 ?? ?? ?? ?? 14 4A 03 98 7A 44 12 68 02 9B 40 F8 02 B0 A7 E7 00 20 D7 E7 03 99 01 22 ?? ?2 0? 0? 4F F0 F0 0C A1 F5 98 63 ?? ?2 0? 0? 99 68 00 23 11 43 ?? ?? ?? ?? C1 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 65 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "__isoc99_wscanf"
		size = 320
		refs = "0004 stdin 0068 _IO_vfwscanf 00c0 __lll_lock_wait_private 00da __libc_do_syscall 013c _Unwind_Resume"
	strings:
		$1 = { 0F B4 F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 2C 68 08 9E 23 68 19 04 51 D4 A0 6C 1D EE 70 7F A7 F5 98 67 83 68 BB 42 47 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 3C D1 A2 6C 2B 68 10 46 97 60 42 68 01 32 42 60 DA 6B 09 AF 28 68 31 46 42 F0 10 05 3A 46 DD 63 00 23 01 97 ?? ?? ?? ?? E2 6B 05 46 23 68 22 F0 14 02 E2 63 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 0C DC 28 46 03 B0 BD E8 F0 40 04 B0 70 47 23 46 C8 E7 23 46 C9 E7 ?? ?? ?? ?? BF E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E5 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1116_0_0 {
	meta:
		name = "__isoc99_scanf"
		size = 320
		refs = "0004 stdin 0068 _IO_vfscanf 00c0 __lll_lock_wait_private 00da __libc_do_syscall 013c _Unwind_Resume"
	strings:
		$1 = { 0F B4 F0 B5 ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 2C 68 08 9E 23 68 19 04 51 D4 A0 6C 1D EE 70 7F A7 F5 98 67 83 68 BB 42 47 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 3C D1 A2 6C 2B 68 10 46 97 60 42 68 01 32 42 60 DA 6B 09 AF 28 68 31 46 42 F0 10 05 3A 46 DD 63 00 23 01 97 ?? ?? ?? ?? E2 6B 05 46 23 68 22 F0 14 02 E2 63 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 0C DC 28 46 03 B0 BD E8 F0 40 04 B0 70 47 23 46 C8 E7 23 46 C9 E7 ?? ?? ?? ?? BF E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E5 E7 E3 6B 05 46 22 68 23 F0 14 03 E3 63 13 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "catopen"
		size = 232
		refs = "000c strchr 0018 malloc 002c __open_catalog 003c free 004e .LC2 0056 getenv 0062 __libc_enable_secure 006e .LC3 0082 .LC1 008c .LC0 00b2 setlocale 00ba strlen 00ce stpcpy 00e2 memcpy"
	strings:
		$1 = { 2D E9 F0 41 0C 46 00 AF 2F 21 80 46 ?? ?? ?? ?? 00 25 2E 46 C8 B1 1C 20 ?? ?? ?? ?? 04 46 4F F0 FF 30 3C B1 40 46 29 46 32 46 23 46 ?? ?? ?? ?? 18 B9 20 46 BD 46 BD E8 F0 81 20 46 ?? ?? ?? ?? 4F F0 FF 30 BD 46 BD E8 F0 81 01 2C 2F D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 06 46 B6 B1 33 78 A3 B1 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 9B B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 04 46 08 B1 03 78 DB B9 ?? ?2 0? 0? ?? ?2 0? 0? C4 E7 ?? ?2 0? 0? ?? ?2 0? 0? EB E7 30 46 2F 21 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 28 18 BF 1E 46 DF E7 01 46 05 20 ?? ?? ?? ?? 06 46 D0 E7 ?? ?? ?? ?? 21 46 88 30 20 F0 07 03 AD EB 03 0D 68 46 6D 46 ?? ?? ?? ?? ?? ?2 0? 0? 3A 23 ?? ?2 0? 0? 79 22 00 F8 01 3B ?? ?? ?? ?? 96 E7 }
	condition:
		$1
}

rule file_465_1_0 {
	meta:
		name = "catgets"
		size = 132
		refs = "0026 __aeabi_uidivmod 0080 __libc_errno"
	strings:
		$1 = { 2D E9 F8 4F 9B 46 43 1C 07 46 92 46 34 D0 01 F1 01 08 B8 F1 00 0F 2F DD 00 2A 2D DB 44 68 00 25 02 FB 08 F0 21 46 ?? ?? ?? ?? 04 EB 44 0C FB 68 4F EA 8C 09 01 EB 41 01 03 EB 81 04 04 E0 BE 68 61 44 4C 44 B5 42 0D D2 26 68 01 35 46 45 F6 D1 66 68 56 45 F3 D1 02 31 38 69 53 F8 21 30 18 44 BD E8 F8 8F 06 4B 1D EE 70 2F 2A 21 58 46 7B 44 1B 68 D1 50 BD E8 F8 8F 58 46 BD E8 F8 8F 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_465_2_0 {
	meta:
		name = "catclose"
		size = 76
		refs = "0012 free 0024 __munmap 0048 __libc_errno"
	strings:
		$1 = { 43 1C 10 B5 04 46 14 D0 03 68 4B B1 01 2B 10 D1 40 69 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 00 20 10 BD A1 69 40 69 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 00 20 10 BD 05 4B 1D EE 70 2F 09 21 4F F0 FF 30 7B 44 1B 68 D1 50 10 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_467_0_0 {
	meta:
		name = "_IO_fread"
		size = 300
		refs = "005c _IO_sgetn 00a0 __aeabi_uidiv 00b4 __lll_lock_wait_private 00ce __libc_do_syscall 0128 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F8 43 0E 46 02 FB 01 F5 17 46 80 46 1C 46 00 2D 49 D0 1B 68 19 04 1D D4 A0 6C 1D EE 70 9F A9 F5 98 69 82 68 4A 45 12 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 00 2A 35 D1 A2 6C 10 46 C2 F8 08 90 42 68 01 32 42 60 41 46 20 46 2A 46 ?? ?? ?? ?? 23 68 80 46 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 10 DC 45 45 08 D0 40 46 31 46 ?? ?? ?? ?? BD E8 F8 83 28 46 BD E8 F8 83 38 46 BD E8 F8 83 ?? ?? ?? ?? C6 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E1 E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_469_0_0 {
	meta:
		name = "fstatat64"
		size = 26
		refs = "0012 __fxstatat64"
		altNames = "fstatat"
	strings:
		$1 = { 30 B5 83 B0 0D 46 14 46 01 46 00 93 2A 46 23 46 03 20 ?? ?? ?? ?? 03 B0 30 BD }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "execlp"
		size = 184
		refs = "0058 realloc 0066 execvp 0076 free 00b2 memcpy"
	strings:
		$1 = { 0E B4 2D E9 F0 4F AD F5 80 5D 82 B0 83 46 0D F5 81 55 0D F1 08 0A 0C 35 55 F8 04 3B CA F8 00 30 4A F8 04 5C 8B B3 10 26 01 24 57 46 4F F4 80 68 00 E0 08 36 04 35 55 F8 04 3C 4F EA 84 09 01 95 47 F8 24 30 01 34 63 B1 A0 45 F2 D1 57 45 38 46 31 46 4F EA 48 08 22 D0 ?? ?? ?? ?? C8 B1 07 46 E7 E7 58 46 39 46 ?? ?? ?? ?? 57 45 04 46 08 BF 00 46 03 D0 38 46 ?? ?? ?? ?? 20 46 0D F5 80 5D 02 B0 BD E8 F0 4F 03 B0 70 47 51 46 ?? ?? ?? ?? F4 E7 38 46 ?? ?? ?? ?? 4F F0 FF 30 EE E7 31 46 00 20 ?? ?? ?? ?? 51 46 09 F1 04 02 07 46 00 28 F2 D0 ?? ?? ?? ?? BC E7 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "wcsspn"
		size = 60
	strings:
		$1 = { 70 B4 04 68 C4 B1 0D 68 06 46 9D B1 00 20 A5 42 09 D0 0A 46 01 E0 9C 42 05 D0 52 F8 04 3F 00 2B F9 D1 70 BC 70 47 56 F8 04 4F 01 30 00 2C EE D1 70 BC 70 47 28 46 F4 E7 20 46 F2 E7 }
	condition:
		$1
}

rule file_474_0_0 {
	meta:
		name = "__getutline_r"
		size = 158
		refs = "0002 __libc_utmp_lock 002a __libc_utmp_jump_table 0072 __lll_lock_wait_private 0098 __libc_do_syscall"
	strings:
		$1 = { 70 B5 ?? ?2 0? 0? 05 46 82 B0 ?? ?2 0? 0? 01 20 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 06 00 2E F7 D1 BF F3 5F 8F EB B9 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? 1B 68 DB 68 98 47 00 21 05 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0D DC 28 46 02 B0 70 BD ?? ?2 0? 0? 01 91 ?? ?2 0? 0? 00 92 ?? ?? ?? ?? 00 9A 01 99 D6 E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? E0 E7 }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "getrpcport"
		size = 168
		refs = "0048 __gethostbyname_r 0080 memcpy 0098 pmap_getport 00a4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 91 B0 02 AF AD F5 81 6D 92 46 80 46 8B 46 7B 60 02 AA 4F F4 80 64 07 F1 0C 06 07 F1 10 05 DF F8 80 90 08 E0 4A 46 7A 44 12 68 8A 58 22 2A 18 D1 AD EB 03 0D 02 AA 23 46 07 F1 24 01 00 96 40 46 01 95 64 00 ?? ?? ?? ?? 04 F1 0E 03 1D EE 70 1F 23 F0 07 03 84 46 08 B9 FA 68 3A B9 3A 69 01 32 E0 D0 00 20 3C 37 BD 46 BD E8 F0 8F 13 69 07 F1 18 00 D2 68 02 24 19 68 C7 F8 00 C0 ?? ?? ?? ?? D7 F8 00 C0 59 46 7B 68 52 46 07 F1 14 00 BC 82 A7 F8 16 C0 ?? ?? ?? ?? 3C 37 BD 46 BD E8 F0 8F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "__readdir64"
		size = 244
		refs = "0068 __getdents64 00d8 __libc_do_syscall 00e0 __lll_lock_wait_private 00e8 __libc_errno"
	strings:
		$1 = { 2D E9 F8 45 1D EE 70 8F 37 4B 04 46 01 22 07 1D 7B 44 1B 68 58 F8 03 60 BF F3 5F 8F 57 E8 00 3F 00 2B 03 D1 47 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 54 D1 D4 F8 10 C0 04 F1 18 0A 0A E0 A8 68 D5 E9 00 23 29 8A 60 61 52 EA 03 00 61 44 21 61 8C 46 18 D1 E3 68 0C F1 18 05 25 44 63 45 EE D8 20 68 51 46 A2 68 55 46 ?? ?? ?? ?? 4F F0 00 0C 00 28 01 DD E0 60 E2 E7 1A D1 1C 4B 00 25 7B 44 1B 68 48 F8 03 60 00 22 63 68 BF F3 5F 8F 57 E8 00 1F 99 42 03 D1 47 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 0C DC 28 46 BD E8 F8 85 0F 4B 7B 44 1B 68 58 F8 03 30 02 2B 18 BF 65 46 E1 D1 DA E7 A8 F5 98 68 01 22 38 46 00 23 D8 F8 08 10 4F F0 F0 0C 11 43 ?? ?? ?? ?? E5 E7 38 46 ?? ?? ?? ?? A6 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "__libc_open64"
		size = 160
		refs = "0014 __libc_multiple_threads 002c __libc_do_syscall 0044 __libc_enable_asynccancel 0066 __libc_disable_asynccancel 0098 __libc_errno"
	strings:
		$1 = { 0E B4 30 B5 84 B0 04 46 07 99 11 F0 40 02 1C BF 08 AB 03 93 ?? ?2 0? 0? 18 BF 08 9A ?? ?2 0? 0? 1B 68 6B B9 41 F4 00 31 4F F0 05 0C ?? ?? ?? ?? 10 F5 80 5F 1B D8 04 B0 BD E8 30 40 03 B0 70 47 8D E8 06 00 ?? ?? ?? ?? 00 99 4F F0 05 0C 01 9A 41 F4 00 31 05 46 20 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0E D8 28 46 ?? ?? ?? ?? 20 46 E3 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 D9 E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E6 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_0_3 {
	meta:
		name = "__libc_open64"
		size = 160
		refs = "0014 __pthread_multiple_threads 002c __libc_do_syscall 0044 __pthread_enable_asynccancel 0066 __pthread_disable_asynccancel 0098 errno"
	strings:
		$1 = { 0E B4 30 B5 84 B0 04 46 07 99 11 F0 40 02 1C BF 08 AB 03 93 ?? ?2 0? 0? 18 BF 08 9A ?? ?2 0? 0? 1B 68 6B B9 41 F4 00 31 4F F0 05 0C ?? ?? ?? ?? 10 F5 80 5F 1B D8 04 B0 BD E8 30 40 03 B0 70 47 8D E8 06 00 ?? ?? ?? ?? 00 99 4F F0 05 0C 01 9A 41 F4 00 31 05 46 20 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0E D8 28 46 ?? ?? ?? ?? 20 46 E3 E7 0A 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 D9 E7 06 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E6 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_479_0_0 {
	meta:
		name = "ffsll"
		size = 28
	strings:
		$1 = { 00 28 12 BF 00 22 20 22 5F EA 01 00 90 FA A0 F0 1E BF B0 FA 80 F0 01 32 80 18 70 47 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "__wcscasecmp"
		size = 46
		refs = "0014 towlower"
	strings:
		$1 = { 88 42 70 B5 06 46 0D 46 02 D1 0E E0 84 42 0A D1 56 F8 04 0B ?? ?? ?? ?? 04 46 55 F8 04 0B ?? ?? ?? ?? 00 2C F2 D1 20 1A 70 BD 00 20 70 BD }
	condition:
		$1
}

rule file_481_0_0 {
	meta:
		name = "__rawmemchr"
		size = 118
	strings:
		$1 = { 02 78 00 F0 07 03 C9 B2 C3 F1 0F 03 8A 42 08 BF 70 47 10 F8 01 2F 01 3B 18 BF 8A 42 F9 D1 8A 42 08 BF 70 47 00 F1 01 00 F0 E8 02 23 41 EA 01 21 40 F2 01 1C 90 F8 40 F0 C0 F2 01 1C 41 EA 01 41 82 EA 01 02 83 EA 01 03 CC FA 52 F2 CC FA 53 F3 90 F8 80 F0 13 43 08 BF F0 E8 02 23 F0 D0 00 2A A0 F1 04 00 0C BF 1A 46 04 38 12 BA B2 FA 82 F2 00 EB D2 00 70 47 }
	condition:
		$1
}

rule file_483_0_0 {
	meta:
		name = "__mbsnrtowcs"
		size = 492
		refs = "0006 .LANCHOR0 0040 __strnlen 0070 _dl_mcount_wrapper_check 016a _nl_C_LC_CTYPE 0178 __wcsmbs_load_conv 0180 .LC3 0184 .LC1 0188 __PRETTY_FUNCTION__.11593 019a __assert_fail 019e __wcsmbs_gconv_fcts_c 01a8 .LC2 01c6 .LC0 01e4 _nl_current_LC_CTYPE 01e8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F D5 B0 ?? ?2 0? 0? 06 46 5E 9F ?? ?2 0? 0? 0D 46 99 46 01 21 00 23 00 2F 08 BF 27 46 0E 93 10 97 10 46 13 93 0F 91 0D 91 12 B9 55 B0 BD E8 F0 8F 2C 68 51 1E 1D EE 70 2F 05 92 20 46 ?? ?? ?? ?? 67 4B 05 99 7B 44 1B 68 CB 58 1F 68 7B 69 01 30 04 EB 00 08 00 2B 00 F0 86 80 1F 68 7C 69 00 2E 51 D0 20 46 06 EB 89 03 0B 96 0C 93 ?? ?? ?? ?? 00 22 38 46 43 46 0D F1 1C 0E 00 92 01 27 02 92 0B A9 2A 46 CD F8 04 E0 03 97 A0 47 0B 9B 9B 1B 4F EA A3 0B 30 F0 04 02 10 D1 BB F1 00 0F 00 F0 90 80 0B F1 80 43 01 3B 56 F8 23 30 33 B9 10 9B 1B 68 00 2B 76 D1 0B F1 FF 3B 2B 60 03 1C 18 BF 01 23 02 1F 18 BF 01 22 13 42 08 D0 81 1F 01 29 05 D9 05 28 52 D1 58 46 55 B0 BD E8 F0 8F 20 F0 02 00 05 28 0C BF 00 23 03 F0 01 03 00 2B F2 D0 00 2A F0 D0 3B 4B 54 22 05 99 4F F0 FF 30 7B 44 1B 68 CA 50 91 E7 10 99 09 AB D5 F8 00 E0 B3 46 14 AD 0D F1 1C 0A 03 C9 4F F0 01 09 54 AA CD F8 20 E0 0C 92 83 E8 03 00 10 93 20 46 0B 95 ?? ?? ?? ?? 08 AA 43 46 8D E8 40 04 38 46 02 96 0B A9 CD F8 0C 90 A0 47 0B 9B 5A 1B 0B EB A2 0B 05 28 EB D0 30 F0 04 01 B1 D1 53 F8 04 3C 00 2B AD D1 0B F1 FF 3B AA E7 ?? ?2 0? 0? ?? ?2 0? 0? 9F 42 13 D0 38 46 ?? ?? ?? ?? 7B 69 6E E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 89 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 5A E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 7E 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 7B 22 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_484_0_0 {
	meta:
		name = "_dl_signal_error"
		size = 270
		refs = "0004 _dl_error_catch_tsd 000c .LC0 002a .LC1 003e strlen 0054 malloc 0060 mempcpy 0068 memcpy 0080 __longjmp 0084 _dl_out_of_memory 0094 _dl_argv 0098 .LC2 00a0 .LC3 00a4 .LC4 00da .LC5 00f4 _dl_dprintf 00fa _exit 0108 __strerror_r"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 0C 46 AD F2 1C 4D 31 68 00 2B 14 BF 98 46 A8 46 07 46 91 46 88 47 ?? ?2 0? 0? ?? ?2 0? 0? 00 2C 08 BF 34 46 05 68 5D B3 20 46 ?? ?? ?? ?? 00 F1 01 09 40 46 ?? ?? ?? ?? 00 F1 01 0A 0A EB 09 00 ?? ?? ?? ?? 68 60 98 B1 41 46 52 46 ?? ?? ?? ?? 21 46 4A 46 ?? ?? ?? ?? 01 23 2B 72 28 60 05 F1 10 00 00 2F 14 BF 39 46 4F F0 FF 31 ?? ?? ?? ?? ?? ?2 0? 0? 2E 60 ?? ?2 0? 0? 28 72 6A 60 EE E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 94 F8 00 A0 12 68 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? B9 F1 00 0F 08 BF 99 46 BA F1 00 0F 0C BF B2 46 AA 46 12 68 00 2A 14 BF 93 46 8B 46 97 B9 30 46 ?? ?2 0? 0? 04 90 8D E8 10 04 02 20 5A 46 CD F8 08 80 4B 46 03 96 ?? ?2 0? 0? ?? ?? ?? ?? 7F 20 ?? ?? ?? ?? 38 46 06 A9 4F F4 80 62 2E 46 ?? ?? ?? ?? E5 E7 }
	condition:
		$1
}

rule file_484_1_0 {
	meta:
		name = "_dl_signal_cerror"
		size = 110
		refs = "0004 _dl_debug_mask 001c .LANCHOR0 003c .LC7 0040 .LC6 004e .LC8 0060 _dl_debug_printf 006a _dl_signal_error"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? ?? ?2 0? 0? 80 46 83 B0 0E 46 20 68 91 46 1D 46 30 F4 08 64 ?? ?2 0? 0? 0A D1 ?? ?2 0? 0? 24 68 40 46 31 46 DC B1 2A 46 A0 47 03 B0 BD E8 F0 83 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 27 68 ?? ?2 0? 0? ?? ?2 0? 0? 00 2F 0C BF 67 46 77 46 ?? ?2 0? 0? 00 97 ?? ?? ?? ?? DF E7 4A 46 2B 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_484_2_0 {
	meta:
		name = "_dl_catch_error"
		size = 118
		refs = "0002 _dl_error_catch_tsd 0026 __sigsetjmp"
	strings:
		$1 = { 30 B5 ?? ?2 0? 0? EF B0 ?? ?2 0? 0? 00 25 02 90 09 95 20 68 03 91 05 93 04 92 80 47 29 46 03 68 01 90 0C A8 07 93 ?? ?? ?? ?? 04 46 88 B9 01 9A 08 AB 72 98 13 60 05 9B 98 47 07 9B 01 9D 20 46 02 9A 2B 60 03 9B 04 9D 14 60 1C 60 2C 70 6F B0 30 BD 07 9B B0 F1 FF 3F 08 BF 00 20 01 9D 08 9C 09 99 2B 60 02 9B 9D F8 28 20 03 9D 1C 60 04 9B 29 60 1A 70 EB E7 }
	condition:
		$1
}

rule file_484_3_0 {
	meta:
		name = "_dl_receive_error"
		size = 58
		refs = "0004 _dl_error_catch_tsd 0014 .LANCHOR0"
	strings:
		$1 = { 2D E9 F8 43 ?? ?2 0? 0? ?? ?2 0? 0? 17 46 06 46 89 46 1B 68 ?? ?2 0? 0? 98 47 ?? ?2 0? 0? 00 23 D4 F8 00 80 26 60 05 46 38 46 2F 68 2B 60 C8 47 C4 F8 00 80 2F 60 BD E8 F8 83 }
	condition:
		$1
}

rule file_485_0_0 {
	meta:
		name = "__ttyname_r_chk"
		size = 18
		refs = "000e __chk_fail 000a __ttyname_r"
	strings:
		$1 = { 9A 42 08 B5 03 D8 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1408_0_0 {
	meta:
		name = "__ptsname_r_chk"
		size = 18
		refs = "000e __chk_fail 000a __ptsname_r"
	strings:
		$1 = { 9A 42 08 B5 03 D8 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_486_0_0 {
	meta:
		name = "execle"
		size = 230
		refs = "0064 realloc 007a __execve 008a free 00dc memcpy"
	strings:
		$1 = { 0E B4 84 46 2D E9 F0 4F AD F5 80 5D 84 B0 0D F5 81 59 0D F1 10 0B 09 F1 14 09 59 F8 04 3B CB F8 00 30 4B F8 04 9C 00 2B 39 D0 09 F1 04 04 10 26 01 25 D8 46 4F F4 80 6A 01 E0 04 34 08 36 54 F8 04 3C C9 EB 04 07 03 94 01 35 48 F8 07 30 8B B1 AA 45 F2 D1 D8 45 40 46 31 46 4F EA 4A 07 2C D0 CD F8 04 C0 ?? ?? ?? ?? DD F8 04 C0 F8 B1 80 46 BA 46 E2 E7 22 68 60 46 41 46 ?? ?? ?? ?? D8 45 04 46 08 BF 00 46 03 D0 40 46 ?? ?? ?? ?? 20 46 0D F5 80 5D 04 B0 BD E8 F0 4F 03 B0 70 47 0D F5 81 53 59 46 18 33 1A 68 ?? ?? ?? ?? F0 E7 40 46 ?? ?? ?? ?? 4F F0 FF 30 EA E7 31 46 00 20 CD F8 04 C0 ?? ?? ?? ?? 4F EA 8A 02 59 46 BA 46 DD F8 04 C0 80 46 00 28 ED D0 CD F8 04 C0 ?? ?? ?? ?? DD F8 04 C0 A9 E7 }
	condition:
		$1
}

rule file_487_0_0 {
	meta:
		name = "__getcwd"
		size = 1936
		refs = "0012 __getpagesize 0026 malloc 003e __libc_do_syscall 00bc realloc 00c4 __libc_errno 0100 .LC0 011c __lxstat64 012a .LC1 0180 __have_atfcts 018c dots.10848 01c6 .LC2 01d6 __openat64_nocancel 01ea __fxstat64 01fa __closedir 021e __fdopendir 0260 __readdir 02c0 __fxstatat64 0308 strlen 0356 memcpy 039e .LC3 03a2 .LC4 03a6 __PRETTY_FUNCTION__.9709 03b8 __assert_fail 03be free 0404 rewinddir 0448 mempcpy 0454 strcpy 0538 __opendir 0624 memmove"
	strings:
		$1 = { 2D E9 F0 4F BB B0 8B 46 02 AF 04 46 89 B9 00 28 46 D1 ?? ?? ?? ?? B0 F5 80 5F AC BF 01 46 4F F4 80 51 08 46 F9 60 ?? ?? ?? ?? F9 68 82 46 18 B9 31 E0 82 46 00 28 F4 D0 50 46 4F F0 B7 0C ?? ?? ?? ?? 10 F5 80 5F 11 D8 00 28 B8 BF 1D EE 70 9F 14 DB BB F1 00 0F 08 BF 00 2C 2D D0 00 2C 14 BF 20 46 50 46 E4 37 BD 46 BD E8 F0 8F 15 4B 1D EE 70 9F 40 42 7B 44 1B 68 49 F8 03 00 12 4B 7B 44 1B 68 59 F8 03 30 24 2B 22 D0 22 2B 00 F0 81 81 00 2C 00 F0 55 82 00 20 E4 37 BD 46 BD E8 F0 8F 0A 4B 1D EE 70 2F 08 46 E4 37 7B 44 1B 68 16 21 D1 50 BD 46 BD E8 F0 8F 01 46 50 46 ?? ?? ?? ?? 04 46 CB E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? D4 F1 01 04 38 BF 00 24 7C 65 7D 6D DB F1 01 04 38 BF 00 24 FC 64 2C 42 40 F0 68 81 FD 6C 00 2D 40 F0 18 82 7B 61 C7 F8 38 B0 C7 F8 44 A0 BE 6B ?? ?2 0? 0? 4F F0 00 0C 07 F1 78 02 56 44 ?? ?2 0? 0? 03 20 74 1E 06 F8 01 CC 3C 62 ?? ?? ?? ?? 00 28 C0 F2 36 82 D7 E9 1E 45 ?? ?2 0? 0? 03 20 ?? ?2 0? 0? 07 F1 78 02 C7 E9 1C 45 D7 F8 D8 50 3D 66 ?? ?? ?? ?? 00 28 C0 F2 33 82 D7 E9 1E 45 C7 E9 0A 45 D7 F8 D8 50 D7 E9 0A 01 7D 62 D7 E9 1C 45 8D 42 08 BF 84 42 3C 6E 7D 6A 0C BF 00 23 01 23 AC 42 18 BF 43 F0 01 03 00 2B 00 F0 2F 82 ?? ?2 0? 0? DF F8 54 85 ?? ?2 0? 0? ?? ?2 0? 0? C7 F8 30 B0 00 25 B3 46 ?? ?2 0? 0? E0 24 C7 F8 5C C0 C7 F8 50 C0 0C F1 E1 0C FC 63 C7 F8 58 C0 6F F0 63 0C C7 F8 34 A0 C7 F8 64 C0 DB F8 00 30 00 2B C0 F2 8A 81 ?? ?2 0? 0? 78 6E ?? ?2 0? 0? 4F F4 00 22 00 23 ?? ?? ?? ?? 00 28 78 66 C0 F2 7F 81 03 20 79 6E 07 F1 78 02 ?? ?? ?? ?? 00 28 C0 F2 3D 82 01 24 2D B1 28 46 ?? ?? ?? ?? 00 28 40 F0 2A 82 DB F8 00 30 D7 E9 1E 01 D7 F8 D8 50 00 2B C7 E9 1A 01 3D 61 C0 F2 8D 81 78 6E ?? ?? ?? ?? 05 46 00 2D 00 F0 0D 82 D7 F8 3C A0 00 26 3B 6D 01 24 D7 F8 58 C0 00 21 38 6E 53 44 CC EB 03 03 C7 F8 04 B0 03 EB 04 0A BB 64 C7 F8 40 A0 C7 E9 06 01 43 46 28 46 7B 44 1B 68 49 F8 03 60 ?? ?? ?? ?? 00 28 00 F0 C1 80 83 7A 13 F0 FB 0F F0 D1 C3 7A 2E 2B 00 F0 C8 80 D7 E9 1C 23 D7 E9 1A AB 9B 45 08 BF 92 45 14 BF 00 23 04 F0 01 03 2B B1 03 68 39 6E 8B 42 18 BF 01 24 DA D1 D7 F8 04 A0 DA F8 00 30 00 2B C0 F2 B8 80 00 F1 0B 0A 4F F4 80 73 00 93 52 46 03 20 79 6E 07 F1 78 03 ?? ?? ?? ?? 00 28 C5 DB D7 F8 88 30 03 F4 70 43 B3 F5 80 4F BE D1 D7 E9 1E 23 D7 E9 1C 01 99 42 08 BF 90 42 B6 D1 D7 E9 36 23 D7 E9 06 01 8B 42 08 BF 82 42 AE D1 D7 F8 20 C0 50 46 7C 6B D7 F8 04 B0 C4 EB 0C 04 3C 67 ?? ?? ?? ?? 3A 6F 90 42 04 46 23 D3 FB 6C 00 2B 00 F0 24 82 BE 6B B0 42 28 BF 06 46 78 6B 76 00 31 46 ?? ?? ?? ?? 03 46 00 28 00 F0 0C 82 D7 F8 38 C0 7A 6B 39 6F 62 44 D7 F8 20 C0 01 44 BE 63 C2 EB 0C 00 CC EB 02 02 30 44 7B 63 18 44 ?? ?? ?? ?? 38 62 D7 F8 20 C0 22 46 51 46 C4 EB 0C 03 3C 69 18 46 03 F1 FF 3A C7 F8 20 A0 3C 66 ?? ?? ?? ?? 2F 22 00 F8 01 2C 78 6A A0 42 00 F0 BF 81 D7 E9 1A 23 C7 E9 1C 23 14 E7 00 2C 08 BF BB F1 00 0F 7F F4 79 AE ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 7B 22 ?? ?? ?? ?? 50 46 ?? ?? ?? ?? BA 4B 41 F2 01 00 7B 44 1B 68 59 F8 03 30 7B 61 ?? ?? ?? ?? 82 46 00 28 00 F0 65 81 41 F2 01 0C 00 24 C7 F8 38 C0 7C 64 88 E6 B0 4B 7B 44 1B 68 59 F8 03 30 00 2B 40 F0 C4 80 00 2C 3B D0 28 46 1C 46 ?? ?? ?? ?? 24 E7 03 7B 00 2B 3F F4 21 AF 83 89 2E 2B 7F F4 30 AF 1B E7 B0 F8 08 E0 00 F1 0B 0A D7 F8 40 B0 6B 46 B9 6D DE 44 BA 6C AE F1 04 00 BB 60 20 F0 07 00 AD EB 00 0D 0D F1 08 0C C7 F8 0C C0 60 46 ?? ?? ?? ?? 2F 22 51 46 00 F8 01 2B ?? ?? ?? ?? D7 F8 0C C0 03 20 07 F1 78 02 61 46 ?? ?? ?? ?? BB 68 00 28 B8 BF 9D 46 FF F6 F0 AE 9D 46 27 E7 8E 4B 02 22 D7 F8 34 A0 16 46 D7 F8 30 B0 7B 44 1B 68 49 F8 03 20 D7 F8 50 C0 F8 6D 84 45 02 D0 38 6D ?? ?? ?? ?? 15 B1 28 46 ?? ?? ?? ?? 24 B1 78 6E 4F F0 06 0C ?? ?? ?? ?? 7C 6C 00 2C 78 D0 7F 4B 7B 44 1B 68 49 F8 03 60 7D 6D 3D B1 BB F1 00 0F 3F F4 E4 AD 78 6C ?? ?? ?? ?? DF E5 78 6D C4 E5 4F F0 FF 34 7C 66 76 4B 7B 44 1B 68 59 F8 03 30 26 2B 40 F0 CA 80 BC 6D 4F F0 FF 30 D7 F8 50 A0 CB F8 00 00 54 45 23 D0 D7 F8 58 C0 03 20 07 F1 78 02 AC F1 03 0C C7 F8 58 C0 61 46 ?? ?? ?? ?? 00 28 C0 F2 B9 80 00 24 68 E6 66 4B 16 22 C7 F8 44 A0 7B 44 1B 68 49 F8 03 20 C5 E7 B8 6D ?? ?? ?? ?? 05 46 71 E6 50 46 ?? ?? ?? ?? 20 46 8C E5 D7 F8 5C C0 64 45 34 D0 D7 F8 3C C0 B8 6D 4F EA 4C 04 61 1C ?? ?? ?? ?? 38 65 00 28 00 F0 C1 80 D7 F8 3C A0 50 44 B8 65 FA 6B B8 6D 39 6D FC 63 ?? ?? ?? ?? 00 23 03 70 BE E7 D7 F8 34 A0 1E 46 D7 F8 30 B0 04 46 7D E7 00 25 6F F0 63 0C C7 F8 64 C0 49 4B 00 24 7B 44 1B 68 59 F8 03 60 79 E7 50 46 ?? ?? ?? ?? 82 E7 6F F0 63 04 00 25 7C 66 EF E7 D7 F8 3C A0 4F EA 4A 04 60 1C ?? ?? ?? ?? 38 65 00 28 00 F0 B2 80 B9 6D FA 6B ?? ?? ?? ?? B8 65 C9 E7 ?? ?2 0? 0? ?? ?2 0? 0? FC 65 3C 65 BD 6B D7 F8 20 B0 6B 1E D7 F8 50 C0 53 44 FC 6D 9B 45 01 BF 2F 23 0B F8 01 3C 0B F1 FF 3B C7 F8 20 B0 A4 45 02 D0 60 46 ?? ?? ?? ?? D7 F8 20 B0 50 46 CB EB 06 05 59 46 2A 46 ?? ?? ?? ?? FC 6C 00 2C 58 D1 26 4B 7C 69 78 6C 7B 44 1B 68 00 28 08 BF 50 46 49 F8 03 40 0F E5 21 4B D7 F8 34 A0 7B 44 1B 68 D7 F8 30 B0 59 F8 03 60 1A E7 1D 4B 00 25 D7 F8 34 A0 7B 44 1B 68 D7 F8 30 B0 59 F8 03 60 0F E7 19 4B 01 24 D7 F8 34 A0 7B 44 1B 68 D7 F8 30 B0 59 F8 03 60 04 E7 D7 F8 34 A0 1E 46 D7 F8 30 B0 00 24 FD E6 11 4B 00 24 D7 F8 34 A0 7B 44 1B 68 D7 F8 30 B0 59 F8 03 60 F2 E6 78 64 0A E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 29 46 50 46 ?? ?? ?? ?? 78 64 A0 E7 BC 6D 24 4B D7 F8 34 A0 3C 65 7B 44 1B 68 D7 F8 30 B0 04 46 59 F8 03 60 C8 E6 D7 E9 0A 23 D7 E9 1A 01 8B 42 08 BF 82 42 0C BF 00 24 01 24 00 2C 7F F4 34 AE 28 46 D7 F8 34 A0 D7 F8 30 B0 ?? ?? ?? ?? 38 B9 BE 6B 56 44 59 E7 D7 F8 34 A0 D7 F8 30 B0 2D E7 10 4B 25 46 7B 44 1B 68 59 F8 03 60 9F E6 0E 4B 04 46 D7 F8 34 A0 7B 44 1B 68 D7 F8 30 B0 59 F8 03 60 94 E6 09 4B 22 22 D7 F8 34 A0 16 46 7B 44 1B 68 D7 F8 30 B0 FC 6C 49 F8 03 20 87 E6 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_488_0_0 {
	meta:
		name = "__fstatfs64"
		size = 48
		refs = "000a __libc_do_syscall 002c __libc_errno"
	strings:
		$1 = { 0A 46 40 F2 0B 1C 00 B5 58 21 ?? ?? ?? ?? 10 F5 80 5F 01 D8 5D F8 04 FB 04 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_489_0_0 {
	meta:
		name = "abort"
		size = 416
		refs = "0000 .LANCHOR0 007a _exit 0082 raise 008e __fcloseall 00e4 __libc_do_syscall 0120 __lll_lock_wait_private 0136 memset 0154 __sigaction 0178 __sigprocmask 018a _IO_flush_all_lockp"
	strings:
		$1 = { ?? ?2 0? 0? 1D EE 70 5F ?? ?2 0? 0? A5 F5 98 65 80 B5 C4 B0 A3 68 AB 42 10 D0 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 AC 80 A5 60 63 68 ?? ?2 0? 0? E6 68 ?? ?2 0? 0? 01 33 63 60 33 46 00 2E 00 F0 84 80 01 2B 00 F0 95 80 02 2B 1B D0 03 2B 64 D0 04 2B 11 D0 05 2B 09 D0 06 2B 02 D0 07 2B 00 D0 FE E7 7F 20 08 23 E3 60 ?? ?? ?? ?? 06 20 E0 60 ?? ?? ?? ?? E3 68 EF E7 05 23 E3 60 ?? ?? ?? ?? E3 68 E7 E7 63 68 ?? ?2 0? 0? 00 21 ?? ?2 0? 0? 01 3B E1 60 63 60 F3 B9 19 46 93 60 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0B DD A9 68 01 22 ?? ?2 0? 0? 00 23 ?? ?2 0? 0? 11 43 4F F0 F0 0C ?? ?? ?? ?? 06 20 ?? ?? ?? ?? A2 68 ?? ?2 0? 0? 95 42 ?? ?2 0? 0? 14 D0 01 21 BF F3 5F 8F 53 E8 00 2F 00 2A 03 D1 43 E8 00 10 00 28 F7 D1 BF F3 5F 8F 2A B1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? A5 60 63 68 01 33 63 60 00 21 8C 22 21 A8 04 23 E3 60 ?? ?? ?? ?? 42 AB 22 A9 4F F0 FF 32 43 F8 04 2D 8B 42 FB D1 00 23 21 A9 1A 46 06 20 42 93 ?? ?? ?? ?? E3 68 82 E7 4F F0 01 08 31 46 80 22 01 A8 C7 F8 0C 80 ?? ?? ?? ?? 40 46 32 46 01 A9 20 23 01 93 ?? ?? ?? ?? FB 68 01 2B 7F F4 6B AF 00 20 02 23 E3 60 ?? ?? ?? ?? E3 68 63 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 4C E7 }
	condition:
		$1
}

rule file_490_0_0 {
	meta:
		name = "symlinkat"
		size = 220
		refs = "0004 __have_atfcts 0020 __libc_do_syscall 0046 strlen 0052 procfd.11201 006e __snprintf 008c __atfct_seterrno 00d0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 43 ?? ?2 0? 0? 83 B0 ?? ?2 0? 0? 81 46 02 AF 88 46 26 68 15 46 00 2E 0D DB 40 F2 4B 1C ?? ?? ?? ?? 10 F5 80 5F 37 D8 04 37 BD 46 BD E8 F0 83 4F F0 FF 33 23 60 18 F1 64 0F 2B D0 2B 78 2F 2B 28 D0 28 46 ?? ?? ?? ?? 00 28 35 D0 00 F1 2E 03 ?? ?2 0? 0? 23 F0 07 03 00 F1 20 01 AD EB 03 0D ?? ?2 0? 0? 02 AC 43 46 00 95 20 46 ?? ?? ?? ?? 25 46 48 46 29 46 4F F0 53 0C ?? ?? ?? ?? 10 F5 80 5F D1 D9 40 42 41 46 22 46 ?? ?? ?? ?? 4F F0 FF 30 C9 E7 00 24 EC E7 0D 4A 1D EE 70 1F 0C 4B 40 42 7A 44 12 68 88 50 7B 44 1B 68 CB 58 26 2B BE D0 4F F0 FF 30 B7 E7 07 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 D1 50 AD E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_492_0_0 {
	meta:
		name = "_dl_start_profile"
		size = 1386
		refs = "0004 _dl_profile_map 0026 _dl_pagesize 007e .LANCHOR0 00f2 _dl_profile 010a __profile_frequency 010e .LC4 0112 _dl_profile_output 0142 strlen 016a stpcpy 017c .LC5 01a0 __open 01b8 __fxstat64 01d0 .LC1 01e6 __close 01f4 __strerror_r 0200 _dl_dprintf 0234 .LC0 026e .LC6 02ac memset 02c0 __lseek 0308 __libc_write 0342 __mmap 038c memcmp 03b8 __munmap 03ca .LC2 03dc .LC3 03f0 __libc_errno 045a calloc 04de __aeabi_uidiv 0502 __profil 053e .LC7 054e _exit"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? AD F5 19 7D ?? ?2 0? 0? 02 AF 1C 68 B4 F8 58 11 D4 F8 50 31 03 EB 41 11 8B 42 80 F0 CC 81 ?? ?2 0? 0? 4F F0 FF 35 ?? ?2 0? 0? 00 20 12 68 C2 F1 00 0E 02 EB 05 0C 02 E0 20 33 8B 42 18 D2 1A 68 01 2A F9 D1 9A 69 D2 07 F6 D5 9A 68 20 33 53 F8 0C 6C 0C EB 02 08 02 EA 0E 02 46 44 95 42 28 BF 15 46 06 EA 0E 06 B0 42 38 BF 30 46 8B 42 E6 D3 29 46 02 46 23 68 ?? ?2 0? 0? ?? ?2 0? 0? 48 F2 1F 56 03 F1 03 09 1D 44 81 44 25 F0 03 05 29 F0 03 09 C5 F2 EB 16 C5 EB 09 03 65 60 A3 60 4F F0 00 0E 03 EB 43 05 4F EA 53 08 04 20 C4 F8 00 E0 A6 FB 05 36 E0 60 76 09 31 2E 00 F2 A4 80 4F F4 98 5A 32 23 4F F4 C8 76 23 61 7E 62 46 F6 67 55 4F F6 FF 70 4F F0 00 0B 4F EA 58 03 7A 64 C6 F6 6F 65 C0 F2 01 00 FD 62 39 64 ?? ?2 0? 0? BB 64 ?? ?2 0? 0? C7 F8 34 B0 C7 F8 38 B0 C7 F8 3C B0 38 63 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 07 F1 50 0E C7 F8 58 B0 0E 68 73 21 87 F8 5F 10 A7 F8 5C B0 87 F8 5E B0 F8 64 93 E8 03 00 8E E8 03 00 30 46 ?? ?? ?? ?? 2B 68 7B 60 02 46 18 46 BA 60 ?? ?? ?? ?? BA 68 31 46 10 44 00 F1 18 02 22 F0 07 02 AD EB 02 0D 02 AE 30 46 ?? ?? ?? ?? 7B 68 19 46 2F 23 00 F8 01 3B ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 DB 72 86 46 03 CB 1B 78 CE F8 00 00 30 46 CE F8 04 10 48 F2 42 01 8E F8 08 30 ?? ?? ?? ?? B0 F1 FF 3F 84 46 40 D0 61 46 03 20 07 F1 60 02 C7 F8 08 C0 ?? ?? ?? ?? D7 F8 08 C0 00 28 05 DB 3B 6F 03 F4 70 43 B3 F5 00 4F 39 D0 ?? ?2 0? 0? 1D EE 70 2F ?? ?2 0? 0? 84 4B 60 46 7B 44 1B 68 D5 58 ?? ?? ?? ?? 07 F1 C8 01 4F F4 C8 72 28 46 ?? ?? ?? ?? 21 46 32 46 03 46 02 20 ?? ?? ?? ?? 07 F5 17 77 BD 46 BD E8 F0 8F B6 F5 80 1F 40 F2 9E 81 4F F0 40 0A 4F F4 00 0B 4F F4 80 13 C7 F8 24 B0 C0 F2 00 6A 23 61 52 E7 71 4B 1D EE 70 2F ?? ?2 0? 0? 7B 44 1B 68 ?? ?2 0? 0? D5 58 D2 E7 D7 E9 24 23 C2 44 C7 F8 20 A0 52 EA 03 0E 16 D0 D7 F8 20 A0 50 46 4F EA EA 7B 59 46 8B 42 08 BF 82 42 60 D0 60 46 ?? ?? ?? ?? ?? ?2 0? 0? 32 46 2B 68 ?? ?2 0? 0? 02 20 ?? ?? ?? ?? C0 E7 ?? ?2 0? 0? C7 F8 18 D0 ?? ?2 0? 0? 59 46 DA F8 00 30 D8 1D 1A 46 20 F0 07 00 7B 60 AD EB 00 0D 0D F1 08 0E C7 F8 1C E0 70 46 ?? ?? ?? ?? 7B 68 38 6A 5A 46 D7 F8 08 C0 59 42 01 40 60 46 ?? ?? ?? ?? D7 F8 08 C0 01 30 00 F0 1F 81 2B 46 C7 F8 14 90 C7 F8 10 80 55 46 FC 60 E1 46 DF F8 18 B1 9A 46 D7 F8 20 80 FC 69 07 E0 5B 46 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 6D D1 2B 68 48 46 21 46 5A 1E 08 EA 02 02 ?? ?? ?? ?? 43 1C ED D0 00 28 CC 46 D7 F8 10 80 55 46 D7 F8 14 90 FC 68 C0 F2 F4 80 D7 F8 18 A0 D5 46 CD F8 00 C0 4F F0 00 0A CD F8 04 A0 50 46 C7 F8 08 C0 03 22 39 6A 01 23 ?? ?? ?? ?? D7 F8 08 C0 B0 F1 FF 3F 83 46 3B D0 60 46 0B F1 38 0E C7 F8 1C E0 ?? ?? ?? ?? D7 F8 1C C0 08 F1 04 00 D7 E9 24 23 84 44 B8 61 0C F1 04 01 A1 61 52 EA 03 01 C4 F8 14 C0 3D D0 07 F1 2C 01 58 46 14 22 C7 F8 08 C0 ?? ?? ?? ?? 50 BB DB F8 14 30 6B B9 07 F1 40 01 0B F1 18 00 20 22 ?? ?? ?? ?? D7 F8 08 C0 18 B9 5C F8 04 3C 01 2B 4D D0 58 46 39 6A ?? ?? ?? ?? 57 E7 00 22 4F F0 FF 31 10 46 0D 46 58 E6 ?? ?2 0? 0? 1D EE 70 2F ?? ?2 0? 0? 01 E7 CC 46 BB 69 ?? ?2 0? 0? ?? ?2 0? 0? 9D 46 F9 E6 BB F1 00 0F E2 D1 3E E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 F1 2C 05 07 F1 40 06 0B F1 18 0E CB F8 14 A0 0F CD 4F F0 01 0A CB F8 00 00 28 68 CB F8 04 10 CB F8 08 20 CB F8 10 00 CB F8 0C 30 0F CE CB F8 18 00 CE F8 04 10 CE F8 08 20 CE F8 0C 30 0F CE CE F8 10 00 CE F8 14 10 CE F8 18 20 CE F8 1C 30 4C F8 04 AC 78 6A 01 21 C7 F8 08 C0 40 44 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? D7 F8 08 C0 E0 61 00 28 62 D0 D7 F8 1C A0 00 21 BE 69 00 EB 08 05 13 69 51 62 5A F8 06 10 15 62 99 42 38 BF 5A F8 06 30 A3 62 DB B1 03 EB 43 03 0C EB 83 03 53 F8 04 1C A3 F1 08 0B 62 6A 0C 3B 63 45 4F EA 91 01 02 F1 01 06 66 62 05 EB C2 0E 30 F8 11 A0 96 B2 45 F8 32 B0 AE F8 04 A0 20 F8 11 60 E7 D1 65 68 C5 EB 09 09 C8 45 28 BF 4F F4 80 33 10 D2 41 46 48 46 ?? ?? ?? ?? B0 F5 80 3F 01 46 28 BF 01 23 06 D2 FF 28 0F D9 4F F4 80 30 ?? ?? ?? ?? 03 46 F8 69 41 46 2A 46 ?? ?? ?? ?? 01 23 23 60 7B E6 1D EE 70 2F 63 E7 B9 F1 80 7F 2B BF 4F EA 18 21 41 46 48 46 4F EA 09 20 ?? ?? ?? ?? 01 46 4F F0 80 70 ?? ?? ?? ?? 03 46 E2 E7 39 6A 58 46 ?? ?? ?? ?? ?? ?2 0? 0? 02 20 ?? ?2 0? 0? ?? ?? ?? ?? 7F 20 ?? ?? ?? ?? 4F EA C6 0A 26 61 0A EB 06 16 C7 F8 24 A0 4F EA 86 0A 0A F1 40 0A B4 E5 }
	condition:
		$1
}

rule file_492_1_0 {
	meta:
		name = "_dl_mcount"
		size = 628
		refs = "0000 .LANCHOR0"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 2D E9 F0 0F 94 B0 1A 68 00 2A 00 F0 01 81 5C 68 9A 68 09 1B 00 1B 90 42 28 BF 00 20 8A 42 01 91 40 F2 F6 80 01 9C D9 68 DA 69 24 FA 01 F1 32 F8 11 50 02 EB 41 02 02 92 AD B2 00 2D 40 F0 EC 80 ?? ?2 0? 0? 01 26 ?? ?2 0? 0? 03 90 07 F1 24 0B 07 F1 28 0A 4B E0 39 69 8A 42 4D D2 02 EB 42 02 B9 69 05 96 01 EB 82 01 48 68 80 08 5A 6A 04 92 04 9A 06 92 06 99 04 9A 05 9C BF F3 5F 8F 14 44 5B E8 00 2F 8A 42 03 D1 4B E8 00 45 00 2D F7 D1 BF F3 5F 8F 07 92 07 99 06 9A 91 42 E6 D1 9D 6A DC 69 04 99 2A 46 05 EB 45 09 1D 6A 34 F8 10 80 01 31 9C 69 05 EB C1 0C 04 EB 89 05 1C 6A 44 F8 31 50 89 B2 DD 69 AC F8 04 80 25 F8 10 10 50 1C BF F3 5F 8F 5A E8 00 1F 91 42 03 D1 4A E8 00 04 00 2C F7 D1 91 42 BF F3 5F 8F 40 F0 B9 80 5C 69 9A 6A 21 68 91 42 AE D1 02 9D 03 98 2A 88 92 B2 00 2A 40 F0 A6 80 01 22 09 92 22 68 08 92 08 9A 0A 92 0A 99 08 9A 09 9D BF F3 5F 8F 15 44 54 E8 00 2F 8A 42 03 D1 44 E8 00 56 00 2E F7 D1 BF F3 5F 8F 0B 92 0B 99 0A 9A 91 42 E6 D1 08 9A 19 69 8A 42 65 D2 47 49 01 24 0D 94 5C 6A 0C 94 0C 9C 0E 94 0E 9D 0C 9C 0D 9E BF F3 5F 8F 26 44 51 E8 00 4F AC 42 03 D1 41 E8 00 67 00 2F F7 D1 BF F3 5F 8F 0F 94 0F 9D 0E 9C A5 42 E6 D1 0C 9C 02 EB 42 02 02 9D 00 26 01 34 9F 69 19 6A 92 00 A4 B2 2C 80 2C 88 BD 18 DF F8 D0 C0 A4 B2 41 F8 34 50 01 EB C4 08 B8 50 01 9F AE 60 6F 60 A8 F8 04 60 9A 6A BF F3 5F 8F 55 1C 5C E8 00 0F 90 42 03 D1 4C E8 00 56 00 2E F7 D1 82 42 BF F3 5F 8F EF D1 51 F8 34 20 02 F1 08 03 01 21 11 91 91 68 10 91 10 99 12 91 12 98 10 99 11 9C BF F3 5F 8F 0C 44 53 E8 00 1F 81 42 03 D1 43 E8 00 45 00 2D F7 D1 BF F3 5F 8F 13 91 13 98 12 99 88 42 E6 D1 10 9B 14 B0 BD E8 F0 0F 70 47 1A 6A 02 EB C5 05 2A 68 11 68 81 42 D6 D0 A9 88 69 B1 1E 6A 05 E0 56 F8 31 20 21 46 14 68 84 42 05 D0 06 EB C1 05 AC 88 00 2C F4 D1 2A 68 11 68 81 42 C3 D0 04 35 02 95 F6 E6 02 9F 1A 6A 3D 88 AD B2 02 EB C5 05 DE E7 9A 6A 34 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_493_2_0 {
	meta:
		name = "xdrmem_setpos"
		size = 42
	strings:
		$1 = { 10 B4 03 69 C4 68 42 69 19 44 22 44 91 42 08 D8 8B 42 06 D8 52 1A C1 60 42 61 01 20 5D F8 04 4B 70 47 00 20 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_493_3_0 {
	meta:
		name = "xdrmem_inline"
		size = 26
	strings:
		$1 = { 42 69 03 46 8A 42 25 BF C1 EB 02 02 C0 68 00 20 5A 61 24 BF 09 18 D9 60 70 47 }
	condition:
		$1
}

rule file_493_4_0 {
	meta:
		name = "xdrmem_putint32"
		size = 38
	strings:
		$1 = { 42 69 03 46 10 B4 03 2A 98 BF 00 20 08 D9 DC 68 04 3A 01 20 5A 61 0A 68 12 BA 44 F8 04 2B DC 60 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_493_5_0 {
	meta:
		name = "xdrmem_getint32"
		size = 38
		altNames = "xdrmem_getlong"
	strings:
		$1 = { 42 69 03 46 10 B4 03 2A 98 BF 00 20 08 D9 DC 68 04 3A 5A 61 01 20 54 F8 04 2B 12 BA 0A 60 DC 60 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_493_6_0 {
	meta:
		name = "xdrmem_putlong"
		size = 36
	strings:
		$1 = { 42 69 03 46 30 B4 03 2A 98 BF 00 20 08 D9 DC 68 15 1F 01 20 0A 68 5D 61 12 BA 44 F8 04 2B DC 60 30 BC 70 47 }
	condition:
		$1
}

rule file_493_8_0 {
	meta:
		name = "xdrmem_putbytes"
		size = 36
		refs = "0016 memcpy"
	strings:
		$1 = { 38 B5 04 46 43 69 15 46 93 42 01 D2 00 20 38 BD 9B 1A C0 68 63 61 ?? ?? ?? ?? E3 68 01 20 1D 44 E5 60 38 BD }
	condition:
		$1
}

rule file_493_9_0 {
	meta:
		name = "xdrmem_getbytes"
		size = 38
		refs = "0018 memcpy"
	strings:
		$1 = { 38 B5 04 46 43 69 15 46 93 42 01 D2 00 20 38 BD 9B 1A 08 46 63 61 E1 68 ?? ?? ?? ?? E3 68 01 20 1D 44 E5 60 38 BD }
	condition:
		$1
}

rule file_493_10_0 {
	meta:
		name = "xdrmem_create"
		size = 26
		refs = "0002 .LANCHOR0"
	strings:
		$1 = { 10 B4 ?? ?2 0? 0? ?? ?2 0? 0? 03 60 44 60 42 61 01 61 C1 60 5D F8 04 4B 70 47 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "__libc_ifunc_impl_list"
		size = 118
		refs = "0000 _dl_hwcap 000e .LC2 001a strcmp 0022 .LANCHOR0 002e .LC3 0032 __memcpy_neon 0036 .LC4 003e __memcpy_vfp"
	strings:
		$1 = { ?? ?2 0? 0? 2D E9 F0 41 ?? ?2 0? 0? 0C 46 ?? ?2 0? 0? ?? ?2 0? 0? D3 F8 00 80 ?? ?? ?? ?? 00 23 30 BB ?? ?2 0? 0? 04 F1 18 05 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 93 E8 07 00 ?? ?2 0? 0? ?? ?2 0? 0? 23 61 03 23 ?? ?2 0? 0? ?? ?2 0? 0? E6 60 ?? ?2 0? 0? C8 F3 00 36 C4 F8 00 C0 C8 F3 80 18 67 60 26 72 84 F8 14 80 85 E8 07 00 18 46 BD E8 F0 81 }
	condition:
		$1
}

rule file_496_0_0 {
	meta:
		name = "__mpn_mul_1"
		size = 42
	strings:
		$1 = { F0 B4 00 26 07 46 92 00 30 46 8C 59 A4 FB 03 45 04 19 BC 51 06 F1 04 06 34 BF 00 24 01 24 B2 42 04 EB 05 00 F1 D1 F0 BC 70 47 }
	condition:
		$1
}

rule file_497_0_0 {
	meta:
		name = "__ttyname_r"
		size = 548
		refs = "004e __tcgetattr 005e __fxstat64 0068 .LC3 008c _fitoa_word 009c __readlink 00bc .LC4 00da __xstat64 0104 getttyname_r 0174 .LC5 0180 memcmp 0192 memmove 0204 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4D D0 B0 7F 4C 00 25 1D EE 70 BF 04 95 7C 44 24 68 88 46 92 46 5B F8 04 70 04 46 59 B1 09 2A 13 D8 78 4B 22 22 10 46 7B 44 1B 68 4B F8 03 20 50 B0 BD E8 F0 8D 74 4B 16 22 10 46 7B 44 1B 68 4B F8 03 20 50 B0 BD E8 F0 8D 0D A9 ?? ?? ?? ?? 00 28 C0 F2 CF 80 03 20 21 46 1C AA ?? ?? ?? ?? 00 28 C0 F2 98 80 ?? ?2 0? 0? 05 AE ?? ?2 0? 0? 0F CB 4F EA 13 4E 07 C6 20 46 26 F8 02 3B 0D F1 22 01 0A 22 2B 46 86 F8 00 E0 ?? ?? ?? ?? 41 46 0A F1 FF 32 03 46 05 A8 1D 70 ?? ?? ?? ?? 43 1C 04 46 00 F0 97 80 0D 28 63 D8 00 23 08 F8 04 30 98 F8 00 30 2F 2B 74 D0 36 AC ?? ?2 0? 0? 22 46 ?? ?2 0? 0? 03 CB 1B 88 C8 F8 00 00 03 20 C8 F8 04 10 41 46 A8 F8 08 30 ?? ?? ?? ?? B0 B9 3A 9B 03 F4 70 43 B3 F5 80 4F 10 D1 DD E9 34 45 04 AE 40 46 DD E9 24 23 AA F1 09 01 02 97 03 96 CD E9 00 45 ?? ?? ?? ?? 38 B9 00 20 91 E7 40 4B 02 20 7B 44 1B 68 4B F8 03 70 04 9B 01 33 88 D0 DD E9 34 45 AA F1 05 0A 04 A8 00 26 DD E9 24 23 51 46 88 F8 05 60 03 90 40 46 02 97 CD E9 00 45 ?? ?? ?? ?? 00 28 E0 D0 04 9B 01 33 3F F4 71 AF DD E9 34 45 40 46 88 F8 05 60 51 46 02 97 04 AF DD E9 24 23 01 26 03 97 CD E9 00 45 04 96 ?? ?? ?? ?? 5E E7 ?? ?2 0? 0? 40 46 ?? ?2 0? 0? 0D 22 ?? ?? ?? ?? 00 28 91 D1 0D 3C 40 46 22 46 08 F1 0D 01 ?? ?? ?? ?? 89 E7 1E 4B 7B 44 1B 68 5B F8 03 00 46 E7 36 AC 03 20 22 46 41 46 ?? ?? ?? ?? 00 28 83 D1 3A 9B 03 F4 70 43 B3 F5 00 5F 7F F4 7D AF DD E9 3E 01 DD E9 24 23 99 42 08 BF 90 42 7F F4 74 AF 99 E7 10 4B 7B 44 1B 68 5B F8 03 30 24 2B 7F F4 6A AF 0D 4B 22 22 10 46 7B 44 1B 68 4B F8 03 20 1D E7 0A 4B 7B 44 1B 68 5B F8 03 00 17 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_497_1_0 {
	meta:
		name = "getttyname_r"
		size = 336
		refs = "000e strlen 001c __opendir 002e __readdir64 0032 .LC0 0058 strcmp 005c .LC1 006e .LC2 0096 __stpncpy 00a8 __xstat64 00d0 __closedir 0140 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 9F B0 80 46 89 46 CD E9 02 23 ?? ?? ?? ?? DD E9 28 45 2B 9F 82 46 40 46 ?? ?? ?? ?? 06 46 00 28 6E D0 C2 44 CD F8 04 A0 30 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 03 46 00 F1 13 0B 58 46 00 2B 4E D0 D3 E9 00 23 AB 42 08 BF A2 42 02 D0 3B 68 00 2B E9 D0 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 28 E1 D0 58 46 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 00 28 D8 D0 58 46 ?? ?? ?? ?? 00 28 D3 D0 58 46 ?? ?? ?? ?? 59 46 43 1C 01 98 4B 45 1A 46 44 D8 ?? ?? ?? ?? 4F F0 00 02 41 46 03 46 03 20 1A 70 04 AA ?? ?? ?? ?? 00 28 BD D1 08 9B 03 F4 70 43 B3 F5 00 5F B7 D1 DD E9 0C AB DD E9 02 23 9B 45 08 BF 92 45 AF D1 83 46 30 46 ?? ?? ?? ?? 1A 4B 2A 99 1D EE 70 2F 7B 44 1B 68 D1 50 0B E0 30 46 4F F0 19 0B ?? ?? ?? ?? 15 4B 2A 99 1D EE 70 2F 7B 44 1B 68 D1 50 58 46 1F B0 BD E8 F0 8F 10 4B 4F F0 FF 31 1D EE 70 2F 39 60 7B 44 1B 68 52 F8 03 B0 58 46 1F B0 BD E8 F0 8F 4F F0 FF 33 30 46 3B 60 ?? ?? ?? ?? 07 4B 1D EE 70 1F 22 22 7B 44 1B 68 93 46 CA 50 DE E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_498_0_0 {
	meta:
		name = "__register_printf_specifier"
		size = 248
		refs = "0006 .LANCHOR0 0036 __printf_function_table 003a .LANCHOR1 009e calloc 00da __libc_do_syscall 00ec __lll_lock_wait_private 00f4 __libc_errno"
	strings:
		$1 = { FF 28 F0 B5 98 BF ?? ?2 0? 0? 0F 46 83 B0 05 46 9E BF 01 21 ?? ?2 0? 0? BF F3 5F 8F 31 D8 54 E8 00 3F 00 2B 03 D1 44 E8 00 10 00 28 F7 D1 BF F3 5F 8F 00 2B 55 D1 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 30 68 28 B3 40 F8 25 70 00 26 1B 68 43 F8 25 20 00 22 23 68 BF F3 5F 8F 54 E8 00 1F 99 42 03 D1 44 E8 00 20 00 28 F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B D8 BF 30 46 1F DC 03 B0 F0 BD 1C 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 4F F4 80 70 08 21 01 92 ?? ?? ?? ?? ?? ?2 0? 0? 01 9A ?? ?2 0? 0? 18 60 18 B1 00 F5 80 60 30 60 C8 E7 4F F0 FF 36 CB E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? 30 46 CD E7 ?? ?2 0? 0? 01 92 ?? ?2 0? 0? ?? ?? ?? ?? 01 9A A0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_500_0_0 {
	meta:
		name = "strcoll"
		size = 20
		refs = "0010 __libc_tsd_LOCALE 000c __strcoll_l"
	strings:
		$1 = { 03 4B 1D EE 70 2F 7B 44 1B 68 D2 58 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1141_0_0 {
	meta:
		name = "wcscoll"
		size = 20
		refs = "0010 __libc_tsd_LOCALE 000c __wcscoll_l"
	strings:
		$1 = { 03 4B 1D EE 70 2F 7B 44 1B 68 D2 58 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_501_0_0 {
	meta:
		name = "_IO_fwrite"
		size = 332
		refs = "00c0 __aeabi_uidiv 00d4 __lll_lock_wait_private 00ee __libc_do_syscall 0148 _Unwind_Resume"
	strings:
		$1 = { 2D E9 F8 43 0E 46 02 FB 01 F5 17 46 80 46 1C 46 00 2D 59 D0 1B 68 19 04 1D D4 A0 6C 1D EE 70 9F A9 F5 98 69 82 68 4A 45 12 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 00 2A 45 D1 A2 6C 10 46 C2 F8 08 90 42 68 01 32 42 60 E3 6E 5B B9 4F F0 FF 33 E3 66 D4 F8 98 30 41 46 20 46 2A 46 DB 69 98 47 80 46 04 E0 01 33 18 BF 4F F0 00 08 F1 D0 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 13 DC A8 45 0B D0 B8 F1 FF 3F 05 D0 40 46 31 46 ?? ?? ?? ?? BD E8 F8 83 00 20 BD E8 F8 83 38 46 BD E8 F8 83 ?? ?? ?? ?? B6 E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? DE E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_504_0_0 {
	meta:
		name = "_IO_wstrn_overflow"
		size = 56
		refs = "001e _IO_wsetb"
	strings:
		$1 = { C3 6D 2D E9 F0 41 00 F1 A8 04 9A 69 05 46 88 46 A2 42 0C D0 00 F5 D4 77 00 23 21 46 3A 46 ?? ?? ?? ?? EE 6D 33 46 77 60 F4 60 B4 60 34 60 1C 61 40 46 5C 61 BD E8 F0 81 }
	condition:
		$1
}

rule file_504_1_0 {
	meta:
		name = "_IO_vswprintf"
		size = 106
		refs = "0016 .LANCHOR0 002a _IO_no_init 0032 _IO_fwide 0040 _IO_wstr_init_static 004a _IO_vfwprintf"
	strings:
		$1 = { 2D E9 F0 43 AD F5 1D 7D 00 24 0E 46 07 46 91 46 98 46 44 94 31 B3 ?? ?2 0? 0? 22 46 03 AB 32 A8 4F F4 00 41 ?? ?2 0? 0? 00 95 ?? ?? ?? ?? 01 21 32 A8 ?? ?? ?? ?? 3B 46 39 46 72 1E 32 A8 3C 60 ?? ?? ?? ?? 49 46 42 46 32 A8 ?? ?? ?? ?? 49 9B 5C A9 9A 69 8A 42 05 D0 1B 69 1C 60 0D F5 1D 7D BD E8 F0 83 4F F0 FF 30 F8 E7 }
	condition:
		$1
}

rule file_506_0_0 {
	meta:
		name = "__atomic_preadv_replacement"
		size = 256
		refs = "0060 __pread 0094 memcpy 00a0 free 00d0 __libc_alloca_cutoff 00e2 malloc 00fc __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F B2 F1 00 08 85 B0 82 46 89 46 00 AF 72 DD 4E 68 B6 F1 00 4F 3E BF 00 25 8C 46 2A 46 04 D3 44 E0 DC F8 04 60 B4 42 40 D3 01 35 4F F6 FF 74 45 45 C7 F6 FF 74 32 44 0C F1 08 0C C2 EB 04 04 EF D1 B2 F5 80 5F 3F D8 02 F1 0E 01 00 20 21 F0 07 01 F8 60 AD EB 01 0D 6E 46 50 46 31 46 ?? ?? ?? ?? B0 F1 00 0B 43 DB B8 F1 00 0F DA 46 15 DD 00 25 01 E0 45 45 11 D0 D9 F8 04 40 31 46 D9 F8 00 00 01 35 A2 45 38 BF 54 46 09 F1 08 09 22 46 26 44 ?? ?? ?? ?? BA EB 04 0A EB D1 F8 68 ?? ?? ?? ?? 58 46 14 37 BD 46 BD E8 F0 8F 13 4B 1D EE 70 2F 4F F0 FF 3B 16 21 7B 44 1B 68 58 46 14 37 D1 50 BD 46 BD E8 F0 8F 10 46 BA 60 7B 60 ?? ?? ?? ?? BA 68 7B 68 00 28 B6 D1 10 46 BA 60 7B 60 ?? ?? ?? ?? BA 68 7B 68 06 46 F8 60 00 28 B4 D1 4F F0 FF 3B D2 E7 00 22 A6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_506_1_0 {
	meta:
		name = "preadv"
		size = 180
		refs = "0004 __libc_multiple_threads 0020 __libc_do_syscall 0054 __libc_enable_asynccancel 0078 __libc_disable_asynccancel 00a8 __libc_errno"
	strings:
		$1 = { 2D E9 F0 47 ?? ?2 0? 0? ?? ?2 0? 0? 81 46 88 46 17 46 24 68 1E 46 EC B9 DD 17 40 F2 69 1C 2C 46 ?? ?? ?? ?? 10 F5 80 5F 29 D8 04 46 00 2C 02 DB 20 46 BD E8 F0 87 1C 4B 1D EE 70 2F 7B 44 1B 68 D3 58 26 2B F4 D1 48 46 41 46 3A 46 33 46 BD E8 F0 47 55 E7 ?? ?? ?? ?? F5 17 41 46 3A 46 33 46 40 F2 69 1C 2C 46 82 46 48 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 0D D8 50 46 ?? ?? ?? ?? D6 E7 0B 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 CB E7 07 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E7 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_507_0_0 {
	meta:
		name = "setgroups"
		size = 72
		refs = "0000 __nptl_setxid 0026 __libc_do_syscall 0044 __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 10 B5 04 46 86 B0 43 B1 01 A8 CE 23 02 94 03 91 01 93 ?? ?? ?? ?? 06 B0 10 BD 4F F0 CE 0C ?? ?? ?? ?? 10 F5 80 5F F6 D9 04 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 EC E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_509_0_0 {
	meta:
		name = "__getwc_unlocked"
		size = 24
		refs = "0014 __wuflow"
	strings:
		$1 = { C3 6D 3B B1 1A 68 59 68 8A 42 03 D2 11 1D 10 68 19 60 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_510_0_0 {
	meta:
		name = "__mbsrtowcs_chk"
		size = 20
		refs = "0010 __chk_fail 000c __mbsrtowcs"
	strings:
		$1 = { 10 B5 02 9C 94 42 03 D3 BD E8 10 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_0_0 {
	meta:
		name = "__wcsrtombs_chk"
		size = 20
		refs = "0010 __chk_fail 000c __wcsrtombs"
	strings:
		$1 = { 10 B5 02 9C 94 42 03 D3 BD E8 10 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_511_0_0 {
	meta:
		name = "__wcsxfrm_l"
		size = 1506
		refs = "0012 __wcslen 00d8 __collidx_table_lookup 014a __wcpncpy 053c free 0542 .LC0 0546 .LC1 054a __PRETTY_FUNCTION__.10424 055c __assert_fail 0560 .LC4 057e .LC3 059c .LC2 05bc __libc_alloca_cutoff 05ca malloc"
	strings:
		$1 = { 2D E9 F0 4F 8F B0 00 AF 92 46 89 46 F8 60 08 46 DE 68 ?? ?? ?? ?? 72 6A FA 62 05 46 3A B9 BA F1 00 0F 40 F0 8C 80 3C 37 BD 46 BD E8 F0 8F B3 6C B2 6A F4 6C 7B 63 7A 61 7A 6B 33 6D 76 6D 92 07 BB 62 3E 62 40 F0 7D 82 A3 07 40 F0 A7 82 BB 6A 9E 07 40 F0 94 82 3A 6A 90 07 40 F0 81 82 00 2D 61 D0 6E 1C 06 EB 86 08 B8 F5 80 5F 00 F2 A5 82 AD 00 05 F1 0E 02 06 F1 0E 03 22 F0 07 02 23 F0 07 03 AD EB 02 0D 00 22 C7 F8 24 D0 AD EB 03 0D 7A 60 C7 F8 1C D0 7A 6A 00 23 C7 F8 08 A0 9A 46 04 3A D9 F8 00 10 3A 63 3B 61 BC 61 11 E0 39 6B 1A 16 F8 69 23 F0 7F 43 00 F8 0A 20 0A F1 01 02 41 F8 04 3F 39 63 D8 F8 00 10 00 29 77 D0 C1 46 92 46 78 6B 09 F1 04 08 ?? ?? ?? ?? 00 28 A8 BF 03 46 E4 DA BA 6A A2 EB 80 03 1E 46 5A 68 56 F8 08 CB BC F1 00 0F 32 DB 8A B1 99 68 D9 F8 04 30 99 42 29 D1 30 46 41 46 00 23 05 E0 50 F8 04 5F 51 F8 04 4F A5 42 1F D1 01 33 9A 42 F6 D1 08 EB 82 08 63 46 C3 E7 50 46 BA F1 00 0F 3F F4 7B AF FB 68 28 46 3C 37 1D 60 BD 46 BD E8 F0 8F 6A 1C F8 68 49 46 52 45 28 BF 52 46 ?? ?? ?? ?? 28 46 3C 37 BD 46 BD E8 F0 8F 06 EB 82 03 C5 E7 55 1E 12 D0 99 68 D9 F8 04 30 99 42 25 D1 30 46 41 46 00 23 AB 46 05 E0 50 F8 04 5F 51 F8 04 4F A5 42 1A D1 01 33 5B 45 F6 D1 02 F1 80 43 01 3B 56 F8 23 00 58 F8 23 10 88 42 0E DC 06 EB C2 03 53 F8 04 4C A1 42 A1 DC 09 1A 08 EB 82 08 3A 6A CC EB 01 0C 52 F8 2C 30 7A E7 06 EB C2 03 95 E7 C7 F8 10 A0 01 20 3B 69 BA 62 7A 6A D7 F8 08 A0 02 EB 83 02 D7 F8 0C 80 BA 60 FB 69 BA 6A BC 69 38 62 B9 61 99 54 FA 69 38 6A 79 69 13 78 42 1E 11 44 FA 6A 39 63 02 FB 03 F3 CA 5C 02 F0 04 03 03 F0 FF 09 00 2B 40 F0 BD 80 FB 69 4F F0 FF 3B D7 F8 24 C0 7B 63 BB 69 D1 07 30 D5 BB F1 FF 3F 00 F0 87 80 CB 45 80 F0 84 80 7A 6A 02 EB 8B 0B 62 46 52 F8 04 5C 69 1C 42 F8 04 1C 54 F8 25 00 C6 18 B2 45 9C BF 09 18 42 F8 04 1C 12 D9 00 28 00 F0 96 80 08 EB 83 03 08 EB 86 00 01 E0 52 F8 04 1C 4D 1C 42 F8 04 5C 54 F8 21 10 43 F8 04 1B 83 42 F4 D1 04 3A 5A 45 5C D0 33 46 D9 E7 BB F1 FF 3F 08 BF CB 46 78 6B 09 F1 01 09 F9 6A 0C F1 04 0C 10 F8 01 2F 01 FB 02 F2 B9 6A 78 63 38 6B 89 45 82 5C B8 D3 BB F1 FF 3F 2C D0 D9 45 2A D9 7A 6A 02 EB 89 09 02 EB 8B 0B 59 F8 04 0C 1A 46 41 1C 49 F8 04 1C 54 F8 20 00 03 44 9A 45 9C BF 09 18 49 F8 04 1C 12 D9 00 28 00 F0 0A 81 08 EB 82 02 08 EB 83 05 01 E0 59 F8 04 1C 48 1C 49 F8 04 0C 54 F8 21 10 42 F8 04 1B AA 42 F4 D1 A9 F1 04 09 D9 45 D9 D1 53 45 80 F0 F1 80 39 6A F8 6A 88 42 94 BF 00 22 01 22 48 F8 23 20 0A 46 5D 1C 3B 6A 01 33 3B 62 FB 6A 93 42 40 F2 ED 80 BD 61 59 E7 1E 46 DC F8 00 30 5A 1C CC F8 00 20 54 F8 23 10 73 18 9A 45 15 D9 00 29 00 F0 D9 80 08 EB 86 06 08 EB 83 00 01 E0 DC F8 00 20 51 1C CC F8 00 10 54 F8 22 20 46 F8 04 2B 86 42 F4 D1 4F F0 FF 3B 88 E7 0A 44 4F F0 FF 3B CC F8 00 20 82 E7 1E 46 77 E7 FB 69 4F F0 01 0B 4F F0 00 09 7E 6A 5D 46 4F F0 FF 3C 7B 63 D3 46 BB 69 C2 46 C8 46 D2 07 40 F1 98 80 BC F1 FF 3F 2D D0 E0 45 2B D9 7A 6A 02 EB 8C 09 32 46 52 F8 04 1C 48 1C 42 F8 04 0C 54 F8 21 10 00 29 00 F0 83 80 03 F1 01 0C 8C 44 E3 45 10 D9 0A EB 83 00 4A F8 23 50 00 23 52 F8 04 5C 1D 44 01 33 8B 42 54 F8 25 50 40 F8 04 5F F5 D1 52 F8 04 0C 63 46 01 25 01 44 42 F8 04 1C 04 3A 4A 45 D7 D1 32 68 51 1C 31 60 54 F8 22 20 00 2A 67 D0 50 1C 18 44 83 45 0E D9 4A F8 23 50 0A EB 83 01 00 25 33 68 2B 44 01 35 95 42 54 F8 23 30 41 F8 04 3F F6 D1 31 68 03 46 01 25 4F F0 FF 3C 0A 44 32 60 78 6B 08 F1 01 08 F9 6A 04 36 10 F8 01 2F 01 FB 02 F2 B9 6A 78 63 38 6B 88 45 82 5C 9C D3 BC F1 FF 3F D0 46 DA 46 AB 46 3F F4 49 AF 3A 69 94 45 BF F4 45 AF 7A 6A 02 EB 8C 0C BA 68 52 F8 04 0C 45 1C 42 F8 04 5C 54 F8 20 10 29 B3 5E 1C 0E 44 B2 45 10 D9 08 EB 83 00 48 F8 23 B0 00 23 52 F8 04 5C 1D 44 01 33 8B 42 54 F8 25 50 40 F8 04 5F F5 D1 52 F8 04 5C 33 46 4F F0 01 0B 29 44 42 F8 04 1C 04 3A 62 45 D9 D1 19 E7 01 35 95 E7 BC F1 FF 3F 08 BF C4 46 B3 E7 0B F1 01 0B F1 E7 01 35 4F F0 FF 3C AC E7 3A 6A 15 E7 A9 F1 04 09 13 46 D9 45 7F F4 DE AE 02 E7 33 46 4F F0 FF 3B BE E6 02 2D 10 D9 B8 69 43 1C 9D 42 0C D1 82 45 21 BF 00 F1 80 43 05 46 F9 68 03 F1 FF 33 32 BF BD 69 00 22 41 F8 23 20 7A 68 22 B9 68 1E 3C 37 BD 46 BD E8 F0 8F 78 6A ?? ?? ?? ?? F6 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 86 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 89 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 88 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 87 22 ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 00 28 7F F4 55 AD 40 46 AD 00 ?? ?? ?? ?? 78 62 28 44 7B 6A F8 61 00 2B 3F F4 4B AD 01 22 7A 60 59 E5 }
	condition:
		$1
}

rule file_512_0_0 {
	meta:
		name = "xdr_authdes_cred"
		size = 92
		refs = "0006 xdr_enum 001c xdr_opaque 002e xdr_string"
	strings:
		$1 = { 38 B5 05 46 0C 46 ?? ?? ?? ?? 98 B1 23 68 5B B1 01 2B 0F D1 28 46 04 F1 14 01 04 22 ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD 28 46 21 1D FF 22 ?? ?? ?? ?? 08 B9 00 20 38 BD 28 46 04 F1 08 01 08 22 ?? ?? ?? ?? 00 28 F5 D0 28 46 04 F1 10 01 04 22 ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_512_1_0 {
	meta:
		name = "xdr_authdes_verf"
		size = 34
		refs = "0008 xdr_opaque"
	strings:
		$1 = { 38 B5 08 22 05 46 0C 46 ?? ?? ?? ?? 40 B1 28 46 04 F1 08 01 04 22 ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_513_0_0 {
	meta:
		name = "__strncasecmp"
		size = 80
		refs = "004c __libc_tsd_LOCALE"
	strings:
		$1 = { 12 4B 00 2A 18 BF 88 42 F0 B4 1D EE 70 4F 7B 44 1B 68 08 BF 00 20 E3 58 10 D0 9F 6B 46 1E 02 E0 75 B1 01 3A 0F D0 16 F8 01 5F 11 F8 01 0B 57 F8 25 30 57 F8 20 40 1B 1B F2 D0 18 46 F0 BC 70 47 28 46 F0 BC 70 47 10 46 F0 BC 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_514_0_0 {
	meta:
		name = "find_module_idx"
		size = 140
		refs = "0004 .LANCHOR0 0022 __hash_string 002e __aeabi_uidivmod 005a strcmp"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 83 B0 80 46 DB F8 00 50 01 91 B5 F8 06 90 AF 88 A9 44 CD F8 00 90 ?? ?? ?? ?? 2E 89 2F 44 31 46 81 46 ?? ?? ?? ?? 48 46 0C 46 B1 1E ?? ?? ?? ?? DB F8 04 20 AB 88 C3 EB 02 09 01 F1 01 0B 4F EA 8B 0A 00 9B 03 EB 84 05 07 E0 99 45 02 D9 ?? ?? ?? ?? 78 B1 A6 42 55 44 0A D9 2B 88 40 46 5C 44 F9 18 00 2B F1 D1 4F F0 FF 30 03 B0 BD E8 F0 8F A4 1B E6 E7 6B 88 01 9A 13 60 03 B0 BD E8 F0 8F }
	condition:
		$1
}

rule file_514_1_0 {
	meta:
		name = "find_module"
		size = 114
		refs = "000c strlen 002e mempcpy 0036 memcpy 003c __gconv_find_shlib 005c _dl_mcount_wrapper_check"
	strings:
		$1 = { 2D E9 F0 41 00 AF 0D 46 14 46 06 46 ?? ?? ?? ?? 80 46 28 46 ?? ?? ?? ?? 31 46 42 46 46 1C B0 44 08 F1 07 08 28 F0 07 08 AD EB 08 0D 68 46 ?? ?? ?? ?? 29 46 32 46 ?? ?? ?? ?? 68 46 ?? ?? ?? ?? 20 60 90 B1 C1 68 00 23 05 69 42 69 61 61 28 46 E5 61 22 62 63 60 A3 61 A3 63 1D B1 ?? ?? ?? ?? 20 46 A8 47 BD 46 BD E8 F0 81 01 20 BD 46 BD E8 F0 81 }
	condition:
		$1
}

rule file_514_3_0 {
	meta:
		name = "__gconv_load_cache"
		size = 356
		refs = "0000 .LC0 000e getenv 0012 __gconv_path_envvar 0022 .LC1 0030 __libc_do_syscall 0042 __fxstat64 0050 .LANCHOR0 0068 __mmap 00d0 free 0108 __munmap 0126 malloc 0144 __read 0160 __libc_errno"
	strings:
		$1 = { ?? ?2 0? 0? 2D E9 F0 41 ?? ?2 0? 0? 9C B0 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 18 60 00 28 51 D1 01 46 ?? ?2 0? 0? 0A 46 ?? ?2 0? 0? 4F F0 05 0C ?? ?? ?? ?? 10 F5 80 5F 05 46 68 D8 03 20 29 46 02 AA ?? ?? ?? ?? 00 28 46 DB 0E 9E 0F 2E 43 D9 ?? ?2 0? 0? 00 27 ?? ?2 0? 0? 01 22 00 95 31 46 01 97 38 46 13 46 66 60 ?? ?? ?? ?? 20 60 01 30 57 D0 28 46 4F F0 06 0C ?? ?? ?? ?? 20 68 4F F4 49 72 C2 F2 01 02 ?? ?2 0? 0? ?? ?2 0? 0? 01 68 91 42 29 D1 5B 68 82 88 9A 42 25 D2 C2 88 93 42 22 D9 01 89 01 B3 02 EB 81 02 93 42 1C D3 42 89 93 42 19 D9 82 89 93 42 28 BF 00 20 14 D3 1C B0 BD E8 F0 81 4F F0 FF 30 1C B0 BD E8 F0 81 30 68 ?? ?? ?? ?? 00 23 33 60 28 46 4F F0 06 0C ?? ?? ?? ?? 4F F0 FF 30 EA E7 A3 68 ?? ?2 0? 0? ?? ?2 0? 0? 43 B1 ?? ?? ?? ?? 00 23 AB 60 00 23 4F F0 FF 30 23 60 DB E7 69 68 ?? ?? ?? ?? F6 E7 14 4B 1D EE 70 2F 45 42 4F F0 FF 30 7B 44 1B 68 D5 50 CD E7 66 68 30 46 ?? ?? ?? ?? 20 60 00 28 D3 D0 32 46 A0 46 21 68 D2 1B 28 46 ?? ?2 0? 0? 39 44 ?? ?2 0? 0? ?? ?? ?? ?? 07 44 01 30 BF D0 D8 F8 04 30 9F 42 1A 46 ED D3 01 23 B3 60 89 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_514_4_0 {
	meta:
		name = "__gconv_compare_alias_cache"
		size = 82
		refs = "0000 .LANCHOR0 0022 strcmp"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 70 B5 0C 46 1B 68 82 B0 15 46 06 46 D3 B1 69 46 FF F7 BA FE 40 B1 30 46 21 46 ?? ?? ?? ?? 00 23 28 60 18 46 02 B0 70 BD 20 46 01 A9 FF F7 AC FE 03 46 00 28 EF D1 9D E8 06 00 18 46 8A 1A 2A 60 02 B0 70 BD 4F F0 FF 33 EB E7 }
	condition:
		$1
}

rule file_514_5_0 {
	meta:
		name = "__gconv_lookup_cache"
		size = 732
		refs = "0004 .LANCHOR0 00c4 malloc 00e4 .LC2 0198 __gconv_get_builtin_trans 01b4 __gconv_release_step 01bc free"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 8F B0 06 46 90 46 25 68 1F 46 CD B1 08 46 0C A9 B5 F8 04 A0 B5 F8 0A B0 FF F7 8A FE 58 B9 0C 9B 6A 89 03 F1 01 09 63 68 09 EB 49 09 4F EA 89 09 4A 44 9A 42 09 D9 01 26 30 46 0F B0 BD E8 F0 8F 02 26 30 46 0F B0 BD E8 F0 8F 30 46 0D A9 FF F7 6F FE 06 46 00 28 EE D1 0D 99 68 89 4B 1C 62 68 03 EB 43 03 9B 00 18 44 90 42 E4 D8 18 9A AB 44 0C 3B 12 F0 01 0F 0B EB 03 00 0C 9A 05 90 40 F0 9F 80 A9 F1 0C 09 AA 44 0B EB 09 0C 00 2A 6D D0 21 B1 BC F8 0A 00 00 28 40 F0 98 80 BC F8 04 10 00 29 C8 D0 0D 9D 00 2D 65 D1 00 2A C3 D0 78 20 03 92 01 93 CD F8 08 C0 ?? ?? ?? ?? 03 9A 01 9B DD F8 08 C0 04 46 00 28 5A D0 C8 F8 00 00 00 21 39 60 12 B3 BC F8 06 50 ?? ?2 0? 0? 3B F8 09 00 ?? ?2 0? 0? A1 63 01 21 50 44 22 61 E0 60 0A EB 05 00 A1 60 1A F8 05 20 00 2A 4A D0 BC F8 08 10 22 46 01 93 51 44 FF F7 59 FE 01 9B 02 46 00 28 51 D1 0D 9D 3A 68 01 32 3A 60 00 2D 8C D0 3D 68 ?? ?2 0? 0? 05 9A ?? ?2 0? 0? 3B F8 03 C0 01 20 00 23 B2 F8 02 E0 C5 EB 05 12 D4 44 04 EB 82 02 0A EB 0E 08 C2 F8 10 C0 D1 60 90 60 93 63 1A F8 0E 30 BB B1 05 9B 40 46 99 88 51 44 FF F7 2E FE 80 46 F8 B9 3B 68 01 33 3B 60 65 E7 0D 46 00 2D 3F F4 61 AF 00 22 05 98 01 89 00 29 97 D1 5A E7 03 26 59 E7 05 9B 11 46 98 88 50 44 ?? ?? ?? ?? E8 E7 BC F8 08 00 21 46 01 93 50 44 ?? ?? ?? ?? 01 9B B6 E7 15 B1 20 46 ?? ?? ?? ?? 20 46 46 46 ?? ?? ?? ?? 40 E7 20 46 16 46 ?? ?? ?? ?? 3B E7 91 42 7F F4 5E AF 4F F0 FF 36 35 E7 AD 89 24 68 28 44 06 91 01 38 07 92 04 44 04 94 04 98 05 88 68 1E 65 B1 04 9A 06 21 01 FB 00 20 01 FB 05 24 06 99 40 88 81 42 04 D0 02 34 04 94 EE E7 07 9A 4C E7 3C 20 3D 60 01 93 00 FB 05 F0 CD F8 08 C0 ?? ?? ?? ?? 01 9B DD F8 08 C0 07 90 C8 F8 00 00 00 28 AD D0 3B F8 09 50 00 22 04 98 07 9C 55 44 08 96 56 46 0B 97 CA 46 07 46 99 46 06 92 09 90 CD F8 28 C0 06 9B 22 46 78 88 21 46 01 33 06 93 0C 23 B7 F8 04 E0 E5 60 3C 34 03 FB 00 FC 01 23 06 EB 0E 00 3B F8 0C C0 44 F8 34 3C 00 23 06 EB 0C 05 44 F8 04 3C 44 F8 2C 5C 16 F8 0E 30 63 B1 F9 88 31 44 FF F7 9A FD 60 B9 04 9B 06 37 1A 88 06 9B 93 42 D6 DB 08 9E CE E6 F8 88 30 44 ?? ?? ?? ?? F2 E7 DD F8 28 C0 4B 46 07 98 D1 46 01 93 B2 46 CD F8 08 C0 0B 9F 08 9E ?? ?? ?? ?? 0C 9A 01 9B DD F8 08 C0 00 2A 7F F4 E8 AE 0D 9D 4E E7 }
	condition:
		$1
}

rule file_514_7_0 {
	meta:
		name = "free_mem"
		size = 28
		refs = "0000 .LANCHOR0 0012 __munmap 0016 free"
	strings:
		$1 = { ?? ?2 0? 0? ?? ?2 0? 0? 9A 68 18 68 1A B9 20 B1 59 68 ?? ?? ?? ?? ?? ?? ?? ?? 70 47 }
	condition:
		$1
}

rule file_516_0_0 {
	meta:
		name = "___vsnprintf_chk"
		size = 126
		refs = "002a _IO_no_init 0030 _IO_strn_jumps 0050 _IO_str_init_static_internal 005a _IO_vfprintf 007a __chk_fail"
	strings:
		$1 = { 8B 42 2D E9 F0 41 05 46 BC B0 17 46 35 D3 00 23 01 F1 FF 38 14 93 2C AE 51 B3 00 24 02 A8 23 46 00 94 4F F4 00 41 4F F0 FF 32 ?? ?? ?? ?? A7 42 ?? ?2 0? 0? 29 46 ?? ?2 0? 0? 28 93 2C 70 42 46 C8 BF 11 9B 02 A8 C4 BF 43 F0 04 03 11 93 2B 46 ?? ?? ?? ?? 43 9A 02 A8 42 99 ?? ?? ?? ?? 09 9B B3 42 1E BF 00 22 07 9B 1A 70 3C B0 BD E8 F0 81 2C AE 4F F0 3F 08 35 46 CF E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_518_0_0 {
	meta:
		name = "__register_printf_type"
		size = 220
		refs = "0002 .LANCHOR0 002a .LANCHOR1 0036 .LANCHOR2 0082 calloc 00ae __lll_lock_wait_private 00d0 __libc_do_syscall 00d8 __libc_errno"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? 07 46 ?? ?2 0? 0? 01 22 BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 20 00 28 F7 D1 BF F3 5F 8F 00 2B 3D D1 ?? ?2 0? 0? ?? ?2 0? 0? 2B 68 1B B3 ?? ?2 0? 0? ?? ?2 0? 0? 1E 68 B6 F5 80 7F 25 D0 2A 68 06 F1 80 41 08 39 70 1C 18 60 42 F8 21 70 00 21 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 10 00 28 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 1C DC 30 46 F8 BD F8 20 04 21 ?? ?? ?? ?? 28 60 00 28 D4 D1 4F F0 FF 36 E1 E7 11 4B 1D EE 70 2F 1C 21 4F F0 FF 36 7B 44 1B 68 D1 50 D7 E7 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? BA E7 1D EE 70 1F 01 22 A1 F5 98 61 ?? ?2 0? 0? ?? ?2 0? 0? 00 23 89 68 4F F0 F0 0C 11 43 ?? ?? ?? ?? D1 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_520_0_0 {
	meta:
		name = "__run_exit_handlers"
		size = 172
		refs = "0004 __call_tls_dtors 0052 __start___libc_atexit 0056 __stop___libc_atexit 0080 _exit 00a0 free"
	strings:
		$1 = { 2D E9 F8 43 ?? ?2 0? 0? ?? ?2 0? 0? 07 46 88 46 91 46 0B B1 ?? ?? ?? ?? D8 F8 00 60 B6 B1 73 68 06 EB 03 14 73 B1 54 F8 08 5C 01 3B A4 F1 08 02 73 60 03 2D 26 D0 04 2D 2C D0 02 2D 25 D0 10 3C 00 2B F0 D1 33 68 C8 F8 00 30 43 BB B9 F1 00 0F 15 D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 9A 42 0B D2 D2 43 13 44 0F 4D 00 24 9E 08 01 36 01 34 55 F8 04 3F 98 47 B4 42 F9 D1 38 46 ?? ?? ?? ?? 53 68 98 47 C9 E7 53 68 38 46 91 68 98 47 C4 E7 53 68 39 46 90 68 98 47 BF E7 30 46 ?? ?? ?? ?? B8 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_521_0_0 {
	meta:
		name = "swapcontext"
		size = 38
		refs = "0002 __getcontext 0022 __setcontext"
	strings:
		$1 = { 0B B5 ?? ?? ?? ?? 04 46 BD E8 0B 40 00 2C 1C BF 20 46 70 47 C0 F8 54 D0 C0 F8 58 E0 C0 F8 5C E0 08 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_522_0_0 {
	meta:
		name = "clearerr"
		size = 178
		refs = "00a4 __libc_do_syscall 00ac __lll_lock_wait_private"
	strings:
		$1 = { 02 68 38 B5 11 04 04 46 3A D4 83 6C 1D EE 70 5F A5 F5 98 65 99 68 A9 42 36 D0 01 21 BF F3 5F 8F 53 E8 00 2F 00 2A 03 D1 43 E8 00 10 00 28 F7 D1 BF F3 5F 8F 00 2A 38 D1 A3 6C 22 68 58 68 22 F0 30 01 12 04 9D 60 00 F1 01 00 58 60 21 60 16 D4 5A 68 01 3A 5A 60 92 B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0B DC 38 BD 22 F0 30 02 02 60 38 BD 59 68 22 F0 30 02 01 31 59 60 02 60 DC E7 A9 68 01 22 18 46 4F F0 F0 0C 00 23 11 43 ?? ?? ?? ?? 38 BD 18 46 ?? ?? ?? ?? C2 E7 }
	condition:
		$1
}

rule file_524_0_0 {
	meta:
		name = "__sched_cpucount"
		size = 86
	strings:
		$1 = { 20 F0 03 00 30 B4 0D 18 A9 42 4F F0 00 00 20 D2 51 F8 04 3B 03 F0 55 32 CB B1 5B 08 03 F0 55 33 13 44 03 F0 33 32 9C 08 04 F0 33 34 14 44 04 F0 0F 33 22 09 02 F0 0F 32 1A 44 02 F0 FF 14 13 0A 03 F0 FF 13 23 44 1A 0C 12 FA 83 F3 18 44 8D 42 DE D8 30 BC 70 47 }
	condition:
		$1
}

rule file_525_0_0 {
	meta:
		name = "__sigsetjmp"
		size = 68
		refs = "003c __sigjmp_save 0040 _dl_hwcap"
	strings:
		$1 = { 00 C0 A0 E1 F0 6F AC E8 30 20 9F E5 00 20 92 E5 40 00 12 E3 00 00 00 0A 10 8B AC EC 02 0C 12 E3 05 00 00 0A 02 A1 EC EC 02 B1 EC EC 02 C1 EC EC 02 D1 EC EC 02 E1 EC EC 02 F1 EC EC ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_0_0 {
	meta:
		name = "_IO_file_seekoff_maybe_mmap"
		size = 50
	strings:
		$1 = { 30 B5 83 B0 D0 F8 98 50 04 46 06 99 00 91 29 6C 88 47 02 46 0B 46 00 2A 73 F1 00 01 05 DB 10 46 19 46 C4 E9 14 23 03 B0 30 BD 4F F0 FF 30 01 46 F9 E7 }
	condition:
		$1
}

rule file_528_1_0 {
	meta:
		name = "new_do_write"
		size = 166
		refs = "008c _IO_adjust_column"
	strings:
		$1 = { 03 68 2D E9 F0 43 13 F4 80 59 83 B0 06 46 0F 46 90 46 1F D0 4F F0 FF 34 4F F0 FF 35 C0 E9 14 45 D6 F8 98 30 42 46 30 46 39 46 DB 6B 98 47 04 46 B6 F8 44 00 28 BB F2 6E F3 69 00 2A F3 60 73 60 B3 60 73 61 33 61 27 DD 33 6A 20 46 B3 61 03 B0 BD E8 F0 83 82 68 01 69 8A 42 E1 D0 D0 F8 98 40 8A 1A 01 25 00 95 D3 17 21 6C 88 47 B1 F1 FF 3F 08 BF B0 F1 FF 3F 08 BF 48 46 E8 D0 C6 E9 14 01 CE E7 00 2C D7 D0 01 38 39 46 22 46 ?? ?? ?? ?? 01 30 A6 F8 44 00 CE E7 31 68 40 F2 02 22 0A 40 00 2A D2 D1 D0 E7 }
	condition:
		$1
}

rule file_528_2_0 {
	meta:
		name = "mmap_remap_check"
		size = 438
		refs = "0030 __munmap 0046 .LANCHOR0 0066 _IO_wfile_jumps 009c __getpagesize 013e __lseek64 0194 __mremap"
	strings:
		$1 = { D0 F8 98 30 2D E9 F0 4F A1 B0 06 A9 9B 6C 82 46 98 47 83 46 28 B9 0A 9B 03 F4 70 43 B3 F5 00 4F 32 D0 DA F8 1C 00 4F F0 01 0B DA F8 20 10 09 1A ?? ?? ?? ?? DA F8 6C 20 00 23 CA F8 20 30 9A 42 CA F8 1C 30 D8 BF ?? ?2 0? 0? CA F8 0C 30 DC BF ?? ?2 0? 0? CA F8 98 20 DA F8 5C 20 CA F8 04 30 CA F8 08 30 CB BF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? C8 BF CA F8 98 30 C2 F8 B8 30 58 46 21 B0 BD E8 F0 8F DD E9 12 45 54 EA 05 00 C7 D0 B4 F5 80 1F 75 F1 00 02 C2 DA ?? ?? ?? ?? DA F8 1C 30 4F F0 00 09 00 27 9C 46 01 46 42 42 DA F8 20 00 66 18 16 F1 FF 36 C0 1A 06 EA 02 08 01 38 CD E9 02 89 08 44 B9 46 10 40 DD E9 02 67 80 46 05 90 46 45 77 EB 09 07 43 DB DD E9 02 67 B0 45 79 EB 07 07 A4 BF E4 18 CA F8 20 40 4B DB DA F8 08 20 CC EB 04 0C DA F8 04 10 E0 46 DA E9 14 67 4F EA EC 79 52 1A CA F8 0C 30 B6 1A 67 EB E2 77 CA E9 14 67 46 45 77 EB 09 00 A4 BF CA F8 04 40 CA F8 08 40 AB DA DA F8 38 00 1E 44 CA F8 08 40 62 46 4B 46 CA F8 04 60 00 21 00 91 ?? ?? ?? ?? DA F8 1C 30 DA F8 20 20 D2 1A D3 17 99 42 08 BF 90 42 2C D0 DA F8 00 30 43 F0 20 03 CA F8 00 30 8D E7 01 3C DD F8 14 80 21 44 11 40 58 18 C1 EB 08 01 ?? ?? ?? ?? DA F8 1C 30 12 9C 9C 46 1C 44 CA F8 20 40 B3 E7 01 3C 18 46 63 18 05 99 1A 40 01 23 ?? ?? ?? ?? 43 1C 3F F4 42 AF 12 9C 84 46 CA F8 1C 00 03 46 04 44 CA F8 20 40 9F E7 CA E9 14 01 64 E7 }
	condition:
		$1
}

rule file_528_3_0 {
	meta:
		name = "_IO_file_sync_mmap"
		size = 82
		refs = "001a __lseek64"
	strings:
		$1 = { 82 68 43 68 10 B5 93 42 82 B0 04 46 C2 69 16 D0 9A 1A 00 21 80 6B D3 17 00 91 ?? ?? ?? ?? E3 69 62 68 D2 1A D3 17 99 42 08 BF 90 42 0A D1 E1 68 00 20 C4 E9 14 23 61 60 A1 60 02 B0 10 BD 9A 1A D3 17 F4 E7 23 68 4F F0 FF 30 43 F0 20 03 23 60 F3 E7 }
	condition:
		$1
}

rule file_528_4_0 {
	meta:
		name = "decide_maybe_mmap"
		size = 304
		refs = "0026 _IO_wfile_jumps 002a .LANCHOR0 0094 __mmap64 00ac __lseek64 00c0 __munmap 00da _IO_setb 00fe _IO_wfile_jumps_mmap"
	strings:
		$1 = { D0 F8 98 30 2D E9 F0 41 9E B0 04 A9 9B 6C 07 46 98 47 28 B9 08 9B 03 F4 70 43 B3 F5 00 4F 19 D0 FB 6E 00 2B DD BF ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? D5 BF ?? ?2 0? 0? ?? ?2 0? 0? C7 F8 98 20 C7 F8 98 30 FA 6D C2 F8 B8 30 1E B0 BD E8 F0 81 DD E9 10 45 54 EA 05 01 E0 D0 B4 F5 80 1F 75 F1 00 03 DB DA D7 E9 14 23 B3 F1 FF 3F 08 BF B2 F1 FF 3F 03 D0 94 42 75 EB 03 01 CF DB BE 6B 01 22 21 46 13 46 00 24 00 25 00 96 00 20 CD E9 02 45 ?? ?? ?? ?? 43 1C 06 46 C0 D0 B8 6B 4F F0 00 08 DD E9 10 23 CD F8 00 80 ?? ?? ?? ?? DD E9 10 45 A9 42 08 BF A0 42 0A D0 30 46 21 46 ?? ?? ?? ?? 4F F0 FF 32 4F F0 FF 33 C7 E9 14 23 A6 E7 32 18 31 46 43 46 38 46 ?? ?? ?? ?? D7 E9 14 23 10 99 B3 F1 FF 3F 08 BF B2 F1 FF 3F FB 6E 08 BF 00 22 11 98 00 2B 32 44 7A 60 CE BF ?? ?2 0? 0? 0A 4A ?? ?2 0? 0? FE 60 C8 BF ?? ?2 0? 0? 0E 44 39 65 BE 60 D8 BF ?? ?2 0? 0? 78 65 D4 BF C7 F8 98 20 C7 F8 98 30 8E E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_5_0 {
	meta:
		name = "_IO_file_xsgetn_maybe_mmap"
		size = 28
	strings:
		$1 = { 70 B5 04 46 0E 46 15 46 FF F7 58 FF D4 F8 98 30 31 46 2A 46 20 46 1B 6A 98 47 70 BD }
	condition:
		$1
}

rule file_528_6_0 {
	meta:
		name = "_IO_file_xsgetn_mmap"
		size = 156
		refs = "0054 mempcpy 0076 _IO_switch_to_main_get_area"
	strings:
		$1 = { 2D E9 F0 41 04 46 46 68 90 46 83 68 0D 46 9B 1B 93 42 16 D2 02 68 D2 05 58 BF 0F 46 22 D4 20 46 FF F7 EA FD 00 28 2E D1 66 68 A3 68 9B 1B 43 45 3E BF 22 68 42 F0 10 02 22 60 2B B9 78 1B BD E8 F0 81 0F 46 00 2B F9 D0 43 45 38 BF 98 46 31 46 38 46 42 46 ?? ?? ?? ?? 46 44 66 60 07 46 78 1B BD E8 F0 81 31 46 1A 46 28 46 C3 EB 08 08 ?? ?? ?? ?? 07 46 20 46 ?? ?? ?? ?? 66 68 A3 68 9B 1B 98 45 DA D9 CB E7 D4 F8 98 30 29 46 42 46 20 46 7D 1B 1B 6A 98 47 28 44 BD E8 F0 81 }
	condition:
		$1
}

rule file_528_7_0 {
	meta:
		name = "_IO_file_close"
		size = 48
		refs = "0008 __libc_do_syscall 002c __libc_errno"
	strings:
		$1 = { 00 B5 4F F0 06 0C 80 6B ?? ?? ?? ?? 10 F5 80 5F 01 D8 5D F8 04 FB 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_9_0 {
	meta:
		name = "_IO_file_setbuf_mmap"
		size = 60
		refs = "0002 _IO_wfile_jumps 0008 .LANCHOR0 001e _IO_new_file_setbuf 0028 _IO_wfile_jumps_mmap"
	strings:
		$1 = { 70 B5 ?? ?2 0? 0? C6 6D ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? C0 F8 98 40 05 46 C6 F8 B8 30 ?? ?? ?? ?? 00 B1 70 BD EA 6D ?? ?2 0? 0? 54 34 ?? ?2 0? 0? C5 F8 98 40 C2 F8 B8 30 70 BD }
	condition:
		$1
}

rule file_528_10_0 {
	meta:
		name = "_IO_new_file_underflow"
		size = 488
		refs = "0028 _IO_stdout 00d2 __libc_do_syscall 00d8 _IO_switch_to_get_mode 0140 free 014e _IO_doallocbuf 0184 __lll_lock_wait_private 01de _Unwind_Resume 01e4 __libc_errno"
	strings:
		$1 = { F8 B5 04 46 03 68 58 07 00 F1 AE 80 62 68 A1 68 8A 42 C0 F0 87 80 E2 69 00 2A 00 F0 8F 80 40 F2 02 22 1A 40 00 2A 56 D0 ?? ?2 0? 0? ?? ?2 0? 0? 35 68 2B 68 19 04 21 D4 AA 6C 1D EE 70 7F A7 F5 98 67 93 68 BB 42 00 F0 86 80 01 21 BF F3 5F 8F 52 E8 00 3F 00 2B 03 D1 42 E8 00 10 00 28 F7 D1 BF F3 5F 8F 00 2B 40 F0 8C 80 AB 6C 30 68 1A 46 9F 60 51 68 03 68 01 31 51 60 00 E0 28 46 03 F4 22 73 B3 F5 20 7F 68 D0 2B 68 1A 04 23 D4 A8 6C 43 68 01 3B 43 60 F3 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 25 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 0B DD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? E3 69 D4 F8 98 50 20 46 22 6A 19 46 63 60 E3 60 D2 1A A3 60 A3 61 63 61 23 61 AB 6B 98 47 00 28 14 DD D4 E9 14 23 A1 68 B3 F1 FF 3F 08 BF B2 F1 FF 3F 01 44 A1 60 04 D0 12 18 43 EB E0 73 C4 E9 14 23 63 68 18 78 F8 BD 10 78 F8 BD 23 68 4F F0 FF 30 0C BF 43 F0 10 03 43 F0 20 03 23 60 F8 BD 60 6A 28 B1 ?? ?? ?? ?? 23 68 23 F4 80 73 23 60 20 46 ?? ?? ?? ?? 23 68 63 E7 28 46 8B E7 D0 F8 98 30 4F F0 FF 31 DB 68 98 47 8F E7 1E 4A 43 F0 20 01 1D EE 70 3F 21 60 7A 44 12 68 09 21 4F F0 FF 30 99 50 F8 BD 10 46 ?? ?? ?? ?? 6F E7 2B 68 04 46 1B 04 24 D4 AB 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 15 00 2D F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 20 46 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_11_0 {
	meta:
		name = "_IO_new_file_seekoff"
		size = 900
		refs = "0062 _IO_unsave_markers 00e8 free 00fa _IO_doallocbuf 01f2 _IO_switch_to_get_mode 0380 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 14 46 1D 46 C2 68 83 68 9F B0 82 46 9A 42 DD F8 A0 80 29 9E 03 69 42 69 4E D0 9A 42 98 BF 4F F0 00 09 4D D9 00 2E 40 F0 A6 81 01 27 B1 46 B8 46 00 24 00 25 DA F8 1C 30 00 2B 50 D0 B8 F1 01 0F 6C D0 B8 F1 02 0F 40 F0 8E 80 DA F8 98 30 50 46 04 A9 9B 6C 98 47 00 28 00 F0 26 81 50 46 ?? ?? ?? ?? DA F8 98 10 22 46 CD F8 00 80 2B 46 50 46 09 6C 88 47 02 46 0B 46 B3 F1 FF 3F 08 BF B2 F1 FF 3F 00 F0 BF 80 DA F8 1C 40 DA F8 00 50 CA E9 14 23 25 F0 10 05 CA F8 0C 40 CA F8 00 50 CA F8 04 40 CA F8 08 40 CA F8 14 40 CA F8 10 40 CA F8 18 40 1F B0 BD E8 F0 8F 93 42 AE D1 4F F0 01 09 DA F8 00 70 C7 F3 C0 27 00 2E 40 F0 8B 80 DA F8 1C 30 4F F0 01 08 00 24 00 25 00 2B AE D1 DA F8 0C 00 38 B1 ?? ?? ?? ?? DA F8 00 30 23 F4 80 73 CA F8 00 30 50 46 ?? ?? ?? ?? DA F8 1C 30 B8 F1 01 0F CA F8 14 30 CA F8 10 30 CA F8 18 30 CA F8 0C 30 CA F8 04 30 CA F8 08 30 92 D1 33 1C 87 F0 01 07 18 BF 01 23 DA F8 08 10 1F 43 14 BF DA F8 04 20 DA F8 14 20 8A 1A DA E9 14 01 A4 1A 65 EB E2 75 B1 F1 FF 3F 08 BF B0 F1 FF 3F 00 F0 EF 80 24 18 45 EB 01 05 00 2C 75 F1 00 00 A8 BF 4F F0 00 08 C0 F2 FD 80 00 2E 4A D0 DA E9 14 23 B3 F1 FF 3F 08 BF B2 F1 FF 3F 47 D0 DA F8 0C 10 00 29 43 D0 DA F8 00 B0 1B F4 80 71 40 D1 DA F8 1C C0 DA F8 08 00 CC EB 00 00 16 1A 63 EB E0 77 B4 42 75 EB 07 00 33 DB 94 42 75 EB 03 00 2F DA A6 1B 2B F0 10 00 66 44 8A E8 41 00 00 2A 73 F1 00 00 CA F8 0C C0 CA F8 14 C0 CA F8 10 C0 CA F8 18 C0 16 DB DA F8 98 60 50 46 00 91 31 6C 88 47 20 46 29 46 0F E0 00 2F 3F F4 25 AF 50 46 01 27 ?? ?? ?? ?? 00 28 3F F4 1E AF 4F F0 FF 30 01 46 01 E0 20 46 29 46 1F B0 BD E8 F0 8F DA F8 00 B0 1B F0 04 0B 7F F4 23 AF DA F8 1C 30 26 46 DA F8 20 00 2F 46 19 1A C0 1A 04 EA 01 02 05 EA E1 73 C1 17 B6 1A 67 EB 03 07 B0 42 71 EB 07 0E DA F8 98 10 43 DA CD F8 00 B0 50 46 22 46 2B 46 09 6C 88 47 CD E9 02 01 00 28 71 F1 00 01 CD DB 00 22 00 23 16 46 DD E9 02 01 DA F8 1C 70 12 18 20 46 43 EB 01 03 DA F8 00 10 CA E9 14 23 3E 44 07 EB 0B 03 CA F8 04 60 CA F8 08 30 21 F0 10 03 CA F8 0C 70 29 46 CA F8 14 70 CA F8 10 70 CA F8 18 70 CA F8 00 30 1F B0 BD E8 F0 8F 08 9B 03 F4 70 43 B3 F5 00 4F 7F F4 D3 AE DD E9 10 23 80 46 A4 18 45 EB 03 05 00 2E 7F F4 51 AF 9A E7 CD F8 00 B0 50 46 09 6C 88 47 CD E9 02 01 00 28 71 F1 00 00 8B DB 56 EA 07 01 39 D0 DA F8 98 30 32 46 DA F8 1C 10 9B 6B B9 F1 00 0F 02 D1 DA F8 20 20 52 1A 50 46 98 47 02 46 C3 17 B2 42 73 EB 07 01 A8 BF 83 46 A7 DA 01 30 34 46 3D 46 08 BF 4F F0 01 08 3F F4 9D AE A4 1A 65 EB 03 05 4F F0 01 08 96 E6 00 2B 7F F4 94 AE DA F8 98 10 01 23 50 46 00 93 00 22 00 23 09 6C 88 47 B1 F1 FF 3F 08 BF B0 F1 FF 3F 3F F4 52 AF CA E9 14 01 FA E6 32 46 3B 46 80 E7 06 4B 1D EE 70 2F 4F F0 FF 30 16 24 7B 44 1B 68 01 46 D4 50 46 E7 4F F0 00 09 36 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_12_0 {
	meta:
		name = "_IO_file_close_mmap"
		size = 64
		refs = "000a __munmap 001a __libc_do_syscall 003c __libc_errno"
	strings:
		$1 = { 10 B5 04 46 C0 69 21 6A 09 1A ?? ?? ?? ?? 00 23 A0 6B 4F F0 06 0C 23 62 E3 61 ?? ?? ?? ?? 10 F5 80 5F 00 D8 10 BD 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F4 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_14_0 {
	meta:
		name = "_IO_file_underflow_maybe_mmap"
		size = 20
	strings:
		$1 = { 10 B5 04 46 FF F7 64 FF 20 46 D4 F8 98 30 1B 69 98 47 10 BD }
	condition:
		$1
}

rule file_528_16_0 {
	meta:
		name = "_IO_new_file_write"
		size = 136
		refs = "0020 __write 0062 __libc_do_syscall 0084 __libc_errno"
	strings:
		$1 = { F8 B5 17 1E 06 46 0D 46 26 DD 3C 46 02 E0 24 1A 00 2C 1F DD F3 6B 29 46 22 46 B0 6B 9B 07 1E D4 ?? ?? ?? ?? 00 28 05 44 F1 DA 33 68 3F 1B 43 F0 20 03 33 60 D6 E9 14 45 00 2C 75 F1 00 03 04 DB E4 19 45 EB E7 75 C6 E9 14 45 10 EA 20 00 38 BF 38 46 F8 BD 3F 1B ED E7 00 27 38 46 EA E7 4F F0 04 0C ?? ?? ?? ?? 10 F5 80 5F 02 46 DA D9 05 4B 1D EE 70 1F 52 42 4F F0 FF 30 7B 44 1B 68 CA 50 D3 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_17_0 {
	meta:
		name = "_IO_file_xsgetn"
		size = 278
		refs = "0050 __aeabi_uidivmod 0090 memcpy 00a8 mempcpy 00be _IO_switch_to_main_get_area 00ca __underflow 0102 free 0110 _IO_doallocbuf"
	strings:
		$1 = { 2D E9 F8 43 06 46 C3 69 89 46 90 46 00 2B 76 D0 47 46 B8 F1 00 0F 37 D0 71 68 B4 68 64 1A BC 42 34 D2 00 2C 3E D1 33 68 DB 05 47 D4 F3 69 00 2B 52 D0 31 6A C9 1A 8F 42 46 D3 7F 29 F3 60 73 60 98 BF 3A 46 B3 60 73 61 33 61 B3 61 03 D9 38 46 ?? ?? ?? ?? 7A 1A D6 F8 98 30 30 46 49 46 9B 6B 98 47 00 28 40 DD D6 E9 14 45 81 44 3F 1A B5 F1 FF 3F 08 BF B4 F1 FF 3F 04 D0 24 18 45 EB E0 75 C6 E9 14 45 00 2F C7 D1 00 27 07 E0 3A 46 48 46 ?? ?? ?? ?? 73 68 3B 44 00 27 73 60 C7 EB 08 00 BD E8 F8 83 48 46 22 46 ?? ?? ?? ?? 73 68 3F 1B 1C 44 33 68 74 60 DB 05 81 46 B7 D5 30 46 ?? ?? ?? ?? 00 2F A8 D1 DF E7 30 46 ?? ?? ?? ?? 01 30 E4 D0 00 2F A0 D1 D7 E7 F3 60 3A 46 73 60 B3 60 73 61 33 61 B3 61 B6 E7 33 68 C7 EB 08 00 0C BF 43 F0 10 03 43 F0 20 03 33 60 BD E8 F8 83 40 6A 28 B1 ?? ?? ?? ?? 33 68 23 F4 80 73 33 60 30 46 ?? ?? ?? ?? 7C E7 }
	condition:
		$1
}

rule file_528_18_0 {
	meta:
		name = "_IO_file_seekoff_mmap"
		size = 228
		refs = "00e0 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 82 B0 1D 46 80 46 09 99 14 46 08 9B 00 29 46 D0 01 2B 3D D0 02 2B 05 D1 02 6A C3 69 D3 1A E4 18 45 EB E3 75 00 2C 75 F1 00 01 45 DB D8 F8 98 10 00 23 22 46 00 93 40 46 2B 46 09 6C 88 47 02 46 0B 46 00 2A 73 F1 00 0C 42 DB D8 F8 1C 10 D8 F8 20 00 C8 E9 14 23 46 1A C8 F8 0C 10 F7 17 A6 42 77 EB 05 0C B1 BF C8 F8 04 00 09 19 C8 F8 04 10 C8 F8 08 10 D8 F8 00 10 B8 BF C8 F8 08 00 21 F0 10 01 C8 F8 00 10 20 46 29 46 02 B0 BD E8 F0 81 42 68 C3 68 D3 1A E4 18 45 EB E3 75 C2 E7 82 68 43 68 D0 E9 14 45 D3 1A E4 1A 65 EB E3 75 20 46 29 46 02 B0 BD E8 F0 81 08 4B 1D EE 70 2F 16 21 4F F0 FF 34 7B 44 1B 68 4F F0 FF 35 D1 50 DA E7 4F F0 FF 34 4F F0 FF 35 D5 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_19_0 {
	meta:
		name = "_IO_file_underflow_mmap"
		size = 56
	strings:
		$1 = { 43 68 82 68 10 B5 93 42 04 46 01 D2 18 78 10 BD FF F7 A6 FC 50 B9 63 68 A2 68 93 42 F6 D3 23 68 4F F0 FF 30 43 F0 10 03 23 60 10 BD D4 F8 98 30 20 46 1B 69 98 47 10 BD }
	condition:
		$1
}

rule file_528_20_0 {
	meta:
		name = "_IO_file_read"
		size = 64
		refs = "0016 __libc_do_syscall 003c __libc_errno 000e __read"
	strings:
		$1 = { C3 6B 00 B5 9B 07 80 6B 03 D4 5D F8 04 EB ?? ?? ?? ?? 4F F0 03 0C ?? ?? ?? ?? 10 F5 80 5F 01 D8 5D F8 04 FB 05 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 5D F8 04 FB 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_21_0 {
	meta:
		name = "_IO_new_file_xsputn"
		size = 270
		refs = "003e mempcpy 00b8 __aeabi_uidivmod 00ce _IO_default_xsputn"
	strings:
		$1 = { 2D E9 F0 41 14 46 05 46 0F 46 12 B3 03 68 03 F4 20 63 B3 F5 20 6F 1F D0 86 69 40 69 86 42 9C BF 16 46 4F F0 00 08 0E D9 36 1A 4F F0 00 08 00 2E 51 D0 A6 42 28 BF 26 46 39 46 32 46 37 44 ?? ?? ?? ?? A6 1B 68 61 08 EB 06 03 23 BB A0 1B BD E8 F0 81 10 46 BD E8 F0 81 40 69 2E 6A 36 1A B2 42 3B D8 8B 18 99 42 13 D2 13 F8 01 2C 59 1E 0A 2A 1C BF 02 3B 07 F1 FF 32 05 D1 42 E0 91 F8 00 C0 BC F1 0A 0F 3D D0 93 42 19 46 03 F1 FF 33 F5 D1 4F F0 00 08 CD E7 D5 F8 98 30 28 46 4F F0 FF 31 DB 68 98 47 43 1C 27 D0 29 6A EB 69 C9 1A 7F 29 98 BF 00 21 02 D9 30 46 ?? ?? ?? ?? B6 EB 01 08 0E D1 00 2E C2 D0 32 46 28 46 07 EB 08 01 ?? ?? ?? ?? 36 1A BA E7 26 46 B5 E7 4F F0 00 08 A6 E7 28 46 39 46 42 46 FF F7 D5 F8 80 45 C0 EB 06 06 AC D8 00 2E AA D0 E6 E7 B4 42 18 BF 00 2E A5 D1 A8 E7 C9 1B 4F F0 01 08 01 EB 08 06 8F E7 }
	condition:
		$1
}

rule file_528_22_0 {
	meta:
		name = "_IO_new_file_init"
		size = 40
		refs = "001c _IO_link_in"
	strings:
		$1 = { 01 68 4F F0 FF 32 10 B5 4F F0 FF 33 04 46 C0 E9 14 23 41 F4 10 53 43 F0 0C 03 03 60 ?? ?? ?? ?? 4F F0 FF 33 A3 63 10 BD }
	condition:
		$1
}

rule file_528_23_0 {
	meta:
		name = "_IO_file_open"
		size = 224
		refs = "0020 __open 0054 _IO_link_in 0096 __libc_do_syscall 00d4 __libc_errno"
	strings:
		$1 = { F0 B5 83 B0 04 46 08 46 09 9D E7 6B 00 2D 0C BF 4F F4 00 31 00 21 08 9E 11 43 1A 46 BB 07 41 D4 ?? ?? ?? ?? 00 28 05 46 3A DB 21 68 41 F2 04 03 33 40 41 F2 04 00 41 F2 0C 02 21 F4 80 51 83 42 06 EA 02 02 21 F0 0C 01 A5 63 42 EA 01 02 22 60 05 D0 20 46 ?? ?? ?? ?? 20 46 03 B0 F0 BD D4 F8 98 30 02 21 03 22 20 46 8D E8 06 00 00 22 59 6A 00 23 88 47 B1 F1 FF 3F 08 BF B0 F1 FF 3F E8 D1 14 4B 1D EE 70 2F 7B 44 1B 68 D3 58 1D 2B E0 D0 28 46 4F F0 06 0C ?? ?? ?? ?? 10 F5 80 5F 12 D8 00 20 DA E7 4F F0 05 0C ?? ?? ?? ?? 10 F5 80 5F B8 D9 09 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 AE E7 05 4B 41 42 00 20 7B 44 1B 68 D1 50 C2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_24_0 {
	meta:
		name = "_IO_new_file_attach"
		size = 132
		refs = "0078 __libc_errno"
	strings:
		$1 = { 83 6B F0 B5 01 33 83 B0 04 46 31 D1 07 68 4F F0 FF 32 19 4D 4F F0 FF 33 27 F0 0C 0E C0 E9 14 23 81 63 1D EE 70 6F D0 F8 98 70 4E F0 40 01 01 60 7D 44 2D 68 4F F0 01 0E 03 21 75 59 00 22 CD F8 00 E0 00 23 01 91 79 6A 88 47 B1 F1 FF 3F 08 BF B0 F1 FF 3F 06 D0 09 4B 20 46 7B 44 1B 68 F5 50 03 B0 F0 BD 06 4B 7B 44 1B 68 F3 58 1D 2B F2 D0 00 20 03 B0 F0 BD 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_25_0 {
	meta:
		name = "_IO_new_do_write"
		size = 24
	strings:
		$1 = { 10 B5 14 46 0A B9 10 46 10 BD FE F7 F5 FF 20 1A 18 BF 6F F0 00 00 10 BD }
	condition:
		$1
}

rule file_528_26_0 {
	meta:
		name = "_IO_new_file_close_it"
		size = 216
		refs = "001e _IO_unsave_markers 003a _IO_free_wbackup_area 0046 _IO_wsetb 0062 _IO_setb 0076 _IO_un_link 00c2 _IO_wdo_write 00d0 _IO_do_write"
	strings:
		$1 = { 81 6B 70 B5 4A 1C 04 46 49 D0 02 68 40 F6 08 03 13 40 B3 F5 00 6F 18 BF 00 26 49 D0 20 46 ?? ?? ?? ?? E3 6B 9B 06 48 BF 00 25 3A D5 E3 6E 00 2B 13 DD E3 6D 1B 6A 13 B1 20 46 ?? ?? ?? ?? 00 21 20 46 0A 46 0B 46 ?? ?? ?? ?? E3 6D 00 22 9A 60 1A 60 5A 60 1A 61 DA 60 5A 61 00 21 20 46 0A 46 0B 46 ?? ?? ?? ?? 00 23 20 46 E3 60 63 60 A3 60 63 61 23 61 A3 61 ?? ?? ?? ?? 00 2D 14 BF 29 46 31 46 42 F2 0C 43 4F F0 FF 32 CF F6 AD 33 A2 63 23 60 4F F0 FF 32 4F F0 FF 33 C4 E9 14 23 08 46 70 BD D4 F8 98 30 20 46 5B 6C 98 47 05 46 BD E7 C3 6E 00 2B 09 DD C2 6D D3 68 12 69 19 46 D2 1A 92 10 ?? ?? ?? ?? 06 46 A8 E7 01 69 42 69 52 1A ?? ?? ?? ?? 06 46 A1 E7 }
	condition:
		$1
}

rule file_528_27_0 {
	meta:
		name = "_IO_new_file_fopen"
		size = 920
		refs = "0090 _IO_file_open 00a0 __have_o_cloexec 00b0 .LC0 00bc strstr 00ce __strchrnul 00ec mempcpy 00fe _nl_C_locobj 019a __wcsmbs_named_conv 01bc __libio_codecvt 0218 memcpy 0220 __libio_translit 0306 __fcntl 0334 __libc_errno 033a _IO_file_close_it 0352 .LC3 0356 .LC2 035a __PRETTY_FUNCTION__.13525 036e __assert_fail 0372 .LC1"
	strings:
		$1 = { 2D E9 F0 4F 87 B0 91 46 02 AF 05 46 82 6B 01 32 15 D1 99 F8 00 20 72 2A 00 F0 65 81 77 2A 13 D0 61 2A 00 F0 59 81 C3 4B 1D EE 70 2F 00 20 16 21 7B 44 1B 68 D1 50 14 37 BD 46 BD E8 F0 8F 00 20 14 37 BD 46 BD E8 F0 8F 4F F0 04 0C 4F F0 01 0E 4F F4 10 72 09 F1 01 04 09 F1 07 00 A0 46 01 34 98 F8 00 60 63 2E 00 F0 1F 81 00 F2 0B 81 2B 2E 00 F0 1F 81 62 2E 00 F0 15 81 0E B1 84 42 ED D1 01 93 4E EA 02 02 CD F8 00 C0 28 46 4F F4 DB 73 ?? ?? ?? ?? 80 46 00 28 D1 D0 EB 6B 5C 06 07 D5 ?? ?2 0? 0? ?? ?2 0? 0? 23 68 00 2B 40 F3 26 81 ?? ?2 0? 0? 09 F1 01 00 ?? ?2 0? 0? ?? ?? ?? ?? 00 28 00 F0 16 81 46 1D 2C 21 30 46 E9 46 ?? ?? ?? ?? 31 46 4F F0 00 0B 82 1B 02 F1 0A 03 23 F0 07 03 AD EB 03 0D 0D F1 08 0A 50 46 ?? ?? ?? ?? 80 F8 00 B0 9D F8 08 30 00 2B 00 F0 18 81 ?? ?2 0? 0? 51 46 ?? ?2 0? 0? 52 46 D0 F8 34 E0 D0 F8 3C C0 0D E0 5F 2B 10 D0 A3 F1 2C 00 02 28 0C D9 3A 2B 0A D0 2F 2B 00 F0 CF 80 11 F8 01 3F 6B B1 1C B2 3E F8 14 00 00 07 EC D5 5C F8 24 30 01 32 02 F8 01 3C 11 F8 01 3F 00 2B F1 D1 BB F1 01 0F 0B F1 01 03 00 F3 E9 80 99 1E 2F 24 53 1C 8A 1A 03 F8 01 4C 18 46 01 33 D1 18 01 29 F8 DD 00 23 03 70 9A F8 02 30 73 B9 ?? ?2 0? 0? 0A F1 FF 32 ?? ?2 0? 0? D9 6B 16 F8 01 3B 11 F8 23 30 02 F8 01 3F 00 2B F7 D1 51 46 38 46 ?? ?? ?? ?? 04 46 00 28 40 F0 C9 80 7B 68 01 2B 40 F0 E2 80 D7 F8 0C A0 BA F1 01 0F 40 F0 CC 80 EE 6D ?? ?2 0? 0? ?? ?2 0? 0? 78 22 86 F8 2C 00 86 F8 2D 00 86 F8 2E 00 86 F8 2F 00 86 F8 30 00 86 F8 31 00 86 F8 32 00 86 F8 33 00 70 68 EB 6D 30 60 F0 68 30 61 83 F8 34 40 83 F8 35 40 83 F8 36 40 83 F8 37 40 83 F8 38 40 83 F8 39 40 83 F8 3A 40 83 F8 3B 40 EE 6D 06 F1 3C 00 A8 65 ?? ?? ?? ?? 7B 68 3A 68 ?? ?2 0? 0? 34 67 ?? ?2 0? 0? F3 65 40 46 FB 68 14 37 C6 F8 74 A0 C6 F8 6C A0 32 66 D8 F8 5C 20 C6 F8 88 30 57 F8 0C 3C 2C 32 C6 F8 84 40 C6 F8 9C 40 B2 67 C6 F8 A0 A0 C6 F8 98 A0 C6 F8 8C 30 D8 F8 5C 30 C6 F8 B0 10 2C 33 C6 F8 A4 30 EB 6D D3 F8 B8 30 C5 F8 98 30 C8 F8 6C A0 CD 46 BD 46 BD E8 F0 8F 6D 2E 1A D0 78 2E 09 D0 65 2E 7F F4 F5 AE EE 6B 42 F4 00 22 46 F0 40 06 EE 63 ED E6 42 F0 80 02 C1 46 E9 E6 EE 6B 46 F0 02 06 EE 63 E4 E6 0C F4 80 5C C1 46 4F F0 02 0E DE E6 EE 6B 46 F0 01 06 EE 63 D9 E6 0B F1 01 0B BB F1 03 0F 2B D0 13 70 01 32 28 E7 41 F2 04 0C 4F F0 01 0E 4F F4 88 62 B6 E6 4F F0 00 0E 4F F0 08 0C 72 46 B0 E6 40 46 14 37 BD 46 BD E8 F0 8F AE 6B 05 D0 30 46 02 21 01 22 ?? ?? ?? ?? D1 E6 30 46 01 21 ?? ?? ?? ?? 10 F0 01 0F 14 BF 01 23 4F F0 FF 33 23 60 00 2B BF F6 C4 AE EA E7 10 46 1F E7 52 46 01 23 11 E7 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? 15 4B 1D EE 70 2F 16 21 7B 44 1B 68 00 20 D1 50 CD 46 71 E6 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 40 F2 7B 12 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 BD 72 ?? ?? ?? ?? 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_28_0 {
	meta:
		name = "_IO_new_file_finish"
		size = 84
		refs = "001c _IO_wdo_write 004e _IO_do_write 002e _IO_default_finish"
	strings:
		$1 = { 83 6B 10 B5 01 33 04 46 0D D0 C3 6E 00 2B 1B DD C2 6D D3 68 12 69 19 46 D2 1A 92 10 ?? ?? ?? ?? 23 68 5B 06 05 D5 20 46 00 21 BD E8 10 40 ?? ?? ?? ?? D4 F8 98 30 20 46 5B 6C 98 47 20 46 00 21 BD E8 10 40 ?? ?? ?? ?? 01 69 42 69 52 1A ?? ?? ?? ?? E5 E7 }
	condition:
		$1
}

rule file_528_29_0 {
	meta:
		name = "_IO_new_file_overflow"
		size = 300
		refs = "0082 _IO_do_write 00a4 _IO_wdo_write 00e2 _IO_doallocbuf 010c _IO_free_backup_area 0128 __libc_errno"
	strings:
		$1 = { F8 B5 04 46 03 68 0D 46 1E 07 5C D4 18 05 14 D5 23 69 00 2B 64 D0 62 69 6F 1C 4D D0 23 6A 93 42 36 D0 53 1C 63 61 15 70 23 68 9A 07 25 D4 9B 05 01 D5 0A 2D 21 D0 E8 B2 F8 BD 22 69 00 2A 4F D0 62 68 D9 05 5F D4 20 6A 43 F4 00 67 E6 6E 90 42 27 60 A0 61 0A BF E1 69 A1 68 0A 46 62 61 08 BF A1 60 00 2E 22 61 61 60 E1 60 D5 DC 40 F2 02 21 19 40 00 29 D0 D0 A2 61 CE E7 21 69 20 46 62 69 52 1A ?? ?? ?? ?? 01 30 D5 D1 4F F0 FF 30 F8 BD E3 6E 00 2B 2D DD E2 6D 20 46 D3 68 12 69 19 46 D2 1A 92 10 ?? ?? ?? ?? B0 F1 FF 31 48 42 48 41 00 28 EA D1 62 69 B4 E7 21 69 20 46 BD E8 F8 40 52 1A ?? ?? ?? ?? 18 4A 43 F0 20 01 1D EE 70 3F 01 60 7A 44 12 68 09 21 4F F0 FF 30 99 50 F8 BD 20 46 ?? ?? ?? ?? E2 69 23 68 E2 60 62 60 A2 60 A7 E7 21 69 20 46 52 1A ?? ?? ?? ?? B0 F1 FF 36 70 42 70 41 D4 E7 A3 68 20 46 9E 1A ?? ?? ?? ?? E1 68 E0 69 23 68 0A 1A 96 42 38 BF 32 46 8A 1A E2 60 62 60 8F E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_528_30_0 {
	meta:
		name = "_IO_new_file_sync"
		size = 152
		refs = "0020 _IO_wdo_write 006c _IO_do_write 0094 __libc_errno"
	strings:
		$1 = { 42 69 01 69 10 B5 8A 42 82 B0 04 46 0F D9 C3 6E 00 2B 2A DD C2 6D D3 68 12 69 19 46 D2 1A 92 10 ?? ?? ?? ?? 00 30 18 BF 01 20 00 28 2E D1 62 68 A3 68 D2 1A 08 D1 00 20 4F F0 FF 32 4F F0 FF 33 C4 E9 14 23 02 B0 10 BD D4 F8 98 10 01 23 20 46 00 93 D3 17 09 6C 88 47 B1 F1 FF 3F 08 BF B0 F1 FF 3F 0B D0 63 68 A3 60 E5 E7 52 1A ?? ?? ?? ?? 00 30 18 BF 01 20 00 28 D9 D0 07 E0 05 4B 1D EE 70 2F 7B 44 1B 68 D3 58 1D 2B D4 D0 4F F0 FF 30 D8 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_529_0_0 {
	meta:
		name = "__clock_nanosleep"
		size = 104
		refs = "0010 __libc_multiple_threads 002a __libc_do_syscall 0048 __libc_enable_asynccancel 0062 __libc_disable_asynccancel"
	strings:
		$1 = { 03 28 2D E9 F0 41 04 46 0F 46 16 46 1D 46 18 D0 ?? ?2 0? 0? 02 2C ?? ?2 0? 0? 08 BF 6F F0 05 04 00 68 88 B9 20 46 40 F2 09 1C ?? ?? ?? ?? 04 46 14 F5 80 5F 02 D9 60 42 BD E8 F0 81 00 20 BD E8 F0 81 16 20 BD E8 F0 81 ?? ?? ?? ?? 39 46 32 46 2B 46 40 F2 09 1C 80 46 20 46 ?? ?? ?? ?? 04 46 40 46 ?? ?? ?? ?? E3 E7 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "__res_state"
		size = 20
		refs = "0010 __libc_resp"
	strings:
		$1 = { 03 4B 1D EE 70 2F 7B 44 1B 68 D0 58 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_124_0_3 {
	meta:
		name = "__res_state"
		size = 20
		refs = "0010 __resp"
	strings:
		$1 = { 03 4B 1D EE 70 2F 7B 44 1B 68 D0 58 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_540_0_0 {
	meta:
		name = "getspent"
		size = 204
		refs = "0004 .LANCHOR0 002c __getspent_r 0030 .LANCHOR1 004a __nss_getent 009a __lll_lock_wait_private 00b8 __libc_do_syscall 00c4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 41 ?? ?2 0? 0? 82 B0 01 22 ?? ?2 0? 0? BF F3 5F 8F 54 E8 00 3F 00 2B 03 D1 44 E8 00 21 00 29 F7 D1 BF F3 5F 8F 9B BB 25 4B ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? A3 F1 24 01 ?? ?2 0? 0? 00 93 00 26 4F F4 80 63 01 96 ?? ?? ?? ?? 1D 4B 1D EE 70 5F 7B 44 1B 68 55 F8 03 80 07 46 23 68 BF F3 5F 8F 54 E8 00 2F 9A 42 03 D1 44 E8 00 61 00 29 F7 D1 93 42 BF F3 5F 8F F0 D1 01 2B 0F DC 11 4B 38 46 7B 44 1B 68 45 F8 03 80 02 B0 BD E8 F0 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? C4 E7 A5 F5 98 63 01 22 ?? ?2 0? 0? 4F F0 F0 0C 99 68 ?? ?2 0? 0? 00 23 11 43 ?? ?? ?? ?? E0 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_543_0_0 {
	meta:
		name = "__new_msgctl"
		size = 48
		refs = "000a __libc_do_syscall 002c __libc_errno"
	strings:
		$1 = { 00 B5 41 F4 80 71 4F F4 98 7C ?? ?? ?? ?? 10 F5 80 5F 01 D8 5D F8 04 FB 04 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_544_0_0 {
	meta:
		name = "__poll_chk"
		size = 20
		refs = "0010 __chk_fail 000c __poll"
	strings:
		$1 = { B1 EB D3 0F 08 B5 03 D8 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_545_0_0 {
	meta:
		name = "__lchown"
		size = 44
		refs = "0006 __libc_do_syscall 0028 __libc_errno"
	strings:
		$1 = { 00 B5 4F F0 C6 0C ?? ?? ?? ?? 10 F5 80 5F 01 D8 5D F8 04 FB 04 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F3 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_546_0_0 {
	meta:
		name = "_dl_scope_free"
		size = 134
		refs = "0010 free 0018 _dl_scope_free_list 0038 _dl_wait_lookup_done 0062 malloc"
	strings:
		$1 = { 1D EE 70 3F A3 F5 98 63 70 B5 05 46 1C 68 1C B9 ?? ?? ?? ?? 20 46 70 BD ?? ?2 0? 0? ?? ?2 0? 0? 26 68 EE B1 33 68 31 2B 06 D8 06 EB 83 02 00 24 01 33 33 60 50 60 ED E7 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 98 47 33 68 4B B1 01 3B 33 60 06 EB 83 03 58 68 ?? ?? ?? ?? 33 68 00 2B F5 D1 01 24 D9 E7 CC 20 ?? ?? ?? ?? 20 60 20 B1 01 23 45 60 34 46 03 60 CF E7 ?? ?2 0? 0? 01 24 ?? ?2 0? 0? 1B 68 98 47 28 46 C4 E7 }
	condition:
		$1
}

rule file_549_0_0 {
	meta:
		name = "__swprintf_chk"
		size = 24
		refs = "0010 __vswprintf_chk"
	strings:
		$1 = { 30 B5 85 B0 08 AC 54 F8 04 5B 00 95 01 94 03 94 ?? ?? ?? ?? 05 B0 30 BD }
	condition:
		$1
}

rule file_1137_0_0 {
	meta:
		name = "___snprintf_chk"
		size = 24
		refs = "0010 __vsnprintf_chk"
	strings:
		$1 = { 30 B5 85 B0 08 AC 54 F8 04 5B 00 95 01 94 03 94 ?? ?? ?? ?? 05 B0 30 BD }
	condition:
		$1
}

rule file_550_0_0 {
	meta:
		name = "____wcstoull_l_internal"
		size = 972
		refs = "0036 __iswspace_l 0072 __strtol_ull_max_tab 0076 __strtol_ull_rem_tab 0086 __strtol_ul_max_tab 015c __iswalpha_l 016c __towupper_l 03ac __correctly_grouped_prefixwc 03c4 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 8F B0 17 46 1D 46 DD F8 60 80 99 46 0A 90 05 91 D8 F8 04 20 00 2B 40 F0 83 81 01 2F 00 F0 85 80 24 2F 00 F2 82 80 0A 9C A2 46 41 46 04 34 DA F8 00 00 ?? ?? ?? ?? 00 28 F6 D1 DA F8 00 30 52 46 00 2B 00 F0 25 81 2D 2B 00 F0 AA 80 2B 2B 0C 90 04 BF A2 46 53 68 30 2B 00 F0 8A 80 00 2F 70 D0 0A 2F 6E D0 B9 1E 00 22 0D 93 93 46 04 92 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 EB C1 00 ?? ?2 0? 0? 52 5C ?? ?2 0? 0? D0 E9 00 45 53 F8 21 C0 0B 92 CD E9 06 45 0D 9D 00 2D 00 F0 36 81 D3 45 00 F0 2D 81 00 22 55 46 CD F8 20 A0 92 46 CD F8 08 80 E0 46 0D 9C 0C E0 04 9B 4C 45 14 BF 00 23 03 F0 01 03 00 2B 43 D0 6C 68 35 46 84 B1 B3 45 69 D0 A4 F1 30 00 2E 1D 09 28 ED D8 B8 42 6B DA D0 45 73 D9 6C 68 35 46 07 FB 0A 0A 00 2C EE D1 52 46 DD F8 20 A0 DD F8 08 80 03 94 02 92 00 25 B2 45 00 F0 C5 80 05 9C 04 B1 26 60 00 2D 40 F0 16 81 0C 9D DD E9 02 01 75 B1 40 42 61 EB 41 01 0F B0 BD E8 F0 8F A5 4B 1D EE 70 2F 00 20 00 21 7B 44 1B 68 16 24 D4 50 0F B0 BD E8 F0 8F 0D 93 00 2D 40 F0 0B 81 04 95 08 21 AB 46 0A 27 8C E7 02 99 20 46 ?? ?? ?? ?? 02 99 03 46 20 46 00 2B 00 F0 C1 80 ?? ?? ?? ?? 37 38 B7 E7 37 F0 10 02 7F F4 74 AF DA F8 04 00 41 46 ?? ?? ?? ?? 58 28 02 BF 0A F1 08 0A 0E 21 10 27 04 D0 00 2F 40 F0 E2 80 06 21 08 27 DA F8 00 30 62 E7 A2 46 53 68 01 24 0C 94 55 E7 52 46 DD F8 08 80 DD F8 20 A0 02 92 00 22 03 92 A2 E7 52 46 DD F8 08 80 00 23 DD F8 20 A0 02 92 2E 46 03 93 98 E7 52 46 DD F8 08 80 DD F8 20 A0 14 46 2E 46 00 25 CD E9 02 45 00 25 CD F8 34 A0 3A 46 DD F8 10 A0 FB 17 CD F8 10 80 A8 46 DD E9 02 45 CD E9 08 23 09 9B D4 46 CA 46 B9 46 04 FB 03 F2 08 9B 03 FB 05 22 A4 FB 03 45 15 44 24 18 45 F1 00 05 56 F8 04 7F 00 2F 55 D0 5E 45 5B D0 A7 F1 30 00 09 28 15 D9 57 45 14 BF 00 23 0C F0 01 03 00 2B EE D1 38 46 04 99 CD F8 04 C0 ?? ?? ?? ?? 00 28 40 D0 38 46 04 99 ?? ?? ?? ?? DD F8 04 C0 37 38 48 45 37 DA DD E9 06 23 AB 42 08 BF A2 42 0D D3 9D 42 08 BF 94 42 0B 9A 14 BF 00 23 01 23 90 42 94 BF 00 23 03 F0 01 03 00 2B 37 D0 4F F0 01 08 C6 E7 DD F8 28 A0 05 9C 00 2C 3F D0 0A 9D C5 EB 0A 03 07 2B 05 DC 0A 9C 00 20 05 9D 00 21 2C 60 45 E7 41 46 5A F8 04 0C ?? ?? ?? ?? 58 28 F2 D1 5A F8 08 3C 30 2B EE D1 AA F1 04 03 00 20 00 21 23 60 34 E7 CD E9 02 45 45 46 DD F8 34 A0 DD F8 10 80 10 E7 CD E9 02 45 45 46 0F E7 52 46 88 46 DD F8 20 A0 2E 46 02 92 03 93 03 E7 4F 46 D1 46 E2 46 7E E7 00 24 00 25 56 46 CD E9 02 45 F9 E6 00 22 00 23 56 46 CD E9 02 23 F3 E6 00 20 00 21 0D E7 D5 6A 2B 78 01 3B DB B2 FD 2B 84 BF 00 25 A9 46 3F F6 73 AE D2 F8 34 90 B9 F1 00 0F 08 BF 00 25 6B E6 20 4B 1D EE 70 2F 22 24 4F F0 FF 30 7B 44 1B 68 4F F0 FF 31 D4 50 F0 E6 DA F8 00 30 7F E6 99 45 CE D0 DB B1 56 46 0D 9C 09 E0 20 46 ?? ?? ?? ?? 37 38 09 28 13 DC 74 68 37 1D 3E 46 7C B1 A4 F1 30 03 37 46 09 2B F6 D9 4C 45 41 46 20 46 F2 D0 ?? ?? ?? ?? 41 46 00 28 E7 D1 00 E0 57 46 39 46 2B 46 50 46 4A 46 ?? ?? ?? ?? DA F8 00 30 01 24 08 21 04 94 0A 27 0D 93 83 46 57 E6 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_551_0_0 {
	meta:
		name = "stty"
		size = 52
		refs = "002c __libc_errno"
		altNames = "gtty"
	strings:
		$1 = { 49 B1 0A 4B 1D EE 70 2F 26 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 06 4B 1D EE 70 2F 16 21 4F F0 FF 30 7B 44 1B 68 D1 50 70 47 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_555_0_0 {
	meta:
		name = "__mempcpy_chk"
		size = 116
		refs = "003a _wordcopy_fwd_aligned 0060 _wordcopy_fwd_dest_aligned 0070 __chk_fail"
	strings:
		$1 = { 93 42 2D E9 F0 41 33 D3 0F 2A 04 46 0D 46 1C D9 47 42 07 F0 03 07 C7 EB 02 08 3F B3 C6 19 0B 46 13 F8 01 5B 04 F8 01 5B B4 42 F9 D1 CD 19 AB 07 30 46 29 46 4F EA 98 02 12 D1 ?? ?? ?? ?? 28 F0 03 04 08 F0 03 02 25 44 34 44 62 B1 A0 18 23 46 2A 1B D1 5C 03 F8 01 1B 83 42 FA D1 BD E8 F0 81 ?? ?? ?? ?? EB E7 20 46 BD E8 F0 81 06 46 DE E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_0_0 {
	meta:
		name = "_nss_files_parse_spent"
		size = 540
		refs = "000a strchr 007e strtoul 0218 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 70 B5 0D 46 82 B0 0A 21 04 46 ?? ?? ?? ?? 08 B1 00 23 03 70 2C 60 23 78 3A 2B 18 BF 00 2B 07 D0 62 1C 14 46 12 F8 01 3B 3A 2B 18 BF 00 2B F8 D1 13 B1 00 23 04 F8 01 3B 23 78 33 B9 2A 68 12 78 2B 2A 18 BF 2D 2A 00 F0 CC 80 6C 60 23 78 00 2B 18 BF 3A 2B 07 D0 62 1C 14 46 12 F8 01 3B 3A 2B 18 BF 00 2B F8 D1 13 B1 00 23 04 F8 01 3B 23 78 13 B9 00 20 02 B0 70 BD 0A 22 20 46 01 A9 ?? ?? ?? ?? 01 9B A3 42 08 BF 4F F0 FF 32 A8 60 08 BF AA 60 1A 78 3A 2A 08 BF 5C 1C 02 D0 00 2A E8 D1 1C 46 23 78 00 2B E4 D0 0A 22 20 46 01 A9 ?? ?? ?? ?? 01 9B A3 42 08 BF 4F F0 FF 32 E8 60 08 BF EA 60 1A 78 3A 2A 08 BF 5E 1C 02 D0 00 2A D0 D1 1E 46 33 78 00 2B CC D0 30 46 01 A9 0A 22 ?? ?? ?? ?? 01 9C B4 42 08 BF 4F F0 FF 33 28 61 08 BF 2B 61 23 78 3A 2B 08 BF 01 34 01 D0 00 2B B8 D1 45 4B 1D EE 70 1F 22 78 7B 44 1B 68 C8 58 30 F8 12 30 9E 04 48 BF 63 1C 06 D5 1C 46 13 F8 01 2B 30 F8 12 10 89 04 F8 D4 00 2A 67 D0 0A 22 20 46 01 A9 ?? ?? ?? ?? 01 9B A3 42 08 BF 4F F0 FF 32 68 61 08 BF 6A 61 1A 78 3A 2A 08 BF 5C 1C 02 D0 00 2A 8E D1 1C 46 23 78 00 2B 8A D0 20 46 01 A9 0A 22 ?? ?? ?? ?? 01 9E A6 42 08 BF 4F F0 FF 33 A8 61 08 BF AB 61 33 78 3A 2B 08 BF 01 36 02 D0 00 2B 7F F4 76 AF 33 78 00 2B 3F F4 72 AF 30 46 01 A9 0A 22 ?? ?? ?? ?? 01 9C B4 42 08 BF 4F F0 FF 33 E8 61 08 BF EB 61 23 78 3A 2B 08 BF 01 34 02 D0 00 2B 7F F4 5D AF 23 78 3B B3 0A 22 01 A9 20 46 ?? ?? ?? ?? 01 9B A3 42 08 BF 4F F0 FF 32 28 62 08 BF 2A 62 18 78 D0 F1 01 00 38 BF 00 20 48 E7 4F F0 FF 32 01 20 6B 60 AB 60 EB 60 2B 61 6A 61 AA 61 EA 61 2A 62 02 B0 70 BD 4F F0 FF 33 01 20 6B 61 AB 61 EB 61 2B 62 33 E7 4F F0 FF 33 01 20 2B 62 2E E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_556_1_0 {
	meta:
		name = "__sgetspent_r"
		size = 96
		refs = "0014 strncpy 0036 _nss_files_parse_spent 0058 __libc_errno"
	strings:
		$1 = { F0 B5 14 46 5D 1E 1A 46 83 B0 00 23 0E 46 63 55 01 46 20 46 ?? ?? ?? ?? 64 5D 14 B1 22 20 03 B0 F0 BD 0D 4D 1D EE 70 7F 23 46 31 46 7D 44 2D 68 22 46 3D 44 00 95 ?? ?? ?? ?? 08 9B 00 28 04 DD 1E 60 20 46 16 B1 03 B0 F0 BD 1C 60 03 4B 7B 44 1B 68 F8 58 E3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_557_0_0 {
	meta:
		name = "relocate_pc24.12559.isra.6"
		size = 278
		refs = "002a .LANCHOR0 002e _dl_pagesize 00bc __mmap 00ce .LC1 00d2 .LC2 00d6 __PRETTY_FUNCTION__.12569 00ea __assert_fail 00f0 .LC3 00fe _dl_signal_error 0102 .LC0"
	strings:
		$1 = { 2D E9 F0 47 14 46 8A 1A 0F 46 1A 44 1E 46 12 F0 7E 41 82 B0 0C BF 00 23 01 23 81 46 B1 F1 7E 4F 0C BF 00 23 03 F0 01 03 93 B3 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? D5 F8 00 A0 BA F1 00 0F 31 D0 6B 68 ?? ?2 0? 0? 4F F2 04 01 0A EB 03 02 CE F2 1F 51 4A F8 03 10 03 F1 08 01 D8 F8 00 00 ?? ?2 0? 0? 36 1B ?? ?2 0? 0? 81 42 57 60 32 44 69 60 22 BF 00 21 19 60 59 60 12 F0 7E 41 0C BF 00 23 01 23 B1 F1 7E 4F 0C BF 00 23 03 F0 01 03 73 BB 23 68 C2 F3 97 02 03 F0 7F 43 13 43 23 60 02 B0 BD E8 F0 87 ?? ?2 0? 0? 4F F0 FF 33 CD F8 04 A0 50 46 00 93 07 22 22 23 D8 F8 00 10 ?? ?? ?? ?? 43 1C 1E D0 6B 68 82 46 28 60 00 2B BB D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 4F F4 9F 72 ?? ?? ?? ?? 00 20 ?? ?2 0? 0? D9 F8 00 10 02 46 ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? 50 46 D9 F8 00 10 52 46 ?? ?2 0? 0? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_557_1_0 {
	meta:
		name = "_dl_try_allocate_static_tls"
		size = 140
		refs = "000a _dl_tls_static_align 001c _dl_tls_static_used 002c _dl_tls_static_size 0074 _dl_init_static_tls"
	strings:
		$1 = { D0 F8 3C 22 F8 B5 51 1C 32 D0 ?? ?2 0? 0? D0 F8 34 12 ?? ?2 0? 0? 12 68 91 42 34 D8 ?? ?2 0? 0? D0 F8 38 52 ?? ?2 0? 0? C1 F1 00 0C ?? ?2 0? 0? D0 F8 30 72 16 68 ?? ?2 0? 0? 31 44 24 68 01 39 49 1B 01 EA 0C 01 0D 44 E9 19 A1 42 1B D8 44 69 C0 F8 3C 52 C0 F8 38 62 94 F8 94 41 11 60 C4 F3 80 02 3A B9 90 F8 95 11 41 F0 04 01 80 F8 95 11 10 46 F8 BD ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 98 47 00 22 10 46 F8 BD 4F F0 FF 32 F1 E7 }
	condition:
		$1
}

rule file_557_2_0 {
	meta:
		name = "_dl_allocate_static_tls"
		size = 38
		refs = "000c _dl_try_allocate_static_tls 0016 .LC4 0022 _dl_signal_error"
	strings:
		$1 = { D0 F8 3C 32 10 B5 01 33 04 46 03 D0 ?? ?? ?? ?? 00 B9 10 BD 00 20 ?? ?2 0? 0? 61 68 02 46 ?? ?2 0? 0? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_557_3_0 {
	meta:
		name = "_dl_nothread_init_static_tls"
		size = 102
		refs = "0030 mempcpy 0048 .LC5 004c .LC6 0050 __PRETTY_FUNCTION__.12502 0062 __assert_fail 0044 memset"
	strings:
		$1 = { 1D EE 70 1F 38 B5 04 46 0B 68 D4 F8 40 22 D0 F8 3C 02 53 F8 08 5C 08 44 AA 42 15 D8 03 EB C2 01 43 F8 32 00 01 23 0B 71 D4 F8 28 12 D4 F8 2C 22 ?? ?? ?? ?? D4 F8 30 22 D4 F8 2C 32 00 21 D2 1A BD E8 38 40 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 8D 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_557_4_0 {
	meta:
		name = "_dl_protect_relro"
		size = 84
		refs = "0002 _dl_pagesize 002a __mprotect 003a errstring.12800 004c _dl_signal_error 0050 __libc_errno"
	strings:
		$1 = { 38 B5 ?? ?2 0? 0? ?? ?2 0? 0? D0 F8 48 52 02 68 04 46 D0 F8 4C 12 18 68 AB 18 19 44 40 42 01 40 18 40 88 42 05 D0 01 22 09 1A ?? ?? ?? ?? 00 28 00 DB 38 BD 06 48 1D EE 70 5F ?? ?2 0? 0? 61 68 78 44 00 68 ?? ?2 0? 0? 00 22 28 58 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_557_5_0 {
	meta:
		name = "_dl_reloc_bad_type"
		size = 66
		refs = "0000 .LANCHOR1 0016 stpcpy 001a _itoa_lower_digits 003e _dl_signal_error"
	strings:
		$1 = { ?? ?2 0? 0? 70 B5 ?? ?2 0? 0? 88 B0 06 46 0D 46 68 46 03 EB 42 11 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 71 68 00 22 04 46 C5 F3 03 10 05 F0 0F 05 1E 5C 10 46 5D 5D 6B 46 A2 70 26 70 65 70 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_557_6_0 {
	meta:
		name = "_dl_relocate_object"
		size = 4352
		refs = "0028 _dl_debug_mask 00ae _dl_tlsdesc_return 00c8 _dl_rtld_map 00cc .LC12 00d4 _dl_verbose 00da _dl_argv 01b8 _dl_hwcap 02dc _dl_lookup_symbol_x 0370 _dl_protect_relro 0390 _dl_tlsdesc_lazy_resolver 03d4 _dl_tlsdesc_undefweak 0518 _dl_profile 051c _dl_runtime_profile 0534 _dl_name_match_p 053e _dl_profile_map 0584 .LC17 05aa _dl_dprintf 05c2 memcpy 0722 _dl_reloc_bad_type 07e6 _dl_runtime_resolve 0d18 _dl_allocate_static_tls 0da0 .LC7 0db8 .LC9 0dbc .LC8 0dc8 .LC15 0dd6 _dl_debug_printf 0dfe _dl_pagesize 0e64 __mprotect 0ee8 .LC10 0f02 _dl_signal_error 0fb0 __libc_do_syscall 0fe6 .LC11 0ffa .LC16 0ffe .LC2 1002 __PRETTY_FUNCTION__.12656 1016 __assert_fail 109c .LC13 10aa calloc 10b8 .LC14 10e6 _exit 10fc __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F A5 B0 04 AF 02 F0 01 04 83 46 FB 61 15 46 90 F8 94 31 BC 64 5C 07 B9 62 00 F1 AA 81 FC 69 00 2C 00 F0 60 82 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 98 06 00 F1 AE 86 DB F8 78 30 00 2B 40 F0 D6 86 3B 61 DB F8 34 20 DB F8 7C 30 52 68 3A 62 00 2B 00 F0 93 81 BC 6C 00 2C 40 F0 4D 82 DB F8 64 00 00 23 3B 66 7B 66 BB 66 FB 66 3B 67 7B 67 BB 67 FB 67 00 28 00 F0 E9 83 41 68 DB F8 68 20 DB F8 BC 30 39 66 54 68 60 18 7C 66 33 B1 5B 68 60 18 E2 08 9A 42 94 BF BA 66 BB 66 DB F8 70 30 1B B1 5B 68 11 2B 00 F0 88 83 DB F8 00 90 ?? ?2 0? 0? 05 F0 00 75 ?? ?2 0? 0? FD 60 CC 46 07 F1 60 05 38 63 BD 63 00 20 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 3D 64 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? FD 62 ?? ?2 0? 0? 07 F1 70 05 7A 62 BB 61 FD 64 04 EB 01 0A BC 6B 62 46 A5 68 0C 46 00 28 00 F0 4C 81 51 45 38 BF 01 F1 08 03 01 D3 17 E0 0B 46 13 F8 04 5C 53 F8 08 1C 16 2D 02 EB 01 00 40 F0 C5 85 DB F8 10 02 00 28 40 F0 D3 85 50 58 10 44 50 50 9A 45 03 F1 08 01 E9 D8 DB F8 00 C0 BD 6B FC 6C A5 42 40 F0 77 83 DB F8 3C 40 00 23 E1 46 3B 66 7B 66 BB 66 FB 66 3B 67 7B 67 BB 67 FB 67 00 2C 00 F0 8A 83 62 68 DB F8 40 30 DB F8 C0 10 3A 66 5B 68 9C 18 7B 66 61 B1 4A F6 AB 20 49 68 CA F6 AA 20 9C 18 A0 FB 03 50 C0 08 88 42 94 BF B8 66 B9 66 DB F8 70 10 19 B1 49 68 07 29 00 F0 55 83 ?? ?2 0? 0? 07 F1 60 05 ?? ?2 0? 0? 7D 62 FC 63 ?? ?2 0? 0? ?? ?2 0? 0? CA 46 ?? ?2 0? 0? ?? ?2 0? 0? BD 63 ?? ?2 0? 0? 7C 63 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 3D 63 FC 62 7D 6A D3 18 F8 6B DB F8 38 10 AC 68 83 45 BB 64 13 46 4D 68 04 EB 44 04 02 EB 84 04 0E D0 BA F1 00 0F 00 F0 FA 82 A2 42 08 D2 99 68 0C 33 53 F8 0C 2C 9C 42 51 44 42 F8 0A 10 F6 D8 DB F8 E4 30 00 2B 00 F0 2A 84 B8 6C 5B 68 A0 42 3B 64 40 F2 86 80 C7 F8 44 A0 AA 46 94 E8 22 00 38 6C 2A 0A ED B2 D7 F8 44 90 17 2D 4F EA 02 18 DB F8 70 31 30 F8 12 20 0A EB 08 06 89 44 FE 65 00 F0 BE 85 00 2D 67 D0 31 7B 09 09 00 F0 BF 81 DB F8 18 12 8E 42 A5 F1 11 01 00 F0 54 85 16 2D 18 BF 02 29 8C BF 00 21 01 21 01 20 29 B9 B5 F1 0D 0E DE F1 00 00 50 EB 0E 00 C2 F3 0E 02 14 2D 0C BF 02 21 00 21 01 43 CB F8 18 62 13 EB 02 13 CB F8 1C 12 03 D0 5A 68 00 2A 08 BF 00 23 5A F8 08 00 01 22 00 93 4F F0 00 0E 3B 6A 01 91 59 46 18 44 02 92 BB 6A 07 F1 5C 02 CD F8 0C E0 ?? ?? ?? ?? F9 6D 0A 46 CB F8 24 12 03 46 CB F8 20 02 00 2B 00 F0 F5 81 50 68 19 68 00 EB 01 0C 11 7B 01 F0 0F 01 0A 29 00 F0 36 85 13 2D 00 F0 EF 81 00 F2 70 81 02 2D 00 F0 87 82 40 F2 BE 81 11 2D 00 F0 75 82 12 2D 40 F0 70 82 FB 6D 03 B1 5B 68 A2 68 1A 44 C9 F8 00 20 BD 6C 0C 34 A5 42 3F F6 7D AF 7C 6A FD 6C AC 42 40 F0 D0 86 FC 69 00 2C 40 F0 A3 86 9B F8 94 31 3D 69 43 F0 04 03 8B F8 94 31 2C 46 00 2D 40 F0 16 86 DB F8 4C 32 13 B1 58 46 ?? ?? ?? ?? 84 37 BD 46 BD E8 F0 8F DB F8 44 31 00 2B 3F F4 6C AE BC 6C 00 2C 3F F4 68 AE 59 68 ?? ?2 0? 0? DB F8 00 20 ?? ?2 0? 0? 53 50 5E E6 38 6C 01 EB C5 05 DB F8 38 30 83 45 5E 68 03 D0 BC F1 00 0F 40 F0 F4 81 DB F8 E4 30 00 2B 00 F0 62 82 5B 68 AA 45 FB 63 7F F6 BA AE C7 F8 34 A0 08 35 B2 46 ?? ?2 0? 0? ?? ?2 0? 0? C7 F8 44 C0 7C 61 15 E9 12 00 F8 6B 22 0A E4 B2 D7 F8 44 90 17 2C 4F EA 02 18 DB F8 70 31 30 F8 12 20 0A EB 08 06 89 44 7E 65 00 F0 6A 84 00 2C 64 D0 31 7B 09 09 00 F0 9B 80 DB F8 18 12 8E 42 A4 F1 11 01 00 F0 3A 85 16 2C 18 BF 02 29 8C BF 00 21 01 21 01 20 29 B9 B4 F1 0D 0E DE F1 00 00 50 EB 0E 00 C2 F3 0E 02 14 2C 0C BF 02 21 00 21 01 43 CB F8 18 62 13 EB 02 13 CB F8 1C 12 03 D0 5A 68 00 2A 08 BF 00 23 5A F8 08 00 01 22 00 93 4F F0 00 0E 3B 6A 01 91 59 46 18 44 02 92 BB 6A 07 F1 54 02 CD F8 0C E0 ?? ?? ?? ?? 79 6D 0A 46 CB F8 24 12 03 46 CB F8 20 02 00 2B 00 F0 96 80 50 68 19 68 00 EB 01 0C 11 7B 01 F0 0F 01 0A 29 00 F0 1F 84 12 2C 00 F0 90 80 4C D8 02 2C 00 F0 37 81 40 F2 D2 80 0D 2C 00 F0 41 81 11 2C 40 F0 26 81 1B B1 D3 F8 40 32 C9 F8 00 30 7C 6B 05 F1 08 03 AC 42 7F F6 2E AE 1D 46 7C E7 BC 6C D0 F8 80 30 00 2B 18 BF 00 24 BC 64 97 E5 DB F8 2C 30 5B 68 5A 68 22 B1 DB F8 00 10 0A 44 CB F8 10 22 FC 69 C3 F8 04 B0 00 2C 00 F0 67 81 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 99 60 10 68 00 28 00 F0 5F 81 59 46 ?? ?? ?? ?? 00 28 00 F0 59 81 ?? ?2 0? 0? ?? ?2 0? 0? C3 F8 00 B0 51 E1 32 46 5B 46 A4 E7 16 2C 00 F2 95 80 15 2C 80 F0 E4 80 13 2C 00 F0 0C 81 14 2C 40 F0 D8 80 7B 6D 00 2B B3 D0 9A 68 B3 68 9A 42 04 D8 BC 69 21 68 E1 B1 9A 42 1A D2 F8 6A ?? ?2 0? 0? DB F8 34 40 ?? ?2 0? 0? 5A F8 08 30 02 68 02 20 64 68 12 68 23 44 7C 6A C7 F8 08 C0 00 2A 08 BF 22 46 ?? ?? ?? ?? 7A 6D B3 68 D7 F8 08 C0 92 68 48 46 61 46 9A 42 28 BF 1A 46 ?? ?? ?? ?? 87 E7 9C 46 00 2A 7F F4 6A AF 12 2C 7F F4 70 AF 7B 6D 00 2B 3F F4 7D AF 5A 68 D9 F8 00 30 13 44 C9 F8 00 30 75 E7 32 46 5B 46 80 E6 16 2D 60 D8 15 2D 80 F0 15 81 FB 6D 00 2B 3F F4 99 AE 9A 68 B3 68 9A 42 04 D8 FD 6A 29 68 E1 B1 9A 42 1A D2 78 6B ?? ?2 0? 0? DB F8 34 50 ?? ?2 0? 0? 5A F8 08 30 02 68 02 20 6D 68 12 68 2B 44 3D 6B C7 F8 08 C0 00 2A 08 BF 2A 46 ?? ?? ?? ?? FA 6D B3 68 D7 F8 08 C0 92 68 93 42 38 BF 1A 46 48 46 61 46 0C 34 ?? ?? ?? ?? BD 6C A5 42 3F F6 EB AD 6C E6 01 2C 57 D1 D9 F8 00 30 61 46 4A 46 0B F1 04 00 43 F3 17 03 9B 00 FF F7 5A FB 2A E7 A0 2C 49 D1 D9 F8 00 20 DB F8 00 30 13 44 98 47 C9 F8 00 00 1F E7 01 2D 40 F0 B5 80 A3 68 61 46 4A 46 0B F1 04 00 FF F7 44 FB BD 6C 0C 34 A5 42 3F F6 C2 AD 43 E6 A0 2D 40 F0 A5 80 BD 6B 0C 34 54 F8 04 2C DB F8 00 30 28 68 13 44 98 47 BD 6C A5 42 C9 F8 00 00 3F F6 AF AD 30 E6 9C 46 00 2A 7F F4 0B AE 13 2D 7F F4 11 AE FA 6D 00 2A 3F F4 21 AE D3 F8 3C 12 48 1C 01 28 40 F2 69 84 BD 6C 0C 34 54 F8 04 3C 52 68 A5 42 13 44 19 44 C9 F8 00 10 3F F6 91 AD 12 E6 A2 46 58 46 51 46 00 22 ?? ?? ?? ?? C9 F8 00 C0 D5 E6 3C 6C A3 45 01 BF DB F8 00 30 72 68 9B 18 C3 EB 0C 0C D9 F8 00 30 9C 44 C9 F8 00 C0 C6 E6 7A 6D 00 2A 00 F0 72 81 D9 F8 00 10 00 29 B8 BF 54 68 D3 F8 3C 22 A8 BF D9 F8 00 40 51 1C 01 29 40 F2 0A 84 22 44 3C 6B C9 F8 00 20 C9 F8 04 40 AD E6 7A 6D 00 2A 3F F4 AA AE D3 F8 3C 12 48 1C 01 28 40 F2 17 84 52 68 D9 F8 00 30 13 44 19 44 C9 F8 00 10 9B E6 A9 42 BF F4 09 AE 54 F8 08 3B A5 42 5C F8 03 20 62 44 4C F8 03 20 F6 D8 FE E5 DB F8 7C 20 DB F8 28 30 52 68 5B 68 9E 18 86 42 B8 6C 04 BF C3 EB 04 04 7C 66 10 B9 00 2C 40 F0 29 81 3A 67 BA 6C 7B 67 FA 67 61 E4 ?? ?2 0? 0? ?? ?2 0? 0? 9A 60 DB F8 44 31 00 2B 7F F4 CA AD 30 E4 DB F8 1C 11 00 29 7F F4 0C AD FF E4 AA 46 87 E7 00 2B 3F F4 92 AD BD 6C 0C 34 D3 F8 40 32 A5 42 C9 F8 00 30 3F F6 0B AD 8C E5 BD 6C 0C 34 54 F8 04 3C A5 42 63 44 C9 F8 00 30 3F F6 00 AD 81 E5 BC 6B BD 6B 21 69 10 35 E8 68 64 69 BD 63 54 E4 04 46 01 46 24 E4 DB F8 7C 00 DB F8 28 10 40 68 49 68 0D 18 A5 42 BC 6C 04 BF C1 EB 03 03 7B 66 1C B9 13 B1 0B 44 7B 66 98 E4 BD 6C 38 67 79 67 FD 67 93 E4 23 46 22 46 89 E4 AA 45 7F F6 5A AC C7 F8 3C A0 08 35 B2 46 ?? ?2 0? 0? ?? ?2 0? 0? C7 F8 44 C0 7C 63 15 E9 18 00 D7 F8 44 90 4F EA 14 28 E4 B2 17 2C 99 44 4F EA 08 18 0A EB 08 06 3E 65 00 F0 59 83 00 2C 52 D0 33 7B 1B 09 57 D0 DB F8 18 32 9E 42 A4 F1 11 03 00 F0 2F 83 16 2C 18 BF 02 2B 8C BF 00 23 01 23 01 22 1B B9 B4 F1 0D 03 5A 42 5A 41 5A F8 08 00 14 2C 0C BF 02 23 00 23 39 6A 13 43 CB F8 18 62 01 22 CB F8 1C 32 08 44 01 93 59 46 00 23 02 92 00 93 07 F1 50 02 03 93 BB 6A ?? ?? ?? ?? 39 6D 0A 46 CB F8 24 12 03 46 CB F8 20 02 00 2B 5E D0 50 68 19 68 00 EB 01 0C 11 7B 01 F0 0F 01 0A 29 00 F0 E5 82 12 2C 00 F0 6D 81 17 D8 02 2C 00 F0 5A 81 77 D9 0D 2C 4E D0 11 2C 6D D1 1B B1 D3 F8 40 32 C9 F8 00 30 FC 6B 05 F1 08 03 AC 42 7F F6 E4 AB 1D 46 92 E7 32 46 5B 46 D9 E7 16 2C 6F D8 15 2C 80 F0 6C 81 13 2C 00 F0 57 81 14 2C 53 D1 3B 6D 00 2B E7 D0 9A 68 B3 68 9A 42 04 D8 BC 69 21 68 E1 B1 9A 42 1A D2 F8 6A ?? ?2 0? 0? DB F8 34 40 ?? ?2 0? 0? 5A F8 08 30 02 68 02 20 64 68 12 68 23 44 7C 6A C7 F8 08 C0 00 2A 08 BF 22 46 ?? ?? ?? ?? 3A 6D B3 68 D7 F8 08 C0 92 68 48 46 61 46 9A 42 28 BF 1A 46 ?? ?? ?? ?? BB E7 9C 46 00 2A A7 D0 A0 E7 3A 6D 00 2A 00 F0 53 81 D9 F8 00 10 00 29 B8 BF 54 68 D3 F8 3C 22 A8 BF D9 F8 00 40 51 1C 01 29 40 F2 7A 81 22 44 3C 6B C9 F8 00 20 C9 F8 04 40 9E E7 1C 44 7C 66 FF F7 3A BB 7C 69 C9 F8 04 40 4C E5 A4 46 58 46 61 46 00 22 ?? ?? ?? ?? 01 2C F7 D1 D9 F8 00 30 61 46 4A 46 0B F1 04 00 43 F3 17 03 9B 00 FF F7 68 F9 82 E7 A0 2C E9 D1 D9 F8 00 20 DB F8 00 30 13 44 98 47 C9 F8 00 00 77 E7 B9 6C A1 42 84 BF C7 F8 40 A0 AA 46 7F F6 5A AC 94 E8 28 00 D7 F8 40 90 4F EA 15 28 ED B2 17 2D 99 44 4F EA 08 18 0A EB 08 06 BE 65 00 F0 2D 82 00 2D 56 D0 33 7B 1B 09 59 D0 DB F8 18 32 9E 42 A5 F1 11 03 00 F0 CC 82 16 2D 18 BF 02 2B 8C BF 00 23 01 23 01 22 1B B9 B5 F1 0D 03 5A 42 5A 41 5A F8 08 00 14 2D 0C BF 02 23 00 23 39 6A 13 43 CB F8 18 62 01 22 CB F8 1C 32 08 44 01 93 59 46 00 23 02 92 00 93 07 F1 58 02 03 93 BB 6A ?? ?? ?? ?? B9 6D 0A 46 CB F8 24 12 03 46 CB F8 20 02 00 2B 71 D0 50 68 19 68 00 EB 01 0C 11 7B 01 F0 0F 01 0A 29 00 F0 73 82 13 2D 00 F0 A0 80 19 D8 02 2D 00 F0 AD 80 55 D9 11 2D 00 F0 90 80 12 2D 40 F0 AB 80 BB 6D 03 B1 5B 68 A2 68 13 44 C9 F8 00 30 BD 6C 0C 34 A5 42 92 D8 FF F7 EB BB 32 46 5B 46 D7 E7 16 2D 31 D8 15 2D 80 F0 91 80 BB 6D 00 2B EE D0 9A 68 B3 68 9A 42 04 D8 FD 6A 29 68 E1 B1 9A 42 1A D2 78 6B ?? ?2 0? 0? DB F8 34 50 ?? ?2 0? 0? 5A F8 08 30 02 68 02 20 6D 68 12 68 2B 44 3D 6B C7 F8 08 C0 00 2A 08 BF 2A 46 ?? ?? ?? ?? BA 6D B3 68 D7 F8 08 C0 92 68 48 46 61 46 9A 42 28 BF 1A 46 ?? ?? ?? ?? C2 E7 A0 2D 64 D1 BD 6B A2 68 DB F8 00 30 28 68 13 44 98 47 C9 F8 00 00 B6 E7 01 2D 58 D1 61 46 4A 46 0B F1 04 00 A3 68 FF F7 99 F8 AC E7 9C 46 00 2A 94 D0 8D E7 3C 6C A3 45 01 BF DB F8 00 30 72 68 9B 18 C3 EB 0C 0C D9 F8 00 30 9C 44 C9 F8 00 C0 A0 E6 3B 6D 00 2B 3F F4 9D AE 5A 68 D9 F8 00 30 13 44 C9 F8 00 30 95 E6 3A 6D 00 2A 3F F4 92 AE D3 F8 3C 12 48 1C 01 28 40 F2 FB 81 52 68 D9 F8 00 30 13 44 19 44 C9 F8 00 10 83 E6 C9 F8 00 C0 80 E6 00 2B 3F F4 77 AF D3 F8 40 32 C9 F8 00 30 71 E7 BA 6D 00 2A 3F F4 6E AF D3 F8 3C 12 48 1C 01 28 40 F2 D5 81 52 68 A3 68 13 44 19 44 C9 F8 00 10 60 E7 A3 68 63 44 C9 F8 00 30 5B E7 AC 46 CA E6 7C 6B C9 F8 04 40 5C E6 0D 2D 40 F0 9C 81 41 68 21 B1 DB F8 1C 11 00 29 00 F0 9A 81 DB F8 48 11 DB F8 00 40 49 68 21 44 41 60 FF F7 30 BA 50 50 FF F7 2D BA 7C 6C DB F8 00 30 62 58 13 44 63 50 FF F7 F5 BB D2 89 00 2A 3F F4 DD AB F8 68 00 28 7F F4 D9 AB ?? ?2 0? 0? ?? ?2 0? 0? 10 68 BB 60 E0 47 BB 68 84 46 FF F7 CE BB 18 46 BB 60 ?? ?? ?? ?? BB 68 D3 F8 3C 22 7D E6 16 2D 18 BF 02 29 98 BF 01 20 8C BF 00 21 01 21 98 BF B8 61 06 D9 B5 F1 0D 0C DC F1 00 00 50 EB 0C 00 B8 61 B8 69 14 2D 0C BF 4F F0 02 0C 4F F0 00 0C 4C EA 00 0C DB F8 1C 02 84 45 7F F4 92 AA DB F8 24 12 DB F8 20 32 0A 46 F9 65 FF F7 BD BA D2 89 00 2A 3F F4 C6 AA F8 68 00 28 7F F4 C2 AA B9 6B 08 68 BB 60 E0 47 BB 68 84 46 FF F7 BA BA DB F8 04 10 0B 78 63 B9 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 12 68 11 68 00 29 08 BF 19 46 BC 6C ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 00 2C 18 BF 1A 46 ?? ?2 0? 0? ?? ?? ?? ?? FF F7 2D B9 7D 6C A2 68 DB F8 00 30 13 44 6B 50 FF F7 A4 BA BB F8 58 21 DB F8 50 31 03 EB 42 11 8B 42 48 D2 ?? ?2 0? 0? 46 F2 40 29 00 20 ?? ?2 0? 0? C7 F2 51 39 03 F1 20 04 38 61 05 E0 03 EB 42 11 20 34 8A 45 BF F4 10 A9 54 F8 20 1C A2 46 01 29 F4 D1 54 F8 08 1C 89 07 F0 D4 D8 F8 00 20 86 B0 54 F8 18 3C 04 AE 54 F8 0C 1C 50 1E 18 44 52 42 08 44 DB F8 00 10 13 40 02 40 D2 1A 0B 44 72 60 11 46 18 46 03 22 33 60 ?? ?? ?? ?? 00 28 3D DB 54 F8 08 2C 38 69 02 F0 07 01 DB F8 50 31 BB F8 58 21 89 00 F0 60 49 FA 01 F1 3E 61 01 F0 0F 01 B1 60 C3 E7 00 24 3C 61 FF F7 D6 B8 16 2C 18 BF 02 29 98 BF 01 20 8C BF 00 21 01 21 98 BF 78 60 06 D9 B4 F1 0D 0C DC F1 00 00 50 EB 0C 00 78 60 78 68 14 2C 0C BF 4F F0 02 0C 4F F0 00 0C 4C EA 00 0C DB F8 1C 02 84 45 7F F4 AC AA DB F8 24 12 DB F8 20 32 0A 46 79 65 FF F7 D7 BA ?? ?2 0? 0? ?? ?2 0? 0? 82 48 1D EE 70 4F DB F8 04 10 00 22 78 44 00 68 20 58 ?? ?? ?? ?? 3D 6C A1 68 DB F8 00 20 0A 44 EA 50 24 E6 D2 89 00 2A 3F F4 17 AD FA 68 00 2A 7F F4 13 AD ?? ?2 0? 0? ?? ?2 0? 0? 10 68 BB 60 E0 47 BB 68 84 46 08 E5 16 2C 18 BF 02 2B 8C BF 00 23 01 23 98 BF 01 22 03 D9 B4 F1 0D 01 4A 42 4A 41 14 2C 0C BF 02 20 00 20 DB F8 1C 12 02 43 8A 42 7F F4 C0 AC DB F8 24 12 DB F8 20 32 0A 46 39 65 DE E4 7C 6C DB F8 00 20 E1 58 0A 44 E2 50 F4 E4 18 46 BB 60 ?? ?? ?? ?? BB 68 D3 F8 3C 22 FF F7 ED BB 94 E8 07 00 ?? ?? ?? ?? 00 28 22 DB 20 68 4F F0 02 0C 61 68 C0 F2 0F 0C 00 22 01 44 ?? ?? ?? ?? E4 68 00 2C 3F F4 D6 A9 EA E7 18 46 BB 60 ?? ?? ?? ?? BB 68 7A 6D D3 F8 3C 12 FF F7 DF BB 18 46 BB 60 ?? ?? ?? ?? BB 68 FA 6D D3 F8 3C 12 FF F7 8D BB ?? ?2 0? 0? ?? ?2 0? 0? 7F E7 58 46 29 46 01 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 }
	condition:
		$1
}

rule file_558_0_0 {
	meta:
		name = "__pselect"
		size = 300
		refs = "0024 __libc_multiple_threads 0046 __libc_do_syscall 0096 __sigprocmask 00a8 __select 00be __libc_enable_asynccancel 00e0 __libc_disable_asynccancel 011c __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F AB B0 83 46 8A 46 34 9E 91 46 98 46 35 9F 34 46 36 B1 04 AB 96 E8 03 00 1C 46 1E 46 83 E8 03 00 ?? ?2 0? 0? 08 22 ?? ?2 0? 0? 06 97 07 92 1B 68 00 2B 42 D1 58 46 51 46 4A 46 43 46 06 AD 40 F2 4F 1C ?? ?? ?? ?? 10 F5 80 5F 4A D8 04 46 63 1C 03 D0 20 46 2B B0 BD E8 F0 8F 2F 4B 1D EE 70 2F 7B 44 1B 68 D3 58 26 2B F3 D1 76 B1 73 68 00 2B 41 DB 44 F6 D3 52 D8 17 C1 F2 62 02 31 68 82 FB 03 43 08 91 C0 EB A3 13 09 93 27 B1 02 20 39 46 0A AA ?? ?? ?? ?? 06 B1 08 AE 00 96 58 46 51 46 4A 46 43 46 ?? ?? ?? ?? 04 46 00 2F D1 D0 0A A9 00 22 02 20 ?? ?? ?? ?? CB E7 ?? ?? ?? ?? 06 AD 51 46 4A 46 43 46 40 F2 4F 1C 03 90 58 46 ?? ?? ?? ?? 10 F5 80 5F 04 46 13 D8 03 98 ?? ?? ?? ?? B5 E7 0E 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 AA E7 0A 4B 16 21 7B 44 1B 68 D1 50 A7 E7 08 4B 1D EE 70 2F 41 42 4F F0 FF 34 7B 44 1B 68 D1 50 E1 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "setsourcefilter"
		size = 224
		refs = "003c memcpy 005e __get_sol 0070 __setsockopt 00a0 free 00b2 __libc_alloca_cutoff 00c6 malloc 00dc __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 85 B0 02 AF 83 46 8C 46 7C 6B 91 46 1E 46 4F EA C4 18 08 F1 8C 05 B5 F5 80 5F 46 D8 05 F1 0E 02 4F F0 01 0A 22 F0 07 02 AD EB 02 0D 02 AC 20 46 49 46 32 46 40 F8 04 CB ?? ?? ?? ?? 3B 6B 42 46 B9 6B 04 F1 8C 00 C4 F8 84 30 7B 6B C4 F8 88 30 ?? ?? ?? ?? 31 46 B9 F8 00 00 ?? ?? ?? ?? 43 1C 01 46 0E D0 00 95 58 46 30 22 23 46 ?? ?? ?? ?? 05 46 28 46 BA F1 00 0F 0F D0 0C 37 BD 46 BD E8 F0 8F 15 4B 1D EE 70 2F 05 46 16 21 7B 44 1B 68 28 46 D1 50 BA F1 00 0F EF D1 20 46 ?? ?? ?? ?? 28 46 0C 37 BD 46 BD E8 F0 8F 28 46 79 60 ?? ?? ?? ?? D7 F8 04 C0 82 46 00 28 AF D1 28 46 C7 F8 04 C0 ?? ?? ?? ?? D7 F8 04 C0 04 46 00 28 AE D1 4F F0 FF 30 D1 E7 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_561_0_0 {
	meta:
		name = "isblank"
		size = 28
		refs = "0018 __libc_tsd_CTYPE_B"
	strings:
		$1 = { 05 4B 1D EE 70 2F 7B 44 1B 68 D3 58 33 F8 10 00 00 F0 01 00 70 47 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_561_1_0 {
	meta:
		name = "_tolower"
		size = 28
		refs = "0018 _nl_current_LC_CTYPE"
	strings:
		$1 = { 05 4B 1D EE 70 2F 80 30 7B 44 1B 68 D3 58 1B 68 1B 6B 53 F8 20 00 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_561_2_0 {
	meta:
		name = "_toupper"
		size = 28
		refs = "0018 _nl_current_LC_CTYPE"
	strings:
		$1 = { 05 4B 1D EE 70 2F 80 30 7B 44 1B 68 D3 58 1B 68 9B 6A 53 F8 20 00 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_562_0_0 {
	meta:
		name = "__wcpncpy_chk"
		size = 18
		refs = "000e __chk_fail 000a __wcpncpy"
	strings:
		$1 = { 93 42 08 B5 03 D3 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1354_0_0 {
	meta:
		name = "__confstr_chk"
		size = 18
		refs = "000e __chk_fail 000a confstr"
	strings:
		$1 = { 93 42 08 B5 03 D3 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_815_0_0 {
	meta:
		name = "__wcsncpy_chk"
		size = 18
		refs = "000e __chk_fail 000a __wcsncpy"
	strings:
		$1 = { 93 42 08 B5 03 D3 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_849_0_0 {
	meta:
		name = "__wmemset_chk"
		size = 18
		refs = "000e __chk_fail 000a wmemset"
	strings:
		$1 = { 93 42 08 B5 03 D3 BD E8 08 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_563_0_0 {
	meta:
		name = "__strncasecmp_l"
		size = 64
	strings:
		$1 = { 00 2A 18 BF 88 42 F0 B4 08 BF 00 20 10 D0 9F 6B 46 1E 02 E0 75 B1 01 3A 0F D0 16 F8 01 5F 11 F8 01 0B 57 F8 25 30 57 F8 20 40 1B 1B F2 D0 18 46 F0 BC 70 47 28 46 F0 BC 70 47 10 46 F0 BC 70 47 }
	condition:
		$1
}

rule file_566_1_0 {
	meta:
		name = "strtold"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0014 ____strtold_l_internal"
	strings:
		$1 = { 05 4B 00 22 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1112_1_0 {
	meta:
		name = "strtod"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0014 ____strtod_l_internal"
	strings:
		$1 = { 05 4B 00 22 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_746_1_0 {
	meta:
		name = "strtof"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0014 ____strtof_l_internal"
	strings:
		$1 = { 05 4B 00 22 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1101_1_0 {
	meta:
		name = "wcstod"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0014 ____wcstod_l_internal"
	strings:
		$1 = { 05 4B 00 22 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1034_1_0 {
	meta:
		name = "wcstof"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0014 ____wcstof_l_internal"
	strings:
		$1 = { 05 4B 00 22 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_956_1_0 {
	meta:
		name = "wcstold"
		size = 28
		refs = "0018 __libc_tsd_LOCALE 0014 ____wcstold_l_internal"
	strings:
		$1 = { 05 4B 00 22 10 B4 1D EE 70 4F 7B 44 1B 68 E3 58 5D F8 04 4B ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_567_0_0 {
	meta:
		name = "__new_semctl"
		size = 68
		refs = "0018 __libc_do_syscall 0040 __libc_errno"
	strings:
		$1 = { 0C B4 4F F4 96 7C 10 B5 82 B0 04 AC 05 9B 54 F8 04 2B 42 F4 80 72 01 94 ?? ?? ?? ?? 10 F5 80 5F 04 D8 02 B0 BD E8 10 40 02 B0 70 47 04 4B 1D EE 70 2F 41 42 4F F0 FF 30 7B 44 1B 68 D1 50 F0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_1_0 {
	meta:
		name = "clntudp_freeres"
		size = 18
	strings:
		$1 = { 80 68 0B 46 10 B5 11 46 02 24 40 F8 38 4F 98 47 10 BD }
	condition:
		$1
}

rule file_570_3_0 {
	meta:
		name = "clntudp_control"
		size = 258
	strings:
		$1 = { 01 39 83 68 30 B4 14 46 82 B0 0E 29 77 D8 DF E8 01 F0 17 1E 25 2B 32 39 76 3D 40 44 53 60 65 71 08 00 20 68 02 AA 99 6D 01 25 00 90 00 9B 1B BA 42 F8 04 3D 10 68 C8 60 28 46 02 B0 30 BC 70 47 94 E8 03 00 24 33 01 25 83 E8 03 00 F4 E7 24 33 01 25 93 E8 03 00 84 E8 03 00 ED E7 08 33 01 25 0F CB 84 E8 0F 00 E7 E7 94 E8 03 00 1C 33 01 25 83 E8 03 00 E0 E7 1C 33 01 25 93 E8 03 00 84 E8 03 00 D9 E7 1B 68 01 25 23 60 D5 E7 01 25 5D 60 D2 E7 00 22 01 25 5A 60 CE E7 9A 6D 01 25 02 AB 10 68 01 90 01 9A 12 BA 43 F8 08 2D 18 68 20 60 28 46 02 B0 30 BC 70 47 20 68 02 AA 99 6D 01 25 00 90 00 9B 01 3B 1B BA 42 F8 04 3D 10 68 08 60 B2 E7 9A 6D 01 25 02 AB 10 69 E2 E7 20 68 02 AA 99 6D 01 25 00 90 00 9B 1B BA 42 F8 04 3D 10 68 08 61 A1 E7 9A 6D 01 25 02 AB D0 68 D1 E7 00 25 9A E7 }
	condition:
		$1
}

rule file_570_4_0 {
	meta:
		name = "clntudp_destroy"
		size = 46
		refs = "0018 free 0028 __close"
	strings:
		$1 = { 38 B5 05 46 84 68 63 68 6B B9 E3 6B DB 69 13 B1 04 F1 38 00 98 47 20 46 ?? ?? ?? ?? 28 46 BD E8 38 40 ?? ?? ?? ?? 20 68 ?? ?? ?? ?? ED E7 }
	condition:
		$1
}

rule file_570_5_0 {
	meta:
		name = "clntudp_call"
		size = 1168
		refs = "001e _null_auth 0106 __sendto 016c __poll 0188 getifaddrs 01b4 freeifaddrs 01fc __recvfrom 021c memcmp 023c xdrmem_create 0248 xdr_replymsg 025a _seterr_reply 030a __recvmsg 0472 xdr_opaque_auth 0484 __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F B9 B0 80 46 02 AF 44 F6 D3 50 D8 F8 08 B0 C1 F2 62 00 7B 62 4F F4 7A 74 7A 63 ?? ?2 0? 0? DB F8 20 30 ?? ?2 0? 0? DB F8 28 50 0B F1 38 09 DB F8 1C 20 80 FB 03 60 3D 63 DB 17 01 35 C7 F8 28 A0 DA 46 14 BF DB F8 24 50 D7 F8 08 51 C3 EB A0 13 0C BF D7 F8 0C 61 FD 62 04 FB 02 33 08 BF FD 62 44 F2 3F 25 08 BF 3E 63 C0 F2 0F 05 0B F1 60 06 C3 46 A8 46 00 24 BE 61 F9 63 03 26 FB 61 3C 62 BC 63 7E 61 7D 6B 00 2D 47 D0 DA F8 3C 30 00 22 DA F8 50 10 48 46 CA F8 38 20 5B 69 98 47 DA F8 58 50 DA F8 3C 20 48 46 07 F1 3C 01 2B 68 52 68 01 33 2B 60 90 47 00 28 00 F0 FC 80 DB F8 00 30 49 46 18 46 1B 6A 5B 68 98 47 00 28 00 F0 F2 80 48 46 79 6A 7E 6B B0 47 00 28 00 F0 EB 80 DA F8 3C 30 48 46 1B 69 98 47 05 46 DA F8 00 00 0A F1 08 03 DA F8 58 10 2A 46 00 93 00 23 DA F8 18 60 01 96 ?? ?? ?? ?? A8 42 B8 63 40 F0 62 81 FD 6A 1D B9 3E 6B 00 2E 00 F0 69 81 BD 6A 07 F1 B4 03 D7 F8 04 61 FC 60 95 E8 07 00 D7 F8 00 51 C7 F8 C4 60 BE 6B C7 F8 C8 50 06 F5 87 75 C7 F8 08 90 25 F0 07 05 7D 60 55 46 83 E8 07 00 01 22 55 F8 0C 3B A7 F8 48 20 7B 64 43 46 D0 46 9A 46 3D 61 07 F1 44 00 01 21 FA 69 ?? ?? ?? ?? 44 1C 00 F0 8A 80 30 BB 53 46 07 F1 8C 00 C2 46 FC 68 D7 F8 08 90 98 46 ?? ?? ?? ?? 00 28 40 F0 91 80 D7 F8 8C 00 60 B1 03 46 9A 68 D1 07 05 D5 DA 68 1A B1 12 88 02 2A 00 F0 F2 80 1B 68 00 2B F3 D1 D3 46 ?? ?? ?? ?? 04 20 CB F8 2C 00 DC 37 BD 46 BD E8 F0 8F B7 F8 4A 30 1A 07 78 D4 07 F1 54 04 07 F1 40 06 10 25 D7 F8 18 90 05 E0 A9 4B 7B 44 1B 68 D3 58 04 2B 61 D1 D8 F8 00 00 49 46 D8 F8 5C 20 40 23 8D E8 50 00 3D 64 ?? ?? ?? ?? 1D EE 70 2F 00 28 EA DB 03 28 03 46 AA DD 7E 6B 4E B1 D8 F8 58 10 04 22 B8 69 3B 60 ?? ?? ?? ?? 3B 68 00 28 9E D1 52 46 07 F1 74 00 B9 69 C2 46 90 46 1A 46 01 23 FC 68 D7 F8 08 90 ?? ?? ?? ?? 07 F1 74 00 07 F1 A8 01 ?? ?? ?? ?? 00 28 00 F0 15 81 07 F1 A8 00 0A F1 2C 01 ?? ?? ?? ?? DA F8 2C 00 00 28 00 F0 E9 80 7D 69 01 3D 7D 61 A6 D0 DB F8 00 30 18 46 1B 6A DB 68 98 47 00 28 7F F4 03 AF D3 46 DB F8 2C 00 99 E7 7F 4B 1D EE 70 2F 7B 44 1B 68 D3 58 04 2B 3F F4 64 AF 04 20 C8 F8 30 30 C8 F8 2C 00 DC 37 BD 46 BD E8 F0 8F 0B 2B F4 D1 57 E7 D3 46 7F E7 01 20 CA F8 2C 00 7E E7 7D 68 10 22 BE 6B 00 21 AD EB 05 0D C7 F8 90 20 C7 F8 A4 10 01 22 07 F1 8C 01 C7 F8 98 20 4F F4 80 72 C7 F8 A0 20 4F F4 00 52 D8 F8 00 00 02 AB 07 F1 64 05 C7 F8 9C 30 42 AC C7 F8 8C 50 07 F1 4C 03 3E 65 FC 64 C7 F8 94 30 ?? ?? ?? ?? 05 1E FF F6 5D AF 20 46 D8 F8 58 10 2A 46 ?? ?? ?? ?? 00 28 7F F4 54 AF D7 F8 A4 30 9B 04 7F F5 4F AF D7 F8 90 30 00 2B 5F D1 0B 2D 7F F7 48 AF D7 F8 A0 20 D7 F8 9C 00 0B 2A 98 BF 00 23 10 44 88 BF D7 F8 9C 30 00 2B 3F F4 3A AF 5A 68 12 B9 9A 68 0B 2A 62 D0 1A 68 D1 1C 0B 2A 21 F0 03 02 13 44 7F F6 2D AF 03 F1 0C 02 90 42 FF F4 28 AF 1A 68 03 32 22 F0 03 02 1A 44 90 42 FF F4 20 AF E1 E7 ?? ?? ?? ?? DA F8 20 20 DA F8 1C 30 14 44 3E 6A 44 45 1E 44 3E 62 C4 BF 3D 6A 6B 1C 08 DD A4 F5 74 24 1A 46 A4 F5 10 74 01 33 44 45 F7 DC 3A 62 FE 6A 3D 6A AE 42 04 DC B5 42 11 D1 3E 6B A6 42 0E DD BD 6B 8B E6 2D 4B 1D EE 70 1F 03 22 7B 44 1B 68 10 46 CA F8 2C 20 CB 58 CA F8 30 30 E6 E6 05 20 CA F8 2C 00 E2 E6 10 2B 7F F4 E8 AE B7 F8 64 30 02 2B 7F F4 E3 AE 07 F1 68 00 39 69 04 22 ?? ?? ?? ?? 00 28 7F F4 DA AE B7 F8 66 20 B8 F8 0A 30 9A 42 7F F4 D3 AE 89 E7 DA 68 04 23 18 46 C8 F8 2C 30 C8 F8 30 20 C1 E6 D8 46 07 F1 B4 01 D3 46 D8 F8 00 30 18 46 1B 6A 9B 68 98 47 28 B9 07 22 06 23 CA F8 2C 20 CA F8 30 30 D7 F8 B8 30 00 2B 3F F4 0F AF 02 23 48 46 07 F1 B4 01 CB F8 38 30 ?? ?? ?? ?? DB F8 2C 00 A0 E6 02 20 CA F8 2C 00 9C E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_6_0 {
	meta:
		name = "__libc_clntudp_bufcreate"
		size = 576
		refs = "0018 malloc 0052 pmap_getport 005a free 00a2 .LANCHOR0 00c8 _create_xid 00e6 xdrmem_create 00ee xdr_callhdr 0110 authnone_create 011a __rpc_thread_createerr 011e .LC0 012a _libc_intl_domainname 0132 __dcgettext 0136 .LC1 013a .LC2 014a __fxprintf 015a __have_sock_cloexec 016e __socket 0186 bindresvport 01a4 __setsockopt 01f2 __ioctl 0216 __fcntl 0238 __libc_errno"
	strings:
		$1 = { 82 B0 2D E9 F0 4F 93 B0 81 46 0C 20 21 9C 88 46 20 9E 03 92 03 34 1D 93 ?? ?? ?? ?? 24 F0 03 07 03 36 26 F0 03 06 05 46 07 F1 64 00 30 44 ?? ?? ?? ?? 00 2D 18 BF 00 28 04 46 6E D0 B9 F8 02 30 07 F1 60 02 02 44 82 65 D3 B9 48 46 41 46 03 9A 11 23 ?? ?? ?? ?? 70 B9 20 46 ?? ?? ?? ?? 2B 46 1D B1 28 46 ?? ?? ?? ?? 00 23 18 46 13 B0 BD E8 F0 4F 02 B0 70 47 03 02 43 EA 10 20 A9 F8 02 00 99 E8 0F 00 04 F1 08 0E 0D F1 74 09 04 F1 1C 0B 4F F0 10 0A AC 60 8E E8 0F 00 4F F0 FF 32 99 E8 03 00 ?? ?2 0? 0? C4 F8 18 A0 ?? ?2 0? 0? 6B 60 4F F0 00 0A 8B E8 03 00 04 F1 38 09 66 65 4F F0 02 0B 62 62 A2 62 E7 65 ?? ?? ?? ?? 32 46 03 9E 53 46 A1 6D CD F8 24 80 0A 96 CD F8 1C A0 CD F8 20 B0 06 90 48 46 ?? ?? ?? ?? 48 46 06 A9 ?? ?? ?? ?? 00 28 B0 D0 E3 6B 48 46 1B 69 98 47 1F 99 20 65 0B 68 53 45 A8 BF C4 F8 04 A0 25 DB 23 60 ?? ?? ?? ?? 2B 46 28 60 A7 E7 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? 05 22 06 46 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 03 46 00 20 ?? ?? ?? ?? 0C 23 33 60 B3 60 00 2C 82 D0 7E E7 ?? ?2 0? 0? ?? ?2 0? 0? 33 68 53 45 23 DA 02 20 11 22 01 46 ?? ?? ?? ?? 1F 9A 22 99 10 60 0A 03 03 46 49 D4 00 2B 4E DB 18 46 00 21 ?? ?? ?? ?? 33 68 00 2B A8 BF 05 AB 24 DB 1F 99 04 22 01 26 05 96 08 68 00 21 00 92 0B 22 ?? ?? ?? ?? 1F 9A 66 60 13 68 AE E7 22 9A 58 46 42 F4 00 61 11 22 41 F0 02 01 ?? ?? ?? ?? 1F 9B 18 60 33 68 23 B9 00 28 A8 BF 01 23 13 DB 33 60 00 2B C7 DB 1F 99 0B 68 CF E7 1F 9E 12 AB 01 22 45 F2 21 41 43 F8 34 2D 1A 46 30 68 02 93 ?? ?? ?? ?? 02 9B CC E7 0F 4B 1D EE 70 2F 7B 44 1B 68 D3 58 16 2B 0C BF 4F F0 FF 33 01 23 DF E7 01 22 02 21 ?? ?? ?? ?? 1F 9A 13 68 AE E7 ?? ?? ?? ?? 05 4B 0C 21 1D EE 70 2F 01 60 7B 44 1B 68 D3 58 83 60 0F E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_570_7_0 {
	meta:
		name = "clntudp_bufcreate"
		size = 42
		refs = "001c __libc_clntudp_bufcreate"
	strings:
		$1 = { 82 B0 F0 B5 87 B0 00 24 11 9D 0F 9F 10 9E 03 95 0E 9D 01 97 02 96 00 95 04 94 0D 93 ?? ?? ?? ?? 07 B0 BD E8 F0 40 02 B0 70 47 }
	condition:
		$1
}

rule file_570_8_0 {
	meta:
		name = "clntudp_create"
		size = 42
		refs = "001c __libc_clntudp_bufcreate"
	strings:
		$1 = { 82 B0 F0 B5 87 B0 42 F2 60 24 00 27 0F 9E 0E 9D 02 94 03 94 8D E8 60 00 04 97 0D 93 ?? ?? ?? ?? 07 B0 BD E8 F0 40 02 B0 70 47 }
	condition:
		$1
}

rule file_571_0_0 {
	meta:
		name = "__getnetbyaddr_r"
		size = 404
		refs = "0004 .LANCHOR0 004a __nss_next2 0054 _dl_mcount_wrapper_check 0074 .LC0 0100 __nss_networks_lookup2 012c __res_maybe_init 0178 __libc_errno 0180 __libc_resp"
	strings:
		$1 = { 2D E9 F0 4F ?? ?2 0? 0? ?? ?2 0? 0? 89 B0 17 46 80 46 22 78 89 46 9A 46 14 9D 00 2A 6A D0 62 68 1D EE 70 6F A1 68 B2 F1 FF 3C DC F1 00 03 06 92 53 EB 0C 03 07 91 00 2B 40 F0 82 80 DF F8 4C B1 04 97 06 E0 00 27 00 94 01 97 ?? ?? ?? ?? 00 28 38 D1 07 98 ?? ?? ?? ?? 12 9F 5B 46 07 9C 49 46 04 9A 00 97 7B 44 1B 68 33 44 02 95 01 93 40 46 53 46 A0 47 ?? ?2 0? 0? ?? ?2 0? 0? 00 22 07 AB 04 46 06 A8 A7 1C DD D1 2F 68 01 37 DA D1 DF F8 00 C1 FC 44 DC F8 00 C0 56 F8 0C C0 BC F1 22 0F D0 D1 13 9F 01 2C 4F F0 00 02 3A 60 10 D9 32 4B 7B 44 1B 68 F0 58 22 28 12 D0 02 34 14 D0 09 B0 BD E8 F0 8F 01 2C 04 9F EB D1 13 99 00 22 0F 60 2A 4B 10 46 7B 44 1B 68 F2 50 09 B0 BD E8 F0 8F 02 34 18 BF 16 22 F3 D1 2B 68 01 33 18 BF 0B 22 EE D1 E4 E7 ?? ?2 0? 0? 07 AB ?? ?2 0? 0? 06 A8 ?? ?? ?? ?? 03 46 48 B1 1D EE 70 6F 4F F0 FF 32 62 60 BF F3 5F 8F 01 22 22 70 8C E7 18 4A 1D EE 70 6F 01 46 7A 44 12 68 B0 58 05 93 ?? ?? ?? ?? 43 1C 05 9B 17 D0 07 99 06 9A A1 60 62 60 E8 E7 13 9F 00 22 0F 4B 3A 60 7B 44 1B 68 F3 58 02 2B 1E BF 4F F0 FF 33 2B 60 1C 46 A8 D1 03 23 4F F0 FF 34 2B 60 A3 E7 13 9F 07 4A 28 60 3B 60 7A 44 12 68 B0 58 A3 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_574_1_0 {
	meta:
		name = "xdr_keybuf"
		size = 16
		refs = "0004 xdr_opaque"
	strings:
		$1 = { 08 B5 30 22 ?? ?? ?? ?? 00 30 18 BF 01 20 08 BD }
	condition:
		$1
}

rule file_18_3_4 {
	meta:
		name = "_ZSt18uncaught_exceptionv"
		size = 16
		refs = "0002 __cxa_get_globals"
	strings:
		$1 = { 08 B5 ?? ?? ?? ?? 40 68 00 30 18 BF 01 20 08 BD }
	condition:
		$1
}

rule file_574_2_0 {
	meta:
		name = "xdr_netnamestr"
		size = 16
		refs = "0004 xdr_string"
	strings:
		$1 = { 08 B5 FF 22 ?? ?? ?? ?? 00 30 18 BF 01 20 08 BD }
	condition:
		$1
}

rule file_574_3_0 {
	meta:
		name = "xdr_cryptkeyarg"
		size = 30
		refs = "0008 xdr_string 0012 xdr_des_block"
	strings:
		$1 = { 38 B5 FF 22 05 46 0C 46 ?? ?? ?? ?? 30 B1 28 46 21 1D ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_574_4_0 {
	meta:
		name = "xdr_cryptkeyarg2"
		size = 46
		refs = "0008 xdr_string 0012 xdr_netobj 0022 xdr_des_block"
	strings:
		$1 = { 38 B5 FF 22 04 46 0D 46 ?? ?? ?? ?? 20 B1 20 46 29 1D ?? ?? ?? ?? 08 B9 00 20 38 BD 20 46 05 F1 0C 01 ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_574_5_0 {
	meta:
		name = "xdr_cryptkeyres"
		size = 38
		refs = "0006 xdr_enum 001a xdr_des_block"
	strings:
		$1 = { 38 B5 05 46 0C 46 ?? ?? ?? ?? 18 B1 23 68 13 B1 01 20 38 BD 38 BD 28 46 21 1D ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_574_7_0 {
	meta:
		name = "xdr_getcredres"
		size = 38
		refs = "0006 xdr_enum 001a xdr_unixcred"
	strings:
		$1 = { 38 B5 05 46 0C 46 ?? ?? ?? ?? 18 B1 23 68 13 B1 01 20 38 BD 38 BD 28 46 21 1D ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_574_9_0 {
	meta:
		name = "xdr_key_netstres"
		size = 38
		refs = "0006 xdr_enum 001a xdr_key_netstarg"
	strings:
		$1 = { 38 B5 05 46 0C 46 ?? ?? ?? ?? 18 B1 23 68 13 B1 01 20 38 BD 38 BD 28 46 21 1D ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_574_6_0 {
	meta:
		name = "xdr_unixcred"
		size = 72
		refs = "0008 xdr_u_int 003a xdr_array"
	strings:
		$1 = { 30 B5 83 B0 05 46 0C 46 ?? ?? ?? ?? 10 B9 00 20 03 B0 30 BD 28 46 21 1D ?? ?? ?? ?? 00 28 F6 D0 ?? ?2 0? 0? 28 46 ?? ?2 0? 0? 04 22 01 93 04 F1 0C 01 00 92 10 23 04 F1 08 02 ?? ?? ?? ?? 00 30 18 BF 01 20 03 B0 30 BD }
	condition:
		$1
}

rule file_574_8_0 {
	meta:
		name = "xdr_key_netstarg"
		size = 52
		refs = "0008 xdr_opaque 0028 xdr_string"
	strings:
		$1 = { 38 B5 30 22 05 46 0C 46 ?? ?? ?? ?? 30 B1 28 46 04 F1 30 01 30 22 ?? ?? ?? ?? 08 B9 00 20 38 BD 28 46 04 F1 60 01 FF 22 ?? ?? ?? ?? 00 30 18 BF 01 20 38 BD }
	condition:
		$1
}

rule file_576_0_0 {
	meta:
		name = "__bb_init_func"
		size = 70
		refs = "0004 __bb_head 001a _gmonparam 0028 __dso_handle 0034 _mcleanup 003e __cxa_atexit"
	strings:
		$1 = { 03 68 4B B9 ?? ?2 0? 0? 01 22 ?? ?2 0? 0? 02 60 1A 68 18 60 02 61 02 B1 70 47 ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 00 2B F7 D0 ?? ?2 0? 0? ?? ?2 0? 0? 3B B1 1A 68 ?? ?2 0? 0? 00 21 ?? ?2 0? 0? ?? ?? ?? ?? 1A 46 F6 E7 }
	condition:
		$1
}

rule file_577_0_0 {
	meta:
		name = "sigset"
		size = 220
		refs = "002a memset 0036 __sigaction 005e __sigprocmask 00d8 __libc_errno"
	strings:
		$1 = { 02 29 0B 46 70 B5 05 46 AD F5 06 7D 3E D0 B1 F1 FF 32 46 1E 54 42 54 41 3F 2E 88 BF 44 F0 01 04 44 BB 21 46 80 22 41 A8 40 93 ?? ?? ?? ?? 40 A9 28 46 63 AA 61 94 ?? ?? ?? ?? 00 28 45 DB 21 46 80 22 68 46 74 09 ?? ?? ?? ?? 01 23 06 F0 1F 06 18 46 69 46 20 AA 03 FA 06 F6 4D F8 24 60 ?? ?? ?? ?? 00 28 31 DB 20 AA 52 F8 24 30 1E 42 31 D1 63 98 08 E0 18 4B 1D EE 70 2F 4F F0 FF 30 16 21 7B 44 1B 68 D1 50 0D F5 06 7D 70 BD 00 21 80 22 68 46 01 24 ?? ?? ?? ?? 6B 1E 69 46 20 AA 5E 09 00 20 03 F0 1F 03 9C 40 4D F8 26 40 ?? ?? ?? ?? 00 28 0A DB 20 AA 52 F8 26 10 21 40 0A D1 28 46 63 AA ?? ?? ?? ?? 00 28 D2 DA 4F F0 FF 30 0D F5 06 7D 70 BD 02 20 D6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_578_0_0 {
	meta:
		name = "remove"
		size = 52
		refs = "0004 __unlink 001c __rmdir 0030 __libc_errno"
	strings:
		$1 = { 10 B5 04 46 ?? ?? ?? ?? 88 B1 09 4B 1D EE 70 2F 7B 44 1B 68 D3 58 15 2B 07 D1 20 46 ?? ?? ?? ?? 00 38 18 BF 6F F0 00 00 10 BD 4F F0 FF 30 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_579_0_0 {
	meta:
		name = "strtok"
		size = 78
		refs = "0002 .LANCHOR0 0014 strspn 0022 strpbrk 003c __rawmemchr"
	strings:
		$1 = { F8 B5 ?? ?2 0? 0? 04 46 0F 46 ?? ?2 0? 0? 90 B1 20 46 39 46 ?? ?? ?? ?? 26 18 20 5C 98 B1 39 46 30 46 ?? ?? ?? ?? 01 46 38 B1 00 23 30 46 01 F8 01 3B 29 60 F8 BD 2C 68 EA E7 30 46 ?? ?? ?? ?? 28 60 30 46 F8 BD 2E 60 06 46 30 46 F8 BD }
	condition:
		$1
}

rule file_580_0_0 {
	meta:
		name = "fputws"
		size = 292
		refs = "0006 __wcslen 0050 _IO_fwide 00c0 __libc_do_syscall 00c6 __lll_lock_wait_private 0120 _Unwind_Resume"
	strings:
		$1 = { F8 B5 0C 46 07 46 ?? ?? ?? ?? 23 68 19 04 05 46 1C D4 A0 6C 1D EE 70 6F A6 F5 98 66 82 68 B2 42 11 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 00 2A 42 D1 A2 6C 10 46 96 60 42 68 01 32 42 60 20 46 01 21 ?? ?? ?? ?? 01 28 26 D1 D4 F8 98 30 39 46 20 46 2A 46 DB 69 98 47 85 42 1D D1 01 25 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 04 DC 28 46 F8 BD 4F F0 FF 35 DF E7 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? ED E7 ?? ?? ?? ?? B9 E7 23 68 05 46 1B 04 24 D4 A3 6C 5A 68 01 3A 5A 60 FA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 0C DD 1D EE 70 1F 01 22 A1 F5 98 61 18 46 4F F0 F0 0C 00 23 89 68 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_582_0_0 {
	meta:
		name = "inet_ntoa"
		size = 60
		refs = "000e .LC0 002c __snprintf 0038 .LANCHOR0"
	strings:
		$1 = { 0D 49 03 46 10 B5 1D EE 70 4F 84 B0 0C 44 ?? ?2 0? 0? C3 F3 07 41 C0 F3 07 20 ?? ?2 0? 0? 8D E8 03 00 19 0E 20 46 02 91 DB B2 12 21 ?? ?? ?? ?? 20 46 04 B0 10 BD 00 BF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_583_0_0 {
	meta:
		name = "ether_line"
		size = 368
		refs = "0160 __libc_tsd_CTYPE_B 0164 __libc_tsd_CTYPE_TOLOWER"
	strings:
		$1 = { 2D E9 F0 0F 1D EE 70 CF 55 4C 82 B0 55 4B 7C 44 24 68 7B 44 1B 68 5C F8 04 40 5C F8 03 80 00 23 01 94 04 78 18 F8 24 50 A5 F1 30 06 A5 F1 61 07 F4 B2 05 2F 88 BF 09 2C 00 F2 8B 80 44 78 09 2E 88 BF A5 F1 57 06 04 2B 8C BF 00 27 01 27 18 F8 24 40 3A 2C 0C BF 00 25 07 F0 01 05 A2 46 DD B9 14 F1 00 09 00 F1 01 05 18 BF 4F F0 01 09 05 2B 18 BF 4F F0 00 09 B9 F1 00 0F 2B D0 DD F8 04 A0 3A F8 14 90 19 F4 00 5F 06 D0 4E 71 01 33 01 35 06 2B 26 D0 28 46 C4 E7 A4 F1 30 09 A4 F1 61 0B 85 1C 5F FA 89 FA BB F1 05 0F 88 BF BA F1 09 0F 4F D8 90 F8 02 A0 B9 F1 09 0F 88 BF A4 F1 57 09 36 01 BA F1 3A 0F 0C BF 00 27 07 F0 01 07 4E 44 00 2F 3E D1 CE 54 BA F1 00 0F D7 D1 01 33 06 2B D8 D1 21 4B 29 78 7B 44 1B 68 5C F8 03 40 34 F8 11 30 9F 04 07 D5 6B 1C 1D 46 13 F8 01 1B 34 F8 11 00 86 04 F8 D4 23 29 18 BF 00 29 21 D0 2B 78 23 2B 18 BF 00 2B 16 D0 34 F8 13 10 88 04 12 D4 12 48 08 E0 01 46 79 44 09 68 5C F8 01 10 31 F8 13 10 89 04 07 D4 02 F8 01 3B 15 F8 01 3F 23 2B 18 BF 00 2B EE D1 00 20 10 70 02 B0 BD E8 F0 0F 70 47 4F F0 FF 30 02 B0 BD E8 F0 0F 70 47 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_584_0_0 {
	meta:
		name = "__execvpe"
		size = 768
		refs = "0014 strchr 0022 __execve 0090 .LC0 00c4 free 00d4 .LC1 00dc getenv 00e8 strlen 0132 memcpy 015e __strchrnul 0256 confstr 0288 __libc_alloca_cutoff 0296 malloc 02ec __libc_errno"
	strings:
		$1 = { 2D E9 F0 4F 89 B0 80 46 00 AF 0C 46 03 78 15 46 BB B1 2F 21 ?? ?? ?? ?? 00 28 5B D0 2A 46 40 46 21 46 ?? ?? ?? ?? B1 4B 1D EE 70 2F 7B 44 1B 68 D3 58 08 2B 12 D0 4F F0 FF 30 24 37 BD 46 BD E8 F0 8F AB 4B 1D EE 70 2F 02 21 4F F0 FF 30 7B 44 1B 68 24 37 D1 50 BD 46 BD E8 F0 8F 22 1F 00 23 00 E0 33 46 52 F8 04 1F 5E 1C 00 29 F9 D1 02 33 4F EA 83 09 B9 F5 80 5F 00 F2 15 81 09 F1 0E 03 4F F0 00 09 23 F0 07 03 AD EB 03 0D 69 46 01 2E ?? ?2 0? 0? ?? ?2 0? 0? C1 F8 04 80 08 60 0D D0 B0 00 00 23 06 46 04 44 C6 F1 04 06 08 44 54 F8 04 2D C2 50 04 3B B3 42 F9 D1 08 68 2A 46 ?? ?? ?? ?? 48 46 ?? ?? ?? ?? 4F F0 FF 30 24 37 BD 46 BD E8 F0 8F ?? ?2 0? 0? ?? ?2 0? 0? ?? ?? ?? ?? 83 46 00 28 00 F0 B5 80 ?? ?? ?? ?? 4F F0 01 0A 06 46 40 46 ?? ?? ?? ?? 00 F1 01 09 09 EB 06 03 9A 44 C7 F8 18 A0 BA F5 80 5F 00 F2 DB 80 B9 69 01 F1 0E 02 00 21 22 F0 07 02 F9 60 AD EB 02 0D EA 46 BB F1 00 0F 00 F0 9C 80 70 1C 4A 46 41 46 50 44 ?? ?? ?? ?? 4F F0 00 09 C8 46 1D EE 70 6F 2F 22 C7 F8 08 90 43 1E 3B 61 ?? ?2 0? 0? F8 61 ?? ?2 0? 0? 00 F8 01 2C 7B 61 58 46 3A 21 ?? ?? ?? ?? 83 45 82 46 38 D0 3B 69 CB EB 00 02 59 46 98 1A ?? ?? ?? ?? 83 46 58 46 21 46 2A 46 ?? ?? ?? ?? 5C 4B 7B 44 1B 68 F3 58 08 2B 28 D0 14 2B 1D DC 13 2B 06 DA 02 2B 04 D0 0D 2B 7F F4 4B AF 4F F0 01 09 9A F8 00 30 0A F1 01 0B 00 2B D4 D1 B9 F1 00 0F 04 D0 50 4B 0D 22 7B 44 1B 68 F2 50 B8 68 ?? ?? ?? ?? F8 68 ?? ?? ?? ?? 33 E7 6E 2B E8 D0 74 2B 7F F4 2F AF E4 E7 D7 F8 1C B0 CB E7 B8 F1 00 0F 0A D0 D8 F8 00 00 41 46 2A 46 ?? ?? ?? ?? 42 4B 7B 44 1B 68 F3 58 C8 E7 22 1F 00 E0 98 46 52 F8 04 1F 08 F1 01 03 00 29 F8 D1 08 F1 02 08 B8 69 4F EA 88 08 40 44 B0 F5 80 5F 32 D8 08 F1 0E 02 22 F0 07 02 AD EB 02 0D E8 46 79 69 01 2B 88 E8 02 08 21 D0 98 00 00 23 C0 F1 04 0E 22 18 40 44 52 F8 04 1D C1 50 04 3B 73 45 F9 D1 C9 E7 01 46 02 46 ?? ?? ?? ?? 06 46 00 F1 02 0A 47 E7 01 33 3A 22 0A EB 03 0B 00 20 0A F8 03 20 0B F1 01 01 32 46 ?? ?? ?? ?? 56 E7 ?? ?2 0? 0? ?? ?2 0? 0? B1 E7 7B 60 ?? ?? ?? ?? 7B 68 00 28 C6 D1 40 46 7B 60 ?? ?? ?? ?? 7B 68 B8 60 00 28 8E D0 80 46 C3 E7 48 46 ?? ?? ?? ?? 00 28 7F F4 E5 AE 48 46 ?? ?? ?? ?? 81 46 00 28 3F F4 BB AE 49 46 E4 E6 50 46 7B 60 ?? ?? ?? ?? 7B 68 00 28 7F F4 1D AF B8 69 7B 60 ?? ?? ?? ?? 7B 68 82 46 00 28 3F F4 A8 AE F8 60 1B E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_585_0_0 {
	meta:
		name = "_nss_files_parse_grent"
		size = 464
		refs = "0020 strchr 00a6 strtoul 0192 __rawmemchr 01cc __libc_tsd_CTYPE_B"
	strings:
		$1 = { 82 42 2D E9 F0 47 14 46 82 B0 06 46 02 EB 03 08 89 46 02 D8 80 45 00 F2 BB 80 25 46 30 46 0A 21 ?? ?? ?? ?? 08 B1 00 23 03 70 C9 F8 00 60 33 78 3A 2B 18 BF 00 2B 05 D0 16 F8 01 3F 3A 2B 18 BF 00 2B F9 D1 13 B1 00 23 06 F8 01 3B 33 78 5B B9 D9 F8 00 20 12 78 2B 2A 18 BF 2D 2A 04 BF C9 F8 04 30 C9 F8 08 30 31 D0 C9 F8 04 60 33 78 00 2B 18 BF 3A 2B 05 D0 16 F8 01 3F 3A 2B 18 BF 00 2B F9 D1 00 2B 6F D1 D9 F8 00 30 1B 78 2B 2B 18 BF 2D 2B 72 D1 33 78 1B B9 00 20 02 B0 BD E8 F0 87 0A 22 30 46 01 A9 ?? ?? ?? ?? 01 9B 9E 42 08 BF 00 22 C9 F8 08 00 08 BF C9 F8 08 20 1A 78 3A 2A 08 BF 5E 1C 02 D0 1E 46 00 2A E5 D1 00 2D 71 D0 03 35 3E 4B 25 F0 03 0A 00 21 57 46 0A F1 08 0C E0 45 31 D3 30 78 00 28 57 D0 1A 46 1D EE 70 4F 7A 44 12 68 A5 58 35 F8 10 20 94 04 2C D5 01 36 34 46 01 36 20 78 35 F8 10 20 92 04 F8 D4 02 46 38 B3 2C 28 08 BF 22 78 23 D0 25 46 02 E0 2C 2A 04 D0 35 46 6A 78 6E 1C 00 2A F8 D1 B4 42 3F BF 3C 60 04 37 6A 78 07 F1 08 0C 00 2A D0 D0 E0 45 31 70 06 F1 01 06 CD D2 0A 9A 22 23 4F F0 FF 30 13 60 02 B0 BD E8 F0 87 34 46 2C 28 08 BF 22 78 DB D1 26 46 E9 E7 00 23 06 F8 01 3B D9 F8 00 30 1B 78 2B 2B 18 BF 2D 2B 8C D0 30 46 01 A9 0A 22 ?? ?? ?? ?? 01 9B 9E 42 C9 F8 08 00 96 D1 83 E7 00 21 ?? ?? ?? ?? 45 1C 40 E7 38 60 4F F0 FF 30 BA F1 00 0F 3F F4 79 AF 01 20 C9 F8 0C A0 02 B0 BD E8 F0 87 B4 42 07 D8 B0 45 05 D9 29 46 30 46 ?? ?? ?? ?? 45 1C 83 E7 25 46 81 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_585_1_0 {
	meta:
		name = "__fgetgrent_r"
		size = 528
		refs = "006e fgets_unlocked 00bc _nss_files_parse_grent 010c __libc_do_syscall 0182 __lll_lock_wait_private 01fc __libc_errno 020c __libc_tsd_CTYPE_B"
	strings:
		$1 = { 2D E9 F0 4F 98 46 03 68 83 B0 05 46 8B 46 1C 04 17 46 48 BF 1D EE 70 6F 1D D4 80 6C 1D EE 70 6F A6 F5 98 64 83 68 A3 42 12 D0 01 22 BF F3 5F 8F 50 E8 00 3F 00 2B 03 D1 40 E8 00 21 00 29 F7 D1 BF F3 5F 8F 00 2B 40 F0 9C 80 AB 6C 18 46 9C 60 43 68 01 33 43 60 08 F1 FF 34 DF F8 B0 A1 3C 44 4F F0 FF 09 84 F8 00 90 38 46 41 46 2A 46 ?? ?? ?? ?? 00 28 00 F0 88 80 23 78 FF 2B 4F D1 52 46 03 78 7A 44 12 68 B1 58 31 F8 13 20 92 04 48 BF 00 F1 01 0E 06 D5 70 46 1E F8 01 3B 31 F8 13 20 92 04 F8 D4 00 2B 18 BF 23 2B DB D0 53 4B 59 46 3A 46 7B 44 1B 68 33 44 00 93 43 46 ?? ?? ?? ?? 00 28 CF D0 2B 68 04 46 1B 04 21 D4 A8 6C 43 68 01 3B 43 60 E3 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 25 00 2D F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 09 DD A6 F5 98 61 01 22 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 01 34 6A D0 0C 9D 00 20 C5 F8 00 B0 23 E0 2B 68 19 04 17 D4 A8 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 0B DC 0C 9D 00 22 29 4B 2A 60 22 22 7B 44 1B 68 10 46 F2 50 03 B0 BD E8 F0 8F A6 F5 98 61 01 22 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? E8 E7 ?? ?? ?? ?? 60 E7 2B 68 D8 06 C8 D5 19 04 21 D4 A8 6C 43 68 01 3B 43 60 E3 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 09 DD A6 F5 98 61 01 22 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? 0C 9D 00 22 0A 4B 2A 60 7B 44 1B 68 02 22 10 46 F2 50 BD E7 0C 9C 00 22 06 4B 22 60 7B 44 1B 68 F0 58 B5 E7 00 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_586_0_0 {
	meta:
		name = "strncat"
		size = 120
	strings:
		$1 = { 30 B4 05 46 00 E0 25 46 2C 46 14 F8 01 3B 00 2B F9 D1 03 2A 05 F1 FF 34 17 D9 95 08 0D E0 4B 78 A3 70 73 B1 8B 78 04 31 E3 70 53 B1 11 F8 01 3C 04 F8 04 3F 2B B1 01 3D 05 D0 0B 78 63 70 00 2B ED D1 30 BC 70 47 02 F0 03 02 7A B1 0B 78 65 1C 63 70 00 2B F5 D0 22 44 05 E0 11 F8 01 3F 05 F8 01 3F 00 2B ED D0 95 42 2C 46 F6 D1 00 2B E8 D0 00 23 63 70 30 BC 70 47 }
	condition:
		$1
}

rule file_588_0_0 {
	meta:
		name = "ungetwc"
		size = 262
		refs = "004a _IO_fwide 0056 _IO_sputbackwc 00aa __libc_do_syscall 00b0 __lll_lock_wait_private 0102 _Unwind_Resume"
	strings:
		$1 = { 0B 68 70 B5 05 46 18 04 0C 46 1C D4 88 6C 1D EE 70 6F A6 F5 98 66 82 68 B2 42 11 D0 01 21 BF F3 5F 8F 50 E8 00 2F 00 2A 03 D1 40 E8 00 13 00 2B F7 D1 BF F3 5F 8F 00 2A 3A D1 A2 6C 10 46 96 60 42 68 01 32 42 60 01 21 20 46 ?? ?? ?? ?? 69 1C 04 D0 29 46 20 46 ?? ?? ?? ?? 05 46 23 68 1A 04 17 D4 A0 6C 43 68 01 3B 43 60 93 B9 1A 46 83 60 03 68 BF F3 5F 8F 50 E8 00 1F 99 42 03 D1 40 E8 00 24 00 2C F7 D1 8B 42 BF F3 5F 8F F0 D1 01 2B 01 DC 28 46 70 BD 1D EE 70 1F 01 22 A1 F5 98 61 00 23 4F F0 F0 0C 89 68 11 43 ?? ?? ?? ?? F0 E7 ?? ?? ?? ?? C1 E7 23 68 05 46 1B 04 20 D4 A3 6C 5A 68 01 3A 5A 60 DA B9 11 46 9A 60 1A 68 BF F3 5F 8F 53 E8 00 0F 90 42 03 D1 43 E8 00 14 00 2C F7 D1 82 42 BF F3 5F 8F F0 D1 01 2A 08 DD B1 68 01 22 18 46 4F F0 F0 0C 00 23 11 43 ?? ?? ?? ?? 28 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_589_0_0 {
	meta:
		name = "__xpg_strerror_r"
		size = 192
		refs = "0008 __strerror_r 0016 _sys_nerr_internal 0024 _sys_errlist_internal 0034 strlen 004c mempcpy 0084 .LC0 0088 .LC1 008c __PRETTY_FUNCTION__.10126 009e __assert_fail 00a2 .LC2"
	strings:
		$1 = { F8 B5 0E 46 04 46 15 46 ?? ?? ?? ?? B0 42 07 46 25 D0 00 2C 45 DB ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 9C 42 3E DA ?? ?2 0? 0? ?? ?2 0? 0? 53 F8 24 30 00 2B 36 D0 ?? ?? ?? ?? 04 46 0D B9 22 20 F8 BD 6A 1E 30 46 94 42 38 BF 22 46 39 46 ?? ?? ?? ?? A5 42 4F F0 00 03 03 70 F0 D9 18 46 F8 BD 00 2C 06 DB ?? ?2 0? 0? ?? ?2 0? 0? 1B 68 9C 42 01 DB 16 20 F8 BD ?? ?2 0? 0? ?? ?2 0? 0? 53 F8 24 30 00 2B F5 D0 ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 25 22 ?? ?? ?? ?? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? ?? ?2 0? 0? 2B 22 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_591_0_0 {
	meta:
		name = "try.6189"
		size = 90
		refs = "0010 nl_langinfo 0020 __regfree 002e __regcomp 0042 __regexec"
	strings:
		$1 = { 2D E9 F0 43 83 B0 1D 46 0F 46 90 46 E1 46 0A 9E ?? ?? ?? ?? 2B 68 83 42 04 46 0C D0 23 B1 30 46 ?? ?? ?? ?? 00 23 2B 60 30 46 21 46 01 22 ?? ?? ?? ?? 78 B9 2C 60 00 23 D9 F8 00 10 1A 46 30 46 00 93 ?? ?? ?? ?? 00 28 14 BF 40 46 38 46 03 B0 BD E8 F0 83 4F F0 FF 30 F9 E7 }
	condition:
		$1
}

rule file_591_1_0 {
	meta:
		name = "rpmatch"
		size = 68
	strings:
		$1 = { 30 B5 85 B0 0E 4D 04 AC 01 21 00 22 44 F8 04 0D 2B 1F A4 46 00 95 4F F4 A0 20 FF F7 C3 FF 01 46 61 B9 01 20 05 F1 24 02 A4 46 00 92 C0 F2 05 00 05 F1 20 03 4F F0 FF 32 FF F7 B4 FF 05 B0 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_592_0_0 {
	meta:
		name = "_quicksort"
		size = 638
		refs = "0046 __aeabi_uidiv"
	strings:
		$1 = { 2D E9 F0 4F C7 B0 93 46 1F 46 05 90 DD F8 40 81 00 29 72 D0 04 29 4F EA 82 03 01 F1 FF 31 04 93 6E D9 DD F8 14 A0 56 42 06 AB 00 93 08 AB 02 93 02 FB 01 A1 00 23 06 93 07 93 03 91 01 91 01 9B 59 46 CA EB 03 00 ?? ?? ?? ?? 51 46 42 46 40 08 0B FB 00 A5 28 46 B8 47 00 28 C0 F2 DC 80 01 98 29 46 42 46 B8 47 00 28 C0 F2 E2 80 01 9C 0A EB 0B 09 34 44 48 46 29 46 42 46 B8 47 00 28 01 DA BF E0 34 44 28 46 21 46 42 46 B8 47 00 28 F8 DB A1 45 80 F0 99 80 22 46 09 EB 0B 0C 4B 46 10 78 19 78 03 F8 01 0B 63 45 02 F8 01 1B F7 D1 4D 45 08 BF 25 46 02 D0 AC 42 08 BF 4D 46 34 44 E1 46 A1 45 D7 D9 04 99 CA EB 04 03 99 42 C0 F0 86 80 01 9A C9 EB 02 03 99 42 38 BF CA 46 08 D3 02 9B 53 F8 08 AC 53 F8 04 3C 01 93 02 9B 08 3B 02 93 02 9B 00 99 8B 42 A2 D8 05 E0 47 B0 BD E8 F0 8F 02 FB 01 01 03 91 04 9B 05 9D DD F8 14 90 1D 44 03 9B D9 44 AB 42 38 BF 1D 46 4D 45 24 BF 4E 46 05 9C 18 D3 30 46 21 46 42 46 B8 47 34 EA 20 04 28 BF 34 46 5E 44 B5 42 F4 D2 05 99 8C 42 0A D0 0B 46 04 EB 0B 00 19 78 22 78 04 F8 01 1B 84 42 03 F8 01 2B F7 D1 D9 44 CB F1 00 0A 09 F1 FF 36 CD F8 04 B0 03 9B 99 45 C7 D8 01 9B C3 EB 09 04 00 E0 54 44 48 46 21 46 42 46 B8 47 00 28 F8 DB 01 9A 01 9B 22 44 4A 45 33 44 02 93 18 D0 99 45 16 D8 B4 46 18 46 62 45 04 46 63 46 10 F8 01 B9 01 D9 30 E0 0B 46 1D 78 03 EB 0A 01 8A 42 25 70 1C 46 F7 D9 B0 42 83 F8 00 B0 0C F1 FF 3C EA D1 01 9B 02 9E 99 44 CD E7 7F F4 7A AF 34 44 04 99 CA EB 04 03 D9 44 99 42 BF F4 7A AF 01 99 C9 EB 01 02 04 99 91 42 28 BF 01 94 81 D2 93 42 02 9B 3C DD C3 F8 00 A0 08 33 43 F8 04 4C CA 46 02 93 76 E7 D9 44 36 E7 23 46 B0 42 0C F1 FF 3C 83 F8 00 B0 C0 D1 D4 E7 52 46 05 EB 0B 04 2B 46 10 78 19 78 03 F8 01 0B A3 42 02 F8 01 1B F7 D1 16 E7 01 9A 05 EB 0B 04 2B 46 10 78 19 78 03 F8 01 0B A3 42 02 F8 01 1B F7 D1 28 46 51 46 42 46 B8 47 00 28 BF F6 0B AF 52 46 2B 46 10 78 19 78 03 F8 01 0B A3 42 02 F8 01 1B F7 D1 FF E6 01 99 08 33 43 F8 08 9C 01 94 43 F8 04 1C 02 93 38 E7 }
	condition:
		$1
}

rule file_593_0_0 {
	meta:
		name = "__recv_chk"
		size = 22
		refs = "0012 __chk_fail 000e __recv"
	strings:
		$1 = { 9A 42 10 B5 02 9C 04 D8 23 46 BD E8 10 40 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_594_0_0 {
	meta:
		name = "_IO_wfile_doallocate"
		size = 100
		refs = "003e __mmap 0052 _IO_wsetb 005c _IO_file_doallocate"
	strings:
		$1 = { C3 69 30 B5 04 46 83 B0 43 B3 21 6A 22 68 CB 1A D2 07 