private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_0_0 {
	meta:
		name = "TActionBarAccessibility.accDoDefaultAction"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.accDoDefaultAction 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 14 00 }
	condition:
		$1
}

rule function_1_0 {
	meta:
		name = "TActionBarAccessibility.accHitTest"
		size = 320
		refs = "0024 VariantInit 003b _Dn_TActionBarItem 0040 @IsClass 0061 TControl.ScreenToClient 007a TCollectionItem.GetIndex 0086 @OleVarFromInt 0099 _Dn_TActionClientItem 00da TWinControl.ControlAtPos 0108 TControl.GetBoundsRect 0113 PtInRect"
	strings:
		$1 = { 55 8B EC 83 C4 CC 53 56 57 8B 7D 14 8B 5D 08 8B C7 85 FF 74 0D 33 D2 89 57 0C 89 57 08 89 57 04 89 17 57 E8 ?? ?? ?? ?? 66 C7 07 03 00 33 F6 C7 45 FC 01 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 4C 8B 45 0C 89 45 EC 8B 45 10 89 45 F0 8D 4D F4 8D 55 EC 8B 43 0C 8B 40 0C E8 ?? ?? ?? ?? 8B 43 0C 8B 70 0C 85 F6 0F 84 C1 00 00 00 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 42 8B C7 B1 FC E8 ?? ?? ?? ?? 33 C0 89 45 FC E9 A0 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 58 8B 43 0C 83 78 44 00 74 4F 8B 45 0C 89 45 E4 8B 45 10 89 45 E8 6A 00 6A 00 8D 4D DC 8D 55 E4 8B 43 0C 8B 70 18 8B C6 E8 ?? ?? ?? ?? 8D 55 DC 8B C6 B1 01 E8 ?? ?? ?? ?? 8B F0 8B 86 B4 01 00 00 E8 ?? ?? ?? ?? 8B D0 42 8B C7 B1 FC E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 36 85 F6 74 2B 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 8D 45 CC 8D 55 F4 E8 ?? ?? ?? ?? 84 C0 74 12 8B C7 33 D2 B1 01 E8 ?? ?? ?? ?? 33 C0 89 45 FC EB 07 C7 45 FC 01 00 00 00 8B 45 FC 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule function_2_0 {
	meta:
		name = "TActionBarAccessibility.accLocation"
		size = 288
		refs = "0019 @VarAddRef 0021 TActionBarAccessibility.accLocation 0038 @OleVarFromInt 0043 @VarCmpEQ 0050 _Dn_TActionBarItem 0055 @IsClass 006b TActionClient.GetItems 0077 @VarCopy 0091 @VarSub 0099 @VarToInteger 00a1 TActionClients.GetActionClient 00bf TControl.ClientToScreen 00f7 OleVariant 0101 @FinalizeArray 0109 @VarClr 010f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 1C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 E8 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 E8 8D 45 1C E8 ?? ?? ?? ?? 75 1E 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 8B 5F 0C EB 46 8B 5F 44 EB 41 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 1C 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 C8 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C8 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 8B 58 44 85 DB 74 39 8D 55 B8 8B C3 8B 08 FF 51 54 8D 55 B8 8D 4D F8 8B C3 E8 ?? ?? ?? ?? 8B 45 0C 8B 55 F8 89 10 8B 45 10 8B 55 FC 89 10 8B 45 14 8B 53 48 89 10 8B 45 18 8B 53 4C 89 10 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 8B 15 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 1C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C6 5F 5E 5B 8B E5 5D C2 24 00 }
	condition:
		$1
}

rule function_3_0 {
	meta:
		name = "TActionBarAccessibility.accNavigate"
		size = 90
		refs = "0008 @VarAddRef 0027 TActionBarAccessibility.accNavigate 0047 @VarClr 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 10 E8 ?? ?? ?? ?? 8B 45 20 8B 55 20 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 1C 00 }
	condition:
		$1
}

rule function_4_0 {
	meta:
		name = "TActionBarAccessibility.Get_accFocus"
		size = 35
		altNames = "TActionBarAccessibility.Get_accSelection"
	strings:
		$1 = { 55 8B EC 8B 45 0C 8B 55 0C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A B8 03 00 02 80 5D C2 08 00 }
	condition:
		$1
}

rule function_5_0 {
	meta:
		name = "TActionBarAccessibility.Create"
		size = 78
		refs = "000e @ClassCreate 002c @IntfCopy 0037 @AfterConstruction"
	strings:
		$1 = { 55 8B EC 53 56 57 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F8 89 4F 10 8B 75 08 89 77 0C 8D 46 34 8B D7 85 D2 74 03 83 EA EC E8 ?? ?? ?? ?? 8B C7 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C7 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_6_0 {
	meta:
		name = "TActionBarAccessibility.GetIDsOfNames"
		size = 12
		altNames = "TBaseDebugScriptSite.GetDeferredText TBaseDebugScriptSite.GetScriptTextAttributes TEventDispatch.GetIDsOfNames TEventDispatchEx.GetIDsOfNames TLocalAppServer.GetIDsOfNames TMSDOMEventHandler.GetIDsOfNames TOleControl.GetIDsOfNames TSOAPAppServerAdapter.GetIDsOfNames TServerEventDispatch.GetIDsOfNames"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 18 00 }
	condition:
		$1
}

rule function_7_0 {
	meta:
		name = "CmpUnimplemented"
		size = 12
		altNames = "TActionBarAccessibility.GetTypeInfo TActiveXControl.InitFromData TActiveXControl.SetData TDataDispatch.GetTypeInfo TDataObject.SetData TLocalAppServer.GetTypeInfo TMSDOMEventHandler.GetTypeInfo TObjectDispatch.GetTypeInfo TSOAPAppServerAdapter.GetTypeInfo"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 10 00 }
	condition:
		$1
}

rule function_8_0 {
	meta:
		name = "TActionBarAccessibility.GetTypeInfoCount"
		size = 12
		altNames = "TActiveScriptSite.GetLCID TActiveXControl.ContextSensitiveHelp TActiveXControl.GetSizeMax TActiveXControl.QueryGetData TActiveXControl.SetColorScheme TActiveXControl.Unfreeze TCustomMSHTMLParser.OnRequestEdit TCustomMSHTMLParser.OnShowWindow TDownLoadURL.GetPriority TDownLoadURL.OnLowResource TLocalAppServer.GetTypeInfoCount TMSDOMEventHandler.GetTypeInfoCount TObjectDispatch.GetTypeInfoCount TOleControl.LockInPlaceActive TOleControl.OnFocus TOleControl.SetBorderSpace TOleLinkStub.GetUpdateOptions TOleLinkStub.SetSourceDisplayName TOleLinkStub.SetUpdateOptions TOleLinkStub.Update TPropertyPageImpl.EditProperty TPropertyPageImpl.Help TSOAPAppServerAdapter.GetTypeInfoCount UniUnimplemented"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 08 00 }
	condition:
		$1
}

rule function_9_0 {
	meta:
		name = "TActionBarAccessibility.Get_accChild"
		size = 298
		refs = "0018 @VarAddRef 002b TActionBarAccessibility.Get_accChild 003d @OleVarFromInt 0048 @VarCmpEQ 005c TActionClient.GetItems 0079 @VarCmpGT 0083 @IntfClear 00a0 @VarCopy 00ba @VarSub 00c2 @VarToInteger 00ca TActionClients.GetActionClient 00d4 _DV_TActionBarAccessibility 00d9 TActionBarAccessibility.Create 00ea @IntfCopy 0102 OleVariant 010c @FinalizeArray 0114 @VarClr 011a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 0A BB 57 00 07 80 E9 98 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 8B 40 08 8B 70 08 8D 45 E0 8B D6 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0F 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 EB 62 8B 73 0C 8B C6 E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 1C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 8B 15 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_26_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accChild"
		size = 298
		refs = "0018 @VarAddRef 002b TActionMenuBarAccessibility.Get_accChild 003d @OleVarFromInt 0048 @VarCmpEQ 005c TActionClient.GetItems 0079 @VarCmpGT 0083 @IntfClear 00a0 @VarCopy 00ba @VarSub 00c2 @VarToInteger 00ca TActionClients.GetActionClient 00d4 _DV_TActionMenuBarAccessibility 00d9 TActionBarAccessibility.Create 00ea @IntfCopy 0102 OleVariant 010c @FinalizeArray 0114 @VarClr 011a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 0A BB 57 00 07 80 E9 98 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 8B 40 08 8B 70 08 8D 45 E0 8B D6 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0F 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 EB 62 8B 73 0C 8B C6 E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 50 8B CE B2 01 A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 85 D2 74 03 83 EA EC 8B 45 1C E8 ?? ?? ?? ?? 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C0 8B 15 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 8B C3 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_10_0 {
	meta:
		name = "TActionBarAccessibility.Get_accChildCount"
		size = 31
		refs = "000a TActionClient.GetItems"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 40 0C E8 ?? ?? ?? ?? 8B 40 08 8B 40 08 8B 55 0C 89 02 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule function_11_0 {
	meta:
		name = "TActionBarAccessibility.Get_accDefaultAction"
		size = 78
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accDefaultAction 003b @VarClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_14_0 {
	meta:
		name = "TActionBarAccessibility.Get_accHelp"
		size = 78
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accHelp 003b @VarClr 0041 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_12_0 {
	meta:
		name = "TActionBarAccessibility.Get_accDescription"
		size = 361
		refs = "0019 @VarAddRef 002c TActionBarAccessibility.Get_accDescription 0043 @OleVarFromInt 004e @VarCmpEQ 005b _Dn_TActionBarItem 0060 @IsClass 0075 GetLongHint 0080 @WStrFromUStr 00a8 TActionClient.GetItems 00b4 @VarCopy 00ce @VarSub 00d6 @VarToInteger 00de TActionClients.GetActionClient 00e3 TActionClientItem.GetAction 012b OleVariant 0135 @FinalizeArray 0142 @UStrArrayClr 014a @VarClr 0158 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 50 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1E 8D 55 EC 8B 47 0C 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? EB 77 8D 55 E8 8B 47 44 8B 80 80 00 00 00 E8 ?? ?? ?? ?? 8B 55 E8 8B 45 1C E8 ?? ?? ?? ?? EB 59 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 C4 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C4 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 40 7C 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 C0 8B 45 C0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C4 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C8 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_15_0 {
	meta:
		name = "TActionBarAccessibility.Get_accHelpTopic"
		size = 186
		refs = "0021 @VarAddRef 0029 TActionBarAccessibility.Get_accHelpTopic 0037 @WStrClr 004c @OleVarFromInt 0057 @VarCmpEQ 0062 _Dn_TActionClientItem 0067 @IsClass 0073 TActionClientItem.GetAction 009b @VarClr 00a9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 8B 75 20 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 8D 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 0C E8 ?? ?? ?? ?? 33 C0 89 06 BF 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 10 E8 ?? ?? ?? ?? 75 2D 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 1B 8B 43 0C E8 ?? ?? ?? ?? 85 C0 74 0F 8B 43 0C E8 ?? ?? ?? ?? 8B 40 74 89 06 33 FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C7 5F 5E 5B 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule function_16_0 {
	meta:
		name = "TActionBarAccessibility.Get_accKeyboardShortcut"
		size = 441
		refs = "001a @VarAddRef 002d TActionBarAccessibility.Get_accKeyboardShortcut 0044 @OleVarFromInt 004f @VarCmpEQ 0060 _Dn_TActionBarItem 0065 @IsClass 0071 @WStrClr 007d TActionClientItem.GetAction 008c TActionClientItem.GetCaption 0097 GetHotkey 00a2 @WStrFromUStr 00bb ShortCutToText 00ec TActionClient.GetItems 00f8 @VarCopy 0112 @VarSub 011a @VarToInteger 0122 TActionClients.GetActionClient 0173 OleVariant 017d @FinalizeArray 0185 @UStrClr 0192 @UStrArrayClr 019a @VarClr 01a8 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 08 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 8F 00 00 00 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0D 8B 45 1C E8 ?? ?? ?? ?? E9 E7 00 00 00 8B C7 E8 ?? ?? ?? ?? 85 C0 75 23 8D 55 E8 8B 43 0C E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? EB 22 8B 43 0C E8 ?? ?? ?? ?? 0F B7 80 84 00 00 00 8D 55 E4 E8 ?? ?? ?? ?? 8B 55 E4 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E0 8B 45 E0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 7D 33 F6 EB 79 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 CC E8 ?? ?? ?? ?? 8D 45 BC BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 BC 8D 45 CC E8 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 80 84 00 00 00 8D 55 DC E8 ?? ?? ?? ?? 8B 55 DC 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E0 8B 45 E0 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 BC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E4 BA 03 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB C0 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_17_0 {
	meta:
		name = "TActionBarAccessibility.Get_accName"
		size = 423
		refs = "001a @VarAddRef 002d TActionBarAccessibility.Get_accName 0041 @OleVarFromInt 004c @VarCmpEQ 0059 _Dn_TActionClientItem 005e @IsClass 006c TActionClientItem.GetCaption 0077 StripHotkey 0082 @WStrFromUStr 008f _Dn_TActionBarItem 00a7 TControl.GetText 00b4 TActionClient.GetItems 00d1 @VarCmpGT 00ee @VarCopy 0108 @VarSub 0110 @VarToInteger 0118 TActionClients.GetActionClient 014c OleVariant 0156 @FinalizeArray 0163 @UStrArrayClr 016b @VarClr 0173 @UStrClr 0196 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 0A 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 5E 8B 7B 0C 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 25 8D 55 E8 8B C7 E8 ?? ?? ?? ?? 8B 45 E8 8D 55 EC E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? E9 AF 00 00 00 8B C7 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 84 9A 00 00 00 8D 55 E4 8B 47 0C E8 ?? ?? ?? ?? E9 8A 00 00 00 8B 43 0C E8 ?? ?? ?? ?? 8B 40 08 8B 78 08 8D 45 D4 8B D7 B1 FC E8 ?? ?? ?? ?? 8D 55 D4 8D 45 0C E8 ?? ?? ?? ?? 7E 07 BE 01 00 00 00 EB 5C 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 BC E8 ?? ?? ?? ?? 8D 45 AC BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 AC 8D 45 BC E8 ?? ?? ?? ?? 8D 45 BC E8 ?? ?? ?? ?? 8B D0 58 E8 ?? ?? ?? ?? 8D 55 CC E8 ?? ?? ?? ?? 8B 45 CC 8D 55 D0 E8 ?? ?? ?? ?? 8B 55 D0 8B 45 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 AC 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 CC BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 D4 E8 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 E8 BA 02 00 00 00 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB AB 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "TActionBarAccessibility.Get_accParent"
		size = 50
		refs = "0026 @IntfCopy"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 08 8B 45 0C 85 C0 74 04 33 D2 89 10 B8 01 00 00 00 8B 73 10 85 F6 74 0D 8B 45 0C 8B 56 34 E8 ?? ?? ?? ?? 33 C0 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "TActionBarAccessibility.Get_accRole"
		size = 244
		refs = "0013 @VarAddRef 0032 TActionBarAccessibility.Get_accRole 0043 VariantInit 0057 @OleVarFromInt 0062 @VarCmpEQ 006d _Dn_TActionBarItem 0072 @IsClass 0095 _Dn_TCustomActionMainMenuBar 00d5 @VarClr 00e3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 52 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 02 00 00 00 EB 3E 8B 43 0C 8B 78 44 85 FF 74 1E 8B 47 34 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 0B 00 00 00 EB 16 8B 45 1C C7 40 08 0C 00 00 00 EB 0A 8B 45 1C C7 40 08 0C 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "TActionBarAccessibility.accSelect"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.accSelect 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 10 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 10 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "TActionBarAccessibility.Get_accState"
		size = 650
		refs = "0019 @VarAddRef 0038 TActionBarAccessibility.Get_accState 0049 VariantInit 005f @OleVarFromInt 006a @VarCmpEQ 0079 _Dn_TActionBarItem 007e @IsClass 0093 _Dn_TActionClientItem 00c5 IsVisible 00dc IsEnabled 00f4 IsChecked 0111 TActionClient.GetItems 011d @VarCopy 0137 @VarSub 013f @VarToInteger 0149 TActionClients.GetActionClient 0198 TActionClient.GetHasItems 01a2 HasPopup 0261 OleVariant 026b @FinalizeArray 0273 @VarClr 0279 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 12 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 FF 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 8F 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 0C 8B 70 0C EB 18 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 8B 43 0C 8B 70 44 85 F6 75 0A BF 57 00 07 80 E9 98 01 00 00 8B 45 1C C7 40 08 84 00 10 00 0F B6 46 59 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 5C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 4C 0F B6 40 69 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 49 01 00 00 8B 45 1C C7 40 08 84 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 D0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 D0 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 8B F0 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 0F B6 40 59 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 C0 E8 ?? ?? ?? ?? 8D 45 B0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 B0 8D 45 C0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 A0 E8 ?? ?? ?? ?? 8D 45 90 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 90 8D 45 A0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 5C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 80 E8 ?? ?? ?? ?? 8D 85 70 FF FF FF BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 95 70 FF FF FF 8D 45 80 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 92 E0 00 00 00 84 C0 74 07 8B 45 1C 83 48 08 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 70 FF FF FF 8B 15 ?? ?? ?? ?? B9 09 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B C7 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_22_0 {
	meta:
		name = "TActionBarAccessibility.Get_accValue"
		size = 86
		refs = "0008 @VarAddRef 001b TActionBarAccessibility.Get_accValue 0029 @WStrClr 0043 @VarClr 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 1C E8 ?? ?? ?? ?? BB 01 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_23_0 {
	meta:
		name = "TActionBarAccessibility.Invoke"
		size = 12
		altNames = "TLocalAppServer.Invoke TSOAPAppServerAdapter.Invoke"
	strings:
		$1 = { 55 8B EC B8 01 40 00 80 5D C2 24 00 }
	condition:
		$1
}

rule function_24_0 {
	meta:
		name = "TActionBarAccessibility.Set_accName"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.Set_accName 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_25_0 {
	meta:
		name = "TActionBarAccessibility.Set_accValue"
		size = 67
		refs = "0008 @VarAddRef 0010 TActionBarAccessibility.Set_accValue 0030 @VarClr 0036 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 8D 45 0C E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BB 03 00 02 80 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 5D C2 18 00 }
	condition:
		$1
}

rule function_27_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accDescription"
		size = 232
		refs = "0014 @VarAddRef 0027 TActionMenuBarAccessibility.Get_accDescription 003a @WStrClr 0046 @OleVarFromInt 0051 @VarCmpEQ 005e TActionClientItem.GetCaption 006b @UStrCat 0076 @WStrFromUStr 00a7 @UStrClr 00af @VarClr 00bd @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 51 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 85 C0 74 04 33 D2 89 10 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BE 01 00 00 00 8B 45 1C E8 ?? ?? ?? ?? 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 23 8D 55 EC 8B 43 0C E8 ?? ?? ?? ?? 8D 45 EC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 EC 8B 45 1C E8 ?? ?? ?? ?? 8B 45 1C 8B 00 89 45 E8 8B 45 E8 85 C0 74 07 83 E8 04 8B 00 D1 E8 85 C0 7E 02 33 F6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 8B C6 5E 5B 8B E5 5D C2 18 00 00 00 00 B0 04 02 00 FF FF FF FF 05 00 00 00 20 00 6D 00 65 00 6E 00 75 00 00 00 }
	condition:
		$1
}

rule function_28_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accRole"
		size = 202
		refs = "0012 @VarAddRef 0031 TActionMenuBarAccessibility.Get_accRole 0042 VariantInit 0056 @OleVarFromInt 0061 @VarCmpEQ 006c _Dn_TActionBarItem 0071 @IsClass 00ac @VarClr 00ba @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 53 56 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 F6 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 75 2A 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 0C 8B 45 1C C7 40 08 02 00 00 00 EB 16 8B 45 1C C7 40 08 0C 00 00 00 EB 0A 8B 45 1C C7 40 08 0C 00 00 00 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C6 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_29_0 {
	meta:
		name = "TActionMenuBarAccessibility.Get_accState"
		size = 772
		refs = "0019 @VarAddRef 0038 TActionMenuBarAccessibility.Get_accState 0049 VariantInit 005f @OleVarFromInt 006a @VarCmpEQ 0079 _Dn_TActionBarItem 007e @IsClass 0093 _Dn_TActionClientItem 00bb IsVisible 00d2 IsEnabled 00ec IsChecked 0109 TActionClientItem.GetAction 0153 TActionClient.GetItems 0170 @VarCmpGT 0190 @VarCopy 01aa @VarSub 01b2 @VarToInteger 01bc TActionClients.GetActionClient 01c9 MessageBeep 0258 TActionClient.GetHasItems 0262 HasPopup 02db OleVariant 02e5 @FinalizeArray 02ed @VarClr 02f3 @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 14 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 8B 5D 08 8D 45 0C E8 ?? ?? ?? ?? 8B 45 1C 8B 55 1C 85 D2 74 0D 33 C9 89 4A 0C 89 4A 08 89 4A 04 89 0A 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 FF 8B 45 1C 50 E8 ?? ?? ?? ?? 8B 45 1C 66 C7 00 03 00 33 F6 8D 45 F0 33 D2 B1 01 E8 ?? ?? ?? ?? 8D 55 F0 8D 45 0C E8 ?? ?? ?? ?? 0F 85 DB 00 00 00 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 08 8B 43 0C 8B 70 0C EB 18 8B 43 0C 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 06 8B 43 0C 8B 70 44 85 F6 74 51 8B 45 1C C7 40 08 04 00 10 00 0F B6 46 59 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 52 5C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B C6 8B 10 FF 92 E0 00 00 00 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 CB 01 00 00 8B 45 1C C7 40 08 04 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 85 C0 0F 84 B1 01 00 00 8B 43 0C E8 ?? ?? ?? ?? 0F B6 80 86 00 00 00 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 0F B6 40 6A 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 E9 77 01 00 00 8B 43 0C E8 ?? ?? ?? ?? 8B 40 08 8B 70 08 8D 45 E0 8B D6 B1 FC E8 ?? ?? ?? ?? 8D 55 E0 8D 45 0C E8 ?? ?? ?? ?? 7E 0A BF 57 00 07 80 E9 46 01 00 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 C0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 C0 8D 45 D0 E8 ?? ?? ?? ?? 8D 45 D0 E8 ?? ?? ?? ?? 8B F0 8B D6 58 E8 ?? ?? ?? ?? 83 78 44 00 75 07 6A 00 E8 ?? ?? ?? ?? 8B 45 1C C7 40 08 04 00 10 00 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 B0 E8 ?? ?? ?? ?? 8D 45 A0 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 A0 8D 45 B0 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 0F B6 40 59 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 45 90 E8 ?? ?? ?? ?? 8D 45 80 BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 55 80 8D 45 90 E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 8B 43 0C E8 ?? ?? ?? ?? 50 8D 55 0C 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 8D 85 60 FF FF FF BA 01 00 00 00 B1 01 E8 ?? ?? ?? ?? 8D 95 60 FF FF FF 8D 85 70 FF FF FF E8 ?? ?? ?? ?? 8B D6 58 E8 ?? ?? ?? ?? 8B 40 44 8B 10 FF 52 5C 83 E0 7F 8B 04 85 ?? ?? ?? ?? 8B 55 1C 09 42 08 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 60 FF FF FF 8B 15 ?? ?? ?? ?? B9 0A 00 00 00 E8 ?? ?? ?? ?? 8D 45 0C E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DA 8B C7 5F 5E 5B 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule function_31_0 {
	meta:
		name = "ABAccessibility"
		size = 8
		refs = "0002 _DV_3"
		altNames = "ActnPopup ApacheHTTP ApacheTwoHTTP AspTlb AutoDisp AzureUI Binder2000 ComObjWrapper Contnrs DBCommon DBXCommonIndy DBXDataExpressMetaDataProvider DBXFirebirdMetaDataWriter DBXInformixMetaDataWriter DBXInterbaseMetaDataWriter DBXMessageHandlerJSonClient DBXMetaDataCommandFactory DBXMetaDataReader DBXMsSqlMetaDataWriter DBXMySqlMetaDataWriter DBXReaderTableStorage DBXSybaseASAMetaDataWriter DBXSybaseASEMetaDataWriter DBXTransport DBXTypedTableStorage DSAzureTable DSClientCreators DSConnectProtocolTypeWizardPage DSConnectToTypeWizardPage DSConnectToWizardPage DSConnectionProperties DSPortsWizardPage DSProd DSProjectLocationWizardPage DSServerClassWizardPage DSStandAloneAppWizardPage DSTCPServerTransport DateUtils DbgSiteAS GDIPAPI Generics.Collections IdBaseComponent IdCoder IdCoder00E IdCoder3to4 IdCoderQuotedPrintable IdContainers IdCoreDsnRegister IdExceptionCore IdFTPListOutput IdHTTPProxyServer IdHashCRC IdIPAddrMon IdIPMCastClient IdIPWatch IdMailBox IdMappedPOP3 IdMappedPortTCP IdMessageClient IdMessageCollection IdNetworkCalculator IdRawHeaders IdRemoteCMDClient IdReplyFTP IdSASLUserPass IdSNMP IdSchedulerOfThread IdServerInterceptLogBase IdSimpleServer IdSocketHandle IdSocks IdSysLogMessage IdTCPClient IdTCPServer IdThreadComponent IdTime IdTimeServer IdTimeUDP IdTimeUDPServer IdUDPClient IdURI ImgList IndySockTransport IsapiHTTP MPlayer MSPpt2000 Masks MidasCon PagItems Printers RegularExpressions SConnect SOAPAttach SOAPHTTPPasInv SQLProxyDesigner ScktMain SimpleDS SockAppReg SqlEdit SqlReg SvnClientCommitFrame SvnClientLoginPrompt TabNotBk TeeDBEdit TeeEdiGene TeeNavigator TeePenDlg WSILIntf XMLBrokr XMLIniFile XMLIntf XMLSchemaTags msxml svn_client"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6255_0 {
	meta:
		name = "ADOConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6688_0 {
	meta:
		name = "ADODB2000"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6698_0 {
	meta:
		name = "ADODBXP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6712_0 {
	meta:
		name = "ADOInt"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8428_0 {
	meta:
		name = "ASPBehavior"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65_0 {
	meta:
		name = "AbnfUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67_0 {
	meta:
		name = "AccCtrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_1991_0 {
	meta:
		name = "Access2000"
		size = 8
		refs = "0002 _DV_67"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4823_0 {
	meta:
		name = "AccessXP"
		size = 8
		refs = "0002 _DV_48"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4881_0 {
	meta:
		name = "AclAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_4883_0 {
	meta:
		name = "ActivDbgLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5269_0 {
	meta:
		name = "ActiveX"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5276_0 {
	meta:
		name = "ActnColorMaps"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_5398_0 {
	meta:
		name = "ActnCtrls"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6134_0 {
	meta:
		name = "ActnRes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6240_0 {
	meta:
		name = "AdaptReq"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6244_0 {
	meta:
		name = "AddConn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_6253_0 {
	meta:
		name = "AdoConEd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8066_0 {
	meta:
		name = "AdsConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8102_0 {
	meta:
		name = "AdsTypes"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8204_0 {
	meta:
		name = "AnsiStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8385_0 {
	meta:
		name = "AscrLib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8555_0 {
	meta:
		name = "AutoAdap"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9216_0 {
	meta:
		name = "BDE"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8898_0 {
	meta:
		name = "BandActn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9273_0 {
	meta:
		name = "BrkrConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9374_0 {
	meta:
		name = "ButtonGroup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9835_0 {
	meta:
		name = "CGIHTTP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11915_0 {
	meta:
		name = "COMAdmin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9510_0 {
	meta:
		name = "Calendar"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9775_0 {
	meta:
		name = "CertHelper"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9936_0 {
	meta:
		name = "Character"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11368_0 {
	meta:
		name = "ClassRegistry"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11472_0 {
	meta:
		name = "CmAdmCtl"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11884_0 {
	meta:
		name = "CodecUtilsWin32"
		size = 8
		refs = "0002 _DV_211"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11913_0 {
	meta:
		name = "ColorGrd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11918_0 {
	meta:
		name = "ComApp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_11920_0 {
	meta:
		name = "ComConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14175_0 {
	meta:
		name = "ComStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14177_0 {
	meta:
		name = "ComSvcs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13900_0 {
	meta:
		name = "CommCtrl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_13930_0 {
	meta:
		name = "CommDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14135_0 {
	meta:
		name = "CompProd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_14179_0 {
	meta:
		name = "Consts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15286_0 {
	meta:
		name = "CopyPrsr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15325_0 {
	meta:
		name = "Cor"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15327_0 {
	meta:
		name = "CorError"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15468_0 {
	meta:
		name = "CorHdr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15470_0 {
	meta:
		name = "Cpl"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15640_0 {
	meta:
		name = "CtlConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_15774_0 {
	meta:
		name = "D2D1"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16080_0 {
	meta:
		name = "D3DX8"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16570_0 {
	meta:
		name = "D3DX9"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16590_0 {
	meta:
		name = "DAO2000"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16610_0 {
	meta:
		name = "DAOXP"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18332_0 {
	meta:
		name = "DBActns"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18559_0 {
	meta:
		name = "DBAdapt"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18586_0 {
	meta:
		name = "DBBdeWeb"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18599_0 {
	meta:
		name = "DBByteBuffer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18667_0 {
	meta:
		name = "DBCGrids"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_18713_0 {
	meta:
		name = "DBChart"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19019_0 {
	meta:
		name = "DBClient"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19021_0 {
	meta:
		name = "DBClientActnRes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19034_0 {
	meta:
		name = "DBClientActns"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19120_0 {
	meta:
		name = "DBCommonTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19138_0 {
	meta:
		name = "DBConnAdmin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19140_0 {
	meta:
		name = "DBConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19592_0 {
	meta:
		name = "DBDrvEd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_19872_0 {
	meta:
		name = "DBGrids"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20038_0 {
	meta:
		name = "DBOleCtl"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20057_0 {
	meta:
		name = "DBOleEdt"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20079_0 {
	meta:
		name = "DBPlatform"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20776_0 {
	meta:
		name = "DBWeb"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20835_0 {
	meta:
		name = "DBXClient"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20841_0 {
	meta:
		name = "DBXClientResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22251_0 {
	meta:
		name = "DBXCommonResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22397_0 {
	meta:
		name = "DBXCommonTable"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22540_0 {
	meta:
		name = "DBXCustomDataGenerator"
		size = 8
		refs = "0002 _DV_91"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22690_0 {
	meta:
		name = "DBXDBMetaData"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22865_0 {
	meta:
		name = "DBXDBReaders"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22674_0 {
	meta:
		name = "DBXDb2MetaDataReader"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22682_0 {
	meta:
		name = "DBXDb2MetaDataWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23144_0 {
	meta:
		name = "DBXDelegate"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23276_0 {
	meta:
		name = "DBXDynalinkNative"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23288_0 {
	meta:
		name = "DBXEncryption"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23291_0 {
	meta:
		name = "DBXEntReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23353_0 {
	meta:
		name = "DBXFirebirdMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23470_0 {
	meta:
		name = "DBXInformixMetaDataReader"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23547_0 {
	meta:
		name = "DBXInterbaseMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23712_0 {
	meta:
		name = "DBXJSON"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23722_0 {
	meta:
		name = "DBXJSONCommon"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_23988_0 {
	meta:
		name = "DBXJSONReflect"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25007_0 {
	meta:
		name = "DBXMemoryRow"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25070_0 {
	meta:
		name = "DBXMessageHandlerCommon"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25140_0 {
	meta:
		name = "DBXMessageHandlerJSonCommon"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25207_0 {
	meta:
		name = "DBXMessageHandlerJSonServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25243_0 {
	meta:
		name = "DBXMessageHandlerServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25277_0 {
	meta:
		name = "DBXMetaDataCommand"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25307_0 {
	meta:
		name = "DBXMetaDataError"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25309_0 {
	meta:
		name = "DBXMetaDataNames"
		size = 8
		refs = "0002 _DV_74"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25420_0 {
	meta:
		name = "DBXMetaDataProvider"
		size = 8
		refs = "0002 _DV_43"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25669_0 {
	meta:
		name = "DBXMetaDataUtil"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25799_0 {
	meta:
		name = "DBXMetaDataWriter"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25304_0 {
	meta:
		name = "DBXMetadataCommon"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_25874_0 {
	meta:
		name = "DBXMsSqlMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26040_0 {
	meta:
		name = "DBXMySqlMetaDataReader"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26414_0 {
	meta:
		name = "DBXOCL"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_26936_0 {
	meta:
		name = "DBXOpenSSLRes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27003_0 {
	meta:
		name = "DBXOracleMetaDataReader"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27013_0 {
	meta:
		name = "DBXOracleMetaDataWriter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27138_0 {
	meta:
		name = "DBXPlatform"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27225_0 {
	meta:
		name = "DBXRSAFilter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27211_0 {
	meta:
		name = "DBXReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27293_0 {
	meta:
		name = "DBXSqlScanner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27544_0 {
	meta:
		name = "DBXStream"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27621_0 {
	meta:
		name = "DBXStreamPlatform"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27555_0 {
	meta:
		name = "DBXStreamer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27675_0 {
	meta:
		name = "DBXSybaseASAMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27760_0 {
	meta:
		name = "DBXSybaseASEMetaDataReader"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27783_0 {
	meta:
		name = "DBXTableFactory"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27807_0 {
	meta:
		name = "DBXTestResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28224_0 {
	meta:
		name = "DBXTransportFilter"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27194_0 {
	meta:
		name = "DBXpressWeb"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28727_0 {
	meta:
		name = "DDEml"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30137_0 {
	meta:
		name = "DSAuth"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30162_0 {
	meta:
		name = "DSAzDlgACL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30174_0 {
	meta:
		name = "DSAzDlgBlock"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30201_0 {
	meta:
		name = "DSAzDlgBlockBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30399_0 {
	meta:
		name = "DSAzDlgBlockProps"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30425_0 {
	meta:
		name = "DSAzDlgCopyBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30629_0 {
	meta:
		name = "DSAzDlgCreateContainer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30823_0 {
	meta:
		name = "DSAzDlgMetadata"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30840_0 {
	meta:
		name = "DSAzDlgPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30861_0 {
	meta:
		name = "DSAzDlgPageBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31053_0 {
	meta:
		name = "DSAzDlgPageProps"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31078_0 {
	meta:
		name = "DSAzDlgPutBlockList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31279_0 {
	meta:
		name = "DSAzDlgSnapshotBlob"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_31582_0 {
	meta:
		name = "DSAzure"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32399_0 {
	meta:
		name = "DSAzureMessageDialog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32468_0 {
	meta:
		name = "DSAzureQueue"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32533_0 {
	meta:
		name = "DSAzureReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32669_0 {
	meta:
		name = "DSAzureTableDialog"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32991_0 {
	meta:
		name = "DSAzureTableRowDialog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33014_0 {
	meta:
		name = "DSClientDsnResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33064_0 {
	meta:
		name = "DSClientMetadata"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33540_0 {
	meta:
		name = "DSClientModuleCreators"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33550_0 {
	meta:
		name = "DSClientModuleForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33590_0 {
	meta:
		name = "DSClientModuleReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33634_0 {
	meta:
		name = "DSClientMrWizard"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_33743_0 {
	meta:
		name = "DSClientReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34118_0 {
	meta:
		name = "DSClientResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34274_0 {
	meta:
		name = "DSClientRest"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34588_0 {
	meta:
		name = "DSClientSource"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34590_0 {
	meta:
		name = "DSCommonDsnResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34637_0 {
	meta:
		name = "DSCommonProxy"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_34642_0 {
	meta:
		name = "DSCommonReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35012_0 {
	meta:
		name = "DSCommonServer"
		size = 8
		refs = "0002 _DV_63"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35096_0 {
	meta:
		name = "DSCommonTable"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35121_0 {
	meta:
		name = "DSConnect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_35897_0 {
	meta:
		name = "DSCreators"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_36583_0 {
	meta:
		name = "DSHTTPCommon"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37812_0 {
	meta:
		name = "DSHTTPWebBroker"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37815_0 {
	meta:
		name = "DSIndy10ServerTransportReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_37892_0 {
	meta:
		name = "DSMrWizardCommon"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38153_0 {
	meta:
		name = "DSNames"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38227_0 {
	meta:
		name = "DSPortFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38726_0 {
	meta:
		name = "DSProviderClientReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_38747_0 {
	meta:
		name = "DSProxy"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40799_0 {
	meta:
		name = "DSProxyRest"
		size = 8
		refs = "0002 _DV_62"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_40862_0 {
	meta:
		name = "DSProxyWriter"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41340_0 {
	meta:
		name = "DSProxyWriterRegistry"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41779_0 {
	meta:
		name = "DSReflect"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41846_0 {
	meta:
		name = "DSRestClientModuleForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_41848_0 {
	meta:
		name = "DSRestConnectionFrameUnit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44280_0 {
	meta:
		name = "DSSQLClientModuleForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44344_0 {
	meta:
		name = "DSSQLConnectionFrameUnit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42691_0 {
	meta:
		name = "DSServerDsnResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42712_0 {
	meta:
		name = "DSServerMethodsClassGen"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_42718_0 {
	meta:
		name = "DSServerMethodsFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43134_0 {
	meta:
		name = "DSServerReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43136_0 {
	meta:
		name = "DSServerResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_43144_0 {
	meta:
		name = "DSServerScriptGen"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44276_0 {
	meta:
		name = "DSSource"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44404_0 {
	meta:
		name = "DSStandAloneCreators"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44416_0 {
	meta:
		name = "DSStandAloneForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44437_0 {
	meta:
		name = "DSStandAloneReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44465_0 {
	meta:
		name = "DSTransport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44477_0 {
	meta:
		name = "DSUtil"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44479_0 {
	meta:
		name = "DSWebBrokerFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44486_0 {
	meta:
		name = "DSWebBrokerLocationFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44554_0 {
	meta:
		name = "DSWebBrokerReg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44589_0 {
	meta:
		name = "DUnitAbout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44591_0 {
	meta:
		name = "DUnitConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44597_0 {
	meta:
		name = "DUnitMainForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44659_0 {
	meta:
		name = "DX7toDX8"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44665_0 {
	meta:
		name = "DXFile"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44669_0 {
	meta:
		name = "DXTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_16648_0 {
	meta:
		name = "DataBkr"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22583_0 {
	meta:
		name = "DbxDataGenerator"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_22926_0 {
	meta:
		name = "DbxDefaultTestDriverUnits"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27274_0 {
	meta:
		name = "DbxSqlEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_27805_0 {
	meta:
		name = "DbxTest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28737_0 {
	meta:
		name = "DeployAddFileForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28744_0 {
	meta:
		name = "DeployAmazonEC2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28764_0 {
	meta:
		name = "DeployAuthenticationPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28781_0 {
	meta:
		name = "DeployFilesPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28852_0 {
	meta:
		name = "DeployMessageService"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28859_0 {
	meta:
		name = "DeployProgressForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28861_0 {
	meta:
		name = "DeployResStrs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28889_0 {
	meta:
		name = "DeployStorage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_28968_0 {
	meta:
		name = "DeploySummaryPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29041_0 {
	meta:
		name = "DeployToCloudMenu"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29048_0 {
	meta:
		name = "DeployTypes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29127_0 {
	meta:
		name = "DeployWizardForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29212_0 {
	meta:
		name = "Diagnostics"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29919_0 {
	meta:
		name = "DirOutln"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29613_0 {
	meta:
		name = "Direct2D"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29725_0 {
	meta:
		name = "Direct3D"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29755_0 {
	meta:
		name = "Direct3D8"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29791_0 {
	meta:
		name = "Direct3D9"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29811_0 {
	meta:
		name = "DirectDraw"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29831_0 {
	meta:
		name = "DirectInput"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29838_0 {
	meta:
		name = "DirectMusic"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29841_0 {
	meta:
		name = "DirectPlay8"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29877_0 {
	meta:
		name = "DirectShow9"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29899_0 {
	meta:
		name = "DirectSound"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_29921_0 {
	meta:
		name = "Dlgs"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_30102_0 {
	meta:
		name = "DrTable"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44653_0 {
	meta:
		name = "Dwmapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44661_0 {
	meta:
		name = "DxDiag"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44667_0 {
	meta:
		name = "DxgiFormat"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44685_0 {
	meta:
		name = "EditChar"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_44699_0 {
	meta:
		name = "EncdDecd"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_45977_0 {
	meta:
		name = "EncodingUtils"
		size = 8
		refs = "0002 _DV_652"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49851_0 {
	meta:
		name = "ExDispID"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_47787_0 {
	meta:
		name = "Excel2000"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49847_0 {
	meta:
		name = "ExcelXP"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_49960_0 {
	meta:
		name = "ExtActns"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50622_0 {
	meta:
		name = "FileCtrl"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_50653_0 {
	meta:
		name = "FldEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52152_0 {
	meta:
		name = "GDIPOBJ"
		size = 8
		refs = "0002 _DV_62"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_54103_0 {
	meta:
		name = "GIFConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55625_0 {
	meta:
		name = "GUITestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_51342_0 {
	meta:
		name = "Gauges"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52904_0 {
	meta:
		name = "Generics.Defaults"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_52924_0 {
	meta:
		name = "GestureConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53031_0 {
	meta:
		name = "GestureCtrls"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_53449_0 {
	meta:
		name = "GestureMgr"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55486_0 {
	meta:
		name = "Grids"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56084_0 {
	meta:
		name = "HTTPD"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56249_0 {
	meta:
		name = "HTTPD2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56311_0 {
	meta:
		name = "HTTPParse"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56396_0 {
	meta:
		name = "HTTPProd"
		size = 8
		refs = "0002 _DV_71"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56400_0 {
	meta:
		name = "HTTPSOAPToPasBind"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56428_0 {
	meta:
		name = "HTTPUtil"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_55655_0 {
	meta:
		name = "HelpIntfs"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63451_0 {
	meta:
		name = "IEActions"
		size = 8
		refs = "0002 _DV_89"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64386_0 {
	meta:
		name = "IOUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56470_0 {
	meta:
		name = "IdASN1Util"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56439_0 {
	meta:
		name = "IdAboutVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56441_0 {
	meta:
		name = "IdAllAuthentications"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56443_0 {
	meta:
		name = "IdAllFTPListParsers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56445_0 {
	meta:
		name = "IdAllHeaderCoders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56448_0 {
	meta:
		name = "IdAntiFreeze"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56456_0 {
	meta:
		name = "IdAntiFreezeBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56472_0 {
	meta:
		name = "IdAssignedNumbers"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56485_0 {
	meta:
		name = "IdAttachment"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56494_0 {
	meta:
		name = "IdAttachmentFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56507_0 {
	meta:
		name = "IdAttachmentMemory"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56552_0 {
	meta:
		name = "IdAuthenticationManager"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56646_0 {
	meta:
		name = "IdBlockCipherIntercept"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56685_0 {
	meta:
		name = "IdBuffer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57020_0 {
	meta:
		name = "IdCTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56689_0 {
	meta:
		name = "IdChargenServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56693_0 {
	meta:
		name = "IdChargenUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56699_0 {
	meta:
		name = "IdCharsets"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56714_0 {
	meta:
		name = "IdCmdTCPClient"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56747_0 {
	meta:
		name = "IdCmdTCPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56797_0 {
	meta:
		name = "IdCoderHeader"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56847_0 {
	meta:
		name = "IdCommandHandlers"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56867_0 {
	meta:
		name = "IdCompressionIntercept"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56878_0 {
	meta:
		name = "IdCompressorZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56884_0 {
	meta:
		name = "IdConnectThroughHttpProxy"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56909_0 {
	meta:
		name = "IdContext"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_56986_0 {
	meta:
		name = "IdCookie"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57004_0 {
	meta:
		name = "IdCookieManager"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57018_0 {
	meta:
		name = "IdCoreSelectionEditors"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57111_0 {
	meta:
		name = "IdCustomHTTPServer"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57151_0 {
	meta:
		name = "IdCustomTCPServer"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57167_0 {
	meta:
		name = "IdCustomTransparentProxy"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57273_0 {
	meta:
		name = "IdDICT"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57298_0 {
	meta:
		name = "IdDICTCommon"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57314_0 {
	meta:
		name = "IdDICTServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57522_0 {
	meta:
		name = "IdDNSResolver"
		size = 8
		refs = "0002 _DV_02"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57623_0 {
	meta:
		name = "IdDNSServer"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57238_0 {
	meta:
		name = "IdDateTimeStamp"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57242_0 {
	meta:
		name = "IdDayTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57246_0 {
	meta:
		name = "IdDayTimeServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57250_0 {
	meta:
		name = "IdDayTimeUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57254_0 {
	meta:
		name = "IdDayTimeUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57318_0 {
	meta:
		name = "IdDiscardServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57321_0 {
	meta:
		name = "IdDiscardUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57625_0 {
	meta:
		name = "IdDsnCoreResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57653_0 {
	meta:
		name = "IdDsnPropEdBindingVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57660_0 {
	meta:
		name = "IdDsnRegister"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57662_0 {
	meta:
		name = "IdDsnResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57679_0 {
	meta:
		name = "IdDsnSASLListEditorFormVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57719_0 {
	meta:
		name = "IdEMailAddress"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57683_0 {
	meta:
		name = "IdEcho"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57687_0 {
	meta:
		name = "IdEchoServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57691_0 {
	meta:
		name = "IdEchoUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57695_0 {
	meta:
		name = "IdEchoUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57723_0 {
	meta:
		name = "IdException"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57749_0 {
	meta:
		name = "IdExplicitTLSClientServerBase"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57820_0 {
	meta:
		name = "IdFSP"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57956_0 {
	meta:
		name = "IdFTP"
		size = 8
		refs = "0002 _DV_23"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57976_0 {
	meta:
		name = "IdFTPBaseFileSystem"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58064_0 {
	meta:
		name = "IdFTPCommon"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58075_0 {
	meta:
		name = "IdFTPList"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58581_0 {
	meta:
		name = "IdFTPListTypes"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58766_0 {
	meta:
		name = "IdFTPServerContextBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57755_0 {
	meta:
		name = "IdFinger"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_57759_0 {
	meta:
		name = "IdFingerServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_58991_0 {
	meta:
		name = "IdGlobalCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59140_0 {
	meta:
		name = "IdGopher"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59142_0 {
	meta:
		name = "IdGopherConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59148_0 {
	meta:
		name = "IdGopherServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59312_0 {
	meta:
		name = "IdHMACMD5"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59334_0 {
	meta:
		name = "IdHMACSHA1"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59398_0 {
	meta:
		name = "IdHTTP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59449_0 {
	meta:
		name = "IdHTTPHeaderInfo"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59463_0 {
	meta:
		name = "IdHTTPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59191_0 {
	meta:
		name = "IdHash"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59202_0 {
	meta:
		name = "IdHashElf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59222_0 {
	meta:
		name = "IdHashMessageDigest"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59239_0 {
	meta:
		name = "IdHashSHA"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59292_0 {
	meta:
		name = "IdHeaderList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59740_0 {
	meta:
		name = "IdIMAP4"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59812_0 {
	meta:
		name = "IdIMAP4Server"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59927_0 {
	meta:
		name = "IdIOHandler"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59950_0 {
	meta:
		name = "IdIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59978_0 {
	meta:
		name = "IdIOHandlerStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59990_0 {
	meta:
		name = "IdIPAddress"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60017_0 {
	meta:
		name = "IdIPMCastBase"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60048_0 {
	meta:
		name = "IdIPMCastServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60214_0 {
	meta:
		name = "IdIRC"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59535_0 {
	meta:
		name = "IdIcmpClient"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59546_0 {
	meta:
		name = "IdIdent"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59553_0 {
	meta:
		name = "IdIdentServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59823_0 {
	meta:
		name = "IdIntercept"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59831_0 {
	meta:
		name = "IdInterceptSimLog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59836_0 {
	meta:
		name = "IdInterceptThrottler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60262_0 {
	meta:
		name = "IdIrcServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60327_0 {
	meta:
		name = "IdLPR"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60285_0 {
	meta:
		name = "IdLogDebug"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60290_0 {
	meta:
		name = "IdLogEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60300_0 {
	meta:
		name = "IdLogFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60307_0 {
	meta:
		name = "IdLogStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60351_0 {
	meta:
		name = "IdMappedFTP"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60388_0 {
	meta:
		name = "IdMappedPortUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60395_0 {
	meta:
		name = "IdMappedTelnet"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60446_0 {
	meta:
		name = "IdMessage"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60484_0 {
	meta:
		name = "IdMessageBuilder"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60535_0 {
	meta:
		name = "IdMessageCoder"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60624_0 {
	meta:
		name = "IdMessageParts"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60656_0 {
	meta:
		name = "IdMultipartFormData"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60760_0 {
	meta:
		name = "IdNNTP"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60820_0 {
	meta:
		name = "IdNNTPServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60831_0 {
	meta:
		name = "IdNTLM"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60853_0 {
	meta:
		name = "IdOSFileName"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60868_0 {
	meta:
		name = "IdOTPCalculator"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60892_0 {
	meta:
		name = "IdPOP3"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60922_0 {
	meta:
		name = "IdPOP3Server"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60934_0 {
	meta:
		name = "IdQOTDUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60939_0 {
	meta:
		name = "IdQOTDUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60926_0 {
	meta:
		name = "IdQotd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60930_0 {
	meta:
		name = "IdQotdServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61237_0 {
	meta:
		name = "IdRSH"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61241_0 {
	meta:
		name = "IdRSHServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60953_0 {
	meta:
		name = "IdRawBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60955_0 {
	meta:
		name = "IdRawClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60971_0 {
	meta:
		name = "IdRawFunctions"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61094_0 {
	meta:
		name = "IdRegister"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61097_0 {
	meta:
		name = "IdRegisterCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61113_0 {
	meta:
		name = "IdRemoteCMDServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61144_0 {
	meta:
		name = "IdReply"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61170_0 {
	meta:
		name = "IdReplyIMAP4"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61185_0 {
	meta:
		name = "IdReplyPOP3"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61198_0 {
	meta:
		name = "IdReplyRFC"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61219_0 {
	meta:
		name = "IdReplySMTP"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61221_0 {
	meta:
		name = "IdResourceStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61223_0 {
	meta:
		name = "IdResourceStringsCore"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61225_0 {
	meta:
		name = "IdResourceStringsProtocols"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61229_0 {
	meta:
		name = "IdRexec"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61233_0 {
	meta:
		name = "IdRexecServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61258_0 {
	meta:
		name = "IdSASLAnonymous"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61277_0 {
	meta:
		name = "IdSASLCollection"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61289_0 {
	meta:
		name = "IdSASLDigest"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61295_0 {
	meta:
		name = "IdSASLExternal"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61301_0 {
	meta:
		name = "IdSASLLogin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61308_0 {
	meta:
		name = "IdSASLOTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61313_0 {
	meta:
		name = "IdSASLPlain"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61320_0 {
	meta:
		name = "IdSASLSKey"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61332_0 {
	meta:
		name = "IdSASL_CRAMBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61337_0 {
	meta:
		name = "IdSASL_CRAM_MD5"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61341_0 {
	meta:
		name = "IdSASL_CRAM_SHA1"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61447_0 {
	meta:
		name = "IdSMTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61469_0 {
	meta:
		name = "IdSMTPBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61497_0 {
	meta:
		name = "IdSMTPRelay"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61555_0 {
	meta:
		name = "IdSMTPServer"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61592_0 {
	meta:
		name = "IdSNPP"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61601_0 {
	meta:
		name = "IdSNTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62142_0 {
	meta:
		name = "IdSSPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61351_0 {
	meta:
		name = "IdScheduler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61366_0 {
	meta:
		name = "IdSchedulerOfThreadDefault"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61375_0 {
	meta:
		name = "IdSchedulerOfThreadPool"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61403_0 {
	meta:
		name = "IdServerIOHandler"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61408_0 {
	meta:
		name = "IdServerIOHandlerSocket"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61412_0 {
	meta:
		name = "IdServerIOHandlerStack"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61390_0 {
	meta:
		name = "IdServerInterceptLogEvent"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61395_0 {
	meta:
		name = "IdServerInterceptLogFile"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_61703_0 {
	meta:
		name = "IdSocksServer"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62249_0 {
	meta:
		name = "IdStackBSDBase"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62251_0 {
	meta:
		name = "IdStackConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62314_0 {
	meta:
		name = "IdStream"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62319_0 {
	meta:
		name = "IdStreamVCL"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62329_0 {
	meta:
		name = "IdStrings"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62354_0 {
	meta:
		name = "IdStruct"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62366_0 {
	meta:
		name = "IdSync"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62373_0 {
	meta:
		name = "IdSysLog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62415_0 {
	meta:
		name = "IdSysLogServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62419_0 {
	meta:
		name = "IdSystat"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62423_0 {
	meta:
		name = "IdSystatServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62427_0 {
	meta:
		name = "IdSystatUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62432_0 {
	meta:
		name = "IdSystatUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62506_0 {
	meta:
		name = "IdTCPConnection"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62516_0 {
	meta:
		name = "IdTCPStream"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62444_0 {
	meta:
		name = "IdTask"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62531_0 {
	meta:
		name = "IdTelnet"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62539_0 {
	meta:
		name = "IdTelnetServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62549_0 {
	meta:
		name = "IdText"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62687_0 {
	meta:
		name = "IdThreadSafe"
		size = 8
		refs = "0002 _DV_11"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62711_0 {
	meta:
		name = "IdTraceRoute"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62722_0 {
	meta:
		name = "IdTrivialFTP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62729_0 {
	meta:
		name = "IdTrivialFTPBase"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62752_0 {
	meta:
		name = "IdTrivialFTPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62779_0 {
	meta:
		name = "IdUDPBase"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62826_0 {
	meta:
		name = "IdUDPServer"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62829_0 {
	meta:
		name = "IdUnixTime"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62832_0 {
	meta:
		name = "IdUnixTimeServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62835_0 {
	meta:
		name = "IdUnixTimeUDP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62838_0 {
	meta:
		name = "IdUnixTimeUDPServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62854_0 {
	meta:
		name = "IdUriUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62889_0 {
	meta:
		name = "IdUserAccounts"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62891_0 {
	meta:
		name = "IdUserPassProvider"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62950_0 {
	meta:
		name = "IdVCard"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62969_0 {
	meta:
		name = "IdWebDAV"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62977_0 {
	meta:
		name = "IdWhoIsServer"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_62973_0 {
	meta:
		name = "IdWhois"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63152_0 {
	meta:
		name = "IdWship6"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63154_0 {
	meta:
		name = "IdYarn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63200_0 {
	meta:
		name = "IdZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63216_0 {
	meta:
		name = "IdZLibCompressorBase"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63218_0 {
	meta:
		name = "IdZLibConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63286_0 {
	meta:
		name = "IdZLibHeaders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60264_0 {
	meta:
		name = "Idispids"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63515_0 {
	meta:
		name = "ImageHlp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63673_0 {
	meta:
		name = "Imm"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63788_0 {
	meta:
		name = "IniFiles"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63925_0 {
	meta:
		name = "IntfInfo"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63927_0 {
	meta:
		name = "InvConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64138_0 {
	meta:
		name = "InvRules"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63932_0 {
	meta:
		name = "Invoker"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64388_0 {
	meta:
		name = "IpExport"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64446_0 {
	meta:
		name = "IpHlpApi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64448_0 {
	meta:
		name = "IpRtrMib"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64450_0 {
	meta:
		name = "IpTypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64452_0 {
	meta:
		name = "Isapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64454_0 {
	meta:
		name = "Isapi2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64527_0 {
	meta:
		name = "JConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_64799_0 {
	meta:
		name = "Keyboard"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65030_0 {
	meta:
		name = "KeyboardTypes"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65268_0 {
	meta:
		name = "KnownFolders"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65345_0 {
	meta:
		name = "LZExpand"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65281_0 {
	meta:
		name = "LangUtils"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65332_0 {
	meta:
		name = "ListActns"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65785_0 {
	meta:
		name = "MConnect"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66783_0 {
	meta:
		name = "MMSystem"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66906_0 {
	meta:
		name = "MSComctlLibXP"
		size = 8
		refs = "0002 _DV_42"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66908_0 {
	meta:
		name = "MSDATASRCXP"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66928_0 {
	meta:
		name = "MSForms2000"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67180_0 {
	meta:
		name = "MSHTML"
		size = 8
		refs = "0002 _DV_221"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65347_0 {
	meta:
		name = "Manipulations"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65362_0 {
	meta:
		name = "Mapi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65417_0 {
	meta:
		name = "Mask"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65450_0 {
	meta:
		name = "MaskUtils"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_65733_0 {
	meta:
		name = "Math"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66011_0 {
	meta:
		name = "Messages"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66139_0 {
	meta:
		name = "MidComp"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66141_0 {
	meta:
		name = "MidConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66578_0 {
	meta:
		name = "MidProd"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66013_0 {
	meta:
		name = "Midas"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67182_0 {
	meta:
		name = "MsInkAut"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67184_0 {
	meta:
		name = "MsInkAut15"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66932_0 {
	meta:
		name = "Mshtmdid"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67738_0 {
	meta:
		name = "MtsRdm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67717_0 {
	meta:
		name = "Mtsobj"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67748_0 {
	meta:
		name = "Mtx"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67757_0 {
	meta:
		name = "MultiMon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67760_0 {
	meta:
		name = "Nb30"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_69132_0 {
	meta:
		name = "OPConvert"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_73831_0 {
	meta:
		name = "OWC10XP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67785_0 {
	meta:
		name = "ObjAuto"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67808_0 {
	meta:
		name = "ObjBrkr"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67829_0 {
	meta:
		name = "ObjComAuto"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67831_0 {
	meta:
		name = "ObjectArray"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67839_0 {
	meta:
		name = "Office2000"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_67849_0 {
	meta:
		name = "OfficeXP"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_68525_0 {
	meta:
		name = "Ole2"
		size = 8
		refs = "0002 _DV_17"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_68609_0 {
	meta:
		name = "OleConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_68715_0 {
	meta:
		name = "OleCtl"
		size = 8
		refs = "0002 _DV_12"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_69075_0 {
	meta:
		name = "OleDB"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_69102_0 {
	meta:
		name = "OleDlg"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_69134_0 {
	meta:
		name = "OpConvertOptions"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_70023_0 {
	meta:
		name = "Outline"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_71812_0 {
	meta:
		name = "Outlook2000"
		size = 8
		refs = "0002 _DV_75"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_73821_0 {
	meta:
		name = "OutlookXP"
		size = 8
		refs = "0002 _DV_66"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_73902_0 {
	meta:
		name = "ParserUtilsWin32"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74041_0 {
	meta:
		name = "PenWin"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74553_0 {
	meta:
		name = "PowerPointXP"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74617_0 {
	meta:
		name = "PrivateHeap"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74619_0 {
	meta:
		name = "PropKey"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74752_0 {
	meta:
		name = "PropSys"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74978_0 {
	meta:
		name = "Provider"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75004_0 {
	meta:
		name = "PsAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75006_0 {
	meta:
		name = "Qos"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76424_0 {
	meta:
		name = "RTLConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75135_0 {
	meta:
		name = "RegStr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75025_0 {
	meta:
		name = "Register2000"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75028_0 {
	meta:
		name = "RegisterXP"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75133_0 {
	meta:
		name = "Registry"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75277_0 {
	meta:
		name = "RegularExpressionsAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75279_0 {
	meta:
		name = "RegularExpressionsConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75333_0 {
	meta:
		name = "RegularExpressionsCore"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_75349_0 {
	meta:
		name = "ReqFiles"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76225_0 {
	meta:
		name = "RibbonActnCtrls"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76305_0 {
	meta:
		name = "RibbonConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76324_0 {
	meta:
		name = "RibbonGalleryBar"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76389_0 {
	meta:
		name = "RibbonStyleActnCtrls"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76392_0 {
	meta:
		name = "RichEdit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76422_0 {
	meta:
		name = "Rio"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_76426_0 {
	meta:
		name = "RtsCom"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_79466_0 {
	meta:
		name = "SHDocVw"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_79782_0 {
	meta:
		name = "SHFolder"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80597_0 {
	meta:
		name = "SMINTF"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80660_0 {
	meta:
		name = "SOAPAttachIntf"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80699_0 {
	meta:
		name = "SOAPConn"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80738_0 {
	meta:
		name = "SOAPDm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80749_0 {
	meta:
		name = "SOAPDomConv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80755_0 {
	meta:
		name = "SOAPEnv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80776_0 {
	meta:
		name = "SOAPHTTPClient"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80781_0 {
	meta:
		name = "SOAPHTTPDisp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80835_0 {
	meta:
		name = "SOAPHTTPTrans"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80857_0 {
	meta:
		name = "SOAPLinked"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80870_0 {
	meta:
		name = "SOAPPasInv"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_78121_0 {
	meta:
		name = "ScktCnst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_78270_0 {
	meta:
		name = "ScktComp"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_78594_0 {
	meta:
		name = "ScreenTips"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_78689_0 {
	meta:
		name = "ScrptMgr"
		size = 8
		refs = "0002 _DV_22"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_79124_0 {
	meta:
		name = "Series"
		size = 8
		refs = "0002 _DV_91"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80505_0 {
	meta:
		name = "ShLwApi"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_79198_0 {
	meta:
		name = "ShadowWnd"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_79593_0 {
	meta:
		name = "ShellAPI"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_79468_0 {
	meta:
		name = "ShellAnimations"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_79595_0 {
	meta:
		name = "ShellConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80054_0 {
	meta:
		name = "ShlObj"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80524_0 {
	meta:
		name = "SimpleDSReg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80546_0 {
	meta:
		name = "SiteConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80595_0 {
	meta:
		name = "SiteProd"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_80920_0 {
	meta:
		name = "SockAppNotify"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81054_0 {
	meta:
		name = "SockHTTP"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81077_0 {
	meta:
		name = "SockRequestInterpreter"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81100_0 {
	meta:
		name = "SockTransport"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81149_0 {
	meta:
		name = "Spin"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81151_0 {
	meta:
		name = "SqlConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81823_0 {
	meta:
		name = "StdActnMenus"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_81927_0 {
	meta:
		name = "StdActns"
		size = 8
		refs = "0002 _DV_83"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82337_0 {
	meta:
		name = "StdCtrls"
		size = 8
		refs = "0002 _DV_72"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82347_0 {
	meta:
		name = "StdVCL"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82396_0 {
	meta:
		name = "StrHlpr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82464_0 {
	meta:
		name = "StrUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82398_0 {
	meta:
		name = "StructuredQuery"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82400_0 {
	meta:
		name = "StructuredQueryCondition"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_82724_0 {
	meta:
		name = "SvnClientCheckout"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83150_0 {
	meta:
		name = "SvnClientConflict"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83266_0 {
	meta:
		name = "SvnClientProjectSelect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83271_0 {
	meta:
		name = "SvnClientRecentComments"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83276_0 {
	meta:
		name = "SvnClientRepoBrowserDialog"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83794_0 {
	meta:
		name = "SvnClientSSLClientCertPrompt"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83799_0 {
	meta:
		name = "SvnClientSSLServerTrustPrompt"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83810_0 {
	meta:
		name = "SvnClientUpdate"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83818_0 {
	meta:
		name = "SvnImages"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83820_0 {
	meta:
		name = "SvnUIConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83822_0 {
	meta:
		name = "SvnUITypes"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83830_0 {
	meta:
		name = "SvnUIUtils"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83887_0 {
	meta:
		name = "SvrConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83966_0 {
	meta:
		name = "SvrHTTPIndy"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83968_0 {
	meta:
		name = "SvrInfoConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84018_0 {
	meta:
		name = "SvrSockRequest"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84159_0 {
	meta:
		name = "SysConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_84193_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_10299_0 {
	meta:
		name = "TBinaryWriter.Create@"
		size = 8
		refs = "0002 TBinaryWriter.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_86117_0 {
	meta:
		name = "TConnect"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_85156_0 {
	meta:
		name = "TEncoding.Create@"
		size = 8
		refs = "0002 TEncoding.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_59501_0 {
	meta:
		name = "TIdHTTPWebBrokerBridgeRequestHandler.Create@"
		size = 8
		refs = "0002 TIdHTTPWebBrokerBridgeRequestHandler.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_85155_0 {
	meta:
		name = "TLanguages.Create@"
		size = 8
		refs = "0002 TLanguages.$ClassInitFlag"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_86096_0 {
	meta:
		name = "Tabs"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90286_0 {
	meta:
		name = "TeExport"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_86818_0 {
	meta:
		name = "TeeAxMaxMin"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_86813_0 {
	meta:
		name = "TeeAxisIncr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_86832_0 {
	meta:
		name = "TeeBackImage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_86913_0 {
	meta:
		name = "TeeBrushDlg"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_86958_0 {
	meta:
		name = "TeeChartExp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87047_0 {
	meta:
		name = "TeeChartGrid"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87174_0 {
	meta:
		name = "TeeCustomShapeEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87243_0 {
	meta:
		name = "TeeData"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87339_0 {
	meta:
		name = "TeeDesignOptions"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87343_0 {
	meta:
		name = "TeeDraw3D"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87373_0 {
	meta:
		name = "TeeEdi3D"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87452_0 {
	meta:
		name = "TeeEdiAxis"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87474_0 {
	meta:
		name = "TeeEdiFont"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87563_0 {
	meta:
		name = "TeeEdiGrad"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87595_0 {
	meta:
		name = "TeeEdiLege"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87611_0 {
	meta:
		name = "TeeEdiPage"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87636_0 {
	meta:
		name = "TeeEdiPane"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87727_0 {
	meta:
		name = "TeeEdiSeri"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87842_0 {
	meta:
		name = "TeeEdiTitl"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87893_0 {
	meta:
		name = "TeeEdiWall"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87868_0 {
	meta:
		name = "TeeEditTools"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87897_0 {
	meta:
		name = "TeeEmbossEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_87957_0 {
	meta:
		name = "TeeExpForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88191_0 {
	meta:
		name = "TeeFiltersEditor"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88215_0 {
	meta:
		name = "TeeFormatting"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88243_0 {
	meta:
		name = "TeeFrames"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88270_0 {
	meta:
		name = "TeeFuncEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88313_0 {
	meta:
		name = "TeeGalleryAlternate"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88586_0 {
	meta:
		name = "TeeLisB"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88595_0 {
	meta:
		name = "TeeMargins"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_88611_0 {
	meta:
		name = "TeeMouseCursor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_89668_0 {
	meta:
		name = "TeePrevi"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_89704_0 {
	meta:
		name = "TeePreviewPanel"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90002_0 {
	meta:
		name = "TeeSelectList"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90020_0 {
	meta:
		name = "TeeShadowEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90098_0 {
	meta:
		name = "TeeSourceEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90212_0 {
	meta:
		name = "TeeStringsEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90227_0 {
	meta:
		name = "TeeSymbolEditor"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90311_0 {
	meta:
		name = "TestExtensions"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90567_0 {
	meta:
		name = "TextTestRunner"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90618_0 {
	meta:
		name = "ThemedActnCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90670_0 {
	meta:
		name = "Themes"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90726_0 {
	meta:
		name = "TimeSpan"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90749_0 {
	meta:
		name = "TlHelp32"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90774_0 {
	meta:
		name = "ToolWin"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90776_0 {
	meta:
		name = "TpcShrd"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90827_0 {
	meta:
		name = "TreeUtils"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90990_0 {
	meta:
		name = "TypInfo"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90847_0 {
	meta:
		name = "Types"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_90996_0 {
	meta:
		name = "UDDIHelper"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91090_0 {
	meta:
		name = "UriUtils"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91092_0 {
	meta:
		name = "UrlHist"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91165_0 {
	meta:
		name = "UrlMon"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91950_0 {
	meta:
		name = "VBIDE2000"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91986_0 {
	meta:
		name = "VBIDEXP"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92008_0 {
	meta:
		name = "VDBConsts"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91330_0 {
	meta:
		name = "ValEdit"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_91537_0 {
	meta:
		name = "VarHlpr"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92368_0 {
	meta:
		name = "WBComp"
		size = 8
		refs = "0002 _DV_64"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98804_0 {
	meta:
		name = "WMF9"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101193_0 {
	meta:
		name = "WSDLBind"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101205_0 {
	meta:
		name = "WSDLIntf"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101298_0 {
	meta:
		name = "WSDLItems"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101393_0 {
	meta:
		name = "WSDLLookup"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101743_0 {
	meta:
		name = "WSDLNode"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_92370_0 {
	meta:
		name = "WbmConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93091_0 {
	meta:
		name = "WebAuto"
		size = 8
		refs = "0002 _DV_41"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93101_0 {
	meta:
		name = "WebBroker"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93114_0 {
	meta:
		name = "WebBrokerSOAP"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93361_0 {
	meta:
		name = "WebCat"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93425_0 {
	meta:
		name = "WebCntxt"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93535_0 {
	meta:
		name = "WebComp"
		size = 8
		refs = "0002 _DV_21"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93537_0 {
	meta:
		name = "WebConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93580_0 {
	meta:
		name = "WebContnrs"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93734_0 {
	meta:
		name = "WebDisp"
		size = 8
		refs = "0002 _DV_81"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93769_0 {
	meta:
		name = "WebFact"
		size = 8
		refs = "0002 _DV_9"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_93846_0 {
	meta:
		name = "WebFileDispatcher"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94330_0 {
	meta:
		name = "WebForm"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94433_0 {
	meta:
		name = "WebModu"
		size = 8
		refs = "0002 _DV_61"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94435_0 {
	meta:
		name = "WebNode"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94718_0 {
	meta:
		name = "WebScript_TLB"
		size = 8
		refs = "0002 _DV_92"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94782_0 {
	meta:
		name = "WebServExp"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_94824_0 {
	meta:
		name = "WebSess"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95018_0 {
	meta:
		name = "WebSnapObjs"
		size = 8
		refs = "0002 _DV_13"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95045_0 {
	meta:
		name = "WebUsers"
		size = 8
		refs = "0002 _DV_8"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95069_0 {
	meta:
		name = "WideSqlEdit"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95333_0 {
	meta:
		name = "WideStrUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95287_0 {
	meta:
		name = "WideStringUtils"
		size = 8
		refs = "0002 _DV_6"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95178_0 {
	meta:
		name = "WideStrings"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98125_0 {
	meta:
		name = "WinInet"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98200_0 {
	meta:
		name = "WinSock"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98604_0 {
	meta:
		name = "WinSpool"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98656_0 {
	meta:
		name = "WinSvc"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_95348_0 {
	meta:
		name = "Wincodec"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98137_0 {
	meta:
		name = "Winsafer"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98346_0 {
	meta:
		name = "Winsock2"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98669_0 {
	meta:
		name = "WizardContentFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98690_0 {
	meta:
		name = "WizardIniOptions"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98703_0 {
	meta:
		name = "WizardMainForm"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_98723_0 {
	meta:
		name = "WizardPageFrame"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_99872_0 {
	meta:
		name = "Word2000"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101085_0 {
	meta:
		name = "WordXP"
		size = 8
		refs = "0002 _DV_51"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_101901_0 {
	meta:
		name = "XMLConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_102147_0 {
	meta:
		name = "XMLDoc"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_102630_0 {
	meta:
		name = "XMLSchema"
		size = 8
		refs = "0002 _DV_15"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_102753_0 {
	meta:
		name = "XPActnCtrls"
		size = 8
		refs = "0002 _DV_01"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_102755_0 {
	meta:
		name = "XPMan"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_102982_0 {
	meta:
		name = "XSLProd"
		size = 8
		refs = "0002 _DV_4"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_102280_0 {
	meta:
		name = "XmlRulesUtils"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_102709_0 {
	meta:
		name = "Xmlxform"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_103046_0 {
	meta:
		name = "ZLib"
		size = 8
		refs = "0002 _DV_7"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_103048_0 {
	meta:
		name = "ZLibConst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_8353_0 {
	meta:
		name = "apr"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_9218_0 {
	meta:
		name = "bdeconst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_20015_0 {
	meta:
		name = "dblookup"
		size = 8
		refs = "0002 _DV_5"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_60833_0 {
	meta:
		name = "idoc"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_63902_0 {
	meta:
		name = "inquire_v1"
		size = 8
		refs = "0002 _DV_94"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_66930_0 {
	meta:
		name = "mshtmcid"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_68537_0 {
	meta:
		name = "oleacc"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_74240_0 {
	meta:
		name = "pnglang"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_83812_0 {
	meta:
		name = "svnconst"
		size = 8
		refs = "0002 _DV_1"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_102679_0 {
	meta:
		name = "xmlutil"
		size = 8
		refs = "0002 _DV_2"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_32_0 {
	meta:
		name = "IsAbnfALPHAWideChar"
		size = 24
		altNames = "IsUriAlphaWideChar"
	strings:
		$1 = { 83 C0 BF 66 83 E8 1A 72 09 83 C0 FA 66 83 E8 1A 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_33_0 {
	meta:
		name = "IsAbnfBITChar"
		size = 18
		altNames = "IsAbnfBITWideChar"
	strings:
		$1 = { 66 83 F8 30 74 06 66 83 F8 31 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_34_0 {
	meta:
		name = "IsAbnfCHARWideChar"
		size = 13
	strings:
		$1 = { 48 66 83 E8 7F 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_35_0 {
	meta:
		name = "IsAbnfCRChar"
		size = 12
		altNames = "IsAbnfCRWideChar"
	strings:
		$1 = { 66 83 F8 0D 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_36_0 {
	meta:
		name = "IsAbnfCRLFWideStr"
		size = 100
		refs = "000c @WStrAddRef 0014 IsAbnfCRLFWideStr 0027 @WStrEqual 0044 @WStrClr 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8D 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 04 B3 01 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 04 00 00 00 0D 00 0A 00 00 00 00 00 }
	condition:
		$1
}

rule function_37_0 {
	meta:
		name = "IsAbnfCTLWideChar"
		size = 18
	strings:
		$1 = { 66 83 E8 20 72 06 66 83 E8 5F 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_38_0 {
	meta:
		name = "IsAbnfDIGITWideChar"
		size = 15
		altNames = "IsUriDigitWideChar"
	strings:
		$1 = { 83 C0 D0 66 83 E8 0A 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_39_0 {
	meta:
		name = "IsAbnfDQUOTEChar"
		size = 12
		altNames = "IsAbnfDQUOTEWideChar"
	strings:
		$1 = { 66 83 F8 22 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_40_0 {
	meta:
		name = "IsAbnfHEXDIGWideChar"
		size = 24
	strings:
		$1 = { 83 C0 D0 66 83 E8 0A 72 09 83 C0 F9 66 83 E8 06 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_41_0 {
	meta:
		name = "IsAbnfHTABChar"
		size = 12
		altNames = "IsAbnfHTABWideChar"
	strings:
		$1 = { 66 83 F8 09 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_42_0 {
	meta:
		name = "IsAbnfLFChar"
		size = 12
		altNames = "IsAbnfLFWideChar"
	strings:
		$1 = { 66 83 F8 0A 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_43_0 {
	meta:
		name = "IsAbnfLWSPWideStr"
		size = 158
		refs = "000c @WStrAddRef 0014 IsAbnfLWSPWideStr 008c @WStrClr 0092 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8D 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 85 C0 74 07 83 E8 04 8B 00 D1 E8 8B D0 85 D2 75 04 33 DB EB 45 B3 01 33 C0 3B D0 7E 3D 40 8B 4D FC 0F B7 4C 41 FE 66 83 E9 09 74 2A 66 83 E9 04 74 08 66 83 E9 13 75 1A EB 1C 3B D0 75 04 33 DB EB 18 40 8B 4D FC 66 83 7C 41 FE 0A 74 08 33 DB EB 08 33 DB EB 04 3B D0 7F C3 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_44_0 {
	meta:
		name = "IsAbnfOCTETWideChar"
		size = 12
	strings:
		$1 = { 66 2D 00 01 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_45_0 {
	meta:
		name = "IsAbnfSPChar"
		size = 12
		altNames = "IsAbnfSPWideChar"
	strings:
		$1 = { 66 83 F8 20 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_46_0 {
	meta:
		name = "IsAbnfVCHARWideChar"
		size = 15
	strings:
		$1 = { 83 C0 DF 66 83 E8 5E 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_47_0 {
	meta:
		name = "IsAbnfWSPWideChar"
		size = 18
	strings:
		$1 = { 66 83 E8 09 74 06 66 83 E8 17 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_48_0 {
	meta:
		name = "IsAbnfALPHAChar"
		size = 18
		altNames = "IsUriAlphaChar"
	strings:
		$1 = { 04 BF 2C 1A 72 06 04 FA 2C 1A 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_50_0 {
	meta:
		name = "IsAbnfCHARChar"
		size = 11
	strings:
		$1 = { 48 2C 7F 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_52_0 {
	meta:
		name = "IsAbnfCRLFStr"
		size = 108
		refs = "000c @UStrAddRef 0014 IsAbnfCRLFStr 0027 @UStrEqual 0044 @UStrClr 004a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 04 B3 01 EB 02 33 DB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 00 00 B0 04 02 00 FF FF FF FF 02 00 00 00 0D 00 0A 00 00 00 00 00 }
	condition:
		$1
}

rule function_53_0 {
	meta:
		name = "IsAbnfCTLChar"
		size = 14
	strings:
		$1 = { 2C 20 72 04 2C 5F 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_54_0 {
	meta:
		name = "IsAbnfDIGITChar"
		size = 12
		altNames = "IsUriDigitChar"
	strings:
		$1 = { 04 D0 2C 0A 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_56_0 {
	meta:
		name = "IsAbnfHEXDIGChar"
		size = 18
	strings:
		$1 = { 04 D0 2C 0A 72 06 04 F9 2C 06 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_59_0 {
	meta:
		name = "IsAbnfLWSPStr"
		size = 153
		refs = "000c @UStrAddRef 0014 IsAbnfLWSPStr 0087 @UStrClr 008d @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 45 FC 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 FC 85 C0 74 05 83 E8 04 8B 00 8B D0 85 D2 75 04 33 DB EB 42 B3 01 33 C0 3B D0 7E 3A 40 8B 4D FC 0F B6 4C 41 FE 80 E9 09 74 28 80 E9 04 74 07 80 E9 13 75 1A EB 1C 3B D0 75 04 33 DB EB 18 40 8B 4D FC 66 83 7C 41 FE 0A 74 08 33 DB EB 08 33 DB EB 04 3B D0 7F C6 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 5D C3 }
	condition:
		$1
}

rule function_60_0 {
	meta:
		name = "IsAbnfOCTETChar"
		size = 6
	strings:
		$1 = { B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_62_0 {
	meta:
		name = "IsAbnfVCHARChar"
		size = 12
	strings:
		$1 = { 04 DF 2C 5E 73 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_63_0 {
	meta:
		name = "IsAbnfWSPChar"
		size = 14
	strings:
		$1 = { 2C 09 74 04 2C 17 75 03 B0 01 C3 33 C0 C3 }
	condition:
		$1
}

rule function_68_0 {
	meta:
		name = "CoFormatCondition.Create"
		size = 100
		refs = "000c CoFormatCondition.Create 001a CLASS_FormatCondition 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 2C 99 7A E2 30 A3 D0 11 81 DD 00 C0 4F C2 F5 1B }
	condition:
		$1
}

rule function_69_0 {
	meta:
		name = "CoFormatCondition.CreateRemote"
		size = 128
		refs = "0011 CoFormatCondition.CreateRemote 0021 @WStrFromUStr 002c CLASS_FormatCondition 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 2C 99 7A E2 30 A3 D0 11 81 DD 00 C0 4F C2 F5 1B }
	condition:
		$1
}

rule function_70_0 {
	meta:
		name = "TAccessApplication.InitServerData"
		size = 9
		refs = "0001 CServerData"
		altNames = "TAccessForm.InitServerData TAccessHyperlink.InitServerData TAccessReferences.InitServerData TAccessReport.InitServerData TAccessWebOptions.InitServerData TAllDataAccessPages.InitServerData TAllDatabaseDiagrams.InitServerData TAllForms.InitServerData TAllFunctions.InitServerData TAllMacros.InitServerData TAllModules.InitServerData TAllQueries.InitServerData TAllReports.InitServerData TAllStoredProcedures.InitServerData TAllTables.InitServerData TAllViews.InitServerData TAppointmentItem.InitServerData TBinder.InitServerData TCOMAdminCatalog.InitServerData TCOMAdminCatalogCollection.InitServerData TCOMAdminCatalogObject.InitServerData TClass_.InitServerData TCodeData.InitServerData TCodeProject.InitServerData TContactItem.InitServerData TCurrentData.InitServerData TCurrentProject.InitServerData TDataAccessPage.InitServerData TDefaultWebOptions.InitServerData TDistListItem.InitServerData TDocumentItem.InitServerData TExcelApplication.InitServerData TExcelChart.InitServerData TExcelGlobal.InitServerData TExcelOLEObject.InitServerData TExcelQueryTable.InitServerData TExcelWorkbook.InitServerData TExcelWorksheet.InitServerData TExplorer.InitServerData TExplorers.InitServerData TFolders.InitServerData TFormOld.InitServerData TFormatCondition.InitServerData TInspector.InitServerData TInspectors.InitServerData TInternetExplorer.InitServerData TItems.InitServerData TJournalItem.InitServerData TMailItem.InitServerData TMaster.InitServerData TMeetingItem.InitServerData TNameSpace.InitServerData TNoteItem.InitServerData TOLECtrl.InitServerData TOutlookApplication.InitServerData TOutlookBarGroups.InitServerData TOutlookBarPane.InitServerData TOutlookBarShortcuts.InitServerData TPostItem.InitServerData TPowerPointApplication.InitServerData TPowerPointGlobal.InitServerData TPowerPointPresentation.InitServerData TPowerPointSlide.InitServerData TPowerRex.InitServerData TPrinter.InitServerData TReminder.InitServerData TReminders.InitServerData TRemoteItem.InitServerData TReportItem.InitServerData TReportOld.InitServerData TResults.InitServerData TShellNameSpace.InitServerData TShellUIHelper.InitServerData TShellWindows.InitServerData TSyncObject.InitServerData TTaskItem.InitServerData TTaskRequestAcceptItem.InitServerData TTaskRequestDeclineItem.InitServerData TTaskRequestItem.InitServerData TTaskRequestUpdateItem.InitServerData TViews.InitServerData TWizHook.InitServerData TWordApplication.InitServerData TWordDocument.InitServerData TWordFont.InitServerData TWordGlobal.InitServerData TWordLetterContent.InitServerData TWordOLEControl.InitServerData TWordParagraphFormat.InitServerData"
	strings:
		$1 = { BA ?? ?? ?? ?? 89 50 34 C3 }
	condition:
		$1
}

rule function_71_0 {
	meta:
		name = "TFormatCondition.Connect"
		size = 104
		refs = "000c TFormatCondition.Connect 0032 @IntfCast 0047 @IntfClear 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 54 00 75 1A 8D 55 FC 8B C3 8B 08 FF 51 38 8D 43 54 8B 55 FC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 2C 99 7A E2 30 A3 D0 11 81 DD 00 C0 4F C2 F5 1B }
	condition:
		$1
}

rule function_72_0 {
	meta:
		name = "TFormatCondition.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TFormatCondition.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1434_0 {
	meta:
		name = "TAccessApplication.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAccessApplication.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2031_0 {
	meta:
		name = "TAccessHyperlink.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAccessHyperlink.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1961_0 {
	meta:
		name = "TAccessWebOptions.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAccessWebOptions.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_3756_0 {
	meta:
		name = "TAllDataAccessPages.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllDataAccessPages.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1781_0 {
	meta:
		name = "TAllDatabaseDiagrams.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllDatabaseDiagrams.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1664_0 {
	meta:
		name = "TAllForms.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllForms.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4813_0 {
	meta:
		name = "TAllFunctions.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllFunctions.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_3730_0 {
	meta:
		name = "TAllMacros.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllMacros.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1703_0 {
	meta:
		name = "TAllModules.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllModules.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1742_0 {
	meta:
		name = "TAllQueries.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllQueries.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_3717_0 {
	meta:
		name = "TAllReports.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllReports.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_3808_0 {
	meta:
		name = "TAllStoredProcedures.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllStoredProcedures.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1729_0 {
	meta:
		name = "TAllTables.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllTables.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_3795_0 {
	meta:
		name = "TAllViews.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TAllViews.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_9226_0 {
	meta:
		name = "TBinder.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TBinder.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_11404_0 {
	meta:
		name = "TCOMAdminCatalog.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TCOMAdminCatalog.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_11451_0 {
	meta:
		name = "TCOMAdminCatalogCollection.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TCOMAdminCatalogCollection.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_11436_0 {
	meta:
		name = "TCOMAdminCatalogObject.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TCOMAdminCatalogObject.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1866_0 {
	meta:
		name = "TCodeData.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TCodeData.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1837_0 {
	meta:
		name = "TCodeProject.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TCodeProject.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1823_0 {
	meta:
		name = "TCurrentData.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TCurrentData.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1794_0 {
	meta:
		name = "TCurrentProject.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TCurrentProject.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1638_0 {
	meta:
		name = "TDataAccessPage.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TDataAccessPage.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1929_0 {
	meta:
		name = "TDefaultWebOptions.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TDefaultWebOptions.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_47256_0 {
	meta:
		name = "TExcelGlobal.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TExcelGlobal.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_73123_0 {
	meta:
		name = "TNoteItem.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TNoteItem.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_74245_0 {
	meta:
		name = "TPowerPointGlobal.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TPowerPointGlobal.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_74546_0 {
	meta:
		name = "TPowerRex.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TPowerRex.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4062_0 {
	meta:
		name = "TPrinter.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TPrinter.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_73785_0 {
	meta:
		name = "TReminder.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TReminder.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79391_0 {
	meta:
		name = "TShellUIHelper.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TShellUIHelper.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_1880_0 {
	meta:
		name = "TWizHook.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TWizHook.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_99278_0 {
	meta:
		name = "TWordFont.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TWordFont.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_98809_0 {
	meta:
		name = "TWordGlobal.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TWordGlobal.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_99491_0 {
	meta:
		name = "TWordLetterContent.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TWordLetterContent.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_99368_0 {
	meta:
		name = "TWordParagraphFormat.ConnectTo"
		size = 83
		refs = "000e @IntfAddRef 0016 TWordParagraphFormat.ConnectTo 002e @IntfCopy 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 89 55 FC 8B D8 8B 45 FC E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C3 8B 10 FF 52 44 8D 43 54 8B 55 FC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_73_0 {
	meta:
		name = "TAccessApplication.Disconnect"
		size = 19
		refs = "000d @IntfClear"
		altNames = "TAccessHyperlink.Disconnect TAccessWebOptions.Disconnect TAllDataAccessPages.Disconnect TAllDatabaseDiagrams.Disconnect TAllForms.Disconnect TAllFunctions.Disconnect TAllMacros.Disconnect TAllModules.Disconnect TAllQueries.Disconnect TAllReports.Disconnect TAllStoredProcedures.Disconnect TAllTables.Disconnect TAllViews.Disconnect TBinder.Disconnect TCOMAdminCatalog.Disconnect TCOMAdminCatalogCollection.Disconnect TCOMAdminCatalogObject.Disconnect TCodeData.Disconnect TCodeProject.Disconnect TCurrentData.Disconnect TCurrentProject.Disconnect TDataAccessPage.Disconnect TDefaultWebOptions.Disconnect TExcelGlobal.Disconnect TFormatCondition.Disconnect TNoteItem.Disconnect TPowerPointGlobal.Disconnect TPowerRex.Disconnect TPrinter.Disconnect TReminder.Disconnect TShellUIHelper.Disconnect TWizHook.Disconnect TWordFont.Disconnect TWordGlobal.Disconnect TWordLetterContent.Disconnect TWordParagraphFormat.Disconnect"
	strings:
		$1 = { 53 8B D8 83 7B 54 00 74 08 8D 43 54 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_74_0 {
	meta:
		name = "TFormatCondition.GetDefaultInterface"
		size = 420
		refs = "001f TFormatCondition.GetDefaultInterface 0029 @Assert 0033 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 54 00 75 07 8B C3 8B 10 FF 52 40 83 7B 54 00 75 14 B9 87 46 00 00 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 8B 53 54 E8 ?? ?? ?? ?? 5E 5B C3 00 00 B0 04 02 00 FF FF FF FF 29 00 00 00 43 00 3A 00 5C 00 62 00 75 00 69 00 6C 00 64 00 73 00 5C 00 54 00 70 00 5C 00 74 00 79 00 70 00 65 00 6C 00 69 00 62 00 5C 00 70 00 61 00 73 00 32 00 6B 00 5C 00 41 00 63 00 63 00 65 00 73 00 73 00 32 00 30 00 30 00 30 00 2E 00 70 00 61 00 73 00 00 00 B0 04 02 00 FF FF FF FF 7C 00 00 00 44 00 65 00 66 00 61 00 75 00 6C 00 74 00 49 00 6E 00 74 00 65 00 72 00 66 00 61 00 63 00 65 00 20 00 69 00 73 00 20 00 4E 00 55 00 4C 00 4C 00 2E 00 20 00 43 00 6F 00 6D 00 70 00 6F 00 6E 00 65 00 6E 00 74 00 20 00 69 00 73 00 20 00 6E 00 6F 00 74 00 20 00 63 00 6F 00 6E 00 6E 00 65 00 63 00 74 00 65 00 64 00 20 00 74 00 6F 00 20 00 53 00 65 00 72 00 76 00 65 00 72 00 2E 00 20 00 59 00 6F 00 75 00 20 00 6D 00 75 00 73 00 74 00 20 00 63 00 61 00 6C 00 6C 00 20 00 27 00 43 00 6F 00 6E 00 6E 00 65 00 63 00 74 00 27 00 20 00 6F 00 72 00 20 00 27 00 43 00 6F 00 6E 00 6E 00 65 00 63 00 74 00 54 00 6F 00 27 00 20 00 62 00 65 00 66 00 6F 00 72 00 65 00 20 00 74 00 68 00 69 00 73 00 20 00 6F 00 70 00 65 00 72 00 61 00 74 00 69 00 6F 00 6E 00 00 00 00 00 }
	condition:
		$1
}

rule function_75_0 {
	meta:
		name = "TAccessApplication.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TOleServer.Create 0022 @AfterConstruction"
		altNames = "TAccessForm.Create TAccessHyperlink.Create TAccessReferences.Create TAccessReport.Create TAccessWebOptions.Create TAllDataAccessPages.Create TAllDatabaseDiagrams.Create TAllForms.Create TAllFunctions.Create TAllMacros.Create TAllModules.Create TAllQueries.Create TAllReports.Create TAllStoredProcedures.Create TAllTables.Create TAllViews.Create TAppointmentItem.Create TBinder.Create TCOMAdminCatalog.Create TCOMAdminCatalogCollection.Create TCOMAdminCatalogObject.Create TClass_.Create TCodeData.Create TCodeProject.Create TContactItem.Create TCurrentData.Create TCurrentProject.Create TDataAccessPage.Create TDefaultWebOptions.Create TDistListItem.Create TDocumentItem.Create TExcelApplication.Create TExcelChart.Create TExcelGlobal.Create TExcelOLEObject.Create TExcelQueryTable.Create TExcelWorkbook.Create TExcelWorksheet.Create TExplorer.Create TExplorers.Create TFolders.Create TFormOld.Create TFormatCondition.Create TInspector.Create TInspectors.Create TInternetExplorer.Create TItems.Create TJournalItem.Create TMailItem.Create TMaster.Create TMeetingItem.Create TNameSpace.Create TNoteItem.Create TOLECtrl.Create TOutlookApplication.Create TOutlookBarGroups.Create TOutlookBarPane.Create TOutlookBarShortcuts.Create TPostItem.Create TPowerPointApplication.Create TPowerPointGlobal.Create TPowerPointPresentation.Create TPowerPointSlide.Create TPowerRex.Create TPrinter.Create TReminder.Create TReminders.Create TRemoteItem.Create TReportItem.Create TReportOld.Create TResults.Create TShellNameSpace.Create TShellUIHelper.Create TShellWindows.Create TSyncObject.Create TTaskItem.Create TTaskRequestAcceptItem.Create TTaskRequestDeclineItem.Create TTaskRequestItem.Create TTaskRequestUpdateItem.Create TViews.Create TWizHook.Create TWordApplication.Create TWordDocument.Create TWordFont.Create TWordGlobal.Create TWordLetterContent.Create TWordOLEControl.Create TWordParagraphFormat.Create"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34731_0 {
	meta:
		name = "DSAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34812_0 {
	meta:
		name = "DSMetadata.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSCustomAdmin.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_57720_0 {
	meta:
		name = "EIdException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_94657_0 {
	meta:
		name = "TAbstractActiveScriptLanguages.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8778_0 {
	meta:
		name = "TActiveForm.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomActiveForm.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8768_0 {
	meta:
		name = "TActiveFormControl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TActiveXControl.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8769_0 {
	meta:
		name = "TActiveFormControl.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TActiveXControl.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8628_0 {
	meta:
		name = "TActiveXControl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8629_0 {
	meta:
		name = "TActiveXControl.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13997_0 {
	meta:
		name = "TAutoObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TTypedComObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13998_0 {
	meta:
		name = "TAutoObject.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TTypedComObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14088_0 {
	meta:
		name = "TAutoObjectEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_14090_0 {
	meta:
		name = "TAutoObjectEvent.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TAutoObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_31507_0 {
	meta:
		name = "TAzureBlobService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAzureService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_31556_0 {
	meta:
		name = "TAzureTableService.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAzureService.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_31809_0 {
	meta:
		name = "TBBlock.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBBlockList>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_31803_0 {
	meta:
		name = "TBPageRange.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBPageList>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_31795_0 {
	meta:
		name = "TBSignedIdentifier.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TBEnumerationItem<DSAzureBlob.TBSignedIdentifiers>.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27126_0 {
	meta:
		name = "TBaseTransportFilterItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_6201_0 {
	meta:
		name = "TBasicImageResponseImpl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAbstractAdapterResponse.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_17622_0 {
	meta:
		name = "TBinaryField.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TField.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_9792_0 {
	meta:
		name = "TCGIRequest.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebRequest.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_86348_0 {
	meta:
		name = "TCanvas3D.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_42694_0 {
	meta:
		name = "TClassCreator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_11366_0 {
	meta:
		name = "TClassRegistryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_54177_0 {
	meta:
		name = "TColorLookup.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_83961_0 {
	meta:
		name = "TConnectionIntercept.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdBaseComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_12517_0 {
	meta:
		name = "TConversion.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23879_0 {
	meta:
		name = "TConverterEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_82055_0 {
	meta:
		name = "TCustomComboBoxStrings.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TStrings.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_92297_0 {
	meta:
		name = "TCustomHTMLDragDropDesigner.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_92309_0 {
	meta:
		name = "TCustomHTMLRegionDesigner.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_18718_0 {
	meta:
		name = "TCustomRemoteServer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_18593_0 {
	meta:
		name = "TDBByteBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21450_0 {
	meta:
		name = "TDBXAnsiMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22475_0 {
	meta:
		name = "TDBXAnsiStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21430_0 {
	meta:
		name = "TDBXAnsiStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22470_0 {
	meta:
		name = "TDBXBlobSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22464_0 {
	meta:
		name = "TDBXBooleanSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_20785_0 {
	meta:
		name = "TDBXClientDriverLoader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TClassRegistryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21777_0 {
	meta:
		name = "TDBXClosedByteReader.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteReader.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21870_0 {
	meta:
		name = "TDBXConnectionBuilder.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_25036_0 {
	meta:
		name = "TDBXConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22541_0 {
	meta:
		name = "TDBXDataExpressMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXMetaDataProvider.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_25283_0 {
	meta:
		name = "TDBXDataExpressProviderContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22439_0 {
	meta:
		name = "TDBXDataGeneratedRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22479_0 {
	meta:
		name = "TDBXDataGeneratorException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22480_0 {
	meta:
		name = "TDBXDateSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22487_0 {
	meta:
		name = "TDBXDecimalSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22492_0 {
	meta:
		name = "TDBXDoubleSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27246_0 {
	meta:
		name = "TDBXIdTCPLayer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TFactoryObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22497_0 {
	meta:
		name = "TDBXInt16SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22502_0 {
	meta:
		name = "TDBXInt32SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22507_0 {
	meta:
		name = "TDBXInt64SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22512_0 {
	meta:
		name = "TDBXInt8SequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21915_0 {
	meta:
		name = "TDBXMemoryConnectionFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionFactory.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_25354_0 {
	meta:
		name = "TDBXMetaDataProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23158_0 {
	meta:
		name = "TDBXMethodTable.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22292_0 {
	meta:
		name = "TDBXNoOpRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXStreamerRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27228_0 {
	meta:
		name = "TDBXSocketChannel.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27046_0 {
	meta:
		name = "TDBXStringBuffer.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21559_0 {
	meta:
		name = "TDBXStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWideStringValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22311_0 {
	meta:
		name = "TDBXTable.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXTableRow.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22309_0 {
	meta:
		name = "TDBXTableRow.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22517_0 {
	meta:
		name = "TDBXTimeSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22524_0 {
	meta:
		name = "TDBXTimestampSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21190_0 {
	meta:
		name = "TDBXTransaction.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21032_0 {
	meta:
		name = "TDBXValueType.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21552_0 {
	meta:
		name = "TDBXWideMemoValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXByteArrayValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22535_0 {
	meta:
		name = "TDBXWideStringSequenceGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXDataGeneratorColumn.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21529_0 {
	meta:
		name = "TDBXWideStringValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXWritableValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_21207_0 {
	meta:
		name = "TDBXWritableValue.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValue.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_22022_0 {
	meta:
		name = "TDBXWritableValueList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXValueList.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_65767_0 {
	meta:
		name = "TDCOMConnection.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDispatchConnection.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_40790_0 {
	meta:
		name = "TDSAdminRestClient.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSRestClient.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34727_0 {
	meta:
		name = "TDSCustomAdmin.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_33056_0 {
	meta:
		name = "TDSCustomProxyGenerator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34861_0 {
	meta:
		name = "TDSCustomServerClass.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDSServerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34849_0 {
	meta:
		name = "TDSServerCommandHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXCommandHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34858_0 {
	meta:
		name = "TDSServerComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34919_0 {
	meta:
		name = "TDSServerMethod.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34940_0 {
	meta:
		name = "TDSServerMethodProvider.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_34990_0 {
	meta:
		name = "TDSVoidConnectionHandler.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TDBXConnectionHandler.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_64111_0 {
	meta:
		name = "TDataContext.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8556_0 {
	meta:
		name = "TEnumDispatcherAS.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCustomEnumDispatcher.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_27130_0 {
	meta:
		name = "TFactoryObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_54838_0 {
	meta:
		name = "TGraphic.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_64469_0 {
	meta:
		name = "TISAPIFactory.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_56634_0 {
	meta:
		name = "TIdBaseComponent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TIdInitializerComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_57697_0 {
	meta:
		name = "TIdEMailAddressItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_58149_0 {
	meta:
		name = "TIdFTPRegParseList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59156_0 {
	meta:
		name = "TIdHash.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_60064_0 {
	meta:
		name = "TIdIRCReplies.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_60518_0 {
	meta:
		name = "TIdMessageDecoderInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_60525_0 {
	meta:
		name = "TIdMessageEncoderInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_56923_0 {
	meta:
		name = "TIdNetscapeCookie.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_62360_0 {
	meta:
		name = "TIdNotify.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_59412_0 {
	meta:
		name = "TIdProxyConnectionInfo.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_62330_0 {
	meta:
		name = "TIdStruct.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_62357_0 {
	meta:
		name = "TIdSync.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23602_0 {
	meta:
		name = "TJSONException.Create"
		size = 53
		refs = "000a @ClassCreate 0017 Exception.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23636_0 {
	meta:
		name = "TJSONNumber.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONString.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23603_0 {
	meta:
		name = "TJSONPair.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONAncestor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23623_0 {
	meta:
		name = "TJSONString.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TJSONAncestor.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_31823_0 {
	meta:
		name = "TLeaseItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_80852_0 {
	meta:
		name = "TLogLinkedWebNode.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TLinkedWebNode.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_95009_0 {
	meta:
		name = "TModuleObj.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponentsEnumerator.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8834_0 {
	meta:
		name = "TOleGraphic.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TGraphic.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_8798_0 {
	meta:
		name = "TPropertyPageImpl.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TAggregatedObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_23886_0 {
	meta:
		name = "TReverterEvent.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_10676_0 {
	meta:
		name = "TStringList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TStrings.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_88011_0 {
	meta:
		name = "TTeeExportFormat.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_90848_0 {
	meta:
		name = "TTypeTranslator.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13990_0 {
	meta:
		name = "TTypedComObject.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_13991_0 {
	meta:
		name = "TTypedComObject.CreateAggregated"
		size = 53
		refs = "000a @ClassCreate 0017 TComObject.CreateAggregated 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_63379_0 {
	meta:
		name = "TWebBrowserSearchFindFirst.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebBrowserSearchFind.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_66511_0 {
	meta:
		name = "TWebButton.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TWebContainedComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_93034_0 {
	meta:
		name = "TWebComponentsStub.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TScriptComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_95025_0 {
	meta:
		name = "TWebUserItem.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TCollectionItem.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_95174_0 {
	meta:
		name = "TWideStringList.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_102056_0 {
	meta:
		name = "TXMLDocument.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TComponent.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_102814_0 {
	meta:
		name = "TXSBaseDate.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TObject.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_102882_0 {
	meta:
		name = "TXSDate.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TRemotable.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_102918_0 {
	meta:
		name = "TXSDuration.Create"
		size = 53
		refs = "000a @ClassCreate 0017 TRemotable.Create 0022 @AfterConstruction"
	strings:
		$1 = { 53 56 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 8B DA 8B F0 33 D2 8B C6 E8 ?? ?? ?? ?? 8B C6 84 DB 74 0F E8 ?? ?? ?? ?? 64 8F 05 00 00 00 00 83 C4 0C 8B C6 5E 5B C3 }
	condition:
		$1
}

rule function_76_0 {
	meta:
		name = "TAccessApplication.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TOleServer.Destroy 001e @ClassDestroy"
		altNames = "TAccessForm.Destroy TAccessHyperlink.Destroy TAccessReferences.Destroy TAccessReport.Destroy TAccessWebOptions.Destroy TAllDataAccessPages.Destroy TAllDatabaseDiagrams.Destroy TAllForms.Destroy TAllFunctions.Destroy TAllMacros.Destroy TAllModules.Destroy TAllQueries.Destroy TAllReports.Destroy TAllStoredProcedures.Destroy TAllTables.Destroy TAllViews.Destroy TAppointmentItem.Destroy TBinder.Destroy TCOMAdminCatalog.Destroy TCOMAdminCatalogCollection.Destroy TCOMAdminCatalogObject.Destroy TClass_.Destroy TCodeData.Destroy TCodeProject.Destroy TContactItem.Destroy TCurrentData.Destroy TCurrentProject.Destroy TDataAccessPage.Destroy TDefaultWebOptions.Destroy TDistListItem.Destroy TDocumentItem.Destroy TExcelApplication.Destroy TExcelChart.Destroy TExcelGlobal.Destroy TExcelOLEObject.Destroy TExcelQueryTable.Destroy TExcelWorkbook.Destroy TExcelWorksheet.Destroy TExplorer.Destroy TExplorers.Destroy TFolders.Destroy TFormOld.Destroy TFormatCondition.Destroy TInspector.Destroy TInspectors.Destroy TInternetExplorer.Destroy TItems.Destroy TJournalItem.Destroy TMailItem.Destroy TMaster.Destroy TMeetingItem.Destroy TNameSpace.Destroy TNoteItem.Destroy TOLECtrl.Destroy TOutlookApplication.Destroy TOutlookBarGroups.Destroy TOutlookBarPane.Destroy TOutlookBarShortcuts.Destroy TPostItem.Destroy TPowerPointApplication.Destroy TPowerPointGlobal.Destroy TPowerPointPresentation.Destroy TPowerPointSlide.Destroy TPowerRex.Destroy TPrinter.Destroy TReminder.Destroy TReminders.Destroy TRemoteItem.Destroy TReportItem.Destroy TReportOld.Destroy TResults.Destroy TShellNameSpace.Destroy TShellUIHelper.Destroy TShellWindows.Destroy TSyncObject.Destroy TTaskItem.Destroy TTaskRequestAcceptItem.Destroy TTaskRequestDeclineItem.Destroy TTaskRequestItem.Destroy TTaskRequestUpdateItem.Destroy TViews.Destroy TWizHook.Destroy TWordApplication.Destroy TWordDocument.Destroy TWordFont.Destroy TWordGlobal.Destroy TWordLetterContent.Destroy TWordOLEControl.Destroy TWordParagraphFormat.Destroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_93552_0 {
	meta:
		name = "TAbstractNamedVariants.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TPersistent.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8779_0 {
	meta:
		name = "TActiveForm.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCustomForm.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8771_0 {
	meta:
		name = "TActiveFormControl.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TActiveXControl.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8787_0 {
	meta:
		name = "TActiveFormFactory.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TActiveXControlFactory.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_31471_0 {
	meta:
		name = "TAzureConnectionString.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TComponent.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_31810_0 {
	meta:
		name = "TBBlock.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TBEnumerationItem<DSAzureBlob.TBBlockList>.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_31804_0 {
	meta:
		name = "TBPageRange.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TBEnumerationItem<DSAzureBlob.TBPageList>.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_31796_0 {
	meta:
		name = "TBSignedIdentifier.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TBEnumerationItem<DSAzureBlob.TBSignedIdentifiers>.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_83964_0 {
	meta:
		name = "TConnectionIntercept.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TComponent.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_13134_0 {
	meta:
		name = "TCoolBands.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCollection.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_82056_0 {
	meta:
		name = "TCustomComboBoxStrings.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TStrings.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_80998_0 {
	meta:
		name = "TCustomTcpServer.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TBaseSocket.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_63181_0 {
	meta:
		name = "TCustomZlibStream.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_20783_0 {
	meta:
		name = "TDBXClientDriver.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXDriver.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21023_0 {
	meta:
		name = "TDBXConnectionValue.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXWritableValue.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28075_0 {
	meta:
		name = "TDBXConsoleTraceOutput.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXTraceOutput.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43320_0 {
	meta:
		name = "TDBXCropRequestFilter.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDSRequestFilter<DBXCommon.TDBXValue>.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_22833_0 {
	meta:
		name = "TDBXDataSetReader.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXTableReader.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_22995_0 {
	meta:
		name = "TDBXDelegateParameterList.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXParameterList.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_27021_0 {
	meta:
		name = "TDBXInt32Object.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_25168_0 {
	meta:
		name = "TDBXJSonServerOutputConnectionHandler.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXJSonConnectionHandler.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21916_0 {
	meta:
		name = "TDBXMemoryConnectionFactory.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXConnectionFactory.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21981_0 {
	meta:
		name = "TDBXNullValue.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXWritableValue.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_22837_0 {
	meta:
		name = "TDBXParamsReader.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXTableReader.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_27159_0 {
	meta:
		name = "TDBXPoolCommand.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXCommand.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_27171_0 {
	meta:
		name = "TDBXPoolReader.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXReader.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21975_0 {
	meta:
		name = "TDBXStateItemList.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21560_0 {
	meta:
		name = "TDBXStringValue.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXWideStringValue.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_28063_0 {
	meta:
		name = "TDBXTraceParameter.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXDelegateParameter.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_27959_0 {
	meta:
		name = "TDBXTraceParameterList.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXDelegateParameterList.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_27973_0 {
	meta:
		name = "TDBXTraceWritableValue.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXDelegateWritableValue.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21070_0 {
	meta:
		name = "TDBXValueType.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_21208_0 {
	meta:
		name = "TDBXWritableValue.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXValue.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_54166_0 {
	meta:
		name = "TDIBReader.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36538_0 {
	meta:
		name = "TDSCacheResponseHandler.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDSJsonResponseHandler.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36515_0 {
	meta:
		name = "TDSClientCallbackChannelManager.TDSChannelCallback.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36518_0 {
	meta:
		name = "TDSClientCallbackChannelManager.TDSChannelThread.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TThread.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_36576_0 {
	meta:
		name = "TDSClientCallbackChannelManager.TDSExecuteThread.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TThread.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_44462_0 {
	meta:
		name = "TDSJSONProtocolHandlerFactory.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43267_0 {
	meta:
		name = "TDSJSONService.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDSService.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43253_0 {
	meta:
		name = "TDSRESTService.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDSService.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43393_0 {
	meta:
		name = "TDSRequestFilter<DBXCommon.TDBXValue>.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_34147_0 {
	meta:
		name = "TDSRestCacheCommand.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_41930_0 {
	meta:
		name = "TDSServerClass.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TComponent.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_41951_0 {
	meta:
		name = "TDSServerDriver.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDBXDriver.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_43191_0 {
	meta:
		name = "TDSTunnelSession.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TDSSession.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_93793_0 {
	meta:
		name = "TDispatchFileRequest.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8557_0 {
	meta:
		name = "TEnumDispatcherAS.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCustomEnumDispatcher.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_93124_0 {
	meta:
		name = "TEventDispatchEx.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_54479_0 {
	meta:
		name = "TGIFApplicationExtension.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TGIFExtension.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_51998_0 {
	meta:
		name = "TGPFontCollection.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_52004_0 {
	meta:
		name = "TGPInstalledFontCollection.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TGPFontCollection.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_53388_0 {
	meta:
		name = "TGestureCollection.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCollection.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_59755_0 {
	meta:
		name = "TIdIMAP4Server.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdCmdTCPServer.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60029_0 {
	meta:
		name = "TIdIPMCastListenerThread.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdThread.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60507_0 {
	meta:
		name = "TIdMessageClient.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdExplicitTLSClient.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60747_0 {
	meta:
		name = "TIdNNTP.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdMessageClient.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_61099_0 {
	meta:
		name = "TIdRemoteCMDClient.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdTCPConnection.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_61844_0 {
	meta:
		name = "TIdSSLCipher.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_62253_0 {
	meta:
		name = "TIdStackWindows.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TIdStack.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_63702_0 {
	meta:
		name = "TIndyTCPConnectionTransport.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_60676_0 {
	meta:
		name = "TIpProperty.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TPersistent.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_85770_0 {
	meta:
		name = "TLanguages.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_80853_0 {
	meta:
		name = "TLogLinkedWebNode.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TLinkedWebNode.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_95010_0 {
	meta:
		name = "TModuleObj.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObjectScripter.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_94891_0 {
	meta:
		name = "TModulesObj.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObjectScripter.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_42723_0 {
	meta:
		name = "TNewDataSnapAppExpert.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_33512_0 {
	meta:
		name = "TNewDataSnapClientModuleCreator.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_33552_0 {
	meta:
		name = "TNewDataSnapClientModuleExpert.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_44418_0 {
	meta:
		name = "TNewDataSnapStandAloneAppExpert.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_44366_0 {
	meta:
		name = "TNewDataSnapStandAloneProjectCreator.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_44489_0 {
	meta:
		name = "TNewDataSnapWebBrokerExpert.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8605_0 {
	meta:
		name = "TOleStream.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_40162_0 {
	meta:
		name = "TProjectChangeNotifier.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8799_0 {
	meta:
		name = "TPropertyPageImpl.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_80739_0 {
	meta:
		name = "TSOAPDOMProcessor.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TComponent.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_81200_0 {
	meta:
		name = "TSQLBlobStream.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TMemoryStream.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_78613_0 {
	meta:
		name = "TScriptObjectContainer.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_54952_0 {
	meta:
		name = "TSharedImage.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_8392_0 {
	meta:
		name = "TShowTagsBehavior.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCustomPaintedBehavior.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_80507_0 {
	meta:
		name = "TSimpleDataSet.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCustomClientDataSet.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_80675_0 {
	meta:
		name = "TSoapConnection.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCustomConnection.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_56402_0 {
	meta:
		name = "TStreamLoader.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_29423_0 {
	meta:
		name = "TTaskDialogButtons.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCollection.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_90849_0 {
	meta:
		name = "TTypeTranslator.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_93037_0 {
	meta:
		name = "TWebComponentsStub.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_80605_0 {
	meta:
		name = "TWebRequestStream.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_83910_0 {
	meta:
		name = "TWebServerResponse.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TWebResponse.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_78633_0 {
	meta:
		name = "TXMLDocument.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_101938_0 {
	meta:
		name = "TXMLNodeList.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TObject.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_78621_0 {
	meta:
		name = "TXMLRowSets.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TScriptObjectContainer.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_102693_0 {
	meta:
		name = "TXMLTransformProvider.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCustomProvider.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_102913_0 {
	meta:
		name = "TXSCustomDateTime.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TRemotable.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_98695_0 {
	meta:
		name = "TfrmWizardMain.Destroy"
		size = 37
		refs = "0003 @BeforeDestruction 0013 TCustomForm.Destroy 001e @ClassDestroy"
	strings:
		$1 = { 53 56 E8 ?? ?? ?? ?? 8B DA 8B F0 8B D3 80 E2 FC 8B C6 E8 ?? ?? ?? ?? 84 DB 7E 07 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_77_0 {
	meta:
		name = "TFormatCondition.Get_ForeColor"
		size = 95
		refs = "0012 TFormatCondition.Get_ForeColor 0026 TFormatCondition.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_4067_0 {
	meta:
		name = "TPrinter.Get_ColorMode"
		size = 95
		refs = "0012 TPrinter.Get_ColorMode 0026 TPrinter.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_79375_0 {
	meta:
		name = "TShellWindows.Get_Count"
		size = 95
		refs = "0012 TShellWindows.Get_Count 0026 TShellWindows.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_78_0 {
	meta:
		name = "TFormatCondition.Set_ForeColor"
		size = 84
		refs = "000f TFormatCondition.Set_ForeColor 0020 TFormatCondition.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67334_0 {
	meta:
		name = "TOLECtrl.Set_Visible"
		size = 84
		refs = "000f TOLECtrl.Set_Visible 0020 TOLECtrl.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4068_0 {
	meta:
		name = "TPrinter.Set_ColorMode"
		size = 84
		refs = "000f TPrinter.Set_ColorMode 0020 TPrinter.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79_0 {
	meta:
		name = "TFormatCondition.Get_BackColor"
		size = 95
		refs = "0012 TFormatCondition.Get_BackColor 0026 TFormatCondition.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1628_0 {
	meta:
		name = "TAccessReferences.Get_Count"
		size = 95
		refs = "0012 TAccessReferences.Get_Count 0026 TAccessReferences.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_11409_0 {
	meta:
		name = "TCOMAdminCatalog.Get_MajorVersion"
		size = 95
		refs = "0012 TCOMAdminCatalog.Get_MajorVersion 0026 TCOMAdminCatalog.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_11457_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Get_Count"
		size = 95
		refs = "0012 TCOMAdminCatalogCollection.Get_Count 0026 TCOMAdminCatalogCollection.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1936_0 {
	meta:
		name = "TDefaultWebOptions.Get_HyperlinkColor"
		size = 95
		refs = "0012 TDefaultWebOptions.Get_HyperlinkColor 0026 TDefaultWebOptions.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_4069_0 {
	meta:
		name = "TPrinter.Get_Copies"
		size = 95
		refs = "0012 TPrinter.Get_Copies 0026 TPrinter.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_98934_0 {
	meta:
		name = "TWordDocument.Get_Creator"
		size = 95
		refs = "0012 TWordDocument.Get_Creator 0026 TWordDocument.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_80_0 {
	meta:
		name = "TFormatCondition.Set_BackColor"
		size = 84
		refs = "000f TFormatCondition.Set_BackColor 0020 TFormatCondition.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1480_0 {
	meta:
		name = "TAccessApplication.NewCurrentDatabase"
		size = 84
		refs = "000f TAccessApplication.NewCurrentDatabase 0020 TAccessApplication.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1969_0 {
	meta:
		name = "TAccessWebOptions.Set_OrganizeInFolder"
		size = 84
		refs = "000f TAccessWebOptions.Set_OrganizeInFolder 0020 TAccessWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_11463_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Remove"
		size = 84
		refs = "000f TCOMAdminCatalogCollection.Remove 0020 TCOMAdminCatalogCollection.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1646_0 {
	meta:
		name = "TDataAccessPage.Set_Visible"
		size = 84
		refs = "000f TDataAccessPage.Set_Visible 0020 TDataAccessPage.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1937_0 {
	meta:
		name = "TDefaultWebOptions.Set_HyperlinkColor"
		size = 84
		refs = "000f TDefaultWebOptions.Set_HyperlinkColor 0020 TDefaultWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46781_0 {
	meta:
		name = "TExcelChart.Activate"
		size = 84
		refs = "000f TExcelChart.Activate 0020 TExcelChart.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47070_0 {
	meta:
		name = "TExcelWorksheet.Activate"
		size = 84
		refs = "000f TExcelWorksheet.Activate 0020 TExcelWorksheet.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4070_0 {
	meta:
		name = "TPrinter.Set_Copies"
		size = 84
		refs = "000f TPrinter.Set_Copies 0020 TPrinter.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_81_0 {
	meta:
		name = "TFormatCondition.Get_FontBold"
		size = 96
		refs = "0012 TFormatCondition.Get_FontBold 0026 TFormatCondition.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1970_0 {
	meta:
		name = "TAccessWebOptions.Get_UseLongFileNames"
		size = 96
		refs = "0012 TAccessWebOptions.Get_UseLongFileNames 0026 TAccessWebOptions.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_82_0 {
	meta:
		name = "TFormatCondition.Set_FontBold"
		size = 84
		refs = "000f TFormatCondition.Set_FontBold 0020 TFormatCondition.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1971_0 {
	meta:
		name = "TAccessWebOptions.Set_UseLongFileNames"
		size = 84
		refs = "000f TAccessWebOptions.Set_UseLongFileNames 0020 TAccessWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1939_0 {
	meta:
		name = "TDefaultWebOptions.Set_FollowedHyperlinkColor"
		size = 84
		refs = "000f TDefaultWebOptions.Set_FollowedHyperlinkColor 0020 TDefaultWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46787_0 {
	meta:
		name = "TExcelChart.Delete"
		size = 84
		refs = "000f TExcelChart.Delete 0020 TExcelChart.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47566_0 {
	meta:
		name = "TExcelWorkbook.Activate"
		size = 84
		refs = "000f TExcelWorkbook.Activate 0020 TExcelWorkbook.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47076_0 {
	meta:
		name = "TExcelWorksheet.Delete"
		size = 84
		refs = "000f TExcelWorksheet.Delete 0020 TExcelWorksheet.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67425_0 {
	meta:
		name = "TMaster.Set_ColorScheme"
		size = 84
		refs = "000f TMaster.Set_ColorScheme 0020 TMaster.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79381_0 {
	meta:
		name = "TShellWindows.Revoke"
		size = 84
		refs = "000f TShellWindows.Revoke 0020 TShellWindows.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99288_0 {
	meta:
		name = "TWordFont.Set_Bold"
		size = 84
		refs = "000f TWordFont.Set_Bold 0020 TWordFont.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_83_0 {
	meta:
		name = "TFormatCondition.Get_FontItalic"
		size = 96
		refs = "0012 TFormatCondition.Get_FontItalic 0026 TFormatCondition.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1236_0 {
	meta:
		name = "TAccessReport.Get_FilterOn"
		size = 96
		refs = "0012 TAccessReport.Get_FilterOn 0026 TAccessReport.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1972_0 {
	meta:
		name = "TAccessWebOptions.Get_DownloadComponents"
		size = 96
		refs = "0012 TAccessWebOptions.Get_DownloadComponents 0026 TAccessWebOptions.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1940_0 {
	meta:
		name = "TDefaultWebOptions.Get_UnderlineHyperlinks"
		size = 96
		refs = "0012 TDefaultWebOptions.Get_UnderlineHyperlinks 0026 TDefaultWebOptions.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_3254_0 {
	meta:
		name = "TReportOld.Get_FilterOn"
		size = 96
		refs = "0012 TReportOld.Get_FilterOn 0026 TReportOld.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_99502_0 {
	meta:
		name = "TWordLetterContent.Get_IncludeHeaderFooter"
		size = 96
		refs = "0012 TWordLetterContent.Get_IncludeHeaderFooter 0026 TWordLetterContent.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_84_0 {
	meta:
		name = "TFormatCondition.Set_FontItalic"
		size = 84
		refs = "000f TFormatCondition.Set_FontItalic 0020 TFormatCondition.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1237_0 {
	meta:
		name = "TAccessReport.Set_FilterOn"
		size = 84
		refs = "000f TAccessReport.Set_FilterOn 0020 TAccessReport.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1973_0 {
	meta:
		name = "TAccessWebOptions.Set_DownloadComponents"
		size = 84
		refs = "000f TAccessWebOptions.Set_DownloadComponents 0020 TAccessWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_11416_0 {
	meta:
		name = "TCOMAdminCatalog.ShutdownApplication"
		size = 84
		refs = "000f TCOMAdminCatalog.ShutdownApplication 0020 TCOMAdminCatalog.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1941_0 {
	meta:
		name = "TDefaultWebOptions.Set_UnderlineHyperlinks"
		size = 84
		refs = "000f TDefaultWebOptions.Set_UnderlineHyperlinks 0020 TDefaultWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4074_0 {
	meta:
		name = "TPrinter.Set_Duplex"
		size = 84
		refs = "000f TPrinter.Set_Duplex 0020 TPrinter.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3255_0 {
	meta:
		name = "TReportOld.Set_FilterOn"
		size = 84
		refs = "000f TReportOld.Set_FilterOn 0020 TReportOld.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79452_0 {
	meta:
		name = "TShellNameSpace.InvokeContextMenuCommand"
		size = 84
		refs = "000f TShellNameSpace.InvokeContextMenuCommand 0020 TShellNameSpace.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99290_0 {
	meta:
		name = "TWordFont.Set_Italic"
		size = 84
		refs = "000f TWordFont.Set_Italic 0020 TWordFont.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99503_0 {
	meta:
		name = "TWordLetterContent.Set_IncludeHeaderFooter"
		size = 84
		refs = "000f TWordLetterContent.Set_IncludeHeaderFooter 0020 TWordLetterContent.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99380_0 {
	meta:
		name = "TWordParagraphFormat.Set_Alignment"
		size = 84
		refs = "000f TWordParagraphFormat.Set_Alignment 0020 TWordParagraphFormat.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 38 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_85_0 {
	meta:
		name = "TFormatCondition.Get_FontUnderline"
		size = 96
		refs = "0012 TFormatCondition.Get_FontUnderline 0026 TFormatCondition.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1651_0 {
	meta:
		name = "TDataAccessPage.Get_CurrentView"
		size = 96
		refs = "0012 TDataAccessPage.Get_CurrentView 0026 TDataAccessPage.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1942_0 {
	meta:
		name = "TDefaultWebOptions.Get_OrganizeInFolder"
		size = 96
		refs = "0012 TDefaultWebOptions.Get_OrganizeInFolder 0026 TDefaultWebOptions.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_71337_0 {
	meta:
		name = "TOutlookBarPane.Get_Visible"
		size = 96
		refs = "0012 TOutlookBarPane.Get_Visible 0026 TOutlookBarPane.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_86_0 {
	meta:
		name = "TFormatCondition.Set_FontUnderline"
		size = 84
		refs = "000f TFormatCondition.Set_FontUnderline 0020 TFormatCondition.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1943_0 {
	meta:
		name = "TDefaultWebOptions.Set_OrganizeInFolder"
		size = 84
		refs = "000f TDefaultWebOptions.Set_OrganizeInFolder 0020 TDefaultWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71271_0 {
	meta:
		name = "TNoteItem.Set_Color"
		size = 84
		refs = "000f TNoteItem.Set_Color 0020 TNoteItem.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71338_0 {
	meta:
		name = "TOutlookBarPane.Set_Visible"
		size = 84
		refs = "000f TOutlookBarPane.Set_Visible 0020 TOutlookBarPane.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4076_0 {
	meta:
		name = "TPrinter.Set_Orientation"
		size = 84
		refs = "000f TPrinter.Set_Orientation 0020 TPrinter.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79411_0 {
	meta:
		name = "TShellUIHelper.AutoCompleteSaveForm"
		size = 84
		refs = "000f TShellUIHelper.AutoCompleteSaveForm 0020 TShellUIHelper.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99292_0 {
	meta:
		name = "TWordFont.Set_Hidden"
		size = 84
		refs = "000f TWordFont.Set_Hidden 0020 TWordFont.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99382_0 {
	meta:
		name = "TWordParagraphFormat.Set_KeepTogether"
		size = 84
		refs = "000f TWordParagraphFormat.Set_KeepTogether 0020 TWordParagraphFormat.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_87_0 {
	meta:
		name = "TFormatCondition.Get_Enabled"
		size = 96
		refs = "0012 TFormatCondition.Get_Enabled 0026 TFormatCondition.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1240_0 {
	meta:
		name = "TAccessReport.Get_OrderByOn"
		size = 96
		refs = "0012 TAccessReport.Get_OrderByOn 0026 TAccessReport.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_9237_0 {
	meta:
		name = "TBinder.Get_Visible"
		size = 96
		refs = "0012 TBinder.Get_Visible 0026 TBinder.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_11460_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Get_RemoveEnabled"
		size = 96
		refs = "0012 TCOMAdminCatalogCollection.Get_RemoveEnabled 0026 TCOMAdminCatalogCollection.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_1944_0 {
	meta:
		name = "TDefaultWebOptions.Get_UseLongFileNames"
		size = 96
		refs = "0012 TDefaultWebOptions.Get_UseLongFileNames 0026 TDefaultWebOptions.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_3258_0 {
	meta:
		name = "TReportOld.Get_OrderByOn"
		size = 96
		refs = "0012 TReportOld.Get_OrderByOn 0026 TReportOld.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_79454_0 {
	meta:
		name = "TShellNameSpace.CreateSubscriptionForSelection"
		size = 96
		refs = "0012 TShellNameSpace.CreateSubscriptionForSelection 0026 TShellNameSpace.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_98824_0 {
	meta:
		name = "TWordGlobal.Get_PrintPreview"
		size = 96
		refs = "0012 TWordGlobal.Get_PrintPreview 0026 TWordGlobal.GetDefaultInterface 0034 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 0F B7 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_88_0 {
	meta:
		name = "TFormatCondition.Set_Enabled"
		size = 84
		refs = "000f TFormatCondition.Set_Enabled 0020 TFormatCondition.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1241_0 {
	meta:
		name = "TAccessReport.Set_OrderByOn"
		size = 84
		refs = "000f TAccessReport.Set_OrderByOn 0020 TAccessReport.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1977_0 {
	meta:
		name = "TAccessWebOptions.Set_Encoding"
		size = 84
		refs = "000f TAccessWebOptions.Set_Encoding 0020 TAccessWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9238_0 {
	meta:
		name = "TBinder.Set_Visible"
		size = 84
		refs = "000f TBinder.Set_Visible 0020 TBinder.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1945_0 {
	meta:
		name = "TDefaultWebOptions.Set_UseLongFileNames"
		size = 84
		refs = "000f TDefaultWebOptions.Set_UseLongFileNames 0020 TDefaultWebOptions.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_49477_0 {
	meta:
		name = "TExcelWorkbook.Set_AutoUpdateFrequency"
		size = 84
		refs = "000f TExcelWorkbook.Set_AutoUpdateFrequency 0020 TExcelWorkbook.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4078_0 {
	meta:
		name = "TPrinter.Set_PaperBin"
		size = 84
		refs = "000f TPrinter.Set_PaperBin 0020 TPrinter.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3259_0 {
	meta:
		name = "TReportOld.Set_OrderByOn"
		size = 84
		refs = "000f TReportOld.Set_OrderByOn 0020 TReportOld.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79415_0 {
	meta:
		name = "TShellUIHelper.AutoCompleteAttach"
		size = 84
		refs = "000f TShellUIHelper.AutoCompleteAttach 0020 TShellUIHelper.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99294_0 {
	meta:
		name = "TWordFont.Set_SmallCaps"
		size = 84
		refs = "000f TWordFont.Set_SmallCaps 0020 TWordFont.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98825_0 {
	meta:
		name = "TWordGlobal.Set_PrintPreview"
		size = 84
		refs = "000f TWordGlobal.Set_PrintPreview 0020 TWordGlobal.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99507_0 {
	meta:
		name = "TWordLetterContent.Set_LetterStyle"
		size = 84
		refs = "000f TWordLetterContent.Set_LetterStyle 0020 TWordLetterContent.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99384_0 {
	meta:
		name = "TWordParagraphFormat.Set_KeepWithNext"
		size = 84
		refs = "000f TWordParagraphFormat.Set_KeepWithNext 0020 TWordParagraphFormat.GetDefaultInterface 002e @CheckAutoResult 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_89_0 {
	meta:
		name = "TFormatCondition.Get_type_"
		size = 95
		refs = "0012 TFormatCondition.Get_type_ 0026 TFormatCondition.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_11461_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Get_DataStoreMajorVersion"
		size = 95
		refs = "0012 TCOMAdminCatalogCollection.Get_DataStoreMajorVersion 0026 TCOMAdminCatalogCollection.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_70061_0 {
	meta:
		name = "TExplorer.Get_Height"
		size = 95
		refs = "0012 TExplorer.Get_Height 0026 TExplorer.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_4079_0 {
	meta:
		name = "TPrinter.Get_PaperSize"
		size = 95
		refs = "0012 TPrinter.Get_PaperSize 0026 TPrinter.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_98944_0 {
	meta:
		name = "TWordDocument.Get_type_"
		size = 95
		refs = "0012 TWordDocument.Get_type_ 0026 TWordDocument.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_99295_0 {
	meta:
		name = "TWordFont.Get_AllCaps"
		size = 95
		refs = "0012 TWordFont.Get_AllCaps 0026 TWordFont.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_99385_0 {
	meta:
		name = "TWordParagraphFormat.Get_PageBreakBefore"
		size = 95
		refs = "0012 TWordParagraphFormat.Get_PageBreakBefore 0026 TWordParagraphFormat.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_90_0 {
	meta:
		name = "TFormatCondition.Get_Operator"
		size = 95
		refs = "0012 TFormatCondition.Get_Operator 0026 TFormatCondition.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_11462_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Get_DataStoreMinorVersion"
		size = 95
		refs = "0012 TCOMAdminCatalogCollection.Get_DataStoreMinorVersion 0026 TCOMAdminCatalogCollection.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_71275_0 {
	meta:
		name = "TNoteItem.Get_Height"
		size = 95
		refs = "0012 TNoteItem.Get_Height 0026 TNoteItem.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_79428_0 {
	meta:
		name = "TShellNameSpace.Get_EnumOptions"
		size = 95
		refs = "0012 TShellNameSpace.Get_EnumOptions 0026 TShellNameSpace.GetDefaultInterface 0034 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 33 D2 89 55 F8 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_91_0 {
	meta:
		name = "TFormatCondition.Get_Expression1"
		size = 91
		refs = "000f TFormatCondition.Get_Expression1 001c @WStrClr 0027 TFormatCondition.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1446_0 {
	meta:
		name = "TAccessApplication.Get_Forms"
		size = 91
		refs = "000f TAccessApplication.Get_Forms 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1244_0 {
	meta:
		name = "TAccessReport.Get_Caption"
		size = 91
		refs = "000f TAccessReport.Get_Caption 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72071_0 {
	meta:
		name = "TAppointmentItem.Get_ConversationIndex"
		size = 91
		refs = "000f TAppointmentItem.Get_ConversationIndex 001c @WStrClr 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9241_0 {
	meta:
		name = "TBinder.Get_BuiltinDocumentProperties"
		size = 91
		refs = "000f TBinder.Get_BuiltinDocumentProperties 001c @IntfClear 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1854_0 {
	meta:
		name = "TCodeProject.Get_Properties"
		size = 91
		refs = "000f TCodeProject.Get_Properties 001c @IntfClear 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70651_0 {
	meta:
		name = "TContactItem.Get_ConversationIndex"
		size = 91
		refs = "000f TContactItem.Get_ConversationIndex 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3851_0 {
	meta:
		name = "TCurrentProject.Get_Properties"
		size = 91
		refs = "000f TCurrentProject.Get_Properties 001c @IntfClear 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1656_0 {
	meta:
		name = "TDataAccessPage.Get_ConnectionString"
		size = 91
		refs = "000f TDataAccessPage.Get_ConnectionString 001c @WStrClr 0027 TDataAccessPage.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72770_0 {
	meta:
		name = "TDistListItem.Get_ConversationIndex"
		size = 91
		refs = "000f TDistListItem.Get_ConversationIndex 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72851_0 {
	meta:
		name = "TDocumentItem.Get_ConversationIndex"
		size = 91
		refs = "000f TDocumentItem.Get_ConversationIndex 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70097_0 {
	meta:
		name = "TInspector.Get_HTMLEditor"
		size = 91
		refs = "000f TInspector.Get_HTMLEditor 001c @IntfClear 0027 TInspector.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72978_0 {
	meta:
		name = "TItems.GetNext"
		size = 91
		refs = "000f TItems.GetNext 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71154_0 {
	meta:
		name = "TJournalItem.Get_ConversationIndex"
		size = 91
		refs = "000f TJournalItem.Get_ConversationIndex 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70142_0 {
	meta:
		name = "TMailItem.Get_ConversationIndex"
		size = 91
		refs = "000f TMailItem.Get_ConversationIndex 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67433_0 {
	meta:
		name = "TMaster.Get_Scripts"
		size = 91
		refs = "000f TMaster.Get_Scripts 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72205_0 {
	meta:
		name = "TMeetingItem.Get_ConversationIndex"
		size = 91
		refs = "000f TMeetingItem.Get_ConversationIndex 001c @WStrClr 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70610_0 {
	meta:
		name = "TOutlookApplication.Get_COMAddIns"
		size = 91
		refs = "000f TOutlookApplication.Get_COMAddIns 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73253_0 {
	meta:
		name = "TPostItem.Get_ConversationIndex"
		size = 91
		refs = "000f TPostItem.Get_ConversationIndex 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74463_0 {
	meta:
		name = "TPowerPointApplication.Get_Build"
		size = 91
		refs = "000f TPowerPointApplication.Get_Build 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74330_0 {
	meta:
		name = "TPowerPointPresentation.Get_SlideShowSettings"
		size = 91
		refs = "000f TPowerPointPresentation.Get_SlideShowSettings 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4081_0 {
	meta:
		name = "TPrinter.Get_Port"
		size = 91
		refs = "000f TPrinter.Get_Port 001c @WStrClr 0027 TPrinter.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73337_0 {
	meta:
		name = "TRemoteItem.Get_ConversationIndex"
		size = 91
		refs = "000f TRemoteItem.Get_ConversationIndex 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71521_0 {
	meta:
		name = "TReportItem.Get_ConversationIndex"
		size = 91
		refs = "000f TReportItem.Get_ConversationIndex 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3262_0 {
	meta:
		name = "TReportOld.Get_Caption"
		size = 91
		refs = "000f TReportOld.Get_Caption 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72308_0 {
	meta:
		name = "TTaskItem.Get_ConversationIndex"
		size = 91
		refs = "000f TTaskItem.Get_ConversationIndex 001c @WStrClr 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73477_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_ConversationIndex"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_ConversationIndex 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71646_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_ConversationIndex"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_ConversationIndex 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71709_0 {
	meta:
		name = "TTaskRequestItem.Get_ConversationIndex"
		size = 91
		refs = "000f TTaskRequestItem.Get_ConversationIndex 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71772_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_ConversationIndex"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_ConversationIndex 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99586_0 {
	meta:
		name = "TWordApplication.Get_FontNames"
		size = 91
		refs = "000f TWordApplication.Get_FontNames 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98828_0 {
	meta:
		name = "TWordGlobal.Get_System_"
		size = 91
		refs = "000f TWordGlobal.Get_System_ 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_92_0 {
	meta:
		name = "TFormatCondition.Get_Expression2"
		size = 91
		refs = "000f TFormatCondition.Get_Expression2 001c @WStrClr 0027 TFormatCondition.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3465_0 {
	meta:
		name = "TAccessApplication.Get_Reports"
		size = 91
		refs = "000f TAccessApplication.Get_Reports 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72072_0 {
	meta:
		name = "TAppointmentItem.Get_ConversationTopic"
		size = 91
		refs = "000f TAppointmentItem.Get_ConversationTopic 001c @WStrClr 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9242_0 {
	meta:
		name = "TBinder.Get_CustomDocumentProperties"
		size = 91
		refs = "000f TBinder.Get_CustomDocumentProperties 001c @IntfClear 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1855_0 {
	meta:
		name = "TCodeProject.Get_Application"
		size = 91
		refs = "000f TCodeProject.Get_Application 001c @IntfClear 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72482_0 {
	meta:
		name = "TContactItem.Get_ConversationTopic"
		size = 91
		refs = "000f TContactItem.Get_ConversationTopic 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1812_0 {
	meta:
		name = "TCurrentProject.Get_Application"
		size = 91
		refs = "000f TCurrentProject.Get_Application 001c @IntfClear 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72771_0 {
	meta:
		name = "TDistListItem.Get_ConversationTopic"
		size = 91
		refs = "000f TDistListItem.Get_ConversationTopic 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72852_0 {
	meta:
		name = "TDocumentItem.Get_ConversationTopic"
		size = 91
		refs = "000f TDocumentItem.Get_ConversationTopic 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46118_0 {
	meta:
		name = "TExcelApplication.Get_Cells"
		size = 91
		refs = "000f TExcelApplication.Get_Cells 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_49289_0 {
	meta:
		name = "TExcelGlobal.Get_Cells"
		size = 91
		refs = "000f TExcelGlobal.Get_Cells 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70098_0 {
	meta:
		name = "TInspector.Get_WordEditor"
		size = 91
		refs = "000f TInspector.Get_WordEditor 001c @IntfClear 0027 TInspector.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72979_0 {
	meta:
		name = "TItems.GetPrevious"
		size = 91
		refs = "000f TItems.GetPrevious 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71155_0 {
	meta:
		name = "TJournalItem.Get_ConversationTopic"
		size = 91
		refs = "000f TJournalItem.Get_ConversationTopic 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70143_0 {
	meta:
		name = "TMailItem.Get_ConversationTopic"
		size = 91
		refs = "000f TMailItem.Get_ConversationTopic 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74538_0 {
	meta:
		name = "TMaster.Get_Design"
		size = 91
		refs = "000f TMaster.Get_Design 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70398_0 {
	meta:
		name = "TMeetingItem.Get_ConversationTopic"
		size = 91
		refs = "000f TMeetingItem.Get_ConversationTopic 001c @WStrClr 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70611_0 {
	meta:
		name = "TOutlookApplication.Get_Explorers"
		size = 91
		refs = "000f TOutlookApplication.Get_Explorers 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71383_0 {
	meta:
		name = "TPostItem.Get_ConversationTopic"
		size = 91
		refs = "000f TPostItem.Get_ConversationTopic 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67373_0 {
	meta:
		name = "TPowerPointApplication.Get_Version"
		size = 91
		refs = "000f TPowerPointApplication.Get_Version 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67269_0 {
	meta:
		name = "TPowerPointPresentation.Get_Fonts"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Fonts 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71456_0 {
	meta:
		name = "TRemoteItem.Get_ConversationTopic"
		size = 91
		refs = "000f TRemoteItem.Get_ConversationTopic 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71522_0 {
	meta:
		name = "TReportItem.Get_ConversationTopic"
		size = 91
		refs = "000f TReportItem.Get_ConversationTopic 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79430_0 {
	meta:
		name = "TShellNameSpace.Get_SelectedItem"
		size = 91
		refs = "000f TShellNameSpace.Get_SelectedItem 001c @IntfClear 0027 TShellNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72309_0 {
	meta:
		name = "TTaskItem.Get_ConversationTopic"
		size = 91
		refs = "000f TTaskItem.Get_ConversationTopic 001c @WStrClr 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71584_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_ConversationTopic"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_ConversationTopic 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71647_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_ConversationTopic"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_ConversationTopic 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73616_0 {
	meta:
		name = "TTaskRequestItem.Get_ConversationTopic"
		size = 91
		refs = "000f TTaskRequestItem.Get_ConversationTopic 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73685_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_ConversationTopic"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_ConversationTopic 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99587_0 {
	meta:
		name = "TWordApplication.Get_LandscapeFontNames"
		size = 91
		refs = "000f TWordApplication.Get_LandscapeFontNames 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98829_0 {
	meta:
		name = "TWordGlobal.Get_AutoCorrect"
		size = 91
		refs = "000f TWordGlobal.Get_AutoCorrect 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_93_0 {
	meta:
		name = "TFormatCondition.Modify"
		size = 121
		refs = "0012 TFormatCondition.Modify 001d EmptyParam 0044 TFormatCondition.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_94_0 {
	meta:
		name = "TFormatCondition.Modify"
		size = 152
		refs = "0022 @VarAddRef 002a TFormatCondition.Modify 0035 EmptyParam 0058 TFormatCondition.GetDefaultInterface 0066 @CheckAutoResult 007b @IntfClear 0083 @VarClr 0089 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_95_0 {
	meta:
		name = "TFormatCondition.Modify"
		size = 177
		refs = "002c @VarAddRef 003c TFormatCondition.Modify 0066 TFormatCondition.GetDefaultInterface 0074 @CheckAutoResult 0089 @IntfClear 0092 OleVariant 009c @FinalizeArray 00a2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 DC 53 56 57 33 DB 89 5D DC 8B 75 08 8D 7D E0 A5 A5 A5 A5 8B 75 0C 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 E0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 EC FF 75 E8 FF 75 E4 FF 75 E0 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 57 56 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 45 DC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule function_96_0 {
	meta:
		name = "TFormatCondition.Delete"
		size = 79
		refs = "000c TFormatCondition.Delete 001c TFormatCondition.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_11424_0 {
	meta:
		name = "TCOMAdminCatalog.RefreshComponents"
		size = 79
		refs = "000c TCOMAdminCatalog.RefreshComponents 001c TCOMAdminCatalog.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_71125_0 {
	meta:
		name = "TItems.ResetColumns"
		size = 79
		refs = "000c TItems.ResetColumns 001c TItems.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_71250_0 {
	meta:
		name = "TNameSpace.RefreshRemoteHeaders"
		size = 79
		refs = "000c TNameSpace.RefreshRemoteHeaders 001c TNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_97_0 {
	meta:
		name = "TAccessControl.InitControlData"
		size = 12
		refs = "0001 CControlData"
		altNames = "TAccessField.InitControlData TAccessGroupLevel.InitControlData TAccessImage.InitControlData TAccessLabel.InitControlData TAccessLine.InitControlData TAccessPage.InitControlData TAccessPageBreak.InitControlData TAccessRectangle.InitControlData TAccessSection.InitControlData TDataSourceObject.InitControlData"
	strings:
		$1 = { BA ?? ?? ?? ?? 89 90 70 02 00 00 C3 }
	condition:
		$1
}

rule function_98_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 F0 02 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 C1 EA C1 B1 6F 48 CE 11 A6 5D 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_99_0 {
	meta:
		name = "TAccessControl.CreateControl"
		size = 29
		refs = "0015 DoCreate"
		altNames = "TAccessField.CreateControl TAccessGroupLevel.CreateControl TAccessImage.CreateControl TAccessLabel.CreateControl TAccessLine.CreateControl TAccessPage.CreateControl TAccessPageBreak.CreateControl TAccessRectangle.CreateControl TAccessSection.CreateControl TDataSourceObject.CreateControl"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 8B 45 FC 83 B8 F0 02 00 00 00 75 07 55 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule function_100_0 {
	meta:
		name = "TAccessField.GetControlInterface"
		size = 29
		refs = "0009 TAccessField.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_128_0 {
	meta:
		name = "TAccessControl.GetControlInterface"
		size = 29
		refs = "0009 TAccessControl.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2880_0 {
	meta:
		name = "TAccessGroupLevel.GetControlInterface"
		size = 29
		refs = "0009 TAccessGroupLevel.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2147_0 {
	meta:
		name = "TAccessImage.GetControlInterface"
		size = 29
		refs = "0009 TAccessImage.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_155_0 {
	meta:
		name = "TAccessLabel.GetControlInterface"
		size = 29
		refs = "0009 TAccessLabel.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2134_0 {
	meta:
		name = "TAccessLine.GetControlInterface"
		size = 29
		refs = "0009 TAccessLine.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_815_0 {
	meta:
		name = "TAccessPage.GetControlInterface"
		size = 29
		refs = "0009 TAccessPage.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_615_0 {
	meta:
		name = "TAccessPageBreak.GetControlInterface"
		size = 29
		refs = "0009 TAccessPageBreak.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_2121_0 {
	meta:
		name = "TAccessRectangle.GetControlInterface"
		size = 29
		refs = "0009 TAccessRectangle.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_854_0 {
	meta:
		name = "TAccessSection.GetControlInterface"
		size = 29
		refs = "0009 TAccessSection.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_73732_0 {
	meta:
		name = "TDataSourceObject.GetControlInterface"
		size = 29
		refs = "0009 TDataSourceObject.CreateControl 0016 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 8B C3 E8 ?? ?? ?? ?? 8B C6 8B 93 F0 02 00 00 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_101_0 {
	meta:
		name = "TAccessField.Get_Value"
		size = 152
		refs = "001a TAccessField.Get_Value 002a TAccessField.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_414_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Value"
		size = 152
		refs = "001a TAccessBoundObjectFrame.Get_Value 002a TAccessBoundObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_330_0 {
	meta:
		name = "TAccessCheckBox.Get_Value"
		size = 152
		refs = "001a TAccessCheckBox.Get_Value 002a TAccessCheckBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2527_0 {
	meta:
		name = "TAccessComboBox.Get_Value"
		size = 152
		refs = "001a TAccessComboBox.Get_Value 002a TAccessComboBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2761_0 {
	meta:
		name = "TAccessCustomControl.Get_Value"
		size = 152
		refs = "001a TAccessCustomControl.Get_Value 002a TAccessCustomControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "TAccessListBox.Get_Value"
		size = 152
		refs = "001a TAccessListBox.Get_Value 002a TAccessListBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2238_0 {
	meta:
		name = "TAccessOptionButton.Get_Value"
		size = 152
		refs = "001a TAccessOptionButton.Get_Value 002a TAccessOptionButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2327_0 {
	meta:
		name = "TAccessOptionGroup.Get_Value"
		size = 152
		refs = "001a TAccessOptionGroup.Get_Value 002a TAccessOptionGroup.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_675_0 {
	meta:
		name = "TAccessPaletteButton.Get_Value"
		size = 152
		refs = "001a TAccessPaletteButton.Get_Value 002a TAccessPaletteButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_799_0 {
	meta:
		name = "TAccessTabControl.Get_Value"
		size = 152
		refs = "001a TAccessTabControl.Get_Value 002a TAccessTabControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2422_0 {
	meta:
		name = "TAccessTextBox.Get_Value"
		size = 152
		refs = "001a TAccessTextBox.Get_Value 002a TAccessTextBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_645_0 {
	meta:
		name = "TAccessToggleButton.Get_Value"
		size = 152
		refs = "001a TAccessToggleButton.Get_Value 002a TAccessToggleButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_102_0 {
	meta:
		name = "TAccessField.Set_Value"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessField.Set_Value 0041 TAccessField.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_103_0 {
	meta:
		name = "CoAccessHyperlink.Create"
		size = 100
		refs = "000c CoAccessHyperlink.Create 001a CLASS_AccessHyperlink 001f CreateComObject 002e @IntfCast 0043 @IntfClear 0049 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 11 66 D5 50 AC 60 CF 11 82 C9 00 AA 00 4B 9F E6 }
	condition:
		$1
}

rule function_104_0 {
	meta:
		name = "CoAccessHyperlink.CreateRemote"
		size = 128
		refs = "0011 CoAccessHyperlink.CreateRemote 0021 @WStrFromUStr 002c CLASS_AccessHyperlink 0031 CreateRemoteComObject 0040 @IntfCast 0055 @WStrClr 005d @IntfClear 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F1 8B DA 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 8D 4D FC BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 FC 8B C6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 59 59 5D C3 00 11 66 D5 50 AC 60 CF 11 82 C9 00 AA 00 4B 9F E6 }
	condition:
		$1
}

rule function_106_0 {
	meta:
		name = "TAccessHyperlink.Connect"
		size = 104
		refs = "000c TAccessHyperlink.Connect 0032 @IntfCast 0047 @IntfClear 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 7B 54 00 75 1A 8D 55 FC 8B C3 8B 08 FF 51 38 8D 43 54 8B 55 FC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 00 11 66 D5 50 AC 60 CF 11 82 C9 00 AA 00 4B 9F E6 }
	condition:
		$1
}

rule function_109_0 {
	meta:
		name = "TAccessHyperlink.GetDefaultInterface"
		size = 420
		refs = "001f TAccessHyperlink.GetDefaultInterface 0029 @Assert 0033 @IntfCopy"
	strings:
		$1 = { 53 56 8B F2 8B D8 83 7B 54 00 75 07 8B C3 8B 10 FF 52 40 83 7B 54 00 75 14 B9 C6 47 00 00 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 8B 53 54 E8 ?? ?? ?? ?? 5E 5B C3 00 00 B0 04 02 00 FF FF FF FF 29 00 00 00 43 00 3A 00 5C 00 62 00 75 00 69 00 6C 00 64 00 73 00 5C 00 54 00 70 00 5C 00 74 00 79 00 70 00 65 00 6C 00 69 00 62 00 5C 00 70 00 61 00 73 00 32 00 6B 00 5C 00 41 00 63 00 63 00 65 00 73 00 73 00 32 00 30 00 30 00 30 00 2E 00 70 00 61 00 73 00 00 00 B0 04 02 00 FF FF FF FF 7C 00 00 00 44 00 65 00 66 00 61 00 75 00 6C 00 74 00 49 00 6E 00 74 00 65 00 72 00 66 00 61 00 63 00 65 00 20 00 69 00 73 00 20 00 4E 00 55 00 4C 00 4C 00 2E 00 20 00 43 00 6F 00 6D 00 70 00 6F 00 6E 00 65 00 6E 00 74 00 20 00 69 00 73 00 20 00 6E 00 6F 00 74 00 20 00 63 00 6F 00 6E 00 6E 00 65 00 63 00 74 00 65 00 64 00 20 00 74 00 6F 00 20 00 53 00 65 00 72 00 76 00 65 00 72 00 2E 00 20 00 59 00 6F 00 75 00 20 00 6D 00 75 00 73 00 74 00 20 00 63 00 61 00 6C 00 6C 00 20 00 27 00 43 00 6F 00 6E 00 6E 00 65 00 63 00 74 00 27 00 20 00 6F 00 72 00 20 00 27 00 43 00 6F 00 6E 00 6E 00 65 00 63 00 74 00 54 00 6F 00 27 00 20 00 62 00 65 00 66 00 6F 00 72 00 65 00 20 00 74 00 68 00 69 00 73 00 20 00 6F 00 70 00 65 00 72 00 61 00 74 00 69 00 6F 00 6E 00 00 00 00 00 }
	condition:
		$1
}

rule function_112_0 {
	meta:
		name = "TAccessHyperlink.Get_SubAddress"
		size = 156
		refs = "001a TAccessHyperlink.Get_SubAddress 002a TAccessHyperlink.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @VarToWStr 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 53 75 62 41 64 64 72 65 73 73 00 00 00 }
	condition:
		$1
}

rule function_113_0 {
	meta:
		name = "TAccessHyperlink.Set_SubAddress"
		size = 168
		refs = "0022 @VarAddRef 002a TAccessHyperlink.Set_SubAddress 003a TAccessHyperlink.GetDefaultInterface 0045 @VarFromDisp 0059 @DispInvoke 0071 @IntfClear 007a OleVariant 0084 @FinalizeArray 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5F 5E 5B 8B E5 5D C3 00 04 01 00 8C 53 75 62 41 64 64 72 65 73 73 00 00 }
	condition:
		$1
}

rule function_114_0 {
	meta:
		name = "TAccessHyperlink.Get_Address"
		size = 152
		refs = "001a TAccessHyperlink.Get_Address 002a TAccessHyperlink.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @VarToWStr 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 41 64 64 72 65 73 73 00 00 }
	condition:
		$1
}

rule function_115_0 {
	meta:
		name = "TAccessHyperlink.Set_Address"
		size = 164
		refs = "0022 @VarAddRef 002a TAccessHyperlink.Set_Address 003a TAccessHyperlink.GetDefaultInterface 0045 @VarFromDisp 0059 @DispInvoke 0071 @IntfClear 007a OleVariant 0084 @FinalizeArray 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5F 5E 5B 8B E5 5D C3 00 04 01 00 8C 41 64 64 72 65 73 73 00 }
	condition:
		$1
}

rule function_116_0 {
	meta:
		name = "TAccessHyperlink.Get_EmailSubject"
		size = 156
		refs = "001a TAccessHyperlink.Get_EmailSubject 002a TAccessHyperlink.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @VarToWStr 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 45 6D 61 69 6C 53 75 62 6A 65 63 74 00 }
	condition:
		$1
}

rule function_117_0 {
	meta:
		name = "TAccessHyperlink.Set_EmailSubject"
		size = 172
		refs = "0022 @VarAddRef 002a TAccessHyperlink.Set_EmailSubject 003a TAccessHyperlink.GetDefaultInterface 0045 @VarFromDisp 0059 @DispInvoke 0071 @IntfClear 007a OleVariant 0084 @FinalizeArray 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5F 5E 5B 8B E5 5D C3 00 04 01 00 8C 45 6D 61 69 6C 53 75 62 6A 65 63 74 00 00 00 00 }
	condition:
		$1
}

rule function_118_0 {
	meta:
		name = "TAccessHyperlink.Get_ScreenTip"
		size = 156
		refs = "001a TAccessHyperlink.Get_ScreenTip 002a TAccessHyperlink.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @VarToWStr 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 53 63 72 65 65 6E 54 69 70 00 00 00 00 }
	condition:
		$1
}

rule function_119_0 {
	meta:
		name = "TAccessHyperlink.Set_ScreenTip"
		size = 168
		refs = "0022 @VarAddRef 002a TAccessHyperlink.Set_ScreenTip 003a TAccessHyperlink.GetDefaultInterface 0045 @VarFromDisp 0059 @DispInvoke 0071 @IntfClear 007a OleVariant 0084 @FinalizeArray 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5F 5E 5B 8B E5 5D C3 00 04 01 00 8C 53 63 72 65 65 6E 54 69 70 00 00 00 }
	condition:
		$1
}

rule function_120_0 {
	meta:
		name = "TAccessHyperlink.Get_TextToDisplay"
		size = 160
		refs = "001a TAccessHyperlink.Get_TextToDisplay 002a TAccessHyperlink.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @VarToWStr 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 54 65 78 74 54 6F 44 69 73 70 6C 61 79 00 00 00 00 }
	condition:
		$1
}

rule function_121_0 {
	meta:
		name = "TAccessHyperlink.Set_TextToDisplay"
		size = 172
		refs = "0022 @VarAddRef 002a TAccessHyperlink.Set_TextToDisplay 003a TAccessHyperlink.GetDefaultInterface 0045 @VarFromDisp 0059 @DispInvoke 0071 @IntfClear 007a OleVariant 0084 @FinalizeArray 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DD 5F 5E 5B 8B E5 5D C3 00 04 01 00 8C 54 65 78 74 54 6F 44 69 73 70 6C 61 79 00 00 00 }
	condition:
		$1
}

rule function_122_0 {
	meta:
		name = "TAccessHyperlink.AddToFavorites"
		size = 79
		refs = "000c TAccessHyperlink.AddToFavorites 001c TAccessHyperlink.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_218_0 {
	meta:
		name = "TAccessImage.SizeToFit"
		size = 79
		refs = "000c TAccessImage.SizeToFit 001c TAccessImage.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_677_0 {
	meta:
		name = "TAccessPaletteButton.SizeToFit"
		size = 79
		refs = "000c TAccessPaletteButton.SizeToFit 001c TAccessPaletteButton.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_73799_0 {
	meta:
		name = "TReminder.Dismiss"
		size = 79
		refs = "000c TReminder.Dismiss 001c TReminder.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79449_0 {
	meta:
		name = "TShellNameSpace.Synchronize"
		size = 79
		refs = "000c TShellNameSpace.Synchronize 001c TShellNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_123_0 {
	meta:
		name = "TAccessHyperlink.Follow"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessHyperlink.Follow 0050 TAccessHyperlink.GetDefaultInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 10 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 50 8B 45 0C 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_124_0 {
	meta:
		name = "TAccessHyperlink.CreateNewDocument"
		size = 96
		refs = "0012 TAccessHyperlink.CreateNewDocument 0029 TAccessHyperlink.GetDefaultInterface 0037 @CheckAutoResult 004c @IntfClear 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 0F B7 45 08 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_126_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 F0 02 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 40 65 B9 26 8E 8F 1B 10 AF 4E 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_129_0 {
	meta:
		name = "TAccessControl.Get_Application"
		size = 91
		refs = "000f TAccessControl.Get_Application 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3457_0 {
	meta:
		name = "TAccessApplication.Get_Application"
		size = 91
		refs = "000f TAccessApplication.Get_Application 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2352_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accParent"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_accParent 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2262_0 {
	meta:
		name = "TAccessCheckBox.Get_accParent"
		size = 91
		refs = "000f TAccessCheckBox.Get_accParent 001c @IntfClear 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2503_0 {
	meta:
		name = "TAccessComboBox.Get_accParent"
		size = 91
		refs = "000f TAccessComboBox.Get_accParent 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_227_0 {
	meta:
		name = "TAccessCommandButton.Get_accParent"
		size = 91
		refs = "000f TAccessCommandButton.Get_accParent 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2739_0 {
	meta:
		name = "TAccessCustomControl.Get_accParent"
		size = 91
		refs = "000f TAccessCustomControl.Get_accParent 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4118_0 {
	meta:
		name = "TAccessForm.Get_accParent"
		size = 91
		refs = "000f TAccessForm.Get_accParent 001c @IntfClear 0027 TAccessForm.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2881_0 {
	meta:
		name = "TAccessGroupLevel.Get_Application"
		size = 91
		refs = "000f TAccessGroupLevel.Get_Application 001c @IntfClear 0027 TAccessGroupLevel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_208_0 {
	meta:
		name = "TAccessImage.Get_Application"
		size = 91
		refs = "000f TAccessImage.Get_Application 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2084_0 {
	meta:
		name = "TAccessLabel.Get_accParent"
		size = 91
		refs = "000f TAccessLabel.Get_accParent 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_199_0 {
	meta:
		name = "TAccessLine.Get_Application"
		size = 91
		refs = "000f TAccessLine.Get_Application 001c @IntfClear 0027 TAccessLine.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "TAccessListBox.Get_accParent"
		size = 91
		refs = "000f TAccessListBox.Get_accParent 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_572_0 {
	meta:
		name = "TAccessObjectFrame.Get_accParent"
		size = 91
		refs = "000f TAccessObjectFrame.Get_accParent 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2218_0 {
	meta:
		name = "TAccessOptionButton.Get_accParent"
		size = 91
		refs = "000f TAccessOptionButton.Get_accParent 001c @IntfClear 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2307_0 {
	meta:
		name = "TAccessOptionGroup.Get_accParent"
		size = 91
		refs = "000f TAccessOptionGroup.Get_accParent 001c @IntfClear 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2830_0 {
	meta:
		name = "TAccessPage.Get_accParent"
		size = 91
		refs = "000f TAccessPage.Get_accParent 001c @IntfClear 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2606_0 {
	meta:
		name = "TAccessPageBreak.Get_Application"
		size = 91
		refs = "000f TAccessPageBreak.Get_Application 001c @IntfClear 0027 TAccessPageBreak.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2668_0 {
	meta:
		name = "TAccessPaletteButton.Get_Application"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Application 001c @IntfClear 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_190_0 {
	meta:
		name = "TAccessRectangle.Get_Application"
		size = 91
		refs = "000f TAccessRectangle.Get_Application 001c @IntfClear 0027 TAccessRectangle.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1627_0 {
	meta:
		name = "TAccessReferences.Get_Parent"
		size = 91
		refs = "000f TAccessReferences.Get_Parent 001c @IntfClear 0027 TAccessReferences.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4569_0 {
	meta:
		name = "TAccessReport.Get_FormName"
		size = 91
		refs = "000f TAccessReport.Get_FormName 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2873_0 {
	meta:
		name = "TAccessSection.Get_Application"
		size = 91
		refs = "000f TAccessSection.Get_Application 001c @IntfClear 0027 TAccessSection.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2688_0 {
	meta:
		name = "TAccessSubForm.Get_accParent"
		size = 91
		refs = "000f TAccessSubForm.Get_accParent 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2731_0 {
	meta:
		name = "TAccessSubReport.Get_Application"
		size = 91
		refs = "000f TAccessSubReport.Get_Application 001c @IntfClear 0027 TAccessSubReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2789_0 {
	meta:
		name = "TAccessTabControl.Get_accParent"
		size = 91
		refs = "000f TAccessTabControl.Get_accParent 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_436_0 {
	meta:
		name = "TAccessTextBox.Get_accParent"
		size = 91
		refs = "000f TAccessTextBox.Get_accParent 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_625_0 {
	meta:
		name = "TAccessToggleButton.Get_accParent"
		size = 91
		refs = "000f TAccessToggleButton.Get_accParent 001c @IntfClear 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4032_0 {
	meta:
		name = "TAccessWebOptions.Get_Application"
		size = 91
		refs = "000f TAccessWebOptions.Get_Application 001c @IntfClear 0027 TAccessWebOptions.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3761_0 {
	meta:
		name = "TAllDataAccessPages.Get_Application"
		size = 91
		refs = "000f TAllDataAccessPages.Get_Application 001c @IntfClear 0027 TAllDataAccessPages.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1786_0 {
	meta:
		name = "TAllDatabaseDiagrams.Get_Application"
		size = 91
		refs = "000f TAllDatabaseDiagrams.Get_Application 001c @IntfClear 0027 TAllDatabaseDiagrams.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3709_0 {
	meta:
		name = "TAllForms.Get_Application"
		size = 91
		refs = "000f TAllForms.Get_Application 001c @IntfClear 0027 TAllForms.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4818_0 {
	meta:
		name = "TAllFunctions.Get_Application"
		size = 91
		refs = "000f TAllFunctions.Get_Application 001c @IntfClear 0027 TAllFunctions.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1695_0 {
	meta:
		name = "TAllMacros.Get_Application"
		size = 91
		refs = "000f TAllMacros.Get_Application 001c @IntfClear 0027 TAllMacros.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1708_0 {
	meta:
		name = "TAllModules.Get_Application"
		size = 91
		refs = "000f TAllModules.Get_Application 001c @IntfClear 0027 TAllModules.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3787_0 {
	meta:
		name = "TAllQueries.Get_Application"
		size = 91
		refs = "000f TAllQueries.Get_Application 001c @IntfClear 0027 TAllQueries.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1682_0 {
	meta:
		name = "TAllReports.Get_Application"
		size = 91
		refs = "000f TAllReports.Get_Application 001c @IntfClear 0027 TAllReports.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1773_0 {
	meta:
		name = "TAllStoredProcedures.Get_Application"
		size = 91
		refs = "000f TAllStoredProcedures.Get_Application 001c @IntfClear 0027 TAllStoredProcedures.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3774_0 {
	meta:
		name = "TAllTables.Get_Application"
		size = 91
		refs = "000f TAllTables.Get_Application 001c @IntfClear 0027 TAllTables.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3800_0 {
	meta:
		name = "TAllViews.Get_Application"
		size = 91
		refs = "000f TAllViews.Get_Application 001c @IntfClear 0027 TAllViews.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72057_0 {
	meta:
		name = "TAppointmentItem.Get_Application"
		size = 91
		refs = "000f TAppointmentItem.Get_Application 001c @IntfClear 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9231_0 {
	meta:
		name = "TBinder.Get_Name"
		size = 91
		refs = "000f TBinder.Get_Name 001c @WStrClr 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3920_0 {
	meta:
		name = "TCodeData.Get_AllTables"
		size = 91
		refs = "000f TCodeData.Get_AllTables 001c @IntfClear 0027 TCodeData.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3887_0 {
	meta:
		name = "TCodeProject.Get_AllForms"
		size = 91
		refs = "000f TCodeProject.Get_AllForms 001c @IntfClear 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72467_0 {
	meta:
		name = "TContactItem.Get_Application"
		size = 91
		refs = "000f TContactItem.Get_Application 001c @IntfClear 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3872_0 {
	meta:
		name = "TCurrentData.Get_AllTables"
		size = 91
		refs = "000f TCurrentData.Get_AllTables 001c @IntfClear 0027 TCurrentData.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1799_0 {
	meta:
		name = "TCurrentProject.Get_AllForms"
		size = 91
		refs = "000f TCurrentProject.Get_AllForms 001c @IntfClear 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3678_0 {
	meta:
		name = "TDataAccessPage.Get__Name"
		size = 91
		refs = "000f TDataAccessPage.Get__Name 001c @WStrClr 0027 TDataAccessPage.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1934_0 {
	meta:
		name = "TDefaultWebOptions.Get_Application"
		size = 91
		refs = "000f TDefaultWebOptions.Get_Application 001c @IntfClear 0027 TDefaultWebOptions.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72756_0 {
	meta:
		name = "TDistListItem.Get_Application"
		size = 91
		refs = "000f TDistListItem.Get_Application 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72837_0 {
	meta:
		name = "TDocumentItem.Get_Application"
		size = 91
		refs = "000f TDocumentItem.Get_Application 001c @IntfClear 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46104_0 {
	meta:
		name = "TExcelApplication.Get_Application"
		size = 91
		refs = "000f TExcelApplication.Get_Application 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46685_0 {
	meta:
		name = "TExcelChart.Get_Application"
		size = 91
		refs = "000f TExcelChart.Get_Application 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_49275_0 {
	meta:
		name = "TExcelGlobal.Get_Application"
		size = 91
		refs = "000f TExcelGlobal.Get_Application 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_49467_0 {
	meta:
		name = "TExcelWorkbook.Get_Application"
		size = 91
		refs = "000f TExcelWorkbook.Get_Application 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_48962_0 {
	meta:
		name = "TExcelWorksheet.Get_Application"
		size = 91
		refs = "000f TExcelWorksheet.Get_Application 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71840_0 {
	meta:
		name = "TExplorer.Get_Application"
		size = 91
		refs = "000f TExplorer.Get_Application 001c @IntfClear 0027 TExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71049_0 {
	meta:
		name = "TExplorers.Get_Application"
		size = 91
		refs = "000f TExplorers.Get_Application 001c @IntfClear 0027 TExplorers.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72939_0 {
	meta:
		name = "TFolders.Get_Application"
		size = 91
		refs = "000f TFolders.Get_Application 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2894_0 {
	meta:
		name = "TFormOld.Get_accParent"
		size = 91
		refs = "000f TFormOld.Get_accParent 001c @IntfClear 0027 TFormOld.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70089_0 {
	meta:
		name = "TInspector.Get_Application"
		size = 91
		refs = "000f TInspector.Get_Application 001c @IntfClear 0027 TInspector.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72922_0 {
	meta:
		name = "TInspectors.Get_Application"
		size = 91
		refs = "000f TInspectors.Get_Application 001c @IntfClear 0027 TInspectors.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72963_0 {
	meta:
		name = "TItems.Get_Application"
		size = 91
		refs = "000f TItems.Get_Application 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72996_0 {
	meta:
		name = "TJournalItem.Get_Application"
		size = 91
		refs = "000f TJournalItem.Get_Application 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71918_0 {
	meta:
		name = "TMailItem.Get_Application"
		size = 91
		refs = "000f TMailItem.Get_Application 001c @IntfClear 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67420_0 {
	meta:
		name = "TMaster.Get_Application"
		size = 91
		refs = "000f TMaster.Get_Application 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72191_0 {
	meta:
		name = "TMeetingItem.Get_Application"
		size = 91
		refs = "000f TMeetingItem.Get_Application 001c @IntfClear 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73088_0 {
	meta:
		name = "TNameSpace.Get_Application"
		size = 91
		refs = "000f TNameSpace.Get_Application 001c @IntfClear 0027 TNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73128_0 {
	meta:
		name = "TNoteItem.Get_Application"
		size = 91
		refs = "000f TNoteItem.Get_Application 001c @IntfClear 0027 TNoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72425_0 {
	meta:
		name = "TOutlookApplication.Get_Application"
		size = 91
		refs = "000f TOutlookApplication.Get_Application 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73181_0 {
	meta:
		name = "TOutlookBarGroups.Get_Application"
		size = 91
		refs = "000f TOutlookBarGroups.Get_Application 001c @IntfClear 0027 TOutlookBarGroups.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71329_0 {
	meta:
		name = "TOutlookBarPane.Get_Application"
		size = 91
		refs = "000f TOutlookBarPane.Get_Application 001c @IntfClear 0027 TOutlookBarPane.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71349_0 {
	meta:
		name = "TOutlookBarShortcuts.Get_Application"
		size = 91
		refs = "000f TOutlookBarShortcuts.Get_Application 001c @IntfClear 0027 TOutlookBarShortcuts.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_6415_0 {
	meta:
		name = "TParameter.GetProperties"
		size = 91
		refs = "000f TParameter.GetProperties 001c @IntfClear 0027 TParameter.GetParameter 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71368_0 {
	meta:
		name = "TPostItem.Get_Application"
		size = 91
		refs = "000f TPostItem.Get_Application 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74449_0 {
	meta:
		name = "TPowerPointApplication.Get_Presentations"
		size = 91
		refs = "000f TPowerPointApplication.Get_Presentations 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74250_0 {
	meta:
		name = "TPowerPointGlobal.Get_ActivePresentation"
		size = 91
		refs = "000f TPowerPointGlobal.Get_ActivePresentation 001c @IntfClear 0027 TPowerPointGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74318_0 {
	meta:
		name = "TPowerPointPresentation.Get_Application"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Application 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74271_0 {
	meta:
		name = "TPowerPointSlide.Get_Application"
		size = 91
		refs = "000f TPowerPointSlide.Get_Application 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73790_0 {
	meta:
		name = "TReminder.Get_Application"
		size = 91
		refs = "000f TReminder.Get_Application 001c @IntfClear 0027 TReminder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73812_0 {
	meta:
		name = "TReminders.Get_Application"
		size = 91
		refs = "000f TReminders.Get_Application 001c @IntfClear 0027 TReminders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71441_0 {
	meta:
		name = "TRemoteItem.Get_Application"
		size = 91
		refs = "000f TRemoteItem.Get_Application 001c @IntfClear 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73395_0 {
	meta:
		name = "TReportItem.Get_Application"
		size = 91
		refs = "000f TReportItem.Get_Application 001c @IntfClear 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3248_0 {
	meta:
		name = "TReportOld.Get_FormName"
		size = 91
		refs = "000f TReportOld.Get_FormName 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73745_0 {
	meta:
		name = "TResults.Get_Application"
		size = 91
		refs = "000f TResults.Get_Application 001c @IntfClear 0027 TResults.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71823_0 {
	meta:
		name = "TSyncObject.Get_Application"
		size = 91
		refs = "000f TSyncObject.Get_Application 001c @IntfClear 0027 TSyncObject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72294_0 {
	meta:
		name = "TTaskItem.Get_Application"
		size = 91
		refs = "000f TTaskItem.Get_Application 001c @IntfClear 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71569_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Application"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Application 001c @IntfClear 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73532_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Application"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Application 001c @IntfClear 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73601_0 {
	meta:
		name = "TTaskRequestItem.Get_Application"
		size = 91
		refs = "000f TTaskRequestItem.Get_Application 001c @IntfClear 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73670_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Application"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Application 001c @IntfClear 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73772_0 {
	meta:
		name = "TViews.Get_Application"
		size = 91
		refs = "000f TViews.Get_Application 001c @IntfClear 0027 TViews.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_100750_0 {
	meta:
		name = "TWordApplication.Get_Application"
		size = 91
		refs = "000f TWordApplication.Get_Application 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98932_0 {
	meta:
		name = "TWordDocument.Get_Name"
		size = 91
		refs = "000f TWordDocument.Get_Name 001c @WStrClr 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99283_0 {
	meta:
		name = "TWordFont.Get_Application"
		size = 91
		refs = "000f TWordFont.Get_Application 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99882_0 {
	meta:
		name = "TWordGlobal.Get_Application"
		size = 91
		refs = "000f TWordGlobal.Get_Application 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99496_0 {
	meta:
		name = "TWordLetterContent.Get_Application"
		size = 91
		refs = "000f TWordLetterContent.Get_Application 001c @IntfClear 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99373_0 {
	meta:
		name = "TWordParagraphFormat.Get_Application"
		size = 91
		refs = "000f TWordParagraphFormat.Get_Application 001c @IntfClear 0027 TWordParagraphFormat.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 1C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_130_0 {
	meta:
		name = "TAccessControl.Get_Parent"
		size = 91
		refs = "000f TAccessControl.Get_Parent 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3458_0 {
	meta:
		name = "TAccessApplication.Get_Parent"
		size = 91
		refs = "000f TAccessApplication.Get_Parent 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2882_0 {
	meta:
		name = "TAccessGroupLevel.Get_Parent"
		size = 91
		refs = "000f TAccessGroupLevel.Get_Parent 001c @IntfClear 0027 TAccessGroupLevel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_209_0 {
	meta:
		name = "TAccessImage.Get_Parent"
		size = 91
		refs = "000f TAccessImage.Get_Parent 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_200_0 {
	meta:
		name = "TAccessLine.Get_Parent"
		size = 91
		refs = "000f TAccessLine.Get_Parent 001c @IntfClear 0027 TAccessLine.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_617_0 {
	meta:
		name = "TAccessPageBreak.Get_Parent"
		size = 91
		refs = "000f TAccessPageBreak.Get_Parent 001c @IntfClear 0027 TAccessPageBreak.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2669_0 {
	meta:
		name = "TAccessPaletteButton.Get_Parent"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Parent 001c @IntfClear 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_191_0 {
	meta:
		name = "TAccessRectangle.Get_Parent"
		size = 91
		refs = "000f TAccessRectangle.Get_Parent 001c @IntfClear 0027 TAccessRectangle.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_856_0 {
	meta:
		name = "TAccessSection.Get_Parent"
		size = 91
		refs = "000f TAccessSection.Get_Parent 001c @IntfClear 0027 TAccessSection.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2732_0 {
	meta:
		name = "TAccessSubReport.Get_Parent"
		size = 91
		refs = "000f TAccessSubReport.Get_Parent 001c @IntfClear 0027 TAccessSubReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4033_0 {
	meta:
		name = "TAccessWebOptions.Get_Parent"
		size = 91
		refs = "000f TAccessWebOptions.Get_Parent 001c @IntfClear 0027 TAccessWebOptions.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3762_0 {
	meta:
		name = "TAllDataAccessPages.Get_Parent"
		size = 91
		refs = "000f TAllDataAccessPages.Get_Parent 001c @IntfClear 0027 TAllDataAccessPages.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3827_0 {
	meta:
		name = "TAllDatabaseDiagrams.Get_Parent"
		size = 91
		refs = "000f TAllDatabaseDiagrams.Get_Parent 001c @IntfClear 0027 TAllDatabaseDiagrams.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1670_0 {
	meta:
		name = "TAllForms.Get_Parent"
		size = 91
		refs = "000f TAllForms.Get_Parent 001c @IntfClear 0027 TAllForms.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4819_0 {
	meta:
		name = "TAllFunctions.Get_Parent"
		size = 91
		refs = "000f TAllFunctions.Get_Parent 001c @IntfClear 0027 TAllFunctions.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1696_0 {
	meta:
		name = "TAllMacros.Get_Parent"
		size = 91
		refs = "000f TAllMacros.Get_Parent 001c @IntfClear 0027 TAllMacros.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1709_0 {
	meta:
		name = "TAllModules.Get_Parent"
		size = 91
		refs = "000f TAllModules.Get_Parent 001c @IntfClear 0027 TAllModules.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1748_0 {
	meta:
		name = "TAllQueries.Get_Parent"
		size = 91
		refs = "000f TAllQueries.Get_Parent 001c @IntfClear 0027 TAllQueries.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1683_0 {
	meta:
		name = "TAllReports.Get_Parent"
		size = 91
		refs = "000f TAllReports.Get_Parent 001c @IntfClear 0027 TAllReports.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1774_0 {
	meta:
		name = "TAllStoredProcedures.Get_Parent"
		size = 91
		refs = "000f TAllStoredProcedures.Get_Parent 001c @IntfClear 0027 TAllStoredProcedures.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1735_0 {
	meta:
		name = "TAllTables.Get_Parent"
		size = 91
		refs = "000f TAllTables.Get_Parent 001c @IntfClear 0027 TAllTables.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1761_0 {
	meta:
		name = "TAllViews.Get_Parent"
		size = 91
		refs = "000f TAllViews.Get_Parent 001c @IntfClear 0027 TAllViews.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9232_0 {
	meta:
		name = "TBinder.Get_Path"
		size = 91
		refs = "000f TBinder.Get_Path 001c @WStrClr 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1872_0 {
	meta:
		name = "TCodeData.Get_AllQueries"
		size = 91
		refs = "000f TCodeData.Get_AllQueries 001c @IntfClear 0027 TCodeData.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1843_0 {
	meta:
		name = "TCodeProject.Get_AllReports"
		size = 91
		refs = "000f TCodeProject.Get_AllReports 001c @IntfClear 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1829_0 {
	meta:
		name = "TCurrentData.Get_AllQueries"
		size = 91
		refs = "000f TCurrentData.Get_AllQueries 001c @IntfClear 0027 TCurrentData.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1800_0 {
	meta:
		name = "TCurrentProject.Get_AllReports"
		size = 91
		refs = "000f TCurrentProject.Get_AllReports 001c @IntfClear 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1644_0 {
	meta:
		name = "TDataAccessPage.Get_Name"
		size = 91
		refs = "000f TDataAccessPage.Get_Name 001c @WStrClr 0027 TDataAccessPage.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3999_0 {
	meta:
		name = "TDefaultWebOptions.Get_Parent"
		size = 91
		refs = "000f TDefaultWebOptions.Get_Parent 001c @IntfClear 0027 TDefaultWebOptions.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67421_0 {
	meta:
		name = "TMaster.Get_Parent"
		size = 91
		refs = "000f TMaster.Get_Parent 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_6405_0 {
	meta:
		name = "TParameter.GetName"
		size = 91
		refs = "000f TParameter.GetName 001c @WStrClr 0027 TParameter.GetParameter 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67359_0 {
	meta:
		name = "TPowerPointApplication.Get_Windows"
		size = 91
		refs = "000f TPowerPointApplication.Get_Windows 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67195_0 {
	meta:
		name = "TPowerPointGlobal.Get_ActiveWindow"
		size = 91
		refs = "000f TPowerPointGlobal.Get_ActiveWindow 001c @IntfClear 0027 TPowerPointGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67257_0 {
	meta:
		name = "TPowerPointPresentation.Get_Parent"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Parent 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67216_0 {
	meta:
		name = "TPowerPointSlide.Get_Parent"
		size = 91
		refs = "000f TPowerPointSlide.Get_Parent 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98933_0 {
	meta:
		name = "TWordDocument.Get_Application"
		size = 91
		refs = "000f TWordDocument.Get_Application 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_131_0 {
	meta:
		name = "TAccessControl.Get_Column"
		size = 200
		refs = "0029 @VarAddRef 0031 TAccessControl.Get_Column 0041 TAccessControl.GetControlInterface 004c @VarFromDisp 0066 @DispInvoke 0074 @OleVarFromVar 0089 @VarClr 0091 @IntfClear 009a OleVariant 00a4 @FinalizeArray 00aa @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 DC 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8B 55 D8 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 14 8D 55 C8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C2 04 00 00 00 00 02 02 00 83 8C 43 6F 6C 75 6D 6E 00 }
	condition:
		$1
}

rule function_543_0 {
	meta:
		name = "TAccessComboBox.Get_Column"
		size = 200
		refs = "0029 @VarAddRef 0031 TAccessComboBox.Get_Column 0041 TAccessComboBox.GetControlInterface 004c @VarFromDisp 0066 @DispInvoke 0074 @OleVarFromVar 0089 @VarClr 0091 @IntfClear 009a OleVariant 00a4 @FinalizeArray 00aa @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 DC 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8B 55 D8 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 14 8D 55 C8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C2 04 00 00 00 00 02 02 00 83 8C 43 6F 6C 75 6D 6E 00 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "TAccessListBox.Get_Column"
		size = 200
		refs = "0029 @VarAddRef 0031 TAccessListBox.Get_Column 0041 TAccessListBox.GetControlInterface 004c @VarFromDisp 0066 @DispInvoke 0074 @OleVarFromVar 0089 @VarClr 0091 @IntfClear 009a OleVariant 00a4 @FinalizeArray 00aa @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 57 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 DC 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 D8 8B C3 E8 ?? ?? ?? ?? 8B 55 D8 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 14 8D 55 C8 8B 45 08 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 C8 E8 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C2 04 00 00 00 00 02 02 00 83 8C 43 6F 6C 75 6D 6E 00 }
	condition:
		$1
}

rule function_132_0 {
	meta:
		name = "TAccessControl.Get_Selected"
		size = 100
		refs = "0015 TAccessControl.Get_Selected 002a TAccessControl.GetControlInterface 0038 @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 33 C9 89 4D F8 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 50 56 8D 55 F8 8B C3 E8 ?? ?? ?? ?? 8B 45 F8 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 8B 5D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_133_0 {
	meta:
		name = "TAccessControl.Set_Selected"
		size = 89
		refs = "0012 TAccessControl.Set_Selected 0024 TAccessControl.GetControlInterface 0032 @CheckAutoResult 0047 @IntfClear 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79382_0 {
	meta:
		name = "TShellWindows.OnNavigate"
		size = 89
		refs = "0012 TShellWindows.OnNavigate 0024 TShellWindows.GetDefaultInterface 0032 @CheckAutoResult 0047 @IntfClear 004d @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 34 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_134_0 {
	meta:
		name = "TAccessControl.Get_OldValue"
		size = 152
		refs = "001a TAccessControl.Get_OldValue 002a TAccessControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_409_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_OldValue"
		size = 152
		refs = "001a TAccessBoundObjectFrame.Get_OldValue 002a TAccessBoundObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_327_0 {
	meta:
		name = "TAccessCheckBox.Get_OldValue"
		size = 152
		refs = "001a TAccessCheckBox.Get_OldValue 002a TAccessCheckBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_2521_0 {
	meta:
		name = "TAccessComboBox.Get_OldValue"
		size = 152
		refs = "001a TAccessComboBox.Get_OldValue 002a TAccessComboBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_244_0 {
	meta:
		name = "TAccessCommandButton.Get_OldValue"
		size = 152
		refs = "001a TAccessCommandButton.Get_OldValue 002a TAccessCommandButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_2756_0 {
	meta:
		name = "TAccessCustomControl.Get_OldValue"
		size = 152
		refs = "001a TAccessCustomControl.Get_OldValue 002a TAccessCustomControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_2150_0 {
	meta:
		name = "TAccessImage.Get_OldValue"
		size = 152
		refs = "001a TAccessImage.Get_OldValue 002a TAccessImage.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "TAccessListBox.Get_OldValue"
		size = 152
		refs = "001a TAccessListBox.Get_OldValue 002a TAccessListBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_589_0 {
	meta:
		name = "TAccessObjectFrame.Get_OldValue"
		size = 152
		refs = "001a TAccessObjectFrame.Get_OldValue 002a TAccessObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_2235_0 {
	meta:
		name = "TAccessOptionButton.Get_OldValue"
		size = 152
		refs = "001a TAccessOptionButton.Get_OldValue 002a TAccessOptionButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_2324_0 {
	meta:
		name = "TAccessOptionGroup.Get_OldValue"
		size = 152
		refs = "001a TAccessOptionGroup.Get_OldValue 002a TAccessOptionGroup.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_672_0 {
	meta:
		name = "TAccessPaletteButton.Get_OldValue"
		size = 152
		refs = "001a TAccessPaletteButton.Get_OldValue 002a TAccessPaletteButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_796_0 {
	meta:
		name = "TAccessTabControl.Get_OldValue"
		size = 152
		refs = "001a TAccessTabControl.Get_OldValue 002a TAccessTabControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "TAccessTextBox.Get_OldValue"
		size = 152
		refs = "001a TAccessTextBox.Get_OldValue 002a TAccessTextBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_642_0 {
	meta:
		name = "TAccessToggleButton.Get_OldValue"
		size = 152
		refs = "001a TAccessToggleButton.Get_OldValue 002a TAccessToggleButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 6C 64 56 61 6C 75 65 00 }
	condition:
		$1
}

rule function_135_0 {
	meta:
		name = "TAccessControl.Get_Form"
		size = 91
		refs = "000f TAccessControl.Get_Form 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1445_0 {
	meta:
		name = "TAccessApplication.Get_CurrentObjectName"
		size = 91
		refs = "000f TAccessApplication.Get_CurrentObjectName 001c @WStrClr 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_212_0 {
	meta:
		name = "TAccessImage.Get_Controls"
		size = 91
		refs = "000f TAccessImage.Get_Controls 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_674_0 {
	meta:
		name = "TAccessPaletteButton.Get_Controls"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Controls 001c @IntfClear 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4577_0 {
	meta:
		name = "TAccessReport.Get_OrderBy"
		size = 91
		refs = "000f TAccessReport.Get_OrderBy 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1974_0 {
	meta:
		name = "TAccessWebOptions.Get_LocationOfComponents"
		size = 91
		refs = "000f TAccessWebOptions.Get_LocationOfComponents 001c @WStrClr 0027 TAccessWebOptions.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70265_0 {
	meta:
		name = "TAppointmentItem.Get_Body"
		size = 91
		refs = "000f TAppointmentItem.Get_Body 001c @WStrClr 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_11458_0 {
	meta:
		name = "TCOMAdminCatalogCollection.Get_Name"
		size = 91
		refs = "000f TCOMAdminCatalogCollection.Get_Name 001c @VarClr 0027 TCOMAdminCatalogCollection.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70645_0 {
	meta:
		name = "TContactItem.Get_Body"
		size = 91
		refs = "000f TContactItem.Get_Body 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70922_0 {
	meta:
		name = "TDistListItem.Get_Body"
		size = 91
		refs = "000f TDistListItem.Get_Body 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70995_0 {
	meta:
		name = "TDocumentItem.Get_Body"
		size = 91
		refs = "000f TDocumentItem.Get_Body 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71092_0 {
	meta:
		name = "TFolders.GetFirst"
		size = 91
		refs = "000f TFolders.GetFirst 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79286_0 {
	meta:
		name = "TInternetExplorer.Get_Application"
		size = 91
		refs = "000f TInternetExplorer.Get_Application 001c @IntfClear 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73004_0 {
	meta:
		name = "TJournalItem.Get_Body"
		size = 91
		refs = "000f TJournalItem.Get_Body 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70136_0 {
	meta:
		name = "TMailItem.Get_Body"
		size = 91
		refs = "000f TMailItem.Get_Body 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72199_0 {
	meta:
		name = "TMeetingItem.Get_Body"
		size = 91
		refs = "000f TMeetingItem.Get_Body 001c @WStrClr 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70619_0 {
	meta:
		name = "TOutlookApplication.ActiveInspector"
		size = 91
		refs = "000f TOutlookApplication.ActiveInspector 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73247_0 {
	meta:
		name = "TPostItem.Get_Body"
		size = 91
		refs = "000f TPostItem.Get_Body 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74457_0 {
	meta:
		name = "TPowerPointApplication.Get_Name"
		size = 91
		refs = "000f TPowerPointApplication.Get_Name 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74258_0 {
	meta:
		name = "TPowerPointGlobal.Get_Windows"
		size = 91
		refs = "000f TPowerPointGlobal.Get_Windows 001c @IntfClear 0027 TPowerPointGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67262_0 {
	meta:
		name = "TPowerPointPresentation.Get_NotesMaster"
		size = 91
		refs = "000f TPowerPointPresentation.Get_NotesMaster 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67223_0 {
	meta:
		name = "TPowerPointSlide.Get_Name"
		size = 91
		refs = "000f TPowerPointSlide.Get_Name 001c @WStrClr 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73796_0 {
	meta:
		name = "TReminder.Get_Item"
		size = 91
		refs = "000f TReminder.Get_Item 001c @IntfClear 0027 TReminder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73331_0 {
	meta:
		name = "TRemoteItem.Get_Body"
		size = 91
		refs = "000f TRemoteItem.Get_Body 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73403_0 {
	meta:
		name = "TReportItem.Get_Body"
		size = 91
		refs = "000f TReportItem.Get_Body 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3256_0 {
	meta:
		name = "TReportOld.Get_OrderBy"
		size = 91
		refs = "000f TReportOld.Get_OrderBy 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73755_0 {
	meta:
		name = "TResults.GetLast"
		size = 91
		refs = "000f TResults.GetLast 001c @IntfClear 0027 TResults.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72302_0 {
	meta:
		name = "TTaskItem.Get_Body"
		size = 91
		refs = "000f TTaskItem.Get_Body 001c @WStrClr 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73471_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Body"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Body 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71640_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Body"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Body 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73609_0 {
	meta:
		name = "TTaskRequestItem.Get_Body"
		size = 91
		refs = "000f TTaskRequestItem.Get_Body 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73678_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Body"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Body 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73780_0 {
	meta:
		name = "TViews._NewEnum"
		size = 91
		refs = "000f TViews._NewEnum 001c @IntfClear 0027 TViews.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79243_0 {
	meta:
		name = "TWebBrowser.Get_Application"
		size = 91
		refs = "000f TWebBrowser.Get_Application 001c @IntfClear 0027 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79222_0 {
	meta:
		name = "TWebBrowser_V1.Get_Application"
		size = 91
		refs = "000f TWebBrowser_V1.Get_Application 001c @IntfClear 0027 TWebBrowser_V1.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99580_0 {
	meta:
		name = "TWordApplication.Get_Selection"
		size = 91
		refs = "000f TWordApplication.Get_Selection 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98940_0 {
	meta:
		name = "TWordDocument.Get_Tables"
		size = 91
		refs = "000f TWordDocument.Get_Tables 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98822_0 {
	meta:
		name = "TWordGlobal.Get_Selection"
		size = 91
		refs = "000f TWordGlobal.Get_Selection 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99504_0 {
	meta:
		name = "TWordLetterContent.Get_PageDesign"
		size = 91
		refs = "000f TWordLetterContent.Get_PageDesign 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99477_0 {
	meta:
		name = "TWordOLEControl.Get_Name"
		size = 91
		refs = "000f TWordOLEControl.Get_Name 001c @WStrClr 0027 TWordOLEControl.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_136_0 {
	meta:
		name = "TAccessControl.Get_Report"
		size = 91
		refs = "000f TAccessControl.Get_Report 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3687_0 {
	meta:
		name = "TDataAccessPage.Get_Application"
		size = 91
		refs = "000f TDataAccessPage.Get_Application 001c @IntfClear 0027 TDataAccessPage.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46113_0 {
	meta:
		name = "TExcelApplication.Get_ActiveSheet"
		size = 91
		refs = "000f TExcelApplication.Get_ActiveSheet 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47270_0 {
	meta:
		name = "TExcelGlobal.Get_ActiveSheet"
		size = 91
		refs = "000f TExcelGlobal.Get_ActiveSheet 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70058_0 {
	meta:
		name = "TExplorer.Get_Caption"
		size = 91
		refs = "000f TExplorer.Get_Caption 001c @WStrClr 0027 TExplorer.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71093_0 {
	meta:
		name = "TFolders.GetLast"
		size = 91
		refs = "000f TFolders.GetLast 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79287_0 {
	meta:
		name = "TInternetExplorer.Get_Parent"
		size = 91
		refs = "000f TInternetExplorer.Get_Parent 001c @IntfClear 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67367_0 {
	meta:
		name = "TPowerPointApplication.Get_Caption"
		size = 91
		refs = "000f TPowerPointApplication.Get_Caption 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67203_0 {
	meta:
		name = "TPowerPointGlobal.Get_CommandBars"
		size = 91
		refs = "000f TPowerPointGlobal.Get_CommandBars 001c @IntfClear 0027 TPowerPointGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67263_0 {
	meta:
		name = "TPowerPointPresentation.Get_HandoutMaster"
		size = 91
		refs = "000f TPowerPointPresentation.Get_HandoutMaster 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73756_0 {
	meta:
		name = "TResults.GetNext"
		size = 91
		refs = "000f TResults.GetNext 001c @IntfClear 0027 TResults.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79244_0 {
	meta:
		name = "TWebBrowser.Get_Parent"
		size = 91
		refs = "000f TWebBrowser.Get_Parent 001c @IntfClear 0027 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79223_0 {
	meta:
		name = "TWebBrowser_V1.Get_Parent"
		size = 91
		refs = "000f TWebBrowser_V1.Get_Parent 001c @IntfClear 0027 TWebBrowser_V1.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99581_0 {
	meta:
		name = "TWordApplication.Get_WordBasic"
		size = 91
		refs = "000f TWordApplication.Get_WordBasic 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98941_0 {
	meta:
		name = "TWordDocument.Get_Footnotes"
		size = 91
		refs = "000f TWordDocument.Get_Footnotes 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98823_0 {
	meta:
		name = "TWordGlobal.Get_WordBasic"
		size = 91
		refs = "000f TWordGlobal.Get_WordBasic 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_137_0 {
	meta:
		name = "TAccessControl.Get_ItemData"
		size = 168
		refs = "0021 TAccessControl.Get_ItemData 0031 TAccessControl.GetControlInterface 003c @VarFromDisp 0052 @DispInvoke 005f @OleVarFromVar 0074 @VarClr 007c @IntfClear 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 8B F1 89 55 EC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 E8 8B C3 E8 ?? ?? ?? ?? 8B 55 E8 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 EC 50 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 D8 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 02 01 00 83 49 74 65 6D 44 61 74 61 00 00 00 00 }
	condition:
		$1
}

rule function_545_0 {
	meta:
		name = "TAccessComboBox.Get_ItemData"
		size = 168
		refs = "0021 TAccessComboBox.Get_ItemData 0031 TAccessComboBox.GetControlInterface 003c @VarFromDisp 0052 @DispInvoke 005f @OleVarFromVar 0074 @VarClr 007c @IntfClear 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 8B F1 89 55 EC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 E8 8B C3 E8 ?? ?? ?? ?? 8B 55 E8 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 EC 50 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 D8 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 02 01 00 83 49 74 65 6D 44 61 74 61 00 00 00 00 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "TAccessListBox.Get_ItemData"
		size = 168
		refs = "0021 TAccessListBox.Get_ItemData 0031 TAccessListBox.GetControlInterface 003c @VarFromDisp 0052 @DispInvoke 005f @OleVarFromVar 0074 @VarClr 007c @IntfClear 008a @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 87 4D FC 53 56 8B F1 89 55 EC 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 E8 8B C3 E8 ?? ?? ?? ?? 8B 55 E8 8D 45 F0 E8 ?? ?? ?? ?? 8D 45 EC 50 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 D8 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 D8 E8 ?? ?? ?? ?? 8D 45 E8 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 00 02 01 00 83 49 74 65 6D 44 61 74 61 00 00 00 00 }
	condition:
		$1
}

rule function_138_0 {
	meta:
		name = "TAccessControl.Get_Object_"
		size = 91
		refs = "000f TAccessControl.Get_Object_ 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_11468_0 {
	meta:
		name = "TCOMAdminCatalogCollection.GetUtilInterface"
		size = 91
		refs = "000f TCOMAdminCatalogCollection.GetUtilInterface 001c @IntfClear 0027 TCOMAdminCatalogCollection.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1851_0 {
	meta:
		name = "TCodeProject.Get_Path"
		size = 91
		refs = "000f TCodeProject.Get_Path 001c @WStrClr 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1808_0 {
	meta:
		name = "TCurrentProject.Get_Path"
		size = 91
		refs = "000f TCurrentProject.Get_Path 001c @WStrClr 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3689_0 {
	meta:
		name = "TDataAccessPage.Get_Document"
		size = 91
		refs = "000f TDataAccessPage.Get_Document 001c @IntfClear 0027 TDataAccessPage.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46115_0 {
	meta:
		name = "TExcelApplication.Get_ActiveWorkbook"
		size = 91
		refs = "000f TExcelApplication.Get_ActiveWorkbook 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46692_0 {
	meta:
		name = "TExcelChart.Get_Name"
		size = 91
		refs = "000f TExcelChart.Get_Name 001c @WStrClr 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47272_0 {
	meta:
		name = "TExcelGlobal.Get_ActiveWorkbook"
		size = 91
		refs = "000f TExcelGlobal.Get_ActiveWorkbook 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_48969_0 {
	meta:
		name = "TExcelWorksheet.Get_Name"
		size = 91
		refs = "000f TExcelWorksheet.Get_Name 001c @WStrClr 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71095_0 {
	meta:
		name = "TFolders.GetPrevious"
		size = 91
		refs = "000f TFolders.GetPrevious 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79289_0 {
	meta:
		name = "TInternetExplorer.Get_Document"
		size = 91
		refs = "000f TInternetExplorer.Get_Document 001c @IntfClear 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71119_0 {
	meta:
		name = "TItems.FindNext"
		size = 91
		refs = "000f TItems.FindNext 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71273_0 {
	meta:
		name = "TNoteItem.Get_EntryID"
		size = 91
		refs = "000f TNoteItem.Get_EntryID 001c @WStrClr 0027 TNoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67344_0 {
	meta:
		name = "TOLECtrl.Get_Name"
		size = 91
		refs = "000f TOLECtrl.Get_Name 001c @WStrClr 0027 TOLECtrl.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67369_0 {
	meta:
		name = "TPowerPointApplication.Get_Assistant"
		size = 91
		refs = "000f TPowerPointApplication.Get_Assistant 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74327_0 {
	meta:
		name = "TPowerPointPresentation.Get_PageSetup"
		size = 91
		refs = "000f TPowerPointPresentation.Get_PageSetup 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79246_0 {
	meta:
		name = "TWebBrowser.Get_Document"
		size = 91
		refs = "000f TWebBrowser.Get_Document 001c @IntfClear 0027 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79225_0 {
	meta:
		name = "TWebBrowser_V1.Get_Document"
		size = 91
		refs = "000f TWebBrowser_V1.Get_Document 001c @IntfClear 0027 TWebBrowser_V1.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99583_0 {
	meta:
		name = "TWordApplication.Get_NormalTemplate"
		size = 91
		refs = "000f TWordApplication.Get_NormalTemplate 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98943_0 {
	meta:
		name = "TWordDocument.Get_Comments"
		size = 91
		refs = "000f TWordDocument.Get_Comments 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 48 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_139_0 {
	meta:
		name = "TAccessControl.Get_ObjectVerbs"
		size = 96
		refs = "0012 TAccessControl.Get_ObjectVerbs 001f @WStrClr 002b TAccessControl.GetControlInterface 0039 @CheckAutoResult 004e @IntfClear 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71241_0 {
	meta:
		name = "TNameSpace.GetRecipientFromID"
		size = 96
		refs = "0012 TNameSpace.GetRecipientFromID 001f @IntfClear 002b TNameSpace.GetDefaultInterface 0039 @CheckAutoResult 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70624_0 {
	meta:
		name = "TOutlookApplication.GetNamespace"
		size = 96
		refs = "0012 TOutlookApplication.GetNamespace 001f @IntfClear 002b TOutlookApplication.GetDefaultInterface 0039 @CheckAutoResult 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 4C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_140_0 {
	meta:
		name = "TAccessControl.Get_Properties"
		size = 91
		refs = "000f TAccessControl.Get_Properties 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1853_0 {
	meta:
		name = "TCodeProject.Get_Connection"
		size = 91
		refs = "000f TCodeProject.Get_Connection 001c @IntfClear 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1810_0 {
	meta:
		name = "TCurrentProject.Get_Connection"
		size = 91
		refs = "000f TCurrentProject.Get_Connection 001c @IntfClear 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3690_0 {
	meta:
		name = "TDataAccessPage.Get_WebOptions"
		size = 91
		refs = "000f TDataAccessPage.Get_WebOptions 001c @IntfClear 0027 TDataAccessPage.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46117_0 {
	meta:
		name = "TExcelApplication.Get_Assistant"
		size = 91
		refs = "000f TExcelApplication.Get_Assistant 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46694_0 {
	meta:
		name = "TExcelChart.Get_Next"
		size = 91
		refs = "000f TExcelChart.Get_Next 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47274_0 {
	meta:
		name = "TExcelGlobal.Get_Assistant"
		size = 91
		refs = "000f TExcelGlobal.Get_Assistant 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_48971_0 {
	meta:
		name = "TExcelWorksheet.Get_Next"
		size = 91
		refs = "000f TExcelWorksheet.Get_Next 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79291_0 {
	meta:
		name = "TInternetExplorer.Get_type_"
		size = 91
		refs = "000f TInternetExplorer.Get_type_ 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71121_0 {
	meta:
		name = "TItems.GetLast"
		size = 91
		refs = "000f TItems.GetLast 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67432_0 {
	meta:
		name = "TMaster.Get_Hyperlinks"
		size = 91
		refs = "000f TMaster.Get_Hyperlinks 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67346_0 {
	meta:
		name = "TOLECtrl.Get_AltHTML"
		size = 91
		refs = "000f TOLECtrl.Get_AltHTML 001c @WStrClr 0027 TOLECtrl.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67371_0 {
	meta:
		name = "TPowerPointApplication.Get_FileFind"
		size = 91
		refs = "000f TPowerPointApplication.Get_FileFind 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67267_0 {
	meta:
		name = "TPowerPointPresentation.Get_ExtraColors"
		size = 91
		refs = "000f TPowerPointPresentation.Get_ExtraColors 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99585_0 {
	meta:
		name = "TWordApplication.Get_AutoCorrect"
		size = 91
		refs = "000f TWordApplication.Get_AutoCorrect 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98827_0 {
	meta:
		name = "TWordGlobal.Get_NormalTemplate"
		size = 91
		refs = "000f TWordGlobal.Get_NormalTemplate 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_141_0 {
	meta:
		name = "TAccessControl.Get_ItemsSelected"
		size = 91
		refs = "000f TAccessControl.Get_ItemsSelected 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3467_0 {
	meta:
		name = "TAccessApplication.Get_DoCmd"
		size = 91
		refs = "000f TAccessApplication.Get_DoCmd 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72074_0 {
	meta:
		name = "TAppointmentItem.Get_EntryID"
		size = 91
		refs = "000f TAppointmentItem.Get_EntryID 001c @WStrClr 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72484_0 {
	meta:
		name = "TContactItem.Get_EntryID"
		size = 91
		refs = "000f TContactItem.Get_EntryID 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3694_0 {
	meta:
		name = "TDataAccessPage.Get_MailEnvelope"
		size = 91
		refs = "000f TDataAccessPage.Get_MailEnvelope 001c @IntfClear 0027 TDataAccessPage.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72773_0 {
	meta:
		name = "TDistListItem.Get_EntryID"
		size = 91
		refs = "000f TDistListItem.Get_EntryID 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72854_0 {
	meta:
		name = "TDocumentItem.Get_EntryID"
		size = 91
		refs = "000f TDocumentItem.Get_EntryID 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46120_0 {
	meta:
		name = "TExcelApplication.Get_Columns"
		size = 91
		refs = "000f TExcelApplication.Get_Columns 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47277_0 {
	meta:
		name = "TExcelGlobal.Get_Columns"
		size = 91
		refs = "000f TExcelGlobal.Get_Columns 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70066_0 {
	meta:
		name = "TExplorer.Get_Selection"
		size = 91
		refs = "000f TExplorer.Get_Selection 001c @IntfClear 0027 TExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73013_0 {
	meta:
		name = "TJournalItem.Get_EntryID"
		size = 91
		refs = "000f TJournalItem.Get_EntryID 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71935_0 {
	meta:
		name = "TMailItem.Get_EntryID"
		size = 91
		refs = "000f TMailItem.Get_EntryID 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74540_0 {
	meta:
		name = "TMaster.Get_SlideShowTransition"
		size = 91
		refs = "000f TMaster.Get_SlideShowTransition 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72208_0 {
	meta:
		name = "TMeetingItem.Get_EntryID"
		size = 91
		refs = "000f TMeetingItem.Get_EntryID 001c @WStrClr 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72435_0 {
	meta:
		name = "TOutlookApplication.Get_LanguageSettings"
		size = 91
		refs = "000f TOutlookApplication.Get_LanguageSettings 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71385_0 {
	meta:
		name = "TPostItem.Get_EntryID"
		size = 91
		refs = "000f TPostItem.Get_EntryID 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74466_0 {
	meta:
		name = "TPowerPointApplication.Get_ActivePrinter"
		size = 91
		refs = "000f TPowerPointApplication.Get_ActivePrinter 001c @WStrClr 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74333_0 {
	meta:
		name = "TPowerPointPresentation.Get_Tags"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Tags 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74303_0 {
	meta:
		name = "TPowerPointSlide.Duplicate"
		size = 91
		refs = "000f TPowerPointSlide.Duplicate 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71458_0 {
	meta:
		name = "TRemoteItem.Get_EntryID"
		size = 91
		refs = "000f TRemoteItem.Get_EntryID 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71524_0 {
	meta:
		name = "TReportItem.Get_EntryID"
		size = 91
		refs = "000f TReportItem.Get_EntryID 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72311_0 {
	meta:
		name = "TTaskItem.Get_EntryID"
		size = 91
		refs = "000f TTaskItem.Get_EntryID 001c @WStrClr 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71586_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_EntryID"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_EntryID 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71649_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_EntryID"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_EntryID 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73618_0 {
	meta:
		name = "TTaskRequestItem.Get_EntryID"
		size = 91
		refs = "000f TTaskRequestItem.Get_EntryID 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71775_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_EntryID"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_EntryID 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99589_0 {
	meta:
		name = "TWordApplication.Get_Languages"
		size = 91
		refs = "000f TWordApplication.Get_Languages 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98831_0 {
	meta:
		name = "TWordGlobal.Get_LandscapeFontNames"
		size = 91
		refs = "000f TWordGlobal.Get_LandscapeFontNames 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_142_0 {
	meta:
		name = "TAccessControl.Get_Pages"
		size = 91
		refs = "000f TAccessControl.Get_Pages 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3905_0 {
	meta:
		name = "TCodeProject.Get_AccessConnection"
		size = 91
		refs = "000f TCodeProject.Get_AccessConnection 001c @IntfClear 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3857_0 {
	meta:
		name = "TCurrentProject.Get_AccessConnection"
		size = 91
		refs = "000f TCurrentProject.Get_AccessConnection 001c @IntfClear 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46701_0 {
	meta:
		name = "TExcelChart.Get_PageSetup"
		size = 91
		refs = "000f TExcelChart.Get_PageSetup 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47005_0 {
	meta:
		name = "TExcelWorksheet.Get_PageSetup"
		size = 91
		refs = "000f TExcelWorksheet.Get_PageSetup 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67378_0 {
	meta:
		name = "TPowerPointApplication.Get_VBE"
		size = 91
		refs = "000f TPowerPointApplication.Get_VBE 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67274_0 {
	meta:
		name = "TPowerPointPresentation.Get_CustomDocumentProperties"
		size = 91
		refs = "000f TPowerPointPresentation.Get_CustomDocumentProperties 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99592_0 {
	meta:
		name = "TWordApplication.Get_FileConverters"
		size = 91
		refs = "000f TWordApplication.Get_FileConverters 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98834_0 {
	meta:
		name = "TWordGlobal.Get_Assistant"
		size = 91
		refs = "000f TWordGlobal.Get_Assistant 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99516_0 {
	meta:
		name = "TWordLetterContent.Get_RecipientAddress"
		size = 91
		refs = "000f TWordLetterContent.Get_RecipientAddress 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 6C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_143_0 {
	meta:
		name = "TAccessControl.Get_Controls"
		size = 91
		refs = "000f TAccessControl.Get_Controls 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Application"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_Application 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_325_0 {
	meta:
		name = "TAccessCheckBox.Get_Application"
		size = 91
		refs = "000f TAccessCheckBox.Get_Application 001c @IntfClear 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2518_0 {
	meta:
		name = "TAccessComboBox.Get_Application"
		size = 91
		refs = "000f TAccessComboBox.Get_Application 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_242_0 {
	meta:
		name = "TAccessCommandButton.Get_Application"
		size = 91
		refs = "000f TAccessCommandButton.Get_Application 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2754_0 {
	meta:
		name = "TAccessCustomControl.Get_Application"
		size = 91
		refs = "000f TAccessCustomControl.Get_Application 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4134_0 {
	meta:
		name = "TAccessForm.Get_FormName"
		size = 91
		refs = "000f TAccessForm.Get_FormName 001c @WStrClr 0027 TAccessForm.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_171_0 {
	meta:
		name = "TAccessLabel.Get_Application"
		size = 91
		refs = "000f TAccessLabel.Get_Application 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2462_0 {
	meta:
		name = "TAccessListBox.Get_Application"
		size = 91
		refs = "000f TAccessListBox.Get_Application 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_587_0 {
	meta:
		name = "TAccessObjectFrame.Get_Application"
		size = 91
		refs = "000f TAccessObjectFrame.Get_Application 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_285_0 {
	meta:
		name = "TAccessOptionButton.Get_Application"
		size = 91
		refs = "000f TAccessOptionButton.Get_Application 001c @IntfClear 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2322_0 {
	meta:
		name = "TAccessOptionGroup.Get_Application"
		size = 91
		refs = "000f TAccessOptionGroup.Get_Application 001c @IntfClear 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_831_0 {
	meta:
		name = "TAccessPage.Get_Application"
		size = 91
		refs = "000f TAccessPage.Get_Application 001c @IntfClear 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_701_0 {
	meta:
		name = "TAccessSubForm.Get_Application"
		size = 91
		refs = "000f TAccessSubForm.Get_Application 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_794_0 {
	meta:
		name = "TAccessTabControl.Get_Application"
		size = 91
		refs = "000f TAccessTabControl.Get_Application 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_451_0 {
	meta:
		name = "TAccessTextBox.Get_Application"
		size = 91
		refs = "000f TAccessTextBox.Get_Application 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2634_0 {
	meta:
		name = "TAccessToggleButton.Get_Application"
		size = 91
		refs = "000f TAccessToggleButton.Get_Application 001c @IntfClear 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46702_0 {
	meta:
		name = "TExcelChart.Get_Previous"
		size = 91
		refs = "000f TExcelChart.Get_Previous 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47470_0 {
	meta:
		name = "TExcelWorkbook.Get_CodeName"
		size = 91
		refs = "000f TExcelWorkbook.Get_CodeName 001c @WStrClr 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47006_0 {
	meta:
		name = "TExcelWorksheet.Get_Previous"
		size = 91
		refs = "000f TExcelWorksheet.Get_Previous 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2910_0 {
	meta:
		name = "TFormOld.Get_FormName"
		size = 91
		refs = "000f TFormOld.Get_FormName 001c @WStrClr 0027 TFormOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67275_0 {
	meta:
		name = "TPowerPointPresentation.Get_VBProject"
		size = 91
		refs = "000f TPowerPointPresentation.Get_VBProject 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99593_0 {
	meta:
		name = "TWordApplication.Get_MailingLabel"
		size = 91
		refs = "000f TWordApplication.Get_MailingLabel 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98953_0 {
	meta:
		name = "TWordDocument.Get_Sections"
		size = 91
		refs = "000f TWordDocument.Get_Sections 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98835_0 {
	meta:
		name = "TWordGlobal.Get_FileConverters"
		size = 91
		refs = "000f TWordGlobal.Get_FileConverters 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 70 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_144_0 {
	meta:
		name = "TAccessControl.Get_Hyperlink"
		size = 91
		refs = "000f TAccessControl.Get_Hyperlink 001c @IntfClear 0027 TAccessControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Parent"
		size = 91
		refs = "000f TAccessBoundObjectFrame.Get_Parent 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_326_0 {
	meta:
		name = "TAccessCheckBox.Get_Parent"
		size = 91
		refs = "000f TAccessCheckBox.Get_Parent 001c @IntfClear 0027 TAccessCheckBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2519_0 {
	meta:
		name = "TAccessComboBox.Get_Parent"
		size = 91
		refs = "000f TAccessComboBox.Get_Parent 001c @IntfClear 0027 TAccessComboBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_243_0 {
	meta:
		name = "TAccessCommandButton.Get_Parent"
		size = 91
		refs = "000f TAccessCommandButton.Get_Parent 001c @IntfClear 0027 TAccessCommandButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2755_0 {
	meta:
		name = "TAccessCustomControl.Get_Parent"
		size = 91
		refs = "000f TAccessCustomControl.Get_Parent 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_172_0 {
	meta:
		name = "TAccessLabel.Get_Parent"
		size = 91
		refs = "000f TAccessLabel.Get_Parent 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2463_0 {
	meta:
		name = "TAccessListBox.Get_Parent"
		size = 91
		refs = "000f TAccessListBox.Get_Parent 001c @IntfClear 0027 TAccessListBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2574_0 {
	meta:
		name = "TAccessObjectFrame.Get_Parent"
		size = 91
		refs = "000f TAccessObjectFrame.Get_Parent 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_286_0 {
	meta:
		name = "TAccessOptionButton.Get_Parent"
		size = 91
		refs = "000f TAccessOptionButton.Get_Parent 001c @IntfClear 0027 TAccessOptionButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "TAccessOptionGroup.Get_Parent"
		size = 91
		refs = "000f TAccessOptionGroup.Get_Parent 001c @IntfClear 0027 TAccessOptionGroup.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_832_0 {
	meta:
		name = "TAccessPage.Get_Parent"
		size = 91
		refs = "000f TAccessPage.Get_Parent 001c @IntfClear 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_702_0 {
	meta:
		name = "TAccessSubForm.Get_Parent"
		size = 91
		refs = "000f TAccessSubForm.Get_Parent 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2805_0 {
	meta:
		name = "TAccessTabControl.Get_Parent"
		size = 91
		refs = "000f TAccessTabControl.Get_Parent 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "TAccessTextBox.Get_Parent"
		size = 91
		refs = "000f TAccessTextBox.Get_Parent 001c @IntfClear 0027 TAccessTextBox.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_641_0 {
	meta:
		name = "TAccessToggleButton.Get_Parent"
		size = 91
		refs = "000f TAccessToggleButton.Get_Parent 001c @IntfClear 0027 TAccessToggleButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1956_0 {
	meta:
		name = "TDefaultWebOptions.Get_FolderSuffix"
		size = 91
		refs = "000f TDefaultWebOptions.Get_FolderSuffix 001c @WStrClr 0027 TDefaultWebOptions.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47471_0 {
	meta:
		name = "TExcelWorkbook.Get__CodeName"
		size = 91
		refs = "000f TExcelWorkbook.Get__CodeName 001c @WStrClr 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79300_0 {
	meta:
		name = "TInternetExplorer.Get_LocationName"
		size = 91
		refs = "000f TInternetExplorer.Get_LocationName 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71284_0 {
	meta:
		name = "TNoteItem.Get_Subject"
		size = 91
		refs = "000f TNoteItem.Get_Subject 001c @WStrClr 0027 TNoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70626_0 {
	meta:
		name = "TOutlookApplication.ActiveWindow"
		size = 91
		refs = "000f TOutlookApplication.ActiveWindow 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99594_0 {
	meta:
		name = "TWordApplication.Get_Dialogs"
		size = 91
		refs = "000f TWordApplication.Get_Dialogs 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98954_0 {
	meta:
		name = "TWordDocument.Get_Paragraphs"
		size = 91
		refs = "000f TWordDocument.Get_Paragraphs 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98836_0 {
	meta:
		name = "TWordGlobal.Get_Dialogs"
		size = 91
		refs = "000f TWordGlobal.Get_Dialogs 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99518_0 {
	meta:
		name = "TWordLetterContent.Get_Salutation"
		size = 91
		refs = "000f TWordLetterContent.Get_Salutation 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_145_0 {
	meta:
		name = "TAccessControl.Undo"
		size = 79
		refs = "000c TAccessControl.Undo 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79336_0 {
	meta:
		name = "TInternetExplorer.GoHome"
		size = 79
		refs = "000c TInternetExplorer.GoHome 001c TInternetExplorer.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79447_0 {
	meta:
		name = "TShellNameSpace.ResetSort"
		size = 79
		refs = "000c TShellNameSpace.ResetSort 001c TShellNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79398_0 {
	meta:
		name = "TShellUIHelper.RefreshOfflineDesktop"
		size = 79
		refs = "000c TShellUIHelper.RefreshOfflineDesktop 001c TShellUIHelper.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79249_0 {
	meta:
		name = "TWebBrowser.GoHome"
		size = 79
		refs = "000c TWebBrowser.GoHome 001c TWebBrowser.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79228_0 {
	meta:
		name = "TWebBrowser_V1.GoHome"
		size = 79
		refs = "000c TWebBrowser_V1.GoHome 001c TWebBrowser_V1.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_146_0 {
	meta:
		name = "TAccessControl.Dropdown"
		size = 79
		refs = "000c TAccessControl.Dropdown 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_202_0 {
	meta:
		name = "TAccessLine.SizeToFit"
		size = 79
		refs = "000c TAccessLine.SizeToFit 001c TAccessLine.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_619_0 {
	meta:
		name = "TAccessPageBreak.SizeToFit"
		size = 79
		refs = "000c TAccessPageBreak.SizeToFit 001c TAccessPageBreak.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_193_0 {
	meta:
		name = "TAccessRectangle.SizeToFit"
		size = 79
		refs = "000c TAccessRectangle.SizeToFit 001c TAccessRectangle.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79337_0 {
	meta:
		name = "TInternetExplorer.GoSearch"
		size = 79
		refs = "000c TInternetExplorer.GoSearch 001c TInternetExplorer.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79448_0 {
	meta:
		name = "TShellNameSpace.NewFolder"
		size = 79
		refs = "000c TShellNameSpace.NewFolder 001c TShellNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79250_0 {
	meta:
		name = "TWebBrowser.GoSearch"
		size = 79
		refs = "000c TWebBrowser.GoSearch 001c TWebBrowser.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_79229_0 {
	meta:
		name = "TWebBrowser_V1.GoSearch"
		size = 79
		refs = "000c TWebBrowser_V1.GoSearch 001c TWebBrowser_V1.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_147_0 {
	meta:
		name = "TAccessControl.Requery"
		size = 79
		refs = "000c TAccessControl.Requery 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_71243_0 {
	meta:
		name = "TNameSpace.Logoff"
		size = 79
		refs = "000c TNameSpace.Logoff 001c TNameSpace.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_67242_0 {
	meta:
		name = "TPowerPointSlide.Copy"
		size = 79
		refs = "000c TPowerPointSlide.Copy 001c TPowerPointSlide.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_99485_0 {
	meta:
		name = "TWordOLEControl.Delete"
		size = 79
		refs = "000c TWordOLEControl.Delete 001c TWordOLEControl.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_148_0 {
	meta:
		name = "TAccessControl.SizeToFit"
		size = 79
		refs = "000c TAccessControl.SizeToFit 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_99486_0 {
	meta:
		name = "TWordOLEControl.Activate"
		size = 79
		refs = "000c TWordOLEControl.Activate 001c TWordOLEControl.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_149_0 {
	meta:
		name = "TAccessControl.Goto_"
		size = 79
		refs = "000c TAccessControl.Goto_ 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_150_0 {
	meta:
		name = "TAccessControl.SetFocus"
		size = 79
		refs = "000c TAccessControl.SetFocus 001c TAccessControl.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_67244_0 {
	meta:
		name = "TPowerPointSlide.Delete"
		size = 79
		refs = "000c TPowerPointSlide.Delete 001c TPowerPointSlide.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_151_0 {
	meta:
		name = "TAccessControl._Evaluate"
		size = 100
		refs = "0012 TAccessControl._Evaluate 0020 @VarClr 002d TAccessControl.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 68 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_153_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 F0 02 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 48 E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_157_0 {
	meta:
		name = "TAccessLabel.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accChild 0034 @IntfClear 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accChild 0034 @IntfClear 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_311_0 {
	meta:
		name = "TAccessCheckBox.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accChild 0034 @IntfClear 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2504_0 {
	meta:
		name = "TAccessComboBox.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accChild 0034 @IntfClear 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_228_0 {
	meta:
		name = "TAccessCommandButton.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accChild 0034 @IntfClear 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_734_0 {
	meta:
		name = "TAccessCustomControl.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accChild 0034 @IntfClear 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_878_0 {
	meta:
		name = "TAccessForm.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accChild 0034 @IntfClear 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "TAccessListBox.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accChild 0034 @IntfClear 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_573_0 {
	meta:
		name = "TAccessObjectFrame.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accChild 0034 @IntfClear 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2219_0 {
	meta:
		name = "TAccessOptionButton.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accChild 0034 @IntfClear 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_352_0 {
	meta:
		name = "TAccessOptionGroup.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accChild 0034 @IntfClear 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2831_0 {
	meta:
		name = "TAccessPage.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accChild 0034 @IntfClear 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2689_0 {
	meta:
		name = "TAccessSubForm.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accChild 0034 @IntfClear 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2790_0 {
	meta:
		name = "TAccessTabControl.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accChild 0034 @IntfClear 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "TAccessTextBox.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accChild 0034 @IntfClear 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2620_0 {
	meta:
		name = "TAccessToggleButton.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accChild 0034 @IntfClear 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1723_0 {
	meta:
		name = "TAllDataAccessPages.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllDataAccessPages.Get_Item 0034 @IntfClear 004b TAllDataAccessPages.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_3828_0 {
	meta:
		name = "TAllDatabaseDiagrams.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllDatabaseDiagrams.Get_Item 0034 @IntfClear 004b TAllDatabaseDiagrams.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1671_0 {
	meta:
		name = "TAllForms.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllForms.Get_Item 0034 @IntfClear 004b TAllForms.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4820_0 {
	meta:
		name = "TAllFunctions.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllFunctions.Get_Item 0034 @IntfClear 004b TAllFunctions.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_3737_0 {
	meta:
		name = "TAllMacros.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllMacros.Get_Item 0034 @IntfClear 004b TAllMacros.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_3750_0 {
	meta:
		name = "TAllModules.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllModules.Get_Item 0034 @IntfClear 004b TAllModules.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1749_0 {
	meta:
		name = "TAllQueries.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllQueries.Get_Item 0034 @IntfClear 004b TAllQueries.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_3724_0 {
	meta:
		name = "TAllReports.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllReports.Get_Item 0034 @IntfClear 004b TAllReports.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1775_0 {
	meta:
		name = "TAllStoredProcedures.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllStoredProcedures.Get_Item 0034 @IntfClear 004b TAllStoredProcedures.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1736_0 {
	meta:
		name = "TAllTables.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllTables.Get_Item 0034 @IntfClear 004b TAllTables.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1762_0 {
	meta:
		name = "TAllViews.Get_Item"
		size = 137
		refs = "001f @VarAddRef 0027 TAllViews.Get_Item 0034 @IntfClear 004b TAllViews.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2896_0 {
	meta:
		name = "TFormOld.Get_accChild"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accChild 0034 @IntfClear 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_158_0 {
	meta:
		name = "TAccessLabel.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accName 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accName 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_312_0 {
	meta:
		name = "TAccessCheckBox.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accName 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2505_0 {
	meta:
		name = "TAccessComboBox.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accName 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_229_0 {
	meta:
		name = "TAccessCommandButton.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accName 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2741_0 {
	meta:
		name = "TAccessCustomControl.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accName 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4121_0 {
	meta:
		name = "TAccessForm.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accName 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2449_0 {
	meta:
		name = "TAccessListBox.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accName 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2560_0 {
	meta:
		name = "TAccessObjectFrame.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accName 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_272_0 {
	meta:
		name = "TAccessOptionButton.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accName 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2309_0 {
	meta:
		name = "TAccessOptionGroup.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accName 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_818_0 {
	meta:
		name = "TAccessPage.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accName 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_688_0 {
	meta:
		name = "TAccessSubForm.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accName 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2791_0 {
	meta:
		name = "TAccessTabControl.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accName 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2402_0 {
	meta:
		name = "TAccessTextBox.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accName 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_627_0 {
	meta:
		name = "TAccessToggleButton.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accName 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2897_0 {
	meta:
		name = "TFormOld.Get_accName"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accName 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_159_0 {
	meta:
		name = "TAccessLabel.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accValue 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_395_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accValue 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_313_0 {
	meta:
		name = "TAccessCheckBox.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accValue 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2506_0 {
	meta:
		name = "TAccessComboBox.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accValue 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_230_0 {
	meta:
		name = "TAccessCommandButton.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accValue 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2742_0 {
	meta:
		name = "TAccessCustomControl.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accValue 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4122_0 {
	meta:
		name = "TAccessForm.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accValue 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2450_0 {
	meta:
		name = "TAccessListBox.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accValue 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2561_0 {
	meta:
		name = "TAccessObjectFrame.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accValue 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_273_0 {
	meta:
		name = "TAccessOptionButton.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accValue 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2310_0 {
	meta:
		name = "TAccessOptionGroup.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accValue 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_819_0 {
	meta:
		name = "TAccessPage.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accValue 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_689_0 {
	meta:
		name = "TAccessSubForm.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accValue 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2792_0 {
	meta:
		name = "TAccessTabControl.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accValue 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2403_0 {
	meta:
		name = "TAccessTextBox.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accValue 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_628_0 {
	meta:
		name = "TAccessToggleButton.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accValue 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2898_0 {
	meta:
		name = "TFormOld.Get_accValue"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accValue 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_160_0 {
	meta:
		name = "TAccessLabel.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accDescription 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accDescription 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2266_0 {
	meta:
		name = "TAccessCheckBox.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accDescription 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2507_0 {
	meta:
		name = "TAccessComboBox.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accDescription 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_231_0 {
	meta:
		name = "TAccessCommandButton.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accDescription 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_737_0 {
	meta:
		name = "TAccessCustomControl.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accDescription 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_881_0 {
	meta:
		name = "TAccessForm.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accDescription 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "TAccessListBox.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accDescription 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_576_0 {
	meta:
		name = "TAccessObjectFrame.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accDescription 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_274_0 {
	meta:
		name = "TAccessOptionButton.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accDescription 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2311_0 {
	meta:
		name = "TAccessOptionGroup.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accDescription 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_820_0 {
	meta:
		name = "TAccessPage.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accDescription 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_690_0 {
	meta:
		name = "TAccessSubForm.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accDescription 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_783_0 {
	meta:
		name = "TAccessTabControl.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accDescription 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2404_0 {
	meta:
		name = "TAccessTextBox.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accDescription 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_629_0 {
	meta:
		name = "TAccessToggleButton.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accDescription 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_71054_0 {
	meta:
		name = "TExplorers.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TExplorers.Item 0034 @IntfClear 004b TExplorers.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_71089_0 {
	meta:
		name = "TFolders.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TFolders.Item 0034 @IntfClear 004b TFolders.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2899_0 {
	meta:
		name = "TFormOld.Get_accDescription"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accDescription 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_71071_0 {
	meta:
		name = "TInspectors.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TInspectors.Item 0034 @IntfClear 004b TInspectors.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_71115_0 {
	meta:
		name = "TItems.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TItems.Item 0034 @IntfClear 004b TItems.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_71315_0 {
	meta:
		name = "TOutlookBarGroups.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TOutlookBarGroups.Item 0034 @IntfClear 004b TOutlookBarGroups.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_71354_0 {
	meta:
		name = "TOutlookBarShortcuts.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TOutlookBarShortcuts.Item 0034 @IntfClear 004b TOutlookBarShortcuts.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_73817_0 {
	meta:
		name = "TReminders.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TReminders.Item 0034 @IntfClear 004b TReminders.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_73753_0 {
	meta:
		name = "TResults.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TResults.Item 0034 @IntfClear 004b TResults.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_73777_0 {
	meta:
		name = "TViews.Item"
		size = 137
		refs = "001f @VarAddRef 0027 TViews.Item 0034 @IntfClear 004b TViews.GetDefaultInterface 0059 @CheckAutoResult 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 30 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_161_0 {
	meta:
		name = "TAccessLabel.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessLabel.Get_accRole 003f TAccessLabel.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessBoundObjectFrame.Get_accRole 003f TAccessBoundObjectFrame.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_315_0 {
	meta:
		name = "TAccessCheckBox.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessCheckBox.Get_accRole 003f TAccessCheckBox.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_2508_0 {
	meta:
		name = "TAccessComboBox.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessComboBox.Get_accRole 003f TAccessComboBox.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_232_0 {
	meta:
		name = "TAccessCommandButton.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessCommandButton.Get_accRole 003f TAccessCommandButton.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_2744_0 {
	meta:
		name = "TAccessCustomControl.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessCustomControl.Get_accRole 003f TAccessCustomControl.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_4124_0 {
	meta:
		name = "TAccessForm.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessForm.Get_accRole 003f TAccessForm.GetDefaultInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_2452_0 {
	meta:
		name = "TAccessListBox.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessListBox.Get_accRole 003f TAccessListBox.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_2563_0 {
	meta:
		name = "TAccessObjectFrame.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessObjectFrame.Get_accRole 003f TAccessObjectFrame.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_275_0 {
	meta:
		name = "TAccessOptionButton.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessOptionButton.Get_accRole 003f TAccessOptionButton.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_2312_0 {
	meta:
		name = "TAccessOptionGroup.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessOptionGroup.Get_accRole 003f TAccessOptionGroup.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_821_0 {
	meta:
		name = "TAccessPage.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessPage.Get_accRole 003f TAccessPage.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_691_0 {
	meta:
		name = "TAccessSubForm.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessSubForm.Get_accRole 003f TAccessSubForm.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_2794_0 {
	meta:
		name = "TAccessTabControl.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessTabControl.Get_accRole 003f TAccessTabControl.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_2405_0 {
	meta:
		name = "TAccessTextBox.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessTextBox.Get_accRole 003f TAccessTextBox.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_630_0 {
	meta:
		name = "TAccessToggleButton.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TAccessToggleButton.Get_accRole 003f TAccessToggleButton.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_2900_0 {
	meta:
		name = "TFormOld.Get_accRole"
		size = 188
		refs = "0027 @VarAddRef 002f TFormOld.Get_accRole 003f TFormOld.GetDefaultInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 52 6F 6C 65 00 }
	condition:
		$1
}

rule function_162_0 {
	meta:
		name = "TAccessLabel.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessLabel.Get_accState 003f TAccessLabel.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessBoundObjectFrame.Get_accState 003f TAccessBoundObjectFrame.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_316_0 {
	meta:
		name = "TAccessCheckBox.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessCheckBox.Get_accState 003f TAccessCheckBox.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_2509_0 {
	meta:
		name = "TAccessComboBox.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessComboBox.Get_accState 003f TAccessComboBox.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_233_0 {
	meta:
		name = "TAccessCommandButton.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessCommandButton.Get_accState 003f TAccessCommandButton.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_2745_0 {
	meta:
		name = "TAccessCustomControl.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessCustomControl.Get_accState 003f TAccessCustomControl.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_4125_0 {
	meta:
		name = "TAccessForm.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessForm.Get_accState 003f TAccessForm.GetDefaultInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_2453_0 {
	meta:
		name = "TAccessListBox.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessListBox.Get_accState 003f TAccessListBox.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_2564_0 {
	meta:
		name = "TAccessObjectFrame.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessObjectFrame.Get_accState 003f TAccessObjectFrame.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_276_0 {
	meta:
		name = "TAccessOptionButton.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessOptionButton.Get_accState 003f TAccessOptionButton.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_2313_0 {
	meta:
		name = "TAccessOptionGroup.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessOptionGroup.Get_accState 003f TAccessOptionGroup.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_822_0 {
	meta:
		name = "TAccessPage.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessPage.Get_accState 003f TAccessPage.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_692_0 {
	meta:
		name = "TAccessSubForm.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessSubForm.Get_accState 003f TAccessSubForm.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_2795_0 {
	meta:
		name = "TAccessTabControl.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessTabControl.Get_accState 003f TAccessTabControl.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_2406_0 {
	meta:
		name = "TAccessTextBox.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessTextBox.Get_accState 003f TAccessTextBox.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_631_0 {
	meta:
		name = "TAccessToggleButton.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TAccessToggleButton.Get_accState 003f TAccessToggleButton.GetControlInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_2901_0 {
	meta:
		name = "TFormOld.Get_accState"
		size = 192
		refs = "0027 @VarAddRef 002f TFormOld.Get_accState 003f TFormOld.GetDefaultInterface 004a @VarFromDisp 0060 @DispInvoke 006d @OleVarFromVar 0082 @VarClr 008a @IntfClear 0093 OleVariant 009d @FinalizeArray 00a3 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 B9 06 00 00 00 6A 00 6A 00 49 75 F9 87 4D FC 53 56 57 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 DC 8B C3 E8 ?? ?? ?? ?? 8B 55 DC 8D 45 E0 E8 ?? ?? ?? ?? 8D 45 F0 50 68 ?? ?? ?? ?? 8D 45 E0 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 8D 55 CC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 CC E8 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 E0 8B 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB D5 5F 5E 5B 8B E5 5D C3 02 01 00 8C 61 63 63 53 74 61 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_163_0 {
	meta:
		name = "TAccessLabel.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accHelp 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accHelp 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_317_0 {
	meta:
		name = "TAccessCheckBox.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accHelp 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2510_0 {
	meta:
		name = "TAccessComboBox.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accHelp 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_234_0 {
	meta:
		name = "TAccessCommandButton.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accHelp 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2746_0 {
	meta:
		name = "TAccessCustomControl.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accHelp 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4126_0 {
	meta:
		name = "TAccessForm.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accHelp 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2454_0 {
	meta:
		name = "TAccessListBox.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accHelp 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2565_0 {
	meta:
		name = "TAccessObjectFrame.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accHelp 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_277_0 {
	meta:
		name = "TAccessOptionButton.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accHelp 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2314_0 {
	meta:
		name = "TAccessOptionGroup.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accHelp 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_823_0 {
	meta:
		name = "TAccessPage.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accHelp 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_693_0 {
	meta:
		name = "TAccessSubForm.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accHelp 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2796_0 {
	meta:
		name = "TAccessTabControl.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accHelp 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2407_0 {
	meta:
		name = "TAccessTextBox.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accHelp 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_632_0 {
	meta:
		name = "TAccessToggleButton.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accHelp 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2902_0 {
	meta:
		name = "TFormOld.Get_accHelp"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accHelp 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 3C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_164_0 {
	meta:
		name = "TAccessLabel.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessLabel.Get_accHelpTopic 0051 @WStrClr 005c TAccessLabel.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessBoundObjectFrame.Get_accHelpTopic 0051 @WStrClr 005c TAccessBoundObjectFrame.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_318_0 {
	meta:
		name = "TAccessCheckBox.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessCheckBox.Get_accHelpTopic 0051 @WStrClr 005c TAccessCheckBox.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2511_0 {
	meta:
		name = "TAccessComboBox.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessComboBox.Get_accHelpTopic 0051 @WStrClr 005c TAccessComboBox.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_235_0 {
	meta:
		name = "TAccessCommandButton.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessCommandButton.Get_accHelpTopic 0051 @WStrClr 005c TAccessCommandButton.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2747_0 {
	meta:
		name = "TAccessCustomControl.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessCustomControl.Get_accHelpTopic 0051 @WStrClr 005c TAccessCustomControl.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4127_0 {
	meta:
		name = "TAccessForm.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessForm.Get_accHelpTopic 0051 @WStrClr 005c TAccessForm.GetDefaultInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2455_0 {
	meta:
		name = "TAccessListBox.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessListBox.Get_accHelpTopic 0051 @WStrClr 005c TAccessListBox.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2566_0 {
	meta:
		name = "TAccessObjectFrame.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessObjectFrame.Get_accHelpTopic 0051 @WStrClr 005c TAccessObjectFrame.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_278_0 {
	meta:
		name = "TAccessOptionButton.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessOptionButton.Get_accHelpTopic 0051 @WStrClr 005c TAccessOptionButton.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2315_0 {
	meta:
		name = "TAccessOptionGroup.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessOptionGroup.Get_accHelpTopic 0051 @WStrClr 005c TAccessOptionGroup.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_824_0 {
	meta:
		name = "TAccessPage.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessPage.Get_accHelpTopic 0051 @WStrClr 005c TAccessPage.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_694_0 {
	meta:
		name = "TAccessSubForm.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessSubForm.Get_accHelpTopic 0051 @WStrClr 005c TAccessSubForm.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2797_0 {
	meta:
		name = "TAccessTabControl.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessTabControl.Get_accHelpTopic 0051 @WStrClr 005c TAccessTabControl.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2408_0 {
	meta:
		name = "TAccessTextBox.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessTextBox.Get_accHelpTopic 0051 @WStrClr 005c TAccessTextBox.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_633_0 {
	meta:
		name = "TAccessToggleButton.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TAccessToggleButton.Get_accHelpTopic 0051 @WStrClr 005c TAccessToggleButton.GetControlInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2903_0 {
	meta:
		name = "TFormOld.Get_accHelpTopic"
		size = 159
		refs = "002b @VarAddRef 0033 TFormOld.Get_accHelpTopic 0051 @WStrClr 005c TFormOld.GetDefaultInterface 006a @CheckAutoResult 0082 @IntfClear 008a @VarClr 0090 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 E4 53 56 57 33 DB 89 5D E4 8B F1 8D 7D F0 A5 A5 A5 A5 89 55 EC 8B D8 8B 45 EC 85 C0 74 04 33 D2 89 10 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 E8 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 EC E8 ?? ?? ?? ?? 50 8D 55 E4 8B C3 E8 ?? ?? ?? ?? 8B 45 E4 50 8B 00 FF 50 40 E8 ?? ?? ?? ?? 8B 5D E8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 E4 E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_165_0 {
	meta:
		name = "TAccessLabel.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_319_0 {
	meta:
		name = "TAccessCheckBox.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2512_0 {
	meta:
		name = "TAccessComboBox.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_236_0 {
	meta:
		name = "TAccessCommandButton.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2748_0 {
	meta:
		name = "TAccessCustomControl.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4128_0 {
	meta:
		name = "TAccessForm.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2456_0 {
	meta:
		name = "TAccessListBox.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2567_0 {
	meta:
		name = "TAccessObjectFrame.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_279_0 {
	meta:
		name = "TAccessOptionButton.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2316_0 {
	meta:
		name = "TAccessOptionGroup.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_825_0 {
	meta:
		name = "TAccessPage.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_695_0 {
	meta:
		name = "TAccessSubForm.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2798_0 {
	meta:
		name = "TAccessTabControl.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2409_0 {
	meta:
		name = "TAccessTextBox.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_634_0 {
	meta:
		name = "TAccessToggleButton.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accKeyboardShortcut 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2904_0 {
	meta:
		name = "TFormOld.Get_accKeyboardShortcut"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accKeyboardShortcut 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_166_0 {
	meta:
		name = "TAccessLabel.Get_accFocus"
		size = 152
		refs = "001a TAccessLabel.Get_accFocus 002a TAccessLabel.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_402_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accFocus"
		size = 152
		refs = "001a TAccessBoundObjectFrame.Get_accFocus 002a TAccessBoundObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_320_0 {
	meta:
		name = "TAccessCheckBox.Get_accFocus"
		size = 152
		refs = "001a TAccessCheckBox.Get_accFocus 002a TAccessCheckBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_2513_0 {
	meta:
		name = "TAccessComboBox.Get_accFocus"
		size = 152
		refs = "001a TAccessComboBox.Get_accFocus 002a TAccessComboBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_237_0 {
	meta:
		name = "TAccessCommandButton.Get_accFocus"
		size = 152
		refs = "001a TAccessCommandButton.Get_accFocus 002a TAccessCommandButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_2749_0 {
	meta:
		name = "TAccessCustomControl.Get_accFocus"
		size = 152
		refs = "001a TAccessCustomControl.Get_accFocus 002a TAccessCustomControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_4129_0 {
	meta:
		name = "TAccessForm.Get_accFocus"
		size = 152
		refs = "001a TAccessForm.Get_accFocus 002a TAccessForm.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_2457_0 {
	meta:
		name = "TAccessListBox.Get_accFocus"
		size = 152
		refs = "001a TAccessListBox.Get_accFocus 002a TAccessListBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_2568_0 {
	meta:
		name = "TAccessObjectFrame.Get_accFocus"
		size = 152
		refs = "001a TAccessObjectFrame.Get_accFocus 002a TAccessObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_280_0 {
	meta:
		name = "TAccessOptionButton.Get_accFocus"
		size = 152
		refs = "001a TAccessOptionButton.Get_accFocus 002a TAccessOptionButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_2317_0 {
	meta:
		name = "TAccessOptionGroup.Get_accFocus"
		size = 152
		refs = "001a TAccessOptionGroup.Get_accFocus 002a TAccessOptionGroup.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_826_0 {
	meta:
		name = "TAccessPage.Get_accFocus"
		size = 152
		refs = "001a TAccessPage.Get_accFocus 002a TAccessPage.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_696_0 {
	meta:
		name = "TAccessSubForm.Get_accFocus"
		size = 152
		refs = "001a TAccessSubForm.Get_accFocus 002a TAccessSubForm.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_2799_0 {
	meta:
		name = "TAccessTabControl.Get_accFocus"
		size = 152
		refs = "001a TAccessTabControl.Get_accFocus 002a TAccessTabControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_2410_0 {
	meta:
		name = "TAccessTextBox.Get_accFocus"
		size = 152
		refs = "001a TAccessTextBox.Get_accFocus 002a TAccessTextBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_635_0 {
	meta:
		name = "TAccessToggleButton.Get_accFocus"
		size = 152
		refs = "001a TAccessToggleButton.Get_accFocus 002a TAccessToggleButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_2905_0 {
	meta:
		name = "TFormOld.Get_accFocus"
		size = 152
		refs = "001a TFormOld.Get_accFocus 002a TFormOld.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 46 6F 63 75 73 00 }
	condition:
		$1
}

rule function_167_0 {
	meta:
		name = "TAccessLabel.Get_accSelection"
		size = 156
		refs = "001a TAccessLabel.Get_accSelection 002a TAccessLabel.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accSelection"
		size = 156
		refs = "001a TAccessBoundObjectFrame.Get_accSelection 002a TAccessBoundObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_321_0 {
	meta:
		name = "TAccessCheckBox.Get_accSelection"
		size = 156
		refs = "001a TAccessCheckBox.Get_accSelection 002a TAccessCheckBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_2514_0 {
	meta:
		name = "TAccessComboBox.Get_accSelection"
		size = 156
		refs = "001a TAccessComboBox.Get_accSelection 002a TAccessComboBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_238_0 {
	meta:
		name = "TAccessCommandButton.Get_accSelection"
		size = 156
		refs = "001a TAccessCommandButton.Get_accSelection 002a TAccessCommandButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_2750_0 {
	meta:
		name = "TAccessCustomControl.Get_accSelection"
		size = 156
		refs = "001a TAccessCustomControl.Get_accSelection 002a TAccessCustomControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_4130_0 {
	meta:
		name = "TAccessForm.Get_accSelection"
		size = 156
		refs = "001a TAccessForm.Get_accSelection 002a TAccessForm.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_2458_0 {
	meta:
		name = "TAccessListBox.Get_accSelection"
		size = 156
		refs = "001a TAccessListBox.Get_accSelection 002a TAccessListBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_2569_0 {
	meta:
		name = "TAccessObjectFrame.Get_accSelection"
		size = 156
		refs = "001a TAccessObjectFrame.Get_accSelection 002a TAccessObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_281_0 {
	meta:
		name = "TAccessOptionButton.Get_accSelection"
		size = 156
		refs = "001a TAccessOptionButton.Get_accSelection 002a TAccessOptionButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_2318_0 {
	meta:
		name = "TAccessOptionGroup.Get_accSelection"
		size = 156
		refs = "001a TAccessOptionGroup.Get_accSelection 002a TAccessOptionGroup.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_827_0 {
	meta:
		name = "TAccessPage.Get_accSelection"
		size = 156
		refs = "001a TAccessPage.Get_accSelection 002a TAccessPage.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_697_0 {
	meta:
		name = "TAccessSubForm.Get_accSelection"
		size = 156
		refs = "001a TAccessSubForm.Get_accSelection 002a TAccessSubForm.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_2800_0 {
	meta:
		name = "TAccessTabControl.Get_accSelection"
		size = 156
		refs = "001a TAccessTabControl.Get_accSelection 002a TAccessTabControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_2411_0 {
	meta:
		name = "TAccessTextBox.Get_accSelection"
		size = 156
		refs = "001a TAccessTextBox.Get_accSelection 002a TAccessTextBox.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_636_0 {
	meta:
		name = "TAccessToggleButton.Get_accSelection"
		size = 156
		refs = "001a TAccessToggleButton.Get_accSelection 002a TAccessToggleButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_2906_0 {
	meta:
		name = "TFormOld.Get_accSelection"
		size = 156
		refs = "001a TFormOld.Get_accSelection 002a TFormOld.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 61 63 63 53 65 6C 65 63 74 69 6F 6E 00 }
	condition:
		$1
}

rule function_168_0 {
	meta:
		name = "TAccessLabel.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessLabel.Get_accDefaultAction 0034 @WStrClr 004b TAccessLabel.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_404_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.Get_accDefaultAction 0034 @WStrClr 004b TAccessBoundObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_322_0 {
	meta:
		name = "TAccessCheckBox.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCheckBox.Get_accDefaultAction 0034 @WStrClr 004b TAccessCheckBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2515_0 {
	meta:
		name = "TAccessComboBox.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessComboBox.Get_accDefaultAction 0034 @WStrClr 004b TAccessComboBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_239_0 {
	meta:
		name = "TAccessCommandButton.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCommandButton.Get_accDefaultAction 0034 @WStrClr 004b TAccessCommandButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2751_0 {
	meta:
		name = "TAccessCustomControl.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessCustomControl.Get_accDefaultAction 0034 @WStrClr 004b TAccessCustomControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4131_0 {
	meta:
		name = "TAccessForm.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessForm.Get_accDefaultAction 0034 @WStrClr 004b TAccessForm.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2459_0 {
	meta:
		name = "TAccessListBox.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessListBox.Get_accDefaultAction 0034 @WStrClr 004b TAccessListBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2570_0 {
	meta:
		name = "TAccessObjectFrame.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.Get_accDefaultAction 0034 @WStrClr 004b TAccessObjectFrame.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_282_0 {
	meta:
		name = "TAccessOptionButton.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionButton.Get_accDefaultAction 0034 @WStrClr 004b TAccessOptionButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2319_0 {
	meta:
		name = "TAccessOptionGroup.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.Get_accDefaultAction 0034 @WStrClr 004b TAccessOptionGroup.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_828_0 {
	meta:
		name = "TAccessPage.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessPage.Get_accDefaultAction 0034 @WStrClr 004b TAccessPage.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_698_0 {
	meta:
		name = "TAccessSubForm.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessSubForm.Get_accDefaultAction 0034 @WStrClr 004b TAccessSubForm.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2801_0 {
	meta:
		name = "TAccessTabControl.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTabControl.Get_accDefaultAction 0034 @WStrClr 004b TAccessTabControl.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2412_0 {
	meta:
		name = "TAccessTextBox.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessTextBox.Get_accDefaultAction 0034 @WStrClr 004b TAccessTextBox.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_637_0 {
	meta:
		name = "TAccessToggleButton.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TAccessToggleButton.Get_accDefaultAction 0034 @WStrClr 004b TAccessToggleButton.GetControlInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2907_0 {
	meta:
		name = "TFormOld.Get_accDefaultAction"
		size = 137
		refs = "001f @VarAddRef 0027 TFormOld.Get_accDefaultAction 0034 @WStrClr 004b TFormOld.GetDefaultInterface 0059 @CheckAutoResult 006e @IntfClear 0076 @VarClr 007c @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B F1 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_169_0 {
	meta:
		name = "TAccessLabel.Set_accName"
		size = 132
		refs = "0017 TAccessLabel.Set_accName 0027 TAccessLabel.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "TAccessBoundObjectFrame.Set_accName"
		size = 132
		refs = "0017 TAccessBoundObjectFrame.Set_accName 0027 TAccessBoundObjectFrame.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_323_0 {
	meta:
		name = "TAccessCheckBox.Set_accName"
		size = 132
		refs = "0017 TAccessCheckBox.Set_accName 0027 TAccessCheckBox.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_2516_0 {
	meta:
		name = "TAccessComboBox.Set_accName"
		size = 132
		refs = "0017 TAccessComboBox.Set_accName 0027 TAccessComboBox.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_240_0 {
	meta:
		name = "TAccessCommandButton.Set_accName"
		size = 132
		refs = "0017 TAccessCommandButton.Set_accName 0027 TAccessCommandButton.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_2752_0 {
	meta:
		name = "TAccessCustomControl.Set_accName"
		size = 132
		refs = "0017 TAccessCustomControl.Set_accName 0027 TAccessCustomControl.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_4132_0 {
	meta:
		name = "TAccessForm.Set_accName"
		size = 132
		refs = "0017 TAccessForm.Set_accName 0027 TAccessForm.GetDefaultInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_2460_0 {
	meta:
		name = "TAccessListBox.Set_accName"
		size = 132
		refs = "0017 TAccessListBox.Set_accName 0027 TAccessListBox.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_2571_0 {
	meta:
		name = "TAccessObjectFrame.Set_accName"
		size = 132
		refs = "0017 TAccessObjectFrame.Set_accName 0027 TAccessObjectFrame.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_283_0 {
	meta:
		name = "TAccessOptionButton.Set_accName"
		size = 132
		refs = "0017 TAccessOptionButton.Set_accName 0027 TAccessOptionButton.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_2320_0 {
	meta:
		name = "TAccessOptionGroup.Set_accName"
		size = 132
		refs = "0017 TAccessOptionGroup.Set_accName 0027 TAccessOptionGroup.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_829_0 {
	meta:
		name = "TAccessPage.Set_accName"
		size = 132
		refs = "0017 TAccessPage.Set_accName 0027 TAccessPage.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_699_0 {
	meta:
		name = "TAccessSubForm.Set_accName"
		size = 132
		refs = "0017 TAccessSubForm.Set_accName 0027 TAccessSubForm.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_2802_0 {
	meta:
		name = "TAccessTabControl.Set_accName"
		size = 132
		refs = "0017 TAccessTabControl.Set_accName 0027 TAccessTabControl.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_2413_0 {
	meta:
		name = "TAccessTextBox.Set_accName"
		size = 132
		refs = "0017 TAccessTextBox.Set_accName 0027 TAccessTextBox.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_638_0 {
	meta:
		name = "TAccessToggleButton.Set_accName"
		size = 132
		refs = "0017 TAccessToggleButton.Set_accName 0027 TAccessToggleButton.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_2908_0 {
	meta:
		name = "TFormOld.Set_accName"
		size = 132
		refs = "0017 TFormOld.Set_accName 0027 TFormOld.GetDefaultInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 4E 61 6D 65 00 }
	condition:
		$1
}

rule function_170_0 {
	meta:
		name = "TAccessLabel.Set_accValue"
		size = 136
		refs = "0017 TAccessLabel.Set_accValue 0027 TAccessLabel.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "TAccessBoundObjectFrame.Set_accValue"
		size = 136
		refs = "0017 TAccessBoundObjectFrame.Set_accValue 0027 TAccessBoundObjectFrame.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_324_0 {
	meta:
		name = "TAccessCheckBox.Set_accValue"
		size = 136
		refs = "0017 TAccessCheckBox.Set_accValue 0027 TAccessCheckBox.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2517_0 {
	meta:
		name = "TAccessComboBox.Set_accValue"
		size = 136
		refs = "0017 TAccessComboBox.Set_accValue 0027 TAccessComboBox.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_241_0 {
	meta:
		name = "TAccessCommandButton.Set_accValue"
		size = 136
		refs = "0017 TAccessCommandButton.Set_accValue 0027 TAccessCommandButton.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2753_0 {
	meta:
		name = "TAccessCustomControl.Set_accValue"
		size = 136
		refs = "0017 TAccessCustomControl.Set_accValue 0027 TAccessCustomControl.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_4133_0 {
	meta:
		name = "TAccessForm.Set_accValue"
		size = 136
		refs = "0017 TAccessForm.Set_accValue 0027 TAccessForm.GetDefaultInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2461_0 {
	meta:
		name = "TAccessListBox.Set_accValue"
		size = 136
		refs = "0017 TAccessListBox.Set_accValue 0027 TAccessListBox.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2572_0 {
	meta:
		name = "TAccessObjectFrame.Set_accValue"
		size = 136
		refs = "0017 TAccessObjectFrame.Set_accValue 0027 TAccessObjectFrame.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_284_0 {
	meta:
		name = "TAccessOptionButton.Set_accValue"
		size = 136
		refs = "0017 TAccessOptionButton.Set_accValue 0027 TAccessOptionButton.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2321_0 {
	meta:
		name = "TAccessOptionGroup.Set_accValue"
		size = 136
		refs = "0017 TAccessOptionGroup.Set_accValue 0027 TAccessOptionGroup.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_830_0 {
	meta:
		name = "TAccessPage.Set_accValue"
		size = 136
		refs = "0017 TAccessPage.Set_accValue 0027 TAccessPage.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_700_0 {
	meta:
		name = "TAccessSubForm.Set_accValue"
		size = 136
		refs = "0017 TAccessSubForm.Set_accValue 0027 TAccessSubForm.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2803_0 {
	meta:
		name = "TAccessTabControl.Set_accValue"
		size = 136
		refs = "0017 TAccessTabControl.Set_accValue 0027 TAccessTabControl.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2414_0 {
	meta:
		name = "TAccessTextBox.Set_accValue"
		size = 136
		refs = "0017 TAccessTextBox.Set_accValue 0027 TAccessTextBox.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_639_0 {
	meta:
		name = "TAccessToggleButton.Set_accValue"
		size = 136
		refs = "0017 TAccessToggleButton.Set_accValue 0027 TAccessToggleButton.GetControlInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_2909_0 {
	meta:
		name = "TFormOld.Set_accValue"
		size = 136
		refs = "0017 TFormOld.Set_accValue 0027 TFormOld.GetDefaultInterface 0032 @VarFromDisp 0043 @DispInvoke 005b @IntfClear 0063 @VarClr 0069 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 6A 00 6A 00 6A 00 53 56 8B F1 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 45 F0 50 6A 00 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5E 5B 8B E5 5D C3 00 00 00 04 01 00 08 61 63 63 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_173_0 {
	meta:
		name = "TAccessLabel.Get_Properties"
		size = 91
		refs = "000f TAccessLabel.Get_Properties 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_894_0 {
	meta:
		name = "TAccessForm.Get_RecordSource"
		size = 91
		refs = "000f TAccessForm.Get_RecordSource 001c @WStrClr 0027 TAccessForm.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_833_0 {
	meta:
		name = "TAccessPage.Get_Properties"
		size = 91
		refs = "000f TAccessPage.Get_Properties 001c @IntfClear 0027 TAccessPage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_703_0 {
	meta:
		name = "TAccessSubForm.Get_Form"
		size = 91
		refs = "000f TAccessSubForm.Get_Form 001c @IntfClear 0027 TAccessSubForm.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70280_0 {
	meta:
		name = "TAppointmentItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TAppointmentItem.Get_MAPIOBJECT 001c @IntfClear 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9250_0 {
	meta:
		name = "TBinder.Get_DefaultFilePath"
		size = 91
		refs = "000f TBinder.Get_DefaultFilePath 001c @WStrClr 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70660_0 {
	meta:
		name = "TContactItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TContactItem.Get_MAPIOBJECT 001c @IntfClear 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72779_0 {
	meta:
		name = "TDistListItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TDistListItem.Get_MAPIOBJECT 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72860_0 {
	meta:
		name = "TDocumentItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TDocumentItem.Get_MAPIOBJECT 001c @IntfClear 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2912_0 {
	meta:
		name = "TFormOld.Get_RecordSource"
		size = 91
		refs = "000f TFormOld.Get_RecordSource 001c @WStrClr 0027 TFormOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79301_0 {
	meta:
		name = "TInternetExplorer.Get_LocationURL"
		size = 91
		refs = "000f TInternetExplorer.Get_LocationURL 001c @WStrClr 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73019_0 {
	meta:
		name = "TJournalItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TJournalItem.Get_MAPIOBJECT 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71941_0 {
	meta:
		name = "TMailItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TMailItem.Get_MAPIOBJECT 001c @IntfClear 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72214_0 {
	meta:
		name = "TMeetingItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TMeetingItem.Get_MAPIOBJECT 001c @IntfClear 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73098_0 {
	meta:
		name = "TNameSpace.Get_MAPIOBJECT"
		size = 91
		refs = "000f TNameSpace.Get_MAPIOBJECT 001c @IntfClear 0027 TNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71391_0 {
	meta:
		name = "TPostItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TPostItem.Get_MAPIOBJECT 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67277_0 {
	meta:
		name = "TPowerPointPresentation.Get_FullName"
		size = 91
		refs = "000f TPowerPointPresentation.Get_FullName 001c @WStrClr 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71464_0 {
	meta:
		name = "TRemoteItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TRemoteItem.Get_MAPIOBJECT 001c @IntfClear 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73418_0 {
	meta:
		name = "TReportItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TReportItem.Get_MAPIOBJECT 001c @IntfClear 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72317_0 {
	meta:
		name = "TTaskItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73486_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71655_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73624_0 {
	meta:
		name = "TTaskRequestItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskRequestItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73693_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_MAPIOBJECT"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_MAPIOBJECT 001c @IntfClear 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99595_0 {
	meta:
		name = "TWordApplication.Get_CaptionLabels"
		size = 91
		refs = "000f TWordApplication.Get_CaptionLabels 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98955_0 {
	meta:
		name = "TWordDocument.Get_Words"
		size = 91
		refs = "000f TWordDocument.Get_Words 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98837_0 {
	meta:
		name = "TWordGlobal.Get_CaptionLabels"
		size = 91
		refs = "000f TWordGlobal.Get_CaptionLabels 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 78 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_174_0 {
	meta:
		name = "TAccessLabel.Get_Hyperlink"
		size = 94
		refs = "000f TAccessLabel.Get_Hyperlink 001c @IntfClear 0027 TAccessLabel.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2372_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_Properties"
		size = 94
		refs = "000f TAccessBoundObjectFrame.Get_Properties 001c @IntfClear 0027 TAccessBoundObjectFrame.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_753_0 {
	meta:
		name = "TAccessCustomControl.Get_Properties"
		size = 94
		refs = "000f TAccessCustomControl.Get_Properties 001c @IntfClear 0027 TAccessCustomControl.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_592_0 {
	meta:
		name = "TAccessObjectFrame.Get_Properties"
		size = 94
		refs = "000f TAccessObjectFrame.Get_Properties 001c @IntfClear 0027 TAccessObjectFrame.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_798_0 {
	meta:
		name = "TAccessTabControl.Get_Pages"
		size = 94
		refs = "000f TAccessTabControl.Get_Pages 001c @IntfClear 0027 TAccessTabControl.GetControlInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72083_0 {
	meta:
		name = "TAppointmentItem.Get_Mileage"
		size = 94
		refs = "000f TAppointmentItem.Get_Mileage 001c @WStrClr 0027 TAppointmentItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72493_0 {
	meta:
		name = "TContactItem.Get_Mileage"
		size = 94
		refs = "000f TContactItem.Get_Mileage 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72782_0 {
	meta:
		name = "TDistListItem.Get_Mileage"
		size = 94
		refs = "000f TDistListItem.Get_Mileage 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71013_0 {
	meta:
		name = "TDocumentItem.Get_Mileage"
		size = 94
		refs = "000f TDocumentItem.Get_Mileage 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47475_0 {
	meta:
		name = "TExcelWorkbook.Get_CommandBars"
		size = 94
		refs = "000f TExcelWorkbook.Get_CommandBars 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71166_0 {
	meta:
		name = "TJournalItem.Get_Mileage"
		size = 94
		refs = "000f TJournalItem.Get_Mileage 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70154_0 {
	meta:
		name = "TMailItem.Get_Mileage"
		size = 94
		refs = "000f TMailItem.Get_Mileage 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70409_0 {
	meta:
		name = "TMeetingItem.Get_Mileage"
		size = 94
		refs = "000f TMeetingItem.Get_Mileage 001c @WStrClr 0027 TMeetingItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73265_0 {
	meta:
		name = "TPostItem.Get_Mileage"
		size = 94
		refs = "000f TPostItem.Get_Mileage 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74292_0 {
	meta:
		name = "TPowerPointSlide.Get_NotesPage"
		size = 94
		refs = "000f TPowerPointSlide.Get_NotesPage 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73349_0 {
	meta:
		name = "TRemoteItem.Get_Mileage"
		size = 94
		refs = "000f TRemoteItem.Get_Mileage 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73421_0 {
	meta:
		name = "TReportItem.Get_Mileage"
		size = 94
		refs = "000f TReportItem.Get_Mileage 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72320_0 {
	meta:
		name = "TTaskItem.Get_Mileage"
		size = 94
		refs = "000f TTaskItem.Get_Mileage 001c @WStrClr 0027 TTaskItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73489_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Mileage"
		size = 94
		refs = "000f TTaskRequestAcceptItem.Get_Mileage 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73558_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Mileage"
		size = 94
		refs = "000f TTaskRequestDeclineItem.Get_Mileage 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71721_0 {
	meta:
		name = "TTaskRequestItem.Get_Mileage"
		size = 94
		refs = "000f TTaskRequestItem.Get_Mileage 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71784_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Mileage"
		size = 94
		refs = "000f TTaskRequestUpdateItem.Get_Mileage 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3963_0 {
	meta:
		name = "TWizHook.LocalFont"
		size = 94
		refs = "000f TWizHook.LocalFont 001c @WStrClr 0027 TWizHook.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98958_0 {
	meta:
		name = "TWordDocument.Get_Fields"
		size = 94
		refs = "000f TWordDocument.Get_Fields 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98840_0 {
	meta:
		name = "TWordGlobal.Get_Tasks"
		size = 94
		refs = "000f TWordGlobal.Get_Tasks 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0038 @CheckAutoResult 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99522_0 {
	meta:
		name = "TWordLetterContent.Get_RecipientReference"
		size = 94
		refs = "000f TWordLetterContent.Get_RecipientReference 001c @WStrClr 0027 TWordLetterContent.GetDefaultInterface 0038 @CheckAutoResult 004d @IntfClear 0053 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 84 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_175_0 {
	meta:
		name = "TAccessLabel.accSelect"
		size = 100
		refs = "000f TAccessLabel.accSelect 001a EmptyParam 0030 TAccessLabel.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_418_0 {
	meta:
		name = "TAccessBoundObjectFrame.accSelect"
		size = 100
		refs = "000f TAccessBoundObjectFrame.accSelect 001a EmptyParam 0030 TAccessBoundObjectFrame.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_332_0 {
	meta:
		name = "TAccessCheckBox.accSelect"
		size = 100
		refs = "000f TAccessCheckBox.accSelect 001a EmptyParam 0030 TAccessCheckBox.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2531_0 {
	meta:
		name = "TAccessComboBox.accSelect"
		size = 100
		refs = "000f TAccessComboBox.accSelect 001a EmptyParam 0030 TAccessComboBox.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_252_0 {
	meta:
		name = "TAccessCommandButton.accSelect"
		size = 100
		refs = "000f TAccessCommandButton.accSelect 001a EmptyParam 0030 TAccessCommandButton.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2767_0 {
	meta:
		name = "TAccessCustomControl.accSelect"
		size = 100
		refs = "000f TAccessCustomControl.accSelect 001a EmptyParam 0030 TAccessCustomControl.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4538_0 {
	meta:
		name = "TAccessForm.accSelect"
		size = 100
		refs = "000f TAccessForm.accSelect 001a EmptyParam 0030 TAccessForm.GetDefaultInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2477_0 {
	meta:
		name = "TAccessListBox.accSelect"
		size = 100
		refs = "000f TAccessListBox.accSelect 001a EmptyParam 0030 TAccessListBox.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2584_0 {
	meta:
		name = "TAccessObjectFrame.accSelect"
		size = 100
		refs = "000f TAccessObjectFrame.accSelect 001a EmptyParam 0030 TAccessObjectFrame.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_292_0 {
	meta:
		name = "TAccessOptionButton.accSelect"
		size = 100
		refs = "000f TAccessOptionButton.accSelect 001a EmptyParam 0030 TAccessOptionButton.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2329_0 {
	meta:
		name = "TAccessOptionGroup.accSelect"
		size = 100
		refs = "000f TAccessOptionGroup.accSelect 001a EmptyParam 0030 TAccessOptionGroup.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_837_0 {
	meta:
		name = "TAccessPage.accSelect"
		size = 100
		refs = "000f TAccessPage.accSelect 001a EmptyParam 0030 TAccessPage.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_707_0 {
	meta:
		name = "TAccessSubForm.accSelect"
		size = 100
		refs = "000f TAccessSubForm.accSelect 001a EmptyParam 0030 TAccessSubForm.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2811_0 {
	meta:
		name = "TAccessTabControl.accSelect"
		size = 100
		refs = "000f TAccessTabControl.accSelect 001a EmptyParam 0030 TAccessTabControl.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2424_0 {
	meta:
		name = "TAccessTextBox.accSelect"
		size = 100
		refs = "000f TAccessTextBox.accSelect 001a EmptyParam 0030 TAccessTextBox.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_651_0 {
	meta:
		name = "TAccessToggleButton.accSelect"
		size = 100
		refs = "000f TAccessToggleButton.accSelect 001a EmptyParam 0030 TAccessToggleButton.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3221_0 {
	meta:
		name = "TFormOld.accSelect"
		size = 100
		refs = "000f TFormOld.accSelect 001a EmptyParam 0030 TFormOld.GetDefaultInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_176_0 {
	meta:
		name = "TAccessLabel.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessLabel.accSelect 0044 TAccessLabel.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_419_0 {
	meta:
		name = "TAccessBoundObjectFrame.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.accSelect 0044 TAccessBoundObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_333_0 {
	meta:
		name = "TAccessCheckBox.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCheckBox.accSelect 0044 TAccessCheckBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2532_0 {
	meta:
		name = "TAccessComboBox.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessComboBox.accSelect 0044 TAccessComboBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_253_0 {
	meta:
		name = "TAccessCommandButton.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCommandButton.accSelect 0044 TAccessCommandButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2768_0 {
	meta:
		name = "TAccessCustomControl.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessCustomControl.accSelect 0044 TAccessCustomControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_4539_0 {
	meta:
		name = "TAccessForm.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessForm.accSelect 0044 TAccessForm.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2478_0 {
	meta:
		name = "TAccessListBox.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessListBox.accSelect 0044 TAccessListBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2585_0 {
	meta:
		name = "TAccessObjectFrame.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.accSelect 0044 TAccessObjectFrame.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_293_0 {
	meta:
		name = "TAccessOptionButton.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessOptionButton.accSelect 0044 TAccessOptionButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2330_0 {
	meta:
		name = "TAccessOptionGroup.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.accSelect 0044 TAccessOptionGroup.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_838_0 {
	meta:
		name = "TAccessPage.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessPage.accSelect 0044 TAccessPage.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_708_0 {
	meta:
		name = "TAccessSubForm.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessSubForm.accSelect 0044 TAccessSubForm.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2812_0 {
	meta:
		name = "TAccessTabControl.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessTabControl.accSelect 0044 TAccessTabControl.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2425_0 {
	meta:
		name = "TAccessTextBox.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessTextBox.accSelect 0044 TAccessTextBox.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_652_0 {
	meta:
		name = "TAccessToggleButton.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TAccessToggleButton.accSelect 0044 TAccessToggleButton.GetControlInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_3222_0 {
	meta:
		name = "TFormOld.accSelect"
		size = 130
		refs = "001f @VarAddRef 0027 TFormOld.accSelect 0044 TFormOld.GetDefaultInterface 0052 @CheckAutoResult 0067 @IntfClear 006f @VarClr 0075 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 54 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_177_0 {
	meta:
		name = "TAccessLabel.accLocation"
		size = 115
		refs = "0012 TAccessLabel.accLocation 001d EmptyParam 003c TAccessLabel.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_420_0 {
	meta:
		name = "TAccessBoundObjectFrame.accLocation"
		size = 115
		refs = "0012 TAccessBoundObjectFrame.accLocation 001d EmptyParam 003c TAccessBoundObjectFrame.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_334_0 {
	meta:
		name = "TAccessCheckBox.accLocation"
		size = 115
		refs = "0012 TAccessCheckBox.accLocation 001d EmptyParam 003c TAccessCheckBox.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2533_0 {
	meta:
		name = "TAccessComboBox.accLocation"
		size = 115
		refs = "0012 TAccessComboBox.accLocation 001d EmptyParam 003c TAccessComboBox.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_254_0 {
	meta:
		name = "TAccessCommandButton.accLocation"
		size = 115
		refs = "0012 TAccessCommandButton.accLocation 001d EmptyParam 003c TAccessCommandButton.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2769_0 {
	meta:
		name = "TAccessCustomControl.accLocation"
		size = 115
		refs = "0012 TAccessCustomControl.accLocation 001d EmptyParam 003c TAccessCustomControl.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_4540_0 {
	meta:
		name = "TAccessForm.accLocation"
		size = 115
		refs = "0012 TAccessForm.accLocation 001d EmptyParam 003c TAccessForm.GetDefaultInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2479_0 {
	meta:
		name = "TAccessListBox.accLocation"
		size = 115
		refs = "0012 TAccessListBox.accLocation 001d EmptyParam 003c TAccessListBox.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2586_0 {
	meta:
		name = "TAccessObjectFrame.accLocation"
		size = 115
		refs = "0012 TAccessObjectFrame.accLocation 001d EmptyParam 003c TAccessObjectFrame.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_294_0 {
	meta:
		name = "TAccessOptionButton.accLocation"
		size = 115
		refs = "0012 TAccessOptionButton.accLocation 001d EmptyParam 003c TAccessOptionButton.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2331_0 {
	meta:
		name = "TAccessOptionGroup.accLocation"
		size = 115
		refs = "0012 TAccessOptionGroup.accLocation 001d EmptyParam 003c TAccessOptionGroup.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_839_0 {
	meta:
		name = "TAccessPage.accLocation"
		size = 115
		refs = "0012 TAccessPage.accLocation 001d EmptyParam 003c TAccessPage.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_709_0 {
	meta:
		name = "TAccessSubForm.accLocation"
		size = 115
		refs = "0012 TAccessSubForm.accLocation 001d EmptyParam 003c TAccessSubForm.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2813_0 {
	meta:
		name = "TAccessTabControl.accLocation"
		size = 115
		refs = "0012 TAccessTabControl.accLocation 001d EmptyParam 003c TAccessTabControl.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_2426_0 {
	meta:
		name = "TAccessTextBox.accLocation"
		size = 115
		refs = "0012 TAccessTextBox.accLocation 001d EmptyParam 003c TAccessTextBox.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_653_0 {
	meta:
		name = "TAccessToggleButton.accLocation"
		size = 115
		refs = "0012 TAccessToggleButton.accLocation 001d EmptyParam 003c TAccessToggleButton.GetControlInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_3223_0 {
	meta:
		name = "TFormOld.accLocation"
		size = 115
		refs = "0012 TFormOld.accLocation 001d EmptyParam 003c TFormOld.GetDefaultInterface 004a @CheckAutoResult 005f @IntfClear 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8B 45 08 50 8B 45 0C 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 08 00 }
	condition:
		$1
}

rule function_178_0 {
	meta:
		name = "TAccessLabel.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessLabel.accLocation 0050 TAccessLabel.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_421_0 {
	meta:
		name = "TAccessBoundObjectFrame.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessBoundObjectFrame.accLocation 0050 TAccessBoundObjectFrame.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_335_0 {
	meta:
		name = "TAccessCheckBox.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessCheckBox.accLocation 0050 TAccessCheckBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2534_0 {
	meta:
		name = "TAccessComboBox.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessComboBox.accLocation 0050 TAccessComboBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_255_0 {
	meta:
		name = "TAccessCommandButton.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessCommandButton.accLocation 0050 TAccessCommandButton.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2770_0 {
	meta:
		name = "TAccessCustomControl.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessCustomControl.accLocation 0050 TAccessCustomControl.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_4541_0 {
	meta:
		name = "TAccessForm.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessForm.accLocation 0050 TAccessForm.GetDefaultInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2480_0 {
	meta:
		name = "TAccessListBox.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessListBox.accLocation 0050 TAccessListBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2587_0 {
	meta:
		name = "TAccessObjectFrame.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessObjectFrame.accLocation 0050 TAccessObjectFrame.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_295_0 {
	meta:
		name = "TAccessOptionButton.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessOptionButton.accLocation 0050 TAccessOptionButton.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2332_0 {
	meta:
		name = "TAccessOptionGroup.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessOptionGroup.accLocation 0050 TAccessOptionGroup.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_840_0 {
	meta:
		name = "TAccessPage.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessPage.accLocation 0050 TAccessPage.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_710_0 {
	meta:
		name = "TAccessSubForm.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessSubForm.accLocation 0050 TAccessSubForm.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2814_0 {
	meta:
		name = "TAccessTabControl.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessTabControl.accLocation 0050 TAccessTabControl.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_2427_0 {
	meta:
		name = "TAccessTextBox.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessTextBox.accLocation 0050 TAccessTextBox.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_654_0 {
	meta:
		name = "TAccessToggleButton.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TAccessToggleButton.accLocation 0050 TAccessToggleButton.GetControlInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_3224_0 {
	meta:
		name = "TFormOld.accLocation"
		size = 144
		refs = "0022 @VarAddRef 002a TFormOld.accLocation 0050 TFormOld.GetDefaultInterface 005e @CheckAutoResult 0073 @IntfClear 007b @VarClr 0081 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B 75 08 8D 7D F0 A5 A5 A5 A5 8B F9 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8B 45 0C 50 8B 45 10 50 57 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 58 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule function_179_0 {
	meta:
		name = "TAccessLabel.accNavigate"
		size = 112
		refs = "0012 TAccessLabel.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessLabel.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_422_0 {
	meta:
		name = "TAccessBoundObjectFrame.accNavigate"
		size = 112
		refs = "0012 TAccessBoundObjectFrame.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessBoundObjectFrame.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_336_0 {
	meta:
		name = "TAccessCheckBox.accNavigate"
		size = 112
		refs = "0012 TAccessCheckBox.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessCheckBox.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2535_0 {
	meta:
		name = "TAccessComboBox.accNavigate"
		size = 112
		refs = "0012 TAccessComboBox.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessComboBox.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_256_0 {
	meta:
		name = "TAccessCommandButton.accNavigate"
		size = 112
		refs = "0012 TAccessCommandButton.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessCommandButton.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2771_0 {
	meta:
		name = "TAccessCustomControl.accNavigate"
		size = 112
		refs = "0012 TAccessCustomControl.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessCustomControl.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_4542_0 {
	meta:
		name = "TAccessForm.accNavigate"
		size = 112
		refs = "0012 TAccessForm.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessForm.GetDefaultInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2481_0 {
	meta:
		name = "TAccessListBox.accNavigate"
		size = 112
		refs = "0012 TAccessListBox.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessListBox.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2588_0 {
	meta:
		name = "TAccessObjectFrame.accNavigate"
		size = 112
		refs = "0012 TAccessObjectFrame.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessObjectFrame.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_296_0 {
	meta:
		name = "TAccessOptionButton.accNavigate"
		size = 112
		refs = "0012 TAccessOptionButton.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessOptionButton.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2333_0 {
	meta:
		name = "TAccessOptionGroup.accNavigate"
		size = 112
		refs = "0012 TAccessOptionGroup.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessOptionGroup.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_841_0 {
	meta:
		name = "TAccessPage.accNavigate"
		size = 112
		refs = "0012 TAccessPage.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessPage.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_711_0 {
	meta:
		name = "TAccessSubForm.accNavigate"
		size = 112
		refs = "0012 TAccessSubForm.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessSubForm.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2815_0 {
	meta:
		name = "TAccessTabControl.accNavigate"
		size = 112
		refs = "0012 TAccessTabControl.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessTabControl.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_2428_0 {
	meta:
		name = "TAccessTextBox.accNavigate"
		size = 112
		refs = "0012 TAccessTextBox.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessTextBox.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_655_0 {
	meta:
		name = "TAccessToggleButton.accNavigate"
		size = 112
		refs = "0012 TAccessToggleButton.accNavigate 001f @VarClr 0025 EmptyParam 003b TAccessToggleButton.GetControlInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3225_0 {
	meta:
		name = "TFormOld.accNavigate"
		size = 112
		refs = "0012 TFormOld.accNavigate 001f @VarClr 0025 EmptyParam 003b TFormOld.GetDefaultInterface 0049 @CheckAutoResult 005e @IntfClear 0064 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C7 E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_180_0 {
	meta:
		name = "TAccessLabel.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessLabel.accNavigate 0035 @VarClr 004d TAccessLabel.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_423_0 {
	meta:
		name = "TAccessBoundObjectFrame.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessBoundObjectFrame.accNavigate 0035 @VarClr 004d TAccessBoundObjectFrame.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_337_0 {
	meta:
		name = "TAccessCheckBox.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessCheckBox.accNavigate 0035 @VarClr 004d TAccessCheckBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2536_0 {
	meta:
		name = "TAccessComboBox.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessComboBox.accNavigate 0035 @VarClr 004d TAccessComboBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_257_0 {
	meta:
		name = "TAccessCommandButton.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessCommandButton.accNavigate 0035 @VarClr 004d TAccessCommandButton.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2772_0 {
	meta:
		name = "TAccessCustomControl.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessCustomControl.accNavigate 0035 @VarClr 004d TAccessCustomControl.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_4543_0 {
	meta:
		name = "TAccessForm.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessForm.accNavigate 0035 @VarClr 004d TAccessForm.GetDefaultInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2482_0 {
	meta:
		name = "TAccessListBox.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessListBox.accNavigate 0035 @VarClr 004d TAccessListBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2589_0 {
	meta:
		name = "TAccessObjectFrame.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessObjectFrame.accNavigate 0035 @VarClr 004d TAccessObjectFrame.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_297_0 {
	meta:
		name = "TAccessOptionButton.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessOptionButton.accNavigate 0035 @VarClr 004d TAccessOptionButton.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2334_0 {
	meta:
		name = "TAccessOptionGroup.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessOptionGroup.accNavigate 0035 @VarClr 004d TAccessOptionGroup.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_842_0 {
	meta:
		name = "TAccessPage.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessPage.accNavigate 0035 @VarClr 004d TAccessPage.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_712_0 {
	meta:
		name = "TAccessSubForm.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessSubForm.accNavigate 0035 @VarClr 004d TAccessSubForm.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2816_0 {
	meta:
		name = "TAccessTabControl.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessTabControl.accNavigate 0035 @VarClr 004d TAccessTabControl.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_2429_0 {
	meta:
		name = "TAccessTextBox.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessTextBox.accNavigate 0035 @VarClr 004d TAccessTextBox.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_656_0 {
	meta:
		name = "TAccessToggleButton.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TAccessToggleButton.accNavigate 0035 @VarClr 004d TAccessToggleButton.GetControlInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_3226_0 {
	meta:
		name = "TFormOld.accNavigate"
		size = 141
		refs = "001f @VarAddRef 0027 TFormOld.accNavigate 0035 @VarClr 004d TFormOld.GetDefaultInterface 005b @CheckAutoResult 0070 @IntfClear 007e @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 DB 89 5D EC 8B F1 8D 7D F0 A5 A5 A5 A5 8B F2 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 56 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 5C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_181_0 {
	meta:
		name = "TAccessLabel.accHitTest"
		size = 100
		refs = "0012 TAccessLabel.accHitTest 0020 @VarClr 002d TAccessLabel.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "TAccessBoundObjectFrame.accHitTest"
		size = 100
		refs = "0012 TAccessBoundObjectFrame.accHitTest 0020 @VarClr 002d TAccessBoundObjectFrame.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_338_0 {
	meta:
		name = "TAccessCheckBox.accHitTest"
		size = 100
		refs = "0012 TAccessCheckBox.accHitTest 0020 @VarClr 002d TAccessCheckBox.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2537_0 {
	meta:
		name = "TAccessComboBox.accHitTest"
		size = 100
		refs = "0012 TAccessComboBox.accHitTest 0020 @VarClr 002d TAccessComboBox.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_258_0 {
	meta:
		name = "TAccessCommandButton.accHitTest"
		size = 100
		refs = "0012 TAccessCommandButton.accHitTest 0020 @VarClr 002d TAccessCommandButton.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2773_0 {
	meta:
		name = "TAccessCustomControl.accHitTest"
		size = 100
		refs = "0012 TAccessCustomControl.accHitTest 0020 @VarClr 002d TAccessCustomControl.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_4544_0 {
	meta:
		name = "TAccessForm.accHitTest"
		size = 100
		refs = "0012 TAccessForm.accHitTest 0020 @VarClr 002d TAccessForm.GetDefaultInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2483_0 {
	meta:
		name = "TAccessListBox.accHitTest"
		size = 100
		refs = "0012 TAccessListBox.accHitTest 0020 @VarClr 002d TAccessListBox.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2590_0 {
	meta:
		name = "TAccessObjectFrame.accHitTest"
		size = 100
		refs = "0012 TAccessObjectFrame.accHitTest 0020 @VarClr 002d TAccessObjectFrame.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_298_0 {
	meta:
		name = "TAccessOptionButton.accHitTest"
		size = 100
		refs = "0012 TAccessOptionButton.accHitTest 0020 @VarClr 002d TAccessOptionButton.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2335_0 {
	meta:
		name = "TAccessOptionGroup.accHitTest"
		size = 100
		refs = "0012 TAccessOptionGroup.accHitTest 0020 @VarClr 002d TAccessOptionGroup.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_843_0 {
	meta:
		name = "TAccessPage.accHitTest"
		size = 100
		refs = "0012 TAccessPage.accHitTest 0020 @VarClr 002d TAccessPage.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_713_0 {
	meta:
		name = "TAccessSubForm.accHitTest"
		size = 100
		refs = "0012 TAccessSubForm.accHitTest 0020 @VarClr 002d TAccessSubForm.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2817_0 {
	meta:
		name = "TAccessTabControl.accHitTest"
		size = 100
		refs = "0012 TAccessTabControl.accHitTest 0020 @VarClr 002d TAccessTabControl.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_2430_0 {
	meta:
		name = "TAccessTextBox.accHitTest"
		size = 100
		refs = "0012 TAccessTextBox.accHitTest 0020 @VarClr 002d TAccessTextBox.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_657_0 {
	meta:
		name = "TAccessToggleButton.accHitTest"
		size = 100
		refs = "0012 TAccessToggleButton.accHitTest 0020 @VarClr 002d TAccessToggleButton.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_3227_0 {
	meta:
		name = "TFormOld.accHitTest"
		size = 100
		refs = "0012 TFormOld.accHitTest 0020 @VarClr 002d TFormOld.GetDefaultInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 60 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_182_0 {
	meta:
		name = "TAccessLabel.accDoDefaultAction"
		size = 95
		refs = "000c TAccessLabel.accDoDefaultAction 0017 EmptyParam 002c TAccessLabel.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_425_0 {
	meta:
		name = "TAccessBoundObjectFrame.accDoDefaultAction"
		size = 95
		refs = "000c TAccessBoundObjectFrame.accDoDefaultAction 0017 EmptyParam 002c TAccessBoundObjectFrame.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_339_0 {
	meta:
		name = "TAccessCheckBox.accDoDefaultAction"
		size = 95
		refs = "000c TAccessCheckBox.accDoDefaultAction 0017 EmptyParam 002c TAccessCheckBox.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2538_0 {
	meta:
		name = "TAccessComboBox.accDoDefaultAction"
		size = 95
		refs = "000c TAccessComboBox.accDoDefaultAction 0017 EmptyParam 002c TAccessComboBox.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_259_0 {
	meta:
		name = "TAccessCommandButton.accDoDefaultAction"
		size = 95
		refs = "000c TAccessCommandButton.accDoDefaultAction 0017 EmptyParam 002c TAccessCommandButton.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2774_0 {
	meta:
		name = "TAccessCustomControl.accDoDefaultAction"
		size = 95
		refs = "000c TAccessCustomControl.accDoDefaultAction 0017 EmptyParam 002c TAccessCustomControl.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_4545_0 {
	meta:
		name = "TAccessForm.accDoDefaultAction"
		size = 95
		refs = "000c TAccessForm.accDoDefaultAction 0017 EmptyParam 002c TAccessForm.GetDefaultInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2484_0 {
	meta:
		name = "TAccessListBox.accDoDefaultAction"
		size = 95
		refs = "000c TAccessListBox.accDoDefaultAction 0017 EmptyParam 002c TAccessListBox.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2591_0 {
	meta:
		name = "TAccessObjectFrame.accDoDefaultAction"
		size = 95
		refs = "000c TAccessObjectFrame.accDoDefaultAction 0017 EmptyParam 002c TAccessObjectFrame.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_299_0 {
	meta:
		name = "TAccessOptionButton.accDoDefaultAction"
		size = 95
		refs = "000c TAccessOptionButton.accDoDefaultAction 0017 EmptyParam 002c TAccessOptionButton.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2336_0 {
	meta:
		name = "TAccessOptionGroup.accDoDefaultAction"
		size = 95
		refs = "000c TAccessOptionGroup.accDoDefaultAction 0017 EmptyParam 002c TAccessOptionGroup.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_844_0 {
	meta:
		name = "TAccessPage.accDoDefaultAction"
		size = 95
		refs = "000c TAccessPage.accDoDefaultAction 0017 EmptyParam 002c TAccessPage.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_714_0 {
	meta:
		name = "TAccessSubForm.accDoDefaultAction"
		size = 95
		refs = "000c TAccessSubForm.accDoDefaultAction 0017 EmptyParam 002c TAccessSubForm.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2818_0 {
	meta:
		name = "TAccessTabControl.accDoDefaultAction"
		size = 95
		refs = "000c TAccessTabControl.accDoDefaultAction 0017 EmptyParam 002c TAccessTabControl.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_2431_0 {
	meta:
		name = "TAccessTextBox.accDoDefaultAction"
		size = 95
		refs = "000c TAccessTextBox.accDoDefaultAction 0017 EmptyParam 002c TAccessTextBox.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_658_0 {
	meta:
		name = "TAccessToggleButton.accDoDefaultAction"
		size = 95
		refs = "000c TAccessToggleButton.accDoDefaultAction 0017 EmptyParam 002c TAccessToggleButton.GetControlInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_3228_0 {
	meta:
		name = "TFormOld.accDoDefaultAction"
		size = 95
		refs = "000c TFormOld.accDoDefaultAction 0017 EmptyParam 002c TFormOld.GetDefaultInterface 003a @CheckAutoResult 004f @IntfClear 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? FF 70 0C FF 70 08 FF 70 04 FF 30 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_183_0 {
	meta:
		name = "TAccessLabel.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessLabel.accDoDefaultAction 0041 TAccessLabel.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "TAccessBoundObjectFrame.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessBoundObjectFrame.accDoDefaultAction 0041 TAccessBoundObjectFrame.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2292_0 {
	meta:
		name = "TAccessCheckBox.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessCheckBox.accDoDefaultAction 0041 TAccessCheckBox.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2539_0 {
	meta:
		name = "TAccessComboBox.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessComboBox.accDoDefaultAction 0041 TAccessComboBox.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_260_0 {
	meta:
		name = "TAccessCommandButton.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessCommandButton.accDoDefaultAction 0041 TAccessCommandButton.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_769_0 {
	meta:
		name = "TAccessCustomControl.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessCustomControl.accDoDefaultAction 0041 TAccessCustomControl.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_1211_0 {
	meta:
		name = "TAccessForm.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessForm.accDoDefaultAction 0041 TAccessForm.GetDefaultInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_515_0 {
	meta:
		name = "TAccessListBox.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessListBox.accDoDefaultAction 0041 TAccessListBox.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_606_0 {
	meta:
		name = "TAccessObjectFrame.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessObjectFrame.accDoDefaultAction 0041 TAccessObjectFrame.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_300_0 {
	meta:
		name = "TAccessOptionButton.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessOptionButton.accDoDefaultAction 0041 TAccessOptionButton.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2337_0 {
	meta:
		name = "TAccessOptionGroup.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessOptionGroup.accDoDefaultAction 0041 TAccessOptionGroup.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_845_0 {
	meta:
		name = "TAccessPage.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessPage.accDoDefaultAction 0041 TAccessPage.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_715_0 {
	meta:
		name = "TAccessSubForm.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessSubForm.accDoDefaultAction 0041 TAccessSubForm.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_809_0 {
	meta:
		name = "TAccessTabControl.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessTabControl.accDoDefaultAction 0041 TAccessTabControl.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_2432_0 {
	meta:
		name = "TAccessTextBox.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessTextBox.accDoDefaultAction 0041 TAccessTextBox.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_659_0 {
	meta:
		name = "TAccessToggleButton.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessToggleButton.accDoDefaultAction 0041 TAccessToggleButton.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_3229_0 {
	meta:
		name = "TFormOld.accDoDefaultAction"
		size = 127
		refs = "001d @VarAddRef 0025 TFormOld.accDoDefaultAction 0041 TFormOld.GetDefaultInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_79433_0 {
	meta:
		name = "TShellNameSpace.Set_Root"
		size = 127
		refs = "001d @VarAddRef 0025 TShellNameSpace.Set_Root 0041 TShellNameSpace.GetDefaultInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 64 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_184_0 {
	meta:
		name = "TAccessLabel.SizeToFit"
		size = 79
		refs = "000c TAccessLabel.SizeToFit 001c TAccessLabel.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_562_0 {
	meta:
		name = "TAccessComboBox.Dropdown"
		size = 79
		refs = "000c TAccessComboBox.Dropdown 001c TAccessComboBox.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_846_0 {
	meta:
		name = "TAccessPage.SizeToFit"
		size = 79
		refs = "000c TAccessPage.SizeToFit 001c TAccessPage.GetControlInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_70076_0 {
	meta:
		name = "TExplorer.Activate"
		size = 79
		refs = "000c TExplorer.Activate 001c TExplorer.GetDefaultInterface 002a @CheckAutoResult 003f @IntfClear 0045 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 7C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_185_0 {
	meta:
		name = "TAccessLabel._Evaluate"
		size = 103
		refs = "0012 TAccessLabel._Evaluate 0020 @VarClr 002d TAccessLabel.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_847_0 {
	meta:
		name = "TAccessPage._Evaluate"
		size = 103
		refs = "0012 TAccessPage._Evaluate 0020 @VarClr 002d TAccessPage.GetControlInterface 003e @CheckAutoResult 0053 @IntfClear 0059 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 90 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_187_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 F0 02 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 4A E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_192_0 {
	meta:
		name = "TAccessRectangle.Get_Properties"
		size = 91
		refs = "000f TAccessRectangle.Get_Properties 001c @IntfClear 0027 TAccessRectangle.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1441_0 {
	meta:
		name = "TAccessApplication.Get_CodeContextObject"
		size = 91
		refs = "000f TAccessApplication.Get_CodeContextObject 001c @IntfClear 0027 TAccessApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_865_0 {
	meta:
		name = "TAccessGroupLevel.Get_Properties"
		size = 91
		refs = "000f TAccessGroupLevel.Get_Properties 001c @IntfClear 0027 TAccessGroupLevel.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_201_0 {
	meta:
		name = "TAccessLine.Get_Properties"
		size = 91
		refs = "000f TAccessLine.Get_Properties 001c @IntfClear 0027 TAccessLine.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_618_0 {
	meta:
		name = "TAccessPageBreak.Get_Properties"
		size = 91
		refs = "000f TAccessPageBreak.Get_Properties 001c @IntfClear 0027 TAccessPageBreak.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1232_0 {
	meta:
		name = "TAccessReport.Get_RecordSource"
		size = 91
		refs = "000f TAccessReport.Get_RecordSource 001c @WStrClr 0027 TAccessReport.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_857_0 {
	meta:
		name = "TAccessSection.Get_Properties"
		size = 91
		refs = "000f TAccessSection.Get_Properties 001c @IntfClear 0027 TAccessSection.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_727_0 {
	meta:
		name = "TAccessSubReport.Get_Form"
		size = 91
		refs = "000f TAccessSubReport.Get_Form 001c @IntfClear 0027 TAccessSubReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70259_0 {
	meta:
		name = "TAppointmentItem.Get_Session"
		size = 91
		refs = "000f TAppointmentItem.Get_Session 001c @IntfClear 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9233_0 {
	meta:
		name = "TBinder.Get_ActiveSection"
		size = 91
		refs = "000f TBinder.Get_ActiveSection 001c @IntfClear 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_11443_0 {
	meta:
		name = "TCOMAdminCatalogObject.Get_Key"
		size = 91
		refs = "000f TCOMAdminCatalogObject.Get_Key 001c @VarClr 0027 TCOMAdminCatalogObject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1873_0 {
	meta:
		name = "TCodeData.Get_AllViews"
		size = 91
		refs = "000f TCodeData.Get_AllViews 001c @IntfClear 0027 TCodeData.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1844_0 {
	meta:
		name = "TCodeProject.Get_AllMacros"
		size = 91
		refs = "000f TCodeProject.Get_AllMacros 001c @IntfClear 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70639_0 {
	meta:
		name = "TContactItem.Get_Session"
		size = 91
		refs = "000f TContactItem.Get_Session 001c @IntfClear 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1830_0 {
	meta:
		name = "TCurrentData.Get_AllViews"
		size = 91
		refs = "000f TCurrentData.Get_AllViews 001c @IntfClear 0027 TCurrentData.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3841_0 {
	meta:
		name = "TCurrentProject.Get_AllMacros"
		size = 91
		refs = "000f TCurrentProject.Get_AllMacros 001c @IntfClear 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70916_0 {
	meta:
		name = "TDistListItem.Get_Session"
		size = 91
		refs = "000f TDistListItem.Get_Session 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70989_0 {
	meta:
		name = "TDocumentItem.Get_Session"
		size = 91
		refs = "000f TDocumentItem.Get_Session 001c @IntfClear 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46106_0 {
	meta:
		name = "TExcelApplication.Get_Parent"
		size = 91
		refs = "000f TExcelApplication.Get_Parent 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_46687_0 {
	meta:
		name = "TExcelChart.Get_Parent"
		size = 91
		refs = "000f TExcelChart.Get_Parent 001c @IntfClear 0027 TExcelChart.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47263_0 {
	meta:
		name = "TExcelGlobal.Get_Parent"
		size = 91
		refs = "000f TExcelGlobal.Get_Parent 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47455_0 {
	meta:
		name = "TExcelWorkbook.Get_Parent"
		size = 91
		refs = "000f TExcelWorkbook.Get_Parent 001c @IntfClear 0027 TExcelWorkbook.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_48964_0 {
	meta:
		name = "TExcelWorksheet.Get_Parent"
		size = 91
		refs = "000f TExcelWorksheet.Get_Parent 001c @IntfClear 0027 TExcelWorksheet.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71842_0 {
	meta:
		name = "TExplorer.Get_Session"
		size = 91
		refs = "000f TExplorer.Get_Session 001c @IntfClear 0027 TExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72907_0 {
	meta:
		name = "TExplorers.Get_Session"
		size = 91
		refs = "000f TExplorers.Get_Session 001c @IntfClear 0027 TExplorers.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71085_0 {
	meta:
		name = "TFolders.Get_Session"
		size = 91
		refs = "000f TFolders.Get_Session 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70091_0 {
	meta:
		name = "TInspector.Get_Session"
		size = 91
		refs = "000f TInspector.Get_Session 001c @IntfClear 0027 TInspector.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71068_0 {
	meta:
		name = "TInspectors.Get_Session"
		size = 91
		refs = "000f TInspectors.Get_Session 001c @IntfClear 0027 TInspectors.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72965_0 {
	meta:
		name = "TItems.Get_Session"
		size = 91
		refs = "000f TItems.Get_Session 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71142_0 {
	meta:
		name = "TJournalItem.Get_Session"
		size = 91
		refs = "000f TJournalItem.Get_Session 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70130_0 {
	meta:
		name = "TMailItem.Get_Session"
		size = 91
		refs = "000f TMailItem.Get_Session 001c @IntfClear 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67422_0 {
	meta:
		name = "TMaster.Get_Shapes"
		size = 91
		refs = "000f TMaster.Get_Shapes 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70385_0 {
	meta:
		name = "TMeetingItem.Get_Session"
		size = 91
		refs = "000f TMeetingItem.Get_Session 001c @IntfClear 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71228_0 {
	meta:
		name = "TNameSpace.Get_Session"
		size = 91
		refs = "000f TNameSpace.Get_Session 001c @IntfClear 0027 TNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73130_0 {
	meta:
		name = "TNoteItem.Get_Session"
		size = 91
		refs = "000f TNoteItem.Get_Session 001c @IntfClear 0027 TNoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72427_0 {
	meta:
		name = "TOutlookApplication.Get_Session"
		size = 91
		refs = "000f TOutlookApplication.Get_Session 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73183_0 {
	meta:
		name = "TOutlookBarGroups.Get_Session"
		size = 91
		refs = "000f TOutlookBarGroups.Get_Session 001c @IntfClear 0027 TOutlookBarGroups.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73202_0 {
	meta:
		name = "TOutlookBarPane.Get_Session"
		size = 91
		refs = "000f TOutlookBarPane.Get_Session 001c @IntfClear 0027 TOutlookBarPane.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73222_0 {
	meta:
		name = "TOutlookBarShortcuts.Get_Session"
		size = 91
		refs = "000f TOutlookBarShortcuts.Get_Session 001c @IntfClear 0027 TOutlookBarShortcuts.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73241_0 {
	meta:
		name = "TPostItem.Get_Session"
		size = 91
		refs = "000f TPostItem.Get_Session 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74451_0 {
	meta:
		name = "TPowerPointApplication.Get_Dialogs"
		size = 91
		refs = "000f TPowerPointApplication.Get_Dialogs 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74252_0 {
	meta:
		name = "TPowerPointGlobal.Get_AddIns"
		size = 91
		refs = "000f TPowerPointGlobal.Get_AddIns 001c @IntfClear 0027 TPowerPointGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74320_0 {
	meta:
		name = "TPowerPointPresentation.Get_SlideMaster"
		size = 91
		refs = "000f TPowerPointPresentation.Get_SlideMaster 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74273_0 {
	meta:
		name = "TPowerPointSlide.Get_Shapes"
		size = 91
		refs = "000f TPowerPointSlide.Get_Shapes 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73792_0 {
	meta:
		name = "TReminder.Get_Session"
		size = 91
		refs = "000f TReminder.Get_Session 001c @IntfClear 0027 TReminder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73814_0 {
	meta:
		name = "TReminders.Get_Session"
		size = 91
		refs = "000f TReminders.Get_Session 001c @IntfClear 0027 TReminders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71443_0 {
	meta:
		name = "TRemoteItem.Get_Session"
		size = 91
		refs = "000f TRemoteItem.Get_Session 001c @IntfClear 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71509_0 {
	meta:
		name = "TReportItem.Get_Session"
		size = 91
		refs = "000f TReportItem.Get_Session 001c @IntfClear 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3250_0 {
	meta:
		name = "TReportOld.Get_RecordSource"
		size = 91
		refs = "000f TReportOld.Get_RecordSource 001c @WStrClr 0027 TReportOld.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73747_0 {
	meta:
		name = "TResults.Get_Session"
		size = 91
		refs = "000f TResults.Get_Session 001c @IntfClear 0027 TResults.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79378_0 {
	meta:
		name = "TShellWindows._NewEnum"
		size = 91
		refs = "000f TShellWindows._NewEnum 001c @IntfClear 0027 TShellWindows.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71825_0 {
	meta:
		name = "TSyncObject.Get_Session"
		size = 91
		refs = "000f TSyncObject.Get_Session 001c @IntfClear 0027 TSyncObject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72296_0 {
	meta:
		name = "TTaskItem.Get_Session"
		size = 91
		refs = "000f TTaskItem.Get_Session 001c @IntfClear 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73465_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Session"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Session 001c @IntfClear 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73534_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Session"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Session 001c @IntfClear 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71697_0 {
	meta:
		name = "TTaskRequestItem.Get_Session"
		size = 91
		refs = "000f TTaskRequestItem.Get_Session 001c @IntfClear 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71760_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Session"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Session 001c @IntfClear 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73774_0 {
	meta:
		name = "TViews.Get_Session"
		size = 91
		refs = "000f TViews.Get_Session 001c @IntfClear 0027 TViews.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99574_0 {
	meta:
		name = "TWordApplication.Get_Parent"
		size = 91
		refs = "000f TWordApplication.Get_Parent 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99285_0 {
	meta:
		name = "TWordFont.Get_Parent"
		size = 91
		refs = "000f TWordFont.Get_Parent 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98816_0 {
	meta:
		name = "TWordGlobal.Get_Parent"
		size = 91
		refs = "000f TWordGlobal.Get_Parent 001c @IntfClear 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99498_0 {
	meta:
		name = "TWordLetterContent.Get_Parent"
		size = 91
		refs = "000f TWordLetterContent.Get_Parent 001c @IntfClear 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99375_0 {
	meta:
		name = "TWordParagraphFormat.Get_Parent"
		size = 91
		refs = "000f TWordParagraphFormat.Get_Parent 001c @IntfClear 0027 TWordParagraphFormat.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 24 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_194_0 {
	meta:
		name = "TAccessRectangle._Evaluate"
		size = 100
		refs = "0012 TAccessRectangle._Evaluate 0020 @VarClr 002d TAccessRectangle.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_203_0 {
	meta:
		name = "TAccessLine._Evaluate"
		size = 100
		refs = "0012 TAccessLine._Evaluate 0020 @VarClr 002d TAccessLine.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_620_0 {
	meta:
		name = "TAccessPageBreak._Evaluate"
		size = 100
		refs = "0012 TAccessPageBreak._Evaluate 0020 @VarClr 002d TAccessPageBreak.GetControlInterface 003b @CheckAutoResult 0050 @IntfClear 0056 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 45 08 E8 ?? ?? ?? ?? 50 57 56 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 2C E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 59 5D C2 04 00 }
	condition:
		$1
}

rule function_196_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 F0 02 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 4C E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_205_0 {
	meta:
		name = "DoCreate"
		size = 132
		refs = "000e DoCreate 0022 TOleControl.GetOleObject 002d @VarToIntf 0045 @IntfCast 005a @VarClr 0062 @IntfClear 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C9 51 51 51 51 51 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B 45 08 8B 40 FC E8 ?? ?? ?? ?? 8D 55 EC 8D 45 FC E8 ?? ?? ?? ?? 8B 55 FC 8B 45 08 8B 40 FC 05 F0 02 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 8B E5 5D C3 00 00 4E E9 06 3B 7C E4 CD 11 87 01 00 AA 00 3F 0F 07 }
	condition:
		$1
}

rule function_211_0 {
	meta:
		name = "TAccessImage.Get_Properties"
		size = 91
		refs = "000f TAccessImage.Get_Properties 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_673_0 {
	meta:
		name = "TAccessPaletteButton.Get_Properties"
		size = 91
		refs = "000f TAccessPaletteButton.Get_Properties 001c @IntfClear 0027 TAccessPaletteButton.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1630_0 {
	meta:
		name = "TAccessReferences._NewEnum"
		size = 91
		refs = "000f TAccessReferences._NewEnum 001c @IntfClear 0027 TAccessReferences.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_858_0 {
	meta:
		name = "TAccessSection.Get_Controls"
		size = 91
		refs = "000f TAccessSection.Get_Controls 001c @IntfClear 0027 TAccessSection.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_728_0 {
	meta:
		name = "TAccessSubReport.Get_Report"
		size = 91
		refs = "000f TAccessSubReport.Get_Report 001c @IntfClear 0027 TAccessSubReport.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72060_0 {
	meta:
		name = "TAppointmentItem.Get_Parent"
		size = 91
		refs = "000f TAppointmentItem.Get_Parent 001c @IntfClear 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_9234_0 {
	meta:
		name = "TBinder.Get_Sections"
		size = 91
		refs = "000f TBinder.Get_Sections 001c @IntfClear 0027 TBinder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_11444_0 {
	meta:
		name = "TCOMAdminCatalogObject.Get_Name"
		size = 91
		refs = "000f TCOMAdminCatalogObject.Get_Name 001c @VarClr 0027 TCOMAdminCatalogObject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1874_0 {
	meta:
		name = "TCodeData.Get_AllStoredProcedures"
		size = 91
		refs = "000f TCodeData.Get_AllStoredProcedures 001c @IntfClear 0027 TCodeData.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1845_0 {
	meta:
		name = "TCodeProject.Get_AllModules"
		size = 91
		refs = "000f TCodeProject.Get_AllModules 001c @IntfClear 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72470_0 {
	meta:
		name = "TContactItem.Get_Parent"
		size = 91
		refs = "000f TContactItem.Get_Parent 001c @IntfClear 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3875_0 {
	meta:
		name = "TCurrentData.Get_AllStoredProcedures"
		size = 91
		refs = "000f TCurrentData.Get_AllStoredProcedures 001c @IntfClear 0027 TCurrentData.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_3842_0 {
	meta:
		name = "TCurrentProject.Get_AllModules"
		size = 91
		refs = "000f TCurrentProject.Get_AllModules 001c @IntfClear 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70917_0 {
	meta:
		name = "TDistListItem.Get_Parent"
		size = 91
		refs = "000f TDistListItem.Get_Parent 001c @IntfClear 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70990_0 {
	meta:
		name = "TDocumentItem.Get_Parent"
		size = 91
		refs = "000f TDocumentItem.Get_Parent 001c @IntfClear 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47932_0 {
	meta:
		name = "TExcelApplication.Get_ActiveCell"
		size = 91
		refs = "000f TExcelApplication.Get_ActiveCell 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_49278_0 {
	meta:
		name = "TExcelGlobal.Get_ActiveCell"
		size = 91
		refs = "000f TExcelGlobal.Get_ActiveCell 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70054_0 {
	meta:
		name = "TExplorer.Get_Parent"
		size = 91
		refs = "000f TExplorer.Get_Parent 001c @IntfClear 0027 TExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72908_0 {
	meta:
		name = "TExplorers.Get_Parent"
		size = 91
		refs = "000f TExplorers.Get_Parent 001c @IntfClear 0027 TExplorers.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72942_0 {
	meta:
		name = "TFolders.Get_Parent"
		size = 91
		refs = "000f TFolders.Get_Parent 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70092_0 {
	meta:
		name = "TInspector.Get_Parent"
		size = 91
		refs = "000f TInspector.Get_Parent 001c @IntfClear 0027 TInspector.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72925_0 {
	meta:
		name = "TInspectors.Get_Parent"
		size = 91
		refs = "000f TInspectors.Get_Parent 001c @IntfClear 0027 TInspectors.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71110_0 {
	meta:
		name = "TItems.Get_Parent"
		size = 91
		refs = "000f TItems.Get_Parent 001c @IntfClear 0027 TItems.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71143_0 {
	meta:
		name = "TJournalItem.Get_Parent"
		size = 91
		refs = "000f TJournalItem.Get_Parent 001c @IntfClear 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70131_0 {
	meta:
		name = "TMailItem.Get_Parent"
		size = 91
		refs = "000f TMailItem.Get_Parent 001c @IntfClear 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67423_0 {
	meta:
		name = "TMaster.Get_HeadersFooters"
		size = 91
		refs = "000f TMaster.Get_HeadersFooters 001c @IntfClear 0027 TMaster.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72194_0 {
	meta:
		name = "TMeetingItem.Get_Parent"
		size = 91
		refs = "000f TMeetingItem.Get_Parent 001c @IntfClear 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71229_0 {
	meta:
		name = "TNameSpace.Get_Parent"
		size = 91
		refs = "000f TNameSpace.Get_Parent 001c @IntfClear 0027 TNameSpace.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71265_0 {
	meta:
		name = "TNoteItem.Get_Parent"
		size = 91
		refs = "000f TNoteItem.Get_Parent 001c @IntfClear 0027 TNoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72428_0 {
	meta:
		name = "TOutlookApplication.Get_Parent"
		size = 91
		refs = "000f TOutlookApplication.Get_Parent 001c @IntfClear 0027 TOutlookApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73184_0 {
	meta:
		name = "TOutlookBarGroups.Get_Parent"
		size = 91
		refs = "000f TOutlookBarGroups.Get_Parent 001c @IntfClear 0027 TOutlookBarGroups.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73203_0 {
	meta:
		name = "TOutlookBarPane.Get_Parent"
		size = 91
		refs = "000f TOutlookBarPane.Get_Parent 001c @IntfClear 0027 TOutlookBarPane.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73223_0 {
	meta:
		name = "TOutlookBarShortcuts.Get_Parent"
		size = 91
		refs = "000f TOutlookBarShortcuts.Get_Parent 001c @IntfClear 0027 TOutlookBarShortcuts.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_6418_0 {
	meta:
		name = "TParameter.GetValue"
		size = 91
		refs = "000f TParameter.GetValue 001c @VarClr 0027 TParameter.GetParameter 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73242_0 {
	meta:
		name = "TPostItem.Get_Parent"
		size = 91
		refs = "000f TPostItem.Get_Parent 001c @IntfClear 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74452_0 {
	meta:
		name = "TPowerPointApplication.Get_ActiveWindow"
		size = 91
		refs = "000f TPowerPointApplication.Get_ActiveWindow 001c @IntfClear 0027 TPowerPointApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74253_0 {
	meta:
		name = "TPowerPointGlobal.Get_Application"
		size = 91
		refs = "000f TPowerPointGlobal.Get_Application 001c @IntfClear 0027 TPowerPointGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74321_0 {
	meta:
		name = "TPowerPointPresentation.Get_TitleMaster"
		size = 91
		refs = "000f TPowerPointPresentation.Get_TitleMaster 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67218_0 {
	meta:
		name = "TPowerPointSlide.Get_HeadersFooters"
		size = 91
		refs = "000f TPowerPointSlide.Get_HeadersFooters 001c @IntfClear 0027 TPowerPointSlide.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73793_0 {
	meta:
		name = "TReminder.Get_Parent"
		size = 91
		refs = "000f TReminder.Get_Parent 001c @IntfClear 0027 TReminder.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73815_0 {
	meta:
		name = "TReminders.Get_Parent"
		size = 91
		refs = "000f TReminders.Get_Parent 001c @IntfClear 0027 TReminders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71444_0 {
	meta:
		name = "TRemoteItem.Get_Parent"
		size = 91
		refs = "000f TRemoteItem.Get_Parent 001c @IntfClear 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71510_0 {
	meta:
		name = "TReportItem.Get_Parent"
		size = 91
		refs = "000f TReportItem.Get_Parent 001c @IntfClear 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73748_0 {
	meta:
		name = "TResults.Get_Parent"
		size = 91
		refs = "000f TResults.Get_Parent 001c @IntfClear 0027 TResults.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70037_0 {
	meta:
		name = "TSyncObject.Get_Parent"
		size = 91
		refs = "000f TSyncObject.Get_Parent 001c @IntfClear 0027 TSyncObject.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72297_0 {
	meta:
		name = "TTaskItem.Get_Parent"
		size = 91
		refs = "000f TTaskItem.Get_Parent 001c @IntfClear 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71572_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Parent"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Parent 001c @IntfClear 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73535_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Parent"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Parent 001c @IntfClear 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73604_0 {
	meta:
		name = "TTaskRequestItem.Get_Parent"
		size = 91
		refs = "000f TTaskRequestItem.Get_Parent 001c @IntfClear 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73673_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Parent"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Parent 001c @IntfClear 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73775_0 {
	meta:
		name = "TViews.Get_Parent"
		size = 91
		refs = "000f TViews.Get_Parent 001c @IntfClear 0027 TViews.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_100753_0 {
	meta:
		name = "TWordApplication.Get_Name"
		size = 91
		refs = "000f TWordApplication.Get_Name 001c @WStrClr 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98935_0 {
	meta:
		name = "TWordDocument.Get_Parent"
		size = 91
		refs = "000f TWordDocument.Get_Parent 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99286_0 {
	meta:
		name = "TWordFont.Get_Duplicate"
		size = 91
		refs = "000f TWordFont.Get_Duplicate 001c @IntfClear 0027 TWordFont.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99885_0 {
	meta:
		name = "TWordGlobal.Get_Name"
		size = 91
		refs = "000f TWordGlobal.Get_Name 001c @WStrClr 0027 TWordGlobal.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99499_0 {
	meta:
		name = "TWordLetterContent.Get_Duplicate"
		size = 91
		refs = "000f TWordLetterContent.Get_Duplicate 001c @IntfClear 0027 TWordLetterContent.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99376_0 {
	meta:
		name = "TWordParagraphFormat.Get_Duplicate"
		size = 91
		refs = "000f TWordParagraphFormat.Get_Duplicate 001c @IntfClear 0027 TWordParagraphFormat.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 28 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_213_0 {
	meta:
		name = "TAccessImage.Get_Hyperlink"
		size = 91
		refs = "000f TAccessImage.Get_Hyperlink 001c @IntfClear 0027 TAccessImage.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72067_0 {
	meta:
		name = "TAppointmentItem.Get_Categories"
		size = 91
		refs = "000f TAppointmentItem.Get_Categories 001c @WStrClr 0027 TAppointmentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1850_0 {
	meta:
		name = "TCodeProject.Get_Name"
		size = 91
		refs = "000f TCodeProject.Get_Name 001c @WStrClr 0027 TCodeProject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72477_0 {
	meta:
		name = "TContactItem.Get_Categories"
		size = 91
		refs = "000f TContactItem.Get_Categories 001c @WStrClr 0027 TContactItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1807_0 {
	meta:
		name = "TCurrentProject.Get_Name"
		size = 91
		refs = "000f TCurrentProject.Get_Name 001c @WStrClr 0027 TCurrentProject.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_1653_0 {
	meta:
		name = "TDataAccessPage.Get_Parent"
		size = 91
		refs = "000f TDataAccessPage.Get_Parent 001c @IntfClear 0027 TDataAccessPage.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72766_0 {
	meta:
		name = "TDistListItem.Get_Categories"
		size = 91
		refs = "000f TDistListItem.Get_Categories 001c @WStrClr 0027 TDistListItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72847_0 {
	meta:
		name = "TDocumentItem.Get_Categories"
		size = 91
		refs = "000f TDocumentItem.Get_Categories 001c @WStrClr 0027 TDocumentItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_47939_0 {
	meta:
		name = "TExcelApplication.Get_ActiveWindow"
		size = 91
		refs = "000f TExcelApplication.Get_ActiveWindow 001c @IntfClear 0027 TExcelApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_49285_0 {
	meta:
		name = "TExcelGlobal.Get_ActiveWindow"
		size = 91
		refs = "000f TExcelGlobal.Get_ActiveWindow 001c @IntfClear 0027 TExcelGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72950_0 {
	meta:
		name = "TFolders.GetNext"
		size = 91
		refs = "000f TFolders.GetNext 001c @IntfClear 0027 TFolders.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79288_0 {
	meta:
		name = "TInternetExplorer.Get_Container"
		size = 91
		refs = "000f TInternetExplorer.Get_Container 001c @IntfClear 0027 TInternetExplorer.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73006_0 {
	meta:
		name = "TJournalItem.Get_Categories"
		size = 91
		refs = "000f TJournalItem.Get_Categories 001c @WStrClr 0027 TJournalItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71928_0 {
	meta:
		name = "TMailItem.Get_Categories"
		size = 91
		refs = "000f TMailItem.Get_Categories 001c @WStrClr 0027 TMailItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_72201_0 {
	meta:
		name = "TMeetingItem.Get_Categories"
		size = 91
		refs = "000f TMeetingItem.Get_Categories 001c @WStrClr 0027 TMeetingItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71378_0 {
	meta:
		name = "TPostItem.Get_Categories"
		size = 91
		refs = "000f TPostItem.Get_Categories 001c @WStrClr 0027 TPostItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_67204_0 {
	meta:
		name = "TPowerPointGlobal.Get_AnswerWizard"
		size = 91
		refs = "000f TPowerPointGlobal.Get_AnswerWizard 001c @IntfClear 0027 TPowerPointGlobal.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_74326_0 {
	meta:
		name = "TPowerPointPresentation.Get_Slides"
		size = 91
		refs = "000f TPowerPointPresentation.Get_Slides 001c @IntfClear 0027 TPowerPointPresentation.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71451_0 {
	meta:
		name = "TRemoteItem.Get_Categories"
		size = 91
		refs = "000f TRemoteItem.Get_Categories 001c @WStrClr 0027 TRemoteItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71517_0 {
	meta:
		name = "TReportItem.Get_Categories"
		size = 91
		refs = "000f TReportItem.Get_Categories 001c @WStrClr 0027 TReportItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73757_0 {
	meta:
		name = "TResults.GetPrevious"
		size = 91
		refs = "000f TResults.GetPrevious 001c @IntfClear 0027 TResults.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_70490_0 {
	meta:
		name = "TTaskItem.Get_Categories"
		size = 91
		refs = "000f TTaskItem.Get_Categories 001c @WStrClr 0027 TTaskItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73473_0 {
	meta:
		name = "TTaskRequestAcceptItem.Get_Categories"
		size = 91
		refs = "000f TTaskRequestAcceptItem.Get_Categories 001c @WStrClr 0027 TTaskRequestAcceptItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_71642_0 {
	meta:
		name = "TTaskRequestDeclineItem.Get_Categories"
		size = 91
		refs = "000f TTaskRequestDeclineItem.Get_Categories 001c @WStrClr 0027 TTaskRequestDeclineItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73611_0 {
	meta:
		name = "TTaskRequestItem.Get_Categories"
		size = 91
		refs = "000f TTaskRequestItem.Get_Categories 001c @WStrClr 0027 TTaskRequestItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_73680_0 {
	meta:
		name = "TTaskRequestUpdateItem.Get_Categories"
		size = 91
		refs = "000f TTaskRequestUpdateItem.Get_Categories 001c @WStrClr 0027 TTaskRequestUpdateItem.GetDefaultInterface 0035 @CheckAutoResult 004a @IntfClear 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79245_0 {
	meta:
		name = "TWebBrowser.Get_Container"
		size = 91
		refs = "000f TWebBrowser.Get_Container 001c @IntfClear 0027 TWebBrowser.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_79224_0 {
	meta:
		name = "TWebBrowser_V1.Get_Container"
		size = 91
		refs = "000f TWebBrowser_V1.Get_Container 001c @IntfClear 0027 TWebBrowser_V1.GetControlInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99582_0 {
	meta:
		name = "TWordApplication.Get_RecentFiles"
		size = 91
		refs = "000f TWordApplication.Get_RecentFiles 001c @IntfClear 0027 TWordApplication.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_98942_0 {
	meta:
		name = "TWordDocument.Get_Endnotes"
		size = 91
		refs = "000f TWordDocument.Get_Endnotes 001c @IntfClear 0027 TWordDocument.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_99479_0 {
	meta:
		name = "TWordOLEControl.Get_Automation"
		size = 91
		refs = "000f TWordOLEControl.Get_Automation 001c @IntfClear 0027 TWordOLEControl.GetDefaultInterface 0035 @CheckAutoResult 0050 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B C6 E8 ?? ?? ?? ?? 50 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 50 8B 00 FF 50 44 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_214_0 {
	meta:
		name = "TAccessImage.Get_PictureData"
		size = 156
		refs = "001a TAccessImage.Get_PictureData 002a TAccessImage.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 50 69 63 74 75 72 65 44 61 74 61 00 00 }
	condition:
		$1
}

rule function_248_0 {
	meta:
		name = "TAccessCommandButton.Get_PictureData"
		size = 156
		refs = "001a TAccessCommandButton.Get_PictureData 002a TAccessCommandButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 50 69 63 74 75 72 65 44 61 74 61 00 00 }
	condition:
		$1
}

rule function_1152_0 {
	meta:
		name = "TAccessForm.Get_PictureData"
		size = 156
		refs = "001a TAccessForm.Get_PictureData 002a TAccessForm.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 50 69 63 74 75 72 65 44 61 74 61 00 00 }
	condition:
		$1
}

rule function_835_0 {
	meta:
		name = "TAccessPage.Get_PictureData"
		size = 156
		refs = "001a TAccessPage.Get_PictureData 002a TAccessPage.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 50 69 63 74 75 72 65 44 61 74 61 00 00 }
	condition:
		$1
}

rule function_1398_0 {
	meta:
		name = "TAccessReport.Get_PictureData"
		size = 156
		refs = "001a TAccessReport.Get_PictureData 002a TAccessReport.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 50 69 63 74 75 72 65 44 61 74 61 00 00 }
	condition:
		$1
}

rule function_647_0 {
	meta:
		name = "TAccessToggleButton.Get_PictureData"
		size = 156
		refs = "001a TAccessToggleButton.Get_PictureData 002a TAccessToggleButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 50 69 63 74 75 72 65 44 61 74 61 00 00 }
	condition:
		$1
}

rule function_3170_0 {
	meta:
		name = "TFormOld.Get_PictureData"
		size = 156
		refs = "001a TFormOld.Get_PictureData 002a TFormOld.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 50 69 63 74 75 72 65 44 61 74 61 00 00 }
	condition:
		$1
}

rule function_3416_0 {
	meta:
		name = "TReportOld.Get_PictureData"
		size = 156
		refs = "001a TReportOld.Get_PictureData 002a TReportOld.GetDefaultInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 50 69 63 74 75 72 65 44 61 74 61 00 00 }
	condition:
		$1
}

rule function_215_0 {
	meta:
		name = "TAccessImage.Set_PictureData"
		size = 127
		refs = "001d @VarAddRef 0025 TAccessImage.Set_PictureData 0041 TAccessImage.GetControlInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_73118_0 {
	meta:
		name = "TNameSpace.Dial"
		size = 127
		refs = "001d @VarAddRef 0025 TNameSpace.Dial 0041 TNameSpace.GetDefaultInterface 004f @CheckAutoResult 0064 @IntfClear 006c @VarClr 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 57 33 C9 89 4D EC 8B F2 8D 7D F0 A5 A5 A5 A5 8B D8 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 75 FC FF 75 F8 FF 75 F4 FF 75 F0 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 45 EC 50 8B 00 FF 50 74 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E8 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_216_0 {
	meta:
		name = "TAccessImage.Get_ObjectPalette"
		size = 160
		refs = "001a TAccessImage.Get_ObjectPalette 002a TAccessImage.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 62 6A 65 63 74 50 61 6C 65 74 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_416_0 {
	meta:
		name = "TAccessBoundObjectFrame.Get_ObjectPalette"
		size = 160
		refs = "001a TAccessBoundObjectFrame.Get_ObjectPalette 002a TAccessBoundObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 62 6A 65 63 74 50 61 6C 65 74 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_250_0 {
	meta:
		name = "TAccessCommandButton.Get_ObjectPalette"
		size = 160
		refs = "001a TAccessCommandButton.Get_ObjectPalette 002a TAccessCommandButton.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 62 6A 65 63 74 50 61 6C 65 74 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_759_0 {
	meta:
		name = "TAccessCustomControl.Get_ObjectPalette"
		size = 160
		refs = "001a TAccessCustomControl.Get_ObjectPalette 002a TAccessCustomControl.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?? ?? ?? ?? 8B 55 EC 8D 45 F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 55 DC 8B C6 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 DC E8 ?? ?? ?? ?? 8D 45 EC E8 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E0 5E 5B 8B E5 5D C3 00 01 00 00 4F 62 6A 65 63 74 50 61 6C 65 74 74 65 00 00 00 00 }
	condition:
		$1
}

rule function_596_0 {
	meta:
		name = "TAccessObjectFrame.Get_ObjectPalette"
		size = 160
		refs = "001a TAccessObjectFrame.Get_ObjectPalette 002a TAccessObjectFrame.GetControlInterface 0035 @VarFromDisp 0047 @DispInvoke 0054 @OleVarFromVar 0069 @VarClr 0071 @IntfClear 007f @HandleFinally"
	strings:
		$1 = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 EC 8B C3 E8 ?