private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "??2@YAPAXIHPBDH@Z"
		size = 16
		refs = "0009 ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "??3@YAXPAXABUnothrow_t@std@@@Z"
		size = 16
		refs = "0009 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "??_U@YAPAXIHPBDH@Z"
		size = 16
		refs = "0009 ??_U@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_954_0_0 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 16
		refs = "0009 ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__CIatan_pentium4"
		size = 748
		refs = "002a _mabs 0032 _in 0046 _in1 0050 _in0 006e _p01 007a _p23 0086 _p45 0092 _p60 00be _in2 00dc _d01 00e8 _d23 00f4 _d45 0100 _d67 010c _d89 0118 _d1011 0124 _d1213 0130 _d1400 0164 _in3 016e _cnst8 0176 _cntshf 0197 __atan_table 01ab _one 01c6 _onen 0254 _zero 0263 _minval 026b libm_small 029f _mexp 02bd _pi_2d 02df ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 3C 24 E8 08 00 00 00 C9 C3 F3 0F 7E 7C 24 04 66 0F 14 FF 66 0F 28 D7 66 0F 54 15 ?? ?? ?? ?? 66 0F 2F 15 ?? ?? ?? ?? 0F 8A 86 02 00 00 0F 83 55 02 00 00 66 0F 2F 15 ?? ?? ?? ?? 73 6E 66 0F 2F 15 ?? ?? ?? ?? 0F 82 F6 01 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 0F 83 90 00 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 F3 0F 7E F7 66 0F 57 F2 66 0F 2F 15 ?? ?? ?? ?? 73 4F F3 0F 7E 05 ?? ?? ?? ?? F3 0F 7E 2D ?? ?? ?? ?? F3 0F 7E DA F2 0F 58 D8 66 0F 73 D3 2C 66 0F FA DD 66 0F 7E D8 8D 04 40 F3 0F 7E 2C C5 ?? ?? ?? ?? F3 0F 7E DA F2 0F 5C D5 F2 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 0F 5E D3 66 0F 14 D2 EB 19 B8 00 03 00 00 F3 0F 7E C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 14 D2 F3 0F 7E 04 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EA F2 0F 5C EC F2 0F 5C EA F2 0F 5C C5 66 0F 56 C6 66 0F D6 44 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 75 05 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 73 1D DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 04 24 83 C4 08 DC 44 24 04 C3 DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 44 24 04 C3 F3 0F 7E C2 F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 C3 66 0F 2E C3 7A 15 8B 44 24 08 C1 E8 1F DD 05 ?? ?? ?? ?? DC 04 C5 ?? ?? ?? ?? C3 BA EB 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 90 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "__execl"
		size = 66
		refs = "000f __errno 001a __invalid_parameter_noinfo 0039 __execve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 33 D2 3B CA 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 38 11 74 E7 8B 45 0C 3B C2 74 E0 38 10 74 DC 52 8D 45 0C 50 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "___libm_sse2_tanf"
		size = 416
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER_16 0047 _SHIFTER 007a _PP_1 0086 _P_1 0092 _PP_2 009e _P_2 00a8 _Ctable 00e4 _ONE 015b _ONE_P230 018a _tan"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D FF 46 0F 87 3A 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 3D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 F8 F3 0F 5A C0 F2 0F 10 25 ?? ?? ?? ?? F3 0F 58 E1 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 25 ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 EF 66 0F 73 F7 20 66 0F 73 F5 1D 66 0F 57 FD 81 C2 00 76 1C 00 83 E2 1F F2 0F 10 2D ?? ?? ?? ?? 66 0F 57 EF F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D7 F2 0F 10 35 ?? ?? ?? ?? 66 0F 57 F7 F2 0F 10 1D ?? ?? ?? ?? 66 0F 57 DF 8D 05 ?? ?? ?? ?? C1 E2 03 03 C2 C1 E2 03 03 C2 66 0F 73 F4 1D 66 0F 73 F1 1D F2 0F 59 EC F2 0F 59 D1 F2 0F 59 F4 F2 0F 59 D9 F2 0F 58 E8 F2 0F 58 D0 F2 0F 58 EE F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 5E FD F2 0F 59 78 40 F2 0F 10 58 38 F2 0F 59 DA F2 0F 10 60 18 F2 0F 59 E2 F2 0F 10 68 28 F2 0F 59 EA F2 0F 10 70 08 F2 0F 59 F2 F2 0F 59 D2 F2 0F 58 58 30 F2 0F 58 60 10 F2 0F 58 68 20 F2 0F 58 30 F2 0F 59 DA F2 0F 59 E2 F2 0F 59 D2 F2 0F 58 DD F2 0F 58 E6 F2 0F 59 DA F2 0F 58 DC F2 0F 5C DF F2 0F 5A C3 C3 7F 11 F3 0F 5A C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 27 8B C4 83 EC 20 83 E4 F0 89 44 24 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 8B 64 24 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 29
		refs = "0014 __mbsnbcpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_488_7_0 {
	meta:
		name = "__aligned_recalloc"
		size = 29
		refs = "0014 __aligned_offset_recalloc"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_725_20_0 {
	meta:
		name = "__cftof"
		size = 29
		refs = "0014 __cftof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 29
		refs = "0014 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_484_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 29
		refs = "0014 __mbsnbcat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 29
		refs = "0014 __mbsnbset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 29
		refs = "0014 __mbsncat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__mbsncpy_s"
		size = 29
		refs = "0014 __mbsncpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_712_0_0 {
	meta:
		name = "__mbsnset_s"
		size = 29
		refs = "0014 __mbsnset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_672_4_0 {
	meta:
		name = "_wctomb_s"
		size = 29
		refs = "0014 __wctomb_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 135
		refs = "0014 __getptd 002a ___ptlocinfo 0032 ___globallocalestatus 003c ___updatetlocinfo 0047 ___ptmbcinfo 005c ___updatetmbcinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B F1 C6 46 0C 00 85 C0 75 63 E8 ?? ?? ?? ?? 89 46 08 8B 48 6C 89 0E 8B 48 68 89 4E 04 8B 0E 3B 0D ?? ?? ?? ?? 74 12 8B 0D ?? ?? ?? ?? 85 48 70 75 07 E8 ?? ?? ?? ?? 89 06 8B 46 04 3B 05 ?? ?? ?? ?? 74 16 8B 46 08 8B 0D ?? ?? ?? ?? 85 48 70 75 08 E8 ?? ?? ?? ?? 89 46 04 8B 46 08 F6 40 70 02 75 14 83 48 70 02 C6 46 0C 01 EB 0A 8B 08 89 0E 8B 40 04 89 46 04 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_5_3_0 {
	meta:
		name = "__mbsdec_l"
		size = 136
		refs = "000f __errno 001a __invalid_parameter_noinfo 004c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 08 00 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 C9 C3 56 8B 75 0C 85 F6 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 05 39 75 08 72 04 33 C0 EB 40 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 83 79 08 00 8D 46 FF 74 1C 48 39 45 08 77 0A 0F B6 10 F6 44 0A 1D 04 75 F0 8B CE 2B C8 83 E1 01 2B F1 8D 46 FF 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5E C9 C3 }
	condition:
		$1
}

rule file_5_4_0 {
	meta:
		name = "__mbsdec"
		size = 23
		refs = "000e __mbsdec_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_78_1011_2 {
	meta:
		name = "??$receive@I@Concurrency@@YAIPAV?$ISource@I@0@I@Z"
		size = 23
		refs = "000e ??$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@0@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_78_930_2 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@AAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 23
		refs = "000e ??$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_78_936_2 {
	meta:
		name = "??$receive@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@I@Z"
		size = 23
		refs = "000e ??$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PAV?$ISource@W4agent_status@Concurrency@@@0@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_488_3_0 {
	meta:
		name = "__aligned_malloc"
		size = 23
		refs = "000e __aligned_offset_malloc"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_737_4_0 {
	meta:
		name = "__atodbl"
		size = 23
		refs = "000e __atodbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_737_8_0 {
	meta:
		name = "__atoflt"
		size = 23
		refs = "000e __atoflt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_737_6_0 {
	meta:
		name = "__atoldbl"
		size = 23
		refs = "000e __atoldbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__execvp"
		size = 23
		refs = "000e __execvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "__getws_s"
		size = 23
		refs = "000e __getws_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_576_4_0 {
	meta:
		name = "__ismbslead"
		size = 23
		refs = "000e __ismbslead_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_602_4_0 {
	meta:
		name = "__ismbstrail"
		size = 23
		refs = "000e __ismbstrail_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_540_4_0 {
	meta:
		name = "__mbbtype"
		size = 23
		refs = "000e __mbbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_896_4_0 {
	meta:
		name = "__mbsbtype"
		size = 23
		refs = "000e __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_177_4_0 {
	meta:
		name = "__mbschr"
		size = 23
		refs = "000e __mbschr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_455_4_0 {
	meta:
		name = "__mbscmp"
		size = 23
		refs = "000e __mbscmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_560_4_0 {
	meta:
		name = "__mbscoll"
		size = 23
		refs = "000e __mbscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_165_4_0 {
	meta:
		name = "__mbscspn"
		size = 23
		refs = "000e __mbscspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_611_4_0 {
	meta:
		name = "__mbsicmp"
		size = 23
		refs = "000e __mbsicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_309_4_0 {
	meta:
		name = "__mbsicoll"
		size = 23
		refs = "000e __mbsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_767_4_0 {
	meta:
		name = "__mbslwr_s"
		size = 23
		refs = "000e __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_465_4_0 {
	meta:
		name = "__mbsnbcnt"
		size = 23
		refs = "000e __mbsnbcnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_204_4_0 {
	meta:
		name = "__mbsnccnt"
		size = 23
		refs = "000e __mbsnccnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_485_1_0 {
	meta:
		name = "__mbsninc"
		size = 23
		refs = "000e __mbsninc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__mbsnlen"
		size = 23
		refs = "000e __mbsnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_149_4_0 {
	meta:
		name = "__mbspbrk"
		size = 23
		refs = "000e __mbspbrk_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_330_4_0 {
	meta:
		name = "__mbsrchr"
		size = 23
		refs = "000e __mbsrchr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_520_4_0 {
	meta:
		name = "__mbsset"
		size = 23
		refs = "000e __mbsset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_122_4_0 {
	meta:
		name = "__mbsspn"
		size = 23
		refs = "000e __mbsspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_434_4_0 {
	meta:
		name = "__mbsspnp"
		size = 23
		refs = "000e __mbsspnp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_565_4_0 {
	meta:
		name = "__mbsstr"
		size = 23
		refs = "000e __mbsstr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_605_1_0 {
	meta:
		name = "__mbstok"
		size = 23
		refs = "000e __mbstok_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_285_4_0 {
	meta:
		name = "__mbstrnlen"
		size = 23
		refs = "000e __mbstrnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_647_4_0 {
	meta:
		name = "__mbsupr_s"
		size = 23
		refs = "000e __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_466_7_0 {
	meta:
		name = "__strlwr_s"
		size = 23
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_534_7_0 {
	meta:
		name = "__strupr_s"
		size = 23
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_48_7_0 {
	meta:
		name = "__wcslwr_s"
		size = 23
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_962_7_0 {
	meta:
		name = "__wcsupr_s"
		size = 23
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_768_0_0 {
	meta:
		name = "__wexecvp"
		size = 23
		refs = "000e __wexecvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_751_1_0 {
	meta:
		name = "_gets_s"
		size = 23
		refs = "000e __gets_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_600_4_0 {
	meta:
		name = "_strcoll"
		size = 23
		refs = "000e __strcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_831_4_0 {
	meta:
		name = "_strtod"
		size = 23
		refs = "000e __strtod_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_109_4_0 {
	meta:
		name = "_wcstod"
		size = 23
		refs = "000e __wcstod_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_wcscpy_s"
		size = 99
		refs = "0016 __errno 0020 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 57 85 F6 74 07 8B 7D 0C 85 FF 75 15 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5D C3 8B 45 10 85 C0 75 05 66 89 06 EB DF 8B D6 2B D0 0F B7 08 66 89 0C 02 83 C0 02 66 85 C9 74 03 4F 75 EE 33 C0 85 FF 75 D4 66 89 06 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB BC }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__getws_helper"
		size = 322
		refs = "0003 __sehtable$__getws_helper 0008 __SEH_prolog4 0020 __errno 002b __invalid_parameter_noinfo 0042 ___iob_func 004a __lock_file2 005b __fgetwc_nolock 0107 ___security_cookie 010c __local_unwind4 012d __SEH_epilog4 013b __unlock_file2"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 8B F3 89 5D E0 33 C0 85 DB 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 F6 00 00 00 33 C0 3B 45 0C 1B C0 F7 D8 74 DE E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 59 59 83 65 FC 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 08 BF FF FF 00 00 3B C7 75 0E 83 65 E0 00 83 7D 10 00 0F 85 A0 00 00 00 8B 4D 0C 83 F9 FF 75 2E 83 F8 0A 0F 84 8A 00 00 00 3B C7 0F 84 82 00 00 00 66 89 06 83 C6 02 89 75 DC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 08 EB D2 89 4D E4 83 F8 0A 74 2A 3B C7 74 26 83 7D E4 00 76 0C FF 4D E4 66 89 06 83 C6 02 89 75 DC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 08 EB D1 83 7D E4 00 75 2D 33 C0 66 89 03 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E9 17 FF FF FF 33 C0 66 89 06 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_8_2_0 {
	meta:
		name = "__getws"
		size = 22
		refs = "000d __getws_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_751_2_0 {
	meta:
		name = "_gets"
		size = 22
		refs = "000d __gets_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 33
		refs = "001b __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 14 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "__setdefaultprecision"
		size = 40
		refs = "0011 __controlfp_s 0022 __invoke_watson"
	strings:
		$1 = { 8B FF 56 68 00 00 03 00 68 00 00 01 00 33 F6 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0A 56 56 56 56 56 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_711_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_824_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_992_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_968_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_711_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_824_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_416_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_220_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_992_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_716_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_968_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_2_0 {
	meta:
		name = "__CIatan_default"
		size = 159
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 0038 ___fastflag 003f __fast_exit 004a _NAME_ 004f __math_exit 0054 __convertTOStoQNaN 006c __piby2 0099 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 36 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 E8 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 26 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? A9 00 00 00 80 74 BF D9 E0 EB BB B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__lsearch_s"
		size = 152
		refs = "000e __errno 0019 __invalid_parameter_noinfo 0088 _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 53 33 DB 39 5D 08 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 74 56 8B 75 10 3B F3 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 57 57 8B 7D 0C 3B FB 74 0A 39 5D 14 76 05 39 5D 18 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 30 39 1E 76 19 57 FF 75 08 FF 75 1C FF 55 18 83 C4 0C 85 C0 74 19 03 7D 14 43 3B 1E 72 E7 FF 75 14 FF 75 08 57 E8 ?? ?? ?? ?? 83 C4 0C FF 06 8B C7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "__recalloc"
		size = 110
		refs = "001c __errno 003b __msize 0047 _realloc 0060 _memset"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 53 33 DB 3B CB 76 1B 6A E0 33 D2 58 F7 F1 3B 45 10 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 41 0F AF 4D 10 56 57 8B F1 39 5D 08 74 0B FF 75 08 E8 ?? ?? ?? ?? 59 8B D8 56 FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 74 14 3B DE 73 10 2B F3 56 6A 00 03 DF 53 E8 ?? ?? ?? ?? 83 C4 0C 8B C7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__wchmod"
		size = 101
		refs = "000c ___doserrno 0014 __errno 001f __invalid_parameter_noinfo 002d __imp__GetFileAttributesW@4 0038 __imp__GetLastError@0 003e __dosmaperr 0059 __imp__SetFileAttributesW@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 1D E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 FF 75 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB DE F6 45 0C 80 74 05 83 E0 FE EB 03 83 C8 01 50 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 D5 33 C0 5D C3 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "__chmod"
		size = 101
		refs = "000c ___doserrno 0014 __errno 001f __invalid_parameter_noinfo 002d __imp__GetFileAttributesA@4 0038 __imp__GetLastError@0 003e __dosmaperr 0059 __imp__SetFileAttributesA@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 1D E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 FF 75 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB DE F6 45 0C 80 74 05 83 E0 FE EB 03 83 C8 01 50 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 D5 33 C0 5D C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_wcsncat_s"
		size = 214
		refs = "002e __errno 0038 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 5D 14 56 8B 75 08 57 85 DB 75 10 85 F6 75 10 39 75 0C 75 12 33 C0 5F 5E 5B 5D C3 85 F6 74 07 8B 7D 0C 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB DD 8B 55 10 85 DB 74 0B 85 D2 75 07 33 C0 66 89 06 EB DB 8B C6 66 83 38 00 74 06 83 C0 02 4F 75 F4 85 FF 74 E7 83 FB FF 75 16 2B C2 0F B7 0A 66 89 0C 10 83 C2 02 66 85 C9 74 29 4F 75 EE EB 24 85 DB 74 1B 2B D0 0F B7 0C 02 66 89 08 83 C0 02 66 85 C9 74 06 4F 74 03 4B 75 EB 85 DB 75 05 33 C9 66 89 08 85 FF 0F 85 70 FF FF FF 33 C0 83 FB FF 75 10 8B 4D 0C 6A 50 66 89 44 4E FE 58 E9 5B FF FF FF 66 89 06 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 E9 61 FF FF FF }
	condition:
		$1
}

rule file_20_3_0 {
	meta:
		name = "__mbsncpy_s_l"
		size = 491
		refs = "0030 __errno 003a __invalid_parameter_noinfo 0065 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 007a _strncpy_s 00c3 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 8B 5D 08 56 57 33 FF 89 7D F8 39 7D 14 75 0E 3B DF 75 0E 39 7D 0C 75 0E E9 BE 01 00 00 3B DF 74 05 39 7D 0C 77 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 A1 01 00 00 39 7D 14 75 08 C6 03 00 E9 92 01 00 00 8B 75 10 3B F7 75 05 C6 03 00 EB D1 FF 75 18 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 39 78 08 75 26 FF 75 14 56 FF 75 0C 53 E8 ?? ?? ?? ?? 83 C4 10 80 7D F4 00 0F 84 5B 01 00 00 8B 4D F0 83 61 70 FD E9 4F 01 00 00 83 7D 14 FF 8B 45 0C 8B FB 89 45 FC 75 15 8B CB 2B CE 8A 06 88 04 31 46 84 C0 74 6C FF 4D FC 75 F1 EB 65 8D 45 E8 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 22 80 7E 01 00 74 32 83 7D FC 02 76 39 8A 0E 88 0F 8A 46 01 88 47 01 83 C7 02 83 C6 02 83 6D FC 02 EB 0F 8A 06 88 07 47 46 84 C0 74 1D FF 4D FC 74 18 FF 4D 14 75 B7 EB 11 C6 07 00 47 C7 45 F8 01 00 00 00 EB 04 83 65 FC 00 83 7D 14 00 75 03 C6 07 00 33 C0 39 45 FC 0F 85 8E 00 00 00 83 7D 14 FF 75 61 39 45 F8 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 45 0C 83 F8 01 76 42 8D 74 03 FE 8B FE 3B F3 72 18 8D 45 E8 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 4F 3B FB 73 E8 8B C6 2B C7 A8 01 74 15 C6 06 00 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 6A 50 58 EB 5F 8B 45 0C C6 44 03 FF 00 EB E4 88 03 E8 ?? ?? ?? ?? 6A 22 5E 89 30 E8 ?? ?? ?? ?? 80 7D F4 00 0F 84 92 FE FF FF 8B 45 F0 83 60 70 FD E9 86 FE FF FF 39 45 F8 74 1B E8 ?? ?? ?? ?? 6A 2A 59 89 08 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 8B C1 EB 0E 38 45 F4 74 07 8B 45 F0 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "___ascii_memicmp"
		size = 89
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 45 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 83 C6 01 8A 07 83 C7 01 3A E0 74 18 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 07 83 E9 01 75 D5 EB 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__lsearch"
		size = 148
		refs = "000e __errno 0019 __invalid_parameter_noinfo 0084 _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 53 33 DB 39 5D 08 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 70 56 8B 75 10 3B F3 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 53 57 8B 7D 0C 3B FB 74 0A 39 5D 14 76 05 39 5D 18 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 2C 39 1E 76 15 57 FF 75 08 FF 55 18 59 59 85 C0 74 19 03 7D 14 43 3B 1E 72 EB FF 75 14 FF 75 08 57 E8 ?? ?? ?? ?? 83 C4 0C FF 06 8B C7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "_wcsncmp"
		size = 57
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 8B 55 0C 8B 4D 08 FF 4D 10 74 15 0F B7 01 66 85 C0 74 0D 66 3B 02 75 08 83 C1 02 83 C2 02 EB E6 0F B7 01 0F B7 0A 2B C1 5D C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__fptostr"
		size = 179
		refs = "0017 __errno 0021 __invalid_parameter_noinfo 009c _strlen 00a5 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 14 53 8B 59 0C 56 8B 75 08 33 C0 3B F0 75 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 83 00 00 00 39 45 0C 76 E5 8B 55 10 88 06 3B D0 7E 02 8B C2 40 39 45 0C 77 0E E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB D0 57 8D 7E 01 C6 06 30 8B C7 85 D2 7E 1A 8A 0B 84 C9 74 06 0F BE C9 43 EB 03 6A 30 59 88 08 40 4A 85 D2 7F E9 8B 4D 14 C6 00 00 85 D2 78 12 80 3B 35 7C 0D EB 03 C6 00 30 48 80 38 39 74 F7 FE 00 80 3E 31 75 05 FF 41 04 EB 12 57 E8 ?? ?? ?? ?? 40 50 57 56 E8 ?? ?? ?? ?? 83 C4 10 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "__mblen_l"
		size = 191
		refs = "002f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003c __isleadbyte_l 0064 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 0F 84 A2 00 00 00 38 1E 0F 84 9A 00 00 00 39 5D 0C 0F 84 91 00 00 00 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 85 C0 8B 45 F0 59 74 4B 8B 88 AC 00 00 00 83 F9 01 7E 2F 39 4D 0C 7C 2A 53 53 51 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 74 17 8B 45 F0 8B 80 AC 00 00 00 38 5D FC 74 41 8B 4D F8 83 61 70 FD EB 38 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF EB 27 53 53 6A 01 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 74 DB 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 40 EB 02 33 C0 5E 5B C9 C3 }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "_mblen"
		size = 39
		refs = "0007 ___locale_changed 000f ___initiallocalestructinfo 001e __mblen_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 07 68 ?? ?? ?? ?? EB 02 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "?__CxxUnhandledExceptionFilter@@YGJPAU_EXCEPTION_POINTERS@@@Z"
		size = 66
		refs = "0038 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 81 38 63 73 6D E0 75 2A 83 78 10 03 75 24 8B 40 14 3D 20 05 93 19 74 15 3D 21 05 93 19 74 0E 3D 22 05 93 19 74 07 3D 00 40 99 01 75 05 E8 ?? ?? ?? ?? 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_29_3_0 {
	meta:
		name = "__mbsnextc_l"
		size = 108
		refs = "0012 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001e __errno 0029 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 FF 75 0C 8D 4D F0 33 F6 E8 ?? ?? ?? ?? 8B 4D 08 85 C9 75 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 2B 0F B6 01 8B 55 F4 F6 44 10 1D 04 74 0C 80 79 01 00 74 06 C1 E0 08 8B F0 41 0F B6 01 03 C6 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5E C9 C3 }
	condition:
		$1
}

rule file_29_4_0 {
	meta:
		name = "__mbsnextc"
		size = 19
		refs = "000b __mbsnextc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_725_12_0 {
	meta:
		name = "__cropzeros"
		size = 19
		refs = "000b __cropzeros_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_725_11_0 {
	meta:
		name = "__forcdecpt"
		size = 19
		refs = "000b __forcdecpt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_813_25_0 {
	meta:
		name = "__ismbbkana"
		size = 19
		refs = "000b __ismbbkana_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_421_4_0 {
	meta:
		name = "__ismbcalnum"
		size = 19
		refs = "000b __ismbcalnum_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_291_4_0 {
	meta:
		name = "__ismbcalpha"
		size = 19
		refs = "000b __ismbcalpha_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_182_4_0 {
	meta:
		name = "__ismbcdigit"
		size = 19
		refs = "000b __ismbcdigit_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_207_4_0 {
	meta:
		name = "__ismbcgraph"
		size = 19
		refs = "000b __ismbcgraph_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_242_4_0 {
	meta:
		name = "__ismbchira"
		size = 19
		refs = "000b __ismbchira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_242_6_0 {
	meta:
		name = "__ismbckata"
		size = 19
		refs = "000b __ismbckata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_123_4_0 {
	meta:
		name = "__ismbcl0"
		size = 19
		refs = "000b __ismbcl0_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_123_6_0 {
	meta:
		name = "__ismbcl1"
		size = 19
		refs = "000b __ismbcl1_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_123_8_0 {
	meta:
		name = "__ismbcl2"
		size = 19
		refs = "000b __ismbcl2_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_239_4_0 {
	meta:
		name = "__ismbclegal"
		size = 19
		refs = "000b __ismbclegal_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_251_4_0 {
	meta:
		name = "__ismbclower"
		size = 19
		refs = "000b __ismbclower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_757_4_0 {
	meta:
		name = "__ismbcprint"
		size = 19
		refs = "000b __ismbcprint_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_601_4_0 {
	meta:
		name = "__ismbcpunct"
		size = 19
		refs = "000b __ismbcpunct_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_321_4_0 {
	meta:
		name = "__ismbcspace"
		size = 19
		refs = "000b __ismbcspace_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_242_8_0 {
	meta:
		name = "__ismbcsymbol"
		size = 19
		refs = "000b __ismbcsymbol_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_927_4_0 {
	meta:
		name = "__ismbcupper"
		size = 19
		refs = "000b __ismbcupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_378_4_0 {
	meta:
		name = "__mbbtombc"
		size = 19
		refs = "000b __mbbtombc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_624_4_0 {
	meta:
		name = "__mbcjistojms"
		size = 19
		refs = "000b __mbcjistojms_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_624_6_0 {
	meta:
		name = "__mbcjmstojis"
		size = 19
		refs = "000b __mbcjmstojis_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_871_1_0 {
	meta:
		name = "__mbctohira"
		size = 19
		refs = "000b __mbctohira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_502_1_0 {
	meta:
		name = "__mbctokata"
		size = 19
		refs = "000b __mbctokata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_832_4_0 {
	meta:
		name = "__mbctolower"
		size = 19
		refs = "000b __mbctolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_378_6_0 {
	meta:
		name = "__mbctombb"
		size = 19
		refs = "000b __mbctombb_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_215_4_0 {
	meta:
		name = "__mbctoupper"
		size = 19
		refs = "000b __mbctoupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_980_4_0 {
	meta:
		name = "__mbslen"
		size = 19
		refs = "000b __mbslen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_949_4_0 {
	meta:
		name = "__mbsrev"
		size = 19
		refs = "000b __mbsrev_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_313_4_0 {
	meta:
		name = "__wtof"
		size = 19
		refs = "000b __wtof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_211_4_0 {
	meta:
		name = "_atof"
		size = 19
		refs = "000b __atof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_4_0 {
	meta:
		name = "_isleadbyte"
		size = 19
		refs = "000b __isleadbyte_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_106_4_0 {
	meta:
		name = "_towlower"
		size = 19
		refs = "000b __towlower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_528_4_0 {
	meta:
		name = "_towupper"
		size = 19
		refs = "000b __towupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "_bsearch"
		size = 180
		refs = "0021 __errno 002c __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 8B 4D 0C 56 8D 70 FF 0F AF 75 14 03 F1 89 4D 0C 85 C9 75 18 85 C0 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 5F 83 7D 14 00 76 E6 83 7D 18 00 74 E0 53 57 3B CE 77 49 8B D8 D1 EB 74 4E 89 45 10 83 65 10 01 8B C3 75 03 8D 43 FF 0F AF 45 14 03 45 0C 8B F8 57 FF 75 08 FF 55 18 59 59 85 C0 74 26 79 10 2B 7D 14 83 7D 10 00 8B F7 75 0B 8D 43 FF EB 08 03 7D 14 89 7D 0C 8B C3 39 75 0C 76 B7 33 C0 5F 5B 5E 5D C3 8B C7 EB F7 85 C0 74 F1 FF 75 0C FF 75 08 FF 55 18 F7 D8 1B C0 59 F7 D0 23 45 0C 59 EB DD }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
		size = 555
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 __errno 0030 __invalid_parameter_noinfo 007c __isctype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 56 FF 75 08 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 10 8B 75 0C 85 C0 74 02 89 30 85 F6 75 24 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D F0 00 74 07 8B 45 EC 83 60 70 FD 33 C0 E9 E0 01 00 00 83 7D 14 00 74 0C 83 7D 14 02 7C D0 83 7D 14 24 7F CA 83 65 FC 00 8B 4D E4 53 8A 1E 57 8D 7E 01 83 B9 AC 00 00 00 01 7E 17 8D 45 E4 50 0F B6 C3 6A 08 50 E8 ?? ?? ?? ?? 8B 4D E4 83 C4 0C EB 10 8B 91 C8 00 00 00 0F B6 C3 0F B7 04 42 83 E0 08 85 C0 74 05 8A 1F 47 EB C7 80 FB 2D 75 06 83 4D 18 02 EB 05 80 FB 2B 75 03 8A 1F 47 8B 45 14 85 C0 0F 88 4F 01 00 00 83 F8 01 0F 84 46 01 00 00 83 F8 24 0F 8F 3D 01 00 00 85 C0 75 2A 80 FB 30 74 09 C7 45 14 0A 00 00 00 EB 36 8A 07 3C 78 74 0D 3C 58 74 09 C7 45 14 08 00 00 00 EB 23 C7 45 14 10 00 00 00 EB 0A 83 F8 10 75 15 80 FB 30 75 10 8A 07 3C 78 74 04 3C 58 75 06 8A 5F 01 83 C7 02 83 C8 FF 33 D2 F7 75 14 8B B1 C8 00 00 00 89 55 F8 0F B6 CB 0F B7 0C 4E 8B D1 83 E2 04 74 08 0F BE CB 83 E9 30 EB 19 81 E1 03 01 00 00 74 30 8D 4B 9F 80 F9 19 0F BE CB 77 03 83 E9 20 83 C1 C9 3B 4D 14 73 1A 83 4D 18 08 39 45 FC 72 28 75 05 3B 4D F8 76 21 83 4D 18 04 83 7D 10 00 75 23 8B 45 18 4F A8 08 75 20 83 7D 10 00 74 03 8B 7D 0C 83 65 FC 00 EB 5B 8B 55 FC 0F AF 55 14 03 D1 89 55 FC 8A 1F 47 EB 8A BE FF FF FF 7F A8 04 75 1B A8 01 75 3D 83 E0 02 74 09 81 7D FC 00 00 00 80 77 09 85 C0 75 2B 39 75 FC 76 26 E8 ?? ?? ?? ?? F6 45 18 01 C7 00 22 00 00 00 74 06 83 4D FC FF EB 0F F6 45 18 02 6A 00 58 0F 95 C0 03 C6 89 45 FC 8B 45 10 85 C0 74 02 89 38 F6 45 18 02 74 03 F7 5D FC 80 7D F0 00 74 07 8B 45 EC 83 60 70 FD 8B 45 FC EB 18 8B 45 10 85 C0 74 02 89 30 80 7D F0 00 74 07 8B 45 EC 83 60 70 FD 33 C0 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_33_4_0 {
	meta:
		name = "_strtol"
		size = 43
		refs = "0013 ___locale_changed 001a ___initiallocalestructinfo 0022 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 FF 75 10 FF 75 0C FF 75 08 39 05 ?? ?? ?? ?? 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_563_4_0 {
	meta:
		name = "__strtoi64"
		size = 43
		refs = "0013 ___locale_changed 001a ___initiallocalestructinfo 0022 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 FF 75 10 FF 75 0C FF 75 08 39 05 ?? ?? ?? ?? 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "__wcstoi64"
		size = 43
		refs = "0013 ___locale_changed 001a ___initiallocalestructinfo 0022 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 FF 75 10 FF 75 0C FF 75 08 39 05 ?? ?? ?? ?? 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_33_5_0 {
	meta:
		name = "__strtol_l"
		size = 29
		refs = "0014 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_563_5_0 {
	meta:
		name = "__strtoi64_l"
		size = 29
		refs = "0014 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_4_0 {
	meta:
		name = "__wcstoi64_l"
		size = 29
		refs = "0014 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_33_6_0 {
	meta:
		name = "_strtoul"
		size = 44
		refs = "0007 ___locale_changed 001a ___initiallocalestructinfo 0023 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_563_6_0 {
	meta:
		name = "__strtoui64"
		size = 44
		refs = "0007 ___locale_changed 001a ___initiallocalestructinfo 0023 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_5_0 {
	meta:
		name = "__wcstoui64"
		size = 44
		refs = "0007 ___locale_changed 001a ___initiallocalestructinfo 0023 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_33_7_0 {
	meta:
		name = "__strtoul_l"
		size = 29
		refs = "0014 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_563_7_0 {
	meta:
		name = "__strtoui64_l"
		size = 29
		refs = "0014 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_6_0 {
	meta:
		name = "__wcstoui64_l"
		size = 29
		refs = "0014 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 10 FF 75 0C FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 38
		refs = "0012 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0017 ??0exception@std@@QAE@ABQBDH@Z 001d ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 6A 01 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_35_2_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7bad_alloc@std@@6B@ 000f ??1exception@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_772_48_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7FreeThreadProxy@details@Concurrency@@6B@ 000f ??1ThreadProxy@details@Concurrency@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_42_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7ThreadScheduler@details@Concurrency@@6B@ 000f ??1SchedulerBase@details@Concurrency@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_436_7_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7ThreadVirtualProcessor@details@Concurrency@@6B@ 000f ??1VirtualProcessor@details@Concurrency@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_865_35_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7UMSThreadScheduler@details@Concurrency@@6B@ 000f ??1SchedulerBase@details@Concurrency@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_20_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7exception@std@@6B@ 000f ?_Tidy@exception@std@@AAEXXZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7exception@std@@6B@ 000f ?_Tidy@exception@std@@AAEXXZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_405_2_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7bad_exception@std@@6B@ 000f ??1exception@std@@UAE@XZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_18_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7exception@std@@6B@ 000f ?_Tidy@exception@std@@AAEXXZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_14_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 39
		refs = "000a ??_7exception@std@@6B@ 000f ?_Tidy@exception@std@@AAEXXZ 001b ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_35_3_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_21_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0bad_typeid@std@@QAE@ABV01@@Z 0012 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_12_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 29
		refs = "000c ??0bad_typeid@std@@QAE@PBD@Z 0012 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_17_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_974_31_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_4_1 {
	meta:
		name = "??0bad_function_call@tr1@std@@QAE@ABV012@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_function_call@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_129_1 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_19_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_94_4_2 {
	meta:
		name = "??0bad_weak_ptr@tr1@std@@QAE@ABV012@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7bad_weak_ptr@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_94_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_93_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_266_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_94_2 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 29
		refs = "000c ??0system_error@std@@QAE@ABV01@@Z 0012 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_347_67_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_277_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_273_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_294_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_93_86_0 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_118_2 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_51_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_218_1 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_66_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_448_12_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_448_25_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_448_16_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_17_75_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7length_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_695_11_0 {
	meta:
		name = "??0logic_error@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_260_1 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_135_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_101_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_160_1 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_70_8_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_88_28_2 {
	meta:
		name = "??0overflow_error@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_17_23_1 {
	meta:
		name = "??0range_error@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7range_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_83_83_2 {
	meta:
		name = "??0runtime_error@std@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_107_8_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_154_0 {
	meta:
		name = "??0task_canceled@details@Concurrency@@QAE@ABV012@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7task_canceled@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_429_68_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@ABV01@@Z"
		size = 29
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_35_4_0 {
	meta:
		name = "?_Nomemory@std@@YAXXZ"
		size = 100
		refs = "000a ?$S1@?1??_Nomemory@std@@YAXXZ@4IA 0012 ?nomem@?1??_Nomemory@std@@YAXXZ@4Vbad_alloc@2@B 0017 ??_7bad_alloc@std@@6B@ 002f ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0034 ??0exception@std@@QAE@ABQBDH@Z 0039 ??__Fnomem@?1??_Nomemory@std@@YAXXZ@YAXXZ 0044 _atexit 004e ??0exception@std@@QAE@ABV01@@Z 0053 __TI2?AVbad_alloc@std@@ 005f __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 F6 05 ?? ?? ?? ?? 01 56 57 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 75 2C 83 0D ?? ?? ?? ?? 01 6A 01 8D 45 FC 50 8B CF C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 57 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 89 75 F0 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_35_5_0 {
	meta:
		name = "??__Fnomem@?1??_Nomemory@std@@YAXXZ@YAXXZ"
		size = 20
		refs = "0002 ?nomem@?1??_Nomemory@std@@YAXXZ@4Vbad_alloc@2@B 0006 ??_7bad_alloc@std@@6B@ 0010 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_496_5_0 {
	meta:
		name = "??__Fnomem@?5???2@YAPAXI@Z@YAXXZ"
		size = 20
		refs = "0002 ?nomem@?5???2@YAPAXI@Z@4Vbad_alloc@std@@B 0006 ??_7bad_alloc@std@@6B@ 0010 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_337_1 {
	meta:
		name = "??__Fnomem@?L@??_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z@YAXXZ"
		size = 20
		refs = "0002 ?nomem@?L@??_Locimp_Addfac@_Locimp@locale@std@@CAXPAV234@PAVfacet@34@I@Z@4Vbad_alloc@4@B 0006 ??_7bad_alloc@std@@6B@ 0010 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_336_1 {
	meta:
		name = "??__Fnomem@?P@??_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z@YAXXZ"
		size = 20
		refs = "0002 ?nomem@?P@??_Locimp_ctor@_Locimp@locale@std@@CAXPAV234@ABV234@@Z@4Vbad_alloc@4@B 0006 ??_7bad_alloc@std@@6B@ 0010 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { C7 05 ?? ?? ?? ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__wutime32"
		size = 121
		refs = "000c __errno 0017 __invalid_parameter_noinfo 0031 __wsopen_s 0045 __futime32 0062 __close"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 6A 00 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 DF 56 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 83 FF FF 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FF FF 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_333_1_0 {
	meta:
		name = "__utime32"
		size = 121
		refs = "000c __errno 0017 __invalid_parameter_noinfo 0031 __sopen_s 0045 __futime32 0062 __close"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 6A 00 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 DF 56 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 83 FF FF 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FF FF 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_967_1_0 {
	meta:
		name = "__utime64"
		size = 121
		refs = "000c __errno 0017 __invalid_parameter_noinfo 0031 __sopen_s 0045 __futime64 0062 __close"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 6A 00 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 DF 56 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 83 FF FF 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FF FF 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "__wutime64"
		size = 121
		refs = "000c __errno 0017 __invalid_parameter_noinfo 0031 __wsopen_s 0045 __futime64 0062 __close"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 6A 00 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 DF 56 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 59 59 83 FF FF 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 59 83 FF FF 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_2_0 {
	meta:
		name = "__CItan_default"
		size = 178
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003e ___fastflag 0045 __fast_exit 0050 _NAME_ 0055 __math_exit 005b __pi_by_2_to_61 0072 __convertTOStoQNaN 008a __indefinite 00ac __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 54 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 F2 9B DF E0 9E 7A 1F DD D8 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 F2 DD D8 EB CB E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 20 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 44
		refs = "0026 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 1E 3B 45 0C 74 05 3B 45 10 75 14 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_42_1_0 {
	meta:
		name = "__wsetlocale"
		size = 470
		refs = "0003 __sehtable$__wsetlocale 0008 __SEH_prolog4 0027 _wcstombs_s 0042 __invoke_watson 0051 __calloc_crt 0083 _free 0095 _setlocale 00ab __getptd 00d0 __mbstowcs_s_l 0101 __malloc_crt 0153 __lock 016a __imp__InterlockedDecrement@4 0186 ___globallocalestatus 01c8 __SEH_epilog4 01d0 __unlock"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 DB 39 7D 0C 74 77 68 FF FF FF 7F FF 75 0C 57 57 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 14 3B C7 74 14 83 F8 16 74 05 83 F8 22 75 0A 57 57 57 57 57 E8 ?? ?? ?? ?? 39 7D E4 74 3D 6A 01 FF 75 E4 E8 ?? ?? ?? ?? 59 59 8B D8 3B DF 74 2B 6A FF FF 75 0C FF 75 E4 53 57 E8 ?? ?? ?? ?? 83 C4 14 3B C7 74 1C 83 F8 16 74 C4 83 F8 22 74 BF 3B C7 74 0E 53 E8 ?? ?? ?? ?? 59 33 C0 E9 38 01 00 00 53 8B 75 08 56 E8 ?? ?? ?? ?? 89 45 0C 53 E8 ?? ?? ?? ?? 83 C4 0C 39 7D 0C 74 DE E8 ?? ?? ?? ?? 89 45 DC 8B 48 6C 89 4D D0 8B 40 68 89 45 D4 89 7D E4 8D 45 D0 50 57 FF 75 0C 57 57 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 18 3B C7 74 16 83 F8 16 0F 84 58 FF FF FF 83 F8 22 0F 84 4F FF FF FF 3B C7 75 97 8B 45 E4 3D EE FF FF 7F 77 8D 8D 44 00 04 50 E8 ?? ?? ?? ?? 59 8B D8 89 5D D8 3B DF 0F 84 75 FF FF FF 8D 43 04 89 45 E0 8D 4D D0 51 6A FF FF 75 0C FF 75 E4 50 57 E8 ?? ?? ?? ?? 83 C4 18 3B C7 74 1A 83 F8 16 0F 84 00 FF FF FF 83 F8 22 0F 84 F7 FE FF FF 3B C7 0F 85 34 FF FF FF 8B 5D D0 6A 0C E8 ?? ?? ?? ?? 59 89 7D FC C1 E6 04 03 F3 8B 46 54 3B C7 74 14 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 45 DC F6 40 70 02 75 24 F6 05 ?? ?? ?? ?? 01 75 1B 8B 46 54 3B C7 74 14 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 0B 8B 45 D8 89 08 89 46 54 8B 45 E0 89 46 4C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__VEC_memzero"
		size = 186
	strings:
		$1 = { 66 0F EF C0 51 53 8B C1 83 E0 0F 85 C0 75 7F 8B C2 83 E2 7F C1 E8 07 74 37 8D A4 24 00 00 00 00 66 0F 7F 01 66 0F 7F 41 10 66 0F 7F 41 20 66 0F 7F 41 30 66 0F 7F 41 40 66 0F 7F 41 50 66 0F 7F 41 60 66 0F 7F 41 70 8D 89 80 00 00 00 48 75 D0 85 D2 74 37 8B C2 C1 E8 04 74 0F EB 03 8D 49 00 66 0F 7F 01 8D 49 10 48 75 F6 83 E2 0F 74 1C 8B C2 33 DB C1 EA 02 74 08 89 19 8D 49 04 4A 75 F8 83 E0 03 74 06 88 19 41 48 75 FA 5B 58 C3 8B D8 F7 DB 83 C3 10 2B D3 33 C0 52 8B D3 83 E2 03 74 06 88 01 41 4A 75 FA C1 EB 02 74 08 89 01 8D 49 04 4B 75 F8 5A E9 55 FF FF FF }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "_vfwprintf_helper"
		size = 138
		refs = "0003 __sehtable$_vfwprintf_helper 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0040 __lock_file 004b __stbuf 0064 __ftbuf 007b __SEH_epilog4 0084 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 0C 85 F6 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4B 33 C0 39 45 10 0F 95 C0 85 C0 74 DF 89 75 0C 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 E8 ?? ?? ?? ?? 8B F8 FF 75 18 FF 75 14 FF 75 10 56 FF 55 08 89 45 E4 56 57 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "__vfwprintf_l"
		size = 32
		refs = "0012 __woutput_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_1_0 {
	meta:
		name = "__vfprintf_l"
		size = 32
		refs = "0012 __output_l 0017 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_3_0 {
	meta:
		name = "__vfprintf_p_l"
		size = 32
		refs = "0012 __output_p_l 0017 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_2_0 {
	meta:
		name = "__vfprintf_s_l"
		size = 32
		refs = "0012 __output_s_l 0017 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_45_3_0 {
	meta:
		name = "__vfwprintf_p_l"
		size = 32
		refs = "0012 __woutput_p_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_45_2_0 {
	meta:
		name = "__vfwprintf_s_l"
		size = 32
		refs = "0012 __woutput_s_l 0017 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_45_4_0 {
	meta:
		name = "_vfwprintf"
		size = 31
		refs = "0011 __woutput_l 0016 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_6_0 {
	meta:
		name = "__vfprintf_p"
		size = 31
		refs = "0011 __output_p_l 0016 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_45_6_0 {
	meta:
		name = "__vfwprintf_p"
		size = 31
		refs = "0011 __woutput_p_l 0016 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_4_0 {
	meta:
		name = "_vfprintf"
		size = 31
		refs = "0011 __output_l 0016 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_541_5_0 {
	meta:
		name = "_vfprintf_s"
		size = 31
		refs = "0011 __output_s_l 0016 _vfprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_45_5_0 {
	meta:
		name = "_vfwprintf_s"
		size = 31
		refs = "0011 __woutput_s_l 0016 _vfwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 6A 00 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 679
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 __errno 0032 __invalid_parameter_noinfo 0077 _iswctype 00bf __wchartodigit 011f __aulldvrm 01d0 __allmul"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 53 FF 75 08 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 10 8B 5D 0C 33 C9 3B C1 74 02 89 18 3B D9 75 26 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D DC 00 74 07 8B 45 D8 83 60 70 FD 33 C0 33 D2 E9 58 02 00 00 39 4D 14 74 0C 83 7D 14 02 7C CF 83 7D 14 24 7F C9 56 0F B7 33 57 89 4D F8 89 4D FC 8D 7B 02 EB 06 0F B7 37 83 C7 02 6A 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 EC 66 83 FE 2D 75 06 83 4D 18 02 EB 06 66 83 FE 2B 75 06 0F B7 37 83 C7 02 8B 45 14 85 C0 0F 88 E4 01 00 00 83 F8 01 0F 84 DB 01 00 00 83 F8 24 0F 8F D2 01 00 00 6A 10 5B 85 C0 75 2D 56 E8 ?? ?? ?? ?? 59 85 C0 74 09 C7 45 14 0A 00 00 00 EB 3D 0F B7 07 83 F8 78 74 0E 83 F8 58 74 09 C7 45 14 08 00 00 00 EB 27 89 5D 14 39 5D 14 75 1F 56 E8 ?? ?? ?? ?? 59 85 C0 75 14 0F B7 07 83 F8 78 74 05 83 F8 58 75 07 0F B7 77 02 83 C7 04 8B 45 14 99 52 50 6A FF 6A FF 89 45 E0 89 55 E4 E8 ?? ?? ?? ?? 89 4D E8 89 5D EC 89 45 F0 89 55 F4 56 E8 ?? ?? ?? ?? 8B D8 59 83 FB FF 75 29 6A 41 58 66 3B C6 77 06 66 83 FE 5A 76 09 8D 46 9F 66 83 F8 19 77 52 8D 46 9F 66 83 F8 19 0F B7 C6 77 03 83 E8 20 8D 58 C9 3B 5D 14 73 3B 8B 4D FC 83 4D 18 08 3B 4D F4 72 4E 77 08 8B 45 F8 3B 45 F0 72 44 8B 45 F0 39 45 F8 75 13 3B 4D F4 75 0E 33 C0 3B 45 EC 72 30 77 05 3B 5D E8 76 29 83 4D 18 04 83 7D 10 00 75 3A 8B 45 18 83 EF 02 A8 08 75 3B 33 C0 39 45 10 74 03 8B 7D 0C 89 45 F8 89 45 FC E9 8C 00 00 00 51 FF 75 F8 FF 75 E4 FF 75 E0 E8 ?? ?? ?? ?? 33 C9 03 C3 13 D1 89 45 F8 89 55 FC 0F B7 37 83 C7 02 E9 44 FF FF FF BE FF FF FF 7F BB 00 00 00 80 A8 04 75 27 A8 01 75 54 83 E0 02 74 0D 39 5D FC 77 19 72 06 83 7D F8 00 77 11 85 C0 75 3E 39 75 FC 72 39 77 06 83 7D F8 FF 76 31 E8 ?? ?? ?? ?? F6 45 18 01 C7 00 22 00 00 00 74 0A 83 4D F8 FF 83 4D FC FF EB 16 F6 45 18 02 74 09 83 65 F8 00 89 5D FC EB 07 83 4D F8 FF 89 75 FC 8B 45 10 85 C0 74 02 89 38 F6 45 18 02 74 13 8B 45 F8 8B 4D FC F7 D8 83 D1 00 F7 D9 89 45 F8 89 4D FC 80 7D DC 00 74 07 8B 45 D8 83 60 70 FD 8B 45 F8 8B 55 FC EB 1A 8B 45 10 85 C0 74 02 89 18 80 7D DC 00 74 07 8B 45 D8 83 60 70 FD 33 C0 33 D2 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__CIlog10_pentium4"
		size = 656
		refs = "0039 emask 0041 CC 0049 One 0051 Magic 0059 hi_mask 0077 CB_Tbl 007f T_Tbl 00e1 coeff 010d LOG10_2 0119 place_L 0180 Zero 01cf Infs 01fa Two52 024b ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 BE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E9 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 08 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 17 FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 09 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E9 03 00 00 EB A6 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__MarkAllocaS"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 08 8B 4D 0C 89 08 83 C0 08 5D C3 }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "__freea"
		size = 32
		refs = "0019 _free"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 12 83 E8 08 81 38 DD DD 00 00 75 07 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_48_5_0 {
	meta:
		name = "?_wcslwr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
		size = 368
		refs = "0008 ___security_cookie 001d __errno 0027 __invalid_parameter_noinfo 0035 _wcsnlen 0089 ___crtLCMapStringW 00e2 __alloca_probe_16 00f6 _malloc 013e _wcscpy_s 0157 __freea 016a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B F1 33 DB 57 3B F3 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 2C 01 00 00 FF 75 08 56 E8 ?? ?? ?? ?? 59 59 3B 45 08 72 07 33 C0 66 89 06 EB D5 8B 45 0C 8B 00 8B 40 14 3B C3 75 29 8B C6 66 39 1E 74 1B 0F B7 08 83 F9 41 72 0B 83 F9 5A 77 06 83 C1 20 66 89 08 83 C0 02 66 39 18 75 E5 33 C0 E9 E2 00 00 00 53 53 6A FF 56 BF 00 01 00 00 57 50 E8 ?? ?? ?? ?? 8B C8 83 C4 18 89 4D F8 3B CB 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 AE 00 00 00 39 4D 08 73 11 33 C0 66 89 06 E8 ?? ?? ?? ?? 6A 22 E9 5D FF FF FF 3B CB 7E 43 6A E0 33 D2 58 F7 F1 83 F8 02 72 37 8D 44 09 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 3B C3 74 09 C7 00 DD DD 00 00 83 C0 08 8B 4D F8 8B D8 85 DB 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 86 8B 45 0C 8B 00 51 53 6A FF 56 57 FF 70 14 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 11 53 FF 75 08 56 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0C E8 ?? ?? ?? ?? 6A 2A 59 89 08 8B F1 53 E8 ?? ?? ?? ?? 59 8B C6 8D 65 EC 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_48_6_0 {
	meta:
		name = "__wcslwr_s_l"
		size = 51
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001e ?_wcslwr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F0 50 FF 75 0C E8 ?? ?? ?? ?? 80 7D FC 00 59 59 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_962_6_0 {
	meta:
		name = "__wcsupr_s_l"
		size = 51
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001e ?_wcsupr_s_l_stat@@YAHPA_WIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F0 50 FF 75 0C E8 ?? ?? ?? ?? 80 7D FC 00 59 59 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_48_8_0 {
	meta:
		name = "__wcslwr_l"
		size = 26
		refs = "000e __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_466_8_0 {
	meta:
		name = "__strlwr_l"
		size = 26
		refs = "000e __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_534_8_0 {
	meta:
		name = "__strupr_l"
		size = 26
		refs = "000e __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_962_8_0 {
	meta:
		name = "__wcsupr_l"
		size = 26
		refs = "000e __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_48_9_0 {
	meta:
		name = "__wcslwr"
		size = 104
		refs = "0007 ___locale_changed 0016 __errno 0021 __invalid_parameter_noinfo 005c __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 46 8B 45 08 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5D C3 66 83 38 00 8B C8 74 35 57 0F B7 11 6A 41 5F 66 3B FA 77 0B 83 FA 5A 77 06 83 C2 20 66 89 11 83 C1 02 66 83 39 00 75 E1 5F 5D C3 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__rmdir"
		size = 48
		refs = "000a __imp__RemoveDirectoryA@4 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_866_0_0 {
	meta:
		name = "__wremove"
		size = 48
		refs = "000a __imp__DeleteFileW@4 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "__wrmdir"
		size = 48
		refs = "000a __imp__RemoveDirectoryW@4 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "_remove"
		size = 48
		refs = "000a __imp__DeleteFileA@4 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__execv"
		size = 71
		refs = "0010 __errno 001b __invalid_parameter_noinfo 003d __execve"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 33 D2 3B F2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 20 38 16 74 E7 8B 4D 0C 3B CA 74 E0 8B 01 3B C2 74 DA 38 10 74 D6 52 51 56 E8 ?? ?? ?? ?? 83 C4 0C 5E 5D C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__seterrormode"
		size = 16
		refs = "000a __imp__SetErrorMode@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_64_2_1 {
	meta:
		name = "?_Mtx_lock@threads@stdext@@YAXPAX@Z"
		size = 16
		refs = "000a __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_64_3_1 {
	meta:
		name = "?_Mtx_unlock@threads@stdext@@YAXPAX@Z"
		size = 16
		refs = "000a __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_91_2_1 {
	meta:
		name = "__Mtxdst"
		size = 16
		refs = "000a __imp__DeleteCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_91_1_1 {
	meta:
		name = "__Mtxinit"
		size = 16
		refs = "000a __imp__InitializeCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_91_3_1 {
	meta:
		name = "__Mtxlock"
		size = 16
		refs = "000a __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_91_4_1 {
	meta:
		name = "__Mtxunlock"
		size = 16
		refs = "000a __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_755_0_0 {
	meta:
		name = "__loaddll"
		size = 16
		refs = "000a __imp__LoadLibraryA@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_localeconv"
		size = 38
		refs = "0001 __getptd 000a ___ptlocinfo 0012 ___globallocalestatus 001c ___updatetlocinfo 0021 ___lconv"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 48 6C 3B 0D ?? ?? ?? ?? 74 10 8B 0D ?? ?? ?? ?? 85 48 70 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "___libm_sse2_atan"
		size = 530
		refs = "0007 _BMASK1 0013 _BMASK2 001b _SGNMASK 0059 _ONEMASK 00a2 _a2 00aa _b2 00bf _atan_tbl 01ca _pi_table"
	strings:
		$1 = { 83 EC 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 D2 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 3D ?? ?? ?? ?? 66 0F C5 D0 03 8B C2 81 E2 FF 7F 00 00 66 0F 13 44 24 04 B9 40 40 00 00 66 0F C4 D1 03 66 0F 54 C7 66 0F 57 FF F2 0F 10 C8 66 0F 54 D8 66 0F C4 F9 03 66 0F 56 DE 66 0F 12 2D ?? ?? ?? ?? 81 EA A0 3F 00 00 81 FA 5F 04 00 00 0F 87 BD 00 00 00 83 C4 0C F2 0F C2 D0 06 F2 0F 5D DF 66 0F 54 EA 66 0F 54 C2 F2 0F 59 CB F2 0F 5C C3 F2 0F 58 CD F2 0F 5E C1 66 0F C5 D3 03 81 EA 9F 3F 00 00 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 25 ?? ?? ?? ?? 25 00 80 00 00 66 0F C4 F8 03 03 D2 66 0F 12 34 D5 ?? ?? ?? ?? 83 C2 01 66 0F 12 2C D5 ?? ?? ?? ?? 66 0F 57 EF 66 0F 57 F7 F2 0F 10 C8 66 0F 57 CF F2 0F 10 D9 F2 0F 59 C0 F2 0F 59 D0 F2 0F 58 E0 F2 0F 58 CE F2 0F 5C F1 F2 0F 58 F3 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 D8 F2 0F 58 F5 F2 0F 59 D3 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 D6 F2 0F 58 CA 66 0F 28 C1 C3 81 C2 B0 03 00 00 81 FA 0F 08 00 00 77 56 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 44 24 04 83 C4 0C F2 0F 59 C9 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 F9 F2 0F 10 F1 F2 0F 59 C8 F2 0F 58 D4 F2 0F 59 FE F2 0F 59 D1 F2 0F 58 FD F2 0F 59 D7 F2 0F 58 C2 C3 81 C2 F0 3B 00 00 81 FA F0 43 00 00 73 17 66 0F 12 44 24 04 83 C4 0C 83 FA 10 66 0F 28 C8 73 04 F2 0F 59 C9 C3 66 0F 12 64 24 04 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 66 0F 73 D1 20 66 0F 7E CA 81 FA 00 00 F0 7F 73 11 66 0F 55 C4 66 0F 56 D0 66 0F 56 C3 F2 0F 58 C2 C3 81 EA 00 00 F0 7F 0B C2 83 F8 00 74 E2 F2 0F 10 C4 F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "_atol"
		size = 22
		refs = "000d _strtol"
	strings:
		$1 = { 8B FF 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_55_4_0 {
	meta:
		name = "__atoi64"
		size = 22
		refs = "000d __strtoi64"
	strings:
		$1 = { 8B FF 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_458_4_0 {
	meta:
		name = "__wtoi64"
		size = 22
		refs = "000d __wcstoi64"
	strings:
		$1 = { 8B FF 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "__wtol"
		size = 22
		refs = "000d _wcstol"
	strings:
		$1 = { 8B FF 55 8B EC 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "__atol_l"
		size = 25
		refs = "0010 __strtol_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_55_5_0 {
	meta:
		name = "__atoi64_l"
		size = 25
		refs = "0010 __strtoi64_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_458_5_0 {
	meta:
		name = "__wtoi64_l"
		size = 25
		refs = "0010 __wcstoi64_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_458_1_0 {
	meta:
		name = "__wtol_l"
		size = 25
		refs = "0010 __wcstol_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 0A 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__filelengthi64"
		size = 270
		refs = "0003 __sehtable$__filelengthi64 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0039 __nhandle 0052 __invalid_parameter_noinfo 0060 ___pioinfo 007a ___lock_fhandle 0093 __lseeki64_nolock 00ff __SEH_epilog4 0108 __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1D E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF 0B D0 E9 CD 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 19 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB CF 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0B 0F BE 4C 31 04 83 E1 01 74 C7 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 47 6A 01 57 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B F0 8B DA 23 C3 83 F8 FF 74 3F 6A 02 57 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC 89 55 E0 3B F0 75 04 3B DA 74 2A 57 53 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 1A E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D DC FF 83 4D E0 FF C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 DC 8B 55 E0 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "___report_gsfailure"
		size = 262
		refs = "000c _GS_ContextRecord 008d _GS_ExceptionRecord 00a6 ___security_cookie 00b1 ___security_cookie_complement 00bd __imp__IsDebuggerPresent@0 00c2 _DebuggerWasPresent 00c9 __crt_debugger_hook 00d2 __imp__SetUnhandledExceptionFilter@4 00d7 _GS_ExceptionPointers 00dd __imp__UnhandledExceptionFilter@4 00f9 __imp__GetCurrentProcess@0 0100 __imp__TerminateProcess@8"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 28 03 00 00 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 E0 FC FF FF C7 05 ?? ?? ?? ?? 01 00 01 00 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 A1 ?? ?? ?? ?? 89 85 D8 FC FF FF A1 ?? ?? ?? ?? 89 85 DC FC FF FF FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 59 6A 00 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 6A 01 E8 ?? ?? ?? ?? 59 68 09 04 00 C0 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "?name@type_info@@QBEPBDPAU__type_info_node@@@Z"
		size = 20
		refs = "000a ?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 51 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_58_3_0 {
	meta:
		name = "?_name_internal_method@type_info@@QBEPBDPAU__type_info_node@@@Z"
		size = 20
		refs = "000a ?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 51 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "??1type_info@@UAE@XZ"
		size = 16
		refs = "0005 ??_7type_info@@6B@ 000a ?_Type_info_dtor@type_info@@CAXPAV1@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_44_42_2 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 16
		refs = "0005 ??_7ios_base@std@@6B@ 000a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_63_43_2 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 16
		refs = "0005 ??_7ios_base@std@@6B@ 000a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_60_43_2 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 16
		refs = "0005 ??_7ios_base@std@@6B@ 000a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_39_36_2 {
	meta:
		name = "??1ios_base@std@@UAE@XZ"
		size = 16
		refs = "0005 ??_7ios_base@std@@6B@ 000a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 8B FF 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_58_2_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1type_info@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_1063_1 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_1001_1 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_767_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_829_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_93_236_2 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_63_247_2 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_59_271_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_89_132_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_63_127_2 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_0_140_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_907_2 {
	meta:
		name = "??_G?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_38_83_2 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$ctype@G@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_59_97_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$ctype@_W@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_570_1 {
	meta:
		name = "??_G?$function@$$A6A_NABI@Z@tr1@std@@QAEPAXI@Z"
		size = 33
		refs = "0009 ?_Tidy@?$_Function_impl1@_NABI@tr1@std@@IAEXXZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_316_1 {
	meta:
		name = "??_G?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@QAEPAXI@Z"
		size = 33
		refs = "0009 ?_Tidy@?$_Function_impl1@_NABW4agent_status@Concurrency@@@tr1@std@@IAEXXZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_572_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_568_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_569_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_566_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_571_1 {
	meta:
		name = "??_G?$ordered_message_processor@I@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_567_1 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_993_2 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_906_2 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_905_1 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_921_2 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_994_1 {
	meta:
		name = "??_G?$single_assignment@I@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$single_assignment@I@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_222_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_292_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_773_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_772_1 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_613_2 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_774_1 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_43_150_2 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_71_356_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_71_176_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_590_71_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_718_62_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1ExternalContextBase@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_590_72_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_117_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1InternalContextBase@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_429_134_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AAEPAXI@Z"
		size = 33
		refs = "0009 ??1ResourceManager@details@Concurrency@@AAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_590_50_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1ScheduleGroupBase@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_313_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1SchedulerBase@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_84_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1SchedulerPolicy@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_487_77_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IAEPAXI@Z"
		size = 33
		refs = "0009 ??1SchedulerProxy@details@Concurrency@@IAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_65_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1SchedulingNode@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_66_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1SchedulingRing@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_55_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1TaskStack@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_849_20_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1ThreadProxy@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_764_15_0 {
	meta:
		name = "??_GTransmogrificator@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1Transmogrificator@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_802_15_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1TransmogrifiedPrimary@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_9_0 {
	meta:
		name = "??_GUMSBackgroundPoller@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1UMSBackgroundPoller@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_772_80_0 {
	meta:
		name = "??_GUMSFreeThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1UMSFreeThreadProxy@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_93_84_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_93_46_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_221_36_0 {
	meta:
		name = "??_GUMSThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1UMSThreadInternalContext@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_179_40_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1UMSThreadProxy@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_914_20_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1UMSThreadVirtualProcessor@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_698_46_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1VirtualProcessor@details@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_590_37_0 {
	meta:
		name = "??_GWorkQueue@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1WorkQueue@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_38_42_1 {
	meta:
		name = "??_G_Concurrent_queue_base_v4@details@Concurrency@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1_Concurrent_queue_base_v4@details@Concurrency@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_36_13_1 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1_Fac_node@std@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_42_41_2 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 33
		refs = "0009 ??1_Locimp@locale@std@@MAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_655_2 {
	meta:
		name = "??_G_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_654_2 {
	meta:
		name = "??_G_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_137_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1_TaskCollection@details@Concurrency@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_405_41_0 {
	meta:
		name = "??_G__ExceptionPtr@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1__ExceptionPtr@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_1023_2 {
	meta:
		name = "??_Gagent@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1agent@Concurrency@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_5_1 {
	meta:
		name = "??_Gbad_function_call@tr1@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_130_2 {
	meta:
		name = "??_Gbad_target@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_53_5_1 {
	meta:
		name = "??_Gbad_weak_ptr@tr1@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_96_0 {
	meta:
		name = "??_Gcontext_self_unblock@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_95_0 {
	meta:
		name = "??_Gcontext_unblock_unbalanced@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_267_0 {
	meta:
		name = "??_Gdefault_scheduler_exists@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_45_19_1 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_347_68_0 {
	meta:
		name = "??_Gimproper_lock@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_75_0 {
	meta:
		name = "??_Gimproper_scheduler_attach@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_76_0 {
	meta:
		name = "??_Gimproper_scheduler_detach@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_77_0 {
	meta:
		name = "??_Gimproper_scheduler_reference@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_495_17_0 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_119_1 {
	meta:
		name = "??_Ginvalid_link_target@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_90_0 {
	meta:
		name = "??_Ginvalid_multiple_scheduling@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_219_2 {
	meta:
		name = "??_Ginvalid_operation@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_91_0 {
	meta:
		name = "??_Ginvalid_oversubscribe_operation@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_448_13_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_key@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_86_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_85_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_value@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_37_23_1 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_16_51_1 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 33
		refs = "0009 ??1locale@std@@QAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_821_49_0 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_82_0 {
	meta:
		name = "??_Gmessage_not_found@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_781_31_0 {
	meta:
		name = "??_Gmissing_wait@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_88_0 {
	meta:
		name = "??_Gnested_scheduler_missing_detach@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_30_161_1 {
	meta:
		name = "??_Goperation_timed_out@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_37_24_1 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_37_26_1 {
	meta:
		name = "??_Goverflow_error@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_17_43_1 {
	meta:
		name = "??_Grange_error@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_50_13_1 {
	meta:
		name = "??_Gregex_error@tr1@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_83_64_2 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_107_9_0 {
	meta:
		name = "??_Gscheduler_not_attached@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_772_12_0 {
	meta:
		name = "??_Gscheduler_resource_allocation_error@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_39_99_1 {
	meta:
		name = "??_Gsystem_error@std@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_994_29_0 {
	meta:
		name = "??_Gtask_canceled@details@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_429_69_0 {
	meta:
		name = "??_Gunsupported_os@Concurrency@@UAEPAXI@Z"
		size = 33
		refs = "0009 ??1exception@std@@UAE@XZ 0015 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_5_0 {
	meta:
		name = "??8type_info@@QBE_NABV0@@Z"
		size = 32
		refs = "0011 _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 40 5D C2 04 00 }
	condition:
		$1
}

rule file_58_6_0 {
	meta:
		name = "??9type_info@@QBE_NABV0@@Z"
		size = 33
		refs = "0011 _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? F7 D8 59 1B C0 59 F7 D8 5D C2 04 00 }
	condition:
		$1
}

rule file_58_7_0 {
	meta:
		name = "?before@type_info@@QBEHABV1@@Z"
		size = 36
		refs = "0011 _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 C1 09 51 83 C0 09 50 E8 ?? ?? ?? ?? 59 59 33 C9 85 C0 0F 9F C1 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_61_3_0 {
	meta:
		name = "__mbsnlen_l"
		size = 121
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D F4 33 D2 39 53 08 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 3C 56 8B 75 0C 57 33 FF 85 F6 74 29 8B 45 08 8A 08 84 C9 74 1C 0F B6 C9 F6 44 19 1D 04 74 0B 42 3B D6 73 11 40 80 38 00 74 07 47 40 42 3B D6 72 DE 3B D6 72 04 8B C6 EB 02 8B C7 5F 5E 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "??0logic_error@std@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_68_0_1 {
	meta:
		name = "??0bad_alloc@std@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_8_0 {
	meta:
		name = "??0bad_cast@std@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_974_0_0 {
	meta:
		name = "??0bad_exception@std@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_34_0 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_635_10_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_27_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_24_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_21_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_67_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_12_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_15_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_18_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_40_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_61_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_52_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_64_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_43_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_49_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_46_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_37_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_30_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_55_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_58_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_60_9_2 {
	meta:
		name = "??0runtime_error@std@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_9_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_70_0 {
	meta:
		name = "??0task_canceled@details@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7task_canceled@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_250_6_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@PBD@Z"
		size = 30
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0013 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_63_2_0 {
	meta:
		name = "??0invalid_argument@std@@QAE@PBD@Z"
		size = 36
		refs = "0013 ??0exception@std@@QAE@ABQBD@Z 0019 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_405_20_0 {
	meta:
		name = "??0length_error@std@@QAE@PBD@Z"
		size = 36
		refs = "0013 ??0exception@std@@QAE@ABQBD@Z 0019 ??_7length_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_17_7_1 {
	meta:
		name = "??0out_of_range@std@@QAE@PBD@Z"
		size = 36
		refs = "0013 ??0exception@std@@QAE@ABQBD@Z 0019 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_37_10_1 {
	meta:
		name = "??0overflow_error@std@@QAE@PBD@Z"
		size = 36
		refs = "0013 ??0exception@std@@QAE@ABQBD@Z 0019 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_17_11_1 {
	meta:
		name = "??0range_error@std@@QAE@PBD@Z"
		size = 36
		refs = "0013 ??0exception@std@@QAE@ABQBD@Z 0019 ??_7range_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 89 45 08 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_63_5_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@XZ"
		size = 30
		refs = "000b _memset"
	strings:
		$1 = { 8B FF 56 6A 0C 8B F1 6A 00 56 E8 ?? ?? ?? ?? 33 C0 21 06 66 89 46 04 83 C4 0C 8B C6 5E C3 }
	condition:
		$1
}

rule file_63_6_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@GK@Z"
		size = 41
		refs = "000e _memset"
	strings:
		$1 = { 8B FF 55 8B EC 56 6A 0C 8B F1 6A 00 56 E8 ?? ?? ?? ?? 66 8B 45 08 66 89 46 04 8B 45 0C 89 06 83 C4 0C 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_63_7_0 {
	meta:
		name = "??4HardwareAffinity@details@Concurrency@@QAEAAU012@ABU012@@Z"
		size = 26
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 8B 4D 08 66 8B 51 04 66 89 50 04 8B 09 89 08 5D C2 04 00 }
	condition:
		$1
}

rule file_63_8_0 {
	meta:
		name = "??_H@YGXPAXIHP6EPAX0@Z@Z"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC FF 4D 10 78 12 56 8B 75 08 8B CE FF 55 14 03 75 0C FF 4D 10 79 F3 5E 5D C2 10 00 }
	condition:
		$1
}

rule file_63_12_0 {
	meta:
		name = "?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QAE?AUHardwareAffinity@23@I@Z"
		size = 38
		refs = "001b ??0HardwareAffinity@details@Concurrency@@QAE@GK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 49 10 6B C0 2C FF 34 08 0F B7 44 08 10 8B 4D 08 50 E8 ?? ?? ?? ?? 8B 45 08 5D C2 08 00 }
	condition:
		$1
}

rule file_63_16_0 {
	meta:
		name = "??0ExecutionResource@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAV012@@Z"
		size = 87
		refs = "000a ??_7ExecutionResource@details@Concurrency@@6B@ 001a ??0HardwareAffinity@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? 57 8D 4E 08 C7 46 04 00 00 00 00 E8 ?? ?? ?? ?? 8B 7D 0C 8B 45 08 83 66 1C 00 83 66 20 00 89 46 14 89 7E 18 8B 07 8B CF FF 10 89 46 24 8B 47 28 83 66 30 00 89 46 28 8B 07 8B CF FF 50 04 89 46 2C 5F 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_63_19_0 {
	meta:
		name = "?Remove@ExecutionResource@details@Concurrency@@UAEXPAUIScheduler@3@@Z"
		size = 109
		refs = "001d ??_C@_0L@HKFDMHB@pScheduler?$AA@ 0022 ??0exception@std@@QAE@ABQBD@Z 0029 ??_7invalid_argument@std@@6B@ 002e __TI3?AVinvalid_argument@std@@ 0037 __CxxThrowException@8 003f ?GetCurrentThreadExecutionResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@XZ 004b ??0invalid_operation@Concurrency@@QAE@XZ 0050 __TI2?AVinvalid_operation@Concurrency@@ 0063 ?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 57 8B 7D 08 8B F1 85 FF 75 28 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 F4 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 4E 14 E8 ?? ?? ?? ?? 3B C6 74 0F 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB DC 8B 46 14 39 78 08 75 E9 8B 48 0C 56 E8 ?? ?? ?? ?? 5F 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_63_24_0 {
	meta:
		name = "?SetAsCurrent@ExecutionResource@details@Concurrency@@QAEXXZ"
		size = 36
		refs = "0012 __imp__TlsGetValue@4 001d __imp__TlsSetValue@8"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 14 8B 40 0C 57 8B 78 70 57 FF 15 ?? ?? ?? ?? 56 57 89 46 20 FF 15 ?? ?? ?? ?? 5F 5E C3 }
	condition:
		$1
}

rule file_63_25_0 {
	meta:
		name = "?ResetCurrent@ExecutionResource@details@Concurrency@@QAEXXZ"
		size = 29
		refs = "0013 __imp__TlsSetValue@8"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 14 FF 76 20 8B 40 0C FF 70 70 FF 15 ?? ?? ?? ?? 83 66 20 00 5E C3 }
	condition:
		$1
}

rule file_63_26_0 {
	meta:
		name = "?IncrementUseCounts@ExecutionResource@details@Concurrency@@QAEXXZ"
		size = 180
		refs = "0009 ___security_cookie 0045 ?IncrementFixedCoreCount@SchedulerProxy@details@Concurrency@@QAEXII_N@Z 0050 __imp__GetCurrentThread@0 005b ??0HardwareAffinity@details@Concurrency@@QAE@PAX@Z 0077 ?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QAE?AUHardwareAffinity@23@I@Z 0080 ?ApplyTo@HardwareAffinity@details@Concurrency@@QAEXPAX@Z 0089 ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0092 ?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 009b ?AddThreadSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 00a2 ?SetAsCurrent@ExecutionResource@details@Concurrency@@QAEXXZ 00ae @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B F1 8B 46 30 8D 48 01 89 4E 30 85 C0 0F 85 81 00 00 00 39 46 1C 8B 4E 14 53 0F 95 C3 39 46 18 75 64 84 DB 0F 94 C0 0F B6 C0 50 FF 76 28 FF 76 24 E8 ?? ?? ?? ?? 84 DB 75 52 57 FF 15 ?? ?? ?? ?? 8B F8 57 8D 4D E4 E8 ?? ?? ?? ?? 66 8B 48 04 66 89 4E 0C 8B 00 89 46 08 FF 76 24 8B 4E 14 8D 45 F0 50 E8 ?? ?? ?? ?? 57 8D 4D F0 E8 ?? ?? ?? ?? 8B 4E 14 56 E8 ?? ?? ?? ?? 8B 4E 14 56 E8 ?? ?? ?? ?? 5F EB 06 56 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_63_27_0 {
	meta:
		name = "?DecrementUseCounts@ExecutionResource@details@Concurrency@@QAEXXZ"
		size = 109
		refs = "0013 ?ResetCurrent@ExecutionResource@details@Concurrency@@QAEXXZ 0031 ?DecrementFixedCoreCount@SchedulerProxy@details@Concurrency@@QAEXII_N@Z 003b __imp__GetCurrentThread@0 0044 ?ApplyTo@HardwareAffinity@details@Concurrency@@QAEXPAX@Z 004d ?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0056 ?DestroyExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 005d ?DecrementUseCounts@ExecutionResource@details@Concurrency@@QAEXXZ 0066 ?RemoveThreadSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
	strings:
		$1 = { 8B FF 56 8B F1 FF 4E 30 75 61 83 7E 1C 00 53 0F 95 C3 E8 ?? ?? ?? ?? 8B 4E 18 85 C9 75 3E 8B 4E 14 84 DB 0F 94 C0 0F B6 C0 50 FF 76 28 FF 76 24 E8 ?? ?? ?? ?? 84 DB 75 31 FF 15 ?? ?? ?? ?? 50 8D 4E 08 E8 ?? ?? ?? ?? 8B 4E 14 56 E8 ?? ?? ?? ?? 8B 4E 14 56 E8 ?? ?? ?? ?? EB 0E E8 ?? ?? ?? ?? 8B 4E 14 56 E8 ?? ?? ?? ?? 5B 5E C3 }
	condition:
		$1
}

rule file_63_28_0 {
	meta:
		name = "?CurrentSubscriptionLevel@ExecutionResource@details@Concurrency@@UBEIXZ"
		size = 20
		refs = "000f ?CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QAEIII@Z"
	strings:
		$1 = { 8B C1 FF 70 28 8B 48 14 FF 70 24 8B 49 0C E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_63_31_0 {
	meta:
		name = "??0ExecutionResource@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 91
		refs = "000b ??_7ExecutionResource@details@Concurrency@@6B@ 0018 ??0HardwareAffinity@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 57 C7 06 ?? ?? ?? ?? 33 FF 8D 4E 08 89 7E 04 E8 ?? ?? ?? ?? 8B 45 08 8B 4D 0C 89 46 14 89 7E 18 89 7E 1C 89 7E 20 8B 41 14 89 46 24 8B 45 10 89 46 28 6B C0 2C 89 7E 30 8B 51 28 0F B6 44 02 04 8B 49 10 C1 E1 08 03 C1 89 46 2C 5F 8B C6 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "_fast_error_exit"
		size = 41
		refs = "0007 ___error_mode 000f __FF_MSGBANNER 0017 __NMSG_WRITE 0021 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "_check_managed_app"
		size = 71
		refs = "0008 ___ImageBase"
	strings:
		$1 = { B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 03 33 C0 C3 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 EC B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 DE 83 B8 ?? ?? ?? ?? 0E 76 D5 33 C9 39 88 ?? ?? ?? ?? 0F 95 C1 8B C1 C3 }
	condition:
		$1
}

rule file_65_2_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 353
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 0010 __NoHeapEnableTerminationOnCorruption 001d __imp__HeapSetInformation@16 0029 ___ImageBase 006b __heap_init 0076 _fast_error_exit 007c __mtinit 008d __RTC_Initialize 0095 __ioinit 00a0 __amsg_exit 00a7 __imp__GetCommandLineW@0 00ac __wcmdln 00b1 ___crtGetEnvironmentStringsW 00b6 __wenvptr 00bb __wsetargv 00cc __wsetenvp 00df __cinit 00f0 __wenviron 00f5 ___winitenv 00fc ___wargv 0102 ___argc 0107 _wmain 0118 _exit 011d __cexit 0130 __XcptFilter 0148 __exit 014d __c_exit 015c __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 35 ?? ?? ?? ?? 75 0B 56 56 6A 01 56 FF 15 ?? ?? ?? ?? B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 05 89 75 E4 EB 36 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 EA B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 DC 83 B8 ?? ?? ?? ?? 0E 76 D3 33 C9 39 B0 ?? ?? ?? ?? 0F 95 C1 89 4D E4 E8 ?? ?? ?? ?? 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 89 75 FC E8 ?? ?? ?? ?? 85 C0 79 08 6A 1B E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 79 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 3B C6 74 07 50 E8 ?? ?? ?? ?? 59 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 50 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 39 75 E4 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 45 EC 8B 08 8B 09 89 4D DC 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 45 DC 89 45 E0 83 7D E4 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_828_2_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 353
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 0010 __NoHeapEnableTerminationOnCorruption 001d __imp__HeapSetInformation@16 0029 ___ImageBase 006b __heap_init 0076 _fast_error_exit 007c __mtinit 008d __RTC_Initialize 0095 __ioinit 00a0 __amsg_exit 00a7 __imp__GetCommandLineA@0 00ac __acmdln 00b1 ___crtGetEnvironmentStringsA 00b6 __aenvptr 00bb __setargv 00cc __setenvp 00df __cinit 00f0 __environ 00f5 ___initenv 00fc ___argv 0102 ___argc 0107 _main 0118 _exit 011d __cexit 0130 __XcptFilter 0148 __exit 014d __c_exit 015c __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 35 ?? ?? ?? ?? 75 0B 56 56 6A 01 56 FF 15 ?? ?? ?? ?? B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 05 89 75 E4 EB 36 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 EA B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 DC 83 B8 ?? ?? ?? ?? 0E 76 D3 33 C9 39 B0 ?? ?? ?? ?? 0F 95 C1 89 4D E4 E8 ?? ?? ?? ?? 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 89 75 FC E8 ?? ?? ?? ?? 85 C0 79 08 6A 1B E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 79 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 3B C6 74 07 50 E8 ?? ?? ?? ?? 59 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? 50 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 39 75 E4 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 45 EC 8B 08 8B 09 89 4D DC 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 45 DC 89 45 E0 83 7D E4 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__wspawnlpe"
		size = 84
		refs = "000d __errno 0018 __invalid_parameter_noinfo 004b __wspawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 66 83 39 00 74 E5 8B 45 10 85 C0 74 DE 66 83 38 00 74 D8 8D 45 10 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "__wspawnle"
		size = 84
		refs = "000d __errno 0018 __invalid_parameter_noinfo 004b __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 66 83 39 00 74 E5 8B 45 10 85 C0 74 DE 66 83 38 00 74 D8 8D 45 10 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__chdir"
		size = 297
		refs = "000c ___security_cookie 0032 ___doserrno 003a __errno 0045 __invalid_parameter_noinfo 0056 __imp__SetCurrentDirectoryA@4 0070 __imp__GetCurrentDirectoryA@8 0085 __calloc_crt 00c8 __mbctoupper 00e6 __imp__SetEnvironmentVariableA@8 00f9 __imp__GetLastError@0 00ff __dosmaperr 0111 _free 0123 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 18 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 A5 E8 FE FF FF 00 83 8D EC FE FF FF FF 56 8D B5 F4 FE FF FF 85 C0 75 20 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 CB 00 00 00 53 57 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 95 00 00 00 8D 85 F4 FE FF FF 50 68 05 01 00 00 FF 15 ?? ?? ?? ?? 8B F8 81 FF 04 01 00 00 7E 2B 8D 5F 01 6A 01 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 66 C7 85 E8 FE FF FF 01 00 00 00 85 FF 74 58 56 53 FF 15 ?? ?? ?? ?? 8B F8 85 FF 74 4A 8A 06 3C 5C 74 04 3C 2F 75 05 3A 46 01 74 32 C6 85 F0 FE FF FF 3D 0F B6 06 50 E8 ?? ?? ?? ?? 59 88 85 F1 FE FF FF 56 8D 85 F0 FE FF FF 50 66 C7 85 F2 FE FF FF 3A 00 FF 15 ?? ?? ?? ?? 85 C0 74 09 83 A5 EC FE FF FF 00 EB 0D FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 BD E8 FE FF FF 00 5F 5B 74 07 56 E8 ?? ?? ?? ?? 59 8B 85 EC FE FF FF 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "___addl"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 8B 75 0C 8D 0C 32 33 C0 3B CA 72 04 3B CE 73 03 33 C0 40 8B 55 10 89 0A 5E 5D C3 }
	condition:
		$1
}

rule file_68_1_0 {
	meta:
		name = "___add_12"
		size = 113
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 53 56 57 8B 7D 0C 8B 17 8D 34 11 33 DB 3B F1 72 04 3B F2 73 03 33 DB 43 89 30 85 DB 74 1E 8B 48 04 8D 51 01 33 F6 3B D1 72 05 83 FA 01 73 03 33 F6 46 89 50 04 85 F6 74 03 FF 40 08 8B 48 04 8B 57 04 8D 34 11 33 DB 3B F1 72 04 3B F2 73 03 33 DB 43 89 70 04 85 DB 74 03 FF 40 08 8B 4F 08 01 48 08 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_68_2_0 {
	meta:
		name = "___shl_12"
		size = 51
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B 30 8B CE 03 F6 57 8B 78 04 C1 E9 1F 89 30 8D 34 3F 0B F1 8B 48 08 8B D7 C1 EA 1F 03 C9 0B CA 5F 89 70 04 89 48 08 5E 5D C3 }
	condition:
		$1
}

rule file_68_3_0 {
	meta:
		name = "___mtold12"
		size = 484
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 10 53 33 DB 56 57 C7 45 FC 4E 40 00 00 89 18 89 58 04 89 58 08 39 5D 0C 0F 86 45 01 00 00 89 5D 10 8B 08 8B F0 8D 7D E8 A5 A5 A5 8B D1 8D 3C 09 C1 EA 1F 8D 0C 1B 0B CA 8B 55 10 83 65 10 00 8B F3 8B D9 89 7D F8 C1 EE 1F 03 D2 0B D6 8B 75 F8 03 C9 C1 EF 1F 0B CF 8B F9 89 4D F8 8D 0C 12 8B 55 E8 03 F6 C1 EB 1F 0B CB 03 D6 89 30 89 78 04 89 48 08 3B D6 72 05 3B 55 E8 73 07 C7 45 10 01 00 00 00 83 7D 10 00 89 10 74 27 8B 75 F8 83 65 10 00 8D 7E 01 3B FE 72 05 83 FF 01 73 07 C7 45 10 01 00 00 00 83 7D 10 00 89 78 04 74 04 41 89 48 08 8B 75 EC 83 65 10 00 8D 1C 37 3B DF 72 04 3B DE 73 07 C7 45 10 01 00 00 00 83 7D 10 00 89 58 04 74 04 41 89 48 08 03 4D F0 83 65 F8 00 8B FB 03 C9 8B F2 C1 EF 1F 0B CF C1 EE 1F 03 DB 03 D2 0B DE 89 48 08 89 4D F4 89 4D 10 8B 4D 08 89 10 89 58 04 0F BE 31 8D 0C 32 89 75 E8 3B CA 72 04 3B CE 73 07 C7 45 F8 01 00 00 00 83 7D F8 00 89 08 74 24 8D 4B 01 33 D2 3B CB 72 05 83 F9 01 73 03 33 D2 42 8B D9 89 48 04 85 D2 74 0A 8B 4D F4 41 89 4D 10 89 48 08 FF 4D 0C 8B 4D 10 FF 45 08 83 7D 0C 00 89 58 04 89 48 08 0F 87 C0 FE FF FF 33 DB 39 58 08 75 2A 8B 50 04 8B 08 81 45 FC F0 FF 00 00 8B FA 8B F1 C1 EE 10 C1 E2 10 C1 EF 10 0B D6 C1 E1 10 89 50 04 89 08 3B FB 74 DC 89 78 08 8B 78 08 F7 C7 00 80 00 00 75 30 8B 48 04 8B 18 81 45 FC FF FF 00 00 8B F1 8B D3 C1 EE 1F 03 FF C1 EA 1F 03 C9 0B FE 03 DB 0B CA 89 18 89 48 04 89 78 08 F7 C7 00 80 00 00 74 D3 66 8B 4D FC 5F 5E 66 89 48 0A 5B C9 C3 }
	condition:
		$1
}

rule file_69_8_0 {
	meta:
		name = "?SwitchTo@FreeThreadProxy@details@Concurrency@@UAEXPAUIExecutionContext@3@W4SwitchingProxyState@3@@Z"
		size = 155
		refs = "001e ??_C@_08BAFMHLII@pContext?$AA@ 0023 ??0exception@std@@QAE@ABQBD@Z 0028 __TI3?AVinvalid_argument@std@@ 0033 ??_7invalid_argument@std@@6B@ 0038 __CxxThrowException@8 005c ?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QAEXPAVFreeThreadProxy@23@@Z 0083 __imp__SignalObjectAndWait@16 0090 ?ResumeExecution@ThreadProxy@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 8B 5D 08 56 57 8B F1 85 DB 75 28 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 C7 45 F4 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 03 8B CB FF 50 08 8B F8 85 FF 75 0E 8B 46 10 8B 48 18 8B 01 53 FF 50 1C 8B F8 8B 4E 10 57 E8 ?? ?? ?? ?? 8B 45 0C 83 66 10 00 83 E8 00 74 21 48 75 1E 8D 5E 20 40 8B CB 87 01 6A 01 6A FF FF 76 0C FF 77 0C FF 15 ?? ?? ?? ?? 33 C0 87 03 EB 07 8B CF E8 ?? ?? ?? ?? 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_69_11_0 {
	meta:
		name = "?AssociateExecutionContext@FreeThreadProxy@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 41 40 8B 10 51 8B C8 FF 52 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_69_12_0 {
	meta:
		name = "?ReturnIdleProxy@FreeThreadProxy@details@Concurrency@@QAEXXZ"
		size = 16
	strings:
		$1 = { 8B C1 8B 48 04 83 60 40 00 8B 11 50 FF 52 04 C3 }
	condition:
		$1
}

rule file_69_13_0 {
	meta:
		name = "?Dispatch@FreeThreadProxy@details@Concurrency@@EAEXXZ"
		size = 104
		refs = "002d __imp__TlsSetValue@8 0053 ?ReturnIdleProxy@FreeThreadProxy@details@Concurrency@@QAEXXZ 005a ?SuspendExecution@ThreadProxy@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 65 FC 00 56 8B F1 8B 46 24 C7 45 F8 08 00 00 00 85 C0 75 42 8B 4E 04 8B C6 83 C8 01 50 8B 01 FF 50 10 50 FF 15 ?? ?? ?? ?? EB 2B 8B 4E 40 8B 01 56 FF 50 0C 8B 4E 40 8B 01 8D 55 F8 52 FF 50 10 83 66 40 00 83 66 10 00 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B 46 24 85 C0 74 CE 5E C9 C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "_xtow@16"
		size = 86
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 00 74 0B 6A 2D 5A 66 89 11 83 C1 02 F7 D8 56 8B F1 33 D2 F7 75 08 83 FA 09 76 05 83 C2 57 EB 03 83 C2 30 66 89 11 83 C1 02 85 C0 75 E4 66 89 01 83 E9 02 0F B7 01 66 8B 16 66 89 11 66 89 06 83 E9 02 83 C6 02 3B F1 72 EA 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "__itow"
		size = 42
		refs = "0021 _xtow@16"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 0A 8B 45 08 75 0A 85 C0 79 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_470_1_0 {
	meta:
		name = "__itoa"
		size = 42
		refs = "0021 _xtoa@16"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 0A 8B 45 08 75 0A 85 C0 79 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_71_2_0 {
	meta:
		name = "__ltow"
		size = 39
		refs = "001e _xtow@16"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 10 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 10 8B 45 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_470_2_0 {
	meta:
		name = "__ltoa"
		size = 39
		refs = "001e _xtoa@16"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 10 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 10 8B 45 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_71_3_0 {
	meta:
		name = "__ultow"
		size = 26
		refs = "0011 _xtow@16"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 6A 00 FF 75 10 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_470_3_0 {
	meta:
		name = "__ultoa"
		size = 26
		refs = "0011 _xtoa@16"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 6A 00 FF 75 10 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_71_4_0 {
	meta:
		name = "@x64tow@20"
		size = 131
		refs = "0036 __aulldvrm"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 14 00 53 8B 5D 08 56 57 8B F0 74 15 6A 2D 58 66 89 06 8B 45 0C 83 C6 02 F7 DB 83 D0 00 F7 D8 EB 03 8B 45 0C 8B FE 33 C9 51 FF 75 10 50 53 E8 ?? ?? ?? ?? 89 5D 0C 8B D8 8B C2 83 F9 09 76 05 83 C1 57 EB 03 83 C1 30 66 89 0E 83 C6 02 85 C0 77 D5 72 04 85 DB 75 CF 33 C0 66 89 06 83 EE 02 0F B7 06 66 8B 0F 66 89 0E 66 89 07 83 EE 02 83 C7 02 3B FE 72 EA 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule file_71_5_0 {
	meta:
		name = "__i64tow"
		size = 51
		refs = "002a @x64tow@20"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 14 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 50 FF 75 14 8B 45 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_470_5_0 {
	meta:
		name = "__i64toa"
		size = 51
		refs = "002a @x64toa@20"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 14 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 50 FF 75 14 8B 45 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_71_6_0 {
	meta:
		name = "__ui64tow"
		size = 29
		refs = "0014 @x64tow@20"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 6A 00 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_470_6_0 {
	meta:
		name = "__ui64toa"
		size = 29
		refs = "0014 @x64toa@20"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 6A 00 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "_IsRootUNCName"
		size = 157
		refs = "0004 _wcslen"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 59 83 F8 05 0F 82 88 00 00 00 0F B7 06 83 F8 5C 74 05 83 F8 2F 75 7B 0F B7 46 02 83 F8 5C 74 05 83 F8 2F 75 6D 0F B7 46 04 83 F8 5C 74 64 83 F8 2F 74 5F 8D 46 06 0F B7 08 33 D2 66 3B CA 74 52 66 83 F9 5C 74 11 66 83 F9 2F 74 0B 83 C0 02 0F B7 08 66 3B CA 75 E9 66 39 10 74 36 83 C0 02 66 39 10 74 2E 0F B7 08 66 3B CA 74 22 66 83 F9 5C 74 11 66 83 F9 2F 74 0B 83 C0 02 0F B7 08 66 3B CA 75 E9 66 39 10 74 06 66 39 50 02 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_72_1_0 {
	meta:
		name = "__wfullpath_helper"
		size = 96
		refs = "0008 __errno 0020 __wfullpath"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? FF 75 10 83 20 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 E8 ?? ?? ?? ?? 85 FF 74 06 89 30 8B C7 EB 24 83 38 22 74 04 33 C0 EB 1B E8 ?? ?? ?? ?? 6A 00 FF 75 0C 89 30 6A 00 E8 ?? ?? ?? ?? 8B 4D 14 83 C4 0C 89 01 5F 5E 5D C3 }
	condition:
		$1
}

rule file_281_2_0 {
	meta:
		name = "__fullpath_helper"
		size = 96
		refs = "0008 __errno 0020 __fullpath"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? FF 75 10 83 20 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 E8 ?? ?? ?? ?? 85 FF 74 06 89 30 8B C7 EB 24 83 38 22 74 04 33 C0 EB 1B E8 ?? ?? ?? ?? 6A 00 FF 75 0C 89 30 6A 00 E8 ?? ?? ?? ?? 8B 4D 14 83 C4 0C 89 01 5F 5E 5D C3 }
	condition:
		$1
}

rule file_72_2_0 {
	meta:
		name = "__wstat64i32"
		size = 1118
		refs = "000c ___security_cookie 0031 ___doserrno 0038 __errno 0043 __invalid_parameter_noinfo 0051 ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0057 _wcspbrk 008e _towlower 009c __getdrive 00b4 __imp__FindFirstFileExW@24 00c8 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00f3 __wfullpath_helper 0106 _wcslen 0111 _IsRootUNCName 011c __imp__GetDriveTypeW@4 0134 _free 0167 ___loctotime64_t 01d6 __wsopen_s 01fa __fstat64i32 0207 __close 023d __imp__FileTimeToLocalFileTime@8 0259 __imp__FileTimeToSystemTime@8 03d9 __imp__FindClose@4 03e5 ___wdtoxmode 0435 __imp__GetLastError@0 043b __dosmaperr 0458 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 80 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 8C FB FF FF 89 9D 80 FB FF FF 3B F3 75 1C E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 00 04 00 00 3B FB 74 E0 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 D5 03 00 00 66 83 7E 02 3A 75 1D 0F B7 06 66 3B C3 74 06 66 39 5E 04 74 D5 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 53 53 53 89 85 84 FB FF FF 8D 85 94 FB FF FF 50 53 56 FF 15 ?? ?? ?? ?? 89 85 90 FB FF FF 83 F8 FF 0F 85 E3 00 00 00 68 ?? ?? ?? ?? 56 89 9D 90 FB FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 83 8D 85 90 FB FF FF 50 68 04 01 00 00 8D 85 F4 FD FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 0F 84 89 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 74 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 68 39 9D 90 FB FF FF 74 0C FF B5 90 FB FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 33 C0 6A 01 68 BC 07 00 00 C7 85 94 FB FF FF 10 00 00 00 89 9D B0 FB FF FF 89 9D B4 FB FF FF 66 89 85 C0 FB FF FF E8 ?? ?? ?? ?? 8B B5 8C FB FF FF 8B CA 83 C4 1C 89 47 20 89 57 24 89 47 18 89 4F 1C 89 47 28 89 4F 2C E9 50 02 00 00 39 9D 90 FB FF FF 0F 84 C8 FE FF FF FF B5 90 FB FF FF E8 ?? ?? ?? ?? 59 E9 B7 FE FF FF F7 85 94 FB FF FF 00 04 00 00 74 5F 81 BD B8 FB FF FF 0C 00 00 A0 75 53 83 8D 90 FB FF FF FF 53 6A 40 53 8D 85 90 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 7C FE FF FF 83 BD 90 FB FF FF FF 0F 84 6F FE FF FF 57 FF B5 90 FB FF FF E8 ?? ?? ?? ?? FF B5 90 FB FF FF 8B F0 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 E9 3A 02 00 00 39 9D A8 FB FF FF 75 10 39 9D AC FB FF FF 75 08 89 5F 20 89 5F 24 EB 78 8D 85 88 FB FF FF 50 8D 85 A8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 EA 01 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CE 01 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 39 9D A0 FB FF FF 75 16 39 9D A4 FB FF FF 75 0E 8B 47 20 89 47 18 8B 47 24 89 47 1C EB 78 8D 85 88 FB FF FF 50 8D 85 A0 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 54 01 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 38 01 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 18 89 57 1C 39 9D 98 FB FF FF 75 16 39 9D 9C FB FF FF 75 0E 8B 47 20 89 47 28 8B 47 24 89 47 2C EB 78 8D 85 88 FB FF FF 50 8D 85 98 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BE 00 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A2 00 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C FF B5 90 FB FF FF FF 15 ?? ?? ?? ?? 56 FF B5 94 FB FF FF E8 ?? ?? ?? ?? 66 89 47 06 33 C0 40 66 89 47 08 8B 85 B4 FB FF FF 59 59 89 47 14 39 9D B0 FB FF FF 74 0A 83 8D 80 FB FF FF FF 89 5F 14 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 84 FB FF FF 48 89 07 89 47 10 8B 85 80 FB FF FF EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 90 FB FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "_wcsstr"
		size = 96
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 53 8B 5D 0C 66 83 3B 00 57 8B F8 74 43 0F B7 08 66 85 C9 74 39 8B D1 2B C3 8B 4D 0C 66 85 D2 74 19 0F B7 11 66 85 D2 74 2B 0F B7 1C 08 2B DA 75 09 83 C1 02 66 39 1C 08 75 E7 66 83 39 00 74 14 83 C7 02 0F B7 17 83 C0 02 66 85 D2 75 CB 33 C0 5F 5B 5D C3 8B C7 EB F8 }
	condition:
		$1
}

rule file_78_1_0 {
	meta:
		name = "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
		size = 55
		refs = "0009 __lock 0010 ?_pnhHeap@@3P6AHI@ZA 0016 __imp__DecodePointer@4 0021 __imp__EncodePointer@4 002d __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 56 6A 04 E8 ?? ?? ?? ?? 59 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 75 08 8B F0 FF 15 ?? ?? ?? ?? 6A 04 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_78_4_0 {
	meta:
		name = "__callnewh"
		size = 40
		refs = "0007 ?_pnhHeap@@3P6AHI@ZA 000d __imp__DecodePointer@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 0F FF 75 08 FF D0 59 85 C0 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "__execlpe"
		size = 79
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0046 __execvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 80 39 00 74 E6 8B 45 0C 85 C0 74 DF 80 38 00 74 DA 8D 45 0C 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 0C 50 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "__sleep"
		size = 29
		refs = "0017 __imp__Sleep@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 07 C7 45 08 01 00 00 00 FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_1_0 {
	meta:
		name = "__beep"
		size = 19
		refs = "000d __imp__Beep@8"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_81_7_0 {
	meta:
		name = "??0_MallocaHolder@details@Concurrency@@QAE@PAX@Z"
		size = 16
		altNames = "??0<lambda1>@?A0x8894c2c9@Concurrency@@QAE@QAV?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@2@@Z ??0<lambda2>@?A0x8894c2c9@Concurrency@@QAE@QAV?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@2@@Z ??0<lambda3>@?A0x8894c2c9@Concurrency@@QAE@QAV?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@2@@Z ??0<lambda4>@?A0x8894c2c9@Concurrency@@QAE@QAV?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@2@@Z ??0_Timevec@std@@QAE@PAX@Z ??0id@locale@std@@QAE@I@Z ??0locale@std@@AAE@PAV_Locimp@01@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 8B 4D 08 89 08 5D C2 04 00 }
	condition:
		$1
}

rule file_81_9_0 {
	meta:
		name = "??0_TaskCollectionBase@details@Concurrency@@QAE@XZ"
		size = 25
	strings:
		$1 = { 8B C1 81 48 04 FF FF FF 0F 83 60 0C 00 83 60 14 00 C7 40 10 00 00 00 80 C3 }
	condition:
		$1
}

rule file_81_17_0 {
	meta:
		name = "?GetWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ"
		size = 21
		refs = "000c ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 7E 20 00 75 05 E8 ?? ?? ?? ?? 8B 46 20 5E C3 }
	condition:
		$1
}

rule file_863_154_0 {
	meta:
		name = "?GetStructuredWorkQueue@ContextBase@details@Concurrency@@QAEPAVWorkQueue@23@XZ"
		size = 21
		refs = "000c ?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 7E 20 00 75 05 E8 ?? ?? ?? ?? 8B 46 20 5E C3 }
	condition:
		$1
}

rule file_81_18_0 {
	meta:
		name = "?GetWorkQueueIdentity@ContextBase@details@Concurrency@@QAEIXZ"
		size = 24
		refs = "000c ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 7E 20 00 75 05 E8 ?? ?? ?? ?? 8B 46 20 8B 40 3C 5E C3 }
	condition:
		$1
}

rule file_81_25_0 {
	meta:
		name = "?HasAnyCancellation@ContextBase@details@Concurrency@@QBE_NXZ"
		size = 16
	strings:
		$1 = { 8B 41 68 8B 49 60 03 C1 33 C9 85 C0 0F 9F C0 C3 }
	condition:
		$1
}

rule file_81_26_0 {
	meta:
		name = "?CancelEntireContext@ContextBase@details@Concurrency@@QAEXXZ"
		size = 16
		refs = "000b ?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z"
	strings:
		$1 = { 33 C0 40 8D 51 64 87 02 6A 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_81_30_0 {
	meta:
		name = "?IsOneShotInitialized@SchedulerBase@details@Concurrency@@SA_NXZ"
		size = 17
		refs = "0001 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA"
	strings:
		$1 = { A1 ?? ?? ?? ?? 25 00 00 00 80 F7 D8 1B C0 F7 D8 C3 }
	condition:
		$1
}

rule file_81_31_0 {
	meta:
		name = "?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
		size = 34
		refs = "0002 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 000d ?CreateContextFromDefaultScheduler@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0013 ?t_dwContextIndex@SchedulerBase@details@Concurrency@@1KA 0019 __imp__TlsGetValue@4"
	strings:
		$1 = { F7 05 ?? ?? ?? ?? 00 00 00 80 75 05 E9 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 EB C3 }
	condition:
		$1
}

rule file_81_33_0 {
	meta:
		name = "?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000c ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B 41 20 83 78 08 01 75 08 6A 01 E8 ?? ?? ?? ?? C3 8B 81 84 00 00 00 FF 40 60 C3 }
	condition:
		$1
}

rule file_81_34_0 {
	meta:
		name = "?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXI@Z"
		size = 36
		refs = "0010 ?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 41 20 83 78 08 01 75 06 5D E9 ?? ?? ?? ?? 8B 81 84 00 00 00 8B 4D 08 01 48 60 5D C2 04 00 }
	condition:
		$1
}

rule file_81_38_0 {
	meta:
		name = "?IncrementDequeuedTaskCounter@ExternalContextBase@details@Concurrency@@QAEXI@Z"
		size = 21
	strings:
		$1 = { 8B FF 55 8B EC 8B 81 80 00 00 00 8B 4D 08 01 48 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_81_39_0 {
	meta:
		name = "??0TaskStack@details@Concurrency@@QAE@XZ"
		size = 16
	strings:
		$1 = { 8B C1 33 C9 89 08 89 48 04 89 48 08 88 48 0C C3 }
	condition:
		$1
}

rule file_81_43_0 {
	meta:
		name = "??0SweeperContext@details@Concurrency@@QAE@PAV_TaskCollection@12@@Z"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 8B 4D 08 83 60 04 00 89 08 5D C2 04 00 }
	condition:
		$1
}

rule file_81_45_0 {
	meta:
		name = "?Push@TaskStack@details@Concurrency@@QAE_NH@Z"
		size = 117
		refs = "0038 ??_U@YAPAXI@Z 0049 _memcpy 0053 ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4E 04 8B 06 3B C8 7C 4E 81 F9 00 04 00 00 7C 08 C6 46 0C 01 32 C0 EB 4F 53 57 8D 78 08 33 C9 6A 04 5A 8B C7 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B D8 8B 06 C1 E0 02 50 FF 76 08 53 E8 ?? ?? ?? ?? FF 76 08 89 3E E8 ?? ?? ?? ?? 83 C4 14 5F 89 5E 08 5B 8B 46 04 8B 4E 08 8B 55 08 89 14 81 FF 46 04 B0 01 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_49_0 {
	meta:
		name = "?_Schedule@_StructuredTaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 85
		refs = "0019 ??0invalid_multiple_scheduling@Concurrency@@QAE@XZ 001e __TI2?AVinvalid_multiple_scheduling@Concurrency@@ 0027 __CxxThrowException@8 0031 ?_StructuredChoreWrapper@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z 003f ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 004b ?PushStructured@ContextBase@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 57 8B 7D 08 83 7F 08 00 8B F1 74 16 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 89 77 08 C7 47 0C ?? ?? ?? ?? FF 46 0C 83 7E 08 00 75 08 E8 ?? ?? ?? ?? 89 46 08 8B 4E 08 57 E8 ?? ?? ?? ?? 5F 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_81_54_0 {
	meta:
		name = "?_IsCanceling@_StructuredTaskCollection@details@Concurrency@@QAE_NXZ"
		size = 87
		refs = "000c ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0046 ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 7E 08 00 75 08 E8 ?? ?? ?? ?? 89 46 08 8B 46 08 8B 48 64 85 C9 74 04 33 C9 EB 03 8B 48 5C 83 7E 14 00 75 28 83 F9 FF 74 0D 8B 56 04 C1 E2 04 C1 FA 04 3B CA 7E 16 8B 40 68 85 C0 7E 0B 8B CE E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 5E C3 33 C0 40 5E C3 }
	condition:
		$1
}

rule file_81_57_0 {
	meta:
		name = "?_IsIndirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ"
		size = 18
	strings:
		$1 = { 39 49 54 74 0A 8B 49 68 33 C0 40 84 C8 75 02 33 C0 C3 }
	condition:
		$1
}

rule file_81_59_0 {
	meta:
		name = "?_IsDirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ"
		size = 18
	strings:
		$1 = { 39 49 54 74 0A 8B 49 68 33 C0 40 84 C8 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_81_61_0 {
	meta:
		name = "?_NotifyNewChore@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 38
		refs = "0019 ?wait@event@Concurrency@@QAEII@Z 0021 ?reset@event@Concurrency@@QAEXXZ"
	strings:
		$1 = { 33 C0 8D 51 0C 40 F0 0F C1 02 40 83 F8 01 75 15 56 8D 71 38 6A FF 8B CE E8 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_81_62_0 {
	meta:
		name = "?_NotifyCompletedChore@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 29
		refs = "0017 ?set@event@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 41 0C 83 CA FF F0 0F C1 10 4A 75 08 83 C1 38 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_81_63_0 {
	meta:
		name = "?_FullAliasWait@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z"
		size = 232
		refs = "0003 __ehhandler$?_FullAliasWait@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z 0008 __EH_prolog3_GS 003a __alloca_probe_16 0051 _malloc 0075 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 007a ??0exception@std@@QAE@ABQBDH@Z 007f __TI2?AVbad_alloc@std@@ 008a ??_7bad_alloc@std@@6B@ 008f __CxxThrowException@8 00c4 ?wait_for_multiple@event@Concurrency@@SAIPAPAV12@I_NI@Z 00ca __freea 00d9 ?wait@event@Concurrency@@QAEII@Z 00e1 __EH_epilog3_GS"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 8B 45 08 33 FF 85 C0 0F 84 B8 00 00 00 8B 40 58 47 85 C0 75 F8 85 FF 0F 8E A8 00 00 00 8D 04 BD 0C 00 00 00 3D 00 04 00 00 77 16 E8 ?? ?? ?? ?? 8B F4 85 F6 74 25 C7 06 CC CC 00 00 83 C6 08 EB 16 50 E8 ?? ?? ?? ?? 59 85 C0 74 09 C7 00 DD DD 00 00 83 C0 08 8B F0 85 F6 75 2A 6A 01 8D 45 EC 50 8D 4D E0 C7 45 EC ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 C7 45 E0 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 75 EC 8B 43 54 83 65 FC 00 33 D2 83 C0 38 42 8D 4F 01 89 06 8B 45 08 3B CA 7E 0E 8D 78 38 89 3C 96 8B 40 58 42 3B D1 7C F2 6A FF 6A 01 51 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 14 EB 0A 6A FF 8D 4B 38 E8 ?? ?? ?? ?? 8D 65 D0 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_81_65_0 {
	meta:
		name = "__ehhandler$?_FullAliasWait@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_FullAliasWait@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_67_0 {
	meta:
		name = "?_CollectionMatchPredicate@_TaskCollection@details@Concurrency@@CA_NPAV_UnrealizedChore@23@PAX@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 40 08 8B 4D 0C 2B 01 F7 D8 1B C0 40 5D C3 }
	condition:
		$1
}

rule file_81_68_0 {
	meta:
		name = "?_SweepAbortedChore@_TaskCollection@details@Concurrency@@CA_NPAV_UnrealizedChore@23@PAX@Z"
		size = 37
		refs = "0014 ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z 001c ?_NotifyCompletedChore@_TaskCollection@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B 45 0C 56 8B 71 08 FF 40 04 51 E8 ?? ?? ?? ?? 59 8B CE E8 ?? ?? ?? ?? B0 01 5E 5D C3 }
	condition:
		$1
}

rule file_81_69_0 {
	meta:
		name = "?_RaisedException@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 29
		refs = "0009 ?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 8B 4E 54 E8 ?? ?? ?? ?? 8B 46 54 B9 00 00 00 80 83 C0 30 F0 09 08 5E C3 }
	condition:
		$1
}

rule file_81_71_0 {
	meta:
		name = "?_SetCancelState@_TaskCollection@details@Concurrency@@AAE_NJ_N@Z"
		size = 66
	strings:
		$1 = { 8B FF 55 8B EC 8B 51 30 53 56 57 32 DB 80 7D 0C 00 74 08 F7 C2 FF FF FF 7F 75 1E 8B F2 81 E6 00 00 00 80 0B 75 08 8D 79 30 8B C2 F0 0F B1 37 3B C2 74 04 8B D0 EB D6 B3 01 5F 5E 8A C3 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_81_72_0 {
	meta:
		name = "??0?$_SpinWait@$00@details@Concurrency@@QAE@P6AXXZ@Z"
		size = 21
		altNames = "??0?$_SpinWait@$0A@@details@Concurrency@@QAE@P6AXXZ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 8B 4D 08 83 60 08 00 89 48 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_81_74_0 {
	meta:
		name = "?Next@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QBEPAUListEntry@23@PAU423@@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 3B 01 74 05 8B 40 04 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_81_82_0 {
	meta:
		name = "?Lookup@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
		size = 40
		altNames = "?Lookup@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@AAEPAUListNode@123@ABQAXH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 41 08 8B 4D 0C 8B 04 88 85 C0 74 10 8B 4D 08 8B 09 39 48 04 74 08 8B 00 85 C0 75 F5 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_81_84_0 {
	meta:
		name = "??0ListNode@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@ABQAV_TaskCollection@23@0@Z"
		size = 30
		altNames = "??0ListNode@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@ABQAXABQAVExternalContextBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 83 20 00 8B 4D 08 8B 09 89 48 04 8B 4D 0C 8B 09 89 48 08 5D C2 08 00 }
	condition:
		$1
}

rule file_81_85_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 75 09 C7 41 08 04 00 00 00 EB 0B 89 01 33 C0 40 89 41 04 89 41 08 5D C2 04 00 }
	condition:
		$1
}

rule file_81_86_0 {
	meta:
		name = "?Remove@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
		size = 69
		altNames = "?Remove@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@AAEPAUListNode@123@ABQAXH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 41 08 8B 55 0C 8D 14 90 8B 02 56 33 F6 57 85 C0 74 12 8B 7D 08 8B 3F 39 78 04 74 10 8B F0 8B 00 85 C0 75 F3 33 C0 5F 5E 5D C2 08 00 85 F6 75 06 8B 30 89 32 EB 04 8B 10 89 16 FF 49 04 EB E7 }
	condition:
		$1
}

rule file_81_87_0 {
	meta:
		name = "?Randomize@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAII@Z"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 B9 19 95 F1 7F F7 E1 03 C2 5D C3 }
	condition:
		$1
}

rule file_81_91_0 {
	meta:
		name = "?_Cancel@_StructuredTaskCollection@details@Concurrency@@QAEXXZ"
		size = 86
		refs = "000c ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0016 ?_MarkCancellation@_TaskCollectionBase@details@Concurrency@@IAE_NXZ 003a ?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z 0047 ?_FinishCancelState@_TaskCollectionBase@details@Concurrency@@IAEXI@Z 0050 ?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
	strings:
		$1 = { 8B FF 56 8B F1 83 7E 08 00 75 08 E8 ?? ?? ?? ?? 89 46 08 8B CE E8 ?? ?? ?? ?? 84 C0 74 36 8B 4E 08 33 D2 8D 41 68 42 F0 0F C1 10 8B 46 04 C1 E0 04 C1 F8 04 85 C0 78 0A 50 E8 ?? ?? ?? ?? 6A 03 EB 02 6A 02 8B CE E8 ?? ?? ?? ?? 8B 4E 08 56 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_81_93_0 {
	meta:
		name = "?_ReleaseAlias@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 57
		refs = "002a ??1_TaskCollection@details@Concurrency@@QAE@XZ 0030 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 53 56 8B F1 8B 4E 68 57 F6 C1 02 75 18 8B F9 83 CF 02 8D 5E 68 8B C1 F0 0F B1 3B 3B C1 74 14 8B C8 A8 02 74 E8 8B CE E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 5F 5E 5B C3 }
	condition:
		$1
}

rule file_81_95_0 {
	meta:
		name = "?_AbortiveSweep@_TaskCollection@details@Concurrency@@AAEXPAX@Z"
		size = 82
		refs = "000c ?_SweepAbortedChore@_TaskCollection@details@Concurrency@@CA_NPAV_UnrealizedChore@23@PAX@Z 001b ?_CollectionMatchPredicate@_TaskCollection@details@Concurrency@@CA_NPAV_UnrealizedChore@23@PAX@Z 0020 ?SweepUnstructured@ContextBase@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z 002b ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 004a ?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 65 FC 00 68 ?? ?? ?? ?? 8D 45 F8 50 89 4D F8 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D FC 00 76 24 E8 ?? ?? ?? ?? 80 78 40 00 74 0E 8B 80 80 00 00 00 8B 4D FC 01 48 0C EB 0B FF 75 FC 8D 48 FC E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_81_96_0 {
	meta:
		name = "??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ"
		size = 20
		refs = "000c ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"
		altNames = "??0?$SafeRWList@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@XZ ??0?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 26 00 8D 4E 04 E8 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_81_97_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 28
		refs = "0011 ?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B F1 8D 48 04 89 06 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_20_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 28
		refs = "0011 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B F1 8D 48 04 89 06 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_47_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QAE@AAV123@@Z"
		size = 28
		refs = "0011 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B F1 8D 48 04 89 06 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_99_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"
		size = 24
		refs = "000a ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0012 ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 56 8B F1 83 66 08 00 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_581_69_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"
		size = 24
		refs = "000a ?_Value@_SpinCount@details@Concurrency@@SAIXZ 0012 ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 56 8B F1 83 66 08 00 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_81_100_0 {
	meta:
		name = "?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z"
		size = 48
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B 09 6A 04 5A 33 C0 56 6B C0 21 0F B6 F1 03 C6 41 4A 75 F4 B9 19 95 F1 7F F7 E1 8D 04 10 33 D2 F7 75 0C 5E 8B C2 5D C3 }
	condition:
		$1
}

rule file_81_102_0 {
	meta:
		name = "?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 55
		refs = "0003 __ehhandler$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ 0008 __EH_prolog3 002d ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ 0032 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D F0 33 D2 89 51 2C 8D 41 18 89 51 30 89 51 6C 89 45 EC 89 55 FC 3B C2 74 0A 8D 48 04 89 10 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_81_103_0 {
	meta:
		name = "__unwindfunclet$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ$0"
		size = 18
		refs = "000b ??3@YAXPAX0@Z"
	strings:
		$1 = { 8B 45 F0 83 C0 18 50 FF 75 EC E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_81_104_0 {
	meta:
		name = "__ehhandler$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_219_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_229_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_229_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_220_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_230_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_253_1 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_383_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_347_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_248_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_82_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_350_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_1109_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_869_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_878_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_875_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_872_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_1020_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_812_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_833_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_898_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_830_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_116_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1040_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduleGroup@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1037_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@AAVScheduler@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1034_2 {
	meta:
		name = "__ehhandler$??0agent@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0agent@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_2_5 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_101_0 {
	meta:
		name = "__ehhandler$?AddVirtualProcessor@SchedulerBase@details@Concurrency@@QAEXPAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddVirtualProcessor@SchedulerBase@details@Concurrency@@QAEXPAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_863_123_0 {
	meta:
		name = "__ehhandler$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_168_0 {
	meta:
		name = "__ehhandler$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSingleton@ResourceManager@details@Concurrency@@SAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_106_0 {
	meta:
		name = "__ehhandler$?CreateUMSBackgroundThreads@ResourceManager@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateUMSBackgroundThreads@ResourceManager@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_291_0 {
	meta:
		name = "__ehhandler$?GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_59_0 {
	meta:
		name = "__ehhandler$?ManageOversubscribers@ThreadScheduler@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ManageOversubscribers@ThreadScheduler@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_175_0 {
	meta:
		name = "__ehhandler$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveExecutionResource@ResourceManager@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_145_0 {
	meta:
		name = "__ehhandler$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_107_0 {
	meta:
		name = "__ehhandler$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_179_1 {
	meta:
		name = "__ehhandler$?_Init@?$_Mpunct@D@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$_Mpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_403_1 {
	meta:
		name = "__ehhandler$?_Init@?$_Mpunct@G@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$_Mpunct@G@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_376_2 {
	meta:
		name = "__ehhandler$?_Init@?$_Mpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$_Mpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_215_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_523_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_512_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_342_2 {
	meta:
		name = "__ehhandler$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_141_0 {
	meta:
		name = "__ehhandler$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_135_0 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCopyException@@YAXPAXPBX1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCopyException@@YAXPAXPBX1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_132_0 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCurrentException@@YAXPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCurrentException@@YAXPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_61_2 {
	meta:
		name = "__ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?global@locale@std@@SA?AV12@ABV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_105_0 {
	meta:
		name = "?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z"
		size = 136
		refs = "0003 __ehhandler$?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z 0008 __EH_prolog3 001b ?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ 003a ?CancelStealers@ContextBase@details@Concurrency@@QAEXPAV_TaskCollectionBase@23@@Z 0057 ?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z 007c ?_ReleaseRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0081 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8D 77 18 8D 4E 04 89 75 EC 89 4D F0 E8 ?? ?? ?? ?? 83 65 FC 00 80 7D 0C 00 75 0C 83 7F 2C 00 7E 0F 8B 06 85 C0 75 0F 8B 4F 08 57 E8 ?? ?? ?? ?? 8B 06 85 C0 74 2A 8B 78 04 EB 27 33 C0 40 8D 4F 14 87 01 6A 00 8D 4F B0 E8 ?? ?? ?? ?? 6A 00 8D 4F B0 E8 ?? ?? ?? ?? 3B 3E 74 05 8B 7F 04 EB 02 33 FF 85 FF 75 D5 8B 4D F0 83 4D FC FF E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_81_108_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
		size = 112
		refs = "0013 ?_Value@_SpinCount@details@Concurrency@@SAIXZ 001b ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 DB 8B 46 08 2B C3 75 12 89 5E 08 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? EB E7 48 74 34 48 74 1C 48 74 05 48 74 24 EB 10 89 5E 08 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 32 C0 EB 2A FF 4E 04 75 07 C7 46 08 03 00 00 00 B3 01 FF 56 0C 8A C3 EB 15 F3 90 FF 0E 75 0D 8B 46 04 F7 D8 1B C0 83 C0 03 89 46 08 B0 01 5E 5B C3 }
	condition:
		$1
}

rule file_81_109_0 {
	meta:
		name = "?Insert@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@0@Z"
		size = 100
		refs = "0011 ?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z 001e ?Lookup@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z 0029 ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 8B 7D 08 8B F1 FF 36 57 E8 ?? ?? ?? ?? 59 59 8B D8 53 57 8B CE E8 ?? ?? ?? ?? 85 C0 75 35 6A 0C E8 ?? ?? ?? ?? 59 85 C0 74 12 83 20 00 8B 0F 89 48 04 8B 4D 0C 8B 09 89 48 08 EB 02 33 C0 8B 56 08 8B CB 8B 14 8A 89 10 8B 56 08 89 04 8A FF 46 04 EB 02 33 C0 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_81_110_0 {
	meta:
		name = "?Find@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@PAPAV523@@Z"
		size = 56
		refs = "000e ?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z 001b ?Lookup@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 FF 36 FF 75 08 E8 ?? ?? ?? ?? 59 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 85 C0 74 0E 8B 4D 0C 85 C9 74 09 8B 50 08 89 11 EB 02 33 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_81_111_0 {
	meta:
		name = "?FindAndDelete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@PAPAV423@@Z"
		size = 65
		refs = "000e ?HashValue@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@CAIABQAV_TaskCollection@23@H@Z 001b ?Remove@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@AAEPAUListNode@123@ABQAV_TaskCollection@23@H@Z 0032 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 FF 36 FF 75 08 E8 ?? ?? ?? ?? 59 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 85 C0 74 17 8B 4D 0C 85 C9 74 05 8B 50 08 89 11 50 E8 ?? ?? ?? ?? 59 B0 01 EB 02 32 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_81_112_0 {
	meta:
		name = "?AddArbitraryAlias@ContextBase@details@Concurrency@@QAEXPAV_TaskCollection@23@0@Z"
		size = 34
		refs = "0009 ?SweepAliasTable@ContextBase@details@Concurrency@@QAEXXZ 0019 ?Insert@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 8D 45 0C 50 8D 45 08 50 8D 4E 70 E8 ?? ?? ?? ?? 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_81_113_0 {
	meta:
		name = "?_Initialize@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"
		size = 91
		refs = "0040 ?_UnderlyingYield@details@Concurrency@@YAXXZ 004c ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 BE 01 00 00 80 8D 41 10 8D 56 FF 57 8B D8 8B FE 8B C2 F0 0F B1 3B 3B C2 75 15 8D 41 18 85 C0 74 06 C7 00 00 00 00 00 33 C0 8B CB 87 01 EB 1D 83 65 F4 00 C7 45 F8 ?? ?? ?? ?? 8B FB EB 08 8D 4D EC E8 ?? ?? ?? ?? 8B 07 3B C6 7E F2 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_81_114_0 {
	meta:
		name = "??0_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 140
		refs = "0003 __ehhandler$??0_TaskCollection@details@Concurrency@@QAE@XZ 0008 __EH_prolog3 002f ??0event@Concurrency@@QAE@XZ 0043 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0052 ?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ 005a ?set@event@Concurrency@@QAEXXZ 0062 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0071 ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0087 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 EC 33 FF BB FF FF FF 0F 09 5E 04 89 7E 0C C7 46 10 00 00 00 80 89 7E 14 89 7E 34 8D 4E 38 E8 ?? ?? ?? ?? 89 7E 58 89 7E 5C 89 7D FC 89 7E 68 89 7E 74 E8 ?? ?? ?? ?? 89 46 08 8B 40 34 8B CE 89 06 E8 ?? ?? ?? ?? 8D 4E 38 E8 ?? ?? ?? ?? 89 76 54 E8 ?? ?? ?? ?? 89 45 F0 39 78 20 75 0A 8B C8 E8 ?? ?? ?? ?? 8B 45 F0 8B 40 20 8B 40 3C 21 5E 04 89 46 70 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_81_117_0 {
	meta:
		name = "??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z"
		size = 195
		refs = "0003 __ehhandler$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z 0008 __EH_prolog3 002e ??0event@Concurrency@@QAE@XZ 0048 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0057 ?_Initialize@_TaskCollection@details@Concurrency@@AAEXXZ 005f ?set@event@Concurrency@@QAEXXZ 0097 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 00a5 ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 00bc __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 81 4E 04 FF FF FF 0F 33 DB 89 5E 0C C7 46 10 00 00 00 80 89 5E 14 89 5E 34 8D 4E 38 E8 ?? ?? ?? ?? 8B 45 08 8B 40 54 89 46 54 89 5E 5C 89 5D FC 89 5E 68 89 5E 74 E8 ?? ?? ?? ?? 89 46 08 8B 40 34 8B CE 89 06 E8 ?? ?? ?? ?? 8D 4E 38 E8 ?? ?? ?? ?? 38 5D 0C 74 27 8B 46 54 8B 48 58 8D 78 58 89 4E 58 8B C1 EB 0B 89 46 58 8B 7E 54 8B C8 83 C7 58 8B D6 F0 0F B1 17 3B C1 75 EB EB 07 83 4E 68 01 89 5E 58 E8 ?? ?? ?? ?? 8B F8 39 5F 20 75 07 8B CF E8 ?? ?? ?? ?? 8B 47 20 8B 40 3C 81 66 04 FF FF FF 0F 89 46 70 8B C6 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_81_119_0 {
	meta:
		name = "__ehhandler$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_90_0 {
	meta:
		name = "__ehhandler$??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@tr1@std@@AAEXPAV__ExceptionPtr@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Resetp@V__ExceptionPtr@@@?$shared_ptr@V__ExceptionPtr@@@tr1@std@@AAEXPAV__ExceptionPtr@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1045_2 {
	meta:
		name = "__ehhandler$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@QAE@PAV?$ISource@W4agent_status@Concurrency@@@1@IPAV?$ITarget@I@1@ABV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_234_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_520_2 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_535_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_770_2 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_832_2 {
	meta:
		name = "__ehhandler$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@PAV?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_151_2 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_159_2 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_177_1 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1018_2 {
	meta:
		name = "__ehhandler$??0?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@tr1@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@QAE@ABV?$function@$$A6AXABI@Z@tr1@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_182_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_502_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_475_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_619_1 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_624_2 {
	meta:
		name = "__ehhandler$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1026_2 {
	meta:
		name = "__ehhandler$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_915_2 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_911_1 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_799_1 {
	meta:
		name = "__ehhandler$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1030_2 {
	meta:
		name = "__ehhandler$??0?$single_assignment@I@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$single_assignment@I@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_791_1 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_786_1 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_631_2 {
	meta:
		name = "__ehhandler$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_781_2 {
	meta:
		name = "__ehhandler$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_285_1 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_664_2 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_634_2 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_863_137_0 {
	meta:
		name = "__ehhandler$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_581_39_0 {
	meta:
		name = "__ehhandler$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0MultiWaitBlockHolder@details@Concurrency@@QAE@_NI00@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_821_91_0 {
	meta:
		name = "__ehhandler$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ScheduleGroupBase@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_487_81_0 {
	meta:
		name = "__ehhandler$??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulerProxy@details@Concurrency@@QAE@PAUIScheduler@2@PAVResourceManager@12@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_590_75_0 {
	meta:
		name = "__ehhandler$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulingRing@details@Concurrency@@QAE@PAVSchedulerBase@12@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_51_0 {
	meta:
		name = "__ehhandler$??0ThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_436_3_0 {
	meta:
		name = "__ehhandler$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_914_16_0 {
	meta:
		name = "__ehhandler$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_694_37_0 {
	meta:
		name = "__ehhandler$??0WorkQueue@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0WorkQueue@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_85_0 {
	meta:
		name = "__ehhandler$??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_88_0 {
	meta:
		name = "__ehhandler$??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QAE@AAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_71_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_76_0 {
	meta:
		name = "__ehhandler$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_322_2 {
	meta:
		name = "__ehhandler$??1?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Async_send_queue@V?$message@I@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_319_2 {
	meta:
		name = "__ehhandler$??1?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Async_send_queue@V?$message@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_1062_2 {
	meta:
		name = "__ehhandler$??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1000_1 {
	meta:
		name = "__ehhandler$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_766_1 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_827_1 {
	meta:
		name = "__ehhandler$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_260_1 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_245_2 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_270_1 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_895_2 {
	meta:
		name = "__ehhandler$??1?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$call@IV?$function@$$A6AXABI@Z@tr1@std@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_547_2 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_520_1 {
	meta:
		name = "__ehhandler$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_961_1 {
	meta:
		name = "__ehhandler$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_882_1 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@I@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_868_1 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_920_2 {
	meta:
		name = "__ehhandler$??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$propagator_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_978_1 {
	meta:
		name = "__ehhandler$??1?$single_assignment@I@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$single_assignment@I@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_706_2 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_674_1 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_585_2 {
	meta:
		name = "__ehhandler$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_580_2 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_576_2 {
	meta:
		name = "__ehhandler$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_738_1 {
	meta:
		name = "__ehhandler$??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$target_block@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_718_48_0 {
	meta:
		name = "__ehhandler$??1ExternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ExternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_105_0 {
	meta:
		name = "__ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1InternalContextBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_110_0 {
	meta:
		name = "__ehhandler$??1ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_305_0 {
	meta:
		name = "__ehhandler$??1SchedulerBase@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerBase@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_487_68_0 {
	meta:
		name = "__ehhandler$??1SchedulerProxy@details@Concurrency@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulerProxy@details@Concurrency@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_590_64_0 {
	meta:
		name = "__ehhandler$??1SchedulingRing@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1SchedulingRing@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_772_15_0 {
	meta:
		name = "__ehhandler$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_877_35_0 {
	meta:
		name = "__ehhandler$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_698_43_0 {
	meta:
		name = "__ehhandler$??1VirtualProcessor@details@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1VirtualProcessor@details@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_653_1 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_receive_impl@I@Concurrency@@YAIPAV?$ISource@I@1@IPBV?$function@$$A6A_NABI@Z@tr1@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_399_1 {
	meta:
		name = "__ehhandler$??1_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Blocking_recipient@?1???$_receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PAV?$ISource@W4agent_status@Concurrency@@@1@IPBV?$function@$$A6A_NABW4agent_status@Concurrency@@@Z@tr1@std@@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_30_2 {
	meta:
		name = "__ehhandler$??1_Fac_tidy_reg_t@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Fac_tidy_reg_t@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_40_1 {
	meta:
		name = "__ehhandler$??1_Locimp@locale@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locimp@locale@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_167_1 {
	meta:
		name = "__ehhandler$??1_Locinfo@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locinfo@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_487_96_0 {
	meta:
		name = "__ehhandler$?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddExecutionResource@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_487_93_0 {
	meta:
		name = "__ehhandler$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AddVirtualProcessorRoots@SchedulerProxy@details@Concurrency@@QAEXPAPAUIVirtualProcessorRoot@3@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_47_0 {
	meta:
		name = "__ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_590_68_0 {
	meta:
		name = "__ehhandler$?AllocateScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?AllocateScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_764_23_0 {
	meta:
		name = "__ehhandler$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_974_21_0 {
	meta:
		name = "__ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_257_0 {
	meta:
		name = "__ehhandler$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_772_53_0 {
	meta:
		name = "__ehhandler$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@FreeThreadProxyFactory@details@Concurrency@@EAEPAVFreeThreadProxy@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_54_0 {
	meta:
		name = "__ehhandler$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_865_38_0 {
	meta:
		name = "__ehhandler$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Create@UMSThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_487_56_0 {
	meta:
		name = "__ehhandler$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateExternalThreadResource@SchedulerProxy@details@Concurrency@@QAEPAVExecutionResource@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_772_100_0 {
	meta:
		name = "__ehhandler$?CreateFactory@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@SAPAUIThreadProxyFactory@23@PAVThreadProxyFactoryManager@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateFactory@?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@VUMSFreeThreadProxyFactory@23@@details@Concurrency@@SAPAUIThreadProxyFactory@23@PAVThreadProxyFactoryManager@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_26_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_865_12_0 {
	meta:
		name = "__ehhandler$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateInternalContext@UMSThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_82_0 {
	meta:
		name = "__ehhandler$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateSchedulerProxy@ResourceManager@details@Concurrency@@AAEPAVSchedulerProxy@23@PAUIScheduler@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_863_149_0 {
	meta:
		name = "__ehhandler$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateStructuredWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_23_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_865_9_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessor@UMSThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_487_61_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_877_21_0 {
	meta:
		name = "__ehhandler$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateVirtualProcessorRoot@UMSSchedulerProxy@details@Concurrency@@UAEPAVVirtualProcessorRoot@23@PAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_863_146_0 {
	meta:
		name = "__ehhandler$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_487_106_0 {
	meta:
		name = "__ehhandler$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QAEXPAVVirtualProcessorRoot@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_577_26_0 {
	meta:
		name = "__ehhandler$?EnsureSingleton@Etw@details@Concurrency@@SAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?EnsureSingleton@Etw@details@Concurrency@@SAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_163_0 {
	meta:
		name = "__ehhandler$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_226_0 {
	meta:
		name = "__ehhandler$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetExternalContext@SchedulerBase@details@Concurrency@@AAEPAVExternalContextBase@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_772_105_0 {
	meta:
		name = "__ehhandler$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_160_0 {
	meta:
		name = "__ehhandler$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_772_108_0 {
	meta:
		name = "__ehhandler$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QAEPAVUMSFreeThreadProxyFactory@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_172_0 {
	meta:
		name = "__ehhandler$?Release@ResourceManager@details@Concurrency@@UAEIXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Release@ResourceManager@details@Concurrency@@UAEIXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_487_100_0 {
	meta:
		name = "__ehhandler$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RemoveCore@SchedulerProxy@details@Concurrency@@QAEXPAUSchedulerNode@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_270_0 {
	meta:
		name = "__ehhandler$?ResetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?ResetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_260_0 {
	meta:
		name = "__ehhandler$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_694_29_0 {
	meta:
		name = "__ehhandler$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Steal@WorkQueue@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_195_0 {
	meta:
		name = "__ehhandler$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SubscribeCurrentThread@ResourceManager@details@Concurrency@@QAEPAVExecutionResource@23@PAVSchedulerProxy@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_157_0 {
	meta:
		name = "__ehhandler$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_24_0 {
	meta:
		name = "__ehhandler$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_994_6_0 {
	meta:
		name = "__ehhandler$?_Current_exception@_Exception_ptr@std@@SA?AV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Current_exception@_Exception_ptr@std@@SA?AV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_27_1 {
	meta:
		name = "__ehhandler$?_Fac_tidy@@YAXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Fac_tidy@@YAXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_44_2 {
	meta:
		name = "__ehhandler$?_Init@locale@std@@CAPAV_Locimp@12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@locale@std@@CAPAV_Locimp@12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_21_2 {
	meta:
		name = "__ehhandler$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_215_2 {
	meta:
		name = "__ehhandler$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_994_20_0 {
	meta:
		name = "__ehhandler$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_110_0 {
	meta:
		name = "__ehhandler$?__ExceptionPtrCopy@@YAXPAXPBX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?__ExceptionPtrCopy@@YAXPAXPBX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_346_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1040_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_1006_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_209_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_244_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_244_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_120_0 {
	meta:
		name = "?_Reset@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z"
		size = 209
		refs = "0011 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0022 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 002e ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 004d ?CollectionCancelComplete@ContextBase@details@Concurrency@@QAE_NH@Z 0079 ?_Reset@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z 00a8 ?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 00b1 ?_IsDirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 83 65 F8 00 53 56 8B F1 BB ?? ?? ?? ?? 57 89 5D FC 8D 7E 34 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B 07 83 F8 09 74 F1 E8 ?? ?? ?? ?? 33 C9 3B 46 08 75 21 87 0F 83 F9 04 75 11 8B 4E 04 C1 E1 04 C1 F9 04 51 8B C8 E8 ?? ?? ?? ?? 81 4E 04 FF FF FF 0F EB 07 6A 03 58 F0 0F B1 0F 39 76 54 75 48 8B 7D 08 EB 15 8B 47 68 D1 E8 A8 01 75 09 6A 00 8B CF E8 ?? ?? ?? ?? 8B 7F 58 85 FF 75 E7 33 C0 8D 4E 30 87 01 85 C0 79 3B 21 7D E8 89 5D EC EB 08 8D 4D E0 E8 ?? ?? ?? ?? 83 7E 14 08 74 F2 8B CE E8 ?? ?? ?? ?? EB 1C 8B CE E8 ?? ?? ?? ?? 84 C0 74 11 83 7D 08 00 74 0B FF 75 08 8B 4E 54 E8 ?? ?? ?? ?? 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_81_121_0 {
	meta:
		name = "?_CancelFromArbitraryThread@_TaskCollection@details@Concurrency@@AAEX_N@Z"
		size = 152
		refs = "0065 ?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z 0072 ?_AbortiveSweep@_TaskCollection@details@Concurrency@@AAEXPAX@Z 007f ?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 8B F1 8D 56 34 57 8B 3A 89 55 F8 33 C0 8B CF 83 E9 00 74 0D 49 74 05 83 E9 04 75 08 6A 09 58 EB 07 6A 03 58 85 C0 74 60 8B C8 8B DA 8B C7 F0 0F B1 0B 3B C7 74 04 8B F8 EB D3 C6 45 FC 00 83 FF 01 74 05 83 FF 05 75 25 8B 46 04 8B 5E 08 C1 E0 04 C1 F8 04 50 8B CB C6 45 FC 01 E8 ?? ?? ?? ?? 83 FF 05 75 08 53 8B CE E8 ?? ?? ?? ?? FF 75 FC 8B CE FF 75 08 E8 ?? ?? ?? ?? 80 7D FC 00 74 08 8B 4D F8 6A 04 58 87 01 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_81_122_0 {
	meta:
		name = "?_CancelDirectAliases@_TaskCollection@details@Concurrency@@AAEX_NPAV123@@Z"
		size = 33
		refs = "0011 ?_CancelFromArbitraryThread@_TaskCollection@details@Concurrency@@AAEX_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 0C EB 0D FF 75 08 8B CE E8 ?? ?? ?? ?? 8B 76 58 85 F6 75 EF 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_81_123_0 {
	meta:
		name = "?_Cancel@_TaskCollection@details@Concurrency@@AAEX_NPAV123@@Z"
		size = 166
		refs = "000a ?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 001a ?_SetCancelState@_TaskCollection@details@Concurrency@@AAE_NJ_N@Z 0025 ?_IsIndirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ 0037 ?_CancelFromArbitraryThread@_TaskCollection@details@Concurrency@@AAEX_N@Z 0063 ?_CancelStolenContexts@_TaskCollection@details@Concurrency@@AAEX_N0@Z 0071 ?_CancelDirectAliases@_TaskCollection@details@Concurrency@@AAEX_NPAV123@@Z 008b ?CancelCollection@ContextBase@details@Concurrency@@QAEXH@Z 0098 ?_AbortiveSweep@_TaskCollection@details@Concurrency@@AAEXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F1 E8 ?? ?? ?? ?? 6A 01 68 01 00 00 40 8B CE 8B F8 E8 ?? ?? ?? ?? 84 C0 74 53 8B CF E8 ?? ?? ?? ?? 84 C0 75 10 3B FE 74 0C FF 75 08 8B CE E8 ?? ?? ?? ?? EB 2B 53 8B 7E 34 83 FF 01 74 35 83 FF 05 74 30 6A 03 59 8D 56 34 33 C0 F0 0F B1 0A 3B C7 75 E3 6A 01 FF 75 08 8B CE E8 ?? ?? ?? ?? 5B FF 75 0C 8B CE FF 75 08 E8 ?? ?? ?? ?? 5F 5E 5D C2 08 00 8B 46 04 8B 5E 08 C1 E0 04 C1 F8 04 50 8B CB E8 ?? ?? ?? ?? 83 FF 05 75 08 53 8B CE E8 ?? ?? ?? ?? 6A 04 59 8D 46 34 87 08 EB 98 }
	condition:
		$1
}

rule file_81_124_0 {
	meta:
		name = "?Delete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@@Z"
		size = 19
		refs = "000b ?FindAndDelete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@PAPAV423@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_369_329_0 {
	meta:
		name = "?StartupNewVirtualProcessor@SchedulerBase@details@Concurrency@@UAEXPAVScheduleGroupBase@23@@Z"
		size = 19
		refs = "000b ?StartupIdleVirtualProcessor@SchedulerBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@PAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_93_85_2 {
	meta:
		name = "?clear@ios_base@std@@QAEXH@Z"
		size = 19
		refs = "000b ?clear@ios_base@std@@QAEXH_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_48_353_1 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
		size = 19
		refs = "000b ?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXID@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_8_847_2 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z"
		size = 19
		refs = "000b ?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXIG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_71_838_1 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z"
		size = 19
		refs = "000b ?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_81_125_0 {
	meta:
		name = "?_WaitOnStolenChores@_StructuredTaskCollection@details@Concurrency@@AAEXJ@Z"
		size = 54
		refs = "0016 ?_Initialize@_StructuredTaskCollection@details@Concurrency@@AAEXXZ 002c ?Wait@StructuredEvent@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F9 8D 77 10 8B 06 3D 01 00 00 80 7F 05 E8 ?? ?? ?? ?? 8B 45 08 F7 D8 F0 0F C1 06 2B 45 08 79 08 8D 4F 18 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_81_126_0 {
	meta:
		name = "?_CountUp@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"
		size = 49
		refs = "0017 ?_Initialize@_StructuredTaskCollection@details@Concurrency@@AAEXXZ 0029 ?Set@StructuredEvent@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 57 8B F9 8D 77 10 8B 06 3D 01 00 00 80 7F 05 E8 ?? ?? ?? ?? 33 C0 40 F0 0F C1 06 40 75 08 8D 4F 18 E8 ?? ?? ?? ?? 5F 5E C9 C3 }
	condition:
		$1
}

rule file_81_127_0 {
	meta:
		name = "?_Abort@_TaskCollection@details@Concurrency@@AAEX_N@Z"
		size = 292
		refs = "000d ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 001a ?_IsIndirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ 0042 ?_AbortiveSweep@_TaskCollection@details@Concurrency@@AAEXPAX@Z 0073 ?TryPopUnstructured@ContextBase@details@Concurrency@@QAEPAV_UnrealizedChore@23@H@Z 0095 ?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 009f ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z 00a7 ?_NotifyCompletedChore@_TaskCollection@details@Concurrency@@AAEXXZ 00c1 ?_IsDirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ 00d6 ?_Cancel@_TaskCollection@details@Concurrency@@AAEX_NPAV123@@Z 00e0 ?_FullAliasWait@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z 0119 ?_Reset@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 57 8B F1 E8 ?? ?? ?? ?? 8B 7E 5C 8B CE 89 45 F8 E8 ?? ?? ?? ?? 33 DB 84 C0 74 05 89 5D FC EB 09 8B 46 54 8B 40 58 89 45 FC 3B FB 74 16 80 7F 0C 00 74 10 FF 75 F8 8B CE E8 ?? ?? ?? ?? C6 47 0C 00 EB 67 39 5E 74 7E 62 8B 46 74 83 F8 02 76 0E FF 4F 04 8B 47 04 8B 4F 08 8B 04 81 EB 04 8B 44 86 5C 8B 4D F8 FF 4E 74 50 E8 ?? ?? ?? ?? 8B D8 85 DB 74 34 8B 45 F8 80 78 40 00 74 0B 8B 80 80 00 00 00 FF 40 0C EB 08 8D 48 FC E8 ?? ?? ?? ?? 83 63 08 00 53 E8 ?? ?? ?? ?? 59 8B CE E8 ?? ?? ?? ?? 83 7E 74 00 7F A0 33 DB 80 7D 08 00 75 15 39 5E 0C 7F 10 8B CE E8 ?? ?? ?? ?? 84 C0 75 05 39 5D FC 74 0C FF 75 FC 8B 4E 54 53 E8 ?? ?? ?? ?? FF 75 FC 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 06 8B 46 54 8B 40 58 39 45 FC 74 05 89 45 FC EB B0 89 5E 74 3B FB 74 03 89 5F 04 80 7D 08 00 75 0A FF 75 FC 8B CE E8 ?? ?? ?? ?? 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_81_129_0 {
	meta:
		name = "?_Abort@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"
		size = 177
		refs = "0017 ?PopStructured@ContextBase@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ 0036 ?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 004a ?_Cancel@_StructuredTaskCollection@details@Concurrency@@QAEXXZ 0054 ?_WaitOnStolenChores@_StructuredTaskCollection@details@Concurrency@@AAEXJ@Z 0061 ?_UnderlyingYield@details@Concurrency@@YAXXZ 006b ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 00a1 ?CollectionCancelComplete@ContextBase@details@Concurrency@@QAE_NH@Z 00a8 ?_RethrowException@_TaskCollectionBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B F1 57 8B 7E 08 33 DB EB 29 8B CF E8 ?? ?? ?? ?? 3B C3 74 23 89 58 08 38 5F 40 74 0B 8B 87 80 00 00 00 FF 40 0C EB 08 8D 4F FC E8 ?? ?? ?? ?? FF 4E 0C 39 5E 0C 7F D2 39 5E 0C 7E 14 8B CE E8 ?? ?? ?? ?? FF 76 0C 8B CE E8 ?? ?? ?? ?? 89 5E 0C 89 5D F8 C7 45 FC ?? ?? ?? ?? EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B 46 14 83 E0 FC 83 F8 08 74 ED F6 46 14 03 74 0A 8D 47 68 83 C9 FF F0 0F C1 08 8B 46 14 83 E0 03 3C 03 75 11 8B 46 04 C1 E0 04 C1 F8 04 50 8B CF E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_81_130_0 {
	meta:
		name = "?_TaskCleanup@_TaskCollection@details@Concurrency@@AAE_N_N@Z"
		size = 88
		refs = "000c ?_IsDirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ 0015 ?__uncaught_exception@@YA_NXZ 0047 ?_Abort@_TaskCollection@details@Concurrency@@AAEX_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B F1 32 DB E8 ?? ?? ?? ?? 84 C0 75 37 E8 ?? ?? ?? ?? 84 C0 75 24 83 7E 0C 00 0F 9F C3 39 76 54 75 14 8B 46 58 EB 0B 83 78 0C 00 7E 02 B3 01 8B 40 58 85 C0 75 F1 84 DB 74 0A FF 75 08 8B CE E8 ?? ?? ?? ?? 33 C0 84 DB 5E 0F 94 C0 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_81_131_0 {
	meta:
		name = "??1_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 140
		refs = "0003 __ehhandler$??1_TaskCollection@details@Concurrency@@QAE@XZ 0008 __EH_prolog3 0018 ?_IsDirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ 0025 ?_TaskCleanup@_TaskCollection@details@Concurrency@@AAE_N_N@Z 0041 ?_ReleaseAlias@_TaskCollection@details@Concurrency@@AAEXXZ 0055 ??1TaskStack@details@Concurrency@@QAE@XZ 005b ??3@YAXPAX@Z 0068 ??0missing_wait@Concurrency@@QAE@XZ 006d __TI2?AVmissing_wait@Concurrency@@ 0076 __CxxThrowException@8 0082 ??1event@Concurrency@@QAE@XZ 0087 __EH_epilog3"
	strings:
		$1 = { 6A 10 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 83 65 FC 00 32 DB E8 ?? ?? ?? ?? 84 C0 75 2B 6A 00 8B CE E8 ?? ?? ?? ?? 8A D8 F6 DB 1A DB FE C3 39 76 54 75 15 8B 4E 58 85 C9 74 0E 8B 79 58 E8 ?? ?? ?? ?? 8B CF 85 FF 75 F2 8B 7E 5C 85 FF 74 0E 8B CF E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 84 DB 74 16 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E4 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4E 38 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_81_133_0 {
	meta:
		name = "__ehhandler$??1_TaskCollection@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_TaskCollection@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_143_2 {
	meta:
		name = "__ehhandler$??0_Locinfo@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locinfo@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_564_2 {
	meta:
		name = "__ehhandler$??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_537_2 {
	meta:
		name = "__ehhandler$??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_541_2 {
	meta:
		name = "__ehhandler$??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_514_2 {
	meta:
		name = "__ehhandler$??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_321_0 {
	meta:
		name = "__ehhandler$?RegisterForExitTracking@SchedulerBase@details@Concurrency@@QAEXPAVExternalContextBase@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RegisterForExitTracking@SchedulerBase@details@Concurrency@@QAEXPAVExternalContextBase@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_192_0 {
	meta:
		name = "__ehhandler$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QAEPAUIExecutionResource@3@PAVSchedulerProxy@23@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_991_25_0 {
	meta:
		name = "__ehhandler$?StartPolling@UMSBackgroundPoller@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?StartPolling@UMSBackgroundPoller@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_694_22_0 {
	meta:
		name = "__ehhandler$?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXP6A_NPAV_UnrealizedChore@23@PAX@Z12@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_277_2 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_710_1 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_706_1 {
	meta:
		name = "__ehhandler$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getfmt@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_472_2 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_452_2 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@AAEXPAV?$message@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_490_2 {
	meta:
		name = "__ehhandler$?_Handle_message@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Handle_message@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@AAEXPAV?$message@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_128_2 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_138_0 {
	meta:
		name = "__ehhandler$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@tr1@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@tr1@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_64_2 {
	meta:
		name = "__ehhandler$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_557_1 {
	meta:
		name = "__ehhandler$?_Process_message_helper@?$ordered_message_processor@I@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Process_message_helper@?$ordered_message_processor@I@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_530_1 {
	meta:
		name = "__ehhandler$?_Process_message_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Process_message_helper@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_148_0 {
	meta:
		name = "__ehhandler$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_763_1 {
	meta:
		name = "__ehhandler$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_824_1 {
	meta:
		name = "__ehhandler$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAEXPAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_985_1 {
	meta:
		name = "__ehhandler$?propagate_message@?$single_assignment@I@Concurrency@@MAE?AW4message_status@2@PAV?$message@I@2@PAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?propagate_message@?$single_assignment@I@Concurrency@@MAE?AW4message_status@2@PAV?$message@I@2@PAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_720_1 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_688_1 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UAEXPAV?$ITarget@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_608_2 {
	meta:
		name = "__ehhandler$?release_ref@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?release_ref@?$source_block@V?$single_link_registry@V?$ITarget@I@Concurrency@@@Concurrency@@V?$ordered_message_processor@I@2@@Concurrency@@UAEXPAV?$ITarget@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_988_2 {
	meta:
		name = "__ehhandler$?send_message@?$single_assignment@I@Concurrency@@MAE?AW4message_status@2@PAV?$message@I@2@PAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?send_message@?$single_assignment@I@Concurrency@@MAE?AW4message_status@2@PAV?$message@I@2@PAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_138_0 {
	meta:
		name = "?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z"
		size = 302
		refs = "0003 __ehhandler$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z 0008 __EH_prolog3_catch 0016 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 007a ?_Interrupt@_TaskCollectionBase@details@Concurrency@@IAEX_NH@Z 0090 ?PopStructured@ContextBase@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ 00db ?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 00ec ?_WaitOnStolenChores@_StructuredTaskCollection@details@Concurrency@@AAEXJ@Z 010b ?_Abort@_StructuredTaskCollection@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 83 7E 08 00 75 08 E8 ?? ?? ?? ?? 89 46 08 8B 7E 08 8B 47 34 89 06 89 77 34 8B 06 89 7D EC 85 C0 74 0C 8B 40 04 C1 E0 04 C1 F8 04 40 EB 02 33 C0 8B 4E 04 8B 5D 0C 83 65 FC 00 33 C8 81 E1 FF FF FF 0F 31 4E 04 85 DB 74 2F F6 46 14 03 75 0C 8B 47 68 8B 4F 60 03 C1 85 C0 7E 14 F6 46 14 03 6A 00 0F 95 C0 0F B6 C0 50 8B CE E8 ?? ?? ?? ?? 53 FF 53 04 83 63 08 00 59 83 7E 0C 00 7E 54 8B CF E8 ?? ?? ?? ?? F6 46 14 03 8B D8 89 5D 0C 75 0C 8B 47 68 8B 4F 60 03 C1 85 C0 7E 14 F6 46 14 03 6A 02 0F 95 C0 0F B6 C0 50 8B CE E8 ?? ?? ?? ?? 85 DB 74 1E FF 4E 0C 80 7F 40 00 74 0B 8B 87 80 00 00 00 FF 40 0C EB A7 8D 4F FC E8 ?? ?? ?? ?? EB 9D 8B 46 0C 85 C0 7E 0C 50 8B CE E8 ?? ?? ?? ?? 83 66 0C 00 83 4D FC FF 8B 06 89 47 34 33 C0 39 46 14 0F 84 95 00 00 00 8B CE E8 ?? ?? ?? ?? 8B 47 68 8B 4F 60 03 C1 85 C0 7E 0B 6A 00 6A 00 8B CE E8 ?? ?? ?? ?? 6A 02 58 E9 87 00 00 00 }
	condition:
		$1
}

rule file_81_139_0 {
	meta:
		name = "__catch$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z$0"
		size = 82
		refs = "002e ?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 0039 ?_RaisedCancel@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0042 $LN36"
	strings:
		$1 = { 8B 7D 0C 8B 75 08 85 FF 74 2C F7 46 04 00 00 00 20 74 1F 8B 45 EC FF 4E 0C 80 78 40 00 74 0B 8B 80 80 00 00 00 FF 40 0C EB 08 8D 48 FC E8 ?? ?? ?? ?? 83 67 08 00 8B CE E8 ?? ?? ?? ?? 83 4D FC FF B8 ?? ?? ?? ?? C3 8B 75 08 8B 7D EC E9 78 FF FF FF }
	condition:
		$1
}

rule file_81_140_0 {
	meta:
		name = "__catch$?_RunAndWait@_StructuredTaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z$1"
		size = 61
		refs = "000f ?_RaisedException@_TaskCollectionBase@details@Concurrency@@IAEXXZ 0018 $LN36 002e ?_Interrupt@_TaskCollectionBase@details@Concurrency@@IAEX_NH@Z 0036 __EH_epilog3"
	strings:
		$1 = { 8B 45 0C 85 C0 74 04 83 60 08 00 8B 4D 08 E8 ?? ?? ?? ?? 83 4D FC FF B8 ?? ?? ?? ?? C3 8B 4F 68 8B 57 60 03 CA 85 C9 7E 09 50 50 8B CE E8 ?? ?? ?? ?? 33 C0 40 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_81_142_0 {
	meta:
		name = "?GetArbitraryAlias@ContextBase@details@Concurrency@@QAEPAV_TaskCollection@23@PAV423@@Z"
		size = 91
		refs = "0014 ?Find@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@PAPAV523@@Z 003f ?FindAndDelete@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE_NABQAV_TaskCollection@23@PAPAV423@@Z 0046 ??1_TaskCollection@details@Concurrency@@QAE@XZ 004c ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 57 8D 79 70 6A 00 8D 45 08 50 8B CF E8 ?? ?? ?? ?? 85 C0 74 05 8B 70 08 EB 02 33 F6 85 F6 74 2C 8B 46 68 D1 E8 A8 01 74 23 8B 46 54 89 45 FC 6A 00 8D 45 FC 50 8B CF E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 33 F6 5F 8B C6 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_81_143_0 {
	meta:
		name = "?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ"
		size = 154
		refs = "0003 __ehhandler$?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 0008 __EH_prolog3 000f ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 001f ?CreateWorkQueue@ContextBase@details@Concurrency@@QAEXXZ 003a ?GetIndirectAlias@ContextBase@details@Concurrency@@QBEPAV_TaskCollection@23@XZ 004b ?GetArbitraryAlias@ContextBase@details@Concurrency@@QAEPAV_TaskCollection@23@PAV423@@Z 0056 ??2@YAPAXI@Z 006b ??0_TaskCollection@details@Concurrency@@AAE@PAV012@_N@Z 007e ?SweepAliasTable@ContextBase@details@Concurrency@@QAEXXZ 008e ?Insert@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEPAUListNode@123@ABQAV_TaskCollection@23@0@Z 0095 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 E8 ?? ?? ?? ?? 8B F0 33 DB 39 5E 20 75 07 8B CE E8 ?? ?? ?? ?? 8B 46 20 8B 40 3C 3B 77 08 75 09 3B 47 70 75 04 8B C7 EB 5D 8B CE E8 ?? ?? ?? ?? 3B C3 74 05 39 78 54 74 4D 57 8B CE E8 ?? ?? ?? ?? 3B C3 75 41 6A 78 E8 ?? ?? ?? ?? 59 8B C8 89 4D EC 89 5D FC 3B CB 74 0A 6A 01 57 E8 ?? ?? ?? ?? 8B D8 83 4D FC FF 8B CE 89 5D F0 89 7D EC E8 ?? ?? ?? ?? 8D 45 F0 50 8D 45 EC 50 8D 4E 70 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_81_146_0 {
	meta:
		name = "?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 188
		refs = "0003 __ehhandler$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z 0008 __EH_prolog3_catch 0019 ??0invalid_multiple_scheduling@Concurrency@@QAE@XZ 001e __TI2?AVinvalid_multiple_scheduling@Concurrency@@ 0027 __CxxThrowException@8 0030 ?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 003c ?_UnstructuredChoreWrapper@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z 0058 ??2@YAPAXI@Z 007a ?_NotifyNewChore@_TaskCollection@details@Concurrency@@AAEXXZ 007f ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0087 ?PushUnstructured@ContextBase@details@Concurrency@@QAEHPAV_UnrealizedChore@23@@Z 008f ?Push@TaskStack@details@Concurrency@@QAE_NH@Z 009b __EH_epilog3"
	strings:
		$1 = { 6A 10 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 83 7B 08 00 74 16 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E4 50 E8 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? 8B F0 89 73 08 C7 43 0C ?? ?? ?? ?? 8B 7E 74 8D 47 01 89 46 74 83 FF 02 72 54 8B 7E 5C 85 FF 75 22 6A 10 E8 ?? ?? ?? ?? 59 33 C9 3B C1 74 0D 89 08 89 48 04 89 48 08 88 48 0C EB 02 33 C0 8B F8 89 46 5C 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 8B C8 E8 ?? ?? ?? ?? 50 8B CF E8 ?? ?? ?? ?? 84 C0 75 03 FF 4E 74 E8 ?? ?? ?? ?? C2 04 00 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 8B C8 E8 ?? ?? ?? ?? 89 44 BE 60 EB DE }
	condition:
		$1
}

rule file_81_147_0 {
	meta:
		name = "__catch$?_Schedule@_TaskCollection@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z$0"
		size = 18
		refs = "0004 ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z"
	strings:
		$1 = { FF 75 08 E8 ?? ?? ?? ?? 59 6A 00 6A 00 E9 58 FF FF FF }
	condition:
		$1
}

rule file_81_149_0 {
	meta:
		name = "?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z"
		size = 581
		refs = "0003 __ehhandler$?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z 0008 __EH_prolog3_catch 0012 ?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 001c ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0075 ?_NotifyNewChore@_TaskCollection@details@Concurrency@@AAEXXZ 007d ??0task_canceled@details@Concurrency@@QAE@XZ 0082 __TI2?AVtask_canceled@details@Concurrency@@ 008b __CxxThrowException@8 00e0 ?_Interrupt@_TaskCollectionBase@details@Concurrency@@IAEX_NH@Z 00f2 ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z 00fa ?_NotifyCompletedChore@_TaskCollection@details@Concurrency@@AAEXXZ 0174 ?TryPopUnstructured@ContextBase@details@Concurrency@@QAEPAV_UnrealizedChore@23@H@Z 01e7 ?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 01f6 ?_FullAliasWait@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z 0219 ?_UnderlyingYield@details@Concurrency@@YAXXZ 0229 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 8B CF E8 ?? ?? ?? ?? 8B F0 89 75 E8 E8 ?? ?? ?? ?? 8B D8 8B 47 58 89 45 E4 8B 43 34 89 5D E0 C6 45 EF 00 89 06 85 C0 74 0C 8B 40 04 C1 E0 04 C1 F8 04 40 EB 02 33 C0 8B 4E 04 83 65 FC 00 33 C8 81 E1 FF FF FF 0F 31 4E 04 33 C9 89 73 34 41 8D 56 34 33 C0 F0 0F B1 0A 83 F8 03 75 23 83 7D 0C 00 74 07 8B CE E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D4 50 E8 ?? ?? ?? ?? 83 7D 0C 00 74 6D 8B CE E8 ?? ?? ?? ?? 8B 43 68 8B 4B 60 03 C1 85 C0 7F 15 8B 45 08 8B 40 54 8B 40 30 85 C0 75 08 8B 46 34 83 F8 01 74 27 8B 45 08 8B 40 54 8B 40 30 85 C0 75 0C 8B 46 34 83 F8 01 75 04 32 C0 EB 03 33 C0 40 8B 4D 08 6A 00 50 E8 ?? ?? ?? ?? 8B 7D 0C 57 FF 57 04 83 67 08 00 59 57 E8 ?? ?? ?? ?? 59 8B CE E8 ?? ?? ?? ?? 83 65 0C 00 8B 7D 08 83 7E 74 00 0F 8E 83 00 00 00 8B 43 68 8B 4B 60 03 C1 85 C0 7F 12 8B 47 54 8B 40 30 85 C0 75 08 8B 46 34 83 F8 01 74 23 8B 47 54 8B 40 30 85 C0 75 0C 8B 46 34 83 F8 01 75 04 32 C0 EB 03 33 C0 40 6A 00 50 8B CF E8 ?? ?? ?? ?? 8B 46 74 83 F8 02 76 11 8B 46 5C FF 48 04 8B 48 04 8B 40 08 8B 04 88 EB 04 8B 44 87 5C FF 4E 74 50 8B CB E8 ?? ?? ?? ?? 8B F8 89 7D 0C 85 FF 75 4E 8B 46 5C 85 C0 74 03 21 78 04 83 66 74 00 8B 7D 08 8B 46 5C 85 C0 74 57 80 78 0C 00 74 51 6A 05 33 C0 C6 45 EF 01 59 8D 56 34 40 F0 0F B1 0A 83 F8 04 74 05 83 F8 09 75 36 8D 4D C8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C8 E9 BA FE FF FF 80 7B 40 00 74 0E 8B 83 80 00 00 00 FF 40 0C E9 04 FF FF FF 8D 4B FC E8 ?? ?? ?? ?? E9 F7 FE FF FF FF 75 E4 8B CF E8 ?? ?? ?? ?? 80 7D EF 00 74 2F 33 C9 6A 05 41 8D 56 34 58 F0 0F B1 0A 83 F8 09 75 1D 83 65 C0 00 C7 45 C4 ?? ?? ?? ?? 8B 47 34 83 F8 09 75 0A 8D 4D B8 E8 ?? ?? ?? ?? EB EE 8B 47 58 39 45 E4 75 06 83 4D FC FF EB 32 89 45 E4 E9 C0 FE FF FF }
	condition:
		$1
}

rule file_81_150_0 {
	meta:
		name = "__catch$?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z$0"
		size = 130
		refs = "000d ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z 0016 ?_NotifyCompletedChore@_TaskCollection@details@Concurrency@@AAEXXZ 001f $LN97 006b ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IAE_NXZ 0079 ?_Reset@_TaskCollection@details@Concurrency@@AAEXPAV123@@Z"
	strings:
		$1 = { 8B 45 0C 85 C0 74 13 83 60 08 00 50 E8 ?? ?? ?? ?? 59 8B 4D E8 E8 ?? ?? ?? ?? 83 4D FC FF B8 ?? ?? ?? ?? C3 8B 5D E0 8B 75 E8 8B 06 8B 7D 08 89 43 34 8B 43 60 8B 4B 68 03 C1 85 C0 7F 12 8B 47 54 8B 40 30 85 C0 75 08 8B 46 34 83 F8 01 74 23 8B 43 60 85 C0 7F 57 8B 47 54 8B 40 30 85 C0 75 4D 8B 46 34 85 C0 75 46 8B CF E8 ?? ?? ?? ?? 84 C0 75 3B FF 75 E4 8B CE E8 ?? ?? ?? ?? 33 C0 40 EB 4F }
	condition:
		$1
}

rule file_81_151_0 {
	meta:
		name = "__catch$?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z$1"
		size = 87
		refs = "000d ?_InternalFree@_UnrealizedChore@details@Concurrency@@CAXPAV123@@Z 0016 ?_NotifyCompletedChore@_TaskCollection@details@Concurrency@@AAEXXZ 001e ?_RaisedException@_TaskCollection@details@Concurrency@@AAEXXZ 0027 $LN97 0031 ?_Abort@_TaskCollection@details@Concurrency@@AAEX_N@Z 0048 ?_Interrupt@_TaskCollectionBase@details@Concurrency@@IAEX_NH@Z 0050 __EH_epilog3"
	strings:
		$1 = { 8B 45 0C 85 C0 74 13 83 60 08 00 50 E8 ?? ?? ?? ?? 59 8B 4D E8 E8 ?? ?? ?? ?? 8B 4D E8 E8 ?? ?? ?? ?? 83 4D FC FF B8 ?? ?? ?? ?? C3 6A 00 8B CE E8 ?? ?? ?? ?? 8B 43 60 8B 4B 68 03 C1 85 C0 7E 0B 6A 00 6A 00 8B CF E8 ?? ?? ?? ?? 6A 02 58 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_81_152_0 {
	meta:
		name = "__ehhandler$?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_RunAndWait@_TaskCollection@details@Concurrency@@QAG?AW4_TaskCollectionStatus@23@PAV_UnrealizedChore@23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_30_1057_1 {
	meta:
		name = "__ehhandler$?_Reset@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Reset@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_156_0 {
	meta:
		name = "?_IsCanceling@_TaskCollection@details@Concurrency@@QAE_NXZ"
		size = 196
		refs = "0012 ?_Alias@_TaskCollection@details@Concurrency@@AAEPAV123@XZ 0055 ?_WillInterruptForPendingCancel@_TaskCollectionBase@details@Concurrency@@IAE_NXZ 0060 ?_IsIndirectAlias@_TaskCollection@details@Concurrency@@ABE_NXZ"
	strings:
		$1 = { 8B FF 53 8B D9 8B 43 30 85 C0 74 04 B0 01 5B C3 56 E8 ?? ?? ?? ?? 8B F0 8B 4E 08 8B 41 64 85 C0 74 04 33 D2 EB 03 8B 51 5C 8B 41 64 85 C0 0F 85 8B 00 00 00 8B 46 04 C1 E0 04 C1 F8 04 83 F8 FF 74 09 83 FA FF 74 04 3B D0 7E 74 8B 41 68 85 C0 7E 0B 8B CE E8 ?? ?? ?? ?? 84 C0 75 62 8B CE E8 ?? ?? ?? ?? 84 C0 74 53 8B 4B 08 8B 41 64 85 C0 74 04 33 D2 EB 03 8B 51 5C 8B 41 64 85 C0 75 3F 8B 43 04 C1 E0 04 C1 F8 04 83 F8 FF 74 0E 83 FA FF 74 09 3B D0 7F 05 33 F6 46 EB 02 33 F6 8B 41 68 85 C0 7E 10 8B CB E8 ?? ?? ?? ?? 84 C0 74 05 33 C0 40 EB 02 33 C0 0B C6 75 04 32 C0 EB 02 B0 01 5E 5B C3 }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "_wparse_cmdline"
		size = 375
	strings:
		$1 = { 8B FF 55 8B EC 51 53 8B 5D 0C 56 33 F6 89 37 C7 03 01 00 00 00 39 75 08 74 09 8B 4D 08 83 45 08 04 89 11 3B D6 74 09 66 8B 08 66 89 0A 83 C2 02 FF 07 6A 22 59 66 39 08 75 11 33 DB 85 F6 0F 94 C3 83 C0 02 8B F3 8B 5D 0C EB 1A FF 07 85 D2 74 09 66 8B 08 66 89 0A 83 C2 02 0F B7 08 83 C0 02 66 85 C9 74 38 85 F6 75 C9 66 83 F9 20 74 06 66 83 F9 09 75 BD 85 D2 74 06 33 C9 66 89 4A FE 33 F6 66 83 38 00 0F 84 DC 00 00 00 0F B7 08 83 F9 20 74 05 83 F9 09 75 0A 83 C0 02 EB EE 83 E8 02 EB DD 66 83 38 00 0F 84 BB 00 00 00 83 7D 08 00 74 09 8B 4D 08 83 45 08 04 89 11 FF 03 85 D2 74 09 66 8B 08 66 89 0A 83 C2 02 FF 07 C7 45 FC 01 00 00 00 33 DB EB 04 83 C0 02 43 66 83 38 5C 74 F6 66 83 38 22 75 36 F6 C3 01 75 1D 85 F6 74 0C 66 83 78 02 22 75 05 83 C0 02 EB 0D 83 65 FC 00 33 C9 85 F6 0F 94 C1 8B F1 D1 EB EB 10 4B 85 D2 74 09 6A 5C 59 66 89 0A 83 C2 02 FF 07 85 DB 75 EC 0F B7 08 66 85 C9 74 28 85 F6 75 0A 83 F9 20 74 1F 83 F9 09 74 1A 83 7D FC 00 74 0C 85 D2 74 06 66 89 0A 83 C2 02 FF 07 83 C0 02 E9 7B FF FF FF 85 D2 74 08 33 C9 66 89 0A 83 C2 02 FF 07 8B 5D 0C E9 1A FF FF FF 8B 45 08 85 C0 74 03 83 20 00 FF 03 5E 5B C9 C3 }
	condition:
		$1
}

rule file_82_2_0 {
	meta:
		name = "___wsetargv"
		size = 181
		refs = "0010 ?_pgmname@?1??__wsetargv@@9@9 0022 __imp__GetModuleFileNameW@12 0027 __wcmdln 002d __wpgmptr 004b _wparse_cmdline 0074 __malloc_crt 0098 ___argc 009e ___wargv 00a3 __wcwild"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 57 68 04 01 00 00 BE ?? ?? ?? ?? 56 33 C0 33 FF 57 66 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 3B C7 74 07 8B D8 66 39 38 75 02 8B DE 8D 45 FC 50 57 8D 7D F8 33 D2 8B C3 E8 ?? ?? ?? ?? 8B 7D FC 59 59 81 FF FF FF FF 3F 73 51 8B 4D F8 81 F9 FF FF FF 7F 73 46 8D 04 79 03 C0 03 C9 3B C1 72 3B 50 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 2E 8D 45 FC 50 8D 14 BE 56 8D 7D F8 8B C3 E8 ?? ?? ?? ?? 8B 45 FC 59 48 59 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? F7 D8 1B C0 EB 03 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_84_3_0 {
	meta:
		name = "__stricoll_l"
		size = 158
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 0027 __invalid_parameter_noinfo 0054 __stricmp 0074 ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 5D 39 5D 0C 74 D8 8B 45 F0 8B 48 10 3B CB 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 33 FF 70 08 8D 45 F0 6A FF FF 75 0C 6A FF FF 75 08 68 01 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_84_4_0 {
	meta:
		name = "__stricoll"
		size = 38
		refs = "0007 ___locale_changed 0010 __stricmp 001d __stricoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 06 5D E9 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "___libm_sse2_atanf"
		size = 416
		refs = "000d _BMASK1 0019 _SGNMASK_S 0021 _BMASK2 0085 _ONEMASK 00b4 _cv 00c7 _atan_tbl 00fe _cvs 015c _pi_table"
	strings:
		$1 = { B9 C0 01 00 00 66 0F 6E D1 F3 0F 10 1D ?? ?? ?? ?? 66 0F 57 E4 F3 0F 10 3D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 73 F2 18 0F 54 D8 66 0F C5 D0 01 0F 54 F8 66 0F 57 C9 8B C2 81 E2 F8 7F 00 00 81 EA 00 3D 00 00 81 FA F8 22 00 00 0F 87 99 00 00 00 66 0F D4 DA B9 50 40 00 00 66 0F C4 E1 03 66 0F D4 FA 66 0F 73 F3 1D 66 0F C4 C9 03 66 0F 73 F7 1D F2 0F C2 E3 06 66 0F 56 DE F2 0F 10 C7 66 0F 12 2D ?? ?? ?? ?? F2 0F 5D D9 66 0F 54 C4 F2 0F 59 FB 66 0F 54 EC F2 0F 5C C3 F2 0F 58 FD F2 0F 5E C7 66 0F C5 D3 03 81 EA 9F 3F 00 00 66 0F 12 25 ?? ?? ?? ?? 25 00 80 00 00 66 0F C4 C8 03 66 0F 12 34 D5 ?? ?? ?? ?? 66 0F 57 F1 66 0F 57 C8 F2 0F 59 C0 F2 0F 59 E1 F2 0F 58 CE F2 0F 59 C4 F2 0F 58 C1 66 0F 5A C0 C3 81 C2 80 1D 00 00 81 FA 7F 40 00 00 77 35 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? F3 0F 59 FF F3 0F 59 E0 F3 0F 59 D0 F3 0F 10 EF F3 0F 59 FF F3 0F 59 E5 F3 0F 59 FA F3 0F 58 FC F3 0F 58 C7 C3 81 C2 80 1F 00 00 81 FA 80 5F 00 00 73 1B B8 01 00 80 3F 66 0F 7E C1 81 FA 80 00 00 00 0F 42 C1 66 0F 6E C8 F3 0F 59 C9 C3 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 1D ?? ?? ?? ?? 81 FA 7F 7F 00 00 77 19 25 00 80 00 00 66 0F 57 C0 66 0F C4 C0 01 0F 56 D0 0F 56 C3 F3 0F 58 C2 C3 66 0F 7E C2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 74 D5 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "__CRT_INIT@12"
		size = 356
		refs = "0003 __sehtable$__CRT_INIT@12 0008 __SEH_prolog4 0015 __heap_init 0025 __mtinit 002e __heap_term 0035 __RTC_Initialize 003b __imp__GetCommandLineA@0 0040 __acmdln 0045 ___crtGetEnvironmentStringsA 004a __aenvptr 004f __ioinit 0058 __mtterm 005f __setargv 0068 __setenvp 0073 __cinit 007e ___proc_attached 0088 __ioterm 00a7 __C_Termination_Done 00ae __cexit 00e0 ___flsindex 00f5 ___set_flsgetvalue 0101 __calloc_crt 011a _gpFlsSetValue 0120 __imp__DecodePointer@4 012d __initptd 0135 __imp__GetCurrentThreadId@0 0143 _free 0154 __freeptd 015d __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 0C 83 F8 01 75 7A E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 38 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 07 E8 ?? ?? ?? ?? EB E9 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 07 E8 ?? ?? ?? ?? EB CF E8 ?? ?? ?? ?? 85 C0 78 20 E8 ?? ?? ?? ?? 85 C0 78 17 6A 00 E8 ?? ?? ?? ?? 59 85 C0 75 0B FF 05 ?? ?? ?? ?? E9 D2 00 00 00 E8 ?? ?? ?? ?? EB C9 33 FF 3B C7 75 5B 39 3D ?? ?? ?? ?? 7E 81 FF 0D ?? ?? ?? ?? 89 7D FC 39 3D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 39 7D 10 75 0F E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 07 00 00 00 E9 82 00 00 00 33 FF 39 7D 10 75 0E 83 3D ?? ?? ?? ?? FF 74 05 E8 ?? ?? ?? ?? C3 EB 6A 83 F8 02 75 59 E8 ?? ?? ?? ?? 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 59 59 8B F0 3B F7 0F 84 0C FF FF FF 56 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 85 C0 74 17 57 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 89 06 83 4E 04 FF EB 18 56 E8 ?? ?? ?? ?? 59 E9 D0 FE FF FF 83 F8 03 75 07 57 E8 ?? ?? ?? ?? 59 33 C0 40 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_87_1_0 {
	meta:
		name = "___DllMainCRTStartup"
		size = 246
		refs = "0003 __sehtable$___DllMainCRTStartup 0008 __SEH_prolog4 001f ___proc_attached 0037 __pRawDllMain 0055 __CRT_INIT@12 0068 _DllMain@12 00dd ___CppXcptFilter 00f1 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B F2 8B 5D 08 33 C0 40 89 45 E4 85 F6 75 0C 39 15 ?? ?? ?? ?? 0F 84 C5 00 00 00 83 65 FC 00 3B F0 74 05 83 FE 02 75 2E A1 ?? ?? ?? ?? 85 C0 74 08 57 56 53 FF D0 89 45 E4 83 7D E4 00 0F 84 96 00 00 00 57 56 53 E8 ?? ?? ?? ?? 89 45 E4 85 C0 0F 84 83 00 00 00 57 56 53 E8 ?? ?? ?? ?? 89 45 E4 83 FE 01 75 24 85 C0 75 20 57 50 53 E8 ?? ?? ?? ?? 57 6A 00 53 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 06 57 6A 00 53 FF D0 85 F6 74 05 83 FE 03 75 26 57 56 53 E8 ?? ?? ?? ?? 85 C0 75 03 21 45 E4 83 7D E4 00 74 11 A1 ?? ?? ?? ?? 85 C0 74 08 57 56 53 FF D0 89 45 E4 C7 45 FC FE FF FF FF 8B 45 E4 EB 1D 8B 45 EC 8B 08 8B 09 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 C7 45 FC FE FF FF FF 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_87_2_0 {
	meta:
		name = "__DllMainCRTStartup@12"
		size = 35
		refs = "000c ___security_init_cookie 001a ___DllMainCRTStartup"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 01 75 05 E8 ?? ?? ?? ?? FF 75 08 8B 4D 10 8B 55 0C E8 ?? ?? ?? ?? 59 5D C2 0C 00 }
	condition:
		$1
}

rule file_88_1_0 {
	meta:
		name = "__make__time32_t"
		size = 583
		refs = "0009 ___security_cookie 0023 __errno 002e __invalid_parameter_noinfo 007e __days 00ce @__security_check_cookie@4 01b6 ___tzset 01bf __get_dstbias 01cd __get_timezone 01e5 __localtime32_s 021c __invoke_watson 0229 __gmtime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 33 DB 57 8B F9 89 5D CC 89 5D D0 3B FB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 8C 00 00 00 8B 4F 14 8D 41 BB 56 89 4D D4 83 F8 46 77 6E 8B 47 10 3B C3 7C 05 83 F8 0B 7E 23 6A 0C 99 5E F7 FE 03 C8 89 4D D4 89 57 10 3B D3 7D 09 03 D6 49 89 57 10 89 4D D4 8D 41 BB 83 F8 46 77 3F 8B 47 10 8B 14 85 ?? ?? ?? ?? F6 C1 03 75 06 83 F8 01 7E 01 42 8D 41 FF 69 C9 6D 01 00 00 C1 F8 02 03 C2 8D 84 01 21 9C FF FF 8B 4F 0C 8D 34 08 89 75 D4 3B C3 7C 25 3B CB 7C 29 3B F3 7D 25 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5E 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C3 3B CB 7D 04 3B F3 7D DB 8B CE 6B C9 18 3B F3 74 11 8B C1 99 F7 FE 33 D2 83 F8 18 0F 95 C2 8B C2 EB 02 33 C0 3B C3 75 BB 8B 47 08 8D 34 08 89 75 D4 3B CB 7C 0A 3B C3 7C 0E 3B F3 7C A6 EB 08 3B C3 7D 04 3B F3 7D 9C 8B CE 6B C9 3C 3B F3 74 11 8B C1 99 F7 FE 33 D2 83 F8 3C 0F 95 C2 8B C2 EB 02 33 C0 3B C3 0F 85 78 FF FF FF 8B 47 04 8D 34 08 89 75 D4 3B CB 7C 0E 3B C3 7C 16 3B F3 0F 8C 5F FF FF FF EB 0C 3B C3 7D 08 3B F3 0F 8D 51 FF FF FF 8B CE 6B C9 3C 3B F3 74 11 8B C1 99 F7 FE 33 D2 83 F8 3C 0F 95 C2 8B C2 EB 02 33 C0 3B C3 0F 85 2D FF FF FF 8B 07 8D 14 08 89 55 D4 3B CB 7C 0E 3B C3 7C 16 3B D3 0F 8C 15 FF FF FF EB 0C 3B C3 7D 08 3B D3 0F 8D 07 FF FF FF 39 5D 08 74 6B E8 ?? ?? ?? ?? 8D 45 CC 50 E8 ?? ?? ?? ?? 59 85 C0 75 4E 8D 45 D0 50 E8 ?? ?? ?? ?? 59 85 C0 75 40 8B 45 D0 01 45 D4 8D 45 D4 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 C4 FE FF FF 8B 47 20 3B C3 7F 07 7D 3B 39 5D F8 7E 36 8B 45 CC 01 45 D4 8D 45 D4 50 8D 45 D8 50 E8 ?? ?? ?? ?? EB 17 53 53 53 53 53 E8 ?? ?? ?? ?? 8D 45 D4 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 80 FE FF FF 8B 45 D4 6A 09 59 8D 75 D8 F3 A5 E9 7E FE FF FF }
	condition:
		$1
}

rule file_88_2_0 {
	meta:
		name = "__mktime32"
		size = 18
		refs = "000b __make__time32_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 6A 01 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_873_2_0 {
	meta:
		name = "__mktime64"
		size = 18
		refs = "000b __make__time64_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 6A 01 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_88_3_0 {
	meta:
		name = "__mkgmtime32"
		size = 18
		refs = "000b __make__time32_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 6A 00 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_873_3_0 {
	meta:
		name = "__mkgmtime64"
		size = 18
		refs = "000b __make__time64_t"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 6A 00 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__wdospawn"
		size = 527
		refs = "0034 ___doserrno 003b __errno 0046 __invalid_parameter_noinfo 0079 _memset 0082 __nhandle 009a ___pioinfo 00d7 __calloc_crt 018b __imp__CreateProcessW@40 0193 __imp__GetLastError@0 019d _free 01a8 __dosmaperr 01b7 __exit 01bd __imp__CloseHandle@4 01cd __imp__WaitForSingleObject@8 01da __imp__GetExitCodeProcess@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 68 8B 45 08 53 33 DB 57 88 5D FF 3B C3 74 15 83 F8 01 74 10 7E 16 83 F8 03 7E 09 83 F8 04 75 0C C6 45 FF 01 8B 45 10 89 45 F0 EB 36 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B9 01 00 00 83 C0 02 66 39 18 75 F8 66 39 58 02 74 09 6A 20 5A 66 89 10 83 C0 02 66 39 18 75 E4 56 6A 44 5E 56 8D 45 98 53 50 E8 ?? ?? ?? ?? 89 75 98 8B 35 ?? ?? ?? ?? 83 C4 0C 3B F3 74 2B 8D 46 FF 8B C8 8B D0 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E2 1F C1 E2 06 38 5C 11 04 75 06 4E 48 3B F3 75 E0 3B F3 0F 8C 44 01 00 00 81 FE 32 33 00 00 0F 83 38 01 00 00 8B C6 6B C0 05 83 C0 04 66 89 45 CA 0F B7 C0 6A 01 50 E8 ?? ?? ?? ?? 59 59 89 45 CC 3B C3 0F 84 14 01 00 00 89 30 8B 45 CC 8D 48 04 8D 7C 30 04 89 5D F8 3B F3 7E 39 8B 45 F8 8B D0 83 E0 1F C1 FA 05 C1 E0 06 03 04 95 ?? ?? ?? ?? 8A 50 04 F6 C2 10 75 08 88 11 8B 00 89 07 EB 05 88 19 83 0F FF FF 45 F8 41 83 C7 04 39 75 F8 7C CA 8B 45 CC 38 5D FF 74 2A 8D 48 04 33 D2 8D 44 30 04 83 FE 03 7D 04 8B FE EB 03 6A 03 5F 3B D7 7D 0C 88 19 83 08 FF 42 41 83 C0 04 EB E4 6A 08 5E EB 02 8B F3 E8 ?? ?? ?? ?? 89 18 8D 45 DC 50 8D 45 98 50 53 FF 75 14 81 CE 00 04 00 00 56 6A 01 53 53 FF 75 F0 FF 75 0C FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? FF 75 CC 8B F8 E8 ?? ?? ?? ?? 59 3B F3 75 09 57 E8 ?? ?? ?? ?? 59 EB 58 83 7D 08 02 75 06 53 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 39 5D 08 75 1D 6A FF FF 75 DC FF 15 ?? ?? ?? ?? 8D 45 EC 50 FF 75 DC FF 15 ?? ?? ?? ?? 8B 5D EC EB 06 83 7D 08 04 75 07 FF 75 DC FF D6 EB 03 8B 5D DC FF 75 E0 FF D6 8B C3 EB 0E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 C8 FF 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_91_1_0 {
	meta:
		name = "_wadd"
		size = 65
		refs = "0008 __malloc_crt 001f _arghead 002a _argend"
		altNames = "_add"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 E8 ?? ?? ?? ?? 59 85 C0 75 05 83 C8 FF 5D C3 8B 4D 08 83 60 04 00 83 3D ?? ?? ?? ?? 00 89 08 74 0B 8B 0D ?? ?? ?? ?? 89 41 04 EB 05 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_91_2_0 {
	meta:
		name = "_wsort"
		size = 55
		refs = "0011 __wcsicmp"
	strings:
		$1 = { 8B FF 57 8B F8 85 FF 74 2C 56 EB 21 FF 37 FF 36 E8 ?? ?? ?? ?? 59 59 85 C0 79 08 8B 0E 8B 07 89 0F 89 06 8B 76 04 85 F6 75 E2 8B 7F 04 8B 77 04 85 F6 75 D8 5E 5F C3 }
	condition:
		$1
}

rule file_501_2_0 {
	meta:
		name = "_sort"
		size = 55
		refs = "0011 __mbsicmp"
	strings:
		$1 = { 8B FF 57 8B F8 85 FF 74 2C 56 EB 21 FF 37 FF 36 E8 ?? ?? ?? ?? 59 59 85 C0 79 08 8B 0E 8B 07 89 0F 89 06 8B 76 04 85 F6 75 E2 8B 7F 04 8B 77 04 85 F6 75 D8 5E 5F C3 }
	condition:
		$1
}

rule file_91_3_0 {
	meta:
		name = "_wfind"
		size = 149
		refs = "000f ?findbuf@?1??wfind@@9@9 001b __malloc_crt 002e ?_WildFindHandle@?1??wfind@@9@9 0039 __imp__FindClose@4 0052 __imp__FindFirstFileExW@24 0079 __imp__FindNextFileW@8"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 74 5E 39 35 ?? ?? ?? ?? 75 18 68 54 03 00 00 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 3B C6 75 04 33 C0 EB 3B A1 ?? ?? ?? ?? 3B C6 74 0D 50 FF 15 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 56 56 56 FF 35 ?? ?? ?? ?? 56 FF 75 08 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 F8 FF 74 C9 A1 ?? ?? ?? ?? 83 C0 2C 5E 5D C3 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 DF FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? EB 94 }
	condition:
		$1
}

rule file_91_4_0 {
	meta:
		name = "_wmatch"
		size = 453
		refs = "006c _wfind 007e _argend 0086 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 008e _wcscmp 009d ??_C@_15DDHGOCBH@?$AA?4?$AA?4?$AA?$AA@ 00c9 __wcsdup 00d7 _wadd 00ec _wcslen 0109 __calloc_crt 011c _wcsncpy_s 0132 _wcscpy_s 017a __invoke_watson 0180 _arghead 018f __wcsicmp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B 75 0C 33 DB 89 5D F8 3B F3 75 08 83 C8 FF E9 A3 01 00 00 57 8B 7D 08 EB 18 0F B7 06 83 F8 5C 74 14 83 F8 2F 74 0F 83 F8 3A 74 10 83 EE 02 89 75 0C 3B F7 75 E4 66 83 3E 3A 75 0B 8D 47 02 3B F0 0F 85 68 01 00 00 0F B7 06 83 F8 5C 74 0A 83 F8 2F 74 05 83 F8 3A 75 07 8B DE 2B DF D1 FB 43 57 E8 ?? ?? ?? ?? 59 89 45 FC 85 C0 0F 84 3D 01 00 00 8B 3D ?? ?? ?? ?? 89 7D F4 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 B5 00 00 00 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 9E 00 00 00 0F B7 06 83 F8 5C 74 2D 83 F8 3A 74 28 83 F8 2F 74 23 FF 75 FC E8 ?? ?? ?? ?? 59 89 45 08 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 83 C8 FF E9 D8 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 59 8D 74 18 01 85 DB 78 E7 81 FE FF FF FF 7F 73 DF 3B F3 72 DB 6A 02 56 E8 ?? ?? ?? ?? 8B F8 59 59 85 FF 74 CB 53 FF 75 08 56 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 4B FF 75 FC 2B F3 8D 04 5F 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 35 57 E8 ?? ?? ?? ?? 59 85 C0 75 98 8B 75 0C 8B 7D F4 FF 45 F8 6A 00 E8 ?? ?? ?? ?? 59 89 45 FC 85 C0 0F 85 21 FF FF FF 39 45 F8 74 4D 85 FF 74 11 8B 77 04 EB 12 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 85 F6 74 2A EB 21 FF 36 FF 37 E8 ?? ?? ?? ?? 59 59 85 C0 79 08 8B 0F 8B 06 89 0E 89 07 8B 7F 04 85 FF 75 E2 8B 76 04 8B 7E 04 85 FF 75 D8 33 C0 EB 0A 8B 7D 08 57 E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_91_5_0 {
	meta:
		name = "__wcwild"
		size = 189
		refs = "0005 ___wargv 000e _argend 0014 _arghead 0020 ??_C@_15EAECJAPL@?$AA?$CK?$AA?$DP?$AA?$AA@ 0026 _wcspbrk 0034 _wmatch 003e _wadd 006b __calloc_crt 0077 ___argc 00a7 _free"
	strings:
		$1 = { 8B FF 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 30 83 06 02 8B 06 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 3B C7 74 0B 50 FF 36 E8 ?? ?? ?? ?? 59 EB 07 FF 36 E8 ?? ?? ?? ?? 59 85 C0 75 10 83 C6 04 39 3E 75 CC A1 ?? ?? ?? ?? 33 F6 EB 09 83 C8 FF EB 5E 8B 40 04 46 3B C7 75 F8 8D 46 01 50 6A 04 E8 ?? ?? ?? ?? 59 59 3B C7 74 E2 89 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B CE 3B F7 74 0E 8B 11 89 10 8B 49 04 83 C0 04 3B CF 75 F2 89 38 8B C6 3B F7 74 16 8B 76 04 50 E8 ?? ?? ?? ?? 59 8B C6 3B F7 75 F0 89 35 ?? ?? ?? ?? 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_92_5_0 {
	meta:
		name = "?ThrottleActivation@VirtualProcessor@details@Concurrency@@QAEX_N@Z"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8A 45 08 88 81 80 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_92_7_0 {
	meta:
		name = "??0ThreadInternalContext@details@Concurrency@@QAE@PAVSchedulerBase@12@@Z"
		size = 36
		refs = "000c ??0InternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@@Z 0012 ??_7ThreadInternalContext@details@Concurrency@@6BIExecutionContext@2@@ 0019 ??_7ThreadInternalContext@details@Concurrency@@6BContextBase@12@@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_12_0 {
	meta:
		name = "?GetCriticalRegionType@ContextBase@details@Concurrency@@UBE?AW4CriticalRegionType@3@XZ"
		size = 20
	strings:
		$1 = { 83 79 10 00 76 04 6A 02 58 C3 33 C0 3B 41 0C 1B C0 F7 D8 C3 }
	condition:
		$1
}

rule file_92_14_0 {
	meta:
		name = "?PrepareToRun@InternalContextBase@details@Concurrency@@MAEXPAVVirtualProcessor@23@@Z"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 81 84 00 00 00 33 C0 83 C1 2C 87 01 5D C2 04 00 }
	condition:
		$1
}

rule file_92_16_0 {
	meta:
		name = "??1ThreadInternalContext@details@Concurrency@@UAE@XZ"
		size = 18
		refs = "0002 ??_7ThreadInternalContext@details@Concurrency@@6BIExecutionContext@2@@ 0009 ??_7ThreadInternalContext@details@Concurrency@@6BContextBase@12@@ 000e ??1InternalContextBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { C7 01 ?? ?? ?? ?? C7 41 04 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_221_17_0 {
	meta:
		name = "??1UMSThreadInternalContext@details@Concurrency@@UAE@XZ"
		size = 18
		refs = "0002 ??_7UMSThreadInternalContext@details@Concurrency@@6BIExecutionContext@2@@ 0009 ??_7UMSThreadInternalContext@details@Concurrency@@6BContextBase@12@@ 000e ??1InternalContextBase@details@Concurrency@@UAE@XZ"
	strings:
		$1 = { C7 01 ?? ?? ?? ?? C7 41 04 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_20_0 {
	meta:
		name = "??_GThreadInternalContext@details@Concurrency@@UAEPAXI@Z"
		size = 46
		refs = "000a ??_7ThreadInternalContext@details@Concurrency@@6BIExecutionContext@2@@ 0011 ??_7ThreadInternalContext@details@Concurrency@@6BContextBase@12@@ 0016 ??1InternalContextBase@details@Concurrency@@UAE@XZ 0022 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_21_0 {
	meta:
		name = "?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 56
		refs = "0003 __ehhandler$?CreateVirtualProcessor@ThreadScheduler@details@Concurrency@@UAEPAVVirtualProcessor@23@PAVSchedulingNode@23@PAUIVirtualProcessorRoot@3@@Z 0008 __EH_prolog3 0012 ??2@YAPAXI@Z 002c ??0ThreadVirtualProcessor@details@Concurrency@@QAE@PAVSchedulingNode@12@PAUIVirtualProcessorRoot@2@@Z 0031 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 94 00 00 00 E8 ?? ?? ?? ?? 59 8B C8 89 4D F0 33 C0 89 45 FC 3B C8 74 0B FF 75 0C FF 75 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_92_24_0 {
	meta:
		name = "?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ"
		size = 51
		refs = "0003 __ehhandler$?CreateInternalContext@ThreadScheduler@details@Concurrency@@MAEPAVInternalContextBase@23@XZ 0008 __EH_prolog3 0014 ??2@YAPAXI@Z 0029 ??0ThreadInternalContext@details@Concurrency@@QAE@PAVSchedulerBase@12@@Z 002e __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 68 D0 00 00 00 E8 ?? ?? ?? ?? 59 8B C8 89 4D F0 33 C0 89 45 FC 3B C8 74 06 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_33_0 {
	meta:
		name = "?HasWorkPending@ThreadScheduler@details@Concurrency@@MAE_NXZ"
		size = 26
		refs = "000b ?HasWorkPending@SchedulerBase@details@Concurrency@@MAE_NXZ"
	strings:
		$1 = { 8B 81 6C 01 00 00 85 C0 7F 0C E8 ?? ?? ?? ?? 84 C0 75 03 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_92_34_0 {
	meta:
		name = "?DestroySchedulerEventHandlers@ThreadScheduler@details@Concurrency@@MAEXXZ"
		size = 32
		refs = "0014 __imp__SetEvent@4 001c ?DestroySchedulerEventHandlers@SchedulerBase@details@Concurrency@@MAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 FF B6 68 01 00 00 C6 86 58 01 00 00 01 FF 15 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_38_0 {
	meta:
		name = "?AddTail@?$List@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z"
		size = 79
	strings:
		$1 = { 8B FF 55 8B EC 8B 01 85 C0 75 11 8B 45 08 89 80 84 00 00 00 89 80 88 00 00 00 EB 2D 8B 90 84 00 00 00 8B 45 08 89 90 84 00 00 00 8B 11 89 90 88 00 00 00 8B 11 8B 92 84 00 00 00 89 82 88 00 00 00 8B 11 89 82 84 00 00 00 89 01 5D C2 04 00 }
	condition:
		$1
}

rule file_92_39_0 {
	meta:
		name = "?RemoveHead@?$List@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEPAVVirtualProcessor@23@XZ"
		size = 58
	strings:
		$1 = { 8B FF 56 8B 31 85 F6 75 04 33 C0 5E C3 8B 86 84 00 00 00 3B F0 75 05 83 21 00 5E C3 57 8B B8 84 00 00 00 89 B7 88 00 00 00 8B 09 8B 90 84 00 00 00 5F 89 91 84 00 00 00 5E C3 }
	condition:
		$1
}

rule file_92_40_0 {
	meta:
		name = "?Remove@?$List@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z"
		size = 80
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 8B 9E 88 00 00 00 57 8B BE 84 00 00 00 89 9F 88 00 00 00 8B 86 88 00 00 00 8B 96 84 00 00 00 89 90 84 00 00 00 8B 01 5F 3B F0 5E 5B 75 14 3B 80 84 00 00 00 75 04 33 C0 EB 06 8B 80 88 00 00 00 89 01 5D C2 04 00 }
	condition:
		$1
}

rule file_92_49_0 {
	meta:
		name = "??0ThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z"
		size = 63
		refs = "0003 __ehhandler$??0ThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z 0008 __EH_prolog3 0015 ??0SchedulerBase@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z 001f ??_7ThreadScheduler@details@Concurrency@@6B@ 0031 ??0_ReaderWriterLock@details@Concurrency@@QAE@XZ 0038 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 FF 75 08 E8 ?? ?? ?? ?? 83 65 FC 00 C7 06 ?? ?? ?? ?? 83 A6 5C 01 00 00 00 8D 8E 60 01 00 00 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_92_52_0 {
	meta:
		name = "?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
		size = 51
		refs = "0003 __ehhandler$?Create@ThreadScheduler@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z 0008 __EH_prolog3 0012 ??2@YAPAXI@Z 0029 ??0ThreadScheduler@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z 002e __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 70 01 00 00 E8 ?? ?? ?? ?? 59 8B C8 89 4D F0 33 C0 89 45 FC 3B C8 74 08 FF 75 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_55_0 {
	meta:
		name = "?ThrottleOversubscriber@ThreadScheduler@details@Concurrency@@UAEXPAVVirtualProcessor@23@@Z"
		size = 101
		refs = "0011 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0030 ?AddTail@?$List@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z 004f __imp__SetEvent@4 005a ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B F1 57 8D 8E 60 01 00 00 E8 ?? ?? ?? ?? 8B 4D 08 80 B9 80 00 00 00 00 75 32 C6 81 80 00 00 00 01 51 8D 8E 5C 01 00 00 E8 ?? ?? ?? ?? 33 C9 8D 86 6C 01 00 00 41 F0 0F C1 08 41 83 F9 01 75 0C FF B6 68 01 00 00 FF 15 ?? ?? ?? ?? 8D 8E 60 01 00 00 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_92_56_0 {
	meta:
		name = "?RemoveThrottleOversubscriber@ThreadScheduler@details@Concurrency@@UAEXPAVVirtualProcessor@23@@Z"
		size = 62
		refs = "0011 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 002c ?Remove@?$List@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z 0034 ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D B1 5C 01 00 00 57 8D 4E 04 E8 ?? ?? ?? ?? 8B 4D 08 80 B9 80 00 00 00 00 74 0F C6 81 80 00 00 00 00 51 8B CE E8 ?? ?? ?? ?? 8D 4E 04 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_92_57_0 {
	meta:
		name = "?ManageOversubscribers@ThreadScheduler@details@Concurrency@@AAEXXZ"
		size = 251
		refs = "0003 __ehhandler$?ManageOversubscribers@ThreadScheduler@details@Concurrency@@AAEXXZ 0008 __EH_prolog3 0018 ?ThrottlingTime@SchedulerBase@details@Concurrency@@QAEKK@Z 0020 __imp__GetTickCount@0 0044 __imp__WaitForSingleObject@8 0071 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 0080 ?RemoveHead@?$List@VVirtualProcessor@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QAEPAVVirtualProcessor@23@XZ 0094 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NXZ 00a3 ?GetAnonymousScheduleGroup@SchedulerBase@details@Concurrency@@QAEPAVScheduleGroupBase@23@XZ 00ac ?ActivateVirtualProcessor@SchedulerBase@details@Concurrency@@IAEXPAVVirtualProcessor@23@PAVScheduleGroupBase@23@@Z 00b9 ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ 00d1 ?AttemptSchedulerSweep@SchedulerBase@details@Concurrency@@IAEXXZ 00ea __imp__CloseHandle@4 00f1 ?DecrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ 00f6 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 33 FF 89 7D F0 6A 01 8B CE E8 ?? ?? ?? ?? 8B D8 FF 15 ?? ?? ?? ?? 89 45 EC 2B 45 F0 8B CB 2B C8 3B C3 1B C0 23 C1 85 FF 75 03 83 C8 FF 50 FF B6 68 01 00 00 FF 15 ?? ?? ?? ?? 80 BE 58 01 00 00 00 0F 85 8D 00 00 00 3D 02 01 00 00 75 7E 8B 45 EC 89 45 F0 8D 86 5C 01 00 00 8D 58 04 8B CB 89 45 EC E8 ?? ?? ?? ?? 83 65 FC 00 8D 8E 5C 01 00 00 E8 ?? ?? ?? ?? 8B F8 85 FF 74 26 8B CF C6 87 80 00 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 14 8B CE C6 47 7B 00 E8 ?? ?? ?? ?? 50 57 8B CE E8 ?? ?? ?? ?? 83 CF FF 8B CB 89 7D FC E8 ?? ?? ?? ?? 8D 86 6C 01 00 00 F0 0F C1 38 4F 0F 85 45 FF FF FF 8B CE E8 ?? ?? ?? ?? E9 39 FF FF FF 33 FF 47 E9 31 FF FF FF FF B6 68 01 00 00 FF 15 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_60_0 {
	meta:
		name = "?BackgroundOversubscribeManagerProc@ThreadScheduler@details@Concurrency@@CGKPAX@Z"
		size = 27
		refs = "0009 ?ManageOversubscribers@ThreadScheduler@details@Concurrency@@AAEXXZ 0010 ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 59 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_865_50_0 {
	meta:
		name = "?BackgroundContextCreationProc@UMSThreadScheduler@details@Concurrency@@CGKPAX@Z"
		size = 27
		refs = "0009 ?WaitForContextCreationRequest@UMSThreadScheduler@details@Concurrency@@AAEXXZ 0010 ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 59 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_991_26_0 {
	meta:
		name = "?BackgroundPollerMain@UMSBackgroundPoller@details@Concurrency@@CGKPAX@Z"
		size = 27
		refs = "0009 ?StartPolling@UMSBackgroundPoller@details@Concurrency@@AAEXXZ 0010 ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 59 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_429_151_0 {
	meta:
		name = "?DynamicRMThreadProc@ResourceManager@details@Concurrency@@CGKPAX@Z"
		size = 27
		refs = "0009 ?DynamicResourceManager@ResourceManager@details@Concurrency@@AAEXXZ 0010 ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 59 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_764_24_0 {
	meta:
		name = "?TransmogrificatorMain@Transmogrificator@details@Concurrency@@CGKPAX@Z"
		size = 27
		refs = "0009 ?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AAEXXZ 0010 ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 59 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_92_61_0 {
	meta:
		name = "?InitializeSchedulerEventHandlers@ThreadScheduler@details@Concurrency@@MAEXXZ"
		size = 81
		refs = "001a __imp__CreateEventW@16 0027 ?IncrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ 002f ?BackgroundOversubscribeManagerProc@ThreadScheduler@details@Concurrency@@CGKPAX@Z 003a ?LoadLibraryAndCreateThread@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@KP6GKPAX@Z1KPAK@Z 0044 __imp__CloseHandle@4 004d ?InitializeSchedulerEventHandlers@SchedulerBase@details@Concurrency@@MAEXXZ"
	strings:
		$1 = { 8B FF 53 56 33 DB 53 53 8B F1 53 53 89 9E 6C 01 00 00 88 9E 58 01 00 00 FF 15 ?? ?? ?? ?? 8B CE 89 86 68 01 00 00 E8 ?? ?? ?? ?? 53 53 56 68 ?? ?? ?? ?? 68 00 00 01 00 53 E8 ?? ?? ?? ?? 83 C4 18 50 FF 15 ?? ?? ?? ?? 8B CE 5E 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "_HRESULT_FROM_WIN32"
		size = 24
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 7E 0A 25 FF FF 00 00 0D 00 00 07 80 5D C3 }
	condition:
		$1
}

rule file_93_7_0 {
	meta:
		name = "??0HardwareAffinity@details@Concurrency@@QAE@ABU012@@Z"
		size = 29
		refs = "000f _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 56 6A 0C FF 75 08 8B F1 56 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_93_8_0 {
	meta:
		name = "??8HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z"
		size = 35
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 66 8B 50 04 66 3B 51 04 75 0B 8B 00 3B 01 75 05 33 C0 40 EB 02 33 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_93_9_0 {
	meta:
		name = "??9HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z"
		size = 24
		refs = "0009 ??8HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_93_24_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
		size = 41
		refs = "000e ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 0015 ??_7ExecutionResource@details@Concurrency@@6B@ 001d ??3@YAXPAX@Z"
		altNames = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UAEPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_93_33_0 {
	meta:
		name = "?NotifyBlocked@UMSThreadProxy@details@Concurrency@@QAEX_N@Z"
		size = 34
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 38 45 08 0F 95 C0 40 80 7D 08 00 89 41 1C 75 07 33 C0 83 C1 20 87 01 5D C2 04 00 }
	condition:
		$1
}

rule file_93_35_0 {
	meta:
		name = "?SetAffinity@UMSFreeThreadProxy@details@Concurrency@@QAEXUHardwareAffinity@23@@Z"
		size = 65
		refs = "0014 ??8HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z 0023 ?ApplyTo@HardwareAffinity@details@Concurrency@@QAEXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F9 8D 45 08 50 8D 8F B0 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 0B FF 77 14 8D 4D 08 E8 ?? ?? ?? ?? 66 8B 45 0C 66 89 87 B4 00 00 00 8B 45 08 89 87 B0 00 00 00 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_93_37_0 {
	meta:
		name = "?GetThreadProxyId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 16
		refs = "0003 ?s_threadProxyIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 33 C9 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 8B C1 C3 }
	condition:
		$1
}

rule file_429_59_0 {
	meta:
		name = "?GetExecutionContextId@Concurrency@@YAIXZ"
		size = 16
		refs = "0003 ?s_executionContextIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 33 C9 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 8B C1 C3 }
	condition:
		$1
}

rule file_429_55_0 {
	meta:
		name = "?GetExecutionContextId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 16
		refs = "0003 ?s_executionContextIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 33 C9 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 8B C1 C3 }
	condition:
		$1
}

rule file_369_71_0 {
	meta:
		name = "?GetNewWorkQueueId@SchedulerBase@details@Concurrency@@SAIXZ"
		size = 16
		refs = "0003 ?s_workQueueIdCounter@SchedulerBase@details@Concurrency@@0JC"
	strings:
		$1 = { 33 C9 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 8B C1 C3 }
	condition:
		$1
}

rule file_429_58_0 {
	meta:
		name = "?GetSchedulerId@Concurrency@@YAIXZ"
		size = 16
		refs = "0003 ?s_schedulerIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 33 C9 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 8B C1 C3 }
	condition:
		$1
}

rule file_429_54_0 {
	meta:
		name = "?GetSchedulerId@ResourceManager@details@Concurrency@@SAIXZ"
		size = 16
		refs = "0003 ?s_schedulerIdCount@ResourceManager@details@Concurrency@@0JC"
	strings:
		$1 = { 33 C9 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 8B C1 C3 }
	condition:
		$1
}

rule file_93_44_0 {
	meta:
		name = "?PollForCompletion@UMSSchedulerProxy@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
		size = 24
		refs = "0010 ?InsertProxyInCompletionWhenAwake@UMSBackgroundPoller@details@Concurrency@@QAEXPAVUMSThreadProxy@23@PAVUMSSchedulerProxy@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 41 14 51 FF 75 08 8B 48 60 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_93_47_0 {
	meta:
		name = "??0InitialThreadParam@UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAV123@@Z"
		size = 87
		refs = "001b __imp__CreateEventW@16 0027 __imp__GetLastError@0 003e ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0043 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 004c __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 10 56 6A 00 6A 00 6A 00 8B F1 6A 00 89 46 04 FF 15 ?? ?? ?? ?? 89 06 85 C0 75 2B FF 15 ?? ?? ?? ?? 85 C0 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 8B C6 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_93_49_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@ABV01@@Z"
		size = 38
		refs = "000e ??0exception@std@@QAE@ABV01@@Z 0014 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 57 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B 47 0C 89 46 0C 5F 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_50_11_1 {
	meta:
		name = "??0regex_error@tr1@std@@QAE@ABV012@@Z"
		size = 38
		refs = "000e ??0exception@std@@QAE@ABV01@@Z 0014 ??_7regex_error@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 57 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B 47 0C 89 46 0C 5F 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_93_54_0 {
	meta:
		name = "?OnPrimary@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAE_NXZ"
		size = 21
		refs = "0007 __imp__GetCurrentThreadId@0"
	strings:
		$1 = { 8B FF 56 8B F1 FF 15 ?? ?? ?? ?? 2B 46 68 5E F7 D8 1B C0 40 C3 }
	condition:
		$1
}

rule file_93_57_0 {
	meta:
		name = "??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UAE@XZ"
		size = 64
		refs = "000b __imp__CloseHandle@4 0011 ??_7UMSFreeVirtualProcessorRoot@details@Concurrency@@6BIThreadProxy@2@@ 0018 ??_7UMSFreeVirtualProcessorRoot@details@Concurrency@@6BUMSBaseObject@12@@ 001f ??_7UMSFreeVirtualProcessorRoot@details@Concurrency@@6BVirtualProcessorRoot@12@@ 0032 ??_7VirtualProcessorRoot@details@Concurrency@@6B@ 003a ??_7ExecutionResource@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 56 8B F1 57 FF 76 5C 8B 3D ?? ?? ?? ?? C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? FF D7 FF 76 58 FF D7 FF 76 54 FF D7 C7 46 08 ?? ?? ?? ?? 5F C7 46 0C ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_93_59_0 {
	meta:
		name = "?DeleteThis@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAEXXZ"
		size = 91
		refs = "0007 ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPAXXZ 000d ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z 0054 __imp__SetEvent@4"
	strings:
		$1 = { 8B FF 56 57 8B F1 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B F8 59 85 FF 74 08 8D 4F 04 8B 01 FF 50 18 C6 46 6A 01 85 FF 74 12 8B 47 20 8D 4E F8 3B C1 74 26 8D 4F 04 8B 01 FF 50 1C 83 7E 4C 00 74 18 80 7E 6B 00 75 09 FF 76 50 C6 46 6B 01 EB 03 FF 76 50 FF 15 ?? ?? ?? ?? 5F 5E C3 }
	condition:
		$1
}

rule file_93_60_0 {
	meta:
		name = "?Activate@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@@Z"
		size = 99
		refs = "0023 __imp__SetEvent@4 004c ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 80 7E 69 00 74 1B 33 C0 8D 4E 48 40 F0 0F C1 01 40 83 F8 02 74 40 FF 76 50 FF 15 ?? ?? ?? ?? EB 35 8B 4D 08 57 89 4E 58 8B 01 8D 7E F8 57 FF 50 0C 8B 4E 18 C6 46 69 01 C7 46 48 01 00 00 00 83 C6 04 56 E8 ?? ?? ?? ?? FF 77 58 C6 47 73 01 FF 15 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_93_61_0 {
	meta:
		name = "?EnsureAllTasksVisible@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@@Z"
		size = 191
		refs = "000f __imp__GetCurrentThreadId@0 003b ??0invalid_operation@Concurrency@@QAE@XZ 0040 __TI2?AVinvalid_operation@Concurrency@@ 0049 __CxxThrowException@8 007d ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPAXXZ 0083 ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z 0093 ?FlushStoreBuffers@ResourceManager@details@Concurrency@@QAEXXZ 00a8 ??_C@_08BAFMHLII@pContext?$AA@ 00ad ??0exception@std@@QAE@ABQBD@Z 00b4 ??_7invalid_argument@std@@6B@ 00b9 __TI3?AVinvalid_argument@std@@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 57 8B F1 FF 15 ?? ?? ?? ?? 3B 46 60 8B 7D 08 0F 94 45 FF 33 DB 3B FB 74 7B 38 5D FF 74 05 3B 7E 58 75 71 39 5E 5C 75 1B 38 5D FF 75 16 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 07 8B CF FF 50 08 8D 4E F8 3B C1 74 12 8B 07 8B CF FF 50 08 85 C0 74 05 8D 58 FC EB 02 33 DB 80 7D FF 00 75 19 85 DB 74 15 39 5E 5C 75 BB E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 3B C3 75 AB 8B 46 18 8B 48 0C E8 ?? ?? ?? ?? 5F 5E 5B C9 C2 04 00 8D 45 08 50 8D 4D F0 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 F0 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 85 }
	condition:
		$1
}

rule file_93_66_0 {
	meta:
		name = "?InternalDeactivate@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAE_NXZ"
		size = 139
		refs = "0051 __imp__WaitForMultipleObjects@16 006a ?SweepCompletionList@UMSSchedulerProxy@details@Concurrency@@QAE_NPAVUMSThreadProxy@23@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B D9 8B 43 58 89 45 F0 8B 43 20 56 C7 45 FC 02 00 00 00 85 C0 74 05 8D 48 F8 EB 02 33 C9 8B 89 DC 00 00 00 89 4D F4 85 C0 74 05 83 C0 F8 EB 02 33 C0 8B 80 E0 00 00 00 89 45 F8 85 C0 74 07 C7 45 FC 03 00 00 00 8B 35 ?? ?? ?? ?? EB 17 8B 43 20 85 C0 74 05 8D 48 F8 EB 02 33 C9 6A 00 6A 00 E8 ?? ?? ?? ?? 6A FF 6A 00 8D 45 F0 50 FF 75 FC FF D6 83 F8 01 74 D7 33 C9 85 C0 5E 0F 94 C0 5B C9 C3 }
	condition:
		$1
}

rule file_93_67_0 {
	meta:
		name = "?Affinitize@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N@Z"
		size = 130
		refs = "0009 ___security_cookie 0024 ?SpinUntilBlocked@UMSThreadProxy@details@Concurrency@@IAEXXZ 0047 ?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QAE?AUHardwareAffinity@23@I@Z 0058 _memcpy 0062 ?SetAffinity@UMSFreeThreadProxy@details@Concurrency@@QAEXUHardwareAffinity@23@@Z 006a ?PrepareToRun@UMSThreadProxy@details@Concurrency@@IAEXPAVUMSFreeVirtualProcessorRoot@23@@Z 007a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 33 DB 57 8B 7D 08 8B F1 38 5D 0C 75 07 8B CF E8 ?? ?? ?? ?? 39 77 24 74 39 8B 46 20 3B C3 74 03 8D 58 F8 8D 4E 08 8B 01 FF 10 50 8D 45 F0 50 8D 4B 08 E8 ?? ?? ?? ?? 83 EC 0C 8B C4 6A 0C 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 0C 8B CF E8 ?? ?? ?? ?? 56 8B CF E8 ?? ?? ?? ?? 8B 4D FC 89 7E 64 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C2 08 00 }
	condition:
		$1
}

rule file_93_68_0 {
	meta:
		name = "?CriticalBlockAndExecute@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@@Z"
		size = 115
		refs = "003a ?SweepCompletionList@UMSSchedulerProxy@details@Concurrency@@QAE_NPAVUMSThreadProxy@23@_N@Z 004a __imp__WaitForMultipleObjects@16 0056 ?IsTerminated@UMSThreadProxy@details@Concurrency@@QAE_NXZ 0068 ?Execute@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8B F1 8B 46 5C 89 45 F8 8B 46 20 85 C0 74 05 83 C0 F8 EB 02 33 C0 8B 80 DC 00 00 00 89 45 FC 8B 46 20 85 C0 74 05 8D 48 F8 EB 02 33 C9 6A 00 6A 00 E8 ?? ?? ?? ?? 6A FF 6A 00 8D 45 F8 50 6A 02 FF 15 ?? ?? ?? ?? 85 C0 75 D5 8B 4D 08 E8 ?? ?? ?? ?? 84 C0 75 10 6A 01 6A 00 FF 75 08 8B CE E8 ?? ?? ?? ?? EB B9 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_93_69_0 {
	meta:
		name = "?InvokeSchedulingContext@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEX_N@Z"
		size = 40
	strings:
		$1 = { 8B FF 55 8B EC 51 51 0F B6 45 08 8B 49 60 83 E0 01 8D 55 F8 C7 45 F8 08 00 00 00 89 45 FC 8B 01 52 FF 50 10 C9 C2 04 00 }
	condition:
		$1
}

rule file_93_73_0 {
	meta:
		name = "?GetResourceManager@UMSFreeVirtualProcessorRoot@details@Concurrency@@QAEPAVResourceManager@23@XZ"
		size = 18
	strings:
		$1 = { 8B 41 20 85 C0 74 05 83 C0 F8 EB 02 33 C0 8B 40 14 C3 }
	condition:
		$1
}

rule file_93_83_0 {
	meta:
		name = "?Release@UMSSchedulerProxy@details@Concurrency@@QAEJXZ"
		size = 43
		refs = "001b ??1UMSSchedulerProxy@details@Concurrency@@QAE@XZ 0021 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 56 57 8B F9 8D 87 F4 00 00 00 83 CE FF F0 0F C1 30 4E 75 10 85 FF 74 0C E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_93_85_0 {
	meta:
		name = "?Deactivate@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAE_NPAUIExecutionContext@3@@Z"
		size = 271
		refs = "000f __imp__GetCurrentThreadId@0 0043 ??0invalid_operation@Concurrency@@QAE@XZ 0048 __TI2?AVinvalid_operation@Concurrency@@ 0051 __CxxThrowException@8 0085 ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPAXXZ 008b ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z 00b5 ?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 00c0 ?Deactivate@UMSThreadProxy@details@Concurrency@@IAE_NXZ 00ca ?InternalDeactivate@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAE_NXZ 00dd ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 00f5 ??_C@_08BAFMHLII@pContext?$AA@ 00fa ??0exception@std@@QAE@ABQBD@Z 0101 ??_7invalid_argument@std@@6B@ 0106 __TI3?AVinvalid_argument@std@@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 57 8B F1 FF 15 ?? ?? ?? ?? 3B 46 60 8B 7D 08 0F 94 45 FF 33 DB 3B FB 0F 84 C4 00 00 00 38 5D FF 74 09 3B 7E 58 0F 85 B6 00 00 00 39 5E 5C 75 1B 38 5D FF 75 16 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 8B 07 8B CF FF 50 08 8D 4E F8 3B C1 74 12 8B 07 8B CF FF 50 08 85 C0 74 05 8D 58 FC EB 02 33 DB 80 7D FF 00 75 19 85 DB 74 15 39 5E 5C 75 BB E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 3B C3 75 AB 80 7E 68 00 74 1F 8D 46 48 83 C9 FF F0 0F C1 08 49 75 3A 80 7E 68 00 74 0C 8B 4E 18 8D 46 04 50 E8 ?? ?? ?? ?? 85 DB 74 09 8B CB E8 ?? ?? ?? ?? EB 08 8D 4E F8 E8 ?? ?? ?? ?? 88 46 68 84 C0 74 0C 8B 4E 18 8D 46 04 50 E8 ?? ?? ?? ?? 8A 46 68 5F 5E 5B C9 C2 04 00 8D 45 08 50 8D 4D F0 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 F0 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 3D FF FF FF }
	condition:
		$1
}

rule file_93_87_0 {
	meta:
		name = "?HandleBlocking@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N@Z"
		size = 96
		refs = "003c ?InvokeSchedulingContext@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEX_N@Z 004d ?CriticalBlockAndExecute@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 8B D9 8D 4E 04 8B 01 FF 50 20 89 45 08 83 F8 02 74 26 83 7D 08 01 75 06 80 7D 0C 00 75 1A C7 46 1C 01 00 00 00 33 C0 8D 4E 20 87 01 FF 75 0C 8B CB E8 ?? ?? ?? ?? EB DA 56 8B CB C7 46 1C 02 00 00 00 E8 ?? ?? ?? ?? 8B 06 6A 01 8B CE FF 50 04 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_93_89_0 {
	meta:
		name = "?Execute@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N1@Z"
		size = 151
		refs = "0011 ?Affinitize@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N@Z 0035 ?ExecuteUmsThread@UMS@details@Concurrency@@SAHPAX@Z 0040 ?IsSuspended@UMSThreadProxy@details@Concurrency@@QAE_NXZ 0067 ?InsertProxyInCompletionWhenAwake@UMSBackgroundPoller@details@Concurrency@@QAEXPAVUMSThreadProxy@23@PAVUMSSchedulerProxy@23@@Z 008d ?HandleBlocking@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 FF 75 10 8B 75 08 56 8B D9 E8 ?? ?? ?? ?? 80 7D 10 00 75 04 83 66 34 00 8D 4E 04 8B 01 57 FF 50 20 85 C0 6A 0A 0F 95 45 13 5F FF 76 10 E8 ?? ?? ?? ?? 4F 59 75 0E 8B CE E8 ?? ?? ?? ?? 84 C0 75 07 6A 0A 5F F3 90 EB E2 8B 43 20 5F 85 C0 74 05 83 C0 F8 EB 02 33 C0 50 8B 40 14 8B 48 60 56 E8 ?? ?? ?? ?? 80 7D 0C 00 74 16 80 7D 13 00 75 10 C7 46 1C 01 00 00 00 33 C0 83 C6 20 87 06 EB 0A 6A 01 56 8B CB E8 ?? ?? ?? ?? 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_93_90_0 {
	meta:
		name = "?HandleYielding@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@@Z"
		size = 334
		refs = "0050 ?Execute@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N1@Z 006b ?ReturnIdleProxy@UMSFreeThreadProxy@details@Concurrency@@AAEXXZ 0098 __imp__WaitForSingleObject@8 00b0 ?InternalDeactivate@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAE_NXZ 0103 ?InvokeSchedulingContext@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEX_N@Z 011f ?GetResourceManager@UMSFreeVirtualProcessorRoot@details@Concurrency@@QAEPAVResourceManager@23@XZ 0128 ?UnblockTransmogrification@Transmogrificator@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 8B 46 34 33 DB 43 57 8B F9 3B C3 0F 84 EE 00 00 00 83 F8 02 0F 84 AB 00 00 00 83 F8 03 0F 84 DC 00 00 00 83 F8 04 74 71 83 F8 06 7E 1D 89 5E 1C 33 C0 8D 4E 20 87 01 8B 07 8B CF FF 50 0C 6A 00 6A 00 56 8B CF E8 ?? ?? ?? ?? 83 F8 05 0F 94 C0 84 C0 74 13 89 5E 1C 33 C0 8D 4E 20 87 01 8B CE E8 ?? ?? ?? ?? EB 12 8D 4E 04 8B 01 FF 50 1C 89 5E 1C 33 C0 83 C6 20 87 06 80 7F 72 00 75 13 83 67 64 00 6A FF FF 77 58 C6 47 71 00 FF 15 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 89 5E 1C 33 C0 8D 4E 20 87 01 8B CF E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 6A 00 6A 00 41 89 4E 40 FF 77 64 8B CF E8 ?? ?? ?? ?? EB CD 8B 46 38 83 65 08 00 85 C0 74 03 89 45 08 89 5E 1C 33 C0 8D 4E 20 87 01 8B CE E8 ?? ?? ?? ?? 33 F6 39 75 08 74 0A 56 56 FF 75 08 E9 4E FF FF FF 56 8B CF E8 ?? ?? ?? ?? EB F6 8B 4E 38 83 65 08 00 85 C9 74 03 89 4D 08 83 F8 03 75 12 8B CF E8 ?? ?? ?? ?? 8B 48 64 56 E8 ?? ?? ?? ?? EB 0A 89 5E 1C 33 C0 83 C6 20 87 06 33 C0 39 45 08 74 04 50 50 EB B4 6A 00 8B CF E8 ?? ?? ?? ?? EB F5 }
	condition:
		$1
}

rule file_93_91_0 {
	meta:
		name = "?SwitchTo@UMSFreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@W4SwitchingProxyState@3@@Z"
		size = 44
		refs = "0023 ?Execute@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 8B 01 FF 50 08 85 C0 74 05 83 C0 FC EB 02 33 C0 6A 00 6A 01 50 8B CE E8 ?? ?? ?? ?? 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_93_93_0 {
	meta:
		name = "?PrimaryInvocation@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z"
		size = 402
		refs = "0003 __ehhandler$?PrimaryInvocation@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z 0008 __EH_prolog3_catch 0011 ?GetCurrentUmsThread@UMS@details@Concurrency@@SAPAXXZ 003c ?SetUmsThreadInformation@UMS@details@Concurrency@@SAHPAXW4_RTL_UMS_THREAD_INFO_CLASS@@0K@Z 0049 __imp__GetLastError@0 0060 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0065 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 006e __CxxThrowException@8 0076 __imp__SetEvent@4 008c ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPAK@Z 00e0 ?HandleYielding@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@@Z 00f5 ?HandleBlocking@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N@Z 0102 __imp__WaitForSingleObject@8 0110 ?InvokeSchedulingContext@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEX_N@Z 0116 ?s_fRequireUMSWorkaround@ResourceManager@details@Concurrency@@0_NA 0158 ?Cancel@UMSThreadProxy@details@Concurrency@@QAEXXZ 0164 ?Execute@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXPAVUMSFreeThreadProxy@23@_N1@Z 0169 ?s_terminating@ResourceManager@details@Concurrency@@0JC 017b ??0invalid_operation@Concurrency@@QAE@XZ 0180 __TI2?AVinvalid_operation@Concurrency@@"
	strings:
		$1 = { 6A 4C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 33 DB E8 ?? ?? ?? ?? 39 7D 08 75 64 8B 7D 10 8B 77 04 89 75 10 85 F6 74 08 8D 4E 04 89 4D EC EB 03 21 5D EC 6A 04 8D 4D EC 51 6A 01 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 2B FF 15 ?? ?? ?? ?? 85 C0 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D B8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 B8 50 E8 ?? ?? ?? ?? FF 37 FF 15 ?? ?? ?? ?? 33 FF EB 54 57 6A 04 8D 4D E8 51 6A 01 50 89 7D E8 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 27 FF 15 ?? ?? ?? ?? 3B C7 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D A8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 A8 EB AE 8B 45 E8 3B C7 74 05 8D 70 FC EB 02 33 F6 8B 5E 64 89 75 10 8B 45 08 2B C7 74 22 48 8B CE 74 08 53 E8 ?? ?? ?? ?? EB 2E 8A 45 0C F6 D0 24 01 88 45 0C FF 75 0C 53 E8 ?? ?? ?? ?? EB 19 6A FF FF 76 58 FF 15 ?? ?? ?? ?? 80 7E 72 00 75 08 57 8B CE E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 0F 84 09 01 00 00 83 7D 08 02 0F 85 FF 00 00 00 89 7D 08 8B 46 20 89 7D FC 3B C7 74 05 83 C0 F8 EB 02 33 C0 8D 48 08 8B 01 57 FF 50 1C 3B C7 74 03 8D 78 FC FF 47 54 FF 47 58 8B CF E8 ?? ?? ?? ?? 6A 01 6A 01 57 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 1B 83 7D 08 0A 7C 15 8D 4D D8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D8 E9 E0 FE FF FF 83 4D FC FF EB 34 }
	condition:
		$1
}

rule file_93_94_0 {
	meta:
		name = "__catch$?PrimaryInvocation@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z$0"
		size = 101
		refs = "0001 ?s_terminating@ResourceManager@details@Concurrency@@0JC 000d ?get_error_code@scheduler_resource_allocation_error@Concurrency@@QBEJXZ 002c $LN83 004e __aullrem 005a __imp__SleepEx@8"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 75 1E 8B 4D E4 E8 ?? ?? ?? ?? 3D 05 00 07 80 75 06 83 7D 08 0A 7C 09 6A 00 6A 00 E9 B4 FE FF FF 83 4D FC FF B8 ?? ?? ?? ?? C3 8B 75 10 A1 ?? ?? ?? ?? 85 C0 75 41 FF 45 08 0F 31 6A 01 6A 00 68 F3 01 00 00 52 50 E8 ?? ?? ?? ?? 05 F4 01 00 00 50 FF 15 ?? ?? ?? ?? 33 FF E9 37 FF FF FF }
	condition:
		$1
}

rule file_93_95_0 {
	meta:
		name = "__catch$?PrimaryInvocation@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z$1"
		size = 59
		refs = "0001 ?s_terminating@ResourceManager@details@Concurrency@@0JC 0014 $LN83 0025 ?_UnderlyingYield@details@Concurrency@@YAXXZ 002d ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ 0034 __EH_epilog3"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 74 B0 83 7D 08 0A 7D AA 83 4D FC FF B8 ?? ?? ?? ?? C3 A1 ?? ?? ?? ?? 83 65 D0 00 C7 45 D4 ?? ?? ?? ?? 8D 4D C8 E8 ?? ?? ?? ?? EB F6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_93_96_0 {
	meta:
		name = "__ehhandler$?PrimaryInvocation@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?PrimaryInvocation@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_97_0 {
	meta:
		name = "?PrimaryMain@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGKPAX@Z"
		size = 178
		refs = "0034 ?PrimaryInvocation@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGXW4_RTL_UMS_SCHEDULER_REASON@@KPAX@Z 003c ?EnterUmsSchedulingMode@UMS@details@Concurrency@@SAHPAU_UMS_SCHEDULER_STARTUP_INFO@@@Z 0048 ??2@YAPAXI@Z 0055 __imp__GetLastError@0 006b ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0079 __TI3PAVscheduler_resource_allocation_error@Concurrency@@ 0082 __CxxThrowException@8 0095 ?Release@UMSSchedulerProxy@details@Concurrency@@QAEJXZ 00a6 ?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 4D 08 56 8B 71 04 C7 45 F0 00 01 00 00 8B 46 20 85 C0 74 05 83 C0 F8 EB 02 33 C0 8B 80 D8 00 00 00 89 45 F4 8D 45 F0 50 C7 45 F8 ?? ?? ?? ?? 89 4D FC E8 ?? ?? ?? ?? 59 85 C0 75 41 6A 10 E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 21 FF 15 ?? ?? ?? ?? 85 C0 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8B CE E8 ?? ?? ?? ?? 89 45 08 EB 04 83 65 08 00 68 ?? ?? ?? ?? 8D 45 08 50 E8 ?? ?? ?? ?? 8B 46 20 85 C0 74 05 8D 48 F8 EB 02 33 C9 E8 ?? ?? ?? ?? 8D 4E 08 8B 01 6A 01 FF 50 20 6A 00 E8 ?? ?? ?? ?? 59 33 C0 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_93_98_0 {
	meta:
		name = "?CreatePrimary@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXXZ"
		size = 185
		refs = "0003 __ehhandler$?CreatePrimary@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXXZ 0008 __EH_prolog3_GS 0013 ??0InitialThreadParam@UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAV123@@Z 0023 ?PrimaryMain@UMSFreeVirtualProcessorRoot@details@Concurrency@@CGKPAX@Z 002d ?LoadLibraryAndCreateThread@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@KP6GKPAX@Z1KPAK@Z 0072 ?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QAE?AUHardwareAffinity@23@I@Z 0079 ?ApplyTo@HardwareAffinity@details@Concurrency@@QAEXPAX@Z 0096 __imp__SetThreadPriority@8 00a1 __imp__WaitForSingleObject@8 00af __imp__CloseHandle@4 00b4 __EH_epilog3_GS"
	strings:
		$1 = { 6A 18 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 56 8D 4D DC E8 ?? ?? ?? ?? 33 DB 8D 46 68 50 53 8D 45 DC 50 68 ?? ?? ?? ?? 53 53 89 5D FC E8 ?? ?? ?? ?? 89 46 54 8B 46 20 83 C4 18 3B C3 74 05 83 C0 F8 EB 02 33 C0 33 C9 05 F4 00 00 00 41 F0 0F C1 08 8B 46 20 3B C3 74 05 8D 78 F8 EB 02 33 FF FF 76 54 8D 4E 08 8B 01 FF 10 50 8D 45 E4 50 8D 4F 08 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 46 20 3B C3 74 05 83 C0 F8 EB 02 33 C0 FF B0 A0 00 00 00 FF 76 54 FF 15 ?? ?? ?? ?? 6A FF FF 75 DC FF 15 ?? ?? ?? ?? 39 5D DC 74 09 FF 75 DC FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_93_100_0 {
	meta:
		name = "__ehhandler$?CreatePrimary@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?CreatePrimary@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A D8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_101_0 {
	meta:
		name = "??0UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVUMSSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 223
		refs = "0003 __ehhandler$??0UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVUMSSchedulerProxy@12@PAUSchedulerNode@12@I@Z 0008 __EH_prolog3 0018 ??_7IThreadProxy@Concurrency@@6B@ 001f ??_7UMSBaseObject@details@Concurrency@@6B@ 0039 ??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z 0044 ??_7UMSFreeVirtualProcessorRoot@details@Concurrency@@6BIThreadProxy@2@@ 004b ??_7UMSFreeVirtualProcessorRoot@details@Concurrency@@6BUMSBaseObject@12@@ 0052 ??_7UMSFreeVirtualProcessorRoot@details@Concurrency@@6BVirtualProcessorRoot@12@@ 006a ?s_threadProxyIdCount@ResourceManager@details@Concurrency@@0JC 0076 __imp__CreateEventW@16 008c __imp__GetLastError@0 00a3 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 00a8 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00b1 __CxxThrowException@8 00d1 ?CreatePrimary@UMSFreeVirtualProcessorRoot@details@Concurrency@@AAEXXZ 00d8 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 8B 45 08 33 DB C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? 3B C3 74 05 83 C0 08 EB 02 33 C0 FF 75 10 8D 4E 08 FF 75 0C 50 E8 ?? ?? ?? ?? 33 C9 89 5D FC C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 89 5E 54 89 5E 58 89 5E 60 89 5E 64 C7 46 70 01 00 00 00 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 8B 3D ?? ?? ?? ?? 53 53 53 53 89 4E 6C FF D7 89 46 5C 3B C3 75 2B FF 15 ?? ?? ?? ?? 3B C3 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 53 53 53 53 FF D7 89 46 58 3B C3 75 0C FF 15 ?? ?? ?? ?? 3B C3 7E D2 EB C6 8B CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_93_103_0 {
	meta:
		name = "__ehhandler$??0UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVUMSSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVUMSSchedulerProxy@12@PAUSchedulerNode@12@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_93_0 {
	meta:
		name = "__ehhandler$??$_Resetp@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@tr1@std@@AAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Resetp@V__ExceptionPtr@@P6AXPAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@tr1@std@@AAEXPAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_209_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@DDH@std@@@std@@YAABV?$codecvt@DDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@DDH@std@@@std@@YAABV?$codecvt@DDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_38_216_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@GDH@std@@@std@@YAABV?$codecvt@GDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@GDH@std@@@std@@YAABV?$codecvt@GDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_607_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@_WDH@std@@@std@@YAABV?$codecvt@_WDH@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@_WDH@std@@@std@@YAABV?$codecvt@_WDH@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_335_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_1055_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_982_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_178_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_167_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_167_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_231_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_619_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_572_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_234_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_599_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_598_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_259_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_602_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_578_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_312_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_309_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_718_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_715_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_709_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_706_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_200_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_610_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_586_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_203_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_590_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_589_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_218_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_616_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_592_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_293_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_721_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_735_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_262_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_605_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_604_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_718_61_0 {
	meta:
		name = "__ehhandler$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ExternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_132_0 {
	meta:
		name = "__ehhandler$??0ResourceManager@details@Concurrency@@AAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ResourceManager@details@Concurrency@@AAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_248_0 {
	meta:
		name = "__ehhandler$??0SchedulerBase@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0SchedulerBase@details@Concurrency@@QAE@ABVSchedulerPolicy@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_772_9_0 {
	meta:
		name = "__ehhandler$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0ThreadProxyFactoryManager@details@Concurrency@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_772_63_0 {
	meta:
		name = "__ehhandler$??0UMSFreeThreadProxyFactory@details@Concurrency@@QAE@PAVThreadProxyFactoryManager@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0UMSFreeThreadProxyFactory@details@Concurrency@@QAE@PAVThreadProxyFactoryManager@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_649_2 {
	meta:
		name = "__ehhandler$??1_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Originator@?1???$send@I@Concurrency@@YA_NPAV?$ITarget@I@1@ABI@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_638_2 {
	meta:
		name = "__ehhandler$??1_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Originator@?1???$send@W4agent_status@Concurrency@@@Concurrency@@YA_NPAV?$ITarget@W4agent_status@Concurrency@@@1@ABW4agent_status@1@@Z@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_217_0 {
	meta:
		name = "__ehhandler$?Initialize@SchedulerBase@details@Concurrency@@AAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?Initialize@SchedulerBase@details@Concurrency@@AAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_264_0 {
	meta:
		name = "__ehhandler$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXABVSchedulerPolicy@3@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_357_2 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_354_2 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_82_2 {
	meta:
		name = "__ehhandler$?_Internal_grow@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIIIP6AXPAXPBXI@Z1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Internal_grow@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIIIP6AXPAXPBXI@Z1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_74_2 {
	meta:
		name = "__ehhandler$?_Internal_reserve@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Internal_reserve@_Concurrent_vector_base_v4@details@Concurrency@@IAEXIII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_753_2 {
	meta:
		name = "__ehhandler$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@I@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@I@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@I@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_78_814_2 {
	meta:
		name = "__ehhandler$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@W4agent_status@Concurrency@@@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?remove@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QAE_NPAV?$ISource@W4agent_status@Concurrency@@@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_581_32_0 {
	meta:
		name = "__ehhandler$?reset@event@Concurrency@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?reset@event@Concurrency@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_792_17_0 {
	meta:
		name = "__ehhandler$?wait@Concurrency@@YAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wait@Concurrency@@YAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_1_0 {
	meta:
		name = "?_TryAcquire@_NonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 18
	strings:
		$1 = { 8B 01 85 C0 75 09 40 8B D0 87 11 85 D2 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_95_5_0 {
	meta:
		name = "?_UnderlyingYield@details@Concurrency@@YAXXZ"
		size = 22
		refs = "0001 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0012 __imp__SwitchToThread@0"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 1C FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_7_0 {
	meta:
		name = "?_TryAcquire@_HyperNonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 40
		refs = "0007 ?StaticEnterHyperCriticalRegion@ContextBase@details@Concurrency@@SAXXZ 001f ?StaticExitHyperCriticalRegion@ContextBase@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 8B FF 53 56 8B F1 E8 ?? ?? ?? ?? 8B 06 85 C0 75 0B 33 DB 43 8B C3 87 06 85 C0 74 07 32 DB E8 ?? ?? ?? ?? 5E 8A C3 5B C3 }
	condition:
		$1
}

rule file_95_9_0 {
	meta:
		name = "?_TryAcquire@_CriticalNonReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 40
		refs = "0007 ?StaticEnterCriticalRegion@ContextBase@details@Concurrency@@SAXXZ 001f ?StaticExitCriticalRegion@ContextBase@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 8B FF 53 56 8B F1 E8 ?? ?? ?? ?? 8B 06 85 C0 75 0B 33 DB 43 8B C3 87 06 85 C0 74 07 32 DB E8 ?? ?? ?? ?? 5E 8A C3 5B C3 }
	condition:
		$1
}

rule file_95_12_0 {
	meta:
		name = "?_ConcRT_Assert@details@Concurrency@@YAXPBD0H@Z"
		size = 254
		refs = "000c ___security_cookie 001f ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0026 ?OnPrimary@UMSSchedulingContext@details@Concurrency@@SA_NXZ 0030 __imp__DebugBreak@0 003d @__security_check_cookie@4 004a ?GetScheduler@ContextBase@details@Concurrency@@QBEPAVSchedulerBase@23@XZ 0059 __imp__GetCurrentThreadId@0 0061 ?ScheduleGroupRefCount@ContextBase@details@Concurrency@@QBEIXZ 007e ??_C@_1GI@NCMIFDBM@?$AA?$FL?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?$CI?$AA?$CF?$AAd?$AA?$CJ?$AA?$FN?$AA?5?$AA?$CF?$AAS?$AA?3?$AA?5?$AA?$CB?$AA?$CB?$AA?$CB?$AA?$CB?$AA?$CB?$AA?$CB?$AA?$CB?$AAA?$AAs?$AAs@ 008f _swprintf_s 00a5 ??_C@_1EO@DDNBJEBC@?$AA?$FL?$AA?$CF?$AAd?$AA?$FN?$AA?5?$AA?$CF?$AAS?$AA?3?$AA?5?$AA?$CB?$AA?$CB?$AA?$CB?$AA?$CB?$AA?$CB?$AA?$CB?$AA?$CB?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CI?$AA?$CF?$AAS@ 00cc _g_DebugOutFilePtr 00d1 _fwprintf 00dc _fflush 00ec __imp__OutputDebugStringW@4 00f9 _exit"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 08 08 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 0C 56 57 8B 7D 08 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 84 C0 74 15 FF 15 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 85 F6 74 51 8B CE E8 ?? ?? ?? ?? 85 C0 74 46 FF 75 10 53 57 FF 15 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 50 8B 06 8B CE FF 50 08 50 8B 06 8B CE FF 10 50 8B 06 8B CE FF 50 04 50 68 ?? ?? ?? ?? 8D 85 F8 F7 FF FF 68 00 04 00 00 50 E8 ?? ?? ?? ?? 83 C4 2C EB 25 FF 75 10 53 57 FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 85 F8 F7 FF FF 68 00 04 00 00 50 E8 ?? ?? ?? ?? 83 C4 1C 33 C0 66 89 45 F8 8D 85 F8 F7 FF FF 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8D 85 F8 F7 FF FF 50 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A F8 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_95_16_0 {
	meta:
		name = "?ReferenceLoadLibrary@details@Concurrency@@YAXXZ"
		size = 141
		refs = "000c ___security_cookie 0019 __imp__GetModuleHandleA@4 001e ___ImageBase 0035 __imp__GetModuleFileNameW@12 0046 __imp__LoadLibraryW@4 004b ?HostModule@details@Concurrency@@3PAUHINSTANCE__@@A 0055 @__security_check_cookie@4 005d __imp__GetLastError@0 0077 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 007c __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0088 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 1C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 6A 00 FF 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 3B C1 74 29 68 04 01 00 00 8D 85 F4 FD FF FF 50 51 FF 15 ?? ?? ?? ?? 85 C0 74 1E 8D 85 F4 FD FF FF 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 FF 15 ?? ?? ?? ?? 85 C0 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 8D E4 FD FF FF E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_95_20_0 {
	meta:
		name = "?LoadLibraryAndCreateThread@details@Concurrency@@YAPAXPAU_SECURITY_ATTRIBUTES@@KP6GKPAX@Z1KPAK@Z"
		size = 116
		refs = "000b ?LoadLibraryCount@details@Concurrency@@3JC 001b ?ReferenceLoadLibrary@details@Concurrency@@YAXXZ 0022 ?s_oneShotInitializationState@SchedulerBase@details@Concurrency@@0JA 003f __imp__CreateThread@24 0049 __imp__GetLastError@0 0060 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0065 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 006e __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 33 C9 83 EC 10 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 83 F9 01 75 11 E8 ?? ?? ?? ?? 33 C9 B8 ?? ?? ?? ?? 41 F0 0F C1 08 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 2B FF 15 ?? ?? ?? ?? 85 C0 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_95_21_0 {
	meta:
		name = "?FreeLibraryAndDestroyThread@details@Concurrency@@YAXK@Z"
		size = 45
		refs = "0006 ?LoadLibraryCount@details@Concurrency@@3JC 0014 ?CheckOneShotStaticDestruction@SchedulerBase@details@Concurrency@@SAXXZ 0019 ?HostModule@details@Concurrency@@3PAUHINSTANCE__@@A 0027 __imp__FreeLibraryAndExitThread@8"
	strings:
		$1 = { 8B FF 55 8B EC B8 ?? ?? ?? ?? 83 C9 FF F0 0F C1 08 75 18 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 0A FF 75 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_95_22_0 {
	meta:
		name = "?InitializeCookie@Security@details@Concurrency@@SAKXZ"
		size = 78
		refs = "000a ?s_cookie@Security@details@Concurrency@@2KA 0010 ?s_initialized@Security@details@Concurrency@@2JC 001a __imp__EncodePointer@4 0022 ___security_cookie 0032 __imp__GetCurrentThread@0 0039 __imp__GetThreadTimes@20"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 8B F0 33 35 ?? ?? ?? ?? 8D 45 F8 50 50 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 08 8B 45 F4 33 45 F0 33 F0 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_95_31_0 {
	meta:
		name = "??$ConcRT_FillBuffer@$0EAB@@details@Concurrency@@YAXAAY0EAB@_WPB_WPAD@Z"
		size = 176
		refs = "000b ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 001b ?GetScheduler@ContextBase@details@Concurrency@@QBEPAVSchedulerBase@23@XZ 0025 __imp__GetCurrentThreadId@0 002d ?ScheduleGroupRefCount@ContextBase@details@Concurrency@@QBEIXZ 004a ??_C@_1CG@CBCHDCDB@?$AA?$FL?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?3?$AA?$CF?$AAd?$AA?$CI?$AA?$CF?$AAd?$AA?$CJ?$AA?$FN?$AA?5?$AA?$AA@ 0055 _swprintf_s 0077 _vswprintf_s 007d _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 FF E8 ?? ?? ?? ?? 8B 5D 08 8B F0 85 F6 74 4C 8B CE E8 ?? ?? ?? ?? 85 C0 74 41 FF 15 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 50 8B 06 8B CE FF 50 08 50 8B 06 8B CE FF 10 50 8B 06 8B CE FF 50 04 50 68 ?? ?? ?? ?? 68 01 04 00 00 53 E8 ?? ?? ?? ?? 8B F8 83 C4 20 85 FF 79 02 33 FF FF 75 10 B8 01 04 00 00 FF 75 0C 2B C7 50 8D 04 7B 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 7E 23 8D 0C 43 66 83 79 FE 0A 74 19 6A 0A 3D 00 04 00 00 58 73 0B 66 89 01 33 C0 66 89 41 02 EB 04 66 89 41 FE 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_95_32_0 {
	meta:
		name = "?_ConcRT_DumpMessage@details@Concurrency@@YAXPB_WZZ"
		size = 97
		refs = "000c ___security_cookie 0024 ??$ConcRT_FillBuffer@$0EAB@@details@Concurrency@@YAXAAY0EAB@_WPB_WPAD@Z 003a __imp__OutputDebugStringW@4 0046 ___iob_func 004f _fwprintf 005b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 08 08 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8D 45 0C 50 FF 75 08 8D 85 F8 F7 FF FF 50 E8 ?? ?? ?? ?? 33 C0 66 89 45 F8 83 C4 0C 8D 85 F8 F7 FF FF 50 FF 15 ?? ?? ?? ?? 8D 85 F8 F7 FF FF 50 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 59 59 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_95_33_0 {
	meta:
		name = "?_ConcRT_Trace@details@Concurrency@@YAXHPB_WZZ"
		size = 169
		refs = "000c ___security_cookie 0016 _g_DesiredTraceLevel 002e ??$ConcRT_FillBuffer@$0EAB@@details@Concurrency@@YAXAAY0EAB@_WPB_WPAD@Z 0039 _g_DebugOutFilePtr 004d _fwprintf 0052 _g_CommitFrequency 0061 _g_TraceCount 006c __aullrem 0089 _fflush 0099 __imp__OutputDebugStringW@4 00a3 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 08 08 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC A1 ?? ?? ?? ?? 85 45 08 74 7E 8D 45 10 50 FF 75 0C 8D 85 F8 F7 FF FF 50 E8 ?? ?? ?? ?? 33 C0 66 89 45 F8 A1 ?? ?? ?? ?? 83 C4 0C 85 C0 74 4C 8D 8D F8 F7 FF FF 51 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 59 59 85 C0 7E 41 99 52 50 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 05 ?? ?? ?? ?? 01 83 15 ?? ?? ?? ?? 00 0B C2 75 1B FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 EB 0D 8D 85 F8 F7 FF FF 50 FF 15 ?? ?? ?? ?? 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_95_36_0 {
	meta:
		name = "?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 53
		refs = "001b ?_Sleep0@details@Concurrency@@YAXXZ 0023 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 56 8B F1 40 87 01 85 C0 74 1E 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 33 C0 40 8B CE 87 01 85 C0 75 ED 5E C9 C3 }
	condition:
		$1
}

rule file_95_37_0 {
	meta:
		name = "?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 18
		refs = "0006 ?StaticEnterHyperCriticalRegion@ContextBase@details@Concurrency@@SAXXZ 000e ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_38_0 {
	meta:
		name = "?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
		size = 18
		refs = "0006 ?StaticEnterCriticalRegion@ContextBase@details@Concurrency@@SAXXZ 000e ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_39_0 {
	meta:
		name = "??0_SpinLock@details@Concurrency@@QAE@ACJ@Z"
		size = 72
		refs = "0026 ?_UnderlyingYield@details@Concurrency@@YAXXZ 002e ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 10 56 8B F1 33 C9 89 06 8B D0 41 33 C0 F0 0F B1 0A 85 C0 74 22 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 16 33 C9 41 33 C0 F0 0F B1 0A 85 C0 75 E9 8B C6 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_96_4_0 {
	meta:
		name = "___check_float_string"
		size = 90
		refs = "0017 __calloc_crt 003b _memcpy 0046 __recalloc_crt"
	strings:
		$1 = { 8B FF 55 8B EC 8B 06 39 45 08 75 49 8B 0F 6A 04 50 3B 4D 0C 75 2E E8 ?? ?? ?? ?? 59 59 89 07 85 C0 75 04 33 C0 5D C3 8B 45 10 C7 00 01 00 00 00 8B 06 03 C0 50 FF 75 0C FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D2 89 07 D1 26 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_96_5_0 {
	meta:
		name = "__INTRN_LOCALE_CONV"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 8B 80 BC 00 00 00 5D C3 }
	condition:
		$1
}

rule file_96_6_0 {
	meta:
		name = "__hextodec"
		size = 54
		refs = "001c _isdigit"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 08 00 FF 00 00 56 75 1A 0F B7 75 08 8B C6 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 59 85 C0 74 04 8B C6 EB 0A 0F B7 45 08 83 E0 DF 83 E8 07 5E 5D C3 }
	condition:
		$1
}

rule file_96_8_0 {
	meta:
		name = "__un_inc"
		size = 24
		refs = "0012 __ungetwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 66 3B 45 08 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_245_8_0 {
	meta:
		name = "__un_inc"
		size = 24
		refs = "0012 __ungetwc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 66 3B 45 08 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_96_9_0 {
	meta:
		name = "__whiteout"
		size = 42
		refs = "0006 __getwche_nolock 001b _iswctype"
	strings:
		$1 = { 8B FF 57 FF 06 E8 ?? ?? ?? ?? 0F B7 F8 B8 FF FF 00 00 66 3B F8 74 0E 6A 08 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 DE 66 8B C7 5F C3 }
	condition:
		$1
}

rule file_96_10_0 {
	meta:
		name = "__cprinput_l"
		size = 4015
		refs = "000c ___security_cookie 0057 __errno 0062 __invalid_parameter_noinfo 0078 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00a2 _iswctype 00b9 __whiteout 00c2 __un_inc 015e _isdigit 02e8 __getwche_nolock 0462 ___check_float_string 0773 __malloc_crt 0792 _wcstombs_s 07c8 __cfltcvt_tab 07ce __imp__DecodePointer@4 07d6 _free 0989 _memset 0b73 _wctomb_s 0cef __allmul 0d0e _isxdigit 0d38 __hextodec 0f4d __invoke_watson 0fa9 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 56 57 33 FF 8B F1 89 85 E8 FC FF FF 8D 85 40 FD FF FF 89 85 24 FD FF FF C7 85 F4 FC FF FF 5E 01 00 00 89 BD FC FC FF FF 89 BD EC FC FF FF 89 BD E4 FC FF FF 89 BD 34 FD FF FF 3B F7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 33 0F 00 00 FF 75 08 8D 8D CC FC FF FF E8 ?? ?? ?? ?? 0F B7 06 C6 85 2B FD FF FF 00 89 BD 38 FD FF FF 89 BD F8 FC FF FF 66 3B C7 0F 84 ED 0E 00 00 8B FE 53 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 34 FF 8D 38 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 59 83 C7 02 0F B7 07 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EC E9 59 0E 00 00 0F B7 07 6A 25 59 66 3B C8 0F 85 2B 0E 00 00 66 3B 4F 02 0F 84 13 0E 00 00 33 C0 89 85 0C FD FF FF 89 85 DC FC FF FF 89 85 1C FD FF FF 89 85 08 FD FF FF 89 85 30 FD FF FF 88 85 13 FD FF FF 88 85 2A FD FF FF 88 85 2E FD FF FF 88 85 3F FD FF FF 88 85 2C FD FF FF 88 85 2F FD FF FF C6 85 2D FD FF FF 01 89 85 F0 FC FF FF BE 00 FF 00 00 83 C7 02 0F B7 1F 85 DE 75 2C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 30 FD FF FF FF 85 08 FD FF FF 6B C0 0A 8D 44 18 D0 89 85 30 FD FF FF E9 CC 00 00 00 83 FB 4E 0F 8F 86 00 00 00 0F 84 BD 00 00 00 83 FB 2A 74 73 83 FB 46 0F 84 AF 00 00 00 83 FB 49 74 10 83 FB 4C 75 77 FE 85 2D FD FF FF E9 9A 00 00 00 0F B7 4F 02 83 F9 36 75 20 66 83 7F 04 34 75 19 83 C7 04 FF 85 F0 FC FF FF 83 A5 14 FD FF FF 00 83 A5 18 FD FF FF 00 EB 71 83 F9 33 75 0C 66 83 7F 04 32 75 05 83 C7 04 EB 60 83 F9 64 74 5B 83 F9 69 74 56 83 F9 6F 74 51 83 F9 78 74 4C 83 F9 58 75 19 EB 45 FE 85 2E FD FF FF EB 3D 83 FB 68 74 2C 83 FB 6C 74 0D 83 FB 77 74 1A FE 85 3F FD FF FF EB 26 66 83 7F 02 6C 75 05 83 C7 02 EB 93 FE 85 2D FD FF FF FE 85 2F FD FF FF EB 0C FE 8D 2D FD FF FF FE 8D 2F FD FF FF 80 BD 3F FD FF FF 00 0F 84 F1 FE FF FF 80 BD 2E FD FF FF 00 89 BD 00 FD FF FF 75 19 8B 85 E8 FC FF FF 8B 18 89 85 E0 FC FF FF 83 C0 04 89 85 E8 FC FF FF EB 02 33 DB 80 BD 2F FD FF FF 00 89 9D 04 FD FF FF C6 85 3F FD FF FF 00 75 1B 0F B7 07 83 F8 53 74 0C C6 85 2F FD FF FF 01 83 F8 43 75 07 C6 85 2F FD FF FF FF 0F B7 07 83 C8 20 89 85 20 FD FF FF 83 F8 6E 74 54 83 F8 63 74 12 83 F8 7B 74 0D 8D B5 38 FD FF FF E8 ?? ?? ?? ?? EB 0B FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF B8 FF FF 00 00 66 3B 85 34 FD FF FF 0F 84 56 0C 00 00 8B 9D 04 FD FF FF 8B BD 00 FD FF FF 8B 85 20 FD FF FF BE 00 FF 00 00 8B 95 08 FD FF FF 85 D2 74 0D 83 BD 30 FD FF FF 00 0F 84 1C 0C 00 00 83 F8 6F 0F 8F 92 05 00 00 0F 84 CE 08 00 00 83 F8 63 0F 84 95 04 00 00 6A 64 59 3B C1 0F 84 BA 08 00 00 0F 8E 9A 05 00 00 83 F8 67 7E 48 83 F8 69 74 21 83 F8 6E 0F 85 87 05 00 00 80 BD 2E FD FF FF 00 8B BD 38 FD FF FF 0F 84 4B 0B 00 00 E9 72 0B 00 00 89 8D 20 FD FF FF 6A 2D 58 66 3B 85 34 FD FF FF 0F 85 CB 06 00 00 C6 85 2A FD FF FF 01 E9 CB 06 00 00 6A 2D 58 33 DB 66 3B 85 34 FD FF FF 75 0C 8B 8D 24 FD FF FF 66 89 01 43 EB 0C 6A 2B 58 66 3B 85 34 FD FF FF 75 1A FF 8D 30 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF 83 BD 08 FD FF FF 00 75 07 83 8D 30 FD FF FF FF F7 85 34 FD FF FF 00 FF 00 00 0F 85 85 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 73 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 63 66 0F BE 85 34 FD FF FF 8B 8D 24 FD FF FF FF 85 1C FD FF FF 66 89 04 59 8D 85 FC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 F4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 EC 0A 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF A9 00 FF 00 00 0F 84 7B FF FF FF 8B 85 CC FC FF FF 8B 80 BC 00 00 00 8B 40 30 0F B7 30 0F BE 8D 34 FD FF FF 8B C6 3B C1 0F 85 EE 00 00 00 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 DA 00 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF 8B 85 24 FD FF FF 66 89 34 58 8D 85 FC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 F4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 4C 0A 00 00 F7 85 34 FD FF FF 00 FF 00 00 0F 85 80 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 5E 8B 85 24 FD FF FF 66 8B 8D 34 FD FF FF FF 85 1C FD FF FF 66 89 0C 58 8D 85 FC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 F4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 D7 09 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF A9 00 FF 00 00 74 80 83 BD 1C FD FF FF 00 0F 84 7B 01 00 00 6A 65 58 66 3B 85 34 FD FF FF 74 10 6A 45 58 66 3B 85 34 FD FF FF 0F 85 5F 01 00 00 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 4B 01 00 00 8B 8D 24 FD FF FF 6A 65 58 66 89 04 59 8D 85 FC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 F4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 46 09 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 6A 2D 59 89 85 34 FD FF FF 66 3B C8 75 2E 51 8B 8D 24 FD FF FF 58 66 89 04 59 8D 85 FC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 FE 08 00 00 EB 0C 6A 2B 58 66 3B 85 34 FD FF FF 75 2C 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 75 08 21 85 30 FD FF FF EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF F7 85 34 FD FF FF 00 FF 00 00 0F 85 80 00 00 00 0F B6 85 34 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 5E 8B 85 24 FD FF FF 66 8B 8D 34 FD FF FF FF 85 1C FD FF FF 66 89 0C 58 8D 85 FC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 24 FD FF FF 8D B5 F4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 4F 08 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF A9 00 FF 00 00 74 80 FF B5 34 FD FF FF FF 8D 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 1C FD FF FF 00 59 0F 84 15 08 00 00 80 BD 2E FD FF FF 00 0F 85 A6 07 00 00 8B B5 F4 FC FF FF 8B 8D 24 FD FF FF FF 85 F8 FC FF FF 33 C0 8D 74 36 02 56 66 89 04 59 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 84 DB 07 00 00 8D 46 FF 50 FF B5 24 FD FF FF 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 12 83 F8 16 0F 84 A1 07 00 00 83 F8 22 0F 84 98 07 00 00 8D 85 CC FC FF FF 50 0F BE 85 2D FD FF FF 57 FF B5 04 FD FF FF 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 19 07 00 00 85 D2 75 10 FF 85 30 FD FF FF C7 85 08 FD FF FF 01 00 00 00 80 BD 2F FD FF FF 00 7E 07 C6 85 2C FD FF FF 01 FF B5 34 FD FF FF FF 8D 38 FD FF FF 8B F3 E8 ?? ?? ?? ?? 59 33 FF 39 BD 08 FD FF FF 74 14 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 84 03 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 20 FD FF FF 63 0F B7 D0 89 95 34 FD FF FF 74 56 83 BD 20 FD FF FF 73 75 13 83 FA 09 72 09 83 FA 0D 0F 86 43 03 00 00 83 FA 20 75 3A 83 BD 20 FD FF FF 7B 0F 85 31 03 00 00 0F B7 C2 8B C8 33 FF 83 E1 07 47 D3 E7 8B 8D EC FC FF FF C1 E8 03 0F BE 04 08 0F BE 8D 13 FD FF FF 33 C1 85 F8 0F 84 06 03 00 00 33 FF 80 BD 2E FD FF FF 00 0F 85 EF 02 00 00 80 BD 2C FD FF FF 00 0F 84 9C 02 00 00 66 89 13 83 C3 02 E9 CC 02 00 00 83 E8 70 0F 84 32 03 00 00 83 E8 03 0F 84 14 FF FF FF 48 48 0F 84 28 03 00 00 83 E8 03 0F 84 9C FA FF FF 83 E8 03 74 34 66 8B 85 34 FD FF FF 66 39 07 0F 85 49 06 00 00 FE 8D 2B FD FF FF 80 BD 2E FD FF FF 00 0F 85 E0 05 00 00 8B 85 E0 FC FF FF 89 85 E8 FC FF FF E9 CF 05 00 00 80 BD 2F FD FF FF 00 7E 07 C6 85 2C FD FF FF 01 6A 5E 83 C7 02 58 66 3B 07 75 0A 83 C7 02 C6 85 13 FD FF FF FF 8B B5 EC FC FF FF 85 F6 75 25 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 EC FC FF FF 85 C0 0F 84 E9 05 00 00 C7 85 E4 FC FF FF 01 00 00 00 8B F0 68 00 20 00 00 6A 00 56 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 58 66 3B 07 75 0E 50 5A 83 C7 02 C6 46 0B 20 E9 9A 00 00 00 8B 95 DC FC FF FF E9 8F 00 00 00 0F B7 C0 6A 2D 59 83 C7 02 66 3B C8 75 70 66 85 D2 74 6B 0F B7 0F 6A 5D 5B 66 3B D9 74 60 8B C1 83 C7 02 66 3B D0 73 02 EB 05 0F B7 CA 8B D0 89 8D 0C FD FF FF 66 3B D1 73 2A 8B C1 2B C2 0F B7 C0 0F B7 DA 89 85 00 FD FF FF 8B CB 83 E1 07 B2 01 D2 E2 8B C3 C1 E8 03 08 14 30 43 FF 8D 00 FD FF FF 75 E6 0F B7 8D 0C FD FF FF 8B C1 83 E1 07 B2 01 D2 E2 C1 E8 03 08 14 30 33 D2 EB 11 8B C8 83 E1 07 B3 01 D2 E3 8B D0 C1 E8 03 08 1C 30 0F B7 07 6A 5D 59 66 3B C8 0F 85 62 FF FF FF 66 83 3F 00 0F 84 04 05 00 00 8B 9D 04 FD FF FF 89 BD 00 FD FF FF E9 9C FD FF FF 6A 2B 58 66 3B 85 34 FD FF FF 75 29 FF 8D 30 FD FF FF 75 0D 85 D2 74 09 C6 85 3F FD FF FF 01 EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF 6A 30 5B 66 3B 9D 34 FD FF FF 0F 85 AD 01 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 6A 78 5F 89 85 34 FD FF FF 66 3B F8 74 58 6A 58 59 66 3B C8 74 50 C7 85 1C FD FF FF 01 00 00 00 39 BD 20 FD FF FF 74 26 83 BD 08 FD FF FF 00 74 0E FF 8D 30 FD FF FF 75 06 FE 85 3F FD FF FF C7 85 20 FD FF FF 6F 00 00 00 E9 51 01 00 00 FF 8D 38 FD FF FF 50 E8 ?? ?? ?? ?? 59 89 9D 34 FD FF FF E9 39 01 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 08 FD FF FF 00 0F B7 C0 89 85 34 FD FF FF 74 16 83 AD 30 FD FF FF 02 83 BD 30 FD FF FF 01 7D 06 FE 85 3F FD FF FF 89 BD 20 FD FF FF E9 FB 00 00 00 52 6A 05 8D 85 0C FD FF FF 53 50 89 BD 0C FD FF FF E8 ?? ?? ?? ?? 83 C4 10 3B C7 74 18 83 F8 16 74 09 83 F8 22 0F 85 90 FC FF FF 57 57 57 57 57 E9 B6 03 00 00 03 9D 0C FD FF FF 89 9D 04 FD FF FF E9 75 FC FF FF 83 C6 02 E9 6D FC FF FF FF 8D 38 FD FF FF 52 E8 ?? ?? ?? ?? 59 3B F3 0F 84 99 03 00 00 80 BD 2E FD FF FF 00 0F 85 2A 03 00 00 FF 85 F8 FC FF FF 83 BD 20 FD FF FF 63 0F 84 17 03 00 00 80 BD 2C FD FF FF 00 74 10 8B 8D 04 FD FF FF 33 C0 66 89 01 E9 FE 02 00 00 8B 85 04 FD FF FF C6 00 00 E9 F0 02 00 00 C6 85 2D FD FF FF 01 6A 2D 58 66 3B 85 34 FD FF FF 75 09 C6 85 2A FD FF FF 01 EB 0C 6A 2B 58 66 3B 85 34 FD FF FF 75 29 FF 8D 30 FD FF FF 75 0D 85 D2 74 09 C6 85 3F FD FF FF 01 EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 34 FD FF FF 83 BD F0 FC FF FF 00 0F 84 64 01 00 00 80 BD 3F FD FF FF 00 0F 85 20 01 00 00 8B 9D 34 FD FF FF 83 BD 20 FD FF FF 78 74 7C 83 BD 20 FD FF FF 70 74 73 85 DE 0F 85 F3 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 E1 00 00 00 83 BD 20 FD FF FF 6F 75 2D 6A 38 58 66 3B C3 0F 86 CC 00 00 00 8B 85 14 FD FF FF 8B 8D 18 FD FF FF 0F A4 C1 03 C1 E0 03 89 85 14 FD FF FF 89 8D 18 FD FF FF EB 68 6A 00 6A 0A FF B5 18 FD FF FF FF B5 14 FD FF FF E8 ?? ?? ?? ?? 89 85 14 FD FF FF 89 95 18 FD FF FF EB 45 85 DE 0F 85 80 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 72 8B 85 14 FD FF FF 8B 8D 18 FD FF FF 0F A4 C1 04 C1 E0 04 53 89 85 14 FD FF FF 89 8D 18 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF FF 85 1C FD FF FF 0F B7 C3 83 E8 30 99 01 85 14 FD FF FF 11 95 18 FD FF FF 83 BD 08 FD FF FF 00 74 08 FF 8D 30 FD FF FF 74 26 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 34 FD FF FF E9 F3 FE FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 2A FD FF FF 00 8B BD 0C FD FF FF 0F 84 F4 00 00 00 8B 85 14 FD FF FF 8B 8D 18 FD FF FF F7 D8 83 D1 00 F7 D9 89 85 14 FD FF FF 89 8D 18 FD FF FF E9 D0 00 00 00 80 BD 3F FD FF FF 00 8B BD 0C FD FF FF 0F 85 B2 00 00 00 8B 9D 34 FD FF FF 83 BD 20 FD FF FF 78 74 3A 83 BD 20 FD FF FF 70 74 31 85 DE 0F 85 85 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 77 83 BD 20 FD FF FF 6F 75 0D 6A 38 58 66 3B C3 76 66 C1 E7 03 EB 2A 6B FF 0A EB 25 85 DE 75 58 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 4A 53 C1 E7 04 E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 34 FD FF FF FF 85 1C FD FF FF 83 BD 08 FD FF FF 00 0F B7 C3 8D 7C 07 D0 74 08 FF 8D 30 FD FF FF 74 26 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 34 FD FF FF E9 61 FF FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 2A FD FF FF 00 74 02 F7 DF 83 BD 20 FD FF FF 46 75 07 83 A5 1C FD FF FF 00 83 BD 1C FD FF FF 00 0F 84 A3 00 00 00 80 BD 2E FD FF FF 00 75 38 FF 85 F8 FC FF FF 8B 9D 04 FD FF FF 83 BD F0 FC FF FF 00 74 13 8B 85 14 FD FF FF 89 03 8B 85 18 FD FF FF 89 43 04 EB 10 80 BD 2D FD FF FF 00 74 04 89 3B EB 03 66 89 3B 8B BD 00 FD FF FF FE 85 2B FD FF FF 83 C7 02 EB 2D 66 3B C8 75 09 66 3B 4F 02 75 03 83 C7 02 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 66 8B 0F 0F B7 C0 83 C7 02 89 85 34 FD FF FF 66 3B C8 75 18 0F B7 07 66 85 C0 0F 85 59 F1 FF FF EB 16 56 56 56 56 56 E8 ?? ?? ?? ?? FF B5 34 FD FF FF E8 ?? ?? ?? ?? 59 83 BD E4 FC FF FF 01 5B 75 0C FF B5 EC FC FF FF E8 ?? ?? ?? ?? 59 83 BD FC FC FF FF 01 75 0C FF B5 24 FD FF FF E8 ?? ?? ?? ?? 59 80 BD D8 FC FF FF 00 74 0A 8B 85 D4 FC FF FF 83 60 70 FD 8B 85 F8 FC FF FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_96_11_0 {
	meta:
		name = "__cwscanf"
		size = 23
		refs = "000f __cprinput_l"
		altNames = "__cscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 0C 50 6A 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_826_10_0 {
	meta:
		name = "__cscanf_s"
		size = 23
		refs = "000f __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 0C 50 6A 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_283_11_0 {
	meta:
		name = "__cwscanf_s"
		size = 23
		refs = "000f __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 0C 50 6A 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_96_12_0 {
	meta:
		name = "__cwscanf_l"
		size = 24
		refs = "0010 __cprinput_l"
		altNames = "__cscanf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 10 50 FF 75 0C E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_826_11_0 {
	meta:
		name = "__cscanf_s_l"
		size = 24
		refs = "0010 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 10 50 FF 75 0C E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_283_12_0 {
	meta:
		name = "__cwscanf_s_l"
		size = 24
		refs = "0010 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 45 10 50 FF 75 0C E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__chkstk"
		size = 43
	strings:
		$1 = { 51 8D 4C 24 04 2B C8 1B C0 F7 D0 23 C8 8B C4 25 00 F0 FF FF 3B C8 72 0A 8B C1 59 94 8B 00 89 04 24 C3 2D 00 10 00 00 85 00 EB E9 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__dospawn"
		size = 516
		refs = "0037 ___doserrno 003e __errno 0049 __invalid_parameter_noinfo 0072 _memset 007b __nhandle 0093 ___pioinfo 00d0 __calloc_crt 0180 __imp__CreateProcessA@40 0188 __imp__GetLastError@0 0192 _free 019d __dosmaperr 01ac __exit 01b2 __imp__CloseHandle@4 01c2 __imp__WaitForSingleObject@8 01cf __imp__GetExitCodeProcess@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 68 8B 45 08 53 33 DB 57 89 5D F4 88 5D FF 3B C3 74 15 83 F8 01 74 10 7E 16 83 F8 03 7E 09 83 F8 04 75 0C C6 45 FF 01 8B 45 10 89 45 F0 EB 2D E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 AB 01 00 00 40 38 18 75 FB 38 58 01 74 04 C6 00 20 40 38 18 75 EE 56 6A 44 5E 56 8D 45 98 53 50 E8 ?? ?? ?? ?? 89 75 98 8B 35 ?? ?? ?? ?? 83 C4 0C 3B F3 74 2B 8D 46 FF 8B C8 8B D0 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E2 1F C1 E2 06 38 5C 11 04 75 06 4E 48 3B F3 75 E0 3B F3 0F 8C 40 01 00 00 81 FE 32 33 00 00 0F 83 34 01 00 00 8B C6 6B C0 05 83 C0 04 66 89 45 CA 0F B7 C0 6A 01 50 E8 ?? ?? ?? ?? 59 59 89 45 CC 3B C3 0F 84 10 01 00 00 89 30 8B 45 CC 8D 48 04 8D 7C 30 04 89 5D F8 3B F3 7E 39 8B 45 F8 8B D0 83 E0 1F C1 FA 05 C1 E0 06 03 04 95 ?? ?? ?? ?? 8A 50 04 F6 C2 10 75 08 88 11 8B 00 89 07 EB 05 88 19 83 0F FF FF 45 F8 41 83 C7 04 39 75 F8 7C CA 8B 45 CC 38 5D FF 74 2C 8D 48 04 33 D2 8D 44 30 04 83 FE 03 7D 04 8B FE EB 03 6A 03 5F 3B D7 7D 0C 88 19 83 08 FF 42 41 83 C0 04 EB E4 C7 45 F4 08 00 00 00 E8 ?? ?? ?? ?? 89 18 8D 45 DC 50 8D 45 98 50 53 FF 75 14 FF 75 F4 6A 01 53 53 FF 75 F0 FF 75 0C FF 15 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? FF 75 CC 8B F8 E8 ?? ?? ?? ?? 59 3B F3 75 09 57 E8 ?? ?? ?? ?? 59 EB 58 83 7D 08 02 75 06 53 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 39 5D 08 75 1D 6A FF FF 75 DC FF 15 ?? ?? ?? ?? 8D 45 EC 50 FF 75 DC FF 15 ?? ?? ?? ?? 8B 5D EC EB 06 83 7D 08 04 75 07 FF 75 DC FF D6 EB 03 8B 5D DC FF 75 E0 FF D6 8B C3 EB 0E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 C8 FF 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__fseeki64_nolock"
		size = 156
		refs = "002f __ftelli64_nolock 003e __flush 0071 __fileno 0078 __lseeki64 008b __errno"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8B 46 0C 57 A8 83 74 79 8B 7D 14 85 FF 74 0A 83 FF 01 74 05 83 FF 02 75 68 83 E0 EF 89 46 0C 83 FF 01 75 0F 56 E8 ?? ?? ?? ?? 01 45 0C 59 11 55 10 33 FF 56 E8 ?? ?? ?? ?? 8B 46 0C 59 84 C0 79 08 83 E0 FC 89 46 0C EB 16 A8 01 74 12 A8 08 74 0E A9 00 04 00 00 75 07 C7 46 18 00 02 00 00 57 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 74 0F 33 C0 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 5E 5D C3 }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "__fseeki64"
		size = 127
		refs = "0003 __sehtable$__fseeki64 0008 __SEH_prolog4 0019 __errno 0024 __invalid_parameter_noinfo 0042 __lock_file 0056 __fseeki64_nolock 0070 __SEH_epilog4 0079 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 08 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 42 8B 75 14 85 F6 74 0A 83 FE 01 74 05 83 FE 02 75 DA FF 75 08 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "__wfindfirst32i64"
		size = 306
		refs = "000c ___security_cookie 0024 __errno 002f __invalid_parameter_noinfo 003e @__security_check_cookie@4 0056 __imp__FindFirstFileExW@24 0067 __imp__GetLastError@0 00c2 ___timet_from_ft 0110 _wcscpy_s 012d __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 58 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 3B C7 74 DB 57 57 57 8D 8D AC FD FF FF 51 57 50 FF 15 ?? ?? ?? ?? 89 85 A8 FD FF FF 83 F8 FF 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB A5 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 98 E8 ?? ?? ?? ?? 89 30 EB 8F 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 53 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 0C 33 C0 33 DB 03 85 CC FD FF FF 89 46 10 13 CB 8D 85 D8 FD FF FF 50 89 4E 14 68 04 01 00 00 83 C6 18 56 E8 ?? ?? ?? ?? 83 C4 18 5B 85 C0 75 0B 8B 85 A8 FD FF FF E9 0F FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_102_2_0 {
	meta:
		name = "__wfindnext32i64"
		size = 310
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 005b __imp__FindNextFileW@8 0065 __imp__GetLastError@0 0095 @__security_check_cookie@4 00ce ___timet_from_ft 011c _wcscpy_s 0131 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 83 CB FF 56 8B 75 0C 3B C3 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 55 57 33 FF 3B F7 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 39 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 4E FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 33 83 F8 08 74 21 83 F8 12 74 29 E8 ?? ?? ?? ?? C7 00 16 00 00 00 8B C3 5F 8B 4D FC 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E2 E8 ?? ?? ?? ?? 89 30 EB D9 8B 85 AC FD FF FF 83 C0 80 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 8B 8D C8 FD FF FF 89 46 0C 33 C0 33 DB 03 85 CC FD FF FF 89 46 10 13 CB 8D 85 D8 FD FF FF 50 89 4E 14 68 04 01 00 00 83 C6 18 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 61 FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_103_1_0 {
	meta:
		name = "_wcomexecmd"
		size = 114
		refs = "000e __errno 0019 __invalid_parameter_noinfo 003a __wcenvarg 0054 __wdospawn 005e _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 7D 0C 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF C9 C3 83 7D 10 00 74 E5 FF 75 0C 8D 45 F8 50 8D 45 FC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D7 56 FF 75 F8 FF 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_537_1_0 {
	meta:
		name = "_comexecmd"
		size = 114
		refs = "000e __errno 0019 __invalid_parameter_noinfo 003a __cenvarg 0054 __dospawn 005e _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 7D 0C 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF C9 C3 83 7D 10 00 74 E5 FF 75 0C 8D 45 F8 50 8D 45 FC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D7 56 FF 75 F8 FF 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_103_2_0 {
	meta:
		name = "__wspawnve"
		size = 494
		refs = "0014 __errno 001f __invalid_parameter_noinfo 004a _wcsrchr 0067 _wcschr 0075 _wcslen 0080 __calloc_crt 0095 ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 009c _wcscpy_s 00ab _wcscat_s 00c3 __invoke_watson 00e9 __waccess_s 0104 _wcomexecmd 0172 _ext_strings 01c6 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 0C 89 5D FC 85 DB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 0B 01 00 00 66 83 3B 00 74 E2 8B 45 10 85 C0 74 DB 8B 00 85 C0 74 D5 66 83 38 00 74 CF 56 57 6A 5C 53 E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 68 85 F6 75 6E 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 5E 53 E8 ?? ?? ?? ?? 8D 70 03 6A 02 56 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 89 7D FC 85 FF 0F 84 9D 00 00 00 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 14 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 05 8D 77 04 EB 16 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 85 F6 74 04 3B C6 76 02 8B F0 83 4D F4 FF 6A 2E 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 30 6A 00 FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 D7 00 00 00 FF 75 14 FF 75 10 FF 75 FC FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 E9 BB 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 8D 70 05 6A 02 56 E8 ?? ?? ?? ?? 8B F8 33 DB 83 C4 0C 3B FB 75 08 83 C8 FF 5F 5E 5B C9 C3 FF 75 FC 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 96 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 8D 04 47 59 89 45 F0 E8 ?? ?? ?? ?? 8B 18 8B 45 F0 2B C7 89 75 F8 D1 F8 29 45 F8 BE ?? ?? ?? ?? FF 36 FF 75 F8 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 2D FF FF FF 50 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 0D 83 EE 04 81 FE ?? ?? ?? ?? 7D D0 EB 1C E8 ?? ?? ?? ?? FF 75 14 89 18 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 57 E8 ?? ?? ?? ?? 8B 5D 0C 59 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 E9 50 FF FF FF 53 53 53 53 53 E9 D4 FE FF FF }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "___libm_sse2_exp"
		size = 534
		refs = "000b _cv 0013 _Shifter 0096 _Tbl_addr 00ba _mmask 00c6 _bias 0124 _emask 0193 _XMAX 01a3 _XMIN 01d1 _INF 01dd _ZERO 0211 _ONE_val"
	strings:
		$1 = { 83 EC 0C 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F C5 C0 03 25 FF 7F 00 00 BA 8F 40 00 00 2B D0 2D 90 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 9F 01 00 00 66 0F 59 C8 66 0F 58 CE 66 0F 28 F9 66 0F 5C CE 66 0F 59 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 7E F8 8B C8 83 E1 3F C1 E1 04 C1 F8 06 8B D0 66 0F 5C C3 66 0F 28 91 ?? ?? ?? ?? 66 0F 59 E0 66 0F 28 C8 66 0F 59 C0 66 0F 58 EC F2 0F 59 C0 F2 0F 58 CA 66 0F 15 D2 66 0F 6F 35 ?? ?? ?? ?? 66 0F DB FE 66 0F 6F 35 ?? ?? ?? ?? 66 0F D4 FE 66 0F 73 F7 2E 66 0F 59 C5 F2 0F 58 C8 66 0F 56 D7 66 0F 15 C0 F2 0F 58 C1 81 C2 7E 03 00 00 81 FA 7C 07 00 00 77 0C 83 C4 0C F2 0F 59 C2 F2 0F 58 C2 C3 83 EC 12 9B D9 7C 24 10 66 8B 54 24 10 66 81 CA 00 03 66 89 14 24 D9 2C 24 8B D0 D1 F8 2B D0 66 0F 6F 35 ?? ?? ?? ?? 66 0F DF F2 05 FF 03 00 00 66 0F 6E D8 66 0F 73 F3 34 66 0F 56 F3 81 C2 FF 03 00 00 66 0F 6E E2 66 0F 73 F4 34 66 0F 13 04 24 DD 04 24 66 0F 13 74 24 08 DD 44 24 08 DC C9 DE C1 66 0F 13 24 24 DD 04 24 DE C9 DD 1C 24 66 0F 12 04 24 D9 6C 24 10 83 C4 1E C3 3D 00 00 F0 7F 73 2B 8B 44 24 08 3D 00 00 00 80 73 10 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 59 C0 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 59 C0 C3 8B 54 24 04 3D 00 00 F0 7F 77 28 83 FA 00 75 23 8B 44 24 08 3D 00 00 F0 7F 75 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 8B 44 24 08 25 FF FF FF 7F 3D 00 00 90 40 0F 83 79 FF FF FF 66 0F 12 44 24 04 83 C4 0C F2 0F 58 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_106_3_0 {
	meta:
		name = "__towlower_l"
		size = 160
		refs = "0020 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0056 _iswctype 007d ___crtLCMapStringW"
	strings:
		$1 = { 8B FF 55 8B EC B8 FF FF 00 00 83 EC 14 66 39 45 08 0F 84 87 00 00 00 53 56 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 75 EC 8B 4E 14 33 DB 3B CB 75 15 8B 45 08 8D 48 BF 66 83 F9 19 77 04 66 83 C0 20 0F B7 C0 EB 4B B8 00 01 00 00 6A 01 66 39 45 08 73 1E FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 0F B7 45 08 59 74 2C 8B 8E CC 00 00 00 0F B6 04 01 EB 20 8D 55 FC 52 6A 01 8D 55 08 52 50 51 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F B7 45 08 74 04 0F B7 45 FC 38 5D F8 74 07 8B 4D F4 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "?Id@CurrentScheduler@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 04 83 C8 FF C3 }
	condition:
		$1
}

rule file_627_6_0 {
	meta:
		name = "?VirtualProcessorId@Context@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 04 83 C8 FF C3 }
	condition:
		$1
}

rule file_107_2_0 {
	meta:
		name = "?GetNumberOfVirtualProcessors@CurrentScheduler@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 08 83 C8 FF C3 }
	condition:
		$1
}

rule file_627_7_0 {
	meta:
		name = "?ScheduleGroupId@Context@Concurrency@@SAIXZ"
		size = 20
		refs = "0001 ?SafeFastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 8B 10 8B C8 FF 62 08 83 C8 FF C3 }
	condition:
		$1
}

rule file_107_3_0 {
	meta:
		name = "?GetPolicy@CurrentScheduler@Concurrency@@SA?AVSchedulerPolicy@2@XZ"
		size = 30
		refs = "000b ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 E8 ?? ?? ?? ?? FF 75 08 8B 10 8B C8 FF 52 0C 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_107_5_0 {
	meta:
		name = "?Create@CurrentScheduler@Concurrency@@SAXABVSchedulerPolicy@2@@Z"
		size = 22
		refs = "0009 ?Create@SchedulerBase@details@Concurrency@@SAPAV123@ABVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 8B 10 59 8B C8 5D FF 62 1C }
	condition:
		$1
}

rule file_107_6_0 {
	meta:
		name = "?Detach@CurrentScheduler@Concurrency@@SAXXZ"
		size = 49
		refs = "0009 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ 0014 ?Detach@SchedulerBase@details@Concurrency@@QAEXXZ 001e ??0scheduler_not_attached@Concurrency@@QAE@XZ 0023 __TI2?AVscheduler_not_attached@Concurrency@@ 002c __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 85 C0 74 09 8B C8 E8 ?? ?? ?? ?? C9 C3 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_107_10_0 {
	meta:
		name = "?RegisterShutdownEvent@CurrentScheduler@Concurrency@@SAXPAX@Z"
		size = 52
		refs = "0009 ?SafeFastCurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ 0021 ??0scheduler_not_attached@Concurrency@@QAE@XZ 0026 __TI2?AVscheduler_not_attached@Concurrency@@ 002f __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 85 C0 74 0C FF 75 08 8B 10 8B C8 FF 52 18 C9 C3 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_107_12_0 {
	meta:
		name = "?ScheduleTask@CurrentScheduler@Concurrency@@SAXP6AXPAX@Z0@Z"
		size = 25
		refs = "0006 ?CurrentScheduler@SchedulerBase@details@Concurrency@@SAPAV123@XZ"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? FF 75 0C 8B 10 FF 75 08 8B C8 FF 52 24 5D C3 }
	condition:
		$1
}

rule file_109_3_0 {
	meta:
		name = "__wcstod_l"
		size = 264
		refs = "0009 ___security_cookie 0024 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0033 __errno 003e __invalid_parameter_noinfo 0065 _iswctype 0079 __wfltin2 00ae __HUGE 0102 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 0C 57 8B 7D 08 FF 75 10 8D 4D CC 8B DF E8 ?? ?? ?? ?? 85 F6 74 02 89 3E 85 FF 75 24 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D D8 00 74 07 8B 45 D4 83 60 70 FD D9 EE E9 A3 00 00 00 0F B7 07 EB 06 83 C3 02 0F B7 03 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EC 8D 45 CC 50 8D 45 E4 53 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 85 F6 74 08 8B 41 04 8D 04 43 89 06 8B 01 A9 40 02 00 00 74 0D D9 EE DD 5D DC 85 F6 74 49 89 3E EB 45 A8 81 74 10 66 83 3B 2D DD 05 ?? ?? ?? ?? 75 1D D9 E0 EB 19 A9 00 01 00 00 74 24 DD 41 10 D9 EE D9 C0 DD EA DF E0 DD D9 F6 C4 44 7A 10 DD 5D DC E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 08 DD D8 DD 41 10 DD 5D DC 80 7D D8 00 74 07 8B 45 D4 83 60 70 FD DD 45 DC 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__fputwchar"
		size = 26
		refs = "0006 ___iob_func 0012 _fputwc"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "__fputchar"
		size = 26
		refs = "0006 ___iob_func 0012 _putc"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__setjmp"
		size = 56
		refs = "001a __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 06 8B 40 0C 89 42 1C 2B C0 C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "___libm_sse2_powf"
		size = 1715
		refs = "0004 _dword_mask 000f _SIGMASK 001b _EXPMASK 0048 _cv 0093 _B_table 009b _SCALE5 00c4 _T_tbl 00e9 _Shifter 0161 _cev 01a9 _exp2_tbl 01f6 _ABSVALMASK 02bf _NEG_ZEROD 0357 _ABSVALS 039b _ONEMASK 0437 _NEG_ZERO 0443 _NEG_INF 0492 _sNaN 0533 _INF"
	strings:
		$1 = { F3 0F 10 3D ?? ?? ?? ?? 83 EC 0C 66 0F 12 2D ?? ?? ?? ?? 66 0F DB C7 66 0F 12 1D ?? ?? ?? ?? 66 0F DB CF F3 0F 11 44 24 04 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB F3 0F 11 4C 24 08 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? F3 0F 5A C9 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B CA 81 F9 00 80 00 00 0F 83 7D 01 00 00 BA 3F 3F 00 00 B9 00 00 00 00 66 0F 6E C2 83 E0 7F 83 C0 01 25 FE 00 00 00 66 0F 12 3C 85 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 1A 66 0F 73 F7 1A 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 04 85 ?? ?? ?? ?? F2 0F 5C DF F2 0F 59 FD F2 0F 59 EB F2 0F 5C 3D ?? ?? ?? ?? F2 0F 58 EF 66 0F 70 FD 44 66 0F 12 1D ?? ?? ?? ?? F2 0F 58 C5 66 0F 59 F7 66 0F 59 FF F2 0F 58 C4 F2 0F 59 D7 F2 0F 58 C2 66 0F 70 D2 EE F2 0F 58 F2 F2 0F 59 C1 F2 0F 59 FF 66 0F C5 D0 03 F2 0F 10 E0 F2 0F 58 C3 F2 0F 5C C3 66 0F 59 F7 B8 D0 41 00 00 81 E2 F0 7F 00 00 2B C2 81 EA 60 3E 00 00 0B D0 81 FA 00 00 00 80 0F 83 F8 04 00 00 F2 0F 2D C0 F2 0F 5C E0 66 0F 70 FE EE F2 0F 58 F7 66 0F 28 3D ?? ?? ?? ?? F2 0F 59 CE 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 F6 F2 0F 58 E1 66 0F 70 EC 44 BA BF 0F 00 00 2B D0 05 A0 0F 00 00 0B D0 2D A0 0F 00 00 81 FA 00 00 00 80 0F 83 D9 03 00 00 8B D0 D1 FA 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 81 C9 F0 3F 00 00 83 E2 F0 03 CA 66 0F C4 F1 03 83 C4 0C 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 66 0F 5A C0 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E CA F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 66 0F 73 D0 20 66 0F 7E C1 81 F9 00 00 F0 7F 0F 83 D4 00 00 00 0B D1 83 FA 00 0F 84 20 03 00 00 66 0F 7E E2 81 FA FF FF 7F 7F 0F 86 DC 00 00 00 66 0F 73 F3 34 66 0F 56 FB B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D0 14 66 0F FA C3 66 0F EF DB 66 0F EE C3 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 83 38 01 00 00 81 F9 FF 00 00 00 0F 85 EF 01 00 00 66 0F 12 1D ?? ?? ?? ?? F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 34 66 0F FA C3 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 C1 01 7F 00 00 81 E1 00 80 00 00 81 FA 00 00 80 00 72 32 BA 3F BF 00 00 E9 8C FD FF FF 66 0F 7E E2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 77 05 E9 91 01 00 00 83 C4 0C F3 0F 10 C4 F3 0F 58 C0 C3 B9 00 00 00 00 66 0F 57 C0 BA 80 5F 00 00 66 0F C4 C2 01 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? F3 0F 59 E0 66 0F 7E E2 81 E2 FF FF FF 7F 83 FA 00 74 26 66 0F C5 C4 01 0F 28 C4 0F 54 25 ?? ?? ?? ?? 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB BA 3F 5F 00 00 E9 0D FD FF FF 8B 54 24 08 81 E2 00 00 00 80 83 FA 00 74 23 C1 E1 10 66 0F 7E E2 23 D1 81 CA 00 00 80 7F 66 0F 6E C2 83 C4 0C F3 0F 10 2D ?? ?? ?? ?? F3 0F 5E EC C3 C1 E1 10 66 0F 7E E2 23 D1 83 FA 00 75 7E 83 C4 0C 0F 57 C0 C3 66 0F 7E E2 81 FA 00 00 80 7F 0F 84 99 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 87 2F FF FF FF 81 F9 FF 00 00 00 75 65 F2 0F 10 E9 F2 0F 10 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 2D ?? ?? ?? ?? 66 0F 73 D5 34 66 0F FA EB 66 0F EF DB 66 0F F3 D5 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 27 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 D1 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 B7 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F 7E E0 3D 00 00 00 80 0F 84 E7 FE FF FF 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 C3 8B 44 24 08 8B C8 25 FF FF FF 7F 3D 00 00 80 7F 0F 87 87 00 00 00 81 E1 00 00 00 80 66 0F 7E E2 81 F2 00 00 80 BF 83 FA 00 74 30 83 F9 00 74 49 66 0F 7E E0 25 FF FF FF 7F 3D 00 00 80 3F 73 14 83 F8 00 75 4C B9 00 00 80 3F 66 0F 6E E9 F3 0F 5E EC EB 3D 83 C4 0C 0F 57 C0 C3 83 EC 10 0F AE 5C 24 0C 83 64 24 0C DE 0F AE 54 24 0C 83 C4 1C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C4 01 25 80 7F 00 00 3D 80 3F 00 00 73 07 83 C4 0C 0F 57 C0 C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 4C 24 08 83 C4 0C F3 0F 58 C9 F3 0F 10 C1 C3 66 0F 7E E0 F3 0F 10 05 ?? ?? ?? ?? 83 F8 00 74 17 66 0F 7E E0 0F 57 D2 F3 0F 58 E2 25 FF FF FF 7F 3D 00 00 80 7F 77 00 83 C4 0C C3 3D 00 20 00 00 0F 8D 92 00 00 00 3D 00 E0 FF FF 0F 8E 9E 00 00 00 66 0F 57 C9 8B D0 C1 FA 05 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 8B C2 D1 FA 2B C2 C1 E2 04 05 FF 03 00 00 C1 E0 04 81 C9 F0 3F 00 00 03 CA 66 0F C4 F1 03 66 0F C4 C8 03 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 F2 0F 59 C1 66 0F 5A C0 66 0F C5 C0 01 25 FF 7F 00 00 3D 80 7F 00 00 73 05 83 F8 10 72 00 83 C4 0C C3 83 C4 0C 81 C9 7F 7F 00 00 66 0F 57 C0 66 0F C4 C1 01 F3 0F 58 C0 C3 83 C4 0C B8 00 00 80 00 66 0F 6E E8 F3 0F 59 ED 66 0F 57 C0 66 0F C4 C1 01 C3 8B 54 24 04 F3 0F 10 64 24 04 81 FA 00 00 80 3F 0F 84 9C FE FF FF 8B 44 24 08 F3 0F 10 4C 24 08 25 FF FF FF 7F 3D 00 00 80 7F 0F 83 27 FE FF FF 83 F8 00 0F 84 CD FE FF FF 66 0F C5 D0 03 8B C2 81 E2 F0 7F 00 00 81 FA 60 3E 00 00 76 10 25 00 80 00 00 83 F8 00 0F 84 73 FF FF FF EB 88 83 C4 0C C1 E1 10 81 C9 00 00 80 3F 66 0F 6E C1 C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "_wcsnlen"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 39 45 0C 76 12 8B 4D 08 66 83 39 00 74 09 40 83 C1 02 3B 45 0C 72 F1 5D C3 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "_strncat_s"
		size = 192
		refs = "0030 __errno 003a __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 14 53 56 8B 75 08 33 DB 57 3B CB 75 10 3B F3 75 10 39 5D 0C 75 12 33 C0 5F 5E 5B 5D C3 3B F3 74 07 8B 7D 0C 3B FB 77 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB DD 8B 55 10 3B CB 74 08 3B D3 75 04 88 1E EB DE 8B C6 38 18 74 04 40 4F 75 F8 3B FB 74 EE 83 F9 FF 75 11 2B C2 8A 0A 88 0C 10 42 3A CB 74 24 4F 75 F3 EB 1F 3B CB 76 14 2B D0 8A 0C 02 88 08 40 3A CB 74 08 4F 74 05 FF 4D 14 75 EE 39 5D 14 75 02 88 18 3B FB 75 85 83 7D 14 FF 75 0F 8B 45 0C 6A 50 88 5C 06 FF 58 E9 72 FF FF FF 88 1E E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 E9 79 FF FF FF }
	condition:
		$1
}

rule file_116_3_0 {
	meta:
		name = "__mbsnbcoll_l"
		size = 211
		refs = "0020 __errno 002b __invalid_parameter_noinfo 0061 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0078 __strncoll_l 0099 ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 10 33 DB 3B F3 75 07 33 C0 E9 B5 00 00 00 39 5D 08 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 96 00 00 00 39 5D 0C 74 E1 57 BF FF FF FF 7F 3B F7 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 61 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 39 58 08 75 14 FF 75 14 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 41 FF 70 04 56 FF 75 0C 56 FF 75 08 68 00 10 00 00 FF 70 0C 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C7 EB 0F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_116_4_0 {
	meta:
		name = "__mbsnbcoll"
		size = 26
		refs = "0011 __mbsnbcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_59_1_2 {
	meta:
		name = "__Stoll"
		size = 26
		refs = "0011 __Stollx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_1_1_2 {
	meta:
		name = "__Stoul"
		size = 26
		refs = "0011 __Stoulx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_47_1_2 {
	meta:
		name = "__Stoull"
		size = 26
		refs = "0011 __Stoullx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_488_6_0 {
	meta:
		name = "__aligned_realloc"
		size = 26
		refs = "0011 __aligned_offset_realloc"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_725_9_0 {
	meta:
		name = "__fassign"
		size = 26
		refs = "0011 __fassign_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_719_0_0 {
	meta:
		name = "__mbscat_s"
		size = 26
		refs = "0011 __mbscat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "__mbscpy_s"
		size = 26
		refs = "0011 __mbscpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_498_4_0 {
	meta:
		name = "__mbsnbcat"
		size = 26
		refs = "0011 __mbsnbcat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_810_4_0 {
	meta:
		name = "__mbsnbcmp"
		size = 26
		refs = "0011 __mbsnbcmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_494_4_0 {
	meta:
		name = "__mbsnbcpy"
		size = 26
		refs = "0011 __mbsnbcpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_996_4_0 {
	meta:
		name = "__mbsnbicmp"
		size = 26
		refs = "0011 __mbsnbicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_665_4_0 {
	meta:
		name = "__mbsnbicoll"
		size = 26
		refs = "0011 __mbsnbicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_322_4_0 {
	meta:
		name = "__mbsnbset"
		size = 26
		refs = "0011 __mbsnbset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_433_4_0 {
	meta:
		name = "__mbsncat"
		size = 26
		refs = "0011 __mbsncat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_456_4_0 {
	meta:
		name = "__mbsncmp"
		size = 26
		refs = "0011 __mbsncmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_356_4_0 {
	meta:
		name = "__mbsncoll"
		size = 26
		refs = "0011 __mbsncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_958_4_0 {
	meta:
		name = "__mbsncpy"
		size = 26
		refs = "0011 __mbsncpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_513_4_0 {
	meta:
		name = "__mbsnicmp"
		size = 26
		refs = "0011 __mbsnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_552_4_0 {
	meta:
		name = "__mbsnicoll"
		size = 26
		refs = "0011 __mbsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_287_4_0 {
	meta:
		name = "__mbsnset"
		size = 26
		refs = "0011 __mbsnset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_749_0_0 {
	meta:
		name = "__mbsset_s"
		size = 26
		refs = "0011 __mbsset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_427_4_0 {
	meta:
		name = "__mbstok_s"
		size = 26
		refs = "0011 __mbstok_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_739_0_0 {
	meta:
		name = "__spawnvp"
		size = 26
		refs = "0011 __spawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_885_2_0 {
	meta:
		name = "__wcstol_l"
		size = 26
		refs = "0011 ?wcstoxl@@YAKPB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__wspawnvp"
		size = 26
		refs = "0011 __wspawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "_mbtowc"
		size = 26
		refs = "0011 __mbtowc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_903_4_0 {
	meta:
		name = "_strxfrm"
		size = 26
		refs = "0011 __strxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_885_1_0 {
	meta:
		name = "_wcstol"
		size = 26
		refs = "0011 ?wcstoxl@@YAKPB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_449_6_0 {
	meta:
		name = "_wcstombs"
		size = 26
		refs = "0011 __wcstombs_l_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_626_4_0 {
	meta:
		name = "_wcsxfrm"
		size = 26
		refs = "0011 __wcsxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_118_6_0 {
	meta:
		name = "__Getdays_l"
		size = 232
		refs = "0014 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c _strlen 0054 __malloc_crt 007c _strcpy_s 00e3 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 FF 75 08 8D 4D E8 33 DB E8 ?? ?? ?? ?? 8B 45 E8 8B B8 D4 00 00 00 89 5D FC 8B 75 FC FF 74 B7 1C E8 ?? ?? ?? ?? FF 34 B7 89 45 F8 E8 ?? ?? ?? ?? 03 C3 FF 45 FC 83 7D FC 07 59 59 8B 4D F8 8D 5C 08 02 72 D5 8D 43 01 50 E8 ?? ?? ?? ?? 8B F0 59 89 75 F8 85 F6 74 64 83 65 FC 00 8B 45 FC C6 06 3A FF 34 87 8B 45 F8 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 54 56 E8 ?? ?? ?? ?? 03 F0 8B 45 FC C6 06 3A FF 74 87 1C 8B 45 F8 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 2A 56 E8 ?? ?? ?? ?? 03 F0 FF 45 FC 83 7D FC 07 59 72 A3 C6 06 00 80 7D F4 00 5F 5E 5B 74 07 8B 45 F0 83 60 70 FD 8B 45 F8 C9 C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_118_8_0 {
	meta:
		name = "__Getmonths_l"
		size = 240
		refs = "0014 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0032 _strlen 005e __malloc_crt 0086 _strcpy_s 00eb __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 57 FF 75 08 8D 4D E4 33 DB E8 ?? ?? ?? ?? 8B 45 E4 8B B8 D4 00 00 00 8D 77 38 89 75 F8 C7 45 FC 0C 00 00 00 FF 76 30 E8 ?? ?? ?? ?? FF 36 89 45 F4 E8 ?? ?? ?? ?? 8B 75 F8 59 59 8B 4D F4 03 C3 83 C6 04 FF 4D FC 8D 5C 08 02 89 75 F8 75 D5 8D 43 01 50 E8 ?? ?? ?? ?? 8B F0 59 89 75 F8 85 F6 74 62 83 65 FC 00 83 C7 68 8B 45 F8 C6 06 3A FF 77 D0 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 52 56 E8 ?? ?? ?? ?? 03 F0 8B 45 F8 C6 06 3A FF 37 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 2D 56 E8 ?? ?? ?? ?? 03 F0 FF 45 FC 83 C7 04 83 7D FC 0C 59 72 A8 C6 06 00 80 7D F0 00 5F 5E 5B 74 07 8B 45 EC 83 60 70 FD 8B 45 F8 C9 C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_118_10_0 {
	meta:
		name = "__Gettnames_l"
		size = 746
		refs = "0014 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c _strlen 00d8 __malloc_crt 00f7 _memcpy 0124 _strcpy_s 018b __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 53 56 57 FF 75 08 8D 4D DC 33 FF E8 ?? ?? ?? ?? 8B 45 DC 8B B0 D4 00 00 00 89 7D FC 8B 5D FC FF 74 9E 1C E8 ?? ?? ?? ?? FF 34 9E 89 45 EC E8 ?? ?? ?? ?? 03 C7 FF 45 FC 83 7D FC 07 59 59 8B 4D EC 8D 7C 08 02 72 D5 8D 46 38 89 45 F0 C7 45 EC 0C 00 00 00 8B 5D F0 FF 73 30 E8 ?? ?? ?? ?? FF 33 89 45 F4 E8 ?? ?? ?? ?? 83 45 F0 04 59 59 8B 4D F4 03 C7 FF 4D EC 8D 7C 08 02 75 D7 FF B6 9C 00 00 00 E8 ?? ?? ?? ?? FF B6 98 00 00 00 8B D8 E8 ?? ?? ?? ?? FF B6 A0 00 00 00 03 C7 8D 7C 18 02 E8 ?? ?? ?? ?? FF B6 A4 00 00 00 8D 7C 07 01 E8 ?? ?? ?? ?? FF B6 A8 00 00 00 8D 7C 07 01 E8 ?? ?? ?? ?? 8D 84 07 65 01 00 00 50 89 45 F8 E8 ?? ?? ?? ?? 8B D8 83 C4 18 85 DB 0F 84 ED 01 00 00 68 64 01 00 00 56 53 8D BB 64 01 00 00 E8 ?? ?? ?? ?? 83 65 FC 00 8D 46 1C 89 5D F0 83 C4 0C 29 75 F0 89 45 F4 8B 45 FC 89 3C 83 8B 45 F4 FF 70 E4 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 54 57 E8 ?? ?? ?? ?? 8B 4D F0 8D 7C 07 01 8B 45 F4 89 3C 01 FF 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 2A 57 E8 ?? ?? ?? ?? FF 45 FC 83 45 F4 04 83 7D FC 07 59 8D 7C 07 01 72 9D 83 65 FC 00 8D 43 68 89 45 EC 8D 46 38 89 45 F4 EB 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 8B 45 F4 8B 4D F0 89 3C 08 FF 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 D4 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B 45 EC 89 38 8B 45 F4 FF 70 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 AA 57 E8 ?? ?? ?? ?? FF 45 FC 83 45 F4 04 83 45 EC 04 83 7D FC 0C 59 8D 7C 07 01 72 9A 8B C3 2B C7 03 45 F8 89 BB 98 00 00 00 FF B6 98 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 69 FF FF FF 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB 9C 00 00 00 FF B6 9C 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 3A FF FF FF 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB A0 00 00 00 FF B6 A0 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 0B FF FF FF 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB A4 00 00 00 FF B6 A4 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 DC FE FF FF 57 E8 ?? ?? ?? ?? 8D 44 07 01 8B CB 2B C8 03 4D F8 89 83 A8 00 00 00 FF B6 A8 00 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 AD FE FF FF 80 7D E8 00 74 07 8B 45 E4 83 60 70 FD 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_118_12_0 {
	meta:
		name = "?_store_str@@YAXPADPAPADPAI@Z"
		size = 32
	strings:
		$1 = { 83 38 00 56 8B F2 74 16 57 8A 16 84 D2 74 0E 8B 39 88 17 FF 01 46 FF 08 83 38 00 75 EC 5F 5E C3 }
	condition:
		$1
}

rule file_118_13_0 {
	meta:
		name = "?_store_number@@YAXHPAPADPAI@Z"
		size = 54
	strings:
		$1 = { 83 3E 01 8B 0F 53 76 19 6A 0A 99 5B F7 FB 80 C2 30 88 11 41 FF 0E 8B 16 85 C0 7E 05 83 FA 01 77 E7 8B 07 89 0F 49 8A 18 8A 11 88 19 49 88 10 40 3B C1 72 F2 5B C3 }
	condition:
		$1
}

rule file_118_14_0 {
	meta:
		name = "?_store_num@@YAXHHPAPADPAII@Z"
		size = 123
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B F2 33 D2 89 55 FC 39 55 08 74 35 83 39 01 8B 37 76 19 6A 0A 99 5B F7 FB 80 C2 30 88 16 46 FF 09 8B 11 85 C0 7E 05 83 FA 01 77 E7 8B 07 89 37 4E 8A 10 8A 0E 88 16 4E 88 08 40 3B C6 72 F2 EB 2E 3B 31 73 28 4E 8D 56 01 85 D2 74 17 6A 0A 99 5B F7 FB 8B 1F 80 C2 30 FF 45 FC 88 14 1E 4E 83 FE FF 75 E9 8B 45 FC 01 07 29 01 EB 02 89 11 5E 5B C9 C3 }
	condition:
		$1
}

rule file_118_15_0 {
	meta:
		name = "?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
		size = 952
		refs = "0243 ?_store_num@@YAXHHPAPADPAII@Z 025f ?_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPADPAIPAU__lc_time_data@@@Z 02be __errno 02c9 __invalid_parameter_noinfo 030b ___tzset 0310 ___tzname 03ac ?_store_str@@YAXPADPAPADPAI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 0F BE C0 56 8B 75 0C 57 8B D9 8B FA 83 F8 59 0F 8F B1 01 00 00 0F 84 7B 01 00 00 83 F8 49 0F 8F C0 00 00 00 0F 84 8F 00 00 00 83 E8 04 0F 84 76 03 00 00 83 E8 09 0F 84 6D 03 00 00 83 E8 18 74 6A 83 E8 1C 74 45 48 74 22 83 E8 06 0F 85 74 02 00 00 8B 46 08 85 C0 0F 88 59 02 00 00 83 F8 17 0F 8F 50 02 00 00 E9 CA 01 00 00 8B 76 10 85 F6 0F 88 40 02 00 00 83 FE 0B 0F 8F 37 02 00 00 8B 55 10 8B 54 B2 68 E9 15 03 00 00 8B 76 18 85 F6 0F 88 20 02 00 00 83 FE 06 0F 8F 17 02 00 00 8B 55 10 8B 54 B2 1C E9 F5 02 00 00 8B 07 C6 00 25 FF 07 FF 0B E9 F0 02 00 00 8B 76 08 85 F6 0F 88 F2 01 00 00 83 FE 17 0F 8F E9 01 00 00 8B C6 99 6A 0C 59 F7 F9 8B C2 85 C0 75 02 51 58 8B CB E9 51 01 00 00 83 E8 4D 0F 84 96 00 00 00 6A 06 59 2B C1 74 77 48 48 74 2C 48 48 74 0C 48 0F 85 C3 01 00 00 E9 69 01 00 00 8B 46 18 85 C0 0F 88 A3 01 00 00 3B C1 0F 8F 9B 01 00 00 85 C0 74 1A 8D 48 FF EB 15 8B 46 18 85 C0 0F 88 87 01 00 00 3B C1 0F 8F 7F 01 00 00 8B C8 8B 46 1C 85 C0 0F 88 72 01 00 00 3D 6D 01 00 00 0F 8F 67 01 00 00 3B C1 7D 04 33 C0 EB 86 6A 07 99 5E F7 FE 3B D1 0F 8C 78 FF FF FF 40 E9 72 FF FF FF 8B 06 85 C0 0F 88 41 01 00 00 83 F8 3B 0F 8F 38 01 00 00 E9 5A FF FF FF 8B 46 04 85 C0 0F 88 28 01 00 00 83 F8 3B E9 CA FE FF FF 8B 46 14 3D 94 F8 FF FF 0F 8C 12 01 00 00 3D A3 1F 00 00 0F 8F 07 01 00 00 99 6A 64 59 F7 F9 FF 75 14 8B CB 6A 04 83 C0 13 6B C0 64 03 C2 EB 74 83 F8 6D 0F 8F 1D 01 00 00 0F 84 03 01 00 00 83 E8 5A 0F 84 25 01 00 00 83 E8 07 0F 84 C3 00 00 00 48 0F 84 A4 00 00 00 48 74 55 48 74 2A 83 E8 06 0F 85 C9 00 00 00 8B 76 1C 85 F6 0F 88 AE 00 00 00 81 FE 6D 01 00 00 0F 8F A2 00 00 00 FF 75 14 8D 46 01 6A 03 EB 1C 8B 76 0C 83 FE 01 0F 8C 8C 00 00 00 83 FE 1F 0F 8F 83 00 00 00 8B C6 FF 75 14 6A 02 5A E8 ?? ?? ?? ?? 59 E9 63 01 00 00 83 7D 14 00 FF 75 10 53 57 56 74 3C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 63 83 3B 00 74 5E 8B 07 C6 00 20 FF 07 FF 0B FF 75 10 53 57 56 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 85 1D 01 00 00 EB 38 6A 00 EB C2 8B 76 10 85 F6 78 1D 83 FE 0B 7F 18 8B 55 10 8B 54 B2 38 E9 F6 00 00 00 8B 76 18 85 F6 78 05 83 FE 06 7E 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 DF 00 00 00 8B 55 10 8B 14 B2 E9 C8 00 00 00 8B 76 10 85 F6 78 D7 83 FE 0B 7F D2 8D 46 01 E9 49 FF FF FF 83 E8 70 0F 84 81 00 00 00 83 E8 07 74 5D 48 74 40 48 74 24 48 75 C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 33 C0 39 46 20 0F 95 C0 89 45 FC 8B C3 8B 5D FC 8B 14 9A EB 7E 8B 46 14 85 C0 78 8B FF 75 14 99 6A 64 59 F7 F9 8B CB 8B C2 E9 FB FE FF FF 83 7D 14 00 FF 75 10 53 57 56 74 07 6A 01 E9 29 FF FF FF 6A 00 E9 22 FF FF FF 8B 46 18 85 C0 0F 88 54 FF FF FF 83 F8 06 0F 8F 4B FF FF FF FF 75 14 33 D2 42 E9 C5 FE FF FF 8B 76 08 85 F6 0F 88 35 FF FF FF 83 FE 17 0F 8F 2C FF FF FF 8B 55 10 83 FE 0B 7F 08 8B 92 98 00 00 00 EB 06 8B 92 9C 00 00 00 8B C3 8B CF E8 ?? ?? ?? ?? 33 C0 40 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_118_16_0 {
	meta:
		name = "?_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPADPAIPAU__lc_time_data@@@Z"
		size = 1114
		refs = "0009 ___security_cookie 0060 __imp__GetDateFormatA@24 0067 __imp__GetTimeFormatA@24 00d7 __alloca_probe_16 00eb _malloc 0143 __freea 0157 @__security_check_cookie@4 01ad __isleadbyte_l 022e ??_C@_05JAMEPDIN@am?1pm?$AA@ 0234 ___ascii_stricmp 0244 ??_C@_03EBAPMIKO@a?1p?$AA@ 0440 ?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 8B 4D 0C 83 E9 00 89 45 E0 8B 45 10 53 8B 5D 18 56 8B 75 14 89 45 D8 8B 45 1C 57 89 45 DC 74 13 49 74 08 8B B8 A8 00 00 00 EB 0E 8B B8 A4 00 00 00 EB 06 8B B8 A0 00 00 00 83 B8 B0 00 00 00 01 0F 84 81 01 00 00 83 7D 0C 02 A1 ?? ?? ?? ?? 75 05 A1 ?? ?? ?? ?? 89 45 D4 8B 45 D8 B9 6C 07 00 00 66 03 48 14 66 89 4D EC 66 8B 48 10 66 41 66 89 4D EE 66 8B 48 0C 66 89 4D F2 66 8B 48 08 66 89 4D F4 66 8B 48 04 66 8B 00 66 89 45 F8 33 C0 50 50 57 66 89 4D F6 8D 4D EC 51 50 66 89 45 FA 8B 45 DC FF B0 AC 00 00 00 FF 55 D4 89 45 D0 85 C0 0F 84 10 01 00 00 83 C0 08 3D 00 04 00 00 7F 13 E8 ?? ?? ?? ?? 8B C4 85 C0 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 59 85 C0 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 E8 85 C0 0F 84 D4 00 00 00 FF 75 D0 89 45 E4 50 57 8D 45 EC 50 8B 45 DC 6A 00 FF B0 AC 00 00 00 FF 55 D4 48 85 C0 7E 18 8B 7D E4 83 3B 00 76 10 8A 17 8B 0E 88 11 FF 06 47 FF 0B 48 85 C0 7F EB FF 75 E8 E8 ?? ?? ?? ?? 59 33 C0 40 8D 65 C4 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 33 D2 39 13 74 E5 89 55 E8 8B CF 41 42 38 01 74 FA 89 4D E4 0F BE C8 83 F9 64 0F 8F 7C 01 00 00 0F 84 48 01 00 00 83 F9 27 0F 84 D5 00 00 00 83 F9 41 0F 84 98 00 00 00 83 F9 48 74 7B 83 F9 4D 74 4C 83 F9 61 0F 84 85 00 00 00 FF 75 E0 51 E8 ?? ?? ?? ?? 59 59 85 C0 74 1A 83 3B 01 76 15 80 7F 01 00 0F 84 8D 02 00 00 8A 17 8B 0E 88 11 FF 06 47 FF 0B 8A 0F 8B 06 88 08 FF 06 47 FF 0B 8A 07 84 C0 0F 85 77 FF FF FF E9 5D FF FF FF 8B C2 48 74 17 48 74 1B 48 74 0A 48 75 AF B0 42 E9 2F 02 00 00 B0 62 E9 28 02 00 00 C7 45 E8 01 00 00 00 B0 6D E9 1A 02 00 00 8B C2 48 74 05 48 74 09 EB 89 C7 45 E8 01 00 00 00 B0 48 E9 02 02 00 00 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 83 C7 05 EB 14 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 06 83 C7 03 89 7D E4 B0 70 E9 CE 01 00 00 03 FA F6 C2 01 0F 84 70 FF FF FF 8A 07 84 C0 0F 84 D2 FE FF FF 83 3B 00 0F 84 5D FF FF FF 3C 27 74 42 FF 75 E0 0F BE C0 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1A 83 3B 01 76 15 80 7F 01 00 0F 84 AF 01 00 00 8A 17 8B 0E 88 11 FF 06 47 FF 0B 8B 06 8A 0F 88 08 FF 06 47 FF 0B 8A 07 84 C0 75 B6 E9 17 FF FF FF 47 E9 11 FF FF FF 8B C2 48 74 1B 48 74 1F 48 74 0E 48 0F 85 CB FE FF FF B0 41 E9 4B 01 00 00 B0 61 E9 44 01 00 00 C7 45 E8 01 00 00 00 B0 64 E9 36 01 00 00 8B C1 83 E8 68 0F 84 15 01 00 00 83 E8 05 0F 84 F4 00 00 00 83 E8 06 0F 84 D3 00 00 00 48 74 25 83 E8 05 0F 85 86 FE FF FF 8D 42 FF 48 74 0F 48 48 0F 85 78 FE FF FF B0 59 E9 F8 00 00 00 B0 79 E9 F1 00 00 00 8B 45 D8 83 78 08 0B 8B 45 DC 7F 08 8B B8 98 00 00 00 EB 06 8B B8 9C 00 00 00 83 FA 01 0F 85 80 00 00 00 83 3B 00 76 7B 0F BE 07 FF 75 E0 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1A 83 3B 01 76 15 80 7F 01 00 0F 84 CC 00 00 00 8A 17 8B 0E 88 11 FF 06 47 FF 0B 8B 06 8A 0F 88 08 FF 06 FF 0B E9 AA 00 00 00 83 3B 00 0F 86 A1 00 00 00 FF 75 E0 0F BE C0 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1A 83 3B 01 76 15 80 7F 01 00 0F 84 88 00 00 00 8A 17 8B 0E 88 11 FF 06 47 FF 0B 8A 0F 8B 06 88 08 FF 06 47 FF 0B 8A 07 84 C0 75 BA EB 62 8B C2 48 74 08 48 74 0C E9 B2 FD FF FF C7 45 E8 01 00 00 00 B0 53 EB 2E 8B C2 48 74 08 48 74 0C E9 9A FD FF FF C7 45 E8 01 00 00 00 B0 4D EB 16 8B C2 48 74 08 48 74 0C E9 82 FD FF FF C7 45 E8 01 00 00 00 B0 49 FF 75 E8 8B CB FF 75 DC 8B D6 FF 75 D8 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 08 8B 7D E4 E9 89 FD FF FF 33 C0 E9 F1 FC FF FF }
	condition:
		$1
}

rule file_118_17_0 {
	meta:
		name = "__Strftime_l"
		size = 396
		refs = "001b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 __errno 0032 __invalid_parameter_noinfo 00b3 __isleadbyte_l 010e ?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 08 53 FF 75 1C 33 DB 8D 4D E0 89 5D F8 89 45 F0 E8 ?? ?? ?? ?? 8B 45 08 3B C3 75 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 E9 40 01 00 00 57 8B 7D 0C 3B FB 75 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 E9 14 01 00 00 56 8B 75 10 88 18 3B F3 0F 84 E7 00 00 00 8B 45 18 3B C3 75 09 8B 45 E0 8B 80 D4 00 00 00 89 45 F4 89 7D FC 3B FB 0F 86 9F 00 00 00 8A 06 3A C3 74 79 3C 25 74 41 8D 4D E0 0F BE C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1E 33 C9 41 39 4D FC 76 16 8D 46 01 38 18 74 70 8A 0E 8B 55 08 88 0A FF 45 08 FF 4D FC 8B F0 8A 06 8B 4D 08 88 01 FF 45 08 46 FF 4D FC EB 2F 39 5D 14 74 79 46 33 C0 80 3E 23 75 02 40 46 50 FF 75 F4 8D 45 E0 FF 75 14 8D 4D FC 50 8A 06 8D 55 08 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 42 46 39 5D FC 77 81 39 5D FC 76 1B 8B 45 08 88 18 2B 7D FC 8B C7 38 5D EC 74 54 8B 4D E8 83 61 70 FD EB 4B 89 4D F8 8B 45 F0 88 18 39 5D F8 75 20 39 5D FC 77 1B E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 1E 39 5D FC 76 DF C7 45 F8 01 00 00 00 EB D6 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_118_18_0 {
	meta:
		name = "__strftime_l"
		size = 32
		refs = "0017 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_529_6_0 {
	meta:
		name = "__vsnprintf_s"
		size = 32
		refs = "0017 __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_660_6_0 {
	meta:
		name = "__vsnwprintf_s"
		size = 32
		refs = "0017 __vsnwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_545_19_0 {
	meta:
		name = "__wcsftime_l"
		size = 32
		refs = "0017 __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_118_19_0 {
	meta:
		name = "_strftime"
		size = 31
		refs = "0016 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_545_20_0 {
	meta:
		name = "_wcsftime"
		size = 31
		refs = "0016 __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_118_20_0 {
	meta:
		name = "__Strftime"
		size = 32
		refs = "0017 __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_545_18_0 {
	meta:
		name = "__Wcsftime"
		size = 32
		refs = "0017 __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_725_17_0 {
	meta:
		name = "__cftoa"
		size = 32
		refs = "0017 __cftoa_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_725_15_0 {
	meta:
		name = "__cftoe"
		size = 32
		refs = "0017 __cftoe_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_725_22_0 {
	meta:
		name = "__cftog"
		size = 32
		refs = "0017 __cftog_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_738_7_0 {
	meta:
		name = "_mbstowcs_s"
		size = 32
		refs = "0017 __mbstowcs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_449_8_0 {
	meta:
		name = "_wcstombs_s"
		size = 32
		refs = "0017 __wcstombs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__locking_nolock"
		size = 189
		refs = "0011 __lseek_nolock 0048 __get_osfhandle 0055 __imp__UnlockFile@20 005d __imp__LockFile@20 0067 __imp__GetLastError@0 007d __imp__Sleep@4 0098 __dosmaperr 00a0 __errno 00ab ___doserrno"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 6A 01 33 F6 56 FF 75 08 E8 ?? ?? ?? ?? 8B D8 83 C8 FF 83 C4 0C 3B D8 0F 84 94 00 00 00 83 7D 0C 01 74 09 83 7D 0C 03 89 75 FC 75 07 C7 45 FC 09 00 00 00 57 56 FF 75 10 33 FF 56 53 FF 75 08 E8 ?? ?? ?? ?? 59 50 39 75 0C 75 08 FF 15 ?? ?? ?? ?? EB 06 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? 8B F8 39 75 FC 7E 14 3B FE 74 40 68 E8 03 00 00 FF 15 ?? ?? ?? ?? FF 4D FC EB B6 3B FE 74 2C 83 7D 0C 01 74 0F 83 7D 0C 03 74 09 57 E8 ?? ?? ?? ?? 59 EB 12 E8 ?? ?? ?? ?? C7 00 24 00 00 00 E8 ?? ?? ?? ?? 89 38 83 C8 FF EB 02 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_119_1_0 {
	meta:
		name = "__locking"
		size = 212
		refs = "0003 __sehtable$__locking 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0035 __nhandle 004f __invalid_parameter_noinfo 005d ___pioinfo 0077 ___lock_fhandle 0091 __locking_nolock 00c4 __SEH_epilog4 00ce __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 83 FB FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 94 00 00 00 85 DB 78 08 3B 1D ?? ?? ?? ?? 72 1A E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB D2 8B C3 C1 F8 05 8D 3C 85 ?? ?? ?? ?? 8B F3 83 E6 1F C1 E6 06 8B 07 0F BE 44 30 04 83 E0 01 74 C6 53 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 07 F6 44 30 04 01 74 14 FF 75 10 FF 75 0C 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 5D 08 53 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "__lseek"
		size = 212
		refs = "0003 __sehtable$__lseek 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0035 __nhandle 004f __invalid_parameter_noinfo 005d ___pioinfo 0077 ___lock_fhandle 0091 __lseek_nolock 00c4 __SEH_epilog4 00ce __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 83 FB FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 94 00 00 00 85 DB 78 08 3B 1D ?? ?? ?? ?? 72 1A E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB D2 8B C3 C1 F8 05 8D 3C 85 ?? ?? ?? ?? 8B F3 83 E6 1F C1 E6 06 8B 07 0F BE 44 30 04 83 E0 01 74 C6 53 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 07 F6 44 30 04 01 74 14 FF 75 10 FF 75 0C 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 5D 08 53 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_999_1_0 {
	meta:
		name = "__write"
		size = 212
		refs = "0003 __sehtable$__write 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0035 __nhandle 004f __invalid_parameter_noinfo 005d ___pioinfo 0077 ___lock_fhandle 0091 __write_nolock 00c4 __SEH_epilog4 00ce __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 83 FB FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 94 00 00 00 85 DB 78 08 3B 1D ?? ?? ?? ?? 72 1A E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB D2 8B C3 C1 F8 05 8D 3C 85 ?? ?? ?? ?? 8B F3 83 E6 1F C1 E6 06 8B 07 0F BE 44 30 04 83 E0 01 74 C6 53 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 07 F6 44 30 04 01 74 14 FF 75 10 FF 75 0C 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 5D 08 53 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "_realloc"
		size = 173
		refs = "000f _malloc 0022 _free 003b __crtheap 0041 __imp__HeapReAlloc@16 004d __newmode 0055 __callnewh 006b __errno 0084 __imp__GetLastError@0 008a __get_errno_from_oserr"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 0B FF 75 0C E8 ?? ?? ?? ?? 59 5D C3 56 8B 75 0C 85 F6 75 0D FF 75 08 E8 ?? ?? ?? ?? 59 33 C0 EB 4D 57 EB 30 85 F6 75 01 46 56 FF 75 08 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 5E 39 05 ?? ?? ?? ?? 74 40 56 E8 ?? ?? ?? ?? 59 85 C0 74 1D 83 FE E0 76 CB 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 5F 5E 5D C3 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 06 EB E2 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 06 8B C7 EB CA }
	condition:
		$1
}

rule file_122_3_0 {
	meta:
		name = "__mbsspn_l"
		size = 188
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 _strspn 0036 __errno 0041 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F4 33 DB 39 5E 08 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 7E 8B 45 08 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 63 39 5D 0C 74 DB 38 18 74 4B 57 8B 4D 0C EB 28 8A 11 0F B6 FA F6 44 37 1D 04 74 17 3A 10 75 08 8A 51 01 3A 50 01 74 14 8D 51 01 38 1A 74 0D 8B CA EB 04 3A 10 74 05 41 38 19 75 D4 38 19 74 14 0F B6 08 F6 44 31 1D 04 74 05 40 38 18 74 05 40 38 18 75 B7 5F 2B 45 08 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_123_3_0 {
	meta:
		name = "__ismbcl0_l"
		size = 89
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 29 8B 4D 08 C1 E9 08 0F B6 C9 F6 44 01 1D 04 74 19 0F B6 4D 08 F6 44 01 1D 08 74 0E 81 7D 08 9F 88 00 00 73 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_123_5_0 {
	meta:
		name = "__ismbcl1_l"
		size = 95
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 2F 8B 4D 08 8B D1 C1 EA 08 0F B6 D2 F6 44 02 1D 04 74 1D 0F B6 D1 F6 44 02 1D 08 74 13 81 C1 61 77 FF FF 81 F9 D3 0F 00 00 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_123_7_0 {
	meta:
		name = "__ismbcl2_l"
		size = 95
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 2F 8B 4D 08 8B D1 C1 EA 08 0F B6 D2 F6 44 02 1D 04 74 1D 0F B6 D1 F6 44 02 1D 08 74 13 81 C1 61 67 FF FF 81 F9 05 52 00 00 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "__freebuf"
		size = 49
		refs = "0018 _free"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8B 46 0C A8 83 74 1E A8 08 74 1A FF 76 08 E8 ?? ?? ?? ?? 81 66 0C F7 FB FF FF 33 C0 59 89 06 89 46 08 89 46 04 5E 5D C3 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__87except"
		size = 319
		refs = "001e ___security_cookie 00a5 __handle_exc 00f2 __raise_exc 0105 __ctrlfp 0112 __matherr_flag 011b __matherr 0127 __set_errno_from_matherr 0134 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 88 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 43 10 0F B7 08 56 8B 73 0C 8B 06 48 57 89 8D 78 FF FF FF 74 52 48 74 43 48 74 34 48 74 25 48 74 46 48 48 74 13 48 0F 85 A5 00 00 00 C7 85 7C FF FF FF 10 00 00 00 EB 39 C7 06 01 00 00 00 E9 8E 00 00 00 C7 85 7C FF FF FF 12 00 00 00 EB 22 C7 85 7C FF FF FF 11 00 00 00 EB 16 C7 85 7C FF FF FF 04 00 00 00 EB 0A C7 85 7C FF FF FF 08 00 00 00 51 8D 7E 18 57 FF B5 7C FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 49 8B 43 08 83 F8 10 74 10 83 F8 16 74 0B 83 F8 1D 74 06 83 65 C0 FE EB 12 8B 4D C0 DD 46 10 83 E1 E3 DD 5D B0 83 C9 03 89 4D C0 57 8D 4E 08 51 50 FF B5 7C FF FF FF 8D 85 78 FF FF FF 50 8D 45 80 50 E8 ?? ?? ?? ?? 83 C4 18 68 FF FF 00 00 FF B5 78 FF FF FF E8 ?? ?? ?? ?? 83 3E 08 59 59 74 14 83 3D ?? ?? ?? ?? 00 75 0B 56 E8 ?? ?? ?? ?? 59 85 C0 75 08 FF 36 E8 ?? ?? ?? ?? 59 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "_sprintf"
		size = 132
		refs = "001f __errno 002a __invalid_parameter_noinfo 005c __output_l 0077 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 57 33 DB 6A 07 33 C0 59 8D 7D E4 89 5D E0 F3 AB 39 5D 0C 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 4D 8B 45 08 3B C3 74 E4 56 89 45 E8 89 45 E0 8D 45 10 50 53 FF 75 0C 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_126_1_0 {
	meta:
		name = "__sprintf_l"
		size = 28
		refs = "0013 __vsprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_500_1_0 {
	meta:
		name = "___swprintf_l"
		size = 28
		refs = "0013 ___vswprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_926_1_0 {
	meta:
		name = "__fprintf_l"
		size = 28
		refs = "0013 __vfprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_926_4_0 {
	meta:
		name = "__fprintf_p_l"
		size = 28
		refs = "0013 __vfprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_926_2_0 {
	meta:
		name = "__fprintf_s_l"
		size = 28
		refs = "0013 __vfprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_599_1_0 {
	meta:
		name = "__fwprintf_l"
		size = 28
		refs = "0013 __vfwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_599_4_0 {
	meta:
		name = "__fwprintf_p_l"
		size = 28
		refs = "0013 __vfwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_599_2_0 {
	meta:
		name = "__fwprintf_s_l"
		size = 28
		refs = "0013 __vfwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_126_2_0 {
	meta:
		name = "_sprintf_s"
		size = 30
		refs = "0015 __vsprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "?swprintf@@YAHPAGIPBGZZ"
		size = 30
		refs = "0015 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_126_6_0 {
	meta:
		name = "__sprintf_p"
		size = 30
		refs = "0015 __vsprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_500_4_0 {
	meta:
		name = "__swprintf_p"
		size = 30
		refs = "0015 __vswprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_473_1_0 {
	meta:
		name = "_swprintf"
		size = 30
		refs = "0015 __vswprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_500_2_0 {
	meta:
		name = "_swprintf_s"
		size = 30
		refs = "0015 __vswprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_126_3_0 {
	meta:
		name = "__sprintf_s_l"
		size = 31
		refs = "0016 __vsprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_899_1_0 {
	meta:
		name = "__snprintf_c_l"
		size = 31
		refs = "0016 __vsnprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_842_1_0 {
	meta:
		name = "__snprintf_l"
		size = 31
		refs = "0016 __vsnprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_390_1_0 {
	meta:
		name = "__snwprintf_l"
		size = 31
		refs = "0016 __vsnwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_126_7_0 {
	meta:
		name = "__sprintf_p_l"
		size = 31
		refs = "0016 __vsprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_796_1_0 {
	meta:
		name = "__swprintf_c_l"
		size = 31
		refs = "0016 __vswprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_500_7_0 {
	meta:
		name = "__swprintf_p_l"
		size = 31
		refs = "0016 __vswprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_500_5_0 {
	meta:
		name = "__swprintf_s_l"
		size = 31
		refs = "0016 __vswprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_126_4_0 {
	meta:
		name = "__snprintf_s"
		size = 33
		refs = "0018 __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_500_3_0 {
	meta:
		name = "__snwprintf_s"
		size = 33
		refs = "0018 __vsnwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 18 50 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_126_5_0 {
	meta:
		name = "__snprintf_s_l"
		size = 34
		refs = "0019 __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 1C 50 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_500_6_0 {
	meta:
		name = "__snwprintf_s_l"
		size = 34
		refs = "0019 __vsnwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 1C 50 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_126_8_0 {
	meta:
		name = "__scprintf"
		size = 21
		refs = "000d __vscprintf"
		altNames = "__scprintf_p"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_500_8_0 {
	meta:
		name = "__scwprintf"
		size = 21
		refs = "000d __vscwprintf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_500_9_0 {
	meta:
		name = "__scwprintf_p"
		size = 21
		refs = "000d __vscwprintf_p"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_126_10_0 {
	meta:
		name = "__scprintf_l"
		size = 25
		refs = "0010 __vscprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_538_10_0 {
	meta:
		name = "__cprintf_l"
		size = 25
		refs = "0010 __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_11_0 {
	meta:
		name = "__cprintf_p_l"
		size = 25
		refs = "0010 __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_375_10_0 {
	meta:
		name = "__cprintf_s_l"
		size = 25
		refs = "0010 __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_337_9_0 {
	meta:
		name = "__cwprintf_l"
		size = 25
		refs = "0010 __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_923_9_0 {
	meta:
		name = "__cwprintf_p_l"
		size = 25
		refs = "0010 __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_667_9_0 {
	meta:
		name = "__cwprintf_s_l"
		size = 25
		refs = "0010 __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_314_1_0 {
	meta:
		name = "__printf_l"
		size = 25
		refs = "0010 __vprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_314_4_0 {
	meta:
		name = "__printf_p_l"
		size = 25
		refs = "0010 __vprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_314_2_0 {
	meta:
		name = "__printf_s_l"
		size = 25
		refs = "0010 __vprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_126_11_0 {
	meta:
		name = "__scprintf_p_l"
		size = 25
		refs = "0010 __vscprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_500_10_0 {
	meta:
		name = "__scwprintf_l"
		size = 25
		refs = "0010 __vscwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_500_11_0 {
	meta:
		name = "__scwprintf_p_l"
		size = 25
		refs = "0010 __vscwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_919_1_0 {
	meta:
		name = "__wprintf_l"
		size = 25
		refs = "0010 __vwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_919_4_0 {
	meta:
		name = "__wprintf_p_l"
		size = 25
		refs = "0010 __vwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_919_2_0 {
	meta:
		name = "__wprintf_s_l"
		size = 25
		refs = "0010 __vwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "__ftime64_s"
		size = 368
		refs = "000c ___security_cookie 0027 __errno 0031 __invalid_parameter_noinfo 003f @__security_check_cookie@4 0046 ___tzset 0052 __get_timezone 0079 __imp__GetSystemTimeAsFileTime@4 0092 __aulldiv 00a4 _elapsed_minutes_cache 00bb __imp__GetTimeZoneInformation@4 00d8 _dstflag_cache 0136 __aullrem 016b __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C4 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 57 33 FF 89 BD 4C FF FF FF 3B F7 75 1F E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 E8 ?? ?? ?? ?? 8D 85 4C FF FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 06 01 00 00 8B 85 4C FF FF FF 53 6A 3C 99 59 F7 F9 66 89 46 0A 8D 85 44 FF FF FF 50 FF 15 ?? ?? ?? ?? 8B 9D 44 FF FF FF 57 8B BD 48 FF FF FF 68 00 46 C3 23 57 53 E8 ?? ?? ?? ?? 89 85 3C FF FF FF 89 95 40 FF FF FF 3B 05 ?? ?? ?? ?? 75 08 3B 15 ?? ?? ?? ?? 74 62 8D 85 50 FF FF FF 50 FF 15 ?? ?? ?? ?? 83 F8 FF 74 27 83 F8 02 75 19 66 83 7D EA 00 74 12 83 7D F8 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 10 83 25 ?? ?? ?? ?? 00 EB 07 83 0D ?? ?? ?? ?? FF 8B 85 3C FF FF FF 8B BD 48 FF FF FF 8B 9D 44 FF FF FF A3 ?? ?? ?? ?? 8B 85 40 FF FF FF A3 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 6A 00 68 10 27 00 00 57 53 66 89 46 0C E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 6A 00 81 C3 00 80 C1 2A 68 80 96 98 00 81 D7 21 4E 62 FE 57 53 66 89 46 08 E8 ?? ?? ?? ?? 89 06 89 56 04 33 C0 5B E9 D2 FE FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__SEH_prolog4_GS"
		size = 72
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 89 45 E4 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "_rename"
		size = 51
		refs = "000d __imp__MoveFileA@8 0017 __imp__GetLastError@0 0025 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_778_0_0 {
	meta:
		name = "__wrename"
		size = 51
		refs = "000d __imp__MoveFileW@8 0017 __imp__GetLastError@0 0025 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "?_open@@YAHPBDHH@Z"
		size = 45
		refs = "0018 __sopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_130_2_0 {
	meta:
		name = "?_wopen@@YAHPB_WHH@Z"
		size = 45
		refs = "0018 __wsopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_130_1_0 {
	meta:
		name = "?_sopen@@YAHPBDHHH@Z"
		size = 46
		refs = "0019 __sopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_130_3_0 {
	meta:
		name = "?_wsopen@@YAHPB_WHHH@Z"
		size = 46
		refs = "0019 __wsopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "__lseeki64_nolock"
		size = 133
		refs = "001a __get_osfhandle 0027 __errno 0044 __imp__SetFilePointer@16 0051 __imp__GetLastError@0 005b __dosmaperr 006a ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 56 8B 75 08 89 45 F8 8B 45 10 57 56 89 45 FC E8 ?? ?? ?? ?? 83 CF FF 59 3B C7 75 11 E8 ?? ?? ?? ?? C7 00 09 00 00 00 8B C7 8B D7 EB 4A FF 75 14 8D 4D FC 51 FF 75 F8 50 FF 15 ?? ?? ?? ?? 89 45 F8 3B C7 75 13 FF 15 ?? ?? ?? ?? 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 EB CF 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 8D 44 30 04 80 20 FD 8B 45 F8 8B 55 FC 5F 5E C9 C3 }
	condition:
		$1
}

rule file_131_1_0 {
	meta:
		name = "__lseeki64"
		size = 234
		refs = "0003 __sehtable$__lseeki64 0008 __SEH_prolog4 001e ___doserrno 0026 __errno 003f __nhandle 0059 __invalid_parameter_noinfo 0067 ___pioinfo 0081 ___lock_fhandle 00a0 __lseeki64_nolock 00db __SEH_epilog4 00e4 __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 CB FF 89 5D DC 89 5D E0 8B 45 08 83 F8 FE 75 1C E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 8B C3 8B D3 E9 A1 00 00 00 85 C0 78 08 3B 05 ?? ?? ?? ?? 72 1A E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB D1 8B C8 C1 F9 05 8D 3C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0F 0F BE 4C 31 04 83 E1 01 74 C6 50 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 07 F6 44 30 04 01 74 1C FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC 89 55 E0 EB 19 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 89 5D DC 89 5D E0 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 DC 8B 55 E0 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__isatty"
		size = 86
		refs = "000e __errno 0022 __nhandle 0034 __invalid_parameter_noinfo 0045 ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 F8 FE 75 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 33 C0 5D C3 85 C0 78 08 3B 05 ?? ?? ?? ?? 72 12 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB DE 8B C8 83 E0 1F C1 F9 05 8B 0C 8D ?? ?? ?? ?? C1 E0 06 0F BE 44 01 04 83 E0 40 5D C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__fsqrt"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 45 08 D9 FA DD 5D F8 DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_CallDestructExceptionObject"
		size = 56
		refs = "0013 __pDestructExceptionObject 0020 __IsNonwritableInCurrentImage"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 81 3E 63 73 6D E0 75 24 83 3D ?? ?? ?? ?? 00 74 1B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 0C FF 75 0C 56 FF 15 ?? ?? ?? ?? 59 59 5E 5D C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__eof"
		size = 276
		refs = "0003 __sehtable$__eof 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0050 __invalid_parameter_noinfo 005e ___pioinfo 0078 ___lock_fhandle 0091 __lseeki64_nolock 0105 __SEH_epilog4 010e __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 D5 00 00 00 33 DB 3B C3 7C 08 3B 05 ?? ?? ?? ?? 72 19 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB D1 8B C8 C1 F9 05 8D 3C 8D ?? ?? ?? ?? 8B F0 83 E6 1F C1 E6 06 8B 0F 0F BE 4C 31 04 83 E1 01 74 C7 50 E8 ?? ?? ?? ?? 59 89 5D FC 8B 07 F6 44 30 04 01 74 56 6A 01 53 53 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B F0 8B FA 23 C7 83 F8 FF 74 4E 6A 02 53 53 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B C8 23 CA 83 F9 FF 74 36 3B F0 75 0D 3B FA 75 09 C7 45 E4 01 00 00 00 EB 29 53 57 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 5D E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 18 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsW"
		size = 88
		refs = "0005 __imp__GetEnvironmentStringsW@0 0033 __malloc_crt 0041 __imp__FreeEnvironmentStringsW@4 004f _memcpy"
	strings:
		$1 = { 8B FF 56 FF 15 ?? ?? ?? ?? 8B F0 33 C9 3B F1 75 04 33 C0 5E C3 66 39 0E 74 10 83 C0 02 66 39 08 75 F8 83 C0 02 66 39 08 75 F0 53 2B C6 8D 58 02 57 53 E8 ?? ?? ?? ?? 8B F8 59 85 FF 75 0D 56 FF 15 ?? ?? ?? ?? 8B C7 5F 5B 5E C3 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C EB E6 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__strnset_s"
		size = 112
		refs = "002e __errno 0038 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 8B 75 14 33 D2 57 3B F2 75 0F 3B CA 75 0F 39 55 0C 75 11 33 C0 5F 5E 5D C3 3B CA 74 07 8B 7D 0C 3B FA 77 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB DE 8B C1 38 11 74 14 53 3B F2 76 0E 4F 74 0B 8A 5D 10 88 18 40 4E 38 10 75 EE 5B 3B F2 75 0A EB 04 4F 74 05 40 38 10 75 F8 3B FA 75 B0 88 11 EB BD }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "__tell"
		size = 22
		refs = "000d __lseek"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__fwrite_nolock"
		size = 343
		refs = "0020 __errno 002b __invalid_parameter_noinfo 009c _memcpy 00ba __flush 00da __fileno 00e1 __write 010c __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 57 8B 7D 0C 85 FF 74 1D 83 7D 10 00 74 17 8B 75 14 85 F6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 5F 5E 5B C9 C3 8B 4D 08 85 C9 74 E2 83 C8 FF 33 D2 F7 F7 39 45 10 77 D6 0F AF 7D 10 F7 46 0C 0C 01 00 00 89 4D FC 89 7D F4 8B DF 74 08 8B 46 18 89 45 F8 EB 07 C7 45 F8 00 10 00 00 85 FF 0F 84 BF 00 00 00 8B 4E 0C 81 E1 08 01 00 00 74 2F 8B 46 04 85 C0 74 28 0F 88 AF 00 00 00 8B FB 3B D8 72 02 8B F8 57 FF 75 FC FF 36 E8 ?? ?? ?? ?? 29 7E 04 01 3E 83 C4 0C 2B DF 01 7D FC EB 4F 3B 5D F8 72 4F 85 C9 74 0B 56 E8 ?? ?? ?? ?? 59 85 C0 75 7D 83 7D F8 00 8B FB 74 09 33 D2 8B C3 F7 75 F8 2B FA 57 FF 75 FC 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 61 8B CF 3B C7 77 02 8B C8 01 4D FC 2B D9 3B C7 72 50 8B 7D F4 EB 29 8B 45 FC 0F BE 00 56 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 74 29 FF 45 FC 8B 46 18 4B 89 45 F8 85 C0 7F 07 C7 45 F8 01 00 00 00 85 DB 0F 85 41 FF FF FF 8B 45 10 E9 F5 FE FF FF 83 4E 0C 20 8B C7 2B C3 33 D2 F7 75 0C E9 E3 FE FF FF 83 4E 0C 20 8B 45 F4 EB EB }
	condition:
		$1
}

rule file_145_1_0 {
	meta:
		name = "_fwrite"
		size = 122
		refs = "0003 __sehtable$_fwrite 0008 __SEH_prolog4 0025 __errno 0030 __invalid_parameter_noinfo 0037 __SEH_epilog4 0040 __lock_file 0055 __fwrite_nolock 0074 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 75 0C 74 21 39 75 10 74 1C 33 C0 39 75 14 0F 95 C0 3B C6 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? C3 FF 75 14 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 05 00 00 00 8B 45 E4 EB C6 FF 75 14 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__getdllprocaddr"
		size = 49
		refs = "001c __imp__GetProcAddress@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 00 75 17 81 7D 10 FF FF 00 00 7F 19 FF 75 10 FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 83 7D 10 FF 75 05 FF 75 0C EB EA 33 C0 5D C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 25
		refs = "000e ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_22_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QAE@PAV123@@Z"
		size = 25
		refs = "000e ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_863_7_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 25
		refs = "000e ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_8_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 25
		refs = "000e ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_369_241_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 25
		refs = "000e ?_Acquire@_NonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_991_2_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 25
		refs = "000e ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_487_4_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QAE@AAV123@@Z"
		size = 25
		refs = "000e ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_347_77_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 25
		refs = "000e ?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 89 0E E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_147_6_0 {
	meta:
		name = "?SetOversubscribedVProc@InternalContextBase@details@Concurrency@@QAEXPAVVirtualProcessor@23@@Z"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 81 88 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_147_10_0 {
	meta:
		name = "??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z"
		size = 72
		altNames = "??A?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QBEPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@12@H@Z ??A?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QBEPAVExternalStatistics@12@H@Z ??A?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QBEPAVScheduleGroupBase@12@H@Z ??A?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QBEPAVWorkQueue@12@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 8B C1 8B 48 2C D3 FA 3B 50 3C 7C 04 33 C0 EB 2C 8B 48 34 56 8B 70 38 3B D6 7C 11 2B D6 8B 4C B1 FC 78 0C 42 4A 8B 49 04 75 FA EB 03 8B 0C 91 8B 40 28 8B 09 48 23 45 08 5E 8B 04 81 5D C2 04 00 }
	condition:
		$1
}

rule file_147_11_0 {
	meta:
		name = "?PullFromFreePool@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEPAVVirtualProcessor@23@XZ"
		size = 20
		refs = "0005 __imp__InterlockedPopEntrySList@4"
	strings:
		$1 = { 8B FF 51 FF 15 ?? ?? ?? ?? 85 C0 75 01 C3 05 74 FF FF FF C3 }
	condition:
		$1
}

rule file_147_16_0 {
	meta:
		name = "?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 41
		altNames = "?UnlockedSteal@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 8B 41 04 8B 11 3B D0 7D 1D 8B 11 56 8B 71 08 57 8B 79 0C 23 F2 33 C0 8D 34 B7 87 06 5F 5E 85 C0 74 06 42 89 11 C3 33 C0 C3 }
	condition:
		$1
}

rule file_147_17_0 {
	meta:
		name = "??0ArrayNode@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAPAVVirtualProcessor@23@@Z"
		size = 24
		altNames = "??0ArrayNode@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAPAU?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@23@@Z ??0ArrayNode@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAPAVExternalStatistics@23@@Z ??0ArrayNode@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAPAVScheduleGroupBase@23@@Z ??0ArrayNode@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAPAVWorkQueue@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 8B 4D 08 83 60 04 00 83 48 08 FF 89 08 5D C2 04 00 }
	condition:
		$1
}

rule file_147_19_0 {
	meta:
		name = "??$_InternalDeleteHelper@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@YAXPAVVirtualProcessor@01@@Z"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 74 06 8B 01 6A 01 FF 10 5D C3 }
	condition:
		$1
}

rule file_147_20_0 {
	meta:
		name = "?FindMatchingVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAUIVirtualProcessorRoot@3@@Z"
		size = 54
		refs = "0018 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 71 58 57 33 FF 85 F6 7E 1C 8D 59 18 57 8B CB E8 ?? ?? ?? ?? 85 C0 74 08 8B 48 4C 3B 4D 08 74 07 47 3B FE 7C E7 33 C0 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_147_21_0 {
	meta:
		name = "?FindAvailableVirtualProcessor@SchedulingNode@details@Concurrency@@AAEPAVVirtualProcessor@23@PAV423@@Z"
		size = 100
		refs = "0019 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NXZ 0034 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 57 8B F9 85 F6 74 15 80 7E 7B 00 75 0F 8B CE E8 ?? ?? ?? ?? 84 C0 74 04 8B C6 EB 35 8B 47 58 53 33 DB 85 C0 7E 28 53 8D 4F 18 E8 ?? ?? ?? ?? 8B F0 85 F6 74 11 80 7E 7B 00 75 0B 8B CE E8 ?? ?? ?? ?? 84 C0 75 11 8B 47 58 43 3B D8 7C D8 33 C0 5B 5F 5E 5D C2 04 00 8B C6 EB F5 }
	condition:
		$1
}

rule file_147_22_0 {
	meta:
		name = "?CheckForNewOwningRing@SchedulingNode@details@Concurrency@@AAEXXZ"
		size = 228
		refs = "000c ___security_cookie 0028 __alloca_probe_16 003c _memset 0057 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z 00de @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 08 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B F1 8B 06 8B 40 24 57 83 F8 40 7E 08 C1 E0 02 E8 ?? ?? ?? ?? 68 00 01 00 00 33 DB 8D 85 FC FE FF FF 53 50 E8 ?? ?? ?? ?? 8B 46 58 83 C4 0C 33 FF 89 9D F8 FE FF FF 85 C0 7E 38 53 8D 4E 18 E8 ?? ?? ?? ?? 85 C0 74 23 8B 48 44 8B 49 64 8D 8C 8D FC FE FF FF FF 01 8B 09 3B CF 7E 0E 8B 40 44 8B 40 64 8B F9 89 85 F8 FE FF FF 8B 46 58 43 3B D8 7C C8 8B 46 58 33 FF 85 C0 7E 3C 57 8D 4E 18 E8 ?? ?? ?? ?? 85 C0 74 27 8B 0E 8B 49 20 8B 95 F8 FE FF FF 8B 0C 91 89 48 48 33 C9 83 C0 54 87 08 83 F9 01 75 0A 8D 46 10 83 C9 FF F0 0F C1 08 8B 46 58 47 3B F8 7C C4 8D A5 EC FE FF FF 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_147_23_0 {
	meta:
		name = "??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
		size = 241
		refs = "0075 ??_U@YAPAXI@Z 0085 _memset 008c ??2@YAPAXI@Z 00c0 __imp__InitializeSListHead@4"
		altNames = "??0?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z ??0?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z ??0?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z ??0?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 53 56 8B F1 89 46 24 8B 45 10 33 DB 89 46 44 8B 45 0C 89 5E 10 89 5E 2C 89 5E 30 C7 46 38 00 02 00 00 C7 46 3C 01 00 00 00 8D 48 FF 89 5E 40 57 89 5E 48 85 C8 74 23 8B C8 D1 F9 0B C1 8B C8 C1 F9 02 0B C1 8B C8 C1 F9 04 0B C1 8B C8 C1 F9 08 0B C1 8B C8 C1 F9 10 0B C1 40 33 C9 6A 04 5A 89 46 28 F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B F8 8B 46 28 C1 E0 02 50 53 57 E8 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 14 3B C3 74 0B 83 48 08 FF 89 38 89 58 04 EB 02 33 C0 89 46 30 8B 46 38 33 C9 6A 04 5A F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 59 8B 4E 30 89 46 34 56 89 08 FF D7 8D 46 08 50 FF D7 8B 46 28 D1 F8 74 0B 8B 4E 2C 41 D1 F8 75 FB 89 4E 2C 5F 8B C6 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_147_24_0 {
	meta:
		name = "?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 37
		refs = "000c ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ 0013 ?UnlockedSteal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 001c ?_Release@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 57 8B 7E 10 8B CF E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B CF 8B F0 E8 ?? ?? ?? ?? 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_147_26_0 {
	meta:
		name = "?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z"
		size = 38
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 EB 12 8D 8E 74 FF FF FF 8B 36 85 C9 74 06 8B 01 6A 01 FF 10 85 F6 75 EA 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_147_27_0 {
	meta:
		name = "?StealLocalRunnableContext@SchedulingNode@details@Concurrency@@AAEPAVInternalContextBase@23@PAVVirtualProcessor@23@@Z"
		size = 91
		refs = "0035 ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z 0041 ?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 53 8B 59 58 56 33 F6 57 89 75 FC 3B C6 74 06 8B 78 58 46 EB 02 33 FF 3B F3 7D 2D 83 C1 18 89 4D 08 8D 04 3E 99 F7 FB 8B 4D 08 52 E8 ?? ?? ?? ?? 85 C0 74 0F 8D 48 08 E8 ?? ?? ?? ?? 89 45 FC 85 C0 75 05 46 3B F3 7C D9 8B 45 FC 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_147_29_0 {
	meta:
		name = "??1?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 120
		refs = "0006 __imp__InterlockedFlushSList@4 0013 ?DeleteElements@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AAEXPAU_SINGLE_LIST_ENTRY@@@Z 0059 ??_V@YAXPAX@Z 005f ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 56 57 8B 3D ?? ?? ?? ?? 8B F1 56 FF D7 50 8B CE E8 ?? ?? ?? ?? 8D 46 08 50 FF D7 50 8B CE E8 ?? ?? ?? ?? FF 76 10 8B CE E8 ?? ?? ?? ?? 8B 7E 30 85 FF 74 36 53 33 DB 39 5E 28 7E 15 8B 07 8B 0C 98 85 C9 74 06 8B 01 6A 01 FF 10 43 3B 5E 28 7C EB FF 37 8B 5F 04 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 8B FB 85 DB 75 CC 5B FF 76 34 E8 ?? ?? ?? ?? 59 5F 5E C3 }
	condition:
		$1
}

rule file_147_30_0 {
	meta:
		name = "?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEHPAVVirtualProcessor@23@@Z"
		size = 337
		refs = "00cd ??_U@YAPAXI@Z 00df _memset 00e6 ??2@YAPAXI@Z 0125 ?_UnderlyingYield@details@Concurrency@@YAXXZ 012d ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 83 65 F8 00 53 56 8B F1 8B 5E 30 57 C6 45 FF 00 89 5D F0 83 7B 08 FF 7C 66 8B 03 33 C9 39 4E 28 7E 5D 89 45 F4 8B 45 F4 83 38 00 75 21 8B 45 F8 8B 5D F4 8D 14 01 8B 45 08 89 50 58 8B 56 40 8B F8 33 C0 F0 0F B1 3B 85 C0 74 0F 8B 5D F0 83 45 F4 04 41 3B 4E 28 7C CD EB 25 01 4D F8 C6 45 FF 01 39 55 F8 7C 0A 33 D2 8D 46 40 42 F0 0F C1 10 8B 5D F0 83 CA FF 8D 7B 08 8B C1 F0 0F B1 17 80 7D FF 00 0F 85 A6 00 00 00 6A FE 59 8D 53 08 83 C8 FF F0 0F B1 0A 8B 46 28 01 45 F8 83 7B 04 00 75 6E 33 C9 41 8D 53 04 33 C0 F0 0F B1 0A 85 C0 75 5E 8B 46 28 33 C9 6A 04 5A F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 8B 4E 28 C1 E1 02 51 6A 00 50 89 45 F0 E8 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0F 8B 4D F0 83 60 04 00 83 48 08 FF 89 08 EB 02 33 C0 8B 4E 3C 3B 4E 38 7D 09 8B 56 34 89 04 8A FF 46 3C 8D 4B 04 87 01 83 7B 04 01 75 19 83 65 E8 00 C7 45 EC ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 83 7B 04 01 74 F2 80 7D FF 00 8B 5B 04 89 5D F0 0F 84 D4 FE FF FF 8B 45 F8 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_147_31_0 {
	meta:
		name = "??0SchedulingNode@details@Concurrency@@QAE@PAVSchedulingRing@12@@Z"
		size = 65
		refs = "0029 ??0?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAE@PAVSchedulerBase@12@HH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B F1 33 C9 89 46 04 89 4E 08 68 FF FF FF 7F 89 4E 0C 89 4E 10 68 00 01 00 00 FF 30 8D 4E 18 E8 ?? ?? ?? ?? 8B 46 04 8B 08 89 0E 8B 40 64 89 46 14 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_147_33_0 {
	meta:
		name = "?AddVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAUIVirtualProcessorRoot@3@_N@Z"
		size = 279
		refs = "0012 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0020 ?PullFromFreePool@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEPAVVirtualProcessor@23@XZ 006a ?ThrottlingTime@SchedulerBase@details@Concurrency@@QAEKK@Z 00a8 ?Add@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QAEHPAVVirtualProcessor@23@@Z 00b0 ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QAE_N_N@Z 00c0 ?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 00d0 ?GetAnonymousScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 57 8B F1 C6 45 FF 00 E8 ?? ?? ?? ?? 8D 4E 18 89 45 F4 89 4D F8 E8 ?? ?? ?? ?? FF 75 08 8B F8 56 85 FF 75 0B 8B 0E 8B 01 FF 50 50 8B F8 EB 07 8B 07 8B CF FF 50 18 33 DB 43 80 7D 0C 00 74 2F 8B 45 F4 83 C0 FC 88 5F 78 89 47 7C 89 B8 88 00 00 00 8B 0E 8B 01 FF 50 2C 84 C0 74 60 8B 0E 53 E8 ?? ?? ?? ?? 85 C0 74 54 88 5D FF 88 5F 7B 8D 46 0C 8B CB F0 0F C1 08 80 7D FF 00 75 76 8B 06 8B 80 FC 00 00 00 85 C0 75 4B 8B 06 8B 40 14 85 C0 7E 42 33 C0 8D 4F 04 87 01 8B 4D F8 57 E8 ?? ?? ?? ?? 8B 0E 53 E8 ?? ?? ?? ?? 84 C0 74 56 8B 4D F4 85 C9 74 0D E8 ?? ?? ?? ?? EB 0E C6 45 FF 00 EB AC 8B 4E 04 E8 ?? ?? ?? ?? 8B 17 50 8B CF FF 52 1C EB 30 8D 46 08 8B CB F0 0F C1 08 8B 06 05 FC 00 00 00 F0 0F C1 18 8B 4D F8 57 E8 ?? ?? ?? ?? EB 11 8B 4D F8 57 E8 ?? ?? ?? ?? 8B 0E 8B 01 57 FF 50 30 8B C7 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__strset"
		size = 33
	strings:
		$1 = { 55 8B EC 57 8B 7D 08 8B D7 33 C0 83 C9 FF F2 AE 83 C1 02 F7 D9 8A 45 0C 8B FA F3 AA 8B C2 5F C9 C3 }
	condition:
		$1
}

rule file_149_3_0 {
	meta:
		name = "__mbspbrk_l"
		size = 197
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 _strpbrk 0039 __errno 0044 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F4 33 DB 39 5E 08 75 12 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 84 00 00 00 8B 4D 08 3B CB 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 69 39 5D 0C 74 DB 38 19 74 4B 57 8B 45 0C EB 28 8A 10 0F B6 FA F6 44 37 1D 04 74 17 3A 11 75 08 8A 50 01 3A 51 01 74 14 8D 50 01 38 1A 74 0D 8B C2 EB 04 3A 11 74 05 40 38 18 75 D4 38 18 75 14 0F B6 01 F6 44 30 1D 04 74 05 41 38 19 74 05 41 38 19 75 B7 5F 0F B6 01 F7 D8 1B C0 23 C1 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "_wcstok_s"
		size = 222
		refs = "000e __errno 0019 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 10 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 C9 C3 56 8B 75 0C 85 F6 74 0D 8B 4D 08 85 C9 75 1D 8B 08 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 8E 00 00 00 0F B7 11 57 66 85 D2 74 2E 0F B7 3E 8B 75 0C 66 85 FF 74 12 8B C7 66 3B C2 74 0B 83 C6 02 0F B7 06 66 85 C0 75 F0 66 83 3E 00 74 0B 83 C1 02 0F B7 11 66 85 D2 75 D5 66 83 39 00 89 4D FC 74 3C 8B 45 0C 0F B7 38 8B 55 0C 66 85 FF 74 15 0F B7 31 8B C7 66 3B C6 74 0B 83 C2 02 0F B7 02 66 85 C0 75 F0 66 83 3A 00 75 0B 83 C1 02 66 83 39 00 75 D4 EB 08 33 C0 66 89 01 83 C1 02 8B 45 10 89 08 8B 45 FC 2B C1 F7 D8 1B C0 23 45 FC 5F 5E C9 C3 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "_strcpy_s"
		size = 95
		refs = "0016 __errno 0020 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 57 85 D2 74 07 8B 7D 0C 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 33 8B 45 10 85 C0 75 04 88 02 EB E2 8B F2 2B F0 8A 08 88 0C 06 40 84 C9 74 03 4F 75 F3 85 FF 75 11 C6 02 00 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB C6 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_153_3_0 {
	meta:
		name = "__gcvt_s"
		size = 316
		refs = "0009 ___security_cookie 001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 __errno 0030 __invalid_parameter_noinfo 008a __fltout2 00ad __cftof 00c1 __cftoe 0136 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 08 6A 00 8D 4D D4 E8 ?? ?? ?? ?? 85 FF 75 25 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 80 7D E0 00 0F 84 EE 00 00 00 8B 45 DC 83 60 70 FD E9 E2 00 00 00 53 8B 5D 0C 85 DB 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 B8 00 00 00 8B 75 18 C6 07 00 3B F3 72 09 E8 ?? ?? ?? ?? 6A 22 EB E0 6A 16 8D 45 E4 50 8D 45 C4 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 8B 40 04 8D 48 FF 83 C4 14 83 F9 FF 7C 1A 8D 56 FF 3B CA 7F 13 2B F0 56 53 8D 45 10 57 50 E8 ?? ?? ?? ?? 83 C4 10 EB 12 6A 00 4E 56 53 8D 45 10 57 50 E8 ?? ?? ?? ?? 83 C4 14 8B F0 85 F6 75 49 8A 0F 8B C7 84 C9 74 18 8B 55 D4 8B 92 BC 00 00 00 8B 12 8A 12 3A CA 74 07 40 8A 08 84 C9 75 F5 8A 08 40 84 C9 74 29 EB 06 80 F9 65 74 07 40 8A 08 84 C9 75 F4 8B D0 48 80 38 30 74 FA 8A 0A 40 42 88 08 84 C9 75 F6 EB 07 E8 ?? ?? ?? ?? 89 30 80 7D E0 00 74 07 8B 45 DC 83 60 70 FD 5B 8B 4D FC 5F 8B C6 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_153_4_0 {
	meta:
		name = "__gcvt"
		size = 40
		refs = "0016 __gcvt_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 DD 45 08 51 51 DD 1C 24 6A FF FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 F7 D8 1B C0 F7 D0 23 45 14 5D C3 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__swab"
		size = 79
		refs = "000d __errno 0019 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 75 11 E8 ?? ?? ?? ?? C7 00 16 00 00 00 5D E9 ?? ?? ?? ?? 8B 45 0C 85 C0 74 E8 8B 55 10 85 D2 78 E1 83 FA 01 7E 1D 53 56 8D 72 FE D1 EE 46 8A 59 01 8A 11 88 18 83 C1 02 88 50 01 83 C0 02 4E 75 ED 5E 5B 5D C3 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__allmul"
		size = 52
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 10 0B C8 8B 4C 24 0C 75 09 8B 44 24 04 F7 E1 C2 10 00 53 F7 E1 8B D8 8B 44 24 08 F7 64 24 14 03 D8 8B 44 24 08 F7 E1 03 D3 5B C2 10 00 }
	condition:
		$1
}

rule file_156_2_0 {
	meta:
		name = "___shr_12"
		size = 50
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 50 08 8B 48 04 56 57 8B F9 8B F2 D1 E9 C1 E6 1F 0B CE 89 48 04 8B 08 C1 E7 1F D1 EA D1 E9 0B CF 5F 89 50 08 89 08 5E 5D C3 }
	condition:
		$1
}

rule file_156_3_0 {
	meta:
		name = "___ld12mul"
		size = 635
		refs = "0009 ___security_cookie 0275 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 33 C9 53 8B 5D 0C 0F B7 53 0A 56 89 4D D4 89 4D F0 89 4D F4 89 4D F8 0F B7 48 0A 8B F2 33 F1 81 E6 00 80 00 00 89 75 E0 BE FF 7F 00 00 23 CE 23 D6 8D 34 0A 57 0F B7 F6 BF FF 7F 00 00 89 75 D0 66 3B CF 0F 83 EE 01 00 00 66 3B D7 0F 83 E5 01 00 00 BF FD BF 00 00 66 3B F7 0F 87 D7 01 00 00 BF BF 3F 00 00 66 3B F7 77 0A 33 C9 89 48 08 E9 DE 01 00 00 BF FF FF FF 7F 66 85 C9 75 1D 46 89 75 D0 85 78 08 75 14 33 C9 39 48 04 75 0F 39 08 75 0B 66 89 48 0A E9 BC 01 00 00 33 C9 66 3B D1 75 12 46 89 75 D0 85 7B 08 75 09 39 4B 04 75 04 39 0B 74 B8 89 4D E4 8D 7D F4 C7 45 E8 05 00 00 00 8B 4D E4 8B 55 E8 03 C9 89 55 D8 85 D2 7E 50 83 C3 08 89 5D DC 8D 1C 08 8B 55 DC 0F B7 12 0F B7 0B 83 65 EC 00 0F AF CA 8B 57 FC 8D 34 0A 3B F2 72 04 3B F1 73 07 C7 45 EC 01 00 00 00 83 7D EC 00 89 77 FC 74 03 66 FF 07 83 6D DC 02 83 C3 02 FF 4D D8 83 7D D8 00 7F BF 8B 5D 0C 8B 75 D0 83 C7 02 FF 45 E4 FF 4D E8 83 7D E8 00 7F 92 81 C6 02 C0 00 00 BF FF FF 00 00 66 85 F6 7E 38 F7 45 F8 00 00 00 80 75 2A 8B 4D F0 8B 5D F4 8B 55 F4 D1 65 F0 C1 E9 1F 03 DB 0B D9 8B 4D F8 C1 EA 1F 03 C9 0B CA 03 F7 89 5D F4 89 4D F8 66 85 F6 7F CD 66 85 F6 7F 4F 03 F7 66 85 F6 79 48 8B CE F7 D9 0F B7 C9 89 4D EC 03 F1 F6 45 F0 01 74 03 FF 45 D4 8B 4D F8 8B 5D F4 8B 55 F4 D1 6D F8 C1 E1 1F D1 EB 0B D9 8B 4D F0 C1 E2 1F D1 E9 0B CA FF 4D EC 89 5D F4 89 4D F0 75 CF 83 7D D4 00 74 05 66 83 4D F0 01 B9 00 80 00 00 66 39 4D F0 77 11 8B 55 F0 81 E2 FF FF 01 00 81 FA 00 80 01 00 75 2F 83 7D F2 FF 75 26 83 65 F2 00 83 7D F6 FF 75 17 83 65 F6 00 66 39 7D FA 75 07 66 89 4D FA 46 EB 0E 66 FF 45 FA EB 08 FF 45 F6 EB 03 FF 45 F2 B9 FF 7F 00 00 66 3B F1 73 1C 66 8B 4D F2 0B 75 E0 66 89 08 8B 4D F4 89 48 02 8B 4D F8 89 48 06 66 89 70 0A EB 20 33 D2 33 C9 66 39 4D E0 0F 94 C2 4A 81 E2 00 00 00 80 81 C2 00 80 FF 7F 89 50 08 89 08 89 48 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_156_4_0 {
	meta:
		name = "___multtenpow12"
		size = 767
		refs = "0009 ___security_cookie 0016 __pow10pos 0031 __pow10neg 02f9 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 B9 ?? ?? ?? ?? 83 E9 60 33 D2 89 4D DC 39 55 0C 0F 84 C8 02 00 00 7D 0E F7 5D 0C B9 ?? ?? ?? ?? 83 E9 60 89 4D DC 39 55 10 75 05 33 C9 66 89 08 39 55 0C 0F 84 A5 02 00 00 53 56 57 8B 4D 0C 83 45 DC 54 C1 7D 0C 03 83 E1 07 3B CA 0F 84 7E 02 00 00 6B C9 0C 03 4D DC 8B D9 B9 00 80 00 00 66 39 0B 72 0E 8B F3 8D 7D E4 A5 A5 A5 FF 4D E6 8D 5D E4 0F B7 48 0A 89 55 C8 89 55 F0 89 55 F4 89 55 F8 0F B7 53 0A 8B F2 33 F1 81 E6 00 80 00 00 89 75 D0 BE FF 7F 00 00 23 CE 23 D6 8D 3C 0A 0F B7 FF 89 7D D8 66 3B CE 0F 83 02 02 00 00 66 3B D6 0F 83 F9 01 00 00 BE FD BF 00 00 66 3B FE 0F 87 EB 01 00 00 BE BF 3F 00 00 66 3B FE 77 0A 33 C9 89 48 08 E9 F2 01 00 00 33 F6 66 3B CE 75 21 47 F7 40 08 FF FF FF 7F 89 7D D8 75 14 39 70 04 75 0F 39 30 75 0B 33 C9 66 89 48 0A E9 CF 01 00 00 66 3B D6 75 23 47 F7 43 08 FF FF FF 7F 89 7D D8 75 16 39 73 04 75 11 39 33 75 0D 89 70 08 89 70 04 89 30 E9 A7 01 00 00 89 75 CC 8D 75 F4 C7 45 E0 05 00 00 00 8B 4D CC 8B 55 E0 03 C9 89 55 D4 85 D2 7E 53 8D 53 08 03 C8 89 55 C0 89 4D C4 8B 4D C4 8B 55 C0 0F B7 12 0F B7 09 83 65 BC 00 0F AF CA 8B 56 FC 8D 3C 0A 3B FA 72 04 3B F9 73 07 C7 45 BC 01 00 00 00 83 7D BC 00 89 7E FC 74 03 66 FF 06 83 45 C4 02 83 6D C0 02 FF 4D D4 83 7D D4 00 7F BB 8B 7D D8 83 C6 02 FF 45 CC FF 4D E0 83 7D E0 00 7F 8F 81 C7 02 C0 00 00 66 85 FF 7E 3B F7 45 F8 00 00 00 80 75 2D 8B 75 F4 8B 4D F0 D1 65 F0 C1 E9 1F 8B D6 03 F6 0B F1 8B 4D F8 C1 EA 1F 03 C9 0B CA 81 C7 FF FF 00 00 89 75 F4 89 4D F8 66 85 FF 7F CA 66 85 FF 7F 4D 81 C7 FF FF 00 00 66 85 FF 79 42 8B CF F7 D9 0F B7 F1 03 FE F6 45 F0 01 74 03 FF 45 C8 8B 4D F8 8B 5D F4 8B 55 F4 D1 6D F8 C1 E1 1F D1 EB 0B D9 8B 4D F0 C1 E2 1F D1 E9 0B CA 4E 89 5D F4 89 4D F0 75 D1 39 75 C8 74 05 66 83 4D F0 01 B9 00 80 00 00 66 39 4D F0 77 11 8B 55 F0 81 E2 FF FF 01 00 81 FA 00 80 01 00 75 34 83 7D F2 FF 75 2B 83 65 F2 00 83 7D F6 FF 75 1C 83 65 F6 00 BA FF FF 00 00 66 39 55 FA 75 07 66 89 4D FA 47 EB 0E 66 FF 45 FA EB 08 FF 45 F6 EB 03 FF 45 F2 B9 FF 7F 00 00 66 3B F9 73 1C 66 8B 4D F2 0B 7D D0 66 89 08 8B 4D F4 89 48 02 8B 4D F8 89 48 06 66 89 78 0A EB 20 33 D2 33 C9 66 39 4D D0 0F 94 C2 4A 81 E2 00 00 00 80 81 C2 00 80 FF 7F 89 50 08 89 48 04 89 08 33 D2 39 55 0C 0F 85 61 FD FF FF 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_156_5_0 {
	meta:
		name = "___strgtold12_l"
		size = 1756
		refs = "0009 ___security_cookie 0049 __errno 0054 __invalid_parameter_noinfo 008c $LN276 030c ___mtold12 0349 __pow10pos 0360 __pow10neg 06a3 @__security_check_cookie@4 06ac $LN119 06b0 $LN108 06b4 $LN97 06b8 $LN88 06bc $LN75 06c0 $LN61 06c4 $LN58 06c8 $LN43 06cc $LN49 06d0 $LN36 06d4 $LN254 06d8 $LN28"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 33 C9 56 33 F6 89 45 88 8B 45 0C 46 57 89 45 90 8D 7D E0 89 4D 8C 89 75 98 89 4D B4 89 4D A8 89 4D A4 89 4D A0 89 4D 9C 89 4D B0 89 4D 94 39 4D 24 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 3C 06 00 00 8B 55 10 89 55 AC 8A 02 3C 20 74 0C 3C 09 74 08 3C 0A 74 04 3C 0D 75 03 42 EB EB 53 B3 30 8A 02 42 83 F9 0B 0F 87 1C 02 00 00 FF 24 8D ?? ?? ?? ?? 8D 48 CF 80 F9 08 77 06 6A 03 59 4A EB DF 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 75 05 6A 05 59 EB C9 0F BE C0 83 E8 2B 74 1D 48 48 74 0D 83 E8 03 0F 85 7C 01 00 00 8B CE EB B0 6A 02 59 C7 45 8C 00 80 00 00 EB A4 83 65 8C 00 6A 02 59 EB 9B 8D 48 CF 89 75 A8 80 F9 08 76 AB 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 75 04 6A 04 EB AF 3C 2B 74 22 3C 2D 74 1E 3A C3 74 BB 3C 43 0F 8E 2F 01 00 00 3C 45 7E 0A 2C 64 3C 01 0F 87 21 01 00 00 6A 06 EB 89 4A 6A 0B EB 84 8D 48 CF 80 F9 08 0F 86 5F FF FF FF 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 0F 84 61 FF FF FF 3A C3 0F 84 73 FF FF FF 8B 55 AC E9 10 01 00 00 89 75 A8 EB 1A 3C 39 7F 1A 83 7D B4 19 73 0A FF 45 B4 2A C3 88 07 47 EB 03 FF 45 B0 8A 02 42 3A C3 7D E2 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 0F 84 68 FF FF FF 3C 2B 74 8E 3C 2D 74 8A E9 6B FF FF FF 83 7D B4 00 89 75 A8 89 75 A4 75 26 EB 06 FF 4D B0 8A 02 42 3A C3 74 F6 EB 18 3C 39 7F D5 83 7D B4 19 73 0B FF 45 B4 2A C3 88 07 47 FF 4D B0 8A 02 42 3A C3 7D E4 EB BB 2A C3 89 75 A4 3C 09 0F 87 6E FF FF FF 6A 04 E9 AB FE FF FF 8D 4A FE 89 4D AC 8D 48 CF 80 F9 08 77 07 6A 09 E9 96 FE FF FF 0F BE C0 83 E8 2B 74 20 48 48 74 10 83 E8 03 0F 85 3D FF FF FF 6A 08 E9 91 FE FF FF 83 4D 98 FF 6A 07 59 E9 51 FE FF FF 6A 07 E9 7E FE FF FF 89 75 A0 EB 03 8A 02 42 3A C3 74 F9 2C 31 3C 08 76 B8 4A EB 26 8D 48 CF 80 F9 08 76 AD 3A C3 EB BF 83 7D 20 00 74 47 0F BE C0 83 E8 2B 8D 4A FF 89 4D AC 74 C4 48 48 74 B4 8B D1 83 7D A8 00 8B 45 90 89 10 0F 84 D8 03 00 00 6A 18 58 39 45 B4 76 10 80 7D F7 05 7C 03 FE 45 F7 4F FF 45 B0 89 45 B4 83 7D B4 00 0F 86 DD 03 00 00 EB 59 6A 0A 59 4A 83 F9 0A 0F 85 CF FD FF FF EB BE 89 75 A0 33 C9 EB 19 3C 39 7F 20 6B C9 0A 0F BE F0 8D 4C 31 D0 81 F9 50 14 00 00 7F 09 8A 02 42 3A C3 7D E3 EB 05 B9 51 14 00 00 89 4D 9C EB 0B 3C 39 0F 8F 5D FF FF FF 8A 02 42 3A C3 7D F1 E9 51 FF FF FF FF 4D B4 FF 45 B0 4F 80 3F 00 74 F4 8D 45 C4 50 FF 75 B4 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 45 9C 33 D2 83 C4 0C 39 55 98 7D 02 F7 D8 03 45 B0 39 55 A0 75 03 03 45 18 39 55 A4 75 03 2B 45 1C 3D 50 14 00 00 0F 8F 21 03 00 00 3D B0 EB FF FF 0F 8C 2D 03 00 00 B9 ?? ?? ?? ?? 83 E9 60 89 45 AC 3B C2 0F 84 E8 02 00 00 7D 0D F7 D8 B9 ?? ?? ?? ?? 89 45 AC 83 E9 60 39 55 14 75 06 33 C0 66 89 45 C4 39 55 AC 0F 84 C5 02 00 00 EB 05 8B 4D 84 33 D2 8B 45 AC C1 7D AC 03 83 C1 54 83 E0 07 89 4D 84 3B C2 0F 84 9C 02 00 00 6B C0 0C 8D 1C 01 B8 00 80 00 00 66 39 03 72 0E 8B F3 8D 7D B8 A5 A5 A5 FF 4D BA 8D 5D B8 8B 55 CE 33 C0 89 45 B0 89 45 D4 89 45 D8 89 45 DC 0F B7 43 0A 8B F0 33 75 CE B9 FF 7F 00 00 23 D1 23 C1 81 E6 00 80 00 00 BF FF 7F 00 00 8D 0C 10 89 75 90 0F B7 C9 66 3B D7 0F 83 20 02 00 00 66 3B C7 0F 83 17 02 00 00 BF FD BF 00 00 66 3B CF 0F 87 09 02 00 00 BE BF 3F 00 00 66 3B CE 77 0D 33 C0 89 45 C8 89 45 C4 E9 0D 02 00 00 33 F6 66 3B D6 75 1F 41 F7 45 CC FF FF FF 7F 75 15 39 75 C8 75 10 39 75 C4 75 0B 33 C0 66 89 45 CE E9 EA 01 00 00 66 3B C6 75 21 41 F7 43 08 FF FF FF 7F 75 17 39 73 04 75 12 39 33 75 0E 89 75 CC 89 75 C8 89 75 C4 E9 C4 01 00 00 89 75 98 8D 7D D8 C7 45 A8 05 00 00 00 8B 45 98 8B 55 A8 03 C0 89 55 9C 85 D2 7E 52 8D 44 05 C4 89 45 A4 8D 43 08 89 45 A0 8B 45 A0 8B 55 A4 0F B7 12 0F B7 00 83 65 B4 00 0F AF C2 8B 57 FC 8D 34 02 3B F2 72 04 3B F0 73 07 C7 45 B4 01 00 00 00 83 7D B4 00 89 77 FC 74 03 66 FF 07 83 45 A4 02 83 6D A0 02 FF 4D 9C 83 7D 9C 00 7F BB 83 C7 02 FF 45 98 FF 4D A8 83 7D A8 00 7F 90 81 C1 02 C0 00 00 66 85 C9 7E 37 8B 7D DC 85 FF 78 2B 8B 75 D8 8B 45 D4 D1 65 D4 C1 E8 1F 8B D6 03 F6 0B F0 C1 EA 1F 8D 04 3F 0B C2 81 C1 FF FF 00 00 89 75 D8 89 45 DC 66 85 C9 7F CE 66 85 C9 7F 4D 81 C1 FF FF 00 00 66 85 C9 79 42 8B C1 F7 D8 0F B7 F0 03 CE F6 45 D4 01 74 03 FF 45 B0 8B 45 DC 8B 7D D8 8B 55 D8 D1 6D DC C1 E0 1F D1 EF 0B F8 8B 45 D4 C1 E2 1F D1 E8 0B C2 4E 89 7D D8 89 45 D4 75 D1 39 75 B0 74 05 66 83 4D D4 01 B8 00 80 00 00 66 39 45 D4 77 11 8B 55 D4 81 E2 FF FF 01 00 81 FA 00 80 01 00 75 34 83 7D D6 FF 75 2B 83 65 D6 00 83 7D DA FF 75 1C 83 65 DA 00 BA FF FF 00 00 66 39 55 DE 75 07 66 89 45 DE 41 EB 0E 66 FF 45 DE EB 08 FF 45 DA EB 03 FF 45 D6 B8 FF 7F 00 00 66 3B C8 72 23 33 C0 33 C9 66 39 45 90 89 45 C8 0F 94 C1 89 45 C4 49 81 E1 00 00 00 80 81 C1 00 80 FF 7F 89 4D CC EB 3B 66 8B 45 D6 0B 4D 90 66 89 45 C4 8B 45 D8 89 45 C6 8B 45 DC 89 45 CA 66 89 4D CE EB 1E 33 C0 66 85 F6 0F 94 C0 83 65 C8 00 48 25 00 00 00 80 05 00 80 FF 7F 83 65 C4 00 89 45 CC 83 7D AC 00 0F 85 3D FD FF FF 8B 45 CC 0F B7 4D C4 8B 75 C6 8B 55 CA C1 E8 10 EB 2F C7 45 94 04 00 00 00 EB 1E 33 F6 B8 FF 7F 00 00 BA 00 00 00 80 33 C9 C7 45 94 02 00 00 00 EB 0F C7 45 94 01 00 00 00 33 C9 33 C0 33 D2 33 F6 8B 7D 88 0B 45 8C 66 89 0F 66 89 47 0A 8B 45 94 89 77 02 89 57 06 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_156_6_0 {
	meta:
		name = "___STRINGTOLD_L"
		size = 91
		refs = "0009 ___security_cookie 0030 ___strgtold12_l 003c __ld12told 0055 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 18 8B 4D 10 8B 45 0C 56 8B 75 08 57 52 33 D2 52 52 52 FF 75 14 51 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_874_6_0 {
	meta:
		name = "___WSTRINGTOLD_L"
		size = 91
		refs = "0009 ___security_cookie 0030 ___wstrgtold12_l 003c __ld12told 0055 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 18 8B 4D 10 8B 45 0C 56 8B 75 08 57 52 33 D2 52 52 52 FF 75 14 51 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_159_3_0 {
	meta:
		name = "__mbtowc_l"
		size = 278
		refs = "0035 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0068 __isleadbyte_l 009a __imp__MultiByteToWideChar@24 00d1 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 0C 33 DB 3B F3 74 15 39 5D 10 74 10 38 1E 75 12 8B 45 08 3B C3 74 05 33 C9 66 89 08 33 C0 5E 5B C9 C3 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 39 58 14 75 1E 8B 45 08 3B C3 74 06 0F B6 0E 66 89 08 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 40 EB CB 8D 45 F0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 7D 8B 45 F0 8B 88 AC 00 00 00 83 F9 01 7E 25 39 4D 10 7C 20 33 D2 39 5D 08 0F 95 C2 52 FF 75 08 51 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 8B 45 F0 75 10 8B 4D 10 3B 88 AC 00 00 00 72 20 38 5E 01 74 1B 8B 80 AC 00 00 00 38 5D FC 0F 84 66 FF FF FF 8B 4D F8 83 61 70 FD E9 5A FF FF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF E9 3B FF FF FF 33 C0 39 5D 08 0F 95 C0 50 FF 75 08 8B 45 F0 6A 01 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 0F 85 3A FF FF FF EB BA }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__creat"
		size = 49
		refs = "001c __sopen_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 FF 75 0C 83 4D FC FF 6A 40 68 02 03 00 00 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 45 FC C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "__wcreat"
		size = 49
		refs = "001c __wsopen_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 FF 75 0C 83 4D FC FF 6A 40 68 02 03 00 00 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 45 FC C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "___wcsncnt"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 EB 0A 49 66 83 38 00 74 08 83 C0 02 85 C9 75 F2 49 8B 45 0C 2B C1 48 5D C3 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 40
		refs = "000e ___sys_nerr 001e ___sys_errlist"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 78 09 E8 ?? ?? ?? ?? 3B 30 7C 07 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 8B 04 B0 5E 5D C3 }
	condition:
		$1
}

rule file_164_2_0 {
	meta:
		name = "_strerror"
		size = 106
		refs = "0008 __getptd_noexit 0015 ??_C@_0EA@FCLIIPNN@Visual?5C?$CL?$CL?5CRT?3?5Not?5enough?5memor@ 002a __calloc_crt 0048 __get_sys_err_msg 0050 _strcpy_s 0065 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 E8 ?? ?? ?? ?? 8B F0 33 DB 3B F3 75 07 B8 ?? ?? ?? ?? EB 22 57 BF 86 00 00 00 39 5E 24 75 1B 6A 01 57 E8 ?? ?? ?? ?? 59 59 89 46 24 3B C3 75 0A B8 ?? ?? ?? ?? 5F 5E 5B 5D C3 FF 75 08 8B 76 24 E8 ?? ?? ?? ?? 50 57 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 04 8B C6 EB DD 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_164_3_0 {
	meta:
		name = "_strerror_s"
		size = 83
		refs = "000f __errno 0019 __invalid_parameter_noinfo 0032 __get_sys_err_msg 003d _strncpy_s 004e __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 33 FF 39 7D 08 75 15 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5D C3 8B 75 0C 3B F7 76 E4 8D 46 FF 50 FF 75 10 E8 ?? ?? ?? ?? 59 50 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 D7 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_165_3_0 {
	meta:
		name = "__mbscspn_l"
		size = 188
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 _strcspn 0036 __errno 0041 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F4 33 DB 39 5E 08 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 7E 8B 45 08 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 63 39 5D 0C 74 DB 38 18 74 4B 57 8B 4D 0C EB 28 8A 11 0F B6 FA F6 44 37 1D 04 74 17 3A 10 75 08 8A 51 01 3A 50 01 74 14 8D 51 01 38 1A 74 0D 8B CA EB 04 3A 10 74 05 41 38 19 75 D4 38 19 75 14 0F B6 08 F6 44 31 1D 04 74 05 40 38 18 74 05 40 38 18 75 B7 5F 2B 45 08 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__vsnprintf_l"
		size = 172
		refs = "001d __errno 0028 __invalid_parameter_noinfo 007f __output_l 00a0 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 83 65 E0 00 57 6A 07 33 C0 59 8D 7D E4 F3 AB 39 45 10 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 78 8B 4D 0C 56 8B 75 08 85 C9 74 19 85 F6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 53 B8 FF FF FF 7F 89 45 E4 3B C8 77 03 89 4D E4 FF 75 18 8D 45 E0 FF 75 14 C7 45 EC 42 00 00 00 FF 75 10 89 75 E8 50 89 75 E0 E8 ?? ?? ?? ?? 83 C4 10 8B F8 85 F6 74 1C FF 4D E4 78 08 8B 45 E0 C6 00 00 EB 0D 8D 45 E0 50 6A 00 E8 ?? ?? ?? ?? 59 59 8B C7 5E 5F C9 C3 }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "__vsnprintf"
		size = 29
		refs = "0014 __vsnprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_359_3_0 {
	meta:
		name = "?vswprintf@@YAHPAGIPBGPAD@Z"
		size = 29
		refs = "0014 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_359_1_0 {
	meta:
		name = "?vswprintf@@YAHPA_WIPB_WPAD@Z"
		size = 29
		refs = "0014 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_867_1_0 {
	meta:
		name = "__vsnwprintf"
		size = 29
		refs = "0014 __vsnwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_529_4_0 {
	meta:
		name = "_vsprintf_s"
		size = 29
		refs = "0014 __vsprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_660_4_0 {
	meta:
		name = "_vswprintf_s"
		size = 29
		refs = "0014 __vswprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 14 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__putws"
		size = 219
		refs = "0003 __sehtable$__putws 0008 __SEH_prolog4 0021 __errno 002c __invalid_parameter_noinfo 0038 ___iob_func 0043 __lock_file2 0057 __stbuf 007a __fputwc_nolock 00ad __ftbuf 00c3 __SEH_epilog4 00d4 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE FF FF 00 00 89 75 E4 33 C0 39 45 08 0F 95 C0 85 C0 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C6 E9 8B 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 83 65 FC 00 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 59 8B D8 8B 45 08 0F B7 00 66 85 C0 74 1E 8B F8 83 45 08 02 E8 ?? ?? ?? ?? 83 C0 20 50 57 E8 ?? ?? ?? ?? 59 59 66 3B C6 74 1D EB D7 E8 ?? ?? ?? ?? 83 C0 20 50 6A 0A E8 ?? ?? ?? ?? 59 59 66 3B C6 74 04 83 65 E4 00 E8 ?? ?? ?? ?? 83 C0 20 50 53 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__CallSettingFrame@12"
		size = 76
		refs = "001f __NLG_Notify1"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 51 8B 45 0C 83 C0 0C 89 45 FC 8B 45 08 55 FF 75 10 8B 4D 10 8B 6D FC E8 ?? ?? ?? ?? 56 57 FF D0 5F 5E 8B DD 5D 8B 4D 10 55 8B EB 81 F9 00 01 00 00 75 05 B9 02 00 00 00 51 E8 ?? ?? ?? ?? 5D 59 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_175_1_0 {
	meta:
		name = "__tsopen_nolock"
		size = 1844
		refs = "003f __get_fmode 0083 ___doserrno 008d __errno 0097 __invalid_parameter_noinfo 01a4 __umaskval 01f1 __alloc_osfhnd 0224 __imp__CreateFileA@28 028f ___pioinfo 02a2 __imp__GetLastError@0 02a8 __dosmaperr 02c1 __imp__GetFileType@4 02f8 __imp__CloseHandle@4 0327 __set_osfhnd 0387 __lseek_nolock 03a4 __close_nolock 03ba __read_nolock 03d3 __chsize_nolock 04f0 __lseeki64_nolock 0609 __write 0700 __free_osfhnd 072f __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 53 33 DB F6 45 10 80 56 8B F0 89 5D DC 88 5D FE 89 5D F8 C7 45 D0 0C 00 00 00 89 5D D4 74 09 89 5D D8 C6 45 FF 10 EB 0A C7 45 D8 01 00 00 00 88 5D FF 8D 45 DC 50 E8 ?? ?? ?? ?? 59 85 C0 0F 85 DD 06 00 00 B8 00 80 00 00 85 45 10 75 12 F7 45 10 00 40 07 00 75 05 39 45 DC 74 04 80 4D FF 80 8B 45 10 83 E0 03 2B C3 B9 00 00 00 C0 BA 00 00 00 80 74 43 48 74 28 48 74 20 E8 ?? ?? ?? ?? 89 18 83 0E FF E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 DE 00 00 00 89 4D F4 EB 1B F6 45 10 08 74 09 F7 45 10 00 00 07 00 75 EC C7 45 F4 00 00 00 40 EB 03 89 55 F4 8B 45 14 6A 10 59 2B C1 74 37 2B C1 74 2A 2B C1 74 1D 2B C1 74 10 83 E8 40 75 A5 39 55 F4 0F 94 C0 89 45 EC EB 1E C7 45 EC 03 00 00 00 EB 15 C7 45 EC 02 00 00 00 EB 0C C7 45 EC 01 00 00 00 EB 03 89 5D EC 8B 45 10 BA 00 07 00 00 23 C2 B9 00 04 00 00 57 BF 00 01 00 00 3B C1 7F 33 74 28 3B C3 74 24 3B C7 74 17 3D 00 02 00 00 74 54 3D 00 03 00 00 75 2D C7 45 E8 02 00 00 00 EB 54 C7 45 E8 04 00 00 00 EB 4B C7 45 E8 03 00 00 00 EB 42 3D 00 05 00 00 74 34 3D 00 06 00 00 74 24 3B C2 74 29 E8 ?? ?? ?? ?? 89 18 83 0E FF E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5F 5E 5B C9 C3 C7 45 E8 05 00 00 00 EB 07 C7 45 E8 01 00 00 00 8B 45 10 C7 45 F0 80 00 00 00 85 C7 74 16 8B 0D ?? ?? ?? ?? F7 D1 23 4D 18 84 C9 78 07 C7 45 F0 01 00 00 00 A8 40 74 12 81 4D F0 00 00 00 04 81 4D F4 00 00 01 00 83 4D EC 04 A9 00 10 00 00 74 03 09 7D F0 A8 20 74 09 81 4D F0 00 00 00 08 EB 0B A8 10 74 07 81 4D F0 00 00 00 10 E8 ?? ?? ?? ?? 83 CB FF 89 06 3B C3 75 21 E8 ?? ?? ?? ?? 83 20 00 89 1E E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 60 FF FF FF 8B 45 08 8B 3D ?? ?? ?? ?? 6A 00 FF 75 F0 C7 00 01 00 00 00 FF 75 E8 8D 45 D0 50 FF 75 EC FF 75 F4 FF 75 0C FF D7 89 45 E0 3B C3 75 70 8B 4D F4 B8 00 00 00 C0 23 C8 3B C8 75 2B F6 45 10 01 74 25 81 65 F4 FF FF FF 7F 6A 00 FF 75 F0 8D 45 D0 FF 75 E8 50 FF 75 EC FF 75 F4 FF 75 0C FF D7 89 45 E0 3B C3 75 37 8B 36 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 8D 44 30 04 80 20 FE FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 89 45 F8 E9 65 04 00 00 FF 75 E0 FF 15 ?? ?? ?? ?? 85 C0 75 44 8B 36 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 8D 44 30 04 80 20 FE FF 15 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 59 FF 75 E0 FF 15 ?? ?? ?? ?? 85 F6 75 AD E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB A0 83 F8 02 75 06 80 4D FF 40 EB 09 83 F8 03 75 04 80 4D FF 08 FF 75 E0 FF 36 E8 ?? ?? ?? ?? 8B 06 8B D0 83 E0 1F C1 FA 05 8B 14 95 ?? ?? ?? ?? 59 C1 E0 06 59 8A 4D FF 80 C9 01 88 4C 02 04 8B 06 8B D0 83 E0 1F C1 FA 05 8B 14 95 ?? ?? ?? ?? C1 E0 06 8D 44 02 24 80 20 80 88 4D FD 80 65 FD 48 88 4D FF 75 7E F6 C1 80 0F 84 A7 02 00 00 F6 45 10 02 74 6F 6A 02 53 FF 36 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 3B FB 75 19 E8 ?? ?? ?? ?? 81 38 83 00 00 00 74 4F FF 36 E8 ?? ?? ?? ?? E9 FF FE FF FF 6A 01 8D 45 FC 50 FF 36 C6 45 FC 00 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 19 80 7D FC 1A 75 13 8B C7 99 52 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 C3 6A 00 6A 00 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 B1 F6 45 FF 80 0F 84 28 02 00 00 BF 00 40 07 00 B9 00 40 00 00 85 7D 10 75 0F 8B 45 DC 23 C7 75 05 09 4D 10 EB 03 09 45 10 8B 45 10 23 C7 3B C1 74 44 3D 00 00 01 00 74 29 3D 00 40 01 00 74 22 3D 00 00 02 00 74 29 3D 00 40 02 00 74 22 3D 00 00 04 00 74 07 3D 00 40 04 00 75 1E C6 45 FE 01 EB 18 8B 4D 10 B8 01 03 00 00 23 C8 3B C8 75 0A C6 45 FE 02 EB 04 C6 45 FE 00 F7 45 10 00 00 07 00 0F 84 AC 01 00 00 33 FF F6 45 FF 40 89 7D E4 0F 85 9D 01 00 00 8B 45 F4 B9 00 00 00 C0 23 C1 3D 00 00 00 40 0F 84 B0 00 00 00 3D 00 00 00 80 74 71 3B C1 0F 85 79 01 00 00 8B 45 E8 3B C7 0F 86 6E 01 00 00 83 F8 02 76 0E 83 F8 04 76 2B 83 F8 05 0F 85 5B 01 00 00 0F BE 45 FE 33 FF 48 0F 84 1E 01 00 00 48 0F 85 47 01 00 00 C7 45 E4 FF FE 00 00 6A 02 E9 12 01 00 00 6A 02 57 57 FF 36 E8 ?? ?? ?? ?? 83 C4 10 0B C2 74 CC 57 57 57 FF 36 E8 ?? ?? ?? ?? 23 C2 83 C4 10 3B C3 0F 84 8F FE FF FF 6A 03 8D 45 E4 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 0F 84 77 FE FF FF 83 F8 02 74 6A 83 F8 03 0F 85 AC 00 00 00 81 7D E4 EF BB BF 00 75 58 C6 45 FE 01 E9 D8 00 00 00 8B 45 E8 3B C7 0F 86 CD 00 00 00 83 F8 02 0F 86 69 FF FF FF 83 F8 04 0F 87 57 FF FF FF 6A 02 57 57 FF 36 E8 ?? ?? ?? ?? 83 C4 10 0B C2 0F 84 4A FF FF FF 57 57 57 FF 36 E8 ?? ?? ?? ?? 83 C4 10 23 C2 3B C3 0F 85 8E 00 00 00 E9 08 FE FF FF 8B 45 E4 25 FF FF 00 00 3D FE FF 00 00 75 1A FF 36 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 6A 16 5E 89 30 89 75 F8 E9 5F 01 00 00 3D FF FE 00 00 75 1B 57 6A 02 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 0F 84 C3 FD FF FF C6 45 FE 02 EB 3E 57 57 FF 36 E8 ?? ?? ?? ?? 83 C4 0C EB 9A C7 45 E4 EF BB BF 00 6A 03 5B 8B C3 2B C7 50 8D 44 3D E4 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 88 FD FF FF 03 F8 3B DF 7F DD 83 CB FF 8B 06 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F C1 E0 06 8D 44 01 24 8A 08 32 4D FE 80 E1 7F 30 08 8B 06 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F C1 E0 06 8D 44 01 24 8B 4D 10 8A 10 C1 E9 10 C0 E1 07 80 E2 7F 0A CA 80 7D FD 00 88 08 75 21 F6 45 10 08 74 1B 8B 06 8B C8 83 E0 1F C1 F9 05 8B 0C 8D ?? ?? ?? ?? C1 E0 06 8D 44 01 04 80 08 20 8B 4D F4 B8 00 00 00 C0 23 C8 3B C8 75 7E F6 45 10 01 74 78 FF 75 E0 FF 15 ?? ?? ?? ?? 6A 00 FF 75 F0 8D 45 D0 6A 03 50 FF 75 EC 8B 45 F4 25 FF FF FF 7F 50 FF 75 0C FF 15 ?? ?? ?? ?? 3B C3 75 34 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 06 8B C8 83 E0 1F C1 F9 05 8B 0C 8D ?? ?? ?? ?? C1 E0 06 8D 44 01 04 80 20 FE FF 36 E8 ?? ?? ?? ?? 59 E9 A2 FB FF FF 8B 36 8B CE C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E6 1F C1 E6 06 89 04 0E 8B 45 F8 E9 56 FA FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_175_2_0 {
	meta:
		name = "__open"
		size = 174
		refs = "0003 __sehtable$__open 0008 __SEH_prolog4 0022 __errno 002d __invalid_parameter_noinfo 004c __tsopen_nolock 0090 ___pioinfo 009f __unlock_fhandle 00a9 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D E4 FF 33 FF 89 7D E0 33 C0 39 7D 08 0F 95 C0 3B C7 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 72 89 7D FC FF 75 10 6A 40 FF 75 0C FF 75 08 8D 45 E0 50 8D 45 E4 E8 ?? ?? ?? ?? 83 C4 14 89 45 DC C7 45 FC FE FF FF FF E8 12 00 00 00 8B 75 DC 3B F7 74 3C E8 ?? ?? ?? ?? 89 30 EB BF 33 FF 39 7D E0 74 2B 39 7D DC 74 1D 8B 45 E4 C1 F8 05 8B 4D E4 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 20 FE FF 75 E4 E8 ?? ?? ?? ?? 59 C3 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_844_2_0 {
	meta:
		name = "__wopen"
		size = 174
		refs = "0003 __sehtable$__wopen 0008 __SEH_prolog4 0022 __errno 002d __invalid_parameter_noinfo 004c __tsopen_nolock 0090 ___pioinfo 009f __unlock_fhandle 00a9 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D E4 FF 33 FF 89 7D E0 33 C0 39 7D 08 0F 95 C0 3B C7 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 72 89 7D FC FF 75 10 6A 40 FF 75 0C FF 75 08 8D 45 E0 50 8D 45 E4 E8 ?? ?? ?? ?? 83 C4 14 89 45 DC C7 45 FC FE FF FF FF E8 12 00 00 00 8B 75 DC 3B F7 74 3C E8 ?? ?? ?? ?? 89 30 EB BF 33 FF 39 7D E0 74 2B 39 7D DC 74 1D 8B 45 E4 C1 F8 05 8B 4D E4 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 20 FE FF 75 E4 E8 ?? ?? ?? ?? 59 C3 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_175_3_0 {
	meta:
		name = "__sopen_helper"
		size = 196
		refs = "0003 __sehtable$__sopen_helper 0008 __SEH_prolog4 0020 __errno 002a __invalid_parameter_noinfo 006b __tsopen_nolock 008c __SEH_epilog4 00b0 ___pioinfo 00be __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 18 3B F7 0F 95 C0 3B C7 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 59 83 0E FF 33 C0 39 7D 08 0F 95 C0 3B C7 74 DE 39 7D 1C 74 0F 8B 45 14 25 7F FE FF FF F7 D8 1B C0 40 74 CA 89 7D FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 8D 45 E4 50 8B C6 E8 ?? ?? ?? ?? 83 C4 14 89 45 E0 C7 45 FC FE FF FF FF E8 15 00 00 00 8B 45 E0 3B C7 74 03 83 0E FF E8 ?? ?? ?? ?? C3 33 FF 8B 75 18 39 7D E4 74 28 39 7D E0 74 1B 8B 06 8B C8 C1 F9 05 83 E0 1F C1 E0 06 8B 0C 8D ?? ?? ?? ?? 8D 44 01 04 80 20 FE FF 36 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_844_3_0 {
	meta:
		name = "__wsopen_helper"
		size = 196
		refs = "0003 __sehtable$__wsopen_helper 0008 __SEH_prolog4 0020 __errno 002a __invalid_parameter_noinfo 006b __tsopen_nolock 008c __SEH_epilog4 00b0 ___pioinfo 00be __unlock_fhandle"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 18 3B F7 0F 95 C0 3B C7 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 59 83 0E FF 33 C0 39 7D 08 0F 95 C0 3B C7 74 DE 39 7D 1C 74 0F 8B 45 14 25 7F FE FF FF F7 D8 1B C0 40 74 CA 89 7D FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 8D 45 E4 50 8B C6 E8 ?? ?? ?? ?? 83 C4 14 89 45 E0 C7 45 FC FE FF FF FF E8 15 00 00 00 8B 45 E0 3B C7 74 03 83 0E FF E8 ?? ?? ?? ?? C3 33 FF 8B 75 18 39 7D E4 74 28 39 7D E0 74 1B 8B 06 8B C8 C1 F9 05 83 E0 1F C1 E0 06 8B 0C 8D ?? ?? ?? ?? 8D 44 01 04 80 20 FE FF 36 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_175_4_0 {
	meta:
		name = "__sopen"
		size = 50
		refs = "001d __sopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 4D FC FF 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_844_4_0 {
	meta:
		name = "__wsopen"
		size = 50
		refs = "001d __wsopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 4D FC FF 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_175_5_0 {
	meta:
		name = "__sopen_s"
		size = 32
		refs = "0017 __sopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 08 FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_844_5_0 {
	meta:
		name = "__wsopen_s"
		size = 32
		refs = "0017 __wsopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 08 FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_177_3_0 {
	meta:
		name = "__mbschr_l"
		size = 176
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001e __errno 0029 __invalid_parameter_noinfo 004b _strchr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 08 33 DB 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 70 56 8B 75 F4 39 5E 08 75 3A FF 75 0C 50 E8 ?? ?? ?? ?? 59 59 EB 3D 0F B6 D1 F6 44 32 1D 04 74 1A 40 8A 10 3A D3 74 3A 0F B7 C9 0F B6 D2 C1 E1 08 0B CA 39 4D 0C 75 0B 48 EB 19 0F B7 D1 39 55 0C 74 09 40 0F B6 08 66 3B CB 75 CB 0F B7 C9 39 4D 0C 75 0E 38 5D FC 74 17 8B 4D F8 83 61 70 FD EB 0E 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5E 5B C9 C3 }
	condition:
		$1
}

rule file_179_10_0 {
	meta:
		name = "??1UMSThreadProxy@details@Concurrency@@UAE@XZ"
		size = 69
		refs = "000b __imp__CloseHandle@4 0011 ??_7UMSThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 0018 ??_7UMSThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 001f ??_7UMSThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 003d ?DeleteUmsThreadContext@UMS@details@Concurrency@@SAHPAX@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 18 57 8B 3D ?? ?? ?? ?? C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 85 C0 74 03 50 FF D7 8B 46 14 85 C0 74 03 50 FF D7 8B 76 10 85 F6 74 07 56 E8 ?? ?? ?? ?? 59 5F 5E C3 }
	condition:
		$1
}

rule file_179_14_0 {
	meta:
		name = "?GetCriticalRegionType@UMSThreadProxy@details@Concurrency@@UBE?AW4CriticalRegionType@3@XZ"
		size = 20
	strings:
		$1 = { 83 79 54 00 76 04 6A 02 58 C3 33 C0 3B 41 50 1B C0 F7 D8 C3 }
	condition:
		$1
}

rule file_179_15_0 {
	meta:
		name = "?GetNextUnblockNotification@UMSThreadProxy@details@Concurrency@@UAEPAUIUMSUnblockNotification@3@XZ"
		size = 21
	strings:
		$1 = { 8B 41 58 8D 48 A0 F7 D8 1B C0 23 C1 74 04 83 C0 08 C3 33 C0 C3 }
	condition:
		$1
}

rule file_179_18_0 {
	meta:
		name = "?ReadyForDispatch@UMSThreadProxy@details@Concurrency@@AAEXXZ"
		size = 29
		refs = "0016 ?UmsThreadYield@UMS@details@Concurrency@@SAHPAX@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8D 4E 04 8B 01 FF 50 18 56 C7 46 34 07 00 00 00 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_179_19_0 {
	meta:
		name = "?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPAV123@PAX@Z"
		size = 116
		refs = "0027 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPAK@Z 0034 __imp__GetLastError@0 004b ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0050 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0059 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 56 33 F6 39 75 08 75 04 33 C0 EB 5D 8D 45 08 50 6A 04 8D 45 FC 50 6A 01 FF 75 08 89 75 FC E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 2B FF 15 ?? ?? ?? ?? 3B C6 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D EC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 8B 4D FC 3B CE 74 0B 8B 01 FF 10 84 C0 75 03 8B 75 FC 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_179_23_0 {
	meta:
		name = "?FromListEntry@UMSThreadProxy@details@Concurrency@@SAPAV123@PAU_SINGLE_LIST_ENTRY@@@Z"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 75 02 5D C3 83 C0 A0 5D C3 }
	condition:
		$1
}

rule file_179_24_0 {
	meta:
		name = "?InternalSwitchTo@UMSThreadProxy@details@Concurrency@@IAEXPAV123@W4SwitchingProxyState@3@@Z"
		size = 129
		refs = "0009 ___security_cookie 003e ?GetResourceManager@UMSFreeVirtualProcessorRoot@details@Concurrency@@QAEPAVResourceManager@23@XZ 0047 ?PerformTransmogrification@Transmogrificator@details@Concurrency@@QAEXPAVUMSThreadProxy@23@@Z 005d ?UmsThreadYield@UMS@details@Concurrency@@SAHPAX@Z 0079 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B F1 8B 46 04 57 8D 4E 04 C7 45 F0 02 00 00 00 C7 45 F4 01 00 00 00 C7 45 F8 03 00 00 00 FF 50 18 83 7D 0C 02 75 11 8B 4E 20 E8 ?? ?? ?? ?? 8B 48 64 56 E8 ?? ?? ?? ?? 8B 45 0C 8B 44 85 F0 89 46 34 8B 45 08 56 89 46 38 E8 ?? ?? ?? ?? 83 7D 0C 00 59 74 09 8B 46 04 8D 4E 04 FF 50 1C 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C2 08 00 }
	condition:
		$1
}

rule file_179_25_0 {
	meta:
		name = "?InternalSwitchOut@UMSThreadProxy@details@Concurrency@@IAEXXZ"
		size = 56
		refs = "0028 ?UmsThreadYield@UMS@details@Concurrency@@SAHPAX@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 04 57 8D 4E 04 FF 50 18 8B 46 3C 56 85 C0 74 09 C7 46 3C 00 00 00 00 EB 07 C7 46 34 06 00 00 00 E8 ?? ?? ?? ?? 8B 46 04 59 5F 8D 4E 04 5E FF 60 1C }
	condition:
		$1
}

rule file_179_26_0 {
	meta:
		name = "?Deactivate@UMSThreadProxy@details@Concurrency@@IAE_NXZ"
		size = 60
		refs = "001d ?UmsThreadYield@UMS@details@Concurrency@@SAHPAX@Z"
	strings:
		$1 = { 8B FF 53 56 8B F1 8B 46 04 57 8D 4E 04 FF 50 18 83 66 38 00 56 C7 46 34 04 00 00 00 E8 ?? ?? ?? ?? 83 7E 40 01 8B 46 04 59 0F 94 C3 83 66 40 00 8D 4E 04 FF 50 1C 5F 5E 8A C3 5B C3 }
	condition:
		$1
}

rule file_179_27_0 {
	meta:
		name = "?SetPriority@UMSThreadProxy@details@Concurrency@@QAEXH@Z"
		size = 75
		refs = "0014 __imp__SetThreadPriority@8 001e __imp__GetLastError@0 0035 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 003a __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 0043 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 10 50 FF 71 14 89 41 2C FF 15 ?? ?? ?? ?? 85 C0 75 2B FF 15 ?? ?? ?? ?? 85 C0 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_179_29_0 {
	meta:
		name = "?IsSuspended@UMSThreadProxy@details@Concurrency@@QAE_NXZ"
		size = 41
		refs = "0018 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPAK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 01 8D 45 FF 50 6A 05 FF 71 10 C6 45 FF 00 E8 ?? ?? ?? ?? 33 C0 83 C4 14 38 45 FF 0F 95 C0 C9 C3 }
	condition:
		$1
}

rule file_179_30_0 {
	meta:
		name = "?IsTerminated@UMSThreadProxy@details@Concurrency@@QAE_NXZ"
		size = 41
		refs = "0018 ?QueryUmsThreadInformation@UMS@details@Concurrency@@SAHPAXW4_RTL_UMS_THREAD_INFO_CLASS@@0KPAK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 01 8D 45 FF 50 6A 06 FF 71 10 C6 45 FF 00 E8 ?? ?? ?? ?? 33 C0 83 C4 14 38 45 FF 0F 95 C0 C9 C3 }
	condition:
		$1
}

rule file_179_31_0 {
	meta:
		name = "?PrepareToRun@UMSThreadProxy@details@Concurrency@@IAEXPAVUMSFreeVirtualProcessorRoot@23@@Z"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 C7 41 1C 00 00 00 00 89 41 24 89 41 20 5D C2 04 00 }
	condition:
		$1
}

rule file_179_42_0 {
	meta:
		name = "?UMSThreadProxyMain@UMSThreadProxy@details@Concurrency@@CGKPAX@Z"
		size = 30
		refs = "000c ?ReadyForDispatch@UMSThreadProxy@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 8B CE E8 ?? ?? ?? ?? 8B 06 8B CE FF 50 08 33 C0 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_179_43_0 {
	meta:
		name = "?InternalYieldToSystem@UMSThreadProxy@details@Concurrency@@IAEXXZ"
		size = 44
		refs = "001c ?UmsThreadYield@UMS@details@Concurrency@@SAHPAX@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 04 57 8D 4E 04 FF 50 18 83 66 38 00 56 C7 46 34 08 00 00 00 E8 ?? ?? ?? ?? 8B 46 04 59 5F 8D 4E 04 5E FF 60 1C }
	condition:
		$1
}

rule file_179_44_0 {
	meta:
		name = "?FreeViaExit@UMSThreadProxy@details@Concurrency@@IAEXXZ"
		size = 56
		refs = "000f ?s_fRequireUMSWorkaround@ResourceManager@details@Concurrency@@0_NA 0031 ?UmsThreadYield@UMS@details@Concurrency@@SAHPAX@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8D 4E 04 8B 01 FF 50 18 80 3D ?? ?? ?? ?? 00 74 12 8B 46 20 80 78 72 00 74 09 C7 46 48 01 00 00 00 5E C3 56 C7 46 34 05 00 00 00 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_179_46_0 {
	meta:
		name = "??0UMSThreadProxy@details@Concurrency@@QAE@PAUIThreadProxyFactory@12@PAXI@Z"
		size = 591
		refs = "0014 ??_7IUMSThreadProxy@Concurrency@@6B@ 001b ??_7IUMSUnblockNotification@Concurrency@@6B@ 0029 ??_7UMSThreadProxy@details@Concurrency@@6BUMSBaseObject@12@@ 0030 ??_7UMSThreadProxy@details@Concurrency@@6BIUMSThreadProxy@2@@ 0037 ??_7UMSThreadProxy@details@Concurrency@@6BIUMSUnblockNotification@2@@ 006c __imp__CreateEventW@16 0079 __imp__GetLastError@0 0090 ??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z 0095 __TI2?AVscheduler_resource_allocation_error@Concurrency@@ 009e __CxxThrowException@8 00a5 ?s_threadProxyIdCount@ResourceManager@details@Concurrency@@0JC 00b4 ?CreateUmsThreadContext@UMS@details@Concurrency@@SAHPAPAX@Z 00f2 ?SetUmsThreadInformation@UMS@details@Concurrency@@SAHPAXW4_RTL_UMS_THREAD_INFO_CLASS@@0K@Z 0142 ?InitializeProcThreadAttributeList@UMS@details@Concurrency@@SAHPAU_PROC_THREAD_ATTRIBUTE_LIST@@KKPAK@Z 014a ??_U@YAPAXI@Z 0166 ??_V@YAXPAX@Z 01a5 ?UpdateProcThreadAttribute@UMS@details@Concurrency@@SAHPAU_PROC_THREAD_ATTRIBUTE_LIST@@KKPAXK1PAK@Z 01f0 ?UMSThreadProxyMain@UMSThreadProxy@details@Concurrency@@CGKPAX@Z 01fb __imp__GetCurrentProcess@0 0201 ?CreateRemoteThreadEx@UMS@details@Concurrency@@SAPAXPAXPAU_SECURITY_ATTRIBUTES@@KP6GK0@Z0KPAU_PROC_THREAD_ATTRIBUTE_LIST@@PAK@Z 020a ?DeleteProcThreadAttributeList@UMS@details@Concurrency@@SAXPAU_PROC_THREAD_ATTRIBUTE_LIST@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 70 53 33 DB 56 8B F1 C7 46 04 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 57 89 46 0C 8B 45 10 53 C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 89 5E 14 89 5E 18 53 8D 7E 10 89 1F 89 5E 1C 89 5E 20 89 5E 24 89 46 28 88 5E 30 89 5E 34 53 89 5E 3C 89 5E 40 53 89 5E 48 89 5E 54 89 5E 58 FF 15 ?? ?? ?? ?? 89 46 18 3B C3 75 2B FF 15 ?? ?? ?? ?? 3B C3 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 33 C9 B8 ?? ?? ?? ?? 41 F0 0F C1 08 41 57 89 4E 50 E8 ?? ?? ?? ?? 59 85 C0 75 27 FF 15 ?? ?? ?? ?? 3B C3 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D D0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D0 EB B8 6A 04 8D 45 FC 50 6A 01 FF 37 89 75 FC E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 2A FF 15 ?? ?? ?? ?? 3B C3 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D C0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C0 E9 75 FF FF FF 8B 07 89 45 F4 8B 45 0C 89 45 F8 8D 45 08 50 53 6A 01 53 C7 45 F0 00 01 00 00 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 8B F8 8D 45 08 50 53 6A 01 57 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 31 57 E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? 3B C3 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D B0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 B0 E9 07 FF FF FF 53 53 6A 0C 8D 45 F0 50 68 06 00 03 00 53 57 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 31 57 E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? 3B C3 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D A0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 A0 E9 BB FE FF FF 8D 46 5C 50 8B 45 10 57 68 00 00 01 00 56 68 ?? ?? ?? ?? C1 E0 0A 50 53 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 89 46 14 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 28 39 5E 14 75 2A FF 15 ?? ?? ?? ?? 3B C3 7E 0A 25 FF FF 00 00 0D 00 00 07 80 50 8D 4D 90 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 90 E9 56 FE FF FF 5F 8B C6 5E 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_179_48_0 {
	meta:
		name = "?SpinUntilBlocked@UMSThreadProxy@details@Concurrency@@IAEXXZ"
		size = 47
		refs = "0019 ?_Sleep0@details@Concurrency@@YAXXZ 0021 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B F1 8B 46 20 85 C0 74 1A 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 46 20 85 C0 75 F1 5E C9 C3 }
	condition:
		$1
}

rule file_179_49_0 {
	meta:
		name = "?SpinOnAndReturnBlockingType@UMSThreadProxy@details@Concurrency@@IAE?AW4BlockingType@123@XZ"
		size = 49
		refs = "0018 ?_Sleep0@details@Concurrency@@YAXXZ 0020 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B F1 8B 46 1C 85 C0 75 19 21 45 F8 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 46 1C 85 C0 74 F1 8B 46 1C 5E C9 C3 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__spawnlp"
		size = 68
		refs = "000d __errno 0018 __invalid_parameter_noinfo 003b __spawnvp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 85 C9 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 80 39 00 74 E6 8B 45 10 85 C0 74 DF 80 38 00 74 DA 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_182_3_0 {
	meta:
		name = "__ismbcdigit_l"
		size = 199
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006a ___crtGetStringTypeA 00a1 __isctype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 6E 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 33 DB 88 4D 09 5F 39 58 08 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 73 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CC 66 39 5D FE 75 0B F6 45 FC 04 74 05 33 C0 40 EB 02 33 C0 38 5D F8 EB 2E 8B 45 EC 83 B8 AC 00 00 00 01 7E 11 8D 45 EC 50 6A 04 51 E8 ?? ?? ?? ?? 83 C4 0C EB 0D 8B 80 C8 00 00 00 0F B7 04 48 83 E0 04 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__aullrem"
		size = 117
	strings:
		$1 = { 53 8B 44 24 14 0B C0 75 18 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B 44 24 08 F7 F1 8B C2 33 D2 EB 50 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B C8 F7 64 24 14 91 F7 64 24 10 03 D1 72 0E 3B 54 24 0C 77 08 72 0E 3B 44 24 08 76 08 2B 44 24 10 1B 54 24 14 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 5B C2 10 00 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__EH_prolog3"
		size = 51
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_186_1_0 {
	meta:
		name = "__EH_prolog3_catch"
		size = 54
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_186_2_0 {
	meta:
		name = "__EH_prolog3_GS"
		size = 54
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_186_3_0 {
	meta:
		name = "__EH_prolog3_catch_GS"
		size = 57
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 EC 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_186_4_0 {
	meta:
		name = "__EH_epilog3"
		size = 20
	strings:
		$1 = { 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5F 5E 5B 8B E5 5D 51 C3 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__allshl"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 8B D0 33 C0 80 E1 1F D3 E2 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__mbsinc_l"
		size = 39
		refs = "0011 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 0F B6 06 FF 75 0C 50 E8 ?? ?? ?? ?? 59 46 59 85 C0 74 06 80 3E 00 74 01 46 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_188_1_0 {
	meta:
		name = "__mbsinc"
		size = 59
		refs = "000e __errno 0019 __invalid_parameter_noinfo 0026 __ismbblead"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 85 F6 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 17 0F B6 06 50 E8 ?? ?? ?? ?? 46 59 85 C0 74 06 80 3E 00 74 01 46 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "___libm_sse2_log10"
		size = 574
		refs = "0024 _emask 002c _CC 0034 _One 003c _Magic 0044 _hi_mask 0062 _CB_Tbl 006a _T_Tbl 00cc _coeff 00f8 _LOG10_2 0104 _place_LR 015e _Zero 01b2 _Infs 01e1 _Two52"
	strings:
		$1 = { 83 EC 0C BA 00 00 00 00 66 0F 13 44 24 04 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 B1 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 83 C4 0C F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 54 83 F9 FF 74 67 81 F9 FE 07 00 00 77 75 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 83 C4 0C 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 1B FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 0C 83 C4 0C 66 0F 57 C0 F2 0F 5E C0 C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 CE 83 C4 0C F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_191_3_0 {
	meta:
		name = "___check_float_string"
		size = 87
		refs = "0017 __calloc_crt 0038 _memcpy 0043 __recalloc_crt"
	strings:
		$1 = { 8B FF 55 8B EC 8B 06 39 45 08 75 46 8B 0F 6A 02 50 3B 4D 0C 75 2B E8 ?? ?? ?? ?? 59 59 89 07 85 C0 75 04 33 C0 5D C3 8B 45 10 C7 00 01 00 00 00 FF 36 FF 75 0C FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D5 89 07 D1 26 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_191_5_0 {
	meta:
		name = "__hextodec"
		size = 32
		refs = "000b _isdigit"
	strings:
		$1 = { 8B FF 55 8B EC 0F B6 45 08 50 E8 ?? ?? ?? ?? 85 C0 0F BE 45 08 59 75 06 83 E0 DF 83 E8 07 5D C3 }
	condition:
		$1
}

rule file_191_7_0 {
	meta:
		name = "__un_inc"
		size = 19
		refs = "000d __ungetch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 FF 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_201_7_0 {
	meta:
		name = "__un_inc"
		size = 19
		refs = "000d __ungetc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 FF 74 06 5D E9 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_191_8_0 {
	meta:
		name = "__whiteout"
		size = 35
		refs = "0006 __getche_nolock 0016 _isspace"
	strings:
		$1 = { 8B FF 53 FF 06 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 0E 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 E4 8B C3 5B C3 }
	condition:
		$1
}

rule file_191_9_0 {
	meta:
		name = "__cprinput_l"
		size = 3643
		refs = "000c ___security_cookie 0051 __errno 005c __invalid_parameter_noinfo 0072 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 009b _isspace 00b1 __whiteout 00b7 __un_inc 013f _isdigit 02b9 __getche_nolock 03fa ___check_float_string 06d2 __cfltcvt_tab 06d8 __imp__DecodePointer@4 07c8 _isleadbyte 080e __mbtowc_l 08ae _memset 0b81 __allmul 0b94 _isxdigit 0bb7 __hextodec 0e0f _free 0e35 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC FC 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 56 57 33 FF 8B F1 89 85 18 FE FF FF 8D 85 7C FE FF FF 89 85 58 FE FF FF C7 85 2C FE FF FF 5E 01 00 00 89 BD 3C FE FF FF 89 BD 1C FE FF FF 89 BD 70 FE FF FF 3B F7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 C5 0D 00 00 FF 75 08 8D 8D 04 FE FF FF E8 ?? ?? ?? ?? 8A 06 C6 85 63 FE FF FF 00 89 BD 74 FE FF FF 89 BD 38 FE FF FF 84 C0 0F 84 81 0D 00 00 8B FE 53 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 2C FF 8D 74 FE FF FF 8D B5 74 FE FF FF E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 47 0F B6 07 50 E8 ?? ?? ?? ?? 59 85 C0 75 F1 E9 04 0D 00 00 8A 07 3C 25 0F 85 B8 0C 00 00 38 47 01 0F 84 A5 0C 00 00 33 C0 89 85 20 FE FF FF 88 85 37 FE FF FF 89 85 50 FE FF FF 89 85 4C FE FF FF 89 85 68 FE FF FF 88 85 65 FE FF FF 88 85 64 FE FF FF 88 85 67 FE FF FF 88 85 57 FE FF FF 88 85 66 FE FF FF 88 85 6F FE FF FF C6 85 7B FE FF FF 01 89 85 30 FE FF FF 33 F6 47 0F B6 1F 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 68 FE FF FF FF 85 4C FE FF FF 6B C0 0A 8D 44 18 D0 89 85 68 FE FF FF E9 C5 00 00 00 83 FB 4E 0F 8F 83 00 00 00 0F 84 B6 00 00 00 83 FB 2A 74 70 83 FB 46 0F 84 A8 00 00 00 83 FB 49 74 10 83 FB 4C 75 74 FE 85 7B FE FF FF E9 93 00 00 00 8A 4F 01 80 F9 36 75 1E 8D 47 02 80 38 34 75 16 FF 85 30 FE FF FF 8B F8 89 B5 40 FE FF FF 89 B5 44 FE FF FF EB 6D 80 F9 33 75 0C 8D 47 02 80 38 32 75 04 8B F8 EB 5C 80 F9 64 74 57 80 F9 69 74 52 80 F9 6F 74 4D 80 F9 78 74 48 80 F9 58 75 19 EB 41 FE 85 67 FE FF FF EB 39 83 FB 68 74 28 83 FB 6C 74 0D 83 FB 77 74 16 FE 85 57 FE FF FF EB 22 8D 47 01 80 38 6C 74 97 FE 85 7B FE FF FF FE 85 6F FE FF FF EB 0C FE 8D 7B FE FF FF FE 8D 6F FE FF FF 80 BD 57 FE FF FF 00 0F 84 FE FE FF FF 80 BD 67 FE FF FF 00 89 BD 28 FE FF FF 75 19 8B 85 18 FE FF FF 8B 30 89 85 14 FE FF FF 83 C0 04 89 85 18 FE FF FF EB 02 33 F6 32 DB 89 B5 48 FE FF FF 38 9D 6F FE FF FF 75 18 8A 07 3C 53 74 0B C6 85 6F FE FF FF FF 3C 43 75 07 C6 85 6F FE FF FF 01 0F B6 07 83 C8 20 89 85 5C FE FF FF 83 F8 6E 74 3D 83 F8 63 74 12 83 F8 7B 74 0D 8D B5 74 FE FF FF E8 ?? ?? ?? ?? EB 0B FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 83 F8 FF 0F 84 32 0B 00 00 8B B5 48 FE FF FF 8B BD 28 FE FF FF 8B 8D 4C FE FF FF 85 C9 74 0D 83 BD 68 FE FF FF 00 0F 84 F1 0A 00 00 8B 85 5C FE FF FF 83 F8 6F 0F 8F 29 05 00 00 0F 84 C8 07 00 00 83 F8 63 0F 84 D9 03 00 00 6A 64 5A 3B C2 0F 84 B4 07 00 00 0F 8E 31 05 00 00 83 F8 67 7E 45 83 F8 69 74 21 83 F8 6E 0F 85 1E 05 00 00 80 BD 67 FE FF FF 00 8B BD 74 FE FF FF 0F 84 09 0A 00 00 E9 30 0A 00 00 89 95 5C FE FF FF 83 BD 70 FE FF FF 2D 0F 85 1F 06 00 00 C6 85 64 FE FF FF 01 E9 1C 06 00 00 33 DB 83 BD 70 FE FF FF 2D 75 0C 8B 85 58 FE FF FF C6 00 2D 43 EB 09 83 BD 70 FE FF FF 2B 75 17 FF 8D 68 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 83 BD 4C FE FF FF 00 75 07 83 8D 68 FE FF FF FF 0F B6 85 70 FE FF FF EB 65 8B 85 68 FE FF FF FF 8D 68 FE FF FF 85 C0 74 60 8A 85 70 FE FF FF 8B 8D 58 FE FF FF FF 85 50 FE FF FF 88 04 0B 8D 85 3C FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 2C FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 F5 09 00 00 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 90 8B 85 04 FE FF FF 8B 80 BC 00 00 00 8B 00 8A 00 88 85 65 FE FF FF 3A 85 70 FE FF FF 0F 85 D9 00 00 00 8B 85 68 FE FF FF FF 8D 68 FE FF FF 85 C0 0F 84 C5 00 00 00 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B 8D 58 FE FF FF 89 85 70 FE FF FF 8A 85 65 FE FF FF 88 04 0B 8D 85 3C FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 2C FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 54 09 00 00 0F B6 85 70 FE FF FF EB 65 8B 85 68 FE FF FF FF 8D 68 FE FF FF 85 C0 74 60 8B 85 58 FE FF FF 8A 8D 70 FE FF FF FF 85 50 FE FF FF 88 0C 03 8D 85 3C FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 2C FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 FA 08 00 00 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 90 83 BD 50 FE FF FF 00 0F 84 4D 01 00 00 83 BD 70 FE FF FF 65 74 0D 83 BD 70 FE FF FF 45 0F 85 37 01 00 00 8B 85 68 FE FF FF FF 8D 68 FE FF FF 85 C0 0F 84 23 01 00 00 8B 85 58 FE FF FF C6 04 03 65 8D 85 3C FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 2C FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 6E 08 00 00 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 83 F8 2D 75 2C 8B 85 58 FE FF FF C6 04 03 2D 8D 85 3C FE FF FF 50 8D 85 7C FE FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 2E 08 00 00 EB 09 83 BD 70 FE FF FF 2B 75 29 8B 85 68 FE FF FF FF 8D 68 FE FF FF 85 C0 75 08 21 85 68 FE FF FF EB 11 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 0F B6 85 70 FE FF FF EB 65 8B 85 68 FE FF FF FF 8D 68 FE FF FF 85 C0 74 60 8B 85 58 FE FF FF 8A 8D 70 FE FF FF FF 85 50 FE FF FF 88 0C 03 8D 85 3C FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 2C FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 A0 07 00 00 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 90 FF B5 70 FE FF FF FF 8D 74 FE FF FF E8 ?? ?? ?? ?? 83 BD 50 FE FF FF 00 59 0F 84 62 07 00 00 80 BD 67 FE FF FF 00 0F 85 D0 06 00 00 8B 85 58 FE FF FF FF 85 38 FE FF FF 8D 8D 04 FE FF FF 51 50 FF B5 48 FE FF FF C6 04 03 00 0F BE 85 7B FE FF FF 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 83 C4 10 E9 93 06 00 00 85 C9 75 10 FF 85 68 FE FF FF C7 85 4C FE FF FF 01 00 00 00 80 BD 6F FE FF FF 00 7E 07 C6 85 66 FE FF FF 01 FF B5 70 FE FF FF FF 8D 74 FE FF FF 8B FE E8 ?? ?? ?? ?? 59 83 BD 4C FE FF FF 00 74 14 8B 85 68 FE FF FF FF 8D 68 FE FF FF 85 C0 0F 84 3B 03 00 00 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 83 BD 5C FE FF FF 63 89 85 70 FE FF FF 74 4E 83 BD 5C FE FF FF 73 75 13 83 F8 09 7C 09 83 F8 0D 0F 8E FD 02 00 00 83 F8 20 75 32 83 BD 5C FE FF FF 7B 0F 85 EB 02 00 00 0F BE 9D 65 FE FF FF 33 D2 8B C8 83 E1 07 42 D3 E2 8B C8 C1 F9 03 0F BE 4C 0D DC 33 CB 85 D1 0F 84 C6 02 00 00 80 BD 67 FE FF FF 00 0F 85 B3 02 00 00 80 BD 66 FE FF FF 00 0F 84 98 02 00 00 88 85 24 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 11 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 88 85 25 FE FF FF 8D 85 04 FE FF FF 50 8B 85 04 FE FF FF C7 85 1C FE FF FF 3F 00 00 00 FF B0 AC 00 00 00 8D 85 24 FE FF FF 50 8D 85 1C FE FF FF 50 E8 ?? ?? ?? ?? 66 8B 85 1C FE FF FF 83 C4 10 66 89 06 83 C6 02 E9 31 02 00 00 83 E8 70 0F 84 95 02 00 00 83 E8 03 0F 84 C1 FE FF FF 48 48 0F 84 8B 02 00 00 83 E8 03 0F 84 05 FB FF FF 83 E8 03 74 33 0F B6 07 3B 85 70 FE FF FF 0F 85 82 05 00 00 FE 8D 63 FE FF FF 80 BD 67 FE FF FF 00 0F 85 08 05 00 00 8B 85 14 FE FF FF 89 85 18 FE FF FF E9 F7 04 00 00 80 BD 6F FE FF FF 00 7E 07 C6 85 66 FE FF FF 01 80 7F 01 5E 8D 77 01 75 0A 8D 77 02 C6 85 65 FE FF FF FF 6A 20 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 5D 75 0C B2 5D 46 C6 45 E7 20 E9 92 00 00 00 8A 95 37 FE FF FF E9 87 00 00 00 46 3C 2D 75 6B 84 D2 74 67 8A 0E 80 F9 5D 74 60 46 3A D1 73 08 88 8D 7B FE FF FF EB 08 88 95 7B FE FF FF 8A D1 3A 95 7B FE FF FF 73 26 8A 85 7B FE FF FF 2A C2 0F B6 FA 0F B6 D0 8B CF 83 E1 07 8B C7 B3 01 D2 E3 C1 E8 03 8D 44 05 DC 08 18 47 4A 75 E8 0F B6 8D 7B FE FF FF 8B C1 83 E1 07 B2 01 D2 E2 C1 E8 03 8D 44 05 DC 08 10 32 D2 EB 17 0F B6 C8 8A D0 8B C1 83 E1 07 B3 01 C1 E8 03 D2 E3 8D 44 05 DC 08 18 8A 06 3C 5D 0F 85 6F FF FF FF 84 C0 0F 84 94 04 00 00 89 B5 28 FE FF FF 8B B5 48 FE FF FF E9 8F FD FF FF 83 BD 70 FE FF FF 2B 75 21 FF 8D 68 FE FF FF 75 08 85 C9 74 04 B3 01 EB 11 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 6A 30 5E 39 B5 70 FE FF FF 0F 85 54 01 00 00 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 3C 78 74 51 3C 58 74 4D 83 BD 5C FE FF FF 78 C7 85 50 FE FF FF 01 00 00 00 74 22 83 BD 4C FE FF FF 00 74 0A FF 8D 68 FE FF FF 75 02 FE C3 C7 85 5C FE FF FF 6F 00 00 00 E9 06 01 00 00 FF 8D 74 FE FF FF 50 E8 ?? ?? ?? ?? 59 89 B5 70 FE FF FF E9 EE 00 00 00 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 83 BD 4C FE FF FF 00 89 85 70 FE FF FF 74 12 83 AD 68 FE FF FF 02 83 BD 68 FE FF FF 01 7D 02 FE C3 C7 85 5C FE FF FF 78 00 00 00 E9 B3 00 00 00 88 06 46 89 B5 48 FE FF FF E9 BB FC FF FF 47 E9 B5 FC FF FF FF 8D 74 FE FF FF 50 E8 ?? ?? ?? ?? 59 3B FE 0F 84 80 03 00 00 80 BD 67 FE FF FF 00 0F 85 EE 02 00 00 FF 85 38 FE FF FF 83 BD 5C FE FF FF 63 0F 84 DB 02 00 00 80 BD 66 FE FF FF 00 74 10 8B 8D 48 FE FF FF 33 C0 66 89 01 E9 C2 02 00 00 8B 85 48 FE FF FF C6 00 00 E9 B4 02 00 00 C6 85 7B FE FF FF 01 83 BD 70 FE FF FF 2D 75 09 C6 85 64 FE FF FF 01 EB 09 83 BD 70 FE FF FF 2B 75 21 FF 8D 68 FE FF FF 75 08 85 C9 74 04 B3 01 EB 11 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF 83 BD 30 FE FF FF 00 0F 84 3D 01 00 00 84 DB 0F 85 FE 00 00 00 83 BD 5C FE FF FF 78 74 65 83 BD 5C FE FF FF 70 74 5C 0F B6 85 70 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 C4 00 00 00 83 BD 5C FE FF FF 6F 75 22 83 BD 70 FE FF FF 38 0F 8D AE 00 00 00 8B B5 40 FE FF FF 8B BD 44 FE FF FF 0F A4 F7 03 C1 E6 03 EB 52 6A 00 6A 0A FF B5 44 FE FF FF FF B5 40 FE FF FF E8 ?? ?? ?? ?? 8B F0 8B FA EB 37 0F B6 85 70 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6C 8B B5 40 FE FF FF 8B BD 44 FE FF FF FF B5 70 FE FF FF 0F A4 F7 04 C1 E6 04 E8 ?? ?? ?? ?? 59 89 85 70 FE FF FF 8B 85 70 FE FF FF FF 85 50 FE FF FF 83 C0 D0 99 03 F0 13 FA 83 BD 4C FE FF FF 00 89 B5 40 FE FF FF 89 BD 44 FE FF FF 74 08 FF 8D 68 FE FF FF 74 28 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF E9 14 FF FF FF FF B5 70 FE FF FF FF 8D 74 FE FF FF E8 ?? ?? ?? ?? 59 80 BD 64 FE FF FF 00 8B BD 20 FE FF FF 0F 84 ED 00 00 00 8B 85 40 FE FF FF 8B 8D 44 FE FF FF F7 D8 83 D1 00 F7 D9 89 85 40 FE FF FF 89 8D 44 FE FF FF E9 C9 00 00 00 8B BD 20 FE FF FF 84 DB 0F 85 B0 00 00 00 83 BD 5C FE FF FF 78 74 37 83 BD 5C FE FF FF 70 74 2E 0F B6 85 70 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 7A 83 BD 5C FE FF FF 6F 75 0E 83 BD 70 FE FF FF 38 7D 68 C1 E7 03 EB 2C 6B FF 0A EB 27 0F B6 85 70 FE FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 4C FF B5 70 FE FF FF C1 E7 04 E8 ?? ?? ?? ?? 59 89 85 70 FE FF FF FF 85 50 FE FF FF 83 BD 4C FE FF FF 00 8B 85 70 FE FF FF 8D 7C 07 D0 74 08 FF 8D 68 FE FF FF 74 28 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 70 FE FF FF E9 62 FF FF FF FF B5 70 FE FF FF FF 8D 74 FE FF FF E8 ?? ?? ?? ?? 59 80 BD 64 FE FF FF 00 74 02 F7 DF 83 BD 5C FE FF FF 46 75 07 83 A5 50 FE FF FF 00 83 BD 50 FE FF FF 00 0F 84 C6 00 00 00 80 BD 67 FE FF FF 00 75 38 FF 85 38 FE FF FF 8B B5 48 FE FF FF 83 BD 30 FE FF FF 00 74 13 8B 85 40 FE FF FF 89 06 8B 85 44 FE FF FF 89 46 04 EB 10 80 BD 7B FE FF FF 00 74 04 89 3E EB 03 66 89 3E 8B BD 28 FE FF FF FE 85 63 FE FF FF 47 EB 4C 3C 25 75 06 38 47 01 75 01 47 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B D8 0F B6 07 47 89 9D 70 FE FF FF 3B C3 75 40 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 19 FF 85 74 FE FF FF E8 ?? ?? ?? ?? 0F B6 0F 47 3B C8 75 22 FF 8D 74 FE FF FF 8A 07 84 C0 0F 85 B8 F2 FF FF EB 1E FF B5 70 FE FF FF E8 ?? ?? ?? ?? EB 10 53 EB F6 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 83 BD 3C FE FF FF 01 5B 75 0C FF B5 58 FE FF FF E8 ?? ?? ?? ?? 59 80 BD 10 FE FF FF 00 74 0A 8B 85 0C FE FF FF 83 60 70 FD 8B 85 38 FE FF FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "___ascii_strnicmp"
		size = 97
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 4D 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 0A E4 8A 07 74 27 0A C0 74 23 83 C6 01 83 C7 01 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 0B 83 E9 01 75 D1 33 C9 3A E0 74 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_195_1_0 {
	meta:
		name = "___dtold"
		size = 179
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 4D 0C 0F B7 41 06 53 8B D8 C1 EB 04 25 00 80 00 00 56 BA FF 07 00 00 23 DA 57 89 45 0C 8B 41 04 8B 09 0F B7 FB BE 00 00 00 80 25 FF FF 0F 00 89 75 FC 85 FF 74 13 3B FA 74 08 81 C3 00 3C 00 00 EB 28 BF FF 7F 00 00 EB 24 33 D2 3B C2 75 12 3B CA 75 0E 8B 45 08 66 8B 4D 0C 89 50 04 89 10 EB 42 81 C3 01 3C 00 00 89 55 FC 0F B7 FB 8B D1 C1 EA 15 C1 E0 0B 0B D0 0B 55 FC 8B 45 08 C1 E1 0B EB 13 8B 08 8B D9 C1 EB 1F 03 D2 0B D3 03 C9 81 C7 FF FF 00 00 89 08 89 50 04 85 D6 74 E4 8B 4D 0C 0B CF 5F 5E 66 89 48 08 5B C9 C3 }
	condition:
		$1
}

rule file_195_2_0 {
	meta:
		name = "__fltout2"
		size = 142
		refs = "0009 ___security_cookie 0027 ___dtold 0042 _$I10_OUTPUT 0062 _strcpy_s 007b @__security_check_cookie@4 0089 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 53 8B 5D 10 56 89 45 DC 57 8D 45 08 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 59 8D 45 E0 50 6A 00 6A 11 83 EC 0C 8D 75 D0 8B FC A5 A5 66 A5 E8 ?? ?? ?? ?? 8B 75 DC 89 43 08 0F BE 45 E2 89 03 0F BF 45 E0 89 43 04 8D 45 E4 50 FF 75 18 56 E8 ?? ?? ?? ?? 83 C4 24 85 C0 75 14 8B 4D FC 5F 89 73 0C 5E 8B C3 33 CD 5B E8 ?? ?? ?? ?? C9 C3 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_196_3_0 {
	meta:
		name = "__isleadbyte_l"
		size = 56
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 45 08 8B 4D F0 8B 89 C8 00 00 00 0F B7 04 41 25 00 80 00 00 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_196_5_0 {
	meta:
		name = "__iswalpha_l"
		size = 22
		refs = "000e _iswctype"
		altNames = "_iswalpha"
	strings:
		$1 = { 8B FF 55 8B EC 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_7_0 {
	meta:
		name = "__iswupper_l"
		size = 19
		refs = "000b _iswctype"
		altNames = "_iswupper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_9_0 {
	meta:
		name = "__iswlower_l"
		size = 19
		refs = "000b _iswctype"
		altNames = "_iswlower"
	strings:
		$1 = { 8B FF 55 8B EC 6A 02 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_11_0 {
	meta:
		name = "__iswdigit_l"
		size = 19
		refs = "000b _iswctype"
		altNames = "_iswdigit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 04 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_13_0 {
	meta:
		name = "__iswxdigit_l"
		size = 22
		refs = "000e _iswctype"
		altNames = "_iswxdigit"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_15_0 {
	meta:
		name = "__iswspace_l"
		size = 19
		refs = "000b _iswctype"
		altNames = "_iswspace"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_17_0 {
	meta:
		name = "__iswpunct_l"
		size = 19
		refs = "000b _iswctype"
		altNames = "_iswpunct"
	strings:
		$1 = { 8B FF 55 8B EC 6A 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_326_9_0 {
	meta:
		name = "_tmpfile_s"
		size = 19
		refs = "000b __tmpfile_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_19_0 {
	meta:
		name = "__iswalnum_l"
		size = 22
		refs = "000e _iswctype"
		altNames = "_iswalnum"
	strings:
		$1 = { 8B FF 55 8B EC 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_21_0 {
	meta:
		name = "__iswprint_l"
		size = 22
		refs = "000e _iswctype"
		altNames = "_iswprint"
	strings:
		$1 = { 8B FF 55 8B EC 68 57 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_23_0 {
	meta:
		name = "__iswgraph_l"
		size = 22
		refs = "000e _iswctype"
		altNames = "_iswgraph"
	strings:
		$1 = { 8B FF 55 8B EC 68 17 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_25_0 {
	meta:
		name = "__iswcntrl_l"
		size = 19
		refs = "000b _iswctype"
		altNames = "_iswcntrl"
	strings:
		$1 = { 8B FF 55 8B EC 6A 20 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_196_27_0 {
	meta:
		name = "_iswascii"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC B8 80 00 00 00 66 39 45 08 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_196_28_0 {
	meta:
		name = "__iswcsym_l"
		size = 38
		refs = "000e _iswctype"
		altNames = "___iswcsym"
	strings:
		$1 = { 8B FF 55 8B EC 68 07 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 09 66 83 7D 08 5F 74 02 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_196_30_0 {
	meta:
		name = "__iswcsymf_l"
		size = 38
		refs = "000e _iswctype"
		altNames = "___iswcsymf"
	strings:
		$1 = { 8B FF 55 8B EC 68 03 01 00 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 09 66 83 7D 08 5F 74 02 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "_strncmp"
		size = 192
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 53 8B 5D 10 85 DB 75 07 33 C0 E9 9A 00 00 00 56 83 FB 04 72 75 8D 73 FC 85 F6 74 6E 8B 4D 0C 8B 45 08 8A 10 83 C0 04 83 C1 04 84 D2 74 52 3A 51 FC 75 4D 8A 50 FD 84 D2 74 3C 3A 51 FD 75 37 8A 50 FE 84 D2 74 26 3A 51 FE 75 21 8A 50 FF 84 D2 74 10 3A 51 FF 75 0B 83 45 FC 04 39 75 FC 72 C2 EB 2E 0F B6 40 FF 0F B6 49 FF EB 46 0F B6 40 FE 0F B6 49 FE EB 3C 0F B6 40 FD 0F B6 49 FD EB 32 0F B6 40 FC 0F B6 49 FC EB 28 8B 4D 0C 8B 45 08 8B 75 FC EB 0D 8A 10 84 D2 74 11 3A 11 75 0D 40 46 41 3B F3 72 EF 33 C0 5E 5B C9 C3 0F B6 00 0F B6 09 2B C1 EB F2 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "_strlen"
		size = 139
	strings:
		$1 = { 8B 4C 24 04 F7 C1 03 00 00 00 74 24 8A 01 83 C1 01 84 C0 74 4E F7 C1 03 00 00 00 75 EF 05 00 00 00 00 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 32 84 E4 74 24 A9 00 00 FF 00 74 13 A9 00 00 00 FF 74 02 EB CD 8D 41 FF 8B 4C 24 04 2B C1 C3 8D 41 FE 8B 4C 24 04 2B C1 C3 8D 41 FD 8B 4C 24 04 2B C1 C3 8D 41 FC 8B 4C 24 04 2B C1 C3 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "__read_nolock"
		size = 1463
		refs = "001d ___doserrno 0025 __errno 0040 __nhandle 0059 __invalid_parameter_noinfo 0071 ___pioinfo 0118 __malloc_crt 014e __lseeki64_nolock 01f6 __imp__ReadFile@20 02b6 __imp__GetLastError@0 036a __lookuptrailbytes 03f0 __imp__MultiByteToWideChar@24 0403 __dosmaperr 0416 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 55 10 56 8B 75 08 6A FE 58 89 45 EC 89 55 E4 3B F0 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 7D 05 00 00 53 33 DB 3B F3 7C 08 3B 35 ?? ?? ?? ?? 72 1F E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 4E 05 00 00 8B C6 C1 F8 05 57 83 E6 1F 8D 3C 85 ?? ?? ?? ?? 8B 07 C1 E6 06 8A 4C 30 04 F6 C1 01 75 14 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 68 81 FA FF FF FF 7F 77 4E 89 5D F4 3B D3 0F 84 06 05 00 00 F6 C1 02 0F 85 FD 04 00 00 39 5D 0C 74 35 8A 44 30 24 02 C0 D0 F8 88 45 FE 0F BE C0 48 6A 04 59 74 19 48 75 0E 8B C2 F7 D0 A8 01 74 16 83 E2 FE 89 55 10 8B 5D 0C 89 5D F0 EB 7A 8B C2 F7 D0 A8 01 75 19 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 36 8B C2 D1 E8 89 4D 10 3B C1 72 03 89 45 10 FF 75 10 E8 ?? ?? ?? ?? 8B D8 59 89 5D F0 85 DB 75 1E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 6E 04 00 00 6A 01 6A 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 8B 0F 89 44 0E 28 83 C4 10 89 54 0E 2C 8B 0F 03 CE F6 41 04 48 8B C3 74 7A 8A 49 05 80 F9 0A 74 72 83 7D 10 00 74 6C FF 4D 10 80 7D FE 00 88 0B 8B 0F 8D 43 01 C7 45 F4 01 00 00 00 C6 44 0E 05 0A 74 50 8B 0F 8A 4C 0E 25 80 F9 0A 74 45 83 7D 10 00 74 3F 88 08 8B 0F 40 FF 4D 10 80 7D FE 01 C7 45 F4 02 00 00 00 C6 44 0E 25 0A 75 25 8B 0F 8A 4C 0E 26 80 F9 0A 74 1A 83 7D 10 00 74 14 88 08 8B 0F 40 FF 4D 10 C7 45 F4 03 00 00 00 C6 44 0E 26 0A 6A 00 8D 4D E8 51 FF 75 10 50 8B 07 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 0F 84 78 03 00 00 8B 4D E8 85 C9 0F 88 6D 03 00 00 3B 4D 10 0F 87 64 03 00 00 8B 07 01 4D F4 8D 44 06 04 F6 00 80 0F 84 E4 01 00 00 80 7D FE 02 0F 84 14 02 00 00 85 C9 74 0A 80 3B 0A 75 05 80 08 04 EB 03 80 20 FB 8B 5D F0 8B 45 F4 03 C3 89 5D 10 89 45 F4 3B D8 0F 83 D1 00 00 00 8B 4D 10 8A 01 3C 1A 0F 84 AF 00 00 00 3C 0D 74 0C 88 03 43 41 89 4D 10 E9 91 00 00 00 8B 45 F4 48 3B C8 73 18 8D 41 01 80 38 0A 75 0B 83 C1 02 89 4D 10 C6 03 0A EB 75 89 45 10 EB 6D FF 45 10 6A 00 8D 45 E8 50 6A 01 8D 45 FF 50 8B 07 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 85 C0 75 45 83 7D E8 00 74 3F 8B 07 F6 44 06 04 48 74 14 80 7D FF 0A 74 B9 C6 03 0D 8B 07 8A 4D FF 88 4C 06 05 EB 25 3B 5D F0 75 06 80 7D FF 0A 74 A0 6A 01 6A FF 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 80 7D FF 0A 74 04 C6 03 0D 43 8B 45 F4 39 45 10 0F 82 46 FF FF FF EB 15 8B 07 8D 44 06 04 F6 00 40 75 05 80 08 02 EB 05 8A 01 88 03 43 8B C3 2B 45 F0 80 7D FE 01 89 45 F4 0F 85 D0 00 00 00 85 C0 0F 84 C8 00 00 00 4B 8A 0B 84 C9 78 06 43 E9 86 00 00 00 33 C0 40 0F B6 C9 EB 0F 83 F8 04 7F 13 3B 5D F0 72 0E 4B 0F B6 0B 40 80 B9 ?? ?? ?? ?? 00 74 E8 8A 13 0F B6 CA 0F BE 89 ?? ?? ?? ?? 85 C9 75 0D E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 7A 41 3B C8 75 04 03 D8 EB 40 8B 0F F6 44 31 04 48 74 25 43 88 54 31 05 83 F8 02 7C 09 8A 13 8B 0F 88 54 0E 25 43 83 F8 03 75 09 8A 13 8B 0F 88 54 0E 26 43 2B D8 EB 12 F7 D8 99 6A 01 52 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B 45 E4 2B 5D F0 D1 E8 50 FF 75 0C 53 FF 75 F0 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 89 45 F4 85 C0 75 34 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 4D EC FF 8B 45 F0 3B 45 0C 74 07 50 E8 ?? ?? ?? ?? 59 8B 45 EC 83 F8 FE 0F 85 8B 01 00 00 8B 45 F4 E9 83 01 00 00 8B 45 F4 8B 17 33 C9 3B C3 0F 95 C1 03 C0 89 45 F4 89 4C 16 30 EB C6 85 C9 74 0B 66 83 3B 0A 75 05 80 08 04 EB 03 80 20 FB 8B 5D F0 8B 45 F4 03 C3 89 5D 10 89 45 F4 3B D8 0F 83 01 01 00 00 8B 45 10 0F B7 08 83 F9 1A 0F 84 D9 00 00 00 83 F9 0D 74 11 66 89 0B 83 C3 02 83 C0 02 89 45 10 E9 B5 00 00 00 8B 4D F4 83 C1 FE 3B C1 73 1E 8D 48 02 66 83 39 0A 75 0D 83 C0 04 89 45 10 6A 0A E9 8E 00 00 00 89 4D 10 E9 84 00 00 00 83 45 10 02 6A 00 8D 45 E8 50 6A 02 8D 45 F8 50 8B 07 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 85 C0 75 5B 83 7D E8 00 74 55 8B 07 F6 44 06 04 48 74 28 66 83 7D F8 0A 74 B2 6A 0D 58 66 89 03 8B 07 8A 4D F8 88 4C 06 05 8B 07 8A 4D F9 88 4C 06 25 8B 07 C6 44 06 26 0A EB 2A 3B 5D F0 75 07 66 83 7D F8 0A 74 85 6A 01 6A FF 6A FE FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 66 83 7D F8 0A 74 09 6A 0D 58 66 89 03 83 C3 02 8B 45 F4 39 45 10 0F 82 1A FF FF FF EB 19 8B 0F 8D 74 0E 04 F6 06 40 75 05 80 0E 02 EB 09 66 8B 00 66 89 03 83 C3 02 2B 5D F0 89 5D F4 E9 92 FE FF FF FF 15 ?? ?? ?? ?? 6A 05 5E 3B C6 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 30 E9 6A FE FF FF 83 F8 6D 0F 85 5A FE FF FF 83 65 EC 00 E9 5C FE FF FF 33 C0 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_199_1_0 {
	meta:
		name = "__read"
		size = 246
		refs = "0003 __sehtable$__read 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0035 __nhandle 004f __invalid_parameter_noinfo 005d ___pioinfo 0099 ___lock_fhandle 00b3 __read_nolock 00e6 __SEH_epilog4 00f0 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 83 FB FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 B6 00 00 00 85 DB 78 08 3B 1D ?? ?? ?? ?? 72 1A E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB D2 8B C3 C1 F8 05 8D 3C 85 ?? ?? ?? ?? 8B F3 83 E6 1F C1 E6 06 8B 07 0F BE 44 30 04 83 E0 01 74 C6 B8 FF FF FF 7F 3B 45 10 1B C0 40 75 15 E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B7 53 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 07 F6 44 30 04 01 74 14 FF 75 10 FF 75 0C 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 5D 08 53 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_200_1_0 {
	meta:
		name = "__set_controlfp"
		size = 115
		refs = "0035 ___sse2_available 005b __controlfp_s 006c __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 56 33 F6 81 7D 08 1F 00 09 00 75 3A 83 F8 FF 75 35 9B D9 7D FC 0F B7 4D FC 81 E1 3D 1F 00 00 BA 3D 02 00 00 66 3B CA 75 1D 39 35 ?? ?? ?? ?? 74 35 0F AE 5D F8 8B 4D F8 81 E1 C0 FE 00 00 81 F9 80 1E 00 00 74 20 25 FF FF F7 FF 50 FF 75 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0A 56 56 56 56 56 E8 ?? ?? ?? ?? 5E C9 C3 }
	condition:
		$1
}

rule file_200_2_0 {
	meta:
		name = "__abstract_cw"
		size = 159
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 33 C0 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 53 0F B7 D1 56 8B CA BE 00 0C 00 00 23 CE 57 BF 00 03 00 00 BB 00 02 00 00 74 21 81 F9 00 04 00 00 74 14 81 F9 00 08 00 00 74 08 3B CE 75 0D 0B C7 EB 09 0B C3 EB 05 0D 00 01 00 00 23 D7 74 0B 3B D3 75 0C 0D 00 00 01 00 EB 05 0D 00 00 02 00 F7 45 08 00 10 00 00 5F 5E 5B 74 05 0D 00 00 04 00 5D C3 }
	condition:
		$1
}

rule file_200_3_0 {
	meta:
		name = "__hw_cw"
		size = 142
	strings:
		$1 = { 33 C0 F6 C3 10 74 01 40 F6 C3 08 74 03 83 C8 04 F6 C3 04 74 03 83 C8 08 F6 C3 02 74 03 83 C8 10 F6 C3 01 74 03 83 C8 20 F7 C3 00 00 08 00 74 03 83 C8 02 8B CB BA 00 03 00 00 23 CA 56 BE 00 02 00 00 74 23 81 F9 00 01 00 00 74 16 3B CE 74 0B 3B CA 75 13 0D 00 0C 00 00 EB 0C 0D 00 08 00 00 EB 05 0D 00 04 00 00 8B CB 81 E1 00 00 03 00 74 0C 81 F9 00 00 01 00 75 06 0B C6 EB 02 0B C2 5E F7 C3 00 00 04 00 74 05 0D 00 10 00 00 C3 }
	condition:
		$1
}

rule file_200_4_0 {
	meta:
		name = "__abstract_sw"
		size = 67
		altNames = "___abstract_sw_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 8A 4D 08 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 5D C3 }
	condition:
		$1
}

rule file_200_5_0 {
	meta:
		name = "___abstract_cw_sse2"
		size = 160
	strings:
		$1 = { 33 C0 84 D2 79 03 6A 10 58 53 BB 00 02 00 00 56 57 85 D3 74 03 83 C8 08 F7 C2 00 04 00 00 74 03 83 C8 04 F7 C2 00 08 00 00 74 03 83 C8 02 F7 C2 00 10 00 00 74 03 83 C8 01 BF 00 01 00 00 85 D7 74 05 0D 00 00 08 00 8B CA BE 00 60 00 00 23 CE 74 21 81 F9 00 20 00 00 74 17 81 F9 00 40 00 00 74 0B 3B CE 75 0D 0D 00 03 00 00 EB 06 0B C3 EB 02 0B C7 5F 81 E2 40 80 00 00 83 EA 40 5E 5B 74 19 81 EA C0 7F 00 00 74 0B 83 EA 40 75 11 0D 00 00 00 01 C3 0D 00 00 00 03 C3 0D 00 00 00 02 C3 }
	condition:
		$1
}

rule file_200_6_0 {
	meta:
		name = "___hw_cw_sse2"
		size = 160
	strings:
		$1 = { 33 C0 F6 C2 10 74 05 B8 80 00 00 00 53 56 57 BB 00 02 00 00 F6 C2 08 74 02 0B C3 F6 C2 04 74 05 0D 00 04 00 00 F6 C2 02 74 05 0D 00 08 00 00 F6 C2 01 74 05 0D 00 10 00 00 BF 00 01 00 00 F7 C2 00 00 08 00 74 02 0B C7 8B CA BE 00 03 00 00 23 CE 74 1F 3B CF 74 16 3B CB 74 0B 3B CE 75 13 0D 00 60 00 00 EB 0C 0D 00 40 00 00 EB 05 0D 00 20 00 00 B9 00 00 00 03 5F 23 D1 5E 5B 81 FA 00 00 00 01 74 16 81 FA 00 00 00 02 74 0A 3B D1 75 0F 0D 00 80 00 00 C3 83 C8 40 C3 0D 40 80 00 00 C3 }
	condition:
		$1
}

rule file_200_9_0 {
	meta:
		name = "__statusfp"
		size = 146
		refs = "0045 ___sse2_available"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 9B DD 7D FC 8A 45 FC 33 D2 BE 00 00 08 00 A8 3F 74 29 A8 01 74 03 6A 10 5A A8 04 74 03 83 CA 08 A8 08 74 03 83 CA 04 A8 10 74 03 83 CA 02 A8 20 74 03 83 CA 01 A8 02 74 02 0B D6 83 3D ?? ?? ?? ?? 00 74 41 0F AE 5D F8 8A 4D F8 33 C0 F6 C1 3F 74 2F F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 02 0B C6 0B C2 EB 02 8B C2 5E C9 C3 }
	condition:
		$1
}

rule file_200_10_0 {
	meta:
		name = "__fpreset"
		size = 56
		refs = "0004 ___pxcptinfoptrs 000d __setdefaultprecision 0017 ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 8B 30 DB E3 E8 ?? ?? ?? ?? 68 80 1F 00 00 E8 ?? ?? ?? ?? 59 85 F6 74 16 8B 46 04 F7 00 08 00 01 00 74 0B 83 60 20 00 C7 40 24 FF FF 00 00 5E C3 }
	condition:
		$1
}

rule file_200_11_0 {
	meta:
		name = "___statusfp_sse2"
		size = 59
		refs = "0001 ___get_fpsr_sse2"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 A8 3F 74 2D A8 01 74 03 6A 10 59 A8 04 74 03 83 C9 08 A8 08 74 03 83 C9 04 A8 10 74 03 83 C9 02 A8 20 74 03 83 C9 01 A8 02 74 06 81 C9 00 00 08 00 8B C1 C3 }
	condition:
		$1
}

rule file_200_12_0 {
	meta:
		name = "___clearfp_sse2"
		size = 80
	strings:
		$1 = { 8B FF 55 8B EC 51 0F AE 5D FC 83 65 FC C0 0F AE 55 FC 8A 4D FC 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 C9 C3 }
	condition:
		$1
}

rule file_200_13_0 {
	meta:
		name = "___control87_sse2"
		size = 374
		refs = "00cc ___hw_cw_sse2 00d5 ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 81 65 0C 1F 03 08 03 0F AE 5D F8 8B 4D F8 33 C0 84 C9 79 03 6A 10 58 53 BB 00 02 00 00 56 57 85 CB 74 03 83 C8 08 F7 C1 00 04 00 00 74 03 83 C8 04 F7 C1 00 08 00 00 74 03 83 C8 02 F7 C1 00 10 00 00 74 03 83 C8 01 BE 00 01 00 00 85 CE 74 05 0D 00 00 08 00 8B D1 BF 00 60 00 00 23 D7 74 21 81 FA 00 20 00 00 74 17 81 FA 00 40 00 00 74 0B 3B D7 75 0D 0D 00 03 00 00 EB 06 0B C3 EB 02 0B C6 BE 40 80 00 00 23 CE 83 E9 40 74 1B 81 E9 C0 7F 00 00 74 0C 83 E9 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 8B 55 0C 8B 4D 08 23 4D 0C F7 D2 23 D0 0B D1 3B D0 0F 84 A6 00 00 00 E8 ?? ?? ?? ?? 50 89 45 FC E8 ?? ?? ?? ?? 59 0F AE 5D FC 8B 55 FC 33 C0 84 D2 79 03 6A 10 58 85 D3 74 03 83 C8 08 F7 C2 00 04 00 00 74 03 83 C8 04 F7 C2 00 08 00 00 74 03 83 C8 02 F7 C2 00 10 00 00 74 03 83 C8 01 BB 00 01 00 00 85 D3 74 05 0D 00 00 08 00 8B CA 23 CF 74 24 81 F9 00 20 00 00 74 1A 81 F9 00 40 00 00 74 0B 3B CF 75 10 0D 00 03 00 00 EB 09 0D 00 02 00 00 EB 02 0B C3 23 D6 83 EA 40 74 1B 81 EA C0 7F 00 00 74 0C 83 EA 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_200_14_0 {
	meta:
		name = "__statusfp2"
		size = 90
		refs = "0051 ___statusfp_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 85 D2 74 3C 9B DD 7D 08 8A 45 08 33 C9 A8 3F 74 2D A8 01 74 03 6A 10 59 A8 04 74 03 83 C9 08 A8 08 74 03 83 C9 04 A8 10 74 03 83 C9 02 A8 20 74 03 83 C9 01 A8 02 74 06 81 C9 00 00 08 00 89 0A 56 8B 75 0C 85 F6 74 07 E8 ?? ?? ?? ?? 89 06 5E 5D C3 }
	condition:
		$1
}

rule file_200_15_0 {
	meta:
		name = "__clearfp"
		size = 217
		refs = "000e ___sse2_available"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 7D FC DB E2 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 8A 45 FC 33 D2 56 BE 00 00 08 00 A8 3F 74 29 A8 01 74 03 6A 10 5A A8 04 74 03 83 CA 08 A8 08 74 03 83 CA 04 A8 10 74 03 83 CA 02 A8 20 74 03 83 CA 01 A8 02 74 02 0B D6 0F AE 5D F8 83 65 F8 C0 0F AE 55 F8 8A 4D F8 33 C0 F6 C1 3F 74 2F F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 02 0B C6 0B C2 5E C9 C3 8A 4D FC 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 C9 C3 }
	condition:
		$1
}

rule file_200_16_0 {
	meta:
		name = "___control87_2"
		size = 791
		refs = "00ce __hw_cw 0182 ___sse2_available 0254 ___hw_cw_sse2 025d ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 83 EC 10 53 56 33 D2 57 BF 00 03 00 00 39 55 10 0F 84 56 01 00 00 9B D9 7D FC 66 8B 5D FC F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 C3 8B C8 BE 00 0C 00 00 23 CE 74 26 81 F9 00 04 00 00 74 18 81 F9 00 08 00 00 74 08 3B CE 75 12 0B D7 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 23 C7 74 0F 3D 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 0F B7 C3 A9 00 10 00 00 74 06 81 CA 00 00 04 00 8B 5D 0C 8B 45 08 23 45 0C F7 D3 23 DA 0B D8 3B DA 0F 84 9F 00 00 00 E8 ?? ?? ?? ?? 0F B7 C0 89 45 F8 D9 6D F8 9B D9 7D F8 8B 55 F8 33 DB F6 C2 01 74 03 6A 10 5B F6 C2 04 74 03 83 CB 08 F6 C2 08 74 03 83 CB 04 F6 C2 10 74 03 83 CB 02 F6 C2 20 74 03 83 CB 01 F6 C2 02 74 06 81 CB 00 00 08 00 0F B7 CA 8B C1 23 C6 74 24 3D 00 04 00 00 74 17 3D 00 08 00 00 74 08 3B C6 75 12 0B DF EB 0E 81 CB 00 02 00 00 EB 06 81 CB 00 01 00 00 23 CF 74 10 81 F9 00 02 00 00 75 0E 81 CB 00 00 01 00 EB 06 81 CB 00 00 02 00 F7 C2 00 10 00 00 74 06 81 CB 00 00 04 00 8B 45 10 89 18 8B 45 0C 83 7D 14 00 0F 84 91 01 00 00 33 F6 39 35 ?? ?? ?? ?? 0F 84 7E 01 00 00 25 1F 03 08 03 89 45 F0 0F AE 5D F4 8B 45 F4 84 C0 79 03 6A 10 5E A9 00 02 00 00 74 03 83 CE 08 A9 00 04 00 00 74 03 83 CE 04 A9 00 08 00 00 74 03 83 CE 02 A9 00 10 00 00 74 03 83 CE 01 A9 00 01 00 00 74 06 81 CE 00 00 08 00 8B C8 BF 00 60 00 00 23 CF 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CF 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BB 40 80 00 00 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B 45 F0 8B D0 23 45 08 F7 D2 23 D6 0B D0 3B D6 75 07 8B C6 E9 B0 00 00 00 E8 ?? ?? ?? ?? 50 89 45 10 E8 ?? ?? ?? ?? 59 0F AE 5D 10 8B 4D 10 33 D2 84 C9 79 03 6A 10 5A F7 C1 00 02 00 00 74 03 83 CA 08 F7 C1 00 04 00 00 74 03 83 CA 04 F7 C1 00 08 00 00 74 03 83 CA 02 F7 C1 00 10 00 00 74 03 83 CA 01 BE 00 01 00 00 85 CE 74 06 81 CA 00 00 08 00 8B C1 23 C7 74 24 3D 00 20 00 00 74 1B 3D 00 40 00 00 74 0C 3B C7 75 12 81 CA 00 03 00 00 EB 0A 81 CA 00 02 00 00 EB 02 0B D6 23 CB 83 E9 40 74 1D 81 E9 C0 7F 00 00 74 0D 83 E9 40 75 16 81 CA 00 00 00 01 EB 0E 81 CA 00 00 00 03 EB 06 81 CA 00 00 00 02 8B C2 8B 4D 14 89 01 EB 05 8B 45 14 89 30 5F 33 C0 5E 40 5B C9 C3 }
	condition:
		$1
}

rule file_200_17_0 {
	meta:
		name = "__control87"
		size = 786
		refs = "00c7 __hw_cw 0176 ___sse2_available 0249 ___hw_cw_sse2 0252 ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 57 9B D9 7D FC 66 8B 5D FC 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 BE 00 0C 00 00 23 C6 BF 00 03 00 00 74 24 3D 00 04 00 00 74 17 3D 00 08 00 00 74 08 3B C6 75 12 0B D7 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 23 CF 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 0F B7 C3 A9 00 10 00 00 74 06 81 CA 00 00 04 00 8B 7D 0C 8B 4D 08 8B C7 F7 D0 23 C2 23 CF 0B C1 89 45 0C 3B C2 0F 84 AE 00 00 00 8B D8 E8 ?? ?? ?? ?? 0F B7 C0 89 45 F8 D9 6D F8 9B D9 7D F8 8B 5D F8 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 23 C6 74 28 3D 00 04 00 00 74 1B 3D 00 08 00 00 74 0C 3B C6 75 16 81 CA 00 03 00 00 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 81 E1 00 03 00 00 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 F7 C3 00 10 00 00 74 06 81 CA 00 00 04 00 89 55 0C 8B C2 33 F6 39 35 ?? ?? ?? ?? 0F 84 8D 01 00 00 81 E7 1F 03 08 03 89 7D EC 0F AE 5D F0 8B 45 F0 84 C0 79 03 6A 10 5E A9 00 02 00 00 74 03 83 CE 08 A9 00 04 00 00 74 03 83 CE 04 A9 00 08 00 00 74 03 83 CE 02 A9 00 10 00 00 74 03 83 CE 01 A9 00 01 00 00 74 06 81 CE 00 00 08 00 8B C8 BB 00 60 00 00 23 CB 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CB 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BF 40 80 00 00 23 C7 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B 45 EC 8B D0 23 45 08 F7 D2 23 D6 0B D0 3B D6 75 07 8B C6 E9 B0 00 00 00 E8 ?? ?? ?? ?? 50 89 45 F4 E8 ?? ?? ?? ?? 59 0F AE 5D F4 8B 4D F4 33 D2 84 C9 79 03 6A 10 5A F7 C1 00 02 00 00 74 03 83 CA 08 F7 C1 00 04 00 00 74 03 83 CA 04 F7 C1 00 08 00 00 74 03 83 CA 02 F7 C1 00 10 00 00 74 03 83 CA 01 BE 00 01 00 00 85 CE 74 06 81 CA 00 00 08 00 8B C1 23 C3 74 24 3D 00 20 00 00 74 1B 3D 00 40 00 00 74 0C 3B C3 75 12 81 CA 00 03 00 00 EB 0A 81 CA 00 02 00 00 EB 02 0B D6 23 CF 83 E9 40 74 1D 81 E9 C0 7F 00 00 74 0D 83 E9 40 75 16 81 CA 00 00 00 01 EB 0E 81 CA 00 00 00 03 EB 06 81 CA 00 00 00 02 8B C2 8B C8 33 4D 0C 0B 45 0C F7 C1 1F 03 08 00 74 05 0D 00 00 00 80 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_200_18_0 {
	meta:
		name = "__controlfp"
		size = 789
		refs = "00d0 __hw_cw 017f ___sse2_available 0252 ___hw_cw_sse2 025b ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 57 8B 7D 0C 81 E7 FF FF F7 FF 9B D9 7D 0C 66 8B 5D 0C 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 BE 00 0C 00 00 23 C6 74 28 3D 00 04 00 00 74 1B 3D 00 08 00 00 74 0C 3B C6 75 16 81 CA 00 03 00 00 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 81 E1 00 03 00 00 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 0F B7 C3 A9 00 10 00 00 74 06 81 CA 00 00 04 00 8B C7 F7 D0 8B CF 23 4D 08 23 C2 0B C1 89 45 F0 3B C2 0F 84 AE 00 00 00 8B D8 E8 ?? ?? ?? ?? 0F B7 C0 89 45 FC D9 6D FC 9B D9 7D FC 8B 5D FC 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 23 C6 74 28 3D 00 04 00 00 74 1B 3D 00 08 00 00 74 0C 3B C6 75 16 81 CA 00 03 00 00 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 81 E1 00 03 00 00 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 F7 C3 00 10 00 00 74 06 81 CA 00 00 04 00 8B C2 89 55 F0 33 F6 39 35 ?? ?? ?? ?? 0F 84 87 01 00 00 81 E7 1F 03 08 03 89 7D EC 0F AE 5D F4 8B 45 F4 84 C0 79 03 6A 10 5E A9 00 02 00 00 74 03 83 CE 08 A9 00 04 00 00 74 03 83 CE 04 A9 00 08 00 00 74 03 83 CE 02 A9 00 10 00 00 74 03 83 CE 01 A9 00 01 00 00 74 06 81 CE 00 00 08 00 8B C8 BF 00 60 00 00 23 CF 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CF 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BB 40 80 00 00 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B 45 EC 8B D0 23 45 08 F7 D2 23 D6 0B D0 3B D6 75 07 8B C6 E9 AA 00 00 00 E8 ?? ?? ?? ?? 50 89 45 F8 E8 ?? ?? ?? ?? 59 0F AE 5D F8 8B 55 F8 33 C0 84 D2 79 03 6A 10 58 F7 C2 00 02 00 00 74 03 83 C8 08 F7 C2 00 04 00 00 74 03 83 C8 04 F7 C2 00 08 00 00 74 03 83 C8 02 F7 C2 00 10 00 00 74 03 83 C8 01 BE 00 01 00 00 85 D6 74 05 0D 00 00 08 00 8B CA 23 CF 74 24 81 F9 00 20 00 00 74 1A 81 F9 00 40 00 00 74 0B 3B CF 75 10 0D 00 03 00 00 EB 09 0D 00 02 00 00 EB 02 0B C6 23 D3 83 EA 40 74 1B 81 EA C0 7F 00 00 74 0C 83 EA 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 8B C8 33 4D F0 0B 45 F0 F7 C1 1F 03 08 00 74 05 0D 00 00 00 80 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_201_6_0 {
	meta:
		name = "__inc"
		size = 22
		refs = "0010 __filbuf"
	strings:
		$1 = { FF 4A 04 78 09 8B 0A 0F B6 01 41 89 0A C3 52 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_201_8_0 {
	meta:
		name = "__whiteout"
		size = 42
		refs = "000c __inc 001c _isspace"
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 55 08 FF 06 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 0E 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 75 E1 8B C3 5B 5D C3 }
	condition:
		$1
}

rule file_201_9_0 {
	meta:
		name = "__input_s_l"
		size = 4387
		refs = "000c ___security_cookie 0067 __errno 0072 __invalid_parameter_noinfo 008b __fileno 0091 ___badioinfo 00af ___pioinfo 0105 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 012b _isspace 0147 __whiteout 0159 __ungetc_nolock 01ff _isdigit 038c __inc 051a ___check_float_string 0826 __cfltcvt_tab 082c __imp__DecodePointer@4 094d _isleadbyte 0999 __mbtowc_l 0a36 _memset 0d33 __allmul 0d4a _isxdigit 0d74 __hextodec 10aa _free 111d @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 04 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 14 8B 45 08 56 8B 75 0C 57 33 FF 89 8D 1C FE FF FF 8D 8D 7C FE FF FF 89 85 60 FE FF FF 89 B5 50 FE FF FF 89 8D 58 FE FF FF C7 85 28 FE FF FF 5E 01 00 00 89 BD 30 FE FF FF 89 BD 10 FE FF FF 89 BD 6C FE FF FF 89 BD 0C FE FF FF 3B F7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 97 10 00 00 3B C7 74 E4 F6 40 0C 40 53 75 72 50 E8 ?? ?? ?? ?? 59 BA ?? ?? ?? ?? 83 F8 FF 74 1B 83 F8 FE 74 16 8B C8 83 E1 1F 8B D8 C1 FB 05 C1 E1 06 03 0C 9D ?? ?? ?? ?? EB 02 8B CA F6 41 24 7F 75 26 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 83 E0 1F C1 F9 05 C1 E0 06 03 04 8D ?? ?? ?? ?? EB 02 8B C2 F6 40 24 80 74 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 19 10 00 00 FF 75 10 8D 8D FC FD FF FF E8 ?? ?? ?? ?? 8A 06 C6 85 5E FE FF FF 00 89 BD 74 FE FF FF 89 BD 38 FE FF FF 84 C0 0F 84 D5 0F 00 00 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 4B FF B5 60 FE FF FF FF 8D 74 FE FF FF 8D B5 74 FE FF FF E8 ?? ?? ?? ?? 59 83 F8 FF 74 0E FF B5 60 FE FF FF 50 E8 ?? ?? ?? ?? 59 59 8B B5 50 FE FF FF 46 0F B6 06 50 E8 ?? ?? ?? ?? 59 85 C0 75 F1 89 B5 50 FE FF FF E9 70 0E 00 00 8B B5 50 FE FF FF 8A 06 3C 25 0F 85 DA 0D 00 00 38 46 01 0F 84 C7 0D 00 00 33 FF 89 BD 3C FE FF FF C6 85 2F FE FF FF 00 89 BD 54 FE FF FF 89 BD 40 FE FF FF 89 BD 64 FE FF FF 89 BD 34 FE FF FF C6 85 5D FE FF FF 00 C6 85 5C FE FF FF 00 C6 85 6A FE FF FF 00 C6 85 73 FE FF FF 00 C6 85 5F FE FF FF 00 C6 85 6B FE FF FF 00 C6 85 7B FE FF FF 01 89 BD 24 FE FF FF 46 0F B6 1E 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 64 FE FF FF FF 85 40 FE FF FF 6B C0 0A 8D 44 18 D0 89 85 64 FE FF FF E9 C5 00 00 00 83 FB 4E 0F 8F 83 00 00 00 0F 84 B6 00 00 00 83 FB 2A 74 70 83 FB 46 0F 84 A8 00 00 00 83 FB 49 74 10 83 FB 4C 75 74 FE 85 7B FE FF FF E9 93 00 00 00 8A 4E 01 80 F9 36 75 1E 8D 46 02 80 38 34 75 16 FF 85 24 FE FF FF 8B F0 89 BD 48 FE FF FF 89 BD 4C FE FF FF EB 6D 80 F9 33 75 0C 8D 46 02 80 38 32 75 04 8B F0 EB 5C 80 F9 64 74 57 80 F9 69 74 52 80 F9 6F 74 4D 80 F9 78 74 48 80 F9 58 75 19 EB 41 FE 85 6A FE FF FF EB 39 83 FB 68 74 28 83 FB 6C 74 0D 83 FB 77 74 16 FE 85 73 FE FF FF EB 22 8D 46 01 80 38 6C 74 97 FE 85 7B FE FF FF FE 85 6B FE FF FF EB 0C FE 8D 7B FE FF FF FE 8D 6B FE FF FF 80 BD 73 FE FF FF 00 0F 84 FE FE FF FF 80 BD 6A FE FF FF 00 89 B5 50 FE FF FF 75 19 8B 85 1C FE FF FF 8B 18 89 85 14 FE FF FF 83 C0 04 89 85 1C FE FF FF EB 02 33 DB 80 BD 6B FE FF FF 00 89 9D 44 FE FF FF C6 85 73 FE FF FF 00 75 18 8A 06 3C 53 74 0B C6 85 6B FE FF FF FF 3C 43 75 07 C6 85 6B FE FF FF 01 0F B6 3E 83 CF 20 89 BD 18 FE FF FF 83 FF 6E 74 50 83 FF 63 74 19 83 FF 7B 74 14 FF B5 60 FE FF FF 8D B5 74 FE FF FF E8 ?? ?? ?? ?? 59 EB 11 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 83 F8 FF 0F 84 FB 0C 00 00 8B 9D 44 FE FF FF 8B B5 50 FE FF FF 8B BD 18 FE FF FF 8B 8D 40 FE FF FF 85 C9 74 0D 83 BD 64 FE FF FF 00 0F 84 36 0C 00 00 80 BD 6A FE FF FF 00 75 41 83 FF 63 74 0A 83 FF 73 74 05 83 FF 7B 75 32 8B 85 14 FE FF FF 8B 18 83 C0 04 89 85 14 FE FF FF 83 C0 04 89 85 1C FE FF FF 8B 40 FC 89 9D 44 FE FF FF 89 85 34 FE FF FF 83 F8 01 0F 82 F5 0B 00 00 83 FF 6F 0F 8F 97 05 00 00 0F 84 55 08 00 00 83 FF 63 0F 84 10 04 00 00 83 FF 64 0F 84 43 08 00 00 0F 8E A3 05 00 00 83 FF 67 7E 44 83 FF 69 74 21 83 FF 6E 0F 85 90 05 00 00 80 BD 6A FE FF FF 00 8B 85 74 FE FF FF 0F 84 BF 0A 00 00 E9 E6 0A 00 00 6A 64 5F 8B 9D 6C FE FF FF 83 FB 2D 0F 85 93 06 00 00 C6 85 5C FE FF FF 01 E9 8C 06 00 00 33 DB 83 BD 6C FE FF FF 2D 75 0C 8B 85 58 FE FF FF C6 00 2D 43 EB 09 83 BD 6C FE FF FF 2B 75 1D FF 8D 64 FE FF FF 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 83 BD 40 FE FF FF 00 75 07 83 8D 64 FE FF FF FF 0F B6 85 6C FE FF FF EB 6B 8B 85 64 FE FF FF FF 8D 64 FE FF FF 85 C0 74 66 8A 85 6C FE FF FF 8B 8D 58 FE FF FF FF 85 54 FE FF FF 88 04 0B 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 71 0B 00 00 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 8A 8B 85 FC FD FF FF 8B 80 BC 00 00 00 8B 00 8A 00 88 85 5D FE FF FF 3A 85 6C FE FF FF 0F 85 E5 00 00 00 8B 85 64 FE FF FF FF 8D 64 FE FF FF 85 C0 0F 84 D1 00 00 00 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B 8D 58 FE FF FF 89 85 6C FE FF FF 8A 85 5D FE FF FF 88 04 0B 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 C4 0A 00 00 0F B6 85 6C FE FF FF EB 6B 8B 85 64 FE FF FF FF 8D 64 FE FF FF 85 C0 74 66 8B 85 58 FE FF FF 8A 8D 6C FE FF FF FF 85 54 FE FF FF 88 0C 03 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 6A 0A 00 00 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 8A 83 BD 54 FE FF FF 00 0F 84 5F 01 00 00 83 BD 6C FE FF FF 65 74 0D 83 BD 6C FE FF FF 45 0F 85 49 01 00 00 8B 85 64 FE FF FF FF 8D 64 FE FF FF 85 C0 0F 84 35 01 00 00 8B 85 58 FE FF FF C6 04 03 65 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 D8 09 00 00 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 83 F8 2D 75 2C 8B 85 58 FE FF FF C6 04 03 2D 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 92 09 00 00 EB 09 83 BD 6C FE FF FF 2B 75 2F 8B 85 64 FE FF FF FF 8D 64 FE FF FF 85 C0 75 08 21 85 64 FE FF FF EB 17 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 0F B6 85 6C FE FF FF EB 6B 8B 85 64 FE FF FF FF 8D 64 FE FF FF 85 C0 74 66 8B 85 58 FE FF FF 8A 8D 6C FE FF FF FF 85 54 FE FF FF 88 0C 03 8D 85 30 FE FF FF 50 8D 85 7C FE FF FF 50 43 53 8D BD 58 FE FF FF 8D B5 28 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 FE 08 00 00 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 75 8A FF 8D 74 FE FF FF 83 BD 6C FE FF FF FF 74 13 FF B5 60 FE FF FF FF B5 6C FE FF FF E8 ?? ?? ?? ?? 59 59 83 BD 54 FE FF FF 00 0F 84 AA 08 00 00 80 BD 6A FE FF FF 00 0F 85 4D 07 00 00 8B 85 58 FE FF FF FF 85 38 FE FF FF 8D 8D FC FD FF FF 51 50 FF B5 44 FE FF FF C6 04 03 00 0F BE 85 7B FE FF FF 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 83 C4 10 E9 10 07 00 00 85 C9 75 10 FF 85 64 FE FF FF C7 85 40 FE FF FF 01 00 00 00 80 BD 6B FE FF FF 00 7E 07 C6 85 5F FE FF FF 01 FF 8D 74 FE FF FF 83 BD 6C FE FF FF FF 8B F3 74 13 FF B5 60 FE FF FF FF B5 6C FE FF FF E8 ?? ?? ?? ?? 59 59 83 FF 63 74 06 FF 8D 34 FE FF FF 83 BD 40 FE FF FF 00 74 14 8B 85 64 FE FF FF FF 8D 64 FE FF FF 85 C0 0F 84 76 03 00 00 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 89 85 6C FE FF FF 83 F8 FF 0F 84 3D 03 00 00 83 FF 63 74 4C 83 FF 73 75 13 83 F8 09 7C 09 83 F8 0D 0F 8E 25 03 00 00 83 F8 20 75 34 83 FF 7B 0F 85 17 03 00 00 0F BE BD 5D FE FF FF 33 D2 8B C8 83 E1 07 42 D3 E2 8B C8 C1 F9 03 0F BE 4C 0D DC 33 CF 85 D1 0F 84 F2 02 00 00 8B BD 18 FE FF FF 80 BD 6A FE FF FF 00 0F 85 D9 02 00 00 83 BD 34 FE FF FF 00 0F 84 1A 07 00 00 80 BD 5F FE FF FF 00 0F 84 B1 02 00 00 88 85 20 FE FF FF 0F B6 C0 50 E8 ?? ?? ?? ?? 59 85 C0 74 17 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 88 85 21 FE FF FF 8D 85 FC FD FF FF 50 8B 85 FC FD FF FF C7 85 10 FE FF FF 3F 00 00 00 FF B0 AC 00 00 00 8D 85 20 FE FF FF 50 8D 85 10 FE FF FF 50 E8 ?? ?? ?? ?? 66 8B 85 10 FE FF FF 83 C4 10 66 89 03 83 C3 02 E9 44 02 00 00 8B C7 83 E8 70 0F 84 B2 02 00 00 83 E8 03 0F 84 88 FE FF FF 48 48 0F 84 A8 02 00 00 83 E8 03 0F 84 90 FA FF FF 83 E8 03 74 33 0F B6 06 3B 85 6C FE FF FF 0F 85 3C 06 00 00 FE 8D 5E FE FF FF 80 BD 6A FE FF FF 00 0F 85 4C 05 00 00 8B 85 14 FE FF FF 89 85 1C FE FF FF E9 3B 05 00 00 80 BD 6B FE FF FF 00 7E 07 C6 85 5F FE FF FF 01 46 80 3E 5E 75 08 46 C6 85 5D FE FF FF FF 6A 20 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 5D 75 0C B2 5D 46 C6 45 E7 20 E9 92 00 00 00 8A 95 2F FE FF FF E9 87 00 00 00 46 3C 2D 75 6B 84 D2 74 67 8A 0E 80 F9 5D 74 60 46 3A D1 73 08 88 8D 7B FE FF FF EB 08 88 95 7B FE FF FF 8A D1 3A 95 7B FE FF FF 73 26 8A 85 7B FE FF FF 2A C2 0F B6 FA 0F B6 D0 8B CF 83 E1 07 8B C7 B3 01 D2 E3 C1 E8 03 8D 44 05 DC 08 18 47 4A 75 E8 0F B6 8D 7B FE FF FF 8B C1 83 E1 07 B2 01 D2 E2 C1 E8 03 8D 44 05 DC 08 10 32 D2 EB 17 0F B6 C8 8A D0 8B C1 83 E1 07 B3 01 C1 E8 03 D2 E3 8D 44 05 DC 08 18 8A 06 3C 5D 0F 85 6F FF FF FF 84 C0 0F 84 A8 05 00 00 8B 9D 44 FE FF FF 8B BD 18 FE FF FF 89 B5 50 FE FF FF E9 55 FD FF FF 83 FB 2B 75 2E FF 8D 64 FE FF FF 75 0D 85 C9 74 09 C6 85 73 FE FF FF 01 EB 19 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 FB 30 0F 85 78 01 00 00 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 80 FB 78 74 50 80 FB 58 74 4B C7 85 54 FE FF FF 01 00 00 00 83 FF 78 74 1B 83 BD 40 FE FF FF 00 74 0E FF 8D 64 FE FF FF 75 06 FE 85 73 FE FF FF 6A 6F EB 5B FF 8D 74 FE FF FF 83 FB FF 74 0E FF B5 60 FE FF FF 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 04 01 00 00 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 83 BD 40 FE FF FF 00 8B D8 89 9D 6C FE FF FF 74 16 83 AD 64 FE FF FF 02 83 BD 64 FE FF FF 01 7D 06 FE 85 73 FE FF FF 6A 78 5F E9 CA 00 00 00 88 03 43 89 9D 44 FE FF FF E9 86 FC FF FF 46 E9 86 FC FF FF FF 8D 74 FE FF FF 83 F8 FF 74 0E FF B5 60 FE FF FF 50 E8 ?? ?? ?? ?? 59 59 3B F3 0F 84 72 04 00 00 80 BD 6A FE FF FF 00 0F 85 15 03 00 00 FF 85 38 FE FF FF 83 BD 18 FE FF FF 63 0F 84 02 03 00 00 80 BD 5F FE FF FF 00 74 10 8B 8D 44 FE FF FF 33 C0 66 89 01 E9 E9 02 00 00 8B 85 44 FE FF FF C6 00 00 E9 DB 02 00 00 C6 85 7B FE FF FF 01 8B 9D 6C FE FF FF 83 FB 2D 75 09 C6 85 5C FE FF FF 01 EB 05 83 FB 2B 75 2E FF 8D 64 FE FF FF 75 0D 85 C9 74 09 C6 85 73 FE FF FF 01 EB 19 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF 83 BD 24 FE FF FF 00 0F 84 46 01 00 00 80 BD 73 FE FF FF 00 0F 85 08 01 00 00 83 FF 78 74 69 83 FF 70 74 64 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 D3 00 00 00 83 FF 6F 75 2A 83 FB 38 0F 8D C5 00 00 00 8B 85 48 FE FF FF 8B 8D 4C FE FF FF 0F A4 C1 03 C1 E0 03 89 85 48 FE FF FF 89 8D 4C FE FF FF EB 5F 6A 00 6A 0A FF B5 4C FE FF FF FF B5 48 FE FF FF E8 ?? ?? ?? ?? 89 85 48 FE FF FF 89 95 4C FE FF FF EB 3C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 73 8B 85 48 FE FF FF 8B 8D 4C FE FF FF 0F A4 C1 04 C1 E0 04 53 89 85 48 FE FF FF 89 8D 4C FE FF FF E8 ?? ?? ?? ?? 8B D8 59 89 9D 6C FE FF FF FF 85 54 FE FF FF 8D 43 D0 99 01 85 48 FE FF FF 11 95 4C FE FF FF 83 BD 40 FE FF FF 00 74 08 FF 8D 64 FE FF FF 74 37 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF E9 11 FF FF FF FF 8D 74 FE FF FF 83 FB FF 74 0E FF B5 60 FE FF FF 53 E8 ?? ?? ?? ?? 59 59 80 BD 5C FE FF FF 00 0F 84 FE 00 00 00 8B 85 48 FE FF FF 8B 8D 4C FE FF FF F7 D8 83 D1 00 F7 D9 89 85 48 FE FF FF 89 8D 4C FE FF FF E9 DA 00 00 00 80 BD 73 FE FF FF 00 0F 85 BE 00 00 00 83 FF 78 74 37 83 FF 70 74 32 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 89 00 00 00 83 FF 6F 75 10 83 FB 38 7D 7F 8B 85 3C FE FF FF C1 E0 03 EB 35 8B 85 3C FE FF FF 6B C0 0A EB 2A 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 5B C1 A5 3C FE FF FF 04 53 E8 ?? ?? ?? ?? 8B D8 8B 85 3C FE FF FF 59 89 9D 6C FE FF FF FF 85 54 FE FF FF 83 BD 40 FE FF FF 00 8D 44 18 D0 89 85 3C FE FF FF 74 08 FF 8D 64 FE FF FF 74 37 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B D8 89 9D 6C FE FF FF E9 5B FF FF FF FF 8D 74 FE FF FF 83 FB FF 74 0E FF B5 60 FE FF FF 53 E8 ?? ?? ?? ?? 59 59 80 BD 5C FE FF FF 00 74 06 F7 9D 3C FE FF FF 83 FF 46 75 07 83 A5 54 FE FF FF 00 83 BD 54 FE FF FF 00 0F 84 97 01 00 00 80 BD 6A FE FF FF 00 75 3E FF 85 38 FE FF FF 8B 9D 44 FE FF FF 8B 85 3C FE FF FF 83 BD 24 FE FF FF 00 74 13 8B 85 48 FE FF FF 89 03 8B 85 4C FE FF FF 89 43 04 EB 10 80 BD 7B FE FF FF 00 74 04 89 03 EB 03 66 89 03 8B B5 50 FE FF FF FE 85 5E FE FF FF 46 89 B5 50 FE FF FF EB 6C 3C 25 75 06 38 46 01 75 01 46 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 8B D8 0F B6 06 46 89 9D 6C FE FF FF 89 B5 50 FE FF FF 3B C3 0F 85 EE 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 29 8B 95 60 FE FF FF FF 85 74 FE FF FF E8 ?? ?? ?? ?? 0F B6 0E 46 89 B5 50 FE FF FF 3B C8 0F 85 AA 00 00 00 FF 8D 74 FE FF FF 83 BD 6C FE FF FF FF 75 1B 80 3E 25 0F 85 BD 00 00 00 8B 85 50 FE FF FF 80 78 01 6E 0F 85 AD 00 00 00 8B F0 8A 06 84 C0 0F 85 2D F1 FF FF E9 9C 00 00 00 83 BD }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__spawnv"
		size = 74
		refs = "0010 __errno 001b __invalid_parameter_noinfo 0040 __spawnve"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 0C 33 D2 3B F2 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 23 38 16 74 E7 8B 4D 10 3B CA 74 E0 8B 01 3B C2 74 DA 38 10 74 D6 52 51 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_204_3_0 {
	meta:
		name = "__mbsnccnt_l"
		size = 130
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 __errno 002e __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 08 8B 75 0C 85 C9 75 25 85 F6 74 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 3C 33 C0 85 F6 74 29 57 8A 11 4E 84 D2 74 20 8B 7D F4 0F B6 D2 F6 44 3A 1D 04 74 0D 8B D6 4E 85 D2 74 0C 41 80 39 00 74 06 40 41 85 F6 75 D9 5F 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5E C9 C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "___RTtypeid"
		size = 125
		refs = "0003 __sehtable$___RTtypeid 0008 __SEH_prolog4 0014 ??_C@_0CE@FFJAJLDK@Attempted?5a?5typeid?5of?5NULL?5point@ 001c ??0bad_typeid@std@@QAE@PBD@Z 0021 __TI2?AVbad_typeid@std@@ 002a __CxxThrowException@8 0046 __SEH_epilog4 004c ??_C@_0CB@EEENAAHH@Bad?5read?5pointer?5?9?5no?5RTTI?5data?$CB@ 0054 ??0__non_rtti_object@std@@QAE@PBD@Z 0059 __TI3?AV__non_rtti_object@std@@ 0077 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 85 C0 75 1B 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? 83 65 FC 00 8B 00 8B 40 FC 8B 40 0C 85 C0 74 0D C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB C6 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? EB D3 }
	condition:
		$1
}

rule file_205_1_0 {
	meta:
		name = "?FindCompleteObject@@YAPAXPAPAX@Z"
		size = 22
	strings:
		$1 = { 8B 01 8B 50 FC 8B C1 2B 42 04 8B 52 08 85 D2 74 04 2B CA 2B 01 C3 }
	condition:
		$1
}

rule file_205_2_0 {
	meta:
		name = "?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@1@Z"
		size = 119
		refs = "0030 _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 40 10 53 8B 58 08 56 33 F6 57 8B 78 0C 85 DB 74 27 8B 04 B7 8B 4D 0C 89 45 FC 8B 00 3B C1 74 44 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 31 46 3B F3 72 D9 33 C0 5F 5E 5B C9 C3 8B 04 B7 F6 40 14 04 75 F0 8B 00 8B 4D 08 3B C1 74 1A 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 46 3B F3 72 D6 EB CD 8B 45 FC EB CA }
	condition:
		$1
}

rule file_205_3_0 {
	meta:
		name = "?PMDtoOffset@@YAHPAXABUPMD@@@Z"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 8B 50 04 33 C9 85 D2 78 10 8B CA 8B 55 08 8B 14 11 56 8B 70 08 03 0C 32 5E 8B 00 03 C1 5D C3 }
	condition:
		$1
}

rule file_205_4_0 {
	meta:
		name = "___RTCastToVoid"
		size = 96
		refs = "0003 __sehtable$___RTCastToVoid 0008 __SEH_prolog4 0016 __SEH_epilog4 0020 ?FindCompleteObject@@YAPAXPAPAX@Z 0045 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 004d ??0__non_rtti_object@std@@QAE@PBD@Z 0052 __TI3?AV__non_rtti_object@std@@ 005b __CxxThrowException@8"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 08 85 C9 75 08 33 C0 E8 ?? ?? ?? ?? C3 83 65 FC 00 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB E8 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_205_5_0 {
	meta:
		name = "?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 264
		refs = "004e _strcmp 0091 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 40 10 83 4D F8 FF 53 8B 58 08 33 C9 56 57 8B 78 0C 89 4D F0 89 4D EC 89 4D F4 89 4D FC 3B D9 0F 86 D3 00 00 00 8B 45 FC 8B 34 87 2B 45 F8 3B 45 F4 76 32 8B 06 8B 4D 14 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 16 8B 45 EC 85 C0 75 50 8B 45 FC 89 45 F8 8B 46 04 89 75 F0 89 45 F4 8B 06 8B 4D 0C 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 1B FF 75 08 8D 46 08 E8 ?? ?? ?? ?? 59 3B 45 10 75 0A 8B 4D F0 85 C9 75 1D 89 75 EC FF 45 FC 39 5D FC 72 81 EB 52 F6 46 14 03 75 4C F6 40 14 01 75 46 8B C6 EB 44 8B 45 FC 2B 45 F8 3B 45 F4 77 31 F6 41 14 40 75 10 83 7D F8 00 75 06 F6 46 14 01 75 25 8B C1 EB 23 8B 51 18 8B 52 0C 8B 04 82 8A 40 14 24 01 0F B6 C0 F7 D8 1B C0 F7 D0 23 C1 EB 08 F6 41 14 03 74 D5 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_205_6_0 {
	meta:
		name = "?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 342
		refs = "005f _strcmp 00a7 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8B 40 10 8B 48 0C 83 4D F4 FF 83 4D E8 FF 53 8B 58 08 56 57 33 FF 89 7D EC 89 7D E4 89 7D E0 89 4D DC 89 7D F0 C6 45 FF 01 89 7D F8 3B DF 0F 86 13 01 00 00 8B 45 F8 8B 4D DC 8B 34 81 2B 45 F4 3B 45 F0 76 33 8B 06 8B 4D 14 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 17 F6 46 14 03 75 03 89 75 E0 8B 45 F8 89 45 F4 8B 46 04 8B FE 89 45 F0 8B 06 8B 4D 0C 3B C1 74 17 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 89 00 00 00 FF 75 08 8D 46 08 E8 ?? ?? ?? ?? 59 3B 45 10 75 78 8B 45 F8 2B 45 F4 3B 45 F0 77 64 80 7D FF 00 74 67 F6 47 14 40 75 14 83 7D F4 00 75 0A F6 46 14 01 74 04 C6 45 FF 00 B0 01 EB 1B 8B 4F 18 8B 49 0C 8B 04 81 8B 40 14 A8 01 74 04 C6 45 FF 00 C1 E8 02 F6 D0 24 01 80 7D FF 00 74 2C 84 C0 74 28 FF 75 08 8D 47 08 E8 ?? ?? ?? ?? 83 7D EC 00 59 74 05 39 45 E8 75 37 89 7D EC 89 45 E8 EB 09 F6 46 14 05 75 03 89 75 E4 FF 45 F8 39 5D F8 0F 82 07 FF FF FF 80 7D FF 00 74 07 8B 45 EC 85 C0 75 0F 83 7D E4 00 74 07 8B 45 E0 85 C0 75 02 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_205_7_0 {
	meta:
		name = "___RTDynamicCast"
		size = 320
		refs = "0003 __sehtable$___RTDynamicCast 0008 __SEH_prolog4 0016 __SEH_epilog4 0022 ?FindCompleteObject@@YAPAXPAPAX@Z 006b _strcmp 00bc ?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 00c3 ?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 00d5 ?PMDtoOffset@@YAHPAXABUPMD@@@Z 00f7 ??_C@_0BC@JNJNLHBP@Bad?5dynamic_cast?$CB?$AA@ 00ff ??0bad_cast@std@@QAE@PBD@Z 0104 __TI2?AVbad_cast@std@@ 010d __CxxThrowException@8 012d ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 0135 ??0__non_rtti_object@std@@QAE@PBD@Z 013a __TI3?AV__non_rtti_object@std@@"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 75 08 33 C0 E8 ?? ?? ?? ?? C3 83 65 FC 00 8B CE E8 ?? ?? ?? ?? 8B D0 89 55 E4 8B 06 8B 40 FC 2B 75 0C 2B F2 8B 48 10 8B 49 04 F6 C1 01 75 6E 8B 40 10 8B 78 0C 8B 40 08 89 45 08 33 F6 89 75 DC 3B 75 08 73 54 8B 1C B7 8B 03 8B 4D 14 3B C1 74 16 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 03 46 EB D6 46 89 75 D8 3B 75 08 73 6B 8B 04 B7 F6 40 14 04 75 62 8B 00 8B 4D 10 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 D2 8B C3 EB 20 33 C0 EB 1C FF 75 14 56 FF 75 10 52 F6 C1 02 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 1E 83 C0 08 FF 75 E4 E8 ?? ?? ?? ?? 59 03 45 E4 89 45 E0 C7 45 FC FE FF FF FF E9 29 FF FF FF 33 C0 89 45 E0 39 45 18 74 EA 68 ?? ?? ?? ?? 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 CC 50 E8 ?? ?? ?? ?? 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 83 65 E0 00 68 ?? ?? ?? ?? 8D 4D CC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB C8 }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "__findclose"
		size = 38
		refs = "000a __imp__FindClose@4 0013 __errno"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_206_2_0 {
	meta:
		name = "___timet_from_ft"
		size = 122
		refs = "0009 ___security_cookie 0027 __imp__FileTimeToLocalFileTime@8 0039 __imp__FileTimeToSystemTime@8 0062 ___loctotime32_t 0074 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 38 00 75 06 83 78 04 00 74 4B 8D 4D E4 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 3C 8D 45 EC 50 8D 45 E4 50 FF 15 ?? ?? ?? ?? 85 C0 74 2A 0F B7 45 F8 6A 00 50 0F B7 45 F6 50 0F B7 45 F4 50 0F B7 45 F2 50 0F B7 45 EE 50 0F B7 45 EC 50 E8 ?? ?? ?? ?? 83 C4 1C EB 03 83 C8 FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_206_3_0 {
	meta:
		name = "__findfirst32"
		size = 286
		refs = "000c ___security_cookie 0024 __errno 002f __invalid_parameter_noinfo 004b __imp__FindFirstFileExA@24 0058 __imp__GetLastError@0 0089 @__security_check_cookie@4 00c2 ___timet_from_ft 0101 _strcpy_s 0119 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 49 3B C7 74 E7 53 57 57 57 8D 8D BC FE FF FF 51 57 50 FF 15 ?? ?? ?? ?? 8B D8 83 FB FF 75 4F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 34 83 F8 08 74 22 83 F8 12 74 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E1 E8 ?? ?? ?? ?? 89 30 EB D8 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 DC FE FF FF 89 46 10 8D 85 E8 FE FF FF 50 68 04 01 00 00 83 C6 14 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 8B C3 E9 6D FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_206_4_0 {
	meta:
		name = "__findnext32"
		size = 293
		refs = "000c ___security_cookie 0022 __errno 002d __invalid_parameter_noinfo 0059 __imp__FindNextFileA@8 0063 __imp__GetLastError@0 0093 @__security_check_cookie@4 00cc ___timet_from_ft 010b _strcpy_s 0120 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 83 F8 FF 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 56 57 33 FF 3B F7 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 39 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 4E FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 33 83 F8 08 74 21 83 F8 12 74 29 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5F 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E2 E8 ?? ?? ?? ?? 89 30 EB D9 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 C8 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 D0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 0C 8B 85 DC FE FF FF 89 46 10 8D 85 E8 FE FF FF 50 68 04 01 00 00 83 C6 14 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 71 FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_207_3_0 {
	meta:
		name = "__ismbcgraph_l"
		size = 187
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0069 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 78 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 83 78 08 00 5F 75 11 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 33 C0 C9 C3 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CB 66 83 7D FE 00 75 3C F7 45 FC 17 01 00 00 74 33 33 C0 40 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD C9 C3 0F B6 C1 8B 4D EC 8B 89 C8 00 00 00 BA 17 01 00 00 66 85 14 41 75 D7 8B 4D F0 F6 44 08 1D 03 75 CD 33 C0 EB CC }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "_strncpy_s"
		size = 181
		refs = "002e __errno 0038 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 53 33 DB 56 57 39 5D 14 75 10 3B C3 75 10 39 5D 0C 75 12 33 C0 5F 5E 5B 5D C3 3B C3 74 07 8B 7D 0C 3B FB 77 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB DD 39 5D 14 75 04 88 18 EB D2 8B 55 10 3B D3 75 04 88 18 EB D9 83 7D 14 FF 8B C8 75 13 8B F0 2B F2 8A 0A 88 0C 16 42 3A CB 74 22 4F 75 F3 EB 1D 8B F2 2B F0 8A 14 0E 88 11 41 3A D3 74 08 4F 74 05 FF 4D 14 75 EE 39 5D 14 75 02 88 19 3B FB 75 8B 83 7D 14 FF 75 0F 8B 4D 0C 6A 50 88 5C 08 FF 58 E9 78 FF FF FF 88 18 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB 82 }
	condition:
		$1
}

rule file_211_3_0 {
	meta:
		name = "__atof_l"
		size = 171
		refs = "0009 ___security_cookie 001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 __errno 0031 __invalid_parameter_noinfo 005d __isctype_l 0087 __fltin2 00a5 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 0C 8B 75 08 8D 4D D4 E8 ?? ?? ?? ?? 85 F6 75 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D E0 00 74 07 8B 45 DC 83 60 70 FD D9 EE EB 58 8B 45 D4 83 B8 AC 00 00 00 01 7E 14 8D 45 D4 50 0F B6 06 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C EB 10 0F B6 0E 8B 80 C8 00 00 00 0F B7 04 48 83 E0 08 85 C0 74 03 46 EB C9 8D 45 D4 50 8D 45 E4 56 50 E8 ?? ?? ?? ?? DD 40 10 83 C4 0C 80 7D E0 00 74 07 8B 45 DC 83 60 70 FD 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_211_5_0 {
	meta:
		name = "___strgtold12"
		size = 66
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ___strgtold12_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_313_5_0 {
	meta:
		name = "___wstrgtold12"
		size = 66
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ___wstrgtold12_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_211_6_0 {
	meta:
		name = "___STRINGTOLD"
		size = 57
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ___STRINGTOLD_L"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_313_6_0 {
	meta:
		name = "___WSTRINGTOLD"
		size = 57
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 ___WSTRINGTOLD_L"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_212_2_0 {
	meta:
		name = "__searchenv_s"
		size = 860
		refs = "000c ___security_cookie 0048 __errno 0052 __invalid_parameter_noinfo 0092 __access_s 00b8 __fullpath 00dd __dupenv_s 00f7 __invoke_watson 0111 _strlen 0142 __calloc_crt 0192 __getpath 0255 _strcpy_s 02ae _free 02c9 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 28 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 83 A5 E0 FE FF FF 00 83 A5 F0 FE FF FF 00 53 8B 5D 08 56 8B 75 10 89 85 EC FE FF FF 8B 45 14 89 9D D8 FE FF FF 89 85 E4 FE FF FF 85 F6 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 64 02 00 00 85 C0 74 E8 85 DB 75 04 88 1E EB E0 80 3B 00 75 1A C6 06 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 30 E9 13 02 00 00 57 E8 ?? ?? ?? ?? 8B 38 6A 00 53 E8 ?? ?? ?? ?? 59 59 89 85 E8 FE FF FF E8 ?? ?? ?? ?? 89 38 33 FF 39 BD E8 FE FF FF 75 1F FF B5 E4 FE FF FF 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 82 02 00 00 88 06 E9 C3 01 00 00 FF B5 EC FE FF FF 8D 85 E0 FE FF FF 57 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 74 13 83 F8 16 0F 85 92 01 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 8B 85 E0 FE FF FF 3B C7 0F 84 7A 01 00 00 53 89 85 EC FE FF FF E8 ?? ?? ?? ?? 8B D8 8D 85 F4 FE FF FF 89 85 F0 FE FF FF B8 08 01 00 00 59 8B F8 3B D8 72 37 FF B5 EC FE FF FF E8 ?? ?? ?? ?? 8D 7C 18 02 6A 01 57 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F0 FE FF FF 85 C0 75 13 C6 06 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 2B 01 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 DC FE FF FF E9 FE 00 00 00 8B 85 EC FE FF FF 8B CF 2B CB 49 51 FF B5 F0 FE FF FF 89 85 E8 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 EC FE FF FF 85 C0 75 66 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 0F 85 CE 00 00 00 E8 ?? ?? ?? ?? 83 38 22 0F 85 C0 00 00 00 FF B5 E8 FE FF FF E8 ?? ?? ?? ?? 8D 7C 18 02 6A 01 57 E8 ?? ?? ?? ?? 83 C4 0C 89 85 F0 FE FF FF 85 C0 0F 84 68 FF FF FF 8B CF 2B CB 51 50 FF B5 E8 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 89 85 EC FE FF FF 85 C0 74 7A 8B 85 F0 FE FF FF 80 38 00 74 6F 50 E8 ?? ?? ?? ?? 8B 95 F0 FE FF FF 89 85 E8 FE FF FF 03 C2 59 0F BE 48 FF 83 F9 2F 74 14 83 F9 5C 74 0F 83 F9 3A 74 0A C6 00 5C 40 FF 85 E8 FE FF FF FF B5 D8 FE FF FF 8B CF 2B C8 03 CA 51 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 EC 00 00 00 50 FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 59 83 BD EC FE FF FF 00 0F 85 F5 FE FF FF C6 06 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 30 5F 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 74 0C FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 FF B5 E0 FE FF FF E8 ?? ?? ?? ?? 59 8B 4D FC 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8B 85 E8 FE FF FF 03 C3 3B 85 E4 FE FF FF 72 2A 8D 85 F4 FE FF FF C6 06 00 39 85 F0 FE FF FF 74 0C FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 88 E8 ?? ?? ?? ?? FF B5 F0 FE FF FF 8B 8D DC FE FF FF FF B5 E4 FE FF FF 89 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 21 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 74 0C FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 33 F6 E9 48 FF FF FF 33 C0 50 50 50 50 50 E9 9A FD FF FF }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "__searchenv"
		size = 29
		refs = "0014 __searchenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 68 04 01 00 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_338_3_0 {
	meta:
		name = "__wsearchenv"
		size = 29
		refs = "0014 __wsearchenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 68 04 01 00 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_213_1_0 {
	meta:
		name = "__wgetenv_helper_nolock"
		size = 155
		refs = "0007 ___env_initialized 000f __wenviron 0020 __environ 0027 ___crtGetEnvironmentStringsW 002c __wenvptr 0031 __wsetenvp 003a ___mbtow_environ 0056 _wcslen 0079 __wcsnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 EB 77 57 85 F6 75 2E 39 35 ?? ?? ?? ?? 74 67 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 09 E8 ?? ?? ?? ?? 85 C0 75 4B 8B 35 ?? ?? ?? ?? 85 F6 74 41 83 7D 08 00 74 3B FF 75 08 E8 ?? ?? ?? ?? 59 8B F8 EB 28 50 E8 ?? ?? ?? ?? 59 3B C7 76 1A 8B 06 66 83 3C 78 3D 75 11 57 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 06 85 C0 75 D2 33 C0 5F 5E 5D C3 8B 06 8D 44 78 02 EB F4 }
	condition:
		$1
}

rule file_213_2_0 {
	meta:
		name = "__wgetenv_s_helper"
		size = 135
		refs = "000d __errno 0017 __invalid_parameter_noinfo 0041 __wgetenv_helper_nolock 004e _wcslen 006d _wcscpy_s 0082 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F0 85 F6 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 45 8B 45 08 83 26 00 85 C0 74 06 85 DB 75 06 EB DD 85 DB 75 D9 85 C0 74 05 33 C9 66 89 08 57 FF 75 0C E8 ?? ?? ?? ?? 8B F8 59 85 FF 74 2C 57 E8 ?? ?? ?? ?? 40 89 06 33 F6 59 3B DE 74 1C 3B C3 76 07 6A 22 58 5F 5E 5D C3 57 53 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 04 33 C0 EB E7 56 56 56 56 56 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_213_3_0 {
	meta:
		name = "__wdupenv_s_helper"
		size = 156
		refs = "0010 __errno 001a __invalid_parameter_noinfo 0037 __wgetenv_helper_nolock 0044 _wcslen 004f _calloc 0079 _wcscpy_s 0097 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F8 33 F6 3B FE 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 4F 8B 45 08 89 37 3B C6 74 02 89 30 39 75 0C 74 DD 53 FF 75 0C E8 ?? ?? ?? ?? 8B D8 59 3B DE 74 4B 53 E8 ?? ?? ?? ?? 8D 70 01 6A 02 56 E8 ?? ?? ?? ?? 89 07 33 FF 83 C4 0C 3B C7 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 5B 5F 5E 5D C3 53 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0D 8B 45 08 3B C7 74 02 89 30 33 C0 EB DF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_213_4_0 {
	meta:
		name = "__wgetenv"
		size = 122
		refs = "0003 __sehtable$__wgetenv 0008 __SEH_prolog4 0019 __errno 0024 __invalid_parameter_noinfo 0036 _wcsnlen 0047 __lock 0054 __wgetenv_helper_nolock 006c __SEH_epilog4 0074 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 08 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3F BE FF 7F 00 00 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 3B C6 1B C0 F7 D8 74 D4 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_345_4_0 {
	meta:
		name = "_getenv"
		size = 122
		refs = "0003 __sehtable$_getenv 0008 __SEH_prolog4 0019 __errno 0024 __invalid_parameter_noinfo 0036 _strnlen 0047 __lock 0054 __getenv_helper_nolock 006c __SEH_epilog4 0074 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 08 0F 95 C0 85 C0 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 3F BE FF 7F 00 00 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 3B C6 1B C0 F7 D8 74 D4 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_213_5_0 {
	meta:
		name = "__wgetenv_s"
		size = 208
		refs = "0003 __sehtable$__wgetenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0032 __invalid_parameter_noinfo 006a __wgetenv_helper_nolock 0077 _wcslen 009a _wcscpy_s 00b8 __SEH_epilog4 00c3 __invoke_watson 00ca __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 DB 89 5D FC 33 C0 8B 7D 08 3B FB 0F 95 C0 3B C3 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 89 75 E4 EB 6D 89 1F 8B 4D 0C 3B CB 74 09 39 5D 10 77 09 3B CB 75 0A 39 5D 10 75 05 33 C0 40 EB 02 33 C0 3B C3 74 CA 3B CB 74 05 33 C0 66 89 01 FF 75 14 E8 ?? ?? ?? ?? 59 8B F0 3B F3 74 30 56 E8 ?? ?? ?? ?? 59 40 89 07 39 5D 10 74 21 3B 45 10 76 09 C7 45 E4 22 00 00 00 EB 16 56 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 3B C3 75 18 89 5D E4 C7 45 FC FE FF FF FF E8 13 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 53 53 53 53 53 E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_213_6_0 {
	meta:
		name = "__wdupenv_s"
		size = 215
		refs = "0003 __sehtable$__wdupenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0032 __invalid_parameter_noinfo 0056 __wgetenv_helper_nolock 0063 _wcslen 006e _calloc 0098 _wcscpy_s 00bf __SEH_epilog4 00ca __invoke_watson 00d1 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 7D 08 3B FE 0F 95 C0 3B C6 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 89 75 E4 EB 74 89 37 8B 45 0C 3B C6 74 02 89 30 33 C0 39 75 10 0F 95 C0 3B C6 74 D5 FF 75 10 E8 ?? ?? ?? ?? 59 8B D8 3B DE 74 D5 53 E8 ?? ?? ?? ?? 8D 70 01 6A 02 56 E8 ?? ?? ?? ?? 83 C4 0C 89 07 33 FF 3B C7 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 E4 EB 1B 53 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 75 21 8B 45 0C 3B C7 74 02 89 30 89 7D E4 C7 45 FC FE FF FF FF E8 13 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 57 57 57 57 57 E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__set_error_mode"
		size = 63
		refs = "0017 ___error_mode 002b __errno 0036 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 85 C9 78 1E 83 F9 02 7E 0C 83 F9 03 75 14 A1 ?? ?? ?? ?? 5D C3 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5D C3 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_215_3_0 {
	meta:
		name = "__mbctoupper_l"
		size = 166
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0066 ___crtLCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 FF 75 0C 8D 4D E8 E8 ?? ?? ?? ?? 8B 5D 08 81 FB FF 00 00 00 76 61 8B C3 C1 E8 08 0F B6 C8 88 45 FC 8B 45 EC 88 5D FD F6 44 01 1D 04 75 11 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 8B C3 EB 5B 6A 01 FF 70 04 8D 4D F8 6A 02 51 6A 02 8D 4D FC 51 68 00 02 00 00 FF 70 0C 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 C6 0F B6 45 F8 0F B6 4D F9 C1 E0 08 03 C1 EB 16 8B 45 EC F6 44 18 1D 20 74 0A 0F B6 84 18 1D 01 00 00 EB 02 8B C3 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "_vscanf"
		size = 125
		refs = "0003 __sehtable$_vscanf 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0030 ___iob_func 0037 __lock_file2 0068 __SEH_epilog4 0076 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 38 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 89 75 FC FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 50 FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_661_0_0 {
	meta:
		name = "_vwscanf"
		size = 125
		refs = "0003 __sehtable$_vwscanf 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0030 ___iob_func 0037 __lock_file2 0068 __SEH_epilog4 0076 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 38 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 89 75 FC FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 50 FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_217_1_0 {
	meta:
		name = "_scanf"
		size = 29
		refs = "000f __input_l 0014 _vscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_217_3_0 {
	meta:
		name = "_scanf_s"
		size = 29
		refs = "000f __input_s_l 0014 _vscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_661_1_0 {
	meta:
		name = "_wscanf"
		size = 29
		refs = "000f __winput_l 0014 _vwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_661_3_0 {
	meta:
		name = "_wscanf_s"
		size = 29
		refs = "000f __winput_s_l 0014 _vwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_217_2_0 {
	meta:
		name = "__scanf_l"
		size = 30
		refs = "0010 __input_l 0015 _vscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_217_4_0 {
	meta:
		name = "__scanf_s_l"
		size = 30
		refs = "0010 __input_s_l 0015 _vscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_661_2_0 {
	meta:
		name = "__wscanf_l"
		size = 30
		refs = "0010 __winput_l 0015 _vwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_661_4_0 {
	meta:
		name = "__wscanf_s_l"
		size = 30
		refs = "0010 __winput_s_l 0015 _vwscanf"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 10 50 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_218_1_0 {
	meta:
		name = "__findfirst64"
		size = 315
		refs = "000c ___security_cookie 0024 __errno 002f __invalid_parameter_noinfo 003e @__security_check_cookie@4 0056 __imp__FindFirstFileExA@24 0067 __imp__GetLastError@0 00c2 ___time64_t_from_ft 0119 _strcpy_s 0136 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 48 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 3B C7 74 DB 57 57 57 8D 8D BC FE FF FF 51 57 50 FF 15 ?? ?? ?? ?? 89 85 B8 FE FF FF 83 F8 FF 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB A5 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 98 E8 ?? ?? ?? ?? 89 30 EB 8F 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 53 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C8 FE FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 D0 FE FF FF 50 89 56 14 E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF 89 46 18 33 C0 33 DB 03 85 DC FE FF FF 89 56 1C 89 46 20 13 CB 8D 85 E8 FE FF FF 50 89 4E 24 68 04 01 00 00 83 C6 28 56 E8 ?? ?? ?? ?? 83 C4 18 5B 85 C0 75 0B 8B 85 B8 FE FF FF E9 06 FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_218_2_0 {
	meta:
		name = "__findnext64"
		size = 319
		refs = "000c ___security_cookie 0025 __errno 0030 __invalid_parameter_noinfo 005b __imp__FindNextFileA@8 0065 __imp__GetLastError@0 0095 @__security_check_cookie@4 00ce ___time64_t_from_ft 0125 _strcpy_s 013a __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 83 CB FF 56 8B 75 0C 3B C3 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B C3 EB 55 57 33 FF 3B F7 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 39 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 4E FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 33 83 F8 08 74 21 83 F8 12 74 29 E8 ?? ?? ?? ?? C7 00 16 00 00 00 8B C3 5F 8B 4D FC 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB E2 E8 ?? ?? ?? ?? 89 30 EB D9 8B 85 BC FE FF FF 83 C0 80 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C8 FE FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 D0 FE FF FF 50 89 56 14 E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF 89 46 18 33 C0 33 DB 03 85 DC FE FF FF 89 56 1C 89 46 20 13 CB 8D 85 E8 FE FF FF 50 89 4E 24 68 04 01 00 00 83 C6 28 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 84 58 FF FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "__mbccpy_s_l"
		size = 254
		refs = "0022 __errno 002c __invalid_parameter_noinfo 005a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0067 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 8B 5D 10 56 85 DB 74 03 83 23 00 8B 75 08 85 F6 74 06 83 7D 0C 00 77 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 C3 00 00 00 57 8B 7D 14 85 FF 75 14 C6 06 00 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? EB 73 FF 75 18 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 0F B6 07 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 6B 80 7F 01 00 75 28 C6 06 00 85 DB 74 06 C7 03 01 00 00 00 E8 ?? ?? ?? ?? 6A 2A 59 89 08 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B C1 EB 5A 6A 02 58 39 45 0C 73 23 C6 06 00 E8 ?? ?? ?? ?? 6A 22 5E 89 30 E8 ?? ?? ?? ?? 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B C6 EB 2F 8A 0F 88 0E 8A 4F 01 88 4E 01 85 DB 74 12 89 03 EB 0E 8A 07 88 06 85 DB 74 06 C7 03 01 00 00 00 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_220_2_0 {
	meta:
		name = "__CIlog_default"
		size = 213
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0032 __DEFAULT_CW_in_mem 004c ___fastflag 0053 __fast_exit 0059 LOG_name 0063 __math_exit 0089 __indefinite 0095 __convertTOStoQNaN 00ad __minfinity 00cf __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 4C 8B 44 24 0C 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? A9 00 00 F0 7F 74 5E A9 00 00 00 80 75 41 D9 ED D9 C9 D9 F1 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E9 ?? ?? ?? ?? A9 00 00 00 80 75 17 EB D4 A9 FF FF 0F 00 75 1D 83 7C 24 08 00 75 16 25 00 00 00 80 74 C5 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 EB 22 E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 C5 83 7C 24 08 00 75 BE DD D8 DB 2D ?? ?? ?? ?? B8 02 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_221_7_0 {
	meta:
		name = "?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z"
		size = 47
		refs = "0007 ?g_TraceOn@details@Concurrency@@3_NA 0013 ?g_EnableLevel@details@Concurrency@@3EA 0024 ?ThrowContextEvent@ContextBase@details@Concurrency@@KAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 80 3D ?? ?? ?? ?? 00 74 1D 8B 45 0C 3A 05 ?? ?? ?? ?? 77 12 FF 75 14 FF 75 10 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C2 10 00 }
	condition:
		$1
}

rule file_698_36_0 {
	meta:
		name = "?TraceVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@AAEXW4ConcRT_EventType@3@EKK@Z"
		size = 47
		refs = "0007 ?g_TraceOn@details@Concurrency@@3_NA 0013 ?g_EnableLevel@details@Concurrency@@3EA 0024 ?ThrowVirtualProcessorEvent@VirtualProcessor@details@Concurrency@@CAXW4ConcRT_EventType@3@EKK@Z"
	strings:
		$1 = { 8B FF 55 8B EC 80 3D ?? ?? ?? ?? 00 74 1D 8B 45 0C 3A 05 ?? ?? ?? ?? 77 12 FF 75 14 FF 75 10 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C2 10 00 }
	condition:
		$1
}

rule file_221_9_0 {
	meta:
		name = "?UNSAFE_SetVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXPAVVirtualProcessor@23@@Z"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 81 84 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_221_10_0 {
	meta:
		name = "??0UMSThreadInternalContext@details@Concurrency@@QAE@PAVSchedulerBase@12@@Z"
		size = 46
		refs = "000c ??0InternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@@Z 0012 ??_7UMSThreadInternalContext@details@Concurrency@@6BIExecutionContext@2@@ 0019 ??_7UMSThreadInternalContext@details@Concurrency@@6BContextBase@12@@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? C7 86 D4 00 00 00 00 00 00 00 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_221_14_0 {
	meta:
		name = "?IsSynchronouslyBlocked@UMSThreadInternalContext@details@Concurrency@@UBE_NXZ"
		size = 22
	strings:
		$1 = { 8B 41 2C 83 F8 02 74 0A 8B 41 28 A8 02 75 03 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_221_18_0 {
	meta:
		name = "?PrepareToRun@UMSThreadInternalContext@details@Concurrency@@EAEXPAVVirtualProcessor@23@@Z"
		size = 41
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 81 D0 00 00 00 C7 81 D4 00 00 00 00 00 00 00 89 81 84 00 00 00 33 C0 83 C1 2C 87 01 5D C2 04 00 }
	condition:
		$1
}

rule file_221_19_0 {
	meta:
		name = "?NotifyBlocked@UMSThreadInternalContext@details@Concurrency@@AAEX_N@Z"
		size = 36
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 38 45 08 C7 81 84 00 00 00 00 00 00 00 0F 95 C0 83 C1 2C 8D 44 00 02 87 01 5D C2 04 00 }
	condition:
		$1
}

rule file_221_20_0 {
	meta:
		name = "?Block@UMSThreadInternalContext@details@Concurrency@@UAEXXZ"
		size = 139
		refs = "0007 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 001e ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0058 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 007e ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 0087 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 56 57 8B F1 E8 ?? ?? ?? ?? 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 03 8B CE E8 ?? ?? ?? ?? 8B 86 80 00 00 00 33 C9 41 80 78 79 00 8D 56 2C 8B F9 74 28 F0 0F C1 3A 47 3B F9 75 13 6A 02 5A 8D 7E 2C 8B C1 F0 0F B1 17 3B C1 75 03 51 EB 02 6A 02 8D 4E FC E8 ?? ?? ?? ?? EB 24 F0 0F C1 3A 47 3B F9 75 1B 6A 02 5A 8D 7E 2C 8B C1 F0 0F B1 17 3B C1 75 0B 51 6A 00 8D 4E FC E8 ?? ?? ?? ?? 5F 8B CE 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_221_22_0 {
	meta:
		name = "?EnterCriticalRegionHelper@UMSThreadInternalContext@details@Concurrency@@UAEHXZ"
		size = 60
		refs = "0025 __imp__Sleep@4"
	strings:
		$1 = { 8B FF 56 8B F1 EB 22 8B 8E 80 00 00 00 85 C9 74 29 83 B9 9C 00 00 00 00 74 20 8B 06 8B CE FF 50 34 6A 01 FF 15 ?? ?? ?? ?? FF 46 0C 8B 4E 7C 8B 01 FF 50 10 83 7E 0C 01 74 CD 5E C3 }
	condition:
		$1
}

rule file_221_24_0 {
	meta:
		name = "?EnterHyperCriticalRegionHelper@UMSThreadInternalContext@details@Concurrency@@UAEHXZ"
		size = 63
		refs = "0025 __imp__Sleep@4"
	strings:
		$1 = { 8B FF 56 8B F1 EB 22 8B 8E 80 00 00 00 85 C9 74 2C 83 B9 9C 00 00 00 00 74 23 8B 06 8B CE FF 50 38 6A 01 FF 15 ?? ?? ?? ?? FF 46 0C FF 46 10 8B 4E 7C 8B 01 FF 50 18 83 7E 0C 01 74 CA 5E C3 }
	condition:
		$1
}

rule file_221_26_0 {
	meta:
		name = "?Oversubscribe@UMSThreadInternalContext@details@Concurrency@@UAEX_N@Z"
		size = 56
		refs = "001e ??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ 0023 __TI2?AVinvalid_oversubscribe_operation@Concurrency@@ 002c __CxxThrowException@8"
		altNames = "?Oversubscribe@ExternalContextBase@details@Concurrency@@UAEX_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 80 7D 08 00 74 05 FF 41 14 EB 21 8B 41 14 85 C0 75 16 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 48 89 41 14 C9 C2 04 00 }
	condition:
		$1
}

rule file_221_39_0 {
	meta:
		name = "?SpinOnAndReturnBlockingType@UMSThreadInternalContext@details@Concurrency@@AAE?AW4BlockingType@123@XZ"
		size = 58
		refs = "001b ?_Sleep0@details@Concurrency@@YAXXZ 0023 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B F1 8B 86 D4 00 00 00 85 C0 75 1C 21 45 F8 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 86 D4 00 00 00 85 C0 74 EE 8B 86 D4 00 00 00 5E C9 C3 }
	condition:
		$1
}

rule file_222_3_0 {
	meta:
		name = "__strnicmp_l"
		size = 226
		refs = "001c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0028 __errno 0033 __invalid_parameter_noinfo 008f ___ascii_strnicmp 00b1 __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 10 00 53 56 57 0F 84 C6 00 00 00 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D 08 85 DB 75 27 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 8F 00 00 00 8B 75 0C 85 F6 74 D2 BF FF FF FF 7F 39 7D 10 76 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B C7 EB 5D 8B 45 F0 83 78 14 00 75 1C FF 75 10 56 53 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 41 8B 4D F8 83 61 70 FD EB 38 2B DE 0F B6 04 33 8D 4D F0 51 50 E8 ?? ?? ?? ?? 8B F8 0F B6 06 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 10 46 FF 4D 10 74 08 85 FF 74 04 3B F8 74 D2 2B F8 8B C7 EB BB 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_222_4_0 {
	meta:
		name = "__strnicmp"
		size = 83
		refs = "0009 ___locale_changed 0015 __errno 0020 __invalid_parameter_noinfo 003b ___ascii_strnicmp 004a __strnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 75 30 39 45 08 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 39 45 0C 74 E4 81 7D 10 FF FF FF 7F 77 DB 5D E9 ?? ?? ?? ?? 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_839_4_0 {
	meta:
		name = "__strncoll"
		size = 83
		refs = "0009 ___locale_changed 0015 __errno 0020 __invalid_parameter_noinfo 003b _strncmp 004a __strncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 75 30 39 45 08 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 39 45 0C 74 E4 81 7D 10 FF FF FF 7F 77 DB 5D E9 ?? ?? ?? ?? 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_594_4_0 {
	meta:
		name = "__wcsncoll"
		size = 83
		refs = "0009 ___locale_changed 0015 __errno 0020 __invalid_parameter_noinfo 003b _wcsncmp 004a __wcsncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 75 30 39 45 08 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 39 45 0C 74 E4 81 7D 10 FF FF FF 7F 77 DB 5D E9 ?? ?? ?? ?? 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "__frnd"
		size = 20
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 45 08 D9 FC DD 5D F8 DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "___sse2_available_init"
		size = 16
		refs = "0004 __imp__IsProcessorFeaturePresent@4 0009 ___sse2_available"
	strings:
		$1 = { 6A 0A FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_587_1_0 {
	meta:
		name = "__sse2_mathfcns_init"
		size = 16
		refs = "0004 __imp__IsProcessorFeaturePresent@4 0009 ___use_sse2_mathfcns"
	strings:
		$1 = { 6A 0A FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_226_3_0 {
	meta:
		name = "__mbsset_s_l"
		size = 329
		refs = "001d __errno 0027 __invalid_parameter_noinfo 0039 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 004d __strset_s 008d __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 8B 7D 08 33 DB 89 5D F8 3B FB 74 05 39 5D 0C 77 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 12 01 00 00 FF 75 14 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 39 58 08 75 24 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F4 0F 84 E7 00 00 00 8B 4D F0 83 61 70 FD E9 DB 00 00 00 8B 45 0C 89 45 FC 8B 45 10 C1 E8 08 8B F7 88 45 0B 3A C3 74 40 38 5D 10 74 4F 8D 45 E8 50 0F B6 45 0B 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 3B 38 1F 74 6B FF 4D FC 74 66 38 5E 01 74 40 FF 4D FC 8A 4D 0B 88 0E 74 5C 8A 45 10 88 46 01 83 C6 02 38 1E 75 DF EB 48 8D 45 E8 50 0F B6 45 10 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 21 88 1F E8 ?? ?? ?? ?? 8B C8 6A 2A 58 89 01 E9 6F FF FF FF FF 45 FC 88 1E C7 45 F8 01 00 00 00 EB 13 38 1F 74 0F FF 4D FC 74 0A 8A 45 10 88 06 46 38 1E 75 F1 39 5D FC 75 26 88 1F E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 38 5D F4 0F 84 06 FF FF FF 8B 45 F0 83 60 70 FD E9 FA FE FF FF 39 5D F8 75 9E 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__floor_default"
		size = 216
		refs = "0011 _newcw 0016 __ctrlfp 0037 __sptype 0057 __handle_qnan1 0074 __real@3ff0000000000000 008c __frnd 00cd __except1"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 BE FF FF 00 00 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? DD 45 08 59 59 0F B7 4D 0E 8B D8 B8 F0 7F 00 00 23 C8 51 51 DD 1C 24 66 3B C8 75 55 E8 ?? ?? ?? ?? 59 59 85 C0 7E 2D 83 F8 02 7E 1A 83 F8 03 75 23 DD 45 08 53 51 51 DD 1C 24 6A 0B E8 ?? ?? ?? ?? 83 C4 10 EB 74 56 53 E8 ?? ?? ?? ?? DD 45 08 59 59 EB 66 DD 45 08 53 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0B 6A 08 EB 41 E8 ?? ?? ?? ?? DD 5D F8 DD 45 F8 59 DD 45 08 59 DA E9 DF E0 F6 C4 44 7A 0E 56 53 E8 ?? ?? ?? ?? DD 45 F8 59 59 EB 22 F6 C3 20 75 ED DD 45 F8 53 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 0B 6A 10 E8 ?? ?? ?? ?? 83 C4 1C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__cfltcvt_init"
		size = 96
		refs = "0001 __cfltcvt 0006 __cfltcvt_tab 0010 __cropzeros 001a __fassign 0024 __forcdecpt 002e __positive 003d __cfltcvt_l 0047 __fassign_l 0051 __cropzeros_l 005b __forcdecpt_l"
	strings:
		$1 = { B8 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_228_1_0 {
	meta:
		name = "___setfflag"
		size = 21
		refs = "0009 ___fastflag"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_459_1_0 {
	meta:
		name = "__set_malloc_crt_max_wait"
		size = 21
		refs = "0009 __maxwait"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 A1 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_228_2_0 {
	meta:
		name = "__fpmath"
		size = 25
		refs = "0006 __cfltcvt_init 0011 __setdefaultprecision"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 83 7D 08 00 74 05 E8 ?? ?? ?? ?? DB E2 5D C3 }
	condition:
		$1
}

rule file_232_2_0 {
	meta:
		name = "__strerror"
		size = 200
		refs = "0009 __getptd_noexit 002b __calloc_crt 0058 __mbsnbcat_s 0064 ??_C@_02LMMGGCAJ@?3?5?$AA@ 006b _strcat_s 007c __invoke_watson 0081 __errno 0088 __get_sys_err_msg 0091 _strlen 00a3 _strncat_s 00af ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 57 E8 ?? ?? ?? ?? 8B F8 33 DB 3B FB 75 07 33 C0 E9 A8 00 00 00 56 BE 86 00 00 00 39 5F 24 75 18 6A 01 56 E8 ?? ?? ?? ?? 59 59 89 47 24 3B C3 75 07 33 C0 E9 84 00 00 00 8B 45 08 8B 7F 24 88 1F 3B C3 74 35 38 18 74 31 68 82 00 00 00 50 56 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 13 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0A 53 53 53 53 53 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 57 89 45 FC E8 ?? ?? ?? ?? B9 84 00 00 00 2B C8 51 FF 75 FC 56 57 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 C8 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 B5 8B C7 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_232_3_0 {
	meta:
		name = "__strerror_s"
		size = 156
		refs = "000f __errno 0019 __invalid_parameter_noinfo 003a _strlen 004a _strcpy_s 0056 ??_C@_02LMMGGCAJ@?3?5?$AA@ 005d _strcat_s 0070 __invoke_watson 0090 _strerror_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 77 8B 75 0C 85 F6 74 E6 53 8B 5D 10 C6 07 00 85 DB 74 41 80 3B 00 74 3C 53 E8 ?? ?? ?? ?? 59 8D 4E F9 3B C1 73 2E 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 13 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0C 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 57 E8 ?? ?? ?? ?? 59 2B F0 56 57 E8 ?? ?? ?? ?? 59 03 C7 50 E8 ?? ?? ?? ?? 83 C4 0C 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "__close_nolock"
		size = 156
		refs = "000c __get_osfhandle 0017 ___pioinfo 0054 __imp__CloseHandle@4 005e __imp__GetLastError@0 006a __free_osfhnd 008c __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 57 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 50 A1 ?? ?? ?? ?? 83 FE 01 75 09 F6 80 84 00 00 00 01 75 0B 83 FE 02 75 1C F6 40 44 01 74 16 6A 02 E8 ?? ?? ?? ?? 6A 01 8B F8 E8 ?? ?? ?? ?? 59 59 3B C7 74 1C 56 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 8B F8 EB 02 33 FF 56 E8 ?? ?? ?? ?? 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 59 C6 44 30 04 00 85 FF 74 0C 57 E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_233_1_0 {
	meta:
		name = "__close"
		size = 196
		refs = "0003 __sehtable$__close 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0035 __nhandle 004f __invalid_parameter_noinfo 005d ___pioinfo 0077 ___lock_fhandle 008b __close_nolock 00b4 __SEH_epilog4 00be __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 83 FB FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 84 00 00 00 85 DB 78 08 3B 1D ?? ?? ?? ?? 72 1A E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB D2 8B C3 C1 F8 05 8D 3C 85 ?? ?? ?? ?? 8B F3 83 E6 1F C1 E6 06 8B 07 0F BE 44 30 04 83 E0 01 74 C6 53 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 07 F6 44 30 04 01 74 0C 53 E8 ?? ?? ?? ?? 59 89 45 E4 EB 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 5D 08 53 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_237_2_0 {
	meta:
		name = "__spawnvpe"
		size = 620
		refs = "0019 __errno 0024 __invalid_parameter_noinfo 007c __spawnve 00a3 __mbschr 00b2 ??_C@_04HBHDLLBA@PATH?$AA@ 00bc __dupenv_s 00d6 __invoke_watson 00ec __calloc_crt 0106 __getpath 011f _strlen 0132 __mbsrchr 013d ??_C@_01KICIPPFI@?2?$AA@ 0144 _strcat_s 01c6 ___doserrno 0251 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 0C 56 57 33 FF 33 F6 89 7D FC 3B C7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 38 02 00 00 80 38 00 74 E3 53 8B 5D 10 3B DF 74 0B 8B 03 3B C7 74 05 80 38 00 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 07 02 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 F0 E8 ?? ?? ?? ?? FF 75 14 89 38 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 F8 FF 0F 85 A9 01 00 00 E8 ?? ?? ?? ?? 83 38 02 0F 85 9B 01 00 00 6A 2F FF 75 0C E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 87 01 00 00 68 ?? ?? ?? ?? 8D 45 FC 57 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 74 13 83 F8 16 0F 85 68 01 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 39 7D FC 0F 84 55 01 00 00 6A 01 BB 04 01 00 00 53 E8 ?? ?? ?? ?? 8B F0 59 59 3B F7 0F 84 3C 01 00 00 68 03 01 00 00 56 FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 3B C7 E9 0B 01 00 00 80 3E 00 0F 84 1B 01 00 00 56 E8 ?? ?? ?? ?? 8D 7C 30 FF 8A 07 59 3C 5C 75 1F 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F8 74 2C 68 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 83 C4 0C EB 1B 3C 2F 74 17 68 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 C2 00 00 00 56 E8 ?? ?? ?? ?? FF 75 0C 8B F8 E8 ?? ?? ?? ?? 03 F8 59 59 3B FB 0F 83 B2 00 00 00 FF 75 0C 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 91 00 00 00 E8 ?? ?? ?? ?? FF 75 14 83 20 00 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 F8 FF 75 7B E8 ?? ?? ?? ?? 83 38 02 74 45 E8 ?? ?? ?? ?? 83 38 15 74 3B 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F0 74 0E 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B F0 75 4B 8D 7E 01 6A 5C 57 E8 ?? ?? ?? ?? 59 59 3B F8 74 0E 6A 2F 57 E8 ?? ?? ?? ?? 59 59 3B F8 75 2C 68 03 01 00 00 56 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 33 FF 85 C0 89 45 F8 0F 85 EC FE FF FF EB 0E 33 C0 50 50 50 50 50 E9 9F FE FF FF 33 FF E8 ?? ?? ?? ?? 39 38 75 0A E8 ?? ?? ?? ?? 8B 4D F0 89 08 3B F7 74 07 56 E8 ?? ?? ?? ?? 59 39 7D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "__fstat32i64"
		size = 844
		refs = "0003 __sehtable$__fstat32i64 0008 __SEH_prolog4_GS 0026 ___doserrno 002d __errno 0038 __invalid_parameter_noinfo 0049 _memset 006f __nhandle 0091 ___pioinfo 00b5 ___lock_fhandle 00e6 __SEH_epilog4_GS 00f0 __imp__GetFileType@4 0112 __imp__GetLastError@0 0118 __dosmaperr 0179 __imp__PeekNamedPipe@24 01bf __imp__GetFileInformationByHandle@8 0200 __imp__FileTimeToLocalFileTime@8 0216 __imp__FileTimeToSystemTime@8 0243 ___loctotime32_t 0346 __unlock_fhandle"
	strings:
		$1 = { 6A 64 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 89 7D 98 8B 75 0C 33 DB 89 5D 9C 33 C0 3B F3 0F 95 C0 3B C3 75 1F E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 A1 00 00 00 6A 30 53 56 E8 ?? ?? ?? ?? 83 C4 0C 83 FF FE 75 14 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB D3 3B FB 7C 08 3B 3D ?? ?? ?? ?? 72 14 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB AE 8B C7 C1 F8 05 8D 1C 85 ?? ?? ?? ?? 83 E7 1F C1 E7 06 8B 03 0F BE 44 38 04 83 E0 01 75 0A E8 ?? ?? ?? ?? 83 20 00 EB CB FF 75 98 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 03 F6 44 38 04 01 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D 9C FF C7 45 FC FE FF FF FF E8 60 02 00 00 8B 45 9C E8 ?? ?? ?? ?? C3 FF 34 38 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 9B 00 00 00 83 F8 02 74 1D 83 F8 03 74 13 85 C0 74 B7 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B3 83 F8 02 75 07 B9 00 20 00 00 EB 05 B9 00 10 00 00 66 89 4E 06 8B 4D 98 89 0E 89 4E 10 33 C9 41 66 89 4E 08 33 C9 66 89 4E 04 66 89 4E 0C 66 89 4E 0A 89 4E 28 89 4E 24 89 4E 20 83 F8 02 75 0B 89 4E 18 89 4E 1C E9 6C FF FF FF 51 8D 45 94 50 51 51 51 8B 03 FF 34 38 FF 15 ?? ?? ?? ?? 85 C0 74 0F 8B 45 94 99 89 46 18 89 56 1C E9 46 FF FF FF 83 66 18 00 83 66 1C 00 E9 39 FF FF FF 33 C0 66 89 46 06 66 89 46 0C 66 89 46 0A 66 89 46 04 40 66 89 46 08 8D 45 A0 50 8B 03 FF 34 38 FF 15 ?? ?? ?? ?? 85 C0 0F 84 45 FF FF FF 0F B7 46 06 F6 45 A0 01 74 07 0D 24 01 00 00 EB 05 0D B6 01 00 00 66 89 46 06 33 FF 39 7D B4 75 0A 39 7D B8 75 05 89 7E 24 EB 57 8D 45 8C 50 8D 45 B4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C6 FE FF FF 8D 45 D4 50 8D 45 8C 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B0 FE FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 24 39 7D AC 75 0A 39 7D B0 75 05 8B 46 24 EB 54 8D 45 8C 50 8D 45 AC 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 60 FE FF FF 8D 45 D4 50 8D 45 8C 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 4A FE FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 39 7D A4 75 0A 39 7D A8 75 05 8B 46 24 EB 54 8D 45 8C 50 8D 45 A4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 FA FD FF FF 8D 45 D4 50 8D 45 8C 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E4 FD FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 28 33 C0 8B 4D C0 33 DB 03 45 C4 13 CB 89 46 18 89 4E 1C 0F B7 46 06 0D 00 80 00 00 66 89 46 06 89 3E 89 7E 10 E9 94 FD FF FF FF 75 98 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_239_3_0 {
	meta:
		name = "__ismbclegal_l"
		size = 71
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 08 C1 E8 08 0F B6 C8 8B 45 F4 F6 44 01 1D 04 74 10 0F B6 4D 08 F6 44 01 1D 08 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_240_1_0 {
	meta:
		name = "___getlocaleinfo"
		size = 428
		refs = "000c ___security_cookie 004b ___crtGetLocaleInfoA 005a __imp__GetLastError@0 0087 __calloc_crt 00d6 _free 00e7 @__security_check_cookie@4 00f5 _strncpy_s 0119 __invoke_watson 0125 __imp__GetLocaleInfoW@16"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 90 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 0C 01 8B 45 08 53 56 57 8B 7D 18 89 85 78 FF FF FF 0F 85 EF 00 00 00 83 A5 74 FF FF FF 00 68 80 00 00 00 8D 9D 7C FF FF FF 8B CB 51 FF 75 14 FF 75 10 50 E8 ?? ?? ?? ?? 8B F0 83 C4 14 85 F6 75 62 FF 15 ?? ?? ?? ?? 83 F8 7A 75 78 56 56 FF 75 14 FF 75 10 FF B5 78 FF FF FF E8 ?? ?? ?? ?? 83 C4 14 89 85 70 FF FF FF 85 C0 74 58 46 56 50 E8 ?? ?? ?? ?? 8B D8 59 59 85 DB 74 48 FF B5 70 FF FF FF 89 B5 74 FF FF FF 53 FF 75 14 FF 75 10 FF B5 78 FF FF FF E8 ?? ?? ?? ?? 8B F0 83 C4 14 85 F6 74 1A 6A 01 56 E8 ?? ?? ?? ?? 89 07 33 FF 59 59 3B C7 75 21 39 BD 74 FF FF FF 74 07 53 E8 ?? ?? ?? ?? 59 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8D 4E FF 51 53 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 13 39 BD 74 FF FF FF 74 07 53 E8 ?? ?? ?? ?? 59 33 C0 EB CB 57 57 57 57 57 E8 ?? ?? ?? ?? 83 7D 0C 02 75 48 8B 35 ?? ?? ?? ?? 33 C0 50 50 FF 75 14 89 07 FF 75 10 FF D6 8B D8 85 DB 74 1E 6A 02 53 E8 ?? ?? ?? ?? 59 59 89 07 85 C0 74 0E 53 50 FF 75 14 FF 75 10 FF D6 85 C0 75 B4 FF 37 E8 ?? ?? ?? ?? 83 27 00 59 E9 70 FF FF FF 83 7D 0C 00 0F 85 66 FF FF FF 83 A5 78 FF FF FF 00 6A 02 8D 85 78 FF FF FF 50 8B 45 14 0D 00 00 00 20 50 FF 75 10 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3C FF FF FF 8A 85 78 FF FF FF 88 07 E9 63 FF FF FF }
	condition:
		$1
}

rule file_242_3_0 {
	meta:
		name = "__ismbchira_l"
		size = 66
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 12 8B 45 08 05 61 7D FF FF 83 F8 52 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_242_5_0 {
	meta:
		name = "__ismbckata_l"
		size = 74
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 1A 8B 45 08 8D 88 C0 7C FF FF 83 F9 56 77 0C 3D 7F 83 00 00 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_242_7_0 {
	meta:
		name = "__ismbcsymbol_l"
		size = 74
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 1A 8B 45 08 8D 88 BF 7E FF FF 83 F9 6B 77 0C 3D 7F 81 00 00 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "__fileno"
		size = 38
		refs = "000d __errno 0018 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 8B 40 10 5D C3 }
	condition:
		$1
}

rule file_244_2_0 {
	meta:
		name = "__wcenvarg"
		size = 990
		refs = "0009 ___security_cookie 002e ??_C@_1BG@FIGGICF@?$AAS?$AAy?$AAs?$AAt?$AAe?$AAm?$AAR?$AAo?$AAo?$AAt?$AA?$AA@ 0052 _wcslen 006b __calloc_crt 0080 __errno 008b ___doserrno 00a7 __wdupenv_s 00bd __invoke_watson 010f __wenvptr 0118 ___crtGetEnvironmentStringsW 012c _free 0163 _wcscpy_s 021b __wcsnicmp 02eb _memcpy 0351 ??_C@_13NMPKAAJP@?$AA?$DN?$AA?$AA@ 0358 _wcscat_s 03cc @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 0C 8B 45 08 53 56 57 89 4D C8 8B 4D 10 89 4D CC 8B 4D 14 6A 05 89 4D E0 59 BE ?? ?? ?? ?? 8D 7D E4 F3 A5 33 DB 66 A5 6A 02 89 45 B8 8B F8 8B 00 89 5D D0 89 5D DC 89 5D C0 5E EB 10 50 E8 ?? ?? ?? ?? 83 C7 04 8D 74 06 01 8B 07 59 3B C3 75 EC 6A 02 56 89 75 B4 E8 ?? ?? ?? ?? 8B 75 CC 59 59 89 06 3B C3 75 23 8B 45 E0 89 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 26 03 00 00 8D 45 E4 50 8D 45 DC 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0F 83 F8 16 75 6E 53 53 53 53 53 E8 ?? ?? ?? ?? 8D 45 E4 50 E8 ?? ?? ?? ?? 8D 78 02 59 89 7D C4 39 5D DC 74 0E FF 75 DC E8 ?? ?? ?? ?? 03 F8 59 89 7D C4 8B 7D C8 3B FB 74 52 C7 45 D8 02 00 00 00 EB 14 50 E8 ?? ?? ?? ?? 59 8B 4D D8 8D 44 01 01 89 45 D8 83 C7 04 8B 07 3B C3 75 E6 A1 ?? ?? ?? ?? 3B C3 75 6F E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 3B C3 75 61 FF 36 83 4D D0 FF E8 ?? ?? ?? ?? 8B 45 E0 89 1E 59 89 18 E9 5F 02 00 00 8B 45 E0 8B 7D BC 89 18 8B 5D B8 8B 03 8B 36 85 C0 0F 84 63 01 00 00 8B 4D B4 50 8B C6 2B C6 D1 F8 2B C8 51 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 60 02 00 00 FF 33 E8 ?? ?? ?? ?? 59 8D 74 46 02 83 C3 04 E9 34 01 00 00 6A 3D 89 5D D4 5E 66 39 18 74 2B 0F B7 10 8B C8 66 3B D6 74 21 51 E8 ?? ?? ?? ?? 59 8B 4D D4 8D 4C 01 01 A1 ?? ?? ?? ?? 89 4D D4 8D 0C 48 0F B7 11 66 3B D3 75 DA 8B 7D D4 8B CF 8D 0C 48 EB 2C 66 39 59 02 74 2B 66 83 7C 78 04 3A 75 23 66 39 74 78 06 75 1C 8D 44 78 08 50 E8 ?? ?? ?? ?? 8D 7C 07 05 A1 ?? ?? ?? ?? 59 8D 0C 78 66 39 31 74 CF 8B 75 C8 8B C7 2B 45 D4 01 45 D8 8B 45 D8 89 45 BC EB 1F 8D 45 E4 50 E8 ?? ?? ?? ?? 50 8D 45 E4 50 FF 36 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 50 83 C6 04 39 1E 75 DD 8B 45 D8 03 45 C4 6A 02 50 E8 ?? ?? ?? ?? 8B 75 CC 59 59 8B 4D E0 89 01 3B C3 0F 85 F8 FE FF FF FF 36 E8 ?? ?? ?? ?? 59 89 1E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 83 4D D0 FF C7 00 08 00 00 00 E9 26 01 00 00 8B 45 D8 C7 45 C0 01 00 00 00 EB B1 8B 4D CC 50 8B C6 2B 01 8B 4D B4 D1 F8 2B C8 51 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 2F 01 00 00 FF 33 E8 ?? ?? ?? ?? 59 8D 34 46 6A 20 58 83 C3 04 66 89 06 83 C6 02 8B 03 85 C0 75 C2 8B 5D C8 66 89 46 FE 66 89 06 8B 45 E0 8B 30 85 DB 0F 84 AB 00 00 00 8B 45 D4 8B 0D ?? ?? ?? ?? 2B F8 03 FF 57 8D 04 41 50 56 E8 ?? ?? ?? ?? 03 F7 83 C4 0C 83 3B 00 8B FB 74 36 8B 4D E0 FF 37 8B C6 2B 01 8B 4D BC D1 F8 2B C8 51 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 B5 00 00 00 FF 37 E8 ?? ?? ?? ?? 83 C7 04 83 3F 00 59 8D 74 46 02 75 CA 83 7D C0 00 75 4B 8B 7D C4 8D 45 E4 50 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 82 00 00 00 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6F 33 DB 39 5D DC 74 15 FF 75 DC 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 38 FD FF FF 8D 34 7E 85 F6 74 14 8B 45 E0 3B 30 75 08 33 C0 66 89 06 83 C6 02 33 C0 66 89 06 33 DB A1 ?? ?? ?? ?? 3B C3 74 07 50 E8 ?? ?? ?? ?? 59 89 1D ?? ?? ?? ?? 39 5D DC 74 09 FF 75 DC E8 ?? ?? ?? ?? 59 8B 45 D0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 33 C0 50 50 50 50 50 E9 DE FC FF FF }
	condition:
		$1
}

rule file_245_9_0 {
	meta:
		name = "__whiteout"
		size = 50
		refs = "000c __fgetwc_nolock 0022 _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 57 FF 75 08 FF 06 E8 ?? ?? ?? ?? 0F B7 F8 B8 FF FF 00 00 59 66 3B F8 74 0E 6A 08 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 DA 66 8B C7 5F 5D C3 }
	condition:
		$1
}

rule file_245_10_0 {
	meta:
		name = "__winput_s_l"
		size = 4582
		refs = "000c ___security_cookie 006d __errno 0078 __invalid_parameter_noinfo 0092 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00ba _iswctype 00dd __whiteout 00e7 __un_inc 01a1 _isdigit 0335 __fgetwc_nolock 04f6 ___check_float_string 083f __malloc_crt 085e _wcstombs_s 0894 __cfltcvt_tab 089a __imp__DecodePointer@4 08a2 _free 0a88 _memset 0c8d _wctomb_s 0e00 __allmul 0e23 _isxdigit 0e4d __hextodec 10f4 __invoke_watson 11e0 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 48 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 14 8B 45 08 56 8B 75 0C 57 33 FF 89 8D D8 FC FF FF 8D 8D 40 FD FF FF 89 85 20 FD FF FF 89 B5 FC FC FF FF 89 8D 18 FD FF FF C7 85 E4 FC FF FF 5E 01 00 00 89 BD E0 FC FF FF 89 BD DC FC FF FF 89 BD D0 FC FF FF 89 BD 30 FD FF FF 89 BD CC FC FF FF 3B F7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 54 11 00 00 3B C7 74 E4 FF 75 10 8D 8D BC FC FF FF E8 ?? ?? ?? ?? 0F B7 06 C6 85 1E FD FF FF 00 89 BD 38 FD FF FF 89 BD EC FC FF FF 66 3B C7 0F 84 0A 11 00 00 53 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 4E FF B5 20 FD FF FF FF 8D 38 FD FF FF FF B5 20 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 50 E8 ?? ?? ?? ?? 8B B5 FC FC FF FF 59 59 83 C6 02 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EC 89 B5 FC FC FF FF E9 AE 0F 00 00 8B B5 FC FC FF FF 0F B7 06 6A 25 59 66 3B C8 0F 85 3E 0F 00 00 66 3B 4E 02 0F 84 26 0F 00 00 33 FF 89 BD 0C FD FF FF 89 BD B8 FC FF FF 89 BD 14 FD FF FF 89 BD F4 FC FF FF 89 BD 28 FD FF FF 89 BD F0 FC FF FF C6 85 03 FD FF FF 00 C6 85 1D FD FF FF 00 C6 85 2F FD FF FF 00 C6 85 3F FD FF FF 00 C6 85 1F FD FF FF 00 C6 85 37 FD FF FF 00 C6 85 27 FD FF FF 01 89 BD 10 FD FF FF 83 C6 02 0F B7 1E F7 C3 00 FF 00 00 75 2C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 28 FD FF FF FF 85 F4 FC FF FF 6B C0 0A 8D 44 18 D0 89 85 28 FD FF FF E9 CA 00 00 00 83 FB 4E 0F 8F 84 00 00 00 0F 84 BB 00 00 00 83 FB 2A 74 71 83 FB 46 0F 84 AD 00 00 00 83 FB 49 74 10 83 FB 4C 75 75 FE 85 27 FD FF FF E9 98 00 00 00 0F B7 4E 02 83 F9 36 75 1E 66 83 7E 04 34 75 17 83 C6 04 FF 85 10 FD FF FF 89 BD 04 FD FF FF 89 BD 08 FD FF FF EB 71 83 F9 33 75 0C 66 83 7E 04 32 75 05 83 C6 04 EB 60 83 F9 64 74 5B 83 F9 69 74 56 83 F9 6F 74 51 83 F9 78 74 4C 83 F9 58 75 19 EB 45 FE 85 2F FD FF FF EB 3D 83 FB 68 74 2C 83 FB 6C 74 0D 83 FB 77 74 1A FE 85 3F FD FF FF EB 26 66 83 7E 02 6C 75 05 83 C6 02 EB 95 FE 85 27 FD FF FF FE 85 37 FD FF FF EB 0C FE 8D 27 FD FF FF FE 8D 37 FD FF FF 80 BD 3F FD FF FF 00 0F 84 EF FE FF FF 80 BD 2F FD FF FF 00 89 B5 FC FC FF FF 75 19 8B 85 D8 FC FF FF 8B 18 89 85 D4 FC FF FF 83 C0 04 89 85 D8 FC FF FF EB 02 33 DB 80 BD 37 FD FF FF 00 89 9D F8 FC FF FF C6 85 3F FD FF FF 00 75 1B 0F B7 06 83 F8 53 74 0C C6 85 37 FD FF FF 01 83 F8 43 75 07 C6 85 37 FD FF FF FF 0F B7 3E 83 CF 20 89 BD E8 FC FF FF 83 FF 6E 74 52 83 FF 63 74 18 83 FF 7B 74 13 FF B5 20 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? EB 11 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 B9 FF FF 00 00 89 85 30 FD FF FF 66 3B C8 0F 84 F2 0D 00 00 8B 9D F8 FC FF FF 8B B5 FC FC FF FF 8B 8D F4 FC FF FF 85 C9 74 0D 83 BD 28 FD FF FF 00 0F 84 BC 0D 00 00 80 BD 2F FD FF FF 00 75 41 83 FF 63 74 0A 83 FF 73 74 05 83 FF 7B 75 32 8B 85 D4 FC FF FF 8B 18 83 C0 04 89 85 D4 FC FF FF 83 C0 04 89 85 D8 FC FF FF 8B 40 FC 89 9D F8 FC FF FF 89 85 F0 FC FF FF 83 F8 01 0F 82 10 0D 00 00 83 FF 6F 0F 8F 06 06 00 00 0F 84 5F 09 00 00 83 FF 63 0F 84 D8 04 00 00 6A 64 58 3B F8 0F 84 4B 09 00 00 0F 8E 10 06 00 00 83 FF 67 7E 4C 83 FF 69 74 21 83 FF 6E 0F 85 FD 05 00 00 80 BD 2F FD FF FF 00 8B 85 38 FD FF FF 0F 84 07 0C 00 00 E9 2E 0C 00 00 89 85 E8 FC FF FF 8B F8 8B 9D 30 FD FF FF 6A 2D 58 66 3B C3 0F 85 43 07 00 00 C6 85 1D FD FF FF 01 E9 3F 07 00 00 6A 2D 58 33 DB 66 3B 85 30 FD FF FF 75 0C 8B 8D 18 FD FF FF 66 89 01 43 EB 0C 6A 2B 58 66 3B 85 30 FD FF FF 75 21 FF 8D 28 FD FF FF FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF 83 BD F4 FC FF FF 00 75 07 83 8D 28 FD FF FF FF F7 85 30 FD FF FF 00 FF 00 00 0F 85 8C 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 7A 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 74 6A 66 0F BE 85 30 FD FF FF 8B 8D 18 FD FF FF FF 85 14 FD FF FF 66 89 04 59 8D 85 E0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 18 FD FF FF 8D B5 E4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 3E 0C 00 00 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF A9 00 FF 00 00 0F 84 74 FF FF FF 8B 85 BC FC FF FF 8B 80 BC 00 00 00 8B 40 30 0F B7 30 0F BE 8D 30 FD FF FF 8B C6 3B C1 0F 85 FF 00 00 00 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 0F 84 EB 00 00 00 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 30 FD FF FF 8B 85 18 FD FF FF 66 89 34 58 8D 85 E0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 18 FD FF FF 8D B5 E4 FC FF FF E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 91 0B 00 00 F7 85 30 FD FF FF 00 FF 00 00 0F 85 8B 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 79 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 74 69 8B 85 18 FD FF FF 66 8B 8D 30 FD FF FF FF 85 14 FD FF FF 66 89 0C 58 8D 85 E0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 18 FD FF FF 8D B5 E4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 1C 0B 00 00 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF A9 00 FF 00 00 0F 84 75 FF FF FF 83 BD 14 FD FF FF 00 0F 84 94 01 00 00 6A 65 58 66 3B 85 30 FD FF FF 74 10 6A 45 58 66 3B 85 30 FD FF FF 0F 85 78 01 00 00 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 0F 84 64 01 00 00 8B 8D 18 FD FF FF 6A 65 58 66 89 04 59 8D 85 E0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 18 FD FF FF 8D B5 E4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 80 0A 00 00 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 C0 6A 2D 59 89 85 30 FD FF FF 66 3B C8 75 2E 51 8B 8D 18 FD FF FF 58 66 89 04 59 8D 85 E0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 31 0A 00 00 EB 0C 6A 2B 58 66 3B 85 30 FD FF FF 75 33 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 75 08 21 85 28 FD FF FF EB 1B FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF F7 85 30 FD FF FF 00 FF 00 00 0F 85 8B 00 00 00 0F B6 85 30 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 79 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 74 69 8B 85 18 FD FF FF 66 8B 8D 30 FD FF FF FF 85 14 FD FF FF 66 89 0C 58 8D 85 E0 FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 18 FD FF FF 8D B5 E4 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 7B 09 00 00 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 59 89 85 30 FD FF FF A9 00 FF 00 00 0F 84 75 FF FF FF FF B5 20 FD FF FF FF 8D 38 FD FF FF FF B5 30 FD FF FF E8 ?? ?? ?? ?? 83 BD 14 FD FF FF 00 59 59 0F 84 2F 09 00 00 80 BD 2F FD FF FF 00 0F 85 1F 08 00 00 8B B5 E4 FC FF FF 8B 8D 18 FD FF FF FF 85 EC FC FF FF 33 C0 8D 74 36 02 56 66 89 04 59 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 84 F5 08 00 00 8D 46 FF 50 FF B5 18 FD FF FF 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 12 83 F8 16 0F 84 7C 08 00 00 83 F8 22 0F 84 73 08 00 00 8D 85 BC FC FF FF 50 0F BE 85 27 FD FF FF 57 FF B5 F8 FC FF FF 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 92 07 00 00 85 C9 75 10 FF 85 28 FD FF FF C7 85 F4 FC FF FF 01 00 00 00 80 BD 37 FD FF FF 00 7E 07 C6 85 1F FD FF FF 01 FF B5 20 FD FF FF FF 8D 38 FD FF FF FF B5 30 FD FF FF 8B F3 E8 ?? ?? ?? ?? 59 59 83 FF 63 74 06 FF 8D F0 FC FF FF 83 BD F4 FC FF FF 00 74 14 8B 85 28 FD FF FF FF 8D 28 FD FF FF 85 C0 0F 84 C5 03 00 00 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D0 B8 FF FF 00 00 59 89 95 30 FD FF FF 66 3B C2 0F 84 88 03 00 00 83 FF 63 74 52 83 FF 73 75 13 83 FA 09 72 09 83 FA 0D 0F 86 70 03 00 00 83 FA 20 75 3A 83 FF 7B 0F 85 62 03 00 00 0F B7 C2 8B C8 33 FF 83 E1 07 47 D3 E7 8B 8D DC FC FF FF C1 E8 03 0F BE 04 08 0F BE 8D 03 FD FF FF 33 C1 85 F8 8B BD E8 FC FF FF 0F 84 31 03 00 00 80 BD 2F FD FF FF 00 0F 85 1C 03 00 00 83 BD F0 FC FF FF 00 0F 84 61 07 00 00 80 BD 1F FD FF FF 00 0F 84 BA 02 00 00 66 89 13 83 C3 02 89 9D F8 FC FF FF E9 25 FF FF FF 8B C7 83 E8 70 0F 84 4D 03 00 00 83 E8 03 0F 84 E1 FE FF FF 48 48 0F 84 43 03 00 00 83 E8 03 0F 84 28 FA FF FF 83 E8 03 74 33 8B 85 30 FD FF FF 66 39 06 0F 85 F2 06 00 00 FE 8D 1E FD FF FF 80 BD 2F FD FF FF 00 0F 85 27 06 00 00 8B 85 D4 FC FF FF 89 85 D8 FC FF FF E9 16 06 00 00 80 BD 37 FD FF FF 00 7E 07 C6 85 1F FD FF FF 01 6A 5E 58 8D 7E 02 66 3B 46 02 75 0A 8D 7E 04 C6 85 03 FD FF FF FF 8B B5 DC FC FF FF 85 F6 75 25 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 DC FC FF FF 85 C0 0F 84 D0 06 00 00 C7 85 D0 FC FF FF 01 00 00 00 8B F0 68 00 20 00 00 6A 00 56 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 58 66 3B 07 75 0E 50 5A 83 C7 02 C6 46 0B 20 E9 9A 00 00 00 8B 95 B8 FC FF FF E9 8F 00 00 00 0F B7 C0 6A 2D 59 83 C7 02 66 3B C8 75 70 66 85 D2 74 6B 0F B7 0F 6A 5D 5B 66 3B D9 74 60 8B C1 83 C7 02 66 3B D0 73 02 EB 05 0F B7 CA 8B D0 89 8D 10 FD FF FF 66 3B D1 73 2A 8B C1 2B C2 0F B7 C0 0F B7 DA 89 85 0C FD FF FF 8B CB 83 E1 07 B2 01 D2 E2 8B C3 C1 E8 03 08 14 30 43 FF 8D 0C FD FF FF 75 E6 0F B7 8D 10 FD FF FF 8B C1 83 E1 07 B2 01 D2 E2 C1 E8 03 08 14 30 33 D2 EB 11 8B C8 83 E1 07 B3 01 D2 E3 8B D0 C1 E8 03 08 1C 30 0F B7 07 6A 5D 59 66 3B C8 0F 85 62 FF FF FF 66 83 3F 00 0F 84 EB 05 00 00 8B 9D F8 FC FF FF 89 BD FC FC FF FF 8B BD E8 FC FF FF E9 63 FD FF FF 6A 2B 58 66 3B C3 75 30 FF 8D 28 FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 1B FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF 6A 30 58 66 3B C3 0F 85 C8 01 00 00 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 D8 6A 78 5E 89 9D 30 FD FF FF 66 3B F3 74 55 6A 58 58 66 3B C3 74 4D C7 85 14 FD FF FF 01 00 00 00 3B FE 74 23 83 BD F4 FC FF FF 00 74 0E FF 8D 28 FD FF FF 75 06 FE 85 3F FD FF FF C7 85 E8 FC FF FF 6F 00 00 00 EB 5C FF B5 20 FD FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 4A 01 00 00 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD F4 FC FF FF 00 0F B7 D8 59 89 9D 30 FD FF FF 74 16 83 AD 28 FD FF FF 02 83 BD 28 FD FF FF 01 7D 06 FE 85 3F FD FF FF 89 B5 E8 FC FF FF 8B BD E8 FC FF FF E9 05 01 00 00 83 A5 10 FD FF FF 00 52 FF B5 F0 FC FF FF 8D 85 10 FD FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 22 0F 84 73 04 00 00 8B 85 10 FD FF FF 85 C0 0F 8E 4D FC FF FF 03 D8 29 85 F0 FC FF FF 89 9D F8 FC FF FF E9 3A FC FF FF 83 C6 02 E9 32 FC FF FF FF B5 20 FD FF FF FF 8D 38 FD FF FF 52 E8 ?? ?? ?? ?? 59 59 3B F3 0F 84 61 04 00 00 80 BD 2F FD FF FF 00 0F 85 51 03 00 00 FF 85 EC FC FF FF 83 FF 63 0F 84 42 03 00 00 80 BD 1F FD FF FF 00 74 10 8B 8D F8 FC FF FF 33 C0 66 89 01 E9 29 03 00 00 8B 85 F8 FC FF FF C6 00 00 E9 1B 03 00 00 C6 85 27 FD FF FF 01 8B 9D 30 FD FF FF 6A 2D 58 66 3B C3 75 09 C6 85 1D FD FF FF 01 EB 08 6A 2B 58 66 3B C3 75 30 FF 8D 28 FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 1B FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 59 0F B7 D8 89 9D 30 FD FF FF 83 BD 10 FD FF FF 00 0F 84 62 01 00 00 80 BD 3F FD FF FF 00 0F 85 24 01 00 00 83 FF 78 74 78 83 FF 70 74 73 F7 C3 00 FF 00 00 0F 85 FA 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 E8 00 00 00 83 FF 6F 75 2D 6A 38 58 66 3B C3 0F 86 D7 00 00 00 8B 85 04 FD FF FF 8B 8D 08 FD FF FF 0F A4 C1 03 C1 E0 03 89 85 04 FD FF FF 89 8D 08 FD FF FF EB 6C 6A 00 6A 0A FF B5 08 FD FF FF FF B5 04 FD FF FF E8 ?? ?? ?? ?? 89 85 04 FD FF FF 89 95 08 FD FF FF EB 49 F7 C3 00 FF 00 00 0F 85 87 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 79 8B 85 04 FD FF FF 8B 8D 08 FD FF FF 0F A4 C1 04 C1 E0 04 53 89 85 04 FD FF FF 89 8D 08 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF FF 85 14 FD FF FF 0F B7 C3 83 E8 30 99 01 85 04 FD FF FF 11 95 08 FD FF FF 83 BD F4 FC FF FF 00 74 08 FF 8D 28 FD FF FF 74 34 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF E9 F0 FE FF FF FF B5 20 FD FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 59 80 BD 1D FD FF FF 00 0F 84 1A 01 00 00 8B 85 04 FD FF FF 8B 8D 08 FD FF FF F7 D8 83 D1 00 F7 D9 89 85 04 FD FF FF 89 8D 08 FD FF FF E9 F6 00 00 00 80 BD 3F FD FF FF 00 0F 85 DA 00 00 00 83 FF 78 74 4A 83 FF 70 74 45 F7 C3 00 FF 00 00 0F 85 B0 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 9E 00 00 00 83 FF 6F 75 17 6A 38 58 66 3B C3 0F 86 8D 00 00 00 8B 85 0C FD FF FF C1 E0 03 EB 3E 8B 85 0C FD FF FF 6B C0 0A EB 33 F7 C3 00 FF 00 00 75 6F 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 61 C1 A5 0C FD FF FF 04 53 E8 ?? ?? ?? ?? 0F B7 D8 8B 85 0C FD FF FF 59 89 9D 30 FD FF FF FF 85 14 FD FF FF 83 BD F4 FC FF FF 00 0F B7 CB 8D 44 08 D0 89 85 0C FD FF FF 74 08 FF 8D 28 FD FF FF 74 34 FF B5 20 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 30 FD FF FF E9 3A FF FF FF FF B5 20 FD FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 59 80 BD 1D FD FF FF 00 74 06 F7 9D 0C FD FF FF 83 FF 46 75 07 83 A5 14 FD FF FF 00 83 BD 14 FD FF FF 00 0F 84 4A 01 00 00 80 BD 2F FD FF FF 00 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "__msize"
		size = 51
		refs = "000c __errno 0017 __invalid_parameter_noinfo 0027 __crtheap 002d __imp__HeapSize@12"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF 5D C3 FF 75 08 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "__fstat32"
		size = 812
		refs = "0003 __sehtable$__fstat32 0008 __SEH_prolog4_GS 0026 ___doserrno 002d __errno 0038 __invalid_parameter_noinfo 0049 _memset 006f __nhandle 0091 ___pioinfo 00b5 ___lock_fhandle 00e6 __SEH_epilog4_GS 00f0 __imp__GetFileType@4 0112 __imp__GetLastError@0 0118 __dosmaperr 0176 __imp__PeekNamedPipe@24 01ab __imp__GetFileInformationByHandle@8 01ec __imp__FileTimeToLocalFileTime@8 0202 __imp__FileTimeToSystemTime@8 022f ___loctotime32_t 0326 __unlock_fhandle"
	strings:
		$1 = { 6A 64 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 89 7D 98 8B 75 0C 33 DB 89 5D 9C 33 C0 3B F3 0F 95 C0 3B C3 75 1F E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 A1 00 00 00 6A 24 53 56 E8 ?? ?? ?? ?? 83 C4 0C 83 FF FE 75 14 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB D3 3B FB 7C 08 3B 3D ?? ?? ?? ?? 72 14 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB AE 8B C7 C1 F8 05 8D 1C 85 ?? ?? ?? ?? 83 E7 1F C1 E7 06 8B 03 0F BE 44 38 04 83 E0 01 75 0A E8 ?? ?? ?? ?? 83 20 00 EB CB FF 75 98 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 03 F6 44 38 04 01 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D 9C FF C7 45 FC FE FF FF FF E8 40 02 00 00 8B 45 9C E8 ?? ?? ?? ?? C3 FF 34 38 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 87 00 00 00 83 F8 02 74 1D 83 F8 03 74 13 85 C0 74 B7 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B3 83 F8 02 75 07 B9 00 20 00 00 EB 05 B9 00 10 00 00 66 89 4E 06 8B 4D 98 89 0E 89 4E 10 33 C9 41 66 89 4E 08 33 C9 66 89 4E 04 66 89 4E 0C 66 89 4E 0A 89 4E 20 89 4E 1C 89 4E 18 83 F8 02 75 08 89 4E 14 E9 6F FF FF FF 51 8D 45 94 50 51 51 51 8B 03 FF 34 38 FF 15 ?? ?? ?? ?? F7 D8 1B C0 23 45 94 89 46 14 E9 4D FF FF FF 33 C0 66 89 46 06 66 89 46 0C 66 89 46 0A 66 89 46 04 40 66 89 46 08 8D 45 A0 50 8B 03 FF 34 38 FF 15 ?? ?? ?? ?? 85 C0 0F 84 59 FF FF FF 0F B7 46 06 F6 45 A0 01 74 07 0D 24 01 00 00 EB 05 0D B6 01 00 00 66 89 46 06 33 FF 39 7D B4 75 0A 39 7D B8 75 05 89 7E 1C EB 57 8D 45 8C 50 8D 45 B4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 DA FE FF FF 8D 45 D4 50 8D 45 8C 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C4 FE FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 1C 39 7D AC 75 0A 39 7D B0 75 05 8B 46 1C EB 54 8D 45 8C 50 8D 45 AC 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 74 FE FF FF 8D 45 D4 50 8D 45 8C 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 5E FE FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 18 39 7D A4 75 0A 39 7D A8 75 05 8B 46 1C EB 54 8D 45 8C 50 8D 45 A4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 0E FE FF FF 8D 45 D4 50 8D 45 8C 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F8 FD FF FF 6A FF 0F B7 45 E0 50 0F B7 45 DE 50 0F B7 45 DC 50 0F B7 45 DA 50 0F B7 45 D6 50 0F B7 45 D4 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 8B 45 C4 89 46 14 0F B7 46 06 0D 00 80 00 00 66 89 46 06 89 3E 89 7E 10 E9 B4 FD FF FF FF 75 98 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_248_29_0 {
	meta:
		name = "?SetAffinity@FreeThreadProxy@details@Concurrency@@QAEXUHardwareAffinity@23@@Z"
		size = 56
		refs = "0011 ??8HardwareAffinity@details@Concurrency@@QAE_NABU012@@Z 0020 ?ApplyTo@HardwareAffinity@details@Concurrency@@QAEXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F9 8D 45 08 50 8D 4F 30 E8 ?? ?? ?? ?? 84 C0 75 0B FF 77 08 8D 4D 08 E8 ?? ?? ?? ?? 66 8B 45 0C 66 89 47 34 8B 45 08 89 47 30 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_248_30_0 {
	meta:
		name = "??0FreeVirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z"
		size = 39
		refs = "0012 ??0VirtualProcessorRoot@details@Concurrency@@QAE@PAVSchedulerProxy@12@PAUSchedulerNode@12@I@Z 001c ??_7FreeVirtualProcessorRoot@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 10 8B F1 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 66 4C 00 C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_248_32_0 {
	meta:
		name = "?Deactivate@FreeVirtualProcessorRoot@details@Concurrency@@UAE_NPAUIExecutionContext@3@@Z"
		size = 140
		refs = "001c ??_C@_08BAFMHLII@pContext?$AA@ 0021 ??0exception@std@@QAE@ABQBD@Z 0028 ??_7invalid_argument@std@@6B@ 002d __TI3?AVinvalid_argument@std@@ 0036 __CxxThrowException@8 0044 ??0invalid_operation@Concurrency@@QAE@XZ 0049 __TI2?AVinvalid_operation@Concurrency@@ 006f ?DecrementCoreSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 0077 ?SuspendExecution@ThreadProxy@details@Concurrency@@QAEXXZ 0080 ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B F1 8B 4D 08 85 C9 75 28 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 F4 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 83 7E 4C 00 75 0F 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB E2 8B 01 FF 50 08 39 46 4C 75 E7 8D 46 48 83 C9 FF F0 0F C1 08 49 75 1F 8B 4E 18 57 8D 7E 04 57 E8 ?? ?? ?? ?? 8B 4E 4C E8 ?? ?? ?? ?? 8B 4E 18 57 E8 ?? ?? ?? ?? 5F B0 01 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_248_37_0 {
	meta:
		name = "?EnsureAllTasksVisible@FreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@@Z"
		size = 105
		refs = "001c ??_C@_08BAFMHLII@pContext?$AA@ 0021 ??0exception@std@@QAE@ABQBD@Z 0028 ??_7invalid_argument@std@@6B@ 002d __TI3?AVinvalid_argument@std@@ 0036 __CxxThrowException@8 0044 ??0invalid_operation@Concurrency@@QAE@XZ 0049 __TI2?AVinvalid_operation@Concurrency@@ 0060 ?FlushStoreBuffers@ResourceManager@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B F1 8B 4D 08 85 C9 75 28 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 F4 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 83 7E 4C 00 75 0F 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB E2 8B 01 FF 50 08 39 46 4C 75 E7 8B 46 18 8B 48 0C E8 ?? ?? ?? ?? 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_248_38_0 {
	meta:
		name = "?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QAEXPAVFreeThreadProxy@23@@Z"
		size = 104
		refs = "0009 ___security_cookie 001d ?SpinUntilBlocked@ThreadProxy@details@Concurrency@@QAEXXZ 0038 ?GetNodeAffinity@SchedulerProxy@details@Concurrency@@QAE?AUHardwareAffinity@23@I@Z 0049 _memcpy 0053 ?SetAffinity@FreeThreadProxy@details@Concurrency@@QAEXUHardwareAffinity@23@@Z 0060 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B 7D 08 8B F1 8B CF E8 ?? ?? ?? ?? 89 7E 4C 89 77 10 8B 06 8B 5E 18 8B CE FF 10 50 8D 45 F0 50 8B CB E8 ?? ?? ?? ?? 83 EC 0C 8B C4 6A 0C 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 0C 8B CF E8 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_248_42_0 {
	meta:
		name = "?Activate@FreeVirtualProcessorRoot@details@Concurrency@@UAEXPAUIExecutionContext@3@@Z"
		size = 161
		refs = "001d ??_C@_08BAFMHLII@pContext?$AA@ 0022 ??0exception@std@@QAE@ABQBD@Z 0029 ??_7invalid_argument@std@@6B@ 002e __TI3?AVinvalid_argument@std@@ 0037 __CxxThrowException@8 0054 ??0invalid_operation@Concurrency@@QAE@XZ 0059 __TI2?AVinvalid_operation@Concurrency@@ 0076 ?IncrementCoreSubscription@SchedulerProxy@details@Concurrency@@QAEXPAVExecutionResource@23@@Z 007e ?Affinitize@FreeVirtualProcessorRoot@details@Concurrency@@QAEXPAVFreeThreadProxy@23@@Z 0097 ?ResumeExecution@ThreadProxy@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 57 8B 7D 08 8B F1 85 FF 75 28 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 F4 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 8B 07 53 8B CF FF 50 08 8B D8 8B 46 4C 85 C0 74 13 3B D8 74 32 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB D3 85 DB 75 0B 8B 4E 18 8B 01 57 FF 50 1C 8B D8 8B 4E 18 8D 46 04 50 E8 ?? ?? ?? ?? 53 8B CE E8 ?? ?? ?? ?? 33 C0 8D 4E 48 40 F0 0F C1 01 40 5B 83 F8 02 74 08 8B 4E 4C E8 ?? ?? ?? ?? 5F 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@PBDJ@Z"
		size = 36
		refs = "000d ??0exception@std@@QAE@ABQBD@Z 0019 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 08 50 8B F1 E8 ?? ?? ?? ?? 8B 45 0C 89 46 0C C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_250_4_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QAE@J@Z"
		size = 44
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 0021 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 89 46 0C C7 06 ?? ?? ?? ?? 8B C6 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_50_5_1 {
	meta:
		name = "??0regex_error@tr1@std@@QAE@W4error_type@regex_constants@12@@Z"
		size = 44
		refs = "0010 ??_C@_0BJ@JKOPOGND@regular?5expression?5error?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 0021 ??_7regex_error@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 89 46 0C C7 06 ?? ?? ?? ?? 8B C6 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_250_8_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_36_0 {
	meta:
		name = "??0bad_target@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_29_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_26_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_23_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_69_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_14_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_17_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_20_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_42_0 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_63_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_54_0 {
	meta:
		name = "??0invalid_operation@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_66_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_45_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_51_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_48_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_39_0 {
	meta:
		name = "??0message_not_found@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_33_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_57_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_60_0 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_11_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_250_72_0 {
	meta:
		name = "??0task_canceled@details@Concurrency@@QAE@XZ"
		size = 36
		refs = "0010 ??_C@_00CNPNBAHC@?$AA@ 0015 ??0exception@std@@QAE@ABQBD@Z 001b ??_7task_canceled@details@Concurrency@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8D 45 FC 50 8B F1 C7 45 FC ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_251_3_0 {
	meta:
		name = "__ismbclower_l"
		size = 175
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 006a ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 6E 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 33 DB 88 4D 09 5F 39 58 08 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 5B 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CC 66 39 5D FE 75 0B F6 45 FC 02 74 05 33 C0 40 EB 02 33 C0 38 5D F8 EB 16 8B 45 F0 8A 44 08 1D 24 20 33 C9 3C 20 0F 94 C1 80 7D F8 00 8B C1 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__lseek_nolock"
		size = 117
		refs = "000b __get_osfhandle 0016 __errno 0031 __imp__SetFilePointer@16 003e __imp__GetLastError@0 004c __dosmaperr 005e ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 56 E8 ?? ?? ?? ?? 59 83 F8 FF 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF EB 4D 57 FF 75 10 6A 00 FF 75 0C 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF EB 1B 8B C6 C1 F8 05 8B 04 85 ?? ?? ?? ?? 83 E6 1F C1 E6 06 8D 44 30 04 80 20 FD 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_253_4_0 {
	meta:
		name = "??0WorkItem@details@Concurrency@@QAE@PAVRealizedChore@12@PAVScheduleGroupBase@12@@Z"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 8B 4D 0C 89 48 04 8B 4D 08 C7 00 02 00 00 00 89 48 08 5D C2 08 00 }
	condition:
		$1
}

rule file_253_5_0 {
	meta:
		name = "??0WorkItem@details@Concurrency@@QAE@PAV_UnrealizedChore@12@PAVScheduleGroupBase@12@@Z"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 8B 4D 0C 89 48 04 8B 4D 08 C7 00 04 00 00 00 89 48 08 5D C2 08 00 }
	condition:
		$1
}

rule file_253_9_0 {
	meta:
		name = "?LocalBiasStage@WorkSearchContext@details@Concurrency@@AAEHXZ"
		size = 31
	strings:
		$1 = { 8B 41 10 83 F8 65 73 03 33 C0 C3 83 F8 7F 73 04 33 C0 40 C3 3D 97 00 00 00 1B C0 83 C0 03 C3 }
	condition:
		$1
}

rule file_253_10_0 {
	meta:
		name = "?DropRingBias@WorkSearchContext@details@Concurrency@@AAE_NXZ"
		size = 25
	strings:
		$1 = { 81 79 14 33 01 00 00 0F 97 C0 84 C0 74 0A 80 79 21 00 75 04 C6 41 20 01 C3 }
	condition:
		$1
}

rule file_253_11_0 {
	meta:
		name = "?PerformOneTimeLRCScan@WorkSearchContext@details@Concurrency@@AAE_NXZ"
		size = 18
	strings:
		$1 = { 80 79 20 00 74 09 66 C7 41 20 00 01 B0 01 C3 32 C0 C3 }
	condition:
		$1
}

rule file_253_15_0 {
	meta:
		name = "?GetNextSchedulingNode@SchedulerBase@details@Concurrency@@QAEPAVSchedulingNode@23@PAHH@Z"
		size = 75
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 0C FF 53 8B 5D 08 0F 95 C0 56 8B 71 24 57 33 FF 03 03 89 45 08 85 F6 7E 1C 8B 45 08 03 C7 99 F7 FE 3B 55 0C 74 0F 8B 41 1C 8B 04 90 85 C0 75 0E 47 3B FE 7C E4 33 C0 5F 5E 5B 5D C2 08 00 89 13 EB F5 }
	condition:
		$1
}

rule file_253_19_0 {
	meta:
		name = "?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
		size = 36
		refs = "0019 ?RemoveScheduleGroup@SchedulingRing@details@Concurrency@@AAEXPAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { F6 41 74 04 75 1B 56 8D 41 6C 83 CE FF F0 0F C1 30 4E 75 09 51 8B 49 60 E8 ?? ?? ?? ?? 8B C6 5E C3 33 C0 C3 }
	condition:
		$1
}

rule file_253_20_0 {
	meta:
		name = "??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
		size = 40
		refs = "0016 ?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 8B F1 8D 4F 04 C7 06 01 00 00 00 E8 ?? ?? ?? ?? 89 7E 08 89 46 04 5F 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_253_21_0 {
	meta:
		name = "?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 52
		refs = "001f ?GetInternalContext@ScheduleGroupBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z"
	strings:
		$1 = { 8B FF 53 56 8B F1 8B 06 48 48 6A 01 5B 74 07 48 48 75 19 53 EB 02 6A 00 FF 76 08 8B 4E 04 E8 ?? ?? ?? ?? 89 46 08 08 98 97 00 00 00 8B 46 08 89 1E 5E 5B C3 }
	condition:
		$1
}

rule file_253_22_0 {
	meta:
		name = "?Invoke@WorkItem@details@Concurrency@@QAEXXZ"
		size = 49
		refs = "001d ?Invoke@RealizedChore@details@Concurrency@@QAEXXZ 002b ?ReleaseRealizedChore@SchedulerBase@details@Concurrency@@QAEXPAVRealizedChore@23@@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8B 06 48 48 74 0E 48 48 75 20 8B 76 08 56 FF 56 0C 59 5E C3 8B 4E 08 E8 ?? ?? ?? ?? 8B 46 04 FF 76 08 8B 48 64 E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_253_23_0 {
	meta:
		name = "?TransferReferences@WorkItem@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 65
		refs = "0010 ?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 0027 ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ 0037 ?SwapScheduleGroup@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 8B F1 8D 4F 04 E8 ?? ?? ?? ?? 83 3E 02 8B 76 04 75 11 3B C6 74 04 6A 00 EB 0F 8B C8 E8 ?? ?? ?? ?? EB 0E 3B C6 74 0A 6A 01 56 8B CF E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_253_24_0 {
	meta:
		name = "?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z"
		size = 51
		refs = "001b ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 49 08 8B 01 83 EC 0C FF 50 08 85 C0 74 19 56 57 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 5F B0 01 5E EB 02 32 C0 C9 C2 04 00 }
	condition:
		$1
}

rule file_253_25_0 {
	meta:
		name = "?GetRunnableContext@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z"
		size = 51
		refs = "001b ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 01 83 EC 0C FF 50 18 85 C0 74 19 56 57 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 5F B0 01 5E EB 02 32 C0 C9 C2 08 00 }
	condition:
		$1
}

rule file_253_29_0 {
	meta:
		name = "?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
		size = 35
		altNames = "?Pop@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEPAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 8B 51 04 56 8B 71 08 4A 57 8B 79 0C 23 F2 89 51 04 33 C0 8D 34 B7 87 06 5F 5E 85 C0 75 04 42 89 51 04 C3 }
	condition:
		$1
}

rule file_253_33_0 {
	meta:
		name = "?GetNextVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAHH@Z"
		size = 93
		refs = "003d ??A?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@QBEPAVVirtualProcessor@12@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 33 C0 83 7D 0C FF 53 0F 95 C0 83 65 FC 00 56 8B F1 8B 4D 08 57 8B 7E 58 03 01 89 45 F8 85 FF 7E 25 8B 45 FC 03 45 F8 99 F7 FF 8B DA 3B 5D 0C 74 15 53 8D 4E 18 E8 ?? ?? ?? ?? 85 C0 75 11 FF 45 FC 39 7D FC 7C DB 33 C0 5F 5E 5B C9 C2 08 00 8B 4D 08 89 19 EB F2 }
	condition:
		$1
}

rule file_253_34_0 {
	meta:
		name = "?GetLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ"
		size = 22
		refs = "000f ?Pop@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ"
	strings:
		$1 = { 8B 41 0C 83 C1 08 8B 11 2B C2 85 C0 7E 05 E9 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_253_35_0 {
	meta:
		name = "?GetFirstSchedulingNode@SchedulerBase@details@Concurrency@@QAEPAVSchedulingNode@23@PAH@Z"
		size = 23
		refs = "000f ?GetNextSchedulingNode@SchedulerBase@details@Concurrency@@QAEPAVSchedulingNode@23@PAHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 20 00 6A FF 50 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_253_39_0 {
	meta:
		name = "?GetFirstVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAH@Z"
		size = 23
		refs = "000f ?GetNextVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 20 00 6A FF 50 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_253_36_0 {
	meta:
		name = "?SetPseudoRRScheduleGroupNext@SchedulingRing@details@Concurrency@@QAEXH@Z"
		size = 24
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 40 56 8B 71 50 99 F7 FE 5E 89 51 60 5D C2 04 00 }
	condition:
		$1
}

rule file_253_37_0 {
	meta:
		name = "?GetNextScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAHH@Z"
		size = 93
		refs = "003d ??A?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@QBEPAVScheduleGroupBase@12@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 33 C0 83 7D 0C FF 53 0F 95 C0 83 65 FC 00 56 8B F1 8B 4D 08 57 8B 7E 50 03 01 89 45 F8 85 FF 7E 25 8B 45 FC 03 45 F8 99 F7 FF 8B DA 3B 5D 0C 74 15 53 8D 4E 10 E8 ?? ?? ?? ?? 85 C0 75 11 FF 45 FC 39 7D FC 7C DB 33 C0 5F 5E 5B C9 C2 08 00 8B 4D 08 89 19 EB F2 }
	condition:
		$1
}

rule file_253_41_0 {
	meta:
		name = "?GetPseudoRRScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAH@Z"
		size = 25
		refs = "0011 ?GetNextScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 51 60 6A FF 50 89 10 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_253_42_0 {
	meta:
		name = "?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z"
		size = 82
		refs = "0019 ?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 002b ?GetNextVirtualProcessor@SchedulingNode@details@Concurrency@@QAEPAVVirtualProcessor@23@PAHH@Z 0040 ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 65 FC 00 6A FF EB 13 3B 45 10 74 0C 8D 48 08 E8 ?? ?? ?? ?? 85 C0 75 18 6A 00 8B 4D 0C 8D 45 FC 50 E8 ?? ?? ?? ?? 85 C0 75 DD 32 C0 C9 C2 0C 00 56 57 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 5F B0 01 5E EB E3 }
	condition:
		$1
}

rule file_253_43_0 {
	meta:
		name = "?StealForeignLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@@Z"
		size = 68
		refs = "001f ?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z 0031 ?GetNextSchedulingNode@SchedulerBase@details@Concurrency@@QAEPAVSchedulingNode@23@PAHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 56 8B F1 6A FF EB 18 3B 45 0C 74 11 6A 00 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 84 C0 75 19 6A 00 8B 4E 0C 8D 45 FC 50 E8 ?? ?? ?? ?? 85 C0 75 D8 32 C0 5E C9 C2 08 00 B0 01 EB F7 }
	condition:
		$1
}

rule file_253_44_0 {
	meta:
		name = "?GetLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVVirtualProcessor@23@_N@Z"
		size = 67
		refs = "0015 ?Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 001c ?GetLocalRunnableContext@VirtualProcessor@details@Concurrency@@AAEPAVInternalContextBase@23@XZ 002b ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 83 EC 0C 80 7D 10 00 74 0A 83 C1 08 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 85 C0 74 19 56 57 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 5F B0 01 5E EB 02 32 C0 C9 C2 0C 00 }
	condition:
		$1
}

rule file_253_45_0 {
	meta:
		name = "?SearchFair_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z"
		size = 108
		refs = "001c ?GetNextScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAHH@Z 005c ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 0C 8B 46 60 57 89 45 0C 6A FF 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B 7D 0C EB 19 8B 10 8B C8 FF 52 18 8B C8 85 C9 75 18 57 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 85 C0 75 E3 32 C0 5F 5E C9 C2 08 00 8B 7E 50 8B 45 0C 40 99 F7 FF 51 8D 4D F4 89 56 60 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 B0 01 EB D8 }
	condition:
		$1
}

rule file_253_46_0 {
	meta:
		name = "?SearchFair_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z"
		size = 117
		refs = "001d ?GetNextScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAHH@Z 0029 ?GetRealizedChore@ScheduleGroupBase@details@Concurrency@@IAEPAVRealizedChore@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B 75 0C 8B 46 60 57 89 45 0C 6A FF 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B 5D 0C EB 19 8B CF E8 ?? ?? ?? ?? 8B C8 85 C9 75 1B 53 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B F8 85 FF 75 E1 32 C0 5F 5E 5B C9 C2 08 00 8B 5E 50 8B 45 0C 40 99 F7 FB 89 7D F8 8B 7D 08 C7 45 F4 02 00 00 00 89 4D FC B0 01 89 56 60 8D 75 F4 A5 A5 A5 EB D2 }
	condition:
		$1
}

rule file_253_47_0 {
	meta:
		name = "?SearchFair_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z"
		size = 117
		refs = "001d ?GetNextScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAHH@Z 0029 ?StealUnrealizedChore@ScheduleGroupBase@details@Concurrency@@IAEPAV_UnrealizedChore@23@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B 75 0C 8B 46 60 57 89 45 0C 6A FF 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B 5D 0C EB 19 8B CF E8 ?? ?? ?? ?? 8B C8 85 C9 75 1B 53 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B F8 85 FF 75 E1 32 C0 5F 5E 5B C9 C2 08 00 8B 5E 50 8B 45 0C 40 99 F7 FB 89 7D F8 8B 7D 08 C7 45 F4 04 00 00 00 89 4D FC B0 01 89 56 60 8D 75 F4 A5 A5 A5 EB D2 }
	condition:
		$1
}

rule file_253_48_0 {
	meta:
		name = "?SearchFair@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
		size = 215
		refs = "0010 ?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z 0024 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@XZ 003c ?SearchFair_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z 0052 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@PBV423@PAV423@@Z 0068 ?StealForeignLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@@Z 0084 ?SearchFair_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z 00b2 ?SearchFair_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 FF 75 08 8B F1 32 DB E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 B2 00 00 00 8B 4E 0C 57 E8 ?? ?? ?? ?? F6 45 10 01 89 06 8B 3E 89 7D FC 74 3D EB 21 57 FF 75 08 E8 ?? ?? ?? ?? 8A D8 84 DB 0F 85 84 00 00 00 8B 4E 0C 57 FF 75 FC E8 ?? ?? ?? ?? 8B F8 8B CE 85 FF 75 D9 8B 46 08 FF 70 40 FF 75 08 E8 ?? ?? ?? ?? 8A D8 84 DB 75 5C F6 45 10 02 74 28 8B 7D FC EB 1F 57 FF 75 08 8B CE E8 ?? ?? ?? ?? 8A D8 84 DB 75 40 8B 4E 0C 57 FF 75 FC E8 ?? ?? ?? ?? 8B F8 85 FF 75 DD F6 45 10 04 74 28 8B 7D FC EB 1F 57 FF 75 08 8B CE E8 ?? ?? ?? ?? 8A D8 84 DB 75 12 8B 4E 0C 57 FF 75 FC E8 ?? ?? ?? ?? 8B F8 85 FF 75 DD 8A C3 5F 5E 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_253_49_0 {
	meta:
		name = "?SearchFairYield@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
		size = 228
		refs = "0010 ?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z 0024 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@XZ 0042 ?SearchFair_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z 0058 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@PBV423@PAV423@@Z 0079 ?SearchFair_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z 00ac ?SearchFair_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@@Z 00d5 ?StealForeignLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 FF 75 08 8B F1 32 DB E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 BF 00 00 00 8B 4E 0C 57 E8 ?? ?? ?? ?? F6 45 10 04 89 06 8B 3E 74 31 89 7D FC 85 FF 74 2A FF 75 FC 8B CE FF 75 08 E8 ?? ?? ?? ?? 8A D8 84 DB 0F 85 8B 00 00 00 FF 75 FC 8B 4E 0C 57 E8 ?? ?? ?? ?? 89 45 FC 85 C0 75 D6 F6 45 10 02 74 2D 89 7D FC 85 FF 74 26 FF 75 FC 8B CE FF 75 08 E8 ?? ?? ?? ?? 8A D8 84 DB 75 58 FF 75 FC 8B 4E 0C 57 E8 ?? ?? ?? ?? 89 45 FC 85 C0 75 DA F6 45 10 01 74 3F 89 7D 10 85 FF 74 26 FF 75 10 8B CE FF 75 08 E8 ?? ?? ?? ?? 8A D8 84 DB 75 25 FF 75 10 8B 4E 0C 57 E8 ?? ?? ?? ?? 89 45 10 85 C0 75 DA 8B 46 08 FF 70 40 8B CE FF 75 08 E8 ?? ?? ?? ?? 8A D8 8A C3 5F 5E 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_253_50_0 {
	meta:
		name = "?SearchCacheLocal_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupBase@23@@Z"
		size = 113
		refs = "001c ?GetNextScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAHH@Z 0061 ??0WorkItem@details@Concurrency@@QAE@PAVInternalContextBase@12@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 0C 8B 46 60 57 89 45 0C 6A FF 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B 7D 0C EB 1E 3B 45 10 74 0D 8B 10 8B C8 FF 52 18 8B C8 85 C9 75 18 57 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 85 C0 75 DE 32 C0 5F 5E C9 C2 0C 00 8B 7E 50 8B 45 0C 40 99 F7 FF 51 8D 4D F4 89 56 60 E8 ?? ?? ?? ?? 8B 7D 08 8B F0 A5 A5 A5 B0 01 EB D8 }
	condition:
		$1
}

rule file_253_51_0 {
	meta:
		name = "?SearchCacheLocal_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@1PAVScheduleGroupBase@23@@Z"
		size = 171
		refs = "001c ?GetRealizedChore@ScheduleGroupBase@details@Concurrency@@IAEPAVRealizedChore@23@XZ 004e ?GetNextScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 0C 57 3B 75 10 75 2C 8B 7D 14 85 FF 74 25 8B CF E8 ?? ?? ?? ?? 85 C0 74 1A 89 7D F8 8B 7D 08 89 45 FC C7 45 F4 02 00 00 00 8D 75 F4 A5 A5 A5 B0 01 EB 40 8B 46 60 53 89 45 0C 6A FF 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B 5D 0C EB 1E 3B 7D 14 74 0D 8B CF E8 ?? ?? ?? ?? 8B C8 85 C9 75 1B 53 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B F8 85 FF 75 DC 32 C0 5B 5F 5E C9 C2 10 00 8B 5E 50 8B 45 0C 40 99 F7 FB 89 7D F8 8B 7D 08 C7 45 F4 02 00 00 00 89 4D FC B0 01 89 56 60 8D 75 F4 A5 A5 A5 EB D2 }
	condition:
		$1
}

rule file_253_52_0 {
	meta:
		name = "?SearchCacheLocal_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@1PAVScheduleGroupBase@23@@Z"
		size = 171
		refs = "001c ?StealUnrealizedChore@ScheduleGroupBase@details@Concurrency@@IAEPAV_UnrealizedChore@23@XZ 004e ?GetNextScheduleGroup@SchedulingRing@details@Concurrency@@QAEPAVScheduleGroupBase@23@PAHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 0C 57 3B 75 10 75 2C 8B 7D 14 85 FF 74 25 8B CF E8 ?? ?? ?? ?? 85 C0 74 1A 89 7D F8 8B 7D 08 89 45 FC C7 45 F4 04 00 00 00 8D 75 F4 A5 A5 A5 B0 01 EB 40 8B 46 60 53 89 45 0C 6A FF 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B 5D 0C EB 1E 3B 7D 14 74 0D 8B CF E8 ?? ?? ?? ?? 8B C8 85 C9 75 1B 53 8D 45 0C 50 8B CE E8 ?? ?? ?? ?? 8B F8 85 FF 75 DC 32 C0 5B 5F 5E C9 C2 10 00 8B 5E 50 8B 45 0C 40 99 F7 FB 89 7D F8 8B 7D 08 C7 45 F4 04 00 00 00 89 4D FC B0 01 89 56 60 8D 75 F4 A5 A5 A5 EB D2 }
	condition:
		$1
}

rule file_253_53_0 {
	meta:
		name = "?SearchCacheLocal@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
		size = 508
		refs = "0018 ?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z 0043 ?LocalBiasStage@WorkSearchContext@details@Concurrency@@AAEHXZ 0073 ?GetLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVVirtualProcessor@23@_N@Z 0088 ?GetRunnableContext@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z 00a2 ?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z 00c2 ?DropRingBias@WorkSearchContext@details@Concurrency@@AAE_NXZ 00fb ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@PBV423@PAV423@@Z 012b ?UpdateRamblingState@VirtualProcessor@details@Concurrency@@QAEX_NPAVSchedulingRing@23@@Z 0153 ?SearchCacheLocal_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupBase@23@@Z 0172 ?SearchCacheLocal_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@1PAVScheduleGroupBase@23@@Z 018d ?SearchCacheLocal_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@1PAVScheduleGroupBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 33 DB 57 8B F1 88 5D FF FF 75 08 8B CE E8 ?? ?? ?? ?? 84 C0 0F 85 D1 01 00 00 8B 06 89 45 F8 3B C3 75 10 8B 46 08 8B 40 48 89 06 8B 06 89 46 04 89 45 F8 8B 7D F8 8B CE E8 ?? ?? ?? ?? 8B C8 8B 45 10 83 E0 01 89 4D EC 89 45 F0 74 57 83 F9 03 7D 52 83 F9 02 7D 1E 3B CB 0F 9F C0 0F B6 C0 50 FF 76 08 8B CE FF 75 08 E8 ?? ?? ?? ?? 84 C0 0F 85 6D 01 00 00 FF 75 0C 8B CE FF 75 08 E8 ?? ?? ?? ?? 84 C0 0F 85 58 01 00 00 8B 46 08 8B 48 40 50 51 FF 75 08 8B CE E8 ?? ?? ?? ?? 84 C0 0F 85 3E 01 00 00 83 7D EC 02 7E 05 89 5D F4 EB 06 8B 45 0C 89 45 F4 8B CE E8 ?? ?? ?? ?? 84 C0 74 41 8B 45 F8 8B 40 04 38 5E 20 74 17 FF 76 08 8B CE 50 FF 75 08 66 C7 46 20 00 01 E8 ?? ?? ?? ?? 88 45 FF 38 5D FF 75 17 FF 75 F8 8B 4E 0C FF 75 F8 E8 ?? ?? ?? ?? 8B F8 89 5E 14 66 89 5E 20 89 5E 10 38 5D FF 0F 84 B3 00 00 00 8B 46 04 FF 46 10 FF 46 14 8B 4E 08 3B C7 0F 95 C0 0F B6 C0 57 50 E8 ?? ?? ?? ?? 89 3E 38 5D FF 0F 84 D8 FE FF FF 8A 45 FF 5F 5E 5B C9 C2 0C 00 39 5D F0 74 16 FF 75 F4 8B CE 57 FF 75 08 E8 ?? ?? ?? ?? 84 C0 0F 85 8A 00 00 00 F6 45 10 02 74 15 FF 75 0C 8B CE FF 75 F8 57 FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 6F F6 45 10 04 74 15 FF 75 0C 8B CE FF 75 F8 57 FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 54 39 5D F0 74 15 FF 76 08 8B 47 04 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 84 C0 75 3A 8B 4E 0C 57 FF 75 F8 E8 ?? ?? ?? ?? 8B F8 89 5E 14 89 5E 10 66 89 5E 20 3B FB 0F 85 75 FF FF FF 89 1E 89 5E 14 89 5E 10 66 89 5E 20 39 5D EC 0F 85 2E FE FF FF E9 51 FF FF FF 89 5E 10 C6 45 FF 01 E9 1F FF FF FF B0 01 E9 41 FF FF FF }
	condition:
		$1
}

rule file_253_54_0 {
	meta:
		name = "?SearchCacheLocalYield@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
		size = 387
		refs = "0013 ?PreSearch@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@@Z 0045 ?DropRingBias@WorkSearchContext@details@Concurrency@@AAE_NXZ 0053 ?GetNextSchedulingRing@SchedulerBase@details@Concurrency@@QAEPAVSchedulingRing@23@PBV423@PAV423@@Z 007b ?LocalBiasStage@WorkSearchContext@details@Concurrency@@AAEHXZ 0095 ?SearchCacheLocal_Unrealized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@1PAVScheduleGroupBase@23@@Z 00b6 ?SearchCacheLocal_Realized@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@1PAVScheduleGroupBase@23@@Z 00d7 ?SearchCacheLocal_Runnables@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingRing@23@PAVScheduleGroupBase@23@@Z 00f5 ?StealLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVSchedulingNode@23@PAVVirtualProcessor@23@@Z 0115 ?GetRunnableContext@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z 0131 ?GetLocalRunnable@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVVirtualProcessor@23@_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 FF 75 08 8B F1 C6 45 FF 00 E8 ?? ?? ?? ?? 84 C0 74 07 B0 01 E9 4E 01 00 00 8B 06 89 45 F8 8B 06 85 C0 75 10 8B 46 08 8B 40 48 89 06 8B 06 89 46 04 89 45 F8 53 57 8B 7D F8 8B CE E8 ?? ?? ?? ?? 84 C0 74 1A 8B 4E 0C 57 57 E8 ?? ?? ?? ?? 83 66 14 00 83 66 10 00 8B F8 66 C7 46 20 00 00 85 FF 0F 84 EE 00 00 00 8B 45 10 83 E0 04 89 45 F0 8B CE E8 ?? ?? ?? ?? 83 7D F0 00 89 45 F4 74 19 FF 75 0C 8B CE FF 75 F8 57 FF 75 08 E8 ?? ?? ?? ?? 84 C0 0F 85 D4 00 00 00 8B 5D 10 F6 C3 02 74 19 FF 75 0C 8B CE FF 75 F8 57 FF 75 08 E8 ?? ?? ?? ?? 84 C0 0F 85 B3 00 00 00 83 7D F4 01 7D 1B F6 C3 01 74 16 FF 75 0C 8B CE 57 FF 75 08 E8 ?? ?? ?? ?? 84 C0 0F 85 92 00 00 00 83 E3 01 74 15 FF 76 08 8B 47 04 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 84 C0 75 78 3B 7D F8 75 37 85 DB 74 33 83 7D F4 02 7D 15 FF 75 0C 8B CE FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 58 83 7D F4 02 0F 9F C0 0F B6 C0 50 FF 76 08 8B CE FF 75 08 E8 ?? ?? ?? ?? 84 C0 75 3C 8B 4E 0C 57 FF 75 F8 E8 ?? ?? ?? ?? 83 66 14 00 83 66 10 00 8B F8 66 C7 46 20 00 00 85 FF 0F 85 1B FF FF FF 33 C0 89 06 89 46 14 89 46 10 66 89 46 20 8A 45 FF 5F 5B 5E C9 C2 0C 00 FF 46 10 FF 46 14 C6 45 FF 01 89 3E EB E8 }
	condition:
		$1
}

rule file_253_55_0 {
	meta:
		name = "?Reset@WorkSearchContext@details@Concurrency@@QAEXPAVVirtualProcessor@23@W4Algorithm@123@@Z"
		size = 73
		refs = "002a ?SearchFair@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z 0031 ?SearchFairYield@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z 003a ?SearchCacheLocal@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z 0041 ?SearchCacheLocalYield@WorkSearchContext@details@Concurrency@@AAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@K@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 89 01 89 41 10 89 41 14 66 89 41 20 8B 45 08 89 41 08 8B 40 40 8B 00 89 41 0C 8B 45 0C 48 74 10 C7 41 18 ?? ?? ?? ?? C7 41 1C ?? ?? ?? ?? EB 0E C7 41 18 ?? ?? ?? ?? C7 41 1C ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_254_2_0 {
	meta:
		name = "__wspawnvpe"
		size = 536
		refs = "0019 __errno 0024 __invalid_parameter_noinfo 007c __wspawnve 00a3 _wcschr 00b2 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 00bc __wdupenv_s 00d6 __invoke_watson 00ec __calloc_crt 0115 _wcslen 012c ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0133 _wcscat_s 01a4 ___doserrno 01d2 __wgetpath 01fd _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 0C 56 57 33 FF 33 F6 89 7D FC 3B C7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 E4 01 00 00 66 39 38 74 E3 53 8B 5D 10 3B DF 74 0B 8B 03 3B C7 74 05 66 39 38 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 B3 01 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 EC E8 ?? ?? ?? ?? FF 75 14 89 38 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 F8 FF 0F 85 55 01 00 00 E8 ?? ?? ?? ?? 83 38 02 0F 85 47 01 00 00 6A 2F FF 75 0C E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 33 01 00 00 68 ?? ?? ?? ?? 8D 45 FC 57 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 74 13 83 F8 16 0F 85 14 01 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 39 7D FC 0F 84 01 01 00 00 6A 02 BB 04 01 00 00 53 E8 ?? ?? ?? ?? 8B F0 59 59 3B F7 0F 84 E8 00 00 00 68 03 01 00 00 56 FF 75 FC E9 C7 00 00 00 66 39 3E 0F 84 D1 00 00 00 56 E8 ?? ?? ?? ?? 8D 44 46 FE 0F B7 00 59 83 F8 5C 74 18 83 F8 2F 74 13 68 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 92 56 E8 ?? ?? ?? ?? FF 75 0C 89 45 F0 E8 ?? ?? ?? ?? 59 59 8B 4D F0 03 C8 BB 04 01 00 00 3B CB 0F 83 81 00 00 00 FF 75 0C 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 58 FF FF FF E8 ?? ?? ?? ?? FF 75 14 89 38 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 F8 FF 75 4B E8 ?? ?? ?? ?? 83 38 02 74 25 E8 ?? ?? ?? ?? 83 38 15 74 1B 0F B7 06 83 F8 5C 74 05 83 F8 2F 75 2A 0F B7 46 02 83 F8 5C 74 05 83 F8 2F 75 1C 68 03 01 00 00 56 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 3B C7 0F 85 26 FF FF FF E8 ?? ?? ?? ?? 39 38 75 0A E8 ?? ?? ?? ?? 8B 4D EC 89 08 3B F7 74 07 56 E8 ?? ?? ?? ?? 59 39 7D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__ctime64_s"
		size = 148
		refs = "0009 ___security_cookie 0024 __errno 002e __invalid_parameter_noinfo 006d __localtime64_s 0080 _asctime_s 008e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 56 8B 75 08 85 F6 74 06 83 7D 0C 00 77 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 51 C6 06 00 85 C0 74 E6 8B 48 04 8B 10 85 C9 7F 12 7C 04 85 D2 73 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB DA 83 F9 07 7C 0A 7F ED 81 FA FF 6F 40 93 77 E5 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 10 8D 45 D8 50 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_256_1_0 {
	meta:
		name = "__ctime64"
		size = 109
		refs = "0009 ___security_cookie 001a __errno 0025 __invalid_parameter_noinfo 0031 @__security_check_cookie@4 0057 __localtime64_s 0066 _asctime"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 85 C0 75 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 83 78 04 00 7F 14 7C 05 83 38 00 73 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB D8 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 C8 8D 45 D8 50 E8 ?? ?? ?? ?? 59 EB BE }
	condition:
		$1
}

rule file_922_1_0 {
	meta:
		name = "__wctime64"
		size = 109
		refs = "0009 ___security_cookie 001a __errno 0025 __invalid_parameter_noinfo 0031 @__security_check_cookie@4 0057 __localtime64_s 0066 __wasctime"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 85 C0 75 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 83 78 04 00 7F 14 7C 05 83 38 00 73 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB D8 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 C8 8D 45 D8 50 E8 ?? ?? ?? ?? 59 EB BE }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "__d_inttype"
		size = 106
		refs = "0010 __fpclass 0023 __frnd 003b __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 59 59 A8 90 75 4C DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 45 08 59 DA E9 59 DF E0 F6 C4 44 7A 31 DD 45 08 51 DC 0D ?? ?? ?? ?? 51 DD 5D F8 DD 45 F8 DD 1C 24 E8 ?? ?? ?? ?? DD 45 F8 59 DA E9 59 DF E0 F6 C4 44 7A 05 6A 02 58 C9 C3 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_257_1_0 {
	meta:
		name = "__powhlp"
		size = 299
		refs = "0034 __d_inf 0091 __d_ind 00df __d_inttype 0117 __d_mzero"
	strings:
		$1 = { 8B FF 55 8B EC DD 45 08 56 B8 00 00 F0 7F D9 E1 33 D2 33 F6 B9 00 00 F0 FF 39 45 14 75 3A 39 55 10 75 7A D9 E8 D8 D1 DF E0 F6 C4 05 7A 0F DD D8 DD D8 DD 05 ?? ?? ?? ?? E9 E4 00 00 00 D8 D1 DF E0 DD D9 F6 C4 41 8B 45 18 0F 85 D5 00 00 00 DD D8 D9 EE E9 CC 00 00 00 39 4D 14 75 40 39 55 10 75 3B D9 E8 D8 D1 DF E0 F6 C4 05 7A 0B DD D8 DD D8 D9 EE E9 A9 00 00 00 DE D9 DF E0 F6 C4 41 8B 45 18 75 0B DD 05 ?? ?? ?? ?? E9 95 00 00 00 DD 05 ?? ?? ?? ?? 33 F6 46 E9 87 00 00 00 DD D8 39 45 0C 75 28 39 55 08 75 7D D9 EE DC 55 10 DF E0 F6 C4 05 0F 8B 77 FF FF FF DC 55 10 DF E0 F6 C4 41 8B 45 18 74 5E DD D8 D9 E8 EB 58 39 4D 0C 75 55 39 55 08 75 50 DD 45 10 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 EE 59 DC 55 10 59 8B C8 DF E0 F6 C4 05 7A 11 DD D8 DD 05 ?? ?? ?? ?? 83 F9 01 75 21 D9 E0 EB 1D DC 55 10 DF E0 F6 C4 41 75 0F 83 F9 01 75 0E DD D8 DD 05 ?? ?? ?? ?? EB 04 DD D8 D9 E8 8B 45 18 DD 18 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "_strcspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 73 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_259_2_0 {
	meta:
		name = "__wexecvpe"
		size = 510
		refs = "0017 __errno 0022 __invalid_parameter_noinfo 0065 __wexecve 007e _wcschr 00af ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 00b9 __wdupenv_s 00d3 __invoke_watson 00e9 __calloc_crt 0142 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0149 _wcscat_s 015a _wcslen 01d5 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 57 8B 7D 08 33 DB 89 5D FC 3B FB 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 C0 01 00 00 66 39 1F 74 E6 56 8B 75 0C 3B F3 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 9D 01 00 00 8B 06 3B C3 74 E5 66 39 18 74 E0 E8 ?? ?? ?? ?? FF 75 10 89 18 56 57 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 02 0F 85 62 01 00 00 6A 5C 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 50 01 00 00 6A 2F 57 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 3E 01 00 00 66 39 1F 74 0B 66 83 7F 02 3A 0F 84 2E 01 00 00 68 ?? ?? ?? ?? 8D 45 FC 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 13 83 F8 16 0F 85 0F 01 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 39 5D FC 0F 84 0A 01 00 00 6A 02 BB 04 01 00 00 53 E8 ?? ?? ?? ?? 8B F0 59 59 8B FE 85 F6 0F 84 DF 00 00 00 8B 4D FC EB 19 66 83 F8 3B 74 1E 8D 96 04 02 00 00 3B FA 73 14 66 89 07 83 C7 02 83 C1 02 0F B7 01 89 4D F8 66 85 C0 75 DC 33 C0 66 89 07 8D 47 FE 3B FE 77 02 8B C7 0F B7 00 8B FE 83 F8 5C 74 1C 83 F8 2F 74 17 68 ?? ?? ?? ?? 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 9A 00 00 00 56 E8 ?? ?? ?? ?? FF 75 08 89 45 F4 E8 ?? ?? ?? ?? 59 59 8B 4D F4 03 C8 BB 04 01 00 00 3B CB 73 5A FF 75 08 53 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 68 E8 ?? ?? ?? ?? FF 75 10 83 20 00 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 02 74 1B 0F B7 06 83 F8 5C 74 05 83 F8 2F 75 1B 0F B7 46 02 83 F8 5C 74 05 83 F8 2F 75 0D 8B 4D F8 66 83 39 00 0F 85 43 FF FF FF 56 E8 ?? ?? ?? ?? 59 33 DB 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 5E 5F 83 C8 FF 5B C9 C3 33 C0 50 50 50 50 50 E9 D4 FE FF FF }
	condition:
		$1
}

rule file_260_3_0 {
	meta:
		name = "___ascii_stricmp"
		size = 57
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C 56 8B 75 08 57 0F B6 06 8D 48 BF 46 83 F9 19 77 03 83 C0 20 0F B6 0A 8D 79 BF 42 83 FF 19 77 03 83 C1 20 85 C0 74 04 3B C1 74 DA 5F 2B C1 5E 5D C3 }
	condition:
		$1
}

rule file_260_4_0 {
	meta:
		name = "__stricmp_l"
		size = 192
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 0027 __invalid_parameter_noinfo 0076 ___ascii_stricmp 008b __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D 08 85 DB 75 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 7F 56 8B 75 0C 85 F6 75 24 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 52 8B 45 F0 83 78 14 00 75 0B 56 53 E8 ?? ?? ?? ?? 59 59 EB 31 2B DE 57 0F B6 04 33 8D 4D F0 51 50 E8 ?? ?? ?? ?? 8B F8 0F B6 06 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 10 46 85 FF 74 04 3B F8 74 D7 2B F8 8B C7 5F 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_260_5_0 {
	meta:
		name = "__stricmp"
		size = 71
		refs = "0009 ___locale_changed 0015 __errno 0020 __invalid_parameter_noinfo 0032 ___ascii_stricmp 003e __stricmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 75 27 39 45 08 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 39 45 0C 74 E4 5D E9 ?? ?? ?? ?? 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_814_4_0 {
	meta:
		name = "_wcscoll"
		size = 71
		refs = "0009 ___locale_changed 0015 __errno 0020 __invalid_parameter_noinfo 0032 _wcscmp 003e __wcscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 75 27 39 45 08 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF FF 7F 5D C3 39 45 0C 74 E4 5D E9 ?? ?? ?? ?? 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "_fgetc"
		size = 244
		refs = "0003 __sehtable$_fgetc 0008 __SEH_prolog4 0020 __errno 002b __invalid_parameter_noinfo 0039 __lock_file 0049 __fileno 0068 ___pioinfo 006f ___badioinfo 00cc __filbuf 00e4 __SEH_epilog4 00ee __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 08 3B F7 0F 95 C0 3B C7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 AC 00 00 00 56 E8 ?? ?? ?? ?? 59 89 7D FC F6 46 0C 40 75 6F 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1B 83 F8 FE 74 16 8B D0 C1 FA 05 8B C8 83 E1 1F C1 E1 06 03 0C 95 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 24 7F 75 29 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 4D E4 FF 39 7D E4 75 19 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 75 08 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_262_1_0 {
	meta:
		name = "_getc"
		size = 244
		refs = "0003 __sehtable$_getc 0008 __SEH_prolog4 0020 __errno 002b __invalid_parameter_noinfo 0039 __lock_file 0049 __fileno 0068 ___pioinfo 006f ___badioinfo 00cc __filbuf 00e4 __SEH_epilog4 00ee __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 08 3B F7 0F 95 C0 3B C7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 AC 00 00 00 56 E8 ?? ?? ?? ?? 59 89 7D FC F6 46 0C 40 75 6F 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1B 83 F8 FE 74 16 8B D0 C1 FA 05 8B C8 83 E1 1F C1 E1 06 03 0C 95 ?? ?? ?? ?? EB 05 B9 ?? ?? ?? ?? F6 41 24 7F 75 29 83 F8 FF 74 19 83 F8 FE 74 14 8B C8 C1 F9 05 83 E0 1F C1 E0 06 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 4D E4 FF 39 7D E4 75 19 FF 4E 04 78 0A 8B 0E 0F B6 01 41 89 0E EB 07 56 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 75 08 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_262_2_0 {
	meta:
		name = "__getc_nolock"
		size = 32
		refs = "0019 __filbuf"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 FF 4A 04 78 0A 8B 0A 0F B6 01 41 89 0A 5D C3 52 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsA"
		size = 151
		refs = "000c __imp__GetEnvironmentStringsW@0 0034 __imp__WideCharToMultiByte@32 0053 __malloc_crt 0075 _free 0080 __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 FF 15 ?? ?? ?? ?? 8B D8 33 F6 3B DE 75 04 33 C0 EB 77 66 39 33 74 10 83 C0 02 66 39 30 75 F8 83 C0 02 66 39 30 75 F0 57 8B 3D ?? ?? ?? ?? 56 56 56 2B C3 56 D1 F8 40 50 53 56 56 89 45 F4 FF D7 89 45 F8 3B C6 74 38 50 E8 ?? ?? ?? ?? 59 89 45 FC 3B C6 74 2A 56 56 FF 75 F8 50 FF 75 F4 53 56 56 FF D7 85 C0 75 0C FF 75 FC E8 ?? ?? ?? ?? 59 89 75 FC 53 FF 15 ?? ?? ?? ?? 8B 45 FC EB 09 53 FF 15 ?? ?? ?? ?? 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "_fp64_is_qnan"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C B8 00 00 F0 7F 23 C8 3B C8 75 0E F7 45 0C 00 00 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_1_0 {
	meta:
		name = "_fp64_is_snan"
		size = 52
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C B8 00 00 F0 7F 23 C8 3B C8 75 1D F7 45 0C 00 00 08 00 75 14 F7 45 0C FF FF 07 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_2_0 {
	meta:
		name = "_fp64_is_inf"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C B8 00 00 F0 7F 23 C8 3B C8 75 14 F7 45 0C FF FF 0F 00 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_3_0 {
	meta:
		name = "_fp64_is_zero"
		size = 29
		altNames = "_iszerod"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 0C FF FF FF 7F 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_4_0 {
	meta:
		name = "_fp64_is_denormal"
		size = 38
		altNames = "_isdenormald"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 0C 00 00 F0 7F 75 14 F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_5_0 {
	meta:
		name = "_RoundDoubleToIntegral"
		size = 536
		refs = "0014 _fp64_is_qnan 0025 _fp64_is_zero 0037 _fp64_is_inf 005f _fp64_is_denormal 00a2 __aullshr 00ad __allshl"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 0C 83 EC 1C 53 56 8B 75 10 57 56 52 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 E7 01 00 00 56 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 D5 01 00 00 56 52 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 C4 01 00 00 8B CE C1 E9 14 81 E1 FF 07 00 00 81 F9 33 04 00 00 0F 83 AD 01 00 00 56 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 25 01 00 00 81 F9 FF 03 00 00 0F 82 19 01 00 00 8D 99 01 FC FF FF 81 E6 FF FF 0F 00 0B F0 6A 34 33 FF 0B FA 59 81 CE 00 00 10 00 2B CB 8B C7 8B D6 89 5D FC 89 4D F8 E8 ?? ?? ?? ?? 8B 4D F8 89 45 E4 E8 ?? ?? ?? ?? 89 45 F4 89 55 F8 8B C7 8B D6 8D 4B 0C E8 ?? ?? ?? ?? 8D 4B 0C E8 ?? ?? ?? ?? 8B 4D 14 6A 00 8B DA 5A 8B F8 6A 01 0B C3 89 5D F0 58 74 04 89 01 EB 02 89 11 6A 33 59 39 4D FC 74 0A 2B 4D FC 33 D2 E8 ?? ?? ?? ?? 8B C8 8B F2 0F A4 CE 01 03 C9 83 7D 08 00 75 4A 39 55 F0 77 36 72 04 3B F8 73 32 8B 45 F4 8B 75 F8 8B 55 FC 8B 4D 10 81 C2 FF 03 00 00 C1 E2 14 81 E2 00 00 F0 7F 81 E6 FF FF 0F 00 0B D6 81 E1 00 00 00 80 0B D1 E9 D1 00 00 00 3B F8 75 2F 39 55 F0 75 2A F6 45 E4 01 EB 22 83 7D 08 01 75 0B F7 45 10 00 00 00 80 74 B2 EB 0F 83 7D 08 02 75 AA F7 45 10 00 00 00 80 75 A1 0B FB 74 9D 03 4D F4 13 75 F8 8B C1 85 C0 75 97 81 FE 00 00 20 00 75 8F FF 45 FC BE 00 00 10 00 EB 85 33 DB 33 C0 43 39 45 08 75 3E BF 00 00 00 80 85 F7 74 1F 81 F9 FE 03 00 00 75 13 F7 C6 FF FF 0F 00 75 04 3B D0 74 07 BA 00 00 F0 BF EB 41 8B D7 EB 3D 81 F9 FE 03 00 00 75 33 F7 C6 FF FF 0F 00 75 20 3B D0 74 27 EB 1A 39 5D 08 75 06 85 F6 79 1C EB D4 83 7D 08 02 BA 00 00 00 80 75 0B 85 F2 75 0D BA 00 00 F0 3F EB 06 85 F2 75 02 33 D2 8B 4D 14 89 19 EB 0A 8B 45 14 83 20 00 8B C2 8B D6 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_264_7_0 {
	meta:
		name = "_isinfd"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 25 FF FF FF 7F 3D 00 00 F8 7F 75 0B 83 7D 08 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_8_0 {
	meta:
		name = "_issnand"
		size = 44
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 25 00 00 F8 7F 3D 00 00 F0 7F 75 14 F7 45 0C FF FF 07 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_9_0 {
	meta:
		name = "_isnand"
		size = 43
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C B8 00 00 F0 7F 23 C8 3B C8 75 14 F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_10_0 {
	meta:
		name = "_quietd"
		size = 46
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F8 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 51 51 0D 00 00 08 00 89 4D F8 89 45 FC DD 45 F8 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_264_12_0 {
	meta:
		name = "_isdenormalf"
		size = 32
		altNames = "_fp32_is_denormal"
	strings:
		$1 = { 8B FF 55 8B EC F7 45 08 00 00 80 7F 75 0E F7 45 08 FF FF 7F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_264_13_0 {
	meta:
		name = "_Fill_FPIEEE_RECORD"
		size = 193
	strings:
		$1 = { 8B 48 20 8B 50 10 33 11 83 E2 03 31 11 8B 50 14 8B 48 20 C1 E2 02 33 11 83 E2 1C 31 11 8B 10 8B 48 20 C1 EA 05 F7 D2 33 51 08 83 E2 01 31 51 08 8B 10 8B 48 20 C1 EA 03 F7 D2 33 51 08 83 E2 02 31 51 08 8B 10 8B 48 20 D1 EA F7 D2 33 51 08 83 E2 04 31 51 08 8B 10 8B 48 20 03 D2 F7 D2 33 51 08 83 E2 08 31 51 08 8B 10 8B 48 20 C1 E2 04 F7 D2 33 51 08 83 E2 10 31 51 08 8B 48 20 83 61 0C FE 8B 48 20 83 61 0C FD 8B 48 20 83 61 0C FB 8B 48 20 83 61 0C F7 8B 48 20 83 61 0C EF 8B 48 20 83 61 04 FE 8B 48 20 83 61 04 FD 8B 48 20 83 61 04 FB 8B 48 20 83 61 04 F7 8B 40 20 83 60 04 EF C3 }
	condition:
		$1
}

rule file_264_14_0 {
	meta:
		name = "_XMMI2_FP_Emulation"
		size = 5872
		refs = "001e ___security_cookie 007f $LN367 0086 $LN475 00ac _isdenormald 00ec $LN476 015e __control87 0208 __statusfp 0229 _Fill_FPIEEE_RECORD 024b _isnand 031f _MIN_DOUBLE_NORMALA 0325 _memcpy 032e _MAX_DOUBLE_NORMALA 033d _POSINFDEA 034c _NEGINFDEA 035b _TWO_TO_1536A 036a _TWO_TO_M1536A 05ef _ZERODA 0601 _NZERODA 07a5 $LN368 07ac $LN477 07b7 _issnand 08bb $LN369 08c2 $LN478 08fe $LN370 0905 $LN479 0c2a _isdenormalf 0fa7 _MIN_SINGLE_NORMALA 0fd9 _MAX_SINGLE_NORMALA 10d2 _ZEROFA 10e4 _NZEROFA 1486 _fp64_is_qnan 14c3 _fp64_is_snan 1520 _fp64_is_denormal 159f _RoundDoubleToIntegral 1641 @__security_check_cookie@4 164c $LN351 1650 $LN40 1654 $LN74 1658 $LN276 165c $LN225 1660 $LN157 1664 $LN131 1668 $LN116 166c $LN194 1670 $LN183 1674 $LN21 1678 $LN1 16a0 $LN345 16a8 $LN344 16b0 $LN343 16b8 $LN342 16c0 $LN270 16c4 $LN265 16d0 $LN228 16d4 $LN229"
	strings:
		$1 = { 8B FF 53 8B DC 51 51 83 E4 F8 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC A8 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 73 08 33 D2 57 89 55 88 DB E3 8B 46 20 8B 08 33 4E 10 89 95 6C FF FF FF 83 E1 03 31 08 8B 4E 14 8B 46 20 C1 E1 02 33 08 89 95 5C FF FF FF 83 E1 1C 31 08 8B 4E 20 8B 39 C1 EF 05 81 E7 FF 0F 00 00 8D 47 B7 89 85 58 FF FF FF 83 F8 23 0F 87 BB 15 00 00 0F B6 80 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 41 10 8B 79 14 89 45 90 8B 41 30 89 45 98 8B 41 34 89 7D 94 89 45 9C 39 56 0C 74 37 57 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 BA 00 00 00 80 85 C0 74 09 23 FA 83 65 90 00 89 7D 94 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 07 21 55 9C 83 65 98 00 8B 85 58 FF FF FF 83 F8 07 77 39 FF 24 85 ?? ?? ?? ?? 8B 01 25 3F 00 FE FF 83 C8 20 EB 24 8B 01 25 5F 00 FE FF 83 C8 40 EB 18 8B 01 25 7F 00 FE FF 83 C8 60 EB 0C 8B 01 25 9F 00 FE FF 0D 80 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 18 B8 00 02 00 00 EB 11 B8 00 01 00 00 EB 0A 33 C0 EB 06 8B 85 5C FF FF FF 0D 1F 00 09 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 59 59 74 73 48 74 4E 48 74 29 48 0F 85 86 00 00 00 DB E2 DD 45 90 DD 45 98 DE F9 DD 9D 78 FF FF FF DB E2 DD 45 90 DD 45 98 DE F9 DB BD 60 FF FF FF EB 64 DB E2 DD 45 90 DD 45 98 DE C9 DD 9D 78 FF FF FF DB E2 DD 45 90 DD 45 98 DE C9 DB BD 60 FF FF FF EB 42 DB E2 DD 45 90 DD 45 98 DE E9 DD 9D 78 FF FF FF DB E2 DD 45 90 DD 45 98 DE E9 DB BD 60 FF FF FF EB 20 DB E2 DD 45 90 DD 45 98 DE C1 DD 9D 78 FF FF FF DB E2 DD 45 90 DD 45 98 DE C1 DB BD 60 FF FF FF E8 ?? ?? ?? ?? 89 45 88 A8 08 74 07 81 65 88 FF FF F7 FF 8B 06 A8 01 75 26 F6 45 88 10 74 20 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 33 C0 40 09 46 04 8B 76 20 83 4E 04 10 E9 F3 13 00 00 57 FF 75 90 E8 ?? ?? ?? ?? 8B D0 59 59 85 D2 0F 85 79 04 00 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 64 04 00 00 8B 06 BF 00 00 08 00 A8 02 75 18 85 7D 88 74 13 8B C6 E8 ?? ?? ?? ?? 83 4E 04 02 33 C0 40 E9 A6 13 00 00 A8 04 75 21 F6 45 88 08 74 1B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 08 83 4E 04 04 8B 76 20 83 4E 04 08 EB D3 DD 85 78 FF FF FF DD 5D 80 FF 75 84 FF 75 80 E8 ?? ?? ?? ?? 59 59 85 C0 74 3C 8B 46 20 83 48 60 01 DD 45 80 8B 46 20 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 8B 46 20 83 48 0C 10 83 4E 04 01 E9 29 13 00 00 85 7D 88 74 04 83 4E 04 02 6A 0A 5F 57 8D 45 E4 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 F0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 B4 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 D8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 CC 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 57 8D 45 C0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 48 DB AD 60 FF FF FF DB 6D E4 D9 E0 DE D9 9B DD 7D B0 D9 EE DB AD 60 FF FF FF DE D9 9B DD 7D A4 DB AD 60 FF FF FF D9 EE DE D9 9B DD 7D AC DB 6D E4 DB AD 60 FF FF FF DE D9 9B DD 7D A8 0F B7 45 B0 B9 00 45 00 00 23 C1 BA 00 01 00 00 66 3B C2 75 0B 0F B7 45 A4 23 C1 66 3B C2 74 16 0F B7 45 AC 23 C1 66 3B C2 75 15 0F B7 45 A8 23 C1 66 3B C2 75 0A C7 85 6C FF FF FF 01 00 00 00 DB AD 60 FF FF FF DB 6D D8 DE D9 9B DD 7D B0 DB 6D F0 D9 E0 DB AD 60 FF FF FF DE D9 9B DD 7D A4 DB AD 60 FF FF FF DB 6D F0 DE D9 9B DD 7D AC DB 6D B4 DB AD 60 FF FF FF DE D9 9B DD 7D A8 0F B7 45 B0 23 C1 66 3B C2 75 0B 0F B7 45 A4 23 C1 66 3B C2 74 16 0F B7 45 AC 23 C1 66 3B C2 75 15 0F B7 45 A8 23 C1 66 3B C2 75 0A C7 85 5C FF FF FF 01 00 00 00 8B 06 33 FF A8 10 75 5F 39 BD 6C FF FF FF 74 57 DB AD 60 FF FF FF DB 6D CC DE C9 DD 9D 78 FF FF FF 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 02 8B 46 20 83 4E 04 10 83 48 04 02 8B 4E 20 33 C0 40 09 41 60 DD 85 78 FF FF FF 8B 4E 20 DD 59 50 84 45 88 0F 84 7A 11 00 00 8B 4E 20 09 41 0C 83 4E 04 20 E9 6B 11 00 00 A8 08 75 34 39 BD 5C FF FF FF 74 2C DB AD 60 FF FF FF DB 6D C0 DE C9 DD 9D 78 FF FF FF 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 EB 9B 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 74 30 48 74 20 48 74 10 48 75 32 DD 45 90 DD 45 98 DE F9 DD 5D 80 EB 25 DD 45 90 DD 45 98 DE C9 DD 5D 80 EB 18 DD 45 90 DD 45 98 DE E9 DD 5D 80 EB 0B DD 45 90 DD 45 98 DE C1 DD 5D 80 E8 ?? ?? ?? ?? 33 C9 8B D0 41 84 D1 74 0B 39 BD 6C FF FF FF 74 03 83 CA 02 F6 06 20 0F 85 A5 00 00 00 84 D1 75 15 39 7E 08 0F 84 98 00 00 00 39 BD 6C FF FF FF 0F 84 8C 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 33 C9 41 09 48 0C 8B 46 20 83 4E 04 20 09 48 04 8B 46 20 09 48 60 39 BD 6C FF FF FF 74 0B 8B 46 20 83 48 0C 02 83 4E 04 10 39 BD 5C FF FF FF 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 7E 08 74 31 39 BD 6C FF FF FF 74 29 D9 EE DC 55 80 DF E0 F6 C4 05 7A 0A DD D8 DD 05 ?? ?? ?? ?? EB 10 DC 5D 80 DF E0 F6 C4 41 75 09 DD 05 ?? ?? ?? ?? DD 5D 80 8B 46 20 DD 45 80 DD 58 50 8B C1 E9 21 10 00 00 8B 46 20 09 48 60 8B 46 20 F6 C2 02 74 0A 83 48 0C 02 83 4E 04 10 EB 04 83 60 0C FD 8B 46 20 F6 C2 04 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 8B 46 20 84 D1 74 09 09 48 0C 83 4E 04 20 EB 04 83 60 0C FE 39 7E 08 74 46 39 BD 6C FF FF FF 74 3E D9 EE DC 55 80 DF E0 F6 C4 05 7A 0A DD D8 DD 05 ?? ?? ?? ?? EB 10 DC 5D 80 DF E0 F6 C4 41 75 09 DD 05 ?? ?? ?? ?? DD 5D 80 8B 46 20 09 48 0C 83 4E 04 20 8B 46 20 83 48 0C 02 83 4E 04 10 8B 46 20 DD 45 80 DD 58 50 8B 46 20 F6 C2 08 74 0A 83 48 0C 08 83 4E 04 04 EB 04 83 60 0C F7 8B 76 20 83 66 0C EF E9 63 0F 00 00 8B 46 20 83 48 60 01 85 D2 74 25 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 74 14 8B 45 90 81 CF 00 00 08 00 89 45 98 89 7D 9C DD 45 98 EB 06 DD 85 78 FF FF FF 8B 46 20 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 45 88 10 74 96 E9 C7 FB FF FF 8B 79 14 8B 41 10 89 7D 94 8B 79 30 89 7D 98 8B 79 34 89 45 90 89 7D 9C 39 56 0C 74 35 FF 75 94 50 E8 ?? ?? ?? ?? 83 C4 08 BA 00 00 00 80 85 C0 74 07 21 55 94 83 65 90 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 07 21 55 9C 83 65 98 00 8B 01 8B 7E 18 25 FF 00 FE FF 83 E7 07 0D E0 00 00 00 89 01 83 FF 07 77 57 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 1A FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 08 21 85 6C FF FF FF EB 0A C7 85 6C FF FF FF 01 00 00 00 E8 ?? ?? ?? ?? A8 10 74 0A C7 85 6C FF FF FF 01 00 00 00 33 D2 39 95 6C FF FF FF 74 09 F6 06 01 0F 84 1A FA FF FF FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 1B 01 00 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 06 01 00 00 FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 4C 83 4E 04 02 F6 06 02 75 43 8B C6 E8 ?? ?? ?? ?? E9 1C FA FF FF FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 6B FF FF FF FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 56 FF FF FF 21 85 6C FF FF FF 33 D2 E9 66 FF FF FF DD 45 98 DC 5D 90 DF E0 F6 C4 41 75 13 83 FF 07 77 57 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? DD 45 98 DC 5D 90 DF E0 F6 C4 05 7A 14 83 FF 03 76 31 83 FF 07 77 32 83 4D 98 FF 83 4D 9C FF EB 28 DD 45 90 DD 45 98 DA E9 DF E0 F6 C4 44 7A 19 83 FF 07 77 14 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 89 55 98 89 55 9C 8B 46 20 DD 45 98 83 48 60 01 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 E9 88 FD FF FF 83 FF 02 76 0A 83 FF 06 76 42 83 FF 07 75 06 89 55 98 89 55 9C 8B 46 20 DD 45 98 83 48 60 01 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 39 95 6C FF FF FF E9 A8 FD FF FF 83 4D 98 FF 83 4D 9C FF EB BF 8B 41 10 89 45 90 8B 41 14 89 45 94 8B 41 30 89 45 98 8B 41 34 89 45 9C 39 56 0C 74 37 FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 BA 00 00 00 80 85 C0 74 07 21 55 94 83 65 90 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 07 21 55 9C 83 65 98 00 83 EF 59 74 38 4F 75 5B FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 03 33 FF 47 E8 ?? ?? ?? ?? A8 10 74 31 33 FF 47 EB 2C FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 75 EA FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 75 D9 33 FF EB 06 8B BD 6C FF FF FF 8B 46 20 8B 08 81 E1 FF 00 FE FF 81 C9 E0 00 00 00 89 08 85 FF 74 09 F6 06 01 0F 84 B7 F7 FF FF FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 9F 00 00 00 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 8A 00 00 00 FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 12 FF 75 9C FF 75 98 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 99 FD FF FF DD 45 98 DC 5D 90 DF E0 F6 C4 05 7A 0C 81 66 1C 2A F7 FF FF E9 3C FE FF FF DD 45 98 DC 5D 90 DF E0 F6 C4 41 75 0D 8B 46 1C 25 2B F7 FF FF 83 C8 01 EB 1E DD 45 90 DD 45 98 DA E9 DF E0 F6 C4 44 0F 8A 0F FE FF FF 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C E9 FC FD FF FF 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 85 FF E9 DC FB FF FF 8B 41 10 89 85 58 FF FF FF 8B 46 10 2B C2 74 24 48 74 14 48 74 0A 48 75 15 BA 00 03 00 00 EB 14 BA 00 02 00 00 EB 0D BA 00 01 00 00 EB 06 8B 95 5C FF FF FF 81 CA 1F 00 0A 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 DB 85 58 FF FF FF D9 5D A0 E8 ?? ?? ?? ?? F6 06 20 75 45 A8 01 74 41 8B C6 E8 ?? ?? ?? ?? 8B 46 20 8B 08 81 E1 1F 01 FE FF 81 C9 00 01 00 00 89 08 8B 4E 20 33 C0 40 09 41 0C 8B 4E 20 83 4E 04 20 09 41 04 8B 4E 20 09 41 60 D9 45 A0 8B 4E 20 D9 59 50 E9 44 0A 00 00 8B 4E 20 83 49 60 01 D9 45 A0 8B 4E 20 D9 59 50 A8 01 8B 46 20 0F 84 12 FD FF FF 83 48 0C 01 83 4E 04 20 E9 09 FD FF FF 8B 41 10 89 45 88 39 56 0C 74 14 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 81 65 88 00 00 00 80 8B C7 83 E8 64 BF 00 01 00 00 74 0E 48 75 19 8B 01 25 1F 01 FE FF 0B C7 EB 0C 8B 01 25 5F 05 FE FF 0D 40 05 00 00 89 01 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 83 F8 08 74 05 83 F8 2A EB 0E 8B 46 10 2B C2 74 21 48 74 14 48 74 0A 48 75 12 BA 00 03 00 00 EB 11 BA 00 02 00 00 EB 0A 8B D7 EB 06 8B 95 5C FF FF FF 81 CA 1F 00 0A 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 88 DB 5D 8C E8 ?? ?? ?? ?? 33 D2 42 84 16 75 08 A8 10 0F 85 54 F5 FF FF 8B 4E 20 8B 7D 8C 89 79 50 F6 06 20 75 29 84 C2 74 25 8B C6 E8 ?? ?? ?? ?? 8B 4E 20 33 C0 40 09 41 0C 8B 4E 20 83 4E 04 20 09 41 04 8B 76 20 09 46 60 E9 30 09 00 00 8B 4E 20 09 51 60 8B 4E 20 84 C2 74 09 09 51 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 0F 84 88 F9 FF FF 8B 46 20 83 48 0C 10 09 56 04 E9 E8 08 00 00 8B 41 10 89 45 90 8B 41 14 89 45 94 39 56 0C 74 1A 50 FF 75 90 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0A 81 65 94 00 00 00 80 89 55 90 B8 00 01 00 00 83 FF 5B 72 20 83 FF 5C 76 0F 83 FF 5E 76 2E 83 FF 66 74 29 83 FF 67 75 0C 8B 39 81 E7 1F 01 FE FF 0B F8 89 39 8B 4E 20 8B 09 C1 E9 05 81 E1 FF 0F 00 00 83 F9 08 74 15 83 F9 2A EB 1E 8B 39 81 E7 5F 05 FE FF 81 CF 40 05 00 00 EB D6 8B 4E 10 2B CA 74 21 49 74 14 49 74 0A 49 75 12 BA 00 03 00 00 EB 11 BA 00 02 00 00 EB 0A 8B D0 EB 06 8B 95 5C FF FF FF 81 CA 1F 00 09 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 DD 45 90 DB 5D 8C E9 AA FE FF FF 8B 41 10 89 45 88 39 56 0C 74 14 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 81 65 88 00 00 00 80 8B 01 25 1F 01 FE FF 0D 00 01 00 00 89 01 DB E2 D9 45 88 DD 5D 80 E8 ?? ?? ?? ?? 8B 0E F6 C1 01 75 08 A8 10 0F 85 C9 F3 FF FF 8B D0 81 E2 00 00 08 00 74 04 83 4E 04 02 F6 C1 02 75 08 85 D2 0F 85 EB F9 FF FF 8B 4E 20 DD 45 80 DD 59 50 8B 4E 20 83 49 60 01 8B 4E 20 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 E9 85 F8 FF FF 8B 41 10 8B 79 14 89 45 90 89 7D 94 39 56 0C 74 18 57 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0A 81 65 94 00 00 00 80 89 55 90 8B 01 25 1F 01 FE FF BF 00 01 00 00 0B C7 89 01 8B 46 10 2B C2 74 21 48 74 14 48 74 0A 48 75 12 BA 00 03 00 00 EB 11 BA 00 02 00 00 EB 0A 8B D7 EB 06 8B 95 5C FF FF FF 81 CA 1F 00 0A 00 68 1F 03 0B 00 52 E8 ?? ?? ?? ?? 59 59 DB E2 DD 45 90 D9 5D A0 E8 ?? ?? ?? ?? 33 D2 8B C8 8B 06 42 89 4D 88 84 C2 75 09 F6 C1 10 0F 85 E3 F2 FF FF 81 E1 00 00 08 00 74 04 83 4E 04 02 A8 02 75 08 85 C9 0F 85 08 F9 FF FF FF 75 94 FF 75 90 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 2B 02 00 00 8B 45 94 25 FF FF FF 7F 3D 00 00 F8 7F 75 0A 83 7D 90 00 0F 84 12 02 00 00 85 C0 75 09 39 45 90 0F 84 05 02 00 00 DB E2 DD 45 90 D9 E8 DE C9 DD 9D 70 FF FF FF DD 05 ?? ?? ?? ?? D9 C0 D9 E0 DD 85 70 FF FF FF D8 D1 DF E0 DD D9 F6 C4 41 75 0F D8 D1 DF E0 DD D9 F6 C4 05 7A 06 8B FA EB 08 DD D9 8B BD 6C FF FF FF DD 05 ?? ?? ?? ?? D9 C0 D9 E0 D8 DA DF E0 F6 C4 41 74 0B DE D9 DF E0 F6 C4 05 7A 0C EB 04 DD D8 DD D8 89 95 5C FF FF FF 8B }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_wcspbrk"
		size = 68
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 0F B7 10 53 56 57 66 85 D2 74 2A 8B 5D 0C 0F B7 3B 8B F3 66 85 FF 74 12 8B CF 66 3B CA 74 18 83 C6 02 0F B7 0E 66 85 C9 75 F0 83 C0 02 0F B7 10 66 85 D2 75 DC 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
		size = 50
	strings:
		$1 = { 8B FF 55 8B EC 51 53 8B 45 0C 83 C0 0C 89 45 FC 64 8B 1D 00 00 00 00 8B 03 64 A3 00 00 00 00 8B 45 08 8B 5D 0C 8B 6D FC 8B 63 FC FF E0 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_266_4_0 {
	meta:
		name = "?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z"
		size = 84
		refs = "0017 $ReturnPoint$27112 0027 _RtlUnwind@16"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 57 64 8B 35 00 00 00 00 89 75 FC C7 45 F8 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 F8 FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 8B 40 04 83 E0 FD 8B 4D 0C 89 41 04 64 8B 3D 00 00 00 00 8B 5D FC 89 3B 64 89 1D 00 00 00 00 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_266_5_0 {
	meta:
		name = "___CxxFrameHandler"
		size = 54
		refs = "0022 ___InternalCxxFrameHandler"
		altNames = "___CxxFrameHandler2 ___CxxFrameHandler3"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 FC 89 45 FC 33 C0 50 50 50 FF 75 FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 5F 5E 5B 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_266_8_0 {
	meta:
		name = "___CxxLongjmpUnwind@4"
		size = 31
		refs = "0014 ___FrameUnwindToState"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 70 1C FF 70 28 6A 00 FF 70 18 E8 ?? ?? ?? ?? 83 C4 10 5D C2 04 00 }
	condition:
		$1
}

rule file_266_9_0 {
	meta:
		name = "?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z"
		size = 51
		refs = "0010 @__security_check_cookie@4 0029 ___InternalCxxFrameHandler"
	strings:
		$1 = { 8B FF 55 8B EC 56 FC 8B 75 0C 8B 4E 08 33 CE E8 ?? ?? ?? ?? 6A 00 56 FF 76 14 FF 76 0C 6A 00 FF 75 10 FF 76 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 5E 5D C3 }
	condition:
		$1
}

rule file_266_10_0 {
	meta:
		name = "?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
		size = 215
		refs = "0013 $ExceptionContinuation$27230 002b ?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z 0030 ___security_cookie 008c __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 53 81 7D 08 23 01 00 00 75 12 B8 ?? ?? ?? ?? 8B 4D 0C 89 01 33 C0 40 E9 B0 00 00 00 83 65 D8 00 C7 45 DC ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 4D D8 33 C1 89 45 E0 8B 45 18 89 45 E4 8B 45 0C 89 45 E8 8B 45 1C 89 45 EC 8B 45 20 89 45 F0 83 65 F4 00 83 65 F8 00 83 65 FC 00 89 65 F4 89 6D F8 64 A1 00 00 00 00 89 45 D8 8D 45 D8 64 A3 00 00 00 00 C7 45 C8 01 00 00 00 8B 45 08 89 45 CC 8B 45 10 89 45 D0 E8 ?? ?? ?? ?? 8B 80 80 00 00 00 89 45 D4 8D 45 CC 50 8B 45 08 FF 30 FF 55 D4 59 59 83 65 C8 00 83 7D FC 00 74 17 64 8B 1D 00 00 00 00 8B 03 8B 5D D8 89 03 64 89 1D 00 00 00 00 EB 09 8B 45 D8 64 A3 00 00 00 00 8B 45 C8 5B C9 C3 }
	condition:
		$1
}

rule file_266_11_0 {
	meta:
		name = "?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z"
		size = 159
		refs = "0012 @__security_check_cookie@4 0055 ___InternalCxxFrameHandler 006c ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0084 ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 FC 8B 45 0C 8B 48 08 33 4D 0C E8 ?? ?? ?? ?? 8B 45 08 8B 40 04 83 E0 66 74 11 8B 45 0C C7 40 24 01 00 00 00 33 C0 40 EB 6C EB 6A 6A 01 8B 45 0C FF 70 18 8B 45 0C FF 70 14 8B 45 0C FF 70 0C 6A 00 FF 75 10 8B 45 0C FF 70 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 8B 45 0C 83 78 24 00 75 0B FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 8D 45 FC 50 68 23 01 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 FC 8B 5D 0C 8B 63 1C 8B 6B 20 FF E0 33 C0 40 5B C9 C3 }
	condition:
		$1
}

rule file_266_12_0 {
	meta:
		name = "?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z"
		size = 115
		refs = "001f ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 57 8B 7D 08 8B 47 10 8B 77 0C 89 45 FC 8B DE EB 2B 83 FE FF 75 05 E8 ?? ?? ?? ?? 8B 4D 10 4E 8B C6 6B C0 14 03 45 FC 39 48 04 7D 05 3B 48 08 7E 05 83 FE FF 75 09 FF 4D 0C 8B 5D 08 89 75 08 83 7D 0C 00 7D CC 8B 45 14 46 89 30 8B 45 18 89 18 3B 5F 0C 77 04 3B F3 76 05 E8 ?? ?? ?? ?? 8B C6 6B C0 14 03 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_266_13_0 {
	meta:
		name = "__CreateFrameInfo"
		size = 44
		refs = "000f __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 56 8B 75 08 89 06 E8 ?? ?? ?? ?? 8B 80 98 00 00 00 89 46 04 E8 ?? ?? ?? ?? 89 B0 98 00 00 00 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_266_14_0 {
	meta:
		name = "__IsExceptionObjectToBeDestroyed"
		size = 39
		refs = "0006 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 8B 80 98 00 00 00 EB 0A 8B 08 3B 4D 08 74 0A 8B 40 04 85 C0 75 F2 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_266_15_0 {
	meta:
		name = "__FindAndUnlinkFrame"
		size = 82
		refs = "0007 __getptd 0046 ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B 75 08 3B B0 98 00 00 00 75 11 E8 ?? ?? ?? ?? 8B 4E 04 89 88 98 00 00 00 5E 5D C3 E8 ?? ?? ?? ?? 8B 80 98 00 00 00 EB 09 8B 48 04 3B F1 74 0F 8B C1 83 78 04 00 75 F1 5E 5D E9 ?? ?? ?? ?? 8B 4E 04 89 48 04 EB D2 }
	condition:
		$1
}

rule file_266_16_0 {
	meta:
		name = "?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 96
		refs = "0009 ___security_cookie 0029 ?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z 004d __CallSettingFrame@12"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 83 65 E8 00 8D 4D E8 33 C1 8B 4D 08 89 45 F0 8B 45 0C 89 45 F4 8B 45 14 40 C7 45 EC ?? ?? ?? ?? 89 4D F8 89 45 FC 64 A1 00 00 00 00 89 45 E8 8D 45 E8 64 A3 00 00 00 00 FF 75 18 51 FF 75 10 E8 ?? ?? ?? ?? 8B C8 8B 45 E8 64 A3 00 00 00 00 8B C1 C9 C3 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "__purecall"
		size = 42
		refs = "0002 ___pPurecall 0008 __imp__DecodePointer@4 0015 __NMSG_WRITE 001e __set_abort_behavior 0026 _abort"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 02 FF D0 6A 19 E8 ?? ?? ?? ?? 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 0C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_1_0 {
	meta:
		name = "__set_purecall_handler"
		size = 39
		refs = "0008 ___pPurecall 000e __imp__DecodePointer@4 0019 __imp__EncodePointer@4"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 75 08 8B F0 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_833_5_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 39
		refs = "0008 ?__pInconsistency@@3P6AXXZA 000e __imp__DecodePointer@4 0019 __imp__EncodePointer@4"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 75 08 8B F0 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_699_2_0 {
	meta:
		name = "__set_invalid_parameter_handler"
		size = 39
		refs = "0008 ___pInvalidArgHandler 000e __imp__DecodePointer@4 0019 __imp__EncodePointer@4"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 75 08 8B F0 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_269_3_0 {
	meta:
		name = "?Enqueue@?$SQueue@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 8D 82 C8 00 00 00 83 20 00 56 8B 71 04 89 16 89 41 04 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_269_4_0 {
	meta:
		name = "?Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 51
		refs = "000d ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ 0029 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 57 8D 4E 08 E8 ?? ?? ?? ?? 8B 4D 08 8D 81 C8 00 00 00 83 20 00 8B 56 04 89 0A 8D 4E 08 89 46 04 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_269_5_0 {
	meta:
		name = "?AddToRunnablesCollection@FairScheduleGroup@details@Concurrency@@EAEXPAVInternalContextBase@23@@Z"
		size = 17
		refs = "000d ?Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		altNames = "?AddToRunnablesCollection@CacheLocalScheduleGroup@details@Concurrency@@EAEXPAVInternalContextBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 81 C1 D0 00 00 00 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "_wcsrchr"
		size = 46
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B D0 66 8B 08 83 C0 02 66 85 C9 75 F5 66 8B 4D 0C 83 E8 02 3B C2 74 05 66 39 08 75 F4 66 39 08 74 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "_wmemcpy"
		size = 27
		refs = "0012 _memcpy"
		altNames = "?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_71_303_1 {
	meta:
		name = "?move@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
		size = 27
		refs = "0012 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_71_222_1 {
	meta:
		name = "?move@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 27
		refs = "0012 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "_wmemmove"
		size = 27
		refs = "0012 _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_272_1_0 {
	meta:
		name = "_wmemset"
		size = 44
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 10 85 C9 74 1B 8B 45 0C 0F B7 D0 8B C2 C1 E2 10 57 8B 7D 08 0B C2 D1 E9 F3 AB 13 C9 66 F3 AB 5F 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_272_2_0 {
	meta:
		name = "_wmemcpy_s"
		size = 120
		refs = "0018 __errno 0022 __invalid_parameter_noinfo 0040 _memcpy 0052 _wmemset"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 14 85 F6 75 04 33 C0 EB 64 83 7D 08 00 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 4B 83 7D 10 00 74 19 39 75 0C 72 14 8D 04 36 50 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB C4 FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 10 00 74 B8 39 75 0C 73 0E E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB AF 6A 16 58 5E 5D C3 }
	condition:
		$1
}

rule file_273_2_0 {
	meta:
		name = "__wstat32i64"
		size = 1060
		refs = "000c ___security_cookie 002b ___doserrno 0032 __errno 003d __invalid_parameter_noinfo 004b ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0051 _wcspbrk 0088 _towlower 0096 __getdrive 00ae __imp__FindFirstFileExW@24 00c2 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00ed __wfullpath_helper 00fc _wcslen 0107 _IsRootUNCName 0112 __imp__GetDriveTypeW@4 012a _free 015d ___loctotime32_t 01c1 __wsopen_s 01e5 __fstat32i64 01f2 __close 0225 __imp__FileTimeToLocalFileTime@8 0241 __imp__FileTimeToSystemTime@8 03a6 __imp__FindClose@4 03b2 ___wdtoxmode 03fb __imp__GetLastError@0 0401 __dosmaperr 041e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 8C FB FF FF 3B F3 75 1C E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 CC 03 00 00 3B FB 74 E0 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 A1 03 00 00 66 83 7E 02 3A 75 1D 0F B7 06 66 3B C3 74 06 66 39 5E 04 74 D5 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 53 53 53 89 85 84 FB FF FF 8D 85 94 FB FF FF 50 53 56 FF 15 ?? ?? ?? ?? 89 85 90 FB FF FF 83 F8 FF 0F 85 D4 00 00 00 68 ?? ?? ?? ?? 56 89 9D 90 FB FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 83 8D 85 90 FB FF FF 50 68 04 01 00 00 8D 85 F4 FD FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 74 7E 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 69 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 5D 39 9D 90 FB FF FF 74 0C FF B5 90 FB FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 33 C0 6A 01 68 BC 07 00 00 C7 85 94 FB FF FF 10 00 00 00 89 9D B0 FB FF FF 89 9D B4 FB FF FF 66 89 85 C0 FB FF FF E8 ?? ?? ?? ?? 8B B5 8C FB FF FF 83 C4 1C 89 47 24 89 47 20 89 47 28 E9 32 02 00 00 39 9D 90 FB FF FF 0F 84 D7 FE FF FF FF B5 90 FB FF FF E8 ?? ?? ?? ?? 59 E9 C6 FE FF FF F7 85 94 FB FF FF 00 04 00 00 74 5F 81 BD B8 FB FF FF 0C 00 00 A0 75 53 83 8D 90 FB FF FF FF 53 6A 40 53 8D 85 90 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 8B FE FF FF 83 BD 90 FB FF FF FF 0F 84 7E FE FF FF 57 FF B5 90 FB FF FF E8 ?? ?? ?? ?? FF B5 90 FB FF FF 8B F0 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 E9 15 02 00 00 39 9D A8 FB FF FF 75 0D 39 9D AC FB FF FF 75 05 89 5F 24 EB 75 8D 85 88 FB FF FF 50 8D 85 A8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C8 01 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 AC 01 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 24 39 9D A0 FB FF FF 75 0D 39 9D A4 FB FF FF 75 05 8B 47 24 EB 72 8D 85 88 FB FF FF 50 8D 85 A0 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 3E 01 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 22 01 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 39 9D 98 FB FF FF 75 0D 39 9D 9C FB FF FF 75 05 8B 47 24 EB 72 8D 85 88 FB FF FF 50 8D 85 98 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B4 00 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 98 00 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C FF B5 90 FB FF FF 89 47 28 FF 15 ?? ?? ?? ?? 56 FF B5 94 FB FF FF E8 ?? ?? ?? ?? 66 89 47 06 33 C0 40 66 89 47 08 33 C0 33 F6 03 85 B4 FB FF FF 59 59 8B 8D B0 FB FF FF 13 CE 89 47 18 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 84 FB FF FF 48 89 07 89 47 10 89 4F 1C 33 C0 EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 90 FB FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "_fp32_is_qnan"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 00 00 80 7F 23 C8 3B C8 75 0E F7 45 08 00 00 40 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_275_1_0 {
	meta:
		name = "_fp32_is_snan"
		size = 46
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 00 00 80 7F 23 C8 3B C8 75 17 F7 45 08 00 00 40 00 75 0E F7 45 08 FF FF 3F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_275_2_0 {
	meta:
		name = "_fp32_is_inf"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 00 00 80 7F 23 C8 3B C8 75 0E F7 45 08 FF FF 7F 00 75 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_275_3_0 {
	meta:
		name = "_fp32_is_zero"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 F7 45 08 FF FF FF 7F 75 01 40 5D C3 }
	condition:
		$1
}

rule file_275_5_0 {
	meta:
		name = "_RoundFloatToIntegral"
		size = 423
		refs = "000d _fp32_is_qnan 001c _fp32_is_zero 002d _fp32_is_inf 0053 _fp32_is_denormal"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 75 0C 57 56 E8 ?? ?? ?? ?? 59 85 C0 0F 85 81 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 85 70 01 00 00 56 E8 ?? ?? ?? ?? 59 85 C0 0F 85 61 01 00 00 8B FE C1 EF 17 81 E7 FF 00 00 00 81 FF 96 00 00 00 0F 83 4A 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 85 AE 00 00 00 83 FF 7F 0F 82 A5 00 00 00 53 8B C6 25 FF FF 7F 00 0D 00 00 80 00 6A 17 8B D0 83 C7 81 59 2B CF D3 EA 6A 16 89 55 FC D3 E2 8D 4F 09 D3 E0 D3 E8 8B 4D 10 8B D8 33 C0 85 DB 0F 95 C0 89 01 33 C0 59 40 3B F9 74 04 2B CF D3 E0 83 7D 08 00 8D 0C 00 75 1E 3B D8 72 34 75 06 F6 45 FC 01 74 2C 03 CA 81 F9 00 00 00 01 75 24 B9 00 00 80 00 47 EB 1C 83 7D 08 01 75 06 85 F6 79 10 EB 0A 83 7D 08 02 75 08 85 F6 78 04 85 DB 75 D4 8B CA 8D 47 7F C1 E0 17 25 00 00 80 7F 81 E1 FF FF 7F 00 0B C1 81 E6 00 00 00 80 0B C6 5B E9 93 00 00 00 33 C9 41 83 7D 08 00 75 39 B8 00 00 00 80 85 F0 74 18 83 FF 7E 75 0F F7 C6 FF FF 7F 00 74 07 BE 00 00 80 BF EB 5E 8B F0 EB 5A 83 FF 7E 75 0F F7 C6 FF FF 7F 00 74 07 BE 00 00 80 3F EB 46 33 F6 EB 42 39 4D 08 75 12 81 E6 00 00 00 80 F7 DE 1B F6 81 E6 00 00 80 BF EB 2B 83 7D 08 02 75 18 81 E6 00 00 00 80 F7 DE 1B F6 81 E6 00 00 80 40 81 C6 00 00 80 3F EB 0D B8 00 00 00 80 23 F0 F7 DE 1B F6 23 F0 8B 45 10 89 08 EB 06 8B 45 10 83 20 00 8B C6 5F 5E C9 C3 }
	condition:
		$1
}

rule file_275_6_0 {
	meta:
		name = "_issnanf"
		size = 38
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 25 00 00 C0 7F 3D 00 00 80 7F 75 0E F7 45 08 FF FF 3F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_275_7_0 {
	meta:
		name = "_isnanf"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 B8 00 00 80 7F 23 C8 3B C8 75 0E F7 45 08 FF FF 7F 00 74 05 33 C0 40 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_275_11_0 {
	meta:
		name = "_XMMI_FP_Emulation"
		size = 3968
		refs = "0056 $LN275 005d $LN356 0077 _isdenormalf 00a4 $LN357 0113 __control87 016d __statusfp 0194 _Fill_FPIEEE_RECORD 01b5 _isnanf 0274 _MIN_SINGLE_NORMALA 02b1 _NEGINFFA 02bb _MAX_SINGLE_NORMALA 02dc _POSINFFA 02fe _TWO_TO_192A 0357 _TWO_TO_M192A 0456 _ZEROFA 0468 _NZEROFA 05eb $LN276 05f2 $LN358 05f8 _issnanf 06bd $LN277 06c4 $LN359 06fe $LN278 0705 $LN360 0d82 _fp32_is_qnan 0da0 _fp32_is_snan 0dfd _fp32_is_denormal 0e6f _RoundFloatToIntegral 0eec $LN267 0ef0 $LN40 0ef4 $LN74 0ef8 $LN193 0efc $LN142 0f00 $LN111 0f04 $LN100 0f08 $LN21 0f0c $LN1 0f30 $LN261 0f38 $LN260 0f40 $LN259 0f48 $LN258 0f50 $LN187 0f54 $LN182 0f60 $LN145 0f64 $LN146"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 53 56 33 C0 57 89 45 E8 DB E3 8B 75 08 89 45 EC 89 45 E4 8B 46 20 8B 08 33 4E 10 BB FF 0F 00 00 83 E1 03 31 08 8B 4E 14 8B 46 20 C1 E1 02 33 08 83 E1 1C 31 08 8B 4E 20 8B 11 C1 EA 05 23 D3 8D 7A D5 83 FF 1C 0F 87 90 0E 00 00 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7E 0C 00 8B 41 10 89 45 08 8B 41 30 89 45 F8 74 29 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 BB 00 00 00 80 85 C0 74 03 21 5D 08 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 03 21 5D F8 83 FF 07 77 39 FF 24 BD ?? ?? ?? ?? 8B 01 25 3F 00 FE FF 83 C8 20 EB 24 8B 01 25 5F 00 FE FF 83 C8 40 EB 18 8B 01 25 7F 00 FE FF 83 C8 60 EB 0C 8B 01 25 9F 00 FE FF 0D 80 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 15 B8 00 02 00 00 EB 0E B8 00 01 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 59 59 74 36 48 74 24 48 74 12 48 75 3A DB E2 D9 45 08 D9 45 F8 DE F9 DD 5D DC EB 2B DB E2 D9 45 08 D9 45 F8 DE C9 DD 5D DC EB 1C DB E2 D9 45 08 D9 45 F8 DE E9 DD 5D DC EB 0D DB E2 D9 45 08 D9 45 F8 DE C1 DD 5D DC E8 ?? ?? ?? ?? 89 45 F0 A8 08 74 07 81 65 F0 FF FF F7 FF 8B 06 33 DB 43 89 45 E8 84 C3 75 25 F6 45 F0 10 74 1F 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 09 5E 04 8B 76 20 83 4E 04 10 8B C3 E9 35 0D 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 85 72 03 00 00 FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 0F 85 61 03 00 00 F6 45 E8 02 6A 02 BA 00 00 08 00 5F 75 11 85 55 F0 74 0C 8B C6 E8 ?? ?? ?? ?? 09 7E 04 EB B5 F6 45 E8 04 75 21 F6 45 F0 08 74 1B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 08 83 4E 04 04 8B 76 20 83 4E 04 08 EB 8E DD 45 DC D9 55 FC FF 75 FC E8 ?? ?? ?? ?? 59 85 C0 74 3C 8B 46 20 DD D8 09 58 60 D9 45 FC 8B 46 20 D9 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 8B 46 20 83 48 0C 10 09 5E 04 E9 79 0C 00 00 85 55 F0 74 03 09 7E 04 DD 05 ?? ?? ?? ?? D9 C0 D9 E0 D8 DA DF E0 D9 EE F6 C4 05 7A 09 D8 D2 DF E0 F6 C4 41 74 14 D8 DA DF E0 F6 C4 05 7A 14 D8 D9 DF E0 F6 C4 41 75 0D EB 04 DD D9 DD D8 89 5D EC EB 02 DD D8 D9 05 ?? ?? ?? ?? D8 D9 DF E0 DD 05 ?? ?? ?? ?? F6 C4 05 7A 0D D9 C0 D9 E0 D8 DA DF E0 F6 C4 41 74 1A D8 D9 DF E0 F6 C4 05 7A 16 D9 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 07 EB 02 DD D8 89 5D E4 F6 45 E8 10 75 53 83 7D EC 00 74 4D DC 0D ?? ?? ?? ?? 8B C6 DD 5D DC E8 ?? ?? ?? ?? 8B 46 20 09 78 0C 8B 46 20 83 4E 04 10 09 78 04 8B 46 20 09 58 60 DD 45 DC D9 5D 08 D9 45 08 8B 46 20 D9 58 50 84 5D F0 0F 84 6F FE FF FF 8B 46 20 09 58 0C 83 4E 04 20 E9 60 FE FF FF F6 45 E8 08 75 39 83 7D E4 00 74 33 DC 0D ?? ?? ?? ?? 8B C6 DD 5D DC E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 8B 46 20 09 58 60 DD 45 DC D9 5D 08 D9 45 08 EB A3 8B 46 20 DD D8 8B 00 C1 E8 05 25 FF 0F 00 00 48 74 30 48 74 20 48 74 10 48 75 32 D9 45 08 D9 45 F8 DE F9 D9 5D FC EB 25 D9 45 08 D9 45 F8 DE C9 D9 5D FC EB 18 D9 45 08 D9 45 F8 DE E9 D9 5D FC EB 0B D9 45 08 D9 45 F8 DE C1 D9 5D FC E8 ?? ?? ?? ?? F6 06 20 8B C8 0F 85 98 00 00 00 84 CB 75 14 83 7E 08 00 0F 84 8A 00 00 00 83 7D EC 00 0F 84 80 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 83 7D EC 00 74 0A 8B 46 20 09 78 0C 83 4E 04 10 33 C9 39 4D E4 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 4E 08 74 2E 39 4D EC 74 29 D9 EE D8 55 FC DF E0 F6 C4 05 7A 0A DD D8 D9 05 ?? ?? ?? ?? EB 10 D8 5D FC DF E0 F6 C4 41 75 09 D9 05 ?? ?? ?? ?? D9 5D FC 8B 46 20 D9 45 FC D9 58 50 E9 2C FD FF FF 8B 46 20 09 58 60 8B 46 20 F6 C1 02 74 09 09 78 0C 83 4E 04 10 EB 04 83 60 0C FD 8B 46 20 F6 C1 04 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 8B 46 20 84 CB 74 09 09 58 0C 83 4E 04 20 EB 04 83 60 0C FE 83 7E 08 00 74 43 83 7D EC 00 74 3D D9 EE D8 55 FC DF E0 F6 C4 05 7A 0A DD D8 D9 05 ?? ?? ?? ?? EB 10 D8 5D FC DF E0 F6 C4 41 75 09 D9 05 ?? ?? ?? ?? D9 5D FC 8B 46 20 09 58 0C 83 4E 04 20 8B 46 20 09 78 0C 83 4E 04 10 8B 46 20 D9 45 FC D9 58 50 8B 46 20 F6 C1 08 74 0A 83 48 0C 08 83 4E 04 04 EB 04 83 60 0C F7 8B 76 20 83 66 0C EF E9 AD 09 00 00 8B 46 20 09 58 60 85 FF 74 1B FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 74 0E 8B 46 20 81 CA 00 00 40 00 89 50 50 EB 0F DD 45 DC 8B 46 20 D9 5D 08 D9 45 08 D9 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 45 F0 10 74 9E E9 CA FC FF FF 83 7E 0C 00 8B 51 10 8B 41 30 89 55 08 89 45 F8 74 29 52 E8 ?? ?? ?? ?? 83 C4 04 BB 00 00 00 80 85 C0 74 05 23 D3 89 55 08 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 03 21 5D F8 8B 01 8B 7E 18 25 FF 00 FE FF 33 DB 83 E7 07 0D E0 00 00 00 43 89 01 83 FF 07 77 3E 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 14 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 05 21 45 F0 EB 03 89 5D F0 E8 ?? ?? ?? ?? A8 10 74 03 89 5D F0 83 7D F0 00 74 08 84 1E 0F 84 5D FB FF FF FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 0F 85 F4 00 00 00 FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 0F 85 E3 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0F FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 32 83 4E 04 02 F6 06 02 75 29 8B C6 E8 ?? ?? ?? ?? E9 20 FB FF FF 52 E8 ?? ?? ?? ?? 59 85 C0 75 8F FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 75 82 21 45 F0 EB 8E D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 13 83 FF 07 77 53 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 10 83 FF 03 76 2D 83 FF 07 77 2C 83 4D 08 FF EB 26 D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 7A 17 83 FF 07 77 12 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 65 08 00 8B 46 20 D9 45 08 09 58 60 8B 46 20 D9 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 E9 ED FD FF FF 83 FF 02 76 0A 83 FF 06 76 3D 83 FF 07 75 04 83 65 08 00 8B 46 20 D9 45 08 09 58 60 8B 46 20 D9 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 83 7D F0 00 E9 0A FE FF FF 83 4D 08 FF EB C6 83 7E 0C 00 8B 79 10 8B 49 30 89 7D 08 89 4D F8 74 29 57 E8 ?? ?? ?? ?? 83 C4 04 BB 00 00 00 80 85 C0 74 05 23 FB 89 7D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 23 CB 89 4D F8 83 EA 3B 6A 01 5B 74 30 4A 75 49 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 11 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 FF EB 02 8B FB E8 ?? ?? ?? ?? A8 10 74 23 8B FB EB 1F 57 E8 ?? ?? ?? ?? 59 85 C0 75 F1 FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 75 E4 33 FF EB 03 8B 7D F0 8B 46 20 8B 08 81 E1 FF 00 FE FF 81 C9 E0 00 00 00 89 08 85 FF 74 08 84 1E 0F 84 5A F9 FF FF FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 0F 85 98 00 00 00 FF 75 F8 E8 ?? ?? ?? ?? 59 85 C0 0F 85 87 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0F FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 F9 FD FF FF D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 0C 81 66 1C 2A F7 FF FF E9 7D FE FF FF D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 0C 8B 46 1C 25 2B F7 FF FF 0B C3 EB 1E D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 0F 8A 4F FE FF FF 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C E9 3C FE FF FF 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 85 FF E9 79 FC FF FF 8B 41 10 89 45 08 8B 46 10 83 E8 00 BF 00 01 00 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 12 B8 00 02 00 00 EB 0B 8B C7 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 DB 45 08 D9 5D FC E8 ?? ?? ?? ?? 33 DB 43 F6 06 20 75 35 84 C3 74 31 8B C6 E8 ?? ?? ?? ?? 8B 46 20 8B 08 81 E1 1F 01 FE FF 0B CF 89 08 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 E9 CD FA FF FF 8B 4E 20 09 59 60 D9 45 FC 8B 4E 20 D9 59 50 84 C3 8B 46 20 0F 84 63 FD FF FF 09 58 0C 83 4E 04 20 E9 5B FD FF FF 83 7E 0C 00 8B 41 10 89 45 08 74 14 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 81 65 08 00 00 00 80 BF 00 01 00 00 83 FA 3F 72 23 83 FA 40 76 13 83 FA 42 77 19 8B 01 25 5F 05 FE FF 0D 40 05 00 00 EB 09 8B 01 25 1F 01 FE FF 0B C7 89 01 8B 46 20 8B 00 C1 E8 05 23 C3 83 F8 08 74 05 83 F8 2A EB 0F 8B 46 10 83 E8 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 12 B8 00 02 00 00 EB 0B 8B C7 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 08 DB 5D F4 E8 ?? ?? ?? ?? 33 DB 43 84 1E 75 08 A8 10 0F 85 10 F7 FF FF 8B 4E 20 8B 55 F4 89 51 50 F6 06 20 75 26 84 C3 74 22 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 76 20 09 5E 60 E9 F4 F6 FF FF 8B 4E 20 09 59 60 8B 4E 20 84 C3 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 E9 9F FA FF FF 83 7E 0C 00 8B 59 10 8B 79 30 89 5D 08 89 7D F8 74 2A 53 E8 ?? ?? ?? ?? 83 C4 04 BB 00 00 00 80 85 C0 74 03 21 5D 08 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 23 FB 89 7D F8 8B 5D 08 83 FA 35 72 26 83 FA 36 76 13 83 FA 38 77 1C 8B 01 25 1F 05 FE FF 0D 00 05 00 00 EB 0C 8B 01 25 3F 05 FE FF 0D 20 05 00 00 89 01 53 E8 ?? ?? ?? ?? 59 85 C0 75 0B 57 E8 ?? ?? ?? ?? 59 85 C0 74 31 33 DB 43 84 1E 0F 84 1E F6 FF FF 8B 46 20 09 58 60 8B 46 20 89 78 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB E9 BB F6 FF FF 53 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0D 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 18 83 4E 04 02 F6 06 02 75 0F 8B C6 E8 ?? ?? ?? ?? 33 C0 40 E9 1A 03 00 00 D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 1A 8B 4E 20 8B 01 C1 E8 05 25 FF 0F 00 00 83 E8 28 74 2C 48 75 43 89 79 50 EB 3E D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 1A 8B 4E 20 8B 01 C1 E8 05 25 FF 0F 00 00 83 E8 28 74 DA 48 75 1A 89 59 50 EB 15 D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 7A 06 8B 46 20 89 78 50 8B 46 20 83 48 60 01 E9 DE FA FF FF 83 7E 0C 00 8B 41 10 89 45 08 74 14 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 81 65 08 00 00 00 80 8B 01 25 BF 00 FE FF 0D A0 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 15 B8 00 02 00 00 EB 0E B8 00 01 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 08 D9 FA D9 5D FC E8 ?? ?? ?? ?? A8 10 74 05 25 FF FF F7 FF 8B 0E 33 DB 43 84 CB 75 08 A8 10 0F 85 BD F4 FF FF 8B D0 81 E2 00 00 08 00 74 04 83 4E 04 02 F6 C1 02 75 08 85 D2 0F 85 8E F9 FF FF 8B 4E 20 D9 45 FC D9 59 50 F6 06 20 75 08 84 C3 0F 85 8E FD FF FF 8B 4E 20 09 59 60 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 84 C3 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C F7 A8 10 0F 84 EE F7 FF FF 8B 46 20 83 48 0C 10 89 5E 04 E9 98 01 00 00 8B 01 25 3F 01 FE FF 0D 20 01 00 00 89 01 8B 46 20 8B 78 10 8B D7 C1 FA 17 8B C7 C1 F8 1F C1 E0 08 81 E2 FF 00 00 00 0B D0 8B C7 25 FF FF 7F 00 C1 E2 17 0B D0 52 E8 ?? ?? ?? ?? 59 85 C0 74 13 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 60 01 E9 38 01 00 00 52 E8 ?? ?? ?? ?? 59 85 C0 74 52 33 DB 43 8B C6 84 1E 75 22 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 8B 46 20 09 5E 04 83 48 04 10 8B 76 20 83 66 60 FE E9 D5 F3 FF FF E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 8B 46 20 09 5E 04 09 58 60 8B 46 20 83 60 60 E1 81 CF 00 00 40 00 E9 E2 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 26 83 7E 0C 00 74 20 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 60 01 8B 46 20 83 60 60 E1 81 E7 00 00 00 80 E9 AF 00 00 00 8B 46 18 33 DB 83 E0 0F 43 89 45 08 A8 04 75 05 83 E0 03 EB 25 8B 46 10 83 E8 00 74 16 48 74 0F 48 74 07 48 75 11 6A 03 EB 02 6A 02 58 EB 0B 8B C3 EB 07 33 C0 EB 03 8B 45 08 8D 4D E8 51 52 50 E8 ?? ?? ?? ?? 83 C4 0C F6 45 08 08 8B F8 75 4B 83 7D E8 00 74 45 F6 06 20 8B C6 75 2D E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 8B 46 20 83 60 60 E1 8B 46 20 89 78 50 E9 F1 F2 FF FF E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 83 4E 04 20 EB 07 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 60 8B 46 20 83 60 60 E1 8B 46 20 89 78 50 33 C0 5F 5E 5B C9 C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 01 02 02 02 02 03 03 04 04 05 05 06 06 06 06 08 08 08 07 07 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 00 01 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "__cwait"
		size = 145
		refs = "0019 __imp__WaitForSingleObject@8 0028 __imp__GetExitCodeProcess@8 0036 __imp__GetLastError@0 0042 __errno 004d ___doserrno 005d __dosmaperr 006b __imp__CloseHandle@4"
	strings:
		$1 = { 8B FF 55 8B EC 53 8B 5D 0C 83 FB FF 74 72 83 FB FE 74 6D 56 6A FF 53 FF 15 ?? ?? ?? ?? 85 C0 75 13 8D 45 0C 50 53 FF 15 ?? ?? ?? ?? 85 C0 74 04 8B F3 EB 34 8B 35 ?? ?? ?? ?? FF D6 83 F8 06 75 18 E8 ?? ?? ?? ?? C7 00 0A 00 00 00 E8 ?? ?? ?? ?? C7 00 06 00 00 00 EB 09 FF D6 50 E8 ?? ?? ?? ?? 59 83 CE FF 89 75 0C 53 FF 15 ?? ?? ?? ?? 8B 45 08 85 C0 74 05 8B 4D 0C 89 08 8B C6 5E EB 0E E8 ?? ?? ?? ?? C7 00 0A 00 00 00 83 C8 FF 5B 5D C3 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "__wfdopen"
		size = 382
		refs = "0003 __sehtable$__wfdopen 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 004c __nhandle 006d ___pioinfo 00a3 __commode 012f __getstream 0152 __cflush 016e __SEH_epilog4 0178 __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 8B 45 0C 85 C0 0F 95 C1 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 3C 01 00 00 8B 4D 08 83 F9 FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB E4 85 C9 78 08 3B 0D ?? ?? ?? ?? 72 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB C6 8B D1 C1 FA 05 83 E1 1F C1 E1 06 8B 14 95 ?? ?? ?? ?? 0F BE 4C 0A 04 33 D2 42 23 CA 74 D5 EB 03 83 C0 02 66 83 38 20 74 F7 0F B7 08 83 F9 61 74 0A 83 F9 72 74 14 83 F9 77 75 80 6A 02 5B 33 F6 33 FF 0B 1D ?? ?? ?? ?? EB 5D 8B DA EB F0 85 D2 74 65 0F B7 C9 83 E9 20 74 4D 83 E9 0B 74 37 83 E9 37 74 11 49 74 22 83 E9 0B 74 10 83 E9 06 0F 85 46 FF FF FF 85 FF 75 21 47 EB 2B 85 F6 75 1A 46 81 E3 FF BF FF FF EB 1E 85 F6 75 0D 46 81 CB 00 40 00 00 EB 11 84 DB 79 04 33 D2 EB 09 83 E3 FC 81 CB 80 00 00 00 83 C0 02 0F B7 08 66 85 C9 75 9C EB 03 83 C0 02 66 83 38 20 74 F7 33 C9 66 39 08 0F 94 C1 8B C1 85 C0 0F 84 EC FE FF FF E8 ?? ?? ?? ?? 8B F0 89 75 0C 85 F6 75 10 E8 ?? ?? ?? ?? C7 00 18 00 00 00 E9 DE FE FF FF 83 65 FC 00 FF 05 ?? ?? ?? ?? 89 5E 0C 8B 45 08 89 46 10 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "__difftime32"
		size = 44
		refs = "001e __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 0C 00 7C 12 8B 45 08 85 C0 78 0B 2B 45 0C 89 45 0C DB 45 0C 5D C3 E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 5D C3 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 80
		refs = "0003 __sehtable$?DebuggerProbe@@YAHK@Z 0008 __SEH_prolog4 0032 __imp__RaiseException@16 004b __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 88 45 E7 C7 45 CC 01 10 00 00 89 4D D0 8D 4D E7 89 4D D4 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 07 33 C0 40 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 98
		refs = "0003 __sehtable$?DebuggerRuntime@@YAHKHPAXPB_W@Z 0008 __SEH_prolog4 0044 __imp__RaiseException@16 005d __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 88 45 E7 C7 45 CC 02 10 00 00 89 4D D0 8B 4D 08 89 4D D4 8B 4D 0C 89 4D D8 8D 4D E7 89 4D DC 8B 4D 10 89 4D E0 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 07 33 C0 40 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_280_2_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 518
		refs = "000c ___security_cookie 003b ?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z 004c ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 005e __imp__MultiByteToWideChar@24 0091 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 009b ?DebuggerProbe@@YAHK@Z 00b3 __RTC_NoFalsePositives 00b8 ?DebuggerRuntime@@YAHKHPAXPB_W@Z 00e7 __imp__IsDebuggerPresent@0 011a ?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z 0137 ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 0159 __imp__WideCharToMultiByte@32 017c ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 01b1 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 01d4 ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 0200 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 0E 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 56 8B F1 57 8B FA 33 DB 56 89 B5 CC F1 FF FF 89 85 C4 F1 FF FF 89 BD C0 F1 FF FF 89 9D C8 F1 FF FF E8 ?? ?? ?? ?? 59 89 85 D0 F1 FF FF 3B C3 75 0D 56 E8 ?? ?? ?? ?? 59 89 85 C8 F1 FF FF 53 53 6A FF 57 8B 3D ?? ?? ?? ?? 53 BE E9 FD 00 00 56 FF D7 3D 00 02 00 00 73 1E 50 8D 85 D4 F1 FF FF 50 6A FF FF B5 C0 F1 FF FF 53 56 FF D7 8D BD D4 F1 FF FF 85 C0 75 05 BF ?? ?? ?? ?? B9 02 10 00 00 E8 ?? ?? ?? ?? 85 C0 74 28 8B 8D C4 F1 FF FF 57 FF B5 CC F1 FF FF FF 34 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 30 01 00 00 32 C0 EB 02 B0 01 39 9D C8 F1 FF FF 75 0C 39 9D D0 F1 FF FF 0F 84 15 01 00 00 3A C3 74 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 03 01 00 00 B8 04 01 00 00 50 8D 8D F4 FD FF FF 51 8D 8D CC F1 FF FF 51 50 8D 85 EC FB FF FF 50 8B 85 CC F1 FF FF 83 C0 FB 50 E8 ?? ?? ?? ?? 83 C4 18 39 9D D0 F1 FF FF 74 2E 57 FF B5 C4 F1 FF FF 8D 85 F4 FD FF FF 68 ?? ?? ?? ?? 50 FF B5 CC F1 FF FF 8D 85 EC FB FF FF 50 FF 75 08 FF 95 D0 F1 FF FF E9 97 00 00 00 8B 3D ?? ?? ?? ?? 53 53 68 0A 03 00 00 8D 85 D4 F5 FF FF 50 6A FF 8D 85 EC FB FF FF 50 53 56 C7 85 D0 F1 FF FF ?? ?? ?? ?? FF D7 85 C0 74 0C 8D 85 D4 F5 FF FF 89 85 D0 F1 FF FF 53 53 68 0A 03 00 00 8D 85 E0 F8 FF FF 50 6A FF 8D 85 F4 FD FF FF 50 53 56 C7 85 BC F1 FF FF ?? ?? ?? ?? FF D7 85 C0 8D 85 E0 F8 FF FF 75 06 8B 85 BC F1 FF FF FF B5 C0 F1 FF FF FF B5 C4 F1 FF FF 68 ?? ?? ?? ?? 50 FF B5 CC F1 FF FF FF B5 D0 F1 FF FF FF 75 08 FF 95 C8 F1 FF FF 83 C4 1C 83 F8 01 75 01 CC 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_280_3_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 59
		refs = "0010 ?_RTC_ErrorLevels@@3PAHA 0017 __RTC_ErrorMessages 0023 ??_C@_0BO@GNIAFIKK@Unknown?5Runtime?5Check?5Error?6?$AN?$AA@ 0033 ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 83 F9 04 77 10 8B 04 8D ?? ?? ?? ?? 8B 14 8D ?? ?? ?? ?? EB 0B 33 C0 6A 05 40 BA ?? ?? ?? ?? 59 83 F8 FF 74 0C 51 8B 4D 08 50 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_280_4_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 243
		refs = "000c ___security_cookie 0017 ?_RTC_ErrorLevels@@3PAHA 005c _stack_premsg 0096 _stack_postmsg 00ca ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 00df ?failwithmessage@@YAXPAXHHPBD@Z 00ed @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 08 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 56 8B 75 0C 89 85 F8 FB FF FF 0F 84 B7 00 00 00 80 3E 00 53 0F 84 90 00 00 00 8B CE 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 83 C1 2D 81 F9 00 04 00 00 77 77 8D 9D FC FB FF FF 33 C9 8A 81 ?? ?? ?? ?? 88 84 0D FC FB FF FF 41 84 C0 75 EE 8B C6 8B D6 8A 08 40 84 C9 75 F9 57 8D BD FC FB FF FF 2B C2 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 B8 ?? ?? ?? ?? F3 A4 8B C8 8A 10 40 84 D2 75 F9 8D BD FC FB FF FF 2B C1 8B F1 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 5F EB 05 BB ?? ?? ?? ?? 8B 8D F8 FB FF FF 6A 02 FF 35 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 59 59 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_280_5_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPAD00I@Z"
		size = 103
		refs = "0034 ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 003d ?wsprintffp@@3P6AHPADPBDZZA"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 53 56 89 45 FC 8B 45 10 57 8B 7D 08 33 F6 2B C7 89 45 F8 8B 4D 14 83 F9 10 72 03 6A 10 59 3B F1 73 25 8A 1C 38 0F B6 C3 50 68 ?? ?? ?? ?? FF 75 FC FF 15 ?? ?? ?? ?? 83 45 FC 03 8B 45 F8 83 C4 0C 88 1F 46 47 EB CC 8B 45 08 C6 04 06 00 6B F6 03 8B 45 0C 5F C6 04 06 00 5E 5B C9 C3 }
	condition:
		$1
}

rule file_280_6_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
		size = 287
		refs = "000c ___security_cookie 0018 ?_RTC_ErrorLevels@@3PAHA 0034 ??_C@_1BG@OILDLIOJ@?$AAu?$AAs?$AAe?$AAr?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 003a __imp__LoadLibraryW@4 0047 ??_C@_09FOPFMPEJ@wsprintfA?$AA@ 004e __imp__GetProcAddress@8 0053 ?wsprintffp@@3P6AHPADPBDZZA 006b ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 0076 ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 007c ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 0085 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 008a ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 0095 ??_C@_0BC@KIBAILCI@?$CFs?$CFs?$CFp?$CFs?$CFld?$CFs?$CFd?$CFs?$AA@ 00ad ?_getMemBlockDataString@@YAXPAD00I@Z 00b5 ??_C@_01EEMJAFIK@?6?$AA@ 00be ??_C@_02LLMPMKNF@?$DO?5?$AA@ 00c7 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 00d4 __imp__lstrlenA@4 00f6 ?failwithmessage@@YAXPAXHHPBD@Z 0103 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 0119 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 1D ?? ?? ?? ?? 56 8B 75 0C 57 8B 7D 08 89 BD BC FE FF FF 83 FB FF 0F 84 DD 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 B9 00 00 00 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 F6 0F 84 A0 00 00 00 85 C0 0F 84 98 00 00 00 8B 4E 0C 68 ?? ?? ?? ?? FF 75 10 83 E9 24 68 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 8D 7E 20 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D C0 FE FF FF 68 ?? ?? ?? ?? 51 FF D0 8B 46 0C 83 E8 24 50 57 8D 45 B4 50 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 38 68 ?? ?? ?? ?? 8D 45 B4 50 68 ?? ?? ?? ?? 8D 45 E8 50 68 ?? ?? ?? ?? 8D 85 C0 FE FF FF 50 FF 15 ?? ?? ?? ?? 8D 84 05 C0 FE FF FF 50 FF 15 ?? ?? ?? ?? 8B 8D BC FE FF FF 6A 04 53 8D 95 C0 FE FF FF E8 ?? ?? ?? ?? 83 C4 20 EB 11 6A 04 53 BA ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 59 59 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_280_7_0 {
	meta:
		name = "__RTC_UninitUse"
		size = 226
		refs = "000c ___security_cookie 0017 ?_RTC_ErrorLevels@@3PAHA 0052 _uninit_premsg 008a _uninit_postmsg 00be ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 00ce ?failwithmessage@@YAXPAXHHPBD@Z 00dc @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 04 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 0F 84 B1 00 00 00 53 56 85 C0 0F 84 8E 00 00 00 8B C8 8D 71 01 8A 19 41 84 DB 75 F9 2B CE 83 C1 3A 81 F9 00 04 00 00 77 75 8D 95 FC FB FF FF 33 C9 8A 99 ?? ?? ?? ?? 88 9C 0D FC FB FF FF 41 84 DB 75 EE 8B F0 8A 08 40 84 C9 75 F9 57 8D BD FC FB FF FF 2B C6 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 B8 ?? ?? ?? ?? F3 A4 8B C8 8A 18 40 84 DB 75 F9 8D BD FC FB FF FF 2B C1 8B F1 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 5F EB 05 BA ?? ?? ?? ?? 8B 4D 04 6A 03 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_281_0_0 {
	meta:
		name = "___dtoxmode"
		size = 189
		refs = "0052 __mbsrchr 005f ??_C@_04JLMDILM@?4exe?$AA@ 0065 __mbsicmp 0070 ??_C@_04CPCBDHLK@?4cmd?$AA@ 0081 ??_C@_04NEEFLLOK@?4bat?$AA@ 0092 ??_C@_04PNGHFIJN@?4com?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 0F B6 45 08 56 8B 75 0C 80 7E 01 3A 57 8B CE 75 03 8D 4E 02 8A 11 80 FA 5C 74 05 80 FA 2F 75 06 80 79 01 00 74 0D A8 10 75 09 BF 00 80 00 00 84 D2 75 05 BF 40 40 00 00 C1 E0 07 F7 D0 25 80 00 00 00 0D 00 01 00 00 6A 2E 56 0B F8 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 47 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 33 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 22 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 11 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 03 83 CF 40 8B C7 C1 E8 03 83 E0 38 0B F8 8B C7 C1 E8 06 83 E0 07 0B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_281_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 122
		refs = "0004 _strlen"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 59 83 F8 05 72 69 8A 06 3C 5C 74 04 3C 2F 75 5F 8A 46 01 3C 5C 74 04 3C 2F 75 54 8A 46 02 3C 5C 74 4D 3C 2F 74 49 8D 46 03 8A 08 32 D2 3A CA 74 3E 80 F9 5C 74 0C 80 F9 2F 74 07 40 8A 08 3A CA 75 EF 38 10 74 29 40 38 10 74 24 8A 08 3A CA 74 1A 80 F9 5C 74 0C 80 F9 2F 74 07 40 8A 08 3A CA 75 EF 38 10 74 05 38 50 01 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_281_3_0 {
	meta:
		name = "__stat32"
		size = 1066
		refs = "000c ___security_cookie 0031 ___doserrno 0038 __errno 0043 __invalid_parameter_noinfo 0051 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 0057 __mbspbrk 008d __mbctolower 0098 __getdrive 00b0 __imp__FindFirstFileExA@24 00c4 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 00ef __fullpath_helper 00fe _strlen 0109 _IsRootUNCName 0114 __imp__GetDriveTypeA@4 012c _free 015c ___loctotime32_t 01c0 __sopen_s 01e4 __fstat32 01f1 __close 0224 __imp__FileTimeToLocalFileTime@8 0240 __imp__FileTimeToSystemTime@8 03a5 __imp__FindClose@4 03b1 ___dtoxmode 0401 __imp__GetLastError@0 0407 __dosmaperr 0424 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 6C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 A0 FD FF FF 89 9D 94 FD FF FF 3B F3 75 1C E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 CC 03 00 00 3B FB 74 E0 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 A1 03 00 00 80 7E 01 3A 75 1A 8A 06 3A C3 74 05 38 5E 02 74 D9 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 53 53 53 89 85 98 FD FF FF 8D 85 A8 FD FF FF 50 53 56 FF 15 ?? ?? ?? ?? 89 85 A4 FD FF FF 83 F8 FF 0F 85 D1 00 00 00 68 ?? ?? ?? ?? 56 89 9D A4 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 87 8D 85 A4 FD FF FF 50 68 04 01 00 00 8D 85 F8 FE FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 74 7B 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 66 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 5A 39 9D A4 FD FF FF 74 0C FF B5 A4 FD FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 85 A8 FD FF FF 10 00 00 00 89 9D C4 FD FF FF 89 9D C8 FD FF FF 88 9D D4 FD FF FF E8 ?? ?? ?? ?? 8B B5 A0 FD FF FF 83 C4 1C 89 47 1C 89 47 18 89 47 20 E9 32 02 00 00 39 9D A4 FD FF FF 0F 84 DE FE FF FF FF B5 A4 FD FF FF E8 ?? ?? ?? ?? 59 E9 CD FE FF FF F7 85 A8 FD FF FF 00 04 00 00 74 5F 81 BD CC FD FF FF 0C 00 00 A0 75 53 83 8D A4 FD FF FF FF 53 6A 40 53 8D 85 A4 FD FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 92 FE FF FF 83 BD A4 FD FF FF FF 0F 84 85 FE FF FF 57 FF B5 A4 FD FF FF E8 ?? ?? ?? ?? FF B5 A4 FD FF FF 8B F0 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 E9 1C 02 00 00 39 9D BC FD FF FF 75 0D 39 9D C0 FD FF FF 75 05 89 5F 1C EB 75 8D 85 9C FD FF FF 50 8D 85 BC FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CF 01 00 00 8D 85 E8 FE FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B3 01 00 00 0F B7 85 F4 FE FF FF 6A FF 50 0F B7 85 F2 FE FF FF 50 0F B7 85 F0 FE FF FF 50 0F B7 85 EE FE FF FF 50 0F B7 85 EA FE FF FF 50 0F B7 85 E8 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 1C 39 9D B4 FD FF FF 75 0D 39 9D B8 FD FF FF 75 05 8B 47 1C EB 72 8D 85 9C FD FF FF 50 8D 85 B4 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 45 01 00 00 8D 85 E8 FE FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 29 01 00 00 0F B7 85 F4 FE FF FF 6A FF 50 0F B7 85 F2 FE FF FF 50 0F B7 85 F0 FE FF FF 50 0F B7 85 EE FE FF FF 50 0F B7 85 EA FE FF FF 50 0F B7 85 E8 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 18 39 9D AC FD FF FF 75 0D 39 9D B0 FD FF FF 75 05 8B 47 1C EB 72 8D 85 9C FD FF FF 50 8D 85 AC FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BB 00 00 00 8D 85 E8 FE FF FF 50 8D 85 9C FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 9F 00 00 00 0F B7 85 F4 FE FF FF 6A FF 50 0F B7 85 F2 FE FF FF 50 0F B7 85 F0 FE FF FF 50 0F B7 85 EE FE FF FF 50 0F B7 85 EA FE FF FF 50 0F B7 85 E8 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C FF B5 A4 FD FF FF 89 47 20 FF 15 ?? ?? ?? ?? 56 FF B5 A8 FD FF FF E8 ?? ?? ?? ?? 66 89 47 06 33 C0 40 66 89 47 08 8B 85 C8 FD FF FF 59 59 89 47 14 39 9D C4 FD FF FF 74 0A 83 8D 94 FD FF FF FF 89 5F 14 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 98 FD FF FF 48 89 07 89 47 10 8B 85 94 FD FF FF EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 A4 FD FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__allshr"
		size = 33
	strings:
		$1 = { 80 F9 40 73 16 80 F9 20 73 06 0F AD D0 D3 FA C3 8B C2 C1 FA 1F 80 E1 1F D3 F8 C3 C1 FA 1F 8B C2 C3 }
	condition:
		$1
}

rule file_283_10_0 {
	meta:
		name = "__cprinput_s_l"
		size = 4255
		refs = "000c ___security_cookie 0063 __errno 006e __invalid_parameter_noinfo 0084 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00ac _iswctype 00c3 __whiteout 00cc __un_inc 017f _isdigit 0307 __getwche_nolock 04c4 ___check_float_string 07d5 __malloc_crt 07f4 _wcstombs_s 082a __cfltcvt_tab 0830 __imp__DecodePointer@4 0838 _free 0a02 _memset 0beb _wctomb_s 0d50 __allmul 0d73 _isxdigit 0d9d __hextodec 0ff2 __invoke_watson 1099 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 40 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 56 57 33 FF 8B F1 89 85 E0 FC FF FF 8D 85 40 FD FF FF 89 B5 14 FD FF FF 89 85 20 FD FF FF C7 85 E8 FC FF FF 5E 01 00 00 89 BD EC FC FF FF 89 BD E4 FC FF FF 89 BD D8 FC FF FF 89 BD 28 FD FF FF 89 BD D4 FC FF FF 3B F7 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 17 10 00 00 FF 75 08 8D 8D C0 FC FF FF E8 ?? ?? ?? ?? 0F B7 06 C6 85 25 FD FF FF 00 89 BD 38 FD FF FF 89 BD F0 FC FF FF 66 3B C7 0F 84 D1 0F 00 00 53 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 3A FF 8D 38 FD FF FF 8D B5 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 8B B5 14 FD FF FF 59 83 C6 02 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EC E9 93 0E 00 00 8B B5 14 FD FF FF 0F B7 06 6A 25 59 66 3B C8 0F 85 94 0E 00 00 66 3B 4E 02 0F 84 7C 0E 00 00 33 FF 89 BD F8 FC FF FF 89 BD D0 FC FF FF 89 BD 1C FD FF FF 89 BD 04 FD FF FF 89 BD 30 FD FF FF 89 BD FC FC FF FF C6 85 0B FD FF FF 00 C6 85 24 FD FF FF 00 C6 85 2F FD FF FF 00 C6 85 3F FD FF FF 00 C6 85 26 FD FF FF 00 C6 85 37 FD FF FF 00 C6 85 27 FD FF FF 01 89 BD 18 FD FF FF 83 C6 02 0F B7 1E F7 C3 00 FF 00 00 75 2C 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 1E 8B 85 30 FD FF FF FF 85 04 FD FF FF 6B C0 0A 8D 44 18 D0 89 85 30 FD FF FF E9 CA 00 00 00 83 FB 4E 0F 8F 84 00 00 00 0F 84 BB 00 00 00 83 FB 2A 74 71 83 FB 46 0F 84 AD 00 00 00 83 FB 49 74 10 83 FB 4C 75 75 FE 85 27 FD FF FF E9 98 00 00 00 0F B7 4E 02 83 F9 36 75 1E 66 83 7E 04 34 75 17 83 C6 04 FF 85 18 FD FF FF 89 BD 0C FD FF FF 89 BD 10 FD FF FF EB 71 83 F9 33 75 0C 66 83 7E 04 32 75 05 83 C6 04 EB 60 83 F9 64 74 5B 83 F9 69 74 56 83 F9 6F 74 51 83 F9 78 74 4C 83 F9 58 75 19 EB 45 FE 85 2F FD FF FF EB 3D 83 FB 68 74 2C 83 FB 6C 74 0D 83 FB 77 74 1A FE 85 3F FD FF FF EB 26 66 83 7E 02 6C 75 05 83 C6 02 EB 95 FE 85 27 FD FF FF FE 85 37 FD FF FF EB 0C FE 8D 27 FD FF FF FE 8D 37 FD FF FF 80 BD 3F FD FF FF 00 0F 84 EF FE FF FF 80 BD 2F FD FF FF 00 89 B5 14 FD FF FF 75 19 8B 85 E0 FC FF FF 8B 18 89 85 DC FC FF FF 83 C0 04 89 85 E0 FC FF FF EB 02 33 DB 80 BD 37 FD FF FF 00 89 9D 00 FD FF FF C6 85 3F FD FF FF 00 75 1B 0F B7 06 83 F8 53 74 0C C6 85 37 FD FF FF 01 83 F8 43 75 07 C6 85 37 FD FF FF FF 0F B7 3E 83 CF 20 89 BD F4 FC FF FF 83 FF 6E 74 49 83 FF 63 74 12 83 FF 7B 74 0D 8D B5 38 FD FF FF E8 ?? ?? ?? ?? EB 0B FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 28 FD FF FF B8 FF FF 00 00 66 3B 85 28 FD FF FF 0F 84 0E 0D 00 00 8B 9D 00 FD FF FF 8B B5 14 FD FF FF 8B 8D 04 FD FF FF 85 C9 74 0D 83 BD 30 FD FF FF 00 0F 84 DF 0C 00 00 80 BD 2F FD FF FF 00 75 41 83 FF 63 74 0A 83 FF 73 74 05 83 FF 7B 75 32 8B 85 DC FC FF FF 8B 18 83 C0 04 89 85 DC FC FF FF 83 C0 04 89 85 E0 FC FF FF 8B 40 FC 89 9D 00 FD FF FF 89 85 FC FC FF FF 83 F8 01 0F 82 39 0C 00 00 83 FF 6F 0F 8F AB 05 00 00 0F 84 E1 08 00 00 83 FF 63 0F 84 99 04 00 00 6A 64 58 3B F8 0F 84 CD 08 00 00 0F 8E B5 05 00 00 83 FF 67 7E 4C 83 FF 69 74 21 83 FF 6E 0F 85 A2 05 00 00 80 BD 2F FD FF FF 00 8B 85 38 FD FF FF 0F 84 66 0B 00 00 E9 8D 0B 00 00 89 85 F4 FC FF FF 8B F8 8B 9D 28 FD FF FF 6A 2D 58 66 3B C3 0F 85 E8 06 00 00 C6 85 24 FD FF FF 01 E9 E4 06 00 00 6A 2D 58 33 DB 66 3B 85 28 FD FF FF 75 0C 8B 8D 20 FD FF FF 66 89 01 43 EB 0C 6A 2B 58 66 3B 85 28 FD FF FF 75 1A FF 8D 30 FD FF FF FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 28 FD FF FF 83 BD 04 FD FF FF 00 75 07 83 8D 30 FD FF FF FF F7 85 28 FD FF FF 00 FF 00 00 0F 85 85 00 00 00 0F B6 85 28 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 73 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 63 66 0F BE 85 28 FD FF FF 8B 8D 20 FD FF FF FF 85 1C FD FF FF 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 61 0B 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 28 FD FF FF A9 00 FF 00 00 0F 84 7B FF FF FF 8B 85 C0 FC FF FF 8B 80 BC 00 00 00 8B 40 30 0F B7 30 0F BE 8D 28 FD FF FF 8B C6 3B C1 0F 85 EE 00 00 00 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 DA 00 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 28 FD FF FF 8B 85 20 FD FF FF 66 89 34 58 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 C1 0A 00 00 F7 85 28 FD FF FF 00 FF 00 00 0F 85 80 00 00 00 0F B6 85 28 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 5E 8B 85 20 FD FF FF 66 8B 8D 28 FD FF FF FF 85 1C FD FF FF 66 89 0C 58 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 4C 0A 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 28 FD FF FF A9 00 FF 00 00 74 80 83 BD 1C FD FF FF 00 0F 84 7B 01 00 00 6A 65 58 66 3B 85 28 FD FF FF 74 10 6A 45 58 66 3B 85 28 FD FF FF 0F 85 5F 01 00 00 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 4B 01 00 00 8B 8D 20 FD FF FF 6A 65 58 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 BB 09 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 6A 2D 59 89 85 28 FD FF FF 66 3B C8 75 2E 51 8B 8D 20 FD FF FF 58 66 89 04 59 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 73 09 00 00 EB 0C 6A 2B 58 66 3B 85 28 FD FF FF 75 2C 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 75 08 21 85 30 FD FF FF EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 28 FD FF FF F7 85 28 FD FF FF 00 FF 00 00 0F 85 80 00 00 00 0F B6 85 28 FD FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 6E 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 74 5E 8B 85 20 FD FF FF 66 8B 8D 28 FD FF FF FF 85 1C FD FF FF 66 89 0C 58 8D 85 EC FC FF FF 50 8D 85 40 FD FF FF 50 43 53 8D BD 20 FD FF FF 8D B5 E8 FC FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 C4 08 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 C0 89 85 28 FD FF FF A9 00 FF 00 00 74 80 FF B5 28 FD FF FF FF 8D 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 1C FD FF FF 00 59 0F 84 8A 08 00 00 80 BD 2F FD FF FF 00 0F 85 BD 07 00 00 8B B5 E8 FC FF FF 8B 8D 20 FD FF FF FF 85 F0 FC FF FF 33 C0 8D 74 36 02 56 66 89 04 59 E8 ?? ?? ?? ?? 8B F8 59 85 FF 0F 84 50 08 00 00 8D 46 FF 50 FF B5 20 FD FF FF 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 12 83 F8 16 0F 84 E4 07 00 00 83 F8 22 0F 84 DB 07 00 00 8D 85 C0 FC FF FF 50 0F BE 85 27 FD FF FF 57 FF B5 00 FD FF FF 48 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 30 07 00 00 85 C9 75 10 FF 85 30 FD FF FF C7 85 04 FD FF FF 01 00 00 00 80 BD 37 FD FF FF 00 7E 07 C6 85 26 FD FF FF 01 FF B5 28 FD FF FF FF 8D 38 FD FF FF 8B F3 E8 ?? ?? ?? ?? 59 83 FF 63 74 06 FF 8D FC FC FF FF 83 BD 04 FD FF FF 00 74 14 8B 85 30 FD FF FF FF 8D 30 FD FF FF 85 C0 0F 84 8D 03 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D0 89 95 28 FD FF FF 83 FF 63 74 52 83 FF 73 75 13 83 FA 09 72 09 83 FA 0D 0F 86 54 03 00 00 83 FA 20 75 3A 83 FF 7B 0F 85 46 03 00 00 0F B7 C2 8B C8 33 FF 83 E1 07 47 D3 E7 8B 8D E4 FC FF FF C1 E8 03 0F BE 04 08 0F BE 8D 0B FD FF FF 33 C1 85 F8 8B BD F4 FC FF FF 0F 84 15 03 00 00 80 BD 2F FD FF FF 00 0F 85 00 03 00 00 83 BD FC FC FF FF 00 0F 84 DF 06 00 00 80 BD 26 FD FF FF 00 0F 84 9E 02 00 00 66 89 13 83 C3 02 89 9D 00 FD FF FF E9 3A FF FF FF 8B C7 83 E8 70 0F 84 2A 03 00 00 83 E8 03 0F 84 FD FE FF FF 48 48 0F 84 20 03 00 00 83 E8 03 0F 84 83 FA FF FF 83 E8 03 74 33 8B 85 28 FD FF FF 66 39 06 0F 85 76 06 00 00 FE 8D 25 FD FF FF 80 BD 2F FD FF FF 00 0F 85 E1 05 00 00 8B 85 DC FC FF FF 89 85 E0 FC FF FF E9 D0 05 00 00 80 BD 37 FD FF FF 00 7E 07 C6 85 26 FD FF FF 01 6A 5E 58 8D 7E 02 66 3B 46 02 75 0A 8D 7E 04 C6 85 0B FD FF FF FF 8B B5 E4 FC FF FF 85 F6 75 25 68 00 20 00 00 E8 ?? ?? ?? ?? 59 89 85 E4 FC FF FF 85 C0 0F 84 47 06 00 00 C7 85 D8 FC FF FF 01 00 00 00 8B F0 68 00 20 00 00 6A 00 56 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 58 66 3B 07 75 0E 50 5A 83 C7 02 C6 46 0B 20 E9 9A 00 00 00 8B 95 D0 FC FF FF E9 8F 00 00 00 0F B7 C0 6A 2D 59 83 C7 02 66 3B C8 75 70 66 85 D2 74 6B 0F B7 0F 6A 5D 5B 66 3B D9 74 60 8B C1 83 C7 02 66 3B D0 73 02 EB 05 0F B7 CA 8B D0 89 8D 18 FD FF FF 66 3B D1 73 2A 8B C1 2B C2 0F B7 C0 0F B7 DA 89 85 14 FD FF FF 8B CB 83 E1 07 B2 01 D2 E2 8B C3 C1 E8 03 08 14 30 43 FF 8D 14 FD FF FF 75 E6 0F B7 8D 18 FD FF FF 8B C1 83 E1 07 B2 01 D2 E2 C1 E8 03 08 14 30 33 D2 EB 11 8B C8 83 E1 07 B3 01 D2 E3 8B D0 C1 E8 03 08 1C 30 0F B7 07 6A 5D 59 66 3B C8 0F 85 62 FF FF FF 66 83 3F 00 0F 84 62 05 00 00 8B 9D 00 FD FF FF 89 BD 14 FD FF FF 8B BD F4 FC FF FF E9 7F FD FF FF 6A 2B 58 66 3B C3 75 29 FF 8D 30 FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF 6A 30 58 66 3B C3 0F 85 A5 01 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 6A 78 5E 89 9D 28 FD FF FF 66 3B F3 74 4E 6A 58 58 66 3B C3 74 46 C7 85 1C FD FF FF 01 00 00 00 3B FE 74 23 83 BD 04 FD FF FF 00 74 0E FF 8D 30 FD FF FF 75 06 FE 85 3F FD FF FF C7 85 F4 FC FF FF 6F 00 00 00 EB 4E FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 6A 30 5B E9 35 01 00 00 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 83 BD 04 FD FF FF 00 0F B7 D8 89 9D 28 FD FF FF 74 16 83 AD 30 FD FF FF 02 83 BD 30 FD FF FF 01 7D 06 FE 85 3F FD FF FF 89 B5 F4 FC FF FF 8B BD F4 FC FF FF E9 F7 00 00 00 83 A5 18 FD FF FF 00 52 FF B5 FC FC FF FF 8D 85 18 FD FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 22 0F 84 0D 04 00 00 8B 85 18 FD FF FF 85 C0 0F 8E 7E FC FF FF 03 D8 29 85 FC FC FF FF 89 9D 00 FD FF FF E9 6B FC FF FF 83 C6 02 E9 63 FC FF FF FF 8D 38 FD FF FF 52 E8 ?? ?? ?? ?? 59 3B F3 0F 84 FB 03 00 00 80 BD 2F FD FF FF 00 0F 85 2E 03 00 00 FF 85 F0 FC FF FF 83 FF 63 0F 84 1F 03 00 00 80 BD 26 FD FF FF 00 74 10 8B 8D 00 FD FF FF 33 C0 66 89 01 E9 06 03 00 00 8B 85 00 FD FF FF C6 00 00 E9 F8 02 00 00 C6 85 27 FD FF FF 01 8B 9D 28 FD FF FF 6A 2D 58 66 3B C3 75 09 C6 85 24 FD FF FF 01 EB 08 6A 2B 58 66 3B C3 75 29 FF 8D 30 FD FF FF 75 0D 85 C9 74 09 C6 85 3F FD FF FF 01 EB 14 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF 83 BD 18 FD FF FF 00 0F 84 54 01 00 00 80 BD 3F FD FF FF 00 0F 85 16 01 00 00 83 FF 78 74 78 83 FF 70 74 73 F7 C3 00 FF 00 00 0F 85 F3 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 E1 00 00 00 83 FF 6F 75 2D 6A 38 58 66 3B C3 0F 86 D0 00 00 00 8B 85 0C FD FF FF 8B 8D 10 FD FF FF 0F A4 C1 03 C1 E0 03 89 85 0C FD FF FF 89 8D 10 FD FF FF EB 6C 6A 00 6A 0A FF B5 10 FD FF FF FF B5 0C FD FF FF E8 ?? ?? ?? ?? 89 85 0C FD FF FF 89 95 10 FD FF FF EB 49 F7 C3 00 FF 00 00 0F 85 80 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 72 8B 85 0C FD FF FF 8B 8D 10 FD FF FF 0F A4 C1 04 C1 E0 04 53 89 85 0C FD FF FF 89 8D 10 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 59 89 9D 28 FD FF FF FF 85 1C FD FF FF 0F B7 C3 83 E8 30 99 01 85 0C FD FF FF 11 95 10 FD FF FF 83 BD 04 FD FF FF 00 74 08 FF 8D 30 FD FF FF 74 26 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF E9 F7 FE FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 24 FD FF FF 00 0F 84 0C 01 00 00 8B 85 0C FD FF FF 8B 8D 10 FD FF FF F7 D8 83 D1 00 F7 D9 89 85 0C FD FF FF 89 8D 10 FD FF FF E9 E8 00 00 00 80 BD 3F FD FF FF 00 0F 85 CC 00 00 00 83 FF 78 74 4A 83 FF 70 74 45 F7 C3 00 FF 00 00 0F 85 A9 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 0F 84 97 00 00 00 83 FF 6F 75 17 6A 38 58 66 3B C3 0F 86 86 00 00 00 8B 85 F8 FC FF FF C1 E0 03 EB 3E 8B 85 F8 FC FF FF 6B C0 0A EB 33 F7 C3 00 FF 00 00 75 68 0F B6 C3 50 E8 ?? ?? ?? ?? 59 85 C0 74 5A C1 A5 F8 FC FF FF 04 53 E8 ?? ?? ?? ?? 0F B7 D8 8B 85 F8 FC FF FF 59 89 9D 28 FD FF FF FF 85 1C FD FF FF 83 BD 04 FD FF FF 00 0F B7 CB 8D 44 08 D0 89 85 F8 FC FF FF 74 08 FF 8D 30 FD FF FF 74 26 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 0F B7 D8 89 9D 28 FD FF FF E9 41 FF FF FF FF 8D 38 FD FF FF 53 E8 ?? ?? ?? ?? 59 80 BD 24 FD FF FF 00 74 06 F7 9D F8 FC FF FF 83 FF 46 75 07 83 A5 1C FD FF FF 00 83 BD 1C FD FF FF 00 0F 84 07 01 00 00 80 BD 2F FD FF FF 00 75 3E FF 85 F0 FC FF FF 8B 9D 00 FD FF FF 8B 85 F8 FC FF FF 83 BD 18 FD FF FF 00 74 13 8B 85 0C FD FF FF 89 03 8B 85 10 FD FF FF 89 43 04 EB 10 80 BD 27 FD FF FF 00 74 04 89 03 EB 03 66 89 03 8B B5 14 FD FF FF FE 85 25 FD FF FF 83 C6 02 89 B5 14 FD FF FF EB 33 66 3B C8 75 09 66 3B 4E 02 75 03 83 C6 02 FF 85 38 FD FF FF E8 ?? ?? ?? ?? 66 8B 0E 0F B7 C0 83 C6 02 89 85 28 FD FF FF 89 B5 14 FD FF FF 66 3B C8 75 6A 0F B7 06 66 85 C0 0F 85 DE F0 FF FF EB 68 80 BD 37 FD FF FF 00 7E 07 33 C0 66 89 03 EB 03 C6 03 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 48 56 56 56 56 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C7 85 D4 FC }
	condition:
		$1
}

rule file_284_2_0 {
	meta:
		name = "___fls_getvalue@4"
		size = 26
		refs = "000a ___getvalueindex 0010 __imp__TlsGetValue@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 5D C2 04 00 }
	condition:
		$1
}

rule file_284_4_0 {
	meta:
		name = "___set_flsgetvalue"
		size = 52
		refs = "0005 ___getvalueindex 000b __imp__TlsGetValue@4 0017 _gpFlsGetValue 001d __imp__DecodePointer@4 002c __imp__TlsSetValue@8"
	strings:
		$1 = { 8B FF 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 1B FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 56 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_284_5_0 {
	meta:
		name = "___fls_setvalue@8"
		size = 29
		refs = "000d _gpFlsSetValue 0013 __imp__DecodePointer@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 5D C2 08 00 }
	condition:
		$1
}

rule file_284_6_0 {
	meta:
		name = "__mtterm"
		size = 61
		refs = "0001 ___flsindex 000d _gpFlsFree 0013 __imp__DecodePointer@4 0021 ___getvalueindex 002d __imp__TlsFree@4 0039 __mtdeletelocks"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 16 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 83 0D ?? ?? ?? ?? FF A1 ?? ?? ?? ?? 83 F8 FF 74 0E 50 FF 15 ?? ?? ?? ?? 83 0D ?? ?? ?? ?? FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_7_0 {
	meta:
		name = "__initptd"
		size = 180
		refs = "0003 __sehtable$__initptd 0008 __SEH_prolog4 000d ??_C@_1BK@DBDEIDLH@?$AAK?$AAE?$AAR?$AAN?$AAE?$AAL?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 0013 __imp__GetModuleHandleW@4 001d __XcptActTab 003f ___initialmbcinfo 0046 __lock 0054 __imp__InterlockedIncrement@4 007a ___ptlocinfo 0085 ___addlocaleref 0097 __SEH_epilog4 00a5 __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 75 08 C7 46 5C ?? ?? ?? ?? 83 66 08 00 33 FF 47 89 7E 14 89 7E 70 C6 86 C8 00 00 00 43 C6 86 4B 01 00 00 43 C7 46 68 ?? ?? ?? ?? 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 76 68 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 3E 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 89 7D FC 8B 45 0C 89 46 6C 85 C0 75 08 A1 ?? ?? ?? ?? 89 46 6C FF 76 6C E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 15 00 00 00 E8 ?? ?? ?? ?? C3 33 FF 47 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_284_8_0 {
	meta:
		name = "__getptd_noexit"
		size = 121
		refs = "0006 __imp__GetLastError@0 000c ___flsindex 0013 ___set_flsgetvalue 0027 __calloc_crt 003c _gpFlsSetValue 0042 __imp__DecodePointer@4 0050 __initptd 0058 __imp__GetCurrentThreadId@0 0066 _free 0070 __imp__SetLastError@4"
	strings:
		$1 = { 8B FF 56 57 FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? FF D0 8B F0 85 F6 75 4E 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 3A 56 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 85 C0 74 18 6A 00 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 EB 09 56 E8 ?? ?? ?? ?? 59 33 F6 57 FF 15 ?? ?? ?? ?? 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_284_9_0 {
	meta:
		name = "__getptd"
		size = 26
		refs = "0004 __getptd_noexit 0011 __amsg_exit"
	strings:
		$1 = { 8B FF 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 08 6A 10 E8 ?? ?? ?? ?? 59 8B C6 5E C3 }
	condition:
		$1
}

rule file_284_10_0 {
	meta:
		name = "__freefls@4"
		size = 303
		refs = "0003 __sehtable$__freefls@4 0008 __SEH_prolog4 0020 _free 007d __XcptActTab 008d __lock 00a0 __imp__InterlockedDecrement@4 00aa ___initialmbcinfo 00db ___removelocaleref 00e2 ___ptlocinfo 00ea ___initiallocinfo 00f7 ___freetlocinfo 0110 __SEH_epilog4 011d __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 0F 84 F8 00 00 00 8B 46 24 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 2C 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 34 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 3C 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 40 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 44 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 48 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 5C 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 7E 68 85 FF 74 1A 57 FF 15 ?? ?? ?? ?? 85 C0 75 0F 81 FF ?? ?? ?? ?? 74 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 57 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 8B 7E 6C 85 FF 74 23 57 E8 ?? ?? ?? ?? 59 3B 3D ?? ?? ?? ?? 74 14 81 FF ?? ?? ?? ?? 74 0C 83 3F 00 75 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 1E 00 00 00 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C2 04 00 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 8B 75 08 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_284_11_0 {
	meta:
		name = "__freeptd"
		size = 110
		refs = "0007 ___flsindex 0017 ___getvalueindex 001d __imp__TlsGetValue@4 0045 _gpFlsSetValue 004b __imp__DecodePointer@4 0055 __freefls@4 0068 __imp__TlsSetValue@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? FF 74 4B 83 7D 08 00 75 27 56 FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? FF D6 85 C0 74 13 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 FF D0 89 45 08 5E 6A 00 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 FF 75 08 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 74 09 6A 00 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_284_14_0 {
	meta:
		name = "__mtinit"
		size = 379
		refs = "0004 ??_C@_1BK@DBDEIDLH@?$AAK?$AAE?$AAR?$AAN?$AAE?$AAL?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 000a __imp__GetModuleHandleW@4 0015 __mtterm 0020 __imp__GetProcAddress@8 0025 ??_C@_08KNHFBNJ@FlsAlloc?$AA@ 002d ??_C@_0M@GDNOONDI@FlsGetValue?$AA@ 0033 _gpFlsAlloc 003a ??_C@_0M@JCPCPOEF@FlsSetValue?$AA@ 0040 _gpFlsGetValue 0047 ??_C@_07PEJMOBNF@FlsFree?$AA@ 004d _gpFlsSetValue 005c __imp__TlsSetValue@8 0061 _gpFlsFree 007e __imp__TlsGetValue@4 0088 __imp__TlsFree@4 0092 ___crtTlsAlloc@4 00a3 __imp__TlsAlloc@0 00a8 ___getvalueindex 00c7 __init_pointers 00d3 __imp__EncodePointer@4 0106 __mtinitlocks 0110 __imp__DecodePointer@4 0115 __freefls@4 0124 ___flsindex 0135 __calloc_crt 015a __initptd 0162 __imp__GetCurrentThreadId@0"
	strings:
		$1 = { 8B FF 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 09 E8 ?? ?? ?? ?? 33 C0 5F C3 56 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 83 3D ?? ?? ?? ?? 00 8B 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 74 16 83 3D ?? ?? ?? ?? 00 74 0D 83 3D ?? ?? ?? ?? 00 74 04 85 C0 75 24 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 F8 FF 0F 84 C1 00 00 00 FF 35 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 B0 00 00 00 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? FF D6 FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF D6 FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF D6 FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF D6 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 63 8B 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D7 FF D0 A3 ?? ?? ?? ?? 83 F8 FF 74 44 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 30 56 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D7 FF D0 85 C0 74 1B 6A 00 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 33 C0 40 EB 07 E8 ?? ?? ?? ?? 33 C0 5E 5F C3 }
	condition:
		$1
}

rule file_285_3_0 {
	meta:
		name = "__mbstrnlen_l"
		size = 238
		refs = "0014 __errno 001f __invalid_parameter_noinfo 0050 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0063 _strnlen 0079 __imp__MultiByteToWideChar@24 00b3 __isleadbyte_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 BF 00 00 00 57 8B 7D 0C 81 FF FF FF FF 7F 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB 4F FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 83 B8 AC 00 00 00 01 75 0E 57 56 E8 ?? ?? ?? ?? 38 5D FC 59 59 EB 72 53 53 57 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 75 1C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF EB 4C 89 5D 08 85 FF 74 31 8A 06 84 C0 74 27 8D 4D F0 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 0B 43 3B DF 73 13 46 80 3E 00 74 09 FF 45 08 46 43 3B DF 72 D3 3B DF 72 04 8B C7 EB 03 8B 45 08 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "__initp_misc_winsig"
		size = 30
		refs = "0009 _ctrlc_action 000e _ctrlbreak_action 0013 _abort_action 0018 _term_action"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_286_1_0 {
	meta:
		name = "_ctrlevent_capture@4"
		size = 156
		refs = "0003 __sehtable$_ctrlevent_capture@4 0008 __SEH_prolog4 0010 __lock 001e _ctrlc_action 002a __imp__DecodePointer@4 003b _ctrlbreak_action 005f __encoded_null 007e __unlock 0095 __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 57 E8 ?? ?? ?? ?? 59 89 7D FC 39 7D 08 75 1D BE ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 C7 45 E0 02 00 00 00 EB 1B BE ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 C7 45 E0 15 00 00 00 3B C7 74 0C 83 F8 01 74 07 E8 ?? ?? ?? ?? 89 06 C7 45 FC FE FF FF FF E8 0B 00 00 00 39 7D E4 75 0E 33 C0 EB 1A 33 FF 57 E8 ?? ?? ?? ?? 59 C3 83 7D E4 01 74 07 FF 75 E0 FF 55 E4 59 33 C0 40 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_286_2_0 {
	meta:
		name = "_siglookup"
		size = 55
		refs = "000a __XcptActTabCount"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 0D ?? ?? ?? ?? 56 39 50 04 74 0F 8B F1 6B F6 0C 03 75 08 83 C0 0C 3B C6 72 EC 6B C9 0C 03 4D 08 5E 3B C1 73 05 39 50 04 74 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_286_6_0 {
	meta:
		name = "_signal"
		size = 576
		refs = "0003 __sehtable$_signal 0008 __SEH_prolog4 006b __getptd_noexit 007a __XcptActTab 0085 __XcptActTabSize 008a __malloc_crt 00a3 _memcpy 00b0 _siglookup 00dc __XcptActTabCount 00fd __lock 0111 _ConsoleCtrlHandler_Installed 011b _ctrlevent_capture@4 0121 __imp__SetConsoleCtrlHandler@8 0135 ___doserrno 013d __imp__GetLastError@0 016b _abort_action 0171 __imp__DecodePointer@4 017f __imp__EncodePointer@4 018c _ctrlbreak_action 01ad _term_action 01ce _ctrlc_action 0208 __unlock 0228 __errno 0233 __invalid_parameter_noinfo 023b __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E0 00 8B 75 0C 8B 5D 08 83 FE 04 0F 84 EF 01 00 00 83 FE 03 0F 84 E6 01 00 00 6A 02 5F 3B DF 0F 84 C7 00 00 00 83 FB 15 0F 84 BE 00 00 00 83 FB 16 0F 84 B5 00 00 00 83 FB 06 0F 84 AC 00 00 00 83 FB 0F 0F 84 A3 00 00 00 83 FB 08 74 0E 83 FB 04 74 09 83 FB 0B 0F 85 A4 01 00 00 E8 ?? ?? ?? ?? 8B F0 85 F6 0F 84 95 01 00 00 BF ?? ?? ?? ?? 39 7E 5C 75 27 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 46 5C 85 C0 0F 84 74 01 00 00 FF 35 ?? ?? ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 0C FF 76 5C 8B D3 E8 ?? ?? ?? ?? 59 85 C0 0F 84 51 01 00 00 8B 48 08 89 4D E4 8B 4D 0C 83 F9 02 0F 84 2E 01 00 00 83 C0 04 EB 1D 89 48 04 83 C0 0C 8B 15 ?? ?? ?? ?? 6B D2 0C 03 56 5C 8D 78 FC 3B FA 0F 83 0C 01 00 00 39 18 74 DF E9 03 01 00 00 6A 00 E8 ?? ?? ?? ?? 59 83 65 FC 00 3B DF 74 05 83 FB 15 75 3E 83 3D ?? ?? ?? ?? 00 75 35 6A 01 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 41 3B C1 75 08 89 0D ?? ?? ?? ?? EB 19 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 89 06 C7 45 E0 01 00 00 00 8B 75 0C 8B C3 2B C7 74 79 83 E8 04 74 11 83 E8 09 74 4E 83 E8 06 74 28 48 0F 85 82 00 00 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 3B F7 74 6F 56 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 61 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 3B F7 74 4E 56 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 40 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 3B F7 74 2D 56 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 1F FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 3B F7 74 0C 56 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 0E 00 00 00 83 7D E0 00 75 11 8B 45 E4 EB 38 8B 5D 08 6A 00 E8 ?? ?? ?? ?? 59 C3 83 FB 01 74 24 83 FB 03 74 1F 83 FB 0D 74 1A 83 FB 0F 7E 05 83 FB 11 7E 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_286_7_0 {
	meta:
		name = "_raise"
		size = 419
		refs = "0003 __sehtable$_raise 0008 __SEH_prolog4 0034 __getptd_noexit 004a _ctrlc_action 005b _siglookup 0077 __errno 0082 __invalid_parameter_noinfo 0089 _abort_action 0095 _ctrlbreak_action 00a1 _term_action 00b4 __imp__DecodePointer@4 00cf __exit 00da __lock 0115 __First_FPE_Indx 011e __Num_FPE 0140 __encoded_null 0170 __unlock 019e __SEH_epilog4"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 89 7D D8 8B 5D 08 83 FB 0B 7F 4B 74 15 8B C3 6A 02 59 2B C1 74 22 2B C1 74 08 2B C1 74 59 2B C1 75 43 E8 ?? ?? ?? ?? 8B F8 89 7D D8 85 FF 75 14 83 C8 FF E9 54 01 00 00 BE ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 55 FF 77 5C 8B D3 E8 ?? ?? ?? ?? 59 8D 70 08 8B 06 EB 51 8B C3 83 E8 0F 74 32 83 E8 06 74 21 48 74 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? EB B9 BE ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 16 BE ?? ?? ?? ?? A1 ?? ?? ?? ?? EB 0A BE ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 45 E4 01 00 00 00 50 FF 15 ?? ?? ?? ?? 89 45 E0 33 C0 83 7D E0 01 0F 84 D6 00 00 00 39 45 E0 75 07 6A 03 E8 ?? ?? ?? ?? 39 45 E4 74 07 50 E8 ?? ?? ?? ?? 59 33 C0 89 45 FC 83 FB 08 74 0A 83 FB 0B 74 05 83 FB 04 75 1B 8B 4F 60 89 4D D4 89 47 60 83 FB 08 75 3E 8B 4F 64 89 4D D0 C7 47 64 8C 00 00 00 83 FB 08 75 2C 8B 0D ?? ?? ?? ?? 89 4D DC 8B 0D ?? ?? ?? ?? 03 0D ?? ?? ?? ?? 39 4D DC 7D 19 8B 4D DC 6B C9 0C 8B 57 5C 89 44 11 08 FF 45 DC EB DD E8 ?? ?? ?? ?? 89 06 C7 45 FC FE FF FF FF E8 15 00 00 00 83 FB 08 75 1F FF 77 64 53 FF 55 E0 59 EB 19 8B 5D 08 8B 7D D8 83 7D E4 00 74 08 6A 00 E8 ?? ?? ?? ?? 59 C3 53 FF 55 E0 59 83 FB 08 74 0A 83 FB 0B 74 05 83 FB 04 75 11 8B 45 D4 89 47 60 83 FB 08 75 06 8B 45 D0 89 47 64 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_287_3_0 {
	meta:
		name = "__mbsnset_l"
		size = 321
		refs = "001c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a __errno 0035 __invalid_parameter_noinfo 005c __strnset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 57 FF 75 14 8D 4D F0 89 75 08 33 DB 33 FF E8 ?? ?? ?? ?? 3B F3 75 28 39 5D 10 74 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 E9 F0 00 00 00 8B 45 F4 39 58 08 75 24 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 0F 84 D0 00 00 00 8B 4D F8 83 61 70 FD E9 C4 00 00 00 8B 4D 0C 8B C1 C1 E8 08 8A D0 3A D3 74 6E 3A CB 75 0F E8 ?? ?? ?? ?? B2 20 C7 00 16 00 00 00 8A CA 39 5D 10 0F 84 8B 00 00 00 8A 06 FF 4D 10 3A C3 74 77 3B FB 75 12 8B 7D F4 0F B6 C0 F6 44 38 1D 04 74 05 33 FF 47 EB 02 33 FF 88 16 46 8A 06 3A C3 74 1D 3B FB 75 12 8B 7D F4 0F B6 C0 F6 44 38 1D 04 74 05 33 FF 47 EB 02 33 FF 88 0E 46 EB 04 C6 46 FF 20 39 5D 10 75 B0 EB 2E 39 5D 10 74 34 8A 06 FF 4D 10 3A C3 74 20 3B FB 75 12 8B 55 F4 0F B6 C0 F6 44 10 1D 04 74 05 33 FF 47 EB 02 33 FF 88 0E 46 39 5D 10 75 D7 3B FB 74 07 38 1E 74 03 C6 06 20 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B 45 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__strnset"
		size = 43
	strings:
		$1 = { 55 8B EC 57 53 8B 7D 08 8B D7 8B 5D 10 33 C0 8B CB E3 12 F2 AE 75 03 83 C1 01 2B D9 8B CB 8B FA 8A 45 0C F3 AA 8B C2 5B 5F C9 C3 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__wcsset_s"
		size = 76
		refs = "0039 __errno 0043 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 85 C9 74 2B 8B 55 0C 85 D2 74 24 66 83 39 00 8B C1 74 13 4A 74 10 66 8B 75 10 66 89 30 83 C0 02 66 83 38 00 75 ED 33 C0 85 D2 75 14 66 89 01 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_291_3_0 {
	meta:
		name = "__ismbcalpha_l"
		size = 187
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0069 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 78 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 83 78 08 00 5F 75 11 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 33 C0 C9 C3 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CB 66 83 7D FE 00 75 3C F7 45 FC 03 01 00 00 74 33 33 C0 40 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD C9 C3 0F B6 C1 8B 4D EC 8B 89 C8 00 00 00 BA 03 01 00 00 66 85 14 41 75 D7 8B 4D F0 F6 44 08 1D 01 75 CD 33 C0 EB CC }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "_modf"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __modf_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_547_0_0 {
	meta:
		name = "_ceil"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __ceil_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "_floor"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __floor_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_293_1_0 {
	meta:
		name = "__modf_pentium4"
		size = 264
		refs = "000a _Bns 0031 _Sign 00a9 _Mantissa 00b1 _Zero 00fc ___libm_error_support"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 C8 66 0F 28 E0 66 0F 28 F0 66 0F 73 F0 01 66 0F 73 D0 35 66 0F 73 D3 34 66 0F 54 25 ?? ?? ?? ?? 66 0F 7E C0 66 0F FA D0 8B 4C 24 0C 66 0F D3 CA 66 0F F3 CA 66 0F 7E DA 3D FF 03 00 00 7C 1E 3D 32 04 00 00 7F 20 66 0F D6 09 F2 0F 5C F1 66 0F 56 F4 66 0F D6 74 24 04 DD 44 24 04 C3 66 0F D6 21 DD 44 24 04 C3 3D FF 07 00 00 F3 0F 7E 44 24 04 74 11 66 0F D6 01 81 FA 00 08 00 00 D9 EE 7C 02 D9 E0 C3 66 0F 28 C8 F2 0F 58 C0 66 0F D6 01 66 0F 54 05 ?? ?? ?? ?? 66 0F C2 05 ?? ?? ?? ?? 04 66 0F C5 C0 00 66 0F 54 C1 66 0F 56 C4 BA EF 03 00 00 83 F8 00 75 0B 66 0F D6 44 24 04 DD 44 24 04 C3 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 }
	condition:
		$1
}

rule file_295_2_0 {
	meta:
		name = "___wcserror"
		size = 228
		refs = "0009 __getptd_noexit 002b __calloc_crt 005c _wcsncat_s 0068 ??_C@_15ELOONFKJ@?$AA?3?$AA?5?$AA?$AA@ 006f _wcscat_s 0080 __invoke_watson 0085 __errno 008c __get_sys_err_msg 0095 _wcslen 00bf _mbstowcs_s 00cb ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 E8 ?? ?? ?? ?? 8B F0 33 DB 3B F3 75 07 33 C0 E9 C4 00 00 00 57 BF 86 00 00 00 39 5E 28 75 18 6A 02 57 E8 ?? ?? ?? ?? 59 59 89 46 28 3B C3 75 07 33 C0 E9 A0 00 00 00 8B 76 28 33 C0 66 89 06 8B 45 08 3B C3 74 36 66 39 18 74 31 68 82 00 00 00 50 57 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 13 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0A 53 53 53 53 53 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 56 89 45 FC E8 ?? ?? ?? ?? 59 59 B9 84 00 00 00 2B C8 51 FF 75 FC 56 E8 ?? ?? ?? ?? 59 8B CF 2B C8 51 56 E8 ?? ?? ?? ?? 59 8D 04 46 50 53 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 B0 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 9D 8B C6 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_295_3_0 {
	meta:
		name = "___wcserror_s"
		size = 159
		refs = "000f __errno 0019 __invalid_parameter_noinfo 003c _wcslen 004c _wcscpy_s 0058 ??_C@_15ELOONFKJ@?$AA?3?$AA?5?$AA?$AA@ 005f _wcscat_s 0072 __invoke_watson 0093 __wcserror_s"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 7D 08 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 7A 8B 75 0C 85 F6 74 E6 53 8B 5D 10 33 C0 66 89 07 85 DB 74 41 66 39 03 74 3C 53 E8 ?? ?? ?? ?? 59 8D 4E F9 3B C1 73 2E 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 13 68 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0C 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 57 E8 ?? ?? ?? ?? 59 2B F0 56 57 E8 ?? ?? ?? ?? 59 8D 04 47 50 E8 ?? ?? ?? ?? 83 C4 0C 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__wstrdate_s"
		size = 201
		refs = "0009 ___security_cookie 0021 __errno 002d __invalid_parameter_noinfo 0054 __imp__GetLocalTime@4 00c3 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 85 F6 74 06 83 7D 0C 00 77 18 E8 ?? ?? ?? ?? 6A 16 59 8B F1 89 08 E8 ?? ?? ?? ?? 8B C6 E9 84 00 00 00 33 C0 83 7D 0C 09 66 89 06 73 09 E8 ?? ?? ?? ?? 6A 22 EB DB 53 57 8D 45 EC 50 FF 15 ?? ?? ?? ?? 0F B7 45 EC 99 6A 64 5B F7 FB 0F B7 4D EE 6A 2F 58 66 89 46 0A 66 89 46 04 33 C0 66 89 46 10 8B C1 6A 0A 59 0F B7 7D F2 8B DA 99 F7 F9 83 C0 30 66 89 06 83 C2 30 66 89 56 02 8B C7 99 F7 F9 5F 83 C0 30 66 89 46 06 83 C2 30 66 89 56 08 8B C3 99 F7 F9 5B 83 C0 30 83 C2 30 66 89 46 0C 66 89 56 0E 33 C0 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_297_1_0 {
	meta:
		name = "__wstrdate"
		size = 28
		refs = "000b __wstrdate_s"
	strings:
		$1 = { 8B FF 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_543_1_0 {
	meta:
		name = "__strdate"
		size = 28
		refs = "000b __strdate_s"
	strings:
		$1 = { 8B FF 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_984_1_0 {
	meta:
		name = "__strtime"
		size = 28
		refs = "000b __strtime_s"
	strings:
		$1 = { 8B FF 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_981_1_0 {
	meta:
		name = "__wstrtime"
		size = 28
		refs = "000b __wstrtime_s"
	strings:
		$1 = { 8B FF 55 8B EC 6A 09 FF 75 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 45 08 59 5D C3 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__difftime64"
		size = 67
		refs = "0035 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 14 00 7C 29 7F 06 83 7D 10 00 72 21 8B 4D 0C 85 C9 7C 1A 8B 45 08 7F 04 85 C0 72 11 2B 45 10 1B 4D 14 89 45 10 89 4D 14 DF 6D 10 5D C3 E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 5D C3 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "__endthreadex"
		size = 31
		refs = "0006 __getptd_noexit 0010 __freeptd 001a __imp__ExitThread@4"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 FF 75 08 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_300_1_0 {
	meta:
		name = "__callthreadstartex"
		size = 65
		refs = "0003 __sehtable$__callthreadstartex 0008 __SEH_prolog4 000d __getptd 001d __endthreadex 002e __XcptFilter 003c __exit"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 70 58 FF 50 54 50 E8 ?? ?? ?? ?? 8B 45 EC 8B 08 8B 09 89 4D E4 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 FF 75 E4 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_300_2_0 {
	meta:
		name = "__threadstartex@4"
		size = 101
		refs = "0007 ___set_flsgetvalue 000c ___get_flsindex 0012 ___fls_getvalue@4 0025 ___fls_setvalue@8 002f __imp__GetLastError@0 0036 __imp__ExitThread@4 003c __imp__GetCurrentThreadId@0 005b __freefls@4 0060 __callthreadstartex"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 2A 8B 75 08 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 0D FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 06 EB 1B 8B 4D 08 8B 51 54 89 50 54 8B 51 58 89 50 58 8B 51 04 51 89 50 04 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_300_3_0 {
	meta:
		name = "__beginthreadex"
		size = 160
		refs = "0011 __errno 001c __invalid_parameter_noinfo 0026 ___set_flsgetvalue 0032 __calloc_crt 003f __getptd 0048 __initptd 006b __threadstartex@4 0077 __imp__CreateThread@24 0081 __imp__GetLastError@0 0089 _free 0094 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 53 57 8B 7D 10 33 DB 85 FF 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 EB 78 56 E8 ?? ?? ?? ?? 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 74 49 E8 ?? ?? ?? ?? FF 70 6C 56 E8 ?? ?? ?? ?? 8B 45 14 83 4E 04 FF 89 46 58 8B 45 1C 59 59 89 7E 54 85 C0 75 03 8D 45 10 50 FF 75 18 56 68 ?? ?? ?? ?? FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 1C FF 15 ?? ?? ?? ?? 8B D8 56 E8 ?? ?? ?? ?? 59 85 DB 74 07 53 E8 ?? ?? ?? ?? 59 33 C0 5E 5F 5B 5D C3 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "__access_s"
		size = 127
		refs = "000e ___doserrno 0015 __errno 001f __invalid_parameter_noinfo 0035 __imp__GetFileAttributesA@4 0040 __imp__GetLastError@0 0046 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1A E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 55 F7 45 0C F9 FF FF FF 75 DD FF 75 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 EB 28 A8 10 75 22 A8 01 74 1E F6 45 0C 02 74 18 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB D1 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_731_0_0 {
	meta:
		name = "__waccess_s"
		size = 127
		refs = "000e ___doserrno 0015 __errno 001f __invalid_parameter_noinfo 0035 __imp__GetFileAttributesW@4 0040 __imp__GetLastError@0 0046 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 08 75 1A E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 55 F7 45 0C F9 FF FF FF 75 DD FF 75 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 EB 28 A8 10 75 22 A8 01 74 1E F6 45 0C 02 74 18 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB D1 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_304_1_0 {
	meta:
		name = "__access"
		size = 24
		refs = "000c __access_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 F7 D8 59 1B C0 5D C3 }
	condition:
		$1
}

rule file_731_1_0 {
	meta:
		name = "__waccess"
		size = 24
		refs = "000c __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 F7 D8 59 1B C0 5D C3 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "_wcsncpy_s"
		size = 205
		refs = "002e __errno 0038 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 53 8B 5D 14 56 57 85 DB 75 10 85 D2 75 10 39 55 0C 75 12 33 C0 5F 5E 5B 5D C3 85 D2 74 07 8B 7D 0C 85 FF 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB DD 85 DB 75 07 33 C0 66 89 02 EB D0 8B 4D 10 85 C9 75 07 33 C0 66 89 02 EB D4 8B C2 83 FB FF 75 18 8B F2 2B F1 0F B7 01 66 89 04 0E 83 C1 02 66 85 C0 74 27 4F 75 EE EB 22 8B F1 2B F2 0F B7 0C 06 66 89 08 83 C0 02 66 85 C9 74 06 4F 74 03 4B 75 EB 85 DB 75 05 33 C9 66 89 08 85 FF 0F 85 79 FF FF FF 33 C0 83 FB FF 75 10 8B 4D 0C 6A 50 66 89 44 4A FE 58 E9 64 FF FF FF 66 89 02 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 E9 6A FF FF FF }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__flsbuf"
		size = 356
		refs = "000c __fileno 001c __errno 007a ___iob_func 0095 __isatty 00a0 __getbuf 00d0 __write 0104 ___pioinfo 010b ___badioinfo 011b __lseeki64"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 75 0C 56 E8 ?? ?? ?? ?? 89 45 0C 8B 46 0C 59 A8 82 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4E 0C 20 83 C8 FF E9 2F 01 00 00 A8 40 74 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB E3 53 33 DB A8 01 74 16 89 5E 04 A8 10 0F 84 87 00 00 00 8B 4E 08 83 E0 FE 89 0E 89 46 0C 8B 46 0C 83 E0 EF 83 C8 02 89 46 0C 89 5E 04 89 5D FC A9 0C 01 00 00 75 2C E8 ?? ?? ?? ?? 83 C0 20 3B F0 74 0C E8 ?? ?? ?? ?? 83 C0 40 3B F0 75 0D FF 75 0C E8 ?? ?? ?? ?? 59 85 C0 75 07 56 E8 ?? ?? ?? ?? 59 F7 46 0C 08 01 00 00 57 0F 84 80 00 00 00 8B 46 08 8B 3E 8D 48 01 89 0E 8B 4E 18 2B F8 49 89 4E 04 3B FB 7E 1D 57 50 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC EB 4D 83 C8 20 89 46 0C 83 C8 FF EB 79 8B 4D 0C 83 F9 FF 74 1B 83 F9 FE 74 16 8B C1 83 E0 1F 8B D1 C1 FA 05 C1 E0 06 03 04 95 ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 04 20 74 14 6A 02 53 53 51 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 74 25 8B 46 08 8A 4D 08 88 08 EB 16 33 FF 47 57 8D 45 08 50 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 39 7D FC 74 09 83 4E 0C 20 83 C8 FF EB 08 8B 45 08 25 FF 00 00 00 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "__alldiv"
		size = 170
	strings:
		$1 = { 57 56 53 33 FF 8B 44 24 14 0B C0 7D 14 47 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 18 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B D3 EB 41 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 07 3B 44 24 10 76 01 4E 33 D2 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5B 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_309_3_0 {
	meta:
		name = "__mbsicoll_l"
		size = 162
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 0027 __invalid_parameter_noinfo 0055 __stricoll_l 0078 ___crtCompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 61 39 5D 0C 74 D8 8B 45 F4 39 58 08 75 13 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 35 FF 70 04 6A FF FF 75 0C 6A FF FF 75 08 68 01 10 00 00 FF 70 0C 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9B 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "__mbccpy_l"
		size = 28
		refs = "0013 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_310_1_0 {
	meta:
		name = "__mbccpy"
		size = 27
		refs = "0012 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "__is_LFH_enabled"
		size = 51
		refs = "0016 __crtheap 001c __imp__HeapQueryInformation@20"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 4D FC FF 6A 00 6A 04 8D 45 FC 50 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 0B 83 7D FC 02 75 05 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_311_1_0 {
	meta:
		name = "__expand"
		size = 186
		refs = "000d __errno 0018 __invalid_parameter_noinfo 0046 __crtheap 004c __imp__HeapSize@12 0060 __imp__HeapReAlloc@16 008a __imp__HeapQueryInformation@20 00a6 __imp__GetLastError@0 00ac __get_errno_from_oserr"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 14 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 C9 C3 56 8B 75 0C 83 FE E0 76 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 7F 85 F6 75 01 46 53 57 FF 75 08 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 56 FF 75 08 8B D8 6A 10 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 49 81 FB 00 40 00 00 77 2B 3B F3 77 27 83 4D FC FF 50 6A 04 8D 45 FC 50 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 0B 83 7D FC 02 75 05 8B 7D 08 EB 16 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 06 8B C7 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_313_3_0 {
	meta:
		name = "__wtof_l"
		size = 136
		refs = "0009 ___security_cookie 001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 __errno 0031 __invalid_parameter_noinfo 0050 _iswctype 0064 __wfltin2 0082 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 0C 8B 75 08 8D 4D D4 E8 ?? ?? ?? ?? 85 F6 75 24 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 7D E0 00 74 07 8B 45 DC 83 60 70 FD D9 EE EB 35 83 C6 02 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 EC 8D 45 D4 50 8D 45 E4 56 50 E8 ?? ?? ?? ?? DD 40 10 83 C4 0C 80 7D E0 00 74 07 8B 45 DC 83 60 70 FD 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "_printf"
		size = 167
		refs = "0003 __sehtable$_printf 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0030 ___iob_func 003d __lock_file2 004f __stbuf 0067 __output_l 0078 __ftbuf 008f __SEH_epilog4 00a0 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5F E8 ?? ?? ?? ?? 6A 20 5B 03 C3 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 75 FC E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 59 8B F8 8D 45 0C 50 56 FF 75 08 E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 89 45 E4 E8 ?? ?? ?? ?? 03 C3 50 57 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_919_0_0 {
	meta:
		name = "_wprintf"
		size = 167
		refs = "0003 __sehtable$_wprintf 0008 __SEH_prolog4 001b __errno 0026 __invalid_parameter_noinfo 0030 ___iob_func 003d __lock_file2 004f __stbuf 0067 __woutput_l 0078 __ftbuf 008f __SEH_epilog4 00a0 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 5F E8 ?? ?? ?? ?? 6A 20 5B 03 C3 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 75 FC E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 59 8B F8 8D 45 0C 50 56 FF 75 08 E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 89 45 E4 E8 ?? ?? ?? ?? 03 C3 50 57 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_314_3_0 {
	meta:
		name = "_printf_s"
		size = 24
		refs = "000f __vprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_538_11_0 {
	meta:
		name = "__cprintf"
		size = 24
		refs = "000f __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_12_0 {
	meta:
		name = "__cprintf_p"
		size = 24
		refs = "000f __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_375_11_0 {
	meta:
		name = "__cprintf_s"
		size = 24
		refs = "000f __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_337_10_0 {
	meta:
		name = "__cwprintf"
		size = 24
		refs = "000f __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_923_10_0 {
	meta:
		name = "__cwprintf_p"
		size = 24
		refs = "000f __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_667_10_0 {
	meta:
		name = "__cwprintf_s"
		size = 24
		refs = "000f __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_314_5_0 {
	meta:
		name = "__printf_p"
		size = 24
		refs = "000f __vprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_919_5_0 {
	meta:
		name = "__wprintf_p"
		size = 24
		refs = "000f __vwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_919_3_0 {
	meta:
		name = "_wprintf_s"
		size = 24
		refs = "000f __vwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 0C 50 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_314_6_0 {
	meta:
		name = "__set_printf_count_output"
		size = 42
		refs = "0007 ___security_cookie 0015 ___enable_percent_n"
	strings:
		$1 = { 8B FF 55 8B EC 8B 0D ?? ?? ?? ?? 8B 55 08 83 C9 01 33 C0 39 0D ?? ?? ?? ?? 0F 94 C0 F7 DA 1B D2 23 D1 89 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_314_7_0 {
	meta:
		name = "__get_printf_count_output"
		size = 22
		refs = "0001 ___security_cookie 000c ___enable_percent_n"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 C8 01 33 C9 39 05 ?? ?? ?? ?? 0F 94 C1 8B C1 C3 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "_exp"
		size = 60
		refs = "0002 ___use_sse2_mathfcns 0037 __exp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 6E 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 41 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_315_1_0 {
	meta:
		name = "__CIexp"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIexp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 3C 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 0F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "_evaluate"
		size = 76
		refs = "000e __invalid_parameter_noinfo 0014 __real@bff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 85 C9 7E 04 85 D2 7F 0D E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 5D C3 DD 04 C8 DD 45 08 EB 05 DD 04 C8 DE C2 49 DC C9 85 C9 7F F4 DD 00 8D 42 FF DE C2 DD 04 D6 D8 C9 85 C0 7E 06 DC 04 C6 48 EB F4 DD D9 DC 06 DE F9 5D C3 }
	condition:
		$1
}

rule file_316_1_0 {
	meta:
		name = "__j0"
		size = 368
		refs = "001f __real@401e000000000000 002f _J0p 0052 _J0q 007c __real@4020000000000000 0081 _P0p 00ad _P0q 00ce _Q0p 00f4 _Q0q 0121 __real@3fe921fb54442d18 012f _cos 0140 _sin 0157 __real@400921fb54442d18 015d __real@4000000000000000 0165 _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 83 EC 20 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 05 D9 E0 DD 55 08 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 4E D9 C0 B8 ?? ?? ?? ?? DE C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA DD 05 ?? ?? ?? ?? DE C2 DE F1 C9 C3 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 5D F8 DD 45 F8 DC 4D F8 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DE F9 DD 5D E8 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D E0 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DD 5D E8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 45 E0 DC 4D F8 DE C9 DC 6D E8 DD 5D E0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 C9 C3 }
	condition:
		$1
}

rule file_316_2_0 {
	meta:
		name = "__j1"
		size = 389
		refs = "002a __real@401e000000000000 003a _J1p 005d _J1q 008e __real@4020000000000000 0093 _P1p 00bf _P1q 00e0 _Q1p 0106 _Q1q 0133 __real@4002d97c7f3321d2 0141 _cos 0152 _sin 0169 __real@400921fb54442d18 016f __real@4000000000000000 0177 _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 D9 EE C7 45 FC 01 00 00 00 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 09 83 4D FC FF D9 E0 DD 55 08 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 55 D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA DD 05 ?? ?? ?? ?? DE C2 DE F1 DB 45 FC DE CA DE C9 C9 C3 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 5D F4 DD 45 F4 DC 4D F4 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DE F9 DD 5D E4 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D DC DC 25 ?? ?? ?? ?? DD 5D EC DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DC 4D E4 DD 5D E4 DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DD 45 DC DC 4D F4 DE C9 DC 6D E4 DD 5D DC DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DA 4D FC 59 59 DC 4D DC C9 C3 }
	condition:
		$1
}

rule file_316_3_0 {
	meta:
		name = "__jn"
		size = 319
		refs = "002a __j0 003e __j1 006b _fabs"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 56 8B 75 08 85 F6 79 0F DD 45 0C F7 DE D9 E0 89 75 08 DD 5D 0C 85 F6 DD 45 0C 75 0F 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 07 01 00 00 83 FE 01 75 0F 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 F3 00 00 00 D9 EE D9 C0 DD EA DF E0 DD D9 F6 C4 44 0F 8B E2 00 00 00 DD D8 51 DB 45 08 51 DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DC 5D F4 59 03 F6 59 DF E0 DD 45 0C F6 C4 41 75 54 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? D9 C0 59 D9 C9 59 DC C0 6A 04 58 89 45 FC DC 75 0C DC 65 F4 3B F0 75 09 DD D9 E9 85 00 00 00 D9 C9 D9 C0 DB 45 FC 83 45 FC 02 DE CA D9 C9 DC 75 0C DE E2 39 75 FC 75 E7 DD D8 EB 68 D9 C0 8D 46 24 D8 C9 89 75 08 D9 EE 89 45 FC 3B C6 7E 10 DA 6D FC 83 6D FC 02 D9 C1 DE F1 39 75 FC 7F F0 DD D9 83 C6 FE DA 6D 08 89 75 FC D9 C1 DE F1 DD 55 EC D9 E8 DB 45 FC 83 6D FC 02 D8 F3 DE E2 D9 C9 DD 5D F4 74 0B DD 45 F4 DB 45 FC DC 4D F4 EB E6 51 DD D8 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D EC DC 75 F4 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_316_4_0 {
	meta:
		name = "_domain_err"
		size = 54
		refs = "0010 __ctrlfp 002d __except1"
	strings:
		$1 = { 8B FF 55 8B EC 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? DD 45 14 59 59 50 83 EC 10 DD 5C 24 08 DD 45 0C DD 1C 24 FF 75 08 6A 08 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_316_5_0 {
	meta:
		name = "__y0"
		size = 433
		refs = "001a __d_ind 002b _domain_err 0036 __real@401e000000000000 0046 _Y0p 0069 _Y0q 0098 __j0 009e __real@3fe45f306dc9c883 00ac _log 00bd __real@4020000000000000 00c2 _P0p 00ee _P0q 010f _Q0p 0135 _Q0q 0162 __real@3fe921fb54442d18 0170 _cos 0186 _sin 0198 __real@400921fb54442d18 019e __real@4000000000000000 01a6 _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 83 EC 20 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 22 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 75 78 D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D F8 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DD 5D F0 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F0 DC 45 F8 E9 F2 00 00 00 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 5D F8 DD 45 F8 DC 4D F8 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DE F9 DD 5D E0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D E8 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 45 E8 DC 4D F8 DE C9 DD 5D E8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 DC 45 E8 DD 5D E0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 C9 C3 }
	condition:
		$1
}

rule file_316_6_0 {
	meta:
		name = "__y1"
		size = 449
		refs = "001a __d_ind 002b _domain_err 0036 __real@401e000000000000 004a _Y1p 006d _Y1q 009c __j1 00aa _log 00ba __real@3fe45f306dc9c883 00cd __real@4020000000000000 00d2 _P1p 00fe _P1q 011f _Q1p 0145 _Q1q 0172 __real@4002d97c7f3321d2 0180 _cos 0196 _sin 01a8 __real@400921fb54442d18 01ae __real@4000000000000000 01b6 _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 83 EC 20 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 23 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 01 0F 85 84 00 00 00 D9 C0 B8 ?? ?? ?? ?? D8 C9 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? D8 CA DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D F8 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F0 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F0 D9 E8 DC 75 08 DE E9 DC 0D ?? ?? ?? ?? DD 45 F8 DC 4D 08 DE C1 E9 F2 00 00 00 DD 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D8 F1 DD 5D F8 DD 45 F8 DC 4D F8 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? DE F9 DD 5D E0 DD 05 ?? ?? ?? ?? D8 C9 DC 00 83 E8 08 D8 C9 3D ?? ?? ?? ?? 7F F2 DC 05 ?? ?? ?? ?? B8 ?? ?? ?? ?? D9 C1 DC 0D ?? ?? ?? ?? DC 00 83 E8 08 D8 CA 3D ?? ?? ?? ?? 7F F2 DD DA 51 DD 05 ?? ?? ?? ?? 51 DE C2 DE F1 DD 5D E8 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 45 E8 DC 4D F8 DE C9 DD 5D E8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 DC 45 E8 DD 5D E0 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E0 59 59 C9 C3 }
	condition:
		$1
}

rule file_316_7_0 {
	meta:
		name = "__yn"
		size = 200
		refs = "001a __d_ind 002b _domain_err 0059 __y0 0065 __y1 0085 __real@4000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC D9 EE 83 EC 14 DD 45 0C D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 24 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 53 33 DB 43 83 7D 08 00 89 5D FC 7D 10 F7 5D 08 84 5D 08 74 04 83 4D FC FF 83 7D 08 00 51 51 DD 1C 24 75 07 E8 ?? ?? ?? ?? EB 0A 39 5D 08 75 0C E8 ?? ?? ?? ?? DA 4D FC 59 59 EB 55 E8 ?? ?? ?? ?? DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B 45 08 DC 75 0C 59 59 89 5D 10 3B C3 7F 06 DD D9 EB 21 D9 C9 DB 45 10 FF 45 10 D8 C9 D8 CA DC 65 F4 DD 5D EC D9 C9 DD 5D F4 DD 45 EC 39 45 10 7C E1 DD D8 DD D8 DB 45 FC DC 4D EC 5B C9 C3 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "_fabs"
		size = 187
		refs = "001a __ctrlfp 003b __sptype 0050 __real@3ff0000000000000 0066 __except1 0077 __handle_qnan1"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 D9 EE 56 57 DD 5D F8 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 59 59 0F B7 4D 0E 8B F8 B8 F0 7F 00 00 23 C8 66 3B C8 75 68 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 48 59 59 74 4A 48 74 39 48 DD 45 08 57 74 21 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 15 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 48 51 51 DD 1C 24 6A 15 E8 ?? ?? ?? ?? 83 C4 10 EB 37 56 57 E8 ?? ?? ?? ?? DD 45 08 D9 E0 EB 27 56 57 E8 ?? ?? ?? ?? DD 45 08 EB 1B 8B 45 0C 25 FF FF FF 7F 89 45 FC 8B 45 08 56 57 89 45 F8 E8 ?? ?? ?? ?? DD 45 F8 59 59 5F 5E C9 C3 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "__ftell_nolock"
		size = 404
		refs = "0014 __errno 001f __invalid_parameter_noinfo 002e __fileno 0045 __lseek 0083 ___pioinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 57 8B 7D 08 33 DB 3B FB 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 65 01 00 00 56 57 E8 ?? ?? ?? ?? 8B F0 59 89 75 F8 39 5F 04 7D 03 89 5F 04 6A 01 53 56 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 3B C3 0F 8C FB 00 00 00 8B 57 0C F7 C2 08 01 00 00 75 08 2B 47 04 E9 25 01 00 00 8B 07 8B 4F 08 8B D8 2B D9 89 5D F4 F6 C2 03 74 3C 8B D6 C1 FA 05 8B 14 95 ?? ?? ?? ?? 83 E6 1F C1 E6 06 F6 44 32 04 80 74 16 8B D1 3B D0 73 10 8B F0 80 3A 0A 75 01 43 42 3B D6 72 F5 89 5D F4 83 7D FC 00 75 1B 8B C3 E9 D8 00 00 00 84 D2 78 EF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 87 00 00 00 F6 47 0C 01 0F 84 B4 00 00 00 8B 57 04 85 D2 75 08 21 55 F4 E9 A5 00 00 00 8B 5D F8 8B 75 F8 2B C1 03 C2 C1 FB 05 83 E6 1F 8D 1C 9D ?? ?? ?? ?? 89 45 08 8B 03 C1 E6 06 F6 44 30 04 80 74 79 6A 02 6A 00 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 3B 45 FC 75 20 8B 47 08 8B 4D 08 03 C8 EB 09 80 38 0A 75 03 FF 45 08 40 3B C1 72 F3 F7 47 0C 00 20 00 00 EB 40 6A 00 FF 75 FC FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 79 05 83 C8 FF EB 38 B8 00 02 00 00 39 45 08 77 10 8B 4F 0C F6 C1 08 74 08 F7 C1 00 04 00 00 74 03 8B 47 18 89 45 08 8B 03 F6 44 30 04 04 74 03 FF 45 08 8B 45 08 29 45 FC 8B 45 F4 03 45 FC 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_320_1_0 {
	meta:
		name = "_ftell"
		size = 101
		refs = "0003 __sehtable$_ftell 0008 __SEH_prolog4 0019 __errno 0024 __invalid_parameter_noinfo 0031 __lock_file 003e __ftell_nolock 0056 __SEH_epilog4 005f __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 45 08 0F 95 C0 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 28 FF 75 08 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_321_3_0 {
	meta:
		name = "__ismbcspace_l"
		size = 196
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0067 ___crtGetStringTypeA 009e __isctype_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 6B 33 C0 57 66 89 45 FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 33 DB 88 4D 09 5F 39 58 08 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 70 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 6A 01 53 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CF 66 39 5D FE 75 0B F6 45 FC 08 74 05 33 C0 40 EB 02 33 C0 38 5D F8 EB 2E 8B 45 EC 83 B8 AC 00 00 00 01 7E 11 8D 45 EC 50 6A 08 51 E8 ?? ?? ?? ?? 83 C4 0C EB 0D 8B 80 C8 00 00 00 0F B7 04 48 83 E0 08 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_322_3_0 {
	meta:
		name = "__mbsnbset_l"
		size = 224
		refs = "0017 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002d __strnset 0056 __errno 0061 __invalid_parameter_noinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B 75 08 FF 75 14 8D 4D F0 89 75 08 E8 ?? ?? ?? ?? 8B 45 F4 33 DB 39 58 08 75 24 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 0F 84 9F 00 00 00 8B 4D F8 83 61 70 FD E9 93 00 00 00 57 8B 7D 10 3B F3 75 24 3B FB 74 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 66 8B 45 0C 8B C8 C1 E9 08 8A D1 3A D3 74 45 8A C8 3A C3 75 2C E8 ?? ?? ?? ?? B2 20 C7 00 16 00 00 00 8A CA EB 1B 38 1E 74 2E 8D 47 FF 83 EF 02 85 C0 74 13 38 5E 01 74 0E 88 16 88 4E 01 83 C6 02 3B FB 75 E1 EB 11 C6 06 20 EB 0C 4F 38 1E 74 07 88 06 46 3B FB 75 F4 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B 45 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "__stbuf"
		size = 156
		refs = "000b __fileno 0011 __isatty 001c ___iob_func 003c __cflush 004e __stdbuf 005e __malloc_crt"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 7C E8 ?? ?? ?? ?? 83 C0 20 3B F0 75 04 33 C0 EB 0F E8 ?? ?? ?? ?? 83 C0 40 3B F0 75 60 33 C0 40 FF 05 ?? ?? ?? ?? F7 46 0C 0C 01 00 00 75 4E 53 57 8D 3C 85 ?? ?? ?? ?? 83 3F 00 BB 00 10 00 00 75 20 53 E8 ?? ?? ?? ?? 59 89 07 85 C0 75 13 8D 46 14 6A 02 89 46 08 89 06 58 89 46 18 89 46 04 EB 0D 8B 3F 89 7E 08 89 3E 89 5E 18 89 5E 04 81 4E 0C 02 11 00 00 33 C0 5F 40 5B EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_323_1_0 {
	meta:
		name = "__ftbuf"
		size = 52
		refs = "001a __flush"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 27 56 8B 75 0C F7 46 0C 00 10 00 00 74 19 56 E8 ?? ?? ?? ?? 81 66 0C FF EE FF FF 83 66 18 00 83 26 00 83 66 08 00 59 5E 5D C3 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 18
		refs = "000e ?terminate@@YAXXZ"
	strings:
		$1 = { 8B 00 81 38 63 73 6D E0 74 03 33 C0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_324_1_0 {
	meta:
		name = "?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
		size = 94
		refs = "0003 __sehtable$?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z 0008 __SEH_prolog4 0048 ?terminate@@YAXXZ 0057 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 4D 10 78 3A 8B 4D 08 2B 4D 0C 89 4D 08 FF 55 14 EB ED 8B 45 EC 89 45 E4 8B 45 E4 8B 00 89 45 E0 8B 45 E0 81 38 63 73 6D E0 74 0B C7 45 DC 00 00 00 00 8B 45 DC C3 E8 ?? ?? ?? ?? 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C2 10 00 }
	condition:
		$1
}

rule file_324_2_0 {
	meta:
		name = "??_M@YGXPAXIHP6EX0@Z@Z"
		size = 99
		refs = "0003 __sehtable$??_M@YGXPAXIHP6EX0@Z@Z 0008 __SEH_prolog4 0044 __SEH_epilog4 005e ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 8B 75 0C 8B C6 0F AF 45 10 01 45 08 83 65 FC 00 FF 4D 10 78 0B 29 75 08 8B 4D 08 FF 55 14 EB F0 C7 45 E4 01 00 00 00 C7 45 FC FE FF FF FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 10 00 83 7D E4 00 75 11 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "__byteswap_ulong"
		size = 45
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 56 8B C1 BA 00 FF 00 00 23 C2 8B F1 C1 E6 10 03 C6 8B F1 C1 EE 08 23 F2 C1 E0 08 03 C6 C1 E9 18 03 C1 5E 5D C3 }
	condition:
		$1
}

rule file_325_1_0 {
	meta:
		name = "__byteswap_ushort"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8B C1 C1 E0 08 66 C1 E9 08 66 03 C1 5D C3 }
	condition:
		$1
}

rule file_325_2_0 {
	meta:
		name = "__byteswap_uint64"
		size = 155
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 53 56 8B 75 08 57 33 D2 8B FE 8B C6 25 00 FF 00 00 8B D9 0F A4 FB 10 C1 E7 10 03 C7 13 D3 0F A4 C2 10 33 DB C1 E0 10 8B FE 81 E7 00 00 FF 00 03 C7 13 D3 0F A4 C2 10 8B FE C1 E0 10 BE 00 00 00 FF 23 FE 03 C7 13 D3 0F A4 C2 08 8B F9 C1 EF 08 81 E7 00 FF 00 00 C1 E0 08 03 C7 8B 7D 08 13 D3 8B D9 0F AC DF 08 23 FE 33 F6 03 C7 8B 7D 08 13 D6 8B F1 0F AC F7 18 8B F7 81 E6 00 00 FF 00 33 FF 03 C6 13 D7 C1 E9 18 33 F6 03 C1 5F 13 D6 5E 5B 5D C3 }
	condition:
		$1
}

rule file_326_1_0 {
	meta:
		name = "_init_namebuf"
		size = 170
		refs = "001a _tmpnam_s_buf 0021 _tmpfile_buf 002b _tmpnam_buf 0037 ??_C@_01KICIPPFI@?2?$AA@ 003e _strcpy_s 0077 __getpid 007d __ultoa_s 0089 ??_C@_01LFCBOECM@?4?$AA@ 0090 _strcat_s 00a1 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 53 56 57 33 DB 33 FF 2B C3 74 17 48 74 0A 48 75 1A BE ?? ?? ?? ?? EB 05 BE ?? ?? ?? ?? 6A 12 5F EB 0C BE ?? ?? ?? ?? 6A 0E EB F4 8B 75 08 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 52 8D 46 01 8A 48 FF 80 F9 5C 74 09 80 F9 2F 74 04 C6 00 5C 40 83 7D 08 01 75 05 C6 00 74 EB 03 C6 00 73 40 8B CE 2B C8 6A 20 03 CF 51 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 13 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0A 53 53 53 53 53 E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_326_2_0 {
	meta:
		name = "_genfname"
		size = 152
		refs = "0009 ___security_cookie 001a __mbsrchr 0031 __invalid_parameter_noinfo 0042 _strtoul 005b @__security_check_cookie@4 006b __ultoa_s 0082 _strcpy_s 0093 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B F9 6A 2E 57 E8 ?? ?? ?? ?? 8D 70 01 59 59 3B F7 72 09 8B C6 2B C7 39 45 08 77 0A E8 ?? ?? ?? ?? 83 C8 FF EB 19 53 6A 20 33 DB 53 56 E8 ?? ?? ?? ?? 83 C4 0C 40 3B 45 0C 72 12 83 C8 FF 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 6A 20 6A 08 8D 4D F4 51 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 17 8D 45 F4 2B FE 03 7D 08 50 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 C5 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_326_4_0 {
	meta:
		name = "__tmpnam_helper"
		size = 316
		refs = "0003 __sehtable$__tmpnam_helper 0008 __SEH_prolog4 0012 __errno 001e __mtinitlocknum 003b __lock 0049 _tmpnam_buf 0052 _tmpnam_s_buf 0061 _init_namebuf 006f _genfname 0080 __access_s 0092 __getptd_noexit 00ad __malloc_crt 00ca __invoke_watson 00d5 _strlen 00f5 _strcpy_s 0129 __unlock 0137 __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 E8 ?? ?? ?? ?? 8B 00 89 45 E0 6A 02 E8 ?? ?? ?? ?? 59 85 C0 75 11 8B 45 18 89 18 E8 ?? ?? ?? ?? 8B 00 E9 FE 00 00 00 6A 02 E8 ?? ?? ?? ?? 59 89 5D FC 39 5D 10 75 09 BF ?? ?? ?? ?? 6A 0E EB 07 BF ?? ?? ?? ?? 6A 12 5E 38 1F 75 0B FF 75 10 E8 ?? ?? ?? ?? 59 EB 15 FF 75 14 56 8B CF E8 ?? ?? ?? ?? 59 85 C0 59 0F 85 83 00 00 00 53 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 DE 8B 75 08 3B F3 75 3D E8 ?? ?? ?? ?? 8B F0 3B F3 75 09 C7 45 E4 0C 00 00 00 EB 5B 39 5E 2C 75 0F 6A 0E E8 ?? ?? ?? ?? 59 89 46 2C 3B C3 74 E3 8B 76 2C 89 75 08 57 6A 0E EB 2F 53 53 53 53 53 E8 ?? ?? ?? ?? 39 5D 10 74 1C 57 E8 ?? ?? ?? ?? 59 3B 45 0C 72 10 C7 45 E4 22 00 00 00 39 5D 0C 74 15 88 1E EB 11 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 75 C4 C7 45 FC FE FF FF FF E8 1A 00 00 00 8B 45 18 8B 4D 08 89 08 8B 75 E4 E8 ?? ?? ?? ?? 3B F3 74 0F 89 30 EB 10 33 DB 6A 02 E8 ?? ?? ?? ?? 59 C3 8B 4D E0 89 08 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_326_5_0 {
	meta:
		name = "_tmpnam_s"
		size = 59
		refs = "000c __errno 0017 __invalid_parameter_noinfo 0032 __tmpnam_helper"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 8D 45 08 50 68 FF FF FF 7F 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_913_4_0 {
	meta:
		name = "__wtmpnam_s"
		size = 59
		refs = "000c __errno 0017 __invalid_parameter_noinfo 0032 __wtmpnam_helper"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 6A 16 58 5D C3 8D 45 08 50 68 FF FF FF 7F 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_326_6_0 {
	meta:
		name = "_tmpnam"
		size = 39
		refs = "001b __tmpnam_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 50 68 FF 7F 00 00 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_913_5_0 {
	meta:
		name = "__wtmpnam"
		size = 39
		refs = "001b __wtmpnam_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 50 68 FF 7F 00 00 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_326_7_0 {
	meta:
		name = "__tmpfile_helper"
		size = 499
		refs = "0003 __sehtable$__tmpfile_helper 0008 __SEH_prolog4 0023 __errno 002d __invalid_parameter_noinfo 003b __mtinitlocknum 0053 __lock 005c _tmpfile_buf 006a ??_C@_01KICIPPFI@?2?$AA@ 0072 _strcpy_s 00b7 __getpid 00bd __ultoa_s 00c9 ??_C@_01LFCBOECM@?4?$AA@ 00d1 _strcat_s 00e2 __invoke_watson 00f0 _genfname 00ff __getstream 013e __sopen_s 0177 __strdup 0189 __close 01ad __SEH_epilog4 01bb __commode 01e5 __unlock_file 01ed __unlock"
	strings:
		$1 = { 6A 1C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D D4 89 5D D8 33 C9 8B 45 08 3B C3 0F 95 C1 3B CB 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 74 01 00 00 89 18 6A 02 E8 ?? ?? ?? ?? 59 85 C0 75 0C E8 ?? ?? ?? ?? 8B 00 E9 5C 01 00 00 6A 02 E8 ?? ?? ?? ?? 59 89 5D FC BE ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 7D 68 ?? ?? ?? ?? 6A 12 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 75 5F C7 45 E4 ?? ?? ?? ?? A0 ?? ?? ?? ?? 3C 5C 74 12 3C 2F 74 0E C6 05 ?? ?? ?? ?? 5C C7 45 E4 ?? ?? ?? ?? 8B 45 E4 C6 00 74 FF 45 E4 6A 20 B8 ?? ?? ?? ?? 2B 45 E4 50 FF 75 E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 3B C3 75 14 68 ?? ?? ?? ?? 6A 12 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 22 53 53 53 53 53 E8 ?? ?? ?? ?? 68 FF FF FF 7F 6A 12 8B CE E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 D6 00 00 00 E8 ?? ?? ?? ?? 8B F8 89 7D DC 3B FB 75 09 C7 45 D4 18 00 00 00 EB 7B C7 45 D8 01 00 00 00 E8 ?? ?? ?? ?? 8B 18 E8 ?? ?? ?? ?? 83 20 00 68 80 01 00 00 FF 75 0C 68 42 85 00 00 56 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 14 83 F8 11 75 14 68 FF FF FF 7F 6A 12 8B CE E8 ?? ?? ?? ?? 59 59 85 C0 74 CD E8 ?? ?? ?? ?? 83 38 00 75 07 E8 ?? ?? ?? ?? 89 18 83 7D E0 FF 74 19 56 E8 ?? ?? ?? ?? 59 89 47 1C 33 C9 3B C1 75 2D FF 75 E0 E8 ?? ?? ?? ?? 59 33 DB C7 45 FC FE FF FF FF E8 42 00 00 00 8B 75 D4 3B F3 74 07 E8 ?? ?? ?? ?? 89 30 8B C6 E8 ?? ?? ?? ?? C3 89 4F 04 89 0F 89 4F 08 A1 ?? ?? ?? ?? 0D 80 00 00 00 89 47 0C 8B 45 E0 89 47 10 8B 45 08 89 38 EB BA 8B 7D DC EB B7 8B 7D DC 33 DB 39 5D D8 74 07 57 E8 ?? ?? ?? ?? 59 6A 02 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_326_8_0 {
	meta:
		name = "_tmpfile"
		size = 28
		refs = "0011 __tmpfile_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 65 FC 00 8D 45 FC 6A 40 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 C9 C3 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "__cputs"
		size = 128
		refs = "0003 __sehtable$__cputs 0008 __SEH_prolog4 001e ___doserrno 0025 __errno 0030 __invalid_parameter_noinfo 003c __lock 0055 __putch_nolock 0072 __SEH_epilog4 007a __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 39 5D 08 0F 95 C0 3B C3 75 1C E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 38 6A 03 E8 ?? ?? ?? ?? 59 89 5D FC 8B 45 08 8A 00 3A C3 74 15 0F BE C0 FF 45 08 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 E5 09 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "_fast_error_exit"
		size = 41
		refs = "0007 ___error_mode 000f __FF_MSGBANNER 0017 __NMSG_WRITE 0021 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_329_2_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 365
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 0012 __imp__GetStartupInfoW@4 001a __NoHeapEnableTerminationOnCorruption 0027 __imp__HeapSetInformation@16 0033 ___ImageBase 0075 __heap_init 0080 _fast_error_exit 0086 __mtinit 0097 __RTC_Initialize 009f __ioinit 00aa __amsg_exit 00b1 __imp__GetCommandLineA@0 00b6 __acmdln 00bb ___crtGetEnvironmentStringsA 00c0 __aenvptr 00c5 __setargv 00d6 __setenvp 00e9 __cinit 00fa __wincmdln 0116 _WinMain@16 0124 _exit 0129 __cexit 013c __XcptFilter 0154 __exit 0159 __c_exit 0168 __SEH_epilog4"
	strings:
		$1 = { 6A 58 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 98 50 FF 15 ?? ?? ?? ?? 33 F6 39 35 ?? ?? ?? ?? 75 0B 56 56 6A 01 56 FF 15 ?? ?? ?? ?? B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 05 89 75 E4 EB 36 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 EA B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 DC 83 B8 ?? ?? ?? ?? 0E 76 D3 33 C9 39 B0 ?? ?? ?? ?? 0F 95 C1 89 4D E4 E8 ?? ?? ?? ?? 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 89 75 FC E8 ?? ?? ?? ?? 85 C0 79 08 6A 1B E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 79 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 3B C6 74 07 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? F6 45 C4 01 74 06 0F B7 4D C8 EB 03 6A 0A 59 51 50 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 39 75 E4 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 45 EC 8B 08 8B 09 89 4D DC 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 45 DC 89 45 E0 83 7D E4 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_959_2_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 365
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 0012 __imp__GetStartupInfoW@4 001a __NoHeapEnableTerminationOnCorruption 0027 __imp__HeapSetInformation@16 0033 ___ImageBase 0075 __heap_init 0080 _fast_error_exit 0086 __mtinit 0097 __RTC_Initialize 009f __ioinit 00aa __amsg_exit 00b1 __imp__GetCommandLineW@0 00b6 __wcmdln 00bb ___crtGetEnvironmentStringsW 00c0 __wenvptr 00c5 __wsetargv 00d6 __wsetenvp 00e9 __cinit 00fa __wwincmdln 0116 _wWinMain@16 0124 _exit 0129 __cexit 013c __XcptFilter 0154 __exit 0159 __c_exit 0168 __SEH_epilog4"
	strings:
		$1 = { 6A 58 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 98 50 FF 15 ?? ?? ?? ?? 33 F6 39 35 ?? ?? ?? ?? 75 0B 56 56 6A 01 56 FF 15 ?? ?? ?? ?? B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 74 05 89 75 E4 EB 36 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 EA B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 DC 83 B8 ?? ?? ?? ?? 0E 76 D3 33 C9 39 B0 ?? ?? ?? ?? 0F 95 C1 89 4D E4 E8 ?? ?? ?? ?? 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 89 75 FC E8 ?? ?? ?? ?? 85 C0 79 08 6A 1B E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 79 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 79 08 6A 09 E8 ?? ?? ?? ?? 59 6A 01 E8 ?? ?? ?? ?? 59 3B C6 74 07 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? F6 45 C4 01 74 06 0F B7 4D C8 EB 03 6A 0A 59 51 50 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 39 75 E4 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 45 EC 8B 08 8B 09 89 4D DC 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 45 DC 89 45 E0 83 7D E4 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_330_3_0 {
	meta:
		name = "__mbsrchr_l"
		size = 170
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 __errno 002c __invalid_parameter_noinfo 004e _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 57 FF 75 10 8D 4D F0 33 DB 33 FF E8 ?? ?? ?? ?? 8B 4D 08 3B CB 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 66 56 8B 75 F4 39 5E 08 75 19 FF 75 0C 51 E8 ?? ?? ?? ?? 59 59 38 5D FC 74 4C 8B 4D F8 83 61 70 FD EB 43 8A 11 0F B6 C2 F6 44 30 1D 04 74 1D 41 8A 11 84 D2 74 12 0F B6 DA C1 E0 08 0B C3 39 45 0C 75 10 8D 79 FF EB 0B 85 FF EB 03 39 45 0C 75 02 8B F9 41 84 D2 75 CB 38 55 FC 74 07 8B 45 F8 83 60 70 FD 8B C7 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "___strncnt"
		size = 33
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 0C 8B 45 08 EB 07 49 80 38 00 74 06 40 85 C9 75 F5 49 8B 45 0C 2B C1 48 5D C3 }
	condition:
		$1
}

rule file_332_3_0 {
	meta:
		name = "__copytlocinfo_nolock"
		size = 38
		refs = "001e ___addlocaleref"
	strings:
		$1 = { 8B FF 56 8B F1 85 F6 74 1B 85 C0 74 17 3B C6 74 13 57 6A 36 59 8B F8 F3 A5 83 20 00 50 E8 ?? ?? ?? ?? 59 5F 5E C3 }
	condition:
		$1
}

rule file_332_4_0 {
	meta:
		name = "__configthreadlocale"
		size = 94
		refs = "0007 __getptd 0031 __errno 003c __invalid_parameter_noinfo 0054 ___globallocalestatus"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B 48 70 6A 00 5A F6 C1 02 0F 94 C2 8D 72 01 8B 55 08 83 FA FF 74 30 85 D2 74 33 83 FA 01 74 1F 83 FA 02 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB 16 83 E1 FD EB 03 83 C9 02 89 48 70 EB 07 83 0D ?? ?? ?? ?? FF 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_332_5_0 {
	meta:
		name = "_sync_legacy_variables_lk"
		size = 41
		refs = "0001 ___ptlocinfo 000d ___lconv 0019 __pctype 0024 ___mb_cur_max"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 88 BC 00 00 00 89 0D ?? ?? ?? ?? 8B 88 C8 00 00 00 89 0D ?? ?? ?? ?? 8B 80 AC 00 00 00 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_332_6_0 {
	meta:
		name = "__free_locale"
		size = 194
		refs = "0003 __sehtable$__free_locale 0008 __SEH_prolog4 001a __lock 002d __imp__InterlockedDecrement@4 0039 ___initialmbcinfo 0041 _free 0069 ___removelocaleref 007a ___initiallocinfo 0082 ___freetlocinfo 00a5 __SEH_epilog4 00b0 __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 0F 84 8D 00 00 00 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 46 04 85 C0 74 1C 50 FF 15 ?? ?? ?? ?? 85 C0 75 11 8B 46 04 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 5B 00 00 00 83 3E 00 74 3C 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 FF 36 E8 ?? ?? ?? ?? 59 8B 06 85 C0 74 13 83 38 00 75 0E 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 26 00 00 00 B8 0D F0 AD BA 89 06 89 46 04 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C3 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 8B 75 08 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_332_8_0 {
	meta:
		name = "__get_current_locale"
		size = 175
		refs = "0003 __sehtable$__get_current_locale 0008 __SEH_prolog4 000d __getptd 0018 __calloc_crt 0028 __errno 0037 ___updatetlocinfo 003c ___updatetmbcinfo 004e __lock 005a ___addlocaleref 007f __imp__InterlockedIncrement@4 0092 __SEH_epilog4 009d __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 6A 01 6A 08 E8 ?? ?? ?? ?? 59 59 8B F0 89 75 E4 85 F6 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 5B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 47 6C 89 06 8B 47 68 89 46 04 6A 0C E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 36 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 2F 00 00 00 6A 0D E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 FF 76 04 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 17 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 0C E8 ?? ?? ?? ?? 59 C3 8B 75 E4 6A 0D E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_332_11_0 {
	meta:
		name = "__strcats"
		size = 65
		refs = "0020 _strcat_s 003c __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 57 33 DB 33 FF 39 5D 10 7E 22 56 8D 75 10 83 C6 04 FF 36 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0B 47 3B 7D 10 7C E3 5E 5F 5B 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_332_12_0 {
	meta:
		name = "___lc_strtolc"
		size = 287
		refs = "0015 _memset 0044 _strncpy_s 005d __invoke_watson 0062 ??_C@_03EGDHDPFD@_?4?0?$AA@ 006b _strcspn"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 8B 7D 08 68 90 00 00 00 33 DB 53 57 E8 ?? ?? ?? ?? 8B 75 0C 8A 06 83 C4 0C 84 C0 75 07 33 C0 E9 E2 00 00 00 3C 2E 75 31 8D 46 01 38 18 74 2A 6A 0F 50 8D 87 80 00 00 00 6A 10 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 08 88 9F 8F 00 00 00 EB CE 53 53 53 53 53 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 89 5D 0C E8 ?? ?? ?? ?? 3B C3 E9 8D 00 00 00 83 7D 0C 00 8D 3C 30 8A 1F 75 17 83 F8 40 0F 83 81 00 00 00 80 FB 2E 74 7C 50 56 6A 40 FF 75 08 EB 3B 83 7D 0C 01 75 16 83 F8 40 73 68 80 FB 5F 74 63 50 8B 45 08 56 6A 40 83 C0 40 EB 1E 83 7D 0C 02 75 51 83 F8 10 73 4C 84 DB 74 05 80 FB 2C 75 43 50 8B 45 08 56 6A 10 83 E8 80 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 34 80 FB 2C 0F 84 3D FF FF FF 84 DB 0F 84 35 FF FF FF FF 45 0C 8D 77 01 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 6B FF FF FF 83 C8 FF 5F 5E 5B 5D C3 33 C0 50 50 50 50 50 E9 3D FF FF FF }
	condition:
		$1
}

rule file_332_13_0 {
	meta:
		name = "___lc_lctostr"
		size = 107
		refs = "0012 _strcpy_s 0028 ??_C@_01IDAFKMJL@_?$AA@ 0035 __strcats 004a ??_C@_01LFCBOECM@?4?$AA@ 0066 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 10 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 33 DB 85 C0 75 41 8D 46 40 38 18 74 16 50 68 ?? ?? ?? ?? 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 8D 86 80 00 00 00 38 18 5E 5B 74 16 50 68 ?? ?? ?? ?? 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_332_14_0 {
	meta:
		name = "__setlocale_get_all"
		size = 357
		refs = "0015 __malloc_crt 0037 ??_C@_01NEMOKFLO@?$DN?$AA@ 003d ___lc_category 0046 __strcats 005b ??_C@_01ICJEACDI@?$DL?$AA@ 0062 _strcat_s 007f _strcmp 00c3 __imp__InterlockedDecrement@4 00d6 _free 010f __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 33 DB 43 68 55 03 00 00 89 5D F4 E8 ?? ?? ?? ?? 59 89 45 F0 85 C0 0F 84 3D 01 00 00 57 8D 78 04 C6 07 00 89 18 FF 76 58 BB 51 03 00 00 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 6A 03 53 57 E8 ?? ?? ?? ?? 8D 46 58 83 C4 18 C7 45 FC ?? ?? ?? ?? 89 45 F8 68 ?? ?? ?? ?? 53 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 96 00 00 00 8B 45 F8 8D 48 10 FF 31 89 4D F8 FF 30 E8 ?? ?? ?? ?? 59 59 85 C0 74 04 83 65 F4 00 8B 45 F8 FF 30 83 45 FC 0C 68 ?? ?? ?? ?? 89 45 F8 8B 45 FC FF 30 6A 03 53 57 E8 ?? ?? ?? ?? 83 C4 18 81 7D FC ?? ?? ?? ?? 7C A2 83 7D F4 00 75 55 8B 46 50 8B 1D ?? ?? ?? ?? 85 C0 74 10 50 FF D3 85 C0 75 09 FF 76 50 E8 ?? ?? ?? ?? 59 8B 46 54 85 C0 74 10 50 FF D3 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 45 F0 83 66 54 00 83 66 4C 00 89 46 50 89 7E 48 8B C7 EB 5A 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? FF 75 F0 E8 ?? ?? ?? ?? 8B 46 50 8B 3D ?? ?? ?? ?? 33 DB 59 3B C3 74 10 50 FF D7 85 C0 75 09 FF 76 50 E8 ?? ?? ?? ?? 59 8B 46 54 3B C3 74 10 50 FF D7 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 46 68 89 5E 54 89 5E 4C 89 5E 50 89 5E 48 5F 5B C9 C3 }
	condition:
		$1
}

rule file_332_15_0 {
	meta:
		name = "__expandlocale"
		size = 545
		refs = "000c ___security_cookie 0037 __getptd 008f ??_C@_01GFHCPBMG@C?$AA@ 009d _strcpy_s 00d7 __invoke_watson 00dd _strlen 00f9 _strcmp 012d ___lc_strtolc 0145 ___get_qualified_locale 016f ___lc_lctostr 018c ??_C@_00CNPNBAHC@?$AA@ 019b _strncpy_s 01be _memcpy 021b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC B4 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 56 8B 75 08 57 8B 7D 14 89 85 64 FF FF FF 8B 45 18 89 BD 5C FF FF FF 89 85 60 FF FF FF E8 ?? ?? ?? ?? 8D 88 C4 00 00 00 89 8D 54 FF FF FF 8D 88 C8 00 00 00 8D 98 BC 00 00 00 05 4B 01 00 00 89 8D 58 FF FF FF 89 85 68 FF FF FF 85 F6 0F 84 A4 01 00 00 83 BD 64 FF FF FF 00 0F 84 97 01 00 00 83 7D 10 00 0F 84 8D 01 00 00 80 3E 43 75 53 80 7E 01 00 75 4D 68 ?? ?? ?? ?? FF 75 10 FF B5 64 FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 27 85 FF 74 0B 66 89 07 66 89 47 02 66 89 47 04 8B 85 60 FF FF FF 85 C0 74 03 83 20 00 8B 85 64 FF FF FF E9 43 01 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? BF 83 00 00 00 59 89 85 50 FF FF FF 3B C7 73 2C 56 FF B5 68 FF FF FF E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 A3 00 00 00 56 FF B5 58 FF FF FF E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 8D 00 00 00 83 A5 4C FF FF FF 00 8D 85 6C FF FF FF 56 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 D5 00 00 00 8D 85 6C FF FF FF 50 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 BC 00 00 00 0F B7 43 04 8B 8D 54 FF FF FF 89 01 8D 85 6C FF FF FF 50 57 FF B5 68 FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 80 3E 00 74 0A 8B 85 50 FF FF FF 3B C7 72 0B 8B 85 4C FF FF FF BE ?? ?? ?? ?? 40 50 56 57 FF B5 58 FF FF FF E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 25 FF FF FF 33 F6 39 B5 5C FF FF FF 74 11 6A 06 53 FF B5 5C FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 39 B5 60 FF FF FF 74 16 6A 04 FF B5 54 FF FF FF FF B5 60 FF FF FF E8 ?? ?? ?? ?? 83 C4 0C FF B5 68 FF FF FF FF 75 10 FF B5 64 FF FF FF E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 08 8B 85 68 FF FF FF EB 0C 56 56 56 56 56 E9 C6 FE FF FF 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_332_16_0 {
	meta:
		name = "__setlocale_set_cat"
		size = 826
		refs = "000c ___security_cookie 0029 __getptd 0051 __expandlocale 0066 @__security_check_cookie@4 007c _strcmp 0093 _strlen 00a2 __malloc_crt 00ec _memcpy 0115 _strcpy_s 0210 __first_127char 0219 ___crtGetStringTypeA 0240 __ctype_loc_style 024c _memcmp 029a ___lc_category 02b3 _free 02da ___clocalestr 02f0 __imp__InterlockedDecrement@4 0335 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC C8 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B D9 57 89 9D 70 FE FF FF 89 85 68 FE FF FF E8 ?? ?? ?? ?? 8B F8 53 8D 85 5C FE FF FF 50 8D 85 50 FE FF FF 50 68 83 00 00 00 8D 85 78 FF FF FF 50 FF B5 68 FE FF FF E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 10 33 C0 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C3 C1 E3 04 03 DE FF 73 48 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 8B 43 48 EB D3 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 83 C0 05 50 89 85 74 FE FF FF E8 ?? ?? ?? ?? 59 59 89 85 6C FE FF FF 85 C0 74 AA 8B 43 48 8B 8D 70 FE FF FF 89 85 68 FE FF FF 8D 44 8E 0C 89 85 58 FE FF FF 8B 00 89 85 48 FE FF FF 8D 41 06 6B C0 06 03 C6 6A 06 50 89 85 64 FE FF FF 8D 85 38 FE FF FF 50 E8 ?? ?? ?? ?? 8B 46 04 8D 8D 78 FF FF FF 51 8B 8D 74 FE FF FF 89 85 4C FE FF FF 8B 85 6C FE FF FF 83 C1 FC 83 C0 04 51 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 85 09 02 00 00 8B 85 6C FE FF FF 8B 8D 58 FE FF FF 83 C0 04 89 43 48 0F B7 85 50 FE FF FF 89 01 6A 06 8D 85 50 FE FF FF 50 FF B5 64 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 83 BD 70 FE FF FF 02 0F 85 19 01 00 00 8B 85 5C FE FF FF 83 A5 74 FE FF FF 00 89 46 04 8B 87 F4 01 00 00 8B 8F F0 01 00 00 89 85 64 FE FF FF 8D 87 D0 01 00 00 8B 56 04 3B 10 74 36 8B 10 FF 85 74 FE FF FF 89 08 8B 8D 64 FE FF FF 89 95 40 FE FF FF 8B 50 04 89 48 04 8B 8D 40 FE FF FF 83 C0 08 83 BD 74 FE FF FF 05 89 95 64 FE FF FF 7C C5 EB 2D 8B 85 74 FE FF FF 85 C0 74 23 8D 84 C7 D0 01 00 00 8B 10 89 97 D0 01 00 00 8B 50 04 89 97 D4 01 00 00 89 08 8B 8D 64 FE FF FF 89 48 04 83 BD 74 FE FF FF 05 75 72 6A 01 FF 76 14 8D 85 78 FE FF FF FF 76 04 50 6A 7F 68 ?? ?? ?? ?? 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 3C 33 C0 B9 FF 01 00 00 66 21 8C 45 78 FE FF FF 40 83 F8 7F 72 ED 68 FE 00 00 00 FF 35 ?? ?? ?? ?? 8D 85 78 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 40 89 87 D4 01 00 00 EB 07 83 A7 D4 01 00 00 00 8B 46 04 89 87 D0 01 00 00 8B 87 D4 01 00 00 89 86 A8 00 00 00 83 BD 70 FE FF FF 01 75 09 8B 85 5C FE FF FF 89 46 08 8B 85 70 FE FF FF 6B C0 0C 56 FF 90 ?? ?? ?? ?? 59 85 C0 74 31 8B 85 68 FE FF FF FF B5 6C FE FF FF 89 43 48 E8 ?? ?? ?? ?? 8B 85 48 FE FF FF 59 8B 8D 58 FE FF FF 89 01 8B 85 4C FE FF FF 89 46 04 E9 88 FD FF FF 81 BD 68 FE FF FF ?? ?? ?? ?? 74 2E 8B BD 70 FE FF FF 83 C7 05 03 FF FF 34 FE FF 15 ?? ?? ?? ?? 85 C0 75 16 FF 34 FE E8 ?? ?? ?? ?? FF 73 54 E8 ?? ?? ?? ?? 83 63 4C 00 59 59 8B 8D 70 FE FF FF 8B 85 6C FE FF FF 83 C1 05 03 C9 C7 00 01 00 00 00 89 04 CE E9 59 FD FF FF 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_332_17_0 {
	meta:
		name = "__setlocale_nolock"
		size = 540
		refs = "000c ___security_cookie 002f __setlocale_set_cat 007c ??_C@_02BALPLPBG@?$DN?$DL?$AA@ 0082 _strpbrk 00b4 ___lc_category 00c5 _strncmp 00d3 _strlen 00f3 ??_C@_01ICJEACDI@?$DL?$AA@ 00f9 _strcspn 0128 _strncpy_s 018d __invoke_watson 01a6 __expandlocale 01c2 _strcmp 0209 __setlocale_get_all 0216 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 98 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 33 DB 8B F2 57 89 B5 68 FF FF FF 3B CB 74 1B 3B C3 74 0C 50 E8 ?? ?? ?? ?? 59 E9 D4 01 00 00 03 C9 8B 44 CE 48 E9 C9 01 00 00 C7 85 70 FF FF FF 01 00 00 00 89 9D 74 FF FF FF 3B C3 0F 84 AC 01 00 00 80 38 4C 0F 85 30 01 00 00 80 78 01 43 0F 85 26 01 00 00 80 78 02 5F 0F 85 1C 01 00 00 8B F8 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B D8 59 59 85 DB 0F 84 FF 00 00 00 2B C7 89 85 70 FF FF FF 0F 84 F1 00 00 00 80 3B 3B 0F 84 E8 00 00 00 C7 85 6C FF FF FF 01 00 00 00 BE ?? ?? ?? ?? EB 06 8B 85 70 FF FF FF 50 57 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 10 FF 36 E8 ?? ?? ?? ?? 59 39 85 70 FF FF FF 74 11 FF 85 6C FF FF FF 83 C6 0C 81 FE ?? ?? ?? ?? 7E C9 43 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B F8 33 F6 59 59 3B FE 75 09 80 3B 3B 0F 85 81 00 00 00 83 BD 6C FF FF FF 05 7F 44 57 53 8D 85 78 FF FF FF 68 83 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 54 8B 8D 6C FF FF FF 8B B5 68 FF FF FF 88 84 3D 78 FF FF FF 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 59 85 C0 74 06 FF 85 74 FF FF FF 03 FB 80 3F 00 74 0A 47 80 3F 00 0F 85 0D FF FF FF 33 C0 39 85 74 FF FF FF 0F 84 91 00 00 00 8B B5 68 FF FF FF E9 81 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 33 C0 EB 78 53 53 53 68 83 00 00 00 8D 8D 78 FF FF FF 51 50 E8 ?? ?? ?? ?? 83 C4 18 3B C3 74 5C 8D 7E 48 85 DB 74 35 FF 37 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 1B 8D 85 78 FF FF FF 50 8B CB E8 ?? ?? ?? ?? 59 85 C0 75 08 21 85 70 FF FF FF EB 06 FF 85 74 FF FF FF 43 83 C7 10 83 FB 05 7E BE 33 C0 39 85 70 FF FF FF 75 08 39 85 74 FF FF FF 74 05 E8 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_332_18_0 {
	meta:
		name = "__create_locale"
		size = 245
		refs = "001a __calloc_crt 0027 __errno 004c _free 007a ___initiallocinfo 007f __copytlocinfo_nolock 008c __setlocale_nolock 0098 ___removelocaleref 009f ___freetlocinfo 00b7 __setmbcp_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 05 56 57 77 24 83 7D 0C 00 74 1E 33 FF 47 57 6A 08 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 11 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 5F 5E 5D C3 57 68 D8 00 00 00 E8 ?? ?? ?? ?? 59 59 89 06 85 C0 75 09 56 E8 ?? ?? ?? ?? 59 EB D3 57 68 20 02 00 00 E8 ?? ?? ?? ?? 59 59 89 46 04 85 C0 75 10 FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 EB D9 8B 06 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 0C 8B 4D 08 8B 16 E8 ?? ?? ?? ?? 59 85 C0 75 19 FF 36 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C EB 32 FF 76 04 8B 06 FF 70 04 E8 ?? ?? ?? ?? 59 59 85 C0 74 23 FF 76 04 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 10 33 F6 EB 0A 8B 46 04 89 38 8B 46 04 89 38 8B C6 E9 3E FF FF FF }
	condition:
		$1
}

rule file_332_20_0 {
	meta:
		name = "_setlocale"
		size = 372
		refs = "0003 __sehtable$_setlocale 0008 __SEH_prolog4 0017 __errno 0022 __invalid_parameter_noinfo 002e __getptd 0038 ___updatetlocinfo 004e __calloc_crt 0064 __lock 0072 __copytlocinfo_nolock 0088 __setlocale_nolock 009f ___clocalestr 00a7 _strcmp 00b3 ___locale_changed 00cc __updatetlocinfoEx_nolock 00d2 ___removelocaleref 00e1 ___globallocalestatus 00eb ___ptlocinfo 0103 ___lconv 010f __pctype 011a ___mb_cur_max 0135 __unlock 0151 ___freetlocinfo 0167 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E0 00 83 7D 08 05 76 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 39 01 00 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 E8 ?? ?? ?? ?? 83 4E 70 10 83 65 FC 00 33 FF 47 57 68 D8 00 00 00 E8 ?? ?? ?? ?? 59 59 8B D8 89 5D DC 85 DB 0F 84 F6 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 89 7D FC 8B 4E 6C 8B C3 E8 ?? ?? ?? ?? 83 65 FC 00 E8 B3 00 00 00 FF 75 0C 8B 4D 08 8B D3 E8 ?? ?? ?? ?? 59 89 45 E0 85 C0 0F 84 B1 00 00 00 83 7D 0C 00 74 19 68 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 59 59 85 C0 74 06 89 3D ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 02 00 00 00 8D 7E 6C 53 57 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 0C F6 46 70 02 75 3F F6 05 ?? ?? ?? ?? 01 75 36 FF 37 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 A1 ?? ?? ?? ?? 8B 88 BC 00 00 00 89 0D ?? ?? ?? ?? 8B 88 C8 00 00 00 89 0D ?? ?? ?? ?? 8B 80 AC 00 00 00 A3 ?? ?? ?? ?? 83 65 FC 00 E8 17 00 00 00 EB 2E 8B 5D DC 8B 75 E4 33 FF 47 6A 0C E8 ?? ?? ?? ?? 59 C3 8B 75 E4 6A 0C E8 ?? ?? ?? ?? 59 C3 EB 0E 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 8B 75 E4 83 66 70 EF C3 }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "__futime32"
		size = 435
		refs = "0009 ___security_cookie 0022 __errno 003a __nhandle 004c __invalid_parameter_noinfo 005a ___pioinfo 0074 __time32 008b __localtime32_s 00dc __imp__SystemTimeToFileTime@8 00f8 __imp__LocalFileTimeToFileTime@8 0182 __get_osfhandle 018a __imp__SetFileTime@16 01ad @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 5C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 57 8B 7D 0C 89 45 BC 83 F8 FE 75 13 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 72 01 00 00 85 C0 78 08 3B 05 ?? ?? ?? ?? 72 12 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB DA 8B C8 C1 F9 05 8B 0C 8D ?? ?? ?? ?? 83 E0 1F C1 E0 06 F6 44 01 04 01 74 D5 85 FF 75 13 8D 45 B8 50 E8 ?? ?? ?? ?? 8B 45 B8 59 89 45 B4 8D 7D B4 8D 47 04 50 8D 45 C8 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 8A 8B 45 DC 05 6C 07 00 00 66 89 45 EC 8B 45 D8 40 66 89 45 EE 66 8B 45 D4 66 89 45 F2 66 8B 45 D0 66 89 45 F4 66 8B 45 CC 66 89 45 F6 66 8B 45 C8 66 89 45 F8 33 C0 53 56 8B 35 ?? ?? ?? ?? 66 89 45 FA 8D 45 C0 50 8D 45 EC 50 FF D6 85 C0 0F 84 A0 00 00 00 8B 1D ?? ?? ?? ?? 8D 45 AC 50 8D 45 C0 50 FF D3 85 C0 0F 84 88 00 00 00 8D 45 C8 57 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 78 8B 45 DC 05 6C 07 00 00 66 89 45 EC 8B 45 D8 40 66 89 45 EE 66 8B 45 D4 66 89 45 F2 66 8B 45 D0 66 89 45 F4 66 8B 45 CC 66 89 45 F6 66 8B 45 C8 66 89 45 F8 33 C0 66 89 45 FA 8D 45 C0 50 8D 45 EC 50 FF D6 85 C0 74 30 8D 45 A4 50 8D 45 C0 50 FF D3 85 C0 74 22 8D 45 AC 50 8D 45 A4 50 6A 00 FF 75 BC E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5E 5B 8B 4D FC 33 CD 5F E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "___init_ctype"
		size = 935
		refs = "0009 ___security_cookie 0050 ___getlocaleinfo 0062 __malloc_crt 0072 __calloc_crt 00eb __imp__GetCPInfo@8 0158 ___crtGetStringTypeA 018b ___crtLCMapStringA 0263 _memcpy 0298 __imp__InterlockedDecrement@4 02ad _free 0374 ___newctype 037e ___newclmap 0388 ___newcumap 03a1 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 33 DB 56 8B 75 08 57 89 5D D4 89 5D E4 89 5D E0 89 5D D8 89 5D DC 89 75 B4 89 5D B8 39 5E 14 0F 84 19 03 00 00 8D 46 04 39 18 75 20 50 0F B7 46 30 68 04 10 00 00 50 8D 45 B4 53 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 CA 02 00 00 6A 04 E8 ?? ?? ?? ?? 6A 02 BF 80 01 00 00 57 89 45 D4 E8 ?? ?? ?? ?? 6A 01 57 89 45 E4 E8 ?? ?? ?? ?? 6A 01 57 89 45 E0 E8 ?? ?? ?? ?? 6A 01 68 01 01 00 00 89 45 D8 E8 ?? ?? ?? ?? 83 C4 24 89 45 DC 39 5D D4 0F 84 7F 02 00 00 39 5D E4 0F 84 76 02 00 00 3B C3 0F 84 6E 02 00 00 39 5D E0 0F 84 65 02 00 00 39 5D D8 0F 84 5C 02 00 00 8B 45 D4 89 18 33 C0 8B 4D DC 88 04 08 40 3D 00 01 00 00 7C F2 8D 45 E8 50 FF 76 04 FF 15 ?? ?? ?? ?? 85 C0 0F 84 32 02 00 00 83 7D E8 05 0F 87 28 02 00 00 0F B7 45 E8 89 45 D0 83 F8 01 7E 2E 38 5D EE 74 29 8D 45 EF 8A 08 3A CB 74 20 0F B6 78 FF 0F B6 C9 EB 0B 8B 4D DC C6 04 0F 20 0F B6 08 47 3B F9 7E F1 83 C0 02 38 58 FF 75 DA 8B 45 E4 53 53 FF 76 04 05 00 01 00 00 50 68 00 01 00 00 FF 75 DC 89 45 C0 6A 01 53 E8 ?? ?? ?? ?? 83 C4 20 85 C0 0F 84 C2 01 00 00 8B 4D E0 8B 45 DC 53 FF 76 04 BF FF 00 00 00 57 81 C1 81 00 00 00 51 57 40 50 68 00 01 00 00 FF 76 14 53 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 8F 01 00 00 8B 45 D8 53 FF 76 04 05 81 00 00 00 57 50 8B 45 DC 57 40 50 68 00 02 00 00 FF 76 14 53 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 62 01 00 00 8B 45 E4 8B 7D E0 8D 88 FE 00 00 00 33 D2 83 7D D0 01 66 89 11 8B 55 D8 89 4D C4 8D 8F 80 00 00 00 88 5F 7F 88 5A 7F 88 19 89 4D BC 8D 8A 80 00 00 00 89 4D C8 88 19 7E 55 38 5D EE 74 50 8D 4D EF 89 4D E4 8A 11 3A D3 74 44 0F B6 49 FF 0F B6 D2 89 4D E0 3B CA 7F 28 8D 8C 48 00 01 00 00 EB 03 8B 4D CC FF 45 E0 BA 00 80 00 00 66 89 11 83 C1 02 89 4D CC 8B 4D E4 0F B6 09 39 4D E0 7E E1 8B 4D E4 83 C1 02 89 4D E4 38 59 FF 75 B6 68 FE 00 00 00 8D 88 00 02 00 00 51 50 E8 ?? ?? ?? ?? 6A 7F 8D 87 00 01 00 00 50 57 E8 ?? ?? ?? ?? 8B 45 D8 6A 7F 8D 88 00 01 00 00 51 50 E8 ?? ?? ?? ?? 8B 86 C0 00 00 00 83 C4 24 3B C3 74 4B 50 FF 15 ?? ?? ?? ?? 85 C0 75 40 8B 86 C4 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 8B 86 CC 00 00 00 BF 80 00 00 00 2B C7 50 E8 ?? ?? ?? ?? 8B 86 D0 00 00 00 2B C7 50 E8 ?? ?? ?? ?? FF B6 C0 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 8B 45 D4 C7 00 01 00 00 00 89 86 C0 00 00 00 8B 45 C0 89 86 C8 00 00 00 8B 45 C4 89 86 C4 00 00 00 8B 45 BC 89 86 CC 00 00 00 8B 45 C8 89 86 D0 00 00 00 8B 45 D0 89 86 AC 00 00 00 FF 75 DC E8 ?? ?? ?? ?? 59 8B C3 EB 6F FF 75 D4 E8 ?? ?? ?? ?? FF 75 E4 E8 ?? ?? ?? ?? FF 75 E0 E8 ?? ?? ?? ?? FF 75 D8 E8 ?? ?? ?? ?? 33 DB 83 C4 10 43 EB CB 8B 86 C0 00 00 00 3B C3 74 07 50 FF 15 ?? ?? ?? ?? 89 9E C0 00 00 00 89 9E C4 00 00 00 C7 86 C8 00 00 00 ?? ?? ?? ?? C7 86 CC 00 00 00 ?? ?? ?? ?? C7 86 D0 00 00 00 ?? ?? ?? ?? C7 86 AC 00 00 00 01 00 00 00 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_334_1_0 {
	meta:
		name = "____mb_cur_max_func"
		size = 41
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 80 AC 00 00 00 C3 }
	condition:
		$1
}

rule file_334_2_0 {
	meta:
		name = "____mb_cur_max_l_func"
		size = 28
		refs = "000e ____mb_cur_max_func"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 75 06 5D E9 ?? ?? ?? ?? 8B 00 8B 80 AC 00 00 00 5D C3 }
	condition:
		$1
}

rule file_334_3_0 {
	meta:
		name = "____lc_codepage_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 40 04 C3 }
	condition:
		$1
}

rule file_334_4_0 {
	meta:
		name = "____lc_collate_cp_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 40 08 C3 }
	condition:
		$1
}

rule file_334_5_0 {
	meta:
		name = "____lc_handle_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 83 C0 0C C3 }
	condition:
		$1
}

rule file_335_3_0 {
	meta:
		name = "__mbsnbset_s_l"
		size = 540
		refs = "0034 __errno 003e __invalid_parameter_noinfo 0050 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0067 __strnset_s 00a5 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 53 33 DB 56 57 89 5D F0 89 5D F4 39 5D 14 75 0F 39 5D 08 75 0F 39 5D 0C 75 11 E9 EE 01 00 00 39 5D 08 74 07 8B 7D 0C 3B FB 77 16 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 E9 CE 01 00 00 FF 75 18 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 E4 39 58 08 75 27 FF 75 14 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 38 5D EC 0F 84 A0 01 00 00 8B 4D E8 83 61 70 FD E9 94 01 00 00 8B 45 10 8B 75 08 C1 E8 08 89 7D F8 88 45 FF 3A C3 74 31 38 5D 10 74 44 8D 45 E0 50 0F B6 45 FF 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 30 F6 45 14 01 74 0A FF 4D 14 C7 45 F0 01 00 00 00 D1 6D 14 E9 8E 00 00 00 8D 45 E0 50 0F B6 45 10 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 B9 00 00 00 88 1E E8 ?? ?? ?? ?? 8B C8 6A 2A 58 89 01 E9 7C FF FF FF 39 5D 14 0F 86 A4 00 00 00 FF 4D F8 0F 84 98 00 00 00 38 5E 01 74 52 39 5D F4 74 05 89 5D F4 EB 12 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 89 45 F4 8A 45 FF 88 06 46 FF 4D F8 74 6C 39 5D F4 74 05 89 5D F4 EB 12 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 89 45 F4 8A 45 10 88 06 46 FF 4D 14 38 1E 75 99 EB 41 FF 45 F8 88 1E C7 45 F0 01 00 00 00 EB 33 39 5D 14 76 31 FF 4D F8 74 29 39 5D F4 74 05 89 5D F4 EB 12 8D 45 E0 50 0F B6 06 50 E8 ?? ?? ?? ?? 59 59 89 45 F4 8A 45 10 88 06 46 FF 4D 14 38 1E 75 CD 39 5D 14 75 31 39 5D F4 74 28 38 1E 74 28 FF 4D F8 74 1F C7 45 F0 01 00 00 00 38 5E 01 75 07 FF 45 F8 88 1E EB 0C C6 06 20 46 EB 06 FF 4D F8 74 05 46 38 1E 75 F6 39 5D F8 75 29 8B 45 08 88 18 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 38 5D EC 0F 84 4E FE FF FF 8B 45 E8 83 60 70 FD E9 42 FE FF FF 39 5D F0 0F 85 D8 FE FF FF 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_336_17_0 {
	meta:
		name = "?SearchForWork@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 6A 07 FF 75 0C 83 C1 1C FF 75 08 FF 51 18 5D C2 08 00 }
	condition:
		$1
}

rule file_336_19_0 {
	meta:
		name = "?SearchForWorkInYield@VirtualProcessor@details@Concurrency@@QAE_NPAVWorkItem@23@PAVScheduleGroupBase@23@@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 6A 03 FF 75 0C 83 C1 1C FF 75 08 FF 51 1C 5D C2 08 00 }
	condition:
		$1
}

rule file_336_26_0 {
	meta:
		name = "?CrossGroupRunnable@InternalContextBase@details@Concurrency@@QAEXJ@Z"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 81 C4 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_336_28_0 {
	meta:
		name = "?InternalReference@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
		size = 18
		altNames = "?Reference@ScheduleGroupBase@details@Concurrency@@UAEIXZ"
	strings:
		$1 = { 33 C0 F6 41 74 04 75 09 83 C1 6C 40 F0 0F C1 01 40 C3 }
	condition:
		$1
}

rule file_336_31_0 {
	meta:
		name = "?GetAndResetOversubscribedVProc@InternalContextBase@details@Concurrency@@QAEPAVVirtualProcessor@23@PAV423@@Z"
		size = 52
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 56 33 F6 85 D2 74 1E 8D 81 88 00 00 00 8B 08 3B D1 75 12 57 8B F8 33 C9 8B C2 F0 0F B1 0F 5F 3B C2 75 02 8B F2 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_32_0 {
	meta:
		name = "?GetVirtualProcessorId@InternalContextBase@details@Concurrency@@UBEIXZ"
		size = 47
		refs = "0007 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0026 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 56 57 8B F9 E8 ?? ?? ?? ?? 8B 8F 80 00 00 00 85 C9 74 0B 8B 87 80 00 00 00 8B 70 74 EB 03 83 CE FF 8B CF E8 ?? ?? ?? ?? 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_336_33_0 {
	meta:
		name = "?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
		size = 187
		refs = "0034 ?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@PAVVirtualProcessor@23@@Z 004e ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0057 ?ReleaseInternalContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@@Z 0065 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00b3 ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 8B 45 0C 53 56 33 DB 2B C3 57 8B F1 C7 45 FC 01 00 00 00 74 1E 48 74 3F 48 74 0C 48 75 39 C7 45 FC 02 00 00 00 EB 30 8B 4E 1C 53 56 E8 ?? ?? ?? ?? EB 24 8B 4E 20 FF 76 0C 8B 01 FF 50 04 50 6A 04 6A 06 8D 4E 04 E8 ?? ?? ?? ?? 8B 4E 1C 56 E8 ?? ?? ?? ?? 89 5D FC 8D 4E 04 89 4D F8 E8 ?? ?? ?? ?? 8B BE 84 00 00 00 89 9E 84 00 00 00 8B 9E 80 00 00 00 33 C0 40 83 C6 2C 87 06 FF 75 08 8B 07 8B CF FF 50 10 8B 45 08 85 C0 75 07 8B 07 8B CF FF 50 04 FF 75 FC 8B 13 50 8B CB FF 52 04 83 7D 0C 00 5F 5E 5B 74 08 8B 4D F8 E8 ?? ?? ?? ?? C9 C2 08 00 }
	condition:
		$1
}

rule file_336_34_0 {
	meta:
		name = "?LeaveScheduler@InternalContextBase@details@Concurrency@@AAEXXZ"
		size = 193
		refs = "0013 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 003c ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0044 ?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0055 ?GetInternalContext@ScheduleGroupBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z 0066 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00b1 ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 8B F1 8D 5E 04 57 8B CB E8 ?? ?? ?? ?? 8B 56 1C 8B 8E 84 00 00 00 6A 07 52 8D 45 EC 33 FF 83 C1 1C 50 89 7D EC 89 7D F4 FF 51 18 8B CB 84 C0 74 0F E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 8B 4E 1C 57 57 E8 ?? ?? ?? ?? 8B CB 89 45 FC E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? 8B BE 84 00 00 00 C7 86 84 00 00 00 00 00 00 00 8B 86 80 00 00 00 89 45 F8 33 C0 40 83 C6 2C 87 06 FF 75 FC 8B 07 8B CF FF 50 10 8B 45 FC 85 C0 75 07 8B 07 8B CF FF 50 04 8B 4D F8 8B 11 6A 02 50 FF 52 04 8B CB E8 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_336_35_0 {
	meta:
		name = "?WaitForWork@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 163
		refs = "0037 ?MakeAvailable@VirtualProcessor@details@Concurrency@@QAEXXZ 0043 ?EnsureAllTasksVisible@VirtualProcessor@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z 006c ?VirtualProcessorIdle@SchedulerBase@details@Concurrency@@QAEX_N@Z 0081 ?Deactivate@VirtualProcessor@details@Concurrency@@QAE_NPAUIExecutionContext@3@@Z"
	strings:
		$1 = { 8B FF 56 8B F1 FF 86 90 00 00 00 8B 86 90 00 00 00 B9 00 01 00 00 3B C1 73 0C 8B 8E 80 00 00 00 8B 01 5E FF 60 0C 75 22 8B 8E 84 00 00 00 57 C6 86 96 00 00 00 01 E8 ?? ?? ?? ?? 8B 8E 84 00 00 00 56 E8 ?? ?? ?? ?? 5F 5E C3 F6 86 97 00 00 00 02 74 13 8B 8E 80 00 00 00 48 89 86 90 00 00 00 8B 01 5E FF 60 0C 8B 4E 20 6A 01 E8 ?? ?? ?? ?? EB 07 8B 06 8B CE FF 50 24 8B 8E 84 00 00 00 56 E8 ?? ?? ?? ?? 84 C0 74 E9 8B 4E 20 6A 00 E8 ?? ?? ?? ?? 83 A6 90 00 00 00 00 C6 86 96 00 00 00 00 5E C3 }
	condition:
		$1
}

rule file_336_36_0 {
	meta:
		name = "?ExecutedAssociatedChore@InternalContextBase@details@Concurrency@@IAE_NXZ"
		size = 101
		refs = "0013 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0037 ?Invoke@RealizedChore@details@Concurrency@@QAEXXZ 0040 ?ReleaseRealizedChore@SchedulerBase@details@Concurrency@@QAEXPAVRealizedChore@23@@Z 0049 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0058 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 BE 8C 00 00 00 00 74 53 57 8D 4E 04 E8 ?? ?? ?? ?? 80 BE 95 00 00 00 00 74 0D 8B 86 8C 00 00 00 50 FF 50 0C 59 EB 18 53 8B 9E 8C 00 00 00 8B CB E8 ?? ?? ?? ?? 8B 4E 20 53 E8 ?? ?? ?? ?? 5B 8D 4E 04 E8 ?? ?? ?? ?? 83 A6 8C 00 00 00 00 8D 4E 04 E8 ?? ?? ?? ?? 5F B0 01 5E C3 32 C0 5E C3 }
	condition:
		$1
}

rule file_336_37_0 {
	meta:
		name = "?SwitchToRunnableContext@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z"
		size = 22
		refs = "000e ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 6A 00 FF 70 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_336_38_0 {
	meta:
		name = "?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 63
		refs = "0015 ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NXZ 002e ?Deactivate@VirtualProcessor@details@Concurrency@@QAE_NPAUIExecutionContext@3@@Z"
	strings:
		$1 = { 8B FF 56 8B F1 80 BE 96 00 00 00 00 74 2F 8B 8E 84 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 19 EB 07 8B 06 8B CE FF 50 24 8B 8E 84 00 00 00 56 E8 ?? ?? ?? ?? 84 C0 74 E9 C6 86 96 00 00 00 00 5E C3 }
	condition:
		$1
}

rule file_336_39_0 {
	meta:
		name = "?PrepareForUse@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@PAU_Chore@23@_N@Z"
		size = 92
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B 75 0C 33 D2 88 91 CC 00 00 00 89 41 1C 3B F2 75 12 F6 40 74 04 75 36 33 C9 83 C0 6C 41 F0 0F C1 08 EB 2A 38 55 10 74 19 F6 40 74 04 75 0A 33 D2 83 C0 6C 42 F0 0F C1 10 C6 81 95 00 00 00 01 EB 06 88 91 95 00 00 00 89 B1 8C 00 00 00 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_336_43_0 {
	meta:
		name = "?SetProxy@InternalContextBase@details@Concurrency@@UAEXPAUIThreadProxy@3@@Z"
		size = 65
		refs = "0019 ??_C@_0N@FACDCNDA@pThreadProxy?$AA@ 001e ??0exception@std@@QAE@ABQBD@Z 0023 __TI3?AVinvalid_argument@std@@ 002e ??_7invalid_argument@std@@6B@ 0033 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 EC 0C 85 C0 75 28 8D 45 08 50 8D 4D F4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 C7 45 F4 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 81 80 00 00 00 C9 C2 04 00 }
	condition:
		$1
}

rule file_336_45_0 {
	meta:
		name = "?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z"
		size = 81
		refs = "0003 __ehhandler$?Alloc@InternalContextBase@details@Concurrency@@UAEPAXI@Z 0008 __EH_prolog3 001d ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 002c ?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QAEPAVSubAllocator@23@XZ 0036 ?Alloc@SubAllocator@details@Concurrency@@QAEPAXI@Z 0043 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 004a __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8D 77 FC F7 DE 1B F6 23 F7 8B CE 89 75 F0 E8 ?? ?? ?? ?? 8B 8F 80 00 00 00 83 65 FC 00 E8 ?? ?? ?? ?? FF 75 08 8B C8 E8 ?? ?? ?? ?? 83 4D FC FF 8B CE 8B F8 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_336_48_0 {
	meta:
		name = "?Free@InternalContextBase@details@Concurrency@@UAEXPAX@Z"
		size = 46
		refs = "0009 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0014 ?GetCurrentSubAllocator@VirtualProcessor@details@Concurrency@@QAEPAVSubAllocator@23@XZ 001e ?Free@SubAllocator@details@Concurrency@@QAEXPAX@Z 0025 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 8B 8E 80 00 00 00 E8 ?? ?? ?? ?? FF 75 08 8B C8 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_49_0 {
	meta:
		name = "?IncrementEnqueuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 33
		refs = "000a ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 001d ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 56 8B F1 57 8D 4E 04 E8 ?? ?? ?? ?? 8B 86 84 00 00 00 FF 40 5C 5F 8D 4E 04 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_50_0 {
	meta:
		name = "?IncrementDequeuedTaskCounterHelper@InternalContextBase@details@Concurrency@@QAEXI@Z"
		size = 43
		refs = "000d ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0021 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 57 8D 4E 04 E8 ?? ?? ?? ?? 8B 86 84 00 00 00 8B 4D 08 01 48 60 8D 4E 04 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_56_0 {
	meta:
		name = "?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@@Z"
		size = 184
		refs = "0027 ??_U@YAPAXI@Z 003b ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ 007a _memset 00a4 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QAEXXZ 00ac ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B F1 8B 46 08 57 8D 44 00 02 33 C9 6A 04 5A 89 45 FC F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 59 8B 4E 10 8B D8 8B 46 0C 89 45 F0 89 4D F4 E8 ?? ?? ?? ?? 8B 46 04 8B 06 8B 7E 04 89 45 F8 8B 06 2B F8 33 C0 85 FF 7E 16 8B 4D F8 8B 56 0C 03 C8 23 4E 08 8B 0C 8A 89 0C 83 40 3B C7 7C EA 8B 45 FC 2B C7 C1 E0 02 50 8D 04 BB 6A 00 50 E8 ?? ?? ?? ?? 8B 45 FC 8B 55 08 83 C4 0C 48 89 5E 0C 8B 4E 0C 89 46 08 23 C7 C7 06 00 00 00 00 89 14 81 8B 4D F4 47 89 7E 04 E8 ?? ?? ?? ?? FF 75 F0 E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_863_112_0 {
	meta:
		name = "?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@@Z"
		size = 184
		refs = "0027 ??_U@YAPAXI@Z 003b ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 007a _memset 00a4 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QAEXXZ 00ac ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 8B F1 8B 46 08 57 8D 44 00 02 33 C9 6A 04 5A 89 45 FC F7 E2 0F 90 C1 F7 D9 0B C8 51 E8 ?? ?? ?? ?? 59 8B 4E 10 8B D8 8B 46 0C 89 45 F0 89 4D F4 E8 ?? ?? ?? ?? 8B 46 04 8B 06 8B 7E 04 89 45 F8 8B 06 2B F8 33 C0 85 FF 7E 16 8B 4D F8 8B 56 0C 03 C8 23 4E 08 8B 0C 8A 89 0C 83 40 3B C7 7C EA 8B 45 FC 2B C7 C1 E0 02 50 8D 04 BB 6A 00 50 E8 ?? ?? ?? ?? 8B 45 FC 8B 55 08 83 C4 0C 48 89 5E 0C 8B 4E 0C 89 46 08 23 C7 C7 06 00 00 00 00 89 14 81 8B 4D F4 47 89 7E 04 E8 ?? ?? ?? ?? FF 75 F0 E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_336_64_0 {
	meta:
		name = "?Oversubscribe@InternalContextBase@details@Concurrency@@UAEX_N@Z"
		size = 116
		refs = "001b ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 002d ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 003e ??0invalid_oversubscribe_operation@Concurrency@@QAE@XZ 0043 __TI2?AVinvalid_oversubscribe_operation@Concurrency@@ 004c __CxxThrowException@8 0060 ?GetAndResetOversubscribedVProc@InternalContextBase@details@Concurrency@@QAEPAVVirtualProcessor@23@PAV423@@Z 006b ?MarkForRetirement@VirtualProcessor@details@Concurrency@@AAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 80 7D 08 00 56 8B F1 74 22 FF 46 14 83 7E 14 01 75 55 E8 ?? ?? ?? ?? 8B 8E 80 00 00 00 8B 01 FF 50 20 8B CE E8 ?? ?? ?? ?? EB 3C 8B 46 14 85 C0 75 16 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 48 89 46 14 75 19 FF B6 84 00 00 00 8D 4E FC E8 ?? ?? ?? ?? 85 C0 74 07 8B C8 E8 ?? ?? ?? ?? 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_336_68_0 {
	meta:
		name = "?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z"
		size = 227
		refs = "0026 ?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ 003d ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 005d ?ExitHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 007f ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0088 ?ReleaseInternalContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@@Z 0094 ?TriggerCommitSafePoints@SchedulerBase@details@Concurrency@@QAEXPAVSafePointMarker@23@@Z 009d ?VirtualProcessorActive@SchedulerBase@details@Concurrency@@QAE_N_N@Z 00c9 ?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@PAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 8B F1 8B 86 80 00 00 00 89 45 F8 8B 86 84 00 00 00 32 DB 85 C0 0F 84 92 00 00 00 57 E8 ?? ?? ?? ?? 8B 86 84 00 00 00 8B 80 90 00 00 00 8D 4E 04 89 45 FC E8 ?? ?? ?? ?? 8B 8E 84 00 00 00 8B 01 FF 50 0C 33 DB 89 9E 84 00 00 00 39 5D 08 74 12 8D 4E 04 E8 ?? ?? ?? ?? 33 C0 40 8D 4E 2C 87 01 EB 21 8B 4E 20 FF 76 0C 8B 01 FF 50 04 50 6A 04 6A 06 8D 4E 04 E8 ?? ?? ?? ?? 8B 4E 1C 56 E8 ?? ?? ?? ?? 8B 4E 20 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 4E 20 53 E8 ?? ?? ?? ?? 83 7D 08 00 8A 9E 94 00 00 00 5F 75 08 33 C0 40 8D 4E 2C 87 01 83 7D 08 02 7C 11 83 7D 08 03 7F 0B 8B 4E 1C 6A 00 56 E8 ?? ?? ?? ?? 83 7D 08 00 74 08 8B 4D F8 8B 01 FF 50 08 5E 8A C3 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_336_69_0 {
	meta:
		name = "?RejoinScheduler@InternalContextBase@details@Concurrency@@AAEXXZ"
		size = 33
		refs = "000a ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0013 ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 001d ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 56 8B F1 57 8D 4E 04 E8 ?? ?? ?? ?? 6A 03 8B CE E8 ?? ?? ?? ?? 5F 8D 4E 04 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_70_0 {
	meta:
		name = "?WorkWasFound@InternalContextBase@details@Concurrency@@IAE_NPAVWorkItem@23@@Z"
		size = 58
		refs = "0024 ?ReclaimVirtualProcessor@InternalContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 56 1C 8B 86 84 00 00 00 6A 07 52 FF 75 08 8D 48 1C FF 51 18 84 C0 74 12 8B CE E8 ?? ?? ?? ?? 83 A6 90 00 00 00 00 B0 01 EB 02 32 C0 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_71_0 {
	meta:
		name = "?ExecuteChoreInline@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z"
		size = 61
		refs = "000d ?TransferReferences@WorkItem@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 0014 ?IncrementDequeuedTaskCounter@InternalContextBase@details@Concurrency@@QAEXXZ 001e ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0026 ?Invoke@WorkItem@details@Concurrency@@QAEXXZ 002d ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0034 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 8B 4D 08 56 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 83 C6 04 8B CE E8 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_336_73_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z"
		size = 49
		refs = "002d ?GrowAndPush@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@AAEXPAVInternalContextBase@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 51 04 8B 41 08 56 8B 31 03 F0 3B D6 7D 16 8B 71 0C 57 8B 7D 08 23 C2 89 3C 86 42 5F 89 51 04 5E 5D C2 04 00 5E 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_863_125_0 {
	meta:
		name = "?Push@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QAEXPAV_UnrealizedChore@23@@Z"
		size = 49
		refs = "002d ?GrowAndPush@?$StructuredWorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AAEXPAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 51 04 8B 41 08 56 8B 31 03 F0 3B D6 7D 16 8B 71 0C 57 8B 7D 08 23 C2 89 3C 86 42 5F 89 51 04 5E 5D C2 04 00 5E 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_76_0 {
	meta:
		name = "?Block@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 256
		refs = "000d ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0024 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 005f ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 00a1 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00a9 ?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 00d5 ?GetInternalContext@ScheduleGroupBase@details@Concurrency@@IAEPAVInternalContextBase@23@PAU_Chore@23@_N@Z 00e1 ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B F1 E8 ?? ?? ?? ?? 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 03 8B CE E8 ?? ?? ?? ?? 8B 86 80 00 00 00 8A 40 79 33 DB 43 84 C0 74 30 8D 4E 2C 8B D3 F0 0F C1 11 42 3B D3 75 13 6A 02 59 8D 56 2C 8B C3 F0 0F B1 0A 3B C3 75 03 53 EB 02 6A 02 8D 4E FC E8 ?? ?? ?? ?? E9 8D 00 00 00 8D 46 2C 8B CB F0 0F C1 08 41 3B CB 75 7F 8B 56 18 8B 8E 80 00 00 00 57 6A 07 52 8D 45 F4 33 FF 83 C1 1C 50 89 7D F4 89 7D FC FF 51 18 84 C0 74 22 39 5D F4 74 1A 8B CE E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 8B CE 8B F8 E8 ?? ?? ?? ?? EB 03 8B 7D FC 6A 02 59 8D 56 2C 8B C3 F0 0F B1 0A 3B C3 75 1C 85 FF 75 0C 8B 4E 18 57 57 E8 ?? ?? ?? ?? 8B F8 53 57 8D 4E FC E8 ?? ?? ?? ?? EB 0D 85 FF 74 09 8B 07 6A 00 8B CF FF 50 18 5F 8B CE E8 ?? ?? ?? ?? 5E 5B C9 C3 }
	condition:
		$1
}

rule file_336_77_0 {
	meta:
		name = "?Yield@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 167
		refs = "000f ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0026 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 003b ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 006c ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0074 ?Bind@WorkItem@details@Concurrency@@QAEPAVInternalContextBase@23@XZ 0088 ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B F1 32 DB E8 ?? ?? ?? ?? 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 05 8B CE E8 ?? ?? ?? ?? 8B 86 80 00 00 00 38 58 79 74 0C 6A 02 8D 4E FC E8 ?? ?? ?? ?? EB 4F 8B 56 18 8B 8E 80 00 00 00 83 65 F4 00 83 65 FC 00 6A 03 52 8D 45 F4 83 C1 1C 50 FF 51 1C 84 C0 74 2B 83 7D F4 01 74 16 8B CE E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 6A 02 FF 75 FC 8D 4E FC E8 ?? ?? ?? ?? EB 02 B3 01 8B CE E8 ?? ?? ?? ?? 84 DB 74 08 8B 4E 7C 8B 01 FF 50 0C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_336_78_0 {
	meta:
		name = "?SpinYield@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 139
		refs = "000f ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0026 ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 003b ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 006c ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 0077 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 53 56 8B F1 32 DB E8 ?? ?? ?? ?? 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 05 8B CE E8 ?? ?? ?? ?? 8B 86 80 00 00 00 38 58 79 74 0C 6A 02 8D 4E FC E8 ?? ?? ?? ?? EB 33 8B 56 18 8B 8E 80 00 00 00 83 65 F4 00 83 65 FC 00 6A 01 52 8D 45 F4 83 C1 1C 50 FF 51 18 84 C0 74 0F 6A 02 FF 75 FC 8D 4E FC E8 ?? ?? ?? ?? EB 02 B3 01 8B CE E8 ?? ?? ?? ?? 84 DB 74 08 8B 4E 7C 8B 01 FF 50 0C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_336_79_0 {
	meta:
		name = "?AddToRunnables@InternalContextBase@details@Concurrency@@MAEXPAVVirtualProcessor@23@@Z"
		size = 215
		refs = "000c ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0027 ?GetScheduler@ContextBase@details@Concurrency@@QBEPAVSchedulerBase@23@XZ 0039 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0065 ?GetScheduleGroup@ContextBase@details@Concurrency@@QBEPAVScheduleGroupBase@23@XZ 0082 ?Push@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QAEXPAVInternalContextBase@23@@Z 009b ?StartupIdleVirtualProcessor@SchedulerBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@PAVVirtualProcessor@23@@Z 00b7 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 00cc ?AddRunnableContext@ScheduleGroupBase@details@Concurrency@@IAEXPAVInternalContextBase@23@PAVVirtualProcessor@23@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 57 8B F1 E8 ?? ?? ?? ?? 8B F8 85 FF 0F 84 AA 00 00 00 80 7F 40 00 0F 85 A0 00 00 00 8B CF E8 ?? ?? ?? ?? 39 46 20 0F 85 90 00 00 00 8B DF 8B CF E8 ?? ?? ?? ?? 8B 46 1C F6 40 74 02 75 77 8B 87 80 00 00 00 8B 48 0C 8B 40 08 2B C8 8B 46 20 0F B7 40 10 3B C8 7D 5E 8B 5E 1C 8B CF E8 ?? ?? ?? ?? 3B C3 74 0A C7 86 C4 00 00 00 01 00 00 00 8B 8F 80 00 00 00 56 83 C1 08 E8 ?? ?? ?? ?? 8B 46 20 8B 80 FC 00 00 00 85 C0 7E 0C FF 75 08 8B 4E 20 53 E8 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 3B C3 74 0A C7 86 C4 00 00 00 00 00 00 00 8B CF E8 ?? ?? ?? ?? EB 13 8B CB E8 ?? ?? ?? ?? FF 75 08 8B 4E 1C 56 E8 ?? ?? ?? ?? 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_336_81_0 {
	meta:
		name = "?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ"
		size = 75
		refs = "0020 ??3@YAXPAX@Z 0041 _memset"
		altNames = "?Wipe@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 57 8B F1 33 FF 39 7E 04 7E 3B 39 3E 7E 20 53 8B 46 08 8B 04 B8 85 C0 74 0F 8B 18 50 E8 ?? ?? ?? ?? 59 8B C3 85 DB 75 F1 47 3B 3E 7C E2 5B 8B 06 83 66 04 00 C1 E0 02 50 6A 00 FF 76 08 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C3 }
	condition:
		$1
}

rule file_336_82_0 {
	meta:
		name = "?SpinUntilValueEquals@details@Concurrency@@YAXPCJJ@Z"
		size = 48
		refs = "001a ?_Sleep0@details@Concurrency@@YAXXZ 0022 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B 75 08 8B 06 3B 45 0C 74 1A 83 65 F8 00 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 06 3B 45 0C 75 F1 5E C9 C3 }
	condition:
		$1
}

rule file_336_83_0 {
	meta:
		name = "?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 46
		refs = "0018 ?_Sleep0@details@Concurrency@@YAXXZ 0020 ?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B F1 8B 46 2C 85 C0 75 19 21 45 F8 C7 45 FC ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 46 2C 85 C0 74 F1 5E C9 C3 }
	condition:
		$1
}

rule file_336_84_0 {
	meta:
		name = "?SwapScheduleGroup@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@_N@Z"
		size = 71
		refs = "0018 ?SpinUntilValueEquals@details@Concurrency@@YAXPCJJ@Z 0022 ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IAEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 83 7E 1C 00 74 34 8D 86 C4 00 00 00 6A 00 50 E8 ?? ?? ?? ?? 59 59 8B 4E 1C E8 ?? ?? ?? ?? 80 7D 0C 00 8B 45 08 74 10 F6 40 74 04 75 0A 33 D2 8D 48 6C 42 F0 0F C1 11 89 46 1C 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_336_85_0 {
	meta:
		name = "?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 26
		refs = "0009 ?Cleanup@ContextBase@details@Concurrency@@QAEXXZ 0014 ?SwapScheduleGroup@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@_N@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8D 4E 04 E8 ?? ?? ?? ?? 6A 00 6A 00 8B CE E8 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_336_86_0 {
	meta:
		name = "?Cancel@InternalContextBase@details@Concurrency@@MAEXXZ"
		size = 98
		refs = "001e ?ClaimExclusiveOwnership@VirtualProcessor@details@Concurrency@@QAE_NXZ 002e ?Activate@VirtualProcessor@details@Concurrency@@QAEXPAUIExecutionContext@3@@Z 0039 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 004d ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ 0054 ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 005e ?DecrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 8B 86 84 00 00 00 57 85 C0 74 25 C6 86 94 00 00 00 01 8B 8E 84 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 0C 8B 8E 84 00 00 00 56 E8 ?? ?? ?? ?? 5F 5E C3 8D 7E 04 E8 ?? ?? ?? ?? 3B C7 75 09 C6 86 94 00 00 00 01 EB E8 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B 4E 20 5F 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_87_0 {
	meta:
		name = "?RemoveFromUse@InternalContextBase@details@Concurrency@@QAEXXZ"
		size = 37
		refs = "0009 ?ReleaseWorkQueue@ContextBase@details@Concurrency@@IAEXXZ 0014 ?SwapScheduleGroup@InternalContextBase@details@Concurrency@@QAEXPAVScheduleGroupBase@23@_N@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8D 4E 04 E8 ?? ?? ?? ?? 6A 00 6A 00 8B CE E8 ?? ?? ?? ?? 83 66 3C 00 C6 86 CC 00 00 00 01 5E C3 }
	condition:
		$1
}

rule file_336_88_0 {
	meta:
		name = "??1?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "0006 ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ 000e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_369_282_0 {
	meta:
		name = "??1?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAE@XZ"
		size = 21
		refs = "0006 ?Wipe@?$Hash@PAXPAVExternalContextBase@details@Concurrency@@@details@Concurrency@@QAEXXZ 000e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_336_89_0 {
	meta:
		name = "??1ContextBase@details@Concurrency@@QAE@XZ"
		size = 24
		refs = "0009 ?Wipe@?$Hash@PAV_TaskCollection@details@Concurrency@@PAV123@@details@Concurrency@@QAEXXZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 56 8D 71 70 8B CE E8 ?? ?? ?? ?? FF 76 08 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_336_90_0 {
	meta:
		name = "?Unblock@InternalContextBase@details@Concurrency@@UAEXXZ"
		size = 147
		refs = "0017 ?FastCurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 003d ?TraceContextEvent@ContextBase@details@Concurrency@@IAEXW4ConcRT_EventType@3@EKK@Z 0051 ?SpinUntilBlocked@InternalContextBase@details@Concurrency@@IAEXXZ 006f ??0context_unblock_unbalanced@Concurrency@@QAE@XZ 0074 __TI2?AVcontext_unblock_unbalanced@Concurrency@@ 007d __CxxThrowException@8 0085 ??0context_self_unblock@Concurrency@@QAE@XZ 008a __TI2?AVcontext_self_unblock@Concurrency@@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 8B F1 8D 7E FC F7 DF 1B FF 23 FE E8 ?? ?? ?? ?? 3B F8 74 62 8D 46 2C 83 CF FF F0 0F C1 38 4F 8B 4E 1C FF 76 08 8B 01 FF 50 04 50 6A 04 6A 04 8B CE E8 ?? ?? ?? ?? 83 FF 01 75 1F 8D 4E FC C7 46 2C 00 00 00 00 E8 ?? ?? ?? ?? 8B 46 FC 6A 00 8D 4E FC FF 50 18 5F 5E 5B C9 C3 47 83 FF 01 76 F5 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E8 EB E8 }
	condition:
		$1
}

rule file_336_97_0 {
	meta:
		name = "?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ"
		size = 29
		refs = "0009 ?EnterHyperCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0010 ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 0019 ?DecrementInternalContextCount@SchedulerBase@details@Concurrency@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 8D 4E 04 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B 4E 20 5E E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_336_98_0 {
	meta:
		name = "?IsVirtualProcessorRetired@InternalContextBase@details@Concurrency@@IAE_NXZ"
		size = 53
		refs = "001e ?SwitchOut@InternalContextBase@details@Concurrency@@IAE_NW4ReasonForSwitch@123@@Z 0029 ?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 33 C9 38 8E 96 00 00 00 75 22 8B 86 84 00 00 00 38 48 79 74 17 51 8B CE E8 ?? ?? ?? ?? 84 C0 74 07 8B CE E8 ?? ?? ?? ?? B0 01 5E C3 32 C0 5E C3 }
	condition:
		$1
}

rule file_336_99_0 {
	meta:
		name = "?Dispatch@InternalContextBase@details@Concurrency@@UAEXPAUDispatchState@3@@Z"
		size = 284
		refs = "000f __imp__GetCurrentThreadId@0 001a ?SetAsCurrentTls@ContextBase@details@Concurrency@@IAEXXZ 0022 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0032 ?ExecutedAssociatedChore@InternalContextBase@details@Concurrency@@IAE_NXZ 003d ?IsVirtualProcessorRetired@InternalContextBase@details@Concurrency@@IAE_NXZ 0075 ?SafePoint@VirtualProcessor@details@Concurrency@@QAE_NXZ 0081 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QAEHXZ 0089 ?CommitSafePoints@SchedulerBase@details@Concurrency@@QAEXXZ 009c ?WorkWasFound@InternalContextBase@details@Concurrency@@IAE_NPAVWorkItem@23@@Z 00b1 ?ExecuteChoreInline@InternalContextBase@details@Concurrency@@IAEXPAVWorkItem@23@@Z 00c3 ?WaitForWork@InternalContextBase@details@Concurrency@@IAEXXZ 00d4 ?CleanupDispatchedContextOnCancel@InternalContextBase@details@Concurrency@@IAEXXZ 00e6 ?ClearContextTls@ContextBase@details@Concurrency@@AAEXXZ 00f7 ?SwitchTo@InternalContextBase@details@Concurrency@@IAEXPAV123@W4ReasonForSwitch@123@@Z 0109 ??0nested_scheduler_missing_detach@Concurrency@@QAE@XZ 010e __TI2?AVnested_scheduler_missing_detach@Concurrency@@ 0117 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 8B F1 FF 15 ?? ?? ?? ?? 8D 4E 04 89 46 3C E8 ?? ?? ?? ?? 8D 4E 04 E8 ?? ?? ?? ?? 83 A6 90 00 00 00 00 8B CE 32 DB E8 ?? ?? ?? ?? 84 C0 74 0E 8B CE E8 ?? ?? ?? ?? 8A D8 E9 92 00 00 00 8B 86 84 00 00 00 83 65 F4 00 83 65 FC 00 80 A6 97 00 00 00 FD 85 C0 0F 84 98 00 00 00 80 BE 96 00 00 00 00 75 27 8B 8E 84 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 18 8D 4E 04 E8 ?? ?? ?? ?? 8B 4E 20 E8 ?? ?? ?? ?? 8D 4E 04 E8 ?? ?? ?? ?? 8D 45 F4 50 8B CE E8 ?? ?? ?? ?? 8B CE 84 C0 74 11 83 7D F4 01 74 45 8D 45 F4 50 E8 ?? ?? ?? ?? EB 83 E8 ?? ?? ?? ?? 84 C0 75 22 8B CE E8 ?? ?? ?? ?? 8A 86 94 00 00 00 84 C0 74 09 8B CE E8 ?? ?? ?? ?? B3 01 84 DB 0F 84 66 FF FF FF 8D 4E 04 E8 ?? ?? ?? ?? 5F 5E 5B C9 C2 04 00 6A 00 FF 75 FC E8 ?? ?? ?? ?? EB E5 8D 4E 04 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E8 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_336_103_0 {
	meta:
		name = "??1InternalContextBase@details@Concurrency@@UAE@XZ"
		size = 52
		refs = "0003 __ehhandler$??1InternalContextBase@details@Concurrency@@UAE@XZ 0008 __EH_prolog3 0014 ??_7InternalContextBase@details@Concurrency@@6BIExecutionContext@2@@ 001a ??_7InternalContextBase@details@Concurrency@@6BContextBase@12@@ 0023 ?Cleanup@InternalContextBase@details@Concurrency@@IAEXXZ 002a ??1ContextBase@details@Concurrency@@QAE@XZ 002f __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D F0 8D 71 04 C7 01 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_336_116_0 {
	meta:
		name = "??0InternalContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@@Z"
		size = 117
		refs = "0015 ??_7IExecutionContext@Concurrency@@6B@ 001a ??0ContextBase@details@Concurrency@@QAE@PAVSchedulerBase@12@_N@Z 0027 ??_7InternalContextBase@details@Concurrency@@6BIExecutionContext@2@@ 002e ??_7InternalContextBase@details@Concurrency@@6BContextBase@12@@"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 33 DB 8B F1 53 FF 75 08 8D 4E 04 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 A6 97 00 00 00 FC C7 06 ?? ?? ?? ?? C7 46 04 ?? ?? ?? ?? 89 9E 80 00 00 00 89 9E 84 00 00 00 89 9E 88 00 00 00 89 9E 8C 00 00 00 89 9E 90 00 00 00 88 9E 94 00 00 00 88 9E 96 00 00 00 89 9E C4 00 00 00 5F 89 5E 1C C6 86 CC 00 00 00 01 8B C6 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_337_3_0 {
	meta:
		name = "_write_char"
		size = 33
		refs = "0009 __putwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 B9 FF FF 00 00 66 3B C1 75 05 83 0E FF 5D C3 FF 06 5D C3 }
	condition:
		$1
}

rule file_337_4_0 {
	meta:
		name = "_write_multi_char"
		size = 36
		refs = "0011 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F0 EB 11 FF 75 08 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 59 74 06 83 7D 0C 00 7F E9 5E 5D C3 }
	condition:
		$1
}

rule file_337_5_0 {
	meta:
		name = "_write_string"
		size = 96
		refs = "000d __errno 0025 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 57 8B F0 8B D9 E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 83 20 00 EB 27 0F B7 03 FF 4D 08 50 E8 ?? ?? ?? ?? 83 C3 02 83 3E FF 59 75 12 E8 ?? ?? ?? ?? 83 38 2A 75 0E 6A 3F E8 ?? ?? ?? ?? 59 83 7D 08 00 7F D3 E8 ?? ?? ?? ?? 83 38 00 75 07 E8 ?? ?? ?? ?? 89 38 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_337_6_0 {
	meta:
		name = "_get_int_arg"
		size = 18
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 04 8B 00 8B 40 FC 5D C3 }
	condition:
		$1
}

rule file_337_7_0 {
	meta:
		name = "_get_int64_arg"
		size = 21
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 08 8B 08 8B 41 F8 8B 51 FC 5D C3 }
	condition:
		$1
}

rule file_337_8_0 {
	meta:
		name = "__vcwprintf_l"
		size = 2908
		refs = "000c ___security_cookie 005a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0063 __errno 006e __invalid_parameter_noinfo 00da ___lookuptable 0102 $LN273 0330 _write_char 041c ___nullstring 044d __isleadbyte_l 04e1 __mbtowc_l 0568 _strlen 05d1 __get_printf_count_output 0675 __malloc_crt 06e5 __cfltcvt_tab 06eb __imp__DecodePointer@4 08af __aulldvrm 090d ___wnullstring 09ce _write_string 0ae0 _free 0b35 @__security_check_cookie@4 0b3c $NORMAL_STATE$29682 0b40 $LN131 0b44 $LN130 0b48 $LN122 0b4c $LN118 0b50 $LN117 0b54 $LN113 0b58 $LN97"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 10 56 33 F6 57 FF 75 0C 8B 7D 08 8D 8D AC FB FF FF 89 9D E4 FB FF FF 89 B5 C0 FB FF FF 89 B5 F8 FB FF FF 89 B5 D4 FB FF FF 89 B5 F4 FB FF FF 89 B5 DC FB FF FF 89 B5 BC FB FF FF 89 B5 D8 FB FF FF E8 ?? ?? ?? ?? 3B FE 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 80 BD B8 FB FF FF 00 74 0A 8B 85 B4 FB FF FF 83 60 70 FD 83 C8 FF E9 9F 0A 00 00 0F B7 0F 33 D2 89 B5 EC FB FF FF 89 B5 F0 FB FF FF 89 B5 C8 FB FF FF 89 8D E8 FB FF FF 66 3B CE 0F 84 60 0A 00 00 6A 02 5E 03 FE 83 BD EC FB FF FF 00 89 BD C4 FB FF FF 0F 8C 48 0A 00 00 8D 41 E0 66 83 F8 58 77 0F 0F B7 C1 0F BE 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 0F BE 84 C2 ?? ?? ?? ?? C1 F8 04 89 85 A4 FB FF FF 83 F8 07 0F 87 ED 09 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 8D F4 FB FF FF FF 89 85 A0 FB FF FF 89 85 BC FB FF FF 89 85 D4 FB FF FF 89 85 DC FB FF FF 89 85 F8 FB FF FF 89 85 D8 FB FF FF E9 B4 09 00 00 0F B7 C1 83 E8 20 74 4A 83 E8 03 74 36 83 E8 08 74 25 2B C6 74 15 83 E8 03 0F 85 95 09 00 00 83 8D F8 FB FF FF 08 E9 89 09 00 00 83 8D F8 FB FF FF 04 E9 7D 09 00 00 83 8D F8 FB FF FF 01 E9 71 09 00 00 81 8D F8 FB FF FF 80 00 00 00 E9 62 09 00 00 09 B5 F8 FB FF FF E9 57 09 00 00 66 83 F9 2A 75 2E 83 C3 04 89 9D E4 FB FF FF 8B 5B FC 89 9D D4 FB FF FF 85 DB 0F 89 37 09 00 00 83 8D F8 FB FF FF 04 F7 DB 89 9D D4 FB FF FF E9 23 09 00 00 8B 85 D4 FB FF FF 6B C0 0A 0F B7 C9 8D 44 08 D0 89 85 D4 FB FF FF E9 08 09 00 00 83 A5 F4 FB FF FF 00 E9 FC 08 00 00 66 83 F9 2A 75 26 83 C3 04 89 9D E4 FB FF FF 8B 5B FC 89 9D F4 FB FF FF 85 DB 0F 89 DC 08 00 00 83 8D F4 FB FF FF FF E9 D0 08 00 00 8B 85 F4 FB FF FF 6B C0 0A 0F B7 C9 8D 44 08 D0 89 85 F4 FB FF FF E9 B5 08 00 00 0F B7 C1 83 F8 49 74 57 83 F8 68 74 46 83 F8 6C 74 18 83 F8 77 0F 85 9A 08 00 00 81 8D F8 FB FF FF 00 08 00 00 E9 8B 08 00 00 66 83 3F 6C 75 17 03 FE 81 8D F8 FB FF FF 00 10 00 00 89 BD C4 FB FF FF E9 6E 08 00 00 83 8D F8 FB FF FF 10 E9 62 08 00 00 83 8D F8 FB FF FF 20 E9 56 08 00 00 0F B7 07 83 F8 36 75 1F 66 83 7F 02 34 75 18 83 C7 04 81 8D F8 FB FF FF 00 80 00 00 89 BD C4 FB FF FF E9 2F 08 00 00 83 F8 33 75 1F 66 83 7F 02 32 75 18 83 C7 04 81 A5 F8 FB FF FF FF 7F FF FF 89 BD C4 FB FF FF E9 0B 08 00 00 83 F8 64 0F 84 02 08 00 00 83 F8 69 0F 84 F9 07 00 00 83 F8 6F 0F 84 F0 07 00 00 83 F8 75 0F 84 E7 07 00 00 83 F8 78 0F 84 DE 07 00 00 83 F8 58 0F 84 D5 07 00 00 83 A5 A4 FB FF FF 00 51 8D B5 EC FB FF FF C7 85 D8 FB FF FF 01 00 00 00 E8 ?? ?? ?? ?? E9 B2 07 00 00 0F B7 C1 83 F8 64 0F 8F 2D 02 00 00 0F 84 BE 02 00 00 83 F8 53 0F 8F 18 01 00 00 74 7E 83 E8 41 74 10 2B C6 74 59 2B C6 74 08 2B C6 0F 85 D1 05 00 00 83 C1 20 C7 85 A0 FB FF FF 01 00 00 00 89 8D E8 FB FF FF 83 8D F8 FB FF FF 40 83 BD F4 FB FF FF 00 8D BD FC FB FF FF B8 00 02 00 00 89 BD E0 FB FF FF 89 85 F0 FB FF FF 0F 8D 90 02 00 00 C7 85 F4 FB FF FF 06 00 00 00 E9 EC 02 00 00 F7 85 F8 FB FF FF 30 08 00 00 0F 85 C6 00 00 00 83 8D F8 FB FF FF 20 E9 BA 00 00 00 F7 85 F8 FB FF FF 30 08 00 00 75 07 83 8D F8 FB FF FF 20 8B BD F4 FB FF FF 83 FF FF 75 05 BF FF FF FF 7F 83 C3 04 F6 85 F8 FB FF FF 20 89 9D E4 FB FF FF 8B 5B FC 89 9D E0 FB FF FF 0F 84 F1 04 00 00 85 DB 75 0C 8B 1D ?? ?? ?? ?? 89 9D E0 FB FF FF 83 A5 F0 FB FF FF 00 8B F3 85 FF 0F 8E 05 05 00 00 8A 06 84 C0 0F 84 FB 04 00 00 8D 8D AC FB FF FF 0F B6 C0 51 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 01 46 46 FF 85 F0 FB FF FF 39 BD F0 FB FF FF 7C D0 E9 D0 04 00 00 83 E8 58 0F 84 FA 02 00 00 2B C6 0F 84 95 00 00 00 83 E8 07 0F 84 F8 FE FF FF 2B C6 0F 85 AE 04 00 00 0F B7 03 83 C3 04 33 F6 46 F6 85 F8 FB FF FF 20 89 B5 D8 FB FF FF 89 9D E4 FB FF FF 89 85 A8 FB FF FF 74 42 88 85 CC FB FF FF 8D 85 AC FB FF FF 50 8B 85 AC FB FF FF C6 85 CD FB FF FF 00 FF B0 AC 00 00 00 8D 85 CC FB FF FF 50 8D 85 FC FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 79 0F 89 B5 BC FB FF FF EB 07 66 89 85 FC FB FF FF 8D 85 FC FB FF FF 89 85 E0 FB FF FF 89 B5 F0 FB FF FF E9 2A 04 00 00 8B 03 83 C3 04 89 9D E4 FB FF FF 85 C0 74 3A 8B 48 04 85 C9 74 33 F7 85 F8 FB FF FF 00 08 00 00 0F BF 00 89 8D E0 FB FF FF 74 12 99 2B C2 C7 85 D8 FB FF FF 01 00 00 00 E9 E5 03 00 00 83 A5 D8 FB FF FF 00 E9 DB 03 00 00 A1 ?? ?? ?? ?? 89 85 E0 FB FF FF 50 E8 ?? ?? ?? ?? 59 E9 C4 03 00 00 83 F8 70 0F 8F 00 02 00 00 0F 84 E4 01 00 00 83 F8 65 0F 8C B2 03 00 00 83 F8 67 0F 8E EB FD FF FF 83 F8 69 74 71 83 F8 6E 74 28 83 F8 6F 0F 85 96 03 00 00 F6 85 F8 FB FF FF 80 C7 85 E8 FB FF FF 08 00 00 00 74 61 81 8D F8 FB FF FF 00 02 00 00 EB 55 8B 33 83 C3 04 89 9D E4 FB FF FF E8 ?? ?? ?? ?? 85 C0 0F 84 85 FA FF FF F6 85 F8 FB FF FF 20 74 0C 66 8B 85 EC FB FF FF 66 89 06 EB 08 8B 85 EC FB FF FF 89 06 C7 85 BC FB FF FF 01 00 00 00 E9 C7 04 00 00 83 8D F8 FB FF FF 40 C7 85 E8 FB FF FF 0A 00 00 00 8B 8D F8 FB FF FF F7 C1 00 80 00 00 0F 84 AF 01 00 00 8B 03 8B 53 04 83 C3 08 E9 DB 01 00 00 75 12 66 83 F9 67 75 63 C7 85 F4 FB FF FF 01 00 00 00 EB 57 39 85 F4 FB FF FF 7E 06 89 85 F4 FB FF FF 81 BD F4 FB FF FF A3 00 00 00 7E 3D 8B B5 F4 FB FF FF 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 59 8B 8D E8 FB FF FF 89 85 C8 FB FF FF 85 C0 74 10 8B F8 89 85 E0 FB FF FF 89 B5 F0 FB FF FF EB 0A C7 85 F4 FB FF FF A3 00 00 00 8B 03 83 C3 08 89 85 98 FB FF FF 8B 43 FC 89 85 9C FB FF FF 8D 85 AC FB FF FF 50 FF B5 A0 FB FF FF 0F BE C1 FF B5 F4 FB FF FF 89 9D E4 FB FF FF 50 FF B5 F0 FB FF FF 8D 85 98 FB FF FF 57 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 8B B5 F8 FB FF FF 83 C4 1C 81 E6 80 00 00 00 74 21 83 BD F4 FB FF FF 00 75 18 8D 85 AC FB FF FF 50 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 59 59 66 83 BD E8 FB FF FF 67 75 1C 85 F6 75 18 8D 85 AC FB FF FF 50 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 59 59 80 3F 2D 75 11 81 8D F8 FB FF FF 00 01 00 00 47 89 BD E0 FB FF FF 57 E9 02 FE FF FF C7 85 F4 FB FF FF 08 00 00 00 C7 85 C0 FB FF FF 07 00 00 00 EB 24 83 E8 73 0F 84 63 FC FF FF 2B C6 0F 84 84 FE FF FF 83 E8 03 0F 85 A7 01 00 00 C7 85 C0 FB FF FF 27 00 00 00 F6 85 F8 FB FF FF 80 C7 85 E8 FB FF FF 10 00 00 00 0F 84 64 FE FF FF 6A 30 58 66 89 85 D0 FB FF FF 8B 85 C0 FB FF FF 83 C0 51 66 89 85 D2 FB FF FF 89 B5 DC FB FF FF E9 3F FE FF FF F7 C1 00 10 00 00 0F 85 45 FE FF FF 83 C3 04 F6 C1 20 74 18 89 9D E4 FB FF FF F6 C1 40 74 06 0F BF 43 FC EB 04 0F B7 43 FC 99 EB 13 8B 43 FC F6 C1 40 74 03 99 EB 02 33 D2 89 9D E4 FB FF FF F6 C1 40 74 1B 85 D2 7F 17 7C 04 85 C0 73 11 F7 D8 83 D2 00 F7 DA 81 8D F8 FB FF FF 00 01 00 00 F7 85 F8 FB FF FF 00 90 00 00 8B DA 8B F0 75 02 33 DB 83 BD F4 FB FF FF 00 7D 0C C7 85 F4 FB FF FF 01 00 00 00 EB 1A 83 A5 F8 FB FF FF F7 B8 00 02 00 00 39 85 F4 FB FF FF 7E 06 89 85 F4 FB FF FF 8B C6 0B C3 75 06 21 85 DC FB FF FF 8D BD FB FD FF FF 8B 85 F4 FB FF FF FF 8D F4 FB FF FF 85 C0 7F 06 8B C6 0B C3 74 2D 8B 85 E8 FB FF FF 99 52 50 53 56 E8 ?? ?? ?? ?? 83 C1 30 89 9D 94 FB FF FF 8B F0 8B DA 83 F9 39 7E 06 03 8D C0 FB FF FF 88 0F 4F EB BD 8D 85 FB FD FF FF 2B C7 47 F7 85 F8 FB FF FF 00 02 00 00 89 85 F0 FB FF FF 89 BD E0 FB FF FF 74 4B 85 C0 74 05 80 3F 30 74 42 4F 89 BD E0 FB FF FF C6 07 30 40 EB 2F 85 DB 75 0C 8B 1D ?? ?? ?? ?? 89 9D E0 FB FF FF C7 85 D8 FB FF FF 01 00 00 00 8B C3 EB 09 4F 66 83 38 00 74 06 03 C6 85 FF 75 F3 2B C3 D1 F8 89 85 F0 FB FF FF 83 BD BC FB FF FF 00 0F 85 87 01 00 00 8B 85 F8 FB FF FF A8 40 74 2B A9 00 01 00 00 74 04 6A 2D EB 0E A8 01 74 04 6A 2B EB 06 A8 02 74 14 6A 20 58 66 89 85 D0 FB FF FF C7 85 DC FB FF FF 01 00 00 00 8B 9D D4 FB FF FF 2B 9D F0 FB FF FF 2B 9D DC FB FF FF F6 85 F8 FB FF FF 0C 75 22 8B FB 85 DB 7E 1C 6A 20 8D B5 EC FB FF FF 4F E8 ?? ?? ?? ?? 83 BD EC FB FF FF FF 59 74 04 85 FF 7F E4 FF B5 DC FB FF FF 8D 85 EC FB FF FF 8D 8D D0 FB FF FF E8 ?? ?? ?? ?? F6 85 F8 FB FF FF 08 59 74 2B F6 85 F8 FB FF FF 04 75 22 8B FB 85 DB 7E 1C 6A 30 8D B5 EC FB FF FF 4F E8 ?? ?? ?? ?? 83 BD EC FB FF FF FF 59 74 04 85 FF 7F E4 83 BD D8 FB FF FF 00 75 7A 83 BD F0 FB FF FF 00 7E 71 8B 85 F0 FB FF FF 8B BD E0 FB FF FF 89 85 E8 FB FF FF FF 8D E8 FB FF FF 8D 85 AC FB FF FF 50 8B 85 AC FB FF FF FF B0 AC 00 00 00 8D 85 A8 FB FF FF 57 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 94 FB FF FF 85 C0 7E 23 FF B5 A8 FB FF FF 8D B5 EC FB FF FF E8 ?? ?? ?? ?? 03 BD 94 FB FF FF 83 BD E8 FB FF FF 00 59 7F AC EB 21 83 8D EC FB FF FF FF EB 18 FF B5 F0 FB FF FF 8B 8D E0 FB FF FF 8D 85 EC FB FF FF E8 ?? ?? ?? ?? 59 83 BD EC FB FF FF 00 7C 25 F6 85 F8 FB FF FF 04 EB 16 6A 20 8D B5 EC FB FF FF 4B E8 ?? ?? ?? ?? 83 BD EC FB FF FF FF 59 74 04 85 DB 7F E4 83 BD C8 FB FF FF 00 74 13 FF B5 C8 FB FF FF E8 ?? ?? ?? ?? 83 A5 C8 FB FF FF 00 59 8B BD C4 FB FF FF 0F B7 07 89 85 E8 FB FF FF 66 85 C0 74 13 8B 95 A4 FB FF FF 8B 9D E4 FB FF FF 8B C8 E9 A0 F5 FF FF 80 BD B8 FB FF FF 00 74 0A 8B 85 B4 FB FF FF 83 60 70 FD 8B 85 EC FB FF FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_337_11_0 {
	meta:
		name = "__vcwprintf"
		size = 23
		refs = "000e __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_538_12_0 {
	meta:
		name = "__vcprintf"
		size = 23
		refs = "000e __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_13_0 {
	meta:
		name = "__vcprintf_p"
		size = 23
		refs = "000e __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_375_12_0 {
	meta:
		name = "__vcprintf_s"
		size = 23
		refs = "000e __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_923_11_0 {
	meta:
		name = "__vcwprintf_p"
		size = 23
		refs = "000e __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_667_11_0 {
	meta:
		name = "__vcwprintf_s"
		size = 23
		refs = "000e __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 0C 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_338_2_0 {
	meta:
		name = "__wsearchenv_s"
		size = 863
		refs = "000c ___security_cookie 0049 __errno 0053 __invalid_parameter_noinfo 007f __waccess_s 00a5 __wfullpath 00cb __wdupenv_s 00e5 __invoke_watson 00ff _wcslen 0130 __calloc_crt 0182 __wgetpath 0254 _wcscpy_s 02ae _free 02ca @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 30 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 8B 5D 10 56 33 C9 57 8B 7D 08 89 85 E4 FD FF FF 8B 45 14 89 BD D0 FD FF FF 89 85 DC FD FF FF 89 8D D8 FD FF FF 89 8D E8 FD FF FF 3B D9 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? E9 63 02 00 00 3B C1 76 E8 3B F9 75 07 33 C0 66 89 03 EB DD 66 39 0F 0F 84 0E 02 00 00 E8 ?? ?? ?? ?? 8B 30 6A 00 57 E8 ?? ?? ?? ?? 59 59 89 85 E0 FD FF FF E8 ?? ?? ?? ?? 89 30 33 F6 39 B5 E0 FD FF FF 75 20 FF B5 DC FD FF FF 57 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 E5 01 00 00 66 89 03 E9 D6 01 00 00 FF B5 E4 FD FF FF 8D 85 D8 FD FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 13 83 F8 16 0F 85 A3 01 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 8B 85 D8 FD FF FF 3B C6 0F 84 8B 01 00 00 57 89 85 E4 FD FF FF E8 ?? ?? ?? ?? 8B F0 8D 85 EC FD FF FF 89 85 E8 FD FF FF B8 08 01 00 00 59 8B F8 3B F0 72 39 FF B5 E4 FD FF FF E8 ?? ?? ?? ?? 8D 7C 30 02 6A 02 57 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E8 FD FF FF 85 C0 75 15 33 C0 66 89 03 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 3C 01 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 D4 FD FF FF E9 0D 01 00 00 8B 85 E4 FD FF FF 8B CF 2B CE 49 51 FF B5 E8 FD FF FF 89 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 FD FF FF 85 C0 75 6A 8D 85 EC FD FF FF 39 85 E8 FD FF FF 0F 85 DD 00 00 00 E8 ?? ?? ?? ?? 83 38 22 0F 85 CF 00 00 00 FF B5 E0 FD FF FF E8 ?? ?? ?? ?? 8D 7C 30 02 6A 02 57 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E8 FD FF FF 85 C0 0F 84 66 FF FF FF 8B CF 2B CE 51 50 FF B5 E0 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 FD FF FF 85 C0 0F 84 85 00 00 00 8B 85 E8 FD FF FF 66 83 38 00 74 79 50 E8 ?? ?? ?? ?? 8B 95 E8 FD FF FF 89 85 E0 FD FF FF 8D 04 42 59 0F B7 48 FE 83 F9 2F 74 19 83 F9 5C 74 14 83 F9 3A 74 0F 6A 5C 59 66 89 08 83 C0 02 FF 85 E0 FD FF FF FF B5 D0 FD FF FF 8B C8 2B CA D1 F9 8B D7 2B D1 52 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 F0 00 00 00 50 FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 5B 83 BD E4 FD FF FF 00 0F 85 E6 FE FF FF 33 C0 66 89 03 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 30 8D 85 EC FD FF FF 39 85 E8 FD FF FF 74 0C FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 FF B5 D8 FD FF FF E8 ?? ?? ?? ?? 59 8B 4D FC 5F 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8B 85 E0 FD FF FF 03 C6 3B 85 DC FD FF FF 72 2C 33 C0 66 89 03 8D 85 EC FD FF FF 39 85 E8 FD FF FF 74 0C FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 86 E8 ?? ?? ?? ?? FF B5 E8 FD FF FF 8B 8D D4 FD FF FF FF B5 DC FD FF FF 89 08 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 21 8D 85 EC FD FF FF 39 85 E8 FD FF FF 74 0C FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 33 F6 E9 46 FF FF FF 33 C0 50 50 50 50 50 E9 85 FD FF FF }
	condition:
		$1
}

rule file_339_1_0 {
	meta:
		name = "_comexecmd"
		size = 113
		refs = "000e __errno 0019 __invalid_parameter_noinfo 003a __cenvarg 0053 __dospawn 005d _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF C9 C3 83 7D 0C 00 74 E5 FF 75 08 8D 45 F8 50 8D 45 FC 50 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D7 56 FF 75 F8 FF 75 FC FF 75 08 6A 02 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_355_1_0 {
	meta:
		name = "_wcomexecmd"
		size = 113
		refs = "000e __errno 0019 __invalid_parameter_noinfo 003a __wcenvarg 0053 __wdospawn 005d _free"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 83 7D 08 00 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF C9 C3 83 7D 0C 00 74 E5 FF 75 08 8D 45 F8 50 8D 45 FC 50 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D7 56 FF 75 F8 FF 75 FC FF 75 08 6A 02 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_339_2_0 {
	meta:
		name = "__execve"
		size = 483
		refs = "0014 __errno 001f __invalid_parameter_noinfo 0048 __mbsrchr 0065 __mbschr 0073 _strlen 007e __calloc_crt 0093 ??_C@_02CEGDFPFP@?4?2?$AA@ 009a _strcpy_s 00a9 _strcat_s 00c1 __invoke_watson 00e7 __access_s 00ff _comexecmd 0166 _ext_strings 01bb _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 57 8B 7D 08 89 7D FC 85 FF 75 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF E9 06 01 00 00 80 3F 00 74 E3 8B 45 0C 85 C0 74 DC 8B 00 85 C0 74 D6 80 38 00 74 D1 53 56 6A 5C 57 E8 ?? ?? ?? ?? 6A 2F 57 8B F0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 68 85 F6 75 6E 6A 3A 57 E8 ?? ?? ?? ?? 8B F0 59 59 85 F6 75 5E 57 E8 ?? ?? ?? ?? 8D 70 03 6A 01 56 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 89 5D FC 85 DB 0F 84 9A 00 00 00 68 ?? ?? ?? ?? 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 14 57 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 05 8D 73 02 EB 16 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 85 F6 74 04 3B C6 76 02 8B F0 83 4D F4 FF 6A 2E 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 2D 6A 00 FF 75 FC E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 CE 00 00 00 FF 75 10 FF 75 0C FF 75 FC E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 E9 B5 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 8D 70 05 6A 01 56 E8 ?? ?? ?? ?? 8B D8 33 FF 83 C4 0C 3B DF 75 08 83 C8 FF 5E 5B 5F C9 C3 FF 75 FC 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 90 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 59 8D 3C 03 E8 ?? ?? ?? ?? 8B 00 2B F7 89 45 F0 03 F3 C7 45 F8 ?? ?? ?? ?? 8B 45 F8 FF 30 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 38 FF FF FF 50 53 E8 ?? ?? ?? ?? 59 59 85 C0 74 0F 83 6D F8 04 81 7D F8 ?? ?? ?? ?? 7D CF EB 1C E8 ?? ?? ?? ?? FF 75 10 8B 4D F0 FF 75 0C 89 08 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 53 E8 ?? ?? ?? ?? 8B 7D 08 59 39 7D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 E9 56 FF FF FF 57 57 57 57 57 E9 DD FE FF FF }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "__dup2_nolock"
		size = 272
		refs = "0018 ___pioinfo 0029 __errno 0034 ___doserrno 0075 __close_nolock 0086 __imp__GetCurrentProcess@0 008f __get_osfhandle 009e __imp__DuplicateHandle@28 00a8 __imp__GetLastError@0 00b5 __set_osfhnd 00c3 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 8B 5D 08 56 8B 75 08 C1 FB 05 83 E6 1F 8D 1C 9D ?? ?? ?? ?? 8B 03 C1 E6 06 F6 44 30 04 01 75 1B E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 20 00 83 C8 FF E9 C9 00 00 00 8B 4D 0C 39 4D 08 75 07 33 C0 E9 BA 00 00 00 57 8B C1 C1 F8 05 8D 04 85 ?? ?? ?? ?? 8B F9 83 E7 1F 89 45 F8 8B 00 C1 E7 06 F6 44 38 04 01 74 07 51 E8 ?? ?? ?? ?? 59 6A 02 6A 01 6A 00 8D 45 FC 50 FF 15 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 0F FF 75 FC FF 75 0C E8 ?? ?? ?? ?? 59 59 33 C0 85 C0 74 0C 50 E8 ?? ?? ?? ?? 59 83 C8 FF EB 3E 8B 03 8A 44 30 04 8B 4D F8 8B 11 24 EF 88 44 3A 04 8B 01 8B 13 8A 54 32 24 8D 44 38 24 32 10 80 E2 7F 30 10 8B 01 8B 0B 8D 7C 38 24 8B 03 8A 44 30 24 32 07 24 7F 32 44 31 24 88 07 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_340_1_0 {
	meta:
		name = "_extend_ioinfo_arrays"
		size = 110
		refs = "0005 __nhandle 000c ___pioinfo 001a __calloc_crt"
	strings:
		$1 = { 8B FF 56 3B 3D ?? ?? ?? ?? 7C 5A BE ?? ?? ?? ?? 83 3E 00 75 45 6A 40 6A 20 E8 ?? ?? ?? ?? 59 59 85 C0 74 45 83 05 ?? ?? ?? ?? 20 8D 88 00 08 00 00 89 06 3B C1 73 23 83 C0 05 83 48 FB FF 83 60 03 00 66 C7 40 FF 00 0A 8B 0E 83 C0 40 81 C1 00 08 00 00 8D 50 FB 3B D1 72 E0 83 C6 04 3B 3D ?? ?? ?? ?? 7D AB 33 C0 5E C3 83 C8 FF 5E C3 }
	condition:
		$1
}

rule file_340_2_0 {
	meta:
		name = "__dup2"
		size = 261
		refs = "0003 __sehtable$__dup2 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0036 __nhandle 0051 __invalid_parameter_noinfo 0067 ___pioinfo 0097 _extend_ioinfo_arrays 00b5 ___lock_fhandle 00d2 __dup2_nolock 00eb __SEH_epilog4 00f8 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 83 FE FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 BB 00 00 00 33 DB 3B F3 7C 09 A1 ?? ?? ?? ?? 3B F0 72 19 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? EB D0 8B CE C1 F9 05 8B D6 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 0F BE 4C 11 04 83 E1 01 74 C9 8B 7D 0C 83 FF FE 75 09 E8 ?? ?? ?? ?? 89 18 EB 96 81 FF 00 08 00 00 1B C9 F7 D9 74 AC 3B F8 7C 19 E8 ?? ?? ?? ?? 85 C0 74 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E9 78 FF FF FF 3B F7 7D 09 56 E8 ?? ?? ?? ?? 57 EB 09 7E 0E 57 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 89 5D FC 57 56 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 0F 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 7D 0C 8B 75 08 56 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "_wcstok"
		size = 174
		refs = "0007 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 8B 4D 08 89 45 FC 85 C9 75 03 8B 48 1C 0F B7 11 56 57 66 85 D2 74 31 8B 45 0C 0F B7 00 8B 7D 0C 66 85 C0 74 12 8B F0 66 3B F2 74 0B 83 C7 02 0F B7 37 66 85 F6 75 F0 66 83 3F 00 74 0B 83 C1 02 0F B7 11 66 85 D2 75 D5 66 83 39 00 89 4D 08 74 3C 8B 45 0C 0F B7 00 8B 75 0C 66 85 C0 74 15 0F B7 39 8B D0 66 3B D7 74 0B 83 C6 02 0F B7 16 66 85 D2 75 F0 66 83 3E 00 75 0B 83 C1 02 66 83 39 00 75 D4 EB 08 33 C0 66 89 01 83 C1 02 8B 45 FC 89 48 1C 8B 45 08 2B C1 F7 D8 1B C0 23 45 08 5F 5E C9 C3 }
	condition:
		$1
}

rule file_342_2_0 {
	meta:
		name = "__wstat64"
		size = 1105
		refs = "000c ___security_cookie 002b ___doserrno 0032 __errno 003d __invalid_parameter_noinfo 004b ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0051 _wcspbrk 0088 _towlower 0096 __getdrive 00ae __imp__FindFirstFileExW@24 00c2 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00ed __wfullpath_helper 0100 _wcslen 010b _IsRootUNCName 0116 __imp__GetDriveTypeW@4 012e _free 0161 ___loctotime64_t 01d0 __wsopen_s 01f4 __fstat64 0201 __close 0237 __imp__FileTimeToLocalFileTime@8 0253 __imp__FileTimeToSystemTime@8 03d3 __imp__FindClose@4 03df ___wdtoxmode 0428 __imp__GetLastError@0 042e __dosmaperr 044b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 33 DB 57 8B 7D 0C 89 B5 8C FB FF FF 3B F3 75 1C E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? E9 F9 03 00 00 3B FB 74 E0 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 CE 03 00 00 66 83 7E 02 3A 75 1D 0F B7 06 66 3B C3 74 06 66 39 5E 04 74 D5 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 53 53 53 89 85 84 FB FF FF 8D 85 94 FB FF FF 50 53 56 FF 15 ?? ?? ?? ?? 89 85 90 FB FF FF 83 F8 FF 0F 85 E3 00 00 00 68 ?? ?? ?? ?? 56 89 9D 90 FB FF FF E8 ?? ?? ?? ?? 59 59 85 C0 74 83 8D 85 90 FB FF FF 50 68 04 01 00 00 8D 85 F4 FD FF FF 56 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 3B F3 0F 84 89 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 03 74 09 E8 ?? ?? ?? ?? 85 C0 74 74 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 68 39 9D 90 FB FF FF 74 0C FF B5 90 FB FF FF E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 33 C0 6A 01 68 BC 07 00 00 C7 85 94 FB FF FF 10 00 00 00 89 9D B0 FB FF FF 89 9D B4 FB FF FF 66 89 85 C0 FB FF FF E8 ?? ?? ?? ?? 8B B5 8C FB FF FF 8B CA 83 C4 1C 89 47 28 89 57 2C 89 47 20 89 4F 24 89 47 30 89 4F 34 E9 50 02 00 00 39 9D 90 FB FF FF 0F 84 C8 FE FF FF FF B5 90 FB FF FF E8 ?? ?? ?? ?? 59 E9 B7 FE FF FF F7 85 94 FB FF FF 00 04 00 00 74 5F 81 BD B8 FB FF FF 0C 00 00 A0 75 53 83 8D 90 FB FF FF FF 53 6A 40 53 8D 85 90 FB FF FF 56 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 7C FE FF FF 83 BD 90 FB FF FF FF 0F 84 6F FE FF FF 57 FF B5 90 FB FF FF E8 ?? ?? ?? ?? FF B5 90 FB FF FF 8B F0 E8 ?? ?? ?? ?? 83 C4 0C 8B C6 E9 33 02 00 00 39 9D A8 FB FF FF 75 10 39 9D AC FB FF FF 75 08 89 5F 28 89 5F 2C EB 78 8D 85 88 FB FF FF 50 8D 85 A8 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E3 01 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C7 01 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C 39 9D A0 FB FF FF 75 16 39 9D A4 FB FF FF 75 0E 8B 47 28 89 47 20 8B 47 2C 89 47 24 EB 78 8D 85 88 FB FF FF 50 8D 85 A0 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 4D 01 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 31 01 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 39 9D 98 FB FF FF 75 16 39 9D 9C FB FF FF 75 0E 8B 47 28 89 47 30 8B 47 2C 89 47 34 EB 78 8D 85 88 FB FF FF 50 8D 85 98 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B7 00 00 00 8D 85 E4 FD FF FF 50 8D 85 88 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 9B 00 00 00 0F B7 85 F0 FD FF FF 6A FF 50 0F B7 85 EE FD FF FF 50 0F B7 85 EC FD FF FF 50 0F B7 85 EA FD FF FF 50 0F B7 85 E6 FD FF FF 50 0F B7 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 30 89 57 34 FF B5 90 FB FF FF FF 15 ?? ?? ?? ?? 56 FF B5 94 FB FF FF E8 ?? ?? ?? ?? 66 89 47 06 33 C0 40 66 89 47 08 33 C0 33 F6 03 85 B4 FB FF FF 59 59 8B 8D B0 FB FF FF 13 CE 89 47 18 33 C0 66 89 47 04 66 89 47 0C 66 89 47 0A 8B 85 84 FB FF FF 48 89 07 89 47 10 89 4F 1C 33 C0 EB 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF B5 90 FB FF FF FF 15 ?? ?? ?? ?? 83 C8 FF 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "_fputws"
		size = 164
		refs = "0003 __sehtable$_fputws 0008 __SEH_prolog4 001e __errno 0029 __invalid_parameter_noinfo 0044 _wcslen 004f __lock_file 0071 __fputwc_nolock 0095 __SEH_epilog4 009e __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 E0 33 C0 39 75 08 0F 95 C0 3B C6 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 FF FF 00 00 EB 60 33 C0 39 75 0C 0F 95 C0 3B C6 74 DD FF 75 08 E8 ?? ?? ?? ?? 89 45 E4 FF 75 0C E8 ?? ?? ?? ?? 59 59 89 75 FC 8B 45 E4 FF 4D E4 85 C0 74 23 8B 45 08 0F B7 00 83 45 08 02 FF 75 0C 50 E8 ?? ?? ?? ?? 59 59 B9 FF FF 00 00 66 3B C1 75 D7 83 4D E0 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "__telli64"
		size = 24
		refs = "000f __lseeki64"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_345_1_0 {
	meta:
		name = "__getenv_helper_nolock"
		size = 135
		refs = "0007 ___env_initialized 000f __environ 0020 __wenviron 0027 ___wtomb_environ 0043 _strlen 0065 __mbsnbicoll"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 EB 63 57 85 F6 75 1B 39 35 ?? ?? ?? ?? 74 53 E8 ?? ?? ?? ?? 85 C0 75 4A 8B 35 ?? ?? ?? ?? 85 F6 74 40 83 7D 08 00 74 3A FF 75 08 E8 ?? ?? ?? ?? 59 8B F8 EB 27 50 E8 ?? ?? ?? ?? 59 3B C7 76 19 8B 06 80 3C 38 3D 75 11 57 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 06 85 C0 75 D3 33 C0 5F 5E 5D C3 8B 06 8D 44 38 01 EB F4 }
	condition:
		$1
}

rule file_345_2_0 {
	meta:
		name = "__getenv_s_helper"
		size = 139
		refs = "0010 __errno 001a __invalid_parameter_noinfo 0042 __getenv_helper_nolock 004f _strlen 0071 _strcpy_s 0086 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B F0 33 DB 3B F3 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 43 8B 45 08 89 1E 3B C3 74 07 39 5D 0C 77 07 EB DD 39 5D 0C 75 D8 3B C3 74 02 88 18 57 FF 75 10 E8 ?? ?? ?? ?? 8B F8 59 3B FB 74 2F 57 E8 ?? ?? ?? ?? 40 59 89 06 39 5D 0C 74 20 3B 45 0C 76 08 6A 22 58 5F 5E 5B 5D C3 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 04 33 C0 EB E4 53 53 53 53 53 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_345_3_0 {
	meta:
		name = "__dupenv_s_helper"
		size = 156
		refs = "0010 __errno 001a __invalid_parameter_noinfo 0037 __getenv_helper_nolock 0044 _strlen 004f _calloc 0079 _strcpy_s 0097 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B F8 33 F6 3B FE 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 4F 8B 45 08 89 37 3B C6 74 02 89 30 39 75 0C 74 DD 53 FF 75 0C E8 ?? ?? ?? ?? 8B D8 59 3B DE 74 4B 53 E8 ?? ?? ?? ?? 8D 70 01 6A 01 56 E8 ?? ?? ?? ?? 89 07 33 FF 83 C4 0C 3B C7 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 5B 5F 5E 5D C3 53 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0D 8B 45 08 3B C7 74 02 89 30 33 C0 EB DF 57 57 57 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_345_5_0 {
	meta:
		name = "_getenv_s"
		size = 205
		refs = "0003 __sehtable$_getenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0032 __invalid_parameter_noinfo 0067 __getenv_helper_nolock 0074 _strlen 0097 _strcpy_s 00b5 __SEH_epilog4 00c0 __invoke_watson 00c7 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 DB 89 5D FC 33 C0 8B 7D 08 3B FB 0F 95 C0 3B C3 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 89 75 E4 EB 6A 89 1F 8B 4D 0C 3B CB 74 09 39 5D 10 77 09 3B CB 75 0A 39 5D 10 75 05 33 C0 40 EB 02 33 C0 3B C3 74 CA 3B CB 74 02 88 19 FF 75 14 E8 ?? ?? ?? ?? 59 8B F0 3B F3 74 30 56 E8 ?? ?? ?? ?? 59 40 89 07 39 5D 10 74 21 3B 45 10 76 09 C7 45 E4 22 00 00 00 EB 16 56 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 3B C3 75 18 89 5D E4 C7 45 FC FE FF FF FF E8 13 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 53 53 53 53 53 E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_345_6_0 {
	meta:
		name = "__dupenv_s"
		size = 215
		refs = "0003 __sehtable$__dupenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0032 __invalid_parameter_noinfo 0056 __getenv_helper_nolock 0063 _strlen 006e _calloc 0098 _strcpy_s 00bf __SEH_epilog4 00ca __invoke_watson 00d1 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 7D 08 3B FE 0F 95 C0 3B C6 75 14 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 89 75 E4 EB 74 89 37 8B 45 0C 3B C6 74 02 89 30 33 C0 39 75 10 0F 95 C0 3B C6 74 D5 FF 75 10 E8 ?? ?? ?? ?? 59 8B D8 3B DE 74 D5 53 E8 ?? ?? ?? ?? 8D 70 01 6A 01 56 E8 ?? ?? ?? ?? 83 C4 0C 89 07 33 FF 3B C7 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 E4 EB 1B 53 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 75 21 8B 45 0C 3B C7 74 02 89 30 89 7D E4 C7 45 FC FE FF FF FF E8 13 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 57 57 57 57 57 E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "___crtCompareStringW"
		size = 99
		refs = "0012 _wcsnlen 0044 __imp__CompareStringW@24"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 14 85 F6 7E 0D 56 FF 75 10 E8 ?? ?? ?? ?? 59 59 8B F0 8B 45 1C 85 C0 7E 0B 50 FF 75 18 E8 ?? ?? ?? ?? 59 59 85 F6 74 1A 85 C0 74 16 50 FF 75 18 56 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? EB 16 8B CE 2B C8 75 05 6A 02 58 EB 0B 33 C0 85 C9 0F 99 C0 8D 44 00 01 5E 5D C3 }
	condition:
		$1
}

rule file_347_5_0 {
	meta:
		name = "?_Initialize@_SpinCount@details@Concurrency@@SAXXZ"
		size = 23
		refs = "0001 ?GetProcessorCount@Concurrency@@YAIXZ 0012 ?_S_spinCount@_SpinCount@details@Concurrency@@2IA"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 41 3B C8 1B C0 25 A0 0F 00 00 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_347_7_0 {
	meta:
		name = "??0_NonReentrantBlockingLock@details@Concurrency@@QAE@XZ"
		size = 22
		refs = "0005 ?_S_spinCount@_SpinCount@details@Concurrency@@2IA 000e __imp__InitializeCriticalSectionAndSpinCount@8"
		altNames = "??0_ReentrantBlockingLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B FF 56 FF 35 ?? ?? ?? ?? 8B F1 56 FF 15 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_347_11_0 {
	meta:
		name = "?_TryAcquire@_NonReentrantBlockingLock@details@Concurrency@@QAE_NXZ"
		size = 16
		refs = "0005 __imp__TryEnterCriticalSection@4"
		altNames = "?_TryAcquire@_ReentrantBlockingLock@details@Concurrency@@QAE_NXZ"
	strings:
		$1 = { 8B FF 51 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 C3 }
	condition:
		$1
}

rule file_347_19_0 {
	meta:
		name = "?_TryAcquire@_ReentrantLock@details@Concurrency@@QAE_NXZ"
		size = 46
		refs = "0008 __imp__GetCurrentThreadId@0"
	strings:
		$1 = { 8B FF 56 57 8B F1 FF 15 ?? ?? ?? ?? 8B C8 8B D1 8D 7E 04 83 C8 FF F0 0F B1 17 83 F8 FF 74 08 3B C1 74 04 32 C0 EB 04 FF 06 B0 01 5F 5E C3 }
	condition:
		$1
}

rule file_347_21_0 {
	meta:
		name = "?_Release@_ReentrantLock@details@Concurrency@@QAEXXZ"
		size = 39
		refs = "0007 __imp__GetCurrentThreadId@0"
	strings:
		$1 = { 8B FF 56 8B F1 FF 15 ?? ?? ?? ?? 8B 4E 04 3B C8 75 13 8B 06 83 F8 01 7C 0C 48 89 06 75 07 C7 46 04 FF FF FF FF 5E C3 }
	condition:
		$1
}

rule file_347_22_0 {
	meta:
		name = "??0_ReaderWriterLock@details@Concurrency@@QAE@XZ"
		size = 16
		altNames = "??0_Generic_error_category@std@@QAE@XZ ??0_Iostream_error_category@std@@QAE@XZ"
	strings:
		$1 = { 8B C1 C7 00 00 00 00 00 C7 40 04 00 00 00 00 C3 }
	condition:
		$1
}

rule file_347_24_0 {
	meta:
		name = "?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
		size = 17
	strings:
		$1 = { C7 01 00 00 00 00 83 C1 04 83 C8 FF F0 0F C1 01 C3 }
	condition:
		$1
}

rule file_347_25_0 {
	meta:
		name = "?_TryAcquireWrite@_ReaderWriterLock@details@Concurrency@@QAE_NXZ"
		size = 33
	strings:
		$1 = { 8B FF 56 83 CA FF 8B F1 33 C0 F0 0F B1 16 5E 85 C0 75 0B 40 83 C1 04 8B D0 F0 0F C1 11 C3 32 C0 C3 }
	condition:
		$1
}

rule file_347_26_0 {
	meta:
		name = "?_WaitEquals@_ReaderWriterLock@details@Concurrency@@CAXADJJJ@Z"
		size = 73
		refs = "001c __imp__Sleep@4 0025 ?_S_spinCount@_SpinCount@details@Concurrency@@2IA"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B 75 08 8B 0E 23 4D 10 33 C0 6A 0A 5B 3B 4D 0C 74 2C 57 8B 3D ?? ?? ?? ?? F3 90 40 3B 05 ?? ?? ?? ?? 72 0F 85 DB 7E 05 4B 6A 00 EB 02 6A 01 FF D7 33 C0 8B 0E 23 4D 10 3B 4D 0C 75 DC 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_347_27_0 {
	meta:
		name = "?_FlushWriteOwners@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
		size = 23
		refs = "000f ?_WaitEquals@_ReaderWriterLock@details@Concurrency@@CAXADJJJ@Z"
	strings:
		$1 = { 8D 41 04 8B 08 85 C9 7E 0D 6A FF 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_347_28_0 {
	meta:
		name = "??0LockQueueNode@details@Concurrency@@QAE@XZ"
		size = 27
		refs = "0011 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 66 04 00 C7 46 08 01 00 00 00 E8 ?? ?? ?? ?? 89 06 8B C6 5E C3 }
	condition:
		$1
}

rule file_347_29_0 {
	meta:
		name = "??0LockQueueNode@details@Concurrency@@QAE@PAVContext@2@I@Z"
		size = 26
	strings:
		$1 = { 8B FF 55 8B EC 8B C1 8B 4D 08 83 60 04 00 89 08 8B 4D 0C 89 48 08 5D C2 08 00 }
	condition:
		$1
}

rule file_347_32_0 {
	meta:
		name = "?Copy@LockQueueNode@details@Concurrency@@QAEXPAV123@@Z"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 50 08 89 51 08 8B 50 04 89 51 04 8B 00 89 01 5D C2 04 00 }
	condition:
		$1
}

rule file_347_36_0 {
	meta:
		name = "??0critical_section@Concurrency@@QAE@XZ"
		size = 23
		altNames = "??0_NonReentrantPPLLock@details@Concurrency@@QAE@XZ"
	strings:
		$1 = { 8B C1 33 C9 89 48 0C 89 48 10 89 08 89 48 04 C7 40 08 02 00 00 00 C3 }
	condition:
		$1
}

rule file_347_39_0 {
	meta:
		name = "??0reader_writer_lock@Concurrency@@QAE@XZ"
		size = 29
	strings:
		$1 = { 8B C1 33 C9 89 48 0C 89 48 10 89 48 14 89 48 18 89 08 89 48 04 C7 40 08 02 00 00 00 C3 }
	condition:
		$1
}

rule file_347_41_0 {
	meta:
		name = "?try_lock_read@reader_writer_lock@Concurrency@@QAE_NXZ"
		size = 40
	strings:
		$1 = { 8B FF 56 57 8D 51 18 EB 0F 8D 71 08 8B FA 8B C1 F0 0F B1 37 3B C1 74 0C 8B 0A F6 C1 03 74 EA 32 C0 5F 5E C3 B0 01 EB F9 }
	condition:
		$1
}

rule file_347_42_0 {
	meta:
		name = "?_Set_next_writer@reader_writer_lock@Concurrency@@AAE_NPAX@Z"
		size = 69
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 89 41 10 83 C1 18 33 D2 57 42 8B F1 8B 06 8B F8 0B FA F0 0F B1 3E 75 F6 A8 04 75 18 6A 02 5A 8B 01 8B F0 0B F2 F0 0F B1 31 75 F6 83 F8 08 7D 04 B0 01 EB 02 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_347_43_0 {
	meta:
		name = "?_Get_reader_convoy@reader_writer_lock@Concurrency@@AAEPAXXZ"
		size = 38
	strings:
		$1 = { 8B FF 56 8D 51 18 6A 04 58 8B F2 F0 0F C1 06 5E A8 01 74 0A A8 02 75 06 6A 02 58 F0 09 02 33 C0 83 C1 0C 87 01 C3 }
	condition:
		$1
}

rule file_347_44_0 {
	meta:
		name = "?_Unlock_reader@reader_writer_lock@Concurrency@@AAEXXZ"
		size = 35
	strings:
		$1 = { 6A F8 58 8D 51 18 F0 0F C1 02 83 E0 FB 83 F8 0B 75 10 8B 41 10 83 60 08 FE 8B 00 8B 10 8B C8 FF 62 0C C3 }
	condition:
		$1
}

rule file_347_47_0 {
	meta:
		name = "?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
		size = 38
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 75 09 C7 41 08 04 00 00 00 EB 0D 83 61 04 00 89 01 C7 41 08 01 00 00 00 5D C2 04 00 }
	condition:
		$1
}

rule file_347_52_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$0A@@details@Concurrency@@IAEXXZ"
		size = 16
		refs = "0006 ?_S_spinCount@_SpinCount@details@Concurrency@@2IA 000b ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 83 61 08 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_347_63_0 {
	meta:
		name = "?_Reset@?$_SpinWait@$00@details@Concurrency@@IAEXXZ"
		size = 16
		refs = "0006 ?_S_spinCount@_SpinCount@details@Concurrency@@2IA 000b ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 83 61 08 00 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_347_57_0 {
	meta:
		name = "??0_ReentrantPPLLock@details@Concurrency@@QAE@XZ"
		size = 33
	strings:
		$1 = { 8B C1 33 C9 89 48 0C 89 48 10 89 08 89 48 04 C7 40 08 02 00 00 00 C7 40 18 FF FF FF FF 89 48 14 C3 }
	condition:
		$1
}

rule file_347_58_0 {
	meta:
		name = "?_AcquireRead@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
		size = 55
		refs = "0016 ?_WaitEquals@_ReaderWriterLock@details@Concurrency@@CAXADJJJ@Z"
	strings:
		$1 = { 8B FF 53 56 8B F1 57 8D 7E 04 8B 07 85 C0 7E 0D 6A FF 6A 00 57 E8 ?? ?? ?? ?? 83 C4 0C 8B 0E 83 F9 FF 74 E6 8D 51 01 8B DE 8B C1 F0 0F B1 13 3B C1 75 D7 5F 5E 5B C3 }
	condition:
		$1
}

rule file_347_59_0 {
	meta:
		name = "?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QAEXXZ"
		size = 47
		refs = "0017 ?_WaitEquals@_ReaderWriterLock@details@Concurrency@@CAXADJJJ@Z"
	strings:
		$1 = { 8B FF 56 8B F1 33 C9 8D 46 04 41 F0 0F C1 08 EB 0D 6A FF 6A 00 56 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B D6 83 C9 FF F0 0F B1 0A 85 C0 75 E4 5E C3 }
	condition:
		$1
}

rule file_347_60_0 {
	meta:
		name = "?UpdateQueuePosition@LockQueueNode@details@Concurrency@@QAEXPAV123@@Z"
		size = 83
	strings:
		$1 = { 8B FF 55 8B EC 57 8B F9 8B 47 08 D1 E8 B1 01 84 C1 75 3B 8B 45 08 8B 50 08 D1 EA 84 D1 74 2F 56 8B 70 08 8B 50 08 83 C6 08 83 E6 FA 84 D1 74 1A 8B 50 08 C1 EA 02 84 D1 75 0D 8B 00 8B 10 8B C8 FF 52 10 84 C0 74 03 83 CE 04 09 77 08 5E 5F 5D C2 04 00 }
	condition:
		$1
}

rule file_347_61_0 {
	meta:
		name = "?UpdateBlockingState@LockQueueNode@details@Concurrency@@QAEXPAV123@@Z"
		size = 52
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 56 8B F1 8B 48 08 F6 C1 01 74 1C 8B 48 08 C1 E9 02 F6 C1 01 75 0D 8B 00 8B 10 8B C8 FF 52 10 84 C0 74 04 83 4E 08 04 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_347_62_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ"
		size = 109
		refs = "0012 ?_S_spinCount@_SpinCount@details@Concurrency@@2IA 0019 ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 56 8B F1 8B 46 08 83 E8 00 75 12 21 46 08 FF 35 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? EB E6 48 74 34 48 74 1F 48 74 07 48 75 15 32 C0 EB 23 83 66 08 00 FF 35 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 32 C0 5E C3 FF 4E 04 75 07 C7 46 08 03 00 00 00 B0 01 F3 90 5E C3 F3 90 FF 0E 75 0D 8B 46 04 F7 D8 1B C0 83 C0 03 89 46 08 B0 01 5E C3 }
	condition:
		$1
}

rule file_347_64_0 {
	meta:
		name = "?Block@LockQueueNode@details@Concurrency@@QAEXI@Z"
		size = 134
		refs = "000c ?GetProcessorCount@Concurrency@@YAIXZ 0043 ?_S_spinCount@_SpinCount@details@Concurrency@@2IA 005b ?_UnderlyingYield@details@Concurrency@@YAXXZ 0063 ?_SetSpinCount@?$_SpinWait@$0A@@details@Concurrency@@QAEXI@Z 0073 ?_SpinOnce@?$_SpinWait@$0A@@details@Concurrency@@QAE_NXZ 007d ?Block@Context@Concurrency@@SAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 8B F1 E8 ?? ?? ?? ?? 8B 4E 08 C1 E9 02 F6 C1 01 75 61 8B 4E 08 D1 E9 F6 C1 01 74 10 8B 4E 08 8B 55 08 C1 E9 03 C1 EA 03 2B CA EB 03 33 C9 41 53 8D 58 02 3B CB 77 3B 57 8B 3D ?? ?? ?? ?? 8D 41 FF 0F AF C7 33 D2 F7 F3 83 65 F8 00 8D 4D F0 C7 45 FC ?? ?? ?? ?? 03 C7 50 E8 ?? ?? ?? ?? 5F 8B 46 08 A8 01 74 0C 8D 4D F0 E8 ?? ?? ?? ?? 84 C0 75 ED 5B E8 ?? ?? ?? ?? 5E C9 C2 04 00 }
	condition:
		$1
}

rule file_347_65_0 {
	meta:
		name = "?_Acquire_lock@critical_section@Concurrency@@QAEXPAX_N@Z"
		size = 136
		refs = "0016 ??_C@_0BD@BAGHDICJ@Lock?5already?5taken?$AA@ 001e ??0improper_lock@Concurrency@@QAE@PBD@Z 0023 __TI2?AVimproper_lock@Concurrency@@ 002c __CxxThrowException@8 0043 ?UpdateQueuePosition@LockQueueNode@details@Concurrency@@QAEXPAV123@@Z 005c ?Block@LockQueueNode@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 08 8B 06 57 8B F9 3B 07 75 1B 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 53 8B DE 8D 47 10 87 18 8B CE 85 DB 75 0F 89 77 0C 57 E8 ?? ?? ?? ?? 83 66 08 FE EB 1B 53 E8 ?? ?? ?? ?? 89 73 04 FF 77 08 8B CE E8 ?? ?? ?? ?? 57 8B CE E8 ?? ?? ?? ?? 80 7D 0C 00 5B 74 13 8B 46 08 89 47 08 8B 46 04 89 47 04 8B 06 89 07 89 77 0C 5F 5E C9 C2 08 00 }
	condition:
		$1
}

rule file_347_69_0 {
	meta:
		name = "??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z"
		size = 67
		refs = "0003 __ehhandler$??0scoped_lock@critical_section@Concurrency@@QAE@AAV12@@Z 0008 __EH_prolog3 0027 ??0LockQueueNode@details@Concurrency@@QAE@XZ 0035 ?_Acquire_lock@critical_section@Concurrency@@QAEXPAX_N@Z 003c __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 45 08 8D 7E 04 89 06 89 7D 08 89 7D F0 83 65 FC 00 85 FF 74 07 8B CF E8 ?? ?? ?? ?? 8B 0E 83 4D FC FF 6A 01 57 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_347_74_0 {
	meta:
		name = "??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z"
		size = 67
		refs = "0003 __ehhandler$??0scoped_lock@reader_writer_lock@Concurrency@@QAE@AAV12@@Z 0008 __EH_prolog3 0027 ??0LockQueueNode@details@Concurrency@@QAE@XZ 0035 ?_Acquire_lock@reader_writer_lock@Concurrency@@QAEXPAX_N@Z 003c __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 45 08 8D 7E 04 89 06 89 7D 08 89 7D F0 83 65 FC 00 85 FF 74 07 8B CF E8 ?? ?? ?? ?? 8B 0E 83 4D FC FF 6A 01 57 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_347_72_0 {
	meta:
		name = "?lock_read@reader_writer_lock@Concurrency@@QAEXXZ"
		size = 177
		refs = "0018 ?CurrentContext@SchedulerBase@details@Concurrency@@SAPAVContextBase@23@XZ 0024 ??_C@_0BP@FOPPMPGO@Lock?5already?5taken?5as?5a?5writer?$AA@ 002c ??0improper_lock@Concurrency@@QAE@PBD@Z 0031 __TI2?AVimproper_lock@Concurrency@@ 003a __CxxThrowException@8 0065 ?_Get_reader_convoy@reader_writer_lock@Concurrency@@AAEPAXXZ 0084 ?UpdateBlockingState@LockQueueNode@details@Concurrency@@QAEXPAV123@@Z 008e ?Block@LockQueueNode@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 83 65 F8 00 56 57 8B F9 C7 45 FC 01 00 00 00 E8 ?? ?? ?? ?? 89 45 F4 3B 07 75 1B 68 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E8 50 E8 ?? ?? ?? ?? 8D 75 F4 8D 47 0C 87 30 85 F6 75 35 53 6A 04 59 8D 57 18 8B 02 8B D8 0B D9 F0 0F B1 1A 75 F6 5B A8 03 75 26 8B CF E8 ?? ?? ?? ?? 83 60 08 FE 8D 4D F4 3B C1 74 39 8B 00 8B 10 8B C8 FF 52 0C EB 09 56 8D 4D F4 E8 ?? ?? ?? ?? 6A 00 8D 4D F4 E8 ?? ?? ?? ?? 85 F6 74 17 6A 08 58 83 C7 18 F0 0F C1 07 83 66 08 FE 8B 36 8B 06 8B CE FF 50 0C 5F 5E C9 C3 }
	condition:
		$1
}

rule file_347_73_0 {
	meta:
		name = "?_Acquire_lock@reader_writer_lock@Concurrency@@QAEXPAX_N@Z"
		size = 145
		refs = "0016 ??_C@_0BD@BAGHDICJ@Lock?5already?5taken?$AA@ 001e ??0improper_lock@Concurrency@@QAE@PBD@Z 0023 __TI2?AVimproper_lock@Concurrency@@ 002c __CxxThrowException@8 0040 ?UpdateQueuePosition@LockQueueNode@details@Concurrency@@QAEXPAV123@@Z 0048 ?_Set_next_writer@reader_writer_lock@Concurrency@@AAE_NPAX@Z 0065 ?Block@LockQueueNode@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 75 08 8B 06 57 8B F9 3B 07 75 1B 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 53 8B DE 8D 47 14 87 18 8B CE 85 DB 75 18 57 E8 ?? ?? ?? ?? 56 8B CF E8 ?? ?? ?? ?? 84 C0 74 0F 83 66 08 FE EB 1B 53 E8 ?? ?? ?? ?? 89 73 04 FF 77 08 8B CE E8 ?? ?? ?? ?? 57 8B CE E8 ?? ?? ?? ?? 80 7D 0C 00 5B 74 13 8B 46 08 89 47 08 8B 46 04 89 47 04 8B 06 89 07 89 77 10 5F 5E C9 C2 08 00 }
	condition:
		$1
}

rule file_347_78_0 {
	meta:
		name = "?_SpinOnce@?$_SpinWait@$00@details@Concurrency@@QAE_NXZ"
		size = 112
		refs = "0014 ?_S_spinCount@_SpinCount@details@Concurrency@@2IA 001b ?_SetSpinCount@?$_SpinWait@$00@details@Concurrency@@QAEXI@Z"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 DB 8B 46 08 2B C3 75 12 89 5E 08 FF 35 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? EB E7 48 74 34 48 74 1C 48 74 05 48 74 24 EB 10 89 5E 08 FF 35 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 32 C0 EB 2A FF 4E 04 75 07 C7 46 08 03 00 00 00 B3 01 FF 56 0C 8A C3 EB 15 F3 90 FF 0E 75 0D 8B 46 04 F7 D8 1B C0 83 C0 03 89 46 08 B0 01 5E 5B C3 }
	condition:
	