private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_strcspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 73 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__fpieee_flt"
		size = 3308
		refs = "001f ___security_cookie 008f _fpieee_flt_simd 0117 ??_C@_1HO@FABLIPOK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 011e __CrtDbgReportW 0178 _instr_info_table 05ef _FLDTable 0705 $LN82 071c __FillOperand 077c __PreventStackOverwrite 07a5 __UpdateFpCtxt 07be __IsMemoryLocation 07f5 __GetFpRegVal 0834 __ieee_adj_single 084e __ieee_adj_double 0927 __AdjustLocation 0a7d $LN83 0cb8 @__security_check_cookie@4 0cc4 $LN26 0cc8 $LN23 0cd0 $LN24 0cd4 $LN27 0cdc $LN9 0ce0 $LN8 0ce4 $LN7 0ce8 $LN6"
	strings:
		$1 = { 8B FF 53 8B DC 83 EC 08 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC 40 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 81 7B 08 8E 00 00 C0 74 3D 81 7B 08 8F 00 00 C0 74 34 81 7B 08 90 00 00 C0 74 2B 81 7B 08 91 00 00 C0 74 22 81 7B 08 93 00 00 C0 74 19 81 7B 08 B4 02 00 C0 74 10 81 7B 08 B5 02 00 C0 74 07 33 C0 E9 44 0C 00 00 DB E3 81 7B 08 B4 02 00 C0 74 09 81 7B 08 B5 02 00 C0 75 19 8B 43 10 50 8B 4B 0C 51 8B 53 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 17 0C 00 00 8B 43 0C 8B 08 89 4D F8 8B 55 F8 83 C2 14 89 55 F4 8B 43 0C 8B 48 04 89 4D F0 8B 55 F0 83 C2 1C 89 55 EC 8B 45 F4 83 38 00 74 2F 8B 4D F4 8B 11 52 FF 53 10 83 C4 04 89 45 E8 83 7D E8 FF 75 12 8B 45 EC 8B 48 04 81 E1 00 FF FF FF 8B 55 EC 89 4A 04 8B 45 E8 E9 BD 0B 00 00 8B 45 EC 8B 48 0C 0F B6 11 83 E2 F8 81 FA D8 00 00 00 74 29 33 C0 75 1E 6A 00 6A 00 68 F2 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 E9 80 0B 00 00 8B 55 EC 8B 42 0C 66 8B 08 66 89 4D E4 8B 55 E4 C1 EA 0E 83 E2 03 33 C0 83 FA 03 0F 94 C0 89 45 E0 8B 4D E4 83 E1 07 C1 E1 04 8B 55 E0 C1 E2 03 0B CA 8B 45 E4 C1 E8 0B 83 E0 07 0B C8 89 4D DC 8B 4D DC 8D 14 8D ?? ?? ?? ?? 89 55 D8 8B 45 D8 8B 08 81 E1 FF 0F 00 00 81 E1 FF 0F 00 00 C1 E1 05 8B 95 60 FF FF FF 81 E2 1F 00 FE FF 0B D1 89 95 60 FF FF FF 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 89 8D 5C FF FF FF 8B 55 EC 8B 02 89 85 58 FF FF FF 8B 4D EC 8B 51 04 89 95 54 FF FF FF 8B 85 58 FF FF FF 25 00 0C 00 00 89 85 50 FF FF FF 81 BD 50 FF FF FF 00 08 00 00 77 23 81 BD 50 FF FF FF 00 08 00 00 74 4A 83 BD 50 FF FF FF 00 74 1C 81 BD 50 FF FF FF 00 04 00 00 74 21 EB 56 81 BD 50 FF FF FF 00 0C 00 00 74 3B EB 48 8B 8D 60 FF FF FF 83 E1 FC 89 8D 60 FF FF FF EB 37 8B 95 60 FF FF FF 83 E2 FC 83 CA 01 89 95 60 FF FF FF EB 23 8B 85 60 FF FF FF 83 E0 FC 83 C8 02 89 85 60 FF FF FF EB 0F 8B 8D 60 FF FF FF 83 C9 03 89 8D 60 FF FF FF 8B 95 58 FF FF FF 81 E2 00 03 00 00 89 95 4C FF FF FF 74 3F 81 BD 4C FF FF FF 00 02 00 00 74 1F 81 BD 4C FF FF FF 00 03 00 00 74 02 EB 37 8B 85 60 FF FF FF 83 E0 E3 89 85 60 FF FF FF EB 26 8B 8D 60 FF FF FF 83 E1 E3 83 C9 04 89 8D 60 FF FF FF EB 12 8B 95 60 FF FF FF 83 E2 E3 83 CA 08 89 95 60 FF FF FF 8B 85 58 FF FF FF 83 E0 20 F7 D8 1B C0 83 C0 01 83 E0 01 8B 8D 68 FF FF FF 83 E1 FE 0B C8 89 8D 68 FF FF FF 8B 95 58 FF FF FF 83 E2 10 F7 DA 1B D2 83 C2 01 83 E2 01 D1 E2 8B 85 68 FF FF FF 83 E0 FD 0B C2 89 85 68 FF FF FF 8B 8D 58 FF FF FF 83 E1 08 F7 D9 1B C9 83 C1 01 83 E1 01 C1 E1 02 8B 95 68 FF FF FF 83 E2 FB 0B D1 89 95 68 FF FF FF 8B 85 58 FF FF FF 83 E0 04 F7 D8 1B C0 83 C0 01 83 E0 01 C1 E0 03 8B 8D 68 FF FF FF 83 E1 F7 0B C8 89 8D 68 FF FF FF 8B 95 58 FF FF FF 83 E2 01 F7 DA 1B D2 83 C2 01 83 E2 01 C1 E2 04 8B 85 68 FF FF FF 83 E0 EF 0B C2 89 85 68 FF FF FF 8B 8D 54 FF FF FF 83 E1 20 F7 D9 1B C9 F7 D9 83 E1 01 8B 95 6C FF FF FF 83 E2 FE 0B D1 89 95 6C FF FF FF 8B 85 54 FF FF FF 83 E0 10 F7 D8 1B C0 F7 D8 83 E0 01 D1 E0 8B 8D 6C FF FF FF 83 E1 FD 0B C8 89 8D 6C FF FF FF 8B 95 54 FF FF FF 83 E2 08 F7 DA 1B D2 F7 DA 83 E2 01 C1 E2 02 8B 85 6C FF FF FF 83 E0 FB 0B C2 89 85 6C FF FF FF 8B 8D 54 FF FF FF 83 E1 04 F7 D9 1B C9 F7 D9 83 E1 01 C1 E1 03 8B 95 6C FF FF FF 83 E2 F7 0B D1 89 95 6C FF FF FF 8B 85 54 FF FF FF 83 E0 01 F7 D8 1B C0 F7 D8 83 E0 01 C1 E0 04 8B 8D 6C FF FF FF 83 E1 EF 0B C8 89 8D 6C FF FF FF 8B 95 68 FF FF FF 83 E2 01 74 17 8B 85 6C FF FF FF 83 E0 01 74 0C C7 85 48 FF FF FF 01 00 00 00 EB 0A C7 85 48 FF FF FF 00 00 00 00 8B 8D 48 FF FF FF 83 E1 01 8B 95 64 FF FF FF 83 E2 FE 0B D1 89 95 64 FF FF FF 8B 85 68 FF FF FF D1 E8 83 E0 01 74 19 8B 8D 6C FF FF FF D1 E9 83 E1 01 74 0C C7 85 44 FF FF FF 01 00 00 00 EB 0A C7 85 44 FF FF FF 00 00 00 00 8B 95 44 FF FF FF 83 E2 01 D1 E2 8B 85 64 FF FF FF 83 E0 FD 0B C2 89 85 64 FF FF FF 8B 8D 68 FF FF FF C1 E9 02 83 E1 01 74 1A 8B 95 6C FF FF FF C1 EA 02 83 E2 01 74 0C C7 85 40 FF FF FF 01 00 00 00 EB 0A C7 85 40 FF FF FF 00 00 00 00 8B 85 40 FF FF FF 83 E0 01 C1 E0 02 8B 8D 64 FF FF FF 83 E1 FB 0B C8 89 8D 64 FF FF FF 8B 95 68 FF FF FF C1 EA 03 83 E2 01 74 1A 8B 85 6C FF FF FF C1 E8 03 83 E0 01 74 0C C7 85 3C FF FF FF 01 00 00 00 EB 0A C7 85 3C FF FF FF 00 00 00 00 8B 8D 3C FF FF FF 83 E1 01 C1 E1 03 8B 95 64 FF FF FF 83 E2 F7 0B D1 89 95 64 FF FF FF 8B 85 68 FF FF FF C1 E8 04 83 E0 01 74 1A 8B 8D 6C FF FF FF C1 E9 04 83 E1 01 74 0C C7 85 38 FF FF FF 01 00 00 00 EB 0A C7 85 38 FF FF FF 00 00 00 00 8B 95 38 FF FF FF 83 E2 01 C1 E2 04 8B 85 64 FF FF FF 83 E0 EF 0B C2 89 85 64 FF FF FF C7 85 34 FF FF FF 00 00 00 00 EB 0F 8B 8D 34 FF FF FF 83 C1 01 89 8D 34 FF FF FF 83 BD 34 FF FF FF 04 7D 35 8B 95 34 FF FF FF 8B 04 95 ?? ?? ?? ?? 3B 45 DC 75 21 8B 8D 64 FF FF FF C1 E9 04 83 E1 01 75 13 83 BD 5C FF FF FF 00 7D 0A C7 85 5C FF FF FF 00 00 00 00 EB B3 8B 55 D8 8B 02 C1 E8 0C 83 E0 1F 83 F8 08 75 11 8B 4D E4 C1 E9 08 83 E1 07 89 8D 30 FF FF FF EB 11 8B 55 D8 8B 02 C1 E8 0C 83 E0 1F 89 85 30 FF FF FF 8B 8D 30 FF FF FF 89 8D 2C FF FF FF 8B 55 D8 8B 02 C1 E8 11 83 E0 1F 83 F8 08 75 11 8B 4D E4 C1 E9 08 83 E1 07 89 8D 28 FF FF FF EB 11 8B 55 D8 8B 02 C1 E8 11 83 E0 1F 89 85 28 FF FF FF 8B 8D 28 FF FF FF 89 8D 24 FF FF FF 8B 55 D8 8B 02 C1 E8 16 83 E0 1F 83 F8 08 75 11 8B 4D E4 C1 E9 08 83 E1 07 89 8D 20 FF FF FF EB 11 8B 55 D8 8B 02 C1 E8 16 83 E0 1F 89 85 20 FF FF FF 8B 8D 20 FF FF FF 89 8D 1C FF FF FF 8B 53 08 89 95 18 FF FF FF 8B 85 18 FF FF FF 05 72 FF FF 3F 89 85 18 FF FF FF 83 BD 18 FF FF FF 05 0F 87 3A 03 00 00 8B 8D 18 FF FF FF FF 24 8D ?? ?? ?? ?? 8B 95 2C FF FF FF 52 8B 45 EC 50 8D 8D 70 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 24 FF FF FF 52 8B 45 EC 50 8D 4D 90 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 1C FF FF FF 52 8B 45 EC 50 8D 4D B0 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 C0 83 E2 FE 89 55 C0 8D 85 60 FF FF FF 50 FF 53 10 83 C4 04 89 45 E8 83 7D E8 FF 75 3C 8B 8D 1C FF FF FF 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 1C FF FF FF 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 51 8B 95 1C FF FF FF 52 8D 45 B0 50 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 10 E9 85 02 00 00 8B 55 D8 8B 02 C1 E8 16 83 E0 1F 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 46 01 00 00 8B 8D 2C FF FF FF 51 8B 55 EC 52 8D 85 70 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 8B 4D EC 51 8D 95 08 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 08 89 8D FC FE FF FF 8B 50 04 89 95 00 FF FF FF 66 8B 40 08 66 89 85 04 FF FF FF 8B 4D C0 83 C9 01 89 4D C0 83 BD 1C FF FF FF 0D 75 16 8B 55 C0 83 E2 E1 89 55 C0 A1 ?? ?? ?? ?? 89 85 F8 FE FF FF EB 18 8B 4D C0 83 E1 E1 83 C9 02 89 4D C0 8B 15 ?? ?? ?? ?? 89 95 F8 FE FF FF 81 7B 08 91 00 00 C0 75 0E 8B 85 F8 FE FF FF F7 D8 89 85 F8 FE FF FF DB 85 F8 FE FF FF DB AD FC FE FF FF D9 FD DD D9 DB BD FC FE FF FF 83 BD 1C FF FF FF 0D 75 17 DB AD FC FE FF FF D9 9D F4 FE FF FF D9 85 F4 FE FF FF D9 5D B0 EB 15 DB AD FC FE FF FF DD 9D E8 FE FF FF DD 85 E8 FE FF FF DD 5D B0 DB E2 8D 8D 60 FF FF FF 51 FF 53 10 83 C4 04 89 45 E8 83 7D E8 FF 75 3C 8B 95 1C FF FF FF 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 1C FF FF FF 8B 4D D8 8B 11 C1 E2 02 C1 FA 1D 52 8B 85 1C FF FF FF 50 8D 4D B0 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 10 E9 23 01 00 00 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 51 8B 95 2C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 E4 FE FF FF 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 51 8B 95 24 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 E0 FE FF FF 8B 45 D8 8B 08 C1 E1 02 C1 F9 1D 51 8B 95 1C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 89 85 DC FE FF FF 8B 85 E4 FE FF FF 3B 85 DC FE FF FF 75 0A C7 85 E4 FE FF FF 1F 00 00 00 8B 8D E0 FE FF FF 3B 8D DC FE FF FF 75 0A C7 85 E0 FE FF FF 1F 00 00 00 8B 95 DC FE FF FF 52 8B 45 EC 50 8D 4D B0 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 E4 FE FF FF 52 8B 45 EC 50 8D 8D 70 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 95 E0 FE FF FF 52 8B 45 EC 50 8D 4D 90 51 E8 ?? ?? ?? ?? 83 C4 0C 8D 95 60 FF FF FF 52 FF 53 10 83 C4 04 89 45 E8 83 7D E8 FF 75 32 8B 85 DC FE FF FF 50 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 DC FE FF FF 6A 00 8B 95 DC FE FF FF 52 8D 45 B0 50 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 10 83 7D E8 FF 0F 85 6F 02 00 00 8B 55 EC 8B 42 04 25 00 FF FF FF 8B 4D EC 89 41 04 8B 55 EC 8B 02 89 85 58 FF FF FF 8B 8D 60 FF FF FF 83 E1 03 89 8D D8 FE FF FF 83 BD D8 FE FF FF 03 77 6A 8B 95 D8 FE FF FF FF 24 95 ?? ?? ?? ?? 8B 85 58 FF FF FF 25 FF F3 FF FF 89 85 58 FF FF FF EB 4A 8B 8D 58 FF FF FF 81 E1 FF F3 FF FF 81 C9 00 04 00 00 89 8D 58 FF FF FF EB 30 8B 95 58 FF FF FF 81 E2 FF F3 FF FF 81 CA 00 08 00 00 89 95 58 FF FF FF EB 16 8B 85 58 FF FF FF 25 FF F3 FF FF 0D 00 0C 00 00 89 85 58 FF FF FF 8B 8D 60 FF FF FF C1 E9 02 83 E1 07 89 8D D4 FE FF FF 74 14 83 BD D4 FE FF FF 01 74 25 83 BD D4 FE FF FF 02 74 34 EB 44 8B 95 58 FF FF FF 81 E2 FF FC FF FF 81 CA 00 03 00 00 89 95 58 FF FF FF EB 2A 8B 85 58 FF FF FF 25 FF FC FF FF 0D 00 02 00 00 89 85 58 FF FF FF EB 12 8B 8D 58 FF FF FF 81 E1 FF FC FF FF 89 8D 58 FF FF FF 8B 95 68 FF FF FF 83 E2 01 74 1D 8B 85 58 FF FF FF 83 E0 DF 89 85 58 FF FF FF 8B 8D 58 FF FF FF 89 8D D0 FE FF FF EB 1B 8B 95 58 FF FF FF 83 CA 20 89 95 58 FF FF FF 8B 85 58 FF FF FF 89 85 D0 FE FF FF 8B 8D 68 FF FF FF D1 E9 83 E1 01 74 1D 8B 95 58 FF FF FF 83 E2 EF 89 95 58 FF FF FF 8B 85 58 FF FF FF 89 85 CC FE FF FF EB 1B 8B 8D 58 FF FF FF 83 C9 10 89 8D 58 FF FF FF 8B 95 58 FF FF FF 89 95 CC FE FF FF 8B 85 68 FF FF FF C1 E8 02 83 E0 01 74 1D 8B 8D 58 FF FF FF 83 E1 F7 89 8D 58 FF FF FF 8B 95 58 FF FF FF 89 95 C8 FE FF FF EB 1B 8B 85 58 FF FF FF 83 C8 08 89 85 58 FF FF FF 8B 8D 58 FF FF FF 89 8D C8 FE FF FF 8B 95 68 FF FF FF C1 EA 03 83 E2 01 74 1D 8B 85 58 FF FF FF 83 E0 FB 89 85 58 FF FF FF 8B 8D 58 FF FF FF 89 8D C4 FE FF FF EB 1B 8B 95 58 FF FF FF 83 CA 04 89 95 58 FF FF FF 8B 85 58 FF FF FF 89 85 C4 FE FF FF 8B 8D 68 FF FF FF C1 E9 04 83 E1 01 74 1D 8B 95 58 FF FF FF 83 E2 FE 89 95 58 FF FF FF 8B 85 58 FF FF FF 89 85 C0 FE FF FF EB 1B 8B 8D 58 FF FF FF 83 C9 01 89 8D 58 FF FF FF 8B 95 58 FF FF FF 89 95 C0 FE FF FF 8B 45 EC 8B 8D 58 FF FF FF 89 08 8B 45 E8 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "__FillOperand"
		size = 768
		refs = "002d $LN24 0034 $LN25 0057 __GetFpRegVal 0248 __zero80 0282 ??_C@_1HO@FABLIPOK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0289 __CrtDbgReportW 02ac $LN18 02b0 $LN1 02b4 $LN10 02b8 $LN16 02bc $LN15 02c0 $LN14 02c4 $LN12 02c8 $LN13 02cc $LN17 02d0 $LN11 02d4 $LN3 02d8 $LN2 02dc $LN19"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 8B 45 08 8B 48 10 83 C9 01 8B 55 08 89 4A 10 8B 45 10 89 45 DC 83 7D DC 1F 0F 87 7E 02 00 00 8B 4D DC 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 08 8B 48 10 83 E1 E1 83 C9 04 8B 55 08 89 4A 10 8B 45 10 50 8B 4D 0C 51 8D 55 E0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 66 8B 40 08 66 89 41 08 E9 2D 02 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 04 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 E9 FB 01 00 00 8B 45 08 8B 48 10 83 E1 E1 83 C9 08 8B 55 08 89 4A 10 8B 45 0C 8B 48 14 8B 55 08 66 8B 01 66 89 02 E9 D5 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 0A 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 E9 B1 01 00 00 8B 55 08 8B 42 10 83 E0 E1 83 C8 0C 8B 4D 08 89 41 10 8B 55 0C 8B 42 14 8B 08 8B 50 04 8B 45 08 89 08 89 50 04 E9 87 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 02 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 DD 02 DD 18 E9 63 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 D9 02 D9 18 E9 42 01 00 00 8B 4D 08 8B 51 10 83 E2 E1 83 CA 14 8B 45 08 89 50 10 8B 4D 0C 8B 51 14 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 E9 10 01 00 00 8B 45 08 8B 48 10 83 E1 E1 83 C9 16 8B 55 08 89 4A 10 8B 45 0C 8B 48 04 81 E1 00 01 00 00 F7 D9 1B C9 F7 D9 89 4D FC 8B 55 0C 8B 42 04 25 00 04 00 00 F7 D8 1B C0 83 E0 04 89 45 F4 8B 4D 0C 8B 51 04 81 E2 00 01 00 00 F7 DA 1B D2 83 E2 08 89 55 F8 8B 45 FC 0B 45 F4 0B 45 F8 89 45 D8 74 11 83 7D D8 01 74 16 81 7D D8 00 01 00 00 74 18 EB 21 8B 4D 08 C7 01 01 00 00 00 EB 1F 8B 55 08 C7 02 02 00 00 00 EB 14 8B 45 08 C7 00 00 00 00 00 EB 09 8B 4D 08 C7 01 03 00 00 00 EB 73 8B 55 08 8B 42 10 83 E0 E1 83 C8 04 8B 4D 08 89 41 10 8B 55 08 A1 ?? ?? ?? ?? 89 02 8B 0D ?? ?? ?? ?? 89 4A 04 66 A1 ?? ?? ?? ?? 66 89 42 08 EB 42 8B 4D 08 8B 51 10 83 E2 FE 8B 45 08 89 50 10 EB 31 33 C9 75 1E 6A 00 6A 00 68 C6 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 8B 48 10 83 E1 FE 8B 55 08 89 4A 10 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 02 03 04 05 06 07 08 09 0A 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0B }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "__UpdateFpCtxt"
		size = 71
		refs = "0014 __AdjustStack 0028 __UpdateResult"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 14 00 7D 10 8B 45 14 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 7E 10 8B 55 14 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "__UpdateResult"
		size = 476
		refs = "001e $LN23 0025 $LN24 0036 __SetFpRegVal 00f8 $LN25 0178 ??_C@_1HO@FABLIPOK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 017f __CrtDbgReportW 0190 $LN17 0194 $LN1 0198 $LN9 019c $LN15 01a0 $LN14 01a4 $LN13 01a8 $LN11 01ac $LN12 01b0 $LN16 01b4 $LN10 01cc $LN6 01d0 $LN5 01d4 $LN4 01d8 $LN3"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 10 89 45 FC 83 7D FC 11 0F 87 74 01 00 00 8B 4D FC 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 50 8B 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C E9 4A 01 00 00 8B 45 0C 8B 4D 08 8B 51 14 8B 08 89 0A 8B 48 04 89 4A 04 66 8B 40 08 66 89 42 08 E9 2A 01 00 00 8B 4D 08 8B 51 14 8B 45 0C 66 8B 08 66 89 0A E9 16 01 00 00 8B 55 08 8B 42 14 8B 4D 0C 8B 11 89 10 E9 04 01 00 00 8B 45 0C 8B 08 8B 50 04 8B 45 08 8B 40 14 89 08 89 50 04 E9 EC 00 00 00 8B 4D 08 8B 51 14 8B 45 0C DD 00 DD 1A E9 DA 00 00 00 8B 4D 08 8B 51 14 8B 45 0C D9 00 D9 1A E9 C8 00 00 00 8B 4D 0C 8B 55 08 8B 42 14 8B 11 89 10 8B 51 04 89 50 04 66 8B 49 08 66 89 48 08 E9 A8 00 00 00 8B 55 0C 8B 02 89 45 F8 83 7D F8 03 77 76 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 08 8B 42 04 0D 00 40 00 00 8B 4D 08 89 41 04 8B 55 08 8B 42 04 25 FF FA FF FF 8B 4D 08 89 41 04 EB 48 8B 55 08 8B 42 04 25 FF BA FF FF 8B 4D 08 89 41 04 EB 35 8B 55 08 8B 42 04 0D 00 01 00 00 8B 4D 08 89 41 04 8B 55 08 8B 42 04 25 FF BB FF FF 8B 4D 08 89 41 04 EB 11 8B 55 08 8B 42 04 0D 00 45 00 00 8B 4D 08 89 41 04 EB 22 33 D2 75 1E 6A 00 6A 00 68 6C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 02 03 04 05 06 07 08 09 01 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "__AdjustStack"
		size = 348
		refs = "0009 ___security_cookie 0055 __SetTag 0096 _memcpy 00bf _memmove 0154 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 5C A1 ?? ?? ?? ?? 33 C5 89 45 F8 8B 45 08 83 C0 04 89 45 A4 83 7D 0C 00 0F 8E C9 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 3B 55 0C 7D 44 6A 03 8B 45 A4 8B 08 C1 E9 0B 83 E1 07 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 A4 8B 08 C1 E9 0B 83 E1 07 83 C1 01 83 E1 07 C1 E1 0B 8B 55 A4 8B 02 25 FF C7 FF FF 0B C1 8B 4D A4 89 01 EB AB 8B 55 0C 6B D2 0A 52 8B 45 08 83 C0 1C 50 8D 4D A8 51 E8 ?? ?? ?? ?? 83 C4 0C BA 08 00 00 00 2B 55 0C 6B D2 0A 52 8B 45 0C 6B C0 0A 8B 4D 08 8D 54 01 1C 52 8B 45 08 83 C0 1C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 0C 6B C9 0A 51 8D 55 A8 52 B8 08 00 00 00 2B 45 0C 6B C0 0A 8B 4D 08 8D 54 01 1C 52 E8 ?? ?? ?? ?? 83 C4 0C EB 60 83 7D 0C 00 7D 5A 8B 45 A4 8B 08 C1 E9 0B 83 E1 07 83 E9 01 83 E1 07 C1 E1 0B 8B 55 A4 8B 02 25 FF C7 FF FF 0B C1 8B 4D A4 89 01 6A 00 8B 55 A4 8B 02 C1 E8 0B 83 E0 07 50 8B 4D 08 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 46 8B 55 08 83 C2 1C 52 8B 45 08 83 C0 26 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_5_0 {
	meta:
		name = "__AdjustLocation"
		size = 67
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 89 45 F8 83 7D F8 00 7C 22 83 7D F8 07 7E 02 EB 1A 8B 4D 08 2B 4D 0C 89 4D FC 78 06 83 7D FC 07 7E 07 C7 45 FC 1F 00 00 00 EB 06 8B 55 08 89 55 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_6_0 {
	meta:
		name = "__PreventStackOverwrite"
		size = 72
		refs = "000b __IsMemoryLocation"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 2B 8B 4D 08 8B 55 08 8B 81 C4 00 00 00 3B 42 30 76 1A 54 58 89 45 FC 8B 4D 08 8B 51 30 83 C2 04 39 55 FC 77 07 C7 45 0C 1F 00 00 00 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_7_0 {
	meta:
		name = "__IsMemoryLocation"
		size = 39
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 89 45 FC 83 7D FC 0A 7C 0F 83 7D FC 10 7E 02 EB 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_8_0 {
	meta:
		name = "__GetFpRegVal"
		size = 94
		refs = "003f __zero80"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 10 00 7C 2F 83 7D 10 08 7D 29 8B 45 10 6B C0 0A 8B 4D 0C 8D 54 01 1C 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 66 8B 52 08 66 89 50 08 8B 45 08 EB 24 EB 22 8B 45 08 8B 0D ?? ?? ?? ?? 89 08 8B 15 ?? ?? ?? ?? 89 50 04 66 8B 0D ?? ?? ?? ?? 66 89 48 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_1_9_0 {
	meta:
		name = "__SetFpRegVal"
		size = 203
		refs = "00c0 __SetTag"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 83 C0 04 89 45 F4 83 7D 0C 00 0F 8C AC 00 00 00 83 7D 0C 08 0F 8D A2 00 00 00 8B 4D 10 8B 55 0C 6B D2 0A 8B 45 08 8D 54 10 1C 8B 01 89 02 8B 41 04 89 42 04 66 8B 49 08 66 89 4A 08 8B 55 F4 8B 02 C1 E8 0B 83 E0 07 03 45 0C 33 D2 B9 08 00 00 00 F7 F1 89 55 F8 8B 55 10 0F B7 42 08 25 FF 7F 00 00 89 45 F0 74 0B 81 7D F0 FF 7F 00 00 74 25 EB 2C 8B 4D 10 83 39 00 75 12 8B 55 10 83 7A 04 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 02 00 00 00 EB 10 C7 45 FC 02 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D F8 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_10_0 {
	meta:
		name = "__SetTag"
		size = 67
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C D1 E0 89 45 F8 BA 03 00 00 00 8B 4D F8 D3 E2 89 55 FC 8B 45 10 8B 4D F8 D3 E0 89 45 10 8B 4D FC F7 D1 8B 55 08 23 0A 8B 45 10 23 45 FC 0B C8 8B 55 08 89 0A 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "___mtold12"
		size = 338
		refs = "0009 ___security_cookie 006b ___shl_12 0087 ___add_12 014a @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 F8 B8 4E 40 00 00 66 89 45 FC 8B 4D 10 C7 01 00 00 00 00 8B 55 10 C7 42 04 00 00 00 00 8B 45 10 C7 40 08 00 00 00 00 EB 12 8B 4D 0C 83 E9 01 89 4D 0C 8B 55 08 83 C2 01 89 55 08 83 7D 0C 00 76 74 8B 45 10 8B 08 89 4D EC 8B 50 04 89 55 F0 8B 40 08 89 45 F4 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 8D 45 EC 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 0F BE 08 89 4D EC C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 8D 55 EC 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 E9 74 FF FF FF 8B 4D 10 83 79 08 00 75 42 8B 55 10 8B 42 04 C1 E8 10 8B 4D 10 89 41 08 8B 55 10 8B 42 04 C1 E0 10 8B 4D 10 8B 11 C1 EA 10 0B C2 8B 4D 10 89 41 04 8B 55 10 8B 02 C1 E0 10 8B 4D 10 89 01 0F B7 55 FC 83 EA 10 66 89 55 FC EB B5 8B 45 10 8B 48 08 81 E1 00 80 00 00 75 1A 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 66 8B 45 FC 66 83 E8 01 66 89 45 FC EB D8 8B 4D 10 66 8B 55 FC 66 89 51 0A 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "___add_12"
		size = 175
		refs = "0019 ___addl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 08 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 30 8B 55 08 83 C2 04 52 6A 01 8B 45 08 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 83 7D F8 00 74 0F 8B 55 08 8B 42 08 83 C0 01 8B 4D 08 89 41 08 8B 55 08 83 C2 04 52 8B 45 0C 8B 48 04 51 8B 55 08 8B 42 04 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 00 74 0F 8B 4D 08 8B 51 08 83 C2 01 8B 45 08 89 50 08 8B 4D 08 83 C1 08 51 8B 55 0C 8B 42 08 50 8B 4D 08 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "___addl"
		size = 64
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 8B 45 08 03 45 0C 89 45 F8 8B 4D F8 3B 4D 08 72 08 8B 55 F8 3B 55 0C 73 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D 10 8B 55 F8 89 11 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "___shl_12"
		size = 98
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 8B 08 81 E1 00 00 00 80 F7 D9 1B C9 F7 D9 89 4D FC 8B 55 08 8B 42 04 25 00 00 00 80 F7 D8 1B C0 F7 D8 89 45 F8 8B 4D 08 8B 11 D1 E2 8B 45 08 89 10 8B 4D 08 8B 51 04 D1 E2 0B 55 FC 8B 45 08 89 50 04 8B 4D 08 8B 51 08 D1 E2 0B 55 F8 8B 45 08 89 50 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "_clearerr_s"
		size = 337
		refs = "0008 __sehtable$_clearerr_s 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GE@OJGFJACJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1BG@GHDODAOE@?$AAc?$AAl?$AAe?$AAa?$AAr?$AAe?$AAr?$AAr?$AA_?$AAs?$AA?$AA@ 0087 __invalid_parameter 009d __lock_file 00bf __fileno 0102 ___pioinfo 010e ___badioinfo 0135 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 25 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 A7 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 8B 48 0C 83 E1 CF 8B 55 08 89 4A 0C 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F C1 E0 06 03 04 B5 ?? ?? ?? ?? 89 45 E0 EB 07 C7 45 E0 ?? ?? ?? ?? 8B 4D E0 0F BE 51 04 83 E2 FD 8B 45 E0 88 50 04 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 33 C0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_1_0 {
	meta:
		name = "_clearerr"
		size = 19
		refs = "000a _clearerr_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_488_0_4 {
	meta:
		name = "??3@YAXPAXABUnothrow_t@std@@@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_21_18_1 {
	meta:
		name = "??3facet@locale@std@@SAXPAX@Z"
		size = 19
		refs = "000a ??$_DebugHeapDelete@Vfacet@locale@std@@@std@@YAXPAVfacet@locale@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_27_192_1 {
	meta:
		name = "??3facet@locale@std@@SAXPAXABU_DebugHeapTag_t@2@PADH@Z"
		size = 19
		refs = "000a ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_85_0_1 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 19
		refs = "000a ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "??_V@YAXPAX@Z"
		size = 19
		refs = "000a ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_1444_0_4 {
	meta:
		name = "??_V@YAXPAXABUnothrow_t@std@@@Z"
		size = 19
		refs = "000a ??_V@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_35_231_1 {
	meta:
		name = "?length@?$char_traits@D@std@@SAIPBD@Z"
		size = 19
		refs = "000a _strlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_21_1056_1 {
	meta:
		name = "?length@?$char_traits@G@std@@SAIPBG@Z"
		size = 19
		refs = "000a _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_21_1013_1 {
	meta:
		name = "?length@?$char_traits@_W@std@@SAIPB_W@Z"
		size = 19
		refs = "000a _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_73_0_1 {
	meta:
		name = "__LDtest"
		size = 19
		refs = "000a __Dtest"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_353_10_0 {
	meta:
		name = "___free_locale"
		size = 19
		refs = "000a __free_locale"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_254_57_0 {
	meta:
		name = "__aligned_free"
		size = 19
		refs = "000a __aligned_free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_469_2_0 {
	meta:
		name = "__ftime32"
		size = 19
		refs = "000a __ftime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_314_2_0 {
	meta:
		name = "__ftime64"
		size = 19
		refs = "000a __ftime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_337_8_0 {
	meta:
		name = "__inc"
		size = 19
		refs = "000a __fgetwc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_87_1_0 {
	meta:
		name = "__unlink"
		size = 19
		refs = "000a _remove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_646_2_0 {
	meta:
		name = "__wtoi"
		size = 19
		refs = "000a __wtol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_816_1_0 {
	meta:
		name = "__wunlink"
		size = 19
		refs = "000a __wremove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_311_2_0 {
	meta:
		name = "_atoi"
		size = 19
		refs = "000a _atol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "_getwc"
		size = 19
		refs = "000a _fgetwc"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_614_1_0 {
	meta:
		name = "_putchar"
		size = 19
		refs = "000a __fputchar"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "__strnset"
		size = 43
	strings:
		$1 = { 55 8B EC 57 53 8B 7D 08 8B D7 8B 5D 10 33 C0 8B CB E3 12 F2 AE 75 03 83 C1 01 2B D9 8B CB 8B FA 8A 45 0C F3 AA 8B C2 5B 5F C9 C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "___libm_sse2_sinf"
		size = 335
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER 0066 _P_1 0072 _P_2 0078 _Ctable 009e _C_1 00a6 _S_1 00b6 _C_2 00be _S_2 00ca _ONE 010a _ONE_M230 0139 _sin"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D 7F 45 0F 87 E9 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 D8 F3 0F 5A C0 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 E3 66 0F 73 F3 20 66 0F 73 F4 1D 66 0F 57 DC 81 C2 00 76 1C 00 83 E2 3F F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D3 66 0F 57 1D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 04 03 C2 66 0F 73 F1 1D F2 0F 59 D1 F2 0F 59 D9 F2 0F 5C C2 F2 0F 58 D8 F2 0F 59 C0 F2 0F 10 25 ?? ?? ?? ?? F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 E8 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 C0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 F0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 E6 F2 0F 58 EF F2 0F 10 10 F2 0F 59 58 08 F2 0F 59 D4 F2 0F 59 DD F2 0F 58 D3 F2 0F 5A C2 C3 7F 11 F3 0F 5A C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 27 8B C4 83 EC 20 83 E4 F0 89 44 24 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 8B 64 24 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "_fgetwc"
		size = 233
		refs = "0008 __sehtable$_fgetwc 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GA@GEOKFMMH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1O@CGPBPCOK@?$AAf?$AAg?$AAe?$AAt?$AAw?$AAc?$AA?$AA@ 0087 __invalid_parameter 009a __lock_file 00ad __fgetwc_nolock 00cb __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF 00 00 EB 42 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 66 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "__fgetwc_nolock"
		size = 850
		refs = "001d __fileno 0060 ___pioinfo 006c ___badioinfo 00c8 __filbuf 0251 _isleadbyte 02b9 _ungetc 02e4 _mbtowc 02f1 __errno 0346 __filwbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 56 8B 45 08 8B 48 0C 83 E1 40 0F 85 4F 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F C1 E0 06 03 04 B5 ?? ?? ?? ?? 89 45 E0 EB 07 C7 45 E0 ?? ?? ?? ?? 8B 45 E0 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 0F 84 E2 00 00 00 8D 45 F8 89 45 FC 8B 4D 08 8B 51 04 83 EA 01 8B 45 08 89 50 04 8B 4D 08 83 79 04 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D DC 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 45 DC 89 45 F4 83 7D F4 FF 75 0A B8 FF FF 00 00 E9 65 02 00 00 8B 4D FC 8A 55 F4 88 11 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8B 51 04 83 EA 01 8B 45 08 89 50 04 8B 4D 08 83 79 04 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D D8 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8B 45 D8 89 45 F4 83 7D F4 FF 75 0A B8 FF FF 00 00 E9 F7 01 00 00 8B 4D FC 8A 55 F4 88 11 66 8B 45 F8 E9 E6 01 00 00 8B 45 08 8B 48 0C 83 E1 40 0F 85 92 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 40 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FE 74 2F 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 C1 FE 05 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 83 E0 1F C1 E0 06 03 04 B5 ?? ?? ?? ?? 89 45 D4 EB 07 C7 45 D4 ?? ?? ?? ?? 8B 45 D4 0F BE 48 04 81 E1 80 00 00 00 0F 84 27 01 00 00 C7 45 F0 01 00 00 00 8B 55 08 8B 42 04 83 E8 01 8B 4D 08 89 41 04 8B 55 08 83 7A 04 00 7C 20 8B 45 08 8B 08 0F BE 11 81 E2 FF 00 00 00 89 55 D0 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A EB 0F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 8B 4D D0 89 4D E4 83 7D E4 FF 75 0A B8 FF FF 00 00 E9 08 01 00 00 8A 55 E4 88 55 E8 0F B6 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 7B 8B 4D 08 8B 51 04 83 EA 01 8B 45 08 89 50 04 8B 4D 08 83 79 04 00 7C 20 8B 55 08 8B 02 0F BE 08 81 E1 FF 00 00 00 89 4D CC 8B 55 08 8B 02 83 C0 01 8B 4D 08 89 01 EB 0F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 CC 8B 45 CC 89 45 E4 83 7D E4 FF 75 1B 8B 4D 08 51 0F BE 55 E8 52 E8 ?? ?? ?? ?? 83 C4 08 B8 FF FF 00 00 E9 83 00 00 00 8A 45 E4 88 45 E9 C7 45 F0 02 00 00 00 8B 4D F0 51 8D 55 E8 52 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 12 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 B8 FF FF 00 00 EB 4B 66 8B 45 EC EB 45 8B 4D 08 8B 51 04 83 EA 02 8B 45 08 89 50 04 8B 4D 08 83 79 04 00 7C 21 8B 55 08 8B 02 66 8B 08 66 89 4D CA 8B 55 08 8B 02 83 C0 02 8B 4D 08 89 01 66 8B 45 CA EB 0E EB 0C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__wcstoi64"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_506_0_0 {
	meta:
		name = "__strtoi64"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "_strtol"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_815_0_0 {
	meta:
		name = "_wcstol"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 1333
		refs = "0008 __ehhandler$?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z 0019 ___security_cookie 0031 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005d ??_C@_1BK@LAOAACLJ@?$AAn?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0066 ??_C@_1GA@OFLNHKCJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006d __CrtDbgReportW 0081 __errno 0095 ??_C@_1BA@FACINJJA@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAx?$AAq?$AA?$AA@ 009f __invalid_parameter 00bf ??1_LocaleUpdate@@QAE@XZ 00fd ??_C@_1FE@CEHLKAHD@?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAi?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAi?$AAb?$AAa@ 0199 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01a6 __iswctype_l 025f __wchartodigit 02ed __aulldiv 03b0 __aullrem 03e1 __allmul"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 70 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B 45 08 50 8D 4D D0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 7D 10 00 74 08 8B 4D 10 8B 55 0C 89 11 33 C0 83 7D 0C 00 0F 95 C0 89 45 C0 83 7D C0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 4E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 B4 00 00 00 00 C7 45 B8 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 B4 8B 55 B8 E9 56 04 00 00 83 7D 14 00 74 15 83 7D 14 02 7C 06 83 7D 14 24 7E 09 C7 45 98 00 00 00 00 EB 07 C7 45 98 01 00 00 00 8B 55 98 89 55 BC 83 7D BC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 60 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 4E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 AC 00 00 00 00 C7 45 B0 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 AC 8B 55 B0 E9 B6 03 00 00 8B 4D 0C 89 4D F0 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 00 8B 55 F0 66 8B 02 66 89 45 E0 8B 4D F0 83 C1 02 89 4D F0 8D 4D D0 E8 ?? ?? ?? ?? 50 6A 08 0F B7 55 E0 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 15 8B 45 F0 66 8B 08 66 89 4D E0 8B 55 F0 83 C2 02 89 55 F0 EB CF 0F B7 45 E0 83 F8 2D 75 1E 8B 4D 18 83 C9 02 89 4D 18 8B 55 F0 66 8B 02 66 89 45 E0 8B 4D F0 83 C1 02 89 4D F0 EB 1C 0F B7 55 E0 83 FA 2B 75 13 8B 45 F0 66 8B 08 66 89 4D E0 8B 55 F0 83 C2 02 89 55 F0 83 7D 14 00 7C 0C 83 7D 14 01 74 06 83 7D 14 24 7E 38 83 7D 10 00 74 08 8B 45 10 8B 4D 0C 89 08 C7 45 A4 00 00 00 00 C7 45 A8 00 00 00 00 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 A4 8B 55 A8 E9 D3 02 00 00 EB 46 83 7D 14 00 75 40 0F B7 55 E0 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 14 0A 00 00 00 EB 26 8B 45 F0 0F B7 08 83 F9 78 74 0B 8B 55 F0 0F B7 02 83 F8 58 75 09 C7 45 14 10 00 00 00 EB 07 C7 45 14 08 00 00 00 83 7D 14 10 75 43 0F B7 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 32 8B 55 F0 0F B7 02 83 F8 78 74 0B 8B 4D F0 0F B7 11 83 FA 58 75 1C 8B 45 F0 83 C0 02 89 45 F0 8B 4D F0 66 8B 11 66 89 55 E0 8B 45 F0 83 C0 02 89 45 F0 8B 45 14 99 52 50 6A FF 6A FF E8 ?? ?? ?? ?? 89 45 E4 89 55 E8 0F B7 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 83 7D EC FF 74 02 EB 59 0F B7 55 E0 83 FA 41 7C 09 0F B7 45 E0 83 F8 5A 7E 12 0F B7 4D E0 83 F9 61 7C 39 0F B7 55 E0 83 FA 7A 7F 30 0F B7 45 E0 83 F8 61 7C 15 0F B7 4D E0 83 F9 7A 7F 0C 0F B7 55 E0 83 EA 20 89 55 94 EB 07 0F B7 45 E0 89 45 94 8B 4D 94 83 E9 37 89 4D EC EB 05 E9 B7 00 00 00 8B 55 EC 3B 55 14 72 05 E9 AA 00 00 00 8B 45 18 83 C8 08 89 45 18 8B 4D C8 3B 4D E8 72 4C 77 08 8B 55 C4 3B 55 E4 72 42 8B 45 C4 3B 45 E4 75 5E 8B 4D C8 3B 4D E8 75 56 8B 75 EC 33 FF 8B 45 14 99 52 50 6A FF 6A FF E8 ?? ?? ?? ?? 89 75 8C 89 7D 90 89 45 84 89 55 88 8B 55 90 3B 55 88 77 2E 72 08 8B 45 8C 3B 45 84 77 24 8B 45 14 99 52 50 8B 4D C8 51 8B 55 C4 52 E8 ?? ?? ?? ?? 8B 4D EC 33 F6 03 C1 13 D6 89 45 C4 89 55 C8 EB 11 8B 55 18 83 CA 04 89 55 18 83 7D 10 00 75 02 EB 18 8B 45 F0 66 8B 08 66 89 4D E0 8B 55 F0 83 C2 02 89 55 F0 E9 D8 FE FF FF 8B 45 F0 83 E8 02 89 45 F0 8B 4D 18 83 E1 08 75 1F 83 7D 10 00 74 06 8B 55 0C 89 55 F0 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 00 E9 8B 00 00 00 8B 45 18 83 E0 04 75 3A 8B 4D 18 83 E1 01 75 7B 8B 55 18 83 E2 02 74 11 81 7D C8 00 00 00 80 77 21 72 06 83 7D C4 00 77 19 8B 45 18 83 E0 02 75 5A 81 7D C8 FF FF FF 7F 72 51 77 06 83 7D C4 FF 76 49 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 4D 18 83 E1 01 74 10 C7 45 C4 FF FF FF FF C7 45 C8 FF FF FF FF EB 26 8B 55 18 83 E2 02 74 10 C7 45 C4 00 00 00 00 C7 45 C8 00 00 00 80 EB 0E C7 45 C4 FF FF FF FF C7 45 C8 FF FF FF 7F 83 7D 10 00 74 08 8B 45 10 8B 4D F0 89 08 8B 55 18 83 E2 02 74 13 8B 45 C4 F7 D8 8B 4D C8 83 D1 00 F7 D9 89 45 C4 89 4D C8 8B 55 C4 89 55 9C 8B 45 C8 89 45 A0 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 9C 8B 55 A0 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_3_0 {
	meta:
		name = "__ehhandler$?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_306_1 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_850_1 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_721_1 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_4_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 217
		refs = "001b __getptd 0049 ___ptlocinfo 005a ___globallocalestatus 0061 ___updatetlocinfo 0072 ___ptmbcinfo 008a ___updatetmbcinfo"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C6 40 0C 00 83 7D 08 00 0F 85 A6 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 89 41 08 8B 55 FC 8B 42 08 8B 4D FC 8B 50 6C 89 11 8B 45 FC 8B 48 08 8B 55 FC 8B 41 68 89 42 04 8B 4D FC 8B 11 3B 15 ?? ?? ?? ?? 74 1B 8B 45 FC 8B 48 08 8B 51 70 23 15 ?? ?? ?? ?? 75 0A E8 ?? ?? ?? ?? 8B 4D FC 89 01 8B 55 FC 8B 42 04 3B 05 ?? ?? ?? ?? 74 1C 8B 4D FC 8B 51 08 8B 42 70 23 05 ?? ?? ?? ?? 75 0B E8 ?? ?? ?? ?? 8B 4D FC 89 41 04 8B 55 FC 8B 42 08 8B 48 70 83 E1 02 75 1C 8B 55 FC 8B 42 08 8B 48 70 83 C9 02 8B 55 FC 8B 42 08 89 48 70 8B 4D FC C6 41 0C 01 EB 10 8B 55 08 8B 02 8B 4A 04 8B 55 FC 89 02 89 4A 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_5_0 {
	meta:
		name = "??1_LocaleUpdate@@QAE@XZ"
		size = 45
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 0C 85 C9 74 15 8B 55 FC 8B 42 08 8B 48 70 83 E1 FD 8B 55 FC 8B 42 08 89 48 70 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_6_0 {
	meta:
		name = "?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ"
		size = 16
		altNames = "??0?$allocator@D@std@@QAE@XZ ??0?$allocator@G@std@@QAE@XZ ??0?$allocator@_W@std@@QAE@XZ ??D?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ ??D?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@XZ ??D?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@XZ ??E?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@XZ ??E?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@XZ ??E?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_8_7_0 {
	meta:
		name = "__wcstoi64_l"
		size = 33
		refs = "0018 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_506_7_0 {
	meta:
		name = "__strtoi64_l"
		size = 33
		refs = "0018 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_376_7_0 {
	meta:
		name = "__strtol_l"
		size = 33
		refs = "0018 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_815_7_0 {
	meta:
		name = "__wcstol_l"
		size = 33
		refs = "0018 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_8_0 {
	meta:
		name = "__wcstoui64"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_506_8_0 {
	meta:
		name = "__strtoui64"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_376_8_0 {
	meta:
		name = "_strtoul"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_815_8_0 {
	meta:
		name = "_wcstoul"
		size = 71
		refs = "0007 ___locale_changed 001d ___initiallocalestructinfo 0022 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1F 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 1A EB 18 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_9_0 {
	meta:
		name = "__wcstoui64_l"
		size = 33
		refs = "0018 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_506_9_0 {
	meta:
		name = "__strtoui64_l"
		size = 33
		refs = "0018 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_376_9_0 {
	meta:
		name = "__strtoul_l"
		size = 33
		refs = "0018 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_815_9_0 {
	meta:
		name = "__wcstoul_l"
		size = 33
		refs = "0018 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__except_handler3"
		size = 254
		refs = "0035 __ValidateEH3RN 007a _CallDestructExceptionObject 0086 __global_unwind2 0093 __local_unwind2 00a4 __NLG_Notify"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 0F 85 C3 00 00 00 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 FC 8B 73 0C 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 0B C0 0F 8E 8F 00 00 00 83 FE FF 0F 84 8D 00 00 00 8D 0C 76 8B 44 8F 04 0B C0 74 66 56 55 8D 6B 10 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 5D 5E 8B 5D 0C 0B C0 74 4C 78 58 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 08 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8D 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 6A 01 8B 44 8F 08 E8 ?? ?? ?? ?? 8B 04 8F 89 43 0C 8B 44 8F 08 33 DB 33 C9 33 D2 33 F6 33 FF FF D0 8B 7B 08 8D 0C 76 8B 34 8F E9 78 FF FF FF B8 00 00 00 00 EB 23 8B 45 08 83 48 04 08 B8 01 00 00 00 EB 15 55 8D 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "__seh_longjmp_unwind@4"
		size = 27
		refs = "0010 __local_unwind2"
	strings:
		$1 = { 55 8B 4C 24 08 8B 29 8B 41 1C 50 8B 41 18 50 E8 ?? ?? ?? ?? 83 C4 08 5D C2 04 00 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__snprintf"
		size = 417
		refs = "0021 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 002a ??_C@_1GC@BMNPEKNN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0031 __CrtDbgReportW 0045 __errno 0059 ??_C@_1BE@CHNFPLHD@?$AA_?$AAs?$AAn?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 0063 __invalid_parameter 009b ??_C@_1EC@FABAOFFO@?$AA?$CI?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ@ 013a __output_l 0190 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C 8D 45 D4 89 45 F4 33 C9 83 7D 10 00 0F 95 C1 89 4D D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2B 01 00 00 83 7D 0C 00 74 0F 83 7D 08 00 75 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 45 C8 89 45 CC 83 7D CC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B1 00 00 00 8D 55 14 89 55 FC 81 7D 0C FF FF FF 7F 76 0C 8B 45 F4 C7 40 04 FF FF FF 7F EB 09 8B 4D F4 8B 55 0C 89 51 04 8B 45 F4 C7 40 0C 42 00 00 00 8B 4D F4 8B 55 08 89 51 08 8B 45 F4 8B 4D 08 89 08 8B 55 FC 52 6A 00 8B 45 10 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D 08 00 75 05 8B 45 F8 EB 4E 8B 55 F4 8B 42 04 83 E8 01 8B 4D F4 89 41 04 8B 55 F4 83 7A 04 00 7C 22 8B 45 F4 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 C4 8B 45 F4 8B 08 83 C1 01 8B 55 F4 89 0A EB 11 8B 45 F4 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C4 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "__snprintf_l"
		size = 44
		refs = "0021 __vsnprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_399_1_0 {
	meta:
		name = "__snprintf_c_l"
		size = 44
		refs = "0021 __vsnprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_1_0 {
	meta:
		name = "__snwprintf_l"
		size = 44
		refs = "0021 __vsnwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_343_7_0 {
	meta:
		name = "__sprintf_p_l"
		size = 44
		refs = "0021 __vsprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_343_3_0 {
	meta:
		name = "__sprintf_s_l"
		size = 44
		refs = "0021 __vsprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_758_1_0 {
	meta:
		name = "__swprintf_c_l"
		size = 44
		refs = "0021 __vswprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_346_7_0 {
	meta:
		name = "__swprintf_p_l"
		size = 44
		refs = "0021 __vswprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_346_5_0 {
	meta:
		name = "__swprintf_s_l"
		size = 44
		refs = "0021 __vswprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 18 89 45 FC 8B 4D FC 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_784_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_632_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_678_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_471_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_645_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_784_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_60_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_632_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_678_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_642_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_471_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_645_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_2_0 {
	meta:
		name = "__CIatan_default"
		size = 159
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 0038 ___fastflag 003f __fast_exit 004a _NAME_ 004f __math_exit 0054 __convertTOStoQNaN 006c __piby2 0099 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 36 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 E8 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 26 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? A9 00 00 00 80 74 BF D9 E0 EB BB B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__execvp"
		size = 25
		refs = "0010 __execvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "__aligned_malloc_base"
		size = 25
		refs = "0010 __aligned_offset_malloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_4_0 {
	meta:
		name = "__atodbl"
		size = 25
		refs = "0010 __atodbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_8_0 {
	meta:
		name = "__atoflt"
		size = 25
		refs = "0010 __atoflt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_479_6_0 {
	meta:
		name = "__atoldbl"
		size = 25
		refs = "0010 __atoldbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_833_1_0 {
	meta:
		name = "__getws_s"
		size = 25
		refs = "0010 __getws_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_680_4_0 {
	meta:
		name = "__ismbslead"
		size = 25
		refs = "0010 __ismbslead_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_270_4_0 {
	meta:
		name = "__ismbstrail"
		size = 25
		refs = "0010 __ismbstrail_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_858_4_0 {
	meta:
		name = "__mbsbtype"
		size = 25
		refs = "0010 __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_398_4_0 {
	meta:
		name = "__mbschr"
		size = 25
		refs = "0010 __mbschr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_418_4_0 {
	meta:
		name = "__mbscmp"
		size = 25
		refs = "0010 __mbscmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_493_4_0 {
	meta:
		name = "__mbscoll"
		size = 25
		refs = "0010 __mbscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_222_4_0 {
	meta:
		name = "__mbscspn"
		size = 25
		refs = "0010 __mbscspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_764_4_0 {
	meta:
		name = "__mbsdec"
		size = 25
		refs = "0010 __mbsdec_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_581_4_0 {
	meta:
		name = "__mbsicmp"
		size = 25
		refs = "0010 __mbsicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_547_4_0 {
	meta:
		name = "__mbsicoll"
		size = 25
		refs = "0010 __mbsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_138_4_0 {
	meta:
		name = "__mbslwr_s"
		size = 25
		refs = "0010 __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_328_4_0 {
	meta:
		name = "__mbsnbcnt"
		size = 25
		refs = "0010 __mbsnbcnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_923_4_0 {
	meta:
		name = "__mbsnccnt"
		size = 25
		refs = "0010 __mbsnccnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_649_1_0 {
	meta:
		name = "__mbsninc"
		size = 25
		refs = "0010 __mbsninc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_794_4_0 {
	meta:
		name = "__mbsnlen"
		size = 25
		refs = "0010 __mbsnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_379_4_0 {
	meta:
		name = "__mbspbrk"
		size = 25
		refs = "0010 __mbspbrk_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_385_4_0 {
	meta:
		name = "__mbsrchr"
		size = 25
		refs = "0010 __mbsrchr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_214_4_0 {
	meta:
		name = "__mbsset"
		size = 25
		refs = "0010 __mbsset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_111_4_0 {
	meta:
		name = "__mbsspn"
		size = 25
		refs = "0010 __mbsspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_408_4_0 {
	meta:
		name = "__mbsspnp"
		size = 25
		refs = "0010 __mbsspnp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_504_4_0 {
	meta:
		name = "__mbsstr"
		size = 25
		refs = "0010 __mbsstr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_480_1_0 {
	meta:
		name = "__mbstok"
		size = 25
		refs = "0010 __mbstok_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_274_4_0 {
	meta:
		name = "__mbstrnlen"
		size = 25
		refs = "0010 __mbstrnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_623_4_0 {
	meta:
		name = "__mbsupr_s"
		size = 25
		refs = "0010 __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_586_9_0 {
	meta:
		name = "__strlwr_s"
		size = 25
		refs = "0010 __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_695_9_0 {
	meta:
		name = "__strupr_s"
		size = 25
		refs = "0010 __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_768_9_0 {
	meta:
		name = "__wcslwr_s"
		size = 25
		refs = "0010 __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_339_9_0 {
	meta:
		name = "__wcsupr_s"
		size = 25
		refs = "0010 __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_933_0_0 {
	meta:
		name = "__wexecvp"
		size = 25
		refs = "0010 __wexecvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_624_1_0 {
	meta:
		name = "_gets_s"
		size = 25
		refs = "0010 __gets_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_679_4_0 {
	meta:
		name = "_strcoll"
		size = 25
		refs = "0010 __strcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_272_4_0 {
	meta:
		name = "_strtod"
		size = 25
		refs = "0010 __strtod_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_489_4_0 {
	meta:
		name = "_wcstod"
		size = 25
		refs = "0010 __wcstod_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__findfirst32i64"
		size = 717
		refs = "000c ___security_cookie 002f ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0038 ??_C@_1GE@DLOFGOBB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003f __CrtDbgReportW 0056 __errno 006a ??_C@_1CA@CBALGFIN@?$AA_?$AAf?$AAi?$AAn?$AAd?$AAf?$AAi?$AAr?$AAs?$AAt?$AA3?$AA2?$AAi?$AA6?$AA4?$AA?$AA@ 0074 __invalid_parameter 0097 ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0104 ??_C@_1CC@GOBCANBH@?$AA?$CI?$AAs?$AAz?$AAW?$AAi?$AAl?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0165 __imp__FindFirstFileA@8 0174 __imp__GetLastError@0 01ab $LN15 01b2 $LN16 0206 ___timet_from_ft 024c __allmul 0274 ??_C@_1JO@GJBNBNOP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 028c _strcpy_s 0295 __invoke_watson_if_error 02a6 @__security_check_cookie@4 02b0 $LN3 02b4 $LN2 02b8 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 56 33 C0 83 7D 0C 00 0F 95 C0 89 85 B0 FE FF FF 83 BD B0 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 49 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 1C 02 00 00 C7 85 AC FE FF FF 01 00 00 00 83 BD AC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B4 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 A8 FE FF FF 83 BD A8 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A8 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 47 01 00 00 8D 95 B8 FE FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 71 FF 15 ?? ?? ?? ?? 89 85 B4 FE FF FF 8B 8D B4 FE FF FF 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 83 EA 02 89 95 A4 FE FF FF 83 BD A4 FE FF FF 10 77 2E 8B 85 A4 FE FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 BC 00 00 00 8B 95 B8 FE FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 B8 FE FF FF 8B 45 0C 89 10 8D 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 C4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 CC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 D4 FE FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 6A 00 6A 72 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 E4 FE FF FF 52 68 04 01 00 00 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 5E 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 43
		refs = "0022 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 02 EB 1C 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_15_2_0 {
	meta:
		name = "__findnext32i64"
		size = 733
		refs = "000c ___security_cookie 002f ??_C@_1FA@DAHAMGDA@?$AA?$CI?$AA?$CI?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE?$AA?$CJ?$AAh?$AAF?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA_?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE@ 003b ??_C@_1GE@DLOFGOBB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0042 __CrtDbgReportW 0059 __errno 0070 ??_C@_1BO@BOILMGOI@?$AA_?$AAf?$AAi?$AAn?$AAd?$AAn?$AAe?$AAx?$AAt?$AA3?$AA2?$AAi?$AA6?$AA4?$AA?$AA@ 007a __invalid_parameter 00a2 ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0110 ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0177 __imp__FindNextFileA@8 0181 __imp__GetLastError@0 01b8 $LN15 01bf $LN16 0213 ___timet_from_ft 0259 __allmul 0284 ??_C@_1JO@GJBNBNOP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 029c _strcpy_s 02a5 __invoke_watson_if_error 02b5 @__security_check_cookie@4 02c0 $LN3 02c4 $LN2 02c8 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 C0 83 7D 08 FF 0F 95 C0 89 85 B0 FE FF FF 83 BD B0 FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 25 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 AC FE FF FF 83 BD AC FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B2 01 00 00 C7 85 A8 FE FF FF 01 00 00 00 83 BD A8 FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A8 FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 44 01 00 00 8D 95 B8 FE FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 71 FF 15 ?? ?? ?? ?? 89 85 B4 FE FF FF 8B 8D B4 FE FF FF 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 83 EA 02 89 95 A4 FE FF FF 83 BD A4 FE FF FF 10 77 2E 8B 85 A4 FE FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 BE 00 00 00 8B 95 B8 FE FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 B8 FE FF FF 8B 45 0C 89 10 8D 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 C4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 CC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 95 D4 FE FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D D8 FE FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 10 89 51 14 6A 00 68 C1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 E4 FE FF FF 52 68 04 01 00 00 8B 45 0C 83 C0 18 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__splitpath_s"
		size = 1563
		refs = "0102 _strncpy_s 013d ___crtDebugFillThreshold 0168 _memset 01a0 __ismbblead 0531 ??_C@_1CI@MLPLHPBP@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAP?$AAa?$AAt?$AAh?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 053d ??_C@_1HA@GHKPFCBF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0544 __CrtDbgReportW 0558 __errno 056f ??_C@_1BK@GOODFINI@?$AA_?$AAs?$AAp?$AAl?$AAi?$AAt?$AAp?$AAa?$AAt?$AAh?$AA_?$AAs?$AA?$AA@ 0579 __invalid_parameter 05b1 ??_C@_1DE@MLEJGPLF@?$AA?$CI?$AAL?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAp?$AAa?$AAr?$AAa?$AAm?$AAe?$AAt?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 C7 45 F4 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 E8 00 00 00 00 83 7D 08 00 75 05 E9 6F 03 00 00 83 7D 0C 00 75 06 83 7D 10 00 75 0C 83 7D 0C 00 74 0B 83 7D 10 00 75 05 E9 52 03 00 00 83 7D 14 00 75 06 83 7D 18 00 75 0C 83 7D 14 00 74 0B 83 7D 18 00 75 05 E9 35 03 00 00 83 7D 1C 00 75 06 83 7D 20 00 75 0C 83 7D 1C 00 74 0B 83 7D 20 00 75 05 E9 18 03 00 00 83 7D 24 00 75 06 83 7D 28 00 75 0C 83 7D 24 00 74 0B 83 7D 28 00 75 05 E9 FB 02 00 00 83 7D F4 00 0F 85 C9 00 00 00 C7 45 E4 01 00 00 00 8B 45 08 89 45 EC 83 7D E4 00 76 1E 8B 4D EC 0F BE 11 85 D2 74 14 8B 45 E4 83 E8 01 89 45 E4 8B 4D EC 83 C1 01 89 4D EC EB DC 8B 55 EC 0F BE 02 83 F8 3A 75 32 83 7D 0C 00 74 21 83 7D 10 03 73 05 E9 AB 02 00 00 6A 02 8B 4D 08 51 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D EC 83 C1 01 89 4D 08 EB 5B 83 7D 0C 00 74 55 8B 55 0C C6 02 00 83 7D 10 FF 74 49 81 7D 10 FF FF FF 7F 74 40 83 7D 10 01 76 3A 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D8 EB 09 8B 55 10 83 EA 01 89 55 D8 8B 45 D8 50 68 FE 00 00 00 8B 4D 0C 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 F0 00 00 00 00 C7 45 FC 00 00 00 00 8B 55 08 89 55 EC EB 09 8B 45 EC 83 C0 01 89 45 EC 8B 4D EC 0F BE 11 85 D2 74 52 8B 45 EC 0F BE 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0B 8B 55 EC 83 C2 01 89 55 EC EB 32 8B 45 EC 0F BE 08 83 F9 2F 74 0B 8B 55 EC 0F BE 02 83 F8 5C 75 0B 8B 4D EC 83 C1 01 89 4D F0 EB 11 8B 55 EC 0F BE 02 83 F8 2E 75 06 8B 4D EC 89 4D FC EB 9B 83 7D F0 00 74 3C 83 7D 14 00 74 2E 8B 55 F0 2B 55 08 89 55 F8 8B 45 18 3B 45 F8 77 05 E9 92 01 00 00 8B 4D F8 51 8B 55 08 52 8B 45 18 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 F0 89 55 08 EB 5B 83 7D 14 00 74 55 8B 45 14 C6 00 00 83 7D 18 FF 74 49 81 7D 18 FF FF FF 7F 74 40 83 7D 18 01 76 3A 8B 4D 18 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 D4 EB 09 8B 45 18 83 E8 01 89 45 D4 8B 4D D4 51 68 FE 00 00 00 8B 55 14 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 74 75 8B 45 FC 3B 45 08 72 6D 83 7D 1C 00 74 2E 8B 4D FC 2B 4D 08 89 4D F8 8B 55 20 3B 55 F8 77 05 E9 ED 00 00 00 8B 45 F8 50 8B 4D 08 51 8B 55 20 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 10 83 7D 24 00 74 2E 8B 4D EC 2B 4D FC 89 4D F8 8B 55 28 3B 55 F8 77 05 E9 B9 00 00 00 8B 45 F8 50 8B 4D FC 51 8B 55 28 52 8B 45 24 50 E8 ?? ?? ?? ?? 83 C4 10 E9 8E 00 00 00 83 7D 1C 00 74 2E 8B 4D EC 2B 4D 08 89 4D F8 8B 55 20 3B 55 F8 77 05 E9 80 00 00 00 8B 45 F8 50 8B 4D 08 51 8B 55 20 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 10 83 7D 24 00 74 54 8B 4D 24 C6 01 00 83 7D 28 FF 74 48 81 7D 28 FF FF FF 7F 74 3F 83 7D 28 01 76 39 8B 55 28 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 D0 EB 09 8B 4D 28 83 E9 01 89 4D D0 8B 55 D0 52 68 FE 00 00 00 8B 45 24 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 E9 80 02 00 00 C7 45 E8 01 00 00 00 83 7D 0C 00 74 5A 83 7D 10 00 76 54 8B 4D 0C C6 01 00 83 7D 10 FF 74 48 81 7D 10 FF FF FF 7F 74 3F 83 7D 10 01 76 39 8B 55 10 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 CC EB 09 8B 4D 10 83 E9 01 89 4D CC 8B 55 CC 52 68 FE 00 00 00 8B 45 0C 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 74 5A 83 7D 18 00 76 54 8B 4D 14 C6 01 00 83 7D 18 FF 74 48 81 7D 18 FF FF FF 7F 74 3F 83 7D 18 01 76 39 8B 55 18 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C8 EB 09 8B 4D 18 83 E9 01 89 4D C8 8B 55 C8 52 68 FE 00 00 00 8B 45 14 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 1C 00 74 5A 83 7D 20 00 76 54 8B 4D 1C C6 01 00 83 7D 20 FF 74 48 81 7D 20 FF FF FF 7F 74 3F 83 7D 20 01 76 39 8B 55 20 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C4 EB 09 8B 4D 20 83 E9 01 89 4D C4 8B 55 C4 52 68 FE 00 00 00 8B 45 1C 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 24 00 74 5A 83 7D 28 00 76 54 8B 4D 24 C6 01 00 83 7D 28 FF 74 48 81 7D 28 FF FF FF 7F 74 3F 83 7D 28 01 76 39 8B 55 28 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 C0 EB 09 8B 4D 28 83 E9 01 89 4D C0 8B 55 C0 52 68 FE 00 00 00 8B 45 24 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C9 83 7D 08 00 0F 95 C1 89 4D E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D5 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 8D 00 00 00 83 7D E8 00 74 77 33 C0 74 09 C7 45 BC 01 00 00 00 EB 07 C7 45 BC 00 00 00 00 8B 4D BC 89 4D DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D8 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D8 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 10 E8 ?? ?? ?? ?? C7 00 22 00 00 00 B8 22 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "___libm_sse2_log10f"
		size = 377
		refs = "0004 _dword_mask 000c _SIGMASK 0018 _EXPMASK 0039 _cv 0077 _B_table 00a8 _T_Tbl 00cc _L102 010e _pow2_64 0152 _SNAN 015f _One 016b _NEG_INF"
	strings:
		$1 = { F3 0F 10 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F DB C4 66 0F 12 1D ?? ?? ?? ?? 66 0F 6F F8 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 C8 66 0F 56 CB 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B D1 81 FA 00 80 00 00 0F 83 87 00 00 00 B9 3F 3F 00 00 66 0F 6E C1 66 0F 12 1D ?? ?? ?? ?? 83 E0 7F 83 C0 01 25 FE 00 00 00 03 C0 03 C0 66 0F 12 B8 ?? ?? ?? ?? 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 80 ?? ?? ?? ?? F2 0F 59 CF F2 0F 5C CB F2 0F 10 F9 F2 0F 59 E9 F2 0F 10 D9 F2 0F 59 C9 F2 0F 58 EE F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 D1 F2 0F 58 D3 F2 0F 59 FD F2 0F 58 C4 F2 0F 58 D7 F2 0F 58 C2 66 0F 5A C0 C3 66 0F 7E FA 81 FA 00 00 00 80 73 37 81 FA 00 00 80 7F 73 6B 83 FA 00 74 51 F3 0F 59 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F C5 C4 01 0F 5A C4 66 0F 54 C8 66 0F 56 CB B9 3F 5F 00 00 E9 3B FF FF FF 81 FA 00 00 00 80 74 1F 81 E2 FF FF FF 7F 81 FA 01 00 80 7F 73 26 F3 0F 10 C7 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C1 C3 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5E CF F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C7 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "_rename"
		size = 71
		refs = "0010 __imp__MoveFileA@8 001a __imp__GetLastError@0 0035 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_650_0_0 {
	meta:
		name = "__wrename"
		size = 71
		refs = "0010 __imp__MoveFileW@8 001a __imp__GetLastError@0 0035 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 8B 4D 08 51 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "___security_init_cookie"
		size = 219
		refs = "0018 ___security_cookie 0038 ___security_cookie_complement 0047 __imp__GetSystemTimeAsFileTime@4 005c __imp__GetCurrentProcessId@0 0068 __imp__GetCurrentThreadId@0 0074 __imp__GetTickCount@0 0084 __imp__QueryPerformanceCounter@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 81 3D ?? ?? ?? ?? 4E E6 40 BB 74 1F A1 ?? ?? ?? ?? 25 00 00 FF FF 74 13 8B 0D ?? ?? ?? ?? F7 D1 89 0D ?? ?? ?? ?? E9 96 00 00 00 8D 55 F8 52 FF 15 ?? ?? ?? ?? 8B 45 F8 89 45 F4 8B 4D F4 33 4D FC 89 4D F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 FF 15 ?? ?? ?? ?? 33 45 F4 89 45 F4 8D 55 E8 52 FF 15 ?? ?? ?? ?? 8B 45 F4 33 45 E8 89 45 F4 8B 4D F4 33 4D EC 89 4D F4 81 7D F4 4E E6 40 BB 75 09 C7 45 F4 4F E6 40 BB EB 17 8B 55 F4 81 E2 00 00 FF FF 75 0C 8B 45 F4 C1 E0 10 0B 45 F4 89 45 F4 8B 4D F4 89 0D ?? ?? ?? ?? 8B 55 F4 F7 D2 89 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "__87except"
		size = 432
		refs = "001f ___security_cookie 0054 $LN19 00b1 __handle_exc 0121 __raise_exc 0134 __ctrlfp 014f __matherr_flag 015b __matherr 0178 __set_errno_from_matherr 0185 @__security_check_cookie@4 0190 $LN14 0194 $LN11 0198 $LN13 019c $LN12 01a4 $LN8 01a8 $LN9 01ac $LN10"
	strings:
		$1 = { 8B FF 53 8B DC 83 EC 08 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 81 EC A0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 43 10 0F B7 08 89 4D F8 8D 55 F8 89 55 F4 8B 43 0C 8B 08 89 4D F0 8B 55 F0 83 EA 01 89 55 F0 83 7D F0 07 77 40 8B 45 F0 FF 24 85 ?? ?? ?? ?? C7 45 EC 08 00 00 00 EB 34 C7 45 EC 11 00 00 00 EB 2B C7 45 EC 12 00 00 00 EB 22 C7 45 EC 04 00 00 00 EB 19 C7 45 EC 10 00 00 00 EB 10 8B 4B 0C C7 01 01 00 00 00 C7 45 EC 00 00 00 00 83 7D EC 00 0F 84 89 00 00 00 8B 55 F4 8B 02 50 8B 4B 0C 83 C1 18 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 6C 8B 43 08 89 45 E8 83 7D E8 10 74 0E 83 7D E8 16 74 08 83 7D E8 1D 74 02 EB 20 8B 4D B0 83 C9 01 89 4D B0 8B 55 B0 83 E2 E1 83 CA 02 89 55 B0 8B 43 0C DD 40 10 DD 5D A0 EB 09 8B 4D B0 83 E1 FE 89 4D B0 8B 53 0C 83 C2 18 52 8B 43 0C 83 C0 08 50 8B 4B 08 51 8B 55 EC 52 8B 45 F4 50 8D 8D 70 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 18 68 FF FF 00 00 8B 55 F4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 C7 85 6C FF FF FF 00 00 00 00 8B 4B 0C 83 39 08 74 1B 83 3D ?? ?? ?? ?? 00 75 12 8B 53 0C 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 6C FF FF FF 83 BD 6C FF FF FF 00 75 0E 8B 43 0C 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__wexecve"
		size = 1241
		refs = "0028 ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0034 ??_C@_1GC@PEGDHOID@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003b __CrtDbgReportW 004f __errno 0066 ??_C@_1BC@EKDLGEAB@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAv?$AAe?$AA?$AA@ 0070 __invalid_parameter 0091 ??_C@_1CE@CONABGGG@?$AA?$CK?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00fb ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0167 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01d2 ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0230 _wcsrchr 0266 _wcschr 027f _wcslen 0292 ??_C@_0DB@JOMLOMIN@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 029f __calloc_dbg 02c9 ??_C@_1FE@EDEBHNHE@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe@ 02ce ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 02db _wcscpy_s 02e4 __invoke_watson_if_error 02fd ??_C@_1FA@KFCDCBOG@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe@ 030e _wcscat_s 0362 __waccess_s 037a _wcomexecmd 03d8 ??_C@_1DI@MLPIPGLK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?$AA@ 0442 ??_C@_1GA@NDGMJEBK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAe?$AAx?$AAt?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAe?$AAx?$AAt?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5@ 044c _ext_strings 04b5 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8B 45 08 89 45 F0 C7 45 E4 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 56 04 00 00 8B 45 08 0F B7 08 F7 D9 1B C9 F7 D9 89 4D DC 75 21 68 ?? ?? ?? ?? 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 ED 03 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 83 03 00 00 8B 55 0C 33 C0 83 3A 00 0F 95 C0 89 45 D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 17 03 00 00 8B 55 0C 8B 02 0F B7 08 F7 D9 1B C9 F7 D9 89 4D D0 75 21 68 ?? ?? ?? ?? 6A 00 68 E0 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AC 02 00 00 6A 5C 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 6A 2F 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 0F 85 D4 00 00 00 83 7D FC 00 0F 85 C8 00 00 00 6A 3A 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 0F 85 AD 00 00 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 03 89 45 CC 68 F3 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F0 83 7D F0 00 75 08 83 C8 FF E9 1E 02 00 00 6A 00 68 F6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 CC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 F7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 51 8B 55 CC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D F0 83 C1 04 89 4D FC EB 14 83 7D FC 00 74 08 8B 55 EC 3B 55 FC 76 06 8B 45 EC 89 45 FC C7 45 F8 FF FF FF FF 6A 2E 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 74 2E 6A 00 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 17 8B 45 10 50 8B 4D 0C 51 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 E9 33 01 00 00 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 05 89 45 C8 68 25 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 4D C8 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 08 83 C8 FF E9 0F 01 00 00 6A 00 68 28 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F0 52 8B 45 C8 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8D 14 41 89 55 E8 E8 ?? ?? ?? ?? 8B 00 89 45 E4 C7 45 F4 03 00 00 00 EB 09 8B 4D F4 83 E9 01 89 4D F4 83 7D F4 00 7C 7E 6A 00 68 2D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F4 8B 04 95 ?? ?? ?? ?? 50 8B 4D E8 2B 4D FC D1 F9 8B 55 C8 2B D1 52 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 23 E8 ?? ?? ?? ?? 8B 55 E4 89 10 8B 45 10 50 8B 4D 0C 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 EB 05 E9 73 FF FF FF 6A 02 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F0 3B 4D 08 74 0E 6A 02 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "_wcomexecmd"
		size = 303
		refs = "001b ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GC@PEGDHOID@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BG@DLIHJHNJ@?$AAw?$AAc?$AAo?$AAm?$AAe?$AAx?$AAe?$AAc?$AAm?$AAd?$AA?$AA@ 005d __invalid_parameter 007f ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e2 __wcenvarg 0102 __wdospawn 0113 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BF 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5E 8B 4D 08 51 8D 55 F8 52 8D 45 F4 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 05 83 C8 FF EB 38 8B 45 F8 50 8B 4D F4 51 8B 55 08 52 6A 02 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_808_2_0 {
	meta:
		name = "_comexecmd"
		size = 303
		refs = "001b ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GC@PEGDHOID@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BE@BCIEHILB@?$AAc?$AAo?$AAm?$AAe?$AAx?$AAe?$AAc?$AAm?$AAd?$AA?$AA@ 005d __invalid_parameter 007f ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e2 __cenvarg 0102 __dospawn 0113 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BF 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 71 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5E 8B 4D 08 51 8D 55 F8 52 8D 45 F4 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 75 05 83 C8 FF EB 38 8B 45 F8 50 8B 4D F4 51 8B 55 08 52 6A 02 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 6A 02 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "__wcsicoll_l"
		size = 570
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0030 ??_C@_1GE@HCLMOBKC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0037 __CrtDbgReportW 004b __errno 005f ??_C@_1BI@EFNHPDCH@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 0069 __invalid_parameter 007b ??1_LocaleUpdate@@QAE@XZ 009a ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00fe ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01f3 ___crtCompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8B 45 10 50 8D 4D E4 E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 E9 AF 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 E9 3C 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 83 7A 10 00 0F 85 AE 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 C4 EB 09 8B 45 08 0F B7 08 89 4D C4 66 8B 55 C4 66 89 55 FC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 C0 EB 09 8B 45 0C 0F B7 08 89 4D C0 66 8B 55 C0 66 89 55 F4 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 0F B7 55 FC 85 D2 74 10 0F B7 45 FC 0F B7 4D F4 3B C1 0F 84 6C FF FF FF 0F B7 55 FC 0F B7 45 F4 2B D0 89 55 D0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 EB 7A 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 51 04 52 6A FF 8B 45 0C 50 6A FF 8B 4D 08 51 68 01 10 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 8B 42 10 50 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 83 7D F8 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 CC FF FF FF 7F 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 CC EB 14 8B 4D F8 83 E9 02 89 4D C8 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_4_0 {
	meta:
		name = "__wcsicoll"
		size = 409
		refs = "000a ___locale_changed 0028 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0031 ??_C@_1GE@HCLMOBKC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0038 __CrtDbgReportW 004c __errno 0060 ??_C@_1BE@HPGMPCMA@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 006a __invalid_parameter 008e ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 018e __wcsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 83 3D ?? ?? ?? ?? 00 0F 85 6E 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 67 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 67 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 1A 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 68 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 68 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 B4 00 00 00 8B 4D 08 0F B7 11 83 FA 41 7C 19 8B 45 08 0F B7 08 83 F9 5A 7F 0E 8B 55 08 0F B7 02 83 C0 20 89 45 EC EB 09 8B 4D 08 0F B7 11 89 55 EC 66 8B 45 EC 66 89 45 FC 8B 4D 0C 0F B7 11 83 FA 41 7C 19 8B 45 0C 0F B7 08 83 F9 5A 7F 0E 8B 55 0C 0F B7 02 83 C0 20 89 45 E8 EB 09 8B 4D 0C 0F B7 11 89 55 E8 66 8B 45 E8 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 0F B7 45 FC 85 C0 74 10 0F B7 4D FC 0F B7 55 F8 3B CA 0F 84 6C FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 EB 14 EB 12 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_memset"
		size = 122
		refs = "0020 ___sse2_available 0028 __VEC_memzero"
	strings:
		$1 = { 8B 54 24 0C 8B 4C 24 04 85 D2 74 69 33 C0 8A 44 24 08 84 C0 75 16 81 FA 00 01 00 00 72 0E 83 3D ?? ?? ?? ?? 00 74 05 E9 ?? ?? ?? ?? 57 8B F9 83 FA 04 72 31 F7 D9 83 E1 03 74 0C 2B D1 88 07 83 C7 01 83 E9 01 75 F6 8B C8 C1 E0 08 03 C1 8B C8 C1 E0 10 03 C1 8B CA 83 E2 03 C1 E9 02 74 06 F3 AB 85 D2 74 0A 88 07 83 C7 01 83 EA 01 75 F6 8B 44 24 08 5F C3 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "___init_numeric"
		size = 721
		refs = "003e ??_C@_0DB@KKFMDHFI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0049 __calloc_dbg 0082 __malloc_dbg 0099 __free_dbg 0126 ___getlocaleinfo 017c ___free_lconv_num 01af _fix_grouping 01c3 ___lconv_c 0228 __imp__InterlockedDecrement@4 023d ??_C@_1DM@IFKAINNE@?$AAp?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AAo?$AAn?$AAv?$AA_?$AAn?$AAu?$AAm?$AA_?$AAr?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0249 ??_C@_1GC@EDJOCBCL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0250 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 56 57 C7 45 E8 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 89 45 F0 C7 45 F4 00 00 00 00 8B 4D 08 83 79 1C 00 75 0D 8B 55 08 83 7A 18 00 0F 84 C0 01 00 00 6A 65 68 ?? ?? ?? ?? 6A 02 6A 30 6A 01 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 0A B8 01 00 00 00 E9 68 02 00 00 8B 45 08 8B B0 BC 00 00 00 B9 0C 00 00 00 8B 7D E4 F3 A5 6A 71 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 89 45 EC 83 7D EC 00 75 18 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 E9 21 02 00 00 8B 55 EC C7 02 00 00 00 00 8B 45 08 83 78 1C 00 0F 84 F8 00 00 00 6A 7D 68 ?? ?? ?? ?? 6A 02 6A 04 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 00 75 26 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 E9 C9 01 00 00 8B 45 F8 C7 00 00 00 00 00 8B 4D 08 0F B7 51 3E 89 55 FC 8B 45 E4 50 6A 0E 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 8B 45 E4 83 C0 04 50 6A 0F 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 8B 45 E4 83 C0 08 50 6A 10 8B 4D FC 51 6A 01 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 14 0B 45 E8 89 45 E8 74 30 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 83 C8 FF E9 24 01 00 00 8B 45 E4 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 04 EB 29 C7 45 F8 00 00 00 00 8B 55 E4 A1 ?? ?? ?? ?? 89 02 8B 4D E4 8B 15 ?? ?? ?? ?? 89 51 04 8B 45 E4 8B 0D ?? ?? ?? ?? 89 48 08 8B 55 EC C7 02 01 00 00 00 83 7D F8 00 74 09 8B 45 F8 C7 00 01 00 00 00 EB 15 C7 45 F8 00 00 00 00 C7 45 EC 00 00 00 00 C7 45 E4 ?? ?? ?? ?? 8B 4D 08 83 B9 B4 00 00 00 00 74 41 8B 55 08 8B 82 B4 00 00 00 50 FF 15 ?? ?? ?? ?? 85 C0 75 2D 8B 4D 08 83 B9 B4 00 00 00 00 77 21 68 ?? ?? ?? ?? 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 83 B8 B0 00 00 00 00 74 3C 8B 4D 08 8B 91 B0 00 00 00 52 FF 15 ?? ?? ?? ?? 85 C0 75 28 6A 02 8B 45 08 8B 88 B0 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 BC 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 55 F8 89 91 B4 00 00 00 8B 45 08 8B 4D EC 89 88 B0 00 00 00 8B 55 08 8B 45 E4 89 82 BC 00 00 00 33 C0 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "_fix_grouping"
		size = 127
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 0F BE 08 85 C9 74 6B 8B 55 08 0F BE 02 83 F8 30 7C 24 8B 4D 08 0F BE 11 83 FA 39 7F 19 8B 45 08 0F BE 08 83 E9 30 8B 55 08 88 0A 8B 45 08 83 C0 01 89 45 08 EB 3A 8B 4D 08 0F BE 11 83 FA 3B 75 26 8B 45 08 89 45 FC 8B 4D FC 8B 55 FC 8A 42 01 88 01 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 75 E2 EB 09 8B 4D 08 83 C1 01 89 4D 08 EB 8B 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "___free_lconv_num"
		size = 106
		refs = "0014 ___lconv_c 0023 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 02 EB 5B 8B 45 08 8B 08 3B 0D ?? ?? ?? ?? 74 10 6A 02 8B 55 08 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 51 04 3B 15 ?? ?? ?? ?? 74 11 6A 02 8B 45 08 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 42 08 3B 05 ?? ?? ?? ?? 74 11 6A 02 8B 4D 08 8B 51 08 52 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__mbsncpy_s"
		size = 33
		refs = "0018 __mbsncpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_387_3_0 {
	meta:
		name = "__aligned_recalloc_base"
		size = 33
		refs = "0018 __aligned_offset_recalloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_388_19_0 {
	meta:
		name = "__cftof"
		size = 33
		refs = "0018 __cftof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_694_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 33
		refs = "0018 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_779_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 33
		refs = "0018 __mbsnbcat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_511_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 33
		refs = "0018 __mbsnbcpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 33
		refs = "0018 __mbsnbset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 33
		refs = "0018 __mbsncat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "__mbsnset_s"
		size = 33
		refs = "0018 __mbsnset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_907_8_0 {
	meta:
		name = "_wcsftime"
		size = 33
		refs = "0018 __wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__ctime64_s"
		size = 463
		refs = "0031 ??_C@_1FM@LCOGKOBI@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn@ 003a ??_C@_1GC@KODPCLOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0041 __CrtDbgReportW 0055 __errno 0069 ??_C@_1BG@CFEMLMNL@?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA_?$AAs?$AA?$AA@ 0073 __invalid_parameter 00a7 ___crtDebugFillThreshold 00d2 _memset 00ec ??_C@_1CC@FPMHPAM@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 01a1 __localtime64_s 01be _asctime_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 47 01 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D C8 EB 09 8B 55 0C 83 EA 01 89 55 C8 8B 45 C8 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 8C 00 00 00 8B 4D 10 89 4D C4 8B 55 C4 83 7A 04 00 7F 1C 7C 08 8B 45 C4 83 38 00 73 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 16 00 00 00 EB 61 8B 4D 10 89 4D C0 8B 55 C0 83 7A 04 07 7C 1F 7F 0B 8B 45 C0 81 38 FF 6F 40 93 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 16 00 00 00 EB 33 8B 4D 10 51 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 83 7D D8 00 75 17 8D 45 DC 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_1_0 {
	meta:
		name = "__ctime64"
		size = 191
		refs = "001b ??_C@_1CC@FPMHPAM@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 0024 ??_C@_1GC@KODPCLOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BC@LNHMEBEJ@?$AA_?$AAc?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?$AA@ 005d __invalid_parameter 0099 __localtime64_s 00ae _asctime"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 33 C0 83 7D 08 00 0F 95 C0 89 45 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 53 8B 55 08 89 55 D0 8B 45 D0 83 78 04 00 7F 19 7C 08 8B 4D D0 83 39 00 73 0F E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 EB 2B 8B 55 08 52 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 83 7D D8 00 75 10 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_905_1_0 {
	meta:
		name = "__wctime64"
		size = 191
		refs = "001b ??_C@_1CC@FPMHPAM@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 0024 ??_C@_1GC@KODPCLOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BE@DGAEHIKH@?$AA_?$AAw?$AAc?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?$AA@ 005d __invalid_parameter 0099 __localtime64_s 00ae __wasctime"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 33 C0 83 7D 08 00 0F 95 C0 89 45 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 53 8B 55 08 89 55 D0 8B 45 D0 83 78 04 00 7F 19 7C 08 8B 4D D0 83 39 00 73 0F E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 EB 2B 8B 55 08 52 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 83 7D D8 00 75 10 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "__write"
		size = 545
		refs = "0008 __sehtable$__write 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0044 __errno 0061 __nhandle 0084 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 008d ??_C@_1FO@EPLDPDDL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0094 __CrtDbgReportW 00c7 ??_C@_1O@KOFKDHPL@?$AA_?$AAw?$AAr?$AAi?$AAt?$AAe?$AA?$AA@ 00d1 __invalid_parameter 00f2 ___pioinfo 010a ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 016b ___lock_fhandle 01a6 __write_nolock 01d4 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0204 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 B9 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2F 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A9 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 3F E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 E4 FF FF FF FF 33 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "__write_nolock"
		size = 2880
		refs = "000b __chkstk 0010 ___security_cookie 0054 ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005d ??_C@_1FO@EPLDPDDL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0064 __CrtDbgReportW 0078 ___doserrno 0083 __errno 0097 ??_C@_1BM@NCANHCIP@?$AA_?$AAw?$AAr?$AAi?$AAt?$AAe?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 00a1 __invalid_parameter 00c2 ___pioinfo 00f6 ??_C@_1CC@EEOLPHGO@?$AA?$CI?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$CG?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 017d __lseeki64_nolock 0189 __isatty 01b8 __getptd 01f1 __imp__GetConsoleMode@8 0216 __imp__GetConsoleCP@0 029b _isleadbyte 02a7 ??_C@_1DI@CNMHHHLG@?$AAi?$AAs?$AAl?$AAe?$AAa?$AAd?$AAb?$AAy?$AAt?$AAe?$AA?$CI?$AA_?$AAd?$AAb?$AAc?$AAs?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0315 _mbtowc 0445 __imp__WideCharToMultiByte@32 0483 __imp__WriteFile@20 04a8 __imp__GetLastError@0 0543 __putwch_nolock 0ad0 __dosmaperr 0b38 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC B8 90 3C 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 BC C7 45 E8 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 FC 89 45 EC 83 7D 10 00 75 07 33 C0 E9 F1 0A 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 82 0A 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 44 0A 24 D0 E0 D0 F8 88 45 FB 0F BE 4D FB 83 F9 02 74 09 0F BE 55 FB 83 FA 01 75 6F 8B 45 10 83 E0 01 F7 D8 1B C0 83 C0 01 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 78 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 78 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E0 09 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 20 74 12 6A 02 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 64 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 81 E2 80 00 00 00 74 41 E8 ?? ?? ?? ?? 89 45 D4 8B 45 D4 8B 48 6C 33 D2 83 79 14 00 0F 94 C2 89 55 E4 8D 45 D8 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 0F 84 C0 03 00 00 83 7D E4 00 74 0C 0F BE 55 FB 85 D2 0F 84 AE 03 00 00 FF 15 ?? ?? ?? ?? 89 45 C4 C7 45 C8 00 00 00 00 C7 45 CC 00 00 00 00 8B 45 0C 89 45 D0 8B 4D D0 2B 4D 0C 3B 4D 10 0F 83 7D 03 00 00 0F BE 55 FB 85 D2 0F 85 A1 01 00 00 8B 45 D0 0F BE 08 33 D2 83 F9 0A 0F 94 C2 89 55 B0 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 83 7C 0A 38 00 0F 84 AD 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 34 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 B2 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8A 54 01 34 88 55 B4 8B 45 D0 8A 08 88 4D B5 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? C7 44 01 38 00 00 00 00 6A 02 8D 55 B4 52 8D 45 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 97 02 00 00 E9 B7 00 00 00 8B 4D D0 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 0F 84 84 00 00 00 8B 45 D0 2B 45 0C 8B 4D 10 2B C8 83 F9 01 76 27 6A 02 8B 55 D0 52 8D 45 C0 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 4F 02 00 00 8B 4D D0 83 C1 01 89 4D D0 EB 4B 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 55 D0 8A 12 88 54 01 34 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? C7 44 0A 38 01 00 00 00 8B 45 FC 83 C0 01 89 45 FC E9 F9 01 00 00 EB 1C 6A 01 8B 4D D0 51 8D 55 C0 52 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 DB 01 00 00 8B 45 D0 83 C0 01 89 45 D0 EB 34 0F BE 4D FB 83 F9 01 74 09 0F BE 55 FB 83 FA 02 75 22 8B 45 D0 66 8B 08 66 89 4D C0 0F B7 55 C0 33 C0 83 FA 0A 0F 94 C0 89 45 B0 8B 4D D0 83 C1 02 89 4D D0 0F BE 55 FB 85 D2 0F 85 FE 00 00 00 6A 00 6A 00 6A 05 8D 45 B4 50 6A 01 8D 4D C0 51 6A 00 8B 55 C4 52 FF 15 ?? ?? ?? ?? 89 45 C8 83 7D C8 00 75 07 E9 66 01 00 00 EB 5B 6A 00 8D 45 CC 50 8B 4D C8 51 8D 55 B4 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 74 1B 8B 4D D0 2B 4D 0C 03 4D EC 89 4D FC 8B 55 CC 3B 55 C8 7D 05 E9 19 01 00 00 EB 0E FF 15 ?? ?? ?? ?? 89 45 F4 E9 09 01 00 00 83 7D B0 00 74 6C C7 45 C8 01 00 00 00 C6 45 B4 0D 6A 00 8D 45 CC 50 8B 4D C8 51 8D 55 B4 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 74 21 8B 4D CC 3B 4D C8 7D 05 E9 B9 00 00 00 8B 55 EC 83 C2 01 89 55 EC 8B 45 FC 83 C0 01 89 45 FC EB 0E FF 15 ?? ?? ?? ?? 89 45 F4 E9 97 00 00 00 E9 8D 00 00 00 0F BE 4D FB 83 F9 01 74 09 0F BE 55 FB 83 FA 02 75 7B 0F B7 45 C0 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 0F B7 55 C0 3B CA 75 0B 8B 45 FC 83 C0 02 89 45 FC EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 52 83 7D B0 00 74 47 C7 45 C8 01 00 00 00 B9 0D 00 00 00 66 89 4D C0 0F B7 55 C0 52 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 0F B7 4D C0 3B C1 75 14 8B 55 FC 83 C2 01 89 55 FC 8B 45 EC 83 C0 01 89 45 EC EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 74 FC FF FF E9 DC 04 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 81 E1 80 00 00 00 0F 84 6B 04 00 00 C7 45 F4 00 00 00 00 0F BE 55 FB 85 D2 0F 85 3F 01 00 00 C7 85 AC EB FF FF 00 00 00 00 C7 85 A8 EB FF FF 00 00 00 00 8B 45 0C 89 85 AC EB FF FF 8B 8D AC EB FF FF 2B 4D 0C 3B 4D 10 0F 83 0B 01 00 00 8D 95 B0 EB FF FF 89 95 A8 EB FF FF 8B 85 A8 EB FF FF 8D 8D B0 EB FF FF 2B C1 3D FF 13 00 00 73 7A 8B 95 AC EB FF FF 2B 55 0C 3B 55 10 73 6C 8B 85 AC EB FF FF 8A 08 88 8D A7 EB FF FF 8B 95 AC EB FF FF 83 C2 01 89 95 AC EB FF FF 0F BE 85 A7 EB FF FF 83 F8 0A 75 21 8B 4D EC 83 C1 01 89 4D EC 8B 95 A8 EB FF FF C6 02 0D 8B 85 A8 EB FF FF 83 C0 01 89 85 A8 EB FF FF 8B 8D A8 EB FF FF 8A 95 A7 EB FF FF 88 11 8B 85 A8 EB FF FF 83 C0 01 89 85 A8 EB FF FF E9 71 FF FF FF 6A 00 8D 4D F0 51 8B 95 A8 EB FF FF 8D 85 B0 EB FF FF 2B D0 52 8D 8D B0 EB FF FF 51 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 14 01 52 FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 45 FC 03 45 F0 89 45 FC 8B 8D A8 EB FF FF 8D 95 B0 EB FF FF 2B CA 39 4D F0 7D 02 EB 12 EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 E3 FE FF FF E9 17 03 00 00 0F BE 45 FB 83 F8 02 0F 85 43 01 00 00 8B 4D 0C 89 8D 94 D7 FF FF C7 85 9C D7 FF FF 00 00 00 00 8B 95 94 D7 FF FF 2B 55 0C 3B 55 10 0F 83 19 01 00 00 8D 85 A0 D7 FF FF 89 85 9C D7 FF FF 8B 8D 9C D7 FF FF 8D 95 A0 D7 FF FF 2B CA 81 F9 FE 13 00 00 0F 83 83 00 00 00 8B 85 94 D7 FF FF 2B 45 0C 3B 45 10 73 75 8B 8D 94 D7 FF FF 66 8B 11 66 89 95 98 D7 FF FF 8B 85 94 D7 FF FF 83 C0 02 89 85 94 D7 FF FF 0F B7 8D 98 D7 FF FF 83 F9 0A 75 26 8B 55 EC 83 C2 02 89 55 EC B8 0D 00 00 00 8B 8D 9C D7 FF FF 66 89 01 8B 95 9C D7 FF FF 83 C2 02 89 95 9C D7 FF FF 8B 85 9C D7 FF FF 66 8B 8D 98 D7 FF FF 66 89 08 8B 95 9C D7 FF FF 83 C2 02 89 95 9C D7 FF FF E9 63 FF FF FF 6A 00 8D 45 F0 50 8B 8D 9C D7 FF FF 8D 95 A0 D7 FF FF 2B CA 51 8D 85 A0 D7 FF FF 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 55 FC 03 55 F0 89 55 FC 8B 85 9C D7 FF FF 8D 8D A0 D7 FF FF 2B C1 39 45 F0 7D 02 EB 12 EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 05 E9 D5 FE FF FF E9 C7 01 00 00 8B 55 0C 89 95 D4 D0 FF FF C7 85 DC D0 FF FF 00 00 00 00 8B 45 0C 89 85 D4 D0 FF FF 8B 8D D4 D0 FF FF 2B 4D 0C 3B 4D 10 0F 83 99 01 00 00 C7 85 74 C3 FF FF 00 00 00 00 8D 95 E0 D0 FF FF 89 95 DC D0 FF FF 8B 85 DC D0 FF FF 8D 8D E0 D0 FF FF 2B C1 3D A8 06 00 00 73 7A 8B 95 D4 D0 FF FF 2B 55 0C 3B 55 10 73 6C 8B 85 D4 D0 FF FF 66 8B 08 66 89 8D D8 D0 FF FF 8B 95 D4 D0 FF FF 83 C2 02 89 95 D4 D0 FF FF 0F B7 85 D8 D0 FF FF 83 F8 0A 75 1D B9 0D 00 00 00 8B 95 DC D0 FF FF 66 89 0A 8B 85 DC D0 FF FF 83 C0 02 89 85 DC D0 FF FF 8B 8D DC D0 FF FF 66 8B 95 D8 D0 FF FF 66 89 11 8B 85 DC D0 FF FF 83 C0 02 89 85 DC D0 FF FF E9 71 FF FF FF 6A 00 6A 00 68 55 0D 00 00 8D 8D 78 C3 FF FF 51 8B 85 DC D0 FF FF 8D 95 E0 D0 FF FF 2B C2 99 2B C2 D1 F8 50 8D 85 E0 D0 FF FF 50 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 89 85 74 C3 FF FF 83 BD 74 C3 FF FF 00 75 13 FF 15 ?? ?? ?? ?? 89 45 F4 E9 9F 00 00 00 E9 95 00 00 00 C7 85 70 C3 FF FF 00 00 00 00 6A 00 8D 4D F0 51 8B 95 74 C3 FF FF 2B 95 70 C3 FF FF 52 8B 85 70 C3 FF FF 8D 8C 05 78 C3 FF FF 51 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 14 01 52 FF 15 ?? ?? ?? ?? 85 C0 74 11 8B 85 70 C3 FF FF 03 45 F0 89 85 70 C3 FF FF EB 0B FF 15 ?? ?? ?? ?? 89 45 F4 EB 0E 8B 8D 74 C3 FF FF 3B 8D 70 C3 FF FF 7F 91 8B 95 74 C3 FF FF 3B 95 70 C3 FF FF 7E 02 EB 11 8B 85 D4 D0 FF FF 2B 45 0C 89 45 FC E9 55 FE FF FF EB 4A 6A 00 8D 4D F0 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 74 0F C7 45 F4 00 00 00 00 8B 55 F0 89 55 FC EB 09 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D FC 00 0F 85 84 00 00 00 83 7D F4 00 74 30 83 7D F4 05 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 8B 4D F4 89 08 EB 0C 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 56 EB 4C 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 40 74 11 8B 4D 0C 0F BE 11 83 FA 1A 75 06 33 C0 EB 25 EB 1B E8 ?? ?? ?? ?? C7 00 1C 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 C8 FF EB 08 EB 06 8B 45 FC 2B 45 EC 8B 4D BC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__ismbcl0_l"
		size = 149
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 008a ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 51 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 33 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 12 81 7D 08 9F 88 00 00 73 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_4_0 {
	meta:
		name = "__ismbcl0"
		size = 21
		refs = "000c __ismbcl0_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_388_5_0 {
	meta:
		name = "__cropzeros"
		size = 21
		refs = "000c __cropzeros_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "__forcdecpt"
		size = 21
		refs = "000c __forcdecpt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_925_24_0 {
	meta:
		name = "__ismbbkana"
		size = 21
		refs = "000c __ismbbkana_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_284_4_0 {
	meta:
		name = "__ismbcalnum"
		size = 21
		refs = "000c __ismbcalnum_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_171_4_0 {
	meta:
		name = "__ismbcalpha"
		size = 21
		refs = "000c __ismbcalpha_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_126_4_0 {
	meta:
		name = "__ismbcdigit"
		size = 21
		refs = "000c __ismbcdigit_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_903_4_0 {
	meta:
		name = "__ismbcgraph"
		size = 21
		refs = "000c __ismbcgraph_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_852_4_0 {
	meta:
		name = "__ismbchira"
		size = 21
		refs = "000c __ismbchira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_852_6_0 {
	meta:
		name = "__ismbckata"
		size = 21
		refs = "000c __ismbckata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_34_6_0 {
	meta:
		name = "__ismbcl1"
		size = 21
		refs = "000c __ismbcl1_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_34_8_0 {
	meta:
		name = "__ismbcl2"
		size = 21
		refs = "000c __ismbcl2_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_585_4_0 {
	meta:
		name = "__ismbclegal"
		size = 21
		refs = "000c __ismbclegal_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_237_4_0 {
	meta:
		name = "__ismbclower"
		size = 21
		refs = "000c __ismbclower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_818_4_0 {
	meta:
		name = "__ismbcprint"
		size = 21
		refs = "000c __ismbcprint_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_189_4_0 {
	meta:
		name = "__ismbcpunct"
		size = 21
		refs = "000c __ismbcpunct_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_444_4_0 {
	meta:
		name = "__ismbcspace"
		size = 21
		refs = "000c __ismbcspace_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_852_8_0 {
	meta:
		name = "__ismbcsymbol"
		size = 21
		refs = "000c __ismbcsymbol_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_707_4_0 {
	meta:
		name = "__ismbcupper"
		size = 21
		refs = "000c __ismbcupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_810_4_0 {
	meta:
		name = "__mbbtombc"
		size = 21
		refs = "000c __mbbtombc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_402_4_0 {
	meta:
		name = "__mbcjistojms"
		size = 21
		refs = "000c __mbcjistojms_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_402_6_0 {
	meta:
		name = "__mbcjmstojis"
		size = 21
		refs = "000c __mbcjmstojis_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_342_1_0 {
	meta:
		name = "__mbctohira"
		size = 21
		refs = "000c __mbctohira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_673_1_0 {
	meta:
		name = "__mbctokata"
		size = 21
		refs = "000c __mbctokata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_728_4_0 {
	meta:
		name = "__mbctolower"
		size = 21
		refs = "000c __mbctolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_810_6_0 {
	meta:
		name = "__mbctombb"
		size = 21
		refs = "000c __mbctombb_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_426_4_0 {
	meta:
		name = "__mbctoupper"
		size = 21
		refs = "000c __mbctoupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_97_4_0 {
	meta:
		name = "__mbslen"
		size = 21
		refs = "000c __mbslen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_684_4_0 {
	meta:
		name = "__mbsnextc"
		size = 21
		refs = "000c __mbsnextc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_76_4_0 {
	meta:
		name = "__mbsrev"
		size = 21
		refs = "000c __mbsrev_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_940_1_0 {
	meta:
		name = "__mkgmtime32"
		size = 21
		refs = "000c __make__time32_t"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_752_1_0 {
	meta:
		name = "__mkgmtime64"
		size = 21
		refs = "000c __make__time64_t"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_278_4_0 {
	meta:
		name = "__wtof"
		size = 21
		refs = "000c __wtof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_926_4_0 {
	meta:
		name = "_atof"
		size = 21
		refs = "000c __atof_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_512_4_0 {
	meta:
		name = "_isleadbyte"
		size = 21
		refs = "000c __isleadbyte_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_34_5_0 {
	meta:
		name = "__ismbcl1_l"
		size = 158
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0093 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 5A 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 3C 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 1B 81 7D 08 9F 88 00 00 72 12 81 7D 08 72 98 00 00 77 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_7_0 {
	meta:
		name = "__ismbcl2_l"
		size = 158
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0093 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 81 79 04 A4 03 00 00 75 5A 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 45 08 C1 E8 08 0F B6 C8 0F B6 54 0A 1D 83 E2 04 74 3C 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 81 E1 FF 00 00 00 0F B6 D1 0F B6 44 10 1D 83 E0 08 74 1B 81 7D 08 9F 98 00 00 72 12 81 7D 08 A4 EA 00 00 77 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 4D E8 89 4D EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "___libm_sse2_expf"
		size = 343
		refs = "0015 _log2e 0044 _c1 0060 _Tl 007f _Tm 0094 _Th 0137 _INF 0140 _ZERO 0152 _ONE"
	strings:
		$1 = { F3 0F 10 C8 F3 0F 10 E0 B8 3B AA B8 46 66 0F 6E F8 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C1 0F 5A C9 81 E1 FF FF FF 7F 81 E9 00 00 80 31 81 F9 00 00 00 12 0F 83 92 00 00 00 F3 0F 59 C7 F3 0F 2D C0 66 0F 12 35 ?? ?? ?? ?? 66 0F 6E D0 8B C8 C1 E0 03 8B D1 F2 0F 59 D9 D1 F9 83 E0 78 F2 0F 59 B0 ?? ?? ?? ?? 66 0F 12 80 ?? ?? ?? ?? 81 E1 F8 00 00 00 8B C2 C1 FA 06 F3 0F E6 D2 66 0F 12 B9 ?? ?? ?? ?? C1 F8 0E 81 E2 F8 00 00 00 66 0F 6E E8 F2 0F 59 BA ?? ?? ?? ?? F2 0F 5C DA 66 0F 73 F5 34 66 0F 7E E1 8B C1 81 E1 FF FF FF 7F F2 0F 59 F3 81 F9 4F AC AE 42 77 4F 66 0F FE FD F2 0F 58 C6 F2 0F 59 C7 66 0F 5A C0 C3 81 C1 00 00 80 31 81 F9 00 00 80 31 76 76 81 F9 00 00 80 7F 73 40 66 0F 7E E2 81 FA 00 00 00 80 73 0E BA FF FF 7F 7F 66 0F 6E C2 F3 0F 59 C0 C3 BA 00 00 80 00 66 0F 6E C2 F3 0F 59 C0 C3 3D 18 72 B1 42 72 AA 66 0F FE FD F2 0F 58 F0 F2 0F 59 F7 F2 0F 5A C6 C3 81 F9 00 00 80 7F 75 1D 66 0F 7E E0 3D 00 00 80 7F 75 09 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C4 F3 0F 58 C0 C3 F3 0F 10 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "__wexecle"
		size = 455
		refs = "0021 ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002a ??_C@_1GA@IHAAKPOK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0031 __CrtDbgReportW 0045 __errno 0059 ??_C@_1BC@OIHGEFPM@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAl?$AAe?$AA?$AA@ 0063 __invalid_parameter 0084 ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e8 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 014b ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01bc __wexecve"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8D 45 0C 89 45 FC 33 C9 83 7D 08 00 0F 95 C1 89 4D F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 51 01 00 00 8B 45 08 0F B7 08 F7 D9 1B C9 F7 D9 89 4D F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EE 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8A 00 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2A 8B 55 FC 8B 02 8B 4D FC 83 C1 04 89 4D FC 85 C0 74 02 EB EC 8B 55 FC 8B 02 50 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__CIpow_pentium4"
		size = 2912
		refs = "0023 SIGMASK 002b ONEMASK 005c rcp_t1 0070 log2_t1 00ab HALFSIG 00d7 rcp_t2 00eb log2_t2 011d LHN 0133 rcp_t3 0145 log2_t3 022e clv 0289 Shifter 02ad exp2_tbl 02b5 cev 0371 ABSVALMASK 042f NEG_ZERO 0642 NEG_INF 06be sNaN 06c6 QIND 07a9 INF 0844 ___libm_error_support 0a7d EMIN 0aaa NEG_BIG 0ab2 POS_BIG"
	strings:
		$1 = { 55 8B EC 83 EC 10 83 E4 F0 D9 C9 DD 1C 24 DD 5C 24 08 E8 02 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 DB 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 0C 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 17 05 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 E4 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E E1 05 00 00 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 3F 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 0C F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 F2 0F 58 C5 83 EC 10 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 4C 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 DA 00 00 00 0B C1 83 F8 00 0F 84 1C 04 00 00 83 FA 00 0F 8D 05 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A3 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 8C 02 00 00 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5E BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 26 FC FF FF 66 0F 12 7C 24 04 66 0F 12 64 24 04 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 9A 02 00 00 0F 87 DE 01 00 00 83 FA 00 0F 87 D5 01 00 00 E9 86 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 5C FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 10 81 E2 00 00 00 80 83 FA 00 74 31 C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 54 24 04 F2 0F 5E CA BA 1B 00 00 00 E9 99 02 00 00 C1 E1 0D 23 C1 83 F8 00 0F 85 A4 00 00 00 D9 EE C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 BD 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 8D 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 65 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 23 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 DD 05 ?? ?? ?? ?? C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 47 01 00 00 D9 EE C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 2B 01 00 00 D9 EE C3 F2 0F 58 E4 F2 0F 10 C4 BA EE 03 00 00 E9 8F 01 00 00 66 0F 12 54 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 80 FE FF FF 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C9 BA 1C 00 00 00 E9 48 01 00 00 66 0F 12 64 24 04 66 0F 12 54 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 0F 85 A2 00 00 00 66 0F 7E E0 83 F8 00 75 20 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 E9 00 00 00 81 FA 00 00 F0 BF 75 03 D9 E8 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 75 55 66 0F C5 C2 03 66 0F 12 64 24 04 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 99 00 00 00 83 F8 00 74 14 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 72 17 D9 EE C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 03 D9 EE C3 DD 05 ?? ?? ?? ?? C3 F2 0F 58 D2 F2 0F 10 C2 BA EE 03 00 00 EB 63 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? BA 1A 00 00 00 83 F8 00 74 3A 66 0F 7E E0 BA 1D 00 00 00 25 FF FF FF 7F 3D 00 00 F0 7F 77 25 72 05 83 F9 00 77 1E 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? BA 1C 00 00 00 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 83 F8 00 7E 28 3D 00 00 04 00 0F 83 3C 02 00 00 56 8B D0 83 E0 7F 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 26 3D 00 02 FC FF 0F 8E F1 01 00 00 56 8B D0 83 E0 7F 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 3F 00 00 66 0F C4 F8 03 F2 0F 59 54 24 14 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 4E 5E F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 10 FE FF FF BA 19 00 00 00 83 F8 00 0F 84 02 FE FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 5E F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 C6 FD FF FF BA 19 00 00 00 83 F8 00 0F 84 B8 FD FF FF 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 BA 19 00 00 00 E9 84 FD FF FF BA 18 00 00 00 83 F9 00 74 15 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? E9 65 FD FF FF 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 E9 54 FD FF FF 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 EF F6 FF FF 3D 00 00 00 80 72 20 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D 83 EC 10 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 64 24 04 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 2D FF FF FF E9 4B FF FF FF 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "__modf_default"
		size = 361
		refs = "000d __ctrlfp 001d _newcw 0045 __d_ind 0055 __sptype 008d __copysign 00c8 __handle_qnan1 00d9 __real@3ff0000000000000 0103 __except1 0116 __frnd"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 68 FF FF 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 0F B7 4D 0E 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 0F 85 CC 00 00 00 8B 55 10 DD 05 ?? ?? ?? ?? DD 1A 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 83 7D E4 00 7E 6F 83 7D E4 02 7E 08 83 7D E4 03 74 3F EB 61 8B 45 10 DD 45 08 DD 18 83 EC 08 DD 45 08 DD 1C 24 83 EC 08 D9 EE DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 68 FF FF 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 E8 E9 B5 00 00 00 8B 55 10 DD 45 08 DD 1A 8B 45 F4 50 83 EC 08 DD 45 08 DD 1C 24 6A 1C E8 ?? ?? ?? ?? 83 C4 10 E9 91 00 00 00 DD 45 08 DC 05 ?? ?? ?? ?? DD 5D E8 8B 4D 10 DD 45 E8 DD 19 8B 55 F4 52 83 EC 08 DD 45 E8 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 1C 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 59 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F8 8B 45 10 DD 45 F8 DD 18 DD 45 08 DC 65 F8 DD 5D E8 D9 EE DC 5D E8 DF E0 F6 C4 44 7A 14 0F B7 4D 0E 81 E1 00 80 00 00 0F B7 55 EE 0B D1 66 89 55 EE 68 FF FF 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__wwincmdln"
		size = 147
		refs = "0011 __wcmdln 001b ??_C@_11LOCGONAA@?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 F8 00 00 00 00 83 3D ?? ?? ?? ?? 00 75 09 C7 45 F4 ?? ?? ?? ?? EB 08 A1 ?? ?? ?? ?? 89 45 F4 8B 4D F4 89 4D FC 8B 55 FC 0F B7 02 83 F8 20 7F 10 8B 4D FC 0F B7 11 85 D2 74 28 83 7D F8 00 74 22 8B 45 FC 0F B7 08 83 F9 22 75 0C 33 D2 83 7D F8 00 0F 94 C2 89 55 F8 8B 45 FC 83 C0 02 89 45 FC EB C3 8B 4D FC 0F B7 11 85 D2 74 16 8B 45 FC 0F B7 08 83 F9 20 7F 0B 8B 55 FC 83 C2 02 89 55 FC EB E0 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "_qsort"
		size = 1255
		refs = "0043 ??_C@_1DC@HAGCIKOA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 004c ??_C@_1FO@NDBPJPLL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0053 __CrtDbgReportW 006a __errno 007e ??_C@_1M@INMHODIG@?$AAq?$AAs?$AAo?$AAr?$AAt?$AA?$AA@ 0088 __invalid_parameter 00a6 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0110 ??_C@_1BK@HJGMBFLF@?$AAc?$AAo?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01c3 _shortsort 0200 _swap"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 20 01 00 00 83 7D 08 00 75 12 83 7D 0C 00 74 0C C7 85 E0 FE FF FF 00 00 00 00 EB 0A C7 85 E0 FE FF FF 01 00 00 00 8B 85 E0 FE FF FF 89 85 EC FE FF FF 83 BD EC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 72 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD EC FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 72 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 4F 04 00 00 33 D2 3B 55 10 1B C0 F7 D8 89 85 E8 FE FF FF 75 1E 68 ?? ?? ?? ?? 6A 00 6A 73 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD E8 FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 73 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 EC 03 00 00 33 D2 83 7D 14 00 0F 95 C2 89 95 E4 FE FF FF 83 BD E4 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 74 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD E4 FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 74 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 82 03 00 00 83 7D 0C 02 73 05 E9 77 03 00 00 C7 85 78 FF FF FF 00 00 00 00 8B 4D 08 89 4D F8 8B 55 0C 83 EA 01 0F AF 55 10 03 55 08 89 95 F4 FE FF FF 8B 85 F4 FE FF FF 2B 45 F8 33 D2 F7 75 10 83 C0 01 89 85 74 FF FF FF 83 BD 74 FF FF FF 08 77 20 8B 45 14 50 8B 4D 10 51 8B 95 F4 FE FF FF 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 E9 DE 02 00 00 8B 8D 74 FF FF FF D1 E9 0F AF 4D 10 03 4D F8 89 4D FC 8B 55 FC 52 8B 45 F8 50 FF 55 14 83 C4 08 85 C0 7E 14 8B 4D 10 51 8B 55 FC 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D F4 FE FF FF 51 8B 55 F8 52 FF 55 14 83 C4 08 85 C0 7E 17 8B 45 10 50 8B 8D F4 FE FF FF 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 F4 FE FF FF 50 8B 4D FC 51 FF 55 14 83 C4 08 85 C0 7E 17 8B 55 10 52 8B 85 F4 FE FF FF 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 89 95 7C FF FF FF 8B 85 F4 FE FF FF 89 85 F0 FE FF FF 8B 4D FC 3B 8D 7C FF FF FF 76 2F 8B 95 7C FF FF FF 03 55 10 89 95 7C FF FF FF 8B 85 7C FF FF FF 3B 45 FC 73 15 8B 4D FC 51 8B 95 7C FF FF FF 52 FF 55 14 83 C4 08 85 C0 7E D1 8B 45 FC 3B 85 7C FF FF FF 77 32 8B 8D 7C FF FF FF 03 4D 10 89 8D 7C FF FF FF 8B 95 7C FF FF FF 3B 95 F4 FE FF FF 77 15 8B 45 FC 50 8B 8D 7C FF FF FF 51 FF 55 14 83 C4 08 85 C0 7E CE 8B 95 F0 FE FF FF 2B 55 10 89 95 F0 FE FF FF 8B 85 F0 FE FF FF 3B 45 FC 76 15 8B 4D FC 51 8B 95 F0 FE FF FF 52 FF 55 14 83 C4 08 85 C0 7F D1 8B 85 F0 FE FF FF 3B 85 7C FF FF FF 73 02 EB 33 8B 4D 10 51 8B 95 F0 FE FF FF 52 8B 85 7C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 3B 8D F0 FE FF FF 75 09 8B 95 7C FF FF FF 89 55 FC E9 17 FF FF FF 8B 85 F0 FE FF FF 03 45 10 89 85 F0 FE FF FF 8B 4D FC 3B 8D F0 FE FF FF 73 2F 8B 95 F0 FE FF FF 2B 55 10 89 95 F0 FE FF FF 8B 85 F0 FE FF FF 3B 45 FC 76 15 8B 4D FC 51 8B 95 F0 FE FF FF 52 FF 55 14 83 C4 08 85 C0 74 D1 8B 45 FC 3B 85 F0 FE FF FF 72 2F 8B 8D F0 FE FF FF 2B 4D 10 89 8D F0 FE FF FF 8B 95 F0 FE FF FF 3B 55 F8 76 15 8B 45 FC 50 8B 8D F0 FE FF FF 51 FF 55 14 83 C4 08 85 C0 74 D1 8B 95 F0 FE FF FF 2B 55 F8 8B 85 F4 FE FF FF 2B 85 7C FF FF FF 3B D0 7C 58 8B 4D F8 3B 8D F0 FE FF FF 73 2F 8B 95 78 FF FF FF 8B 45 F8 89 84 95 F8 FE FF FF 8B 8D 78 FF FF FF 8B 95 F0 FE FF FF 89 54 8D 80 8B 85 78 FF FF FF 83 C0 01 89 85 78 FF FF FF 8B 8D 7C FF FF FF 3B 8D F4 FE FF FF 73 0E 8B 95 7C FF FF FF 89 55 F8 E9 40 FD FF FF EB 5C 8B 85 7C FF FF FF 3B 85 F4 FE FF FF 73 32 8B 8D 78 FF FF FF 8B 95 7C FF FF FF 89 94 8D F8 FE FF FF 8B 85 78 FF FF FF 8B 8D F4 FE FF FF 89 4C 85 80 8B 95 78 FF FF FF 83 C2 01 89 95 78 FF FF FF 8B 45 F8 3B 85 F0 FE FF FF 73 11 8B 8D F0 FE FF FF 89 8D F4 FE FF FF E9 E2 FC FF FF 8B 95 78 FF FF FF 83 EA 01 89 95 78 FF FF FF 78 25 8B 85 78 FF FF FF 8B 8C 85 F8 FE FF FF 89 4D F8 8B 95 78 FF FF FF 8B 44 95 80 89 85 F4 FE FF FF E9 AC FC FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_42_1_0 {
	meta:
		name = "_shortsort"
		size = 111
		refs = "0059 _swap"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 3B 45 08 76 5B 8B 4D 08 89 4D F8 8B 55 08 03 55 10 89 55 FC EB 09 8B 45 FC 03 45 10 89 45 FC 8B 4D FC 3B 4D 0C 77 1A 8B 55 F8 52 8B 45 FC 50 FF 55 14 83 C4 08 85 C0 7E 06 8B 4D FC 89 4D F8 EB D5 8B 55 10 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 0C 2B 55 10 89 55 0C EB 9D 8B E5 5D C3 }
	condition:
		$1
}

rule file_42_2_0 {
	meta:
		name = "_swap"
		size = 80
		altNames = "_swap_c"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 3B 45 0C 74 3E 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 2E 8B 45 08 8A 08 88 4D FF 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 0C 8A 4D FF 88 08 8B 55 0C 83 C2 01 89 55 0C EB C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "___InternalCxxFrameHandler"
		size = 339
		refs = "0009 __getptd 007b ___FrameUnwindToState 0143 ?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 83 B8 0C 02 00 00 00 75 3C 8B 45 08 81 38 63 73 6D E0 74 31 8B 4D 08 81 39 26 00 00 80 74 26 8B 55 18 8B 02 25 FF FF FF 1F 3D 22 05 93 19 72 15 8B 4D 18 8B 51 20 83 E2 01 74 0A B8 01 00 00 00 E9 FD 00 00 00 8B 45 08 8B 48 04 83 E1 66 74 34 8B 55 18 83 7A 04 00 74 1C 83 7D 1C 00 75 16 6A FF 8B 45 18 50 8B 4D 14 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 10 B8 01 00 00 00 E9 C3 00 00 00 E9 B9 00 00 00 8B 45 18 83 78 0C 00 75 24 8B 4D 18 8B 11 81 E2 FF FF FF 1F 81 FA 21 05 93 19 0F 82 99 00 00 00 8B 45 18 83 78 1C 00 0F 84 8C 00 00 00 8B 4D 08 81 39 63 73 6D E0 75 58 8B 55 08 83 7A 10 03 72 4F 8B 45 08 81 78 14 22 05 93 19 76 43 8B 4D 08 8B 51 1C 8B 42 08 89 45 FC 83 7D FC 00 74 31 0F B6 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 FF 55 FC 83 C4 20 89 45 F8 8B 45 F8 EB 30 EB 29 8B 45 20 50 8B 4D 1C 51 0F B6 55 24 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 20 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
		size = 1175
		refs = "0053 ?_inconsistency@@YAXXZ 00a9 __getptd 00e2 ?_ValidateRead@@YAHPBXI@Z 016e ?IsInExceptionSpec@@YAEPAUEHExceptionRecord@@PBU_s_ESTypeList@@@Z 0183 ?Is_bad_exception_allowed@@YAEPBU_s_ESTypeList@@@Z 0198 ___DestructExceptionObject 01a0 ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 01a8 ??0bad_exception@std@@QAE@PBD@Z 01ad __TI2?AVbad_exception@std@@ 01b6 __CxxThrowException@8 01bd ?terminate@@YAXXZ 0227 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 02e7 ___TypeMatch 0326 ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z 03e8 ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 040a ___FrameUnwindToState 0419 ?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0470 ?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 C6 45 FB 00 C6 45 FA 00 8B 45 18 81 78 04 80 00 00 00 7F 14 8B 4D 0C 8B 51 08 81 E2 FF 00 00 00 0F BE C2 89 45 BC EB 09 8B 4D 0C 8B 51 08 89 55 BC 8B 45 BC 89 45 FC 83 7D FC FF 7C 0D 8B 4D 18 8B 55 FC 3B 51 04 7D 02 EB 05 E8 ?? ?? ?? ?? 8B 45 08 81 38 63 73 6D E0 0F 85 5B 01 00 00 8B 4D 08 83 79 10 03 0F 85 4E 01 00 00 8B 55 08 81 7A 14 20 05 93 19 74 1C 8B 45 08 81 78 14 21 05 93 19 74 10 8B 4D 08 81 79 14 22 05 93 19 0F 85 26 01 00 00 8B 55 08 83 7A 1C 00 0F 85 19 01 00 00 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 75 05 E9 D8 03 00 00 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 08 E8 ?? ?? ?? ?? 8B 88 8C 00 00 00 89 4D 10 C6 45 FB 01 6A 01 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 02 EB 05 E8 ?? ?? ?? ?? 8B 45 08 81 38 63 73 6D E0 75 3B 8B 4D 08 83 79 10 03 75 32 8B 55 08 81 7A 14 20 05 93 19 74 18 8B 45 08 81 78 14 21 05 93 19 74 0C 8B 4D 08 81 79 14 22 05 93 19 75 0E 8B 55 08 83 7A 1C 00 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 74 79 E8 ?? ?? ?? ?? 8B 80 94 00 00 00 89 45 F4 E8 ?? ?? ?? ?? C7 80 94 00 00 00 00 00 00 00 8B 4D F4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 74 02 EB 43 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 0F B6 D0 85 D2 74 2B 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D C0 51 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B 55 08 81 3A 63 73 6D E0 0F 85 6E 02 00 00 8B 45 08 83 78 10 03 0F 85 61 02 00 00 8B 4D 08 81 79 14 20 05 93 19 74 1C 8B 55 08 81 7A 14 21 05 93 19 74 10 8B 45 08 81 78 14 22 05 93 19 0F 85 39 02 00 00 8B 4D 18 83 79 0C 00 0F 86 2B 01 00 00 8D 55 EC 52 8D 45 F0 50 8B 4D FC 51 8B 55 20 52 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 E8 EB 12 8B 4D F0 83 C1 01 89 4D F0 8B 55 E8 83 C2 14 89 55 E8 8B 45 F0 3B 45 EC 0F 83 EC 00 00 00 8B 4D E8 8B 11 3B 55 FC 7F 0B 8B 45 E8 8B 4D FC 3B 48 04 7E 02 EB CB 8B 55 E8 8B 42 10 89 45 E0 8B 4D E8 8B 51 0C 89 55 E4 EB 12 8B 45 E4 83 E8 01 89 45 E4 8B 4D E0 83 C1 10 89 4D E0 83 7D E4 00 0F 8E A0 00 00 00 8B 55 08 8B 42 1C 8B 48 0C 83 C1 04 89 4D D8 8B 55 08 8B 42 1C 8B 48 0C 8B 11 89 55 DC EB 12 8B 45 DC 83 E8 01 89 45 DC 8B 4D D8 83 C1 04 89 4D D8 83 7D DC 00 7E 64 8B 55 D8 8B 02 89 45 D4 8B 4D 08 8B 51 1C 52 8B 45 D4 50 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 02 EB C3 C6 45 FA 01 0F B6 55 FB 52 8B 45 24 50 8B 4D 20 51 8B 55 E8 52 8B 45 D4 50 8B 4D E0 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 2C EB 09 EB 07 EB 84 E9 44 FF FF FF E9 F6 FE FF FF 0F B6 4D 1C 85 C9 74 0E 6A 01 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 45 FA 85 C0 0F 85 DD 00 00 00 8B 4D 18 8B 11 81 E2 FF FF FF 1F 81 FA 21 05 93 19 0F 82 C6 00 00 00 8B 45 18 83 78 1C 00 0F 84 B9 00 00 00 8B 4D 18 8B 51 1C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 0F 85 9B 00 00 00 E8 ?? ?? ?? ?? 8B 90 88 00 00 00 89 55 CC E8 ?? ?? ?? ?? 8B 80 8C 00 00 00 89 45 D0 E8 ?? ?? ?? ?? 8B 4D 08 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 55 10 89 90 8C 00 00 00 83 7D 24 00 75 0F 8B 45 08 50 8B 4D 0C 51 E8 ?? ?? ?? ?? EB 0D 8B 55 08 52 8B 45 24 50 E8 ?? ?? ?? ?? 6A FF 8B 4D 18 51 8B 55 14 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 18 8B 51 1C 52 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B 4D 08 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 55 10 89 90 8C 00 00 00 EB 40 8B 45 18 83 78 0C 00 76 37 0F B6 4D 1C 85 C9 75 2A 8B 55 24 52 8B 45 20 50 8B 4D FC 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 20 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 75 02 EB 05 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "??0bad_exception@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_62_59_1 {
	meta:
		name = "??0bad_alloc@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_8_0 {
	meta:
		name = "??0bad_cast@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_12_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABQBD@Z 001a ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8D 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_43_3_0 {
	meta:
		name = "??1bad_exception@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7bad_exception@std@@6B@ 0016 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_248_1 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 0016 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_271_1 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 0016 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_271_1 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 0016 ??1ios_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_237_1 {
	meta:
		name = "??1?$codecvt@DDH@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$codecvt@DDH@std@@6B@ 0016 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_220_1 {
	meta:
		name = "??1?$codecvt@GDH@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$codecvt@GDH@std@@6B@ 0016 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_220_1 {
	meta:
		name = "??1?$codecvt@_WDH@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$codecvt@_WDH@std@@6B@ 0016 ??1codecvt_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_179_1 {
	meta:
		name = "??1?$collate@D@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$collate@D@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_623_1 {
	meta:
		name = "??1?$collate@G@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$collate@G@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_592_1 {
	meta:
		name = "??1?$collate@_W@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$collate@_W@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_182_1 {
	meta:
		name = "??1?$messages@D@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$messages@D@std@@6B@ 0016 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_626_1 {
	meta:
		name = "??1?$messages@G@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$messages@G@std@@6B@ 0016 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_595_1 {
	meta:
		name = "??1?$messages@_W@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$messages@_W@std@@6B@ 0016 ??1messages_base@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_184_1 {
	meta:
		name = "??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_628_1 {
	meta:
		name = "??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_597_1 {
	meta:
		name = "??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_186_1 {
	meta:
		name = "??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_630_1 {
	meta:
		name = "??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_599_1 {
	meta:
		name = "??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_196_1 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@D$00@std@@6B@ 0016 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_188_1 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@D$0A@@std@@6B@ 0016 ??1?$_Mpunct@D@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_638_1 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@G$00@std@@6B@ 0016 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_632_1 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@G$0A@@std@@6B@ 0016 ??1?$_Mpunct@G@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_609_1 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@_W$00@std@@6B@ 0016 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_601_1 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$moneypunct@_W$0A@@std@@6B@ 0016 ??1?$_Mpunct@_W@std@@MAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_245_1 {
	meta:
		name = "??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_615_1 {
	meta:
		name = "??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_584_1 {
	meta:
		name = "??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_247_1 {
	meta:
		name = "??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_617_1 {
	meta:
		name = "??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_586_1 {
	meta:
		name = "??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 30
		refs = "000e ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_804_19_0 {
	meta:
		name = "??1__non_rtti_object@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7__non_rtti_object@std@@6B@ 0016 ??1bad_typeid@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_3_1 {
	meta:
		name = "??1bad_alloc@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7bad_alloc@std@@6B@ 0016 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_804_11_0 {
	meta:
		name = "??1bad_cast@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7bad_cast@std@@6B@ 0016 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_804_15_0 {
	meta:
		name = "??1bad_typeid@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7bad_typeid@std@@6B@ 0016 ??1exception@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_31_227_1 {
	meta:
		name = "??1codecvt_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7codecvt_base@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_323_1 {
	meta:
		name = "??1ctype_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7ctype_base@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_32_1 {
	meta:
		name = "??1failure@ios_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7failure@ios_base@std@@6B@ 0016 ??1runtime_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_10_1 {
	meta:
		name = "??1invalid_argument@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7invalid_argument@std@@6B@ 0016 ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_87_10_1 {
	meta:
		name = "??1length_error@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7length_error@std@@6B@ 0016 ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_79_1 {
	meta:
		name = "??1messages_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7messages_base@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_192_1 {
	meta:
		name = "??1money_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7money_base@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_10_1 {
	meta:
		name = "??1out_of_range@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7out_of_range@std@@6B@ 0016 ??1logic_error@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_21_373_1 {
	meta:
		name = "??1time_base@std@@UAE@XZ"
		size = 30
		refs = "000e ??_7time_base@std@@6B@ 0016 ??1facet@locale@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_4_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_exception@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_194_1 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Mpunct@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_636_1 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Mpunct@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_607_1 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$_Mpunct@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_50_73_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_75_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_75_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_251_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_277_1 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_277_1 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_50_72_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_74_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_74_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_50_236_1 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$codecvt@DDH@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_219_1 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$codecvt@GDH@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_219_1 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$codecvt@_WDH@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_178_1 {
	meta:
		name = "??_G?$collate@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$collate@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_622_1 {
	meta:
		name = "??_G?$collate@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$collate@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_591_1 {
	meta:
		name = "??_G?$collate@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$collate@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_31_314_1 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ctype@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_80_344_1 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ctype@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_344_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$ctype@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_181_1 {
	meta:
		name = "??_G?$messages@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$messages@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_625_1 {
	meta:
		name = "??_G?$messages@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$messages@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_594_1 {
	meta:
		name = "??_G?$messages@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$messages@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_183_1 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_627_1 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_596_1 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_185_1 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_629_1 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_598_1 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_195_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@D$00@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_187_1 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@D$0A@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_637_1 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@G$00@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_631_1 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@G$0A@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_608_1 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@_W$00@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_600_1 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$moneypunct@_W$0A@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_37_244_1 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_614_1 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_583_1 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_37_246_1 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_616_1 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_585_1 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_37_248_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$numpunct@D@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_618_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$numpunct@G@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_587_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$numpunct@_W@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_197_1 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_639_1 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_610_1 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_201_1 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_643_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_576_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_62_127_1 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1_Fac_node@std@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_62_33_1 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 46
		refs = "000d ??1_Locimp@locale@std@@MAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_17_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1__non_rtti_object@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_83_7_1 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_alloc@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_9_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_cast@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_56_3_1 {
	meta:
		name = "??_Gbad_function_call@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_function_call@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_13_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_typeid@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_3_1 {
	meta:
		name = "??_Gbad_weak_ptr@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1bad_weak_ptr@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_22_210_1 {
	meta:
		name = "??_Gcodecvt_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1codecvt_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_27_324_1 {
	meta:
		name = "??_Gctype_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ctype_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_1_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1exception@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_61_204_1 {
	meta:
		name = "??_Gfacet@locale@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1facet@locale@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_31_274_1 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1failure@ios_base@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_11_1 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1invalid_argument@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_60_273_1 {
	meta:
		name = "??_Gios_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1ios_base@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_11_1 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1length_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_61_244_1 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 46
		refs = "000d ??1locale@std@@QAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_54_8_1 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1logic_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_308_1 {
	meta:
		name = "??_Gmessages_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1messages_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_193_1 {
	meta:
		name = "??_Gmoney_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1money_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_21_1 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1out_of_range@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_65_19_1 {
	meta:
		name = "??_Gregex_error@tr1@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1regex_error@tr1@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_68_27_1 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1runtime_error@std@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_374_1 {
	meta:
		name = "??_Gtime_base@std@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1time_base@std@@UAE@XZ 001e ??3facet@locale@std@@SAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_416_2_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 46
		refs = "000d ??1type_info@@UAE@XZ 001e ??3@YAXPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B 45 08 83 E0 01 74 0C 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_43_5_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_18_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0bad_typeid@std@@QAE@ABV01@@Z 001a ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_16_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 39
		refs = "0011 ??0bad_typeid@std@@QAE@PBD@Z 001a ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_23_7_1 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_10_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_56_5_1 {
	meta:
		name = "??0bad_function_call@tr1@std@@QAE@ABV012@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_function_call@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_804_14_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_88_5_1 {
	meta:
		name = "??0bad_weak_ptr@tr1@std@@QAE@ABV012@@Z"
		size = 39
		refs = "0011 ??0exception@std@@QAE@ABV01@@Z 001a ??_7bad_weak_ptr@tr1@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_202_1 {
	meta:
		name = "??0codecvt_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_8_322_1 {
	meta:
		name = "??0ctype_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_61_298_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 39
		refs = "0011 ??0runtime_error@std@@QAE@ABV01@@Z 001a ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_9_269_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z"
		size = 39
		refs = "0011 ??0runtime_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 001a ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_12_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV01@@Z 001a ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_71_3_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 001a ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_15_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV01@@Z 001a ??_7length_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_3_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 001a ??_7length_error@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_306_1 {
	meta:
		name = "??0messages_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7messages_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_21_808_1 {
	meta:
		name = "??0money_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7money_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_54_12_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV01@@Z 001a ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_87_19_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 39
		refs = "0011 ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 001a ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_143_1 {
	meta:
		name = "??0time_base@std@@QAE@I@Z"
		size = 39
		refs = "0011 ??0facet@locale@std@@IAE@I@Z 001a ??_7time_base@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 08 50 8B 4D FC E8 ?? ?? ?? ?? 8B 4D FC C7 01 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_43_6_0 {
	meta:
		name = "?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
		size = 374
		refs = "001a __getptd 002f __encoded_null 0063 ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z 007f ?_inconsistency@@YAXXZ 0098 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 0165 ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 8B 45 08 81 38 03 00 00 80 75 05 E9 58 01 00 00 E8 ?? ?? ?? ?? 83 B8 80 00 00 00 00 74 4C E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 39 86 80 00 00 00 74 38 8B 4D 08 81 39 4D 4F 43 E0 74 2D 8B 55 24 52 8B 45 20 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 05 E9 FE 00 00 00 8B 45 18 83 78 0C 00 74 02 EB 05 E8 ?? ?? ?? ?? 8D 4D F4 51 8D 55 F8 52 8B 45 1C 50 8B 4D 20 51 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC EB 12 8B 45 F8 83 C0 01 89 45 F8 8B 4D FC 83 C1 14 89 4D FC 8B 55 F8 3B 55 F4 0F 83 AF 00 00 00 8B 45 FC 8B 4D 1C 3B 08 7C 5C 8B 55 FC 8B 45 1C 3B 42 04 7F 51 8B 4D FC 8B 51 0C 83 EA 01 C1 E2 04 8B 45 FC 8B 48 10 83 7C 11 04 00 74 1E 8B 55 FC 8B 42 0C 83 E8 01 C1 E0 04 8B 4D FC 8B 51 10 8B 44 02 04 0F BE 48 08 85 C9 75 1A 8B 55 FC 8B 42 0C 83 E8 01 C1 E0 04 8B 4D FC 8B 51 10 8B 04 02 83 E0 40 74 05 E9 77 FF FF FF 6A 01 8B 4D 24 51 8B 55 20 52 8B 45 FC 50 6A 00 8B 4D FC 8B 51 0C 83 EA 01 C1 E2 04 8B 45 FC 03 50 10 52 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 2C E9 33 FF FF FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_7_0 {
	meta:
		name = "___TypeMatch"
		size = 172
		refs = "004a _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 83 78 04 00 74 0E 8B 4D 08 8B 51 04 0F BE 42 08 85 C0 75 0A B8 01 00 00 00 E9 81 00 00 00 8B 4D 08 8B 55 0C 8B 41 04 3B 42 04 74 24 8B 4D 0C 8B 51 04 83 C2 08 52 8B 45 08 8B 48 04 83 C1 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 04 33 C0 EB 4F 8B 55 0C 8B 02 83 E0 02 74 0A 8B 4D 08 8B 11 83 E2 08 74 31 8B 45 10 8B 08 83 E1 01 74 0A 8B 55 08 8B 02 83 E0 01 74 1D 8B 4D 10 8B 11 83 E2 02 74 0A 8B 45 08 8B 08 83 E1 02 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_8_0 {
	meta:
		name = "___FrameUnwindFilter"
		size = 114
		refs = "002d __getptd 003c ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 08 8B 08 89 4D FC 8B 55 FC 8B 02 89 45 F8 81 7D F8 4D 4F 43 E0 74 1F 81 7D F8 63 73 6D E0 74 02 EB 40 E8 ?? ?? ?? ?? C7 80 90 00 00 00 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7E 1A E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 F4 8B 4D F4 8B 11 83 EA 01 8B 45 F4 89 10 33 C0 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_9_0 {
	meta:
		name = "___FrameUnwindToState"
		size = 384
		refs = "0008 __sehtable$___FrameUnwindToState 000d __except_handler4 001f ___security_cookie 0065 __getptd 00a5 ?_inconsistency@@YAXXZ 00f0 __CallSettingFrame@12 0102 ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 45 10 81 78 04 80 00 00 00 7F 14 8B 4D 08 8B 51 08 81 E2 FF 00 00 00 0F BE C2 89 45 DC EB 09 8B 4D 08 8B 51 08 89 55 DC 8B 45 DC 89 45 E4 E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 D8 8B 4D D8 8B 11 83 C2 01 8B 45 D8 89 10 C7 45 FC 00 00 00 00 8B 4D E4 3B 4D 14 0F 84 8E 00 00 00 83 7D E4 FF 7E 0D 8B 55 10 8B 45 E4 3B 42 04 7D 02 EB 05 E8 ?? ?? ?? ?? 8B 4D 10 8B 51 08 8B 45 E4 8B 0C C2 89 4D E0 C7 45 FC 01 00 00 00 8B 55 10 8B 42 08 8B 4D E4 83 7C C8 04 00 74 25 8B 55 08 8B 45 E0 89 42 08 68 03 01 00 00 8B 4D 08 51 8B 55 10 8B 42 08 8B 4D E4 8B 54 C8 04 52 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 EB 17 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC 00 00 00 00 8B 4D E0 89 4D E4 E9 66 FF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 29 E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7E 1A E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 D4 8B 55 D4 8B 02 83 E8 01 8B 4D D4 89 01 C3 8B 55 E4 3B 55 14 75 02 EB 05 E8 ?? ?? ?? ?? 8B 45 08 8B 4D E4 89 48 08 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_10_0 {
	meta:
		name = "?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
		size = 185
		refs = "0025 ___BuildCatchObject 003b ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0061 ___FrameUnwindToState 0098 ?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 00b1 ?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 89 45 FC 83 7D 20 00 74 18 8B 4D 20 51 8B 55 1C 52 8B 45 FC 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 83 7D 2C 00 75 0F 8B 55 08 52 8B 45 0C 50 E8 ?? ?? ?? ?? EB 0D 8B 4D 08 51 8B 55 2C 52 E8 ?? ?? ?? ?? 8B 45 24 8B 08 51 8B 55 18 52 8B 45 14 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 24 8B 42 04 83 C0 01 8B 4D 0C 89 41 08 68 00 01 00 00 8B 55 28 52 8B 45 1C 8B 48 0C 51 8B 55 18 52 8B 45 10 50 8B 4D FC 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 F8 83 7D F8 00 74 0D 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_11_0 {
	meta:
		name = "?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 646
		refs = "0008 __sehtable$?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 000d __except_handler4 001f ___security_cookie 0057 __CreateFrameInfo 0062 __getptd 00c3 ?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z 00de ?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z 01ab ___FrameUnwindToState 01e6 __FindAndUnlinkFrame 0255 __IsExceptionObjectToBeDestroyed 0269 ___DestructExceptionObject"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 C0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 45 18 89 45 D0 C7 45 DC 00 00 00 00 8B 4D 0C 8B 51 FC 89 55 E0 8B 45 08 8B 48 18 51 8D 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 C8 E8 ?? ?? ?? ?? 8B 88 8C 00 00 00 89 4D CC E8 ?? ?? ?? ?? 8B 55 08 89 90 88 00 00 00 E8 ?? ?? ?? ?? 8B 4D 10 89 88 8C 00 00 00 C7 45 FC 00 00 00 00 C7 45 B4 01 00 00 00 C7 45 FC 01 00 00 00 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 D0 C7 45 FC 00 00 00 00 E9 E7 00 00 00 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 80 0C 02 00 00 00 00 00 00 8B 55 14 8B 42 08 89 45 B8 8B 4D 14 81 79 04 80 00 00 00 7F 13 8B 55 0C 8B 42 08 25 FF 00 00 00 0F BE C8 89 4D B0 EB 09 8B 55 0C 8B 42 08 89 45 B0 8B 4D B0 89 4D BC 8B 55 14 8B 42 10 89 45 C0 C7 45 C4 00 00 00 00 EB 09 8B 4D C4 83 C1 01 89 4D C4 8B 55 14 8B 45 C4 3B 42 0C 73 47 8B 4D C4 6B C9 14 8B 55 C0 8B 45 BC 3B 44 0A 04 7E 33 8B 4D C4 6B C9 14 8B 55 C0 8B 45 BC 3B 44 0A 08 7F 21 8B 4D C4 6B C9 14 8B 55 C0 8B 44 0A 04 83 C0 01 89 45 BC 8B 4D BC 8B 55 B8 8B 04 CA 89 45 BC EB 02 EB A5 8B 4D BC 51 8B 55 14 52 6A 00 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 10 C7 45 D0 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 FC FE FF FF FF C7 45 B4 00 00 00 00 E8 05 00 00 00 E9 99 00 00 00 8B 4D 0C 8B 55 E0 89 51 FC 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B 4D C8 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 55 CC 89 90 8C 00 00 00 8B 45 08 81 38 63 73 6D E0 75 5C 8B 4D 08 83 79 10 03 75 53 8B 55 08 81 7A 14 20 05 93 19 74 18 8B 45 08 81 78 14 21 05 93 19 74 0C 8B 4D 08 81 79 14 22 05 93 19 75 2F 83 7D DC 00 75 29 83 7D D0 00 74 23 8B 55 08 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 10 8B 4D B4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 45 D0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_12_0 {
	meta:
		name = "?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 109
		refs = "0050 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 8B 08 89 4D FC 8B 55 FC 81 3A 63 73 6D E0 75 4E 8B 45 FC 83 78 10 03 75 45 8B 4D FC 81 79 14 20 05 93 19 74 18 8B 55 FC 81 7A 14 21 05 93 19 74 0C 8B 45 FC 81 78 14 22 05 93 19 75 21 8B 4D FC 83 79 1C 00 75 18 E8 ?? ?? ?? ?? C7 80 0C 02 00 00 01 00 00 00 B8 01 00 00 00 EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_13_0 {
	meta:
		name = "___BuildCatchObjectHelper"
		size = 624
		refs = "0008 __sehtable$___BuildCatchObjectHelper 000d __except_handler4 001f ___security_cookie 00af ?_ValidateRead@@YAHPBXI@Z 00c1 ?_ValidateWrite@@YAHPAXI@Z 00e5 ___AdjustPointer 00f4 ?_inconsistency@@YAXXZ 0141 _memmove 0211 ?_ValidateExecute@@YAHP6GHXZ@Z 0250 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 E4 00 00 00 00 8B 45 10 83 78 04 00 74 23 8B 4D 10 8B 51 04 0F BE 42 08 85 C0 74 15 8B 4D 10 83 79 08 00 75 13 8B 55 10 8B 02 25 00 00 00 80 75 07 33 C0 E9 EF 01 00 00 8B 4D 10 8B 11 81 E2 00 00 00 80 74 08 8B 45 0C 89 45 E0 EB 10 8B 4D 10 8B 51 08 8B 45 0C 8D 4C 10 0C 89 4D E0 C7 45 FC 00 00 00 00 8B 55 10 8B 02 83 E0 08 74 58 6A 01 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 39 6A 01 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 27 8B 4D E0 8B 55 08 8B 42 18 89 01 8B 4D 14 83 C1 08 51 8B 55 E0 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D E0 89 01 EB 05 E8 ?? ?? ?? ?? E9 40 01 00 00 8B 55 14 8B 02 83 E0 01 74 78 6A 01 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 59 6A 01 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 47 8B 4D 14 8B 51 14 52 8B 45 08 8B 48 18 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 14 83 78 14 04 75 22 8B 4D E0 83 39 00 74 1A 8B 55 14 83 C2 08 52 8B 45 E0 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 E0 89 02 EB 05 E8 ?? ?? ?? ?? E9 BE 00 00 00 8B 45 14 83 78 18 00 75 5A 6A 01 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 3E 6A 01 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 2C 8B 4D 14 8B 51 14 52 8B 45 14 83 C0 08 50 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 50 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C EB 05 E8 ?? ?? ?? ?? EB 5B 6A 01 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 41 6A 01 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 2F 8B 4D 14 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 1C 8B 45 14 8B 08 83 E1 04 74 09 C7 45 E4 02 00 00 00 EB 07 C7 45 E4 01 00 00 00 EB 05 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 15 B8 01 00 00 00 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_14_0 {
	meta:
		name = "___BuildCatchObject"
		size = 268
		refs = "0008 __sehtable$___BuildCatchObject 000d __except_handler4 001f ___security_cookie 0072 ___BuildCatchObjectHelper 0099 ___AdjustPointer 00ad ?_CallMemberFunction1@@YGXPAX00@Z 00d8 ?_CallMemberFunction2@@YGXPAX00H@Z 00ef ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 45 10 8B 08 81 E1 00 00 00 80 74 08 8B 55 0C 89 55 E4 EB 10 8B 45 10 8B 48 08 8B 55 0C 8D 44 0A 0C 89 45 E4 C7 45 FC 00 00 00 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 01 74 08 83 7D E0 02 74 2B EB 52 8B 55 14 83 C2 08 52 8B 45 08 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 55 14 8B 42 18 50 8B 4D E4 51 E8 ?? ?? ?? ?? EB 29 6A 01 8B 55 14 83 C2 08 52 8B 45 08 8B 48 18 51 E8 ?? ?? ?? ?? 83 C4 08 50 8B 55 14 8B 42 18 50 8B 4D E4 51 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 15 B8 01 00 00 00 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_15_0 {
	meta:
		name = "___DestructExceptionObject"
		size = 175
		refs = "0008 __sehtable$___DestructExceptionObject 000d __except_handler4 001f ___security_cookie 0076 ?_CallMemberFunction0@@YGXPAX0@Z 0092 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 83 7D 08 00 74 0B 8B 45 08 81 38 63 73 6D E0 74 02 EB 55 8B 4D 08 83 79 1C 00 74 4C 8B 55 08 8B 42 1C 83 78 04 00 74 40 C7 45 FC 00 00 00 00 8B 4D 08 8B 51 1C 8B 42 04 50 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 1A 0F B6 45 0C F7 D8 1B C0 F7 D8 C3 8B 65 E8 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_16_0 {
	meta:
		name = "___AdjustPointer"
		size = 72
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 8B 4D 08 03 08 89 4D FC 8B 55 0C 83 7A 04 00 7C 27 8B 45 0C 8B 48 04 8B 55 08 8B 04 0A 8B 4D 0C 8B 51 08 8B 4D FC 03 0C 10 89 4D FC 8B 55 0C 8B 45 FC 03 42 04 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_17_0 {
	meta:
		name = "?__uncaught_exception@@YA_NXZ"
		size = 26
		refs = "0006 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 33 C9 83 B8 90 00 00 00 00 0F 95 C1 8A C1 5D C3 }
	condition:
		$1
}

rule file_43_18_0 {
	meta:
		name = "___CxxExceptionFilter"
		size = 487
		refs = "0087 __getptd 0195 ___TypeMatch 01d1 ___BuildCatchObject"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 83 7D 08 00 75 07 33 C0 E9 CE 01 00 00 8B 45 08 8B 08 89 4D F8 83 7D 0C 00 74 0F 8B 55 0C 0F BE 42 08 85 C0 0F 85 8D 00 00 00 8B 4D F8 81 39 4D 4F 43 E0 74 08 8B 55 10 83 E2 40 75 7A 8B 45 F8 81 38 63 73 6D E0 75 4B 8B 4D F8 83 79 10 03 75 42 8B 55 F8 81 7A 14 20 05 93 19 74 18 8B 45 F8 81 78 14 21 05 93 19 74 0C 8B 4D F8 81 79 14 22 05 93 19 75 1E 8B 55 F8 83 7A 1C 00 75 15 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 75 07 33 C0 E9 48 01 00 00 E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 DC 8B 45 DC 8B 08 83 C1 01 8B 55 DC 89 0A B8 01 00 00 00 E9 24 01 00 00 8B 45 F8 81 38 63 73 6D E0 0F 85 13 01 00 00 8B 4D F8 83 79 10 03 0F 85 06 01 00 00 8B 55 F8 81 7A 14 20 05 93 19 74 1C 8B 45 F8 81 78 14 21 05 93 19 74 10 8B 4D F8 81 79 14 22 05 93 19 0F 85 DE 00 00 00 8B 55 F8 83 7A 1C 00 75 23 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 75 07 33 C0 E9 C2 00 00 00 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 F8 8B 4D 0C 89 4D E4 8B 55 10 89 55 E0 8B 45 E0 0D 00 00 00 80 89 45 E0 8B 4D F8 8B 51 1C 8B 42 0C 83 C0 04 89 45 F4 8B 4D F8 8B 51 1C 8B 42 0C 8B 08 89 4D FC EB 12 8B 55 FC 83 EA 01 89 55 FC 8B 45 F4 83 C0 04 89 45 F4 83 7D FC 00 7E 64 8B 4D F4 8B 11 89 55 F0 8B 45 F8 8B 48 1C 51 8B 55 F0 52 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 3F E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 D8 8B 4D D8 8B 11 83 C2 01 8B 45 D8 89 10 83 7D 14 00 74 18 8B 4D F0 51 8D 55 E0 52 8B 45 14 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 10 B8 01 00 00 00 EB 04 EB 84 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_19_0 {
	meta:
		name = "___CxxRegisterExceptionObject"
		size = 300
		refs = "0087 __getptd 00a0 __CreateFrameInfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 C7 45 F0 00 00 00 00 8B 45 0C 89 45 FC 8B 4D FC 83 C1 08 89 4D F4 8B 55 F4 83 C2 04 89 55 F8 83 7D 08 00 0F 84 A9 00 00 00 8B 45 08 83 38 00 0F 84 9D 00 00 00 8B 4D 08 8B 11 89 55 F0 8B 45 F0 81 38 63 73 6D E0 75 44 8B 4D F0 83 79 10 03 75 3B 8B 55 F0 81 7A 14 20 05 93 19 74 18 8B 45 F0 81 78 14 21 05 93 19 74 0C 8B 4D F0 81 79 14 22 05 93 19 75 17 8B 55 F0 83 7A 1C 00 75 0E E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 F0 8B 4D F0 8B 51 18 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC E8 ?? ?? ?? ?? 8B 4D F4 8B 90 88 00 00 00 89 11 E8 ?? ?? ?? ?? 8B 4D F8 8B 90 8C 00 00 00 89 11 E8 ?? ?? ?? ?? 8B 4D F0 89 88 88 00 00 00 EB 12 8B 55 F4 C7 02 FF FF FF FF 8B 45 F8 C7 00 FF FF FF FF E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 EC 8B 4D EC 8B 11 83 EA 01 8B 45 EC 89 10 E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7D 0F E8 ?? ?? ?? ?? C7 80 90 00 00 00 00 00 00 00 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_20_0 {
	meta:
		name = "___CxxDetectRethrow"
		size = 130
		refs = "005c __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 75 04 33 C0 EB 6C 8B 45 08 8B 08 89 4D FC 8B 55 FC 81 3A 63 73 6D E0 75 57 8B 45 FC 83 78 10 03 75 4E 8B 4D FC 81 79 14 20 05 93 19 74 18 8B 55 FC 81 7A 14 21 05 93 19 74 0C 8B 45 FC 81 78 14 22 05 93 19 75 2A 8B 4D FC 83 79 1C 00 75 21 E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 F8 8B 55 F8 8B 02 83 C0 01 8B 4D F8 89 01 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_21_0 {
	meta:
		name = "___CxxUnregisterExceptionObject"
		size = 375
		refs = "0031 __FindAndUnlinkFrame 0043 __getptd 00b2 __IsExceptionObjectToBeDestroyed 00cc ___DestructExceptionObject"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 89 45 FC 8B 4D FC 83 C1 08 89 4D F4 8B 55 F4 83 C2 04 89 55 F8 8B 45 F4 83 38 FF 0F 84 47 01 00 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 7D 0C 00 0F 85 91 00 00 00 E8 ?? ?? ?? ?? 8B 90 88 00 00 00 81 3A 63 73 6D E0 75 7E E8 ?? ?? ?? ?? 8B 80 88 00 00 00 83 78 10 03 75 6D E8 ?? ?? ?? ?? 8B 88 88 00 00 00 81 79 14 20 05 93 19 74 28 E8 ?? ?? ?? ?? 8B 90 88 00 00 00 81 7A 14 21 05 93 19 74 14 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 22 05 93 19 75 31 E8 ?? ?? ?? ?? 8B 88 88 00 00 00 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 16 6A 01 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 E8 ?? ?? ?? ?? 8B 88 88 00 00 00 81 39 63 73 6D E0 75 6D E8 ?? ?? ?? ?? 8B 90 88 00 00 00 83 7A 10 03 75 5C E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 20 05 93 19 74 28 E8 ?? ?? ?? ?? 8B 88 88 00 00 00 81 79 14 21 05 93 19 74 14 E8 ?? ?? ?? ?? 8B 90 88 00 00 00 81 7A 14 22 05 93 19 75 20 83 7D 0C 00 74 1A E8 ?? ?? ?? ?? 05 90 00 00 00 89 45 F0 8B 45 F0 8B 08 83 E9 01 8B 55 F0 89 0A E8 ?? ?? ?? ?? 8B 4D F4 8B 11 89 90 88 00 00 00 E8 ?? ?? ?? ?? 8B 4D F8 8B 11 89 90 8C 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_23_0 {
	meta:
		name = "___CxxCallUnwindDtor"
		size = 116
		refs = "0008 __sehtable$___CxxCallUnwindDtor 000d __except_handler4 001f ___security_cookie 0050 ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 4D 0C FF 55 08 C7 45 FC FE FF FF FF EB 17 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_24_0 {
	meta:
		name = "___CxxCallUnwindDelDtor"
		size = 120
		refs = "0008 __sehtable$___CxxCallUnwindDelDtor 000d __except_handler4 001f ___security_cookie 0054 ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 0C 50 FF 55 08 83 C4 04 C7 45 FC FE FF FF FF EB 17 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_25_0 {
	meta:
		name = "___CxxCallUnwindStdDelDtor"
		size = 117
		refs = "0008 __sehtable$___CxxCallUnwindStdDelDtor 000d __except_handler4 001f ___security_cookie 0051 ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 0C 50 FF 55 08 C7 45 FC FE FF FF FF EB 17 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_26_0 {
	meta:
		name = "___CxxCallUnwindVecDtor"
		size = 129
		refs = "0008 __sehtable$___CxxCallUnwindVecDtor 000d __except_handler4 001f ___security_cookie 005d ___FrameUnwindFilter"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 FF 55 08 C7 45 FC FE FF FF FF EB 17 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_27_0 {
	meta:
		name = "?IsInExceptionSpec@@YAEPAUEHExceptionRecord@@PBU_s_ESTypeList@@@Z"
		size = 180
		refs = "0011 ?_inconsistency@@YAXXZ 001c ?terminate@@YAXXZ 0098 ___TypeMatch"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 0C 00 74 02 EB 05 E8 ?? ?? ?? ?? 83 7D 0C 00 75 05 E8 ?? ?? ?? ?? C6 45 F3 00 C7 45 EC 00 00 00 00 EB 09 8B 45 EC 83 C0 01 89 45 EC 8B 4D 0C 8B 55 EC 3B 11 7D 6D 8B 45 08 8B 48 1C 8B 51 0C 83 C2 04 89 55 F8 8B 45 08 8B 48 1C 8B 51 0C 8B 02 89 45 FC EB 12 8B 4D FC 83 E9 01 89 4D FC 8B 55 F8 83 C2 04 89 55 F8 83 7D FC 00 7E 34 8B 45 F8 8B 08 89 4D F4 8B 55 08 8B 42 1C 50 8B 4D F4 51 8B 55 EC C1 E2 04 8B 45 0C 03 50 04 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 06 C6 45 F3 01 EB 02 EB B4 EB 80 8A 45 F3 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_28_0 {
	meta:
		name = "?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 78
		refs = "0008 __ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0018 ___security_cookie 002c __getptd 003c ?_inconsistency@@YAXXZ 0048 ?unexpected@@YAXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 53 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 65 F0 E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 75 02 EB 05 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? EB 24 }
	condition:
		$1
}

rule file_43_29_0 {
	meta:
		name = "__catch$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z$0"
		size = 66
		refs = "0001 __getptd 0013 __CxxThrowException@8 001f __tryend$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z$1 002c ?terminate@@YAXXZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 4D 08 89 88 94 00 00 00 6A 00 6A 00 E8 ?? ?? ?? ?? C7 45 FC FF FF FF FF B8 ?? ?? ?? ?? C3 C7 45 FC FF FF FF FF E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_30_0 {
	meta:
		name = "__ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_62_4_1 {
	meta:
		name = "__ehhandler$?facet_Register@facet@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?facet_Register@facet@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_31_0 {
	meta:
		name = "?Is_bad_exception_allowed@@YAEPBU_s_ESTypeList@@@Z"
		size = 79
		refs = "0023 ??_R0?AVbad_exception@std@@@8 0038 ??8type_info@@QBE_NABV0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8B 55 FC 3B 11 7D 27 68 ?? ?? ?? ?? 8B 45 FC C1 E0 04 8B 4D 08 8B 51 04 8B 4C 02 04 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 04 B0 01 EB 04 EB C6 32 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_32_0 {
	meta:
		name = "?_is_exception_typeof@@YAHABVtype_info@@PAU_EXCEPTION_POINTERS@@@Z"
		size = 214
		refs = "0011 ?_inconsistency@@YAXXZ 00b6 ?raw_name@type_info@@QBEPBDXZ 00bc _strcmp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 0C 00 74 02 EB 05 E8 ?? ?? ?? ?? 8B 45 0C 8B 08 89 4D F4 83 7D F4 00 74 02 EB 05 E8 ?? ?? ?? ?? 8B 55 F4 81 3A 63 73 6D E0 75 2F 8B 45 F4 83 78 10 03 75 26 8B 4D F4 81 79 14 20 05 93 19 74 18 8B 55 F4 81 7A 14 21 05 93 19 74 0C 8B 45 F4 81 78 14 22 05 93 19 75 02 EB 05 E8 ?? ?? ?? ?? 8B 4D F4 8B 51 1C 8B 42 0C 83 C0 04 89 45 F8 8B 4D F4 8B 51 1C 8B 42 0C 8B 08 89 4D FC EB 12 8B 55 FC 83 EA 01 89 55 FC 8B 45 F8 83 C0 04 89 45 F8 83 7D FC 00 7E 30 8B 4D F8 8B 11 89 55 F0 8B 45 F0 8B 48 04 83 C1 08 51 8B 4D 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 07 B8 01 00 00 00 EB 04 EB B8 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "___clean_type_info_names"
		size = 20
		refs = "0006 ?__type_info_root_node@@3U__type_info_node@@A 000b ___clean_type_info_names_internal"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_23_14_1 {
	meta:
		name = "??__Einit_atexit@@YAXXZ"
		size = 20
		refs = "0006 ??__Finit_atexit@@YAXXZ 000b _atexit"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_10_7_1 {
	meta:
		name = "?_Lockit_ctor@_Lockit@std@@CAXPAV12@@Z"
		size = 20
		refs = "0006 _mtx 000b __Mtxlock"
	strings:
		$1 = { 8B FF 55 8B EC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__wstat64"
		size = 1516
		refs = "000c ___security_cookie 002f ??_C@_1BO@PCMLKEJK@?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0038 ??_C@_1GA@FGGLPCAO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003f __CrtDbgReportW 0056 ___doserrno 0061 __errno 0075 ??_C@_1BC@NCDNKELJ@?$AA_?$AAw?$AAs?$AAt?$AAa?$AAt?$AA6?$AA4?$AA?$AA@ 007f __invalid_parameter 00a7 ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0107 ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0110 _wcspbrk 0180 _towlower 0196 __getdrive 01ad __imp__FindFirstFileW@8 01cf ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 01fb __wfullpath_helper 0219 _wcslen 022d _IsRootUNCName 0241 __imp__GetDriveTypeW@4 025b _free 02d1 ___loctotime64_t 0330 __imp__FileTimeToLocalFileTime@8 0348 __imp__FileTimeToSystemTime@8 0352 __imp__GetLastError@0 0358 __dosmaperr 0368 __imp__FindClose@4 0565 ___wdtoxmode 058e __allmul 05e4 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 90 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 C0 83 7D 08 00 0F 95 C0 89 85 90 FB FF FF 83 BD 90 FB FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 90 FB FF FF 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 4F 05 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 8C FB FF FF 83 BD 8C FB FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 8C FB FF FF 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D7 04 00 00 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 A4 04 00 00 8B 55 08 0F B7 42 02 83 F8 3A 75 50 8B 4D 08 0F B7 11 85 D2 74 29 8B 45 08 0F B7 48 04 85 C9 75 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 65 04 00 00 8B 55 08 0F B7 02 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 83 E9 60 89 8D 98 FB FF FF EB 0B E8 ?? ?? ?? ?? 89 85 98 FB FF FF 8D 95 A0 FB FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 85 9C FB FF FF 83 BD 9C FB FF FF FF 0F 85 46 01 00 00 C7 85 88 FB FF FF 00 00 00 00 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 67 8D 95 88 FB FF FF 52 68 04 01 00 00 8B 45 08 50 8D 8D F0 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 89 85 94 FB FF FF 83 BD 94 FB FF FF 00 74 39 8B 95 94 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 03 74 13 8B 85 94 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 8D 94 FB FF FF 51 FF 15 ?? ?? ?? ?? 83 F8 01 77 36 83 BD 88 FB FF FF 00 74 0F 8B 95 88 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 5D 03 00 00 83 BD 88 FB FF FF 00 74 0F 8B 85 88 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 C7 85 A0 FB FF FF 10 00 00 00 C7 85 BC FB FF FF 00 00 00 00 C7 85 C0 FB FF FF 00 00 00 00 33 C9 66 89 8D CC FB FF FF 6A FF 6A 00 6A 00 6A 00 6A 01 6A 01 68 BC 07 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 28 89 51 2C 8B 55 0C 8B 45 0C 8B 48 28 89 4A 20 8B 40 2C 89 42 24 8B 4D 0C 8B 55 0C 8B 42 28 89 41 30 8B 52 2C 89 51 34 E9 4F 02 00 00 83 BD B4 FB FF FF 00 75 0D 83 BD B8 FB FF FF 00 0F 84 99 00 00 00 8D 85 80 FB FF FF 50 8D 8D B4 FB FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 70 FB FF FF 52 8D 85 80 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 9C FB FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 69 02 00 00 6A FF 0F B7 95 7C FB FF FF 52 0F B7 85 7A FB FF FF 50 0F B7 8D 78 FB FF FF 51 0F B7 95 76 FB FF FF 52 0F B7 85 72 FB FF FF 50 0F B7 8D 70 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 28 89 51 2C EB 11 8B 55 0C C7 42 28 00 00 00 00 C7 42 2C 00 00 00 00 83 BD AC FB FF FF 00 75 0D 83 BD B0 FB FF FF 00 0F 84 99 00 00 00 8D 85 80 FB FF FF 50 8D 8D AC FB FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 70 FB FF FF 52 8D 85 80 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 9C FB FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 A9 01 00 00 6A FF 0F B7 95 7C FB FF FF 52 0F B7 85 7A FB FF FF 50 0F B7 8D 78 FB FF FF 51 0F B7 95 76 FB FF FF 52 0F B7 85 72 FB FF FF 50 0F B7 8D 70 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 20 89 51 24 EB 12 8B 55 0C 8B 45 0C 8B 48 28 89 4A 20 8B 40 2C 89 42 24 83 BD A4 FB FF FF 00 75 0D 83 BD A8 FB FF FF 00 0F 84 99 00 00 00 8D 8D 80 FB FF FF 51 8D 95 A4 FB FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 85 70 FB FF FF 50 8D 8D 80 FB FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 95 9C FB FF FF 52 FF 15 ?? ?? ?? ?? 83 C8 FF E9 E8 00 00 00 6A FF 0F B7 85 7C FB FF FF 50 0F B7 8D 7A FB FF FF 51 0F B7 95 78 FB FF FF 52 0F B7 85 76 FB FF FF 50 0F B7 8D 72 FB FF FF 51 0F B7 95 70 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 30 89 51 34 EB 12 8B 55 0C 8B 45 0C 8B 48 28 89 4A 30 8B 40 2C 89 42 34 8B 8D 9C FB FF FF 51 FF 15 ?? ?? ?? ?? 8B 55 08 52 8B 85 A0 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 66 89 41 06 BA 01 00 00 00 8B 45 0C 66 89 50 08 8B 8D BC FB FF FF 33 D2 6A 01 6A 00 52 51 E8 ?? ?? ?? ?? 8B 8D C0 FB FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 18 89 51 1C 33 D2 8B 45 0C 66 89 50 04 33 C9 8B 55 0C 66 89 4A 0C 33 C0 8B 4D 0C 66 89 41 0A 8B 95 98 FB FF FF 83 EA 01 8B 45 0C 89 10 8B 4D 0C 8B 55 0C 8B 02 89 41 10 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 267
		refs = "000b _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 05 0F 82 EA 00 00 00 8B 4D 08 0F B7 11 83 FA 5C 74 0F 8B 45 08 0F B7 08 83 F9 2F 0F 85 D0 00 00 00 8B 55 08 0F B7 42 02 83 F8 5C 74 10 8B 4D 08 0F B7 51 02 83 FA 2F 0F 85 B4 00 00 00 8B 45 08 0F B7 48 04 83 F9 5C 0F 84 A4 00 00 00 8B 55 08 0F B7 42 04 83 F8 2F 0F 84 94 00 00 00 8B 4D 08 83 C1 04 89 4D FC 8B 55 FC 83 C2 02 89 55 FC 8B 45 FC 0F B7 08 85 C9 74 1A 8B 55 FC 0F B7 02 83 F8 5C 74 0B 8B 4D FC 0F B7 11 83 FA 2F 75 02 EB 02 EB D3 8B 45 FC 0F B7 08 85 C9 74 54 8B 55 FC 0F B7 42 02 85 C0 74 49 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 0F B7 02 85 C0 74 1A 8B 4D FC 0F B7 11 83 FA 5C 74 0B 8B 45 FC 0F B7 08 83 F9 2F 75 02 EB 02 EB D3 8B 55 FC 0F B7 02 85 C0 74 0B 8B 4D FC 0F B7 51 02 85 D2 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_2_0 {
	meta:
		name = "__wfullpath_helper"
		size = 127
		refs = "0009 __errno 002a __wfullpath"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8B 00 89 45 F8 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 0F E8 ?? ?? ?? ?? 8B 4D F8 89 08 8B 45 FC EB 32 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 24 E8 ?? ?? ?? ?? 8B 55 F8 89 10 6A 00 8B 45 0C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 89 01 8B 55 14 8B 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_145_2_0 {
	meta:
		name = "__fullpath_helper"
		size = 127
		refs = "0009 __errno 002a __fullpath"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8B 00 89 45 F8 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 74 0F E8 ?? ?? ?? ?? 8B 4D F8 89 08 8B 45 FC EB 32 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 EB 24 E8 ?? ?? ?? ?? 8B 55 F8 89 10 6A 00 8B 45 0C 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 14 89 01 8B 55 14 8B 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__chsize_s"
		size = 666
		refs = "0008 __sehtable$__chsize_s 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0058 __nhandle 007b ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 0084 ??_C@_1GA@DBKMEDOF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 008b __CrtDbgReportW 00aa __errno 00be ??_C@_1BE@MAFDNGED@?$AA_?$AAc?$AAh?$AAs?$AAi?$AAz?$AAe?$AA_?$AAs?$AA?$AA@ 00c8 __invalid_parameter 00eb ___pioinfo 0103 ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 018c ??_C@_1BI@GALBKMKE@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 01ef ___lock_fhandle 022a __chsize_nolock 023b ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 027d __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 15 E8 ?? ?? ?? ?? C7 00 00 00 00 00 B8 09 00 00 00 E9 3B 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 09 00 00 00 E9 AF 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 09 00 00 00 E9 27 01 00 00 83 7D 10 00 7C 11 7F 06 83 7D 0C 00 72 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D0 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 3B E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 9E 00 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 01 74 19 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 34 33 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 42 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 E4 09 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "__chsize_nolock"
		size = 657
		refs = "0029 __lseeki64_nolock 0065 __errno 00a1 __imp__GetProcessHeap@0 00a8 __imp__HeapAlloc@12 00e4 __setmode_nolock 0141 __write_nolock 0152 ___doserrno 01c2 __imp__HeapFree@12 0205 __get_osfhandle 020f __imp__SetEndOfFile@4 0242 __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 48 56 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 CC 00 00 00 00 6A 01 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 89 55 DC 8B 4D D8 23 4D DC 83 F9 FF 74 23 6A 02 6A 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 D0 89 55 D4 8B 45 D0 23 45 D4 83 F8 FF 75 0C E8 ?? ?? ?? ?? 8B 00 E9 1C 02 00 00 8B 4D 0C 2B 4D D0 8B 55 10 1B 55 D4 89 4D E8 89 55 EC 83 7D EC 00 0F 8C 3F 01 00 00 7F 0A 83 7D E8 00 0F 86 33 01 00 00 68 00 10 00 00 6A 08 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 C8 83 7D C8 00 75 25 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 C7 45 CC 0C 00 00 00 C7 45 F8 FF FF FF FF C7 45 FC FF FF FF FF E9 EC 00 00 00 68 00 80 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 83 7D EC 00 7C 14 7F 09 81 7D E8 00 10 00 00 72 09 C7 45 C4 00 10 00 00 EB 06 8B 4D E8 89 4D C4 8B 55 C4 89 55 F4 83 7D EC 00 7C 14 7F 09 81 7D E8 00 10 00 00 72 09 C7 45 C0 00 10 00 00 EB 06 8B 45 E8 89 45 C0 8B 4D C0 51 8B 55 C8 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F4 83 7D F4 FF 75 28 E8 ?? ?? ?? ?? 83 38 05 75 12 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 C7 45 CC 0D 00 00 00 8B 45 F4 99 89 45 F8 89 55 FC EB 2A 8B 45 F4 99 8B 4D E8 2B C8 8B 45 EC 1B C2 89 4D E8 89 45 EC 83 7D EC 00 0F 8F 57 FF FF FF 7C 0A 83 7D E8 00 0F 87 4B FF FF FF 8B 4D E4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 C8 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? E9 84 00 00 00 83 7D EC 00 7F 7E 7C 06 83 7D E8 00 73 76 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 89 55 FC 8B 4D F8 23 4D FC 83 F9 FF 74 4F 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 83 E8 01 99 89 45 F8 89 55 FC 8B 45 F8 23 45 FC 83 F8 FF 75 21 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 C7 45 CC 0D 00 00 00 FF 15 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 89 30 8B 4D F8 23 4D FC 83 F9 FF 74 27 6A 00 8B 55 DC 52 8B 45 D8 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 B8 89 55 BC 8B 55 B8 23 55 BC 83 FA FF 75 09 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "__chsize"
		size = 38
		refs = "0011 __chsize_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 99 52 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8B 45 FC F7 D8 1B C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__output_s_l"
		size = 5140
		refs = "000c ___security_cookie 0051 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0075 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0081 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0088 __CrtDbgReportW 009f __errno 00b6 ??_C@_1BI@COFBLHCG@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 00c0 __invalid_parameter 00d5 ??1_LocaleUpdate@@QAE@XZ 0107 __fileno 013e ___pioinfo 0150 ___badioinfo 01ea ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0272 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 035c ___lookuptable_s 03de ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 046f $LN174 047e ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 048c __isleadbyte_l 04af _write_char 04e0 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 05d0 $LN170 05d7 $LN175 0628 _get_int_arg 06e5 $LN171 06ec $LN176 0820 $LN172 0827 $LN177 085b _get_short_arg 0882 _wctomb_s 08fe ___nullstring 090a _strlen 09c9 ___wnullstring 0a9a __get_printf_count_output 0ad6 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0bf7 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0c08 __malloc_dbg 0c7a __cfltcvt_tab 0c80 __decode_pointer 0db9 _get_int64_arg 0f86 __aullrem 0fa8 __aulldiv 10af _write_multi_char 10ca _write_string 122a __free_dbg 127b ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 1307 @__security_check_cookie@4 1310 $NORMAL_STATE$29383 1314 $LN131 1318 $LN130 131c $LN122 1320 $LN118 1324 $LN117 1328 $LN113 132c $LN97 1330 $LN125 1334 $LN124 1338 $LN126 133c $LN127 1340 $LN123 1344 $LN128 135c $LN107 1360 $LN99 1364 $LN110 1368 $LN98 136c $LN111 13a0 $LN66 13a4 $LN94 13a8 $LN82 13ac $LN48 13b0 $LN88 13b4 $LN65 13b8 $LN92 13bc $LN53 13c0 $LN71 13c4 $LN43 13c8 $LN49 13cc $LN80 13d0 $LN51 13d4 $LN46 13d8 $LN95"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FD FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 10 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 1C FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 1C FD FF FF E9 1D 12 00 00 8B 45 08 89 85 98 FD FF FF 8B 8D 98 FD FF FF 8B 51 0C 83 E2 40 0F 85 CB 00 00 00 8B 85 98 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 94 FD FF FF 83 BD 94 FD FF FF FF 74 2D 83 BD 94 FD FF FF FE 74 24 8B 8D 94 FD FF FF C1 F9 05 8B 95 94 FD FF FF 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 95 FC FC FF FF EB 0A C7 85 FC FC FF FF ?? ?? ?? ?? 8B 85 FC FC FF FF 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 56 83 BD 94 FD FF FF FF 74 2D 83 BD 94 FD FF FF FE 74 24 8B 85 94 FD FF FF C1 F8 05 8B 8D 94 FD FF FF 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 8D F8 FC FF FF EB 0A C7 85 F8 FC FF FF ?? ?? ?? ?? 8B 95 F8 FC FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 F4 FC FF FF 00 00 00 00 EB 0A C7 85 F4 FC FF FF 01 00 00 00 8B 95 F4 FC FF FF 89 95 90 FD FF FF 83 BD 90 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 90 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 18 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 18 FD FF FF E9 A8 10 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 8D 8C FD FF FF 83 BD 8C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 8C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 14 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 14 FD FF FF E9 20 10 00 00 C7 85 B4 FD FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FD FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 45 0C 8A 08 88 8D AF FD FF FF 0F BE 95 AF FD FF FF 8B 45 0C 83 C0 01 89 45 0C 85 D2 0F 84 10 0F 00 00 83 BD B4 FD FF FF 00 0F 8C 03 0F 00 00 0F BE 8D AF FD FF FF 83 F9 20 7C 25 0F BE 95 AF FD FF FF 83 FA 78 7F 19 0F BE 85 AF FD FF FF 0F B6 88 ?? ?? ?? ?? 83 E1 0F 89 8D F0 FC FF FF EB 0A C7 85 F0 FC FF FF 00 00 00 00 8B 95 F0 FC FF FF 89 95 B0 FD FF FF 8B 85 B0 FD FF FF 6B C0 09 8B 8D A4 FD FF FF 0F B6 94 08 ?? ?? ?? ?? C1 FA 04 89 95 A4 FD FF FF 83 BD A4 FD FF FF 08 0F 85 9F 00 00 00 33 C0 74 0C C7 85 EC FC FF FF 01 00 00 00 EB 0A C7 85 EC FC FF FF 00 00 00 00 8B 8D EC FC FF FF 89 8D 88 FD FF FF 83 BD 88 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 60 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 88 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 60 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 10 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 10 FD FF FF E9 B4 0E 00 00 8B 85 A4 FD FF FF 89 85 E8 FC FF FF 83 BD E8 FC FF FF 07 0F 87 D2 0D 00 00 8B 8D E8 FC FF FF FF 24 8D ?? ?? ?? ?? C7 45 F4 00 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 50 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B4 00 00 00 8D 85 B4 FD FF FF 50 8B 4D 08 51 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8A 08 88 8D AF FD FF FF 8B 55 0C 83 C2 01 89 55 0C 0F BE 85 AF FD FF FF F7 D8 1B C0 F7 D8 89 85 84 FD FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 84 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 0C FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 0C FD FF FF E9 B2 0D 00 00 8D 95 B4 FD FF FF 52 8B 45 08 50 0F B6 8D AF FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C E9 C9 0C 00 00 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D8 8B 45 D8 89 45 E8 8B 4D E8 89 4D E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 96 0C 00 00 0F BE 95 AF FD FF FF 89 95 E4 FC FF FF 8B 85 E4 FC FF FF 83 E8 20 89 85 E4 FC FF FF 83 BD E4 FC FF FF 10 77 4B 8B 8D E4 FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 F0 83 C8 04 89 45 F0 EB 2C 8B 4D F0 83 C9 01 89 4D F0 EB 21 8B 55 F0 83 CA 02 89 55 F0 EB 16 8B 45 F0 0D 80 00 00 00 89 45 F0 EB 09 8B 4D F0 83 C9 08 89 4D F0 E9 21 0C 00 00 0F BE 95 AF FD FF FF 83 FA 2A 75 28 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 4D F0 83 C9 04 89 4D F0 8B 55 E8 F7 DA 89 55 E8 EB 14 8B 45 E8 6B C0 0A 0F BE 8D AF FD FF FF 8D 54 08 D0 89 55 E8 E9 D4 0B 00 00 C7 45 D0 00 00 00 00 E9 C8 0B 00 00 0F BE 85 AF FD FF FF 83 F8 2A 75 1E 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 55 D0 6B D2 0A 0F BE 85 AF FD FF FF 8D 4C 02 D0 89 4D D0 E9 85 0B 00 00 0F BE 95 AF FD FF FF 89 95 E0 FC FF FF 8B 85 E0 FC FF FF 83 E8 49 89 85 E0 FC FF FF 83 BD E0 FC FF FF 2E 0F 87 0D 01 00 00 8B 8D E0 FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 0F BE 08 83 F9 6C 75 16 8B 55 0C 83 C2 01 89 55 0C 8B 45 F0 0D 00 10 00 00 89 45 F0 EB 09 8B 4D F0 83 C9 10 89 4D F0 E9 CA 00 00 00 8B 55 0C 0F BE 02 83 F8 36 75 26 8B 4D 0C 0F BE 51 01 83 FA 34 75 1A 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 C9 00 80 00 00 89 4D F0 E9 81 00 00 00 8B 55 0C 0F BE 02 83 F8 33 75 23 8B 4D 0C 0F BE 51 01 83 FA 32 75 17 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 E1 FF 7F FF FF 89 4D F0 EB 53 8B 55 0C 0F BE 02 83 F8 64 74 37 8B 4D 0C 0F BE 11 83 FA 69 74 2C 8B 45 0C 0F BE 08 83 F9 6F 74 21 8B 55 0C 0F BE 02 83 F8 75 74 16 8B 4D 0C 0F BE 11 83 FA 78 74 0B 8B 45 0C 0F BE 08 83 F9 58 75 02 EB 0F C7 85 A4 FD FF FF 00 00 00 00 E9 A2 FC FF FF EB 16 8B 55 F0 83 CA 20 89 55 F0 EB 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 E9 4A 0A 00 00 0F BE 8D AF FD FF FF 89 8D DC FC FF FF 8B 95 DC FC FF FF 83 EA 41 89 95 DC FC FF FF 83 BD DC FC FF FF 37 0F 87 1B 08 00 00 8B 85 DC FC FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 F0 81 E2 30 08 00 00 75 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 8B 4D F0 81 E1 10 08 00 00 74 55 C7 85 80 FD FF FF 00 00 00 00 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FD FF FF 0F B7 85 A8 FD FF FF 50 68 00 02 00 00 8D 8D B8 FD FF FF 51 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 80 FD FF FF 83 BD 80 FD FF FF 00 74 07 C7 45 D8 01 00 00 00 EB 26 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 7C FD FF FF 8A 8D 7C FD FF FF 88 8D B8 FD FF FF C7 45 DC 01 00 00 00 8D 95 B8 FD FF FF 89 55 FC E9 5D 07 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 78 FD FF FF 83 BD 78 FD FF FF 00 74 0C 8B 8D 78 FD FF FF 83 79 04 00 75 1A 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 50 8B 4D F0 81 E1 00 08 00 00 74 26 8B 95 78 FD FF FF 8B 42 04 89 45 FC 8B 8D 78 FD FF FF 0F BF 01 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 95 78 FD FF FF 8B 42 04 89 45 FC 8B 8D 78 FD FF FF 0F BF 11 89 55 DC E9 C7 06 00 00 8B 45 F0 25 30 08 00 00 75 0C 8B 4D F0 81 C9 00 08 00 00 89 4D F0 83 7D D0 FF 75 0C C7 85 D8 FC FF FF FF FF FF 7F EB 09 8B 55 D0 89 95 D8 FC FF FF 8B 85 D8 FC FF FF 89 85 70 FD FF FF 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F0 81 E2 10 08 00 00 74 65 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC C7 45 F4 01 00 00 00 8B 4D FC 89 8D 6C FD FF FF 8B 95 70 FD FF FF 8B 85 70 FD FF FF 83 E8 01 89 85 70 FD FF FF 85 D2 74 1E 8B 8D 6C FD FF FF 0F B7 11 85 D2 74 11 8B 85 6C FD FF FF 83 C0 02 89 85 6C FD FF FF EB C9 8B 8D 6C FD FF FF 2B 4D FC D1 F9 89 4D DC EB 5B 83 7D FC 00 75 09 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 89 85 74 FD FF FF 8B 8D 70 FD FF FF 8B 95 70 FD FF FF 83 EA 01 89 95 70 FD FF FF 85 C9 74 1E 8B 85 74 FD FF FF 0F BE 08 85 C9 74 11 8B 95 74 FD FF FF 83 C2 01 89 95 74 FD FF FF EB C9 8B 85 74 FD FF FF 2B 45 FC 89 45 DC E9 AB 05 00 00 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 68 FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 D2 74 0C C7 85 D4 FC FF FF 01 00 00 00 EB 0A C7 85 D4 FC FF FF 00 00 00 00 8B 85 D4 FC FF FF 89 85 64 FD FF FF 83 BD 64 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 64 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 08 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 08 FD FF FF E9 BC 07 00 00 E9 E8 04 00 00 8B 55 F0 83 E2 20 74 12 8B 85 68 FD FF FF 66 8B 8D B4 FD FF FF 66 89 08 EB 0E 8B 95 68 FD FF FF 8B 85 B4 FD FF FF 89 02 C7 45 D8 01 00 00 00 E9 B4 04 00 00 C7 45 D4 01 00 00 00 0F BE 8D AF FD FF FF 83 C1 20 88 8D AF FD FF FF 8B 55 F0 83 CA 40 89 55 F0 8D 85 B8 FD FF FF 89 45 FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F BE 8D AF FD FF FF 83 F9 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 42 68 DA 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 D0 81 C2 5D 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 14 8B 45 E0 89 45 FC 8B 4D D0 81 C1 5D 01 00 00 89 4D BC EB 07 C7 45 D0 A3 00 00 00 8B 55 14 83 C2 08 89 55 14 8B 45 14 8B 48 F8 8B 50 FC 89 8D 58 FD FF FF 89 95 5C FD FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 D4 50 8B 4D D0 51 0F BE 95 AF FD FF FF 52 8B 45 BC 50 8B 4D FC 51 8D 95 58 FD FF FF 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 1C 8B 4D F0 81 E1 80 00 00 00 74 26 83 7D D0 00 75 20 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 FC 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 0F BE 8D AF FD FF FF 83 F9 67 75 2C 8B 55 F0 81 E2 80 00 00 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 8B 55 FC 0F BE 02 83 F8 2D 75 15 8B 4D F0 81 C9 00 01 00 00 89 4D F0 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 09 03 00 00 8B 4D F0 83 C9 40 89 4D F0 C7 45 F8 0A 00 00 00 EB 6F C7 45 F8 0A 00 00 00 EB 66 C7 45 D0 08 00 00 00 C7 85 A0 FD FF FF 07 00 00 00 EB 0A C7 85 A0 FD FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 55 F0 81 E2 80 00 00 00 74 17 C6 45 EC 30 8B 85 A0 FD FF FF 83 C0 51 88 45 ED C7 45 E4 02 00 00 00 EB 1E C7 45 F8 08 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 0C 8B 55 F0 81 CA 00 02 00 00 89 55 F0 8B 45 F0 25 00 80 00 00 74 1D 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 48 FD FF FF 89 95 4C FD FF FF E9 AF 00 00 00 8B 55 F0 81 E2 00 10 00 00 74 1D 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 48 FD FF FF 89 95 4C FD FF FF E9 87 00 00 00 8B 4D F0 83 E1 20 74 42 8B 55 F0 83 E2 40 74 1C 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 98 99 89 85 48 FD FF FF 89 95 4C FD FF FF EB 1C 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 48 FD FF FF 89 95 4C FD FF FF EB 3D 8B 55 F0 83 E2 40 74 1B 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 48 FD FF FF 89 95 4C FD FF FF EB 1A 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 33 D2 89 85 48 FD FF FF 89 95 4C FD FF FF 8B 45 F0 83 E0 40 74 40 83 BD 4C FD FF FF 00 7F 37 7C 09 83 BD 48 FD FF FF 00 73 2C 8B 8D 48 FD FF FF F7 D9 8B 95 4C FD FF FF 83 D2 00 F7 DA 89 8D 40 FD FF FF 89 95 44 FD FF FF 8B 45 F0 0D 00 01 00 00 89 45 F0 EB 18 8B 8D 48 FD FF FF 89 8D 40 FD FF FF 8B 95 4C FD FF FF 89 95 44 FD FF FF 8B 45 F0 25 00 80 00 00 75 26 8B 4D F0 81 E1 00 10 00 00 75 1B 8B 95 40 FD FF FF 8B 85 44 FD FF FF 83 E0 00 89 95 40 FD FF FF 89 85 44 FD FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 4D F0 83 E1 F7 89 4D F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 95 40 FD FF FF 0B 95 44 FD FF FF 75 07 C7 45 E4 00 00 00 00 8D 45 B7 89 45 FC 8B 4D D0 8B 55 D0 83 EA 01 89 55 D0 85 C9 7F 0E 8B 85 40 FD FF FF 0B 85 44 FD FF FF 74 7B 8B 45 F8 99 52 50 8B 8D 44 FD FF FF 51 8B 95 40 FD FF FF 52 E8 ?? ?? ?? ?? 83 C0 30 89 85 54 FD FF FF 8B 45 F8 99 52 50 8B 85 44 FD FF FF 50 8B 8D 40 FD FF FF 51 E8 ?? ?? ?? ?? 89 85 40 FD FF FF 89 95 44 FD FF FF 83 BD 54 FD FF FF 39 7E 12 8B 95 54 FD FF FF 03 95 A0 FD FF FF 89 95 54 FD FF FF 8B 45 FC 8A 8D 54 FD FF FF 88 08 8B 55 FC 83 EA 01 89 55 FC E9 67 FF FF FF 8D 45 B7 2B 45 FC 89 45 DC 8B 4D FC 83 C1 01 89 4D FC 8B 55 }
	condition:
		$1
}

rule file_47_4_0 {
	meta:
		name = "_write_char"
		size = 157
		refs = "0071 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 8B 48 0C 83 E1 40 74 18 8B 55 0C 83 7A 08 00 75 0F 8B 45 10 8B 08 83 C1 01 8B 55 10 89 0A EB 70 8B 45 0C 8B 48 04 83 E9 01 8B 55 0C 89 4A 04 8B 45 0C 83 78 04 00 7C 26 8B 4D 0C 8B 11 8A 45 08 88 02 0F BE 4D 08 81 E1 FF 00 00 00 89 4D FC 8B 55 0C 8B 02 83 C0 01 8B 4D 0C 89 01 EB 14 8B 55 0C 52 0F BE 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC FF 75 0B 8B 4D 10 C7 01 FF FF FF FF EB 0D 8B 55 10 8B 02 83 C0 01 8B 4D 10 89 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_5_0 {
	meta:
		name = "_write_multi_char"
		size = 56
		refs = "0023 _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 21 8B 55 14 52 8B 45 10 50 0F B6 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 14 83 3A FF 75 02 EB 02 EB CF 5D C3 }
	condition:
		$1
}

rule file_47_6_0 {
	meta:
		name = "_write_string"
		size = 141
		refs = "004f _write_char 0068 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 10 8B 48 0C 83 E1 40 74 18 8B 55 10 83 7A 08 00 75 0F 8B 45 14 8B 08 03 4D 0C 8B 55 14 89 0A EB 60 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 50 8B 55 08 8A 02 88 45 FF 8B 4D 14 51 8B 55 10 52 0F B6 45 FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 C1 01 89 4D 08 8B 55 14 83 3A FF 75 20 E8 ?? ?? ?? ?? 83 38 2A 75 14 8B 45 14 50 8B 4D 10 51 6A 3F E8 ?? ?? ?? ?? 83 C4 0C EB 02 EB 02 EB A0 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_7_0 {
	meta:
		name = "_get_int_arg"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_47_8_0 {
	meta:
		name = "_get_int64_arg"
		size = 31
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 83 C1 08 8B 55 08 89 0A 8B 45 08 8B 08 8B 41 F8 8B 51 FC 5D C3 }
	condition:
		$1
}

rule file_47_9_0 {
	meta:
		name = "_get_short_arg"
		size = 29
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 83 C1 04 8B 55 08 89 0A 8B 45 08 8B 08 66 8B 41 FC 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__openfile"
		size = 1977
		refs = "0009 __commode 002c ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0035 ??_C@_1FO@POGAHKND@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003c __CrtDbgReportW 0050 ??_C@_1BK@HGLMNMEC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0074 ??_C@_1BI@MFCLPIBM@?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0120 ??_C@_1DK@PKMJBLLN@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAo?$AAp?$AAe?$AAn?$AA?5?$AAm?$AAo?$AAd?$AAe?$AA?$CC?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 0144 __errno 0158 ??_C@_1BE@DONHJJKE@?$AA_?$AAo?$AAp?$AAe?$AAn?$AAf?$AAi?$AAl?$AAe?$AA?$AA@ 0162 __invalid_parameter 01ba $LN89 01c1 $LN90 03ec ?ccsField@?P@??_openfile@@9@9 03f1 __mbsnbcmp 0536 ?utf8encoding@?P@??_openfile@@9@9 053f __mbsnbicmp 0566 ?utf16encoding@?P@??_openfile@@9@9 0596 ?unicodeencoding@?P@??_openfile@@9@9 0660 ??_C@_1CI@KEDPFCAL@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 06c9 __sopen_s 06da __cflush 0730 $LN54 0734 $LN53 0738 $LN25 073c $LN29 0740 $LN26 0744 $LN35 0748 $LN38 074c $LN32 0750 $LN50 0754 $LN44 0758 $LN41 075c $LN47 0760 $LN24"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? 89 45 EC C7 45 E4 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 0C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 14 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 46 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 8A 11 88 55 C4 80 7D C4 61 74 38 80 7D C4 72 74 08 80 7D C4 77 74 17 EB 3C C7 45 F4 00 00 00 00 8B 45 EC 83 C8 01 89 45 EC E9 98 00 00 00 C7 45 F4 01 03 00 00 8B 4D EC 83 C9 02 89 4D EC E9 83 00 00 00 C7 45 F4 09 01 00 00 8B 55 EC 83 CA 02 89 55 EC EB 71 33 C0 74 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 4D C0 89 4D DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 62 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 62 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B9 05 00 00 C7 45 E0 01 00 00 00 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 0F BE 11 85 D2 0F 84 37 02 00 00 83 7D E0 00 0F 84 2D 02 00 00 8B 45 0C 0F BE 08 89 4D BC 8B 55 BC 83 EA 20 89 55 BC 83 7D BC 54 0F 87 95 01 00 00 8B 45 BC 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E9 F6 01 00 00 8B 55 F4 83 E2 02 74 09 C7 45 E0 00 00 00 00 EB 27 8B 45 F4 83 C8 02 89 45 F4 8B 4D F4 83 E1 FE 89 4D F4 8B 55 EC 81 CA 80 00 00 00 89 55 EC 8B 45 EC 83 E0 FC 89 45 EC E9 B9 01 00 00 8B 4D F4 81 E1 00 C0 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 55 F4 81 CA 00 80 00 00 89 55 F4 E9 94 01 00 00 8B 45 F4 25 00 C0 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 4D F4 81 C9 00 40 00 00 89 4D F4 E9 70 01 00 00 83 7D E4 00 74 09 C7 45 E0 00 00 00 00 EB 13 C7 45 E4 01 00 00 00 8B 55 EC 81 CA 00 40 00 00 89 55 EC E9 49 01 00 00 83 7D E4 00 74 09 C7 45 E0 00 00 00 00 EB 12 C7 45 E4 01 00 00 00 8B 45 EC 25 FF BF FF FF 89 45 EC E9 23 01 00 00 83 7D E8 00 74 09 C7 45 E0 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 4D F4 83 C9 20 89 4D F4 E9 FF 00 00 00 83 7D E8 00 74 09 C7 45 E0 00 00 00 00 EB 10 C7 45 E8 01 00 00 00 8B 55 F4 83 CA 10 89 55 F4 E9 DB 00 00 00 8B 45 F4 25 00 10 00 00 74 09 C7 45 E0 00 00 00 00 EB 0C 8B 4D F4 81 C9 00 10 00 00 89 4D F4 E9 B7 00 00 00 8B 55 F4 83 E2 40 74 09 C7 45 E0 00 00 00 00 EB 09 8B 45 F4 83 C8 40 89 45 F4 E9 98 00 00 00 8B 4D F4 81 C9 80 00 00 00 89 4D F4 E9 87 00 00 00 C7 45 F0 01 00 00 00 C7 45 E0 00 00 00 00 EB 77 33 D2 74 09 C7 45 B8 01 00 00 00 EB 07 C7 45 B8 00 00 00 00 8B 45 B8 89 45 D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 C9 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 69 03 00 00 E9 B2 FD FF FF 83 7D F0 00 0F 84 68 02 00 00 8B 55 0C 0F BE 02 83 F8 20 75 0B 8B 4D 0C 83 C1 01 89 4D 0C EB EA 6A 03 8B 55 0C 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 77 33 C0 74 09 C7 45 B4 01 00 00 00 EB 07 C7 45 B4 00 00 00 00 8B 4D B4 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B6 02 00 00 8B 45 0C 83 C0 03 89 45 0C 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 0F BE 11 83 FA 3D 74 77 33 C0 74 09 C7 45 B0 01 00 00 00 EB 07 C7 45 B0 00 00 00 00 8B 4D B0 89 4D D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 15 02 00 00 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 6A 05 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 19 8B 55 0C 83 C2 05 89 55 0C 8B 45 F4 0D 00 00 04 00 89 45 F4 E9 D4 00 00 00 6A 08 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 19 8B 55 0C 83 C2 08 89 55 0C 8B 45 F4 0D 00 00 02 00 89 45 F4 E9 A4 00 00 00 6A 07 68 ?? ?? ?? ?? 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 16 8B 55 0C 83 C2 07 89 55 0C 8B 45 F4 0D 00 00 01 00 89 45 F4 EB 77 33 C9 74 09 C7 45 AC 01 00 00 00 EB 07 C7 45 AC 00 00 00 00 8B 55 AC 89 55 CC 83 7D CC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 01 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 01 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F2 00 00 00 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 0F BE 11 F7 DA 1B D2 83 C2 01 89 55 C8 75 21 68 ?? ?? ?? ?? 6A 00 68 0B 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 0B 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 76 68 80 01 00 00 8B 4D 10 51 8B 55 F4 52 8B 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 04 33 C0 EB 51 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 8B 45 14 89 45 F8 8B 4D F8 8B 55 EC 89 51 0C 8B 45 F8 C7 40 04 00 00 00 00 8B 4D F8 C7 01 00 00 00 00 8B 55 F8 C7 42 08 00 00 00 00 8B 45 F8 C7 40 1C 00 00 00 00 8B 4D F8 8B 55 FC 89 51 10 8B 45 F8 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 01 02 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 03 0C 0C 0C 0C 0C 0C 0C 0C 0C 04 0C 0C 0C 05 06 07 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 08 09 0C 0C 0C 0C 0C 0C 0C 0C 0C 0C 0A 0C 0C 0C 0C 0C 0B }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "__aulldvrm"
		size = 149
	strings:
		$1 = { 56 8B 44 24 14 0B C0 75 28 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B D8 8B 44 24 08 F7 F1 8B F0 8B C3 F7 64 24 10 8B C8 8B C6 F7 64 24 10 03 D1 EB 47 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 14 8B C8 8B 44 24 10 F7 E6 03 D1 72 0E 3B 54 24 0C 77 08 72 0F 3B 44 24 08 76 09 4E 2B 44 24 10 1B 54 24 14 33 DB 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 5E C2 10 00 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_fputc"
		size = 590
		refs = "0008 __sehtable$_fputc 000d __except_handler4 001f ___security_cookie 004c ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0055 ??_C@_1FO@CJOPDBGD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005c __CrtDbgReportW 0070 __errno 0084 ??_C@_1M@OIJMPNCO@?$AAf?$AAp?$AAu?$AAt?$AAc?$AA?$AA@ 008e __invalid_parameter 00a2 __lock_file 00ca __fileno 00f2 ___pioinfo 00fe ___badioinfo 0171 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 020e __flsbuf 0231 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9F 01 00 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 89 45 DC 8B 4D DC 8B 51 0C 83 E2 40 0F 85 98 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 83 7D D8 FF 74 21 83 7D D8 FE 74 1B 8B 4D D8 C1 F9 05 8B 55 D8 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 55 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 45 D0 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 41 83 7D D8 FF 74 21 83 7D D8 FE 74 1B 8B 45 D8 C1 F8 05 8B 4D D8 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 4D CC EB 07 C7 45 CC ?? ?? ?? ?? 8B 55 CC 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 55 C8 89 55 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 57 8B 4D 0C 8B 51 04 83 EA 01 8B 45 0C 89 50 04 8B 4D 0C 83 79 04 00 7C 26 8B 55 0C 8B 02 8A 4D 08 88 08 0F BE 55 08 81 E2 FF 00 00 00 89 55 C4 8B 45 0C 8B 08 83 C1 01 8B 55 0C 89 0A EB 13 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 C4 8B 55 C4 89 55 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_putc"
		size = 590
		refs = "0008 __sehtable$_putc 000d __except_handler4 001f ___security_cookie 004c ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0055 ??_C@_1FO@CJOPDBGD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005c __CrtDbgReportW 0070 __errno 0084 ??_C@_19LHKMJKNP@?$AAp?$AAu?$AAt?$AAc?$AA?$AA@ 008e __invalid_parameter 00a2 __lock_file 00ca __fileno 00f2 ___pioinfo 00fe ___badioinfo 0171 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 020e __flsbuf 0231 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 48 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9F 01 00 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 89 45 DC 8B 4D DC 8B 51 0C 83 E2 40 0F 85 98 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 83 7D D8 FF 74 21 83 7D D8 FE 74 1B 8B 4D D8 C1 F9 05 8B 55 D8 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 55 D0 EB 07 C7 45 D0 ?? ?? ?? ?? 8B 45 D0 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 41 83 7D D8 FF 74 21 83 7D D8 FE 74 1B 8B 45 D8 C1 F8 05 8B 4D D8 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 4D CC EB 07 C7 45 CC ?? ?? ?? ?? 8B 55 CC 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 55 C8 89 55 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF FF 83 7D E4 00 75 57 8B 4D 0C 8B 51 04 83 EA 01 8B 45 0C 89 50 04 8B 4D 0C 83 79 04 00 7C 26 8B 55 0C 8B 02 8A 4D 08 88 08 0F BE 55 08 81 E2 FF 00 00 00 89 55 C4 8B 45 0C 8B 08 83 C1 01 8B 55 0C 89 0A EB 13 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 C4 8B 55 C4 89 55 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "___libm_sse2_pow"
		size = 2680
		refs = "0007 _SIGMASK 0015 _ONEMASK 004c _rcp_t1 0060 _log2_t1 009b _HALFSIG 00c7 _rcp_t2 00db _log2_t2 010d _LHN 0123 _rcp_t3 0135 _log2_t3 021e _clv 028d _exp2_tbl 0295 _cev 0344 _ABSVALMASK 0402 _NEG_ZERO 061e _NEG_INF 06a1 _sNaN 07a1 _INF 09c1 _EMIN"
	strings:
		$1 = { 83 EC 14 66 0F 12 3D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 12 15 ?? ?? ?? ?? 66 0F 13 4C 24 0C 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 BE 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 0C 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 F9 04 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 28 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E AF 05 00 00 F2 0F 58 E0 F2 0F 2A C0 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 66 0F 59 D7 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 BF 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 0C F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 83 C4 14 F2 0F 58 C5 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 C3 66 0F 12 4C 24 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 DA 00 00 00 0B C1 83 F8 00 0F 84 6B 04 00 00 83 FA 00 0F 8D 05 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A2 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 99 02 00 00 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5E BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 43 FC FF FF 66 0F 12 7C 24 04 66 0F 12 64 24 04 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 9D 02 00 00 0F 87 F1 01 00 00 83 FA 00 0F 87 E8 01 00 00 E9 89 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 79 FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 10 81 E2 00 00 00 80 83 FA 00 74 2B C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 54 24 04 83 C4 14 F2 0F 5E CA C3 C1 E1 0D 23 C1 83 F8 00 0F 85 A9 00 00 00 83 C4 14 66 0F 57 C0 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 D1 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 9C 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 6F 66 0F 12 4C 24 0C 66 0F 12 54 24 0C B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 2D 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 8B 01 00 00 83 C4 14 66 0F 57 C0 C3 66 0F 12 4C 24 0C 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 6A 01 00 00 83 C4 14 66 0F 57 C0 C3 83 C4 14 F2 0F 58 E4 66 0F 28 C4 C3 66 0F 12 54 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 73 FE FF FF 83 C4 14 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 C3 66 0F 12 64 24 04 66 0F 12 54 24 0C 66 0F 7E E0 83 F8 00 75 4C 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 2E 01 00 00 81 FA 00 00 F0 BF 75 2F 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 3D FF 00 00 00 0F 85 D4 00 00 00 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 0F 85 A0 00 00 00 66 0F C5 C2 03 66 0F 12 64 24 04 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 AE 00 00 00 83 F8 00 74 55 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 3C 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 0B D0 83 FA 00 75 43 83 C4 14 66 0F 57 C9 66 0F 57 E4 B8 F0 3F 00 00 66 0F C4 C8 03 F2 0F 5E CC 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 14 66 0F 57 C0 C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 08 83 C4 14 66 0F 57 C0 C3 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 14 F2 0F 58 D2 66 0F 28 C2 C3 83 C4 14 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 14 66 0F 12 05 ?? ?? ?? ?? C3 83 F8 00 7E 25 3D 00 00 04 00 0F 83 B9 01 00 00 56 8B D0 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 23 3D 00 02 FC FF 0F 8E 77 01 00 00 56 8B D0 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 2A C0 83 E0 7F 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 BF 00 00 66 0F C4 F8 03 F2 0F 59 54 24 14 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 19 5E 83 C4 14 F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 C3 5E 83 C4 14 F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 C3 83 C4 14 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 C3 66 0F 57 C9 B8 EF FF 00 00 66 0F C4 C8 03 F2 0F 10 C1 83 F9 00 74 0A 66 0F 73 F0 01 66 0F 73 D0 01 83 C4 14 F2 0F 59 C1 C3 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 AB F7 FF FF 3D 00 00 00 80 72 13 83 C4 14 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D C3 66 0F 12 64 24 04 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 47 FF FF FF E9 5F FF FF FF }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__spawnv"
		size = 530
		refs = "001b ??_C@_1CC@MODLNCFO@?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GA@DELPGPFF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BA@DKJGKDD@?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@PKENOFGE@?$AA?$CK?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0148 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01aa ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0207 __spawnve"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A2 01 00 00 8B 55 0C 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3F 01 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DB 00 00 00 8B 4D 10 33 D2 83 39 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 78 8B 4D 10 8B 11 0F BE 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__powhlp"
		size = 422
		refs = "0051 __d_inf 00bc __d_ind 0130 __d_inttype 0180 __d_mzero"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C C7 45 FC 00 00 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0A DD 45 08 D9 E0 DD 5D E4 EB 06 DD 45 08 DD 5D E4 DD 45 E4 DD 5D F0 81 7D 14 00 00 F0 7F 75 40 83 7D 10 00 75 3A D9 E8 DC 5D F0 DF E0 F6 C4 05 7A 0D 8B 45 18 DD 05 ?? ?? ?? ?? DD 18 EB 1C D9 E8 DC 5D F0 DF E0 F6 C4 41 75 09 8B 4D 18 D9 EE DD 19 EB 07 8B 55 18 D9 E8 DD 1A E9 25 01 00 00 81 7D 14 00 00 F0 FF 75 4B 83 7D 10 00 75 45 D9 E8 DC 5D F0 DF E0 F6 C4 05 7A 09 8B 45 18 D9 EE DD 18 EB 2B D9 E8 DC 5D F0 DF E0 F6 C4 41 75 0D 8B 4D 18 DD 05 ?? ?? ?? ?? DD 19 EB 12 8B 55 18 DD 05 ?? ?? ?? ?? DD 1A C7 45 FC 01 00 00 00 E9 D1 00 00 00 81 7D 0C 00 00 F0 7F 75 40 83 7D 08 00 75 3A D9 EE DC 5D 10 DF E0 F6 C4 05 7A 0D 8B 45 18 DD 05 ?? ?? ?? ?? DD 18 EB 1C D9 EE DC 5D 10 DF E0 F6 C4 41 75 09 8B 4D 18 D9 EE DD 19 EB 07 8B 55 18 D9 E8 DD 1A E9 88 00 00 00 81 7D 0C 00 00 F0 FF 75 7F 83 7D 08 00 75 79 83 EC 08 DD 45 10 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC D9 EE DC 5D 10 DF E0 F6 C4 05 7A 26 83 7D EC 01 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D DC EB 09 DD 05 ?? ?? ?? ?? DD 5D DC 8B 45 18 DD 45 DC DD 18 EB 33 D9 EE DC 5D 10 DF E0 F6 C4 41 75 20 83 7D EC 01 75 0B DD 05 ?? ?? ?? ?? DD 5D D4 EB 05 D9 EE DD 5D D4 8B 4D 18 DD 45 D4 DD 19 EB 07 8B 55 18 D9 E8 DD 1A 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_55_1_0 {
	meta:
		name = "__d_inttype"
		size = 132
		refs = "0012 __fpclass 002e __frnd 004a __real@4000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 25 90 00 00 00 74 04 33 C0 EB 5C 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F8 DD 45 08 DC 5D F8 DF E0 F6 C4 44 7A 39 DD 45 08 DC 35 ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 35 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 09 B8 02 00 00 00 EB 0B EB 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "___libm_sse2_sin"
		size = 440
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 015d _ALL_ONES 0166 _TWO_POW_55 0176 _TWO_POW_M55 019e _sin 01b3 _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 00 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 2C 66 C1 E8 04 66 3D FD 0C 75 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C D8 F2 0F 59 1D ?? ?? ?? ?? C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 23 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 8B 64 24 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "??_N@YGXPAXIHP6EX0@Z1@Z"
		size = 178
		refs = "0008 __sehtable$??_N@YGXPAXIHP6EX0@Z1@Z 000d __except_handler4 001f ___security_cookie 0099 ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 3B 4D 10 7D 13 6A 01 8B 4D 08 FF 55 14 8B 55 08 03 55 0C 89 55 08 EB DC C7 45 E0 01 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1C 83 7D E0 00 75 15 8B 45 18 50 8B 4D E4 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__wfsopen"
		size = 523
		refs = "0008 __sehtable$__wfsopen 000d __except_handler4 001f ___security_cookie 0053 ??_C@_1BO@CLGIAEOJ@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005c ??_C@_1FO@NCADDBOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0063 __CrtDbgReportW 0077 __errno 008b ??_C@_1BC@PAJNLEOB@?$AA_?$AAw?$AAf?$AAs?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 0095 __invalid_parameter 00b6 ??_C@_1BO@MJMKAKCJ@?$AA?$CI?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0118 ??_C@_1CI@HBNALCBB@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0169 __getstream 01b4 __local_unwind4 01d1 __wopenfile 01ee __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 E0 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 56 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F3 00 00 00 8B 4D 0C 0F B7 11 F7 DA 1B D2 F7 DA 89 55 D4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 91 00 00 00 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 74 C7 45 FC 00 00 00 00 8B 4D 08 0F B7 11 85 D2 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 D0 00 00 00 00 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 D0 EB 39 8B 4D E4 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_1_0 {
	meta:
		name = "__wfopen"
		size = 25
		refs = "0010 __wfsopen"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_763_1_0 {
	meta:
		name = "_fopen"
		size = 25
		refs = "0010 __fsopen"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_59_2_0 {
	meta:
		name = "__wfopen_s"
		size = 160
		refs = "0019 ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0025 ??_C@_1FO@NCADDBOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BE@JDODBHOJ@?$AA_?$AAw?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 0061 __invalid_parameter 007d __wfsopen"
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2D 68 80 00 00 00 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 8B 55 08 83 3A 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_763_2_0 {
	meta:
		name = "_fopen_s"
		size = 160
		refs = "0019 ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0025 ??_C@_1FO@NCADDBOO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002c __CrtDbgReportW 0040 __errno 0057 ??_C@_1BA@PBGKCCAP@?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 0061 __invalid_parameter 007d __fsopen"
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2D 68 80 00 00 00 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 8B 55 08 83 3A 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_60_2_0 {
	meta:
		name = "__CIasin_default"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 0048 ___fastflag 004f __fast_exit 005a _NAME_ 005f __math_exit 0080 __piby2 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2B D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0E 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 3A 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 29 81 E1 00 00 00 80 DD D8 DB 2D ?? ?? ?? ?? 74 C0 D9 E0 EB BC E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0E 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "_ungetc"
		size = 233
		refs = "0008 __sehtable$_ungetc 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GA@OAFAANFO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1O@JDPLECOK@?$AAu?$AAn?$AAg?$AAe?$AAt?$AAc?$AA?$AA@ 0087 __invalid_parameter 0098 __lock_file 00af __ungetc_nolock 00cc __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 44 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__ungetc_nolock"
		size = 542
		refs = "0022 __fileno 004a ___pioinfo 0056 ___badioinfo 00c9 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 00d2 ??_C@_1HC@OEJDDIIH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00d9 __CrtDbgReportW 00ed __errno 0101 ??_C@_1BO@OLMLKKEA@?$AA_?$AAu?$AAn?$AAg?$AAe?$AAt?$AAc?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 010b __invalid_parameter 0160 __getbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 45 0C 89 45 F8 8B 4D F8 8B 51 0C 83 E2 40 0F 85 98 00 00 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 FF 74 21 83 7D F4 FE 74 1B 8B 4D F4 C1 F9 05 8B 55 F4 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 55 EC EB 07 C7 45 EC ?? ?? ?? ?? 8B 45 EC 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 41 83 7D F4 FF 74 21 83 7D F4 FE 74 1B 8B 45 F4 C1 F8 05 8B 4D F4 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 4D E8 EB 07 C7 45 E8 ?? ?? ?? ?? 8B 55 E8 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 09 C7 45 E4 00 00 00 00 EB 07 C7 45 E4 01 00 00 00 8B 55 E4 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 26 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 00 01 00 00 8B 4D 0C 89 4D FC 83 7D 08 FF 74 24 8B 55 FC 8B 42 0C 83 E0 01 75 21 8B 4D FC 8B 51 0C 81 E2 80 00 00 00 74 0B 8B 45 FC 8B 48 0C 83 E1 02 74 08 83 C8 FF E9 C8 00 00 00 8B 55 FC 83 7A 08 00 75 0C 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8B 55 FC 8B 01 3B 42 08 75 1E 8B 4D FC 83 79 04 00 74 08 83 C8 FF E9 95 00 00 00 8B 55 FC 8B 02 83 C0 01 8B 4D FC 89 01 8B 55 FC 8B 42 0C 83 E0 40 74 31 8B 4D FC 8B 11 83 EA 01 8B 45 FC 89 10 8B 4D FC 8B 11 0F BE 02 0F BE 4D 08 3B C1 74 12 8B 55 FC 8B 02 83 C0 01 8B 4D FC 89 01 83 C8 FF EB 4E EB 17 8B 55 FC 8B 02 83 E8 01 8B 4D FC 89 01 8B 55 FC 8B 02 8A 4D 08 88 08 8B 55 FC 8B 42 04 83 C0 01 8B 4D FC 89 41 04 8B 55 FC 8B 42 0C 83 E0 EF 8B 4D FC 89 41 0C 8B 55 FC 8B 42 0C 83 C8 01 8B 4D FC 89 41 0C 8B 45 08 25 FF 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__vswprintf_l"
		size = 460
		refs = "0021 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 002d ??_C@_1GE@KINELFI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0034 __CrtDbgReportW 0048 __errno 005f ??_C@_1BK@EPLNBKAK@?$AA_?$AAv?$AAs?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAl?$AA?$AA@ 0069 __invalid_parameter 008b ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0118 __woutput_l 0170 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8D 45 D8 89 45 F8 33 C9 83 7D 0C 00 0F 95 C1 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 50 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 87 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 87 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E6 00 00 00 8B 55 F8 C7 42 0C 42 00 00 00 8B 45 F8 8B 4D 08 89 48 08 8B 55 F8 8B 45 08 89 02 8B 4D F8 C7 41 04 FF FF FF 7F 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D 08 00 75 08 8B 45 FC E9 98 00 00 00 8B 45 F8 8B 48 04 83 E9 01 8B 55 F8 89 4A 04 8B 45 F8 83 78 04 00 7C 21 8B 4D F8 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 CC 8B 4D F8 8B 11 83 C2 01 8B 45 F8 89 10 EB 11 8B 4D F8 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC 8B 55 F8 8B 42 04 83 E8 01 8B 4D F8 89 41 04 8B 55 F8 83 7A 04 00 7C 22 8B 45 F8 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 C8 8B 45 F8 8B 08 83 C1 01 8B 55 F8 89 0A EB 11 8B 45 F8 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C8 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "__vswprintf"
		size = 29
		refs = "0014 __vswprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_601_1_0 {
	meta:
		name = "_vsprintf"
		size = 29
		refs = "0014 __vsprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 6A 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_62_2_0 {
	meta:
		name = "___vswprintf_l"
		size = 31
		refs = "0016 __vswprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_22_258_1 {
	meta:
		name = "??$copy_s@U?$char_traits@D@std@@@_Traits_helper@std@@YAPADPADIPBDIU_Secure_char_traits_tag@1@@Z"
		size = 31
		refs = "0016 ?_Copy_s@?$char_traits@D@std@@SAPADPADIPBDI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_22_261_1 {
	meta:
		name = "??$copy_s@U?$char_traits@G@std@@@_Traits_helper@std@@YAPAGPAGIPBGIU_Secure_char_traits_tag@1@@Z"
		size = 31
		refs = "0016 ?_Copy_s@?$char_traits@G@std@@SAPAGPAGIPBGI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_8_261_1 {
	meta:
		name = "??$copy_s@U?$char_traits@_W@std@@@_Traits_helper@std@@YAPA_WPA_WIPB_WIU_Secure_char_traits_tag@1@@Z"
		size = 31
		refs = "0016 ?_Copy_s@?$char_traits@_W@std@@SAPA_WPA_WIPB_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_68_86_1 {
	meta:
		name = "??$move_s@U?$char_traits@D@std@@@_Traits_helper@std@@YAPADPADIPBDIU_Secure_char_traits_tag@1@@Z"
		size = 31
		refs = "0016 ?_Move_s@?$char_traits@D@std@@SAPADPADIPBDI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_21_1345_1 {
	meta:
		name = "??$move_s@U?$char_traits@G@std@@@_Traits_helper@std@@YAPAGPAGIPBGIU_Secure_char_traits_tag@1@@Z"
		size = 31
		refs = "0016 ?_Move_s@?$char_traits@G@std@@SAPAGPAGIPBGI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_21_1342_1 {
	meta:
		name = "??$move_s@U?$char_traits@_W@std@@@_Traits_helper@std@@YAPA_WPA_WIPB_WIU_Secure_char_traits_tag@1@@Z"
		size = 31
		refs = "0016 ?_Move_s@?$char_traits@_W@std@@SAPA_WPA_WIPB_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_35_11_1 {
	meta:
		name = "??2facet@locale@std@@SAPAXIABU_DebugHeapTag_t@2@PADH@Z"
		size = 31
		refs = "0016 ??2@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_5_6_1 {
	meta:
		name = "??_U@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
		size = 31
		refs = "0016 ??2@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_5_8_1 {
	meta:
		name = "??_V@YAXPAXABU_DebugHeapTag_t@std@@PADH@Z"
		size = 31
		refs = "0016 ??3@YAXPAXABU_DebugHeapTag_t@std@@PADH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_45_0_1 {
	meta:
		name = "__Stoldx"
		size = 31
		refs = "0016 __Stodx"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_166_4_0 {
	meta:
		name = "__mbstowcs_l"
		size = 31
		refs = "0016 __mbstowcs_l_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_200_5_0 {
	meta:
		name = "__wcstombs_l"
		size = 31
		refs = "0016 __wcstombs_l_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_436_10_0 {
	meta:
		name = "_mbsrtowcs"
		size = 31
		refs = "0016 __mbsrtowcs_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_898_9_0 {
	meta:
		name = "_wcsrtombs"
		size = 31
		refs = "0016 __wcsrtombs_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_62_3_0 {
	meta:
		name = "__vscwprintf_helper"
		size = 188
		refs = "0021 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 002d ??_C@_1GE@KINELFI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0034 __CrtDbgReportW 0048 __errno 005f ??_C@_1CG@IMMIEPNA@?$AA_?$AAv?$AAs?$AAc?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0069 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 8D 45 D8 89 45 F8 33 C9 83 7D 0C 00 0F 95 C1 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B3 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B3 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 43 8B 45 F8 C7 40 04 FF FF FF 7F 8B 4D F8 C7 41 0C 42 00 00 00 8B 55 F8 C7 42 08 00 00 00 00 8B 45 F8 C7 00 00 00 00 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D F8 51 FF 55 08 83 C4 10 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_62_4_0 {
	meta:
		name = "__vscwprintf"
		size = 30
		refs = "0010 __woutput_l 0015 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_913_6_0 {
	meta:
		name = "__vprintf_p"
		size = 30
		refs = "0010 __output_p_l 0015 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_601_3_0 {
	meta:
		name = "__vscprintf"
		size = 30
		refs = "0010 __output_l 0015 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_601_5_0 {
	meta:
		name = "__vscprintf_p"
		size = 30
		refs = "0010 __output_p_l 0015 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_62_6_0 {
	meta:
		name = "__vscwprintf_p"
		size = 30
		refs = "0010 __woutput_p_l 0015 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_147_6_0 {
	meta:
		name = "__vwprintf_p"
		size = 30
		refs = "0010 __woutput_p_l 0015 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_913_4_0 {
	meta:
		name = "_vprintf"
		size = 30
		refs = "0010 __output_l 0015 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_913_5_0 {
	meta:
		name = "_vprintf_s"
		size = 30
		refs = "0010 __output_s_l 0015 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_147_4_0 {
	meta:
		name = "_vwprintf"
		size = 30
		refs = "0010 __woutput_l 0015 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_147_5_0 {
	meta:
		name = "_vwprintf_s"
		size = 30
		refs = "0010 __woutput_s_l 0015 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_62_5_0 {
	meta:
		name = "__vscwprintf_l"
		size = 32
		refs = "0012 __woutput_l 0017 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_913_1_0 {
	meta:
		name = "__vprintf_l"
		size = 32
		refs = "0012 __output_l 0017 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_913_3_0 {
	meta:
		name = "__vprintf_p_l"
		size = 32
		refs = "0012 __output_p_l 0017 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_913_2_0 {
	meta:
		name = "__vprintf_s_l"
		size = 32
		refs = "0012 __output_s_l 0017 _vprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_601_4_0 {
	meta:
		name = "__vscprintf_l"
		size = 32
		refs = "0012 __output_l 0017 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_601_6_0 {
	meta:
		name = "__vscprintf_p_l"
		size = 32
		refs = "0012 __output_p_l 0017 __vscprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_62_7_0 {
	meta:
		name = "__vscwprintf_p_l"
		size = 32
		refs = "0012 __woutput_p_l 0017 __vscwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_147_1_0 {
	meta:
		name = "__vwprintf_l"
		size = 32
		refs = "0012 __woutput_l 0017 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_147_3_0 {
	meta:
		name = "__vwprintf_p_l"
		size = 32
		refs = "0012 __woutput_p_l 0017 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "__vwprintf_s_l"
		size = 32
		refs = "0012 __woutput_s_l 0017 _vwprintf_helper"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "___libm_sse2_logf"
		size = 377
		refs = "0004 _dword_mask 0010 _SIGMASK 001c _EXPMASK 0039 _cv 0077 _B_table 00a8 _T_tbl 00cc _LN2 010e _pow2_64 0152 _SNAN 015f _One 016b _NEG_INF"
	strings:
		$1 = { F3 0F 10 25 ?? ?? ?? ?? F3 0F 10 F8 66 0F 12 0D ?? ?? ?? ?? 66 0F DB C4 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 C8 66 0F 56 CB 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B D1 81 FA 00 80 00 00 0F 83 87 00 00 00 B9 3F 3F 00 00 66 0F 6E C1 66 0F 12 1D ?? ?? ?? ?? 83 E0 7F 83 C0 01 25 FE 00 00 00 03 C0 03 C0 66 0F 12 B8 ?? ?? ?? ?? 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 80 ?? ?? ?? ?? F2 0F 59 CF F2 0F 5C CB F2 0F 10 F9 F2 0F 59 E9 F2 0F 10 D9 F2 0F 59 C9 F2 0F 58 EE F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 D1 F2 0F 58 D3 F2 0F 59 FD F2 0F 58 C4 F2 0F 58 D7 F2 0F 58 C2 66 0F 5A C0 C3 66 0F 7E FA 81 FA 00 00 00 80 73 37 81 FA 00 00 80 7F 73 6B 83 FA 00 74 51 F3 0F 59 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F C5 C4 01 0F 5A C4 66 0F 54 C8 66 0F 56 CB B9 3F 5F 00 00 E9 3B FF FF FF 81 FA 00 00 00 80 74 1F 81 E2 FF FF FF 7F 81 FA 01 00 80 7F 73 26 F3 0F 10 C7 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C1 C3 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5E CF F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C7 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "_bsearch"
		size = 550
		refs = "0047 ??_C@_1DC@HAGCIKOA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0050 ??_C@_1GC@ICJFPHNP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0057 __CrtDbgReportW 006b __errno 007f ??_C@_1BA@CLPIMKHD@?$AAb?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AA?$AA@ 0089 __invalid_parameter 00a6 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0109 ??_C@_1CA@OIBGFNKD@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 8B 45 0C 89 45 F8 8B 4D 10 83 E9 01 0F AF 4D 14 03 4D 0C 89 4D F0 83 7D 0C 00 75 0F 83 7D 10 00 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 55 DC 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 8B 01 00 00 33 C9 3B 4D 14 1B D2 F7 DA 89 55 E4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 2C 01 00 00 33 C9 83 7D 18 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 C9 00 00 00 8B 45 F8 3B 45 F0 0F 87 BB 00 00 00 8B 4D 10 D1 E9 89 4D F4 0F 84 85 00 00 00 8B 55 10 83 E2 01 74 08 8B 45 F4 89 45 D8 EB 09 8B 4D F4 83 E9 01 89 4D D8 8B 55 D8 0F AF 55 14 03 55 F8 89 55 FC 8B 45 FC 50 8B 4D 08 51 FF 55 18 83 C4 08 89 45 EC 83 7D EC 00 75 07 8B 45 FC EB 6D EB 3F 83 7D EC 00 7D 2A 8B 55 FC 2B 55 14 89 55 F0 8B 45 10 83 E0 01 74 08 8B 4D F4 89 4D D4 EB 09 8B 55 F4 83 EA 01 89 55 D4 8B 45 D4 89 45 10 EB 0F 8B 4D FC 03 4D 14 89 4D F8 8B 55 F4 89 55 10 EB 23 83 7D 10 00 74 1B 8B 45 F8 50 8B 4D 08 51 FF 55 18 83 C4 08 F7 D8 1B C0 F7 D0 23 45 F8 EB 0B EB 02 EB 05 E9 39 FF FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "_mainCRTStartup"
		size = 17
		refs = "0006 ___security_init_cookie 000b ___tmainCRTStartup"
		altNames = "_WinMainCRTStartup _wWinMainCRTStartup _wmainCRTStartup"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_67_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 398
		refs = "0008 __sehtable$___tmainCRTStartup 000d __except_handler4 001f ___security_cookie 003d _check_managed_app 0047 __heap_init 0055 _fast_error_exit 005d __mtinit 0072 __CrtSetCheckCount 007a __RTC_Initialize 0086 __ioinit 0091 __amsg_exit 009a __imp__GetCommandLineA@0 009f __acmdln 00a4 ___crtGetEnvironmentStringsA 00a9 __aenvptr 00ae __setargv 00c1 __setenvp 00d6 __cinit 00f4 __environ 00fa ___initenv 0106 ___argv 010d ___argc 0113 _main 0128 _exit 012d __cexit 014d __XcptFilter 0169 __exit 016e __c_exit"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 DC 00 00 00 00 E8 ?? ?? ?? ?? 89 45 E0 6A 01 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 83 7D E4 00 74 0C 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 A1 ?? ?? ?? ?? 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 DC 83 7D E0 00 75 09 8B 55 DC 52 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 3F 8B 45 EC 8B 08 8B 11 89 55 D8 8B 45 EC 50 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 55 D8 89 55 DC 83 7D E0 00 75 09 8B 45 DC 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_67_2_0 {
	meta:
		name = "_fast_error_exit"
		size = 46
		refs = "0007 ___error_mode 000f __FF_MSGBANNER 0018 __NMSG_WRITE 0025 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 02 74 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_67_3_0 {
	meta:
		name = "_check_managed_app"
		size = 116
		refs = "000b ___ImageBase"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 FC ?? ?? ?? ?? 83 7D FC 00 74 0E 8B 45 FC 0F B7 08 81 F9 4D 5A 00 00 74 04 33 C0 EB 49 8B 55 FC 8B 45 FC 03 42 3C 89 45 F8 8B 4D F8 81 39 50 45 00 00 74 04 33 C0 EB 2E 8B 55 F8 0F B7 42 18 3D 0B 01 00 00 74 04 33 C0 EB 1C 8B 4D F8 83 79 74 0E 77 04 33 C0 EB 0F 8B 55 F8 33 C0 83 BA E8 00 00 00 00 0F 95 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__setjmp"
		size = 56
		refs = "001a __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 06 8B 40 0C 89 42 1C 2B C0 C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__output_l"
		size = 4796
		refs = "000c ___security_cookie 0051 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0075 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0081 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0088 __CrtDbgReportW 009f __errno 00b6 ??_C@_1BE@IONLIDNC@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAl?$AA?$AA@ 00c0 __invalid_parameter 00d5 ??1_LocaleUpdate@@QAE@XZ 0107 __fileno 013e ___pioinfo 0150 ___badioinfo 01ea ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0272 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 035c ___lookuptable 03c0 $LN165 03cf ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 03dd __isleadbyte_l 0400 _write_char 0431 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0521 $LN161 0528 $LN166 0579 _get_int_arg 0636 $LN162 063d $LN167 0771 $LN163 0778 $LN168 07ac _get_short_arg 07d3 _wctomb_s 084f ___nullstring 085b _strlen 091a ___wnullstring 09eb __get_printf_count_output 0a27 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0b48 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0b59 __malloc_dbg 0bcb __cfltcvt_tab 0bd1 __decode_pointer 0d0a _get_int64_arg 0ed7 __aullrem 0ef9 __aulldiv 1000 _write_multi_char 101b _write_string 117b __free_dbg 11ae @__security_check_cookie@4 11b8 $NORMAL_STATE$29376 11bc $LN130 11c0 $LN129 11c4 $LN121 11c8 $LN117 11cc $LN116 11d0 $LN112 11d4 $LN96 11d8 $LN124 11dc $LN123 11e0 $LN125 11e4 $LN126 11e8 $LN122 11ec $LN127 1204 $LN106 1208 $LN98 120c $LN109 1210 $LN97 1214 $LN110 1248 $LN65 124c $LN93 1250 $LN81 1254 $LN47 1258 $LN87 125c $LN64 1260 $LN91 1264 $LN52 1268 $LN70 126c $LN42 1270 $LN48 1274 $LN79 1278 $LN50 127c $LN45 1280 $LN94"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 18 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FD FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 10 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 28 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 28 FD FF FF E9 C4 10 00 00 8B 45 08 89 85 98 FD FF FF 8B 8D 98 FD FF FF 8B 51 0C 83 E2 40 0F 85 CB 00 00 00 8B 85 98 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 94 FD FF FF 83 BD 94 FD FF FF FF 74 2D 83 BD 94 FD FF FF FE 74 24 8B 8D 94 FD FF FF C1 F9 05 8B 95 94 FD FF FF 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 95 10 FD FF FF EB 0A C7 85 10 FD FF FF ?? ?? ?? ?? 8B 85 10 FD FF FF 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 56 83 BD 94 FD FF FF FF 74 2D 83 BD 94 FD FF FF FE 74 24 8B 85 94 FD FF FF C1 F8 05 8B 8D 94 FD FF FF 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 8D 0C FD FF FF EB 0A C7 85 0C FD FF FF ?? ?? ?? ?? 8B 95 0C FD FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 08 FD FF FF 00 00 00 00 EB 0A C7 85 08 FD FF FF 01 00 00 00 8B 95 08 FD FF FF 89 95 90 FD FF FF 83 BD 90 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 90 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 24 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 24 FD FF FF E9 4F 0F 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 8D 8C FD FF FF 83 BD 8C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 8C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 20 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 20 FD FF FF E9 C7 0E 00 00 C7 85 B4 FD FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FD FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 45 0C 8A 08 88 8D AF FD FF FF 0F BE 95 AF FD FF FF 8B 45 0C 83 C0 01 89 45 0C 85 D2 0F 84 61 0E 00 00 83 BD B4 FD FF FF 00 0F 8C 54 0E 00 00 0F BE 8D AF FD FF FF 83 F9 20 7C 25 0F BE 95 AF FD FF FF 83 FA 78 7F 19 0F BE 85 AF FD FF FF 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 04 FD FF FF EB 0A C7 85 04 FD FF FF 00 00 00 00 8B 95 04 FD FF FF 89 95 B0 FD FF FF 8B 85 B0 FD FF FF 8B 8D A4 FD FF FF 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 95 A4 FD FF FF 8B 85 A4 FD FF FF 89 85 00 FD FF FF 83 BD 00 FD FF FF 07 0F 87 D2 0D 00 00 8B 8D 00 FD FF FF FF 24 8D ?? ?? ?? ?? C7 45 F4 00 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 50 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B4 00 00 00 8D 85 B4 FD FF FF 50 8B 4D 08 51 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8A 08 88 8D AF FD FF FF 8B 55 0C 83 C2 01 89 55 0C 0F BE 85 AF FD FF FF F7 D8 1B C0 F7 D8 89 85 88 FD FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 88 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 1C FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 1C FD FF FF E9 08 0D 00 00 8D 95 B4 FD FF FF 52 8B 45 08 50 0F B6 8D AF FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C E9 C9 0C 00 00 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D8 8B 45 D8 89 45 E8 8B 4D E8 89 4D E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 96 0C 00 00 0F BE 95 AF FD FF FF 89 95 FC FC FF FF 8B 85 FC FC FF FF 83 E8 20 89 85 FC FC FF FF 83 BD FC FC FF FF 10 77 4B 8B 8D FC FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 F0 83 C8 04 89 45 F0 EB 2C 8B 4D F0 83 C9 01 89 4D F0 EB 21 8B 55 F0 83 CA 02 89 55 F0 EB 16 8B 45 F0 0D 80 00 00 00 89 45 F0 EB 09 8B 4D F0 83 C9 08 89 4D F0 E9 21 0C 00 00 0F BE 95 AF FD FF FF 83 FA 2A 75 28 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 4D F0 83 C9 04 89 4D F0 8B 55 E8 F7 DA 89 55 E8 EB 14 8B 45 E8 6B C0 0A 0F BE 8D AF FD FF FF 8D 54 08 D0 89 55 E8 E9 D4 0B 00 00 C7 45 D0 00 00 00 00 E9 C8 0B 00 00 0F BE 85 AF FD FF FF 83 F8 2A 75 1E 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 55 D0 6B D2 0A 0F BE 85 AF FD FF FF 8D 4C 02 D0 89 4D D0 E9 85 0B 00 00 0F BE 95 AF FD FF FF 89 95 F8 FC FF FF 8B 85 F8 FC FF FF 83 E8 49 89 85 F8 FC FF FF 83 BD F8 FC FF FF 2E 0F 87 0D 01 00 00 8B 8D F8 FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 0F BE 08 83 F9 6C 75 16 8B 55 0C 83 C2 01 89 55 0C 8B 45 F0 0D 00 10 00 00 89 45 F0 EB 09 8B 4D F0 83 C9 10 89 4D F0 E9 CA 00 00 00 8B 55 0C 0F BE 02 83 F8 36 75 26 8B 4D 0C 0F BE 51 01 83 FA 34 75 1A 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 C9 00 80 00 00 89 4D F0 E9 81 00 00 00 8B 55 0C 0F BE 02 83 F8 33 75 23 8B 4D 0C 0F BE 51 01 83 FA 32 75 17 8B 45 0C 83 C0 02 89 45 0C 8B 4D F0 81 E1 FF 7F FF FF 89 4D F0 EB 53 8B 55 0C 0F BE 02 83 F8 64 74 37 8B 4D 0C 0F BE 11 83 FA 69 74 2C 8B 45 0C 0F BE 08 83 F9 6F 74 21 8B 55 0C 0F BE 02 83 F8 75 74 16 8B 4D 0C 0F BE 11 83 FA 78 74 0B 8B 45 0C 0F BE 08 83 F9 58 75 02 EB 0F C7 85 A4 FD FF FF 00 00 00 00 E9 A2 FC FF FF EB 16 8B 55 F0 83 CA 20 89 55 F0 EB 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 E9 4A 0A 00 00 0F BE 8D AF FD FF FF 89 8D F4 FC FF FF 8B 95 F4 FC FF FF 83 EA 41 89 95 F4 FC FF FF 83 BD F4 FC FF FF 37 0F 87 1B 08 00 00 8B 85 F4 FC FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 F0 81 E2 30 08 00 00 75 0B 8B 45 F0 0D 00 08 00 00 89 45 F0 8B 4D F0 81 E1 10 08 00 00 74 55 C7 85 84 FD FF FF 00 00 00 00 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FD FF FF 0F B7 85 A8 FD FF FF 50 68 00 02 00 00 8D 8D B8 FD FF FF 51 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 84 FD FF FF 83 BD 84 FD FF FF 00 74 07 C7 45 D8 01 00 00 00 EB 26 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 80 FD FF FF 8A 8D 80 FD FF FF 88 8D B8 FD FF FF C7 45 DC 01 00 00 00 8D 95 B8 FD FF FF 89 55 FC E9 5D 07 00 00 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 7C FD FF FF 83 BD 7C FD FF FF 00 74 0C 8B 8D 7C FD FF FF 83 79 04 00 75 1A 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 50 8B 4D F0 81 E1 00 08 00 00 74 26 8B 95 7C FD FF FF 8B 42 04 89 45 FC 8B 8D 7C FD FF FF 0F BF 01 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 95 7C FD FF FF 8B 42 04 89 45 FC 8B 8D 7C FD FF FF 0F BF 11 89 55 DC E9 C7 06 00 00 8B 45 F0 25 30 08 00 00 75 0C 8B 4D F0 81 C9 00 08 00 00 89 4D F0 83 7D D0 FF 75 0C C7 85 F0 FC FF FF FF FF FF 7F EB 09 8B 55 D0 89 95 F0 FC FF FF 8B 85 F0 FC FF FF 89 85 74 FD FF FF 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F0 81 E2 10 08 00 00 74 65 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC C7 45 F4 01 00 00 00 8B 4D FC 89 8D 70 FD FF FF 8B 95 74 FD FF FF 8B 85 74 FD FF FF 83 E8 01 89 85 74 FD FF FF 85 D2 74 1E 8B 8D 70 FD FF FF 0F B7 11 85 D2 74 11 8B 85 70 FD FF FF 83 C0 02 89 85 70 FD FF FF EB C9 8B 8D 70 FD FF FF 2B 4D FC D1 F9 89 4D DC EB 5B 83 7D FC 00 75 09 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 89 85 78 FD FF FF 8B 8D 74 FD FF FF 8B 95 74 FD FF FF 83 EA 01 89 95 74 FD FF FF 85 C9 74 1E 8B 85 78 FD FF FF 0F BE 08 85 C9 74 11 8B 95 78 FD FF FF 83 C2 01 89 95 78 FD FF FF EB C9 8B 85 78 FD FF FF 2B 45 FC 89 45 DC E9 AB 05 00 00 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 6C FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 D2 74 0C C7 85 EC FC FF FF 01 00 00 00 EB 0A C7 85 EC FC FF FF 00 00 00 00 8B 85 EC FC FF FF 89 85 68 FD FF FF 83 BD 68 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 68 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 18 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 18 FD FF FF E9 12 07 00 00 E9 E8 04 00 00 8B 55 F0 83 E2 20 74 12 8B 85 6C FD FF FF 66 8B 8D B4 FD FF FF 66 89 08 EB 0E 8B 95 6C FD FF FF 8B 85 B4 FD FF FF 89 02 C7 45 D8 01 00 00 00 E9 B4 04 00 00 C7 45 D4 01 00 00 00 0F BE 8D AF FD FF FF 83 C1 20 88 8D AF FD FF FF 8B 55 F0 83 CA 40 89 55 F0 8D 85 B8 FD FF FF 89 45 FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F BE 8D AF FD FF FF 83 F9 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 42 68 DA 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 D0 81 C2 5D 01 00 00 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 14 8B 45 E0 89 45 FC 8B 4D D0 81 C1 5D 01 00 00 89 4D BC EB 07 C7 45 D0 A3 00 00 00 8B 55 14 83 C2 08 89 55 14 8B 45 14 8B 48 F8 8B 50 FC 89 8D 60 FD FF FF 89 95 64 FD FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 D4 50 8B 4D D0 51 0F BE 95 AF FD FF FF 52 8B 45 BC 50 8B 4D FC 51 8D 95 60 FD FF FF 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 1C 8B 4D F0 81 E1 80 00 00 00 74 26 83 7D D0 00 75 20 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 FC 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 0F BE 8D AF FD FF FF 83 F9 67 75 2C 8B 55 F0 81 E2 80 00 00 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 8B 55 FC 0F BE 02 83 F8 2D 75 15 8B 4D F0 81 C9 00 01 00 00 89 4D F0 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 09 03 00 00 8B 4D F0 83 C9 40 89 4D F0 C7 45 F8 0A 00 00 00 EB 6F C7 45 F8 0A 00 00 00 EB 66 C7 45 D0 08 00 00 00 C7 85 A0 FD FF FF 07 00 00 00 EB 0A C7 85 A0 FD FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 55 F0 81 E2 80 00 00 00 74 17 C6 45 EC 30 8B 85 A0 FD FF FF 83 C0 51 88 45 ED C7 45 E4 02 00 00 00 EB 1E C7 45 F8 08 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 0C 8B 55 F0 81 CA 00 02 00 00 89 55 F0 8B 45 F0 25 00 80 00 00 74 1D 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 50 FD FF FF 89 95 54 FD FF FF E9 AF 00 00 00 8B 55 F0 81 E2 00 10 00 00 74 1D 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 50 FD FF FF 89 95 54 FD FF FF E9 87 00 00 00 8B 4D F0 83 E1 20 74 42 8B 55 F0 83 E2 40 74 1C 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 98 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 1C 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 3D 8B 55 F0 83 E2 40 74 1B 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 50 FD FF FF 89 95 54 FD FF FF EB 1A 8D 4D 14 51 E8 ?? ?? ?? ?? 83 C4 04 33 D2 89 85 50 FD FF FF 89 95 54 FD FF FF 8B 45 F0 83 E0 40 74 40 83 BD 54 FD FF FF 00 7F 37 7C 09 83 BD 50 FD FF FF 00 73 2C 8B 8D 50 FD FF FF F7 D9 8B 95 54 FD FF FF 83 D2 00 F7 DA 89 8D 48 FD FF FF 89 95 4C FD FF FF 8B 45 F0 0D 00 01 00 00 89 45 F0 EB 18 8B 8D 50 FD FF FF 89 8D 48 FD FF FF 8B 95 54 FD FF FF 89 95 4C FD FF FF 8B 45 F0 25 00 80 00 00 75 26 8B 4D F0 81 E1 00 10 00 00 75 1B 8B 95 48 FD FF FF 8B 85 4C FD FF FF 83 E0 00 89 95 48 FD FF FF 89 85 4C FD FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 4D F0 83 E1 F7 89 4D F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 95 48 FD FF FF 0B 95 4C FD FF FF 75 07 C7 45 E4 00 00 00 00 8D 45 B7 89 45 FC 8B 4D D0 8B 55 D0 83 EA 01 89 55 D0 85 C9 7F 0E 8B 85 48 FD FF FF 0B 85 4C FD FF FF 74 7B 8B 45 F8 99 52 50 8B 8D 4C FD FF FF 51 8B 95 48 FD FF FF 52 E8 ?? ?? ?? ?? 83 C0 30 89 85 5C FD FF FF 8B 45 F8 99 52 50 8B 85 4C FD FF FF 50 8B 8D 48 FD FF FF 51 E8 ?? ?? ?? ?? 89 85 48 FD FF FF 89 95 4C FD FF FF 83 BD 5C FD FF FF 39 7E 12 8B 95 5C FD FF FF 03 95 A0 FD FF FF 89 95 5C FD FF FF 8B 45 FC 8A 8D 5C FD FF FF 88 08 8B 55 FC 83 EA 01 89 55 FC E9 67 FF FF FF 8D 45 B7 2B 45 FC 89 45 DC 8B 4D FC 83 C1 01 89 4D FC 8B 55 F0 81 E2 00 02 00 00 74 29 83 7D DC 00 74 0B 8B 45 FC 0F BE 08 83 F9 30 74 18 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC C6 00 30 8B 4D DC 83 C1 01 89 4D DC 83 7D D8 00 0F 85 E1 01 00 00 8B 55 F0 83 E2 40 74 3F 8B 45 F0 25 00 01 00 00 74 0D C6 45 EC 2D C7 45 E4 01 00 00 00 EB 28 8B 4D F0 83 E1 01 74 0D C6 45 EC 2B C7 45 E4 01 00 00 00 EB 13 8B 55 F0 83 E2 02 74 0B C6 45 EC 20 C7 45 E4 01 00 00 00 8B 45 E8 2B 45 DC 2B 45 E4 89 85 44 FD FF FF 8B 4D F0 83 E1 0C 75 1C 8D 95 B4 FD FF FF 52 8B 45 08 50 8B 8D 44 FD FF FF 51 6A 20 E8 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__filelengthi64"
		size = 654
		refs = "0008 __sehtable$__filelengthi64 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0044 __errno 0064 __nhandle 0087 ??_C@_1HC@KFLBHHBC@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAe?$AAd@ 0090 ??_C@_1GC@GCAOLCHH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0097 __CrtDbgReportW 00ca ??_C@_1BO@FPPOBOJI@?$AA_?$AAf?$AAi?$AAl?$AAe?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AAi?$AA6?$AA4?$AA?$AA@ 00d4 __invalid_parameter 00f8 ___pioinfo 0110 ??_C@_1DG@LNNHNFHJ@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0174 ___lock_fhandle 01ad __lseeki64_nolock 023e ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 026e __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 DC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 21 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF 83 CA FF E9 23 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 83 CA FF E9 96 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 D0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 83 CA FF E9 0D 01 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 73 6A 01 6A 00 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 89 55 E4 8B 55 E0 23 55 E4 83 FA FF 75 10 C7 45 D8 FF FF FF FF C7 45 DC FF FF FF FF EB 3E 6A 02 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 D8 89 55 DC 8B 4D E0 3B 4D D8 75 08 8B 55 E4 3B 55 DC 74 16 6A 00 8B 45 E4 50 8B 4D E0 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 EB 46 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 D8 FF FF FF FF C7 45 DC FF FF FF FF 33 C0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D8 8B 55 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__wmakepath"
		size = 37
		refs = "001c __wmakepath_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "__makepath"
		size = 37
		refs = "001c __makepath_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "__crt_waiting_on_module_handle"
		size = 83
		refs = "0022 __imp__Sleep@4 002c __imp__GetModuleHandleW@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 F8 E8 03 00 00 C7 45 FC 00 00 00 00 83 7D FC 00 75 30 8B 45 F8 50 FF 15 ?? ?? ?? ?? 8B 4D 08 51 FF 15 ?? ?? ?? ?? 89 45 FC 8B 55 F8 81 C2 E8 03 00 00 89 55 F8 81 7D F8 60 EA 00 00 76 02 EB 02 EB CA 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "__cinit"
		size = 157
		refs = "0008 __FPinit 0015 __IsNonwritableInCurrentImage 002e __initp_misc_cfltcvt_tab 0033 ___xi_z 0038 ___xi_a 003d __initterm_e 0053 __RTC_Terminate 0058 _atexit 0060 ___xc_z 0065 ___xc_a 006a __initterm 0073 ___dyn_tls_init_callback"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 3D ?? ?? ?? ?? 00 74 1E 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0D 8B 45 08 50 FF 15 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 47 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 74 1D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0C 6A 00 6A 02 6A 00 FF 15 ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_2_0 {
	meta:
		name = "_exit"
		size = 23
		refs = "000e _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_73_3_0 {
	meta:
		name = "__exit"
		size = 23
		refs = "000e _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_73_4_0 {
	meta:
		name = "__cexit"
		size = 21
		refs = "000c _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_73_5_0 {
	meta:
		name = "__c_exit"
		size = 21
		refs = "000c _doexit"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_73_6_0 {
	meta:
		name = "__amsg_exit"
		size = 56
		refs = "0007 __FF_MSGBANNER 0010 __NMSG_WRITE 0019 __aexit_rtn 001f __decode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 68 FF 00 00 00 FF 55 FC 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_7_0 {
	meta:
		name = "___freeCrtMemory"
		size = 323
		refs = "0007 __wenviron 0030 __free_dbg 0055 __environ 00a5 ___wargv 00b6 ___argv 00c7 ___onexitbegin 00cd __decode_pointer 00f2 __encoded_null 00fc ___ptmbcinfo 0103 __imp__InterlockedDecrement@4 0111 ___initialmbcinfo 013b __imp__InterlockedIncrement@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 83 7D FC 00 74 1A 8B 55 FC 83 3A 00 74 12 6A 02 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB D7 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 A1 ?? ?? ?? ?? 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 83 7D FC 00 74 1A 8B 55 FC 83 3A 00 74 12 6A 02 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 EB D7 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 6A 02 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 27 81 3D ?? ?? ?? ?? ?? ?? ?? ?? 74 1B 6A 02 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 08 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_8_0 {
	meta:
		name = "_doexit"
		size = 505
		refs = "0008 __sehtable$_doexit 000d __except_handler4 001f ___security_cookie 0033 __lockexit 0040 __C_Exit_Done 004d __C_Termination_Done 0059 __exitflag 0069 ___onexitbegin 006f __decode_pointer 0085 ___onexitend 00d5 __encoded_null 015b ___xp_z 0160 ___xp_a 0165 __initterm 016d ___xt_z 0172 ___xt_a 0180 ?fExit@?1??doexit@@9@9 018a __CrtSetDbgFlag 01a1 ___freeCrtMemory 01a6 __CrtDumpMemoryLeaks 01bf __unlockexit 01e0 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 DC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 01 0F 84 5F 01 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 8A 45 10 A2 ?? ?? ?? ?? 83 7D 0C 00 0F 85 05 01 00 00 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 83 7D E4 00 0F 84 D7 00 00 00 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 C7 45 DC 00 00 00 00 8B 45 E4 89 45 D4 8B 4D D8 89 4D E0 BA 01 00 00 00 85 D2 0F 84 A5 00 00 00 C7 45 D0 00 00 00 00 C7 45 CC 00 00 00 00 8B 45 D8 83 E8 04 89 45 D8 8B 4D D8 3B 4D E4 72 0E E8 ?? ?? ?? ?? 8B 55 D8 39 02 75 02 EB E1 8B 45 D8 3B 45 E4 73 02 EB 6E 8B 4D D8 8B 11 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E8 ?? ?? ?? ?? 8B 4D D8 89 01 FF 55 DC 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 CC 8B 4D D4 3B 4D D0 75 08 8B 55 E0 3B 55 CC 74 18 8B 45 D0 89 45 D4 8B 4D D4 89 4D E4 8B 55 CC 89 55 E0 8B 45 E0 89 45 D8 E9 4E FF FF FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 83 3D ?? ?? ?? ?? 00 75 23 6A FF E8 ?? ?? ?? ?? 83 C4 04 83 E0 20 74 14 C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0C 83 7D 10 00 74 05 E8 ?? ?? ?? ?? C3 83 7D 10 00 74 02 EB 1B C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_9_0 {
	meta:
		name = "___crtCorExitProcess"
		size = 63
		refs = "0009 ??_C@_1BI@BGOHAHKC@?$AAm?$AAs?$AAc?$AAo?$AAr?$AAe?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 000f __imp__GetModuleHandleW@4 001d ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 0027 __imp__GetProcAddress@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 1F 68 ?? ?? ?? ?? 8B 45 FC 50 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 07 8B 4D 08 51 FF 55 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_10_0 {
	meta:
		name = "___crtExitProcess"
		size = 29
		refs = "000a ___crtCorExitProcess 0017 __imp__ExitProcess@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_73_11_0 {
	meta:
		name = "__lockexit"
		size = 17
		refs = "0008 __lock"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_73_12_0 {
	meta:
		name = "__unlockexit"
		size = 17
		refs = "0008 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A 08 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_73_13_0 {
	meta:
		name = "__init_pointers"
		size = 132
		refs = "0007 __encoded_null 0013 __initp_heap_handler 001f __initp_misc_initcrit 002b __initp_misc_invarg 0037 __initp_misc_purevirt 0043 __initp_misc_rand_s 004f __initp_misc_winsig 005b __initp_misc_winxfltr 0067 __initp_eh_hooks 006f __exit 0074 __encode_pointer 007c __aexit_rtn"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_14_0 {
	meta:
		name = "__initterm"
		size = 41
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 3B 45 0C 73 1A 8B 4D 08 83 39 00 74 07 8B 55 08 8B 02 FF D0 8B 4D 08 83 C1 04 89 4D 08 EB DE 5D C3 }
	condition:
		$1
}

rule file_73_15_0 {
	meta:
		name = "__initterm_e"
		size = 63
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 08 3B 45 0C 73 23 83 7D FC 00 75 1D 8B 4D 08 83 39 00 74 0A 8B 55 08 8B 02 FF D0 89 45 FC 8B 4D 08 83 C1 04 89 4D 08 EB D5 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_16_0 {
	meta:
		name = "__get_wpgmptr"
		size = 238
		refs = "001b ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0027 ??_C@_1GC@DGCPEDNJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW 0042 __errno 0059 ??_C@_1BK@PNLDCCDP@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 0063 __invalid_parameter 0075 __wpgmptr 0087 ??_C@_1CC@CDIPMFPD@?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D3 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D3 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D7 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D7 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_17_0 {
	meta:
		name = "__get_pgmptr"
		size = 238
		refs = "001b ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0027 ??_C@_1GC@DGCPEDNJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW 0042 __errno 0059 ??_C@_1BI@COAAPHJK@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 0063 __invalid_parameter 0075 __pgmptr 0087 ??_C@_1CA@BBNAFCKO@?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F1 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F1 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F5 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F5 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "___libm_sse2_asin"
		size = 1097
		refs = "0007 _ABSVALMASK 000f _ONEMASK 0021 _TMASK 0089 _T_table 0096 _Tbl_addr 00c2 _cv 00d6 _SIGNMASK 014b _HALFMASK2 01a2 _PI_BY_2 025d _cv2 02c4 _ONE_BY_2"
	strings:
		$1 = { 83 EC 0C 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 BE 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E C6 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 54 15 ?? ?? ?? ?? F2 0F 10 D9 F2 0F 59 C9 66 0F 12 35 ?? ?? ?? ?? 83 C4 0C F2 0F 59 D9 F2 0F 59 F9 F2 0F 59 EB 66 0F 57 E2 F2 0F 59 D9 F2 0F 58 F7 F2 0F 59 F3 F2 0F 58 EC 66 0F 70 E4 EE F2 0F 58 F5 66 0F 56 E2 F2 0F 58 C6 F2 0F 58 C4 C3 2D BB 03 00 00 83 F8 43 0F 83 18 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 8B C2 66 0F 54 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F 10 C8 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C CF F2 0F 59 FF F2 0F 58 C6 F2 0F 5C E7 F2 0F 59 C1 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 66 0F 28 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 5C 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 25 00 00 08 00 C1 E8 04 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB 83 C4 0C 66 0F C4 F0 03 F2 0F 58 C5 F2 0F 10 EC 66 0F 70 DB EE F2 0F 5C E3 F2 0F 58 DC F2 0F 5C EB F2 0F 5C C5 F2 0F 5C C4 66 0F 56 C6 C3 05 BB 3B 00 00 3D 00 38 00 00 73 5D 66 0F 14 FF 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 F7 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 83 C4 0C 66 0F 59 FF 66 0F 59 F7 66 0F 59 CF 66 0F 59 FF F2 0F 10 DE F2 0F 59 F6 66 0F 58 CA 66 0F 59 E7 F2 0F 59 F3 66 0F 58 CC 66 0F 59 CE 66 0F 70 D1 EE F2 0F 58 CA F2 0F 58 C1 C3 2D FE 3B 00 00 83 F8 02 0F 83 BB 00 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 5C D9 F2 0F 59 E3 66 0F 28 0D ?? ?? ?? ?? 66 0F 70 FC 44 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 59 DF 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FD 66 0F 58 D3 F2 0F 59 D7 66 0F 59 D5 F2 0F 58 E4 66 0F 70 EE EE 66 0F 70 DC 44 F2 0F 5C E5 F2 0F 58 EC F2 0F 5C EB 66 0F 59 D3 F2 0F 58 EE 66 0F 57 F6 66 0F 70 C2 EE F2 0F 5C D5 83 C4 0C F2 0F 58 C2 25 00 80 00 00 35 00 80 00 00 66 0F C4 F0 03 F2 0F 58 C4 66 0F 57 C6 C3 05 FE FE 03 00 3D 00 FF 03 00 0F 82 8A 00 00 00 66 0F 7E C1 66 0F 73 D0 20 66 0F 7E C2 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 74 41 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 7D 42 83 C4 0C 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 C3 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 58 C2 66 0F 55 CF 66 0F 56 C1 C3 66 0F 12 44 24 04 66 0F 57 F6 F2 0F 10 F8 83 C4 0C 66 0F C5 D0 03 81 E2 F0 7F 00 00 83 EA 10 81 FA E0 7F 00 00 72 0C F2 0F 58 F0 66 0F 56 C6 F2 0F 59 F8 C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__wcsnicoll_l"
		size = 674
		refs = "0028 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0031 ??_C@_1GE@LDEPDFMO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0038 __CrtDbgReportW 004c __errno 0060 ??_C@_1BK@EONLMOKH@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 006a __invalid_parameter 008e ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f4 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 014f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0157 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0217 ??1_LocaleUpdate@@QAE@XZ 025b ___crtCompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C 83 7D 10 00 75 07 33 C0 E9 89 02 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 43 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 43 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 23 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 BD 01 00 00 B9 FF FF FF 7F 3B 4D 10 1B D2 83 C2 01 89 55 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 57 01 00 00 8B 4D 14 51 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 10 83 7A 10 00 0F 85 B9 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 C8 EB 09 8B 45 08 0F B7 08 89 4D C8 66 8B 55 C8 66 89 55 DC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 C4 EB 09 8B 45 0C 0F B7 08 89 4D C4 66 8B 55 C4 66 89 55 D8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 10 83 EA 01 89 55 10 74 18 0F B7 45 DC 85 C0 74 10 0F B7 4D DC 0F B7 55 D8 3B CA 0F 84 61 FF FF FF 0F B7 45 DC 0F B7 4D D8 2B C1 89 45 D4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 EB 7E 8D 4D EC E8 ?? ?? ?? ?? 8B 10 8B 42 08 50 8B 4D 10 51 8B 55 0C 52 8B 45 10 50 8B 4D 08 51 68 01 10 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 10 8B 42 10 50 8D 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 D0 FF FF FF 7F 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D0 EB 14 8B 4D FC 83 E9 02 89 4D CC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_4_0 {
	meta:
		name = "__wcsnicoll"
		size = 526
		refs = "000a ___locale_changed 0028 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0031 ??_C@_1GE@LDEPDFMO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0038 __CrtDbgReportW 004c __errno 0060 ??_C@_1BG@PCPANGGF@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 006a __invalid_parameter 008e ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f4 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0203 __wcsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 3D ?? ?? ?? ?? 00 0F 85 DF 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 75 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 75 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 8F 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 76 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 76 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 29 01 00 00 B9 FF FF FF 7F 3B 4D 10 1B D2 83 C2 01 89 55 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 77 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 77 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 C3 00 00 00 8B 4D 08 0F B7 11 83 FA 41 7C 19 8B 45 08 0F B7 08 83 F9 5A 7F 0E 8B 55 08 0F B7 02 83 C0 20 89 45 E8 EB 09 8B 4D 08 0F B7 11 89 55 E8 66 8B 45 E8 66 89 45 FC 8B 4D 0C 0F B7 11 83 FA 41 7C 19 8B 45 0C 0F B7 08 83 F9 5A 7F 0E 8B 55 0C 0F B7 02 83 C0 20 89 45 E4 EB 09 8B 4D 0C 0F B7 11 89 55 E4 66 8B 45 E4 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 8B 45 10 83 E8 01 89 45 10 74 18 0F B7 4D FC 85 C9 74 10 0F B7 55 FC 0F B7 45 F8 3B D0 0F 84 61 FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 EB 18 EB 16 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__mbsrev_l"
		size = 491
		refs = "001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0034 ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 003d ??_C@_1GA@IFCJEOBP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0044 __CrtDbgReportW 0058 __errno 006c ??_C@_1BE@HMKMJMHA@?$AA_?$AAm?$AAb?$AAs?$AAr?$AAe?$AAv?$AA_?$AAl?$AA?$AA@ 0076 __invalid_parameter 0088 ??1_LocaleUpdate@@QAE@XZ 0098 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00aa __strrev 013d ??_C@_1FE@OKOAGNBP@?$AA?$CI?$AA?$CC?$AAB?$AAa?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAi?$AAn?$AAt?$AAo?$AA?5?$AA_?$AAm@ 0163 ??_C@_1BK@NHCDBJID@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$DO?$AAs?$AAt?$AAa?$AAr?$AAt?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 56 8B 45 08 89 45 F8 8B 4D 08 89 4D FC 8B 55 0C 52 8D 4D E4 E8 ?? ?? ?? ?? 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 DC E9 52 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 1F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 E9 22 01 00 00 8B 4D 08 0F B6 11 85 D2 0F 84 C4 00 00 00 8B 45 08 0F B6 30 8D 4D E4 E8 ?? ?? ?? ?? 8B 48 04 0F B6 54 31 1D 83 E2 04 8B 45 08 83 C0 01 89 45 08 85 D2 0F 84 95 00 00 00 8B 4D 08 0F B6 11 85 D2 74 27 8B 45 08 8A 08 88 4D F7 8B 55 08 8B 45 08 8A 48 FF 88 0A 8B 55 08 8A 45 F7 88 42 FF 8B 4D 08 83 C1 01 89 4D 08 EB 64 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 08 3B 4D F8 77 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 83 E8 01 89 45 08 8B 4D 08 C6 01 00 EB 05 E9 2E FF FF FF 8B 55 08 83 EA 01 89 55 08 8B 45 FC 3B 45 08 73 2E 8B 4D FC 8A 11 88 55 F7 8B 45 FC 8B 4D 08 8A 11 88 10 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8A 55 F7 88 11 8B 45 08 83 E8 01 89 45 08 EB CA 8B 4D F8 89 4D D4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "?set_new_handler@@YAP6AXXZP6AXXZ@Z"
		size = 45
		refs = "000e ??_C@_1GG@JDHHLGNI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0013 ??_C@_1BG@DCNCEIOF@?$AAn?$AAe?$AAw?$AA_?$AAp?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0018 __wassert 0022 ?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 14 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 33 C0 5D C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "_div"
		size = 38
		altNames = "_ldiv"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 99 F7 7D 0C 89 45 F8 8B 45 08 99 F7 7D 0C 89 55 FC 8B 45 F8 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__CIlog10_pentium4"
		size = 656
		refs = "0039 emask 0041 CC 0049 One 0051 Magic 0059 hi_mask 0077 CB_Tbl 007f T_Tbl 00e1 coeff 010d LOG10_2 0119 place_L 0180 Zero 01cf Infs 01fa Two52 024b ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 BE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E9 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 08 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 17 FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 09 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E9 03 00 00 EB A6 8D A4 24 00 00 00 00 05 00 00 00 00 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "__read"
		size = 656
		refs = "0008 __sehtable$__read 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0044 __errno 0061 __nhandle 0084 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 008d ??_C@_1FM@NGICBHLO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0094 __CrtDbgReportW 00c7 ??_C@_1M@NHJOLLDM@?$AA_?$AAr?$AAe?$AAa?$AAd?$AA?$AA@ 00d1 __invalid_parameter 00f2 ___pioinfo 010a ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0179 ??_C@_1CC@HBLPFNKH@?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$CJ?$AA?$AA@ 01da ___lock_fhandle 0215 __read_nolock 0243 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0273 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 28 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9E 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 18 01 00 00 BA FF FF FF 7F 3B 55 10 1B C0 83 C0 01 89 45 D8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A9 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 19 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 3F E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 E4 FF FF FF FF 33 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 62 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_1_0 {
	meta:
		name = "__read_nolock"
		size = 3912
		refs = "001d ___doserrno 0028 __errno 0045 __nhandle 0068 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 0074 ??_C@_1FM@NGICBHLO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 007b __CrtDbgReportW 00b1 ??_C@_1BK@JJBHNDKJ@?$AA_?$AAr?$AAe?$AAa?$AAd?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 00bb __invalid_parameter 00dc ___pioinfo 00f4 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0169 ??_C@_1CC@HBLPFNKH@?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$CJ?$AA?$AA@ 0212 ??_C@_1CG@OHLJHGGK@?$AA?$CI?$AAi?$AAn?$AAp?$AAu?$AAt?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 02c3 ??_C@_1CC@EEOLPHGO@?$AA?$CI?$AA?$CI?$AAc?$AAn?$AAt?$AA?5?$AA?$CG?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 034c ??_C@_0CO@CEGKNHEH@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0357 __malloc_dbg 0390 __lseeki64_nolock 0628 __imp__ReadFile@20 0640 __imp__GetLastError@0 0689 __dosmaperr 0a05 __lookuptrailbytes 0b68 __imp__MultiByteToWideChar@24 0f25 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 74 56 C7 45 F4 FE FF FF FF 8B 45 10 89 45 FC 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 09 0F 00 00 83 7D 08 00 7C 14 8B 4D 08 3B 0D ?? ?? ?? ?? 73 09 C7 45 98 01 00 00 00 EB 07 C7 45 98 00 00 00 00 8B 55 98 89 55 BC 83 7D BC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 79 0E 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 01 F7 D9 1B C9 F7 D9 89 4D B8 75 21 68 ?? ?? ?? ?? 6A 00 68 85 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B8 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 68 85 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 ED 0D 00 00 B8 FF FF FF 7F 3B 45 10 1B C9 83 C1 01 89 4D B4 75 21 68 ?? ?? ?? ?? 6A 00 68 86 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B4 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 78 0D 00 00 C7 45 CC 00 00 00 00 83 7D 10 00 74 20 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 02 74 07 33 C0 E9 44 0D 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D B0 83 7D B0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B0 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CF 0C 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 44 0A 24 D0 E0 D0 F8 88 45 EB 8A 4D EB 88 4D 94 80 7D 94 01 74 0F 80 7D 94 02 0F 84 0F 01 00 00 E9 88 01 00 00 8B 55 10 83 E2 01 F7 DA 1B D2 83 C2 01 89 55 AC 75 21 68 ?? ?? ?? ?? 6A 00 68 AC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D AC 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 1E 0C 00 00 8B 4D 10 D1 E9 83 F9 04 73 09 C7 45 90 04 00 00 00 EB 08 8B 55 10 D1 EA 89 55 90 8B 45 90 89 45 10 68 B0 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 D4 83 7D D4 00 75 1E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 BE 0B 00 00 6A 01 6A 00 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 08 C1 F9 05 8B 75 08 83 E6 1F C1 E6 06 8B 0C 8D ?? ?? ?? ?? 89 44 31 28 89 54 31 2C E9 84 00 00 00 8B 55 10 83 E2 01 F7 DA 1B D2 83 C2 01 89 55 A8 75 21 68 ?? ?? ?? ?? 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D A8 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 14 0B 00 00 8B 4D 10 83 E1 FE 89 4D 10 8B 55 0C 89 55 D4 8B 45 D4 89 45 C8 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 48 0F 84 96 01 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 05 83 FA 0A 0F 84 72 01 00 00 83 7D 10 00 0F 84 68 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 45 C8 8A 4C 0A 05 88 08 8B 55 C8 83 C2 01 89 55 C8 8B 45 CC 83 C0 01 89 45 CC 8B 4D 10 83 E9 01 89 4D 10 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? C6 44 01 05 0A 0F BE 55 EB 85 D2 0F 84 07 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 25 83 F8 0A 0F 84 E3 00 00 00 83 7D 10 00 0F 84 D9 00 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 4D C8 8A 54 10 25 88 11 8B 45 C8 83 C0 01 89 45 C8 8B 4D CC 83 C1 01 89 4D CC 8B 55 10 83 EA 01 89 55 10 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? C6 44 0A 25 0A 0F BE 45 EB 83 F8 01 75 7B 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 26 83 F9 0A 74 5B 83 7D 10 00 74 55 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 55 C8 8A 44 01 26 88 02 8B 4D C8 83 C1 01 89 4D C8 8B 55 CC 83 C2 01 89 55 CC 8B 45 10 83 E8 01 89 45 10 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? C6 44 10 26 0A 6A 00 8D 4D EC 51 8B 55 10 52 8B 45 C8 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 74 0E 83 7D EC 00 7C 08 8B 55 EC 3B 55 10 76 5E FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 05 75 23 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 8B 4D DC 89 08 C7 45 F4 FF FF FF FF E9 AA 08 00 00 EB 2C 83 7D DC 6D 75 0E C7 45 F4 00 00 00 00 E9 96 08 00 00 EB 18 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F4 FF FF FF FF E9 7C 08 00 00 8B 45 CC 03 45 EC 89 45 CC 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 81 E1 80 00 00 00 0F 84 4C 08 00 00 0F BE 55 EB 83 FA 02 0F 84 EC 04 00 00 83 7D EC 00 74 45 8B 45 D4 0F BE 08 83 F9 0A 75 3A 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 CA 04 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 88 54 08 04 EB 38 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 FB 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 88 4C 02 04 8B 45 D4 89 45 D8 8B 4D D8 89 4D F8 8B 55 D4 03 55 CC 39 55 F8 0F 83 39 02 00 00 8B 45 F8 0F BE 08 83 F9 1A 0F 85 80 00 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 40 75 3A 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 C8 02 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 88 44 11 04 EB 1C 8B 55 D8 8B 45 F8 8A 08 88 0A 8B 55 D8 83 C2 01 89 55 D8 8B 45 F8 83 C0 01 89 45 F8 E9 AF 01 00 00 E9 A5 01 00 00 8B 4D F8 0F BE 11 83 FA 0D 74 21 8B 45 D8 8B 4D F8 8A 11 88 10 8B 45 D8 83 C0 01 89 45 D8 8B 4D F8 83 C1 01 89 4D F8 E9 79 01 00 00 8B 55 CC 8B 45 D4 8D 4C 10 FF 39 4D F8 73 47 8B 55 F8 0F BE 42 01 83 F8 0A 75 1A 8B 4D F8 83 C1 02 89 4D F8 8B 55 D8 C6 02 0A 8B 45 D8 83 C0 01 89 45 D8 EB 1C 8B 4D D8 8B 55 F8 8A 02 88 01 8B 4D D8 83 C1 01 89 4D D8 8B 55 F8 83 C2 01 89 55 F8 E9 23 01 00 00 8B 45 F8 83 C0 01 89 45 F8 C7 45 DC 00 00 00 00 6A 00 8D 4D EC 51 6A 01 8D 55 F3 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 00 75 06 83 7D EC 00 75 14 8B 4D D8 C6 01 0D 8B 55 D8 83 C2 01 89 55 D8 E9 BA 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 48 74 48 0F BE 4D F3 83 F9 0A 75 11 8B 55 D8 C6 02 0A 8B 45 D8 83 C0 01 89 45 D8 EB 2C 8B 4D D8 C6 01 0D 8B 55 D8 83 C2 01 89 55 D8 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 45 F3 88 44 0A 05 EB 52 8B 4D D8 3B 4D D4 75 1A 0F BE 55 F3 83 FA 0A 75 11 8B 45 D8 C6 00 0A 8B 4D D8 83 C1 01 89 4D D8 EB 30 6A 01 6A FF 6A FF 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 89 55 C4 0F BE 45 F3 83 F8 0A 74 0F 8B 4D D8 C6 01 0D 8B 55 D8 83 C2 01 89 55 D8 E9 B8 FD FF FF 8B 45 D8 2B 45 D4 89 45 CC 0F BE 4D EB 83 F9 01 0F 85 FA 01 00 00 83 7D CC 00 0F 84 F0 01 00 00 8B 55 D8 83 EA 01 89 55 D8 8B 45 D8 0F BE 08 81 E1 80 00 00 00 75 0E 8B 55 D8 83 C2 01 89 55 D8 E9 4F 01 00 00 C7 45 A4 01 00 00 00 8B 45 D8 0F B6 08 0F BE 91 ?? ?? ?? ?? 85 D2 75 22 83 7D A4 04 7F 1C 8B 45 D8 3B 45 D4 72 14 8B 4D D8 83 E9 01 89 4D D8 8B 55 A4 83 C2 01 89 55 A4 EB CD 8B 45 D8 0F B6 08 0F BE 91 ?? ?? ?? ?? 89 55 A0 83 7D A0 00 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 F4 FF FF FF FF E9 BC 04 00 00 8B 45 A0 83 C0 01 3B 45 A4 75 0E 8B 4D D8 03 4D A4 89 4D D8 E9 CF 00 00 00 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 48 0F 84 8F 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 45 D8 8A 00 88 44 0A 05 8B 4D D8 83 C1 01 89 4D D8 83 7D A4 02 7C 28 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 8B 55 D8 8A 12 88 54 01 25 8B 45 D8 83 C0 01 89 45 D8 83 7D A4 03 75 28 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 4D D8 8A 09 88 4C 10 26 8B 55 D8 83 C2 01 89 55 D8 8B 45 D8 2B 45 A4 89 45 D8 EB 1C 6A 01 8B 45 A4 F7 D8 99 52 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 89 55 C4 8B 55 D8 2B 55 D4 89 55 CC 8B 45 FC D1 E8 50 8B 4D 0C 51 8B 55 CC 52 8B 45 D4 50 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 89 45 CC 83 7D CC 00 75 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F4 FF FF FF FF E9 88 03 00 00 8B 4D D8 2B 4D D4 33 D2 39 4D CC 0F 95 C2 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 89 54 08 30 8B 4D CC D1 E1 89 4D CC E9 53 03 00 00 83 7D EC 00 74 45 8B 55 D4 0F B7 02 83 F8 0A 75 3A 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 C9 04 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 88 4C 02 04 EB 38 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 FB 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 88 44 11 04 8B 55 D4 89 55 E0 8B 45 E0 89 45 D0 8B 4D D4 03 4D CC 39 4D D0 0F 83 AC 02 00 00 8B 55 D0 0F B7 02 83 F8 1A 0F 85 82 00 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 40 75 3A 8B 55 08 C1 FA 05 8B 45 08 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 CA 02 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 88 54 08 04 EB 1E 8B 4D E0 8B 55 D0 66 8B 02 66 89 01 8B 4D E0 83 C1 02 89 4D E0 8B 55 D0 83 C2 02 89 55 D0 E9 20 02 00 00 E9 16 02 00 00 8B 45 D0 0F B7 08 83 F9 0D 74 23 8B 55 E0 8B 45 D0 66 8B 08 66 89 0A 8B 55 E0 83 C2 02 89 55 E0 8B 45 D0 83 C0 02 89 45 D0 E9 E8 01 00 00 8B 4D CC 8B 55 D4 8D 44 0A FE 39 45 D0 73 4E 8B 4D D0 0F B7 51 02 83 FA 0A 75 1F 8B 45 D0 83 C0 04 89 45 D0 B9 0A 00 00 00 8B 55 E0 66 89 0A 8B 45 E0 83 C0 02 89 45 E0 EB 1E 8B 4D E0 8B 55 D0 66 8B 02 66 89 01 8B 4D E0 83 C1 02 89 4D E0 8B 55 D0 83 C2 02 89 55 D0 E9 8B 01 00 00 8B 45 D0 83 C0 02 89 45 D0 C7 45 DC 00 00 00 00 6A 00 8D 4D EC 51 6A 02 8D 55 E4 52 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 85 C0 75 09 FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 00 75 06 83 7D EC 00 75 19 B9 0D 00 00 00 8B 55 E0 66 89 0A 8B 45 E0 83 C0 02 89 45 E0 E9 1D 01 00 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 48 0F 84 9D 00 00 00 0F B7 55 E4 83 FA 0A 75 16 B8 0A 00 00 00 8B 4D E0 66 89 01 8B 55 E0 83 C2 02 89 55 E0 EB 7C 8D 45 E4 89 45 9C B9 0D 00 00 00 8B 55 E0 66 89 0A 8B 45 E0 83 C0 02 89 45 E0 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 4D 9C 8A 09 88 4C 10 05 8B 55 9C 83 C2 01 89 55 9C 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 45 9C 8A 00 88 44 0A 25 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? C6 44 10 26 0A EB 5C 8B 4D E0 3B 4D D4 75 1F 0F B7 55 E4 83 FA 0A 75 16 B8 0A 00 00 00 8B 4D E0 66 89 01 8B 55 E0 83 C2 02 89 55 E0 EB 35 6A 01 6A FF 6A FE 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 C0 89 55 C4 0F B7 4D E4 83 F9 0A 74 14 BA 0D 00 00 00 8B 45 E0 66 89 10 8B 4D E0 83 C1 02 89 4D E0 E9 45 FD FF FF 8B 55 E0 2B 55 D4 89 55 CC 8B 45 D4 3B 45 0C 74 0C 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 04 83 7D F4 FE 75 08 8B 55 CC 89 55 8C EB 06 8B 45 F4 89 45 8C 8B 45 8C 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "__wfreopen_helper"
		size = 683
		refs = "0008 __sehtable$__wfreopen_helper 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GC@MPPLBILI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1CC@MPCNIKHO@?$AA_?$AAw?$AAf?$AAr?$AAe?$AAo?$AAp?$AAe?$AAn?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0087 __invalid_parameter 00b4 ??_C@_1CG@LINPOPAD@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 011a ??_C@_1BO@MJMKAKCJ@?$AA?$CI?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0180 ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01ff __lock_file 0220 __fclose_nolock 025f __wopenfile 027e __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 01 02 00 00 8B 55 08 C7 02 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 21 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 21 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 92 01 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 22 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 22 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 2C 01 00 00 33 C9 83 7D 14 00 0F 95 C1 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 23 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 C6 00 00 00 8B 45 0C 0F B7 08 85 C9 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 A5 00 00 00 8B 55 14 89 55 E4 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 4D E4 8B 51 0C 81 E2 83 00 00 00 74 0C 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E4 C7 41 08 00 00 00 00 8B 55 E4 C7 02 00 00 00 00 8B 45 E4 C7 40 0C 00 00 00 00 8B 4D E4 C7 41 04 00 00 00 00 8B 55 E4 52 8B 45 18 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 08 89 01 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 08 83 38 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "__wfreopen"
		size = 46
		refs = "0020 __wfreopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 6A 40 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_558_1_0 {
	meta:
		name = "_freopen"
		size = 46
		refs = "0020 __freopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 6A 40 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "__wfreopen_s"
		size = 36
		refs = "001b __wfreopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_558_2_0 {
	meta:
		name = "_freopen_s"
		size = 36
		refs = "001b __freopen_helper"
	strings:
		$1 = { 8B FF 55 8B EC 68 80 00 00 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "_remove"
		size = 67
		refs = "000c __imp__DeleteFileA@4 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "__rmdir"
		size = 67
		refs = "000c __imp__RemoveDirectoryA@4 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_816_0_0 {
	meta:
		name = "__wremove"
		size = 67
		refs = "000c __imp__DeleteFileW@4 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "__wrmdir"
		size = 67
		refs = "000c __imp__RemoveDirectoryW@4 0016 __imp__GetLastError@0 0031 __dosmaperr"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 FC EB 07 C7 45 FC 00 00 00 00 83 7D FC 00 74 11 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__findfirst32"
		size = 685
		refs = "000c ___security_cookie 002e ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0037 ??_C@_1GE@DLOFGOBB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003e __CrtDbgReportW 0055 __errno 0069 ??_C@_1BK@IAOBEFMC@?$AA_?$AAf?$AAi?$AAn?$AAd?$AAf?$AAi?$AAr?$AAs?$AAt?$AA3?$AA2?$AA?$AA@ 0073 __invalid_parameter 0096 ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0103 ??_C@_1CC@GOBCANBH@?$AA?$CI?$AAs?$AAz?$AAW?$AAi?$AAl?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0164 __imp__FindFirstFileA@8 0173 __imp__GetLastError@0 01aa $LN15 01b1 $LN16 0205 ___timet_from_ft 0257 ??_C@_1JO@GJBNBNOP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 026f _strcpy_s 0278 __invoke_watson_if_error 0288 @__security_check_cookie@4 0290 $LN3 0294 $LN2 0298 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F8 33 C0 83 7D 0C 00 0F 95 C0 89 85 B0 FE FF FF 83 BD B0 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 49 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 00 02 00 00 C7 85 AC FE FF FF 01 00 00 00 83 BD AC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 98 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 A8 FE FF FF 83 BD A8 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A8 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2B 01 00 00 8D 95 B8 FE FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC FF 75 71 FF 15 ?? ?? ?? ?? 89 85 B4 FE FF FF 8B 8D B4 FE FF FF 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 83 EA 02 89 95 A4 FE FF FF 83 BD A4 FE FF FF 10 77 2E 8B 85 A4 FE FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 A0 00 00 00 8B 95 B8 FE FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 B8 FE FF FF 8B 45 0C 89 10 8D 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 C4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 CC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 55 0C 8B 85 D8 FE FF FF 89 42 10 6A 00 6A 72 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D E4 FE FF FF 51 68 04 01 00 00 8B 55 0C 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_88_2_0 {
	meta:
		name = "__findnext32"
		size = 701
		refs = "000c ___security_cookie 002e ??_C@_1FA@DAHAMGDA@?$AA?$CI?$AA?$CI?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE?$AA?$CJ?$AAh?$AAF?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAI?$AAN?$AAV?$AAA?$AAL?$AAI?$AAD?$AA_?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE@ 003a ??_C@_1GE@DLOFGOBB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0041 __CrtDbgReportW 0058 __errno 006f ??_C@_1BI@PAGNIILE@?$AA_?$AAf?$AAi?$AAn?$AAd?$AAn?$AAe?$AAx?$AAt?$AA3?$AA2?$AA?$AA@ 0079 __invalid_parameter 00a1 ??_C@_1BM@BDKGMOHE@?$AA?$CI?$AAp?$AAf?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 010f ??_C@_1FK@EIHIEBPI@?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAw?$AAf?$AAd@ 0176 __imp__FindNextFileA@8 0180 __imp__GetLastError@0 01b7 $LN15 01be $LN16 0212 ___timet_from_ft 0267 ??_C@_1JO@GJBNBNOP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 027f _strcpy_s 0288 __invoke_watson_if_error 0297 @__security_check_cookie@4 02a0 $LN3 02a4 $LN2 02a8 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 5C 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 33 C0 83 7D 08 FF 0F 95 C0 89 85 B0 FE FF FF 83 BD B0 FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9C 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 09 02 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 AC FE FF FF 83 BD AC FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9D 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 96 01 00 00 C7 85 A8 FE FF FF 01 00 00 00 83 BD A8 FE FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A8 FE FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 28 01 00 00 8D 95 B8 FE FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 71 FF 15 ?? ?? ?? ?? 89 85 B4 FE FF FF 8B 8D B4 FE FF FF 89 8D A4 FE FF FF 8B 95 A4 FE FF FF 83 EA 02 89 95 A4 FE FF FF 83 BD A4 FE FF FF 10 77 2E 8B 85 A4 FE FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 02 00 00 00 EB 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 0B E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 A2 00 00 00 8B 95 B8 FE FF FF 81 EA 80 00 00 00 F7 DA 1B D2 23 95 B8 FE FF FF 8B 45 0C 89 10 8D 8D BC FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 89 42 04 8D 85 C4 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 08 8D 95 CC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 89 41 0C 8B 55 0C 8B 85 D8 FE FF FF 89 42 10 6A 00 68 C1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D E4 FE FF FF 51 68 04 01 00 00 8B 55 0C 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 02 02 02 02 01 02 02 02 02 02 02 02 02 02 00 }
	condition:
		$1
}

rule file_88_3_0 {
	meta:
		name = "__findclose"
		size = 39
		refs = "000b __imp__FindClose@4 0014 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_88_4_0 {
	meta:
		name = "___timet_from_ft"
		size = 115
		refs = "0028 __imp__FileTimeToLocalFileTime@8 003a __imp__FileTimeToSystemTime@8 0068 ___loctotime32_t"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 08 83 38 00 75 0E 8B 4D 08 83 79 04 00 75 05 83 C8 FF EB 51 8D 55 F8 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 4D E8 51 8D 55 F8 52 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 28 6A 00 0F B7 45 F4 50 0F B7 4D F2 51 0F B7 55 F0 52 0F B7 45 EE 50 0F B7 4D EA 51 0F B7 55 E8 52 E8 ?? ?? ?? ?? 83 C4 1C 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__loaddll"
		size = 17
		refs = "000b __imp__LoadLibraryA@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_17_2_1 {
	meta:
		name = "__Mtxdst"
		size = 17
		refs = "000b __imp__DeleteCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_17_1_1 {
	meta:
		name = "__Mtxinit"
		size = 17
		refs = "000b __imp__InitializeCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_17_3_1 {
	meta:
		name = "__Mtxlock"
		size = 17
		refs = "000b __imp__EnterCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_17_4_1 {
	meta:
		name = "__Mtxunlock"
		size = 17
		refs = "000b __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_620_0_0 {
	meta:
		name = "__seterrormode"
		size = 17
		refs = "000b __imp__SetErrorMode@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "__unloaddll"
		size = 31
		refs = "000b __imp__FreeLibrary@4 0015 __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__wspawnlp"
		size = 424
		refs = "001b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GC@PALEFAON@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BE@BLAGFGFA@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AAp?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0142 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 019d __wspawnvp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 38 01 00 00 8B 55 0C 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D5 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 74 8B 4D 10 0F B7 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 14 8D 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__resetstkoflw"
		size = 345
		refs = "0009 ___security_cookie 0018 __alloca_probe 0031 __imp__VirtualQuery@12 004c __imp__GetSystemInfo@4 005e ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0064 __imp__GetModuleHandleW@4 0072 ??_C@_0BI@BKLFFAPO@SetThreadStackGuarantee?$AA@ 007c __imp__GetProcAddress@8 011d __imp__VirtualAlloc@16 0137 __imp__VirtualProtect@16 0151 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 74 A1 ?? ?? ?? ?? 33 C5 89 45 90 B8 04 00 00 00 E8 ?? ?? ?? ?? 89 65 8C 8B 45 8C 89 45 E4 6A 1C 8D 4D 98 51 8B 55 E4 52 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 08 01 00 00 8B 45 9C 89 45 94 8D 4D B4 51 FF 15 ?? ?? ?? ?? 8B 55 B8 89 55 DC C7 45 E8 00 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 3A 68 ?? ?? ?? ?? 8B 45 F8 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 22 C7 45 D8 00 00 00 00 8D 4D D8 51 FF 55 FC 83 C4 04 83 F8 01 75 0C 83 7D D8 00 76 06 8B 55 D8 89 55 E8 C7 45 F4 04 01 00 00 8B 45 DC 8B 4D E8 8D 54 01 FF 8B 45 DC 83 E8 01 F7 D0 23 D0 89 55 E8 74 09 8B 4D E8 03 4D DC 89 4D E8 8B 55 DC D1 E2 39 55 E8 73 08 8B 45 DC D1 E0 89 45 E8 8B 4D DC 83 E9 01 F7 D1 23 4D E4 2B 4D E8 89 4D E0 8B 55 94 03 55 DC 89 55 F0 8B 45 E0 3B 45 F0 73 04 33 C0 EB 3C 6A 04 68 00 10 00 00 8B 4D E8 51 8B 55 E0 52 FF 15 ?? ?? ?? ?? 85 C0 74 1A 8D 45 EC 50 8B 4D F4 51 8B 55 E8 52 8B 45 E0 50 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 05 B8 01 00 00 00 8D 65 8C 8B 4D 90 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "_strstr"
		size = 134
		refs = "0075 ___from_strstr_to_strchr"
	strings:
		$1 = { 8B 4C 24 08 57 53 56 8A 11 8B 7C 24 10 84 D2 74 6F 8A 71 01 84 F6 74 55 8B F7 8B 4C 24 14 8A 07 83 C6 01 3A C2 74 17 84 C0 74 0D 8A 06 83 C6 01 3A C2 74 0A 84 C0 75 F3 5E 5B 5F 33 C0 C3 8A 06 83 C6 01 3A C6 75 E9 8D 7E FF 8A 61 02 84 E4 74 28 8A 06 83 C6 02 3A C4 75 BE 8A 41 03 84 C0 74 18 8A 66 FF 83 C1 02 3A C4 74 DF EB AB 33 C0 5E 5B 5F 8A C2 E9 ?? ?? ?? ?? 8D 47 FF 5E 5B 5F C3 8B C7 5E 5B 5F C3 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "__CIlog_pentium4"
		size = 624
		refs = "0039 emask 0041 One 0049 Magic 0051 hi_mask 006f B_Tbl 0077 T_Tbl 00d9 coeff 0105 LOG_2 0111 place_L 0168 Zero 01b7 Infs 01e2 Two52 0233 ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F3 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 AE 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 83 EC 10 66 0F 28 C1 66 0F 15 C9 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 48 83 F9 FF 74 5E 81 F9 FE 07 00 00 77 6C 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 07 DD 05 ?? ?? ?? ?? C3 BA E8 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 02 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 2F FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3A 66 0F 57 C9 F2 0F 5E C9 BA 03 00 00 00 83 EC 1C 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A0 BA E8 03 00 00 EB A6 8D 64 24 00 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__wexecv"
		size = 526
		refs = "001b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1FO@MOEPNDIF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BA@NHAFPAGO@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAv?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CE@IOFFAHL@?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0148 ??_C@_1CG@DNLPJOJF@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01aa ??_C@_1DA@EPHHLJFN@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AAe?$AAc?$AAt?$AAo?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0203 __wexecve"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9E 01 00 00 8B 55 08 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3B 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D7 00 00 00 8B 4D 0C 33 D2 83 39 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 74 8B 4D 0C 8B 11 0F B7 02 F7 D8 1B C0 F7 D8 89 45 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 12 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__mbslen_l"
		size = 173
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002a _strlen 0038 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 45 0C 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 1C 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E8 EB 68 C7 45 FC 00 00 00 00 EB 12 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 83 C1 01 89 4D 08 8B 55 08 0F B6 02 85 C0 74 32 8D 4D EC E8 ?? ?? ?? ?? 8B 48 04 8B 55 08 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 15 8B 55 08 83 C2 01 89 55 08 8B 45 08 0F B6 08 85 C9 75 02 EB 02 EB B2 8B 55 FC 89 55 E4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsW"
		size = 169
		refs = "000a __imp__GetEnvironmentStringsW@0 005b ??_C@_0CP@EFGFBBJB@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0066 __malloc_dbg 007c __imp__FreeEnvironmentStringsW@4 0091 _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 07 33 C0 E9 87 00 00 00 8B 45 FC 89 45 F8 8B 4D F8 0F B7 11 85 D2 74 1E 8B 45 F8 83 C0 02 89 45 F8 8B 4D F8 0F B7 11 85 D2 75 09 8B 45 F8 83 C0 02 89 45 F8 EB D8 8B 4D F8 2B 4D FC 83 C1 02 89 4D F4 6A 3B 68 ?? ?? ?? ?? 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 83 7D F0 00 75 0E 8B 45 FC 50 FF 15 ?? ?? ?? ?? 33 C0 EB 21 8B 4D F4 51 8B 55 FC 52 8B 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D FC 51 FF 15 ?? ?? ?? ?? 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "_memcmp"
		size = 440
		refs = "002a $LN22 0037 _cmpBYTE 0198 _unaligned_memcmp 01a4 $LN1 01a8 $LN2 01ac $LN3 01b0 $LN4 01b4 $LN5"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 10 89 55 F0 83 7D F0 04 0F 87 67 01 00 00 8B 45 F0 FF 24 85 ?? ?? ?? ?? 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 EC EB 73 8B 4D F8 83 C1 01 51 8B 55 FC 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 E8 EB 46 8B 4D F8 83 C1 02 51 8B 55 FC 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 45 F4 89 45 E4 EB 19 8B 4D F8 83 C1 03 51 8B 55 FC 83 C2 03 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 8B 45 E4 89 45 E8 8B 4D E8 89 4D EC 8B 45 EC E9 D5 00 00 00 8B 55 F8 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D E0 EB 46 8B 55 F8 83 C2 01 52 8B 45 FC 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D DC EB 19 8B 55 F8 83 C2 02 52 8B 45 FC 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8B 4D DC 89 4D E0 8B 45 E0 EB 69 8B 55 F8 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 83 7D F4 00 74 08 8B 4D F4 89 4D D8 EB 19 8B 55 F8 83 C2 01 52 8B 45 FC 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D8 8B 45 D8 EB 2A 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 EB 18 33 C0 EB 14 8B 45 10 50 8B 4D F8 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "_cmpBYTE"
		size = 47
		refs = "0024 _cmpResult"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 2B C2 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_2_0 {
	meta:
		name = "_cmpResult"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 10 33 C0 83 7D 08 00 0F 9F C0 8D 44 00 FF 89 45 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_100_3_0 {
	meta:
		name = "_unaligned_memcmp"
		size = 1800
		refs = "001b _cmpDWORD 018c $LN79 03c8 _cmpBYTE 04f4 _cmpWORD 0688 $LN46 068c $LN31 0690 $LN16 0694 $LN1 0698 $LN48 069c $LN33 06a0 $LN18 06a4 $LN3 06a8 $LN50 06ac $LN35 06b0 $LN20 06b4 $LN5 06b8 $LN52 06bc $LN37 06c0 $LN22 06c4 $LN7 06c8 $LN54 06cc $LN39 06d0 $LN24 06d4 $LN9 06d8 $LN56 06dc $LN41 06e0 $LN26 06e4 $LN11 06e8 $LN58 06ec $LN43 06f0 $LN28 06f4 $LN13 06f8 $LN60 06fc $LN45 0700 $LN30 0704 $LN15"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 10 20 0F 82 52 01 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 4F 06 00 00 8B 55 0C 83 C2 04 52 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 28 06 00 00 8B 4D 0C 83 C1 08 51 8B 55 08 83 C2 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 01 06 00 00 8B 45 0C 83 C0 0C 50 8B 4D 08 83 C1 0C 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 DA 05 00 00 8B 55 0C 83 C2 10 52 8B 45 08 83 C0 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 B3 05 00 00 8B 4D 0C 83 C1 14 51 8B 55 08 83 C2 14 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 8C 05 00 00 8B 45 0C 83 C0 18 50 8B 4D 08 83 C1 18 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 65 05 00 00 8B 55 0C 83 C2 1C 52 8B 45 08 83 C0 1C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 3E 05 00 00 8B 4D 08 83 C1 20 89 4D 08 8B 55 0C 83 C2 20 89 55 0C 8B 45 10 83 E8 20 89 45 10 E9 A4 FE FF FF 8B 4D 08 03 4D 10 89 4D 08 8B 55 0C 03 55 10 89 55 0C 8B 45 10 89 45 F8 83 7D F8 1F 0F 87 FA 04 00 00 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 0C 83 EA 1C 52 8B 45 08 83 E8 1C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 CB 04 00 00 8B 4D 0C 83 E9 18 51 8B 55 08 83 EA 18 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 A4 04 00 00 8B 45 0C 83 E8 14 50 8B 4D 08 83 E9 14 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 7D 04 00 00 8B 55 0C 83 EA 10 52 8B 45 08 83 E8 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 56 04 00 00 8B 4D 0C 83 E9 0C 51 8B 55 08 83 EA 0C 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 2F 04 00 00 8B 45 0C 83 E8 08 50 8B 4D 08 83 E9 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 08 04 00 00 8B 55 0C 83 EA 04 52 8B 45 08 83 E8 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 E1 03 00 00 33 C0 E9 DA 03 00 00 8B 4D 0C 83 E9 1D 51 8B 55 08 83 EA 1D 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 B3 03 00 00 8B 45 0C 83 E8 19 50 8B 4D 08 83 E9 19 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 8C 03 00 00 8B 55 0C 83 EA 15 52 8B 45 08 83 E8 15 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 65 03 00 00 8B 4D 0C 83 E9 11 51 8B 55 08 83 EA 11 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 3E 03 00 00 8B 45 0C 83 E8 0D 50 8B 4D 08 83 E9 0D 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 17 03 00 00 8B 55 0C 83 EA 09 52 8B 45 08 83 E8 09 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 F0 02 00 00 8B 4D 0C 83 E9 05 51 8B 55 08 83 EA 05 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 C9 02 00 00 8B 45 0C 83 E8 01 50 8B 4D 08 83 E9 01 51 E8 ?? ?? ?? ?? 83 C4 08 E9 AE 02 00 00 8B 55 0C 83 EA 1E 52 8B 45 08 83 E8 1E 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 87 02 00 00 8B 4D 0C 83 E9 1A 51 8B 55 08 83 EA 1A 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 60 02 00 00 8B 45 0C 83 E8 16 50 8B 4D 08 83 E9 16 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 39 02 00 00 8B 55 0C 83 EA 12 52 8B 45 08 83 E8 12 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 12 02 00 00 8B 4D 0C 83 E9 0E 51 8B 55 08 83 EA 0E 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 EB 01 00 00 8B 45 0C 83 E8 0A 50 8B 4D 08 83 E9 0A 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 C4 01 00 00 8B 55 0C 83 EA 06 52 8B 45 08 83 E8 06 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 9D 01 00 00 8B 4D 0C 83 E9 02 51 8B 55 08 83 EA 02 52 E8 ?? ?? ?? ?? 83 C4 08 E9 82 01 00 00 8B 45 0C 83 E8 1F 50 8B 4D 08 83 E9 1F 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 5B 01 00 00 8B 55 0C 83 EA 1B 52 8B 45 08 83 E8 1B 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 34 01 00 00 8B 4D 0C 83 E9 17 51 8B 55 08 83 EA 17 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 0D 01 00 00 8B 45 0C 83 E8 13 50 8B 4D 08 83 E9 13 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 E6 00 00 00 8B 55 0C 83 EA 0F 52 8B 45 08 83 E8 0F 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 BF 00 00 00 8B 4D 0C 83 E9 0B 51 8B 55 08 83 EA 0B 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 45 FC E9 98 00 00 00 8B 45 0C 83 E8 07 50 8B 4D 08 83 E9 07 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 74 8B 55 0C 83 EA 03 52 8B 45 08 83 E8 03 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 4D FC 89 4D F4 EB 46 8B 55 0C 83 EA 02 52 8B 45 08 83 E8 02 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 83 7D FC 00 74 08 8B 4D FC 89 4D F0 EB 19 8B 55 0C 83 EA 01 52 8B 45 08 83 E8 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 8B 4D F0 89 4D F4 8B 45 F4 EB 02 33 C0 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_4_0 {
	meta:
		name = "_cmpWORD"
		size = 117
		refs = "0039 _cmpBYTE"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 FC 0F B7 02 8B 4D F8 0F B7 11 3B C2 74 4B 8B 45 0C 89 45 F0 8B 4D 08 89 4D F4 8B 55 F0 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 4D EC 89 4D E8 EB 19 8B 55 F0 83 C2 01 52 8B 45 F4 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 8B 45 E8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_5_0 {
	meta:
		name = "_cmpDWORD"
		size = 207
		refs = "0039 _cmpBYTE"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 0C 89 45 FC 8B 4D 08 89 4D F8 8B 55 F8 8B 45 FC 8B 0A 3B 08 0F 84 A5 00 00 00 8B 55 0C 89 55 F0 8B 45 08 89 45 F4 8B 4D F0 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E8 EB 73 8B 4D F0 83 C1 01 51 8B 55 F4 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E4 EB 46 8B 4D F0 83 C1 02 51 8B 55 F4 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 83 7D EC 00 74 08 8B 45 EC 89 45 E0 EB 19 8B 4D F0 83 C1 03 51 8B 55 F4 83 C2 03 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 8B 45 E0 89 45 E4 8B 4D E4 89 4D E8 8B 45 E8 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "__crt_debugger_hook"
		size = 17
		refs = "0007 __debugger_hook_dummy"
	strings:
		$1 = { 8B FF 55 8B EC C7 05 ?? ?? ?? ?? 00 00 00 00 5D C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__cwprintf_l"
		size = 36
		refs = "0019 __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__cprintf_l"
		size = 36
		refs = "0019 __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__cprintf_p_l"
		size = 36
		refs = "0019 __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "__cprintf_s_l"
		size = 36
		refs = "0019 __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_689_1_0 {
	meta:
		name = "__cscanf_l"
		size = 36
		refs = "0019 __cprinput_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_724_1_0 {
	meta:
		name = "__cscanf_s_l"
		size = 36
		refs = "0019 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "__cwprintf_p_l"
		size = 36
		refs = "0019 __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_607_0_0 {
	meta:
		name = "__cwprintf_s_l"
		size = 36
		refs = "0019 __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_1_0 {
	meta:
		name = "__cwscanf_l"
		size = 36
		refs = "0019 __cprinput_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_663_1_0 {
	meta:
		name = "__cwscanf_s_l"
		size = 36
		refs = "0019 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_445_1_0 {
	meta:
		name = "__printf_l"
		size = 36
		refs = "0019 __vprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_445_4_0 {
	meta:
		name = "__printf_p_l"
		size = 36
		refs = "0019 __vprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_445_2_0 {
	meta:
		name = "__printf_s_l"
		size = 36
		refs = "0019 __vprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_343_10_0 {
	meta:
		name = "__scprintf_l"
		size = 36
		refs = "0019 __vscprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_343_11_0 {
	meta:
		name = "__scprintf_p_l"
		size = 36
		refs = "0019 __vscprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_346_10_0 {
	meta:
		name = "__scwprintf_l"
		size = 36
		refs = "0019 __vscwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_346_11_0 {
	meta:
		name = "__scwprintf_p_l"
		size = 36
		refs = "0019 __vscwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_1_0 {
	meta:
		name = "__wprintf_l"
		size = 36
		refs = "0019 __vwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_4_0 {
	meta:
		name = "__wprintf_p_l"
		size = 36
		refs = "0019 __vwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_2_0 {
	meta:
		name = "__wprintf_s_l"
		size = 36
		refs = "0019 __vwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 10 89 45 FC 8B 4D FC 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "__cwprintf"
		size = 34
		refs = "0017 __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_231_1_0 {
	meta:
		name = "__cprintf"
		size = 34
		refs = "0017 __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_184_1_0 {
	meta:
		name = "__cprintf_p"
		size = 34
		refs = "0017 __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_473_1_0 {
	meta:
		name = "__cprintf_s"
		size = 34
		refs = "0017 __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_689_0_0 {
	meta:
		name = "__cscanf"
		size = 34
		refs = "0017 __cprinput_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_724_0_0 {
	meta:
		name = "__cscanf_s"
		size = 34
		refs = "0017 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_268_1_0 {
	meta:
		name = "__cwprintf_p"
		size = 34
		refs = "0017 __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_607_1_0 {
	meta:
		name = "__cwprintf_s"
		size = 34
		refs = "0017 __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__cwscanf"
		size = 34
		refs = "0017 __cprinput_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_663_0_0 {
	meta:
		name = "__cwscanf_s"
		size = 34
		refs = "0017 __cprinput_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_445_5_0 {
	meta:
		name = "__printf_p"
		size = 34
		refs = "0017 __vprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_5_0 {
	meta:
		name = "__wprintf_p"
		size = 34
		refs = "0017 __vwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_445_3_0 {
	meta:
		name = "_printf_s"
		size = 34
		refs = "0017 __vprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_248_3_0 {
	meta:
		name = "_wprintf_s"
		size = 34
		refs = "0017 __vwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 0C 89 45 FC 8B 4D FC 51 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_102_2_0 {
	meta:
		name = "__vcwprintf"
		size = 25
		refs = "0010 __vcwprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_231_2_0 {
	meta:
		name = "__vcprintf"
		size = 25
		refs = "0010 __vcprintf_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_184_2_0 {
	meta:
		name = "__vcprintf_p"
		size = 25
		refs = "0010 __vcprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_473_2_0 {
	meta:
		name = "__vcprintf_s"
		size = 25
		refs = "0010 __vcprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "__vcwprintf_p"
		size = 25
		refs = "0010 __vcwprintf_p_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_607_2_0 {
	meta:
		name = "__vcwprintf_s"
		size = 25
		refs = "0010 __vcwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_102_3_0 {
	meta:
		name = "__vcwprintf_l"
		size = 4092
		refs = "000c ___security_cookie 0051 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0075 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0081 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0088 __CrtDbgReportW 009f __errno 00b6 ??_C@_1BK@OGEKFAEL@?$AA_?$AAv?$AAc?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAl?$AA?$AA@ 00c0 __invalid_parameter 00d5 ??1_LocaleUpdate@@QAE@XZ 0161 ___lookuptable 01c5 $LN152 01e0 _write_char 024d $LN148 0254 $LN153 02a6 _get_int_arg 0363 $LN149 036a $LN154 049e $LN150 04a5 $LN155 04fd ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0522 __mbtowc_l 0582 ___nullstring 058e _strlen 0699 __isleadbyte_l 06ce ___wnullstring 0742 __get_printf_count_output 077e ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 08a0 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 08b1 __malloc_dbg 0923 __cfltcvt_tab 0929 __decode_pointer 0a66 _get_int64_arg 0c36 __aullrem 0c58 __aulldiv 0d6d _write_multi_char 0d84 _write_string 0eba __free_dbg 0eed @__security_check_cookie@4 0ef8 $NORMAL_STATE$29900 0efc $LN131 0f00 $LN130 0f04 $LN122 0f08 $LN118 0f0c $LN117 0f10 $LN113 0f14 $LN97 0f18 $LN125 0f1c $LN124 0f20 $LN126 0f24 $LN127 0f28 $LN123 0f2c $LN128 0f44 $LN107 0f48 $LN99 0f4c $LN110 0f50 $LN98 0f54 $LN111 0f88 $LN64 0f8c $LN94 0f90 $LN82 0f94 $LN46 0f98 $LN88 0f9c $LN63 0fa0 $LN92 0fa4 $LN51 0fa8 $LN69 0fac $LN41 0fb0 $LN47 0fb4 $LN80 0fb8 $LN49 0fbc $LN44 0fc0 $LN95"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D8 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FB FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 0C 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FB FF FF 83 BD 9C FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 4C FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 4C FB FF FF E9 03 0E 00 00 C7 85 B4 FB FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FB FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 45 08 66 8B 08 66 89 8D AC FB FF FF 0F B7 95 AC FB FF FF 8B 45 08 83 C0 02 89 45 08 85 D2 0F 84 9B 0D 00 00 83 BD B4 FB FF FF 00 0F 8C 8E 0D 00 00 0F B7 8D AC FB FF FF 83 F9 20 7C 25 0F B7 95 AC FB FF FF 83 FA 78 7F 19 0F B7 85 AC FB FF FF 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 40 FB FF FF EB 0A C7 85 40 FB FF FF 00 00 00 00 8B 95 40 FB FF FF 89 95 B0 FB FF FF 8B 85 B0 FB FF FF 8B 8D A4 FB FF FF 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 95 A4 FB FF FF 8B 85 A4 FB FF FF 89 85 3C FB FF FF 83 BD 3C FB FF FF 07 0F 87 0C 0D 00 00 8B 8D 3C FB FF FF FF 24 8D ?? ?? ?? ?? C7 45 F4 01 00 00 00 8D 95 B4 FB FF FF 52 0F B7 85 AC FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 E9 DC 0C 00 00 C7 45 D4 00 00 00 00 8B 4D D4 89 4D D8 8B 55 D8 89 55 E8 8B 45 E8 89 45 E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 A9 0C 00 00 0F B7 8D AC FB FF FF 89 8D 38 FB FF FF 8B 95 38 FB FF FF 83 EA 20 89 95 38 FB FF FF 83 BD 38 FB FF FF 10 77 4C 8B 85 38 FB FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 F0 83 CA 04 89 55 F0 EB 2D 8B 45 F0 83 C8 01 89 45 F0 EB 22 8B 4D F0 83 C9 02 89 4D F0 EB 17 8B 55 F0 81 CA 80 00 00 00 89 55 F0 EB 09 8B 45 F0 83 C8 08 89 45 F0 E9 33 0C 00 00 0F B7 8D AC FB FF FF 83 F9 2A 75 28 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 45 F0 83 C8 04 89 45 F0 8B 4D E8 F7 D9 89 4D E8 EB 14 8B 55 E8 6B D2 0A 0F B7 85 AC FB FF FF 8D 4C 02 D0 89 4D E8 E9 E6 0B 00 00 C7 45 D0 00 00 00 00 E9 DA 0B 00 00 0F B7 95 AC FB FF FF 83 FA 2A 75 1E 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 4D D0 6B C9 0A 0F B7 95 AC FB FF FF 8D 44 11 D0 89 45 D0 E9 97 0B 00 00 0F B7 8D AC FB FF FF 89 8D 34 FB FF FF 8B 95 34 FB FF FF 83 EA 49 89 95 34 FB FF FF 83 BD 34 FB FF FF 2E 0F 87 0D 01 00 00 8B 85 34 FB FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 08 0F B7 02 83 F8 6C 75 17 8B 4D 08 83 C1 02 89 4D 08 8B 55 F0 81 CA 00 10 00 00 89 55 F0 EB 09 8B 45 F0 83 C8 10 89 45 F0 E9 C9 00 00 00 8B 4D 08 0F B7 11 83 FA 36 75 25 8B 45 08 0F B7 48 02 83 F9 34 75 19 8B 55 08 83 C2 04 89 55 08 8B 45 F0 0D 00 80 00 00 89 45 F0 E9 80 00 00 00 8B 4D 08 0F B7 11 83 FA 33 75 22 8B 45 08 0F B7 48 02 83 F9 32 75 16 8B 55 08 83 C2 04 89 55 08 8B 45 F0 25 FF 7F FF FF 89 45 F0 EB 53 8B 4D 08 0F B7 11 83 FA 64 74 37 8B 45 08 0F B7 08 83 F9 69 74 2C 8B 55 08 0F B7 02 83 F8 6F 74 21 8B 4D 08 0F B7 11 83 FA 75 74 16 8B 45 08 0F B7 08 83 F9 78 74 0B 8B 55 08 0F B7 02 83 F8 58 75 02 EB 0F C7 85 A4 FB FF FF 00 00 00 00 E9 7B FD FF FF EB 17 8B 4D F0 83 C9 20 89 4D F0 EB 0C 8B 55 F0 81 CA 00 08 00 00 89 55 F0 E9 5C 0A 00 00 0F B7 85 AC FB FF FF 89 85 30 FB FF FF 8B 8D 30 FB FF FF 83 E9 41 89 8D 30 FB FF FF 83 BD 30 FB FF FF 37 0F 87 50 08 00 00 8B 95 30 FB FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D F0 81 E1 30 08 00 00 75 09 8B 55 F0 83 CA 20 89 55 F0 C7 45 F4 01 00 00 00 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FB FF FF 8B 4D F0 83 E1 20 74 57 0F B7 95 A8 FB FF FF 81 E2 FF 00 00 00 88 95 98 FB FF FF C6 85 99 FB FF FF 00 8D 4D C0 E8 ?? ?? ?? ?? 50 8D 4D C0 E8 ?? ?? ?? ?? 8B 00 8B 88 AC 00 00 00 51 8D 95 98 FB FF FF 52 8D 85 B8 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 07 C7 45 D8 01 00 00 00 EB 0E 66 8B 8D A8 FB FF FF 66 89 8D B8 FB FF FF 8D 95 B8 FB FF FF 89 55 FC C7 45 DC 01 00 00 00 E9 8C 07 00 00 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 94 FB FF FF 83 BD 94 FB FF FF 00 74 0C 8B 8D 94 FB FF FF 83 79 04 00 75 1A 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 50 8B 4D F0 81 E1 00 08 00 00 74 26 8B 95 94 FB FF FF 8B 42 04 89 45 FC 8B 8D 94 FB FF FF 0F BF 01 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 95 94 FB FF FF 8B 42 04 89 45 FC 8B 8D 94 FB FF FF 0F BF 11 89 55 DC E9 F6 06 00 00 8B 45 F0 25 30 08 00 00 75 09 8B 4D F0 83 C9 20 89 4D F0 83 7D D0 FF 75 0C C7 85 2C FB FF FF FF FF FF 7F EB 09 8B 55 D0 89 95 2C FB FF FF 8B 85 2C FB FF FF 89 85 8C FB FF FF 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 F0 83 E2 20 0F 84 82 00 00 00 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 89 8D 90 FB FF FF C7 45 DC 00 00 00 00 EB 09 8B 55 DC 83 C2 01 89 55 DC 8B 45 DC 3B 85 8C FB FF FF 7D 4C 8B 8D 90 FB FF FF 0F BE 11 85 D2 74 3F 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 85 90 FB FF FF 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0F 8B 95 90 FB FF FF 83 C2 01 89 95 90 FB FF FF 8B 85 90 FB FF FF 83 C0 01 89 85 90 FB FF FF EB A0 EB 64 83 7D FC 00 75 09 8B 0D ?? ?? ?? ?? 89 4D FC C7 45 F4 01 00 00 00 8B 55 FC 89 95 88 FB FF FF 8B 85 8C FB FF FF 8B 8D 8C FB FF FF 83 E9 01 89 8D 8C FB FF FF 85 C0 74 1E 8B 95 88 FB FF FF 0F B7 02 85 C0 74 11 8B 8D 88 FB FF FF 83 C1 02 89 8D 88 FB FF FF EB C9 8B 95 88 FB FF FF 2B 55 FC D1 FA 89 55 DC E9 B6 05 00 00 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 84 FB FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 C9 74 0C C7 85 28 FB FF FF 01 00 00 00 EB 0A C7 85 28 FB FF FF 00 00 00 00 8B 95 28 FB FF FF 89 95 80 FB FF FF 83 BD 80 FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 80 FB FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 48 FB FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 48 FB FF FF E9 FA 06 00 00 E9 F3 04 00 00 8B 4D F0 83 E1 20 74 12 8B 95 84 FB FF FF 66 8B 85 B4 FB FF FF 66 89 02 EB 0E 8B 8D 84 FB FF FF 8B 95 B4 FB FF FF 89 11 C7 45 D8 01 00 00 00 E9 BF 04 00 00 C7 45 D4 01 00 00 00 0F B7 85 AC FB FF FF 83 C0 20 66 89 85 AC FB FF FF 8B 4D F0 83 C9 40 89 4D F0 8D 95 B8 FB FF FF 89 55 FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F B7 85 AC FB FF FF 83 F8 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 41 68 DA 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D D0 81 C1 5D 01 00 00 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 13 8B 55 E0 89 55 FC 8B 45 D0 05 5D 01 00 00 89 45 BC EB 07 C7 45 D0 A3 00 00 00 8B 4D 10 83 C1 08 89 4D 10 8B 55 10 8B 42 F8 8B 4A FC 89 85 78 FB FF FF 89 8D 7C FB FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 D4 52 8B 45 D0 50 0F BE 8D AC FB FF FF 51 8B 55 BC 52 8B 45 FC 50 8D 8D 78 FB FF FF 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 1C 8B 45 F0 25 80 00 00 00 74 27 83 7D D0 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 4D FC 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 0F B7 85 AC FB FF FF 83 F8 67 75 2B 8B 4D F0 81 E1 80 00 00 00 75 20 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 55 FC 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 8B 4D FC 0F BE 11 83 FA 2D 75 14 8B 45 F0 0D 00 01 00 00 89 45 F0 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 15 03 00 00 8B 45 F0 83 C8 40 89 45 F0 C7 45 F8 0A 00 00 00 EB 75 C7 45 F8 0A 00 00 00 EB 6C C7 45 D0 08 00 00 00 C7 85 A0 FB FF FF 07 00 00 00 EB 0A C7 85 A0 FB FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 1D BA 30 00 00 00 66 89 55 EC 8B 85 A0 FB FF FF 83 C0 51 66 89 45 EE C7 45 E4 02 00 00 00 EB 1E C7 45 F8 08 00 00 00 8B 4D F0 81 E1 80 00 00 00 74 0C 8B 55 F0 81 CA 00 02 00 00 89 55 F0 8B 45 F0 25 00 80 00 00 74 1D 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 68 FB FF FF 89 95 6C FB FF FF E9 AF 00 00 00 8B 55 F0 81 E2 00 10 00 00 74 1D 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 68 FB FF FF 89 95 6C FB FF FF E9 87 00 00 00 8B 4D F0 83 E1 20 74 42 8B 55 F0 83 E2 40 74 1C 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 98 99 89 85 68 FB FF FF 89 95 6C FB FF FF EB 1C 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 68 FB FF FF 89 95 6C FB FF FF EB 3D 8B 55 F0 83 E2 40 74 1B 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 68 FB FF FF 89 95 6C FB FF FF EB 1A 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 33 D2 89 85 68 FB FF FF 89 95 6C FB FF FF 8B 45 F0 83 E0 40 74 40 83 BD 6C FB FF FF 00 7F 37 7C 09 83 BD 68 FB FF FF 00 73 2C 8B 8D 68 FB FF FF F7 D9 8B 95 6C FB FF FF 83 D2 00 F7 DA 89 8D 60 FB FF FF 89 95 64 FB FF FF 8B 45 F0 0D 00 01 00 00 89 45 F0 EB 18 8B 8D 68 FB FF FF 89 8D 60 FB FF FF 8B 95 6C FB FF FF 89 95 64 FB FF FF 8B 45 F0 25 00 80 00 00 75 26 8B 4D F0 81 E1 00 10 00 00 75 1B 8B 95 60 FB FF FF 8B 85 64 FB FF FF 83 E0 00 89 95 60 FB FF FF 89 85 64 FB FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 4D F0 83 E1 F7 89 4D F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 95 60 FB FF FF 0B 95 64 FB FF FF 75 07 C7 45 E4 00 00 00 00 8D 85 B7 FD FF FF 89 45 FC 8B 4D D0 8B 55 D0 83 EA 01 89 55 D0 85 C9 7F 0E 8B 85 60 FB FF FF 0B 85 64 FB FF FF 74 7B 8B 45 F8 99 52 50 8B 8D 64 FB FF FF 51 8B 95 60 FB FF FF 52 E8 ?? ?? ?? ?? 83 C0 30 89 85 74 FB FF FF 8B 45 F8 99 52 50 8B 85 64 FB FF FF 50 8B 8D 60 FB FF FF 51 E8 ?? ?? ?? ?? 89 85 60 FB FF FF 89 95 64 FB FF FF 83 BD 74 FB FF FF 39 7E 12 8B 95 74 FB FF FF 03 95 A0 FB FF FF 89 95 74 FB FF FF 8B 45 FC 8A 8D 74 FB FF FF 88 08 8B 55 FC 83 EA 01 89 55 FC E9 67 FF FF FF 8D 85 B7 FD FF FF 2B 45 FC 89 45 DC 8B 4D FC 83 C1 01 89 4D FC 8B 55 F0 81 E2 00 02 00 00 74 29 83 7D DC 00 74 0B 8B 45 FC 0F BE 08 83 F9 30 74 18 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC C6 00 30 8B 4D DC 83 C1 01 89 4D DC 83 7D D8 00 0F 85 BE 01 00 00 8B 55 F0 83 E2 40 74 4E 8B 45 F0 25 00 01 00 00 74 12 B9 2D 00 00 00 66 89 4D EC C7 45 E4 01 00 00 00 EB 32 8B 55 F0 83 E2 01 74 12 B8 2B 00 00 00 66 89 45 EC C7 45 E4 01 00 00 00 EB 18 8B 4D F0 83 E1 02 74 10 BA 20 00 00 00 66 89 55 EC C7 45 E4 01 00 00 00 8B 45 E8 2B 45 DC 2B 45 E4 89 85 5C FB FF FF 8B 4D F0 83 E1 0C 75 18 8D 95 B4 FB FF FF 52 8B 85 5C FB FF FF 50 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 8D 8D B4 FB FF FF 51 8B 55 E4 52 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D F0 83 E1 08 74 20 8B 55 F0 83 E2 04 75 18 8D 85 B4 FB FF FF 50 8B 8D 5C FB FF FF 51 6A 30 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F4 00 0F 85 B0 00 00 00 83 7D DC 00 0F 8E A6 00 00 00 8B 55 FC 89 95 58 FB FF FF 8B 45 DC 89 85 54 FB FF FF 8B 8D 54 FB FF FF 8B 95 54 FB FF FF 83 EA 01 89 95 54 FB FF FF 85 C9 7E 79 8D 4D C0 E8 ?? ?? ?? ?? 50 8D 4D C0 E8 ?? ?? ?? ?? 8B 00 8B 88 AC 00 00 00 51 8B 95 58 FB FF FF 52 8D 85 A8 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 50 FB FF FF 83 BD 50 FB FF FF 00 7F 0C C7 85 B4 FB FF FF FF FF FF FF EB 2E 8D 8D B4 FB FF FF 51 0F B7 95 A8 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 85 58 FB FF FF 03 85 50 FB FF FF 89 85 58 FB FF FF E9 6E FF FF FF EB 17 8D 8D B4 FB FF FF 51 8B 55 DC 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C 83 BD B4 FB FF FF 00 7C 20 8B 4D F0 83 E1 04 74 18 8D 95 B4 FB FF FF 52 8B 85 5C FB FF FF 50 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E0 00 74 15 6A 02 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 08 C7 45 E0 00 00 00 00 E9 40 F2 FF FF 8B 95 B4 FB FF FF 89 95 44 FB FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 44 FB FF FF 8B 4D B8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 01 05 05 05 05 05 05 05 02 05 03 05 05 04 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 04 01 04 04 04 02 04 04 04 04 04 04 04 04 04 04 03 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0E 01 0E 00 0E 00 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 0E 02 0E 0E 0E 0E 03 0E 04 0E 0E 0E 0E 0E 0E 05 0E 06 07 05 05 05 0E 07 0E 0E 0E 0E 08 09 0A 0E 0E 0B 0E 0C 0E 0E 0D }
	condition:
		$1
}

rule file_102_7_0 {
	meta:
		name = "_write_char"
		size = 55
		refs = "000b __putwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 81 F9 FF FF 00 00 75 0B 8B 55 0C C7 02 FF FF FF FF EB 0D 8B 45 0C 8B 08 83 C1 01 8B 55 0C 89 0A 5D C3 }
	condition:
		$1
}

rule file_102_8_0 {
	meta:
		name = "_write_multi_char"
		size = 52
		refs = "001f _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 1D 8B 55 10 52 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 10 83 39 FF 75 02 EB 02 EB D3 5D C3 }
	condition:
		$1
}

rule file_102_9_0 {
	meta:
		name = "_write_string"
		size = 100
		refs = "002a _write_char 0043 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 4A 8B 55 08 66 8B 02 66 89 45 FE 8B 4D 10 51 0F B7 55 FE 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 83 C0 02 89 45 08 8B 4D 10 83 39 FF 75 1C E8 ?? ?? ?? ?? 83 38 2A 75 10 8B 55 10 52 6A 3F E8 ?? ?? ?? ?? 83 C4 08 EB 02 EB 02 EB A6 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_1_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 473
		refs = "0008 __sehtable$___tmainCRTStartup 000d __except_handler4 001f ___security_cookie 0049 __imp__GetStartupInfoW@4 007d _check_managed_app 0087 __heap_init 0095 _fast_error_exit 009d __mtinit 00b2 __CrtSetCheckCount 00ba __RTC_Initialize 00c6 __ioinit 00d1 __amsg_exit 00d9 ___crtGetCommandLineW 00de __wcmdln 00e3 ___crtGetEnvironmentStringsW 00e8 __wenvptr 00ed __wsetargv 0100 __wsetenvp 0115 __cinit 0132 __wwincmdln 015c ___ImageBase 0161 _wWinMain@16 0173 _exit 0178 __cexit 0198 __XcptFilter 01b4 __exit 01b9 __c_exit"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 94 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 90 00 00 00 00 C7 45 FC 00 00 00 00 8D 45 A0 50 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 26 B8 01 00 00 00 C3 8B 65 E8 C7 45 88 FF 00 00 00 C7 45 FC FE FF FF FF 8B 45 88 E9 52 01 00 00 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? 89 45 94 6A 01 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0A 6A 1C E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 75 0A 6A 10 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 45 FC 01 00 00 00 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 1B E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 85 C0 7D 0A 6A 09 E8 ?? ?? ?? ?? 83 C4 04 6A 01 E8 ?? ?? ?? ?? 83 C4 04 89 45 9C 83 7D 9C 00 74 0C 8B 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 98 8B 55 CC 83 E2 01 74 09 0F B7 45 D0 89 45 84 EB 07 C7 45 84 0A 00 00 00 8B 4D 84 51 8B 55 98 52 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 90 83 7D 94 00 75 09 8B 45 90 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB 3F 8B 4D EC 8B 11 8B 02 89 45 8C 8B 4D EC 51 8B 55 8C 52 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 65 E8 8B 45 8C 89 45 90 83 7D 94 00 75 09 8B 4D 90 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 90 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_2_0 {
	meta:
		name = "_fast_error_exit"
		size = 46
		refs = "0007 ___error_mode 000f __FF_MSGBANNER 0018 __NMSG_WRITE 0025 ___crtExitProcess"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 68 FF 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__fsqrt"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 D9 FA DD 5D F8 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__wfullpath"
		size = 33
		refs = "0018 __wfullpath_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_670_5_0 {
	meta:
		name = "__dupenv_s"
		size = 33
		refs = "0018 __dupenv_s_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "__fullpath"
		size = 33
		refs = "0018 __fullpath_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_452_4_0 {
	meta:
		name = "__getdcwd_nolock"
		size = 33
		refs = "0018 __getdcwd_lk_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_579_5_0 {
	meta:
		name = "__wdupenv_s"
		size = 33
		refs = "0018 __wdupenv_s_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_481_4_0 {
	meta:
		name = "__wgetdcwd_nolock"
		size = 33
		refs = "0018 __wgetdcwd_lk_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "__wfullpath_dbg"
		size = 434
		refs = "0021 __wgetcwd 0043 __imp__GetFullPathNameW@16 0052 __imp__GetLastError@0 0058 __dosmaperr 008c __errno 00b0 __calloc_dbg 00e3 ??_C@_1BK@NOHKJANJ@?$AA?$CI?$AAm?$AAa?$AAx?$AAl?$AAe?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00ef ??_C@_1GE@EJNCNJPK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00f6 __CrtDbgReportW 0121 ??_C@_1BO@ECCJIFJJ@?$AA_?$AAw?$AAf?$AAu?$AAl?$AAl?$AAp?$AAa?$AAt?$AAh?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 012b __invalid_parameter 0168 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 0C 00 74 0A 8B 45 0C 0F B7 08 85 C9 75 15 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 81 01 00 00 83 7D 08 00 0F 85 9D 00 00 00 6A 00 6A 00 6A 00 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 48 01 00 00 8B 55 10 3B 55 FC 76 08 8B 45 10 89 45 EC EB 06 8B 4D FC 89 4D EC 8B 55 EC 89 55 10 81 7D 10 FF FF FF 7F 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 11 01 00 00 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 6A 02 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 DC 00 00 00 EB 68 33 C9 3B 4D 10 1B D2 F7 DA 89 55 F0 75 21 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 78 8B 4D 08 89 4D F4 8D 55 F8 52 8B 45 F4 50 8B 4D 10 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 3B 45 10 72 23 83 7D 08 00 75 0C 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 EB 30 EB 2B 83 7D FC 00 75 25 83 7D 08 00 75 0C 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 03 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "_realloc"
		size = 38
		refs = "0015 __realloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_13_0 {
	meta:
		name = "__expand"
		size = 38
		refs = "0015 __expand_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_819_0_0 {
	meta:
		name = "_calloc"
		size = 38
		refs = "0015 __calloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "_strchr"
		size = 190
	strings:
		$1 = { 33 C0 8A 44 24 08 53 8B D8 C1 E0 08 8B 54 24 08 F7 C2 03 00 00 00 74 15 8A 0A 83 C2 01 3A CB 74 CF 84 C9 74 51 F7 C2 03 00 00 00 75 EB 0B D8 57 8B C3 C1 E3 10 56 0B D8 8B 0A BF FF FE FE 7E 8B C1 8B F7 33 CB 03 F0 03 F9 83 F1 FF 83 F0 FF 33 CF 33 C6 83 C2 04 81 E1 00 01 01 81 75 1C 25 00 01 01 81 74 D3 25 00 01 01 01 75 08 81 E6 00 00 00 80 75 C4 5E 5F 5B 33 C0 C3 8B 42 FC 3A C3 74 36 84 C0 74 EF 3A E3 74 27 84 E4 74 E7 C1 E8 10 3A C3 74 15 84 C0 74 DC 3A E3 74 06 84 E4 74 D4 EB 96 5E 5F 8D 42 FF 5B C3 8D 42 FE 5E 5F 5B C3 8D 42 FD 5E 5F 5B C3 8D 42 FC 5E 5F 5B C3 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__wcsnset"
		size = 66
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 89 45 FC 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 1F 8B 45 08 0F B7 08 85 C9 74 15 8B 55 08 66 8B 45 0C 66 89 02 8B 4D 08 83 C1 02 89 4D 08 EB D1 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__mbsspn_l"
		size = 554
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002e _strspn 003c ??1_LocaleUpdate@@QAE@XZ 005b ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0064 ??_C@_1GA@HAFFGCEC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006b __CrtDbgReportW 007f __errno 0093 ??_C@_1BE@IJNALACN@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAp?$AAn?$AA_?$AAl?$AA?$AA@ 009d __invalid_parameter 00ce ??_C@_1CA@KMNJPEDI@?$AAc?$AAh?$AAa?$AAr?$AAs?$AAe?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 23 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 DE 01 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 6B 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 F8 00 00 00 8B 55 08 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 0F B6 11 85 D2 0F 84 C5 00 00 00 8B 45 0C 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F B6 02 85 C0 74 69 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 FC 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 3A 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 3B C2 75 12 8B 45 FC 0F B6 48 01 8B 55 F8 0F B6 42 01 3B C8 74 0B 8B 4D FC 0F B6 51 01 85 D2 75 02 EB 1F 8B 45 FC 83 C0 01 89 45 FC EB 12 8B 4D FC 0F B6 11 8B 45 F8 0F B6 08 3B D1 75 02 EB 02 EB 84 8B 55 FC 0F B6 02 85 C0 75 02 EB 35 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 15 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 0F B6 08 85 C9 75 02 EB 05 E9 24 FF FF FF 8B 55 F8 2B 55 08 89 55 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "_frexp"
		size = 353
		refs = "001b ??_C@_1BO@KGGHBFPG@?$AAe?$AAx?$AAp?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1HC@HDCMDJF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1M@KFLMCEDC@?$AAf?$AAr?$AAe?$AAx?$AAp?$AA?$AA@ 005d __invalid_parameter 0076 __ctrlfp 00a9 __sptype 00d0 __d_ind 00e5 __except1 00fe __handle_qnan1 0110 __real@3ff0000000000000 013f __decomp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 33 C0 83 7D 10 00 0F 95 C0 89 45 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 26 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 D9 EE E9 F2 00 00 00 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 0F B7 55 0E 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 85 9B 00 00 00 8B 45 10 C7 00 FF FF FF FF 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 E8 83 7D E8 00 7E 4E 83 7D E8 02 7E 08 83 7D E8 03 74 29 EB 40 8B 4D FC 51 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 6F 8B 55 FC 52 83 EC 08 DD 45 08 DD 1C 24 6A 17 E8 ?? ?? ?? ?? 83 C4 10 EB 56 8B 45 FC 50 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 2C 8B 4D 10 51 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F0 68 FF FF 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__mbclen_l"
		size = 63
		refs = "0012 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 8B 4D 08 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 14 8B 45 08 0F B6 48 01 85 C9 74 09 C7 45 FC 02 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_1_0 {
	meta:
		name = "__mbclen"
		size = 59
		refs = "000e __ismbblead"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 14 8B 55 08 0F B6 42 01 85 C0 74 09 C7 45 FC 02 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "__snwprintf"
		size = 509
		refs = "0021 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 002d ??_C@_1GE@DKGHLBLP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0034 __CrtDbgReportW 0048 __errno 005f ??_C@_1BG@BAJEGOIL@?$AA_?$AAs?$AAn?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 0069 __invalid_parameter 00a1 ??_C@_1EC@FABAOFFO@?$AA?$CI?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ@ 0148 __woutput_l 01a1 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8D 45 D4 89 45 F4 33 C9 83 7D 10 00 0F 95 C1 89 4D D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 80 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 80 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 81 01 00 00 83 7D 0C 00 74 0F 83 7D 08 00 75 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 45 C8 89 45 CC 83 7D CC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 01 01 00 00 8D 55 14 89 55 FC 8B 45 F4 C7 40 0C 42 00 00 00 8B 4D F4 8B 55 08 89 51 08 8B 45 F4 8B 4D 08 89 08 81 7D 0C FF FF FF 3F 76 0C 8B 55 F4 C7 42 04 FF FF FF 7F EB 0B 8B 45 0C D1 E0 8B 4D F4 89 41 04 8B 55 FC 52 6A 00 8B 45 10 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D 08 00 75 08 8B 45 F8 E9 99 00 00 00 8B 55 F4 8B 42 04 83 E8 01 8B 4D F4 89 41 04 8B 55 F4 83 7A 04 00 7C 22 8B 45 F4 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 C4 8B 45 F4 8B 08 83 C1 01 8B 55 F4 89 0A EB 11 8B 45 F4 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C4 8B 4D F4 8B 51 04 83 EA 01 8B 45 F4 89 50 04 8B 4D F4 83 79 04 00 7C 22 8B 55 F4 8B 02 C6 00 00 33 C9 81 E1 FF 00 00 00 89 4D C0 8B 55 F4 8B 02 83 C0 01 8B 4D F4 89 01 EB 11 8B 55 F4 52 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 C0 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "__dup"
		size = 544
		refs = "0008 __sehtable$__dup 000d __except_handler4 001f ___security_cookie 0040 ___doserrno 004b __errno 0068 __nhandle 008b ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 0094 ??_C@_1FK@JHPGOADJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 009b __CrtDbgReportW 00ce ??_C@_19DABLNIOD@?$AA_?$AAd?$AAu?$AAp?$AA?$AA@ 00d8 __invalid_parameter 00f9 ___pioinfo 0111 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0172 ___lock_fhandle 01a5 __dup_nolock 01d3 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0203 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 FF FF FF FF 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 B1 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 27 01 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 DC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A1 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 74 11 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 EB 3F E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 C7 45 E4 FF FF FF FF 33 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_1_0 {
	meta:
		name = "__dup_nolock"
		size = 635
		refs = "0008 __sehtable$__dup_nolock 000d __except_handler4 001f ___security_cookie 004b ___pioinfo 007f __alloc_osfhnd 008d __errno 0098 ___doserrno 00bd __imp__GetCurrentProcess@0 00c7 __get_osfhandle 00d8 __imp__DuplicateHandle@28 00e2 __imp__GetLastError@0 00f4 __set_osfhnd 010d __dosmaperr 0249 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 44 0A 04 88 45 DB 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 0F BE 4C 10 04 83 E1 01 75 08 83 C8 FF E9 EB 01 00 00 E8 ?? ?? ?? ?? 89 45 D4 83 7D D4 FF 75 1E E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 C8 FF E9 BF 01 00 00 C7 45 FC 00 00 00 00 6A 02 6A 01 6A 00 8D 55 E4 52 FF 15 ?? ?? ?? ?? 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 0B FF 15 ?? ?? ?? ?? 89 45 DC EB 17 8B 4D E4 51 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 DC 00 00 00 00 83 7D DC 00 74 11 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 E9 DF 00 00 00 0F BE 4D DB 83 E1 EF 8B 55 D4 C1 FA 05 8B 45 D4 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 88 4C 02 04 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8A 44 0A 24 D0 E0 D0 F8 8B 4D D4 C1 F9 05 8B 55 D4 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 24 7F 8A 54 11 24 80 E2 80 0A D0 8B 45 D4 C1 F8 05 8B 4D D4 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 88 54 08 24 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8A 4C 10 24 C0 E1 00 C0 F9 07 8B 55 D4 C1 FA 05 8B 45 D4 83 E0 1F C1 E0 06 8B 14 95 ?? ?? ?? ?? 80 E1 01 C0 E1 07 8A 44 02 24 24 7F 0A C1 8B 4D D4 C1 F9 05 8B 55 D4 83 E2 1F C1 E2 06 8B 0C 8D ?? ?? ?? ?? 88 44 11 24 C7 45 E0 01 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 4B 83 7D E0 00 75 38 8B 55 D4 C1 FA 05 8B 45 D4 83 E0 1F C1 E0 06 8B 0C 95 ?? ?? ?? ?? 0F BE 54 01 04 83 E2 FE 8B 45 D4 C1 F8 05 8B 4D D4 83 E1 1F C1 E1 06 8B 04 85 ?? ?? ?? ?? 88 54 08 04 8B 4D D4 51 E8 ?? ?? ?? ?? 83 C4 04 C3 83 7D E0 00 74 08 8B 55 D4 89 55 D0 EB 07 C7 45 D0 FF FF FF FF 8B 45 D0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "___init_time"
		size = 240
		refs = "0012 ??_C@_0DC@KICHHNFK@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0020 __calloc_dbg 0043 __get_lc_time 0053 ___free_lc_time 0061 __free_dbg 0081 ___lc_time_c 00a6 __imp__InterlockedDecrement@4 00c1 ??_C@_1EE@FDHCFDHN@?$AAp?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AA_?$AAt?$AAi?$AAm?$AAe?$AA_?$AAc?$AAu?$AAr?$AAr?$AA?9?$AA?$DO?$AAr?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5@ 00ca ??_C@_1GE@GJCMHHMH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00d1 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 83 78 20 00 74 6F 6A 40 68 ?? ?? ?? ?? 6A 02 68 B8 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 0A B8 01 00 00 00 E9 B2 00 00 00 8B 4D 08 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 21 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 B8 01 00 00 00 EB 7D 8B 55 FC C7 82 B4 00 00 00 01 00 00 00 EB 07 C7 45 FC ?? ?? ?? ?? 8B 45 08 81 B8 D4 00 00 00 ?? ?? ?? ?? 74 4A 8B 4D 08 8B 91 D4 00 00 00 81 C2 B4 00 00 00 52 FF 15 ?? ?? ?? ?? 85 C0 75 30 8B 45 08 8B 88 D4 00 00 00 83 B9 B4 00 00 00 00 7F 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 8B 4D FC 89 88 D4 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "__get_lc_time"
		size = 1572
		refs = "0052 ___getlocaleinfo"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 C7 45 EC 00 00 00 00 8B 45 0C 0F B7 48 42 89 4D F0 8B 55 0C 0F B7 42 44 89 45 FC 83 7D 08 00 75 08 83 C8 FF E9 EF 05 00 00 8B 4D 0C 89 4D F4 C7 45 F8 00 00 00 00 8B 55 08 83 C2 04 52 6A 31 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 08 52 6A 32 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 0C 52 6A 33 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 10 52 6A 34 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 14 52 6A 35 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 18 52 6A 36 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 52 6A 37 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 20 52 6A 2A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 24 52 6A 2B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 28 52 6A 2C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 2C 52 6A 2D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 30 52 6A 2E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 34 52 6A 2F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 1C 52 6A 30 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 38 52 6A 44 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 3C 52 6A 45 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 40 52 6A 46 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 44 52 6A 47 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 48 52 6A 48 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 4C 52 6A 49 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 50 52 6A 4A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 54 52 6A 4B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 58 52 6A 4C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 5C 52 6A 4D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 60 52 6A 4E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 64 52 6A 4F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 68 52 6A 38 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 6C 52 6A 39 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 70 52 6A 3A 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 74 52 6A 3B 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 78 52 6A 3C 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 83 C2 7C 52 6A 3D 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 80 00 00 00 52 6A 3E 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 84 00 00 00 52 6A 3F 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 88 00 00 00 52 6A 40 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 8C 00 00 00 52 6A 41 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 90 00 00 00 52 6A 42 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 94 00 00 00 52 6A 43 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 98 00 00 00 52 6A 28 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 9C 00 00 00 52 6A 29 8B 45 F0 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A0 00 00 00 52 6A 1F 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A4 00 00 00 52 6A 20 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 A8 00 00 00 52 68 03 10 00 00 8B 45 FC 50 6A 01 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 81 C2 B0 00 00 00 52 68 09 10 00 00 8B 45 FC 50 6A 00 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 14 0B 45 EC 89 45 EC 8B 55 08 8B 45 FC 89 82 AC 00 00 00 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_2_0 {
	meta:
		name = "___free_lc_time"
		size = 781
		refs = "001a __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 05 E9 FB 02 00 00 6A 02 8B 45 08 8B 48 04 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 08 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 0C 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 10 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 14 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 18 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 20 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 24 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 28 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 2C 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 30 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 34 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 1C 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 38 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 3C 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 40 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 44 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 48 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 4C 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 50 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 54 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 58 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 5C 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 60 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 64 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 68 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 6C 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 70 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 51 74 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 48 78 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 42 7C 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 80 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 84 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 88 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 8C 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 90 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 94 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 98 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 9C 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 A0 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 A4 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 A8 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "__wcsnicmp_l"
		size = 555
		refs = "002c ??_C@_1BM@CBACDFHA@?$AAf?$AAi?$AAr?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0035 ??_C@_1GE@JMKOMBJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003c __CrtDbgReportW 0050 __errno 0064 ??_C@_1BI@KLMFNDBC@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 006e __invalid_parameter 0092 ??_C@_1BK@LKBOPAFJ@?$AAl?$AAa?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00ed ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00f5 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01b7 __towlower_l 0220 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C C7 45 F4 00 00 00 00 83 7D 10 00 0F 84 0B 02 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 A8 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 42 01 00 00 8B 4D 14 51 8D 4D E4 E8 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 83 7A 14 00 0F 85 A1 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 D8 EB 09 8B 45 08 0F B7 08 89 4D D8 66 8B 55 D8 66 89 55 FC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 D4 EB 09 8B 45 0C 0F B7 08 89 4D D4 66 8B 55 D4 66 89 55 F8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 10 83 EA 01 89 55 10 74 18 0F B7 45 FC 85 C0 74 10 0F B7 4D FC 0F B7 55 F8 3B CA 0F 84 61 FF FF FF EB 69 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 45 08 0F B7 08 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 FC 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 55 0C 0F B7 02 50 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 8B 45 10 83 E8 01 89 45 10 74 14 0F B7 4D FC 85 C9 74 0C 0F B7 55 FC 0F B7 45 F8 3B D0 74 97 0F B7 4D FC 0F B7 55 F8 2B CA 89 4D F4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_118_4_0 {
	meta:
		name = "__wcsnicmp"
		size = 447
		refs = "000a ___locale_changed 0039 ??_C@_1BM@CBACDFHA@?$AAf?$AAi?$AAr?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0042 ??_C@_1GE@JMKOMBJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0049 __CrtDbgReportW 005d __errno 0071 ??_C@_1BE@JKOKKFEL@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAm?$AAp?$AA?$AA@ 007b __invalid_parameter 009f ??_C@_1BK@LKBOPAFJ@?$AAl?$AAa?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01b4 __wcsnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 3D ?? ?? ?? ?? 00 0F 85 90 01 00 00 C7 45 F4 00 00 00 00 83 7D 10 00 0F 84 78 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 2F 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 C9 00 00 00 8B 4D 08 0F B7 11 83 FA 41 7C 19 8B 45 08 0F B7 08 83 F9 5A 7F 0E 8B 55 08 0F B7 02 83 C0 20 89 45 E8 EB 09 8B 4D 08 0F B7 11 89 55 E8 66 8B 45 E8 66 89 45 FC 8B 4D 0C 0F B7 11 83 FA 41 7C 19 8B 45 0C 0F B7 08 83 F9 5A 7F 0E 8B 55 0C 0F B7 02 83 C0 20 89 45 E4 EB 09 8B 4D 0C 0F B7 11 89 55 E4 66 8B 45 E4 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 8B 45 10 83 E8 01 89 45 10 74 18 0F B7 4D FC 85 C9 74 10 0F B7 55 FC 0F B7 45 F8 3B D0 0F 84 61 FF FF FF 0F B7 4D FC 0F B7 55 F8 2B CA 89 4D F4 8B 45 F4 EB 18 EB 16 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "__mbsnbcat_s_l"
		size = 2016
		refs = "005d ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0066 ??_C@_1GK@MIHKNAIH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006d __CrtDbgReportW 0081 __errno 0095 ??_C@_1BM@BENFBNLI@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 009f __invalid_parameter 00e7 ___crtDebugFillThreshold 011b _memset 0135 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0190 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0198 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01b6 _strncat_s 01c4 ??1_LocaleUpdate@@QAE@XZ 0268 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 029a ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 0337 __ismbblead_l 03bf __CrtGetCheckCount 03d0 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0651 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 9C 00 00 00 C7 45 E8 00 00 00 00 83 7D 14 00 75 13 83 7D 08 00 75 0D 83 7D 0C 00 75 07 33 C0 E9 B1 07 00 00 83 7D 08 00 74 12 83 7D 0C 00 76 0C C7 85 7C FF FF FF 01 00 00 00 EB 0A C7 85 7C FF FF FF 00 00 00 00 8B 85 7C FF FF FF 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 20 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 2C 07 00 00 83 7D 14 00 0F 84 CE 00 00 00 83 7D 10 00 0F 85 C4 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 52 81 7D 0C FF FF FF 7F 74 49 83 7D 0C 01 76 43 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0E 8B 0D ?? ?? ?? ?? 89 8D 78 FF FF FF EB 0C 8B 55 0C 83 EA 01 89 95 78 FF FF FF 8B 85 78 FF FF FF 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 23 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 54 06 00 00 8B 4D 18 51 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 2B 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 9C 8D 4D EC E8 ?? ?? ?? ?? 8B 45 9C E9 0C 06 00 00 8B 4D 08 89 4D FC 8B 55 0C 89 55 E4 83 7D E4 00 76 1E 8B 45 FC 0F B6 08 85 C9 74 14 8B 55 FC 83 C2 01 89 55 FC 8B 45 E4 83 E8 01 89 45 E4 EB DC 83 7D E4 00 0F 85 F0 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 51 81 7D 0C FF FF FF 7F 74 48 83 7D 0C 01 76 42 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0D A1 ?? ?? ?? ?? 89 85 74 FF FF FF EB 0C 8B 4D 0C 83 E9 01 89 8D 74 FF FF FF 8B 95 74 FF FF FF 52 68 FE 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 10 33 D2 74 0C C7 85 70 FF FF FF 01 00 00 00 EB 0A C7 85 70 FF FF FF 00 00 00 00 8B 85 70 FF FF FF 89 45 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 98 16 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 98 E9 E2 04 00 00 8B 55 E4 3B 55 0C 73 7E C7 45 E0 00 00 00 00 8B 45 08 89 45 CC 8B 4D FC 83 E9 01 89 4D D0 8B 55 D0 89 55 C8 8B 45 C8 3B 45 CC 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D C8 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 45 C8 83 E8 01 89 45 C8 EB D1 8B 4D D0 2B 4D C8 83 E1 01 F7 D9 1B C9 F7 D9 89 4D E0 74 1F 8B 55 FC 83 EA 01 89 55 FC 8B 45 FC C6 00 00 8B 4D E4 83 C1 01 89 4D E4 C7 45 E8 01 00 00 00 83 7D 14 FF 75 38 8B 55 FC 8B 45 10 8A 08 88 0A 8B 55 FC 0F B6 02 8B 4D FC 83 C1 01 89 4D FC 8B 55 10 83 C2 01 89 55 10 85 C0 74 0D 8B 45 E4 83 E8 01 89 45 E4 74 02 EB CD E9 86 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 26 8B 4D 14 3B 4D E4 72 1E 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 14 00 76 3C 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 0F B6 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 83 C0 01 89 45 10 85 C9 74 16 8B 4D E4 83 E9 01 89 4D E4 74 0B 8B 55 14 83 EA 01 89 55 14 EB BE 83 7D 14 00 75 0F 8B 45 FC C6 00 00 8B 4D FC 83 C1 01 89 4D FC 83 7D E4 00 0F 85 69 02 00 00 8B 55 10 0F B6 02 85 C0 74 0A 83 7D 14 01 0F 85 81 00 00 00 8B 4D 08 89 4D C0 8B 55 FC 83 EA 01 89 55 C4 8B 45 C4 89 45 BC 8B 4D BC 3B 4D C0 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 BC 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 4D BC 83 E9 01 89 4D BC EB D1 8B 55 C4 2B 55 BC 83 E2 01 F7 DA 1B D2 F7 DA 89 55 E0 74 29 8B 45 FC C6 40 FF 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 94 2A 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 94 E9 F9 02 00 00 83 7D 14 FF 0F 85 D3 00 00 00 83 7D E8 00 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 7D 0C 01 0F 86 97 00 00 00 C7 45 E0 00 00 00 00 8B 4D 08 89 4D B4 8B 55 0C 8B 45 08 8D 4C 10 FE 89 4D B8 8B 55 B8 89 55 B0 8B 45 B0 3B 45 B4 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D B0 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 45 B0 83 E8 01 89 45 B0 EB D1 8B 4D B8 2B 4D B0 83 E1 01 F7 D9 1B C9 F7 D9 89 4D E0 74 34 8B 55 08 03 55 0C C6 42 FE 00 83 3D ?? ?? ?? ?? 00 76 0A 8B 45 08 03 45 0C C6 40 FF FE C7 45 90 50 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 90 E9 3D 02 00 00 8B 4D 08 03 4D 0C C6 41 FF 00 C7 45 8C 50 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 8C E9 1C 02 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 52 81 7D 0C FF FF FF 7F 74 49 83 7D 0C 01 76 43 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0E 8B 0D ?? ?? ?? ?? 89 8D 6C FF FF FF EB 0C 8B 55 0C 83 EA 01 89 95 6C FF FF FF 8B 85 6C FF FF FF 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 10 33 C0 74 0C C7 85 68 FF FF FF 01 00 00 00 EB 0A C7 85 68 FF FF FF 00 00 00 00 8B 8D 68 FF FF FF 89 4D AC 83 7D AC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D AC 00 75 40 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 BC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 88 22 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 88 E9 25 01 00 00 8B 45 E4 3B 45 0C 73 6F 8B 4D 08 89 4D A4 8B 55 FC 83 EA 02 89 55 A8 8B 45 A8 89 45 A0 8B 4D A0 3B 4D A4 72 27 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 A0 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0B 8B 4D A0 83 E9 01 89 4D A0 EB D1 8B 55 A8 2B 55 A0 83 E2 01 F7 DA 1B D2 F7 DA 89 55 E0 74 17 8B 45 FC C6 40 FE 00 8B 4D E4 83 C1 01 89 4D E4 C7 45 E8 01 00 00 00 83 7D 0C FF 74 71 81 7D 0C FF FF FF 7F 74 68 8B 55 0C 2B 55 E4 83 C2 01 3B 55 0C 73 5A 8B 45 0C 2B 45 E4 83 C0 01 8B 4D 0C 2B C8 39 0D ?? ?? ?? ?? 73 0E 8B 15 ?? ?? ?? ?? 89 95 64 FF FF FF EB 14 8B 45 0C 2B 45 E4 83 C0 01 8B 4D 0C 2B C8 89 8D 64 FF FF FF 8B 95 64 FF FF FF 52 68 FE 00 00 00 8B 45 0C 2B 45 E4 8B 4D 08 8D 54 01 01 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E8 00 74 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 84 2A 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 84 EB 12 C7 45 80 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 80 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__wexeclpe"
		size = 455
		refs = "001b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GC@MNNNPHFH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BE@OBFMGHMB@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAl?$AAp?$AAe?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0145 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01bc __wexecvpe"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 57 01 00 00 8B 55 08 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 F4 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 90 00 00 00 8B 4D 0C 0F B7 11 F7 DA 1B D2 F7 DA 89 55 EC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 30 8D 4D 0C 89 4D FC 8B 55 FC 8B 02 8B 4D FC 83 C1 04 89 4D FC 85 C0 74 02 EB EC 8B 55 FC 8B 02 50 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "_wcstok_s"
		size = 555
		refs = "001b ??_C@_1CG@NGEOKDE@?$AA?$CI?$AA_?$AAC?$AAo?$AAn?$AAt?$AAe?$AAx?$AAt?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GI@KOMEMGPL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BC@DIFGONLO@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAk?$AA_?$AAs?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CG@CBDCOOGB@?$AA?$CI?$AA_?$AAC?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f9 ??_C@_1GK@OCGBCEPL@?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CK?$AA_?$AAC?$AAo?$AAn@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 33 C0 83 7D 10 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 12 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 12 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 BC 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 13 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 13 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 59 01 00 00 83 7D 08 00 75 11 8B 4D 10 83 39 00 75 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 01 00 00 00 8B 55 E8 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 14 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 14 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 DE 00 00 00 83 7D 08 00 75 08 8B 4D 10 8B 11 89 55 08 EB 09 8B 45 08 83 C0 02 89 45 08 8B 4D 08 0F B7 11 85 D2 74 3B 8B 45 0C 89 45 F8 EB 09 8B 4D F8 83 C1 02 89 4D F8 8B 55 F8 0F B7 02 85 C0 74 12 8B 4D F8 0F B7 11 8B 45 08 0F B7 08 3B D1 74 02 EB DB 8B 55 F8 0F B7 02 85 C0 75 02 EB 02 EB B2 8B 4D 08 89 4D FC EB 09 8B 55 08 83 C2 02 89 55 08 8B 45 08 0F B7 08 85 C9 74 4C 8B 55 0C 89 55 F8 EB 09 8B 45 F8 83 C0 02 89 45 F8 8B 4D F8 0F B7 11 85 D2 74 12 8B 45 F8 0F B7 08 8B 55 08 0F B7 02 3B C8 74 02 EB DB 8B 4D F8 0F B7 11 85 D2 74 13 33 C0 8B 4D 08 66 89 01 8B 55 08 83 C2 02 89 55 08 EB 02 EB A1 8B 45 10 8B 4D 08 89 08 8B 55 FC 3B 55 08 75 06 33 C0 EB 05 EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__tell"
		size = 23
		refs = "000e __lseek"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "___ascii_strnicmp"
		size = 97
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 4D 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 0A E4 8A 07 74 27 0A C0 74 23 83 C6 01 83 C7 01 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 0B 83 E9 01 75 D1 33 C9 3A E0 74 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "__validate_param_reuseA"
		size = 621
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 8B 45 08 0F BE 48 08 83 F9 70 74 09 0F BE 55 10 83 FA 70 75 17 8B 45 08 0F BE 48 08 0F BE 55 10 33 C0 3B CA 0F 94 C0 E9 27 02 00 00 8B 45 08 0F BE 48 08 83 F9 73 74 15 8B 55 08 0F BE 42 08 83 F8 53 74 09 C7 45 F4 00 00 00 00 EB 07 C7 45 F4 01 00 00 00 8B 4D F4 89 4D FC 0F BE 55 10 83 FA 73 74 12 0F BE 45 10 83 F8 53 74 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 4D F0 89 4D F8 83 7D FC 00 75 06 83 7D F8 00 74 45 8B 55 FC 3B 55 F8 75 2E 8B 45 08 8B 48 0C 81 E1 10 08 00 00 F7 D9 1B C9 F7 D9 8B 55 14 81 E2 10 08 00 00 F7 DA 1B D2 F7 DA 3B CA 75 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC E9 80 01 00 00 8B 45 08 0F BE 48 08 83 F9 64 74 76 8B 55 08 0F BE 42 08 83 F8 69 74 6A 8B 4D 08 0F BE 51 08 83 FA 6F 74 5E 8B 45 08 0F BE 48 08 83 F9 75 74 52 8B 55 08 0F BE 42 08 83 F8 78 74 46 8B 4D 08 0F BE 51 08 83 FA 58 74 3A 0F BE 45 10 83 F8 64 74 31 0F BE 4D 10 83 F9 69 74 28 0F BE 55 10 83 FA 6F 74 1F 0F BE 45 10 83 F8 75 74 16 0F BE 4D 10 83 F9 78 74 0D 0F BE 55 10 83 FA 58 0F 85 F1 00 00 00 8B 45 08 0F BE 48 08 83 F9 64 74 45 8B 55 08 0F BE 42 08 83 F8 69 74 39 8B 4D 08 0F BE 51 08 83 FA 6F 74 2D 8B 45 08 0F BE 48 08 83 F9 75 74 21 8B 55 08 0F BE 42 08 83 F8 78 74 15 8B 4D 08 0F BE 51 08 83 FA 58 74 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 01 00 00 00 0F BE 45 10 83 F8 64 74 36 0F BE 4D 10 83 F9 69 74 2D 0F BE 55 10 83 FA 6F 74 24 0F BE 45 10 83 F8 75 74 1B 0F BE 4D 10 83 F9 78 74 12 0F BE 55 10 83 FA 58 74 09 C7 45 E4 00 00 00 00 EB 07 C7 45 E4 01 00 00 00 8B 45 E8 3B 45 E4 74 04 33 C0 EB 54 8B 4D 08 8B 51 0C 81 E2 00 00 01 00 F7 DA 1B D2 F7 DA 8B 45 14 25 00 00 01 00 F7 D8 1B C0 F7 D8 3B D0 75 1F 8B 4D 08 8B 51 0C 83 E2 20 F7 DA 1B D2 F7 DA 8B 45 14 83 E0 20 F7 D8 1B C0 F7 D8 3B D0 74 04 33 C0 EB 0D 8B 4D 08 8B 11 33 C0 3B 55 0C 0F 94 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_124_1_0 {
	meta:
		name = "__output_p_l"
		size = 14928
		refs = "000c ___security_cookie 0069 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00ea ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00f6 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00fd __CrtDbgReportW 0114 __errno 012b ??_C@_1BI@KANOLAMF@?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AA_?$AAl?$AA?$AA@ 0135 __invalid_parameter 014d ??1_LocaleUpdate@@QAE@XZ 017f __fileno 01b6 ___pioinfo 01c8 ___badioinfo 0262 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 02ed ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 047a ___lookuptable_s 04f2 _strtol 0523 _memset 05d0 ??_C@_1JC@PFJNKEIO@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN?$AA?$DN@ 06b8 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 074c $LN390 078a ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0798 __isleadbyte_l 07bb _write_char 07ec ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 08fd $LN386 0904 $LN391 0980 _get_int_arg 0a15 ??_C@_1JE@NMBHOLFI@?$AA?$CI?$AA?$CI?$AAw?$AAi?$AAd?$AAt?$AAh?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN@ 0b36 __validate_param_reuseA 0b4c ??_C@_1II@PIPIMLPF@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0cf9 ??_C@_1JG@JBJBOCFB@?$AA?$CI?$AA?$CI?$AAp?$AAr?$AAe?$AAc?$AAi?$AAs?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5@ 0e30 ??_C@_1IK@EIEPDKHJ@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0f3a $LN387 0f41 $LN392 10aa $LN388 10b1 $LN393 10fe _get_short_arg 114f ??_C@_1EM@BNPHBBIA@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DO?$AA?$DN?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DM?$AA_?$AAA?$AAR?$AAG@ 125f ??_C@_1IK@MHEDJAMK@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 1320 _wctomb_s 14b4 ??_C@_1IG@FDCPLALG@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 16ee ??_C@_1IG@HJIMKDHC@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 17a9 ___nullstring 17bb _strlen 1aaa ___wnullstring 1d98 __get_printf_count_output 1dd4 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 2009 ??_C@_1IM@DNGHAPLB@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 20f4 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 2108 __malloc_dbg 222e ??_C@_1DG@GOHGNKHE@?$AAp?$AAa?$AAs?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAF?$AAO?$AAR?$AAM?$AAA?$AAT?$AA_?$AAO?$AAU?$AAT?$AAP?$AAU?$AAT?$AA_?$AAP?$AAA?$AAS?$AAS?$AA?$AA@ 22c3 __cfltcvt_tab 22c9 __decode_pointer 246c _get_int64_arg 25d2 ??_C@_1IK@NBGDDCBN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 2806 ??_C@_1JC@OACKELNN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 32bc __aullrem 32e1 __aulldiv 345d _write_multi_char 347e _write_string 35ff __free_dbg 3653 ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 3747 $LN394 383b _get_crtdouble_arg 3883 ??_C@_1FK@BCPANIEK@?$AA?$CI?$AA?$CC?$AAM?$AAi?$AAs?$AAs?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt@ 3922 @__security_check_cookie@4 392c $LN265 3930 $LN259 3934 $LN258 3938 $LN250 393c $LN238 3940 $LN237 3944 $LN225 3948 $LN209 394c $LN253 3950 $LN252 3954 $LN254 3958 $LN255 395c $LN251 3960 $LN256 3978 $LN219 397c $LN211 3980 $LN222 3984 $LN210 3988 $LN223 39bc $LN138 39c0 $LN206 39c4 $LN170 39c8 $LN112 39cc $LN184 39d0 $LN137 39d4 $LN204 39d8 $LN117 39dc $LN151 39e0 $LN107 39e4 $LN113 39e8 $LN168 39ec $LN115 39f0 $LN110 39f4 $LN207 3a30 $LN9 3a34 $LN8 3a38 $LN7 3a3c $LN6 3a40 $LN5 3a44 $LN4 3a48 $LN2 3a4c $LN3"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 20 0B 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 58 F9 FF FF C7 85 3C F7 FF FF 00 00 00 00 C7 85 A4 F9 FF FF 00 00 00 00 C7 85 98 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF 00 00 00 00 C7 85 90 F9 FF FF 00 00 00 00 C7 85 78 F9 FF FF 00 00 00 00 C7 85 A8 F9 FF FF 00 00 00 00 8B 45 10 50 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? C7 85 94 F9 FF FF 00 00 00 00 C7 85 80 F9 FF FF 00 00 00 00 C7 85 48 F7 FF FF 00 00 00 00 C7 85 AC F9 FF FF 00 00 00 00 C7 85 84 F9 FF FF FF FF FF FF C7 85 A0 F9 FF FF FF FF FF FF C7 85 B0 F9 FF FF FF FF FF FF C7 85 7C F9 FF FF FF FF FF FF C7 85 B4 F9 FF FF FF FF FF FF C7 85 8C F9 FF FF 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 38 F7 FF FF 83 BD 38 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 38 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 02 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 08 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 08 F6 FF FF E9 BD 37 00 00 8B 45 08 89 85 34 F7 FF FF 8B 8D 34 F7 FF FF 8B 51 0C 83 E2 40 0F 85 CB 00 00 00 8B 85 34 F7 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 30 F7 FF FF 83 BD 30 F7 FF FF FF 74 2D 83 BD 30 F7 FF FF FE 74 24 8B 8D 30 F7 FF FF C1 F9 05 8B 95 30 F7 FF FF 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 95 64 F5 FF FF EB 0A C7 85 64 F5 FF FF ?? ?? ?? ?? 8B 85 64 F5 FF FF 8A 48 24 D0 E1 D0 F9 0F BE D1 85 D2 75 56 83 BD 30 F7 FF FF FF 74 2D 83 BD 30 F7 FF FF FE 74 24 8B 85 30 F7 FF FF C1 F8 05 8B 8D 30 F7 FF FF 83 E1 1F C1 E1 06 03 0C 85 ?? ?? ?? ?? 89 8D 60 F5 FF FF EB 0A C7 85 60 F5 FF FF ?? ?? ?? ?? 8B 95 60 F5 FF FF 8A 42 24 C0 E0 00 C0 F8 07 0F BE C8 85 C9 74 0C C7 85 5C F5 FF FF 00 00 00 00 EB 0A C7 85 5C F5 FF FF 01 00 00 00 8B 95 5C F5 FF FF 89 95 2C F7 FF FF 83 BD 2C F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 2C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 04 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 04 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 04 F6 FF FF E9 45 36 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 8D 28 F7 FF FF 83 BD 28 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 28 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 00 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 00 F6 FF FF E9 BA 35 00 00 C7 85 54 F7 FF FF 00 00 00 00 8B 45 0C 89 85 94 F9 FF FF C7 85 48 F7 FF FF 00 00 00 00 EB 0F 8B 8D 48 F7 FF FF 83 C1 01 89 8D 48 F7 FF FF 83 BD 48 F7 FF FF 02 0F 8D 62 35 00 00 83 BD 48 F7 FF FF 01 75 0E 83 BD B4 F9 FF FF 00 75 05 E9 4B 35 00 00 C7 85 88 F9 FF FF 00 00 00 00 C7 85 40 F7 FF FF 00 00 00 00 C7 85 8C F9 FF FF 00 00 00 00 C7 85 5C F9 FF FF 00 00 00 00 C7 85 84 F9 FF FF FF FF FF FF C7 85 98 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF 00 00 00 00 8B 95 94 F9 FF FF 89 55 0C C7 85 A0 F9 FF FF FF FF FF FF C7 85 B0 F9 FF FF FF FF FF FF C7 85 7C F9 FF FF FF FF FF FF C7 85 B4 F9 FF FF FF FF FF FF 8B 45 0C 8A 08 88 8D 4F F7 FF FF 0F BE 95 4F F7 FF FF 8B 45 0C 83 C0 01 89 45 0C 85 D2 0F 84 CA 31 00 00 83 BD 54 F7 FF FF 00 0F 8C BD 31 00 00 0F BE 8D 4F F7 FF FF 83 F9 20 7C 25 0F BE 95 4F F7 FF FF 83 FA 78 7F 19 0F BE 85 4F F7 FF FF 0F B6 88 ?? ?? ?? ?? 83 E1 0F 89 8D 58 F5 FF FF EB 0A C7 85 58 F5 FF FF 00 00 00 00 8B 95 58 F5 FF FF 89 95 50 F7 FF FF 8B 85 50 F7 FF FF 6B C0 09 8B 8D 40 F7 FF FF 0F B6 94 08 ?? ?? ?? ?? C1 FA 04 89 95 40 F7 FF FF 83 BD 40 F7 FF FF 01 0F 85 AF 01 00 00 8B 45 0C 0F BE 08 83 F9 25 0F 84 A0 01 00 00 83 BD B4 F9 FF FF FF 75 5C 6A 0A 8D 95 80 F9 FF FF 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7E 39 8B 8D 80 F9 FF FF 0F BE 11 83 FA 24 75 2B 83 BD 48 F7 FF FF 00 75 16 68 40 06 00 00 6A 00 8D 85 C0 F9 FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 B4 F9 FF FF 01 00 00 00 EB 0A C7 85 B4 F9 FF FF 00 00 00 00 83 BD B4 F9 FF FF 01 0F 85 29 01 00 00 6A 0A 8D 8D 80 F9 FF FF 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 A0 F9 FF FF 8B 85 80 F9 FF FF 83 C0 01 89 45 0C 83 BD 48 F7 FF FF 00 0F 85 F2 00 00 00 83 BD A0 F9 FF FF 00 7C 23 8B 8D 80 F9 FF FF 0F BE 11 83 FA 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 54 F5 FF FF 01 00 00 00 EB 0A C7 85 54 F5 FF FF 00 00 00 00 8B 85 54 F5 FF FF 89 85 24 F7 FF FF 83 BD 24 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 50 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 24 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 50 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 FC F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 FC F5 FF FF E9 D7 32 00 00 8B 95 A0 F9 FF FF 3B 95 84 F9 FF FF 7E 0E 8B 85 A0 F9 FF FF 89 85 50 F5 FF FF EB 0C 8B 8D 84 F9 FF FF 89 8D 50 F5 FF FF 8B 95 50 F5 FF FF 89 95 84 F9 FF FF E9 AF 00 00 00 83 BD 40 F7 FF FF 08 0F 85 A2 00 00 00 33 C0 74 0C C7 85 4C F5 FF FF 01 00 00 00 EB 0A C7 85 4C F5 FF FF 00 00 00 00 8B 8D 4C F5 FF FF 89 8D 20 F7 FF FF 83 BD 20 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 5C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 20 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 5C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F8 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 F8 F5 FF FF E9 EF 31 00 00 8B 85 40 F7 FF FF 89 85 48 F5 FF FF 83 BD 48 F5 FF FF 07 0F 87 CD 2E 00 00 8B 8D 48 F5 FF FF FF 24 8D ?? ?? ?? ?? 83 BD 48 F7 FF FF 00 75 09 83 BD B4 F9 FF FF 01 74 12 83 BD 48 F7 FF FF 01 75 0E 83 BD B4 F9 FF FF FF 75 05 E9 97 2E 00 00 C7 85 A8 F9 FF FF 00 00 00 00 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 50 0F B6 95 4F F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B7 00 00 00 8D 85 54 F7 FF FF 50 8B 4D 08 51 0F B6 95 4F F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8A 08 88 8D 4F F7 FF FF 8B 55 0C 83 C2 01 89 55 0C 0F BE 85 4F F7 FF FF F7 D8 1B C0 F7 D8 89 85 1C F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 1C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F4 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 F4 F5 FF FF E9 BB 30 00 00 8D 95 54 F7 FF FF 52 8B 45 08 50 0F B6 8D 4F F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C E9 92 2D 00 00 C7 85 74 F9 FF FF 00 00 00 00 8B 95 74 F9 FF FF 89 95 78 F9 FF FF 8B 85 78 F9 FF FF 89 85 98 F9 FF FF 8B 8D 98 F9 FF FF 89 8D 90 F9 FF FF C7 85 A4 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF FF FF FF FF C7 85 A8 F9 FF FF 00 00 00 00 E9 41 2D 00 00 0F BE 95 4F F7 FF FF 89 95 44 F5 FF FF 8B 85 44 F5 FF FF 83 E8 20 89 85 44 F5 FF FF 83 BD 44 F5 FF FF 10 77 69 8B 8D 44 F5 FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 85 A4 F9 FF FF 83 C8 04 89 85 A4 F9 FF FF EB 44 8B 8D A4 F9 FF FF 83 C9 01 89 8D A4 F9 FF FF EB 33 8B 95 A4 F9 FF FF 83 CA 02 89 95 A4 F9 FF FF EB 22 8B 85 A4 F9 FF FF 0D 80 00 00 00 89 85 A4 F9 FF FF EB 0F 8B 8D A4 F9 FF FF 83 C9 08 89 8D A4 F9 FF FF E9 AE 2C 00 00 0F BE 95 4F F7 FF FF 83 FA 2A 0F 85 A6 02 00 00 83 BD B4 F9 FF FF 00 75 17 8D 45 14 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 98 F9 FF FF E9 5E 02 00 00 6A 0A 8D 8D 80 F9 FF FF 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 B0 F9 FF FF 8B 85 80 F9 FF FF 83 C0 01 89 45 0C 83 BD 48 F7 FF FF 00 0F 85 FC 01 00 00 83 BD B0 F9 FF FF 00 7C 23 8B 8D 80 F9 FF FF 0F BE 11 83 FA 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 40 F5 FF FF 01 00 00 00 EB 0A C7 85 40 F5 FF FF 00 00 00 00 8B 85 40 F5 FF FF 89 85 18 F7 FF FF 83 BD 18 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BB 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 18 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 BB 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F0 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 F0 F5 FF FF E9 92 2E 00 00 8B 95 B0 F9 FF FF 3B 95 84 F9 FF FF 7E 0E 8B 85 B0 F9 FF FF 89 85 3C F5 FF FF EB 0C 8B 8D 84 F9 FF FF 89 8D 3C F5 FF FF 8B 95 3C F5 FF FF 89 95 84 F9 FF FF 8B 85 B0 F9 FF FF C1 E0 04 83 BC 05 C0 F9 FF FF 00 75 45 8B 8D B0 F9 FF FF C1 E1 04 C7 84 0D C0 F9 FF FF 01 00 00 00 8B 95 B0 F9 FF FF C1 E2 04 8A 85 4F F7 FF FF 88 84 15 C8 F9 FF FF 8B 8D B0 F9 FF FF C1 E1 04 8B 95 A4 F9 FF FF 89 94 0D CC F9 FF FF E9 AB 00 00 00 8B 85 A4 F9 FF FF 50 0F B6 8D 4F F7 FF FF 51 6A 01 8B 95 B0 F9 FF FF C1 E2 04 8D 84 15 C0 F9 FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 14 F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 C0 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 14 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C0 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 EC F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 EC F5 FF FF E9 5B 2D 00 00 E9 4D 2A 00 00 EB 2B 8B 95 B0 F9 FF FF C1 E2 04 8B 84 15 C4 F9 FF FF 89 85 10 F7 FF FF 8D 8D 10 F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 98 F9 FF FF 83 BD 98 F9 FF FF 00 7D 1D 8B 95 A4 F9 FF FF 83 CA 04 89 95 A4 F9 FF FF 8B 85 98 F9 FF FF F7 D8 89 85 98 F9 FF FF EB 1A 8B 8D 98 F9 FF FF 6B C9 0A 0F BE 95 4F F7 FF FF 8D 44 11 D0 89 85 98 F9 FF FF E9 D9 29 00 00 C7 85 70 F9 FF FF 00 00 00 00 E9 CA 29 00 00 0F BE 8D 4F F7 FF FF 83 F9 2A 0F 85 93 02 00 00 83 BD B4 F9 FF FF 00 75 17 8D 55 14 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 70 F9 FF FF E9 5E 02 00 00 6A 0A 8D 85 80 F9 FF FF 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 7C F9 FF FF 8B 95 80 F9 FF FF 83 C2 01 89 55 0C 83 BD 48 F7 FF FF 00 0F 85 FC 01 00 00 83 BD 7C F9 FF FF 00 7C 23 8B 85 80 F9 FF FF 0F BE 08 83 F9 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 38 F5 FF FF 01 00 00 00 EB 0A C7 85 38 F5 FF FF 00 00 00 00 8B 95 38 F5 FF FF 89 95 0C F7 FF FF 83 BD 0C F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F0 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 0C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F0 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 E8 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 E8 F5 FF FF E9 AE 2B 00 00 8B 8D 7C F9 FF FF 3B 8D 84 F9 FF FF 7E 0E 8B 95 7C F9 FF FF 89 95 34 F5 FF FF EB 0C 8B 85 84 F9 FF FF 89 85 34 F5 FF FF 8B 8D 34 F5 FF FF 89 8D 84 F9 FF FF 8B 95 7C F9 FF FF C1 E2 04 83 BC 15 C0 F9 FF FF 00 75 45 8B 85 7C F9 FF FF C1 E0 04 C7 84 05 C0 F9 FF FF 01 00 00 00 8B 8D 7C F9 FF FF C1 E1 04 8A 95 4F F7 FF FF 88 94 0D C8 F9 FF FF 8B 85 7C F9 FF FF C1 E0 04 8B 8D A4 F9 FF FF 89 8C 05 CC F9 FF FF E9 AB 00 00 00 8B 95 A4 F9 FF FF 52 0F B6 85 4F F7 FF FF 50 6A 01 8B 8D 7C F9 FF FF C1 E1 04 8D 94 0D C0 F9 FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 08 F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 F5 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 08 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F5 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 E4 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 E4 F5 FF FF E9 77 2A 00 00 E9 69 27 00 00 EB 2B 8B 8D 7C F9 FF FF C1 E1 04 8B 94 0D C4 F9 FF FF 89 95 04 F7 FF FF 8D 85 04 F7 FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 70 F9 FF FF 83 BD 70 F9 FF FF 00 7D 0A C7 85 70 F9 FF FF FF FF FF FF EB 1A 8B 8D 70 F9 FF FF 6B C9 0A 0F BE 95 4F F7 FF FF 8D 44 11 D0 89 85 70 F9 FF FF E9 08 27 00 00 0F BE 8D 4F F7 FF FF 89 8D 30 F5 FF FF 8B 95 30 F5 FF FF 83 EA 49 89 95 30 F5 FF FF 83 BD 30 F5 FF FF 2E 0F 87 42 01 00 00 8B 85 30 F5 FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 0C 0F BE 02 83 F8 6C 75 1D 8B 4D 0C 83 C1 01 89 4D 0C 8B 95 A4 F9 FF FF 81 CA 00 10 00 00 89 95 A4 F9 FF FF EB 0F 8B 85 A4 F9 FF FF 83 C8 10 89 85 A4 F9 FF FF E9 F2 00 00 00 8B 4D 0C 0F BE 11 83 FA 36 75 2B 8B 45 0C 0F BE 48 01 83 F9 34 75 1F 8B 55 0C 83 C2 02 89 55 0C 8B 85 A4 F9 FF FF 0D 00 80 00 00 89 85 A4 F9 FF FF E9 98 00 00 00 8B 4D 0C 0F BE 11 83 FA 33 75 28 8B 45 0C 0F BE 48 01 83 F9 32 75 1C 8B 55 0C 83 C2 02 89 55 0C 8B 85 A4 F9 FF FF 25 FF 7F FF FF 89 85 A4 F9 FF FF EB 65 8B 4D 0C 0F BE 11 83 FA 64 74 37 8B 45 0C 0F BE 08 83 F9 69 74 2C }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "__wcsset_s"
		size = 524
		refs = "0031 ??_C@_1FC@PFMLEHKI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr@ 003a ??_C@_1GI@DFMIPMED@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0041 __CrtDbgReportW 0055 __errno 0069 ??_C@_1BE@DPBIJIKN@?$AA_?$AAw?$AAc?$AAs?$AAs?$AAe?$AAt?$AA_?$AAs?$AA?$AA@ 0073 __invalid_parameter 00e9 ___crtDebugFillThreshold 0116 _memset 011e ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0147 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 12 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 12 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 84 01 00 00 8B 55 08 89 55 FC 8B 45 0C 89 45 F8 8B 4D FC 0F B7 11 85 D2 74 20 8B 45 F8 83 E8 01 89 45 F8 74 15 8B 4D FC 66 8B 55 10 66 89 11 8B 45 FC 83 C0 02 89 45 FC EB D6 83 7D F8 00 0F 85 D3 00 00 00 33 C9 8B 55 08 66 89 0A 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E8 EB 09 8B 55 0C 83 EA 01 89 55 E8 8B 45 E8 D1 E0 50 68 FE 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 71 83 7D 0C FF 74 69 81 7D 0C FF FF FF 7F 74 60 8B 45 0C 2B 45 F8 83 C0 01 3B 45 0C 73 52 8B 4D 0C 2B 4D F8 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 E0 EB 11 8B 4D 0C 2B 4D F8 83 C1 01 8B 55 0C 2B D1 89 55 E0 8B 45 E0 D1 E0 50 68 FE 00 00 00 8B 4D 0C 2B 4D F8 8B 55 08 8D 44 4A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__ismbcdigit_l"
		size = 369
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 004b ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0063 ??1_LocaleUpdate@@QAE@XZ 00a5 ___crtGetStringTypeA 012c __isctype_l 0148 __chvalidator_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 DC 00 00 00 33 C9 66 89 4D EC 33 D2 66 89 55 EE 8B 45 08 C1 E8 08 25 FF 00 00 00 88 45 E8 8B 4D 08 81 E1 FF 00 00 00 88 4D E9 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 17 C7 45 E4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 E9 FE 00 00 00 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 48 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 42 04 50 8D 4D EC 51 6A 02 8D 55 E8 52 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 17 C7 45 E0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 E9 A6 00 00 00 0F B7 45 EE 85 C0 75 12 0F B7 4D EC 83 E1 04 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 DC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 72 EB 68 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 74 2F 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 83 B8 AC 00 00 00 01 7E 1C 8D 4D F0 E8 ?? ?? ?? ?? 50 6A 04 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D0 EB 1A 6A 04 8B 55 08 52 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D0 8B 45 D0 89 45 D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__CItan_pentium4"
		size = 608
		refs = "003d PI32INV 004d SHIFTER 0059 P_1 0065 QQ_2 0073 P_2 0092 P_3 00ad ONE 00b6 Ctable 00be MASK_35 0223 TWO_POW_M55 022b TWO_POW_55 024e __tan_default"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F C5 C0 03 66 25 FF 7F 66 2D 20 38 66 3D A8 08 0F 87 D7 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 F2 0F 2D D1 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 12 2D ?? ?? ?? ?? 81 C2 00 29 07 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 66 0F 12 35 ?? ?? ?? ?? C1 E2 04 8D 05 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 28 D8 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 66 0F 28 78 10 F2 0F 5C DD 66 0F 59 F8 66 0F 5C D1 66 0F 28 48 30 66 0F 59 C8 66 0F 28 60 60 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F2 0F 10 D9 66 0F 58 FC F2 0F 10 E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F2 0F 10 E2 66 0F 12 B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 66 0F 12 3D ?? ?? ?? ?? F2 0F 59 E6 66 0F 12 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F2 0F 10 E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 83 EC 10 F2 0F 58 C3 66 0F 13 44 24 04 DD 44 24 04 83 C4 10 C3 7F 3F 83 EC 10 66 C1 E8 04 66 3D 7E 0C 75 0C F2 0F 10 D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 13 5C 24 04 DD 44 24 04 83 C4 10 C3 E9 ?? ?? ?? ?? 8B FF 8D A4 24 00 00 00 00 05 00 00 00 00 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "__msize_base"
		size = 306
		refs = "0008 __sehtable$__msize_base 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1BO@JDDGCDOA@?$AAp?$AAb?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004e ??_C@_1FO@NOOBKGEM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1BI@MHNDMCP@?$AA_?$AAm?$AAs?$AAi?$AAz?$AAe?$AA_?$AAb?$AAa?$AAs?$AAe?$AA?$AA@ 0087 __invalid_parameter 0098 ___active_heap 00a2 __lock 00b5 ___sbh_find_block 00e2 __unlock 00f7 __crtheap 00fe __imp__HeapSize@12"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8A 00 00 00 83 3D ?? ?? ?? ?? 03 75 68 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 83 7D DC 00 74 0C 8B 45 08 8B 48 FC 83 E9 09 89 4D E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 83 7D DC 00 75 15 8B 55 08 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 E4 EB 16 8B 4D 08 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 45 E4 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "?set_terminate@@YAP6AXXZP6AXXZ@Z"
		size = 64
		refs = "0018 ?_ValidateExecute@@YAHP6GHXZ@Z 0024 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 16 E8 ?? ?? ?? ?? 8B 48 78 89 4D FC E8 ?? ?? ?? ?? 8B 55 08 89 50 78 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_2_0 {
	meta:
		name = "?set_unexpected@@YAP6AXXZP6AXXZ@Z"
		size = 64
		refs = "0018 ?_ValidateExecute@@YAHP6GHXZ@Z 0024 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 16 E8 ?? ?? ?? ?? 8B 48 7C 89 4D FC E8 ?? ?? ?? ?? 8B 55 08 89 50 7C 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_4_0 {
	meta:
		name = "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"
		size = 70
		refs = "0018 ?_ValidateExecute@@YAHP6GHXZ@Z 0024 __getptd"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 1C E8 ?? ?? ?? ?? 8B 88 80 00 00 00 89 4D FC E8 ?? ?? ?? ?? 8B 55 08 89 90 80 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_5_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 77
		refs = "0018 ?_ValidateExecute@@YAHP6GHXZ@Z 0025 ?__pInconsistency@@3P6AXXZA 002b __decode_pointer 003a __encode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 08 00 74 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 23 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 A3 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_130_6_0 {
	meta:
		name = "?set_terminate@@YAP6AXXZH@Z"
		size = 27
		refs = "000e ?set_terminate@@YAP6AXXZP6AXXZ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_130_8_0 {
	meta:
		name = "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZH@Z"
		size = 27
		refs = "000e ?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_130_7_0 {
	meta:
		name = "?set_unexpected@@YAP6AXXZH@Z"
		size = 27
		refs = "000e ?set_unexpected@@YAP6AXXZP6AXXZ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 0C 6A 00 E8 ?? ?? ?? ?? 83 C4 04 EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "__strerror"
		size = 374
		refs = "0010 __getptd_noexit 0030 ??_C@_0DB@MGMNBKNL@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 003e __calloc_dbg 007f ??_C@_1GC@MBPFHPKC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0084 ??_C@_1BE@OOJPNDPE@?$AA_?$AAs?$AAt?$AAr?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 0089 ??_C@_1GO@GJHBPGME@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAb?$AAl?$AAd?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5@ 00a0 __mbsnbcat_s 00a9 __invoke_watson_if_error 00bf ??_C@_1EG@OCAEMKFG@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAb?$AAl?$AAd?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5?$AA?$CC?$AA?3?$AA?5@ 00c4 ??_C@_02LMMGGCAJ@?3?5?$AA@ 00d2 _strcat_s 00e3 __errno 00eb __get_sys_err_msg 0104 ??_C@_1JE@FBKBDMHH@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAl?$AAd?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5?$AAs?$AAy?$AAs@ 010d _strlen 012d _strncat_s 014c ??_C@_1EG@COKGOLO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAb?$AAl?$AAd?$AAm?$AAs?$AAg?$AA?0?$AA?5?$AA?$CI?$AA9?$AA4?$AA?$CL?$AA3?$AA8?$AA?$CL?$AA2?$AA?$CJ?$AA?0?$AA?5?$AA?$CC?$AA?2?$AAn@ 0151 ??_C@_01EEMJAFIK@?6?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 F4 00 00 00 00 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 07 33 C0 E9 4E 01 00 00 8B 45 FC 83 78 24 00 75 2E 6A 4E 68 ?? ?? ?? ?? 6A 02 6A 01 68 86 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B 4D FC 89 41 24 8B 55 FC 83 7A 24 00 75 07 33 C0 E9 17 01 00 00 8B 45 FC 8B 48 24 89 4D F8 8B 55 F8 C6 02 00 83 7D 08 00 74 72 8B 45 08 0F BE 08 85 C9 74 68 6A 00 6A 59 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 82 00 00 00 8B 55 08 52 68 86 00 00 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 6A 5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 86 00 00 00 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? 8B 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 6A 00 6A 63 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 B9 86 00 00 00 2B C8 83 E9 02 51 8B 55 F4 52 68 86 00 00 00 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 86 00 00 00 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_132_2_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 57
		refs = "000d ___sys_nerr 002b ___sys_errlist"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 7C 14 E8 ?? ?? ?? ?? 8B 4D 08 3B 08 7D 08 8B 55 08 89 55 FC EB 0A E8 ?? ?? ?? ?? 8B 00 89 45 FC E8 ?? ?? ?? ?? 8B 4D FC 8B 04 88 8B E5 5D C3 }
	condition:
		$1
}

rule file_132_3_0 {
	meta:
		name = "__strerror_s"
		size = 432
		refs = "0022 ??_C@_1BO@PNINNIGK@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002e ??_C@_1GC@MBPFHPKC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0035 __CrtDbgReportW 0049 __errno 0060 ??_C@_1BI@LDPCOGGD@?$AA_?$AAs?$AAt?$AAr?$AAe?$AAr?$AAr?$AAo?$AAr?$AA_?$AAs?$AA?$AA@ 006a __invalid_parameter 008a ??_C@_1CC@JNJFIMGE@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0102 _strlen 0125 ??_C@_1FA@PEGHDKDC@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AAm@ 0136 _strcpy_s 013f __invoke_watson_if_error 0158 ??_C@_1EK@OEBMBFPG@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AA?$CC@ 015d ??_C@_02LMMGGCAJ@?3?5?$AA@ 016a _strcat_s 01a5 _strerror_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 31 01 00 00 33 D2 3B 55 0C 1B C0 F7 D8 89 45 F4 75 21 68 ?? ?? ?? ?? 6A 00 68 91 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 91 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 C9 00 00 00 8B 55 08 C6 02 00 83 7D 10 00 0F 84 87 00 00 00 8B 45 10 0F BE 08 85 C9 74 7D 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 83 E9 07 3B C1 73 67 6A 00 68 98 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 99 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? 8B 08 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 0C 2B C8 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 03 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "??_U@YAPAXI@Z"
		size = 28
		refs = "000b ??2@YAPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "__fcloseall"
		size = 296
		refs = "0008 __sehtable$__fcloseall 000d __except_handler4 001f ___security_cookie 003c __lock 0061 __nstream 006f ___piob 009d _fclose 00ca __imp__DeleteCriticalSection@4 00de __free_dbg 010b __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 C7 45 E0 03 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D E0 3B 0D ?? ?? ?? ?? 0F 8D 8F 00 00 00 8B 55 E0 A1 ?? ?? ?? ?? 83 3C 90 00 74 7C 8B 4D E0 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 48 0C 81 E1 83 00 00 00 74 22 8B 55 E0 A1 ?? ?? ?? ?? 8B 0C 90 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 09 8B 55 E4 83 C2 01 89 55 E4 83 7D E0 14 7C 3D 8B 45 E0 8B 0D ?? ?? ?? ?? 8B 14 81 83 C2 20 52 FF 15 ?? ?? ?? ?? 6A 02 8B 45 E0 8B 0D ?? ?? ?? ?? 8B 14 81 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 E0 8B 0D ?? ?? ?? ?? C7 04 81 00 00 00 00 E9 59 FF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "___mbtow_environ"
		size = 235
		refs = "0010 __environ 0035 __imp__MultiByteToWideChar@24 004d ??_C@_0DC@DNLKDOEK@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 005a __calloc_dbg 0099 __free_dbg 00ac ___crtwsetenv"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 F4 8B 4D F4 83 39 00 0F 84 C2 00 00 00 6A 00 6A 00 6A FF 8B 55 F4 8B 02 50 6A 00 6A 00 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 08 83 C8 FF E9 9D 00 00 00 6A 3C 68 ?? ?? ?? ?? 6A 02 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 75 05 83 C8 FF EB 78 8B 55 F8 52 8B 45 FC 50 6A FF 8B 4D F4 8B 11 52 6A 00 6A 00 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 13 6A 02 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 83 C8 FF EB 42 6A 00 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 7D 20 83 7D FC 00 74 15 6A 02 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC 00 00 00 00 83 C8 FF EB 10 8B 45 F4 83 C0 04 89 45 F4 E9 32 FF FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "__assert"
		size = 2769
		refs = "000c ___security_cookie 001a __set_error_mode 0036 ___app_type 003e ___iob_func 005c _setvbuf 0070 __assertstring 007e _fprintf 008f _fflush 00a3 ??_C@_1GA@COEIABIF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00a8 ??_C@_1BA@DADDCNOK@?$AA_?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AA?$AA@ 00ad ??_C@_1GK@MEIIIEKC@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 00b2 ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@ 00c3 _strcpy_s 00cc __invoke_watson_if_error 00e5 ??_C@_1FI@LABOHEIE@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd@ 00eb _dblnewline 00fd _strcat_s 011f ??_C@_1FK@JLNGAFHA@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 0124 ??_C@_09KLGCKDOD@Program?3?5?$AA@ 015c __imp__GetModuleFileNameA@12 0176 ??_C@_1GO@MKBPHEIL@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAp?$AAr?$AAo?$AAg?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?0?$AA?5?$AA?$CC?$AA?$DM?$AAp@ 017b ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 01b0 _strlen 01f0 ??_C@_1HO@DGLFHLNC@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?5?$AAp?$AAc?$AAh?$AA?0?$AA?5?$AA?$CI?$AA2?$AA6?$AA0?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAp@ 01f7 _dotdotdot 021a __mbsnbcpy_s 023c ??_C@_1EK@HNKCAGGP@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 0276 ??_C@_1FC@HGJOLIGH@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAn@ 027c _newline 02b0 ??_C@_1FE@JHHKPPGM@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 02b5 ??_C@_06IGPBOHMJ@File?3?5?$AA@ 03cc ??_C@_1GK@LELDAJFN@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ@ 03f4 __mbsnbcat_s 0416 ??_C@_1FG@BIHAHDLM@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd@ 0450 ??_C@_1FO@ILLBEHNB@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 05a3 ??_C@_1HC@NNJOOJHD@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ@ 0632 ??_C@_1HK@LJCIAEID@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ@ 06c5 ??_C@_1IC@IABENIAD@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAp@ 072e ??_C@_1FE@BELKICLD@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAf@ 079f ??_C@_1FE@EHMPHKDB@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 07a4 ??_C@_06FIEBOLOH@Line?3?5?$AA@ 07d7 ??_C@_1KG@MJEHKFDP@?$AA_?$AAi?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$CI?$AA?5?$AAl?$AAi?$AAn?$AAe?$AAn?$AAo?$AA?0?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?5?$AA?$CL?$AA?5?$AAs?$AAt?$AAr@ 0810 __itoa_s 086c ??_C@_1GA@GHECLIPG@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC@ 0871 ??_C@_0N@MEECIJGN@Expression?3?5?$AA@ 08d4 ??_C@_1CHK@HNOMNMBD@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ@ 0963 ??_C@_1EM@ENNCDANH@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AA?5?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAe@ 09d4 ??_C@_1BCK@FOGOPFPO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC?$AAF@ 09d9 ??_C@_0HA@OJHAGA@For?5information?5on?5how?5your?5prog@ 0a0c ??_C@_1FG@FPMGDMJC@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AAd?$AAb@ 0a46 ??_C@_1LM@PPELICOO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAa?$AAs?$AAs?$AAe?$AAr?$AAt?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA6?$AA0?$AA?5?$AA?$CK?$AA?5?$AA9?$AA?$CJ?$AA?0?$AA?5?$AA?$CC?$AA?$CI@ 0a4b ??_C@_0DN@EBBNMLME@?$CIPress?5Retry?5to?5debug?5the?5applic@ 0a72 ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 0a7e ___crtMessageBoxA 0a97 _raise 0aa1 __exit 0abd _abort 0ac9 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 48 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 6A 03 E8 ?? ?? ?? ?? 83 C4 04 83 F8 01 74 17 6A 03 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 67 83 3D ?? ?? ?? ?? 01 75 5E E8 ?? ?? ?? ?? 8B 40 4C 25 0C 01 00 00 75 17 6A 00 6A 04 6A 00 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 10 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 04 E9 21 0A 00 00 6A 00 68 B9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 BA 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 BF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 C6 85 CC FD FF FF 00 68 04 01 00 00 8D 95 C8 FC FF FF 52 6A 00 FF 15 ?? ?? ?? ?? 85 C0 75 38 6A 00 68 C3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 05 01 00 00 8D 85 C8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 8D C8 FC FF FF 89 8D D4 FD FF FF 8D 95 C8 FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 0B 83 F8 3C 76 6B 8D 85 C8 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D D4 FD FF FF 8D 54 01 CF 89 95 D4 FD FF FF 6A 00 68 CB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 03 A1 ?? ?? ?? ?? 50 8B 8D D4 FD FF FF 8D 95 C8 FC FF FF 2B CA B8 05 01 00 00 2B C1 50 8B 8D D4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 CE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 D4 FD FF FF 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 CF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 D4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 83 C0 08 83 F8 3C 0F 86 2E 04 00 00 8B 55 0C 89 95 D4 FD FF FF C7 85 B8 FC FF FF 34 00 00 00 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 BC FC FF FF C7 85 C0 FC FF FF 01 00 00 00 EB 0F 8B 8D C0 FC FF FF 83 C1 01 89 8D C0 FC FF FF 8B 95 BC FC FF FF 2B 95 C0 FC FF FF 8B 85 D4 FD FF FF 0F BE 0C 10 83 F9 5C 74 2B 8B 95 BC FC FF FF 2B 95 C0 FC FF FF 8B 85 D4 FD FF FF 0F BE 0C 10 83 F9 2F 74 10 8B 95 C0 FC FF FF 3B 95 BC FC FF FF 73 02 EB AB 8B 85 B8 FC FF FF 33 D2 B9 03 00 00 00 F7 F1 8B 95 B8 FC FF FF 2B D0 8B 85 BC FC FF FF 2B 85 C0 FC FF FF 3B D0 0F 83 EA 00 00 00 8B 85 B8 FC FF FF 33 D2 B9 03 00 00 00 F7 F1 3B 85 C0 FC FF FF 0F 86 CF 00 00 00 6A 00 68 E9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 B8 FC FF FF 83 EA 03 2B 95 C0 FC FF FF 52 8B 85 D4 FD FF FF 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 EB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D D4 FD FF FF 03 8D BC FC FF FF 2B 8D C0 FC FF FF 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E9 91 02 00 00 8B 85 B8 FC FF FF 33 D2 B9 03 00 00 00 F7 F1 8B 95 B8 FC FF FF 2B D0 8B 85 BC FC FF FF 2B 85 C0 FC FF FF 3B D0 0F 86 DD 00 00 00 8B 8D C0 FC FF FF D1 E9 89 8D C0 FC FF FF 6A 00 68 F3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 B8 FC FF FF 83 EA 03 2B 95 C0 FC FF FF 52 8B 85 D4 FD FF FF 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 F4 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 F5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D D4 FD FF FF 03 8D BC FC FF FF 2B 8D C0 FC FF FF 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E9 89 01 00 00 6A 00 68 FC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 B8 FC FF FF 33 D2 B9 03 00 00 00 F7 F1 8B 95 B8 FC FF FF 2B D0 83 EA 03 52 8B 85 D4 FD FF FF 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 FD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 FE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 B8 FC FF FF 33 D2 B9 06 00 00 00 F7 F1 83 E8 01 50 8B 95 D4 FD FF FF 03 95 BC FC FF FF 2B 95 C0 FC FF FF 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 FF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 00 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D D4 FD FF FF 03 8D BC FC FF FF 8B 85 B8 FC FF FF 33 D2 BE 03 00 00 00 F7 F6 8B F0 8B 85 B8 FC FF FF 33 D2 BF 06 00 00 00 F7 F7 2B F0 83 EE 02 2B CE 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 37 6A 00 68 06 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 0C 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 08 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 0D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 0E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 B9 1C 02 00 00 2B C8 51 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8D 84 05 D8 FD FF FF 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 0F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 14 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 8D 8C 06 B0 00 00 00 81 F9 1C 02 00 00 0F 86 8F 00 00 00 6A 00 68 24 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 05 B3 00 00 00 B9 1C 02 00 00 2B C8 51 8B 55 08 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 25 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 68 1C 02 00 00 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 37 6A 00 68 28 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 08 50 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 2A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 30 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 31 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 52 68 1C 02 00 00 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 36 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 1C 02 00 00 8D 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 68 12 20 01 00 68 ?? ?? ?? ?? 8D 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 C4 FC FF FF 83 BD C4 FC FF FF 03 75 11 6A 16 E8 ?? ?? ?? ?? 83 C4 04 6A 03 E8 ?? ?? ?? ?? 83 BD C4 FC FF FF 04 75 03 CC EB 10 83 BD C4 FC FF FF 05 75 02 EB 05 E8 ?? ?? ?? ?? 5F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "__aullshr"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F AD D0 D3 EA C3 8B C2 33 D2 80 E1 1F D3 E8 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__mbslwr_s_l"
		size = 937
		refs = "003d ??_C@_1JI@LJBHPGOE@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO@ 0046 ??_C@_1GA@MHBBCPNC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 004d __CrtDbgReportW 0061 __errno 0075 ??_C@_1BI@KPPLPFGP@?$AA_?$AAm?$AAb?$AAs?$AAl?$AAw?$AAr?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 007f __invalid_parameter 00a6 _strnlen 00df ___crtDebugFillThreshold 010a _memset 0112 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 013b ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 01f7 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0224 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 027a ___crtLCMapStringA 02f8 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C 83 7D 08 00 74 06 83 7D 0C 00 77 15 83 7D 08 00 75 06 83 7D 0C 00 74 09 C7 45 C8 00 00 00 00 EB 07 C7 45 C8 01 00 00 00 8B 45 C8 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 15 03 00 00 83 7D 08 00 75 07 33 C0 E9 08 03 00 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 8B 4D E4 3B 4D 0C 0F 82 D2 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D C4 EB 09 8B 55 0C 83 EA 01 89 55 C4 8B 45 C4 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 C0 01 00 00 00 EB 07 C7 45 C0 00 00 00 00 8B 4D C0 89 4D DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 44 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 17 02 00 00 83 7D 0C FF 74 5B 81 7D 0C FF FF FF 7F 74 52 8B 45 E4 83 C0 01 3B 45 0C 73 47 8B 4D E4 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 BC EB 0E 8B 4D E4 83 C1 01 8B 55 0C 2B D1 89 55 BC 8B 45 BC 50 68 FE 00 00 00 8B 4D E4 8B 55 08 8D 44 0A 01 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 10 51 8D 4D E8 E8 ?? ?? ?? ?? 8B 55 08 89 55 F8 8B 45 08 89 45 FC EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 0F B6 02 85 C0 0F 84 6D 01 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 04 0F 84 F8 00 00 00 6A 01 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 42 04 50 6A 02 8D 4D D4 51 6A 02 8B 55 F8 52 68 00 01 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 40 04 8B 48 0C 51 8D 4D E8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 24 89 45 D8 83 7D D8 00 75 7A E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D B8 EB 09 8B 55 0C 83 EA 01 89 55 B8 8B 45 B8 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 10 89 55 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 E9 A1 00 00 00 8B 45 FC 8A 4D D4 88 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 F8 83 C0 01 89 45 F8 83 7D D8 01 7E 11 8B 4D FC 8A 55 D5 88 11 8B 45 FC 83 C0 01 89 45 FC EB 51 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 10 74 1D 8D 4D E8 E8 ?? ?? ?? ?? 8B 50 04 8B 45 F8 0F B6 08 8A 94 0A 1D 01 00 00 88 55 B7 EB 08 8B 45 F8 8A 08 88 4D B7 8B 55 FC 8A 45 B7 88 02 8B 4D FC 83 C1 01 89 4D FC E9 7C FE FF FF 8B 55 FC C6 02 00 C7 45 CC 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_138_5_0 {
	meta:
		name = "__mbslwr_l"
		size = 40
		refs = "0016 __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 F7 D9 1B C9 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_623_5_0 {
	meta:
		name = "__mbsupr_l"
		size = 40
		refs = "0016 __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 F7 D9 1B C9 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_138_6_0 {
	meta:
		name = "__mbslwr"
		size = 38
		refs = "0014 __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 F7 D8 1B C0 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_623_6_0 {
	meta:
		name = "__mbsupr"
		size = 38
		refs = "0014 __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 08 F7 D8 1B C0 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "___libm_sse2_powf"
		size = 1715
		refs = "0004 _dword_mask 000f _SIGMASK 001b _EXPMASK 0048 _cv 0093 _B_table 009b _SCALE5 00c4 _T_tbl 00e9 _Shifter 0161 _cev 01a9 _exp2_tbl 01f6 _ABSVALMASK 02bf _NEG_ZEROD 0357 _ABSVALS 039b _ONEMASK 0437 _NEG_ZERO 0443 _NEG_INF 0492 _sNaN 0533 _INF"
	strings:
		$1 = { F3 0F 10 3D ?? ?? ?? ?? 83 EC 0C 66 0F 12 2D ?? ?? ?? ?? 66 0F DB C7 66 0F 12 1D ?? ?? ?? ?? 66 0F DB CF F3 0F 11 44 24 04 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB F3 0F 11 4C 24 08 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? F3 0F 5A C9 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B CA 81 F9 00 80 00 00 0F 83 7D 01 00 00 BA 3F 3F 00 00 B9 00 00 00 00 66 0F 6E C2 83 E0 7F 83 C0 01 25 FE 00 00 00 66 0F 12 3C 85 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 1A 66 0F 73 F7 1A 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 04 85 ?? ?? ?? ?? F2 0F 5C DF F2 0F 59 FD F2 0F 59 EB F2 0F 5C 3D ?? ?? ?? ?? F2 0F 58 EF 66 0F 70 FD 44 66 0F 12 1D ?? ?? ?? ?? F2 0F 58 C5 66 0F 59 F7 66 0F 59 FF F2 0F 58 C4 F2 0F 59 D7 F2 0F 58 C2 66 0F 70 D2 EE F2 0F 58 F2 F2 0F 59 C1 F2 0F 59 FF 66 0F C5 D0 03 F2 0F 10 E0 F2 0F 58 C3 F2 0F 5C C3 66 0F 59 F7 B8 D0 41 00 00 81 E2 F0 7F 00 00 2B C2 81 EA 60 3E 00 00 0B D0 81 FA 00 00 00 80 0F 83 F8 04 00 00 F2 0F 2D C0 F2 0F 5C E0 66 0F 70 FE EE F2 0F 58 F7 66 0F 28 3D ?? ?? ?? ?? F2 0F 59 CE 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 F6 F2 0F 58 E1 66 0F 70 EC 44 BA BF 0F 00 00 2B D0 05 A0 0F 00 00 0B D0 2D A0 0F 00 00 81 FA 00 00 00 80 0F 83 D9 03 00 00 8B D0 D1 FA 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 81 C9 F0 3F 00 00 83 E2 F0 03 CA 66 0F C4 F1 03 83 C4 0C 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 66 0F 5A C0 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E CA F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 66 0F 73 D0 20 66 0F 7E C1 81 F9 00 00 F0 7F 0F 83 D4 00 00 00 0B D1 83 FA 00 0F 84 20 03 00 00 66 0F 7E E2 81 FA FF FF 7F 7F 0F 86 DC 00 00 00 66 0F 73 F3 34 66 0F 56 FB B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D0 14 66 0F FA C3 66 0F EF DB 66 0F EE C3 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 83 38 01 00 00 81 F9 FF 00 00 00 0F 85 EF 01 00 00 66 0F 12 1D ?? ?? ?? ?? F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 34 66 0F FA C3 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 C1 01 7F 00 00 81 E1 00 80 00 00 81 FA 00 00 80 00 72 32 BA 3F BF 00 00 E9 8C FD FF FF 66 0F 7E E2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 77 05 E9 91 01 00 00 83 C4 0C F3 0F 10 C4 F3 0F 58 C0 C3 B9 00 00 00 00 66 0F 57 C0 BA 80 5F 00 00 66 0F C4 C2 01 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? F3 0F 59 E0 66 0F 7E E2 81 E2 FF FF FF 7F 83 FA 00 74 26 66 0F C5 C4 01 0F 28 C4 0F 54 25 ?? ?? ?? ?? 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB BA 3F 5F 00 00 E9 0D FD FF FF 8B 54 24 08 81 E2 00 00 00 80 83 FA 00 74 23 C1 E1 10 66 0F 7E E2 23 D1 81 CA 00 00 80 7F 66 0F 6E C2 83 C4 0C F3 0F 10 2D ?? ?? ?? ?? F3 0F 5E EC C3 C1 E1 10 66 0F 7E E2 23 D1 83 FA 00 75 7E 83 C4 0C 0F 57 C0 C3 66 0F 7E E2 81 FA 00 00 80 7F 0F 84 99 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 87 2F FF FF FF 81 F9 FF 00 00 00 75 65 F2 0F 10 E9 F2 0F 10 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 2D ?? ?? ?? ?? 66 0F 73 D5 34 66 0F FA EB 66 0F EF DB 66 0F F3 D5 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 27 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 D1 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 B7 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F 7E E0 3D 00 00 00 80 0F 84 E7 FE FF FF 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 C3 8B 44 24 08 8B C8 25 FF FF FF 7F 3D 00 00 80 7F 0F 87 87 00 00 00 81 E1 00 00 00 80 66 0F 7E E2 81 F2 00 00 80 BF 83 FA 00 74 30 83 F9 00 74 49 66 0F 7E E0 25 FF FF FF 7F 3D 00 00 80 3F 73 14 83 F8 00 75 4C B9 00 00 80 3F 66 0F 6E E9 F3 0F 5E EC EB 3D 83 C4 0C 0F 57 C0 C3 83 EC 10 0F AE 5C 24 0C 83 64 24 0C DE 0F AE 54 24 0C 83 C4 1C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C4 01 25 80 7F 00 00 3D 80 3F 00 00 73 07 83 C4 0C 0F 57 C0 C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 4C 24 08 83 C4 0C F3 0F 58 C9 F3 0F 10 C1 C3 66 0F 7E E0 F3 0F 10 05 ?? ?? ?? ?? 83 F8 00 74 17 66 0F 7E E0 0F 57 D2 F3 0F 58 E2 25 FF FF FF 7F 3D 00 00 80 7F 77 00 83 C4 0C C3 3D 00 20 00 00 0F 8D 92 00 00 00 3D 00 E0 FF FF 0F 8E 9E 00 00 00 66 0F 57 C9 8B D0 C1 FA 05 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 8B C2 D1 FA 2B C2 C1 E2 04 05 FF 03 00 00 C1 E0 04 81 C9 F0 3F 00 00 03 CA 66 0F C4 F1 03 66 0F C4 C8 03 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 F2 0F 59 C1 66 0F 5A C0 66 0F C5 C0 01 25 FF 7F 00 00 3D 80 7F 00 00 73 05 83 F8 10 72 00 83 C4 0C C3 83 C4 0C 81 C9 7F 7F 00 00 66 0F 57 C0 66 0F C4 C1 01 F3 0F 58 C0 C3 83 C4 0C B8 00 00 80 00 66 0F 6E E8 F3 0F 59 ED 66 0F 57 C0 66 0F C4 C1 01 C3 8B 54 24 04 F3 0F 10 64 24 04 81 FA 00 00 80 3F 0F 84 9C FE FF FF 8B 44 24 08 F3 0F 10 4C 24 08 25 FF FF FF 7F 3D 00 00 80 7F 0F 83 27 FE FF FF 83 F8 00 0F 84 CD FE FF FF 66 0F C5 D0 03 8B C2 81 E2 F0 7F 00 00 81 FA 60 3E 00 00 76 10 25 00 80 00 00 83 F8 00 0F 84 73 FF FF FF EB 88 83 C4 0C C1 E1 10 81 C9 00 00 80 3F 66 0F 6E C1 C3 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "_strncat_s"
		size = 1173
		refs = "004a ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0053 ??_C@_1GK@DICCLCDF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005a __CrtDbgReportW 006e __errno 0082 ??_C@_1BE@IAKAIGJB@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$AA@ 008c __invalid_parameter 00d4 ___crtDebugFillThreshold 00ff _memset 0119 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01fb ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0224 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 02b3 __CrtGetCheckCount 02c4 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 03d2 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 83 7D 14 00 75 13 83 7D 08 00 75 0D 83 7D 0C 00 75 07 33 C0 E9 70 04 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 18 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 18 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 F4 03 00 00 83 7D 14 00 0F 84 C5 00 00 00 83 7D 10 00 0F 85 BB 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E0 EB 09 8B 55 0C 83 EA 01 89 55 E0 8B 45 E0 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 25 03 00 00 8B 4D 08 89 4D FC 8B 55 0C 89 55 F8 83 7D F8 00 76 1E 8B 45 FC 0F BE 08 85 C9 74 14 8B 55 FC 83 C2 01 89 55 FC 8B 45 F8 83 E8 01 89 45 F8 EB DC 83 7D F8 00 0F 85 D1 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 48 81 7D 0C FF FF FF 7F 74 3F 83 7D 0C 01 76 39 8B 55 0C 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 DC EB 09 8B 4D 0C 83 E9 01 89 4D DC 8B 55 DC 52 68 FE 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 0D 33 D2 74 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 45 D8 89 45 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 29 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 29 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 1A 02 00 00 83 7D 14 FF 75 35 8B 55 FC 8B 45 10 8A 08 88 0A 8B 55 FC 0F BE 02 8B 4D FC 83 C1 01 89 4D FC 8B 55 10 83 C2 01 89 55 10 85 C0 74 0D 8B 45 F8 83 E8 01 89 45 F8 74 02 EB CD EB 7D E8 ?? ?? ?? ?? 85 C0 74 26 8B 4D 14 3B 4D F8 72 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 14 00 76 3C 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 0F BE 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 83 C0 01 89 45 10 85 C9 74 16 8B 4D F8 83 E9 01 89 4D F8 74 0B 8B 55 14 83 EA 01 89 55 14 EB BE 83 7D 14 00 75 06 8B 45 FC C6 00 00 83 7D F8 00 0F 85 E9 00 00 00 83 7D 14 FF 75 14 8B 4D 08 03 4D 0C C6 41 FF 00 B8 50 00 00 00 E9 3E 01 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D4 EB 09 8B 55 0C 83 EA 01 89 55 D4 8B 45 D4 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 4D D0 89 4D E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 48 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 6F 83 7D 0C FF 74 67 81 7D 0C FF FF FF 7F 74 5E 8B 45 0C 2B 45 F8 83 C0 01 3B 45 0C 73 50 8B 4D 0C 2B 4D F8 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 CC EB 11 8B 4D 0C 2B 4D F8 83 C1 01 8B 55 0C 2B D1 89 55 CC 8B 45 CC 50 68 FE 00 00 00 8B 4D 0C 2B 4D F8 8B 55 08 8D 44 0A 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "__mbsinc_l"
		size = 70
		refs = "0018 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 0F B6 08 89 4D FC 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 83 C1 01 89 4D 08 85 C0 74 13 8B 55 08 0F B6 02 85 C0 74 09 8B 4D 08 83 C1 01 89 4D 08 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "__mbsinc"
		size = 164
		refs = "001b ??_C@_1CA@HPEMMJMJ@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GA@DEBIMDFF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BA@GDAOKFNN@?$AA_?$AAm?$AAb?$AAs?$AAi?$AAn?$AAc?$AA?$AA@ 005d __invalid_parameter 0076 __ismbblead"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 38 8B 55 08 0F B6 02 89 45 F8 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 83 C2 01 89 55 08 85 C0 74 13 8B 45 08 0F B6 08 85 C9 74 09 8B 55 08 83 C2 01 89 55 08 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "?_Type_info_dtor@type_info@@CAXPAV1@@Z"
		size = 264
		refs = "0008 __sehtable$?_Type_info_dtor@type_info@@CAXPAV1@@Z 000d __except_handler4 001f ___security_cookie 0035 __lock 0052 ___type_info_root_node 008c _free 00a5 ??_C@_1CI@IDCGDBOP@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAn?$AAe?$AAx?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00ae ??_C@_1HG@KNCBMCDD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00b5 __CrtDbgReportW 00ee __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 83 78 04 00 0F 84 8D 00 00 00 8B 0D ?? ?? ?? ?? 89 4D E4 C7 45 E0 ?? ?? ?? ?? EB 06 8B 55 E0 89 55 E4 83 7D E4 00 74 56 8B 45 E4 8B 4D 08 8B 10 3B 51 04 75 1A 8B 45 E0 8B 4D E4 8B 51 04 89 50 04 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 EB 2F 8B 4D E4 89 4D E0 8B 55 E4 83 7A 04 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 58 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC EB 9E 8B 4D 08 8B 51 04 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 C7 40 04 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
		size = 416
		refs = "0008 __sehtable$?_Name_base@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z 000d __except_handler4 001f ___security_cookie 0045 __free_base 004a __malloc_base 005a ___unDName 0076 _strlen 00ac __lock 00ca _malloc 0104 ??_C@_1HG@KNCBMCDD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0109 ??_C@_1CM@OOICDMK@?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAf?$AAo?$AA?3?$AA?3?$AA_?$AAN?$AAa?$AAm?$AAe?$AA_?$AAb?$AAa?$AAs?$AAe?$AA?$AA@ 010e ??_C@_1JK@MLBKHELP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?5?$AA?$CI?$AA?$CI?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CK?$AA?$CJ?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAf?$AAo?$AA?5?$AA?$CK?$AA?$CJ@ 0125 _strcpy_s 012e __invoke_watson_if_error 015c _free 0180 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 8B 45 08 83 78 04 00 0F 85 49 01 00 00 68 00 28 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 8B 4D 08 83 C1 09 51 6A 00 E8 ?? ?? ?? ?? 83 C4 18 89 45 E4 83 7D E4 00 75 07 33 C0 E9 1D 01 00 00 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 8B 45 E0 8B 4D E0 83 E9 01 89 4D E0 85 C0 76 19 8B 55 E4 03 55 E0 0F BE 02 83 F8 20 75 0B 8B 4D E4 03 4D E0 C6 01 00 EB D7 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 83 7A 04 00 0F 85 9C 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 83 7D DC 00 0F 84 85 00 00 00 8B 45 E0 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 89 41 04 8B 55 08 83 7A 04 00 74 5B 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 E4 50 8B 4D E0 83 C1 02 51 8B 55 08 8B 42 04 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 8B 55 08 8B 42 04 89 01 8B 4D DC 8B 55 0C 8B 42 04 89 41 04 8B 4D 0C 8B 55 DC 89 51 04 EB 0C 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C3 8B 55 08 8B 42 04 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "?_Type_info_dtor_internal@type_info@@CAXPAV1@@Z"
		size = 267
		refs = "0008 __sehtable$?_Type_info_dtor_internal@type_info@@CAXPAV1@@Z 000d __except_handler4 001f ___security_cookie 0035 __lock 0052 ___type_info_root_node 008c __free_base 00a5 ??_C@_1CI@IDCGDBOP@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?9?$AA?$DO?$AAn?$AAe?$AAx?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00b1 ??_C@_1HG@KNCBMCDD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00b8 __CrtDbgReportW 00f1 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 83 78 04 00 0F 84 90 00 00 00 8B 0D ?? ?? ?? ?? 89 4D E4 C7 45 E0 ?? ?? ?? ?? EB 06 8B 55 E0 89 55 E4 83 7D E4 00 74 59 8B 45 E4 8B 4D 08 8B 10 3B 51 04 75 1A 8B 45 E0 8B 4D E4 8B 51 04 89 50 04 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 EB 32 8B 4D E4 89 4D E0 8B 55 E4 83 7A 04 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC EB 9B 8B 4D 08 8B 51 04 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 C7 40 04 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "___unDNameHelper"
		size = 59
		refs = "001c __free_base 0021 __malloc_base 0032 ___unDName"
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 14 85 C0 75 09 B9 00 28 00 00 66 89 4D 14 0F B7 55 14 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z"
		size = 440
		refs = "0008 __sehtable$?_Name_base_internal@type_info@@CAPBDPBV1@PAU__type_info_node@@@Z 000d __except_handler4 001f ___security_cookie 0042 __lock 006e ___unDNameHelper 0091 __local_unwind4 00a5 _strlen 00db __malloc_base 0116 ??_C@_1HG@KNCBMCDD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 011b ??_C@_1DO@OJJLFJPE@?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAf?$AAo?$AA?3?$AA?3?$AA_?$AAN?$AAa?$AAm?$AAe?$AA_?$AAb?$AAa?$AAs?$AAe?$AA_?$AAi?$AAn?$AAt?$AAe?$AAr?$AAn?$AAa?$AAl?$AA?$AA@ 0120 ??_C@_1GI@EAJKJPED@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?5?$AA?$CI?$AAp?$AAT?$AAm?$AAp?$AAT?$AAy?$AAp?$AAe?$AAN?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?$CL?$AA2?$AA?0?$AA?5?$AA?$CI@ 0134 _strcpy_s 013d __invoke_watson_if_error 0174 __free_base 0198 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 8B 45 08 83 78 04 00 0F 85 61 01 00 00 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 4D 08 83 79 04 00 0F 85 2A 01 00 00 68 00 28 00 00 6A 00 8B 55 08 83 C2 09 52 6A 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 83 7D E4 00 75 22 C7 45 D4 00 00 00 00 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 45 D4 E9 06 01 00 00 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 8B 55 E0 8B 45 E0 83 E8 01 89 45 E0 85 D2 76 19 8B 4D E4 03 4D E0 0F BE 11 83 FA 20 75 0B 8B 45 E4 03 45 E0 C6 00 00 EB D7 6A 08 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 83 7D DC 00 0F 84 8C 00 00 00 C7 45 D8 00 00 00 00 8B 4D E0 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 83 7D D8 00 74 61 6A 00 68 34 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 E4 52 8B 45 E0 83 C0 02 50 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 08 8B 45 D8 89 42 04 8B 4D DC 8B 55 08 8B 42 04 89 01 8B 4D DC 8B 55 0C 8B 42 04 89 41 04 8B 4D 0C 8B 55 DC 89 51 04 EB 0C 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C3 8B 55 08 8B 42 04 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "___clean_type_info_names_internal"
		size = 177
		refs = "0008 __sehtable$___clean_type_info_names_internal 000d __except_handler4 001f ___security_cookie 0035 __lock 0071 __free_base 0097 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 8B 48 04 89 4D E4 C7 45 E0 00 00 00 00 EB 06 8B 55 E0 89 55 E4 83 7D E4 00 74 25 8B 45 E4 8B 48 04 89 4D E0 8B 55 E4 8B 02 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 EB CF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 0E E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "__stat32i64"
		size = 1480
		refs = "000c ___security_cookie 002f ??_C@_1BO@PCMLKEJK@?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 003b ??_C@_1FM@KAILGGHA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0042 __CrtDbgReportW 0059 ___doserrno 0064 __errno 007b ??_C@_1BG@EDMLMMAK@?$AA_?$AAs?$AAt?$AAa?$AAt?$AA3?$AA2?$AAi?$AA6?$AA4?$AA?$AA@ 0085 __invalid_parameter 00ad ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0113 ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 011c __mbspbrk 018c __mbctolower 019f __getdrive 01b6 __imp__FindFirstFileA@8 01d8 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 0204 __fullpath_helper 0222 _strlen 0236 _IsRootUNCName 024a __imp__GetDriveTypeA@4 0264 _free 02d8 ___loctotime32_t 0328 __imp__FileTimeToLocalFileTime@8 0340 __imp__FileTimeToSystemTime@8 034a __imp__GetLastError@0 0350 __dosmaperr 0360 __imp__FindClose@4 0541 ___dtoxmode 056a __allmul 05c0 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 80 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 C0 83 7D 08 00 0F 95 C0 89 85 A0 FD FF FF 83 BD A0 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A0 FD FF FF 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 25 05 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9F 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9F 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A7 04 00 00 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 74 04 00 00 8B 55 08 0F BE 42 01 83 F8 3A 75 4D 8B 4D 08 0F BE 11 85 D2 74 29 8B 45 08 0F BE 48 02 85 C9 75 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 35 04 00 00 8B 55 08 0F BE 02 50 E8 ?? ?? ?? ?? 83 C4 04 83 E8 60 89 85 A8 FD FF FF EB 0B E8 ?? ?? ?? ?? 89 85 A8 FD FF FF 8D 8D B0 FD FF FF 51 8B 55 08 52 FF 15 ?? ?? ?? ?? 89 85 AC FD FF FF 83 BD AC FD FF FF FF 0F 85 35 01 00 00 C7 85 98 FD FF FF 00 00 00 00 68 ?? ?? ?? ?? 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 67 8D 8D 98 FD FF FF 51 68 04 01 00 00 8B 55 08 52 8D 85 F0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 A4 FD FF FF 83 BD A4 FD FF FF 00 74 39 8B 8D A4 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 03 74 13 8B 95 A4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 85 A4 FD FF FF 50 FF 15 ?? ?? ?? ?? 83 F8 01 77 36 83 BD 98 FD FF FF 00 74 0F 8B 8D 98 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 30 03 00 00 83 BD 98 FD FF FF 00 74 0F 8B 95 98 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 C7 85 B0 FD FF FF 10 00 00 00 C7 85 CC FD FF FF 00 00 00 00 C7 85 D0 FD FF FF 00 00 00 00 C6 85 DC FD FF FF 00 6A FF 6A 00 6A 00 6A 00 6A 01 6A 01 68 BC 07 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 24 8B 55 0C 8B 45 0C 8B 48 24 89 4A 20 8B 55 0C 8B 45 0C 8B 48 24 89 4A 28 E9 33 02 00 00 83 BD C4 FD FF FF 00 75 0D 83 BD C8 FD FF FF 00 0F 84 96 00 00 00 8D 95 90 FD FF FF 52 8D 85 C4 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 8D 80 FD FF FF 51 8D 95 90 FD FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 85 AC FD FF FF 50 FF 15 ?? ?? ?? ?? 83 C8 FF E9 4D 02 00 00 6A FF 0F B7 8D 8C FD FF FF 51 0F B7 95 8A FD FF FF 52 0F B7 85 88 FD FF FF 50 0F B7 8D 86 FD FF FF 51 0F B7 95 82 FD FF FF 52 0F B7 85 80 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 24 EB 0A 8B 55 0C C7 42 24 00 00 00 00 83 BD BC FD FF FF 00 75 0D 83 BD C0 FD FF FF 00 0F 84 96 00 00 00 8D 85 90 FD FF FF 50 8D 8D BC FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 80 FD FF FF 52 8D 85 90 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D AC FD FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 97 01 00 00 6A FF 0F B7 95 8C FD FF FF 52 0F B7 85 8A FD FF FF 50 0F B7 8D 88 FD FF FF 51 0F B7 95 86 FD FF FF 52 0F B7 85 82 FD FF FF 50 0F B7 8D 80 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 20 EB 0C 8B 45 0C 8B 4D 0C 8B 51 24 89 50 20 83 BD B4 FD FF FF 00 75 0D 83 BD B8 FD FF FF 00 0F 84 96 00 00 00 8D 85 90 FD FF FF 50 8D 8D B4 FD FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 80 FD FF FF 52 8D 85 90 FD FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D AC FD FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 DF 00 00 00 6A FF 0F B7 95 8C FD FF FF 52 0F B7 85 8A FD FF FF 50 0F B7 8D 88 FD FF FF 51 0F B7 95 86 FD FF FF 52 0F B7 85 82 FD FF FF 50 0F B7 8D 80 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 28 EB 0C 8B 45 0C 8B 4D 0C 8B 51 24 89 50 28 8B 85 AC FD FF FF 50 FF 15 ?? ?? ?? ?? 8B 4D 08 51 8B 95 B0 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 0C 66 89 41 06 BA 01 00 00 00 8B 45 0C 66 89 50 08 8B 8D CC FD FF FF 33 D2 6A 01 6A 00 52 51 E8 ?? ?? ?? ?? 8B 8D D0 FD FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 18 89 51 1C 33 D2 8B 45 0C 66 89 50 04 33 C9 8B 55 0C 66 89 4A 0C 33 C0 8B 4D 0C 66 89 41 0A 8B 95 A8 FD FF FF 83 EA 01 8B 45 0C 89 10 8B 4D 0C 8B 55 0C 8B 02 89 41 10 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_145_1_0 {
	meta:
		name = "_IsRootUNCName"
		size = 267
		refs = "000b _strlen"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 05 0F 82 EA 00 00 00 8B 4D 08 0F BE 11 83 FA 5C 74 0F 8B 45 08 0F BE 08 83 F9 2F 0F 85 D0 00 00 00 8B 55 08 0F BE 42 01 83 F8 5C 74 10 8B 4D 08 0F BE 51 01 83 FA 2F 0F 85 B4 00 00 00 8B 45 08 0F BE 48 02 83 F9 5C 0F 84 A4 00 00 00 8B 55 08 0F BE 42 02 83 F8 2F 0F 84 94 00 00 00 8B 4D 08 83 C1 02 89 4D FC 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 0F BE 08 85 C9 74 1A 8B 55 FC 0F BE 02 83 F8 5C 74 0B 8B 4D FC 0F BE 11 83 FA 2F 75 02 EB 02 EB D3 8B 45 FC 0F BE 08 85 C9 74 54 8B 55 FC 0F BE 42 01 85 C0 74 49 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 74 1A 8B 4D FC 0F BE 11 83 FA 5C 74 0B 8B 45 FC 0F BE 08 83 F9 2F 75 02 EB 02 EB D3 8B 55 FC 0F BE 02 85 C0 74 0B 8B 4D FC 0F BE 51 01 85 D2 75 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "___crtGetStringTypeA"
		size = 83
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0034 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 003a ?__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHHH@Z 0048 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_885_0_0 {
	meta:
		name = "___crtCompareStringA"
		size = 83
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0034 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 003a ?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDH1HH@Z 0048 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "___crtCompareStringW"
		size = 83
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0034 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 003a ?__crtCompareStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WH1HH@Z 0048 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_771_0_0 {
	meta:
		name = "___crtLCMapStringW"
		size = 83
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0034 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 003a ?__crtLCMapStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WHPA_WHH@Z 0048 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 08 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 EC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_4_0 {
	meta:
		name = "?__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHHH@Z"
		size = 555
		refs = "000a ?f_use@?1??__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHHH@Z@4HA 0018 ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0020 __imp__GetStringTypeW@16 0036 __imp__GetLastError@0 008d ___ansicp 00c1 ___convertcp 00f4 __imp__GetStringTypeA@20 0108 __free_dbg 015f __imp__MultiByteToWideChar@24 0194 _malloc 019d __MarkAllocaS 01cd _memset 0217 __freea"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 83 3D ?? ?? ?? ?? 00 75 38 8D 45 FC 50 6A 01 68 ?? ?? ?? ?? 6A 01 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 83 3D ?? ?? ?? ?? 02 74 0D 83 3D ?? ?? ?? ?? 00 0F 85 B8 00 00 00 C7 45 F8 00 00 00 00 83 7D 20 00 75 0B 8B 4D 08 8B 11 8B 42 14 89 45 20 83 7D 1C 00 75 0B 8B 4D 08 8B 11 8B 42 04 89 45 1C 8B 4D 20 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 FF 75 07 33 C0 E9 83 01 00 00 8B 55 F4 3B 55 1C 74 32 6A 00 6A 00 8D 45 14 50 8B 4D 10 51 8B 55 F4 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 75 07 33 C0 E9 4F 01 00 00 8B 4D F8 89 4D 10 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 20 50 FF 15 ?? ?? ?? ?? 89 45 F0 83 7D F8 00 74 0E 6A 02 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F0 E9 10 01 00 00 83 3D ?? ?? ?? ?? 01 0F 85 01 01 00 00 C7 45 EC 00 00 00 00 83 7D 1C 00 75 0B 8B 55 08 8B 02 8B 48 04 89 4D 1C 6A 00 6A 00 8B 55 14 52 8B 45 10 50 33 C9 83 7D 24 00 0F 95 C1 8D 0C CD 01 00 00 00 51 8B 55 1C 52 FF 15 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 07 33 C0 E9 B4 00 00 00 33 C0 75 32 83 7D E4 00 7E 2C 81 7D E4 F0 FF FF 7F 77 23 68 DD DD 00 00 8B 4D E4 8D 54 09 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC EB 07 C7 45 DC 00 00 00 00 8B 45 DC 89 45 E0 83 7D E0 00 75 04 33 C0 EB 67 8B 4D E4 D1 E1 51 6A 00 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 E4 50 8B 4D E0 51 8B 55 14 52 8B 45 10 50 6A 01 8B 4D 1C 51 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 74 19 8B 55 18 52 8B 45 E8 50 8B 4D E0 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 EC 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 8B 45 EC EB 04 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_5_0 {
	meta:
		name = "__MarkAllocaS"
		size = 33
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 11 8B 45 08 8B 4D 0C 89 08 8B 55 08 83 C2 08 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_146_6_0 {
	meta:
		name = "__freea"
		size = 102
		refs = "002b _free 0042 ??_C@_1FE@KNPCCODH@?$AA?$CI?$AA?$CC?$AAC?$AAo?$AAr?$AAr?$AAu?$AAp?$AAt?$AAe?$AAd?$AA?5?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AA_?$AAf@ 004e ??_C@_1GA@INJGGEBC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 74 56 8B 45 08 83 E8 08 89 45 08 8B 4D 08 8B 11 89 55 FC 81 7D FC DD DD 00 00 75 0E 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 EB 2E 81 7D FC CC CC 00 00 74 25 33 C9 75 21 68 ?? ?? ?? ?? 6A 00 68 09 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "_vwprintf_helper"
		size = 281
		refs = "0008 __sehtable$_vwprintf_helper 000d __except_handler4 001f ___security_cookie 0033 ___iob_func 0050 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0059 ??_C@_1GE@HBOOEGHP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0060 __CrtDbgReportW 0074 __errno 0088 ??_C@_1CA@KIPAKOJP@?$AAv?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0092 __invalid_parameter 00a3 __lock_file 00b6 __stbuf 00e2 __ftbuf 00fc __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 89 45 E4 33 C0 83 7D 0C 00 0F 95 C0 89 45 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 69 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D E4 51 FF 55 08 83 C4 10 89 45 E0 8B 55 E4 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__sse2_mathfcns_init"
		size = 29
		refs = "0007 ___use_sse2_mathfcns 0010 __get_sse2_info"
	strings:
		$1 = { 8B FF 55 8B EC C7 05 ?? ?? ?? ?? 00 00 00 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5D C3 }
	condition:
		$1
}

rule file_148_1_0 {
	meta:
		name = "__set_SSE2_enable"
		size = 30
		refs = "000e ___sse2_available 0013 ___use_sse2_mathfcns"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 F7 D8 1B C0 23 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "__lrotr"
		size = 45
		altNames = "__rotr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 83 E0 1F 89 45 0C B9 20 00 00 00 2B 4D 0C 8B 55 08 D3 E2 8B 45 08 8B 4D 0C D3 E8 0B D0 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_149_2_0 {
	meta:
		name = "__rotr64"
		size = 73
		refs = "001f __allshl 0031 __aullshr"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 45 10 83 E0 3F 89 45 10 B9 40 00 00 00 2B 4D 10 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 8B F0 8B FA 8B 45 08 8B 55 0C 8B 4D 10 E8 ?? ?? ?? ?? 0B F0 0B FA 89 75 08 89 7D 0C 8B 45 08 8B 55 0C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_227_2_0 {
	meta:
		name = "__rotl64"
		size = 73
		refs = "001f __aullshr 0031 __allshl"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 45 10 83 E0 3F 89 45 10 B9 40 00 00 00 2B 4D 10 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 8B F0 8B FA 8B 45 08 8B 55 0C 8B 4D 10 E8 ?? ?? ?? ?? 0B F0 0B FA 89 75 08 89 7D 0C 8B 45 08 8B 55 0C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__wexeclp"
		size = 420
		refs = "001b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GA@LDFLJAKF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BC@IPLBOCFB@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAl?$AAp?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0142 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0199 __wexecvp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 34 01 00 00 8B 55 08 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D1 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 70 8B 4D 0C 0F B7 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 10 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "__fltout2"
		size = 173
		refs = "0009 ___security_cookie 001b ___dtold 0043 _$I10_OUTPUT 0068 ??_C@_1HC@PKFDNKN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006d ??_C@_1BC@BPMMEHLK@?$AA_?$AAf?$AAl?$AAt?$AAo?$AAu?$AAt?$AA2?$AA?$AA@ 0072 ??_C@_1FK@KODCOBKF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AAs?$AAt?$AAr?$AA?0?$AA?5?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5@ 0083 _strcpy_s 008c __invoke_watson_if_error 00a5 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8D 45 08 50 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 8D 55 E0 52 6A 00 6A 11 83 EC 0C 8B C4 8B 4D D4 89 08 8B 55 D8 89 50 04 66 8B 4D DC 66 89 48 08 E8 ?? ?? ?? ?? 83 C4 18 8B 55 10 89 42 08 0F BE 45 E2 8B 4D 10 89 01 0F BF 55 E0 8B 45 10 89 50 04 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E4 51 8B 55 18 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D 10 8B 55 14 89 51 0C 8B 45 10 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_153_2_0 {
	meta:
		name = "___dtold"
		size = 339
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C C7 45 F8 00 00 00 80 33 C0 66 89 45 F0 8B 4D 0C 0F B7 51 06 81 E2 F0 7F 00 00 C1 FA 04 66 89 55 FC 8B 45 0C 0F B7 48 06 81 E1 00 80 00 00 66 89 4D EC 8B 55 0C 8B 42 04 25 FF FF 0F 00 89 45 F4 8B 4D 0C 8B 11 89 55 E8 0F B7 45 FC 89 45 E4 83 7D E4 00 74 16 81 7D E4 FF 07 00 00 74 02 EB 50 B9 FF 7F 00 00 66 89 4D F0 EB 61 83 7D F4 00 75 29 83 7D E8 00 75 23 8B 55 08 C7 42 04 00 00 00 00 8B 45 08 C7 00 00 00 00 00 8B 4D 08 66 8B 55 EC 66 89 51 08 E9 AD 00 00 00 0F BF 45 FC 05 01 3C 00 00 66 89 45 F0 C7 45 F8 00 00 00 00 EB 1C 0F B7 4D FC 81 E9 FF 03 00 00 66 89 4D FC 0F BF 55 FC 81 C2 FF 3F 00 00 66 89 55 F0 8B 45 F4 C1 E0 0B 0B 45 F8 8B 4D E8 C1 E9 15 0B C1 8B 55 08 89 42 04 8B 45 E8 C1 E0 0B 8B 4D 08 89 01 8B 55 08 8B 42 04 25 00 00 00 80 75 3B 8B 4D 08 8B 51 04 D1 E2 8B 45 08 8B 08 81 E1 00 00 00 80 F7 D9 1B C9 F7 D9 0B D1 8B 45 08 89 50 04 8B 4D 08 8B 11 D1 E2 8B 45 08 89 10 66 8B 4D F0 66 83 E9 01 66 89 4D F0 EB B8 0F B7 55 EC 0F B7 45 F0 0B D0 8B 4D 08 66 89 51 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__makepath_s"
		size = 920
		refs = "0031 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 003a ??_C@_1GO@DHMODCKM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0041 __CrtDbgReportW 0055 __errno 0069 ??_C@_1BI@GEIGEDDA@?$AA_?$AAm?$AAa?$AAk?$AAe?$AAp?$AAa?$AAt?$AAh?$AA_?$AAs?$AA?$AA@ 0073 __invalid_parameter 013c __mbsdec 0287 ___crtDebugFillThreshold 02b2 _memset 0316 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 033f ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 13 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 13 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 10 03 00 00 C7 45 F8 00 00 00 00 8B 55 08 89 55 F4 83 7D 10 00 74 42 8B 45 10 0F BE 08 85 C9 74 38 8B 55 F8 83 C2 02 89 55 F8 8B 45 F8 3B 45 0C 72 05 E9 09 02 00 00 8B 4D F4 8B 55 10 8A 02 88 01 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 C6 02 3A 8B 45 F4 83 C0 01 89 45 F4 8B 4D 14 89 4D FC 83 7D FC 00 0F 84 98 00 00 00 8B 55 FC 0F BE 02 85 C0 0F 84 8A 00 00 00 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 3B 55 0C 72 05 E9 B3 01 00 00 8B 45 F4 8B 4D FC 8A 11 88 10 8B 45 F4 83 C0 01 89 45 F4 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F BE 02 85 C0 75 C4 8B 4D FC 51 8B 55 14 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC 0F BE 08 83 F9 2F 74 30 8B 55 FC 0F BE 02 83 F8 5C 74 25 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 3B 55 0C 72 05 E9 4E 01 00 00 8B 45 F4 C6 00 5C 8B 4D F4 83 C1 01 89 4D F4 8B 55 18 89 55 FC 83 7D FC 00 74 3E 8B 45 FC 0F BE 08 85 C9 74 34 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 3B 45 0C 72 05 E9 13 01 00 00 8B 4D F4 8B 55 FC 8A 02 88 01 8B 4D F4 83 C1 01 89 4D F4 8B 55 FC 83 C2 01 89 55 FC EB C2 8B 45 1C 89 45 FC 83 7D FC 00 74 78 8B 4D FC 0F BE 11 85 D2 74 30 8B 45 FC 0F BE 08 83 F9 2E 74 25 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 3B 45 0C 72 05 E9 BE 00 00 00 8B 4D F4 C6 01 2E 8B 55 F4 83 C2 01 89 55 F4 8B 45 FC 0F BE 08 85 C9 74 34 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 3B 45 0C 72 05 E9 8F 00 00 00 8B 4D F4 8B 55 FC 8A 02 88 01 8B 4D F4 83 C1 01 89 4D F4 8B 55 FC 83 C2 01 89 55 FC EB C2 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 3B 4D 0C 76 02 EB 5E 8B 55 F4 C6 02 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 8B 45 F8 3B 45 0C 73 3A 8B 4D 0C 2B 4D F8 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 E4 EB 09 8B 45 0C 2B 45 F8 89 45 E4 8B 4D E4 51 68 FE 00 00 00 8B 55 08 03 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 E9 D4 00 00 00 8B 45 08 C6 00 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 4D 0C 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 E0 EB 09 8B 45 0C 83 E8 01 89 45 E0 8B 4D E0 51 68 FE 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 55 DC 89 55 EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 6C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 05 B8 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_strlen"
		size = 139
	strings:
		$1 = { 8B 4C 24 04 F7 C1 03 00 00 00 74 24 8A 01 83 C1 01 84 C0 74 4E F7 C1 03 00 00 00 75 EF 05 00 00 00 00 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 32 84 E4 74 24 A9 00 00 FF 00 74 13 A9 00 00 00 FF 74 02 EB CD 8D 41 FF 8B 4C 24 04 2B C1 C3 8D 41 FE 8B 4C 24 04 2B C1 C3 8D 41 FD 8B 4C 24 04 2B C1 C3 8D 41 FC 8B 4C 24 04 2B C1 C3 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "_free"
		size = 21
		refs = "000c __free_dbg"
		altNames = "__free_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_940_0_0 {
	meta:
		name = "__mktime32"
		size = 21
		refs = "000c __make__time32_t"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_752_0_0 {
	meta:
		name = "__mktime64"
		size = 21
		refs = "000c __make__time64_t"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_254_18_0 {
	meta:
		name = "__msize"
		size = 21
		refs = "000c __msize_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "_wcsncpy"
		size = 112
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 89 45 FC 83 7D 10 00 74 33 8B 4D 08 8B 55 0C 66 8B 02 66 89 01 8B 4D 08 0F B7 11 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 85 D2 74 0B 8B 55 10 83 EA 01 89 55 10 EB C7 83 7D 10 00 74 1E 8B 45 10 83 E8 01 89 45 10 74 13 33 C9 8B 55 08 66 89 0A 8B 45 08 83 C0 02 89 45 08 EB E2 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "__CIcos_default"
		size = 174
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003c ___fastflag 0043 __fast_exit 004e _NAME_ 0053 __math_exit 0059 __pi_by_2_to_61 006e __convertTOStoQNaN 0086 __indefinite 00a8 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 50 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FF 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FF EB CD E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "__wcsicmp_l"
		size = 558
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0030 ??_C@_1GC@MHLPCCAP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0037 __CrtDbgReportW 004b __errno 005f ??_C@_1BG@EELGPCPD@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 0069 __invalid_parameter 007b ??1_LocaleUpdate@@QAE@XZ 009a ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00fe ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01bd __towlower_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 33 C9 83 7D 08 00 0F 95 C1 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 A3 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 30 01 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 10 83 7A 14 00 0F 85 96 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 D0 EB 09 8B 45 08 0F B7 08 89 4D D0 66 8B 55 D0 66 89 55 FC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 CC EB 09 8B 45 0C 0F B7 08 89 4D CC 66 8B 55 CC 66 89 55 F8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 0F B7 55 FC 85 D2 74 10 0F B7 45 FC 0F B7 4D F8 3B C1 0F 84 6C FF FF FF EB 6E 8B 55 08 66 8B 02 66 89 45 CA 8D 4D E8 E8 ?? ?? ?? ?? 50 0F B7 4D CA 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 FC 8B 55 08 83 C2 02 89 55 08 8B 45 0C 66 8B 08 66 89 4D C8 8D 4D E8 E8 ?? ?? ?? ?? 50 0F B7 55 C8 52 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 F8 8B 45 0C 83 C0 02 89 45 0C 0F B7 4D FC 85 C9 74 0C 0F B7 55 FC 0F B7 45 F8 3B D0 74 92 0F B7 4D FC 0F B7 55 F8 2B CA 89 4D D4 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 8B E5 5D C3 }
	condition:
		$1
}

rule file_160_4_0 {
	meta:
		name = "__wcsicmp"
		size = 409
		refs = "000a ___locale_changed 0028 ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0031 ??_C@_1GC@MHLPCCAP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0038 __CrtDbgReportW 004c __errno 0060 ??_C@_1BC@NHIBDOMC@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAm?$AAp?$AA?$AA@ 006a __invalid_parameter 008e ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 018e __wcsicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 83 3D ?? ?? ?? ?? 00 0F 85 6E 01 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 58 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 58 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 1A 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 59 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 59 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 B4 00 00 00 8B 4D 08 0F B7 11 83 FA 41 7C 19 8B 45 08 0F B7 08 83 F9 5A 7F 0E 8B 55 08 0F B7 02 83 C0 20 89 45 EC EB 09 8B 4D 08 0F B7 11 89 55 EC 66 8B 45 EC 66 89 45 FC 8B 4D 0C 0F B7 11 83 FA 41 7C 19 8B 45 0C 0F B7 08 83 F9 5A 7F 0E 8B 55 0C 0F B7 02 83 C0 20 89 45 E8 EB 09 8B 4D 0C 0F B7 11 89 55 E8 66 8B 45 E8 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 0F B7 45 FC 85 C0 74 10 0F B7 4D FC 0F B7 55 F8 3B CA 0F 84 6C FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 EB 14 EB 12 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "?swprintf@@YAHPAGIPBGZZ"
		size = 57
		refs = "0021 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8D 45 14 89 45 FC 8B 4D FC 51 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 C7 45 FC 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_338_2_0 {
	meta:
		name = "_swprintf"
		size = 57
		refs = "0021 __vswprintf_c_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8D 45 14 89 45 FC 8B 4D FC 51 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 C7 45 FC 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_161_1_0 {
	meta:
		name = "?swprintf@@YAHPA_WIPB_WZZ"
		size = 332
		refs = "001b ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GI@LCMDFJK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f ??_C@_1BO@MLMCMBKN@?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00a6 __woutput_l 00f0 __flsbuf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 8D 45 D4 89 45 F4 8D 4D 14 89 4D FC 83 7D 08 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 10 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 71 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D F4 C7 41 0C 42 00 00 00 8B 55 F4 8B 45 08 89 42 08 8B 4D F4 8B 55 08 89 11 81 7D 0C FF FF FF 3F 76 0C 8B 45 F4 C7 40 04 FF FF FF 7F EB 0B 8B 4D 0C D1 E1 8B 55 F4 89 4A 04 8B 45 FC 50 6A 00 8B 4D 10 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 8B 45 F4 8B 48 04 83 E9 01 8B 55 F4 89 4A 04 8B 45 F4 83 78 04 00 7C 21 8B 4D F4 8B 11 C6 02 00 33 C0 25 FF 00 00 00 89 45 D0 8B 4D F4 8B 11 83 C2 01 8B 45 F4 89 10 EB 11 8B 4D F4 51 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 D0 8B 55 F4 8B 42 04 83 E8 01 8B 4D F4 89 41 04 8B 55 F4 83 7A 04 00 7C 22 8B 45 F4 8B 08 C6 01 00 33 D2 81 E2 FF 00 00 00 89 55 CC 8B 45 F4 8B 08 83 C1 01 8B 55 F4 89 0A EB 11 8B 45 F4 50 6A 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__wchartodigit"
		size = 802
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 08 83 F8 30 7D 08 83 C8 FF E9 0A 03 00 00 0F B7 4D 08 83 F9 3A 7D 0C 0F B7 45 08 83 E8 30 E9 F5 02 00 00 0F B7 55 08 81 FA 10 FF 00 00 0F 8D CB 02 00 00 0F B7 45 08 3D 60 06 00 00 7D 08 83 C8 FF E9 D2 02 00 00 0F B7 4D 08 81 F9 6A 06 00 00 7D 0E 0F B7 45 08 2D 60 06 00 00 E9 B8 02 00 00 0F B7 55 08 81 FA F0 06 00 00 7D 08 83 C8 FF E9 A4 02 00 00 0F B7 45 08 3D FA 06 00 00 7D 0E 0F B7 45 08 2D F0 06 00 00 E9 8B 02 00 00 0F B7 4D 08 81 F9 66 09 00 00 7D 08 83 C8 FF E9 77 02 00 00 0F B7 55 08 81 FA 70 09 00 00 7D 0E 0F B7 45 08 2D 66 09 00 00 E9 5D 02 00 00 0F B7 45 08 3D E6 09 00 00 7D 08 83 C8 FF E9 4A 02 00 00 0F B7 4D 08 81 F9 F0 09 00 00 7D 0E 0F B7 45 08 2D E6 09 00 00 E9 30 02 00 00 0F B7 55 08 81 FA 66 0A 00 00 7D 08 83 C8 FF E9 1C 02 00 00 0F B7 45 08 3D 70 0A 00 00 7D 0E 0F B7 45 08 2D 66 0A 00 00 E9 03 02 00 00 0F B7 4D 08 81 F9 E6 0A 00 00 7D 08 83 C8 FF E9 EF 01 00 00 0F B7 55 08 81 FA F0 0A 00 00 7D 0E 0F B7 45 08 2D E6 0A 00 00 E9 D5 01 00 00 0F B7 45 08 3D 66 0B 00 00 7D 08 83 C8 FF E9 C2 01 00 00 0F B7 4D 08 81 F9 70 0B 00 00 7D 0E 0F B7 45 08 2D 66 0B 00 00 E9 A8 01 00 00 0F B7 55 08 81 FA 66 0C 00 00 7D 08 83 C8 FF E9 94 01 00 00 0F B7 45 08 3D 70 0C 00 00 7D 0E 0F B7 45 08 2D 66 0C 00 00 E9 7B 01 00 00 0F B7 4D 08 81 F9 E6 0C 00 00 7D 08 83 C8 FF E9 67 01 00 00 0F B7 55 08 81 FA F0 0C 00 00 7D 0E 0F B7 45 08 2D E6 0C 00 00 E9 4D 01 00 00 0F B7 45 08 3D 66 0D 00 00 7D 08 83 C8 FF E9 3A 01 00 00 0F B7 4D 08 81 F9 70 0D 00 00 7D 0E 0F B7 45 08 2D 66 0D 00 00 E9 20 01 00 00 0F B7 55 08 81 FA 50 0E 00 00 7D 08 83 C8 FF E9 0C 01 00 00 0F B7 45 08 3D 5A 0E 00 00 7D 0E 0F B7 45 08 2D 50 0E 00 00 E9 F3 00 00 00 0F B7 4D 08 81 F9 D0 0E 00 00 7D 08 83 C8 FF E9 DF 00 00 00 0F B7 55 08 81 FA DA 0E 00 00 7D 0E 0F B7 45 08 2D D0 0E 00 00 E9 C5 00 00 00 0F B7 45 08 3D 20 0F 00 00 7D 08 83 C8 FF E9 B2 00 00 00 0F B7 4D 08 81 F9 2A 0F 00 00 7D 0E 0F B7 45 08 2D 20 0F 00 00 E9 98 00 00 00 0F B7 55 08 81 FA 40 10 00 00 7D 08 83 C8 FF E9 84 00 00 00 0F B7 45 08 3D 4A 10 00 00 7D 0B 0F B7 45 08 2D 40 10 00 00 EB 6E 0F B7 4D 08 81 F9 E0 17 00 00 7D 05 83 C8 FF EB 5D 0F B7 55 08 81 FA EA 17 00 00 7D 0B 0F B7 45 08 2D E0 17 00 00 EB 46 0F B7 45 08 3D 10 18 00 00 7D 05 83 C8 FF EB 36 0F B7 4D 08 81 F9 1A 18 00 00 7D 0B 0F B7 45 08 2D 10 18 00 00 EB 1F 83 C8 FF EB 1A 0F B7 55 08 81 FA 1A FF 00 00 7D 0B 0F B7 45 08 2D 10 FF 00 00 EB 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "__getwch"
		size = 123
		refs = "0008 __sehtable$__getwch 000d __except_handler4 001f ___security_cookie 0035 __lock 0044 __getwch_nolock 005d __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 66 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 66 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_163_1_0 {
	meta:
		name = "__getwche"
		size = 123
		refs = "0008 __sehtable$__getwche 000d __except_handler4 001f ___security_cookie 0035 __lock 0044 __getwche_nolock 005d __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 66 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 66 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_163_2_0 {
	meta:
		name = "__getwch_nolock"
		size = 464
		refs = "0011 _wchbuf 0044 __coninpfh 004c ___initconin 0070 __imp__GetConsoleMode@8 007e __imp__SetConsoleMode@8 0084 _bUseW 009d __imp__ReadConsoleInputW@16 00b0 __imp__GetLastError@0 010f __imp__ReadConsoleInputA@16 0175 __imp__GetConsoleCP@0 017c __imp__MultiByteToWideChar@24 0187 __getextendedkeycode"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 33 C0 66 89 45 E4 0F B7 0D ?? ?? ?? ?? 81 F9 FF FF 00 00 74 25 0F B7 15 ?? ?? ?? ?? 81 E2 FF FF 00 00 66 89 55 E4 B8 FF FF 00 00 66 A3 ?? ?? ?? ?? 66 8B 45 E4 E9 8A 01 00 00 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 75 0A B8 FF FF 00 00 E9 69 01 00 00 8D 4D DC 51 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 68 8D 4D D8 51 6A 01 8D 55 EC 52 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 30 83 3D ?? ?? ?? ?? 02 75 17 FF 15 ?? ?? ?? ?? 83 F8 78 75 0C C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0E B9 FF FF 00 00 66 89 4D E4 E9 E4 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 01 00 00 00 83 7D D8 00 75 0E BA FF FF 00 00 66 89 55 E4 E9 C4 00 00 00 83 3D ?? ?? ?? ?? 00 75 2F 8D 45 D8 50 6A 01 8D 4D EC 51 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 74 06 83 7D D8 00 75 0E B8 FF FF 00 00 66 89 45 E4 E9 8C 00 00 00 0F B7 4D EC 83 F9 01 75 7E 83 7D F0 00 74 78 83 3D ?? ?? ?? ?? 00 74 14 66 8B 55 FA 66 89 55 E4 0F B7 45 E4 85 C0 74 02 EB 62 EB 2B 8A 4D FA 88 4D E3 0F BE 55 E3 85 D2 74 1D 6A 01 8D 45 E4 50 6A 01 8D 4D E3 51 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? EB 35 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 74 1B 8B 45 E8 66 0F B6 08 66 89 4D E4 8B 55 E8 66 0F B6 42 01 66 A3 ?? ?? ?? ?? EB 05 E9 CB FE FF FF 8B 4D DC 51 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 66 8B 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_163_3_0 {
	meta:
		name = "__getwche_nolock"
		size = 114
		refs = "0009 _wchbuf 0038 __getwch_nolock 0051 __putwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 51 0F B7 05 ?? ?? ?? ?? 3D FF FF 00 00 74 23 0F B7 0D ?? ?? ?? ?? 81 E1 FF FF 00 00 66 89 4D FC BA FF FF 00 00 66 89 15 ?? ?? ?? ?? 66 8B 45 FC EB 37 E8 ?? ?? ?? ?? 66 89 45 FC 0F B7 45 FC 3D FF FF 00 00 74 1E 0F B7 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 0F B7 D0 81 FA FF FF 00 00 74 06 66 8B 45 FC EB 05 B8 FF FF 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_163_4_0 {
	meta:
		name = "__ungetwch"
		size = 131
		refs = "0008 __sehtable$__ungetwch 000d __except_handler4 001f ___security_cookie 0035 __lock 0049 __ungetwch_nolock 0065 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 66 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_569_0_0 {
	meta:
		name = "__putwch"
		size = 131
		refs = "0008 __sehtable$__putwch 000d __except_handler4 001f ___security_cookie 0035 __lock 0049 __putwch_nolock 0065 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 03 E8 ?? ?? ?? ?? 83 C4 04 C3 66 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_163_5_0 {
	meta:
		name = "__ungetwch_nolock"
		size = 63
		refs = "0013 _wchbuf"
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 08 3D FF FF 00 00 74 0F 0F B7 0D ?? ?? ?? ?? 81 F9 FF FF 00 00 74 07 B8 FF FF 00 00 EB 17 0F B7 55 08 81 E2 FF 00 00 00 66 89 15 ?? ?? ?? ?? 66 A1 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__fltinf_l"
		size = 256
		refs = "0009 ___security_cookie 0036 ___strgtold12_l 006d __ld12tod 00b2 _flt 00f8 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 E8 C7 45 D8 00 00 00 00 8B 45 18 50 6A 01 8B 4D 14 51 8B 55 10 52 6A 00 8B 45 08 50 8D 4D EC 51 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 8B 45 FC 83 E0 04 74 1C 8B 4D D8 81 C9 00 02 00 00 89 4D D8 C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 EB 47 8D 55 F0 52 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D4 8B 4D FC 83 E1 02 75 06 83 7D D4 01 75 0C 8B 55 D8 81 CA 80 00 00 00 89 55 D8 8B 45 FC 83 E0 01 75 06 83 7D D4 02 75 0C 8B 4D D8 81 C9 00 01 00 00 89 4D D8 8B 55 EC 2B 55 08 A1 ?? ?? ?? ?? 89 50 04 8B 0D ?? ?? ?? ?? 8B 55 0C 3B 51 04 74 09 8B 45 D8 83 C8 40 89 45 D8 8B 0D ?? ?? ?? ?? 8B 55 F0 89 51 10 8B 45 F4 89 41 14 8B 0D ?? ?? ?? ?? 8B 55 D8 89 11 A1 ?? ?? ?? ?? 8B 4D E8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__mbstowcs_l_helper"
		size = 846
		refs = "0049 ??_C@_1BE@EEKACIGI@?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0052 ??_C@_1GE@LCCDHBMH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0059 __CrtDbgReportW 006d __errno 0081 ??_C@_1CG@JEHFHLNG@?$AA_?$AAm?$AAb?$AAs?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAl?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 008b __invalid_parameter 00a2 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00b4 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00ef ??1_LocaleUpdate@@QAE@XZ 014a __imp__MultiByteToWideChar@24 0172 __imp__GetLastError@0 01e7 __isleadbyte_l 02c9 _strlen"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C C7 45 FC 00 00 00 00 83 7D 08 00 74 0D 83 7D 10 00 75 07 33 C0 E9 28 03 00 00 83 7D 08 00 74 0E 83 7D 10 00 76 08 33 C0 8B 4D 08 66 89 01 33 D2 83 7D 0C 00 0F 95 C2 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B0 02 00 00 8B 4D 14 51 8D 4D EC E8 ?? ?? ?? ?? 83 7D 08 00 0F 84 04 02 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 10 83 7A 14 00 75 6A 8B 45 FC 3B 45 10 73 47 8B 4D 0C 03 4D FC 66 0F B6 11 8B 45 08 66 89 10 8B 4D 0C 03 4D FC 0F BE 11 85 D2 75 16 8B 45 FC 89 45 D8 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D8 E9 4F 02 00 00 8B 4D FC 83 C1 01 89 4D FC 8B 55 08 83 C2 02 89 55 08 EB B1 8B 45 FC 89 45 D4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 E9 25 02 00 00 E9 85 01 00 00 8B 4D 10 51 8B 55 08 52 6A FF 8B 45 0C 50 6A 09 8D 4D EC E8 ?? ?? ?? ?? 8B 08 8B 51 04 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 19 8B 45 FC 83 E8 01 89 45 D0 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D0 E9 DA 01 00 00 FF 15 ?? ?? ?? ?? 83 F8 7A 74 2A E8 ?? ?? ?? ?? C7 00 2A 00 00 00 33 C9 8B 55 08 66 89 0A C7 45 CC FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 45 CC E9 A5 01 00 00 8B 45 10 89 45 E0 8B 4D 0C 89 4D E4 EB 09 8B 55 E4 83 C2 01 89 55 E4 8B 45 E0 8B 4D E0 83 E9 01 89 4D E0 85 C0 74 6B 8B 55 E4 0F B6 02 85 C0 74 61 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D E4 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 40 8B 45 E4 0F B6 48 01 85 C9 75 2C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 33 D2 8B 45 08 66 89 10 C7 45 C8 FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 45 C8 E9 23 01 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 E9 7C FF FF FF 8B 55 E4 2B 55 0C 89 55 DC 8B 45 10 50 8B 4D 08 51 8B 55 DC 52 8B 45 0C 50 6A 01 8D 4D EC E8 ?? ?? ?? ?? 8B 08 8B 51 04 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 2A E8 ?? ?? ?? ?? C7 00 2A 00 00 00 33 C0 8B 4D 08 66 89 01 C7 45 C4 FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 45 C4 E9 B1 00 00 00 8B 55 FC 89 55 C0 8D 4D EC E8 ?? ?? ?? ?? 8B 45 C0 E9 9B 00 00 00 E9 8E 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 00 83 78 14 00 75 1E 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 BC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 BC EB 6A EB 60 6A 00 6A 00 6A FF 8B 55 0C 52 6A 09 8D 4D EC E8 ?? ?? ?? ?? 8B 00 8B 48 04 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 21 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 B8 FF FF FF FF 8D 4D EC E8 ?? ?? ?? ?? 8B 45 B8 EB 20 EB 16 8B 55 FC 83 EA 01 89 55 B4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 B4 EB 08 8D 4D EC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_166_5_0 {
	meta:
		name = "_mbstowcs"
		size = 67
		refs = "0007 ___locale_changed 000f ___initiallocalestructinfo 0020 __mbstowcs_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1D 68 ?? ?? ?? ?? 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 EB 18 EB 16 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_166_6_0 {
	meta:
		name = "__mbstowcs_s_l"
		size = 893
		refs = "0044 ??_C@_1JA@JKDFMOPO@?$AA?$CI?$AAp?$AAw?$AAc?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr?$AAd?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5@ 0050 ??_C@_1GE@LCCDHBMH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0057 __CrtDbgReportW 006b __errno 0082 ??_C@_1BM@PHENIGHD@?$AA_?$AAm?$AAb?$AAs?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 008c __invalid_parameter 00c8 ___crtDebugFillThreshold 00f5 _memset 0113 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0146 ??_C@_1CM@LLECFMFH@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AAS?$AAi?$AAz?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 01a0 ??1_LocaleUpdate@@QAE@XZ 01b0 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01c2 __mbstowcs_l_helper 02dd ??_C@_1CO@JNPEPJAL@?$AAr?$AAe?$AAt?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAo?$AAr?$AAd?$AAs?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C C7 45 FC 00 00 00 00 83 7D 0C 00 75 06 83 7D 10 00 74 15 83 7D 0C 00 74 06 83 7D 10 00 77 09 C7 45 C4 00 00 00 00 EB 07 C7 45 C4 01 00 00 00 8B 45 C4 89 45 E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F1 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 DC 02 00 00 83 7D 0C 00 74 59 33 D2 8B 45 0C 66 89 10 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C 8B 4D 10 83 E9 01 39 0D ?? ?? ?? ?? 73 0B 8B 15 ?? ?? ?? ?? 89 55 C0 EB 09 8B 45 10 83 E8 01 89 45 C0 8B 4D C0 D1 E1 51 68 FE 00 00 00 8B 55 0C 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 74 09 8B 45 08 C7 00 00 00 00 00 8B 4D 1C 51 8D 4D E8 E8 ?? ?? ?? ?? 8B 55 18 3B 55 10 76 08 8B 45 10 89 45 BC EB 06 8B 4D 18 89 4D BC 8B 55 BC 89 55 F8 B8 FF FF FF 7F 3B 45 F8 1B C9 83 C1 01 89 4D DC 75 21 68 ?? ?? ?? ?? 6A 00 68 01 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 01 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 16 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 CD 01 00 00 8D 4D E8 E8 ?? ?? ?? ?? 50 8B 45 F8 50 8B 4D 14 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 E4 83 7D E4 FF 75 78 83 7D 0C 00 74 58 33 C0 8B 4D 0C 66 89 01 83 7D 10 FF 74 4A 81 7D 10 FF FF FF 7F 74 41 83 7D 10 01 76 3B 8B 55 10 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 B8 EB 09 8B 4D 10 83 E9 01 89 4D B8 8B 55 B8 D1 E2 52 68 FE 00 00 00 8B 45 0C 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 08 89 4D D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 E9 2F 01 00 00 8B 55 E4 83 C2 01 89 55 E4 83 7D 0C 00 0F 84 FD 00 00 00 8B 45 E4 3B 45 10 0F 86 E4 00 00 00 83 7D 18 FF 0F 84 CD 00 00 00 33 C9 8B 55 0C 66 89 0A 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D B4 EB 09 8B 55 10 83 EA 01 89 55 B4 8B 45 B4 D1 E0 50 68 FE 00 00 00 8B 4D 0C 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E4 39 55 10 1B C0 83 C0 01 89 45 D8 75 21 68 ?? ?? ?? ?? 6A 00 68 1B 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 3D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 1B 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 CC 22 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 CC EB 39 8B 55 10 89 55 E4 C7 45 FC 50 00 00 00 33 C0 8B 4D E4 8B 55 0C 66 89 44 4A FE 83 7D 08 00 74 08 8B 45 08 8B 4D E4 89 08 8B 55 FC 89 55 C8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_166_7_0 {
	meta:
		name = "_mbstowcs_s"
		size = 37
		refs = "001c __mbstowcs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_187_12_0 {
	meta:
		name = "__Strftime"
		size = 37
		refs = "001c __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_388_16_0 {
	meta:
		name = "__cftoa"
		size = 37
		refs = "001c __cftoa_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_388_13_0 {
	meta:
		name = "__cftoe"
		size = 37
		refs = "001c __cftoe_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_388_21_0 {
	meta:
		name = "__cftog"
		size = 37
		refs = "001c __cftog_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_200_8_0 {
	meta:
		name = "_wcstombs_s"
		size = 37
		refs = "001c __wcstombs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "__get_sbh_threshold"
		size = 77
		refs = "0007 __crtheap 000f ??_C@_1BC@DENNNKIM@?$AA_?$AAc?$AAr?$AAt?$AAh?$AAe?$AAa?$AAp?$AA?$AA@ 0018 ??_C@_1GA@CMCJKKIB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 001f __CrtDbgReportW 003b ___active_heap 0043 ___sbh_threshold"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 3D ?? ?? ?? ?? 00 75 04 33 C0 EB 12 83 3D ?? ?? ?? ?? 03 75 07 A1 ?? ?? ?? ?? EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "__set_sbh_threshold"
		size = 399
		refs = "000a __crtheap 0012 ??_C@_1BC@DENNNKIM@?$AA_?$AAc?$AAr?$AAt?$AAh?$AAe?$AAa?$AAp?$AA?$AA@ 001b ??_C@_1GA@CMCJKKIB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0022 __CrtDbgReportW 0041 ___active_heap 005b ??_C@_1EC@DACAONFE@?$AAt?$AAh?$AAr?$AAe?$AAs?$AAh?$AAo?$AAl?$AAd?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAM?$AAA?$AAX?$AA_?$AAA?$AAL?$AAL?$AAO?$AAC?$AA_?$AAD?$AAA?$AAT?$AAA?$AA_?$AAS?$AAI?$AAZ?$AAE@ 007f __errno 0093 ??_C@_1CG@BBFCGKBK@?$AA_?$AAs?$AAe?$AAt?$AA_?$AAs?$AAb?$AAh?$AA_?$AAt?$AAh?$AAr?$AAe?$AAs?$AAh?$AAo?$AAl?$AAd?$AA?$AA@ 009d __invalid_parameter 00b0 ___sbh_threshold 00e9 ___sbh_heap_init 0111 ??_C@_1IC@MOGBEBCE@?$AA?$CI?$AAt?$AAh?$AAr?$AAe?$AAs?$AAh?$AAo?$AAl?$AAd?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAM?$AAA?$AAX?$AA_?$AAA?$AAL?$AAL?$AAO?$AAC?$AA_?$AAD?$AAA?$AAT?$AAA?$AA_?$AAS?$AAI?$AAZ@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 3D ?? ?? ?? ?? 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 67 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 4C 01 00 00 83 3D ?? ?? ?? ?? 03 75 76 B9 F8 03 00 00 3B 4D 08 1B D2 83 C2 01 89 55 FC 75 1E 68 ?? ?? ?? ?? 6A 00 6A 70 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 70 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 E0 00 00 00 8B 4D 08 89 0D ?? ?? ?? ?? B8 01 00 00 00 E9 CD 00 00 00 83 7D 08 00 75 0A B8 01 00 00 00 E9 BD 00 00 00 83 3D ?? ?? ?? ?? 01 0F 85 A3 00 00 00 81 7D 08 F8 03 00 00 77 19 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B9 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 27 8B 55 08 89 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 03 00 00 00 B8 01 00 00 00 EB 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_2_0 {
	meta:
		name = "__set_amblksiz"
		size = 258
		refs = "0031 ??_C@_1DK@BKLENMLC@?$AA0?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAU?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 003d ??_C@_1GA@CMCJKKIB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0044 __CrtDbgReportW 0058 __errno 006f ??_C@_1BM@GFNECEDD@?$AA_?$AAs?$AAe?$AAt?$AA_?$AAa?$AAm?$AAb?$AAl?$AAk?$AAs?$AAi?$AAz?$AA?$AA@ 0079 __invalid_parameter 008b __crtheap 009d ??_C@_1BC@DENNNKIM@?$AA_?$AAc?$AAr?$AAt?$AAh?$AAe?$AAa?$AAp?$AA?$AA@ 00f8 __amblksiz"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 08 00 76 0F 83 7D 08 FF 77 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D8 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D8 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 77 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D9 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0B 8B 4D 08 89 0D ?? ?? ?? ?? 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_3_0 {
	meta:
		name = "__get_amblksiz"
		size = 238
		refs = "001b ??_C@_1BM@IELHFPPM@?$AAp?$AAS?$AAi?$AAz?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0027 ??_C@_1GA@CMCJKKIB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW 0042 __errno 0059 ??_C@_1BM@OFBCOJJF@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAa?$AAm?$AAb?$AAl?$AAk?$AAs?$AAi?$AAz?$AA?$AA@ 0063 __invalid_parameter 0075 __crtheap 0087 ??_C@_1BC@DENNNKIM@?$AA_?$AAc?$AAr?$AAt?$AAh?$AAe?$AAa?$AAp?$AA?$AA@ 00e2 __amblksiz"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F5 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 79 33 D2 83 3D ?? ?? ?? ?? 00 0F 95 C2 89 55 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F6 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_4_0 {
	meta:
		name = "___sbh_heap_init"
		size = 100
		refs = "000d __crtheap 0014 __imp__HeapAlloc@12 0019 ___sbh_pHeaderList 002f ___sbh_threshold 003b ___sbh_pHeaderScan 0041 ___sbh_pHeaderDefer 004b ___sbh_cntHeaderList 0055 ___sbh_sizeHeaderList"
	strings:
		$1 = { 8B FF 55 8B EC 68 40 01 00 00 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 04 33 C0 EB 38 8B 4D 08 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? 10 00 00 00 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_168_5_0 {
	meta:
		name = "___sbh_find_block"
		size = 85
		refs = "0009 ___sbh_cntHeaderList 0012 ___sbh_pHeaderList"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 6B C0 14 03 05 ?? ?? ?? ?? 89 45 FC 8B 0D ?? ?? ?? ?? 89 4D F8 8B 55 F8 3B 55 FC 73 25 8B 45 F8 8B 4D 08 2B 48 0C 89 4D F4 81 7D F4 00 00 10 00 73 05 8B 45 F8 EB 0D 8B 55 F8 83 C2 14 89 55 F8 EB D3 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_6_0 {
	meta:
		name = "___sbh_verify_block"
		size = 88
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 08 8B 4D 0C 2B 48 0C 89 4D F8 8B 55 F8 C1 EA 0F 89 55 FC B8 00 00 00 80 8B 4D FC D3 E8 8B 4D 08 23 41 08 75 1B 8B 55 F8 83 E2 0F 75 13 8B 45 F8 25 FF 0F 00 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_7_0 {
	meta:
		name = "___sbh_free_block"
		size = 1466
		refs = "0458 ___sbh_pHeaderDefer 0465 ___sbh_indGroupDefer 0488 __imp__VirtualFree@12 0538 __crtheap 053f __imp__HeapFree@12 0545 ___sbh_cntHeaderList 054e ___sbh_pHeaderList 056f _memmove 05a1 ___sbh_pHeaderScan"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C 8B 45 08 8B 48 10 89 4D D4 8B 55 08 8B 45 0C 2B 42 0C 89 45 E0 8B 4D E0 C1 E9 0F 89 4D EC 8B 55 EC 69 D2 04 02 00 00 8B 45 D4 8D 8C 10 44 01 00 00 89 4D D8 8B 55 0C 83 EA 04 89 55 E8 8B 45 E8 8B 08 83 E9 01 89 4D C4 8B 55 C4 83 E2 01 74 05 E9 59 05 00 00 8B 45 E8 03 45 C4 89 45 F8 8B 4D F8 8B 11 89 55 CC 8B 45 E8 8B 48 FC 89 4D E4 8B 55 CC 83 E2 01 0F 85 18 01 00 00 8B 45 CC C1 F8 04 83 E8 01 89 45 F0 83 7D F0 3F 76 07 C7 45 F0 3F 00 00 00 8B 4D F8 8B 55 F8 8B 41 04 3B 42 08 0F 85 C6 00 00 00 83 7D F0 20 73 5A BA 00 00 00 80 8B 4D F0 D3 EA F7 D2 8B 45 EC 8B 4D D4 23 54 81 44 8B 45 EC 8B 4D D4 89 54 81 44 8B 55 D4 03 55 F0 8A 42 04 2C 01 8B 4D D4 03 4D F0 88 41 04 8B 55 D4 03 55 F0 0F BE 42 04 85 C0 75 16 BA 00 00 00 80 8B 4D F0 D3 EA F7 D2 8B 45 08 23 10 8B 4D 08 89 11 EB 66 8B 4D F0 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 EC 8B 4D D4 23 94 81 C4 00 00 00 8B 45 EC 8B 4D D4 89 94 81 C4 00 00 00 8B 55 D4 03 55 F0 8A 42 04 2C 01 8B 4D D4 03 4D F0 88 41 04 8B 55 D4 03 55 F0 0F BE 42 04 85 C0 75 1B 8B 4D F0 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 08 23 50 04 8B 4D 08 89 51 04 8B 55 F8 8B 42 08 8B 4D F8 8B 51 04 89 50 04 8B 45 F8 8B 48 04 8B 55 F8 8B 42 08 89 41 08 8B 4D C4 03 4D CC 89 4D C4 8B 55 C4 C1 FA 04 83 EA 01 89 55 C8 83 7D C8 3F 76 07 C7 45 C8 3F 00 00 00 8B 45 E4 83 E0 01 0F 85 4D 01 00 00 8B 4D E8 2B 4D E4 89 4D F4 8B 55 E4 C1 FA 04 83 EA 01 89 55 D0 83 7D D0 3F 76 07 C7 45 D0 3F 00 00 00 8B 45 C4 03 45 E4 89 45 C4 8B 4D C4 C1 F9 04 83 E9 01 89 4D C8 83 7D C8 3F 76 07 C7 45 C8 3F 00 00 00 8B 55 D0 3B 55 C8 0F 84 F7 00 00 00 8B 45 F4 8B 4D F4 8B 50 04 3B 51 08 0F 85 C7 00 00 00 83 7D D0 20 73 5B B8 00 00 00 80 8B 4D D0 D3 E8 F7 D0 8B 4D EC 8B 55 D4 23 44 8A 44 8B 4D EC 8B 55 D4 89 44 8A 44 8B 45 D4 03 45 D0 8A 48 04 80 E9 01 8B 55 D4 03 55 D0 88 4A 04 8B 45 D4 03 45 D0 0F BE 48 04 85 C9 75 16 BA 00 00 00 80 8B 4D D0 D3 EA F7 D2 8B 45 08 23 10 8B 4D 08 89 11 EB 66 8B 4D D0 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 EC 8B 4D D4 23 94 81 C4 00 00 00 8B 45 EC 8B 4D D4 89 94 81 C4 00 00 00 8B 55 D4 03 55 D0 8A 42 04 2C 01 8B 4D D4 03 4D D0 88 41 04 8B 55 D4 03 55 D0 0F BE 42 04 85 C0 75 1B 8B 4D D0 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 08 23 50 04 8B 4D 08 89 51 04 8B 55 F4 8B 42 08 8B 4D F4 8B 51 04 89 50 04 8B 45 F4 8B 48 04 8B 55 F4 8B 42 08 89 41 08 8B 4D F4 89 4D E8 8B 55 E4 83 E2 01 75 0C 8B 45 D0 3B 45 C8 0F 84 08 01 00 00 8B 4D C8 8B 55 D8 8D 04 CA 89 45 DC 8B 4D E8 8B 55 DC 8B 42 04 89 41 04 8B 4D E8 8B 55 DC 89 51 08 8B 45 DC 8B 4D E8 89 48 04 8B 55 E8 8B 42 04 8B 4D E8 89 48 08 8B 55 E8 8B 45 E8 8B 4A 04 3B 48 08 0F 85 C0 00 00 00 83 7D C8 20 73 57 8B 55 D4 03 55 C8 0F BE 42 04 8B 4D D4 03 4D C8 8A 51 04 80 C2 01 8B 4D D4 03 4D C8 88 51 04 85 C0 75 14 BA 00 00 00 80 8B 4D C8 D3 EA 8B 45 08 0B 10 8B 4D 08 89 11 BA 00 00 00 80 8B 4D C8 D3 EA 8B 45 EC 8B 4D D4 0B 54 81 44 8B 45 EC 8B 4D D4 89 54 81 44 EB 63 8B 55 D4 03 55 C8 0F BE 42 04 8B 4D D4 03 4D C8 8A 51 04 80 C2 01 8B 4D D4 03 4D C8 88 51 04 85 C0 75 19 8B 4D C8 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 08 0B 50 04 8B 4D 08 89 51 04 8B 4D C8 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 EC 8B 4D D4 0B 94 81 C4 00 00 00 8B 45 EC 8B 4D D4 89 94 81 C4 00 00 00 8B 55 E8 8B 45 C4 89 02 8B 4D E8 03 4D C4 8B 55 C4 89 51 FC 8B 45 D8 8B 08 83 E9 01 8B 55 D8 89 0A 8B 45 D8 83 38 00 0F 85 60 01 00 00 83 3D ?? ?? ?? ?? 00 0F 84 42 01 00 00 8B 0D ?? ?? ?? ?? C1 E1 0F 8B 15 ?? ?? ?? ?? 03 4A 0C 89 4D FC 68 00 40 00 00 68 00 80 00 00 8B 45 FC 50 FF 15 ?? ?? ?? ?? BA 00 00 00 80 8B 0D ?? ?? ?? ?? D3 EA A1 ?? ?? ?? ?? 0B 50 08 8B 0D ?? ?? ?? ?? 89 51 08 8B 15 ?? ?? ?? ?? 8B 42 10 8B 0D ?? ?? ?? ?? C7 84 88 C4 00 00 00 00 00 00 00 8B 15 ?? ?? ?? ?? 8B 42 10 8A 48 43 80 E9 01 8B 15 ?? ?? ?? ?? 8B 42 10 88 48 43 8B 0D ?? ?? ?? ?? 8B 51 10 0F BE 42 43 85 C0 75 14 8B 0D ?? ?? ?? ?? 8B 51 04 83 E2 FE A1 ?? ?? ?? ?? 89 50 04 8B 0D ?? ?? ?? ?? 83 79 08 FF 0F 85 91 00 00 00 68 00 80 00 00 6A 00 8B 15 ?? ?? ?? ?? 8B 42 0C 50 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 51 10 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 6B C9 14 03 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C2 14 2B CA 51 A1 ?? ?? ?? ?? 83 C0 14 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 15 ?? ?? ?? ?? 83 EA 01 89 15 ?? ?? ?? ?? 8B 45 08 3B 05 ?? ?? ?? ?? 76 09 8B 4D 08 83 E9 14 89 4D 08 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8B 45 08 A3 ?? ?? ?? ?? 8B 4D EC 89 0D ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_8_0 {
	meta:
		name = "___sbh_alloc_block"
		size = 1307
		refs = "000a ___sbh_cntHeaderList 0013 ___sbh_pHeaderList 0062 ___sbh_pHeaderScan 0140 ___sbh_alloc_new_region 0159 ___sbh_alloc_new_group 04ed ___sbh_pHeaderDefer 04f8 ___sbh_indGroupDefer"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 56 A1 ?? ?? ?? ?? 6B C0 14 03 05 ?? ?? ?? ?? 89 45 F4 8B 4D 08 83 C1 17 83 E1 F0 89 4D C8 8B 55 C8 C1 FA 04 83 EA 01 89 55 CC 83 7D CC 20 7D 14 83 C8 FF 8B 4D CC D3 E8 89 45 E8 C7 45 D0 FF FF FF FF EB 15 C7 45 E8 00 00 00 00 8B 4D CC 83 E9 20 83 CA FF D3 EA 89 55 D0 A1 ?? ?? ?? ?? 89 45 E4 8B 4D E4 3B 4D F4 73 22 8B 55 E4 8B 45 E8 23 02 8B 4D E4 8B 55 D0 23 51 04 0B C2 74 02 EB 0B 8B 45 E4 83 C0 14 89 45 E4 EB D6 8B 4D E4 3B 4D F4 0F 85 DB 00 00 00 8B 15 ?? ?? ?? ?? 89 55 E4 8B 45 E4 3B 05 ?? ?? ?? ?? 73 22 8B 4D E4 8B 55 E8 23 11 8B 45 E4 8B 4D D0 23 48 04 0B D1 74 02 EB 0B 8B 55 E4 83 C2 14 89 55 E4 EB D3 8B 45 E4 3B 05 ?? ?? ?? ?? 0F 85 96 00 00 00 8B 4D E4 3B 4D F4 73 16 8B 55 E4 83 7A 08 00 74 02 EB 0B 8B 45 E4 83 C0 14 89 45 E4 EB E2 8B 4D E4 3B 4D F4 75 4A 8B 15 ?? ?? ?? ?? 89 55 E4 8B 45 E4 3B 05 ?? ?? ?? ?? 73 16 8B 4D E4 83 79 08 00 74 02 EB 0B 8B 55 E4 83 C2 14 89 55 E4 EB DF 8B 45 E4 3B 05 ?? ?? ?? ?? 75 15 E8 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 07 33 C0 E9 C2 03 00 00 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 E4 8B 4A 10 89 01 8B 55 E4 8B 42 10 83 38 FF 75 07 33 C0 E9 9C 03 00 00 8B 4D E4 89 0D ?? ?? ?? ?? 8B 55 E4 8B 42 10 89 45 D8 8B 4D D8 8B 11 89 55 EC 83 7D EC FF 74 21 8B 45 EC 8B 4D D8 8B 55 E8 23 54 81 44 8B 45 EC 8B 4D D8 8B 75 D0 23 B4 81 C4 00 00 00 0B D6 75 33 C7 45 EC 00 00 00 00 8B 55 EC 8B 45 D8 8B 4D E8 23 4C 90 44 8B 55 EC 8B 45 D8 8B 75 D0 23 B4 90 C4 00 00 00 0B CE 75 0B 8B 4D EC 83 C1 01 89 4D EC EB D4 8B 55 EC 69 D2 04 02 00 00 8B 45 D8 8D 8C 10 44 01 00 00 89 4D DC C7 45 CC 00 00 00 00 8B 55 EC 8B 45 D8 8B 4D E8 23 4C 90 44 89 4D FC 75 1A C7 45 CC 20 00 00 00 8B 55 EC 8B 45 D8 8B 4D D0 23 8C 90 C4 00 00 00 89 4D FC 83 7D FC 00 7C 13 8B 55 FC D1 E2 89 55 FC 8B 45 CC 83 C0 01 89 45 CC EB E7 8B 4D CC 8B 55 DC 8B 44 CA 04 89 45 F8 8B 4D F8 8B 11 2B 55 C8 89 55 D4 8B 45 D4 C1 F8 04 83 E8 01 89 45 F0 83 7D F0 3F 7E 07 C7 45 F0 3F 00 00 00 8B 4D F0 3B 4D CC 0F 84 08 02 00 00 8B 55 F8 8B 45 F8 8B 4A 04 3B 48 08 0F 85 C6 00 00 00 83 7D CC 20 7D 5A BA 00 00 00 80 8B 4D CC D3 EA F7 D2 8B 45 EC 8B 4D D8 23 54 81 44 8B 45 EC 8B 4D D8 89 54 81 44 8B 55 D8 03 55 CC 8A 42 04 2C 01 8B 4D D8 03 4D CC 88 41 04 8B 55 D8 03 55 CC 0F BE 42 04 85 C0 75 16 BA 00 00 00 80 8B 4D CC D3 EA F7 D2 8B 45 E4 23 10 8B 4D E4 89 11 EB 66 8B 4D CC 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 EC 8B 4D D8 23 94 81 C4 00 00 00 8B 45 EC 8B 4D D8 89 94 81 C4 00 00 00 8B 55 D8 03 55 CC 8A 42 04 2C 01 8B 4D D8 03 4D CC 88 41 04 8B 55 D8 03 55 CC 0F BE 42 04 85 C0 75 1B 8B 4D CC 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 E4 23 50 04 8B 4D E4 89 51 04 8B 55 F8 8B 42 08 8B 4D F8 8B 51 04 89 50 04 8B 45 F8 8B 48 04 8B 55 F8 8B 42 08 89 41 08 83 7D D4 00 0F 84 08 01 00 00 8B 4D F0 8B 55 DC 8D 04 CA 89 45 E0 8B 4D F8 8B 55 E0 8B 42 04 89 41 04 8B 4D F8 8B 55 E0 89 51 08 8B 45 E0 8B 4D F8 89 48 04 8B 55 F8 8B 42 04 8B 4D F8 89 48 08 8B 55 F8 8B 45 F8 8B 4A 04 3B 48 08 0F 85 C0 00 00 00 83 7D F0 20 7D 57 8B 55 D8 03 55 F0 0F BE 42 04 8B 4D D8 03 4D F0 8A 51 04 80 C2 01 8B 4D D8 03 4D F0 88 51 04 85 C0 75 14 BA 00 00 00 80 8B 4D F0 D3 EA 8B 45 E4 0B 10 8B 4D E4 89 11 BA 00 00 00 80 8B 4D F0 D3 EA 8B 45 EC 8B 4D D8 0B 54 81 44 8B 45 EC 8B 4D D8 89 54 81 44 EB 63 8B 55 D8 03 55 F0 0F BE 42 04 8B 4D D8 03 4D F0 8A 51 04 80 C2 01 8B 4D D8 03 4D F0 88 51 04 85 C0 75 19 8B 4D F0 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 E4 0B 50 04 8B 4D E4 89 51 04 8B 4D F0 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 EC 8B 4D D8 0B 94 81 C4 00 00 00 8B 45 EC 8B 4D D8 89 94 81 C4 00 00 00 83 7D D4 00 74 14 8B 55 F8 8B 45 D4 89 02 8B 4D F8 03 4D D4 8B 55 D4 89 51 FC 8B 45 F8 03 45 D4 89 45 F8 8B 4D C8 83 C1 01 8B 55 F8 89 0A 8B 45 C8 83 C0 01 8B 4D F8 03 4D C8 89 41 FC 8B 55 DC 8B 02 8B 4D DC 8B 11 83 C2 01 8B 4D DC 89 11 85 C0 75 20 8B 55 E4 3B 15 ?? ?? ?? ?? 75 15 8B 45 EC 3B 05 ?? ?? ?? ?? 75 0A C7 05 ?? ?? ?? ?? 00 00 00 00 8B 4D D8 8B 55 EC 89 11 8B 45 F8 83 C0 04 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_9_0 {
	meta:
		name = "___sbh_alloc_new_region"
		size = 271
		refs = "0007 ___sbh_cntHeaderList 000d ___sbh_sizeHeaderList 0022 ___sbh_pHeaderList 002a __crtheap 0031 __imp__HeapReAlloc@16 007e __imp__HeapAlloc@12 00a5 __imp__VirtualAlloc@16 00ca __imp__HeapFree@12"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 4A 8B 0D ?? ?? ?? ?? 83 C1 10 6B C9 14 51 8B 15 ?? ?? ?? ?? 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 07 33 C0 E9 C6 00 00 00 8B 4D FC 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C2 10 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 6B C0 14 03 05 ?? ?? ?? ?? 89 45 FC 68 C4 41 00 00 6A 08 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 55 FC 89 42 10 8B 45 FC 83 78 10 00 75 04 33 C0 EB 76 6A 04 68 00 20 00 00 68 00 00 10 00 6A 00 FF 15 ?? ?? ?? ?? 8B 4D FC 89 41 0C 8B 55 FC 83 7A 0C 00 75 1A 8B 45 FC 8B 48 10 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 33 C0 EB 39 8B 45 FC C7 00 00 00 00 00 8B 4D FC C7 41 04 00 00 00 00 8B 55 FC C7 42 08 FF FF FF FF A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 4D FC 8B 51 10 C7 02 FF FF FF FF 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_10_0 {
	meta:
		name = "___sbh_alloc_new_group"
		size = 492
		refs = "00a9 __imp__VirtualAlloc@16"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 8B 45 08 8B 48 10 89 4D E0 8B 55 08 8B 42 08 89 45 D4 C7 45 D8 00 00 00 00 83 7D D4 00 7C 13 8B 4D D4 D1 E1 89 4D D4 8B 55 D8 83 C2 01 89 55 D8 EB E7 8B 45 D8 69 C0 04 02 00 00 8B 4D E0 8D 94 01 44 01 00 00 89 55 E4 C7 45 EC 00 00 00 00 EB 09 8B 45 EC 83 C0 01 89 45 EC 83 7D EC 3F 7D 20 8B 4D EC 8B 55 E4 8D 04 CA 89 45 F8 8B 4D F8 8B 55 F8 89 51 08 8B 45 F8 8B 4D F8 89 48 04 EB D1 8B 55 D8 C1 E2 0F 8B 45 08 03 50 0C 89 55 F4 6A 04 68 00 10 00 00 68 00 80 00 00 8B 4D F4 51 FF 15 ?? ?? ?? ?? 85 C0 75 08 83 C8 FF E9 2F 01 00 00 8B 55 F4 81 C2 00 70 00 00 89 55 FC 8B 45 F4 89 45 F0 EB 0C 8B 4D F0 81 C1 00 10 00 00 89 4D F0 8B 55 F0 3B 55 FC 77 5D 8B 45 F0 C7 40 08 FF FF FF FF 8B 4D F0 C7 81 FC 0F 00 00 FF FF FF FF 8B 55 F0 83 C2 0C 89 55 F8 8B 45 F8 C7 00 F0 0F 00 00 8B 4D F8 81 C1 00 10 00 00 8B 55 F8 89 4A 04 8B 45 F8 2D 00 10 00 00 8B 4D F8 89 41 08 8B 55 F8 81 C2 EC 0F 00 00 89 55 DC 8B 45 DC C7 00 F0 0F 00 00 EB 8F 8B 4D E4 81 C1 F8 01 00 00 89 4D E8 8B 55 F4 83 C2 0C 8B 45 E8 89 50 04 8B 4D E8 8B 51 04 89 55 F8 8B 45 F8 8B 4D E8 89 48 08 8B 55 FC 83 C2 0C 8B 45 E8 89 50 08 8B 4D E8 8B 51 08 89 55 F8 8B 45 F8 8B 4D E8 89 48 04 8B 55 D8 8B 45 E0 C7 44 90 44 00 00 00 00 8B 4D D8 8B 55 E0 C7 84 8A C4 00 00 00 01 00 00 00 8B 45 E0 0F BE 48 43 8B 55 E0 8A 42 43 04 01 8B 55 E0 88 42 43 85 C9 75 0F 8B 45 08 8B 48 04 83 C9 01 8B 55 08 89 4A 04 B8 00 00 00 80 8B 4D D8 D3 E8 F7 D0 8B 4D 08 23 41 08 8B 55 08 89 42 08 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_11_0 {
	meta:
		name = "___sbh_resize_block"
		size = 1480
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 10 83 C0 17 83 E0 F0 89 45 E4 8B 4D 08 8B 51 10 89 55 DC 8B 45 08 8B 4D 0C 2B 48 0C 89 4D EC 8B 55 EC C1 EA 0F 89 55 F4 8B 45 F4 69 C0 04 02 00 00 8B 4D DC 8D 94 01 44 01 00 00 89 55 E0 8B 45 0C 83 E8 04 89 45 F0 8B 4D F0 8B 11 83 EA 01 89 55 D0 8B 45 F0 03 45 D0 89 45 FC 8B 4D FC 8B 11 89 55 D8 8B 45 E4 3B 45 D0 0F 8E 9C 02 00 00 8B 4D D8 83 E1 01 75 0B 8B 55 D0 03 55 D8 39 55 E4 7E 07 33 C0 E9 31 05 00 00 8B 45 D8 C1 F8 04 83 E8 01 89 45 F8 83 7D F8 3F 76 07 C7 45 F8 3F 00 00 00 8B 4D FC 8B 55 FC 8B 41 04 3B 42 08 0F 85 C6 00 00 00 83 7D F8 20 73 5A BA 00 00 00 80 8B 4D F8 D3 EA F7 D2 8B 45 F4 8B 4D DC 23 54 81 44 8B 45 F4 8B 4D DC 89 54 81 44 8B 55 DC 03 55 F8 8A 42 04 2C 01 8B 4D DC 03 4D F8 88 41 04 8B 55 DC 03 55 F8 0F BE 42 04 85 C0 75 16 BA 00 00 00 80 8B 4D F8 D3 EA F7 D2 8B 45 08 23 10 8B 4D 08 89 11 EB 66 8B 4D F8 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 F4 8B 4D DC 23 94 81 C4 00 00 00 8B 45 F4 8B 4D DC 89 94 81 C4 00 00 00 8B 55 DC 03 55 F8 8A 42 04 2C 01 8B 4D DC 03 4D F8 88 41 04 8B 55 DC 03 55 F8 0F BE 42 04 85 C0 75 1B 8B 4D F8 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 08 23 50 04 8B 4D 08 89 51 04 8B 55 FC 8B 42 08 8B 4D FC 8B 51 04 89 50 04 8B 45 FC 8B 48 04 8B 55 FC 8B 42 08 89 41 08 8B 4D D0 03 4D D8 2B 4D E4 89 4D D8 83 7D D8 00 0F 8E 3E 01 00 00 8B 55 F0 03 55 E4 89 55 FC 8B 45 D8 C1 F8 04 83 E8 01 89 45 F8 83 7D F8 3F 76 07 C7 45 F8 3F 00 00 00 8B 4D F8 8B 55 E0 8D 04 CA 89 45 E8 8B 4D FC 8B 55 E8 8B 42 04 89 41 04 8B 4D FC 8B 55 E8 89 51 08 8B 45 E8 8B 4D FC 89 48 04 8B 55 FC 8B 42 04 8B 4D FC 89 48 08 8B 55 FC 8B 45 FC 8B 4A 04 3B 48 08 0F 85 C0 00 00 00 83 7D F8 20 73 57 8B 55 DC 03 55 F8 0F BE 42 04 8B 4D DC 03 4D F8 8A 51 04 80 C2 01 8B 4D DC 03 4D F8 88 51 04 85 C0 75 14 BA 00 00 00 80 8B 4D F8 D3 EA 8B 45 08 0B 10 8B 4D 08 89 11 BA 00 00 00 80 8B 4D F8 D3 EA 8B 45 F4 8B 4D DC 0B 54 81 44 8B 45 F4 8B 4D DC 89 54 81 44 EB 63 8B 55 DC 03 55 F8 0F BE 42 04 8B 4D DC 03 4D F8 8A 51 04 80 C2 01 8B 4D DC 03 4D F8 88 51 04 85 C0 75 19 8B 4D F8 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 08 0B 50 04 8B 4D 08 89 51 04 8B 4D F8 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 F4 8B 4D DC 0B 94 81 C4 00 00 00 8B 45 F4 8B 4D DC 89 94 81 C4 00 00 00 8B 55 FC 8B 45 D8 89 02 8B 4D FC 03 4D D8 8B 55 D8 89 51 FC 8B 45 E4 83 C0 01 8B 4D F0 89 01 8B 55 E4 83 C2 01 8B 45 F0 03 45 E4 89 50 FC E9 AA 02 00 00 8B 4D E4 3B 4D D0 0F 8D 9E 02 00 00 8B 55 E4 83 C2 01 8B 45 F0 89 10 8B 4D E4 83 C1 01 8B 55 F0 03 55 E4 89 4A FC 8B 45 F0 03 45 E4 89 45 F0 8B 4D D0 2B 4D E4 89 4D D0 8B 55 D0 C1 FA 04 83 EA 01 89 55 D4 83 7D D4 3F 76 07 C7 45 D4 3F 00 00 00 8B 45 D8 83 E0 01 0F 85 31 01 00 00 8B 4D D8 C1 F9 04 83 E9 01 89 4D F8 83 7D F8 3F 76 07 C7 45 F8 3F 00 00 00 8B 55 FC 8B 45 FC 8B 4A 04 3B 48 08 0F 85 C6 00 00 00 83 7D F8 20 73 5A BA 00 00 00 80 8B 4D F8 D3 EA F7 D2 8B 45 F4 8B 4D DC 23 54 81 44 8B 45 F4 8B 4D DC 89 54 81 44 8B 55 DC 03 55 F8 8A 42 04 2C 01 8B 4D DC 03 4D F8 88 41 04 8B 55 DC 03 55 F8 0F BE 42 04 85 C0 75 16 BA 00 00 00 80 8B 4D F8 D3 EA F7 D2 8B 45 08 23 10 8B 4D 08 89 11 EB 66 8B 4D F8 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 F4 8B 4D DC 23 94 81 C4 00 00 00 8B 45 F4 8B 4D DC 89 94 81 C4 00 00 00 8B 55 DC 03 55 F8 8A 42 04 2C 01 8B 4D DC 03 4D F8 88 41 04 8B 55 DC 03 55 F8 0F BE 42 04 85 C0 75 1B 8B 4D F8 83 E9 20 BA 00 00 00 80 D3 EA F7 D2 8B 45 08 23 50 04 8B 4D 08 89 51 04 8B 55 FC 8B 42 08 8B 4D FC 8B 51 04 89 50 04 8B 45 FC 8B 48 04 8B 55 FC 8B 42 08 89 41 08 8B 4D D0 03 4D D8 89 4D D0 8B 55 D0 C1 FA 04 83 EA 01 89 55 D4 83 7D D4 3F 76 07 C7 45 D4 3F 00 00 00 8B 45 D4 8B 4D E0 8D 14 C1 89 55 E8 8B 45 F0 8B 4D E8 8B 51 04 89 50 04 8B 45 F0 8B 4D E8 89 48 08 8B 55 E8 8B 45 F0 89 42 04 8B 4D F0 8B 51 04 8B 45 F0 89 42 08 8B 4D F0 8B 55 F0 8B 41 04 3B 42 08 0F 85 C0 00 00 00 83 7D D4 20 73 57 8B 4D DC 03 4D D4 0F BE 51 04 8B 45 DC 03 45 D4 8A 48 04 80 C1 01 8B 45 DC 03 45 D4 88 48 04 85 D2 75 14 BA 00 00 00 80 8B 4D D4 D3 EA 8B 45 08 0B 10 8B 4D 08 89 11 BA 00 00 00 80 8B 4D D4 D3 EA 8B 45 F4 8B 4D DC 0B 54 81 44 8B 45 F4 8B 4D DC 89 54 81 44 EB 63 8B 55 DC 03 55 D4 0F BE 42 04 8B 4D DC 03 4D D4 8A 51 04 80 C2 01 8B 4D DC 03 4D D4 88 51 04 85 C0 75 19 8B 4D D4 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 08 0B 50 04 8B 4D 08 89 51 04 8B 4D D4 83 E9 20 BA 00 00 00 80 D3 EA 8B 45 F4 8B 4D DC 0B 94 81 C4 00 00 00 8B 45 F4 8B 4D DC 89 94 81 C4 00 00 00 8B 55 F0 8B 45 D0 89 02 8B 4D F0 03 4D D0 8B 55 D0 89 51 FC B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_12_0 {
	meta:
		name = "___sbh_heapmin"
		size = 302
		refs = "0008 ___sbh_pHeaderDefer 0014 ___sbh_indGroupDefer 0037 __imp__VirtualFree@12 00c0 ___sbh_cntHeaderList 00d4 __crtheap 00db __imp__HeapFree@12 00e9 ___sbh_pHeaderList 010a _memmove"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 3D ?? ?? ?? ?? 00 0F 84 17 01 00 00 A1 ?? ?? ?? ?? C1 E0 0F 8B 0D ?? ?? ?? ?? 03 41 0C 89 45 FC 68 00 40 00 00 68 00 80 00 00 8B 55 FC 52 FF 15 ?? ?? ?? ?? B8 00 00 00 80 8B 0D ?? ?? ?? ?? D3 E8 8B 0D ?? ?? ?? ?? 0B 41 08 8B 15 ?? ?? ?? ?? 89 42 08 A1 ?? ?? ?? ?? 8B 48 10 8B 15 ?? ?? ?? ?? C7 84 91 C4 00 00 00 00 00 00 00 A1 ?? ?? ?? ?? 8B 48 10 8A 51 43 80 EA 01 A1 ?? ?? ?? ?? 8B 48 10 88 51 43 8B 15 ?? ?? ?? ?? 8B 42 10 0F BE 48 43 85 C9 75 15 8B 15 ?? ?? ?? ?? 8B 42 04 83 E0 FE 8B 0D ?? ?? ?? ?? 89 41 04 8B 15 ?? ?? ?? ?? 83 7A 08 FF 75 62 83 3D ?? ?? ?? ?? 01 7E 59 A1 ?? ?? ?? ?? 8B 48 10 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 6B C0 14 03 05 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C1 14 2B C1 50 8B 15 ?? ?? ?? ?? 83 C2 14 52 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 0D ?? ?? ?? ?? 83 E9 01 89 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_13_0 {
	meta:
		name = "___sbh_heap_check"
		size = 1257
		refs = "000d ___sbh_pHeaderList 0047 ___sbh_cntHeaderList"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 6C 01 00 00 83 3D ?? ?? ?? ?? 00 75 08 83 C8 FF E9 C9 04 00 00 A1 ?? ?? ?? ?? 89 45 C8 C7 85 94 FE FF FF 00 00 00 00 EB 0F 8B 8D 94 FE FF FF 83 C1 01 89 8D 94 FE FF FF 8B 95 94 FE FF FF 3B 15 ?? ?? ?? ?? 0F 8D 92 04 00 00 8B 45 C8 8B 48 10 89 4D B8 83 7D B8 00 75 0A B8 FE FF FF FF E9 7B 04 00 00 8B 55 C8 8B 42 0C 89 45 F0 8B 4D B8 81 C1 44 01 00 00 89 4D BC 8B 55 C8 8B 42 08 89 85 A4 FE FF FF C7 45 CC 00 00 00 00 C7 45 B0 00 00 00 00 C7 45 E4 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 83 7D E4 20 0F 8D 04 04 00 00 C7 45 F4 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 EC 00 00 00 00 C7 85 98 FE FF FF 00 00 00 00 EB 0F 8B 95 98 FE FF FF 83 C2 01 89 95 98 FE FF FF 83 BD 98 FE FF FF 40 7D 13 8B 85 98 FE FF FF C7 84 85 A8 FE FF FF 00 00 00 00 EB D5 83 BD A4 FE FF FF 00 0F 8C 58 03 00 00 83 7D F0 00 75 0A B8 FC FF FF FF E9 C7 03 00 00 8B 4D F0 89 4D D8 C7 45 E8 00 00 00 00 EB 09 8B 55 E8 83 C2 01 89 55 E8 83 7D E8 08 0F 8D 26 01 00 00 8B 45 D8 83 C0 0C 89 45 DC 8B 4D DC 81 C1 F0 0F 00 00 89 4D D0 8B 55 DC 83 7A FC FF 75 08 8B 45 D0 83 38 FF 74 0A B8 FB FF FF FF E9 75 03 00 00 8B 4D DC 8B 11 89 55 C4 8B 45 C4 89 85 A0 FE FF FF 8B 8D A0 FE FF FF 83 E1 01 74 27 8B 55 C4 83 EA 01 89 55 C4 81 7D C4 00 04 00 00 7E 0A B8 FA FF FF FF E9 3D 03 00 00 8B 45 EC 83 C0 01 89 45 EC EB 3F 8B 4D C4 C1 F9 04 83 E9 01 89 8D 98 FE FF FF 83 BD 98 FE FF FF 3F 7E 0A C7 85 98 FE FF FF 3F 00 00 00 8B 95 98 FE FF FF 8B 84 95 A8 FE FF FF 83 C0 01 8B 8D 98 FE FF FF 89 84 8D A8 FE FF FF 83 7D C4 10 7C 11 8B 55 C4 83 E2 0F 75 09 81 7D C4 F0 0F 00 00 7E 0A B8 F9 FF FF FF E9 D2 02 00 00 8B 45 DC 03 45 C4 8B 48 FC 3B 8D A0 FE FF FF 74 0A B8 F8 FF FF FF E9 B7 02 00 00 8B 55 DC 03 55 C4 89 55 DC 8B 45 DC 3B 45 D0 0F 82 2D FF FF FF 8B 4D DC 3B 4D D0 74 0A B8 F8 FF FF FF E9 90 02 00 00 8B 55 D8 81 C2 00 10 00 00 89 55 D8 E9 C7 FE FF FF 8B 45 BC 8B 08 3B 4D EC 74 0A B8 F7 FF FF FF E9 6B 02 00 00 8B 55 BC 89 55 C0 C7 85 9C FE FF FF 00 00 00 00 EB 0F 8B 85 9C FE FF FF 83 C0 01 89 85 9C FE FF FF 83 BD 9C FE FF FF 40 0F 8D BE 01 00 00 C7 45 AC 00 00 00 00 8B 4D C0 89 4D DC 8B 55 DC 8B 42 04 89 45 F8 8B 4D F8 3B 4D C0 0F 84 EF 00 00 00 8B 95 9C FE FF FF 8B 45 AC 3B 84 95 A8 FE FF FF 0F 84 D9 00 00 00 8B 4D F8 3B 4D F0 72 0E 8B 55 F0 81 C2 00 80 00 00 39 55 F8 72 0A B8 F6 FF FF FF E9 E5 01 00 00 8B 45 F8 25 00 F0 FF FF 89 45 B4 8B 4D B4 83 C1 0C 89 4D D4 8B 55 D4 81 C2 F0 0F 00 00 89 55 E0 8B 45 D4 3B 45 E0 74 1A 8B 4D D4 3B 4D F8 75 02 EB 10 8B 55 D4 8B 02 83 E0 FE 03 45 D4 89 45 D4 EB DE 8B 4D D4 3B 4D E0 75 0A B8 F5 FF FF FF E9 91 01 00 00 8B 55 F8 8B 02 C1 F8 04 83 E8 01 89 85 98 FE FF FF 83 BD 98 FE FF FF 3F 7E 0A C7 85 98 FE FF FF 3F 00 00 00 8B 8D 98 FE FF FF 3B 8D 9C FE FF FF 74 0A B8 F4 FF FF FF E9 55 01 00 00 8B 55 F8 8B 42 08 3B 45 DC 74 0A B8 F3 FF FF FF E9 40 01 00 00 8B 4D F8 89 4D DC 8B 55 AC 83 C2 01 89 55 AC E9 FC FE FF FF 83 7D AC 00 74 5D 83 BD 9C FE FF FF 20 7D 28 B8 00 00 00 80 8B 8D 9C FE FF FF D3 E8 0B 45 F4 89 45 F4 BA 00 00 00 80 8B 8D 9C FE FF FF D3 EA 0B 55 CC 89 55 CC EB 2C 8B 8D 9C FE FF FF 83 E9 20 B8 00 00 00 80 D3 E8 0B 45 FC 89 45 FC 8B 8D 9C FE FF FF 83 E9 20 BA 00 00 00 80 D3 EA 0B 55 B0 89 55 B0 8B 45 DC 8B 48 04 3B 4D C0 75 12 8B 95 9C FE FF FF 8B 45 AC 3B 84 95 A8 FE FF FF 74 0A B8 F2 FF FF FF E9 A2 00 00 00 8B 4D C0 8B 51 08 3B 55 DC 74 0A B8 F1 FF FF FF E9 8D 00 00 00 8B 45 C0 83 C0 08 89 45 C0 E9 26 FE FF FF 8B 4D E4 8B 55 B8 8B 45 F4 3B 44 8A 44 75 12 8B 4D E4 8B 55 B8 8B 45 FC 3B 84 8A C4 00 00 00 74 07 B8 F0 FF FF FF EB 57 8B 4D F0 81 C1 00 80 00 00 89 4D F0 8B 55 BC 81 C2 04 02 00 00 89 55 BC 8B 85 A4 FE FF FF D1 E0 89 85 A4 FE FF FF E9 E9 FB FF FF 8B 4D C8 8B 55 CC 3B 11 75 0B 8B 45 C8 8B 4D B0 3B 48 04 74 07 B8 EF FF FF FF EB 10 8B 55 C8 83 C2 14 89 55 C8 E9 4D FB FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__wdospawn"
		size = 1076
		refs = "003d $LN43 0062 ___doserrno 009c ??_C@_1CI@LKKPAGOE@?$AA?$CI?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAm?$AAo?$AAd?$AAe?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00a5 ??_C@_1GC@OJELNCGB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00ac __CrtDbgReportW 00c3 __errno 00d7 ??_C@_1BE@DCPGLAGD@?$AA_?$AAw?$AAd?$AAo?$AAs?$AAp?$AAa?$AAw?$AAn?$AA?$AA@ 00e1 __invalid_parameter 013f _memset 014f __nhandle 017f ___pioinfo 01c0 ??_C@_0DB@MIMOOPAA@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 01ce __calloc_dbg 0371 __imp__CreateProcessW@40 037d __imp__GetLastError@0 038b __free_dbg 03a0 __dosmaperr 03b5 __exit 03c9 __imp__WaitForSingleObject@8 03d7 __imp__GetExitCodeProcess@8 03e7 __imp__CloseHandle@4 0420 $LN33 0424 $LN31 0428 $LN32 0430 $LN30"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 9C 00 00 00 C7 45 F8 00 00 00 00 C6 45 FF 00 8A 45 FF 88 45 FE 8A 4D FE 88 4D 8F 8B 55 08 89 95 6C FF FF FF 83 BD 6C FF FF FF 04 77 2D 8B 85 6C FF FF FF FF 24 85 ?? ?? ?? ?? C6 45 8F 01 E9 A6 00 00 00 E9 A1 00 00 00 C6 45 FE 01 E9 98 00 00 00 C6 45 FF 01 E9 8F 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 33 C9 74 0C C7 85 68 FF FF FF 01 00 00 00 EB 0A C7 85 68 FF FF FF 00 00 00 00 8B 95 68 FF FF FF 89 95 70 FF FF FF 83 BD 70 FF FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 70 FF FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 29 03 00 00 8B 4D 10 89 4D 94 8B 55 10 0F B7 02 85 C0 74 36 8B 4D 10 0F B7 11 85 D2 74 0B 8B 45 10 83 C0 02 89 45 10 EB EB 8B 4D 10 0F B7 51 02 85 D2 74 14 B8 20 00 00 00 8B 4D 10 66 89 01 8B 55 10 83 C2 02 89 55 10 EB C0 6A 44 6A 00 8D 45 B0 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 B0 44 00 00 00 8B 0D ?? ?? ?? ?? 89 4D 84 EB 09 8B 55 84 83 EA 01 89 55 84 83 7D 84 00 74 27 8B 45 84 83 E8 01 C1 F8 05 8B 4D 84 83 E9 01 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 85 C0 75 02 EB CA 83 7D 84 00 7C 09 81 7D 84 32 33 00 00 72 13 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 C8 FF E9 69 02 00 00 8B 4D 84 6B C9 05 83 C1 04 66 89 4D E2 6A 7D 68 ?? ?? ?? ?? 6A 02 6A 01 0F B7 55 E2 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 13 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 C8 FF E9 28 02 00 00 8B 45 E4 8B 4D 84 89 08 8B 55 E4 83 C2 04 89 55 80 8B 45 84 8B 4D E4 8D 54 01 04 89 95 74 FF FF FF C7 45 AC 00 00 00 00 EB 21 8B 45 AC 83 C0 01 89 45 AC 8B 4D 80 83 C1 01 89 4D 80 8B 95 74 FF FF FF 83 C2 04 89 95 74 FF FF FF 8B 45 AC 3B 45 84 7D 62 8B 4D AC C1 F9 05 8B 55 AC 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 95 78 FF FF FF 8B 85 78 FF FF FF 0F BE 48 04 83 E1 10 75 20 8B 55 80 8B 85 78 FF FF FF 8A 48 04 88 0A 8B 95 74 FF FF FF 8B 85 78 FF FF FF 8B 08 89 0A EB 12 8B 55 80 C6 02 00 8B 85 74 FF FF FF C7 00 FF FF FF FF E9 75 FF FF FF 0F BE 4D FF 85 C9 0F 84 86 00 00 00 C7 45 AC 00 00 00 00 8B 55 E4 83 C2 04 89 55 80 8B 45 84 8B 4D E4 8D 54 01 04 89 95 74 FF FF FF EB 21 8B 45 AC 83 C0 01 89 45 AC 8B 4D 80 83 C1 01 89 4D 80 8B 95 74 FF FF FF 83 C2 04 89 95 74 FF FF FF 83 7D 84 03 7D 0B 8B 45 84 89 85 64 FF FF FF EB 0A C7 85 64 FF FF FF 03 00 00 00 8B 4D AC 3B 8D 64 FF FF FF 7D 14 8B 55 80 C6 02 00 8B 85 74 FF FF FF C7 00 FF FF FF FF EB A5 8B 4D F8 83 C9 08 89 4D F8 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 55 F8 81 CA 00 04 00 00 89 55 F8 8D 45 9C 50 8D 4D B0 51 6A 00 8B 55 14 52 8B 45 F8 50 6A 01 6A 00 6A 00 8B 4D 94 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 85 7C FF FF FF FF 15 ?? ?? ?? ?? 89 45 90 6A 02 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 83 BD 7C FF FF FF 00 75 11 8B 4D 90 51 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 6D 83 7D 08 02 75 09 6A 00 E8 ?? ?? ?? ?? EB 51 83 7D 08 00 75 2C 6A FF 8B 55 9C 52 FF 15 ?? ?? ?? ?? 8D 45 88 50 8B 4D 9C 51 FF 15 ?? ?? ?? ?? 8B 55 88 89 55 98 8B 45 9C 50 FF 15 ?? ?? ?? ?? EB 1F 83 7D 08 04 75 13 8B 4D 9C 51 FF 15 ?? ?? ?? ?? C7 45 98 00 00 00 00 EB 06 8B 55 9C 89 55 98 8B 45 A0 50 FF 15 ?? ?? ?? ?? 8B 45 98 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__ismbcalpha_l"
		size = 359
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 004b ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0063 ??1_LocaleUpdate@@QAE@XZ 00a5 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 DF 00 00 00 33 C9 66 89 4D EC 33 D2 66 89 55 EE 8B 45 08 C1 E8 08 25 FF 00 00 00 88 45 E8 8B 4D 08 81 E1 FF 00 00 00 88 4D E9 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 17 C7 45 E4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 E9 F4 00 00 00 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 48 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 42 04 50 8D 4D EC 51 6A 02 8D 55 E8 52 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 17 C7 45 E0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 E9 9C 00 00 00 0F B7 45 EE 85 C0 75 15 0F B7 4D EC 81 E1 03 01 00 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 DC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 65 EB 5B 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 0F B6 4D 08 8B 90 C8 00 00 00 0F B7 04 4A 25 03 01 00 00 75 22 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 0F B6 55 08 0F B6 44 11 1D 83 E0 01 75 09 C7 45 D0 00 00 00 00 EB 07 C7 45 D0 01 00 00 00 8B 4D D0 89 4D D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "_abort"
		size = 307
		refs = "000c ___security_cookie 001d ___abort_behavior 0029 __NMSG_WRITE 0031 ___get_sigabrt 0041 _raise 00e0 _memset 0110 __imp__SetUnhandledExceptionFilter@4 011a __imp__UnhandledExceptionFilter@4 0121 __exit 012b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 F0 C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 83 E0 01 74 0A 6A 0A E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 0A 6A 16 E8 ?? ?? ?? ?? 83 C4 04 8B 0D ?? ?? ?? ?? 83 E1 02 0F 84 C7 00 00 00 89 85 D0 FD FF FF 89 8D CC FD FF FF 89 95 C8 FD FF FF 89 9D C4 FD FF FF 89 B5 C0 FD FF FF 89 BD BC FD FF FF 66 8C 95 E8 FD FF FF 66 8C 8D DC FD FF FF 66 8C 9D B8 FD FF FF 66 8C 85 B4 FD FF FF 66 8C A5 B0 FD FF FF 66 8C AD AC FD FF FF 9C 8F 85 E0 FD FF FF C7 85 20 FD FF FF 01 00 01 00 8B 55 04 89 95 D8 FD FF FF 8D 45 04 89 85 E4 FD FF FF 8D 4D 04 8B 51 FC 89 95 D4 FD FF FF 6A 50 6A 00 8D 85 D0 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 D0 FC FF FF 15 00 00 40 8B 4D 04 89 8D DC FC FF FF 8D 95 D0 FC FF FF 89 55 F4 8D 85 20 FD FF FF 89 45 F8 6A 00 FF 15 ?? ?? ?? ?? 8D 4D F4 51 FF 15 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "__set_abort_behavior"
		size = 43
		refs = "0007 ___abort_behavior"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 0C F7 D1 23 4D FC 8B 55 08 23 55 0C 0B CA 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "___libm_sse2_sincos"
		size = 489
		refs = "001f _PI32INV 002b _SHIFTER 003b _P_1 0047 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 009c _SC_2 00ee _SC_3 00fa _SC_1 017a _ONE 0188 _ALL_ONES 0191 _TWO_POW_55 01a1 _TWO_POW_M55 01be _cos 01d2 _sin"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 4B 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 C3 7F 42 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 F3 0F 7E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "??2@YAPAXI@Z"
		size = 128
		refs = "000d _malloc 0022 __callnewh 002f ?$S1@?5???2@YAPAXI@Z@4IA 0046 ?nomem@?5???2@YAPAXI@Z@4Vbad_alloc@std@@B 004b ??0bad_alloc@std@@QAE@XZ 0050 ??__Fnomem@?5???2@YAPAXI@Z@YAXXZ 0055 _atexit 0065 ??0bad_alloc@std@@QAE@ABV01@@Z 006a __TI2?AVbad_alloc@std@@ 0073 __CxxThrowException@8"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 75 5C 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 4A 8B 15 ?? ?? ?? ?? 83 E2 01 75 24 A1 ?? ?? ?? ?? 83 C8 01 A3 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 68 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F0 51 E8 ?? ?? ?? ?? EB 8F 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_176_1_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 40
		refs = "000c __bad_alloc_Message 0014 ??0exception@std@@QAE@ABQBDH@Z 001d ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 6A 01 68 ?? ?? ?? ?? 8B 4D FC E8 ?? ?? ?? ?? 8B 45 FC C7 00 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_176_4_0 {
	meta:
		name = "??__Fnomem@?5???2@YAPAXI@Z@YAXXZ"
		size = 17
		refs = "0006 ?nomem@?5???2@YAPAXI@Z@4Vbad_alloc@std@@B 000b ??1bad_alloc@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_31_323_1 {
	meta:
		name = "??__Einit_cerr@std@@YAXXZ"
		size = 17
		refs = "0006 _init_cerr 000b ??0_Init_cerr@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_9_323_1 {
	meta:
		name = "??__Einit_cin@std@@YAXXZ"
		size = 17
		refs = "0006 _init_cin 000b ??0_Init_cin@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_41_323_1 {
	meta:
		name = "??__Einit_clog@std@@YAXXZ"
		size = 17
		refs = "0006 _init_clog 000b ??0_Init_clog@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_50_323_1 {
	meta:
		name = "??__Einit_cout@std@@YAXXZ"
		size = 17
		refs = "0006 _init_cout 000b ??0_Init_cout@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_22_347_1 {
	meta:
		name = "??__Einit_ushcerr@std@@YAXXZ"
		size = 17
		refs = "0006 _init_ushcerr 000b ??0_Init_ushcerr@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_347_1 {
	meta:
		name = "??__Einit_ushcin@std@@YAXXZ"
		size = 17
		refs = "0006 _init_ushcin 000b ??0_Init_ushcin@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_61_347_1 {
	meta:
		name = "??__Einit_ushclog@std@@YAXXZ"
		size = 17
		refs = "0006 _init_ushclog 000b ??0_Init_ushclog@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_39_347_1 {
	meta:
		name = "??__Einit_ushcout@std@@YAXXZ"
		size = 17
		refs = "0006 _init_ushcout 000b ??0_Init_ushcout@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_60_347_1 {
	meta:
		name = "??__Einit_wcerr@std@@YAXXZ"
		size = 17
		refs = "0006 _init_wcerr 000b ??0_Init_wcerr@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_27_347_1 {
	meta:
		name = "??__Einit_wcin@std@@YAXXZ"
		size = 17
		refs = "0006 _init_wcin 000b ??0_Init_wcin@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_46_347_1 {
	meta:
		name = "??__Einit_wclog@std@@YAXXZ"
		size = 17
		refs = "0006 _init_wclog 000b ??0_Init_wclog@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_8_347_1 {
	meta:
		name = "??__Einit_wcout@std@@YAXXZ"
		size = 17
		refs = "0006 _init_wcout 000b ??0_Init_wcout@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_31_331_1 {
	meta:
		name = "??__Fcerr@std@@YAXXZ"
		size = 17
		refs = "0006 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000b ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_9_330_1 {
	meta:
		name = "??__Fcin@std@@YAXXZ"
		size = 17
		refs = "0006 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 000b ??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_62_142_1 {
	meta:
		name = "??__Fclassic_locale@std@@YAXXZ"
		size = 17
		refs = "0006 _classic_locale 000b ??1locale@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_41_330_1 {
	meta:
		name = "??__Fclog@std@@YAXXZ"
		size = 17
		refs = "0006 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000b ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_50_330_1 {
	meta:
		name = "??__Fcout@std@@YAXXZ"
		size = 17
		refs = "0006 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000b ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_31_330_1 {
	meta:
		name = "??__Fferr@std@@YAXXZ"
		size = 17
		refs = "0006 _ferr 000b ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_9_329_1 {
	meta:
		name = "??__Ffin@std@@YAXXZ"
		size = 17
		refs = "0006 _fin 000b ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_41_329_1 {
	meta:
		name = "??__Fflog@std@@YAXXZ"
		size = 17
		refs = "0006 _flog 000b ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_50_329_1 {
	meta:
		name = "??__Ffout@std@@YAXXZ"
		size = 17
		refs = "0006 _fout 000b ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_23_16_1 {
	meta:
		name = "??__Finit_atexit@@YAXXZ"
		size = 17
		refs = "0006 _init_atexit 000b ??1_Init_atexit@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_27_350_1 {
	meta:
		name = "??__Finitlocks@@YAXXZ"
		size = 17
		refs = "0006 _initlocks 000b ??1_Init_locks@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_23_15_1 {
	meta:
		name = "??__Finitlocks@std@@YAXXZ"
		size = 17
		refs = "0006 _initlocks 000b ??1_Init_locks@std@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_13_4_1 {
	meta:
		name = "??__Fnomem@?1??_Nomemory@std@@YAXXZ@YAXXZ"
		size = 17
		refs = "0006 ?nomem@?1??_Nomemory@std@@YAXXZ@4Vbad_alloc@2@B 000b ??1bad_alloc@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_5_4_1 {
	meta:
		name = "??__Fnomem@?4???2@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z@YAXXZ"
		size = 17
		refs = "0006 ?nomem@?4???2@YAPAXIABU_DebugHeapTag_t@std@@PADH@Z@4Vbad_alloc@2@B 000b ??1bad_alloc@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_692_4_0 {
	meta:
		name = "??__Fnomem@?4???2@YAPAXIHPBDH@Z@YAXXZ"
		size = 17
		refs = "0006 ?nomem@?4???2@YAPAXIHPBDH@Z@4Vbad_alloc@std@@B 000b ??1bad_alloc@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_37_427_1 {
	meta:
		name = "??__Fnomem@?L@??_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z@YAXXZ"
		size = 17
		refs = "0006 ?nomem@?L@??_Locimp_Addfac@_Locimp@locale@std@@CAXPAV234@PAVfacet@34@I@Z@4Vbad_alloc@4@B 000b ??1bad_alloc@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_37_426_1 {
	meta:
		name = "??__Fnomem@?P@??_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z@YAXXZ"
		size = 17
		refs = "0006 ?nomem@?P@??_Locimp_ctor@_Locimp@locale@std@@CAXPAV234@ABV234@@Z@4Vbad_alloc@4@B 000b ??1bad_alloc@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_60_353_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 17
		refs = "0006 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000b ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_22_353_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 17
		refs = "0006 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000b ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_352_1 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 17
		refs = "0006 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 000b ??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_27_352_1 {
	meta:
		name = "??__Fwcin@std@@YAXXZ"
		size = 17
		refs = "0006 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 000b ??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_46_352_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 17
		refs = "0006 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000b ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_61_352_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 17
		refs = "0006 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000b ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_39_352_1 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 17
		refs = "0006 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000b ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_8_352_1 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 17
		refs = "0006 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000b ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_60_352_1 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 17
		refs = "0006 _wferr 000b ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_22_352_1 {
	meta:
		name = "??__Fwferr@std@@YAXXZ"
		size = 17
		refs = "0006 _wferr 000b ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_27_351_1 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 17
		refs = "0006 _wfin 000b ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_80_351_1 {
	meta:
		name = "??__Fwfin@std@@YAXXZ"
		size = 17
		refs = "0006 _wfin 000b ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_61_351_1 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 17
		refs = "0006 _wflog 000b ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_46_351_1 {
	meta:
		name = "??__Fwflog@std@@YAXXZ"
		size = 17
		refs = "0006 _wflog 000b ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_8_351_1 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 17
		refs = "0006 _wfout 000b ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_39_351_1 {
	meta:
		name = "??__Fwfout@std@@YAXXZ"
		size = 17
		refs = "0006 _wfout 000b ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "__fstat32"
		size = 1566
		refs = "0008 __sehtable$__fstat32 000d __except_handler4 001f ___security_cookie 004c ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0055 ??_C@_1FO@HJNCCKEJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005c __CrtDbgReportW 0070 ___doserrno 007b __errno 008f ??_C@_1BC@OPNEMFNJ@?$AA_?$AAf?$AAs?$AAt?$AAa?$AAt?$AA3?$AA2?$AA?$AA@ 0099 __invalid_parameter 00b1 _memset 00e7 __nhandle 0113 ??_C@_1GO@IHCMJFJC@?$AA?$CI?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs@ 0181 ___pioinfo 0199 ??_C@_1DE@GMHIHBND@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 01fa ___lock_fhandle 023f ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 027d __imp__GetFileType@4 0353 __imp__PeekNamedPipe@24 039d __imp__GetLastError@0 03a3 __dosmaperr 0406 __imp__GetFileInformationByHandle@8 0471 __imp__FileTimeToLocalFileTime@8 0483 __imp__FileTimeToSystemTime@8 04b8 ___loctotime32_t 0601 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 8C 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 D8 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 90 83 7D 90 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 90 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 64 05 00 00 6A 24 6A 00 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 30 05 00 00 83 7D 08 00 7C 17 8B 45 08 3B 05 ?? ?? ?? ?? 73 0C C7 85 7C FF FF FF 01 00 00 00 EB 0A C7 85 7C FF FF FF 00 00 00 00 8B 8D 7C FF FF FF 89 4D 8C 83 7D 8C 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 8C 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 9D 04 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 F7 D8 1B C0 F7 D8 89 45 88 75 1E 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D 88 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 17 04 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 0F BE 44 0A 04 83 E0 01 75 39 E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 D8 FF FF FF FF 33 C9 75 1E 68 ?? ?? ?? ?? 6A 00 6A 5B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC E9 8D 03 00 00 8B 45 08 C1 F8 05 8B 4D 08 83 E1 1F C1 E1 06 8B 14 85 ?? ?? ?? ?? 8B 04 0A 50 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 89 45 DC 83 7D DC 01 0F 84 23 01 00 00 83 7D DC 02 74 0A 83 7D DC 03 0F 85 D9 00 00 00 83 7D DC 02 75 0E B9 00 20 00 00 8B 55 0C 66 89 4A 06 EB 0C B8 00 10 00 00 8B 4D 0C 66 89 41 06 8B 55 0C 8B 45 08 89 02 8B 4D 0C 8B 55 08 89 51 10 B8 01 00 00 00 8B 4D 0C 66 89 41 08 33 D2 8B 45 0C 66 89 50 04 33 C9 8B 55 0C 66 89 4A 0C 33 C0 8B 4D 0C 66 89 41 0A 8B 55 0C C7 42 20 00 00 00 00 8B 45 0C C7 40 1C 00 00 00 00 8B 4D 0C C7 41 18 00 00 00 00 83 7D DC 02 75 0C 8B 55 0C C7 42 14 00 00 00 00 EB 4A 6A 00 8D 45 80 50 6A 00 6A 00 6A 00 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 89 45 84 83 7D 84 00 74 0B 8B 55 0C 8B 45 80 89 42 14 EB 0A 8B 4D 0C C7 41 14 00 00 00 00 E9 74 02 00 00 EB 3A 83 7D DC 00 75 19 E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 45 D8 FF FF FF FF E9 55 02 00 00 EB 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 D8 FF FF FF FF E9 38 02 00 00 33 D2 8B 45 0C 66 89 50 06 33 C9 8B 55 0C 66 89 4A 0C 33 C0 8B 4D 0C 66 89 41 0A 33 D2 8B 45 0C 66 89 50 04 B9 01 00 00 00 8B 55 0C 66 89 4A 08 8D 45 A4 50 8B 4D 08 C1 F9 05 8B 55 08 83 E2 1F C1 E2 06 8B 04 8D ?? ?? ?? ?? 8B 0C 10 51 FF 15 ?? ?? ?? ?? 85 C0 75 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 D8 FF FF FF FF E9 C5 01 00 00 8B 55 A4 83 E2 01 74 16 8B 45 0C 0F B7 48 06 81 C9 24 01 00 00 8B 55 0C 66 89 4A 06 EB 14 8B 45 0C 0F B7 48 06 81 C9 B6 01 00 00 8B 55 0C 66 89 4A 06 83 7D B8 00 75 06 83 7D BC 00 74 60 8D 45 E0 50 8D 4D B8 51 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 55 94 52 8D 45 E0 50 FF 15 ?? ?? ?? ?? 85 C0 75 0C C7 45 D8 FF FF FF FF E9 57 01 00 00 6A FF 0F B7 4D A0 51 0F B7 55 9E 52 0F B7 45 9C 50 0F B7 4D 9A 51 0F B7 55 96 52 0F B7 45 94 50 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 1C EB 0A 8B 55 0C C7 42 1C 00 00 00 00 83 7D B0 00 75 06 83 7D B4 00 74 60 8D 45 E0 50 8D 4D B0 51 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 55 94 52 8D 45 E0 50 FF 15 ?? ?? ?? ?? 85 C0 75 0C C7 45 D8 FF FF FF FF E9 E1 00 00 00 6A FF 0F B7 4D A0 51 0F B7 55 9E 52 0F B7 45 9C 50 0F B7 4D 9A 51 0F B7 55 96 52 0F B7 45 94 50 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 18 EB 0C 8B 55 0C 8B 45 0C 8B 48 1C 89 4A 18 83 7D A8 00 75 06 83 7D AC 00 74 5D 8D 55 E0 52 8D 45 A8 50 FF 15 ?? ?? ?? ?? 85 C0 74 12 8D 4D 94 51 8D 55 E0 52 FF 15 ?? ?? ?? ?? 85 C0 75 09 C7 45 D8 FF FF FF FF EB 6C 6A FF 0F B7 45 A0 50 0F B7 4D 9E 51 0F B7 55 9C 52 0F B7 45 9A 50 0F B7 4D 96 51 0F B7 55 94 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 20 EB 0C 8B 55 0C 8B 45 0C 8B 48 1C 89 4A 20 8B 55 0C 8B 45 C8 89 42 14 8B 4D 0C 0F B7 51 06 81 CA 00 80 00 00 8B 45 0C 66 89 50 06 8B 4D 0C C7 01 00 00 00 00 8B 55 0C C7 42 10 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D8 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "_strncat"
		size = 309
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 0F 84 B7 00 00 00 8B 7C 24 08 56 F7 C7 03 00 00 00 53 74 11 8A 07 83 C7 01 84 C0 74 39 F7 C7 03 00 00 00 75 EF 8B 07 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C7 04 A9 00 01 01 81 74 E8 8B 47 FC 84 C0 74 21 84 E4 74 18 A9 00 00 FF 00 74 0C A9 00 00 00 FF 75 CF 83 EF 01 EB 0D 83 EF 02 EB 08 83 EF 03 EB 03 83 EF 04 8B 74 24 14 F7 C6 03 00 00 00 75 09 8B D9 C1 E9 02 75 5C EB 22 8A 16 83 C6 01 84 D2 74 3D 88 17 83 C7 01 83 E9 01 74 29 F7 C6 03 00 00 00 75 E5 8B D9 C1 E9 02 75 38 8B CB 83 E1 03 74 13 8A 16 83 C6 01 88 17 83 C7 01 84 D2 74 07 83 E9 01 75 ED 88 0F 5B 5E 8B 44 24 08 5F C3 88 17 8B 44 24 10 5B 5E 5F C3 89 17 83 C7 04 83 E9 01 74 C8 BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DC 84 D2 74 CE 84 F6 74 2A F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 75 C4 89 17 8B 44 24 10 5B 5E 5F C3 66 89 17 33 D2 8B 44 24 10 88 57 02 5B 5E 5F C3 66 89 17 8B 44 24 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "__cintrindisp2"
		size = 62
		refs = "0014 __matherr_flag 001c __trandisp2"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 9B D9 BD 5C FF FF FF 9B 83 3D ?? ?? ?? ?? 00 74 14 E8 ?? ?? ?? ?? 80 8D 38 FD FF FF 03 E8 9E 00 00 00 5B C9 C3 D9 C9 DD 95 7A FF FF FF D9 C9 DD 55 82 EB DD }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "__cintrindisp1"
		size = 61
		refs = "0013 __matherr_flag 001b __trandisp1"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 9B D9 BD 5C FF FF FF 83 3D ?? ?? ?? ?? 00 74 1B E8 ?? ?? ?? ?? 80 8D 38 FD FF FF 01 80 A5 38 FD FF FF FD E8 5A 00 00 00 5B C9 C3 DD 95 7A FF FF FF EB DD }
	condition:
		$1
}

rule file_180_2_0 {
	meta:
		name = "__ctrandisp2"
		size = 406
		refs = "003c __trandisp2 0051 ___fastflag 00e6 IeeeAdjU 00f6 DblMin 0102 _zero 0114 IeeeAdjO 0124 DblMax 0130 _infinity 0185 __87except"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 FF 75 0C FF 75 08 E8 B4 01 00 00 83 C4 08 FF 75 14 FF 75 10 E8 A6 01 00 00 83 C4 08 9B D9 BD 5C FF FF FF 80 8D 38 FD FF FF 02 C6 85 71 FF FF FF 01 E8 ?? ?? ?? ?? E8 03 00 00 00 5B C9 C3 80 A5 38 FD FF FF FE 83 3D ?? ?? ?? ?? 00 75 4F DD 95 30 FD FF FF 8A 85 70 FF FF FF 0A C0 74 1A 3C FF 74 5B 3C FE 74 3F 0A C0 74 33 0F BE C0 89 85 72 FF FF FF E9 B2 00 00 00 66 8B 85 5C FF FF FF 66 83 E0 20 75 18 9B DF E0 66 83 E0 20 74 0F C7 85 72 FF FF FF 08 00 00 00 E9 8D 00 00 00 D9 AD 5C FF FF FF 9B C3 66 8B 85 36 FD FF FF 66 25 F0 7F 66 0B C0 74 1B 66 3D F0 7F 74 43 EB BB 66 8B 85 36 FD FF FF 66 25 F0 7F 66 3D F0 7F 74 30 EB A8 C7 85 72 FF FF FF 04 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 73 34 DC 0D ?? ?? ?? ?? EB 2C C7 85 72 FF FF FF 03 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 76 06 DC 0D ?? ?? ?? ?? 56 57 8B 9D 6C FF FF FF 43 89 9D 76 FF FF FF F6 85 38 FD FF FF 01 75 1A FC 8D 75 08 8D BD 7A FF FF FF A5 A5 80 7B 0C 01 74 08 8D 75 10 8D 7D 82 A5 A5 DD 5D 8A 8D 85 72 FF FF FF 8D 9D 5C FF FF FF 53 50 8B 9D 6C FF FF FF 8A 43 0E 0F BE C0 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E DD 45 8A E9 11 FF FF FF }
	condition:
		$1
}

rule file_180_3_0 {
	meta:
		name = "__ctrandisp1"
		size = 51
		refs = "0027 __trandisp1"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 FF 75 0C FF 75 08 E8 1E 00 00 00 83 C4 08 9B D9 BD 5C FF FF FF 80 A5 38 FD FF FF FD E8 ?? ?? ?? ?? E8 82 FE FF FF 5B C9 C3 }
	condition:
		$1
}

rule file_180_4_0 {
	meta:
		name = "__fload"
		size = 60
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 66 8B 45 0E 66 8B D8 66 25 F0 7F 66 3D F0 7F 75 1E 66 81 CB FF 7F 66 89 5D FE 8B 45 0C 8B 5D 08 0F A4 D8 0B 89 45 FA 89 5D F6 DB 6D F6 EB 03 DD 45 08 5B C9 C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__initp_misc_cfltcvt_tab"
		size = 65
		refs = "0024 __cfltcvt_tab 002a __encode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 0A 73 1F 8B 4D FC 8B 14 8D ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 89 04 8D ?? ?? ?? ?? EB D2 8B E5 5D C3 }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "__mbsnbcpy_l"
		size = 602
		refs = "0016 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0043 ??_C@_1DA@DGICPMP@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 004c ??_C@_1GE@EFAKHFIO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0053 __CrtDbgReportW 0067 __errno 007b ??_C@_1BI@HCGBGHAL@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAp?$AAy?$AA_?$AAl?$AA?$AA@ 0085 __invalid_parameter 0097 ??1_LocaleUpdate@@QAE@XZ 00cc ??_C@_1DA@LIIANGMH@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0130 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 014a _strncpy"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 8B 45 08 89 45 FC 8B 4D 14 51 8D 4D EC E8 ?? ?? ?? ?? 83 7D 08 00 75 0F 83 7D 10 00 74 09 C7 45 D0 00 00 00 00 EB 07 C7 45 D0 01 00 00 00 8B 55 D0 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E0 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 E0 E9 B3 01 00 00 83 7D 0C 00 75 0F 83 7D 10 00 74 09 C7 45 CC 00 00 00 00 EB 07 C7 45 CC 01 00 00 00 8B 4D CC 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC 00 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 45 DC E9 2A 01 00 00 8D 4D EC E8 ?? ?? ?? ?? 8B 40 04 83 78 08 00 75 27 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D8 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D8 E9 F2 00 00 00 83 7D 10 00 0F 84 B6 00 00 00 8B 4D 10 83 E9 01 89 4D 10 8D 4D EC E8 ?? ?? ?? ?? 8B 50 04 8B 45 0C 0F B6 08 0F B6 54 0A 1D 83 E2 04 74 65 8B 45 08 8B 4D 0C 8A 11 88 10 8B 45 08 83 C0 01 89 45 08 8B 4D 0C 83 C1 01 89 4D 0C 83 7D 10 00 75 09 8B 55 08 C6 42 FF 00 EB 67 8B 45 10 83 E8 01 89 45 10 8B 4D 08 8B 55 0C 8A 02 88 01 8B 4D 08 0F B6 11 8B 45 08 83 C0 01 89 45 08 8B 4D 0C 83 C1 01 89 4D 0C 85 D2 75 09 8B 55 08 C6 42 FE 00 EB 2F EB 28 8B 45 08 8B 4D 0C 8A 11 88 10 8B 45 08 0F B6 08 8B 55 08 83 C2 01 89 55 08 8B 45 0C 83 C0 01 89 45 0C 85 C9 75 02 EB 05 E9 40 FF FF FF 8B 4D 10 8B 55 10 83 EA 01 89 55 10 85 C9 74 11 8B 45 08 C6 00 00 8B 4D 08 83 C1 01 89 4D 08 EB DF 8B 55 FC 89 55 D4 8D 4D EC E8 ?? ?? ?? ?? 8B 45 D4 8B E5 5D C3 }
	condition:
		$1
}

rule file_182_4_0 {
	meta:
		name = "__mbsnbcpy"
		size = 29
		refs = "0014 __mbsnbcpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_14_1_1 {
	meta:
		name = "__Stoll"
		size = 29
		refs = "0014 __Stollx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_76_1_1 {
	meta:
		name = "__Stoul"
		size = 29
		refs = "0014 __Stoulx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_0_1_1 {
	meta:
		name = "__Stoull"
		size = 29
		refs = "0014 __Stoullx"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_387_2_0 {
	meta:
		name = "__aligned_realloc_base"
		size = 29
		refs = "0014 __aligned_offset_realloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_388_9_0 {
	meta:
		name = "__fassign"
		size = 29
		refs = "0014 __fassign_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_602_0_0 {
	meta:
		name = "__mbscat_s"
		size = 29
		refs = "0014 __mbscat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_740_0_0 {
	meta:
		name = "__mbscpy_s"
		size = 29
		refs = "0014 __mbscpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_451_4_0 {
	meta:
		name = "__mbsnbcat"
		size = 29
		refs = "0014 __mbsnbcat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_604_4_0 {
	meta:
		name = "__mbsnbcmp"
		size = 29
		refs = "0014 __mbsnbcmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_257_4_0 {
	meta:
		name = "__mbsnbcoll"
		size = 29
		refs = "0014 __mbsnbcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_420_4_0 {
	meta:
		name = "__mbsnbicmp"
		size = 29
		refs = "0014 __mbsnbicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_835_4_0 {
	meta:
		name = "__mbsnbicoll"
		size = 29
		refs = "0014 __mbsnbicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_699_4_0 {
	meta:
		name = "__mbsnbset"
		size = 29
		refs = "0014 __mbsnbset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_908_4_0 {
	meta:
		name = "__mbsncat"
		size = 29
		refs = "0014 __mbsncat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_753_4_0 {
	meta:
		name = "__mbsncmp"
		size = 29
		refs = "0014 __mbsncmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_518_4_0 {
	meta:
		name = "__mbsncoll"
		size = 29
		refs = "0014 __mbsncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_762_4_0 {
	meta:
		name = "__mbsncpy"
		size = 29
		refs = "0014 __mbsncpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_421_4_0 {
	meta:
		name = "__mbsnicmp"
		size = 29
		refs = "0014 __mbsnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_922_4_0 {
	meta:
		name = "__mbsnicoll"
		size = 29
		refs = "0014 __mbsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_884_4_0 {
	meta:
		name = "__mbsnset"
		size = 29
		refs = "0014 __mbsnset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_797_0_0 {
	meta:
		name = "__mbsset_s"
		size = 29
		refs = "0014 __mbsset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_891_4_0 {
	meta:
		name = "__mbstok_s"
		size = 29
		refs = "0014 __mbstok_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "__spawnvp"
		size = 29
		refs = "0014 __spawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_574_0_0 {
	meta:
		name = "__wspawnvp"
		size = 29
		refs = "0014 __wspawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_915_4_0 {
	meta:
		name = "_mbtowc"
		size = 29
		refs = "0014 __mbtowc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_429_4_0 {
	meta:
		name = "_strxfrm"
		size = 29
		refs = "0014 __strxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_200_6_0 {
	meta:
		name = "_wcstombs"
		size = 29
		refs = "0014 __wcstombs_l_helper"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_264_4_0 {
	meta:
		name = "_wcsxfrm"
		size = 29
		refs = "0014 __wcsxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__free_base"
		size = 289
		refs = "0008 __sehtable$__free_base 000d __except_handler4 001f ___security_cookie 0046 ___active_heap 0054 __lock 0067 ___sbh_find_block 0080 ___sbh_free_block 0098 __unlock 00ae __crtheap 00b5 __imp__HeapFree@12 00c4 __imp__GetLastError@0 00ca __get_errno_from_oserr 00d4 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 83 7D 08 00 75 05 E9 CB 00 00 00 83 3D ?? ?? ?? ?? 03 0F 85 8B 00 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 E0 83 7D E0 00 74 10 8B 4D 08 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 83 7D E0 00 75 34 8B 45 08 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 18 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 89 30 EB 33 8B 55 08 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 18 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 89 30 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_184_3_0 {
	meta:
		name = "__vcprintf_p_l"
		size = 14384
		refs = "000c ___security_cookie 0069 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00ea ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00f6 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00fd __CrtDbgReportW 0114 __errno 012b ??_C@_1BM@OKHEMPJL@?$AA_?$AAv?$AAc?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAp?$AA_?$AAl?$AA?$AA@ 0135 __invalid_parameter 014d ??1_LocaleUpdate@@QAE@XZ 0277 ___lookuptable_s 02ef _strtol 0320 _memset 03cd ??_C@_1JC@PFJNKEIO@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN?$AA?$DN@ 04b5 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 0549 $LN379 0587 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0595 __isleadbyte_l 05b4 _write_char 05e5 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 06f2 $LN375 06f9 $LN380 0776 _get_int_arg 080b ??_C@_1JE@NMBHOLFI@?$AA?$CI?$AA?$CI?$AAw?$AAi?$AAd?$AAt?$AAh?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN@ 092c __validate_param_reuseA 0942 ??_C@_1II@PIPIMLPF@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0aef ??_C@_1JG@JBJBOCFB@?$AA?$CI?$AA?$CI?$AAp?$AAr?$AAe?$AAc?$AAi?$AAs?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5@ 0c26 ??_C@_1IK@EIEPDKHJ@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0d30 $LN376 0d37 $LN381 0ea2 $LN377 0ea9 $LN382 0ef6 _get_short_arg 0f47 ??_C@_1EM@BNPHBBIA@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DO?$AA?$DN?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DM?$AA_?$AAA?$AAR?$AAG@ 1057 ??_C@_1IK@MHEDJAMK@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 1118 _wctomb_s 12ac ??_C@_1IG@FDCPLALG@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 14e6 ??_C@_1IG@HJIMKDHC@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 15a0 ___nullstring 15b2 _strlen 18a3 ___wnullstring 1b92 __get_printf_count_output 1bce ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 1e03 ??_C@_1IM@DNGHAPLB@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 1eee ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 1f01 __malloc_dbg 2027 ??_C@_1DG@GOHGNKHE@?$AAp?$AAa?$AAs?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAF?$AAO?$AAR?$AAM?$AAA?$AAT?$AA_?$AAO?$AAU?$AAT?$AAP?$AAU?$AAT?$AA_?$AAP?$AAA?$AAS?$AAS?$AA?$AA@ 20bd __cfltcvt_tab 20c3 __decode_pointer 2265 _get_int64_arg 23cb ??_C@_1IK@NBGDDCBN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 2600 ??_C@_1JC@OACKELNN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 30b6 __aullrem 30db __aulldiv 3253 _write_multi_char 3270 _write_string 33e1 __free_dbg 3435 ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 3529 $LN383 361d _get_crtdouble_arg 3665 ??_C@_1FK@BCPANIEK@?$AA?$CI?$AA?$CC?$AAM?$AAi?$AAs?$AAs?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt@ 3704 @__security_check_cookie@4 370c $LN265 3710 $LN259 3714 $LN258 3718 $LN250 371c $LN238 3720 $LN237 3724 $LN225 3728 $LN209 372c $LN253 3730 $LN252 3734 $LN254 3738 $LN255 373c $LN251 3740 $LN256 3758 $LN219 375c $LN211 3760 $LN222 3764 $LN210 3768 $LN223 379c $LN138 37a0 $LN206 37a4 $LN170 37a8 $LN112 37ac $LN184 37b0 $LN137 37b4 $LN204 37b8 $LN117 37bc $LN151 37c0 $LN107 37c4 $LN113 37c8 $LN168 37cc $LN115 37d0 $LN110 37d4 $LN207 3810 $LN9 3814 $LN8 3818 $LN7 381c $LN6 3820 $LN5 3824 $LN4 3828 $LN2 382c $LN3"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC FC 0A 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 58 F9 FF FF C7 85 3C F7 FF FF 00 00 00 00 C7 85 A4 F9 FF FF 00 00 00 00 C7 85 98 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF 00 00 00 00 C7 85 90 F9 FF FF 00 00 00 00 C7 85 78 F9 FF FF 00 00 00 00 C7 85 A8 F9 FF FF 00 00 00 00 8B 45 0C 50 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? C7 85 94 F9 FF FF 00 00 00 00 C7 85 80 F9 FF FF 00 00 00 00 C7 85 48 F7 FF FF 00 00 00 00 C7 85 AC F9 FF FF 00 00 00 00 C7 85 84 F9 FF FF FF FF FF FF C7 85 A0 F9 FF FF FF FF FF FF C7 85 B0 F9 FF FF FF FF FF FF C7 85 7C F9 FF FF FF FF FF FF C7 85 B4 F9 FF FF FF FF FF FF C7 85 8C F9 FF FF 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 38 F7 FF FF 83 BD 38 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 38 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 18 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 18 F6 FF FF E9 9F 35 00 00 C7 85 54 F7 FF FF 00 00 00 00 8B 45 08 89 85 94 F9 FF FF C7 85 48 F7 FF FF 00 00 00 00 EB 0F 8B 8D 48 F7 FF FF 83 C1 01 89 8D 48 F7 FF FF 83 BD 48 F7 FF FF 02 0F 8D 47 35 00 00 83 BD 48 F7 FF FF 01 75 0E 83 BD B4 F9 FF FF 00 75 05 E9 30 35 00 00 C7 85 88 F9 FF FF 00 00 00 00 C7 85 40 F7 FF FF 00 00 00 00 C7 85 8C F9 FF FF 00 00 00 00 C7 85 5C F9 FF FF 00 00 00 00 C7 85 84 F9 FF FF FF FF FF FF C7 85 98 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF 00 00 00 00 8B 95 94 F9 FF FF 89 55 08 C7 85 A0 F9 FF FF FF FF FF FF C7 85 B0 F9 FF FF FF FF FF FF C7 85 7C F9 FF FF FF FF FF FF C7 85 B4 F9 FF FF FF FF FF FF 8B 45 08 8A 08 88 8D 4F F7 FF FF 0F BE 95 4F F7 FF FF 8B 45 08 83 C0 01 89 45 08 85 D2 0F 84 AF 31 00 00 83 BD 54 F7 FF FF 00 0F 8C A2 31 00 00 0F BE 8D 4F F7 FF FF 83 F9 20 7C 25 0F BE 95 4F F7 FF FF 83 FA 78 7F 19 0F BE 85 4F F7 FF FF 0F B6 88 ?? ?? ?? ?? 83 E1 0F 89 8D 7C F5 FF FF EB 0A C7 85 7C F5 FF FF 00 00 00 00 8B 95 7C F5 FF FF 89 95 50 F7 FF FF 8B 85 50 F7 FF FF 6B C0 09 8B 8D 40 F7 FF FF 0F B6 94 08 ?? ?? ?? ?? C1 FA 04 89 95 40 F7 FF FF 83 BD 40 F7 FF FF 01 0F 85 AF 01 00 00 8B 45 08 0F BE 08 83 F9 25 0F 84 A0 01 00 00 83 BD B4 F9 FF FF FF 75 5C 6A 0A 8D 95 80 F9 FF FF 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 7E 39 8B 8D 80 F9 FF FF 0F BE 11 83 FA 24 75 2B 83 BD 48 F7 FF FF 00 75 16 68 40 06 00 00 6A 00 8D 85 C0 F9 FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C7 85 B4 F9 FF FF 01 00 00 00 EB 0A C7 85 B4 F9 FF FF 00 00 00 00 83 BD B4 F9 FF FF 01 0F 85 29 01 00 00 6A 0A 8D 8D 80 F9 FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 A0 F9 FF FF 8B 85 80 F9 FF FF 83 C0 01 89 45 08 83 BD 48 F7 FF FF 00 0F 85 F2 00 00 00 83 BD A0 F9 FF FF 00 7C 23 8B 8D 80 F9 FF FF 0F BE 11 83 FA 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 78 F5 FF FF 01 00 00 00 EB 0A C7 85 78 F5 FF FF 00 00 00 00 8B 85 78 F5 FF FF 89 85 34 F7 FF FF 83 BD 34 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 50 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 34 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 50 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 14 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 14 F6 FF FF E9 BC 32 00 00 8B 95 A0 F9 FF FF 3B 95 84 F9 FF FF 7E 0E 8B 85 A0 F9 FF FF 89 85 74 F5 FF FF EB 0C 8B 8D 84 F9 FF FF 89 8D 74 F5 FF FF 8B 95 74 F5 FF FF 89 95 84 F9 FF FF E9 AF 00 00 00 83 BD 40 F7 FF FF 08 0F 85 A2 00 00 00 33 C0 74 0C C7 85 70 F5 FF FF 01 00 00 00 EB 0A C7 85 70 F5 FF FF 00 00 00 00 8B 8D 70 F5 FF FF 89 8D 30 F7 FF FF 83 BD 30 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 5C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 30 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 5C 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 10 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 10 F6 FF FF E9 D4 31 00 00 8B 85 40 F7 FF FF 89 85 6C F5 FF FF 83 BD 6C F5 FF FF 07 0F 87 B2 2E 00 00 8B 8D 6C F5 FF FF FF 24 8D ?? ?? ?? ?? 83 BD 48 F7 FF FF 00 75 09 83 BD B4 F9 FF FF 01 74 12 83 BD 48 F7 FF FF 01 75 0E 83 BD B4 F9 FF FF FF 75 05 E9 7C 2E 00 00 C7 85 A8 F9 FF FF 00 00 00 00 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 50 0F B6 95 4F F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B3 00 00 00 8D 85 54 F7 FF FF 50 0F B6 8D 4F F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8A 02 88 85 4F F7 FF FF 8B 4D 08 83 C1 01 89 4D 08 0F BE 95 4F F7 FF FF F7 DA 1B D2 F7 DA 89 95 2C F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 2C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 0C F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 0C F6 FF FF E9 A4 30 00 00 8D 8D 54 F7 FF FF 51 0F B6 95 4F F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 E9 7F 2D 00 00 C7 85 74 F9 FF FF 00 00 00 00 8B 85 74 F9 FF FF 89 85 78 F9 FF FF 8B 8D 78 F9 FF FF 89 8D 98 F9 FF FF 8B 95 98 F9 FF FF 89 95 90 F9 FF FF C7 85 A4 F9 FF FF 00 00 00 00 C7 85 70 F9 FF FF FF FF FF FF C7 85 A8 F9 FF FF 00 00 00 00 E9 2E 2D 00 00 0F BE 85 4F F7 FF FF 89 85 68 F5 FF FF 8B 8D 68 F5 FF FF 83 E9 20 89 8D 68 F5 FF FF 83 BD 68 F5 FF FF 10 77 6A 8B 95 68 F5 FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 8D A4 F9 FF FF 83 C9 04 89 8D A4 F9 FF FF EB 45 8B 95 A4 F9 FF FF 83 CA 01 89 95 A4 F9 FF FF EB 34 8B 85 A4 F9 FF FF 83 C8 02 89 85 A4 F9 FF FF EB 23 8B 8D A4 F9 FF FF 81 C9 80 00 00 00 89 8D A4 F9 FF FF EB 0F 8B 95 A4 F9 FF FF 83 CA 08 89 95 A4 F9 FF FF E9 9A 2C 00 00 0F BE 85 4F F7 FF FF 83 F8 2A 0F 85 A6 02 00 00 83 BD B4 F9 FF FF 00 75 17 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 98 F9 FF FF E9 5E 02 00 00 6A 0A 8D 95 80 F9 FF FF 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 B0 F9 FF FF 8B 8D 80 F9 FF FF 83 C1 01 89 4D 08 83 BD 48 F7 FF FF 00 0F 85 FC 01 00 00 83 BD B0 F9 FF FF 00 7C 23 8B 95 80 F9 FF FF 0F BE 02 83 F8 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 64 F5 FF FF 01 00 00 00 EB 0A C7 85 64 F5 FF FF 00 00 00 00 8B 8D 64 F5 FF FF 89 8D 28 F7 FF FF 83 BD 28 F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BB 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 28 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 BB 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 08 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 08 F6 FF FF E9 7E 2E 00 00 8B 85 B0 F9 FF FF 3B 85 84 F9 FF FF 7E 0E 8B 8D B0 F9 FF FF 89 8D 60 F5 FF FF EB 0C 8B 95 84 F9 FF FF 89 95 60 F5 FF FF 8B 85 60 F5 FF FF 89 85 84 F9 FF FF 8B 8D B0 F9 FF FF C1 E1 04 83 BC 0D C0 F9 FF FF 00 75 45 8B 95 B0 F9 FF FF C1 E2 04 C7 84 15 C0 F9 FF FF 01 00 00 00 8B 85 B0 F9 FF FF C1 E0 04 8A 8D 4F F7 FF FF 88 8C 05 C8 F9 FF FF 8B 95 B0 F9 FF FF C1 E2 04 8B 85 A4 F9 FF FF 89 84 15 CC F9 FF FF E9 AB 00 00 00 8B 8D A4 F9 FF FF 51 0F B6 95 4F F7 FF FF 52 6A 01 8B 85 B0 F9 FF FF C1 E0 04 8D 8C 05 C0 F9 FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 24 F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 C0 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 24 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C0 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 04 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 04 F6 FF FF E9 47 2D 00 00 E9 39 2A 00 00 EB 2B 8B 85 B0 F9 FF FF C1 E0 04 8B 8C 05 C4 F9 FF FF 89 8D 20 F7 FF FF 8D 95 20 F7 FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 98 F9 FF FF 83 BD 98 F9 FF FF 00 7D 1D 8B 85 A4 F9 FF FF 83 C8 04 89 85 A4 F9 FF FF 8B 8D 98 F9 FF FF F7 D9 89 8D 98 F9 FF FF EB 1A 8B 95 98 F9 FF FF 6B D2 0A 0F BE 85 4F F7 FF FF 8D 4C 02 D0 89 8D 98 F9 FF FF E9 C5 29 00 00 C7 85 70 F9 FF FF 00 00 00 00 E9 B6 29 00 00 0F BE 95 4F F7 FF FF 83 FA 2A 0F 85 93 02 00 00 83 BD B4 F9 FF FF 00 75 17 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 70 F9 FF FF E9 5E 02 00 00 6A 0A 8D 8D 80 F9 FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 83 E8 01 89 85 7C F9 FF FF 8B 85 80 F9 FF FF 83 C0 01 89 45 08 83 BD 48 F7 FF FF 00 0F 85 FC 01 00 00 83 BD 7C F9 FF FF 00 7C 23 8B 8D 80 F9 FF FF 0F BE 11 83 FA 24 75 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 5C F5 FF FF 01 00 00 00 EB 0A C7 85 5C F5 FF FF 00 00 00 00 8B 85 5C F5 FF FF 89 85 1C F7 FF FF 83 BD 1C F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F0 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 1C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F0 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 00 F6 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 00 F6 FF FF E9 9A 2B 00 00 8B 95 7C F9 FF FF 3B 95 84 F9 FF FF 7E 0E 8B 85 7C F9 FF FF 89 85 58 F5 FF FF EB 0C 8B 8D 84 F9 FF FF 89 8D 58 F5 FF FF 8B 95 58 F5 FF FF 89 95 84 F9 FF FF 8B 85 7C F9 FF FF C1 E0 04 83 BC 05 C0 F9 FF FF 00 75 45 8B 8D 7C F9 FF FF C1 E1 04 C7 84 0D C0 F9 FF FF 01 00 00 00 8B 95 7C F9 FF FF C1 E2 04 8A 85 4F F7 FF FF 88 84 15 C8 F9 FF FF 8B 8D 7C F9 FF FF C1 E1 04 8B 95 A4 F9 FF FF 89 94 0D CC F9 FF FF E9 AB 00 00 00 8B 85 A4 F9 FF FF 50 0F B6 8D 4F F7 FF FF 51 6A 01 8B 95 7C F9 FF FF C1 E2 04 8D 84 15 C0 F9 FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 F7 D8 1B C0 F7 D8 89 85 18 F7 FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 F5 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 18 F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F5 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 FC F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 FC F5 FF FF E9 63 2A 00 00 E9 55 27 00 00 EB 2B 8B 95 7C F9 FF FF C1 E2 04 8B 84 15 C4 F9 FF FF 89 85 14 F7 FF FF 8D 8D 14 F7 FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 70 F9 FF FF 83 BD 70 F9 FF FF 00 7D 0A C7 85 70 F9 FF FF FF FF FF FF EB 1A 8B 95 70 F9 FF FF 6B D2 0A 0F BE 85 4F F7 FF FF 8D 4C 02 D0 89 8D 70 F9 FF FF E9 F4 26 00 00 0F BE 95 4F F7 FF FF 89 95 54 F5 FF FF 8B 85 54 F5 FF FF 83 E8 49 89 85 54 F5 FF FF 83 BD 54 F5 FF FF 2E 0F 87 44 01 00 00 8B 8D 54 F5 FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 08 0F BE 08 83 F9 6C 75 1C 8B 55 08 83 C2 01 89 55 08 8B 85 A4 F9 FF FF 0D 00 10 00 00 89 85 A4 F9 FF FF EB 0F 8B 8D A4 F9 FF FF 83 C9 10 89 8D A4 F9 FF FF E9 F5 00 00 00 8B 55 08 0F BE 02 83 F8 36 75 2C 8B 4D 08 0F BE 51 01 83 FA 34 75 20 8B 45 08 83 C0 02 89 45 08 8B 8D A4 F9 FF FF 81 C9 00 80 00 00 89 8D A4 F9 FF FF E9 99 00 00 00 8B 55 08 0F BE 02 83 F8 33 75 29 8B 4D 08 0F BE 51 01 83 FA 32 75 1D 8B 45 08 83 C0 02 89 45 08 8B 8D A4 F9 FF FF 81 E1 FF 7F FF FF 89 8D A4 F9 FF FF EB 65 8B 55 08 0F BE 02 83 F8 64 74 37 8B 4D 08 0F BE 11 83 FA 69 74 2C 8B 45 08 0F BE 08 83 F9 6F 74 21 8B 55 08 0F BE 02 83 F8 75 74 16 8B 4D 08 0F BE 11 83 FA 78 74 0B 8B 45 08 0F BE 08 83 F9 58 75 14 8B 95 A4 F9 FF FF 81 CA 00 00 01 00 89 95 A4 F9 FF FF EB 0F C7 85 40 F7 FF FF 00 00 00 00 E9 30 F7 FF FF EB 23 8B 85 A4 F9 FF FF 83 C8 20 89 85 A4 F9 FF FF EB 12 8B 8D A4 F9 FF FF 81 C9 00 08 00 00 89 8D A4 F9 FF FF E9 82 25 00 00 0F BE 95 4F F7 FF FF 89 95 50 F5 FF FF 8B 85 50 F5 FF FF 83 E8 41 89 85 50 F5 FF FF 83 BD 50 F5 FF FF 37 0F 87 FC 22 00 00 8B 8D 50 F5 FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 85 A4 F9 FF FF 25 30 08 00 00 75 12 8B 8D A4 F9 FF FF 81 C9 00 08 00 00 89 8D A4 F9 FF FF 8B 95 A4 F9 FF FF 81 E2 10 08 00 00 0F 84 5F 02 00 00 C7 85 10 F7 FF FF 00 00 00 00 83 BD B4 F9 FF FF 00 75 18 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 44 F7 FF FF E9 F3 01 00 00 83 BD A0 F9 FF FF 00 7C 15 83 BD A0 F9 FF FF 64 7D 0C C7 85 4C F5 FF FF 01 00 00 00 EB 0A C7 85 4C F5 FF FF 00 00 00 00 8B 8D 4C F5 FF FF 89 8D 0C F7 FF FF 83 BD 0C F7 FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A8 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 0C F7 FF FF 00 75 49 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A8 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 F8 F5 FF FF FF FF FF FF 8D 8D 60 F9 FF FF E8 ?? ?? ?? ?? 8B 85 F8 F5 FF FF E9 42 27 00 00 83 BD 48 F7 FF FF 00 0F 85 0A 01 00 00 8B 85 A0 F9 FF FF C1 E0 04 83 BC 05 C0 F9 FF FF 00 75 45 8B 8D A0 F9 FF FF C1 E1 04 C7 84 0D C0 F9 FF FF 02 00 00 00 8B 95 A0 F9 FF FF C1 E2 04 8A 85 4F F7 FF FF 88 84 15 C8 }
	condition:
		$1
}

rule file_184_7_0 {
	meta:
		name = "_write_char"
		size = 49
		refs = "000b __putch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 0F BE 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 75 0B 8B 4D 0C C7 01 FF FF FF FF EB 0D 8B 55 0C 8B 02 83 C0 01 8B 4D 0C 89 01 5D C3 }
	condition:
		$1
}

rule file_184_8_0 {
	meta:
		name = "_write_multi_char"
		size = 52
		refs = "001f _write_char"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 1D 8B 55 10 52 0F B6 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 10 83 39 FF 75 02 EB 02 EB D3 5D C3 }
	condition:
		$1
}

rule file_184_9_0 {
	meta:
		name = "_write_string"
		size = 98
		refs = "0028 _write_char 0041 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 8B 4D 0C 83 E9 01 89 4D 0C 85 C0 7E 48 8B 55 08 8A 02 88 45 FF 8B 4D 10 51 0F B6 55 FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 83 C0 01 89 45 08 8B 4D 10 83 39 FF 75 1C E8 ?? ?? ?? ?? 83 38 2A 75 10 8B 55 10 52 6A 3F E8 ?? ?? ?? ?? 83 C4 08 EB 02 EB 02 EB A8 8B E5 5D C3 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "__spawnvpe"
		size = 1229
		refs = "002a ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0033 ??_C@_1GE@IIDGLGJI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003a __CrtDbgReportW 004e __errno 0062 ??_C@_1BE@EGMIEFFD@?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AAp?$AAe?$AA?$AA@ 006c __invalid_parameter 008d ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00f1 ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0157 ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01bc ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0233 __spawnve 0258 __mbschr 0272 ??_C@_1OA@GDPMHNFP@?$AA_?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ@ 027d ??_C@_0DC@EBBANFEI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0284 ??_C@_04HBHDLLBA@PATH?$AA@ 028f __dupenv_s_dbg 0298 __invoke_watson_if_oneof 02ba __calloc_dbg 02e3 __getpath 030a _strlen 032d __mbsrchr 033a ??_C@_01KICIPPFI@?2?$AA@ 0348 _strcat_s 036e ??_C@_1DC@INHIHLBE@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AA?$CC?$AA?2?$AA?2?$AA?$CC?$AA?$CJ?$AA?$AA@ 038a __invoke_watson_if_error 03c7 ??_C@_1DK@DFMMGMNL@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?$AA@ 04aa __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 56 C7 45 E8 00 00 00 00 C7 45 F4 00 00 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 4D 04 00 00 8B 55 0C 0F BE 02 F7 D8 1B C0 F7 D8 89 45 E0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 51 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 51 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EA 03 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 52 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 86 03 00 00 8B 4D 10 33 D2 83 39 00 0F 95 C2 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 20 03 00 00 8B 4D 10 8B 11 0F BE 02 F7 D8 1B C0 F7 D8 89 45 D4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BB 02 00 00 E8 ?? ?? ?? ?? 8B 10 89 55 F0 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 FF 0F 85 83 00 00 00 E8 ?? ?? ?? ?? 83 38 02 75 79 6A 2F 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 67 6A 00 6A 65 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 6A 65 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 00 8D 55 E8 52 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 27 83 7D E8 00 74 21 6A 69 68 ?? ?? ?? ?? 6A 02 6A 01 68 04 01 00 00 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 05 E9 BA 01 00 00 8B 45 E8 89 45 FC 68 03 01 00 00 8B 4D F4 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 83 7D FC 00 0F 84 92 01 00 00 8B 45 F4 0F BE 08 85 C9 0F 84 84 01 00 00 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F4 8D 54 01 FF 89 55 EC 8B 45 EC 0F BE 08 83 F9 5C 75 2B 6A 5C 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 39 45 EC 74 16 68 ?? ?? ?? ?? 68 04 01 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C EB 40 8B 4D EC 0F BE 11 83 FA 2F 74 35 6A 00 68 8A 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 01 00 00 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 03 F0 81 FE 04 01 00 00 73 36 6A 00 68 94 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 0C 50 68 04 01 00 00 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 05 E9 99 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 55 14 52 8B 45 10 50 8B 4D F4 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 F8 83 7D F8 FF 75 66 E8 ?? ?? ?? ?? 83 38 02 74 5E 6A 5C 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 39 45 F4 74 13 6A 2F 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 39 45 F4 75 36 8B 75 F4 83 C6 01 6A 5C 8B 55 F4 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 08 3B F0 74 1D 8B 75 F4 83 C6 01 6A 2F 8B 45 F4 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 08 3B F0 74 02 EB 05 E9 4C FE FF FF E8 ?? ?? ?? ?? 83 38 00 75 0A E8 ?? ?? ?? ?? 8B 4D F0 89 08 83 7D F4 00 74 0E 6A 02 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 83 7D E8 00 74 0E 6A 02 8B 45 E8 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_185_2_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 65
		refs = "0035 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 10 8B 45 08 3B 45 0C 74 0D 8B 4D 08 3B 4D 10 74 05 8B 45 08 EB 1F 8B 55 24 52 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__allrem"
		size = 178
	strings:
		$1 = { 53 57 33 FF 8B 44 24 10 0B C0 7D 14 47 8B 54 24 0C F7 D8 F7 DA 83 D8 00 89 44 24 10 89 54 24 0C 8B 44 24 18 0B C0 7D 13 8B 54 24 14 F7 D8 F7 DA 83 D8 00 89 44 24 18 89 54 24 14 0B C0 75 1B 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B 44 24 0C F7 F1 8B C2 33 D2 4F 79 4E EB 53 8B D8 8B 4C 24 14 8B 54 24 10 8B 44 24 0C D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B C8 F7 64 24 18 91 F7 64 24 14 03 D1 72 0E 3B 54 24 10 77 08 72 0E 3B 44 24 0C 76 08 2B 44 24 14 1B 54 24 18 2B 44 24 0C 1B 54 24 10 4F 79 07 F7 DA F7 D8 83 DA 00 5F 5B C2 10 00 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__Getdays_l"
		size = 438
		refs = "0018 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0020 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0052 _strlen 007d ??_C@_0DC@MEPJBKMO@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 008b __malloc_dbg 00d8 ??_C@_1GE@FCOIONJG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00dd ??_C@_1BG@LGACIFJI@?$AA_?$AAG?$AAe?$AAt?$AAd?$AAa?$AAy?$AAs?$AA_?$AAl?$AA?$AA@ 00e2 ??_C@_1GG@NAGHPCAA@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0@ 0104 _strcpy_s 010d __invoke_watson_if_error 0147 ??_C@_1FM@LPEPDBJF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0@ 01aa ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 56 C7 45 F0 00 00 00 00 8B 45 08 50 8D 4D E0 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 8B 91 D4 00 00 00 89 55 F4 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 07 73 33 8B 4D F8 8B 55 F4 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D F8 8B 55 F4 8B 44 8A 1C 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 F0 8D 4C 30 02 89 4D F0 EB BE 6A 7A 68 ?? ?? ?? ?? 6A 02 8B 55 F0 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 0F 84 01 01 00 00 8B 45 FC 89 45 DC C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 83 7D F8 07 0F 83 D0 00 00 00 8B 55 DC C6 02 3A 8B 45 DC 83 C0 01 89 45 DC 6A 00 68 81 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F8 8B 55 F4 8B 04 8A 50 8B 4D F0 83 C1 01 8B 55 DC 2B 55 FC 2B CA 51 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 03 45 DC 89 45 DC 8B 55 DC C6 02 3A 8B 45 DC 83 C0 01 89 45 DC 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F8 8B 55 F4 8B 44 8A 1C 50 8B 4D F0 83 C1 01 8B 55 DC 2B 55 FC 2B CA 51 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 03 45 DC 89 45 DC E9 1D FF FF FF 8B 55 DC C6 02 00 8B 45 DC 83 C0 01 89 45 DC 8B 4D FC 89 4D D8 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 D8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_5_0 {
	meta:
		name = "__Getdays"
		size = 17
		refs = "0008 __Getdays_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_74_2_1 {
	meta:
		name = "?set_new_handler@std@@YAP6AXXZH@Z"
		size = 17
		refs = "0008 ?set_new_handler@std@@YAP6AXXZP6AXXZ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_187_7_0 {
	meta:
		name = "__Getmonths"
		size = 17
		refs = "0008 __Getmonths_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_187_9_0 {
	meta:
		name = "__Gettnames"
		size = 17
		refs = "0008 __Gettnames_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_756_2_0 {
	meta:
		name = "__encoded_null"
		size = 17
		refs = "0008 __encode_pointer"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_187_6_0 {
	meta:
		name = "__Getmonths_l"
		size = 443
		refs = "0018 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0020 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0053 _strlen 0081 ??_C@_0DC@MEPJBKMO@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 008f __malloc_dbg 00dc ??_C@_1GE@FCOIONJG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00e1 ??_C@_1BK@IDMELNCB@?$AA_?$AAG?$AAe?$AAt?$AAm?$AAo?$AAn?$AAt?$AAh?$AAs?$AA_?$AAl?$AA?$AA@ 00e6 ??_C@_1GI@LNJDDNLK@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0@ 0109 _strcpy_s 0112 __invoke_watson_if_error 014c ??_C@_1FO@IFFKPIEL@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0@ 01af ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 56 C7 45 F0 00 00 00 00 8B 45 08 50 8D 4D E0 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 8B 91 D4 00 00 00 89 55 F4 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 0C 73 34 8B 4D F8 8B 55 F4 8B 44 8A 38 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D F8 8B 55 F4 8B 44 8A 68 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 F0 8D 4C 30 02 89 4D F0 EB BD 68 A1 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F0 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 0F 84 02 01 00 00 8B 45 FC 89 45 DC C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 83 7D F8 0C 0F 83 D1 00 00 00 8B 55 DC C6 02 3A 8B 45 DC 83 C0 01 89 45 DC 6A 00 68 A8 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F8 8B 55 F4 8B 44 8A 38 50 8B 4D F0 83 C1 01 8B 55 DC 2B 55 FC 2B CA 51 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 03 45 DC 89 45 DC 8B 55 DC C6 02 3A 8B 45 DC 83 C0 01 89 45 DC 6A 00 68 AB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F8 8B 55 F4 8B 44 8A 68 50 8B 4D F0 83 C1 01 8B 55 DC 2B 55 FC 2B CA 51 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 03 45 DC 89 45 DC E9 1C FF FF FF 8B 55 DC C6 02 00 8B 45 DC 83 C0 01 89 45 DC 8B 4D FC 89 4D D8 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 D8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_8_0 {
	meta:
		name = "__Gettnames_l"
		size = 1381
		refs = "0018 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0020 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0052 _strlen 015c ??_C@_0DC@MEPJBKMO@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0167 __malloc_dbg 019b _memcpy 01d2 ??_C@_1GE@FCOIONJG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 01d7 ??_C@_1BK@MJNHIAGO@?$AA_?$AAG?$AAe?$AAt?$AAt?$AAn?$AAa?$AAm?$AAe?$AAs?$AA_?$AAl?$AA?$AA@ 01dc ??_C@_1FK@ODMKEFLD@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAw@ 01fb _strcpy_s 0204 __invoke_watson_if_error 0240 ??_C@_1FA@EBHJJADL@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAw@ 02c6 ??_C@_1FM@CHHONFED@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAm@ 032b ??_C@_1FC@BEAPAEGE@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAm@ 0394 ??_C@_1FA@INCJEBF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAa@ 03f7 ??_C@_1FA@MEHIJEIL@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAa@ 045a ??_C@_1FI@GDNOPCGD@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAw@ 04bd ??_C@_1FI@PPIHCJGH@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAw@ 0520 ??_C@_1FG@CJBIADLJ@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AA?0?$AA?5?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAs?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5?$AAp?$AAt?$AA?9?$AA?$DO?$AAw@ 0559 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 56 C7 45 F0 00 00 00 00 8B 45 08 50 8D 4D E0 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 8B 91 D4 00 00 00 89 55 F4 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 07 73 33 8B 4D F8 8B 55 F4 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D F8 8B 55 F4 8B 44 8A 1C 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 F0 8D 4C 30 02 89 4D F0 EB BE C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 83 7D F8 0C 73 34 8B 45 F8 8B 4D F4 8B 54 81 38 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 F8 8B 4D F4 8B 54 81 68 52 E8 ?? ?? ?? ?? 83 C4 04 03 45 F0 8D 44 30 02 89 45 F0 EB BD 8B 4D F4 8B 91 98 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 F4 8B 88 9C 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 03 45 F0 8D 54 30 02 89 55 F0 8B 45 F4 8B 88 A0 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F0 8D 44 02 01 89 45 F0 8B 4D F4 8B 91 A4 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F0 8D 54 01 01 89 55 F0 8B 45 F4 8B 88 A8 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 F0 8D 44 02 01 89 45 F0 8B 4D F0 81 C1 B8 00 00 00 89 4D F0 68 CF 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 0F 84 D4 03 00 00 8B 45 FC 89 45 D8 8B 4D FC 81 C1 B8 00 00 00 89 4D DC 68 B8 00 00 00 8B 55 F4 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 83 7D F8 07 0F 83 CD 00 00 00 8B 55 F8 8B 45 D8 8B 4D DC 89 0C 90 6A 00 68 D8 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F8 8B 45 F4 8B 0C 90 51 8B 55 DC 2B 55 FC 8B 45 F0 2B C2 50 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D DC 8D 54 01 01 89 55 DC 8B 45 F8 8B 4D D8 8B 55 DC 89 54 81 1C 6A 00 68 DB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F8 8B 4D F4 8B 54 81 1C 52 8B 45 DC 2B 45 FC 8B 4D F0 2B C8 51 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D DC 8D 54 01 01 89 55 DC E9 20 FF FF FF C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 0C 0F 83 CF 00 00 00 8B 4D F8 8B 55 D8 8B 45 DC 89 44 8A 38 6A 00 68 E0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F8 8B 55 F4 8B 44 8A 38 50 8B 4D DC 2B 4D FC 8B 55 F0 2B D1 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 DC 8D 44 02 01 89 45 DC 8B 4D F8 8B 55 D8 8B 45 DC 89 44 8A 68 6A 00 68 E3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D F8 8B 55 F4 8B 44 8A 68 50 8B 4D DC 2B 4D FC 8B 55 F0 2B D1 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 DC 8D 44 02 01 89 45 DC E9 1E FF FF FF 8B 4D D8 8B 55 DC 89 91 98 00 00 00 6A 00 68 E7 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F4 8B 88 98 00 00 00 51 8B 55 DC 2B 55 FC 8B 45 F0 2B C2 50 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D DC 8D 54 01 01 89 55 DC 8B 45 D8 8B 4D DC 89 88 9C 00 00 00 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F4 8B 82 9C 00 00 00 50 8B 4D DC 2B 4D FC 8B 55 F0 2B D1 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 DC 8D 44 02 01 89 45 DC 8B 4D D8 8B 55 DC 89 91 A0 00 00 00 6A 00 68 ED 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F4 8B 88 A0 00 00 00 51 8B 55 DC 2B 55 FC 8B 45 F0 2B C2 50 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D DC 8D 54 01 01 89 55 DC 8B 45 D8 8B 4D DC 89 88 A4 00 00 00 6A 00 68 F0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 F4 8B 82 A4 00 00 00 50 8B 4D DC 2B 4D FC 8B 55 F0 2B D1 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 DC 8D 44 02 01 89 45 DC 8B 4D D8 8B 55 DC 89 91 A8 00 00 00 6A 00 68 F3 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F4 8B 88 A8 00 00 00 51 8B 55 DC 2B 55 FC 8B 45 F0 2B C2 50 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 55 FC 89 55 D4 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 D4 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_10_0 {
	meta:
		name = "__strftime_l"
		size = 37
		refs = "001c __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_690_6_0 {
	meta:
		name = "__vsnprintf_s"
		size = 37
		refs = "001c __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_513_6_0 {
	meta:
		name = "__vsnwprintf_s"
		size = 37
		refs = "001c __vsnwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_187_11_0 {
	meta:
		name = "_strftime"
		size = 35
		refs = "001a __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_254_53_0 {
	meta:
		name = "__aligned_offset_realloc"
		size = 35
		refs = "001a __aligned_offset_realloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_187_13_0 {
	meta:
		name = "__Strftime_l"
		size = 1127
		refs = "001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0034 ??_C@_1CG@MPKJHDAA@?$AA?$CI?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 0040 ??_C@_1GE@FCOIONJG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0047 __CrtDbgReportW 005b __errno 0072 ??_C@_1BI@ONBMGNNA@?$AA_?$AAS?$AAt?$AAr?$AAf?$AAt?$AAi?$AAm?$AAe?$AA_?$AAl?$AA?$AA@ 007c __invalid_parameter 008e ??1_LocaleUpdate@@QAE@XZ 00ad ??_C@_1CC@IHEJKGMG@?$AA?$CI?$AA?5?$AAm?$AAa?$AAx?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CJ?$AA?$AA@ 012c ??_C@_1CG@MHIOFJLE@?$AA?$CI?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 019c ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01fa ??_C@_1CA@COHOENPC@?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 02b0 ?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z 02ec __isleadbyte_l 030d ??_C@_1HC@JGDOBCNK@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAc?$AAh?$AAa?$AAr?$AAa?$AAc?$AAt?$AAe?$AAr?$AA?5?$AAs?$AAe?$AAq?$AAu?$AAe?$AAn?$AAc@ 03e4 ??_C@_1M@HCOOECOK@?$AAF?$AAA?$AAL?$AAS?$AAE?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 5C C7 45 F4 00 00 00 00 8B 45 08 89 45 F8 8B 4D 1C 51 8D 4D E0 E8 ?? ?? ?? ?? 33 D2 83 7D 08 00 0F 95 C2 89 55 D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 6D 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 6D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C4 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C4 E9 C9 03 00 00 33 C9 83 7D 0C 00 0F 95 C1 89 4D D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 6E 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 6E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C0 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C0 E9 50 03 00 00 8B 45 08 C6 00 00 33 C9 83 7D 10 00 0F 95 C1 89 4D D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 71 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 71 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 BC 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 BC E9 D1 02 00 00 83 7D 18 00 75 15 8D 4D E0 E8 ?? ?? ?? ?? 8B 00 8B 88 D4 00 00 00 89 4D A8 EB 06 8B 55 18 89 55 A8 8B 45 A8 89 45 DC 8B 4D 0C 89 4D F0 83 7D F0 00 0F 86 BE 01 00 00 8B 55 10 8A 02 88 45 A4 80 7D A4 00 74 0B 80 7D A4 25 74 0A E9 F9 00 00 00 E9 A0 01 00 00 33 C9 83 7D 14 00 0F 95 C1 89 4D CC 83 7D CC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 92 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 92 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 B8 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 B8 E9 03 02 00 00 8B 45 10 83 C0 01 89 45 10 C7 45 FC 00 00 00 00 8B 4D 10 0F BE 11 83 FA 23 75 10 C7 45 FC 01 00 00 00 8B 45 10 83 C0 01 89 45 10 8B 4D FC 51 8B 55 DC 52 8D 45 F0 50 8D 4D 08 51 8B 55 14 52 8B 45 10 0F B6 08 51 8D 4D E0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 12 83 7D F0 00 76 07 C7 45 F4 01 00 00 00 E9 BA 00 00 00 8B 55 10 83 C2 01 89 55 10 E9 A7 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 50 8B 45 10 0F BE 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 66 83 7D F0 01 76 60 8B 55 10 0F BE 42 01 85 C0 75 30 33 C9 75 21 68 ?? ?? ?? ?? 6A 00 68 B7 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 45 F4 01 00 00 00 EB 51 EB 25 8B 45 08 8B 4D 10 8A 11 88 10 8B 45 08 83 C0 01 89 45 08 8B 4D 10 83 C1 01 89 4D 10 8B 55 F0 83 EA 01 89 55 F0 8B 45 08 8B 4D 10 8A 11 88 10 8B 45 08 83 C0 01 89 45 08 8B 4D 10 83 C1 01 89 4D 10 8B 55 F0 83 EA 01 89 55 F0 E9 38 FE FF FF 83 7D F4 00 75 2A 83 7D F0 00 76 24 8B 45 08 C6 00 00 8B 4D 0C 2B 4D F0 89 4D B4 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 B4 E9 B1 00 00 00 E9 A4 00 00 00 8B 55 F8 C6 02 00 83 7D F4 00 75 13 83 7D F0 00 77 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 71 C7 45 C8 00 00 00 00 83 7D C8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 E4 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E4 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 B0 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 B0 EB 1C C7 45 AC 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 AC EB 08 8D 4D E0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_14_0 {
	meta:
		name = "?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
		size = 4035
		refs = "002c $LN122 0033 $LN123 0066 ??_C@_1HE@BFLEOKFO@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAw?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 0072 ??_C@_1GE@FCOIONJG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0079 __CrtDbgReportW 008d __errno 00a4 ??_C@_1BI@HBKPAJH@?$AA_?$AAe?$AAx?$AAp?$AAa?$AAn?$AAd?$AAt?$AAi?$AAm?$AAe?$AA?$AA@ 00ae __invalid_parameter 00d2 ?_store_str@@YAXPADPAPADPAI@Z 01b5 ??_C@_1HC@OOAMILFB@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAo?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 02f7 ?_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPADPAIPAU__lc_time_data@@@Z 041f ??_C@_1HG@NFHHOAD@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA1?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 048b ?_store_num@@YAXHHPAPADPAII@Z 04c6 ??_C@_1HG@KCGGFLNI@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAh?$AAo?$AAu?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 0632 ??_C@_1HI@HHCJCPE@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 0786 ??_C@_1HC@IGKDPPHL@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAi?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 08fd ??_C@_1HC@HLKHIKOB@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAs?$AAe?$AAc?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 0d05 ??_C@_1DC@NMCFBMJP@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAe?$AAa?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?$AA@ 0dc9 ??_C@_1HM@LBNGKIAD@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAe?$AAa?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA?9?$AA1?$AA9?$AA0?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG@ 0e65 ___tzset 0e72 ___tzname 0ebb ??_C@_1EG@JNJKHKFI@?$AA?$CI?$AA?5?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAd?$AAi?$AAr?$AAe?$AAc?$AAt?$AAi?$AAv?$AAe?$AA?$CC?$AA?5?$AA?0?$AA?5?$AA0@ 0eec $LN2 0ef0 $LN3 0ef4 $LN62 0ef8 $LN58 0efc $LN45 0f00 $LN43 0f04 $LN36 0f08 $LN30 0f0c $LN28 0f10 $LN23 0f14 $LN10 0f18 $LN6 0f1c $LN4 0f20 $LN64 0f24 $LN60 0f28 $LN56 0f2c $LN47 0f30 $LN40 0f34 $LN38 0f38 $LN34 0f3c $LN25 0f40 $LN15 0f44 $LN8 0f48 $LN1"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 98 00 00 00 56 0F BE 45 0C 89 45 AC 8B 4D AC 83 E9 04 89 4D AC 83 7D AC 76 0F 87 90 0E 00 00 8B 55 AC 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 10 83 79 18 00 7C 12 8B 55 10 83 7A 18 06 7F 09 C7 45 A8 01 00 00 00 EB 07 C7 45 A8 00 00 00 00 8B 45 A8 89 45 F4 83 7D F4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 31 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 31 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 28 0E 00 00 8B 55 18 52 8B 45 14 50 8B 4D 10 8B 51 18 8B 45 1C 8B 0C 90 51 E8 ?? ?? ?? ?? 83 C4 0C E9 01 0E 00 00 8B 55 10 83 7A 18 00 7C 12 8B 45 10 83 78 18 06 7F 09 C7 45 A4 01 00 00 00 EB 07 C7 45 A4 00 00 00 00 8B 4D A4 89 4D F0 83 7D F0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 3A 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3A 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 81 0D 00 00 8B 45 18 50 8B 4D 14 51 8B 55 10 8B 42 18 8B 4D 1C 8B 54 81 1C 52 E8 ?? ?? ?? ?? 83 C4 0C E9 59 0D 00 00 8B 45 10 83 78 10 00 7C 12 8B 4D 10 83 79 10 0B 7F 09 C7 45 A0 01 00 00 00 EB 07 C7 45 A0 00 00 00 00 8B 55 A0 89 55 EC 83 7D EC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 42 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 42 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 D9 0C 00 00 8B 4D 18 51 8B 55 14 52 8B 45 10 8B 48 10 8B 55 1C 8B 44 8A 38 50 E8 ?? ?? ?? ?? 83 C4 0C E9 B1 0C 00 00 8B 4D 10 83 79 10 00 7C 12 8B 55 10 83 7A 10 0B 7F 09 C7 45 9C 01 00 00 00 EB 07 C7 45 9C 00 00 00 00 8B 45 9C 89 45 E8 83 7D E8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 4A 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 4A 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 31 0C 00 00 8B 55 18 52 8B 45 14 50 8B 4D 10 8B 51 10 8B 45 1C 8B 4C 90 68 51 E8 ?? ?? ?? ?? 83 C4 0C E9 09 0C 00 00 83 7D 20 00 0F 84 88 00 00 00 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 DB 0B 00 00 8B 4D 18 83 39 00 75 07 33 C0 E9 CC 0B 00 00 8B 55 14 8B 02 C6 00 20 8B 4D 14 8B 11 83 C2 01 8B 45 14 89 10 8B 4D 18 8B 11 83 EA 01 8B 45 18 89 10 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 81 0B 00 00 E9 83 00 00 00 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 53 0B 00 00 8B 55 18 83 3A 00 75 07 33 C0 E9 44 0B 00 00 8B 45 14 8B 08 C6 01 20 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B 55 18 8B 02 83 E8 01 8B 4D 18 89 01 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 F9 0A 00 00 E9 EF 0A 00 00 8B 4D 10 83 79 0C 01 7C 12 8B 55 10 83 7A 0C 1F 7F 09 C7 45 98 01 00 00 00 EB 07 C7 45 98 00 00 00 00 8B 45 98 89 45 E4 83 7D E4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 89 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 89 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 6F 0A 00 00 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 02 8B 55 10 8B 42 0C 50 E8 ?? ?? ?? ?? 83 C4 14 E9 48 0A 00 00 8B 4D 10 83 79 08 00 7C 12 8B 55 10 83 7A 08 17 7F 09 C7 45 94 01 00 00 00 EB 07 C7 45 94 00 00 00 00 8B 45 94 89 45 E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 92 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 92 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 C8 09 00 00 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 02 8B 55 10 8B 42 08 50 E8 ?? ?? ?? ?? 83 C4 14 E9 A1 09 00 00 8B 4D 10 83 79 08 00 7C 12 8B 55 10 83 7A 08 17 7F 09 C7 45 90 01 00 00 00 EB 07 C7 45 90 00 00 00 00 8B 45 90 89 45 DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9A 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9A 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 21 09 00 00 8B 55 10 8B 42 08 99 B9 0C 00 00 00 F7 F9 89 55 F8 83 7D F8 00 75 07 C7 45 F8 0C 00 00 00 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 14 E9 DF 08 00 00 8B 45 10 83 78 1C 00 7C 15 8B 4D 10 81 79 1C 6D 01 00 00 7F 09 C7 45 8C 01 00 00 00 EB 07 C7 45 8C 00 00 00 00 8B 55 8C 89 55 D8 83 7D D8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A5 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A5 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 5C 08 00 00 8B 4D 20 51 8B 55 18 52 8B 45 14 50 6A 03 8B 4D 10 8B 51 1C 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 14 E9 32 08 00 00 8B 45 10 83 78 10 00 7C 12 8B 4D 10 83 79 10 0B 7F 09 C7 45 88 01 00 00 00 EB 07 C7 45 88 00 00 00 00 8B 55 88 89 55 D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 AE 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AE 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B2 07 00 00 8B 4D 20 51 8B 55 18 52 8B 45 14 50 6A 02 8B 4D 10 8B 51 10 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 14 E9 88 07 00 00 8B 45 10 83 78 04 00 7C 12 8B 4D 10 83 79 04 3B 7F 09 C7 45 84 01 00 00 00 EB 07 C7 45 84 00 00 00 00 8B 55 84 89 55 D0 83 7D D0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B7 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B7 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 08 07 00 00 8B 4D 20 51 8B 55 18 52 8B 45 14 50 6A 02 8B 4D 10 8B 51 04 52 E8 ?? ?? ?? ?? 83 C4 14 E9 E1 06 00 00 8B 45 10 83 78 08 00 7C 12 8B 4D 10 83 79 08 17 7F 09 C7 45 80 01 00 00 00 EB 07 C7 45 80 00 00 00 00 8B 55 80 89 55 CC 83 7D CC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BF 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D CC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 BF 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 61 06 00 00 8B 4D 10 83 79 08 0B 7F 1C 8B 55 18 52 8B 45 14 50 8B 4D 1C 8B 91 98 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 0C EB 1A 8B 45 18 50 8B 4D 14 51 8B 55 1C 8B 82 9C 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C E9 18 06 00 00 8B 4D 10 83 39 00 7C 14 8B 55 10 83 3A 3B 7F 0C C7 85 7C FF FF FF 01 00 00 00 EB 0A C7 85 7C FF FF FF 00 00 00 00 8B 85 7C FF FF FF 89 45 C8 83 7D C8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 CA 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 CA 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 91 05 00 00 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 02 8B 55 10 8B 02 50 E8 ?? ?? ?? ?? 83 C4 14 E9 6B 05 00 00 8B 4D 10 83 79 18 00 7C 15 8B 55 10 83 7A 18 06 7F 0C C7 85 78 FF FF FF 01 00 00 00 EB 0A C7 85 78 FF FF FF 00 00 00 00 8B 85 78 FF FF FF 89 45 C4 83 7D C4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D1 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D1 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 E2 04 00 00 8B 55 10 8B 42 18 89 45 FC E9 61 01 00 00 E9 5C 01 00 00 8B 4D 10 83 79 18 00 7C 15 8B 55 10 83 7A 18 06 7F 0C C7 85 74 FF FF FF 01 00 00 00 EB 0A C7 85 74 FF FF FF 00 00 00 00 8B 85 74 FF FF FF 89 45 C0 83 7D C0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D8 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D8 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 41 04 00 00 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 01 8B 55 10 8B 42 18 50 E8 ?? ?? ?? ?? 83 C4 14 E9 1A 04 00 00 8B 4D 10 83 79 18 00 7C 15 8B 55 10 83 7A 18 06 7F 0C C7 85 70 FF FF FF 01 00 00 00 EB 0A C7 85 70 FF FF FF 00 00 00 00 8B 85 70 FF FF FF 89 45 BC 83 7D BC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DF 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D BC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DF 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 91 03 00 00 8B 55 10 83 7A 18 00 75 09 C7 45 FC 06 00 00 00 EB 0C 8B 45 10 8B 48 18 83 E9 01 89 4D FC 8B 55 10 83 7A 1C 00 7C 18 8B 45 10 81 78 1C 6D 01 00 00 7F 0C C7 85 6C FF FF FF 01 00 00 00 EB 0A C7 85 6C FF FF FF 00 00 00 00 8B 8D 6C FF FF FF 89 4D B8 83 7D B8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 E5 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 E5 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 E2 02 00 00 8B 45 10 8B 48 1C 3B 4D FC 7D 09 C7 45 F8 00 00 00 00 EB 2D 8B 55 10 8B 42 1C 99 B9 07 00 00 00 F7 F9 89 45 F8 8B 55 10 8B 42 1C 99 B9 07 00 00 00 F7 F9 3B 55 FC 7C 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 20 50 8B 4D 18 51 8B 55 14 52 6A 02 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 14 E9 7D 02 00 00 83 7D 20 00 74 2B 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D 10 51 6A 01 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 53 02 00 00 EB 29 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 28 02 00 00 E9 1E 02 00 00 8B 55 1C 52 8B 45 18 50 8B 4D 14 51 8B 55 10 52 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 FA 01 00 00 E9 F0 01 00 00 8B 4D 10 33 D2 83 79 14 00 0F 9D C2 89 55 B4 83 7D B4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 1A 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 1A 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 89 01 00 00 8B 4D 10 8B 41 14 99 B9 64 00 00 00 F7 F9 89 55 F8 8B 55 20 52 8B 45 18 50 8B 4D 14 51 6A 02 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 14 E9 54 01 00 00 8B 45 10 81 78 14 94 F8 FF FF 7C 18 8B 4D 10 81 79 14 A3 1F 00 00 7F 0C C7 85 68 FF FF FF 01 00 00 00 EB 0A C7 85 68 FF FF FF 00 00 00 00 8B 95 68 FF FF FF 89 55 B0 83 7D B0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 23 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D B0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 23 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 C5 00 00 00 8B 4D 10 8B 41 14 99 B9 64 00 00 00 F7 F9 8B C8 83 C1 13 6B C9 64 8B 55 10 8B 42 14 99 BE 64 00 00 00 F7 FE 03 CA 89 4D F8 8B 45 20 50 8B 4D 18 51 8B 55 14 52 6A 04 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 14 EB 7B E8 ?? ?? ?? ?? 8B 4D 18 51 8B 55 14 52 E8 ?? ?? ?? ?? 8B 4D 10 33 D2 83 79 20 00 0F 95 C2 8B 04 90 50 E8 ?? ?? ?? ?? 83 C4 0C EB 4F 8B 4D 14 8B 11 C6 02 25 8B 45 14 8B 08 83 C1 01 8B 55 14 89 0A 8B 45 18 8B 08 83 E9 01 8B 55 18 89 0A EB 2B EB 29 33 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 40 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 EB 05 B8 01 00 00 00 5E 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 17 17 17 17 17 17 17 17 00 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 01 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 02 03 17 17 17 17 17 04 05 17 17 17 06 17 17 17 17 17 07 17 08 17 09 0A 0B 0C 17 17 17 17 17 17 0D 0E 0F 10 17 17 17 17 17 11 17 17 12 17 17 13 17 17 17 17 17 17 14 15 16 0C }
	condition:
		$1
}

rule file_187_15_0 {
	meta:
		name = "?_store_str@@YAXPADPAPADPAI@Z"
		size = 74
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 83 38 00 74 3B 8B 4D 08 0F BE 11 85 D2 74 31 8B 45 0C 8B 08 8B 55 08 8A 02 88 01 8B 4D 0C 8B 11 83 C2 01 8B 45 0C 89 10 8B 4D 08 83 C1 01 89 4D 08 8B 55 10 8B 02 83 E8 01 8B 4D 10 89 01 EB BD 5D C3 }
	condition:
		$1
}

rule file_187_16_0 {
	meta:
		name = "?_store_num@@YAXHHPAPADPAII@Z"
		size = 170
		refs = "0020 ?_store_number@@YAXHPAPADPAI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 83 7D 18 00 74 16 8B 45 14 50 8B 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C EB 7D 8B 45 14 8B 4D 0C 3B 08 73 6A 8B 55 0C 83 EA 01 89 55 0C EB 09 8B 45 0C 83 E8 01 89 45 0C 8B 4D 0C 83 C1 01 74 32 8B 45 08 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 10 8B 08 8B 45 0C 88 14 01 8B 45 08 99 B9 0A 00 00 00 F7 F9 89 45 08 8B 55 FC 83 C2 01 89 55 FC EB BD 8B 45 10 8B 08 03 4D FC 8B 55 10 89 0A 8B 45 14 8B 08 2B 4D FC 8B 55 14 89 0A EB 09 8B 45 14 C7 00 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_17_0 {
	meta:
		name = "?_store_number@@YAXHPAPADPAI@Z"
		size = 174
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 0C 8B 08 89 4D FC 8B 55 10 83 3A 01 76 45 8B 45 08 99 B9 0A 00 00 00 F7 F9 83 C2 30 8B 45 FC 88 10 8B 4D FC 83 C1 01 89 4D FC 8B 55 10 8B 02 83 E8 01 8B 4D 10 89 01 8B 45 08 99 B9 0A 00 00 00 F7 F9 89 45 08 83 7D 08 00 7E 08 8B 55 10 83 3A 01 77 BB 8B 45 0C 8B 08 89 4D F4 8B 55 0C 8B 45 FC 89 02 8B 4D FC 83 E9 01 89 4D FC 8B 55 FC 8A 02 88 45 FB 8B 4D FC 8B 55 F4 8A 02 88 01 8B 4D FC 83 E9 01 89 4D FC 8B 55 F4 8A 45 FB 88 02 8B 4D F4 83 C1 01 89 4D F4 8B 55 F4 3B 55 FC 72 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_187_18_0 {
	meta:
		name = "?_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPADPAIPAU__lc_time_data@@@Z"
		size = 2068
		refs = "005c __imp__GetDateFormatA@24 0066 __imp__GetTimeFormatA@24 00f0 _malloc 00f9 __MarkAllocaS 0182 __freea 0216 $LN96 021d $LN97 023c $LN98 0277 $LN99 034b ??_C@_05JAMEPDIN@am?1pm?$AA@ 0354 ___ascii_stricmp 036b ??_C@_03EBAPMIKO@a?1p?$AA@ 03d6 __isleadbyte_l 03f9 ??_C@_1IE@EIDABBDG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAc?$AAh?$AAa?$AAr?$AAa?$AAc?$AAt?$AAe?$AAr?$AA?5?$AAs?$AAe?$AAq?$AAu?$AAe?$AAn?$AAc@ 0405 ??_C@_1GE@FCOIONJG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 040c __CrtDbgReportW 05d8 ??_C@_1HG@PAEENAPO@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAc?$AAh?$AAa?$AAr?$AAa?$AAc?$AAt?$AAe?$AAr?$AA?5?$AAs?$AAe?$AAq?$AAu?$AAe?$AAn?$AAc@ 0698 ?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z 0774 $LN14 0778 $LN29 077c $LN44 0780 $LN68 0784 $LN61 0788 $LN49 078c $LN39 0790 $LN34 0794 $LN25 0798 $LN54 079c $LN69 07f4 $LN65 07f8 $LN64 07fc $LN63 0800 $LN62 0804 $LN58 0808 $LN57 080c $LN56 0810 $LN55"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 58 8B 45 0C 89 45 C8 83 7D C8 00 74 08 83 7D C8 01 74 10 EB 1C 8B 4D 1C 8B 91 A0 00 00 00 89 55 F4 EB 1A 8B 45 1C 8B 88 A4 00 00 00 89 4D F4 EB 0C 8B 55 1C 8B 82 A8 00 00 00 89 45 F4 8B 4D 1C 83 B9 B0 00 00 00 01 0F 84 3F 01 00 00 83 7D 0C 02 74 0B 8B 15 ?? ?? ?? ?? 89 55 D0 EB 08 A1 ?? ?? ?? ?? 89 45 D0 8B 4D 10 8B 51 14 81 C2 6C 07 00 00 66 89 55 D4 8B 45 10 8B 48 10 83 C1 01 66 89 4D D6 8B 55 10 66 8B 42 0C 66 89 45 DA 8B 4D 10 66 8B 51 08 66 89 55 DC 8B 45 10 66 8B 48 04 66 89 4D DE 8B 55 10 66 8B 02 66 89 45 E0 33 C9 66 89 4D E2 6A 00 6A 00 8B 55 F4 52 8D 45 D4 50 6A 00 8B 4D 1C 8B 91 AC 00 00 00 52 FF 55 D0 89 45 E4 83 7D E4 00 0F 84 B0 00 00 00 68 DD DD 00 00 8B 45 E4 83 C0 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC 83 7D CC 00 0F 84 86 00 00 00 8B 4D E4 51 8B 55 CC 52 8B 45 F4 50 8D 4D D4 51 6A 00 8B 55 1C 8B 82 AC 00 00 00 50 FF 55 D0 89 45 E4 8B 4D CC 89 4D FC 8B 55 E4 83 EA 01 89 55 E4 83 7D E4 00 7E 39 8B 45 18 83 38 00 76 31 8B 4D 14 8B 11 8B 45 FC 8A 08 88 0A 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B 55 FC 83 C2 01 89 55 FC 8B 45 18 8B 08 83 E9 01 8B 55 18 89 0A EB B8 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 B8 01 00 00 00 E9 DD 05 00 00 8B 4D F4 0F BE 11 85 D2 0F 84 CA 05 00 00 8B 45 18 83 38 00 0F 84 BE 05 00 00 C6 45 EF 00 C7 45 E8 00 00 00 00 C7 45 F8 00 00 00 00 8B 4D F4 89 4D FC EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F4 0F BE 08 8B 55 FC 0F BE 02 8B 55 FC 83 C2 01 89 55 FC 3B C1 75 02 EB DC 8B 45 FC 83 E8 01 89 45 FC 8B 4D F4 0F BE 11 89 55 C4 8B 45 C4 83 E8 27 89 45 C4 83 7D C4 52 0F 87 62 04 00 00 8B 4D C4 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 F8 89 45 C0 8B 4D C0 83 E9 01 89 4D C0 83 7D C0 03 77 21 8B 55 C0 FF 24 95 ?? ?? ?? ?? C7 45 E8 01 00 00 00 C6 45 EF 6D EB 0A C6 45 EF 62 EB 04 C6 45 EF 42 E9 16 04 00 00 8B 45 F8 89 45 BC 8B 4D BC 83 E9 01 89 4D BC 83 7D BC 03 77 21 8B 55 BC FF 24 95 ?? ?? ?? ?? C7 45 E8 01 00 00 00 C6 45 EF 64 EB 0A C6 45 EF 61 EB 04 C6 45 EF 41 E9 DB 03 00 00 8B 45 F8 89 45 B8 83 7D B8 02 74 08 83 7D B8 04 74 08 EB 0A C6 45 EF 79 EB 04 C6 45 EF 59 E9 B8 03 00 00 8B 4D F8 89 4D B4 83 7D B4 01 74 08 83 7D B4 02 74 09 EB 0B C7 45 E8 01 00 00 00 C6 45 EF 49 E9 94 03 00 00 8B 55 F8 89 55 B0 83 7D B0 01 74 08 83 7D B0 02 74 09 EB 0B C7 45 E8 01 00 00 00 C6 45 EF 48 E9 70 03 00 00 8B 45 F8 89 45 AC 83 7D AC 01 74 08 83 7D AC 02 74 09 EB 0B C7 45 E8 01 00 00 00 C6 45 EF 4D E9 4C 03 00 00 8B 4D F8 89 4D A8 83 7D A8 01 74 08 83 7D A8 02 74 09 EB 0B C7 45 E8 01 00 00 00 C6 45 EF 53 E9 28 03 00 00 68 ?? ?? ?? ?? 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 0B 8B 45 F4 83 C0 05 89 45 FC EB 1E 68 ?? ?? ?? ?? 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 09 8B 55 F4 83 C2 03 89 55 FC C6 45 EF 70 E9 E1 02 00 00 8B 45 10 83 78 08 0B 7F 0E 8B 4D 1C 8B 91 98 00 00 00 89 55 F0 EB 0C 8B 45 1C 8B 88 9C 00 00 00 89 4D F0 83 7D F8 01 0F 85 C5 00 00 00 8B 55 18 83 3A 00 0F 86 B9 00 00 00 8B 45 08 50 8B 4D F0 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 6E 8B 45 18 83 38 01 76 66 8B 4D F0 0F BE 51 01 85 D2 75 2C 33 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 A8 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 E9 50 03 00 00 8B 55 14 8B 02 8B 4D F0 8A 11 88 10 8B 45 14 8B 08 83 C1 01 8B 55 14 89 0A 8B 45 F0 83 C0 01 89 45 F0 8B 4D 18 8B 11 83 EA 01 8B 45 18 89 10 8B 4D 14 8B 11 8B 45 F0 8A 08 88 0A 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B 55 F0 83 C2 01 89 55 F0 8B 45 18 8B 08 83 E9 01 8B 55 18 89 0A E9 D3 00 00 00 8B 45 F0 0F BE 08 85 C9 0F 84 C5 00 00 00 8B 55 18 83 3A 00 0F 86 B9 00 00 00 8B 45 08 50 8B 4D F0 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 6E 8B 45 18 83 38 01 76 66 8B 4D F0 0F BE 51 01 85 D2 75 2C 33 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 B8 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 E9 7D 02 00 00 8B 55 14 8B 02 8B 4D F0 8A 11 88 10 8B 45 14 8B 08 83 C1 01 8B 55 14 89 0A 8B 45 F0 83 C0 01 89 45 F0 8B 4D 18 8B 11 83 EA 01 8B 45 18 89 10 8B 4D 14 8B 11 8B 45 F0 8A 08 88 0A 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B 55 F0 83 C2 01 89 55 F0 8B 45 18 8B 08 83 E9 01 8B 55 18 89 0A E9 2D FF FF FF 8B 45 FC 89 45 F4 E9 32 FC FF FF 8B 4D F8 83 E1 01 0F 84 F7 00 00 00 8B 55 F4 03 55 F8 89 55 F4 8B 45 F4 0F BE 08 85 C9 0F 84 DE 00 00 00 8B 55 18 83 3A 00 0F 84 D2 00 00 00 8B 45 F4 0F BE 08 83 F9 27 75 0E 8B 55 F4 83 C2 01 89 55 F4 E9 B9 00 00 00 8B 45 08 50 8B 4D F4 0F BE 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 6E 8B 45 18 83 38 01 76 66 8B 4D F4 0F BE 51 01 85 D2 75 2C 33 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 D5 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 E9 71 01 00 00 8B 55 14 8B 02 8B 4D F4 8A 11 88 10 8B 45 14 8B 08 83 C1 01 8B 55 14 89 0A 8B 45 F4 83 C0 01 89 45 F4 8B 4D 18 8B 11 83 EA 01 8B 45 18 89 10 8B 4D 14 8B 11 8B 45 F4 8A 08 88 0A 8B 55 14 8B 02 83 C0 01 8B 4D 14 89 01 8B 55 F4 83 C2 01 89 55 F4 8B 45 18 8B 08 83 E9 01 8B 55 18 89 0A E9 14 FF FF FF EB 09 8B 45 F4 03 45 F8 89 45 F4 E9 21 FB FF FF 0F BE 4D EF 85 C9 74 3B 8B 55 E8 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 0F B6 4D EF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 07 33 C0 E9 C6 00 00 00 8B 45 FC 89 45 F4 E9 B1 00 00 00 8B 4D 08 51 8B 55 F4 0F BE 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 6B 8B 4D 18 83 39 01 76 63 8B 55 F4 0F BE 42 01 85 C0 75 29 33 C9 75 21 68 ?? ?? ?? ?? 6A 00 68 FE 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 33 C0 EB 68 8B 45 14 8B 08 8B 55 F4 8A 02 88 01 8B 4D 14 8B 11 83 C2 01 8B 45 14 89 10 8B 4D F4 83 C1 01 89 4D F4 8B 55 18 8B 02 83 E8 01 8B 4D 18 89 01 8B 55 14 8B 02 8B 4D F4 8A 11 88 10 8B 45 14 8B 08 83 C1 01 8B 55 14 89 0A 8B 45 F4 83 C0 01 89 45 F4 8B 4D 18 8B 11 83 EA 01 8B 45 18 89 10 E9 28 FA FF FF B8 01 00 00 00 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 01 0A 0A 0A 0A 0A 0A 02 0A 0A 0A 0A 03 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 0A 01 0A 0A 04 0A 0A 0A 05 0A 0A 0A 0A 06 0A 0A 0A 0A 0A 07 08 0A 0A 0A 0A 09 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "___initconin"
		size = 38
		refs = "0015 ??_C@_06GDENEHCP@CONIN$?$AA@ 001b __imp__CreateFileA@28 0020 __coninpfh"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 03 6A 00 6A 03 68 00 00 00 C0 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_188_1_0 {
	meta:
		name = "___initconout"
		size = 38
		refs = "0015 ??_C@_07GPDNMNG@CONOUT$?$AA@ 001b __imp__CreateFileA@28 0020 __confh"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 03 6A 00 6A 03 68 00 00 00 40 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_188_2_0 {
	meta:
		name = "___termcon"
		size = 68
		refs = "0007 __confh 001f __imp__CloseHandle@4 0025 __coninpfh"
	strings:
		$1 = { 8B FF 55 8B EC 83 3D ?? ?? ?? ?? FF 74 15 83 3D ?? ?? ?? ?? FE 74 0C A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 74 16 83 3D ?? ?? ?? ?? FE 74 0D 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "__ismbcpunct_l"
		size = 354
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 004b ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0063 ??1_LocaleUpdate@@QAE@XZ 00a5 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 DC 00 00 00 33 C9 66 89 4D EC 33 D2 66 89 55 EE 8B 45 08 C1 E8 08 25 FF 00 00 00 88 45 E8 8B 4D 08 81 E1 FF 00 00 00 88 4D E9 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 17 C7 45 E4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 E9 EF 00 00 00 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 48 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 42 04 50 8D 4D EC 51 6A 02 8D 55 E8 52 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 17 C7 45 E0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 E9 97 00 00 00 0F B7 45 EE 85 C0 75 12 0F B7 4D EC 83 E1 10 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 DC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 63 EB 59 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 0F B6 4D 08 8B 90 C8 00 00 00 0F B7 04 4A 83 E0 10 75 22 8D 4D F0 E8 ?? ?? ?? ?? 8B 48 04 0F B6 55 08 0F B6 44 11 1D 83 E0 02 75 09 C7 45 D0 00 00 00 00 EB 07 C7 45 D0 01 00 00 00 8B 4D D0 89 4D D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "__controlfp_s"
		size = 224
		refs = "0030 __control87 005d ??_C@_1DG@JNDMIEJL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAp?$AAu?$AAt?$AA?5?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0066 ??_C@_1HI@JIOCECAH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006d __CrtDbgReportW 0081 __errno 0095 ??_C@_1BK@CDOALEA@?$AA_?$AAc?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AAf?$AAp?$AA_?$AAs?$AA?$AA@ 009f __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 10 25 FF FF F7 FF 89 45 10 8B 4D 0C 23 4D 10 81 E1 E0 FC F0 FC 0F 84 88 00 00 00 83 7D 08 00 74 11 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 89 02 33 C0 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 89 4D FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2F 83 7D 08 00 74 17 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 89 02 EB 10 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "?_ValidateRead@@YAHPBXI@Z"
		size = 33
		altNames = "?_ValidateExecute@@YAHP6GHXZ@Z ?_ValidateWrite@@YAHPAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 01 00 00 00 83 7D 08 00 75 07 C7 45 FC 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "_puts"
		size = 719
		refs = "0008 __sehtable$_puts 000d __except_handler4 001f ___security_cookie 004c ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0055 ??_C@_1FM@IMANEMHB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005c __CrtDbgReportW 0070 __errno 0084 ??_C@_19OHLFMNEA@?$AAp?$AAu?$AAt?$AAs?$AA?$AA@ 008e __invalid_parameter 009e ___iob_func 00bc __fileno 00e4 ___pioinfo 00f0 ___badioinfo 0163 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 01c0 __lock_file2 01d8 __stbuf 01e7 _strlen 0205 __fwrite_nolock 0272 __flsbuf 0291 __ftbuf 02b2 __unlock_file2"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 C0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 FF FF FF FF 33 C0 83 7D 08 00 0F 95 C0 89 45 D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 20 02 00 00 E8 ?? ?? ?? ?? 83 C0 20 89 45 D0 8B 55 D0 8B 42 0C 83 E0 40 0F 85 98 00 00 00 8B 4D D0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 CC 83 7D CC FF 74 21 83 7D CC FE 74 1B 8B 55 CC C1 FA 05 8B 45 CC 83 E0 1F C1 E0 06 03 04 95 ?? ?? ?? ?? 89 45 C4 EB 07 C7 45 C4 ?? ?? ?? ?? 8B 4D C4 8A 51 24 D0 E2 D0 FA 0F BE C2 85 C0 75 41 83 7D CC FF 74 21 83 7D CC FE 74 1B 8B 4D CC C1 F9 05 8B 55 CC 83 E2 1F C1 E2 06 03 14 8D ?? ?? ?? ?? 89 55 C0 EB 07 C7 45 C0 ?? ?? ?? ?? 8B 45 C0 8A 48 24 C0 E1 00 C0 F9 07 0F BE D1 85 D2 74 09 C7 45 BC 00 00 00 00 EB 07 C7 45 BC 01 00 00 00 8B 45 BC 89 45 C8 83 7D C8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D C8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 09 01 00 00 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 E4 E8 ?? ?? ?? ?? 83 C0 20 50 8B 45 E4 50 6A 01 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 DC 8B 55 DC 3B 55 E4 75 6C E8 ?? ?? ?? ?? 83 C0 24 89 45 B8 8B 45 B8 8B 08 83 E9 01 8B 55 B8 89 0A 8B 45 B8 83 38 00 7C 2F E8 ?? ?? ?? ?? 83 C0 20 89 45 B4 8B 4D B4 8B 11 C6 02 0A B8 0A 00 00 00 25 FF 00 00 00 89 45 B0 8B 4D B4 8B 11 83 C2 01 8B 45 B4 89 10 EB 16 E8 ?? ?? ?? ?? 83 C0 20 50 6A 0A E8 ?? ?? ?? ?? 83 C4 08 89 45 B0 C7 45 E0 00 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 50 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 14 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "___strncnt"
		size = 70
		altNames = "?strncnt@@YAHPBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 89 45 F8 8B 4D 08 89 4D FC 8B 55 F8 8B 45 F8 83 E8 01 89 45 F8 85 D2 74 15 8B 4D FC 0F BE 11 85 D2 74 0B 8B 45 FC 83 C0 01 89 45 FC EB DB 8B 45 0C 2B 45 F8 83 E8 01 8B E5 5D C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "__execlp"
		size = 420
		refs = "001b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GA@LDFLJAKF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BA@CGMAKGL@?$AA_?$AAe?$AAx?$AAe?$AAc?$AAl?$AAp?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0142 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 0199 __execvp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 34 01 00 00 8B 55 08 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D1 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 70 8B 4D 0C 0F BE 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 35 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 35 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 10 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "___libm_sse2_atan2"
		size = 1302
		refs = "013d _a2 0145 _b2 0155 _P_TBL 015e _SGN_TBL 0176 _ATAN_TBL 0223 _P_TBL2 023c _SELECT_B 02d2 _SGNMASK 02da _pi_table 02f2 _pi2_table 032b _POW55 0338 _INVEXPMASK 0344 _EXPMASK 043a _pi4_table"
	strings:
		$1 = { 83 EC 14 66 0F C5 C0 03 25 F0 7F 00 00 66 0F 13 44 24 04 2D 70 38 00 00 3D 00 0F 00 00 66 0F 13 4C 24 0C 0F 87 D2 02 00 00 66 0F C5 C1 03 25 F0 7F 00 00 2D 70 38 00 00 3D 00 0F 00 00 0F 87 B8 02 00 00 66 0F 14 C1 66 0F 57 ED 66 0F 57 DB B8 00 08 00 00 66 0F C4 E8 03 66 0F FD E9 66 0F 73 D5 1D F3 0F 53 DD 66 0F 57 E4 B9 00 38 00 00 66 0F C4 E1 03 66 0F 73 F3 1D 66 0F FD DC F2 0F 59 D8 66 0F 57 D2 66 0F 57 F6 66 0F 57 FF B8 00 80 00 00 66 0F C4 F0 02 B9 FF 7F 00 00 66 0F C4 F9 03 66 0F FE DE 66 0F 54 DF F2 0F 10 EB 66 0F C5 C3 03 B9 40 40 00 00 66 0F C4 D1 03 F2 0F 5D DA 66 0F 50 D0 66 0F 73 F0 01 66 0F 73 D0 01 F2 0F C2 EA 02 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 10 F1 F2 0F 10 F9 F2 0F 10 D0 B9 00 00 00 00 66 0F C4 F1 00 F2 0F 5C FE F2 0F 10 E0 F2 0F 59 F3 F2 0F 59 E3 F2 0F 59 FB 66 0F 54 C5 F2 0F 5C C6 66 0F 54 CD F2 0F 58 E1 F2 0F 5C C7 25 F0 7F 00 00 2D 9E 3F 00 00 3D 61 04 00 00 0F 87 AE 00 00 00 F2 0F 5E C4 66 0F C5 CB 03 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 C5 00 03 D2 66 0F 28 34 D5 ?? ?? ?? ?? 66 0F 28 0C D5 ?? ?? ?? ?? 81 E9 9E 3F 00 00 F7 D0 83 E0 01 03 C8 03 C9 66 0F 28 2C CD ?? ?? ?? ?? 66 0F 57 E9 66 0F 58 EE F2 0F 10 F5 66 0F 15 ED 83 C4 14 66 0F 57 C8 F2 0F 10 E1 F2 0F 59 C0 F2 0F 59 D0 F2 0F 58 D8 F2 0F 58 CE F2 0F 5C F1 F2 0F 58 F4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 E0 F2 0F 58 F5 F2 0F 59 D4 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D3 F2 0F 58 D6 F2 0F 58 CA 66 0F 28 C1 C3 05 AE 03 00 00 3D AE 03 00 00 0F 87 A3 00 00 00 66 0F 57 E4 B9 F0 3F 00 00 66 0F C4 E1 03 F2 0F 5E E1 83 C4 14 03 D2 66 0F 28 34 D5 ?? ?? ?? ?? 66 0F 14 DB 66 0F 57 C6 66 0F 57 D6 66 0F 57 DE 66 0F 28 3C D5 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? 66 0F 54 1C D5 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 C4 F2 0F 10 F2 F2 0F 59 D2 F2 0F 59 CA F2 0F 58 EA F2 0F 59 F2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 F8 66 0F 58 FB F2 0F 59 CE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 F2 0F 58 EF 66 0F 15 FF F2 0F 58 EF 66 0F 28 C5 C3 66 0F 12 4C 24 0C 66 0F 12 44 24 04 66 0F C5 C1 03 25 F0 7F 00 00 66 0F C5 C8 03 81 E1 F0 7F 00 00 3B C8 7F 2D 66 0F C5 C9 03 81 F9 FF 7F 00 00 7F 08 83 C4 14 F2 0F 5E C1 C3 83 C4 14 66 0F 54 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 57 C2 C3 83 C4 14 66 0F 54 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 57 C2 C3 66 0F C5 C8 03 81 E1 F0 7F 00 00 66 0F C5 C1 03 25 F0 7F 00 00 81 F9 F0 7F 00 00 0F 84 A5 00 00 00 3D F0 7F 00 00 0F 84 52 01 00 00 66 0F 12 1D ?? ?? ?? ?? BA 00 04 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 57 F6 66 0F 12 3D ?? ?? ?? ?? 83 F9 00 74 35 83 F8 00 74 50 03 D1 2B D0 81 FA 00 08 00 00 0F 87 2F FF FF FF 81 C2 F0 3B 00 00 66 0F C4 F2 03 66 0F 54 C4 66 0F 54 CC 66 0F 56 C6 66 0F 56 CF E9 C1 FC FF FF 81 EA 70 03 00 00 F2 0F 59 C3 66 0F C5 C8 03 81 E1 F0 7F 00 00 83 F9 00 0F 84 2A 01 00 00 EB AB 81 C2 70 03 00 00 F2 0F 59 CB 66 0F C5 C1 03 25 F0 7F 00 00 83 F8 00 0F 84 34 01 00 00 EB 91 66 0F 7E C2 F2 0F 10 D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B CA 83 F9 00 75 26 66 0F 73 D0 3F 66 0F 73 F0 3F 3D F0 7F 00 00 73 19 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 83 C4 14 C3 66 0F 7E C8 F2 0F 10 D1 66 0F 73 D2 20 66 0F 7E D1 BA 00 00 00 80 23 D1 81 E1 FF FF 0F 00 0B C8 83 F9 00 75 1E 83 FA 00 75 21 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 83 C4 14 F2 0F 10 C1 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 EE 66 0F 70 F5 EE 66 0F 58 EE 66 0F 56 C5 C3 66 0F 7E C8 F2 0F 10 D1 66 0F 73 D2 20 66 0F 7E D1 BA 00 00 00 80 23 D1 81 E1 FF FF 0F 00 0B C8 83 F9 00 75 AE 66 0F 73 D0 3F 66 0F 73 F0 3F 83 FA 00 75 04 83 C4 14 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 66 0F C5 D1 03 81 E2 00 80 00 00 83 FA 00 74 15 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 83 C4 14 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 73 D0 3F 66 0F 73 F0 3F 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "_DebuggerKnownHandle"
		size = 36
		refs = "0002 __imp__IsDebuggerPresent@0 0010 ?DebuggerProbe@@YAHK@Z"
	strings:
		$1 = { FF 15 ?? ?? ?? ?? 85 C0 74 17 68 04 10 00 00 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_198_1_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 138
		refs = "0008 __sehtable$?DebuggerProbe@@YAHK@Z 000d __except_handler4 001f ___security_cookie 005e __imp__RaiseException@16"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 24 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 33 C0 88 45 E7 C7 45 CC 01 10 00 00 8B 4D 08 89 4D D0 8D 55 E7 89 55 D4 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 09 B8 01 00 00 00 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_2_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 81
		refs = "0010 ?_RTC_ErrorLevels@@3PAHA 0017 __RTC_ErrorMessages 0028 ?failwithmessage@@YAXPAXHHPBD@Z 0032 ??_C@_0BO@GNIAFIKK@Unknown?5Runtime?5Check?5Error?6?$AN?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 83 F8 04 77 24 8B 0C 85 ?? ?? ?? ?? 8B 14 85 ?? ?? ?? ?? 83 F9 FF 74 0F 52 50 8B 45 08 51 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 BA ?? ?? ?? ?? 52 B8 05 00 00 00 50 8B 45 08 B9 01 00 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_198_3_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 519
		refs = "000c ___security_cookie 0030 ?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z 0043 ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 0052 __imp__MultiByteToWideChar@24 0099 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 00a3 ?DebuggerProbe@@YAHK@Z 00ba __RTC_NoFalsePositives 00c3 ?DebuggerRuntime@@YAHKHPAXPB_W@Z 00f5 __imp__IsDebuggerPresent@0 0125 ?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z 013f ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 015f __imp__WideCharToMultiByte@32 0184 ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 01b5 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 01da ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 01f2 __imp__DebugBreak@0 01ff @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 3C 0E 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 56 57 8B 7D 14 53 89 BD C4 F1 FF FF C7 85 C8 F1 FF FF 00 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 89 85 D0 F1 FF FF 85 C0 75 0F 53 E8 ?? ?? ?? ?? 83 C4 04 89 85 C8 F1 FF FF 8B 35 ?? ?? ?? ?? 6A 00 6A 00 6A FF 57 6A 00 68 E9 FD 00 00 FF D6 3D 00 02 00 00 73 26 50 8D 85 D4 F1 FF FF 50 6A FF 57 6A 00 68 E9 FD 00 00 FF D6 85 C0 74 0E 8D 8D D4 F1 FF FF 89 8D CC F1 FF FF EB 0A C7 85 CC F1 FF FF ?? ?? ?? ?? 68 02 10 00 00 E8 ?? ?? ?? ?? 8B 7D 10 83 C4 04 85 C0 74 25 8B 95 CC F1 FF FF 8B 04 BD ?? ?? ?? ?? 52 53 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 24 01 00 00 32 C0 EB 02 B0 01 83 BD C8 F1 FF FF 00 8B B5 D0 F1 FF FF 75 08 85 F6 0F 84 01 01 00 00 84 C0 74 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 EF 00 00 00 68 04 01 00 00 8D 8D EC FB FF FF 51 8D 95 D0 F1 FF FF 52 68 04 01 00 00 8D 85 F4 FD FF FF 50 83 C3 FB 53 E8 ?? ?? ?? ?? 83 C4 18 85 F6 74 2D 8B 8D CC F1 FF FF 8B 85 D0 F1 FF FF 51 57 68 ?? ?? ?? ?? 8D 95 EC FB FF FF 52 8B 55 0C 50 8D 8D F4 FD FF FF 51 52 FF D6 E9 8B 00 00 00 8B 3D ?? ?? ?? ?? 6A 00 6A 00 68 0A 03 00 00 8D 85 D4 F5 FF FF 50 6A FF 8D 8D F4 FD FF FF 51 6A 00 68 E9 FD 00 00 BB ?? ?? ?? ?? FF D7 85 C0 74 06 8D 9D D4 F5 FF FF 6A 00 6A 00 68 0A 03 00 00 8D 95 E0 F8 FF FF 52 6A FF 8D 85 EC FB FF FF 50 6A 00 68 E9 FD 00 00 BE ?? ?? ?? ?? FF D7 85 C0 74 06 8D B5 E0 F8 FF FF 8B 8D C4 F1 FF FF 8B 55 10 8B 85 D0 F1 FF FF 51 8B 4D 0C 52 68 ?? ?? ?? ?? 56 50 53 51 FF 95 C8 F1 FF FF 83 C4 1C 83 F8 01 75 06 FF 15 ?? ?? ?? ?? 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_4_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 156
		refs = "0008 __sehtable$?DebuggerRuntime@@YAHKHPAXPB_W@Z 000d __except_handler4 001f ___security_cookie 0070 __imp__RaiseException@16"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 24 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 33 C0 88 45 E7 C7 45 CC 02 10 00 00 8B 4D 08 89 4D D0 8B 55 0C 89 55 D4 8B 4D 10 89 4D D8 8D 55 E7 89 55 DC 8B 4D 14 89 4D E0 89 45 FC 8D 55 CC 52 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 09 B8 01 00 00 00 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_5_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 252
		refs = "000c ___security_cookie 0017 ?_RTC_ErrorLevels@@3PAHA 0062 _stack_premsg 009c _stack_postmsg 00d0 ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 00e5 ?failwithmessage@@YAXPAXHHPBD@Z 00f4 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 08 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 89 85 F8 FB FF FF 8B 45 0C 0F 84 C0 00 00 00 80 38 00 53 56 0F 84 96 00 00 00 8B C8 8D 71 01 8B FF 8A 11 41 84 D2 75 F9 2B CE 83 C1 2D 81 F9 00 04 00 00 77 7B 8D 9D FC FB FF FF 33 C9 8D 64 24 00 8A 91 ?? ?? ?? ?? 88 94 0D FC FB FF FF 41 84 D2 75 EE 8B D0 8A 08 40 84 C9 75 F9 57 8D BD FC FB FF FF 2B C2 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 8B F2 F3 A5 8B C8 83 E1 03 B8 ?? ?? ?? ?? F3 A4 8B C8 8A 10 40 84 D2 75 F9 8D BD FC FB FF FF 2B C1 8B F1 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 5F EB 05 BB ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 8D F8 FB FF FF 53 6A 02 50 51 E8 ?? ?? ?? ?? 83 C4 10 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_6_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
		size = 307
		refs = "000c ___security_cookie 0018 ?_RTC_ErrorLevels@@3PAHA 0034 ??_C@_0L@GMPLCCII@user32?4dll?$AA@ 003a __imp__LoadLibraryA@4 0047 ??_C@_09FOPFMPEJ@wsprintfA?$AA@ 004e __imp__GetProcAddress@8 0053 ?wsprintffp@@3P6AHPADPBDZZA 006e ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 0074 ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 007d ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 0086 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 008b ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 0096 ??_C@_0BC@KIBAILCI@?$CFs?$CFs?$CFp?$CFs?$CFld?$CFs?$CFd?$CFs?$AA@ 00ae ?_getMemBlockDataString@@YAXPAD00I@Z 00b6 ??_C@_01EEMJAFIK@?6?$AA@ 00bf ??_C@_02LLMPMKNF@?$DO?5?$AA@ 00c8 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 00d5 __imp__lstrlenA@4 00f9 ?failwithmessage@@YAXPAXHHPBD@Z 0109 @__security_check_cookie@4 0112 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 1D ?? ?? ?? ?? 56 8B 75 0C 57 8B 7D 08 89 BD BC FE FF FF 83 FB FF 0F 84 EF 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 CB 00 00 00 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 F6 0F 84 B2 00 00 00 85 C0 0F 84 AA 00 00 00 8B 4D 10 8B 56 0C 68 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 83 EA 24 52 68 ?? ?? ?? ?? 8D 7E 20 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D C0 FE FF FF 68 ?? ?? ?? ?? 51 FF D0 8B 56 0C 83 EA 24 52 57 8D 45 B4 50 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 38 68 ?? ?? ?? ?? 8D 55 B4 52 68 ?? ?? ?? ?? 8D 45 E8 50 68 ?? ?? ?? ?? 8D 8D C0 FE FF FF 51 FF 15 ?? ?? ?? ?? 8D 94 05 C0 FE FF FF 52 FF 15 ?? ?? ?? ?? 8B 8D BC FE FF FF 8D 85 C0 FE FF FF 50 6A 04 53 51 E8 ?? ?? ?? ?? 83 C4 28 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 68 ?? ?? ?? ?? 6A 04 53 57 E8 ?? ?? ?? ?? 83 C4 10 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_7_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPAD00I@Z"
		size = 111
		refs = "003c ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 0043 ?wsprintffp@@3P6AHPADPBDZZA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 53 56 8B 75 08 89 45 FC 8B 45 10 57 33 FF 2B C6 89 45 F8 8B FF 8B 4D 14 83 F9 10 72 05 B9 10 00 00 00 3B F9 73 26 8A 1C 30 8B 55 FC 0F B6 CB 51 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 83 45 FC 03 8B 45 F8 83 C4 0C 88 1E 47 46 EB C9 8B 4D 0C 8B 45 08 8D 14 79 C6 04 07 00 C6 04 17 00 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_198_8_0 {
	meta:
		name = "__RTC_UninitUse"
		size = 233
		refs = "000c ___security_cookie 0017 ?_RTC_ErrorLevels@@3PAHA 0052 _uninit_premsg 008c _uninit_postmsg 00c0 ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 00d2 ?failwithmessage@@YAXPAXHHPBD@Z 00e1 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 04 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 0F 84 B6 00 00 00 53 56 85 C0 0F 84 90 00 00 00 8B C8 8D 71 01 8A 11 41 84 D2 75 F9 2B CE 83 C1 3A 81 F9 00 04 00 00 77 77 8D 9D FC FB FF FF 33 C9 8A 91 ?? ?? ?? ?? 88 94 0D FC FB FF FF 41 84 D2 75 EE 8B D0 8A 08 40 84 C9 75 F9 57 8D BD FC FB FF FF 2B C2 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 8B F2 F3 A5 8B C8 83 E1 03 B8 ?? ?? ?? ?? F3 A4 8B C8 8A 10 40 84 D2 75 F9 8D BD FC FB FF FF 2B C1 8B F1 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 5F EB 05 BB ?? ?? ?? ?? A1 ?? ?? ?? ?? 53 6A 03 50 8B 45 04 50 E8 ?? ?? ?? ?? 83 C4 10 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_199_1_0 {
	meta:
		name = "__toupper_l"
		size = 468
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0050 __isctype_l 006c __chvalidator_l 009a ??1_LocaleUpdate@@QAE@XZ 00e8 __isleadbyte_l 0116 __errno 016c ___crtLCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 8B 45 0C 50 8D 4D E4 E8 ?? ?? ?? ?? 81 7D 08 00 01 00 00 0F 83 9D 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 85 C0 74 2F 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 83 B9 AC 00 00 00 01 7E 1C 8D 4D E4 E8 ?? ?? ?? ?? 50 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC EB 1A 6A 02 8B 45 08 50 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC 83 7D CC 00 74 2C 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 91 D0 00 00 00 8B 45 08 0F B6 0C 02 89 4D E0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 E0 E9 2A 01 00 00 EB 16 8B 55 08 89 55 DC 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 DC E9 12 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 00 83 B8 AC 00 00 00 01 7E 44 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 4D 08 C1 F9 08 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 22 8B 55 08 C1 FA 08 81 E2 FF 00 00 00 88 55 F8 8A 45 08 88 45 F9 C6 45 FA 00 C7 45 F4 02 00 00 00 EB 1C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8A 4D 08 88 4D F8 C6 45 F9 00 C7 45 F4 01 00 00 00 6A 01 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 6A 03 8D 4D FC 51 8B 55 F4 52 8D 45 F8 50 68 00 02 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 51 14 52 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 24 89 45 F4 83 7D F4 00 75 13 8B 45 08 89 45 D8 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 EB 41 83 7D F4 01 75 16 0F B6 4D FC 89 4D D4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 EB 27 EB 1D 0F B6 55 FD 0F B6 45 FC C1 E0 08 0B D0 89 55 D0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 EB 08 8D 4D E4 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_199_5_0 {
	meta:
		name = "_toupper"
		size = 69
		refs = "0008 ___locale_changed 003a __toupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 24 83 7D 08 61 7C 11 83 7D 08 7A 7F 0B 8B 45 08 83 E8 20 89 45 FC EB 06 8B 4D 08 89 4D FC 8B 45 FC EB 10 EB 0E 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "__wcstombs_l_helper"
		size = 1161
		refs = "0009 ___security_cookie 0046 ??_C@_1BK@OIBENBPM@?$AAp?$AAw?$AAc?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004f ??_C@_1GE@OAENIBOD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0056 __CrtDbgReportW 006a __errno 007e ??_C@_1CG@LLJCAOHF@?$AA_?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAl?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 0088 __invalid_parameter 009f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00b1 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00ec ??1_LocaleUpdate@@QAE@XZ 017a ?wcsncnt@@YAIPB_WI@Z 01ac __imp__WideCharToMultiByte@32 026d __imp__GetLastError@0 03f0 _wcslen 0481 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 6C A1 ?? ?? ?? ?? 33 C5 89 45 DC C7 45 FC 00 00 00 00 C7 45 F0 00 00 00 00 83 7D 08 00 74 0D 83 7D 10 00 75 07 33 C0 E9 48 04 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 D0 83 7D D0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 66 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E4 03 00 00 8B 55 14 52 8D 4D E0 E8 ?? ?? ?? ?? 83 7D 08 00 0F 84 2E 03 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 00 83 78 14 00 0F 85 93 00 00 00 8B 4D FC 3B 4D 10 73 70 8B 55 0C 0F B7 02 3D FF 00 00 00 7E 22 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 CC FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 CC E9 83 03 00 00 8B 4D 08 03 4D FC 8B 55 0C 8A 02 88 01 8B 4D 0C 0F B7 11 8B 45 0C 83 C0 02 89 45 0C 85 D2 75 16 8B 4D FC 89 4D C8 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C8 E9 4D 03 00 00 8B 55 FC 83 C2 01 89 55 FC EB 88 8B 45 FC 89 45 C4 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C4 E9 2C 03 00 00 E9 82 02 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 83 B9 AC 00 00 00 01 0F 85 A8 00 00 00 83 7D 10 00 76 13 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 10 8D 4D F0 51 6A 00 8B 55 10 52 8B 45 08 50 8B 4D 10 51 8B 55 0C 52 6A 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 00 8B 48 04 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 33 83 7D F0 00 75 2D 8B 55 08 03 55 FC 0F BE 42 FF 85 C0 75 09 8B 4D FC 83 E9 01 89 4D FC 8B 55 FC 89 55 C0 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C0 E9 8F 02 00 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 BC FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 BC E9 6D 02 00 00 E9 C3 01 00 00 8D 45 F0 50 6A 00 8B 4D 10 51 8B 55 08 52 6A FF 8B 45 0C 50 6A 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 8B 51 04 52 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 1F 83 7D F0 00 75 19 8B 45 FC 83 E8 01 89 45 B8 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 B8 E9 16 02 00 00 83 7D F0 00 75 0B FF 15 ?? ?? ?? ?? 83 F8 7A 74 22 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 B4 FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 B4 E9 E3 01 00 00 8B 4D FC 3B 4D 10 0F 83 1C 01 00 00 8D 55 F0 52 6A 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 00 8B 88 AC 00 00 00 51 8D 55 D4 52 6A 01 8B 45 0C 50 6A 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 8B 51 04 52 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 74 06 83 7D F0 00 74 22 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 B0 FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 B0 E9 6F 01 00 00 83 7D F4 00 7C 06 83 7D F4 05 76 22 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 AC FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 AC E9 41 01 00 00 8B 45 FC 03 45 F4 3B 45 10 76 16 8B 4D FC 89 4D A8 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 A8 E9 20 01 00 00 C7 45 F8 00 00 00 00 EB 12 8B 55 F8 83 C2 01 89 55 F8 8B 45 FC 83 C0 01 89 45 FC 8B 4D F8 3B 4D F4 7D 34 8B 55 08 03 55 FC 8B 45 F8 8A 4C 05 D4 88 0A 8B 55 08 03 55 FC 0F BE 02 85 C0 75 16 8B 4D FC 89 4D A4 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 A4 E9 CB 00 00 00 EB B2 8B 55 0C 83 C2 02 89 55 0C E9 D8 FE FF FF 8B 45 FC 89 45 A0 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 A0 E9 A5 00 00 00 E9 98 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 08 83 79 14 00 75 1E 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 9C 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 9C EB 74 EB 6A 8D 45 F0 50 6A 00 6A 00 6A 00 6A FF 8B 4D 0C 51 6A 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 74 06 83 7D F0 00 74 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 98 FF FF FF FF 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 98 EB 1E 8B 4D FC 83 E9 01 89 4D 94 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 94 EB 08 8D 4D E0 E8 ?? ?? ?? ?? 8B 4D DC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_200_4_0 {
	meta:
		name = "?wcsncnt@@YAIPB_WI@Z"
		size = 91
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 83 C0 01 89 45 F8 8B 4D 08 89 4D FC 8B 55 F8 83 EA 01 89 55 F8 74 15 8B 45 FC 0F B7 08 85 C9 74 0B 8B 55 FC 83 C2 02 89 55 FC EB E0 83 7D F8 00 74 17 8B 45 FC 0F B7 08 85 C9 75 0D 8B 45 FC 2B 45 08 D1 F8 83 C0 01 EB 03 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_200_7_0 {
	meta:
		name = "__wcstombs_s_l"
		size = 806
		refs = "0044 ??_C@_1IM@MFGKHGBP@?$AA?$CI?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ@ 0050 ??_C@_1GE@OAENIBOD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0057 __CrtDbgReportW 006b __errno 0082 ??_C@_1BM@BDMCLLDL@?$AA_?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 008c __invalid_parameter 00c6 ___crtDebugFillThreshold 00f1 _memset 0136 ??_C@_1CM@LLECFMFH@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AAS?$AAi?$AAz?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 01a0 __wcstombs_l_helper 02a4 ??_C@_1CM@KEOGBFLI@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AAr?$AAe?$AAt?$AAs?$AAi?$AAz?$AAe?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C C7 45 FC 00 00 00 00 83 7D 0C 00 74 06 83 7D 10 00 77 15 83 7D 0C 00 75 06 83 7D 10 00 74 09 C7 45 E4 00 00 00 00 EB 07 C7 45 E4 01 00 00 00 8B 45 E4 89 45 F0 83 7D F0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 33 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 33 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 85 02 00 00 83 7D 0C 00 74 55 8B 55 0C C6 02 00 83 7D 10 FF 74 49 81 7D 10 FF FF FF 7F 74 40 83 7D 10 01 76 3A 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E0 EB 09 8B 55 10 83 EA 01 89 55 E0 8B 45 E0 50 68 FE 00 00 00 8B 4D 0C 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 74 09 8B 55 08 C7 02 00 00 00 00 8B 45 18 3B 45 10 76 08 8B 4D 10 89 4D DC EB 06 8B 55 18 89 55 DC 8B 45 DC 89 45 F8 B9 FF FF FF 7F 3B 4D F8 1B D2 83 C2 01 89 55 EC 75 21 68 ?? ?? ?? ?? 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 93 01 00 00 8B 4D 1C 51 8B 55 F8 52 8B 45 14 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 FF 75 67 83 7D 0C 00 74 55 8B 55 0C C6 02 00 83 7D 10 FF 74 49 81 7D 10 FF FF FF 7F 74 40 83 7D 10 01 76 3A 8B 45 10 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D D8 EB 09 8B 55 10 83 EA 01 89 55 D8 8B 45 D8 50 68 FE 00 00 00 8B 4D 0C 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 00 E9 0B 01 00 00 8B 55 F4 83 C2 01 89 55 F4 83 7D 0C 00 0F 84 E7 00 00 00 8B 45 F4 3B 45 10 0F 86 D1 00 00 00 83 7D 18 FF 0F 84 BA 00 00 00 8B 4D 0C C6 01 00 83 7D 10 FF 74 48 81 7D 10 FF FF FF 7F 74 3F 83 7D 10 01 76 39 8B 55 10 83 EA 01 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 D4 EB 09 8B 4D 10 83 E9 01 89 4D D4 8B 55 D4 52 68 FE 00 00 00 8B 45 0C 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 10 39 4D F4 1B D2 F7 DA 89 55 E8 75 21 68 ?? ?? ?? ?? 6A 00 68 57 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 57 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 28 8B 4D 10 89 4D F4 C7 45 FC 50 00 00 00 8B 55 0C 03 55 F4 C6 42 FF 00 83 7D 08 00 74 08 8B 45 08 8B 4D F4 89 08 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "___wrt2err"
		size = 62
		refs = "0029 ___pioinfo 0036 __imp__WriteFile@20"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 0F BE 08 89 4D FC 8B 55 08 83 C2 01 89 55 08 6A 00 8D 45 F8 50 8B 4D FC 51 8B 55 08 52 A1 ?? ?? ?? ?? 8B 88 80 00 00 00 51 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "__dosmaperr"
		size = 40
		refs = "0007 ___doserrno 0015 __get_errno_from_oserr 001f __errno"
	strings:
		$1 = { 8B FF 55 8B EC 56 E8 ?? ?? ?? ?? 8B 4D 08 89 08 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 89 30 5E 5D C3 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "__get_errno_from_oserr"
		size = 116
		refs = "0027 _errtable"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 2D 73 1D 8B 4D FC 8B 55 08 3B 14 CD ?? ?? ?? ?? 75 0C 8B 45 FC 8B 04 C5 ?? ?? ?? ?? EB 37 EB D4 83 7D 08 13 72 0F 83 7D 08 24 77 09 B8 0D 00 00 00 EB 22 EB 20 81 7D 08 BC 00 00 00 72 12 81 7D 08 CA 00 00 00 77 09 B8 08 00 00 00 EB 07 EB 05 B8 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "__set_errno"
		size = 45
		refs = "0007 __getptd_noexit 001e __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 09 B8 0C 00 00 00 EB 0E EB 0C E8 ?? ?? ?? ?? 8B 4D 08 89 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_4_0 {
	meta:
		name = "__set_doserrno"
		size = 45
		refs = "0007 __getptd_noexit 001e ___doserrno"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 09 B8 0C 00 00 00 EB 0E EB 0C E8 ?? ?? ?? ?? 8B 4D 08 89 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "__get_errno"
		size = 118
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1GA@MFGIMPNL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002c __CrtDbgReportW 004c ??_C@_1BG@KCMPBBDK@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$AA@ 0056 __invalid_parameter 0065 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 BD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 25 6A 00 68 BD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0E E8 ?? ?? ?? ?? 8B 55 08 8B 00 89 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_5_0 {
	meta:
		name = "__get_doserrno"
		size = 118
		refs = "0019 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0025 ??_C@_1GA@MFGIMPNL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002c __CrtDbgReportW 004c ??_C@_1BM@INIPHHDD@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAo?$AAs?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$AA@ 0056 __invalid_parameter 0065 ___doserrno"
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F5 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 25 6A 00 68 F5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0E E8 ?? ?? ?? ?? 8B 55 08 8B 00 89 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_6_0 {
	meta:
		name = "__errno"
		size = 39
		refs = "0007 __getptd_noexit 0015 _ErrnoNoMem"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 09 B8 ?? ?? ?? ?? EB 08 EB 06 8B 45 FC 83 C0 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_202_7_0 {
	meta:
		name = "___doserrno"
		size = 39
		refs = "0007 __getptd_noexit 0015 _DoserrorNoMem"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 09 B8 ?? ?? ?? ?? EB 08 EB 06 8B 45 FC 83 C0 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_2_0 {
	meta:
		name = "__cprinput_l"
		size = 5609
		refs = "000c ___security_cookie 006d ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0079 ??_C@_1FO@LDDBLKJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0080 __CrtDbgReportW 0097 __errno 00ae ??_C@_1BI@KNCPPIAC@?$AA_?$AAc?$AAp?$AAr?$AAi?$AAn?$AAp?$AAu?$AAt?$AA_?$AAl?$AA?$AA@ 00b8 __invalid_parameter 00d2 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0105 _iswctype 011e __whiteout 012a __un_inc 020a _isdigit 026a $LN233 0271 $LN235 04a8 __inc 050e $LN234 0515 $LN236 05b7 ??_C@_0CP@MMGCGBFO@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 05c3 __malloc_dbg 05eb _memset 083f ??_C@_1FA@OAMCKJNL@?$AAw?$AAc?$AAt?$AAo?$AAm?$AAb?$AA_?$AAs?$AA?$CI?$AA?$CG?$AAt?$AAe?$AAm?$AAp?$AA?0?$AA?5?$AA?$CI?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CK?$AA?$CJ?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?0@ 085d _wctomb_s 0866 __invoke_watson_if_oneof 0ac5 _isxdigit 0adf __allshl 0af8 __hextodec 0f70 ___check_float_string 0faa ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0fcb __INTRN_LOCALE_CONV 0fda __mbtowc_l 1370 ??_C@_1IE@NKBCJFAM@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?5?$AA?$CI?$AA0?$AA?0?$AA?5?$AAc?$AAf?$AAl?$AAo?$AAa?$AAt?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?0?$AA?5?$AAc?$AAf?$AAs@ 1397 _wcstombs_s 13c7 __cfltcvt_tab 13cd __decode_pointer 13e3 __free_dbg 151f ??1_LocaleUpdate@@QAE@XZ 152f @__security_check_cookie@4 1538 $LN197 153c $LN214 1540 $LN212 1544 $LN202 1548 $LN213 154c $LN201 1550 $LN198 1554 $DEFAULT_LABEL$30013 15a8 $LN179 15ac $LN110 15b0 $LN53 15b4 $LN129 15b8 $LN55 15bc $LN111 15c0 $LN175 15c4 $LN128 15c8 $LN172 15cc $LN13"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 74 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 A0 8D 85 E0 FC FF FF 89 45 A4 C7 45 EC 00 00 00 00 C7 85 C4 FC FF FF 5E 01 00 00 C7 45 D8 00 00 00 00 C7 45 BC 00 00 00 00 C7 45 C8 00 00 00 00 C7 45 B0 00 00 00 00 33 C9 66 89 8D AC FC FF FF 33 D2 83 7D 08 00 0F 95 C2 89 95 A4 FC FF FF 83 BD A4 FC FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 B3 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD A4 FC FF FF 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 B3 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 62 14 00 00 8B 4D 0C 51 8D 8D B4 FC FF FF E8 ?? ?? ?? ?? C6 85 DF FC FF FF 00 0F BE 95 DF FC FF FF 89 55 F0 8B 45 F0 89 45 F4 8B 4D 08 0F B7 11 85 D2 0F 84 EC 13 00 00 6A 08 8B 45 08 0F B7 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 49 8B 55 F0 83 EA 01 89 55 F0 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 83 C2 02 89 55 08 8B 45 08 66 8B 08 66 89 4D B8 6A 08 0F B7 55 B8 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 DA EB 94 8B 45 08 0F B7 08 83 F9 25 0F 85 10 13 00 00 8B 55 08 0F B7 42 02 83 F8 25 0F 84 00 13 00 00 C7 85 A8 FC FF FF 00 00 00 00 33 C9 66 89 4D AC C7 85 D4 FC FF FF 00 00 00 00 8B 95 D4 FC FF FF 89 95 D8 FC FF FF 8B 85 D8 FC FF FF 89 45 B4 C6 45 FA 00 8A 4D FA 88 4D FB 8A 55 FB 88 55 E7 8A 45 E7 88 45 DE 8A 4D DE 88 4D D7 C6 85 B3 FC FF FF 00 C6 45 DF 01 C7 45 D0 00 00 00 00 0F BE 55 DE 85 D2 0F 85 1C 02 00 00 8B 45 08 83 C0 02 89 45 08 8B 4D 08 0F B7 11 89 55 C4 0F B7 45 C4 25 00 FF 00 00 75 3E 0F B7 4D C4 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 27 8B 95 D8 FC FF FF 83 C2 01 89 95 D8 FC FF FF 8B 45 B4 8B 4D B4 8D 14 81 8B 45 C4 8D 4C 50 D0 89 4D B4 E9 BC 01 00 00 8B 55 C4 89 95 90 FC FF FF 8B 85 90 FC FF FF 83 E8 2A 89 85 90 FC FF FF 83 BD 90 FC FF FF 4D 0F 87 8E 01 00 00 8B 8D 90 FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? E9 7E 01 00 00 8A 45 DF 2C 01 88 45 DF 8A 8D B3 FC FF FF 80 E9 01 88 8D B3 FC FF FF E9 62 01 00 00 8B 55 08 0F B7 42 02 83 F8 36 75 3C 8B 4D 08 0F B7 51 04 83 FA 34 75 30 8B 45 08 83 C0 04 89 45 08 8B 4D D0 83 C1 01 89 4D D0 C7 85 C8 FC FF FF 00 00 00 00 C7 85 CC FC FF FF 00 00 00 00 E9 1F 01 00 00 E9 8A 00 00 00 8B 55 08 0F B7 42 02 83 F8 33 75 1C 8B 4D 08 0F B7 51 04 83 FA 32 75 10 8B 45 08 83 C0 04 89 45 08 E9 F4 00 00 00 EB 62 8B 4D 08 0F B7 51 02 83 FA 64 74 30 8B 45 08 0F B7 48 02 83 F9 69 74 24 8B 55 08 0F B7 42 02 83 F8 6F 74 18 8B 4D 08 0F B7 51 02 83 FA 78 74 0C 8B 45 08 0F B7 48 02 83 F9 58 75 26 33 D2 74 1D 8B 45 D0 83 C0 01 89 45 D0 C7 85 C8 FC FF FF 00 00 00 00 C7 85 CC FC FF FF 00 00 00 00 E9 90 00 00 00 33 C9 74 1D 8B 55 D0 83 C2 01 89 55 D0 C7 85 C8 FC FF FF 00 00 00 00 C7 85 CC FC FF FF 00 00 00 00 EB 64 8A 45 DF 04 01 88 45 DF EB 63 8B 4D 08 0F B7 51 02 83 FA 6C 75 2A 8B 45 08 83 C0 02 89 45 08 8B 4D D0 83 C1 01 89 4D D0 C7 85 C8 FC FF FF 00 00 00 00 C7 85 CC FC FF FF 00 00 00 00 EB 2F EB 09 8A 55 DF 80 C2 01 88 55 DF 8A 85 B3 FC FF FF 04 01 88 85 B3 FC FF FF EB 14 8A 4D E7 80 C1 01 88 4D E7 EB 09 8A 55 DE 80 C2 01 88 55 DE E9 D8 FD FF FF 0F BE 45 E7 85 C0 75 1A 8B 4D 10 89 4D E0 8B 55 10 83 C2 04 89 55 10 8B 45 10 8B 48 FC 89 4D B0 EB 07 C7 45 B0 00 00 00 00 C6 45 DE 00 0F BE 95 B3 FC FF FF 85 D2 75 36 8B 45 08 0F B7 08 83 F9 53 74 0B 8B 55 08 0F B7 02 83 F8 43 75 11 8A 8D B3 FC FF FF 80 E9 01 88 8D B3 FC FF FF EB 0F 8A 95 B3 FC FF FF 80 C2 01 88 95 B3 FC FF FF 8B 45 08 0F B7 08 83 C9 20 89 4D C4 83 7D C4 6E 74 36 83 7D C4 63 74 1B 83 7D C4 7B 74 15 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF EB 15 8B 45 F0 83 C0 01 89 45 F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF 83 7D C4 6E 74 14 0F B7 8D AC FC FF FF 81 F9 FF FF 00 00 75 05 E9 1A 10 00 00 83 BD D8 FC FF FF 00 74 0A 83 7D B4 00 0F 84 72 0F 00 00 8B 55 C4 89 95 8C FC FF FF 8B 85 8C FC FF FF 83 E8 63 89 85 8C FC FF FF 83 BD 8C FC FF FF 18 0F 87 EE 0E 00 00 8B 8D 8C FC FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 83 BD D8 FC FF FF 00 75 18 8B 85 D8 FC FF FF 83 C0 01 89 85 D8 FC FF FF 8B 4D B4 83 C1 01 89 4D B4 0F BE 95 B3 FC FF FF 85 D2 7E 08 8A 45 D7 04 01 88 45 D7 E9 EE 01 00 00 0F BE 8D B3 FC FF FF 85 C9 7E 09 8A 55 D7 80 C2 01 88 55 D7 E9 D5 01 00 00 0F BE 85 B3 FC FF FF 85 C0 7E 09 8A 4D D7 80 C1 01 88 4D D7 8B 55 08 83 C2 02 89 55 08 8B 45 08 89 45 CC 8B 4D CC 0F B7 11 83 FA 5E 75 12 8B 45 CC 83 C0 02 89 45 CC 8A 4D FA 80 E9 01 88 4D FA 83 7D BC 00 75 2E 68 AB 02 00 00 68 ?? ?? ?? ?? 6A 02 68 00 20 00 00 E8 ?? ?? ?? ?? 83 C4 10 89 45 BC 83 7D BC 00 75 05 E9 0F 0F 00 00 C7 45 C8 01 00 00 00 68 00 20 00 00 6A 00 8B 55 BC 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D C4 7B 75 24 8B 45 CC 0F B7 08 83 F9 5D 75 19 BA 5D 00 00 00 66 89 55 AC 8B 45 CC 83 C0 02 89 45 CC 8B 4D BC C6 41 0B 20 8B 55 CC 0F B7 02 83 F8 5D 0F 84 FA 00 00 00 8B 4D CC 66 8B 11 66 89 55 A8 8B 45 CC 83 C0 02 89 45 CC 0F B7 4D A8 83 F9 2D 75 13 0F B7 55 AC 85 D2 74 0B 8B 45 CC 0F B7 08 83 F9 5D 75 38 66 8B 55 A8 66 89 55 AC 0F B7 45 AC C1 F8 03 0F B7 4D A8 83 E1 07 BA 01 00 00 00 D3 E2 8B 4D BC 0F BE 04 01 0B C2 0F B7 4D AC C1 F9 03 8B 55 BC 88 04 0A E9 8E 00 00 00 8B 45 CC 66 8B 08 66 89 4D A8 8B 55 CC 83 C2 02 89 55 CC 0F B7 45 AC 0F B7 4D A8 3B C1 7D 0A 66 8B 55 A8 66 89 55 E8 EB 10 66 8B 45 AC 66 89 45 E8 66 8B 4D A8 66 89 4D AC 66 8B 55 AC 66 89 55 A8 EB 0C 66 8B 45 A8 66 83 C0 01 66 89 45 A8 0F B7 4D A8 0F B7 55 E8 3B CA 7F 2D 0F B7 45 A8 C1 F8 03 0F B7 4D A8 83 E1 07 BA 01 00 00 00 D3 E2 8B 4D BC 0F BE 04 01 0B C2 0F B7 4D A8 C1 F9 03 8B 55 BC 88 04 0A EB BB 33 C0 66 89 45 AC E9 F7 FE FF FF 8B 4D CC 0F B7 11 85 D2 75 05 E9 B3 0D 00 00 83 7D C4 7B 75 06 8B 45 CC 89 45 08 8B 4D B0 89 4D C0 8B 55 F0 83 EA 01 89 55 F0 0F B7 85 AC FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 83 BD D8 FC FF FF 00 74 14 8B 4D B4 8B 55 B4 83 EA 01 89 55 B4 85 C9 0F 84 2E 01 00 00 8B 45 F0 83 C0 01 89 45 F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF 83 7D C4 63 74 64 83 7D C4 73 75 24 0F B7 8D AC FC FF FF 83 F9 09 7C 0C 0F B7 95 AC FC FF FF 83 FA 0D 7E 0C 0F B7 85 AC FC FF FF 83 F8 20 75 3A 83 7D C4 7B 0F 85 BF 00 00 00 0F B7 8D AC FC FF FF C1 F9 03 8B 55 BC 0F BE 04 0A 0F BE 4D FA 33 C1 0F B7 8D AC FC FF FF 83 E1 07 BA 01 00 00 00 D3 E2 23 C2 0F 84 8F 00 00 00 0F BE 45 E7 85 C0 75 7C 0F BE 4D D7 85 C9 74 18 8B 55 B0 66 8B 85 AC FC FF FF 66 89 02 8B 4D B0 83 C1 02 89 4D B0 EB 5A C7 85 A0 FC FF FF 00 00 00 00 6A 00 68 43 03 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 0F B7 95 AC FC FF FF 52 6A 05 8B 45 B0 50 8D 8D A0 FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 0C 8B 55 B0 03 95 A0 FC FF FF 89 55 B0 EB 09 8B 45 C0 83 C0 02 89 45 C0 EB 1B 8B 4D F0 83 E9 01 89 4D F0 0F B7 95 AC FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 EB 05 E9 B5 FE FF FF 8B 45 C0 3B 45 B0 74 31 0F BE 4D E7 85 C9 75 27 8B 55 F4 83 C2 01 89 55 F4 83 7D C4 63 74 18 0F BE 45 D7 85 C0 74 0A 33 C9 8B 55 B0 66 89 0A EB 06 8B 45 B0 C6 00 00 EB 05 E9 FF 0B 00 00 E9 54 0B 00 00 C7 45 C4 64 00 00 00 0F B7 8D AC FC FF FF 83 F9 2D 75 0D 8A 55 FB 80 C2 01 88 55 FB EB 0E EB 40 0F B7 85 AC FC FF FF 83 F8 2B 75 34 8B 4D B4 83 E9 01 89 4D B4 75 14 83 BD D8 FC FF FF 00 74 0B 8A 55 DE 80 C2 01 88 55 DE EB 15 8B 45 F0 83 C0 01 89 45 F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF 0F B7 8D AC FC FF FF 83 F9 30 0F 85 CC 00 00 00 8B 55 F0 83 C2 01 89 55 F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF 0F B7 85 AC FC FF FF 83 F8 78 74 0C 0F B7 8D AC FC FF FF 83 F9 58 75 3F 8B 55 F0 83 C2 01 89 55 F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF 83 BD D8 FC FF FF 00 74 18 8B 45 B4 83 E8 02 89 45 B4 83 7D B4 01 7D 09 8A 4D DE 80 C1 01 88 4D DE C7 45 C4 78 00 00 00 EB 60 8B 95 D4 FC FF FF 83 C2 01 89 95 D4 FC FF FF 83 7D C4 78 74 26 83 BD D8 FC FF FF 00 74 14 8B 45 B4 83 E8 01 89 45 B4 75 09 8A 4D DE 80 C1 01 88 4D DE C7 45 C4 6F 00 00 00 EB 25 8B 55 F0 83 EA 01 89 55 F0 0F B7 85 AC FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 B9 30 00 00 00 66 89 8D AC FC FF FF EB 5B C6 45 DF 01 0F B7 95 AC FC FF FF 83 FA 2D 75 0C 8A 45 FB 04 01 88 45 FB EB 0E EB 3F 0F B7 8D AC FC FF FF 83 F9 2B 75 33 8B 55 B4 83 EA 01 89 55 B4 75 13 83 BD D8 FC FF FF 00 74 0A 8A 45 DE 04 01 88 45 DE EB 15 8B 4D F0 83 C1 01 89 4D F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF 83 7D D0 00 0F 84 E8 01 00 00 0F BE 55 DE 85 D2 0F 85 B0 01 00 00 83 7D C4 78 74 06 83 7D C4 70 75 6D 0F B7 85 AC FC FF FF 25 00 FF 00 00 75 52 0F B7 8D AC FC FF FF 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 38 8B 85 C8 FC FF FF 8B 95 CC FC FF FF B1 04 E8 ?? ?? ?? ?? 89 85 C8 FC FF FF 89 95 CC FC FF FF 0F B7 95 AC FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF EB 08 8A 45 DE 04 01 88 45 DE E9 A8 00 00 00 0F B7 8D AC FC FF FF 81 E1 00 FF 00 00 0F 85 8C 00 00 00 0F B7 95 AC FC FF FF 81 E2 FF 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 72 83 7D C4 6F 75 38 0F B7 85 AC FC FF FF 83 F8 38 7D 21 8B 85 C8 FC FF FF 8B 95 CC FC FF FF B1 03 E8 ?? ?? ?? ?? 89 85 C8 FC FF FF 89 95 CC FC FF FF EB 09 8A 4D DE 80 C1 01 88 4D DE EB 32 8B 85 C8 FC FF FF 8B 95 CC FC FF FF B1 02 E8 ?? ?? ?? ?? 03 85 C8 FC FF FF 13 95 CC FC FF FF B1 01 E8 ?? ?? ?? ?? 89 85 C8 FC FF FF 89 95 CC FC FF FF EB 09 8A 55 DE 80 C2 01 88 55 DE 0F BE 45 DE 85 C0 75 69 8B 8D D4 FC FF FF 83 C1 01 89 8D D4 FC FF FF 0F B7 85 AC FC FF FF 83 E8 30 99 03 85 C8 FC FF FF 8B 8D CC FC FF FF 13 CA 89 85 C8 FC FF FF 89 8D CC FC FF FF 83 BD D8 FC FF FF 00 74 15 8B 55 B4 83 EA 01 89 55 B4 75 0A 8A 45 DE 04 01 88 45 DE EB 15 8B 4D F0 83 C1 01 89 4D F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF EB 19 8B 55 F0 83 EA 01 89 55 F0 0F B7 85 AC FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 E9 44 FE FF FF 0F BE 4D FB 85 C9 74 1F 8B 95 C8 FC FF FF F7 DA 8B 85 CC FC FF FF 83 D0 00 F7 D8 89 95 C8 FC FF FF 89 85 CC FC FF FF E9 82 01 00 00 0F BE 4D DE 85 C9 0F 85 60 01 00 00 83 7D C4 78 74 06 83 7D C4 70 75 5A 0F B7 95 AC FC FF FF 81 E2 00 FF 00 00 75 41 0F B7 85 AC FC FF FF 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 28 8B 8D A8 FC FF FF C1 E1 04 89 8D A8 FC FF FF 0F B7 95 AC FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 AC FC FF FF EB 08 8A 45 DE 04 01 88 45 DE EB 78 0F B7 8D AC FC FF FF 81 E1 00 FF 00 00 75 61 0F B7 95 AC FC FF FF 81 E2 FF 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 47 83 7D C4 6F 75 28 0F B7 85 AC FC FF FF 83 F8 38 7D 11 8B 8D A8 FC FF FF C1 E1 03 89 8D A8 FC FF FF EB 09 8A 55 DE 80 C2 01 88 55 DE EB 17 8B 85 A8 FC FF FF 8B 8D A8 FC FF FF 8D 14 81 D1 E2 89 95 A8 FC FF FF EB 08 8A 45 DE 04 01 88 45 DE 0F BE 4D DE 85 C9 75 5C 8B 95 D4 FC FF FF 83 C2 01 89 95 D4 FC FF FF 0F B7 85 AC FC FF FF 8B 8D A8 FC FF FF 8D 54 01 D0 89 95 A8 FC FF FF 83 BD D8 FC FF FF 00 74 16 8B 45 B4 83 E8 01 89 45 B4 75 0B 8A 4D DE 80 C1 01 88 4D DE EB 15 8B 55 F0 83 C2 01 89 55 F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF EB 19 8B 45 F0 83 E8 01 89 45 F0 0F B7 8D AC FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 E9 94 FE FF FF 0F BE 55 FB 85 D2 74 0E 8B 85 A8 FC FF FF F7 D8 89 85 A8 FC FF FF 83 7D C4 46 75 0A C7 85 D4 FC FF FF 00 00 00 00 83 BD D4 FC FF FF 00 74 51 0F BE 4D E7 85 C9 75 47 8B 55 F4 83 C2 01 89 55 F4 83 7D D0 00 74 16 8B 45 B0 8B 8D C8 FC FF FF 89 08 8B 95 CC FC FF FF 89 50 04 EB 22 0F BE 45 DF 85 C0 74 0D 8B 4D B0 8B 95 A8 FC FF FF 89 11 EB 0D 8B 45 B0 66 8B 8D A8 FC FF FF 66 89 08 EB 05 E9 7E 06 00 00 E9 D3 05 00 00 8B 55 F0 89 95 A8 FC FF FF 0F BE 45 E7 85 C0 75 02 EB A3 E9 BB 05 00 00 C7 45 EC 00 00 00 00 0F B7 8D AC FC FF FF 83 F9 2D 75 1C BA 2D 00 00 00 8B 45 EC 8B 4D A4 66 89 14 41 8B 55 EC 83 C2 01 89 55 EC EB 0E EB 2A 0F B7 85 AC FC FF FF 83 F8 2B 75 1E 8B 4D B4 83 E9 01 89 4D B4 8B 55 F0 83 C2 01 89 55 F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF 83 BD D8 FC FF FF 00 75 07 C7 45 B4 FF FF FF FF 0F B7 85 AC FC FF FF 25 00 FF 00 00 0F 85 99 00 00 00 0F B7 8D AC FC FF FF 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 7F 8B 55 B4 8B 45 B4 83 E8 01 89 45 B4 85 D2 74 6F 8B 8D D4 FC FF FF 83 C1 01 89 8D D4 FC FF FF 66 0F BE 95 AC FC FF FF 8B 45 EC 8B 4D A4 66 89 14 41 8B 55 EC 83 C2 01 89 55 EC 8D 45 D8 50 8D 8D E0 FC FF FF 51 8D 55 A4 52 8D 85 C4 FC FF FF 50 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 E9 67 05 00 00 8B 55 F0 83 C2 01 89 55 F0 E8 ?? ?? ?? ?? 66 89 85 AC FC FF FF E9 55 FF FF FF B8 2E 00 00 00 66 89 45 FC 8D 8D B4 FC FF FF E8 ?? ?? ?? ?? 50 8D 8D B4 FC FF FF E8 ?? ?? ?? ?? 8B 08 8B 91 AC 00 00 00 52 8D 85 B4 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 10 0F B7 45 FC 0F BE 8D AC FC FF FF 3B C1 0F 85 15 01 00 00 8B 55 B4 8B 45 B4 83 E8 01 89 45 B4 }
	condition:
		$1
}

rule file_204_7_0 {
	meta:
		name = "___check_float_string"
		size = 243
		refs = "0011 ??_C@_1DO@MBOKMJPK@?$AAn?$AAF?$AAl?$AAo?$AAa?$AAt?$AAS?$AAt?$AAr?$AAU?$AAs?$AAe?$AAd?$AA?$DM?$AA?$DN?$AA?$CI?$AA?$CK?$AAp?$AAn?$AAF?$AAl?$AAo?$AAa?$AAt?$AAS?$AAt?$AAr?$AAS?$AAz?$AA?$CJ?$AA?$AA@ 001d ??_C@_1FO@LDDBLKJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0024 __CrtDbgReportW 004f ??_C@_0CP@MMGCGBFO@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 005e __calloc_dbg 0092 _memcpy 00c2 __recalloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 8B 4D 08 3B 08 76 21 68 ?? ?? ?? ?? 6A 00 68 AF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 0C 8B 4D 08 3B 08 0F 85 AB 00 00 00 8B 55 10 8B 02 3B 45 14 75 5E 68 B4 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 8B 4D 0C 8B 11 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 10 89 01 8B 55 10 83 3A 00 75 04 33 C0 EB 79 8B 45 18 C7 00 01 00 00 00 8B 4D 0C 8B 11 D1 E2 52 8B 45 14 50 8B 4D 10 8B 11 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 8B 08 D1 E1 8B 55 0C 89 0A EB 43 68 BE 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 04 8B 45 0C 8B 08 51 8B 55 10 8B 02 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 75 04 33 C0 EB 19 8B 4D 10 8B 55 FC 89 11 8B 45 0C 8B 08 D1 E1 8B 55 0C 89 0A B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_8_0 {
	meta:
		name = "__INTRN_LOCALE_CONV"
		size = 23
		refs = "0009 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 E8 ?? ?? ?? ?? 8B 00 8B 80 BC 00 00 00 5D C3 }
	condition:
		$1
}

rule file_204_9_0 {
	meta:
		name = "__hextodec"
		size = 70
		refs = "001d _isdigit"
	strings:
		$1 = { 8B FF 55 8B EC 51 0F B7 45 08 25 00 FF 00 00 75 20 0F B7 4D 08 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 09 0F B7 55 08 89 55 FC EB 0D 0F B7 45 08 83 E0 DF 83 E8 07 89 45 FC 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_204_11_0 {
	meta:
		name = "__un_inc"
		size = 31
		refs = "0016 __ungetwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 08 3D FF FF 00 00 74 0D 0F B7 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_204_12_0 {
	meta:
		name = "__whiteout"
		size = 68
		refs = "0014 __inc 0031 _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 8B 08 83 C1 01 8B 55 08 89 0A E8 ?? ?? ?? ?? 66 89 45 FC 0F B7 45 FC 3D FF FF 00 00 75 02 EB 13 6A 08 0F B7 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 CA 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "__fpmath"
		size = 35
		refs = "0006 __cfltcvt_init 000b __ms_p5_mp_test_fdiv 0010 __adjust_fdiv 001b __setdefaultprecision"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 7D 08 00 74 05 E8 ?? ?? ?? ?? DB E2 5D C3 }
	condition:
		$1
}

rule file_206_2_0 {
	meta:
		name = "__cfltcvt_init"
		size = 107
		refs = "0007 __cfltcvt_tab 000b __cfltcvt 0015 __cropzeros 001f __fassign 0029 __forcdecpt 0033 __positive 0047 __cfltcvt_l 0051 __fassign_l 005b __cropzeros_l 0065 __forcdecpt_l"
	strings:
		$1 = { 8B FF 55 8B EC C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_206_3_0 {
	meta:
		name = "___setfflag"
		size = 30
		refs = "0007 ___fastflag"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_22_0 {
	meta:
		name = "__CrtSetAllocHook"
		size = 30
		refs = "0007 __pfnAllocHook"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_20_0 {
	meta:
		name = "__CrtSetBreakAlloc"
		size = 30
		refs = "0007 __crtBreakAlloc"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_59_0 {
	meta:
		name = "__CrtSetDebugFillThreshold"
		size = 30
		refs = "0007 ___crtDebugFillThreshold"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_32_0 {
	meta:
		name = "__CrtSetDumpClient"
		size = 30
		refs = "0007 ?_pfnDumpClient@@3P6AXPAXI@ZA"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_340_3_0 {
	meta:
		name = "__CrtSetReportHook"
		size = 30
		refs = "0007 __pfnReportHook"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_748_0_0 {
	meta:
		name = "__set_malloc_crt_max_wait"
		size = 30
		refs = "0007 __maxwait"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__wcreat"
		size = 73
		refs = "0023 __wsopen_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 FC FF FF FF FF 8B 45 0C 50 6A 40 68 02 03 00 00 8B 4D 08 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 75 08 8B 45 FC 89 45 F4 EB 07 C7 45 F4 FF FF FF FF 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_761_0_0 {
	meta:
		name = "__creat"
		size = 73
		refs = "0023 __sopen_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 FC FF FF FF FF 8B 45 0C 50 6A 40 68 02 03 00 00 8B 4D 08 51 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 75 08 8B 45 FC 89 45 F4 EB 07 C7 45 F4 FF FF FF FF 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "_bsearch_s"
		size = 558
		refs = "0047 ??_C@_1DC@HAGCIKOA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0050 ??_C@_1GC@ICJFPHNP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0057 __CrtDbgReportW 006b __errno 007f ??_C@_1BE@BBDJDLEB@?$AAb?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AA_?$AAs?$AA?$AA@ 0089 __invalid_parameter 00a6 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0109 ??_C@_1CA@OIBGFNKD@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 8B 45 0C 89 45 F8 8B 4D 10 83 E9 01 0F AF 4D 14 03 4D 0C 89 4D F0 83 7D 0C 00 75 0F 83 7D 10 00 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 55 DC 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 54 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 54 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 93 01 00 00 33 C9 3B 4D 14 1B D2 F7 DA 89 55 E4 75 1E 68 ?? ?? ?? ?? 6A 00 6A 55 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 55 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 34 01 00 00 33 C9 83 7D 18 00 0F 95 C1 89 4D E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 56 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 D1 00 00 00 8B 45 F8 3B 45 F0 0F 87 C3 00 00 00 8B 4D 10 D1 E9 89 4D F4 0F 84 89 00 00 00 8B 55 10 83 E2 01 74 08 8B 45 F4 89 45 D8 EB 09 8B 4D F4 83 E9 01 89 4D D8 8B 55 D8 0F AF 55 14 03 55 F8 89 55 FC 8B 45 FC 50 8B 4D 08 51 8B 55 1C 52 FF 55 18 83 C4 0C 89 45 EC 83 7D EC 00 75 07 8B 45 FC EB 71 EB 3F 83 7D EC 00 7D 2A 8B 45 FC 2B 45 14 89 45 F0 8B 4D 10 83 E1 01 74 08 8B 55 F4 89 55 D4 EB 09 8B 45 F4 83 E8 01 89 45 D4 8B 4D D4 89 4D 10 EB 0F 8B 55 FC 03 55 14 89 55 F8 8B 45 F4 89 45 10 EB 27 83 7D 10 00 74 1F 8B 4D F8 51 8B 55 08 52 8B 45 1C 50 FF 55 18 83 C4 0C F7 D8 1B C0 F7 D0 23 45 F8 EB 0B EB 02 EB 05 E9 31 FF FF FF 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__wstat32i64"
		size = 1485
		refs = "000c ___security_cookie 002f ??_C@_1BO@PCMLKEJK@?$AA?$CI?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 003b ??_C@_1FM@KAILGGHA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0042 __CrtDbgReportW 0059 ___doserrno 0064 __errno 007b ??_C@_1BI@MDFNINEI@?$AA_?$AAw?$AAs?$AAt?$AAa?$AAt?$AA3?$AA2?$AAi?$AA6?$AA4?$AA?$AA@ 0085 __invalid_parameter 00ad ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0113 ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 011c _wcspbrk 018c _towlower 01a2 __getdrive 01b9 __imp__FindFirstFileW@8 01db ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 0207 __wfullpath_helper 0225 _wcslen 0239 _IsRootUNCName 024d __imp__GetDriveTypeW@4 0267 _free 02dd ___loctotime32_t 032d __imp__FileTimeToLocalFileTime@8 0345 __imp__FileTimeToSystemTime@8 034f __imp__GetLastError@0 0355 __dosmaperr 0365 __imp__FindClose@4 0546 ___wdtoxmode 056f __allmul 05c5 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 90 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 33 C0 83 7D 08 00 0F 95 C0 89 85 90 FB FF FF 83 BD 90 FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 90 FB FF FF 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9E 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 2A 05 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 8C FB FF FF 83 BD 8C FB FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9F 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 8C FB FF FF 00 75 3C E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9F 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AC 04 00 00 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 79 04 00 00 8B 55 08 0F B7 42 02 83 F8 3A 75 50 8B 4D 08 0F B7 11 85 D2 74 29 8B 45 08 0F B7 48 04 85 C9 75 1E E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 3A 04 00 00 8B 55 08 0F B7 02 50 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C8 83 E9 60 89 8D 98 FB FF FF EB 0B E8 ?? ?? ?? ?? 89 85 98 FB FF FF 8D 95 A0 FB FF FF 52 8B 45 08 50 FF 15 ?? ?? ?? ?? 89 85 9C FB FF FF 83 BD 9C FB FF FF FF 0F 85 37 01 00 00 C7 85 88 FB FF FF 00 00 00 00 68 ?? ?? ?? ?? 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 67 8D 95 88 FB FF FF 52 68 04 01 00 00 8B 45 08 50 8D 8D F0 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 89 85 94 FB FF FF 83 BD 94 FB FF FF 00 74 39 8B 95 94 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 83 F8 03 74 13 8B 85 94 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 12 8B 8D 94 FB FF FF 51 FF 15 ?? ?? ?? ?? 83 F8 01 77 36 83 BD 88 FB FF FF 00 74 0F 8B 95 88 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? C7 00 02 00 00 00 83 C8 FF E9 32 03 00 00 83 BD 88 FB FF FF 00 74 0F 8B 85 88 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 C7 85 A0 FB FF FF 10 00 00 00 C7 85 BC FB FF FF 00 00 00 00 C7 85 C0 FB FF FF 00 00 00 00 33 C9 66 89 8D CC FB FF FF 6A FF 6A 00 6A 00 6A 00 6A 01 6A 01 68 BC 07 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 24 8B 45 0C 8B 4D 0C 8B 51 24 89 50 20 8B 45 0C 8B 4D 0C 8B 51 24 89 50 28 E9 33 02 00 00 83 BD B4 FB FF FF 00 75 0D 83 BD B8 FB FF FF 00 0F 84 96 00 00 00 8D 85 80 FB FF FF 50 8D 8D B4 FB FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 95 70 FB FF FF 52 8D 85 80 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 9C FB FF FF 51 FF 15 ?? ?? ?? ?? 83 C8 FF E9 4D 02 00 00 6A FF 0F B7 95 7C FB FF FF 52 0F B7 85 7A FB FF FF 50 0F B7 8D 78 FB FF FF 51 0F B7 95 76 FB FF FF 52 0F B7 85 72 FB FF FF 50 0F B7 8D 70 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 1C 8B 55 0C 89 42 24 EB 0A 8B 45 0C C7 40 24 00 00 00 00 83 BD AC FB FF FF 00 75 0D 83 BD B0 FB FF FF 00 0F 84 96 00 00 00 8D 8D 80 FB FF FF 51 8D 95 AC FB FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 85 70 FB FF FF 50 8D 8D 80 FB FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 95 9C FB FF FF 52 FF 15 ?? ?? ?? ?? 83 C8 FF E9 97 01 00 00 6A FF 0F B7 85 7C FB FF FF 50 0F B7 8D 7A FB FF FF 51 0F B7 95 78 FB FF FF 52 0F B7 85 76 FB FF FF 50 0F B7 8D 72 FB FF FF 51 0F B7 95 70 FB FF FF 52 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 20 EB 0C 8B 55 0C 8B 45 0C 8B 48 24 89 4A 20 83 BD A4 FB FF FF 00 75 0D 83 BD A8 FB FF FF 00 0F 84 96 00 00 00 8D 95 80 FB FF FF 52 8D 85 A4 FB FF FF 50 FF 15 ?? ?? ?? ?? 85 C0 74 18 8D 8D 70 FB FF FF 51 8D 95 80 FB FF FF 52 FF 15 ?? ?? ?? ?? 85 C0 75 24 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 85 9C FB FF FF 50 FF 15 ?? ?? ?? ?? 83 C8 FF E9 DF 00 00 00 6A FF 0F B7 8D 7C FB FF FF 51 0F B7 95 7A FB FF FF 52 0F B7 85 78 FB FF FF 50 0F B7 8D 76 FB FF FF 51 0F B7 95 72 FB FF FF 52 0F B7 85 70 FB FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 8B 4D 0C 89 41 28 EB 0C 8B 55 0C 8B 45 0C 8B 48 24 89 4A 28 8B 95 9C FB FF FF 52 FF 15 ?? ?? ?? ?? 8B 45 08 50 8B 8D A0 FB FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 0C 66 89 42 06 B8 01 00 00 00 8B 4D 0C 66 89 41 08 8B 95 BC FB FF FF 33 C0 6A 01 6A 00 50 52 E8 ?? ?? ?? ?? 8B 8D C0 FB FF FF 33 F6 03 C1 13 D6 8B 4D 0C 89 41 18 89 51 1C 33 D2 8B 45 0C 66 89 50 04 33 C9 8B 55 0C 66 89 4A 0C 33 C0 8B 4D 0C 66 89 41 0A 8B 95 98 FB FF FF 83 EA 01 8B 45 0C 89 10 8B 4D 0C 8B 55 0C 8B 02 89 41 10 33 C0 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "__wperror"
		size = 475
		refs = "0008 __sehtable$__wperror 000d __except_handler4 001f ___security_cookie 005d ??_C@_1GC@EOMLIFFN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0062 ??_C@_1BC@KGOJENED@?$AA_?$AAw?$AAp?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 0067 ??_C@_1HC@CBGLKNK@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$CI?$AA?5?$AA?$CG?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA0?$AA?$CJ?$AA?0?$AA?5@ 0081 _wcstombs_s 008a __invoke_watson_if_oneof 009a ??_C@_0DB@JFHIDFJP@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 00a7 __calloc_dbg 00cb ??_C@_1IA@FEEJJGPJ@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$CI?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA0?$AA?$CJ?$AA?0?$AA?5?$AAa?$AAm?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe@ 00ff __free_dbg 0119 ___lock_fhandle 0132 _strlen 0143 __write_nolock 014d ??_C@_02LMMGGCAJ@?3?5?$AA@ 016c __errno 0174 __get_sys_err_msg 019e ??_C@_01EEMJAFIK@?6?$AA@ 01c1 __unlock_fhandle"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 DC 02 00 00 00 C7 45 E0 00 00 00 00 83 7D 08 00 0F 84 C3 00 00 00 8B 45 08 0F B7 08 85 C9 0F 84 B5 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 68 FF FF FF 7F 8B 55 08 52 6A 00 6A 00 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 14 50 E8 ?? ?? ?? ?? 83 C4 20 83 7D E0 00 74 20 6A 3A 68 ?? ?? ?? ?? 6A 02 6A 01 8B 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 7D E4 00 75 05 E9 0D 01 00 00 6A 00 6A 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 6A FF 8B 55 08 52 8B 45 E0 50 8B 4D E4 51 6A 00 E8 ?? ?? ?? ?? 83 C4 14 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 13 6A 02 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 E9 BE 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 83 7D E4 00 74 30 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 50 8B 55 E4 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 02 68 ?? ?? ?? ?? 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 02 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 E8 ?? ?? ?? ?? 8B 00 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 8B 4D D8 51 E8 ?? ?? ?? ?? 83 C4 04 50 8B 55 D8 52 8B 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 68 ?? ?? ?? ?? 8B 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "__VEC_memzero"
		size = 143
		refs = "0032 _fastzero_I 007e __VEC_memzero"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 7D FC 8B 45 08 99 8B F8 33 FA 2B FA 83 E7 0F 33 FA 2B FA 85 FF 75 3C 8B 4D 10 8B D1 83 E2 7F 89 55 F4 3B CA 74 12 2B CA 51 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 8B 55 F4 85 D2 74 45 03 45 10 2B C2 89 45 F8 33 C0 8B 7D F8 8B 4D F4 F3 AA 8B 45 08 EB 2E F7 DF 83 C7 10 89 7D F0 33 C0 8B 7D 08 8B 4D F0 F3 AA 8B 45 F0 8B 4D 08 8B 55 10 03 C8 2B D0 52 6A 00 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 8B 7D FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_212_1_0 {
	meta:
		name = "_fastzero_I"
		size = 87
	strings:
		$1 = { 55 8B EC 83 EC 04 89 7D FC 8B 7D 08 8B 4D 0C C1 E9 07 66 0F EF C0 EB 08 8D A4 24 00 00 00 00 90 66 0F 7F 07 66 0F 7F 47 10 66 0F 7F 47 20 66 0F 7F 47 30 66 0F 7F 47 40 66 0F 7F 47 50 66 0F 7F 47 60 66 0F 7F 47 70 8D BF 80 00 00 00 49 75 D0 8B 7D FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "_malloc"
		size = 40
		refs = "000d __newmode 0017 __nh_malloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 00 6A 01 A1 ?? ?? ?? ?? 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "__mbsset_l"
		size = 405
		refs = "0016 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002d ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0036 ??_C@_1GA@FMKJAFAN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003d __CrtDbgReportW 0051 __errno 0065 ??_C@_1BE@KFCMNHGC@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAe?$AAt?$AA_?$AAl?$AA?$AA@ 006f __invalid_parameter 0081 ??1_LocaleUpdate@@QAE@XZ 0091 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 00a7 __strset 00ee ??_C@_1FC@MPDKGLLO@?$AA?$CI?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAp?$AAa?$AAi?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AAm?$AAb@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 8B 45 08 89 45 F8 8B 4D 10 51 8D 4D E8 E8 ?? ?? ?? ?? 33 D2 83 7D 08 00 0F 95 C2 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E0 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 E0 E9 04 01 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 23 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 D0 00 00 00 8B 4D 0C C1 E9 08 88 4D FF 0F B6 55 FF 85 D2 0F 84 8D 00 00 00 8B 45 0C 25 FF 00 00 00 88 45 FE 0F B6 4D FE 85 C9 75 37 33 D2 75 1E 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 16 00 00 00 C6 45 FF 20 8A 4D FF 88 4D FE 8B 55 08 0F B6 02 85 C0 74 37 8B 4D 08 8A 55 FF 88 11 8B 45 08 83 C0 01 89 45 08 8B 4D 08 0F B6 11 85 D2 74 13 8B 45 08 8A 4D FE 88 08 8B 55 08 83 C2 01 89 55 08 EB 07 8B 45 08 C6 40 FF 20 EB BF EB 1D 8B 4D 08 0F B6 11 85 D2 74 13 8B 45 08 8A 4D 0C 88 08 8B 55 08 83 C2 01 89 55 08 EB E3 8B 45 F8 89 45 D8 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "__swab"
		size = 393
		refs = "0023 ??_C@_1BE@KCHEPNFJ@?$AAs?$AAr?$AAc?$AA?$CB?$AA?$DN?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002c ??_C@_1FM@GNMBIMCM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0033 __CrtDbgReportW 0047 __errno 005b ??_C@_1M@CDKJLJII@?$AA_?$AAs?$AAw?$AAa?$AAb?$AA?$AA@ 0065 __invalid_parameter 0084 ??_C@_1BG@ILJBLDMK@?$AAd?$AAe?$AAs?$AAt?$AA?$CB?$AA?$DN?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00e5 ??_C@_1BE@KABAHFFM@?$AAn?$AAb?$AAy?$AAt?$AAe?$AAs?$AA?$DO?$AA?$DN?$AA0?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 C6 45 FE 00 C6 45 FF 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 14 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 B3 00 00 00 33 C9 83 7D 10 00 0F 9D C1 89 4D F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 28 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 55 83 7D 10 01 7E 4F 8B 45 08 8A 08 88 4D FE 8B 55 08 83 C2 01 89 55 08 8B 45 08 8A 08 88 4D FF 8B 55 08 83 C2 01 89 55 08 8B 45 0C 8A 4D FF 88 08 8B 55 0C 83 C2 01 89 55 0C 8B 45 0C 8A 4D FE 88 08 8B 55 0C 83 C2 01 89 55 0C 8B 45 10 83 E8 02 89 45 10 EB AB 8B E5 5D C3 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "_qsort_s"
		size = 1291
		refs = "0043 ??_C@_1DC@HAGCIKOA@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 004c ??_C@_1FO@NDBPJPLL@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0053 __CrtDbgReportW 006a __errno 007e ??_C@_1BA@PAHGIMFK@?$AAq?$AAs?$AAo?$AAr?$AAt?$AA_?$AAs?$AA?$AA@ 0088 __invalid_parameter 00a6 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0110 ??_C@_1BK@HJGMBFLF@?$AAc?$AAo?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01c7 _shortsort_s 0208 _swap_c"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 20 01 00 00 83 7D 08 00 75 12 83 7D 0C 00 74 0C C7 85 E0 FE FF FF 00 00 00 00 EB 0A C7 85 E0 FE FF FF 01 00 00 00 8B 85 E0 FE FF FF 89 85 EC FE FF FF 83 BD EC FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 72 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD EC FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 72 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 73 04 00 00 33 D2 3B 55 10 1B C0 F7 D8 89 85 E8 FE FF FF 75 1E 68 ?? ?? ?? ?? 6A 00 6A 73 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD E8 FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 73 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 10 04 00 00 33 D2 83 7D 14 00 0F 95 C2 89 95 E4 FE FF FF 83 BD E4 FE FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 74 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD E4 FE FF FF 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 74 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 A6 03 00 00 83 7D 0C 02 73 05 E9 9B 03 00 00 C7 85 78 FF FF FF 00 00 00 00 8B 4D 08 89 4D F8 8B 55 0C 83 EA 01 0F AF 55 10 03 55 08 89 95 F4 FE FF FF 8B 85 F4 FE FF FF 2B 45 F8 33 D2 F7 75 10 83 C0 01 89 85 74 FF FF FF 83 BD 74 FF FF FF 08 77 24 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 85 F4 FE FF FF 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 14 E9 FE 02 00 00 8B 95 74 FF FF FF D1 EA 0F AF 55 10 03 55 F8 89 55 FC 8B 45 FC 50 8B 4D F8 51 8B 55 18 52 FF 55 14 83 C4 0C 85 C0 7E 14 8B 45 10 50 8B 4D FC 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 F4 FE FF FF 50 8B 4D F8 51 8B 55 18 52 FF 55 14 83 C4 0C 85 C0 7E 17 8B 45 10 50 8B 8D F4 FE FF FF 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 F4 FE FF FF 50 8B 4D FC 51 8B 55 18 52 FF 55 14 83 C4 0C 85 C0 7E 17 8B 45 10 50 8B 8D F4 FE FF FF 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F8 89 85 7C FF FF FF 8B 8D F4 FE FF FF 89 8D F0 FE FF FF 8B 55 FC 3B 95 7C FF FF FF 76 33 8B 85 7C FF FF FF 03 45 10 89 85 7C FF FF FF 8B 8D 7C FF FF FF 3B 4D FC 73 19 8B 55 FC 52 8B 85 7C FF FF FF 50 8B 4D 18 51 FF 55 14 83 C4 0C 85 C0 7E CD 8B 55 FC 3B 95 7C FF FF FF 77 36 8B 85 7C FF FF FF 03 45 10 89 85 7C FF FF FF 8B 8D 7C FF FF FF 3B 8D F4 FE FF FF 77 19 8B 55 FC 52 8B 85 7C FF FF FF 50 8B 4D 18 51 FF 55 14 83 C4 0C 85 C0 7E CA 8B 95 F0 FE FF FF 2B 55 10 89 95 F0 FE FF FF 8B 85 F0 FE FF FF 3B 45 FC 76 19 8B 4D FC 51 8B 95 F0 FE FF FF 52 8B 45 18 50 FF 55 14 83 C4 0C 85 C0 7F CD 8B 8D F0 FE FF FF 3B 8D 7C FF FF FF 73 02 EB 33 8B 55 10 52 8B 85 F0 FE FF FF 50 8B 8D 7C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 3B 95 F0 FE FF FF 75 09 8B 85 7C FF FF FF 89 45 FC E9 0B FF FF FF 8B 8D F0 FE FF FF 03 4D 10 89 8D F0 FE FF FF 8B 55 FC 3B 95 F0 FE FF FF 73 33 8B 85 F0 FE FF FF 2B 45 10 89 85 F0 FE FF FF 8B 8D F0 FE FF FF 3B 4D FC 76 19 8B 55 FC 52 8B 85 F0 FE FF FF 50 8B 4D 18 51 FF 55 14 83 C4 0C 85 C0 74 CD 8B 55 FC 3B 95 F0 FE FF FF 72 33 8B 85 F0 FE FF FF 2B 45 10 89 85 F0 FE FF FF 8B 8D F0 FE FF FF 3B 4D F8 76 19 8B 55 FC 52 8B 85 F0 FE FF FF 50 8B 4D 18 51 FF 55 14 83 C4 0C 85 C0 74 CD 8B 95 F0 FE FF FF 2B 55 F8 8B 85 F4 FE FF FF 2B 85 7C FF FF FF 3B D0 7C 58 8B 4D F8 3B 8D F0 FE FF FF 73 2F 8B 95 78 FF FF FF 8B 45 F8 89 84 95 F8 FE FF FF 8B 8D 78 FF FF FF 8B 95 F0 FE FF FF 89 54 8D 80 8B 85 78 FF FF FF 83 C0 01 89 85 78 FF FF FF 8B 8D 7C FF FF FF 3B 8D F4 FE FF FF 73 0E 8B 95 7C FF FF FF 89 55 F8 E9 1C FD FF FF EB 5C 8B 85 7C FF FF FF 3B 85 F4 FE FF FF 73 32 8B 8D 78 FF FF FF 8B 95 7C FF FF FF 89 94 8D F8 FE FF FF 8B 85 78 FF FF FF 8B 8D F4 FE FF FF 89 4C 85 80 8B 95 78 FF FF FF 83 C2 01 89 95 78 FF FF FF 8B 45 F8 3B 85 F0 FE FF FF 73 11 8B 8D F0 FE FF FF 89 8D F4 FE FF FF E9 BE FC FF FF 8B 95 78 FF FF FF 83 EA 01 89 95 78 FF FF FF 78 25 8B 85 78 FF FF FF 8B 8C 85 F8 FE FF FF 89 4D F8 8B 95 78 FF FF FF 8B 44 95 80 89 85 F4 FE FF FF E9 88 FC FF FF 8B E5 5D C3 }
	condition:
		$1
}

rule file_216_1_0 {
	meta:
		name = "_shortsort_s"
		size = 115
		refs = "005d _swap_c"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 0C 3B 45 08 76 5F 8B 4D 08 89 4D F8 8B 55 08 03 55 10 89 55 FC EB 09 8B 45 FC 03 45 10 89 45 FC 8B 4D FC 3B 4D 0C 77 1E 8B 55 F8 52 8B 45 FC 50 8B 4D 18 51 FF 55 14 83 C4 0C 85 C0 7E 06 8B 55 FC 89 55 F8 EB D1 8B 45 10 50 8B 4D 0C 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 2B 45 10 89 45 0C EB 99 8B E5 5D C3 }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__mbccpy_s_l"
		size = 638
		refs = "0040 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0049 ??_C@_1GI@CGKJNHPF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0050 __CrtDbgReportW 0064 __errno 0078 ??_C@_1BI@BLONMAID@?$AA_?$AAm?$AAb?$AAc?$AAc?$AAp?$AAy?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0082 __invalid_parameter 00c0 ??_C@_1DE@MLEJGPLF@?$AA?$CI?$AAL?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAp?$AAa?$AAr?$AAa?$AAm?$AAe?$AAt?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 011b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0123 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0130 __ismbblead_l 0175 ??1_LocaleUpdate@@QAE@XZ 0192 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 01bb ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 83 7D 10 00 74 09 8B 45 10 C7 00 00 00 00 00 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 14 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 14 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 E7 01 00 00 83 7D 14 00 75 7A 8B 45 08 C6 00 00 33 C9 74 09 C7 45 D0 01 00 00 00 EB 07 C7 45 D0 00 00 00 00 8B 55 D0 89 55 E8 83 7D E8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 18 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 18 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 67 01 00 00 8B 4D 18 51 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 50 8B 55 14 0F B6 02 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 10 01 00 00 8B 4D 14 0F B6 51 01 85 D2 75 37 8B 45 08 C6 00 00 83 7D 10 00 74 09 8B 4D 10 C7 01 01 00 00 00 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 E0 2A 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 E9 F9 00 00 00 83 7D 0C 02 0F 83 8D 00 00 00 8B 55 08 C6 02 00 B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 55 CC 89 55 E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 2E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3A E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 2E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC 22 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 62 8B 4D 08 8B 55 14 8A 02 88 01 8B 4D 08 83 C1 01 89 4D 08 8B 55 14 83 C2 01 89 55 14 8B 45 08 8B 4D 14 8A 11 88 10 83 7D 10 00 74 09 8B 45 10 C7 00 02 00 00 00 EB 19 8B 4D 08 8B 55 14 8A 02 88 01 83 7D 10 00 74 09 8B 4D 10 C7 01 01 00 00 00 C7 45 D8 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_218_1_0 {
	meta:
		name = "__fullpath_dbg"
		size = 431
		refs = "0021 __getcwd 0043 __imp__GetFullPathNameA@16 0052 __imp__GetLastError@0 0058 __dosmaperr 0089 __errno 00ad __calloc_dbg 00e0 ??_C@_1BK@NOHKJANJ@?$AA?$CI?$AAm?$AAa?$AAx?$AAl?$AAe?$AAn?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00ec ??_C@_1GE@EJNCNJPK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00f3 __CrtDbgReportW 011e ??_C@_1BM@BMDEPKPP@?$AA_?$AAf?$AAu?$AAl?$AAl?$AAp?$AAa?$AAt?$AAh?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0128 __invalid_parameter 0165 _free"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 0C 00 74 0A 8B 45 0C 0F BE 08 85 C9 75 15 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 7E 01 00 00 83 7D 08 00 0F 85 9A 00 00 00 6A 00 6A 00 6A 00 8B 4D 0C 51 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 45 01 00 00 8B 55 10 3B 55 FC 76 08 8B 45 10 89 45 EC EB 06 8B 4D FC 89 4D EC 8B 55 EC 89 55 10 83 7D 10 FF 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 11 01 00 00 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 6A 01 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 75 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 DC 00 00 00 EB 68 33 C9 3B 4D 10 1B D2 F7 DA 89 55 F0 75 21 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 78 8B 4D 08 89 4D F4 8D 55 F8 52 8B 45 F4 50 8B 4D 10 51 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 FC 8B 45 FC 3B 45 10 72 23 83 7D 08 00 75 0C 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 EB 30 EB 2B 83 7D FC 00 75 25 83 7D 08 00 75 0C 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 EB 03 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "??_L@YGXPAXIHP6EX0@Z1@Z"
		size = 176
		refs = "0008 __sehtable$??_L@YGXPAXIHP6EX0@Z1@Z 000d __except_handler4 001f ___security_cookie 0097 ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 FC 00 00 00 00 C7 45 E4 00 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 3B 4D 10 7D 11 8B 4D 08 FF 55 14 8B 55 08 03 55 0C 89 55 08 EB DE C7 45 E0 01 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1C 83 7D E0 00 75 15 8B 45 18 50 8B 4D E4 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "__wexecl"
		size = 422
		refs = "001b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1FO@CDDEPOGG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BA@OIKBEHJF@?$AA_?$AAw?$AAe?$AAx?$AAe?$AAc?$AAl?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0142 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 019b __wexecve"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 83 7D 08 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 36 01 00 00 8B 55 08 0F B7 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D3 00 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 72 8B 4D 0C 0F B7 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 12 6A 00 8D 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_221_0_0 {
	meta:
		name = "__heapused"
		size = 20
		refs = "0006 __errno"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? C7 00 28 00 00 00 33 C0 5D C3 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__mbscspn_l"
		size = 554
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 002e _strcspn 003c ??1_LocaleUpdate@@QAE@XZ 005b ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0064 ??_C@_1GC@PKHAIBND@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 006b __CrtDbgReportW 007f __errno 0093 ??_C@_1BG@HJHJFBCP@?$AA_?$AAm?$AAb?$AAs?$AAc?$AAs?$AAp?$AAn?$AA_?$AAl?$AA?$AA@ 009d __invalid_parameter 00ce ??_C@_1CA@KMNJPEDI@?$AAc?$AAh?$AAa?$AAr?$AAs?$AAe?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 10 50 8D 4D E8 E8 ?? ?? ?? ?? 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 83 79 08 00 75 23 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 DC 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 DC E9 DE 01 00 00 33 C9 83 7D 08 00 0F 95 C1 89 4D E4 83 7D E4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 58 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 58 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D8 E9 6B 01 00 00 33 C0 83 7D 0C 00 0F 95 C0 89 45 E0 83 7D E0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 59 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 59 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 00 00 00 00 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D4 E9 F8 00 00 00 8B 55 08 89 55 F8 EB 09 8B 45 F8 83 C0 01 89 45 F8 8B 4D F8 0F B6 11 85 D2 0F 84 C5 00 00 00 8B 45 0C 89 45 FC EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 0F B6 02 85 C0 74 69 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 FC 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 3A 8B 55 FC 0F B6 02 8B 4D F8 0F B6 11 3B C2 75 12 8B 45 FC 0F B6 48 01 8B 55 F8 0F B6 42 01 3B C8 74 0B 8B 4D FC 0F B6 51 01 85 D2 75 02 EB 1F 8B 45 FC 83 C0 01 89 45 FC EB 12 8B 4D FC 0F B6 11 8B 45 F8 0F B6 08 3B D1 75 02 EB 02 EB 84 8B 55 FC 0F B6 02 85 C0 74 02 EB 35 8D 4D E8 E8 ?? ?? ?? ?? 8B 48 04 8B 55 F8 0F B6 02 0F B6 4C 01 1D 83 E1 04 74 15 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 0F B6 08 85 C9 75 02 EB 05 E9 24 FF FF FF 8B 55 F8 2B 55 08 89 55 D0 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "__towlower_l"
		size = 340
		refs = "0024 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002c ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0069 ??1_LocaleUpdate@@QAE@XZ 0093 __iswctype_l 011b ___crtLCMapStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 0F B7 45 08 3D FF FF 00 00 75 09 66 8B 45 08 E9 34 01 00 00 8B 4D 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 83 7A 14 00 75 3E 0F B7 45 08 83 F8 41 7C 15 0F B7 4D 08 83 F9 5A 7F 0C 0F B7 55 08 83 C2 20 89 55 DC EB 07 0F B7 45 08 89 45 DC 66 8B 4D DC 66 89 4D EA 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 EA E9 DA 00 00 00 0F B7 55 08 81 FA 00 01 00 00 7D 62 8D 4D F0 E8 ?? ?? ?? ?? 50 6A 01 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1B 66 8B 4D 08 66 89 4D E8 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 E8 E9 99 00 00 00 EB 2B 8D 4D F0 E8 ?? ?? ?? ?? 8B 10 0F B7 45 08 8B 8A CC 00 00 00 66 0F B6 14 01 66 89 55 E6 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 E6 EB 6C 8D 4D F0 E8 ?? ?? ?? ?? 8B 00 8B 48 04 51 6A 01 8D 55 EC 52 6A 01 8D 45 08 50 68 00 01 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 08 8B 51 14 52 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 16 66 8B 45 08 66 89 45 E4 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 E4 EB 14 66 8B 4D EC 66 89 4D E2 8D 4D F0 E8 ?? ?? ?? ?? 66 8B 45 E2 8B E5 5D C3 }
	condition:
		$1
}

rule file_225_4_0 {
	meta:
		name = "_towlower"
		size = 22
		refs = "000d __towlower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_882_4_0 {
	meta:
		name = "_towupper"
		size = 22
		refs = "000d __towupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__popen"
		size = 2913
		refs = "0008 __sehtable$__popen 000d __except_handler4 0022 ___security_cookie 00a7 ??_C@_1CI@KEGLLDHA@?$AA?$CI?$AAc?$AAm?$AAd?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 00b3 ??_C@_1FO@GHLFGGJE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00ba __CrtDbgReportW 00d1 __errno 00e8 ??_C@_1O@HEONKIBD@?$AA_?$AAp?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 00f2 __invalid_parameter 0119 ??_C@_1BO@FNGOKJKH@?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01ca ??_C@_1FG@PLKOLFIL@?$AA?$CI?$AA?$CI?$AA?$CK?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AAw?$AA?8?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA?$CK?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN@ 0296 ??_C@_1HG@CICOIJEK@?$AA?$CI?$AA?$CI?$AA?$CK?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA?$CK?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AAt@ 0345 __pipe 03a0 __mtinitlocknum 03b3 __close 03d3 __lock 03f9 __imp__GetCurrentProcess@0 043d ___pioinfo 044e __imp__DuplicateHandle@28 0495 __fdopen 04b3 _idtab 04e0 ??_C@_1OA@MCBDMINA@?$AA_?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ@ 04ee ??_C@_0CP@FGKFGAJD@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 04f5 ??_C@_07CFPBBAOO@COMSPEC?$AA@ 0503 __dupenv_s_dbg 050c __invoke_watson_if_oneof 0523 ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 053b _memset 05c0 _strlen 05ca ??_C@_04NPFIMJFF@?5?1c?5?$AA@ 0604 __calloc_dbg 0631 ??_C@_1FO@BAEKHEKF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn@ 0648 _strcpy_s 0651 __invoke_watson_if_error 066a ??_C@_1FO@GNCHDDLF@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn@ 0682 _strcat_s 06a4 ??_C@_1GE@LPBCCHLN@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAC?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AAL?$AAi?$AAn@ 06df __access_s 070b __imp__CreateProcessA@40 0762 __free_dbg 07b6 ??_C@_1NM@EFAKMOOB@?$AA_?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAP?$AAa?$AAt?$AAh?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK@ 07cb ??_C@_04HBHDLLBA@PATH?$AA@ 086a __getpath 08cc __mbsrchr 08ed ??_C@_1DC@INHIHLBE@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AA?$CC?$AA?2?$AA?2?$AA?$CC?$AA?$CJ?$AA?$AA@ 08f2 ??_C@_01KICIPPFI@?2?$AA@ 0994 ??_C@_1DG@DHDDFIJF@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAc?$AAm?$AAd?$AAe?$AAx?$AAe?$AA?$CJ?$AA?$AA@ 0a5b __imp__CloseHandle@4 0ac2 _fclose 0b41 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 81 C4 10 FF FF FF 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 85 58 FF FF FF 00 00 00 00 C7 85 2C FF FF FF 00 00 00 00 C7 85 30 FF FF FF 00 00 00 00 C7 85 54 FF FF FF 00 00 00 00 C7 85 38 FF FF FF 00 00 00 00 C6 45 D0 00 C6 45 D1 00 C6 45 D2 00 C7 85 50 FF FF FF 00 00 00 00 C7 45 E4 00 00 00 00 C7 85 78 FF FF FF 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 85 24 FF FF FF 83 BD 24 FF FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 93 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 24 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 93 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 4F 0A 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 95 20 FF FF FF 83 BD 20 FF FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 94 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 20 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 94 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 DD 09 00 00 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 0F BE 11 83 FA 77 74 17 8B 45 0C 0F BE 08 83 F9 72 74 0C C7 85 0C FF FF FF 00 00 00 00 EB 0A C7 85 0C FF FF FF 01 00 00 00 8B 95 0C FF FF FF 89 95 1C FF FF FF 83 BD 1C FF FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 9A 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 1C FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 9A 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 2C 09 00 00 8B 4D 0C 8A 11 88 55 D0 8B 45 0C 83 C0 01 89 45 0C 8B 4D 0C 0F BE 11 83 FA 20 75 0B 8B 45 0C 83 C0 01 89 45 0C EB EA 8B 4D 0C 0F BE 11 85 D2 74 22 8B 45 0C 0F BE 08 83 F9 74 74 17 8B 55 0C 0F BE 02 83 F8 62 74 0C C7 85 08 FF FF FF 00 00 00 00 EB 0A C7 85 08 FF FF FF 01 00 00 00 8B 8D 08 FF FF FF 89 8D 18 FF FF FF 83 BD 18 FF FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A1 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 18 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A1 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 60 08 00 00 8B 45 0C 8A 08 88 4D D1 0F BE 55 D1 83 FA 74 75 0C C7 85 58 FF FF FF 00 40 00 00 EB 13 0F BE 45 D1 83 F8 62 75 0A C7 85 58 FF FF FF 00 80 00 00 8B 8D 58 FF FF FF 81 C9 80 00 00 00 89 8D 58 FF FF FF 8B 95 58 FF FF FF 52 68 00 04 00 00 8D 85 40 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 05 E9 F3 07 00 00 0F BE 4D D0 83 F9 77 75 20 C7 85 5C FF FF FF 00 00 00 00 C7 85 6C FF FF FF 00 00 00 00 C7 85 28 FF FF FF 01 00 00 00 EB 1E C7 85 5C FF FF FF 01 00 00 00 C7 85 6C FF FF FF 01 00 00 00 C7 85 28 FF FF FF 00 00 00 00 6A 09 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 25 8B 95 40 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 85 44 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 7F 07 00 00 6A 09 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 C7 85 64 FF FF FF 01 00 00 00 8B 8D 64 FF FF FF 89 8D 60 FF FF FF FF 15 ?? ?? ?? ?? 89 85 74 FF FF FF 6A 02 6A 01 6A 00 8D 95 48 FF FF FF 52 8B 85 74 FF FF FF 50 8B 8D 6C FF FF FF 8B 94 8D 40 FF FF FF C1 FA 05 8B 85 6C FF FF FF 8B 8C 85 40 FF FF FF 83 E1 1F C1 E1 06 8B 14 95 ?? ?? ?? ?? 8B 04 0A 50 8B 8D 74 FF FF FF 51 FF 15 ?? ?? ?? ?? 85 C0 75 05 E9 89 06 00 00 8B 95 6C FF FF FF 8B 84 95 40 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 6C FF FF FF C7 84 8D 60 FF FF FF 00 00 00 00 8D 55 D0 52 8B 85 28 FF FF FF 8B 8C 85 40 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 2C FF FF FF 83 BD 2C FF FF FF 00 75 05 E9 34 06 00 00 6A 00 E8 ?? ?? ?? ?? 83 C4 04 89 85 4C FF FF FF 83 BD 4C FF FF FF 00 75 05 E9 EC 05 00 00 6A 00 68 F0 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 68 F0 00 00 00 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 00 8D 95 30 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 09 83 BD 30 FF FF FF 00 75 09 C7 45 CC ?? ?? ?? ?? EB 09 8B 85 30 FF FF FF 89 45 CC 6A 44 6A 00 8D 4D 80 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 80 44 00 00 00 C7 45 AC 00 01 00 00 83 BD 5C FF FF FF 00 75 0E 8B 95 48 FF FF FF 89 95 04 FF FF FF EB 0D A1 ?? ?? ?? ?? 8B 08 89 8D 04 FF FF FF 8B 95 04 FF FF FF 89 55 B8 83 BD 5C FF FF FF 01 75 0E 8B 85 48 FF FF FF 89 85 00 FF FF FF EB 0F 8B 0D ?? ?? ?? ?? 8B 51 40 89 95 00 FF FF FF 8B 85 00 FF FF FF 89 45 BC 8B 0D ?? ?? ?? ?? 8B 91 80 00 00 00 89 55 C0 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 03 F0 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8D 54 06 01 89 95 38 FF FF FF 68 0B 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 8B 85 38 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 68 FF FF FF 83 BD 68 FF FF FF 00 75 05 E9 9B 04 00 00 6A 00 68 0D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D CC 51 8B 95 38 FF FF FF 52 8B 85 68 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 0E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D 38 FF FF FF 51 8B 95 68 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 0F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 08 50 8B 8D 38 FF FF FF 51 8B 95 68 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? 8B 00 89 85 3C FF FF FF 6A 00 8B 4D CC 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 30 8D 55 D4 52 8D 45 80 50 6A 00 6A 00 6A 00 6A 01 6A 00 6A 00 8B 8D 68 FF FF FF 51 8B 55 CC 52 FF 15 ?? ?? ?? ?? 89 85 50 FF FF FF E9 0F 03 00 00 C7 85 10 FF FF FF 00 00 00 00 C7 85 14 FF FF FF 00 00 00 00 68 25 01 00 00 68 ?? ?? ?? ?? 6A 02 6A 01 68 04 01 00 00 E8 ?? ?? ?? ?? 83 C4 14 89 85 54 FF FF FF 83 BD 54 FF FF FF 00 75 4C 6A 02 8B 85 54 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 8D 68 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 95 30 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 CC 00 00 00 00 E8 ?? ?? ?? ?? 8B 8D 3C FF FF FF 89 08 E9 16 03 00 00 6A 00 68 2E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 68 2E 01 00 00 68 ?? ?? ?? ?? 6A 02 68 ?? ?? ?? ?? 6A 00 8D 95 10 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 5D 6A 02 8B 85 10 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 8D 54 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 95 68 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 C7 45 CC 00 00 00 00 E8 ?? ?? ?? ?? 8B 8D 3C FF FF FF 89 08 E9 70 02 00 00 8B 95 10 FF FF FF 89 95 7C FF FF FF 68 03 01 00 00 8B 85 54 FF FF FF 50 8B 8D 7C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 7C FF FF FF 83 BD 7C FF FF FF 00 0F 84 83 01 00 00 8B 95 54 FF FF FF 0F BE 02 85 C0 0F 84 72 01 00 00 8B 8D 54 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 95 54 FF FF FF 8D 44 02 FF 89 85 34 FF FF FF 8B 8D 34 FF FF FF 0F BE 11 83 FA 5C 75 53 6A 5C 8B 85 54 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 39 85 34 FF FF FF 74 38 6A 00 68 44 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 01 00 00 8B 8D 54 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 46 8B 95 34 FF FF FF 0F BE 02 83 F8 2F 74 38 6A 00 68 47 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 04 01 00 00 8B 8D 54 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 95 54 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 03 F0 81 FE 04 01 00 00 73 39 6A 00 68 52 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D CC 51 68 04 01 00 00 8B 95 54 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 02 EB 4A 6A 00 8B 85 54 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 30 8D 4D D4 51 8D 55 80 52 6A 00 6A 00 6A 00 6A 01 6A 00 6A 00 8B 85 68 FF FF FF 50 8B 8D 54 FF FF FF 51 FF 15 ?? ?? ?? ?? 89 85 50 FF FF FF EB 05 E9 4F FE FF FF 6A 02 8B 95 10 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 85 54 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 8D 68 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 95 30 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 CC 00 00 00 00 8B 85 48 FF FF FF 50 FF 15 ?? ?? ?? ?? 8B 4D D8 51 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 3C FF FF FF 89 10 83 BD 50 FF FF FF 00 74 0B 8B 45 D4 89 85 70 FF FF FF EB 02 EB 22 8B 8D 4C FF FF FF 8B 95 70 FF FF FF 89 51 04 8B 85 4C FF FF FF 8B 8D 2C FF FF FF 89 08 E9 82 00 00 00 8B 95 4C FF FF FF C7 02 00 00 00 00 8B 85 2C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 8B 8D 28 FF FF FF C7 84 8D 60 FF FF FF 00 00 00 00 C7 85 2C FF FF FF 00 00 00 00 8B 95 6C FF FF FF 83 BC 95 60 FF FF FF 00 74 16 8B 85 6C FF FF FF 8B 8C 85 40 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B 95 28 FF FF FF 83 BC 95 60 FF FF FF 00 74 16 8B 85 28 FF FF FF 8B 8C 85 40 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 09 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 85 2C FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_3_0 {
	meta:
		name = "__pclose"
		size = 386
		refs = "0008 __sehtable$__pclose 000d __except_handler4 001f ___security_cookie 004c ??_C@_1CE@LJKJAHN@?$AA?$CI?$AAp?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0058 ??_C@_1FO@GHLFGGJE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005f __CrtDbgReportW 0073 __errno 008a ??_C@_1BA@KDAKDIPO@?$AA_?$AAp?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?$AA@ 0094 __invalid_parameter 00a6 __mtinitlocknum 00bc __lock 00cf _idtab 00f1 _fclose 011b __cwait 0165 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 FF FF FF FF 33 C0 83 7D 08 00 0F 95 C0 89 45 D4 83 7D D4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 C8 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 C8 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CD 00 00 00 6A 09 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 08 83 C8 FF E9 B7 00 00 00 6A 09 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 83 7D DC 00 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 68 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 E8 ?? ?? ?? ?? 8B 08 89 4D D8 E8 ?? ?? ?? ?? C7 00 00 00 00 00 6A 01 8B 55 DC 8B 42 04 50 8D 4D E4 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 0A E8 ?? ?? ?? ?? 83 38 04 75 06 8B 55 E4 89 55 E0 E8 ?? ?? ?? ?? 8B 4D D8 89 08 8B 55 DC C7 02 00 00 00 00 8B 45 DC C7 40 04 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 09 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_226_4_0 {
	meta:
		name = "_idtab"
		size = 222
		refs = "0009 ___idpairs 001d ___idtabsiz 0086 ??_C@_0CP@FGKFGAJD@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 009f __recalloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 A1 ?? ?? ?? ?? 89 45 F8 EB 09 8B 4D F8 83 C1 08 89 4D F8 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 0C D0 39 4D F8 73 0E 8B 55 F8 8B 02 3B 45 08 75 02 EB 02 EB D6 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8D 04 CA 39 45 F8 73 08 8B 45 F8 E9 82 00 00 00 83 7D 08 00 75 51 8B 0D ?? ?? ?? ?? 83 C1 01 3B 0D ?? ?? ?? ?? 72 40 8B 15 ?? ?? ?? ?? 83 C2 01 81 FA FF FF FF 1F 73 2F 68 30 02 00 00 68 ?? ?? ?? ?? 6A 02 6A 08 A1 ?? ?? ?? ?? 83 C0 01 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 75 04 33 C0 EB 27 8B 55 FC 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 4D FC 8D 14 C1 89 55 F8 A1 ?? ?? ?? ?? 83 C0 01 A3 ?? ?? ?? ?? 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__lrotl"
		size = 45
		altNames = "__rotl"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 83 E0 1F 89 45 0C B9 20 00 00 00 2B 4D 0C 8B 55 08 D3 EA 8B 45 08 8B 4D 0C D3 E0 0B D0 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_228_1_0 {
	meta:
		name = "__tolower_l"
		size = 468
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0050 __isctype_l 006c __chvalidator_l 009a ??1_LocaleUpdate@@QAE@XZ 00e8 __isleadbyte_l 0116 __errno 016c ___crtLCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 8B 45 0C 50 8D 4D E4 E8 ?? ?? ?? ?? 81 7D 08 00 01 00 00 0F 83 9D 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 85 C0 74 2F 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 83 B9 AC 00 00 00 01 7E 1C 8D 4D E4 E8 ?? ?? ?? ?? 50 6A 01 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC EB 1A 6A 01 8B 45 08 50 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC 83 7D CC 00 74 2C 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 91 CC 00 00 00 8B 45 08 0F B6 0C 02 89 4D E0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 E0 E9 2A 01 00 00 EB 16 8B 55 08 89 55 DC 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 DC E9 12 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 00 83 B8 AC 00 00 00 01 7E 44 8D 4D E4 E8 ?? ?? ?? ?? 50 8B 4D 08 C1 F9 08 81 E1 FF 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 22 8B 55 08 C1 FA 08 81 E2 FF 00 00 00 88 55 F8 8A 45 08 88 45 F9 C6 45 FA 00 C7 45 F4 02 00 00 00 EB 1C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8A 4D 08 88 4D F8 C6 45 F9 00 C7 45 F4 01 00 00 00 6A 01 8D 4D E4 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 6A 03 8D 4D FC 51 8B 55 F4 52 8D 45 F8 50 68 00 01 00 00 8D 4D E4 E8 ?? ?? ?? ?? 8B 08 8B 51 14 52 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 24 89 45 F4 83 7D F4 00 75 13 8B 45 08 89 45 D8 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D8 EB 41 83 7D F4 01 75 16 0F B6 4D FC 89 4D D4 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D4 EB 27 EB 1D 0F B6 55 FD 0F B6 45 FC C1 E0 08 0B D0 89 55 D0 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 D0 EB 08 8D 4D E4 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_228_5_0 {
	meta:
		name = "_tolower"
		size = 69
		refs = "0008 ___locale_changed 003a __tolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 3D ?? ?? ?? ?? 00 75 24 83 7D 08 41 7C 11 83 7D 08 5A 7F 0B 8B 45 08 83 C0 20 89 45 FC EB 06 8B 4D 08 89 4D FC 8B 45 FC EB 10 EB 0E 6A 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_231_3_0 {
	meta:
		name = "__vcprintf_l"
		size = 4256
		refs = "000c ___security_cookie 0051 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0075 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0081 ??_C@_1GA@HHFOFBLN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0088 __CrtDbgReportW 009f __errno 00b6 ??_C@_1BI@OIKOBEIG@?$AA_?$AAv?$AAc?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAl?$AA?$AA@ 00c0 __invalid_parameter 00d5 ??1_LocaleUpdate@@QAE@XZ 015f ___lookuptable 01c3 $LN154 01d2 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 01e0 __isleadbyte_l 01ff _write_char 0230 ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 031c $LN150 0323 $LN155 0375 _get_int_arg 0432 $LN151 0439 $LN156 056f $LN152 0576 $LN157 05aa _get_short_arg 05d1 _wctomb_s 064c ___nullstring 0658 _strlen 0718 ___wnullstring 07e8 __get_printf_count_output 0824 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 0945 ??_C@_0DA@NFBEBPEE@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 0955 __malloc_dbg 09c8 __cfltcvt_tab 09ce __decode_pointer 0b06 _get_int64_arg 0cd3 __aullrem 0cf5 __aulldiv 0df9 _write_multi_char 0e10 _write_string 0f60 __free_dbg 0f93 @__security_check_cookie@4 0f9c $NORMAL_STATE$29395 0fa0 $LN130 0fa4 $LN129 0fa8 $LN121 0fac $LN117 0fb0 $LN116 0fb4 $LN112 0fb8 $LN96 0fbc $LN124 0fc0 $LN123 0fc4 $LN125 0fc8 $LN126 0fcc $LN122 0fd0 $LN127 0fe8 $LN106 0fec $LN98 0ff0 $LN109 0ff4 $LN97 0ff8 $LN110 102c $LN65 1030 $LN93 1034 $LN81 1038 $LN47 103c $LN87 1040 $LN64 1044 $LN91 1048 $LN52 104c $LN70 1050 $LN42 1054 $LN48 1058 $LN79 105c $LN50 1060 $LN45 1064 $LN94"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC F4 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 B8 C7 85 A0 FD FF FF 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 E8 00 00 00 00 C7 45 D0 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 D8 00 00 00 00 C7 45 F4 00 00 00 00 8B 45 0C 50 8D 4D C0 E8 ?? ?? ?? ?? C7 45 E0 00 00 00 00 33 C9 83 7D 08 00 0F 95 C1 89 8D 9C FD FF FF 83 BD 9C FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 9C FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 07 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 38 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 38 FD FF FF E9 A9 0E 00 00 C7 85 B4 FD FF FF 00 00 00 00 C7 45 DC 00 00 00 00 C7 85 A4 FD FF FF 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 BC 00 00 00 00 8B 45 08 8A 08 88 8D AF FD FF FF 0F BE 95 AF FD FF FF 8B 45 08 83 C0 01 89 45 08 85 D2 0F 84 43 0E 00 00 83 BD B4 FD FF FF 00 0F 8C 36 0E 00 00 0F BE 8D AF FD FF FF 83 F9 20 7C 25 0F BE 95 AF FD FF FF 83 FA 78 7F 19 0F BE 85 AF FD FF FF 0F BE 88 ?? ?? ?? ?? 83 E1 0F 89 8D 28 FD FF FF EB 0A C7 85 28 FD FF FF 00 00 00 00 8B 95 28 FD FF FF 89 95 B0 FD FF FF 8B 85 B0 FD FF FF 8B 8D A4 FD FF FF 0F BE 94 C1 ?? ?? ?? ?? C1 FA 04 89 95 A4 FD FF FF 8B 85 A4 FD FF FF 89 85 24 FD FF FF 83 BD 24 FD FF FF 07 0F 87 B4 0D 00 00 8B 8D 24 FD FF FF FF 24 8D ?? ?? ?? ?? C7 45 F4 00 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 50 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 B0 00 00 00 8D 85 B4 FD FF FF 50 0F B6 8D AF FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8A 02 88 85 AF FD FF FF 8B 4D 08 83 C1 01 89 4D 08 0F BE 95 AF FD FF FF F7 DA 1B D2 F7 DA 89 95 98 FD FF FF 75 21 68 ?? ?? ?? ?? 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 98 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 34 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 34 FD FF FF E9 EE 0C 00 00 8D 8D B4 FD FF FF 51 0F B6 95 AF FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 E9 B3 0C 00 00 C7 45 D4 00 00 00 00 8B 45 D4 89 45 D8 8B 4D D8 89 4D E8 8B 55 E8 89 55 E4 C7 45 F0 00 00 00 00 C7 45 D0 FF FF FF FF C7 45 F4 00 00 00 00 E9 80 0C 00 00 0F BE 85 AF FD FF FF 89 85 20 FD FF FF 8B 8D 20 FD FF FF 83 E9 20 89 8D 20 FD FF FF 83 BD 20 FD FF FF 10 77 4C 8B 95 20 FD FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D F0 83 C9 04 89 4D F0 EB 2D 8B 55 F0 83 CA 01 89 55 F0 EB 22 8B 45 F0 83 C8 02 89 45 F0 EB 17 8B 4D F0 81 C9 80 00 00 00 89 4D F0 EB 09 8B 55 F0 83 CA 08 89 55 F0 E9 0A 0C 00 00 0F BE 85 AF FD FF FF 83 F8 2A 75 28 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 E8 83 7D E8 00 7D 11 8B 55 F0 83 CA 04 89 55 F0 8B 45 E8 F7 D8 89 45 E8 EB 14 8B 4D E8 6B C9 0A 0F BE 95 AF FD FF FF 8D 44 11 D0 89 45 E8 E9 BD 0B 00 00 C7 45 D0 00 00 00 00 E9 B1 0B 00 00 0F BE 8D AF FD FF FF 83 F9 2A 75 1E 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 D0 83 7D D0 00 7D 07 C7 45 D0 FF FF FF FF EB 14 8B 45 D0 6B C0 0A 0F BE 8D AF FD FF FF 8D 54 08 D0 89 55 D0 E9 6E 0B 00 00 0F BE 85 AF FD FF FF 89 85 1C FD FF FF 8B 8D 1C FD FF FF 83 E9 49 89 8D 1C FD FF FF 83 BD 1C FD FF FF 2E 0F 87 0F 01 00 00 8B 95 1C FD FF FF 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 08 0F BE 11 83 FA 6C 75 17 8B 45 08 83 C0 01 89 45 08 8B 4D F0 81 C9 00 10 00 00 89 4D F0 EB 09 8B 55 F0 83 CA 10 89 55 F0 E9 CB 00 00 00 8B 45 08 0F BE 08 83 F9 36 75 26 8B 55 08 0F BE 42 01 83 F8 34 75 1A 8B 4D 08 83 C1 02 89 4D 08 8B 55 F0 81 CA 00 80 00 00 89 55 F0 E9 81 00 00 00 8B 45 08 0F BE 08 83 F9 33 75 23 8B 55 08 0F BE 42 01 83 F8 32 75 17 8B 4D 08 83 C1 02 89 4D 08 8B 55 F0 81 E2 FF 7F FF FF 89 55 F0 EB 53 8B 45 08 0F BE 08 83 F9 64 74 37 8B 55 08 0F BE 02 83 F8 69 74 2C 8B 4D 08 0F BE 11 83 FA 6F 74 21 8B 45 08 0F BE 08 83 F9 75 74 16 8B 55 08 0F BE 02 83 F8 78 74 0B 8B 4D 08 0F BE 11 83 FA 58 75 02 EB 0F C7 85 A4 FD FF FF 00 00 00 00 E9 A8 FC FF FF EB 17 8B 45 F0 83 C8 20 89 45 F0 EB 0C 8B 4D F0 81 C9 00 08 00 00 89 4D F0 E9 31 0A 00 00 0F BE 95 AF FD FF FF 89 95 18 FD FF FF 8B 85 18 FD FF FF 83 E8 41 89 85 18 FD FF FF 83 BD 18 FD FF FF 37 0F 87 19 08 00 00 8B 8D 18 FD FF FF 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 F0 25 30 08 00 00 75 0C 8B 4D F0 81 C9 00 08 00 00 89 4D F0 8B 55 F0 81 E2 10 08 00 00 74 55 C7 85 94 FD FF FF 00 00 00 00 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 A8 FD FF FF 0F B7 8D A8 FD FF FF 51 68 00 02 00 00 8D 95 B8 FD FF FF 52 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 94 FD FF FF 83 BD 94 FD FF FF 00 74 07 C7 45 D8 01 00 00 00 EB 26 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 85 90 FD FF FF 8A 95 90 FD FF FF 88 95 B8 FD FF FF C7 45 DC 01 00 00 00 8D 85 B8 FD FF FF 89 45 FC E9 5B 07 00 00 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 8C FD FF FF 83 BD 8C FD FF FF 00 74 0C 8B 95 8C FD FF FF 83 7A 04 00 75 19 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC EB 50 8B 55 F0 81 E2 00 08 00 00 74 26 8B 85 8C FD FF FF 8B 48 04 89 4D FC 8B 95 8C FD FF FF 0F BF 02 99 2B C2 D1 F8 89 45 DC C7 45 F4 01 00 00 00 EB 1F C7 45 F4 00 00 00 00 8B 85 8C FD FF FF 8B 48 04 89 4D FC 8B 95 8C FD FF FF 0F BF 02 89 45 DC E9 C6 06 00 00 8B 4D F0 81 E1 30 08 00 00 75 0C 8B 55 F0 81 CA 00 08 00 00 89 55 F0 83 7D D0 FF 75 0C C7 85 14 FD FF FF FF FF FF 7F EB 09 8B 45 D0 89 85 14 FD FF FF 8B 8D 14 FD FF FF 89 8D 84 FD FF FF 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 45 F0 25 10 08 00 00 74 66 83 7D FC 00 75 09 8B 0D ?? ?? ?? ?? 89 4D FC C7 45 F4 01 00 00 00 8B 55 FC 89 95 80 FD FF FF 8B 85 84 FD FF FF 8B 8D 84 FD FF FF 83 E9 01 89 8D 84 FD FF FF 85 C0 74 1E 8B 95 80 FD FF FF 0F B7 02 85 C0 74 11 8B 8D 80 FD FF FF 83 C1 02 89 8D 80 FD FF FF EB C9 8B 95 80 FD FF FF 2B 55 FC D1 FA 89 55 DC EB 5A 83 7D FC 00 75 08 A1 ?? ?? ?? ?? 89 45 FC 8B 4D FC 89 8D 88 FD FF FF 8B 95 84 FD FF FF 8B 85 84 FD FF FF 83 E8 01 89 85 84 FD FF FF 85 D2 74 1E 8B 8D 88 FD FF FF 0F BE 11 85 D2 74 11 8B 85 88 FD FF FF 83 C0 01 89 85 88 FD FF FF EB C9 8B 8D 88 FD FF FF 2B 4D FC 89 4D DC E9 AA 05 00 00 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 7C FD FF FF E8 ?? ?? ?? ?? 85 C0 0F 85 A4 00 00 00 33 C0 74 0C C7 85 10 FD FF FF 01 00 00 00 EB 0A C7 85 10 FD FF FF 00 00 00 00 8B 8D 10 FD FF FF 89 8D 78 FD FF FF 83 BD 78 FD FF FF 00 75 21 68 ?? ?? ?? ?? 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD 78 FD FF FF 00 75 46 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 95 06 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 85 30 FD FF FF FF FF FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 30 FD FF FF E9 FA 06 00 00 E9 E7 04 00 00 8B 45 F0 83 E0 20 74 12 8B 8D 7C FD FF FF 66 8B 95 B4 FD FF FF 66 89 11 EB 0E 8B 85 7C FD FF FF 8B 8D B4 FD FF FF 89 08 C7 45 D8 01 00 00 00 E9 B3 04 00 00 C7 45 D4 01 00 00 00 0F BE 95 AF FD FF FF 83 C2 20 88 95 AF FD FF FF 8B 45 F0 83 C8 40 89 45 F0 8D 8D B8 FD FF FF 89 4D FC C7 45 BC 00 02 00 00 83 7D D0 00 7D 09 C7 45 D0 06 00 00 00 EB 2B 83 7D D0 00 75 15 0F BE 95 AF FD FF FF 83 FA 67 75 09 C7 45 D0 01 00 00 00 EB 10 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 81 7D D0 A3 00 00 00 7E 41 68 DA 06 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 D0 05 5D 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 83 7D E0 00 74 14 8B 4D E0 89 4D FC 8B 55 D0 81 C2 5D 01 00 00 89 55 BC EB 07 C7 45 D0 A3 00 00 00 8B 45 10 83 C0 08 89 45 10 8B 4D 10 8B 51 F8 8B 41 FC 89 95 70 FD FF FF 89 85 74 FD FF FF 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 4D D4 51 8B 55 D0 52 0F BE 85 AF FD FF FF 50 8B 4D BC 51 8B 55 FC 52 8D 85 70 FD FF FF 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 1C 8B 55 F0 81 E2 80 00 00 00 74 27 83 7D D0 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 45 FC 50 8B 0D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 0F BE 95 AF FD FF FF 83 FA 67 75 2B 8B 45 F0 25 80 00 00 00 75 21 8D 4D C0 E8 ?? ?? ?? ?? 50 8B 4D FC 51 8B 15 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 04 FF D0 83 C4 08 8B 45 FC 0F BE 08 83 F9 2D 75 15 8B 55 F0 81 CA 00 01 00 00 89 55 F0 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC E9 08 03 00 00 8B 55 F0 83 CA 40 89 55 F0 C7 45 F8 0A 00 00 00 EB 6D C7 45 F8 0A 00 00 00 EB 64 C7 45 D0 08 00 00 00 C7 85 A0 FD FF FF 07 00 00 00 EB 0A C7 85 A0 FD FF FF 27 00 00 00 C7 45 F8 10 00 00 00 8B 45 F0 25 80 00 00 00 74 17 C6 45 EC 30 8B 8D A0 FD FF FF 83 C1 51 88 4D ED C7 45 E4 02 00 00 00 EB 1D C7 45 F8 08 00 00 00 8B 55 F0 81 E2 80 00 00 00 74 0B 8B 45 F0 0D 00 02 00 00 89 45 F0 8B 4D F0 81 E1 00 80 00 00 74 1D 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 60 FD FF FF 89 95 64 FD FF FF E9 AE 00 00 00 8B 45 F0 25 00 10 00 00 74 1D 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 89 85 60 FD FF FF 89 95 64 FD FF FF E9 87 00 00 00 8B 55 F0 83 E2 20 74 42 8B 45 F0 83 E0 40 74 1C 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 98 99 89 85 60 FD FF FF 89 95 64 FD FF FF EB 1C 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 99 89 85 60 FD FF FF 89 95 64 FD FF FF EB 3D 8B 45 F0 83 E0 40 74 1B 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 99 89 85 60 FD FF FF 89 95 64 FD FF FF EB 1A 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 33 C9 89 85 60 FD FF FF 89 8D 64 FD FF FF 8B 55 F0 83 E2 40 74 41 83 BD 64 FD FF FF 00 7F 38 7C 09 83 BD 60 FD FF FF 00 73 2D 8B 85 60 FD FF FF F7 D8 8B 8D 64 FD FF FF 83 D1 00 F7 D9 89 85 58 FD FF FF 89 8D 5C FD FF FF 8B 55 F0 81 CA 00 01 00 00 89 55 F0 EB 18 8B 85 60 FD FF FF 89 85 58 FD FF FF 8B 8D 64 FD FF FF 89 8D 5C FD FF FF 8B 55 F0 81 E2 00 80 00 00 75 25 8B 45 F0 25 00 10 00 00 75 1B 8B 8D 58 FD FF FF 8B 95 5C FD FF FF 83 E2 00 89 8D 58 FD FF FF 89 95 5C FD FF FF 83 7D D0 00 7D 09 C7 45 D0 01 00 00 00 EB 19 8B 45 F0 83 E0 F7 89 45 F0 81 7D D0 00 02 00 00 7E 07 C7 45 D0 00 02 00 00 8B 8D 58 FD FF FF 0B 8D 5C FD FF FF 75 07 C7 45 E4 00 00 00 00 8D 55 B7 89 55 FC 8B 45 D0 8B 4D D0 83 E9 01 89 4D D0 85 C0 7F 0E 8B 95 58 FD FF FF 0B 95 5C FD FF FF 74 7B 8B 45 F8 99 52 50 8B 85 5C FD FF FF 50 8B 8D 58 FD FF FF 51 E8 ?? ?? ?? ?? 83 C0 30 89 85 6C FD FF FF 8B 45 F8 99 52 50 8B 95 5C FD FF FF 52 8B 85 58 FD FF FF 50 E8 ?? ?? ?? ?? 89 85 58 FD FF FF 89 95 5C FD FF FF 83 BD 6C FD FF FF 39 7E 12 8B 8D 6C FD FF FF 03 8D A0 FD FF FF 89 8D 6C FD FF FF 8B 55 FC 8A 85 6C FD FF FF 88 02 8B 4D FC 83 E9 01 89 4D FC E9 67 FF FF FF 8D 55 B7 2B 55 FC 89 55 DC 8B 45 FC 83 C0 01 89 45 FC 8B 4D F0 81 E1 00 02 00 00 74 29 83 7D DC 00 74 0B 8B 55 FC 0F BE 02 83 F8 30 74 18 8B 4D FC 83 E9 01 89 4D FC 8B 55 FC C6 02 30 8B 45 DC 83 C0 01 89 45 DC 83 7D D8 00 0F 85 CA 01 00 00 8B 4D F0 83 E1 40 74 40 8B 55 F0 81 E2 00 01 00 00 74 0D C6 45 EC 2D C7 45 E4 01 00 00 00 EB 28 8B 45 F0 83 E0 01 74 0D C6 45 EC 2B C7 45 E4 01 00 00 00 EB 13 8B 4D F0 83 E1 02 74 0B C6 45 EC 20 C7 45 E4 01 00 00 00 8B 55 E8 2B 55 DC 2B 55 E4 89 95 54 FD FF FF 8B 45 F0 83 E0 0C 75 18 8D 8D B4 FD FF FF 51 8B 95 54 FD FF FF 52 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 8D 85 B4 FD FF FF 50 8B 4D E4 51 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F0 83 E0 08 74 20 8B 4D F0 83 E1 04 75 18 8D 95 B4 FD FF FF 52 8B 85 54 FD FF FF 50 6A 30 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F4 00 0F 84 CA 00 00 00 83 7D DC 00 0F 8E C0 00 00 00 C7 85 3C FD FF FF 00 00 00 00 8B 4D FC 89 8D 50 FD FF FF 8B 55 DC 89 95 4C FD FF FF 8B 85 4C FD FF FF 8B 8D 4C FD FF FF 83 E9 01 89 8D 4C FD FF FF 85 C0 0F 84 85 00 00 00 8B 95 50 FD FF FF 66 8B 02 66 89 85 0E FD FF FF 0F B7 8D 0E FD FF FF 51 6A 06 8D 95 40 FD FF FF 52 8D 85 48 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 89 85 3C FD FF FF 8B 8D 50 FD FF FF 83 C1 02 89 8D 50 FD FF FF 83 BD 3C FD FF FF 00 75 09 83 BD 48 FD FF FF 00 75 0C C7 85 B4 FD FF FF FF FF FF FF EB 22 8D 95 B4 FD FF FF 52 8B 85 48 FD FF FF 50 8D 8D 40 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C E9 5E FF FF FF EB 17 8D 95 B4 FD FF FF 52 8B 45 DC 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 83 BD B4 FD FF FF 00 7C 20 8B 55 F0 83 E2 04 74 18 8D 85 B4 FD FF FF 50 8B 8D 54 FD FF FF 51 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 83 7D E0 00 74 15 6A 02 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 E0 00 00 00 00 E9 9A F1 FF FF 8B 85 B4 FD FF FF 89 85 2C FD FF FF 8D 4D C0 E8 ?? ?? ?? ?? 8B 85 2C FD FF FF 8B 4D B8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 05 05 01 05 05 05 05 05 05 05 02 05 03 05 05 04 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 04 04 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "_setvbuf"
		size = 720
		refs = "0008 __sehtable$_setvbuf 000d __except_handler4 001f ___security_cookie 004c ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0055 ??_C@_1GC@FPPJLAOD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005c __CrtDbgReportW 0070 __errno 0084 ??_C@_1BA@OGODIODK@?$AAs?$AAe?$AAt?$AAv?$AAb?$AAu?$AAf?$AA?$AA@ 008e __invalid_parameter 00cc ??_C@_1HC@CBFEDAGG@?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAI?$AAO?$AAN?$AAB?$AAF?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAI?$AAO@ 0155 ??_C@_1EG@IJNJIDNB@?$AA?$CI?$AA?$CI?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX@ 01ba __lock_file 01cd __flush 01d9 __freebuf 0223 ??_C@_0DB@MIGHMKAN@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 022e __malloc_dbg 0240 __cflush 02b3 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 DC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 DC 83 7D DC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 21 02 00 00 83 7D 10 04 74 15 83 7D 10 00 74 0F 83 7D 10 40 74 09 C7 45 D0 00 00 00 00 EB 07 C7 45 D0 01 00 00 00 8B 55 D0 89 55 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A1 01 00 00 83 7D 10 00 74 06 83 7D 10 40 75 7D 83 7D 14 02 72 12 81 7D 14 FF FF FF 7F 77 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D D4 83 7D D4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 18 01 00 00 8B 45 14 83 E0 FE 89 45 14 8B 4D 08 89 4D E4 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 E4 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 E4 8B 42 0C 25 F3 C2 FF FF 8B 4D E4 89 41 0C 8B 55 10 83 E2 04 74 21 8B 45 E4 8B 48 0C 83 C9 04 8B 55 E4 89 4A 0C 8B 45 E4 83 C0 14 89 45 0C C7 45 14 02 00 00 00 EB 62 83 7D 0C 00 75 4A 6A 78 68 ?? ?? ?? ?? 6A 02 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 0C 83 7D 0C 00 75 18 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? C7 45 E0 FF FF FF FF EB 4A 8B 45 E4 8B 48 0C 81 C9 08 04 00 00 8B 55 E4 89 4A 0C EB 12 8B 45 E4 8B 48 0C 81 C9 00 05 00 00 8B 55 E4 89 4A 0C 8B 45 E4 8B 4D 14 89 48 18 8B 55 E4 8B 45 0C 89 42 08 8B 4D E4 8B 55 0C 89 11 8B 45 E4 C7 40 04 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "__j0"
		size = 274
		refs = "001e __real@401e000000000000 002f _J0q 0036 _J0p 0047 _evaluate 005a __real@4020000000000000 0067 _P0q 006e _P0p 008c _Q0q 0093 _Q0p 00b3 __real@400921fb54442d18 00bc __real@4000000000000000 00c7 _sqrt 00d3 __real@3fe921fb54442d18 00e1 _cos 00fe _sin"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 D9 EE DC 5D 08 DF E0 F6 C4 41 75 08 DD 45 08 D9 E0 DD 5D 08 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 2C 6A 04 68 ?? ?? ?? ?? 6A 0B 68 ?? ?? ?? ?? DD 45 08 DC 4D 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 E9 BB 00 00 00 E9 B6 00 00 00 DD 05 ?? ?? ?? ?? DC 75 08 DD 5D E8 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 E8 DC 4D E8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DD 5D F0 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 E8 DC 4D E8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D E8 DD 5D F8 DD 05 ?? ?? ?? ?? DC 4D 08 DC 3D ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D E0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D D8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F8 DC 6D D8 DC 4D E0 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_1_0 {
	meta:
		name = "_evaluate"
		size = 282
		refs = "0031 ??_C@_1CC@JOKKCJAA@?$AAn?$AA1?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AA2?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 003d ??_C@_1HE@MBKFOGDN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0044 __CrtDbgReportW 0064 ??_C@_1BC@LLMCKKDB@?$AAe?$AAv?$AAa?$AAl?$AAu?$AAa?$AAt?$AAe?$AA?$AA@ 006e __invalid_parameter 0077 __real@bff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 83 7D 14 00 7E 0F 83 7D 1C 00 7E 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 45 E0 89 45 E4 83 7D E4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 49 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 29 6A 00 68 49 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 DD 05 ?? ?? ?? ?? E9 96 00 00 00 8B 55 14 8B 45 10 DD 45 08 DC 0C D0 DD 5D F0 8B 4D 14 83 E9 01 89 4D FC EB 09 8B 55 FC 83 EA 01 89 55 FC 83 7D FC 00 7E 14 8B 45 FC 8B 4D 10 DD 04 C1 DC 45 F0 DC 4D 08 DD 5D F0 EB DD 8B 55 10 DD 45 F0 DC 02 DD 5D F0 8B 45 1C 8B 4D 18 DD 45 08 DC 0C C1 DD 5D E8 8B 55 1C 83 EA 01 89 55 FC EB 09 8B 45 FC 83 E8 01 89 45 FC 83 7D FC 00 7E 14 8B 4D FC 8B 55 18 DD 04 CA DC 45 E8 DC 4D 08 DD 5D E8 EB DD 8B 45 18 DD 45 E8 DC 00 DD 5D E8 DD 45 F0 DC 75 E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_2_0 {
	meta:
		name = "__j1"
		size = 309
		refs = "002c __real@401e000000000000 0043 _J1q 004a _J1p 005e _evaluate 0074 __real@4020000000000000 0081 _P1q 0088 _P1p 00a6 _Q1q 00ad _Q1p 00d0 __real@400921fb54442d18 00d9 __real@4000000000000000 00e7 _sqrt 00f6 __real@4002d97c7f3321d2 0104 _cos 0121 _sin"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 C7 45 F4 01 00 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0F DD 45 08 D9 E0 DD 5D 08 C7 45 F4 FF FF FF FF DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 38 DB 45 F4 DC 4D 08 6A 04 68 ?? ?? ?? ?? 6A 0A 68 ?? ?? ?? ?? DD 45 08 DC 4D 08 83 EC 08 DD 1C 24 DD 5D D8 E8 ?? ?? ?? ?? 83 C4 18 DC 4D D8 E9 C4 00 00 00 E9 BF 00 00 00 DD 05 ?? ?? ?? ?? DC 75 08 DD 5D E8 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 E8 DC 4D E8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DD 5D F8 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 E8 DC 4D E8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D E8 DD 5D E0 DB 45 F4 DD 05 ?? ?? ?? ?? DC 4D 08 DC 3D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D0 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F8 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D C0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E0 DC 6D C0 DC 4D C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_3_0 {
	meta:
		name = "__y0"
		size = 351
		refs = "0019 __d_ind 002c _domain_err 003a __real@401e000000000000 004b _Y0q 0052 _Y0p 0063 _evaluate 0074 __j0 007d __real@3fe45f306dc9c883 008e _log 00a7 __real@4020000000000000 00b4 _P0q 00bb _P0p 00d9 _Q0q 00e0 _Q0p 0100 __real@400921fb54442d18 0109 __real@4000000000000000 0114 _sqrt 0120 __real@3fe921fb54442d18 012e _sin 014b _cos"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 D9 EE DC 5D 08 DF E0 F6 C4 41 75 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 22 E8 ?? ?? ?? ?? 83 C4 14 E9 23 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 5D 6A 08 68 ?? ?? ?? ?? 6A 08 68 ?? ?? ?? ?? DD 45 08 DC 4D 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 45 08 DD 1C 24 DD 5D E0 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 DD 5D D8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D8 DC 45 E0 E9 BB 00 00 00 E9 B6 00 00 00 DD 05 ?? ?? ?? ?? DC 75 08 DD 5D E8 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 E8 DC 4D E8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DD 5D F0 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 E8 DC 4D E8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D E8 DD 5D F8 DD 05 ?? ?? ?? ?? DC 4D 08 DC 3D ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F8 DC 45 C8 DC 4D D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_4_0 {
	meta:
		name = "__y1"
		size = 358
		refs = "0019 __d_ind 002c _domain_err 003a __real@401e000000000000 004b _Y1q 0052 _Y1p 0063 _evaluate 007a __j1 0088 _log 009b __real@3fe45f306dc9c883 00ae __real@4020000000000000 00bb _P1q 00c2 _P1p 00e0 _Q1q 00e7 _Q1p 0107 __real@400921fb54442d18 0110 __real@4000000000000000 011b _sqrt 0127 __real@4002d97c7f3321d2 0135 _sin 0152 _cos"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 D9 EE DC 5D 08 DF E0 F6 C4 41 75 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 23 E8 ?? ?? ?? ?? 83 C4 14 E9 2A 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 64 6A 08 68 ?? ?? ?? ?? 6A 07 68 ?? ?? ?? ?? DD 45 08 DC 4D 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D 08 83 EC 08 DD 45 08 DD 1C 24 DD 5D E0 E8 ?? ?? ?? ?? DD 45 08 DD 1C 24 DD 5D D8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D8 D9 E8 DC 75 08 DE E9 DC 0D ?? ?? ?? ?? DC 45 E0 E9 BB 00 00 00 E9 B6 00 00 00 DD 05 ?? ?? ?? ?? DC 75 08 DD 5D F0 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F0 DC 4D F0 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DD 5D F8 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F0 DC 4D F0 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D F0 DD 5D E8 DD 05 ?? ?? ?? ?? DC 4D 08 DC 3D ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F8 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E8 DC 45 C8 DC 4D D0 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_5_0 {
	meta:
		name = "__jn"
		size = 417
		refs = "002e __j0 004a __j1 0079 _fabs"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 83 7D 08 00 7D 10 8B 45 08 F7 D8 89 45 08 DD 45 0C D9 E0 DD 5D 0C 83 7D 08 00 75 16 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 63 01 00 00 83 7D 08 01 75 16 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 47 01 00 00 D9 EE DC 5D 0C DF E0 F6 C4 44 7A 07 D9 EE E9 34 01 00 00 DB 45 08 83 EC 08 DD 45 0C DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 08 DC 5D C8 DF E0 F6 C4 41 75 72 8B 4D 08 D1 E1 89 4D 08 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D D8 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D D0 C7 45 F4 02 00 00 00 DD 45 D0 DD 5D E0 DB 45 F4 DC 4D D0 DC 75 0C DC 65 D8 DD 5D D0 8B 55 F4 83 C2 02 89 55 F4 8B 45 F4 3B 45 08 75 08 DD 45 D0 E9 AE 00 00 00 DD 45 E0 DD 5D D8 EB CA E9 A1 00 00 00 8B 4D 08 D1 E1 89 4D 08 DD 45 0C DC 4D 0C DD 5D F8 D9 EE DD 5D E0 8B 55 08 83 C2 24 89 55 F4 EB 09 8B 45 F4 83 E8 02 89 45 F4 8B 4D F4 3B 4D 08 7E 0E DB 45 F4 DC 65 E0 DC 7D F8 DD 5D E0 EB E1 DB 45 08 DC 65 E0 DC 7D 0C DD 5D D0 DD 45 D0 DD 5D E8 D9 E8 DD 5D D8 8B 55 08 83 EA 02 89 55 F4 DD 45 D8 DD 5D E0 DB 45 F4 DC 4D D8 DC 75 0C DC 65 D0 DD 5D D8 8B 45 F4 83 E8 02 89 45 F4 75 02 EB 08 DD 45 E0 DD 5D D0 EB D6 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E8 DC 75 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_6_0 {
	meta:
		name = "__yn"
		size = 280
		refs = "0019 __d_ind 002c _domain_err 0072 __y0 0097 __y1 00cd __real@4000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 D9 EE DC 5D 0C DF E0 F6 C4 41 75 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 0C DD 1C 24 6A 24 E8 ?? ?? ?? ?? 83 C4 14 E9 DC 00 00 00 C7 45 F0 01 00 00 00 83 7D 08 00 7D 17 8B 45 08 F7 D8 89 45 08 8B 4D 08 83 E1 01 74 07 C7 45 F0 FF FF FF FF 83 7D 08 00 75 1F DB 45 F0 83 EC 08 DD 45 0C DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D0 E9 93 00 00 00 83 7D 08 01 75 1C DB 45 F0 83 EC 08 DD 45 0C DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D C8 EB 71 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F8 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D E0 DD 05 ?? ?? ?? ?? DC 75 0C DD 5D E8 C7 45 F4 01 00 00 00 EB 09 8B 55 F4 83 C2 01 89 55 F4 8B 45 F4 3B 45 08 7D 1D DB 45 F4 DC 4D E8 DC 4D E0 DC 65 F8 DD 5D D8 DD 45 E0 DD 5D F8 DD 45 D8 DD 5D E0 EB D2 DB 45 F0 DC 4D D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_233_7_0 {
	meta:
		name = "_domain_err"
		size = 67
		refs = "0011 __ctrlfp 0038 __except1"
	strings:
		$1 = { 8B FF 55 8B EC 51 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC 50 83 EC 08 DD 45 14 DD 1C 24 83 EC 08 DD 45 0C DD 1C 24 8B 4D 08 51 6A 08 E8 ?? ?? ?? ?? 83 C4 1C 8B E5 5D C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__ismbclower_l"
		size = 308
		refs = "0010 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 004b ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0063 ??1_LocaleUpdate@@QAE@XZ 00a5 ___crtGetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 8B 45 0C 50 8D 4D F0 E8 ?? ?? ?? ?? 81 7D 08 FF 00 00 00 0F 86 D9 00 00 00 33 C9 66 89 4D EC 33 D2 66 89 55 EE 8B 45 08 C1 E8 08 25 FF 00 00 00 88 45 E8 8B 4D 08 81 E1 FF 00 00 00 88 4D E9 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 83 7A 08 00 75 17 C7 45 E4 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E4 E9 C1 00 00 00 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 48 0C 51 8D 4D F0 E8 ?? ?? ?? ?? 8B 50 04 8B 42 04 50 8D 4D EC 51 6A 02 8D 55 E8 52 6A 01 8D 4D F0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 14 C7 45 E0 00 00 00 00 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 E0 EB 6C 0F B7 45 EE 85 C0 75 12 0F B7 4D EC 83 E1 02 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 DC 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 DC EB 38 EB 2E 8D 4D F0 E8 ?? ?? ?? ?? 8B 40 04 8B 4D 08 0F B6 54 08 1D 83 E2 20 33 C0 83 FA 20 0F 94 C0 89 45 D8 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 D8 EB 08 8D 4D F0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "_wcsspn"
		size = 102
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 89 45 F8 8B 4D F8 0F B7 11 85 D2 74 42 8B 45 0C 89 45 FC EB 09 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 0F B7 02 8B 4D F8 0F B7 11 3B C2 74 16 8B 45 FC 0F B7 08 85 C9 75 0A 8B 45 F8 2B 45 08 D1 F8 EB 15 EB D1 8B 55 F8 83 C2 02 89 55 F8 EB B4 8B 45 F8 2B 45 08 D1 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__rmtmp"
		size = 343
		refs = "0008 __sehtable$__rmtmp 000d __except_handler4 001f ___security_cookie 003c __lock 0061 __nstream 006f ___piob 00a9 __lock_file2 00ed __fclose_nolock 011c __unlock_file2 013a __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 C7 45 E0 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D E0 3B 0D ?? ?? ?? ?? 0F 8D BE 00 00 00 8B 55 E0 A1 ?? ?? ?? ?? 83 3C 90 00 0F 84 A7 00 00 00 8B 4D E0 8B 15 ?? ?? ?? ?? 8B 04 8A 8B 48 0C 81 E1 83 00 00 00 0F 84 8C 00 00 00 8B 55 E0 A1 ?? ?? ?? ?? 8B 0C 90 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC 01 00 00 00 8B 45 E0 8B 0D ?? ?? ?? ?? 8B 14 81 8B 42 0C 25 83 00 00 00 74 30 8B 4D E0 8B 15 ?? ?? ?? ?? 8B 04 8A 83 78 1C 00 74 1E 8B 4D E0 8B 15 ?? ?? ?? ?? 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E4 83 C1 01 89 4D E4 C7 45 FC 00 00 00 00 E8 02 00 00 00 EB 19 8B 55 E0 A1 ?? ?? ?? ?? 8B 0C 90 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 C3 E9 2A FF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "__spawnl"
		size = 426
		refs = "001b ??_C@_1CC@MODLNCFO@?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0024 ??_C@_1GA@NJMEECLG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002b __CrtDbgReportW 003f __errno 0053 ??_C@_1BA@DMANNNMI@?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AA?$AA@ 005d __invalid_parameter 007e ??_C@_1CM@PKENOFGE@?$AA?$CK?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 00e2 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0142 ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 019f __spawnve"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 83 7D 0C 00 0F 95 C0 89 45 FC 83 7D FC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D FC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3A 01 00 00 8B 55 0C 0F BE 02 F7 D8 1B C0 F7 D8 89 45 F8 75 1E 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D7 00 00 00 33 D2 83 7D 10 00 0F 95 C2 89 55 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 76 8B 4D 10 0F BE 11 F7 DA 1B D2 F7 DA 89 55 F0 75 1E 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 6A 00 8D 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "?_set_new_mode@@YAHH@Z"
		size = 151
		refs = "0031 ??_C@_1CK@CFODHCOD@?$AAn?$AAh?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAh?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA1?$AA?$AA@ 003a ??_C@_1GI@OEBKHGDG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0041 __CrtDbgReportW 0055 __errno 0069 ??_C@_1BM@PDPAKJNF@?$AA_?$AAs?$AAe?$AAt?$AA_?$AAn?$AAe?$AAw?$AA_?$AAm?$AAo?$AAd?$AAe?$AA?$AA@ 0073 __invalid_parameter 0081 __newmode"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 08 00 74 0F 83 7D 08 01 74 09 C7 45 F4 00 00 00 00 EB 07 C7 45 F4 01 00 00 00 8B 45 F4 89 45 F8 83 7D F8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 17 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 17 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 14 8B 15 ?? ?? ?? ?? 89 55 FC 8B 45 08 A3 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "__wsearchenv_s"
		size = 1687
		refs = "000c ___security_cookie 004c ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0055 ??_C@_1GE@PHBNAIPH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 005c __CrtDbgReportW 0073 __errno 0087 ??_C@_1BM@HHNAPIIJ@?$AA_?$AAw?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AAe?$AAn?$AAv?$AA_?$AAs?$AA?$AA@ 0091 __invalid_parameter 00b4 ??_C@_1BC@FCDIKEIH@?$AA?$CI?$AAs?$AAz?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0131 ??_C@_1CA@JLJGIEHM@?$AA?$CI?$AAf?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01ca __waccess_s 01fa __wfullpath 023d ??_C@_1OE@IBNOILDE@?$AA_?$AAw?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK@ 0248 ??_C@_0DC@OPHNAMFI@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 025c __wdupenv_s_dbg 0265 __invoke_watson_if_oneof 02af _wcslen 0312 __calloc_dbg 0392 __wgetpath 0515 ??_C@_1FA@FDKBGGLI@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAb?$AAu?$AAf?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAp?$AA?5?$AA?9?$AA?5?$AAp?$AAb?$AAu?$AAf?$AA?$CJ?$AA?0@ 053c _wcscpy_s 0545 __invoke_watson_if_error 0598 __free_dbg 05db ??_C@_1DC@OJGDNNCB@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?0?$AA?5?$AAs?$AAz?$AA?0?$AA?5?$AAp?$AAb?$AAu?$AAf?$AA?$CJ?$AA?$AA@ 068f @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 B8 FD FF FF 00 00 00 00 C7 85 D8 FD FF FF 00 00 00 00 C7 85 D4 FD FF FF 00 00 00 00 33 C0 83 7D 10 00 0F 95 C0 89 85 B4 FD FF FF 83 BD B4 FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 40 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B4 FD FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 E7 05 00 00 33 D2 3B 55 14 1B C0 F7 D8 89 85 B0 FD FF FF 75 1E 68 ?? ?? ?? ?? 6A 00 6A 41 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD B0 FD FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 41 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 7F 05 00 00 83 7D 08 00 75 77 33 D2 8B 45 10 66 89 10 33 C9 83 7D 08 00 0F 95 C1 89 8D AC FD FF FF 83 BD AC FD FF FF 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 BD AC FD FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 02 05 00 00 8B 45 08 0F B7 08 85 C9 75 25 33 D2 8B 45 10 66 89 10 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 08 89 8D D4 FD FF FF E9 9B 04 00 00 E8 ?? ?? ?? ?? 8B 10 89 95 C0 FD FF FF 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 C4 FD FF FF E8 ?? ?? ?? ?? 8B 8D C0 FD FF FF 89 08 83 BD C4 FD FF FF 00 75 41 8B 55 14 52 8B 45 08 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1A 33 D2 8B 45 10 66 89 10 E8 ?? ?? ?? ?? 8B 08 89 8D D4 FD FF FF E9 32 04 00 00 C7 85 D4 FD FF FF 00 00 00 00 E9 23 04 00 00 6A 00 6A 64 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 16 6A 16 6A 64 68 ?? ?? ?? ?? 6A 02 8B 55 0C 52 6A 00 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 18 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 09 83 BD B8 FD FF FF 00 75 25 33 C9 8B 55 10 66 89 0A E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 D4 FD FF FF E9 B3 03 00 00 8B 8D B8 FD FF FF 89 8D C8 FD FF FF 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 D0 FD FF FF 8D 85 E8 FD FF FF 89 85 D8 FD FF FF C7 85 DC FD FF FF 08 01 00 00 8B 8D D0 FD FF FF 3B 8D DC FD FF FF 72 6D 8B 95 C8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 8D D0 FD FF FF 8D 54 08 02 89 95 DC FD FF FF 6A 76 68 ?? ?? ?? ?? 6A 02 6A 02 8B 85 DC FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 D8 FD FF FF 83 BD D8 FD FF FF 00 75 25 33 C9 8B 55 10 66 89 0A E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 D4 FD FF FF E9 04 03 00 00 E8 ?? ?? ?? ?? 8B 08 89 8D C0 FD FF FF 83 BD C8 FD FF FF 00 0F 84 CA 02 00 00 8B 95 C8 FD FF FF 89 95 E4 FD FF FF 8B 85 DC FD FF FF 2B 85 D0 FD FF FF 83 E8 01 50 8B 8D D8 FD FF FF 51 8B 95 C8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 89 85 C8 FD FF FF 83 BD C8 FD FF FF 00 0F 85 BB 00 00 00 8B 85 D8 FD FF FF 8D 8D E8 FD FF FF 3B C1 0F 85 A7 00 00 00 E8 ?? ?? ?? ?? 83 38 22 0F 85 99 00 00 00 8B 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B 8D D0 FD FF FF 8D 54 08 02 89 95 DC FD FF FF 68 8A 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 85 DC FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 D8 FD FF FF 83 BD D8 FD FF FF 00 75 25 33 C9 8B 55 10 66 89 0A E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 D4 FD FF FF E9 13 02 00 00 8B 8D DC FD FF FF 2B 8D D0 FD FF FF 51 8B 95 D8 FD FF FF 52 8B 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 C8 FD FF FF 83 BD C8 FD FF FF 00 74 0D 8B 8D D8 FD FF FF 0F B7 11 85 D2 75 05 E9 AF 01 00 00 8B 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 04 89 85 CC FD FF FF 8B 8D CC FD FF FF 8B 95 D8 FD FF FF 8D 04 4A 89 85 E0 FD FF FF 8B 8D E0 FD FF FF 0F B7 51 FE 89 95 BC FD FF FF 83 BD BC FD FF FF 2F 74 3E 83 BD BC FD FF FF 5C 74 35 83 BD BC FD FF FF 3A 74 2C B8 5C 00 00 00 8B 8D E0 FD FF FF 66 89 01 8B 95 E0 FD FF FF 83 C2 02 89 95 E0 FD FF FF 8B 85 CC FD FF FF 83 C0 01 89 85 CC FD FF FF 6A 00 68 A9 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 51 8B 95 E0 FD FF FF 2B 95 D8 FD FF FF D1 FA 8B 85 DC FD FF FF 2B C2 50 8B 8D E0 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 8B 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 85 C7 00 00 00 8B 85 CC FD FF FF 03 85 D0 FD FF FF 3B 45 14 72 46 33 C9 8B 55 10 66 89 0A 8B 85 D8 FD FF FF 8D 8D E8 FD FF FF 3B C1 74 11 6A 02 8B 95 D8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 85 D4 FD FF FF E9 95 00 00 00 E8 ?? ?? ?? ?? 8B 8D C0 FD FF FF 89 08 6A 00 68 BB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 D8 FD FF FF 52 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 95 D8 FD FF FF 8D 85 E8 FD FF FF 3B D0 74 11 6A 02 8B 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 C7 85 D4 FD FF FF 00 00 00 00 EB 25 E9 29 FD FF FF 33 D2 8B 45 10 66 89 10 E8 ?? ?? ?? ?? C7 00 02 00 00 00 E8 ?? ?? ?? ?? 8B 08 89 8D D4 FD FF FF 8B 95 D8 FD FF FF 8D 85 E8 FD FF FF 3B D0 74 11 6A 02 8B 8D D8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 95 B8 FD FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8B 85 D4 FD FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_244_3_0 {
	meta:
		name = "__wsearchenv"
		size = 32
		refs = "0017 __wsearchenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 68 04 01 00 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_911_3_0 {
	meta:
		name = "__searchenv"
		size = 32
		refs = "0017 __searchenv_s"
	strings:
		$1 = { 8B FF 55 8B EC 68 04 01 00 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "___dyn_tls_init@12"
		size = 74
		refs = "0016 ___xd_a 0028 ___xd_z"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 0C 02 74 07 B8 01 00 00 00 EB 31 C7 45 FC ?? ?? ?? ?? EB 09 8B 45 FC 83 C0 04 89 45 FC 81 7D FC ?? ?? ?? ?? 74 11 8B 4D FC 83 39 00 74 07 8B 55 FC 8B 02 FF D0 EB DD B8 01 00 00 00 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "_wprintf"
		size = 308
		refs = "0008 __sehtable$_wprintf 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GC@FCDCKBIE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1BA@HFKICJND@?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 0087 __invalid_parameter 009d ___iob_func 00a8 __lock_file2 00c0 __stbuf 00de __woutput_l 00f6 __ftbuf 0117 __unlock_file2"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8C 00 00 00 8D 55 0C 89 55 E4 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 45 E4 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 E8 ?? ?? ?? ?? 83 C0 20 50 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 14 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "_printf"
		size = 308
		refs = "0008 __sehtable$_printf 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004e ??_C@_1GA@LHEGHOAF@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1O@GKDHFACN@?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 0087 __invalid_parameter 009d ___iob_func 00a8 __lock_file2 00c0 __stbuf 00de __output_l 00f6 __ftbuf 0117 __unlock_file2"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 D8 83 7D D8 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 36 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D D8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 36 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 8C 00 00 00 8D 55 0C 89 55 E4 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 8B 45 E4 50 6A 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 E8 ?? ?? ?? ?? 83 C0 20 50 8B 55 DC 52 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 14 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 83 C4 08 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "___libm_sse2_tan"
		size = 597
		refs = "001f _PI32INV 002f _SHIFTER 003b _P_1 0047 _QQ_2 0055 _P_2 0074 _P_3 008f _ONE 0098 _Ctable 00a0 _MASK_35 01f2 _TWO_POW_M55 01fa _TWO_POW_55 0217 _sign_mask 0227 _INF 023f _tan"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 20 38 66 3D A8 08 0F 87 C7 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 F2 0F 2D D1 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA F2 0F 10 2D ?? ?? ?? ?? 81 C2 00 29 07 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 F2 0F 10 35 ?? ?? ?? ?? C1 E2 04 8D 05 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 28 D8 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 66 0F 28 78 10 F2 0F 5C DD 66 0F 59 F8 66 0F 5C D1 66 0F 28 48 30 66 0F 59 C8 66 0F 28 60 60 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F2 0F 10 D9 66 0F 58 FC F2 0F 10 E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F2 0F 10 E2 F2 0F 10 B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 E6 F2 0F 10 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F2 0F 10 E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 F2 0F 58 C3 C3 7F 33 66 C1 E8 04 66 3D 7E 0C 75 0C F2 0F 10 D8 F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 D8 F2 0F 59 1D ?? ?? ?? ?? 66 0F 28 C3 C3 F3 0F 7E 3D ?? ?? ?? ?? 66 0F 54 F8 66 0F 57 F8 66 0F 2E 3D ?? ?? ?? ?? 74 23 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 8B 64 24 08 C3 F2 0F 5C C0 C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "_strcpy_s"
		size = 724
		refs = "0031 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 003a ??_C@_1GI@BGBNCIMA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0041 __CrtDbgReportW 0055 __errno 0069 ??_C@_1BC@CFJEPFGF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$AA@ 0073 __invalid_parameter 00b1 ___crtDebugFillThreshold 00dc _memset 00f6 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01e8 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0211 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 F4 83 7D F4 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 12 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 12 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 4C 02 00 00 83 7D 10 00 0F 85 BB 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E4 EB 09 8B 55 0C 83 EA 01 89 55 E4 8B 45 E4 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 83 7D 10 00 0F 95 C2 89 55 F0 83 7D F0 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 13 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 13 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 87 01 00 00 8B 4D 08 89 4D FC 8B 55 0C 89 55 F8 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 0F BE 08 8B 55 FC 83 C2 01 89 55 FC 8B 45 10 83 C0 01 89 45 10 85 C9 74 0D 8B 4D F8 83 E9 01 89 4D F8 74 02 EB CD 83 7D F8 00 0F 85 CF 00 00 00 8B 55 08 C6 02 00 83 7D 0C FF 74 49 81 7D 0C FF FF FF 7F 74 40 83 7D 0C 01 76 3A 8B 45 0C 83 E8 01 39 05 ?? ?? ?? ?? 73 0B 8B 0D ?? ?? ?? ?? 89 4D E0 EB 09 8B 55 0C 83 EA 01 89 55 E0 8B 45 E0 50 68 FE 00 00 00 8B 4D 08 83 C1 01 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 4D DC 89 4D EC 83 7D EC 00 75 1E 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 6F 83 7D 0C FF 74 67 81 7D 0C FF FF FF 7F 74 5E 8B 45 0C 2B 45 F8 83 C0 01 3B 45 0C 73 50 8B 4D 0C 2B 4D F8 83 C1 01 8B 55 0C 2B D1 39 15 ?? ?? ?? ?? 73 0A A1 ?? ?? ?? ?? 89 45 D8 EB 11 8B 4D 0C 2B 4D F8 83 C1 01 8B 55 0C 2B D1 89 55 D8 8B 45 D8 50 68 FE 00 00 00 8B 4D 0C 2B 4D F8 8B 55 08 8D 44 0A 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "___lconv_init"
		size = 65
		refs = "0007 ___lconv_c"
	strings:
		$1 = { 8B FF 55 8B EC C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF C6 05 ?? ?? ?? ?? FF 33 C0 5D C3 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "_fdiv_main_routine"
		size = 279
		refs = "0028 fdiv_risc_table 006e fdiv_scale_1 0085 fdiv_scale_2 00f8 one_shl_63"
	strings:
		$1 = { DB 6C 24 10 DB 6C 24 04 8B 44 24 08 03 C0 0F 83 86 00 00 00 35 00 00 00 0E A9 00 00 00 0E 74 03 DE F9 C3 C1 E8 1C 80 B8 ?? ?? ?? ?? 00 75 03 DE F9 C3 8B 44 24 0C 25 FF 7F 00 00 74 67 3D FF 7F 00 00 74 60 D9 7C 24 1C 8B 44 24 1C 0D 3F 03 00 00 25 FF F3 00 00 89 44 24 20 D9 6C 24 20 8B 44 24 18 25 FF 7F 00 00 83 F8 01 74 17 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 D9 6C 24 1C DE F9 C3 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 D9 6C 24 1C DE F9 C3 8B 44 24 04 0B 44 24 08 75 03 DE F9 C3 8B 44 24 0C 25 FF 7F 00 00 75 F2 D9 7C 24 1C 8B 44 24 1C 0D 3F 03 00 00 25 FF F3 00 00 89 44 24 20 D9 6C 24 20 8B 44 24 18 25 FF 7F 00 00 74 11 3D FF 7F 00 00 74 32 8B 44 24 14 03 C0 73 2A EB 08 8B 44 24 14 03 C0 72 20 D9 C9 DD D8 D9 C0 D8 0D ?? ?? ?? ?? DB 7C 24 04 DB 6C 24 10 D9 C9 9B D9 6C 24 1C E9 F8 FE FF FF D9 6C 24 1C DE F9 C3 }
	condition:
		$1
}

rule file_253_1_0 {
	meta:
		name = "__adj_fdiv_r"
		size = 1183
		refs = "0009 dispatch_table"
	strings:
		$1 = { 83 EC 2C 83 E0 3F FF 24 85 ?? ?? ?? ?? D8 F0 83 C4 2C C3 83 C4 2C CD 06 D8 F8 83 C4 2C C3 83 C4 2C CD 06 D8 F0 83 C4 2C C3 DE F8 83 C4 2C C3 D8 F8 83 C4 2C C3 DE F0 83 C4 2C C3 DB 7C 24 0C D9 C0 DB 3C 24 DB 7C 24 20 E8 9C FE FF FF DB 6C 24 20 D9 C9 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 DB 7C 24 0C E8 81 FE FF FF DB 6C 24 0C D9 C9 83 C4 2C C3 83 C4 2C CD 06 D9 C9 DB 7C 24 0C D9 C0 DB 3C 24 DB 7C 24 20 E8 5E FE FF FF DB 6C 24 20 83 C4 2C C3 DB 3C 24 DB 7C 24 0C E8 4A FE FF FF 83 C4 2C C3 DB 7C 24 0C DB 3C 24 E8 3A FE FF FF DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C DB 3C 24 E8 26 FE FF FF 83 C4 2C C3 DB 7C 24 0C D9 C9 D9 C0 DB 3C 24 DB 7C 24 20 E8 0E FE FF FF D9 C9 DB 6C 24 20 D9 CA 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 C9 DB 7C 24 0C E8 EF FD FF FF D9 C9 DB 6C 24 0C D9 CA 83 C4 2C C3 83 C4 2C CD 06 D9 CA DB 7C 24 0C D9 C9 D9 C0 DB 3C 24 DB 7C 24 20 E8 C8 FD FF FF D9 C9 DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 C9 DB 7C 24 0C E8 B0 FD FF FF D9 C9 83 C4 2C C3 DB 7C 24 0C D9 C9 DB 3C 24 E8 9C FD FF FF D9 C9 DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 C9 DB 3C 24 E8 84 FD FF FF D9 C9 83 C4 2C C3 DB 7C 24 0C D9 CA D9 C0 DB 3C 24 DB 7C 24 20 E8 6A FD FF FF D9 CA DB 6C 24 20 D9 CB 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CA DB 7C 24 0C E8 4B FD FF FF D9 CA DB 6C 24 0C D9 CB 83 C4 2C C3 83 C4 2C CD 06 D9 CB DB 7C 24 0C D9 CA D9 C0 DB 3C 24 DB 7C 24 20 E8 24 FD FF FF D9 CA DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CA DB 7C 24 0C E8 0C FD FF FF D9 CA 83 C4 2C C3 DB 7C 24 0C D9 CA DB 3C 24 E8 F8 FC FF FF D9 CA DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CA DB 3C 24 E8 E0 FC FF FF D9 CA 83 C4 2C C3 DB 7C 24 0C D9 CB D9 C0 DB 3C 24 DB 7C 24 20 E8 C6 FC FF FF D9 CB DB 6C 24 20 D9 CC 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CB DB 7C 24 0C E8 A7 FC FF FF D9 CB DB 6C 24 0C D9 CC 83 C4 2C C3 83 C4 2C CD 06 D9 CC DB 7C 24 0C D9 CB D9 C0 DB 3C 24 DB 7C 24 20 E8 80 FC FF FF D9 CB DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CB DB 7C 24 0C E8 68 FC FF FF D9 CB 83 C4 2C C3 DB 7C 24 0C D9 CB DB 3C 24 E8 54 FC FF FF D9 CB DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CB DB 3C 24 E8 3C FC FF FF D9 CB 83 C4 2C C3 DB 7C 24 0C D9 CC D9 C0 DB 3C 24 DB 7C 24 20 E8 22 FC FF FF D9 CC DB 6C 24 20 D9 CD 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CC DB 7C 24 0C E8 03 FC FF FF D9 CC DB 6C 24 0C D9 CD 83 C4 2C C3 83 C4 2C CD 06 D9 CD DB 7C 24 0C D9 CC D9 C0 DB 3C 24 DB 7C 24 20 E8 DC FB FF FF D9 CC DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CC DB 7C 24 0C E8 C4 FB FF FF D9 CC 83 C4 2C C3 DB 7C 24 0C D9 CC DB 3C 24 E8 B0 FB FF FF D9 CC DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CC DB 3C 24 E8 98 FB FF FF D9 CC 83 C4 2C C3 DB 7C 24 0C D9 CD D9 C0 DB 3C 24 DB 7C 24 20 E8 7E FB FF FF D9 CD DB 6C 24 20 D9 CE 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CD DB 7C 24 0C E8 5F FB FF FF D9 CD DB 6C 24 0C D9 CE 83 C4 2C C3 83 C4 2C CD 06 D9 CE DB 7C 24 0C D9 CD D9 C0 DB 3C 24 DB 7C 24 20 E8 38 FB FF FF D9 CD DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CD DB 7C 24 0C E8 20 FB FF FF D9 CD 83 C4 2C C3 DB 7C 24 0C D9 CD DB 3C 24 E8 0C FB FF FF D9 CD DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CD DB 3C 24 E8 F4 FA FF FF D9 CD 83 C4 2C C3 DB 7C 24 0C D9 CE D9 C0 DB 3C 24 DB 7C 24 20 E8 DA FA FF FF D9 CE DB 6C 24 20 D9 CF 83 C4 2C C3 83 C4 2C CD 06 DB 3C 24 D9 CE DB 7C 24 0C E8 BB FA FF FF D9 CE DB 6C 24 0C D9 CF 83 C4 2C C3 83 C4 2C CD 06 D9 CF DB 7C 24 0C D9 CE D9 C0 DB 3C 24 DB 7C 24 20 E8 94 FA FF FF D9 CE DB 6C 24 20 83 C4 2C C3 DB 3C 24 D9 CE DB 7C 24 0C E8 7C FA FF FF D9 CE 83 C4 2C C3 DB 7C 24 0C D9 CE DB 3C 24 E8 68 FA FF FF D9 CE DB 6C 24 0C 83 C4 2C C3 DB 7C 24 0C D9 CE DB 3C 24 E8 50 FA FF FF D9 CE 83 C4 2C C3 }
	condition:
		$1
}

rule file_253_2_0 {
	meta:
		name = "__fdivp_sti_st"
		size = 19
	strings:
		$1 = { 83 EC 2C DB 3C 24 DB 7C 24 0C E8 3B FA FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_253_3_0 {
	meta:
		name = "__fdivrp_sti_st"
		size = 19
	strings:
		$1 = { 83 EC 2C DB 7C 24 0C DB 3C 24 E8 28 FA FF FF 83 C4 2C C3 }
	condition:
		$1
}

rule file_253_4_0 {
	meta:
		name = "__adj_fdiv_m32"
		size = 76
	strings:
		$1 = { 50 8B 44 24 08 25 00 00 80 7F 3D 00 00 80 7F 74 33 DF E0 25 00 38 00 00 74 0D D9 44 24 08 E8 B7 FF FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 D9 44 24 14 E8 A2 FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 D8 74 24 08 58 C2 04 00 }
	condition:
		$1
}

rule file_253_5_0 {
	meta:
		name = "__adj_fdiv_m64"
		size = 76
	strings:
		$1 = { 50 8B 44 24 0C 25 00 00 F0 7F 3D 00 00 F0 7F 74 33 DF E0 25 00 38 00 00 74 0D DD 44 24 08 E8 6B FF FF FF 58 C2 08 00 D9 C9 83 EC 0C DB 3C 24 DD 44 24 14 E8 56 FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 08 00 DC 74 24 08 58 C2 08 00 }
	condition:
		$1
}

rule file_253_6_0 {
	meta:
		name = "__adj_fdiv_m16i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DF 44 24 08 E8 2F FF FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DF 44 24 14 E8 1A FF FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_253_7_0 {
	meta:
		name = "__adj_fdiv_m32i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DB 44 24 08 E8 FB FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DB 44 24 14 E8 E6 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_253_8_0 {
	meta:
		name = "__adj_fdivr_m32"
		size = 76
	strings:
		$1 = { 50 8B 44 24 08 25 00 00 80 7F 3D 00 00 80 7F 74 33 DF E0 25 00 38 00 00 74 0D D9 44 24 08 E8 CA FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 D9 44 24 14 E8 B5 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 D8 7C 24 08 58 C2 04 00 }
	condition:
		$1
}

rule file_253_9_0 {
	meta:
		name = "__adj_fdivr_m64"
		size = 76
	strings:
		$1 = { 50 8B 44 24 0C 25 00 00 F0 7F 3D 00 00 F0 7F 74 33 DF E0 25 00 38 00 00 74 0D DD 44 24 08 E8 7E FE FF FF 58 C2 08 00 D9 C9 83 EC 0C DB 3C 24 DD 44 24 14 E8 69 FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 08 00 DC 7C 24 08 58 C2 08 00 }
	condition:
		$1
}

rule file_253_10_0 {
	meta:
		name = "__adj_fdivr_m16i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DF 44 24 08 E8 42 FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DF 44 24 14 E8 2D FE FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_253_11_0 {
	meta:
		name = "__adj_fdivr_m32i"
		size = 52
	strings:
		$1 = { 50 DF E0 25 00 38 00 00 74 0D DB 44 24 08 E8 0E FE FF FF 58 C2 04 00 D9 C9 83 EC 0C DB 3C 24 DB 44 24 14 E8 F9 FD FF FF DB 2C 24 D9 C9 83 C4 0C 58 C2 04 00 }
	condition:
		$1
}

rule file_253_12_0 {
	meta:
		name = "__safe_fdiv"
		size = 21
	strings:
		$1 = { 50 83 EC 2C DB 3C 24 DB 7C 24 0C E8 14 F8 FF FF 83 C4 2C 58 C3 }
	condition:
		$1
}

rule file_253_13_0 {
	meta:
		name = "__safe_fdivr"
		size = 21
	strings:
		$1 = { 50 83 EC 2C DB 7C 24 0C DB 3C 24 E8 FF F7 FF FF 83 C4 2C 58 C3 }
	condition:
		$1
}

rule file_253_14_0 {
	meta:
		name = "__fprem_common"
		size = 518
		refs = "001f fprem_risc_table 0163 half 017e big_number 01cf one_shr_64"
	strings:
		$1 = { 50 53 51 8B 44 24 16 35 00 07 00 00 A9 00 07 00 00 0F 85 83 01 00 00 C1 E8 0B 83 E0 0F 80 B8 ?? ?? ?? ?? 00 0F 84 70 01 00 00 8B 44 24 16 25 00 00 FF 7F 3D 00 00 FF 7F 0F 84 5C 01 00 00 8B 44 24 2E 25 00 00 FF 7F 0F 84 4D 01 00 00 3D 00 00 FF 7F 0F 84 42 01 00 00 8B 44 24 2C 03 C0 0F 85 36 01 00 00 8B 44 24 14 03 C0 0F 85 2A 01 00 00 8B 44 24 18 25 FF 7F 00 00 83 C0 3F 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 77 5E 8B 44 24 18 25 FF 7F 00 00 83 C0 0A 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 0F 88 F2 00 00 00 DB 6C 24 28 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 8B CB 2B D8 83 E3 07 83 CB 04 2B CB 8B D8 81 E3 00 80 00 00 0B CB 89 4C 24 18 DB 6C 24 10 89 44 24 18 D9 C9 D9 F8 DB 7C 24 28 DD D8 EB A2 F7 C2 02 00 00 00 75 08 DB 6C 24 10 DB 7C 24 1C D9 7C 24 34 8B 44 24 34 0D 3F 03 00 00 89 44 24 38 D9 6C 24 38 8B 44 24 18 25 FF 7F 00 00 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 83 E3 3F 83 CB 20 83 C3 01 8B CB 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 25 00 80 00 00 0B D8 89 5C 24 18 DB 6C 24 10 D9 E1 DB 6C 24 28 D9 E1 D8 D1 DF E0 25 00 01 00 00 75 02 D8 E1 D9 C9 DC 0D ?? ?? ?? ?? D9 C9 83 E9 01 75 E4 8B 5C 24 30 DB 7C 24 28 DD D8 DB 6C 24 1C DB 2D ?? ?? ?? ?? D9 F8 DD D8 DB 6C 24 28 D9 6C 24 34 81 E3 00 80 00 00 74 0E D9 E0 EB 0A DB 6C 24 10 DB 6C 24 28 D9 F8 F7 C2 03 00 00 00 74 56 DD 7C 24 3C F7 C2 01 00 00 00 74 1F D9 7C 24 34 8B 44 24 34 0D 00 03 00 00 89 44 24 38 D9 6C 24 38 DC 0D ?? ?? ?? ?? D9 6C 24 34 8B 44 24 3C D9 C9 DD D8 DB 6C 24 1C D9 C9 25 00 43 00 00 83 EC 1C D9 34 24 81 64 24 04 FF BC 00 00 09 44 24 04 D9 24 24 83 C4 1C 59 5B 58 C3 }
	condition:
		$1
}

rule file_253_15_0 {
	meta:
		name = "__adj_fprem"
		size = 178
		refs = "006a one_shl_64"
	strings:
		$1 = { 52 83 EC 30 DB 7C 24 18 DB 3C 24 33 D2 8B 44 24 06 A9 00 00 FF 7F 74 0A E8 DD FD FF FF 83 C4 30 5A C3 DB 2C 24 DB 6C 24 18 8B 04 24 0B 44 24 04 74 79 D9 C9 DB 7C 24 0C DB 2C 24 D9 C9 83 CA 02 D9 7C 24 24 8B 44 24 24 0D 3F 03 00 00 89 44 24 28 D9 6C 24 28 8B 44 24 20 25 FF 7F 00 00 3D BE 7F 00 00 77 18 83 CA 01 DC 0D ?? ?? ?? ?? DB 7C 24 18 DC 0D ?? ?? ?? ?? DB 3C 24 EB 20 D9 7C 24 24 8B 44 24 24 0D 00 03 00 00 89 44 24 28 D9 6C 24 28 DD D8 DC 0D ?? ?? ?? ?? DB 3C 24 D9 6C 24 24 E8 54 FD FF FF 83 C4 30 5A C3 D9 F8 83 C4 30 5A C3 }
	condition:
		$1
}

rule file_253_16_0 {
	meta:
		name = "__fprem1_common"
		size = 518
		refs = "001f fprem_risc_table 0163 half 017e big_number 01cf one_shr_64"
	strings:
		$1 = { 50 53 51 8B 44 24 16 35 00 07 00 00 A9 00 07 00 00 0F 85 83 01 00 00 C1 E8 0B 83 E0 0F 80 B8 ?? ?? ?? ?? 00 0F 84 70 01 00 00 8B 44 24 16 25 00 00 FF 7F 3D 00 00 FF 7F 0F 84 5C 01 00 00 8B 44 24 2E 25 00 00 FF 7F 0F 84 4D 01 00 00 3D 00 00 FF 7F 0F 84 42 01 00 00 8B 44 24 2C 03 C0 0F 85 36 01 00 00 8B 44 24 14 03 C0 0F 85 2A 01 00 00 8B 44 24 18 25 FF 7F 00 00 83 C0 3F 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 77 5E 8B 44 24 18 25 FF 7F 00 00 83 C0 0A 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 0F 88 F2 00 00 00 DB 6C 24 28 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 8B CB 2B D8 83 E3 07 83 CB 04 2B CB 8B D8 81 E3 00 80 00 00 0B CB 89 4C 24 18 DB 6C 24 10 89 44 24 18 D9 C9 D9 F8 DB 7C 24 28 DD D8 EB A2 F7 C3 02 00 00 00 75 08 DB 6C 24 10 DB 7C 24 1C D9 7C 24 34 8B 44 24 34 0D 3F 03 00 00 89 44 24 38 D9 6C 24 38 8B 44 24 18 25 FF 7F 00 00 8B 5C 24 30 81 E3 FF 7F 00 00 2B D8 83 E3 3F 83 CB 20 83 C3 01 8B CB 8B 44 24 18 8B 5C 24 30 81 E3 FF 7F 00 00 25 00 80 00 00 0B D8 89 5C 24 18 DB 6C 24 10 D9 E1 DB 6C 24 28 D9 E1 D8 D1 DF E0 25 00 01 00 00 75 02 D8 E1 D9 C9 DC 0D ?? ?? ?? ?? D9 C9 83 E9 01 75 E4 8B 5C 24 30 DB 7C 24 28 DD D8 DB 6C 24 1C DB 2D ?? ?? ?? ?? D9 F5 DD D8 DB 6C 24 28 D9 6C 24 34 81 E3 00 80 00 00 74 0E D9 E0 EB 0A DB 6C 24 10 DB 6C 24 28 D9 F5 F7 C2 03 00 00 00 74 56 DD 7C 24 3C F7 C2 01 00 00 00 74 1F D9 7C 24 34 8B 44 24 34 0D 00 03 00 00 89 44 24 38 D9 6C 24 38 DC 0D ?? ?? ?? ?? D9 6C 24 34 8B 44 24 3C D9 C9 DD D8 DB 6C 24 1C D9 C9 25 00 43 00 00 83 EC 1C D9 34 24 81 64 24 04 FF BC 00 00 09 44 24 04 D9 24 24 83 C4 1C 59 5B 58 C3 }
	condition:
		$1
}

rule file_253_17_0 {
	meta:
		name = "__adj_fprem1"
		size = 181
		refs = "006d one_shl_64"
	strings:
		$1 = { 52 83 EC 30 DB 7C 24 18 DB 3C 24 BA 00 00 00 00 8B 44 24 06 A9 00 00 FF 7F 74 0A E8 DA FD FF FF 83 C4 30 5A C3 DB 2C 24 DB 6C 24 18 8B 04 24 0B 44 24 04 74 79 D9 C9 DB 7C 24 0C DB 2C 24 D9 C9 83 CA 02 D9 7C 24 24 8B 44 24 24 0D 3F 03 00 00 89 44 24 28 D9 6C 24 28 8B 44 24 20 25 FF 7F 00 00 3D BE 7F 00 00 77 18 83 CA 01 DC 0D ?? ?? ?? ?? DB 7C 24 18 DC 0D ?? ?? ?? ?? DB 3C 24 EB 20 D9 7C 24 24 8B 44 24 24 0D 00 03 00 00 89 44 24 28 D9 6C 24 28 DD D8 DC 0D ?? ?? ?? ?? DB 3C 24 D9 6C 24 24 E8 51 FD FF FF 83 C4 30 5A C3 D9 F8 83 C4 30 5A C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "__malloc_dbg"
		size = 46
		refs = "0013 __newmode 001d __nh_malloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 A1 ?? ?? ?? ?? 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "__nh_malloc"
		size = 29
		refs = "0014 __nh_malloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_609_0_0 {
	meta:
		name = "__tempnam"
		size = 29
		refs = "0014 __tempnam_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_507_0_0 {
	meta:
		name = "__wtempnam"
		size = 29
		refs = "0014 __wtempnam_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_254_2_0 {
	meta:
		name = "__nh_malloc_dbg"
		size = 88
		refs = "0028 __nh_malloc_dbg_impl 003f __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 8D 45 FC 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 75 19 83 7D FC 00 74 13 E8 ?? ?? ?? ?? 85 C0 74 0A E8 ?? ?? ?? ?? 8B 4D FC 89 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_8_0 {
	meta:
		name = "__calloc_dbg"
		size = 88
		refs = "0028 __calloc_dbg_impl 003f __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 8D 45 FC 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 83 7D F8 00 75 19 83 7D FC 00 74 13 E8 ?? ?? ?? ?? 85 C0 74 0A E8 ?? ?? ?? ?? 8B 4D FC 89 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_3_0 {
	meta:
		name = "__nh_malloc_dbg_impl"
		size = 103
		refs = "001b __heap_alloc_dbg_impl 0049 __callnewh"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 FC 83 7D FC 00 74 05 8B 45 FC EB 33 83 7D 0C 00 75 0E 8B 55 1C C7 02 0C 00 00 00 8B 45 FC EB 1F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0D 8B 4D 1C C7 01 0C 00 00 00 33 C0 EB 02 EB A3 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_4_0 {
	meta:
		name = "__heap_alloc"
		size = 25
		refs = "0010 __heap_alloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_906_0_0 {
	meta:
		name = "__strdup"
		size = 25
		refs = "0010 __strdup_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_822_0_0 {
	meta:
		name = "__wcsdup"
		size = 25
		refs = "0010 __wcsdup_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_254_5_0 {
	meta:
		name = "__heap_alloc_dbg_impl"
		size = 944
		refs = "0008 __sehtable$__heap_alloc_dbg_impl 000d __except_handler4 001f ___security_cookie 0043 __lock 0053 _check_frequency 0064 _check_counter 006b __CrtCheckMemory 0074 ??_C@_1CE@LJFEPPMP@?$AA_?$AAC?$AAr?$AAt?$AAC?$AAh?$AAe?$AAc?$AAk?$AAM?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 0080 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0087 __CrtDbgReportW 00b0 __lRequestCurr 00b9 __crtBreakAlloc 00ce __pfnAllocHook 0109 ??_C@_0DF@BBEGIFEK@Client?5hook?5allocation?5failure?5a@ 0116 __CrtDbgReport 0126 ??_C@_0CB@CCLOLAHO@Client?5hook?5allocation?5failure?4?6@ 012b ??_C@_02DKCKIIND@?$CFs?$AA@ 0159 __crtDbgFlag 0174 ??_C@_0CF@BICKFLAF@Invalid?5allocation?5size?3?5?$CFIu?5byt@ 01c5 ??_C@_0DC@JEMAGEKG@Error?3?5memory?5allocation?3?5bad?5me@ 01f2 __heap_alloc_base 0273 __lTotalAlloc 0298 __lCurAlloc 02ac __lMaxAlloc 02c0 __pFirstBlock 02d9 __pLastBlock 032d __bNoMansLandFill 033a _memset 0365 __bCleanLandFill 0393 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E4 00 00 00 00 C7 45 E0 00 00 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 83 3D ?? ?? ?? ?? 00 76 55 A1 ?? ?? ?? ?? 83 E8 01 39 05 ?? ?? ?? ?? 75 36 E8 ?? ?? ?? ?? 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 79 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0F 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 D8 83 3D ?? ?? ?? ?? FF 74 0C 8B 4D D8 3B 0D ?? ?? ?? ?? 75 01 CC 83 3D ?? ?? ?? ?? 00 74 75 8B 55 14 52 8B 45 10 50 8B 4D D8 51 8B 55 0C 52 8B 45 08 50 6A 00 6A 01 FF 15 ?? ?? ?? ?? 83 C4 1C 85 C0 75 50 83 7D 10 00 74 25 8B 4D 14 51 8B 55 10 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC EB 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E9 38 02 00 00 8B 55 0C 81 E2 FF FF 00 00 83 FA 02 74 11 A1 ?? ?? ?? ?? 83 E0 01 75 07 C7 45 E4 01 00 00 00 83 7D 08 BC 76 2D 8B 4D 08 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 18 C7 00 0C 00 00 00 E9 E6 01 00 00 8B 4D 0C 81 E1 FF FF 00 00 83 F9 04 74 3A 83 7D 0C 01 74 34 8B 55 0C 81 E2 FF FF 00 00 83 FA 02 74 26 83 7D 0C 03 74 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 4D 08 83 C1 24 89 4D D4 8B 55 D4 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 DC 83 7D DC 00 75 0E 8B 45 18 C7 00 0C 00 00 00 E9 72 01 00 00 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 83 7D E4 00 74 49 8B 55 DC C7 02 00 00 00 00 8B 45 DC C7 40 04 00 00 00 00 8B 4D DC C7 41 08 00 00 00 00 8B 55 DC C7 42 0C BC BA DC FE 8B 45 DC 8B 4D 08 89 48 10 8B 55 DC C7 42 14 03 00 00 00 8B 45 DC C7 40 18 00 00 00 00 E9 BA 00 00 00 83 C9 FF 2B 0D ?? ?? ?? ?? 3B 4D 08 76 11 8B 15 ?? ?? ?? ?? 03 55 08 89 15 ?? ?? ?? ?? EB 0A C7 05 ?? ?? ?? ?? FF FF FF FF A1 ?? ?? ?? ?? 03 45 08 A3 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 3B 0D ?? ?? ?? ?? 76 0C 8B 15 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0D A1 ?? ?? ?? ?? 8B 4D DC 89 48 04 EB 09 8B 55 DC 89 15 ?? ?? ?? ?? 8B 45 DC 8B 0D ?? ?? ?? ?? 89 08 8B 55 DC C7 42 04 00 00 00 00 8B 45 DC 8B 4D 10 89 48 08 8B 55 DC 8B 45 14 89 42 0C 8B 4D DC 8B 55 08 89 51 10 8B 45 DC 8B 4D 0C 89 48 14 8B 55 DC 8B 45 D8 89 42 18 8B 4D DC 89 0D ?? ?? ?? ?? 6A 04 0F B6 15 ?? ?? ?? ?? 52 8B 45 DC 83 C0 1C 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 0F B6 0D ?? ?? ?? ?? 51 8B 55 08 8B 45 DC 8D 4C 10 20 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 08 52 0F B6 05 ?? ?? ?? ?? 50 8B 4D DC 83 C1 20 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 DC 83 C2 20 89 55 E0 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_6_0 {
	meta:
		name = "__heap_alloc_dbg"
		size = 84
		refs = "0024 __heap_alloc_dbg_impl 003b __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 FC 00 00 00 00 8D 45 FC 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 45 F8 83 7D F8 00 75 19 83 7D FC 00 74 13 E8 ?? ?? ?? ?? 85 C0 74 0A E8 ?? ?? ?? ?? 8B 55 FC 89 10 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_7_0 {
	meta:
		name = "__calloc_dbg_impl"
		size = 200
		refs = "0026 ??_C@_1DO@MEOGCGBN@?$AA?$CI?$AA_?$AAH?$AAE?$AAA?$AAP?$AA_?$AAM?$AAA?$AAX?$AAR?$AAE?$AAQ?$AA?5?$AA?1?$AA?5?$AAn?$AAN?$AAu?$AAm?$AA?$CJ?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAn?$AAS?$AAi?$AAz?$AAe?$AA?$AA@ 0032 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0039 __CrtDbgReportW 004d __errno 0064 ??_C@_1CC@CKBDKDFF@?$AA_?$AAc?$AAa?$AAl?$AAl?$AAo?$AAc?$AA_?$AAd?$AAb?$AAg?$AA_?$AAi?$AAm?$AAp?$AAl?$AA?$AA@ 006e __invalid_parameter 0095 __newmode 009f __nh_malloc_dbg_impl 00ba _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 76 6B B8 E0 FF FF FF 33 D2 F7 75 08 3B 45 0C 1B C0 83 C0 01 89 45 F8 75 21 68 ?? ?? ?? ?? 6A 00 68 48 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 48 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 4B 8B 55 0C 0F AF 55 08 89 55 0C 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 0D ?? ?? ?? ?? 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 83 7D FC 00 74 12 8B 45 0C 50 6A 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_9_0 {
	meta:
		name = "__recalloc"
		size = 42
		refs = "0019 __recalloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 00 6A 00 6A 01 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_10_0 {
	meta:
		name = "__realloc_dbg"
		size = 146
		refs = "0008 __sehtable$__realloc_dbg 000d __except_handler4 001f ___security_cookie 0035 __lock 005a _realloc_help 0075 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 6A 01 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8D 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_11_0 {
	meta:
		name = "_realloc_help"
		size = 1529
		refs = "002e __malloc_dbg 004f __free_dbg 005f _check_frequency 0071 _check_counter 0078 __CrtCheckMemory 0081 ??_C@_1CE@LJFEPPMP@?$AA_?$AAC?$AAr?$AAt?$AAC?$AAh?$AAe?$AAc?$AAk?$AAM?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 008d ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0094 __CrtDbgReportW 00be __lRequestCurr 00c7 __crtBreakAlloc 00dc __pfnAllocHook 0119 ??_C@_0DI@KKJPDPGM@Client?5hook?5re?9allocation?5failur@ 0126 __CrtDbgReport 0136 ??_C@_0CE@DOFMDOL@Client?5hook?5re?9allocation?5failur@ 013b ??_C@_02DKCKIIND@?$CFs?$AA@ 0175 ??_C@_0ED@GPCPBAGP@Invalid?5allocation?5size?3?5?$CFIu?5byt@ 0196 ??_C@_0CF@BICKFLAF@Invalid?5allocation?5size?3?5?$CFIu?5byt@ 01b1 __errno 01f2 ??_C@_0FA@EFEIGJKG@Error?3?5memory?5allocation?3?5bad?5me@ 020f ??_C@_0DC@JEMAGEKG@Error?3?5memory?5allocation?3?5bad?5me@ 0235 __bAlignLandFill 0245 _CheckBytes 0255 ??_C@_0EM@LGFLMAGJ@The?5Block?5at?50x?$CFp?5was?5allocated?5@ 0286 __CrtIsValidHeapPointer 0292 ??_C@_1EE@GFOPCECE@?$AA_?$AAC?$AAr?$AAt?$AAI?$AAs?$AAV?$AAa?$AAl?$AAi?$AAd?$AAH?$AAe?$AAa?$AAp?$AAP?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?$CI?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa@ 02e7 ??_C@_1IK@DCPKDGNH@?$AAp?$AAO?$AAl?$AAd?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?9?$AA?$DO?$AAn?$AAL?$AAi?$AAn?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAI?$AAG?$AAN?$AAO?$AAR?$AAE?$AA_?$AAL?$AAI?$AAN?$AAE?$AA?5@ 0333 __lTotalAlloc 0341 ??_C@_0DA@HFBKENN@Error?3?5possible?5heap?5corruption?5@ 037f __realloc_base 03a4 __expand_base 041b __lCurAlloc 043e __lMaxAlloc 0471 __bCleanLandFill 0481 _memset 048d __bNoMansLandFill 04e0 ??_C@_1GE@PCKLOLAO@?$AAf?$AAR?$AAe?$AAa?$AAl?$AAl?$AAo?$AAc?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA?$CB?$AAf?$AAR?$AAe?$AAa?$AAl?$AAl?$AAo?$AAc?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp?$AAN?$AAe?$AAw?$AAB?$AAl@ 0530 __pLastBlock 053a ??_C@_1DC@GEFKNOOL@?$AA_?$AAp?$AAL?$AAa?$AAs?$AAt?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAO?$AAl?$AAd?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 0580 __pFirstBlock 058a ??_C@_1DE@KOOKLFBB@?$AA_?$AAp?$AAF?$AAi?$AAr?$AAs?$AAt?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAO?$AAl?$AAd?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 C7 45 F8 00 00 00 00 8B 45 0C 8B 08 89 4D FC 83 7D 08 00 75 1D 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 10 E9 BB 05 00 00 83 7D 1C 00 74 1D 83 7D FC 00 75 17 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 33 C0 E9 98 05 00 00 83 3D ?? ?? ?? ?? 00 76 56 8B 15 ?? ?? ?? ?? 83 EA 01 39 15 ?? ?? ?? ?? 75 36 E8 ?? ?? ?? ?? 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 CA 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0F 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 55 E8 83 3D ?? ?? ?? ?? FF 74 0C 8B 45 E8 3B 05 ?? ?? ?? ?? 75 01 CC 83 3D ?? ?? ?? ?? 00 74 79 8B 4D 18 51 8B 55 14 52 8B 45 E8 50 8B 4D 10 51 8B 55 FC 52 8B 45 08 50 6A 02 FF 15 ?? ?? ?? ?? 83 C4 1C 85 C0 75 52 83 7D 14 00 74 25 8B 4D 18 51 8B 55 14 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC EB 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 E9 99 04 00 00 83 7D FC BC 76 60 83 7D 14 00 74 29 8B 55 18 52 8B 45 14 50 8B 4D FC 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC EB 1F 8B 45 FC 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 33 04 00 00 83 7D 10 01 74 68 8B 55 10 81 E2 FF FF 00 00 83 FA 04 74 5A 8B 45 10 25 FF FF 00 00 83 F8 02 74 4D 83 7D 14 00 74 25 8B 4D 18 51 8B 55 14 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC EB 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC EB 51 6A 04 0F B6 15 ?? ?? ?? ?? 52 8B 45 08 83 E0 FC 83 E8 04 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 31 8B 4D 08 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 74 03 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 11 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 08 83 EA 20 89 55 F4 8B 45 F4 83 78 14 03 75 07 C7 45 F8 01 00 00 00 83 7D F8 00 74 38 8B 4D F4 81 79 0C BC BA DC FE 75 09 8B 55 F4 83 7A 18 00 74 21 68 ?? ?? ?? ?? 6A 00 68 1B 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC EB 64 8B 4D F4 8B 51 14 81 E2 FF FF 00 00 83 FA 02 75 14 8B 45 10 25 FF FF 00 00 83 F8 01 75 07 C7 45 10 02 00 00 00 8B 4D F4 8B 15 ?? ?? ?? ?? 3B 51 10 73 31 8B 45 08 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 88 02 00 00 83 7D 1C 00 74 25 8B 55 FC 83 C2 24 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 83 7D F0 00 75 07 33 C0 E9 5F 02 00 00 EB 23 8B 4D FC 83 C1 24 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 83 7D F0 00 75 07 33 C0 E9 3A 02 00 00 33 C0 75 FC 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 83 7D F8 00 75 7C 83 3D ?? ?? ?? ?? FF 73 39 8B 55 F0 A1 ?? ?? ?? ?? 2B 42 10 A3 ?? ?? ?? ?? 83 C9 FF 2B 0D ?? ?? ?? ?? 3B 4D FC 76 11 8B 15 ?? ?? ?? ?? 03 55 FC 89 15 ?? ?? ?? ?? EB 0A C7 05 ?? ?? ?? ?? FF FF FF FF 8B 45 F0 8B 0D ?? ?? ?? ?? 2B 48 10 89 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 03 55 FC 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 76 0C 8B 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 55 F0 83 C2 20 89 55 EC 8B 45 F0 8B 4D FC 3B 48 10 76 24 8B 55 F0 8B 45 FC 2B 42 10 50 0F B6 0D ?? ?? ?? ?? 51 8B 55 F0 8B 45 EC 03 42 10 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 0F B6 0D ?? ?? ?? ?? 51 8B 55 EC 03 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F8 00 75 1B 8B 45 F0 8B 4D 14 89 48 08 8B 55 F0 8B 45 18 89 42 0C 8B 4D F0 8B 55 E8 89 51 18 8B 45 F0 8B 4D FC 89 48 10 83 7D 1C 00 75 2F 83 7D 1C 00 75 08 8B 55 F0 3B 55 F4 74 21 68 ?? ?? ?? ?? 6A 00 68 83 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D F0 3B 4D F4 74 06 83 7D F8 00 74 08 8B 45 EC E9 DF 00 00 00 8B 55 F0 83 3A 00 74 10 8B 45 F0 8B 08 8B 55 F0 8B 42 04 89 41 04 EB 38 8B 0D ?? ?? ?? ?? 3B 4D F4 74 21 68 ?? ?? ?? ?? 6A 00 68 94 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 F0 8B 48 04 89 0D ?? ?? ?? ?? 8B 55 F0 83 7A 04 00 74 0F 8B 45 F0 8B 48 04 8B 55 F0 8B 02 89 01 EB 37 8B 0D ?? ?? ?? ?? 3B 4D F4 74 21 68 ?? ?? ?? ?? 6A 00 68 9F 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 F0 8B 08 89 0D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 0E 8B 15 ?? ?? ?? ?? 8B 45 F0 89 42 04 EB 09 8B 4D F0 89 0D ?? ?? ?? ?? 8B 55 F0 A1 ?? ?? ?? ?? 89 02 8B 4D F0 C7 41 04 00 00 00 00 8B 55 F0 89 15 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_12_0 {
	meta:
		name = "__recalloc_dbg"
		size = 249
		refs = "003b ??_C@_1DO@GOKJCEHJ@?$AA?$CI?$AA_?$AAH?$AAE?$AAA?$AAP?$AA_?$AAM?$AAA?$AAX?$AAR?$AAE?$AAQ?$AA?5?$AA?1?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$CJ?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0047 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 004e __CrtDbgReportW 0062 __errno 0079 ??_C@_1BM@OKFKJCEN@?$AA_?$AAr?$AAe?$AAc?$AAa?$AAl?$AAl?$AAo?$AAc?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0083 __invalid_parameter 00a3 __msize 00c2 __realloc_dbg 00eb _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 F4 00 00 00 00 83 7D 0C 00 76 6B B8 E0 FF FF FF 33 D2 F7 75 0C 3B 45 10 1B C0 83 C0 01 89 45 F0 75 21 68 ?? ?? ?? ?? 6A 00 68 41 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 41 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 67 8B 55 10 0F AF 55 0C 89 55 FC 83 7D 08 00 74 0F 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D FC 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 89 45 F4 83 7D F4 00 74 20 8B 45 F8 3B 45 FC 73 18 8B 4D FC 2B 4D F8 51 6A 00 8B 55 F4 03 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_14_0 {
	meta:
		name = "__expand_dbg"
		size = 269
		refs = "0008 __sehtable$__expand_dbg 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CE@CJACEFBA@?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0051 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0058 __CrtDbgReportW 006c __errno 0083 ??_C@_1BI@HAPNGHDP@?$AA_?$AAe?$AAx?$AAp?$AAa?$AAn?$AAd?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 008d __invalid_parameter 00b0 __lock 00d5 _realloc_help 00f0 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 A6 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 A6 04 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 63 83 7D 0C BC 76 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 4E 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 6A 00 8B 55 18 52 8B 45 14 50 8B 4D 10 51 8D 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_16_0 {
	meta:
		name = "__free_dbg"
		size = 126
		refs = "0008 __sehtable$__free_dbg 000d __except_handler4 001f ___security_cookie 0035 __lock 004c __free_dbg_nolock 0064 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_17_0 {
	meta:
		name = "__free_dbg_nolock"
		size = 1247
		refs = "0008 _check_frequency 0019 _check_counter 0020 __CrtCheckMemory 0029 ??_C@_1CE@LJFEPPMP@?$AA_?$AAC?$AAr?$AAt?$AAC?$AAh?$AAe?$AAc?$AAk?$AAM?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 0035 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 003c __CrtDbgReportW 007a __bAlignLandFill 008a _CheckBytes 009a ??_C@_0EJ@HEIBCIMJ@The?5Block?5at?50x?$CFp?5was?5allocated?5@ 00a7 __CrtDbgReport 00b5 __errno 00c6 __pfnAllocHook 00ed ??_C@_0BL@KEIPLFAC@Client?5hook?5free?5failure?4?6?$AA@ 00f2 ??_C@_02DKCKIIND@?$CFs?$AA@ 0116 __CrtIsValidHeapPointer 0122 ??_C@_1EE@GFOPCECE@?$AA_?$AAC?$AAr?$AAt?$AAI?$AAs?$AAV?$AAa?$AAl?$AAi?$AAd?$AAH?$AAe?$AAa?$AAp?$AAP?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?$CI?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa@ 0180 ??_C@_1EO@LHDAJOCM@?$AA_?$AAB?$AAL?$AAO?$AAC?$AAK?$AA_?$AAT?$AAY?$AAP?$AAE?$AA_?$AAI?$AAS?$AA_?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CI?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo@ 01a2 __crtDbgFlag 01b4 __bNoMansLandFill 0204 _szBlockUseName 020a ??_C@_0KI@JGFOHMEB@HEAP?5CORRUPTION?5DETECTED?3?5before@ 0248 ??_C@_0IK@PJCGLBOB@HEAP?5CORRUPTION?5DETECTED?3?5before@ 02c4 ??_C@_0KE@MBMNHHHN@HEAP?5CORRUPTION?5DETECTED?3?5after?5@ 0302 ??_C@_0IG@LEMBDCJK@HEAP?5CORRUPTION?5DETECTED?3?5after?5@ 033b ??_C@_1HK@HPCBMDFG@?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAL?$AAi?$AAn?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAI?$AAG?$AAN?$AAO?$AAR?$AAE?$AA_?$AAL?$AAI?$AAN?$AAE?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp@ 0368 __bDeadLandFill 0372 _memset 037e __free_base 03ac ??_C@_1DM@ODCJIDCP@?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo?$AAc?$AAk?$AAU?$AAs?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAn?$AAB?$AAl?$AAo?$AAc?$AAk?$AAU?$AAs?$AAe?$AA?$AA@ 03d1 __lCurAlloc 0405 __pLastBlock 040f ??_C@_1CK@DMAGEMBG@?$AA_?$AAp?$AAL?$AAa?$AAs?$AAt?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?$AA@ 0453 __pFirstBlock 045d ??_C@_1CM@MMAADDMD@?$AA_?$AAp?$AAF?$AAi?$AAr?$AAs?$AAt?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 3D ?? ?? ?? ?? 00 76 55 A1 ?? ?? ?? ?? 83 E8 01 39 05 ?? ?? ?? ?? 75 36 E8 ?? ?? ?? ?? 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 03 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0F 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 83 7D 08 00 75 05 E9 6C 04 00 00 83 7D 0C 01 75 4F 6A 04 0F B6 05 ?? ?? ?? ?? 50 8B 4D 08 83 E1 FC 83 E9 04 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 2F 8B 55 08 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 17 04 00 00 83 3D ?? ?? ?? ?? 00 74 44 6A 00 6A 00 6A 00 8B 4D 0C 51 6A 00 8B 55 08 52 6A 03 FF 15 ?? ?? ?? ?? 83 C4 1C 85 C0 75 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E9 CA 03 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 25 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 08 83 E8 20 89 45 FC 8B 4D FC 8B 51 14 81 E2 FF FF 00 00 83 FA 04 74 44 8B 45 FC 83 78 14 01 74 3B 8B 4D FC 8B 51 14 81 E2 FF FF 00 00 83 FA 02 74 2A 8B 45 FC 83 78 14 03 74 21 68 ?? ?? ?? ?? 6A 00 68 2B 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 15 ?? ?? ?? ?? 83 E2 04 0F 85 6D 01 00 00 6A 04 0F B6 05 ?? ?? ?? ?? 50 8B 4D FC 83 C1 1C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 92 00 00 00 8B 55 FC 83 7A 08 00 74 4D 8B 45 FC 8B 48 0C 51 8B 55 FC 8B 42 08 50 8B 4D FC 83 C1 20 51 8B 55 FC 8B 42 18 50 8B 4D FC 8B 51 14 81 E2 FF FF 00 00 8B 04 95 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 01 CC EB 3C 8B 55 FC 83 C2 20 52 8B 45 FC 8B 48 18 51 8B 55 FC 8B 42 14 25 FF FF 00 00 8B 0C 85 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 6A 04 0F B6 05 ?? ?? ?? ?? 50 8B 4D FC 8B 51 10 8B 45 FC 8D 4C 10 20 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 92 00 00 00 8B 55 FC 83 7A 08 00 74 4D 8B 45 FC 8B 48 0C 51 8B 55 FC 8B 42 08 50 8B 4D FC 83 C1 20 51 8B 55 FC 8B 42 18 50 8B 4D FC 8B 51 14 81 E2 FF FF 00 00 8B 04 95 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 01 CC EB 3C 8B 55 FC 83 C2 20 52 8B 45 FC 8B 48 18 51 8B 55 FC 8B 42 14 25 FF FF 00 00 8B 0C 85 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 8B 45 FC 83 78 14 03 75 65 8B 4D FC 81 79 0C BC BA DC FE 75 09 8B 55 FC 83 7A 18 00 74 21 68 ?? ?? ?? ?? 6A 00 68 64 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D FC 8B 51 10 83 C2 24 52 0F B6 05 ?? ?? ?? ?? 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 E9 51 01 00 00 8B 45 FC 83 78 14 02 75 0D 83 7D 0C 01 75 07 C7 45 0C 02 00 00 00 8B 4D FC 8B 51 14 3B 55 0C 74 21 68 ?? ?? ?? ?? 6A 00 68 72 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D FC 8B 15 ?? ?? ?? ?? 2B 51 10 89 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E0 02 0F 85 C7 00 00 00 8B 4D FC 83 39 00 74 10 8B 55 FC 8B 02 8B 4D FC 8B 51 04 89 50 04 EB 36 A1 ?? ?? ?? ?? 3B 45 FC 74 21 68 ?? ?? ?? ?? 6A 00 68 81 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 FC 8B 42 04 A3 ?? ?? ?? ?? 8B 4D FC 83 79 04 00 74 0F 8B 55 FC 8B 42 04 8B 4D FC 8B 11 89 10 EB 35 A1 ?? ?? ?? ?? 3B 45 FC 74 21 68 ?? ?? ?? ?? 6A 00 68 8B 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 55 FC 8B 02 A3 ?? ?? ?? ?? 8B 4D FC 8B 51 10 83 C2 24 52 0F B6 05 ?? ?? ?? ?? 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 EB 28 8B 45 FC C7 40 14 00 00 00 00 8B 4D FC 8B 51 10 52 0F B6 05 ?? ?? ?? ?? 50 8B 4D FC 83 C1 20 51 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_19_0 {
	meta:
		name = "__msize_dbg"
		size = 486
		refs = "0008 __sehtable$__msize_dbg 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1CE@CJACEFBA@?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0051 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0058 __CrtDbgReportW 006c __errno 0083 ??_C@_1BG@MBKOGDLD@?$AA_?$AAm?$AAs?$AAi?$AAz?$AAe?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 008d __invalid_parameter 009e _check_frequency 00b0 _check_counter 00b7 __CrtCheckMemory 00c0 ??_C@_1CE@LJFEPPMP@?$AA_?$AAC?$AAr?$AAt?$AAC?$AAh?$AAe?$AAc?$AAk?$AAM?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 00fe __lock 0111 __CrtIsValidHeapPointer 011d ??_C@_1EE@GFOPCECE@?$AA_?$AAC?$AAr?$AAt?$AAI?$AAs?$AAV?$AAa?$AAl?$AAi?$AAd?$AAH?$AAe?$AAa?$AAp?$AAP?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?$CI?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa@ 0179 ??_C@_1EO@LHDAJOCM@?$AA_?$AAB?$AAL?$AAO?$AAC?$AAK?$AA_?$AAT?$AAY?$AAP?$AAE?$AA_?$AAI?$AAS?$AA_?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CI?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo@ 01c9 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 D3 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D3 05 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 38 01 00 00 83 3D ?? ?? ?? ?? 00 76 56 8B 15 ?? ?? ?? ?? 83 EA 01 39 15 ?? ?? ?? ?? 75 36 E8 ?? ?? ?? ?? 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 D9 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0F 8B 0D ?? ?? ?? ?? 83 C1 01 89 0D ?? ?? ?? ?? 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 21 68 ?? ?? ?? ?? 6A 00 68 E7 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 4D 08 83 E9 20 89 4D E0 8B 55 E0 8B 42 14 25 FF FF 00 00 83 F8 04 74 43 8B 4D E0 83 79 14 01 74 3A 8B 55 E0 8B 42 14 25 FF FF 00 00 83 F8 02 74 2A 8B 4D E0 83 79 14 03 74 21 68 ?? ?? ?? ?? 6A 00 68 ED 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 E0 83 78 14 02 75 0D 83 7D 0C 01 75 07 C7 45 0C 02 00 00 00 8B 4D E0 8B 51 10 89 55 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_21_0 {
	meta:
		name = "__CrtSetDbgBlockType"
		size = 227
		refs = "0008 __sehtable$__CrtSetDbgBlockType 000d __except_handler4 001f ___security_cookie 0035 __lock 0048 __CrtIsValidHeapPointer 008f ??_C@_1EO@LHDAJOCM@?$AA_?$AAB?$AAL?$AAO?$AAC?$AAK?$AA_?$AAT?$AAY?$AAP?$AAE?$AA_?$AAI?$AAS?$AA_?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CI?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo@ 009b ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 00a2 __CrtDbgReportW 00c9 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 65 8B 4D 08 83 E9 20 89 4D E4 8B 55 E4 8B 42 14 25 FF FF 00 00 83 F8 04 74 43 8B 4D E4 83 79 14 01 74 3A 8B 55 E4 8B 42 14 25 FF FF 00 00 83 F8 02 74 2A 8B 4D E4 83 79 14 03 74 21 68 ?? ?? ?? ?? 6A 00 68 3A 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 8B 45 E4 8B 4D 0C 89 48 14 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_24_0 {
	meta:
		name = "_CheckBytes"
		size = 68
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 01 00 00 00 8B 45 10 8B 4D 10 83 E9 01 89 4D 10 85 C0 74 20 0F B6 55 0C 8B 45 08 0F B6 08 8B 45 08 83 C0 01 89 45 08 3B CA 74 07 C7 45 FC 00 00 00 00 EB D0 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_25_0 {
	meta:
		name = "__CrtCheckMemory"
		size = 1112
		refs = "0008 __sehtable$__CrtCheckMemory 000d __except_handler4 001f ___security_cookie 0033 __crtDbgFlag 0049 __lock 0058 __heapchk 0092 $LN51 0097 ??_C@_0CE@MKKHMBMK@_heapchk?5fails?5with?5_HEAPBADBEGI@ 009c ??_C@_02DKCKIIND@?$CFs?$AA@ 00a9 __CrtDbgReport 00bc ??_C@_0CD@CPKEAPBD@_heapchk?5fails?5with?5_HEAPBADNODE@ 00de ??_C@_0CC@MJGLGBDG@_heapchk?5fails?5with?5_HEAPBADEND?4@ 0100 ??_C@_0CC@MFFCHFHO@_heapchk?5fails?5with?5_HEAPBADPTR?4@ 0122 ??_C@_0CL@HNNNMKMJ@_heapchk?5fails?5with?5unknown?5retu@ 0155 __pFirstBlock 01ba _szBlockUseName 01c6 ??_C@_07OHKEFPKJ@DAMAGED?$AA@ 01cf __bNoMansLandFill 01dc _CheckBytes 0211 ??_C@_0KI@JGFOHMEB@HEAP?5CORRUPTION?5DETECTED?3?5before@ 0240 ??_C@_0IK@PJCGLBOB@HEAP?5CORRUPTION?5DETECTED?3?5before@ 02af ??_C@_0KE@MBMNHHHN@HEAP?5CORRUPTION?5DETECTED?3?5after?5@ 02de ??_C@_0IG@LEMBDCJK@HEAP?5CORRUPTION?5DETECTED?3?5after?5@ 0316 __bDeadLandFill 034d ??_C@_0KA@IHNJJKPL@HEAP?5CORRUPTION?5DETECTED?3?5on?5top@ 0371 ??_C@_0IC@BBJIOOJH@HEAP?5CORRUPTION?5DETECTED?3?5on?5top@ 03c2 ??_C@_0EG@DGJMPDBH@?$CFhs?5located?5at?50x?$CFp?5is?5?$CFIu?5bytes@ 03f1 ??_C@_0CI@JMLBEDHJ@?$CFhs?5located?5at?50x?$CFp?5is?5?$CFIu?5bytes@ 0428 __unlock 0448 $LN21 044c $LN22 0450 $LN23 0454 $LN24"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 A1 ?? ?? ?? ?? 83 E0 01 75 0A B8 01 00 00 00 E9 ED 03 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 E8 ?? ?? ?? ?? 89 45 E0 83 7D E0 FF 0F 84 E4 00 00 00 83 7D E0 FE 0F 84 DA 00 00 00 8B 4D E0 89 4D D0 8B 55 D0 83 C2 06 89 55 D0 83 7D D0 03 0F 87 95 00 00 00 8B 45 D0 FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E9 86 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC EB 64 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC EB 42 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC EB 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 45 DC 00 00 00 00 E9 CA 02 00 00 C7 45 DC 01 00 00 00 A1 ?? ?? ?? ?? 89 45 E4 EB 08 8B 4D E4 8B 11 89 55 E4 83 7D E4 00 0F 84 A7 02 00 00 C7 45 D8 01 00 00 00 8B 45 E4 8B 48 14 81 E1 FF FF 00 00 83 F9 04 74 23 8B 55 E4 83 7A 14 01 74 1A 8B 45 E4 8B 48 14 81 E1 FF FF 00 00 83 F9 02 74 09 8B 55 E4 83 7A 14 03 75 18 8B 45 E4 8B 48 14 81 E1 FF FF 00 00 8B 14 8D ?? ?? ?? ?? 89 55 D4 EB 07 C7 45 D4 ?? ?? ?? ?? 6A 04 0F B6 05 ?? ?? ?? ?? 50 8B 4D E4 83 C1 1C 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 7A 8B 55 E4 83 7A 08 00 74 3D 8B 45 E4 8B 48 0C 51 8B 55 E4 8B 42 08 50 8B 4D E4 83 C1 20 51 8B 55 E4 8B 42 18 50 8B 4D D4 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 01 CC EB 2D 8B 45 E4 83 C0 20 50 8B 4D E4 8B 51 18 52 8B 45 D4 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC C7 45 D8 00 00 00 00 6A 04 0F B6 15 ?? ?? ?? ?? 52 8B 45 E4 8B 48 10 8B 55 E4 8D 44 0A 20 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 7A 8B 4D E4 83 79 08 00 74 3D 8B 55 E4 8B 42 0C 50 8B 4D E4 8B 51 08 52 8B 45 E4 83 C0 20 50 8B 4D E4 8B 51 18 52 8B 45 D4 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 01 CC EB 2D 8B 55 E4 83 C2 20 52 8B 45 E4 8B 48 18 51 8B 55 D4 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC C7 45 D8 00 00 00 00 8B 4D E4 83 79 14 00 0F 85 86 00 00 00 8B 55 E4 8B 42 10 50 0F B6 0D ?? ?? ?? ?? 51 8B 55 E4 83 C2 20 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 64 8B 45 E4 83 78 08 00 74 32 8B 4D E4 8B 51 0C 52 8B 45 E4 8B 48 08 51 8B 55 E4 83 C2 20 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC EB 22 8B 4D E4 83 C1 20 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 45 D8 00 00 00 00 83 7D D8 00 75 7A 8B 45 E4 83 78 08 00 74 3D 8B 4D E4 8B 51 0C 52 8B 45 E4 8B 48 08 51 8B 55 E4 8B 42 10 50 8B 4D E4 83 C1 20 51 8B 55 D4 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 01 CC EB 2D 8B 4D E4 8B 51 10 52 8B 45 E4 83 C0 20 50 8B 4D D4 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC C7 45 DC 00 00 00 00 E9 47 FD FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_254_26_0 {
	meta:
		name = "__CrtSetDbgFlag"
		size = 326
		refs = "0008 __sehtable$__CrtSetDbgFlag 000d __except_handler4 001f ___security_cookie 0033 __crtDbgFlag 006b ??_C@_1BHO@NNANJNF@?$AA?$CI?$AAf?$AAN?$AAe?$AAw?$AAB?$AAi?$AAt?$AAs?$AA?$DN?$AA?$DN?$AA_?$AAC?$AAR?$AAT?$AAD?$AAB?$AAG?$AA_?$AAR?$AAE?$AAP?$AAO?$AAR?$AAT?$AA_?$AAF?$AAL?$AAA?$AAG?$AA?$CJ?$AA?5@ 0077 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 007e __CrtDbgReportW 0092 __errno 00a9 ??_C@_1BO@GJFDNMNF@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAD?$AAb?$AAg?$AAF?$AAl?$AAa?$AAg?$AA?$AA@ 00b3 __invalid_parameter 00c4 __lock 00eb _check_frequency 0107 _check_counter 0129 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 A1 ?? ?? ?? ?? 89 45 E4 83 7D 08 FF 74 17 8B 4D 08 81 E1 FF FF 00 00 83 E1 C8 74 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 55 DC 89 55 E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 78 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 78 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 A1 ?? ?? ?? ?? EB 73 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 0D ?? ?? ?? ?? 89 4D E4 83 7D 08 FF 74 37 8B 55 08 83 E2 04 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 10 8B 45 08 C1 F8 10 25 FF FF 00 00 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 8B 4D 08 89 0D ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_27_0 {
	meta:
		name = "__CrtDoForAllClientObjects"
		size = 283
		refs = "0008 __sehtable$__CrtDoForAllClientObjects 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1BI@CJGCEEDL@?$AAp?$AAf?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0051 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0058 __CrtDbgReportW 006c __errno 0083 ??_C@_1DE@GJCKCKEC@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAo?$AAF?$AAo?$AAr?$AAA?$AAl?$AAl?$AAC?$AAl?$AAi?$AAe?$AAn?$AAt?$AAO?$AAb?$AAj?$AAe?$AAc?$AAt?$AAs?$AA?$AA@ 008d __invalid_parameter 0098 __crtDbgFlag 00a6 __lock 00b5 __pFirstBlock 0101 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 AD 07 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AD 07 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 EB 73 8B 15 ?? ?? ?? ?? 83 E2 01 75 02 EB 66 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 A1 ?? ?? ?? ?? 89 45 E4 EB 08 8B 4D E4 8B 11 89 55 E4 83 7D E4 00 74 24 8B 45 E4 8B 48 14 81 E1 FF FF 00 00 83 F9 04 75 11 8B 55 0C 52 8B 45 E4 83 C0 20 50 FF 55 08 83 C4 08 EB CE C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_28_0 {
	meta:
		name = "__CrtIsValidPointer"
		size = 16
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 83 7D 08 00 0F 95 C0 5D C3 }
	condition:
		$1
}

rule file_254_29_0 {
	meta:
		name = "__CrtIsValidHeapPointer"
		size = 154
		refs = "001f __CrtIsValidPointer 0030 ___active_heap 003f ___sbh_find_block 005b ___sbh_verify_block 0071 __crtheap 0078 __imp__HeapValidate@12"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 07 33 C0 E9 83 00 00 00 6A 00 6A 20 8B 45 08 83 E8 20 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 04 33 C0 EB 68 83 3D ?? ?? ?? ?? 03 75 49 8B 4D 08 83 E9 20 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 83 7D FC 00 74 17 8B 55 08 83 EA 20 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 EB 32 EB 18 8B 4D 08 83 E9 20 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? EB 18 EB 16 8B 45 08 83 E8 20 50 6A 00 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_30_0 {
	meta:
		name = "__CrtIsMemoryBlock"
		size = 368
		refs = "0008 __sehtable$__CrtIsMemoryBlock 000d __except_handler4 001f ___security_cookie 0072 __CrtIsValidHeapPointer 0087 __lock 00db __CrtIsValidPointer 00f9 __lRequestCurr 0153 __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 C7 45 E4 00 00 00 00 83 7D 10 00 74 09 8B 45 10 C7 00 00 00 00 00 83 7D 14 00 74 09 8B 4D 14 C7 01 00 00 00 00 83 7D 18 00 74 09 8B 55 18 C7 02 00 00 00 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 07 33 C0 E9 DA 00 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 4D 08 83 E9 20 89 4D E0 8B 55 E0 8B 42 14 25 FF FF 00 00 83 F8 04 74 22 8B 4D E0 83 79 14 01 74 19 8B 55 E0 8B 42 14 25 FF FF 00 00 83 F8 02 74 09 8B 4D E0 83 79 14 03 75 6B 6A 01 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 55 8B 4D E0 8B 51 10 3B 55 0C 75 4A 8B 45 E0 8B 48 18 3B 0D ?? ?? ?? ?? 7F 3C 83 7D 10 00 74 0B 8B 55 10 8B 45 E0 8B 48 18 89 0A 83 7D 14 00 74 0B 8B 55 14 8B 45 E0 8B 48 08 89 0A 83 7D 18 00 74 0B 8B 55 18 8B 45 E0 8B 48 0C 89 0A C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_31_0 {
	meta:
		name = "__CrtReportBlockType"
		size = 46
		refs = "000b __CrtIsValidHeapPointer"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 05 83 C8 FF EB 0F 8B 4D 08 83 E9 20 89 4D FC 8B 55 FC 8B 42 14 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_34_0 {
	meta:
		name = "__CrtMemCheckpoint"
		size = 536
		refs = "0008 __sehtable$__CrtMemCheckpoint 000d __except_handler4 001f ___security_cookie 0045 ??_C@_1BM@MIMANDHC@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0051 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0058 __CrtDbgReportW 006c __errno 0083 ??_C@_1CE@NJJKELF@?$AA_?$AAC?$AAr?$AAt?$AAM?$AAe?$AAm?$AAC?$AAh?$AAe?$AAc?$AAk?$AAp?$AAo?$AAi?$AAn?$AAt?$AA?$AA@ 008d __invalid_parameter 009c __lock 00ae __pFirstBlock 0196 ??_C@_0DP@LEFMFBOD@Bad?5memory?5block?5found?5at?50x?$CFp?4?6@ 01a3 __CrtDbgReport 01b7 ??_C@_0CB@EAAIGELO@Bad?5memory?5block?5found?5at?50x?$CFp?4?6@ 01db __lMaxAlloc 01e6 __lTotalAlloc 01fe __unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 DC 83 7D DC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F2 08 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D DC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F2 08 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 6D 01 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8B 55 08 A1 ?? ?? ?? ?? 89 02 C7 45 E4 00 00 00 00 EB 09 8B 4D E4 83 C1 01 89 4D E4 83 7D E4 05 7D 1E 8B 55 E4 8B 45 08 C7 44 90 18 00 00 00 00 8B 4D E4 8B 55 08 C7 44 8A 04 00 00 00 00 EB D3 A1 ?? ?? ?? ?? 89 45 E0 EB 08 8B 4D E0 8B 11 89 55 E0 83 7D E0 00 0F 84 D0 00 00 00 8B 45 E0 8B 48 14 81 E1 FF FF 00 00 7C 66 8B 55 E0 8B 42 14 25 FF FF 00 00 83 F8 05 7D 56 8B 4D E0 8B 51 14 81 E2 FF FF 00 00 8B 45 08 8B 4C 90 04 83 C1 01 8B 55 E0 8B 42 14 25 FF FF 00 00 8B 55 08 89 4C 82 04 8B 45 E0 8B 48 14 81 E1 FF FF 00 00 8B 55 08 8B 44 8A 18 8B 4D E0 03 41 10 8B 55 E0 8B 4A 14 81 E1 FF FF 00 00 8B 55 08 89 44 8A 18 EB 57 8B 45 E0 83 78 08 00 74 2F 8B 4D E0 8B 51 0C 52 8B 45 E0 8B 48 08 51 8B 55 E0 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC EB 1F 8B 4D E0 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E9 1E FF FF FF 8B 45 08 8B 0D ?? ?? ?? ?? 89 48 2C 8B 55 08 A1 ?? ?? ?? ?? 89 42 30 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_35_0 {
	meta:
		name = "__CrtMemDifference"
		size = 535
		refs = "0023 ??_C@_1BM@MIMANDHC@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 002f ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0036 __CrtDbgReportW 004a __errno 0061 ??_C@_1CE@PDIENACM@?$AA_?$AAC?$AAr?$AAt?$AAM?$AAe?$AAm?$AAD?$AAi?$AAf?$AAf?$AAe?$AAr?$AAe?$AAn?$AAc?$AAe?$AA?$AA@ 006b __invalid_parameter 008c ??_C@_1CC@DHPFEMMN@?$AAo?$AAl?$AAd?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 00f5 ??_C@_1CC@DFPEDFBP@?$AAn?$AAe?$AAw?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01cd __crtDbgFlag"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 56 C7 45 FC 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 F4 83 7D F4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 3B 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3B 09 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 99 01 00 00 33 D2 83 7D 0C 00 0F 95 C2 89 55 F0 83 7D F0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 3C 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3C 09 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 30 01 00 00 33 C9 83 7D 10 00 0F 95 C1 89 4D EC 83 7D EC 00 75 21 68 ?? ?? ?? ?? 6A 00 68 3D 09 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3D 09 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 C7 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 45 F8 83 C0 01 89 45 F8 83 7D F8 05 7D 7F 8B 4D F8 8B 55 10 8B 45 F8 8B 75 0C 8B 4C 8A 18 2B 4C 86 18 8B 55 F8 8B 45 08 89 4C 90 18 8B 4D F8 8B 55 10 8B 45 F8 8B 75 0C 8B 4C 8A 04 2B 4C 86 04 8B 55 F8 8B 45 08 89 4C 90 04 8B 4D F8 8B 55 08 83 7C 8A 18 00 75 0D 8B 45 F8 8B 4D 08 83 7C 81 04 00 74 24 83 7D F8 00 74 1E 83 7D F8 02 75 11 83 7D F8 02 75 12 8B 15 ?? ?? ?? ?? 83 E2 10 74 07 C7 45 FC 01 00 00 00 E9 72 FF FF FF 8B 45 10 8B 4D 0C 8B 50 2C 2B 51 2C 8B 45 08 89 50 2C 8B 4D 10 8B 55 0C 8B 41 30 2B 42 30 8B 4D 08 89 41 30 8B 55 08 C7 02 00 00 00 00 8B 45 FC 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_36_0 {
	meta:
		name = "__CrtMemDumpAllObjectsSince"
		size = 60
		refs = "0017 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001f ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0029 ?_CrtMemDumpAllObjectsSince_stat@@YAXPBU_CrtMemState@@PAUlocaleinfo_struct@@@Z 0034 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 C7 45 FC 00 00 00 00 8B 45 FC 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 8D 4D EC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_40_0 {
	meta:
		name = "?_CrtMemDumpAllObjectsSince_stat@@YAXPBU_CrtMemState@@PAUlocaleinfo_struct@@@Z"
		size = 775
		refs = "0008 __sehtable$?_CrtMemDumpAllObjectsSince_stat@@YAXPBU_CrtMemState@@PAUlocaleinfo_struct@@@Z 000d __except_handler4 001f ___security_cookie 003c __lock 004b ??_C@_0BE@KCIPKCIA@Dumping?5objects?5?9?$DO?6?$AA@ 0050 ??_C@_02DKCKIIND@?$CFs?$AA@ 005d __CrtDbgReport 0079 __pFirstBlock 00d1 __crtDbgFlag 00f4 __CrtIsValidPointer 010a __imp__IsBadReadPtr@8 011a ??_C@_0BE@OIEFNFL@?$CDFile?5Error?$CD?$CI?$CFd?$CJ?5?3?5?$AA@ 0145 ??_C@_0L@JMEFFCCJ@?$CFhs?$CI?$CFd?$CJ?5?3?5?$AA@ 0167 ??_C@_06PKLGBFGM@?$HL?$CFld?$HN?5?$AA@ 01b5 ??_C@_0DD@GHNAAKBB@client?5block?5at?50x?$CFp?0?5subtype?5?$CFx@ 01d1 ?_pfnDumpClient@@3P6AXPAXI@ZA 020d __printMemBlockData 0231 ??_C@_0CH@FAGDDGPN@normal?5block?5at?50x?$CFp?0?5?$CFIu?5bytes?5@ 028d ??_C@_0DA@MDLBNIBM@crt?5block?5at?50x?$CFp?0?5subtype?5?$CFx?0?5?$CF@ 02cd __unlock 02d6 ??_C@_0BH@GFGKJDCO@Object?5dump?5complete?4?6?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 08 00 74 08 8B 4D 08 8B 11 89 55 E0 A1 ?? ?? ?? ?? 89 45 E4 EB 08 8B 4D E4 8B 11 89 55 E4 83 7D E4 00 0F 84 28 02 00 00 8B 45 E4 3B 45 E0 0F 84 1C 02 00 00 8B 4D E4 8B 51 14 81 E2 FF FF 00 00 83 FA 03 74 29 8B 45 E4 8B 48 14 81 E1 FF FF 00 00 74 1B 8B 55 E4 8B 42 14 25 FF FF 00 00 83 F8 02 75 10 8B 0D ?? ?? ?? ?? 83 E1 10 75 05 E9 D8 01 00 00 8B 55 E4 83 7A 08 00 74 77 6A 00 6A 01 8B 45 E4 8B 48 08 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 13 6A 01 8B 55 E4 8B 42 08 50 FF 15 ?? ?? ?? ?? 85 C0 74 24 8B 4D E4 8B 51 0C 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC EB 29 8B 4D E4 8B 51 0C 52 8B 45 E4 8B 48 08 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC 8B 45 E4 8B 48 18 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 E4 8B 48 14 81 E1 FF FF 00 00 83 F9 04 0F 85 83 00 00 00 8B 55 E4 8B 42 10 50 8B 4D E4 8B 51 14 C1 FA 10 81 E2 FF FF 00 00 52 8B 45 E4 83 C0 20 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 83 3D ?? ?? ?? ?? 00 74 2C 6A 01 8B 55 E4 83 C2 20 52 FF 15 ?? ?? ?? ?? 85 C0 75 19 8B 45 E4 8B 48 10 51 8B 55 E4 83 C2 20 52 FF 15 ?? ?? ?? ?? 83 C4 08 EB 10 8B 45 E4 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 E9 9E 00 00 00 8B 55 E4 83 7A 14 01 75 3B 8B 45 E4 8B 48 10 51 8B 55 E4 83 C2 20 52 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC 8B 4D E4 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 08 EB 5A 8B 45 E4 8B 48 14 81 E1 FF FF 00 00 83 F9 02 75 49 8B 55 E4 8B 42 10 50 8B 4D E4 8B 51 14 C1 FA 10 81 E2 FF FF 00 00 52 8B 45 E4 83 C0 20 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC 8B 55 E4 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 E9 C6 FD FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_41_0 {
	meta:
		name = "__printMemBlockData"
		size = 414
		refs = "0009 ___security_cookie 001a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0067 ?GetLocaleT@_LocaleUpdate@@QAEPAUlocaleinfo_struct@@XZ 0096 __isctype_l 00b6 __chvalidator_l 00e1 __errno 00fb ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 0119 _sprintf_s 012c ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0131 ??_C@_1CG@LPFIACGM@?$AA_?$AAp?$AAr?$AAi?$AAn?$AAt?$AAM?$AAe?$AAm?$AAB?$AAl?$AAo?$AAc?$AAk?$AAD?$AAa?$AAt?$AAa?$AA?$AA@ 0136 ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0147 __invoke_watson_if_oneof 016e ??_C@_0BA@HJBKCELP@?5Data?3?5?$DM?$CFs?$DO?5?$CFs?6?$AA@ 017b __CrtDbgReport 018c ??1_LocaleUpdate@@QAE@XZ 0196 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 74 A1 ?? ?? ?? ?? 33 C5 89 45 F8 8B 45 08 50 8D 4D A0 E8 ?? ?? ?? ?? C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 0C 83 7A 10 10 7D 0B 8B 45 0C 8B 48 10 89 4D 94 EB 07 C7 45 94 10 00 00 00 8B 55 FC 3B 55 94 0F 8D 06 01 00 00 8B 45 0C 03 45 FC 8A 48 20 88 4D 9F 8D 4D A0 E8 ?? ?? ?? ?? 85 C0 74 33 8D 4D A0 E8 ?? ?? ?? ?? 8B 10 83 BA AC 00 00 00 01 7E 20 8D 4D A0 E8 ?? ?? ?? ?? 50 68 57 01 00 00 0F B6 45 9F 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 90 EB 1E 68 57 01 00 00 0F B6 4D 9F 51 8D 4D A0 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 90 83 7D 90 00 74 09 0F B6 55 9F 89 55 8C EB 07 C7 45 8C 20 00 00 00 8B 45 FC 8A 4D 8C 88 4C 05 B0 E8 ?? ?? ?? ?? 8B 10 89 55 98 E8 ?? ?? ?? ?? C7 00 00 00 00 00 0F B6 45 9F 50 68 ?? ?? ?? ?? 8B 4D FC 6B C9 03 BA 31 00 00 00 2B D1 52 8B 45 FC 6B C0 03 8D 4C 05 C4 51 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 2A 6A 00 68 63 09 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 10 52 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 4D 98 89 08 E9 CA FE FF FF 8B 55 FC C6 44 15 B0 00 8D 45 C4 50 8D 4D B0 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 1C 83 F8 01 75 01 CC 8D 4D A0 E8 ?? ?? ?? ?? 8B 4D F8 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_43_0 {
	meta:
		name = "__CrtDumpMemoryLeaks"
		size = 104
		refs = "000d __CrtMemCheckpoint 0022 __crtDbgFlag 0032 ??_C@_0BI@JBFPOEJA@Detected?5memory?5leaks?$CB?6?$AA@ 0037 ??_C@_02DKCKIIND@?$CFs?$AA@ 0044 __CrtDbgReport 0054 __CrtMemDumpAllObjectsSince"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 04 83 7D E0 00 75 17 83 7D D4 00 75 11 8B 0D ?? ?? ?? ?? 83 E1 10 74 37 83 7D D8 00 74 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_44_0 {
	meta:
		name = "__CrtMemDumpStatistics"
		size = 269
		refs = "001b ??_C@_1BM@MIMANDHC@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0027 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 002e __CrtDbgReportW 0042 __errno 0059 ??_C@_1CM@MPNIBKGK@?$AA_?$AAC?$AAr?$AAt?$AAM?$AAe?$AAm?$AAD?$AAu?$AAm?$AAp?$AAS?$AAt?$AAa?$AAt?$AAi?$AAs?$AAt?$AAi?$AAc?$AAs?$AA?$AA@ 0063 __invalid_parameter 008d _szBlockUseName 00a9 ??_C@_0BO@DACNIABB@?$CFId?5bytes?5in?5?$CFId?5?$CFhs?5Blocks?4?6?$AA@ 00b6 __CrtDbgReport 00cd ??_C@_0CB@BLHDAFNE@Largest?5number?5used?3?5?$CFId?5bytes?4?6@ 00ef ??_C@_0BP@DEDHGGGI@Total?5allocations?3?5?$CFId?5bytes?4?6?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 33 C0 83 7D 08 00 0F 95 C0 89 45 F8 83 7D F8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 14 0A 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 14 0A 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 9A 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 05 7D 3E 8B 45 FC 8B 0C 85 ?? ?? ?? ?? 51 8B 55 FC 8B 45 08 8B 4C 90 04 51 8B 55 FC 8B 45 08 8B 4C 90 18 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 20 83 F8 01 75 01 CC EB B3 8B 45 08 8B 48 2C 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 08 8B 48 30 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_45_0 {
	meta:
		name = "__aligned_malloc"
		size = 29
		refs = "0014 __aligned_offset_malloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_254_46_0 {
	meta:
		name = "__aligned_malloc_dbg"
		size = 33
		refs = "0018 __aligned_offset_malloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 6A 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_254_47_0 {
	meta:
		name = "__aligned_realloc"
		size = 33
		refs = "0018 __aligned_offset_realloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_254_48_0 {
	meta:
		name = "__aligned_recalloc"
		size = 37
		refs = "001c __aligned_offset_recalloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_254_49_0 {
	meta:
		name = "__aligned_realloc_dbg"
		size = 37
		refs = "001c __aligned_offset_realloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 8B 4D 14 51 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_254_50_0 {
	meta:
		name = "__aligned_recalloc_dbg"
		size = 41
		refs = "0020 __aligned_offset_recalloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 6A 00 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_254_51_0 {
	meta:
		name = "__aligned_offset_malloc"
		size = 31
		refs = "0016 __aligned_offset_malloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_254_52_0 {
	meta:
		name = "__aligned_offset_malloc_dbg"
		size = 412
		refs = "001e ??_C@_1CE@NPMGPNNP@?$AAI?$AAS?$AA_?$AA2?$AA_?$AAP?$AAO?$AAW?$AA_?$AAN?$AA?$CI?$AAa?$AAl?$AAi?$AAg?$AAn?$AA?$CJ?$AA?$AA@ 002a ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0031 __CrtDbgReportW 0045 __errno 005c ??_C@_1DG@DONCJBBJ@?$AA_?$AAa?$AAl?$AAi?$AAg?$AAn?$AAe?$AAd?$AA_?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA_?$AAm?$AAa?$AAl?$AAl?$AAo?$AAc?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0066 __invalid_parameter 009f ??_C@_1DK@LFLKFPDA@?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0137 __malloc_dbg 0179 __bAlignLandFill 0186 _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 0C 83 E8 01 23 45 0C F7 D8 1B C0 83 C0 01 89 45 EC 75 21 68 ?? ?? ?? ?? 6A 00 68 39 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D EC 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 39 0B 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 24 01 00 00 83 7D 10 00 74 11 8B 55 10 3B 55 08 72 09 C7 45 E4 00 00 00 00 EB 07 C7 45 E4 01 00 00 00 8B 45 E4 89 45 E8 83 7D E8 00 75 21 68 ?? ?? ?? ?? 6A 00 68 3A 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3A 0B 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 A3 00 00 00 83 7D 0C 04 76 08 8B 55 0C 89 55 E0 EB 07 C7 45 E0 04 00 00 00 8B 45 E0 83 E8 01 89 45 0C 33 C9 2B 4D 10 83 E1 03 89 4D F0 8B 55 18 52 8B 45 14 50 6A 01 8B 4D F0 03 4D 08 8B 55 0C 8D 44 11 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 83 7D F4 00 75 04 33 C0 EB 4D 8B 4D F4 03 4D 0C 03 4D F0 8B 55 10 8D 44 11 08 8B 4D 0C F7 D1 23 C1 2B 45 10 89 45 F8 8B 55 F8 2B 55 F0 83 EA 08 89 55 FC 6A 04 0F B6 05 ?? ?? ?? ?? 50 8B 4D FC 83 C1 04 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 45 F4 89 02 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_54_0 {
	meta:
		name = "__aligned_offset_recalloc"
		size = 39
		refs = "001e __aligned_offset_recalloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 1C 5D C3 }
	condition:
		$1
}

rule file_254_55_0 {
	meta:
		name = "__aligned_offset_realloc_dbg"
		size = 714
		refs = "0023 __aligned_offset_malloc_dbg 003a __aligned_free_dbg 0059 __bNoMansLandFill 0066 _CheckBytes 0076 ??_C@_0EI@NDNJMAJK@The?5block?5at?50x?$CFp?5was?5not?5alloca@ 0083 __CrtDbgReport 0091 __errno 00a7 __bAlignLandFill 00c4 ??_C@_0DL@PGHMMKNE@Damage?5before?50x?$CFp?5which?5was?5all@ 00f4 ??_C@_1CE@NPMGPNNP@?$AAI?$AAS?$AA_?$AA2?$AA_?$AAP?$AAO?$AAW?$AA_?$AAN?$AA?$CI?$AAa?$AAl?$AAi?$AAg?$AAn?$AA?$CJ?$AA?$AA@ 0100 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0107 __CrtDbgReportW 0132 ??_C@_1DI@NINIKFFK@?$AA_?$AAa?$AAl?$AAi?$AAg?$AAn?$AAe?$AAd?$AA_?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA_?$AAr?$AAe?$AAa?$AAl?$AAl?$AAo?$AAc?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 013c __invalid_parameter 0175 ??_C@_1DK@LFLKFPDA@?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 01d2 __msize 0228 __malloc_dbg 027a _memset 02ac _memcpy 02bc __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 83 7D 08 00 75 21 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 14 E9 97 02 00 00 83 7D 0C 00 75 13 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 33 C0 E9 7E 02 00 00 8B 45 08 83 E0 FC 83 E8 08 89 45 E8 6A 04 0F B6 0D ?? ?? ?? ?? 51 8B 55 08 83 EA 04 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 31 8B 45 08 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 24 02 00 00 6A 04 0F B6 15 ?? ?? ?? ?? 52 8B 45 E8 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1F 8B 4D 08 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 10 83 E8 01 23 45 10 F7 D8 1B C0 83 C0 01 89 45 E4 75 21 68 ?? ?? ?? ?? 6A 00 68 D9 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 D9 0B 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 7C 01 00 00 83 7D 14 00 74 11 8B 55 14 3B 55 0C 72 09 C7 45 DC 00 00 00 00 EB 07 C7 45 DC 01 00 00 00 8B 45 DC 89 45 E0 83 7D E0 00 75 21 68 ?? ?? ?? ?? 6A 00 68 DA 0B 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 DA 0B 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 FB 00 00 00 8B 55 E8 8B 02 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D E8 8B 55 08 2B 11 2B C2 89 45 F4 83 7D 10 04 76 08 8B 45 10 89 45 D8 EB 07 C7 45 D8 04 00 00 00 8B 4D D8 83 E9 01 89 4D 10 33 D2 2B 55 14 83 E2 03 89 55 EC 8B 45 1C 50 8B 4D 18 51 6A 01 8B 55 EC 03 55 0C 8B 45 10 8D 4C 02 08 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 F0 83 7D F0 00 75 07 33 C0 E9 87 00 00 00 8B 55 F0 03 55 10 03 55 EC 8B 45 14 8D 4C 02 08 8B 55 10 F7 D2 23 CA 2B 4D 14 89 4D F8 8B 45 F8 2B 45 EC 83 E8 08 89 45 FC 6A 04 0F B6 0D ?? ?? ?? ?? 51 8B 55 FC 83 C2 04 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B 4D F0 89 08 8B 55 F4 3B 55 0C 76 08 8B 45 0C 89 45 D4 EB 06 8B 4D F4 89 4D D4 8B 55 D4 52 8B 45 08 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 8B 55 E8 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_56_0 {
	meta:
		name = "__aligned_offset_recalloc_dbg"
		size = 261
		refs = "003b ??_C@_1DO@GOKJCEHJ@?$AA?$CI?$AA_?$AAH?$AAE?$AAA?$AAP?$AA_?$AAM?$AAA?$AAX?$AAR?$AAE?$AAQ?$AA?5?$AA?1?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$CJ?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0047 ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 004e __CrtDbgReportW 0062 __errno 0079 ??_C@_1DK@MMLHIFFH@?$AA_?$AAa?$AAl?$AAi?$AAg?$AAn?$AAe?$AAd?$AA_?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA_?$AAr?$AAe?$AAc?$AAa?$AAl?$AAl?$AAo?$AAc?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0083 __invalid_parameter 00ab __aligned_msize 00ce __aligned_offset_realloc_dbg 00f7 _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 C7 45 FC 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 F4 00 00 00 00 83 7D 0C 00 76 6B B8 E0 FF FF FF 33 D2 F7 75 0C 3B 45 10 1B C0 83 C0 01 89 45 F0 75 21 68 ?? ?? ?? ?? 6A 00 68 24 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 6A 00 68 24 0C 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 73 8B 55 10 0F AF 55 0C 89 55 FC 83 7D 08 00 74 17 8B 45 18 50 8B 4D 14 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F8 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8B 4D FC 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 F4 83 7D F4 00 74 20 8B 45 F8 3B 45 FC 73 18 8B 4D FC 2B 4D F8 51 6A 00 8B 55 F4 03 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_58_0 {
	meta:
		name = "__aligned_free_dbg"
		size = 171
		refs = "0022 __bNoMansLandFill 002f _CheckBytes 003f ??_C@_0EF@PGELACII@The?5block?5at?50x?$CFp?5was?5not?5alloca@ 004c __CrtDbgReport 0060 __bAlignLandFill 007d ??_C@_0DL@PGHMMKNE@Damage?5before?50x?$CFp?5which?5was?5all@ 00a0 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 05 E9 96 00 00 00 8B 45 08 83 E0 FC 83 E8 08 89 45 FC 6A 04 0F B6 0D ?? ?? ?? ?? 51 8B 55 08 83 EA 04 52 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 21 8B 45 08 50 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC EB 4C 6A 04 0F B6 15 ?? ?? ?? ?? 52 8B 45 FC 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1F 8B 4D 08 51 68 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 01 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_60_0 {
	meta:
		name = "__CrtSetCheckCount"
		size = 21
		refs = "0007 ___crtDebugCheckCount"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_254_62_0 {
	meta:
		name = "__aligned_msize"
		size = 27
		refs = "0012 __aligned_msize_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_19_2_1 {
	meta:
		name = "?_Debug_message@std@@YAXPBG0I@Z"
		size = 27
		refs = "0012 ?_Debug_message@std@@YAXPB_W0I@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_83_3_1 {
	meta:
		name = "?_Fiopen@std@@YAPAU_iobuf@@PBGHH@Z"
		size = 27
		refs = "0012 ?_Fiopen@std@@YAPAU_iobuf@@PB_WHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_83_1_1 {
	meta:
		name = "?_Xfsopen@std@@YAPAU_iobuf@@PB_W0H@Z"
		size = 27
		refs = "0012 __wfsopen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_37_266_1 {
	meta:
		name = "?compare@?$char_traits@D@std@@SAHPBD0I@Z"
		size = 27
		refs = "0012 _memcmp"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_45_1_1 {
	meta:
		name = "__Stold"
		size = 27
		refs = "0012 __Stod"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_254_63_0 {
	meta:
		name = "__aligned_msize_dbg"
		size = 269
		refs = "003e ??_C@_1CC@MOBIKHH@?$AAm?$AAe?$AAm?$AAb?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004a ??_C@_1GC@DNJKKEAA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA_?$AAb?$AAl?$AAd?$AA?2?$AAs?$AAe?$AAl?$AAf?$AA_?$AAx?$AA8?$AA6?$AA?2?$AAc@ 0051 __CrtDbgReportW 0065 __errno 007c ??_C@_1CG@CEGMHIMN@?$AA_?$AAa?$AAl?$AAi?$AAg?$AAn?$AAe?$AAd?$AA_?$AAm?$AAs?$AAi?$AAz?$AAe?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0086 __invalid_parameter 00ac __msize"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 C7 45 E8 00 00 00 00 C7 45 EC 00 00 00 00 C7 45 F8 00 00 00 00 C7 45 F0 00 00 00 00 C7 45 F4 00 00 00 00 33 C0 83 7D 08 00 0F 95 C0 89 45 E4 83 7D E4 00 75 21 68 ?? ?? ?? ?? 6A 00 68 F3 0C 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 14 83 F8 01 75 01 CC 83 7D E4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 F3 0C 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 77 C7 45 FC 00 00 00 00 8B 55 08 83 E2 FC 83 EA 08 89 55 FC 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 55 FC 8B 45 08 2B 02 89 45 E8 33 C9 2B 4D 10 83 E1 03 89 4D F4 83 7D 0C 04 76 08 8B 55 0C 89 55 E0 EB 07 C7 45 E0 04 00 00 00 8B 45 E0 83 E8 01 89 45 0C 8B 4D 0C 8B 55 F4 8D 44 0A 08 2B 45 E8 89 45 EC 8B 4D F8 2B 4D E8 2B 4D EC 89 4D F0 8B 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__ioinit"
		size = 1180
		refs = "0008 __sehtable$__ioinit 000d __except_handler4 001f ___security_cookie 0042 __imp__GetStartupInfoA@4 0081 ??_C@_0DA@NBLAKPEL@f?3?2dd?2vctools?2crt_bld?2self_x86?2c@ 008c __calloc_dbg 00a9 ___pioinfo 00af __nhandle 02c9 __imp__GetFileType@4 030c ___crtInitCritSecAndSpinCount 03a7 __imp__GetStdHandle@4 0484 __imp__SetHandleCount@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 84 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E