private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_2_0_0 {
	meta:
		name = "@_RTC_Check_2_to_1@4"
		size = 38
		refs = "001b ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 53 8B D9 B9 00 FF 00 00 8B C3 23 C1 74 10 3B C1 74 0C 6A 01 FF 75 04 E8 ?? ?? ?? ?? 59 59 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "@_RTC_Check_4_to_1@4"
		size = 38
		refs = "001b ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 53 8B D9 B9 00 FF FF FF 8B C3 23 C1 74 10 3B C1 74 0C 6A 01 FF 75 04 E8 ?? ?? ?? ?? 59 59 8A C3 5B 5D C3 }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "@_RTC_Check_4_to_2@4"
		size = 39
		refs = "001b ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 B9 00 00 FF FF 8B C6 23 C1 74 10 3B C1 74 0C 6A 01 FF 75 04 E8 ?? ?? ?? ?? 59 59 66 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "@_RTC_Check_8_to_1@8"
		size = 49
		refs = "0024 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 08 BA 00 FF FF FF 23 CA 8B C1 0B 45 0C 74 16 3B CA 75 06 83 7D 0C FF 74 0C 6A 01 FF 75 04 E8 ?? ?? ?? ?? 59 59 8A 45 08 5D C2 08 00 }
	condition:
		$1
}

rule file_2_4_0 {
	meta:
		name = "@_RTC_Check_8_to_2@8"
		size = 50
		refs = "0024 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 08 BA 00 00 FF FF 23 CA 8B C1 0B 45 0C 74 16 3B CA 75 06 83 7D 0C FF 74 0C 6A 01 FF 75 04 E8 ?? ?? ?? ?? 59 59 66 8B 45 08 5D C2 08 00 }
	condition:
		$1
}

rule file_2_5_0 {
	meta:
		name = "@_RTC_Check_8_to_4@8"
		size = 37
		refs = "0018 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 55 8B EC 33 C9 8B C1 0B 45 0C 74 12 83 7D 0C FF 74 0C 6A 01 FF 75 04 E8 ?? ?? ?? ?? 59 59 8B 45 08 5D C2 08 00 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "___avx_asinf8"
		size = 352
		refs = "0010 ___common_sasin_data 014a ___common_sasin_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 15 ?? ?? ?? ?? C5 FC 10 25 ?? ?? ?? ?? C5 FC 11 04 24 C5 EC 54 C8 C5 F4 59 DC C5 F4 59 E9 C5 F4 C2 35 ?? ?? ?? ?? 1D C5 DC 5C FB C5 F4 C2 E4 15 C5 D4 5D DF C5 EC 55 D0 C4 E3 7D 19 F5 01 C5 C9 6B C5 C5 D1 EF ED C5 F9 63 F5 C5 FC 52 C7 C5 C4 58 FF C5 F9 D7 D6 C5 FC 59 E8 C5 C4 59 C0 C5 C4 59 FD C5 C4 5C 3D ?? ?? ?? ?? C5 C4 59 35 ?? ?? ?? ?? C5 CC 58 2D ?? ?? ?? ?? C5 FC 59 F7 C5 D4 59 FE C5 E4 59 2D ?? ?? ?? ?? C5 C4 5C F8 C5 D4 58 2D ?? ?? ?? ?? C5 E4 59 05 ?? ?? ?? ?? C5 FC 58 35 ?? ?? ?? ?? C5 E4 59 C3 C5 CC 59 F0 C5 CC 58 C5 C5 FC 59 EB C4 E3 75 4A C7 40 C5 D4 58 35 ?? ?? ?? ?? C5 CC 59 DB C5 E4 59 C8 C5 F4 58 C8 C5 DC 54 1D ?? ?? ?? ?? C5 F4 58 E3 C5 DC 57 C2 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB BA C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "___avx_floorf8"
		size = 16
	strings:
		$1 = { C4 E3 7D 08 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "___sse2_ceilf4"
		size = 112
		refs = "0021 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 50 83 E4 F0 89 44 24 14 66 0F 6F C8 F3 0F 5B D0 66 0F 72 E1 1F 66 0F 6F D8 66 0F DB 05 ?? ?? ?? ?? 0F 5B D2 66 0F 6F E9 66 0F 72 F1 1F 66 0F 66 05 ?? ?? ?? ?? 66 0F EB D1 66 0F 6F E3 66 0F DB D8 66 0F DF C2 66 0F EB C3 66 0F 76 E0 66 0F DF 25 ?? ?? ?? ?? 66 0F DF EC 0F 5C C5 8B 64 24 14 C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__exp_spec_sd"
		size = 272
		refs = "0004 _static_const_table"
	strings:
		$1 = { 66 0F 28 1D ?? ?? ?? ?? 8B 70 04 8B 08 8B FE 81 E6 FF FF FF 7F 81 FE 00 00 F0 7F 66 0F FE CB 77 63 72 09 85 C9 BE 00 00 00 00 75 58 33 F6 81 FF 10 49 87 C0 0F 87 A4 00 00 00 72 0C 81 F9 52 30 2D D5 0F 83 96 00 00 00 81 FF 2B 23 86 C0 77 62 72 08 81 F9 D1 BC 7A DD 73 58 81 FF 42 2E 86 40 7F 41 7C 08 81 F9 F0 39 FA FE 73 37 81 FF 37 2E 86 40 7F 1D 7C 08 81 F9 72 BA D8 E7 73 13 66 0F 28 D6 EB 63 66 0F 57 D2 33 F6 66 0F C2 D2 00 EB 56 66 0F 59 15 ?? ?? ?? ?? 66 0F 59 15 ?? ?? ?? ?? EB 44 BE 01 00 00 00 66 0F 28 15 ?? ?? ?? ?? EB 35 66 0F FE CB 66 0F 28 2D ?? ?? ?? ?? 66 0F 73 F1 2E BE FF FF FF FF 66 0F DB 0D ?? ?? ?? ?? 66 0F FA CD 66 0F 59 D1 66 0F 59 D5 EB 09 BE FF FF FF FF 66 0F 57 D2 85 F6 7C 03 7F 12 C3 66 0F EF ED 66 0F 76 FF 66 0F FA EF 66 0F 59 ED C3 66 0F 28 2D ?? ?? ?? ?? 66 0F 58 ED C3 8D 64 24 00 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "___sse2_exp2"
		size = 416
		refs = "001f _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 66 0F 28 C8 89 4C 24 34 89 5C 24 30 66 0F 28 15 ?? ?? ?? ?? 89 74 24 3C 89 7C 24 38 66 0F 59 D1 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 0C 24 66 0F 5C D3 8D 44 24 04 66 0F 28 C6 66 0F 59 E2 66 0F 29 74 24 10 66 0F 73 F6 04 66 0F 59 EA 66 0F 5C CC 66 0F FE 05 ?? ?? ?? ?? 66 0F 7E F6 66 0F 5C CD 81 E6 F0 03 00 00 66 0F 73 F0 2E 66 0F 15 F6 66 0F 28 BE ?? ?? ?? ?? 66 0F 28 E1 8B 08 66 0F 7E F7 66 0F 28 15 ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F DB 05 ?? ?? ?? ?? 66 0F 59 D1 66 0F 28 B7 ?? ?? ?? ?? 66 0F 59 C9 8B 58 08 66 0F 28 EF 66 0F 58 15 ?? ?? ?? ?? 66 0F C6 EE 00 66 0F 59 D4 81 E1 FF FF FF 7F 66 0F 58 15 ?? ?? ?? ?? 66 0F C6 FE 03 81 E3 FF FF FF 7F 66 0F 59 D4 66 0F 28 DD 66 0F 58 15 ?? ?? ?? ?? 81 E9 2B 23 86 40 66 0F 58 EF 66 0F 59 D1 81 EB 2B 23 86 40 66 0F 58 E2 8B F9 66 0F 59 E5 23 CB 66 0F 58 E7 8D 04 24 66 0F 58 E3 F7 C1 00 00 00 80 66 0F 59 C4 74 12 8B 5C 24 30 8B 4C 24 34 8B 7C 24 38 8B 74 24 3C EB 3E 66 0F 28 F0 66 0F 28 4C 24 10 66 0F 28 D4 E8 85 FD FF FF 66 0F 28 C2 83 C0 08 66 0F 28 4C 24 10 66 0F 28 D4 E8 6F FD FF FF 66 0F C6 C2 02 8B 5C 24 30 8B 4C 24 34 8B 7C 24 38 8B 74 24 3C 8B 64 24 54 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "___sse2_sin2"
		size = 448
		refs = "001c _static_const_table 016a ___common_sin_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC A0 00 00 00 83 E4 F0 89 44 24 64 66 0F 29 04 24 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 D0 66 0F 28 F8 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 BA 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F EF D9 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 5C D7 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 D2 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F EF C3 E9 84 00 00 00 66 0F 28 04 24 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 66 0F 29 44 24 30 66 0F 29 4C 24 40 DD 44 24 30 8D 44 24 20 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 14 33 C0 89 44 24 10 DD 44 24 38 8D 44 24 28 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 1C 33 C0 89 44 24 18 66 0F 28 54 24 20 66 0F 28 5C 24 10 66 0F 57 5C 24 40 E9 F3 FE FF FF 8B 64 24 64 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "___vdecl_fmod4"
		size = 89
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 40 C5 FE 7F 04 24 C5 FE 7F 4C 24 20 DD 04 24 DD 44 24 20 E8 ?? ?? ?? ?? DD 1C 24 DD 44 24 08 DD 44 24 28 E8 ?? ?? ?? ?? DD 5C 24 08 DD 44 24 10 DD 44 24 30 E8 ?? ?? ?? ?? DD 5C 24 10 DD 44 24 18 DD 44 24 38 E8 ?? ?? ?? ?? DD 5C 24 18 C5 FE 6F 04 24 83 C4 40 C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__allrem"
		size = 178
	strings:
		$1 = { 53 57 33 FF 8B 44 24 10 0B C0 7D 14 47 8B 54 24 0C F7 D8 F7 DA 83 D8 00 89 44 24 10 89 54 24 0C 8B 44 24 18 0B C0 7D 13 8B 54 24 14 F7 D8 F7 DA 83 D8 00 89 44 24 18 89 54 24 14 0B C0 75 1B 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B 44 24 0C F7 F1 8B C2 33 D2 4F 79 4E EB 53 8B D8 8B 4C 24 14 8B 54 24 10 8B 44 24 0C D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B C8 F7 64 24 18 91 F7 64 24 14 03 D1 72 0E 3B 54 24 10 77 08 72 0E 3B 44 24 0C 76 08 2B 44 24 14 1B 54 24 18 2B 44 24 0C 1B 54 24 10 4F 79 07 F7 DA F7 D8 83 DA 00 5F 5B C2 10 00 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__sinh_spec_sd"
		size = 320
		refs = "004f _static_const_table"
	strings:
		$1 = { 8B 58 04 8B 08 81 E3 FF FF FF 7F 81 FB 36 23 86 40 0F 82 15 01 00 00 F2 0F 10 30 0F 87 BE 00 00 00 81 FB 50 3C 9C F4 0F 82 FF 00 00 00 81 FB C3 33 86 40 72 2D 77 08 81 F9 00 79 98 78 72 23 8B 48 50 C1 E1 04 81 E1 F0 03 00 00 66 0F 28 B9 ?? ?? ?? ?? 66 0F 28 EF BB 01 00 00 00 66 0F 15 FF EB 0C F2 0F 10 68 10 F2 0F 10 78 20 33 DB 66 0F 28 DD F2 0F 10 70 40 66 0F 28 D6 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 CE 66 0F 58 EF F2 0F 59 F6 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 58 D1 F2 0F 59 D5 F2 0F 10 30 F2 0F 58 D7 85 DB F2 0F 58 D3 74 51 F2 0F 59 15 ?? ?? ?? ?? 33 DB F2 0F 59 15 ?? ?? ?? ?? EB 3D 81 FB CE 33 86 40 0F 82 42 FF FF FF 77 18 81 FB 7D F8 B9 8F 0F 82 34 FF FF FF 33 DB F2 0F 10 15 ?? ?? ?? ?? EB 17 81 FB 00 00 F0 7F 72 EC 77 04 85 C9 74 E8 66 0F 57 D2 66 0F C2 D2 00 66 0F 54 35 ?? ?? ?? ?? 85 DB 66 0F 56 D6 74 01 C3 66 0F 28 2D ?? ?? ?? ?? 66 0F 58 ED C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "___sse2_sinh2"
		size = 560
		refs = "0016 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC E0 00 00 00 83 E4 F0 89 84 24 A4 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 89 74 24 08 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 54 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 4C 24 10 66 0F 5C D3 8D 44 24 10 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 66 0F C2 3D ?? ?? ?? ?? 05 66 0F 73 F6 04 66 0F 29 4C 24 60 66 0F 59 EA 66 0F FB D9 66 0F 5C C4 66 0F 7E F6 89 7C 24 04 66 0F 5C C5 66 0F 50 CF 66 0F FE 0D ?? ?? ?? ?? 81 E6 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F7 66 0F 28 BE ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 50 F7 DE 66 0F 28 B7 ?? ?? ?? ?? 81 C6 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DF 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C7 00 04 00 00 66 0F 28 A6 ?? ?? ?? ?? 66 0F C6 FE 03 66 0F 28 97 ?? ?? ?? ?? 66 0F 59 E9 66 0F 28 F4 66 0F 59 F9 66 0F C6 E2 00 66 0F 29 6C 24 20 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 40 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? F7 C1 03 00 00 00 66 0F 59 D0 66 0F 58 E6 66 0F 29 7C 24 30 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 5C EC 66 0F 59 D8 66 0F 58 FC 66 0F 28 44 24 30 66 0F 59 D1 66 0F 28 20 66 0F 59 DD 66 0F 58 D1 8B 74 24 08 66 0F 5C C6 66 0F 54 25 ?? ?? ?? ?? 66 0F 59 D7 66 0F 28 6C 24 20 66 0F 58 C3 66 0F 5C 6C 24 40 66 0F 58 C2 8B 7C 24 04 66 0F 58 C5 66 0F 56 C4 75 02 EB 2F 89 1C 24 8D 44 24 10 66 0F 28 E0 66 0F 28 D0 66 0F 15 E4 E8 B6 FC FF FF 83 C0 08 66 0F 28 C2 66 0F 28 D4 E8 A6 FC FF FF 66 0F 14 C2 8B 1C 24 8B A4 24 A4 00 00 00 C3 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "___common_sin_reduction_LA"
		size = 752
		refs = "006c __d02PI 0095 __DP4 013c __e02PI 0175 _2il0floatpacket_2 02aa __dPI02"
	strings:
		$1 = { 55 8B EC 83 E4 F0 56 57 53 83 EC 54 B8 00 00 F0 7F 8B 55 0C 8B 5D 10 2B D0 0F 8D B7 02 00 00 33 C0 66 89 44 24 3C D9 7C 24 3E 0F B7 54 24 3E 8B C2 25 00 0F 00 00 3D 00 03 00 00 74 15 81 E2 FF F0 FF FF 81 CA 00 03 FF FF 66 89 54 24 3C D9 6C 24 3C DD 45 08 F2 0F 10 45 08 8B 45 0C DB 7C 24 48 81 7D 0C 00 40 FF 40 73 6E DB 2D ?? ?? ?? ?? DB 6C 24 48 DC C9 D9 C9 D9 3C 24 0F B7 04 24 0D 00 0C 00 00 89 44 24 08 D9 6C 24 08 DB 5C 24 10 D9 2C 24 DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B 7C 24 10 47 83 E7 FE 89 7C 24 18 DB 44 24 18 DC CC D9 CC DE ED D9 CA D8 CB DE EC D8 CA DE EB DE C9 DE E9 DB 7C 24 48 E9 DC 01 00 00 8B C8 05 00 00 80 F3 C1 E9 14 81 E1 FF 07 00 00 F2 0F 11 44 24 10 89 44 24 14 B8 1F 85 EB 51 DD 44 24 10 DB 3C 24 DB 2C 24 8D B9 E4 FB FF FF F7 EF 8B F2 C1 FE 03 C1 FF 1F 2B F7 83 64 24 04 C0 C7 04 24 00 00 00 00 DB 2C 24 6B C6 E7 DC E9 D9 C9 DB 7C 24 20 8D 94 08 E4 FB FF FF 83 FA 11 7C 3A DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 46 D8 CA DB 6C 24 20 DE CA DE C1 DB 7C 24 10 DB 6C 24 10 83 64 24 14 C0 C7 44 24 10 00 00 00 00 DB 6C 24 10 DE E9 DB 7C 24 48 EB 0A DB 2D ?? ?? ?? ?? DB 7C 24 48 DD 04 F5 ?? ?? ?? ?? D9 C1 DD 04 F5 ?? ?? ?? ?? DC C9 DD 04 F5 ?? ?? ?? ?? DE CC DB 6C 24 20 DC CB D9 CA DE C3 DE C9 DE C2 D9 C9 DB 7C 24 10 DB 6C 24 10 DB 6C 24 48 DE C2 D9 C9 DB 7C 24 48 DB 6C 24 48 DE C1 DD 5C 24 30 F2 0F 10 44 24 30 F2 0F 11 44 24 40 8B 44 24 44 C1 E8 14 25 FF 07 00 00 F7 D8 05 33 04 00 00 89 44 24 2C 50 FF 74 24 48 FF 74 24 48 E8 F9 00 00 00 83 C4 0C 8B F8 83 C7 01 83 D2 00 83 E7 FE 89 54 24 44 89 7C 24 40 FF 74 24 2C 52 57 E8 08 01 00 00 83 C4 0C DB 6C 24 48 DB 6C 24 10 DB 6C 24 20 DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 89 44 24 40 89 54 24 44 DB 7C 24 30 DD 44 24 40 DE EE D9 CC DE C5 D9 C1 D9 CA D8 CB DB 2C 24 DC CB DD 04 F5 ?? ?? ?? ?? D8 CD DE C4 D9 CB DE C6 D9 C1 D8 CB DE C1 DE C5 D9 C3 D8 CA D9 C9 D8 CB DE C1 DE C4 D9 C9 DC CA DB 6C 24 30 D9 C0 D8 CB DE C4 D9 CB DE C4 DE CA DD 04 F5 ?? ?? ?? ?? DE C9 DE C1 DE C1 DB 2D ?? ?? ?? ?? DE C9 DB 7C 24 48 DB 6C 24 48 0F B7 44 24 3C 85 C0 DD 1B 74 04 D9 6C 24 3E C1 E7 1E 8B C7 83 C4 54 5B 5F 5E 8B E5 5D C3 33 C0 C7 03 FF FF FF FF C7 43 04 FF FF FF 7F 83 C4 54 5B 5F 5E 8B E5 5D C3 90 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "___common_srl"
		size = 48
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 8B 4C 24 0C 80 F9 40 73 16 80 F9 20 73 06 0F AD D0 D3 FA C3 8B C2 C1 FA 1F 80 E1 1F D3 F8 C3 C1 FA 1F 8B C2 C3 8D 49 00 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "___common_sll"
		size = 48
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 8B 4C 24 0C 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 8B D0 33 C0 80 E1 1F D3 E2 C3 33 C0 33 D2 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "___common_cos_reduction_LA"
		size = 752
		refs = "006c __d02PI 0095 __DP4 013b __e02PI 0174 _2il0floatpacket_9 02a3 __dPI02"
	strings:
		$1 = { 55 8B EC 83 E4 F0 56 57 53 83 EC 54 B8 00 00 F0 7F 8B 55 0C 8B 5D 10 2B D0 0F 8D B8 02 00 00 33 C0 66 89 44 24 3C D9 7C 24 3E 0F B7 54 24 3E 8B C2 25 00 0F 00 00 3D 00 03 00 00 74 15 81 E2 FF F0 FF FF 81 CA 00 03 FF FF 66 89 54 24 3C D9 6C 24 3C DD 45 08 F2 0F 10 45 08 8B 45 0C DB 7C 24 48 81 7D 0C 00 40 FF 40 73 6D DB 2D ?? ?? ?? ?? DB 6C 24 48 DC C9 D9 C9 D9 3C 24 0F B7 04 24 0D 00 0C 00 00 89 44 24 08 D9 6C 24 08 DB 5C 24 10 D9 2C 24 DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B 7C 24 10 83 CF 01 89 7C 24 18 DB 44 24 18 DC CC D9 CC DE ED D9 CA D8 CB DE EC D8 CA DE EB DE C9 DE E9 DB 7C 24 48 E9 D6 01 00 00 8B C8 05 00 00 80 F3 C1 E9 14 81 E1 FF 07 00 00 F2 0F 11 44 24 10 89 44 24 14 B8 1F 85 EB 51 DD 44 24 10 DB 3C 24 DB 2C 24 8D B9 E4 FB FF FF F7 EF 8B F2 C1 FE 03 C1 FF 1F 2B F7 83 64 24 04 C0 C7 04 24 00 00 00 00 DB 2C 24 6B C6 E7 DC E9 D9 C9 DB 7C 24 20 8D 94 08 E4 FB FF FF 83 FA 11 7C 3A DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 46 D8 CA DB 6C 24 20 DE CA DE C1 DB 7C 24 10 DB 6C 24 10 83 64 24 14 C0 C7 44 24 10 00 00 00 00 DB 6C 24 10 DE E9 DB 7C 24 48 EB 0A DB 2D ?? ?? ?? ?? DB 7C 24 48 DD 04 F5 ?? ?? ?? ?? D9 C1 DD 04 F5 ?? ?? ?? ?? DC C9 DD 04 F5 ?? ?? ?? ?? DE CC DB 6C 24 20 DC CB D9 CA DE C3 DE C9 DE C2 D9 C9 DB 7C 24 10 DB 6C 24 10 DB 6C 24 48 DE C2 D9 C9 DB 7C 24 48 DB 6C 24 48 DE C1 DD 5C 24 30 F2 0F 10 44 24 30 F2 0F 11 44 24 40 8B 44 24 44 C1 E8 14 25 FF 07 00 00 F7 D8 05 33 04 00 00 89 44 24 2C 50 FF 74 24 48 FF 74 24 48 E8 AA FD FF FF 83 C4 0C 8B F8 83 CF 01 89 54 24 44 89 7C 24 40 FF 74 24 2C 52 57 E8 BF FD FF FF 83 C4 0C DB 6C 24 48 DB 6C 24 10 DB 6C 24 20 DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 89 44 24 40 89 54 24 44 DB 7C 24 30 DD 44 24 40 DE EE D9 CC DE C5 D9 C1 D9 CA D8 CB DB 2C 24 DC CB DD 04 F5 ?? ?? ?? ?? D8 CD DE C4 D9 CB DE C6 D9 C1 D8 CB DE C1 DE C5 D9 C3 D8 CA D9 C9 D8 CB DE C1 DE C4 D9 C9 DC CA DB 6C 24 30 D9 C0 D8 CB DE C4 D9 CB DE C4 DE CA DD 04 F5 ?? ?? ?? ?? DE C9 DE C1 DE C1 DB 2D ?? ?? ?? ?? DE C9 DB 7C 24 48 DB 6C 24 48 0F B7 44 24 3C 85 C0 DD 1B 74 04 D9 6C 24 3E C1 E7 1E F7 D7 81 E7 00 00 00 80 8B C7 83 C4 54 5B 5F 5E 8B E5 5D C3 33 C0 C7 03 FF FF FF FF C7 43 04 FF FF FF 7F 83 C4 54 5B 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_4_0 {
	meta:
		name = "___common_pi04_reduction_LA"
		size = 784
		refs = "006c __d04PI 0095 __QP4 00a7 __dPI04 0144 __e04PI 017d _2il0floatpacket_12 02c1 __dPI02"
	strings:
		$1 = { 55 8B EC 83 E4 F0 56 57 53 83 EC 54 B8 00 00 F0 7F 8B 55 0C 8B 5D 10 2B D0 0F 8D D2 02 00 00 33 C0 66 89 44 24 44 D9 7C 24 46 0F B7 54 24 46 8B C2 25 00 0F 00 00 3D 00 03 00 00 74 15 81 E2 FF F0 FF FF 81 CA 00 03 FF FF 66 89 54 24 44 D9 6C 24 44 DD 45 08 F2 0F 10 45 08 8B 45 0C DB 7C 24 38 81 7D 0C 00 40 FF 40 73 76 DB 2D ?? ?? ?? ?? DB 6C 24 38 DC C9 D9 C9 D9 3C 24 0F B7 04 24 0D 00 0C 00 00 89 44 24 08 D9 6C 24 08 DB 5C 24 10 D9 2C 24 DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? 8B 7C 24 10 47 83 E7 FE 89 7C 24 18 DB 44 24 18 DC CC D9 CC DE ED D9 CA D8 CB DE EC D8 CA DE EB D9 C9 DC 0D ?? ?? ?? ?? DE EA D9 C9 DB 7C 24 38 E9 D0 01 00 00 8B C8 05 00 00 80 F3 C1 E9 14 81 E1 FF 07 00 00 F2 0F 11 44 24 10 89 44 24 14 B8 1F 85 EB 51 DD 44 24 10 DB 3C 24 DB 2C 24 8D B9 E4 FB FF FF F7 EF 8B F2 C1 FE 03 C1 FF 1F 2B F7 83 64 24 04 C0 C7 04 24 00 00 00 00 DB 2C 24 6B C6 E7 DC E9 D9 C9 DB 7C 24 20 8D 94 08 E4 FB FF FF 83 FA 11 7C 3A DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? 46 D8 CA DB 6C 24 20 DE CA DE C1 DB 7C 24 10 DB 6C 24 10 83 64 24 14 C0 C7 44 24 10 00 00 00 00 DB 6C 24 10 DE E9 DB 7C 24 38 EB 0A DB 2D ?? ?? ?? ?? DB 7C 24 38 DD 04 F5 ?? ?? ?? ?? D9 C1 D8 C9 D9 CA DC 0C F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DB 6C 24 20 DC C9 D9 CC DE C1 D9 CB DE CA DE C1 DB 7C 24 10 DB 6C 24 10 DB 6C 24 38 DE C2 D9 C9 DB 7C 24 38 DB 6C 24 38 DE C1 DD 5C 24 30 8B 44 24 34 C1 E8 14 25 FF 07 00 00 F7 D8 05 33 04 00 00 89 44 24 2C 50 FF 74 24 38 FF 74 24 38 E8 BD FA FF FF 83 C4 0C 8B F8 83 C7 01 83 D2 00 83 E7 FE 89 54 24 34 89 7C 24 30 FF 74 24 2C 52 57 E8 CC FA FF FF 83 C4 0C DB 6C 24 38 DB 6C 24 10 DB 2C 24 DB 6C 24 20 DD 04 F5 ?? ?? ?? ?? 89 44 24 30 D9 C0 89 54 24 34 D8 CB D9 C9 D8 CA D9 CD DC 64 24 30 DE C4 DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? D8 CC DE C3 D9 CA DE C5 D9 C3 D8 C9 DE C6 D9 CD DE C4 D9 C2 D8 C9 D9 CA DC CD D9 CA DE C5 D9 CC DE C3 D9 C1 D9 C9 DC CC D9 CA DC 0C F5 ?? ?? ?? ?? DD 04 F5 ?? ?? ?? ?? DC CA D9 CA DE C5 D9 CC DE C3 DE C9 DE C2 DE C1 DB 2D ?? ?? ?? ?? DC C9 D9 C9 DB 7C 24 38 DB 6C 24 38 D1 FF DE D9 DF E0 9E 7A 02 76 13 DB 2D ?? ?? ?? ?? 83 C7 FD DB 6C 24 38 DE E1 DB 7C 24 38 DB 6C 24 38 0F B7 44 24 44 85 C0 DD 1B 74 04 D9 6C 24 46 8B C7 83 C4 54 5B 5F 5E 8B E5 5D C3 33 C0 C7 03 FF FF FF FF C7 43 04 FF FF FF 7F 83 C4 54 5B 5F 5E 8B E5 5D C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "@_RTC_AllocaHelper@12"
		size = 50
	strings:
		$1 = { 55 8B EC 53 56 8B F1 8B DA 85 F6 74 1F 85 DB 74 1B 8B 55 08 85 D2 74 14 57 B0 CC 8B FE 8B CB F3 AA 8B 02 89 46 04 89 5E 0C 89 32 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "@_RTC_CheckStackVars2@12"
		size = 198
		refs = "0042 ?_RTC_StackFailure@@YAXPAXPBD@Z 0094 ?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 8B DA 33 FF 85 DB 74 48 89 7D FC 39 3B 7E 41 8B F7 8B F9 8B 4B 04 8B 14 0E 81 7C 3A FC CC CC CC CC 75 0F 8B 44 0E 04 03 C2 81 3C 38 CC CC CC CC 74 0E FF 74 0E 08 FF 75 04 E8 ?? ?? ?? ?? 59 59 8B 45 FC 83 C6 0C 40 89 45 FC 3B 03 7C C5 33 FF 8B 75 08 8B C6 85 F6 74 5C 8B 40 04 47 85 C0 75 F8 EB 4E 81 3E CC CC CC CC 75 1B 81 7E 14 CC CC CC CC 75 12 81 7E 18 CC CC CC CC 75 09 81 7E 1C CC CC CC CC 74 0D 57 56 FF 75 04 E8 ?? ?? ?? ?? 83 C4 0C 8B 46 0C 81 7C 30 FC CC CC CC CC 74 0D 57 56 FF 75 04 E8 ?? ?? ?? ?? 83 C4 0C 8B 76 04 4F 85 F6 75 AE 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_35_2_0 {
	meta:
		name = "@_RTC_CheckStackVars@8"
		size = 88
		refs = "0040 ?_RTC_StackFailure@@YAXPAXPBD@Z"
	strings:
		$1 = { 55 8B EC 51 53 8B DA 8B C1 56 33 F6 89 45 FC 39 33 7E 3F 57 8B FE 8B 4B 04 8B 14 0F 81 7C 02 FC CC CC CC CC 75 12 8B 44 0F 04 03 C2 8B 55 FC 81 3C 10 CC CC CC CC 74 0E FF 74 0F 08 FF 75 04 E8 ?? ?? ?? ?? 59 59 8B 45 FC 46 83 C7 0C 3B 33 7C C5 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_3_0 {
	meta:
		name = "__RTC_CheckEsp"
		size = 47
		refs = "001a ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { F2 75 02 F2 C3 55 8B EC 83 EC 00 50 0F 1B 04 04 52 53 56 57 6A 00 FF 75 04 E8 ?? ?? ?? ?? 59 59 5F 5E 5B 5A 58 0F 1A 44 04 FC 8B E5 5D F2 C3 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "__vmlsAtan24Spec"
		size = 2800
		refs = "0073 INFP_1898_0_2 0086 INFN_1898_0_2 00da _2il0floatpacket_46 010e _2il0floatpacket_50 0116 _2il0floatpacket_54 0120 _2il0floatpacket_49 012a _2il0floatpacket_53 0134 _2il0floatpacket_48 013e _2il0floatpacket_52 0148 _2il0floatpacket_47 0159 _2il0floatpacket_51 016c m_or_p_1898_0_2 0173 pi_or_zero_1898_0_2 0632 _2il0floatpacket_39 063f _2il0floatpacket_38 065d _2il0floatpacket_41 066b _2il0floatpacket_40 0678 _2il0floatpacket_45 0685 _2il0floatpacket_44 06a7 NEGZERO_1898_0_2 06c0 _2il0floatpacket_43 06cd _2il0floatpacket_42"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 1C 8B 45 0C 8B 55 08 8B 18 8B FB 8B 32 8B CE F3 0F 10 22 8B D3 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 18 0F 8F 43 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 2F 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 90 06 00 00 0F 2E D8 7A 06 0F 84 67 06 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 0C 06 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 B3 05 00 00 0F 2E E2 7A 06 0F 84 9B 05 00 00 0F 2E E1 7A 06 0F 84 83 05 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 34 24 81 C9 00 00 80 3F 89 5C 24 04 F3 0F 10 14 24 F3 0F 10 4C 24 04 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 22 8B 58 04 8B FB 8B 71 04 8B D3 F3 0F 10 61 04 8B CE 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 58 04 0F 8F 45 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 3B 06 00 00 0F 2E D8 7A 06 0F 84 12 06 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 B7 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 5E 05 00 00 0F 2E E2 7A 06 0F 84 46 05 00 00 0F 2E E1 7A 06 0F 84 2E 05 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 74 24 14 81 C9 00 00 80 3F 89 5C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 62 04 8B 58 08 8B FB 8B 71 08 8B D3 F3 0F 10 61 08 8B CE 81 E7 FF FF FF 7F 81 E1 00 00 00 80 81 E2 00 00 00 80 81 FF 00 00 80 7F F3 0F 10 58 08 0F 8F 45 01 00 00 8B FE 81 E7 FF FF FF 7F 81 FF 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 E3 05 00 00 0F 2E D8 7A 06 0F 84 BA 05 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 5F 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 06 05 00 00 0F 2E E2 7A 06 0F 84 EE 04 00 00 0F 2E E1 7A 06 0F 84 D6 04 00 00 81 E6 FF FF FF 7F 81 E3 FF FF FF 7F 89 74 24 14 81 C9 00 00 80 3F 89 5C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 4C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FA 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C D5 ?? ?? ?? ?? DC 04 D5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 55 10 8B 4D 08 F3 0F 11 62 08 F3 0F 10 61 0C 8B 51 0C 8B DA 8B 48 0C 8B F1 F3 0F 10 58 0C 8B C1 25 FF FF FF 7F 81 E3 00 00 00 80 81 E6 00 00 00 80 3D 00 00 80 7F 0F 8F 43 01 00 00 8B C2 25 FF FF FF 7F 3D 00 00 80 7F 0F 8F 31 01 00 00 0F 57 C0 0F 2E E0 7A 06 0F 84 8F 05 00 00 0F 2E D8 7A 06 0F 84 66 05 00 00 F3 0F 10 15 ?? ?? ?? ?? 0F 2E DA 7A 06 0F 84 0B 05 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 2E D9 7A 06 0F 84 B2 04 00 00 0F 2E E2 7A 06 0F 84 9A 04 00 00 0F 2E E1 7A 06 0F 84 82 04 00 00 81 E2 FF FF FF 7F 81 E1 FF FF FF 7F 89 54 24 14 81 CB 00 00 80 3F 89 4C 24 18 F3 0F 10 54 24 14 F3 0F 10 4C 24 18 89 5C 24 10 0F 2F D1 76 18 DD 05 ?? ?? ?? ?? F3 0F 5C C1 F3 0F 5E C2 F3 0F 11 04 24 D9 04 24 EB 0E F3 0F 5E D1 F3 0F 11 14 24 D9 EE D9 04 24 D9 44 24 10 D9 C1 D8 CA D9 C0 D8 C9 D9 E8 DD 05 ?? ?? ?? ?? D8 CA DD 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? D8 CB D9 C9 DC 05 ?? ?? ?? ?? DE CB C1 FE 1F D9 CA DE C1 D9 C9 DC 05 ?? ?? ?? ?? DE CA DE C1 DE CA D9 C9 DE C2 D9 C9 DC 0C F5 ?? ?? ?? ?? DC 04 F5 ?? ?? ?? ?? DE C9 D9 5C 24 08 F3 0F 10 64 24 08 EB 04 F3 0F 58 E3 8B 45 10 F3 0F 11 60 0C 83 C4 1C 5B 5F 5E 8B E5 5D C3 F3 0F 10 25 ?? ?? ?? ?? E9 4E FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 41 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 22 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 15 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 08 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FB FA FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 D5 FA FF FF 0F 28 E1 E9 CD FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C0 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B3 FA FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 A2 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 95 FA FF FF 85 C9 74 33 0F 2F D8 0F 87 88 FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 73 FA FF FF 0F 28 E0 E9 6B FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 5E FA FF FF 0F 2F D8 0F 87 55 FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 40 FA FF FF 0F 28 E0 E9 38 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 2B FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 A5 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 98 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 79 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 6C FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 5F FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 52 FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 2C FB FF FF 0F 28 E1 E9 24 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 17 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0A FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 F9 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 EC FA FF FF 85 C9 74 33 0F 2F D8 0F 87 DF FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 CA FA FF FF 0F 28 E0 E9 C2 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B5 FA FF FF 0F 2F D8 0F 87 AC FA FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 97 FA FF FF 0F 28 E0 E9 8F FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 82 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FD FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 F0 FB FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 D1 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C4 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B7 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 AA FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 84 FB FF FF 0F 28 E1 E9 7C FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 6F FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 62 FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 51 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 44 FB FF FF 85 C9 74 33 0F 2F D8 0F 87 37 FB FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 22 FB FF FF 0F 28 E0 E9 1A FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0D FB FF FF 0F 2F D8 0F 87 04 FB FF FF 0F 2F C3 77 18 85 D2 F3 0F 10 05 ?? ?? ?? ?? 0F 84 EF FA FF FF 0F 28 E0 E9 E7 FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 DA FA FF FF F3 0F 10 25 ?? ?? ?? ?? E9 51 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 44 FC FF FF 0F 2E E2 7A 02 74 32 0F 2E E1 7A 02 74 1E 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 25 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 18 FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 0B FC FF FF F3 0F 10 25 ?? ?? ?? ?? E9 FE FB FF FF 0F 2E E2 7A 02 74 34 0F 2E 25 ?? ?? ?? ?? 7A 02 74 1C 0F 2F C4 F3 0F 10 0D ?? ?? ?? ?? 0F 28 E0 0F 86 D8 FB FF FF 0F 28 E1 E9 D0 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 C3 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 B6 FB FF FF 0F 2F E0 F3 0F 10 25 ?? ?? ?? ?? 0F 87 A5 FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 98 FB FF FF 85 DB 74 33 0F 2F D8 0F 87 8B FB FF FF 0F 2F C3 77 18 85 F6 F3 0F 10 05 ?? ?? ?? ?? 0F 84 76 FB FF FF 0F 28 E0 E9 6E FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 61 FB FF FF 0F 2F D8 0F 87 58 FB FF FF 0F 2F C3 77 18 85 F6 F3 0F 10 05 ?? ?? ?? ?? 0F 84 43 FB FF FF 0F 28 E0 E9 3B FB FF FF F3 0F 10 25 ?? ?? ?? ?? E9 2E FB FF FF 8B FF }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "___sse2_atan2f4"
		size = 368
		refs = "0012 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC A0 00 00 00 83 E4 F0 89 44 24 64 0F 28 15 ?? ?? ?? ?? 0F 28 EA 0F 29 44 24 20 0F 54 E9 0F 54 D0 0F 28 35 ?? ?? ?? ?? 0F 29 4C 24 30 0F 54 C6 0F 28 FE 0F 56 05 ?? ?? ?? ?? 0F 28 DD 0F 54 F9 0F 29 44 24 10 0F 56 3D ?? ?? ?? ?? 0F C2 DA 01 0F 28 E3 0F 54 E5 0F 28 C3 0F 55 C2 0F 56 E0 0F 54 D3 0F 28 C3 0F 55 C5 0F 56 D0 0F 5E E2 D9 44 24 20 D8 4C 24 24 D8 4C 24 28 D8 4C 24 2C D9 44 24 30 D8 4C 24 34 D8 4C 24 38 D8 4C 24 3C DE C9 DD 1C 24 0F 54 F3 0F 57 ED 0F 54 1D ?? ?? ?? ?? 0F C2 CD 01 0F 56 E6 0F 54 0D ?? ?? ?? ?? 0F 28 C4 8B 44 24 04 0F 59 C4 0F 28 D0 0F 59 D0 0F 28 35 ?? ?? ?? ?? 25 00 00 F0 7F 0F 59 F2 0F 28 2D ?? ?? ?? ?? 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 C5 0F 58 35 ?? ?? ?? ?? 0F 58 C6 0F 59 C4 0F 28 6C 24 10 0F 58 C3 0F 59 C7 0F 58 C1 0F 59 C5 74 09 3D 00 00 F0 7F 74 02 EB 27 83 EC 20 8D 44 24 40 89 04 24 8D 44 24 50 89 44 24 04 8D 44 24 60 89 44 24 08 E8 B2 F3 FF FF 83 C4 20 0F 28 44 24 40 8B 64 24 64 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "___common_scosh_cout_rare"
		size = 1008
		refs = "0011 __vmldCoshHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 3C 8B 4D 08 F2 0F 10 0D ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 51 02 81 E2 80 7F 00 00 81 FA 80 7F 00 00 0F 84 9A 03 00 00 F3 0F 5A 01 F2 0F 11 44 24 20 80 64 24 27 7F 0F B7 54 24 26 81 E2 F0 7F 00 00 81 FA 90 3C 00 00 0F 8E 51 03 00 00 F2 0F 10 74 24 20 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C6 0F 86 15 03 00 00 F2 0F 11 4C 24 30 66 0F 2F 35 ?? ?? ?? ?? 0F 82 3B 01 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C6 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 04 24 F2 0F 10 0C 24 8B 0C 24 8B D1 83 E2 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 08 F2 0F 10 54 24 08 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 08 F2 0F 5C F2 F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C F3 F2 0F 59 CE C1 E2 04 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 10 A2 ?? ?? ?? ?? C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE 81 C1 FF 03 00 00 49 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE 81 E1 FF 07 00 00 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 59 CE F2 0F 58 CE F2 0F 59 CC F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 CC 77 2E C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 F2 0F 10 44 24 30 F2 0F 59 C1 F2 0F 5A C0 8B 45 0C F3 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 49 81 E1 FF 07 00 00 0F B7 44 24 36 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 33 C0 F2 0F 59 4C 24 30 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5A C9 8B 55 0C F3 0F 11 0A 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FE 0F B7 4C 24 36 81 E1 0F 80 FF FF F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 3C 24 F2 0F 10 2C 24 8B 34 24 8B D6 C1 EA 06 83 E6 3F 81 C2 FF 03 00 00 F2 0F 5C 2D ?? ?? ?? ?? F2 0F 11 6C 24 08 81 E2 FF 07 00 00 F2 0F 10 5C 24 08 F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 64 24 08 8D 42 FF F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C F3 F2 0F 10 2D ?? ?? ?? ?? 25 FF 07 00 00 C1 E6 04 F7 DA C1 E0 04 83 C2 FC 0B C8 81 E2 FF 07 00 00 66 89 4C 24 36 81 E1 0F 80 FF FF F2 0F 10 44 24 30 F2 0F 5C F4 0F 28 D6 F2 0F 59 D6 F2 0F 59 EA F2 0F 10 8E ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 10 9E ?? ?? ?? ?? F7 DE C1 E2 04 0B CA 66 89 4C 24 36 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 4C 24 20 F2 0F 59 D8 F2 0F 59 E2 F2 0F 59 EA F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E2 F2 0F 59 EA F2 0F 59 E6 F2 0F 10 7C 24 30 0F 28 C3 F2 0F 10 8E ?? ?? ?? ?? F2 0F 59 CF F2 0F 10 96 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 59 D7 F2 0F 11 44 24 10 0F 28 C3 F2 0F 10 7C 24 10 F2 0F 5C D9 F2 0F 5C C7 F2 0F 59 E3 F2 0F 58 C1 F2 0F 10 4C 24 20 F2 0F 11 44 24 18 F2 0F 5C CA F2 0F 59 CE F2 0F 59 F3 F2 0F 58 CA F2 0F 10 7C 24 10 F2 0F 10 44 24 18 F2 0F 11 7C 24 28 F2 0F 10 54 24 28 F2 0F 59 EA F2 0F 58 4C 24 20 8B 45 0C F2 0F 58 C8 F2 0F 58 CC F2 0F 58 CD F2 0F 58 CE F2 0F 11 4C 24 10 F2 0F 10 74 24 10 F2 0F 58 D6 F2 0F 5A D2 F3 0F 11 10 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 F2 0F 5A C0 8B 45 0C F3 0F 11 00 B8 03 00 00 00 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 44 24 20 F2 0F 5A C0 F3 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 F3 0F 10 01 F3 0F 59 C0 8B 45 0C F3 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "___raise_securityfailure"
		size = 40
		refs = "0007 __imp__SetUnhandledExceptionFilter@4 0010 __imp__UnhandledExceptionFilter@4 001b __imp__GetCurrentProcess@0 0022 __imp__TerminateProcess@8"
	strings:
		$1 = { 55 8B EC 6A 00 FF 15 ?? ?? ?? ?? FF 75 08 FF 15 ?? ?? ?? ?? 68 09 04 00 C0 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "___report_gsfailure"
		size = 251
		refs = "000c _IsProcessorFeaturePresent@4 001a _GS_ContextRecord 009b _GS_ExceptionRecord 00d5 ___security_cookie 00e5 ___security_cookie_complement 00ee _GS_ExceptionPointers 00f3 ___raise_securityfailure"
	strings:
		$1 = { 55 8B EC 81 EC 24 03 00 00 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 6A 02 59 CD 29 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 DC FC FF FF C7 05 ?? ?? ?? ?? 01 00 01 00 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 6A 04 58 6B C0 00 C7 80 ?? ?? ?? ?? 02 00 00 00 6A 04 58 6B C0 00 8B 0D ?? ?? ?? ?? 89 4C 05 F8 6A 04 58 C1 E0 00 8B 0D ?? ?? ?? ?? 89 4C 05 F8 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_3_0 {
	meta:
		name = "___report_securityfailure"
		size = 208
		refs = "000c _IsProcessorFeaturePresent@4 001a _GS_ContextRecord 0091 _GS_ExceptionRecord 00c3 _GS_ExceptionPointers 00c8 ___raise_securityfailure"
	strings:
		$1 = { 55 8B EC 81 EC 1C 03 00 00 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 8B 4D 08 CD 29 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 E4 FC FF FF A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 6A 04 58 6B C0 00 8B 4D 08 89 88 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_4_0 {
	meta:
		name = "___report_securityfailureEx"
		size = 278
		refs = "000c _IsProcessorFeaturePresent@4 001a _GS_ContextRecord 0091 _GS_ExceptionRecord 0109 _GS_ExceptionPointers 010e ___raise_securityfailure"
	strings:
		$1 = { 55 8B EC 81 EC 20 03 00 00 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 8B 4D 08 CD 29 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 E0 FC FF FF A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 83 7D 0C 00 76 0A 83 7D 10 00 75 04 83 65 0C 00 83 7D 0C 0E 76 07 8B 45 0C 48 89 45 0C 8B 45 0C 40 A3 ?? ?? ?? ?? 6A 04 58 6B C0 00 8B 4D 08 89 88 ?? ?? ?? ?? 83 65 FC 00 EB 07 8B 45 FC 40 89 45 FC 8B 45 FC 3B 45 0C 73 15 8B 45 FC 8B 4D FC 8B 55 10 8B 0C 8A 89 0C 85 ?? ?? ?? ?? EB DC 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "___sse2_atan2"
		size = 416
		refs = "0010 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 34 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 54 E0 66 0F 29 24 24 66 0F 57 C4 66 0F C2 C8 01 66 0F 54 D9 66 0F 29 5C 24 10 66 0F 28 E1 66 0F DF C8 66 0F DB D4 66 0F EB CA 66 0F DB C4 66 0F DF 25 ?? ?? ?? ?? 66 0F EB C4 66 0F 5E C8 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 10 66 0F 56 34 24 66 0F 28 C6 8B 64 24 34 C3 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__aulldiv"
		size = 104
	strings:
		$1 = { 53 56 8B 44 24 18 0B C0 75 18 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B D8 8B 44 24 0C F7 F1 8B D3 EB 41 8B C8 8B 5C 24 14 8B 54 24 10 8B 44 24 0C D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 18 8B C8 8B 44 24 14 F7 E6 03 D1 72 0E 3B 54 24 10 77 08 72 07 3B 44 24 0C 76 01 4E 33 D2 8B C6 5E 5B C2 10 00 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "___sse2_log10f4"
		size = 320
		refs = "0010 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 60 83 E4 F0 89 44 24 24 66 0F 6F 15 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F DB D0 66 0F 6F 0D ?? ?? ?? ?? 0F 11 04 24 66 0F FE DA 66 0F 6F 25 ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 66 E0 66 0F EF CB 66 0F 72 E3 17 66 0F EB D1 66 0F 6F C8 66 0F 72 E0 17 66 0F 66 0D ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 66 0F 6F FA 66 0F 6F D0 66 0F FE D3 66 0F DB E1 66 0F D7 C4 0F 28 DF 0F 28 0D ?? ?? ?? ?? 0F 5C 1D ?? ?? ?? ?? 0F 28 05 ?? ?? ?? ?? 0F 58 CB 0F 28 25 ?? ?? ?? ?? 0F 28 EB 0F 5E D9 0F 5B D2 0F 28 CB 0F 59 DB 0F 28 35 ?? ?? ?? ?? 0F 28 FB 0F 59 DB 0F 59 F2 0F 59 C3 3D FF FF 00 00 0F 59 E3 0F 58 05 ?? ?? ?? ?? 0F 59 C7 0F 58 C4 0F 59 15 ?? ?? ?? ?? 0F 28 DD 0F 5C E8 0F 59 E9 0F 58 F3 0F 5C EE 0F 5C D5 0F 59 15 ?? ?? ?? ?? 75 07 0F 28 C2 EB 34 8B FF D9 EC D9 04 24 D9 F1 D9 1C 24 D9 EC D9 44 24 04 D9 F1 D9 5C 24 04 D9 EC D9 44 24 08 D9 F1 D9 5C 24 08 D9 EC D9 44 24 0C D9 F1 D9 5C 24 0C 0F 10 04 24 8B 64 24 24 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "___avx_atan24"
		size = 624
		refs = "0010 ___common_datan2_data 025b ___common_datan2_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 C5 FD 10 35 ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C5 FD 11 04 24 C5 FD 11 4C 24 20 C5 F5 54 DE C5 FD 54 EE C5 FD 54 E7 C5 FD 11 64 24 60 C5 D5 C2 E3 15 C5 F5 54 F7 C5 FD 11 74 24 40 C5 F5 C2 0D ?? ?? ?? ?? 12 C5 E5 56 F7 C5 DD 54 15 ?? ?? ?? ?? C5 FD 11 94 24 80 00 00 00 C4 E3 55 4B FE 40 C4 E3 65 4B D5 40 C5 C5 5E F2 C5 F8 10 3D ?? ?? ?? ?? C4 E3 7D 19 D8 01 C4 E3 7D 19 EC 01 C5 E0 C6 D8 DD C5 D0 C6 EC DD C5 E1 FA D7 C5 F8 10 25 ?? ?? ?? ?? C5 D1 FA EF C5 E9 66 C4 C5 E9 76 DC C5 D1 66 FC C5 D1 76 EC C5 F9 EB D3 C5 C1 EB E5 C5 E9 EB C4 C5 CD 59 E6 C5 F8 50 D0 C5 F5 54 2D ?? ?? ?? ?? C5 FD 11 AC 24 A0 00 00 00 C5 DD 59 EC C5 D5 59 DD C5 E5 59 3D ?? ?? ?? ?? C5 E5 59 0D ?? ?? ?? ?? C5 E5 59 15 ?? ?? ?? ?? C5 C5 58 05 ?? ?? ?? ?? C5 F5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 FD 59 C3 C5 E5 59 0D ?? ?? ?? ?? C5 ED 59 D3 C5 C5 59 FB C5 FD 58 05 ?? ?? ?? ?? C5 F5 58 0D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 FD 59 C3 C5 F5 59 CB C5 ED 59 D3 C5 C5 59 FB C5 FD 58 05 ?? ?? ?? ?? C5 F5 58 0D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 FD 59 C3 C5 F5 59 CB C5 ED 59 D3 C5 C5 59 FB C5 FD 58 05 ?? ?? ?? ?? C5 F5 58 0D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 FD 59 C4 C5 F5 59 DB C5 C5 59 E4 C5 FD 58 CA C5 E5 58 1D ?? ?? ?? ?? C5 F5 59 ED C5 DD 58 C3 C5 D5 58 D0 C5 ED 59 F6 C5 CD 58 84 24 80 00 00 00 C5 FD 56 4C 24 40 C5 F5 58 94 24 A0 00 00 00 C5 ED 56 44 24 60 C5 FD 10 54 24 20 85 D2 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 94 24 80 00 00 00 C5 FD 11 84 24 C0 00 00 00 C5 FD 11 4C 24 40 74 DD 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 C0 00 00 00 EB B3 C5 F8 77 8D 8C F4 C0 00 00 00 8D 54 F4 40 8D 84 F4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "___libm_sse2_cosf"
		size = 320
		refs = "0004 _static_const_table"
	strings:
		$1 = { F2 0F 10 15 ?? ?? ?? ?? 81 E6 FF FF FF 7F 25 00 00 80 7F 3D 00 00 80 7F 0F 84 0E 01 00 00 C1 EE 17 81 EE 8E 00 00 00 81 E6 F8 FF 00 00 F2 0F 10 1C 75 ?? ?? ?? ?? F2 0F 10 2C 75 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 E4 B8 38 43 00 00 66 0F C4 E0 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD F2 0F 10 C2 F2 0F 58 D3 F2 0F 10 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 D8 66 0F 7E D6 F2 0F 5C D4 F2 0F 58 CB B8 80 01 00 00 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C EA 03 F6 8B D6 C1 E6 18 C1 FE 1F 23 C2 03 D6 33 D6 F2 0F 58 CD 81 E2 FE 00 00 00 F2 0F 10 1C D5 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 66 0F 70 D1 44 F2 0F 59 C9 F2 0F 10 2C D5 ?? ?? ?? ?? 8B F0 81 E6 00 01 00 00 C1 E6 17 F2 0F 59 DA 66 0F 6E D6 F2 0F 5C C1 05 80 00 00 00 25 00 01 00 00 C1 E0 17 F2 0F 5C E1 66 0F 73 F2 20 66 0F 6E C8 66 0F 57 E2 F2 0F 59 C5 F2 0F 59 DC 66 0F 73 F1 20 66 0F 57 C1 F2 0F 58 C3 66 0F 5A C0 EB 04 F3 0F 5C C0 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_64_1_0 {
	meta:
		name = "___sse2_cosf4"
		size = 1328
		refs = "0015 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 20 01 00 00 83 E4 F0 89 84 24 E4 00 00 00 0F 28 3D ?? ?? ?? ?? 0F 54 F8 0F 28 05 ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 0F 28 F7 0F 28 D7 0F 28 2D ?? ?? ?? ?? 0F 58 C7 0F 59 C4 66 0F 5B C0 0F 28 25 ?? ?? ?? ?? 0F C2 FD 06 0F 28 2D ?? ?? ?? ?? 0F 50 C7 23 C0 75 5B 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 E9 4A 04 00 00 0F 28 CE 0F 29 74 24 50 66 0F 66 35 ?? ?? ?? ?? 0F 29 BC 24 90 00 00 00 0F 57 3D ?? ?? ?? ?? 0F 50 D6 89 04 24 85 D2 0F 85 A7 02 00 00 0F 28 F2 0F 28 DD 0F 28 2D ?? ?? ?? ?? 0F 29 BC 24 80 00 00 00 0F 28 F8 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 D4 0F 28 25 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F7 1F 0F 59 D0 0F 59 D8 0F 59 E0 0F 59 E8 66 0F 70 44 24 50 EE 0F 5A 4C 24 50 0F 5A C0 0F 5C F2 0F 5C F3 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D9 0F 5C F4 66 0F E6 DB 66 0F 70 DB DC 0F 5C F5 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 44 24 20 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 0F 54 B4 24 80 00 00 00 0F 29 B4 24 A0 00 00 00 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 0F 54 BC 24 80 00 00 00 0F 29 BC 24 B0 00 00 00 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 28 74 24 20 66 0F 59 35 ?? ?? ?? ?? 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F E6 F6 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 58 C1 66 0F 28 4C 24 20 66 0F EF 2D ?? ?? ?? ?? 66 0F 70 ED DD 66 0F 70 F6 DC 66 0F EB 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D6 66 0F 29 44 24 30 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 6C 24 10 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 D9 66 0F 5C C4 66 0F 5C CD 66 0F 73 F6 3E 66 0F 5C D9 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C DD 66 0F 58 C3 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 0F 28 A4 24 90 00 00 00 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 5A 54 24 30 66 0F DB EE 0F 28 B4 24 A0 00 00 00 66 0F 28 5C 24 10 66 0F 58 C8 66 0F EF 2D ?? ?? ?? ?? 66 0F 5A C9 66 0F 70 ED DD 66 0F 14 D1 0F 28 8C 24 B0 00 00 00 66 0F 14 DD 0F 54 D4 0F 54 DC 0F 56 D6 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 56 D9 0F 28 CA 0F 59 D2 E9 76 01 00 00 0F 5A C9 66 0F 29 8C 24 C0 00 00 00 83 F8 0F 0F 84 98 00 00 00 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 5C D7 0F 28 CA 0F 59 D2 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 E2 0F 59 D2 0F 57 CB 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 C2 0F 59 EA 0F 59 D1 0F 59 E1 0F 58 05 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 C2 0F 59 EC 0F 58 C5 0F 58 C1 0F 29 44 24 70 89 74 24 04 0F 5A 74 24 58 66 0F 29 74 24 20 89 04 24 A9 01 00 00 00 74 22 F3 0F 10 44 24 50 8B 74 24 50 8B 44 24 50 F2 0F 10 8C 24 C0 00 00 00 E8 55 FA FF FF F3 0F 11 44 24 70 8B 04 24 A9 02 00 00 00 74 22 F3 0F 10 44 24 54 8B 74 24 54 8B 44 24 54 F2 0F 10 8C 24 C8 00 00 00 E8 29 FA FF FF F3 0F 11 44 24 74 8B 04 24 A9 04 00 00 00 74 1F F3 0F 10 44 24 58 8B 74 24 58 8B 44 24 58 F2 0F 10 4C 24 20 E8 00 FA FF FF F3 0F 11 44 24 78 8B 04 24 0F 28 44 24 70 A9 08 00 00 00 74 1F F3 0F 10 44 24 5C 8B 74 24 5C 8B 44 24 5C F2 0F 10 4C 24 28 E8 D2 F9 FF FF F3 0F 11 44 24 7C 8B 74 24 04 0F 28 44 24 70 EB 23 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 8B A4 24 E4 00 00 00 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "?dllmain_crt_dispatch@@YGHQAUHINSTANCE__@@KQAX@Z"
		size = 83
		refs = "0020 ___scrt_dllmain_crt_thread_detach 0027 ___scrt_dllmain_crt_thread_attach 0037 ?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z 004a ?dllmain_crt_process_detach@@YAH_N@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 E8 00 74 33 83 E8 01 74 20 83 E8 01 74 11 83 E8 01 74 05 33 C0 40 EB 30 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 0F B6 C0 EB 1F FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 EB 10 83 7D 10 00 0F 95 C0 0F B6 C0 50 E8 ?? ?? ?? ?? 59 5D C2 0C 00 }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z"
		size = 274
		refs = "0003 __sehtable$?dllmain_crt_process_attach@@YAHQAUHINSTANCE__@@QAX@Z 0008 __SEH_prolog4 000f ___scrt_initialize_crt 0020 ___scrt_acquire_startup_lock 0032 ___scrt_current_native_startup_state 003c ___scrt_fastfail 004b ___scrt_dllmain_before_initialize_c 0054 __RTC_Initialize 0059 __RTC_Terminate 005e _atexit 0063 ?__scrt_initialize_type_info@@YAXXZ 006a ?__scrt_uninitialize_type_info@@YAXXZ 0074 ___scrt_initialize_default_local_stdio_options 007b ___xi_z 0080 ___xi_a 0085 __initterm_e 0090 ___scrt_dllmain_after_initialize_c 0099 ___xc_z 009e ___xc_a 00a3 __initterm 00cd ___scrt_get_dyn_tls_init_callback 00da ___scrt_is_nonwritable_in_current_image 00f0 @_guard_check_icall@4 00f8 ?__proc_attached@@3HA 0100 __SEH_epilog4 010c ___scrt_release_startup_lock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 59 84 C0 75 07 33 C0 E9 E0 00 00 00 E8 ?? ?? ?? ?? 88 45 E3 B3 01 88 5D E7 83 65 FC 00 83 3D ?? ?? ?? ?? 00 74 07 6A 07 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 65 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 75 29 E8 ?? ?? ?? ?? 84 C0 74 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 C7 05 ?? ?? ?? ?? 02 00 00 00 32 DB 88 5D E7 C7 45 FC FE FF FF FF E8 44 00 00 00 84 DB 0F 85 4C FF FF FF E8 ?? ?? ?? ?? 8B F0 83 3E 00 74 1E 56 E8 ?? ?? ?? ?? 59 84 C0 74 13 FF 75 0C 6A 02 FF 75 08 8B 36 8B CE E8 ?? ?? ?? ?? FF D6 FF 05 ?? ?? ?? ?? 33 C0 40 E8 ?? ?? ?? ?? C3 8A 5D E7 FF 75 E3 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_65_2_0 {
	meta:
		name = "?dllmain_crt_process_detach@@YAH_N@Z"
		size = 125
		refs = "0003 __sehtable$?dllmain_crt_process_detach@@YAH_N@Z 0008 __SEH_prolog4 000d ?__proc_attached@@3HA 0020 ___scrt_acquire_startup_lock 002d ___scrt_current_native_startup_state 0037 ___scrt_fastfail 003c ___scrt_dllmain_uninitialize_c 0059 ___scrt_uninitialize_crt 0069 __SEH_epilog4 006f ___scrt_dllmain_uninitialize_critical 0077 ___scrt_release_startup_lock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 7F 04 33 C0 EB 4F 48 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 88 45 E4 83 65 FC 00 83 3D ?? ?? ?? ?? 02 74 07 6A 07 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 C7 45 FC FE FF FF FF E8 1B 00 00 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 33 C9 84 C0 0F 95 C1 8B C1 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? FF 75 E4 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_65_3_0 {
	meta:
		name = "?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
		size = 252
		refs = "0003 __sehtable$?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z 0008 __SEH_prolog4 0015 ?__proc_attached@@3HA 003e ?dllmain_raw@@YGHQAUHINSTANCE__@@KQAX@Z 0055 ?dllmain_crt_dispatch@@YGHQAUHINSTANCE__@@KQAX@Z 006c _DllMain@12 00dd ___scrt_dllmain_exception_filter 00f7 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 0C 85 FF 75 0F 39 3D ?? ?? ?? ?? 7F 07 33 C0 E9 D4 00 00 00 83 65 FC 00 83 FF 01 74 0A 83 FF 02 74 05 8B 5D 10 EB 31 8B 5D 10 53 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 89 75 E4 85 F6 0F 84 9E 00 00 00 53 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 89 75 E4 85 F6 0F 84 87 00 00 00 53 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 89 75 E4 83 FF 01 75 22 85 F6 75 1E 53 50 FF 75 08 E8 ?? ?? ?? ?? 53 56 FF 75 08 E8 ?? ?? ?? ?? 53 56 FF 75 08 E8 ?? ?? ?? ?? 85 FF 74 05 83 FF 03 75 48 53 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 89 75 E4 85 F6 74 35 53 57 FF 75 08 E8 ?? ?? ?? ?? 8B F0 EB 24 8B 4D EC 8B 01 51 FF 30 68 ?? ?? ?? ?? FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 C3 8B 65 E8 33 F6 89 75 E4 C7 45 FC FE FF FF FF 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "?dllmain_raw@@YGHQAUHINSTANCE__@@KQAX@Z"
		size = 42
		refs = "0006 __pRawDllMain 001f @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 56 8B 35 ?? ?? ?? ?? 85 F6 75 05 33 C0 40 EB 12 FF 75 10 8B CE FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF D6 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_65_6_0 {
	meta:
		name = "__DllMainCRTStartup@12"
		size = 35
		refs = "000a ___security_init_cookie 0018 ?dllmain_dispatch@@YAHQAUHINSTANCE__@@KQAX@Z"
	strings:
		$1 = { 55 8B EC 83 7D 0C 01 75 05 E8 ?? ?? ?? ?? FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C2 0C 00 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "___sse2_powf4"
		size = 960
		refs = "0032 ___common_spow_data 009f _2il0floatpacket_128 03a8 ___common_spow_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 0F 28 F1 0F 12 F1 0F 28 D0 0F 5A D9 0F 5A EE 0F 5A F8 0F 12 D0 0F 5A E2 0F 29 5C 24 20 0F 29 6C 24 30 66 0F 6F 1D ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 66 0F DB D9 0F 29 4C 24 10 0F 28 CD 0F 28 15 ?? ?? ?? ?? 0F 54 CF 0F 54 EC 0F 56 CA 0F 29 04 24 0F 56 EA 66 0F FA 05 ?? ?? ?? ?? 66 0F 73 D7 14 66 0F 7F 44 24 40 66 0F 73 D4 14 66 0F 7F 5C 24 50 66 0F 5A D9 66 0F 5A C5 0F 16 DB 0F 16 C0 0F 53 F3 0F 53 D0 0F 5A DE 0F 5A D2 0F C6 FC DD 0F 28 25 ?? ?? ?? ?? 66 0F 58 DC 66 0F 58 D4 F3 0F E6 F7 66 0F 5C DC 66 0F 5C D4 66 0F 59 CB 66 0F 59 EA 66 0F 70 E7 EE 0F 28 C2 0F 28 3D ?? ?? ?? ?? 66 0F 73 D0 28 66 0F 5C CF 66 0F 5C EF F3 0F E6 E4 66 0F 7E C1 0F 28 FB 66 0F 73 D7 28 66 0F 7E F8 66 0F 70 C0 02 0F 29 6C 24 60 66 0F 70 FF 02 F2 0F 10 A8 ?? ?? ?? ?? 66 0F 7E C0 66 0F 7E FA F2 0F 10 B9 ?? ?? ?? ?? 66 0F 16 B8 ?? ?? ?? ?? 0F 29 7C 24 70 0F 28 3D ?? ?? ?? ?? 0F 28 C7 66 0F C2 C3 01 66 0F C2 FA 01 0F 28 1D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 54 C3 0F 54 FB 0F 56 C2 0F 56 FA 66 0F 5C F0 66 0F 5C E7 0F 28 1D ?? ?? ?? ?? 0F 28 05 ?? ?? ?? ?? 66 0F 59 F3 66 0F 59 E3 0F 28 7C 24 60 0F 28 D8 66 0F 59 D9 66 0F 59 C7 0F 29 A4 24 80 00 00 00 0F 28 E1 0F 28 15 ?? ?? ?? ?? 66 0F 59 E1 66 0F 58 DA 66 0F 58 C2 66 0F 59 DC 0F 28 D7 66 0F 59 D7 66 0F 58 CB 66 0F 59 C2 66 0F 58 F8 66 0F 16 AA ?? ?? ?? ?? 66 0F 58 CD 66 0F 58 7C 24 70 66 0F 58 CE 66 0F 58 BC 24 80 00 00 00 66 0F 59 4C 24 20 66 0F 59 7C 24 30 0F 28 25 ?? ?? ?? ?? 0F 28 DC 66 0F 59 D9 66 0F 59 E7 0F 28 35 ?? ?? ?? ?? 0F 28 D3 66 0F 5C D6 0F 29 A4 24 90 00 00 00 66 0F 5C E6 0F 28 35 ?? ?? ?? ?? 66 0F 58 D6 66 0F 58 E6 0F 28 EA 0F 28 C4 66 0F 5C EE 66 0F 5C C6 66 0F 6F 74 24 40 0F 29 AC 24 A0 00 00 00 66 0F 6F EE 0F C6 CF DD 66 0F 6F 3D ?? ?? ?? ?? 0F 29 84 24 B0 00 00 00 66 0F 66 EF 66 0F 6F 44 24 50 66 0F 76 F7 66 0F 6F 3D ?? ?? ?? ?? 66 0F EB EE 66 0F 6F F0 66 0F 76 C7 66 0F 66 F7 66 0F EB F0 0F 28 C2 66 0F EB EE 66 0F 73 D2 0B 0F 28 B4 24 90 00 00 00 66 0F 73 F2 34 66 0F 5C 9C 24 A0 00 00 00 66 0F 5C B4 24 B0 00 00 00 0F 28 3D ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 0F 54 C7 66 0F 66 0D ?? ?? ?? ?? 0F 54 FC 66 0F 7E C2 66 0F EB E9 0F 28 0D ?? ?? ?? ?? 66 0F 73 D4 0B 66 0F 73 F4 34 66 0F C5 C8 04 66 0F 59 D9 66 0F 59 F1 0F 50 C5 F3 0F 7E 2C D5 ?? ?? ?? ?? 66 0F 16 2C CD ?? ?? ?? ?? 66 0F 7E FA 85 C0 66 0F C5 CF 04 66 0F 59 DD F3 0F 7E 04 D5 ?? ?? ?? ?? 66 0F 16 04 CD ?? ?? ?? ?? 66 0F 59 F0 66 0F 58 DD 66 0F 58 F0 66 0F D4 DA 66 0F D4 F4 66 0F 5A C3 66 0F 5A CE 0F 16 C1 75 04 8B E5 5D C3 0F 28 0C 24 0F 28 54 24 10 0F 29 4C 24 40 0F 29 94 24 80 00 00 00 0F 29 84 24 C0 00 00 00 74 DC 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 C0 00 00 00 EB AB 8D 8C B4 C0 00 00 00 8D 54 B4 40 8D 84 B4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB CA 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "___sse2_asinf4"
		size = 336
		refs = "000f ___common_sasin_data 013c ___common_sasin_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 2D ?? ?? ?? ?? 0F 28 F5 0F 55 E8 0F 54 F0 0F 28 1D ?? ?? ?? ?? 0F 28 FE 0F 59 FB 0F 28 E6 0F 59 E6 0F 28 15 ?? ?? ?? ?? 0F C2 D6 02 0F 29 04 24 0F 28 C3 0F 50 D2 0F 28 D6 0F C2 D3 05 0F 5C C7 0F 52 D8 0F 5D E0 0F 58 C0 0F 28 CB 0F 28 FC 0F 59 CB 85 D2 0F 59 D8 0F 59 FC 0F 59 C1 0F 28 0D ?? ?? ?? ?? 0F 5C 05 ?? ?? ?? ?? 0F 59 C8 0F 59 C3 0F 58 0D ?? ?? ?? ?? 0F 59 C8 0F 28 05 ?? ?? ?? ?? 0F 5C CB 0F 59 C4 0F 28 1D ?? ?? ?? ?? 0F 54 CA 0F 59 DC 0F 58 05 ?? ?? ?? ?? 0F 59 C7 0F 58 1D ?? ?? ?? ?? 0F 58 C3 0F 59 C4 0F 58 05 ?? ?? ?? ?? 0F 59 C4 0F 28 E2 0F 55 E6 0F 56 E1 0F 59 C4 0F 28 35 ?? ?? ?? ?? 0F 58 C4 0F 54 F2 0F 58 C6 66 0F EF C5 75 04 8B E5 5D C3 0F 28 0C 24 0F 29 4C 24 40 0F 29 84 24 80 00 00 00 74 E9 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 80 00 00 00 EB B8 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "___avx_cosf8"
		size = 3200
		refs = "0013 ___common_scos_data 0130 ___common_scos_cout_rare 01df ___common_scos_reduction_data"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC F4 02 00 00 C5 FC 54 15 ?? ?? ?? ?? C5 E1 EF DB C5 EC C2 25 ?? ?? ?? ?? 1E C4 E3 7D 19 E5 01 C5 D9 6B F5 C5 C9 63 FB C5 F9 D7 C7 84 C0 0F 85 FB 00 00 00 C5 FC 58 3D ?? ?? ?? ?? 33 DB C5 FC 10 35 ?? ?? ?? ?? C5 C4 59 15 ?? ?? ?? ?? C5 EC 58 D6 C5 E1 72 F2 1F C4 E3 7D 19 D5 01 C5 EC 5C D6 C5 D1 72 F5 1F C5 EC 5C 25 ?? ?? ?? ?? C5 DC 59 15 ?? ?? ?? ?? C5 FC 5C D2 C4 E3 65 18 ED 01 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 DC 59 1D ?? ?? ?? ?? C5 EC 5C D3 C5 EC 59 DA C5 E4 59 25 ?? ?? ?? ?? C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 E3 C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 E3 C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 DB C5 EC 57 D5 C5 E4 59 DA C5 E4 58 D2 84 DB 75 11 C5 FC 28 C2 81 C4 F4 02 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 11 04 24 C5 FC 11 54 24 40 85 DB 74 E0 33 F6 0F A3 F3 72 0E 46 83 FE 20 7C F5 C5 FC 10 54 24 40 EB CB C5 F8 77 8D 44 B4 40 8D 14 B4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FC 10 25 ?? ?? ?? ?? BA 00 00 80 7F C5 FC 11 44 24 40 C5 F9 6E FA C5 DC 54 EA C5 D4 C2 D4 00 C4 E3 7D 19 C4 01 C5 F8 11 A4 24 90 00 00 00 C4 E3 7D 19 D5 01 C5 E9 6B F5 C5 C9 63 DB C5 F9 70 D7 00 C5 F9 D7 C3 89 84 24 A0 02 00 00 C5 F8 28 C8 C5 E9 DB D9 C5 D1 72 D3 17 C5 E9 DB DC C5 E9 72 D3 17 C5 E1 72 F5 01 C5 E1 FE DD C5 D1 72 F3 02 C5 E1 72 F2 01 C5 F9 7E EA C5 E1 FE DA C5 E1 72 F3 02 C5 F8 11 8C 24 80 00 00 00 C4 E3 79 16 E9 01 C4 E3 79 16 E8 02 C4 E3 79 16 EF 03 C5 F9 7E DE C5 F9 6E 91 ?? ?? ?? ?? C4 E3 79 16 9C 24 AC 02 00 00 01 C4 E3 79 16 9C 24 B0 02 00 00 02 C4 E3 79 16 DB 03 C5 F9 6E 9A ?? ?? ?? ?? C5 E1 6C EA C5 F9 6E 98 ?? ?? ?? ?? C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C DA 89 B4 24 A8 02 00 00 C5 D0 C6 F3 88 C5 F9 6E 9E ?? ?? ?? ?? 8B B4 24 AC 02 00 00 89 BC 24 A4 02 00 00 C5 F9 6E 83 ?? ?? ?? ?? C5 F9 6E 96 ?? ?? ?? ?? 8B B4 24 B0 02 00 00 C5 E1 6C EA C5 F9 6E 93 ?? ?? ?? ?? C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C DA C5 D0 C6 EB 88 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? C5 E1 6C FA C5 F9 6E 97 ?? ?? ?? ?? 8B BC 24 A8 02 00 00 C5 F9 6E 98 ?? ?? ?? ?? C5 E1 6C DA C5 C0 C6 FB 88 C5 F9 6E 9F ?? ?? ?? ?? 8B BC 24 AC 02 00 00 C5 F8 11 B4 24 A0 00 00 00 C5 F8 11 AC 24 B0 00 00 00 C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C D2 C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C D8 C5 E8 C6 D3 88 C5 F8 11 94 24 C0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? B9 FF FF 7F 00 C5 E1 6C DA C5 F9 6E 90 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 8B 94 24 A8 02 00 00 C5 F9 6E 80 ?? ?? ?? ?? B8 FF FF 00 00 C5 E9 6C D0 C5 E0 C6 DA 88 C5 F8 11 9C 24 D0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? BA 00 00 00 80 C5 F9 6E 97 ?? ?? ?? ?? BF 00 00 80 28 C5 F9 6E 83 ?? ?? ?? ?? BB 00 00 80 00 C5 E1 6C DA C5 F9 6E 96 ?? ?? ?? ?? BE FF 00 00 00 C5 E9 6C D0 C5 E0 C6 C2 88 C5 F9 6E D9 C5 F9 70 D3 00 C5 F9 6E DB C5 F9 70 DB 00 C5 E9 DB E4 C5 E9 DB C9 C5 D9 FE D3 C5 F9 6E E0 C5 F1 FE CB C5 F9 70 DC 00 B9 00 00 80 3F C5 C9 DB E3 C5 D1 DB F3 C5 D1 72 D7 10 C5 C1 DB FB C5 FA 7F AC 24 10 01 00 00 BB 00 00 40 47 C5 F8 10 AC 24 C0 00 00 00 B8 FF FF 03 00 C5 FA 7F B4 24 00 01 00 00 C5 C9 72 D5 10 C5 D1 DB EB C5 FA 7F AC 24 40 01 00 00 C5 F8 10 AC 24 D0 00 00 00 C5 F8 11 84 24 E0 00 00 00 C5 F9 72 D0 10 C5 FA 7F 84 24 60 01 00 00 C5 F9 72 D1 10 C5 F1 DB CB C5 D1 72 D5 10 C5 FA 7F AC 24 50 01 00 00 C5 D1 72 D2 10 C5 E9 DB D3 C5 FA 7F A4 24 F0 00 00 00 C4 E2 71 40 E4 C5 FA 7F A4 24 A0 01 00 00 C4 E2 69 40 A4 24 00 01 00 00 C5 FA 7F B4 24 20 01 00 00 C5 FA 7F BC 24 30 01 00 00 C5 FA 7F A4 24 B0 01 00 00 C4 E2 69 40 F6 C4 E2 71 40 A4 24 10 01 00 00 C5 FA 7F B4 24 D0 01 00 00 C4 E2 71 40 F7 C5 E1 DB BC 24 D0 00 00 00 C5 FA 7F A4 24 C0 01 00 00 C4 E2 79 40 E7 C5 FA 6F BC 24 50 01 00 00 C5 D9 72 D4 10 C5 FA 7F 8C 24 80 01 00 00 C4 E2 71 40 CF C5 FA 7F 84 24 70 01 00 00 C4 E2 79 40 C7 C5 C1 72 D1 10 C5 FA 7F B4 24 E0 01 00 00 C5 C9 DB F3 C5 F9 FE C7 C5 C9 FE F0 C5 D9 FE FE C5 E1 DB A4 24 E0 00 00 00 C5 FA 7F 94 24 90 01 00 00 C4 E2 69 40 94 24 40 01 00 00 C4 E2 51 40 CC C5 E9 DB C3 C5 FA 7F 94 24 F0 01 00 00 C5 C9 72 D1 10 C5 FA 6F 8C 24 60 01 00 00 C5 FA 6F 94 24 90 01 00 00 C4 E2 69 40 D1 C4 E2 51 40 E1 C5 E9 72 D2 10 C5 D9 FE E2 C5 F9 FE C4 C5 FA 7F BC 24 00 02 00 00 C5 C9 FE C8 C5 FA 6F A4 24 70 01 00 00 C5 C9 72 D7 10 C5 FA 6F BC 24 E0 01 00 00 C4 E2 59 40 84 24 30 01 00 00 C5 C1 72 D7 10 C5 E1 DB 94 24 C0 01 00 00 C5 F9 FE C7 C5 FA 7F 8C 24 10 02 00 00 C5 E9 FE D0 C5 C1 72 D1 10 C5 C9 FE C2 C5 FA 6F 8C 24 F0 01 00 00 C4 E2 51 40 B4 24 40 01 00 00 C5 F1 72 D1 10 C5 E1 DB 94 24 D0 01 00 00 C5 C9 FE F1 C5 E9 FE D6 C5 C1 FE F2 C5 FA 6F 94 24 C0 01 00 00 C4 E2 59 40 BC 24 10 01 00 00 C5 E9 72 D2 10 C5 E1 DB 8C 24 A0 01 00 00 C5 C1 FE FA C5 FA 7F 84 24 20 02 00 00 C5 F9 72 D0 10 C5 F1 FE D7 C5 FA 7F B4 24 30 02 00 00 C5 F9 FE FA C5 E9 72 D6 10 C5 FA 6F B4 24 D0 01 00 00 C4 E2 51 40 8C 24 20 01 00 00 C5 C9 72 D6 10 C5 E1 DB 84 24 B0 01 00 00 C5 F1 FE CE C5 F9 FE C1 C5 C9 72 D7 10 C5 E9 FE C8 C5 C1 DB FB C5 F8 10 84 24 A0 00 00 00 C5 FA 6F 94 24 80 01 00 00 C5 F9 72 D0 10 C4 E2 69 40 D0 C4 E2 59 40 84 24 F0 00 00 00 C5 E9 DB D3 C5 FA 6F A4 24 A0 01 00 00 C5 D9 72 D4 10 C5 F9 FE C4 C5 E9 FE D0 C5 C9 FE F2 C5 E9 72 D1 10 C5 F8 10 A4 24 B0 00 00 00 C5 F9 72 F6 10 C5 FA 6F B4 24 90 01 00 00 C5 F9 FE C7 C5 C1 72 D4 10 C5 F1 DB CB C4 E2 49 40 E7 C4 E2 51 40 B4 24 00 01 00 00 C5 D9 DB E3 C5 FA 6F AC 24 B0 01 00 00 C5 D1 72 D5 10 C5 C9 FE FD C5 D9 FE E7 C5 E9 FE D4 C5 D9 72 F2 10 C5 FA 6F BC 24 30 02 00 00 C5 D9 FE E9 C5 FA 6F A4 24 20 02 00 00 C5 E1 DB B4 24 00 02 00 00 C5 E9 72 F4 10 C5 E1 DB 9C 24 10 02 00 00 C5 D9 72 F7 10 C5 D9 FE E3 C5 F9 6E DA C5 E9 FE CE C5 F9 6E F1 C5 F9 70 D3 00 BA 00 00 00 34 C5 E9 DB 9C 24 80 00 00 00 B9 FF 01 00 00 C5 F9 70 F6 00 C5 E9 DB 94 24 90 00 00 00 C5 E1 EF FE C5 FA 7F 84 24 40 02 00 00 C5 F9 72 D0 09 C5 FA 7F AC 24 50 02 00 00 C5 D1 72 D5 09 C5 E9 EF F6 C5 F9 EB C7 C5 D1 EB EE C4 E3 7D 18 ED 01 C5 F9 6E C3 C5 F9 70 F0 00 BB DB 0F C9 40 C4 E3 4D 18 FE 01 C5 C4 58 C5 C5 FC 5C F7 C5 F9 6E FE C5 D4 5C EE BE 00 10 C9 40 C5 FC 11 6C 24 60 C5 F9 6E EF C5 F9 70 F5 00 C5 E9 EF EE BF 7A 77 95 B7 C5 F8 11 84 24 60 02 00 00 C4 E3 7D 19 84 24 70 02 00 00 01 C5 F9 70 C7 00 C5 F9 6E F8 C5 F9 70 FF 00 B8 00 F0 FF FF C5 FA 7F 84 24 80 02 00 00 C5 E1 EF C6 C5 C1 DB F1 C5 C1 DB FC C5 C9 72 F6 05 C5 C1 72 F7 05 C5 C9 EB F0 C5 C1 EB FD C5 F1 72 D1 12 C5 D9 72 D4 12 C4 E3 4D 18 FF 01 C4 E3 7D 18 ED 01 C5 F9 6E C2 C5 C4 5C FD BA FF FF FF 7F C5 F9 70 E8 00 C5 E1 EF C5 C5 F9 6E D9 C5 F9 70 DB 00 C5 E9 EF D5 C5 E1 DB B4 24 40 02 00 00 B9 00 00 80 35 C5 E1 DB 9C 24 50 02 00 00 C5 D1 72 F6 0E C5 E1 72 F3 0E C5 D1 EB E9 C5 E1 EB E4 C5 D1 EB C8 C5 D9 EB DA C4 E3 75 18 EB 01 C5 FC 10 4C 24 60 C4 E3 7D 18 D2 01 C5 D4 5C C2 C5 F9 6E EF C5 F4 58 F0 C5 F4 5C E6 C5 FC 58 DC C5 F9 6E E6 C5 E4 58 D7 C5 F9 6E FB C5 F9 70 DC 00 C5 F9 6E E0 C5 F9 70 C7 00 C5 F9 70 FD 00 C5 F9 70 EC 00 C4 E3 55 18 E5 01 C5 CC 54 E4 C5 CC 5C F4 C4 E3 7D 18 C8 01 C4 E3 65 18 C3 01 C4 E3 45 18 DF 01 C5 FC 59 FC C5 FC 59 EE C5 E4 59 C4 C5 F4 59 D2 C5 F9 6E C9 C5 E4 59 F6 C5 D4 58 C0 C5 F9 6E EA C5 EC 58 E6 C5 F9 70 F5 00 C5 FC 58 D4 C5 FC 10 44 24 40 C5 C4 58 E2 C5 C4 5C DC C5 F9 70 F9 00 C5 E4 58 D2 C4 E3 4D 18 DE 01 C5 FC 54 EB C4 E3 45 18 F7 01 C5 D4 C2 DE 1E C5 D4 C2 EE 12 C5 D4 54 E8 C5 E4 54 E4 C5 E4 54 D2 C5 D4 56 E4 C5 FA 6F AC 24 80 02 00 00 C5 FC 11 14 24 C5 D1 DB 94 24 60 02 00 00 C5 C9 72 F2 04 C5 D1 DB 94 24 70 02 00 00 C5 E9 72 F2 04 C5 F9 7E F6 C5 F9 7E D2 C5 DC 59 DC C4 E3 79 16 F3 01 C4 E3 79 16 F7 02 C4 E3 79 16 F1 03 C4 E3 79 16 94 24 BC 02 00 00 01 C4 E3 79 16 94 24 C0 02 00 00 02 C4 E3 79 16 D0 03 C5 F9 6E 96 ?? ?? ?? ?? C5 F9 6E AB ?? ?? ?? ?? C5 E9 6C F5 C5 F9 6E 97 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? 89 94 24 B8 02 00 00 C5 E9 6C D5 C5 F9 6E AA ?? ?? ?? ?? 8B 94 24 BC 02 00 00 C5 C8 C6 D2 88 89 8C 24 B4 02 00 00 C5 F9 6E B2 ?? ?? ?? ?? 8B 94 24 C0 02 00 00 C5 D1 6C FE C5 F9 6E B0 ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 D1 6C EE C5 C0 C6 ED 88 C5 F9 6E B3 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? 89 9C 24 94 02 00 00 89 B4 24 98 02 00 00 89 BC 24 9C 02 00 00 C4 E3 6D 18 D5 01 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C FE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 B8 02 00 00 C5 F9 6E AF ?? ?? ?? ?? C5 D1 6C EE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 BC 02 00 00 C5 C0 C6 ED 88 C5 F9 6E B9 ?? ?? ?? ?? C5 C9 6C F7 C5 F9 6E BA ?? ?? ?? ?? C5 C1 6C F9 C5 C8 C6 F7 88 C4 E3 55 18 EE 01 C5 F9 6E B3 ?? ?? ?? ?? C5 FC 11 6C 24 20 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C F6 8B 9F ?? ?? ?? ?? 89 9C 24 90 02 00 00 8B 9C 24 A0 02 00 00 8B B4 24 B4 02 00 00 8B BC 24 B8 02 00 00 C5 FC 11 44 24 40 C5 F9 6E AC 24 90 02 00 00 C5 F9 6E 86 ?? ?? ?? ?? C5 D1 6C C8 C5 C8 C6 F9 88 89 9C 24 A0 02 00 00 8B 9C 24 98 02 00 00 C5 F9 6E B7 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? C5 F9 6E 82 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? C5 C9 6C F5 C5 F9 6C E9 C5 C8 C6 C5 88 C5 F9 6E AB ?? ?? ?? ?? 8B 9C 24 94 02 00 00 C5 F9 6E B6 ?? ?? ?? ?? C4 E3 45 18 F8 01 C5 F9 6E 83 ?? ?? ?? ?? 8B 9C 24 9C 02 00 00 C5 FC 11 7C 24 60 C5 D1 6C F8 C5 F9 6E 8B ?? ?? ?? ?? C5 F1 6C EE C5 C0 C6 ED 88 C5 F9 6E 87 ?? ?? ?? ?? C5 F9 6E 89 ?? ?? ?? ?? C5 F9 6E B2 ?? ?? ?? ?? C5 F9 6E B8 ?? ?? ?? ?? C5 F9 6C C1 C5 C9 6C CF C5 F8 C6 F1 88 C5 FC 10 7C 24 20 8B 9C 24 A0 02 00 00 C4 E3 55 18 EE 01 C5 DC 59 C5 C5 EC 59 F4 C5 FC 11 AC 24 80 00 00 00 C5 C4 58 C8 C5 CC 58 E9 C5 C4 5C F9 C5 C4 58 F8 C5 F4 5C C5 C5 FC 58 CE C5 E4 59 35 ?? ?? ?? ?? C5 F4 58 C7 C5 CC 58 0D ?? ?? ?? ?? C5 F4 59 F3 C5 CC 59 CC C5 EC 58 B4 24 80 00 00 00 C5 E4 59 15 ?? ?? ?? ?? C5 EC 58 15 ?? ?? ?? ?? C5 EC 59 DB C5 FC 10 54 24 20 C5 DC 59 E2 C5 E4 59 DA C5 CC 5C E4 C5 DC 59 3C 24 C5 F4 59 CC C5 C4 58 74 24 60 C5 F4 58 C0 C5 E4 58 D6 C5 EC 58 D8 C5 FC 10 44 24 40 C5 D4 58 D3 E9 74 F4 FF FF 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "___sse4_exp2"
		size = 672
		refs = "0004 _static_const_table"
	strings:
		$1 = { 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D8 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 58 D3 66 0F C5 C8 03 66 0F 28 E8 66 0F 3A 09 DB 00 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 0F 8D 95 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 81 F9 86 40 00 00 0F 8D 8E 00 00 00 66 0F 16 24 D5 ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C1 C3 8D A4 24 00 00 00 00 90 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 8D A4 24 00 00 00 00 8D 64 24 00 66 0F 16 24 D5 ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 0F 7E 3C C5 ?? ?? ?? ?? 66 0F 16 3C D5 ?? ?? ?? ?? 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 0F 7E 3C C5 ?? ?? ?? ?? 66 0F 16 3C D5 ?? ?? ?? ?? 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 0F 7E 0C C5 ?? ?? ?? ?? 66 0F 16 0C D5 ?? ?? ?? ?? 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 0F 7E 3C C5 ?? ?? ?? ?? 66 0F 16 3C D5 ?? ?? ?? ?? 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 E9 5A FE FF FF 8D 49 00 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "___sse4_expf4"
		size = 704
		refs = "0003 _static_const_table"
	strings:
		$1 = { 0F 28 1D ?? ?? ?? ?? 0F 59 D8 0F 28 25 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 66 0F 5B D3 0F 28 3D ?? ?? ?? ?? 0F 28 E8 66 0F DB F8 66 0F 3A 08 DB 00 66 0F 7E D0 0F 59 E3 66 0F C5 D2 02 0F 59 1D ?? ?? ?? ?? 83 E0 3F 83 E2 3F 66 0F FE CA 0F 5C C4 66 0F 66 3D ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F C5 C2 04 0F 16 24 D5 ?? ?? ?? ?? 66 0F C5 D2 06 0F 50 CF 0F 5C C3 83 E0 3F 83 E2 3F 23 C9 66 0F 72 D1 06 75 38 F3 0F 7E 14 C5 ?? ?? ?? ?? 0F 16 14 D5 ?? ?? ?? ?? 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 0F C6 E2 88 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C1 C3 8D 49 00 F3 0F 7E 34 C5 ?? ?? ?? ?? 0F 16 34 D5 ?? ?? ?? ?? 0F 28 F8 0F 58 C0 0F 59 FF 0F 58 05 ?? ?? ?? ?? 0F C6 E6 88 66 0F 72 F1 17 0F 58 C7 66 0F EB CC 0F 59 C8 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F FE 15 ?? ?? ?? ?? 66 0F 72 D2 06 66 0F C5 C5 01 66 0F C5 D5 03 C1 E8 0F C1 EA 0F F3 0F 7E 3C C5 ?? ?? ?? ?? 0F 16 3C D5 ?? ?? ?? ?? 66 0F C5 C5 05 66 0F C5 D5 07 C1 E8 0F C1 EA 0F F3 0F 7E 1C C5 ?? ?? ?? ?? 0F 16 1C D5 ?? ?? ?? ?? 0F C6 FB 88 66 0F FE D7 66 0F 72 F2 17 66 0F EB D4 0F 59 C2 66 0F C5 C5 01 66 0F C5 D5 03 C1 E8 0F C1 EA 0F F3 0F 7E 3C C5 ?? ?? ?? ?? 0F 16 3C D5 ?? ?? ?? ?? 66 0F C5 C5 05 66 0F C5 D5 07 C1 E8 0F C1 EA 0F F3 0F 7E 1C C5 ?? ?? ?? ?? 0F 16 1C D5 ?? ?? ?? ?? 0F C6 FB 88 0F 59 C7 66 0F EB C1 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 66 0F C5 C5 01 66 0F C5 D5 03 C1 E8 0F C1 EA 0F F3 0F 7E 0C C5 ?? ?? ?? ?? 0F 16 0C D5 ?? ?? ?? ?? 66 0F C5 C5 05 66 0F C5 D5 07 C1 E8 0F C1 EA 0F F3 0F 7E 1C C5 ?? ?? ?? ?? 0F 16 1C D5 ?? ?? ?? ?? 0F C6 CB 88 66 0F DB CE 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 0F C2 35 ?? ?? ?? ?? 00 66 0F C5 C5 01 66 0F C5 D5 03 C1 E8 0F C1 EA 0F F3 0F 7E 3C C5 ?? ?? ?? ?? 0F 16 3C D5 ?? ?? ?? ?? 66 0F C5 C5 05 66 0F C5 D5 07 C1 E8 0F C1 EA 0F F3 0F 7E 1C C5 ?? ?? ?? ?? 0F 16 1C D5 ?? ?? ?? ?? 0F C6 FB 88 66 0F DB F7 66 0F EB CE 0F 28 35 ?? ?? ?? ?? 0F C2 F5 03 66 0F DB EE 66 0F EB CD 0F 59 C9 66 0F EB C1 E9 FD FD FF FF 90 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "__except_handler4_noexcept"
		size = 53
		refs = "0012 __except_handler4 0030 _terminate"
	strings:
		$1 = { 55 8B EC 56 FF 75 14 8B 75 08 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 F6 46 04 66 75 0D 81 3E 63 73 6D E0 75 05 83 F8 01 74 03 5E 5D C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_43_0_3 {
	meta:
		name = "__except_handler3_noexcept"
		size = 53
		refs = "0012 __except_handler3 0030 _terminate"
	strings:
		$1 = { 55 8B EC 56 FF 75 14 8B 75 08 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 F6 46 04 66 75 0D 81 3E 63 73 6D E0 75 05 83 F8 01 74 03 5E 5D C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "___vdecl_fmodf8"
		size = 157
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 40 C5 FE 7F 04 24 C5 FE 7F 4C 24 20 D9 04 24 D9 44 24 20 E8 ?? ?? ?? ?? D9 1C 24 D9 44 24 04 D9 44 24 24 E8 ?? ?? ?? ?? D9 5C 24 04 D9 44 24 08 D9 44 24 28 E8 ?? ?? ?? ?? D9 5C 24 08 D9 44 24 0C D9 44 24 2C E8 ?? ?? ?? ?? D9 5C 24 0C D9 44 24 10 D9 44 24 30 E8 ?? ?? ?? ?? D9 5C 24 10 D9 44 24 14 D9 44 24 34 E8 ?? ?? ?? ?? D9 5C 24 14 D9 44 24 18 D9 44 24 38 E8 ?? ?? ?? ?? D9 5C 24 18 D9 44 24 1C D9 44 24 3C E8 ?? ?? ?? ?? D9 5C 24 1C C5 FE 6F 04 24 83 C4 40 C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "___sse2_tanhf4"
		size = 240
		refs = "000f _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 34 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 54 F8 0F 58 F7 0F 28 15 ?? ?? ?? ?? 0F 54 D6 0F 29 54 24 10 0F 28 1D ?? ?? ?? ?? 0F C2 DF 02 0F 57 C7 0F 28 15 ?? ?? ?? ?? 0F 28 CF 0F C2 CA 02 0F 54 CB 0F 28 2D ?? ?? ?? ?? 8B 4C 24 10 8B 14 8D ?? ?? ?? ?? 89 14 24 0F 54 E9 8B 4C 24 14 8B 14 8D ?? ?? ?? ?? 89 54 24 04 8B 4C 24 18 8B 14 8D ?? ?? ?? ?? 89 54 24 08 8B 4C 24 1C 8B 14 8D ?? ?? ?? ?? 89 54 24 0C 0F 28 15 ?? ?? ?? ?? 0F 5C F2 0F 5C FE 0F 28 E7 0F 59 E7 0F 28 1D ?? ?? ?? ?? 0F 59 DC 0F 58 1D ?? ?? ?? ?? 0F 56 C5 0F 28 15 ?? ?? ?? ?? 0F 59 E2 0F 58 25 ?? ?? ?? ?? 0F 59 E7 0F 28 14 24 0F 28 F3 0F 59 F2 0F 58 F4 0F 59 E2 0F 58 E3 0F 5E F4 0F 55 CE 0F 56 C1 8B 64 24 34 C3 90 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "___sse2_asin2"
		size = 464
		refs = "001a _static_const_table"
	strings:
		$1 = { 8B C4 81 EC C0 00 00 00 83 E4 F0 89 84 24 84 00 00 00 66 0F 28 C8 66 0F 28 05 ?? ?? ?? ?? 66 0F 54 C1 66 0F 29 44 24 10 66 0F 55 C1 66 0F 28 E0 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 3D ?? ?? ?? ?? 66 0F 29 04 24 66 0F 5C F8 66 0F 59 C0 66 0F 59 3D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 FC 66 0F 55 D0 66 0F 56 D7 66 0F 51 F7 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 D8 66 0F C2 DD 00 66 0F 29 5C 24 20 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 DC 66 0F 29 5C 24 40 66 0F 28 0D ?? ?? ?? ?? 66 0F 54 CC 66 0F 56 CD 66 0F 29 4C 24 50 66 0F 28 05 ?? ?? ?? ?? 66 0F 54 C4 66 0F FE C5 66 0F 29 44 24 60 66 0F 28 CA 66 0F 59 D2 66 0F 28 C2 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 EC 66 0F 55 2C 24 66 0F 54 F4 66 0F 56 F5 66 0F 29 74 24 30 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 C8 66 0F 58 CB 66 0F 59 4C 24 30 66 0F 58 4C 24 30 66 0F 59 4C 24 60 66 0F 59 4C 24 50 66 0F 58 4C 24 40 66 0F 28 54 24 20 66 0F 28 C2 66 0F 54 15 ?? ?? ?? ?? 66 0F 55 C1 66 0F 56 C2 66 0F 56 44 24 10 8B A4 24 84 00 00 00 C3 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "___sse2_floorf4"
		size = 80
		refs = "0006 _2il0floatpacket_4 0010 _2il0floatpacket_5 0037 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 D8 0F 28 0D ?? ?? ?? ?? 0F 28 E0 0F 28 15 ?? ?? ?? ?? 0F 54 D9 0F 55 C8 0F 28 EA 0F C2 E9 01 0F 58 CA 0F 28 F5 0F 54 C5 0F 5C CA 0F 56 CB 0F C2 E1 01 0F 54 25 ?? ?? ?? ?? 0F 5C CC 0F 55 F1 0F 56 C6 C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "___sse2_atan22"
		size = 656
		refs = "0021 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC C0 00 00 00 83 E4 F0 89 84 24 84 00 00 00 66 0F 29 04 24 66 0F 29 4C 24 10 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F 29 54 24 30 66 0F 29 5C 24 40 66 0F 57 C2 66 0F 57 CB 66 0F 28 D0 66 0F C2 D1 05 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC 66 0F 28 E2 66 0F 28 E8 66 0F 28 F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 66 0F 5E CA 66 0F 28 24 24 66 0F 28 2C 24 66 0F 28 74 24 10 66 0F 28 7C 24 10 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F C2 25 ?? ?? ?? ?? 06 66 0F C2 2D ?? ?? ?? ?? 01 66 0F C2 35 ?? ?? ?? ?? 06 66 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 C4 83 F8 03 0F 8C 5A 01 00 00 66 0F 28 64 24 40 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F 29 64 24 50 66 0F 29 5C 24 60 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 60 66 0F 56 74 24 40 66 0F 58 74 24 50 66 0F 56 74 24 30 66 0F 28 C6 EB 21 DD 04 24 DD 44 24 10 D9 F3 DD 5C 24 20 DD 44 24 08 DD 44 24 18 D9 F3 DD 5C 24 28 66 0F 28 44 24 20 8B A4 24 84 00 00 00 C3 8D 64 24 00 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "___common_stan_cout_rare"
		size = 96
	strings:
		$1 = { 56 8B 54 24 08 8B 02 0F B7 4A 02 89 04 24 81 E1 80 7F 00 00 C1 E8 18 83 E0 7F F3 0F 10 0A 81 F9 80 7F 00 00 88 44 24 03 74 04 33 C0 59 C3 8B 44 24 0C 81 3C 24 00 00 80 7F 75 13 66 0F EF C0 F3 0F 59 C8 F3 0F 11 08 B8 01 00 00 00 59 C3 F3 0F 59 C9 F3 0F 11 08 33 C0 59 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "___common_stanh_cout_rare"
		size = 80
		refs = "0023 __imlsTanhHATab"
	strings:
		$1 = { 8B 54 24 04 0F B6 42 03 25 80 00 00 00 C1 E8 07 0F B7 4A 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 8B 04 85 ?? ?? ?? ?? 74 09 8B 54 24 08 89 02 33 C0 C3 F7 02 FF FF 7F 00 74 EF F3 0F 10 02 8B 44 24 08 F3 0F 58 C0 F3 0F 11 00 EB E3 8D 64 24 00 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "___common_sacos_cout_rare"
		size = 2672
		refs = "0040 __vmldACosHATab 09d5 _2il0floatpacket_192"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 5C 8B 4D 08 0F B7 41 02 25 80 7F 00 00 F3 0F 10 11 3D 80 7F 00 00 0F 84 1A 0A 00 00 F3 0F 5A CA F2 0F 11 4C 24 40 80 64 24 47 7F F2 0F 10 64 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 75 09 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F CC 0F 86 42 04 00 00 66 0F 2F 25 ?? ?? ?? ?? 0F 86 D8 03 00 00 F2 0F 10 1D ?? ?? ?? ?? 0F 28 D4 F2 0F 59 D3 F2 0F 11 54 24 38 F2 0F 10 44 24 38 F2 0F 11 64 24 08 F2 0F 5C 44 24 40 F2 0F 11 44 24 30 0F 28 C4 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 0F 28 D4 F2 0F 10 7C 24 38 F2 0F 5C C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 44 24 38 0F 28 C8 F2 0F 58 D0 F2 0F 59 C8 F2 0F 10 74 24 30 0F 28 E9 F2 0F 59 D6 F2 0F 58 EA F2 0F 59 FD F2 0F 11 6C 24 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD 0F 28 EB F2 0F 59 E9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 6C 24 38 F2 0F 11 7C 24 18 F2 0F 10 7C 24 38 F2 0F 5C F9 F2 0F 11 7C 24 30 F2 0F 10 7C 24 38 F2 0F 10 6C 24 30 F2 0F 5C FD F2 0F 11 7C 24 38 F2 0F 10 6C 24 38 F2 0F 5C CD F2 0F 11 4C 24 30 F2 0F 10 4C 24 38 F2 0F 10 7C 24 30 F2 0F 59 F1 F2 0F 58 D7 F2 0F 59 C1 F2 0F 59 E2 F2 0F 58 E6 0F 28 F3 F2 0F 59 F0 F2 0F 11 74 24 38 F2 0F 10 6C 24 38 F2 0F 5C E8 F2 0F 11 6C 24 30 0F 28 E8 F2 0F 10 7C 24 38 F2 0F 58 C4 F2 0F 10 74 24 30 F2 0F 59 D0 F2 0F 5C FE F2 0F 11 7C 24 38 F2 0F 10 74 24 38 F2 0F 5C EE F2 0F 11 6C 24 30 0F 28 E9 F2 0F 10 74 24 38 F2 0F 59 EE F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 7C 24 20 F2 0F 58 FC F2 0F 11 5C 24 38 F2 0F 10 5C 24 38 F2 0F 59 CF F2 0F 5C DD F2 0F 11 5C 24 30 0F 28 DD F2 0F 10 7C 24 38 F2 0F 58 CA F2 0F 10 54 24 30 F2 0F 58 E9 F2 0F 5C FA F2 0F 11 7C 24 38 F2 0F 10 54 24 38 F2 0F 10 7C 24 18 F2 0F 5C DA F2 0F 11 5C 24 30 F2 0F 10 5C 24 38 F2 0F 10 54 24 30 F2 0F 11 54 24 28 F2 0F 10 54 24 10 F2 0F 59 D5 F2 0F 59 FA F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 6C 24 08 F2 0F 58 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D7 F2 0F 59 E0 F2 0F 59 F0 F2 0F 58 D4 F2 0F 10 64 24 20 F2 0F 59 E0 0F 28 C5 F2 0F 58 C6 F2 0F 58 D4 F2 0F 11 44 24 38 F2 0F 10 64 24 38 F2 0F 11 34 24 F2 0F 5C EC F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 CF F2 0F 59 DF F2 0F 59 7C 24 28 F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 10 74 24 30 F2 0F 58 D6 F2 0F 58 D1 0F 28 CC F2 0F 58 CB F2 0F 58 D7 F2 0F 11 4C 24 38 F2 0F 10 44 24 38 F2 0F 5C E0 F2 0F 58 E3 F2 0F 11 64 24 30 F3 0F 5A 09 F2 0F 10 44 24 38 F2 0F 10 5C 24 30 66 0F 2F 0D ?? ?? ?? ?? F2 0F 58 D3 76 47 F2 0F 10 25 ?? ?? ?? ?? 0F 28 CC F2 0F 5C C8 F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 5C CA F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 44 24 30 F2 0F 58 C8 EB 45 F2 0F 10 25 ?? ?? ?? ?? 0F 28 C8 F2 0F 58 CC F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 5C E3 F2 0F 58 E0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 4C 24 30 F2 0F 58 CA 8B 45 0C F2 0F 58 D9 F2 0F 5A DB F3 0F 11 18 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 44 24 38 F2 0F 10 44 24 38 F2 0F 59 44 24 40 F2 0F 11 04 24 0F B6 44 24 07 0F B6 49 03 83 E0 7F 83 E1 80 0B C1 88 44 24 07 33 C0 8B 55 0C F2 0F 5C 0C 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5A C9 F3 0F 11 0A 83 C4 5C 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B F0 81 E6 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C DC F2 0F 59 CB F2 0F 11 0C 24 0F B7 54 24 06 81 E2 F0 7F 00 00 C1 EA 04 81 C2 01 FC FF FF 8B DA F7 DB 81 C3 FF 03 00 00 81 E3 FF 07 00 00 C1 E3 04 0B F3 66 89 74 24 0E 8B F2 F2 0F 59 4C 24 08 83 E6 01 0F 28 E9 8B FE F2 0F 10 35 ?? ?? ?? ?? F2 0F 58 E9 75 03 0F 28 E9 F2 0F 59 F5 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 10 0F 28 FE 8B 5C 24 10 2B D6 C1 E7 08 81 E3 FF 01 00 00 03 DF F2 0F 5C FD F2 0F 11 7C 24 30 F2 0F 10 64 24 30 F2 0F 10 14 DD ?? ?? ?? ?? F2 0F 5C F4 0F 28 FA 0F 28 E5 F2 0F 59 FA 0F 28 CE F2 0F 5C E6 F2 0F 59 F2 F2 0F 59 CF F2 0F 59 FC F2 0F 5C C8 D1 EA F2 0F 58 CF F2 0F 10 3D ?? ?? ?? ?? 81 C2 FF 03 00 00 F2 0F 59 F9 81 E2 FF 07 00 00 C1 E2 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 0B C2 F2 0F 11 44 24 18 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 FA F2 0F 59 D4 F2 0F 59 FD F2 0F 58 FA F2 0F 10 15 ?? ?? ?? ?? 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 38 F2 0F 10 44 24 38 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C C6 F2 0F 58 2D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 64 24 38 F2 0F 10 4C 24 30 F2 0F 5C E1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 64 24 38 F2 0F 10 44 24 38 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C F0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 44 24 30 F2 0F 11 74 24 28 0F 28 F1 F2 0F 59 E3 F2 0F 58 F8 F2 0F 58 35 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 F4 F2 0F 59 C3 F2 0F 59 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 C3 0F 28 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 40 F2 0F 58 E8 F2 0F 59 FD F2 0F 11 7C 24 48 0F 28 FA F2 0F 59 FB F2 0F 11 7C 24 38 F2 0F 10 44 24 38 F2 0F 5C C3 F2 0F 11 44 24 30 F2 0F 10 74 24 38 F2 0F 10 6C 24 30 F2 0F 5C F5 F2 0F 11 74 24 38 F2 0F 10 7C 24 38 F2 0F 5C E7 F2 0F 11 64 24 30 F2 0F 10 64 24 38 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 5C 24 38 F2 0F 10 74 24 38 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 38 F2 0F 10 5C 24 38 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 30 F2 0F 10 74 24 38 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 58 DE F2 0F 11 5C 24 38 F2 0F 11 6C 24 50 F2 0F 10 6C 24 38 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 30 0F 28 E5 F2 0F 10 5C 24 38 F2 0F 10 74 24 30 F2 0F 58 E3 F2 0F 11 64 24 38 F2 0F 10 64 24 38 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 59 D4 F2 0F 10 5C 24 30 F2 0F 11 54 24 38 F2 0F 10 54 24 38 F2 0F 5C D4 F2 0F 11 54 24 30 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 F2 0F 10 6C 24 38 F2 0F 5C E5 F2 0F 11 64 24 30 F2 0F 10 6C 24 38 F2 0F 10 54 24 30 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F3 0F 5A 31 F2 0F 58 D3 66 0F 2F 35 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 10 4C 24 50 F2 0F 58 C8 F2 0F 10 44 24 28 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 64 24 40 F2 0F 10 4C 24 48 F2 0F 59 E0 F2 0F 58 CA F2 0F 59 C5 F2 0F 58 CC 77 4D F2 0F 10 25 ?? ?? ?? ?? 0F 28 D4 F2 0F 10 35 ?? ?? ?? ?? F2 0F 5C D0 F2 0F 5C F1 F2 0F 11 54 24 38 F2 0F 10 5C 24 38 F2 0F 11 04 24 F2 0F 5C E3 F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 44 24 38 F2 0F 10 6C 24 30 0F 28 CD F2 0F 58 CE 8B 45 0C F2 0F 58 C1 F2 0F 5A C0 F3 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 66 0F 2E C8 7A 02 74 54 0F 57 05 ?? ?? ?? ?? 66 0F 2E C8 7A 02 74 1E 8B 45 0C F3 0F 5C D2 F3 0F 5E D2 F3 0F 11 10 B8 01 00 00 00 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 5A C0 F3 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 5A 05 ?? ?? ?? ?? 8B 45 0C F3 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F3 0F 5E D2 8B 45 0C BA 01 00 00 00 F3 0F 11 10 33 C0 F7 01 FF FF 7F 00 0F 44 C2 83 C4 5C 5B 5F 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "___avx_tan4"
		size = 2736
		refs = "0012 ___common_dtan_data 0176 ___common_dtan_cout_rare 01f6 ___common_dtan_reduction_data 0287 _2il0floatpacket_355 028f _2il0floatpacket_356 029f _2il0floatpacket_357 0624 _2il0floatpacket_358 065f _2il0floatpacket_359 0673 _2il0floatpacket_361 0685 _2il0floatpacket_362 06cf _2il0floatpacket_363 06e5 _2il0floatpacket_364 0744 _2il0floatpacket_368 0755 _2il0floatpacket_365 075e _2il0floatpacket_366 0767 _2il0floatpacket_367 07a1 _2il0floatpacket_369 07ae _2il0floatpacket_370 07d0 _2il0floatpacket_360 07dc _2il0floatpacket_371"
	strings:
		$1 = { 55 8B EC 83 E4 C0 57 53 81 EC 38 03 00 00 C5 FD 10 0D ?? ?? ?? ?? C5 FD 54 E1 C5 DD C2 1D ?? ?? ?? ?? 1E C5 F5 55 C8 C4 E3 7D 19 DD 01 C5 E0 C6 F5 DD C5 F8 50 C6 85 C0 0F 85 41 01 00 00 C5 FD 10 1D ?? ?? ?? ?? 33 DB C5 DD 59 2D ?? ?? ?? ?? C5 D5 58 F3 C5 CD 5C DB C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C E5 C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C E5 C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C E5 C5 E5 59 2D ?? ?? ?? ?? C5 DD 5C DD C5 E5 59 D3 C5 D9 73 F6 3F C4 E3 7D 19 F5 01 C5 C1 73 F5 3F C5 D1 73 F5 3E C4 E3 5D 18 E7 01 C5 DD 57 E1 C5 F1 73 F6 3E C5 C5 57 FF C4 E3 75 18 F5 01 C5 ED 59 2D ?? ?? ?? ?? C5 CD C2 CF 0C C5 ED 59 35 ?? ?? ?? ?? C5 D5 58 2D ?? ?? ?? ?? C5 CD 58 3D ?? ?? ?? ?? C5 D5 59 F2 C5 C5 59 FA C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 2D ?? ?? ?? ?? C5 CD 59 F2 C5 D5 59 EA C5 CD 58 3D ?? ?? ?? ?? C5 D5 58 35 ?? ?? ?? ?? C5 C5 59 FB C5 F5 55 EF C5 F5 54 DE C5 D5 56 EB C5 F5 54 DF C5 F5 55 CE C5 E5 56 C9 C5 D5 5E C9 C5 F5 57 CC 85 DB 75 10 C5 FD 28 C1 81 C4 38 03 00 00 5B 5F 8B E5 5D C3 C5 FD 11 04 24 C5 FD 11 4C 24 40 74 E3 33 FF 0F A3 FB 72 0E 47 83 FF 20 7C F5 C5 FD 10 4C 24 40 EB CE C5 F8 77 8D 44 FC 40 8D 14 FC 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FD 10 0D ?? ?? ?? ?? B8 00 00 F0 7F C5 FD 11 04 24 C5 F9 6E F8 C5 F9 70 F7 11 C5 F5 54 E4 C5 DD C2 D9 00 C4 E3 7D 19 DC 01 C5 E0 C6 EC DD C5 F8 50 DD C4 E3 7D 19 C5 01 C5 C9 DB DD C5 F8 11 AC 24 30 01 00 00 C5 F8 28 D0 C5 C9 DB CA C5 D9 73 D1 34 C5 F1 73 D3 34 C5 F9 7E E7 C5 F9 7E C8 C5 F8 11 94 24 20 01 00 00 C4 E3 79 16 E1 02 8D 14 7F C5 FA 7E 1C D5 ?? ?? ?? ?? 8D 3C 40 C4 E3 79 16 C8 02 C5 FA 7E 24 FD ?? ?? ?? ?? 8D 0C 49 C5 E1 16 3C CD ?? ?? ?? ?? C5 FA 7E 1C FD ?? ?? ?? ?? 8D 04 40 C5 E1 16 34 C5 ?? ?? ?? ?? C5 FA 7E 1C D5 ?? ?? ?? ?? C5 E1 16 04 CD ?? ?? ?? ?? C5 FA 7E 1C D5 ?? ?? ?? ?? BA 00 00 00 80 C5 D9 16 0C C5 ?? ?? ?? ?? C5 E1 16 24 CD ?? ?? ?? ?? C5 FA 7E 1C FD ?? ?? ?? ?? C5 F9 11 A4 24 60 01 00 00 C5 E1 16 24 C5 ?? ?? ?? ?? C5 F9 11 A4 24 70 01 00 00 C5 FA 6F 25 ?? ?? ?? ?? C5 FA 6F 1D ?? ?? ?? ?? C5 D9 DB D2 C5 D9 DB ED C5 FA 6F 25 ?? ?? ?? ?? C5 F9 11 BC 24 40 01 00 00 C5 E9 D4 D3 C5 D1 D4 DB C5 C1 DB EC C5 C1 73 D0 20 C5 FA 7F BC 24 A0 01 00 00 C5 C1 73 D1 20 C5 F1 DB CC C5 F9 DB C4 C5 FA 7F 8C 24 D0 01 00 00 C5 F9 10 8C 24 60 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 E0 01 00 00 C5 F9 10 8C 24 70 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 F0 01 00 00 C5 F1 73 D2 20 C5 E9 DB D4 C5 FA 7F AC 24 80 01 00 00 C5 E9 F4 ED C5 F9 11 B4 24 50 01 00 00 C5 C9 DB F4 C5 FA 7F 8C 24 00 02 00 00 C5 F1 73 D3 20 C5 E1 DB DC C5 FA 7F B4 24 90 01 00 00 C5 FA 7F AC 24 30 02 00 00 C5 E1 F4 F6 C5 E9 F4 AC 24 A0 01 00 00 C5 FA 7F BC 24 B0 01 00 00 C5 E1 F4 FF C5 FA 7F 84 24 C0 01 00 00 C5 FA 7F B4 24 40 02 00 00 C5 FA 7F AC 24 50 02 00 00 C5 E9 F4 E8 C5 D9 DB B4 24 60 01 00 00 C5 FA 6F 84 24 00 02 00 00 C5 FA 7F BC 24 60 02 00 00 C5 F9 F4 FE C5 C9 73 D7 20 C5 FA 6F BC 24 E0 01 00 00 C5 FA 7F 94 24 10 02 00 00 C5 E9 F4 D7 C5 F9 F4 C7 C5 C1 73 D2 20 C5 F9 D4 C7 C5 FA 7F AC 24 70 02 00 00 C5 D1 DB EC C5 D1 D4 E8 C5 D9 DB 84 24 70 01 00 00 C5 C9 D4 FD C5 F1 F4 F0 C5 FA 6F 94 24 F0 01 00 00 C5 D1 73 D6 20 C5 FA 7F 9C 24 20 02 00 00 C5 E9 F4 B4 24 20 02 00 00 C5 F1 F4 C2 C5 E1 F4 9C 24 D0 01 00 00 C5 E9 73 D6 20 C5 F9 D4 C2 C5 FA 7F 9C 24 80 02 00 00 C5 E1 DB DC C5 E1 D4 D8 C5 FA 6F 84 24 00 02 00 00 C5 D1 D4 D3 C5 F9 F4 9C 24 C0 01 00 00 C5 FA 6F B4 24 70 02 00 00 C5 C9 73 D6 20 C5 E1 D4 DE C5 D9 DB AC 24 50 02 00 00 C5 D1 D4 EB C5 FA 7F BC 24 90 02 00 00 C5 C1 73 D7 20 C5 C1 D4 FD C5 F1 F4 AC 24 D0 01 00 00 C5 FA 6F 9C 24 80 02 00 00 C5 E1 73 D3 20 C5 D1 D4 EB C5 D9 DB B4 24 60 02 00 00 C5 C9 D4 F5 C5 FA 7F 94 24 A0 02 00 00 C5 E9 73 D2 20 C5 E9 D4 EE C5 F9 F4 B4 24 A0 01 00 00 C5 FA 6F 94 24 50 02 00 00 C5 E9 73 D2 20 C5 C9 D4 F2 C5 F1 F4 94 24 B0 01 00 00 C5 D9 DB 9C 24 30 02 00 00 C5 E1 D4 DE C5 FA 7F BC 24 B0 02 00 00 C5 C1 73 D7 20 C5 C1 D4 F3 C5 FA 6F BC 24 60 02 00 00 C5 C1 73 D7 20 C5 E9 D4 D7 C5 D9 DB 9C 24 40 02 00 00 C5 C1 73 D6 20 C5 E1 D4 DA C5 FA 7F AC 24 C0 02 00 00 C5 D1 73 D5 20 C5 D1 D4 D3 C5 F9 10 AC 24 40 01 00 00 C5 C9 DB F4 C5 E1 73 D5 20 C5 E1 F4 AC 24 10 02 00 00 C5 F9 F4 9C 24 80 01 00 00 C5 FA 6F 84 24 30 02 00 00 C5 D1 DB EC C5 F9 73 D0 20 C5 E1 D4 D8 C5 D1 D4 EB C5 C1 D4 FD C5 F9 10 AC 24 50 01 00 00 C5 E1 73 F7 20 C5 F9 73 D5 20 C5 C1 73 D2 20 C5 E1 D4 DE C5 F9 F4 B4 24 20 02 00 00 C5 F1 F4 84 24 90 01 00 00 C5 FA 6F 8C 24 40 02 00 00 C5 C9 DB EC C5 F1 73 D1 20 C5 E9 DB D4 C5 F9 D4 F1 C5 D1 D4 EE C5 C1 D4 FD C5 D1 73 F7 20 C5 FA 6F B4 24 C0 02 00 00 C5 D1 D4 CA C5 FA 6F AC 24 B0 02 00 00 C5 E9 73 F6 20 C5 D9 DB BC 24 90 02 00 00 C5 F9 73 F5 20 C5 D9 DB A4 24 A0 02 00 00 C5 F9 D4 EF C5 E9 D4 FC C5 F9 6E E2 C5 F9 70 C4 11 C5 F9 DB A4 24 20 01 00 00 C5 F9 DB B4 24 30 01 00 00 C5 FA 6F 05 ?? ?? ?? ?? C5 FA 7F 9C 24 D0 02 00 00 C5 E1 73 D3 0C C5 D9 EF D0 C5 C9 EF C0 C5 FA 7F 8C 24 E0 02 00 00 C5 F1 73 D1 0C C5 E1 EB DA C5 F1 EB C8 C4 E3 65 18 C1 01 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 ED 58 D8 C5 E5 5C CA C5 FD 5C D1 C5 FA 6F 05 ?? ?? ?? ?? C5 C9 EF C8 C5 FD 11 54 24 20 C5 FA 6F 15 ?? ?? ?? ?? C5 F8 11 9C 24 F0 02 00 00 C4 E3 7D 19 9C 24 00 03 00 00 01 C5 D9 EF D8 C5 E9 DB C5 C5 E9 DB D7 C5 F9 73 F0 1C C5 E9 73 F2 1C C5 F9 EB C3 C5 E9 EB D1 C5 D1 73 D5 18 C5 C1 73 D7 18 C4 E3 65 18 C9 01 C5 FA 6F 1D ?? ?? ?? ?? C4 E3 7D 18 D2 01 C5 D9 EF C3 C5 C9 EF DB C5 FA 6F 35 ?? ?? ?? ?? C5 C9 DB A4 24 D0 02 00 00 C5 C9 DB B4 24 E0 02 00 00 C5 D9 73 F4 28 C5 D9 EB E5 C5 D1 73 F6 28 C5 D1 EB EF C5 D9 EB E0 C5 D1 EB FB C5 ED 5C D1 C5 FD 10 4C 24 20 C4 E3 5D 18 E7 01 C4 E3 7D 18 DB 01 C5 DD 5C F3 C5 F5 58 C6 C5 F5 5C D8 C5 CD 58 E3 C5 DD 58 F2 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 FD 54 FA C5 FD 5C C7 C4 E2 7D 1A 2D ?? ?? ?? ?? C4 E2 7D 1A 1D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C5 E5 59 D7 C5 E5 59 C8 C5 DD 59 FF C5 D5 59 EE C5 DD 59 C0 C5 F5 58 FF C5 D5 58 C8 C5 C5 58 F1 C5 FD 10 0C 24 C5 ED 58 EE C5 ED 5C DD C5 E5 58 DE C4 E2 7D 1A 25 ?? ?? ?? ?? C5 F5 54 D4 C4 E2 7D 1A 05 ?? ?? ?? ?? C5 ED C2 E0 1E C5 ED C2 F8 12 C5 C5 54 F1 C5 DD 54 ED C5 CD 56 D5 C5 DD 54 DB C5 FA 6F 2D ?? ?? ?? ?? C5 ED 58 E3 C5 FA 6F 3D ?? ?? ?? ?? C5 D1 DB 9C 24 F0 02 00 00 C5 D1 DB 84 24 00 03 00 00 C5 E1 DB CF C5 F9 DB DF C5 F9 7E CF C5 F9 7E D8 6B CF 68 6B C0 68 C5 FA 7E B1 ?? ?? ?? ?? C4 E3 79 16 CA 02 C4 E3 79 16 DF 02 6B D2 68 6B FF 68 C5 FA 7E A8 ?? ?? ?? ?? C5 FA 7E B9 ?? ?? ?? ?? C5 C9 16 92 ?? ?? ?? ?? C5 FA 7E B0 ?? ?? ?? ?? C5 D1 16 87 ?? ?? ?? ?? C5 C1 16 8A ?? ?? ?? ?? C5 FA 7E A9 ?? ?? ?? ?? C5 C9 16 9F ?? ?? ?? ?? C5 FA 7E B8 ?? ?? ?? ?? C4 E3 6D 18 D0 01 C5 D1 16 82 ?? ?? ?? ?? C5 FA 7E A9 ?? ?? ?? ?? C4 E3 75 18 F3 01 C5 C1 16 9F ?? ?? ?? ?? C5 D1 16 BA ?? ?? ?? ?? C4 E3 7D 18 CB 01 C5 FA 7E 98 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C5 FA 7E 81 ?? ?? ?? ?? C5 F9 16 9A ?? ?? ?? ?? C4 E3 45 18 FD 01 C5 FA 7E A8 ?? ?? ?? ?? C5 D1 16 87 ?? ?? ?? ?? C5 FA 7E A9 ?? ?? ?? ?? C4 E3 65 18 D8 01 C5 FC 11 5C 24 40 C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 5C 24 60 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 9C 24 80 00 00 00 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 9C 24 A0 00 00 00 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 9C 24 C0 00 00 00 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 FC 11 9C 24 E0 00 00 00 C5 FA 7E A9 ?? ?? ?? ?? C5 FA 7E 98 ?? ?? ?? ?? C5 D1 16 82 ?? ?? ?? ?? C5 E1 16 AF ?? ?? ?? ?? C4 E3 7D 18 DD 01 C5 ED 5C C4 C5 FC 11 9C 24 00 01 00 00 C5 FD 5A D0 C5 F8 53 DA C5 FC 5A EB C5 FD 59 C5 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 ED 5C D8 C5 E5 59 C3 C5 D5 59 D0 C5 FD 58 DB C5 ED 58 C5 C5 DD 59 94 24 E0 00 00 00 C5 FD 59 DB C5 DD 59 84 24 A0 00 00 00 C5 ED 58 94 24 C0 00 00 00 C5 E5 58 DD C5 C5 59 EC C5 E5 59 F6 C5 D5 58 F9 C5 DD 59 CC C5 DD 59 6C 24 60 C5 CD 58 DF C5 FD 58 B4 24 80 00 00 00 C5 D5 58 7C 24 40 C5 F5 59 84 24 00 01 00 00 C5 F5 59 E9 C5 CD 59 C9 C5 FD 58 C2 C5 F5 58 CF C5 FD 59 F5 C5 CD 58 C1 C5 FD 59 E4 C5 FD 10 04 24 C5 DD 58 CB E9 8E F6 FF FF 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "___sse2_tanh2"
		size = 656
		refs = "0016 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC C0 00 00 00 83 E4 F0 89 84 24 84 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 C8 89 4C 24 60 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 89 74 24 64 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 54 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 4C 24 50 66 0F 5C D3 8D 44 24 50 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 66 0F C2 3D ?? ?? ?? ?? 05 66 0F 73 F6 04 66 0F 29 4C 24 40 66 0F 59 EA 66 0F FB D9 66 0F 5C C4 66 0F 7E F6 89 7C 24 68 66 0F 5C C5 66 0F 50 CF 66 0F FE 0D ?? ?? ?? ?? 81 E6 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F7 66 0F 28 BE ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 30 F7 DE 66 0F 28 B7 ?? ?? ?? ?? 81 C6 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DF 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C7 00 04 00 00 66 0F 28 A6 ?? ?? ?? ?? 66 0F C6 FE 03 66 0F 28 97 ?? ?? ?? ?? 66 0F 59 E9 66 0F 28 F4 66 0F 59 F9 66 0F C6 E2 00 66 0F 29 2C 24 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 20 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? 83 F9 03 66 0F 59 D0 66 0F 58 E6 0F 84 C8 00 00 00 66 0F 29 7C 24 10 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 58 EC 66 0F 59 C3 66 0F 5C FC 66 0F 59 D1 66 0F 28 D8 66 0F 58 D1 66 0F 59 DD 66 0F 28 CA 66 0F 59 D7 66 0F 28 20 66 0F 59 C7 66 0F 58 DA 66 0F 59 CD 66 0F 28 7C 24 10 66 0F 58 DE 66 0F 28 6C 24 20 66 0F 58 DF 66 0F 5C F7 66 0F 28 14 24 66 0F 58 DD 66 0F 5C C6 66 0F 54 25 ?? ?? ?? ?? 66 0F 58 DA 66 0F 5C EA 66 0F 58 C1 8B 74 24 64 66 0F 5C C5 8B 7C 24 68 66 0F 5E C3 83 F9 01 66 0F 56 C4 7D 08 8B 4C 24 60 EB 5B 8B FF 7F 0A 66 0F 28 3D ?? ?? ?? ?? EB 10 66 0F 28 3D ?? ?? ?? ?? EB 06 8B FF 66 0F 57 FF 66 0F 28 08 66 0F 54 C7 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 DB 66 0F 54 D1 66 0F 55 3D ?? ?? ?? ?? 66 0F C2 D9 03 8B 4C 24 60 66 0F 56 C7 8B 74 24 64 66 0F 56 C2 8B 7C 24 68 66 0F 56 C3 8B A4 24 84 00 00 00 C3 8D 49 00 }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "___common_dlog10_cout_rare"
		size = 736
		refs = "003a __vmldLgHATab 006a _2il0floatpacket_78 026f _2il0floatpacket_79"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 18 8B 45 08 0F B7 48 06 8B D1 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 63 02 00 00 F2 0F 10 18 F7 C1 F0 7F 00 00 F2 0F 11 5C 24 10 75 19 F2 0F 10 05 ?? ?? ?? ?? BA C4 FF FF FF F2 0F 59 D8 F2 0F 11 5C 24 10 EB 02 33 D2 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D8 0F 86 E5 01 00 00 0F 28 CB F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 08 80 64 24 0F 7F F2 0F 10 44 24 08 66 0F 2F 05 ?? ?? ?? ?? 0F 86 42 01 00 00 F2 0F 11 5C 24 08 0F B7 4C 24 0E 81 E1 0F 80 FF FF 81 C9 F0 3F FF FF 66 89 4C 24 0E F2 0F 10 6C 24 08 0F 28 DD 0F 28 E5 0F B7 44 24 16 25 F0 7F 00 00 F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? C1 E8 04 F2 0F 11 1C 24 F2 0F 10 0D ?? ?? ?? ?? 8B 4D 0C 8D 94 02 01 FC FF FF 8B 04 24 F2 0F 11 24 24 83 E0 7F F2 0F 10 1C 24 F2 0F 2A D2 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 5C EB F2 0F 59 15 ?? ?? ?? ?? 8D 14 40 33 C0 F2 0F 10 04 D5 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 14 D5 ?? ?? ?? ?? F2 0F 58 0C D5 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 5C 1D ?? ?? ?? ?? 0F 28 F3 0F 28 F8 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 F0 F2 0F 58 CB F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 FD F2 0F 59 DD F2 0F 58 D7 F2 0F 58 C2 F2 0F 58 C3 F2 0F 58 C8 F2 0F 11 09 8B E5 5D C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C1 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C1 F2 0F 58 C8 F2 0F 11 08 33 C0 8B E5 5D C3 66 0F 2E D8 7A 02 74 14 F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 8B 45 0C F2 0F 11 08 B8 02 00 00 00 8B E5 5D C3 0F B6 50 07 F7 C2 80 00 00 00 75 15 F2 0F 10 00 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 8B E5 5D C3 F7 40 04 FF FF 0F 00 75 E2 83 38 00 75 DD F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_97_2_0 {
	meta:
		name = "__RTC_InitBase"
		size = 25
		refs = "0002 ?init@?1??_RTC_InitBase@@9@4_NA 0013 __RTC_SetErrorFuncW"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 75 0F 6A 00 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "___avx_pow4"
		size = 1024
		refs = "0026 ___common_dpow_data 03f3 ___common_dpow_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 C5 FD 11 04 24 C5 FD 11 4C 24 20 C4 E3 7D 19 C2 01 C5 F8 C6 EA DD C5 FD 54 25 ?? ?? ?? ?? C5 DD 56 15 ?? ?? ?? ?? C5 F8 11 AC 24 C0 00 00 00 C4 E3 7D 19 CB 01 C5 F0 C6 F3 DD C5 D0 54 1D ?? ?? ?? ?? C5 C9 DB 3D ?? ?? ?? ?? C5 E1 FE 35 ?? ?? ?? ?? C5 FA 7F BC 24 D0 00 00 00 C5 C1 72 D6 0A C5 F1 72 F7 03 C5 F9 72 F7 04 C5 F9 7E C8 C5 D1 FA 2D ?? ?? ?? ?? C5 D1 72 E5 14 C4 E3 79 16 CA 01 C4 E3 79 16 C9 02 C5 FB 10 A0 ?? ?? ?? ?? C4 E3 79 16 C8 03 C5 D9 16 9A ?? ?? ?? ?? C5 F9 7E C2 C5 FB 10 B1 ?? ?? ?? ?? C5 C9 16 88 ?? ?? ?? ?? C4 E3 79 16 C1 01 C4 E3 79 16 C0 02 C5 F9 10 B2 ?? ?? ?? ?? C4 E3 79 16 C2 03 C5 F9 10 B9 ?? ?? ?? ?? C5 D1 FE 25 ?? ?? ?? ?? C4 E3 4D 18 80 ?? ?? ?? ?? 01 C4 E3 45 18 B2 ?? ?? ?? ?? 01 C5 FD 14 FE C4 E3 65 18 D9 01 C5 FD 15 CE C5 F9 70 F4 50 C5 F9 70 C4 FA C4 E3 4D 18 E8 01 C5 D5 54 35 ?? ?? ?? ?? C5 ED 54 2D ?? ?? ?? ?? C5 ED 5C E5 C5 CD 5C 35 ?? ?? ?? ?? C5 ED 59 D3 C5 D5 59 EB C5 ED 58 05 ?? ?? ?? ?? C5 D5 5C EA C5 DD 59 D3 C5 ED 58 E5 C5 CD 58 D7 C5 ED 58 F0 C5 CD 58 FC C5 ED 5C DE C5 CD 5C D7 C5 E5 58 D8 C5 ED 58 EC C5 D5 58 F3 C5 FD 58 DC C5 CD 58 F1 C5 E5 59 0D ?? ?? ?? ?? C5 F5 58 25 ?? ?? ?? ?? C5 DD 59 C3 C5 FD 58 15 ?? ?? ?? ?? C5 ED 59 EB C5 D5 58 0D ?? ?? ?? ?? C5 F5 59 E3 C5 DD 58 05 ?? ?? ?? ?? C5 FD 59 D3 C5 ED 58 2D ?? ?? ?? ?? C5 D5 59 DB C5 E5 58 F6 C5 FD 10 1D ?? ?? ?? ?? C5 C5 58 EE C5 D5 5C FF C5 CD 5C D7 C5 FD 10 74 24 20 C5 FD 11 54 24 40 C5 D5 54 FB C5 CD 54 D3 C5 ED 59 CF C5 FD 11 7C 24 60 C5 CD 5C C2 C5 D5 5C EF C5 F8 10 B4 24 C0 00 00 00 C5 F8 10 3D ?? ?? ?? ?? C5 FD 11 8C 24 80 00 00 00 C5 ED 59 D5 C4 E3 7D 19 CC 01 C5 F0 C6 DC DD C5 E1 DB 25 ?? ?? ?? ?? C5 C9 FE 1D ?? ?? ?? ?? C5 F8 10 35 ?? ?? ?? ?? C5 C1 66 CB C5 FA 6F 9C 24 D0 00 00 00 C5 E1 66 FE C5 E1 76 DE C5 C1 EB FB C5 F1 EB F7 C5 FD 59 FD C5 F8 10 0D ?? ?? ?? ?? C5 D9 66 D9 C5 D9 76 E1 C5 E1 EB DC C5 C9 EB F3 C5 ED 58 EF C5 F8 50 C6 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 BC 24 80 00 00 00 C5 FD 10 54 24 20 C5 FD 59 44 24 60 C5 C5 58 E1 C5 ED 59 74 24 40 C5 FD 58 DD C5 E5 58 DE C4 E3 7D 19 E0 01 C5 DD 5C C9 C5 D8 C6 E8 88 C5 D0 54 15 ?? ?? ?? ?? C5 F9 72 F2 04 C5 E9 72 F5 0D C5 C5 5C F9 C5 E9 FE 2D ?? ?? ?? ?? C5 F9 70 D5 50 C5 F9 7E C1 C5 F9 70 ED FA C5 E5 58 DF C4 E3 79 16 C2 01 C5 E5 59 35 ?? ?? ?? ?? C4 E3 6D 18 D5 01 C5 ED 54 2D ?? ?? ?? ?? C5 FB 10 91 ?? ?? ?? ?? C4 E3 79 16 C1 02 C5 FD 11 AC 24 A0 00 00 00 C5 E9 16 AA ?? ?? ?? ?? C5 FB 10 91 ?? ?? ?? ?? C4 E3 79 16 C2 03 C5 E9 16 82 ?? ?? ?? ?? C4 E3 55 18 D0 01 C5 CD 58 05 ?? ?? ?? ?? C5 ED 59 94 24 A0 00 00 00 C5 FD 59 CB C5 ED 59 EB C5 F5 58 25 ?? ?? ?? ?? C5 DD 59 F3 C5 CD 58 3D ?? ?? ?? ?? C5 C5 59 DB C5 E5 58 05 ?? ?? ?? ?? C5 FD 59 ED C5 D5 58 C2 85 C0 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 10 54 24 20 C5 FD 11 84 24 C0 00 00 00 C5 FD 11 4C 24 40 C5 FD 11 94 24 80 00 00 00 74 D7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 C0 00 00 00 EB AD C5 F8 77 8D 8C F4 C0 00 00 00 8D 54 F4 40 8D 84 F4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D 64 24 00 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__alldvrm"
		size = 223
	strings:
		$1 = { 57 56 55 33 FF 33 ED 8B 44 24 14 0B C0 7D 15 47 45 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 28 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B F0 8B C3 F7 64 24 18 8B C8 8B C6 F7 64 24 18 03 D1 EB 47 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 0F 3B 44 24 10 76 09 4E 2B 44 24 18 1B 54 24 1C 33 DB 2B 44 24 10 1B 54 24 14 4D 79 07 F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5D 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "___avx_sinh4"
		size = 512
		refs = "0012 ___common_dsinh_data 01ea ___common_dsinh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 81 EC B8 00 00 00 C5 FD 54 35 ?? ?? ?? ?? C5 CD 57 C8 C5 FD 10 25 ?? ?? ?? ?? C5 F5 59 3D ?? ?? ?? ?? C5 FD 11 44 24 20 C5 F9 10 15 ?? ?? ?? ?? C5 FD 11 34 24 C5 C5 58 EC C4 E3 7D 19 CB 01 C5 F0 C6 C3 DD C5 F9 66 35 ?? ?? ?? ?? C5 F8 50 FE C5 D1 DB FA C4 E3 7D 19 EE 01 C5 F9 7E F8 C5 C8 54 C2 C5 D5 5C D4 C5 D1 EF EF C5 F9 7E C1 C5 ED 59 25 ?? ?? ?? ?? C5 ED 59 15 ?? ?? ?? ?? C5 F5 5C CC C1 E0 04 C4 E3 79 16 FA 02 C5 C1 73 F5 2D C1 E2 04 C5 C8 57 E8 C1 E1 04 C5 C9 73 F5 2D C4 E3 79 16 C6 02 C1 E6 04 C5 FA 7E 98 ?? ?? ?? ?? C5 E1 16 A2 ?? ?? ?? ?? C5 FA 7E 99 ?? ?? ?? ?? C5 F9 11 64 24 60 C5 E1 16 A6 ?? ?? ?? ?? C5 F9 11 64 24 70 C5 FA 7E 98 ?? ?? ?? ?? C5 FA 7E A1 ?? ?? ?? ?? C5 E1 16 9A ?? ?? ?? ?? C5 F5 5C D2 C5 D9 16 A6 ?? ?? ?? ?? C5 E1 D4 DF C5 D9 D4 E6 C5 ED 59 CA C5 F9 10 6C 24 60 C4 E3 65 18 C4 01 C5 F9 10 5C 24 70 C5 D1 D4 E7 C5 D1 FB FF C5 FC 11 44 24 40 C5 E1 D4 C6 C5 E1 FB DE C4 E3 5D 18 E0 01 C4 E3 45 18 C3 01 C5 DD 58 E8 C5 DD 5C C0 C5 F5 59 25 ?? ?? ?? ?? C5 DD 58 35 ?? ?? ?? ?? C5 CD 59 E1 C5 DD 59 DA C5 E5 58 DA C5 F5 59 15 ?? ?? ?? ?? C5 ED 58 25 ?? ?? ?? ?? C5 FC 10 54 24 40 C5 DD 59 C9 C5 ED 58 E0 C5 ED 58 ED C5 F5 59 C4 C5 E5 59 D5 C5 ED 58 C8 C5 F5 58 DC C5 E5 56 04 24 85 FF 75 0C 81 C4 B8 00 00 00 5F 5E 8B E5 5D C3 C5 FD 10 4C 24 20 C5 FD 11 44 24 40 C5 FD 11 0C 24 74 E1 33 F6 0F A3 F7 72 18 46 83 FE 20 7C F5 C5 FD 10 44 24 40 81 C4 B8 00 00 00 5F 5E 8B E5 5D C3 C5 F8 77 8D 44 F4 40 8D 14 F4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_103_1_0 {
	meta:
		name = "??_L@YGXPAXIIP6EX0@Z1@Z"
		size = 105
		refs = "0003 __sehtable$??_L@YGXPAXIIP6EX0@Z1@Z 0008 __SEH_prolog4 0020 @_guard_check_icall@4 0048 __SEH_epilog4 0064 ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 88 5D E7 89 5D FC 3B 5D 10 74 1A 8B 4D 14 E8 ?? ?? ?? ?? 8B 4D 08 FF 55 14 8B 45 0C 01 45 08 43 89 5D E0 EB E1 B0 01 88 45 E7 C7 45 FC FE FF FF FF E8 0E 00 00 00 E8 ?? ?? ?? ?? C2 14 00 8B 5D E0 8A 45 E7 84 C0 75 0F FF 75 18 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__allmul"
		size = 52
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 10 0B C8 8B 4C 24 0C 75 09 8B 44 24 04 F7 E1 C2 10 00 53 F7 E1 8B D8 8B 44 24 08 F7 64 24 14 03 D8 8B 44 24 08 F7 E1 03 D3 5B C2 10 00 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "___sse2_coshf4"
		size = 320
		refs = "0012 ___common_scosh_data 0135 ___common_scosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 C8 0F 28 3D ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 55 F9 0F 59 DF 0F 28 25 ?? ?? ?? ?? 0F 29 0C 24 0F 28 CF 66 0F 6F 15 ?? ?? ?? ?? 0F 58 DC 66 0F 66 CA 66 0F 76 D7 66 0F EB CA 0F 50 D1 0F 28 CB 0F 28 15 ?? ?? ?? ?? 66 0F 72 F3 17 0F 28 2D ?? ?? ?? ?? 0F 5C CC 0F 59 D1 85 D2 0F 28 25 ?? ?? ?? ?? 0F 5C FA 0F 59 E1 0F 28 35 ?? ?? ?? ?? 0F 5C FC 0F 28 CF 0F 59 CF 0F 59 E9 0F 59 F1 0F 58 2D ?? ?? ?? ?? 0F 58 35 ?? ?? ?? ?? 0F 59 E9 0F 59 F1 0F 59 EF 0F 58 35 ?? ?? ?? ?? 0F 58 EF 0F 59 F1 66 0F 6F 05 ?? ?? ?? ?? 66 0F 6F D0 66 0F FA C3 66 0F FE D3 66 0F 6F DA 0F 58 D0 0F 5C D8 0F 59 F2 0F 59 DD 0F 58 DE 0F 58 DA 75 07 0F 28 C3 8B E5 5D C3 0F 28 0C 24 0F 29 4C 24 40 0F 29 9C 24 80 00 00 00 74 E6 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 9C 24 80 00 00 00 EB B5 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8B FF }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z"
		size = 20
		refs = "0004 ___security_cookie"
		altNames = "??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6GH01K@Z@Z ??$__crt_fast_decode_pointer@P6GXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6GXPAU_RTL_CONDITION_VARIABLE@@@ZQ6GX0@Z@Z ??$__crt_fast_decode_pointer@PAX@@YAPAXQAX@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8B C8 33 45 08 83 E1 1F D3 C8 5D C3 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@PAP6AXXZ@@YAPAP6AXXZQAP6AXXZ@Z"
		size = 29
		refs = "0004 ___security_cookie"
		altNames = "??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6GH01K@Z@Z ??$__crt_fast_encode_pointer@P6GXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6GXPAU_RTL_CONDITION_VARIABLE@@@ZQ6GX0@Z@Z ??$__crt_fast_encode_pointer@PAX@@YAPAXQAX@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 E0 1F 6A 20 59 2B C8 8B 45 08 D3 C8 33 05 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_109_4_0 {
	meta:
		name = "?find_pe_section@@YAPAU_IMAGE_SECTION_HEADER@@QAEI@Z"
		size = 68
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B 48 3C 03 C8 0F B7 41 14 8D 51 18 03 D0 0F B7 41 06 6B F0 28 03 F2 3B D6 74 19 8B 4D 0C 3B 4A 0C 72 0A 8B 42 08 03 42 0C 3B C8 72 0C 83 C2 28 3B D6 75 EA 33 C0 5E 5D C3 8B C2 EB F9 }
	condition:
		$1
}

rule file_109_5_0 {
	meta:
		name = "?is_potentially_valid_image_base@@YA_NQAX@Z"
		size = 51
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 75 04 32 C0 5D C3 B9 4D 5A 00 00 66 39 08 75 F2 8B 48 3C 03 C8 81 39 50 45 00 00 75 E5 B8 0B 01 00 00 66 39 41 18 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_109_7_0 {
	meta:
		name = "___scrt_acquire_startup_lock"
		size = 53
		refs = "0001 ___scrt_is_ucrt_dll_in_use 0014 ___scrt_native_startup_lock"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 03 32 C0 C3 64 A1 18 00 00 00 56 BE ?? ?? ?? ?? 8B 50 04 EB 04 3B D0 74 10 33 C0 8B CA F0 0F B1 0E 85 C0 75 F0 32 C0 5E C3 B0 01 5E C3 }
	condition:
		$1
}

rule file_109_8_0 {
	meta:
		name = "___scrt_dllmain_after_initialize_c"
		size = 43
		refs = "0001 ___scrt_is_ucrt_dll_in_use 000a ___isa_available_init 0011 __get_startup_argv_mode 0017 __configure_narrow_argv 0024 __initialize_narrow_environment"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? EB 18 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 85 C0 74 03 32 C0 C3 E8 ?? ?? ?? ?? B0 01 C3 }
	condition:
		$1
}

rule file_109_10_0 {
	meta:
		name = "___scrt_dllmain_crt_thread_attach"
		size = 31
		refs = "0001 ___vcrt_thread_attach 000d ___acrt_thread_attach 0016 ___vcrt_thread_detach"
	strings:
		$1 = { E8 ?? ?? ?? ?? 84 C0 75 03 32 C0 C3 E8 ?? ?? ?? ?? 84 C0 75 07 E8 ?? ?? ?? ?? EB ED B0 01 C3 }
	condition:
		$1
}

rule file_109_12_0 {
	meta:
		name = "___scrt_dllmain_exception_filter"
		size = 51
		refs = "0004 ___scrt_is_ucrt_dll_in_use 001d @_guard_check_icall@4 002b __seh_filter_dll"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 75 18 83 7D 0C 01 75 12 FF 75 10 8B 4D 14 50 FF 75 08 E8 ?? ?? ?? ?? FF 55 14 FF 75 1C FF 75 18 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_109_13_0 {
	meta:
		name = "___scrt_dllmain_uninitialize_c"
		size = 35
		refs = "0001 ___scrt_is_ucrt_dll_in_use 000a ?module_local_atexit_table@@3U_onexit_table_t@@A 000f __execute_onexit_table 0016 __is_c_termination_complete 001e __cexit"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 74 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_109_15_0 {
	meta:
		name = "___scrt_initialize_crt"
		size = 57
		refs = "000b ?is_initialized_as_dll@@3_NA 0011 ___isa_available_init 0016 ___vcrt_initialize 0023 ___acrt_initialize 002e ___vcrt_uninitialize"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 75 07 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 04 32 C0 5D C3 E8 ?? ?? ?? ?? 84 C0 75 0A 6A 00 E8 ?? ?? ?? ?? 59 EB E9 B0 01 5D C3 }
	condition:
		$1
}

rule file_109_16_0 {
	meta:
		name = "___scrt_initialize_onexit_tables"
		size = 151
		refs = "0014 ___scrt_is_ucrt_dll_in_use 0021 ?module_local_atexit_table@@3U_onexit_table_t@@A 0026 __initialize_onexit_table 0034 ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 0047 ___security_cookie 0092 ___scrt_fastfail"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 8B 75 08 85 F6 74 05 83 FE 01 75 7C E8 ?? ?? ?? ?? 85 C0 74 2A 85 F6 75 26 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 74 04 32 C0 EB 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? F7 D8 59 1A C0 FE C0 EB 44 A1 ?? ?? ?? ?? 8D 75 F4 57 83 E0 1F BF ?? ?? ?? ?? 6A 20 59 2B C8 83 C8 FF D3 C8 33 05 ?? ?? ?? ?? 89 45 F4 89 45 F8 89 45 FC A5 A5 A5 BF ?? ?? ?? ?? 89 45 F4 89 45 F8 8D 75 F4 89 45 FC B0 01 A5 A5 A5 5F 5E 8B E5 5D C3 6A 05 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_109_17_0 {
	meta:
		name = "___scrt_is_nonwritable_in_current_image"
		size = 138
		refs = "0003 __sehtable$___scrt_is_nonwritable_in_current_image 0008 __SEH_prolog4 0018 ___ImageBase 004a ?find_pe_section@@YAPAU_IMAGE_SECTION_HEADER@@QAEI@Z 0085 __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 75 5D A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 4C B9 0B 01 00 00 66 39 88 ?? ?? ?? ?? 75 3E 8B 45 08 B9 ?? ?? ?? ?? 2B C1 50 51 E8 ?? ?? ?? ?? 59 59 85 C0 74 27 83 78 24 00 7C 21 C7 45 FC FE FF FF FF B0 01 EB 1F 8B 45 EC 8B 00 33 C9 81 38 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 C7 45 FC FE FF FF FF 32 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_109_18_0 {
	meta:
		name = "___scrt_release_startup_lock"
		size = 29
		refs = "0004 ___scrt_is_ucrt_dll_in_use 0015 ___scrt_native_startup_lock"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 85 C0 74 0F 80 7D 08 00 75 09 33 C0 B9 ?? ?? ?? ?? 87 01 5D C3 }
	condition:
		$1
}

rule file_109_19_0 {
	meta:
		name = "___scrt_uninitialize_crt"
		size = 40
		refs = "0005 ?is_initialized_as_dll@@3_NA 0016 ___acrt_uninitialize 001e ___vcrt_uninitialize"
	strings:
		$1 = { 55 8B EC 80 3D ?? ?? ?? ?? 00 74 06 80 7D 0C 00 75 12 FF 75 08 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 59 B0 01 5D C3 }
	condition:
		$1
}

rule file_109_20_0 {
	meta:
		name = "__onexit"
		size = 59
		refs = "0004 ___security_cookie 000c ?module_local_atexit_table@@3U_onexit_table_t@@A 001e __crt_atexit 002a __register_onexit_function"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8B C8 33 05 ?? ?? ?? ?? 83 E1 1F FF 75 08 D3 C8 83 F8 FF 75 07 E8 ?? ?? ?? ?? EB 0B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 F7 D8 59 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_109_21_0 {
	meta:
		name = "_at_quick_exit"
		size = 49
		refs = "0004 ___security_cookie 000c ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 001c __crt_at_quick_exit 0029 __register_onexit_function"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8B C8 33 05 ?? ?? ?? ?? 83 E1 1F D3 C8 83 F8 FF 75 06 5D E9 ?? ?? ?? ?? FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_109_22_0 {
	meta:
		name = "_atexit"
		size = 21
		refs = "0007 __onexit"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? F7 D8 59 1B C0 F7 D8 48 5D C3 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "___sse2_logf4"
		size = 272
		refs = "0014 _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 60 83 E4 F0 89 44 24 24 66 0F 6F E0 66 0F 6F 15 ?? ?? ?? ?? 0F 28 F0 66 0F 6F 0D ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F DB 25 ?? ?? ?? ?? 66 0F 66 D8 66 0F FE D4 66 0F DB 15 ?? ?? ?? ?? 66 0F EF CA 66 0F 72 E2 17 66 0F EB E1 66 0F 6F C8 66 0F 72 E1 17 66 0F 66 05 ?? ?? ?? ?? 66 0F FA 0D ?? ?? ?? ?? 66 0F DB D8 66 0F 6F C1 66 0F FE C2 0F 28 D4 0F 28 0D ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 0F 58 CA 0F 28 25 ?? ?? ?? ?? 0F 28 EA 0F 5E D1 0F 5B C0 0F 28 CA 0F 59 D2 0F 28 FA 0F 59 D2 0F 59 DA 0F 59 E2 0F 58 1D ?? ?? ?? ?? 0F 59 DF 0F 58 DC 0F 59 05 ?? ?? ?? ?? 0F 28 D5 0F 5C EB 0F 59 E9 0F 5C EA 0F 5C C5 81 FA FF FF 00 00 75 02 EB 1E BA 0C 00 00 00 0F 29 34 24 D9 ED D9 04 14 D9 F1 D9 1C 14 83 EA 04 79 F1 0F 28 04 24 EB E0 8B 64 24 24 C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "___security_init_cookie"
		size = 156
		refs = "000f ___security_cookie 002a ___security_cookie_complement 0036 __imp__GetSystemTimeAsFileTime@4 0045 __imp__GetCurrentThreadId@0 004e __imp__GetCurrentProcessId@0 005b __imp__QueryPerformanceCounter@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 83 65 F4 00 83 65 F8 00 A1 ?? ?? ?? ?? 56 57 BF 4E E6 40 BB BE 00 00 FF FF 3B C7 74 0D 85 C6 74 09 F7 D0 A3 ?? ?? ?? ?? EB 66 8D 45 F4 50 FF 15 ?? ?? ?? ?? 8B 45 F8 33 45 F4 89 45 FC FF 15 ?? ?? ?? ?? 31 45 FC FF 15 ?? ?? ?? ?? 31 45 FC 8D 45 EC 50 FF 15 ?? ?? ?? ?? 8B 4D F0 8D 45 FC 33 4D EC 33 4D FC 33 C8 3B CF 75 07 B9 4F E6 40 BB EB 10 85 CE 75 0C 8B C1 0D 11 47 00 00 C1 E0 10 0B C8 89 0D ?? ?? ?? ?? F7 D1 89 0D ?? ?? ?? ?? 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "___sse2_tanf4"
		size = 512
		refs = "0019 _static_const_table 0131 ___common_pi04_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 C8 0F 28 F0 66 0F DB 05 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 0F 28 D0 0F 28 F8 0F 59 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 0F 50 C7 0B C0 0F 85 BB 00 00 00 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 28 D8 0F 5C 05 ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 66 0F 6F C3 66 0F 72 F0 1F 0F 57 C1 0F 5C D4 0F 28 25 ?? ?? ?? ?? 0F 5C D5 0F 28 2D ?? ?? ?? ?? 0F 5C D6 0F 5C D7 66 0F 72 F3 1E 0F 57 C9 0F C2 D9 04 0F 28 CA 0F 59 D2 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 0F 54 CC 0F 55 D5 0F 56 CA 0F 28 F3 0F 28 FB 0F 55 F4 0F 54 FD 0F 56 F7 0F 5E F1 0F 57 C6 E9 EC 00 00 00 66 0F 6F CE 66 0F DB 35 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? F3 0F 7F 34 24 F3 0F 7F 4C 24 30 D9 04 24 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 10 89 44 24 20 D9 44 24 04 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 14 89 44 24 24 D9 44 24 08 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 18 89 44 24 28 D9 44 24 0C 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 1C 89 44 24 2C 0F 10 54 24 10 0F 10 5C 24 20 0F 28 C3 66 0F 72 F0 1F 0F 57 44 24 30 66 0F 72 F3 1E 0F 57 C9 0F C2 D9 04 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? E9 C4 FE FF FF 8B 64 24 54 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "___sse2_log2"
		size = 464
		refs = "005a _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 34 89 1C 24 89 4C 24 04 66 0F 28 F8 66 0F 28 F0 66 0F 73 D7 20 66 0F 7E F8 8B C8 0F C6 FF 02 66 0F 7E FA 8B DA C1 E8 09 25 F0 07 00 00 83 C0 10 25 E0 0F 00 00 C1 EA 09 81 E2 F0 07 00 00 83 C2 10 81 E2 E0 0F 00 00 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F EB 05 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D 66 0F 72 D1 14 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F 54 D8 66 0F 5C C3 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 0F 7E A0 ?? ?? ?? ?? 66 0F 16 A2 ?? ?? ?? ?? 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 D0 00 00 00 81 EB 00 00 10 00 81 FB 00 00 E0 7F 0F 83 BE 00 00 00 66 0F 59 DC 66 0F 59 C4 66 0F 28 B8 ?? ?? ?? ?? 66 0F 28 EF 66 0F 28 B2 ?? ?? ?? ?? 66 0F 14 FE 66 0F 15 EE 66 0F 58 FA 66 0F 28 E7 66 0F C2 25 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F 54 E0 66 0F 58 FB 66 0F 58 FC 66 0F 55 E0 66 0F 58 C3 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 C8 66 0F 59 C0 66 0F 59 F0 66 0F 59 D0 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 D0 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 59 F1 66 0F 58 F2 66 0F 59 C6 66 0F 58 C5 66 0F 58 C4 66 0F 58 C7 8B 4C 24 04 8B 1C 24 EB 2B 66 0F 29 74 24 10 D9 ED DD 44 24 10 D9 F1 8B 4C 24 04 DD 5C 24 10 D9 ED DD 44 24 18 D9 F1 8B 1C 24 DD 5C 24 18 66 0F 28 44 24 10 8B 64 24 34 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "___common_ssin_cout_rare"
		size = 96
		altNames = "___common_scos_cout_rare"
	strings:
		$1 = { 56 8B 54 24 08 8B 02 0F B7 4A 02 89 04 24 81 E1 80 7F 00 00 C1 E8 18 83 E0 7F F3 0F 10 0A 81 F9 80 7F 00 00 75 30 88 44 24 03 8B 54 24 0C 81 3C 24 00 00 80 7F 75 13 B8 01 00 00 00 66 0F EF C0 F3 0F 59 C8 F3 0F 11 0A 59 C3 F3 0F 59 C9 33 C0 F3 0F 11 0A 59 C3 33 C0 59 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "___dyn_tls_init@12"
		size = 98
		refs = "0003 __sehtable$___dyn_tls_init@12 0008 __SEH_prolog4 0017 ___xd_a 0020 ___xd_z 002f @_guard_check_icall@4 0042 __SEH_epilog4 0051 _dyntls_init_exception_filter 005d _terminate"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D 0C 02 75 2F 83 65 FC 00 BE ?? ?? ?? ?? 89 75 E4 81 FE ?? ?? ?? ?? 74 14 8B 3E 85 FF 74 09 8B CF E8 ?? ?? ?? ?? FF D7 83 C6 04 EB E1 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C2 0C 00 8B 45 EC 8B 00 FF 30 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 65 E8 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "_dyntls_init_exception_filter"
		size = 17
	strings:
		$1 = { 55 8B EC 33 C0 81 7D 08 63 73 6D E0 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "___avx_log104"
		size = 416
		refs = "0010 ___common_dlog10_data 0197 ___common_dlog10_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 54 0D ?? ?? ?? ?? C5 F5 56 25 ?? ?? ?? ?? C5 FD 5A F4 C5 F8 53 FE C5 FC 5A D7 C5 D1 73 D0 14 C4 E3 7D 19 C3 01 C5 F1 73 D3 14 C5 FD C2 3D ?? ?? ?? ?? 11 C5 D0 C6 F1 DD C5 FD C2 0D ?? ?? ?? ?? 16 C4 E3 7D 09 EA 00 C5 FE E6 DE C5 C5 56 D1 C5 DD 54 35 ?? ?? ?? ?? C5 DD 5C E6 C5 DD 59 E5 C4 E3 7D 19 D7 01 C5 E8 C6 CF DD C5 CD 59 FD C5 F8 50 C1 C5 C5 5C 15 ?? ?? ?? ?? C5 ED 58 CC C5 E9 73 D5 28 C5 F9 7E D2 C4 E3 79 16 D1 02 C4 E3 7D 19 EE 01 C5 C1 73 D6 28 C5 FB 10 A2 ?? ?? ?? ?? C5 F9 7E FA C5 D9 16 B1 ?? ?? ?? ?? C5 D5 C2 2D ?? ?? ?? ?? 1E C5 FB 10 92 ?? ?? ?? ?? C4 E3 79 16 F9 02 C5 E9 16 B9 ?? ?? ?? ?? C4 E3 4D 18 D7 01 C5 D5 54 3D ?? ?? ?? ?? C5 C5 56 2D ?? ?? ?? ?? C5 E5 5C DD C5 F5 59 2D ?? ?? ?? ?? C5 E5 59 3D ?? ?? ?? ?? C5 F5 59 1D ?? ?? ?? ?? C5 D5 58 25 ?? ?? ?? ?? C5 F5 59 E9 C5 E5 58 35 ?? ?? ?? ?? C5 F5 59 1D ?? ?? ?? ?? C5 CD 59 CD C5 F5 58 CC C5 F5 59 E5 C5 DD 58 DB C5 E5 58 D2 C5 ED 58 CF 85 C0 75 08 C5 FD 28 C1 8B E5 5D C3 C5 FD 11 44 24 40 C5 FD 11 8C 24 80 00 00 00 74 E7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 8C 24 80 00 00 00 EB BD C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "__EH_epilog3"
		size = 21
	strings:
		$1 = { 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5F 5E 5B 8B E5 5D 51 F2 C3 }
	condition:
		$1
}

rule file_142_1_0 {
	meta:
		name = "__EH_epilog3_GS"
		size = 17
		refs = "0007 @__security_check_cookie@4 000d __EH_epilog3"
	strings:
		$1 = { 8B 4D F0 33 CD F2 E8 ?? ?? ?? ?? F2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_2_0 {
	meta:
		name = "__EH_epilog3_catch_GS"
		size = 17
		refs = "0007 @__security_check_cookie@4 000d __EH_epilog3"
	strings:
		$1 = { 8B 4D EC 33 CD F2 E8 ?? ?? ?? ?? F2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_3_0 {
	meta:
		name = "__EH_prolog3"
		size = 52
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_142_4_0 {
	meta:
		name = "__EH_prolog3_GS"
		size = 55
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_142_5_0 {
	meta:
		name = "__EH_prolog3_catch"
		size = 55
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_142_6_0 {
	meta:
		name = "__EH_prolog3_catch_GS"
		size = 58
		refs = "0018 ___security_cookie"
	strings:
		$1 = { 50 64 FF 35 00 00 00 00 8D 44 24 0C 2B 64 24 0C 53 56 57 89 28 8B E8 A1 ?? ?? ?? ?? 33 C5 50 89 45 EC 89 65 F0 FF 75 FC C7 45 FC FF FF FF FF 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "??0bad_alloc@std@@AAE@QBD@Z"
		size = 29
		refs = "0015 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 83 61 04 00 83 61 08 00 8B 45 08 89 41 04 8B C1 C7 01 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_38_1_3 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "??0bad_array_new_length@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_56_97_1 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_101_50_1 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_106_2_1 {
	meta:
		name = "??0bad_function_call@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_38_5_3 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_78_83_2 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 27
		refs = "000a ??0_System_error@std@@QAE@ABV01@@Z 0010 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_83_8_2 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_83_10_2 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_25_5_1 {
	meta:
		name = "??0logic_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_83_14_2 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_106_16_1 {
	meta:
		name = "??0overflow_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_102_1 {
	meta:
		name = "??0runtime_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0exception@std@@QAE@ABV01@@Z 0010 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_69_118_1 {
	meta:
		name = "??0system_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000a ??0_System_error@std@@QAE@ABV01@@Z 0010 ??_7system_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_144_2_0 {
	meta:
		name = "??0bad_alloc@std@@QAE@XZ"
		size = 24
		refs = "000d ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0013 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 83 61 04 00 8B C1 83 61 08 00 C7 41 04 ?? ?? ?? ?? C7 01 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_97_4_6 {
	meta:
		name = "??0bad_array_new_length@std@@QAE@XZ"
		size = 24
		refs = "000d ??_C@_0BF@KINCDENJ@bad?5array?5new?5length?$AA@ 0013 ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 83 61 04 00 8B C1 83 61 08 00 C7 41 04 ?? ?? ?? ?? C7 01 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_120_73_2 {
	meta:
		name = "??0bad_cast@std@@QAE@XZ"
		size = 24
		refs = "000d ??_C@_08EPJLHIJG@bad?5cast?$AA@ 0013 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 83 61 04 00 8B C1 83 61 08 00 C7 41 04 ?? ?? ?? ?? C7 01 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_77_51_2 {
	meta:
		name = "??0bad_exception@std@@QAE@XZ"
		size = 24
		refs = "000d ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 0013 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 83 61 04 00 8B C1 83 61 08 00 C7 41 04 ?? ?? ?? ?? C7 01 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "??0exception@std@@QAE@ABV01@@Z"
		size = 44
		refs = "000b ??_7exception@std@@6B@ 001f ___std_exception_copy"
	strings:
		$1 = { 55 8B EC 56 8B F1 8D 46 04 C7 06 ?? ?? ?? ?? 83 20 00 83 60 04 00 50 8B 45 08 83 C0 04 50 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_144_6_0 {
	meta:
		name = "??0exception@std@@QAE@QBDH@Z"
		size = 29
		refs = "0008 ??_7exception@std@@6B@"
	strings:
		$1 = { 55 8B EC 8B 45 08 C7 01 ?? ?? ?? ?? 83 61 04 00 83 61 08 00 89 41 04 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_144_7_0 {
	meta:
		name = "??1bad_alloc@std@@UAE@XZ"
		size = 17
		refs = "0005 ??_7exception@std@@6B@ 000b ___std_exception_destroy"
		altNames = "??1_System_error@std@@UAE@XZ ??1__non_rtti_object@std@@UAE@XZ ??1bad_array_new_length@std@@UAE@XZ ??1bad_cast@std@@UAE@XZ ??1bad_exception@std@@UAE@XZ ??1bad_function_call@std@@UAE@XZ ??1bad_typeid@std@@UAE@XZ ??1exception@std@@UAE@XZ ??1failure@ios_base@std@@UAE@XZ ??1future_error@std@@UAE@XZ ??1invalid_argument@std@@UAE@XZ ??1length_error@std@@UAE@XZ ??1logic_error@std@@UAE@XZ ??1out_of_range@std@@UAE@XZ ??1overflow_error@std@@UAE@XZ ??1regex_error@std@@UAE@XZ ??1runtime_error@std@@UAE@XZ ??1system_error@std@@UAE@XZ"
	strings:
		$1 = { 8D 41 04 C7 01 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_144_10_0 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 45
		refs = "000b ??_7exception@std@@6B@ 0011 ___std_exception_destroy 0020 ??3@YAXPAXI@Z"
		altNames = "??_G__non_rtti_object@std@@UAEPAXI@Z ??_Gbad_array_new_length@std@@UAEPAXI@Z ??_Gbad_cast@std@@UAEPAXI@Z ??_Gbad_exception@std@@UAEPAXI@Z ??_Gbad_function_call@std@@UAEPAXI@Z ??_Gbad_typeid@std@@UAEPAXI@Z ??_Gexception@std@@UAEPAXI@Z ??_Ginvalid_argument@std@@UAEPAXI@Z ??_Glength_error@std@@UAEPAXI@Z ??_Glogic_error@std@@UAEPAXI@Z ??_Gout_of_range@std@@UAEPAXI@Z ??_Goverflow_error@std@@UAEPAXI@Z ??_Gruntime_error@std@@UAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 8D 46 04 C7 06 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? F6 45 08 01 59 74 0A 6A 0C 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_144_13_0 {
	meta:
		name = "?__scrt_throw_std_bad_alloc@@YAXXZ"
		size = 29
		refs = "000a ??0bad_alloc@std@@QAE@XZ 000f __TI2?AVbad_alloc@std@@ 0018 __CxxThrowException@8"
		altNames = "?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_106_44_1 {
	meta:
		name = "?_Xbad_function_call@std@@YAXXZ"
		size = 29
		refs = "000a ??0bad_function_call@std@@QAE@XZ 000f __TI2?AVbad_function_call@std@@ 0018 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_144_14_0 {
	meta:
		name = "?__scrt_throw_std_bad_array_new_length@@YAXXZ"
		size = 29
		refs = "000a ??0bad_array_new_length@std@@QAE@XZ 000f __TI3?AVbad_array_new_length@std@@ 0018 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "___sse2_sinhf4"
		size = 320
		refs = "0012 ___common_ssinh_data 0130 ___common_ssinh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 F0 0F 28 05 ?? ?? ?? ?? 0F 54 C6 0F 28 D8 0F 28 25 ?? ?? ?? ?? 66 0F EF DE 0F 59 E3 0F 28 FB 0F 28 2D ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 0F 58 E5 0F 50 D7 0F 28 FC 66 0F 72 F4 17 0F 29 34 24 85 D2 0F 28 35 ?? ?? ?? ?? 0F 5C FD 0F 28 2D ?? ?? ?? ?? 0F 59 EF 0F 59 F7 0F 5C DD 66 0F 6F 15 ?? ?? ?? ?? 0F 5C DE 0F 28 EB 66 0F 6F F2 0F 59 EB 66 0F FE F4 66 0F FA D4 66 0F 6F E6 0F 28 0D ?? ?? ?? ?? 0F 58 E2 0F 59 CD 0F 5C F2 0F 28 15 ?? ?? ?? ?? 0F 59 D5 0F 58 0D ?? ?? ?? ?? 0F 59 CD 0F 58 15 ?? ?? ?? ?? 0F 59 D5 0F 59 CB 0F 58 15 ?? ?? ?? ?? 0F 58 CB 0F 59 D5 0F 59 E1 0F 59 D6 0F 58 E2 0F 58 E6 0F 56 C4 75 04 8B E5 5D C3 0F 28 0C 24 0F 29 4C 24 40 0F 29 84 24 80 00 00 00 74 E9 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 84 24 80 00 00 00 EB B8 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "___avx_acosf8"
		size = 368
		refs = "0010 ___common_sacos_data 015f ___common_sacos_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 1D ?? ?? ?? ?? C5 FC 10 2D ?? ?? ?? ?? C5 E4 56 E0 C5 DC 59 FD C5 DC 59 F4 C5 C4 58 D5 C5 E4 54 C8 C5 DC C2 1D ?? ?? ?? ?? 12 C5 FC 11 0C 24 C5 CC 5D CA C5 C9 EF F6 C4 E3 7D 19 DF 01 C5 E1 6B EF C5 FC 52 FA C5 D1 63 DE C5 F9 D7 D3 C5 F4 C2 DA 15 C5 EC 58 D2 C5 C4 59 EF C5 EC 59 F7 C5 EC 59 D5 C5 EC 5C 2D ?? ?? ?? ?? C5 D4 59 3D ?? ?? ?? ?? C5 C4 58 15 ?? ?? ?? ?? C5 CC 59 FD C5 EC 59 EF C5 CC 5C D5 C5 F4 59 35 ?? ?? ?? ?? C4 E3 5D 4A E2 30 C5 CC 58 2D ?? ?? ?? ?? C5 F4 59 35 ?? ?? ?? ?? C5 CC 58 3D ?? ?? ?? ?? C5 F4 59 F1 C5 D4 59 EE C5 D4 58 FF C5 C4 59 E9 C5 D4 58 35 ?? ?? ?? ?? C5 FC C2 E9 11 C5 CC 59 F1 C5 E4 54 0D ?? ?? ?? ?? C5 F4 54 FD C5 E4 55 0D ?? ?? ?? ?? C5 F4 58 EF C5 DC 57 0C 24 C5 CC 59 F1 C5 CC 58 D1 C5 D4 58 CA 84 D2 75 08 C5 FC 28 C1 8B E5 5D C3 C5 FC 11 44 24 40 C5 FC 11 8C 24 80 00 00 00 85 D2 74 E5 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 8C 24 80 00 00 00 EB BB C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_153_0_0 {
	meta:
		name = "___common_dtanh_cout_rare"
		size = 128
		refs = "001a __imldTanhHATab"
	strings:
		$1 = { 8B 54 24 04 8B 44 24 08 0F B6 4A 07 81 E1 80 00 00 00 C1 E9 07 F2 0F 10 04 CD ?? ?? ?? ?? 0F B7 4A 06 81 E1 F0 7F 00 00 C1 E9 04 81 F9 FF 07 00 00 74 29 81 F9 FE 07 00 00 75 06 F2 0F 11 00 EB 18 F2 0F 10 0A F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 59 C8 F2 0F 11 08 33 C0 C3 F7 42 04 FF FF 0F 00 75 0B 83 3A 00 75 06 F2 0F 11 00 EB E9 F2 0F 10 02 F2 0F 58 C0 F2 0F 11 00 EB DB 8B FF }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "__aullrem"
		size = 117
	strings:
		$1 = { 53 8B 44 24 14 0B C0 75 18 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B 44 24 08 F7 F1 8B C2 33 D2 EB 50 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B C8 F7 64 24 14 91 F7 64 24 10 03 D1 72 0E 3B 54 24 0C 77 08 72 0E 3B 44 24 08 76 08 2B 44 24 10 1B 54 24 14 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 5B C2 10 00 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "___common_ssinh_cout_rare"
		size = 1920
		refs = "0011 __vmldSinhHATab 00ff _2il0floatpacket_89"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 7C 8B 4D 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 51 02 81 E2 80 7F 00 00 F3 0F 10 19 81 FA 80 7F 00 00 0F 84 28 07 00 00 F3 0F 5A DB F2 0F 11 5C 24 70 0F B7 54 24 76 81 E2 F0 7F 00 00 F2 0F 11 5C 24 10 C1 EA 04 80 64 24 17 7F 85 D2 0F 8E C2 06 00 00 81 FA C9 03 00 00 0F 8E 8D 06 00 00 F2 0F 10 44 24 10 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 51 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 F1 04 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 71 04 00 00 F2 0F 10 3D ?? ?? ?? ?? 25 0F 80 FF FF F2 0F 59 F8 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 54 24 68 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 7C 24 50 F2 0F 10 64 24 50 8B 4C 24 50 8B D1 C1 EA 06 83 E1 3F 81 C2 FF 03 00 00 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 CC 81 E2 FF 07 00 00 0F 57 25 ?? ?? ?? ?? 8D 72 FF F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C C1 0F 28 D0 0F 28 D8 C1 E1 04 81 E6 FF 07 00 00 F7 DA F2 0F 58 D4 F2 0F 11 54 24 60 83 C2 FC F2 0F 10 6C 24 60 81 E2 FF 07 00 00 C1 E6 04 F2 0F 5C DD F2 0F 11 1C 24 0B C6 F2 0F 10 6C 24 60 F2 0F 10 34 24 66 89 44 24 6E 25 0F 80 FF FF C1 E2 04 F2 0F 58 EE F2 0F 11 6C 24 08 0B C2 F2 0F 10 3C 24 F2 0F 58 E7 F2 0F 11 24 24 F2 0F 10 64 24 08 F2 0F 5C C4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 34 24 F2 0F 10 44 24 08 F2 0F 58 F0 F2 0F 11 74 24 08 F2 0F 10 74 24 60 0F 28 FE F2 0F 59 FC F2 0F 10 6C 24 08 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 11 74 24 10 F2 0F 5C CE F2 0F 11 0C 24 F2 0F 10 54 24 60 F2 0F 10 04 24 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C D0 F2 0F 11 54 24 60 0F 28 D6 F2 0F 59 D6 F2 0F 59 CA F2 0F 11 6C 24 18 0F 28 EE F2 0F 10 5C 24 60 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C EB F2 0F 59 CA F2 0F 59 CE F2 0F 10 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 11 2C 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 F2 0F 11 44 24 28 F2 0F 10 81 ?? ?? ?? ?? F2 0F 10 5C 24 68 66 89 44 24 6E F2 0F 11 4C 24 30 F2 0F 59 C3 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 0F 28 E8 F2 0F 11 7C 24 20 0F B6 44 24 77 83 E0 80 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 10 91 ?? ?? ?? ?? F7 D9 F2 0F 11 74 24 38 F2 0F 10 74 24 68 F2 0F 59 D3 F2 0F 10 89 ?? ?? ?? ?? F2 0F 59 CE F2 0F 10 99 ?? ?? ?? ?? F2 0F 5C E9 F2 0F 59 DE F2 0F 11 6C 24 60 0F 28 F0 F2 0F 10 7C 24 60 F2 0F 5C F7 F2 0F 5C F1 F2 0F 11 34 24 F2 0F 10 74 24 60 F2 0F 10 2C 24 0F 28 FE F2 0F 5C EB F2 0F 58 EA F2 0F 58 D3 F2 0F 58 FD F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C F7 0F 28 F8 F2 0F 58 F9 F2 0F 58 F5 F2 0F 11 34 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C C7 F2 0F 58 C1 F2 0F 11 04 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 0F 28 CF F2 0F 58 D0 F2 0F 58 CA F2 0F 11 4C 24 60 F2 0F 10 5C 24 60 F2 0F 5C FB F2 0F 58 FA F2 0F 11 3C 24 F2 0F 10 7C 24 60 F2 0F 59 E7 0F 28 DF F2 0F 10 0C 24 F2 0F 11 64 24 60 F2 0F 10 64 24 60 F2 0F 5C E7 F2 0F 11 24 24 F2 0F 10 44 24 60 F2 0F 10 24 24 F2 0F 5C C4 F2 0F 11 44 24 60 F2 0F 10 54 24 60 F2 0F 5C DA F2 0F 11 1C 24 F2 0F 10 64 24 60 F2 0F 10 04 24 F2 0F 11 44 24 48 F2 0F 10 5C 24 18 F2 0F 10 44 24 30 0F 28 D3 F2 0F 11 64 24 40 0F 28 E0 F2 0F 59 D1 F2 0F 59 E1 F2 0F 59 C7 F2 0F 59 DF F2 0F 58 D4 F2 0F 10 64 24 38 0F 28 F8 F2 0F 59 E6 F2 0F 58 D4 F2 0F 10 64 24 10 F2 0F 59 E1 F2 0F 58 D4 F2 0F 10 64 24 38 F2 0F 59 E5 F2 0F 58 D3 F2 0F 58 FC F2 0F 58 F2 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 10 5C 24 48 F2 0F 5C C1 F2 0F 10 4C 24 28 F2 0F 58 C4 F2 0F 11 04 24 0F 28 C1 F2 0F 10 64 24 60 F2 0F 10 14 24 F2 0F 59 C3 F2 0F 58 F2 F2 0F 10 7C 24 20 F2 0F 58 F0 F2 0F 59 DF F2 0F 10 54 24 40 0F 28 C4 F2 0F 59 FA F2 0F 58 F3 F2 0F 59 CA F2 0F 58 C7 F2 0F 58 F1 F2 0F 11 44 24 60 0F 28 C5 F2 0F 10 4C 24 60 F2 0F 5C F9 F2 0F 58 FC F2 0F 11 3C 24 F2 0F 10 4C 24 60 F2 0F 10 3C 24 F2 0F 58 C1 F2 0F 58 F7 F2 0F 11 44 24 60 F2 0F 10 7C 24 60 F2 0F 5C EF F2 0F 58 E9 F2 0F 11 2C 24 F2 0F 10 44 24 60 F2 0F 10 2C 24 F2 0F 58 F5 F2 0F 58 F0 F2 0F 11 74 24 58 0F B6 54 24 5F 83 E2 7F 0B D0 88 54 24 5F F2 0F 5A 74 24 58 8B 45 0C F3 0F 11 30 33 C0 83 C4 7C 5E 8B E5 5D C3 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 0F B6 74 24 77 83 E6 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA 8B 55 0C F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 0B C6 88 44 24 5F 33 C0 F2 0F 5A 44 24 58 F3 0F 11 02 83 C4 7C 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 54 24 68 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 50 F2 0F 10 64 24 50 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 50 8B D1 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 E3 F2 0F 5C C2 C1 E2 04 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 0F 10 82 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 C8 77 21 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 11 4C 24 58 EB 33 49 81 E1 FF 07 00 00 0F B7 44 24 6E C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 0F B6 44 24 5F 0F B6 74 24 77 83 E0 7F 83 E6 80 0B C6 88 44 24 5F 33 C0 F2 0F 5A 44 24 58 8B 55 0C F3 0F 11 02 83 C4 7C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 5A C0 8B 45 0C F3 0F 11 00 B8 03 00 00 00 83 C4 7C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 5A C0 F3 0F 11 00 33 C0 83 C4 7C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 11 5C 24 60 F2 0F 11 54 24 68 F3 0F 5A 11 F2 0F 10 4C 24 60 8B 45 0C F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 10 33 C0 83 C4 7C 5E 8B E5 5D C3 8B 45 0C F3 0F 58 DB F3 0F 11 18 33 C0 83 C4 7C 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "___sse2_cos2"
		size = 416
		refs = "0018 _static_const_table 0155 ___common_cos_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 66 0F 29 04 24 66 0F DB 05 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 D0 66 0F 28 F8 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 5C 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 B3 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 5C D7 66 0F 73 F3 3F 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 D2 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F EF C3 EB 6C 66 0F 28 04 24 66 0F DB 05 ?? ?? ?? ?? 66 0F 29 44 24 30 DD 44 24 30 8D 44 24 20 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 14 33 C0 89 44 24 10 DD 44 24 38 8D 44 24 28 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 1C 33 C0 89 44 24 18 66 0F 28 54 24 20 66 0F 28 5C 24 10 E9 0E FF FF FF 8B 64 24 54 C3 }
	condition:
		$1
}

rule file_159_3_0 {
	meta:
		name = "__ftol3_NaN"
		size = 24
	strings:
		$1 = { 66 0F 7E C0 25 FF FF FF 7F 3D 00 00 80 7F 0F 83 4C 01 00 00 F3 0F 5A C0 }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "__ftol3_work"
		size = 134
		refs = "0009 _MinSubInexact 002b _MinInt64 0050 _MinFP32"
	strings:
		$1 = { 83 F9 02 75 18 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F C2 76 0A BA 10 00 00 00 E8 3D 01 00 00 66 0F 2F C5 0F 83 21 01 00 00 F2 0F 10 35 ?? ?? ?? ?? 66 0F 2F C6 0F 82 0F 01 00 00 66 0F 6F C8 66 0F 73 F1 01 66 0F 73 D1 01 83 F9 01 74 3A F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F CA 77 2C 66 0F 57 D2 66 0F 2F CA 74 22 50 9B D9 3C 24 66 8B 04 24 66 A9 10 00 58 75 12 BA 02 00 00 00 E8 DC 00 00 00 33 C0 BA 00 00 00 80 C3 }
	condition:
		$1
}

rule file_159_5_0 {
	meta:
		name = "__ftol3_common"
		size = 194
		refs = "0012 _MantissaMask 001a _IntegerBit 0022 _i1075"
	strings:
		$1 = { 66 0F 57 F6 66 0F 2F CE 0F 84 A6 00 00 00 F2 0F 10 1D ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 66 0F 6E 2D ?? ?? ?? ?? 66 0F 6F F0 F2 0F C2 F1 00 66 0F 6F D1 66 0F DB D3 66 0F EB D4 66 0F 73 D1 34 66 0F 6F E1 66 0F FB E5 66 0F 6F DA 66 0F F3 DC 66 0F 6F E5 66 0F FB E1 66 0F 6F FA 66 0F D3 FC 66 0F 66 CD 66 0F 62 C9 66 0F DB D9 66 0F DF CF 66 0F EB CB 66 0F EF ED 66 0F FB E9 66 0F DB CE 66 0F DF F5 66 0F EB F1 66 0F 7E E0 83 F8 00 7E 23 66 0F F3 FC 66 0F EF D7 66 0F 7E D0 66 0F 73 DA 04 66 0F 7E D2 0B C2 74 0A BA 10 00 00 00 E8 20 00 00 00 66 0F 7E F0 66 0F 73 DE 04 66 0F 7E F2 C3 }
	condition:
		$1
}

rule file_159_6_0 {
	meta:
		name = "__ftol3_arg_error"
		size = 18
	strings:
		$1 = { BA 08 00 00 00 E8 08 00 00 00 33 C0 BA 00 00 00 80 C3 }
	condition:
		$1
}

rule file_159_7_0 {
	meta:
		name = "__ftol3_except"
		size = 68
		refs = "0012 _FpExcptTable 001a _CWMask 003a __except1"
	strings:
		$1 = { 83 EC 20 9B D9 3C 24 0F B7 04 24 83 FA 08 74 08 84 82 ?? ?? ?? ?? 75 28 D9 2D ?? ?? ?? ?? 89 14 24 C7 44 24 04 00 00 00 00 F2 0F 11 44 24 08 F2 0F 11 44 24 10 89 44 24 18 E8 ?? ?? ?? ?? DD D8 83 C4 20 C3 }
	condition:
		$1
}

rule file_159_11_0 {
	meta:
		name = "__dtol3_NaN"
		size = 29
	strings:
		$1 = { 66 0F 6F C8 66 0F 73 D9 04 66 0F 7E C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 83 62 FF FF FF }
	condition:
		$1
}

rule file_159_12_0 {
	meta:
		name = "__dtol3_work"
		size = 231
		refs = "001b _MaxFP32 0058 _MinFP32 0096 _MaxInt64 00d2 _MinInt64"
	strings:
		$1 = { 83 F9 01 0F 84 11 FE FF FF 66 0F 6F C8 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F CA 76 2F 83 F9 04 74 16 BA 01 00 00 00 E8 40 FF FF FF BA 10 00 00 00 E8 36 FF FF FF EB 14 BA 10 00 00 00 E8 2A FF FF FF BA 01 00 00 00 E8 20 FF FF FF F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F CA 73 27 66 0F 57 D2 66 0F 2F CA 0F 84 30 FE FF FF BA 02 00 00 00 E8 FA FE FF FF BA 10 00 00 00 E8 F0 FE FF FF E9 17 FE FF FF 66 0F 6F D8 83 F9 04 75 12 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F DA 72 04 66 0F 5C DA 66 0F 6F E3 66 0F 73 F4 23 66 0F 73 D4 23 66 0F 7E E0 0B C0 74 0A BA 10 00 00 00 E8 B0 FE FF FF 66 0F 2F C5 0F 83 94 FE FF FF F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F C2 0F 82 82 FE FF FF E9 BB FD FF FF 8B FF }
	condition:
		$1
}

rule file_159_13_0 {
	meta:
		name = "__ultod3"
		size = 64
		refs = "000f _Int32ToUInt32 002e _DP2to32"
	strings:
		$1 = { 0F 57 C0 F2 0F 2A C1 C1 E9 1F F2 0F 58 04 CD ?? ?? ?? ?? 85 D2 74 1F 0F 57 C9 F2 0F 2A CA C1 EA 1F F2 0F 58 0C D5 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 C1 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_159_14_0 {
	meta:
		name = "__ltod3"
		size = 39
		refs = "0015 _DP2to32 001e _Int32ToUInt32"
	strings:
		$1 = { 0F 57 C9 F2 0F 2A CA 0F 57 C0 F2 0F 2A C1 C1 E9 1F F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 04 CD ?? ?? ?? ?? F2 0F 58 C1 C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "___common_satan2_cout_rare"
		size = 4192
		refs = "0104 __vmldAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 6C 8B 45 08 8B 4D 0C F3 0F 10 18 F3 0F 10 11 F3 0F 5A C3 F3 0F 5A CA F2 0F 11 44 24 18 F2 0F 11 4C 24 20 0F B6 78 03 0F B7 40 02 25 80 7F 00 00 0F B6 71 03 0F B7 4C 24 1E 81 E6 80 00 00 00 0F B7 5C 24 26 81 E1 F0 7F 00 00 81 E3 F0 7F 00 00 C1 E8 07 C1 EF 07 C1 EE 07 C1 E9 04 C1 EB 04 3D FF 00 00 00 0F 84 9E 0E 00 00 8B 55 0C 0F B7 52 02 81 E2 80 7F 00 00 81 FA 80 7F 00 00 0F 84 85 0E 00 00 85 C9 75 0F 8B 45 08 F7 00 FF FF 7F 00 0F 84 E2 0D 00 00 85 DB 75 0F 8B 45 0C F7 00 FF FF 7F 00 0F 84 8A 0D 00 00 F7 DB F2 0F 11 44 24 20 03 D9 F2 0F 11 4C 24 28 0F B6 44 24 27 0F B6 54 24 2F 83 E0 7F 83 E2 7F 89 44 24 1C 83 FB CA 89 54 24 18 0F 8E 7C 0C 00 00 83 FB 36 0F 8D 23 0C 00 00 8B C2 85 F6 8B 54 24 1C 88 44 24 2F 88 54 24 27 75 10 F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 54 24 18 EB 16 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 44 24 18 F2 0F 10 5C 24 20 85 C9 F2 0F 10 44 24 28 0F 28 E3 F2 0F 5E E0 0F B7 44 24 26 F2 0F 11 64 24 50 0F 8E AB 0D 00 00 81 F9 FE 07 00 00 7D 1D 25 0F 80 FF FF 81 C1 01 FC FF FF F2 0F 11 5C 24 20 0D F0 3F FF FF 66 89 44 24 26 EB 17 F2 0F 10 0D ?? ?? ?? ?? B9 FE 03 00 00 F2 0F 59 D9 F2 0F 11 5C 24 20 F7 D9 81 C1 FF 03 00 00 81 E1 FF 07 00 00 0F B7 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 25 0F 80 FF FF C1 E1 04 F2 0F 11 4C 24 28 0B C1 66 89 44 24 2E F2 0F 10 5C 24 28 F2 0F 59 C3 66 0F 2F 25 ?? ?? ?? ?? 0F 82 20 07 00 00 F2 0F 10 2D ?? ?? ?? ?? 0F 28 F8 F2 0F 59 FD 0F 28 F0 F2 0F 11 3C 24 F2 0F 11 54 24 48 F2 0F 10 14 24 F2 0F 11 64 24 28 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 64 24 08 F2 0F 11 4C 24 40 F2 0F 5C DC F2 0F 11 1C 24 F2 0F 10 0C 24 8B 4C 24 2C 8B D9 81 E1 00 00 08 00 81 E3 00 00 F0 FF 81 C9 00 00 04 00 F2 0F 5C F1 0B D9 C7 44 24 28 00 00 00 00 89 5C 24 2C F2 0F 11 74 24 08 F2 0F 10 0C 24 F2 0F 10 54 24 28 F2 0F 10 74 24 08 F2 0F 59 CA F2 0F 59 F2 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 F7 0F 28 E1 0F B7 54 24 56 F2 0F 58 E6 F2 0F 11 24 24 81 E2 F0 7F 00 00 F2 0F 10 1C 24 C1 EA 04 F2 0F 5C CB 8B 44 24 54 F2 0F 58 CE F2 0F 11 4C 24 08 25 FF FF 0F 00 F2 0F 10 4C 24 20 F2 0F 10 24 24 0F 28 F9 F2 0F 10 74 24 08 F2 0F 58 FC F2 0F 11 3C 24 0F 28 F9 F2 0F 10 1C 24 C1 E2 14 F2 0F 5C FB F2 0F 11 7C 24 08 0B D0 F2 0F 10 3C 24 81 C2 00 00 40 C0 F2 0F 10 5C 24 08 B8 71 00 00 00 C1 FA 13 F2 0F 58 FB F2 0F 11 7C 24 10 0F 28 F9 F2 0F 10 5C 24 08 83 FA 71 F2 0F 58 E3 F2 0F 11 64 24 08 0F 4C C2 F2 0F 10 64 24 10 C1 E0 04 F2 0F 5C FC F2 0F 11 7C 24 10 F2 0F 10 5C 24 08 F2 0F 10 64 24 10 F2 0F 58 DC F2 0F 11 5C 24 10 F2 0F 10 1C 24 F2 0F 10 64 24 10 F2 0F 58 E6 0F 28 F3 F2 0F 59 F5 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C FB F2 0F 11 7C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 0F 28 F9 F2 0F 10 34 24 F2 0F 59 3D ?? ?? ?? ?? F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 1C 24 F2 0F 10 74 24 08 F2 0F 11 3C 24 F2 0F 58 E6 F2 0F 10 34 24 F2 0F 5C 74 24 20 F2 0F 11 74 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 5C F7 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 59 F2 F2 0F 59 FA 0F 28 D6 F2 0F 58 D7 F2 0F 11 14 24 F2 0F 10 14 24 F2 0F 5C F2 0F 28 D0 F2 0F 58 F7 F2 0F 11 74 24 08 0F 28 F0 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 F1 F2 0F 11 34 24 F2 0F 10 34 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 74 24 08 F2 0F 58 D6 F2 0F 11 54 24 10 F2 0F 10 74 24 08 F2 0F 58 CE F2 0F 11 4C 24 08 F2 0F 10 4C 24 10 F2 0F 5C C1 F2 0F 11 44 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 58 F0 F2 0F 11 74 24 10 F2 0F 10 34 24 F2 0F 10 44 24 10 F2 0F 58 C7 0F 28 FE F2 0F 59 FD F2 0F 11 3C 24 F2 0F 10 14 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 10 54 24 40 F2 0F 5C CF F2 0F 11 0C 24 F2 0F 10 3C 24 F2 0F 5C F7 F2 0F 11 74 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 58 C6 0F 28 F2 F2 0F 5E F7 0F 28 CE F2 0F 59 CD F2 0F 11 4C 24 08 F2 0F 10 4C 24 08 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 74 24 10 F2 0F 59 FE F2 0F 5C D7 F2 0F 10 7C 24 10 F2 0F 59 C7 F2 0F 11 44 24 08 F2 0F 10 44 24 08 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 10 7C 24 10 F2 0F 10 44 24 08 F2 0F 10 74 24 10 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C7 F2 0F 59 C3 F2 0F 59 CE 0F 28 D1 F2 0F 59 D4 F2 0F 59 D9 F2 0F 59 E7 F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 D4 F2 0F 11 14 24 0F 28 E0 F2 0F 10 34 24 F2 0F 58 E6 F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C6 F2 0F 11 44 24 08 F2 0F 10 1C 24 0F 28 D3 0F 28 CB F2 0F 59 D3 F2 0F 59 CD F2 0F 59 FA F2 0F 10 44 24 08 F2 0F 11 0C 24 F2 0F 10 34 24 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C F3 F2 0F 59 FA F2 0F 11 74 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D7 F2 0F 10 3C 24 F2 0F 10 64 24 08 F2 0F 59 EA F2 0F 5C FC F2 0F 11 3C 24 F2 0F 10 34 24 F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 58 C3 F2 0F 10 2C 24 F2 0F 5C EA F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 5C D1 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 0F 28 F2 0F 28 FB F2 0F 59 F8 F2 0F 59 D0 F2 0F 59 DC F2 0F 59 F4 F2 0F 58 FA 0F 28 CE 0F 28 D6 F2 0F 58 FB F2 0F 58 CC F2 0F 11 3C 24 F2 0F 10 3C 24 F2 0F 11 0C 24 F2 0F 10 2C 24 F2 0F 5C D5 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 6C 24 08 F2 0F 10 98 ?? ?? ?? ?? F2 0F 58 E5 F2 0F 11 64 24 08 F2 0F 10 64 24 10 F2 0F 5C F4 F2 0F 11 74 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 58 CE F2 0F 11 4C 24 10 F2 0F 10 34 24 F2 0F 10 54 24 10 0F 28 EE F2 0F 58 DE F2 0F 58 C2 F2 0F 11 1C 24 F2 0F 58 C7 F2 0F 10 24 24 F2 0F 11 44 24 38 F2 0F 5C EC F2 0F 11 6C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 CF F2 0F 11 4C 24 10 F2 0F 10 54 24 08 F2 0F 58 90 ?? ?? ?? ?? F2 0F 11 54 24 08 F2 0F 10 5C 24 10 F2 0F 10 54 24 48 F2 0F 5C F3 F2 0F 11 74 24 10 F2 0F 10 6C 24 08 F2 0F 10 64 24 10 F2 0F 58 EC F2 0F 11 6C 24 10 F2 0F 10 34 24 F2 0F 10 7C 24 10 F2 0F 11 74 24 30 F2 0F 58 C7 0F B6 54 24 37 0F 28 CA 83 E2 7F F2 0F 58 80 ?? ?? ?? ?? 8B C6 C1 E0 07 0B D0 88 54 24 37 F2 0F 11 44 24 38 F2 0F 10 44 24 30 0F 28 E0 F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 1C 24 0F B6 4C 24 3F 8B D9 C1 E9 07 83 E3 7F 33 F1 F2 0F 5C E3 F2 0F 11 64 24 08 F2 0F 10 34 24 F2 0F 10 6C 24 08 C1 E6 07 F2 0F 58 F5 F2 0F 11 74 24 10 0B DE F2 0F 10 7C 24 08 88 5C 24 3F F2 0F 58 D7 F2 0F 11 54 24 08 F2 0F 10 54 24 10 C1 E7 07 F2 0F 5C C2 F2 0F 11 44 24 10 F2 0F 10 4C 24 08 F2 0F 10 44 24 10 8B 75 10 F2 0F 58 C8 F2 0F 11 4C 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 11 64 24 30 F2 0F 58 5C 24 38 F2 0F 58 5C 24 18 F2 0F 11 5C 24 38 F2 0F 58 E3 F2 0F 11 64 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 54 24 60 F3 0F 11 16 E9 F9 05 00 00 F2 0F 10 7C 24 20 8B C6 0F 28 E7 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 11 54 24 48 F2 0F 10 25 ?? ?? ?? ?? C1 E0 07 F2 0F 5C 5C 24 20 F2 0F 11 5C 24 08 F2 0F 10 2C 24 F2 0F 10 54 24 08 C1 E7 07 F2 0F 5C EA F2 0F 11 2C 24 0F 28 E8 F2 0F 10 34 24 F2 0F 59 EC F2 0F 5C FE F2 0F 11 7C 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C F0 F2 0F 11 74 24 08 F2 0F 10 2C 24 F2 0F 10 7C 24 08 F2 0F 5C EF F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C C6 F2 0F 11 44 24 08 0F 28 C1 F2 0F 10 2C 24 F2 0F 5E C5 0F 28 F0 F2 0F 59 F4 F2 0F 10 7C 24 08 F2 0F 11 74 24 08 F2 0F 10 74 24 08 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 44 24 10 F2 0F 59 E8 F2 0F 5C CD F2 0F 10 6C 24 10 F2 0F 59 FD F2 0F 11 7C 24 08 F2 0F 10 7C 24 08 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 6C 24 08 F2 0F 10 74 24 10 F2 0F 10 4C 24 08 0F 28 C6 F2 0F 59 C2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 E9 F2 0F 10 4C 24 10 F2 0F 59 E9 0F 28 FD F2 0F 59 FB F2 0F 59 D5 F2 0F 58 FA 0F 28 D0 F2 0F 58 FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 44 24 50 F2 0F 59 C0 F2 0F 59 C8 F2 0F 10 3C 24 0F 28 EF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EC F2 0F 59 C8 F2 0F 10 54 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C F7 F2 0F 59 C8 F2 0F 11 74 24 08 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 04 24 F2 0F 10 5C 24 08 F2 0F 59 E1 F2 0F 5C C3 F2 0F 11 04 24 F2 0F 10 2C 24 F2 0F 5C FD F2 0F 11 7C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 11 24 24 F2 0F 58 D7 F2 0F 10 24 24 F2 0F 5C E1 F2 0F 11 64 24 08 F2 0F 10 2C 24 F2 0F 10 44 24 08 F2 0F 5C E8 F2 0F 11 2C 24 F2 0F 10 1C 24 F2 0F 5C CB F2 0F 11 4C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 0F 28 E9 0F 28 C7 F2 0F 59 C2 F2 0F 59 CA F2 0F 59 FE F2 0F 59 EE F2 0F 58 C1 0F 28 CD 0F 28 DD F2 0F 58 C7 F2 0F 58 CE F2 0F 11 04 24 F2 0F 10 04 24 F2 0F 11 0C 24 F2 0F 10 24 24 F2 0F 5C DC F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 4C 24 08 F2 0F 58 E1 F2 0F 11 64 24 10 F2 0F 10 7C 24 08 F2 0F 58 F7 F2 0F 11 74 24 08 F2 0F 10 74 24 10 F2 0F 5C EE F2 0F 10 74 24 48 F2 0F 11 6C 24 10 F2 0F 10 5C 24 08 F2 0F 10 4C 24 10 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 24 24 F2 0F 10 6C 24 10 F2 0F 11 64 24 30 F2 0F 58 D5 0F B6 54 24 37 F2 0F 58 D0 83 E2 7F 0B D0 88 54 24 37 F2 0F 11 54 24 38 0F 28 D6 F2 0F 10 4C 24 30 0F 28 C1 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 14 24 0F B6 4C 24 3F 8B D9 C1 E9 07 83 E3 7F 33 F1 F2 0F 5C C2 F2 0F 11 44 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 C1 E6 07 F2 0F 58 E3 F2 0F 11 64 24 10 0B DE F2 0F 10 6C 24 08 88 5C 24 3F F2 0F 58 F5 F2 0F 11 74 24 08 F2 0F 10 7C 24 10 8B 75 10 F2 0F 5C CF F2 0F 11 4C 24 10 F2 0F 10 44 24 08 F2 0F 10 4C 24 10 F2 0F 58 C1 F2 0F 11 44 24 10 F2 0F 10 1C 24 F2 0F 10 54 24 10 F2 0F 11 5C 24 30 F2 0F 58 54 24 38 F2 0F 58 54 24 18 F2 0F 11 54 24 38 F2 0F 58 DA F2 0F 11 5C 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 F3 0F 11 0E E9 DA 01 00 00 83 FB 4A 0F 8D 33 01 00 00 88 44 24 27 F2 0F 5E 4C 24 20 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 5C C1 8B 4D 10 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 54 24 67 83 E2 7F 0B D7 88 54 24 67 F2 0F 5A 4C 24 60 F3 0F 11 09 E9 8A 01 00 00 85 F6 0F 85 4E 01 00 00 8B D0 8B 44 24 18 88 54 24 27 88 44 24 2F F2 0F 10 54 24 20 F2 0F 5E 54 24 28 F2 0F 5A C2 F3 0F 11 44 24 58 0F B7 4C 24 5A F7 C1 80 7F 00 00 F2 0F 11 54 24 60 74 43 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 C2 F2 0F 11 04 24 F2 0F 10 0C 24 F2 0F 59 D1 F2 0F 11 54 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 54 24 60 8B 55 10 F3 0F 11 12 E9 08 01 00 00 F2 0F 5A 44 24 60 F3 0F 11 44 24 58 F3 0F 10 54 24 58 F3 0F 10 4C 24 58 F3 0F 59 D1 F3 0F 11 54 24 58 F3 0F 10 5C 24 58 F3 0F 5A DB C1 E7 07 F2 0F 58 5C 24 60 F2 0F 11 5C 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 64 24 60 8B 55 10 F3 0F 11 22 E9 AD 00 00 00 85 C9 75 0B 8B 45 08 F7 00 FF FF 7F 00 74 36 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A EB 68 85 F6 75 30 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E7 07 F2 0F 11 44 24 60 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A EB 34 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A 33 C0 83 C4 6C 5B 5F 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? B9 02 FC FF FF F2 0F 59 D9 F2 0F 11 5C 24 20 E9 75 F2 FF FF 81 F9 FF 07 00 00 0F 84 31 01 00 00 81 FB FF 07 00 00 0F 84 06 01 00 00 8B 55 0C 0F B7 4A 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 74 39 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A E9 72 FF FF FF 3D FF 00 00 00 74 3B 85 F6 0F 85 2F FF FF FF 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E7 07 F2 0F 11 44 24 60 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A E9 30 FF FF FF 85 F6 75 39 F2 0F 10 05 ?? ?? ?? ?? C1 E7 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 0F B6 44 24 67 83 E0 7F 0B C7 88 44 24 67 F2 0F 5A 4C 24 60 8B 55 10 F3 0F 11 0A E9 F3 FE FF FF F2 0F 10 05 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "___common_sexp_cout_rare"
		size = 608
		refs = "0027 _2il0floatpacket_46 003b _2il0floatpacket_47 0049 _2il0floatpacket_49 0062 _2il0floatpacket_50 006a _2il0floatpacket_53 0082 _2il0floatpacket_54 0098 _2il0floatpacket_51 00a9 _2il0floatpacket_52 00c0 _2il0floatpacket_55 00cf _2il0floatpacket_56 00d6 _2il0floatpacket_58 00e2 _2il0floatpacket_57 0171 _2il0floatpacket_61 01c2 _2il0floatpacket_60 01e3 _2il0floatpacket_59 0208 _2il0floatpacket_48"
	strings:
		$1 = { 83 EC 10 8B 44 24 14 0F B7 50 02 81 E2 80 7F 00 00 81 FA 80 7F 00 00 0F 84 0C 02 00 00 F3 0F 10 00 33 D2 F3 0F 10 0D ?? ?? ?? ?? 89 54 24 0C 0F 2F C8 0F 82 CC 01 00 00 0F 2F 05 ?? ?? ?? ?? 0F 82 9A 01 00 00 F3 0F 10 0D ?? ?? ?? ?? 0F 28 F8 F3 0F 59 C8 F3 0F 11 0C 24 F3 0F 10 14 24 F3 0F 10 1D ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 D3 F3 0F 11 54 24 04 F3 0F 10 64 24 04 F3 0F 10 15 ?? ?? ?? ?? F3 0F 5C E3 F3 0F 11 24 24 F3 0F 10 2C 24 F3 0F 59 2D ?? ?? ?? ?? F3 0F 10 34 24 F3 0F 5C FD F3 0F 59 35 ?? ?? ?? ?? 8B 44 24 04 F3 0F 5C FE F3 0F 59 D7 C1 E0 10 F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D7 C1 F8 10 F3 0F 58 15 ?? ?? ?? ?? 0F 2F 05 ?? ?? ?? ?? F3 0F 59 D7 F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D7 F3 0F 58 D1 F3 0F 59 D7 F3 0F 58 D1 F3 0F 11 54 24 08 0F 82 89 00 00 00 8D 50 7F 81 FA FE 00 00 00 77 2D 0F B6 D2 C1 E2 07 66 89 54 24 0E F3 0F 10 44 24 08 F3 0F 59 44 24 0C 8B 4C 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 01 33 C0 83 C4 10 C3 83 C0 7E 0F B6 C0 0F B7 54 24 0E C1 E0 07 81 E2 7F 80 FF FF 0B D0 F3 0F 10 44 24 08 66 89 54 24 0E F3 0F 59 44 24 0C F3 0F 11 44 24 08 F3 0F 10 4C 24 08 F3 0F 59 0D ?? ?? ?? ?? 8B 44 24 18 F3 0F 11 4C 24 08 8B 4C 24 08 89 08 33 C0 83 C4 10 C3 83 C0 BB 0F B6 C0 0F B7 54 24 0E C1 E0 07 81 E2 7F 80 FF FF 0B D0 F3 0F 10 44 24 08 66 89 54 24 0E F3 0F 59 44 24 0C F3 0F 11 44 24 08 F3 0F 10 4C 24 08 F3 0F 59 0D ?? ?? ?? ?? 8B 44 24 18 F3 0F 11 4C 24 08 8B 4C 24 08 89 08 B8 04 00 00 00 83 C4 10 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 8B 54 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 02 B8 04 00 00 00 83 C4 10 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 8B 54 24 18 F3 0F 11 44 24 08 8B 44 24 08 89 02 B8 03 00 00 00 83 C4 10 C3 0F B6 50 03 F7 C2 80 00 00 00 75 16 F3 0F 10 00 F3 0F 59 C0 8B 44 24 18 F3 0F 11 00 33 C0 83 C4 10 C3 F7 00 FF FF 7F 00 75 E2 8B 54 24 18 33 C0 89 02 83 C4 10 C3 90 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "___sse2_tan2"
		size = 512
		refs = "001c _static_const_table 018c ___common_pi04_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC A0 00 00 00 83 E4 F0 89 44 24 64 66 0F 29 04 24 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 D0 66 0F 28 F8 66 0F 59 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 F0 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF C1 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 5C D7 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 D2 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E1 66 0F 28 CB 66 0F 28 D3 66 0F 54 CC 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 28 FB 66 0F 55 F4 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F EF C6 E9 9B 00 00 00 66 0F 28 04 24 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 66 0F 29 44 24 30 66 0F 29 4C 24 40 DD 44 24 30 8D 44 24 20 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 10 33 C0 89 44 24 14 DD 44 24 38 8D 44 24 28 83 EC 20 DD 1C 24 89 44 24 08 E8 ?? ?? ?? ?? 83 C4 20 89 44 24 18 33 C0 89 44 24 1C 66 0F 28 54 24 20 66 0F 28 5C 24 10 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF 44 24 40 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 E9 CC FE FF FF 8B 64 24 64 C3 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "___common_slog10_cout_rare"
		size = 688
		refs = "0039 _2il0floatpacket_77 0060 _2il0floatpacket_93 0078 _2il0floatpacket_78 0099 _2il0floatpacket_79 00a1 _2il0floatpacket_80 00a9 _2il0floatpacket_82 00e1 _2il0floatpacket_81 010e __vmldLgHATab 0134 _2il0floatpacket_83 0142 _2il0floatpacket_84 0158 _2il0floatpacket_85 0164 _2il0floatpacket_86 0170 _2il0floatpacket_87 017c _2il0floatpacket_88 0188 _2il0floatpacket_89 0194 _2il0floatpacket_90 01a0 _2il0floatpacket_91 025a _2il0floatpacket_92"
	strings:
		$1 = { 83 EC 0C 8B 44 24 10 8B 54 24 14 0F B7 48 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 0F 84 4E 02 00 00 F3 0F 10 08 8B 00 89 44 24 08 C1 E8 10 A9 80 7F 00 00 75 15 F3 0F 59 0D ?? ?? ?? ?? B9 D8 FF FF FF F3 0F 11 4C 24 08 EB 02 33 C9 66 0F EF C0 0F 2F C8 0F 86 E5 01 00 00 0F 28 D1 F3 0F 5C 15 ?? ?? ?? ?? F3 0F 11 54 24 04 80 64 24 07 7F F3 0F 10 44 24 04 0F 2F 05 ?? ?? ?? ?? 0F 86 42 01 00 00 0F B7 44 24 0A 25 80 7F 00 00 C1 E8 07 F3 0F 11 4C 24 04 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? F3 0F 10 3D ?? ?? ?? ?? 8D 4C 01 81 F3 0F 2A D9 0F B7 44 24 06 25 7F 80 FF FF 0D 80 3F FF FF 66 89 44 24 06 F3 0F 59 D3 F3 0F 59 DC F3 0F 10 64 24 04 0F 28 EC 0F 28 F4 F3 0F 58 2D ?? ?? ?? ?? F3 0F 58 F7 F3 0F 11 2C 24 8B 04 24 F3 0F 11 34 24 83 E0 7F F3 0F 10 04 24 F3 0F 5C C7 8D 0C C5 00 00 00 00 F3 0F 10 8C 81 ?? ?? ?? ?? F3 0F 5C E0 F3 0F 58 9C 81 ?? ?? ?? ?? F3 0F 58 94 81 ?? ?? ?? ?? F3 0F 59 C1 F3 0F 59 CC F3 0F 5C 05 ?? ?? ?? ?? 0F 28 E8 0F 28 F1 F3 0F 10 25 ?? ?? ?? ?? 33 C0 F3 0F 58 E9 F3 0F 58 D0 F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 F4 F3 0F 59 C4 F3 0F 58 DE F3 0F 58 CB F3 0F 58 C8 F3 0F 58 D1 F3 0F 11 12 83 C4 0C C3 F3 0F 10 05 ?? ?? ?? ?? 33 C0 F3 0F 59 D0 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 D1 F3 0F 11 12 83 C4 0C C3 0F 2E C8 7A 02 74 11 F3 0F 5E C0 F3 0F 11 02 B8 01 00 00 00 83 C4 0C C3 F3 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 F3 0F 5E C8 F3 0F 11 0A 83 C4 0C C3 0F B6 48 03 F7 C1 80 00 00 00 75 12 F3 0F 10 00 33 C0 F3 0F 59 C0 F3 0F 11 02 83 C4 0C C3 F7 00 FF FF 7F 00 75 E6 B8 01 00 00 00 66 0F EF C9 66 0F EF C0 F3 0F 5E C8 F3 0F 11 0A 83 C4 0C C3 8B FF }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "___sse2_sinf4"
		size = 448
		refs = "001b _static_const_table 00f7 ___common_sin_reduction_LA"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 F0 0F 28 D0 0F 28 F8 0F 28 0D ?? ?? ?? ?? 66 0F DB F9 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 C4 0F 28 25 ?? ?? ?? ?? 66 0F 66 FD 0F 28 2D ?? ?? ?? ?? 0F 50 C7 0B C0 75 7B 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 59 C2 0F 58 C4 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 E9 EA 00 00 00 66 0F 28 CE 66 0F DB 35 ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? 0F 11 34 24 0F 11 4C 24 30 D9 04 24 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 10 89 44 24 20 D9 44 24 04 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 14 89 44 24 24 D9 44 24 08 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 18 89 44 24 28 D9 44 24 0C 83 EC 20 DD 1C 24 8D 44 24 10 89 44 24 08 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 20 D9 5C 24 1C 89 44 24 2C 0F 10 54 24 10 0F 10 5C 24 20 0F 57 5C 24 30 0F 28 05 ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 59 D2 E9 F2 FE FF FF 8B 64 24 54 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_168_2_0 {
	meta:
		name = "___scrt_initialize_default_local_stdio_options"
		size = 29
		refs = "0001 ___local_stdio_printf_options 000f ___local_stdio_scanf_options"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 48 04 83 08 04 89 48 04 E8 ?? ?? ?? ?? 8B 48 04 83 08 02 89 48 04 C3 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "___avx_acos4"
		size = 512
		refs = "0010 ___common_dacos_data 01ea ___common_dacos_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 35 ?? ?? ?? ?? C5 FD 10 25 ?? ?? ?? ?? C5 FD 11 04 24 C5 CD 56 C8 C5 F5 59 FC C5 FD 11 4C 24 20 C5 F5 C2 1D ?? ?? ?? ?? 12 C5 C5 58 E4 C5 CD 54 E8 C5 F5 59 F1 C5 FD 11 6C 24 40 C5 FD 5A CC C5 CD 5D EC C5 D5 C2 F4 15 C5 DD 58 E4 C4 E3 7D 19 DA 01 C5 E0 C6 FA DD C5 F8 52 D9 C5 F8 50 D7 C5 FC 5A D3 C5 ED 59 FA C5 DD 59 CA C5 DD 59 E7 C5 DD 5C 3D ?? ?? ?? ?? C5 C5 59 1D ?? ?? ?? ?? C5 F5 59 E7 C5 E5 58 15 ?? ?? ?? ?? C5 ED 59 DF C5 E5 58 15 ?? ?? ?? ?? C5 ED 59 FF C5 D5 59 15 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 C5 59 E4 C5 D5 59 3D ?? ?? ?? ?? C5 F5 5C CC C5 C5 58 3D ?? ?? ?? ?? C5 D5 59 25 ?? ?? ?? ?? C5 FD 11 4C 24 60 C5 D5 59 0D ?? ?? ?? ?? C5 DD 58 1D ?? ?? ?? ?? C5 D5 59 E5 C5 F5 58 0D ?? ?? ?? ?? C5 C5 59 FC C5 F5 59 CC C5 C5 58 DB C5 F5 58 CA C5 DD 59 D4 C5 D5 59 3D ?? ?? ?? ?? C5 E5 59 DA C5 C5 58 3D ?? ?? ?? ?? C5 E5 58 C9 C5 F5 59 D4 C5 ED 58 DF C5 D5 59 3D ?? ?? ?? ?? C5 FD 10 54 24 20 C5 E5 59 E4 C5 C5 58 3D ?? ?? ?? ?? C5 DD 58 CF C5 F5 59 FD C5 FD C2 ED 11 C5 CD 54 05 ?? ?? ?? ?? C5 FD 54 CD C5 CD 55 05 ?? ?? ?? ?? C4 E3 6D 4B 74 24 60 60 C5 FD 58 E1 C5 CD 57 5C 24 40 C5 C5 59 FB C5 C5 58 EB C5 DD 58 C5 85 D2 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 84 24 80 00 00 00 C5 FD 11 4C 24 40 74 E6 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 80 00 00 00 EB BC C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "___common_dtan_cout_rare"
		size = 128
		refs = "004f __vmldTanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 08 8B 55 08 0F B7 4A 06 F2 0F 10 0A 81 E1 F0 7F 00 00 0F B6 42 07 83 E0 7F F2 0F 11 0C 24 81 F9 F0 7F 00 00 88 44 24 07 74 06 33 C0 8B E5 5D C3 8B 45 0C 83 3C 24 00 75 23 81 7C 24 04 00 00 F0 7F 75 19 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 08 B8 01 00 00 00 8B E5 5D C3 F2 0F 59 C9 F2 0F 11 08 33 C0 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "__SEH_prolog4"
		size = 70
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_178_1_0 {
	meta:
		name = "__SEH_epilog4"
		size = 21
	strings:
		$1 = { 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5F 5E 5B 8B E5 5D 51 F2 C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "___common_satan_cout_rare"
		size = 1520
		refs = "0048 __vmlsAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 53 83 EC 3C 8B 4D 08 0F B7 41 02 25 80 7F 00 00 C1 E8 07 3D FF 00 00 00 0F 84 73 05 00 00 F3 0F 10 09 F3 0F 5A C1 F2 0F 11 44 24 30 80 64 24 37 7F F2 0F 10 44 24 30 0F B6 51 03 C1 EA 07 66 0F 2F 05 ?? ?? ?? ?? 0F 82 1D 04 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 D2 03 00 00 0F B7 44 24 36 0F 28 F8 25 F0 7F 00 00 C1 E8 04 8B 4C 24 34 F2 0F 11 44 24 10 81 E1 FF FF 0F 00 C1 E0 14 8B 5C 24 14 0B C1 8B CB 81 E3 00 00 08 00 81 E1 00 00 F0 FF 81 CB 00 00 04 00 0B CB 05 00 00 40 C0 C7 44 24 10 00 00 00 00 89 4C 24 14 F2 0F 10 0D ?? ?? ?? ?? 0F 28 E1 F2 0F 5C 7C 24 10 F2 0F 59 E7 F2 0F 11 64 24 18 F2 0F 10 54 24 18 C1 F8 0F F2 0F 5C D7 F2 0F 11 54 24 20 83 E0 F0 F2 0F 10 5C 24 18 F2 0F 10 6C 24 20 C1 E2 07 F2 0F 5C DD F2 0F 11 5C 24 18 0F 28 E8 F2 0F 10 74 24 18 F2 0F 59 2D ?? ?? ?? ?? F2 0F 5C FE F2 0F 11 7C 24 20 F2 0F 10 5C 24 18 F2 0F 10 64 24 20 F2 0F 11 6C 24 18 F2 0F 10 74 24 18 F2 0F 5C 74 24 30 F2 0F 11 74 24 20 F2 0F 10 6C 24 18 F2 0F 10 54 24 20 F2 0F 5C EA F2 0F 11 6C 24 18 F2 0F 10 74 24 18 F2 0F 5C C6 F2 0F 11 44 24 20 F2 0F 10 7C 24 18 F2 0F 10 44 24 10 F2 0F 10 54 24 20 F2 0F 59 F8 F2 0F 59 D0 0F 28 EF F2 0F 58 EA F2 0F 11 6C 24 18 F2 0F 10 74 24 18 F2 0F 5C FE F2 0F 58 D7 F2 0F 11 54 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 44 24 18 0F 28 F2 F2 0F 10 6C 24 20 F2 0F 58 F0 F2 0F 11 74 24 18 0F 28 F2 F2 0F 10 7C 24 18 F2 0F 5C F7 F2 0F 11 74 24 20 F2 0F 10 74 24 18 F2 0F 10 7C 24 20 F2 0F 58 F7 F2 0F 11 74 24 28 0F 28 F2 F2 0F 10 7C 24 20 F2 0F 58 C7 F2 0F 11 44 24 20 F2 0F 10 44 24 28 F2 0F 5C F0 F2 0F 11 74 24 28 F2 0F 10 74 24 20 F2 0F 10 7C 24 28 F2 0F 58 F7 F2 0F 11 74 24 28 F2 0F 10 7C 24 18 F2 0F 10 44 24 28 F2 0F 58 C5 0F 28 EF F2 0F 59 E9 F2 0F 11 6C 24 18 F2 0F 10 74 24 18 F2 0F 5C F7 F2 0F 11 74 24 20 F2 0F 10 74 24 18 F2 0F 10 6C 24 20 F2 0F 5C F5 F2 0F 11 74 24 18 F2 0F 10 6C 24 18 F2 0F 5C FD F2 0F 11 7C 24 20 F2 0F 10 74 24 18 F2 0F 10 6C 24 20 F2 0F 58 E8 0F 28 C2 F2 0F 5E C6 F2 0F 59 C8 F2 0F 11 4C 24 20 F2 0F 10 4C 24 20 F2 0F 5C C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 20 F2 0F 10 7C 24 28 F2 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 4C 24 28 F2 0F 59 F1 F2 0F 5C D6 F2 0F 10 74 24 28 F2 0F 59 EE F2 0F 11 6C 24 20 F2 0F 10 6C 24 20 F2 0F 5C D5 F2 0F 11 54 24 20 F2 0F 10 7C 24 20 F2 0F 10 74 24 28 F2 0F 10 54 24 20 F2 0F 10 6C 24 28 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 FD 0F 28 EE F2 0F 59 F4 F2 0F 59 EB F2 0F 59 DF 0F 28 C7 F2 0F 59 C4 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 C6 F2 0F 10 90 ?? ?? ?? ?? F2 0F 58 C3 F2 0F 11 44 24 18 0F 28 DD F2 0F 10 74 24 18 0F 28 C2 F2 0F 58 DE F2 0F 11 5C 24 18 F2 0F 10 64 24 18 F2 0F 5C EC F2 0F 58 EE F2 0F 11 6C 24 20 F2 0F 10 5C 24 18 0F 28 EB F2 0F 58 C3 F2 0F 59 EB F2 0F 59 FD F2 0F 10 74 24 20 F2 0F 11 44 24 18 F2 0F 10 4C 24 18 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C D1 F2 0F 59 FD F2 0F 58 D3 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 11 54 24 20 F2 0F 10 44 24 18 F2 0F 10 64 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 59 DF F2 0F 58 DE F2 0F 58 98 ?? ?? ?? ?? F2 0F 58 DC F2 0F 58 C3 F2 0F 11 44 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 5C 24 08 8B 55 0C F3 0F 11 1A E9 57 01 00 00 F2 0F 10 05 ?? ?? ?? ?? C1 E2 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 4C 24 08 8B 55 0C F3 0F 11 0A E9 1E 01 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 8C 00 00 00 0F 28 C8 F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 C1 E2 07 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 D0 F2 0F 11 54 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 44 24 08 8B 55 0C F3 0F 11 02 E9 84 00 00 00 85 C0 74 44 F2 0F 10 0D ?? ?? ?? ?? C1 E2 07 F2 0F 58 C8 F2 0F 11 4C 24 18 F2 0F 10 44 24 18 F2 0F 59 44 24 30 F2 0F 11 44 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 54 24 08 8B 55 0C F3 0F 11 12 EB 3C F3 0F 59 C9 F3 0F 11 0C 24 F3 0F 10 04 24 F3 0F 5A C0 C1 E2 07 F2 0F 58 44 24 30 F2 0F 11 44 24 08 0F B6 44 24 0F 83 E0 7F 0B C2 88 44 24 0F F2 0F 5A 4C 24 08 8B 55 0C F3 0F 11 0A 33 C0 83 C4 3C 5B 8B E5 5D C3 F7 01 FF FF 7F 00 75 3A F2 0F 10 05 ?? ?? ?? ?? 0F B6 41 03 83 E0 80 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 08 0F B6 54 24 0F 83 E2 7F 0B D0 88 54 24 0F F2 0F 5A 4C 24 08 8B 4D 0C F3 0F 11 09 EB B4 F3 0F 10 01 8B 45 0C F3 0F 58 C0 F3 0F 11 00 EB A3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "___avx_expf8"
		size = 320
		refs = "0010 ___common_sexp_data 0136 ___common_sexp_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 25 ?? ?? ?? ?? C5 FC 59 0D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 F8 10 3D ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 F4 58 F4 C5 CC 5C CC C5 F8 54 E2 C4 E3 7D 19 C5 01 C5 D9 66 E7 C5 D0 54 EA C5 D1 66 FF C5 D9 6B D7 C5 F4 59 3D ?? ?? ?? ?? C5 D9 EF E4 C5 F4 59 0D ?? ?? ?? ?? C5 E9 63 EC C5 F9 D7 D5 C5 C9 FE D3 C4 E3 7D 19 F4 01 C5 C9 72 F2 17 C5 FC 5C D7 C5 D9 FE DB C5 D1 72 F3 17 C5 EC 5C D1 C5 EC 59 0D ?? ?? ?? ?? C5 F4 58 25 ?? ?? ?? ?? C4 E3 4D 18 DD 01 C5 DC 59 EA C5 D4 58 35 ?? ?? ?? ?? C5 CC 59 FA C5 C4 58 0D ?? ?? ?? ?? C5 F4 59 E2 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 D2 C5 EC 58 0D ?? ?? ?? ?? C5 E4 59 C9 84 D2 75 08 C5 FC 28 C1 8B E5 5D C3 C5 FC 11 44 24 40 C5 FC 11 8C 24 80 00 00 00 85 D2 74 E5 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 8C 24 80 00 00 00 EB BB C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 90 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "___dyn_tls_dtor@12"
		size = 126
		refs = "0013 __tls_index 0019 __tls_array 0027 _dtor_list 0049 @_guard_check_icall@4 0064 __free_base"
	strings:
		$1 = { 55 8B EC 51 51 83 7D 0C 03 74 06 83 7D 0C 00 75 67 8B 0D ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 53 56 8B 1C 88 89 5D F8 8B B3 ?? ?? ?? ?? 85 F6 74 47 57 8B 3E 83 EF 01 78 24 8D 5F 02 8D 1C 9E 8B 03 89 45 FC 85 C0 74 0A 8B C8 E8 ?? ?? ?? ?? FF 55 FC 83 EB 04 83 EF 01 79 E5 8B 5D F8 8B 7E 04 85 FF 74 07 56 E8 ?? ?? ?? ?? 59 89 BB ?? ?? ?? ?? 8B F7 85 FF 75 BB 5F 5E 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "??$?RUTlsDtorNode@@@__crt_internal_free_policy@@QBEXQBUTlsDtorNode@@@Z"
		size = 16
		refs = "0007 __free_base"
		altNames = "??$?RD@__crt_internal_free_policy@@QBEXQBD@Z ??$?RU__vcrt_ptd@@@__crt_internal_free_policy@@QBEXQBU__vcrt_ptd@@@Z ??$?RX@__crt_internal_free_policy@@QBEXQBX@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_20_0_3 {
	meta:
		name = "??$?RD@__crt_public_free_policy@@QBEXQBD@Z"
		size = 16
		refs = "0007 _free"
	strings:
		$1 = { 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_187_3_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 16
		refs = "0006 __free_base"
		altNames = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAE@XZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_20_2_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@XZ"
		size = 16
		refs = "0006 _free"
	strings:
		$1 = { 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_20_7_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEXXZ"
		size = 16
		refs = "0006 _free"
	strings:
		$1 = { 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_187_6_0 {
	meta:
		name = "___tlregdtor"
		size = 123
		refs = "0005 __tls_array 000b __tls_index 0016 _dtor_list 0020 _dtor_list_head 003a __malloc_base 0043 __free_base"
	strings:
		$1 = { 55 8B EC 64 A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 56 57 8B 34 88 8B 86 ?? ?? ?? ?? 85 C0 75 11 8D 86 ?? ?? ?? ?? 83 20 00 89 86 ?? ?? ?? ?? EB 35 83 38 1E 75 30 68 80 00 00 00 E8 ?? ?? ?? ?? 6A 00 8B F8 E8 ?? ?? ?? ?? 59 59 85 FF 75 05 83 C8 FF EB 25 8B 86 ?? ?? ?? ?? 83 27 00 89 47 04 89 BE ?? ?? ?? ?? 8B 96 ?? ?? ?? ?? 8B 45 08 8B 0A 89 44 8A 08 FF 02 33 C0 5F 5E 5D C3 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "___common_dasin_cout_rare"
		size = 2544
		refs = "0042 __vmldASinHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 64 8B 55 08 0F B7 42 06 25 F0 7F 00 00 F2 0F 10 12 3D F0 7F 00 00 0F B6 4A 07 0F 84 84 09 00 00 F2 0F 11 54 24 40 83 E1 7F 88 4C 24 47 F2 0F 10 4C 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C1 0F 82 3A 09 00 00 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F D1 0F 86 00 04 00 00 66 0F 2F 0D ?? ?? ?? ?? 0F 86 54 03 00 00 F2 0F 10 15 ?? ?? ?? ?? 0F 28 D9 F2 0F 59 DA 0F 28 F1 F2 0F 11 5C 24 30 F2 0F 10 6C 24 30 F2 0F 11 0C 24 8B 4D 0C F2 0F 5C 6C 24 40 F2 0F 11 6C 24 28 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 F2 0F 11 44 24 30 0F 28 C1 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 74 24 28 F2 0F 10 6C 24 30 0F 28 F5 F2 0F 58 C5 F2 0F 59 F5 F2 0F 10 64 24 28 0F 28 DE F2 0F 59 C4 F2 0F 58 D8 F2 0F 59 FB F2 0F 11 5C 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB 0F 28 DA F2 0F 59 DE F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 11 7C 24 10 F2 0F 10 7C 24 30 F2 0F 5C FE F2 0F 11 7C 24 28 F2 0F 10 7C 24 30 F2 0F 10 5C 24 28 F2 0F 5C FB F2 0F 11 7C 24 30 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 7C 24 28 F2 0F 59 E6 F2 0F 58 C7 F2 0F 59 EE F2 0F 59 C8 F2 0F 58 CC 0F 28 E2 F2 0F 59 E5 F2 0F 11 64 24 30 F2 0F 10 7C 24 30 F2 0F 5C FD F2 0F 11 7C 24 28 F2 0F 10 5C 24 30 F2 0F 10 64 24 28 F2 0F 5C DC 0F 28 E5 F2 0F 58 E9 F2 0F 11 5C 24 30 0F 28 DE F2 0F 10 7C 24 30 F2 0F 59 C5 F2 0F 5C E7 F2 0F 11 64 24 28 F2 0F 10 64 24 30 F2 0F 59 DC F2 0F 59 D3 F2 0F 10 7C 24 28 F2 0F 11 7C 24 18 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 59 F7 F2 0F 5C D3 F2 0F 11 54 24 28 F2 0F 58 F0 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 0F 28 FB F2 0F 58 DE F2 0F 11 44 24 30 F2 0F 10 54 24 30 F2 0F 5C FA F2 0F 11 7C 24 28 F2 0F 10 7C 24 08 F2 0F 59 FB F2 0F 10 44 24 30 F2 0F 10 54 24 28 F2 0F 11 54 24 20 F2 0F 10 54 24 10 F2 0F 59 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 10 1C 24 F2 0F 58 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 FA F2 0F 59 F5 F2 0F 59 C5 F2 0F 59 6C 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 E2 F2 0F 58 F9 F2 0F 10 4C 24 18 F2 0F 59 CA 0F 28 D3 F2 0F 58 D4 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 4C 24 30 F2 0F 5C D9 F2 0F 58 DC F2 0F 11 5C 24 28 F2 0F 10 4C 24 30 F2 0F 10 64 24 28 F2 0F 58 FC F2 0F 58 FE 0F 28 F1 F2 0F 58 F0 F2 0F 58 FD F2 0F 11 74 24 30 F2 0F 10 64 24 30 F2 0F 5C CC F2 0F 58 C8 F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 0F 10 44 24 28 0F B6 52 07 F2 0F 58 F8 83 E2 80 F2 0F 58 F9 F2 0F 11 7C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 33 C0 F2 0F 10 7C 24 38 F2 0F 11 39 83 C4 64 5B 5F 5E 8B E5 5D C3 66 0F 2F 0D ?? ?? ?? ?? 72 4A 8B 4D 0C F2 0F 58 C8 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 F2 0F 59 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 0F B6 52 07 83 E0 7F 83 E2 80 0B C2 88 44 24 3F 33 C0 F2 0F 10 4C 24 38 F2 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 59 C9 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 0F B6 52 07 83 E2 80 F2 0F 58 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 83 E0 7F 8B 4D 0C 0B C2 88 44 24 3F 33 C0 F2 0F 10 4C 24 38 F2 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B C8 81 E1 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C D9 F2 0F 59 D3 F2 0F 11 14 24 0F B7 74 24 06 81 E6 F0 7F 00 00 C1 EE 04 81 C6 01 FC FF FF 8B FE F7 DF 81 C7 FF 03 00 00 81 E7 FF 07 00 00 C1 E7 04 0B CF 66 89 4C 24 0E 8B CE F2 0F 59 54 24 08 83 E1 01 0F 28 EA 8B D9 F2 0F 10 35 ?? ?? ?? ?? F2 0F 58 EA 75 03 0F 28 EA F2 0F 59 F5 F2 0F 58 15 ?? ?? ?? ?? 0F 28 FE 0F 28 E5 F2 0F 11 54 24 10 2B F1 8B 7C 24 10 F2 0F 5C FD C1 E3 08 81 E7 FF 01 00 00 03 FB F2 0F 11 7C 24 28 F2 0F 10 4C 24 28 D1 EE F2 0F 5C F1 F2 0F 10 0C FD ?? ?? ?? ?? 0F 28 D6 0F 28 F9 81 C6 FF 03 00 00 F2 0F 59 F9 F2 0F 5C E6 F2 0F 59 F1 F2 0F 59 D7 F2 0F 59 FC F2 0F 5C D0 81 E6 FF 07 00 00 F2 0F 58 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FA C1 E6 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA 0B C6 F2 0F 11 44 24 18 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 F9 F2 0F 59 CC F2 0F 59 FD F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 F9 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 30 F2 0F 10 64 24 30 F2 0F 5C E6 F2 0F 11 64 24 28 F2 0F 10 44 24 30 F2 0F 10 4C 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C C1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 6C 24 30 F2 0F 58 05 ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 C3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 4C 24 28 F2 0F 11 74 24 40 F2 0F 58 F9 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 F4 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 EE F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 0F 28 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 48 F2 0F 58 E8 0F 28 C2 F2 0F 59 C3 F2 0F 59 FD F2 0F 11 44 24 30 F2 0F 11 7C 24 50 F2 0F 10 7C 24 30 F2 0F 5C FB F2 0F 11 7C 24 28 F2 0F 10 6C 24 30 F2 0F 10 44 24 28 F2 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 11 74 24 28 F2 0F 10 64 24 30 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 28 F2 0F 11 5C 24 30 F2 0F 10 74 24 30 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 5C 24 28 F2 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 5C 24 30 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 28 F2 0F 10 74 24 30 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 28 F2 0F 58 DE F2 0F 11 5C 24 30 F2 0F 11 6C 24 58 F2 0F 10 6C 24 30 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 28 0F 28 E5 F2 0F 10 5C 24 30 F2 0F 10 74 24 28 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 64 24 30 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 28 F2 0F 10 64 24 30 F2 0F 59 D4 F2 0F 10 5C 24 28 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 5C D4 F2 0F 11 54 24 28 F2 0F 10 54 24 30 F2 0F 10 6C 24 28 F2 0F 5C D5 F2 0F 11 54 24 30 F2 0F 10 6C 24 30 F2 0F 5C E5 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F2 0F 58 D3 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 10 4C 24 58 F2 0F 59 E3 F2 0F 58 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 58 64 24 48 F2 0F 10 44 24 40 F2 0F 59 D0 F2 0F 59 E0 F2 0F 59 C5 F2 0F 10 4C 24 50 F2 0F 58 CA F2 0F 10 15 ?? ?? ?? ?? 0F 28 F2 F2 0F 58 CC F2 0F 5C F0 F2 0F 11 74 24 30 F2 0F 10 7C 24 30 F2 0F 5C D7 F2 0F 5C D0 F2 0F 11 54 24 28 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 5C 24 30 F2 0F 5C D1 F2 0F 10 44 24 28 0F B6 52 07 F2 0F 58 D0 83 E2 80 F2 0F 58 DA F2 0F 11 5C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 8B 45 0C F2 0F 10 44 24 38 F2 0F 11 00 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 8B 45 0C F2 0F 5C D2 F2 0F 5E D2 F2 0F 11 10 B8 01 00 00 00 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 5E D2 8B 45 0C F2 0F 11 10 F7 42 04 FF FF 0F 00 75 17 B9 01 00 00 00 33 C0 83 3A 00 0F 44 C1 83 C4 64 5B 5F 5E 8B E5 5D C3 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_189_1_0 {
	meta:
		name = "__guard_icall_checks_enforced"
		size = 18
		refs = "0002 ___guard_check_icall_fptr 000a @_guard_check_icall_nop@4"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 33 C0 81 F9 ?? ?? ?? ?? 0F 95 C0 C3 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "___sse2_ceil2"
		size = 80
		refs = "0006 _2il0floatpacket_4 000d _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 D8 0F 28 15 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 EA 0F 54 D9 0F 55 C8 66 0F C2 E9 01 66 0F 58 CA 66 0F 5C CA 0F 56 CB 0F 28 F5 0F 28 E1 66 0F C2 E0 01 0F 54 25 ?? ?? ?? ?? 0F 54 C5 66 0F 5C CC 0F 55 F1 0F 56 C6 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "___avx_atan2f8"
		size = 512
		refs = "0010 ___common_satan2_data 01ed ___common_satan2_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 00 01 00 00 C5 FC 10 35 ?? ?? ?? ?? C5 FC 11 4C 24 20 C5 FC 28 E8 C5 F4 54 E6 C5 D4 54 C6 C5 FC C2 FC 11 C5 FC 11 2C 24 C5 D4 57 D8 C5 DC 56 15 ?? ?? ?? ?? C5 FC 11 5C 24 60 C4 E3 6D 4A E8 70 C4 E3 7D 4A DC 70 C5 F4 C2 15 ?? ?? ?? ?? 12 C5 D4 5E EB C5 F4 57 F4 C5 EC 54 0D ?? ?? ?? ?? C5 FC 11 74 24 40 C5 FC 11 8C 24 80 00 00 00 C5 F8 10 0D ?? ?? ?? ?? C5 C4 55 35 ?? ?? ?? ?? C5 D9 FA D1 C4 E3 7D 19 E3 01 C5 E1 FA E1 C5 F9 FA D9 C4 E3 7D 19 C7 01 C5 C1 FA F9 C5 F8 10 0D ?? ?? ?? ?? C5 E9 66 C1 C5 E9 76 D1 C5 F9 EB D2 C5 E1 66 C1 C5 E1 76 D9 C5 F9 EB C3 C5 D9 66 D9 C5 D9 76 E1 C5 E9 EB C0 C5 E1 EB D4 C5 C1 66 D9 C5 C1 76 F9 C5 E1 EB DF C5 F1 EF C9 C5 E9 EB E3 C5 D4 59 DD C5 F9 6B C4 C5 F9 63 D1 C5 F9 D7 D2 C5 E4 59 E3 C5 DC 59 3D ?? ?? ?? ?? C5 DC 59 05 ?? ?? ?? ?? C5 C4 58 0D ?? ?? ?? ?? C5 FC 58 3D ?? ?? ?? ?? C5 F4 59 D4 C5 C4 59 FC C5 EC 58 05 ?? ?? ?? ?? C5 C4 58 15 ?? ?? ?? ?? C5 FC 59 CC C5 EC 59 D4 C5 F4 58 05 ?? ?? ?? ?? C5 EC 58 0D ?? ?? ?? ?? C5 FC 10 54 24 20 C5 FC 59 E4 C5 F4 59 DB C5 DC 58 05 ?? ?? ?? ?? C5 E4 58 C8 C5 F4 59 ED C5 D4 58 F6 C5 CC 56 44 24 40 C5 FC 58 8C 24 80 00 00 00 C5 F4 56 44 24 60 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 94 24 80 00 00 00 C5 FC 11 84 24 C0 00 00 00 C5 FC 11 4C 24 40 85 D2 74 DB 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 C0 00 00 00 EB B1 C5 F8 77 8D 8C B4 C0 00 00 00 8D 54 B4 40 8D 84 B4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_194_1_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 35
		refs = "000c ??_7type_info@@6B@ 0016 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 0C 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_101_72_1 {
	meta:
		name = "??_G_Ref_count_base@std@@UAEPAXI@Z"
		size = 35
		refs = "000c ??_7_Ref_count_base@std@@6B@ 0016 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 0C 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "__cosh_spec_sd"
		size = 304
		refs = "004b _static_const_table"
	strings:
		$1 = { 8B 58 04 8B 08 81 E3 FF FF FF 7F 81 FB 36 23 86 40 0F 82 01 01 00 00 0F 87 BA 00 00 00 81 FB 50 3C 9C F4 0F 82 EF 00 00 00 81 FB C3 33 86 40 72 2D 77 08 81 F9 00 79 98 78 72 23 8B 48 50 C1 E1 04 81 E1 F0 03 00 00 66 0F 28 B9 ?? ?? ?? ?? 66 0F 28 EF BB 01 00 00 00 66 0F 15 FF EB 0C F2 0F 10 68 10 F2 0F 10 78 20 33 DB 66 0F 28 DD F2 0F 10 70 40 66 0F 28 D6 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 CE 66 0F 58 EF F2 0F 59 F6 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CE F2 0F 58 D1 F2 0F 59 D5 F2 0F 58 D7 85 DB F2 0F 58 D3 74 51 F2 0F 59 15 ?? ?? ?? ?? 33 DB F2 0F 59 15 ?? ?? ?? ?? EB 3D 81 FB CE 33 86 40 0F 82 46 FF FF FF 77 18 81 FB 7D F8 B9 8F 0F 82 38 FF FF FF 33 DB F2 0F 10 15 ?? ?? ?? ?? EB 17 81 FB 00 00 F0 7F 72 EC 77 04 85 C9 74 E8 66 0F 57 D2 66 0F C2 D2 00 85 DB 74 01 C3 66 0F 28 2D ?? ?? ?? ?? 66 0F 58 ED C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_195_1_0 {
	meta:
		name = "___sse2_cosh2"
		size = 560
		refs = "0019 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC E0 00 00 00 83 E4 F0 89 84 24 A4 00 00 00 89 1C 24 66 0F 28 3D ?? ?? ?? ?? 89 7C 24 04 89 74 24 08 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 8D 44 24 10 66 0F 28 25 ?? ?? ?? ?? B9 FF FF FF 7F 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? BB FF FF FF 7F 66 0F 28 F2 66 0F 29 44 24 10 66 0F 5C D3 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 23 48 04 66 0F 73 F6 04 66 0F 29 4C 24 60 66 0F 59 EA 23 58 0C 66 0F FB D9 66 0F 5C C4 66 0F 7E F6 66 0F 5C C5 66 0F FE 0D ?? ?? ?? ?? 81 E6 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F7 66 0F 28 BE ?? ?? ?? ?? 81 E7 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 50 F7 DE 66 0F 28 B7 ?? ?? ?? ?? 81 C6 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DF 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C7 00 04 00 00 66 0F 28 A6 ?? ?? ?? ?? 66 0F C6 FE 03 66 0F 28 97 ?? ?? ?? ?? 66 0F 59 E9 81 E9 36 23 86 40 66 0F 28 F4 66 0F 59 F9 81 EB 36 23 86 40 66 0F C6 E2 00 66 0F 29 6C 24 20 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 40 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 23 D9 66 0F 58 E6 66 0F 29 7C 24 30 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 58 EC 66 0F 59 C3 66 0F 5C FC 66 0F 59 D1 66 0F 59 C5 66 0F 58 D1 66 0F 28 5C 24 30 66 0F 59 D7 66 0F 58 C2 66 0F 28 64 24 40 66 0F 58 C6 66 0F 28 6C 24 20 66 0F 58 C3 F7 C3 00 00 00 80 66 0F 58 C4 66 0F 58 C5 8B 74 24 08 8B 7C 24 04 74 02 EB 29 8D 44 24 10 66 0F 28 E0 66 0F 28 D0 66 0F 15 E4 E8 C9 FC FF FF 83 C0 08 66 0F 28 C2 66 0F 28 D4 E8 B9 FC FF FF 66 0F 14 C2 8B 1C 24 8B A4 24 A4 00 00 00 C3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "___avx_atan4"
		size = 432
		refs = "001b ___common_datan_data"
	strings:
		$1 = { 53 8B DC 83 E4 C0 55 55 8B 6B 04 89 6C 24 04 8B EC 81 EC B8 00 00 00 C5 FD 10 3D ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 FD 54 0D ?? ?? ?? ?? C5 F5 C2 E7 12 C5 FD 54 F2 C5 DD 55 1D ?? ?? ?? ?? C5 E5 57 EE C5 F5 5F DF C5 C5 5D C9 C5 FD 11 AD 48 FF FF FF C5 FD 10 2D ?? ?? ?? ?? C5 FD 10 05 ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C5 F5 5E CB C5 FD 10 1D ?? ?? ?? ?? C5 DD 55 E2 C5 DD 57 F6 C5 CD 57 D1 C5 FD 11 95 68 FF FF FF C5 ED 59 D2 C5 FD 10 25 ?? ?? ?? ?? C5 FD 11 55 88 C5 ED 59 D2 C5 FD 10 35 ?? ?? ?? ?? C5 FD 11 55 A8 C5 ED 59 D2 C5 D5 59 EA C5 C5 59 FA C5 FD 59 C2 C5 D5 58 F6 C5 C5 58 FB C5 FD 58 DC C5 ED 59 25 ?? ?? ?? ?? C5 CD 59 F2 C5 C5 59 EA C5 E5 59 DA C5 DD 58 05 ?? ?? ?? ?? C5 CD 58 25 ?? ?? ?? ?? C5 D5 58 3D ?? ?? ?? ?? C5 E5 58 2D ?? ?? ?? ?? C5 FD 59 F2 C5 DD 59 E2 C5 C5 59 FA C5 D5 59 C2 C5 CD 58 1D ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 FD 58 2D ?? ?? ?? ?? C5 C5 58 35 ?? ?? ?? ?? C5 E5 59 DA C5 DD 59 E2 C5 CD 59 F2 C5 D5 59 EA C5 E5 58 1D ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 D5 58 05 ?? ?? ?? ?? C5 CD 58 35 ?? ?? ?? ?? C5 E5 59 D2 C5 FD 10 0D ?? ?? ?? ?? C5 ED 58 D9 C5 FD 10 55 88 C5 DD 59 CA C5 CD 59 F2 C5 F5 58 C8 C5 CD 58 EB C5 F5 59 65 A8 C5 DD 58 FD C5 C5 59 85 68 FF FF FF C5 FD 58 85 48 FF FF FF 8B E5 5D 8B E3 5B C3 8D A4 24 00 00 00 00 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "___avx_ceilf8"
		size = 16
	strings:
		$1 = { C4 E3 7D 08 C0 02 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "___vdecl_ceil2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_ceil2 000e ___sse2_ceil2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "___vdecl_ceilf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_ceilf4 000e ___sse2_ceilf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "___vdecl_exp2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_exp2 000e ___sse2_exp2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "___vdecl_expf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_expf4 000e ___sse2_expf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "___vdecl_floor2"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_floor2 000e ___sse2_floor2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "___vdecl_floorf4"
		size = 18
		refs = "0002 ___isa_available 0009 ___sse4_floorf4 000e ___sse2_floorf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_207_2_0 {
	meta:
		name = "__RTC_GetErrDesc"
		size = 24
		refs = "000e ?_RTC_errlist@@3QBQBDB"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 F8 04 77 09 8B 04 85 ?? ?? ?? ?? 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_207_4_0 {
	meta:
		name = "__RTC_SetErrorFunc"
		size = 26
		refs = "0004 ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA 000d ?_RTC_ErrorReportFuncW@@3P6AHHPB_WH00ZZA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8B 4D 08 83 25 ?? ?? ?? ?? 00 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_207_5_0 {
	meta:
		name = "__RTC_SetErrorFuncW"
		size = 26
		refs = "0004 ?_RTC_ErrorReportFuncW@@3P6AHHPB_WH00ZZA 000d ?_RTC_ErrorReportFunc@@3P6AHHPBDH00ZZA"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8B 4D 08 83 25 ?? ?? ?? ?? 00 89 0D ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_207_6_0 {
	meta:
		name = "__RTC_SetErrorType"
		size = 35
		refs = "000e ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 55 8B EC 8B 55 08 83 FA 04 77 13 8B 04 95 ?? ?? ?? ?? 8B 4D 0C 89 0C 95 ?? ?? ?? ?? 5D C3 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "___avx_tanh4"
		size = 720
		refs = "0018 ___common_dtanh_data 02c3 ___common_dtanh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 81 EC 38 01 00 00 C5 FD 11 44 24 20 C5 F8 10 25 ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 FD 54 0D ?? ?? ?? ?? C5 FD 54 15 ?? ?? ?? ?? C5 FD 11 14 24 C4 E3 7D 19 C5 01 C5 F8 C6 FD DD C5 C1 DB 2D ?? ?? ?? ?? C5 D1 66 35 ?? ?? ?? ?? C5 D9 66 E5 C5 C9 EB D4 C5 C1 EF FF C5 D1 FA 35 ?? ?? ?? ?? C5 C9 66 C7 C5 F8 50 FA C5 C9 DB E0 C5 C9 66 D3 C4 E3 59 4A DB 20 C5 C9 72 D3 0A C5 F9 7E F0 C4 E3 79 16 F2 01 C4 E3 79 16 F1 02 C4 E3 79 16 F6 03 C5 F9 10 A0 ?? ?? ?? ?? C5 F9 10 9A ?? ?? ?? ?? C5 F9 10 B0 ?? ?? ?? ?? C4 E3 5D 18 A9 ?? ?? ?? ?? 01 C4 E3 65 18 BE ?? ?? ?? ?? 01 C5 F9 10 A2 ?? ?? ?? ?? C5 D5 15 C7 C5 FD 11 44 24 40 C5 F9 10 80 ?? ?? ?? ?? C4 E3 4D 18 91 ?? ?? ?? ?? 01 C4 E3 5D 18 AE ?? ?? ?? ?? 01 C5 F9 10 B2 ?? ?? ?? ?? C5 ED 15 FD C5 ED 14 DD C5 FD 11 BC 24 80 00 00 00 C5 F9 10 B8 ?? ?? ?? ?? C5 FD 11 5C 24 60 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C5 F9 10 B2 ?? ?? ?? ?? C4 E3 7D 18 99 ?? ?? ?? ?? 01 C5 E5 14 E2 C5 E5 15 EA C5 FD 11 AC 24 C0 00 00 00 C5 F9 10 80 ?? ?? ?? ?? C5 FD 11 A4 24 A0 00 00 00 C4 E3 45 18 99 ?? ?? ?? ?? 01 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C5 E5 15 EA C5 FD 11 AC 24 00 01 00 00 C5 F9 10 B2 ?? ?? ?? ?? C5 F9 10 BA ?? ?? ?? ?? C5 F9 10 A8 ?? ?? ?? ?? C5 E5 14 E2 C5 FD 11 A4 24 E0 00 00 00 C4 E3 4D 18 96 ?? ?? ?? ?? 01 C4 E3 55 18 B1 ?? ?? ?? ?? 01 C4 E3 7D 18 99 ?? ?? ?? ?? 01 C5 E5 14 E2 C5 E5 15 DA C5 F9 10 80 ?? ?? ?? ?? C4 E3 45 18 AE ?? ?? ?? ?? 01 C5 CD 14 D5 C5 CD 15 ED C5 F9 10 B2 ?? ?? ?? ?? C4 E3 7D 18 81 ?? ?? ?? ?? 01 C4 E3 4D 18 B6 ?? ?? ?? ?? 01 C5 FD 14 FE C5 F5 58 F7 C5 D5 59 CE C5 F5 58 C2 C5 FD 59 CE C5 F5 58 D3 C5 ED 59 DE C5 E5 58 E4 C5 DD 59 EE C5 D5 58 BC 24 00 01 00 00 C5 C5 59 C6 C5 FD 58 8C 24 E0 00 00 00 C5 F5 59 D6 C5 ED 58 9C 24 C0 00 00 00 C5 E5 59 E6 C5 DD 58 AC 24 A0 00 00 00 C5 D5 59 FE C5 C5 58 84 24 80 00 00 00 C5 FD 59 CE C5 F5 58 54 24 60 C5 ED 59 F6 C5 CD 58 44 24 40 C5 FD 56 04 24 85 FF 75 0C 81 C4 38 01 00 00 5F 5E 8B E5 5D C3 C5 FD 10 4C 24 20 C5 FD 11 44 24 40 C5 FD 11 0C 24 74 E1 33 F6 0F A3 F7 72 18 46 83 FE 20 7C F5 C5 FD 10 44 24 40 81 C4 38 01 00 00 5F 5E 8B E5 5D C3 C5 F8 77 8D 44 F4 40 8D 14 F4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D 64 24 00 }
	condition:
		$1
}

rule file_216_1_0 {
	meta:
		name = "??_M@YGXPAXIIP6EX0@Z@Z"
		size = 122
		refs = "0003 __sehtable$??_M@YGXPAXIIP6EX0@Z@Z 0008 __SEH_prolog4 003a @_guard_check_icall@4 0057 __SEH_epilog4 0075 ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 E7 00 8B 5D 0C 8B C3 8B 7D 10 0F AF C7 8B 75 08 03 F0 89 75 08 83 65 FC 00 8B C7 4F 89 7D 10 85 C0 74 14 2B F3 89 75 08 8B 4D 14 E8 ?? ?? ?? ?? 8B CE FF 55 14 EB E2 B0 01 88 45 E7 C7 45 FC FE FF FF FF E8 14 00 00 00 E8 ?? ?? ?? ?? C2 10 00 8B 7D 10 8B 5D 0C 8B 75 08 8A 45 E7 84 C0 75 0B FF 75 14 57 53 56 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_216_2_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 25
		refs = "0015 _terminate"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 00 81 38 63 73 6D E0 74 04 33 C0 5D C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_3_0 {
	meta:
		name = "?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
		size = 109
		refs = "0003 __sehtable$?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z 0008 __SEH_prolog4 0026 @_guard_check_icall@4 0057 _terminate 0066 __SEH_epilog4"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 89 75 FC 8B 7D 08 89 75 E4 3B 75 10 74 42 2B 7D 0C 89 7D 08 8B 4D 14 E8 ?? ?? ?? ?? 8B CF FF 55 14 46 EB E2 8B 45 EC 89 45 E0 8B 45 E0 8B 00 89 45 DC 8B 45 DC 81 38 63 73 6D E0 74 0B C7 45 D8 00 00 00 00 8B 45 D8 C3 E8 ?? ?? ?? ?? 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C2 10 00 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "___sse4_ceilf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 02 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "___sse2_floor2"
		size = 80
		refs = "0006 _2il0floatpacket_4 0010 _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 D8 0F 28 15 ?? ?? ?? ?? 0F 28 E0 0F 28 0D ?? ?? ?? ?? 0F 28 EA 0F 54 D9 0F 55 C8 66 0F C2 E9 01 66 0F 58 CA 66 0F 5C CA 0F 56 CB 0F 28 F5 66 0F C2 E1 01 0F 54 25 ?? ?? ?? ?? 0F 54 C5 66 0F 5C CC 0F 55 F1 0F 56 C6 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "___vdecl_fmod2"
		size = 55
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 20 F3 0F 7F 04 24 F3 0F 7F 4C 24 10 DD 04 24 DD 44 24 10 E8 ?? ?? ?? ?? DD 1C 24 DD 44 24 08 DD 44 24 18 E8 ?? ?? ?? ?? DD 5C 24 08 F3 0F 6F 04 24 83 C4 20 C3 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "_TestInt"
		size = 144
	strings:
		$1 = { 57 8B 7C 24 0C 81 E7 FF FF FF 7F 8B D7 8B 44 24 08 0B D0 74 69 8D 97 00 00 10 C0 81 FA 00 00 00 40 73 3E 81 FF 00 00 40 43 7D 53 8B CF 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 24 8B D7 D3 E2 C1 E2 0C 0B D0 75 15 83 C1 0B D3 E7 F7 D7 81 E7 00 00 00 80 C1 EF 1F 47 8B C7 5F C3 33 C0 5F C3 83 C1 0B D3 E0 A9 FF FF FF 7F 75 F0 F7 D0 25 00 00 00 80 C1 E8 1F 40 5F C3 B8 02 00 00 00 5F C3 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "__vmldPow_HA_scalar"
		size = 1248
		refs = "01af _2il0floatpacket_6 020c INF_c_1917_0_4 034a _2il0floatpacket_5 0446 QNaN_c_1917_0_4"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 2C F2 0F 10 4D 08 8B 4D 0C 8B F1 F2 0F 11 4C 24 08 81 E1 00 00 00 80 8B 45 14 8B D8 8B F8 81 E6 FF FF FF 7F F2 0F 10 45 10 81 E3 FF FF FF 7F 89 4C 24 1C 81 E7 00 00 00 80 8B 4C 24 08 81 FE 00 00 F0 7F F2 0F 11 04 24 89 74 24 0C 8B 55 10 89 5C 24 04 89 7C 24 10 89 4C 24 24 0F 84 57 04 00 00 C7 44 24 08 00 00 00 00 8B 0C 24 81 FB 00 00 F0 7F 89 4C 24 0C 0F 84 24 04 00 00 C7 44 24 20 00 00 00 00 8B CE 81 E1 00 00 F0 7F 81 F9 00 00 F0 7F 0F 84 F1 03 00 00 C7 04 24 00 00 00 00 8B CB 81 E1 00 00 F0 7F 81 F9 00 00 F0 7F 0F 84 BE 03 00 00 C7 44 24 28 00 00 00 00 8B FE B9 01 00 00 00 0B 7C 24 24 BF 00 00 00 00 0F 44 F9 89 7C 24 18 8B 7C 24 20 0B 7C 24 28 BF 00 00 00 00 0F 44 F9 81 FE 00 00 F0 3F 89 7C 24 14 0F 84 67 03 00 00 C7 44 24 04 00 00 00 00 25 FF FF FF 7F 8B CA 0B C8 74 69 8D 88 00 00 10 C0 81 F9 00 00 00 40 73 3A 3D 00 00 40 43 7D 54 8B C8 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 21 8B F8 D3 E7 C1 E7 0C 0B FA 75 12 83 C1 0B D3 E0 F7 D0 25 00 00 00 80 C1 E8 1F 40 EB 26 33 C0 EB 22 83 C1 0B D3 E2 F7 C2 FF FF FF 7F 75 EF F7 D2 81 E2 00 00 00 80 C1 EA 1F 8D 42 01 EB 05 B8 02 00 00 00 81 FE 00 00 F0 3F 7E 07 BA 01 00 00 00 EB 08 0F 84 C1 02 00 00 33 D2 0B 5C 24 0C 0F 84 90 02 00 00 83 7C 24 1C 00 75 17 83 7C 24 04 00 74 2E D9 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 04 00 74 17 83 7C 24 20 00 74 10 D9 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 3C 24 00 0F 85 38 02 00 00 83 7C 24 28 00 0F 85 1B 02 00 00 83 7C 24 18 00 74 23 83 7C 24 10 00 74 1C 83 7C 24 20 00 74 15 E8 D6 02 00 00 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 85 D2 74 3B 83 7C 24 10 00 75 17 83 7C 24 20 00 74 2D DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 20 00 74 16 66 0F EF C0 F3 0F 11 04 24 D9 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 81 FE 00 00 F0 3F 7D 3B 83 7C 24 10 00 75 1D 83 7C 24 20 00 74 2D 66 0F EF C0 F3 0F 11 04 24 D9 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 20 00 74 10 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 1C 00 75 62 83 7C 24 08 00 74 27 83 7C 24 10 00 74 06 66 0F EF C0 EB 08 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 04 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 18 00 0F 84 19 01 00 00 83 7C 24 10 00 0F 84 E1 00 00 00 83 F8 01 0F 85 9B 00 00 00 E8 EB 01 00 00 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 08 00 74 54 83 7C 24 10 00 75 2A F2 0F 10 05 ?? ?? ?? ?? 83 F8 01 66 0F EF C9 F2 0F 5C C8 74 03 0F 28 C8 F2 0F 11 0C 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 F8 01 66 0F EF C0 75 08 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 04 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 14 00 74 11 85 C0 75 0D 83 7C 24 18 00 0F 84 C9 00 00 00 EB 07 83 7C 24 18 00 74 76 83 7C 24 10 00 74 3D 83 F8 01 74 15 E8 50 01 00 00 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 E8 3B 01 00 00 66 0F EF C0 F2 0F 5C 05 ?? ?? ?? ?? F2 0F 11 04 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 F8 01 74 1D 83 7C 24 14 00 74 26 66 0F EF C0 F3 0F 11 04 24 D9 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 66 0F EF C0 F3 0F 11 04 24 D9 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 F2 0F 11 04 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 F2 0F 11 0C 24 DD 04 24 83 C4 2C 5B 5F 5E 8B E5 5D C3 D9 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 E8 0C 0C 00 00 DD 05 ?? ?? ?? ?? 83 C4 2C 5B 5F 5E 8B E5 5D C3 83 7C 24 24 00 0F 85 27 FD FF FF E9 2F FD FF FF 33 FF B9 01 00 00 00 83 7C 24 24 00 0F 44 F9 89 7C 24 04 E9 89 FC FF FF 33 FF B9 01 00 00 00 83 7C 24 20 00 0F 44 F9 89 7C 24 28 E9 32 FC FF FF 33 FF B9 01 00 00 00 83 7C 24 08 00 0F 44 F9 89 3C 24 E9 FF FB FF FF 33 FF B9 01 00 00 00 83 7C 24 0C 00 0F 44 F9 89 7C 24 20 E9 CC FB FF FF B9 01 00 00 00 33 FF 83 7C 24 24 00 0F 44 F9 89 7C 24 08 E9 99 FB FF FF EB 03 CC CC CC }
	condition:
		$1
}

rule file_236_2_0 {
	meta:
		name = "__raise_zerodivide"
		size = 32
	strings:
		$1 = { 66 0F 76 DB 66 0F 72 F3 1F 0F 57 D2 F3 0F 5E DA C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_236_3_0 {
	meta:
		name = "_pow_scalar"
		size = 1808
		refs = "0096 _static_const_table"
	strings:
		$1 = { 60 8B C4 83 E4 F0 81 EC C0 00 00 00 89 04 24 8D 74 24 30 8D 54 24 38 66 0F D6 44 24 30 66 0F D6 4C 24 38 8B FA 33 C0 BB 00 00 F0 3F 89 44 24 10 89 44 24 14 89 44 24 20 89 5C 24 24 F3 0F 7E 1E 8B 47 04 25 FF FF FF 7F 8B 1F 0B D8 0F 84 F6 05 00 00 3D 00 00 F0 7F 0F 83 EB 05 00 00 8B 56 04 81 EA 00 00 10 80 81 FA FF FF DF FF 0F 8F 32 05 00 00 8B FF F3 0F 7E D3 66 0F 73 D2 20 66 0F 7E D0 F3 0F 7E D3 25 00 FE 0F 00 05 00 02 00 00 C1 E8 0A 66 0F DB 15 ?? ?? ?? ?? 66 0F FB 1D ?? ?? ?? ?? 66 0F EB 15 ?? ?? ?? ?? 66 0F 72 E3 14 66 0F DB 1D ?? ?? ?? ?? F3 0F 7E 04 C5 ?? ?? ?? ?? 03 C0 66 0F D6 54 24 40 66 0F D6 44 24 50 66 0F FA 5C 24 10 66 0F FE 1D ?? ?? ?? ?? F2 0F 59 C2 F3 0F 7E 0C C5 ?? ?? ?? ?? F3 0F 7E 14 C5 ?? ?? ?? ?? F2 0F 5C 1D ?? ?? ?? ?? 66 0F D6 54 24 60 F2 0F 58 D9 F3 0F 7E 0D ?? ?? ?? ?? F3 0F 7E 54 24 40 66 0F DB 4C 24 40 F2 0F 5C D1 F2 0F 59 4C 24 50 F2 0F 59 54 24 50 F2 0F 5C C8 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 CA F3 0F 7E D3 F2 0F 58 D8 F2 0F 5C D3 F2 0F 58 D0 66 0F D6 44 24 70 F3 0F 7E C3 66 0F D6 9C 24 80 00 00 00 F2 0F 58 D9 F2 0F 5C C3 F2 0F 58 C1 F2 0F 58 4C 24 70 F2 0F 58 C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 44 24 60 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 C2 F3 0F 7E D3 F2 0F 58 D8 F3 0F 7E 0F F2 0F 5C D3 F2 0F 58 C2 F3 0F 7E D3 66 0F DB 15 ?? ?? ?? ?? F2 0F 5C DA 66 0F D6 94 24 90 00 00 00 8B 84 24 84 00 00 00 8B 5F 04 25 00 00 F0 7F 81 E3 00 00 F0 7F 03 C3 3D 00 00 90 80 0F 87 5A 04 00 00 F3 0F 7E D1 F2 0F 59 C1 66 0F DB 0D ?? ?? ?? ?? 66 0F D6 84 24 A0 00 00 00 F3 0F 7E C3 F2 0F 5C D1 F2 0F 59 D9 F2 0F 59 C2 F2 0F 59 94 24 90 00 00 00 F2 0F 59 8C 24 90 00 00 00 F2 0F 58 C3 F2 0F 58 C2 F3 0F 7E D1 F2 0F 58 0D ?? ?? ?? ?? 66 0F 7E C8 F3 0F 7E 1D ?? ?? ?? ?? F2 0F 5C D9 66 0F 73 F1 2D 3D 80 00 02 00 0F 8D FB 00 00 00 3D 80 FF 01 00 7D 18 3D 00 E6 FD FF 0F 8E 05 01 00 00 3D 00 1E FE FF 0F 8E 0E 01 00 00 EB 1C 66 0F FB 0D ?? ?? ?? ?? F3 0F 7E 64 24 20 66 0F 59 25 ?? ?? ?? ?? 66 0F D6 64 24 20 83 E0 7F 03 C0 66 0F FE 0D ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? F2 0F 58 DA F2 0F 58 84 24 A0 00 00 00 F2 0F 58 C3 66 0F D6 8C 24 B0 00 00 00 F3 0F 7E 14 C5 ?? ?? ?? ?? F3 0F 7E 1C C5 ?? ?? ?? ?? F3 0F 7E 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 59 C8 F2 0F 59 C8 F2 0F 59 CA F2 0F 58 CB F3 0F 7E 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 D8 F2 0F 59 DA F2 0F 58 CB F2 0F 59 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 C8 F2 0F 58 CA F2 0F 59 4C 24 20 F2 0F 59 8C 24 B0 00 00 00 F3 0F 7E C1 E9 77 03 00 00 8D 49 00 F3 0F 7E 44 24 20 66 0F DB 05 ?? ?? ?? ?? 66 0F EB 05 ?? ?? ?? ?? E9 59 03 00 00 90 F3 0F 7E 44 24 20 66 0F DB 05 ?? ?? ?? ?? E9 45 03 00 00 90 66 0F D4 0D ?? ?? ?? ?? F3 0F 7E 64 24 20 66 0F 59 25 ?? ?? ?? ?? 66 0F D6 64 24 20 83 E0 7F 03 C0 66 0F FE 0D ?? ?? ?? ?? 66 0F DB 0D ?? ?? ?? ?? F2 0F 58 DA F2 0F 58 84 24 A0 00 00 00 F3 0F 7E D3 F2 0F 58 D8 F2 0F 5C D3 F2 0F 58 C2 F3 0F 7E 14 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? F3 0F 7E 6C 24 20 F2 0F 59 EA F2 0F 59 E9 66 0F DB 2D ?? ?? ?? ?? 66 0F 66 2D ?? ?? ?? ?? 66 0F 50 C5 A9 01 00 00 00 0F 84 BD 00 00 00 F3 0F 7E 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB 66 0F D6 8C 24 B0 00 00 00 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 C5 F2 0F 59 DD F3 0F 7E EB 66 0F DB 2D ?? ?? ?? ?? F3 0F 7E F3 F2 0F 5C DD F2 0F 58 C3 F3 0F 7E DA 66 0F DB 15 ?? ?? ?? ?? F3 0F 7E FB F2 0F 5C DA F2 0F 59 F4 F3 0F 7E C8 F2 0F 59 C3 F2 0F 58 C6 F2 0F 59 CA F2 0F 58 C1 F2 0F 58 C4 F2 0F 59 DD F2 0F 58 C3 F2 0F 59 D5 F2 0F 58 C2 F2 0F 58 C7 F3 0F 7E 8C 24 B0 00 00 00 F2 0F 59 4C 24 20 F2 0F 59 C1 E9 FA 01 00 00 F3 0F 7E 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 59 EB F2 0F 59 EB F2 0F 59 EB F2 0F 59 EA F2 0F 58 EC F3 0F 7E 35 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 F3 F2 0F 59 F2 F2 0F 58 EE F2 0F 59 1D ?? ?? ?? ?? F2 0F 59 DA F2 0F 58 EB F3 0F 7E C2 66 0F DB 15 ?? ?? ?? ?? F2 0F 5C C2 F3 0F 7E F5 66 0F DB 2D ?? ?? ?? ?? F2 0F 5C F5 F2 0F 58 C6 F2 0F 58 C5 66 0F 59 C1 66 0F 59 D1 F2 0F 58 C2 F2 0F 59 44 24 20 E9 5B 01 00 00 8D 49 00 8B 46 04 8B 56 04 8B 1E 25 FF FF FF 7F 3D 00 00 F0 7F 0F 83 8C 00 00 00 0B D8 0F 84 84 00 00 00 81 FA 00 00 10 00 73 16 66 0F 59 1D ?? ?? ?? ?? B8 34 00 00 00 89 44 24 14 E9 92 FA FF FF 60 83 EC 10 F3 0F 7E 07 66 0F D6 04 24 E8 7C F4 FF FF 83 C4 10 89 44 24 24 61 8B 44 24 04 83 F8 00 74 43 66 0F EF 1D ?? ?? ?? ?? A9 01 00 00 00 74 09 B8 00 00 F0 BF 89 44 24 24 81 E2 FF FF FF 7F 81 FA 00 00 10 00 0F 87 45 FA FF FF 66 0F 59 1D ?? ?? ?? ?? B8 34 00 00 00 89 44 24 14 E9 2F FA FF FF 8D 49 00 F3 0F 7E 06 F3 0F 7E 0F 60 83 EC 10 66 0F D6 04 24 66 0F D6 4C 24 08 E8 9C F4 FF FF 83 C4 10 61 DD 5C 24 40 F3 0F 7E 44 24 40 E9 85 00 00 00 90 60 83 EC 10 F3 0F 7E 07 66 0F D6 04 24 E8 E6 F3 FF FF 83 C4 10 89 44 24 24 61 8B 44 24 04 8B 5F 04 8B 94 24 84 00 00 00 33 DA 81 FB 00 00 00 80 73 2E 8B 5E 04 81 FB 00 00 00 80 73 0A F3 0F 7E 05 ?? ?? ?? ?? EB 3D 83 F8 00 74 84 66 0F C4 C0 00 66 0F 73 F0 3F 66 0F EB 05 ?? ?? ?? ?? EB 24 8B 5E 04 81 FB 00 00 00 80 73 06 66 0F EF C0 EB 13 83 F8 00 0F 84 56 FF FF FF 66 0F C4 C0 00 66 0F 73 F0 3F 8B 24 24 61 C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_236_4_0 {
	meta:
		name = "___sse2_pow2"
		size = 1088
		refs = "001e _static_const_table"
	strings:
		$1 = { 8B C4 81 EC D0 00 00 00 83 E4 F0 89 84 24 94 00 00 00 66 0F 28 D8 66 0F 28 D0 66 0F DB 05 ?? ?? ?? ?? 66 0F 57 F6 66 0F FE 05 ?? ?? ?? ?? BA 00 00 00 00 89 54 24 70 66 0F 73 D0 2A 66 0F 7E C0 66 0F C5 C8 04 66 0F 29 4C 24 10 66 0F C5 D3 03 F3 0F 7E 04 C5 ?? ?? ?? ?? 66 0F 16 04 CD ?? ?? ?? ?? 66 0F DB 15 ?? ?? ?? ?? 03 C0 66 0F 28 3C C5 ?? ?? ?? ?? 66 0F C5 C3 07 66 0F 29 1C 24 66 0F FB 1D ?? ?? ?? ?? 03 C9 66 0F EB 15 ?? ?? ?? ?? 66 0F 72 E3 14 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 2C CD ?? ?? ?? ?? 66 0F 28 E2 66 0F 29 74 24 30 66 0F FE 1D ?? ?? ?? ?? 66 0F 59 D0 81 EA 10 00 00 80 66 0F 5C 1D ?? ?? ?? ?? 2D 10 00 00 80 81 FA DF 7F 00 80 0F 8F C0 02 00 00 3D DF 7F 00 80 0F 8F B5 02 00 00 66 0F 70 F7 0E 66 0F 14 FD 66 0F 58 DF 66 0F C6 F5 02 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FC 66 0F 5C E7 66 0F 59 F8 66 0F 59 E0 66 0F 5C FA 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 FC 66 0F 28 E3 66 0F 58 DA 66 0F 5C E3 66 0F 58 E2 66 0F 28 C3 66 0F 58 DF 66 0F 5C C3 66 0F 58 C7 66 0F 58 FA 66 0F 58 C4 66 0F 28 D7 66 0F 59 FF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 58 C6 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 28 F3 66 0F 59 E7 66 0F 59 EF 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 28 F9 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 70 D3 F1 66 0F 58 E5 66 0F 58 C4 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D8 66 0F 5C F3 66 0F 7E D0 66 0F 70 D2 FF 8B 4C 24 14 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 C6 66 0F DB E3 25 00 00 F0 7F 81 E1 00 00 F0 7F 66 0F 5C DC 03 C1 3D 00 00 90 80 0F 87 D7 01 00 00 66 0F 7E D0 66 0F 59 C1 8B 4C 24 1C 25 00 00 F0 7F 81 E1 00 00 F0 7F 03 C1 3D 00 00 90 80 0F 87 B3 01 00 00 66 0F 28 EB 8B 44 24 14 25 FF FF FF 7F 8B 4C 24 10 0B C8 66 0F 5C CF 0F 84 96 01 00 00 3D 00 00 F0 7F 66 0F 59 DF 0F 83 87 01 00 00 8B 44 24 1C 25 FF FF FF 7F 8B 4C 24 18 0B C8 0F 84 72 01 00 00 3D 00 00 F0 7F 66 0F 59 E9 0F 83 63 01 00 00 66 0F 59 CC 66 0F 59 FC 66 0F 58 EB 66 0F 28 1D ?? ?? ?? ?? 66 0F 58 E9 66 0F 28 D7 66 0F 58 3D ?? ?? ?? ?? 66 0F 7E F8 66 0F C5 CF 04 66 0F C5 D7 05 C1 E2 10 66 0F 5C DF 0B CA 3D 80 FF 01 00 0F 8D 1D 01 00 00 81 F9 80 FF 01 00 0F 8D 11 01 00 00 3D 00 1E FE FF 0F 8E 06 01 00 00 81 F9 00 1E FE FF 0F 8E FA 00 00 00 83 E0 7F 83 E1 7F 03 C0 03 C9 66 0F 73 F7 2D 66 0F 28 25 ?? ?? ?? ?? 66 0F FE 3D ?? ?? ?? ?? 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 DA 66 0F 58 E8 66 0F 28 05 ?? ?? ?? ?? F3 0F 7E 14 C5 ?? ?? ?? ?? 66 0F 58 EB F3 0F 7E 1C C5 ?? ?? ?? ?? 66 0F 16 14 CD ?? ?? ?? ?? 66 0F 16 1C CD ?? ?? ?? ?? 66 0F 59 C5 66 0F 28 CD 66 0F 59 E5 66 0F 59 ED 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 C5 66 0F 59 E5 66 0F 59 C5 66 0F 59 0D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 E2 66 0F 58 C3 66 0F 59 CA 66 0F 58 C4 66 0F 58 C1 66 0F 58 C2 66 0F 59 C7 E9 97 00 00 00 66 0F 57 F6 66 0F 28 3D ?? ?? ?? ?? 66 0F C2 74 24 10 01 66 0F C2 7C 24 10 05 66 0F EF ED 66 0F DB F7 66 0F 76 2C 24 66 0F 70 FD B1 66 0F DB EE 66 0F DB EF 66 0F D7 D5 89 54 24 70 66 0F 29 6C 24 30 8B 44 24 70 A9 0F 00 00 00 75 16 F2 0F 10 04 24 F2 0F 10 4C 24 10 E8 F7 F4 FF FF F2 0F 11 44 24 20 8B 44 24 70 A9 00 0F 00 00 75 11 F2 0F 10 44 24 08 F2 0F 10 4C 24 18 E8 D5 F4 FF FF 66 0F 76 C9 66 0F EF 4C 24 30 66 0F 14 C0 66 0F 12 44 24 20 66 0F 54 C1 8B A4 24 94 00 00 00 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_236_5_0 {
	meta:
		name = "__raise_invalid"
		size = 16
	strings:
		$1 = { 66 0F 76 D2 66 0F 72 F2 17 F3 0F 5C D2 C3 8B FF }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "__aulldvrm"
		size = 149
	strings:
		$1 = { 56 8B 44 24 14 0B C0 75 28 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B D8 8B 44 24 08 F7 F1 8B F0 8B C3 F7 64 24 10 8B C8 8B C6 F7 64 24 10 03 D1 EB 47 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 14 8B C8 8B 44 24 10 F7 E6 03 D1 72 0E 3B 54 24 0C 77 08 72 0F 3B 44 24 08 76 09 4E 2B 44 24 10 1B 54 24 14 33 DB 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 5E C2 10 00 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "___avx_sin4"
		size = 2368
		refs = "0012 ___common_dsin_data 0145 ___common_dsin_cout_rare 015d ___common_dsin_data_ha 01d6 ___common_dsin_reduction_data 023e _2il0floatpacket_264 0260 _2il0floatpacket_265 026d _2il0floatpacket_266 05fb _2il0floatpacket_267 0636 _2il0floatpacket_268 0650 _2il0floatpacket_269 066f _2il0floatpacket_270 0677 _2il0floatpacket_271 06c4 _2il0floatpacket_272 06d4 _2il0floatpacket_273 072f _2il0floatpacket_277 0740 _2il0floatpacket_274 0749 _2il0floatpacket_275 0752 _2il0floatpacket_276 078c _2il0floatpacket_278 0799 _2il0floatpacket_279"
	strings:
		$1 = { 55 8B EC 83 E4 C0 57 53 81 EC B8 02 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 E5 55 F0 C5 FD 54 DB C5 E5 C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CA 01 C5 F0 C6 E2 DD C5 F8 50 C4 85 C0 0F 85 10 01 00 00 C5 FD 10 0D ?? ?? ?? ?? 33 DB C5 E5 59 3D ?? ?? ?? ?? C5 C5 58 D1 C5 ED 5C E9 C5 D9 73 F2 3F C4 E3 7D 19 D7 01 C5 D5 59 15 ?? ?? ?? ?? C5 F1 73 F7 3F C5 E5 5C DA C4 E3 5D 18 E1 01 C5 D5 59 0D ?? ?? ?? ?? C5 E5 5C D1 C5 D5 59 1D ?? ?? ?? ?? C5 D5 59 2D ?? ?? ?? ?? C5 ED 5C FB C5 C5 5C CD C5 F5 59 D1 C5 F5 57 CC C5 ED 59 25 ?? ?? ?? ?? C5 DD 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 FA C5 C5 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 FA C5 C5 58 1D ?? ?? ?? ?? C5 E5 59 E2 C5 DD 58 2D ?? ?? ?? ?? C5 D5 59 D2 C5 ED 59 D1 C5 ED 58 C9 C5 F5 57 CE 85 DB 75 10 C5 FD 28 C1 81 C4 B8 02 00 00 5B 5F 8B E5 5D C3 C5 FD 11 04 24 C5 FD 11 4C 24 40 74 E3 33 FF 0F A3 FB 72 0E 47 83 FF 20 7C F5 C5 FD 10 4C 24 40 EB CE C5 F8 77 8D 44 FC 40 8D 14 FC 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FD 11 74 24 20 BF 00 00 F0 7F C5 FD 10 35 ?? ?? ?? ?? C5 FD 11 1C 24 C5 FD 11 44 24 40 C5 F9 6E D7 C5 CD 54 E3 C5 DD C2 CE 00 C5 F9 70 E2 11 C4 E3 7D 19 CF 01 C5 F0 C6 EF DD C5 F8 50 DD C5 D9 DB C3 C4 E3 7D 19 DD 01 C5 F1 73 D0 34 C5 D9 DB F5 C5 E9 73 D6 34 C5 F9 7E D0 C5 F9 7E C9 C5 F8 11 9C 24 C0 00 00 00 C5 F8 11 AC 24 D0 00 00 00 C4 E3 79 16 D7 02 8D 04 40 C4 E3 79 16 CA 02 8D 0C 49 C5 FA 7E 04 C5 ?? ?? ?? ?? C5 FA 7E 24 CD ?? ?? ?? ?? C5 FA 7E 14 CD ?? ?? ?? ?? 8D 3C 7F C5 F9 16 34 FD ?? ?? ?? ?? 8D 14 52 C5 D9 16 04 D5 ?? ?? ?? ?? C5 E9 16 24 D5 ?? ?? ?? ?? C5 FA 7E 14 C5 ?? ?? ?? ?? C5 F9 11 A4 24 00 01 00 00 C5 E9 16 24 FD ?? ?? ?? ?? C5 F9 11 A4 24 10 01 00 00 C5 FA 7E 3C CD ?? ?? ?? ?? C5 FA 6F 25 ?? ?? ?? ?? C5 FA 7E 0C C5 ?? ?? ?? ?? C5 D9 DB D3 C5 C1 16 3C D5 ?? ?? ?? ?? C5 D9 DB ED C5 FA 6F 1D ?? ?? ?? ?? B8 00 00 00 80 C5 FA 6F 25 ?? ?? ?? ?? C5 F1 16 0C FD ?? ?? ?? ?? C5 F9 11 BC 24 E0 00 00 00 C5 E9 D4 D3 C5 D1 D4 DB C5 C1 DB EC C5 C1 73 D0 20 C5 FA 7F BC 24 40 01 00 00 C5 C1 73 D1 20 C5 F1 DB CC C5 F9 DB C4 C5 FA 7F 8C 24 70 01 00 00 C5 F9 10 8C 24 00 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 80 01 00 00 C5 F9 10 8C 24 10 01 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 90 01 00 00 C5 F1 73 D2 20 C5 FA 7F 8C 24 A0 01 00 00 C5 F1 73 D3 20 C5 E1 DB DC C5 E9 DB D4 C5 F9 11 B4 24 F0 00 00 00 C5 C9 DB F4 C5 FA 7F BC 24 50 01 00 00 C5 E1 F4 FF C5 FA 7F B4 24 30 01 00 00 C5 E1 F4 F6 C5 FA 7F AC 24 20 01 00 00 C5 E9 F4 ED C5 FA 7F BC 24 00 02 00 00 C5 E9 F4 F8 C5 FA 7F B4 24 E0 01 00 00 C5 E9 F4 B4 24 40 01 00 00 C5 FA 7F 84 24 60 01 00 00 C5 FA 7F AC 24 D0 01 00 00 C5 D9 DB AC 24 00 01 00 00 C5 FA 6F 84 24 A0 01 00 00 C5 FA 7F BC 24 10 02 00 00 C5 FA 7F B4 24 F0 01 00 00 C5 F9 F4 F5 C5 C1 DB EC C5 FA 6F BC 24 80 01 00 00 C5 C9 73 D6 20 C5 FA 7F 94 24 B0 01 00 00 C5 E9 F4 D7 C5 F9 F4 C7 C5 C1 73 D2 20 C5 F9 D4 C7 C5 FA 7F 9C 24 C0 01 00 00 C5 E1 F4 9C 24 70 01 00 00 C5 D1 D4 F8 C5 C9 D4 EF C5 D9 DB B4 24 10 01 00 00 C5 FA 7F 9C 24 20 02 00 00 C5 F1 F4 D6 C5 E1 DB F4 C5 FA 6F 9C 24 90 01 00 00 C5 C1 73 D2 20 C5 F1 F4 C3 C5 E1 F4 9C 24 C0 01 00 00 C5 E9 73 D3 20 C5 F9 D4 C2 C5 C9 D4 F0 C5 FA 6F 84 24 A0 01 00 00 C5 C1 D4 D6 C5 F9 F4 B4 24 60 01 00 00 C5 FA 6F 9C 24 10 02 00 00 C5 E1 73 D3 20 C5 C9 D4 F3 C5 D9 DB BC 24 F0 01 00 00 C5 C1 D4 FE C5 F1 F4 B4 24 70 01 00 00 C5 FA 6F 9C 24 20 02 00 00 C5 E1 73 D3 20 C5 FA 7F AC 24 30 02 00 00 C5 D1 73 D5 20 C5 C9 D4 F3 C5 D1 D4 FF C5 D9 DB AC 24 00 02 00 00 C5 E1 73 D7 20 C5 D1 D4 EE C5 F9 F4 B4 24 40 01 00 00 C5 FA 7F 94 24 40 02 00 00 C5 E9 73 D2 20 C5 E9 D4 ED C5 FA 6F 94 24 F0 01 00 00 C5 E9 73 D2 20 C5 C9 D4 F2 C5 F1 F4 94 24 50 01 00 00 C5 FA 7F BC 24 50 02 00 00 C5 D9 DB BC 24 D0 01 00 00 C5 C1 D4 FE C5 E1 D4 F7 C5 FA 6F 9C 24 00 02 00 00 C5 E1 73 D3 20 C5 E9 D4 D3 C5 D9 DB BC 24 E0 01 00 00 C5 E1 73 D6 20 C5 C1 D4 FA C5 FA 7F AC 24 60 02 00 00 C5 D1 73 D5 20 C5 D1 D4 D7 C5 F9 10 AC 24 E0 00 00 00 C5 C9 DB F4 C5 C1 73 D5 20 C5 C1 F4 AC 24 B0 01 00 00 C5 F9 F4 BC 24 20 01 00 00 C5 FA 6F 84 24 D0 01 00 00 C5 D1 DB EC C5 F9 73 D0 20 C5 C1 D4 F8 C5 D1 D4 EF C5 E1 D4 DD C5 C1 73 F3 20 C5 D1 73 D2 20 C5 C1 D4 DE C5 F9 10 B4 24 F0 00 00 00 C5 E9 DB D4 C5 C1 73 D6 20 C5 C1 F4 84 24 C0 01 00 00 C5 F1 F4 B4 24 30 01 00 00 C5 FA 6F 8C 24 E0 01 00 00 C5 F9 DB FC C5 F1 73 D1 20 C5 C9 D4 C1 C5 C1 D4 F8 C5 D1 D4 EF C5 C9 73 F5 20 C5 C9 D4 CA C5 FA 6F B4 24 50 02 00 00 C5 FA 6F 94 24 60 02 00 00 C5 C1 73 F6 20 C5 F9 6E F0 C5 F9 73 F2 20 C5 D9 DB AC 24 30 02 00 00 C5 D9 DB A4 24 40 02 00 00 C5 F9 70 D6 11 C5 E9 DB B4 24 D0 00 00 00 C5 C1 D4 ED C5 F9 D4 FC C5 E9 DB A4 24 C0 00 00 00 C5 FA 6F 15 ?? ?? ?? ?? C5 FA 7F 9C 24 70 02 00 00 C5 E1 73 D3 0C C5 D9 EF C2 C5 C9 EF D2 C5 FA 7F 8C 24 80 02 00 00 C5 F1 73 D1 0C C5 E1 EB D8 C5 F1 EB CA C4 E3 65 18 D1 01 C4 E2 7D 1A 1D ?? ?? ?? ?? C5 E5 58 CA C5 F5 5C C3 C5 ED 5C D8 C5 FD 11 5C 24 60 C5 F8 10 1D ?? ?? ?? ?? C5 F1 DB D3 C4 E3 7D 19 C8 01 C5 FA 7F 94 24 90 02 00 00 C5 F8 54 CB C5 FA 6F 15 ?? ?? ?? ?? C5 FA 6F 05 ?? ?? ?? ?? C5 D9 EF DA C5 F8 11 8C 24 A0 02 00 00 C5 C9 EF CA C5 F9 DB D5 C5 F9 DB C7 C5 E9 73 F2 1C C5 F9 73 F0 1C C5 E9 EB D3 C5 F9 EB C1 C5 D1 73 D5 18 C5 C1 73 D7 18 C4 E3 6D 18 D0 01 C4 E3 65 18 C9 01 C5 ED 5C D1 C5 FA 6F 0D ?? ?? ?? ?? C5 D9 EF D9 C5 C9 EF C9 C5 FA 6F 35 ?? ?? ?? ?? C5 C9 DB A4 24 70 02 00 00 C5 C9 DB B4 24 80 02 00 00 C5 F9 73 F4 28 C5 F9 EB ED C5 F9 73 F6 28 C5 F9 EB F7 C5 D1 EB E3 C5 C9 EB F9 C4 E3 5D 18 EF 01 C5 FD 10 64 24 60 C4 E3 65 18 C9 01 C5 D5 5C F1 C5 DD 58 C6 C5 DD 5C C8 C5 CD 58 F9 C5 C5 58 F2 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 FD 54 FA C5 FD 5C C7 C4 E2 7D 1A 2D ?? ?? ?? ?? C4 E2 7D 1A 1D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C5 E5 59 D7 C5 E5 59 C8 C5 DD 59 DF C5 D5 59 EE C5 DD 59 C0 C5 F5 58 F3 C5 D5 58 C8 C5 CD 58 D9 C5 ED 58 EB C5 ED 5C FD C5 C5 58 C3 C5 FD 10 1C 24 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 E5 54 E2 C4 E2 7D 1A 0D ?? ?? ?? ?? C5 DD C2 F1 1E C5 DD C2 F9 12 C5 CD 54 ED C5 CD 54 C0 C5 FA 6F B4 24 90 02 00 00 C5 C5 54 D3 C5 F8 10 9C 24 A0 02 00 00 C5 F9 7E F2 C5 F9 7E D8 C5 FD 11 84 24 80 00 00 00 C1 E2 05 C4 E3 79 16 F1 02 C4 E3 79 16 DF 02 C5 ED 56 ED C1 E0 05 C1 E1 05 C1 E7 05 C5 FA 7E 8A ?? ?? ?? ?? C5 FA 7E 90 ?? ?? ?? ?? C5 F1 16 B9 ?? ?? ?? ?? C5 FA 7E A2 ?? ?? ?? ?? C5 E9 16 87 ?? ?? ?? ?? C5 FA 7E 88 ?? ?? ?? ?? C5 D9 16 B1 ?? ?? ?? ?? C5 FA 7E 9A ?? ?? ?? ?? C5 E1 16 91 ?? ?? ?? ?? C4 E3 45 18 C0 01 C5 F1 16 BF ?? ?? ?? ?? C4 E3 4D 18 E7 01 C5 FA 7E B0 ?? ?? ?? ?? C5 C9 16 8F ?? ?? ?? ?? C5 FD 59 FD C4 E3 6D 18 D9 01 C5 D5 59 CC C5 FC 11 9C 24 A0 00 00 00 C5 E5 58 D1 C5 C5 58 F2 C5 E5 5C DA C5 E5 58 D9 C5 ED 5C CE C5 D5 59 D5 C5 F5 58 FF C5 C5 58 CB C5 ED 59 3D ?? ?? ?? ?? C5 C5 58 1D ?? ?? ?? ?? C5 E5 59 FA C5 C5 59 DD C5 FD 58 FC C5 ED 59 25 ?? ?? ?? ?? C5 E5 59 C7 C5 FD 58 D9 C5 DD 58 0D ?? ?? ?? ?? C5 F5 59 C2 C5 FD 58 25 ?? ?? ?? ?? C5 FC 10 84 24 A0 00 00 00 C5 DD 59 D2 C5 D5 59 E8 C5 ED 59 C8 C5 FA 7E 82 ?? ?? ?? ?? C5 F9 16 91 ?? ?? ?? ?? C5 C5 5C FD C5 F5 58 CB C5 FA 7E 98 ?? ?? ?? ?? C5 E1 16 A7 ?? ?? ?? ?? C5 C5 59 BC 24 80 00 00 00 C4 E3 6D 18 EC 01 C5 C5 58 C5 C5 F5 58 C8 C5 FD 10 44 24 40 C5 CD 58 F1 C5 CD 57 4C 24 20 E9 C4 F7 FF FF 8B FF }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "___avx_cos4"
		size = 2352
		refs = "0012 ___common_dcos_data 0149 ___common_dcos_cout_rare 0156 ___common_dcos_data_ha 01d2 ___common_dcos_reduction_data 025a _2il0floatpacket_267 0262 _2il0floatpacket_268 0272 _2il0floatpacket_269 05ee _2il0floatpacket_270 0632 _2il0floatpacket_271 0646 _2il0floatpacket_272 0662 _2il0floatpacket_274 0680 _2il0floatpacket_273 06c0 _2il0floatpacket_275 06d0 _2il0floatpacket_276 072b _2il0floatpacket_280 073c _2il0floatpacket_277 0745 _2il0floatpacket_278 074e _2il0floatpacket_279 0788 _2il0floatpacket_281 0795 _2il0floatpacket_282"
	strings:
		$1 = { 55 8B EC 83 E4 C0 57 53 81 EC 78 02 00 00 C5 FD 58 2D ?? ?? ?? ?? C5 D5 54 35 ?? ?? ?? ?? C5 CD C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CB 01 C5 F0 C6 E3 DD C5 F8 50 C4 85 C0 0F 85 14 01 00 00 C5 FD 10 3D ?? ?? ?? ?? 33 DB C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 DF C5 E5 5C E7 C5 DD 5C 2D ?? ?? ?? ?? C5 D5 59 0D ?? ?? ?? ?? C5 D9 73 F3 3F C4 E3 7D 19 DB 01 C5 E1 73 F3 3F C4 E3 5D 18 E3 01 C5 D5 59 1D ?? ?? ?? ?? C5 FD 5C DB C5 E5 5C D9 C5 D5 59 0D ?? ?? ?? ?? C5 E5 5C D9 C5 D5 59 0D ?? ?? ?? ?? C5 E5 5C D9 C5 E5 59 CB C5 F5 59 2D ?? ?? ?? ?? C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 E9 C5 D5 58 2D ?? ?? ?? ?? C5 D5 59 C9 C5 F5 59 CB C5 F5 58 CB C5 F5 57 CC 85 DB 75 10 C5 FD 28 C1 81 C4 78 02 00 00 5B 5F 8B E5 5D C3 C5 FD 11 04 24 C5 FD 11 4C 24 40 74 E3 33 FF 0F A3 FB 72 0E 47 83 FF 20 7C F5 C5 FD 10 4C 24 40 EB CE C5 F8 77 8D 44 FC 40 8D 14 FC 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FD 10 25 ?? ?? ?? ?? BF 00 00 F0 7F C5 FD 11 04 24 C5 F9 6E FF C5 DD 54 CE C5 F5 C2 CC 00 C4 E3 7D 19 C5 01 C5 F8 11 AC 24 90 00 00 00 C4 E3 7D 19 CE 01 C5 F0 C6 DE DD C5 F9 70 CF 11 C5 F8 50 DB C5 F8 28 D0 C5 F1 DB E2 C5 C9 73 D4 34 C5 F1 DB CD C5 F9 7E F1 C5 E1 73 D1 34 C5 F9 7E D8 C5 F8 11 94 24 80 00 00 00 C4 E3 79 16 F2 02 8D 0C 49 C4 E3 79 16 DF 02 8D 04 40 C5 FA 7E 0C CD ?? ?? ?? ?? C5 FA 7E 24 C5 ?? ?? ?? ?? C5 FA 7E 1C CD ?? ?? ?? ?? 8D 14 52 C5 F1 16 3C D5 ?? ?? ?? ?? 8D 3C 7F C5 FA 7E 0C C5 ?? ?? ?? ?? C5 F1 16 34 FD ?? ?? ?? ?? C5 FA 7E 0C CD ?? ?? ?? ?? C5 F1 16 04 D5 ?? ?? ?? ?? C5 D9 16 0C FD ?? ?? ?? ?? C5 E1 16 24 D5 ?? ?? ?? ?? C5 FA 7E 1C C5 ?? ?? ?? ?? B8 00 00 00 80 C5 F9 11 A4 24 C0 00 00 00 C5 E1 16 24 FD ?? ?? ?? ?? C5 F9 11 A4 24 D0 00 00 00 C5 FA 6F 25 ?? ?? ?? ?? C5 FA 6F 1D ?? ?? ?? ?? C5 D9 DB D2 C5 D9 DB ED C5 FA 6F 25 ?? ?? ?? ?? C5 F9 11 BC 24 A0 00 00 00 C5 E9 D4 D3 C5 D1 D4 DB C5 C1 DB EC C5 C1 73 D0 20 C5 FA 7F BC 24 00 01 00 00 C5 C1 73 D1 20 C5 F1 DB CC C5 F9 DB C4 C5 FA 7F 8C 24 30 01 00 00 C5 F9 10 8C 24 C0 00 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 40 01 00 00 C5 F9 10 8C 24 D0 00 00 00 C5 F1 73 D1 20 C5 FA 7F 8C 24 50 01 00 00 C5 F1 73 D2 20 C5 F9 11 B4 24 B0 00 00 00 C5 C9 DB F4 C5 FA 7F 8C 24 60 01 00 00 C5 F1 73 D3 20 C5 E1 DB DC C5 E9 DB D4 C5 FA 7F B4 24 F0 00 00 00 C5 E1 F4 F6 C5 FA 7F B4 24 A0 01 00 00 C5 E9 F4 B4 24 00 01 00 00 C5 FA 7F AC 24 E0 00 00 00 C5 E9 F4 ED C5 FA 7F BC 24 10 01 00 00 C5 E1 F4 FF C5 FA 7F 84 24 20 01 00 00 C5 FA 7F B4 24 B0 01 00 00 C5 FA 7F AC 24 90 01 00 00 C5 E9 F4 E8 C5 D9 DB B4 24 C0 00 00 00 C5 FA 6F 84 24 60 01 00 00 C5 FA 7F BC 24 C0 01 00 00 C5 F9 F4 FE C5 C9 73 D7 20 C5 FA 6F BC 24 40 01 00 00 C5 FA 7F 94 24 70 01 00 00 C5 E9 F4 D7 C5 F9 F4 C7 C5 C1 73 D2 20 C5 F9 D4 C7 C5 FA 7F AC 24 D0 01 00 00 C5 D1 DB EC C5 D1 D4 E8 C5 FA 7F 9C 24 80 01 00 00 C5 E1 F4 9C 24 30 01 00 00 C5 C9 D4 FD C5 D9 DB B4 24 D0 00 00 00 C5 F1 F4 C6 C5 E1 DB F4 C5 FA 7F 9C 24 E0 01 00 00 C5 D1 73 D0 20 C5 FA 6F 9C 24 50 01 00 00 C5 F1 F4 C3 C5 E1 F4 9C 24 80 01 00 00 C5 E9 73 D3 20 C5 F9 D4 DA C5 C9 D4 F3 C5 FA 6F 84 24 60 01 00 00 C5 D1 D4 D6 C5 F9 F4 B4 24 20 01 00 00 C5 FA 7F BC 24 F0 01 00 00 C5 D1 73 D7 20 C5 FA 6F BC 24 D0 01 00 00 C5 C1 73 D7 20 C5 C9 D4 F7 C5 D9 DB 9C 24 B0 01 00 00 C5 E1 D4 DE C5 F1 F4 B4 24 30 01 00 00 C5 D1 D4 FB C5 FA 6F 9C 24 E0 01 00 00 C5 E1 73 D3 20 C5 C9 D4 F3 C5 D9 DB AC 24 C0 01 00 00 C5 D1 D4 EE C5 F9 F4 B4 24 00 01 00 00 C5 FA 7F 94 24 00 02 00 00 C5 E9 73 D2 20 C5 E9 D4 ED C5 FA 6F 94 24 B0 01 00 00 C5 E9 73 D2 20 C5 C9 D4 F2 C5 F1 F4 94 24 10 01 00 00 C5 D9 DB 9C 24 90 01 00 00 C5 E1 D4 DE C5 FA 7F BC 24 10 02 00 00 C5 C1 73 D7 20 C5 C1 D4 F3 C5 FA 6F BC 24 C0 01 00 00 C5 C1 73 D7 20 C5 E9 D4 D7 C5 D9 DB 9C 24 A0 01 00 00 C5 C1 73 D6 20 C5 E1 D4 DA C5 FA 7F AC 24 20 02 00 00 C5 D1 73 D5 20 C5 D1 D4 D3 C5 F9 10 AC 24 A0 00 00 00 C5 C9 DB F4 C5 E1 73 D5 20 C5 E1 F4 AC 24 70 01 00 00 C5 F9 F4 9C 24 E0 00 00 00 C5 FA 6F 84 24 90 01 00 00 C5 D1 DB EC C5 F9 73 D0 20 C5 E1 D4 D8 C5 D1 D4 EB C5 C1 D4 FD C5 E1 73 F7 20 C5 C1 73 D2 20 C5 E1 D4 DE C5 F9 10 B4 24 B0 00 00 00 C5 E9 DB D4 C5 D1 73 D6 20 C5 D1 F4 84 24 80 01 00 00 C5 F1 F4 AC 24 F0 00 00 00 C5 FA 6F 8C 24 A0 01 00 00 C5 F9 DB F4 C5 F1 73 D1 20 C5 D1 D4 C1 C5 C9 D4 F0 C5 C1 D4 FE C5 FA 6F B4 24 10 02 00 00 C5 F1 73 F7 20 C5 FA 6F 84 24 20 02 00 00 C5 D1 73 F6 20 C5 F9 6E F0 C5 D9 DB BC 24 F0 01 00 00 C5 D9 DB A4 24 00 02 00 00 C5 F1 D4 CA C5 D1 D4 EF C5 E9 73 F0 20 C5 F9 70 C6 11 C5 E9 D4 FC C5 F9 DB A4 24 80 00 00 00 C5 FA 6F 15 ?? ?? ?? ?? C5 FA 7F 9C 24 30 02 00 00 C5 E1 73 D3 0C C5 F9 DB B4 24 90 00 00 00 C5 D9 EF C2 C5 FA 7F 8C 24 40 02 00 00 C5 E1 EB D8 C5 F1 73 D1 0C C5 C9 EF C2 C5 F1 EB C8 C4 E3 65 18 D9 01 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 ED 58 CB C5 F5 5C C2 C5 E5 5C D0 C5 F8 10 05 ?? ?? ?? ?? C5 FD 11 54 24 20 C4 E3 7D 19 CB 01 C5 F1 DB C8 C5 E0 54 D0 C5 FA 6F 05 ?? ?? ?? ?? C5 FA 7F 8C 24 50 02 00 00 C5 F8 11 94 24 60 02 00 00 C5 F9 DB D5 C5 FA 6F 0D ?? ?? ?? ?? C5 F9 DB C7 C5 D9 EF D9 C5 E9 73 F2 1C C5 C9 EF C9 C5 F9 73 F0 1C C5 E9 EB D3 C5 F9 EB C1 C5 D1 73 D5 18 C5 C1 73 D7 18 C4 E3 6D 18 C0 01 C4 E3 65 18 C9 01 C5 FD 5C D1 C5 FA 6F 0D ?? ?? ?? ?? C5 D9 EF D9 C5 C9 EF C9 C5 FA 6F 25 ?? ?? ?? ?? C5 D9 DB B4 24 30 02 00 00 C5 C9 73 F6 28 C5 D9 DB A4 24 40 02 00 00 C5 C9 EB F5 C5 C9 EB EB C5 C9 73 F4 28 C5 C9 EB F7 C5 C9 EB F9 C5 FD 10 64 24 20 C4 E3 55 18 EF 01 C4 E3 65 18 C9 01 C5 D5 5C C9 C5 DD 58 C1 C5 DD 5C F0 C5 F5 58 DE C5 E5 58 F2 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 FD 54 FA C5 FD 5C C7 C4 E2 7D 1A 2D ?? ?? ?? ?? C4 E2 7D 1A 0D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C5 F5 59 D7 C5 F5 59 D8 C5 DD 59 CF C5 D5 59 EE C5 DD 59 C0 C5 E5 58 C9 C5 D5 58 F0 C5 F5 58 EE C5 ED 58 FD C5 ED 5C DF C5 E5 58 F5 C5 FD 10 2C 24 C4 E2 7D 1A 05 ?? ?? ?? ?? C5 D5 54 E0 C4 E2 7D 1A 15 ?? ?? ?? ?? C5 DD C2 CA 1E C5 DD C2 DA 12 C5 F5 54 FF C5 F5 54 CE C5 FD 11 4C 24 40 C5 FA 6F B4 24 50 02 00 00 C5 F8 10 8C 24 60 02 00 00 C5 F9 7E F2 C5 F9 7E C8 C1 E2 05 C4 E3 79 16 F1 02 C4 E3 79 16 CF 02 C5 E5 54 C5 C1 E0 05 C1 E1 05 C1 E7 05 C5 FA 7E A2 ?? ?? ?? ?? C5 FA 7E B0 ?? ?? ?? ?? C5 D9 16 91 ?? ?? ?? ?? C5 C9 16 9F ?? ?? ?? ?? C5 FA 7E AA ?? ?? ?? ?? C5 FA 7E A0 ?? ?? ?? ?? C5 FD 56 FF C5 D1 16 81 ?? ?? ?? ?? C5 D9 16 8F ?? ?? ?? ?? C5 FA 7E A0 ?? ?? ?? ?? C4 E3 6D 18 F3 01 C5 FA 7E 9A ?? ?? ?? ?? C5 E1 16 A9 ?? ?? ?? ?? C4 E3 7D 18 D1 01 C5 D9 16 8F ?? ?? ?? ?? C5 CD 59 E7 C5 FC 11 54 24 60 C4 E3 55 18 E9 01 C5 C5 59 DD C5 CD 58 ED C5 ED 58 C3 C5 DD 58 C8 C5 ED 5C D0 C5 ED 58 D3 C5 FD 5C D9 C5 E5 58 C4 C5 FD 58 E2 C5 C5 59 C7 C5 FD 59 15 ?? ?? ?? ?? C5 ED 58 1D ?? ?? ?? ?? C5 E5 59 D0 C5 ED 59 DF C5 E5 59 F5 C5 CD 58 DC C5 FD 59 35 ?? ?? ?? ?? C5 CD 58 15 ?? ?? ?? ?? C5 ED 59 E0 C5 FC 10 54 24 60 C5 DD 58 35 ?? ?? ?? ?? C5 FA 7E A0 ?? ?? ?? ?? C5 C5 59 FA C5 CD 59 C0 C5 FD 59 F2 C5 FA 7E 82 ?? ?? ?? ?? C5 F9 16 91 ?? ?? ?? ?? C5 CD 58 F3 C5 D5 5C DF C5 D9 16 AF ?? ?? ?? ?? C5 E5 59 5C 24 40 C4 E3 6D 18 FD 01 C5 E5 58 C7 C5 CD 58 F0 C5 FD 10 04 24 C5 F5 58 CE E9 DF F7 FF FF 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "__EH_prolog2"
		size = 56
	strings:
		$1 = { 51 8B 4C 24 08 89 5C 24 08 8D 5C 24 08 F7 D9 23 E1 8B 4B F8 89 2C 24 8B EC 6A FF 50 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 51 8B 43 FC 8B 4B 04 89 4D 04 59 50 F2 C3 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "___sse2_acos2"
		size = 528
		refs = "001a _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 30 01 00 00 83 E4 F0 89 84 24 F4 00 00 00 66 0F 28 C8 66 0F 28 05 ?? ?? ?? ?? 66 0F 57 D2 66 0F C2 D1 05 66 0F 29 94 24 C0 00 00 00 66 0F 54 C1 66 0F 28 D9 66 0F 55 1D ?? ?? ?? ?? 66 0F 29 9C 24 B0 00 00 00 66 0F 29 44 24 10 66 0F 55 C1 66 0F 28 E0 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 3D ?? ?? ?? ?? 66 0F 29 04 24 66 0F 5C F8 66 0F 59 C0 66 0F 59 3D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 FC 66 0F 55 D0 66 0F 56 D7 66 0F 51 F7 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 D8 66 0F C2 DD 00 66 0F 29 5C 24 20 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 84 24 B0 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 56 4C 24 10 66 0F 28 DC 66 0F 54 CC 66 0F 55 D8 66 0F 56 CB 66 0F 29 4C 24 70 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 54 8C 24 C0 00 00 00 66 0F 28 DC 66 0F 54 CC 66 0F 55 D8 66 0F 56 CB 66 0F 29 8C 24 80 00 00 00 66 0F 28 CA 66 0F 59 D2 66 0F 28 C2 66 0F 59 05 ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 EC 66 0F 55 2C 24 66 0F 54 F4 66 0F 56 F5 66 0F 29 74 24 40 66 0F 28 6C 24 20 66 0F 28 74 24 20 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 DA 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 C8 66 0F 58 CB 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 9C 24 C0 00 00 00 66 0F 59 4C 24 40 66 0F 58 4C 24 40 66 0F 59 4C 24 70 66 0F 58 8C 24 80 00 00 00 66 0F 54 EB 66 0F 55 F1 66 0F 56 F5 66 0F 28 C6 66 0F 28 C6 8B A4 24 F4 00 00 00 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "___sse4_floor2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "___avx_asin4"
		size = 480
		refs = "0010 ___common_dasin_data 01c9 ___common_dasin_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 2D ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C5 FD 11 04 24 C5 D5 54 F0 C5 CD 59 E7 C5 CD 59 CE C5 CD C2 15 ?? ?? ?? ?? 1D C5 C5 5C E4 C5 CD C2 FF 15 C5 D5 55 E8 C5 FD 11 6C 24 20 C5 F5 5D EC C5 FD 5A CC C5 DD 58 E4 C4 E3 7D 19 D3 01 C5 E8 C6 C3 DD C5 F8 52 D1 C5 F8 50 D0 C5 FC 5A DA C5 E5 59 C3 C5 DD 59 CB C5 DD 59 E0 C5 DD 5C 05 ?? ?? ?? ?? C5 FD 59 15 ?? ?? ?? ?? C5 F5 59 E0 C5 ED 58 1D ?? ?? ?? ?? C5 E5 59 D0 C5 ED 58 1D ?? ?? ?? ?? C5 D5 59 15 ?? ?? ?? ?? C5 E5 59 C0 C5 ED 58 15 ?? ?? ?? ?? C5 FD 58 05 ?? ?? ?? ?? C5 FD 59 E4 C5 D5 59 05 ?? ?? ?? ?? C5 DD 5C C9 C5 FD 58 05 ?? ?? ?? ?? C5 D5 59 25 ?? ?? ?? ?? C5 FD 11 4C 24 40 C5 D5 59 0D ?? ?? ?? ?? C5 DD 58 1D ?? ?? ?? ?? C5 D5 59 E5 C5 F5 58 0D ?? ?? ?? ?? C5 E5 59 DC C5 E5 58 D8 C5 F5 59 C4 C5 FD 58 CA C5 DD 59 D4 C5 D5 59 05 ?? ?? ?? ?? C5 E5 59 D2 C5 FD 58 05 ?? ?? ?? ?? C5 ED 58 C9 C5 F5 59 DC C5 E5 58 C8 C5 D5 59 05 ?? ?? ?? ?? C5 F5 59 E4 C5 FD 58 15 ?? ?? ?? ?? C5 DD 58 C2 C5 FD 59 ED C4 E3 4D 4B 44 24 40 70 C5 D5 59 F0 C5 CD 58 C8 C5 C5 54 15 ?? ?? ?? ?? C5 F5 58 DA C5 E5 57 44 24 20 85 D2 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 84 24 80 00 00 00 C5 FD 11 4C 24 40 74 E6 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 80 00 00 00 EB BC C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "___avx_logf8"
		size = 352
		refs = "0015 ___common_slog_data 0150 ___common_slog_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 11 04 24 C5 F8 10 1D ?? ?? ?? ?? C5 F8 10 3D ?? ?? ?? ?? C5 F9 FA F3 C4 E3 7D 19 C1 01 C5 E9 72 E6 17 C5 F1 FA E3 C5 C9 DB F7 C5 D1 72 E4 17 C5 D9 DB FF C4 E3 6D 18 D5 01 C5 C9 FE EB C5 C1 FE DB C5 F8 10 35 ?? ?? ?? ?? C5 FC 5B D2 C5 EC 59 15 ?? ?? ?? ?? C4 E3 55 18 E3 01 C5 F8 10 2D ?? ?? ?? ?? C5 F9 FE C5 C5 F1 FE CD C5 C9 66 F8 C5 C9 66 D9 C5 C1 6B C3 C5 DC 5C 1D ?? ?? ?? ?? C5 F1 EF C9 C5 F9 63 E9 C5 F9 D7 D5 C5 E4 59 25 ?? ?? ?? ?? C5 DC 58 35 ?? ?? ?? ?? C5 CC 59 C3 C5 FC 58 0D ?? ?? ?? ?? C5 F4 59 E3 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 F3 C5 CC 58 3D ?? ?? ?? ?? C5 C4 59 C3 C5 FC 58 0D ?? ?? ?? ?? C5 F4 59 E3 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 F3 C5 CC 59 FB C5 C4 58 DB C5 EC 58 C3 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB BA C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "___common_dpow_cout_rare"
		size = 2736
		refs = "0191 __vmldPowHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 6C 8B 55 08 8B 75 0C 0F B6 42 07 F2 0F 10 16 0F B6 7E 07 0F B7 76 06 81 E7 80 00 00 00 0F B7 5A 06 81 E6 F0 7F 00 00 89 44 24 18 81 E3 F0 7F 00 00 25 80 00 00 00 F2 0F 10 0A C1 EB 04 C1 EE 04 C1 E8 07 C1 EF 07 8B 0A F2 0F 11 54 24 60 89 44 24 20 F7 42 04 FF FF 0F 00 75 0E 85 C9 75 0A C7 44 24 10 01 00 00 00 EB 08 C7 44 24 10 00 00 00 00 8B 54 24 60 8B 44 24 64 89 54 24 24 25 FF FF 0F 00 75 12 83 7C 24 24 00 75 0B BA 01 00 00 00 89 54 24 14 EB 08 C7 44 24 14 00 00 00 00 8B D6 33 C9 C1 E2 14 0B D0 B8 01 00 00 00 81 FE FF 07 00 00 0F 45 C8 8B 44 24 24 89 4C 24 1C 0B C2 74 70 81 FE FF 03 00 00 8D 8E 01 FC FF FF 7C 19 83 7C 24 1C 00 74 12 83 F9 14 7F 27 8B C2 D3 E0 C1 E0 0C 0B 44 24 24 74 04 33 D2 EB 4A 8D 8E 0C FC FF FF D3 E2 F7 D2 81 E2 00 00 00 80 C1 EA 1F 42 EB 34 83 F9 35 7D 2A 8B 44 24 24 8D 8E 0C FC FF FF D3 E0 89 44 24 24 A9 FF FF FF 7F 74 04 33 D2 EB 14 F7 D0 25 00 00 00 80 C1 E8 1F 8D 50 01 EB 05 BA 02 00 00 00 83 7C 24 20 00 75 0C 81 FB FF 03 00 00 0F 84 3E 09 00 00 85 F6 75 0B 83 7C 24 14 00 0F 85 A9 03 00 00 33 C0 B9 01 00 00 00 81 FB FF 07 00 00 0F 45 C1 8B 4C 24 10 0B C8 0F 84 82 03 00 00 8B 4C 24 14 0B 4C 24 1C 0F 84 74 03 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2E C8 7A 06 0F 84 B6 08 00 00 66 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 84 08 00 00 85 C0 0F 84 FE 02 00 00 83 7C 24 1C 00 0F 84 F3 02 00 00 66 0F 2F C8 77 08 85 D2 0F 84 B9 02 00 00 23 54 24 20 8B 44 24 18 83 E0 7F F2 0F 11 4C 24 10 85 DB F2 0F 10 04 D5 ?? ?? ?? ?? 88 44 24 17 75 1B F2 0F 10 4C 24 10 BB 38 FF FF FF F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 10 EB 08 F2 0F 10 4C 24 10 33 DB F2 0F 11 4C 24 30 0F B7 44 24 16 25 F0 7F 00 00 0F B7 54 24 36 81 E2 0F 80 FF FF C1 E8 04 81 CA F0 3F FF FF 8B 4C 24 14 66 89 54 24 36 81 E1 FF FF 0F 00 C1 E0 14 0B C1 8B 4C 24 34 05 00 40 18 C0 81 E1 00 C0 0F 00 81 C1 00 40 00 00 C1 E9 0F F2 0F 10 74 24 30 F2 0F 11 44 24 48 0F 28 EE C1 F8 14 F2 0F 10 3C CD ?? ?? ?? ?? 03 C3 0F 28 C7 F2 0F 59 C6 F2 0F 2A C8 F2 0F 11 44 24 38 8B 5C 24 3C 81 E3 00 FC 00 00 81 C3 00 04 00 00 C1 EB 0B C1 E1 04 F2 0F 10 1C DD ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 89 ?? ?? ?? ?? F2 0F 59 FB F2 0F 11 44 24 40 8B 54 24 44 81 E2 F0 0F 00 00 F2 0F 10 1D ?? ?? ?? ?? 83 C2 10 C1 EA 05 F2 0F 59 EB F2 0F 10 24 D5 ?? ?? ?? ?? F2 0F 11 6C 24 50 F2 0F 59 C4 F2 0F 59 FC F2 0F 10 64 24 50 F2 0F 11 5C 24 20 C1 E3 04 F2 0F 5C 64 24 30 F2 0F 58 8B ?? ?? ?? ?? F2 0F 11 64 24 58 F2 0F 10 64 24 50 F2 0F 10 6C 24 58 C1 E2 04 F2 0F 5C E5 F2 0F 58 8A ?? ?? ?? ?? F2 0F 11 64 24 50 F2 0F 10 6C 24 50 F2 0F 10 93 ?? ?? ?? ?? F2 0F 5C F5 F2 0F 58 92 ?? ?? ?? ?? F2 0F 11 74 24 58 0F 28 F7 F2 0F 59 F3 F2 0F 58 91 ?? ?? ?? ?? F2 0F 10 64 24 50 F2 0F 10 6C 24 58 F2 0F 11 74 24 50 F2 0F 10 5C 24 50 F2 0F 11 54 24 28 0F 28 D0 F2 0F 5C DF F2 0F 5C 15 ?? ?? ?? ?? F2 0F 11 5C 24 58 F2 0F 10 5C 24 50 F2 0F 10 74 24 58 F2 0F 5C DE F2 0F 11 5C 24 50 0F 28 DC F2 0F 10 74 24 50 F2 0F 5C FE F2 0F 11 7C 24 58 F2 0F 10 7C 24 50 F2 0F 59 DF F2 0F 59 FD F2 0F 5C D8 0F 28 C1 F2 0F 58 DF F2 0F 58 C2 F2 0F 10 74 24 58 F2 0F 11 44 24 50 F2 0F 10 44 24 50 F2 0F 59 E6 F2 0F 5C C8 F2 0F 59 EE F2 0F 58 CA F2 0F 58 DC F2 0F 11 4C 24 58 F2 0F 58 DD F2 0F 10 6C 24 50 F2 0F 11 6C 24 18 0F B7 44 24 1E 25 F0 7F 00 00 C1 E8 04 03 F0 F2 0F 10 4C 24 58 81 FE 09 08 00 00 F2 0F 10 44 24 48 0F 8D BF 05 00 00 81 FE C0 07 00 00 0F 8F 05 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 33 C0 F2 0F 11 4C 24 50 F2 0F 10 54 24 50 F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 54 24 50 F2 0F 10 5C 24 50 F2 0F 59 C3 E9 C1 00 00 00 F2 0F 11 44 24 50 B8 01 00 00 00 F2 0F 10 4C 24 50 F2 0F 10 44 24 50 F2 0F 5E C8 F2 0F 11 4C 24 50 F2 0F 10 44 24 50 E9 95 00 00 00 81 FB FF 03 00 00 7D 13 33 C0 85 FF 0F 84 83 00 00 00 0F 28 C2 F2 0F 59 C2 EB 7A 33 C0 85 FF 74 0F 23 54 24 20 F2 0F 59 04 D5 ?? ?? ?? ?? EB 65 F2 0F 59 C9 F2 0F 59 D1 23 54 24 20 0F 28 C2 F2 0F 59 04 D5 ?? ?? ?? ?? EB 4B 0F 28 C1 33 C0 F2 0F 58 C2 EB 40 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 CA F2 0F 11 4C 24 50 F2 0F 11 44 24 58 0F B6 74 24 57 0F B6 44 24 5F 83 E6 80 83 E0 7F 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 10 4C 24 58 F2 0F 59 C1 8B 55 10 F2 0F 11 02 83 C4 6C 5B 5F 5E 8B E5 5D C3 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D3 F2 0F 58 D9 F2 0F 59 E2 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 10 54 24 28 F2 0F 58 EC F2 0F 58 D3 F2 0F 11 6C 24 50 0F 28 EA F2 0F 10 7C 24 50 F2 0F 10 5C 24 18 F2 0F 5C DF F2 0F 58 DC F2 0F 11 5C 24 58 F2 0F 10 74 24 50 F2 0F 10 5C 24 58 F2 0F 58 EE F2 0F 11 6C 24 50 F2 0F 10 4C 24 50 F2 0F 5C F1 F2 0F 58 F2 F2 0F 10 54 24 20 F2 0F 11 74 24 58 F2 0F 10 74 24 50 F2 0F 59 D6 F2 0F 10 7C 24 58 F2 0F 11 54 24 50 F2 0F 58 FB F2 0F 10 64 24 50 F2 0F 59 7C 24 60 F2 0F 5C E6 F2 0F 11 64 24 58 F2 0F 10 54 24 50 F2 0F 10 6C 24 58 F2 0F 5C D5 F2 0F 11 54 24 50 F2 0F 10 4C 24 50 F2 0F 5C F1 F2 0F 10 4C 24 60 0F 28 D9 F2 0F 59 1D ?? ?? ?? ?? F2 0F 11 74 24 58 F2 0F 10 64 24 50 F2 0F 10 6C 24 58 F2 0F 11 5C 24 50 F2 0F 10 74 24 50 F2 0F 5C 74 24 60 F2 0F 11 74 24 58 F2 0F 10 5C 24 50 F2 0F 10 54 24 58 F2 0F 5C DA F2 0F 11 5C 24 50 F2 0F 10 74 24 50 F2 0F 5C CE F2 0F 11 4C 24 58 F2 0F 10 4C 24 50 F2 0F 10 74 24 58 0F 28 D9 0F 28 D6 F2 0F 59 D5 F2 0F 59 CD F2 0F 59 DC F2 0F 59 E6 F2 0F 58 D1 F2 0F 58 D4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 E3 F2 0F 58 FA F2 0F 11 64 24 50 F2 0F 10 6C 24 50 8B 54 24 50 8B C2 83 E2 7F F2 0F 5C 2D ?? ?? ?? ?? F2 0F 11 2C 24 F2 0F 10 0C 24 C1 E2 04 F2 0F 5C D9 F2 0F 11 5C 24 08 F2 0F 10 54 24 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 FA F2 0F 59 CF F2 0F 10 92 ?? ?? ?? ?? C1 F8 07 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 CA F2 0F 58 8A ?? ?? ?? ?? 0F 28 E1 F2 0F 58 E2 F2 0F 11 64 24 10 0F B7 54 24 16 8B CA 81 E1 F0 7F 00 00 C1 E9 04 8D 8C 08 01 FC FF FF 81 F9 00 04 00 00 0F 8D 2E 02 00 00 81 F9 02 FC FF FF 7C 33 81 C1 FF 03 00 00 81 E2 0F 80 FF FF 81 E1 FF 07 00 00 33 C0 C1 E1 04 0B D1 66 89 54 24 16 F2 0F 10 4C 24 10 F2 0F 59 C1 F2 0F 11 44 24 10 E9 6F FD FF FF 81 F9 F8 FB FF FF 0F 8C 1C 01 00 00 F2 0F 11 64 24 50 05 C8 00 00 00 F2 0F 10 5C 24 50 05 FF 03 00 00 F2 0F 10 64 24 20 25 FF 07 00 00 0F B7 15 ?? ?? ?? ?? F2 0F 5C D3 F2 0F 59 05 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 11 54 24 58 81 E2 0F 80 FF FF F2 0F 10 5C 24 50 F2 0F 59 E3 F2 0F 10 54 24 58 F2 0F 11 64 24 50 F2 0F 10 6C 24 50 C1 E0 04 F2 0F 5C EB F2 0F 11 6C 24 58 0B D0 F2 0F 10 7C 24 50 33 C0 F2 0F 10 74 24 58 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C FE F2 0F 11 7C 24 50 F2 0F 10 4C 24 50 F2 0F 11 6C 24 18 F2 0F 5C D9 F2 0F 11 5C 24 58 F2 0F 10 4C 24 50 F2 0F 10 64 24 58 66 89 54 24 1E F2 0F 58 D4 F2 0F 10 74 24 18 F2 0F 59 CE F2 0F 59 D6 F2 0F 59 C8 F2 0F 59 C2 F2 0F 11 44 24 50 F2 0F 10 44 24 50 F2 0F 58 C8 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 44 24 50 F2 0F 10 5C 24 50 F2 0F 10 54 24 50 F2 0F 59 DA F2 0F 11 5C 24 50 F2 0F 10 64 24 50 F2 0F 58 CC 0F 28 C1 F2 0F 11 44 24 10 E9 47 FC FF FF 81 F9 C4 FB FF FF 0F 8C 84 00 00 00 05 C7 04 00 00 25 FF 07 00 00 0F B7 15 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 81 E2 0F 80 FF FF C1 E0 04 F2 0F 11 54 24 18 0B D0 66 89 54 24 1E 33 C0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 5C 24 18 F2 0F 59 C1 F2 0F 59 E3 F2 0F 59 C4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 64 24 50 F2 0F 10 6C 24 50 F2 0F 10 74 24 50 F2 0F 59 F5 F2 0F 11 74 24 50 F2 0F 10 7C 24 50 F2 0F 58 C7 F2 0F 11 44 24 10 E9 B7 FB FF FF F2 0F 10 0D ?? ?? ?? ?? 33 C0 F2 0F 11 4C 24 50 F2 0F 10 54 24 50 F2 0F 10 5C 24 50 F2 0F 59 DA F2 0F 11 5C 24 50 F2 0F 10 64 24 50 F2 0F 59 C4 F2 0F 11 44 24 10 E9 7C FB FF FF F2 0F 10 0D ?? ?? ?? ?? 33 C0 F2 0F 11 4C 24 50 F2 0F 10 5C 24 50 F2 0F 10 54 24 50 F2 0F 59 DA F2 0F 11 5C 24 50 F2 0F 10 64 24 50 F2 0F 59 C4 F2 0F 11 44 24 10 E9 41 FB FF FF 0F B6 44 24 1F 25 80 00 00 00 C1 E8 07 33 F8 33 C0 F2 0F 10 0C FD ?? ?? ?? ?? F2 0F 59 C9 F2 0F 59 C8 0F 28 C1 E9 17 FB FF FF 85 D2 75 0B 83 7C 24 1C 00 0F 85 6D F7 FF FF 83 E2 01 33 C0 F2 0F 10 04 D5 ?? ?? ?? ?? E9 F5 FA FF FF F2 0F 59 C9 85 FF 74 1B 23 54 24 20 B8 01 00 00 00 F2 0F 10 04 D5 ?? ?? ?? ?? F2 0F 5E C1 E9 D2 FA FF FF 23 54 24 20 33 C0 F2 0F 10 04 D5 ?? ?? ?? ?? F2 0F 59 C1 E9 BA FA FF FF 83 7C 24 10 00 0F 84 B7 F6 FF FF E9 6A FA FF FF 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "___avx_ceil4"
		size = 16
	strings:
		$1 = { C4 E3 7D 09 C0 02 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "___common_dacos_cout_rare"
		size = 2672
		refs = "0042 __vmldACosHATab 09cb _2il0floatpacket_190"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 5C 8B 4D 08 0F B7 41 06 25 F0 7F 00 00 F2 0F 10 09 3D F0 7F 00 00 0F B6 51 07 0F 84 08 0A 00 00 F2 0F 11 4C 24 40 83 E2 7F 88 54 24 47 F2 0F 10 64 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C4 0F 86 69 09 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F CC 0F 86 3A 04 00 00 66 0F 2F 25 ?? ?? ?? ?? 0F 86 D4 03 00 00 F2 0F 10 1D ?? ?? ?? ?? 0F 28 D4 F2 0F 59 D3 F2 0F 11 54 24 38 F2 0F 10 44 24 38 F2 0F 11 64 24 08 F2 0F 5C 44 24 40 F2 0F 11 44 24 30 0F 28 C4 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 0F 28 D4 F2 0F 10 7C 24 38 F2 0F 5C C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 44 24 38 0F 28 C8 F2 0F 58 D0 F2 0F 59 C8 F2 0F 10 74 24 30 0F 28 E9 F2 0F 59 D6 F2 0F 58 EA F2 0F 59 FD F2 0F 11 6C 24 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD 0F 28 EB F2 0F 59 E9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 6C 24 38 F2 0F 11 7C 24 18 F2 0F 10 7C 24 38 F2 0F 5C F9 F2 0F 11 7C 24 30 F2 0F 10 7C 24 38 F2 0F 10 6C 24 30 F2 0F 5C FD F2 0F 11 7C 24 38 F2 0F 10 6C 24 38 F2 0F 5C CD F2 0F 11 4C 24 30 F2 0F 10 4C 24 38 F2 0F 10 7C 24 30 F2 0F 59 F1 F2 0F 58 D7 F2 0F 59 C1 F2 0F 59 E2 F2 0F 58 E6 0F 28 F3 F2 0F 59 F0 F2 0F 11 74 24 38 F2 0F 10 6C 24 38 F2 0F 5C E8 F2 0F 11 6C 24 30 0F 28 E8 F2 0F 10 7C 24 38 F2 0F 58 C4 F2 0F 10 74 24 30 F2 0F 59 D0 F2 0F 5C FE F2 0F 11 7C 24 38 F2 0F 10 74 24 38 F2 0F 5C EE F2 0F 11 6C 24 30 0F 28 E9 F2 0F 10 74 24 38 F2 0F 59 EE F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 7C 24 20 F2 0F 58 FC F2 0F 11 5C 24 38 F2 0F 10 5C 24 38 F2 0F 59 CF F2 0F 5C DD F2 0F 11 5C 24 30 0F 28 DD F2 0F 10 7C 24 38 F2 0F 58 CA F2 0F 10 54 24 30 F2 0F 58 E9 F2 0F 5C FA F2 0F 11 7C 24 38 F2 0F 10 54 24 38 F2 0F 10 7C 24 18 F2 0F 5C DA F2 0F 11 5C 24 30 F2 0F 10 5C 24 38 F2 0F 10 54 24 30 F2 0F 11 54 24 28 F2 0F 10 54 24 10 F2 0F 59 D5 F2 0F 59 FA F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 6C 24 08 F2 0F 58 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D7 F2 0F 59 E0 F2 0F 59 F0 F2 0F 58 D4 F2 0F 10 64 24 20 F2 0F 59 E0 0F 28 C5 F2 0F 58 C6 F2 0F 58 D4 F2 0F 11 44 24 38 F2 0F 10 64 24 38 F2 0F 11 34 24 F2 0F 5C EC F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 CF F2 0F 59 DF F2 0F 59 7C 24 28 F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 10 74 24 30 F2 0F 58 D6 F2 0F 58 D1 0F 28 CC F2 0F 58 CB F2 0F 58 D7 F2 0F 11 4C 24 38 F2 0F 10 44 24 38 F2 0F 5C E0 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 44 24 38 F2 0F 10 09 F2 0F 10 5C 24 30 66 0F 2F 0D ?? ?? ?? ?? F2 0F 58 D3 76 47 F2 0F 10 25 ?? ?? ?? ?? 0F 28 CC F2 0F 5C C8 F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 5C CA F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 44 24 30 F2 0F 58 C8 EB 45 F2 0F 10 25 ?? ?? ?? ?? 0F 28 C8 F2 0F 58 CC F2 0F 11 4C 24 38 F2 0F 10 5C 24 38 F2 0F 5C E3 F2 0F 58 E0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 11 64 24 30 F2 0F 10 5C 24 38 F2 0F 10 4C 24 30 F2 0F 58 CA 8B 45 0C F2 0F 58 D9 F2 0F 11 18 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 44 24 38 F2 0F 10 44 24 38 F2 0F 59 44 24 40 F2 0F 11 04 24 0F B6 44 24 07 0F B6 49 07 83 E0 7F 83 E1 80 0B C1 88 44 24 07 33 C0 8B 55 0C F2 0F 5C 0C 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0A 83 C4 5C 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B F0 81 E6 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C DC F2 0F 59 CB F2 0F 11 0C 24 0F B7 54 24 06 81 E2 F0 7F 00 00 C1 EA 04 81 C2 01 FC FF FF 8B DA F7 DB 81 C3 FF 03 00 00 81 E3 FF 07 00 00 C1 E3 04 0B F3 66 89 74 24 0E 8B F2 F2 0F 59 4C 24 08 83 E6 01 0F 28 E9 8B FE F2 0F 10 35 ?? ?? ?? ?? F2 0F 58 E9 75 03 0F 28 E9 F2 0F 59 F5 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 10 0F 28 FE 8B 5C 24 10 2B D6 C1 E7 08 81 E3 FF 01 00 00 03 DF F2 0F 5C FD F2 0F 11 7C 24 30 F2 0F 10 64 24 30 F2 0F 10 14 DD ?? ?? ?? ?? F2 0F 5C F4 0F 28 FA 0F 28 E5 F2 0F 59 FA 0F 28 CE F2 0F 5C E6 F2 0F 59 F2 F2 0F 59 CF F2 0F 59 FC F2 0F 5C C8 D1 EA F2 0F 58 CF F2 0F 10 3D ?? ?? ?? ?? 81 C2 FF 03 00 00 F2 0F 59 F9 81 E2 FF 07 00 00 C1 E2 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 0B C2 F2 0F 11 44 24 18 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 FA F2 0F 59 D4 F2 0F 59 FD F2 0F 58 FA F2 0F 10 15 ?? ?? ?? ?? 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 38 F2 0F 10 44 24 38 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C C6 F2 0F 58 2D ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 64 24 38 F2 0F 10 4C 24 30 F2 0F 5C E1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 64 24 38 F2 0F 10 44 24 38 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C F0 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 44 24 30 F2 0F 11 74 24 28 0F 28 F1 F2 0F 59 E3 F2 0F 58 F8 F2 0F 58 35 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 F4 F2 0F 59 C3 F2 0F 59 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 EE F2 0F 59 C3 0F 28 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 40 F2 0F 58 E8 F2 0F 59 FD F2 0F 11 7C 24 48 0F 28 FA F2 0F 59 FB F2 0F 11 7C 24 38 F2 0F 10 44 24 38 F2 0F 5C C3 F2 0F 11 44 24 30 F2 0F 10 74 24 38 F2 0F 10 6C 24 30 F2 0F 5C F5 F2 0F 11 74 24 38 F2 0F 10 7C 24 38 F2 0F 5C E7 F2 0F 11 64 24 30 F2 0F 10 64 24 38 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 30 F2 0F 11 5C 24 38 F2 0F 10 74 24 38 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 30 F2 0F 10 74 24 38 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 38 F2 0F 10 5C 24 38 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 30 F2 0F 10 74 24 38 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 58 DE F2 0F 11 5C 24 38 F2 0F 11 6C 24 50 F2 0F 10 6C 24 38 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 30 0F 28 E5 F2 0F 10 5C 24 38 F2 0F 10 74 24 30 F2 0F 58 E3 F2 0F 11 64 24 38 F2 0F 10 64 24 38 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 30 F2 0F 10 64 24 38 F2 0F 59 D4 F2 0F 10 5C 24 30 F2 0F 11 54 24 38 F2 0F 10 54 24 38 F2 0F 5C D4 F2 0F 11 54 24 30 F2 0F 10 54 24 38 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 38 F2 0F 10 6C 24 38 F2 0F 5C E5 F2 0F 11 64 24 30 F2 0F 10 6C 24 38 F2 0F 10 54 24 30 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F2 0F 10 31 F2 0F 58 D3 66 0F 2F 35 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 10 4C 24 50 F2 0F 58 C8 F2 0F 10 44 24 28 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 58 64 24 40 F2 0F 10 4C 24 48 F2 0F 59 E0 F2 0F 58 CA F2 0F 59 C5 F2 0F 58 CC 77 4D F2 0F 10 25 ?? ?? ?? ?? 0F 28 D4 F2 0F 10 35 ?? ?? ?? ?? F2 0F 5C D0 F2 0F 5C F1 F2 0F 11 54 24 38 F2 0F 10 5C 24 38 F2 0F 11 04 24 F2 0F 5C E3 F2 0F 5C E0 F2 0F 11 64 24 30 F2 0F 10 44 24 38 F2 0F 10 6C 24 30 0F 28 CD F2 0F 58 CE 8B 45 0C F2 0F 58 C1 F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 66 0F 2E C8 7A 02 74 50 0F 57 05 ?? ?? ?? ?? 66 0F 2E C8 7A 02 74 1E 8B 45 0C F2 0F 5C C9 F2 0F 5E C9 F2 0F 11 08 B8 01 00 00 00 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 8B 45 0C F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 00 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 F2 0F 5E C9 8B 45 0C F2 0F 11 08 F7 41 04 FF FF 0F 00 75 17 BA 01 00 00 00 33 C0 83 39 00 0F 44 C2 83 C4 5C 5B 5F 5E 8B E5 5D C3 33 C0 83 C4 5C 5B 5F 5E 8B E5 5D C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_262_1_0 {
	meta:
		name = "__EH_epilog3_align"
		size = 23
	strings:
		$1 = { 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5F 5E 8B E5 5D 8B E3 5B 51 F2 C3 }
	condition:
		$1
}

rule file_262_2_0 {
	meta:
		name = "__EH_prolog3_GS_align"
		size = 110
		refs = "0041 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 F4 50 8B 43 FC 89 6C 24 10 8D 6C 24 10 C7 44 24 0C FF FF FF FF 23 CC 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 41 FC 8B 4D F0 89 5D F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_262_3_0 {
	meta:
		name = "__EH_prolog3_align"
		size = 99
		refs = "003f ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 FC 8B 4B F4 89 6C 24 0C 8D 6C 24 0C C7 44 24 08 FF FF FF FF 53 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_262_4_0 {
	meta:
		name = "__EH_prolog3_catch_GS_align"
		size = 111
		refs = "0042 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 F4 50 8B 43 FC 89 6C 24 10 8D 6C 24 10 C7 44 24 0C FF FF FF FF 53 23 CC 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 41 FC 8B 4D F0 89 65 F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_262_5_0 {
	meta:
		name = "__EH_prolog3_catch_align"
		size = 103
		refs = "0040 ___security_cookie"
	strings:
		$1 = { 51 8B 4C 24 0C 89 5C 24 0C 8D 5C 24 0C 50 8D 44 24 08 F7 D9 23 C1 8D 60 F8 8B 43 F0 89 04 24 8B 43 F8 50 8B 43 FC 8B 4B F4 89 6C 24 0C 8D 6C 24 0C C7 44 24 08 FF FF FF FF 51 53 2B E0 56 57 A1 ?? ?? ?? ?? 33 C5 50 89 65 F0 8B 43 04 89 45 04 FF 75 F4 64 A1 00 00 00 00 89 45 F4 8D 45 F4 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "___sse2_expf4"
		size = 544
		refs = "0012 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 3D ?? ?? ?? ?? 89 4C 24 34 0F 28 0D ?? ?? ?? ?? 89 5C 24 30 0F 54 F8 0F 28 15 ?? ?? ?? ?? 0F 59 C8 0F 28 1D ?? ?? ?? ?? 0F 58 CA 0F 5C D1 66 0F 66 3D ?? ?? ?? ?? 0F 59 DA 66 0F 7E C8 0F 59 15 ?? ?? ?? ?? 0F 29 44 24 20 66 0F 6F E9 66 0F 6F F1 66 0F 73 D1 1D 0F 58 C3 66 0F FE 2D ?? ?? ?? ?? 66 0F 7E CB 0F 58 C2 66 0F 70 CE EE 83 E0 3F 0F 28 35 ?? ?? ?? ?? 0F 59 F0 66 0F 7E C9 81 E3 F8 01 00 00 83 E1 3F F3 0F 7E 1C C5 ?? ?? ?? ?? 66 0F 73 D1 1D F3 0F 7E A3 ?? ?? ?? ?? 90 0F 58 35 ?? ?? ?? ?? 66 0F 7E C8 F3 0F 7E 14 CD ?? ?? ?? ?? 25 F8 01 00 00 0F 14 DC F3 0F 7E 88 ?? ?? ?? ?? 66 0F 72 F5 11 0F 59 F0 0F 28 E3 66 0F DB 2D ?? ?? ?? ?? 0F 14 D1 0F 59 F0 8B 5C 24 30 0F 58 F0 0F C6 DA 44 8B 4C 24 34 0F C6 E2 EE 0F 28 C3 0F 58 DC 0F 59 F3 0F 50 C7 0F 58 F4 A9 0F 00 00 00 0F 58 C6 75 08 0F 59 C5 E9 F7 00 00 00 0F 29 44 24 10 0F 28 4C 24 20 0F 57 D2 0F 59 C5 0F C2 D1 03 B9 00 00 00 00 0F 50 DA 33 C3 0F 84 CB 00 00 00 0F 28 15 ?? ?? ?? ?? 0F 28 D8 0F C2 D1 02 0F 28 05 ?? ?? ?? ?? 0F 54 C2 0F 50 DA 0F 55 D3 33 C3 0F 56 C2 0F 84 A2 00 00 00 0F 28 D8 0F 28 C1 0F C2 05 ?? ?? ?? ?? 02 0F 50 D8 0F 55 C3 33 C3 0F 84 86 00 00 00 0F 50 D9 0F 29 04 24 A9 01 00 00 00 74 6B F7 C3 01 00 00 00 F3 0F 10 44 8C 20 0F 59 05 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 75 15 66 0F FE 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 66 0F EF F6 EB 1A 66 0F FE 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 66 0F FE 05 ?? ?? ?? ?? 0F 28 F5 66 0F 72 F0 11 66 0F DB 05 ?? ?? ?? ?? 66 0F FA C6 F3 0F 59 44 8C 10 F3 0F 59 C5 F3 0F 11 04 8C D1 EB 83 C1 01 D1 E8 75 85 0F 28 04 24 8B 5C 24 30 8B 4C 24 34 8B 64 24 54 C3 8D 64 24 00 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "___common_dcos_cout_rare"
		size = 128
		refs = "0049 __vmldCosHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 08 8B 55 08 0F B7 4A 06 81 E1 F0 7F 00 00 F2 0F 10 0A 0F B6 42 07 83 E0 7F F2 0F 11 0C 24 81 F9 F0 7F 00 00 75 3E 8B 55 0C 83 3C 24 00 75 27 88 44 24 07 81 7C 24 04 00 00 F0 7F 75 19 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 8B E5 5D C3 F2 0F 59 C9 33 C0 F2 0F 11 0A 8B E5 5D C3 33 C0 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "___common_dsin_cout_rare"
		size = 128
		refs = "0049 __vmldSinHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 08 8B 55 08 0F B7 4A 06 81 E1 F0 7F 00 00 F2 0F 10 0A 0F B6 42 07 83 E0 7F F2 0F 11 0C 24 81 F9 F0 7F 00 00 75 3E 8B 55 0C 83 3C 24 00 75 27 88 44 24 07 81 7C 24 04 00 00 F0 7F 75 19 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 8B E5 5D C3 F2 0F 59 C9 33 C0 F2 0F 11 0A 8B E5 5D C3 33 C0 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "___common_dexp_cout_rare"
		size = 912
		refs = "0011 __imldExpHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 4C 8B 45 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? F2 0F 10 00 0F B7 40 06 25 F0 7F 00 00 C1 E8 04 F2 0F 11 44 24 40 3D FF 07 00 00 0F 84 01 03 00 00 3D CA 03 00 00 0F 8E D9 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 82 A7 02 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 79 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F0 F2 0F 59 C8 F2 0F 11 4C 24 30 F2 0F 11 54 24 40 F2 0F 10 54 24 30 F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 54 24 38 F2 0F 10 5C 24 38 8B 74 24 38 8B C6 83 E6 3F F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 10 64 24 30 F2 0F 59 25 ?? ?? ?? ?? F2 0F 10 6C 24 30 F2 0F 5C F4 F2 0F 59 2D ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 DE C1 E6 04 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE C1 E8 06 F2 0F 58 1D ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? F2 0F 59 DE F2 0F 10 8E ?? ?? ?? ?? 8D 90 FF 03 00 00 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 59 DE F2 0F 58 DE F2 0F 58 9E ?? ?? ?? ?? F2 0F 59 D9 72 73 81 E2 FF 07 00 00 F2 0F 58 D9 81 FA FE 07 00 00 77 27 C1 E2 04 81 E1 0F 80 FF FF 0B CA 66 89 4C 24 46 F2 0F 59 5C 24 40 8B 45 0C F2 0F 11 18 33 C0 83 C4 4C 5E 8B E5 5D C3 4A 81 E2 FF 07 00 00 0F B7 44 24 46 C1 E2 04 25 0F 80 FF FF 0B C2 66 89 44 24 46 33 C0 F2 0F 59 5C 24 40 F2 0F 59 1D ?? ?? ?? ?? 8B 55 0C F2 0F 11 1A 83 C4 4C 5E 8B E5 5D C3 05 3B 04 00 00 25 FF 07 00 00 8B D0 0F B7 4C 24 46 C1 E2 04 81 E1 0F 80 FF FF 0B CA 66 89 4C 24 46 83 F8 32 F2 0F 10 54 24 40 F2 0F 59 DA F2 0F 59 D1 0F 28 C2 F2 0F 58 C3 77 14 F2 0F 59 05 ?? ?? ?? ?? 8B 45 0C F2 0F 11 00 E9 CC 00 00 00 F2 0F 11 04 24 F2 0F 10 04 24 8B 45 0C F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 08 F2 0F 10 14 24 F2 0F 59 15 ?? ?? ?? ?? F2 0F 11 54 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 58 E3 F2 0F 11 64 24 18 F2 0F 10 74 24 18 F2 0F 10 6C 24 10 F2 0F 5C F5 F2 0F 11 74 24 20 F2 0F 10 04 24 F2 0F 10 7C 24 20 F2 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 4C 24 08 F2 0F 10 54 24 28 F2 0F 58 D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 20 F2 0F 59 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 F2 0F 10 64 24 28 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 64 24 28 F2 0F 10 74 24 20 F2 0F 10 6C 24 28 F2 0F 58 F5 F2 0F 11 30 B8 04 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 04 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 4C 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 8B 45 0C F2 0F 58 C8 F2 0F 11 08 33 C0 83 C4 4C 5E 8B E5 5D C3 0F B6 44 24 47 A9 80 00 00 00 75 15 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 83 C4 4C 5E 8B E5 5D C3 F7 44 24 44 FF FF 0F 00 75 E1 83 7C 24 40 00 75 DA 8B 45 0C F2 0F 11 10 33 C0 83 C4 4C 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "___avx_log4"
		size = 416
		refs = "0010 ___common_dlog_data 018f ___common_dlog_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 54 2D ?? ?? ?? ?? C5 D5 56 1D ?? ?? ?? ?? C5 FD 5A CB C5 F8 53 F1 C5 FC 5A FE C5 E9 73 D0 14 C4 E3 7D 19 C4 01 C5 D1 73 D4 14 C5 FD C2 25 ?? ?? ?? ?? 11 C5 E8 C6 CD DD C5 FD C2 2D ?? ?? ?? ?? 16 C4 E3 7D 09 D7 00 C5 FE E6 F1 C5 DD 56 FD C5 E5 54 25 ?? ?? ?? ?? C5 E5 5C DC C4 E3 7D 19 FD 01 C5 C0 C6 CD DD C5 DD 59 EA C5 F8 50 C1 C5 E5 59 CA C5 D5 5C 1D ?? ?? ?? ?? C5 E5 58 E9 C5 C1 73 D2 28 C5 F9 7E FA C4 E3 79 16 F9 02 C4 E3 7D 19 D4 01 C5 D9 73 D4 28 C5 FB 10 9A ?? ?? ?? ?? C5 F9 7E E2 C5 E1 16 89 ?? ?? ?? ?? C5 ED C2 15 ?? ?? ?? ?? 1E C5 FB 10 BA ?? ?? ?? ?? C4 E3 79 16 E1 02 C5 ED 54 15 ?? ?? ?? ?? C5 C1 16 A1 ?? ?? ?? ?? C4 E3 75 18 DC 01 C5 ED 56 0D ?? ?? ?? ?? C5 CD 5C F1 C5 D5 59 0D ?? ?? ?? ?? C5 D5 59 25 ?? ?? ?? ?? C5 CD 59 15 ?? ?? ?? ?? C5 F5 58 35 ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 D5 59 CD C5 CD 59 F9 C5 C5 58 F4 C5 CD 59 C9 C5 D5 58 E9 C5 D5 58 DB C5 E5 58 CA 85 C0 75 08 C5 FD 28 C1 8B E5 5D C3 C5 FD 11 44 24 40 C5 FD 11 8C 24 80 00 00 00 74 E7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 8C 24 80 00 00 00 EB BD C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "__initialize_default_precision"
		size = 33
		refs = "000d __controlfp_s 001c ___scrt_fastfail"
	strings:
		$1 = { 68 00 00 03 00 68 00 00 01 00 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 01 C3 6A 07 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "__RTC_Initialize"
		size = 43
		refs = "0003 ___rtc_iaa 0008 ___rtc_izz 001a @_guard_check_icall@4"
	strings:
		$1 = { 53 56 BE ?? ?? ?? ?? BB ?? ?? ?? ?? 3B F3 73 18 57 8B 3E 85 FF 74 09 8B CF E8 ?? ?? ?? ?? FF D7 83 C6 04 3B F3 72 EA 5F 5E 5B C3 }
	condition:
		$1
}

rule file_276_1_0 {
	meta:
		name = "__RTC_Terminate"
		size = 43
		refs = "0003 ___rtc_taa 0008 ___rtc_tzz 001a @_guard_check_icall@4"
	strings:
		$1 = { 53 56 BE ?? ?? ?? ?? BB ?? ?? ?? ?? 3B F3 73 18 57 8B 3E 85 FF 74 09 8B CF E8 ?? ?? ?? ?? FF D7 83 C6 04 3B F3 72 EA 5F 5E 5B C3 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "___isa_available_init"
		size = 410
		refs = "0005 ___isa_available 0013 ___isa_enabled 001a _IsProcessorFeaturePresent@4 00c1 ___favor"
	strings:
		$1 = { 55 8B EC 83 25 ?? ?? ?? ?? 00 83 EC 28 53 33 DB 43 09 1D ?? ?? ?? ?? 6A 0A E8 ?? ?? ?? ?? 85 C0 0F 84 6D 01 00 00 83 65 F0 00 33 C0 83 0D ?? ?? ?? ?? 02 33 C9 56 57 89 1D ?? ?? ?? ?? 8D 7D D8 53 0F A2 8B F3 5B 89 07 89 77 04 89 4F 08 89 57 0C 8B 45 D8 8B 4D E4 89 45 F8 81 F1 69 6E 65 49 8B 45 E0 35 6E 74 65 6C 0B C8 8B 45 DC 6A 01 35 47 65 6E 75 0B C8 58 6A 00 59 53 0F A2 8B F3 5B 89 07 89 77 04 89 4F 08 89 57 0C 75 43 8B 45 D8 25 F0 3F FF 0F 3D C0 06 01 00 74 23 3D 60 06 02 00 74 1C 3D 70 06 02 00 74 15 3D 50 06 03 00 74 0E 3D 60 06 03 00 74 07 3D 70 06 03 00 75 11 8B 3D ?? ?? ?? ?? 83 CF 01 89 3D ?? ?? ?? ?? EB 06 8B 3D ?? ?? ?? ?? 83 7D F8 07 8B 45 E4 89 45 E8 8B 45 E0 89 45 FC 89 45 EC 7C 32 6A 07 58 33 C9 53 0F A2 8B F3 5B 8D 5D D8 89 03 89 73 04 89 4B 08 89 53 0C 8B 45 DC A9 00 02 00 00 89 45 F0 8B 45 FC 74 09 83 CF 02 89 3D ?? ?? ?? ?? 5F 5E A9 00 00 10 00 74 6D 83 0D ?? ?? ?? ?? 04 C7 05 ?? ?? ?? ?? 02 00 00 00 A9 00 00 00 08 74 55 A9 00 00 00 10 74 4E 33 C9 0F 01 D0 89 45 F4 89 55 F8 8B 45 F4 8B 4D F8 83 E0 06 33 C9 83 F8 06 75 33 85 C9 75 2F A1 ?? ?? ?? ?? 83 C8 08 C7 05 ?? ?? ?? ?? 03 00 00 00 F6 45 F0 20 A3 ?? ?? ?? ?? 74 12 83 C8 20 C7 05 ?? ?? ?? ?? 05 00 00 00 A3 ?? ?? ?? ?? 33 C0 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "___avx_powf8"
		size = 1488
		refs = "0041 ___common_spow_data 05bd ___common_spow_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC 80 02 00 00 C5 FC 11 4C 24 20 C5 FC 11 04 24 C4 E3 7D 19 C4 01 C5 FC 5A F4 C5 F8 28 D0 C4 E3 7D 19 C8 01 C5 FC 5A F8 C5 FC 5A D9 C5 FC 5A EA C5 FD 11 7C 24 60 C5 F8 10 3D ?? ?? ?? ?? C5 F9 DB C7 C5 F1 DB CF C5 FA 7F 84 24 10 02 00 00 C5 FA 7F 8C 24 00 02 00 00 C5 FD 11 5C 24 40 C5 F8 10 1D ?? ?? ?? ?? C5 E9 FA D3 C5 D9 FA E3 C5 FA 7F 94 24 E0 01 00 00 C5 FA 7F A4 24 F0 01 00 00 C5 FD 10 05 ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 D5 54 C8 C5 F5 56 DA C5 CD 54 E0 C5 FD 5A FB C5 DD 56 D2 C5 FD 5A E2 C5 F8 53 C7 C5 F8 53 FC C5 FC 5A C8 C5 FC 5A E7 C4 E3 7D 19 E8 01 C5 D1 73 D5 14 C5 F9 73 D0 14 C5 D0 C6 E8 DD C4 E3 7D 19 F7 01 C5 C9 73 D6 14 C5 F9 73 D7 14 C5 C8 C6 F8 DD C4 E3 7D 09 C1 00 C4 E3 7D 09 CC 00 C5 FE E6 F7 C5 FE E6 E5 C5 FD 10 3D ?? ?? ?? ?? C5 E5 59 D8 C5 ED 59 D1 C5 FD 11 B4 24 80 00 00 00 C5 E5 5C EF C5 ED 5C FF C5 FD 11 AC 24 A0 00 00 00 C5 FD 11 BC 24 C0 00 00 00 C5 D1 73 D0 28 C5 F9 7E E8 C4 E3 7D 19 C3 01 C4 E3 79 16 EA 02 C5 E1 73 D3 28 C5 F9 7E D9 C5 C1 73 D1 28 C4 E3 7D 19 CE 01 C5 E9 73 D6 28 C5 FB 10 B0 ?? ?? ?? ?? C4 E3 79 16 D8 02 C5 C9 16 B2 ?? ?? ?? ?? C5 F9 7E FA C5 FB 10 A9 ?? ?? ?? ?? C5 D1 16 98 ?? ?? ?? ?? C5 F9 7E D0 C5 FB 10 AA ?? ?? ?? ?? C4 E3 79 16 D2 02 C4 E3 79 16 F9 02 C4 E3 4D 18 F3 01 C5 FB 10 98 ?? ?? ?? ?? C5 E1 16 92 ?? ?? ?? ?? C5 FD 10 1D ?? ?? ?? ?? C5 D1 16 B9 ?? ?? ?? ?? C5 FD 10 2D ?? ?? ?? ?? C5 E5 C2 C0 11 C5 E5 C2 D9 11 C5 FD 54 CD C5 E5 54 C5 C5 FD 10 1D ?? ?? ?? ?? C5 FD 10 AC 24 A0 00 00 00 C5 F5 56 CB C5 DD 5C C9 C5 FD 10 A4 24 80 00 00 00 C5 FD 56 C3 C5 DD 5C D8 C4 E3 45 18 FA 01 C5 FD 10 15 ?? ?? ?? ?? C5 F5 59 E2 C5 E5 59 D2 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 1D ?? ?? ?? ?? C5 FD 11 A4 24 E0 00 00 00 C5 FD 11 94 24 00 01 00 00 C5 FD 10 94 24 C0 00 00 00 C5 F5 59 C5 C5 F5 59 E2 C5 FD 58 C3 C5 DD 58 CB C5 D5 59 DD C5 ED 59 E2 C5 FD 59 C3 C5 F5 59 CC C5 D5 58 E8 C5 ED 58 C1 C5 FD 10 0D ?? ?? ?? ?? C5 D5 58 F6 C5 FD 58 FF C5 CD 58 84 24 E0 00 00 00 C5 C5 58 B4 24 00 01 00 00 C5 FD 10 3D ?? ?? ?? ?? C5 FD 59 6C 24 40 C5 CD 59 54 24 60 C5 D5 59 E1 C5 ED 59 D9 C5 FD 11 A4 24 20 01 00 00 C5 FD 11 9C 24 40 01 00 00 C5 E5 5C CF C5 DD 5C E7 C5 FD 10 1D ?? ?? ?? ?? C5 DD 58 E3 C5 F5 58 FB C5 DD 5C CB C5 C5 5C DB C5 FD 11 A4 24 60 01 00 00 C5 FD 11 8C 24 A0 01 00 00 C5 FD 11 9C 24 C0 01 00 00 C5 F8 10 1D ?? ?? ?? ?? C5 FD 11 BC 24 80 01 00 00 C4 E3 7D 19 E8 01 C4 E3 7D 19 D6 01 C5 D0 C6 C0 DD C5 E8 C6 D6 DD C5 F8 10 35 ?? ?? ?? ?? C5 FA 6F AC 24 E0 01 00 00 C5 D1 66 CE C5 D1 76 E6 C5 FA 6F AC 24 00 02 00 00 C5 F1 EB E4 C5 D1 66 FB C5 D1 76 CB C5 C1 EB E9 C5 D9 EB CD C5 F8 10 2D ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 F8 54 C5 C5 F9 66 C4 C5 E8 54 D5 C5 F1 EB C8 C5 FA 6F 84 24 F0 01 00 00 C5 F9 66 FE C5 F9 76 F6 C5 C1 EB F6 C5 FA 6F BC 24 10 02 00 00 C5 C1 66 C3 C5 C1 76 DB C5 F9 EB C3 C5 C9 EB F0 C5 E9 66 C4 C5 C9 EB E0 C5 FD 10 AC 24 80 01 00 00 C5 E9 EF D2 C5 F1 6B CC C5 F1 63 DA C5 F9 10 0D ?? ?? ?? ?? C5 FD 10 A4 24 60 01 00 00 C5 F9 D7 C3 C5 D8 54 C1 C4 E3 7D 19 EE 01 C4 E3 7D 19 E7 01 C5 C8 54 D9 C5 F8 11 B4 24 40 02 00 00 C5 C0 54 D1 C5 F8 11 BC 24 20 02 00 00 C5 D9 73 D4 0B C5 FD 10 B4 24 20 01 00 00 C5 FD 10 BC 24 40 01 00 00 C5 F8 11 AC 24 30 02 00 00 C5 D0 54 E9 C5 F9 7E C1 C5 CD 5C 8C 24 A0 01 00 00 C5 C5 5C B4 24 C0 01 00 00 C5 FD 10 3D ?? ?? ?? ?? C4 E3 79 16 C2 02 C5 F5 59 CF C5 CD 59 F7 C5 FA 7E 3C CD ?? ?? ?? ?? C5 C1 16 3C D5 ?? ?? ?? ?? C5 F9 7E D1 C4 E3 79 16 D2 02 C5 FA 7E 04 CD ?? ?? ?? ?? C5 F9 7E E9 C5 F9 16 14 D5 ?? ?? ?? ?? C4 E3 79 16 EA 02 C5 FA 7E 04 CD ?? ?? ?? ?? C5 F9 7E D9 C5 F9 16 2C D5 ?? ?? ?? ?? C4 E3 79 16 DA 02 C4 E3 45 18 D2 01 C5 FA 7E 3C CD ?? ?? ?? ?? C5 C1 16 1C D5 ?? ?? ?? ?? C5 ED 59 C1 C5 FD 58 D2 C4 E3 55 18 DB 01 C5 E5 59 F6 C5 F8 10 AC 24 20 02 00 00 C5 C1 73 D5 0B C5 D1 73 F7 34 C5 CD 58 CB C5 E1 73 F4 34 C4 E3 7D 19 D0 01 C5 E9 D4 E3 C5 F9 D4 C5 C5 F8 10 94 24 30 02 00 00 C5 E1 73 D2 0B C5 F8 10 94 24 40 02 00 00 C5 C1 73 F3 34 C5 E1 73 D2 0B C4 E3 7D 19 CE 01 C4 E3 5D 18 C0 01 C5 D9 73 F3 34 C5 F1 D4 CF C5 C9 D4 F4 C5 FD 5A C0 C4 E3 75 18 CE 01 C5 FD 5A D1 C4 E3 7D 18 C2 01 84 C0 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 10 54 24 20 C5 FC 11 84 24 C0 00 00 00 C5 FC 11 4C 24 40 C5 FC 11 94 24 80 00 00 00 85 C0 74 D5 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 C0 00 00 00 EB AB C5 F8 77 8D 8C B4 C0 00 00 00 8D 54 B4 40 8D 84 B4 80 00 00 00 51 50 52 E8 ?? ?? ?? ?? 83 C4 0C EB C6 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "___common_sasin_cout_rare"
		size = 2528
		refs = "0040 __vmldASinHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 64 8B 55 08 0F B7 42 02 25 80 7F 00 00 F3 0F 10 12 3D 80 7F 00 00 0F 84 86 09 00 00 F3 0F 5A C2 F2 0F 11 44 24 40 80 64 24 47 7F F2 0F 10 4C 24 40 F2 0F 10 05 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 66 0F 2F C1 0F 82 3A 09 00 00 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F D1 0F 86 00 04 00 00 66 0F 2F 0D ?? ?? ?? ?? 0F 86 54 03 00 00 F2 0F 10 15 ?? ?? ?? ?? 0F 28 D9 F2 0F 59 DA 0F 28 F1 F2 0F 11 5C 24 30 F2 0F 10 6C 24 30 F2 0F 11 0C 24 8B 4D 0C F2 0F 5C 6C 24 40 F2 0F 11 6C 24 28 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 F2 0F 11 44 24 30 0F 28 C1 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 11 74 24 28 F2 0F 10 6C 24 30 0F 28 F5 F2 0F 58 C5 F2 0F 59 F5 F2 0F 10 64 24 28 0F 28 DE F2 0F 59 C4 F2 0F 58 D8 F2 0F 59 FB F2 0F 11 5C 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB 0F 28 DA F2 0F 59 DE F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 5C 24 30 F2 0F 11 7C 24 10 F2 0F 10 7C 24 30 F2 0F 5C FE F2 0F 11 7C 24 28 F2 0F 10 7C 24 30 F2 0F 10 5C 24 28 F2 0F 5C FB F2 0F 11 7C 24 30 F2 0F 10 5C 24 30 F2 0F 5C F3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 7C 24 28 F2 0F 59 E6 F2 0F 58 C7 F2 0F 59 EE F2 0F 59 C8 F2 0F 58 CC 0F 28 E2 F2 0F 59 E5 F2 0F 11 64 24 30 F2 0F 10 7C 24 30 F2 0F 5C FD F2 0F 11 7C 24 28 F2 0F 10 5C 24 30 F2 0F 10 64 24 28 F2 0F 5C DC 0F 28 E5 F2 0F 58 E9 F2 0F 11 5C 24 30 0F 28 DE F2 0F 10 7C 24 30 F2 0F 59 C5 F2 0F 5C E7 F2 0F 11 64 24 28 F2 0F 10 64 24 30 F2 0F 59 DC F2 0F 59 D3 F2 0F 10 7C 24 28 F2 0F 11 7C 24 18 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 59 F7 F2 0F 5C D3 F2 0F 11 54 24 28 F2 0F 58 F0 F2 0F 10 44 24 30 F2 0F 10 7C 24 28 F2 0F 5C C7 0F 28 FB F2 0F 58 DE F2 0F 11 44 24 30 F2 0F 10 54 24 30 F2 0F 5C FA F2 0F 11 7C 24 28 F2 0F 10 7C 24 08 F2 0F 59 FB F2 0F 10 44 24 30 F2 0F 10 54 24 28 F2 0F 11 54 24 20 F2 0F 10 54 24 10 F2 0F 59 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 0F 10 1C 24 F2 0F 58 FD F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 FA F2 0F 59 F5 F2 0F 59 C5 F2 0F 59 6C 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 E2 F2 0F 58 F9 F2 0F 10 4C 24 18 F2 0F 59 CA 0F 28 D3 F2 0F 58 D4 F2 0F 58 F9 F2 0F 11 54 24 30 F2 0F 10 4C 24 30 F2 0F 5C D9 F2 0F 58 DC F2 0F 11 5C 24 28 F2 0F 10 4C 24 30 F2 0F 10 64 24 28 F2 0F 58 FC F2 0F 58 FE 0F 28 F1 F2 0F 58 F0 F2 0F 58 FD F2 0F 11 74 24 30 F2 0F 10 64 24 30 F2 0F 5C CC F2 0F 58 C8 F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 0F 10 44 24 28 0F B6 52 03 F2 0F 58 F8 83 E2 80 F2 0F 58 F9 F2 0F 11 7C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 33 C0 F2 0F 5A 7C 24 38 F3 0F 11 39 83 C4 64 5B 5F 5E 8B E5 5D C3 66 0F 2F 0D ?? ?? ?? ?? 72 4A 8B 4D 0C F2 0F 58 C8 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 F2 0F 59 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 0F B6 52 03 83 E0 7F 83 E2 80 0B C2 88 44 24 3F 33 C0 F2 0F 5A 4C 24 38 F3 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 59 C9 F2 0F 11 4C 24 30 F2 0F 10 44 24 30 0F B6 52 03 83 E2 80 F2 0F 58 44 24 40 F2 0F 11 44 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F 33 C0 F2 0F 5A 4C 24 38 8B 4D 0C F3 0F 11 09 83 C4 64 5B 5F 5E 8B E5 5D C3 0F 28 D8 8B C8 81 E1 0F 80 FF FF 25 0F 80 FF FF F2 0F 11 44 24 08 F2 0F 5C D9 F2 0F 59 D3 F2 0F 11 14 24 0F B7 74 24 06 81 E6 F0 7F 00 00 C1 EE 04 81 C6 01 FC FF FF 8B FE F7 DF 81 C7 FF 03 00 00 81 E7 FF 07 00 00 C1 E7 04 0B CF 66 89 4C 24 0E 8B CE F2 0F 59 54 24 08 83 E1 01 0F 28 EA 8B D9 F2 0F 10 35 ?? ?? ?? ?? F2 0F 58 EA 75 03 0F 28 EA F2 0F 59 F5 F2 0F 58 15 ?? ?? ?? ?? 0F 28 FE 0F 28 E5 F2 0F 11 54 24 10 2B F1 8B 7C 24 10 F2 0F 5C FD C1 E3 08 81 E7 FF 01 00 00 03 FB F2 0F 11 7C 24 28 F2 0F 10 4C 24 28 D1 EE F2 0F 5C F1 F2 0F 10 0C FD ?? ?? ?? ?? 0F 28 D6 0F 28 F9 81 C6 FF 03 00 00 F2 0F 59 F9 F2 0F 5C E6 F2 0F 59 F1 F2 0F 59 D7 F2 0F 59 FC F2 0F 5C D0 81 E6 FF 07 00 00 F2 0F 58 D7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 FA C1 E6 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA 0B C6 F2 0F 11 44 24 18 66 89 44 24 1E F2 0F 10 44 24 18 F2 0F 59 F0 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 11 5C 24 20 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 F9 F2 0F 59 CC F2 0F 59 FD F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 F9 0F 28 EA F2 0F 59 EE F2 0F 59 F8 F2 0F 11 6C 24 30 F2 0F 10 64 24 30 F2 0F 5C E6 F2 0F 11 64 24 28 F2 0F 10 44 24 30 F2 0F 10 4C 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 5C C1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 E3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 6C 24 30 F2 0F 58 05 ?? ?? ?? ?? F2 0F 5C F5 F2 0F 59 C3 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 4C 24 28 F2 0F 11 74 24 40 F2 0F 58 F9 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 F1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 F4 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 EE F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 0F 28 F3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 C3 F2 0F 59 C3 F2 0F 11 44 24 48 F2 0F 58 E8 0F 28 C2 F2 0F 59 C3 F2 0F 59 FD F2 0F 11 44 24 30 F2 0F 11 7C 24 50 F2 0F 10 7C 24 30 F2 0F 5C FB F2 0F 11 7C 24 28 F2 0F 10 6C 24 30 F2 0F 10 44 24 28 F2 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 7C 24 30 F2 0F 5C F7 F2 0F 11 74 24 28 F2 0F 10 64 24 30 0F 28 EC 0F 28 C4 F2 0F 59 EC F2 0F 58 C3 F2 0F 59 E1 0F 28 DA F2 0F 59 DD F2 0F 10 7C 24 28 F2 0F 11 5C 24 30 F2 0F 10 74 24 30 F2 0F 59 CF F2 0F 5C F5 F2 0F 59 C7 F2 0F 11 74 24 28 F2 0F 10 74 24 30 F2 0F 10 5C 24 28 F2 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 5C 24 30 F2 0F 5C EB 0F 28 DC F2 0F 11 6C 24 28 F2 0F 10 74 24 30 F2 0F 59 35 ?? ?? ?? ?? F2 0F 10 6C 24 28 F2 0F 58 DE F2 0F 11 5C 24 30 F2 0F 11 6C 24 58 F2 0F 10 6C 24 30 F2 0F 11 74 24 10 F2 0F 5C E5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 58 E6 F2 0F 11 64 24 28 0F 28 E5 F2 0F 10 5C 24 30 F2 0F 10 74 24 28 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 64 24 30 F2 0F 5C EC F2 0F 58 EB F2 0F 11 6C 24 28 F2 0F 10 64 24 30 F2 0F 59 D4 F2 0F 10 5C 24 28 F2 0F 11 54 24 30 F2 0F 10 54 24 30 F2 0F 5C D4 F2 0F 11 54 24 28 F2 0F 10 54 24 30 F2 0F 10 6C 24 28 F2 0F 5C D5 F2 0F 11 54 24 30 F2 0F 10 6C 24 30 F2 0F 5C E5 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D6 F2 0F 58 D3 F2 0F 10 5C 24 20 F2 0F 59 E3 F2 0F 58 D1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 10 4C 24 58 F2 0F 59 E3 F2 0F 58 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 D1 F2 0F 58 64 24 48 F2 0F 10 44 24 40 F2 0F 59 D0 F2 0F 59 E0 F2 0F 59 C5 F2 0F 10 4C 24 50 F2 0F 58 CA F2 0F 10 15 ?? ?? ?? ?? 0F 28 F2 F2 0F 58 CC F2 0F 5C F0 F2 0F 11 74 24 30 F2 0F 10 7C 24 30 F2 0F 5C D7 F2 0F 5C D0 F2 0F 11 54 24 28 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 5C 24 30 F2 0F 5C D1 F2 0F 10 44 24 28 0F B6 52 03 F2 0F 58 D0 83 E2 80 F2 0F 58 DA F2 0F 11 5C 24 38 0F B6 44 24 3F 83 E0 7F 0B C2 88 44 24 3F F2 0F 5A 44 24 38 8B 45 0C F3 0F 11 00 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 8B 45 0C F3 0F 5C D2 F3 0F 5E D2 F3 0F 11 10 B8 01 00 00 00 83 C4 64 5B 5F 5E 8B E5 5D C3 F3 0F 5E D2 8B 45 0C B9 01 00 00 00 F3 0F 11 10 33 C0 F7 02 FF FF 7F 00 0F 44 C1 83 C4 64 5B 5F 5E 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 }
	condition:
		$1
}

rule file_282_1_0 {
	meta:
		name = "??__D@YGXPAX0IIP6EX00@ZP6EX0@Z@Z"
		size = 113
		refs = "0003 __sehtable$??__D@YGXPAX0IIP6EX00@ZP6EX0@Z@Z 0008 __SEH_prolog4 0027 @_guard_check_icall@4 0050 __SEH_epilog4 006c ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 88 5D E7 89 5D FC 33 C0 40 3B 5D 14 74 21 50 FF 75 0C 8B 4D 18 E8 ?? ?? ?? ?? 8B 4D 08 FF 55 18 8B 45 10 01 45 08 01 45 0C 43 89 5D E0 EB D7 88 45 E7 C7 45 FC FE FF FF FF E8 0E 00 00 00 E8 ?? ?? ?? ?? C2 18 00 8B 5D E0 8A 45 E7 84 C0 75 0F FF 75 1C 53 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "___common_spow_cout_rare"
		size = 2960
		refs = "0174 _2il0floatpacket_112 01be __vmlsPowHATab 01d9 _2il0floatpacket_113 0376 _2il0floatpacket_114 0384 _2il0floatpacket_115 04ca _2il0floatpacket_124 061f _2il0floatpacket_116 0637 _2il0floatpacket_117 0646 _2il0floatpacket_118 0652 _2il0floatpacket_119 0787 _2il0floatpacket_120 07aa _2il0floatpacket_121 07f0 _2il0floatpacket_122 07fc _2il0floatpacket_123 0944 _2il0floatpacket_126"
	strings:
		$1 = { 56 57 53 55 83 EC 30 8B 44 24 44 66 0F EF C0 8B 54 24 48 F3 0F 10 20 F3 0F 10 1A 0F 28 CC 8B 12 0F 28 D3 8B 00 0F 2E E0 7A 02 74 06 89 44 24 08 EB 0D 0F 28 CC F3 0F 58 CC F3 0F 11 4C 24 08 0F 2E D8 7A 02 74 06 89 54 24 28 EB 0D 0F 28 D3 F3 0F 58 D3 F3 0F 11 54 24 28 0F B6 54 24 2B B8 01 00 00 00 81 E2 80 00 00 00 33 DB C1 EA 07 33 C9 F7 44 24 08 FF FF 7F 00 89 54 24 2C BA 00 00 00 00 0F B7 6C 24 2A 0F 44 D0 81 E5 80 7F 00 00 F7 44 24 28 FF FF 7F 00 0F B7 7C 24 0A 0F 44 D8 81 E7 80 7F 00 00 C1 ED 07 81 FD FF 00 00 00 0F B6 74 24 0B 0F 45 C8 81 E6 80 00 00 00 66 0F 7E D0 25 FF FF FF 7F 89 4C 24 0C C1 EF 07 C1 EE 07 8D 88 00 00 80 C0 81 F9 00 00 00 40 73 42 3D 00 00 80 4B 0F 8D 20 05 00 00 8B C8 81 E1 00 00 80 FF 81 C1 00 00 80 00 C1 E9 17 D3 E0 A9 FF FF 7F 00 75 1D 25 FF FF FF 00 B9 02 00 00 00 3D 00 00 80 00 B8 01 00 00 00 0F 44 C8 89 4C 24 10 EB 08 C7 44 24 10 00 00 00 00 85 F6 75 09 83 FF 7F 0F 84 47 0A 00 00 85 ED 75 08 85 DB 0F 85 7E 04 00 00 33 C9 B8 01 00 00 00 81 FF FF 00 00 00 0F 45 C8 89 4C 24 08 0B D1 0F 84 4C 04 00 00 0B 5C 24 0C 0F 84 42 04 00 00 0F 2E C8 7A 06 0F 84 B2 09 00 00 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 73 09 00 00 83 7C 24 08 00 0F 84 96 03 00 00 83 7C 24 0C 00 0F 84 8B 03 00 00 0F 2F C8 77 0B 83 7C 24 10 00 0F 84 46 03 00 00 8B 44 24 10 23 C6 F3 0F 11 4C 24 08 80 64 24 0B 7F 85 FF F3 0F 10 04 85 ?? ?? ?? ?? F3 0F 11 44 24 0C 75 1B F3 0F 10 44 24 08 B9 C0 FF FF FF F3 0F 59 05 ?? ?? ?? ?? F3 0F 11 44 24 08 EB 08 F3 0F 10 44 24 08 33 C9 0F B7 5C 24 0A 81 E3 80 7F 00 00 C1 EB 07 8B 54 24 08 C1 E3 17 81 E2 FF FF 7F 00 F3 0F 11 44 24 18 0B DA 0F B7 44 24 1A 81 C3 00 00 C8 C0 25 7F 80 FF FF 0D 80 3F FF FF 66 89 44 24 1A C1 FB 17 03 D9 8B 4C 24 18 81 E1 00 00 78 00 81 C1 00 00 08 00 C1 E9 14 F3 0F 2A C3 F3 0F 10 2C CD ?? ?? ?? ?? 0F 28 D5 F3 0F 10 24 8D ?? ?? ?? ?? F3 0F 58 D0 F3 0F 10 5C 24 18 F3 0F 11 54 24 20 F3 0F 59 DC F3 0F 10 74 24 20 66 0F 7E DE F3 0F 5C C6 81 E6 00 00 1E 00 F3 0F 58 E8 81 C6 00 00 02 00 C1 EE 12 F3 0F 11 6C 24 24 F3 0F 10 54 24 20 0F 28 EA F3 0F 10 3C F5 ?? ?? ?? ?? F3 0F 10 0C B5 ?? ?? ?? ?? F3 0F 58 EF F3 0F 59 E1 F3 0F 10 44 24 24 F3 0F 11 6C 24 20 F3 0F 59 D9 F3 0F 10 6C 24 20 66 0F 7E DF F3 0F 5C D5 81 E7 00 C0 07 00 F3 0F 58 D7 81 C7 00 40 00 00 C1 EF 0F F3 0F 11 54 24 24 F3 0F 10 6C 24 20 0F 28 FD F3 0F 10 14 FD ?? ?? ?? ?? F3 0F 10 74 24 24 F3 0F 58 FA F3 0F 58 C6 F3 0F 11 7C 24 20 F3 0F 10 7C 24 20 F3 0F 10 34 BD ?? ?? ?? ?? F3 0F 5C EF F3 0F 59 E6 F3 0F 58 EA F3 0F 11 6C 24 24 F3 0F 10 6C 24 20 F3 0F 10 54 24 24 F3 0F 10 7C 24 18 F3 0F 58 C2 0F 28 CF F3 0F 58 04 CD ?? ?? ?? ?? F3 0F 59 DE F3 0F 58 04 F5 ?? ?? ?? ?? 0F 28 D3 F3 0F 58 04 FD ?? ?? ?? ?? F3 0F 5C 15 ?? ?? ?? ?? F3 0F 11 44 24 1C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 74 24 20 F3 0F 11 54 24 14 F3 0F 5C 74 24 18 F3 0F 11 74 24 24 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 5C F1 F3 0F 11 74 24 20 F3 0F 10 4C 24 20 F3 0F 5C F9 F3 0F 11 7C 24 24 0F 28 FC F3 0F 59 F8 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 11 7C 24 20 F3 0F 10 44 24 20 F3 0F 5C C4 F3 0F 11 44 24 24 F3 0F 10 7C 24 20 F3 0F 10 44 24 24 F3 0F 5C F8 F3 0F 11 7C 24 20 0F 28 FE F3 0F 10 44 24 20 F3 0F 5C E0 F3 0F 11 64 24 24 F3 0F 10 64 24 20 F3 0F 59 FC F3 0F 59 E1 F3 0F 5C FB 0F 28 DA F3 0F 58 FC F3 0F 58 DD F3 0F 10 44 24 24 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 59 F0 F3 0F 5C EC F3 0F 59 C8 F3 0F 58 FE F3 0F 58 EA F3 0F 58 CF F3 0F 11 6C 24 24 F3 0F 10 64 24 20 F3 0F 11 64 24 10 0F B7 44 24 12 25 80 7F 00 00 C1 E8 07 03 E8 F3 0F 10 54 24 24 81 FD 09 01 00 00 F3 0F 10 44 24 1C 0F 8D 19 06 00 00 81 FD C0 00 00 00 0F 8F 67 01 00 00 C7 44 24 20 00 00 80 3F F3 0F 10 44 24 20 F3 0F 10 54 24 0C 8B 44 24 4C F3 0F 58 05 ?? ?? ?? ?? F3 0F 11 44 24 20 F3 0F 10 4C 24 20 F3 0F 59 D1 F3 0F 11 10 33 C0 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 00 00 F3 0F 10 4C 24 20 F3 0F 10 44 24 20 F3 0F 5E C8 8B 54 24 4C F3 0F 11 4C 24 20 8B 44 24 20 89 02 B8 01 00 00 00 83 C4 30 5D 5B 5F 5E C3 83 FF 7F 7D 31 83 7C 24 2C 00 74 16 F3 0F 59 D2 8B 44 24 4C F3 0F 11 10 33 C0 83 C4 30 5D 5B 5F 5E C3 8B 44 24 4C C7 00 00 00 00 00 33 C0 83 C4 30 5D 5B 5F 5E C3 83 7C 24 2C 00 74 21 8B 44 24 10 23 C6 8B 4C 24 4C 8B 14 85 ?? ?? ?? ?? 33 C0 89 54 24 18 89 11 83 C4 30 5D 5B 5F 5E C3 F3 0F 59 C9 8B 44 24 10 F3 0F 59 D1 23 C6 F3 0F 59 14 85 ?? ?? ?? ?? 33 C0 8B 54 24 4C F3 0F 11 12 83 C4 30 5D 5B 5F 5E C3 8B 44 24 4C F3 0F 58 E3 F3 0F 11 20 33 C0 83 C4 30 5D 5B 5F 5E C3 8B 54 24 4C F3 0F 58 CA F3 0F 11 4C 24 20 C7 44 24 24 00 00 80 3F 0F B6 6C 24 23 0F B6 44 24 27 83 E5 80 83 E0 7F 0B C5 88 44 24 27 33 C0 F3 0F 10 4C 24 24 F3 0F 10 44 24 24 F3 0F 59 C8 F3 0F 11 0A 83 C4 30 5D 5B 5F 5E C3 C7 44 24 10 02 00 00 00 E9 12 FB FF FF F3 0F 10 5C 24 14 F3 0F 10 3D ?? ?? ?? ?? F3 0F 58 D9 F3 0F 58 CA F3 0F 59 FB F3 0F 58 C1 F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB 0F 28 D0 F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB F3 0F 58 3D ?? ?? ?? ?? F3 0F 59 FB F3 0F 58 E7 F3 0F 11 64 24 20 F3 0F 10 4C 24 20 F3 0F 10 64 24 10 F3 0F 5C E1 F3 0F 58 E7 F3 0F 11 64 24 24 F3 0F 10 74 24 20 F3 0F 10 4C 24 24 F3 0F 58 D6 F3 0F 11 54 24 20 F3 0F 10 6C 24 20 F3 0F 10 54 24 28 F3 0F 5C F5 F3 0F 58 F0 F3 0F 11 74 24 24 F3 0F 10 35 ?? ?? ?? ?? F3 0F 10 6C 24 20 0F 28 C6 F3 0F 59 C5 F3 0F 59 F2 F3 0F 10 7C 24 24 F3 0F 11 44 24 20 F3 0F 58 F9 F3 0F 10 4C 24 20 F3 0F 59 7C 24 28 F3 0F 5C CD F3 0F 11 4C 24 24 F3 0F 10 5C 24 20 F3 0F 10 44 24 24 F3 0F 5C D8 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 5C EC F3 0F 11 6C 24 24 F3 0F 10 5C 24 20 F3 0F 10 64 24 24 F3 0F 11 74 24 20 F3 0F 10 6C 24 20 F3 0F 5C 6C 24 28 F3 0F 11 6C 24 24 F3 0F 10 4C 24 20 F3 0F 10 44 24 24 F3 0F 5C C8 F3 0F 11 4C 24 20 F3 0F 10 6C 24 20 F3 0F 5C D5 F3 0F 11 54 24 24 F3 0F 10 54 24 20 F3 0F 10 6C 24 24 0F 28 C2 0F 28 CD F3 0F 59 CC F3 0F 59 D4 F3 0F 59 C3 F3 0F 59 DD F3 0F 58 CA F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 CB 0F 28 D8 F3 0F 58 F9 F3 0F 58 DA F3 0F 11 5C 24 20 F3 0F 10 64 24 20 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C E2 F3 0F 11 24 24 F3 0F 10 34 24 8B 54 24 20 8B C2 83 E2 7F F3 0F 5C C6 F3 0F 11 44 24 04 F3 0F 10 44 24 04 C1 E0 0A F3 0F 58 F8 F3 0F 59 CF F3 0F 10 04 D5 ?? ?? ?? ?? C1 F8 11 F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CF F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CF F3 0F 59 C8 F3 0F 58 0C D5 ?? ?? ?? ?? 0F 28 D1 F3 0F 58 D0 F3 0F 11 54 24 18 0F B7 4C 24 1A 8B D1 81 E2 80 7F 00 00 C1 EA 07 83 C2 81 03 D0 81 FA 80 00 00 00 0F 8D 36 02 00 00 83 FA 82 7C 3A 83 C2 7F 81 E1 7F 80 FF FF 0F B6 D2 C1 E2 07 0B CA 66 89 4C 24 1A F3 0F 10 44 24 18 F3 0F 59 44 24 0C 8B 44 24 4C F3 0F 11 44 24 18 F3 0F 11 00 33 C0 83 C4 30 5D 5B 5F 5E C3 81 FA 78 FF FF FF 0F 8C 1E 01 00 00 F3 0F 11 54 24 20 83 C0 40 F3 0F 10 54 24 20 BA 00 00 80 3F F3 0F 10 1D ?? ?? ?? ?? 83 C0 7F 89 54 24 08 F3 0F 5C C2 C1 EA 10 F3 0F 58 C1 F3 0F 11 44 24 24 F3 0F 10 44 24 20 F3 0F 59 D8 F3 0F 10 4C 24 24 F3 0F 11 5C 24 20 F3 0F 10 64 24 20 0F B7 CA F3 0F 5C E0 F3 0F 11 64 24 24 81 E1 7F 80 FF FF F3 0F 10 74 24 20 F3 0F 10 6C 24 24 0F B6 C0 F3 0F 5C F5 F3 0F 11 74 24 20 F3 0F 10 7C 24 20 C1 E0 07 F3 0F 5C C7 F3 0F 11 44 24 24 0B C8 F3 0F 10 44 24 20 33 C0 F3 0F 10 54 24 24 66 89 4C 24 0A F3 0F 58 CA F3 0F 10 5C 24 08 F3 0F 59 CB F3 0F 59 C3 F3 0F 10 25 ?? ?? ?? ?? F3 0F 59 CC F3 0F 59 C4 F3 0F 11 4C 24 20 F3 0F 10 4C 24 20 C7 44 24 20 00 00 80 00 F3 0F 58 C1 F3 0F 10 74 24 20 F3 0F 10 6C 24 20 F3 0F 59 F5 F3 0F 11 74 24 20 F3 0F 10 7C 24 20 F3 0F 10 4C 24 0C F3 0F 58 C7 F3 0F 59 C8 8B 5C 24 4C F3 0F 11 44 24 18 F3 0F 11 0B 83 C4 30 5D 5B 5F 5E C3 81 FA 61 FF FF FF 7C 7F BA 00 00 80 3F 05 BF 00 00 00 89 54 24 08 C1 EA 10 0F B7 CA 0F B6 C0 81 E1 7F 80 FF FF C1 E0 07 0B C8 33 C0 F3 0F 10 5C 24 0C 66 89 4C 24 0A F3 0F 59 1D ?? ?? ?? ?? F3 0F 59 54 24 08 C7 44 24 20 00 00 80 00 F3 0F 59 DA F3 0F 10 54 24 20 F3 0F 10 44 24 20 F3 0F 59 C2 F3 0F 11 44 24 20 F3 0F 10 4C 24 20 8B 5C 24 4C F3 0F 58 D9 F3 0F 11 5C 24 18 F3 0F 11 1B 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 80 00 F3 0F 10 44 24 20 F3 0F 10 4C 24 20 F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 54 24 20 F3 0F 10 5C 24 0C F3 0F 59 DA 8B 44 24 4C F3 0F 11 5C 24 18 F3 0F 11 18 33 C0 83 C4 30 5D 5B 5F 5E C3 C7 44 24 20 00 00 00 7F F3 0F 10 4C 24 20 F3 0F 10 44 24 20 F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 54 24 20 F3 0F 10 5C 24 0C F3 0F 59 DA 8B 44 24 4C F3 0F 11 5C 24 18 F3 0F 11 18 33 C0 83 C4 30 5D 5B 5F 5E C3 0F B6 44 24 13 25 80 00 00 00 C1 E8 07 8B 54 24 2C 33 D0 33 C0 8B 4C 24 4C F3 0F 10 04 95 ?? ?? ?? ?? F3 0F 59 C0 F3 0F 59 44 24 0C F3 0F 11 01 83 C4 30 5D 5B 5F 5E C3 83 7C 24 10 00 75 0B 83 7C 24 0C 00 0F 85 7B F6 FF FF 8B 44 24 10 83 E0 01 8B 4C 24 4C 8B 14 85 ?? ?? ?? ?? 33 C0 89 11 83 C4 30 5D 5B 5F 5E C3 F3 0F 59 C9 83 7C 24 2C 00 74 28 8B 44 24 10 23 C6 8B 54 24 4C F3 0F 10 04 85 ?? ?? ?? ?? B8 01 00 00 00 F3 0F 5E C1 F3 0F 11 02 83 C4 30 5D 5B 5F 5E C3 8B 44 24 10 23 C6 8B 54 24 4C F3 0F 10 04 85 ?? ?? ?? ?? 33 C0 F3 0F 59 C1 F3 0F 11 02 83 C4 30 5D 5B 5F 5E C3 85 D2 0F 84 B1 F5 FF FF E9 36 FA FF FF 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "?__scrt_initialize_thread_safe_statics@@YAHXZ"
		size = 192
		refs = "000b ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0010 ___vcrt_InitializeCriticalSectionEx 0018 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 001e __imp__GetModuleHandleW@4 002d ??_C@_0BM@HLJJNPAH@InitializeConditionVariable?$AA@ 0034 __imp__GetProcAddress@8 0039 ??_C@_0BJ@JEBJOJFJ@SleepConditionVariableCS?$AA@ 0047 ??_C@_0BJ@PGPPEPCC@WakeAllConditionVariable?$AA@ 0064 ?_Tss_event@@3PAXA 006c ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0071 @_guard_check_icall@4 0079 ??$__crt_fast_encode_pointer@P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZQ6GH01K@Z@Z 007f ?encoded_sleep_condition_variable_cs@@3P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZA 0084 ??$__crt_fast_encode_pointer@P6GXPAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6GXPAU_RTL_CONDITION_VARIABLE@@@ZQ6GX0@Z@Z 008b ?encoded_wake_all_condition_variable@@3P6GXPAU_RTL_CONDITION_VARIABLE@@@ZA 009a __imp__CreateEventW@16 00a8 ?__scrt_uninitialize_thread_safe_statics@@YAXXZ 00ad _atexit 00bb ___scrt_fastfail"
	strings:
		$1 = { 53 56 57 6A 00 68 A0 0F 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 8C 00 00 00 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 8B D8 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 8B F8 FF 15 ?? ?? ?? ?? 8B F0 85 DB 74 37 85 FF 74 33 85 F6 74 2F 83 25 ?? ?? ?? ?? 00 8B CB 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF D3 57 E8 ?? ?? ?? ?? 56 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? EB 16 33 C0 50 50 6A 01 50 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 74 11 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5F 5E 33 C0 5B C3 6A 07 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_291_6_0 {
	meta:
		name = "?__scrt_uninitialize_thread_safe_statics@@YAXXZ"
		size = 28
		refs = "0001 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0007 __imp__DeleteCriticalSection@4 000c ?_Tss_event@@3PAXA 0017 __imp__CloseHandle@4"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 07 50 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_291_7_0 {
	meta:
		name = "__Init_thread_abort"
		size = 25
		refs = "0004 __Init_thread_lock 000f __Init_thread_unlock 0015 __Init_thread_notify"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 45 08 83 20 00 E8 ?? ?? ?? ?? 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_291_8_0 {
	meta:
		name = "__Init_thread_footer"
		size = 63
		refs = "0004 __Init_thread_lock 000a __Init_global_epoch 001c __tls_array 0022 __tls_index 0030 __Init_thread_epoch 0035 __Init_thread_unlock 003b __Init_thread_notify"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 45 08 41 89 0D ?? ?? ?? ?? 89 08 64 A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 0C 88 A1 ?? ?? ?? ?? 89 81 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_291_9_0 {
	meta:
		name = "__Init_thread_header"
		size = 70
		refs = "0005 __Init_thread_lock 0011 __Init_thread_wait 0022 __tls_array 0028 __tls_index 0030 __Init_global_epoch 0036 __Init_thread_epoch 0042 __Init_thread_unlock"
	strings:
		$1 = { 55 8B EC 56 E8 ?? ?? ?? ?? 8B 75 08 EB 08 6A 64 E8 ?? ?? ?? ?? 59 83 3E 00 74 21 83 3E FF 74 EE 64 A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8B 0C 88 A1 ?? ?? ?? ?? 89 81 ?? ?? ?? ?? EB 03 83 0E FF 5E 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_291_11_0 {
	meta:
		name = "__Init_thread_notify"
		size = 65
		refs = "0001 ?_Tss_event@@3PAXA 000c ___security_cookie 0014 ?encoded_wake_all_condition_variable@@3P6GXPAU_RTL_CONDITION_VARIABLE@@@ZA 001e ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0025 @_guard_check_icall@4 0030 __imp__SetEvent@4 003c __imp__ResetEvent@4"
	strings:
		$1 = { A1 ?? ?? ?? ?? 85 C0 75 24 56 8B 35 ?? ?? ?? ?? 8B CE 33 35 ?? ?? ?? ?? 83 E1 1F D3 CE 68 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? FF D6 5E C3 50 FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_291_13_0 {
	meta:
		name = "__Init_thread_wait"
		size = 101
		refs = "0005 ?_Tss_event@@3PAXA 000f ___security_cookie 001a ?encoded_sleep_condition_variable_cs@@3P6GHPAU_RTL_CONDITION_VARIABLE@@PAU_RTL_CRITICAL_SECTION@@K@ZA 0024 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0029 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0030 @_guard_check_icall@4 003f __Init_thread_unlock 0050 __imp__WaitForSingleObjectEx@12 0057 __Init_thread_lock"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 56 75 31 8B 35 ?? ?? ?? ?? 8B CE FF 75 08 33 35 ?? ?? ?? ?? 83 E1 1F D3 CE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? FF D6 F7 D8 1B C0 F7 D8 EB 24 E8 ?? ?? ?? ?? 6A 00 FF 75 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 33 C0 85 F6 0F 94 C0 5E 5D C3 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "___avx_cosh4"
		size = 528
		refs = "0010 ___common_dcosh_data 0206 ___common_dcosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 FD 11 04 24 C5 FD 11 54 24 20 C5 E5 55 E8 C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 74 24 20 C5 C1 73 D3 0B C4 E3 7D 19 D9 01 C5 D9 73 D1 0B C5 FA 7F 64 24 50 C5 FA 7F 7C 24 40 C5 F8 10 0D ?? ?? ?? ?? C4 E3 7D 19 EA 01 C4 E3 7D 19 F4 01 C5 D0 C6 DA DD C5 C8 C6 C4 88 C5 D9 73 F4 2C C5 E1 66 3D ?? ?? ?? ?? C5 F9 DB 15 ?? ?? ?? ?? C5 F8 50 C7 C5 C1 72 F2 03 C5 F9 7E FA C5 F1 FA DA C5 E1 72 F3 03 C4 E3 79 16 F9 01 C5 FB 10 82 ?? ?? ?? ?? C4 E3 79 16 FA 02 C5 F9 16 91 ?? ?? ?? ?? C4 E3 79 16 F9 03 C5 FB 10 8A ?? ?? ?? ?? C5 F9 7E DA C5 F1 16 89 ?? ?? ?? ?? C4 E3 79 16 D9 01 C5 FB 10 BA ?? ?? ?? ?? C4 E3 79 16 DA 02 C5 C1 16 B9 ?? ?? ?? ?? C4 E3 79 16 D9 03 C5 FB 10 82 ?? ?? ?? ?? C5 F9 11 7C 24 60 C5 F9 16 99 ?? ?? ?? ?? C5 CD 5C 44 24 20 C5 FD 59 3D ?? ?? ?? ?? C5 D5 5C EF C5 FD 59 3D ?? ?? ?? ?? C5 D5 5C C7 C5 C1 73 F6 2C C5 F9 10 35 ?? ?? ?? ?? C5 C1 DB FE C5 D9 DB E6 C5 E9 D4 F7 C5 E1 FB DC C5 F1 D4 CC C5 E1 FB 64 24 50 C5 FD 59 E8 C5 F9 10 54 24 60 C5 E9 FB FF C5 C1 FB 7C 24 40 C4 E3 4D 18 C9 01 C4 E3 45 18 DC 01 C5 F5 5C FB C5 F5 58 DB C5 D5 59 0D ?? ?? ?? ?? C5 F5 59 D0 C5 ED 58 C0 C5 FD 59 D7 C5 D5 59 05 ?? ?? ?? ?? C5 FD 58 0D ?? ?? ?? ?? C5 F5 59 ED C5 D5 59 C3 C5 FD 58 CA C5 F5 58 C3 85 C0 75 04 8B E5 5D C3 C5 FD 10 0C 24 C5 FD 11 84 24 80 00 00 00 C5 FD 11 4C 24 40 74 E6 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 84 24 80 00 00 00 EB BC C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 90 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 164
		refs = "0004 __set_app_type 0009 __get_startup_file_mode 000f __set_fmode 0014 ___p__commode 001b __get_startup_commit_mode 0024 ___scrt_initialize_onexit_tables 0033 __RTC_Initialize 0038 __RTC_Terminate 003d _atexit 0042 __get_startup_argv_mode 0048 __configure_wide_argv 0053 ?__scrt_initialize_type_info@@YAXXZ 0058 ___scrt_is_user_matherr_present 0061 __matherr 0066 ___setusermatherr 006c __initialize_invalid_parameter_handler 0071 __initialize_denormal_control 0076 __initialize_default_precision 007b __get_startup_thread_locale_mode 0081 __configthreadlocale 0087 __should_initialize_environment 0090 __initialize_wide_environment 0095 ___scrt_initialize_winrt 009f ___scrt_fastfail"
	strings:
		$1 = { 56 6A 02 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 6A 01 89 06 E8 ?? ?? ?? ?? 83 C4 0C 5E 84 C0 74 6C DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 4A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 C3 6A 07 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 164
		refs = "0004 __set_app_type 0009 __get_startup_file_mode 000f __set_fmode 0014 ___p__commode 001b __get_startup_commit_mode 0024 ___scrt_initialize_onexit_tables 0033 __RTC_Initialize 0038 __RTC_Terminate 003d _atexit 0042 __get_startup_argv_mode 0048 __configure_narrow_argv 0053 ?__scrt_initialize_type_info@@YAXXZ 0058 ___scrt_is_user_matherr_present 0061 __matherr 0066 ___setusermatherr 006c __initialize_invalid_parameter_handler 0071 __initialize_denormal_control 0076 __initialize_default_precision 007b __get_startup_thread_locale_mode 0081 __configthreadlocale 0087 __should_initialize_environment 0090 __initialize_narrow_environment 0095 ___scrt_initialize_winrt 009f ___scrt_fastfail"
	strings:
		$1 = { 56 6A 02 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 6A 01 89 06 E8 ?? ?? ?? ?? 83 C4 0C 5E 84 C0 74 6C DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 4A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 C3 6A 07 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_295_2_0 {
	meta:
		name = "?pre_cpp_initialization@@YAXXZ"
		size = 18
		refs = "0001 ___scrt_set_unhandled_exception_filter 0006 __get_startup_new_mode 000c __set_new_mode"
	strings:
		$1 = { E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_295_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 360
		refs = "0003 __sehtable$?__scrt_common_main_seh@@YAHXZ 0008 __SEH_prolog4 000f ___scrt_initialize_crt 001b ___scrt_fastfail 0029 ___scrt_acquire_startup_lock 0031 ___scrt_current_native_startup_state 0047 ___xi_z 004c ___xi_a 0051 __initterm_e 006d ___xc_z 0072 ___xc_a 0077 __initterm 0092 ___scrt_release_startup_lock 0098 ___scrt_get_dyn_tls_init_callback 00a6 ___scrt_is_nonwritable_in_current_image 00b8 @_guard_check_icall@4 00bf ___scrt_get_dyn_tls_dtor_callback 00d7 __register_thread_local_exe_atexit_callback 00dd ___scrt_get_show_window_mode 00e6 __get_wide_winmain_command_line 00ed ___ImageBase 00f2 _wWinMain@16 00f9 ___scrt_is_managed_app 0103 _exit 010c __cexit 0114 ___scrt_uninitialize_crt 0132 __seh_filter_exe 0149 __exit 0154 __c_exit 0163 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 59 84 C0 75 07 6A 07 E8 ?? ?? ?? ?? 32 DB 88 5D E7 83 65 FC 00 E8 ?? ?? ?? ?? 88 45 DC A1 ?? ?? ?? ?? 33 C9 41 3B C1 74 DC 85 C0 75 49 89 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 74 11 C7 45 FC FE FF FF FF B8 FF 00 00 00 E9 F6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 C7 05 ?? ?? ?? ?? 02 00 00 00 EB 05 8A D9 88 5D E7 FF 75 DC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B F0 33 FF 39 3E 74 1A 56 E8 ?? ?? ?? ?? 59 84 C0 74 0F 57 6A 02 57 8B 36 8B CE E8 ?? ?? ?? ?? FF D6 E8 ?? ?? ?? ?? 8B F0 39 3E 74 13 56 E8 ?? ?? ?? ?? 59 84 C0 74 08 FF 36 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 50 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 84 C0 75 06 56 E8 ?? ?? ?? ?? 84 DB 75 05 E8 ?? ?? ?? ?? 57 6A 01 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF 8B C6 EB 3D 8B 4D EC 8B 01 8B 00 89 45 E0 51 50 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 E8 ?? ?? ?? ?? 84 C0 75 08 FF 75 E0 E8 ?? ?? ?? ?? 80 7D E7 00 75 05 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_391_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 360
		refs = "0003 __sehtable$?__scrt_common_main_seh@@YAHXZ 0008 __SEH_prolog4 000f ___scrt_initialize_crt 001b ___scrt_fastfail 0029 ___scrt_acquire_startup_lock 0031 ___scrt_current_native_startup_state 0047 ___xi_z 004c ___xi_a 0051 __initterm_e 006d ___xc_z 0072 ___xc_a 0077 __initterm 0092 ___scrt_release_startup_lock 0098 ___scrt_get_dyn_tls_init_callback 00a6 ___scrt_is_nonwritable_in_current_image 00b8 @_guard_check_icall@4 00bf ___scrt_get_dyn_tls_dtor_callback 00d7 __register_thread_local_exe_atexit_callback 00dd ___scrt_get_show_window_mode 00e6 __get_narrow_winmain_command_line 00ed ___ImageBase 00f2 _WinMain@16 00f9 ___scrt_is_managed_app 0103 _exit 010c __cexit 0114 ___scrt_uninitialize_crt 0132 __seh_filter_exe 0149 __exit 0154 __c_exit 0163 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 59 84 C0 75 07 6A 07 E8 ?? ?? ?? ?? 32 DB 88 5D E7 83 65 FC 00 E8 ?? ?? ?? ?? 88 45 DC A1 ?? ?? ?? ?? 33 C9 41 3B C1 74 DC 85 C0 75 49 89 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 74 11 C7 45 FC FE FF FF FF B8 FF 00 00 00 E9 F6 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 C7 05 ?? ?? ?? ?? 02 00 00 00 EB 05 8A D9 88 5D E7 FF 75 DC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B F0 33 FF 39 3E 74 1A 56 E8 ?? ?? ?? ?? 59 84 C0 74 0F 57 6A 02 57 8B 36 8B CE E8 ?? ?? ?? ?? FF D6 E8 ?? ?? ?? ?? 8B F0 39 3E 74 13 56 E8 ?? ?? ?? ?? 59 84 C0 74 08 FF 36 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 50 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 84 C0 75 06 56 E8 ?? ?? ?? ?? 84 DB 75 05 E8 ?? ?? ?? ?? 57 6A 01 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF 8B C6 EB 3D 8B 4D EC 8B 01 8B 00 89 45 E0 51 50 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 E8 ?? ?? ?? ?? 84 C0 75 08 FF 75 E0 E8 ?? ?? ?? ?? 80 7D E7 00 75 05 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_295_8_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 28
		refs = "0001 ___scrt_get_show_window_mode 000a __get_wide_winmain_command_line 0012 ___ImageBase 0017 _wWinMain@16"
	strings:
		$1 = { E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_391_8_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 28
		refs = "0001 ___scrt_get_show_window_mode 000a __get_narrow_winmain_command_line 0012 ___ImageBase 0017 _WinMain@16"
	strings:
		$1 = { E8 ?? ?? ?? ?? 0F B7 C0 50 E8 ?? ?? ?? ?? 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "___sse2_atanf4"
		size = 208
		refs = "0012 _static_const_table"
	strings:
		$1 = { 8B C4 81 EC 90 00 00 00 83 E4 F0 89 44 24 54 0F 28 25 ?? ?? ?? ?? 0F 28 DC 0F 55 D8 0F 54 E0 0F 28 3D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F C2 FC 01 0F 28 EF 0F 54 F7 0F 55 FC 0F 56 F7 0F 28 FD 0F 54 E5 0F 55 2D ?? ?? ?? ?? 0F 56 E5 0F 5E F4 0F 28 0D ?? ?? ?? ?? 0F 54 F9 0F 28 CE 0F 59 CE 0F 28 D1 0F 59 D1 0F 28 25 ?? ?? ?? ?? 0F 59 E2 0F 28 05 ?? ?? ?? ?? 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C2 0F 58 25 ?? ?? ?? ?? 0F 58 05 ?? ?? ?? ?? 0F 59 E2 0F 59 C1 0F 58 25 ?? ?? ?? ?? 0F 58 C4 0F 59 C6 0F 58 C7 0F 56 C3 8B 64 24 54 C3 8B FF }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "?GetPdbDll@@YAPAUHINSTANCE__@@XZ"
		size = 24
		refs = "0002 ?alreadyTried@?1??GetPdbDll@@YAPAUHINSTANCE__@@XZ@4_NA 0014 ?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 03 33 C0 C3 C6 05 ?? ?? ?? ?? 01 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_298_1_0 {
	meta:
		name = "?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ"
		size = 505
		refs = "000a ___security_cookie 0020 ??_C@_1EI@MLPKHBGE@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AAw?$AAi?$AAn?$AA?9?$AAc?$AAo?$AAr?$AAe?$AA?9?$AAr?$AAe?$AAg?$AAi?$AAs?$AAt?$AAr?$AAy?$AA?9?$AAl?$AA1?$AA?9?$AA1?$AA?9?$AA0?$AA?4@ 0025 ___vcrt_LoadLibraryExW 0035 ??_C@_1BK@JHLNAEJL@?$AAa?$AAd?$AAv?$AAa?$AAp?$AAi?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 004a __imp__GetLastError@0 006c ??_C@_0O@COHOBMLB@RegOpenKeyExW?$AA@ 0073 __imp__GetProcAddress@8 007e ??_C@_0BB@GLNAEDBD@RegQueryValueExW?$AA@ 0090 ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 00b3 ??_C@_1HE@EBEAGLFB@?$AAS?$AAO?$AAF?$AAT?$AAW?$AAA?$AAR?$AAE?$AA?2?$AAW?$AAo?$AAw?$AA6?$AA4?$AA3?$AA2?$AAN?$AAo?$AAd?$AAe?$AA?2?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?2?$AAV@ 00bd @_guard_check_icall@4 00ca __imp__FreeLibrary@4 00f4 ??_C@_1BG@EABPBLLF@?$AAP?$AAr?$AAo?$AAd?$AAu?$AAc?$AAt?$AAD?$AAi?$AAr?$AA?$AA@ 01a0 ?mspdbName@@3QB_WB 01f1 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 1C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 BE 00 08 00 00 33 DB 56 53 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 39 56 53 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 23 FF 15 ?? ?? ?? ?? 83 F8 57 75 11 53 53 56 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 07 33 C0 E9 7D 01 00 00 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 E7 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B D8 85 DB 74 D5 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 89 85 E8 FD FF FF 85 C0 74 BF 8D 85 F0 FD FF FF 8B CE 50 6A 01 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? FF D6 85 C0 74 09 57 FF 15 ?? ?? ?? ?? EB 94 8D 85 EC FD FF FF C7 85 EC FD FF FF 08 02 00 00 50 8D 85 F4 FD FF FF 8B CB 50 8D 85 E4 FD FF FF 50 6A 00 68 ?? ?? ?? ?? FF B5 F0 FD FF FF E8 ?? ?? ?? ?? FF D3 FF B5 F0 FD FF FF 8B 9D E8 FD FF FF 8B F0 8B CB E8 ?? ?? ?? ?? FF D3 57 FF 15 ?? ?? ?? ?? 85 F6 0F 85 39 FF FF FF 83 BD E4 FD FF FF 01 0F 85 2C FF FF FF 8B 8D EC FD FF FF F6 C1 01 0F 85 1D FF FF FF D1 E9 8B C1 83 F9 02 0F 82 10 FF FF FF 49 33 DB 66 39 9C 4D F4 FD FF FF 0F 85 FF FE FF FF 6A 5C 5A 66 39 94 4D F2 FD FF FF 74 0A 66 89 94 4D F4 FD FF FF 8B C8 8B C1 F7 D0 83 F8 12 0F 82 DB FE FF FF 8D 41 11 3D 04 01 00 00 0F 87 CD FE FF FF 6A 08 8D BD F4 FD FF FF BE ?? ?? ?? ?? 8D 3C 4F 59 F3 A5 68 00 09 00 00 8D 85 F4 FD FF FF 53 50 66 A5 E8 ?? ?? ?? ?? 8B F0 83 C4 0C 85 F6 75 1F FF 15 ?? ?? ?? ?? 83 F8 57 75 14 6A 08 8D 85 F4 FD FF FF 53 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 8B C6 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_298_2_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z"
		size = 825
		refs = "0022 __imp__VirtualQuery@12 003b ___vcrt_GetModuleFileNameW 0099 ?PDBOK@?1??_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z@4_NA 00a5 ?mspdb@@3PAUHINSTANCE__@@A 00ae ?alreadyTried@?1??GetPdbDll@@YAPAUHINSTANCE__@@XZ@4_NA 00c6 ?GetPdbDllFromInstallPath@@YAPAUHINSTANCE__@@XZ 00e2 ??_C@_0BB@KCIACLNC@PDBOpenValidate5?$AA@ 00e9 __imp__GetProcAddress@8 0108 @_guard_check_icall@4 0144 ??_C@_01KDCPPGHE@r?$AA@ 0220 __imp__GetProcessHeap@0 0227 __imp__HeapFree@12 029d __imp__HeapAlloc@12"
	strings:
		$1 = { 55 8B EC 8B 45 14 83 EC 4C 33 C9 83 20 00 8B 45 0C 56 8B 75 08 6A 1C 66 89 08 4E 8D 45 B4 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 4A 02 00 00 FF 75 1C FF 75 18 FF 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 E4 8B 45 B8 B9 4D 5A 00 00 66 39 08 75 D7 8B 48 3C 85 C9 7E D0 03 C8 81 39 50 45 00 00 75 C6 0F B7 51 06 2B F0 53 33 DB 33 C0 57 0F B7 79 14 85 D2 74 1A 83 C1 24 03 CF 3B 31 72 09 8B DE 2B 19 3B 71 FC 72 08 40 83 C1 28 3B C2 72 EB 3B C2 74 7F 40 80 3D ?? ?? ?? ?? 00 89 45 E4 75 39 83 3D ?? ?? ?? ?? 00 75 69 80 3D ?? ?? ?? ?? 00 74 09 83 25 ?? ?? ?? ?? 00 EB 57 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 74 42 C6 05 ?? ?? ?? ?? 01 EB 05 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 22 33 FF 8D 45 E8 50 57 57 8D 45 D0 8B CE 50 57 57 57 FF 75 18 E8 ?? ?? ?? ?? FF D6 83 C4 20 85 C0 75 07 33 C0 E9 5D 01 00 00 89 7D D8 8B 7D E8 8B 07 8B 30 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 3D 41 91 32 01 0F 85 27 01 00 00 8B 7D E8 8D 4D DC 51 68 ?? ?? ?? ?? 6A 00 8B 07 8B 70 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 85 C0 0F 84 01 01 00 00 8B 7D DC 33 C0 50 50 50 8B 37 8D 45 EC 50 53 FF 75 E4 8B 4E 20 E8 ?? ?? ?? ?? 8B CF FF 56 20 85 C0 0F 84 C7 00 00 00 8B 7D EC 8D 4D F4 83 65 F4 00 51 8B 07 8B 70 68 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 84 C0 0F 84 91 00 00 00 8B 7D F4 85 FF 0F 84 86 00 00 00 83 65 F8 00 EB 47 8B 7D F4 8D 45 F0 6A 00 50 8D 45 D4 8B 37 50 8D 45 FC 50 8B 76 0C 8D 45 E0 50 6A 00 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 84 C0 74 43 0F B7 45 FC 3B 45 E4 75 10 8B 4D E0 3B CB 77 09 8B 45 D4 03 C1 3B D8 72 7F 8B 7D F4 8B 07 8B 70 08 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 85 C0 75 A5 8B 45 F8 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 7D F4 8B 07 8B 30 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D EC 8B 07 8B 70 40 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D DC 8B 07 8B 70 38 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D E8 8B 17 8B 72 2C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 45 D8 5F 5B 5E 8B E5 5D C3 8B 45 F0 85 C0 74 A4 3D FF FF FF 1F 73 9D C1 E0 03 50 6A 00 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 F8 85 C0 74 83 8B 7D F4 50 8D 45 F0 50 8B 37 33 C0 50 50 50 8B 76 0C 8D 45 E4 50 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 84 C0 8B 45 F8 0F 84 47 FF FF FF 2B 5D E0 3B 18 0F 82 3C FF FF FF 33 C9 41 39 4D F0 76 0B 3B 1C C8 72 06 41 3B 4D F0 72 F5 8B 44 C8 FC 8B 4D 14 25 FF FF FF 00 8B 7D EC 89 01 33 C0 8B 37 50 50 50 8B 76 70 8D 45 10 50 FF 75 0C 8B CE FF 75 E4 E8 ?? ?? ?? ?? 8B CF FF D6 84 C0 8B 45 F8 0F 84 EE FE FF FF C7 45 D8 01 00 00 00 E9 E2 FE FF FF }
	condition:
		$1
}

rule file_300_1_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 98
		refs = "0003 __sehtable$?DebuggerProbe@@YAHK@Z 0008 __SEH_prolog4 0035 __imp__RaiseException@16 005d __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 88 4D E7 C7 45 CC 01 10 00 00 8B 45 08 89 45 D0 8D 45 E7 89 45 D4 89 4D FC 8D 45 CC 50 6A 06 51 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 16 8B 45 EC 8B 00 33 C9 81 38 88 13 6D 40 0F 94 C1 8B C1 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_300_2_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 116
		refs = "0003 __sehtable$?DebuggerRuntime@@YAHKHPAXPB_W@Z 0008 __SEH_prolog4 0047 __imp__RaiseException@16 006f __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 88 4D E7 C7 45 CC 02 10 00 00 8B 45 08 89 45 D0 8B 45 0C 89 45 D4 8B 45 10 89 45 D8 8D 45 E7 89 45 DC 8B 45 14 89 45 E0 89 4D FC 8D 45 CC 50 6A 06 51 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 16 8B 45 EC 8B 00 33 C9 81 38 88 13 6D 40 0F 94 C1 8B C1 C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_300_3_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
		size = 264
		refs = "000a ___security_cookie 001d ?_RTC_ErrorLevels@@3PAHA 0035 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 003e ?failwithmessage@@YAXPAXHHPBD@Z 004f ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 005d ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 0063 ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 0069 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 006e ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 0073 ??_C@_0BC@HHMKLAND@?$CFs?$CFs?$CFp?$CFs?$CFzd?$CFs?$CFd?$CFs?$AA@ 0084 _sprintf_s 0099 ?_getMemBlockDataString@@YAXPAD00I@Z 00bd ??_C@_01EEMJAFIK@?6?$AA@ 00c6 ??_C@_02LLMPMKNF@?$DO?5?$AA@ 00d2 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 0100 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 48 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B 5D 0C 57 8B 3D ?? ?? ?? ?? 89 85 B8 FE FF FF 83 FF FF 0F 84 C8 00 00 00 85 DB 75 16 68 ?? ?? ?? ?? 6A 04 57 50 E8 ?? ?? ?? ?? 83 C4 10 E9 AE 00 00 00 8B 43 0C 56 68 ?? ?? ?? ?? FF 75 10 83 E8 24 8D 73 20 68 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 BC FE FF FF 68 F4 00 00 00 50 E8 ?? ?? ?? ?? 8B 43 0C 83 E8 24 50 56 8D 45 B4 50 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 3C 8D 95 BC FE FF FF 8A 02 42 84 C0 75 F9 8D 8D BC FE FF FF 8A 01 8B F1 41 84 C0 75 F7 68 ?? ?? ?? ?? 8D 45 B4 50 68 ?? ?? ?? ?? 8D 45 E8 50 8D 45 B1 68 ?? ?? ?? ?? 2B C2 50 56 E8 ?? ?? ?? ?? 8D 85 BC FE FF FF 50 6A 04 57 FF B5 B8 FE FF FF E8 ?? ?? ?? ?? 83 C4 2C 5E 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_300_4_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 60
		refs = "000e ?_RTC_ErrorLevels@@3PAHA 0015 ?_RTC_ErrorMessages@@3QBQBDB 0033 ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 F8 04 77 10 8B 0C 85 ?? ?? ?? ?? 8B 14 85 ?? ?? ?? ?? EB 0C 8B 15 ?? ?? ?? ?? 33 C9 6A 05 41 58 83 F9 FF 74 0E 52 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_300_5_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 236
		refs = "000a ___security_cookie 0015 ?_RTC_ErrorLevels@@3PAHA 0056 ?stack_premsg@@3QBDB 008c ?stack_postmsg@@3QBDB 00c2 ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 00d6 ?failwithmessage@@YAXPAXHHPBD@Z 00e4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 08 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 8B 55 0C 89 85 F8 FB FF FF 0F 84 B2 00 00 00 80 3A 00 53 0F 84 8B 00 00 00 8B CA 8A 01 41 84 C0 75 F9 2B CA 83 C1 2C 81 F9 00 04 00 00 77 75 8D 9D FC FB FF FF 33 C9 8A 81 ?? ?? ?? ?? 88 84 0D FC FB FF FF 41 84 C0 75 EE 56 57 8B F2 8A 02 42 84 C0 75 F9 8D BD FC FB FF FF 2B D6 4F 8A 47 01 47 84 C0 75 F8 8B CA C1 E9 02 F3 A5 8B CA BA ?? ?? ?? ?? 83 E1 03 F3 A4 8B F2 8A 02 42 84 C0 75 F9 8D BD FC FB FF FF 2B D6 4F 8A 47 01 47 84 C0 75 F8 8B CA C1 E9 02 F3 A5 8B CA 83 E1 03 F3 A4 5F 5E EB 05 BB ?? ?? ?? ?? 53 6A 02 FF 35 ?? ?? ?? ?? FF B5 F8 FB FF FF E8 ?? ?? ?? ?? 83 C4 10 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_300_6_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPAD00I@Z"
		size = 121
		refs = "003e ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 0047 _sprintf_s"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 4D 10 8B 55 0C 53 56 33 F6 C7 45 FC 31 00 00 00 2B 4D 08 57 8B 7D 08 89 4D 10 83 7D 14 10 89 55 F8 73 05 8B 45 14 EB 03 6A 10 58 3B F0 73 2B 8A 1C 39 0F B6 C3 50 68 ?? ?? ?? ?? FF 75 FC 52 E8 ?? ?? ?? ?? 8B 55 F8 83 C4 10 83 6D FC 03 46 8B 4D 10 83 C2 03 88 1F 47 EB C0 8B 7D 08 8B 4D 0C 6B C6 03 C6 04 3E 00 5F 5E 5B C6 04 08 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_300_7_0 {
	meta:
		name = "?_strlen_priv@@YAIPBD@Z"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8A 08 40 84 C9 75 F9 2B 45 08 48 5D C3 }
	condition:
		$1
}

rule file_300_8_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 508
		refs = "000a ___security_cookie 002f ?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z 003c ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 0057 __imp__MultiByteToWideChar@24 0097 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 00a1 ?DebuggerProbe@@YAHK@Z 00ba ?_RTC_NoFalsePositives@@3QBHB 00c0 ?DebuggerRuntime@@YAHKHPAXPB_W@Z 00e7 __imp__IsDebuggerPresent@0 0114 ?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z 0134 ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 014a @_guard_check_icall@4 016e ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 017b __imp__WideCharToMultiByte@32 01a2 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 01cc ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 01f4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 3C 0E 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 53 56 57 8B 7D 08 33 DB 89 85 C8 F1 FF FF 8B 45 14 57 89 85 CC F1 FF FF E8 ?? ?? ?? ?? 8B F0 59 85 F6 75 09 57 E8 ?? ?? ?? ?? 59 8B D8 33 C0 50 50 6A FF FF B5 CC F1 FF FF 50 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 3D 00 02 00 00 73 2F 50 8D 85 D4 F1 FF FF 50 6A FF FF B5 CC F1 FF FF 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 0E 8D 85 D4 F1 FF FF 89 85 D0 F1 FF FF EB 0A C7 85 D0 F1 FF FF ?? ?? ?? ?? 68 02 10 00 00 E8 ?? ?? ?? ?? 59 85 C0 74 29 FF B5 D0 F1 FF FF 8B 85 C8 F1 FF FF 57 FF 34 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 85 1C 01 00 00 32 C0 EB 02 B0 01 85 DB 75 08 85 F6 0F 84 09 01 00 00 84 C0 74 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 F7 00 00 00 B9 04 01 00 00 8D 85 EC FB FF FF 51 50 8D 85 C4 F1 FF FF 50 51 8D 85 F4 FD FF FF 50 8D 47 FB 50 E8 ?? ?? ?? ?? 83 C4 18 85 F6 74 36 FF B5 D0 F1 FF FF 8D 85 EC FB FF FF 8B CE FF B5 C8 F1 FF FF 68 ?? ?? ?? ?? 50 FF B5 C4 F1 FF FF 8D 85 F4 FD FF FF 50 FF 75 0C E8 ?? ?? ?? ?? FF D6 E9 8D 00 00 00 33 C9 8D 85 E0 F8 FF FF 51 51 68 0A 03 00 00 50 6A FF 8D 85 F4 FD FF FF BF ?? ?? ?? ?? 50 51 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 06 8D BD E0 F8 FF FF 33 C9 8D 85 D4 F5 FF FF 51 51 68 0A 03 00 00 50 6A FF 8D 85 EC FB FF FF BE ?? ?? ?? ?? 50 51 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 06 8D B5 D4 F5 FF FF FF B5 CC F1 FF FF 8B CB FF B5 C8 F1 FF FF 68 ?? ?? ?? ?? 56 FF B5 C4 F1 FF FF 57 FF 75 0C E8 ?? ?? ?? ?? FF D3 83 C4 1C 83 F8 01 75 01 CC 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_300_9_0 {
	meta:
		name = "__RTC_UninitUse"
		size = 223
		refs = "000a ___security_cookie 0015 ?_RTC_ErrorLevels@@3PAHA 004c ?uninit_premsg@@3QBDB 0082 ?uninit_postmsg@@3QBDB 00b8 ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 00c9 ?failwithmessage@@YAXPAXHHPBD@Z 00d7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 04 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 55 08 0F 84 AE 00 00 00 53 85 D2 0F 84 8B 00 00 00 8B CA 8A 01 41 84 C0 75 F9 2B CA 83 C1 39 81 F9 00 04 00 00 77 75 8D 9D FC FB FF FF 33 C9 8A 81 ?? ?? ?? ?? 88 84 0D FC FB FF FF 41 84 C0 75 EE 56 57 8B F2 8A 02 42 84 C0 75 F9 8D BD FC FB FF FF 2B D6 4F 8A 47 01 47 84 C0 75 F8 8B CA C1 E9 02 F3 A5 8B CA BA ?? ?? ?? ?? 83 E1 03 F3 A4 8B F2 8A 02 42 84 C0 75 F9 8D BD FC FB FF FF 2B D6 4F 8A 47 01 47 84 C0 75 F8 8B CA C1 E9 02 F3 A5 8B CA 83 E1 03 F3 A4 5F 5E EB 05 BB ?? ?? ?? ?? 53 6A 03 FF 35 ?? ?? ?? ?? FF 75 04 E8 ?? ?? ?? ?? 83 C4 10 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_300_11_0 {
	meta:
		name = "__vsprintf_s_l"
		size = 45
		refs = "0013 ___local_stdio_printf_options 001d ___stdio_common_vsprintf_s"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 70 04 FF 30 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 79 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_300_12_0 {
	meta:
		name = "_sprintf_s"
		size = 28
		refs = "0013 __vsprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 14 50 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "__alloca_probe_16"
		size = 44
		refs = "0012 __chkstk"
	strings:
		$1 = { 51 8D 4C 24 08 2B C8 83 E1 0F 03 C1 1B C9 0B C1 59 E9 ?? ?? ?? ?? 51 8D 4C 24 08 2B C8 83 E1 07 03 C1 1B C9 0B C1 59 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__allshr"
		size = 33
	strings:
		$1 = { 80 F9 40 73 16 80 F9 20 73 06 0F AD D0 D3 FA C3 8B C2 C1 FA 1F 80 E1 1F D3 F8 C3 C1 FA 1F 8B C2 C3 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "__alldiv"
		size = 170
	strings:
		$1 = { 57 56 53 33 FF 8B 44 24 14 0B C0 7D 14 47 8B 54 24 10 F7 D8 F7 DA 83 D8 00 89 44 24 14 89 54 24 10 8B 44 24 1C 0B C0 7D 14 47 8B 54 24 18 F7 D8 F7 DA 83 D8 00 89 44 24 1C 89 54 24 18 0B C0 75 18 8B 4C 24 18 8B 44 24 14 33 D2 F7 F1 8B D8 8B 44 24 10 F7 F1 8B D3 EB 41 8B D8 8B 4C 24 18 8B 54 24 14 8B 44 24 10 D1 EB D1 D9 D1 EA D1 D8 0B DB 75 F4 F7 F1 8B F0 F7 64 24 1C 8B C8 8B 44 24 18 F7 E6 03 D1 72 0E 3B 54 24 14 77 08 72 07 3B 44 24 10 76 01 4E 33 D2 8B C6 4F 75 07 F7 DA F7 D8 83 DA 00 5B 5E 5F C2 10 00 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "___avx_log10f8"
		size = 368
		refs = "0010 ___common_slog10_data 0166 ___common_slog10_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 F8 10 1D ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 F9 FA EB C4 E3 7D 19 C1 01 C5 C9 72 E5 17 C5 F1 FA D3 C5 D1 DB EC C5 F1 72 E2 17 C5 E9 DB D4 C5 E9 FE E3 C5 FC C2 15 ?? ?? ?? ?? 16 C4 E3 4D 18 F9 01 C5 FC 5B CF C5 D1 FE FB C5 FC C2 1D ?? ?? ?? ?? 11 C5 C9 EF F6 C5 E4 56 EA C4 E3 45 18 FC 01 C5 C4 5C 3D ?? ?? ?? ?? C4 E3 7D 19 EC 01 C5 D1 6B DC C5 C4 59 2D ?? ?? ?? ?? C5 E1 63 D6 C5 C4 59 25 ?? ?? ?? ?? C5 D4 58 35 ?? ?? ?? ?? C5 F9 D7 D2 C5 DC 58 1D ?? ?? ?? ?? C5 C4 59 EF C5 C4 59 15 ?? ?? ?? ?? C5 CC 59 F5 C5 EC 58 25 ?? ?? ?? ?? C5 CC 58 F3 C5 C4 59 1D ?? ?? ?? ?? C5 E4 58 15 ?? ?? ?? ?? C5 CC 59 DD C5 E4 58 E4 C5 DC 59 ED C5 F4 59 25 ?? ?? ?? ?? C5 F4 59 0D ?? ?? ?? ?? C5 D4 58 D2 C5 EC 59 D7 C5 EC 58 1D ?? ?? ?? ?? C5 E4 59 FF C5 C4 58 D4 C5 F4 58 CA 84 D2 75 08 C5 FC 28 C1 8B E5 5D C3 C5 FC 11 44 24 40 C5 FC 11 8C 24 80 00 00 00 85 D2 74 E5 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 8C 24 80 00 00 00 EB BB C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 90 }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 56
		refs = "0006 __ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z 0016 ___security_cookie 0031 ??2@YAPAXI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 53 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 89 65 F0 FF 75 08 83 65 FC 00 E8 ?? ?? ?? ?? 59 EB 08 }
	condition:
		$1
}

rule file_315_1_0 {
	meta:
		name = "__catch$??2@YAPAXIABUnothrow_t@std@@@Z$0"
		size = 26
		refs = "0001 $LN7"
	strings:
		$1 = { B8 ?? ?? ?? ?? C3 33 C0 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_315_2_0 {
	meta:
		name = "__ehhandler$??2@YAPAXIABUnothrow_t@std@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??2@YAPAXIABUnothrow_t@std@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_15_2 {
	meta:
		name = "__ehhandler$??$_Construct1@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXU?$integral_constant@_N$00@1@AAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$_Construct1@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXU?$integral_constant@_N$00@1@AAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_26_2 {
	meta:
		name = "__ehhandler$??$construct@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXAAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$construct@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@?$allocator_traits@U?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@@std@@SAXAAU?$_StaticAllocator@V?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@@@PAV?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@1@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_93_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_229_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_232_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N1@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_41_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_73_68_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_63_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_121_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_279_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_282_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@IG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_285_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_288_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBGI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_295_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_110_30_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@I_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_301_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_304_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_WI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_75_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_329_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_276_2 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_133_1 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_279_2 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_338_1 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_6_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@ABV012@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@ABV012@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_45_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_46_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_46_2 {
	meta:
		name = "__ehhandler$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@AAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_13_3 {
	meta:
		name = "__ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_82_1 {
	meta:
		name = "__ehhandler$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallCopyCtor@__ExceptionPtr@@ABEXPAX0IQBU_s_CatchableType@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_50_1 {
	meta:
		name = "__ehhandler$?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_New_Locimp@_Locimp@locale@std@@CAPAV123@ABV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_143_1 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_118_2 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_118_2 {
	meta:
		name = "__ehhandler$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_18_1 {
	meta:
		name = "__ehhandler$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_18_2 {
	meta:
		name = "__ehhandler$?create_stl_condition_variable@details@Concurrency@@YAXPAVstl_condition_variable_interface@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?create_stl_condition_variable@details@Concurrency@@YAXPAVstl_condition_variable_interface@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_18_2 {
	meta:
		name = "__ehhandler$?create_stl_critical_section@details@Concurrency@@YAXPAVstl_critical_section_interface@12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?create_stl_critical_section@details@Concurrency@@YAXPAVstl_critical_section_interface@12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_432_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1186_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1189_2 {
	meta:
		name = "__ehhandler$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "___vdecl_fmodf4"
		size = 89
		refs = "0016 __CIfmod"
	strings:
		$1 = { 83 EC 20 F3 0F 7F 04 24 F3 0F 7F 4C 24 10 D9 04 24 D9 44 24 10 E8 ?? ?? ?? ?? D9 1C 24 D9 44 24 04 D9 44 24 14 E8 ?? ?? ?? ?? D9 5C 24 04 D9 44 24 08 D9 44 24 18 E8 ?? ?? ?? ?? D9 5C 24 08 D9 44 24 0C D9 44 24 1C E8 ?? ?? ?? ?? D9 5C 24 0C F3 0F 6F 04 24 83 C4 20 C3 }
	condition:
		$1
}

rule file_322_0_0 {
	meta:
		name = "___sse4_floorf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_323_1_0 {
	meta:
		name = "__ftol2_pentium4"
		size = 19
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F8 DD 1C 24 F2 0F 2C 04 24 C9 C3 }
	condition:
		$1
}

rule file_323_2_0 {
	meta:
		name = "__ftol2_sse_excpt"
		size = 36
		refs = "0002 ___isa_available"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 1B 83 EC 04 D9 3C 24 58 66 83 E0 7F 66 83 F8 7F 74 D3 8D A4 24 00 00 00 00 8D 49 00 }
	condition:
		$1
}

rule file_323_3_0 {
	meta:
		name = "__ftol2"
		size = 117
	strings:
		$1 = { 55 8B EC 83 EC 20 83 E4 F0 D9 C0 D9 54 24 18 DF 7C 24 10 DF 6C 24 10 8B 54 24 18 8B 44 24 10 85 C0 74 3C DE E9 85 D2 79 1E D9 1C 24 8B 0C 24 81 F1 00 00 00 80 81 C1 FF FF FF 7F 83 D0 00 8B 54 24 14 83 D2 00 EB 2C D9 1C 24 8B 0C 24 81 C1 FF FF FF 7F 83 D8 00 8B 54 24 14 83 DA 00 EB 14 8B 54 24 14 F7 C2 FF FF FF 7F 75 B8 D9 5C 24 18 D9 5C 24 18 C9 C3 }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "@__mpx_init_static_rep@8"
		size = 49
	strings:
		$1 = { 56 8B F2 85 C9 F2 74 27 85 F6 F2 74 22 8D 51 04 8B 0A 8D 52 0C 8B 42 F8 2B C1 F3 0F 1B 44 01 FF 8B 4A F0 8B 01 0F 1B 04 01 83 EE 01 F2 75 E1 5E C3 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "___avx_tanhf8"
		size = 624
		refs = "001d ___common_stanh_data 0266 ___common_stanh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC B4 00 00 00 C5 FC 28 E0 C5 FC 11 64 24 20 C5 F8 10 35 ?? ?? ?? ?? C5 F8 10 3D ?? ?? ?? ?? C5 F8 10 0D ?? ?? ?? ?? C5 DC 54 05 ?? ?? ?? ?? C5 DC 54 2D ?? ?? ?? ?? C5 FC 11 2C 24 C5 D9 DB DE C4 E3 7D 19 E2 01 C5 E1 66 EF C5 E9 DB D6 C5 E9 66 FF C5 C9 EF F6 C5 D1 6B EF C5 D1 63 E6 C5 E9 FA E9 C5 F9 D7 C4 C5 E1 FA E1 C5 F8 10 0D ?? ?? ?? ?? C5 D9 66 DE C5 D9 DB D3 C5 D9 66 E1 C5 D1 66 F6 C4 E3 69 4A E1 40 C5 D1 DB F6 C5 D1 66 E9 C4 E3 49 4A C9 50 C5 C9 72 D4 0E C5 F9 7E F3 C5 D1 72 D1 0E C5 F9 7E EE C5 F9 10 A3 ?? ?? ?? ?? C4 E3 79 16 F1 01 C4 E3 79 16 F2 03 C4 E3 79 16 EF 01 89 84 24 80 00 00 00 C5 F9 10 91 ?? ?? ?? ?? C4 E3 79 16 F0 02 89 B4 24 84 00 00 00 C5 F9 10 B6 ?? ?? ?? ?? 89 BC 24 88 00 00 00 C4 E3 79 16 EE 03 C4 E3 6D 18 8A ?? ?? ?? ?? 01 C5 F9 10 97 ?? ?? ?? ?? C4 E3 79 16 EF 02 C4 E3 5D 18 B8 ?? ?? ?? ?? 01 C5 C5 14 D9 C5 C5 15 E1 C5 F9 10 B9 ?? ?? ?? ?? C5 FD 11 5C 24 40 C5 F9 10 9B ?? ?? ?? ?? 8B 8C 24 88 00 00 00 C4 E3 4D 18 B7 ?? ?? ?? ?? 01 C4 E3 6D 18 96 ?? ?? ?? ?? 01 C5 CD 14 EA C5 FD 11 6C 24 60 C5 CD 15 EA C4 E3 45 18 B2 ?? ?? ?? ?? 01 8B 94 24 84 00 00 00 C4 E3 65 18 88 ?? ?? ?? ?? 01 C5 F5 14 D6 C5 F5 15 CE C5 F9 10 B2 ?? ?? ?? ?? C5 F9 10 99 ?? ?? ?? ?? C4 E3 4D 18 BF ?? ?? ?? ?? 01 C4 E3 65 18 B6 ?? ?? ?? ?? 01 C5 C5 14 DE C5 C5 15 FE 8B B4 24 80 00 00 00 8B C6 C5 FC 5A F0 C4 E3 7D 19 C0 01 C5 F5 59 CE C5 FC 5A C0 C5 F5 58 D2 C5 C5 59 F8 C5 ED 59 D6 C5 C5 58 CB C5 ED 58 D4 C5 F5 59 E0 C5 DD 58 CD C5 ED 59 EE C5 F5 59 D8 C5 D5 58 54 24 40 C5 E5 58 44 24 60 C5 FD 5A F2 C5 FD 5A C8 C4 E3 4D 18 D1 01 C5 EC 56 04 24 84 C0 75 0D 81 C4 B4 00 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 10 4C 24 20 C5 FC 11 44 24 40 C5 FC 11 0C 24 85 F6 74 DE 33 DB 0F A3 DE 72 19 43 83 FB 20 7C F5 C5 FC 10 44 24 40 81 C4 B4 00 00 00 5B 5F 5E 8B E5 5D C3 C5 F8 77 8D 44 9C 40 8D 14 9C 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB D1 90 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 164
		refs = "0004 __set_app_type 0009 __get_startup_file_mode 000f __set_fmode 0014 ___p__commode 001b __get_startup_commit_mode 0024 ___scrt_initialize_onexit_tables 0033 __RTC_Initialize 0038 __RTC_Terminate 003d _atexit 0042 __get_startup_argv_mode 0048 __configure_narrow_argv 0053 ?__scrt_initialize_type_info@@YAXXZ 0058 ___scrt_is_user_matherr_present 0061 __matherr 0066 ___setusermatherr 006c __initialize_invalid_parameter_handler 0071 __initialize_denormal_control 0076 __initialize_default_precision 007b __get_startup_thread_locale_mode 0081 __configthreadlocale 0087 __should_initialize_environment 0090 __initialize_narrow_environment 0095 ___scrt_initialize_winrt 009f ___scrt_fastfail"
	strings:
		$1 = { 56 6A 01 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 6A 01 89 06 E8 ?? ?? ?? ?? 83 C4 0C 5E 84 C0 74 6C DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 4A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 C3 6A 07 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 164
		refs = "0004 __set_app_type 0009 __get_startup_file_mode 000f __set_fmode 0014 ___p__commode 001b __get_startup_commit_mode 0024 ___scrt_initialize_onexit_tables 0033 __RTC_Initialize 0038 __RTC_Terminate 003d _atexit 0042 __get_startup_argv_mode 0048 __configure_wide_argv 0053 ?__scrt_initialize_type_info@@YAXXZ 0058 ___scrt_is_user_matherr_present 0061 __matherr 0066 ___setusermatherr 006c __initialize_invalid_parameter_handler 0071 __initialize_denormal_control 0076 __initialize_default_precision 007b __get_startup_thread_locale_mode 0081 __configthreadlocale 0087 __should_initialize_environment 0090 __initialize_wide_environment 0095 ___scrt_initialize_winrt 009f ___scrt_fastfail"
	strings:
		$1 = { 56 6A 01 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 6A 01 89 06 E8 ?? ?? ?? ?? 83 C4 0C 5E 84 C0 74 6C DB E2 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 4A E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 C3 6A 07 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_331_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 367
		refs = "0003 __sehtable$?__scrt_common_main_seh@@YAHXZ 0008 __SEH_prolog4 000f ___scrt_initialize_crt 001b ___scrt_fastfail 0029 ___scrt_acquire_startup_lock 0031 ___scrt_current_native_startup_state 0047 ___xi_z 004c ___xi_a 0051 __initterm_e 006d ___xc_z 0072 ___xc_a 0077 __initterm 0092 ___scrt_release_startup_lock 0098 ___scrt_get_dyn_tls_init_callback 00a6 ___scrt_is_nonwritable_in_current_image 00b8 @_guard_check_icall@4 00bf ___scrt_get_dyn_tls_dtor_callback 00d7 __register_thread_local_exe_atexit_callback 00dd ___p___argv 00e4 ___p___argc 00eb __get_initial_narrow_environment 00f5 _main 00ff ___scrt_is_managed_app 0109 _exit 0112 __cexit 011b ___scrt_uninitialize_crt 0139 __seh_filter_exe 0150 __exit 015b __c_exit 016a __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 59 84 C0 75 07 6A 07 E8 ?? ?? ?? ?? 32 DB 88 5D E7 83 65 FC 00 E8 ?? ?? ?? ?? 88 45 DC A1 ?? ?? ?? ?? 33 C9 41 3B C1 74 DC 85 C0 75 49 89 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 74 11 C7 45 FC FE FF FF FF B8 FF 00 00 00 E9 FD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 C7 05 ?? ?? ?? ?? 02 00 00 00 EB 05 8A D9 88 5D E7 FF 75 DC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B F0 33 FF 39 3E 74 1A 56 E8 ?? ?? ?? ?? 59 84 C0 74 0F 57 6A 02 57 8B 36 8B CE E8 ?? ?? ?? ?? FF D6 E8 ?? ?? ?? ?? 8B F0 39 3E 74 13 56 E8 ?? ?? ?? ?? 59 84 C0 74 08 FF 36 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 50 FF 37 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 E8 ?? ?? ?? ?? 84 C0 75 06 56 E8 ?? ?? ?? ?? 84 DB 75 05 E8 ?? ?? ?? ?? 6A 00 6A 01 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF 8B C6 EB 3D 8B 4D EC 8B 01 8B 00 89 45 E0 51 50 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 E8 ?? ?? ?? ?? 84 C0 75 08 FF 75 E0 E8 ?? ?? ?? ?? 80 7D E7 00 75 05 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_409_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 367
		refs = "0003 __sehtable$?__scrt_common_main_seh@@YAHXZ 0008 __SEH_prolog4 000f ___scrt_initialize_crt 001b ___scrt_fastfail 0029 ___scrt_acquire_startup_lock 0031 ___scrt_current_native_startup_state 0047 ___xi_z 004c ___xi_a 0051 __initterm_e 006d ___xc_z 0072 ___xc_a 0077 __initterm 0092 ___scrt_release_startup_lock 0098 ___scrt_get_dyn_tls_init_callback 00a6 ___scrt_is_nonwritable_in_current_image 00b8 @_guard_check_icall@4 00bf ___scrt_get_dyn_tls_dtor_callback 00d7 __register_thread_local_exe_atexit_callback 00dd ___p___wargv 00e4 ___p___argc 00eb __get_initial_wide_environment 00f5 _wmain 00ff ___scrt_is_managed_app 0109 _exit 0112 __cexit 011b ___scrt_uninitialize_crt 0139 __seh_filter_exe 0150 __exit 015b __c_exit 016a __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 59 84 C0 75 07 6A 07 E8 ?? ?? ?? ?? 32 DB 88 5D E7 83 65 FC 00 E8 ?? ?? ?? ?? 88 45 DC A1 ?? ?? ?? ?? 33 C9 41 3B C1 74 DC 85 C0 75 49 89 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 74 11 C7 45 FC FE FF FF FF B8 FF 00 00 00 E9 FD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 C7 05 ?? ?? ?? ?? 02 00 00 00 EB 05 8A D9 88 5D E7 FF 75 DC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B F0 33 FF 39 3E 74 1A 56 E8 ?? ?? ?? ?? 59 84 C0 74 0F 57 6A 02 57 8B 36 8B CE E8 ?? ?? ?? ?? FF D6 E8 ?? ?? ?? ?? 8B F0 39 3E 74 13 56 E8 ?? ?? ?? ?? 59 84 C0 74 08 FF 36 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 50 FF 37 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 E8 ?? ?? ?? ?? 84 C0 75 06 56 E8 ?? ?? ?? ?? 84 DB 75 05 E8 ?? ?? ?? ?? 6A 00 6A 01 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF 8B C6 EB 3D 8B 4D EC 8B 01 8B 00 89 45 E0 51 50 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 E8 ?? ?? ?? ?? 84 C0 75 08 FF 75 E0 E8 ?? ?? ?? ?? 80 7D E7 00 75 05 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_331_8_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 37
		refs = "0003 ___p___argv 000a ___p___argc 0011 __get_initial_narrow_environment 001b _main"
	strings:
		$1 = { 56 57 E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 50 FF 37 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C3 }
	condition:
		$1
}

rule file_409_8_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 37
		refs = "0003 ___p___wargv 000a ___p___argc 0011 __get_initial_wide_environment 001b _wmain"
	strings:
		$1 = { 56 57 E8 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 50 FF 37 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C3 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__SEH_prolog4_GS"
		size = 73
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 89 45 E4 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_335_1_0 {
	meta:
		name = "__SEH_epilog4_GS"
		size = 17
		refs = "0007 @__security_check_cookie@4 000d __SEH_epilog4"
	strings:
		$1 = { 8B 4D E4 33 CD F2 E8 ?? ?? ?? ?? F2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__aullshr"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F AD D0 D3 EA C3 8B C2 33 D2 80 E1 1F D3 E8 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__FindPESection"
		size = 67
	strings:
		$1 = { 55 8B EC 8B 45 08 33 D2 53 56 57 8B 48 3C 03 C8 0F B7 41 14 0F B7 59 06 83 C0 18 03 C1 85 DB 74 1B 8B 7D 0C 8B 70 0C 3B FE 72 09 8B 48 08 03 CE 3B F9 72 0A 42 83 C0 28 3B D3 72 E8 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "__IsNonwritableInCurrentImage"
		size = 186
		refs = "0006 __sehtable$__IsNonwritableInCurrentImage 000b __except_handler4 001d ___security_cookie 003b ___ImageBase 0040 __ValidateImageBase 005a __FindPESection"
	strings:
		$1 = { 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 54 8B 45 08 2D ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 3A 8B 40 24 C1 E8 1F F7 D0 83 E0 01 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 8B 45 EC 8B 00 33 C9 81 38 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 C7 45 FC FE FF FF FF 33 C0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "__ValidateImageBase"
		size = 49
	strings:
		$1 = { 55 8B EC 8B 45 08 B9 4D 5A 00 00 66 39 08 74 04 33 C0 5D C3 8B 48 3C 03 C8 33 C0 81 39 50 45 00 00 75 0C BA 0B 01 00 00 66 39 51 18 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "___sse2_acosf4"
		size = 352
		refs = "000f ___common_sacos_data 014f ___common_sacos_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 0F 28 3D ?? ?? ?? ?? 0F 28 F7 0F 54 F8 0F 56 F0 0F 28 15 ?? ?? ?? ?? 0F 28 E6 0F 59 E2 0F 28 EE 0F 59 EE 0F 58 E2 0F 52 D4 0F 5D EC 0F 28 DE 0F 28 CA 0F C2 1D ?? ?? ?? ?? 02 0F 59 CA 0F 50 D3 0F 28 DD 0F 29 3C 24 0F C2 DC 05 0F 58 E4 0F 59 D4 85 D2 0F 59 E1 0F 28 3D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 59 CD 0F 5C 25 ?? ?? ?? ?? 0F 59 FC 0F 58 0D ?? ?? ?? ?? 0F 59 E2 0F 58 3D ?? ?? ?? ?? 0F 59 FC 0F 28 E5 0F 59 E5 0F 5C D7 0F 59 CC 0F 28 3D ?? ?? ?? ?? 0F 28 E0 0F 59 FD 0F 54 D3 0F C2 E5 01 0F 58 3D ?? ?? ?? ?? 0F 58 CF 0F 28 FB 0F 59 CD 0F 55 3D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 CD 0F 28 2D ?? ?? ?? ?? 0F 54 EB 0F 54 EC 0F 28 E3 0F 55 E6 0F 58 FD 0F 56 E2 0F 57 24 24 0F 59 CC 0F 58 CC 0F 58 F9 75 07 0F 28 C7 8B E5 5D C3 0F 29 44 24 40 0F 29 BC 24 80 00 00 00 74 EA 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 8B CE B8 01 00 00 00 D3 E0 85 F8 75 17 46 83 FE 20 7C ED 8B 74 24 04 8B 3C 24 0F 28 BC 24 80 00 00 00 EB B9 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB D2 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "__EH_prolog"
		size = 32
	strings:
		$1 = { 6A FF 50 64 A1 00 00 00 00 50 8B 44 24 0C 64 89 25 00 00 00 00 89 6C 24 0C 8D 6C 24 0C 50 F2 C3 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "___avx_sinhf8"
		size = 368
		refs = "0014 ___common_ssinh_data 0162 ___common_ssinh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 28 C8 C5 F4 54 2D ?? ?? ?? ?? C5 D4 57 F9 C5 FC 10 35 ?? ?? ?? ?? C5 C4 59 25 ?? ?? ?? ?? C5 F8 10 05 ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 FC 11 0C 24 C5 DC 58 CE C5 C1 66 E0 C4 E3 7D 19 FB 01 C5 E1 66 D8 C5 D9 6B C3 C5 D9 EF E4 C5 F9 63 DC C5 F4 5C C6 C5 F9 D7 D3 C5 FC 59 35 ?? ?? ?? ?? C5 FC 59 05 ?? ?? ?? ?? C5 C4 5C FE C5 C4 5C D8 C5 E4 59 E3 C5 C9 72 F1 17 C4 E3 7D 19 CF 01 C5 E9 FE CE C5 F9 72 F7 17 C5 E9 FA F6 C5 E9 FE F8 C5 E9 FA D0 C4 E3 75 18 FF 01 C5 DC 59 0D ?? ?? ?? ?? C4 E3 4D 18 F2 01 C5 F4 58 15 ?? ?? ?? ?? C5 C4 58 C6 C5 C4 5C FE C5 EC 59 F4 C5 CC 59 CB C5 F4 58 F3 C5 DC 59 1D ?? ?? ?? ?? C5 FC 59 C6 C5 E4 58 0D ?? ?? ?? ?? C5 F4 59 D4 C5 EC 58 1D ?? ?? ?? ?? C5 E4 59 E4 C5 DC 59 CF C5 FC 58 C1 C5 FC 58 FF C5 D4 56 C7 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB BA C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE EB 03 CC CC CC }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "___common_datan_cout_rare"
		size = 1520
		refs = "004a __vmldAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 53 83 EC 34 8B 45 08 0F B7 50 06 81 E2 F0 7F 00 00 C1 EA 04 81 FA FF 07 00 00 0F 84 66 05 00 00 F2 0F 10 00 0F B6 58 07 8B CB F2 0F 11 44 24 28 83 E3 7F 88 5C 24 2F F2 0F 10 44 24 28 C1 E9 07 66 0F 2F 05 ?? ?? ?? ?? 0F 82 0A 04 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 BF 03 00 00 8B 40 04 0F 28 F8 F2 0F 11 04 24 25 FF FF 0F 00 C1 E2 14 8B 5C 24 04 0B D0 8B C3 81 E3 00 00 08 00 25 00 00 F0 FF 81 CB 00 00 04 00 0B C3 81 C2 00 00 40 C0 C7 04 24 00 00 00 00 89 44 24 04 F2 0F 10 0D ?? ?? ?? ?? 0F 28 E1 F2 0F 5C 3C 24 F2 0F 59 E7 F2 0F 11 64 24 08 F2 0F 10 54 24 08 C1 FA 0F F2 0F 5C D7 F2 0F 11 54 24 10 83 E2 F0 F2 0F 10 5C 24 08 F2 0F 10 6C 24 10 C1 E1 07 F2 0F 5C DD F2 0F 11 5C 24 08 0F 28 E8 F2 0F 10 74 24 08 F2 0F 59 2D ?? ?? ?? ?? F2 0F 5C FE F2 0F 11 7C 24 10 F2 0F 10 5C 24 08 F2 0F 10 64 24 10 F2 0F 11 6C 24 08 F2 0F 10 74 24 08 F2 0F 5C 74 24 28 F2 0F 11 74 24 10 F2 0F 10 6C 24 08 F2 0F 10 54 24 10 F2 0F 5C EA F2 0F 11 6C 24 08 F2 0F 10 74 24 08 F2 0F 5C C6 F2 0F 11 44 24 10 F2 0F 10 7C 24 08 F2 0F 10 04 24 F2 0F 10 54 24 10 F2 0F 59 F8 F2 0F 59 D0 0F 28 EF F2 0F 58 EA F2 0F 11 6C 24 08 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 58 D7 F2 0F 11 54 24 10 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 44 24 08 0F 28 F2 F2 0F 10 6C 24 10 F2 0F 58 F0 F2 0F 11 74 24 08 0F 28 F2 F2 0F 10 7C 24 08 F2 0F 5C F7 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 7C 24 10 F2 0F 58 F7 F2 0F 11 74 24 18 0F 28 F2 F2 0F 10 7C 24 10 F2 0F 58 C7 F2 0F 11 44 24 10 F2 0F 10 44 24 18 F2 0F 5C F0 F2 0F 11 74 24 18 F2 0F 10 74 24 10 F2 0F 10 7C 24 18 F2 0F 58 F7 F2 0F 11 74 24 18 F2 0F 10 7C 24 08 F2 0F 10 44 24 18 F2 0F 58 C5 0F 28 EF F2 0F 59 E9 F2 0F 11 6C 24 08 F2 0F 10 74 24 08 F2 0F 5C F7 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 6C 24 10 F2 0F 5C F5 F2 0F 11 74 24 08 F2 0F 10 6C 24 08 F2 0F 5C FD F2 0F 11 7C 24 10 F2 0F 10 74 24 08 F2 0F 10 6C 24 10 F2 0F 58 E8 0F 28 C2 F2 0F 5E C6 F2 0F 59 C8 F2 0F 11 4C 24 10 F2 0F 10 4C 24 10 F2 0F 5C C8 F2 0F 11 4C 24 18 F2 0F 10 44 24 10 F2 0F 10 7C 24 18 F2 0F 5C C7 F2 0F 11 44 24 18 F2 0F 10 4C 24 18 F2 0F 59 F1 F2 0F 5C D6 F2 0F 10 74 24 18 F2 0F 59 EE F2 0F 11 6C 24 10 F2 0F 10 6C 24 10 F2 0F 5C D5 F2 0F 11 54 24 10 F2 0F 10 7C 24 10 F2 0F 10 74 24 18 F2 0F 10 54 24 10 F2 0F 10 6C 24 18 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 59 FD 0F 28 EE F2 0F 59 F4 F2 0F 59 EB F2 0F 59 DF 0F 28 C7 F2 0F 59 C4 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 C6 F2 0F 10 92 ?? ?? ?? ?? F2 0F 58 C3 F2 0F 11 44 24 08 0F 28 DD F2 0F 10 74 24 08 0F 28 C2 F2 0F 58 DE F2 0F 11 5C 24 08 F2 0F 10 64 24 08 F2 0F 5C EC F2 0F 58 EE F2 0F 11 6C 24 10 F2 0F 10 5C 24 08 0F 28 EB F2 0F 58 C3 F2 0F 59 EB F2 0F 59 FD F2 0F 10 74 24 10 F2 0F 11 44 24 08 F2 0F 10 4C 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C D1 F2 0F 59 FD F2 0F 58 D3 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 11 54 24 10 F2 0F 10 44 24 08 F2 0F 10 64 24 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FD F2 0F 59 DF F2 0F 58 DE F2 0F 58 9A ?? ?? ?? ?? F2 0F 58 DC F2 0F 58 C3 F2 0F 11 44 24 20 0F B6 54 24 27 83 E2 7F 0B D1 8B 4D 0C 88 54 24 27 F2 0F 10 5C 24 20 F2 0F 11 19 E9 5D 01 00 00 F2 0F 10 05 ?? ?? ?? ?? C1 E1 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 20 0F B6 44 24 27 83 E0 7F 8B 55 0C 0B C1 88 44 24 27 F2 0F 10 4C 24 20 F2 0F 11 0A E9 24 01 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 8C 00 00 00 0F 28 C8 F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 C1 E1 07 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 8B 55 0C F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 D0 F2 0F 11 54 24 20 0F B6 44 24 27 83 E0 7F 0B C1 88 44 24 27 F2 0F 10 44 24 20 F2 0F 11 02 E9 8A 00 00 00 0F B7 44 24 2E A9 F0 7F 00 00 74 44 F2 0F 10 0D ?? ?? ?? ?? C1 E1 07 F2 0F 58 C8 F2 0F 11 4C 24 08 F2 0F 10 44 24 08 F2 0F 59 44 24 28 F2 0F 11 44 24 20 0F B6 44 24 27 83 E0 7F 8B 55 0C 0B C1 88 44 24 27 F2 0F 10 54 24 20 F2 0F 11 12 EB 3A F2 0F 59 C0 F2 0F 11 44 24 08 F2 0F 10 44 24 08 C1 E1 07 F2 0F 58 44 24 28 F2 0F 11 44 24 20 0F B6 44 24 27 83 E0 7F 8B 55 0C 0B C1 88 44 24 27 F2 0F 10 4C 24 20 F2 0F 11 0A 33 C0 83 C4 34 5B 8B E5 5D C3 F7 40 04 FF FF 0F 00 75 3F 83 38 00 75 3A F2 0F 10 05 ?? ?? ?? ?? 0F B6 40 07 83 E0 80 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 20 0F B6 54 24 27 83 E2 7F 8B 4D 0C 0B D0 88 54 24 27 F2 0F 10 4C 24 20 F2 0F 11 09 EB AE F2 0F 10 00 8B 45 0C F2 0F 58 C0 F2 0F 11 00 EB 9D 8D A4 24 00 00 00 00 8D 64 24 00 }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "__allshl"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F A5 C2 D3 E0 C3 8B D0 33 C0 80 E1 1F D3 E2 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_363_1_0 {
	meta:
		name = "??__C@YGXPAX0IIP6EX00@ZP6EX0@Z@Z"
		size = 111
		refs = "0003 __sehtable$??__C@YGXPAX0IIP6EX00@ZP6EX0@Z@Z 0008 __SEH_prolog4 0023 @_guard_check_icall@4 004e __SEH_epilog4 006a ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 88 5D E7 89 5D FC 3B 5D 14 74 20 FF 75 0C 8B 4D 18 E8 ?? ?? ?? ?? 8B 4D 08 FF 55 18 8B 45 10 01 45 08 01 45 0C 43 89 5D E0 EB DB B0 01 88 45 E7 C7 45 FC FE FF FF FF E8 0E 00 00 00 E8 ?? ?? ?? ?? C2 18 00 8B 5D E0 8A 45 E7 84 C0 75 0F FF 75 1C 53 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "___common_slog_cout_rare"
		size = 704
		refs = "003f __imlsLnHATab 0068 _2il0floatpacket_72 025a _2il0floatpacket_73"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 18 8B 45 08 8B 55 0C 0F B7 48 02 81 E1 80 7F 00 00 81 F9 80 7F 00 00 0F 84 49 02 00 00 F3 0F 5A 28 F2 0F 11 6C 24 10 0F B7 44 24 16 A9 F0 7F 00 00 75 15 F2 0F 59 2D ?? ?? ?? ?? B9 C4 FF FF FF F2 0F 11 6C 24 10 EB 02 33 C9 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F E8 0F 86 C9 01 00 00 F2 0F 10 1D ?? ?? ?? ?? 0F 28 D5 F2 0F 5C D3 F2 0F 11 54 24 08 80 64 24 0F 7F F2 0F 10 44 24 08 66 0F 2F 05 ?? ?? ?? ?? 0F 86 2E 01 00 00 0F B7 44 24 16 25 F0 7F 00 00 C1 E8 04 F2 0F 11 6C 24 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 8D 8C 01 01 FC FF FF 0F B7 44 24 0E 25 0F 80 FF FF 0D F0 3F FF FF 66 89 44 24 0E F2 0F 10 7C 24 08 0F 28 EF 0F 28 F7 F2 0F 2A D1 F2 0F 58 2D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D4 F2 0F 11 2C 24 8B 0C 24 F2 0F 11 34 24 83 E1 7F F2 0F 10 24 24 F2 0F 5C 25 ?? ?? ?? ?? 8D 04 49 F2 0F 10 04 C5 ?? ?? ?? ?? F2 0F 5C FC F2 0F 59 E0 F2 0F 58 14 C5 ?? ?? ?? ?? F2 0F 58 0C C5 ?? ?? ?? ?? F2 0F 59 C7 F2 0F 5C E3 0F 28 DC 33 C0 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 D8 F2 0F 58 C2 F2 0F 58 E1 F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 59 DB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FB F2 0F 58 C7 F2 0F 58 E0 F2 0F 5A E4 F3 0F 11 22 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C2 F2 0F 59 CA 33 C0 F2 0F 59 C2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 8B E5 5D C3 66 0F 2E E8 7A 02 74 15 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 B8 01 00 00 00 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 5A C9 F3 0F 11 0A 8B E5 5D C3 0F B6 48 03 F7 C1 80 00 00 00 75 12 F3 0F 10 00 33 C0 F3 0F 59 C0 F3 0F 11 02 8B E5 5D C3 F7 00 FF FF 7F 00 75 E6 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 8B E5 5D C3 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 90 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "___common_dlog_cout_rare"
		size = 688
		refs = "003a __imldLnHATab 0063 _2il0floatpacket_70 0248 _2il0floatpacket_71"
	strings:
		$1 = { 55 8B EC 83 E4 F8 83 EC 18 8B 45 08 0F B7 48 06 8B D1 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 3C 02 00 00 F2 0F 10 20 F7 C1 F0 7F 00 00 F2 0F 11 64 24 10 75 15 F2 0F 59 25 ?? ?? ?? ?? BA C4 FF FF FF F2 0F 11 64 24 10 EB 02 33 D2 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F E0 0F 86 C2 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D4 F2 0F 5C D0 F2 0F 11 54 24 08 80 64 24 0F 7F F2 0F 10 4C 24 08 66 0F 2F 0D ?? ?? ?? ?? 0F 86 2B 01 00 00 F2 0F 11 64 24 08 0F B7 4C 24 0E 81 E1 0F 80 FF FF 81 C9 F0 3F FF FF 66 89 4C 24 0E F2 0F 10 74 24 08 0F 28 E6 0F 28 EE 0F B7 44 24 16 25 F0 7F 00 00 F2 0F 58 25 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? C1 E8 04 F2 0F 11 24 24 F2 0F 10 3D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B 4D 0C 8D 94 02 01 FC FF FF 8B 04 24 F2 0F 11 2C 24 83 E0 7F F2 0F 10 24 24 F2 0F 2A DA F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D3 F2 0F 5C F4 F2 0F 59 1D ?? ?? ?? ?? 8D 14 40 33 C0 F2 0F 10 0C D5 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 1C D5 ?? ?? ?? ?? F2 0F 58 14 D5 ?? ?? ?? ?? F2 0F 59 CE F2 0F 5C E0 0F 28 C4 F2 0F 58 E2 F2 0F 58 C1 F2 0F 58 CB F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F8 F2 0F 59 F8 F2 0F 58 CF F2 0F 58 E1 F2 0F 11 21 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C2 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 C2 F2 0F 58 D0 F2 0F 11 10 33 C0 8B E5 5D C3 66 0F 2E E0 7A 02 74 14 F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 8B 45 0C F2 0F 11 08 B8 02 00 00 00 8B E5 5D C3 0F B6 50 07 F7 C2 80 00 00 00 75 15 F2 0F 10 00 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 8B E5 5D C3 F7 40 04 FF FF 0F 00 75 E2 83 38 00 75 DD F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E C0 8B 45 0C F2 0F 11 00 B8 01 00 00 00 8B E5 5D C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "___avx_tanf8"
		size = 4096
		refs = "0013 ___common_stan_data 015d ___common_stan_cout_rare 0204 ___common_stan_reduction_data"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC B4 02 00 00 C5 FC 10 15 ?? ?? ?? ?? C5 FC 54 DA C5 E4 C2 25 ?? ?? ?? ?? 1E C5 EC 55 C8 C5 E9 EF D2 C4 E3 7D 19 E5 01 C5 D9 6B F5 C5 C9 63 FA C5 F9 D7 C7 84 C0 0F 85 20 01 00 00 C5 FC 10 25 ?? ?? ?? ?? 33 DB C5 E4 59 15 ?? ?? ?? ?? C5 EC 58 EC C5 D4 5C F4 C5 CC 59 3D ?? ?? ?? ?? C5 CC 59 25 ?? ?? ?? ?? C5 CC 59 15 ?? ?? ?? ?? C5 CC 59 35 ?? ?? ?? ?? C5 E4 5C DF C5 E4 5C FC C5 C4 5C DA C5 E4 5C D6 C5 EC 59 DA C5 D9 72 F5 1F C4 E3 7D 19 EF 01 C5 D1 72 F5 1E C5 C9 72 F7 1F C5 C1 72 F7 1E C4 E3 5D 18 E6 01 C5 DC 57 C9 C5 E4 59 35 ?? ?? ?? ?? C4 E3 55 18 E7 01 C5 C4 57 FF C5 DC C2 FF 0C C5 CC 58 2D ?? ?? ?? ?? C5 E4 59 25 ?? ?? ?? ?? C5 D4 59 F2 C5 DC 58 25 ?? ?? ?? ?? C5 DC 59 D3 C5 EC 58 2D ?? ?? ?? ?? C5 C4 55 DE C5 C4 54 E5 C5 E4 56 E4 C5 C4 54 D6 C5 C4 55 DD C5 EC 56 EB C5 DC 5E F5 C5 CC 57 D1 84 DB 75 11 C5 FC 28 C2 81 C4 B4 02 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 11 04 24 C5 FC 11 54 24 40 85 DB 74 E0 33 F6 0F A3 F3 72 0E 46 83 FE 20 7C F5 C5 FC 10 54 24 40 EB CB C5 F8 77 8D 44 B4 40 8D 14 B4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC B8 00 00 80 7F C5 FC 11 44 24 20 C5 F9 6E D8 C5 F9 70 EB 00 C4 E3 55 18 E5 01 C5 FC 54 DC C5 E4 C2 F4 00 C4 E3 7D 19 F7 01 C5 C9 6B DF C5 E1 63 D2 C5 F9 D7 F2 C4 E3 7D 19 C3 01 89 B4 24 90 02 00 00 C5 F8 11 5C 24 70 C5 F8 28 C8 C5 D1 DB D1 C5 D9 72 D2 17 C5 D1 DB D3 C5 D1 72 D2 17 C5 E9 72 F4 01 C5 E9 FE D4 C5 D9 72 F2 02 C5 E9 72 F5 01 C5 F9 7E E6 C5 E9 FE D5 C5 E9 72 F2 02 C5 F8 11 4C 24 60 C4 E3 79 16 E1 01 C4 E3 79 16 E0 02 C4 E3 79 16 E3 03 C5 F9 7E D7 C5 F9 6E A1 ?? ?? ?? ?? C4 E3 79 16 94 24 A8 02 00 00 01 C4 E3 79 16 94 24 AC 02 00 00 02 C4 E3 79 16 D2 03 C5 F9 6E 96 ?? ?? ?? ?? C5 E9 6C EC C5 F9 6E 90 ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? C5 E9 6C D4 89 BC 24 A4 02 00 00 C5 D0 C6 F2 88 C5 F9 6E 97 ?? ?? ?? ?? 8B BC 24 A8 02 00 00 89 9C 24 A0 02 00 00 C5 F9 6E 82 ?? ?? ?? ?? C5 F9 6E A7 ?? ?? ?? ?? 8B BC 24 AC 02 00 00 C5 E9 6C EC C5 F9 6E A2 ?? ?? ?? ?? C5 F9 6E 97 ?? ?? ?? ?? C5 E9 6C D4 C5 D0 C6 EA 88 C5 F9 6E 96 ?? ?? ?? ?? C5 F9 6E A1 ?? ?? ?? ?? C5 E9 6C FC C5 F9 6E A3 ?? ?? ?? ?? 8B 9C 24 A4 02 00 00 C5 F9 6E 90 ?? ?? ?? ?? C5 E9 6C D4 C5 C0 C6 FA 88 C5 F9 6E 93 ?? ?? ?? ?? 8B 9C 24 A8 02 00 00 C5 F8 11 B4 24 80 00 00 00 C5 F8 11 AC 24 90 00 00 00 C5 F9 6E A3 ?? ?? ?? ?? C5 E9 6C D4 C5 F9 6E A7 ?? ?? ?? ?? C5 D9 6C E0 C5 E8 C6 D4 88 C5 F9 6E A1 ?? ?? ?? ?? 8B 8C 24 A0 02 00 00 C5 F8 11 94 24 A0 00 00 00 C5 F9 6E 96 ?? ?? ?? ?? BE 00 00 80 00 C5 E9 6C E4 C5 F9 6E 90 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 C5 F9 6E 81 ?? ?? ?? ?? B9 00 00 00 80 C5 E9 6C D0 C5 D8 C6 E2 88 C5 F9 6E 82 ?? ?? ?? ?? BA FF FF 7F 00 C5 F8 11 A4 24 B0 00 00 00 C5 F9 6E 90 ?? ?? ?? ?? B8 00 00 40 47 C5 F9 6E A3 ?? ?? ?? ?? BB 00 00 80 3F C5 E9 6C D4 C5 F9 6E A7 ?? ?? ?? ?? BF FF FF 00 00 C5 D9 6C E0 C5 E8 C6 C4 88 C5 F9 6E D2 C5 F9 70 D2 00 C5 F9 6E E6 C5 F9 70 E4 00 C5 E9 DB DB C5 E9 DB C9 C5 E1 FE D4 C5 F9 6E DF C5 F1 FE CC C5 F9 70 DB 00 BA FF 00 00 00 C5 C9 DB E3 C5 D1 DB F3 C5 D1 72 D7 10 C5 C1 DB FB C5 FA 7F AC 24 F0 00 00 00 BE 00 00 80 28 C5 F8 10 AC 24 A0 00 00 00 BF FF FF 03 00 C5 FA 7F B4 24 E0 00 00 00 C5 C9 72 D5 10 C5 D1 DB EB C5 FA 7F AC 24 30 01 00 00 C5 F8 10 AC 24 B0 00 00 00 C5 F8 11 84 24 C0 00 00 00 C5 F9 72 D0 10 C5 FA 7F 84 24 50 01 00 00 C5 F9 72 D1 10 C5 F1 DB CB C5 D1 72 D5 10 C5 FA 7F AC 24 40 01 00 00 C5 D1 72 D2 10 C5 E9 DB D3 C5 FA 7F A4 24 D0 00 00 00 C4 E2 71 40 E4 C5 FA 7F A4 24 90 01 00 00 C4 E2 69 40 A4 24 E0 00 00 00 C5 FA 7F BC 24 10 01 00 00 C4 E2 71 40 FF C5 FA 7F A4 24 A0 01 00 00 C4 E2 71 40 A4 24 F0 00 00 00 C5 FA 7F B4 24 00 01 00 00 C4 E2 69 40 F6 C5 FA 7F BC 24 D0 01 00 00 C5 FA 7F B4 24 C0 01 00 00 C5 C1 DB F3 C5 FA 6F BC 24 40 01 00 00 C5 FA 7F A4 24 B0 01 00 00 C5 FA 7F 94 24 80 01 00 00 C4 E2 69 40 A4 24 30 01 00 00 C5 E1 DB 94 24 B0 00 00 00 C5 FA 7F 8C 24 70 01 00 00 C4 E2 71 40 CF C5 FA 7F 84 24 60 01 00 00 C4 E2 79 40 D2 C4 E2 79 40 C7 C5 C1 72 D1 10 C5 F9 FE C7 C5 E9 72 D2 10 C5 C9 FE C8 C5 D9 DB C3 C5 E9 FE F1 C5 E1 DB 94 24 C0 00 00 00 C4 E2 51 40 FA C5 FA 7F A4 24 E0 01 00 00 C5 F1 72 D7 10 C5 FA 6F BC 24 50 01 00 00 C5 FA 6F A4 24 80 01 00 00 C4 E2 59 40 E7 C4 E2 51 40 D7 C5 D9 72 D4 10 C5 E9 FE D4 C5 D9 72 D6 10 C5 FA 7F B4 24 F0 01 00 00 C5 F9 FE C2 C5 FA 6F 94 24 60 01 00 00 C5 F1 FE C8 C5 FA 6F B4 24 D0 01 00 00 C4 E2 69 40 BC 24 10 01 00 00 C5 C9 72 D6 10 C5 E1 DB 84 24 B0 01 00 00 C5 C1 FE FE C5 F9 FE C7 C5 FA 6F BC 24 E0 01 00 00 C5 D9 FE C0 C4 E2 51 40 B4 24 30 01 00 00 C5 C1 72 D7 10 C5 FA 7F 8C 24 00 02 00 00 C5 D9 72 D1 10 C5 E1 DB 8C 24 C0 01 00 00 C5 C9 FE F7 C5 F1 FE CE C5 D9 FE F1 C5 FA 6F A4 24 B0 01 00 00 C4 E2 69 40 8C 24 F0 00 00 00 C5 D9 72 D4 10 C5 FA 7F B4 24 20 02 00 00 C5 F1 FE CC C5 E1 DB BC 24 90 01 00 00 C5 D9 72 D6 10 C5 FA 6F B4 24 C0 01 00 00 C5 C1 FE F9 C4 E2 51 40 8C 24 00 01 00 00 C5 C9 72 D6 10 C5 FA 7F 84 24 10 02 00 00 C5 F9 72 D0 10 C5 F9 FE FF C5 F1 FE CE C5 E1 DB 84 24 A0 01 00 00 C5 C9 72 D7 10 C5 F9 FE C1 C5 C1 DB FB C5 D9 FE C8 C5 F8 10 84 24 80 00 00 00 C5 FA 6F A4 24 70 01 00 00 C5 F9 72 D0 10 C4 E2 59 40 E0 C4 E2 69 40 84 24 D0 00 00 00 C5 D9 DB E3 C5 FA 6F 94 24 90 01 00 00 C5 E9 72 D2 10 C5 F9 FE C2 C5 D9 FE E0 C5 C9 FE F4 C5 D9 72 D1 10 C5 F8 10 94 24 90 00 00 00 C5 F9 72 F6 10 C5 FA 6F B4 24 80 01 00 00 C5 F9 FE C7 C5 C1 72 D2 10 C5 F1 DB CB C4 E2 49 40 D7 C4 E2 51 40 B4 24 E0 00 00 00 C5 E9 DB D3 C5 FA 6F AC 24 A0 01 00 00 C5 D1 72 D5 10 C5 C9 FE FD C5 E9 FE D7 C5 D9 FE E2 C5 E9 72 F4 10 C5 E9 FE E9 C5 FA 6F 8C 24 10 02 00 00 C5 E1 DB A4 24 F0 01 00 00 C5 E9 72 F1 10 C5 FA 6F B4 24 20 02 00 00 C5 F9 6E C9 C5 E9 FE D4 C5 C1 72 F6 10 C5 F9 70 E1 00 C5 F9 6E F3 C5 E1 DB 9C 24 00 02 00 00 B9 00 00 00 34 C5 D9 DB 4C 24 60 C5 C1 FE DB C5 F9 70 F6 00 BB FF 01 00 00 C5 D9 DB 64 24 70 C5 F1 EF FE C5 FA 7F 84 24 30 02 00 00 C5 F9 72 D0 09 C5 FA 7F AC 24 40 02 00 00 C5 D1 72 D5 09 C5 FA 7F B4 24 20 01 00 00 C5 D9 EF F6 C5 F9 EB C7 C5 D1 EB EE C4 E3 7D 18 ED 01 C5 F9 6E C0 C5 F9 70 F0 00 B8 DB 0F C9 40 C4 E3 4D 18 FE 01 C5 C4 58 C5 C5 FC 5C F7 C5 F9 6E FA C5 D4 5C EE BA 00 10 C9 40 C5 FC 11 6C 24 40 C5 F9 6E EE C5 F9 70 F5 00 C5 D9 EF EE BE 7A 77 95 B7 C5 F8 11 84 24 50 02 00 00 C4 E3 7D 19 84 24 60 02 00 00 01 C5 F9 70 C7 00 C5 F9 6E FF C5 F9 70 FF 00 BF 00 F0 FF FF C5 FA 7F 84 24 70 02 00 00 C5 F1 EF C6 C5 C1 DB F2 C5 C1 DB FB C5 C9 72 F6 05 C5 C1 72 F7 05 C5 C9 EB F0 C5 C1 EB FD C5 E9 72 D2 12 C5 E1 72 D3 12 C4 E3 7D 18 ED 01 C5 F9 6E C1 B9 FF FF FF 7F C4 E3 4D 18 FF 01 C5 F9 70 F0 00 C5 C4 5C FD C5 F1 EF EE C5 F9 6E CB C5 D9 EF E6 C5 F9 70 C1 00 C5 F9 DB 8C 24 30 02 00 00 BB 00 00 80 35 C5 F9 DB 84 24 40 02 00 00 C5 C9 72 F1 0E C5 C9 EB CA C5 E9 72 F0 0E C5 E9 EB C3 C5 F1 EB CD C5 F9 EB D4 C4 E3 55 18 DC 01 C5 FC 10 64 24 40 C4 E3 75 18 CA 01 C5 F4 5C C3 C5 DC 58 F0 C5 DC 5C CE C5 F9 6E E2 C5 F9 70 EC 00 C5 FC 58 D1 C5 F9 6E CE C5 F9 70 E1 00 C5 EC 58 D7 C5 F9 6E F8 C5 F9 70 C7 00 C5 F9 6E FF C5 F9 70 CF 00 B8 7F 00 00 00 C4 E3 7D 18 D8 01 C4 E3 55 18 C5 01 C4 E3 75 18 E9 01 C5 CC 54 CD C5 CC 5C F1 C5 FC 11 2C 24 C5 FC 59 F9 C5 FC 59 EE C5 E4 59 DA C4 E3 5D 18 E4 01 C5 DC 59 C1 C5 DC 59 F6 C5 D4 58 C0 C5 F9 6E E9 C5 E4 58 CE C5 F9 70 F5 00 C5 FC 58 D9 C5 C4 58 E3 C5 C4 5C D4 C5 F9 6E FB C5 F9 70 C7 00 C5 EC 58 DB C4 E3 4D 18 D6 01 C4 E3 7D 18 F0 01 C5 FC 10 44 24 20 C5 FC 54 EA C5 D4 C2 D6 1E C5 D4 C2 FE 12 C5 EC 54 E4 C5 EC 54 F3 C5 F9 6E D0 C5 FA 6F 9C 24 70 02 00 00 C5 C4 54 E8 C5 F9 70 FA 00 C5 E1 DB 94 24 50 02 00 00 C5 D4 56 EC C5 E9 DB E7 C5 E1 DB 94 24 60 02 00 00 C5 D4 58 CE C5 E9 DB DF C5 C9 72 F4 02 C5 D1 72 F3 02 C5 C9 FE E4 C5 D1 FE D3 C5 D9 72 F4 03 C5 E1 72 F2 03 C5 F9 7E E7 C5 F9 7E D9 C4 E3 79 16 E3 01 C5 F9 6E AF ?? ?? ?? ?? C4 E3 79 16 9C 24 98 02 00 00 01 89 8C 24 94 02 00 00 C5 F9 6E B3 ?? ?? ?? ?? C4 E3 79 16 9C 24 9C 02 00 00 02 C4 E3 79 16 D8 03 C5 D1 6C DE C5 F9 6E A9 ?? ?? ?? ?? C4 E3 79 16 E2 02 C4 E3 79 16 E6 03 8B 8C 24 98 02 00 00 89 BC 24 84 02 00 00 C5 F9 6E BA ?? ?? ?? ?? C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 9C 02 00 00 C5 F9 6E 96 ?? ?? ?? ?? C5 C1 6C E2 C5 E0 C6 D4 88 C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E 98 ?? ?? ?? ?? C5 D1 6C E6 C5 C1 6C EB 89 94 24 8C 02 00 00 C5 D8 C6 F5 88 C5 F9 6E BF ?? ?? ?? ?? C5 F9 6E A2 ?? ?? ?? ?? 8B BC 24 94 02 00 00 8B 94 24 98 02 00 00 C5 F9 6E 9B ?? ?? ?? ?? C5 F9 6E AE ?? ?? ?? ?? 89 9C 24 88 02 00 00 8B 98 ?? ?? ?? ?? 89 9C 24 80 02 00 00 8B 9C 24 90 02 00 00 C4 E3 6D 18 D6 01 C5 C1 6C F3 C5 D9 6C FD C5 C8 C6 DF 88 C5 F9 6E A7 ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 D9 6C ED C5 F9 6E A1 ?? ?? ?? ?? 89 9C 24 90 02 00 00 8B 9C 24 84 02 00 00 C5 FC 11 44 24 20 C5 F9 6E 84 24 80 02 00 00 C5 D9 6C F8 C5 D0 C6 F7 88 C5 F9 6E AB ?? ?? ?? ?? 8B 9C 24 88 02 00 00 C4 E3 65 18 C6 01 C5 F9 6E BE ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? 8B 9C 24 8C 02 00 00 C5 D1 6C F4 89 84 24 34 01 00 00 C5 F9 6E 9B ?? ?? ?? ?? C5 E1 6C EF C5 C8 C6 F5 88 C5 F9 6E A8 ?? ?? ?? ?? 8B 84 24 84 02 00 00 C5 F9 6E A7 ?? ?? ?? ?? C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E B9 ?? ?? ?? ?? C5 D9 6C E3 C5 C1 6C DD C5 F9 6E A8 ?? ?? ?? ?? 8B 84 24 88 02 00 00 C5 D8 C6 FB 88 C5 F9 6E 9B ?? ?? ?? ?? C5 F9 6E A0 ?? ?? ?? ?? C5 D1 6C EC 89 8C 24 9C 02 00 00 89 94 24 98 02 00 00 89 BC 24 94 02 00 00 89 B4 24 30 01 00 00 C4 E3 4D 18 F7 01 C5 F9 6E BE ?? ?? ?? ?? C5 E1 6C E7 C5 D0 C6 DC 88 C5 F9 6E BF ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 C1 6C E5 C5 F9 6E B9 ?? ?? ?? ?? 8B 8C 24 34 01 00 00 C5 F9 6E A9 ?? ?? ?? ?? C5 C1 6C FD 8B 8C 24 84 02 00 00 C5 D8 C6 E7 88 C4 E3 65 18 DC 01 C5 FC 11 5C 24 40 C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? C5 C1 6C FD C5 F9 6E 9E ?? ?? ?? ?? C5 D9 6C EB C5 F9 6E 9A ?? ?? ?? ?? 8B 94 24 9C 02 00 00 C5 F9 6E A7 ?? ?? ?? ?? C5 C0 C6 ED 88 C5 D9 6C FB C5 F9 6E A2 ?? ?? ?? ?? 8B 94 24 34 01 00 00 C5 F9 6E 9A ?? ?? ?? ?? C5 D9 6C E3 C5 C0 C6 FC 88 C4 E3 55 18 EF 01 C5 FC 11 6C 24 60 C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? C5 C1 6C FD C5 F9 6E 9E ?? ?? ?? ?? C5 D9 6C EB C5 F9 6E A7 ?? ?? ?? ?? 8B BC 24 98 02 00 00 C5 C0 C6 DD 88 C5 F9 6E AA ?? ?? ?? ?? C5 F9 6E BF ?? ?? ?? ?? 8B BC 24 9C 02 00 00 C5 D9 6C E7 C5 F9 6E BF ?? ?? ?? ?? C5 C1 6C FD C5 D8 C6 E7 88 C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 C1 6C FD C4 E3 65 18 DC 01 C5 FC 11 9C 24 80 00 00 00 C5 F9 6E 9E ?? ?? ?? ?? C5 F9 6E A3 ?? ?? ?? ?? C5 D9 6C EB C5 C0 C6 ED 88 8B B4 24 94 02 00 00 C5 F9 6E A6 ?? ?? ?? ?? 8B B4 24 98 02 00 00 C5 F9 6E 9E ?? ?? ?? ?? C5 D9 6C FB C5 F9 6E A7 ?? ?? ?? ?? C5 F9 6E 9A ?? ?? ?? ?? C5 D9 6C E3 C5 C0 C6 FC 88 C5 F9 6E A3 ?? ?? ?? ?? 8B 9C 24 30 01 00 00 C4 E3 55 18 EF 01 C5 FC 11 AC 24 A0 00 00 00 C5 F9 6E 9B ?? ?? ?? ?? C5 F9 6E B9 ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 C1 6C FD 8B 9C 24 94 02 00 00 C5 D9 6C EB C5 C0 C6 DD 88 C5 F9 6E A3 ?? ?? ?? ?? C5 F9 6E BE ?? ?? ?? ?? C5 D9 6C E7 C5 F9 6E BF ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 C1 6C FD C5 F9 6E A8 ?? ?? ?? ?? 8B 84 24 8C 02 00 00 C5 D8 C6 E7 88 C5 F9 6E B9 ?? ?? ?? ?? C5 C1 6C FD C4 E3 65 18 DC 01 C5 F9 6E A0 ?? ?? ?? ?? 8B 84 24 30 01 00 00 C5 FC 11 9C 24 C0 00 00 00 C5 F9 6E 98 ?? ?? ?? ?? C5 D9 6C EB C5 C0 C6 ED 88 C5 F9 6E A3 ?? ?? ?? ?? C5 F9 6E 9E ?? ?? ?? ?? C5 D9 6C FB C5 F9 6E A7 ?? ?? ?? ?? C5 F9 6E 9A ?? ?? ?? ?? C5 D9 6C E3 C5 C0 C6 FC 88 C5 F9 6E 98 ?? ?? ?? ?? C4 E3 55 18 EF 01 C5 F9 6E B9 ?? ?? ?? ?? 8B 8C 24 88 02 00 00 C5 FC 11 AC 24 E0 00 00 00 C5 F9 6E A9 ?? ?? ?? ?? C5 C1 6C FD 8B 8C 24 8C 02 00 00 C5 F9 6E A1 ?? ?? ?? ?? C5 D9 6C EB C5 C0 C6 DD 88 C5 F9 6E A3 ?? ?? ?? ?? C5 F9 6E BE ?? ?? ?? ?? C5 D9 6C E7 C5 F9 6E BF ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 C1 6C FD C5 D8 C6 E7 88 C5 EC 5C E9 C5 EC 5C D5 C5 EC 5C D1 8B 9C 24 90 02 00 00 C4 E3 65 18 DC 01 C5 FC 11 9C 24 00 01 00 00 C5 FC 10 1C 24 C5 D4 54 E3 C5 D4 5C EC C5 D4 58 C0 C5 EC 58 E8 C5 FC 53 D4 C5 EC 54 D3 C5 DC 59 E2 C4 E2 7D 1A BC 24 20 01 00 00 C5 C4 5C C4 C5 EC 59 D8 C5 FC 59 E0 C5 E4 58 DA C5 DC 58 FF C5 E4 59 E7 C5 D4 59 FC C5 C4 59 EF C5 C4 5C C0 C5 D4 5C F8 C5 EC 59 EE C5 FC 10 54 24 40 C5 C4 59 C4 C5 F4 59 A4 24 80 00 00 00 C5 FC 59 FE C5 EC 58 F4 C5 EC 5C DE C5 CC 58 D5 C5 E4 58 C4 C5 D4 5C EA C5 F4 59 9C 24 00 01 00 00 C5 F4 59 E1 C5 FC 58 FF C5 D4 58 F6 C5 E4 58 AC 24 E0 00 00 00 C5 F4 59 84 24 C0 00 00 00 C5 C4 58 FE C5 DC 59 F5 C5 FC 58 84 24 A0 00 00 00 C5 C4 58 7C 24 60 C5 CC 58 D8 C5 E4 59 C9 C5 F4 58 C7 C5 EC 58 D0 C5 FC 10 44 24 20 E9 23 F1 FF FF 8D A4 24 00 00 00 00 EB 03 CC CC CC }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__chkstk"
		size = 45
	strings:
		$1 = { 51 8D 4C 24 04 2B C8 1B C0 F7 D0 23 C8 8B C4 25 00 F0 FF FF 3B C8 F2 72 0B 8B C1 59 94 8B 00 89 04 24 F2 C3 2D 00 10 00 00 85 00 EB E7 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "___scrt_fastfail"
		size = 283
		refs = "000e _IsProcessorFeaturePresent@4 002c ___scrt_debugger_hook_flag 0031 _memset 00d7 __imp__IsDebuggerPresent@0 00f6 __imp__SetUnhandledExceptionFilter@4 0100 __imp__UnhandledExceptionFilter@4"
	strings:
		$1 = { 55 8B EC 81 EC 24 03 00 00 53 56 6A 17 E8 ?? ?? ?? ?? 85 C0 74 05 8B 4D 08 CD 29 33 F6 8D 85 DC FC FF FF 68 CC 02 00 00 56 50 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 85 8C FD FF FF 89 8D 88 FD FF FF 89 95 84 FD FF FF 89 9D 80 FD FF FF 89 B5 7C FD FF FF 89 BD 78 FD FF FF 66 8C 95 A4 FD FF FF 66 8C 8D 98 FD FF FF 66 8C 9D 74 FD FF FF 66 8C 85 70 FD FF FF 66 8C A5 6C FD FF FF 66 8C AD 68 FD FF FF 9C 8F 85 9C FD FF FF 8B 45 04 89 85 94 FD FF FF 8D 45 04 89 85 A0 FD FF FF C7 85 DC FC FF FF 01 00 01 00 8B 40 FC 6A 50 89 85 90 FD FF FF 8D 45 A8 56 50 E8 ?? ?? ?? ?? 8B 45 04 83 C4 0C C7 45 A8 15 00 00 40 C7 45 AC 01 00 00 00 89 45 B4 FF 15 ?? ?? ?? ?? 56 8D 58 FF F7 DB 8D 45 A8 89 45 F8 8D 85 DC FC FF FF 1A DB 89 45 FC FE C3 FF 15 ?? ?? ?? ?? 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 75 0D 0F B6 C3 F7 D8 1B C0 21 05 ?? ?? ?? ?? 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_372_1_0 {
	meta:
		name = "___scrt_get_show_window_mode"
		size = 51
		refs = "000f _memset 001c __imp__GetStartupInfoW@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 6A 44 8D 45 BC 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 45 BC 50 FF 15 ?? ?? ?? ?? F6 45 E8 01 74 06 0F B7 45 EC EB 03 6A 0A 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_372_3_0 {
	meta:
		name = "___scrt_is_managed_app"
		size = 68
		refs = "0004 __imp__GetModuleHandleW@4"
	strings:
		$1 = { 6A 00 FF 15 ?? ?? ?? ?? 8B C8 85 C9 75 03 32 C0 C3 B8 4D 5A 00 00 66 39 01 75 F3 8B 41 3C 03 C1 81 38 50 45 00 00 75 E6 B9 0B 01 00 00 66 39 48 18 75 DB 83 78 74 0E 76 D5 83 B8 E8 00 00 00 00 0F 95 C0 C3 }
	condition:
		$1
}

rule file_372_5_0 {
	meta:
		name = "___scrt_unhandled_exception_filter@4"
		size = 65
		refs = "003c _terminate"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 00 81 38 63 73 6D E0 75 25 83 78 10 03 75 1F 8B 40 14 3D 20 05 93 19 74 1B 3D 21 05 93 19 74 14 3D 22 05 93 19 74 0D 3D 00 40 99 01 74 06 33 C0 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "___avx_floor4"
		size = 16
	strings:
		$1 = { C4 E3 7D 09 C0 01 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "___sse4_ceil2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 02 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_383_1_0 {
	meta:
		name = "??_N@YGXPAXIIP6EX0@Z1@Z"
		size = 107
		refs = "0003 __sehtable$??_N@YGXPAXIIP6EX0@Z1@Z 0008 __SEH_prolog4 0024 @_guard_check_icall@4 004a __SEH_epilog4 0066 ?__ArrayUnwind@@YGXPAXIIP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 88 5D E7 89 5D FC 33 C0 40 3B 5D 10 74 1B 50 8B 4D 14 E8 ?? ?? ?? ?? 8B 4D 08 FF 55 14 8B 45 0C 01 45 08 43 89 5D E0 EB DD 88 45 E7 C7 45 FC FE FF FF FF E8 0E 00 00 00 E8 ?? ?? ?? ?? C2 14 00 8B 5D E0 8A 45 E7 84 C0 75 0F FF 75 18 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "___common_dsinh_cout_rare"
		size = 1888
		refs = "0012 __vmldSinhHATab 00f9 _2il0floatpacket_88"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 53 83 EC 78 8B 4D 08 F2 0F 10 15 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 59 06 81 E3 F0 7F 00 00 C1 EB 04 F2 0F 10 19 81 FB FF 07 00 00 0F B6 51 07 F2 0F 11 5C 24 70 0F 84 03 07 00 00 85 DB 0F 8E C5 06 00 00 8B CA 83 E1 7F F2 0F 11 5C 24 10 81 FB C9 03 00 00 88 4C 24 17 0F 8E 84 06 00 00 F2 0F 10 44 24 10 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 4B 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 EA 04 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 69 04 00 00 F2 0F 10 3D ?? ?? ?? ?? 25 0F 80 FF FF F2 0F 59 F8 83 E2 80 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 54 24 68 F2 0F 58 3D ?? ?? ?? ?? F2 0F 11 7C 24 50 F2 0F 10 64 24 50 8B 5C 24 50 8B F3 C1 EE 06 83 E3 3F C1 E3 04 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 CC 8D 8E FF 03 00 00 0F 57 25 ?? ?? ?? ?? 81 C6 FE 03 00 00 F2 0F 59 25 ?? ?? ?? ?? F2 0F 5C C1 0F 28 D0 0F 28 D8 81 E6 FF 07 00 00 F7 D9 C1 E6 04 83 C1 FC 0B C6 81 E1 FF 07 00 00 66 89 44 24 6E 25 0F 80 FF FF C1 E1 04 F2 0F 58 D4 F2 0F 11 54 24 60 0B C1 F2 0F 10 6C 24 60 F2 0F 5C DD F2 0F 11 1C 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 58 EE F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 58 E7 F2 0F 11 24 24 F2 0F 10 64 24 08 F2 0F 5C C4 F2 0F 10 25 ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 34 24 F2 0F 10 44 24 08 F2 0F 58 F0 F2 0F 11 74 24 08 F2 0F 10 74 24 60 0F 28 FE F2 0F 59 FC F2 0F 10 6C 24 08 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 11 74 24 10 F2 0F 5C CE F2 0F 11 0C 24 F2 0F 10 54 24 60 F2 0F 10 04 24 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C D0 F2 0F 11 54 24 60 0F 28 D6 F2 0F 59 D6 F2 0F 59 CA F2 0F 11 6C 24 18 0F 28 EE F2 0F 10 5C 24 60 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C EB F2 0F 59 CA F2 0F 59 CE F2 0F 10 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 11 2C 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 F2 0F 11 44 24 28 F2 0F 10 83 ?? ?? ?? ?? F2 0F 10 5C 24 68 66 89 44 24 6E F2 0F 11 4C 24 30 F2 0F 59 C3 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 0F 28 E8 F2 0F 11 7C 24 20 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 10 93 ?? ?? ?? ?? F7 DB F2 0F 11 74 24 38 F2 0F 10 74 24 68 F2 0F 59 D3 F2 0F 10 8B ?? ?? ?? ?? F2 0F 59 CE F2 0F 10 9B ?? ?? ?? ?? F2 0F 5C E9 F2 0F 59 DE F2 0F 11 6C 24 60 0F 28 F0 F2 0F 10 7C 24 60 F2 0F 5C F7 F2 0F 5C F1 F2 0F 11 34 24 F2 0F 10 74 24 60 F2 0F 10 2C 24 0F 28 FE F2 0F 5C EB F2 0F 58 EA F2 0F 58 D3 F2 0F 58 FD F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C F7 0F 28 F8 F2 0F 58 F9 F2 0F 58 F5 F2 0F 11 34 24 F2 0F 10 6C 24 60 F2 0F 10 34 24 F2 0F 11 7C 24 60 F2 0F 10 7C 24 60 F2 0F 5C C7 F2 0F 58 C1 F2 0F 11 04 24 F2 0F 10 7C 24 60 F2 0F 10 04 24 0F 28 CF F2 0F 58 D0 F2 0F 58 CA F2 0F 11 4C 24 60 F2 0F 10 5C 24 60 F2 0F 5C FB F2 0F 58 FA F2 0F 11 3C 24 F2 0F 10 7C 24 60 F2 0F 59 E7 0F 28 DF F2 0F 10 0C 24 F2 0F 11 64 24 60 F2 0F 10 64 24 60 F2 0F 5C E7 F2 0F 11 24 24 F2 0F 10 44 24 60 F2 0F 10 24 24 F2 0F 5C C4 F2 0F 11 44 24 60 F2 0F 10 54 24 60 F2 0F 5C DA F2 0F 11 1C 24 F2 0F 10 64 24 60 F2 0F 10 04 24 F2 0F 10 5C 24 18 F2 0F 11 44 24 48 0F 28 D3 F2 0F 11 64 24 40 0F 28 E1 F2 0F 10 44 24 30 F2 0F 59 D1 F2 0F 59 E0 F2 0F 59 C7 F2 0F 59 DF F2 0F 58 D4 0F 28 E6 0F 28 F8 F2 0F 59 64 24 38 F2 0F 58 D4 F2 0F 10 64 24 10 F2 0F 59 E1 F2 0F 58 D4 F2 0F 10 64 24 38 F2 0F 59 E5 F2 0F 58 D3 F2 0F 58 FC F2 0F 58 F2 F2 0F 11 7C 24 60 F2 0F 10 4C 24 60 F2 0F 10 5C 24 48 F2 0F 5C C1 F2 0F 10 4C 24 28 F2 0F 58 C4 F2 0F 11 04 24 0F 28 C1 F2 0F 10 64 24 60 F2 0F 10 14 24 F2 0F 59 C3 F2 0F 58 F2 F2 0F 10 7C 24 20 F2 0F 58 F0 F2 0F 59 DF F2 0F 10 54 24 40 F2 0F 58 F3 F2 0F 59 FA F2 0F 59 CA 0F 28 C7 F2 0F 58 F1 F2 0F 58 C4 F2 0F 11 44 24 60 0F 28 C5 F2 0F 10 4C 24 60 F2 0F 5C F9 F2 0F 58 FC F2 0F 11 3C 24 F2 0F 10 4C 24 60 F2 0F 10 3C 24 F2 0F 58 C1 F2 0F 58 F7 F2 0F 11 44 24 60 F2 0F 10 7C 24 60 F2 0F 5C EF F2 0F 58 E9 F2 0F 11 2C 24 F2 0F 10 44 24 60 F2 0F 10 2C 24 F2 0F 58 F5 F2 0F 58 F0 F2 0F 11 74 24 58 0F B6 44 24 5F 83 E0 7F 0B C2 8B 55 0C 88 44 24 5F 33 C0 F2 0F 10 74 24 58 F2 0F 11 32 83 C4 78 5B 5E 8B E5 5D C3 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 0F B6 74 24 77 83 E6 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA 8B 55 0C F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 11 02 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 11 54 24 68 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 50 F2 0F 10 64 24 50 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 50 8B D1 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 E3 F2 0F 5C C2 C1 E2 04 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 0F 10 82 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 C8 77 21 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 11 4C 24 58 EB 33 49 81 E1 FF 07 00 00 0F B7 44 24 6E C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 6E F2 0F 10 44 24 68 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 0F B6 44 24 5F 0F B6 74 24 77 83 E0 7F 83 E6 80 8B 55 0C 0B C6 88 44 24 5F 33 C0 F2 0F 10 44 24 58 F2 0F 11 02 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C3 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 0F 11 00 33 C0 83 C4 78 5B 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 11 5C 24 60 F2 0F 10 4C 24 60 8B 45 0C F2 0F 11 54 24 68 F2 0F 58 4C 24 70 F2 0F 11 08 33 C0 83 C4 78 5B 5E 8B E5 5D C3 8B 45 0C F2 0F 58 DB F2 0F 11 18 33 C0 83 C4 78 5B 5E 8B E5 5D C3 8D 49 00 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "@__security_check_cookie@4"
		size = 17
		refs = "0002 ___security_cookie 000d ___report_gsfailure"
	strings:
		$1 = { 3B 0D ?? ?? ?? ?? F2 75 02 F2 C3 F2 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "___common_datan2_cout_rare"
		size = 4128
		refs = "0013 __vmldAtanHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 57 53 83 EC 64 8B 45 08 F2 0F 10 0D ?? ?? ?? ?? 8B 55 0C 0F 28 D1 F2 0F 10 00 F2 0F 59 C2 F2 0F 59 12 F2 0F 11 44 24 18 F2 0F 11 54 24 20 0F B7 54 24 1E 81 E2 F0 7F 00 00 0F B6 4C 24 27 0F B7 7C 24 26 81 E1 80 00 00 00 81 E7 F0 7F 00 00 C1 EA 04 0F B6 5C 24 1F C1 EB 07 C1 E9 07 C1 EF 04 0F B7 35 ?? ?? ?? ?? 81 FA FF 07 00 00 0F 84 38 0F 00 00 81 FF FF 07 00 00 0F 84 55 0E 00 00 85 D2 75 15 F7 44 24 1C FF FF 0F 00 75 0B 83 7C 24 18 00 0F 84 74 0D 00 00 85 FF 75 15 F7 44 24 24 FF FF 0F 00 75 0B 83 7C 24 20 00 0F 84 48 0D 00 00 F2 0F 11 44 24 20 F7 DF F2 0F 11 54 24 28 03 FA 0F B6 44 24 27 83 E0 7F 89 44 24 18 0F B6 44 24 2F 83 E0 7F 83 FF CA 0F 8E 70 0C 00 00 83 FF 36 0F 8D 13 0C 00 00 85 C9 88 44 24 2F 8B 44 24 18 88 44 24 27 75 10 F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 54 24 18 EB 16 F2 0F 10 05 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 11 44 24 18 F2 0F 10 64 24 20 85 D2 F2 0F 10 44 24 28 0F 28 EC F2 0F 5E E8 0F B7 44 24 26 F2 0F 11 6C 24 50 0F 8E 75 0D 00 00 81 FA FE 07 00 00 7D 1D 25 0F 80 FF FF 81 C2 01 FC FF FF F2 0F 11 64 24 20 0D F0 3F FF FF 66 89 44 24 26 EB 17 F2 0F 10 1D ?? ?? ?? ?? BA FE 03 00 00 F2 0F 59 E3 F2 0F 11 64 24 20 F7 DA 81 E6 0F 80 FF FF 81 C2 FF 03 00 00 81 E2 FF 07 00 00 C1 E2 04 F2 0F 11 4C 24 28 0B F2 66 89 74 24 2E F2 0F 10 5C 24 28 F2 0F 59 C3 66 0F 2F 2D ?? ?? ?? ?? 0F 82 20 07 00 00 F2 0F 11 6C 24 28 0F 28 F8 F2 0F 10 2D ?? ?? ?? ?? 0F 28 F0 F2 0F 59 FD F2 0F 11 3C 24 F2 0F 11 54 24 48 F2 0F 10 14 24 F2 0F 11 4C 24 40 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 64 24 08 8B 74 24 2C 8B FE 81 E6 00 00 08 00 81 E7 00 00 F0 FF 81 CE 00 00 04 00 F2 0F 5C DC F2 0F 11 1C 24 0B FE F2 0F 10 0C 24 C7 44 24 28 00 00 00 00 F2 0F 5C F1 89 7C 24 2C F2 0F 11 74 24 08 F2 0F 10 0C 24 F2 0F 10 54 24 28 F2 0F 10 74 24 08 F2 0F 59 CA F2 0F 59 F2 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 F7 0F 28 E1 0F B7 54 24 56 F2 0F 58 E6 F2 0F 11 24 24 81 E2 F0 7F 00 00 F2 0F 10 1C 24 C1 EA 04 F2 0F 5C CB 8B 44 24 54 F2 0F 58 CE F2 0F 11 4C 24 08 25 FF FF 0F 00 F2 0F 10 4C 24 20 F2 0F 10 24 24 0F 28 F9 F2 0F 10 74 24 08 F2 0F 58 FC F2 0F 11 3C 24 0F 28 F9 F2 0F 10 1C 24 C1 E2 14 F2 0F 5C FB F2 0F 11 7C 24 08 0B D0 F2 0F 10 3C 24 81 C2 00 00 40 C0 F2 0F 10 5C 24 08 B8 71 00 00 00 C1 FA 13 F2 0F 58 FB F2 0F 11 7C 24 10 0F 28 F9 F2 0F 10 5C 24 08 83 FA 71 F2 0F 58 E3 F2 0F 11 64 24 08 0F 4C C2 F2 0F 10 64 24 10 C1 E0 04 F2 0F 5C FC F2 0F 11 7C 24 10 F2 0F 10 5C 24 08 F2 0F 10 64 24 10 F2 0F 58 DC F2 0F 11 5C 24 10 F2 0F 10 1C 24 F2 0F 10 64 24 10 F2 0F 58 E6 0F 28 F3 F2 0F 59 F5 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C FB F2 0F 11 7C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 0F 28 F9 F2 0F 10 34 24 F2 0F 59 3D ?? ?? ?? ?? F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 1C 24 F2 0F 10 74 24 08 F2 0F 11 3C 24 F2 0F 58 E6 F2 0F 10 34 24 F2 0F 5C 74 24 20 F2 0F 11 74 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 5C F7 F2 0F 11 34 24 F2 0F 10 3C 24 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 59 F2 F2 0F 59 FA 0F 28 D6 F2 0F 58 D7 F2 0F 11 14 24 F2 0F 10 14 24 F2 0F 5C F2 0F 28 D0 F2 0F 58 F7 F2 0F 11 74 24 08 0F 28 F0 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 F1 F2 0F 11 34 24 F2 0F 10 34 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 74 24 08 F2 0F 58 D6 F2 0F 11 54 24 10 F2 0F 10 74 24 08 F2 0F 58 CE F2 0F 11 4C 24 08 F2 0F 10 4C 24 10 F2 0F 5C C1 F2 0F 11 44 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 58 F0 F2 0F 11 74 24 10 F2 0F 10 34 24 F2 0F 10 44 24 10 F2 0F 58 C7 0F 28 FE F2 0F 59 FD F2 0F 11 3C 24 F2 0F 10 14 24 F2 0F 5C D6 F2 0F 11 54 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 10 54 24 40 F2 0F 5C CF F2 0F 11 0C 24 F2 0F 10 3C 24 F2 0F 5C F7 F2 0F 11 74 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 58 C6 0F 28 F2 F2 0F 5E F7 0F 28 CE F2 0F 59 CD F2 0F 11 4C 24 08 F2 0F 10 4C 24 08 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 5C CE F2 0F 11 4C 24 10 F2 0F 10 74 24 10 F2 0F 59 FE F2 0F 5C D7 F2 0F 10 7C 24 10 F2 0F 59 C7 F2 0F 11 44 24 08 F2 0F 10 44 24 08 F2 0F 5C D0 F2 0F 11 54 24 08 F2 0F 10 4C 24 08 F2 0F 10 7C 24 10 F2 0F 10 44 24 08 F2 0F 10 74 24 10 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C7 F2 0F 59 C3 F2 0F 59 CE 0F 28 D1 F2 0F 59 D4 F2 0F 59 D9 F2 0F 59 E7 F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 D4 F2 0F 11 14 24 0F 28 E0 F2 0F 10 34 24 F2 0F 58 E6 F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C6 F2 0F 11 44 24 08 F2 0F 10 1C 24 0F 28 D3 0F 28 CB F2 0F 59 D3 F2 0F 59 CD F2 0F 59 FA F2 0F 10 44 24 08 F2 0F 11 0C 24 F2 0F 10 34 24 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C F3 F2 0F 59 FA F2 0F 11 74 24 08 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D7 F2 0F 10 3C 24 F2 0F 10 64 24 08 F2 0F 59 EA F2 0F 5C FC F2 0F 11 3C 24 F2 0F 10 34 24 F2 0F 5C DE F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 58 C3 F2 0F 10 2C 24 F2 0F 5C EA F2 0F 11 6C 24 08 F2 0F 10 3C 24 F2 0F 10 74 24 08 F2 0F 5C FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 5C D1 F2 0F 11 54 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 0F 28 F2 0F 28 FB F2 0F 59 F8 F2 0F 59 D0 F2 0F 59 DC F2 0F 59 F4 F2 0F 58 FA 0F 28 CE 0F 28 D6 F2 0F 58 FB F2 0F 58 CC F2 0F 11 3C 24 F2 0F 10 3C 24 F2 0F 11 0C 24 F2 0F 10 2C 24 F2 0F 5C D5 F2 0F 11 54 24 08 F2 0F 10 1C 24 F2 0F 10 4C 24 08 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 6C 24 08 F2 0F 10 98 ?? ?? ?? ?? F2 0F 58 E5 F2 0F 11 64 24 08 F2 0F 10 64 24 10 F2 0F 5C F4 F2 0F 11 74 24 10 F2 0F 10 4C 24 08 F2 0F 10 74 24 10 F2 0F 58 CE F2 0F 11 4C 24 10 F2 0F 10 34 24 F2 0F 10 54 24 10 0F 28 EE F2 0F 58 DE F2 0F 58 C2 F2 0F 11 1C 24 F2 0F 58 C7 F2 0F 10 24 24 F2 0F 11 44 24 38 F2 0F 5C EC F2 0F 11 6C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 F2 0F 58 CF F2 0F 11 4C 24 10 F2 0F 10 54 24 08 F2 0F 58 90 ?? ?? ?? ?? F2 0F 11 54 24 08 F2 0F 10 5C 24 10 F2 0F 10 54 24 48 F2 0F 5C F3 F2 0F 11 74 24 10 F2 0F 10 6C 24 08 F2 0F 10 64 24 10 F2 0F 58 EC F2 0F 11 6C 24 10 F2 0F 10 34 24 F2 0F 10 7C 24 10 F2 0F 11 74 24 30 F2 0F 58 C7 8B F1 0F 28 CA C1 E6 07 F2 0F 58 80 ?? ?? ?? ?? 0F B6 44 24 37 83 E0 7F 0B C6 88 44 24 37 F2 0F 11 44 24 38 F2 0F 10 44 24 30 0F 28 E0 F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 1C 24 0F B6 7C 24 3F 8B D7 C1 EF 07 83 E2 7F 33 CF F2 0F 5C E3 F2 0F 11 64 24 08 F2 0F 10 34 24 F2 0F 10 6C 24 08 C1 E1 07 F2 0F 58 F5 F2 0F 11 74 24 10 0B D1 F2 0F 10 7C 24 08 88 54 24 3F F2 0F 58 D7 F2 0F 11 54 24 08 F2 0F 10 54 24 10 C1 E3 07 F2 0F 5C C2 F2 0F 11 44 24 10 F2 0F 10 4C 24 08 F2 0F 10 44 24 10 F2 0F 58 C8 F2 0F 11 4C 24 10 F2 0F 10 24 24 F2 0F 10 5C 24 10 F2 0F 11 64 24 30 F2 0F 58 5C 24 38 F2 0F 58 5C 24 18 F2 0F 11 5C 24 38 F2 0F 58 E3 F2 0F 11 64 24 58 0F B6 4C 24 5F 83 E1 7F 0B CB 8B 5D 10 88 4C 24 5F F2 0F 10 54 24 58 F2 0F 11 13 E9 D1 05 00 00 F2 0F 10 7C 24 20 8B F1 0F 28 E7 F2 0F 59 25 ?? ?? ?? ?? F2 0F 11 24 24 F2 0F 10 1C 24 F2 0F 11 54 24 48 F2 0F 10 25 ?? ?? ?? ?? C1 E6 07 F2 0F 5C 5C 24 20 F2 0F 11 5C 24 08 F2 0F 10 2C 24 F2 0F 10 54 24 08 C1 E3 07 F2 0F 5C EA F2 0F 11 2C 24 0F 28 E8 F2 0F 10 34 24 F2 0F 59 EC F2 0F 5C FE F2 0F 11 7C 24 08 F2 0F 10 14 24 F2 0F 10 5C 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C F0 F2 0F 11 74 24 08 F2 0F 10 2C 24 F2 0F 10 7C 24 08 F2 0F 5C EF F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 5C C6 F2 0F 11 44 24 08 0F 28 C1 F2 0F 10 2C 24 F2 0F 5E C5 0F 28 F0 F2 0F 59 F4 F2 0F 10 7C 24 08 F2 0F 11 74 24 08 F2 0F 10 74 24 08 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 74 24 08 F2 0F 10 44 24 10 F2 0F 5C F0 F2 0F 11 74 24 10 F2 0F 10 44 24 10 F2 0F 59 E8 F2 0F 5C CD F2 0F 10 6C 24 10 F2 0F 59 FD F2 0F 11 7C 24 08 F2 0F 10 7C 24 08 F2 0F 5C CF F2 0F 11 4C 24 08 F2 0F 10 6C 24 08 F2 0F 10 74 24 10 F2 0F 10 4C 24 08 0F 28 C6 F2 0F 59 C2 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F3 F2 0F 59 E9 F2 0F 10 4C 24 10 F2 0F 59 E9 0F 28 FD F2 0F 59 FB F2 0F 59 D5 F2 0F 58 FA 0F 28 D0 F2 0F 58 FE F2 0F 11 3C 24 F2 0F 10 0C 24 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 1C 24 F2 0F 5C C3 F2 0F 58 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 44 24 08 F2 0F 10 44 24 50 F2 0F 59 C0 F2 0F 59 C8 F2 0F 10 3C 24 0F 28 EF F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EC F2 0F 59 C8 F2 0F 10 54 24 08 F2 0F 11 2C 24 F2 0F 10 34 24 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5C F7 F2 0F 59 C8 F2 0F 11 74 24 08 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 04 24 F2 0F 10 5C 24 08 F2 0F 59 E1 F2 0F 5C C3 F2 0F 11 04 24 F2 0F 10 2C 24 F2 0F 5C FD F2 0F 11 7C 24 08 F2 0F 10 34 24 F2 0F 10 7C 24 08 F2 0F 11 24 24 F2 0F 58 D7 F2 0F 10 24 24 F2 0F 5C E1 F2 0F 11 64 24 08 F2 0F 10 2C 24 F2 0F 10 44 24 08 F2 0F 5C E8 F2 0F 11 2C 24 F2 0F 10 1C 24 F2 0F 5C CB F2 0F 11 4C 24 08 F2 0F 10 0C 24 F2 0F 10 7C 24 08 0F 28 E9 0F 28 C7 F2 0F 59 C2 F2 0F 59 CA F2 0F 59 FE F2 0F 59 EE F2 0F 58 C1 0F 28 CD 0F 28 DD F2 0F 58 C7 F2 0F 58 CE F2 0F 11 04 24 F2 0F 10 04 24 F2 0F 11 0C 24 F2 0F 10 24 24 F2 0F 5C DC F2 0F 11 5C 24 08 F2 0F 10 24 24 F2 0F 10 4C 24 08 F2 0F 58 E1 F2 0F 11 64 24 10 F2 0F 10 7C 24 08 F2 0F 58 F7 F2 0F 11 74 24 08 F2 0F 10 74 24 10 F2 0F 5C EE F2 0F 10 74 24 48 F2 0F 11 6C 24 10 F2 0F 10 5C 24 08 F2 0F 10 4C 24 10 F2 0F 58 D9 F2 0F 11 5C 24 10 F2 0F 10 24 24 F2 0F 10 6C 24 10 F2 0F 11 64 24 30 F2 0F 58 D5 0F B6 44 24 37 F2 0F 58 D0 83 E0 7F 0B C6 88 44 24 37 F2 0F 11 54 24 38 0F 28 D6 F2 0F 10 4C 24 30 0F 28 C1 F2 0F 58 D1 F2 0F 11 14 24 F2 0F 10 14 24 0F B6 7C 24 3F 8B D7 C1 EF 07 83 E2 7F 33 CF F2 0F 5C C2 F2 0F 11 44 24 08 F2 0F 10 24 24 F2 0F 10 5C 24 08 C1 E1 07 F2 0F 58 E3 F2 0F 11 64 24 10 0B D1 F2 0F 10 6C 24 08 88 54 24 3F F2 0F 58 F5 F2 0F 11 74 24 08 F2 0F 10 7C 24 10 F2 0F 5C CF F2 0F 11 4C 24 10 F2 0F 10 44 24 08 F2 0F 10 4C 24 10 F2 0F 58 C1 F2 0F 11 44 24 10 F2 0F 10 1C 24 F2 0F 10 54 24 10 F2 0F 11 5C 24 30 F2 0F 58 54 24 38 F2 0F 58 54 24 18 F2 0F 11 54 24 38 F2 0F 58 DA F2 0F 11 5C 24 58 0F B6 4C 24 5F 83 E1 7F 0B CB 8B 5D 10 88 4C 24 5F F2 0F 10 4C 24 58 F2 0F 11 0B E9 B2 01 00 00 83 FF 4A 0F 8D 0B 01 00 00 8B 44 24 18 88 44 24 27 F2 0F 5E 54 24 20 F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 5C C2 8B 4D 10 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 54 24 5F 83 E2 7F 0B D3 88 54 24 5F F2 0F 10 4C 24 58 F2 0F 11 09 E9 5E 01 00 00 85 C9 0F 85 22 01 00 00 8B 54 24 18 88 54 24 27 88 44 24 2F F2 0F 10 54 24 20 F2 0F 5E 54 24 28 F2 0F 11 54 24 58 0F B7 4C 24 5E F7 C1 F0 7F 00 00 74 3B C1 E3 07 F2 0F 58 CA F2 0F 11 0C 24 F2 0F 10 04 24 F2 0F 59 D0 F2 0F 11 54 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 F0 00 00 00 F2 0F 59 D2 F2 0F 11 14 24 F2 0F 10 04 24 C1 E3 07 F2 0F 58 44 24 58 F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 B3 00 00 00 85 D2 75 11 F7 44 24 1C FF FF 0F 00 75 07 E9 FD 01 00 00 74 36 F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A EB 68 85 C9 75 30 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E3 07 8B 55 10 0B C3 F2 0F 11 44 24 58 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A EB 34 F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A 33 C0 83 C4 64 5B 5F 5E 8B E5 5D C3 F2 0F 10 1D ?? ?? ?? ?? BA 02 FC FF FF F2 0F 59 E3 F2 0F 11 64 24 20 E9 AB F2 FF FF F7 44 24 24 FF FF 0F 00 75 07 83 7C 24 20 00 74 0D 8B 45 10 F2 0F 58 C2 F2 0F 11 00 EB BA 81 FA FF 07 00 00 74 3B 85 C9 0F 85 76 FF FF FF 0F B6 05 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 83 E0 7F C1 E3 07 8B 55 10 0B C3 F2 0F 11 44 24 58 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 77 FF FF FF 85 C9 75 39 F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 3A FF FF FF F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 5F F2 0F 10 4C 24 58 F2 0F 11 0A E9 01 FF FF FF F7 44 24 1C FF FF 0F 00 0F 85 2C FF FF FF 83 7C 24 18 00 0F 85 21 FF FF FF 81 FF FF 07 00 00 0F 84 04 FF FF FF F2 0F 10 05 ?? ?? ?? ?? C1 E3 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 58 0F B6 44 24 5F 83 E0 7F 8B 55 10 0B C3 88 44 24 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "___avx_exp4"
		size = 352
		refs = "0010 ___common_dexp_data 0151 ___common_dexp_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FD 10 35 ?? ?? ?? ?? C5 FD 59 15 ?? ?? ?? ?? C5 F9 10 25 ?? ?? ?? ?? C5 ED 58 DE C5 E5 5C CE C4 E3 7D 19 C5 01 C5 F8 C6 D5 DD C5 E8 54 3D ?? ?? ?? ?? C5 C1 66 35 ?? ?? ?? ?? C5 F8 50 C6 C5 E0 54 EC C5 F9 7E EA C4 E3 79 16 E9 02 C4 E3 7D 19 DA 01 C5 D9 DF DB C5 E8 54 FC C5 D9 DF E2 C5 FA 7E 34 D5 ?? ?? ?? ?? C5 E9 73 F4 2A C5 F9 7E FA C5 C9 16 2C CD ?? ?? ?? ?? C4 E3 79 16 F9 02 C5 FA 7E 34 D5 ?? ?? ?? ?? C5 C9 16 3C CD ?? ?? ?? ?? C4 E3 55 18 FF 01 C5 F5 59 2D ?? ?? ?? ?? C5 F5 59 0D ?? ?? ?? ?? C5 FD 5C F5 C5 CD 5C F1 C5 CD 58 2D ?? ?? ?? ?? C5 D5 59 CE C5 F5 58 2D ?? ?? ?? ?? C5 F1 73 F3 2A C5 D5 59 F6 C5 CD 58 2D ?? ?? ?? ?? C5 C5 59 FD C4 E3 7D 19 FD 01 C5 C1 D4 D9 C5 D1 D4 CA C4 E3 65 18 C9 01 85 C0 75 08 C5 FD 28 C1 8B E5 5D C3 C5 FD 11 44 24 40 C5 FD 11 8C 24 80 00 00 00 74 E7 33 D2 89 74 24 04 8B F2 89 3C 24 8B F8 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FD 10 8C 24 80 00 00 00 EB BD C5 F8 77 8D 8C F4 80 00 00 00 8D 44 F4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "__SEH_prolog"
		size = 60
		refs = "0001 __except_handler3"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 8B 45 F8 89 65 E8 50 8B 45 FC C7 45 FC FF FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 F2 C3 }
	condition:
		$1
}

rule file_399_1_0 {
	meta:
		name = "__SEH_epilog"
		size = 18
	strings:
		$1 = { 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B C9 51 F2 C3 }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "___sse2_log102"
		size = 464
		refs = "005b _static_const_table"
	strings:
		$1 = { 8B C4 83 EC 70 83 E4 F0 89 44 24 2C 66 0F 28 F8 66 0F 28 F0 66 0F 73 D7 20 89 5C 24 10 89 4C 24 14 66 0F 7E F8 8B C8 0F C6 FF 02 66 0F 7E FA 8B DA C1 E8 09 25 F0 07 00 00 83 C0 10 25 E0 0F 00 00 C1 EA 09 81 E2 F0 07 00 00 83 C2 10 81 E2 E0 0F 00 00 66 0F 28 C8 66 0F DB 05 ?? ?? ?? ?? 66 0F EB 05 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D 66 0F 72 D1 14 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F 54 D8 66 0F 5C C3 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 0F 7E A0 ?? ?? ?? ?? 66 0F 16 A2 ?? ?? ?? ?? 66 0F 59 DC 66 0F 59 C4 66 0F 28 B8 ?? ?? ?? ?? 66 0F 28 EF 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 C9 00 00 00 81 EB 00 00 10 00 81 FB 00 00 E0 7F 0F 83 B7 00 00 00 66 0F 28 B2 ?? ?? ?? ?? 66 0F 14 FE 66 0F 15 EE 66 0F 58 FA 66 0F 28 E7 66 0F C2 25 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F 54 E0 66 0F 58 FB 66 0F 58 FC 66 0F 55 E0 66 0F 58 C3 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 C8 66 0F 59 C0 66 0F 59 F0 66 0F 59 D0 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 D0 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 59 F1 66 0F 58 F2 66 0F 59 0D ?? ?? ?? ?? 66 0F 59 C6 66 0F 58 C1 66 0F 58 C5 66 0F 58 C4 66 0F 58 C7 8B 4C 24 14 8B 5C 24 10 EB 28 66 0F 29 34 24 D9 EC DD 04 24 D9 F1 8B 4C 24 14 DD 1C 24 D9 EC DD 44 24 08 D9 F1 8B 5C 24 10 DD 5C 24 08 66 0F 28 04 24 8B 64 24 2C C3 8D 49 00 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "___avx_atanf8"
		size = 192
		refs = "0004 ___common_satan_data"
	strings:
		$1 = { C5 FC 10 15 ?? ?? ?? ?? C5 FC 10 3D ?? ?? ?? ?? C5 FC 54 25 ?? ?? ?? ?? C5 DC C2 F2 12 C5 EC 5D CC C5 FC 54 EF C5 CC 55 1D ?? ?? ?? ?? C5 E4 57 C5 C5 EC 5F DC C5 F4 5E E3 C5 CC 55 F7 C5 CC 57 ED C5 D4 57 DC C5 E4 59 D3 C5 EC 59 CA C5 F4 59 3D ?? ?? ?? ?? C5 F4 59 25 ?? ?? ?? ?? C5 C4 58 2D ?? ?? ?? ?? C5 DC 58 3D ?? ?? ?? ?? C5 D4 59 F1 C5 C4 59 F9 C5 CC 58 25 ?? ?? ?? ?? C5 C4 58 35 ?? ?? ?? ?? C5 DC 59 E9 C5 CC 59 C9 C5 D4 58 25 ?? ?? ?? ?? C5 F4 58 2D ?? ?? ?? ?? C5 DC 59 CA C5 F4 58 F5 C5 CC 59 D2 C5 EC 58 0D ?? ?? ?? ?? C5 F4 59 DB C5 E4 58 C0 C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "___common_dcosh_cout_rare"
		size = 976
		refs = "0011 __vmldCoshHATab"
	strings:
		$1 = { 55 8B EC 83 E4 F8 56 83 EC 3C 8B 4D 08 F2 0F 10 0D ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 51 06 81 E2 F0 7F 00 00 81 FA F0 7F 00 00 0F 84 7F 03 00 00 F2 0F 10 01 0F B6 51 07 F2 0F 11 44 24 20 83 E2 7F 88 54 24 27 0F B7 4C 24 26 81 E1 F0 7F 00 00 81 F9 90 3C 00 00 0F 8E 34 03 00 00 F2 0F 10 7C 24 20 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C7 0F 86 FC 02 00 00 F2 0F 11 4C 24 30 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CF 66 0F 2F 3D ?? ?? ?? ?? 0F 82 2B 01 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C8 F2 0F 11 0C 24 F2 0F 10 0C 24 8B 0C 24 8B D1 83 E2 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 08 F2 0F 10 54 24 08 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 08 F2 0F 5C FA F2 0F 59 1D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C FB F2 0F 59 CF C1 E2 04 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 10 A2 ?? ?? ?? ?? C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF 81 C1 FF 03 00 00 49 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF 81 E1 FF 07 00 00 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CF F2 0F 59 CF F2 0F 58 CF F2 0F 59 CC F2 0F 58 8A ?? ?? ?? ?? F2 0F 58 CC 77 2A C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 F2 0F 10 44 24 30 F2 0F 59 C1 8B 45 0C F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 49 81 E1 FF 07 00 00 0F B7 44 24 36 C1 E1 04 25 0F 80 FF FF 0B C1 66 89 44 24 36 33 C0 F2 0F 59 4C 24 30 F2 0F 59 0D ?? ?? ?? ?? 8B 55 0C F2 0F 11 0A 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 2D ?? ?? ?? ?? 0F B7 4C 24 36 81 E1 0F 80 FF FF F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0C 24 F2 0F 10 34 24 8B 34 24 8B D6 C1 EA 06 83 E6 3F 81 C2 FF 03 00 00 F2 0F 5C 35 ?? ?? ?? ?? F2 0F 11 74 24 08 8D 42 FF F2 0F 10 5C 24 08 25 FF 07 00 00 F2 0F 59 1D ?? ?? ?? ?? F7 DA F2 0F 10 44 24 08 83 C2 FC F2 0F 59 05 ?? ?? ?? ?? F2 0F 5C FB F2 0F 10 35 ?? ?? ?? ?? 81 E2 FF 07 00 00 C1 E6 04 F2 0F 5C F8 0F 28 E7 F2 0F 59 E7 F2 0F 59 F4 F2 0F 59 EC F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 F4 F2 0F 59 EC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 EF F2 0F 59 F4 C1 E0 04 F2 0F 10 9E ?? ?? ?? ?? 0B C8 F2 0F 10 A6 ?? ?? ?? ?? F7 DE 66 89 4C 24 36 81 E1 0F 80 FF FF C1 E2 04 F2 0F 10 4C 24 30 0B CA 66 89 4C 24 36 F2 0F 59 D9 F2 0F 59 E1 F2 0F 10 44 24 30 F2 0F 10 96 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 10 8E ?? ?? ?? ?? F2 0F 59 C8 0F 28 C3 F2 0F 58 C2 F2 0F 11 44 24 10 0F 28 C3 F2 0F 11 4C 24 20 F2 0F 5C DA F2 0F 10 4C 24 10 F2 0F 59 EB F2 0F 5C C1 8B 45 0C F2 0F 58 C2 F2 0F 11 44 24 18 0F 28 C4 F2 0F 10 54 24 20 F2 0F 10 4C 24 10 F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 FB F2 0F 58 C2 F2 0F 11 4C 24 28 F2 0F 58 C4 F2 0F 10 4C 24 18 F2 0F 58 C1 F2 0F 58 C5 F2 0F 10 6C 24 28 F2 0F 59 F5 F2 0F 58 C6 F2 0F 58 C7 F2 0F 11 44 24 10 F2 0F 10 7C 24 10 F2 0F 58 EF F2 0F 11 28 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C0 8B 45 0C F2 0F 11 00 B8 03 00 00 00 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 05 ?? ?? ?? ?? 8B 45 0C F2 0F 58 44 24 20 F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 F2 0F 10 01 F2 0F 59 C0 8B 45 0C F2 0F 11 00 33 C0 83 C4 3C 5E 8B E5 5D C3 8D 9B 00 00 00 00 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "___avx_coshf8"
		size = 384
		refs = "0010 ___common_scosh_data 016e ___common_scosh_cout_rare"
	strings:
		$1 = { 55 8B EC 83 E4 C0 81 EC C0 00 00 00 C5 FC 10 0D ?? ?? ?? ?? C5 FC 10 1D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 FC 28 F0 C5 F4 55 E6 C5 DC 59 2D ?? ?? ?? ?? C5 FC 11 34 24 C5 F8 10 05 ?? ?? ?? ?? C5 D4 58 EB C5 D9 66 FA C4 E3 7D 19 E1 01 C5 D9 76 F2 C5 C1 EB F6 C5 F1 66 FA C5 F1 76 D2 C5 C1 EB FA C5 C9 6B CF C5 C9 EF F6 C5 F1 63 FE C5 D4 5C F3 C5 F9 D7 D7 C5 CC 59 1D ?? ?? ?? ?? C5 DC 5C FB C5 CC 59 25 ?? ?? ?? ?? C5 C4 5C F4 C5 CC 59 FE C5 E9 72 F5 17 C4 E3 7D 19 EB 01 C5 F9 FE CA C5 E1 72 F3 17 C5 F9 FA D2 C5 F9 FE EB C5 F9 FA C3 C4 E3 75 18 E5 01 C5 C4 59 0D ?? ?? ?? ?? C5 F4 58 1D ?? ?? ?? ?? C4 E3 6D 18 C0 01 C5 C4 59 15 ?? ?? ?? ?? C5 DC 5C E8 C5 DC 58 C0 C5 E4 59 E7 C5 EC 58 1D ?? ?? ?? ?? C5 DC 59 CE C5 E4 59 E7 C5 F4 58 F6 C5 DC 58 0D ?? ?? ?? ?? C5 D4 59 EE C5 F4 59 FF C5 C4 59 C8 C5 D4 58 F1 C5 CC 58 C0 84 D2 75 04 8B E5 5D C3 C5 FC 10 0C 24 C5 FC 11 84 24 80 00 00 00 C5 FC 11 4C 24 40 85 D2 74 E4 33 C0 89 74 24 04 8B F0 89 3C 24 8B FA 0F A3 F7 72 18 46 83 FE 20 7C F5 8B 74 24 04 8B 3C 24 C5 FC 10 84 24 80 00 00 00 EB BA C5 F8 77 8D 8C B4 80 00 00 00 8D 44 B4 40 51 50 E8 ?? ?? ?? ?? 83 C4 08 EB CE 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "??2@YAPAXI@Z"
		size = 51
		refs = "0009 __callnewh 0019 ?__scrt_throw_std_bad_array_new_length@@YAXXZ 0020 ?__scrt_throw_std_bad_alloc@@YAXXZ 0028 _malloc"
	strings:
		$1 = { 55 8B EC EB 1F FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 75 12 83 7D 08 FF 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 74 D4 5D C3 }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "___avx_sinf8"
		size = 3200
		refs = "0013 ___common_ssin_data 012c ___common_ssin_cout_rare 01db ___common_ssin_reduction_data"
	strings:
		$1 = { 55 8B EC 83 E4 C0 56 57 53 81 EC F4 02 00 00 C5 FC 10 1D ?? ?? ?? ?? C5 E9 EF D2 C5 FC 54 CB C5 F4 C2 25 ?? ?? ?? ?? 1E C4 E3 7D 19 E5 01 C5 D9 6B F5 C5 C9 63 FA C5 F9 D7 C7 84 C0 0F 85 F3 00 00 00 C5 E4 55 D0 33 DB C5 FC 10 1D ?? ?? ?? ?? C5 F4 59 25 ?? ?? ?? ?? C5 DC 58 FB C5 C9 72 F7 1F C4 E3 7D 19 FD 01 C5 D9 72 F5 1F C5 C4 5C EB C5 D4 59 1D ?? ?? ?? ?? C5 F4 5C DB C4 E3 4D 18 F4 01 C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 D4 59 25 ?? ?? ?? ?? C5 E4 5C DC C5 E4 59 E3 C5 DC 59 2D ?? ?? ?? ?? C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 EC C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 EC C5 D4 58 2D ?? ?? ?? ?? C5 D4 59 E4 C5 E4 57 DE C5 DC 59 E3 C5 DC 58 DB C5 E4 57 D2 84 DB 75 11 C5 FC 28 C2 81 C4 F4 02 00 00 5B 5F 5E 8B E5 5D C3 C5 FC 11 04 24 C5 FC 11 54 24 40 85 DB 74 E0 33 F6 0F A3 F3 72 0E 46 83 FE 20 7C F5 C5 FC 10 54 24 40 EB CB C5 F8 77 8D 44 B4 40 8D 14 B4 50 52 E8 ?? ?? ?? ?? 83 C4 08 EB DC C5 FC 10 25 ?? ?? ?? ?? BA 00 00 80 7F C5 FC 11 44 24 40 C5 F9 6E FA C5 DC 54 E9 C5 D4 C2 DC 00 C4 E3 7D 19 C4 01 C5 F8 11 A4 24 90 00 00 00 C4 E3 7D 19 DD 01 C5 E1 6B F5 C5 C9 63 D2 C5 F9 D7 C2 C5 F9 70 D7 00 89 84 24 A0 02 00 00 C5 F8 28 C8 C5 E9 DB D9 C5 D1 72 D3 17 C5 E9 DB DC C5 E9 72 D3 17 C5 E1 72 F5 01 C5 E1 FE DD C5 D1 72 F3 02 C5 E1 72 F2 01 C5 F9 7E EA C5 E1 FE DA C5 E1 72 F3 02 C5 F8 11 8C 24 80 00 00 00 C4 E3 79 16 E9 01 C4 E3 79 16 E8 02 C4 E3 79 16 EF 03 C5 F9 7E DE C5 F9 6E 91 ?? ?? ?? ?? C4 E3 79 16 9C 24 AC 02 00 00 01 C4 E3 79 16 9C 24 B0 02 00 00 02 C4 E3 79 16 DB 03 C5 F9 6E 9A ?? ?? ?? ?? C5 E1 6C EA C5 F9 6E 98 ?? ?? ?? ?? C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C DA 89 B4 24 A8 02 00 00 C5 D0 C6 F3 88 C5 F9 6E 9E ?? ?? ?? ?? 8B B4 24 AC 02 00 00 89 BC 24 A4 02 00 00 C5 F9 6E 83 ?? ?? ?? ?? C5 F9 6E 96 ?? ?? ?? ?? 8B B4 24 B0 02 00 00 C5 E1 6C EA C5 F9 6E 93 ?? ?? ?? ?? C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C DA C5 D0 C6 EB 88 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? C5 E1 6C FA C5 F9 6E 97 ?? ?? ?? ?? 8B BC 24 A8 02 00 00 C5 F9 6E 98 ?? ?? ?? ?? C5 E1 6C DA C5 C0 C6 FB 88 C5 F9 6E 9F ?? ?? ?? ?? 8B BC 24 AC 02 00 00 C5 F8 11 B4 24 A0 00 00 00 C5 F8 11 AC 24 B0 00 00 00 C5 F9 6E 97 ?? ?? ?? ?? C5 E1 6C D2 C5 F9 6E 9E ?? ?? ?? ?? C5 E1 6C D8 C5 E8 C6 D3 88 C5 F8 11 94 24 C0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? C5 F9 6E 91 ?? ?? ?? ?? B9 FF FF 7F 00 C5 E1 6C DA C5 F9 6E 90 ?? ?? ?? ?? 8B 84 24 A4 02 00 00 8B 94 24 A8 02 00 00 C5 F9 6E 80 ?? ?? ?? ?? B8 FF FF 00 00 C5 E9 6C D0 C5 E0 C6 DA 88 C5 F8 11 9C 24 D0 00 00 00 C5 F9 6E 9A ?? ?? ?? ?? BA 00 00 00 80 C5 F9 6E 97 ?? ?? ?? ?? BF 00 00 80 28 C5 F9 6E 83 ?? ?? ?? ?? BB 00 00 80 00 C5 E1 6C DA C5 F9 6E 96 ?? ?? ?? ?? BE FF 00 00 00 C5 E9 6C D0 C5 E0 C6 C2 88 C5 F9 6E D9 C5 F9 70 D3 00 C5 F9 6E DB C5 F9 70 DB 00 C5 E9 DB E4 C5 E9 DB C9 C5 D9 FE D3 C5 F9 6E E0 C5 F1 FE CB C5 F9 70 DC 00 B9 00 00 80 3F C5 C9 DB E3 C5 D1 DB F3 C5 D1 72 D7 10 C5 C1 DB FB C5 FA 7F AC 24 10 01 00 00 BB 00 00 40 47 C5 F8 10 AC 24 C0 00 00 00 B8 FF FF 03 00 C5 FA 7F B4 24 00 01 00 00 C5 C9 72 D5 10 C5 D1 DB EB C5 FA 7F AC 24 40 01 00 00 C5 F8 10 AC 24 D0 00 00 00 C5 F8 11 84 24 E0 00 00 00 C5 F9 72 D0 10 C5 FA 7F 84 24 60 01 00 00 C5 F9 72 D1 10 C5 F1 DB CB C5 D1 72 D5 10 C5 FA 7F AC 24 50 01 00 00 C5 D1 72 D2 10 C5 E9 DB D3 C5 FA 7F A4 24 F0 00 00 00 C4 E2 71 40 E4 C5 FA 7F A4 24 A0 01 00 00 C4 E2 69 40 A4 24 00 01 00 00 C5 FA 7F B4 24 20 01 00 00 C5 FA 7F BC 24 30 01 00 00 C5 FA 7F A4 24 B0 01 00 00 C4 E2 69 40 F6 C4 E2 71 40 A4 24 10 01 00 00 C5 FA 7F B4 24 D0 01 00 00 C4 E2 71 40 F7 C5 E1 DB BC 24 D0 00 00 00 C5 FA 7F A4 24 C0 01 00 00 C4 E2 79 40 E7 C5 FA 6F BC 24 50 01 00 00 C5 D9 72 D4 10 C5 FA 7F 8C 24 80 01 00 00 C4 E2 71 40 CF C5 FA 7F 84 24 70 01 00 00 C4 E2 79 40 C7 C5 C1 72 D1 10 C5 FA 7F B4 24 E0 01 00 00 C5 C9 DB F3 C5 F9 FE C7 C5 C9 FE F0 C5 D9 FE FE C5 E1 DB A4 24 E0 00 00 00 C5 FA 7F 94 24 90 01 00 00 C4 E2 69 40 94 24 40 01 00 00 C4 E2 51 40 CC C5 E9 DB C3 C5 FA 7F 94 24 F0 01 00 00 C5 C9 72 D1 10 C5 FA 6F 8C 24 60 01 00 00 C5 FA 6F 94 24 90 01 00 00 C4 E2 69 40 D1 C4 E2 51 40 E1 C5 E9 72 D2 10 C5 D9 FE E2 C5 F9 FE C4 C5 FA 7F BC 24 00 02 00 00 C5 C9 FE C8 C5 FA 6F A4 24 70 01 00 00 C5 C9 72 D7 10 C5 FA 6F BC 24 E0 01 00 00 C4 E2 59 40 84 24 30 01 00 00 C5 C1 72 D7 10 C5 E1 DB 94 24 C0 01 00 00 C5 F9 FE C7 C5 FA 7F 8C 24 10 02 00 00 C5 E9 FE D0 C5 C1 72 D1 10 C5 C9 FE C2 C5 FA 6F 8C 24 F0 01 00 00 C4 E2 51 40 B4 24 40 01 00 00 C5 F1 72 D1 10 C5 E1 DB 94 24 D0 01 00 00 C5 C9 FE F1 C5 E9 FE D6 C5 C1 FE F2 C5 FA 6F 94 24 C0 01 00 00 C4 E2 59 40 BC 24 10 01 00 00 C5 E9 72 D2 10 C5 E1 DB 8C 24 A0 01 00 00 C5 C1 FE FA C5 FA 7F 84 24 20 02 00 00 C5 F9 72 D0 10 C5 F1 FE D7 C5 FA 7F B4 24 30 02 00 00 C5 F9 FE FA C5 E9 72 D6 10 C5 FA 6F B4 24 D0 01 00 00 C4 E2 51 40 8C 24 20 01 00 00 C5 C9 72 D6 10 C5 E1 DB 84 24 B0 01 00 00 C5 F1 FE CE C5 F9 FE C1 C5 C9 72 D7 10 C5 E9 FE C8 C5 C1 DB FB C5 F8 10 84 24 A0 00 00 00 C5 FA 6F 94 24 80 01 00 00 C5 F9 72 D0 10 C4 E2 69 40 D0 C4 E2 59 40 84 24 F0 00 00 00 C5 E9 DB D3 C5 FA 6F A4 24 A0 01 00 00 C5 D9 72 D4 10 C5 F9 FE C4 C5 E9 FE D0 C5 C9 FE F2 C5 E9 72 D1 10 C5 F8 10 A4 24 B0 00 00 00 C5 F9 72 F6 10 C5 FA 6F B4 24 90 01 00 00 C5 F9 FE C7 C5 C1 72 D4 10 C5 F1 DB CB C4 E2 49 40 E7 C4 E2 51 40 B4 24 00 01 00 00 C5 D9 DB E3 C5 FA 6F AC 24 B0 01 00 00 C5 D1 72 D5 10 C5 C9 FE FD C5 D9 FE E7 C5 E9 FE D4 C5 D9 72 F2 10 C5 FA 6F BC 24 30 02 00 00 C5 D9 FE E9 C5 FA 6F A4 24 20 02 00 00 C5 E1 DB B4 24 00 02 00 00 C5 E9 72 F4 10 C5 E1 DB 9C 24 10 02 00 00 C5 D9 72 F7 10 C5 D9 FE E3 C5 F9 6E DA C5 E9 FE CE C5 F9 6E F1 C5 F9 70 D3 00 BA 00 00 00 34 C5 E9 DB 9C 24 80 00 00 00 B9 FF 01 00 00 C5 F9 70 F6 00 C5 E9 DB 94 24 90 00 00 00 C5 E1 EF FE C5 FA 7F 84 24 40 02 00 00 C5 F9 72 D0 09 C5 FA 7F AC 24 50 02 00 00 C5 D1 72 D5 09 C5 E9 EF F6 C5 F9 EB C7 C5 D1 EB EE C4 E3 7D 18 ED 01 C5 F9 6E C3 C5 F9 70 F0 00 BB DB 0F C9 40 C4 E3 4D 18 FE 01 C5 C4 58 C5 C5 FC 5C F7 C5 F9 6E FE C5 D4 5C EE BE 00 10 C9 40 C5 FC 11 6C 24 60 C5 F9 6E EF C5 F9 70 F5 00 C5 E9 EF EE BF 7A 77 95 B7 C5 F8 11 84 24 60 02 00 00 C4 E3 7D 19 84 24 70 02 00 00 01 C5 F9 70 C7 00 C5 F9 6E F8 C5 F9 70 FF 00 B8 00 F0 FF FF C5 FA 7F 84 24 80 02 00 00 C5 E1 EF C6 C5 C1 DB F1 C5 C1 DB FC C5 C9 72 F6 05 C5 C1 72 F7 05 C5 C9 EB F0 C5 C1 EB FD C5 F1 72 D1 12 C5 D9 72 D4 12 C4 E3 4D 18 FF 01 C4 E3 7D 18 ED 01 C5 F9 6E C2 C5 C4 5C FD BA FF FF FF 7F C5 F9 70 E8 00 C5 E1 EF C5 C5 F9 6E D9 C5 F9 70 DB 00 C5 E9 EF D5 C5 E1 DB B4 24 40 02 00 00 B9 00 00 80 35 C5 E1 DB 9C 24 50 02 00 00 C5 D1 72 F6 0E C5 E1 72 F3 0E C5 D1 EB E9 C5 E1 EB E4 C5 D1 EB C8 C5 D9 EB DA C4 E3 75 18 EB 01 C5 FC 10 4C 24 60 C4 E3 7D 18 D2 01 C5 D4 5C C2 C5 F9 6E EF C5 F4 58 F0 C5 F4 5C E6 C5 FC 58 DC C5 F9 6E E6 C5 E4 58 D7 C5 F9 6E FB C5 F9 70 DC 00 C5 F9 6E E0 C5 F9 70 C7 00 C5 F9 70 FD 00 C5 F9 70 EC 00 C4 E3 55 18 E5 01 C5 CC 54 E4 C5 CC 5C F4 C4 E3 7D 18 C8 01 C4 E3 65 18 C3 01 C4 E3 45 18 DF 01 C5 FC 59 FC C5 FC 59 EE C5 E4 59 C4 C5 F4 59 D2 C5 F9 6E C9 C5 E4 59 F6 C5 D4 58 C0 C5 F9 6E EA C5 EC 58 E6 C5 F9 70 F5 00 C5 FC 58 D4 C5 FC 10 44 24 40 C5 C4 58 E2 C5 C4 5C DC C5 F9 70 F9 00 C5 E4 58 D2 C4 E3 4D 18 DE 01 C5 FC 54 EB C4 E3 45 18 F7 01 C5 D4 C2 DE 1E C5 D4 C2 EE 12 C5 D4 54 E8 C5 E4 54 E4 C5 E4 54 D2 C5 D4 56 E4 C5 FA 6F AC 24 80 02 00 00 C5 FC 11 14 24 C5 D1 DB 94 24 60 02 00 00 C5 C9 72 F2 04 C5 D1 DB 94 24 70 02 00 00 C5 E9 72 F2 04 C5 F9 7E F6 C5 F9 7E D2 C5 DC 59 DC C4 E3 79 16 F3 01 C4 E3 79 16 F7 02 C4 E3 79 16 F1 03 C4 E3 79 16 94 24 BC 02 00 00 01 C4 E3 79 16 94 24 C0 02 00 00 02 C4 E3 79 16 D0 03 C5 F9 6E 96 ?? ?? ?? ?? C5 F9 6E AB ?? ?? ?? ?? C5 E9 6C F5 C5 F9 6E 97 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? 89 94 24 B8 02 00 00 C5 E9 6C D5 C5 F9 6E AA ?? ?? ?? ?? 8B 94 24 BC 02 00 00 C5 C8 C6 D2 88 89 8C 24 B4 02 00 00 C5 F9 6E B2 ?? ?? ?? ?? 8B 94 24 C0 02 00 00 C5 D1 6C FE C5 F9 6E B0 ?? ?? ?? ?? C5 F9 6E AA ?? ?? ?? ?? C5 D1 6C EE C5 C0 C6 ED 88 C5 F9 6E B3 ?? ?? ?? ?? C5 F9 6E 88 ?? ?? ?? ?? 89 9C 24 98 02 00 00 89 B4 24 94 02 00 00 89 BC 24 9C 02 00 00 C4 E3 6D 18 D5 01 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C FE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 B8 02 00 00 C5 F9 6E AF ?? ?? ?? ?? C5 D1 6C EE C5 F9 6E B1 ?? ?? ?? ?? 8B 8C 24 BC 02 00 00 C5 C0 C6 ED 88 C5 F9 6E B9 ?? ?? ?? ?? C5 C9 6C F7 C5 F9 6E BA ?? ?? ?? ?? C5 C1 6C F9 C5 C8 C6 F7 88 C4 E3 55 18 EE 01 C5 F9 6E B3 ?? ?? ?? ?? C5 FC 11 6C 24 20 C5 F9 6E AE ?? ?? ?? ?? C5 D1 6C F6 8B 9F ?? ?? ?? ?? 89 9C 24 90 02 00 00 8B 9C 24 A0 02 00 00 8B B4 24 B4 02 00 00 8B BC 24 B8 02 00 00 C5 F9 6E AC 24 90 02 00 00 C5 F9 6E 8E ?? ?? ?? ?? C5 D1 6C F9 C5 FC 11 44 24 40 C5 C8 C6 C7 88 C5 F9 6E B7 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? C5 C9 6C F5 C5 F9 6E 8A ?? ?? ?? ?? C5 F9 6E B8 ?? ?? ?? ?? C5 F1 6C EF C5 C8 C6 CD 88 C5 EC 59 F4 89 9C 24 A0 02 00 00 8B 9C 24 94 02 00 00 C4 E3 7D 18 C1 01 C5 FC 11 44 24 60 C5 DC 59 E8 C5 FC 10 44 24 20 C5 EC 58 54 24 60 C5 FC 58 CD C5 CC 58 F9 C5 FC 5C C1 C5 FC 11 BC 24 80 00 00 00 C5 F4 5C FF C5 FC 58 C5 C5 E4 59 0D ?? ?? ?? ?? C5 C4 58 F6 C5 E4 59 3D ?? ?? ?? ?? C5 CC 58 E8 C5 F4 58 05 ?? ?? ?? ?? C5 C4 58 35 ?? ?? ?? ?? C5 FC 11 AC 24 A0 00 00 00 C5 FC 59 EB C5 CC 59 DB C5 F9 6E B6 ?? ?? ?? ?? C5 D4 59 C4 C5 F9 6E AB ?? ?? ?? ?? 8B 9C 24 98 02 00 00 C5 F9 6E 8B ?? ?? ?? ?? 8B 9C 24 9C 02 00 00 C5 D1 6C E9 C5 F9 6E BB ?? ?? ?? ?? C5 C1 6C CE C5 D0 C6 F9 88 C5 F9 6E B7 ?? ?? ?? ?? C5 F9 6E A9 ?? ?? ?? ?? C5 C9 6C F5 C5 F9 6E 8A ?? ?? ?? ?? C5 F9 6E A8 ?? ?? ?? ?? C5 F1 6C CD C5 FC 10 6C 24 20 C5 C8 C6 F1 88 C5 DC 59 E5 C5 E4 59 DD C5 EC 5C E4 C5 DC 59 14 24 C5 FC 59 C4 8B 9C 24 A0 02 00 00 C4 E3 45 18 CE 01 C5 EC 58 C9 C5 E4 58 D1 C5 FC 58 9C 24 A0 00 00 00 C5 FC 10 44 24 40 C5 EC 58 E3 C5 DC 58 94 24 80 00 00 00 E9 66 F4 FF FF }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "__Stoull"
		size = 24
		refs = "000f __Stoullx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_107_123_1 {
	meta:
		name = "?_Execute_once@std@@YAHAAUonce_flag@1@P6GHPAX1PAPAX@Z1@Z"
		size = 24
		refs = "000f ___crtInitOnceExecuteOnce"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_59_0_2 {
	meta:
		name = "__Stod"
		size = 24
		refs = "000f __Stodx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_90_0_2 {
	meta:
		name = "__Stof"
		size = 24
		refs = "000f __Stofx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_99_0_2 {
	meta:
		name = "__Stold"
		size = 24
		refs = "000f __Stoldx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_11_0_1 {
	meta:
		name = "__Stoll"
		size = 24
		refs = "000f __Stollx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_40_0_1 {
	meta:
		name = "__Stoul"
		size = 24
		refs = "000f __Stoulx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_58_0_2 {
	meta:
		name = "__WStod"
		size = 24
		refs = "000f __WStodx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_87_0_1 {
	meta:
		name = "__WStof"
		size = 24
		refs = "000f __WStofx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_6_0_2 {
	meta:
		name = "__WStold"
		size = 24
		refs = "000f __WStoldx"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_0_1_1 {
	meta:
		name = "__Stoullx"
		size = 491
		refs = "0023 _isspace 00bb _tolower 00c2 _digits 00cb _memchr 00f7 __allmul 014c _ndigs 0189 __aulldiv 0198 __errno"
	strings:
		$1 = { 55 8B EC 8B 45 14 83 EC 24 85 C0 74 03 83 20 00 53 8B 5D 08 56 57 8B F3 0F B6 03 EB 04 46 0F B6 06 50 E8 ?? ?? ?? ?? 59 85 C0 75 F1 8A 06 88 45 FE 3C 2D 74 0A 3C 2B 74 06 C6 45 FE 2B EB 01 46 8B 7D 10 85 FF 0F 88 8C 01 00 00 83 FF 01 0F 84 83 01 00 00 83 FF 24 0F 8F 7A 01 00 00 85 FF 7E 17 83 FF 10 75 31 80 3E 30 75 2C 8A 46 01 3C 78 74 22 3C 58 75 21 EB 1C 80 3E 30 74 05 6A 0A 5F EB 15 8A 46 01 3C 78 74 08 3C 58 74 04 6A 08 EB EE 6A 10 5F 83 C6 02 89 75 E0 EB 01 46 80 3E 30 74 FA 33 C0 89 75 DC 89 45 F8 8B D8 89 45 F0 89 45 EC 88 45 FF 0F BE 06 57 50 E8 ?? ?? ?? ?? 59 50 B8 ?? ?? ?? ?? 50 89 45 F4 E8 ?? ?? ?? ?? 8B C8 83 C4 0C 85 C9 74 57 8B C7 99 89 45 E8 89 55 E4 8B 45 F8 2A 4D F4 53 50 52 FF 75 E8 89 45 F0 89 5D EC 88 4D FF E8 ?? ?? ?? ?? 8B C8 8B DA 0F BE 45 FF 99 03 C8 57 13 DA 89 4D F8 46 0F BE 06 50 E8 ?? ?? ?? ?? 59 50 B8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 55 E4 8B C8 83 C4 0C 85 C9 75 B2 39 75 E0 75 15 8B 4D 0C 85 C9 0F 84 A1 00 00 00 8B 45 08 89 01 E9 97 00 00 00 0F BE 87 ?? ?? ?? ?? 8B CE 2B C8 2B 4D DC 78 5F 85 C9 7F 3A 0F BE 45 FF 8B 4D F8 99 89 4D F4 29 45 F4 8B C3 1B C2 89 45 DC 3B D8 72 21 77 05 3B 4D F4 72 1A 8B C7 99 52 50 FF 75 DC FF 75 F4 E8 ?? ?? ?? ?? 3B 45 F0 75 05 3B 55 EC 74 21 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 14 85 C0 74 06 C7 00 01 00 00 00 83 C8 FF B1 2B 8B D8 EB 06 8A 4D FE 8B 45 F8 80 F9 2D 75 07 F7 D8 83 D3 00 F7 DB 8B 4D 0C 85 C9 74 02 89 31 8B D3 EB 0D 8B 45 0C 85 C0 74 02 89 18 33 C0 33 D2 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_4_1 {
	meta:
		name = "??$?8DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 16
		refs = "000a ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_58_19_1 {
	meta:
		name = "??$?8GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 16
		refs = "000a ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_58_22_1 {
	meta:
		name = "??$?8_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 16
		refs = "000a ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_101_118_1 {
	meta:
		name = "?__ExceptionPtrAssign@@YAXPAXPBX@Z"
		size = 16
		refs = "000a ??4?$shared_ptr@V__ExceptionPtr@@@std@@QAEAAV01@ABV01@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_1_7_1 {
	meta:
		name = "??$?9DU?$char_traits@D@std@@@std@@YA_NABV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 25
		refs = "000a ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8A C1 5D C3 }
	condition:
		$1
}

rule file_58_25_1 {
	meta:
		name = "??$?9GU?$char_traits@G@std@@@std@@YA_NABV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 25
		refs = "000a ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8A C1 5D C3 }
	condition:
		$1
}

rule file_58_28_1 {
	meta:
		name = "??$?9_WU?$char_traits@_W@std@@@std@@YA_NABV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 25
		refs = "000a ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? 33 C9 84 C0 0F 94 C1 8A C1 5D C3 }
	condition:
		$1
}

rule file_1_9_1 {
	meta:
		name = "??$_Find_elem@D@std@@YAIPADD@Z"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 55 08 8B C2 8A 0A 84 C9 74 10 53 8A 5D 0C 3A CB 74 07 40 8A 08 84 C9 75 F5 5B 2B C2 5D C3 }
	condition:
		$1
}

rule file_1_10_1 {
	meta:
		name = "??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z"
		size = 368
		refs = "0003 __ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z 0008 __EH_prolog3_GS 003b ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 007e ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 00b6 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00c9 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ 0152 ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ 0163 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 016b __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 8B 75 14 8B 7D 10 89 45 C8 8B 45 0C 89 45 B8 8A 06 84 C0 74 10 8A C8 8B D6 3A C8 75 01 47 42 8A 0A 84 C9 75 F4 6A 00 57 8D 4D D4 E8 ?? ?? ?? ?? 83 65 FC 00 33 C0 40 C7 45 BC FE FF FF FF 89 45 C0 32 E4 33 C9 33 DB 88 65 D3 89 4D CC 85 FF 0F 84 FB 00 00 00 8A 04 33 84 C0 74 0E 8A 16 3A C2 74 08 43 8A 04 33 84 C0 75 F4 51 8D 4D D4 E8 ?? ?? ?? ?? 80 38 00 74 18 FF 75 CC 8D 4D D4 E8 ?? ?? ?? ?? 0F BE 00 03 D8 8B 4D CC E9 88 00 00 00 8B 45 C0 03 D8 8A 0C 33 3A 0E 74 59 84 C9 74 55 FF 75 B8 8B 4D C8 E8 ?? ?? ?? ?? 84 C0 75 24 8B 55 C8 38 42 04 75 0A 8B CA E8 ?? ?? ?? ?? 8B 55 C8 8A 04 33 3A 42 05 75 0A 8B 4D CC B4 01 88 65 D3 EB 4B 8B 45 C0 6A 7F 59 89 45 C4 3B C1 72 03 89 4D C4 FF 75 CC 8D 4D D4 E8 ?? ?? ?? ?? 8B 4D C4 88 08 EB 93 6A 7F 59 89 45 C4 3B C1 72 03 89 4D C4 FF 75 CC 8D 4D D4 E8 ?? ?? ?? ?? 8B 4D C4 88 08 8B 4D CC 89 4D BC 8B 55 C8 8A 65 D3 41 89 4D CC 3B CF 0F 82 2B FF FF FF 84 E4 74 22 FF 75 B8 8B CA E8 ?? ?? ?? ?? 84 C0 75 14 8B 4D C8 FF 45 C0 E8 ?? ?? ?? ?? 83 4D BC FF E9 F1 FE FF FF 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 BC E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_12_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_42_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_45_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_48_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_51_1 {
	meta:
		name = "__ehhandler$??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_317_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_320_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_323_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_326_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_335_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_308_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1087_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1090_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1093_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1096_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1105_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1016_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1026_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1029_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1032_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1035_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1044_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1047_2 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_13_1 {
	meta:
		name = "??$_Getvals@D@?$numpunct@D@std@@IAEXDPBUlconv@@U_Cvtvec@@@Z"
		size = 25
	strings:
		$1 = { 55 8B EC 8B 55 0C 8B 02 8A 00 88 41 0C 8B 42 04 8A 00 88 41 0D 5D C2 34 00 }
	condition:
		$1
}

rule file_1_15_1 {
	meta:
		name = "??$_Maklocstr@D@std@@YAPADPBDPADABU_Cvtvec@@@Z"
		size = 72
		refs = "001d _calloc 0043 ?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 8B CE 57 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 6A 01 8D 79 01 57 E8 ?? ?? ?? ?? 8B D0 59 59 85 D2 74 19 85 FF 74 0F 8B CA 2B CE 8A 06 88 04 31 46 83 EF 01 75 F5 5F 8B C2 5E 5D C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_23_1 {
	meta:
		name = "??$construct@PADAAPAD@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPAPADAAPAD@Z"
		size = 21
		altNames = "??$construct@PADAAPAD@?$allocator@D@std@@QAEXPAPADAAPAD@Z ??$construct@PAGAAPAG@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QAEXPAPAGAAPAG@Z ??$construct@PAGAAPAG@?$allocator@G@std@@QAEXPAPAGAAPAG@Z ??$construct@PA_WAAPA_W@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QAEXPAPA_WAAPA_W@Z ??$construct@PA_WAAPA_W@?$allocator@_W@std@@QAEXPAPA_WAAPA_W@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 74 07 8B 45 0C 8B 00 89 01 5D C2 08 00 }
	condition:
		$1
}

rule file_1_25_1 {
	meta:
		name = "??$construct@PADAAPAD@?$allocator_traits@V?$allocator@D@std@@@std@@SAXAAV?$allocator@D@1@PAPADAAPAD@Z"
		size = 19
		altNames = "??$construct@PAGAAPAG@?$allocator_traits@V?$allocator@G@std@@@std@@SAXAAV?$allocator@G@1@PAPAGAAPAG@Z ??$construct@PA_WAAPA_W@?$allocator_traits@V?$allocator@_W@std@@@std@@SAXAAV?$allocator@_W@1@PAPA_WAAPA_W@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 85 C9 74 07 8B 45 10 8B 00 89 01 5D C3 }
	condition:
		$1
}

rule file_1_26_1 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAEXPAU_Container_proxy@1@$$QAU21@@Z"
		size = 27
		altNames = "??$construct@U_Container_proxy@std@@U12@@?$allocator@U_Container_proxy@std@@@std@@QAEXPAU_Container_proxy@1@$$QAU21@@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 85 D2 74 0D 8B 4D 0C 8B 01 89 02 8B 41 04 89 42 04 5D C2 08 00 }
	condition:
		$1
}

rule file_1_28_1 {
	meta:
		name = "??$construct@U_Container_proxy@std@@U12@@?$allocator_traits@V?$allocator@U_Container_proxy@std@@@std@@@std@@SAXAAV?$allocator@U_Container_proxy@std@@@1@PAU_Container_proxy@1@$$QAU31@@Z"
		size = 25
	strings:
		$1 = { 55 8B EC 8B 55 0C 85 D2 74 0D 8B 4D 10 8B 01 89 02 8B 41 04 89 42 04 5D C3 }
	condition:
		$1
}

rule file_1_39_1 {
	meta:
		name = "??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$codecvt@DDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_68_35_1 {
	meta:
		name = "??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$codecvt@GDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_12_35_1 {
	meta:
		name = "??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_61_1 {
	meta:
		name = "??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$collate@D@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$collate@D@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$collate@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_149_1 {
	meta:
		name = "??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$collate@G@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$collate@G@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_152_1 {
	meta:
		name = "??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$collate@_W@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$collate@_W@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_19_25_2 {
	meta:
		name = "??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$ctype@D@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$ctype@D@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_56_38_1 {
	meta:
		name = "??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$ctype@G@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$ctype@G@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_140_2 {
	meta:
		name = "??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$ctype@_W@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$ctype@_W@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_116_55_2 {
	meta:
		name = "??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$messages@D@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$messages@D@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_143_2 {
	meta:
		name = "??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$messages@G@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$messages@G@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_146_2 {
	meta:
		name = "??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$messages@_W@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$messages@_W@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_70_1 {
	meta:
		name = "??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_149_2 {
	meta:
		name = "??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_170_1 {
	meta:
		name = "??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_73_1 {
	meta:
		name = "??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_155_2 {
	meta:
		name = "??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_176_1 {
	meta:
		name = "??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_76_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$moneypunct@D$00@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$moneypunct@D$00@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_79_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$moneypunct@D$0A@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_179_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$moneypunct@G$00@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$moneypunct@G$00@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_182_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$moneypunct@G$0A@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_185_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$moneypunct@_W$00@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$moneypunct@_W$00@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_188_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$moneypunct@_W$0A@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_45_1 {
	meta:
		name = "??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_173_2 {
	meta:
		name = "??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_194_1 {
	meta:
		name = "??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_48_1 {
	meta:
		name = "??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_197_1 {
	meta:
		name = "??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_182_2 {
	meta:
		name = "??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_51_1 {
	meta:
		name = "??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$numpunct@D@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$numpunct@D@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_203_1 {
	meta:
		name = "??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$numpunct@G@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$numpunct@G@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_188_2 {
	meta:
		name = "??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$numpunct@_W@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$numpunct@_W@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_82_1 {
	meta:
		name = "??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_191_2 {
	meta:
		name = "??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_194_2 {
	meta:
		name = "??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_85_1 {
	meta:
		name = "??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_197_2 {
	meta:
		name = "??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_44_200_2 {
	meta:
		name = "??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 157
		refs = "0003 __ehhandler$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 0018 ?_Psave@?$_Facetptr@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PBVfacet@locale@2@B 001d ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0029 ??Bid@locale@std@@QAEIXZ 0032 ?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z 004c ?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 005b ??0bad_cast@std@@QAE@XZ 0060 __TI2?AVbad_cast@std@@ 0069 __CxxThrowException@8 007e @_guard_check_icall@4 0088 ?_Facet_Register@std@@YAXPAV_Facet_base@1@@Z 0091 ??1_Lockit@std@@QAE@XZ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 14 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 65 FC 00 89 75 F0 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 8B F8 85 FF 75 51 85 F6 74 04 8B FE EB 49 FF 75 08 8D 45 F0 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 16 8D 4D E0 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 7D F0 89 3D ?? ?? ?? ?? 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 57 E8 ?? ?? ?? ?? 59 8D 4D EC E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_41_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_68_37_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_37_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_63_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@D@std@@@std@@YAABV?$collate@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_151_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@G@std@@@std@@YAABV?$collate@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_154_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$collate@_W@std@@@std@@YAABV?$collate@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_27_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_27_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_27_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_57_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@D@std@@@std@@YAABV?$messages@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_163_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@G@std@@@std@@YAABV?$messages@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_166_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$messages@_W@std@@@std@@YAABV?$messages@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_72_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_151_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_172_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_75_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_175_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_160_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_78_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$00@std@@@std@@YAABV?$moneypunct@D$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_81_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAABV?$moneypunct@D$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_163_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$00@std@@@std@@YAABV?$moneypunct@G$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_184_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAABV?$moneypunct@G$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_187_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAABV?$moneypunct@_W$00@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_190_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAABV?$moneypunct@_W$0A@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_47_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_175_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_178_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_50_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_199_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_202_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_53_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_205_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@G@std@@@std@@YAABV?$numpunct@G@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_190_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$numpunct@_W@std@@@std@@YAABV?$numpunct@_W@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_84_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_193_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_196_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_87_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_199_2 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAABV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_220_1 {
	meta:
		name = "__ehhandler$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAABV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@ABVlocale@0@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_393_2 {
	meta:
		name = "__ehhandler$?do_get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1149_1 {
	meta:
		name = "__ehhandler$?do_get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1152_1 {
	meta:
		name = "__ehhandler$?do_get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@DD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A DC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_54_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ"
		size = 22
		refs = "000e ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 33 C0 89 06 89 46 14 89 46 18 E8 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_58_234_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ"
		size = 22
		refs = "000e ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 33 C0 89 06 89 46 14 89 46 18 E8 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_58_235_1 {
	meta:
		name = "??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ"
		size = 22
		refs = "000e ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 33 C0 89 06 89 46 14 89 46 18 E8 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_1_61_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z"
		size = 73
		refs = "0003 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0008 __EH_prolog3 001c ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ 002e ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 003b ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 0042 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 33 FF 89 3E 89 7E 14 89 7E 18 E8 ?? ?? ?? ?? 57 8B CE 89 7D FC C7 46 18 0F 00 00 00 E8 ?? ?? ?? ?? FF 75 0C 8B CE FF 75 08 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_90_119_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z"
		size = 73
		refs = "0003 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBDI@Z 0008 __EH_prolog3 001c ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ 002e ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 003b ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z 0042 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 33 FF 89 3E 89 7E 14 89 7E 18 E8 ?? ?? ?? ?? 57 8B CE 89 7D FC C7 46 18 0F 00 00 00 E8 ?? ?? ?? ?? FF 75 0C 8B CE FF 75 08 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_1_64_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		size = 80
		refs = "0003 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0008 __EH_prolog3 001c ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ 002e ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 0036 ?length@?$char_traits@D@std@@SAIPBD@Z 0042 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z 0049 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 33 FF 89 3E 89 7E 14 89 7E 18 E8 ?? ?? ?? ?? 57 8B CE 89 7D FC C7 46 18 0F 00 00 00 E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_1_67_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 87
		refs = "0006 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0014 ___security_cookie 0031 ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ 0040 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 33 FF 89 3E 89 7E 14 89 7E 18 E8 ?? ?? ?? ?? 57 8B CE C7 46 18 0F 00 00 00 E8 ?? ?? ?? ?? 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_68_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_38_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_276_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_290_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_292_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_306_1 {
	meta:
		name = "__ehhandler$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_573_2_5 {
	meta:
		name = "__ehhandler$??1_Fac_node@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Fac_node@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_362_2 {
	meta:
		name = "__ehhandler$??1_Locinfo@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locinfo@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_79_1 {
	meta:
		name = "__ehhandler$??1_Sentry_base@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Sentry_base@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_80_1 {
	meta:
		name = "__ehhandler$??1_Sentry_base@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Sentry_base@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_80_1 {
	meta:
		name = "__ehhandler$??1_Sentry_base@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Sentry_base@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_59_1 {
	meta:
		name = "__ehhandler$??1__ExceptionPtr@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1__ExceptionPtr@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_131_2 {
	meta:
		name = "__ehhandler$??1locale@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1locale@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_8_1 {
	meta:
		name = "__ehhandler$??_EGlobalCore@details@Concurrency@@QAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_EGlobalCore@details@Concurrency@@QAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_151_2 {
	meta:
		name = "__ehhandler$?default_error_condition@_System_error_category@std@@UBE?AVerror_condition@2@H@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?default_error_condition@_System_error_category@std@@UBE?AVerror_condition@2@H@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_16_2_1 {
	meta:
		name = "__ehhandler$?get_new_handler@std@@YAP6AXXZXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?get_new_handler@std@@YAP6AXXZXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_4_2 {
	meta:
		name = "__ehhandler$?set_new_handler@std@@YAP6AXXZP6AXXZ@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?set_new_handler@std@@YAP6AXXZP6AXXZ@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_69_1 {
	meta:
		name = "??0?$codecvt@DDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_116_98_2 {
	meta:
		name = "??0?$messages@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$messages@D@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_313_1 {
	meta:
		name = "??0?$messages@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$messages@G@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_314_1 {
	meta:
		name = "??0?$messages@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$messages@_W@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_116_99_2 {
	meta:
		name = "??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_315_1 {
	meta:
		name = "??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_316_1 {
	meta:
		name = "??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_116_100_2 {
	meta:
		name = "??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_44_261_2 {
	meta:
		name = "??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_318_1 {
	meta:
		name = "??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_54_2 {
	meta:
		name = "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_323_1 {
	meta:
		name = "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_324_1 {
	meta:
		name = "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_52_55_2 {
	meta:
		name = "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_325_1 {
	meta:
		name = "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_326_1 {
	meta:
		name = "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "0011 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_1_70_1 {
	meta:
		name = "??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 56
		refs = "001a ??_7?$ctype@D@std@@6B@ 001f __Getctype"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 0C 53 8B D9 56 57 89 5D FC 89 43 04 8D 45 EC 50 C7 03 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8D 7B 08 59 8B C3 A5 A5 A5 A5 5F 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_1_73_1 {
	meta:
		name = "??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 54
		refs = "0003 __ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0008 __EH_prolog3 0023 ??_7?$numpunct@D@std@@6B@ 0028 ?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 002f __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 8B 45 0C 89 46 04 FF 75 10 83 65 FC 00 FF 75 08 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_58_327_1 {
	meta:
		name = "??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 54
		refs = "0003 __ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0008 __EH_prolog3 0023 ??_7?$numpunct@G@std@@6B@ 0028 ?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z 002f __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 8B 45 0C 89 46 04 FF 75 10 83 65 FC 00 FF 75 08 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_58_330_1 {
	meta:
		name = "??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 54
		refs = "0003 __ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0008 __EH_prolog3 0023 ??_7?$numpunct@_W@std@@6B@ 0028 ?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z 002f __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 8B 45 0C 89 46 04 FF 75 10 83 65 FC 00 FF 75 08 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_1_80_1 {
	meta:
		name = "??0_Locinfo@std@@QAE@PBD@Z"
		size = 125
		refs = "0003 __ehhandler$??0_Locinfo@std@@QAE@PBD@Z 0008 __EH_prolog3 0015 ??0_Lockit@std@@QAE@H@Z 004e ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@ 0056 ??0runtime_error@std@@QAE@PBD@Z 005b __TI2?AVruntime_error@std@@ 0064 __CxxThrowException@8 006d ?_Locinfo_ctor@_Locinfo@std@@SAXPAV12@PBD@Z 0076 __EH_epilog3"
	strings:
		$1 = { 6A 10 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 33 DB 53 E8 ?? ?? ?? ?? 89 5D FC 89 5E 04 88 5E 08 89 5E 0C 88 5E 10 33 C0 89 5E 14 66 89 46 18 89 5E 1C 66 89 46 20 89 5E 24 88 5E 28 89 5E 2C 88 5E 30 C6 45 FC 06 39 45 08 75 1B 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E4 50 E8 ?? ?? ?? ?? FF 75 08 56 E8 ?? ?? ?? ?? 59 59 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_1_88_1 {
	meta:
		name = "__ehhandler$??0_Locinfo@std@@QAE@PBD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locinfo@std@@QAE@PBD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_22_1 {
	meta:
		name = "__ehhandler$??$allocate_shared@V__ExceptionPtr@@U?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@std@@YA?AV?$shared_ptr@V__ExceptionPtr@@@0@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$allocate_shared@V__ExceptionPtr@@U?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@_N@std@@YA?AV?$shared_ptr@V__ExceptionPtr@@@0@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_73_2 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_578_1 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_42_2 {
	meta:
		name = "__ehhandler$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_111_2 {
	meta:
		name = "__ehhandler$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_91_1 {
	meta:
		name = "??0codecvt_base@std@@QAE@I@Z"
		size = 27
		refs = "0011 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_102_100_1 {
	meta:
		name = "??0ctype_base@std@@QAE@I@Z"
		size = 27
		refs = "0011 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_41_82_2 {
	meta:
		name = "??0facet@locale@std@@IAE@I@Z"
		size = 27
		refs = "0011 ??_7facet@locale@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_370_1 {
	meta:
		name = "??0messages_base@std@@QAE@I@Z"
		size = 27
		refs = "0011 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_90_162_1 {
	meta:
		name = "??0money_base@std@@QAE@I@Z"
		size = 27
		refs = "0011 ??_7money_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_90_165_1 {
	meta:
		name = "??0time_base@std@@QAE@I@Z"
		size = 27
		refs = "0011 ??_7time_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 89 41 04 8B C1 89 4D FC C7 01 ?? ?? ?? ?? 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_94_1 {
	meta:
		name = "??0exception@std@@QAE@QBD@Z"
		size = 55
		refs = "001a ??_7exception@std@@6B@ 0028 ___std_exception_copy"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 08 56 8B F1 89 45 F8 8D 45 F8 C6 45 FC 01 8D 56 04 C7 06 ?? ?? ?? ?? 83 22 00 83 62 04 00 52 50 E8 ?? ?? ?? ?? 59 59 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_98_1 {
	meta:
		name = "??0locale@std@@QAE@ABV01@@Z"
		size = 86
		refs = "0006 __ehhandler$??0locale@std@@QAE@ABV01@@Z 0015 ___security_cookie 0038 @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 53 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B D9 8B 45 08 8B 78 04 89 7B 04 8B 07 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B C3 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_99_1 {
	meta:
		name = "__ehhandler$??0locale@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0locale@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_46_2 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_46_2 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_46_2 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_13_2 {
	meta:
		name = "__ehhandler$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CallInContext@_ContextCallback@details@Concurrency@@QBEXV?$function@$$A6AXXZ@std@@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_225_2 {
	meta:
		name = "__ehhandler$?_Init@ios_base@std@@IAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@ios_base@std@@IAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_22_2 {
	meta:
		name = "__ehhandler$?rethrow_exception@std@@YAXVexception_ptr@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?rethrow_exception@std@@YAXVexception_ptr@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F0 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_100_1 {
	meta:
		name = "??0locale@std@@QAE@XZ"
		size = 66
		refs = "0006 __ehhandler$??0locale@std@@QAE@XZ 0013 ___security_cookie 0028 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 6A 01 E8 ?? ?? ?? ?? 89 46 04 8B C6 59 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_101_1 {
	meta:
		name = "__ehhandler$??0locale@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0locale@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_105_2 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_132_1 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_104_2 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_1_2 {
	meta:
		name = "__ehhandler$??1_Init_atexit@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Init_atexit@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_18_1 {
	meta:
		name = "__ehhandler$??1_Locimp@locale@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locimp@locale@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_86_1 {
	meta:
		name = "__ehhandler$??1sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_89_1 {
	meta:
		name = "__ehhandler$??1sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_89_1 {
	meta:
		name = "__ehhandler$??1sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_208_1 {
	meta:
		name = "__ehhandler$??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_453_1 {
	meta:
		name = "__ehhandler$??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_456_1 {
	meta:
		name = "__ehhandler$??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@$$QAV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_148_2 {
	meta:
		name = "__ehhandler$??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_147_2 {
	meta:
		name = "__ehhandler$??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_94_147_2 {
	meta:
		name = "__ehhandler$??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_165_2 {
	meta:
		name = "__ehhandler$??_Gios_base@std@@UAEPAXI@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_Gios_base@std@@UAEPAXI@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_265_2 {
	meta:
		name = "__ehhandler$?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1004_1 {
	meta:
		name = "__ehhandler$?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@$$QAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_921_2 {
	meta:
		name = "__ehhandler$?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@$$QAV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A F8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_103_1 {
	meta:
		name = "??0runtime_error@std@@QAE@PBD@Z"
		size = 33
		refs = "000e ??0exception@std@@QAE@QBD@Z 0014 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 56 FF 75 08 8B F1 89 75 FC E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_9_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@PBD@Z"
		size = 33
		refs = "000e ??0exception@std@@QAE@QBD@Z 0014 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 56 FF 75 08 8B F1 89 75 FC E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_11_1 {
	meta:
		name = "??0length_error@std@@QAE@PBD@Z"
		size = 33
		refs = "000e ??0exception@std@@QAE@QBD@Z 0014 ??_7length_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 56 FF 75 08 8B F1 89 75 FC E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_25_6_1 {
	meta:
		name = "??0logic_error@std@@QAE@PBD@Z"
		size = 33
		refs = "000e ??0exception@std@@QAE@QBD@Z 0014 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 56 FF 75 08 8B F1 89 75 FC E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_15_1 {
	meta:
		name = "??0out_of_range@std@@QAE@PBD@Z"
		size = 33
		refs = "000e ??0exception@std@@QAE@QBD@Z 0014 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 56 FF 75 08 8B F1 89 75 FC E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_106_17_1 {
	meta:
		name = "??0overflow_error@std@@QAE@PBD@Z"
		size = 33
		refs = "000e ??0exception@std@@QAE@QBD@Z 0014 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 56 FF 75 08 8B F1 89 75 FC E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_105_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@XZ"
		size = 22
		refs = "000a ?_Deallocate@std@@YAXPAXII@Z"
		altNames = "??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@XZ ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@XZ ?_Free_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ ?_Free_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXXZ ?_Free_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 5E C3 }
	condition:
		$1
}

rule file_1_107_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QAE@XZ"
		size = 21
		refs = "000b _free"
		altNames = "??1?$_Yarn@_W@std@@QAE@XZ ?_Tidy@?$_Yarn@D@std@@AAEXXZ ?_Tidy@?$_Yarn@_W@std@@AAEXXZ"
	strings:
		$1 = { 56 8B F1 83 3E 00 74 08 FF 36 E8 ?? ?? ?? ?? 59 83 26 00 5E C3 }
	condition:
		$1
}

rule file_1_109_1 {
	meta:
		name = "??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
		size = 31
		refs = "0008 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0013 ?_Deallocate@std@@YAXPAXII@Z"
	strings:
		$1 = { 56 6A 00 6A 01 8B F1 E8 ?? ?? ?? ?? 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 5E C3 }
	condition:
		$1
}

rule file_58_395_1 {
	meta:
		name = "??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
		size = 31
		refs = "0008 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z 0013 ?_Deallocate@std@@YAXPAXII@Z"
	strings:
		$1 = { 56 6A 00 6A 01 8B F1 E8 ?? ?? ?? ?? 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 5E C3 }
	condition:
		$1
}

rule file_58_396_1 {
	meta:
		name = "??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
		size = 31
		refs = "0008 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z 0013 ?_Deallocate@std@@YAXPAXII@Z"
	strings:
		$1 = { 56 6A 00 6A 01 8B F1 E8 ?? ?? ?? ?? 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 5E C3 }
	condition:
		$1
}

rule file_1_111_1 {
	meta:
		name = "??1?$ctype@D@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$ctype@D@std@@6B@ 000a ?_Tidy@?$ctype@D@std@@IAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_116_135_2 {
	meta:
		name = "??1?$_Mpunct@D@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@D@std@@6B@ 000a ?_Tidy@?$_Mpunct@D@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_58_380_1 {
	meta:
		name = "??1?$_Mpunct@G@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@G@std@@6B@ 000a ?_Tidy@?$_Mpunct@G@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_44_319_2 {
	meta:
		name = "??1?$_Mpunct@_W@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@_W@std@@6B@ 000a ?_Tidy@?$_Mpunct@_W@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_116_146_2 {
	meta:
		name = "??1?$moneypunct@D$00@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@D@std@@6B@ 000a ?_Tidy@?$_Mpunct@D@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_116_147_2 {
	meta:
		name = "??1?$moneypunct@D$0A@@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@D@std@@6B@ 000a ?_Tidy@?$_Mpunct@D@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_44_343_2 {
	meta:
		name = "??1?$moneypunct@G$00@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@G@std@@6B@ 000a ?_Tidy@?$_Mpunct@G@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_58_410_1 {
	meta:
		name = "??1?$moneypunct@G$0A@@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@G@std@@6B@ 000a ?_Tidy@?$_Mpunct@G@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_58_411_1 {
	meta:
		name = "??1?$moneypunct@_W$00@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@_W@std@@6B@ 000a ?_Tidy@?$_Mpunct@_W@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_44_346_2 {
	meta:
		name = "??1?$moneypunct@_W$0A@@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$_Mpunct@_W@std@@6B@ 000a ?_Tidy@?$_Mpunct@_W@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_52_95_2 {
	meta:
		name = "??1?$numpunct@D@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$numpunct@D@std@@6B@ 000a ?_Tidy@?$numpunct@D@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_44_351_2 {
	meta:
		name = "??1?$numpunct@G@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$numpunct@G@std@@6B@ 000a ?_Tidy@?$numpunct@G@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_58_418_1 {
	meta:
		name = "??1?$numpunct@_W@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$numpunct@_W@std@@6B@ 000a ?_Tidy@?$numpunct@_W@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_90_183_1 {
	meta:
		name = "??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 000a ?_Tidy@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_58_419_1 {
	meta:
		name = "??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 000a ?_Tidy@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_58_420_1 {
	meta:
		name = "??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ"
		size = 22
		refs = "0005 ??_7?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 000a ?_Tidy@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AAEXXZ 0010 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_1_118_1 {
	meta:
		name = "??1_Locinfo@std@@QAE@XZ"
		size = 174
		refs = "0006 __ehhandler$??1_Locinfo@std@@QAE@XZ 0014 ___security_cookie 0028 ?_Locinfo_dtor@_Locinfo@std@@SAXPAV12@@Z 0037 _free 0099 ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 56 E8 ?? ?? ?? ?? 83 7E 2C 00 59 74 09 FF 76 2C E8 ?? ?? ?? ?? 59 33 FF 89 7E 2C 39 7E 24 74 09 FF 76 24 E8 ?? ?? ?? ?? 59 89 7E 24 39 7E 1C 74 09 FF 76 1C E8 ?? ?? ?? ?? 59 89 7E 1C 39 7E 14 74 09 FF 76 14 E8 ?? ?? ?? ?? 59 89 7E 14 39 7E 0C 74 09 FF 76 0C E8 ?? ?? ?? ?? 59 89 7E 0C 39 7E 04 74 09 FF 76 04 E8 ?? ?? ?? ?? 59 8B CE 89 7E 04 E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_125_1 {
	meta:
		name = "??1locale@std@@QAE@XZ"
		size = 99
		refs = "0006 __ehhandler$??1locale@std@@QAE@XZ 0014 ___security_cookie 0033 @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B 79 04 85 FF 74 27 8B 07 8B 70 08 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B F8 85 FF 74 11 8B 0F 6A 01 8B 31 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_129_1 {
	meta:
		name = "??4?$_Yarn@D@std@@QAEAAV01@PBD@Z"
		size = 84
		refs = "0016 _free 0035 _malloc 0044 _memcpy"
	strings:
		$1 = { 55 8B EC 53 8B D9 57 8B 7D 08 39 3B 74 3E 83 3B 00 74 08 FF 33 E8 ?? ?? ?? ?? 59 83 23 00 85 FF 74 2A 80 3F 00 56 8B F7 74 06 46 80 3E 00 75 FA 2B F7 46 56 E8 ?? ?? ?? ?? 89 03 59 85 C0 74 0B 56 57 50 E8 ?? ?? ?? ?? 83 C4 0C 5E 5F 8B C3 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_1_130_1 {
	meta:
		name = "??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@ABV01@@Z"
		size = 30
		refs = "0013 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 3B 75 08 74 0C 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_454_1 {
	meta:
		name = "??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@ABV01@@Z"
		size = 30
		refs = "0013 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 3B 75 08 74 0C 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_457_1 {
	meta:
		name = "??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@ABV01@@Z"
		size = 30
		refs = "0013 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 3B 75 08 74 0C 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_131_1 {
	meta:
		name = "??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@D@Z"
		size = 36
		refs = "0011 ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHD@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4E 04 85 C9 74 0D FF 75 08 E8 ?? ?? ?? ?? 83 F8 FF 75 03 C6 06 01 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_132_1 {
	meta:
		name = "??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z"
		size = 37
		refs = "0020 __invalid_parameter_noinfo_noreturn"
		altNames = "??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 41 14 77 14 83 79 18 10 72 05 8B 49 04 EB 03 83 C1 04 03 C1 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_134_1 {
	meta:
		name = "??Bid@locale@std@@QAEIXZ"
		size = 55
		refs = "0012 ??0_Lockit@std@@QAE@H@Z 001c ?_Id_cnt@id@locale@std@@0HA 002c ??1_Lockit@std@@QAE@XZ"
	strings:
		$1 = { 55 8B EC 51 56 8B F1 83 3E 00 75 24 6A 00 8D 4D FC E8 ?? ?? ?? ?? 83 3E 00 75 0D A1 ?? ?? ?? ?? 40 A3 ?? ?? ?? ?? 89 06 8D 4D FC E8 ?? ?? ?? ?? 8B 06 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_135_1 {
	meta:
		name = "??D?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBEDXZ"
		size = 19
		refs = "000a ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ"
	strings:
		$1 = { 56 8B F1 80 7E 04 00 75 05 E8 ?? ?? ?? ?? 8A 46 05 5E C3 }
	condition:
		$1
}

rule file_1_139_1 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@ABV01@@Z"
		size = 19
		refs = "000b ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
		altNames = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_502_1 {
	meta:
		name = "??Y?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@ABV01@@Z"
		size = 19
		refs = "000b ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_504_1 {
	meta:
		name = "??Y?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@ABV01@@Z"
		size = 19
		refs = "000b ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_993_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@@Z"
		size = 19
		refs = "000b ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_996_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@@Z"
		size = 19
		refs = "000b ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_1_294_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@@Z"
		size = 19
		refs = "000b ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1005_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@@Z"
		size = 19
		refs = "000b ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1012_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@@Z"
		size = 19
		refs = "000b ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@ABV12@II@Z"
	strings:
		$1 = { 55 8B EC 6A FF 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_1_140_1 {
	meta:
		name = "??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@D@Z"
		size = 17
		refs = "0009 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 6A 01 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_503_1 {
	meta:
		name = "??Y?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@G@Z"
		size = 17
		refs = "0009 ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@IG@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 6A 01 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_505_1 {
	meta:
		name = "??Y?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@_W@Z"
		size = 17
		refs = "0009 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@I_W@Z"
	strings:
		$1 = { 55 8B EC FF 75 08 6A 01 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_1_141_1 {
	meta:
		name = "??_G?$codecvt@DDU_Mbstatet@@@std@@MAEPAXI@Z"
		size = 35
		refs = "000c ??_7_Facet_base@std@@6B@ 0016 ??3@YAXPAXI@Z"
		altNames = "??_G?$messages@D@std@@MAEPAXI@Z ??_G?$messages@G@std@@MAEPAXI@Z ??_G?$messages@_W@std@@MAEPAXI@Z ??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z ??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z ??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z ??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z ??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z ??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z ??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z ??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z ??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z ??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z ??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z ??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z ??_Gcodecvt_base@std@@UAEPAXI@Z ??_Gctype_base@std@@UAEPAXI@Z ??_Gfacet@locale@std@@MAEPAXI@Z ??_Gmessages_base@std@@UAEPAXI@Z ??_Gmoney_base@std@@UAEPAXI@Z ??_Gtime_base@std@@UAEPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 08 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_85_78_1 {
	meta:
		name = "??_G_Generic_error_category@std@@UAEPAXI@Z"
		size = 35
		refs = "000c ??_7error_category@std@@6B@ 0016 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 08 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_109_73_2 {
	meta:
		name = "??_G_Iostream_error_category@std@@UAEPAXI@Z"
		size = 35
		refs = "000c ??_7error_category@std@@6B@ 0016 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 08 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_107_103_1 {
	meta:
		name = "??_G_System_error_category@std@@UAEPAXI@Z"
		size = 35
		refs = "000c ??_7error_category@std@@6B@ 0016 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 08 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_190_1 {
	meta:
		name = "??_Gerror_category@std@@UAEPAXI@Z"
		size = 35
		refs = "000c ??_7error_category@std@@6B@ 0016 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 08 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_142_1 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 46
		refs = "0008 ??_7?$ctype@D@std@@6B@ 000d ?_Tidy@?$ctype@D@std@@IAEXXZ 0017 ??_7_Facet_base@std@@6B@ 0021 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 C7 06 ?? ?? ?? ?? 74 0A 6A 18 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_145_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 46
		refs = "0008 ??_7?$numpunct@D@std@@6B@ 000d ?_Tidy@?$numpunct@D@std@@AAEXXZ 0017 ??_7_Facet_base@std@@6B@ 0021 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 C7 06 ?? ?? ?? ?? 74 0A 6A 18 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_530_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 46
		refs = "0008 ??_7?$numpunct@G@std@@6B@ 000d ?_Tidy@?$numpunct@G@std@@AAEXXZ 0017 ??_7_Facet_base@std@@6B@ 0021 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 C7 06 ?? ?? ?? ?? 74 0A 6A 18 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_531_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 46
		refs = "0008 ??_7?$numpunct@_W@std@@6B@ 000d ?_Tidy@?$numpunct@_W@std@@AAEXXZ 0017 ??_7_Facet_base@std@@6B@ 0021 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 C7 06 ?? ?? ?? ?? 74 0A 6A 18 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_146_1 {
	meta:
		name = "??_G_Facet_base@std@@UAEPAXI@Z"
		size = 35
		refs = "000c ??_7_Facet_base@std@@6B@ 0016 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 04 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_153_1 {
	meta:
		name = "?_Addfac@_Locimp@locale@std@@AAEXPAVfacet@23@I@Z"
		size = 22
		refs = "000b ?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C2 08 00 }
	condition:
		$1
}

rule file_1_154_1 {
	meta:
		name = "?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ"
		size = 36
		refs = "000a ?_Allocate@std@@YAPAXII_N@Z"
		altNames = "?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXXZ ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 6A 01 6A 08 6A 01 8B F1 E8 ?? ?? ?? ?? 83 C4 0C 89 06 85 C0 74 07 83 20 00 83 60 04 00 8B 06 89 30 5E C3 }
	condition:
		$1
}

rule file_1_155_1 {
	meta:
		name = "?_Allocate@std@@YAPAXII_N@Z"
		size = 98
		refs = "001b ?_Xbad_alloc@std@@YAXXZ 003a ??2@YAPAXI@Z 0046 __invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 55 8B EC 8B 4D 08 85 C9 75 04 33 C0 5D C3 83 C8 FF 33 D2 F7 75 0C 3B C1 73 05 E9 ?? ?? ?? ?? 0F AF 4D 0C 80 7D 10 00 74 2C 81 F9 00 10 00 00 72 24 8D 41 23 3B C1 76 E2 50 E8 ?? ?? ?? ?? 59 8B C8 85 C9 75 05 E9 ?? ?? ?? ?? 8D 41 23 83 E0 E0 89 48 FC 5D C3 51 E8 ?? ?? ?? ?? 59 85 C0 74 E5 5D C3 }
	condition:
		$1
}

rule file_1_156_1 {
	meta:
		name = "?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX$$QAV12@@Z"
		size = 93
		refs = "0022 _memmove 0053 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 8B F9 83 7E 18 10 73 1B 8B 46 14 83 C0 01 74 23 50 8D 46 04 8D 4F 04 50 51 E8 ?? ?? ?? ?? 83 C4 0C EB 10 8D 4F 04 85 C9 74 05 8B 46 04 89 01 83 66 04 00 8B 46 14 8B CE 89 47 14 8B 46 18 89 47 18 6A 00 C7 46 18 0F 00 00 00 E8 ?? ?? ?? ?? 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_159_1 {
	meta:
		name = "?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXIID@Z"
		size = 74
		refs = "003f _memset"
	strings:
		$1 = { 55 8B EC 83 7D 0C 01 75 19 83 79 18 10 72 05 8B 51 04 EB 03 8D 51 04 8B 45 08 8A 4D 10 88 0C 02 EB 24 83 79 18 10 72 05 8B 49 04 EB 03 83 C1 04 FF 75 0C 0F BE 45 10 50 8B 45 08 03 C1 50 E8 ?? ?? ?? ?? 83 C4 0C 5D C2 0C 00 }
	condition:
		$1
}

rule file_1_160_1 {
	meta:
		name = "?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXI@Z"
		size = 21
		refs = "0010 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 8B 41 14 3B 45 08 72 04 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_564_1 {
	meta:
		name = "?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXI@Z"
		size = 21
		refs = "0010 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 8B 41 14 3B 45 08 72 04 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_565_1 {
	meta:
		name = "?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXI@Z"
		size = 21
		refs = "0010 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 8B 41 14 3B 45 08 72 04 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_161_1 {
	meta:
		name = "?_Clamp_suffix_size@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEIII@Z"
		size = 21
		altNames = "?_Clamp_suffix_size@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEIII@Z ?_Clamp_suffix_size@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEIII@Z"
	strings:
		$1 = { 55 8B EC 8B 41 14 2B 45 08 39 45 0C 77 03 8B 45 0C 5D C2 08 00 }
	condition:
		$1
}

rule file_1_162_1 {
	meta:
		name = "?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z"
		size = 97
		refs = "0003 __ehhandler$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0008 __EH_prolog3_catch 0058 ?_Allocate@std@@YAPAXII_N@Z"
	strings:
		$1 = { 6A 10 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 89 7D E8 8B 75 08 83 CE 0F 83 FE FE 76 05 8B 75 08 EB 2A 33 D2 C7 45 EC 03 00 00 00 8B C6 8B 5F 18 F7 75 EC 8B CB D1 E9 3B C8 76 11 6A FE 58 2B C1 3B D8 77 05 8D 34 19 EB 03 6A FE 5E 83 65 FC 00 8D 46 01 6A 01 6A 01 50 E8 ?? ?? ?? ?? 83 C4 0C EB 2D }
	condition:
		$1
}

rule file_1_163_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z$0"
		size = 126
		refs = "0014 ?_Allocate@std@@YAPAXII_N@Z 001f $LN211 004d _memcpy 005b ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0072 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 0077 __EH_epilog3"
	strings:
		$1 = { 8B 45 08 89 65 F0 6A 01 89 45 EC 40 6A 01 50 C6 45 FC 02 E8 ?? ?? ?? ?? 89 45 E4 83 C4 0C B8 ?? ?? ?? ?? C3 8B 7D E8 8B 75 EC 8B 45 E4 8B 5D 0C 89 45 EC 85 DB 74 1D 83 7F 18 10 72 05 8B 4F 04 EB 03 8D 4F 04 85 DB 74 0B 53 51 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 00 6A 01 8B CF E8 ?? ?? ?? ?? 8D 4F 04 85 C9 74 05 8B 45 EC 89 01 53 8B CF 89 77 18 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_1_164_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z$1"
		size = 22
		refs = "0008 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0011 __CxxThrowException@8"
	strings:
		$1 = { 8B 4D E8 6A 00 6A 01 E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_577_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXII@Z$1"
		size = 22
		refs = "0008 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z 0011 __CxxThrowException@8"
	strings:
		$1 = { 8B 4D E8 6A 00 6A 01 E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_581_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII@Z$1"
		size = 22
		refs = "0008 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z 0011 __CxxThrowException@8"
	strings:
		$1 = { 8B 4D E8 6A 00 6A 01 E8 ?? ?? ?? ?? 6A 00 6A 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_166_1 {
	meta:
		name = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z"
		size = 31
		refs = "000a ?_Deallocate@std@@YAXPAXII@Z 0017 ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ"
		altNames = "?_Move_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXAAU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z"
	strings:
		$1 = { 56 8B F1 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 8B CE E8 ?? ?? ?? ?? 5E C2 04 00 }
	condition:
		$1
}

rule file_58_583_1 {
	meta:
		name = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z"
		size = 31
		refs = "000a ?_Deallocate@std@@YAXPAXII@Z 0017 ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 8B CE E8 ?? ?? ?? ?? 5E C2 04 00 }
	condition:
		$1
}

rule file_58_584_1 {
	meta:
		name = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXABU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z"
		size = 31
		refs = "000a ?_Deallocate@std@@YAXPAXII@Z 0017 ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 8B CE E8 ?? ?? ?? ?? 5E C2 04 00 }
	condition:
		$1
}

rule file_58_899_1 {
	meta:
		name = "?_Move_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXAAU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z"
		size = 31
		refs = "000a ?_Deallocate@std@@YAXPAXII@Z 0017 ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 8B CE E8 ?? ?? ?? ?? 5E C2 04 00 }
	condition:
		$1
}

rule file_58_900_1 {
	meta:
		name = "?_Move_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXAAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z"
		size = 31
		refs = "000a ?_Deallocate@std@@YAXPAXII@Z 0017 ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 6A 08 6A 01 FF 36 E8 ?? ?? ?? ?? 83 26 00 83 C4 0C 8B CE E8 ?? ?? ?? ?? 5E C2 04 00 }
	condition:
		$1
}

rule file_1_167_1 {
	meta:
		name = "?_Deallocate@std@@YAXPAXII@Z"
		size = 75
		refs = "0013 __invalid_parameter_noinfo_noreturn 0044 ??3@YAXPAX@Z"
	strings:
		$1 = { 55 8B EC 83 C8 FF 8B 4D 0C 33 D2 F7 75 10 3B C8 76 05 E9 ?? ?? ?? ?? 0F AF 4D 10 81 F9 00 10 00 00 72 1C 8B 45 08 A8 1F 75 E8 8B 48 FC 3B C8 73 E1 2B C1 83 F8 04 72 DA 83 F8 23 76 05 EB D3 8B 4D 08 51 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_1_168_1 {
	meta:
		name = "?_Decref@facet@locale@std@@UAEPAV_Facet_base@3@XZ"
		size = 18
	strings:
		$1 = { 83 C8 FF F0 0F C1 41 04 48 F7 D8 1B C0 F7 D0 23 C1 C3 }
	condition:
		$1
}

rule file_1_169_1 {
	meta:
		name = "?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
		size = 31
	strings:
		$1 = { 55 8B EC 83 79 18 10 8B 45 08 89 41 14 72 05 8B 49 04 EB 03 83 C1 04 C6 04 01 00 5D C2 04 00 }
	condition:
		$1
}

rule file_1_170_1 {
	meta:
		name = "?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADDH@Z"
		size = 149
		altNames = "?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADDH@Z ?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADDH@Z"
	strings:
		$1 = { 55 8B EC 8B 55 14 56 8B 75 0C 57 C6 06 25 8D 46 01 F6 C2 20 74 04 C6 00 2B 40 F6 C2 10 74 04 C6 00 23 40 8A 4D 10 66 C7 00 2E 2A 83 C0 02 84 C9 74 03 88 08 40 8B CA BF 00 30 00 00 23 CF F6 C2 04 74 22 81 F9 00 20 00 00 74 22 3B CF 75 04 B1 41 EB 36 81 F9 00 10 00 00 0F 95 C1 8D 0C 4D 45 00 00 00 EB 24 81 F9 00 20 00 00 75 04 B1 66 EB 18 3B CF 75 04 B1 61 EB 10 81 F9 00 10 00 00 0F 95 C1 8D 0C 4D 65 00 00 00 88 08 C6 40 01 00 8B C6 5F 5E 5D C3 }
	condition:
		$1
}

rule file_1_171_1 {
	meta:
		name = "?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z"
		size = 770
		refs = "0003 __ehhandler$?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 0008 __EH_prolog3_GS 004b ??_C@_02MDKMJEGG@eE?$AA@ 0055 ??_C@_02OOPEBDOJ@pP?$AA@ 0079 _strcspn 0088 _localeconv 00aa ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 00b4 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00c3 ??1locale@std@@QAE@XZ 00d1 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 00e2 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 00f7 @_guard_check_icall@4 0113 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0130 ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0185 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 01a6 ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@IID@Z 020c ?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z 0248 ?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PBDI@Z 02ee ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 02fd __EH_epilog3_GS"
	strings:
		$1 = { 6A 6C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 24 8B 45 0C 8B 75 18 8B 7D 20 89 45 88 89 75 98 89 7D AC 89 4D 9C 85 C9 74 0F 8A 07 3C 2B 74 04 3C 2D 75 05 33 DB 43 EB 02 33 DB 8B 46 14 BA 00 30 00 00 23 C2 89 5D A8 3B C2 74 07 BA ?? ?? ?? ?? EB 25 8D 43 02 BA ?? ?? ?? ?? 3B C1 77 19 80 3C 1F 30 75 13 8A 4C 1F 01 80 F9 78 74 05 80 F9 58 75 05 8B D8 89 5D A8 52 57 E8 ?? ?? ?? ?? 89 45 8C 6A 2E 58 66 89 45 B4 E8 ?? ?? ?? ?? 8B 00 8A 00 88 45 B4 8D 45 B4 50 57 E8 ?? ?? ?? ?? 83 C4 10 89 45 B0 8D 45 90 8B CE 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 E8 ?? ?? ?? ?? 83 4D FC FF 8B F8 59 8D 4D 90 E8 ?? ?? ?? ?? 8B 75 9C 8D 4D D4 6A 00 56 E8 ?? ?? ?? ?? 6A 00 8D 4D D4 C7 45 FC 01 00 00 00 E8 ?? ?? ?? ?? 8B 55 AC 8B 0F 50 8D 04 16 8B 71 1C 8B CE 50 52 E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D 98 8D 45 A0 50 8B CF E8 ?? ?? ?? ?? 50 C6 45 FC 02 E8 ?? ?? ?? ?? 59 8B F0 C6 45 FC 01 8D 4D A0 89 75 AC E8 ?? ?? ?? ?? 8D 45 B8 8B CE 50 E8 ?? ?? ?? ?? 8B 06 C6 45 FC 03 8B 70 10 8B CE E8 ?? ?? ?? ?? 8B 4D AC FF D6 88 45 94 8B 45 9C 39 45 B0 74 28 8B 5D AC 8B 03 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 8B 75 B0 8D 4D D4 56 8A D8 E8 ?? ?? ?? ?? 88 18 8B 5D A8 EB 03 8B 75 8C 6A 00 8D 4D B8 E8 ?? ?? ?? ?? EB 2A 84 C0 7E 31 0F BE C8 8B C6 2B C3 3B C8 73 26 FF 75 94 2B F1 8D 4D D4 6A 01 56 E8 ?? ?? ?? ?? 8B 4D B0 8D 41 01 80 38 00 7E 05 8B C8 89 4D B0 8A 01 3C 7F 75 CB 8B 45 E8 33 C9 89 45 94 39 4F 24 7C 12 7F 05 39 4F 20 76 0B 8B 77 20 3B F0 76 04 2B F0 EB 02 8B F1 8B 47 14 25 C0 01 00 00 83 F8 40 0F 84 81 00 00 00 3D 00 01 00 00 74 35 8B 7D 08 8D 45 A0 56 FF 75 1C FF 75 14 FF 75 10 50 57 E8 ?? ?? ?? ?? 8B C8 83 C4 18 33 F6 8B 01 89 45 10 8B 41 04 8D 4D D4 53 56 89 45 14 E8 ?? ?? ?? ?? EB 52 53 51 8D 4D D4 E8 ?? ?? ?? ?? 8B 7D 08 50 FF 75 14 8D 45 A0 FF 75 10 50 57 E8 ?? ?? ?? ?? 8B C8 56 FF 75 1C 8B 01 89 45 10 8B 41 04 89 45 14 8D 45 A0 FF 71 04 FF 31 50 57 E8 ?? ?? ?? ?? 83 C4 30 33 F6 EB 21 53 51 8D 4D D4 E8 ?? ?? ?? ?? 8B 7D 08 50 FF 75 14 8D 45 A0 FF 75 10 50 57 E8 ?? ?? ?? ?? 83 C4 18 8B C8 8B 01 89 45 10 8B 41 04 8D 4D D4 89 45 14 8B 45 94 2B C3 50 53 E8 ?? ?? ?? ?? 50 FF 75 14 8D 45 A0 FF 75 10 50 57 E8 ?? ?? ?? ?? 8B 55 98 56 FF 75 1C 8B 08 8B 75 88 89 4D 10 8B 40 04 83 62 20 00 83 62 24 00 50 51 56 57 89 45 14 E8 ?? ?? ?? ?? 83 C4 30 8D 4D B8 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_176_1 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_200_2 {
	meta:
		name = "__ehhandler$?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_372_1 {
	meta:
		name = "__ehhandler$?overflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAEHH@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?overflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAEHH@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_381_1 {
	meta:
		name = "__ehhandler$?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_381_1 {
	meta:
		name = "__ehhandler$?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 84 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_186_1 {
	meta:
		name = "?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 104
		refs = "0003 __ehhandler$?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0044 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 005b ??1_Locinfo@std@@QAE@XZ 0063 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 47 39 1F 75 43 6A 08 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 43 C7 06 ?? ?? ?? ?? 83 66 04 00 EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 02 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_188_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_641_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_565_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_208_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_209_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_658_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_290_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$messages@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_582_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$messages@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_664_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$messages@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_293_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_667_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_670_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_296_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_673_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_597_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_194_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_620_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_623_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_175_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_626_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_629_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_313_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_650_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_653_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_189_1 {
	meta:
		name = "?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 102
		refs = "0003 __ehhandler$?_Getcat@?$ctype@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 0021 ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0048 ??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 0059 ??1_Locinfo@std@@QAE@XZ 0061 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 F6 8B DE 89 5D F0 85 FF 74 43 39 37 75 3F 6A 18 E8 ?? ?? ?? ?? 59 89 45 F0 89 75 FC 85 C0 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 8B 4D F0 43 56 50 E8 ?? ?? ?? ?? 8B F0 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 02 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_192_1 {
	meta:
		name = "?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 104
		refs = "0003 __ehhandler$?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0044 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 005b ??1_Locinfo@std@@QAE@XZ 0063 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 47 39 1F 75 43 6A 08 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 43 C7 06 ?? ?? ?? ?? 83 66 04 00 EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_697_1 {
	meta:
		name = "?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 104
		refs = "0003 __ehhandler$?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0044 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 005b ??1_Locinfo@std@@QAE@XZ 0063 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 47 39 1F 75 43 6A 08 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 43 C7 06 ?? ?? ?? ?? 83 66 04 00 EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_700_1 {
	meta:
		name = "?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 104
		refs = "0003 __ehhandler$?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0044 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 005b ??1_Locinfo@std@@QAE@XZ 0063 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 47 39 1F 75 43 6A 08 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 43 C7 06 ?? ?? ?? ?? 83 66 04 00 EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_195_1 {
	meta:
		name = "?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 104
		refs = "0003 __ehhandler$?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0044 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 005b ??1_Locinfo@std@@QAE@XZ 0063 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 47 39 1F 75 43 6A 08 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 43 C7 06 ?? ?? ?? ?? 83 66 04 00 EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_703_1 {
	meta:
		name = "?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 104
		refs = "0003 __ehhandler$?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0044 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 005b ??1_Locinfo@std@@QAE@XZ 0063 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 47 39 1F 75 43 6A 08 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 43 C7 06 ?? ?? ?? ?? 83 66 04 00 EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_706_1 {
	meta:
		name = "?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 104
		refs = "0003 __ehhandler$?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0044 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 005b ??1_Locinfo@std@@QAE@XZ 0063 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 47 39 1F 75 43 6A 08 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 43 C7 06 ?? ?? ?? ?? 83 66 04 00 EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_198_1 {
	meta:
		name = "?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 123
		refs = "0003 __ehhandler$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0056 ??_7?$numpunct@D@std@@6B@ 005b ?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 006e ??1_Locinfo@std@@QAE@XZ 0076 __EH_epilog3"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 5A 39 1F 75 56 6A 18 E8 ?? ?? ?? ?? 8B F0 59 89 75 EC 21 5D FC 85 F6 74 31 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D B8 E8 ?? ?? ?? ?? 83 66 04 00 43 89 5D F0 53 50 8B CE C7 45 FC 02 00 00 00 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D B8 E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_709_1 {
	meta:
		name = "?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 123
		refs = "0003 __ehhandler$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0056 ??_7?$numpunct@G@std@@6B@ 005b ?_Init@?$numpunct@G@std@@IAEXABV_Locinfo@2@_N@Z 006e ??1_Locinfo@std@@QAE@XZ 0076 __EH_epilog3"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 5A 39 1F 75 56 6A 18 E8 ?? ?? ?? ?? 8B F0 59 89 75 EC 21 5D FC 85 F6 74 31 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D B8 E8 ?? ?? ?? ?? 83 66 04 00 43 89 5D F0 53 50 8B CE C7 45 FC 02 00 00 00 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D B8 E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_714_1 {
	meta:
		name = "?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 123
		refs = "0003 __ehhandler$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0056 ??_7?$numpunct@_W@std@@6B@ 005b ?_Init@?$numpunct@_W@std@@IAEXABV_Locinfo@2@_N@Z 006e ??1_Locinfo@std@@QAE@XZ 0076 __EH_epilog3"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 5A 39 1F 75 56 6A 18 E8 ?? ?? ?? ?? 8B F0 59 89 75 EC 21 5D FC 85 F6 74 31 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D B8 E8 ?? ?? ?? ?? 83 66 04 00 43 89 5D F0 53 50 8B CE C7 45 FC 02 00 00 00 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D B8 E8 ?? ?? ?? ?? 6A 04 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_200_1 {
	meta:
		name = "__unwindfunclet$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
		size = 25
		refs = "0014 ??1_Locinfo@std@@QAE@XZ"
		altNames = "__unwindfunclet$?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1 __unwindfunclet$?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z$1"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8D 4D B8 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_202_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$numpunct@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_259_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@D$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_264_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@D$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_681_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@G$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_686_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@G$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_691_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@_W$00@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_696_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$moneypunct@_W$0A@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_713_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$numpunct@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_718_1 {
	meta:
		name = "__ehhandler$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$numpunct@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_268_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_643_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_647_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_231_2 {
	meta:
		name = "__ehhandler$?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_203_1 {
	meta:
		name = "?_Getctype@_Locinfo@std@@QBE?AU_Ctypevec@@XZ"
		size = 37
		refs = "000d __Getctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 F0 56 57 50 E8 ?? ?? ?? ?? 8B F0 8B 45 08 8B F8 59 A5 A5 A5 A5 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_204_1 {
	meta:
		name = "?_Getcvt@_Locinfo@std@@QBE?AU_Cvtvec@@XZ"
		size = 38
		refs = "000d __Getcvt"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8D 45 D4 56 57 50 E8 ?? ?? ?? ?? 59 6A 0B 8B F0 8B 45 08 59 8B F8 F3 A5 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_205_1 {
	meta:
		name = "?_Getfacet@locale@std@@QBEPBVfacet@12@I@Z"
		size = 61
		refs = "0026 ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ"
	strings:
		$1 = { 55 8B EC 8B 49 04 56 8B 75 08 57 33 FF 3B 71 0C 73 08 8B 41 08 8B 04 B0 EB 02 8B C7 85 C0 75 17 38 41 14 74 12 E8 ?? ?? ?? ?? 3B 70 0C 73 06 8B 40 08 8B 3C B0 8B C7 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_207_1 {
	meta:
		name = "?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 1579
		refs = "0006 __ehhandler$?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 000b __EH_prolog3_GS 0045 ?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 005b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0065 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0078 ??1locale@std@@QAE@XZ 0084 ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00ae ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00cb ?_Src@?1??_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AAVios_base@3@PAH@Z@4QBDB 00da @_guard_check_icall@4 00e9 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00f9 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ 0111 ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ 016e ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 01b3 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 01ea ??$_Find_elem@D@std@@YAIPADD@Z 0228 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 026f ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 02f4 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 03a3 _localeconv 0626 __EH_epilog3_GS"
	strings:
		$1 = { 68 88 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 18 8B 7D 0C 8B 5D 10 8B 4D 14 8B 46 14 8B 55 1C 25 00 30 00 00 89 7D 80 89 9D 74 FF FF FF 89 4D 98 89 55 8C 3D 00 30 00 00 75 15 52 56 51 53 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 E9 D4 05 00 00 8D 85 6C FF FF FF 8B CE 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 E8 ?? ?? ?? ?? 83 4D FC FF 59 8D 8D 6C FF FF FF 89 45 90 E8 ?? ?? ?? ?? 8B 4D 90 8D 45 A8 50 E8 ?? ?? ?? ?? 8D 85 78 FF FF FF C7 45 FC 01 00 00 00 50 8B CE 89 7D 9C C6 45 A4 00 C6 45 A6 00 E8 ?? ?? ?? ?? 50 C6 45 FC 02 E8 ?? ?? ?? ?? 59 8D 8D 78 FF FF FF C6 45 FC 01 8B F8 E8 ?? ?? ?? ?? 8B 0F 8D 45 E0 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 71 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 75 98 8B CB 56 E8 ?? ?? ?? ?? 84 C0 75 43 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EB 75 12 8B 45 80 C6 00 2B 8B CB 8D 78 01 E8 ?? ?? ?? ?? EB 20 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EA 75 08 8B 45 80 C6 00 2D EB D7 8B 7D 9C 8B 4D 8C 33 D2 33 C0 C6 07 30 89 BD 7C FF FF FF 47 52 81 39 00 CA 9A 3B 8D 4D A8 89 7D 9C 0F 95 C0 88 55 A7 48 89 55 94 25 DC 02 00 00 89 55 A0 83 C0 24 89 45 84 E8 ?? ?? ?? ?? 89 45 88 8A 08 80 F9 7F 0F 84 7D 01 00 00 84 C9 0F 8E 75 01 00 00 83 7D BC 00 75 06 C6 45 A5 00 EB 17 8B 45 90 8B 00 8B 70 10 8B CE E8 ?? ?? ?? ?? 8B 4D 90 FF D6 88 45 A5 6A 00 6A 01 8D 4D C4 E8 ?? ?? ?? ?? FF 75 98 8B CB C6 45 FC 03 33 F6 E8 ?? ?? ?? ?? 84 C0 0F 85 D4 00 00 00 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 88 45 9C 8D 45 E0 FF 75 9C 50 E8 ?? ?? ?? ?? 59 59 83 F8 0A 73 49 8B 4D 94 C6 45 A7 01 39 4D 84 7F 0D FF 45 A0 85 C0 74 1B C6 45 A6 01 EB 15 85 C0 75 04 85 C9 74 0D 8A 80 ?? ?? ?? ?? 88 07 47 41 89 4D 94 56 8D 4D C4 E8 ?? ?? ?? ?? 80 38 7F 74 43 56 8D 4D C4 E8 ?? ?? ?? ?? FE 00 EB 36 56 8D 4D C4 E8 ?? ?? ?? ?? 80 38 00 74 41 80 7D A5 00 74 3B 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 A5 75 26 6A 00 6A 01 8D 4D C4 E8 ?? ?? ?? ?? 46 8B CB E8 ?? ?? ?? ?? FF 75 98 8B CB E8 ?? ?? ?? ?? 84 C0 0F 84 42 FF FF FF 89 7D 9C 85 F6 74 0F 56 8D 4D C4 E8 ?? ?? ?? ?? 80 38 00 7E 46 46 8B 55 88 85 F6 74 42 80 3A 7F 74 3D 83 EE 01 74 12 56 8D 4D C4 E8 ?? ?? ?? ?? 8B 55 88 8A 0A 3A 08 75 22 85 F6 75 12 56 8D 4D C4 E8 ?? ?? ?? ?? 8B 55 88 8A 0A 3A 08 7C 0C 80 7A 01 00 7E C4 42 89 55 88 EB BE C6 45 A4 01 8D 4D C4 C6 45 FC 01 E8 ?? ?? ?? ?? 8B 75 98 EB 72 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 66 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 0F B6 43 05 50 8D 45 E0 50 E8 ?? ?? ?? ?? 59 59 83 F8 0A 73 41 8B 4D 94 39 4D 84 7F 0D FF 45 A0 85 C0 74 1B C6 45 A6 01 EB 15 85 C0 75 04 85 C9 74 0D 8A 80 ?? ?? ?? ?? 88 07 47 41 89 4D 94 8B CB C6 45 A7 01 E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 9D 89 7D 9C 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 4E 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8B 45 90 8A 5B 05 8B 00 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B 4D 90 FF D6 3A D8 75 1E E8 ?? ?? ?? ?? 8B 9D 74 FF FF FF 8B CB 8B 00 8A 00 88 07 47 89 7D 9C E8 ?? ?? ?? ?? EB 06 8B 9D 74 FF FF FF 8B 75 98 8B 45 8C 81 38 00 CA 9A 3B 0F 84 A9 00 00 00 83 7D 94 00 0F 85 9F 00 00 00 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 36 8B 7D A0 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 E0 75 18 8B CB C6 45 A7 01 4F E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 D3 89 7D A0 8B 7D 9C 8B 45 A0 85 C0 79 56 C6 07 30 47 40 89 45 A0 EB 4C 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 0F B6 43 05 50 8D 45 E0 50 E8 ?? ?? ?? ?? 59 59 83 F8 0A 73 36 8B 4D 94 3B 4D 84 7D 0F 8A 80 ?? ?? ?? ?? 88 07 47 41 89 4D 94 EB 08 85 C0 74 04 C6 45 A6 01 8B CB C6 45 A7 01 E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 A8 80 7D A6 00 74 42 8D 77 FF 3B B5 7C FF FF FF 74 2E E8 ?? ?? ?? ?? 8A 0E 8B 00 3A 08 74 08 80 F9 39 75 10 C6 06 30 8B 85 7C FF FF FF 4E 3B F0 75 E0 EB 08 FE 06 8B 85 7C FF FF FF 3B F0 75 06 FF 45 A0 C6 06 31 8B 75 98 8A 45 A7 84 C0 0F 84 2A 01 00 00 56 8B CB E8 ?? ?? ?? ?? 84 C0 0F 85 17 01 00 00 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 ED 74 19 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EC 0F 85 EA 00 00 00 C6 07 65 8B CB 47 E8 ?? ?? ?? ?? 83 65 8C 00 8B CB 56 C6 45 A7 00 E8 ?? ?? ?? ?? 84 C0 75 39 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EB 75 05 C6 07 2B EB 18 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EA 75 0B C6 07 2D 8B CB 47 E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 37 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 E0 75 17 8B CB C6 45 A7 01 E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 D4 8A 4D A7 84 C9 74 04 C6 07 30 47 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 43 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 0F B6 43 05 50 8D 45 E0 50 E8 ?? ?? ?? ?? 59 59 83 F8 0A 73 22 8B 4D 8C 83 F9 08 7D 0D 8A 80 ?? ?? ?? ?? 88 07 47 41 89 4D 8C 8B CB C6 45 A7 01 E8 ?? ?? ?? ?? EB B1 8A 45 A7 80 7D A4 00 75 04 84 C0 75 03 8B 7D 80 8D 4D A8 C6 07 00 E8 ?? ?? ?? ?? 8B 45 A0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_212_1 {
	meta:
		name = "__ehhandler$?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 68 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_213_1 {
	meta:
		name = "?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 1603
		refs = "0006 __ehhandler$?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 000b __EH_prolog3_GS 003a ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0044 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 005c ??1locale@std@@QAE@XZ 0067 ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0086 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00a3 ?_Src@?1??_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AAVios_base@3@PAH@Z@4QBDB 00b2 @_guard_check_icall@4 00cb ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00db ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ 010e ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ 01b7 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 0205 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 023c ??$_Find_elem@D@std@@YAIPADD@Z 0275 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 02bc ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 0350 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0413 _localeconv 063e __EH_epilog3_GS"
	strings:
		$1 = { 68 94 00 00 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 0C 8B 75 18 8B CE 8B 5D 10 89 85 74 FF FF FF 8B 45 14 89 45 84 8B 45 1C 89 85 68 FF FF FF 8D 85 60 FF FF FF 50 89 5D 80 E8 ?? ?? ?? ?? 83 65 FC 00 50 E8 ?? ?? ?? ?? 83 4D FC FF 8B F8 59 8D 8D 60 FF FF FF 89 BD 78 FF FF FF E8 ?? ?? ?? ?? 8D 45 98 8B CF 50 E8 ?? ?? ?? ?? 8D 85 6C FF FF FF C7 45 FC 01 00 00 00 50 8B CE E8 ?? ?? ?? ?? 50 C6 45 FC 02 E8 ?? ?? ?? ?? 59 8D 8D 6C FF FF FF C6 45 FC 01 8B F8 E8 ?? ?? ?? ?? 8B 0F 8D 45 D0 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 71 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 75 84 8B CB 8B BD 74 FF FF FF 56 C6 45 95 00 E8 ?? ?? ?? ?? 84 C0 75 3F 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 E7 75 07 8B C7 C6 00 2B EB 1A 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 E6 75 0F 8B C7 C6 00 2D 8B CB 8D 78 01 E8 ?? ?? ?? ?? 33 C0 66 C7 07 30 78 83 C7 02 88 45 97 56 8B CB 89 7D 88 89 45 8C 89 45 90 E8 ?? ?? ?? ?? 84 C0 75 5D 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 D0 75 49 8B CB E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 32 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 E9 74 15 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 E8 75 09 8B CB E8 ?? ?? ?? ?? EB 04 C6 45 97 01 8B 8D 68 FF FF FF 33 C0 6A 00 81 39 00 CA 9A 3B 8D 4D 98 0F 95 C0 48 25 DC 02 00 00 83 C0 24 89 85 70 FF FF FF E8 ?? ?? ?? ?? 89 85 7C FF FF FF 8A 08 80 F9 7F 0F 84 8D 01 00 00 84 C9 0F 8E 85 01 00 00 83 7D AC 00 75 06 C6 45 96 00 EB 1D 8B 85 78 FF FF FF 8B 00 8B 70 10 8B CE E8 ?? ?? ?? ?? 8B 8D 78 FF FF FF FF D6 88 45 96 6A 00 6A 01 8D 4D B4 E8 ?? ?? ?? ?? FF 75 84 8B CB C6 45 FC 03 33 F6 E8 ?? ?? ?? ?? 84 C0 0F 85 CF 00 00 00 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 88 45 88 8D 45 D0 FF 75 88 50 E8 ?? ?? ?? ?? 59 59 83 F8 16 73 44 8B 4D 8C C6 45 97 01 39 8D 70 FF FF FF 7F 05 FF 45 90 EB 15 85 C0 75 04 85 C9 74 0D 8A 80 ?? ?? ?? ?? 88 07 47 41 89 4D 8C 56 8D 4D B4 E8 ?? ?? ?? ?? 80 38 7F 74 43 56 8D 4D B4 E8 ?? ?? ?? ?? FE 00 EB 36 56 8D 4D B4 E8 ?? ?? ?? ?? 80 38 00 74 41 80 7D 96 00 74 3B 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 96 75 26 6A 00 6A 01 8D 4D B4 E8 ?? ?? ?? ?? 46 8B CB E8 ?? ?? ?? ?? FF 75 84 8B CB E8 ?? ?? ?? ?? 84 C0 0F 84 47 FF FF FF 89 7D 88 85 F6 74 0F 56 8D 4D B4 E8 ?? ?? ?? ?? 80 38 00 7E 55 46 8B 95 7C FF FF FF 85 F6 74 4E 80 3A 7F 74 49 83 EE 01 74 15 56 8D 4D B4 E8 ?? ?? ?? ?? 8B 95 7C FF FF FF 8A 0A 3A 08 75 2B 85 F6 75 15 56 8D 4D B4 E8 ?? ?? ?? ?? 8B 95 7C FF FF FF 8A 0A 3A 08 7C 12 8D 42 01 80 38 00 7E BC 8B D0 89 95 7C FF FF FF EB B2 C6 45 95 01 8D 4D B4 C6 45 FC 01 E8 ?? ?? ?? ?? 8B 75 84 EB 6D 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 61 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 0F B6 43 05 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 59 83 F8 16 73 3C 8B 4D 8C 39 8D 70 FF FF FF 7F 05 FF 45 90 EB 15 85 C0 75 04 85 C9 74 0D 8A 80 ?? ?? ?? ?? 88 07 47 41 89 4D 8C 8B CB C6 45 97 01 E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 A2 89 7D 88 80 7D 97 00 74 0D 83 7D 8C 00 75 07 C6 07 30 47 89 7D 88 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 4E 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8B 85 78 FF FF FF 8A 5B 05 8B 00 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B 8D 78 FF FF FF FF D6 3A D8 75 1B E8 ?? ?? ?? ?? 8B 5D 80 8B CB 8B 00 8A 00 88 07 47 89 7D 88 E8 ?? ?? ?? ?? EB 03 8B 5D 80 8B 75 84 83 7D 8C 00 0F 85 98 00 00 00 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 36 8B 7D 90 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 D0 75 18 8B CB C6 45 97 01 4F E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 D3 89 7D 90 8B 7D 88 8B 45 90 85 C0 79 4F C6 07 30 47 40 89 45 90 EB 45 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 0F B6 43 05 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 59 83 F8 16 73 2F 8B 4D 8C 3B 8D 70 FF FF FF 7D 0D 8A 80 ?? ?? ?? ?? 88 07 47 41 89 4D 8C 8B CB C6 45 97 01 E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 AF 8A 45 97 84 C0 0F 84 29 01 00 00 56 8B CB E8 ?? ?? ?? ?? 84 C0 0F 85 16 01 00 00 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EB 74 19 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EA 0F 85 E9 00 00 00 C6 07 70 8B CB 47 E8 ?? ?? ?? ?? 83 65 80 00 8B CB 56 C6 45 97 00 E8 ?? ?? ?? ?? 84 C0 75 39 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 E7 75 05 C6 07 2B EB 18 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 E6 75 0B C6 07 2D 8B CB 47 E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 36 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 D0 75 17 8B CB C6 45 97 01 E8 ?? ?? ?? ?? 56 8B CB E8 ?? ?? ?? ?? 84 C0 74 D4 80 7D 97 00 74 04 C6 07 30 47 56 8B CB E8 ?? ?? ?? ?? 84 C0 75 43 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 0F B6 43 05 50 8D 45 D0 50 E8 ?? ?? ?? ?? 59 59 83 F8 16 73 22 8B 4D 80 83 F9 08 7D 0D 8A 80 ?? ?? ?? ?? 88 07 47 41 89 4D 80 8B CB C6 45 97 01 E8 ?? ?? ?? ?? EB B1 8A 45 97 80 7D 95 00 75 04 84 C0 75 06 8B BD 74 FF FF FF 8B 8D 68 FF FF FF 8B 45 90 C6 07 00 89 01 8D 4D 98 E8 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_218_1 {
	meta:
		name = "__ehhandler$?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 5C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_666_2 {
	meta:
		name = "__ehhandler$?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 5C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_672_2 {
	meta:
		name = "__ehhandler$?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 5C FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_219_1 {
	meta:
		name = "?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z"
		size = 820
		refs = "0003 __ehhandler$?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0008 __EH_prolog3_GS 0023 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0031 ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 004d @_guard_check_icall@4 005c ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0068 ?_Src@?1??_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1HABVlocale@3@@Z@4QBDB 008d ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 009d ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ 00cf ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ 01c8 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0207 ??$_Find_elem@D@std@@YAIPADD@Z 0237 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 027f ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 02c2 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 0320 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 032f __EH_epilog3_GS"
	strings:
		$1 = { 6A 70 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 0C 8B 5D 10 89 45 84 8B 45 14 89 45 90 8B 45 1C 50 89 45 88 E8 ?? ?? ?? ?? 8B F8 8D 45 9C 59 50 8B CF E8 ?? ?? ?? ?? 83 65 FC 00 83 7D B0 00 75 06 C6 45 9A 00 EB 13 8B 07 8B 70 10 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 88 45 9A FF 75 88 E8 ?? ?? ?? ?? 8B F8 8D 45 D4 59 50 68 ?? ?? ?? ?? 8B 0F 68 ?? ?? ?? ?? 8B 71 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 FF 75 90 8B 75 84 8B CB 89 75 94 E8 ?? ?? ?? ?? 84 C0 75 3E 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EB 75 05 C6 06 2B EB 18 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EA 75 10 C6 06 2D 8D 46 01 8B CB 89 45 94 E8 ?? ?? ?? ?? 8B 75 18 6A 0A 81 E6 00 0E 00 00 5F 89 7D 88 81 FE 00 04 00 00 75 05 6A 08 5E EB 12 81 FE 00 08 00 00 75 04 6A 10 EB F1 F7 DE 1B F6 23 F7 FF 75 90 32 C0 89 75 18 8B CB 88 45 9B 88 45 8C 88 45 99 E8 ?? ?? ?? ?? 84 C0 0F 85 84 00 00 00 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 D4 75 70 B0 01 8B CB 88 45 9B 88 45 8C E8 ?? ?? ?? ?? FF 75 90 8B CB E8 ?? ?? ?? ?? 84 C0 75 49 38 43 04 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 ED 74 15 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 8A 43 05 3A 45 EC 75 20 85 F6 74 05 83 FE 10 75 17 6A 10 32 C0 8B CB 5E 89 75 18 88 45 9B 88 45 8C E8 ?? ?? ?? ?? EB 12 85 F6 75 0A 6A 08 5E 89 75 18 85 F6 74 16 3B F7 74 12 33 C0 83 FE 08 0F 95 C0 48 83 E0 F2 83 C0 16 89 45 88 FF 75 8C 8D 4D B8 6A 01 E8 ?? ?? ?? ?? 8B 45 84 8B CB FF 75 90 83 C0 1F C6 45 FC 01 33 FF 89 45 8C E8 ?? ?? ?? ?? 84 C0 0F 85 CF 00 00 00 8B 75 94 80 7B 04 00 75 07 8B CB E8 ?? ?? ?? ?? 0F B6 43 05 50 8D 45 D4 50 E8 ?? ?? ?? ?? 59 59 3B 45 88 73 3B 80 7D 99 00 8A 80 ?? ?? ?? ?? 88 06 75 04 3C 30 74 0A 3B 75 8C 73 05 46 C6 45 99 01 57 8D 4D B8 C6 45 9B 01 E8 ?? ?? ?? ?? 80 38 7F 74 44 57 8D 4D B8 E8 ?? ?? ?? ?? FE 00 EB 37 57 8D 4D B8 E8 ?? ?? ?? ?? 80 38 00 74 42 8A 45 9A 84 C0 74 3B 80 7B 04 00 75 0A 8B CB E8 ?? ?? ?? ?? 8A 45 9A 38 43 05 75 26 6A 00 6A 01 8D 4D B8 E8 ?? ?? ?? ?? 47 8B CB E8 ?? ?? ?? ?? FF 75 90 8B CB E8 ?? ?? ?? ?? 84 C0 0F 84 53 FF FF FF 89 75 94 8B 75 18 85 FF 74 15 57 8D 4D B8 E8 ?? ?? ?? ?? 80 38 00 7E 03 47 EB 04 C6 45 9B 00 6A 00 8D 4D 9C E8 ?? ?? ?? ?? 80 7D 9B 00 8B D8 74 48 85 FF 74 35 80 3B 7F 74 30 83 EF 01 74 0F 57 8D 4D B8 E8 ?? ?? ?? ?? 8A 0B 3A 08 75 2B 85 FF 75 0F 57 8D 4D B8 E8 ?? ?? ?? ?? 8A 0B 3A 08 7C 18 80 7B 01 00 7E CA 43 EB C7 80 7D 99 00 8B 45 94 75 09 C6 00 30 40 EB 03 8B 45 84 8D 4D B8 C6 00 00 E8 ?? ?? ?? ?? 8D 4D 9C E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_222_1 {
	meta:
		name = "__ehhandler$?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 80 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_226_1 {
	meta:
		name = "?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBE_JXZ"
		size = 18
		altNames = "?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBE_JXZ ?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBE_JXZ"
	strings:
		$1 = { 8B 41 1C 33 D2 39 10 74 05 8B 41 2C 8B 10 8B C2 99 C3 }
	condition:
		$1
}

rule file_1_227_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAEPADXZ"
		size = 16
	strings:
		$1 = { 8B 41 2C FF 08 8B 51 1C 8B 02 8D 48 01 89 0A C3 }
	condition:
		$1
}

rule file_1_228_1 {
	meta:
		name = "?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z"
		size = 84
		refs = "0016 ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXII@Z 0034 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0040 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 004f ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 83 FE FE 77 42 39 71 18 73 0B FF 71 14 56 E8 ?? ?? ?? ?? EB 28 80 7D 0C 00 74 18 83 FE 10 73 13 8B 41 14 3B F0 73 02 8B C6 50 6A 01 E8 ?? ?? ?? ?? EB 0A 85 F6 75 08 56 E8 ?? ?? ?? ?? 85 F6 0F 95 C0 5E 5D C2 08 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_229_1 {
	meta:
		name = "?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z"
		size = 117
		altNames = "?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 14 56 8B 75 0C 57 C6 06 25 8D 46 01 F6 C1 20 74 04 C6 00 2B 40 F6 C1 08 74 04 C6 00 23 40 8B 7D 10 8A 17 80 FA 4C 74 04 88 10 EB 0B 66 C7 00 49 36 83 C0 02 C6 00 34 8B D1 81 E2 00 0E 00 00 81 FA 00 04 00 00 75 04 B1 6F EB 18 81 FA 00 08 00 00 74 05 8A 4F 01 EB 0B C0 E1 03 F6 D1 80 E1 20 80 C9 58 88 48 01 C6 40 02 00 8B C6 5F 5E 5D C3 }
	condition:
		$1
}

rule file_1_230_1 {
	meta:
		name = "?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AAEXXZ"
		size = 34
		refs = "000a ?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHXZ"
	strings:
		$1 = { 56 8B F1 8B 0E 85 C9 74 10 E8 ?? ?? ?? ?? 83 F8 FF 74 06 C6 46 04 00 5E C3 83 26 00 C6 46 04 01 5E C3 }
	condition:
		$1
}

rule file_1_233_1 {
	meta:
		name = "?_Init@?$ctype@D@std@@IAEXABV_Locinfo@2@@Z"
		size = 37
		refs = "000f __Getctype"
	strings:
		$1 = { 55 8B EC 83 EC 10 8D 45 F0 56 57 50 8B F9 E8 ?? ?? ?? ?? 83 C7 08 8B F0 59 A5 A5 A5 A5 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_236_1 {
	meta:
		name = "?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 176
		refs = "0003 __ehhandler$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 0008 __EH_prolog3_catch 0012 _localeconv 001d __Getcvt 0039 ??_C@_00CNPNBAHC@?$AA@ 0057 ??$_Maklocstr@D@std@@YAPADPBDPADABU_Cvtvec@@@Z 0067 ??_C@_05LAPONLG@false?$AA@ 007c ??_C@_04LOAJBDKD@true?$AA@ 0098 __EH_epilog3"
	strings:
		$1 = { 6A 64 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 E8 E8 ?? ?? ?? ?? 8B D8 8D 45 BC 50 E8 ?? ?? ?? ?? 33 FF 80 7D 0C 00 59 89 7E 08 89 7E 10 89 7E 14 89 7D FC 74 09 C7 45 EC ?? ?? ?? ?? EB 06 8B 43 08 89 45 EC 8D 45 90 50 E8 ?? ?? ?? ?? 8D 45 BC 50 57 FF 75 EC E8 ?? ?? ?? ?? 83 C4 10 89 46 08 8D 45 BC 50 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 46 10 8D 45 BC 50 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 89 46 14 80 7D 0C 00 74 0E 66 C7 46 0C 2E 2C E8 ?? ?? ?? ?? C2 08 00 8B 03 8A 00 88 46 0C 8B 43 04 8A 00 88 46 0D EB E7 }
	condition:
		$1
}

rule file_1_237_1 {
	meta:
		name = "__catch$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z$0"
		size = 18
		refs = "0004 ?_Tidy@?$numpunct@D@std@@AAEXXZ 000d __CxxThrowException@8"
	strings:
		$1 = { 8B 4D E8 E8 ?? ?? ?? ?? 33 FF 57 57 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_238_1 {
	meta:
		name = "__ehhandler$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 8C 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_240_1 {
	meta:
		name = "?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NPBD@Z"
		size = 60
	strings:
		$1 = { 55 8B EC 8B 55 08 8B C1 85 D2 74 2A 83 78 18 10 8D 48 04 56 72 04 8B 31 EB 02 8B F1 3B D6 5E 72 15 83 78 18 10 72 02 8B 09 8B 40 14 03 C1 3B C2 76 04 B0 01 EB 02 32 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_1_241_1 {
	meta:
		name = "?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z"
		size = 677
		refs = "0003 __ehhandler$?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0008 __EH_prolog3_GS 006c ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0076 ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 0085 ??1locale@std@@QAE@XZ 0090 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 00a1 ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAADI@Z 00b6 @_guard_check_icall@4 00d2 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 00ef ?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00fd ??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEABDI@Z 014c ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@IID@Z 01af ?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z 01eb ?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PBDI@Z 0291 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 02a0 __EH_epilog3_GS"
	strings:
		$1 = { 6A 5C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 24 8B 45 0C 8B 55 18 8B 4D 20 89 45 98 89 55 B0 89 4D B4 89 75 AC 85 F6 74 0F 8A 01 3C 2B 74 04 3C 2D 75 05 33 DB 43 EB 02 33 DB 8B 42 14 25 00 0E 00 00 3D 00 08 00 00 75 1D 8D 43 02 3B C6 77 16 80 3C 19 30 75 10 8A 4C 19 01 80 F9 78 74 05 80 F9 58 75 02 8B D8 8D 45 9C 8B CA 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 E8 ?? ?? ?? ?? 83 4D FC FF 8B F8 59 8D 4D 9C E8 ?? ?? ?? ?? 6A 00 56 8D 4D D4 E8 ?? ?? ?? ?? 6A 00 8D 4D D4 C7 45 FC 01 00 00 00 E8 ?? ?? ?? ?? 8B 55 B4 8B 0F 50 8D 04 16 8B 71 1C 8B CE 50 52 E8 ?? ?? ?? ?? 8B CF FF D6 8B 7D B0 8D 45 A4 50 8B CF E8 ?? ?? ?? ?? 50 C6 45 FC 02 E8 ?? ?? ?? ?? 59 8B F0 C6 45 FC 01 8D 4D A4 89 75 A0 E8 ?? ?? ?? ?? 8D 45 B8 8B CE 50 E8 ?? ?? ?? ?? 6A 00 8D 4D B8 C6 45 FC 03 E8 ?? ?? ?? ?? 89 45 B4 8A 00 3C 7F 74 59 84 C0 7E 55 8B 06 8B 70 10 8B CE E8 ?? ?? ?? ?? 8B 4D A0 FF D6 88 45 A0 8B 45 B4 8A 00 3C 7F 74 38 8B 75 AC 8B 7D B4 84 C0 7E 2B 0F BE C8 8B C6 2B C3 3B C8 73 20 FF 75 A0 2B F1 8D 4D D4 6A 01 56 E8 ?? ?? ?? ?? 8D 47 01 80 38 00 7E 02 8B F8 8A 07 3C 7F 75 D1 8B 7D B0 8B 45 E8 33 C9 89 45 AC 39 4F 24 7C 12 7F 05 39 4F 20 76 0B 8B 77 20 3B F0 76 04 2B F0 EB 02 8B F1 8B 47 14 25 C0 01 00 00 83 F8 40 0F 84 81 00 00 00 3D 00 01 00 00 74 35 8B 7D 08 8D 45 A4 56 FF 75 1C FF 75 14 FF 75 10 50 57 E8 ?? ?? ?? ?? 8B C8 83 C4 18 33 F6 8B 01 89 45 10 8B 41 04 8D 4D D4 53 56 89 45 14 E8 ?? ?? ?? ?? EB 52 53 51 8D 4D D4 E8 ?? ?? ?? ?? 8B 7D 08 50 FF 75 14 8D 45 A4 FF 75 10 50 57 E8 ?? ?? ?? ?? 8B C8 56 FF 75 1C 8B 01 89 45 10 8B 41 04 89 45 14 8D 45 A4 FF 71 04 FF 31 50 57 E8 ?? ?? ?? ?? 83 C4 30 33 F6 EB 21 53 51 8D 4D D4 E8 ?? ?? ?? ?? 8B 7D 08 50 FF 75 14 8D 45 A4 FF 75 10 50 57 E8 ?? ?? ?? ?? 83 C4 18 8B C8 8B 01 89 45 10 8B 41 04 8D 4D D4 89 45 14 8B 45 AC 2B C3 50 53 E8 ?? ?? ?? ?? 50 FF 75 14 8D 45 A4 FF 75 10 50 57 E8 ?? ?? ?? ?? 8B 55 B0 56 FF 75 1C 8B 08 8B 75 98 89 4D 10 8B 40 04 83 62 20 00 83 62 24 00 50 51 56 57 89 45 14 E8 ?? ?? ?? ?? 83 C4 30 8D 4D B8 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_246_1 {
	meta:
		name = "__ehhandler$?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_155_2 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_529_2 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_535_2 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_242_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$collate@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Getcat@?$collate@D@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_569_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Getcat@?$collate@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_573_2 {
	meta:
		name = "__ehhandler$?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Getcat@?$collate@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_871_1 {
	meta:
		name = "__ehhandler$?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_877_1 {
	meta:
		name = "__ehhandler$?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_412_1 {
	meta:
		name = "__ehhandler$?uflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?uflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_413_1 {
	meta:
		name = "__ehhandler$?uflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?uflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 94 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_247_1 {
	meta:
		name = "?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
		size = 194
		refs = "0003 __ehhandler$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 0008 __EH_prolog3 0012 ??0_Lockit@std@@QAE@H@Z 003a __realloc_base 0045 ?_Xbad_alloc@std@@YAXXZ 006b @_guard_check_icall@4 00b8 ??1_Lockit@std@@QAE@XZ 00bd __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 7D 08 83 65 FC 00 8B 5D 10 39 5F 0C 77 3B 8D 73 01 83 FE 28 73 03 6A 28 5E 8B C6 C1 E0 02 50 FF 77 08 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 E8 ?? ?? ?? ?? 89 47 08 EB 0D 8B 4F 0C 8B 47 08 83 24 88 00 FF 47 0C 39 77 0C 72 EE 8B 4D 0C 8B 01 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B 4D 0C FF D6 8B 47 08 8B 04 98 89 45 F0 85 C0 74 2A 8B 00 8B 70 08 8B CE E8 ?? ?? ?? ?? 8B 4D F0 FF D6 89 45 F0 85 C0 74 12 8B 08 6A 01 8B 31 8B CE E8 ?? ?? ?? ?? 8B 4D F0 FF D6 8B 47 08 8B 4D 0C 89 0C 98 8D 4D EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_249_1 {
	meta:
		name = "__ehhandler$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_3_1 {
	meta:
		name = "__ehhandler$??$?0AAPAUEHExceptionRecord@@_N@?$_Ref_count_obj@V__ExceptionPtr@@@std@@QAE@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAPAUEHExceptionRecord@@_N@?$_Ref_count_obj@V__ExceptionPtr@@@std@@QAE@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_35_1 {
	meta:
		name = "__ehhandler$??$make_shared@V__ExceptionPtr@@AAPAUEHExceptionRecord@@_N@std@@YA?AV?$shared_ptr@V__ExceptionPtr@@@0@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$make_shared@V__ExceptionPtr@@AAPAUEHExceptionRecord@@_N@std@@YA?AV?$shared_ptr@V__ExceptionPtr@@@0@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_57_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_43_2 {
	meta:
		name = "__ehhandler$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_57_1 {
	meta:
		name = "__ehhandler$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_43_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_43_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_43_2 {
	meta:
		name = "__ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_359_1 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_776_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_779_2 {
	meta:
		name = "__ehhandler$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IAEXABV_Locinfo@2@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_41_1 {
	meta:
		name = "__ehhandler$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_45_2 {
	meta:
		name = "__ehhandler$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_326_2 {
	meta:
		name = "__ehhandler$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_179_1 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_119_149_2 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_149_2 {
	meta:
		name = "__ehhandler$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEAAV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_390_1 {
	meta:
		name = "__ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?global@locale@std@@SA?AV12@ABV12@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_413_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_380_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_380_2 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_250_1 {
	meta:
		name = "?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z"
		size = 181
		refs = "0003 __ehhandler$?_Locimp_ctor@_Locimp@locale@std@@CAXPAV123@ABV123@@Z 0008 __EH_prolog3 0011 ?_Clocptr@_Locimp@locale@std@@0PAV123@A 0018 ??_C@_01GFHCPBMG@C?$AA@ 0020 ??0_Locinfo@std@@QAE@PBD@Z 0034 ?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 003f ??1_Locinfo@std@@QAE@XZ 004b ??0_Lockit@std@@QAE@H@Z 0065 __malloc_base 0072 ?_Xbad_alloc@std@@YAXXZ 0097 @_guard_check_icall@4 00ab ??1_Lockit@std@@QAE@XZ 00b0 __EH_epilog3"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 0C 3B 35 ?? ?? ?? ?? 75 2E 68 ?? ?? ?? ?? 8D 4D B8 E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 B8 6A 00 FF 75 08 6A 3F 50 E8 ?? ?? ?? ?? 83 C4 10 8D 4D B8 E8 ?? ?? ?? ?? EB 6A 6A 00 8D 4D EC E8 ?? ?? ?? ?? 8B 5D 08 C7 45 FC 01 00 00 00 8B 43 0C 85 C0 74 47 C1 E0 02 50 E8 ?? ?? ?? ?? 89 43 08 59 85 C0 75 05 E8 ?? ?? ?? ?? 8B 7B 0C EB 28 8B 46 08 4F 8B 0C B8 8B 43 08 89 4D F0 89 0C B8 85 C9 74 14 8B 01 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B 4D F0 FF D6 8B 75 0C 85 FF 75 D4 8D 4D EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_254_1 {
	meta:
		name = "?_Locinfo_Addcats@_Locinfo@std@@SAAAV12@PAV12@HPBD@Z"
		size = 148
		refs = "0039 _setlocale 005a ??_C@_01NBENCBCI@?$CK?$AA@ 007f ??4?$_Yarn@D@std@@QAEAAV01@PBD@Z 008a ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@ 008f ?_Xruntime_error@std@@YAXPBD@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 10 57 85 F6 74 7D 80 3E 2A 75 06 80 7E 01 00 74 3F 53 8B 5D 0C 85 DB 75 03 53 EB 24 83 FB 3F 74 1E 33 FF 33 C0 8B CF 40 D3 E0 D1 F8 85 C3 74 09 56 57 E8 ?? ?? ?? ?? 59 59 47 83 FF 05 7E E4 56 6A 00 E8 ?? ?? ?? ?? 59 59 8B C8 5B 85 C9 75 0A 8B 75 08 68 ?? ?? ?? ?? EB 1B 8B 75 08 8B 56 2C 85 D2 75 03 8D 56 30 80 3A 2A 75 08 0F B6 52 01 84 D2 74 09 51 8D 4E 2C E8 ?? ?? ?? ?? 5F 8B C6 5E 5D C3 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_255_1 {
	meta:
		name = "?_Locinfo_ctor@_Locinfo@std@@SAXPAV12@HPBD@Z"
		size = 54
		refs = "0008 _setlocale 0013 ??_C@_00CNPNBAHC@?$AA@ 0020 ??4?$_Yarn@D@std@@QAEAAV01@PBD@Z 002c ?_Locinfo_Addcats@_Locinfo@std@@SAAAV12@PAV12@HPBD@Z"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 B8 ?? ?? ?? ?? 56 8B 75 08 50 8D 4E 24 E8 ?? ?? ?? ?? FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 5E 5D C3 }
	condition:
		$1
}

rule file_1_256_1 {
	meta:
		name = "?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 583
		refs = "0003 __ehhandler$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 0008 __EH_prolog3 0028 ??2@YAPAXI@Z 003b ??0?$ctype@D@std@@QAE@ABV_Locinfo@1@I@Z 0046 ?id@?$ctype@D@std@@2V0locale@2@A 004b ??Bid@locale@std@@QAEIXZ 0053 ?_Locimp_Addfac@_Locimp@locale@std@@CAXPAV123@PAVfacet@23@I@Z 006a ??$use_facet@V?$ctype@D@std@@@std@@YAABV?$ctype@D@0@ABVlocale@0@@Z 00a2 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 00ab ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 00d5 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 00de ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0102 ??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 011f ??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAABV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@ABVlocale@0@@Z 0160 ??_7?$numpunct@D@std@@6B@ 0165 ?_Init@?$numpunct@D@std@@IAEXABV_Locinfo@2@_N@Z 0172 ?id@?$numpunct@D@std@@2V0locale@2@A 0196 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 01c5 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 01ce ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 01f2 ??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 020b ?_Makexloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0216 ?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0222 ?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 023b ??4?$_Yarn@D@std@@QAEAAV01@PBD@Z 0242 __EH_epilog3"
	strings:
		$1 = { 6A 0C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 EC 00 8B 45 0C 8B 5D 14 83 E0 02 8B 7D 10 89 45 EC 74 58 85 DB 75 37 6A 18 E8 ?? ?? ?? ?? 89 45 F0 59 85 C0 74 0F 53 FF 75 08 8B C8 E8 ?? ?? ?? ?? 8B F0 EB 02 33 F6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 83 C4 0C EB 1D B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 56 50 57 E8 ?? ?? ?? ?? 83 C4 10 8B 45 0C 83 E0 08 89 45 F0 0F 84 A9 00 00 00 85 DB 75 68 6A 08 E8 ?? ?? ?? ?? 8B F0 89 75 E8 59 85 F6 74 0B 21 5E 04 C7 06 ?? ?? ?? ?? EB 02 33 F6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 8B F0 83 C4 10 89 75 E8 85 F6 74 0C 83 66 04 00 C7 06 ?? ?? ?? ?? EB 02 33 F6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 83 C4 0C EB 3A B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 56 50 57 E8 ?? ?? ?? ?? 83 C4 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 56 50 57 E8 ?? ?? ?? ?? 83 C4 10 8B 45 F0 85 C0 74 70 85 DB 75 4F 6A 18 E8 ?? ?? ?? ?? 8B F0 59 89 75 E8 C7 45 FC 07 00 00 00 85 F6 74 1A 21 5E 04 53 FF 75 08 8B CE C6 45 FC 08 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 F6 83 4D FC FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 83 C4 0C EB 1D B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 56 50 57 E8 ?? ?? ?? ?? 83 C4 10 83 7D EC 00 74 56 85 DB 75 35 6A 08 E8 ?? ?? ?? ?? 8B F0 89 75 E8 59 85 F6 74 0B 21 5E 04 C7 06 ?? ?? ?? ?? EB 02 33 F6 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 56 57 E8 ?? ?? ?? ?? 83 C4 0C EB 1D B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 56 50 57 E8 ?? ?? ?? ?? 83 C4 10 8B 75 08 53 57 FF 75 0C 56 E8 ?? ?? ?? ?? 53 57 FF 75 0C 56 E8 ?? ?? ?? ?? 53 8B 5D 0C 57 53 56 E8 ?? ?? ?? ?? 09 5F 10 83 C4 30 8B 46 2C 85 C0 75 03 8D 46 30 50 8D 4F 18 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_259_1 {
	meta:
		name = "__ehhandler$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeloc@_Locimp@locale@std@@CAPAV123@ABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_7_2 {
	meta:
		name = "__ehhandler$??$?0AAPAUEHExceptionRecord@@_N@?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@QAE@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??$?0AAPAUEHExceptionRecord@@_N@?$_Ref_count_obj_alloc@V__ExceptionPtr@@U?$_StaticAllocator@H@@@std@@QAE@ABU?$_StaticAllocator@H@@AAPAUEHExceptionRecord@@$$QA_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_93_2 {
	meta:
		name = "__ehhandler$?_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_CurrentException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_886_1 {
	meta:
		name = "__ehhandler$?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makeushloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_895_1 {
	meta:
		name = "__ehhandler$?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Makewloc@_Locimp@locale@std@@CAXABV_Locinfo@3@HPAV123@PBV23@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_451_1 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1071_2 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1074_2 {
	meta:
		name = "__ehhandler$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_time@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_455_1 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1171_1 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1174_1 {
	meta:
		name = "__ehhandler$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?do_get_year@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHPAUtm@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E4 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_270_1 {
	meta:
		name = "?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ"
		size = 36
		refs = "000a ?sgetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHXZ"
	strings:
		$1 = { 56 8B F1 8B 0E 85 C9 74 0F E8 ?? ?? ?? ?? 83 F8 FF 74 05 88 46 05 EB 03 83 26 00 8A 46 05 C6 46 04 01 5E C3 }
	condition:
		$1
}

rule file_1_271_1 {
	meta:
		name = "?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IBE_JXZ"
		size = 18
		altNames = "?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IBE_JXZ ?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IBE_JXZ"
	strings:
		$1 = { 8B 41 20 33 D2 39 10 74 05 8B 41 30 8B 10 8B C2 99 C3 }
	condition:
		$1
}

rule file_1_272_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAEPADXZ"
		size = 16
	strings:
		$1 = { 8B 41 30 FF 08 8B 51 20 8B 02 8D 48 01 89 0A C3 }
	condition:
		$1
}

rule file_1_273_1 {
	meta:
		name = "?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PBDI@Z"
		size = 51
		refs = "0017 ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@D@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 1C 85 F6 74 17 57 8B 7D 18 0F B6 07 8D 4D 10 50 E8 ?? ?? ?? ?? 47 83 EE 01 75 EE 5F 8B 45 0C 8B 4D 10 5E 89 08 8B 4D 14 89 48 04 5D C3 }
	condition:
		$1
}

rule file_1_274_1 {
	meta:
		name = "?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z"
		size = 44
		refs = "0012 ??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QAEAAV01@D@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 1C 85 F6 74 10 FF 75 18 8D 4D 10 E8 ?? ?? ?? ?? 83 EE 01 75 F0 8B 45 0C 8B 4D 10 5E 89 08 8B 4D 14 89 48 04 5D C3 }
	condition:
		$1
}

rule file_58_957_1 {
	meta:
		name = "?_Rep@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@GI@Z"
		size = 44
		refs = "0012 ??4?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@QAEAAV01@G@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 1C 85 F6 74 10 FF 75 18 8D 4D 10 E8 ?? ?? ?? ?? 83 EE 01 75 F0 8B 45 0C 8B 4D 10 5E 89 08 8B 4D 14 89 48 04 5D C3 }
	condition:
		$1
}

rule file_58_958_1 {
	meta:
		name = "?_Rep@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_WI@Z"
		size = 44
		refs = "0012 ??4?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QAEAAV01@_W@Z"
	strings:
		$1 = { 55 8B EC 56 8B 75 1C 85 F6 74 10 FF 75 18 8D 4D 10 E8 ?? ?? ?? ?? 83 EE 01 75 F0 8B 45 0C 8B 4D 10 5E 89 08 8B 4D 14 89 48 04 5D C3 }
	condition:
		$1
}

rule file_1_275_1 {
	meta:
		name = "?_Stodx_v2@std@@YANPBDPAPADHPAH@Z"
		size = 83
		refs = "0009 __errno 001b _strtod 0040 __real@4024000000000000 0048 __CIpow"
	strings:
		$1 = { 55 8B EC 83 EC 10 56 57 E8 ?? ?? ?? ?? FF 75 0C 8B F8 FF 75 08 8B 37 83 27 00 E8 ?? ?? ?? ?? 8B 45 14 83 C4 08 83 7D 10 00 8B 0F DD 55 F0 89 08 89 37 5F 5E 74 19 DD D8 DB 45 10 DD 5D F8 DD 05 ?? ?? ?? ?? DD 45 F8 E8 ?? ?? ?? ?? DC 4D F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_276_1 {
	meta:
		name = "?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z"
		size = 91
		refs = "0008 __errno 001a _strtof 003c __real@4024000000000000 0044 __CIpow"
	strings:
		$1 = { 55 8B EC 51 51 56 57 E8 ?? ?? ?? ?? FF 75 0C 8B F8 FF 75 08 8B 37 83 27 00 E8 ?? ?? ?? ?? 83 7D 10 00 8B 45 14 59 59 8B 0F 89 08 89 37 5F D9 5D FC 5E 74 20 DB 45 10 D9 5D F8 DD 05 ?? ?? ?? ?? D9 45 F8 E8 ?? ?? ?? ?? D9 5D F8 D9 45 F8 D8 4D FC D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_279_1 {
	meta:
		name = "?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z"
		size = 82
		refs = "0024 _memcpy 0034 ?_Deallocate@std@@YAXPAXII@Z 0049 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 80 7D 08 00 56 8B F1 74 30 83 7E 18 10 72 2A 83 7D 0C 00 8D 46 04 53 8B 18 76 0D FF 75 0C 53 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 46 18 6A 01 40 50 53 E8 ?? ?? ?? ?? 83 C4 0C 5B FF 75 0C 8B CE C7 46 18 0F 00 00 00 E8 ?? ?? ?? ?? 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_1_280_1 {
	meta:
		name = "?_Tidy@?$ctype@D@std@@IAEXXZ"
		size = 42
		refs = "000e _free 001a ??_V@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 8B 46 10 85 C0 7E 0A FF 76 0C E8 ?? ?? ?? ?? EB 0A 79 09 FF 76 0C E8 ?? ?? ?? ?? 59 FF 76 14 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_1_281_1 {
	meta:
		name = "?_Tidy@?$numpunct@D@std@@AAEXXZ"
		size = 32
		refs = "0007 _free"
		altNames = "?_Tidy@?$numpunct@G@std@@AAEXXZ ?_Tidy@?$numpunct@_W@std@@AAEXXZ"
	strings:
		$1 = { 56 8B F1 FF 76 08 E8 ?? ?? ?? ?? FF 76 10 E8 ?? ?? ?? ?? FF 76 14 E8 ?? ?? ?? ?? 83 C4 0C 5E C3 }
	condition:
		$1
}

rule file_1_285_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEPADI@Z"
		size = 22
		refs = "000b ?_Allocate@std@@YAPAXII_N@Z"
		altNames = "?allocate@?$allocator@D@std@@QAEPADI@Z"
	strings:
		$1 = { 55 8B EC 6A 01 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_1_286_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAEPAU_Container_proxy@2@I@Z"
		size = 22
		refs = "000b ?_Allocate@std@@YAPAXII_N@Z"
		altNames = "?allocate@?$allocator@U_Container_proxy@std@@@std@@QAEPAU_Container_proxy@2@I@Z"
	strings:
		$1 = { 55 8B EC 6A 01 6A 08 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_1_290_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
		size = 157
		refs = "003c ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0072 _memcpy 007f ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 0091 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ 0098 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 56 8B F1 8B 4D 0C 57 8B 43 14 3B C1 72 78 8B 7D 10 2B C1 3B F8 76 02 8B F8 8B 4E 14 8B C1 F7 D0 3B C7 76 69 8D 04 39 89 45 FC 85 FF 74 4D 6A 00 50 8B CE E8 ?? ?? ?? ?? 84 C0 74 3F 83 7B 18 10 72 05 8B 5B 04 EB 03 83 C3 04 83 7E 18 10 72 05 8B 4E 04 EB 03 8D 4E 04 85 FF 74 15 8B 45 0C 03 C3 57 50 8B 46 14 03 C1 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 FC 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 8B E5 5D C2 0C 00 8B CB E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_291_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z"
		size = 82
		refs = "0023 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0035 ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXIID@Z 003d ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 004d ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 57 8B 7D 08 8B 4E 14 8B C1 F7 D0 3B C7 76 34 8D 1C 39 85 FF 74 24 6A 00 53 8B CE E8 ?? ?? ?? ?? 84 C0 74 16 FF 75 0C 8B CE 57 FF 76 14 E8 ?? ?? ?? ?? 53 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 5D C2 08 00 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_995_1 {
	meta:
		name = "?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@IG@Z"
		size = 82
		refs = "0023 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE_NI_N@Z 0035 ?_Chassign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXIIG@Z 003d ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z 004d ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 57 8B 7D 08 8B 4E 14 8B C1 F7 D0 3B C7 76 34 8D 1C 39 85 FF 74 24 6A 00 53 8B CE E8 ?? ?? ?? ?? 84 C0 74 16 FF 75 0C 8B CE 57 FF 76 14 E8 ?? ?? ?? ?? 53 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 5D C2 08 00 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_998_1 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@I_W@Z"
		size = 82
		refs = "0023 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE_NI_N@Z 0035 ?_Chassign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII_W@Z 003d ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z 004d ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 57 8B 7D 08 8B 4E 14 8B C1 F7 D0 3B C7 76 34 8D 1C 39 85 FF 74 24 6A 00 53 8B CE E8 ?? ?? ?? ?? 84 C0 74 16 FF 75 0C 8B CE 57 FF 76 14 E8 ?? ?? ?? ?? 53 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 5D C2 08 00 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_292_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 81
		refs = "0006 __ehhandler$?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z 0013 ___security_cookie 002f ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0039 ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 3B 75 08 74 13 6A 00 6A 01 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_90_207_1 {
	meta:
		name = "??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 81
		refs = "0006 __ehhandler$??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV01@$$QAV01@@Z 0013 ___security_cookie 002f ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX_NI@Z 0039 ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 3B 75 08 74 13 6A 00 6A 01 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_452_1 {
	meta:
		name = "??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 81
		refs = "0006 __ehhandler$??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV01@$$QAV01@@Z 0013 ___security_cookie 002f ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z 0039 ?_Assign_rv@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 3B 75 08 74 13 6A 00 6A 01 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_455_1 {
	meta:
		name = "??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@$$QAV01@@Z"
		size = 81
		refs = "0006 __ehhandler$??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV01@$$QAV01@@Z 0013 ___security_cookie 002f ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z 0039 ?_Assign_rv@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 3B 75 08 74 13 6A 00 6A 01 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1003_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 81
		refs = "0006 __ehhandler$?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@$$QAV12@@Z 0013 ___security_cookie 002f ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX_NI@Z 0039 ?_Assign_rv@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 3B 75 08 74 13 6A 00 6A 01 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1010_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@$$QAV12@@Z"
		size = 81
		refs = "0006 __ehhandler$?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@$$QAV12@@Z 0013 ___security_cookie 002f ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX_NI@Z 0039 ?_Assign_rv@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 3B 75 08 74 13 6A 00 6A 01 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_295_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z"
		size = 149
		refs = "002b ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@I@Z 0038 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@II@Z 0044 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0075 _memcpy 0080 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 0090 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 8B F1 8B 4D 0C 8B 47 14 3B C1 72 78 8B 5D 10 2B C1 3B D8 76 02 8B D8 3B F7 75 1A 8D 04 19 8B CE 50 E8 ?? ?? ?? ?? 8B 45 0C 8B CE 50 6A 00 E8 ?? ?? ?? ?? EB 46 6A 00 53 8B CE E8 ?? ?? ?? ?? 84 C0 74 38 83 7F 18 10 72 05 8B 7F 04 EB 03 83 C7 04 83 7E 18 10 72 05 8B 4E 04 EB 03 8D 4E 04 85 DB 74 10 8B 45 0C 53 03 C7 50 51 E8 ?? ?? ?? ?? 83 C4 0C 53 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 5D C2 0C 00 8B CF E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_296_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z"
		size = 64
		refs = "0012 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0025 ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXIID@Z 002f ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 003b ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 56 8B F1 74 2E 6A 00 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 19 FF 75 0C 8B CE FF 75 08 6A 00 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_1007_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@IG@Z"
		size = 64
		refs = "0012 ?_Grow@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE_NI_N@Z 0025 ?_Chassign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXIIG@Z 002f ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z 003b ?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 56 8B F1 74 2E 6A 00 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 19 FF 75 0C 8B CE FF 75 08 6A 00 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_1014_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@I_W@Z"
		size = 64
		refs = "0012 ?_Grow@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE_NI_N@Z 0025 ?_Chassign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXII_W@Z 002f ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z 003b ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 83 7D 08 FF 56 8B F1 74 2E 6A 00 FF 75 08 E8 ?? ?? ?? ?? 84 C0 74 19 FF 75 0C 8B CE FF 75 08 6A 00 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_297_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBD@Z"
		size = 31
		refs = "000a ?length@?$char_traits@D@std@@SAIPBD@Z 0016 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_41_260_2 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBD@Z"
		size = 31
		refs = "000a ?length@?$char_traits@D@std@@SAIPBD@Z 0016 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_53_73_2 {
	meta:
		name = "?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_W@Z"
		size = 31
		refs = "000a ?length@?$char_traits@_W@std@@SAIPB_W@Z 0016 ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_WI@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1008_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@PBG@Z"
		size = 31
		refs = "000a ?length@?$char_traits@G@std@@SAIPBG@Z 0016 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@PBGI@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1015_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_W@Z"
		size = 31
		refs = "000a ?length@?$char_traits@_W@std@@SAIPB_W@Z 0016 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@PB_WI@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 59 50 FF 75 08 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_298_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z"
		size = 114
		refs = "000c ?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NPBD@Z 002c ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z 003c ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 005a _memcpy 0065 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 53 8B F1 E8 ?? ?? ?? ?? 84 C0 74 1E 83 7E 18 10 72 05 8B 46 04 EB 03 8D 46 04 FF 75 0C 2B D8 8B CE 53 56 E8 ?? ?? ?? ?? EB 3A 57 8B 7D 0C 8B CE 6A 00 57 E8 ?? ?? ?? ?? 84 C0 74 25 83 7E 18 10 72 05 8B 46 04 EB 03 8D 46 04 85 FF 74 0B 57 53 50 E8 ?? ?? ?? ?? 83 C4 0C 57 8B CE E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 5D C2 08 00 }
	condition:
		$1
}

rule file_1_299_1 {
	meta:
		name = "?assign@?$char_traits@D@std@@SAPADPADID@Z"
		size = 24
		refs = "000f _memset"
	strings:
		$1 = { 55 8B EC FF 75 0C 0F BE 45 10 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1_303_1 {
	meta:
		name = "?c_str@locale@std@@QBEPBDXZ"
		size = 24
		refs = "0008 ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 8B 49 04 85 C9 75 06 B8 ?? ?? ?? ?? C3 8B 41 18 85 C0 75 03 8D 41 1C C3 }
	condition:
		$1
}

rule file_1_304_1 {
	meta:
		name = "?copy@?$char_traits@D@std@@SAPADPADPBDI@Z"
		size = 20
		refs = "0010 _memcpy"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 05 8B 45 08 5D C3 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1254_2 {
	meta:
		name = "?move@?$char_traits@D@std@@SAPADPADPBDI@Z"
		size = 20
		refs = "0010 _memmove"
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 05 8B 45 08 5D C3 5D E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_305_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QAEXPADI@Z"
		size = 23
		refs = "000c ?_Deallocate@std@@YAXPAXII@Z"
		altNames = "?deallocate@?$allocator@D@std@@QAEXPADI@Z"
	strings:
		$1 = { 55 8B EC 6A 01 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C2 08 00 }
	condition:
		$1
}

rule file_1_306_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QAEXPAU_Container_proxy@2@I@Z"
		size = 23
		refs = "000c ?_Deallocate@std@@YAXPAXII@Z"
		altNames = "?deallocate@?$allocator@U_Container_proxy@std@@@std@@QAEXPAU_Container_proxy@2@I@Z"
	strings:
		$1 = { 55 8B EC 6A 08 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C2 08 00 }
	condition:
		$1
}

rule file_1_309_1 {
	meta:
		name = "?decimal_point@?$numpunct@D@std@@QBEDXZ"
		size = 23
		refs = "000c @_guard_check_icall@4"
		altNames = "?always_noconv@codecvt_base@std@@QBE_NXZ ?date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QBE?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QBE?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QBE?AW4dateorder@time_base@2@XZ ?decimal_point@?$_Mpunct@D@std@@QBEDXZ ?decimal_point@?$_Mpunct@G@std@@QBEGXZ ?decimal_point@?$_Mpunct@_W@std@@QBE_WXZ ?decimal_point@?$numpunct@G@std@@QBEGXZ ?decimal_point@?$numpunct@_W@std@@QBE_WXZ"
	strings:
		$1 = { 56 57 8B F9 8B 07 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5F 5E C3 }
	condition:
		$1
}

rule file_1_314_1 {
	meta:
		name = "?do_falsename@?$numpunct@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		altNames = "?do_curr_symbol@?$_Mpunct@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 FF 71 10 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1056_1 {
	meta:
		name = "?do_curr_symbol@?$_Mpunct@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 10 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1057_1 {
	meta:
		name = "?do_curr_symbol@?$_Mpunct@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 10 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1067_1 {
	meta:
		name = "?do_falsename@?$numpunct@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 10 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1068_1 {
	meta:
		name = "?do_falsename@?$numpunct@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 10 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_315_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 201
		refs = "0003 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0045 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0056 ??1locale@std@@QAE@XZ 0071 __Stoulx 0082 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00c2 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 18 8B F0 E8 ?? ?? ?? ?? 80 7D D0 2D 8D 7D D1 74 03 8D 7D D0 8D 45 CC 50 56 8D 45 C8 50 57 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 39 7D C8 74 1E 83 7D CC 00 75 18 81 FE FF FF 00 00 77 10 80 7D D0 2D 75 02 F7 DE 8B 45 C4 66 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1085_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 201
		refs = "0003 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0045 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0056 ??1locale@std@@QAE@XZ 0071 __Stoulx 0082 ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00c2 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 18 8B F0 E8 ?? ?? ?? ?? 80 7D D0 2D 8D 7D D1 74 03 8D 7D D0 8D 45 CC 50 56 8D 45 C8 50 57 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 39 7D C8 74 1E 83 7D CC 00 75 18 81 FE FF FF 00 00 77 10 80 7D D0 2D 75 02 F7 DE 8B 45 C4 66 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1116_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z"
		size = 201
		refs = "0003 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAG@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0045 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0056 ??1locale@std@@QAE@XZ 0071 __Stoulx 0082 ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00c2 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 18 8B F0 E8 ?? ?? ?? ?? 80 7D D0 2D 8D 7D D1 74 03 8D 7D D0 8D 45 CC 50 56 8D 45 C8 50 57 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 39 7D C8 74 1E 83 7D CC 00 75 18 81 FE FF FF 00 00 77 10 80 7D D0 2D 75 02 F7 DE 8B 45 C4 66 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_1_318_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 192
		refs = "0003 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0045 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0056 ??1locale@std@@QAE@XZ 0071 __Stoulx 0082 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00b9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 18 8B F0 E8 ?? ?? ?? ?? 80 7D D0 2D 8D 7D D1 74 03 8D 7D D0 8D 45 CC 50 56 8D 45 C8 50 57 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 39 7D C8 74 15 83 7D CC 00 75 0F 80 7D D0 2D 75 02 F7 DE 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1088_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 192
		refs = "0003 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0045 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0056 ??1locale@std@@QAE@XZ 0071 __Stoulx 0082 ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00b9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 18 8B F0 E8 ?? ?? ?? ?? 80 7D D0 2D 8D 7D D1 74 03 8D 7D D0 8D 45 CC 50 56 8D 45 C8 50 57 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 39 7D C8 74 15 83 7D CC 00 75 0F 80 7D D0 2D 75 02 F7 DE 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1119_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z"
		size = 192
		refs = "0003 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAI@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0045 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0056 ??1locale@std@@QAE@XZ 0071 __Stoulx 0082 ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00b9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 18 8B F0 E8 ?? ?? ?? ?? 80 7D D0 2D 8D 7D D1 74 03 8D 7D D0 8D 45 CC 50 56 8D 45 C8 50 57 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 39 7D C8 74 15 83 7D CC 00 75 0F 80 7D D0 2D 75 02 F7 DE 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_1_321_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 176
		refs = "0003 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005a __Stolx 006b ??1locale@std@@QAE@XZ 0077 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00a9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_1_324_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 176
		refs = "0003 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005a __Stoulx 006b ??1locale@std@@QAE@XZ 0077 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00a9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1091_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 176
		refs = "0003 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005a __Stolx 006b ??1locale@std@@QAE@XZ 0077 ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00a9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1094_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 176
		refs = "0003 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005a __Stoulx 006b ??1locale@std@@QAE@XZ 0077 ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00a9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1122_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z"
		size = 176
		refs = "0003 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAJ@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005a __Stolx 006b ??1locale@std@@QAE@XZ 0077 ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00a9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1125_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z"
		size = 176
		refs = "0003 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAK@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005a __Stoulx 006b ??1locale@std@@QAE@XZ 0077 ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00a9 __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_1_327_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 250
		refs = "000a ___security_cookie 0053 ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 006a ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 0097 _ldexpf 00ab ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 2C 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8D 95 D8 FC FF FF 53 8B 5D 24 83 A5 D8 FC FF FF 00 56 8B 75 20 57 8B 7D 08 52 8D 95 DC FC FF FF C7 85 DC FC FF FF 00 CA 9A 3B 52 50 8D 45 14 50 8D 45 0C 50 8D 85 E4 FC FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 85 D4 FC FF FF 50 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 8B 85 DC FC FF FF 83 C4 10 D9 9D E0 FC FF FF 3D 00 CA 9A 3B 74 1F 85 C0 74 1B D9 85 E0 FC FF FF C1 E0 02 50 51 D9 1C 24 E8 ?? ?? ?? ?? 59 D9 9D E0 FC FF FF 59 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0E 01 8D 85 E4 FC FF FF 39 85 D4 FC FF FF 74 13 83 BD D8 FC FF FF 00 75 0A D9 85 E0 FC FF FF D9 1B EB 03 83 0E 02 8B 4D 0C 8B C7 89 0F 8B 4D 10 89 4F 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_58_1097_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 250
		refs = "000a ___security_cookie 0053 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 006a ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 0097 _ldexpf 00ab ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 2C 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8D 95 D8 FC FF FF 53 8B 5D 24 83 A5 D8 FC FF FF 00 56 8B 75 20 57 8B 7D 08 52 8D 95 DC FC FF FF C7 85 DC FC FF FF 00 CA 9A 3B 52 50 8D 45 14 50 8D 45 0C 50 8D 85 E4 FC FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 85 D4 FC FF FF 50 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 8B 85 DC FC FF FF 83 C4 10 D9 9D E0 FC FF FF 3D 00 CA 9A 3B 74 1F 85 C0 74 1B D9 85 E0 FC FF FF C1 E0 02 50 51 D9 1C 24 E8 ?? ?? ?? ?? 59 D9 9D E0 FC FF FF 59 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0E 01 8D 85 E4 FC FF FF 39 85 D4 FC FF FF 74 13 83 BD D8 FC FF FF 00 75 0A D9 85 E0 FC FF FF D9 1B EB 03 83 0E 02 8B 4D 0C 8B C7 89 0F 8B 4D 10 89 4F 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_58_1128_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAM@Z"
		size = 250
		refs = "000a ___security_cookie 0053 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 006a ?_Stofx_v2@std@@YAMPBDPAPADHPAH@Z 0097 _ldexpf 00ab ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 2C 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8D 95 D8 FC FF FF 53 8B 5D 24 83 A5 D8 FC FF FF 00 56 8B 75 20 57 8B 7D 08 52 8D 95 DC FC FF FF C7 85 DC FC FF FF 00 CA 9A 3B 52 50 8D 45 14 50 8D 45 0C 50 8D 85 E4 FC FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 85 D4 FC FF FF 50 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 8B 85 DC FC FF FF 83 C4 10 D9 9D E0 FC FF FF 3D 00 CA 9A 3B 74 1F 85 C0 74 1B D9 85 E0 FC FF FF C1 E0 02 50 51 D9 1C 24 E8 ?? ?? ?? ?? 59 D9 9D E0 FC FF FF 59 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0E 01 8D 85 E4 FC FF FF 39 85 D4 FC FF FF 74 13 83 BD D8 FC FF FF 00 75 0A D9 85 E0 FC FF FF D9 1B EB 03 83 0E 02 8B 4D 0C 8B C7 89 0F 8B 4D 10 89 4F 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_1_328_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 250
		refs = "000a ___security_cookie 0053 ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AAVios_base@2@PAH@Z 006a ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0092 _ldexp 00ab ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00f0 @__security_check_cookie@4"
		altNames = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
	strings:
		$1 = { 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8D 95 DC FC FF FF 53 8B 5D 24 83 A5 DC FC FF FF 00 56 8B 75 20 57 8B 7D 08 52 8D 95 E0 FC FF FF C7 85 E0 FC FF FF 00 CA 9A 3B 52 50 8D 45 14 50 8D 45 0C 50 8D 85 E4 FC FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 85 D8 FC FF FF 50 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 8B 85 E0 FC FF FF 83 C4 10 DD 95 D0 FC FF FF 3D 00 CA 9A 3B 74 1D 85 C0 74 19 C1 E0 02 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 9D D0 FC FF FF 83 C4 0C EB 02 DD D8 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0E 01 8D 85 E4 FC FF FF 39 85 D8 FC FF FF 74 13 83 BD DC FC FF FF 00 75 0A DD 85 D0 FC FF FF DD 1B EB 03 83 0E 02 8B 4D 0C 8B C7 89 0F 8B 4D 10 89 4F 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_58_1098_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 250
		refs = "000a ___security_cookie 0053 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 006a ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0092 _ldexp 00ab ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8D 95 DC FC FF FF 53 8B 5D 24 83 A5 DC FC FF FF 00 56 8B 75 20 57 8B 7D 08 52 8D 95 E0 FC FF FF C7 85 E0 FC FF FF 00 CA 9A 3B 52 50 8D 45 14 50 8D 45 0C 50 8D 85 E4 FC FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 85 D8 FC FF FF 50 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 8B 85 E0 FC FF FF 83 C4 10 DD 95 D0 FC FF FF 3D 00 CA 9A 3B 74 1D 85 C0 74 19 C1 E0 02 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 9D D0 FC FF FF 83 C4 0C EB 02 DD D8 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0E 01 8D 85 E4 FC FF FF 39 85 D8 FC FF FF 74 13 83 BD DC FC FF FF 00 75 0A DD 85 D0 FC FF FF DD 1B EB 03 83 0E 02 8B 4D 0C 8B C7 89 0F 8B 4D 10 89 4F 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_58_1099_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
		size = 250
		refs = "000a ___security_cookie 0053 ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AAVios_base@2@PAH@Z 006a ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0092 _ldexp 00ab ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8D 95 DC FC FF FF 53 8B 5D 24 83 A5 DC FC FF FF 00 56 8B 75 20 57 8B 7D 08 52 8D 95 E0 FC FF FF C7 85 E0 FC FF FF 00 CA 9A 3B 52 50 8D 45 14 50 8D 45 0C 50 8D 85 E4 FC FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 85 D8 FC FF FF 50 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 8B 85 E0 FC FF FF 83 C4 10 DD 95 D0 FC FF FF 3D 00 CA 9A 3B 74 1D 85 C0 74 19 C1 E0 02 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 9D D0 FC FF FF 83 C4 0C EB 02 DD D8 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0E 01 8D 85 E4 FC FF FF 39 85 D8 FC FF FF 74 13 83 BD DC FC FF FF 00 75 0A DD 85 D0 FC FF FF DD 1B EB 03 83 0E 02 8B 4D 0C 8B C7 89 0F 8B 4D 10 89 4F 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_58_1129_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAN@Z"
		size = 250
		refs = "000a ___security_cookie 0053 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 006a ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0092 _ldexp 00ab ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8D 95 DC FC FF FF 53 8B 5D 24 83 A5 DC FC FF FF 00 56 8B 75 20 57 8B 7D 08 52 8D 95 E0 FC FF FF C7 85 E0 FC FF FF 00 CA 9A 3B 52 50 8D 45 14 50 8D 45 0C 50 8D 85 E4 FC FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 85 D8 FC FF FF 50 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 8B 85 E0 FC FF FF 83 C4 10 DD 95 D0 FC FF FF 3D 00 CA 9A 3B 74 1D 85 C0 74 19 C1 E0 02 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 9D D0 FC FF FF 83 C4 0C EB 02 DD D8 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0E 01 8D 85 E4 FC FF FF 39 85 D8 FC FF FF 74 13 83 BD DC FC FF FF 00 75 0A DD 85 D0 FC FF FF DD 1B EB 03 83 0E 02 8B 4D 0C 8B C7 89 0F 8B 4D 10 89 4F 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_58_1130_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAO@Z"
		size = 250
		refs = "000a ___security_cookie 0053 ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AAVios_base@2@PAH@Z 006a ?_Stodx_v2@std@@YANPBDPAPADHPAH@Z 0092 _ldexp 00ab ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00f0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 30 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8D 95 DC FC FF FF 53 8B 5D 24 83 A5 DC FC FF FF 00 56 8B 75 20 57 8B 7D 08 52 8D 95 E0 FC FF FF C7 85 E0 FC FF FF 00 CA 9A 3B 52 50 8D 45 14 50 8D 45 0C 50 8D 85 E4 FC FF FF 50 51 E8 ?? ?? ?? ?? 83 C4 18 50 8D 85 D8 FC FF FF 50 8D 85 E4 FC FF FF 50 E8 ?? ?? ?? ?? 8B 85 E0 FC FF FF 83 C4 10 DD 95 D0 FC FF FF 3D 00 CA 9A 3B 74 1D 85 C0 74 19 C1 E0 02 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 9D D0 FC FF FF 83 C4 0C EB 02 DD D8 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0E 01 8D 85 E4 FC FF FF 39 85 D8 FC FF FF 74 13 83 BD DC FC FF FF 00 75 0A DD 85 D0 FC FF FF DD 1B EB 03 83 0E 02 8B 4D 0C 8B C7 89 0F 8B 4D 10 89 4F 04 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_1_330_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 174
		refs = "0003 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0008 __EH_prolog3_GS 0026 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0042 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0053 ??1locale@std@@QAE@XZ 0065 __Stoulx 0076 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00a7 __EH_epilog3_GS"
	strings:
		$1 = { 6A 40 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 45 24 8B 4D 1C 8B 5D 08 8B 7D 20 83 65 CC 00 89 45 C4 8D 45 BC 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 68 00 08 00 00 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 56 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D BC 83 C4 18 8B F0 E8 ?? ?? ?? ?? 8D 45 CC 50 56 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0F 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0F 02 8B 4D 0C 8B C3 89 0B 8B 4D 10 89 4B 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1100_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 174
		refs = "0003 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0008 __EH_prolog3_GS 0026 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0042 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 0053 ??1locale@std@@QAE@XZ 0065 __Stoulx 0076 ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00a7 __EH_epilog3_GS"
	strings:
		$1 = { 6A 40 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 45 24 8B 4D 1C 8B 5D 08 8B 7D 20 83 65 CC 00 89 45 C4 8D 45 BC 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 68 00 08 00 00 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 56 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D BC 83 C4 18 8B F0 E8 ?? ?? ?? ?? 8D 45 CC 50 56 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0F 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0F 02 8B 4D 0C 8B C3 89 0B 8B 4D 10 89 4B 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1131_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 174
		refs = "0003 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0008 __EH_prolog3_GS 0026 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0042 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 0053 ??1locale@std@@QAE@XZ 0065 __Stoulx 0076 ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00a7 __EH_epilog3_GS"
	strings:
		$1 = { 6A 40 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 8B 45 24 8B 4D 1C 8B 5D 08 8B 7D 20 83 65 CC 00 89 45 C4 8D 45 BC 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 68 00 08 00 00 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 56 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D BC 83 C4 18 8B F0 E8 ?? ?? ?? ?? 8D 45 CC 50 56 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 10 8D 4D 0C 8B F0 8D 45 14 50 E8 ?? ?? ?? ?? 84 C0 74 03 83 0F 01 8D 45 D0 39 45 C8 74 0D 83 7D CC 00 75 07 8B 45 C4 89 30 EB 03 83 0F 02 8B 4D 0C 8B C3 89 0B 8B 4D 10 89 4B 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_1_332_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_983_2 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1078_1 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_989_2 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1084_1 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1102_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1133_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAAPAX@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_116_417_2 {
	meta:
		name = "__ehhandler$?do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAAVios_base@2@DABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAAVios_base@2@DABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1351_1 {
	meta:
		name = "__ehhandler$?name@locale@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?name@locale@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B0 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_333_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 181
		refs = "0003 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005a __Stollx 006d ??1locale@std@@QAE@XZ 0079 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00ae __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 8B FA E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 10 83 7D CC 00 75 0A 8B 45 C4 89 30 89 78 04 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_1_336_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 181
		refs = "0003 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 005a __Stoullx 006d ??1locale@std@@QAE@XZ 0079 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 00ae __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 8B FA E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 10 83 7D CC 00 75 0A 8B 45 C4 89 30 89 78 04 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1103_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 181
		refs = "0003 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005a __Stollx 006d ??1locale@std@@QAE@XZ 0079 ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00ae __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 8B FA E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 10 83 7D CC 00 75 0A 8B 45 C4 89 30 89 78 04 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1106_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 181
		refs = "0003 __ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HABVlocale@2@@Z 005a __Stoullx 006d ??1locale@std@@QAE@XZ 0079 ?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z 00ae __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 8B FA E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 10 83 7D CC 00 75 0A 8B 45 C4 89 30 89 78 04 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1134_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z"
		size = 181
		refs = "0003 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_J@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005a __Stollx 006d ??1locale@std@@QAE@XZ 0079 ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00ae __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 8B FA E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 10 83 7D CC 00 75 0A 8B 45 C4 89 30 89 78 04 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_58_1137_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z"
		size = 181
		refs = "0003 __ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_K@Z 0008 __EH_prolog3_GS 002b ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0049 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HABVlocale@2@@Z 005a __Stoullx 006d ??1locale@std@@QAE@XZ 0079 ?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z 00ae __EH_epilog3_GS"
	strings:
		$1 = { 6A 3C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 8B 45 08 8B 75 1C 8B CE 8B 5D 20 83 65 CC 00 89 45 C0 8B 45 24 89 45 C4 8D 45 B8 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 4D CC 51 50 FF 76 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 57 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 C8 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B8 83 C4 10 8B F0 8B FA E8 ?? ?? ?? ?? 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0B 01 8D 45 D0 39 45 C8 74 10 83 7D CC 00 75 0A 8B 45 C4 89 30 89 78 04 EB 03 83 0B 02 8B 45 C0 8B 4D 0C 89 08 8B 4D 10 89 48 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_1_339_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z"
		size = 418
		refs = "0003 __ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z 0008 __EH_prolog3_GS 0038 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 0042 ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0051 ??1locale@std@@QAE@XZ 005d ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 006f ?falsename@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0080 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z 008c ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0098 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00a3 ?truename@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00dc ??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z 0127 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAHPADAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HABVlocale@2@@Z 0138 __Stoulx 0171 ?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z 019b __EH_epilog3_GS"
	strings:
		$1 = { 6A 7C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D 90 8B 45 1C 83 CE FF 8B 4D 24 8B 5D 08 8B 7D 20 F7 40 14 00 40 00 00 89 45 88 89 4D 80 0F 84 C2 00 00 00 8D 4D 8C 51 8B C8 E8 ?? ?? ?? ?? 83 65 FC 00 50 E8 ?? ?? ?? ?? 83 4D FC FF 8B F0 59 8D 4D 8C E8 ?? ?? ?? ?? 6A 00 6A 01 8D 4D B4 E8 ?? ?? ?? ?? 8D 45 98 C7 45 FC 01 00 00 00 50 8B CE E8 ?? ?? ?? ?? 6A FF 6A 00 50 8D 4D B4 C6 45 FC 02 E8 ?? ?? ?? ?? 8D 4D 98 C6 45 FC 01 E8 ?? ?? ?? ?? 6A 00 6A 01 8D 4D B4 E8 ?? ?? ?? ?? 8D 45 98 8B CE 50 E8 ?? ?? ?? ?? 6A FF 6A 00 50 8D 4D B4 C6 45 FC 03 E8 ?? ?? ?? ?? 8D 4D 98 C6 45 FC 01 E8 ?? ?? ?? ?? 83 7D CC 10 8B 45 B8 73 03 8D 45 B8 50 6A 02 8D 45 14 50 8D 45 0C 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 4D B4 83 C4 10 8B F0 E8 ?? ?? ?? ?? EB 76 83 65 94 00 8D 8D 78 FF FF FF 51 8B C8 E8 ?? ?? ?? ?? 8D 4D 94 C7 45 FC 04 00 00 00 51 50 8B 45 88 FF 70 14 8D 45 14 50 8D 45 0C 50 8D 45 D0 50 FF 75 90 E8 ?? ?? ?? ?? 83 C4 18 50 8D 45 84 50 8D 45 D0 50 E8 ?? ?? ?? ?? 83 4D FC FF 8D 8D 78 FF FF FF 83 C4 10 89 45 90 E8 ?? ?? ?? ?? 8D 45 D0 39 45 84 74 10 83 7D 94 00 75 0A 8B 45 90 83 F8 01 77 02 8B F0 8D 45 14 50 8D 4D 0C E8 ?? ?? ?? ?? 84 C0 74 03 83 0F 01 85 F6 79 05 83 0F 02 EB 08 8B 45 80 0F 95 C1 88 08 8B 4D 0C 8B C3 89 0B 8B 4D 10 89 4B 04 E8 ?? ?? ?? ?? C2 20 00 }
	condition:
		$1
}

rule file_1_345_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 74 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1115_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 74 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1146_1 {
	meta:
		name = "__ehhandler$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z"
		size = 40
		refs = "0010 @__security_check_cookie@4 001f __ehfuncinfo$?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AAVios_base@2@AAHAA_N@Z 0024 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 8A 74 FF FF FF 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_346_1 {
	meta:
		name = "?do_grouping@?$numpunct@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		altNames = "?do_grouping@?$_Mpunct@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$_Mpunct@G@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$_Mpunct@_W@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$numpunct@G@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$numpunct@_W@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 FF 71 08 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_347_1 {
	meta:
		name = "?do_in@?$codecvt@DDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z"
		size = 26
		altNames = "?do_out@?$codecvt@DDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z"
	strings:
		$1 = { 55 8B EC 8B 4D 14 8B 45 0C 6A 03 89 01 8B 4D 20 8B 45 18 89 01 58 5D C2 1C 00 }
	condition:
		$1
}

rule file_1_348_1 {
	meta:
		name = "?do_length@?$codecvt@DDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PBD1I@Z"
		size = 24
	strings:
		$1 = { 55 8B EC 8B 45 10 2B 45 0C 8B 4D 14 3B C8 72 02 8B C8 8B C1 5D C2 10 00 }
	condition:
		$1
}

rule file_1_351_1 {
	meta:
		name = "?do_narrow@?$ctype@D@std@@MBEPBDPBD0DPAD@Z"
		size = 31
		refs = "0011 _memcpy"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 2B 4D 08 51 FF 75 08 FF 75 14 E8 ?? ?? ?? ?? 8B 45 0C 83 C4 0C 5D C2 10 00 }
	condition:
		$1
}

rule file_1_353_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DJ@Z"
		size = 109
		refs = "0007 ___security_cookie 0025 ??_C@_02EAOCLKAK@ld?$AA@ 002c ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z 003b _sprintf_s 0051 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0063 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 1C 8B F9 FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_1_354_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DK@Z"
		size = 109
		refs = "0007 ___security_cookie 0025 ??_C@_02BDDLJJBK@lu?$AA@ 002c ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z 003b _sprintf_s 0051 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0063 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 1C 8B F9 FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_58_1224_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GJ@Z"
		size = 109
		refs = "0007 ___security_cookie 0025 ??_C@_02EAOCLKAK@ld?$AA@ 002c ?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z 003b _sprintf_s 0051 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0063 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 1C 8B F9 FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_58_1225_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GK@Z"
		size = 109
		refs = "0007 ___security_cookie 0025 ??_C@_02BDDLJJBK@lu?$AA@ 002c ?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z 003b _sprintf_s 0051 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0063 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 1C 8B F9 FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_58_1239_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WJ@Z"
		size = 109
		refs = "0007 ___security_cookie 0025 ??_C@_02EAOCLKAK@ld?$AA@ 002c ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z 003b _sprintf_s 0051 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0063 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 1C 8B F9 FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_58_1240_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WK@Z"
		size = 109
		refs = "0007 ___security_cookie 0025 ??_C@_02BDDLJJBK@lu?$AA@ 002c ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z 003b _sprintf_s 0051 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0063 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 1C 8B F9 FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_1_355_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DN@Z"
		size = 295
		refs = "0003 __ehhandler$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DN@Z 0008 __EH_prolog3_GS 001c ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 005c __real@4202a05f20000000 0071 _frexp 00a0 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 00ad ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00da ?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADDH@Z 00e7 _sprintf_s 010e ?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 0119 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0120 __EH_epilog3_GS"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D C0 8B 45 08 8D 4D CC 8B 75 14 89 45 BC E8 ?? ?? ?? ?? 8B 46 14 BA 00 20 00 00 83 65 FC 00 25 00 30 00 00 8B 4E 1C 8B 7E 18 85 C9 7F 0F 7C 04 85 FF 75 09 3B C2 74 05 6A 06 5F 33 C9 DD 45 1C 89 4D C8 8B CF 3B C2 75 3B D9 C0 D9 E1 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 2A 8D 45 C8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 C8 B9 A0 86 01 00 99 83 C4 0C 33 C2 2B C2 69 C0 97 75 00 00 99 F7 F9 8D 0C 07 8D 41 32 DD D8 8D 4D CC 3B 45 E0 77 08 50 E8 ?? ?? ?? ?? EB 0B 2B 45 E0 6A 00 50 E8 ?? ?? ?? ?? 83 7D E4 10 8B 45 E0 8B 5D D0 89 45 C8 73 03 8D 5D D0 DD 45 1C 8D 45 E8 51 51 DD 1C 24 57 FF 76 14 8B 7D C0 6A 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 FF 75 C8 53 E8 ?? ?? ?? ?? 83 C4 18 8B C8 83 7D E4 10 8B 45 D0 73 03 8D 45 D0 51 50 FF 75 18 56 FF 75 10 8B 75 BC FF 75 0C 56 57 E8 ?? ?? ?? ?? 83 C4 20 8D 4D CC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 1C 00 }
	condition:
		$1
}

rule file_58_1226_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GN@Z"
		size = 295
		refs = "0003 __ehhandler$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GN@Z 0008 __EH_prolog3_GS 001c ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 005c __real@4202a05f20000000 0071 _frexp 00a0 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 00ad ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00da ?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADDH@Z 00e7 _sprintf_s 010e ?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z 0119 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0120 __EH_epilog3_GS"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D C0 8B 45 08 8D 4D CC 8B 75 14 89 45 BC E8 ?? ?? ?? ?? 8B 46 14 BA 00 20 00 00 83 65 FC 00 25 00 30 00 00 8B 4E 1C 8B 7E 18 85 C9 7F 0F 7C 04 85 FF 75 09 3B C2 74 05 6A 06 5F 33 C9 DD 45 1C 89 4D C8 8B CF 3B C2 75 3B D9 C0 D9 E1 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 2A 8D 45 C8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 C8 B9 A0 86 01 00 99 83 C4 0C 33 C2 2B C2 69 C0 97 75 00 00 99 F7 F9 8D 0C 07 8D 41 32 DD D8 8D 4D CC 3B 45 E0 77 08 50 E8 ?? ?? ?? ?? EB 0B 2B 45 E0 6A 00 50 E8 ?? ?? ?? ?? 83 7D E4 10 8B 45 E0 8B 5D D0 89 45 C8 73 03 8D 5D D0 DD 45 1C 8D 45 E8 51 51 DD 1C 24 57 FF 76 14 8B 7D C0 6A 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 FF 75 C8 53 E8 ?? ?? ?? ?? 83 C4 18 8B C8 83 7D E4 10 8B 45 D0 73 03 8D 45 D0 51 50 FF 75 18 56 FF 75 10 8B 75 BC FF 75 0C 56 57 E8 ?? ?? ?? ?? 83 C4 20 8D 4D CC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 1C 00 }
	condition:
		$1
}

rule file_58_1241_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WN@Z"
		size = 295
		refs = "0003 __ehhandler$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WN@Z 0008 __EH_prolog3_GS 001c ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 005c __real@4202a05f20000000 0071 _frexp 00a0 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 00ad ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00da ?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADDH@Z 00e7 _sprintf_s 010e ?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z 0119 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0120 __EH_epilog3_GS"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D C0 8B 45 08 8D 4D CC 8B 75 14 89 45 BC E8 ?? ?? ?? ?? 8B 46 14 BA 00 20 00 00 83 65 FC 00 25 00 30 00 00 8B 4E 1C 8B 7E 18 85 C9 7F 0F 7C 04 85 FF 75 09 3B C2 74 05 6A 06 5F 33 C9 DD 45 1C 89 4D C8 8B CF 3B C2 75 3B D9 C0 D9 E1 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 2A 8D 45 C8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 C8 B9 A0 86 01 00 99 83 C4 0C 33 C2 2B C2 69 C0 97 75 00 00 99 F7 F9 8D 0C 07 8D 41 32 DD D8 8D 4D CC 3B 45 E0 77 08 50 E8 ?? ?? ?? ?? EB 0B 2B 45 E0 6A 00 50 E8 ?? ?? ?? ?? 83 7D E4 10 8B 45 E0 8B 5D D0 89 45 C8 73 03 8D 5D D0 DD 45 1C 8D 45 E8 51 51 DD 1C 24 57 FF 76 14 8B 7D C0 6A 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 FF 75 C8 53 E8 ?? ?? ?? ?? 83 C4 18 8B C8 83 7D E4 10 8B 45 D0 73 03 8D 45 D0 51 50 FF 75 18 56 FF 75 10 8B 75 BC FF 75 0C 56 57 E8 ?? ?? ?? ?? 83 C4 20 8D 4D CC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 1C 00 }
	condition:
		$1
}

rule file_1_357_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DN@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DN@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_10_2 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_36_2 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_39_2 {
	meta:
		name = "__ehhandler$??$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@DV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_42_2 {
	meta:
		name = "__ehhandler$??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0IPBG@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_45_2 {
	meta:
		name = "__ehhandler$??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??$_Getloctxt@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@YAHAAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0IPB_W@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_438_1 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0_NAAVios_base@2@AAHAAO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_986_2 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_992_2 {
	meta:
		name = "__ehhandler$?do_get@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_get@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0_NAAVios_base@2@AAHAAV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_360_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1228_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GN@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GN@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1231_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1243_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WN@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WN@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1246_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1259_2 {
	meta:
		name = "__ehhandler$?name@locale@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?name@locale@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A B8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_358_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DO@Z"
		size = 295
		refs = "0003 __ehhandler$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DO@Z 0008 __EH_prolog3_GS 001c ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 005c __real@4202a05f20000000 0071 _frexp 00a0 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 00ad ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00da ?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADDH@Z 00e7 _sprintf_s 010e ?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBDI@Z 0119 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0120 __EH_epilog3_GS"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D C0 8B 45 08 8D 4D CC 8B 75 14 89 45 BC E8 ?? ?? ?? ?? 8B 46 14 BA 00 20 00 00 83 65 FC 00 25 00 30 00 00 8B 4E 1C 8B 7E 18 85 C9 7F 0F 7C 04 85 FF 75 09 3B C2 74 05 6A 06 5F 33 C9 DD 45 1C 89 4D C8 8B CF 3B C2 75 3B D9 C0 D9 E1 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 2A 8D 45 C8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 C8 B9 A0 86 01 00 99 83 C4 0C 33 C2 2B C2 69 C0 97 75 00 00 99 F7 F9 8D 0C 07 8D 41 32 DD D8 8D 4D CC 3B 45 E0 77 08 50 E8 ?? ?? ?? ?? EB 0B 2B 45 E0 6A 00 50 E8 ?? ?? ?? ?? 83 7D E4 10 8B 45 E0 8B 5D D0 89 45 C8 73 03 8D 5D D0 DD 45 1C 8D 45 E8 51 51 DD 1C 24 57 FF 76 14 8B 7D C0 6A 4C 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 FF 75 C8 53 E8 ?? ?? ?? ?? 83 C4 18 8B C8 83 7D E4 10 8B 45 D0 73 03 8D 45 D0 51 50 FF 75 18 56 FF 75 10 8B 75 BC FF 75 0C 56 57 E8 ?? ?? ?? ?? 83 C4 20 8D 4D CC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 1C 00 }
	condition:
		$1
}

rule file_58_1229_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GO@Z"
		size = 295
		refs = "0003 __ehhandler$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GO@Z 0008 __EH_prolog3_GS 001c ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 005c __real@4202a05f20000000 0071 _frexp 00a0 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 00ad ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00da ?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADDH@Z 00e7 _sprintf_s 010e ?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z 0119 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0120 __EH_epilog3_GS"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D C0 8B 45 08 8D 4D CC 8B 75 14 89 45 BC E8 ?? ?? ?? ?? 8B 46 14 BA 00 20 00 00 83 65 FC 00 25 00 30 00 00 8B 4E 1C 8B 7E 18 85 C9 7F 0F 7C 04 85 FF 75 09 3B C2 74 05 6A 06 5F 33 C9 DD 45 1C 89 4D C8 8B CF 3B C2 75 3B D9 C0 D9 E1 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 2A 8D 45 C8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 C8 B9 A0 86 01 00 99 83 C4 0C 33 C2 2B C2 69 C0 97 75 00 00 99 F7 F9 8D 0C 07 8D 41 32 DD D8 8D 4D CC 3B 45 E0 77 08 50 E8 ?? ?? ?? ?? EB 0B 2B 45 E0 6A 00 50 E8 ?? ?? ?? ?? 83 7D E4 10 8B 45 E0 8B 5D D0 89 45 C8 73 03 8D 5D D0 DD 45 1C 8D 45 E8 51 51 DD 1C 24 57 FF 76 14 8B 7D C0 6A 4C 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 FF 75 C8 53 E8 ?? ?? ?? ?? 83 C4 18 8B C8 83 7D E4 10 8B 45 D0 73 03 8D 45 D0 51 50 FF 75 18 56 FF 75 10 8B 75 BC FF 75 0C 56 57 E8 ?? ?? ?? ?? 83 C4 20 8D 4D CC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 1C 00 }
	condition:
		$1
}

rule file_58_1244_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WO@Z"
		size = 295
		refs = "0003 __ehhandler$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WO@Z 0008 __EH_prolog3_GS 001c ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 005c __real@4202a05f20000000 0071 _frexp 00a0 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 00ad ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00da ?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADDH@Z 00e7 _sprintf_s 010e ?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z 0119 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0120 __EH_epilog3_GS"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 4D C0 8B 45 08 8D 4D CC 8B 75 14 89 45 BC E8 ?? ?? ?? ?? 8B 46 14 BA 00 20 00 00 83 65 FC 00 25 00 30 00 00 8B 4E 1C 8B 7E 18 85 C9 7F 0F 7C 04 85 FF 75 09 3B C2 74 05 6A 06 5F 33 C9 DD 45 1C 89 4D C8 8B CF 3B C2 75 3B D9 C0 D9 E1 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 2A 8D 45 C8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 C8 B9 A0 86 01 00 99 83 C4 0C 33 C2 2B C2 69 C0 97 75 00 00 99 F7 F9 8D 0C 07 8D 41 32 DD D8 8D 4D CC 3B 45 E0 77 08 50 E8 ?? ?? ?? ?? EB 0B 2B 45 E0 6A 00 50 E8 ?? ?? ?? ?? 83 7D E4 10 8B 45 E0 8B 5D D0 89 45 C8 73 03 8D 5D D0 DD 45 1C 8D 45 E8 51 51 DD 1C 24 57 FF 76 14 8B 7D C0 6A 4C 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 FF 75 C8 53 E8 ?? ?? ?? ?? 83 C4 18 8B C8 83 7D E4 10 8B 45 D0 73 03 8D 45 D0 51 50 FF 75 18 56 FF 75 10 8B 75 BC FF 75 0C 56 57 E8 ?? ?? ?? ?? 83 C4 20 8D 4D CC E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 1C 00 }
	condition:
		$1
}

rule file_1_361_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPBX@Z"
		size = 93
		refs = "0007 ___security_cookie 001e ??_C@_02BBAHNLBA@?$CFp?$AA@ 002b _sprintf_s 0041 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 53 8B 5D 08 56 8B 75 14 57 50 68 ?? ?? ?? ?? 8D 45 BC 8B F9 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 BC 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_58_1232_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBX@Z"
		size = 93
		refs = "0007 ___security_cookie 001e ??_C@_02BBAHNLBA@?$CFp?$AA@ 002b _sprintf_s 0041 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 53 8B 5D 08 56 8B 75 14 57 50 68 ?? ?? ?? ?? 8D 45 BC 8B F9 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 BC 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_58_1247_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBX@Z"
		size = 93
		refs = "0007 ___security_cookie 001e ??_C@_02BBAHNLBA@?$CFp?$AA@ 002b _sprintf_s 0041 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 53 8B 5D 08 56 8B 75 14 57 50 68 ?? ?? ?? ?? 8D 45 BC 8B F9 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 BC 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 30 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 18 00 }
	condition:
		$1
}

rule file_1_362_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_J@Z"
		size = 112
		refs = "0007 ___security_cookie 0028 ??_C@_02HIKPPMOK@Ld?$AA@ 002f ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z 003e _sprintf_s 0054 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0066 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 20 8B F9 FF 75 1C FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 34 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule file_1_363_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_K@Z"
		size = 112
		refs = "0007 ___security_cookie 0028 ??_C@_02CLHGNPPK@Lu?$AA@ 002f ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABAPADPADPBDH@Z 003e _sprintf_s 0054 ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@DPADI@Z 0066 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 20 8B F9 FF 75 1C FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 34 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule file_58_1233_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@G_J@Z"
		size = 112
		refs = "0007 ___security_cookie 0028 ??_C@_02HIKPPMOK@Ld?$AA@ 002f ?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z 003e _sprintf_s 0054 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0066 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 20 8B F9 FF 75 1C FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 34 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule file_58_1234_1 {
	meta:
		name = "?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@G_K@Z"
		size = 112
		refs = "0007 ___security_cookie 0028 ??_C@_02CLHGNPPK@Lu?$AA@ 002f ?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABAPADPADPBDH@Z 003e _sprintf_s 0054 ?_Iput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPADI@Z 0066 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 20 8B F9 FF 75 1C FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 34 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule file_58_1248_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_W_J@Z"
		size = 112
		refs = "0007 ___security_cookie 0028 ??_C@_02HIKPPMOK@Ld?$AA@ 002f ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z 003e _sprintf_s 0054 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0066 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 20 8B F9 FF 75 1C FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 34 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule file_58_1249_1 {
	meta:
		name = "?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_W_K@Z"
		size = 112
		refs = "0007 ___security_cookie 0028 ??_C@_02CLHGNPPK@Lu?$AA@ 002f ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABAPADPADPBDH@Z 003e _sprintf_s 0054 ?_Iput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPADI@Z 0066 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 4C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 5D 08 8D 45 F4 56 8B 75 14 57 FF 75 20 8B F9 FF 75 1C FF 76 14 68 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 10 50 8D 45 B4 6A 40 50 E8 ?? ?? ?? ?? 50 8D 45 B4 50 FF 75 18 56 FF 75 10 FF 75 0C 53 57 E8 ?? ?? ?? ?? 8B 4D FC 83 C4 34 8B C3 33 CD 5F 5E 5B E8 ?? ?? ?? ?? 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule file_1_364_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_N@Z"
		size = 342
		refs = "0003 __ehhandler$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_N@Z 0008 __EH_prolog3_GS 003c @_guard_check_icall@4 0054 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 005e ??$use_facet@V?$numpunct@D@std@@@std@@YAABV?$numpunct@D@0@ABVlocale@0@@Z 0069 ??1locale@std@@QAE@XZ 0071 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0089 ?truename@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0090 ?falsename@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0099 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@$$QAV12@@Z 00a1 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 00e0 ?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@DI@Z 011a ?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PBDI@Z 014f __EH_epilog3_GS"
	strings:
		$1 = { 6A 4C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 8B 7D 14 8A 45 18 8B 4D 08 89 4D A8 F7 47 14 00 40 00 00 88 45 B4 75 27 0F B6 45 1C 8B 33 50 FF 75 B4 57 FF 75 10 FF 75 0C 51 8B 4E 24 E8 ?? ?? ?? ?? 8B CB FF 56 24 8B 45 A8 E9 01 01 00 00 8D 45 AC 8B CF 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 E8 ?? ?? ?? ?? 59 8D 4D AC 8B F0 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 80 7D 1C 00 8D 45 B8 C7 45 FC 01 00 00 00 8B CE 50 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 50 8D 4D D4 E8 ?? ?? ?? ?? 8D 4D B8 E8 ?? ?? ?? ?? 83 7F 24 00 8B 4D E8 7C 13 7F 06 83 7F 20 00 76 0B 8B 77 20 3B F1 76 04 2B F1 EB 02 33 F6 8B 47 14 25 C0 01 00 00 83 F8 40 74 26 56 FF 75 B4 8D 45 AC FF 75 10 FF 75 0C 50 53 E8 ?? ?? ?? ?? 83 C4 18 33 F6 8B 10 89 55 0C 8B 40 04 89 45 10 EB 06 8B 45 10 8B 55 0C 83 7D EC 10 8B 4D D8 73 03 8D 4D D8 89 4D B0 8B 4D E8 51 FF 75 B0 50 52 8D 45 AC 50 53 E8 ?? ?? ?? ?? 56 FF 75 B4 8B 75 A8 8B 08 89 4D 0C 8B 40 04 83 67 20 00 83 67 24 00 50 51 56 53 89 45 10 E8 ?? ?? ?? ?? 83 C4 30 8D 4D D4 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 18 00 }
	condition:
		$1
}

rule file_1_367_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_N@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AAVios_base@2@D_N@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_468_1 {
	meta:
		name = "__ehhandler$?do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAAVios_base@2@DABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAAVios_base@2@DABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1119_2 {
	meta:
		name = "__ehhandler$?do_put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@GABV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@GABV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1127_2 {
	meta:
		name = "__ehhandler$?do_put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_WABV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_WABV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1238_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@G_N@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@G_N@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1253_1 {
	meta:
		name = "__ehhandler$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_W_N@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_W_N@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A A4 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_369_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MBEDD@Z"
		size = 23
		refs = "000d __Tolower"
	strings:
		$1 = { 55 8B EC 8D 41 08 50 0F B6 45 08 50 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_1_371_1 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MBEDD@Z"
		size = 23
		refs = "000d __Toupper"
	strings:
		$1 = { 55 8B EC 8D 41 08 50 0F B6 45 08 50 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_1_370_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MBEPBDPADPBD@Z"
		size = 68
		refs = "0028 __Tolower"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 53 56 8B 75 08 33 DB 2B C6 39 75 0C 57 1B FF F7 D7 23 F8 74 1D 8D 41 08 89 45 FC 50 0F B6 06 50 E8 ?? ?? ?? ?? 88 06 46 8B 45 FC 43 59 59 3B DF 75 E9 5F 8B C6 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_1_372_1 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MBEPBDPADPBD@Z"
		size = 68
		refs = "0028 __Toupper"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 53 56 8B 75 08 33 DB 2B C6 39 75 0C 57 1B FF F7 D7 23 F8 74 1D 8D 41 08 89 45 FC 50 0F B6 06 50 E8 ?? ?? ?? ?? 88 06 46 8B 45 FC 43 59 59 3B DF 75 E9 5F 8B C6 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_1_373_1 {
	meta:
		name = "?do_truename@?$numpunct@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
		altNames = "?do_positive_sign@?$_Mpunct@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 FF 71 14 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1206_1 {
	meta:
		name = "?do_positive_sign@?$_Mpunct@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 14 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1207_1 {
	meta:
		name = "?do_positive_sign@?$_Mpunct@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 14 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1282_1 {
	meta:
		name = "?do_truename@?$numpunct@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@PBG@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 14 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1283_1 {
	meta:
		name = "?do_truename@?$numpunct@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 28
		refs = "000f ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@PB_W@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 14 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_374_1 {
	meta:
		name = "?do_unshift@?$codecvt@DDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PAD1AAPAD@Z"
		size = 17
	strings:
		$1 = { 55 8B EC 8B 4D 14 8B 45 0C 89 01 33 C0 5D C2 10 00 }
	condition:
		$1
}

rule file_1_376_1 {
	meta:
		name = "?do_widen@?$ctype@D@std@@MBEPBDPBD0PAD@Z"
		size = 31
		refs = "0011 _memcpy"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 2B 4D 08 51 FF 75 08 FF 75 10 E8 ?? ?? ?? ?? 8B 45 0C 83 C4 0C 5D C2 0C 00 }
	condition:
		$1
}

rule file_1_378_1 {
	meta:
		name = "?eq_int_type@?$char_traits@D@std@@SA_NABH0@Z"
		size = 18
		altNames = "??$?8V__ExceptionPtr@@V0@@std@@YA_NABV?$shared_ptr@V__ExceptionPtr@@@0@0@Z ?__ExceptionPtrCompare@@YA_NPBX0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 08 8B 45 0C 3B 08 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_1_379_1 {
	meta:
		name = "?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QBE_NABV12@@Z"
		size = 59
		refs = "000e ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@ABEDXZ"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 80 7F 04 00 75 05 E8 ?? ?? ?? ?? 8B 75 08 80 7E 04 00 75 07 8B CE E8 ?? ?? ?? ?? 33 C0 39 07 75 06 39 06 74 06 EB 07 39 06 74 03 33 C0 40 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1298_1 {
	meta:
		name = "?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QBE_NABV12@@Z"
		size = 59
		refs = "000e ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@ABEGXZ"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 80 7F 04 00 75 05 E8 ?? ?? ?? ?? 8B 75 08 80 7E 04 00 75 07 8B CE E8 ?? ?? ?? ?? 33 C0 39 07 75 06 39 06 74 06 EB 07 39 06 74 03 33 C0 40 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1299_1 {
	meta:
		name = "?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QBE_NABV12@@Z"
		size = 59
		refs = "000e ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@ABE_WXZ"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 80 7F 04 00 75 05 E8 ?? ?? ?? ?? 8B 75 08 80 7E 04 00 75 07 8B CE E8 ?? ?? ?? ?? 33 C0 39 07 75 06 39 06 74 06 EB 07 39 06 74 03 33 C0 40 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_1_380_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@I@Z"
		size = 33
		refs = "0010 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 001c ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B F1 39 46 14 72 0D 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_1302_1 {
	meta:
		name = "?erase@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@I@Z"
		size = 33
		refs = "0010 ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z 001c ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B F1 39 46 14 72 0D 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_58_1304_1 {
	meta:
		name = "?erase@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@I@Z"
		size = 33
		refs = "0010 ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z 001c ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8B F1 39 46 14 72 0D 50 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 04 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_381_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@II@Z"
		size = 107
		refs = "0020 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 004b _memmove 0066 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 56 8B F1 8B 4D 08 57 8B 7E 14 3B F9 72 52 8B 55 0C 8B C7 2B C1 3B C2 77 0A 51 8B CE E8 ?? ?? ?? ?? EB 35 85 D2 74 31 83 7E 18 10 72 05 8B 46 04 EB 03 8D 46 04 2B FA 53 8D 1C 08 8B C7 2B C1 74 0E 50 8D 04 13 50 53 E8 ?? ?? ?? ?? 83 C4 0C 57 8B CE E8 ?? ?? ?? ?? 5B 5F 8B C6 5E 5D C2 08 00 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_382_1 {
	meta:
		name = "?falsename@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 42
		refs = "0017 @_guard_check_icall@4"
		altNames = "?curr_symbol@?$_Mpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?curr_symbol@?$_Mpunct@G@std@@QBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?curr_symbol@?$_Mpunct@_W@std@@QBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ ?falsename@?$numpunct@G@std@@QBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?falsename@?$numpunct@_W@std@@QBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 56 57 FF 75 08 8B F9 8B 17 8B 72 18 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 45 08 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_385_1 {
	meta:
		name = "?getloc@ios_base@std@@QBE?AVlocale@2@XZ"
		size = 28
		refs = "000f ??0locale@std@@QAE@ABV01@@Z"
	strings:
		$1 = { 55 8B EC 51 FF 71 30 8B 4D 08 83 65 FC 00 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_386_1 {
	meta:
		name = "?global@locale@std@@SA?AV12@ABV12@@Z"
		size = 232
		refs = "0003 __ehhandler$?global@locale@std@@SA?AV12@ABV12@@Z 0008 __EH_prolog3 0019 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 002f ??0_Lockit@std@@QAE@H@Z 003b ?_Getgloballocale@locale@std@@CAPAV_Locimp@12@XZ 0055 @_guard_check_icall@4 007c ?_Setgloballocale@locale@std@@CAXPAX@Z 00a9 _setlocale 00db ??1_Lockit@std@@QAE@XZ 00e3 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D F0 33 DB 43 53 89 5D FC E8 ?? ?? ?? ?? 59 8B 4D 08 89 41 04 57 8D 4D EC 89 7D FC 89 5D F0 E8 ?? ?? ?? ?? C7 45 FC 02 00 00 00 E8 ?? ?? ?? ?? 8B D8 8B 45 0C 3B 58 04 0F 84 8A 00 00 00 8B 03 8B 70 08 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 8B D8 85 DB 74 11 8B 03 6A 01 8B 30 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 8B 45 0C 8B 58 04 53 E8 ?? ?? ?? ?? 8B 03 59 8B 70 04 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 8B 73 10 83 E6 3F 83 FE 3F 75 15 8B 43 18 85 C0 75 03 8D 43 1C 50 57 E8 ?? ?? ?? ?? 59 59 EB 26 33 C0 8B CF 40 D3 E0 D1 F8 85 C6 74 13 8B 43 18 85 C0 75 03 8D 43 1C 50 57 E8 ?? ?? ?? ?? 59 59 47 83 FF 05 7E DA 8D 4D EC E8 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_388_1 {
	meta:
		name = "__unwindfunclet$?global@locale@std@@SA?AV12@ABV12@@Z$0"
		size = 25
		refs = "0014 ??1locale@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_90_482_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@D@std@@MBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@PBD0@Z$0"
		size = 25
		refs = "0014 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_1277_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@G@std@@MBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@PBG0@Z$0"
		size = 25
		refs = "0014 ??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_58_1280_1 {
	meta:
		name = "__unwindfunclet$?do_transform@?$collate@_W@std@@MBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@PB_W0@Z$0"
		size = 25
		refs = "0014 ??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0C 00 00 00 83 65 F0 FE 8B 4D 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_1_392_1 {
	meta:
		name = "?grouping@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 42
		refs = "0017 @_guard_check_icall@4"
		altNames = "?grouping@?$_Mpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$_Mpunct@G@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$_Mpunct@_W@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$numpunct@G@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$numpunct@_W@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 56 57 FF 75 08 8B F9 8B 17 8B 72 14 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 45 08 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_393_1 {
	meta:
		name = "?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@IID@Z"
		size = 151
		refs = "002e ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0060 _memmove 006f ?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXIID@Z 0079 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 008b ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ 0092 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 56 8B F1 57 8B 4E 14 3B CB 72 75 8B 7D 0C 8B C1 F7 D0 3B C7 76 71 8D 04 39 89 45 FC 85 FF 74 55 6A 00 50 8B CE E8 ?? ?? ?? ?? 84 C0 74 47 83 7E 18 10 8D 4E 04 72 04 8B 11 EB 02 8B D1 83 7E 18 10 72 02 8B 09 8B 46 14 2B C3 74 13 50 8D 04 1A 50 8D 04 19 03 C7 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 10 8B CE 57 53 E8 ?? ?? ?? ?? FF 75 FC 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 8B E5 5D C2 0C 00 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_1_394_1 {
	meta:
		name = "?length@?$char_traits@D@std@@SAIPBD@Z"
		size = 29
	strings:
		$1 = { 55 8B EC 8B 45 08 80 38 00 75 04 33 C0 5D C3 8D 50 01 8A 08 40 84 C9 75 F9 2B C2 5D C3 }
	condition:
		$1
}

rule file_1_402_1 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z"
		size = 17
		refs = "0009 ?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXID@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_4_275_2 {
	meta:
		name = "?clear@ios_base@std@@QAEXH@Z"
		size = 17
		refs = "0009 ?clear@ios_base@std@@QAEXH_N@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1374_1 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z"
		size = 17
		refs = "0009 ?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXIG@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1376_1 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z"
		size = 17
		refs = "0009 ?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI_W@Z"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule file_1_403_1 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXID@Z"
		size = 35
		refs = "000d ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 001b ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 41 14 77 08 50 E8 ?? ?? ?? ?? EB 0C FF 75 0C 2B 41 14 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_58_1375_1 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXIG@Z"
		size = 35
		refs = "000d ?_Eos@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEXI@Z 001b ?append@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QAEAAV12@IG@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 41 14 77 08 50 E8 ?? ?? ?? ?? EB 0C FF 75 0C 2B 41 14 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_58_1377_1 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI_W@Z"
		size = 35
		refs = "000d ?_Eos@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEXI@Z 001b ?append@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QAEAAV12@I_W@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 3B 41 14 77 08 50 E8 ?? ?? ?? ?? EB 0C FF 75 0C 2B 41 14 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_1_404_1 {
	meta:
		name = "?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHXZ"
		size = 61
		refs = "0032 @_guard_check_icall@4"
	strings:
		$1 = { 57 8B F9 33 C9 8B 47 1C 39 08 74 05 8B 47 2C 8B 08 85 C9 7E 14 8B 47 2C FF 08 8B 4F 1C 5F 8B 11 8D 42 01 89 01 0F B6 02 C3 8B 07 56 8B 70 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5E 5F C3 }
	condition:
		$1
}

rule file_1_405_1 {
	meta:
		name = "?sgetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHXZ"
		size = 50
		refs = "0027 @_guard_check_icall@4"
	strings:
		$1 = { 57 8B F9 8B 47 1C 8B 08 85 C9 74 07 8B 47 2C 8B 00 EB 02 33 C0 85 C0 7E 05 0F B6 01 5F C3 8B 07 56 8B 70 18 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5E 5F C3 }
	condition:
		$1
}

rule file_1_407_1 {
	meta:
		name = "?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QAEHD@Z"
		size = 77
		refs = "003f @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 57 8B F9 33 C9 8B 47 20 39 08 74 05 8B 47 30 8B 08 85 C9 7E 19 8B 47 30 FF 08 8B 4F 20 8B 11 8D 42 01 89 01 8A 45 08 88 02 0F B6 C0 EB 17 8B 0F 0F B6 45 08 56 50 8B 71 0C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5E 5F 5D C2 04 00 }
	condition:
		$1
}

rule file_1_408_1 {
	meta:
		name = "?thousands_sep@?$numpunct@D@std@@QBEDXZ"
		size = 23
		refs = "000c @_guard_check_icall@4"
		altNames = "?thousands_sep@?$_Mpunct@D@std@@QBEDXZ ?thousands_sep@?$_Mpunct@G@std@@QBEGXZ ?thousands_sep@?$_Mpunct@_W@std@@QBE_WXZ ?thousands_sep@?$numpunct@G@std@@QBEGXZ ?thousands_sep@?$numpunct@_W@std@@QBE_WXZ"
	strings:
		$1 = { 56 57 8B F9 8B 07 8B 70 10 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5F 5E C3 }
	condition:
		$1
}

rule file_1_411_1 {
	meta:
		name = "?truename@?$numpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 42
		refs = "0017 @_guard_check_icall@4"
		altNames = "?positive_sign@?$_Mpunct@D@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?positive_sign@?$_Mpunct@G@std@@QBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?positive_sign@?$_Mpunct@_W@std@@QBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ ?truename@?$numpunct@G@std@@QBE?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?truename@?$numpunct@_W@std@@QBE?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 56 57 FF 75 08 8B F9 8B 17 8B 72 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 45 08 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_1_413_1 {
	meta:
		name = "?widen@?$ctype@D@std@@QBEPBDPBD0PAD@Z"
		size = 38
		refs = "0018 @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 10 8B F9 FF 75 0C FF 75 08 8B 07 8B 70 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5F 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_1_414_1 {
	meta:
		name = "?width@ios_base@std@@QAE_J_J@Z"
		size = 27
	strings:
		$1 = { 55 8B EC 8B 41 20 8B 51 24 56 8B 75 08 89 71 20 8B 75 0C 89 71 24 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_1_419_1 {
	meta:
		name = "_frexpl"
		size = 24
		refs = "000f _frexp"
	strings:
		$1 = { 55 8B EC FF 75 10 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1_421_1 {
	meta:
		name = "_ldexpl"
		size = 24
		refs = "000f _ldexp"
	strings:
		$1 = { 55 8B EC FF 75 10 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_1_420_1 {
	meta:
		name = "_ldexpf"
		size = 33
		refs = "0010 _ldexp"
	strings:
		$1 = { 55 8B EC 51 FF 75 0C D9 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_422_1 {
	meta:
		name = "_powf"
		size = 25
		refs = "000b __CIpow"
	strings:
		$1 = { 55 8B EC 51 D9 45 08 D9 45 0C E8 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "__LDtento"
		size = 338
		refs = "000a ___security_cookie 0047 __real@4024000000000000 0056 __LXp_setw 0060 _tenth 006c __LXp_movx 0075 __LXp_ldexpx 0090 __LXp_mulx 00df __LXp_getw 00fa __LInf 0119 __errno 014a @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 90 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 53 8B 5D 0C 89 85 78 FF FF FF 57 8B 7D 08 85 DB 0F 84 0C 01 00 00 DD 07 D9 EE DA E9 DF E0 F6 C4 44 0F 8B FB 00 00 00 8D 45 DC 56 85 DB 7E 1A DD 05 ?? ?? ?? ?? 51 51 DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 1D 68 ?? ?? ?? ?? 6A 04 5E 56 50 F7 DB E8 ?? ?? ?? ?? 6A 68 56 57 E8 ?? ?? ?? ?? 83 C4 18 F6 C3 01 74 16 8D 85 7C FF FF FF 50 56 8D 45 DC 50 56 57 E8 ?? ?? ?? ?? 83 C4 14 D1 FB 74 29 8D 45 DC 50 8D 45 BC 56 50 E8 ?? ?? ?? ?? 8D 85 7C FF FF FF 50 56 8D 45 BC 50 8D 45 DC 56 50 E8 ?? ?? ?? ?? 83 C4 20 EB B8 D9 E8 DC 5D DC DF E0 F6 C4 41 75 0C 6A 98 56 57 E8 ?? ?? ?? ?? 83 C4 0C 56 57 E8 ?? ?? ?? ?? DD 95 70 FF FF FF D9 EE 83 C4 08 DD E9 DF E0 5E F6 C4 44 7B 1E DD 05 ?? ?? ?? ?? DD E1 DF E0 F6 C4 44 7B 0D D9 E0 DD E9 DF E0 F6 C4 44 7A 30 EB 02 DD D8 DD D8 E8 ?? ?? ?? ?? DD 85 70 FF FF FF C7 00 22 00 00 00 8B 85 78 FF FF FF 85 C0 74 0F 83 08 01 EB 0A 6A 04 57 E8 ?? ?? ?? ?? 59 59 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_0_1 {
	meta:
		name = "__Dtento"
		size = 338
		refs = "000a ___security_cookie 0047 __real@4024000000000000 0056 __Xp_setw 0060 _tenth 006c __Xp_movx 0075 __Xp_ldexpx 0090 __Xp_mulx 00df __Xp_getw 00fa __Inf 0119 __errno 014a @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 90 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 53 8B 5D 0C 89 85 78 FF FF FF 57 8B 7D 08 85 DB 0F 84 0C 01 00 00 DD 07 D9 EE DA E9 DF E0 F6 C4 44 0F 8B FB 00 00 00 8D 45 DC 56 85 DB 7E 1A DD 05 ?? ?? ?? ?? 51 51 DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 1D 68 ?? ?? ?? ?? 6A 04 5E 56 50 F7 DB E8 ?? ?? ?? ?? 6A 68 56 57 E8 ?? ?? ?? ?? 83 C4 18 F6 C3 01 74 16 8D 85 7C FF FF FF 50 56 8D 45 DC 50 56 57 E8 ?? ?? ?? ?? 83 C4 14 D1 FB 74 29 8D 45 DC 50 8D 45 BC 56 50 E8 ?? ?? ?? ?? 8D 85 7C FF FF FF 50 56 8D 45 BC 50 8D 45 DC 56 50 E8 ?? ?? ?? ?? 83 C4 20 EB B8 D9 E8 DC 5D DC DF E0 F6 C4 41 75 0C 6A 98 56 57 E8 ?? ?? ?? ?? 83 C4 0C 56 57 E8 ?? ?? ?? ?? DD 95 70 FF FF FF D9 EE 83 C4 08 DD E9 DF E0 5E F6 C4 44 7B 1E DD 05 ?? ?? ?? ?? DD E1 DF E0 F6 C4 44 7B 0D D9 E0 DD E9 DF E0 F6 C4 44 7A 30 EB 02 DD D8 DD D8 E8 ?? ?? ?? ?? DD 85 70 FF FF FF C7 00 22 00 00 00 8B 85 78 FF FF FF 85 C0 74 0F 83 08 01 EB 0A 6A 04 57 E8 ?? ?? ?? ?? 59 59 8B 4D FC 5F 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_4_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 24
		refs = "000e ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 33 C0 89 06 89 46 14 89 46 18 E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_58_11_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z"
		size = 24
		refs = "000e ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 33 C0 89 06 89 46 14 89 46 18 E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_58_13_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAE@$$QAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z"
		size = 24
		refs = "000e ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QAEXXZ"
	strings:
		$1 = { 56 8B F1 33 C0 89 06 89 46 14 89 46 18 E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_3_6_1 {
	meta:
		name = "??$_Fgetc@_W@std@@YA_NAA_WPAU_iobuf@@@Z"
		size = 39
		refs = "0007 _fgetwc"
		altNames = "??$_Fgetc@G@std@@YA_NAAGPAU_iobuf@@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C E8 ?? ?? ?? ?? 59 0F B7 C8 B8 FF FF 00 00 66 3B C8 75 04 32 C0 5D C3 8B 45 08 66 89 08 B0 01 5D C3 }
	condition:
		$1
}

rule file_3_7_1 {
	meta:
		name = "??$_Fputc@_W@std@@YA_N_WPAU_iobuf@@@Z"
		size = 31
		refs = "000a _fputwc"
		altNames = "??$_Fputc@G@std@@YA_NGPAU_iobuf@@@Z"
	strings:
		$1 = { 55 8B EC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 BA FF FF 00 00 33 C9 66 3B C2 0F 95 C0 5D C3 }
	condition:
		$1
}

rule file_3_8_1 {
	meta:
		name = "??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ"
		size = 54
		refs = "0001 ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@51 0012 ??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ@YAXXZ 0018 ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 001c ??_7_Iostream_error_category@std@@6B@ 002b _atexit"
	strings:
		$1 = { A1 ?? ?? ?? ?? A8 01 75 27 83 C8 01 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 05 00 00 00 E8 ?? ?? ?? ?? 59 B8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_12_1 {
	meta:
		name = "??$_Ungetc@_W@std@@YA_NAB_WPAU_iobuf@@@Z"
		size = 35
		refs = "000e _ungetwc"
		altNames = "??$_Ungetc@G@std@@YA_NABGPAU_iobuf@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 75 0C 0F B7 00 50 E8 ?? ?? ?? ?? 59 59 BA FF FF 00 00 33 C9 66 3B C2 0F 95 C0 5D C3 }
	condition:
		$1
}

rule file_3_41_1 {
	meta:
		name = "??0?$_Immortalizer@V_Iostream_error_category@std@@@std@@QAE@XZ"
		size = 20
		refs = "0006 ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { 85 C9 74 0D C7 01 ?? ?? ?? ?? C7 41 04 05 00 00 00 8B C1 C3 }
	condition:
		$1
}

rule file_3_44_1 {
	meta:
		name = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z"
		size = 33
		altNames = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PBGPBU_Container_base12@1@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PB_WPBU_Container_base12@1@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 21 00 83 61 04 00 89 41 08 8B 45 0C 85 C0 74 04 8B 00 89 01 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_3_45_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PADPBU_Container_base12@1@@Z"
		size = 24
		refs = "000d ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 0C 8B F1 FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_58_245_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PAGPBU_Container_base12@1@@Z"
		size = 24
		refs = "000d ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QAE@PBGPBU_Container_base12@1@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 0C 8B F1 FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_58_247_1 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PA_WPBU_Container_base12@1@@Z"
		size = 24
		refs = "000d ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QAE@PB_WPBU_Container_base12@1@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 0C 8B F1 FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_3_53_1 {
	meta:
		name = "??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 42
		refs = "000b ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0018 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 001d ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 55 8B EC 51 56 8B F1 89 75 FC E8 ?? ?? ?? ?? 6A 00 FF 75 08 8B CE C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_23_53_1 {
	meta:
		name = "??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 42
		refs = "000b ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ 0018 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 001d ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 55 8B EC 51 56 8B F1 89 75 FC E8 ?? ?? ?? ?? 6A 00 FF 75 08 8B CE C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_56_53_1 {
	meta:
		name = "??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAE@PAU_iobuf@@@Z"
		size = 42
		refs = "000b ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0018 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 001d ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 55 8B EC 51 56 8B F1 89 75 FC E8 ?? ?? ?? ?? 6A 00 FF 75 08 8B CE C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_54_1 {
	meta:
		name = "??0?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAE@XZ"
		size = 19
		refs = "000b ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B C1 C7 01 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_54_1 {
	meta:
		name = "??0?$basic_ios@DU?$char_traits@D@std@@@std@@IAE@XZ"
		size = 19
		refs = "000b ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B C1 C7 01 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_56_54_1 {
	meta:
		name = "??0?$basic_ios@GU?$char_traits@G@std@@@std@@IAE@XZ"
		size = 19
		refs = "000b ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 89 4D FC 8B C1 C7 01 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_55_1 {
	meta:
		name = "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 103
		refs = "0003 __ehhandler$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0008 __EH_prolog3 001d ??_8?$basic_ostream@_WU?$char_traits@_W@std@@@std@@7B@ 0024 ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 0041 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0059 ?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAEXPAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z 0060 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 EC 83 65 F0 00 83 7D 10 00 74 18 C7 06 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 83 65 FC 00 C7 45 F0 01 00 00 00 8B 06 FF 75 0C FF 75 08 8B 40 04 C7 04 06 ?? ?? ?? ?? 8B 06 8B 48 04 8D 41 F8 89 44 31 FC 8B 06 8B 48 04 03 CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_23_55_1 {
	meta:
		name = "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 103
		refs = "0003 __ehhandler$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0008 __EH_prolog3 001d ??_8?$basic_ostream@DU?$char_traits@D@std@@@std@@7B@ 0024 ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 0041 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0059 ?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IAEXPAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z 0060 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 EC 83 65 F0 00 83 7D 10 00 74 18 C7 06 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 83 65 FC 00 C7 45 F0 01 00 00 00 8B 06 FF 75 0C FF 75 08 8B 40 04 C7 04 06 ?? ?? ?? ?? 8B 06 8B 48 04 8D 41 F8 89 44 31 FC 8B 06 8B 48 04 03 CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_68_55_1 {
	meta:
		name = "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 103
		refs = "0003 __ehhandler$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0008 __EH_prolog3 001d ??_8?$basic_ostream@GU?$char_traits@G@std@@@std@@7B@ 0024 ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 0041 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0059 ?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IAEXPAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z 0060 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 EC 83 65 F0 00 83 7D 10 00 74 18 C7 06 ?? ?? ?? ?? C7 46 08 ?? ?? ?? ?? 83 65 FC 00 C7 45 F0 01 00 00 00 8B 06 FF 75 0C FF 75 08 8B 40 04 C7 04 06 ?? ?? ?? ?? 8B 06 8B 48 04 8D 41 F8 89 44 31 FC 8B 06 8B 48 04 03 CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_3_56_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z$0"
		size = 28
		refs = "0017 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0F 00 00 00 83 65 F0 FE 8B 4D EC 83 C1 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_23_56_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z$0"
		size = 28
		refs = "0017 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0F 00 00 00 83 65 F0 FE 8B 4D EC 83 C1 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_68_56_1 {
	meta:
		name = "__unwindfunclet$??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z$0"
		size = 28
		refs = "0017 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
	strings:
		$1 = { 8B 45 F0 83 E0 01 0F 84 0F 00 00 00 83 65 F0 FE 8B 4D EC 83 C1 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_58_1 {
	meta:
		name = "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ"
		size = 71
		refs = "0003 __ehhandler$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0008 __EH_prolog3 0012 ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@ 0017 ??2@YAPAXI@Z 0029 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 003b ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXXZ 0042 __EH_epilog3"
	strings:
		$1 = { 6A 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 6A 08 C7 07 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 11 83 65 FC 00 6A 01 E8 ?? ?? ?? ?? 59 89 46 04 EB 02 33 F6 8B CF 89 77 34 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_23_58_1 {
	meta:
		name = "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ"
		size = 71
		refs = "0003 __ehhandler$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ 0008 __EH_prolog3 0012 ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@ 0017 ??2@YAPAXI@Z 0029 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 003b ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAEXXZ 0042 __EH_epilog3"
	strings:
		$1 = { 6A 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 6A 08 C7 07 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 11 83 65 FC 00 6A 01 E8 ?? ?? ?? ?? 59 89 46 04 EB 02 33 F6 8B CF 89 77 34 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_56_58_1 {
	meta:
		name = "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ"
		size = 71
		refs = "0003 __ehhandler$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0008 __EH_prolog3 0012 ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@ 0017 ??2@YAPAXI@Z 0029 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 003b ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXXZ 0042 __EH_epilog3"
	strings:
		$1 = { 6A 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F9 6A 08 C7 07 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 59 85 F6 74 11 83 65 FC 00 6A 01 E8 ?? ?? ?? ?? 59 89 46 04 EB 02 33 F6 8B CF 89 77 34 E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_61_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z"
		size = 99
		refs = "0006 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z 0014 ___security_cookie 0031 ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ 0040 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 004a ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEX$$QAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 57 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 33 FF 89 3E 89 7E 14 89 7E 18 E8 ?? ?? ?? ?? 57 8B CE C7 46 18 0F 00 00 00 E8 ?? ?? ?? ?? FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_63_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z"
		size = 73
		refs = "0003 __ehhandler$??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 0008 __EH_prolog3 001c ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QAEXXZ 002e ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 003b ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z 0042 __EH_epilog3"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 F0 33 FF 89 3E 89 7E 14 89 7E 18 E8 ?? ?? ?? ?? 57 8B CE 89 7D FC C7 46 18 0F 00 00 00 E8 ?? ?? ?? ?? 6A FF 57 FF 75 08 8B CE E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_3_74_1 {
	meta:
		name = "??0?$codecvt@_WDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 57
		refs = "001a ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 001f __Getcvt"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 53 8B D9 56 57 89 5D FC 89 43 04 8D 45 D0 50 C7 03 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 6A 0B 59 8D 7B 08 8B F0 F3 A5 5F 5E 8B C3 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_56_74_1 {
	meta:
		name = "??0?$codecvt@GDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 57
		refs = "001a ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 001f __Getcvt"
	strings:
		$1 = { 55 8B EC 83 EC 30 8B 45 0C 53 8B D9 56 57 89 5D FC 89 43 04 8D 45 D0 50 C7 03 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 6A 0B 59 8D 7B 08 8B F0 F3 A5 5F 5E 8B C3 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_75_1 {
	meta:
		name = "??0?$ctype@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 39
		refs = "0015 ??_7?$ctype@_W@std@@6B@ 001a ?_Init@?$ctype@_W@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 56 FF 75 08 8B F1 89 75 FC 89 46 04 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_56_75_1 {
	meta:
		name = "??0?$ctype@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 39
		refs = "0015 ??_7?$ctype@G@std@@6B@ 001a ?_Init@?$ctype@G@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 56 FF 75 08 8B F1 89 75 FC 89 46 04 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_76_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QAE@U_Mbstatet@@_J@Z"
		size = 40
	strings:
		$1 = { 55 8B EC 8B 45 10 83 21 00 83 61 04 00 89 41 08 8B 45 14 89 41 0C 8B 45 08 89 41 10 8B 45 0C 89 41 14 8B C1 5D C2 10 00 }
	condition:
		$1
}

rule file_3_77_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QAE@_J@Z"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 45 08 89 01 8B 45 0C 89 41 04 33 C0 89 41 08 89 41 0C 89 41 10 89 41 14 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_3_82_1 {
	meta:
		name = "??0_Generic_error_category@std@@QAE@XZ"
		size = 16
		refs = "0002 ??_7_Generic_error_category@std@@6B@"
	strings:
		$1 = { C7 01 ?? ?? ?? ?? 8B C1 C7 41 04 03 00 00 00 C3 }
	condition:
		$1
}

rule file_3_83_1 {
	meta:
		name = "??0_Init_wcerr@std@@QAE@XZ"
		size = 48
		refs = "0001 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000d ?_Ptr_wcerr@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0015 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? 56 BE ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 40 04 83 4C 30 14 02 8B C1 5E C3 }
	condition:
		$1
}

rule file_37_83_1 {
	meta:
		name = "??0_Init_cerr@std@@QAE@XZ"
		size = 48
		refs = "0001 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000d ?_Ptr_cerr@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0015 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? 56 BE ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 40 04 83 4C 30 14 02 8B C1 5E C3 }
	condition:
		$1
}

rule file_69_83_1 {
	meta:
		name = "??0_Init_ushcerr@std@@QAE@XZ"
		size = 48
		refs = "0001 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000d ?_Ptr_wcerr@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0015 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? 56 BE ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 40 04 83 4C 30 14 02 8B C1 5E C3 }
	condition:
		$1
}

rule file_3_84_1 {
	meta:
		name = "??0_Iostream_error_category@std@@QAE@XZ"
		size = 16
		refs = "0002 ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { C7 01 ?? ?? ?? ?? 8B C1 C7 41 04 05 00 00 00 C3 }
	condition:
		$1
}

rule file_3_95_1 {
	meta:
		name = "??0_System_error@std@@IAE@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 107
		refs = "0007 ___security_cookie 0020 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ABV01@@Z 002f ?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z 003a ??0runtime_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0042 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0059 ??_7_System_error@std@@6B@ 0061 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 56 83 EC 1C 8B F1 8B CC 89 75 DC 50 E8 ?? ?? ?? ?? FF 75 0C 8D 45 E0 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 28 8B CE 50 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 4D 08 8B C6 89 4E 0C 8B 4D 0C 89 4E 10 8B 4D FC C7 06 ?? ?? ?? ?? 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_96_1 {
	meta:
		name = "??0_System_error@std@@QAE@ABV01@@Z"
		size = 42
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7_System_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 56 8B F9 E8 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 8B 46 0C 89 47 0C 8B 46 10 89 47 10 8B C7 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_25_3_1 {
	meta:
		name = "??0future_error@std@@QAE@ABV01@@Z"
		size = 42
		refs = "000c ??0exception@std@@QAE@ABV01@@Z 0012 ??_7future_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 56 8B F9 E8 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 8B 46 0C 89 47 0C 8B 46 10 89 47 10 8B C7 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_102_1 {
	meta:
		name = "??0error_code@std@@QAE@HABVerror_category@1@@Z"
		size = 20
		altNames = "??0?$_Smanip@H@std@@QAE@P6AXAAVios_base@1@H@ZH@Z ??0_Fac_node@std@@QAE@PAU01@PAV_Facet_base@1@@Z ??0error_condition@std@@QAE@HABVerror_category@1@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 01 8B 45 0C 89 41 04 8B C1 5D C2 08 00 }
	condition:
		$1
}

rule file_3_109_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@PBDABVerror_code@2@@Z"
		size = 41
		refs = "0016 ??0system_error@std@@QAE@Verror_code@1@PBD@Z 001c ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 56 FF 75 08 8B F1 FF 70 04 89 75 FC FF 30 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_116_1 {
	meta:
		name = "??0runtime_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 48
		refs = "001d ??0exception@std@@QAE@QBD@Z 0023 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 55 8B EC 51 8B 45 08 56 8B F1 89 75 FC 83 78 18 10 72 05 8B 40 04 EB 03 83 C0 04 50 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_119_1 {
	meta:
		name = "??0system_error@std@@QAE@Verror_code@1@PBD@Z"
		size = 74
		refs = "0003 __ehhandler$??0system_error@std@@QAE@Verror_code@1@PBD@Z 0008 __EH_prolog3_GS 0019 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 002e ??0_System_error@std@@IAE@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0036 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 003c ??_7system_error@std@@6B@ 0043 __EH_epilog3_GS"
	strings:
		$1 = { 6A 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 D0 8B 45 10 8D 4D D4 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 D4 50 FF 75 0C 8B CE FF 75 08 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_85_59_1 {
	meta:
		name = "??0system_error@std@@QAE@HABVerror_category@1@PBD@Z"
		size = 74
		refs = "0003 __ehhandler$??0system_error@std@@QAE@HABVerror_category@1@PBD@Z 0008 __EH_prolog3_GS 0019 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 002e ??0_System_error@std@@IAE@Verror_code@1@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0036 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 003c ??_7system_error@std@@6B@ 0043 __EH_epilog3_GS"
	strings:
		$1 = { 6A 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 D0 8B 45 10 8D 4D D4 50 E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 D4 50 FF 75 0C 8B CE FF 75 08 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2 0C 00 }
	condition:
		$1
}

rule file_3_121_1 {
	meta:
		name = "__ehhandler$??0system_error@std@@QAE@Verror_code@1@PBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??0system_error@std@@QAE@Verror_code@1@PBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_61_1 {
	meta:
		name = "__ehhandler$??0system_error@std@@QAE@HABVerror_category@1@PBD@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??0system_error@std@@QAE@HABVerror_category@1@PBD@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_81_1 {
	meta:
		name = "__ehhandler$??0system_error@std@@QAE@Verror_code@1@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$??0system_error@std@@QAE@Verror_code@1@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_130_1 {
	meta:
		name = "__ehhandler$?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_199_1 {
	meta:
		name = "__ehhandler$?message@_System_error_category@std@@UBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?message@_System_error_category@std@@UBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A CC 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_131_1 {
	meta:
		name = "??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 90
		refs = "0006 __ehhandler$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0013 ___security_cookie 002b ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 0032 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAEXXZ 003f ?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAEPAV12@XZ 0046 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 83 7E 4C 00 C7 06 ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 80 7E 48 00 74 07 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_132_1 {
	meta:
		name = "??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 90
		refs = "0006 __ehhandler$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0013 ___security_cookie 002b ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 0032 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAEXXZ 003f ?close@?$basic_filebuf@DU?$char_traits@D@std@@@std@@QAEPAV12@XZ 0046 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 83 7E 4C 00 C7 06 ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 80 7E 48 00 74 07 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_56_131_1 {
	meta:
		name = "??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 90
		refs = "0006 __ehhandler$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0013 ___security_cookie 002b ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 0032 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAEXXZ 003f ?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAEPAV12@XZ 0046 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 83 7E 4C 00 C7 06 ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 80 7E 48 00 74 07 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_133_1 {
	meta:
		name = "??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 66
		refs = "0006 __ehhandler$??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0012 ___security_cookie 0029 ??_7ios_base@std@@6B@ 002e ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 83 65 FC 00 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_134_1 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 66
		refs = "0006 __ehhandler$??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ 0012 ___security_cookie 0029 ??_7ios_base@std@@6B@ 002e ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 83 65 FC 00 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_56_133_1 {
	meta:
		name = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 66
		refs = "0006 __ehhandler$??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ 0012 ___security_cookie 0029 ??_7ios_base@std@@6B@ 002e ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 83 65 FC 00 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_135_1 {
	meta:
		name = "__ehhandler$??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_136_1 {
	meta:
		name = "__ehhandler$??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_ios@DU?$char_traits@D@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_135_1 {
	meta:
		name = "__ehhandler$??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_ios@GU?$char_traits@G@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_100_83_1 {
	meta:
		name = "__ehhandler$??1_UShinit@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_UShinit@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_63_2 {
	meta:
		name = "__ehhandler$??1_Winit@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Winit@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_128_2 {
	meta:
		name = "__ehhandler$??1ios_base@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1ios_base@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_143_2 {
	meta:
		name = "__ehhandler$??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_172_1 {
	meta:
		name = "__ehhandler$??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_D?$basic_istream@GU?$char_traits@G@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_15_142_2 {
	meta:
		name = "__ehhandler$??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_D?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_120_143_2 {
	meta:
		name = "__ehhandler$??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_142_2 {
	meta:
		name = "__ehhandler$??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_142_2 {
	meta:
		name = "__ehhandler$??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_136_1 {
	meta:
		name = "??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 28
		refs = "000a ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 8B 41 F8 8B 40 04 C7 44 08 F8 ?? ?? ?? ?? 8B 41 F8 8B 50 04 8D 42 F8 89 44 0A F4 C3 }
	condition:
		$1
}

rule file_23_137_1 {
	meta:
		name = "??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 28
		refs = "000a ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 8B 41 F8 8B 40 04 C7 44 08 F8 ?? ?? ?? ?? 8B 41 F8 8B 50 04 8D 42 F8 89 44 0A F4 C3 }
	condition:
		$1
}

rule file_68_136_1 {
	meta:
		name = "??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 28
		refs = "000a ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 8B 41 F8 8B 40 04 C7 44 08 F8 ?? ?? ?? ?? 8B 41 F8 8B 50 04 8D 42 F8 89 44 0A F4 C3 }
	condition:
		$1
}

rule file_3_137_1 {
	meta:
		name = "??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 33
		refs = "0006 ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@ 0011 ??1locale@std@@QAE@XZ 0019 ??3@YAXPAXI@Z"
	strings:
		$1 = { 56 8B 71 34 C7 01 ?? ?? ?? ?? 85 F6 74 11 8B CE E8 ?? ?? ?? ?? 6A 08 56 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_23_138_1 {
	meta:
		name = "??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 33
		refs = "0006 ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@ 0011 ??1locale@std@@QAE@XZ 0019 ??3@YAXPAXI@Z"
	strings:
		$1 = { 56 8B 71 34 C7 01 ?? ?? ?? ?? 85 F6 74 11 8B CE E8 ?? ?? ?? ?? 6A 08 56 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_56_137_1 {
	meta:
		name = "??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 33
		refs = "0006 ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@ 0011 ??1locale@std@@QAE@XZ 0019 ??3@YAXPAXI@Z"
	strings:
		$1 = { 56 8B 71 34 C7 01 ?? ?? ?? ?? 85 F6 74 11 8B CE E8 ?? ?? ?? ?? 6A 08 56 E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_3_140_1 {
	meta:
		name = "??1?$ctype@_W@std@@MAE@XZ"
		size = 41
		refs = "0009 ??_7?$ctype@_W@std@@6B@ 0013 _free 0023 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 83 7E 10 00 C7 06 ?? ?? ?? ?? 74 09 FF 76 0C E8 ?? ?? ?? ?? 59 FF 76 14 E8 ?? ?? ?? ?? 59 C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_56_140_1 {
	meta:
		name = "??1?$ctype@G@std@@MAE@XZ"
		size = 41
		refs = "0009 ??_7?$ctype@G@std@@6B@ 0013 _free 0023 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 56 8B F1 83 7E 10 00 C7 06 ?? ?? ?? ?? 74 09 FF 76 0C E8 ?? ?? ?? ?? 59 FF 76 14 E8 ?? ?? ?? ?? 59 C7 06 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_3_157_1 {
	meta:
		name = "??1ios_base@std@@UAE@XZ"
		size = 62
		refs = "0006 __ehhandler$??1ios_base@std@@UAE@XZ 0012 ___security_cookie 0025 ??_7ios_base@std@@6B@ 002a ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 51 C7 01 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_164_1 {
	meta:
		name = "??8error_category@std@@QBE_NABV01@@Z"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 49 04 3B 48 04 0F 94 C0 5D C2 04 00 }
	condition:
		$1
}

rule file_3_165_1 {
	meta:
		name = "??8std@@YA_NABVerror_condition@0@0@Z"
		size = 40
	strings:
		$1 = { 55 8B EC 8B 55 08 56 8B 75 0C 8B 42 04 8B 4E 04 8B 40 04 3B 41 04 75 0B 8B 02 3B 06 75 05 33 C0 40 EB 02 33 C0 5E 5D C3 }
	condition:
		$1
}

rule file_3_168_1 {
	meta:
		name = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ"
		size = 52
		refs = "0008 __invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 8B 41 08 85 C0 75 05 E9 ?? ?? ?? ?? 8B 09 85 C9 74 F5 8B 09 85 C9 74 EF 83 79 18 10 72 05 8B 51 04 EB 03 8D 51 04 3B D0 77 DD 8B 49 14 03 CA 3B C1 73 D4 C3 }
	condition:
		$1
}

rule file_3_170_1 {
	meta:
		name = "??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ"
		size = 96
		refs = "0006 __ehhandler$??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0012 ___security_cookie 002f ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0047 ??_7ios_base@std@@6B@ 004c ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8D 51 08 8B 42 F8 8B 40 04 C7 44 10 F8 ?? ?? ?? ?? 8B 42 F8 8B 48 04 8D 41 F8 89 44 11 F4 83 65 FC 00 52 C7 02 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_171_1 {
	meta:
		name = "??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ"
		size = 96
		refs = "0006 __ehhandler$??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ 0012 ___security_cookie 002f ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0047 ??_7ios_base@std@@6B@ 004c ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8D 51 08 8B 42 F8 8B 40 04 C7 44 10 F8 ?? ?? ?? ?? 8B 42 F8 8B 48 04 8D 41 F8 89 44 11 F4 83 65 FC 00 52 C7 02 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_170_1 {
	meta:
		name = "??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ"
		size = 96
		refs = "0006 __ehhandler$??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ 0012 ___security_cookie 002f ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0047 ??_7ios_base@std@@6B@ 004c ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8D 51 08 8B 42 F8 8B 40 04 C7 44 10 F8 ?? ?? ?? ?? 8B 42 F8 8B 48 04 8D 41 F8 89 44 11 F4 83 65 FC 00 52 C7 02 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B 4D F4 64 89 0D 00 00 00 00 59 8B E5 5D C3 }
	condition:
		$1
}

rule file_3_174_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 34
		refs = "0007 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 58 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_175_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 34
		refs = "0007 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 58 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_56_174_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 34
		refs = "0007 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 58 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_175_1 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 90
		refs = "0006 __ehhandler$??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z 0013 ___security_cookie 002c ??_7ios_base@std@@6B@ 0031 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0040 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 83 65 FC 00 56 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 59 74 0A 6A 48 56 E8 ?? ?? ?? ?? 59 59 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_23_176_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 90
		refs = "0006 __ehhandler$??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UAEPAXI@Z 0013 ___security_cookie 002c ??_7ios_base@std@@6B@ 0031 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0040 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 83 65 FC 00 56 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 59 74 0A 6A 48 56 E8 ?? ?? ?? ?? 59 59 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_56_175_1 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 90
		refs = "0006 __ehhandler$??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UAEPAXI@Z 0013 ___security_cookie 002c ??_7ios_base@std@@6B@ 0031 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0040 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 83 65 FC 00 56 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 59 74 0A 6A 48 56 E8 ?? ?? ?? ?? 59 59 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_178_1 {
	meta:
		name = "??_G?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 37
		refs = "000a ??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAEXXZ 0018 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8D 71 F8 8B CE E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 50 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_179_1 {
	meta:
		name = "??_G?$basic_ostream@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 37
		refs = "000a ??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QAEXXZ 0018 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8D 71 F8 8B CE E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 50 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_68_178_1 {
	meta:
		name = "??_G?$basic_ostream@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 37
		refs = "000a ??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QAEXXZ 0018 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8D 71 F8 8B CE E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 50 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_179_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 34
		refs = "0007 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 38 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_180_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 34
		refs = "0007 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 38 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_56_179_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 34
		refs = "0007 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 38 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_180_1 {
	meta:
		name = "??_G?$codecvt@_WDU_Mbstatet@@@std@@MAEPAXI@Z"
		size = 35
		refs = "000c ??_7_Facet_base@std@@6B@ 0016 ??3@YAXPAXI@Z"
		altNames = "??_G?$codecvt@GDU_Mbstatet@@@std@@MAEPAXI@Z"
	strings:
		$1 = { 55 8B EC F6 45 08 01 56 8B F1 C7 06 ?? ?? ?? ?? 74 0A 6A 34 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_181_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 34
		refs = "0007 ??1?$ctype@_W@std@@MAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 44 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_56_181_1 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 34
		refs = "0007 ??1?$ctype@G@std@@MAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 44 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_185_1 {
	meta:
		name = "??_G_System_error@std@@UAEPAXI@Z"
		size = 45
		refs = "000b ??_7exception@std@@6B@ 0011 ___std_exception_destroy 0020 ??3@YAXPAXI@Z"
		altNames = "??_Gfailure@ios_base@std@@UAEPAXI@Z ??_Gfuture_error@std@@UAEPAXI@Z ??_Gsystem_error@std@@UAEPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 8D 46 04 C7 06 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? F6 45 08 01 59 74 0A 6A 14 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_193_1 {
	meta:
		name = "??_Gios_base@std@@UAEPAXI@Z"
		size = 90
		refs = "0006 __ehhandler$??_Gios_base@std@@UAEPAXI@Z 0013 ___security_cookie 002c ??_7ios_base@std@@6B@ 0031 ?_Ios_base_dtor@ios_base@std@@CAXPAV12@@Z 0040 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 56 A1 ?? ?? ?? ?? 33 C5 50 8D 45 F4 64 A3 00 00 00 00 8B F1 83 65 FC 00 56 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 45 08 01 59 74 0A 6A 38 56 E8 ?? ?? ?? ?? 59 59 8B C6 8B 4D F4 64 89 0D 00 00 00 00 59 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_196_1 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 34
		refs = "0007 ??1locale@std@@QAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 08 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_28_25_1 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 34
		refs = "0007 ??1_Fac_node@std@@QAE@XZ 0015 ??3@YAXPAXI@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? F6 45 08 01 74 0A 6A 08 56 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_200_1 {
	meta:
		name = "??__Einitlocks@@YAXXZ"
		size = 22
		refs = "0001 ?initlocks@@3V_Init_locks@std@@A 0006 ??0_Init_locks@std@@QAE@XZ 000b ??__Finitlocks@@YAXXZ 0010 _atexit"
	strings:
		$1 = { B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_62_3_1 {
	meta:
		name = "??__Einitlocks@std@@YAXXZ"
		size = 22
		refs = "0001 ?initlocks@std@@3V_Init_locks@1@A 0006 ??0_Init_locks@std@@QAE@XZ 000b ??__Finitlocks@std@@YAXXZ 0010 _atexit"
	strings:
		$1 = { B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_3_201_1 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 31
		refs = "0005 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000a ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000f ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 ??__Fwcerr@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_37_200_1 {
	meta:
		name = "??__Ecerr@std@@YAXXZ"
		size = 31
		refs = "0005 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 000a ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000f ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0014 ??__Fcerr@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_113_200_1 {
	meta:
		name = "??__Ecin@std@@YAXXZ"
		size = 31
		refs = "0005 ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 000a ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 000f ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0014 ??__Fcin@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_120_170_2 {
	meta:
		name = "??__Eclog@std@@YAXXZ"
		size = 31
		refs = "0005 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 000a ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000f ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0014 ??__Fclog@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_23_200_1 {
	meta:
		name = "??__Ecout@std@@YAXXZ"
		size = 31
		refs = "0005 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 000a ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000f ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QAE@PAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0014 ??__Fcout@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_69_201_1 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 31
		refs = "0005 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000a ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000f ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 ??__Fwcerr@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_56_201_1 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 31
		refs = "0005 ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000a ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 000f ??0?$basic_istream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 ??__Fwcin@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_102_201_1 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 31
		refs = "0005 ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000a ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 000f ??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 ??__Fwcin@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_4_171_2 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 31
		refs = "0005 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000a ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000f ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 ??__Fwclog@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_24_171_2 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 31
		refs = "0005 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000a ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000f ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 ??__Fwclog@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_73_201_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 31
		refs = "0005 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000a ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000f ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 ??__Fwclog@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_12_201_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 31
		refs = "0005 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000a ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000f ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 ??__Fwclog@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_7_201_1 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 31
		refs = "0005 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000a ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000f ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 ??__Fwcout@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_61_171_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 31
		refs = "0005 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000a ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000f ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 ??__Fwcout@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_94_171_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 31
		refs = "0005 ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 000a ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000f ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QAE@PAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0014 ??__Fwcout@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_68_201_1 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 31
		refs = "0005 ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 000a ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000f ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QAE@PAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0014 ??__Fwcout@std@@YAXXZ 0019 _atexit"
	strings:
		$1 = { 6A 01 6A 00 68 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_3_202_1 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 186
		refs = "0004 ___acrt_iob_func 000a ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0011 ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0016 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A 0027 ??__Fwferr@std@@YAXXZ 0031 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 00b3 _atexit"
	strings:
		$1 = { 56 6A 02 E8 ?? ?? ?? ?? 59 B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 88 0D ?? ?? ?? ?? 88 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_69_202_1 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 186
		refs = "0004 ___acrt_iob_func 000a ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0011 ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0016 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A 0027 ??__Fwferr@std@@YAXXZ 0031 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 00b3 _atexit"
	strings:
		$1 = { 56 6A 02 E8 ?? ?? ?? ?? 59 B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 88 0D ?? ?? ?? ?? 88 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_12_202_1 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 186
		refs = "0004 ___acrt_iob_func 000a ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0011 ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0016 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A 0027 ??__Fwflog@std@@YAXXZ 0031 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 00b3 _atexit"
	strings:
		$1 = { 56 6A 02 E8 ?? ?? ?? ?? 59 B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 88 0D ?? ?? ?? ?? 88 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_73_202_1 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 186
		refs = "0004 ___acrt_iob_func 000a ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0011 ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0016 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A 0027 ??__Fwflog@std@@YAXXZ 0031 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 00b3 _atexit"
	strings:
		$1 = { 56 6A 02 E8 ?? ?? ?? ?? 59 B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 88 0D ?? ?? ?? ?? 88 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_24_172_2 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 186
		refs = "0004 ___acrt_iob_func 000a ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0011 ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0016 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A 0027 ??__Fwflog@std@@YAXXZ 0031 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 00b3 _atexit"
	strings:
		$1 = { 56 6A 02 E8 ?? ?? ?? ?? 59 B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 88 0D ?? ?? ?? ?? 88 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_3_207_1 {
	meta:
		name = "?_Adopt@_Iterator_base12@std@@QAEXPBU_Container_base12@2@@Z"
		size = 18
	strings:
		$1 = { 55 8B EC 8B 45 08 85 C0 74 04 8B 00 89 01 5D C2 04 00 }
	condition:
		$1
}

rule file_3_221_1 {
	meta:
		name = "?_Donarrow@?$ctype@_W@std@@IBED_WD@Z"
		size = 74
		refs = "0007 ___security_cookie 0028 __Wcrtomb 0040 @__security_check_cookie@4"
		altNames = "?_Donarrow@?$ctype@G@std@@IBEDGD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 65 EC 00 8D 41 18 83 65 F0 00 50 8D 45 EC 50 FF 75 08 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 01 8A 45 0C 75 03 8A 45 F4 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_222_1 {
	meta:
		name = "?_Dowiden@?$ctype@_W@std@@IBE_WD@Z"
		size = 61
		refs = "0021 __Mbrtowc"
		altNames = "?_Dowiden@?$ctype@G@std@@IBEGD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 65 F4 00 8D 41 18 83 65 F8 00 50 8D 45 F4 50 6A 01 8D 45 08 50 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 79 07 B8 FF FF 00 00 EB 04 66 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_223_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ"
		size = 384
		refs = "0003 __ehhandler$?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ 0008 __EH_prolog3_GS 0037 @_guard_check_icall@4 005f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0077 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 007e ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ 0114 _fwrite 0156 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 0170 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 017b __EH_epilog3_GS"
	strings:
		$1 = { 6A 68 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 89 5D C4 33 FF 89 7D CC 39 7B 38 0F 84 59 01 00 00 80 7B 3E 00 0F 84 4F 01 00 00 8B 03 B9 FF FF 00 00 51 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 0F B7 C0 B9 FF FF 00 00 66 3B C8 0F 94 C0 84 C0 74 07 32 C0 E9 22 01 00 00 57 6A 08 8D 4D D4 E8 ?? ?? ?? ?? 8D 43 40 89 7D FC 8B 7D C4 89 45 C0 8D 45 B0 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 5D E8 8D 4D D4 89 45 C8 8D 45 A4 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7F 38 8D 4D BC 8B 55 C8 51 03 D3 8B 37 52 50 FF 75 C0 8B 4E 20 E8 ?? ?? ?? ?? 8B CF FF 56 20 33 DB 2B C3 74 0E 83 E8 01 0F 85 95 00 00 00 8B 7D C4 EB 06 8B 7D C4 88 5F 3E 8D 45 98 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 55 BC 2B D0 89 55 C8 74 38 33 F6 8D 45 8C 46 8D 4D D4 09 75 CC 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? FF 77 4C FF 75 C8 56 50 E8 ?? ?? ?? ?? 8B 55 C8 83 C4 10 3B D0 74 08 33 C0 40 88 45 D3 EB 06 33 C0 88 5D D3 40 8B 4D CC 84 C8 74 06 83 E1 FE 89 4D CC 38 5D D3 75 26 38 5F 3E 74 23 85 D2 0F 85 20 FF FF FF 53 6A 08 8D 4D D4 E8 ?? ?? ?? ?? E9 10 FF FF FF 48 83 E8 01 75 07 40 EB 02 8A C3 8A D8 8D 4D D4 E8 ?? ?? ?? ?? 8A C3 EB 02 B0 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_56_223_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ"
		size = 384
		refs = "0003 __ehhandler$?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ 0008 __EH_prolog3_GS 0037 @_guard_check_icall@4 005f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 0077 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 007e ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ 0114 _fwrite 0156 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 0170 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 017b __EH_epilog3_GS"
	strings:
		$1 = { 6A 68 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 89 5D C4 33 FF 89 7D CC 39 7B 38 0F 84 59 01 00 00 80 7B 3E 00 0F 84 4F 01 00 00 8B 03 B9 FF FF 00 00 51 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 0F B7 C0 B9 FF FF 00 00 66 3B C8 0F 94 C0 84 C0 74 07 32 C0 E9 22 01 00 00 57 6A 08 8D 4D D4 E8 ?? ?? ?? ?? 8D 43 40 89 7D FC 8B 7D C4 89 45 C0 8D 45 B0 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 5D E8 8D 4D D4 89 45 C8 8D 45 A4 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7F 38 8D 4D BC 8B 55 C8 51 03 D3 8B 37 52 50 FF 75 C0 8B 4E 20 E8 ?? ?? ?? ?? 8B CF FF 56 20 33 DB 2B C3 74 0E 83 E8 01 0F 85 95 00 00 00 8B 7D C4 EB 06 8B 7D C4 88 5F 3E 8D 45 98 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 55 BC 2B D0 89 55 C8 74 38 33 F6 8D 45 8C 46 8D 4D D4 09 75 CC 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? FF 77 4C FF 75 C8 56 50 E8 ?? ?? ?? ?? 8B 55 C8 83 C4 10 3B D0 74 08 33 C0 40 88 45 D3 EB 06 33 C0 88 5D D3 40 8B 4D CC 84 C8 74 06 83 E1 FE 89 4D CC 38 5D D3 75 26 38 5F 3E 74 23 85 D2 0F 85 20 FF FF FF 53 6A 08 8D 4D D4 E8 ?? ?? ?? ?? E9 10 FF FF FF 48 83 E8 01 75 07 40 EB 02 8A C3 8A D8 8D 4D D4 E8 ?? ?? ?? ?? 8A C3 EB 02 B0 01 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_225_1 {
	meta:
		name = "__ehhandler$?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_224_1 {
	meta:
		name = "__ehhandler$?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAE_NXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAE_NXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_56_225_1 {
	meta:
		name = "__ehhandler$?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_605_1 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Fput@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@AAVios_base@2@GPBDI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_611_1 {
	meta:
		name = "__ehhandler$?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?_Fput@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@ABA?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@AAVios_base@2@_WPBDI@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_90_472_1 {
	meta:
		name = "__ehhandler$?do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAAVios_base@2@DO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@_NAAVios_base@2@DO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1215_1 {
	meta:
		name = "__ehhandler$?do_put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@GO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@GU?$char_traits@G@std@@@2@V32@_NAAVios_base@2@GO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_58_1223_1 {
	meta:
		name = "__ehhandler$?do_put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_WO@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?do_put@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MBE?AV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@_NAAVios_base@2@_WO@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A 88 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_236_1 {
	meta:
		name = "?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 102
		refs = "0003 __ehhandler$?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 0021 ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0048 ??0?$codecvt@_WDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0059 ??1_Locinfo@std@@QAE@XZ 0061 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 F6 8B DE 89 5D F0 85 FF 74 43 39 37 75 3F 6A 34 E8 ?? ?? ?? ?? 59 89 45 F0 89 75 FC 85 C0 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 8B 4D F0 43 56 50 E8 ?? ?? ?? ?? 8B F0 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 02 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_56_236_1 {
	meta:
		name = "?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 102
		refs = "0003 __ehhandler$?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 0021 ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 0048 ??0?$codecvt@GDU_Mbstatet@@@std@@QAE@ABV_Locinfo@1@I@Z 0059 ??1_Locinfo@std@@QAE@XZ 0061 __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 F6 8B DE 89 5D F0 85 FF 74 43 39 37 75 3F 6A 34 E8 ?? ?? ?? ?? 59 89 45 F0 89 75 FC 85 C0 74 1E 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 8B 4D F0 43 56 50 E8 ?? ?? ?? ?? 8B F0 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 02 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_239_1 {
	meta:
		name = "?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 112
		refs = "0003 __ehhandler$?_Getcat@?$ctype@_W@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 004b ??_7?$ctype@_W@std@@6B@ 0050 ?_Init@?$ctype@_W@std@@IAEXABV_Locinfo@2@@Z 0063 ??1_Locinfo@std@@QAE@XZ 006b __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 4F 39 1F 75 4B 6A 44 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 26 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 83 66 04 00 8B CE 50 43 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 02 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_56_239_1 {
	meta:
		name = "?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z"
		size = 112
		refs = "0003 __ehhandler$?_Getcat@?$ctype@G@std@@SAIPAPBVfacet@locale@2@PBV42@@Z 0008 __EH_prolog3 001f ??2@YAPAXI@Z 0034 ?c_str@locale@std@@QBEPBDXZ 003d ??0_Locinfo@std@@QAE@PBD@Z 004b ??_7?$ctype@G@std@@6B@ 0050 ?_Init@?$ctype@G@std@@IAEXABV_Locinfo@2@@Z 0063 ??1_Locinfo@std@@QAE@XZ 006b __EH_epilog3"
	strings:
		$1 = { 6A 38 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 33 DB 89 5D F0 85 FF 74 4F 39 1F 75 4B 6A 44 E8 ?? ?? ?? ?? 8B F0 59 89 75 F0 21 5D FC 85 F6 74 26 8B 4D 0C E8 ?? ?? ?? ?? 50 8D 4D BC E8 ?? ?? ?? ?? 83 66 04 00 8B CE 50 43 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 02 33 F6 89 37 F6 C3 01 74 08 8D 4D BC E8 ?? ?? ?? ?? 6A 02 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_247_1 {
	meta:
		name = "?_Gndec@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEPA_WXZ"
		size = 16
		altNames = "?_Gndec@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEPAGXZ"
	strings:
		$1 = { 8B 41 2C FF 00 8B 49 1C 8B 01 83 C0 FE 89 01 C3 }
	condition:
		$1
}

rule file_3_248_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEPA_WXZ"
		size = 16
		altNames = "?_Gninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEPAGXZ"
	strings:
		$1 = { 8B 41 2C FF 08 8B 51 1C 8B 02 8D 48 02 89 0A C3 }
	condition:
		$1
}

rule file_3_251_1 {
	meta:
		name = "?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@12@@Z"
		size = 56
		refs = "0015 ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXXZ 0020 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 55 8B EC 83 7D 0C 01 56 8B F1 0F 94 C0 88 46 48 C6 46 3E 00 E8 ?? ?? ?? ?? 8B 45 08 89 46 4C A1 ?? ?? ?? ?? 89 46 40 A1 ?? ?? ?? ?? 83 66 38 00 89 46 44 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_56_251_1 {
	meta:
		name = "?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@12@@Z"
		size = 56
		refs = "0015 ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXXZ 0020 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 55 8B EC 83 7D 0C 01 56 8B F1 0F 94 C0 88 46 48 C6 46 3E 00 E8 ?? ?? ?? ?? 8B 45 08 89 46 4C A1 ?? ?? ?? ?? 89 46 40 A1 ?? ?? ?? ?? 83 66 38 00 89 46 44 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_3_252_1 {
	meta:
		name = "?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXPAPA_W0PAH001@Z"
		size = 43
		altNames = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAEXPAPAD0PAH001@Z ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXPAPAG0PAH001@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 89 41 0C 8B 45 14 89 41 10 8B 45 0C 89 41 1C 8B 45 18 89 41 20 8B 45 10 89 41 2C 8B 45 1C 89 41 30 5D C2 18 00 }
	condition:
		$1
}

rule file_3_253_1 {
	meta:
		name = "?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXXZ"
		size = 68
		altNames = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAEXXZ ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXXZ"
	strings:
		$1 = { 8D 41 04 89 41 0C 8D 51 08 8D 41 14 89 51 10 89 41 1C 8D 41 18 89 41 20 8D 41 24 89 41 2C 8D 41 28 89 41 30 56 33 F6 89 32 8B 41 20 89 30 8B 41 30 89 30 8B 41 0C 89 30 8B 41 1C 89 30 8B 41 2C 89 30 5E C3 }
	condition:
		$1
}

rule file_3_254_1 {
	meta:
		name = "?_Init@?$codecvt@_WDU_Mbstatet@@@std@@IAEXABV_Locinfo@2@@Z"
		size = 38
		refs = "000f __Getcvt"
		altNames = "?_Init@?$codecvt@GDU_Mbstatet@@@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8D 45 D4 56 57 50 8B F9 E8 ?? ?? ?? ?? 59 6A 0B 59 83 C7 08 8B F0 F3 A5 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_255_1 {
	meta:
		name = "?_Init@?$ctype@_W@std@@IAEXABV_Locinfo@2@@Z"
		size = 59
		refs = "0010 __Getctype 0022 __Getcvt"
		altNames = "?_Init@?$ctype@G@std@@IAEXABV_Locinfo@2@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8D 45 F0 53 56 57 50 8B D9 E8 ?? ?? ?? ?? 8B F0 8D 7B 08 8D 45 C4 50 A5 A5 A5 A5 E8 ?? ?? ?? ?? 59 59 6A 0B 59 8D 7B 18 8B F0 F3 A5 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_256_1 {
	meta:
		name = "?_Init@ios_base@std@@IAEXXZ"
		size = 102
		refs = "0003 __ehhandler$?_Init@ios_base@std@@IAEXXZ 0008 __EH_prolog3 0039 ?clear@ios_base@std@@QAEXH_N@Z 0040 ??2@YAPAXI@Z 0051 ?_Init@locale@std@@CAPAV_Locimp@12@_N@Z 0061 __EH_epilog3"
	strings:
		$1 = { 6A 00 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 33 DB C7 46 14 01 02 00 00 53 53 89 5E 30 89 5E 08 89 5E 10 C7 46 18 06 00 00 00 89 5E 1C 89 5E 20 89 5E 24 89 5E 28 89 5E 2C E8 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 8B F8 59 85 FF 74 10 6A 01 89 5D FC E8 ?? ?? ?? ?? 59 89 47 04 EB 02 8B FB 89 7E 30 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_260_1 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
		size = 54
		refs = "0013 @_guard_check_icall@4 002b ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 57 8B F9 8B 03 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 84 C0 74 06 83 67 38 00 EB 0A 8B CF 89 5F 38 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_23_258_1 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAEXPBV?$codecvt@DDU_Mbstatet@@@2@@Z"
		size = 54
		refs = "0013 @_guard_check_icall@4 002b ?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 57 8B F9 8B 03 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 84 C0 74 06 83 67 38 00 EB 0A 8B CF 89 5F 38 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_56_260_1 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPBV?$codecvt@GDU_Mbstatet@@@2@@Z"
		size = 54
		refs = "0013 @_guard_check_icall@4 002b ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXXZ"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 57 8B F9 8B 03 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 84 C0 74 06 83 67 38 00 EB 0A 8B CF 89 5F 38 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_3_262_1 {
	meta:
		name = "?_Lock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEXXZ"
		size = 16
		refs = "000a __lock_file"
		altNames = "?_Lock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEXXZ ?_Lock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEXXZ"
	strings:
		$1 = { 83 79 4C 00 74 09 FF 71 4C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_120_248_2 {
	meta:
		name = "?_Unlock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEXXZ"
		size = 16
		refs = "000a __unlock_file"
	strings:
		$1 = { 83 79 4C 00 74 09 FF 71 4C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_4_249_2 {
	meta:
		name = "?_Unlock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEXXZ"
		size = 16
		refs = "000a __unlock_file"
	strings:
		$1 = { 83 79 4C 00 74 09 FF 71 4C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_3_285_1 {
	meta:
		name = "?_Unlock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEXXZ"
		size = 16
		refs = "000a __unlock_file"
	strings:
		$1 = { 83 79 4C 00 74 09 FF 71 4C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_3_264_1 {
	meta:
		name = "?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z"
		size = 115
		refs = "0003 __ehhandler$?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z 0008 __EH_prolog3_GS 001e ??_C@_02LMMGGCAJ@?3?5?$AA@ 0024 ?length@?$char_traits@D@std@@SAIPBD@Z 002f ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z 003b ?message@error_code@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 004c ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z 0054 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 005f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@$$QAV01@@Z 006e __EH_epilog3_GS"
	strings:
		$1 = { 6A 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 83 65 D0 00 83 65 FC 00 83 7D 28 00 74 16 BF ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 50 57 8D 4D 14 E8 ?? ?? ?? ?? 8D 45 D4 50 8D 4D 0C E8 ?? ?? ?? ?? 6A FF 6A 00 50 8D 4D 14 C6 45 FC 01 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 14 8B CE 50 E8 ?? ?? ?? ?? 8D 4D 14 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_3_279_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEPA_WXZ"
		size = 16
		altNames = "?_Pninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEPAGXZ"
	strings:
		$1 = { 8B 41 30 FF 08 8B 51 20 8B 02 8D 48 02 89 0A C3 }
	condition:
		$1
}

rule file_3_280_1 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAEXXZ"
		size = 37
		altNames = "?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAEXXZ"
	strings:
		$1 = { 57 8B 79 0C 8D 41 3C 39 07 75 18 8B 51 50 56 8B 71 54 89 17 2B F2 8B 41 1C D1 FE 89 10 8B 41 2C 89 30 5E 5F C3 }
	condition:
		$1
}

rule file_3_281_1 {
	meta:
		name = "?_Set_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAEXXZ"
		size = 59
		altNames = "?_Set_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAEXXZ"
	strings:
		$1 = { 8B D1 56 57 8B 7A 0C 8D 72 3C 8B 07 3B C6 74 13 89 42 50 8B 42 2C 8B 08 8B 42 1C 8B 00 8D 04 48 89 42 54 89 37 8B CA 8B 42 1C 2B CE 83 C1 3E D1 F9 5F 89 30 8B 42 2C 5E 89 08 C3 }
	condition:
		$1
}

rule file_3_300_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@PBDI@Z"
		size = 153
		refs = "000d ?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NPBD@Z 002d ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ABV12@II@Z 0052 ?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE_NI_N@Z 0075 _memcpy 0082 ?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEXI@Z 0094 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QBEXXZ"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 56 53 8B F1 E8 ?? ?? ?? ?? 84 C0 74 1E 83 7E 18 10 72 05 8B 46 04 EB 03 8D 46 04 FF 75 0C 2B D8 8B CE 53 56 E8 ?? ?? ?? ?? EB 56 8B 4E 14 8B C1 57 8B 7D 0C F7 D0 3B C7 76 4F 8D 04 39 89 45 FC 85 FF 74 3A 6A 00 50 8B CE E8 ?? ?? ?? ?? 84 C0 74 2C 83 7E 18 10 72 05 8B 4E 04 EB 03 8D 4E 04 85 FF 74 10 8B 46 14 57 03 C1 53 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 FC 8B CE E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 8B E5 5D C2 08 00 8B CE E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_3_307_1 {
	meta:
		name = "?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 34
		refs = "0017 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QAE@PBDPBU_Container_base12@1@@Z"
	strings:
		$1 = { 55 8B EC 83 79 18 10 72 05 8B 41 04 EB 03 8D 41 04 51 8B 4D 08 50 E8 ?? ?? ?? ?? 8B 45 08 5D C2 04 00 }
	condition:
		$1
}

rule file_3_313_1 {
	meta:
		name = "?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAEXH_N@Z"
		size = 28
		refs = "0014 ?clear@ios_base@std@@QAEXH_N@Z"
		altNames = "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QAEXH_N@Z ?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QAEXH_N@Z"
	strings:
		$1 = { 55 8B EC 83 79 38 00 8B 45 08 75 03 83 C8 04 FF 75 0C 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_3_315_1 {
	meta:
		name = "?clear@ios_base@std@@QAEXH_N@Z"
		size = 122
		refs = "0028 ?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z 0030 ??_C@_0BF@PHHKMMFD@ios_base?3?3badbit?5set?$AA@ 0038 ??0failure@ios_base@std@@QAE@PBDABVerror_code@2@@Z 003d __TI5?AVfailure@ios_base@std@@ 0055 ??_C@_0BG@FMKFHCIL@ios_base?3?3failbit?5set?$AA@ 0064 ??_C@_0BF@OOHOMBOF@ios_base?3?3eofbit?5set?$AA@ 0075 __CxxThrowException@8"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 1C 83 E0 17 89 41 0C 8B 49 10 23 C8 74 54 80 7D 0C 00 75 54 8D 45 F8 6A 01 50 F6 C1 04 74 20 E8 ?? ?? ?? ?? 59 59 50 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 E4 50 EB 2D F6 C1 02 74 0F E8 ?? ?? ?? ?? 59 59 50 68 ?? ?? ?? ?? EB D9 E8 ?? ?? ?? ?? 59 59 50 68 ?? ?? ?? ?? EB CA 8B E5 5D C2 08 00 6A 00 6A 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_3_316_1 {
	meta:
		name = "?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QAEPAV12@XZ"
		size = 95
		refs = "0010 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ 0021 _fclose 003c ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXXZ 0048 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 53 57 8B F9 83 7F 4C 00 75 04 33 DB EB 23 56 E8 ?? ?? ?? ?? FF 77 4C 0F B6 F0 F7 DE 1B F6 23 F7 E8 ?? ?? ?? ?? 8B D8 F7 DB 59 1B DB F7 D3 23 DE 5E 8B CF C6 47 48 00 C6 47 3E 00 E8 ?? ?? ?? ?? 83 67 4C 00 8B C3 8B 0D ?? ?? ?? ?? 89 4F 40 8B 0D ?? ?? ?? ?? 83 67 38 00 89 4F 44 5F 5B C3 }
	condition:
		$1
}

rule file_56_316_1 {
	meta:
		name = "?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QAEPAV12@XZ"
		size = 95
		refs = "0010 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ 0021 _fclose 003c ?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXXZ 0048 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 53 57 8B F9 83 7F 4C 00 75 04 33 DB EB 23 56 E8 ?? ?? ?? ?? FF 77 4C 0F B6 F0 F7 DE 1B F6 23 F7 E8 ?? ?? ?? ?? 8B D8 F7 DB 59 1B DB F7 D3 23 DE 5E 8B CF C6 47 48 00 C6 47 3E 00 E8 ?? ?? ?? ?? 83 67 4C 00 8B C3 8B 0D ?? ?? ?? ?? 89 4F 40 8B 0D ?? ?? ?? ?? 83 67 38 00 89 4F 44 5F 5B C3 }
	condition:
		$1
}

rule file_3_318_1 {
	meta:
		name = "?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 34
		refs = "0019 _memcpy"
		altNames = "?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
	strings:
		$1 = { 55 8B EC 8B 45 10 85 C0 75 05 8B 45 08 5D C3 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_58_1347_1 {
	meta:
		name = "?move@?$char_traits@G@std@@SAPAGPAGPBGI@Z"
		size = 34
		refs = "0019 _memmove"
	strings:
		$1 = { 55 8B EC 8B 45 10 85 C0 75 05 8B 45 08 5D C3 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_58_1348_1 {
	meta:
		name = "?move@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z"
		size = 34
		refs = "0019 _memmove"
	strings:
		$1 = { 55 8B EC 8B 45 10 85 C0 75 05 8B 45 08 5D C3 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_3_323_1 {
	meta:
		name = "?default_error_condition@error_category@std@@UBE?AVerror_condition@2@H@Z"
		size = 18
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 55 0C 89 10 89 48 04 5D C2 08 00 }
	condition:
		$1
}

rule file_3_328_1 {
	meta:
		name = "?do_in@?$codecvt@_WDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PBD1AAPBDPA_W3AAPA_W@Z"
		size = 162
		refs = "0040 __Mbrtowc"
		altNames = "?do_in@?$codecvt@GDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PBD1AAPBDPAG3AAPAG@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 8B D1 8B 4D 20 53 56 8B 75 14 33 DB 57 8B 7D 10 89 55 FC 89 06 8B 45 18 89 01 39 3E 0F 95 C3 EB 62 8B 45 1C 39 01 74 68 8D 42 08 50 FF 75 08 8B C7 2B 06 50 FF 36 FF 31 E8 ?? ?? ?? ?? 8B C8 83 C4 14 83 F9 FE 74 47 83 F9 FF 74 3D 85 C9 75 1B 8B 45 20 33 D2 8B 00 66 39 10 75 0F 8B 0E 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 41 8B 55 FC 8D 41 03 F7 D8 1B C0 23 C1 8B 4D 20 01 06 83 01 02 33 C0 8B D8 39 3E 75 9A EB 07 6A 02 58 EB 04 89 3E 8B C3 5F 5E 5B 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule file_3_329_1 {
	meta:
		name = "?do_is@?$ctype@_W@std@@MBEPB_WPB_W0PAF@Z"
		size = 28
		refs = "0011 __Getwctypes"
		altNames = "?do_is@?$ctype@G@std@@MBEPBGPBG0PAF@Z"
	strings:
		$1 = { 55 8B EC 8D 41 08 50 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_330_1 {
	meta:
		name = "?do_is@?$ctype@_W@std@@MBE_NF_W@Z"
		size = 28
		refs = "000b __Getwctype"
		altNames = "?do_is@?$ctype@G@std@@MBE_NFG@Z"
	strings:
		$1 = { 55 8B EC 8D 41 08 50 FF 75 0C E8 ?? ?? ?? ?? 66 85 45 08 59 59 0F 95 C0 5D C2 08 00 }
	condition:
		$1
}

rule file_3_331_1 {
	meta:
		name = "?do_length@?$codecvt@_WDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PBD1I@Z"
		size = 132
		refs = "003c __Mbrtowc"
		altNames = "?do_length@?$codecvt@GDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PBD1I@Z"
	strings:
		$1 = { 55 8B EC 83 EC 0C 8B 55 08 53 56 33 F6 8B D9 8B 02 89 45 F4 8B 42 04 57 8B 7D 0C 89 45 F8 39 75 14 76 56 3B 7D 10 74 51 8D 43 08 50 8D 45 F4 50 8B 45 10 2B C7 50 8D 45 FC 57 50 E8 ?? ?? ?? ?? 8B C8 83 C4 14 83 F9 FE 74 2F 83 F9 FF 74 2A 85 C9 75 15 66 39 45 FC 75 0F 8B CF 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 41 8D 41 03 F7 D8 1B C0 23 C1 03 F8 46 3B 75 14 72 AA 5F 8B C6 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_3_335_1 {
	meta:
		name = "?do_narrow@?$ctype@_W@std@@MBEPB_WPB_W0DPAD@Z"
		size = 83
		refs = "0030 ?_Donarrow@?$ctype@_W@std@@IBED_WD@Z"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 83 65 FC 00 56 8B 75 08 2B C6 40 89 4D F8 D1 E8 39 75 0C 57 1B FF F7 D7 23 F8 74 25 53 8B 5D 14 FF 75 10 0F B7 06 50 E8 ?? ?? ?? ?? 8B 4D F8 83 C6 02 88 03 43 8B 45 FC 40 89 45 FC 3B C7 75 E0 5B 5F 8B C6 5E 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_56_335_1 {
	meta:
		name = "?do_narrow@?$ctype@G@std@@MBEPBGPBG0DPAD@Z"
		size = 83
		refs = "0030 ?_Donarrow@?$ctype@G@std@@IBEDGD@Z"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 83 65 FC 00 56 8B 75 08 2B C6 40 89 4D F8 D1 E8 39 75 0C 57 1B FF F7 D7 23 F8 74 25 53 8B 5D 14 FF 75 10 0F B7 06 50 E8 ?? ?? ?? ?? 8B 4D F8 83 C6 02 88 03 43 8B 45 FC 40 89 45 FC 3B C7 75 E0 5B 5F 8B C6 5E 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_3_336_1 {
	meta:
		name = "?do_out@?$codecvt@_WDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PB_W1AAPB_WPAD3AAPAD@Z"
		size = 230
		refs = "0007 ___security_cookie 0054 __Wcrtomb 00a0 _memcpy 00dc @__security_check_cookie@4"
		altNames = "?do_out@?$codecvt@GDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PBG1AAPBGPAD3AAPAD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 8B 5D 08 56 8B 75 14 57 8B 7D 20 89 4D EC 89 06 8B 45 18 89 07 8B 45 10 39 06 0F 84 95 00 00 00 8B 45 1C 39 07 0F 84 8A 00 00 00 2B 07 83 F8 05 7C 1E 8D 41 08 50 8B 06 53 0F B7 00 50 FF 37 E8 ?? ?? ?? ?? 83 C4 10 85 C0 79 4B 6A 02 58 EB 6F 8B 03 89 45 E8 8B 43 04 89 45 E4 8D 41 08 50 8B 06 53 0F B7 00 50 8D 45 F4 50 E8 ?? ?? ?? ?? 8B C8 83 C4 10 89 4D F0 85 C9 78 D0 8B 45 1C 2B 07 3B C1 7C 26 51 8D 45 F4 50 FF 37 E8 ?? ?? ?? ?? 8B 45 F0 83 C4 0C 83 06 02 01 07 8B 45 10 39 06 74 13 8B 4D EC E9 76 FF FF FF 8B 45 E8 89 03 8B 45 E4 89 43 04 8B 4D 10 33 C0 39 0E 0F 95 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 1C 00 }
	condition:
		$1
}

rule file_3_337_1 {
	meta:
		name = "?do_scan_is@?$ctype@_W@std@@MBEPB_WFPB_W0@Z"
		size = 60
		refs = "001f @_guard_check_icall@4"
		altNames = "?do_scan_is@?$ctype@G@std@@MBEPBGFPBG0@Z"
	strings:
		$1 = { 55 8B EC 53 57 8B 7D 0C 8B D9 3B 7D 10 74 25 56 8B 0B 0F B7 07 50 FF 75 08 8B 71 10 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 84 C0 75 08 83 C7 02 3B 7D 10 75 DD 5E 8B C7 5F 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_338_1 {
	meta:
		name = "?do_scan_not@?$ctype@_W@std@@MBEPB_WFPB_W0@Z"
		size = 60
		refs = "001f @_guard_check_icall@4"
		altNames = "?do_scan_not@?$ctype@G@std@@MBEPBGFPBG0@Z"
	strings:
		$1 = { 55 8B EC 53 57 8B 7D 0C 8B D9 3B 7D 10 74 25 56 8B 0B 0F B7 07 50 FF 75 08 8B 71 10 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 84 C0 74 08 83 C7 02 3B 7D 10 75 DD 5E 8B C7 5F 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_339_1 {
	meta:
		name = "?do_tolower@?$ctype@_W@std@@MBEPB_WPA_WPB_W@Z"
		size = 74
		refs = "002b __Towlower"
		altNames = "?do_tolower@?$ctype@G@std@@MBEPBGPAGPBG@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 53 56 8B 75 08 33 DB 2B C6 40 D1 E8 39 75 0C 57 1B FF F7 D7 23 F8 74 20 8D 41 08 89 45 FC 50 0F B7 06 50 E8 ?? ?? ?? ?? 66 89 06 83 C6 02 8B 45 FC 43 59 59 3B DF 75 E6 5F 8B C6 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_4_301_2 {
	meta:
		name = "?do_toupper@?$ctype@G@std@@MBEPBGPAGPBG@Z"
		size = 74
		refs = "002b __Towupper"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 53 56 8B 75 08 33 DB 2B C6 40 D1 E8 39 75 0C 57 1B FF F7 D7 23 F8 74 20 8D 41 08 89 45 FC 50 0F B7 06 50 E8 ?? ?? ?? ?? 66 89 06 83 C6 02 8B 45 FC 43 59 59 3B DF 75 E6 5F 8B C6 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_58_1274_1 {
	meta:
		name = "?do_toupper@?$ctype@_W@std@@MBEPB_WPA_WPB_W@Z"
		size = 74
		refs = "002b __Towupper"
	strings:
		$1 = { 55 8B EC 51 8B 45 0C 53 56 8B 75 08 33 DB 2B C6 40 D1 E8 39 75 0C 57 1B FF F7 D7 23 F8 74 20 8D 41 08 89 45 FC 50 0F B7 06 50 E8 ?? ?? ?? ?? 66 89 06 83 C6 02 8B 45 FC 43 59 59 3B DF 75 E6 5F 8B C6 5E 5B 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_340_1 {
	meta:
		name = "?do_tolower@?$ctype@_W@std@@MBE_W_W@Z"
		size = 21
		refs = "000b __Towlower"
		altNames = "?do_tolower@?$ctype@G@std@@MBEGG@Z"
	strings:
		$1 = { 55 8B EC 8D 41 08 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_4_300_2 {
	meta:
		name = "?do_toupper@?$ctype@G@std@@MBEGG@Z"
		size = 21
		refs = "000b __Towupper"
	strings:
		$1 = { 55 8B EC 8D 41 08 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_58_1275_1 {
	meta:
		name = "?do_toupper@?$ctype@_W@std@@MBE_W_W@Z"
		size = 21
		refs = "000b __Towupper"
	strings:
		$1 = { 55 8B EC 8D 41 08 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_3_343_1 {
	meta:
		name = "?do_unshift@?$codecvt@_WDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PAD1AAPAD@Z"
		size = 146
		refs = "0007 ___security_cookie 0039 __Wcrtomb 0074 _memcpy 0088 @__security_check_cookie@4"
		altNames = "?do_unshift@?$codecvt@GDU_Mbstatet@@@std@@MBEHAAU_Mbstatet@@PAD1AAPAD@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 08 8B 45 0C 53 8B 5D 14 56 57 33 FF 89 55 F0 89 03 8B 02 89 45 EC 8B 42 04 89 45 E8 8D 41 08 50 52 8D 45 F4 57 50 E8 ?? ?? ?? ?? 8B F0 83 C4 10 85 F6 7F 05 6A 02 5F EB 32 8B 45 10 4E 2B 03 3B C6 7D 13 8B 45 F0 33 FF 8B 4D EC 47 89 08 8B 4D E8 89 48 04 EB 15 85 F6 7E 11 56 8D 45 F4 50 FF 33 E8 ?? ?? ?? ?? 83 C4 0C 01 33 8B 4D FC 8B C7 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_3_344_1 {
	meta:
		name = "?do_widen@?$ctype@_W@std@@MBEPBDPBD0PA_W@Z"
		size = 78
		refs = "002a ?_Dowiden@?$ctype@_W@std@@IBE_WD@Z"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 83 65 FC 00 56 8B 75 08 2B C6 39 75 0C 57 1B FF 89 4D F8 F7 D7 23 F8 74 23 53 8B 5D 10 0F B6 06 50 E8 ?? ?? ?? ?? 8B 4D F8 46 66 89 03 8D 5B 02 8B 45 FC 40 89 45 FC 3B C7 75 E2 5B 5F 8B C6 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_56_345_1 {
	meta:
		name = "?do_widen@?$ctype@G@std@@MBEPBDPBD0PAG@Z"
		size = 78
		refs = "002a ?_Dowiden@?$ctype@G@std@@IBEGD@Z"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 83 65 FC 00 56 8B 75 08 2B C6 39 75 0C 57 1B FF 89 4D F8 F7 D7 23 F8 74 23 53 8B 5D 10 0F B6 06 50 E8 ?? ?? ?? ?? 8B 4D F8 46 66 89 03 8D 5B 02 8B 45 FC 40 89 45 FC 3B C7 75 E2 5B 5F 8B C6 5E 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_351_1 {
	meta:
		name = "?eq_int_type@?$char_traits@_W@std@@SA_NABG0@Z"
		size = 20
		altNames = "?eq_int_type@?$char_traits@G@std@@SA_NABG0@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 66 8B 08 8B 45 0C 66 3B 08 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_3_352_1 {
	meta:
		name = "?equivalent@error_category@std@@UBE_NABVerror_code@2@H@Z"
		size = 37
	strings:
		$1 = { 55 8B EC 8B 41 04 56 8B 75 08 8B 56 04 3B 42 04 75 0C 8B 06 3B 45 0C 75 05 33 C0 40 EB 02 33 C0 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_3_353_1 {
	meta:
		name = "?equivalent@error_category@std@@UBE_NHABVerror_condition@2@@Z"
		size = 51
		refs = "001b @_guard_check_icall@4 0025 ??8std@@YA_NABVerror_condition@0@0@Z"
	strings:
		$1 = { 55 8B EC 51 51 56 57 FF 75 0C 8B F9 8D 4D F8 FF 75 08 51 8B 07 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 50 E8 ?? ?? ?? ?? 59 59 5F 5E 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_356_1 {
	meta:
		name = "?gbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXH@Z"
		size = 23
		altNames = "?gbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXH@Z"
	strings:
		$1 = { 55 8B EC 8B 41 2C 8B 55 08 29 10 8B 49 1C 8D 04 12 01 01 5D C2 04 00 }
	condition:
		$1
}

rule file_3_359_1 {
	meta:
		name = "?imbue@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEXABVlocale@2@@Z"
		size = 28
		refs = "000a ??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@_WDU_Mbstatet@@@0@ABVlocale@0@@Z 0013 ?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 59 50 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_23_351_1 {
	meta:
		name = "?imbue@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAEXABVlocale@2@@Z"
		size = 28
		refs = "000a ??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@DDU_Mbstatet@@@0@ABVlocale@0@@Z 0013 ?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAEXPBV?$codecvt@DDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 59 50 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_56_359_1 {
	meta:
		name = "?imbue@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEXABVlocale@2@@Z"
		size = 28
		refs = "000a ??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAABV?$codecvt@GDU_Mbstatet@@@0@ABVlocale@0@@Z 0013 ?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPBV?$codecvt@GDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 55 8B EC 56 FF 75 08 8B F1 E8 ?? ?? ?? ?? 59 50 8B CE E8 ?? ?? ?? ?? 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_361_1 {
	meta:
		name = "?in@?$codecvt@_WDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PBD1AAPBDPA_W3AAPA_W@Z"
		size = 49
		refs = "0022 @_guard_check_icall@4"
		altNames = "?in@?$codecvt@DDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z ?in@?$codecvt@GDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PBD1AAPBDPAG3AAPAG@Z"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 20 8B F9 FF 75 1C FF 75 18 8B 37 FF 75 14 FF 75 10 8B 4E 18 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B CF FF 56 18 5F 5E 5D C2 1C 00 }
	condition:
		$1
}

rule file_3_362_1 {
	meta:
		name = "?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IAEXPAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z"
		size = 74
		refs = "0007 ?_Init@ios_base@std@@IAEXXZ 001a ?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0034 ?clear@ios_base@std@@QAEXH_N@Z 0040 ?_Addstd@ios_base@std@@SAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 8B 45 08 8B CE 83 66 3C 00 6A 20 89 46 38 E8 ?? ?? ?? ?? 83 7E 38 00 66 89 46 40 75 10 8B 46 0C 8B CE 83 C8 04 6A 00 50 E8 ?? ?? ?? ?? 80 7D 0C 00 74 07 56 E8 ?? ?? ?? ?? 59 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_56_362_1 {
	meta:
		name = "?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IAEXPAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z"
		size = 74
		refs = "0007 ?_Init@ios_base@std@@IAEXXZ 001a ?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0034 ?clear@ios_base@std@@QAEXH_N@Z 0040 ?_Addstd@ios_base@std@@SAXPAV12@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 8B 45 08 8B CE 83 66 3C 00 6A 20 89 46 38 E8 ?? ?? ?? ?? 83 7E 38 00 66 89 46 40 75 10 8B 46 0C 8B CE 83 C8 04 6A 00 50 E8 ?? ?? ?? ?? 80 7D 0C 00 74 07 56 E8 ?? ?? ?? ?? 59 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_3_364_1 {
	meta:
		name = "?is@?$ctype@_W@std@@QBE_NF_W@Z"
		size = 35
		refs = "0015 @_guard_check_icall@4"
		altNames = "?is@?$ctype@G@std@@QBE_NFG@Z"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 0C 8B F9 FF 75 08 8B 07 8B 70 10 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_3_366_1 {
	meta:
		name = "?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z"
		size = 23
		refs = "0004 ??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAAV_Iostream_error_category@0@XZ"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 8B 55 08 8B 4D 0C 89 42 04 8B C2 89 0A 5D C3 }
	condition:
		$1
}

rule file_3_371_1 {
	meta:
		name = "?message@_Generic_error_category@std@@UBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 35
		refs = "000c ?_Syserror_map@std@@YAPBDH@Z 0016 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z"
	strings:
		$1 = { 55 8B EC 51 FF 75 0C 83 65 FC 00 E8 ?? ?? ?? ?? 59 8B 4D 08 50 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_372_1 {
	meta:
		name = "?message@_Iostream_error_category@std@@UBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 49
		refs = "0012 ??_C@_0BG@PADBLCHM@iostream?5stream?5error?$AA@ 0017 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@PBD@Z 0024 ?message@_Generic_error_category@std@@UBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 83 7D 0C 01 75 0F 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0B FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C2 08 00 }
	condition:
		$1
}

rule file_3_373_1 {
	meta:
		name = "?message@error_code@std@@QBE?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 45
		refs = "001a @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 56 57 8B 79 04 FF 31 FF 75 08 8B 17 8B 72 08 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 8B 45 08 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_377_1 {
	meta:
		name = "?not_eof@?$char_traits@_W@std@@SAGABG@Z"
		size = 23
		altNames = "?not_eof@?$char_traits@G@std@@SAGABG@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 B9 FF FF 00 00 0F B7 00 66 3B C1 75 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_3_378_1 {
	meta:
		name = "?out@?$codecvt@_WDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PB_W1AAPB_WPAD3AAPAD@Z"
		size = 49
		refs = "0022 @_guard_check_icall@4"
		altNames = "?out@?$codecvt@DDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PBD1AAPBDPAD3AAPAD@Z ?out@?$codecvt@GDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PBG1AAPBGPAD3AAPAD@Z"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 20 8B F9 FF 75 1C FF 75 18 8B 37 FF 75 14 FF 75 10 8B 4E 1C FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B CF FF 56 1C 5F 5E 5D C2 1C 00 }
	condition:
		$1
}

rule file_3_379_1 {
	meta:
		name = "?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z"
		size = 589
		refs = "0003 __ehhandler$?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z 0008 __EH_prolog3_GS 0066 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAEXXZ 0075 ??$_Fputc@_W@std@@YA_N_WPAU_iobuf@@@Z 0090 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 00a0 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 00a7 ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ 00eb @_guard_check_icall@4 0144 _fwrite 0190 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 01fe ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0206 __EH_epilog3_GS"
	strings:
		$1 = { 6A 6C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 C8 83 65 CC 00 BB FF FF 00 00 8B 7D 08 66 3B DF 75 07 33 C0 E9 DC 01 00 00 8B 46 20 8B 08 85 C9 74 23 8B 56 30 8B 02 8D 04 41 3B C8 73 17 FF 0A 66 8B C7 8B 56 20 8B 32 8D 4E 02 89 0A 66 89 3E E9 B0 01 00 00 83 7E 4C 00 75 08 66 8B C3 E9 A2 01 00 00 8B CE E8 ?? ?? ?? ?? 83 7E 38 00 75 14 FF 76 4C 57 E8 ?? ?? ?? ?? 59 59 84 C0 74 DC 0F B7 DF EB D7 6A 00 6A 08 8D 4D D4 66 89 7D D0 E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 AC 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7D E8 8D 4D D4 8B D8 8D 45 A0 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4E 38 8D 56 40 89 4D C4 89 55 B8 8B 31 8D 4D C0 51 8D 0C 1F 51 8B 4E 1C 50 8D 45 BC 50 8D 45 D2 50 8D 45 D0 50 52 E8 ?? ?? ?? ?? 8B 4D C4 FF 56 1C E9 F3 00 00 00 83 F8 01 0F 8F 1C 01 00 00 8D 45 94 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 75 C0 8B 5D CC 2B F0 74 33 8D 45 88 83 CB 01 50 8D 4D D4 89 5D CC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7D C8 FF 77 4C 56 6A 01 50 E8 ?? ?? ?? ?? 83 C4 10 3B F0 74 07 B0 01 EB 05 8B 7D C8 32 C0 F6 C3 01 74 06 83 E3 FE 89 5D CC 84 C0 0F 85 AA 00 00 00 8D 45 D0 C6 47 3E 01 39 45 BC 0F 85 92 00 00 00 85 F6 75 15 83 7D E8 20 0F 83 B7 00 00 00 56 6A 08 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 AC 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 75 E8 8D 4D D4 8B D8 8D 45 A0 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4F 38 89 4D C4 8B 39 8D 4D C0 51 8D 0C 1E 51 8B 4F 1C 50 8D 45 BC 50 8D 45 D2 50 8D 45 D0 50 FF 75 B8 E8 ?? ?? ?? ?? 8B 4D C4 FF 57 1C 85 C0 0F 89 05 FF FF FF BE FF FF 00 00 8D 4D D4 E8 ?? ?? ?? ?? 66 8B C6 E8 ?? ?? ?? ?? C2 04 00 8B 45 08 0F B7 F0 EB 05 BE FF FF 00 00 0F B7 F6 EB 26 83 F8 03 75 D1 8B 45 C8 FF 70 4C FF 75 D0 E8 ?? ?? ?? ?? 59 59 84 C0 74 08 8B 45 08 0F B7 F0 EB 05 BE FF FF 00 00 0F B7 C6 0F B7 F0 EB AD }
	condition:
		$1
}

rule file_56_379_1 {
	meta:
		name = "?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z"
		size = 589
		refs = "0003 __ehhandler$?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z 0008 __EH_prolog3_GS 0066 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAEXXZ 0075 ??$_Fputc@G@std@@YA_NGPAU_iobuf@@@Z 0090 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@ID@Z 00a0 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 00a7 ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ 00eb @_guard_check_icall@4 0144 _fwrite 0190 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 01fe ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 0206 __EH_epilog3_GS"
	strings:
		$1 = { 6A 6C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 C8 83 65 CC 00 BB FF FF 00 00 8B 7D 08 66 3B DF 75 07 33 C0 E9 DC 01 00 00 8B 46 20 8B 08 85 C9 74 23 8B 56 30 8B 02 8D 04 41 3B C8 73 17 FF 0A 66 8B C7 8B 56 20 8B 32 8D 4E 02 89 0A 66 89 3E E9 B0 01 00 00 83 7E 4C 00 75 08 66 8B C3 E9 A2 01 00 00 8B CE E8 ?? ?? ?? ?? 83 7E 38 00 75 14 FF 76 4C 57 E8 ?? ?? ?? ?? 59 59 84 C0 74 DC 0F B7 DF EB D7 6A 00 6A 08 8D 4D D4 66 89 7D D0 E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 AC 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7D E8 8D 4D D4 8B D8 8D 45 A0 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4E 38 8D 56 40 89 4D C4 89 55 B8 8B 31 8D 4D C0 51 8D 0C 1F 51 8B 4E 1C 50 8D 45 BC 50 8D 45 D2 50 8D 45 D0 50 52 E8 ?? ?? ?? ?? 8B 4D C4 FF 56 1C E9 F3 00 00 00 83 F8 01 0F 8F 1C 01 00 00 8D 45 94 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 75 C0 8B 5D CC 2B F0 74 33 8D 45 88 83 CB 01 50 8D 4D D4 89 5D CC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7D C8 FF 77 4C 56 6A 01 50 E8 ?? ?? ?? ?? 83 C4 10 3B F0 74 07 B0 01 EB 05 8B 7D C8 32 C0 F6 C3 01 74 06 83 E3 FE 89 5D CC 84 C0 0F 85 AA 00 00 00 8D 45 D0 C6 47 3E 01 39 45 BC 0F 85 92 00 00 00 85 F6 75 15 83 7D E8 20 0F 83 B7 00 00 00 56 6A 08 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 AC 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 75 E8 8D 4D D4 8B D8 8D 45 A0 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4F 38 89 4D C4 8B 39 8D 4D C0 51 8D 0C 1E 51 8B 4F 1C 50 8D 45 BC 50 8D 45 D2 50 8D 45 D0 50 FF 75 B8 E8 ?? ?? ?? ?? 8B 4D C4 FF 57 1C 85 C0 0F 89 05 FF FF FF BE FF FF 00 00 8D 4D D4 E8 ?? ?? ?? ?? 66 8B C6 E8 ?? ?? ?? ?? C2 04 00 8B 45 08 0F B7 F0 EB 05 BE FF FF 00 00 0F B7 F6 EB 26 83 F8 03 75 D1 8B 45 C8 FF 70 4C FF 75 D0 E8 ?? ?? ?? ?? 59 59 84 C0 74 08 8B 45 08 0F B7 F0 EB 05 BE FF FF 00 00 0F B7 C6 0F B7 F0 EB AD }
	condition:
		$1
}

rule file_3_383_1 {
	meta:
		name = "?pbackfail@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGG@Z"
		size = 148
		refs = "0063 ??$_Ungetc@_W@std@@YA_NAB_WPAU_iobuf@@@Z 0082 ?_Set_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 53 56 66 8B 75 08 BB FF FF 00 00 57 8B F9 8B 47 1C 8B 08 85 C9 74 2B 8B 47 0C 39 08 73 24 66 3B DE 74 06 66 39 71 FE 75 19 8B 47 2C FF 00 8B 47 1C 83 00 FE 66 3B F3 74 05 0F B7 C6 EB 49 33 C0 EB 45 83 7F 4C 00 74 3C 66 3B DE 74 37 83 7F 38 00 75 1B FF 77 4C 8D 45 FE 66 89 75 FE 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 05 66 8B C6 EB 19 8B 47 1C 8D 4F 3C 39 08 74 0C 66 89 31 8B CF E8 ?? ?? ?? ?? EB E5 66 8B C3 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_56_383_1 {
	meta:
		name = "?pbackfail@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGG@Z"
		size = 148
		refs = "0063 ??$_Ungetc@G@std@@YA_NABGPAU_iobuf@@@Z 0082 ?_Set_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAEXXZ"
	strings:
		$1 = { 55 8B EC 51 53 56 66 8B 75 08 BB FF FF 00 00 57 8B F9 8B 47 1C 8B 08 85 C9 74 2B 8B 47 0C 39 08 73 24 66 3B DE 74 06 66 39 71 FE 75 19 8B 47 2C FF 00 8B 47 1C 83 00 FE 66 3B F3 74 05 0F B7 C6 EB 49 33 C0 EB 45 83 7F 4C 00 74 3C 66 3B DE 74 37 83 7F 38 00 75 1B FF 77 4C 8D 45 FE 66 89 75 FE 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 05 66 8B C6 EB 19 8B 47 1C 8D 4F 3C 39 08 74 0C 66 89 31 8B CF E8 ?? ?? ?? ?? EB E5 66 8B C3 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_3_385_1 {
	meta:
		name = "?pbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXH@Z"
		size = 23
		altNames = "?pbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXH@Z"
	strings:
		$1 = { 55 8B EC 8B 41 30 8B 55 08 29 10 8B 49 20 8D 04 12 01 01 5D C2 04 00 }
	condition:
		$1
}

rule file_3_390_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 193
		refs = "003b ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ 0058 __fseeki64 006b _fgetpos 0078 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAEXXZ 008c ??0?$fpos@U_Mbstatet@@@std@@QAE@U_Mbstatet@@_J@Z 0099 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B F1 57 8B 56 1C 8D 46 3C 39 02 75 1A 83 7D 14 01 75 14 83 7E 38 00 75 0E 8B 7D 0C 8B 5D 10 83 C7 FE 83 D3 FF EB 06 8B 5D 10 8B 7D 0C 83 7E 4C 00 74 5B E8 ?? ?? ?? ?? 84 C0 74 52 8B C7 0B C3 75 06 83 7D 14 01 74 14 FF 75 14 53 57 FF 76 4C E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 32 8D 45 F8 50 FF 76 4C E8 ?? ?? ?? ?? 59 59 85 C0 75 20 8B CE E8 ?? ?? ?? ?? FF 75 FC 8B 4D 08 FF 75 F8 FF 76 44 FF 76 40 E8 ?? ?? ?? ?? 8B 45 08 EB 23 8B 55 08 A1 ?? ?? ?? ?? 89 02 33 C0 8B 0D ?? ?? ?? ?? 89 42 08 89 42 0C 89 4A 04 89 42 10 89 42 14 8B C2 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_56_390_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 193
		refs = "003b ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ 0058 __fseeki64 006b _fgetpos 0078 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAEXXZ 008c ??0?$fpos@U_Mbstatet@@@std@@QAE@U_Mbstatet@@_J@Z 0099 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B F1 57 8B 56 1C 8D 46 3C 39 02 75 1A 83 7D 14 01 75 14 83 7E 38 00 75 0E 8B 7D 0C 8B 5D 10 83 C7 FE 83 D3 FF EB 06 8B 5D 10 8B 7D 0C 83 7E 4C 00 74 5B E8 ?? ?? ?? ?? 84 C0 74 52 8B C7 0B C3 75 06 83 7D 14 01 74 14 FF 75 14 53 57 FF 76 4C E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 32 8D 45 F8 50 FF 76 4C E8 ?? ?? ?? ?? 59 59 85 C0 75 20 8B CE E8 ?? ?? ?? ?? FF 75 FC 8B 4D 08 FF 75 F8 FF 76 44 FF 76 40 E8 ?? ?? ?? ?? 8B 45 08 EB 23 8B 55 08 A1 ?? ?? ?? ?? 89 02 33 C0 8B 0D ?? ?? ?? ?? 89 42 08 89 42 0C 89 4A 04 89 42 10 89 42 14 8B C2 5F 5E 5B 8B E5 5D C2 14 00 }
	condition:
		$1
}

rule file_3_391_1 {
	meta:
		name = "?seekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 42
		refs = "0007 ?_BADOFF@std@@3_JB"
		altNames = "?seekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@_JHH@Z ?seekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 A1 ?? ?? ?? ?? 89 02 33 C0 8B 0D ?? ?? ?? ?? 89 42 08 89 42 0C 89 4A 04 89 42 10 89 42 14 8B C2 5D C2 14 00 }
	condition:
		$1
}

rule file_3_392_1 {
	meta:
		name = "?seekpos@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 192
		refs = "0023 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAE_NXZ 0033 _fsetpos 004b __fseeki64 005e _fgetpos 0077 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAEXXZ 008b ??0?$fpos@U_Mbstatet@@@std@@QAE@U_Mbstatet@@_J@Z 0098 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 14 53 8B 5D 10 56 8B F1 89 45 F8 8B 45 18 57 8B 7D 0C 83 7E 4C 00 89 45 FC 74 72 E8 ?? ?? ?? ?? 84 C0 74 69 8D 45 F8 50 FF 76 4C E8 ?? ?? ?? ?? 59 59 85 C0 75 57 8B C7 0B C3 74 13 6A 01 53 57 FF 76 4C E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 3E 8D 45 F8 50 FF 76 4C E8 ?? ?? ?? ?? 59 59 85 C0 75 2C 8B 45 1C 8B CE 89 46 40 8B 45 20 89 46 44 E8 ?? ?? ?? ?? FF 75 FC 8B 4D 08 FF 75 F8 FF 76 44 FF 76 40 E8 ?? ?? ?? ?? 8B 45 08 EB 23 8B 55 08 A1 ?? ?? ?? ?? 89 02 33 C0 8B 0D ?? ?? ?? ?? 89 42 08 89 42 0C 89 4A 04 89 42 10 89 42 14 8B C2 5F 5E 5B 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_23_383_1 {
	meta:
		name = "?seekpos@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 192
		refs = "0023 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IAE_NXZ 0033 _fsetpos 004b __fseeki64 005e _fgetpos 0077 ?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AAEXXZ 008b ??0?$fpos@U_Mbstatet@@@std@@QAE@U_Mbstatet@@_J@Z 0098 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 14 53 8B 5D 10 56 8B F1 89 45 F8 8B 45 18 57 8B 7D 0C 83 7E 4C 00 89 45 FC 74 72 E8 ?? ?? ?? ?? 84 C0 74 69 8D 45 F8 50 FF 76 4C E8 ?? ?? ?? ?? 59 59 85 C0 75 57 8B C7 0B C3 74 13 6A 01 53 57 FF 76 4C E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 3E 8D 45 F8 50 FF 76 4C E8 ?? ?? ?? ?? 59 59 85 C0 75 2C 8B 45 1C 8B CE 89 46 40 8B 45 20 89 46 44 E8 ?? ?? ?? ?? FF 75 FC 8B 4D 08 FF 75 F8 FF 76 44 FF 76 40 E8 ?? ?? ?? ?? 8B 45 08 EB 23 8B 55 08 A1 ?? ?? ?? ?? 89 02 33 C0 8B 0D ?? ?? ?? ?? 89 42 08 89 42 0C 89 4A 04 89 42 10 89 42 14 8B C2 5F 5E 5B 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_56_392_1 {
	meta:
		name = "?seekpos@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 192
		refs = "0023 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAE_NXZ 0033 _fsetpos 004b __fseeki64 005e _fgetpos 0077 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAEXXZ 008b ??0?$fpos@U_Mbstatet@@@std@@QAE@U_Mbstatet@@_J@Z 0098 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 14 53 8B 5D 10 56 8B F1 89 45 F8 8B 45 18 57 8B 7D 0C 83 7E 4C 00 89 45 FC 74 72 E8 ?? ?? ?? ?? 84 C0 74 69 8D 45 F8 50 FF 76 4C E8 ?? ?? ?? ?? 59 59 85 C0 75 57 8B C7 0B C3 74 13 6A 01 53 57 FF 76 4C E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 3E 8D 45 F8 50 FF 76 4C E8 ?? ?? ?? ?? 59 59 85 C0 75 2C 8B 45 1C 8B CE 89 46 40 8B 45 20 89 46 44 E8 ?? ?? ?? ?? FF 75 FC 8B 4D 08 FF 75 F8 FF 76 44 FF 76 40 E8 ?? ?? ?? ?? 8B 45 08 EB 23 8B 55 08 A1 ?? ?? ?? ?? 89 02 33 C0 8B 0D ?? ?? ?? ?? 89 42 08 89 42 0C 89 4A 04 89 42 10 89 42 14 8B C2 5F 5E 5B 8B E5 5D C2 20 00 }
	condition:
		$1
}

rule file_3_393_1 {
	meta:
		name = "?seekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 42
		refs = "0007 ?_BADOFF@std@@3_JB"
		altNames = "?seekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@V32@H@Z ?seekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAE?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
	strings:
		$1 = { 55 8B EC 8B 55 08 A1 ?? ?? ?? ?? 89 02 33 C0 8B 0D ?? ?? ?? ?? 89 42 08 89 42 0C 89 4A 04 89 42 10 89 42 14 8B C2 5D C2 20 00 }
	condition:
		$1
}

rule file_3_397_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEPAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@PA_W_J@Z"
		size = 81
		refs = "002f _setvbuf 0042 ?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 83 7E 4C 00 74 3E 83 7D 08 00 8B 55 0C 75 0C 8B C2 0B 45 10 75 05 6A 04 59 EB 02 33 C9 8D 04 12 50 51 FF 75 08 FF 76 4C E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 10 6A 01 FF 76 4C 8B CE E8 ?? ?? ?? ?? 8B C6 EB 02 33 C0 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_56_397_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEPAV?$basic_streambuf@GU?$char_traits@G@std@@@2@PAG_J@Z"
		size = 81
		refs = "002f _setvbuf 0042 ?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 55 8B EC 56 8B F1 83 7E 4C 00 74 3E 83 7D 08 00 8B 55 0C 75 0C 8B C2 0B 45 10 75 05 6A 04 59 EB 02 33 C9 8D 04 12 50 51 FF 75 08 FF 76 4C E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 10 6A 01 FF 76 4C 8B CE E8 ?? ?? ?? ?? 8B C6 EB 02 33 C0 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_399_1 {
	meta:
		name = "?setf@ios_base@std@@QAEHH@Z"
		size = 19
	strings:
		$1 = { 55 8B EC 8B 41 14 0F B7 55 08 0B D0 89 51 14 5D C2 04 00 }
	condition:
		$1
}

rule file_3_400_1 {
	meta:
		name = "?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXPA_W00@Z"
		size = 37
		altNames = "?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXPAG00@Z"
	strings:
		$1 = { 55 8B EC 8B 51 0C 8B 45 08 56 8B 75 10 89 02 8B 41 1C 8B 55 0C 2B F2 D1 FE 89 10 8B 41 2C 89 30 5E 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_401_1 {
	meta:
		name = "?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAEXPA_W0@Z"
		size = 34
		altNames = "?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAEXPAG0@Z"
	strings:
		$1 = { 55 8B EC 8B 41 10 8B 55 0C 56 8B 75 08 2B D6 89 30 8B 41 20 D1 FA 89 30 8B 41 30 5E 89 10 5D C2 08 00 }
	condition:
		$1
}

rule file_3_402_1 {
	meta:
		name = "?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAEXH_N@Z"
		size = 37
		refs = "001d ?clear@ios_base@std@@QAEXH_N@Z"
		altNames = "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QAEXH_N@Z ?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QAEXH_N@Z"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 18 8B 41 0C 0B 45 08 83 79 38 00 75 03 83 C8 04 FF 75 0C 50 E8 ?? ?? ?? ?? 5D C2 08 00 }
	condition:
		$1
}

rule file_3_405_1 {
	meta:
		name = "?state@?$fpos@U_Mbstatet@@@std@@QBE?AU_Mbstatet@@XZ"
		size = 21
	strings:
		$1 = { 55 8B EC 8B 45 08 8B 51 10 8B 49 14 89 10 89 48 04 5D C2 04 00 }
	condition:
		$1
}

rule file_3_406_1 {
	meta:
		name = "?sync@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEHXZ"
		size = 66
		refs = "001a @_guard_check_icall@4 0031 _fflush"
		altNames = "?sync@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEHXZ"
	strings:
		$1 = { 53 8B D9 57 33 FF 39 7B 4C 74 32 8B 03 B9 FF FF 00 00 56 51 8B 70 0C 8B CE E8 ?? ?? ?? ?? 8B CB FF D6 B9 FF FF 00 00 5E 66 3B C8 74 10 FF 73 4C E8 ?? ?? ?? ?? 59 85 C0 79 03 83 CF FF 8B C7 5F 5B C3 }
	condition:
		$1
}

rule file_3_408_1 {
	meta:
		name = "?tie@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QAEPAV?$basic_ostream@_WU?$char_traits@_W@std@@@2@PAV32@@Z"
		size = 16
		altNames = "?tie@?$basic_ios@DU?$char_traits@D@std@@@std@@QAEPAV?$basic_ostream@DU?$char_traits@D@std@@@2@PAV32@@Z ?tie@?$basic_ios@GU?$char_traits@G@std@@@std@@QAEPAV?$basic_ostream@GU?$char_traits@G@std@@@2@PAV32@@Z"
	strings:
		$1 = { 55 8B EC 8B 41 3C 8B 55 08 89 51 3C 5D C2 04 00 }
	condition:
		$1
}

rule file_3_411_1 {
	meta:
		name = "?uflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGXZ"
		size = 497
		refs = "0003 __ehhandler$?uflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGXZ 0008 __EH_prolog3_GS 0051 ?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AAEXXZ 0068 ??$_Fgetc@_W@std@@YA_NAA_WPAU_iobuf@@@Z 007f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 008a _fgetc 00a5 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00b1 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 00b8 ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ 00fa @_guard_check_icall@4 013c _memcpy_s 0170 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@II@Z 01a1 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 01a9 __EH_epilog3_GS 01d5 _ungetc"
	strings:
		$1 = { 6A 5C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 C4 8B 46 1C 8B 08 85 C9 74 23 8B 56 2C 8B 3A 8D 04 79 3B C8 73 17 8D 47 FF 89 02 8B 56 1C 8B 02 8D 48 02 89 0A 66 8B 00 E9 6B 01 00 00 33 DB 39 5E 4C 75 0A B8 FF FF 00 00 E9 5A 01 00 00 8B CE E8 ?? ?? ?? ?? 39 5E 38 75 21 FF 76 4C 33 C0 66 89 45 CC 8D 45 CC 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 D2 66 8B 45 CC E9 2D 01 00 00 8D 4D D4 E8 ?? ?? ?? ?? FF 76 4C 89 5D FC E8 ?? ?? ?? ?? 59 83 F8 FF 0F 84 F1 00 00 00 8D 4E 40 89 4D C8 50 6A 01 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 A4 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 5D E8 8D 4D D4 89 45 C0 8D 45 98 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7E 38 8B D0 8D 45 BC 50 8D 45 D2 8B 37 50 8D 45 D0 50 8B 4E 18 8D 45 CC 50 8B 45 C0 03 C3 50 52 FF 75 C8 E8 ?? ?? ?? ?? 8B CF FF 56 18 85 C0 0F 88 DF 00 00 00 83 F8 01 7E 39 83 F8 03 0F 85 D1 00 00 00 83 7D E8 02 72 55 8D 45 B0 50 8D 4D D4 E8 ?? ?? ?? ?? 6A 02 8B C8 E8 ?? ?? ?? ?? 50 8D 45 D0 6A 02 50 E8 ?? ?? ?? ?? 66 8B 45 D0 83 C4 10 EB 51 8D 45 D0 39 45 BC 8D 4D D4 8D 45 B0 50 75 56 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D CC 2B C8 51 6A 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 75 C4 FF 76 4C E8 ?? ?? ?? ?? 59 83 F8 FF 0F 85 15 FF FF FF C7 45 C8 FF FF 00 00 66 8B 45 C8 0F B7 C0 89 45 C8 0F B7 F0 8D 4D D4 E8 ?? ?? ?? ?? 66 8B C6 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7D E8 8B 4D CC 2B F9 03 F8 85 FF 7E 1C 8B 75 C4 FF 76 4C 4F 0F BE 04 0F 50 E8 ?? ?? ?? ?? 59 59 85 FF 7E 05 8B 4D CC EB E7 66 8B 45 D0 EB AA BE FF FF 00 00 EB AC }
	condition:
		$1
}

rule file_56_410_1 {
	meta:
		name = "?uflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGXZ"
		size = 497
		refs = "0003 __ehhandler$?uflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGXZ 0008 __EH_prolog3_GS 0051 ?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AAEXXZ 0068 ??$_Fgetc@G@std@@YA_NAAGPAU_iobuf@@@Z 007f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 008a _fgetc 00a5 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@ID@Z 00b1 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 00b8 ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QBEABDXZ 00fa @_guard_check_icall@4 013c _memcpy_s 0170 ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAEAAV12@II@Z 01a1 ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QAE@XZ 01a9 __EH_epilog3_GS 01d5 _ungetc"
	strings:
		$1 = { 6A 5C B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F1 89 75 C4 8B 46 1C 8B 08 85 C9 74 23 8B 56 2C 8B 3A 8D 04 79 3B C8 73 17 8D 47 FF 89 02 8B 56 1C 8B 02 8D 48 02 89 0A 66 8B 00 E9 6B 01 00 00 33 DB 39 5E 4C 75 0A B8 FF FF 00 00 E9 5A 01 00 00 8B CE E8 ?? ?? ?? ?? 39 5E 38 75 21 FF 76 4C 33 C0 66 89 45 CC 8D 45 CC 50 E8 ?? ?? ?? ?? 59 59 84 C0 74 D2 66 8B 45 CC E9 2D 01 00 00 8D 4D D4 E8 ?? ?? ?? ?? FF 76 4C 89 5D FC E8 ?? ?? ?? ?? 59 83 F8 FF 0F 84 F1 00 00 00 8D 4E 40 89 4D C8 50 6A 01 8D 4D D4 E8 ?? ?? ?? ?? 8D 45 A4 50 8D 4D D4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 5D E8 8D 4D D4 89 45 C0 8D 45 98 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7E 38 8B D0 8D 45 BC 50 8D 45 D2 8B 37 50 8D 45 D0 50 8B 4E 18 8D 45 CC 50 8B 45 C0 03 C3 50 52 FF 75 C8 E8 ?? ?? ?? ?? 8B CF FF 56 18 85 C0 0F 88 DF 00 00 00 83 F8 01 7E 39 83 F8 03 0F 85 D1 00 00 00 83 7D E8 02 72 55 8D 45 B0 50 8D 4D D4 E8 ?? ?? ?? ?? 6A 02 8B C8 E8 ?? ?? ?? ?? 50 8D 45 D0 6A 02 50 E8 ?? ?? ?? ?? 66 8B 45 D0 83 C4 10 EB 51 8D 45 D0 39 45 BC 8D 4D D4 8D 45 B0 50 75 56 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4D CC 2B C8 51 6A 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 75 C4 FF 76 4C E8 ?? ?? ?? ?? 59 83 F8 FF 0F 85 15 FF FF FF C7 45 C8 FF FF 00 00 66 8B 45 C8 0F B7 C0 89 45 C8 0F B7 F0 8D 4D D4 E8 ?? ?? ?? ?? 66 8B C6 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 7D E8 8B 4D CC 2B F9 03 F8 85 FF 7E 1C 8B 75 C4 FF 76 4C 4F 0F BE 04 0F 50 E8 ?? ?? ?? ?? 59 59 85 FF 7E 05 8B 4D CC EB E7 66 8B 45 D0 EB AA BE FF FF 00 00 EB AC }
	condition:
		$1
}

rule file_3_414_1 {
	meta:
		name = "?uflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAEGXZ"
		size = 54
		refs = "000c @_guard_check_icall@4"
		altNames = "?uflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAEGXZ"
	strings:
		$1 = { 56 57 8B F9 8B 07 8B 70 18 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 BA FF FF 00 00 66 3B D0 74 12 8B 47 2C FF 08 8B 4F 1C 8B 11 8D 42 02 89 01 0F B7 12 5F 66 8B C2 5E C3 }
	condition:
		$1
}

rule file_3_415_1 {
	meta:
		name = "?underflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MAEGXZ"
		size = 84
		refs = "0027 @_guard_check_icall@4"
		altNames = "?underflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MAEGXZ"
	strings:
		$1 = { 57 8B F9 8B 47 1C 8B 00 85 C0 74 11 8B 57 2C 8B 12 8D 14 50 3B C2 73 05 66 8B 00 5F C3 8B 07 53 56 8B 70 1C 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 0F B7 D8 B8 FF FF 00 00 66 3B C3 74 14 8B 0F 53 8B 71 10 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 66 8B C3 5E 5B 5F C3 }
	condition:
		$1
}

rule file_3_417_1 {
	meta:
		name = "?unshift@?$codecvt@_WDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PAD1AAPAD@Z"
		size = 41
		refs = "001b @_guard_check_icall@4"
		altNames = "?unshift@?$codecvt@DDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PAD1AAPAD@Z ?unshift@?$codecvt@GDU_Mbstatet@@@std@@QBEHAAU_Mbstatet@@PAD1AAPAD@Z"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 14 8B F9 FF 75 10 FF 75 0C 8B 07 FF 75 08 8B 70 20 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5F 5E 5D C2 10 00 }
	condition:
		$1
}

rule file_3_421_1 {
	meta:
		name = "?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 73
		refs = "0003 __ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0008 __EH_prolog3 0011 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 001b ??$use_facet@V?$ctype@_W@std@@@std@@YAABV?$ctype@_W@0@ABVlocale@0@@Z 002a ??1locale@std@@QAE@XZ 0039 @_guard_check_icall@4 0042 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 E8 ?? ?? ?? ?? 83 4D FC FF 8B F8 59 8D 4D EC E8 ?? ?? ?? ?? 8B 0F FF 75 08 8B 71 30 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_56_420_1 {
	meta:
		name = "?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 73
		refs = "0003 __ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0008 __EH_prolog3 0011 ?getloc@ios_base@std@@QBE?AVlocale@2@XZ 001b ??$use_facet@V?$ctype@G@std@@@std@@YAABV?$ctype@G@0@ABVlocale@0@@Z 002a ??1locale@std@@QAE@XZ 0039 @_guard_check_icall@4 0042 __EH_epilog3"
	strings:
		$1 = { 6A 08 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 83 65 FC 00 50 E8 ?? ?? ?? ?? 83 4D FC FF 8B F8 59 8D 4D EC E8 ?? ?? ?? ?? 8B 0F FF 75 08 8B 71 30 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_3_424_1 {
	meta:
		name = "?widen@?$ctype@_W@std@@QBE_WD@Z"
		size = 32
		refs = "0012 @_guard_check_icall@4"
		altNames = "?widen@?$ctype@G@std@@QBEGD@Z"
	strings:
		$1 = { 55 8B EC 56 57 FF 75 08 8B F9 8B 07 8B 70 30 8B CE E8 ?? ?? ?? ?? 8B CF FF D6 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_3_425_1 {
	meta:
		name = "?xsgetn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAE_JPA_W_J@Z"
		size = 252
		refs = "006f ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 00a4 @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 10 33 D2 89 4D F4 33 C9 89 4D FC 89 55 F8 85 DB 0F 8C D4 00 00 00 57 8B 7D 0C 7F 08 85 FF 0F 84 C5 00 00 00 8B 4D F4 56 8B 41 1C 8B 00 89 45 EC 85 C0 74 07 8B 41 2C 8B 00 EB 02 33 C0 99 8B F0 8B C2 89 45 F0 85 C0 7C 4A 7F 04 85 F6 74 44 3B D8 7F 0B 7C 04 3B FE 73 05 8B F7 89 5D F0 56 FF 75 EC FF 75 08 E8 ?? ?? ?? ?? 8B 4D F4 83 C4 0C 01 75 FC 8B 55 F8 13 55 F0 2B FE 8B 41 2C 1B 5D F0 89 55 F8 8D 14 36 29 30 8B 41 1C 01 10 8B 45 08 EB 38 8B 01 8B 70 1C 8B CE E8 ?? ?? ?? ?? 8B 4D F4 FF D6 0F B7 C8 B8 FF FF 00 00 66 3B C1 74 31 83 45 FC 01 8B 45 08 83 55 F8 00 83 C7 FF 6A 02 83 D3 FF 66 89 08 8B 4D F4 5A 03 C2 89 45 08 85 DB 0F 8F 50 FF FF FF 7C 08 85 FF 0F 85 46 FF FF FF 8B 4D FC 8B 55 F8 5E 5F 8B C1 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_56_424_1 {
	meta:
		name = "?xsgetn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAE_JPAG_J@Z"
		size = 252
		refs = "006f ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 00a4 @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 10 33 D2 89 4D F4 33 C9 89 4D FC 89 55 F8 85 DB 0F 8C D4 00 00 00 57 8B 7D 0C 7F 08 85 FF 0F 84 C5 00 00 00 8B 4D F4 56 8B 41 1C 8B 00 89 45 EC 85 C0 74 07 8B 41 2C 8B 00 EB 02 33 C0 99 8B F0 8B C2 89 45 F0 85 C0 7C 4A 7F 04 85 F6 74 44 3B D8 7F 0B 7C 04 3B FE 73 05 8B F7 89 5D F0 56 FF 75 EC FF 75 08 E8 ?? ?? ?? ?? 8B 4D F4 83 C4 0C 01 75 FC 8B 55 F8 13 55 F0 2B FE 8B 41 2C 1B 5D F0 89 55 F8 8D 14 36 29 30 8B 41 1C 01 10 8B 45 08 EB 38 8B 01 8B 70 1C 8B CE E8 ?? ?? ?? ?? 8B 4D F4 FF D6 0F B7 C8 B8 FF FF 00 00 66 3B C1 74 31 83 45 FC 01 8B 45 08 83 55 F8 00 83 C7 FF 6A 02 83 D3 FF 66 89 08 8B 4D F4 5A 03 C2 89 45 08 85 DB 0F 8F 50 FF FF FF 7C 08 85 FF 0F 85 46 FF FF FF 8B 4D FC 8B 55 F8 5E 5F 8B C1 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_426_1 {
	meta:
		name = "?xsputn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MAE_JPB_W_J@Z"
		size = 255
		refs = "0070 ?copy@?$char_traits@_W@std@@SAPA_WPA_WPB_WI@Z 00b2 @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 10 33 D2 89 4D F4 33 C9 89 4D FC 89 55 F8 85 DB 0F 8C D7 00 00 00 57 8B 7D 0C 7F 08 85 FF 0F 84 C8 00 00 00 8B 4D F4 56 8B 41 20 8B 00 89 45 EC 85 C0 74 07 8B 41 30 8B 00 EB 02 33 C0 99 8B F0 8B C2 89 45 F0 85 C0 7C 51 7F 04 85 F6 74 4B 3B D8 7F 0B 7C 04 3B FE 73 05 8B F7 89 5D F0 8B 45 08 56 50 FF 75 EC E8 ?? ?? ?? ?? 8B 4D F4 8D 04 36 8B 55 F8 83 C4 0C 01 75 FC 89 45 EC 13 55 F0 2B FE 8B 41 30 1B 5D F0 89 55 F8 8D 14 36 29 30 8B 41 20 01 10 8B 45 EC EB 36 8B 09 8B 45 08 8B 71 0C 8B CE 0F B7 00 50 E8 ?? ?? ?? ?? 8B 4D F4 FF D6 B9 FF FF 00 00 66 3B C8 74 29 83 45 FC 01 8B 4D F4 83 55 F8 00 83 C7 FF 6A 02 83 D3 FF 58 01 45 08 85 DB 0F 8F 4D FF FF FF 7C 08 85 FF 0F 85 43 FF FF FF 8B 4D FC 8B 55 F8 5E 5F 8B C1 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_56_425_1 {
	meta:
		name = "?xsputn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MAE_JPBG_J@Z"
		size = 255
		refs = "0070 ?copy@?$char_traits@G@std@@SAPAGPAGPBGI@Z 00b2 @_guard_check_icall@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 10 33 D2 89 4D F4 33 C9 89 4D FC 89 55 F8 85 DB 0F 8C D7 00 00 00 57 8B 7D 0C 7F 08 85 FF 0F 84 C8 00 00 00 8B 4D F4 56 8B 41 20 8B 00 89 45 EC 85 C0 74 07 8B 41 30 8B 00 EB 02 33 C0 99 8B F0 8B C2 89 45 F0 85 C0 7C 51 7F 04 85 F6 74 4B 3B D8 7F 0B 7C 04 3B FE 73 05 8B F7 89 5D F0 8B 45 08 56 50 FF 75 EC E8 ?? ?? ?? ?? 8B 4D F4 8D 04 36 8B 55 F8 83 C4 0C 01 75 FC 89 45 EC 13 55 F0 2B FE 8B 41 30 1B 5D F0 89 55 F8 8D 14 36 29 30 8B 41 20 01 10 8B 45 EC EB 36 8B 09 8B 45 08 8B 71 0C 8B CE 0F B7 00 50 E8 ?? ?? ?? ?? 8B 4D F4 FF D6 B9 FF FF 00 00 66 3B C8 74 29 83 45 FC 01 8B 4D F4 83 55 F8 00 83 C7 FF 6A 02 83 D3 FF 58 01 45 08 85 DB 0F 8F 4D FF FF FF 7C 08 85 FF 0F 85 43 FF FF FF 8B 4D FC 8B 55 F8 5E 5F 8B C1 5B 8B E5 5D C2 0C 00 }
	condition:
		$1
}

rule file_3_427_1 {
	meta:
		name = "_memcpy_s"
		size = 127
		refs = "0017 __errno 0021 __invalid_parameter_noinfo 003a _memcpy 004c _memset"
	strings:
		$1 = { 55 8B EC 56 8B 75 14 85 F6 75 04 33 C0 EB 6D 8B 45 08 85 C0 75 13 E8 ?? ?? ?? ?? 6A 16 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 53 57 8B 7D 10 85 FF 74 14 39 75 0C 72 0F 56 57 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 EB 36 FF 75 0C 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 85 FF 75 09 E8 ?? ?? ?? ?? 6A 16 EB 0C 39 75 0C 73 13 E8 ?? ?? ?? ?? 6A 22 5E 89 30 E8 ?? ?? ?? ?? 8B C6 EB 03 6A 16 58 5F 5E 5D C3 }
	condition:
		$1
}

rule file_3_428_1 {
	meta:
		name = "_wmemcpy"
		size = 25
		refs = "0010 _memcpy"
	strings:
		$1 = { 55 8B EC 8B 45 10 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_58_1418_1 {
	meta:
		name = "_wmemmove"
		size = 25
		refs = "0010 _memmove"
	strings:
		$1 = { 55 8B EC 8B 45 10 03 C0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_4_0_1 {
	meta:
		name = "_GetTableIndexFromLcid"
		size = 53
		refs = "0019 ?LcidToLocaleNameTable@@3QBULcidToLocaleName@@B"
	strings:
		$1 = { 55 8B EC 56 33 C9 BE E3 00 00 00 8D 04 0E 99 2B C2 8B 55 08 D1 F8 2B 14 C5 ?? ?? ?? ?? 74 13 85 D2 79 05 8D 70 FF EB 03 8D 48 01 3B CE 7E DC 83 C8 FF 5E 5D C3 }
	condition:
		$1
}

rule file_4_1_1 {
	meta:
		name = "_GetTableIndexFromLocaleName"
		size = 78
		refs = "001c ?LocaleNameToIndexTable@@3QBULocaleNameIndex@@B 0024 ___wcsnicmp_ascii"
	strings:
		$1 = { 55 8B EC 53 56 57 33 FF BB E3 00 00 00 8D 04 3B 99 2B C2 8B F0 D1 FE 6A 55 FF 34 F5 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 13 79 05 8D 5E FF EB 03 8D 7E 01 3B FB 7E D0 83 C8 FF EB 07 8B 04 F5 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_4_2_1 {
	meta:
		name = "___crtCompareStringEx"
		size = 86
		refs = "0006 ___encodedKERNEL32Functions 000c ___security_cookie 002c @_guard_check_icall@4 0047 ___crtDownlevelLocaleNameToLCID 004f __imp__CompareStringW@24"
	strings:
		$1 = { 55 8B EC 56 8B 35 ?? ?? ?? ?? 33 35 ?? ?? ?? ?? 74 22 33 C0 8B CE 50 50 50 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF D6 EB 1F FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 5E 5D C3 }
	condition:
		$1
}

rule file_4_6_1 {
	meta:
		name = "___crtLCMapStringEx"
		size = 86
		refs = "0006 ___encodedKERNEL32Functions 000c ___security_cookie 002c @_guard_check_icall@4 0047 ___crtDownlevelLocaleNameToLCID 004f __imp__LCMapStringW@24"
	strings:
		$1 = { 55 8B EC 56 8B 35 ?? ?? ?? ?? 33 35 ?? ?? ?? ?? 74 22 33 C0 8B CE 50 50 50 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF D6 EB 1F FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 5E 5D C3 }
	condition:
		$1
}

rule file_4_3_1 {
	meta:
		name = "___crtDownlevelLCIDToLocaleName"
		size = 107
		refs = "002e _GetTableIndexFromLcid 003a ?LcidToLocaleNameTable@@3QBULcidToLocaleName@@B 0042 _wcsnlen 0058 _wcscpy_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 53 56 57 85 C0 74 57 3D 00 04 00 00 74 50 3D 00 08 00 00 74 49 83 7D 0C 00 8B 75 10 75 04 85 F6 7F 3C 85 F6 78 38 50 E8 ?? ?? ?? ?? 59 85 C0 78 2D 8B 1C C5 ?? ?? ?? ?? 6A 55 53 E8 ?? ?? ?? ?? 8B F8 59 59 85 F6 7E 11 3B FE 7D 12 53 56 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 8D 47 01 EB 02 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_4_4_1 {
	meta:
		name = "___crtDownlevelLocaleNameToLCID"
		size = 42
		refs = "000d _GetTableIndexFromLocaleName 0020 ?LcidToLocaleNameTable@@3QBULcidToLocaleName@@B"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 1D FF 75 08 E8 ?? ?? ?? ?? 59 85 C0 78 10 3D E4 00 00 00 73 09 8B 04 C5 ?? ?? ?? ?? 5D C3 33 C0 5D C3 }
	condition:
		$1
}

rule file_4_5_1 {
	meta:
		name = "___crtGetLocaleInfoEx"
		size = 57
		refs = "0009 ___encodedKERNEL32Functions 000f ___security_cookie 0021 @_guard_check_icall@4 002a ___crtDownlevelLocaleNameToLCID 0032 __imp__GetLocaleInfoW@16"
	strings:
		$1 = { 55 8B EC 56 FF 75 14 8B 35 ?? ?? ?? ?? 33 35 ?? ?? ?? ?? FF 75 10 FF 75 0C FF 75 08 74 0B 8B CE E8 ?? ?? ?? ?? FF D6 EB 0D E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 5E 5D C3 }
	condition:
		$1
}

rule file_4_7_1 {
	meta:
		name = "___wcsnicmp_ascii"
		size = 115
	strings:
		$1 = { 55 8B EC 51 56 8B 75 10 33 C0 85 F6 74 60 8B 4D 0C 53 57 8B 7D 08 6A 41 5B 6A 5A 5A 2B F9 89 55 FC EB 03 6A 5A 5A 0F B7 04 0F 66 3B C3 72 0D 66 3B C2 77 08 83 C0 20 0F B7 D0 EB 02 8B D0 0F B7 01 66 3B C3 72 0C 66 3B 45 FC 77 06 83 C0 20 0F B7 C0 83 C1 02 83 EE 01 74 0A 66 85 D2 74 05 66 3B D0 74 BF 0F B7 C8 0F B7 C2 5F 2B C1 5B 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_5_0_1 {
	meta:
		name = "__Wcscoll"
		size = 157
		refs = "0022 ____lc_locale_name_func 0078 ___crtCompareStringW 0084 __errno"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 45 18 53 8B 5D 10 56 8B 75 0C 57 8B 7D 14 2B F2 2B FB D1 FE D1 FF 85 C0 75 08 E8 ?? ?? ?? ?? 8B 55 08 8B 40 04 85 C0 75 3D 8B CE 3B F7 7C 13 8B CF EB 0F 66 8B 02 66 3B 03 75 23 83 C2 02 83 C3 02 49 85 C9 7F ED 33 C0 85 C0 75 45 3B F7 74 41 3B F7 0F 9D C0 8D 04 45 FF FF FF FF EB 33 1B C0 83 E0 FE 40 EB E2 57 53 56 52 68 00 10 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 E8 02 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_5_1_1 {
	meta:
		name = "__Wmemcmp"
		size = 55
	strings:
		$1 = { 55 8B EC 8B 4D 10 56 85 C9 7E 19 8B 55 0C 8B 75 08 66 8B 06 66 3B 02 75 10 83 C6 02 83 C2 02 49 85 C9 7F ED 33 C0 5E 5D C3 0F B7 06 66 3B 02 1B C0 83 E0 FE 40 EB EF }
	condition:
		$1
}

rule file_6_0_1 {
	meta:
		name = "__WStoxflt"
		size = 652
		refs = "0007 ___security_cookie 005d ?digits@?1??_WStoxflt@@9@9 0090 ?vals@?1??_WStoxflt@@9@9 00a9 _localeconv 0207 _iswctype 0284 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 6B 4D 18 07 33 D2 8B 45 10 53 8B 5D 14 56 8B 75 0C 89 45 BC 89 5D C4 89 55 C8 89 4D D4 57 83 F9 23 7E 06 6A 23 59 89 4D D4 6A 30 5F 89 13 89 53 04 89 55 CC 66 39 3E 75 0E 33 C0 40 89 45 CC 83 C6 02 66 39 3E 74 F8 8B FA 8B 5D C4 B8 ?? ?? ?? ?? C7 45 D0 16 00 00 00 0F B7 0E 66 39 08 8B 4D D4 74 0B 83 C0 02 83 6D D0 01 75 EC 8B C2 85 C0 74 26 3B F9 7F 15 2D ?? ?? ?? ?? D1 F8 8A 04 45 ?? ?? ?? ?? 88 44 3D D8 47 EB 02 FF 03 33 C0 83 C6 02 40 89 45 CC EB B1 E8 ?? ?? ?? ?? 8B 00 0F BE 08 0F B7 06 3B C1 75 03 83 C6 02 85 FF 75 18 6A 30 58 66 39 06 75 10 33 D2 42 89 55 CC FF 0B 83 C6 02 66 39 06 74 F6 8B 4D D4 8B 5D C4 B8 ?? ?? ?? ?? C7 45 D4 16 00 00 00 0F B7 16 66 39 10 8B 55 CC 74 0B 83 C0 02 83 6D D4 01 75 EC 33 C0 85 C0 74 24 3B F9 7F 15 2D ?? ?? ?? ?? D1 F8 8A 04 45 ?? ?? ?? ?? 88 44 3D D8 47 FF 0B 33 D2 83 C6 02 42 89 55 CC EB B3 89 75 D0 3B CF 7D 0F 80 7C 0D D8 08 7C 04 FE 44 0D D7 FF 03 8B F9 85 FF 7E 13 8D 45 D8 80 7C 38 FF 00 75 07 FF 03 4F 85 FF 7F F2 85 FF 75 07 33 FF C6 45 D8 00 47 C1 23 02 85 D2 0F 84 F9 00 00 00 8B C7 99 6A 07 59 F7 F9 89 4D D4 2B CA 8B C1 99 F7 7D D4 F7 DA 1B D2 F7 DA 89 55 C8 85 FF 7E 40 8D 45 D8 2B C8 33 F6 89 4D C0 8D 45 D8 03 C6 03 C1 99 F7 7D D4 0F BE 44 35 D8 85 D2 8B 55 C8 75 09 42 89 55 C8 89 04 93 EB 0E 8B 0C 93 C1 E1 04 03 C8 89 0C 93 8B 4D C0 46 3B F7 7C CD 8B 75 D0 0F B7 06 83 F8 70 74 09 83 F8 50 0F 85 85 00 00 00 6A 2D 89 75 C0 83 C6 02 59 6A 2B 5F 0F B7 06 89 7D D0 66 3B C7 74 05 66 3B C1 75 06 89 45 D0 83 C6 02 0F B7 06 83 65 D4 00 6A 04 50 E8 ?? ?? ?? ?? 59 33 FF 59 85 C0 74 30 47 33 DB 81 FB 00 E1 F5 05 7D 0B 6B CB 0A 0F B7 1E 83 C3 D0 03 D9 83 C6 02 6A 04 0F B7 06 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 D9 89 5D D4 8B 5D C4 6A 2D 58 66 39 45 D0 8B 45 D4 75 02 F7 D8 01 03 8B 55 CC 85 FF 75 08 8B 75 C0 EB 03 8B 55 CC 8B 4D BC 8B C2 F7 D8 1B C0 23 45 C8 85 C9 74 09 85 D2 75 03 8B 75 08 89 31 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_1_1 {
	meta:
		name = "_wmemchr"
		size = 34
	strings:
		$1 = { 55 8B EC 8B 4D 10 85 C9 74 14 66 8B 55 0C 8B 45 08 66 39 10 74 0A 83 C0 02 83 E9 01 75 F3 33 C0 5D C3 }
	condition:
		$1
}

rule file_7_83_1 {
	meta:
		name = "??0_Init_wcout@std@@QAE@XZ"
		size = 89
		refs = "0003 ?_Ptr_wcin@std@@3PAV?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0008 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 000e ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 002a ?_Ptr_wcerr@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0043 ?_Ptr_wclog@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 57 8B F9 85 F6 74 0F 8B 06 8B 40 04 89 54 30 3C 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 0F 8B 01 8B 40 04 89 54 08 3C 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 09 8B 01 8B 40 04 89 54 08 3C 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_23_83_1 {
	meta:
		name = "??0_Init_cout@std@@QAE@XZ"
		size = 89
		refs = "0003 ?_Ptr_cin@std@@3PAV?$basic_istream@DU?$char_traits@D@std@@@1@A 0008 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 000e ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 002a ?_Ptr_cerr@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0043 ?_Ptr_clog@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 57 8B F9 85 F6 74 0F 8B 06 8B 40 04 89 54 30 3C 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 0F 8B 01 8B 40 04 89 54 08 3C 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 09 8B 01 8B 40 04 89 54 08 3C 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_68_83_1 {
	meta:
		name = "??0_Init_ushcout@std@@QAE@XZ"
		size = 89
		refs = "0003 ?_Ptr_wcin@std@@3PAV?$basic_istream@GU?$char_traits@G@std@@@1@A 0008 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 000e ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 002a ?_Ptr_wcerr@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0043 ?_Ptr_wclog@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 57 8B F9 85 F6 74 0F 8B 06 8B 40 04 89 54 30 3C 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 0F 8B 01 8B 40 04 89 54 08 3C 8B 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 09 8B 01 8B 40 04 89 54 08 3C 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_7_202_1 {
	meta:
		name = "??__Ewfout@std@@YAXXZ"
		size = 186
		refs = "0004 ___acrt_iob_func 000a ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0011 ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0016 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A 0027 ??__Fwfout@std@@YAXXZ 0031 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 00b3 _atexit"
	strings:
		$1 = { 56 6A 01 E8 ?? ?? ?? ?? 59 B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 88 0D ?? ?? ?? ?? 88 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_68_202_1 {
	meta:
		name = "??__Ewfout@std@@YAXXZ"
		size = 186
		refs = "0004 ___acrt_iob_func 000a ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0011 ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0016 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IAEXPAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A 0027 ??__Fwfout@std@@YAXXZ 0031 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 00b3 _atexit"
	strings:
		$1 = { 56 6A 01 E8 ?? ?? ?? ?? 59 B9 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C9 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 88 0D ?? ?? ?? ?? 88 0D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_8_1_1 {
	meta:
		name = "__WStodx"
		size = 618
		refs = "000a ___security_cookie 003a __WStopfx 0074 __WStoflt 007a __real@41cdcd6500000000 0093 __Xp_setw 00bf __Xp_setn 00e6 __Xp_mulx 0104 __Xp_addx 0122 __Dtento 014b __WStoxflt 0151 __real@41b0000000000000 020a __Dscale 021a __Inf 0227 __Nan 0249 __Pmsw 0262 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC CC 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B 5D 14 56 8B 75 0C 57 89 85 48 FF FF FF 89 85 44 FF FF FF 8D 85 44 FF FF FF 56 50 89 9D 38 FF FF FF E8 ?? ?? ?? ?? 8B F8 83 E7 08 89 BD 34 FF FF FF 59 59 85 DB 74 03 83 23 00 33 FF 83 E0 F7 47 3B C7 0F 85 CE 00 00 00 6A 03 8D 45 EC 50 56 FF B5 44 FF FF FF FF B5 48 FF FF FF E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 0C 89 85 48 FF FF FF 8D 45 AC DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 CC 83 BD 48 FF FF FF 00 75 13 D9 EE 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 5C FF 75 F0 56 50 E8 ?? ?? ?? ?? 83 C4 0C 39 BD 48 FF FF FF 7E 47 8B 9D 48 FF FF FF 8D 85 4C FF FF FF 50 56 8D 45 AC 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? FF 74 BD F0 47 8D 45 8C 56 50 E8 ?? ?? ?? ?? 56 8D 45 8C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 30 3B FB 7C C5 8B 9D 38 FF FF FF 8B 45 10 03 45 EC 53 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C E9 01 01 00 00 83 F8 02 0F 85 DC 00 00 00 6A 03 8D 45 EC 50 56 FF B5 44 FF FF FF FF B5 48 FF FF FF E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 0C 89 85 48 FF FF FF 8D 45 8C DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 CC 83 BD 48 FF FF FF 00 75 13 D9 EE 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 5C FF 75 F0 56 50 E8 ?? ?? ?? ?? 83 C4 0C 39 BD 48 FF FF FF 7E 47 8B 9D 48 FF FF FF 8D 85 4C FF FF FF 50 56 8D 45 8C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? FF 74 BD F0 47 8D 45 AC 56 50 E8 ?? ?? ?? ?? 56 8D 45 AC 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 30 3B FB 7C C5 8B 9D 38 FF FF FF 53 FF 75 10 8D 45 CC 50 E8 ?? ?? ?? ?? FF 75 EC 8D 85 3C FF FF FF 50 DD 9D 3C FF FF FF E8 ?? ?? ?? ?? 83 C4 14 EB 22 83 F8 03 75 08 DD 05 ?? ?? ?? ?? EB 0F 83 F8 04 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 EE DD 9D 3C FF FF FF 83 BD 34 FF FF FF 00 5F 5E 5B 74 15 8D 85 3C FF FF FF 50 E8 ?? ?? ?? ?? 59 B9 00 80 00 00 66 31 08 8B 4D FC DD 85 3C FF FF FF 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_1_1 {
	meta:
		name = "__Stodx"
		size = 618
		refs = "000a ___security_cookie 003a __Stopfx 0074 __Stoflt 007a __real@41cdcd6500000000 0093 __Xp_setw 00bf __Xp_setn 00e6 __Xp_mulx 0104 __Xp_addx 0122 __Dtento 014b __Stoxflt 0151 __real@41b0000000000000 020a __Dscale 021a __Inf 0227 __Nan 0249 __Pmsw 0262 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC CC 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B 5D 14 56 8B 75 0C 57 89 85 48 FF FF FF 89 85 44 FF FF FF 8D 85 44 FF FF FF 56 50 89 9D 38 FF FF FF E8 ?? ?? ?? ?? 8B F8 83 E7 08 89 BD 34 FF FF FF 59 59 85 DB 74 03 83 23 00 33 FF 83 E0 F7 47 3B C7 0F 85 CE 00 00 00 6A 03 8D 45 EC 50 56 FF B5 44 FF FF FF FF B5 48 FF FF FF E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 0C 89 85 48 FF FF FF 8D 45 AC DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 CC 83 BD 48 FF FF FF 00 75 13 D9 EE 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 5C FF 75 F0 56 50 E8 ?? ?? ?? ?? 83 C4 0C 39 BD 48 FF FF FF 7E 47 8B 9D 48 FF FF FF 8D 85 4C FF FF FF 50 56 8D 45 AC 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? FF 74 BD F0 47 8D 45 8C 56 50 E8 ?? ?? ?? ?? 56 8D 45 8C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 30 3B FB 7C C5 8B 9D 38 FF FF FF 8B 45 10 03 45 EC 53 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C E9 01 01 00 00 83 F8 02 0F 85 DC 00 00 00 6A 03 8D 45 EC 50 56 FF B5 44 FF FF FF FF B5 48 FF FF FF E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 0C 89 85 48 FF FF FF 8D 45 8C DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 CC 83 BD 48 FF FF FF 00 75 13 D9 EE 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 5C FF 75 F0 56 50 E8 ?? ?? ?? ?? 83 C4 0C 39 BD 48 FF FF FF 7E 47 8B 9D 48 FF FF FF 8D 85 4C FF FF FF 50 56 8D 45 8C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? FF 74 BD F0 47 8D 45 AC 56 50 E8 ?? ?? ?? ?? 56 8D 45 AC 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 30 3B FB 7C C5 8B 9D 38 FF FF FF 53 FF 75 10 8D 45 CC 50 E8 ?? ?? ?? ?? FF 75 EC 8D 85 3C FF FF FF 50 DD 9D 3C FF FF FF E8 ?? ?? ?? ?? 83 C4 14 EB 22 83 F8 03 75 08 DD 05 ?? ?? ?? ?? EB 0F 83 F8 04 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 EE DD 9D 3C FF FF FF 83 BD 34 FF FF FF 00 5F 5E 5B 74 15 8D 85 3C FF FF FF 50 E8 ?? ?? ?? ?? 59 B9 00 80 00 00 66 31 08 8B 4D FC DD 85 3C FF FF FF 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_1_1 {
	meta:
		name = "__Stoldx"
		size = 618
		refs = "000a ___security_cookie 003a __Stopfx 0074 __Stoflt 007a __real@41cdcd6500000000 0093 __LXp_setw 00bf __LXp_setn 00e6 __LXp_mulx 0104 __LXp_addx 0122 __LDtento 014b __Stoxflt 0151 __real@41b0000000000000 020a __LDscale 021a __LInf 0227 __LNan 0249 __LPmsw 0262 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC CC 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B 5D 14 56 8B 75 0C 57 89 85 48 FF FF FF 89 85 44 FF FF FF 8D 85 44 FF FF FF 56 50 89 9D 38 FF FF FF E8 ?? ?? ?? ?? 8B F8 83 E7 08 89 BD 34 FF FF FF 59 59 85 DB 74 03 83 23 00 33 FF 83 E0 F7 47 3B C7 0F 85 CE 00 00 00 6A 03 8D 45 EC 50 56 FF B5 44 FF FF FF FF B5 48 FF FF FF E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 0C 89 85 48 FF FF FF 8D 45 AC DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 CC 83 BD 48 FF FF FF 00 75 13 D9 EE 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 5C FF 75 F0 56 50 E8 ?? ?? ?? ?? 83 C4 0C 39 BD 48 FF FF FF 7E 47 8B 9D 48 FF FF FF 8D 85 4C FF FF FF 50 56 8D 45 AC 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? FF 74 BD F0 47 8D 45 8C 56 50 E8 ?? ?? ?? ?? 56 8D 45 8C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 30 3B FB 7C C5 8B 9D 38 FF FF FF 8B 45 10 03 45 EC 53 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C E9 01 01 00 00 83 F8 02 0F 85 DC 00 00 00 6A 03 8D 45 EC 50 56 FF B5 44 FF FF FF FF B5 48 FF FF FF E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 0C 89 85 48 FF FF FF 8D 45 8C DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 CC 83 BD 48 FF FF FF 00 75 13 D9 EE 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 5C FF 75 F0 56 50 E8 ?? ?? ?? ?? 83 C4 0C 39 BD 48 FF FF FF 7E 47 8B 9D 48 FF FF FF 8D 85 4C FF FF FF 50 56 8D 45 8C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? FF 74 BD F0 47 8D 45 AC 56 50 E8 ?? ?? ?? ?? 56 8D 45 AC 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 30 3B FB 7C C5 8B 9D 38 FF FF FF 53 FF 75 10 8D 45 CC 50 E8 ?? ?? ?? ?? FF 75 EC 8D 85 3C FF FF FF 50 DD 9D 3C FF FF FF E8 ?? ?? ?? ?? 83 C4 14 EB 22 83 F8 03 75 08 DD 05 ?? ?? ?? ?? EB 0F 83 F8 04 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 EE DD 9D 3C FF FF FF 83 BD 34 FF FF FF 00 5F 5E 5B 74 15 8D 85 3C FF FF FF 50 E8 ?? ?? ?? ?? 59 B9 00 80 00 00 66 31 08 8B 4D FC DD 85 3C FF FF FF 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_1_1 {
	meta:
		name = "__WStoldx"
		size = 618
		refs = "000a ___security_cookie 003a __WStopfx 0074 __WStoflt 007a __real@41cdcd6500000000 0093 __LXp_setw 00bf __LXp_setn 00e6 __LXp_mulx 0104 __LXp_addx 0122 __LDtento 014b __WStoxflt 0151 __real@41b0000000000000 020a __LDscale 021a __LInf 0227 __LNan 0249 __LPmsw 0262 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC CC 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 8B 5D 14 56 8B 75 0C 57 89 85 48 FF FF FF 89 85 44 FF FF FF 8D 85 44 FF FF FF 56 50 89 9D 38 FF FF FF E8 ?? ?? ?? ?? 8B F8 83 E7 08 89 BD 34 FF FF FF 59 59 85 DB 74 03 83 23 00 33 FF 83 E0 F7 47 3B C7 0F 85 CE 00 00 00 6A 03 8D 45 EC 50 56 FF B5 44 FF FF FF FF B5 48 FF FF FF E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 0C 89 85 48 FF FF FF 8D 45 AC DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 CC 83 BD 48 FF FF FF 00 75 13 D9 EE 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 5C FF 75 F0 56 50 E8 ?? ?? ?? ?? 83 C4 0C 39 BD 48 FF FF FF 7E 47 8B 9D 48 FF FF FF 8D 85 4C FF FF FF 50 56 8D 45 AC 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? FF 74 BD F0 47 8D 45 8C 56 50 E8 ?? ?? ?? ?? 56 8D 45 8C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 30 3B FB 7C C5 8B 9D 38 FF FF FF 8B 45 10 03 45 EC 53 50 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C E9 01 01 00 00 83 F8 02 0F 85 DC 00 00 00 6A 03 8D 45 EC 50 56 FF B5 44 FF FF FF FF B5 48 FF FF FF E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 0C 89 85 48 FF FF FF 8D 45 8C DD 1C 24 6A 04 5E 56 50 E8 ?? ?? ?? ?? 83 C4 10 8D 45 CC 83 BD 48 FF FF FF 00 75 13 D9 EE 51 51 DD 1C 24 56 50 E8 ?? ?? ?? ?? 83 C4 10 EB 5C FF 75 F0 56 50 E8 ?? ?? ?? ?? 83 C4 0C 39 BD 48 FF FF FF 7E 47 8B 9D 48 FF FF FF 8D 85 4C FF FF FF 50 56 8D 45 8C 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? FF 74 BD F0 47 8D 45 AC 56 50 E8 ?? ?? ?? ?? 56 8D 45 AC 50 8D 45 CC 56 50 E8 ?? ?? ?? ?? 83 C4 30 3B FB 7C C5 8B 9D 38 FF FF FF 53 FF 75 10 8D 45 CC 50 E8 ?? ?? ?? ?? FF 75 EC 8D 85 3C FF FF FF 50 DD 9D 3C FF FF FF E8 ?? ?? ?? ?? 83 C4 14 EB 22 83 F8 03 75 08 DD 05 ?? ?? ?? ?? EB 0F 83 F8 04 75 08 DD 05 ?? ?? ?? ?? EB 02 D9 EE DD 9D 3C FF FF FF 83 BD 34 FF FF FF 00 5F 5E 5B 74 15 8D 85 3C FF FF FF 50 E8 ?? ?? ?? ?? 59 B9 00 80 00 00 66 31 08 8B 4D FC DD 85 3C FF FF FF 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "__Xp_addh"
		size = 779
		refs = "0026 __Dunscale 0044 __Dtest 005c __Pmsw 0090 __Feraise 0096 __Nan 0208 __Dint 0216 __Dscale"
	strings:
		$1 = { 55 8B EC 83 EC 20 DD 45 10 53 8B 5D 0C 57 8B 7D 08 DD 5D E8 85 DB 0F 84 E7 02 00 00 56 8D 45 E8 50 8D 45 F8 50 E8 ?? ?? ?? ?? 59 59 0F B7 C0 33 C9 66 3B C8 0F 8D 80 00 00 00 6A 02 5E 66 3B C6 74 6E 57 E8 ?? ?? ?? ?? 0F B7 C0 59 66 85 C0 7E 5F 66 3B C6 0F 84 A8 02 00 00 57 E8 ?? ?? ?? ?? B9 00 80 00 00 66 8B 00 66 23 C1 0F B7 F0 8D 45 10 50 E8 ?? ?? ?? ?? 59 59 B9 00 80 00 00 66 8B 00 66 23 C1 66 3B C6 0F 84 75 02 00 00 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 1F 59 83 FB 01 0F 8E 5C 02 00 00 D9 EE DD 5F 08 E9 52 02 00 00 DD 45 10 DD 1F E9 48 02 00 00 66 85 C0 0F 89 3F 02 00 00 33 F6 C7 45 F4 00 08 00 00 85 DB 0F 8E 2E 02 00 00 8D 04 F7 DD 00 89 45 F0 8D 45 E0 50 8D 45 FC 50 DD 5D E0 E8 ?? ?? ?? ?? 59 59 0F B7 C0 33 C9 66 3B C8 0F 8C 06 02 00 00 DD 45 10 66 85 C0 0F 84 EA 01 00 00 0F BF 55 FC 0F BF 45 F8 8B CA D9 EE 2B C8 83 F9 E6 7F 4D DD E1 DF E0 F6 C4 44 7B 44 8B CE 8B D1 41 3B CB 7D 0C DD 04 CF DD E9 DF E0 F6 C4 44 7A ED 8D 43 FF 3B C8 7D 03 41 EB 06 3B CB 75 02 8B CA 3B F1 7D 0C DD 44 CF F8 DD 1C CF 49 3B CE 7F F4 8B 45 F0 D9 C9 DD 18 DD 5D 10 E9 80 01 00 00 6A 1A 58 3B C8 7C 16 DD E1 DF E0 F6 C4 44 7B 0D DD D8 89 55 F4 DD D8 46 E9 63 01 00 00 8B 4D F0 DD 01 DE C2 D9 C9 DD 11 DD E9 DF E0 F6 C4 44 7A 2C 8B D6 42 3B D3 7D 10 DD 04 D7 DD 54 D7 F8 DD E9 DF E0 F6 C4 44 7A EB DD 54 DF F8 DD 01 DA E9 DF E0 F6 C4 44 0F 8B 3F 01 00 00 EB 02 DD D8 DD 01 8D 45 10 50 8D 45 F8 50 DD 5D 10 E8 ?? ?? ?? ?? 8B 55 F4 66 8B 45 F8 59 59 66 89 45 F6 8D 4A E6 98 3B C8 0F 8D 8F 00 00 00 66 8B 45 F6 6A 1A 66 2B C2 59 66 03 C1 0F B7 C0 50 8D 45 10 50 E8 ?? ?? ?? ?? 0F BF 45 F8 50 8D 45 10 50 E8 ?? ?? ?? ?? 8B 45 F0 83 C4 10 DD 00 DC 65 10 DD 10 D9 EE DD E1 DF E0 DD D9 F6 C4 44 7A 1D 8B CE 41 3B CB 7D 10 DD 04 CF DD 54 CF F8 DD E9 DF E0 F6 C4 44 7A EB DD 5C DF F8 EB 02 DD D8 83 EE 01 75 0C C7 45 F4 00 08 00 00 E9 84 00 00 00 DD 44 F7 F8 8D 45 E8 50 8D 45 FC 50 DD 5D E8 E8 ?? ?? ?? ?? 0F BF 45 FC 89 45 F4 EB 65 46 3B F3 74 7C 8B 45 F0 50 DD 00 8D 45 FC 50 DD 5D 10 E8 ?? ?? ?? ?? 6A 1A 58 50 8B 45 F0 50 E8 ?? ?? ?? ?? 0F BF 45 FC 50 FF 75 F0 E8 ?? ?? ?? ?? 8B 4D F0 83 C4 18 DD 45 10 0F BF 45 FC 89 45 F4 DC 21 DD 55 10 D9 EE DD E9 DF E0 F6 C4 44 7A 04 DD D8 DD 01 8D 45 E8 50 8D 45 F8 50 DD 5D E8 E8 ?? ?? ?? ?? 59 59 3B F3 0F 8C E4 FD FF FF EB 10 8D 4E 01 DD 1C F7 3B CB 7D 06 D9 EE DD 5C F7 08 5E 8B C7 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_0_1 {
	meta:
		name = "__LXp_addh"
		size = 779
		refs = "0026 __LDunscale 0044 __LDtest 005c __LPmsw 0090 __Feraise 0096 __LNan 0208 __LDint 0216 __LDscale"
	strings:
		$1 = { 55 8B EC 83 EC 20 DD 45 10 53 8B 5D 0C 57 8B 7D 08 DD 5D E8 85 DB 0F 84 E7 02 00 00 56 8D 45 E8 50 8D 45 F8 50 E8 ?? ?? ?? ?? 59 59 0F B7 C0 33 C9 66 3B C8 0F 8D 80 00 00 00 6A 02 5E 66 3B C6 74 6E 57 E8 ?? ?? ?? ?? 0F B7 C0 59 66 85 C0 7E 5F 66 3B C6 0F 84 A8 02 00 00 57 E8 ?? ?? ?? ?? B9 00 80 00 00 66 8B 00 66 23 C1 0F B7 F0 8D 45 10 50 E8 ?? ?? ?? ?? 59 59 B9 00 80 00 00 66 8B 00 66 23 C1 66 3B C6 0F 84 75 02 00 00 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 1F 59 83 FB 01 0F 8E 5C 02 00 00 D9 EE DD 5F 08 E9 52 02 00 00 DD 45 10 DD 1F E9 48 02 00 00 66 85 C0 0F 89 3F 02 00 00 33 F6 C7 45 F4 00 08 00 00 85 DB 0F 8E 2E 02 00 00 8D 04 F7 DD 00 89 45 F0 8D 45 E0 50 8D 45 FC 50 DD 5D E0 E8 ?? ?? ?? ?? 59 59 0F B7 C0 33 C9 66 3B C8 0F 8C 06 02 00 00 DD 45 10 66 85 C0 0F 84 EA 01 00 00 0F BF 55 FC 0F BF 45 F8 8B CA D9 EE 2B C8 83 F9 E6 7F 4D DD E1 DF E0 F6 C4 44 7B 44 8B CE 8B D1 41 3B CB 7D 0C DD 04 CF DD E9 DF E0 F6 C4 44 7A ED 8D 43 FF 3B C8 7D 03 41 EB 06 3B CB 75 02 8B CA 3B F1 7D 0C DD 44 CF F8 DD 1C CF 49 3B CE 7F F4 8B 45 F0 D9 C9 DD 18 DD 5D 10 E9 80 01 00 00 6A 1A 58 3B C8 7C 16 DD E1 DF E0 F6 C4 44 7B 0D DD D8 89 55 F4 DD D8 46 E9 63 01 00 00 8B 4D F0 DD 01 DE C2 D9 C9 DD 11 DD E9 DF E0 F6 C4 44 7A 2C 8B D6 42 3B D3 7D 10 DD 04 D7 DD 54 D7 F8 DD E9 DF E0 F6 C4 44 7A EB DD 54 DF F8 DD 01 DA E9 DF E0 F6 C4 44 0F 8B 3F 01 00 00 EB 02 DD D8 DD 01 8D 45 10 50 8D 45 F8 50 DD 5D 10 E8 ?? ?? ?? ?? 8B 55 F4 66 8B 45 F8 59 59 66 89 45 F6 8D 4A E6 98 3B C8 0F 8D 8F 00 00 00 66 8B 45 F6 6A 1A 66 2B C2 59 66 03 C1 0F B7 C0 50 8D 45 10 50 E8 ?? ?? ?? ?? 0F BF 45 F8 50 8D 45 10 50 E8 ?? ?? ?? ?? 8B 45 F0 83 C4 10 DD 00 DC 65 10 DD 10 D9 EE DD E1 DF E0 DD D9 F6 C4 44 7A 1D 8B CE 41 3B CB 7D 10 DD 04 CF DD 54 CF F8 DD E9 DF E0 F6 C4 44 7A EB DD 5C DF F8 EB 02 DD D8 83 EE 01 75 0C C7 45 F4 00 08 00 00 E9 84 00 00 00 DD 44 F7 F8 8D 45 E8 50 8D 45 FC 50 DD 5D E8 E8 ?? ?? ?? ?? 0F BF 45 FC 89 45 F4 EB 65 46 3B F3 74 7C 8B 45 F0 50 DD 00 8D 45 FC 50 DD 5D 10 E8 ?? ?? ?? ?? 6A 1A 58 50 8B 45 F0 50 E8 ?? ?? ?? ?? 0F BF 45 FC 50 FF 75 F0 E8 ?? ?? ?? ?? 8B 4D F0 83 C4 18 DD 45 10 0F BF 45 FC 89 45 F4 DC 21 DD 55 10 D9 EE DD E9 DF E0 F6 C4 44 7A 04 DD D8 DD 01 8D 45 E8 50 8D 45 F8 50 DD 5D E8 E8 ?? ?? ?? ?? 59 59 3B F3 0F 8C E4 FD FF FF EB 10 8D 4E 01 DD 1C F7 3B CB 7D 06 D9 EE DD 5C F7 08 5E 8B C7 5F 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_1_1 {
	meta:
		name = "__Xp_addx"
		size = 68
		refs = "002c __Xp_addh"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 14 7E 33 D9 EE 57 8B 7D 10 DD 04 F7 DA E9 DF E0 F6 C4 44 7B 20 DD 04 F7 51 51 DD 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? D9 EE 83 C4 10 46 3B 75 14 7C D6 DD D8 5F 8B 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_20_1_1 {
	meta:
		name = "__LXp_addx"
		size = 68
		refs = "002c __LXp_addh"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 14 7E 33 D9 EE 57 8B 7D 10 DD 04 F7 DA E9 DF E0 F6 C4 44 7B 20 DD 04 F7 51 51 DD 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? D9 EE 83 C4 10 46 3B 75 14 7C D6 DD D8 5F 8B 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_9_2_1 {
	meta:
		name = "__Xp_getw"
		size = 124
		altNames = "__LXp_getw"
	strings:
		$1 = { 55 8B EC 8B 55 0C 85 D2 75 04 D9 EE 5D C3 8B 4D 08 83 FA 01 74 62 DD 01 D9 EE DD E1 DF E0 DD D9 F6 C4 44 7B 51 DD 41 08 DD E9 DF E0 F6 C4 44 7B 45 83 FA 02 74 37 DD 41 10 DA E9 DF E0 F6 C4 44 7B 2D DD 41 08 DC 01 DD 41 10 83 FA 04 7C 03 DC 41 18 D9 C1 DC 21 DD 41 08 DA E9 DF E0 F6 C4 44 7A 04 DE C1 5D C3 DD D9 DC 41 08 EB 05 DD D8 DD 41 08 DC 01 5D C3 DD D8 DD 01 5D C3 }
	condition:
		$1
}

rule file_9_3_1 {
	meta:
		name = "__Xp_invx"
		size = 258
		refs = "0018 __Dtest 003c __Inf 0065 _memcpy 006b __real@bff0000000000000 0078 __Xp_mulh 009f __Xp_setw 00c2 __Xp_mulx 00d1 __Xp_addh 00e6 __Xp_addx"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 8B 75 08 57 8B 7D 0C 85 FF 0F 84 E4 00 00 00 56 E8 ?? ?? ?? ?? 59 0F B7 C0 33 C9 66 3B C8 7F 20 66 83 F8 01 75 04 D9 EE EB 0F 66 85 C0 0F 85 C0 00 00 00 DD 05 ?? ?? ?? ?? DD 1E E9 B3 00 00 00 DD 06 8B C7 53 8B 5D 10 C1 E0 03 50 56 DD 5D EC 8D 0C 18 8D 14 08 89 4D FC 51 89 55 F8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 DD 1C 24 57 FF 75 FC E8 ?? ?? ?? ?? 33 C0 83 C4 10 40 89 45 F4 3B F8 7E 09 DD 46 08 DC 45 EC DD 5D EC D9 E8 DC 75 EC 51 51 DD 1C 24 57 56 E8 ?? ?? ?? ?? 83 C4 10 83 FF 01 7E 4E 8B C7 C1 E0 03 50 56 53 E8 ?? ?? ?? ?? FF 75 F8 57 FF 75 FC 57 53 E8 ?? ?? ?? ?? D9 E8 83 C4 18 DD 1C 24 57 53 E8 ?? ?? ?? ?? FF 75 F8 57 56 57 53 E8 ?? ?? ?? ?? 57 53 57 56 E8 ?? ?? ?? ?? 8B 45 F4 83 C4 34 03 C0 89 45 F4 3B C7 7C B2 5B 5F 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_3_1 {
	meta:
		name = "__LXp_invx"
		size = 258
		refs = "0018 __LDtest 003c __LInf 0065 _memcpy 006b __real@bff0000000000000 0078 __LXp_mulh 009f __LXp_setw 00c2 __LXp_mulx 00d1 __LXp_addh 00e6 __LXp_addx"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 8B 75 08 57 8B 7D 0C 85 FF 0F 84 E4 00 00 00 56 E8 ?? ?? ?? ?? 59 0F B7 C0 33 C9 66 3B C8 7F 20 66 83 F8 01 75 04 D9 EE EB 0F 66 85 C0 0F 85 C0 00 00 00 DD 05 ?? ?? ?? ?? DD 1E E9 B3 00 00 00 DD 06 8B C7 53 8B 5D 10 C1 E0 03 50 56 DD 5D EC 8D 0C 18 8D 14 08 89 4D FC 51 89 55 F8 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 DD 1C 24 57 FF 75 FC E8 ?? ?? ?? ?? 33 C0 83 C4 10 40 89 45 F4 3B F8 7E 09 DD 46 08 DC 45 EC DD 5D EC D9 E8 DC 75 EC 51 51 DD 1C 24 57 56 E8 ?? ?? ?? ?? 83 C4 10 83 FF 01 7E 4E 8B C7 C1 E0 03 50 56 53 E8 ?? ?? ?? ?? FF 75 F8 57 FF 75 FC 57 53 E8 ?? ?? ?? ?? D9 E8 83 C4 18 DD 1C 24 57 53 E8 ?? ?? ?? ?? FF 75 F8 57 56 57 53 E8 ?? ?? ?? ?? 57 53 57 56 E8 ?? ?? ?? ?? 8B 45 F4 83 C4 34 03 C0 89 45 F4 3B C7 7C B2 5B 5F 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_4_1 {
	meta:
		name = "__Xp_ldexpx"
		size = 60
		refs = "001b _ldexp"
		altNames = "__LXp_ldexpx"
	strings:
		$1 = { 55 8B EC 56 33 F6 57 8B 7D 08 39 75 0C 7E 27 FF 75 10 DD 04 F7 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 14 F7 D9 EE 83 C4 0C DA E9 DF E0 F6 C4 44 7B 06 46 3B 75 0C 7C D9 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_9_5_1 {
	meta:
		name = "__Xp_movx"
		size = 29
		refs = "0011 _memcpy"
		altNames = "__LXp_movx"
	strings:
		$1 = { 55 8B EC 8B 45 0C C1 E0 03 50 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_9_6_1 {
	meta:
		name = "__Xp_mulh"
		size = 382
		refs = "0007 ___security_cookie 002e __Dtest 0046 __Feraise 00e4 __Dunscale 00ef __Dint 00fd __Dscale 010d __Xp_addh 0168 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC DD 45 10 D9 EE 53 8B 5D 0C 56 57 8B 7D 08 85 DB 7E 55 DD D8 8D 45 DC DC 0F 50 DD 5D DC E8 ?? ?? ?? ?? 0F B7 F0 33 C0 59 66 3B C6 7F 31 66 83 FE 02 75 08 6A 01 E8 ?? ?? ?? ?? 59 DD 45 DC 33 C0 DD 1F 66 3B C6 0F 8D 02 01 00 00 83 FB 01 0F 8E F9 00 00 00 D9 EE DD 5F 08 E9 EF 00 00 00 D9 EE DD 17 DD 45 10 D9 C9 33 F6 33 D2 46 89 55 D4 85 DB 7F 09 DD D8 E9 D1 00 00 00 D9 C9 83 FE 04 7D 33 8D 04 32 8D 0C C7 8D 04 32 3B C3 0F 8D CE 00 00 00 DD 01 DD E9 DF E0 F6 C4 44 0F 8B BF 00 00 00 D9 C1 DC 09 DD 5C F5 DC 46 DD 11 83 C1 08 83 FE 04 7C D3 DD D9 DD 45 DC DD E1 DF E0 DD D9 F6 C4 44 0F 8B 83 00 00 00 8D 45 CC 50 8D 45 D8 50 DD 5D CC E8 ?? ?? ?? ?? 8D 45 CC 6A 1A 50 E8 ?? ?? ?? ?? 0F BF 45 D8 50 8D 45 CC 50 E8 ?? ?? ?? ?? DD 45 CC 83 C4 10 DD 1C 24 53 57 E8 ?? ?? ?? ?? DD 45 DC 83 C4 08 DC 65 CC DD 1C 24 53 57 E8 ?? ?? ?? ?? D9 EE 33 C9 41 83 C4 10 3B F1 7E 16 DD 44 CD DC DD 54 CD D4 DD E9 DF E0 F6 C4 44 7B 05 41 3B CE 7C EA 8B 55 D4 DD 45 10 42 4E 89 55 D4 3B D3 0F 8C 31 FF FF FF DD D9 DD D8 8B 4D FC 8B C7 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 DD D9 6A 08 DD 54 F5 DC 5E E9 48 FF FF FF }
	condition:
		$1
}

rule file_20_6_1 {
	meta:
		name = "__LXp_mulh"
		size = 382
		refs = "0007 ___security_cookie 002e __LDtest 0046 __Feraise 00e4 __LDunscale 00ef __LDint 00fd __LDscale 010d __LXp_addh 0168 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC DD 45 10 D9 EE 53 8B 5D 0C 56 57 8B 7D 08 85 DB 7E 55 DD D8 8D 45 DC DC 0F 50 DD 5D DC E8 ?? ?? ?? ?? 0F B7 F0 33 C0 59 66 3B C6 7F 31 66 83 FE 02 75 08 6A 01 E8 ?? ?? ?? ?? 59 DD 45 DC 33 C0 DD 1F 66 3B C6 0F 8D 02 01 00 00 83 FB 01 0F 8E F9 00 00 00 D9 EE DD 5F 08 E9 EF 00 00 00 D9 EE DD 17 DD 45 10 D9 C9 33 F6 33 D2 46 89 55 D4 85 DB 7F 09 DD D8 E9 D1 00 00 00 D9 C9 83 FE 04 7D 33 8D 04 32 8D 0C C7 8D 04 32 3B C3 0F 8D CE 00 00 00 DD 01 DD E9 DF E0 F6 C4 44 0F 8B BF 00 00 00 D9 C1 DC 09 DD 5C F5 DC 46 DD 11 83 C1 08 83 FE 04 7C D3 DD D9 DD 45 DC DD E1 DF E0 DD D9 F6 C4 44 0F 8B 83 00 00 00 8D 45 CC 50 8D 45 D8 50 DD 5D CC E8 ?? ?? ?? ?? 8D 45 CC 6A 1A 50 E8 ?? ?? ?? ?? 0F BF 45 D8 50 8D 45 CC 50 E8 ?? ?? ?? ?? DD 45 CC 83 C4 10 DD 1C 24 53 57 E8 ?? ?? ?? ?? DD 45 DC 83 C4 08 DC 65 CC DD 1C 24 53 57 E8 ?? ?? ?? ?? D9 EE 33 C9 41 83 C4 10 3B F1 7E 16 DD 44 CD DC DD 54 CD D4 DD E9 DF E0 F6 C4 44 7B 05 41 3B CE 7C EA 8B 55 D4 DD 45 10 42 4E 89 55 D4 3B D3 0F 8C 31 FF FF FF DD D9 DD D8 8B 4D FC 8B C7 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 DD D9 6A 08 DD 54 F5 DC 5E E9 48 FF FF FF }
	condition:
		$1
}

rule file_9_7_1 {
	meta:
		name = "__Xp_mulx"
		size = 232
		refs = "0051 _memcpy 005e __Xp_mulh 00b7 __Xp_addx"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 56 8B 75 0C 85 F6 0F 84 CC 00 00 00 83 7D 14 00 0F 84 C2 00 00 00 57 8B 7D 10 DD 07 D9 EE DD E1 DF E0 DD D9 F6 C4 44 0F 8B 97 00 00 00 DD 47 08 DA E9 DF E0 F6 C4 44 0F 8B 89 00 00 00 8B 55 18 8B CE C1 E1 03 51 53 52 E8 ?? ?? ?? ?? DD 07 59 DD 1C 24 56 53 E8 ?? ?? ?? ?? 33 C0 83 C4 10 40 89 45 FC 39 45 14 7E 6F DD 04 C7 D9 EE DA E9 DF E0 F6 C4 44 7B 61 8B 55 18 8B CE C1 E1 03 51 52 8D 04 11 50 E8 ?? ?? ?? ?? 8B 45 FC 59 DD 04 C7 8B C6 C1 E0 03 03 45 18 DD 1C 24 56 50 E8 ?? ?? ?? ?? 8B C6 C1 E0 03 03 45 18 56 50 56 53 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 20 40 89 45 FC 3B 45 14 7C A6 EB 13 DD D8 DD 07 51 51 DD 1C 24 56 53 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_7_1 {
	meta:
		name = "__LXp_mulx"
		size = 232
		refs = "0051 _memcpy 005e __LXp_mulh 00b7 __LXp_addx"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 56 8B 75 0C 85 F6 0F 84 CC 00 00 00 83 7D 14 00 0F 84 C2 00 00 00 57 8B 7D 10 DD 07 D9 EE DD E1 DF E0 DD D9 F6 C4 44 0F 8B 97 00 00 00 DD 47 08 DA E9 DF E0 F6 C4 44 0F 8B 89 00 00 00 8B 55 18 8B CE C1 E1 03 51 53 52 E8 ?? ?? ?? ?? DD 07 59 DD 1C 24 56 53 E8 ?? ?? ?? ?? 33 C0 83 C4 10 40 89 45 FC 39 45 14 7E 6F DD 04 C7 D9 EE DA E9 DF E0 F6 C4 44 7B 61 8B 55 18 8B CE C1 E1 03 51 52 8D 04 11 50 E8 ?? ?? ?? ?? 8B 45 FC 59 DD 04 C7 8B C6 C1 E0 03 03 45 18 DD 1C 24 56 50 E8 ?? ?? ?? ?? 8B C6 C1 E0 03 03 45 18 56 50 56 53 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 20 40 89 45 FC 3B 45 14 7C A6 EB 13 DD D8 DD 07 51 51 DD 1C 24 56 53 E8 ?? ?? ?? ?? 83 C4 10 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_8_1 {
	meta:
		name = "__Xp_setn"
		size = 40
		refs = "001a __Xp_setw"
	strings:
		$1 = { 55 8B EC 51 51 DB 45 10 51 51 DD 5D F8 DD 45 F8 DD 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_8_1 {
	meta:
		name = "__LXp_setn"
		size = 40
		refs = "001a __LXp_setw"
	strings:
		$1 = { 55 8B EC 51 51 DB 45 10 51 51 DD 5D F8 DD 45 F8 DD 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 08 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_9_1 {
	meta:
		name = "__Xp_setw"
		size = 239
		refs = "0031 __Dunscale 0060 __Dint 006e __Dscale"
	strings:
		$1 = { 55 8B EC 83 EC 14 DD 45 10 53 56 8B 75 08 57 8B 7D 0C DD 55 F4 85 FF 0F 8E C7 00 00 00 83 FF 01 0F 84 BA 00 00 00 8D 45 F4 DD D8 50 8D 45 FC 50 E8 ?? ?? ?? ?? 0F B7 C0 59 59 66 85 C0 0F 84 9A 00 00 00 33 C9 66 3B C8 7D 0F DD 45 F4 DD 1E D9 EE DD 5E 08 E9 8D 00 00 00 8D 45 F4 6A 1A 50 E8 ?? ?? ?? ?? 0F BF 45 FC 50 8D 45 F4 50 E8 ?? ?? ?? ?? DD 45 F4 8D 5E 08 DD 16 DC 6D 10 83 C4 10 DD 55 EC DD 13 83 FF 02 7E 5A D9 EE DD E1 DF E0 DD D9 F6 C4 44 7B 41 8D 45 FC DD D8 53 50 E8 ?? ?? ?? ?? 6A 1A 53 E8 ?? ?? ?? ?? 0F BF 45 FC 50 53 E8 ?? ?? ?? ?? DD 45 EC 83 C4 18 DC 23 DD 56 10 83 FF 03 7E 1E D9 EE DD E1 DF E0 DD D9 F6 C4 44 7B 11 DD 5E 18 EB 0E DD 5E 10 EB 09 DD 45 F4 DD 1E EB 02 DD D8 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_9_1 {
	meta:
		name = "__LXp_setw"
		size = 239
		refs = "0031 __LDunscale 0060 __LDint 006e __LDscale"
	strings:
		$1 = { 55 8B EC 83 EC 14 DD 45 10 53 56 8B 75 08 57 8B 7D 0C DD 55 F4 85 FF 0F 8E C7 00 00 00 83 FF 01 0F 84 BA 00 00 00 8D 45 F4 DD D8 50 8D 45 FC 50 E8 ?? ?? ?? ?? 0F B7 C0 59 59 66 85 C0 0F 84 9A 00 00 00 33 C9 66 3B C8 7D 0F DD 45 F4 DD 1E D9 EE DD 5E 08 E9 8D 00 00 00 8D 45 F4 6A 1A 50 E8 ?? ?? ?? ?? 0F BF 45 FC 50 8D 45 F4 50 E8 ?? ?? ?? ?? DD 45 F4 8D 5E 08 DD 16 DC 6D 10 83 C4 10 DD 55 EC DD 13 83 FF 02 7E 5A D9 EE DD E1 DF E0 DD D9 F6 C4 44 7B 41 8D 45 FC DD D8 53 50 E8 ?? ?? ?? ?? 6A 1A 53 E8 ?? ?? ?? ?? 0F BF 45 FC 50 53 E8 ?? ?? ?? ?? DD 45 EC 83 C4 18 DC 23 DD 56 10 83 FF 03 7E 1E D9 EE DD E1 DF E0 DD D9 F6 C4 44 7B 11 DD 5E 18 EB 0E DD 5E 10 EB 09 DD 45 F4 DD 1E EB 02 DD D8 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_10_1 {
	meta:
		name = "__Xp_sqrtx"
		size = 276
		refs = "0018 __Dtest 0056 __CIsqrt 0068 __Xp_setw 0084 _memcpy 008a __real@bfe0000000000000 0095 __Xp_mulh 00a1 __Xp_mulx 00b5 __real@3ff8000000000000 00c2 __Xp_addh 00ff __Feraise 0105 __Nan"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 8B 75 0C 57 8B 7D 08 85 F6 0F 84 F6 00 00 00 57 E8 ?? ?? ?? ?? D9 EE DC 1F 59 33 C9 66 3B C8 DF E0 0F 8E C9 00 00 00 F6 C4 41 0F 84 C5 00 00 00 DD 07 8B CE C1 E1 03 53 8B 5D 10 8D 04 19 89 45 FC 03 C1 89 45 F8 83 FE 01 7E 03 DC 47 08 E8 ?? ?? ?? ?? D9 E8 DE F1 51 51 DD 1C 24 56 FF 75 FC E8 ?? ?? ?? ?? 83 C4 10 6A 02 58 89 45 F4 3B F0 7E 6A 8B C6 C1 E0 03 50 FF 75 FC 53 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 DD 1C 24 56 53 E8 ?? ?? ?? ?? FF 75 F8 56 57 56 53 E8 ?? ?? ?? ?? FF 75 F8 56 FF 75 FC 56 53 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 30 DD 1C 24 56 53 E8 ?? ?? ?? ?? FF 75 F8 56 53 56 FF 75 FC E8 ?? ?? ?? ?? 8B 45 F4 83 C4 24 03 C0 89 45 F4 3B C6 7C 96 FF 75 F8 56 FF 75 FC 56 57 E8 ?? ?? ?? ?? 83 C4 14 5B EB 15 F6 C4 41 75 10 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 1F 59 8B C7 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_10_1 {
	meta:
		name = "__LXp_sqrtx"
		size = 276
		refs = "0018 __LDtest 0056 __CIsqrt 0068 __LXp_setw 0084 _memcpy 008a __real@bfe0000000000000 0095 __LXp_mulh 00a1 __LXp_mulx 00b5 __real@3ff8000000000000 00c2 __LXp_addh 00ff __Feraise 0105 __LNan"
	strings:
		$1 = { 55 8B EC 83 EC 0C 56 8B 75 0C 57 8B 7D 08 85 F6 0F 84 F6 00 00 00 57 E8 ?? ?? ?? ?? D9 EE DC 1F 59 33 C9 66 3B C8 DF E0 0F 8E C9 00 00 00 F6 C4 41 0F 84 C5 00 00 00 DD 07 8B CE C1 E1 03 53 8B 5D 10 8D 04 19 89 45 FC 03 C1 89 45 F8 83 FE 01 7E 03 DC 47 08 E8 ?? ?? ?? ?? D9 E8 DE F1 51 51 DD 1C 24 56 FF 75 FC E8 ?? ?? ?? ?? 83 C4 10 6A 02 58 89 45 F4 3B F0 7E 6A 8B C6 C1 E0 03 50 FF 75 FC 53 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 DD 1C 24 56 53 E8 ?? ?? ?? ?? FF 75 F8 56 57 56 53 E8 ?? ?? ?? ?? FF 75 F8 56 FF 75 FC 56 53 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 83 C4 30 DD 1C 24 56 53 E8 ?? ?? ?? ?? FF 75 F8 56 53 56 FF 75 FC E8 ?? ?? ?? ?? 8B 45 F4 83 C4 24 03 C0 89 45 F4 3B C6 7C 96 FF 75 F8 56 FF 75 FC 56 57 E8 ?? ?? ?? ?? 83 C4 14 5B EB 15 F6 C4 41 75 10 6A 01 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? DD 1F 59 8B C7 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_11_1 {
	meta:
		name = "__Xp_subx"
		size = 70
		refs = "002e __Xp_addh"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 14 7E 35 D9 EE 57 8B 7D 10 DD 04 F7 DA E9 DF E0 F6 C4 44 7B 22 DD 04 F7 51 51 D9 E0 DD 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? D9 EE 83 C4 10 46 3B 75 14 7C D4 DD D8 5F 8B 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_20_11_1 {
	meta:
		name = "__LXp_subx"
		size = 70
		refs = "002e __LXp_addh"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 14 7E 35 D9 EE 57 8B 7D 10 DD 04 F7 DA E9 DF E0 F6 C4 44 7B 22 DD 04 F7 51 51 D9 E0 DD 1C 24 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? D9 EE 83 C4 10 46 3B 75 14 7C D4 DD D8 5F 8B 45 08 5E 5D C3 }
	condition:
		$1
}

rule file_10_0_1 {
	meta:
		name = "__FSinh"
		size = 362
		refs = "0009 __FDtest 006b __FRteps 0095 __real@3f2abd1aa0000000 009d __real@3f810f3ae0000000 00a5 __real@3fc5555b40000000 00bb __FXbig 00d7 __FExp 00e3 __real@3fd0000000000000 0113 __Feraise"
	strings:
		$1 = { 55 8B EC 51 8D 45 08 50 E8 ?? ?? ?? ?? 98 59 83 E8 00 0F 84 42 01 00 00 83 E8 01 0F 84 0F 01 00 00 83 E8 01 0F 84 01 01 00 00 D9 45 0C D9 EE DD E1 DF E0 F6 C4 44 7A 17 D8 5D 08 DF E0 F6 C4 41 75 02 D9 E0 D9 5D FC D9 45 FC E9 17 01 00 00 D9 45 08 D8 D1 DF E0 56 33 F6 DD D9 F6 C4 05 7A 09 D9 E0 46 D9 5D 08 D9 45 08 D9 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 04 DE C9 EB 72 D9 E8 D8 D1 DF E0 F6 C4 41 75 32 DD D8 D9 C0 D8 C9 D9 5D FC D9 45 FC DD 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? D8 C9 DC 05 ?? ?? ?? ?? DE C9 D9 C1 DE C9 DE C1 D9 5D FC D8 4D FC EB 35 D9 05 ?? ?? ?? ?? D8 DA DF E0 6A FF 51 DD D9 F6 C4 41 8D 45 08 75 23 DD D9 D9 1C 24 50 E8 ?? ?? ?? ?? D9 45 08 83 C4 0C DD 05 ?? ?? ?? ?? D8 F1 DE E9 D8 4D 0C D9 5D 08 EB 25 DD D8 D9 1C 24 50 E8 ?? ?? ?? ?? 98 83 C4 0C 83 E8 00 74 09 83 E8 01 75 0C 6A 08 EB 02 6A 10 E8 ?? ?? ?? ?? 59 D9 45 08 66 85 F6 5E 74 02 D9 E0 D9 5D FC D9 45 FC EB 3B D9 45 08 EB 36 D9 45 0C D9 EE DD E9 DF E0 F6 C4 44 7B 07 DD D8 D9 45 08 EB 0D B8 00 80 00 00 66 85 45 0A 74 02 D9 E0 D9 5D FC D9 45 FC EB 0C D9 45 08 D8 4D 0C D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_1_1 {
	meta:
		name = "__Stollx"
		size = 203
		refs = "0021 _isspace 0044 __Stoullx 00a1 __errno"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 0C 85 FF 75 03 8D 7D FC 8B 45 08 8B F0 0F B6 00 EB 04 46 0F B6 06 50 E8 ?? ?? ?? ?? 59 85 C0 75 F1 8A 1E 80 FB 2D 74 09 80 FB 2B 74 04 B3 2B EB 01 46 FF 75 14 FF 75 10 57 56 E8 ?? ?? ?? ?? 83 C4 10 8B C8 8B 45 08 3B 37 75 02 89 07 33 F6 3B 07 75 06 8B C1 0B C2 75 39 80 FB 2B 75 0F 81 FA FF FF FF 7F 77 2C 72 05 83 F9 FF 77 25 80 FB 2D 75 17 BF 00 00 00 80 33 F6 3B D7 72 06 77 18 3B CE 77 14 F7 D9 13 D6 F7 DA 8B C1 5F 5E 5B 8B E5 5D C3 BF 00 00 00 80 E8 ?? ?? ?? ?? C7 00 22 00 00 00 8B 45 14 85 C0 74 06 C7 00 01 00 00 00 80 FB 2D 74 08 83 CE FF BF FF FF FF 7F 8B C6 8B D7 EB C9 }
	condition:
		$1
}

rule file_12_83_1 {
	meta:
		name = "??0_Init_wclog@std@@QAE@XZ"
		size = 32
		refs = "0001 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0007 ?_Ptr_wclog@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0013 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? 8B C1 C3 }
	condition:
		$1
}

rule file_113_83_1 {
	meta:
		name = "??0_Init_cin@std@@QAE@XZ"
		size = 32
		refs = "0001 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 0007 ?_Ptr_cin@std@@3PAV?$basic_istream@DU?$char_traits@D@std@@@1@A 0013 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? 8B C1 C3 }
	condition:
		$1
}

rule file_43_83_1 {
	meta:
		name = "??0_Init_clog@std@@QAE@XZ"
		size = 32
		refs = "0001 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0007 ?_Ptr_clog@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0013 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? 8B C1 C3 }
	condition:
		$1
}

rule file_56_83_1 {
	meta:
		name = "??0_Init_ushcin@std@@QAE@XZ"
		size = 32
		refs = "0001 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0007 ?_Ptr_wcin@std@@3PAV?$basic_istream@GU?$char_traits@G@std@@@1@A 0013 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? 8B C1 C3 }
	condition:
		$1
}

rule file_73_83_1 {
	meta:
		name = "??0_Init_ushclog@std@@QAE@XZ"
		size = 32
		refs = "0001 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0007 ?_Ptr_wclog@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0013 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? 8B C1 C3 }
	condition:
		$1
}

rule file_102_83_1 {
	meta:
		name = "??0_Init_wcin@std@@QAE@XZ"
		size = 32
		refs = "0001 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0007 ?_Ptr_wcin@std@@3PAV?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0013 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 50 04 A1 ?? ?? ?? ?? 89 82 ?? ?? ?? ?? 8B C1 C3 }
	condition:
		$1
}

rule file_12_199_1 {
	meta:
		name = "??__Einit_wclog@std@@YAXXZ"
		size = 30
		refs = "0001 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0007 ?_Ptr_wclog@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0013 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 48 04 A1 ?? ?? ?? ?? 89 81 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_113_202_1 {
	meta:
		name = "??__Einit_cin@std@@YAXXZ"
		size = 30
		refs = "0001 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 0007 ?_Ptr_cin@std@@3PAV?$basic_istream@DU?$char_traits@D@std@@@1@A 0013 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 48 04 A1 ?? ?? ?? ?? 89 81 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_43_202_1 {
	meta:
		name = "??__Einit_clog@std@@YAXXZ"
		size = 30
		refs = "0001 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0007 ?_Ptr_clog@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A 0013 ?_Ptr_cout@std@@3PAV?$basic_ostream@DU?$char_traits@D@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 48 04 A1 ?? ?? ?? ?? 89 81 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_56_199_1 {
	meta:
		name = "??__Einit_ushcin@std@@YAXXZ"
		size = 30
		refs = "0001 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0007 ?_Ptr_wcin@std@@3PAV?$basic_istream@GU?$char_traits@G@std@@@1@A 0013 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 48 04 A1 ?? ?? ?? ?? 89 81 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_73_199_1 {
	meta:
		name = "??__Einit_ushclog@std@@YAXXZ"
		size = 30
		refs = "0001 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0007 ?_Ptr_wclog@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A 0013 ?_Ptr_wcout@std@@3PAV?$basic_ostream@GU?$char_traits@G@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 48 04 A1 ?? ?? ?? ?? 89 81 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_102_199_1 {
	meta:
		name = "??__Einit_wcin@std@@YAXXZ"
		size = 30
		refs = "0001 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0007 ?_Ptr_wcin@std@@3PAV?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0013 ?_Ptr_wcout@std@@3PAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@A"
	strings:
		$1 = { A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 48 04 A1 ?? ?? ?? ?? 89 81 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_13_0_1 {
	meta:
		name = "__Getcoll"
		size = 33
		refs = "0002 ____lc_collate_cp_func 0009 ____lc_locale_name_func 0016 __wcsdup"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 E8 ?? ?? ?? ?? 8B 50 04 85 D2 74 09 52 E8 ?? ?? ?? ?? 59 8B D0 8B C6 5E C3 }
	condition:
		$1
}

rule file_13_1_1 {
	meta:
		name = "__Strcoll"
		size = 147
		refs = "001a ____lc_locale_name_func 0022 ____lc_collate_cp_func 0041 _memcmp 006e ___crtCompareStringA 007a __errno"
	strings:
		$1 = { 55 8B EC 8B 45 18 53 56 8B 75 0C 2B 75 08 57 8B 7D 14 2B 7D 10 85 C0 75 0F E8 ?? ?? ?? ?? 8B 58 04 E8 ?? ?? ?? ?? EB 05 8B 58 04 8B 00 85 DB 75 2D 8B C6 3B F7 7C 02 8B C7 50 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 42 3B F7 74 3E 3B F7 0F 9D C0 8D 04 45 FF FF FF FF EB 30 50 57 FF 75 10 56 FF 75 08 68 00 10 00 00 53 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF 7F EB 03 83 E8 02 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_14_0_1 {
	meta:
		name = "?_MP_Add@std@@YAXQA_K_K@Z"
		size = 49
		refs = "0026 ?add@std@@YAXPA_KH0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 0C 83 65 F4 00 83 65 FC 00 89 45 F0 8B 45 10 89 45 F8 8D 45 F0 6A 02 50 6A 05 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_1_1 {
	meta:
		name = "?_MP_Get@std@@YA_KQA_K@Z"
		size = 28
		refs = "0010 __allshl"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 B1 20 8B 46 08 8B 56 0C E8 ?? ?? ?? ?? 03 06 13 56 04 5E 5D C3 }
	condition:
		$1
}

rule file_14_2_1 {
	meta:
		name = "?_MP_Mul@std@@YAXQA_K_K1@Z"
		size = 239
		refs = "0087 __allmul 009e __aullshr"
	strings:
		$1 = { 55 8B EC 83 EC 3C 8B 45 0C 33 D2 53 8B 5D 08 56 89 45 D4 8B F3 8B 45 10 57 89 45 DC 8D 7B 08 8B 45 14 89 45 C4 8B 45 18 6A 08 89 45 CC 8D 45 C4 59 89 13 2B C3 89 53 04 F3 A5 8B FA 89 55 D8 8B F3 89 55 E0 89 55 C8 89 55 D0 89 7D F4 89 75 F0 89 45 E4 8B 0C 30 89 4D EC 8B 4C 30 04 8B 04 30 0B C1 89 4D E8 75 08 89 56 10 89 56 14 EB 63 8B DE 89 55 FC 8B 75 EC 8B FA 89 55 F8 51 56 FF 74 FD D8 FF 74 FD D4 E8 ?? ?? ?? ?? 03 45 FC B1 20 13 55 F8 01 03 8B 03 11 53 04 8B 53 04 E8 ?? ?? ?? ?? 83 63 04 00 8D 5B 08 8B 4D E8 47 89 45 FC 89 55 F8 83 FF 02 7C C4 8B 5D 08 8B 75 F0 89 7D E8 8B 4D E8 8B 7D F4 03 CF 89 54 CB 04 33 D2 89 04 CB 8B 45 E4 47 83 C6 08 89 7D F4 89 75 F0 83 FF 02 0F 8C 6B FF FF FF 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_14_3_1 {
	meta:
		name = "?_MP_Rem@std@@YAXQA_K_K@Z"
		size = 704
		refs = "003e ?limit@std@@YAHPA_KH@Z 005e __aulldiv 007d ?mul@std@@YAXPA_KH_K@Z 00c4 __allshl 00dc __aulldvrm 0132 __allmul 01ad __aullshr 0245 ?add@std@@YAXPA_KH0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 4C 8B 45 0C 53 56 57 89 45 B4 33 FF 8B 45 10 6A 02 89 45 BC 0B C7 5B 89 7D B8 89 7D C0 89 5D F8 75 11 8D 4D BC 8D 49 F8 4B 8B 01 0B 41 04 74 F5 89 5D F8 6A 05 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 4C DD AC 8B F0 8B 44 DD B0 2B F3 83 C1 01 89 75 E0 13 C7 50 51 6A 01 57 E8 ?? ?? ?? ?? 8B C8 8B C2 89 4D D8 89 45 E8 83 F9 0