private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_2_0_0 {
	meta:
		name = "__vdecl_fmod2"
		size = 61
		refs = "0011 fmod"
	strings:
		$1 = { 48 83 EC 48 F3 0F 7F 44 24 20 F3 0F 7F 4C 24 30 E8 ?? ?? ?? ?? 66 0F D6 44 24 20 F3 0F 7E 44 24 28 F3 0F 7E 4C 24 38 E8 ?? ?? ?? ?? 66 0F D6 44 24 28 F3 0F 6F 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 187
		refs = "000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d __p__commode 0025 _get_startup_commit_mode 0031 __scrt_initialize_onexit_tables 003a _RTC_Initialize 0041 _RTC_Terminate 0046 atexit 004b _get_startup_argv_mode 0052 _configure_wide_argv 005b ?__scrt_initialize_type_info@@YAXXZ 0060 __scrt_is_user_matherr_present 006b _matherr 0070 __setusermatherr 0075 _initialize_invalid_parameter_handler 007a _initialize_denormal_control 007f _get_startup_thread_locale_mode 0086 _configthreadlocale 008b _should_initialize_environment 0094 _initialize_wide_environment 0099 __scrt_initialize_winrt 00ab __scrt_fastfail"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 02 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? B9 01 00 00 00 89 03 E8 ?? ?? ?? ?? 84 C0 74 6C E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 85 C0 75 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 B9 07 00 00 00 E8 ?? ?? ?? ?? CC B9 07 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_315_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 187
		refs = "000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d __p__commode 0025 _get_startup_commit_mode 0031 __scrt_initialize_onexit_tables 003a _RTC_Initialize 0041 _RTC_Terminate 0046 atexit 004b _get_startup_argv_mode 0052 _configure_narrow_argv 005b ?__scrt_initialize_type_info@@YAXXZ 0060 __scrt_is_user_matherr_present 006b _matherr 0070 __setusermatherr 0075 _initialize_invalid_parameter_handler 007a _initialize_denormal_control 007f _get_startup_thread_locale_mode 0086 _configthreadlocale 008b _should_initialize_environment 0094 _initialize_narrow_environment 0099 __scrt_initialize_winrt 00ab __scrt_fastfail"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 02 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? B9 01 00 00 00 89 03 E8 ?? ?? ?? ?? 84 C0 74 6C E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 85 C0 75 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 B9 07 00 00 00 E8 ?? ?? ?? ?? CC B9 07 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "?post_pgo_initialization@@YAHXZ"
		size = 16
		refs = "0005 __scrt_initialize_default_local_stdio_options"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "?pre_cpp_initialization@@YAXXZ"
		size = 25
		refs = "0005 __scrt_set_unhandled_exception_filter 000a _get_startup_new_mode 0015 _set_new_mode"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "?__scrt_common_main@@YAHXZ"
		size = 18
		refs = "0005 __security_init_cookie 000e ?__scrt_common_main_seh@@YAHXZ"
		altNames = "WinMainCRTStartup mainCRTStartup wWinMainCRTStartup wmainCRTStartup"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 364
		refs = "0010 __scrt_initialize_crt 001e __scrt_fastfail 002c __scrt_acquire_startup_lock 0034 __scrt_current_native_startup_state 0058 __xi_z 005f __xi_a 0064 _initterm_e 0079 __xc_z 0080 __xc_a 0085 _initterm 00a0 __scrt_release_startup_lock 00a5 __scrt_get_dyn_tls_init_callback 00b6 __scrt_is_nonwritable_in_current_image 00c5 _guard_check_icall 00d5 __scrt_get_dyn_tls_dtor_callback 00f2 _register_thread_local_exe_atexit_callback 00f7 __scrt_get_show_window_mode 00ff _get_wide_winmain_command_line 010e __ImageBase 0113 wWinMain 011a __scrt_is_managed_app 0125 exit 012f _cexit 0138 __scrt_uninitialize_crt 014e _exit 015b _c_exit"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 B9 01 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 0B B9 07 00 00 00 E8 ?? ?? ?? ?? CC 40 32 FF 40 88 7C 24 20 E8 ?? ?? ?? ?? 8A D8 8B 0D ?? ?? ?? ?? 83 F9 01 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? 85 C9 75 4A C7 05 ?? ?? ?? ?? 01 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B8 FF 00 00 00 E9 EB 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 08 40 B7 01 40 88 7C 24 20 8A CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 22 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 16 48 8B 1B 48 8B CB E8 ?? ?? ?? ?? 45 33 C0 41 8D 50 02 33 C9 FF D3 E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 14 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 08 48 8B 0B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 D8 E8 ?? ?? ?? ?? 4C 8B C0 44 8B CB 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 84 C0 75 07 8B CB E8 ?? ?? ?? ?? 40 84 FF 75 05 E8 ?? ?? ?? ?? 33 D2 B1 01 E8 ?? ?? ?? ?? 8B C3 EB 21 8B D8 E8 ?? ?? ?? ?? 84 C0 75 08 8B CB E8 ?? ?? ?? ?? CC 80 7C 24 20 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_315_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 364
		refs = "0010 __scrt_initialize_crt 001e __scrt_fastfail 002c __scrt_acquire_startup_lock 0034 __scrt_current_native_startup_state 0058 __xi_z 005f __xi_a 0064 _initterm_e 0079 __xc_z 0080 __xc_a 0085 _initterm 00a0 __scrt_release_startup_lock 00a5 __scrt_get_dyn_tls_init_callback 00b6 __scrt_is_nonwritable_in_current_image 00c5 _guard_check_icall 00d5 __scrt_get_dyn_tls_dtor_callback 00f2 _register_thread_local_exe_atexit_callback 00f7 __scrt_get_show_window_mode 00ff _get_narrow_winmain_command_line 010e __ImageBase 0113 WinMain 011a __scrt_is_managed_app 0125 exit 012f _cexit 0138 __scrt_uninitialize_crt 014e _exit 015b _c_exit"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 B9 01 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 0B B9 07 00 00 00 E8 ?? ?? ?? ?? CC 40 32 FF 40 88 7C 24 20 E8 ?? ?? ?? ?? 8A D8 8B 0D ?? ?? ?? ?? 83 F9 01 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? 85 C9 75 4A C7 05 ?? ?? ?? ?? 01 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B8 FF 00 00 00 E9 EB 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 08 40 B7 01 40 88 7C 24 20 8A CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 22 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 16 48 8B 1B 48 8B CB E8 ?? ?? ?? ?? 45 33 C0 41 8D 50 02 33 C9 FF D3 E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 14 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 08 48 8B 0B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 D8 E8 ?? ?? ?? ?? 4C 8B C0 44 8B CB 33 D2 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 84 C0 75 07 8B CB E8 ?? ?? ?? ?? 40 84 FF 75 05 E8 ?? ?? ?? ?? 33 D2 B1 01 E8 ?? ?? ?? ?? 8B C3 EB 21 8B D8 E8 ?? ?? ?? ?? 84 C0 75 08 8B CB E8 ?? ?? ?? ?? CC 80 7C 24 20 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_4_5_0 {
	meta:
		name = "?filt$0@?0??__scrt_common_main_seh@@YAHXZ@4HA"
		size = 30
		refs = "0012 _seh_filter_exe"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 48 8B D1 8B 08 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_4_6_0 {
	meta:
		name = "?configure_argv@__scrt_wide_argv_policy@@SAHXZ"
		size = 20
		refs = "0005 _get_startup_argv_mode 0010 _configure_wide_argv"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_3_0 {
	meta:
		name = "?configure_argv@__scrt_narrow_argv_policy@@SAHXZ"
		size = 20
		refs = "0005 _get_startup_argv_mode 0010 _configure_narrow_argv"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 44
		refs = "0007 __scrt_get_show_window_mode 000f _get_wide_winmain_command_line 0019 __ImageBase 0028 wWinMain"
	strings:
		$1 = { 40 53 48 83 EC 20 E8 ?? ?? ?? ?? 0F B7 D8 E8 ?? ?? ?? ?? 4C 8B C0 48 8D 0D ?? ?? ?? ?? 44 8B CB 33 D2 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_315_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 44
		refs = "0007 __scrt_get_show_window_mode 000f _get_narrow_winmain_command_line 0019 __ImageBase 0028 WinMain"
	strings:
		$1 = { 40 53 48 83 EC 20 E8 ?? ?? ?? ?? 0F B7 D8 E8 ?? ?? ?? ?? 4C 8B C0 48 8D 0D ?? ?? ?? ?? 44 8B CB 33 D2 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "__avx_sinf8"
		size = 2784
		refs = "0080 __common_ssin_data 0213 __common_ssin_cout_rare 0248 __common_ssin_reduction_data"
	strings:
		$1 = { 56 41 56 41 57 48 81 EC C0 02 00 00 33 F6 C5 7C 11 BC 24 A0 02 00 00 C5 7C 11 B4 24 60 02 00 00 C5 7C 11 AC 24 20 02 00 00 C5 7C 11 A4 24 40 02 00 00 C5 7C 11 9C 24 C0 01 00 00 C5 7C 11 94 24 E0 01 00 00 C5 7C 11 8C 24 A0 01 00 00 C5 7C 11 84 24 80 02 00 00 C5 FC 11 BC 24 80 01 00 00 C5 FC 11 B4 24 00 02 00 00 C5 C1 EF FF 4C 89 AC 24 D8 00 00 00 4C 8D AC 24 1F 01 00 00 C5 FC 10 35 ?? ?? ?? ?? 49 83 E5 C0 C5 FC 54 D6 C5 EC C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CB 01 C5 F1 6B E3 C5 D9 63 EF C5 F9 D7 C5 84 C0 0F 85 6A 01 00 00 C5 7C 10 05 ?? ?? ?? ?? C5 EC 59 1D ?? ?? ?? ?? C4 C1 64 58 E0 C5 CC 55 C8 C5 D1 72 F4 1F C4 41 5C 5C E8 C5 14 59 0D ?? ?? ?? ?? C5 14 59 15 ?? ?? ?? ?? C5 14 59 25 ?? ?? ?? ?? C5 14 59 3D ?? ?? ?? ?? C4 C1 6C 5C D1 C4 41 6C 5C DA C4 41 24 5C F4 C4 C1 0C 5C D7 C5 6C 59 D2 C4 E3 7D 19 E6 01 C5 AC 59 25 ?? ?? ?? ?? C5 C1 72 F6 1F C4 E3 55 18 DF 01 C5 DC 58 2D ?? ?? ?? ?? C4 C1 54 59 F2 C5 CC 58 3D ?? ?? ?? ?? C4 41 44 59 C2 C5 3C 58 0D ?? ?? ?? ?? C4 41 34 59 DA C5 6C 57 EB C4 41 24 59 E5 C4 41 1C 58 F5 C5 8C 57 C9 40 84 F6 75 73 C5 FC 10 B4 24 00 02 00 00 C5 FC 10 BC 24 80 01 00 00 C5 7C 10 84 24 80 02 00 00 C5 7C 10 8C 24 A0 01 00 00 C5 7C 10 94 24 E0 01 00 00 C5 7C 10 9C 24 C0 01 00 00 C5 7C 10 A4 24 40 02 00 00 C5 7C 10 AC 24 20 02 00 00 C5 7C 10 B4 24 60 02 00 00 C5 7C 10 BC 24 A0 02 00 00 4C 8B AC 24 D8 00 00 00 C5 FC 28 C1 48 81 C4 C0 02 00 00 41 5F 41 5E 5E C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 F6 0F 84 79 FF FF FF 45 33 F6 44 0F A3 F6 72 14 41 FF C6 41 83 FE 20 7C F1 C4 C1 7C 10 4D 40 E9 5C FF FF FF C5 F8 77 4B 8D 4C B5 00 4B 8D 54 B5 40 E8 ?? ?? ?? ?? EB D8 C5 7C 10 15 ?? ?? ?? ?? BA 00 00 80 7F C4 C1 7C 11 45 00 C5 79 6E C2 C4 41 79 70 E8 00 C5 AC 54 F2 BA FF 00 00 00 C4 C1 4C C2 CA 00 48 8D 05 ?? ?? ?? ?? C5 91 DB E0 C4 C3 7D 19 C7 01 C5 89 72 D4 17 C4 41 11 DB CF C4 C1 19 72 F6 01 C4 C1 21 72 D1 17 C4 C1 19 FE EE C4 C1 49 72 F3 01 C4 41 49 FE D3 C4 C1 31 72 F2 02 C4 41 79 7E CE C5 F8 11 44 24 20 C5 78 11 7C 24 30 C4 43 79 16 CF 01 C4 63 79 16 CE 02 C4 E3 7D 19 CB 01 C5 F1 6B D3 C5 F1 72 F5 02 C5 E9 63 FF C5 F9 D7 CF C4 C1 79 7E C8 C4 41 79 6E 24 06 C4 41 79 6E 34 07 89 8C 24 D0 00 00 00 C4 63 79 16 C9 03 C4 C3 79 16 CA 02 C4 C3 79 16 CB 03 C4 C3 79 16 C9 01 C5 F9 6E 2C 06 C5 F9 6E 34 01 C4 C1 79 6E 3C 02 C4 41 79 6E 04 03 C4 41 19 6C DE C5 51 6C D6 C5 F9 6E 6C 06 04 C5 F9 6E 74 01 04 C4 41 41 6C E8 C4 41 20 C6 C2 88 C4 41 79 6E 64 06 04 C4 41 79 6E 74 07 04 C5 51 6C D6 C4 C1 79 6E 6C 07 08 41 BF FF FF 7F 00 C4 C1 79 6E 1C 00 C4 C1 79 6E 14 01 C4 41 19 6C DE C4 41 79 6E 74 06 08 41 BE 00 00 80 00 C5 E1 6C E2 C4 C1 79 6E 4C 00 04 C4 C1 79 6E 5C 01 04 C4 C1 79 6E 54 02 04 C4 C1 79 6E 7C 03 04 C4 41 58 C6 ED 88 C5 F1 6C E3 C5 69 6C CF C4 C1 79 6E 7C 03 08 41 BB FF FF 00 00 C4 C1 79 6E 4C 00 08 41 B8 00 00 40 47 C4 C1 79 6E 5C 01 08 41 B9 00 00 80 3F C4 C1 79 6E 54 02 08 41 BA 00 00 00 80 C4 C1 58 C6 E1 88 C5 71 6C CB C5 69 6C E7 C4 C1 79 6E FF C4 C1 30 C6 CC 88 C4 41 79 6E CE C5 79 70 E7 00 41 BF 00 00 80 28 C5 89 6C DD C5 99 DB C0 C4 C1 79 70 E9 00 C4 41 19 DB FF C4 41 20 C6 D2 88 C5 79 FE F5 C5 F9 6E 74 06 08 C4 C1 79 6E C3 C5 79 6E 5C 01 08 48 8D 05 ?? ?? ?? ?? 41 BE FF FF 03 00 C4 C1 49 6C D3 C5 81 FE F5 C5 79 70 F8 00 C5 A1 72 D4 10 C4 C1 11 DB FF C4 41 09 DB CF C5 78 11 44 24 50 C4 41 39 DB E7 C5 E0 C6 DA 88 C4 C1 39 72 D2 10 C4 C1 29 DB C7 C5 E9 72 D1 10 C4 C1 29 72 D6 10 C4 41 49 DB F7 C5 FA 7F 7C 24 60 C4 C1 59 DB EF C4 E2 31 40 FF C4 C1 71 DB CF C5 FA 7F BC 24 B0 00 00 00 C5 D9 72 D3 10 C4 E2 29 40 FA C4 C1 61 DB DF C4 E2 31 40 D2 41 BB 00 00 00 34 C5 78 11 6C 24 40 C5 91 72 D6 10 C4 C2 09 40 F4 C5 E9 72 D2 10 C5 7A 7F 64 24 70 C5 C1 FE FA C5 7A 7F 84 24 90 00 00 00 B9 7A 77 95 B7 C5 FA 7F 84 24 A0 00 00 00 BE FF FF FF 7F C5 FA 7F B4 24 C0 00 00 00 C4 42 09 40 E0 C4 E2 31 40 F5 C4 62 09 40 C0 C4 E2 29 40 C1 C4 C1 39 DB D7 C5 F1 72 D0 10 C4 C1 49 DB C7 C5 F9 FE C7 C5 C9 72 D6 10 C5 F1 FE F8 C4 C1 39 72 D0 10 C4 E2 11 40 C3 C4 E2 11 40 DC C5 F9 72 D0 10 C4 E2 09 40 E4 C5 F1 72 D4 10 C5 E1 FE D9 C5 F1 72 D7 10 C5 7A 7F 9C 24 80 00 00 00 C5 E9 FE D3 C4 42 31 40 DB C5 F9 FE E2 C4 E2 29 40 ED C4 C1 21 DB C7 C5 D1 FE DE C4 C1 19 DB D7 C5 F9 FE C3 C5 E1 72 D4 10 C5 F1 FE F0 C4 C1 21 72 D3 10 C4 E2 11 40 8C 24 A0 00 00 00 C5 D1 72 D6 10 C4 C1 71 FE C0 C4 C1 19 72 D4 10 C5 E9 FE C8 C4 C1 41 DB FF C4 E2 29 40 94 24 80 00 00 00 C5 61 FE C1 C5 FA 6F 9C 24 B0 00 00 00 C4 C1 69 FE C3 C4 C1 61 DB CF C4 C1 69 72 D0 10 C5 F1 FE C8 C4 C1 39 72 F0 10 C4 62 11 40 9C 24 90 00 00 00 C5 D1 FE E9 C5 FA 6F 8C 24 C0 00 00 00 C4 41 21 FE DC C4 C1 71 DB C7 C5 99 72 D5 10 C4 C1 79 FE C3 C5 F1 72 D1 10 C5 78 10 5C 24 40 C5 E9 FE D0 C4 C1 79 72 D3 10 C4 C1 51 DB EF C4 62 29 40 54 24 60 C4 41 79 6E D9 C4 62 31 40 C8 C5 F9 72 D3 10 C4 41 31 DB CF C5 29 FE D0 C4 C1 31 FE DA C5 F9 72 D2 10 C5 19 FE CB C4 C1 69 DB D7 C5 F8 10 5C 24 50 C4 C1 19 72 F1 10 C5 B1 72 D3 10 C5 19 FE D5 C4 62 11 40 6C 24 70 41 B9 DB 0F C9 40 C4 42 09 40 F1 C5 11 FE E9 C4 C1 09 DB DF C4 41 59 DB FF C4 41 61 FE CD C4 C1 79 6E E2 C4 C1 79 FE C1 C5 89 72 F6 10 C5 F9 70 F4 00 C5 99 72 F0 10 C5 C9 DB 6C 24 20 C5 09 FE CF C4 C1 79 70 FB 00 C5 99 FE C2 C5 49 DB 74 24 30 C4 C1 71 72 D2 09 C5 D1 EF DF C4 41 79 6E E0 C4 41 39 FE FF C5 B9 72 D0 09 C5 89 EF E7 C5 F1 EB D3 C4 C1 79 70 F4 00 C5 39 EB EC C4 41 79 6E E7 41 BA FF 01 00 00 41 B8 00 10 C9 40 41 BF 00 00 80 35 C4 C3 6D 18 CD 01 C5 F9 6E D2 C4 63 4D 18 DE 01 BA 00 F0 FF FF C5 A4 58 E1 C5 79 70 C2 00 C4 C1 5C 5C DB C5 74 5C EB C4 C1 79 70 CC 00 C4 41 79 6E E6 C5 D1 EF D1 C5 89 EF D9 C4 C1 79 70 CC 00 C4 C1 71 DB F1 C4 C1 71 DB CF C5 A1 72 F6 05 C5 99 72 F1 05 C5 21 EB DA C5 99 EB F3 C4 C1 31 72 D1 12 C4 C1 01 72 D7 12 C4 E3 6D 18 DB 01 C4 C1 79 6E D2 C4 E3 25 18 CE 01 C5 79 6E D9 C5 F9 70 F2 00 C4 C1 79 6E D1 C5 74 5C E3 C4 C1 79 6E CB C4 41 49 DB D2 C5 C9 DB C0 C5 F9 70 D9 00 C4 C1 29 72 F2 0E C5 D1 EF EB C4 41 29 EB D1 C5 A9 EB CD C5 A9 72 F0 0E C5 09 EF F3 C4 41 29 EB D7 C4 C1 29 EB C6 C4 E3 75 18 D8 01 C4 43 55 18 F6 01 C4 C1 79 6E E8 C4 41 64 5C D6 C5 F9 70 F5 00 C4 41 14 58 CA C4 C1 14 5C C1 C5 79 70 EA 00 C5 AC 58 C8 C5 79 6E D2 C4 C1 79 70 C2 00 C4 41 74 58 FC C4 41 79 70 E3 00 C4 E3 7D 18 C8 01 C5 B4 54 E9 C5 34 5C CD C4 43 15 18 ED 01 C4 E3 4D 18 D6 01 C4 C1 79 6E F7 C4 C3 1D 18 DC 01 C4 41 6C 59 D1 C5 E4 59 CD C4 41 14 59 F7 C4 C1 64 59 D9 C5 EC 59 C5 C5 F9 6E D6 C5 F9 70 EA 00 C5 79 70 CE 00 C5 2C 58 F9 C5 0C 58 D3 C4 C1 04 58 DA C5 FC 58 CB C5 FC 5C C1 C5 7C 58 D3 C4 C1 7C 10 45 00 8B B4 24 D0 00 00 00 C4 E3 7D 19 E7 01 C4 C1 59 DB E0 C5 E9 72 F4 04 C4 C1 41 DB F8 C4 C1 79 7E D7 C4 C3 79 16 D6 01 C4 C3 79 16 D3 02 C4 C3 79 16 D2 03 C4 41 79 6E 04 07 C4 C1 79 6E 14 06 C4 43 35 18 E9 01 C5 B1 72 F7 04 C4 41 79 7E C9 C4 C1 79 6E 24 02 C4 43 79 16 C8 01 C4 63 79 16 C9 02 C4 63 79 16 CA 03 C4 41 79 6E 4C 02 04 C4 63 55 18 DD 01 C4 41 7C 54 E3 C4 C1 1C C2 DD 1E C4 41 1C C2 F5 12 C5 B9 6C EA C4 41 79 6E 04 03 C5 B9 6C F4 C4 41 79 6E 44 03 04 C5 0C 54 F8 C5 E4 54 C9 C5 D0 C6 FE 88 C4 41 79 6E 1C 01 C4 41 79 6E 24 00 C5 79 6E 2C 01 C5 79 6E 34 02 C4 C1 79 6E 6C 07 04 C4 C1 79 6E 74 06 04 C5 84 56 C9 C4 41 21 6C FC C4 C1 11 6C D6 C5 51 6C DE C4 41 39 6C E1 C5 80 C6 E2 88 C4 41 20 C6 EC 88 C4 41 64 54 D2 C5 F4 59 D9 C4 E3 45 18 D4 01 C4 C1 79 6E 64 01 04 48 8D 05 ?? ?? ?? ?? C4 41 79 6E 5C 00 04 C5 79 6E 64 01 04 C5 79 6E 74 02 04 C4 41 59 6C FB C4 41 19 6C C6 C4 41 00 C6 C0 88 C4 43 15 18 C8 01 C4 41 79 6E 6C 07 0C C4 41 79 6E 44 06 0C C4 C1 79 6E 74 03 0C C4 C1 79 6E 6C 02 0C C4 C1 11 6C E0 C4 41 79 6E 64 01 0C C4 41 79 6E 6C 00 0C C5 79 6E 74 01 0C C5 79 6E 7C 02 0C C5 C9 6C FD C4 41 19 6C C5 C4 C1 09 6C F7 C5 58 C6 DF 88 C5 B8 C6 EE 88 C5 6C 59 F9 C4 E3 25 18 FD 01 C5 74 59 E7 C4 41 34 58 EC C4 C1 34 5C E5 C4 41 04 58 C5 C4 C1 5C 58 EC C4 41 14 5C F0 C4 41 79 6E 6C 02 08 C5 E4 59 25 ?? ?? ?? ?? C4 C1 0C 58 F7 C5 5C 58 1D ?? ?? ?? ?? C5 EC 58 E7 C5 CC 58 F5 C4 C1 79 6E 7C 07 08 C5 24 59 E3 C5 E4 59 15 ?? ?? ?? ?? C4 41 79 6E 5C 06 08 C4 41 41 6C F3 C4 C1 79 6E 7C 01 08 C4 41 79 6E 5C 00 08 C5 9C 59 E9 C4 C1 74 59 C9 C4 41 79 6E 64 03 08 C4 41 19 6C FD C5 EC 58 15 ?? ?? ?? ?? C4 41 41 6C EB C5 F9 6E 7C 01 08 C5 DC 5C C9 C5 79 6E 64 02 08 C5 EC 59 DB C5 2C 59 D1 C4 C1 08 C6 D7 88 C4 41 41 6C F4 C4 41 10 C6 FE 88 C4 C1 64 59 D9 C5 D4 59 E9 C5 D4 58 F6 C4 C3 6D 18 D7 01 C5 2C 58 D2 C4 C1 64 58 E2 C5 DC 58 FE C5 BC 58 CF E9 89 F6 FF FF 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__avx_cosf8"
		size = 2768
		refs = "007f __common_scos_data 020d __common_scos_cout_rare 0242 __common_scos_reduction_data"
	strings:
		$1 = { 53 56 41 56 48 81 EC C0 02 00 00 33 DB C5 7C 11 BC 24 E0 01 00 00 C5 7C 11 B4 24 A0 02 00 00 C5 7C 11 AC 24 80 01 00 00 C5 7C 11 A4 24 A0 01 00 00 C5 7C 11 9C 24 C0 01 00 00 C5 7C 11 94 24 40 02 00 00 C5 7C 11 8C 24 20 02 00 00 C5 7C 11 84 24 80 02 00 00 C5 FC 11 BC 24 60 02 00 00 C5 FC 11 B4 24 00 02 00 00 C5 C9 EF F6 4C 89 AC 24 D8 00 00 00 4C 8D AC 24 1F 01 00 00 C5 FC 54 2D ?? ?? ?? ?? 49 83 E5 C0 C5 D4 C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CA 01 C5 F1 6B DA C5 E1 63 E6 C5 F9 D7 C4 84 C0 0F 85 69 01 00 00 C5 FC 58 0D ?? ?? ?? ?? C5 FC 10 3D ?? ?? ?? ?? C5 F4 59 15 ?? ?? ?? ?? C5 EC 58 DF C5 D9 72 F3 1F C5 64 5C C7 C5 3C 5C 35 ?? ?? ?? ?? C5 0C 59 0D ?? ?? ?? ?? C5 0C 59 1D ?? ?? ?? ?? C5 0C 59 2D ?? ?? ?? ?? C4 41 7C 5C D1 C4 41 2C 5C E3 C4 E3 7D 19 DD 01 C5 8C 59 1D ?? ?? ?? ?? C5 C9 72 F5 1F C4 41 1C 5C FD C5 84 5C FB C5 44 59 D7 C5 AC 59 15 ?? ?? ?? ?? C4 E3 5D 18 CE 01 C5 EC 58 25 ?? ?? ?? ?? C4 C1 5C 59 EA C5 D4 58 35 ?? ?? ?? ?? C4 41 4C 59 C2 C5 3C 58 0D ?? ?? ?? ?? C4 41 34 59 DA C5 44 57 E9 C4 41 24 59 E5 C4 C1 1C 58 CD 84 DB 75 72 C5 FC 10 B4 24 00 02 00 00 C5 FC 10 BC 24 60 02 00 00 C5 7C 10 84 24 80 02 00 00 C5 7C 10 8C 24 20 02 00 00 C5 7C 10 94 24 40 02 00 00 C5 7C 10 9C 24 C0 01 00 00 C5 7C 10 A4 24 A0 01 00 00 C5 7C 10 AC 24 80 01 00 00 C5 7C 10 B4 24 A0 02 00 00 C5 7C 10 BC 24 E0 01 00 00 4C 8B AC 24 D8 00 00 00 C5 FC 28 C1 48 81 C4 C0 02 00 00 41 5E 5E 5B C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 DB 0F 84 7A FF FF FF 33 F6 0F A3 F3 72 12 FF C6 83 FE 20 7C F4 C4 C1 7C 10 4D 40 E9 61 FF FF FF C5 F8 77 49 8D 4C B5 00 49 8D 54 B5 40 E8 ?? ?? ?? ?? EB DA C5 7C 10 1D ?? ?? ?? ?? BA 00 00 80 7F C4 C1 7C 11 45 00 C5 79 6E EA C4 C1 79 70 D5 00 C5 24 54 CD BA FF 00 00 00 C4 41 34 C2 D3 00 48 8D 05 ?? ?? ?? ?? C4 63 7D 19 D7 01 C5 29 6B C7 C5 B9 63 E6 C5 F9 D7 CC 89 8C 24 D0 00 00 00 C5 E9 DB F0 C4 C3 7D 19 C7 01 C5 D1 72 D6 17 C4 C1 69 DB DF C5 89 72 F5 01 C5 B1 72 D3 17 C5 89 FE CD C4 C1 19 72 F1 01 C5 A9 72 F1 02 C4 41 19 FE D9 C4 C1 61 72 F3 02 C4 C1 79 7E DB C5 79 7E D6 C5 F8 11 44 24 20 C5 78 11 7C 24 30 C4 C3 79 16 DE 01 C4 E3 79 16 DB 02 C4 E3 79 16 D9 03 C4 43 79 16 D0 01 C4 43 79 16 D1 02 C4 43 79 16 D2 03 C4 41 79 6E 34 03 C4 C1 79 6E 2C 06 C5 F9 6E 0C 03 C5 79 6E 24 01 C5 F9 6E 3C 06 C4 41 79 6E 04 00 C4 C1 79 6E 24 01 C4 41 79 6E 2C 02 C5 09 6C CD C4 41 71 6C DC C4 41 79 6E 74 03 04 C4 C1 79 6E 6C 06 04 C5 F9 6E 4C 03 04 C5 79 6E 64 01 04 C4 C1 41 6C F0 C4 C1 59 6C D5 C4 41 30 C6 C3 88 C5 79 6E 54 06 04 C4 C1 79 6E 7C 00 04 C5 09 6C CD C4 41 71 6C DC C5 48 C6 EA 88 C4 C1 79 6E 64 01 04 C4 C1 79 6E 74 02 04 C5 A9 6C D7 C4 41 30 C6 D3 88 C4 41 79 6E 4C 06 08 41 BE FF FF 7F 00 C5 D9 6C DE C4 41 79 6E 64 03 08 41 BB 00 00 80 00 C5 E8 C6 E3 88 C5 F9 6E 7C 06 08 BE 00 00 40 47 C4 C1 79 6E 74 00 08 41 B8 00 00 80 3F C4 C1 79 6E 54 01 08 41 B9 00 00 00 80 C4 C1 79 6E 5C 02 08 41 BA FF FF 00 00 C5 41 6C F6 C5 E9 6C EB C5 88 C6 CD 88 C4 41 79 6E F6 C4 C1 19 6C F1 C4 C1 79 6E EB C4 41 79 70 E6 00 41 BB FF FF 03 00 C5 79 6E 5C 03 08 C5 99 DB C0 C5 F9 6E 7C 01 08 48 8D 05 ?? ?? ?? ?? C4 41 19 DB FF C5 79 70 CD 00 41 BE 00 00 80 28 C5 A1 6C D7 C4 41 79 FE F1 C4 C1 79 6E C2 C5 A1 72 D4 10 C5 C8 C6 DA 88 C4 C1 01 FE F1 C5 79 70 F8 00 C5 E9 72 D1 10 C4 C1 11 DB FF C4 41 09 DB CF C5 78 11 44 24 50 C4 41 39 DB E7 C4 C1 39 72 D2 10 C4 C1 29 DB C7 C4 C1 29 72 D6 10 C4 41 49 DB F7 C5 FA 7F 7C 24 60 C4 C1 59 DB EF C4 E2 31 40 FF C4 C1 71 DB CF C5 FA 7F BC 24 B0 00 00 00 C5 D9 72 D3 10 C4 E2 29 40 FA C4 C1 61 DB DF C4 E2 31 40 D2 41 BA 00 00 00 34 C5 78 11 6C 24 40 C5 91 72 D6 10 C4 C2 09 40 F4 C5 E9 72 D2 10 C5 7A 7F 64 24 70 C5 C1 FE FA C5 7A 7F 84 24 90 00 00 00 B9 7A 77 95 B7 C5 FA 7F 84 24 A0 00 00 00 BB FF FF FF 7F C5 FA 7F B4 24 C0 00 00 00 C4 42 09 40 E0 C4 E2 31 40 F5 C4 62 09 40 C0 C4 E2 29 40 C1 C5 F1 72 D0 10 C4 C1 49 DB C7 C5 F9 FE C7 C5 C9 72 D6 10 C5 F1 FE F8 C4 C1 39 DB CF C4 E2 11 40 C3 C4 C1 39 72 D0 10 C4 E2 11 40 DC C5 F9 72 D0 10 C4 E2 09 40 E4 C5 D9 72 D4 10 C5 E1 FE D4 C5 7A 7F 9C 24 80 00 00 00 C5 F1 FE DA C4 42 31 40 DB C5 F9 FE E3 C4 E2 29 40 ED C4 C1 21 DB C7 C5 D1 FE CE C5 E9 72 D7 10 C5 F9 FE C1 C4 C1 19 DB EF C5 E9 FE F0 C5 E1 72 D4 10 C4 E2 11 40 94 24 A0 00 00 00 C4 C1 21 72 D3 10 C4 C1 69 FE C0 C4 C1 19 72 D4 10 C5 51 FE C0 C5 F9 72 D6 10 C4 E2 29 40 94 24 80 00 00 00 C4 41 61 FE C0 C5 FA 6F 9C 24 B0 00 00 00 C4 41 69 FE DB C4 C1 61 DB CF C4 C1 41 DB FF C4 C1 71 FE D3 C5 C9 72 F6 10 C5 FA 6F 8C 24 C0 00 00 00 C5 F9 FE EA C4 62 11 40 9C 24 90 00 00 00 C4 C1 71 DB C7 C4 41 21 FE DC C4 C1 69 72 D0 10 C4 C1 79 FE C3 C5 99 72 D5 10 C5 E9 FE D0 C4 C1 51 DB EF C5 F8 10 44 24 40 C4 C1 39 72 F0 10 C5 A1 72 D0 10 C4 42 31 40 CB C4 62 29 40 54 24 60 C4 C1 31 DB C7 C5 B1 72 D3 10 C4 41 29 FE D9 C5 B1 72 D2 10 C4 C1 79 FE C3 C4 C1 69 DB D7 C5 19 FE D0 C4 41 79 6E E0 C5 F8 10 44 24 50 C4 C1 61 72 F2 10 C5 A1 72 D0 10 C5 F9 72 D1 10 C4 62 11 40 6C 24 70 C5 61 FE D5 C4 42 09 40 F3 C5 11 FE E8 C4 41 09 DB DF C4 41 59 DB FF C4 C1 21 FE DD C4 C1 79 6E E1 C5 31 FE CB C4 C1 21 72 D2 09 C5 F9 70 CC 00 C4 C1 09 72 F1 10 C5 F1 DB 6C 24 20 C5 89 FE C2 C4 C1 79 70 E4 00 C5 49 FE CF C5 71 DB 74 24 30 C5 D1 EF FC C5 F9 6E DE C5 91 72 D0 09 C5 89 EF F4 C4 41 39 FE FF C5 F9 70 CB 00 C5 21 EB C7 C5 91 EB D6 C4 C1 79 6E F6 41 B9 FF 01 00 00 41 B8 DB 0F C9 40 C5 F9 70 DE 00 BE 00 10 C9 40 C5 89 EF F3 41 BE 00 00 80 35 C4 63 3D 18 DA 01 C5 D1 EF D3 C4 63 75 18 E1 01 C4 C1 79 6E CB C4 C1 1C 58 E3 C5 79 6E C2 C4 41 79 70 C0 00 C4 C1 5C 5C FC BA 00 F0 FF FF C5 24 5C EF C5 79 70 D9 00 C4 41 21 DB E1 C4 41 21 DB DF C4 C1 61 72 F4 05 C4 C1 21 72 F3 05 C5 61 EB E2 C5 A1 EB DE C4 C1 31 72 D1 12 C4 C1 01 72 D7 12 C4 E3 1D 18 CB 01 C4 41 79 6E E1 C4 63 6D 18 DE 01 C4 C1 79 6E F2 C4 C1 74 5C DB C4 C1 79 70 CC 00 C5 79 6E E2 C4 41 71 DB D2 C5 F1 DB C0 C5 F9 70 D6 00 C4 C1 21 72 F2 0E C5 D1 EF EA C4 41 21 EB C9 C5 31 EB DD C5 B1 72 F0 0E C5 09 EF F2 C4 41 31 EB CF C4 C1 31 EB C6 C5 79 6E FE C4 C1 79 70 CF 00 C4 63 25 18 D0 01 C4 43 55 18 F6 01 C4 41 2C 5C CE C4 41 79 6E D0 C4 41 79 70 F4 00 C4 C1 14 58 D1 C5 94 5C C2 C4 41 79 70 EA 00 C5 34 58 D8 C5 A4 58 F3 C5 F9 6E D9 C5 F9 70 EB 00 C4 43 0D 18 CE 01 C4 41 6C 54 D9 C4 C1 6C 5C D3 C4 C3 15 18 C5 01 C4 63 75 18 F9 01 C4 63 55 18 ED 01 C4 C1 79 6E EE C4 41 04 59 D3 C5 04 59 CA C4 41 14 59 DB C5 FC 59 F6 C5 94 59 C2 C5 F9 6E D3 C5 F9 70 DA 00 C4 41 34 58 CB C5 4C 58 D8 C5 F9 70 F5 00 C4 C1 7C 10 45 00 C4 C1 34 58 CB C5 2C 58 D9 C4 41 2C 5C D3 C5 2C 58 C9 8B 9C 24 D0 00 00 00 C4 63 65 18 E3 01 C4 41 7C 54 EC C4 63 4D 18 F6 01 C4 C1 14 C2 CE 1E C4 41 14 C2 FE 12 C5 04 54 D0 C4 41 74 54 DB C4 41 2C 56 DB C4 41 74 54 D1 C4 41 24 59 CB C4 E3 7D 19 E7 01 C4 C1 59 DB E0 C5 F1 72 F4 04 C4 C1 41 DB F8 C4 C1 79 7E CE C5 D1 72 F7 04 C4 C1 79 7E E8 C4 C3 79 16 CB 01 C4 C3 79 16 CA 02 C4 C3 79 16 C9 03 C4 E3 79 16 EE 01 C4 E3 79 16 E9 02 C4 E3 79 16 EA 03 C4 41 79 6E 04 06 C4 C1 79 6E 3C 03 C5 B9 6C D7 C4 C1 79 6E 0C 02 C4 41 79 6E 04 01 C4 C1 71 6C D8 C4 C1 79 6E 34 00 C5 79 6E 24 06 C5 E8 C6 E3 88 C4 41 49 6C FC C5 79 6E 2C 01 C5 79 6E 34 02 C4 C1 79 6E 54 06 04 C4 C1 79 6E 5C 03 04 C4 C1 79 6E 6C 02 04 C4 C1 79 6E 74 01 04 C4 C1 11 6C FE C5 69 6C C3 C5 51 6C E6 C5 80 C6 CF 88 C4 41 38 C6 EC 88 C4 E3 5D 18 F9 01 C4 C1 79 6E 4C 00 04 48 8D 05 ?? ?? ?? ?? C5 79 6E 44 06 04 C5 79 6E 64 01 04 C5 79 6E 74 02 04 C4 41 71 6C F8 C4 C1 19 6C E6 C5 80 C6 E4 88 C4 E3 15 18 F4 01 C4 41 79 6E 6C 06 08 C4 C1 79 6E 64 03 08 C4 C1 79 6E 54 02 08 C4 C1 79 6E 4C 01 08 C5 91 6C EC C4 41 79 6E 64 00 08 C5 79 6E 6C 06 08 C5 79 6E 74 01 08 C5 79 6E 7C 02 08 C5 E9 6C D9 C4 C1 19 6C E5 C4 C1 09 6C D7 C5 50 C6 C3 88 C5 D8 C6 CA 88 C4 C1 79 6E 5C 06 0C C4 41 79 6E 64 03 0C C4 41 79 6E 6C 02 0C C4 41 79 6E 74 01 0C C4 41 61 6C FC C5 F9 6E 5C 06 0C C5 79 6E 64 02 0C C4 C1 11 6C E6 C5 80 C6 D4 88 C4 E3 3D 18 E9 01 C4 C1 79 6E 4C 00 0C C5 79 6E 44 01 0C C5 71 6C EB C4 41 39 6C F4 C4 41 10 C6 FE 88 C4 41 44 59 EB C4 C3 6D 18 DF 01 C5 A4 59 CB C5 C4 58 DB C5 B4 59 3D ?? ?? ?? ?? C5 4C 58 C1 C5 C4 58 3D ?? ?? ?? ?? C4 C1 4C 5C D0 C4 C1 14 58 E0 C5 6C 58 F9 C5 3C 5C E4 C5 B4 59 0D ?? ?? ?? ?? C4 41 1C 58 F5 C5 74 58 05 ?? ?? ?? ?? C4 C1 0C 58 D7 C4 41 3C 59 E1 C4 41 44 59 C9 C4 C1 1C 59 CB C5 24 59 DE C5 B4 59 F6 C4 C1 64 5C DB C5 2C 59 D3 C5 F4 59 CB C5 AC 58 ED C5 F4 58 D2 C5 CC 58 FD C5 44 58 C2 C4 C1 5C 58 C8 E9 97 F6 FF FF 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__common_satan_cout_rare"
		size = 1584
		refs = "004f _vmlsAtanHATab"
	strings:
		$1 = { 48 83 EC 78 44 0F B7 49 02 41 81 E1 80 7F 00 00 41 C1 E9 07 44 0F 29 7C 24 50 41 81 F9 FF 00 00 00 0F 29 7C 24 60 0F 84 B1 05 00 00 F3 0F 10 09 F3 0F 5A C1 F2 0F 11 44 24 70 80 64 24 77 7F F2 0F 10 44 24 70 8A 41 03 C0 E8 07 66 0F 2F 05 ?? ?? ?? ?? 4C 8B 44 24 70 0F 82 5B 04 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 14 04 00 00 4C 89 44 24 30 44 0F 28 F8 44 8B 44 24 34 45 8B C8 41 81 E0 00 00 08 00 41 81 E1 00 00 F0 FF 41 81 C8 00 00 04 00 4C 8D 1D ?? ?? ?? ?? 45 0B C8 C7 44 24 30 00 00 00 00 44 89 4C 24 34 F2 0F 10 0D ?? ?? ?? ?? 0F 28 E1 F2 44 0F 5C 7C 24 30 C0 E0 07 F2 41 0F 59 E7 F2 0F 11 64 24 38 F2 0F 10 54 24 38 44 0F B7 54 24 76 F2 41 0F 5C D7 F2 0F 11 54 24 40 41 81 E2 F0 7F 00 00 F2 0F 10 5C 24 38 F2 0F 10 6C 24 40 41 C1 EA 04 F2 0F 5C DD F2 0F 11 5C 24 38 0F 28 E8 F2 0F 10 7C 24 38 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 5C FF F2 44 0F 11 7C 24 40 F2 0F 10 5C 24 38 F2 0F 10 64 24 40 F2 0F 11 6C 24 38 F2 0F 10 7C 24 38 8B 4C 24 74 41 C1 E2 14 81 E1 FF FF 0F 00 44 0B D1 F2 0F 5C 7C 24 70 F2 0F 11 7C 24 40 41 81 C2 00 00 40 C0 F2 0F 10 6C 24 38 F2 0F 10 54 24 40 41 C1 FA 12 F2 0F 5C EA F2 0F 11 6C 24 38 41 83 E2 FE F2 0F 10 7C 24 38 4D 63 D2 F2 0F 5C C7 F2 0F 11 44 24 40 F2 44 0F 10 7C 24 38 F2 0F 10 44 24 30 F2 0F 10 54 24 40 F2 44 0F 59 F8 F2 0F 59 D0 41 0F 28 EF F2 0F 58 EA F2 0F 11 6C 24 38 F2 0F 10 7C 24 38 F2 44 0F 5C FF F2 41 0F 58 D7 F2 0F 11 54 24 40 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 44 24 38 0F 28 FA F2 0F 10 6C 24 40 F2 0F 58 F8 F2 0F 11 7C 24 38 0F 28 FA F2 44 0F 10 7C 24 38 F2 41 0F 5C FF F2 0F 11 7C 24 40 F2 0F 10 7C 24 38 F2 44 0F 10 7C 24 40 F2 41 0F 58 FF F2 0F 11 7C 24 48 0F 28 FA F2 44 0F 10 7C 24 40 F2 41 0F 58 C7 F2 0F 11 44 24 40 F2 0F 10 44 24 48 F2 0F 5C F8 F2 0F 11 7C 24 48 F2 0F 10 7C 24 40 F2 44 0F 10 7C 24 48 F2 41 0F 58 FF F2 0F 11 7C 24 48 F2 44 0F 10 7C 24 38 F2 0F 10 44 24 48 F2 0F 58 C5 41 0F 28 EF F2 0F 59 E9 F2 0F 11 6C 24 38 F2 0F 10 7C 24 38 F2 41 0F 5C FF F2 0F 11 7C 24 40 F2 0F 10 7C 24 38 F2 0F 10 6C 24 40 F2 0F 5C FD F2 0F 11 7C 24 38 F2 0F 10 6C 24 38 F2 44 0F 5C FD F2 44 0F 11 7C 24 40 F2 0F 10 7C 24 38 F2 0F 10 6C 24 40 F2 0F 58 E8 0F 28 C2 F2 0F 5E C7 F2 0F 59 C8 F2 0F 11 4C 24 40 F2 0F 10 4C 24 40 F2 0F 5C C8 F2 0F 11 4C 24 48 F2 0F 10 44 24 40 F2 44 0F 10 7C 24 48 F2 41 0F 5C C7 F2 0F 11 44 24 48 F2 0F 10 4C 24 48 F2 0F 59 F9 F2 0F 5C D7 F2 0F 10 7C 24 48 F2 0F 59 EF F2 0F 11 6C 24 40 F2 0F 10 6C 24 40 F2 0F 5C D5 F2 0F 11 54 24 40 F2 44 0F 10 7C 24 40 F2 0F 10 7C 24 48 F2 0F 10 54 24 40 F2 0F 10 6C 24 48 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FA F2 44 0F 59 FD 0F 28 EF F2 0F 59 FC F2 0F 59 EB F2 41 0F 59 DF 41 0F 28 C7 F2 0F 59 C4 F2 44 0F 10 3D ?? ?? ?? ?? F2 0F 58 C7 F2 43 0F 10 14 D3 F2 0F 58 C3 F2 0F 11 44 24 38 0F 28 DD F2 0F 10 7C 24 38 0F 28 C2 F2 0F 58 DF F2 0F 11 5C 24 38 F2 0F 10 64 24 38 F2 0F 5C EC F2 0F 58 EF F2 0F 11 6C 24 40 F2 0F 10 5C 24 38 0F 28 EB F2 0F 58 C3 F2 0F 59 EB F2 44 0F 59 FD F2 0F 10 7C 24 40 F2 0F 11 44 24 38 F2 0F 10 4C 24 38 F2 44 0F 58 3D ?? ?? ?? ?? F2 0F 5C D1 F2 44 0F 59 FD F2 0F 58 D3 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 0F 11 54 24 40 F2 0F 10 44 24 38 F2 0F 10 64 24 40 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 FD F2 41 0F 59 DF F2 0F 58 DF F2 43 0F 58 5C D3 08 F2 0F 58 DC F2 0F 58 C3 F2 0F 11 44 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 5C 24 28 F3 0F 11 1A E9 47 01 00 00 F2 0F 10 05 ?? ?? ?? ?? C0 E0 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 4C 24 28 F3 0F 11 0A E9 12 01 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 85 00 00 00 0F 28 C8 F2 0F 59 C8 C0 E0 07 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 D0 F2 0F 11 54 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 44 24 28 F3 0F 11 02 EB 7F 45 85 C9 74 40 F2 0F 10 0D ?? ?? ?? ?? C0 E0 07 F2 0F 58 C8 F2 0F 11 4C 24 38 F2 0F 10 44 24 38 F2 0F 59 44 24 70 F2 0F 11 44 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 54 24 28 F3 0F 11 12 EB 3A F3 0F 59 C9 C0 E0 07 F3 0F 11 4C 24 20 F3 0F 10 44 24 20 F3 0F 5A C0 F2 0F 58 44 24 70 F2 0F 11 44 24 28 8A 4C 24 2F 80 E1 7F 0A C8 88 4C 24 2F F2 0F 5A 4C 24 28 F3 0F 11 0A 0F 28 7C 24 60 33 C0 44 0F 28 7C 24 50 48 83 C4 78 C3 F7 01 FF FF 7F 00 75 38 F2 0F 10 05 ?? ?? ?? ?? 8A 41 03 24 80 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 28 44 8A 44 24 2F 41 80 E0 7F 44 0A C0 44 88 44 24 2F F2 0F 5A 4C 24 28 F3 0F 11 0A EB AE F3 0F 10 01 F3 0F 58 C0 F3 0F 11 02 EB A0 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_19_1_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 64
		refs = "0030 __imp_RaiseException"
	strings:
		$1 = { 48 8B C4 48 83 EC 58 C6 40 08 00 C7 40 C8 01 10 00 00 89 48 D0 48 8D 40 08 48 89 44 24 30 4C 8D 4C 24 20 33 D2 44 8D 42 0A B9 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 00 0F B6 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_19_2_0 {
	meta:
		name = "?filt$0@?0??DebuggerProbe@@YAHK@Z@4HA"
		size = 32
		altNames = "?filt$0@?0??DebuggerRuntime@@YAHKHPEAXPEB_W@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 33 C9 81 38 88 13 6D 40 0F 94 C1 8B C1 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_19_3_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPEAXPEB_W@Z"
		size = 76
		refs = "003c __imp_RaiseException"
	strings:
		$1 = { 48 8B C4 48 83 EC 58 C6 40 08 00 C7 40 C8 02 10 00 00 89 48 D0 89 50 D4 4C 89 40 D8 48 8D 40 08 48 89 44 24 38 4C 89 4C 24 40 4C 8D 4C 24 20 33 D2 44 8D 42 0A B9 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 00 0F B6 44 24 60 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_19_5_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPEAXPEAU_RTC_ALLOCA_NODE@@H@Z"
		size = 464
		refs = "0022 __security_cookie 0033 ?_RTC_ErrorLevels@@3PAHA 0054 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 006c ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 0078 ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 0084 ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 0090 ??_C@_0BC@HHMKLAND@?$CFs?$CFs?$CFp?$CFs?$CFzd?$CFs?$CFd?$CFs?$AA@ 00a1 ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 00ad ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 00c0 sprintf_s 00ff ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 0158 ??_C@_01EEMJAFIK@?6?$AA@ 017c ??_C@_02LLMPMKNF@?$DO?5?$AA@ 0183 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 01a2 ?failwithmessage@@YAXPEAXHHPEBD@Z 01b1 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 55 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 20 FF FF FF 48 81 EC E0 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 D0 00 00 00 44 8B 35 ?? ?? ?? ?? 48 8B F2 48 89 4C 24 68 4C 8B E9 41 83 FE FF 0F 84 5A 01 00 00 48 85 D2 75 0C 4C 8D 0D ?? ?? ?? ?? E9 3B 01 00 00 48 8B 42 0C 48 8D 4A 20 48 83 E8 24 48 8D 15 ?? ?? ?? ?? 48 89 54 24 50 4C 8D 0D ?? ?? ?? ?? 44 89 44 24 48 48 8D 15 ?? ?? ?? ?? 48 89 54 24 40 4C 8D 05 ?? ?? ?? ?? 48 89 44 24 38 BA 06 01 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8D 05 ?? ?? ?? ?? 48 89 4C 24 28 48 8D 4D C0 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8B 46 0C 33 FF 48 83 E8 24 8D 4F 10 48 3B C1 48 0F 42 C8 48 85 C9 74 4A 48 8D 44 24 70 4C 8B E9 48 2B F0 4C 8D 7D 88 44 8D 67 31 48 8D 04 3E 49 8B D4 0F B6 5C 05 90 4C 8D 05 ?? ?? ?? ?? 44 8B CB 49 8B CF E8 ?? ?? ?? ?? 88 5C 3C 70 49 83 EC 03 48 FF C7 49 83 C7 03 49 3B FD 72 CE 4C 8B 6C 24 68 48 8D 45 88 C6 44 3C 70 00 48 03 C7 4C 8D 45 C0 C6 04 78 00 41 8A 00 49 FF C0 84 C0 75 F6 48 8D 55 C0 8A 02 48 8B CA 48 FF C2 84 C0 75 F4 48 8D 05 ?? ?? ?? ?? 48 89 44 24 30 48 8D 95 C7 00 00 00 48 8D 45 88 49 2B D0 48 89 44 24 28 4C 8D 4C 24 70 48 8D 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 89 44 24 20 E8 ?? ?? ?? ?? 4C 8D 4D C0 49 8B CD 41 B8 04 00 00 00 41 8B D6 E8 ?? ?? ?? ?? 48 8B 8D D0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 38 02 00 00 48 81 C4 E0 01 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_19_6_0 {
	meta:
		name = "?_RTC_Failure@@YAXPEAXH@Z"
		size = 76
		refs = "000f __ImageBase 0017 ?_RTC_ErrorLevels@@3PAHA 001f ?_RTC_ErrorMessages@@3QBQEBDB 0043 ?failwithmessage@@YAXPEAXHHPEBD@Z"
	strings:
		$1 = { 48 83 EC 28 83 FA 04 77 1C 48 63 C2 4C 8D 0D ?? ?? ?? ?? 45 8B 94 81 ?? ?? ?? ?? 4D 8B 8C C1 ?? ?? ?? ?? EB 11 4C 8B 0D ?? ?? ?? ?? 41 BA 01 00 00 00 41 8D 52 04 41 83 FA FF 74 0B 44 8B C2 41 8B D2 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_19_7_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPEAXPEBD@Z"
		size = 233
		refs = "000a __security_cookie 001c ?_RTC_ErrorLevels@@3PAHA 005c ?stack_premsg@@3QBDB 00a3 ?stack_postmsg@@3QBDB 00bc ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 00cd ?failwithmessage@@YAXPEAXHHPEBD@Z 00dd __security_check_cookie"
	strings:
		$1 = { 48 81 EC 38 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 20 04 00 00 44 8B 15 ?? ?? ?? ?? 4C 8B D9 41 83 FA FF 0F 84 A4 00 00 00 80 3A 00 0F 84 83 00 00 00 48 8B CA 8A 01 48 FF C1 84 C0 75 F7 48 2B CA 48 83 C1 2C 48 81 F9 00 04 00 00 77 67 4C 8D 4C 24 20 33 C9 48 8D 05 ?? ?? ?? ?? 8A 04 01 88 44 0C 20 48 FF C1 84 C0 75 EB 48 8D 4C 24 20 48 FF C9 48 FF C1 80 39 00 75 F8 45 33 C0 42 8A 04 02 42 88 04 01 49 FF C0 84 C0 75 F1 48 8D 4C 24 20 48 FF C9 48 FF C1 80 39 00 75 F8 4C 8D 05 ?? ?? ?? ?? 33 D2 41 8A 04 10 88 04 11 48 FF C2 84 C0 75 F2 EB 07 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 41 8B D2 49 8B CB E8 ?? ?? ?? ?? 48 8B 8C 24 20 04 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 38 04 00 00 C3 }
	condition:
		$1
}

rule file_19_8_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPEAD00_K@Z"
		size = 167
		refs = "0052 ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 0060 sprintf_s"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 18 48 89 70 20 48 89 50 10 57 41 54 41 55 41 56 41 57 48 83 EC 20 33 FF 4D 8B F8 4C 8B F2 48 8B E9 8D 77 10 4C 3B CE 49 0F 42 F1 48 85 F6 74 44 44 8D 77 31 4C 8B E1 48 8B FE 4C 8B EA 4C 2B F9 43 0F B6 1C 27 4C 8D 05 ?? ?? ?? ?? 44 8B CB 49 8B D6 49 8B CD E8 ?? ?? ?? ?? 41 88 1C 24 49 83 EE 03 49 FF C4 49 83 C5 03 48 83 EE 01 75 D1 4C 8B 74 24 58 48 8B 5C 24 50 49 8D 04 7E 48 8B 74 24 68 C6 04 2F 00 48 8B 6C 24 60 C6 04 07 00 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_19_9_0 {
	meta:
		name = "?_strlen_priv@@YA_KPEBD@Z"
		size = 19
	strings:
		$1 = { 48 8B C1 8A 10 48 FF C0 84 D2 75 F7 48 2B C1 48 FF C8 C3 }
	condition:
		$1
}

rule file_19_10_0 {
	meta:
		name = "?failwithmessage@@YAXPEAXHHPEBD@Z"
		size = 607
		refs = "001f __security_cookie 003d ?_RTC_GetErrorFuncW@@YAP6AHHPEB_WH00ZZPEBX@Z 004d ?_RTC_GetErrorFunc@@YAP6AHHPEBDH00ZZPEBX@Z 0071 __imp_MultiByteToWideChar 00b2 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 00bc ?DebuggerProbe@@YAHK@Z 00c7 ?_RTC_NoFalsePositives@@3QBHB 00d9 ?DebuggerRuntime@@YAHKHPEAXPEB_W@Z 00fd __imp_IsDebuggerPresent 012f ?_RTC_GetSrcLine@@YAHPEAEPEA_WKPEAH1K@Z 013c _guard_check_icall 0148 ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 0194 ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 01aa __imp_WideCharToMultiByte 01d1 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 0217 ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 0247 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D AC 24 58 F2 FF FF 48 81 EC A8 0E 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 90 0D 00 00 4D 8B E1 4D 63 F0 44 8B EA 48 8B F9 45 33 FF E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 0B 48 8B CF E8 ?? ?? ?? ?? 4C 8B F8 83 64 24 28 00 83 CE FF 48 83 64 24 20 00 44 8B CE 4D 8B C4 33 D2 B9 E9 FD 00 00 FF 15 ?? ?? ?? ?? 48 63 C8 48 81 F9 00 02 00 00 73 2E 89 44 24 28 44 8B CE 48 8D 85 90 09 00 00 4D 8B C4 33 D2 48 89 44 24 20 B9 E9 FD 00 00 FF 15 ?? ?? ?? ?? 48 8D B5 90 09 00 00 85 C0 75 07 48 8D 35 ?? ?? ?? ?? B9 02 10 00 00 E8 ?? ?? ?? ?? 85 C0 74 23 48 8D 0D ?? ?? ?? ?? 4C 8B CE 42 8B 14 B1 4C 8B C7 41 8B CE E8 ?? ?? ?? ?? 85 C0 0F 85 57 01 00 00 EB 02 B0 01 4D 85 FF 75 09 48 85 DB 0F 84 44 01 00 00 84 C0 74 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 32 01 00 00 41 B8 04 01 00 00 48 8D 85 60 01 00 00 44 89 44 24 28 48 8D 4F FB 4C 8D 4C 24 40 48 89 44 24 20 48 8D 54 24 50 E8 ?? ?? ?? ?? 48 85 DB 74 39 48 8B CB E8 ?? ?? ?? ?? 44 8B 44 24 40 48 8D 05 ?? ?? ?? ?? 48 89 74 24 30 4C 8D 8D 60 01 00 00 44 89 74 24 28 48 8D 54 24 50 41 8B CD 48 89 44 24 20 FF D3 E9 C5 00 00 00 48 83 64 24 38 00 48 8D 85 70 03 00 00 48 83 64 24 30 00 4C 8D 44 24 50 C7 44 24 28 0A 03 00 00 48 8D 1D ?? ?? ?? ?? 41 83 C9 FF 48 89 44 24 20 33 D2 B9 E9 FD 00 00 FF 15 ?? ?? ?? ?? 48 8D BD 70 03 00 00 B9 E9 FD 00 00 85 C0 4C 8D 85 60 01 00 00 48 8D 85 80 06 00 00 48 0F 44 FB 48 8D 35 ?? ?? ?? ?? 48 83 64 24 38 00 41 83 C9 FF 48 83 64 24 30 00 33 D2 C7 44 24 28 0A 03 00 00 48 89 44 24 20 FF 15 ?? ?? ?? ?? 48 8D 9D 80 06 00 00 49 8B CF 85 C0 48 0F 44 DE E8 ?? ?? ?? ?? 44 8B 44 24 40 48 8D 05 ?? ?? ?? ?? 4C 89 64 24 30 4C 8B CB 44 89 74 24 28 48 8B D7 41 8B CD 48 89 44 24 20 41 FF D7 83 F8 01 75 01 CC 48 8B 8D 90 0D 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 A8 0E 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_19_11_0 {
	meta:
		name = "_RTC_UninitUse"
		size = 236
		refs = "000a __security_cookie 001c ?_RTC_ErrorLevels@@3PAHA 005c ?uninit_premsg@@3QBDB 00a1 ?uninit_postmsg@@3QBDB 00ba ??_C@_0DE@OHJBPMBP@A?5variable?5is?5being?5used?5without@ 00d0 ?failwithmessage@@YAXPEAXHHPEBD@Z 00e0 __security_check_cookie"
	strings:
		$1 = { 48 81 EC 38 04 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 20 04 00 00 44 8B 15 ?? ?? ?? ?? 4C 8B C1 41 83 FA FF 0F 84 A7 00 00 00 48 85 C9 0F 84 81 00 00 00 48 8B D1 8A 02 48 FF C2 84 C0 75 F7 49 2B D0 48 83 C2 39 48 81 FA 00 04 00 00 77 65 4C 8D 4C 24 20 33 C9 48 8D 05 ?? ?? ?? ?? 8A 04 01 88 44 0C 20 48 FF C1 84 C0 75 EB 48 8D 4C 24 20 48 FF C9 48 FF C1 80 39 00 75 F8 33 D2 41 8A 04 10 88 04 11 48 FF C2 84 C0 75 F2 48 8D 4C 24 20 48 FF C9 48 FF C1 80 39 00 75 F8 4C 8D 05 ?? ?? ?? ?? 33 D2 41 8A 04 10 88 04 11 48 FF C2 84 C0 75 F2 EB 07 4C 8D 0D ?? ?? ?? ?? 48 8B 8C 24 38 04 00 00 41 B8 03 00 00 00 41 8B D2 E8 ?? ?? ?? ?? 48 8B 8C 24 20 04 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 38 04 00 00 C3 }
	condition:
		$1
}

rule file_19_13_0 {
	meta:
		name = "_vsprintf_s_l"
		size = 98
		refs = "0021 __local_stdio_printf_options 0041 __stdio_common_vsprintf_s"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 49 8B D9 49 8B F8 48 8B F2 48 8B E9 E8 ?? ?? ?? ?? 4C 8B 54 24 60 4C 8B CF 4C 89 54 24 28 4C 8B C6 48 8B D5 48 89 5C 24 20 48 8B 08 E8 ?? ?? ?? ?? 48 8B 5C 24 40 83 C9 FF 48 8B 6C 24 48 85 C0 48 8B 74 24 50 0F 48 C1 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_19_14_0 {
	meta:
		name = "sprintf_s"
		size = 82
		refs = "0021 __local_stdio_printf_options 003d __stdio_common_vsprintf_s"
	strings:
		$1 = { 4C 89 44 24 18 4C 89 4C 24 20 53 55 56 57 48 83 EC 38 49 8B F0 48 8D 6C 24 78 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 89 6C 24 28 4C 8B CE 48 83 64 24 20 00 4C 8B C3 48 8B D7 48 8B 08 E8 ?? ?? ?? ?? 83 C9 FF 85 C0 0F 48 C1 48 83 C4 38 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "??__D@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z"
		size = 123
		refs = "0039 _guard_check_icall"
	strings:
		$1 = { 48 8B C4 4C 89 40 18 48 89 48 08 53 56 57 41 56 41 57 48 83 EC 30 4D 8B F9 4D 8B F0 48 8B F2 48 8B F9 33 DB 48 89 58 D0 88 58 C8 49 3B DF 74 3A 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 41 B8 01 00 00 00 48 8B D6 48 8B CF FF 94 24 80 00 00 00 49 03 FE 48 89 7C 24 60 49 03 F6 48 89 74 24 68 48 FF C3 48 89 5C 24 28 EB C1 C6 44 24 20 01 48 83 C4 30 41 5F 41 5E 5F 5E 5B C3 }
	condition:
		$1
}

rule file_20_1_0 {
	meta:
		name = "?fin$0@?0???__D@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z@4HA"
		size = 47
		refs = "0023 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
		altNames = "?fin$0@?0???__C@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 80 7D 20 00 75 19 4C 8B 8D 88 00 00 00 4C 8B 45 28 48 8B 55 70 48 8B 4D 60 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "_RTC_InitBase"
		size = 32
		refs = "0006 ?init@?1??_RTC_InitBase@@9@4_NA 0017 _RTC_SetErrorFuncW"
	strings:
		$1 = { 48 83 EC 28 80 3D ?? ?? ?? ?? 00 75 0E 33 C9 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_2_0 {
	meta:
		name = "__scrt_initialize_default_local_stdio_options"
		size = 27
		refs = "0005 __local_stdio_printf_options 000e __local_stdio_scanf_options"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 83 08 04 E8 ?? ?? ?? ?? 48 83 08 02 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__sse2_powf4"
		size = 1200
		refs = "0010 __common_spow_data 00dd _2il0floatpacket_128 04a1 __common_spow_cout_rare"
	strings:
		$1 = { 48 81 EC A8 01 00 00 0F 28 D0 0F 12 D0 48 8D 15 ?? ?? ?? ?? 44 0F 29 9C 24 90 01 00 00 0F 28 D9 0F 29 BC 24 70 01 00 00 0F 5A F8 44 0F 5A DA 0F 5A D1 44 0F 29 BC 24 00 01 00 00 44 0F 29 B4 24 10 01 00 00 44 0F 29 AC 24 20 01 00 00 44 0F 29 A4 24 30 01 00 00 44 0F 29 94 24 40 01 00 00 44 0F 29 8C 24 50 01 00 00 44 0F 29 84 24 60 01 00 00 0F 29 B4 24 80 01 00 00 4C 89 AC 24 A0 01 00 00 4C 8D 6C 24 6F 44 0F 28 2D ?? ?? ?? ?? 49 83 E5 C0 45 0F 28 FD 45 0F 54 EB 0F 28 25 ?? ?? ?? ?? 44 0F 54 FF 44 0F 56 FC 44 0F 56 EC 66 41 0F 5A EF 66 45 0F 5A CD 0F 16 ED 66 0F 73 D7 14 45 0F 16 C9 66 41 0F 73 D3 14 44 0F 53 C5 45 0F 53 D1 41 0F 5A E0 41 0F 5A EA 44 0F 28 25 ?? ?? ?? ?? 66 41 0F 58 E4 66 41 0F 58 EC 66 41 0F 5C E4 66 41 0F 5C EC 66 44 0F 59 FC 66 44 0F 59 ED 44 0F 28 CC 44 0F 28 D5 66 41 0F 73 D1 28 66 41 0F 73 D2 28 66 41 0F 70 F1 02 41 0F C6 FB DD 44 0F 28 1D ?? ?? ?? ?? 66 0F 7E F1 0F 28 35 ?? ?? ?? ?? 0F 12 D9 66 45 0F 5C FB 66 45 0F 5C EB F3 44 0F E6 E7 0F 5A DB 66 45 0F 7E D0 66 44 0F 7E C8 66 45 0F 70 DA 02 44 0F 28 D6 66 0F 70 FF EE 66 44 0F C2 D4 01 66 0F C2 F5 01 F3 0F E6 FF 66 45 0F 7E D9 44 0F 28 1D ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 45 0F 54 D3 41 0F 54 F3 44 0F 56 D4 0F 56 F4 45 0F 28 DF 66 45 0F 5C E2 66 0F 5C FE 66 45 0F 59 DF 0F 28 2D ?? ?? ?? ?? 41 0F 28 F5 66 44 0F 59 E5 66 0F 59 FD 66 41 0F 59 F5 0F 28 2D ?? ?? ?? ?? 0F 28 E5 66 41 0F 59 E7 66 41 0F 59 ED 44 0F 28 15 ?? ?? ?? ?? 66 41 0F 58 E2 66 41 0F 58 EA 66 41 0F 59 E3 66 0F 59 EE 66 44 0F 58 FC 66 44 0F 58 ED 48 63 C0 4D 63 C0 48 63 C9 4D 63 C9 F2 44 0F 10 84 10 80 A1 BF FF F2 45 0F 10 8C 10 80 A1 BF FF 66 44 0F 16 84 11 80 A1 BF FF 66 45 0F 16 8C 11 80 A1 BF FF 66 45 0F 58 F8 66 45 0F 58 E9 66 45 0F 58 FC 66 44 0F 58 EF 66 44 0F 59 FA 66 44 0F 59 EB 44 0F 28 0D ?? ?? ?? ?? 45 0F 28 D1 66 45 0F 59 D7 66 45 0F 59 CD 0F 28 15 ?? ?? ?? ?? 45 0F 28 C2 41 0F 28 F9 66 44 0F 5C C2 66 0F 5C FA 0F 28 1D ?? ?? ?? ?? 66 44 0F 58 C3 66 0F 58 FB 45 0F 28 E0 44 0F 28 DF 0F 29 44 24 20 66 0F FA 05 ?? ?? ?? ?? 66 44 0F 5C E3 66 44 0F 5C DB 66 45 0F 5C D4 66 45 0F 5C CB 66 44 0F 6F 35 ?? ?? ?? ?? 66 0F 6F D0 45 0F C6 FD DD 66 44 0F DB F1 66 44 0F 6F 2D ?? ?? ?? ?? 66 41 0F 66 D5 66 41 0F 76 C5 66 0F EB D0 66 45 0F 6F EE 66 0F 6F 05 ?? ?? ?? ?? 66 44 0F 66 E8 66 44 0F 76 F0 66 44 0F DB 3D ?? ?? ?? ?? 66 45 0F EB EE 66 44 0F 66 3D ?? ?? ?? ?? 66 41 0F EB D5 0F 28 05 ?? ?? ?? ?? 66 41 0F EB D7 45 0F 28 F8 66 41 0F 73 D0 0B 44 0F 54 F8 0F 54 C7 66 45 0F 7E FA 66 0F 73 D7 0B 66 0F 7E C1 66 41 0F 73 F0 34 44 0F 28 35 ?? ?? ?? ?? 66 0F 73 F7 34 66 45 0F C5 DF 04 66 44 0F C5 C0 04 66 45 0F 59 D6 66 45 0F 59 CE 0F 50 C2 41 C1 E2 03 C1 E1 03 41 C1 E3 03 41 C1 E0 03 85 C0 F3 41 0F 7E 94 12 00 36 00 00 F3 0F 7E 9C 11 00 36 00 00 66 41 0F 16 94 13 00 36 00 00 66 41 0F 16 9C 10 00 36 00 00 66 44 0F 59 D2 66 44 0F 59 CB 66 44 0F 58 D2 66 44 0F 58 CB 66 45 0F D4 D0 66 44 0F D4 CF 66 41 0F 5A C2 66 41 0F 5A E1 0F 16 C4 75 68 0F 28 B4 24 80 01 00 00 0F 28 BC 24 70 01 00 00 44 0F 28 84 24 60 01 00 00 44 0F 28 8C 24 50 01 00 00 44 0F 28 94 24 40 01 00 00 44 0F 28 9C 24 90 01 00 00 44 0F 28 A4 24 30 01 00 00 44 0F 28 AC 24 20 01 00 00 44 0F 28 B4 24 10 01 00 00 44 0F 28 BC 24 00 01 00 00 4C 8B AC 24 A0 01 00 00 48 81 C4 A8 01 00 00 C3 0F 28 54 24 20 41 0F 29 55 00 41 0F 29 4D 40 41 0F 29 85 80 00 00 00 0F 84 7B FF FF FF 33 D2 48 89 5C 24 28 8B DA 48 89 74 24 20 8B F0 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 1E FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 85 80 00 00 00 E9 3D FF FF FF 49 8D 4C 9D 00 49 8D 54 9D 40 4D 8D 84 9D 80 00 00 00 E8 ?? ?? ?? ?? EB C9 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__security_check_cookie"
		size = 33
		refs = "0003 __security_cookie 001d __report_gsfailure"
	strings:
		$1 = { 48 3B 0D ?? ?? ?? ?? F2 75 12 48 C1 C1 10 66 F7 C1 FF FF F2 75 02 F2 C3 48 C1 C9 10 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "__common_sexp_cout_rare"
		size = 608
		refs = "002a _2il0floatpacket_46 003f _2il0floatpacket_47 004d _2il0floatpacket_49 0065 _2il0floatpacket_50 0095 _2il0floatpacket_51 00a7 _2il0floatpacket_52 00af _2il0floatpacket_54 00bf _2il0floatpacket_53 00cb _2il0floatpacket_55 00db _2il0floatpacket_56 00e2 _2il0floatpacket_58 00ee _2il0floatpacket_57 017f _2il0floatpacket_61 01d5 _2il0floatpacket_60 01ee _2il0floatpacket_59 0210 _2il0floatpacket_48"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 41 81 F8 80 7F 00 00 0F 84 0F 02 00 00 F3 0F 10 01 45 33 C0 F3 0F 10 0D ?? ?? ?? ?? 44 89 44 24 2C 0F 2F C8 0F 82 D0 01 00 00 0F 2F 05 ?? ?? ?? ?? 0F 82 A1 01 00 00 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 F3 0F 11 4C 24 20 F3 0F 10 54 24 20 F3 0F 10 1D ?? ?? ?? ?? F3 0F 58 D3 F3 0F 11 54 24 24 0F 28 D0 F3 0F 10 64 24 24 44 8B 44 24 24 F3 0F 5C E3 F3 0F 11 64 24 20 F3 0F 10 6C 24 20 F3 0F 59 2D ?? ?? ?? ?? F3 0F 10 4C 24 20 F3 0F 5C D5 F3 0F 59 0D ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? F3 0F 5C D1 F3 0F 59 E2 F3 0F 10 1D ?? ?? ?? ?? 41 C1 E0 10 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E2 41 C1 F8 10 F3 0F 58 25 ?? ?? ?? ?? 0F 2F 05 ?? ?? ?? ?? F3 0F 59 E2 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E2 F3 0F 58 E3 F3 0F 59 E2 F3 0F 58 E3 F3 0F 11 64 24 28 0F 82 88 00 00 00 41 8D 48 7F 81 F9 FE 00 00 00 77 2A 0F B6 C9 C1 E1 07 66 89 4C 24 2E F3 0F 10 44 24 28 F3 0F 59 44 24 2C F3 0F 11 44 24 28 44 8B 44 24 28 44 89 02 48 83 C4 38 C3 41 83 C0 7E 45 0F B6 C0 0F B7 4C 24 2E 41 C1 E0 07 81 E1 7F 80 FF FF 41 0B C8 F3 0F 10 44 24 28 66 89 4C 24 2E F3 0F 59 44 24 2C F3 0F 11 44 24 28 F3 0F 10 4C 24 28 F3 0F 59 0D ?? ?? ?? ?? F3 0F 11 4C 24 28 44 8B 4C 24 28 44 89 0A 48 83 C4 38 C3 41 83 C0 BB 45 0F B6 C0 0F B7 44 24 2E 41 C1 E0 07 25 7F 80 FF FF 41 0B C0 F3 0F 10 44 24 28 66 89 44 24 2E B8 04 00 00 00 F3 0F 59 44 24 2C F3 0F 11 44 24 28 F3 0F 10 4C 24 28 F3 0F 59 0D ?? ?? ?? ?? F3 0F 11 4C 24 28 8B 4C 24 28 89 0A 48 83 C4 38 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 F3 0F 11 44 24 28 8B 44 24 28 89 02 B8 04 00 00 00 48 83 C4 38 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 F3 0F 11 44 24 28 8B 44 24 28 89 02 B8 03 00 00 00 48 83 C4 38 C3 44 8A 41 03 41 80 E0 80 41 80 F8 80 74 11 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 48 83 C4 38 C3 F7 01 FF FF 7F 00 75 E7 33 C9 89 0A 48 83 C4 38 C3 66 90 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "__vdecl_floor2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_floor2 000e __sse2_floor2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__vdecl_ceil2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_ceil2 000e __sse2_ceil2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__vdecl_ceilf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_ceilf4 000e __sse2_ceilf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "__vdecl_exp2"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_exp2 000e __sse2_exp2"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__vdecl_expf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_expf4 000e __sse2_expf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "__vdecl_floorf4"
		size = 18
		refs = "0002 __isa_available 0009 __sse4_floorf4 000e __sse2_floorf4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 02 0F 8D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__static_scalar_sin"
		size = 1264
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 81 04 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 E0 00 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 E0 00 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 01 0F 8C 89 02 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 1F 41 F7 C1 00 00 00 10 0F 85 93 02 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 F4 01 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E 1C 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 94 24 D0 00 00 00 F3 41 0F 7E B4 24 D8 00 00 00 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1D F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F1 8B C7 F2 0F 58 F3 F3 0F 7E D0 F2 0F 58 C6 F2 0F 5C D0 F2 0F 58 F2 F3 41 0F 7E 4C 24 70 F2 0F 59 C8 F3 41 0F 7E 94 24 80 00 00 00 F2 0F 2D D1 F2 0F 58 CA F3 41 0F 7E 5C 24 50 F2 0F 5C CA 66 41 0F 28 54 24 40 F2 0F 59 D9 66 0F 14 C9 C1 E0 03 81 C2 00 76 1C 00 F3 0F 7E E0 03 D0 83 E2 3F 66 41 0F 28 6C 24 30 49 8D 84 24 90 01 00 00 C1 E2 05 48 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 41 0F 59 4C 24 60 F2 0F 5C E3 F3 0F 7E 78 08 66 0F 14 C0 F3 0F 7E DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F3 0F 7E 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 5C CE 66 41 0F 28 74 24 10 F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 41 0F 58 6C 24 20 F2 0F 59 20 66 41 0F 58 34 24 66 0F 59 E8 F3 0F 7E C3 F2 0F 58 58 08 66 0F 59 CF F3 0F 7E FC F2 0F 58 E3 66 0F 58 F5 F3 0F 7E 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F3 0F 7E C4 F2 0F 58 CE F2 0F 58 C1 E9 13 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 F2 FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 DF FD FF FF 66 0F 57 C0 66 0F 57 F6 E9 87 FE FF FF 0F 84 FA FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 DD FD FF FF F7 D9 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 03 E9 7C FD FF FF 41 D3 E9 BB 00 00 00 20 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 20 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 37 FD FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 03 81 C7 00 00 00 20 E9 F3 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_29_1_0 {
	meta:
		name = "__sse2_sin2"
		size = 1216
		refs = "001f MMDPI1 002b MMDINVPI 0033 MMIABSMASK 003b MMDPI2 0043 MMDPI3 004b MMDRSHIFT 005f MMDHUGE 0073 MMDPI4 00a8 MMDA8 00b0 MMDA7 00cc MMDA6 00d4 MMDA5 00e4 MMDA4 00ec MMDA3 00fc MMDA2 0104 MMDA1 014f flAllOnes 015d MMISIGNMASK 0177 TWO_POW_30 01f8 THE_PI02_INV 020d MMI_ONE 0215 MSK_LOW_BIT 021d RS 0231 PI02C_0 023d PI02C_1 024d PI02C_2 027e PI02C_3 02aa PI02C_4"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 D0 66 0F 59 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 C9 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 70 FF F5 66 0F 29 7C 24 30 66 0F 57 3D ?? ?? ?? ?? 66 0F 29 7C 24 40 66 0F 28 3D ?? ?? ?? ?? 66 0F 54 FA 66 0F 29 54 24 50 66 0F 54 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 66 CA 66 0F 50 D1 66 0F 29 7C 24 60 66 0F 29 54 24 70 83 F2 03 0F 85 E0 01 00 00 83 F8 03 74 57 66 0F 28 54 24 50 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 54 5C 24 40 66 0F 5C D7 66 0F 54 54 24 40 66 0F 29 9C 24 80 00 00 00 66 0F 29 94 24 90 00 00 00 66 0F 28 54 24 70 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 73 F3 3E 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F DB 1D ?? ?? ?? ?? 66 0F 58 D1 66 0F 57 5C 24 60 83 F8 03 74 1E 66 0F 54 54 24 30 66 0F 56 94 24 90 00 00 00 66 0F 54 5C 24 30 66 0F 56 9C 24 80 00 00 00 66 0F 28 CA 66 0F 59 D2 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 E9 EA 00 00 00 89 44 24 20 83 F8 03 0F 84 C0 00 00 00 66 0F 28 54 24 50 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4B D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 44 24 58 89 44 24 20 E8 87 F6 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB BB F2 0F 10 44 24 50 E8 6D F6 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 9B 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "__avx_atanf8"
		size = 208
		refs = "000e __common_satan_data"
	strings:
		$1 = { 48 83 EC 48 C5 7C 11 7C 24 20 C5 FC 10 2D ?? ?? ?? ?? C5 FC 10 15 ?? ?? ?? ?? C5 7C 54 3D ?? ?? ?? ?? C5 FC 54 CD C5 84 C2 C2 12 C4 C1 6C 5F DF C4 C1 6C 5D D7 C5 EC 5E D3 C5 FC 55 25 ?? ?? ?? ?? C5 FC 55 DD C5 DC 57 E1 C5 E4 57 C9 C5 F4 57 DA C5 E4 59 D3 C5 EC 59 CA C5 F4 59 2D ?? ?? ?? ?? C5 74 59 3D ?? ?? ?? ?? C5 D4 58 05 ?? ?? ?? ?? C5 84 58 2D ?? ?? ?? ?? C5 7C 59 F9 C5 D4 59 E9 C5 04 58 3D ?? ?? ?? ?? C5 D4 58 05 ?? ?? ?? ?? C5 84 59 E9 C5 FC 59 C9 C5 D4 58 2D ?? ?? ?? ?? C5 F4 58 0D ?? ?? ?? ?? C5 D4 59 EA C5 D4 58 C1 C5 FC 59 D2 C5 6C 58 3D ?? ?? ?? ?? C5 84 59 DB C5 7C 10 7C 24 20 C5 E4 58 C4 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__common_stan_cout_rare"
		size = 112
	strings:
		$1 = { 48 83 EC 28 33 C0 44 8B 01 44 0F B7 49 02 44 89 44 24 20 41 81 E1 80 7F 00 00 41 C1 E8 18 41 83 E0 7F F3 0F 10 09 41 81 F9 80 7F 00 00 44 88 44 24 23 74 05 48 83 C4 28 C3 81 7C 24 20 00 00 80 7F 75 16 B8 01 00 00 00 66 0F EF C0 F3 0F 59 C8 F3 0F 11 0A 48 83 C4 28 C3 F3 0F 59 C9 F3 0F 11 0A 48 83 C4 28 C3 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_RTC_Initialize"
		size = 74
		refs = "0012 __rtc_iaa 0019 __rtc_izz 002b _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8D 1D ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? EB 16 48 8B 3B 48 85 FF 74 0A 48 8B CF E8 ?? ?? ?? ?? FF D7 48 83 C3 08 48 3B DE 72 E5 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "_RTC_Terminate"
		size = 74
		refs = "0012 __rtc_taa 0019 __rtc_tzz 002b _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8D 1D ?? ?? ?? ?? 48 8D 35 ?? ?? ?? ?? EB 16 48 8B 3B 48 85 FF 74 0A 48 8B CF E8 ?? ?? ?? ?? FF D7 48 83 C3 08 48 3B DE 72 E5 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__sse2_asinf4"
		size = 432
		refs = "0036 __common_sasin_data 01a1 __common_sasin_cout_rare"
	strings:
		$1 = { 48 81 EC F8 00 00 00 44 0F 29 BC 24 E0 00 00 00 44 0F 29 A4 24 D0 00 00 00 44 0F 29 94 24 C0 00 00 00 44 0F 28 D0 4C 89 AC 24 F0 00 00 00 4C 8D 6C 24 6F 0F 28 2D ?? ?? ?? ?? 49 83 E5 C0 44 0F 28 FD 41 0F 55 EA 45 0F 54 FA 44 0F 28 25 ?? ?? ?? ?? 41 0F 28 D7 41 0F 59 D4 41 0F 28 DC 0F 28 0D ?? ?? ?? ?? 41 0F 28 E7 41 0F C2 CF 02 41 0F 59 E7 0F 5C DA 0F 50 D1 41 0F 28 D7 0F 28 05 ?? ?? ?? ?? 41 0F C2 D4 05 0F 5D E3 44 0F 52 E3 0F 59 C4 0F 58 DB 41 0F 28 CC 85 D2 41 0F 59 CC 0F 58 05 ?? ?? ?? ?? 44 0F 59 E3 0F 59 D9 0F 28 0D ?? ?? ?? ?? 0F 5C 1D ?? ?? ?? ?? 0F 59 CB 41 0F 59 DC 0F 58 0D ?? ?? ?? ?? 0F 59 CB 0F 28 DC 0F 59 DC 41 0F 5C CC 0F 59 C3 44 0F 28 25 ?? ?? ?? ?? 0F 54 CA 44 0F 59 E4 44 0F 58 25 ?? ?? ?? ?? 41 0F 58 C4 0F 59 C4 0F 58 05 ?? ?? ?? ?? 0F 59 C4 0F 28 E2 41 0F 55 E7 0F 56 E1 0F 59 C4 44 0F 28 3D ?? ?? ?? ?? 0F 58 C4 44 0F 54 FA 41 0F 58 C7 66 0F EF C5 75 2B 44 0F 28 94 24 C0 00 00 00 44 0F 28 A4 24 D0 00 00 00 44 0F 28 BC 24 E0 00 00 00 4C 8B AC 24 F0 00 00 00 48 81 C4 F8 00 00 00 C3 45 0F 29 55 00 41 0F 29 45 40 74 C9 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 EB 91 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "__scrt_fastfail"
		size = 325
		refs = "001d IsProcessorFeaturePresent 002b __scrt_debugger_hook_flag 003d memset 0047 __imp_RtlCaptureContext 0061 __imp_RtlLookupFunctionEntry 00a2 __imp_RtlVirtualUnwind 00f6 __imp_IsDebuggerPresent 0117 __imp_SetUnhandledExceptionFilter 0122 __imp_UnhandledExceptionFilter"
	strings:
		$1 = { 48 89 5C 24 08 55 48 8D AC 24 40 FB FF FF 48 81 EC C0 05 00 00 8B D9 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 04 8B CB CD 29 83 25 ?? ?? ?? ?? 00 48 8D 4D F0 33 D2 41 B8 D0 04 00 00 E8 ?? ?? ?? ?? 48 8D 4D F0 FF 15 ?? ?? ?? ?? 48 8B 9D E8 00 00 00 48 8D 95 D8 04 00 00 48 8B CB 45 33 C0 FF 15 ?? ?? ?? ?? 48 85 C0 74 3C 48 83 64 24 38 00 48 8D 8D E0 04 00 00 48 8B 95 D8 04 00 00 4C 8B C8 48 89 4C 24 30 4C 8B C3 48 8D 8D E8 04 00 00 48 89 4C 24 28 48 8D 4D F0 48 89 4C 24 20 33 C9 FF 15 ?? ?? ?? ?? 48 8B 85 C8 04 00 00 48 8D 4C 24 50 48 89 85 E8 00 00 00 33 D2 48 8D 85 C8 04 00 00 41 B8 98 00 00 00 48 83 C0 08 48 89 85 88 00 00 00 E8 ?? ?? ?? ?? 48 8B 85 C8 04 00 00 48 89 44 24 60 C7 44 24 50 15 00 00 40 C7 44 24 54 01 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 01 48 8D 44 24 50 48 89 44 24 40 48 8D 45 F0 0F 94 C3 48 89 44 24 48 33 C9 FF 15 ?? ?? ?? ?? 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 75 0A F6 DB 1B C0 21 05 ?? ?? ?? ?? 48 8B 9C 24 D0 05 00 00 48 81 C4 C0 05 00 00 5D C3 }
	condition:
		$1
}

rule file_38_2_0 {
	meta:
		name = "__scrt_get_show_window_mode"
		size = 60
		refs = "0013 memset 001e __imp_GetStartupInfoW"
	strings:
		$1 = { 48 81 EC 98 00 00 00 33 D2 48 8D 4C 24 20 44 8D 42 68 E8 ?? ?? ?? ?? 48 8D 4C 24 20 FF 15 ?? ?? ?? ?? F6 44 24 5C 01 B8 0A 00 00 00 0F B7 4C 24 60 0F 45 C1 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_38_4_0 {
	meta:
		name = "__scrt_is_managed_app"
		size = 84
		refs = "0008 __imp_GetModuleHandleW"
	strings:
		$1 = { 48 83 EC 28 33 C9 FF 15 ?? ?? ?? ?? 48 8B C8 48 85 C0 75 04 32 C0 EB 37 B8 4D 5A 00 00 66 39 01 75 F2 48 63 41 3C 48 03 C1 81 38 50 45 00 00 75 E3 B9 0B 02 00 00 66 39 48 18 75 D8 83 B8 84 00 00 00 0E 76 CF 83 B8 F8 00 00 00 00 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_6_0 {
	meta:
		name = "__scrt_unhandled_exception_filter"
		size = 56
		refs = "0033 terminate"
	strings:
		$1 = { 48 83 EC 28 48 8B 01 81 38 63 73 6D E0 75 1C 83 78 18 04 75 16 8B 48 20 8D 81 E0 FA 6C E6 83 F8 02 76 0F 81 F9 00 40 99 01 74 07 33 C0 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "__avx_tanh4"
		size = 832
		refs = "000a __common_dtanh_data 0334 __common_dtanh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 D0 00 00 00 C5 7C 11 B4 24 F0 01 00 00 C5 7C 11 AC 24 D0 01 00 00 C4 41 09 EF F6 C5 7C 11 A4 24 B0 01 00 00 C5 7C 11 9C 24 90 01 00 00 C5 7C 11 94 24 70 01 00 00 C5 7C 11 8C 24 50 01 00 00 C5 7C 11 84 24 30 01 00 00 C5 FC 11 BC 24 10 01 00 00 C5 FC 11 B4 24 F0 00 00 00 4C 89 AC 24 10 02 00 00 4C 8D 6C 24 6F 49 83 E5 C0 C4 C1 7D 11 45 20 C5 78 10 15 ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 FD 54 0D ?? ?? ?? ?? C5 7D 54 0D ?? ?? ?? ?? C4 E3 7D 19 C5 01 C5 F8 C6 E5 DD C5 59 DB 2D ?? ?? ?? ?? C5 91 FA 05 ?? ?? ?? ?? C4 41 61 66 C5 C4 41 79 66 FE C4 C1 79 66 E2 C4 C1 79 DB EF C4 43 51 4A D2 40 C5 91 66 15 ?? ?? ?? ?? C4 C1 61 72 D2 0A C4 41 69 EB E0 C5 F9 7E D9 C4 41 78 50 C4 C4 E3 79 16 D8 01 48 63 C9 48 63 C0 C4 C3 79 16 D9 02 C4 C3 79 16 DA 03 4D 63 C9 4D 63 D2 C5 F9 10 14 11 C5 79 10 1C 10 C5 79 10 64 10 10 C5 F9 10 44 10 20 C5 79 10 44 11 10 C5 79 10 7C 11 20 C5 F9 10 5C 11 30 C4 C3 6D 18 34 11 01 C4 43 25 18 14 12 01 C5 F9 10 54 10 30 C4 41 4D 15 D2 C5 F9 10 74 11 40 C4 43 3D 18 6C 11 10 01 C4 C3 05 18 6C 11 20 01 C4 43 65 18 5C 11 30 01 C4 43 1D 18 74 12 10 01 C4 C3 7D 18 64 12 20 01 C4 C3 6D 18 7C 12 30 01 C5 79 10 44 10 40 C4 41 15 14 E6 C4 41 15 15 EE C5 55 14 F4 C5 55 15 FC C5 A5 14 C7 C5 A5 15 EF C5 79 10 5C 11 50 C5 F9 10 7C 10 50 C4 C3 3D 18 54 12 40 01 C4 43 25 18 44 11 50 01 C4 C3 4D 18 5C 11 40 01 C5 E5 14 E2 C5 E5 15 DA C5 F9 10 74 11 60 C4 43 45 18 5C 12 50 01 C4 C1 3D 14 D3 C4 41 3D 15 DB C5 79 10 44 10 60 C4 C3 4D 18 74 11 60 01 C4 43 3D 18 44 12 60 01 C4 C1 4D 14 F8 C5 75 58 C7 C4 C1 25 59 C8 C5 F5 58 CA C4 C1 75 59 D0 C5 ED 58 DB C4 C1 65 59 F0 C5 CD 58 E4 C4 C1 5D 59 F8 C5 C5 58 ED C4 41 55 59 D8 C5 A5 58 C0 C4 C1 7D 59 C0 C4 41 7D 58 FF C4 C1 05 59 C0 C4 41 7D 58 F6 C4 C1 0D 59 C0 C4 41 7D 58 ED C4 C1 15 59 C0 C4 41 7D 58 E4 C4 41 1D 59 C0 C4 41 3D 58 D2 C4 C1 2D 56 C1 45 85 C0 75 6A C5 FC 10 B4 24 F0 00 00 00 C5 FC 10 BC 24 10 01 00 00 C5 7C 10 84 24 30 01 00 00 C5 7C 10 8C 24 50 01 00 00 C5 7C 10 94 24 70 01 00 00 C5 7C 10 9C 24 90 01 00 00 C5 7C 10 A4 24 B0 01 00 00 C5 7C 10 AC 24 D0 01 00 00 C5 7C 10 B4 24 F0 01 00 00 C5 7C 10 BC 24 D0 00 00 00 4C 8B AC 24 10 02 00 00 48 81 C4 18 02 00 00 C3 C4 C1 7D 10 4D 20 C4 C1 7D 11 45 40 C4 C1 7D 11 4D 00 74 82 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 41 8B F0 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 45 40 E9 50 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "_RTC_Check_2_to_1"
		size = 47
		refs = "0023 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F BF D9 B9 00 FF 00 00 8B C3 23 C1 74 13 3B C1 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8A C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "_RTC_Check_4_to_1"
		size = 50
		refs = "0026 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B C1 8B D9 25 00 FF FF FF 05 00 01 00 00 A9 FF FE FF FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8A C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "_RTC_Check_4_to_2"
		size = 51
		refs = "0026 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B C1 8B D9 25 00 00 FF FF 05 00 00 01 00 A9 FF FF FE FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_40_3_0 {
	meta:
		name = "_RTC_Check_8_to_1"
		size = 55
		refs = "002b ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 25 00 FF FF FF 48 05 00 01 00 00 48 A9 FF FE FF FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8A C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_40_4_0 {
	meta:
		name = "_RTC_Check_8_to_2"
		size = 56
		refs = "002b ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 25 00 00 FF FF 48 05 00 00 01 00 48 A9 FF FF FE FF 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_40_5_0 {
	meta:
		name = "_RTC_Check_8_to_4"
		size = 76
		refs = "0040 ?_RTC_Failure@@YAXPEAXH@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C1 48 8B D9 48 B9 00 00 00 00 FF FF FF FF 48 23 C1 48 B9 00 00 00 00 01 00 00 00 48 03 C1 48 B9 FF FF FF FF FE FF FF FF 48 85 C1 74 0F 48 8B 4C 24 28 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__sse4_ceilf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 02 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__common_datan_cout_rare"
		size = 1568
		refs = "0051 _vmldAtanHATab"
	strings:
		$1 = { 48 83 EC 78 44 0F B7 41 06 41 81 E0 F0 7F 00 00 41 C1 E8 04 44 0F 29 5C 24 50 41 81 F8 FF 07 00 00 0F 29 74 24 60 0F 84 9B 05 00 00 4C 8B 09 4C 89 4C 24 48 49 C1 E9 38 8A 41 07 41 83 E1 7F 44 88 4C 24 4F F2 0F 10 44 24 48 C0 E8 07 66 0F 2F 05 ?? ?? ?? ?? 4C 8B 4C 24 48 0F 82 45 04 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 00 04 00 00 4C 89 4C 24 20 44 0F 28 D8 44 8B 4C 24 24 45 8B D1 41 81 E1 00 00 08 00 41 81 E2 00 00 F0 FF 41 81 C9 00 00 04 00 4C 8D 1D ?? ?? ?? ?? 45 0B D1 C7 44 24 20 00 00 00 00 44 89 54 24 24 F2 0F 10 0D ?? ?? ?? ?? 0F 28 E1 F2 44 0F 5C 5C 24 20 C0 E0 07 F2 41 0F 59 E3 8B 49 04 F2 0F 11 64 24 28 81 E1 FF FF 0F 00 F2 0F 10 54 24 28 41 C1 E0 14 F2 41 0F 5C D3 F2 0F 11 54 24 30 44 0B C1 F2 0F 10 5C 24 28 41 81 C0 00 00 40 C0 F2 0F 10 6C 24 30 41 C1 F8 12 F2 0F 5C DD F2 0F 11 5C 24 28 0F 28 E8 F2 0F 10 74 24 28 41 83 E0 FE F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 5C DE F2 44 0F 11 5C 24 30 F2 0F 10 5C 24 28 F2 0F 10 64 24 30 F2 0F 11 6C 24 28 F2 0F 10 74 24 28 4D 63 C0 F2 0F 5C 74 24 48 F2 0F 11 74 24 30 F2 0F 10 6C 24 28 F2 0F 10 54 24 30 F2 0F 5C EA F2 0F 11 6C 24 28 F2 0F 10 74 24 28 F2 0F 5C C6 F2 0F 11 44 24 30 F2 44 0F 10 5C 24 28 F2 0F 10 44 24 20 F2 0F 10 54 24 30 F2 44 0F 59 D8 F2 0F 59 D0 41 0F 28 EB F2 0F 58 EA F2 0F 11 6C 24 28 F2 0F 10 74 24 28 F2 44 0F 5C DE F2 41 0F 58 D3 F2 0F 11 54 24 30 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 44 24 28 0F 28 F2 F2 0F 10 6C 24 30 F2 0F 58 F0 F2 0F 11 74 24 28 0F 28 F2 F2 44 0F 10 5C 24 28 F2 41 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 74 24 28 F2 44 0F 10 5C 24 30 F2 41 0F 58 F3 F2 0F 11 74 24 38 0F 28 F2 F2 44 0F 10 5C 24 30 F2 41 0F 58 C3 F2 0F 11 44 24 30 F2 0F 10 44 24 38 F2 0F 5C F0 F2 0F 11 74 24 38 F2 0F 10 74 24 30 F2 44 0F 10 5C 24 38 F2 41 0F 58 F3 F2 0F 11 74 24 38 F2 44 0F 10 5C 24 28 F2 0F 10 44 24 38 F2 0F 58 C5 41 0F 28 EB F2 0F 59 E9 F2 0F 11 6C 24 28 F2 0F 10 74 24 28 F2 41 0F 5C F3 F2 0F 11 74 24 30 F2 0F 10 74 24 28 F2 0F 10 6C 24 30 F2 0F 5C F5 F2 0F 11 74 24 28 F2 0F 10 6C 24 28 F2 44 0F 5C DD F2 44 0F 11 5C 24 30 F2 0F 10 74 24 28 F2 0F 10 6C 24 30 F2 0F 58 E8 0F 28 C2 F2 0F 5E C6 F2 0F 59 C8 F2 0F 11 4C 24 30 F2 0F 10 4C 24 30 F2 0F 5C C8 F2 0F 11 4C 24 38 F2 0F 10 44 24 30 F2 44 0F 10 5C 24 38 F2 41 0F 5C C3 F2 0F 11 44 24 38 F2 0F 10 4C 24 38 F2 0F 59 F1 F2 0F 5C D6 F2 0F 10 74 24 38 F2 0F 59 EE F2 0F 11 6C 24 30 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 30 F2 44 0F 10 5C 24 30 F2 0F 10 74 24 38 F2 0F 10 54 24 30 F2 0F 10 6C 24 38 F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DA F2 44 0F 59 DD 0F 28 EE F2 0F 59 F4 F2 0F 59 EB F2 41 0F 59 DB 41 0F 28 C3 F2 0F 59 C4 F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 58 C6 F2 43 0F 10 14 C3 F2 0F 58 C3 F2 0F 11 44 24 28 0F 28 DD F2 0F 10 74 24 28 0F 28 C2 F2 0F 58 DE F2 0F 11 5C 24 28 F2 0F 10 64 24 28 F2 0F 5C EC F2 0F 58 EE F2 0F 11 6C 24 30 F2 0F 10 5C 24 28 0F 28 EB F2 0F 58 C3 F2 0F 59 EB F2 44 0F 59 DD F2 0F 10 74 24 30 F2 0F 11 44 24 28 F2 0F 10 4C 24 28 F2 44 0F 58 1D ?? ?? ?? ?? F2 0F 5C D1 F2 44 0F 59 DD F2 0F 58 D3 F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 0F 11 54 24 30 F2 0F 10 44 24 28 F2 0F 10 64 24 30 F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 44 0F 58 1D ?? ?? ?? ?? F2 44 0F 59 DD F2 41 0F 59 DB F2 0F 58 DE F2 43 0F 58 5C C3 08 F2 0F 58 DC F2 0F 58 C3 F2 0F 11 44 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 E9 43 01 00 00 F2 0F 10 05 ?? ?? ?? ?? C0 E0 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 E9 10 01 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 83 00 00 00 0F 28 C8 F2 0F 59 C8 C0 E0 07 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 D0 F2 0F 11 54 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 EB 7F 0F B7 4C 24 4E F7 C1 F0 7F 00 00 74 3E F2 0F 10 0D ?? ?? ?? ?? C0 E0 07 F2 0F 58 C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 0F 59 44 24 48 F2 0F 11 44 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 EB 34 F2 0F 59 C0 C0 E0 07 F2 0F 11 44 24 28 F2 0F 10 44 24 28 F2 0F 58 44 24 48 F2 0F 11 44 24 40 8A 4C 24 47 80 E1 7F 0A C8 88 4C 24 47 48 8B 44 24 40 48 89 02 0F 28 74 24 60 33 C0 44 0F 28 5C 24 50 48 83 C4 78 C3 F7 41 04 FF FF 0F 00 75 37 83 39 00 75 32 F2 0F 10 05 ?? ?? ?? ?? 8A 49 07 80 E1 80 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 40 8A 44 24 47 24 7F 0A C1 88 44 24 47 4C 8B 44 24 40 4C 89 02 EB AE F2 0F 10 01 F2 0F 58 C0 F2 0F 11 02 EB A0 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__avx_tanhf8"
		size = 768
		refs = "000f __common_stanh_data 02ec __common_stanh_cout_rare"
	strings:
		$1 = { 57 41 56 41 57 48 81 EC 10 02 00 00 4C 8D 1D ?? ?? ?? ?? C5 7C 11 BC 24 E0 01 00 00 C5 7C 11 B4 24 40 01 00 00 C5 7C 11 A4 24 C0 01 00 00 C5 7C 11 9C 24 A0 01 00 00 C5 7C 11 94 24 80 01 00 00 C5 7C 11 8C 24 60 01 00 00 4C 89 AC 24 00 02 00 00 4C 8D AC 24 DF 00 00 00 C5 7C 54 0D ?? ?? ?? ?? 49 83 E5 C0 C5 7C 54 15 ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 F8 10 0D ?? ?? ?? ?? C5 78 10 25 ?? ?? ?? ?? C5 78 10 3D ?? ?? ?? ?? C5 79 DB DC C4 E3 7D 19 C5 01 C5 A1 66 D1 C5 D1 DB EC C5 D1 66 D9 C5 D9 EF E4 C5 E9 6B CB C4 C1 21 FA D4 C5 71 63 F4 C4 C1 69 66 DF C4 C1 79 D7 FE C4 41 51 FA F4 C5 69 66 E4 C5 89 66 E4 C4 C1 69 DB EC C5 09 DB DC C4 C1 09 66 CF C4 43 51 4A E7 30 C4 43 21 4A FF 10 C4 C1 09 72 D4 0E C4 C1 19 72 D7 0E C4 41 79 7E F7 C5 79 7E E1 C4 43 79 16 F2 01 C4 63 79 16 E2 01 4D 63 FF 4D 63 D2 C4 43 79 16 F1 02 C4 43 79 16 F0 03 48 63 C9 C4 63 79 16 E0 02 48 63 D2 C4 43 79 16 E6 03 4D 63 C9 4D 63 C0 48 63 C0 4D 63 F6 C4 01 79 10 3C 1F C4 81 79 10 2C 1A C4 A1 79 10 1C 19 C4 21 79 10 1C 1A C4 83 05 18 24 19 01 C4 83 55 18 14 18 01 C5 5D 14 F2 C5 DD 15 E2 C4 81 79 10 54 1F 10 C4 A3 65 18 0C 18 01 C4 81 79 10 5C 1A 10 C4 03 25 18 3C 1E 01 C4 41 75 14 E7 C4 C1 75 15 EF C4 21 79 10 7C 19 10 C4 83 65 18 4C 18 10 01 C4 A1 79 10 5C 1A 10 C4 03 6D 18 5C 19 10 01 C5 A5 14 D1 C5 A5 15 C9 C4 23 05 18 7C 18 10 01 C4 03 65 18 5C 1E 10 01 C4 C1 05 14 DB C4 41 05 15 DB C4 41 7C 5A F9 C4 43 7D 19 C9 01 C4 C1 75 59 CF C4 41 7C 5A C9 C5 F5 58 D2 C4 C1 25 59 C9 C4 C1 6D 59 D7 C5 F5 58 DB C5 ED 58 CC C4 C1 65 59 E1 C5 DD 58 D5 C4 C1 75 59 EF C4 41 6D 59 D9 C4 41 55 58 F6 C4 41 25 58 FC C4 41 7D 5A E6 C4 C1 7D 5A CF C4 E3 1D 18 D1 01 C4 C1 6C 56 CA 40 84 FF 75 4F C5 7C 10 8C 24 60 01 00 00 C5 7C 10 94 24 80 01 00 00 C5 7C 10 9C 24 A0 01 00 00 C5 7C 10 A4 24 C0 01 00 00 C5 7C 10 B4 24 40 01 00 00 C5 7C 10 BC 24 E0 01 00 00 4C 8B AC 24 00 02 00 00 C5 FC 28 C1 48 81 C4 10 02 00 00 41 5F 41 5E 5F C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 FF 74 A1 C5 FC 11 B4 24 80 00 00 00 45 33 F6 C5 FC 11 7C 24 60 C5 7C 11 44 24 40 C5 7C 11 6C 24 20 44 0F A3 F7 72 2F 41 FF C6 41 83 FE 20 7C F1 C5 FC 10 B4 24 80 00 00 00 C5 FC 10 7C 24 60 C5 7C 10 44 24 40 C5 7C 10 6C 24 20 C4 C1 7C 10 4D 40 E9 4E FF FF FF C5 F8 77 4B 8D 4C B5 00 4B 8D 54 B5 40 E8 ?? ?? ?? ?? EB BD 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__guard_check_icall_thunk"
		size = 33
		refs = "0011 __guard_check_icall_fptr"
	strings:
		$1 = { 48 50 51 52 41 50 41 51 48 83 EC 20 48 8B C8 FF 15 ?? ?? ?? ?? 48 83 C4 20 41 59 41 58 5A 59 58 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "__vdecl_fmod4"
		size = 107
		refs = "0011 fmod"
	strings:
		$1 = { 48 83 EC 68 C5 FE 7F 44 24 20 C5 FE 7F 4C 24 40 E8 ?? ?? ?? ?? 66 0F D6 44 24 20 F3 0F 7E 44 24 28 F3 0F 7E 4C 24 48 E8 ?? ?? ?? ?? 66 0F D6 44 24 28 F3 0F 7E 44 24 30 F3 0F 7E 4C 24 50 E8 ?? ?? ?? ?? 66 0F D6 44 24 30 F3 0F 7E 44 24 38 F3 0F 7E 4C 24 58 E8 ?? ?? ?? ?? 66 0F D6 44 24 38 C5 FE 6F 44 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "__raise_securityfailure"
		size = 52
		refs = "000d __imp_SetUnhandledExceptionFilter 0016 __imp_UnhandledExceptionFilter 001c __imp_GetCurrentProcess 0030 __imp_TerminateProcess"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 33 C9 FF 15 ?? ?? ?? ?? 48 8B CB FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 BA 09 04 00 C0 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "__report_gsfailure"
		size = 209
		refs = "000f IsProcessorFeaturePresent 0021 GS_ContextRecord 0026 capture_previous_context 0050 GS_ExceptionRecord 00a2 __security_cookie 00b7 __security_cookie_complement 00c3 GS_ExceptionPointers 00c8 __raise_securityfailure"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 07 B9 02 00 00 00 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 89 05 ?? ?? ?? ?? 48 8D 44 24 38 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 44 24 40 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 48 C7 04 01 02 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8B 0D ?? ?? ?? ?? 48 89 4C 04 20 B8 08 00 00 00 48 6B C0 01 48 8B 0D ?? ?? ?? ?? 48 89 4C 04 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_65_2_0 {
	meta:
		name = "__report_rangecheckfailure"
		size = 19
		refs = "000a __report_securityfailure"
	strings:
		$1 = { 48 83 EC 28 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_65_3_0 {
	meta:
		name = "__report_securityfailure"
		size = 155
		refs = "000e IsProcessorFeaturePresent 0021 GS_ContextRecord 0026 capture_current_context 0050 GS_ExceptionRecord 008d GS_ExceptionPointers 0092 __raise_securityfailure"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 08 8B 44 24 30 8B C8 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 28 48 89 05 ?? ?? ?? ?? 48 8D 44 24 28 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 8B 54 24 30 48 89 14 01 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_65_4_0 {
	meta:
		name = "__report_securityfailureEx"
		size = 270
		refs = "0017 IsProcessorFeaturePresent 002a GS_ContextRecord 002f capture_current_context 0059 GS_ExceptionRecord 0100 GS_ExceptionPointers 0105 __raise_securityfailure"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 89 4C 24 08 48 83 EC 38 B9 17 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 08 8B 44 24 40 8B C8 CD 29 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 44 24 38 48 89 05 ?? ?? ?? ?? 48 8D 44 24 38 48 83 C0 08 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 83 7C 24 48 00 76 10 48 83 7C 24 50 00 75 08 C7 44 24 48 00 00 00 00 83 7C 24 48 0E 76 0A 8B 44 24 48 FF C8 89 44 24 48 8B 44 24 48 FF C0 89 05 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 8B 54 24 40 48 89 14 01 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 8B 44 24 48 39 44 24 20 73 22 8B 44 24 20 8B 4C 24 20 FF C1 8B C9 48 8D 15 ?? ?? ?? ?? 4C 8B 44 24 50 49 8B 04 C0 48 89 04 CA EB CA 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_65_5_0 {
	meta:
		name = "capture_current_context"
		size = 109
		refs = "000f __imp_RtlCaptureContext 0027 __imp_RtlLookupFunctionEntry 005e __imp_RtlVirtualUnwind"
	strings:
		$1 = { 48 89 5C 24 20 57 48 83 EC 40 48 8B D9 FF 15 ?? ?? ?? ?? 48 8B BB F8 00 00 00 48 8D 54 24 50 48 8B CF 45 33 C0 FF 15 ?? ?? ?? ?? 48 85 C0 74 32 48 83 64 24 38 00 48 8D 4C 24 58 48 8B 54 24 50 4C 8B C8 48 89 4C 24 30 4C 8B C7 48 8D 4C 24 60 48 89 4C 24 28 33 C9 48 89 5C 24 20 FF 15 ?? ?? ?? ?? 48 8B 5C 24 68 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_65_6_0 {
	meta:
		name = "capture_previous_context"
		size = 113
		refs = "000d __imp_RtlCaptureContext 0027 __imp_RtlLookupFunctionEntry 005e __imp_RtlVirtualUnwind"
	strings:
		$1 = { 40 53 56 57 48 83 EC 40 48 8B D9 FF 15 ?? ?? ?? ?? 48 8B B3 F8 00 00 00 33 FF 45 33 C0 48 8D 54 24 60 48 8B CE FF 15 ?? ?? ?? ?? 48 85 C0 74 39 48 83 64 24 38 00 48 8D 4C 24 68 48 8B 54 24 60 4C 8B C8 48 89 4C 24 30 4C 8B C6 48 8D 4C 24 70 48 89 4C 24 28 33 C9 48 89 5C 24 20 FF 15 ?? ?? ?? ?? FF C7 83 FF 02 7C B1 48 83 C4 40 5F 5E 5B C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__avx_ceil4"
		size = 16
	strings:
		$1 = { C4 E3 7D 09 C0 02 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "__sse2_ceilf4"
		size = 96
		refs = "0015 s_dw7f800000_1933_0_1 0029 s_dw4affffff_1933_0_1 0049 s_dwbf800000_1933_0_1"
	strings:
		$1 = { 66 0F 6F C8 F3 0F 5B D0 66 0F 72 E1 1F 66 0F 6F D8 66 0F DB 05 ?? ?? ?? ?? 0F 5B D2 66 0F 6F E9 66 0F 72 F1 1F 66 0F 66 05 ?? ?? ?? ?? 66 0F EB D1 66 0F 6F E3 66 0F DB D8 66 0F DF C2 66 0F EB C3 66 0F 76 E0 66 0F DF 25 ?? ?? ?? ?? 66 0F DF EC 0F 5C C5 C3 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__sse2_floorf4"
		size = 80
		refs = "0006 _2il0floatpacket_4 0010 _2il0floatpacket_5 0037 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 E0 0F 28 0D ?? ?? ?? ?? 0F 28 E8 0F 28 1D ?? ?? ?? ?? 0F 54 E1 0F 55 C8 0F 28 D3 0F C2 D1 01 0F 58 CB 0F 54 C2 0F 5C CB 0F 56 CC 0F 28 DA 0F C2 E9 01 0F 54 2D ?? ?? ?? ?? 0F 5C CD 0F 55 D9 0F 56 C3 C3 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "__avx_asin4"
		size = 656
		refs = "0048 __common_dasin_data 0287 __common_dasin_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 F0 01 00 00 C5 7C 11 94 24 90 01 00 00 C5 7C 11 8C 24 B0 01 00 00 C5 7C 11 84 24 70 01 00 00 C5 FC 11 B4 24 D0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 10 2D ?? ?? ?? ?? 49 83 E5 C0 C5 7D 10 0D ?? ?? ?? ?? C5 55 54 D0 C4 41 2D 59 F9 C5 AD C2 25 ?? ?? ?? ?? 1D C4 41 35 5C FF C4 41 2D C2 C9 15 C4 C1 7D 5A DF C5 55 55 C0 C4 C1 2D 59 EA C4 C1 55 5D EF C4 41 05 58 FF C4 E3 7D 19 E1 01 C5 D8 C6 D1 DD C5 F8 52 E3 C5 F8 50 D2 C5 FC 5A F4 C5 CD 59 CE C5 85 59 F6 C5 85 59 D1 C5 ED 5C 25 ?? ?? ?? ?? C5 DD 59 1D ?? ?? ?? ?? C5 4D 59 FC C5 E5 58 0D ?? ?? ?? ?? C5 F5 59 D4 C5 D5 59 0D ?? ?? ?? ?? C5 ED 58 1D ?? ?? ?? ?? C5 F5 58 0D ?? ?? ?? ?? C5 D5 59 15 ?? ?? ?? ?? C5 E5 59 E4 C5 ED 58 15 ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C4 41 5D 59 FF C5 D5 59 25 ?? ?? ?? ?? C5 05 5C FE C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 1D ?? ?? ?? ?? C5 DD 58 35 ?? ?? ?? ?? C5 D5 59 E5 C5 E5 59 DC C5 E5 58 DE C5 F5 59 F4 C5 CD 58 CA C5 DD 59 D4 C5 D5 59 35 ?? ?? ?? ?? C5 E5 59 D2 C5 CD 58 35 ?? ?? ?? ?? C5 ED 58 C9 C5 F5 59 DC C5 D5 59 0D ?? ?? ?? ?? C5 E5 58 D6 C5 F5 58 1D ?? ?? ?? ?? C5 ED 59 E4 C5 DD 58 CB C5 F5 59 ED C4 C3 2D 4B CF 90 C5 55 59 D1 C5 AD 58 D1 C5 35 54 0D ?? ?? ?? ?? C4 C1 6D 58 C9 C4 C1 75 57 C8 85 D2 75 41 C5 FC 10 B4 24 D0 01 00 00 C5 7C 10 84 24 70 01 00 00 C5 7C 10 8C 24 B0 01 00 00 C5 7C 10 94 24 90 01 00 00 C5 7C 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 B1 33 C0 C5 FC 11 BC 24 A0 00 00 00 C5 7C 11 9C 24 80 00 00 00 C5 7C 11 64 24 60 C5 7C 11 6C 24 40 C5 7C 11 74 24 20 48 89 9C 24 C8 00 00 00 8B D8 48 89 B4 24 C0 00 00 00 8B F2 0F A3 DE 72 46 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 A0 00 00 00 C5 7C 10 9C 24 80 00 00 00 C5 7C 10 64 24 60 C5 7C 10 6C 24 40 C5 7C 10 74 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 C8 00 00 00 48 8B B4 24 C0 00 00 00 E9 2C FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB A6 0F 1F 00 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__avx_pow4"
		size = 1216
		refs = "000a __common_dpow_data 04b2 __common_dpow_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 B0 01 00 00 C5 7C 11 B4 24 90 01 00 00 C5 7C 11 AC 24 70 01 00 00 C5 7C 11 A4 24 50 01 00 00 C5 7C 11 9C 24 30 01 00 00 C5 7C 11 94 24 10 01 00 00 C5 7C 11 8C 24 D0 01 00 00 C5 7C 11 84 24 30 02 00 00 C5 FC 11 BC 24 10 02 00 00 C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 50 02 00 00 4C 8D 6C 24 6F C5 78 10 3D ?? ?? ?? ?? 49 83 E5 C0 C5 F8 10 1D ?? ?? ?? ?? C4 E3 7D 19 C5 01 C5 F8 C6 ED DD C5 50 54 15 ?? ?? ?? ?? C5 29 FE 25 ?? ?? ?? ?? C4 C1 21 72 D4 0A C4 C1 41 72 F3 03 C4 C1 49 72 F3 04 C5 F9 7E F8 C4 C1 79 7E F2 48 63 C0 C4 E3 79 16 F9 01 48 63 C9 C4 C3 79 16 F3 01 C5 7B 10 0C 10 4D 63 D2 4D 63 DB C5 31 16 34 11 C4 E3 79 16 F0 02 C4 E3 79 16 F1 03 C4 C3 79 16 F8 02 48 63 C0 48 63 C9 4D 63 C0 C4 C3 79 16 F9 03 4D 63 C9 C4 41 79 10 9C 12 40 20 00 00 C4 41 79 10 8C 13 40 20 00 00 C5 7D 54 2D ?? ?? ?? ?? C5 15 56 05 ?? ?? ?? ?? C4 41 7B 10 2C 10 C4 41 11 16 14 11 C4 E3 25 18 B4 10 40 20 00 00 01 C4 E3 35 18 BC 11 40 20 00 00 01 C5 4D 14 DF C5 4D 15 CF C5 D1 FA 35 ?? ?? ?? ?? C5 91 72 E6 14 C5 D1 FE 2D ?? ?? ?? ?? C4 43 0D 18 E2 01 C5 11 FE 35 ?? ?? ?? ?? C4 41 79 70 D6 50 C4 C1 79 70 FE FA C4 E3 2D 18 F7 01 C5 4D 54 2D ?? ?? ?? ?? C5 FD 10 35 ?? ?? ?? ?? C4 C1 3D 59 FC C5 15 5C 15 ?? ?? ?? ?? C5 3D 54 F6 C4 41 3D 5C EE C5 45 58 05 ?? ?? ?? ?? C4 41 2D 58 DB C4 41 0D 59 F4 C4 41 15 59 E4 C4 41 25 58 D0 C5 8D 5C FF C5 1D 58 E7 C4 C1 25 5C FA C4 41 2D 58 EC C4 C1 45 58 F8 C4 41 2D 5C DD C4 41 25 58 F4 C5 0D 58 D7 C4 41 3D 58 F4 C4 C1 2D 58 F9 C5 0D 59 05 ?? ?? ?? ?? C5 3D 58 15 ?? ?? ?? ?? C4 41 2D 59 DE C5 25 58 25 ?? ?? ?? ?? C4 41 1D 59 C6 C5 3D 58 0D ?? ?? ?? ?? C4 41 35 59 D6 C5 2D 58 1D ?? ?? ?? ?? C4 41 25 59 E6 C5 1D 58 05 ?? ?? ?? ?? C4 41 3D 59 F6 C5 8D 58 FF C5 15 58 D7 C4 41 2D 5C ED C4 C1 45 5C FD C5 2D 54 EE C4 41 2D 5C E5 C5 75 54 DE C4 C1 25 59 F5 C4 41 75 5C D3 C4 41 25 59 DC C4 41 2D 59 F4 C4 41 2D 59 D5 C4 41 25 58 E6 C4 E3 7D 19 CC 01 C5 F0 C6 D4 DD C4 C1 69 DB D7 C5 F8 10 25 ?? ?? ?? ?? C5 D9 66 E5 C4 C3 7D 19 F0 01 C4 41 48 C6 C8 DD C4 41 31 DB C7 C5 69 66 FB C5 E9 76 DB C5 81 EB EB C5 D9 EB DD C5 FD 10 25 ?? ?? ?? ?? C5 78 10 0D ?? ?? ?? ?? C4 41 39 66 F9 C4 C1 39 76 D1 C5 01 EB C2 C4 41 61 EB C8 C5 CD 58 D4 C4 41 2D 58 FC C4 C1 78 50 C1 C5 F5 59 EF C4 E3 7D 19 D7 01 C5 E8 C6 FF 88 C5 40 54 2D ?? ?? ?? ?? C5 B9 72 F7 0D C4 C1 61 72 F5 04 C4 C1 79 7E D8 C5 ED 5C D4 C5 39 FE 15 ?? ?? ?? ?? C4 41 79 70 CA 50 C4 C3 79 16 DA 02 4D 63 C0 C4 C3 79 16 D9 01 4D 63 D2 C4 E3 79 16 D9 03 4D 63 C9 48 63 C9 C5 CD 5C D2 C5 85 58 F5 C4 41 7B 10 AC 10 80 60 00 00 C4 41 79 70 DA FA C4 41 7B 10 84 12 80 60 00 00 C5 4D 58 D2 C4 41 11 16 B4 11 80 60 00 00 C5 B9 16 9C 11 80 60 00 00 C4 43 35 18 E3 01 C5 9D 54 3D ?? ?? ?? ?? C4 E3 0D 18 DB 01 C5 45 59 FB C5 AD 59 3D ?? ?? ?? ?? C4 41 05 59 EA C5 C5 58 25 ?? ?? ?? ?? C4 C1 5D 59 EA C5 D5 58 35 ?? ?? ?? ?? C4 41 4D 59 C2 C5 3D 58 0D ?? ?? ?? ?? C4 41 35 59 DA C5 25 58 25 ?? ?? ?? ?? C4 41 1D 59 F5 C4 C1 0D 58 D7 85 C0 75 6E C5 FC 10 B4 24 F0 01 00 00 C5 FC 10 BC 24 10 02 00 00 C5 7C 10 84 24 30 02 00 00 C5 7C 10 8C 24 D0 01 00 00 C5 7C 10 94 24 10 01 00 00 C5 7C 10 9C 24 30 01 00 00 C5 7C 10 A4 24 50 01 00 00 C5 7C 10 AC 24 70 01 00 00 C5 7C 10 B4 24 90 01 00 00 C5 7C 10 BC 24 B0 01 00 00 4C 8B AC 24 50 02 00 00 C5 FD 28 C2 48 81 C4 58 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 C4 C1 7D 11 95 80 00 00 00 0F 84 77 FF FF FF 33 D2 48 89 5C 24 28 8B DA 48 89 74 24 20 8B F0 0F A3 DE 72 1F FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 95 80 00 00 00 E9 43 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 4D 8D 84 DD 80 00 00 00 E8 ?? ?? ?? ?? EB C5 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_77_1_0 {
	meta:
		name = "??_Gtype_info@@UEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7type_info@@6B@ 001e ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 18 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "__common_dexp_cout_rare"
		size = 880
		refs = "0016 _imldExpHATab"
	strings:
		$1 = { 55 48 83 EC 70 33 C0 4C 8B 01 4C 89 44 24 60 49 C1 E8 30 4C 8B 0D ?? ?? ?? ?? 41 81 E0 F0 7F 00 00 41 C1 E8 04 F2 0F 10 09 41 81 F8 FF 07 00 00 0F 84 02 03 00 00 41 81 F8 CA 03 00 00 0F 8E DF 02 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C1 0F 82 B2 02 00 00 66 0F 2F 0D ?? ?? ?? ?? 0F 82 89 02 00 00 F2 0F 10 05 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 0F 59 C1 F2 0F 11 44 24 50 F2 0F 10 54 24 50 F2 0F 10 05 ?? ?? ?? ?? 4C 89 4C 24 60 F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 54 24 58 0F 28 D1 F2 0F 10 5C 24 58 8B 4C 24 58 44 8B C1 83 E1 3F F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 50 44 8D 14 09 F2 0F 10 64 24 50 8D 4C 09 01 F2 0F 59 25 ?? ?? ?? ?? F2 0F 10 6C 24 50 F2 0F 5C D4 F2 0F 59 2D ?? ?? ?? ?? F2 0F 5C D5 F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 41 C1 E8 06 F2 0F 58 05 ?? ?? ?? ?? 66 0F 2F 0D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 41 8D A8 FF 03 00 00 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 C2 F2 0F 58 C2 F2 43 0F 10 14 D3 F2 41 0F 58 04 CB F2 0F 59 C2 72 76 81 E5 FF 07 00 00 F2 0F 58 C2 81 FD FE 07 00 00 77 2B 49 C1 E9 30 C1 E5 04 41 81 E1 0F 80 FF FF 44 0B CD 66 44 89 4C 24 66 F2 0F 10 4C 24 60 F2 0F 59 C1 F2 0F 11 02 48 83 C4 70 5D C3 FF CD 81 E5 FF 07 00 00 0F B7 4C 24 66 C1 E5 04 81 E1 0F 80 FF FF 0B CD 66 89 4C 24 66 F2 0F 10 4C 24 60 F2 0F 59 C1 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 02 48 83 C4 70 5D C3 41 81 C0 3B 04 00 00 41 81 E0 FF 07 00 00 41 8B C0 0F B7 4C 24 66 C1 E0 04 81 E1 0F 80 FF FF 0B C8 66 89 4C 24 66 41 83 F8 32 F2 0F 10 5C 24 60 F2 0F 59 C3 F2 0F 59 DA 0F 28 CB F2 0F 58 C8 77 11 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 0A E9 CE 00 00 00 F2 0F 11 4C 24 20 F2 0F 10 4C 24 20 F2 0F 5C D9 F2 0F 11 5C 24 28 F2 0F 10 54 24 28 F2 0F 58 C2 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 30 F2 0F 10 64 24 20 F2 0F 10 5C 24 30 F2 0F 58 E3 F2 0F 11 64 24 38 F2 0F 10 44 24 38 F2 0F 10 6C 24 30 F2 0F 5C C5 F2 0F 11 44 24 40 F2 0F 10 54 24 20 F2 0F 10 4C 24 40 F2 0F 5C D1 F2 0F 11 54 24 48 F2 0F 10 5C 24 28 F2 0F 10 64 24 48 F2 0F 58 E3 F2 0F 11 64 24 48 F2 0F 10 44 24 40 F2 0F 59 05 ?? ?? ?? ?? F2 0F 11 44 24 40 F2 0F 10 4C 24 48 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 48 F2 0F 10 54 24 40 F2 0F 10 6C 24 48 F2 0F 58 D5 F2 0F 11 12 B8 04 00 00 00 48 83 C4 70 5D C3 F2 0F 10 05 ?? ?? ?? ?? B8 04 00 00 00 F2 0F 59 C0 F2 0F 11 02 48 83 C4 70 5D C3 F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C0 F2 0F 11 02 48 83 C4 70 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 11 02 48 83 C4 70 5D C3 8A 4C 24 67 80 E1 80 80 F9 80 74 0E F2 0F 59 C9 F2 0F 11 0A 48 83 C4 70 5D C3 F7 44 24 64 FF FF 0F 00 75 E8 83 7C 24 60 00 75 E1 4C 89 0A 48 83 C4 70 5D C3 0F 1F 40 00 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__common_scosh_cout_rare"
		size = 1072
		refs = "0030 _vmldCoshHATab"
	strings:
		$1 = { 48 81 EC 88 00 00 00 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 44 0F 29 5C 24 70 41 81 F8 80 7F 00 00 44 0F 29 44 24 50 0F 29 7C 24 60 4C 8B 0D ?? ?? ?? ?? 0F 84 E7 03 00 00 F3 0F 5A 01 F2 0F 11 44 24 40 80 64 24 47 7F 0F B7 4C 24 46 81 E1 F0 7F 00 00 81 F9 90 3C 00 00 0F 8E 92 03 00 00 F2 44 0F 10 5C 24 40 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C3 0F 86 5D 03 00 00 4C 89 4C 24 40 66 44 0F 2F 1D ?? ?? ?? ?? 0F 82 5B 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 41 0F 59 C3 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 20 F2 0F 10 4C 24 20 44 8B 44 24 20 41 8B C8 83 E1 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 28 44 8D 14 09 F2 0F 10 54 24 28 8D 4C 09 01 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 28 F2 44 0F 5C DA F2 0F 59 1D ?? ?? ?? ?? F2 44 0F 5C DB F2 41 0F 59 E3 F2 43 0F 10 0C D3 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E3 41 C1 E8 06 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E3 41 81 C0 FF 03 00 00 41 FF C8 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E3 41 81 E0 FF 07 00 00 41 81 F8 FE 07 00 00 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E3 F2 41 0F 59 E3 F2 41 0F 58 E3 F2 0F 59 E1 F2 41 0F 58 24 CB F2 0F 58 CC 77 2F 49 C1 E9 30 41 C1 E0 04 41 81 E1 0F 80 FF FF 45 0B C8 66 44 89 4C 24 46 F2 0F 10 44 24 40 F2 0F 59 C1 F2 0F 5A C0 F3 0F 11 02 E9 5F 02 00 00 41 FF C8 41 81 E0 FF 07 00 00 0F B7 4C 24 46 41 C1 E0 04 81 E1 0F 80 FF FF 41 0B C8 66 89 4C 24 46 F2 0F 10 44 24 40 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5A C9 F3 0F 11 0A E9 1F 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? F2 41 0F 59 CB 44 0F B7 4C 24 46 41 81 E1 0F 80 FF FF F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 20 F2 0F 10 7C 24 20 44 8B 5C 24 20 45 8B D3 41 C1 EA 06 41 83 E3 3F 41 81 C2 FF 03 00 00 F2 0F 5C 3D ?? ?? ?? ?? F2 0F 11 7C 24 28 41 81 E2 FF 07 00 00 F2 44 0F 10 44 24 28 F2 44 0F 59 05 ?? ?? ?? ?? F2 0F 10 64 24 28 41 8D 4A FF F2 0F 59 25 ?? ?? ?? ?? F2 45 0F 5C D8 F2 44 0F 10 05 ?? ?? ?? ?? 81 E1 FF 07 00 00 C1 E1 04 41 F7 DA 44 0B C9 43 8D 0C 1B 41 83 C2 FC 41 81 E2 FF 07 00 00 F2 44 0F 5C DC 41 0F 28 EB F2 41 0F 59 EB F2 44 0F 59 C5 F2 41 0F 10 24 C8 F7 D9 F2 0F 10 3D ?? ?? ?? ?? 47 8D 44 1B 01 66 44 89 4C 24 46 41 81 E1 0F 80 FF FF 41 C1 E2 04 4C 8D 1D ?? ?? ?? ?? F2 0F 59 FD F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C5 45 0B CA F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 59 FD F2 44 0F 59 C5 F2 41 0F 59 FB F2 0F 10 4C 24 40 4D 8B D3 66 44 89 4C 24 46 44 8D 89 80 00 00 00 81 C1 81 00 00 00 F2 0F 10 44 24 40 F2 43 0F 10 2C C3 4D 8B C3 F2 0F 59 E1 F2 0F 59 E9 F2 43 0F 10 14 CA 0F 28 CC F2 0F 59 D0 F2 41 0F 10 1C C8 F2 0F 58 CA F2 0F 59 D8 F2 0F 11 4C 24 30 0F 28 CC F2 0F 10 44 24 30 F2 0F 5C E2 F2 0F 5C C8 F2 0F 59 FC F2 0F 58 CA 0F 28 D5 F2 0F 11 4C 24 38 F2 0F 5C D3 F2 41 0F 59 D3 F2 44 0F 59 DC F2 0F 58 D3 F2 0F 10 4C 24 30 F2 0F 58 D5 F2 44 0F 59 C1 F2 0F 10 44 24 38 F2 0F 58 D0 F2 0F 58 D7 F2 41 0F 58 D0 F2 41 0F 58 D3 F2 0F 11 54 24 30 F2 44 0F 10 5C 24 30 F2 41 0F 58 CB F2 0F 5A C9 F3 0F 11 0A EB 31 F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C0 F2 0F 5A C0 F3 0F 11 02 EB 16 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 44 24 40 F2 0F 5A C0 F3 0F 11 02 0F 28 7C 24 60 44 0F 28 44 24 50 44 0F 28 5C 24 70 48 81 C4 88 00 00 00 C3 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 EB D9 90 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__sse2_cosf4"
		size = 2240
		refs = "001d flAbsMask 0024 MMSPIo2 002f MMSINVPI 003c MMIHUGE 0049 MMSPI1 0054 MMSPI2 006d MMSPI4 0077 MMS05 007e MMSPI3 0099 MMSA9 00a9 MMSA5 00b0 MMSA3 00c3 MMSA7 010c flTwoPow30 012d flAllOnes 01b0 dbInvPio2 01c5 dbiOne 01cd dbRS 01ea PI02C_0 01f6 PI02C_1 0206 PI02C_2 0237 PI02C_3 0263 PI02C_4 0273 dbSignMask 0741 __spec_table"
	strings:
		$1 = { 48 81 EC 18 01 00 00 0F 29 BC 24 F0 00 00 00 0F 29 B4 24 00 01 00 00 0F 28 F0 0F 28 0D ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 66 0F DB C1 0F 28 25 ?? ?? ?? ?? 0F 28 D0 0F 28 F8 0F 28 2D ?? ?? ?? ?? 0F 58 C3 0F 59 C4 0F 28 25 ?? ?? ?? ?? 66 0F 66 FD 0F 28 2D ?? ?? ?? ?? 0F 50 C7 0B C0 0F 85 95 00 00 00 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 0F 28 B4 24 00 01 00 00 0F 28 BC 24 F0 00 00 00 48 81 C4 18 01 00 00 C3 66 0F DB 35 ?? ?? ?? ?? 0F 28 CE 0F 29 74 24 40 66 0F 66 35 ?? ?? ?? ?? 0F 50 D6 85 D2 0F 85 52 05 00 00 83 F8 0F 0F 84 F2 02 00 00 0F 29 7C 24 50 66 0F EF 3D ?? ?? ?? ?? 0F 29 7C 24 60 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 CA 0F 5C CF 0F 59 D2 66 0F DB 5C 24 60 66 0F DB 4C 24 60 66 0F DB 54 24 60 0F 29 5C 24 70 0F 29 8C 24 80 00 00 00 0F 29 94 24 90 00 00 00 0F 5A 4C 24 40 0F 5A 44 24 48 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D9 66 0F E6 DB 66 0F 70 DB DC 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 84 24 A0 00 00 00 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 28 9C 24 A0 00 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F E6 DB 66 0F 58 C1 66 0F 28 8C 24 A0 00 00 00 66 0F EF 2D ?? ?? ?? ?? 66 0F 70 ED DD 66 0F 70 DB DC 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 29 84 24 B0 00 00 00 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 AC 24 C0 00 00 00 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 58 C8 66 0F EF 2D ?? ?? ?? ?? 66 0F 5A 94 24 B0 00 00 00 66 0F 70 ED DD 66 0F 5A D9 66 0F 14 D3 F3 0F 7E 9C 24 C0 00 00 00 66 0F 14 DD 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 59 D2 66 0F DB 5C 24 50 66 0F DB 4C 24 50 66 0F DB 54 24 50 66 0F EB 5C 24 70 66 0F EB 8C 24 80 00 00 00 66 0F EB 94 24 90 00 00 00 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 E9 0B 03 00 00 66 0F 70 C1 EE 0F 5A C9 0F 5A C0 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D9 66 0F 59 F0 66 0F E6 DB 66 0F E6 F6 66 0F 70 DB DC 66 0F 70 F6 DC 66 0F EB 1D ?? ?? ?? ?? 66 0F EB 35 ?? ?? ?? ?? 66 0F 29 B4 24 D0 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 84 24 A0 00 00 00 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F DB EB 66 0F 58 C1 66 0F 28 8C 24 A0 00 00 00 66 0F EF 2D ?? ?? ?? ?? 66 0F 70 ED DD 66 0F 28 9C 24 D0 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 94 24 D0 00 00 00 66 0F 29 84 24 B0 00 00 00 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C2 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 AC 24 C0 00 00 00 66 0F 5C C8 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C1 66 0F 5C CC 66 0F 5C C1 66 0F 28 F1 66 0F 5C C4 66 0F 5C CD 66 0F 73 F3 3E 66 0F 5C F1 66 0F 28 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 C6 66 0F 58 C8 66 0F 59 E2 66 0F 5C F9 66 0F 28 E9 66 0F 5C CC 66 0F 58 C7 66 0F 5C E9 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 C5 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 5A 94 24 B0 00 00 00 66 0F DB EB 66 0F 58 C8 66 0F 5A D9 66 0F EF 2D ?? ?? ?? ?? 66 0F 14 D3 0F 28 05 ?? ?? ?? ?? 0F 28 CA 0F 59 D2 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 05 ?? ?? ?? ?? 66 0F 70 ED DD 0F 59 C2 F3 0F 7E 9C 24 C0 00 00 00 0F 59 C1 66 0F 14 DD 0F 58 C1 66 0F EF C3 E9 B4 00 00 00 83 F8 0F 0F 84 85 00 00 00 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 5C C1 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 CA 0F 5C CF 0F 59 D2 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 0F 29 84 24 E0 00 00 00 89 44 24 20 8B 44 24 20 45 33 C9 A8 01 75 2F 49 FF C1 D1 F8 89 44 24 20 49 83 F9 04 7C ED 0F 28 84 24 E0 00 00 00 0F 28 B4 24 00 01 00 00 0F 28 BC 24 F0 00 00 00 48 81 C4 18 01 00 00 C3 42 8B 44 8C 40 48 8D 15 ?? ?? ?? ?? 89 44 24 28 48 89 54 24 30 F3 0F 10 44 24 28 4C 8B 44 24 30 0F 28 C8 66 0F 7E C1 0F 5A C9 F2 41 0F 10 90 10 05 00 00 81 E1 FF FF FF 7F 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 0F 84 0E 01 00 00 C1 E9 17 81 E9 8E 00 00 00 81 E1 F8 FF 00 00 F2 41 0F 10 9C 48 10 04 00 00 F2 41 0F 10 AC 48 18 04 00 00 F2 41 0F 10 90 50 05 00 00 66 0F 57 E4 B8 38 43 00 00 66 0F C4 E0 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD F2 0F 10 C2 F2 0F 58 D3 F2 0F 10 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 D8 66 0F 7E D1 F2 0F 5C D4 F2 0F 58 CB B8 80 01 00 00 F2 41 0F 10 A0 40 05 00 00 F2 0F 5C EA 03 C9 8B D1 C1 E1 18 C1 F9 1F 23 C2 03 D1 33 D1 F2 0F 58 CD 81 E2 FE 00 00 00 F2 41 0F 10 1C D0 F2 41 0F 10 80 48 05 00 00 66 0F 70 D1 44 F2 0F 59 C9 F2 41 0F 10 6C D0 08 8B C8 81 E1 00 01 00 00 C1 E1 17 F2 0F 59 DA 66 0F 6E D1 F2 0F 5C C1 05 80 00 00 00 25 00 01 00 00 C1 E0 17 F2 0F 5C E1 66 0F 73 F2 20 66 0F 6E C8 66 0F 57 E2 F2 0F 59 C5 F2 0F 59 DC 66 0F 73 F1 20 66 0F 57 C1 F2 0F 58 C3 66 0F 5A C0 EB 04 F3 0F 5C C0 F3 0F 11 44 24 24 8B 44 24 24 42 89 84 8C E0 00 00 00 8B 44 24 20 E9 57 FE FF FF 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_87_1_0 {
	meta:
		name = "_guard_icall_checks_enforced"
		size = 23
		refs = "0003 __guard_check_icall_fptr 000a _guard_check_icall_nop"
	strings:
		$1 = { 48 8B 0D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 33 C0 48 3B CA 0F 95 C0 C3 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__common_scos_cout_rare"
		size = 112
		altNames = "__common_ssin_cout_rare"
	strings:
		$1 = { 48 83 EC 28 44 8B 01 0F B7 41 02 44 89 44 24 20 25 80 7F 00 00 41 C1 E8 18 41 83 E0 7F F3 0F 10 09 3D 80 7F 00 00 75 34 44 88 44 24 23 81 7C 24 20 00 00 80 7F 75 16 B8 01 00 00 00 66 0F EF C0 F3 0F 59 C8 F3 0F 11 0A 48 83 C4 28 C3 F3 0F 59 C9 33 C0 F3 0F 11 0A 48 83 C4 28 C3 33 C0 48 83 C4 28 C3 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__sse4_ceil2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 02 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__avx_acos4"
		size = 672
		refs = "0048 __common_dacos_data 0296 __common_dacos_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 D0 01 00 00 C5 7C 11 B4 24 90 01 00 00 C5 7C 11 84 24 70 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 0F 01 00 00 C5 7D 10 35 ?? ?? ?? ?? 49 83 E5 C0 C5 FD 10 2D ?? ?? ?? ?? C5 8D 56 F8 C5 45 59 FD C5 45 59 C7 C5 C5 C2 25 ?? ?? ?? ?? 12 C5 85 58 ED C5 FD 5A D5 C5 3D 5D C5 C5 F8 52 F2 C5 3D C2 FD 15 C5 D5 58 ED C5 0D 54 F0 C4 E3 7D 19 E1 01 C5 D8 C6 D9 DD C5 FC 5A E6 C5 F8 50 D3 C5 DD 59 CC C5 D5 59 F4 C5 D5 59 D9 C5 E5 5C 25 ?? ?? ?? ?? C5 DD 59 15 ?? ?? ?? ?? C5 CD 59 EC C5 ED 58 0D ?? ?? ?? ?? C5 F5 59 DC C5 BD 59 0D ?? ?? ?? ?? C5 E5 58 15 ?? ?? ?? ?? C5 F5 58 1D ?? ?? ?? ?? C5 ED 59 E4 C5 BD 59 15 ?? ?? ?? ?? C5 DD 58 25 ?? ?? ?? ?? C5 ED 58 0D ?? ?? ?? ?? C5 BD 59 15 ?? ?? ?? ?? C5 DD 59 ED C4 C1 3D 59 E0 C5 ED 58 15 ?? ?? ?? ?? C5 CD 5C ED C5 BD 59 35 ?? ?? ?? ?? C4 E3 45 4B FD F0 C5 CD 58 35 ?? ?? ?? ?? C5 CD 59 F4 C5 CD 58 DB C5 F5 59 F4 C5 CD 58 CA C5 DD 59 D4 C5 BD 59 35 ?? ?? ?? ?? C5 E5 59 DA C5 CD 58 35 ?? ?? ?? ?? C5 E5 58 C9 C5 F5 59 D4 C5 ED 58 DE C5 BD 59 35 ?? ?? ?? ?? C5 E5 59 E4 C5 CD 58 35 ?? ?? ?? ?? C5 DD 58 CE C4 C1 75 59 F0 C4 C1 7D C2 C8 11 C4 C1 45 57 EE C5 CD 59 F5 C5 05 54 05 ?? ?? ?? ?? C5 BD 54 D9 C5 85 55 15 ?? ?? ?? ?? C5 ED 58 E3 C5 CD 58 CD C5 DD 58 C9 85 D2 75 41 C5 FC 10 B4 24 F0 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 84 24 70 01 00 00 C5 7C 10 B4 24 90 01 00 00 C5 7C 10 BC 24 D0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 B1 33 C0 C5 7C 11 8C 24 A0 00 00 00 C5 7C 11 94 24 80 00 00 00 C5 7C 11 5C 24 60 C5 7C 11 64 24 40 C5 7C 11 6C 24 20 48 89 9C 24 C8 00 00 00 8B D8 48 89 B4 24 C0 00 00 00 8B F2 0F A3 DE 72 46 FF C3 83 FB 20 7C F4 C5 7C 10 8C 24 A0 00 00 00 C5 7C 10 94 24 80 00 00 00 C5 7C 10 5C 24 60 C5 7C 10 64 24 40 C5 7C 10 6C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 C8 00 00 00 48 8B B4 24 C0 00 00 00 E9 2C FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB A6 0F 1F 40 00 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__common_sasin_cout_rare"
		size = 2784
		refs = "007b _vmldASinHATab"
	strings:
		$1 = { 55 48 81 EC D0 00 00 00 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 F3 0F 10 09 41 81 F8 80 7F 00 00 44 0F 29 BC 24 A0 00 00 00 44 0F 29 B4 24 B0 00 00 00 44 0F 29 AC 24 C0 00 00 00 44 0F 29 5C 24 60 44 0F 29 54 24 70 44 0F 29 8C 24 80 00 00 00 44 0F 29 84 24 90 00 00 00 0F 84 63 0A 00 00 F3 0F 5A C1 F2 0F 11 44 24 38 80 64 24 3F 7F F2 44 0F 10 54 24 38 F2 44 0F 10 2D ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F EA 0F 82 DF 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C2 0F 86 27 04 00 00 66 44 0F 2F 15 ?? ?? ?? ?? 0F 86 85 03 00 00 F2 44 0F 10 35 ?? ?? ?? ?? 41 0F 28 E2 F2 41 0F 59 E6 45 0F 28 CA F2 0F 11 64 24 28 45 0F 28 DA F2 44 0F 10 6C 24 28 41 0F 28 DE F2 44 0F 5C 6C 24 38 F2 44 0F 11 6C 24 20 F2 44 0F 10 44 24 28 F2 0F 10 4C 24 20 F2 44 0F 5C C1 F2 44 0F 11 44 24 28 F2 0F 10 54 24 28 F2 44 0F 5C CA F2 44 0F 11 4C 24 20 F2 0F 10 6C 24 28 0F 28 D5 F2 44 0F 58 DD F2 0F 59 D5 F2 44 0F 10 7C 24 20 0F 28 C2 F2 45 0F 59 DF F2 0F 59 DA F2 41 0F 58 C3 F2 44 0F 10 0D ?? ?? ?? ?? F2 44 0F 59 C8 F2 0F 11 5C 24 28 F2 0F 10 64 24 28 F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 5C E2 F2 44 0F 59 C8 F2 0F 11 64 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 5C CD F2 44 0F 59 C8 F2 0F 11 4C 24 28 F2 44 0F 10 44 24 28 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 5C D0 F2 44 0F 59 C8 F2 0F 11 54 24 20 45 0F 28 C2 F2 0F 10 64 24 28 F2 0F 10 5C 24 20 F2 44 0F 59 FC F2 44 0F 58 0D ?? ?? ?? ?? F2 44 0F 58 DB F2 0F 59 EC F2 44 0F 59 C8 F2 45 0F 59 C3 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 58 C7 F2 44 0F 59 C8 45 0F 28 FE F2 44 0F 58 0D ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 59 C8 F2 44 0F 11 7C 24 28 F2 44 0F 10 6C 24 28 F2 44 0F 5C ED F2 44 0F 58 0D ?? ?? ?? ?? F2 44 0F 11 6C 24 20 44 0F 28 ED F2 0F 10 54 24 28 F2 41 0F 58 E8 F2 44 0F 59 C8 F2 44 0F 59 DD F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 10 4C 24 20 F2 44 0F 59 C8 F2 0F 5C D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 28 F2 44 0F 5C EB 0F 28 DC F2 44 0F 58 0D ?? ?? ?? ?? F2 44 0F 11 6C 24 20 F2 0F 10 4C 24 28 F2 0F 10 54 24 20 44 0F 28 FA F2 0F 59 D9 F2 45 0F 58 F8 F2 44 0F 59 C8 F2 41 0F 59 E7 F2 44 0F 59 F3 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 58 E3 F2 44 0F 59 C8 F2 44 0F 11 74 24 28 44 0F 28 EB F2 44 0F 10 5C 24 28 F2 44 0F 5C DB F2 0F 58 DC F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 59 C3 F2 44 0F 11 5C 24 20 F2 44 0F 10 5C 24 28 F2 44 0F 10 74 24 20 F2 44 0F 59 C8 F2 45 0F 5C DE F2 44 0F 11 5C 24 28 F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 59 DD F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 44 0F 58 D8 F2 0F 59 CD F2 44 0F 59 C5 F2 0F 59 D5 F2 45 0F 58 D9 F2 44 0F 10 74 24 28 41 0F 28 C2 F2 45 0F 5C EE F2 0F 58 C1 F2 45 0F 58 D8 F2 44 0F 11 6C 24 20 F2 44 0F 58 DA F2 44 0F 10 74 24 28 F2 44 0F 10 6C 24 20 F2 0F 11 44 24 28 F2 0F 10 54 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 5C D2 F2 0F 59 E0 F2 44 0F 59 F0 F2 41 0F 59 C5 F2 44 0F 58 D1 F2 44 0F 11 54 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 54 24 20 F2 45 0F 58 DA F2 44 0F 58 DC 0F 28 E1 F2 41 0F 58 E6 F2 44 0F 58 D8 F2 0F 11 64 24 28 F2 44 0F 10 54 24 28 F2 41 0F 5C CA F2 41 0F 58 CE F2 0F 11 4C 24 20 F2 0F 10 5C 24 28 F2 0F 10 54 24 20 8A 49 03 F2 44 0F 58 DA 80 E1 80 F2 44 0F 58 DB F2 44 0F 11 5C 24 30 40 8A 6C 24 37 40 80 E5 7F 40 0A E9 40 88 6C 24 37 F2 0F 5A 6C 24 30 F3 0F 11 2A E9 49 06 00 00 66 44 0F 2F 15 ?? ?? ?? ?? 72 44 F2 45 0F 58 D5 F2 44 0F 11 54 24 28 F2 0F 10 44 24 28 F2 0F 59 44 24 38 F2 0F 11 44 24 30 40 8A 6C 24 37 8A 49 03 40 80 E5 7F 80 E1 80 40 0A E9 40 88 6C 24 37 F2 0F 5A 4C 24 30 F3 0F 11 0A E9 FA 05 00 00 F2 45 0F 59 D2 F2 44 0F 11 54 24 28 F2 0F 10 44 24 28 8A 49 03 80 E1 80 F2 0F 58 44 24 38 F2 0F 11 44 24 30 40 8A 6C 24 37 40 80 E5 7F 40 0A E9 40 88 6C 24 37 F2 0F 5A 4C 24 30 F3 0F 11 0A E9 B6 05 00 00 4D 8B D1 F2 45 0F 5C EA F2 41 0F 59 C5 F2 0F 11 44 24 38 44 0F B7 44 24 3E 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B E8 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4C 24 40 45 0B D3 66 44 89 54 24 46 83 E5 01 F2 44 0F 10 44 24 40 44 8B DD F2 41 0F 59 C0 0F 28 E8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 E8 F2 44 0F 10 15 ?? ?? ?? ?? 75 03 0F 28 E8 F2 44 0F 59 D5 F2 0F 58 C2 F2 0F 11 44 24 48 45 0F 28 CA 44 8B 54 24 48 44 2B C5 41 C1 E3 08 41 81 E2 FF 01 00 00 45 03 D3 F2 44 0F 5C CD 4C 8D 1D ?? ?? ?? ?? F2 44 0F 11 4C 24 20 44 0F 28 CD F2 0F 10 5C 24 20 F2 44 0F 10 05 ?? ?? ?? ?? F2 44 0F 5C D3 F2 43 0F 10 04 D3 41 0F 28 CA 0F 28 E0 F2 45 0F 5C CA F2 0F 59 E0 F2 44 0F 59 D0 F2 0F 59 CC F2 41 0F 59 E1 F2 0F 5C 0D ?? ?? ?? ?? 41 D1 E8 F2 0F 58 CC F2 44 0F 59 C1 41 81 C0 FF 03 00 00 4C 89 4C 24 50 41 81 E0 FF 07 00 00 49 C1 E9 30 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 41 81 E1 0F 80 FF FF 41 C1 E0 04 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 45 0B C8 66 44 89 4C 24 56 F2 0F 10 5C 24 50 F2 44 0F 59 D3 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 F2 44 0F 10 35 ?? ?? ?? ?? F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 58 35 ?? ?? ?? ?? F2 44 0F 59 C1 F2 45 0F 59 F5 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 C1 F2 0F 10 0D ?? ?? ?? ?? F2 44 0F 59 C0 F2 41 0F 59 C1 F2 44 0F 59 C5 44 0F 28 C9 F2 44 0F 58 C0 F2 45 0F 59 CA F2 44 0F 59 C3 F2 44 0F 11 4C 24 28 F2 44 0F 10 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 0F 10 54 24 28 F2 0F 10 1D ?? ?? ?? ?? F2 41 0F 5C D2 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 0F 11 54 24 20 0F 28 D3 F2 0F 10 6C 24 28 F2 0F 10 64 24 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C EC F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 CD F2 41 0F 58 D6 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 59 D5 F2 45 0F 59 CD F2 0F 11 6C 24 28 0F 28 E9 F2 44 0F 10 5C 24 28 0F 28 E0 F2 41 0F 59 ED F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 5C D3 F2 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 CD F2 0F 58 E2 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 44 0F 11 54 24 20 F2 44 0F 10 54 24 28 F2 44 0F 10 7C 24 20 F2 0F 11 6C 24 28 F2 45 0F 58 C7 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 44 0F 10 5C 24 28 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 5C DD F2 45 0F 59 CD F2 44 0F 11 5C 24 20 44 0F 28 D9 F2 0F 10 54 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 58 0D ?? ?? ?? ?? F2 41 0F 5C D7 F2 45 0F 59 CD F2 0F 11 54 24 28 F2 44 0F 10 74 24 28 F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 CD F2 45 0F 59 CD F2 45 0F 59 CD F2 41 0F 58 E1 F2 44 0F 59 C4 41 0F 28 E5 F2 41 0F 5C E6 F2 0F 11 64 24 20 F2 44 0F 10 74 24 28 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E5 F2 44 0F 59 F3 F2 44 0F 59 DD F2 0F 10 54 24 20 F2 44 0F 11 5C 24 28 F2 44 0F 10 7C 24 28 F2 0F 59 E2 F2 44 0F 5C FD F2 0F 59 DA F2 44 0F 11 7C 24 20 F2 44 0F 10 7C 24 28 F2 44 0F 10 5C 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C FB F2 41 0F 59 D5 F2 44 0F 11 7C 24 28 45 0F 28 FE F2 44 0F 10 5C 24 28 F2 41 0F 5C EB F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6C 24 20 F2 44 0F 10 5C 24 28 F2 44 0F 59 1D ?? ?? ?? ?? F2 41 0F 59 D5 F2 45 0F 58 FB F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6C 24 20 F2 41 0F 58 D1 F2 0F 58 EC F2 41 0F 59 D2 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 28 F2 44 0F 11 5C 24 48 F2 45 0F 5C F7 F2 45 0F 58 F3 F2 44 0F 11 74 24 20 44 0F 28 F0 F2 44 0F 10 7C 24 28 F2 44 0F 10 5C 24 20 F2 45 0F 58 F7 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 28 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 44 24 20 F2 44 0F 10 74 24 28 F2 41 0F 59 CE F2 44 0F 10 7C 24 20 F2 0F 11 4C 24 28 F2 0F 10 4C 24 28 F2 41 0F 5C CE F2 0F 11 4C 24 20 F2 0F 10 4C 24 28 F2 0F 10 44 24 20 F2 0F 5C C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 44 0F 5C F0 F2 44 0F 11 74 24 20 F2 0F 10 44 24 28 F2 44 0F 10 74 24 20 F2 45 0F 58 F3 F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F2 F2 44 0F 59 D0 F2 45 0F 58 C6 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 58 C2 44 0F 28 E8 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C EA F2 41 0F 5C D0 F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 28 F2 41 0F 5C C5 F2 41 0F 5C C2 F2 0F 11 44 24 20 F2 0F 10 5C 24 28 F2 0F 10 4C 24 20 8A 49 03 F2 0F 58 D1 80 E1 80 F2 0F 58 DA F2 0F 11 5C 24 30 40 8A 6C 24 37 40 80 E5 7F 40 0A E9 40 88 6C 24 37 F2 0F 5A 64 24 30 F3 0F 11 22 EB 11 B8 01 00 00 00 F3 0F 5C C9 F3 0F 5E C9 F3 0F 11 0A 44 0F 28 84 24 90 00 00 00 44 0F 28 8C 24 80 00 00 00 44 0F 28 54 24 70 44 0F 28 5C 24 60 44 0F 28 AC 24 C0 00 00 00 44 0F 28 B4 24 B0 00 00 00 44 0F 28 BC 24 A0 00 00 00 48 81 C4 D0 00 00 00 5D C3 F3 0F 5E C9 F3 0F 11 0A BA 01 00 00 00 33 C0 F7 01 FF FF 7F 00 0F 44 C2 EB A4 0F 1F 00 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__GSHandlerCheck_EH"
		size = 127
		refs = "0034 __GSHandlerCheckCommon 0060 __CxxFrameHandler3"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 49 8B 59 38 48 8B F2 4D 8B F0 48 8B E9 49 8B D1 48 8B CE 49 8B F9 4C 8D 43 04 E8 ?? ?? ?? ?? 8B 45 04 24 66 F6 D8 B8 01 00 00 00 45 1B C0 41 F7 D8 44 03 C0 44 85 43 04 74 11 4C 8B CF 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__mpx_init_static_rep"
		size = 55
	strings:
		$1 = { 48 85 C9 F2 74 30 48 85 D2 F2 74 2A 4C 8D 41 08 49 8B 08 49 8B 40 08 4D 8D 40 18 48 2B C1 F3 0F 1B 44 01 FF 49 8B 48 E0 48 8B 01 0F 1B 04 01 48 83 EA 01 F2 75 DA C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__avx_floor4"
		size = 16
	strings:
		$1 = { C4 E3 7D 09 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "__chkstk2"
		size = 63
	strings:
		$1 = { 41 50 41 51 4D 33 C9 4C 8D 44 24 18 4C 2B C0 4D 0F 42 C1 65 4C 8B 0C 25 10 00 00 00 4D 3B C1 F2 73 17 66 41 81 E0 00 F0 4D 8D 89 00 F0 FF FF 41 C6 01 00 4D 3B C1 F2 75 EF 41 59 41 58 F2 C3 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "?__scrt_initialize_thread_safe_statics@@YAHXZ"
		size = 286
		refs = "0015 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 001f __vcrt_InitializeCriticalSectionEx 0026 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 002c __imp_GetModuleHandleW 003f ??_C@_0BM@HLJJNPAH@InitializeConditionVariable?$AA@ 0048 __imp_GetProcAddress 004f ??_C@_0BJ@JEBJOJFJ@SleepConditionVariableCS?$AA@ 0062 ??_C@_0BJ@PGPPEPCC@WakeAllConditionVariable?$AA@ 0087 ?_Tss_event@@3PEAXEA 0090 _guard_check_icall 0097 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 00a0 __security_cookie 00bf ?encoded_sleep_condition_variable_cs@@3P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZEA 00c6 ?encoded_wake_all_condition_variable@@3P6AXPEAU_RTL_CONDITION_VARIABLE@@@ZEA 00cd ?__scrt_uninitialize_thread_safe_statics@@YAXXZ 00d2 atexit 00f6 __imp_CreateEventW 010e __scrt_fastfail"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 45 33 C0 48 8D 0D ?? ?? ?? ?? BA A0 0F 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 CC 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 8B F0 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 8B F8 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 F6 74 6E 48 85 FF 74 69 48 85 C0 74 64 48 83 25 ?? ?? ?? ?? 00 48 8B CE E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF D6 48 8B 15 ?? ?? ?? ?? B9 40 00 00 00 8B C2 83 E0 3F 2B C8 48 D3 CF 48 33 FA 48 D3 CB 48 33 DA 48 89 3D ?? ?? ?? ?? 48 89 1D ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 5C 24 30 33 C0 48 8B 74 24 38 48 83 C4 20 5F C3 45 33 C9 45 33 C0 33 C9 41 8D 51 01 FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 75 C4 EB 0B B9 07 00 00 00 E8 ?? ?? ?? ?? CC B9 07 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_108_1_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z"
		size = 22
		refs = "0003 __security_cookie"
		altNames = "??$__crt_fast_decode_pointer@P6AXPEAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPEAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z ??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z ??$__crt_fast_decode_pointer@PEAX@@YAPEAXQEAX@Z"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8B D1 8B C8 48 33 C2 83 E1 3F 48 D3 C8 C3 }
	condition:
		$1
}

rule file_108_3_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@Z@@YAP6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZQ6AH01K@Z@Z"
		size = 30
		refs = "0003 __security_cookie"
		altNames = "??$__crt_fast_encode_pointer@P6AXPEAU_RTL_CONDITION_VARIABLE@@@Z@@YAP6AXPEAU_RTL_CONDITION_VARIABLE@@@ZQ6AX0@Z@Z ??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z ??$__crt_fast_encode_pointer@PEAX@@YAPEAXQEAX@Z"
	strings:
		$1 = { 4C 8B 05 ?? ?? ?? ?? 48 8B C1 41 8B D0 B9 40 00 00 00 83 E2 3F 2B CA 48 D3 C8 49 33 C0 C3 }
	condition:
		$1
}

rule file_108_6_0 {
	meta:
		name = "?__scrt_uninitialize_thread_safe_statics@@YAXXZ"
		size = 40
		refs = "0007 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 000d __imp_DeleteCriticalSection 0014 ?_Tss_event@@3PEAXEA 001f __imp_CloseHandle"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 06 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_7_0 {
	meta:
		name = "_Init_thread_abort"
		size = 48
		refs = "000c ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0012 __imp_EnterCriticalSection 0022 __imp_LeaveCriticalSection 002c _Init_thread_notify"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 23 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_8_0 {
	meta:
		name = "_Init_thread_footer"
		size = 96
		refs = "000c ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0012 __imp_EnterCriticalSection 0018 _Init_global_epoch 0025 _tls_index 003e _Init_thread_epoch 0052 __imp_LeaveCriticalSection 005c _Init_thread_notify"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 89 03 65 48 8B 04 25 58 00 00 00 41 B9 ?? ?? ?? ?? 4C 8B 04 D0 8B 05 ?? ?? ?? ?? 43 89 04 01 FF 15 ?? ?? ?? ?? 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_9_0 {
	meta:
		name = "_Init_thread_header"
		size = 103
		refs = "000c ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0012 __imp_EnterCriticalSection 0026 _Init_thread_wait 003c _tls_index 0042 _Init_thread_epoch 004c _Init_global_epoch 0063 __imp_LeaveCriticalSection"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 3B 00 75 11 83 0B FF EB 34 B9 64 00 00 00 E8 ?? ?? ?? ?? EB EA 83 3B FF 74 EF 65 48 8B 04 25 58 00 00 00 8B 0D ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 8B 14 C8 8B 05 ?? ?? ?? ?? 41 89 04 10 48 8D 0D ?? ?? ?? ?? 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_11_0 {
	meta:
		name = "_Init_thread_notify"
		size = 91
		refs = "0009 ?_Tss_event@@3PEAXEA 0015 __security_cookie 001e ?encoded_wake_all_condition_variable@@3P6AXPEAU_RTL_CONDITION_VARIABLE@@@ZEA 002c _guard_check_icall 0033 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 0044 __imp_SetEvent 0057 __imp_ResetEvent"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 0D ?? ?? ?? ?? 48 85 C9 75 30 48 8B 1D ?? ?? ?? ?? 8B CB 48 33 1D ?? ?? ?? ?? 83 E1 3F 48 D3 CB 48 8B CB E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B 48 FF E0 FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_13_0 {
	meta:
		name = "_Init_thread_wait"
		size = 151
		refs = "0016 ?_Tss_event@@3PEAXEA 001f __security_cookie 0028 ?encoded_sleep_condition_variable_cs@@3P6AHPEAU_RTL_CONDITION_VARIABLE@@PEAU_RTL_CRITICAL_SECTION@@K@ZEA 0036 _guard_check_icall 0040 ?_Tss_mutex@@3U_RTL_CRITICAL_SECTION@@A 0047 ?_Tss_cv@@3U_RTL_CONDITION_VARIABLE@@A 005d __imp_LeaveCriticalSection 006f __imp_WaitForSingleObjectEx 007e __imp_EnterCriticalSection"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 FF 8B F1 48 39 3D ?? ?? ?? ?? 75 38 48 8B 1D ?? ?? ?? ?? 8B CB 48 33 1D ?? ?? ?? ?? 83 E1 3F 48 D3 CB 48 8B CB E8 ?? ?? ?? ?? 44 8B C6 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF D3 85 C0 0F 95 C0 EB 33 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 45 33 C0 8B D6 FF 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 8B D8 FF 15 ?? ?? ?? ?? 85 DB 0F 94 C0 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "__sse2_atanf4"
		size = 192
		refs = "0007 s_dwAbsMask 000e s_fOne 002e s_dwSignMask 0035 s_fPi2 005d s_fA8 0064 s_fA7 0071 s_fA6 0078 s_fA5 0085 s_fA4 008c s_fA3 0099 s_fA2 00a0 s_fA1 00ad s_fA0"
	strings:
		$1 = { 0F 28 E8 66 0F DB 05 ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 5F D8 0F 28 E0 0F 5D 05 ?? ?? ?? ?? 0F 5E C3 66 0F 66 25 ?? ?? ?? ?? 66 0F DB 2D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 66 0F DB D4 66 0F DB 25 ?? ?? ?? ?? 66 0F EF D5 66 0F EF E5 66 0F EF E0 0F 59 C0 0F 28 D8 0F 59 C0 0F 28 2D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 E8 0F 59 C8 0F 58 2D ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 C5 0F 59 CB 0F 58 05 ?? ?? ?? ?? 0F 58 C1 0F 59 C4 0F 58 C2 C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "__common_dlog_cout_rare"
		size = 704
		refs = "003e _imldLnHATab 0064 _2il0floatpacket_70 025c _2il0floatpacket_71"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 41 81 F8 F0 7F 00 00 0F 84 4E 02 00 00 F2 0F 10 19 45 33 C0 48 8B 09 48 89 4C 24 30 48 C1 E9 30 F7 C1 F0 7F 00 00 75 14 F2 0F 59 1D ?? ?? ?? ?? 41 B8 C4 FF FF FF F2 0F 11 5C 24 30 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D8 0F 86 D2 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D3 F2 0F 5C D0 F2 0F 11 54 24 28 80 64 24 2F 7F F2 0F 10 4C 24 28 66 0F 2F 0D ?? ?? ?? ?? 0F 86 3F 01 00 00 F2 0F 11 5C 24 28 44 0F B7 4C 24 2E 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 2E F2 0F 10 6C 24 28 0F 28 DD 0F B7 4C 24 36 81 E1 F0 7F 00 00 F2 0F 58 1D ?? ?? ?? ?? C1 E9 04 F2 0F 11 5C 24 20 0F 28 DD 44 8B 54 24 20 41 83 E2 7F F2 0F 58 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 45 8D 84 08 01 FC FF FF F2 41 0F 2A C8 F2 0F 10 5C 24 20 47 8D 1C 52 48 8D 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 4C 8B C9 F2 0F 10 25 ?? ?? ?? ?? 4C 8B C1 F2 0F 59 D1 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 CC F2 0F 5C EB F2 43 0F 58 54 D8 08 F2 43 0F 58 4C D9 10 F2 42 0F 10 24 D9 F2 0F 59 DC F2 0F 59 E5 F2 0F 5C D8 0F 28 C3 F2 0F 58 DA F2 0F 58 C4 F2 0F 58 E1 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 59 E8 F2 0F 58 E5 F2 0F 58 DC F2 0F 11 1A 48 83 C4 38 C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 59 C2 F2 0F 58 D0 F2 0F 11 12 48 83 C4 38 C3 66 0F 2E D8 7A 02 74 12 F2 0F 5E C0 F2 0F 11 02 B8 01 00 00 00 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 11 0A 48 83 C4 38 C3 44 8A 41 07 41 80 E0 80 41 80 F8 80 74 11 F2 0F 10 01 F2 0F 59 C0 F2 0F 11 02 48 83 C4 38 C3 F7 41 04 FF FF 0F 00 75 E6 83 39 00 75 E1 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 11 02 48 83 C4 38 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "??_L@YAXPEAX_K1P6AX0@Z2@Z"
		size = 110
		refs = "003a _guard_check_icall"
	strings:
		$1 = { 48 8B C4 48 89 58 18 48 89 70 20 48 89 50 10 48 89 48 08 57 41 56 41 57 48 83 EC 30 49 8B F1 4D 8B F8 4C 8B F2 48 8B F9 33 DB 48 89 58 E0 88 58 D8 49 3B DF 74 1F 48 8B CE E8 ?? ?? ?? ?? 48 8B CF FF D6 49 03 FE 48 89 7C 24 50 48 FF C3 48 89 5C 24 28 EB DC C6 44 24 20 01 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 30 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_112_1_0 {
	meta:
		name = "?fin$0@?0???_L@YAXPEAX_K1P6AX0@Z2@Z@4HA"
		size = 44
		refs = "0020 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
		altNames = "?fin$0@?0???_N@YAXPEAX_K1P6AX0@Z2@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 80 7D 20 00 75 16 4C 8B 4D 70 4C 8B 45 28 48 8B 55 58 48 8B 4D 50 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "__avx_atan4"
		size = 656
		refs = "006c __common_datan_data"
	strings:
		$1 = { 55 48 81 EC 30 02 00 00 48 8D 6C 24 20 C5 7C 11 BD C0 00 00 00 C5 7C 11 B5 E0 00 00 00 C5 7C 11 AD 00 01 00 00 C5 7C 11 A5 20 01 00 00 C5 7C 11 9D 40 01 00 00 C5 7C 11 95 60 01 00 00 C5 7C 11 8D 80 01 00 00 C5 7C 11 85 A0 01 00 00 C5 FC 11 BD C0 01 00 00 C5 FC 11 B5 E0 01 00 00 4C 89 AD 00 02 00 00 4C 8D 6D 3F C5 FD 10 35 ?? ?? ?? ?? 49 83 E5 C0 C5 FD 10 25 ?? ?? ?? ?? C5 7D 10 35 ?? ?? ?? ?? C5 7D 10 3D ?? ?? ?? ?? C5 7D 10 2D ?? ?? ?? ?? C5 FD 54 1D ?? ?? ?? ?? C5 7D 54 C6 C5 E5 C2 C4 12 C5 DD 5D D3 C5 FD 55 0D ?? ?? ?? ?? C4 C1 75 57 E8 C5 E5 5F CC C5 FD 10 1D ?? ?? ?? ?? C4 C1 7D 11 6D 00 C5 FD 10 25 ?? ?? ?? ?? C5 FD 10 2D ?? ?? ?? ?? C5 6D 5E D1 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 15 ?? ?? ?? ?? C5 7D 10 25 ?? ?? ?? ?? C5 FD 55 FE C4 41 45 57 C8 C4 41 35 57 DA C4 41 7D 11 5D 20 C4 41 25 59 DB C5 FD 10 05 ?? ?? ?? ?? C5 FD 10 35 ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C4 41 7D 11 5D 40 C4 41 25 59 DB C5 7D 10 05 ?? ?? ?? ?? C5 7D 10 15 ?? ?? ?? ?? C4 41 7D 11 5D 60 C4 41 25 59 DB C5 7D 10 0D ?? ?? ?? ?? C4 41 0D 59 F3 C4 C1 65 59 DB C4 41 15 59 EB C4 41 0D 58 F7 C5 E5 58 DC C5 95 58 E5 C4 41 75 59 FB C4 C1 0D 59 EB C4 C1 65 59 DB C4 C1 5D 59 E3 C5 85 58 D2 C5 D5 58 E8 C5 E5 58 FF C4 41 5D 58 E8 C4 C1 6D 59 CB C4 C1 55 59 D3 C4 41 45 59 C3 C5 F5 58 C6 C4 41 6D 58 F1 C5 BD 58 15 ?? ?? ?? ?? C4 C1 7D 59 F3 C4 41 15 59 CB C4 C1 6D 59 DB C5 7C 10 AD 00 01 00 00 C4 41 4D 58 FA C5 B5 58 25 ?? ?? ?? ?? C5 E5 58 05 ?? ?? ?? ?? C4 C1 05 59 CB C4 41 0D 59 D3 C4 41 5D 59 DB C5 7C 10 B5 E0 00 00 00 C5 7C 10 BD C0 00 00 00 C5 F5 58 35 ?? ?? ?? ?? C5 AD 58 2D ?? ?? ?? ?? C4 C1 25 58 D4 C4 C1 7D 10 4D 40 C5 7C 10 95 60 01 00 00 C5 7C 10 9D 40 01 00 00 C5 55 59 E1 C5 CD 59 E9 C5 FC 10 B5 E0 01 00 00 C5 9D 58 D8 C5 D5 58 FA C5 7C 10 A5 20 01 00 00 C4 C1 65 59 65 60 C5 5D 58 C7 C5 FC 10 BD C0 01 00 00 C4 41 3D 59 4D 20 C5 7C 10 85 A0 01 00 00 C4 C1 35 58 45 00 C5 7C 10 8D 80 01 00 00 4C 8B AD 00 02 00 00 48 8D A5 10 02 00 00 5D C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "__sse2_tanhf4"
		size = 272
		refs = "0011 s_fTh 0018 s_fRS 001f s_dwAbsMask 002d s_dwIndexMask 0058 s_fTen 0067 s_dwPosInf 0079 s_fOne 0097 s_fA2 00a1 s_fA0 00ac s_fA3 00b6 s_fA1"
	strings:
		$1 = { 48 83 EC 48 0F 29 7C 24 20 0F 29 74 24 30 4C 8D 0D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 66 0F DB F8 0F 58 F7 0F 28 15 ?? ?? ?? ?? 66 0F DB D6 66 0F 7E D0 66 0F 70 D2 39 66 0F 7E D2 66 0F 70 D2 39 66 0F 7E D1 66 0F 70 D2 39 66 41 0F 7E D0 0F 28 1D ?? ?? ?? ?? 0F C2 DF 02 66 0F EF C7 0F 28 15 ?? ?? ?? ?? 0F 28 CF 0F C2 CA 02 66 0F DB CB 0F 28 2D ?? ?? ?? ?? 66 0F DB E9 0F 28 15 ?? ?? ?? ?? 0F 5C F2 0F 5C FE 0F 28 E7 0F 59 E7 0F 28 1D ?? ?? ?? ?? 0F 59 DC 0F 58 1D ?? ?? ?? ?? 66 0F EB C5 0F 28 15 ?? ?? ?? ?? 0F 59 E2 0F 58 25 ?? ?? ?? ?? 0F 59 E7 F3 41 0F 7E 14 81 F3 41 0F 7E 3C 91 F3 41 0F 7E 34 89 F3 43 0F 7E 2C 81 0F 14 D7 0F 14 F5 0F C6 D6 44 0F 28 F3 0F 59 F2 0F 58 F4 0F 59 E2 0F 58 E3 0F 5E F4 66 0F DF CE 66 0F EB C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "__sse2_sinh2"
		size = 544
		refs = "000a __common_dsinh_data 0212 __common_dsinh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 01 00 00 4C 8D 05 ?? ?? ?? ?? 44 0F 29 AC 24 D0 00 00 00 44 0F 29 A4 24 E0 00 00 00 44 0F 29 94 24 F0 00 00 00 44 0F 29 8C 24 00 01 00 00 0F 29 B4 24 C0 00 00 00 4C 89 AC 24 10 01 00 00 4C 8D 6C 24 6F 0F 28 35 ?? ?? ?? ?? 49 83 E5 C0 0F 54 F0 44 0F 28 D6 44 0F 28 0D ?? ?? ?? ?? 66 44 0F EF D0 66 45 0F 59 CA 0F 28 0D ?? ?? ?? ?? 66 44 0F 58 C9 41 0F 28 E1 66 0F 5C E1 F3 0F 7E 15 ?? ?? ?? ?? 66 41 0F 70 DA DD 66 0F 66 DA 0F 28 15 ?? ?? ?? ?? 66 0F 59 D4 0F 50 D3 0F 28 0D ?? ?? ?? ?? 44 0F 28 2D ?? ?? ?? ?? 66 0F 59 CC 66 44 0F 5C D2 66 44 0F 5C D1 41 0F 28 CA 83 E2 03 66 41 0F 59 CA 66 44 0F 59 E9 66 44 0F 58 2D ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 41 0F 54 E9 66 0F 7E E8 66 44 0F EF CD 44 0F 28 25 ?? ?? ?? ?? 66 41 0F 73 F1 2D 66 0F C5 CD 04 66 44 0F 59 E9 66 44 0F 59 E1 66 45 0F 59 EA 66 44 0F 58 25 ?? ?? ?? ?? 66 45 0F 58 EA 66 44 0F 59 E1 C1 E0 04 41 0F 28 E9 C1 E1 04 85 D2 F3 42 0F 7E 54 00 08 F3 42 0F 7E 1C 00 66 42 0F 16 54 01 08 66 0F D4 EA 66 41 0F FB D1 66 0F 6F E5 66 0F 58 E2 66 0F 5C EA 66 42 0F 16 1C 01 66 41 0F D4 D9 66 0F 58 EB 66 0F 58 DC 66 44 0F 59 E5 66 44 0F 59 EB 66 45 0F 58 EC 66 44 0F 58 ED 41 0F 56 F5 75 3F 44 0F 28 8C 24 00 01 00 00 0F 28 C6 0F 28 B4 24 C0 00 00 00 44 0F 28 94 24 F0 00 00 00 44 0F 28 A4 24 E0 00 00 00 44 0F 28 AC 24 D0 00 00 00 4C 8B AC 24 10 01 00 00 48 81 C4 18 01 00 00 C3 41 0F 29 45 00 41 0F 29 75 40 74 B5 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 1B FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 75 40 E9 7A FF FF FF 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D4 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "_raise_zerodivide"
		size = 32
	strings:
		$1 = { 66 0F 76 C0 66 0F EF C9 66 0F 72 F0 1C F3 0F 5E C1 C3 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "__sse2_pow2"
		size = 1152
		refs = "000a s_Data"
	strings:
		$1 = { 48 81 EC 98 00 00 00 48 8D 05 ?? ?? ?? ?? 0F 29 7C 24 70 0F 29 74 24 60 48 89 84 24 80 00 00 00 66 0F 28 D8 66 0F 28 D0 66 0F DB 05 ?? ?? ?? ?? 66 0F 57 F6 4C 8B 84 24 80 00 00 00 66 0F FE 05 ?? ?? ?? ?? BA 00 00 00 00 89 94 24 88 00 00 00 66 0F 73 D0 2A 66 0F 7E C0 66 0F C5 C8 04 66 0F 29 4C 24 20 66 0F C5 D3 03 F3 41 0F 7E 84 C0 50 02 00 00 66 41 0F 16 84 C8 50 02 00 00 66 0F DB 15 ?? ?? ?? ?? 03 C0 66 41 0F 28 BC C0 60 22 00 00 66 0F C5 C3 07 66 0F 29 5C 24 30 66 0F FB 1D ?? ?? ?? ?? 03 C9 66 0F EB 15 ?? ?? ?? ?? 66 0F 72 E3 14 66 0F DB 1D ?? ?? ?? ?? 66 41 0F 28 AC C8 60 22 00 00 66 0F 28 E2 66 0F 29 74 24 40 66 0F FE 1D ?? ?? ?? ?? 66 0F 59 D0 81 EA 10 00 00 80 66 0F 5C 1D ?? ?? ?? ?? 2D 10 00 00 80 81 FA DF 7F 00 80 0F 8F C4 02 00 00 3D DF 7F 00 80 0F 8F B9 02 00 00 66 0F 70 F7 0E 66 0F 14 FD 66 0F 58 DF 66 0F C6 F5 02 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FC 66 0F 5C E7 66 0F 59 F8 66 0F 59 E0 66 0F 5C FA 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 FC 66 0F 28 E3 66 0F 58 DA 66 0F 5C E3 66 0F 58 E2 66 0F 28 C3 66 0F 58 DF 66 0F 5C C3 66 0F 58 C7 66 0F 58 FA 66 0F 58 C4 66 0F 28 D7 66 0F 59 FF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 58 C6 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 28 F3 66 0F 59 E7 66 0F 59 EF 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E7 66 0F 59 EF 66 0F 28 F9 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 70 D3 F1 66 0F 58 E5 66 0F 58 C4 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D8 66 0F 5C F3 66 0F 7E D0 66 0F 70 D2 FF 8B 4C 24 24 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 C6 66 0F DB E3 25 00 00 F0 7F 81 E1 00 00 F0 7F 66 0F 5C DC 03 C1 3D 00 00 90 80 0F 87 DF 01 00 00 66 0F 7E D0 66 0F 59 C1 8B 4C 24 2C 25 00 00 F0 7F 81 E1 00 00 F0 7F 03 C1 3D 00 00 90 80 0F 87 BB 01 00 00 66 0F 28 EB 8B 44 24 24 25 FF FF FF 7F 8B 4C 24 20 0B C8 66 0F 5C CF 0F 84 9E 01 00 00 3D 00 00 F0 7F 66 0F 59 DF 0F 83 8F 01 00 00 8B 44 24 2C 25 FF FF FF 7F 8B 4C 24 28 0B C8 0F 84 7A 01 00 00 3D 00 00 F0 7F 66 0F 59 E9 0F 83 6B 01 00 00 66 0F 59 CC 66 0F 59 FC 66 0F 58 EB 66 0F 28 1D ?? ?? ?? ?? 66 0F 58 E9 66 0F 28 D7 66 0F 58 3D ?? ?? ?? ?? 66 0F 7E F8 66 0F C5 CF 04 66 0F C5 D7 05 C1 E2 10 66 0F 5C DF 0B CA 3D 80 FF 01 00 0F 8D 25 01 00 00 81 F9 80 FF 01 00 0F 8D 19 01 00 00 3D 00 1E FE FF 0F 8E 0E 01 00 00 81 F9 00 1E FE FF 0F 8E 02 01 00 00 83 E0 7F 83 E1 7F 03 C0 03 C9 66 0F 73 F7 2D 66 0F 28 25 ?? ?? ?? ?? 66 0F FE 3D ?? ?? ?? ?? 66 0F DB 3D ?? ?? ?? ?? 66 0F 58 DA 66 0F 58 E8 66 0F 28 05 ?? ?? ?? ?? F3 41 0F 7E 94 C0 90 62 00 00 66 0F 58 EB F3 41 0F 7E 9C C0 98 62 00 00 66 41 0F 16 94 C8 90 62 00 00 66 41 0F 16 9C C8 98 62 00 00 66 0F 59 C5 66 0F 28 CD 66 0F 59 E5 66 0F 59 ED 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 C5 66 0F 59 E5 66 0F 59 C5 66 0F 59 0D ?? ?? ?? ?? 66 0F 59 C2 66 0F 59 E2 66 0F 58 C3 66 0F 59 CA 66 0F 58 C4 66 0F 58 C1 66 0F 58 C2 66 0F 59 C7 E9 A9 00 00 00 66 0F 57 F6 66 0F 28 3D ?? ?? ?? ?? 66 0F C2 74 24 20 01 66 0F C2 7C 24 20 05 66 0F EF ED 66 0F DB F7 66 0F 76 6C 24 30 66 0F 70 FD B1 66 0F DB EE 66 0F DB EF 66 0F D7 D5 89 94 24 88 00 00 00 66 0F 29 6C 24 40 8B 84 24 88 00 00 00 A8 0F 75 1E F2 0F 10 44 24 30 F2 0F 10 4C 24 20 E8 60 00 00 00 F2 0F 11 44 24 50 8B 84 24 88 00 00 00 A9 00 0F 00 00 75 17 F2 0F 10 44 24 38 F2 0F 10 4C 24 28 E8 3B 00 00 00 F2 0F 11 44 24 58 4C 8B 84 24 80 00 00 00 66 0F 28 44 24 50 66 0F 76 C9 66 0F EF 4C 24 40 66 0F 54 C1 0F 28 74 24 60 0F 28 7C 24 70 48 81 C4 98 00 00 00 C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_127_2_0 {
	meta:
		name = "pow_scalar"
		size = 3712
		refs = "00e4 s_Data 03f6 INF_c_2044_0_4 048b _2il0floatpacket_15 04f6 _2il0floatpacket_16 0c25 QNaN_c_2044_0_4"
	strings:
		$1 = { 53 56 57 41 54 41 55 41 56 41 57 55 48 81 EC F8 00 00 00 33 D2 F2 0F 11 8C 24 88 00 00 00 8B 9C 24 8C 00 00 00 8B CB 81 E1 FF FF FF 7F 44 0F 29 BC 24 90 00 00 00 81 F9 00 00 F0 7F 44 0F 29 B4 24 D0 00 00 00 44 0F 29 A4 24 E0 00 00 00 44 0F 29 9C 24 A0 00 00 00 44 0F 29 84 24 B0 00 00 00 0F 29 B4 24 C0 00 00 00 F2 0F 11 84 24 40 01 00 00 66 49 0F 7E C1 0F 83 93 01 00 00 8B 84 24 88 00 00 00 0B C8 0F 84 84 01 00 00 49 8B C1 48 C1 E8 20 8B E8 81 E5 FF FF FF 7F 4C 89 4C 24 28 8D 8D 00 00 F0 FF 81 F9 00 00 E0 7F 73 14 8B C8 81 E1 00 00 00 80 81 F9 00 00 00 80 0F 85 47 04 00 00 81 FD 00 00 F0 7F 0F 83 42 01 00 00 8B 4C 24 28 0B E9 0F 84 36 01 00 00 3D 00 00 10 00 73 2B F2 0F 59 05 ?? ?? ?? ?? 48 B8 00 00 00 00 00 00 F0 3F F2 0F 11 44 24 28 BA 34 00 00 00 48 89 44 24 30 8B 44 24 2C E9 0C 04 00 00 F2 0F 11 4C 24 20 8B 7C 24 24 81 E7 FF FF FF 7F 8B CF 8B 74 24 20 0B CE 74 6C 8D 8F 00 00 10 C0 81 F9 00 00 00 40 73 3D 81 FF 00 00 40 43 7D 56 8B CF 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 23 8B EF D3 E5 C1 E5 0C 0B EE 75 14 83 C1 0B D3 E7 F7 D7 81 E7 00 00 00 80 C1 EF 1F FF C7 EB 26 33 FF EB 22 83 C1 0B D3 E6 F7 C6 FF FF FF 7F 75 EF F7 D6 81 E6 00 00 00 80 C1 EE 1F 8D 7E 01 EB 05 BF 02 00 00 00 25 00 00 00 80 3D 00 00 00 80 75 6D 85 FF 74 69 0F 28 C8 83 FF 01 0F 57 C0 F2 0F 5C C1 F2 0F 11 44 24 28 74 11 48 B8 00 00 00 00 00 00 F0 3F 48 89 44 24 30 EB 0F 48 B8 00 00 00 00 00 00 F0 BF 48 89 44 24 30 8B 44 24 2C 8B C8 81 E1 FF FF FF 7F 81 F9 00 00 10 00 0F 83 24 03 00 00 F2 0F 59 05 ?? ?? ?? ?? BA 34 00 00 00 F2 0F 11 44 24 28 8B 44 24 2C E9 08 03 00 00 F2 0F 11 4C 24 20 4C 89 4C 24 30 49 C1 E9 20 45 8B D9 F2 0F 11 4C 24 28 41 81 E3 FF FF FF 7F 44 8B 54 24 2C 41 81 E1 00 00 00 80 44 8B 44 24 24 41 81 E2 FF FF FF 7F 41 81 E0 00 00 00 80 8B 7C 24 30 41 81 FB 00 00 F0 7F 44 89 5C 24 34 44 89 54 24 2C 0F 84 1F 0A 00 00 C7 44 24 20 00 00 00 00 41 BF 01 00 00 00 8B 44 24 28 41 81 FA 00 00 F0 7F 0F 84 F3 09 00 00 33 F6 41 8B D3 81 E2 00 00 F0 7F 81 FA 00 00 F0 7F 0F 84 CC 09 00 00 33 ED 41 8B D2 81 E2 00 00 F0 7F 81 FA 00 00 F0 7F 0F 84 A8 09 00 00 33 DB 41 8B D3 8B CE 0B D7 BA 00 00 00 00 41 0F 44 D7 45 33 E4 0B CB 45 0F 44 E7 41 81 FB 00 00 F0 3F 44 89 64 24 30 0F 84 6E 09 00 00 45 33 FF F2 0F 11 4C 24 28 44 8B 6C 24 2C 41 81 E5 FF FF FF 7F 41 8B CD 44 8B 74 24 28 41 0B CE 74 7F 41 8D 8D 00 00 10 C0 81 F9 00 00 00 40 73 48 41 81 FD 00 00 40 43 7D 67 41 8B CD 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 2D 45 8B E5 41 D3 E4 41 C1 E4 0C 45 0B E6 75 19 83 C1 0B 41 D3 E5 41 F7 D5 41 81 E5 00 00 00 80 41 C1 ED 1F 41 FF C5 EB 2E 45 33 ED EB 29 83 C1 0B 41 D3 E6 41 F7 C6 FF FF FF 7F 75 EC 41 F7 D6 41 81 E6 00 00 00 80 41 C1 EE 1F 45 8D 6E 01 EB 06 41 BD 02 00 00 00 41 81 FB 00 00 F0 3F 7E 04 B1 01 EB 08 0F 84 A7 08 00 00 B1 00 44 0B D0 0F 84 4B 01 00 00 45 85 C9 75 0B 45 85 FF 0F 85 3D 01 00 00 EB 0D 45 85 FF 74 08 85 F6 0F 85 2E 01 00 00 85 ED 0F 85 21 01 00 00 85 DB 0F 85 26 01 00 00 85 D2 74 0D 45 85 C0 74 08 85 F6 0F 85 D9 00 00 00 84 C9 74 22 45 85 C0 75 11 85 F6 74 19 F2 0F 10 0D ?? ?? ?? ?? E9 FB 00 00 00 85 F6 74 08 0F 57 C9 E9 EF 00 00 00 41 81 FB 00 00 F0 3F 7D 22 45 85 C0 75 0C 85 F6 74 19 0F 57 C9 E9 D5 00 00 00 85 F6 74 0D F2 0F 10 0D ?? ?? ?? ?? E9 C4 00 00 00 45 85 C9 75 23 83 7C 24 20 00 74 0D 45 85 C0 74 AB 0F 57 C9 E9 AB 00 00 00 85 D2 74 B0 45 85 C0 74 7B 41 83 FD 01 EB 60 83 7C 24 20 00 74 2C 45 85 C0 75 14 41 83 FD 01 0F 84 BF 07 00 00 F2 0F 10 0D ?? ?? ?? ?? EB 7C 41 83 FD 01 0F 57 C9 75 73 F2 0F 10 0D ?? ?? ?? ?? EB 69 83 7C 24 30 00 74 0F 45 85 ED 75 0A 85 D2 0F 84 77 07 00 00 EB 08 85 D2 0F 84 54 FF FF FF 45 85 C0 74 19 41 83 FD 01 0F 84 70 07 00 00 E8 9D F6 FF FF F2 0F 10 0D ?? ?? ?? ?? EB 2D 41 83 FD 01 74 10 83 7C 24 30 00 0F 84 25 FF FF FF 0F 57 C9 EB 17 F2 0F 10 0D ?? ?? ?? ?? EB 0D 0F 28 C8 EB 08 F2 0F 10 0D ?? ?? ?? ?? F2 0F 11 8C 24 88 00 00 00 E9 C8 06 00 00 48 B9 00 00 00 00 00 00 F0 3F 48 89 4C 24 30 8B F0 48 8D 2D ?? ?? ?? ?? F2 0F 11 44 24 20 81 E6 00 FE 0F 00 8B 4C 24 24 81 C6 00 02 00 00 81 E1 FF FF 0F 00 05 00 02 18 C0 C1 EE 0A 81 C9 00 00 F0 3F 89 4C 24 24 4C 8B CD 48 C1 E1 20 8D 3C 36 44 8B 54 24 20 49 0B CA 48 89 4C 24 28 44 8D 44 36 01 81 E1 00 00 00 F8 F2 0F 10 AC F5 50 02 00 00 89 4C 24 28 0F 28 D5 F2 0F 10 74 24 20 0F 28 DD F2 0F 10 64 24 28 F2 0F 59 D6 F2 0F 5C F4 F2 0F 59 DC F2 0F 59 F5 F2 0F 5C DA C1 F8 14 2B C2 8B D3 F2 44 0F 2A D8 48 8B C5 F2 0F 11 5C 24 38 81 E2 00 00 F0 7F F2 44 0F 10 44 24 38 81 C2 00 00 10 C0 F2 0F 10 0D ?? ?? ?? ?? F2 44 0F 58 C6 F2 44 0F 58 9C F8 60 22 00 00 F2 0F 58 CA F2 44 0F 11 44 24 38 F2 44 0F 11 5C 24 40 F2 44 0F 10 64 24 40 F2 44 0F 58 E1 F2 44 0F 11 64 24 48 8B 44 24 4C 44 8B D8 41 81 E3 00 00 F0 7F 41 81 C3 00 00 10 C0 41 C1 FB 14 C1 FA 14 44 03 DA F2 43 0F 10 84 C1 60 22 00 00 41 83 FB 0B 0F 8F 64 06 00 00 F2 0F 10 74 24 40 F2 0F 10 64 24 48 48 8B 94 24 88 00 00 00 F2 0F 5C F4 F2 0F 11 74 24 50 F2 0F 10 54 24 50 48 89 54 24 28 F2 0F 58 D1 F2 0F 11 54 24 50 81 E2 00 00 00 F8 F2 0F 10 6C 24 48 F2 0F 10 5C 24 38 89 54 24 28 F2 0F 58 EB F2 0F 11 6C 24 58 F2 44 0F 10 5C 24 48 F2 44 0F 10 44 24 58 F2 45 0F 5C D8 F2 44 0F 11 5C 24 60 F2 44 0F 10 74 24 38 F2 44 0F 10 64 24 60 F2 45 0F 58 F4 F2 44 0F 11 74 24 60 F2 0F 10 64 24 50 F2 44 0F 10 7C 24 60 F2 41 0F 58 E7 F2 0F 11 64 24 60 F2 0F 10 74 24 60 F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 C6 F2 0F 11 44 24 60 F2 0F 10 44 24 38 F2 0F 10 74 24 60 F2 0F 58 C8 F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 F4 F2 0F 11 74 24 60 F2 0F 10 64 24 58 F2 0F 10 4C 24 60 F2 0F 58 E1 F2 0F 11 64 24 68 F2 0F 10 44 24 68 F2 0F 10 74 24 58 F2 0F 10 A4 24 88 00 00 00 F2 0F 5C C6 F2 0F 5C 64 24 28 F2 0F 11 44 24 70 F2 0F 10 54 24 60 F2 0F 10 4C 24 70 F2 0F 5C D1 F2 0F 11 54 24 60 48 8B 44 24 68 48 89 44 24 78 81 64 24 78 00 00 00 F8 F2 0F 10 6C 24 68 F2 0F 10 5C 24 78 F2 0F 10 15 ?? ?? ?? ?? F2 0F 5C EB F2 0F 11 AC 24 80 00 00 00 0F 28 EA F2 0F 10 74 24 78 F2 0F 59 74 24 28 F2 44 0F 10 84 24 80 00 00 00 F2 0F 58 EE F2 44 0F 59 C4 F2 44 0F 10 A4 24 80 00 00 00 F2 44 0F 59 64 24 28 F2 44 0F 10 5C 24 78 F2 45 0F 58 E0 F2 41 0F 59 E3 F2 0F 11 6C 24 20 F2 41 0F 58 E4 8B 5C 24 20 8B C3 83 E0 80 83 E3 7F C1 F8 07 F2 0F 10 5C 24 60 3D FF 03 00 00 F2 0F 59 9C 24 88 00 00 00 7C 52 3D 01 04 00 00 7C 34 48 8B 05 ?? ?? ?? ?? 48 89 84 24 88 00 00 00 48 C1 E8 20 8B 54 24 34 81 E2 00 00 00 80 0B C2 89 84 24 8C 00 00 00 F2 0F 10 8C 24 88 00 00 00 E9 46 03 00 00 F2 0F 10 4C 24 30 FF C8 F2 0F 58 C9 F2 0F 11 4C 24 30 E9 6B 02 00 00 3D 3C FC FF FF 0F 8F 5A 02 00 00 3D CC FB FF FF 7F 2A 8B 44 24 34 48 C7 84 24 88 00 00 00 00 00 00 00 25 00 00 00 80 89 84 24 8C 00 00 00 F2 0F 10 8C 24 88 00 00 00 E9 F3 02 00 00 F2 44 0F 10 35 ?? ?? ?? ?? 83 C0 6F C1 E0 14 48 8D 15 ?? ?? ?? ?? 05 00 00 F0 3F 48 8B EA 89 44 24 2C 8D 04 1B F2 44 0F 10 3D ?? ?? ?? ?? 8D 5C 1B 01 48 8B CA F2 0F 5C EA F2 0F 58 E3 F2 0F 5C F5 0F 28 DE F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 DC F2 44 0F 59 F3 F2 0F 10 AC C2 90 62 00 00 F2 0F 10 8C DD 90 62 00 00 C7 44 24 28 00 00 00 00 F2 44 0F 10 5C 24 30 F2 44 0F 59 1D ?? ?? ?? ?? F2 44 0F 58 35 ?? ?? ?? ?? F2 44 0F 59 F3 48 8B 84 C1 90 62 00 00 F2 44 0F 58 F2 45 0F 28 E6 F2 44 0F 59 E3 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 58 E7 F2 44 0F 59 E5 44 0F 28 C2 F2 44 0F 59 C3 F2 44 0F 59 E3 F2 44 0F 59 C5 F2 44 0F 59 E3 F2 44 0F 58 E1 F2 45 0F 58 E0 F2 44 0F 10 44 24 28 41 0F 28 C0 F2 0F 59 C5 F2 41 0F 59 C3 F2 0F 11 44 24 20 8B 74 24 24 81 E6 FF FF FF 7F 81 FE 00 00 10 00 0F 86 B6 00 00 00 F2 44 0F 59 F3 F2 0F 5C F3 F2 45 0F 59 D8 F2 45 0F 58 FE F2 0F 58 F4 F2 44 0F 59 FB 44 0F 28 E3 F2 41 0F 58 D7 F2 44 0F 59 E2 F2 0F 59 D6 F2 44 0F 11 64 24 20 41 0F 28 DC 81 64 24 20 00 00 00 FF 0F 28 F5 F2 44 0F 10 74 24 20 48 89 44 24 28 F2 41 0F 5C DE F2 44 0F 59 E1 F2 0F 58 D3 C7 44 24 28 00 00 00 00 F2 44 0F 10 7C 24 28 F2 41 0F 5C F7 0F 28 E6 F2 0F 59 E2 F2 41 0F 59 D7 F2 41 0F 59 F6 F2 44 0F 58 E4 F2 45 0F 59 F7 F2 41 0F 58 CC F2 0F 58 CA F2 0F 58 CE F2 41 0F 58 CE F2 0F 58 CD F2 41 0F 59 CB F2 0F 11 8C 24 88 00 00 00 E9 36 01 00 00 48 89 44 24 20 33 C0 F2 44 0F 11 64 24 28 89 44 24 20 81 64 24 24 00 00 FF FF 89 44 24 28 F2 0F 10 4C 24 20 F2 0F 10 44 24 28 F2 0F 5C E9 F2 44 0F 5C E0 F2 44 0F 58 E5 41 0F 28 EB F2 41 0F 59 E8 F2 44 0F 59 C1 F2 44 0F 58 E0 F2 45 0F 59 C3 F2 44 0F 59 E5 41 0F 28 CC F2 41 0F 58 C8 F2 0F 11 8C 24 88 00 00 00 E9 CA 00 00 00 F2 0F 10 4C 24 30 C1 E0 14 48 8D 15 ?? ?? ?? ?? 05 00 00 F0 3F 8D 4C 1B 01 89 44 24 2C 8D 04 1B F2 0F 5C EA F2 0F 58 E3 F2 0F 5C F5 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 E6 F2 0F 10 35 ?? ?? ?? ?? 48 8B DA F2 0F 11 6C 24 20 F2 0F 10 AC C2 90 62 00 00 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 DC F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 DD F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 F4 F2 0F 59 D4 F2 0F 59 F4 F2 0F 59 D5 F2 0F 59 F4 F2 0F 59 F5 C7 44 24 28 00 00 00 00 F2 0F 58 B4 CB 90 62 00 00 F2 0F 58 F2 F2 0F 58 F3 F2 0F 58 F5 F2 0F 59 CE F2 0F 59 4C 24 28 F2 0F 11 8C 24 88 00 00 00 0F 28 B4 24 C0 00 00 00 0F 28 C1 44 0F 28 84 24 B0 00 00 00 44 0F 28 9C 24 A0 00 00 00 44 0F 28 A4 24 E0 00 00 00 44 0F 28 B4 24 D0 00 00 00 44 0F 28 BC 24 90 00 00 00 48 81 C4 F8 00 00 00 5D 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 E8 5F 02 00 00 F2 0F 10 0D ?? ?? ?? ?? E9 CC F8 FF FF E8 2D EF FF FF 0F 57 C9 F2 0F 5C 0D ?? ?? ?? ?? E9 B7 F8 FF FF 85 FF 0F 85 47 F7 FF FF E9 4C F7 FF FF 33 C9 85 FF 44 0F 45 F9 E9 88 F6 FF FF 33 DB 85 F6 41 0F 44 DF E9 4D F6 FF FF 33 ED 83 7C 24 20 00 41 0F 44 EF E9 26 F6 FF FF 33 F6 85 C0 41 0F 44 F7 E9 02 F6 FF FF 41 BF 01 00 00 00 33 C0 85 FF 41 0F 44 C7 89 44 24 20 E9 D8 F5 FF FF 33 D8 F7 C3 00 00 00 80 0F 85 F1 00 00 00 F7 84 24 44 01 00 00 00 00 00 80 75 1C 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 FB FE FF FF 48 8B 84 24 88 00 00 00 8B D8 48 C1 E8 20 25 FF FF FF 7F 8B D0 0B D3 74 CB 8D 90 00 00 10 C0 81 FA 00 00 00 40 73 50 3D 00 00 40 43 7D B6 8B C8 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 4F 8B D0 D3 E2 C1 E2 0C 0B D3 75 28 83 C1 0B D3 E0 A9 00 00 00 80 74 89 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 84 FE FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 68 FE FF FF 83 C1 0B D3 E3 F7 C3 FF FF FF 7F 75 D7 F7 C3 00 00 00 80 0F 84 38 FF FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 33 FE FF FF F7 84 24 44 01 00 00 00 00 00 80 75 14 48 C7 84 24 88 00 00 00 00 00 00 00 0F 57 C9 E9 12 FE FF FF 48 8B 84 24 88 00 00 00 8B D8 48 C1 E8 20 25 FF FF FF 7F 8B D0 0B D3 74 D3 8D 90 00 00 10 C0 81 FA 00 00 00 40 0F 83 63 FF FF FF 3D 00 00 40 43 7D BA 8B C8 81 E1 00 00 F0 7F 81 C1 00 00 10 C0 C1 F9 14 83 F9 14 7F 37 8B D0 D3 E2 C1 E2 0C 0B D3 0F 85 37 FF FF FF 83 C1 0B D3 E0 A9 00 00 00 80 74 89 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 93 FD FF FF 83 C1 0B D3 E3 F7 C3 FF FF FF 7F 0F 85 FE FE FF FF F7 C3 00 00 00 80 0F 84 50 FF FF FF 48 8B 05 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 48 89 84 24 88 00 00 00 E9 5A FD FF FF 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_127_3_0 {
	meta:
		name = "_raise_invalid"
		size = 16
	strings:
		$1 = { B8 FF FF 8F FF 66 0F 6E C0 F3 0F 58 C0 C3 66 90 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "__avx_logf8"
		size = 544
		refs = "003f __common_slog_data 0217 __common_slog_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 B4 24 F0 01 00 00 C5 7C 11 A4 24 D0 01 00 00 C5 7C 11 9C 24 B0 01 00 00 C5 7C 11 8C 24 90 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 2F 01 00 00 C5 F8 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 F8 10 2D ?? ?? ?? ?? C5 F8 10 0D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 79 FA F4 C4 E3 7D 19 C3 01 C4 C1 21 72 E6 17 C5 61 FA E4 C5 09 DB F5 C4 C1 31 72 E4 17 C5 99 DB ED C5 09 FE F4 C5 D1 FE E4 C5 F9 FE E9 C5 E1 FE C9 C5 E9 66 D9 C5 F1 EF C9 C4 43 25 18 C9 01 C4 41 7C 5B D9 C5 69 66 CD C5 B1 6B D3 C5 E9 63 D9 C5 F9 D7 D3 C5 24 59 1D ?? ?? ?? ?? C4 E3 0D 18 E4 01 C5 DC 5C 15 ?? ?? ?? ?? C5 EC 59 25 ?? ?? ?? ?? C5 DC 58 2D ?? ?? ?? ?? C5 54 59 CA C5 34 58 25 ?? ?? ?? ?? C5 1C 59 F2 C5 8C 58 0D ?? ?? ?? ?? C5 F4 59 DA C5 E4 58 25 ?? ?? ?? ?? C5 DC 59 EA C5 54 58 0D ?? ?? ?? ?? C5 34 59 E2 C5 1C 58 35 ?? ?? ?? ?? C5 8C 59 CA C5 F4 59 DA C5 E4 58 D2 C5 A4 58 CA 84 D2 75 38 C5 7C 10 8C 24 90 01 00 00 C5 7C 10 9C 24 B0 01 00 00 C5 7C 10 A4 24 D0 01 00 00 C5 7C 10 B4 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 B8 33 C0 C5 FC 11 B4 24 C0 00 00 00 C5 FC 11 BC 24 A0 00 00 00 C5 7C 11 84 24 80 00 00 00 C5 7C 11 54 24 60 C5 7C 11 6C 24 40 C5 7C 11 7C 24 20 48 89 9C 24 E8 00 00 00 8B D8 48 89 B4 24 E0 00 00 00 8B F2 0F A3 DE 72 4F FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 C0 00 00 00 C5 FC 10 BC 24 A0 00 00 00 C5 7C 10 84 24 80 00 00 00 C5 7C 10 54 24 60 C5 7C 10 6C 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 E8 00 00 00 48 8B B4 24 E0 00 00 00 E9 21 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 9D 0F 1F 00 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "__sse2_acos2"
		size = 480
		refs = "000b iSignMask 004a dbOneHalf 0053 dbOne 00b0 dbTwo 00d7 dbPio2hi 00df dbPi 0101 dbA10 010d dbA09 0115 dbA08 011d dbA07 0136 dbA06 0142 dbA05 0158 dbA04 0160 dbA03 0170 dbA02 0178 dbA01 0190 dbA00"
	strings:
		$1 = { 48 81 EC A8 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F C2 D0 05 66 0F 29 54 24 20 66 0F 54 C8 66 0F 28 D8 66 0F 55 1D ?? ?? ?? ?? 66 0F 29 5C 24 30 66 0F 29 4C 24 40 66 0F 55 C8 66 0F 28 E1 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 2D ?? ?? ?? ?? 66 0F 29 4C 24 50 66 0F 5C E9 66 0F 59 C9 66 0F 59 2D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 EC 66 0F 55 D1 66 0F 56 D5 66 0F 51 ED 66 0F 28 D9 66 0F 29 54 24 60 66 0F 59 D2 66 0F C2 1D ?? ?? ?? ?? 00 66 0F 29 5C 24 70 66 0F 28 0D ?? ?? ?? ?? 66 0F 56 4C 24 30 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 44 24 40 66 0F 28 DC 66 0F 54 C4 66 0F 55 E1 66 0F 56 C4 66 0F 29 84 24 80 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 54 44 24 20 66 0F 28 E3 66 0F 54 C3 66 0F 55 D9 66 0F 28 CA 66 0F 56 C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 29 84 24 90 00 00 00 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 54 EC 66 0F 58 1D ?? ?? ?? ?? 66 0F 55 64 24 50 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 CA 66 0F 59 DA 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 54 54 24 20 66 0F 59 4C 24 60 66 0F 56 EC 66 0F 58 CB 66 0F 59 CD 66 0F 28 44 24 70 66 0F 58 CD 66 0F 59 8C 24 80 00 00 00 66 0F 54 54 24 70 66 0F 58 8C 24 90 00 00 00 66 0F 55 C1 66 0F 56 C2 48 81 C4 A8 00 00 00 C3 66 90 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "??_M@YAXPEAX_K1P6AX0@Z@Z"
		size = 105
		refs = "004f _guard_check_icall"
	strings:
		$1 = { 48 8B C4 4C 89 48 20 4C 89 40 18 48 89 50 10 53 56 57 41 56 48 83 EC 38 49 8B F1 49 8B D8 4C 8B F2 C6 40 C8 00 48 8B FA 49 0F AF F8 48 03 F9 48 89 78 08 48 8B C3 48 FF CB 48 89 5C 24 70 48 85 C0 74 17 49 2B FE 48 89 7C 24 60 48 8B CE E8 ?? ?? ?? ?? 48 8B CF FF D6 EB D9 C6 44 24 20 01 48 83 C4 38 41 5E 5F 5E 5B C3 }
	condition:
		$1
}

rule file_144_1_0 {
	meta:
		name = "?fin$0@?0???_M@YAXPEAX_K1P6AX0@Z@Z@4HA"
		size = 44
		refs = "0020 ?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 80 7D 20 00 75 16 4C 8B 4D 78 4C 8B 45 70 48 8B 55 68 48 8B 4D 60 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPEAU_EXCEPTION_POINTERS@@@Z"
		size = 28
		refs = "0017 terminate"
	strings:
		$1 = { 48 83 EC 28 48 8B 01 81 38 63 73 6D E0 74 07 33 C0 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_144_4_0 {
	meta:
		name = "?__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z"
		size = 98
		refs = "003c _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 10 48 89 74 24 18 48 89 4C 24 08 57 41 56 41 57 48 83 EC 50 49 8B F1 4D 8B F0 4C 8B FA 48 8B F9 33 DB 48 89 5C 24 28 49 3B DE 74 1A 49 2B FF 48 89 7C 24 70 48 8B CE E8 ?? ?? ?? ?? 48 8B CF FF D6 48 FF C3 EB DC EB 00 4C 8D 5C 24 50 49 8B 5B 28 49 8B 73 30 49 8B E3 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_144_5_0 {
	meta:
		name = "?filt$0@?0??__ArrayUnwind@@YAXPEAX_K1P6AX0@Z@Z@4HA"
		size = 65
		refs = "0035 terminate"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 89 4D 40 48 89 4D 30 48 8B 45 30 48 8B 08 48 89 4D 38 48 8B 45 38 81 38 63 73 6D E0 74 0C C7 45 20 00 00 00 00 8B 45 20 EB 06 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__avx_tan4"
		size = 2640
		refs = "000a __common_dtan_reduction_data 007e __common_dtan_data 0269 __common_dtan_cout_rare 02ca _2il0floatpacket_355 030d _2il0floatpacket_356 0373 _2il0floatpacket_357 05e2 _2il0floatpacket_358 0609 _2il0floatpacket_361 061b _2il0floatpacket_362 0624 _2il0floatpacket_359 0661 _2il0floatpacket_360 0679 _2il0floatpacket_364 068a _2il0floatpacket_363 06dc _2il0floatpacket_368 06ef _2il0floatpacket_365 06f8 _2il0floatpacket_366 0701 _2il0floatpacket_367 0743 _2il0floatpacket_369 0750 _2il0floatpacket_371 0759 _2il0floatpacket_370"
	strings:
		$1 = { 48 81 EC B8 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 D0 01 00 00 33 C0 C5 7C 11 B4 24 70 02 00 00 C5 7C 11 AC 24 90 01 00 00 C5 7C 11 A4 24 B0 01 00 00 C5 7C 11 9C 24 90 02 00 00 C5 7C 11 94 24 F0 01 00 00 C5 7C 11 8C 24 50 02 00 00 C5 7C 11 84 24 30 02 00 00 C5 FC 11 BC 24 10 02 00 00 C5 FC 11 B4 24 70 01 00 00 4C 89 AC 24 B0 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 10 15 ?? ?? ?? ?? 49 83 E5 C0 C5 FD 54 EA C5 D5 C2 0D ?? ?? ?? ?? 1E C5 ED 55 D0 C4 E3 7D 19 CB 01 C5 F0 C6 E3 DD C5 F8 50 CC 85 C9 0F 85 C1 01 00 00 C5 FD 10 3D ?? ?? ?? ?? C5 D5 59 35 ?? ?? ?? ?? C5 CD 58 CF C5 75 5C EF C5 15 59 05 ?? ?? ?? ?? C5 15 59 15 ?? ?? ?? ?? C5 15 59 25 ?? ?? ?? ?? C5 15 59 3D ?? ?? ?? ?? C4 41 55 5C C8 C4 41 35 5C DA C4 41 25 5C F4 C4 C1 0D 5C E7 C5 DD 59 EC C5 55 59 25 ?? ?? ?? ?? C5 55 59 2D ?? ?? ?? ?? C5 1D 58 35 ?? ?? ?? ?? C5 0D 59 FD C4 41 25 57 DB C5 E1 73 F1 3F C4 C3 7D 19 C8 01 C4 C1 49 73 F0 3F C4 C1 31 73 F0 3E C4 E3 65 18 FE 01 C5 C5 57 DA C5 E9 73 F1 3E C5 95 58 0D ?? ?? ?? ?? C5 85 58 3D ?? ?? ?? ?? C5 F5 59 F5 C5 45 59 C5 C4 43 6D 18 D1 01 C5 4D 58 0D ?? ?? ?? ?? C4 C1 2D C2 D3 0C C5 3D 58 15 ?? ?? ?? ?? C5 B5 59 ED C5 AD 59 CC C5 D5 58 2D ?? ?? ?? ?? C5 ED 55 E1 C5 6D 54 D5 C4 C1 5D 56 F2 C5 ED 54 E1 C5 ED 55 D5 C5 DD 56 FA C5 4D 5E C7 C5 BD 57 CB 85 C0 75 6E C5 FC 10 B4 24 70 01 00 00 C5 FC 10 BC 24 10 02 00 00 C5 7C 10 84 24 30 02 00 00 C5 7C 10 8C 24 50 02 00 00 C5 7C 10 94 24 F0 01 00 00 C5 7C 10 9C 24 90 02 00 00 C5 7C 10 A4 24 B0 01 00 00 C5 7C 10 AC 24 90 01 00 00 C5 7C 10 B4 24 70 02 00 00 C5 7C 10 BC 24 D0 01 00 00 4C 8B AC 24 B0 02 00 00 C5 FD 28 C1 48 81 C4 B8 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 84 33 D2 48 89 5C 24 28 8B DA 48 89 74 24 20 8B F0 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 4D 40 E9 53 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 C5 FD 10 15 ?? ?? ?? ?? 41 B8 00 00 F0 7F C4 C1 7D 11 45 00 C4 C1 79 6E F0 C5 6D 54 D5 C5 2D C2 CA 00 C5 F9 70 D6 11 C5 69 DB D0 C4 43 7D 19 CB 01 C4 C3 7D 19 C7 01 C4 C1 30 C6 DB DD C4 41 69 DB CF C4 C1 51 73 D1 34 C4 C1 21 73 D2 34 C4 C1 79 7E EA C5 79 7E D9 C5 FA 6F 15 ?? ?? ?? ?? C5 F8 11 44 24 20 C5 E9 DB C0 C4 C3 79 16 E8 02 47 8D 14 52 C4 43 79 16 DB 02 44 8D 0C 49 41 C1 E2 03 41 C1 E1 03 43 8D 0C 40 C1 E1 03 47 8D 1C 5B 41 C1 E3 03 C4 41 F9 6E 34 12 C5 7A 6F 0D ?? ?? ?? ?? C4 C1 F9 6E 4C 12 08 C5 F8 50 C3 C5 78 11 7C 24 30 C4 41 69 DB FF C4 C1 F9 6E 1C 11 C4 C1 F9 6E 74 11 10 C5 09 16 14 11 C4 41 79 D4 F1 C5 71 16 6C 11 08 C4 41 61 16 04 13 C4 C1 49 16 4C 13 10 C4 41 F9 6E 64 11 08 C5 E9 73 D1 20 C4 C1 F9 6E 7C 12 10 41 B9 00 00 00 80 C4 C1 01 D4 F1 C5 7A 6F 3D ?? ?? ?? ?? C5 79 11 54 24 50 C4 41 09 DB CF C4 C1 19 16 64 13 08 C4 41 29 DB E7 C5 C1 16 5C 11 10 48 8D 15 ?? ?? ?? ?? C4 C1 39 DB FF C4 C1 29 73 D6 20 C4 C1 71 DB CF C5 79 11 44 24 40 C4 C1 39 73 D5 20 C5 FA 7F 7C 24 60 C4 C1 11 DB C7 C5 91 73 D6 20 C4 41 49 DB F7 C5 B1 F4 F7 C4 C1 59 DB EF C5 A9 F4 F9 C5 F1 73 D7 20 C5 A1 73 D4 20 C5 A9 F4 FA C5 D9 73 D3 20 C5 B1 F4 D2 C5 FA 7F B4 24 B0 00 00 00 C5 E9 73 D2 20 C5 B1 F4 F5 C4 C1 61 DB DF C5 A9 F4 ED C5 C1 D4 FA C5 91 F4 D4 C5 89 F4 E4 C5 7A 7F 64 24 70 C4 41 09 F4 E4 C5 7A 7F 84 24 90 00 00 00 C5 FA 7F 84 24 A0 00 00 00 C5 7A 7F A4 24 C0 00 00 00 C4 41 09 F4 E0 C5 09 F4 C0 C4 C1 49 DB C7 C5 F9 D4 C7 C5 F1 D4 F8 C5 91 F4 C3 C5 F1 73 D0 20 C5 F9 73 D4 20 C5 E9 D4 D0 C5 7A 7F 9C 24 80 00 00 00 C4 C1 39 DB DF C4 41 31 F4 DB C5 F9 73 D7 20 C5 E1 D4 DA C5 E9 73 D6 20 C4 C1 39 73 D0 20 C5 F1 D4 E3 C5 D1 D4 DA C4 C1 21 DB CF C4 C1 21 73 D3 20 C5 F1 D4 EB C5 F9 D4 F5 C5 91 F4 84 24 A0 00 00 00 C4 C1 79 D4 C0 C4 C1 19 DB CF C5 E1 73 D4 20 C5 F1 D4 D0 C5 A9 F4 8C 24 80 00 00 00 C5 29 F4 54 24 60 C5 61 D4 C2 C4 C1 71 D4 C3 C5 FA 6F 9C 24 B0 00 00 00 C5 D1 73 D6 20 C4 C1 61 DB D7 C4 C1 19 73 D4 20 C5 E9 D4 D0 C5 D1 D4 EA C5 91 F4 94 24 90 00 00 00 C5 11 F4 6C 24 70 C4 C1 69 D4 D4 C5 FA 6F 8C 24 C0 00 00 00 C4 C1 21 73 D0 20 C4 C1 71 DB C7 C5 99 73 F6 20 C5 F9 D4 C2 C5 A1 D4 D0 C5 79 10 5C 24 40 C5 F9 73 D5 20 C4 C1 21 73 D3 20 C4 C1 51 DB EF C4 41 31 F4 CB C5 A1 73 D3 20 C4 41 29 D4 D3 C4 41 31 DB CF C4 C1 39 73 F0 20 C4 41 31 D4 CA C4 C1 79 D4 C1 C5 79 10 4C 24 50 C5 E1 73 F0 20 C4 C1 21 73 D1 20 C5 B1 73 D1 20 C4 41 09 F4 F3 C5 F9 73 D2 20 C5 61 D4 D5 C4 C1 11 D4 D9 C4 41 09 DB DF C4 41 79 6E E9 C5 A1 D4 EB C5 F9 D4 C5 C5 89 73 F0 20 C4 C1 69 DB D7 C4 C1 79 70 F5 11 C4 C1 41 DB CF C4 41 59 DB FF C4 C1 59 73 D2 0C C5 89 D4 D2 C4 41 39 D4 CF C5 99 D4 F9 C5 49 DB 74 24 20 C5 E1 73 D2 0C C5 7A 6F 3D ?? ?? ?? ?? C5 49 DB 6C 24 30 C4 C1 09 EF C7 C4 41 11 EF C7 C5 59 EB D8 C4 C1 61 EB E8 C4 E3 25 18 CD 01 C5 7A 6F 1D ?? ?? ?? ?? C4 C1 09 EF EB C4 C1 11 EF DB C5 7A 6F 1D ?? ?? ?? ?? C4 62 7D 1A 25 ?? ?? ?? ?? C5 9D 58 E1 C4 C1 5D 5C F4 C5 21 DB E7 C4 41 21 DB D9 C5 C1 73 D7 18 C4 C1 31 73 D1 18 C5 F5 5C C6 C4 C1 71 73 F4 1C C4 C1 19 73 F3 1C C5 F1 EB CD C5 19 EB DB C5 FA 6F 35 ?? ?? ?? ?? C4 43 75 18 E3 01 C4 E3 55 18 DB 01 C5 1D 5C E3 C5 FA 6F 1D ?? ?? ?? ?? C4 41 61 DB D2 C5 E1 DB D2 C5 7A 6F 1D ?? ?? ?? ?? C4 C1 29 73 F2 28 C5 E1 73 F2 28 C4 41 09 EF F3 C5 29 EB D7 C4 C1 11 EF EB C4 C1 61 EB C9 C4 41 29 EB DE C5 71 EB ED C4 C3 25 18 FD 01 C4 E3 0D 18 ED 01 C5 45 5C D5 C4 C1 7D 58 D2 C5 FD 5C C2 C5 AD 58 C0 C4 C1 7D 58 DC C4 62 7D 1A 25 ?? ?? ?? ?? C4 41 6D 54 CC C4 41 6D 5C F1 C4 62 7D 1A 1D ?? ?? ?? ?? C4 62 7D 1A 15 ?? ?? ?? ?? C4 E2 7D 1A 2D ?? ?? ?? ?? C4 41 2D 59 E6 C4 C1 55 59 C9 C5 25 59 EB C4 C1 55 59 FE C4 C1 2D 59 C1 C5 1D 58 D1 C5 95 58 D7 C5 2D 58 CA C4 41 7D 58 E1 C4 C1 7D 5C C4 C4 41 7D 58 D1 C4 C1 7D 10 45 00 C4 62 7D 1A 1D ?? ?? ?? ?? C4 C1 7D 54 DB C5 7A 6F 1D ?? ?? ?? ?? C4 E2 7D 1A 2D ?? ?? ?? ?? C5 E5 C2 FD 1E C5 65 C2 F5 12 C5 8D 54 C8 C4 41 45 54 EC C4 C1 75 56 D5 C4 41 45 54 CA C4 C1 6D 58 D1 C4 C3 7D 19 E0 01 C5 D9 DB E6 C5 39 DB C6 C4 41 59 DB D3 C4 41 39 DB CB C4 41 79 7E D3 C5 79 7E C9 45 6B CB 68 6B C9 68 C4 43 79 16 D0 02 C4 43 79 16 CA 02 45 6B C0 68 45 6B DA 68 C4 C1 F9 6E B4 11 40 01 00 00 C4 61 F9 6E 9C 11 40 01 00 00 C4 41 F9 6E 84 11 50 01 00 00 C4 61 F9 6E B4 11 50 01 00 00 C4 41 49 16 94 10 40 01 00 00 C4 C1 21 16 9C 13 40 01 00 00 C4 C1 F9 6E 8C 11 58 01 00 00 C4 41 F9 6E 9C 11 68 01 00 00 C4 C1 39 16 AC 10 50 01 00 00 C4 E1 F9 6E B4 11 58 01 00 00 C4 61 F9 6E 84 11 68 01 00 00 C4 41 09 16 A4 13 50 01 00 00 C4 41 71 16 AC 10 58 01 00 00 C4 C1 49 16 A4 13 58 01 00 00 C4 41 F9 6E B4 11 70 01 00 00 C4 E1 F9 6E 8C 11 70 01 00 00 C4 C1 71 16 B4 13 70 01 00 00 C4 E3 2D 18 FB 01 C4 C1 21 16 9C 10 68 01 00 00 C4 43 55 18 CC 01 C4 C1 39 16 AC 13 68 01 00 00 C4 41 09 16 A4 10 70 01 00 00 C4 63 15 18 D4 01 C4 C1 F9 6E A4 11 78 01 00 00 C4 41 59 16 9C 10 78 01 00 00 C4 63 65 18 ED 01 C4 E1 F9 6E 9C 11 78 01 00 00 C4 41 61 16 84 13 78 01 00 00 C4 C1 F9 6E AC 11 80 01 00 00 C5 15 59 EA C4 63 1D 18 F6 01 C4 E1 F9 6E B4 11 80 01 00 00 C4 41 51 16 A4 10 80 01 00 00 C4 C1 49 16 A4 13 80 01 00 00 C4 C1 F9 6E B4 11 90 01 00 00 C4 C3 25 18 C8 01 C4 41 F9 6E 9C 11 88 01 00 00 C4 61 F9 6E 84 11 88 01 00 00 C4 C1 21 16 9C 10 88 01 00 00 C4 61 F9 6E 9C 11 90 01 00 00 C5 F5 59 CA C4 E3 1D 18 EC 01 C4 41 39 16 A4 13 88 01 00 00 C4 41 F9 6E 84 11 98 01 00 00 C4 C1 49 16 A4 10 90 01 00 00 C4 C1 39 16 B4 10 98 01 00 00 C4 43 65 18 E4 01 C4 C1 21 16 9C 13 90 01 00 00 C4 61 F9 6E 9C 11 98 01 00 00 C4 41 21 16 84 13 98 01 00 00 C5 1D 59 E2 C5 9D 58 ED C4 E3 5D 18 DB 01 C4 C1 F9 6E A4 11 A0 01 00 00 C4 41 59 16 9C 10 A0 01 00 00 C4 43 4D 18 C0 01 C4 E1 F9 6E B4 11 A0 01 00 00 C4 C1 49 16 A4 13 A0 01 00 00 C5 3D 59 C2 C5 BD 58 DB C4 63 25 18 DC 01 C5 C5 5C E2 C5 FD 5A FC C5 F8 53 F7 C5 FC 5A F6 C5 DD 59 E6 C4 43 05 18 FF 01 C5 85 5C FC C5 C5 59 E7 C5 5D 58 FF C5 CD 59 FC C5 C5 58 E6 C4 41 5D 59 FF C5 85 58 F6 C4 41 15 58 FA C4 41 4D 59 D1 C5 6D 59 CA C4 41 2D 58 D7 C4 41 75 58 FE C4 41 25 59 D9 C4 C1 35 59 C9 C4 41 55 59 C9 C5 25 58 F3 C4 C1 35 58 DF C5 0D 59 F1 C5 8D 58 E3 C5 DD 59 D2 C4 C1 6D 58 CA E9 60 F7 FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__avx_ceilf8"
		size = 16
	strings:
		$1 = { C4 E3 7D 08 C0 02 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__avx_log4"
		size = 640
		refs = "000a __common_dlog_data 0274 __common_dlog_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 05 ?? ?? ?? ?? C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 8F 01 00 00 C5 FD 54 1D ?? ?? ?? ?? 49 83 E5 C0 C5 E5 56 35 ?? ?? ?? ?? C5 FD 5A EE C5 F8 53 CD C5 FC 5A D1 C4 E3 7D 09 D2 00 C5 E1 73 D0 14 C4 E3 7D 19 C4 01 C5 D1 73 D4 14 C5 E0 C6 CD DD C5 FD C2 1D ?? ?? ?? ?? 11 C5 FD C2 25 ?? ?? ?? ?? 16 C5 FE E6 C9 C5 E5 56 E4 C4 E3 7D 19 E3 01 C5 D8 C6 EB DD C5 CD 54 25 ?? ?? ?? ?? C5 CD 5C F4 C5 F8 50 D5 C5 DD 59 E2 C5 CD 59 F2 C5 DD 5C 1D ?? ?? ?? ?? C5 E5 58 DE C5 C9 73 D2 28 C4 E3 7D 19 D5 01 C5 D1 73 D5 28 C4 C1 79 7E E9 C5 ED C2 15 ?? ?? ?? ?? 1E C5 F9 7E F1 4D 63 C9 C4 C3 79 16 EA 02 4D 63 D2 C4 C3 79 16 F0 02 C4 C1 7B 10 B4 01 40 A0 BF FF C5 ED 54 15 ?? ?? ?? ?? C4 C1 49 16 AC 02 40 A0 BF FF C5 ED 56 35 ?? ?? ?? ?? C5 F5 5C CE C5 E5 59 35 ?? ?? ?? ?? C5 F5 59 15 ?? ?? ?? ?? C5 CD 58 0D ?? ?? ?? ?? C5 E5 59 F3 48 63 C9 4D 63 C0 C5 F5 59 CE C5 FB 10 A4 01 40 A0 BF FF C4 C1 59 16 A4 00 40 A0 BF FF C4 E3 5D 18 E5 01 C5 E5 59 2D ?? ?? ?? ?? C5 D5 58 2D ?? ?? ?? ?? C5 F5 58 CD C5 F5 59 EE C5 E5 58 DD C5 E5 58 E4 C5 DD 58 CA 85 D2 75 1D C5 FC 10 B4 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 D5 33 C0 C5 FC 11 BC 24 20 01 00 00 C5 7C 11 84 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 48 01 00 00 8B D8 48 89 B4 24 40 01 00 00 8B F2 0F A3 DE 72 6A FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 20 01 00 00 C5 7C 10 84 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 48 01 00 00 48 8B B4 24 40 01 00 00 E9 08 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB 82 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "__common_datan2_cout_rare"
		size = 4464
		refs = "0011 _vmldAtanHATab"
	strings:
		$1 = { 57 48 81 EC C0 00 00 00 0F 29 74 24 70 F2 0F 10 35 ?? ?? ?? ?? F2 0F 10 01 0F 28 CE F2 0F 59 C1 F2 0F 59 0A F2 0F 11 44 24 38 F2 0F 11 4C 24 40 0F B7 44 24 3E 25 F0 7F 00 00 8A 54 24 47 44 0F B7 5C 24 46 80 E2 80 41 81 E3 F0 7F 00 00 C1 E8 04 8A 4C 24 3F C0 E9 07 C0 EA 07 44 0F 29 BC 24 90 00 00 00 44 0F 29 AC 24 A0 00 00 00 44 0F 29 9C 24 80 00 00 00 44 0F 29 84 24 B0 00 00 00 41 C1 EB 04 48 8B 3D ?? ?? ?? ?? 3D FF 07 00 00 0F 84 64 10 00 00 41 81 FB FF 07 00 00 0F 84 9C 0F 00 00 85 C0 75 15 F7 44 24 3C FF FF 0F 00 75 0B 83 7C 24 38 00 0F 84 AC 0E 00 00 45 85 DB 75 15 F7 44 24 44 FF FF 0F 00 75 0B 83 7C 24 40 00 0F 84 7F 0E 00 00 41 F7 DB F2 0F 11 44 24 38 44 03 D8 F2 0F 11 4C 24 40 44 8A 54 24 3F 44 8A 4C 24 47 41 80 E2 7F 41 80 E1 7F 41 83 FB CA 0F 8E B3 0D 00 00 41 83 FB 36 0F 8D 5E 0D 00 00 44 88 4C 24 47 84 D2 44 88 54 24 3F 75 0F F2 44 0F 10 05 ?? ?? ?? ?? 45 0F 28 D8 EB 12 F2 44 0F 10 05 ?? ?? ?? ?? F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 10 4C 24 38 85 C0 F2 0F 10 6C 24 40 0F 28 D1 F2 0F 5E D5 4C 8B 4C 24 38 F2 0F 11 54 24 58 0F 8E C0 0E 00 00 3D FE 07 00 00 7D 24 4C 89 4C 24 38 05 01 FC FF FF 49 C1 E9 30 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 3E EB 17 F2 0F 10 05 ?? ?? ?? ?? B8 FE 03 00 00 F2 0F 59 C8 F2 0F 11 4C 24 38 F7 D8 05 FF 03 00 00 48 89 7C 24 40 25 FF 07 00 00 48 C1 EF 30 C1 E0 04 81 E7 0F 80 FF FF 0B F8 66 89 7C 24 46 F2 0F 10 44 24 40 F2 0F 59 E8 66 0F 2F 15 ?? ?? ?? ?? 0F 82 03 08 00 00 F2 0F 10 25 ?? ?? ?? ?? 0F 28 C5 F2 0F 59 C4 B8 71 00 00 00 F2 0F 11 44 24 20 0F 28 C5 F2 44 0F 10 7C 24 20 F2 0F 11 54 24 40 F2 44 0F 5C FD F2 44 0F 11 7C 24 28 F2 0F 10 5C 24 20 F2 0F 10 54 24 28 44 8B 54 24 44 45 8B DA 41 81 E2 00 00 08 00 41 81 E3 00 00 F0 FF 41 81 CA 00 00 04 00 F2 0F 5C DA F2 0F 11 5C 24 20 45 0B DA F2 0F 10 4C 24 20 4C 8D 15 ?? ?? ?? ?? C7 44 24 40 00 00 00 00 F2 0F 5C C1 44 89 5C 24 44 4D 8B DA F2 0F 11 44 24 28 F2 0F 10 5C 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 28 F2 0F 59 D9 F2 0F 59 C1 F2 44 0F 10 2D ?? ?? ?? ?? F2 41 0F 59 DD F2 41 0F 59 C5 44 0F 28 FB 44 0F B7 4C 24 5E F2 44 0F 58 F8 F2 44 0F 11 7C 24 20 41 81 E1 F0 7F 00 00 F2 0F 10 54 24 20 41 C1 E9 04 F2 0F 5C DA 8B 7C 24 5C F2 0F 58 D8 F2 0F 10 44 24 38 81 E7 FF FF 0F 00 F2 0F 11 5C 24 28 44 0F 28 F8 F2 0F 10 54 24 20 F2 44 0F 10 6C 24 28 F2 44 0F 58 FA F2 44 0F 11 7C 24 20 44 0F 28 F8 F2 0F 10 5C 24 20 41 C1 E1 14 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 44 0B CF F2 44 0F 10 7C 24 20 41 81 C1 00 00 40 C0 F2 0F 10 5C 24 28 41 C1 F9 13 F2 44 0F 58 FB F2 44 0F 11 7C 24 30 44 0F 28 F8 F2 0F 10 5C 24 28 41 83 F9 71 F2 0F 58 D3 F2 0F 11 54 24 28 41 0F 4C C1 F2 0F 10 54 24 30 03 C0 48 63 C0 F2 44 0F 5C FA F2 44 0F 11 7C 24 30 F2 0F 10 5C 24 28 F2 0F 10 54 24 30 F2 0F 58 DA F2 0F 11 5C 24 30 F2 0F 10 5C 24 20 F2 0F 10 54 24 30 F2 41 0F 58 D5 44 0F 28 EB F2 44 0F 59 EC F2 44 0F 11 6C 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 20 44 0F 28 F8 F2 44 0F 10 6C 24 20 F2 44 0F 59 3D ?? ?? ?? ?? F2 41 0F 5C DD F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 6C 24 28 F2 44 0F 11 7C 24 20 F2 41 0F 58 D5 F2 44 0F 10 6C 24 20 F2 44 0F 5C 6C 24 38 F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 7C 24 28 F2 45 0F 5C EF F2 44 0F 11 6C 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C C7 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 44 0F 10 6C 24 28 F2 0F 59 C1 F2 44 0F 59 E9 0F 28 C8 F2 41 0F 58 CD F2 0F 11 4C 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C C7 F2 41 0F 58 C5 44 0F 28 ED F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 44 0F 10 7C 24 28 F2 44 0F 58 E8 F2 44 0F 11 6C 24 20 44 0F 28 ED F2 0F 10 4C 24 20 F2 44 0F 5C E9 F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 20 F2 0F 10 4C 24 28 F2 44 0F 58 E9 F2 44 0F 11 6C 24 30 F2 0F 10 4C 24 28 F2 0F 58 C1 F2 0F 11 44 24 28 F2 0F 10 44 24 30 F2 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 44 24 28 F2 0F 10 6C 24 30 F2 0F 58 C5 F2 0F 11 44 24 30 F2 44 0F 10 6C 24 20 F2 0F 10 4C 24 30 F2 41 0F 58 CF 45 0F 28 FD F2 44 0F 59 FC F2 44 0F 11 7C 24 20 44 0F 28 FE F2 0F 10 44 24 20 F2 41 0F 5C C5 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 0F 10 6C 24 28 F2 0F 5C C5 F2 0F 11 44 24 20 F2 0F 10 6C 24 20 F2 44 0F 5C ED F2 44 0F 11 6C 24 28 F2 0F 10 6C 24 20 F2 44 0F 5E FD 41 0F 28 C7 F2 0F 59 C4 F2 44 0F 10 6C 24 28 F2 0F 11 44 24 28 F2 41 0F 58 CD F2 0F 10 44 24 28 F2 41 0F 5C C7 F2 0F 11 44 24 30 F2 0F 10 44 24 28 F2 44 0F 10 6C 24 30 F2 41 0F 5C C5 F2 0F 11 44 24 30 F2 44 0F 10 6C 24 30 F2 41 0F 59 ED F2 0F 5C F5 F2 0F 10 6C 24 30 F2 0F 59 CD F2 0F 11 4C 24 28 F2 0F 10 4C 24 28 F2 0F 5C F1 F2 0F 11 74 24 28 F2 0F 10 6C 24 28 48 8B 7C 24 30 F2 0F 10 74 24 28 F2 0F 10 44 24 30 48 89 7C 24 48 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 EE F2 0F 59 E8 F2 0F 10 74 24 48 44 0F 28 ED 0F 28 C6 F2 0F 59 C3 F2 44 0F 59 EA F2 0F 59 DD F2 0F 59 D6 F2 44 0F 58 EB 44 0F 28 F8 F2 44 0F 58 EA F2 44 0F 11 6C 24 20 F2 0F 10 54 24 20 F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 58 FA F2 44 0F 11 7C 24 20 F2 0F 10 4C 24 20 F2 0F 5C C1 F2 0F 58 C2 F2 0F 11 44 24 28 F2 44 0F 10 7C 24 20 41 0F 28 F7 41 0F 28 EF F2 41 0F 59 F7 F2 0F 59 EC F2 0F 59 DE F2 0F 10 44 24 28 F2 0F 11 6C 24 20 F2 44 0F 10 6C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 45 0F 5C EF F2 0F 59 DE F2 44 0F 11 6C 24 28 F2 0F 10 54 24 20 F2 0F 10 4C 24 28 F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C D1 F2 0F 59 DE F2 0F 11 54 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 DE F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 F3 F2 0F 10 5C 24 20 F2 0F 59 E6 F2 44 0F 5C FB F2 44 0F 11 7C 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 7C 24 28 F2 0F 11 64 24 20 F2 41 0F 58 C7 F2 0F 10 64 24 20 F2 0F 5C E6 F2 0F 11 64 24 28 F2 0F 10 4C 24 20 F2 0F 10 6C 24 28 F2 0F 5C CD F2 0F 11 4C 24 20 F2 0F 10 54 24 20 F2 0F 5C F2 F2 0F 11 74 24 28 F2 0F 10 74 24 20 F2 0F 10 5C 24 28 0F 28 EE 44 0F 28 FB F2 44 0F 59 F8 F2 0F 59 F0 F2 41 0F 59 DD F2 41 0F 59 ED F2 44 0F 58 FE 0F 28 CD 0F 28 D5 F2 44 0F 58 FB F2 41 0F 58 CD F2 44 0F 11 7C 24 20 F2 0F 10 74 24 20 F2 0F 11 4C 24 20 F2 0F 10 64 24 20 F2 0F 5C D4 F2 0F 11 54 24 28 F2 0F 10 5C 24 20 F2 0F 10 4C 24 28 F2 0F 58 D9 F2 0F 11 5C 24 30 F2 0F 10 64 24 28 F2 44 0F 58 EC F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 30 F2 41 0F 5C ED F2 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 4C 24 30 F2 0F 58 D1 F2 0F 11 54 24 30 4C 8B 4C 24 20 4C 89 4C 24 48 F2 0F 10 4C 24 48 0F 28 E1 F2 0F 10 5C 24 30 F2 41 0F 58 24 C2 F2 0F 58 C3 F2 0F 11 64 24 20 F2 0F 58 C6 F2 0F 10 6C 24 20 0F 28 F1 F2 0F 11 44 24 50 F2 0F 5C F5 F2 0F 11 74 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 FD F2 44 0F 11 7C 24 30 F2 0F 10 64 24 28 F2 41 0F 58 24 C3 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 0F 5C CD F2 0F 11 4C 24 30 F2 0F 10 5C 24 28 F2 0F 10 54 24 30 F2 0F 58 DA F2 0F 11 5C 24 30 4C 8B 4C 24 20 F2 0F 10 4C 24 30 4C 89 4C 24 48 48 8D 3D ?? ?? ?? ?? F2 0F 58 C1 C0 E1 07 F2 0F 58 44 C7 08 8A C2 C0 E0 07 F2 0F 11 44 24 50 41 0F 28 C0 49 C1 E9 38 44 8A 54 24 57 45 8A DA 41 C0 EA 07 41 80 E3 7F 41 80 E1 7F 41 32 D2 44 0A C8 44 88 4C 24 4F F2 0F 10 74 24 48 0F 28 D6 F2 0F 58 C6 C0 E2 07 F2 0F 11 44 24 20 F2 0F 10 4C 24 20 F2 0F 5C D1 F2 0F 11 54 24 28 44 0A DA F2 0F 10 64 24 20 F2 0F 10 5C 24 28 44 88 5C 24 57 F2 0F 58 E3 F2 0F 11 64 24 30 F2 0F 10 6C 24 28 F2 44 0F 58 C5 F2 44 0F 11 44 24 28 F2 44 0F 10 44 24 30 F2 41 0F 5C F0 F2 0F 11 74 24 30 F2 44 0F 10 7C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 58 FD F2 44 0F 11 7C 24 30 48 8B 54 24 20 F2 0F 10 44 24 30 48 89 54 24 48 F2 0F 58 44 24 50 F2 41 0F 58 C3 F2 44 0F 10 5C 24 48 F2 0F 11 44 24 50 F2 44 0F 58 D8 F2 44 0F 11 5C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 4C 24 60 49 89 08 E9 0A 06 00 00 F2 0F 10 4C 24 38 44 8A CA 0F 28 C1 F2 0F 59 05 ?? ?? ?? ?? 41 C0 E1 07 C0 E1 07 F2 0F 11 44 24 20 F2 0F 10 54 24 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C 54 24 38 F2 0F 11 54 24 28 0F 28 D5 F2 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 0F 59 D0 F2 41 0F 5C E5 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C CF F2 0F 11 4C 24 28 F2 0F 10 4C 24 20 F2 0F 10 5C 24 28 F2 0F 11 54 24 20 0F 28 D6 F2 0F 10 64 24 20 F2 0F 5C E5 F2 0F 11 64 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C EC F2 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 41 0F 5E D7 0F 28 EA F2 0F 59 E8 F2 0F 10 64 24 28 F2 0F 11 6C 24 28 F2 44 0F 10 6C 24 28 F2 44 0F 5C EA F2 44 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 6C 24 30 F2 0F 5C D5 F2 0F 11 54 24 30 F2 0F 10 6C 24 30 F2 44 0F 59 FD F2 41 0F 5C F7 F2 44 0F 10 7C 24 30 F2 41 0F 59 E7 F2 0F 11 64 24 28 F2 0F 10 64 24 28 F2 0F 5C F4 F2 0F 11 74 24 28 F2 0F 10 6C 24 28 48 8B 44 24 30 F2 0F 10 74 24 28 F2 0F 10 64 24 30 48 89 44 24 48 F2 0F 10 54 24 48 44 0F 28 EA F2 0F 58 2D ?? ?? ?? ?? F2 44 0F 59 E9 F2 0F 59 D3 F2 0F 59 EE F2 0F 59 EC 44 0F 28 FD F2 44 0F 59 FB F2 0F 59 CD F2 44 0F 58 F9 41 0F 28 CD F2 44 0F 58 FA F2 44 0F 11 7C 24 20 F2 0F 10 5C 24 20 F2 0F 58 CB F2 0F 11 4C 24 20 F2 0F 10 74 24 20 F2 44 0F 5C EE F2 44 0F 58 EB F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 58 F2 45 0F 59 ED F2 41 0F 59 DD F2 0F 10 54 24 20 0F 28 F2 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 F0 F2 41 0F 59 DD F2 0F 10 64 24 28 F2 0F 11 74 24 20 F2 0F 10 6C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 0F 5C EA F2 41 0F 59 DD F2 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 0F 10 4C 24 28 F2 0F 58 1D ?? ?? ?? ?? F2 44 0F 5C F9 F2 41 0F 59 DD F2 44 0F 11 7C 24 20 F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 41 0F 59 DD F2 44 0F 10 6C 24 20 F2 0F 59 C3 F2 41 0F 5C D5 F2 0F 11 54 24 28 F2 0F 10 4C 24 20 F2 0F 10 54 24 28 F2 0F 11 44 24 20 F2 0F 58 E2 F2 0F 10 44 24 20 F2 0F 5C C3 F2 0F 11 44 24 28 F2 0F 10 6C 24 20 F2 0F 10 74 24 28 F2 0F 5C EE F2 0F 11 6C 24 20 F2 0F 10 44 24 20 F2 0F 5C D8 F2 0F 11 5C 24 28 F2 0F 10 54 24 20 F2 0F 10 5C 24 28 0F 28 EA 44 0F 28 EB F2 44 0F 59 EC F2 0F 59 D4 F2 0F 59 D9 F2 0F 59 E9 F2 44 0F 58 EA 44 0F 28 FD 0F 28 D5 F2 44 0F 58 EB F2 44 0F 58 F9 F2 44 0F 11 6C 24 20 F2 0F 10 74 24 20 F2 44 0F 11 7C 24 20 F2 0F 10 44 24 20 F2 0F 5C D0 F2 0F 11 54 24 28 F2 44 0F 10 6C 24 20 F2 0F 10 5C 24 28 F2 44 0F 58 EB F2 44 0F 11 6C 24 30 F2 44 0F 10 7C 24 28 F2 41 0F 58 CF F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 0F 5C E9 F2 0F 11 6C 24 30 F2 0F 10 54 24 28 F2 0F 10 44 24 30 F2 0F 58 D0 F2 0F 11 54 24 30 48 8B 7C 24 20 F2 0F 10 4C 24 30 48 89 7C 24 48 F2 0F 58 E1 48 C1 EF 38 F2 0F 58 E6 40 80 E7 7F 41 0A F9 40 88 7C 24 4F F2 0F 11 64 24 50 41 0F 28 E0 F2 0F 10 6C 24 48 0F 28 C5 F2 0F 58 E5 F2 0F 11 64 24 20 F2 0F 10 64 24 20 44 8A 54 24 57 45 8A DA 41 C0 EA 07 F2 0F 5C C4 F2 0F 11 44 24 28 F2 0F 10 54 24 20 F2 0F 10 4C 24 28 41 32 D2 41 80 E3 7F C0 E2 07 F2 0F 58 D1 F2 0F 11 54 24 30 F2 0F 10 5C 24 28 F2 44 0F 58 C3 F2 44 0F 11 44 24 28 44 0A DA F2 44 0F 10 44 24 30 44 88 5C 24 57 F2 41 0F 5C E8 F2 0F 11 6C 24 30 F2 0F 10 4C 24 28 F2 0F 10 44 24 30 F2 0F 58 C8 F2 0F 11 4C 24 30 48 8B 54 24 20 F2 0F 10 54 24 30 48 89 54 24 48 F2 0F 58 54 24 50 F2 41 0F 58 D3 F2 44 0F 10 5C 24 48 F2 0F 11 54 24 50 F2 44 0F 58 DA F2 44 0F 11 5C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 4C 24 60 49 89 08 E9 83 01 00 00 41 83 FB 4A 0F 8D F4 00 00 00 44 88 54 24 3F F2 0F 5E 4C 24 38 F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 5C C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 38 01 00 00 84 D2 0F 85 03 01 00 00 44 88 54 24 3F 44 88 4C 24 47 F2 0F 10 4C 24 38 F2 0F 5E 4C 24 40 F2 0F 11 4C 24 60 0F B7 44 24 66 A9 F0 7F 00 00 74 36 C0 E1 07 F2 0F 58 F1 F2 0F 11 74 24 20 F2 0F 10 44 24 20 F2 0F 59 C8 F2 0F 11 4C 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 D2 00 00 00 F2 0F 59 C9 C0 E1 07 F2 0F 11 4C 24 20 F2 0F 10 44 24 20 F2 0F 58 44 24 60 F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 E9 9A 00 00 00 85 C0 75 11 F7 44 24 3C FF FF 0F 00 75 07 E9 EA 01 00 00 74 2F F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 EB 56 84 D2 75 25 C0 E1 07 48 8B 05 ?? ?? ?? ?? 48 89 44 24 60 48 C1 E8 38 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 EB 2D F2 0F 10 05 ?? ?? ?? ?? C0 E1 07 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 60 8A 44 24 67 24 7F 0A C1 88 44 24 67 48 8B 54 24 60 49 89 10 0F 28 74 24 70 33 C0 44 0F 28 84 24 B0 00 00 00 44 0F }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "__sse2_log102"
		size = 496
		refs = "0022 __common_dlog10_data 0072 _2il0floatpacket_52 01e0 __common_dlog10_cout_rare"
	strings:
		$1 = { 48 81 EC E8 00 00 00 0F 28 E0 44 0F 29 BC 24 C0 00 00 00 0F 28 E8 44 0F 29 B4 24 D0 00 00 00 4C 8D 05 ?? ?? ?? ?? 4C 89 AC 24 E0 00 00 00 4C 8D 6C 24 6F 44 0F 28 35 ?? ?? ?? ?? 49 83 E5 C0 44 0F 54 F0 44 0F 56 35 ?? ?? ?? ?? 66 41 0F 5A CE 66 0F C2 25 ?? ?? ?? ?? 01 66 0F C2 2D ?? ?? ?? ?? 06 0F 16 C9 0F 56 E5 0F 53 D1 66 0F 50 D4 0F 28 1D ?? ?? ?? ?? 0F 28 C8 66 0F 73 D1 14 44 0F 5A FA 66 44 0F 58 FB 66 44 0F 5C FB 66 0F 70 D1 DD 41 0F 28 E7 F3 0F E6 DA 0F 28 15 ?? ?? ?? ?? 66 0F 73 D4 28 41 0F 54 D6 85 D2 66 44 0F 5C F2 66 41 0F 59 D7 66 45 0F 59 F7 66 0F 5C 15 ?? ?? ?? ?? 66 0F 7E E0 66 0F 70 EC 02 0F 28 25 ?? ?? ?? ?? 66 41 0F C2 E7 01 66 41 0F 58 D6 66 0F 7E E9 0F 54 25 ?? ?? ?? ?? 44 0F 28 FA 0F 56 25 ?? ?? ?? ?? 66 0F 5C DC 66 44 0F 59 FA 66 0F 59 1D ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 44 0F 28 35 ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 44 0F 59 F2 66 41 0F 59 E7 66 44 0F 58 35 ?? ?? ?? ?? 66 0F 59 15 ?? ?? ?? ?? 66 41 0F 58 E6 66 41 0F 59 E7 48 63 C0 66 0F 58 E2 48 63 C9 F2 42 0F 10 8C 00 40 90 BF FF 66 42 0F 16 8C 01 40 90 BF FF 66 0F 58 E1 66 0F 58 E3 75 25 44 0F 28 B4 24 D0 00 00 00 0F 28 C4 44 0F 28 BC 24 C0 00 00 00 4C 8B AC 24 E0 00 00 00 48 81 C4 E8 00 00 00 C3 41 0F 29 45 00 41 0F 29 65 40 74 CF 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 65 40 EB 97 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D7 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_160_4_0 {
	meta:
		name = "?find_pe_section@@YAPEAU_IMAGE_SECTION_HEADER@@QEAE_K@Z"
		size = 73
	strings:
		$1 = { 4C 63 41 3C 41 0F B7 44 08 14 4D 8D 0C 08 48 83 C0 18 4C 03 C8 41 0F B7 44 08 06 48 8D 0C 80 4D 8D 04 C9 4D 3B C8 74 1E 41 8B 49 0C 48 3B D1 72 0B 41 8B 41 08 03 C1 48 3B D0 72 06 49 83 C1 28 EB E1 49 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_160_5_0 {
	meta:
		name = "?is_potentially_valid_image_base@@YA_NQEAX@Z"
		size = 46
	strings:
		$1 = { 48 85 C9 75 03 32 C0 C3 B8 4D 5A 00 00 66 39 01 75 F3 48 63 41 3C 48 03 C1 81 38 50 45 00 00 75 E4 B9 0B 02 00 00 66 39 48 18 0F 94 C0 C3 }
	condition:
		$1
}

rule file_160_7_0 {
	meta:
		name = "__scrt_acquire_startup_lock"
		size = 57
		refs = "0005 __scrt_is_ucrt_dll_in_use 0028 __scrt_native_startup_lock"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 85 C0 74 21 65 48 8B 04 25 30 00 00 00 48 8B 48 08 EB 05 48 3B C8 74 14 33 C0 F0 48 0F B1 0D ?? ?? ?? ?? 75 EE 32 C0 48 83 C4 28 C3 B0 01 EB F7 }
	condition:
		$1
}

rule file_160_8_0 {
	meta:
		name = "__scrt_dllmain_after_initialize_c"
		size = 52
		refs = "0005 __scrt_is_ucrt_dll_in_use 000e __isa_available_init 0015 _get_startup_argv_mode 001c _configure_narrow_argv 0029 _initialize_narrow_environment"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 85 C0 74 07 E8 ?? ?? ?? ?? EB 19 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 85 C0 74 04 32 C0 EB 07 E8 ?? ?? ?? ?? B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_160_9_0 {
	meta:
		name = "__scrt_dllmain_before_initialize_c"
		size = 21
		refs = "0007 __scrt_initialize_onexit_tables"
	strings:
		$1 = { 48 83 EC 28 33 C9 E8 ?? ?? ?? ?? 84 C0 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_160_10_0 {
	meta:
		name = "__scrt_dllmain_crt_thread_attach"
		size = 40
		refs = "0005 __vcrt_thread_attach 0012 __acrt_thread_attach 001b __vcrt_thread_detach"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 84 C0 75 04 32 C0 EB 12 E8 ?? ?? ?? ?? 84 C0 75 07 E8 ?? ?? ?? ?? EB EC B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_160_11_0 {
	meta:
		name = "__scrt_dllmain_crt_thread_detach"
		size = 21
		refs = "0005 __acrt_thread_detach 000a __vcrt_thread_detach"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B0 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_160_12_0 {
	meta:
		name = "__scrt_dllmain_exception_filter"
		size = 97
		refs = "0020 __scrt_is_ucrt_dll_in_use 0031 _guard_check_icall 005d _seh_filter_dll"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F9 49 8B F0 8B DA 48 8B E9 E8 ?? ?? ?? ?? 85 C0 75 17 83 FB 01 75 12 48 8B CF E8 ?? ?? ?? ?? 4C 8B C6 33 D2 48 8B CD FF D7 48 8B 54 24 58 8B 4C 24 50 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_13_0 {
	meta:
		name = "__scrt_dllmain_uninitialize_c"
		size = 48
		refs = "0005 __scrt_is_ucrt_dll_in_use 0010 ?module_local_atexit_table@@3U_onexit_table_t@@A 0019 _execute_onexit_table 001e _is_c_termination_complete 0027 _cexit"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 85 C0 74 10 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_160_14_0 {
	meta:
		name = "__scrt_dllmain_uninitialize_critical"
		size = 20
		refs = "0007 __acrt_uninitialize_critical 0010 __vcrt_uninitialize_critical"
	strings:
		$1 = { 48 83 EC 28 33 C9 E8 ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_15_0 {
	meta:
		name = "__scrt_initialize_crt"
		size = 73
		refs = "0009 ?is_initialized_as_dll@@3_NA 001e __isa_available_init 0023 __vcrt_initialize 0030 __acrt_initialize 003b __vcrt_uninitialize"
	strings:
		$1 = { 40 53 48 83 EC 20 0F B6 05 ?? ?? ?? ?? 85 C9 BB 01 00 00 00 0F 44 C3 88 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 04 32 C0 EB 14 E8 ?? ?? ?? ?? 84 C0 75 09 33 C9 E8 ?? ?? ?? ?? EB EA 8A C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_160_16_0 {
	meta:
		name = "__scrt_initialize_onexit_tables"
		size = 201
		refs = "0019 __scrt_is_ucrt_dll_in_use 0028 ?module_local_atexit_table@@3U_onexit_table_t@@A 002d _initialize_onexit_table 003c ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 004f __security_cookie 00c4 __scrt_fastfail"
	strings:
		$1 = { 48 89 5C 24 08 55 48 8B EC 48 83 EC 40 8B D9 83 F9 01 0F 87 A6 00 00 00 E8 ?? ?? ?? ?? 85 C0 74 2B 85 DB 75 27 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 04 32 C0 EB 7A 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 94 C0 EB 67 48 8B 15 ?? ?? ?? ?? 49 83 C8 FF 8B C2 B9 40 00 00 00 83 E0 3F 2B C8 B0 01 49 D3 C8 4C 33 C2 4C 89 45 E0 4C 89 45 E8 0F 10 45 E0 4C 89 45 F0 F2 0F 10 4D F0 0F 11 05 ?? ?? ?? ?? 4C 89 45 E0 4C 89 45 E8 0F 10 45 E0 4C 89 45 F0 F2 0F 11 0D ?? ?? ?? ?? F2 0F 10 4D F0 0F 11 05 ?? ?? ?? ?? F2 0F 11 0D ?? ?? ?? ?? 48 8B 5C 24 50 48 83 C4 40 5D C3 B9 05 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_160_17_0 {
	meta:
		name = "__scrt_is_nonwritable_in_current_image"
		size = 153
		refs = "000f __ImageBase"
	strings:
		$1 = { 48 83 EC 18 4C 8B C1 B8 4D 5A 00 00 66 39 05 ?? ?? ?? ?? 75 79 48 63 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0C 10 81 39 50 45 00 00 75 5F B8 0B 02 00 00 66 39 41 18 75 54 4C 2B C2 0F B7 41 14 48 8D 51 18 48 03 D0 0F B7 41 06 48 8D 0C 80 4C 8D 0C CA 48 89 14 24 49 3B D1 74 18 8B 4A 0C 4C 3B C1 72 0A 8B 42 08 03 C1 4C 3B C0 72 08 48 83 C2 28 EB DF 33 D2 48 85 D2 75 04 32 C0 EB 14 83 7A 24 00 7D 04 32 C0 EB 0A B0 01 EB 06 32 C0 EB 02 32 C0 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_160_18_0 {
	meta:
		name = "__scrt_is_nonwritable_in_current_image$filt$0"
		size = 24
	strings:
		$1 = { 40 55 48 8B EA 48 8B 01 33 C9 81 38 05 00 00 C0 0F 94 C1 8B C1 5D C3 CC }
	condition:
		$1
}

rule file_160_19_0 {
	meta:
		name = "__scrt_release_startup_lock"
		size = 36
		refs = "0009 __scrt_is_ucrt_dll_in_use 001a __scrt_native_startup_lock"
	strings:
		$1 = { 40 53 48 83 EC 20 8A D9 E8 ?? ?? ?? ?? 33 D2 85 C0 74 0B 84 DB 75 07 48 87 15 ?? ?? ?? ?? 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_160_20_0 {
	meta:
		name = "__scrt_uninitialize_crt"
		size = 43
		refs = "0008 ?is_initialized_as_dll@@3_NA 0018 __acrt_uninitialize 001f __vcrt_uninitialize"
	strings:
		$1 = { 40 53 48 83 EC 20 80 3D ?? ?? ?? ?? 00 8A D9 74 04 84 D2 75 0E 8A CB E8 ?? ?? ?? ?? 8A CB E8 ?? ?? ?? ?? B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_160_21_0 {
	meta:
		name = "_onexit"
		size = 79
		refs = "0009 __security_cookie 0015 ?module_local_atexit_table@@3U_onexit_table_t@@A 0029 _crt_atexit 003a _register_onexit_function"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 15 ?? ?? ?? ?? 48 8B D9 8B CA 48 33 15 ?? ?? ?? ?? 83 E1 3F 48 D3 CA 48 83 FA FF 75 0A 48 8B CB E8 ?? ?? ?? ?? EB 0F 48 8B D3 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 85 C0 48 0F 44 CB 48 8B C1 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_160_22_0 {
	meta:
		name = "at_quick_exit"
		size = 54
		refs = "0003 __security_cookie 000f ?module_local_at_quick_exit_table@@3U_onexit_table_t@@A 0023 _crt_at_quick_exit 0032 _register_onexit_function"
	strings:
		$1 = { 48 8B 15 ?? ?? ?? ?? 4C 8B C1 8B CA 48 33 15 ?? ?? ?? ?? 83 E1 3F 48 D3 CA 48 83 FA FF 75 08 49 8B C8 E9 ?? ?? ?? ?? 49 8B D0 48 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_160_23_0 {
	meta:
		name = "atexit"
		size = 23
		refs = "0005 _onexit"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? 48 F7 D8 1B C0 F7 D8 FF C8 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "__sse4_floor2"
		size = 16
	strings:
		$1 = { 66 0F 3A 09 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__avx_powf8"
		size = 1520
		refs = "000a __common_spow_data 05e9 __common_spow_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 B0 01 00 00 C5 7C 11 B4 24 70 01 00 00 C5 7C 11 AC 24 50 01 00 00 C5 7C 11 A4 24 30 01 00 00 C5 7C 11 9C 24 10 01 00 00 C5 7C 11 94 24 30 02 00 00 C5 7C 11 8C 24 10 02 00 00 C5 7C 11 84 24 F0 01 00 00 C5 FC 11 BC 24 D0 01 00 00 C5 FC 11 B4 24 90 01 00 00 4C 89 AC 24 50 02 00 00 4C 8D 6C 24 6F 49 83 E5 C0 C4 C1 7C 11 45 20 C5 7D 10 25 ?? ?? ?? ?? C5 7D 10 35 ?? ?? ?? ?? C5 F8 10 25 ?? ?? ?? ?? C5 78 10 0D ?? ?? ?? ?? C4 C1 7C 11 4D 00 C5 F9 FA D4 C4 E3 7D 19 C3 01 C5 7C 5A C0 C5 FC 5A FB C5 E1 FA DC C4 41 3D 54 DC C4 41 45 54 FC C4 C1 25 56 C6 C4 41 05 56 FE C4 C1 71 DB E1 C4 C3 7D 19 CA 01 C5 FC 5A F1 C4 41 29 DB E9 C5 FD 5A C8 C4 41 7D 5A CF C5 7A 7F 6C 24 20 C4 C1 7C 5A EA C5 78 53 D1 C4 41 78 53 E9 C4 41 7C 5A F2 C4 41 7C 5A DD C4 43 7D 09 CE 00 C5 7D 10 35 ?? ?? ?? ?? C4 63 7D 19 C1 01 C4 C1 39 73 D0 14 C5 F1 73 D1 14 C5 38 C6 D1 DD C4 41 7E E6 D2 C5 B9 73 D7 14 C4 C3 7D 19 FC 01 C4 C1 71 73 D4 14 C5 38 C6 E9 DD C4 43 7D 09 C3 00 C4 41 7D 59 E1 C4 C1 7E E6 FD C4 C1 05 59 C0 C4 41 1D 5C DE C4 41 7D 5C E6 C4 C1 01 73 D1 28 C5 79 7E F8 C4 43 7D 19 CD 01 48 63 C0 C4 C1 09 73 D5 28 C4 41 79 7E F0 C4 63 79 16 F9 02 48 63 C9 C5 7B 10 AC 10 80 A1 BF FF 4D 63 C0 C4 43 79 16 F1 02 4D 63 C9 C5 11 16 AC 11 80 A1 BF FF C4 41 7B 10 BC 10 80 A1 BF FF C4 C1 79 73 D0 28 C4 63 7D 19 C1 01 C5 F1 73 D1 28 C5 F9 7E C8 C4 C1 79 7E C2 C4 41 01 16 BC 11 80 A1 BF FF 48 63 C0 C4 E3 79 16 C9 02 48 63 C9 4D 63 D2 C4 C3 79 16 C3 02 4D 63 DB C4 43 15 18 EF 01 C5 7B 10 BC 10 80 A1 BF FF C5 81 16 8C 11 80 A1 BF FF C5 7D 10 3D ?? ?? ?? ?? C4 41 7B 10 B4 12 80 A1 BF FF C4 C1 09 16 84 13 80 A1 BF FF C5 7D 10 35 ?? ?? ?? ?? C4 41 05 C2 C9 11 C4 41 05 C2 F8 11 C4 41 35 54 C6 C4 41 05 54 CE C5 7D 10 3D ?? ?? ?? ?? C4 41 3D 56 C7 C4 41 35 56 CF C4 41 2D 5C D0 C4 C1 45 5C F9 C4 E3 7D 18 C1 01 C5 FD 10 0D ?? ?? ?? ?? C5 2D 59 F1 C5 45 59 F9 C5 FD 10 0D ?? ?? ?? ?? C5 FD 10 3D ?? ?? ?? ?? C4 41 75 59 C3 C4 41 75 59 CC C5 3D 58 D7 C5 B5 58 CF C4 41 25 59 C3 C4 41 1D 59 CC C4 41 2D 59 D0 C4 41 75 59 C1 C4 41 25 58 DA C4 41 1D 58 C0 C4 C1 25 58 CD C5 3D 58 D0 C5 FD 10 05 ?? ?? ?? ?? C4 41 75 58 CE C4 41 2D 58 EF C5 35 59 CE C5 15 59 C5 C5 FD 10 2D ?? ?? ?? ?? C5 FD 10 35 ?? ?? ?? ?? C5 78 10 2D ?? ?? ?? ?? C5 35 59 FD C5 BD 59 ED C5 05 5C E6 C5 55 5C DE C5 1D 58 D0 C5 A5 58 C8 C5 78 10 25 ?? ?? ?? ?? C5 2D 5C F0 C5 F5 5C C0 C4 41 05 5C F6 C5 D5 5C E8 C5 7D 10 3D ?? ?? ?? ?? C4 63 7D 19 C7 01 C5 38 C6 DF DD C5 F8 10 3D ?? ?? ?? ?? C5 69 66 C7 C5 E9 76 D7 C4 63 7D 19 CE 01 C5 B0 C6 F6 DD C5 39 EB CA C5 F8 10 15 ?? ?? ?? ?? C5 59 66 C2 C5 D9 76 E2 C5 39 EB C4 C4 C1 48 54 E5 C4 41 31 EB C8 C5 61 66 C7 C5 E1 76 DF C4 C1 59 66 F4 C5 B9 EB DB C5 31 EB CE C5 7A 6F 44 24 20 C4 41 20 54 ED C5 B9 66 E2 C5 B9 76 D2 C5 D9 EB F2 C4 41 11 66 E4 C5 E1 EB FE C5 F9 10 25 ?? ?? ?? ?? C4 41 41 EB DC C4 41 31 6B CB C4 41 39 EF C0 C4 C1 31 63 D0 C5 F9 D7 C2 C4 41 55 59 CF C4 41 0D 59 C7 C5 28 54 DC C4 63 7D 19 D3 01 C4 C1 29 73 D2 0B C4 41 79 7E D8 C5 60 54 E4 C4 41 79 7E E2 C5 E1 73 D3 0B C4 C1 29 73 F2 34 41 C1 E0 03 C4 43 79 16 D9 02 41 C1 E2 03 C4 63 79 16 E1 02 41 C1 E1 03 C1 E1 03 C4 C1 F9 6E 84 10 00 36 00 00 C4 C1 F9 6E B4 12 00 36 00 00 C4 C1 79 16 AC 11 00 36 00 00 C5 C9 16 BC 11 00 36 00 00 C5 70 54 EC C4 E3 7D 19 CA 01 C5 F1 73 D1 0B C5 E8 54 E4 C5 E9 73 D2 0B C4 41 79 7E E8 C5 F1 73 F1 34 C4 C1 79 7E E3 41 C1 E0 03 C4 43 79 16 E9 02 41 C1 E3 03 C4 E3 79 16 E1 02 41 C1 E1 03 C1 E1 03 C4 41 F9 6E 9C 10 00 36 00 00 C4 41 F9 6E A4 13 00 36 00 00 C4 41 21 16 AC 11 00 36 00 00 C5 99 16 A4 11 00 36 00 00 C4 63 55 18 F7 01 C5 C1 73 F3 34 C4 41 0D 59 C0 C4 C1 3D 58 C6 C4 63 15 18 FC 01 C4 41 05 59 C9 C4 C1 35 58 E7 C4 E3 7D 19 C6 01 C4 C1 79 D4 EA C5 49 D4 CF C5 F9 73 F2 34 C4 C1 7C 10 55 00 C4 C3 7D 19 E0 01 C5 D9 D4 E1 C5 39 D4 C0 C4 43 55 18 D9 01 C4 C1 7D 5A DB C4 C3 5D 18 E8 01 C5 FD 5A F5 C4 E3 65 18 C6 01 84 C0 75 6A C5 FC 10 B4 24 90 01 00 00 C5 FC 10 BC 24 D0 01 00 00 C5 7C 10 84 24 F0 01 00 00 C5 7C 10 8C 24 10 02 00 00 C5 7C 10 94 24 30 02 00 00 C5 7C 10 9C 24 10 01 00 00 C5 7C 10 A4 24 30 01 00 00 C5 7C 10 AC 24 50 01 00 00 C5 7C 10 B4 24 70 01 00 00 C5 7C 10 BC 24 B0 01 00 00 4C 8B AC 24 50 02 00 00 48 81 C4 58 02 00 00 C3 C4 C1 7C 10 4D 20 C4 C1 7C 11 55 40 C4 C1 7C 11 85 80 00 00 00 C4 C1 7C 11 4D 00 85 C0 0F 84 73 FF FF FF 33 D2 48 89 5C 24 28 8B DA 48 89 74 24 20 8B F0 0F A3 DE 72 1F FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7C 10 85 80 00 00 00 E9 3F FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 4D 8D 84 9D 80 00 00 00 E8 ?? ?? ?? ?? EB C5 90 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__dyn_tls_dtor"
		size = 166
		refs = "0023 _tls_index 0032 dtor_list 0061 _guard_check_icall 007d _free_base"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 83 FA 03 74 04 85 D2 75 6C 8B 0D ?? ?? ?? ?? 65 48 8B 04 25 58 00 00 00 41 BF ?? ?? ?? ?? 4C 8B 34 C8 4B 8B 3C 3E 48 85 FF 74 4A 8B 1F 83 EB 01 78 26 48 63 F3 48 83 C6 02 48 8D 34 F7 48 8B 2E 48 85 ED 74 0A 48 8B CD E8 ?? ?? ?? ?? FF D5 48 83 EE 08 83 EB 01 79 E5 48 8B 5F 08 48 85 DB 74 08 48 8B CF E8 ?? ?? ?? ?? 4B 89 1C 3E 48 8B FB 48 85 DB 75 B6 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_170_3_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 27
		refs = "000d _free_base"
		altNames = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEAA@XZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@UTlsDtorNode@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__vcrt_ptd@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@XU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_12_2_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAA@XZ"
		size = 27
		refs = "000d free"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_12_7_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAXXZ"
		size = 27
		refs = "000d free"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_170_6_0 {
	meta:
		name = "__tlregdtor"
		size = 163
		refs = "0023 _tls_index 0029 dtor_list 003b dtor_list_head 0056 _malloc_base 0060 _free_base"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 65 48 8B 04 25 58 00 00 00 48 8B F1 8B 15 ?? ?? ?? ?? 41 BE ?? ?? ?? ?? 48 8B 1C D0 49 8B 04 1E 48 85 C0 75 11 B8 ?? ?? ?? ?? 48 03 C3 49 89 04 1E 83 20 00 EB 32 83 38 1E 75 2D B9 00 01 00 00 E8 ?? ?? ?? ?? 33 C9 48 8B F8 E8 ?? ?? ?? ?? 48 85 FF 75 05 83 C8 FF EB 1F 49 8B 04 1E 83 27 00 48 89 47 08 49 89 3C 1E 49 8B 0C 1E 48 63 01 48 89 74 C1 10 FF 01 33 C0 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "__sse2_ceil2"
		size = 80
		refs = "0006 _2il0floatpacket_4 000d _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 E0 0F 28 1D ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 D3 0F 54 E1 0F 55 C8 66 0F C2 D1 01 66 0F 58 CB 66 0F 5C CB 0F 56 CC 0F 28 DA 0F 28 E9 66 0F C2 E8 01 0F 54 2D ?? ?? ?? ?? 0F 54 C2 66 0F 5C CD 0F 55 D9 0F 56 C3 C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "__avx_log104"
		size = 656
		refs = "000a __common_dlog10_data 027c __common_dlog10_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 05 ?? ?? ?? ?? C5 FC 11 BC 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 8F 01 00 00 C5 FD 54 1D ?? ?? ?? ?? 49 83 E5 C0 C5 E5 56 3D ?? ?? ?? ?? C5 FD 5A EF C5 F8 53 E5 C5 FC 5A E4 C4 E3 7D 09 E4 00 C5 F1 73 D0 14 C4 E3 7D 19 C2 01 C5 E1 73 D2 14 C5 FD C2 15 ?? ?? ?? ?? 11 C5 F0 C6 EB DD C5 FD C2 0D ?? ?? ?? ?? 16 C5 FE E6 DD C5 ED 56 D1 C4 E3 7D 19 D1 01 C5 E8 C6 E9 DD C5 C5 54 15 ?? ?? ?? ?? C5 C5 5C FA C5 F8 50 D5 C5 ED 59 D4 C5 C5 59 FC C5 ED 5C 0D ?? ?? ?? ?? C5 F5 58 CF C5 C1 73 D4 28 C4 E3 7D 19 E5 01 C5 D1 73 D5 28 C4 C1 79 7E E9 C5 DD C2 25 ?? ?? ?? ?? 1E C5 F9 7E F9 4D 63 C9 C4 C3 79 16 EA 02 4D 63 D2 C4 C3 79 16 F8 02 C4 C1 7B 10 BC 01 40 90 BF FF C5 DD 54 25 ?? ?? ?? ?? C4 C1 41 16 AC 02 40 90 BF FF C5 DD 56 3D ?? ?? ?? ?? C5 E5 5C DF C5 F5 59 3D ?? ?? ?? ?? C5 E5 59 25 ?? ?? ?? ?? C5 F5 59 1D ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? 48 63 C9 4D 63 C0 C5 FB 10 94 01 40 90 BF FF C4 C1 69 16 94 00 40 90 BF FF C4 E3 6D 18 D5 01 C5 E5 58 2D ?? ?? ?? ?? C5 F5 59 D9 C5 F5 59 0D ?? ?? ?? ?? C5 D5 59 EB C5 D5 58 EF C5 D5 59 DB C5 E5 58 C9 C5 F5 58 D2 C5 ED 58 CC 85 D2 75 1D C5 FC 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 D5 33 C0 C5 FC 11 B4 24 20 01 00 00 C5 7C 11 84 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 48 01 00 00 8B D8 48 89 B4 24 40 01 00 00 8B F2 0F A3 DE 72 6A FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 20 01 00 00 C5 7C 10 84 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 48 01 00 00 48 8B B4 24 40 01 00 00 E9 08 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB 82 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "__common_dsinh_cout_rare"
		size = 2096
		refs = "006d _vmldSinhHATab 015a _2il0floatpacket_88"
	strings:
		$1 = { 41 54 48 81 EC E0 00 00 00 33 C0 4C 8B 09 4D 8B C1 49 C1 E8 30 F2 0F 10 11 41 81 E0 F0 7F 00 00 41 C1 E8 04 44 0F 29 7C 24 50 41 81 F8 FF 07 00 00 44 0F 29 74 24 60 44 0F 29 6C 24 70 44 0F 29 A4 24 80 00 00 00 44 0F 29 9C 24 90 00 00 00 44 0F 29 94 24 A0 00 00 00 44 0F 29 8C 24 B0 00 00 00 44 0F 29 84 24 C0 00 00 00 4C 8B 25 ?? ?? ?? ?? 4C 89 8C 24 D0 00 00 00 0F 84 A1 07 00 00 45 85 C0 0F 8E 6C 07 00 00 49 8B C9 48 C1 E9 38 4C 89 4C 24 38 83 E1 7F 88 4C 24 3F 41 81 F8 C9 03 00 00 0F 8E EB 06 00 00 F2 0F 10 44 24 38 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 BC 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 49 05 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 CE 04 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 44 0F 59 E8 F2 44 0F 10 25 ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 4C 89 64 24 48 49 C1 EC 30 F2 44 0F 58 2D ?? ?? ?? ?? F2 44 0F 11 6C 24 30 41 81 E4 0F 80 FF FF F2 44 0F 10 74 24 30 44 8B 44 24 30 45 8B D0 41 C1 EA 06 41 83 E0 3F 49 C1 E9 38 F2 44 0F 5C 35 ?? ?? ?? ?? F2 45 0F 59 E6 41 8D 8A FF 03 00 00 44 0F 57 35 ?? ?? ?? ?? 41 81 C2 FE 03 00 00 F2 44 0F 59 35 ?? ?? ?? ?? F2 41 0F 5C C4 44 0F 28 C8 0F 28 E8 41 81 E2 FF 07 00 00 F7 D9 41 C1 E2 04 83 C1 FC 45 0B E2 47 8D 14 00 81 E1 FF 07 00 00 66 44 89 64 24 4E 41 81 E4 0F 80 FF FF C1 E1 04 47 8D 44 00 01 44 0B E1 41 80 E1 80 F2 45 0F 58 CE F2 44 0F 11 4C 24 40 F2 44 0F 10 54 24 40 F2 41 0F 5C EA F2 0F 11 6C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 44 24 20 F2 45 0F 58 D8 F2 44 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 45 0F 58 F7 F2 44 0F 10 7C 24 48 F2 44 0F 11 74 24 20 F2 44 0F 10 5C 24 28 66 44 89 64 24 4E 4D 8B E3 F2 41 0F 5C C3 F2 0F 11 44 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 0F 10 6C 24 40 0F 28 D5 44 0F 28 DD F2 0F 59 D4 0F 28 CD F2 44 0F 59 DD F2 44 0F 10 44 24 28 F2 0F 11 54 24 40 F2 44 0F 10 4C 24 40 F2 43 0F 10 14 C3 4D 8B C3 F2 41 0F 59 D7 F2 44 0F 5C CD F2 44 0F 11 4C 24 20 F2 44 0F 10 0D ?? ?? ?? ?? F2 45 0F 59 CB F2 0F 10 5C 24 40 F2 44 0F 10 54 24 20 F2 41 0F 5C DA F2 44 0F 10 15 ?? ?? ?? ?? F2 45 0F 59 D3 F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 45 0F 59 CB F2 0F 5C C8 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 D3 F2 45 0F 59 CB F2 44 0F 59 D5 F2 43 0F 10 04 D3 41 F7 DA F2 0F 11 4C 24 20 F2 41 0F 59 C7 F2 44 0F 10 5C 24 48 41 8D 8A 80 00 00 00 41 81 C2 81 00 00 00 44 0F 28 F0 F2 44 0F 10 6C 24 40 F2 41 0F 10 0C CC F2 44 0F 10 64 24 20 F2 41 0F 59 CB F2 43 0F 10 1C D0 F2 44 0F 5C F1 F2 41 0F 59 DB F2 44 0F 11 74 24 40 44 0F 28 D8 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF F2 44 0F 5C D9 F2 44 0F 11 5C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 74 24 20 45 0F 28 FB F2 44 0F 5C F3 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 58 FE F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF 44 0F 28 F8 F2 44 0F 58 F9 F2 45 0F 58 DE F2 44 0F 11 5C 24 20 F2 44 0F 10 74 24 40 F2 44 0F 10 5C 24 20 F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 41 0F 5C C7 F2 0F 58 C1 F2 0F 11 44 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 20 0F 28 D9 F2 0F 58 D0 F2 0F 58 DA F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 0F 5C C8 F2 0F 58 CA F2 0F 11 4C 24 20 F2 0F 10 44 24 40 F2 0F 59 E0 0F 28 C8 F2 0F 10 5C 24 20 F2 0F 11 64 24 40 F2 0F 10 64 24 40 F2 0F 59 EB F2 0F 5C E0 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 40 F2 0F 10 54 24 20 F2 44 0F 5C FA F2 44 0F 11 7C 24 40 45 0F 28 F8 F2 0F 10 64 24 40 F2 44 0F 59 FB F2 0F 5C CC F2 44 0F 59 C0 F2 0F 11 4C 24 20 0F 28 CB F2 41 0F 59 CA F2 44 0F 59 D0 F2 44 0F 58 F9 41 0F 28 CB F2 41 0F 59 C9 F2 45 0F 59 CE F2 44 0F 58 F9 F2 0F 10 54 24 40 41 0F 28 CC F2 0F 10 64 24 20 F2 44 0F 58 FD F2 0F 59 CC F2 41 0F 59 E5 F2 44 0F 59 EA F2 45 0F 58 F8 F2 44 0F 59 E2 F2 45 0F 58 DF 41 0F 28 EA 41 0F 28 D5 F2 41 0F 58 E9 F2 0F 11 6C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C D0 F2 45 0F 58 D1 45 0F 28 CE F2 44 0F 11 54 24 20 F2 0F 10 5C 24 40 F2 0F 10 44 24 20 F2 0F 58 D3 F2 44 0F 58 D8 F2 0F 11 54 24 40 F2 44 0F 58 D9 F2 44 0F 58 DC F2 0F 10 64 24 40 F2 44 0F 5C EC F2 45 0F 58 DC F2 44 0F 58 EB F2 44 0F 11 6C 24 20 F2 44 0F 10 54 24 40 F2 0F 10 6C 24 20 F2 45 0F 58 CA F2 44 0F 58 DD F2 44 0F 11 4C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C F0 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 F2 44 0F 10 6C 24 40 F2 44 0F 10 64 24 20 F2 45 0F 58 DC F2 45 0F 58 DD F2 44 0F 11 5C 24 38 44 8A 5C 24 3F 41 80 E3 7F 45 0A D9 44 88 5C 24 3F 48 8B 4C 24 38 48 89 0A E9 FD 01 00 00 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 8A 8C 24 D7 00 00 00 80 E1 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 38 44 8A 44 24 3F 41 80 E0 7F 44 0A C1 44 88 44 24 3F 4C 8B 4C 24 38 4C 89 0A E9 90 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? 4C 89 64 24 48 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 F2 0F 10 64 24 30 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 30 44 8B D1 41 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 47 8D 04 12 F2 0F 59 E3 F2 0F 5C C2 47 8D 5C 12 01 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 43 0F 10 04 C1 F2 0F 59 C8 4D 8B C1 F2 43 0F 58 0C D8 F2 0F 58 C8 77 29 49 C1 EC 30 C1 E1 04 41 81 E4 0F 80 FF FF 44 0B E1 66 44 89 64 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 11 4C 24 38 EB 39 FF C9 81 E1 FF 07 00 00 44 0F B7 44 24 4E C1 E1 04 41 81 E0 0F 80 FF FF 44 0B C1 66 44 89 44 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 38 44 8A 44 24 3F 8A 8C 24 D7 00 00 00 41 80 E0 7F 80 E1 80 44 0A C1 44 88 44 24 3F 4C 8B 4C 24 38 4C 89 0A EB 2F F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C2 F2 0F 11 02 EB 18 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 11 02 44 0F 28 84 24 C0 00 00 00 44 0F 28 8C 24 B0 00 00 00 44 0F 28 94 24 A0 00 00 00 44 0F 28 9C 24 90 00 00 00 44 0F 28 A4 24 80 00 00 00 44 0F 28 6C 24 70 44 0F 28 74 24 60 44 0F 28 7C 24 50 48 81 C4 E0 00 00 00 41 5C C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 11 54 24 40 F2 0F 10 4C 24 40 4C 89 64 24 48 F2 0F 58 8C 24 D0 00 00 00 F2 0F 11 0A EB 8B F2 0F 58 D2 F2 0F 11 12 EB 81 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "__avx_sinhf8"
		size = 576
		refs = "0036 __common_ssinh_data 022f __common_ssinh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 F0 01 00 00 C5 7C 11 8C 24 B0 01 00 00 C5 FC 11 B4 24 D0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 4F 01 00 00 C5 FC 54 2D ?? ?? ?? ?? 49 83 E5 C0 C5 54 57 F8 C5 7C 10 0D ?? ?? ?? ?? C5 84 59 0D ?? ?? ?? ?? C5 F8 10 35 ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C4 C1 74 58 C9 C5 81 66 E6 C4 63 7D 19 FB 01 C5 E1 66 DE C5 D9 6B E3 C5 C9 EF F6 C4 C1 74 5C D9 C5 D9 63 E6 C5 F9 D7 D4 C5 64 59 0D ?? ?? ?? ?? C4 41 04 5C F9 C5 64 59 0D ?? ?? ?? ?? C4 C1 04 5C D9 C5 E4 59 E3 C5 81 72 F1 17 C4 C3 7D 19 C9 01 C4 C1 69 FE CF C4 C1 49 72 F1 17 C4 41 69 FA FF C5 69 FE CE C5 E9 FA D6 C4 43 75 18 C9 01 C5 DC 59 0D ?? ?? ?? ?? C4 63 05 18 FA 01 C5 F4 58 15 ?? ?? ?? ?? C4 C1 34 58 F7 C4 41 34 5C CF C5 6C 59 FC C5 84 59 CB C5 74 58 FB C5 DC 59 1D ?? ?? ?? ?? C4 C1 4C 59 F7 C5 E4 58 0D ?? ?? ?? ?? C5 F4 59 D4 C5 EC 58 1D ?? ?? ?? ?? C5 E4 59 E4 C4 C1 5C 59 C9 C5 CC 58 D1 C4 41 6C 58 C9 C4 C1 54 56 C9 84 D2 75 2F C5 FC 10 B4 24 D0 01 00 00 C5 7C 10 8C 24 B0 01 00 00 C5 7C 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 C1 33 C0 C5 FC 11 BC 24 E0 00 00 00 C5 7C 11 84 24 C0 00 00 00 C5 7C 11 94 24 A0 00 00 00 C5 7C 11 9C 24 80 00 00 00 C5 7C 11 64 24 60 C5 7C 11 6C 24 40 C5 7C 11 74 24 20 48 89 9C 24 08 01 00 00 8B D8 48 89 B4 24 00 01 00 00 8B F2 0F A3 DE 72 58 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 E0 00 00 00 C5 7C 10 84 24 C0 00 00 00 C5 7C 10 94 24 A0 00 00 00 C5 7C 10 9C 24 80 00 00 00 C5 7C 10 64 24 60 C5 7C 10 6C 24 40 C5 7C 10 74 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 08 01 00 00 48 8B B4 24 00 01 00 00 E9 18 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 94 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "__common_ssinh_cout_rare"
		size = 2128
		refs = "0062 _vmldSinhHATab 0160 _2il0floatpacket_89"
	strings:
		$1 = { 48 81 EC D8 00 00 00 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 F3 0F 10 11 41 81 F8 80 7F 00 00 44 0F 29 7C 24 50 44 0F 29 74 24 60 44 0F 29 6C 24 70 44 0F 29 A4 24 80 00 00 00 44 0F 29 9C 24 90 00 00 00 44 0F 29 94 24 A0 00 00 00 44 0F 29 8C 24 B0 00 00 00 44 0F 29 84 24 C0 00 00 00 4C 8B 1D ?? ?? ?? ?? 0F 84 CE 07 00 00 F3 0F 5A D2 F2 0F 11 94 24 D0 00 00 00 44 0F B7 84 24 D6 00 00 00 41 81 E0 F0 7F 00 00 F2 0F 11 54 24 38 41 C1 E8 04 80 64 24 3F 7F 45 85 C0 0F 8E 6A 07 00 00 41 81 F8 C9 03 00 00 0F 8E FA 06 00 00 F2 0F 10 44 24 38 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 C7 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 51 05 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 D4 04 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? F2 44 0F 59 E8 F2 44 0F 10 25 ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 4C 89 5C 24 48 49 C1 EB 30 F2 44 0F 58 2D ?? ?? ?? ?? F2 44 0F 11 6C 24 30 41 81 E3 0F 80 FF FF F2 44 0F 10 74 24 30 44 8B 44 24 30 41 8B C8 C1 E9 06 41 83 E0 3F 81 C1 FF 03 00 00 F2 44 0F 5C 35 ?? ?? ?? ?? F2 45 0F 59 E6 81 E1 FF 07 00 00 44 0F 57 35 ?? ?? ?? ?? 44 8D 49 FF F2 44 0F 59 35 ?? ?? ?? ?? F2 41 0F 5C C4 44 0F 28 C8 0F 28 E8 41 81 E1 FF 07 00 00 F7 D9 41 C1 E1 04 83 C1 FC 45 0B D9 47 8D 0C 00 81 E1 FF 07 00 00 66 44 89 5C 24 4E 41 81 E3 0F 80 FF FF C1 E1 04 47 8D 44 00 01 44 0B D9 F2 45 0F 58 CE F2 44 0F 11 4C 24 40 F2 44 0F 10 54 24 40 F2 41 0F 5C EA F2 0F 11 6C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 44 24 20 F2 45 0F 58 D8 F2 44 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 45 0F 58 F7 F2 44 0F 10 7C 24 48 F2 44 0F 11 74 24 20 F2 44 0F 10 5C 24 28 66 44 89 5C 24 4E 4D 8B DA F2 41 0F 5C C3 F2 0F 11 44 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 0F 10 6C 24 40 0F 28 D5 44 0F 28 DD F2 0F 59 D4 0F 28 CD F2 44 0F 59 DD F2 44 0F 10 44 24 28 F2 0F 11 54 24 40 F2 44 0F 10 4C 24 40 F2 43 0F 10 14 C2 4D 8B C2 F2 41 0F 59 D7 F2 44 0F 5C CD F2 44 0F 11 4C 24 20 F2 44 0F 10 0D ?? ?? ?? ?? F2 45 0F 59 CB F2 0F 10 5C 24 40 F2 44 0F 10 54 24 20 F2 41 0F 5C DA F2 44 0F 10 15 ?? ?? ?? ?? F2 45 0F 59 D3 F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 45 0F 59 CB F2 0F 5C C8 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 D3 F2 45 0F 59 CB F2 44 0F 59 D5 F2 43 0F 10 04 CA 41 F7 D9 F2 0F 11 4C 24 20 F2 41 0F 59 C7 F2 44 0F 10 5C 24 48 41 8D 89 80 00 00 00 41 81 C1 81 00 00 00 44 0F 28 F0 F2 44 0F 10 6C 24 40 F2 41 0F 10 0C CB F2 44 0F 10 64 24 20 F2 41 0F 59 CB F2 43 0F 10 1C C8 F2 44 0F 5C F1 F2 41 0F 59 DB F2 44 0F 11 74 24 40 44 0F 28 D8 F2 44 0F 10 7C 24 40 44 8A 94 24 D7 00 00 00 F2 45 0F 5C DF 41 80 E2 80 F2 44 0F 5C D9 F2 44 0F 11 5C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 74 24 20 45 0F 28 FB F2 44 0F 5C F3 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 58 FE F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF 44 0F 28 F8 F2 44 0F 58 F9 F2 45 0F 58 DE F2 44 0F 11 5C 24 20 F2 44 0F 10 74 24 40 F2 44 0F 10 5C 24 20 F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 41 0F 5C C7 F2 0F 58 C1 F2 0F 11 44 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 20 0F 28 D9 F2 0F 58 D0 F2 0F 58 DA F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 0F 5C C8 F2 0F 58 CA F2 0F 11 4C 24 20 F2 0F 10 44 24 40 F2 0F 59 E0 0F 28 C8 F2 0F 10 5C 24 20 F2 0F 11 64 24 40 F2 0F 10 64 24 40 F2 0F 59 EB F2 0F 5C E0 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 40 F2 0F 10 54 24 20 F2 44 0F 5C FA F2 44 0F 11 7C 24 40 45 0F 28 F8 F2 0F 10 64 24 40 F2 44 0F 59 FB F2 0F 5C CC F2 44 0F 59 C0 F2 0F 11 4C 24 20 41 0F 28 CA F2 0F 59 CB F2 44 0F 59 D0 F2 44 0F 58 F9 41 0F 28 C9 F2 41 0F 59 CB F2 45 0F 59 CE F2 44 0F 58 F9 F2 0F 10 54 24 40 41 0F 28 CC F2 0F 10 64 24 20 F2 44 0F 58 FD F2 0F 59 CC F2 41 0F 59 E5 F2 44 0F 59 EA F2 45 0F 58 F8 F2 44 0F 59 E2 F2 45 0F 58 DF 41 0F 28 EA F2 41 0F 58 E9 F2 0F 11 6C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C D0 F2 45 0F 58 D1 45 0F 28 CE F2 44 0F 11 54 24 20 F2 0F 10 5C 24 40 F2 0F 10 44 24 20 0F 28 D3 F2 44 0F 58 D8 F2 41 0F 58 D5 F2 44 0F 58 D9 F2 0F 11 54 24 40 F2 44 0F 58 DC F2 0F 10 64 24 40 F2 45 0F 58 DC F2 44 0F 5C EC F2 44 0F 58 EB F2 44 0F 11 6C 24 20 F2 44 0F 10 54 24 40 F2 0F 10 6C 24 20 F2 45 0F 58 CA F2 44 0F 58 DD F2 44 0F 11 4C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C F0 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 F2 44 0F 10 6C 24 40 F2 44 0F 10 64 24 20 F2 45 0F 58 DC F2 45 0F 58 DD F2 44 0F 11 5C 24 38 8A 4C 24 3F 80 E1 7F 41 0A CA 88 4C 24 3F F2 44 0F 5A 5C 24 38 F3 44 0F 11 1A E9 0A 02 00 00 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 8A 8C 24 D7 00 00 00 80 E1 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 38 44 8A 44 24 3F 41 80 E0 7F 44 0A C1 44 88 44 24 3F F2 0F 5A 44 24 38 F3 0F 11 02 E9 9B 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 15 ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? 4C 89 5C 24 48 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 F2 0F 10 64 24 30 F2 0F 10 0D ?? ?? ?? ?? 44 8B 44 24 30 41 8B C8 83 E1 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 44 8D 0C 09 F2 0F 59 E3 F2 0F 5C C2 8D 4C 09 01 F2 0F 5C C4 F2 0F 59 C8 41 C1 E8 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 41 81 C0 FE 03 00 00 41 81 E0 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 41 81 F8 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 43 0F 10 04 CA F2 0F 59 C8 F2 41 0F 58 0C CA F2 0F 58 C8 77 2A 49 C1 EB 30 41 C1 E0 04 41 81 E3 0F 80 FF FF 45 0B D8 66 44 89 5C 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 11 4C 24 38 EB 39 41 FF C8 41 81 E0 FF 07 00 00 0F B7 4C 24 4E 41 C1 E0 04 81 E1 0F 80 FF FF 41 0B C8 66 89 4C 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 38 44 8A 44 24 3F 8A 8C 24 D7 00 00 00 41 80 E0 7F 80 E1 80 44 0A C1 44 88 44 24 3F F2 0F 5A 44 24 38 F3 0F 11 02 EB 37 F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C2 F2 0F 5A C0 F3 0F 11 02 EB 1C F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 5A C0 F3 0F 11 02 44 0F 28 84 24 C0 00 00 00 44 0F 28 8C 24 B0 00 00 00 44 0F 28 94 24 A0 00 00 00 44 0F 28 9C 24 90 00 00 00 44 0F 28 A4 24 80 00 00 00 44 0F 28 6C 24 70 44 0F 28 74 24 60 44 0F 28 7C 24 50 48 81 C4 D8 00 00 00 C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 11 54 24 40 F3 0F 5A 11 F2 0F 10 4C 24 40 4C 89 5C 24 48 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 EB 8A F3 0F 58 D2 F3 0F 11 12 EB 80 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__common_spow_cout_rare"
		size = 2976
		refs = "0187 _2il0floatpacket_112 01b7 _vmlsPowHATab 01e9 _2il0floatpacket_113 0390 _2il0floatpacket_115 039f _2il0floatpacket_114 050f _2il0floatpacket_124 063f _2il0floatpacket_116 0669 _2il0floatpacket_117 0681 _2il0floatpacket_118 068d _2il0floatpacket_119 07c5 _2il0floatpacket_120 07ea _2il0floatpacket_121 0836 _2il0floatpacket_122 0845 _2il0floatpacket_123 098d _2il0floatpacket_126"
	strings:
		$1 = { 53 41 54 41 55 41 57 55 48 81 EC 90 00 00 00 33 C0 F3 0F 10 21 66 0F EF C0 F3 0F 10 1A 0F 28 CC 8B 12 0F 28 D3 44 0F 29 7C 24 60 44 0F 29 74 24 70 44 0F 29 AC 24 80 00 00 00 44 0F 29 44 24 50 0F 29 7C 24 40 8B 09 0F 2E E0 7A 02 74 06 89 4C 24 28 EB 0D 0F 28 CC F3 0F 58 CC F3 0F 11 4C 24 28 0F 2E D8 7A 02 74 06 89 54 24 3C EB 0D 0F 28 D3 F3 0F 58 D3 F3 0F 11 54 24 3C 66 0F 7E D5 41 BC 01 00 00 00 45 33 DB F7 44 24 28 FF FF 7F 00 0F B7 54 24 3E 45 0F 44 DC 45 33 D2 81 E5 FF FF FF 7F 81 E2 80 7F 00 00 45 33 C9 F7 44 24 3C FF FF 7F 00 44 0F B7 7C 24 2A 45 0F 44 D4 41 81 E7 80 7F 00 00 C1 EA 07 8D 8D 00 00 80 C0 81 FA FF 00 00 00 44 0F B6 6C 24 2B 8A 5C 24 3F 45 0F 45 CC 41 81 E5 80 00 00 00 80 E3 80 41 C1 EF 07 41 C1 ED 07 C0 EB 07 81 F9 00 00 00 40 73 3E 81 FD 00 00 80 4B 0F 8D 27 05 00 00 8B CD 81 E1 00 00 80 FF 81 C1 00 00 80 00 C1 E9 17 D3 E5 F7 C5 FF FF 7F 00 75 17 81 E5 FF FF FF 00 81 FD 00 00 80 00 BD 02 00 00 00 41 0F 44 EC EB 02 33 ED 45 85 ED 75 0A 41 83 FF 7F 0F 84 3C 0A 00 00 85 D2 75 09 45 85 D2 0F 85 6C 04 00 00 33 C9 41 81 FF FF 00 00 00 41 0F 45 CC 44 0B D9 0F 84 4B 04 00 00 45 0B D1 0F 84 42 04 00 00 0F 2E C8 7A 06 0F 84 B8 09 00 00 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 83 09 00 00 85 C9 0F 84 BE 03 00 00 45 85 C9 0F 84 B5 03 00 00 0F 2F C8 77 08 85 ED 0F 84 7D 03 00 00 41 23 ED 48 8D 0D ?? ?? ?? ?? F3 0F 11 4C 24 2C 80 64 24 2F 7F 45 85 FF F3 44 0F 10 B4 A9 CC 05 00 00 B9 00 00 00 00 75 1B F3 0F 10 44 24 2C B9 C0 FF FF FF F3 0F 59 05 ?? ?? ?? ?? F3 0F 11 44 24 2C EB 06 F3 0F 10 44 24 2C F3 0F 11 44 24 30 4C 8D 25 ?? ?? ?? ?? 44 0F B7 54 24 32 4D 8B EC 41 81 E2 7F 80 FF FF 4D 8B FC 41 81 CA 80 3F FF FF 66 44 89 54 24 32 4D 8B D4 8B 6C 24 30 81 E5 00 00 78 00 44 0F B7 4C 24 2E 81 C5 00 00 08 00 41 81 E1 80 7F 00 00 41 C1 E9 07 C1 ED 14 44 8B 5C 24 2C 41 C1 E1 17 41 81 E3 FF FF 7F 00 45 0B CB 41 81 C1 00 00 C8 C0 4D 8B DD 41 C1 F9 17 44 03 C9 F3 45 0F 10 04 AC 03 ED F3 45 0F 2A E9 F3 0F 10 6C 24 30 4D 8B CD 0F 28 FD F3 41 0F 10 64 AD 24 F3 41 0F 59 F8 44 0F 28 FC F3 45 0F 58 FD 66 0F 7E F9 F3 44 0F 11 7C 24 34 81 E1 00 00 1E 00 F3 44 0F 10 7C 24 34 81 C1 00 00 02 00 C1 E9 12 F3 45 0F 5C EF F3 41 0F 58 E5 F3 41 0F 10 5C 8F 6C 03 C9 F3 0F 11 64 24 38 F3 44 0F 10 7C 24 34 41 0F 28 E7 F3 0F 59 FB F3 44 0F 59 C3 66 41 0F 7E FC F3 41 0F 10 84 8A 90 00 00 00 0F 28 DD F3 44 0F 10 6C 24 38 F3 0F 58 E0 F3 0F 11 64 24 34 41 81 E4 00 C0 07 00 F3 0F 10 64 24 34 41 81 C4 00 40 00 00 41 C1 EC 0F F3 44 0F 5C FC F3 44 0F 58 F8 F3 43 0F 10 94 A3 D8 00 00 00 45 03 E4 F3 44 0F 11 7C 24 38 F3 0F 10 64 24 34 44 0F 28 FC F3 43 0F 10 8C A5 1C 01 00 00 F3 0F 10 44 24 38 F3 44 0F 58 F9 F3 44 0F 58 E8 F3 44 0F 59 C2 F3 44 0F 11 7C 24 34 F3 44 0F 10 7C 24 34 F3 41 0F 5C E7 F3 0F 59 FA F3 0F 58 E1 F3 0F 10 15 ?? ?? ?? ?? 0F 28 C7 F3 0F 59 DA F3 0F 5C 05 ?? ?? ?? ?? F3 0F 11 64 24 38 F3 0F 10 64 24 34 F3 0F 10 4C 24 38 F3 0F 11 5C 24 34 F3 44 0F 58 E9 F3 0F 10 4C 24 34 F3 0F 5C 4C 24 30 F3 45 0F 58 6C A9 28 F3 0F 11 4C 24 38 49 8B ED F3 0F 10 4C 24 34 F3 44 0F 10 7C 24 38 F3 41 0F 5C CF F3 44 0F 58 AC 8D 94 00 00 00 F3 0F 11 4C 24 34 F3 0F 10 5C 24 34 F3 0F 5C EB F3 47 0F 58 AC A7 20 01 00 00 F3 0F 11 6C 24 38 41 0F 28 E8 F3 0F 59 EA F3 44 0F 10 7C 24 34 F3 0F 10 4C 24 38 F3 0F 11 6C 24 34 F3 0F 10 54 24 34 F3 41 0F 5C D0 F3 0F 11 54 24 38 F3 0F 10 54 24 34 F3 0F 10 5C 24 38 F3 0F 5C D3 41 0F 28 DF F3 0F 11 54 24 34 F3 0F 10 6C 24 34 F3 44 0F 5C C5 F3 44 0F 11 44 24 38 F3 44 0F 10 44 24 34 F3 41 0F 59 D8 F3 44 0F 59 C1 F3 0F 5C DF 0F 28 F8 F3 41 0F 58 D8 F3 0F 58 FC F3 0F 10 54 24 38 F3 0F 11 7C 24 34 F3 44 0F 59 FA F3 0F 59 CA F3 41 0F 58 DF F3 0F 10 54 24 34 F3 0F 58 CB F3 0F 5C E2 F3 0F 58 E0 F3 0F 11 64 24 38 F3 0F 10 5C 24 34 F3 0F 11 5C 24 28 0F B7 4C 24 2A 81 E1 80 7F 00 00 C1 E9 07 03 D1 F3 0F 10 54 24 38 81 FA 09 01 00 00 0F 8D F3 05 00 00 81 FA C0 00 00 00 0F 8F 3E 01 00 00 C7 44 24 34 00 00 80 3F F3 0F 10 44 24 34 F3 0F 58 05 ?? ?? ?? ?? F3 0F 11 44 24 34 F3 0F 10 4C 24 34 F3 44 0F 59 F1 F3 45 0F 11 30 E9 D3 00 00 00 33 C0 89 44 24 34 41 8B C4 F3 0F 10 4C 24 34 F3 0F 10 44 24 34 F3 0F 5E C8 F3 0F 11 4C 24 34 8B 54 24 34 41 89 10 E9 A8 00 00 00 41 83 FF 7F 7D 1C 84 DB 74 0E F3 0F 59 D2 F3 41 0F 11 10 E9 90 00 00 00 33 D2 41 89 10 E9 86 00 00 00 84 DB 74 1A 41 23 ED 48 8D 15 ?? ?? ?? ?? 8B 8C AA E8 05 00 00 89 4C 24 2C 41 89 08 EB 68 F3 0F 59 C9 41 23 ED F3 0F 59 D1 48 8D 15 ?? ?? ?? ?? F3 0F 59 94 AA CC 05 00 00 F3 41 0F 11 10 EB 46 F3 0F 58 E3 F3 41 0F 11 20 EB 3B F3 0F 58 CA F3 0F 11 4C 24 34 C7 44 24 38 00 00 80 3F 8A 54 24 37 8A 4C 24 3B 80 E2 80 80 E1 7F 0A CA 88 4C 24 3B F3 0F 10 4C 24 38 F3 0F 10 44 24 38 F3 0F 59 C8 F3 41 0F 11 08 0F 28 7C 24 40 44 0F 28 44 24 50 44 0F 28 AC 24 80 00 00 00 44 0F 28 74 24 70 44 0F 28 7C 24 60 48 81 C4 90 00 00 00 5D 41 5F 41 5D 41 5C 5B C3 BD 02 00 00 00 E9 03 FB FF FF F3 0F 10 2D ?? ?? ?? ?? 48 8D 1D ?? ?? ?? ?? F3 44 0F 10 44 24 28 48 8B EB F3 0F 58 C1 F3 0F 58 CA F3 0F 59 E8 F3 44 0F 58 E9 F3 0F 58 2D ?? ?? ?? ?? F3 0F 59 E8 45 0F 28 FD F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 2D ?? ?? ?? ?? F3 0F 59 E8 F3 0F 58 2D ?? ?? ?? ?? F3 0F 59 E8 F3 0F 58 DD F3 0F 11 5C 24 34 F3 0F 10 7C 24 34 F3 44 0F 5C C7 F3 44 0F 58 C5 F3 44 0F 11 44 24 38 F3 0F 10 44 24 34 F3 0F 10 54 24 38 F3 44 0F 58 F8 F3 44 0F 11 7C 24 34 F3 0F 10 64 24 34 F3 0F 5C C4 F3 41 0F 58 C5 44 0F 28 E9 F3 0F 11 44 24 38 F3 0F 10 44 24 34 F3 44 0F 59 E8 F3 0F 10 64 24 38 F3 44 0F 11 6C 24 34 F3 0F 58 E2 F3 0F 10 5C 24 34 F3 0F 59 64 24 3C F3 0F 5C D8 F3 0F 11 5C 24 38 F3 0F 10 7C 24 34 F3 0F 10 6C 24 38 F3 0F 5C FD F3 0F 10 6C 24 3C F3 0F 59 CD F3 0F 11 7C 24 34 F3 44 0F 10 44 24 34 F3 41 0F 5C C0 F3 0F 11 44 24 38 F3 0F 10 54 24 34 F3 0F 10 5C 24 38 F3 0F 11 4C 24 34 F3 0F 10 44 24 34 F3 0F 5C 44 24 3C F3 0F 11 44 24 38 F3 44 0F 10 6C 24 34 F3 44 0F 10 7C 24 38 F3 45 0F 5C EF F3 44 0F 11 6C 24 34 F3 0F 10 44 24 34 F3 0F 5C E8 F3 0F 11 6C 24 38 F3 0F 10 7C 24 34 F3 0F 10 4C 24 38 44 0F 28 EF 0F 28 C1 F3 0F 59 C3 F3 0F 59 FB F3 44 0F 59 EA F3 0F 59 D1 F3 0F 58 C7 F3 0F 10 1D ?? ?? ?? ?? F3 0F 58 C2 41 0F 28 D5 F3 0F 58 E0 F3 0F 58 D3 F3 0F 11 54 24 34 F3 44 0F 10 44 24 34 F3 0F 10 0D ?? ?? ?? ?? F3 44 0F 5C C3 F3 44 0F 11 44 24 20 F3 44 0F 10 7C 24 20 8B 4C 24 34 8B D1 83 E1 7F F3 45 0F 5C EF F3 44 0F 11 6C 24 24 03 C9 F3 0F 10 44 24 24 F3 0F 58 E0 F3 0F 59 CC F3 0F 10 84 8B A4 01 00 00 C1 E2 0A F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CC C1 FA 11 F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CC F3 0F 59 C8 F3 0F 58 8C 8D A8 01 00 00 0F 28 D1 F3 0F 58 D0 F3 0F 11 54 24 2C 0F B7 5C 24 2E 8B CB 81 E1 80 7F 00 00 C1 E9 07 83 C1 81 03 CA 81 F9 80 00 00 00 0F 8D 22 02 00 00 83 F9 82 7C 31 83 C1 7F 81 E3 7F 80 FF FF 0F B6 C9 C1 E1 07 0B D9 66 89 5C 24 2E F3 0F 10 44 24 2C F3 41 0F 59 C6 F3 0F 11 44 24 2C F3 41 0F 11 00 E9 43 FD FF FF 81 F9 78 FF FF FF 0F 8C 20 01 00 00 F3 0F 11 54 24 34 83 C2 40 F3 0F 10 54 24 34 B9 00 00 80 3F 89 4C 24 28 83 C2 7F C1 E9 10 F3 0F 5C C2 0F B7 D9 F3 0F 58 C1 F3 0F 11 44 24 38 81 E3 7F 80 FF FF F3 44 0F 10 44 24 34 F3 0F 10 0D ?? ?? ?? ?? F3 41 0F 59 C8 F3 0F 10 44 24 38 F3 0F 11 4C 24 34 F3 0F 10 5C 24 34 0F B6 D2 F3 41 0F 5C D8 F3 0F 11 5C 24 38 F3 0F 10 6C 24 34 F3 0F 10 64 24 38 C1 E2 07 F3 0F 5C EC F3 0F 11 6C 24 34 0B DA F3 0F 10 7C 24 34 66 89 5C 24 2A F3 44 0F 5C C7 F3 44 0F 11 44 24 38 F3 0F 10 5C 24 34 F3 44 0F 10 6C 24 38 F3 44 0F 10 7C 24 28 F3 41 0F 58 C5 F3 41 0F 59 DF F3 41 0F 59 C7 F3 44 0F 10 2D ?? ?? ?? ?? F3 41 0F 59 C5 F3 41 0F 59 DD F3 0F 11 44 24 34 F3 0F 10 44 24 34 C7 44 24 34 00 00 80 00 F3 0F 58 D8 F3 0F 10 4C 24 34 F3 44 0F 10 7C 24 34 F3 41 0F 59 CF F3 0F 11 4C 24 34 F3 0F 10 54 24 34 F3 0F 58 DA F3 44 0F 59 F3 F3 0F 11 5C 24 2C F3 45 0F 11 30 E9 17 FC FF FF 81 F9 61 FF FF FF 7C 7E B9 00 00 80 3F 81 C2 BF 00 00 00 89 4C 24 28 C1 E9 10 0F B7 D9 0F B6 D2 81 E3 7F 80 FF FF C1 E2 07 0B DA 66 89 5C 24 2A F3 0F 10 05 ?? ?? ?? ?? F3 0F 10 4C 24 28 F3 44 0F 59 F0 F3 0F 59 D1 C7 44 24 34 00 00 80 00 F3 44 0F 59 F2 F3 0F 10 54 24 34 F3 0F 10 5C 24 34 F3 0F 59 DA F3 0F 11 5C 24 34 F3 0F 10 64 24 34 F3 44 0F 58 F4 F3 44 0F 11 74 24 2C F3 45 0F 11 30 E9 91 FB FF FF C7 44 24 34 00 00 80 00 F3 0F 10 44 24 34 F3 0F 10 4C 24 34 F3 0F 59 C8 F3 0F 11 4C 24 34 F3 0F 10 54 24 34 F3 44 0F 59 F2 F3 44 0F 11 74 24 2C F3 45 0F 11 30 E9 57 FB FF FF C7 44 24 34 00 00 00 7F F3 0F 10 4C 24 34 F3 0F 10 44 24 34 F3 0F 59 C8 F3 0F 11 4C 24 34 F3 0F 10 54 24 34 F3 44 0F 59 F2 F3 44 0F 11 74 24 2C F3 45 0F 11 30 E9 1D FB FF FF 8A 54 24 2B 48 8D 0D ?? ?? ?? ?? 80 E2 80 C0 EA 07 32 DA 0F B6 DB F3 0F 10 84 99 C0 05 00 00 F3 0F 59 C0 F3 41 0F 59 C6 F3 41 0F 11 00 E9 EB FA FF FF 85 ED 75 09 45 85 C9 0F 85 70 F6 FF FF 83 E5 01 48 8D 15 ?? ?? ?? ?? 8B 8C AA CC 05 00 00 41 89 08 E9 C5 FA FF FF F3 0F 59 C9 84 DB 74 24 41 23 ED 48 8D 05 ?? ?? ?? ?? F3 0F 10 84 A8 CC 05 00 00 41 8B C4 F3 0F 5E C1 F3 41 0F 11 00 E9 99 FA FF FF 41 23 ED 48 8D 15 ?? ?? ?? ?? F3 0F 10 84 AA CC 05 00 00 F3 0F 59 C1 F3 41 0F 11 00 E9 78 FA FF FF 45 85 DB 0F 84 BB F5 FF FF E9 2F FA FF FF 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "__sse2_atan22"
		size = 736
		refs = "0027 iSignMask 005c dbPio2hi 00b8 iAbsMask 00d8 iMinWorkNum 00e1 iMaxWorkNum 012c dbPi 0158 dbA19 0160 dbA18 0168 dbA17 0170 dbA16 0193 dbA15 019b dbA14 01a3 dbA13 01ab dbA12 01c3 dbA11 01cb dbA10 01d3 dbA09 01db dbA08 01f3 dbA07 01fb dbA06 0203 dbA05 020b dbA04 0223 dbA03 022b dbA02 0233 dbA01 023b dbA00"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F 29 44 24 60 66 0F 29 4C 24 70 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F 29 54 24 20 66 0F 29 5C 24 30 66 0F 57 C2 66 0F 57 CB 66 0F 28 D0 66 0F C2 D1 05 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC 66 0F 28 E2 66 0F 28 E8 66 0F 28 F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 66 0F 5E CA 66 0F 28 64 24 60 66 0F 28 6C 24 60 66 0F 28 74 24 70 66 0F 28 7C 24 70 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F C2 25 ?? ?? ?? ?? 06 66 0F C2 2D ?? ?? ?? ?? 01 66 0F C2 35 ?? ?? ?? ?? 06 66 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 C4 83 F8 03 89 84 24 A0 00 00 00 0F 8C 63 01 00 00 66 0F 28 64 24 30 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F 29 64 24 40 66 0F 29 5C 24 50 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 C7 84 24 A0 00 00 00 03 00 00 00 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 50 66 0F 56 74 24 30 66 0F 58 74 24 40 66 0F 56 74 24 20 66 0F 28 C6 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 83 BC 24 A0 00 00 00 03 7D 34 F2 0F 10 44 24 60 F2 0F 10 4C 24 70 E8 3A 00 00 00 F2 0F 11 44 24 60 F2 0F 10 44 24 68 F2 0F 10 4C 24 78 E8 23 00 00 00 F2 0F 11 44 24 68 66 0F 28 44 24 60 48 81 C4 A8 00 00 00 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_183_1_0 {
	meta:
		name = "__common_atan2_sd"
		size = 944
		refs = "0027 iSignMask 005c dbPio2hi 00b8 iAbsMask 00d8 iMinWorkNum 00e1 iMaxWorkNum 0125 dbPi 0151 dbA19 0159 dbA18 0161 dbA17 0169 dbA16 0181 dbA15 0189 dbA14 0191 dbA13 0199 dbA12 01b1 dbA11 01b9 dbA10 01c1 dbA09 01c9 dbA08 01e1 dbA07 01e9 dbA06 01f1 dbA05 01f9 dbA04 0211 dbA03 0219 dbA02 0221 dbA01 0229 dbA00 027e dbZero 0336 db3Pio4hi 0348 dbPio4hi"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F D6 44 24 20 66 0F D6 4C 24 30 F3 0F 7E 15 ?? ?? ?? ?? F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F D6 54 24 40 66 0F D6 5C 24 50 66 0F 57 C2 66 0F 57 CB F3 0F 7E D0 F2 0F C2 D1 05 F3 0F 7E 1D ?? ?? ?? ?? F3 0F 7E E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC F3 0F 7E E2 F3 0F 7E E8 F3 0F 7E F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 F2 0F 5E CA F3 0F 7E 64 24 20 F3 0F 7E 6C 24 20 F3 0F 7E 74 24 30 F3 0F 7E 7C 24 30 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F C2 25 ?? ?? ?? ?? 06 F2 0F C2 2D ?? ?? ?? ?? 01 F2 0F C2 35 ?? ?? ?? ?? 06 F2 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 D4 83 E2 01 0F 84 5D 01 00 00 F3 0F 7E 64 24 50 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F D6 64 24 60 66 0F D6 5C 24 70 F3 0F 7E E1 F2 0F 59 C9 F3 0F 7E E9 F2 0F 59 C9 F3 0F 7E C1 F2 0F 59 C9 F3 0F 7E 15 ?? ?? ?? ?? F3 0F 7E 1D ?? ?? ?? ?? F3 0F 7E 35 ?? ?? ?? ?? F3 0F 7E 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D0 F2 0F 59 D5 F2 0F 59 D8 F2 0F 59 F5 F2 0F 58 D3 F2 0F 58 F7 F2 0F 58 F2 F2 0F 59 F4 F2 0F 58 74 24 70 66 0F 56 74 24 50 F2 0F 58 74 24 60 66 0F 56 74 24 40 F3 0F 7E C6 E9 10 01 00 00 F3 0F 7E 54 24 20 F3 0F 7E 5C 24 30 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? 66 0F EB 54 24 40 66 0F EB 5C 24 50 66 0F D6 54 24 20 66 0F D6 5C 24 30 F3 0F 7E 44 24 20 48 8B 44 24 20 48 8B 54 24 30 48 23 05 ?? ?? ?? ?? 48 23 15 ?? ?? ?? ?? 48 3B 05 ?? ?? ?? ?? 0F 8F A5 00 00 00 74 42 48 3B 15 ?? ?? ?? ?? 0F 8F 96 00 00 00 48 23 D2 74 1B 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 75 71 66 0F 54 05 ?? ?? ?? ?? E9 82 00 00 00 48 23 C0 75 4D 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 75 51 EB DE 48 3B 15 ?? ?? ?? ?? 7F 58 7C 32 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 74 12 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 42 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 30 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 1E 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 0C F3 0F 7E 44 24 20 F2 0F 59 44 24 30 F2 0F 11 84 24 A0 00 00 00 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 F2 0F 10 84 24 A0 00 00 00 48 81 C4 A8 00 00 00 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "__avx_cosh4"
		size = 720
		refs = "000a __common_dcosh_data 02bb __common_dcosh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 05 ?? ?? ?? ?? C5 7C 11 B4 24 70 01 00 00 C5 7C 11 A4 24 30 01 00 00 C5 7C 11 94 24 50 01 00 00 C5 7C 11 8C 24 F0 01 00 00 C5 7C 11 84 24 D0 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 90 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 CF 00 00 00 C5 FD 10 15 ?? ?? ?? ?? 49 83 E5 C0 C5 FD 10 1D ?? ?? ?? ?? C5 78 10 15 ?? ?? ?? ?? C5 F9 10 2D ?? ?? ?? ?? C5 ED 55 E0 C5 DD 59 3D ?? ?? ?? ?? C5 C5 58 F3 C5 F1 73 D2 0B C4 C3 7D 19 D6 01 C4 C1 69 73 D6 0B C4 C3 7D 19 E1 01 C4 C3 7D 19 F6 01 C4 41 58 C6 E1 DD C4 C1 48 C6 FE 88 C5 19 66 05 ?? ?? ?? ?? C5 41 DB 0D ?? ?? ?? ?? C4 C1 78 50 D0 C4 C1 39 72 F1 03 C5 79 7E C1 C4 41 29 FA D1 C4 C1 19 72 F2 03 C4 41 79 7E E3 48 63 C9 C4 43 79 16 C0 01 4D 63 C0 C4 43 79 16 C1 02 4D 63 C9 C5 FB 10 3C 01 C4 41 41 16 14 00 C4 43 79 16 E0 02 C4 41 7B 10 0C 01 4D 63 C0 C4 43 79 16 E1 03 4D 63 C9 C4 63 79 16 E1 01 C4 C1 7B 10 3C 00 4D 63 DB C4 41 41 16 24 01 C5 CD 5C FB C5 C5 59 1D ?? ?? ?? ?? C5 C5 59 3D ?? ?? ?? ?? C5 DD 5C DB C5 D9 73 F6 2C C4 C1 49 73 F6 2C C5 D9 DB E5 C5 C9 DB ED C4 43 79 16 C2 03 48 63 C9 4D 63 D2 C4 41 7B 10 04 03 C5 E5 5C DF C5 39 16 04 01 C4 41 31 16 0C 02 C5 29 D4 F4 C5 B9 FB E4 C5 31 D4 CD C5 99 FB ED C5 D9 FB C9 C5 D1 FB D2 C5 E5 59 FB C5 45 59 15 ?? ?? ?? ?? C5 2D 58 25 ?? ?? ?? ?? C4 43 0D 18 C9 01 C4 E3 75 18 E2 01 C5 35 5C C4 C5 B5 58 D4 C5 45 59 0D ?? ?? ?? ?? C5 9D 59 FF C5 B5 59 F3 C5 45 59 F2 C5 CD 58 DB C4 C1 65 59 C8 C5 8D 58 D9 C5 E5 58 CA 85 D2 75 53 C5 FC 10 B4 24 90 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 84 24 D0 01 00 00 C5 7C 10 8C 24 F0 01 00 00 C5 7C 10 94 24 50 01 00 00 C5 7C 10 A4 24 30 01 00 00 C5 7C 10 B4 24 70 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 9F 33 C0 C5 7C 11 5C 24 60 C5 7C 11 6C 24 40 C5 7C 11 7C 24 20 48 89 9C 24 88 00 00 00 8B D8 48 89 B4 24 80 00 00 00 8B F2 0F A3 DE 72 34 FF C3 83 FB 20 7C F4 C5 7C 10 5C 24 60 C5 7C 10 6C 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 88 00 00 00 48 8B B4 24 80 00 00 00 E9 3E FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB B8 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "__avx_atan2f8"
		size = 672
		refs = "005a __common_satan2_data 029a __common_satan2_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 C5 7C 11 BC 24 70 01 00 00 C5 7C 11 A4 24 30 02 00 00 C5 7C 11 9C 24 D0 01 00 00 C5 7C 11 94 24 10 02 00 00 C5 7C 11 84 24 F0 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 90 01 00 00 4C 89 AC 24 50 02 00 00 4C 8D AC 24 CF 00 00 00 C5 FC 10 35 ?? ?? ?? ?? 49 83 E5 C0 C5 74 C2 1D ?? ?? ?? ?? 12 C5 F4 54 EE C5 FC 54 D6 C5 6C C2 D5 11 C5 D4 56 3D ?? ?? ?? ?? C4 E3 45 4A E2 A0 C4 63 6D 4A FD A0 C5 A4 54 3D ?? ?? ?? ?? C4 41 5C 5E DF C5 F8 10 25 ?? ?? ?? ?? C5 78 10 3D ?? ?? ?? ?? C5 74 57 C5 C5 FC 57 F2 C5 2C 55 15 ?? ?? ?? ?? C4 C3 7D 19 EC 01 C5 D1 FA EC C4 E3 7D 19 D3 01 C5 19 FA E4 C5 E9 FA D4 C5 E1 FA DC C4 C1 51 66 E7 C4 C1 51 76 EF C5 D9 EB E5 C4 C1 69 66 EF C4 C1 69 76 D7 C5 D1 EB D2 C4 C1 61 66 EF C5 D9 EB D2 C4 C1 19 66 E7 C4 41 19 76 E7 C4 C1 61 76 DF C4 C1 59 EB E4 C5 51 EB FB C4 C1 59 EB E7 C5 E9 6B D4 C5 E1 EF DB C4 C1 24 59 E3 C5 E9 63 EB C5 F9 D7 D5 C5 5C 59 FC C5 04 59 25 ?? ?? ?? ?? C5 84 59 15 ?? ?? ?? ?? C5 9C 58 1D ?? ?? ?? ?? C5 6C 58 25 ?? ?? ?? ?? C4 C1 64 59 EF C4 41 1C 59 E7 C5 D4 58 15 ?? ?? ?? ?? C5 9C 58 2D ?? ?? ?? ?? C4 C1 6C 59 DF C4 C1 54 59 EF C5 E4 58 15 ?? ?? ?? ?? C5 D4 58 1D ?? ?? ?? ?? C4 41 6C 59 FF C5 E4 59 E4 C5 84 58 15 ?? ?? ?? ?? C5 DC 58 DA C4 41 64 59 DB C4 41 24 58 D2 C4 41 2C 56 C0 C5 BC 58 D7 C5 EC 56 D6 84 D2 75 53 C5 FC 10 B4 24 90 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 84 24 F0 01 00 00 C5 7C 10 94 24 10 02 00 00 C5 7C 10 9C 24 D0 01 00 00 C5 7C 10 A4 24 30 02 00 00 C5 7C 10 BC 24 70 01 00 00 4C 8B AC 24 50 02 00 00 C5 FC 28 C2 48 81 C4 58 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 C4 C1 7C 11 95 80 00 00 00 85 D2 74 94 33 C0 C5 7C 11 4C 24 60 C5 7C 11 6C 24 40 C5 7C 11 74 24 20 48 89 9C 24 88 00 00 00 8B D8 48 89 B4 24 80 00 00 00 8B F2 0F A3 DE 72 37 FF C3 83 FB 20 7C F4 C5 7C 10 4C 24 60 C5 7C 10 6C 24 40 C5 7C 10 74 24 20 C4 C1 7C 10 95 80 00 00 00 48 8B 9C 24 88 00 00 00 48 8B B4 24 80 00 00 00 E9 30 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 4D 8D 84 9D 80 00 00 00 E8 ?? ?? ?? ?? EB AD }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__sse2_log10f4"
		size = 704
		refs = "0012 flMantissaMask 001a s_dwPosInf 0022 s_dwSqrt2Addition 002d s_fOne 003d s_dwSqrt2Mask 0068 s_dwExpBias 0073 s_fInvLn10 00b0 s_fB2 00ca s_fB1 00d1 s_fB0 00db s_fLg2 0130 s_dwAbsMask 013c s_dwPosZero 0144 s_dwNegInf 0164 s_dwSpecial1 016c s_dwSpecial2 0196 s_fDenoAdd"
	strings:
		$1 = { 48 83 EC 78 0F 29 7C 24 50 0F 29 74 24 60 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 2D ?? ?? ?? ?? 0F 58 EC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 66 0F FE C2 0F 28 15 ?? ?? ?? ?? 0F 59 D4 0F 5E E5 C7 44 24 70 01 00 00 00 0F 29 4C 24 20 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 5B C0 0F 28 EC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 81 FA FF FF 00 00 75 32 C7 44 24 70 00 00 00 00 0F 59 DC 0F 59 25 ?? ?? ?? ?? 0F 58 1D ?? ?? ?? ?? 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DC 0F 5C DA 0F 59 DD 0F 58 DA 0F 58 C3 83 7C 24 70 00 75 0F 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 0F 28 54 24 20 0F 28 F2 66 0F EF FF 66 0F 6F C6 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 6F C6 66 0F DB 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 66 0D ?? ?? ?? ?? 66 0F DB CE 66 0F EB F9 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 7F 7C 24 30 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F DB 0D ?? ?? ?? ?? 66 0F 7F 4C 24 40 66 0F 6F C8 66 0F 6F D6 66 0F EB 15 ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 66 0F DB C2 66 0F 76 3D ?? ?? ?? ?? 66 0F DB F7 66 0F DF 3D ?? ?? ?? ?? 66 0F EB FE 66 0F DF CF 66 0F EB C1 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 3D ?? ?? ?? ?? 0F 58 FC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 EC 0F 5E E7 66 0F FE C2 0F 28 D1 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 5B C0 0F 28 FC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 59 DC 0F 59 D4 0F 58 1D ?? ?? ?? ?? 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DA 0F 5C DD 0F 59 DF 0F 58 DD 0F 58 C3 66 0F EB 44 24 30 0F 58 44 24 40 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 66 90 }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "__common_dsin_cout_rare"
		size = 128
		refs = "0045 _vmldSinHATab"
	strings:
		$1 = { 48 83 EC 28 48 8B 01 48 89 44 24 20 48 C1 E8 38 44 0F B7 41 06 41 81 E0 F0 7F 00 00 83 E0 7F F2 0F 10 09 41 81 F8 F0 7F 00 00 75 3E 83 7C 24 20 00 75 28 88 44 24 27 81 7C 24 24 00 00 F0 7F 75 1A F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 48 83 C4 28 C3 F2 0F 59 C9 33 C0 F2 0F 11 0A 48 83 C4 28 C3 33 C0 48 83 C4 28 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "__common_dcos_cout_rare"
		size = 128
		refs = "0045 _vmldCosHATab"
	strings:
		$1 = { 48 83 EC 28 48 8B 01 48 89 44 24 20 48 C1 E8 38 44 0F B7 41 06 41 81 E0 F0 7F 00 00 83 E0 7F F2 0F 10 09 41 81 F8 F0 7F 00 00 75 3E 83 7C 24 20 00 75 28 88 44 24 27 81 7C 24 24 00 00 F0 7F 75 1A F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 48 83 C4 28 C3 F2 0F 59 C9 33 C0 F2 0F 11 0A 48 83 C4 28 C3 33 C0 48 83 C4 28 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "__sse4_floorf4"
		size = 16
	strings:
		$1 = { 66 0F 3A 08 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "??_N@YAXPEAX_K1P6AX0@Z2@Z"
		size = 116
		refs = "003a _guard_check_icall"
	strings:
		$1 = { 48 8B C4 48 89 58 18 48 89 70 20 48 89 50 10 48 89 48 08 57 41 56 41 57 48 83 EC 30 4D 8B F9 4D 8B F0 48 8B F2 48 8B F9 33 DB 48 89 58 E0 88 58 D8 49 3B DE 74 25 49 8B CF E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF 41 FF D7 48 03 FE 48 89 7C 24 50 48 FF C3 48 89 5C 24 28 EB D6 C6 44 24 20 01 48 8B 5C 24 60 48 8B 74 24 68 48 83 C4 30 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "__chkstk"
		size = 81
	strings:
		$1 = { 48 83 EC 10 4C 89 14 24 4C 89 5C 24 08 4D 33 DB 4C 8D 54 24 18 4C 2B D0 4D 0F 42 D3 65 4C 8B 1C 25 10 00 00 00 4D 3B D3 F2 73 17 66 41 81 E2 00 F0 4D 8D 9B 00 F0 FF FF 41 C6 03 00 4D 3B D3 F2 75 EF 4C 8B 14 24 4C 8B 5C 24 08 48 83 C4 10 F2 C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "??2@YAPEAX_K@Z"
		size = 60
		refs = "000f _callnewh 001e ?__scrt_throw_std_bad_array_new_length@@YAXXZ 0025 ?__scrt_throw_std_bad_alloc@@YAXXZ 002d malloc"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 EB 21 48 8B CB E8 ?? ?? ?? ?? 85 C0 75 12 48 83 FB FF 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 85 C0 74 D5 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "__dyn_tls_init"
		size = 82
		refs = "0012 __xd_a 001e __xd_z 0033 _guard_check_icall 0042 terminate"
	strings:
		$1 = { 83 FA 02 75 4C 48 89 5C 24 08 57 48 83 EC 30 48 8D 1D ?? ?? ?? ?? 48 89 5C 24 20 48 8D 05 ?? ?? ?? ?? 48 3B D8 74 18 48 8B 3B 48 85 FF 74 0A 48 8B CF E8 ?? ?? ?? ?? FF D7 48 83 C3 08 EB D7 EB 06 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_199_1_0 {
	meta:
		name = "__dyn_tls_init$filt$0"
		size = 27
		refs = "000f dyntls_init_exception_filter"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 8B 08 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "__avx_tanf8"
		size = 3696
		refs = "007d __common_stan_data 0234 __common_stan_cout_rare 02f3 __common_stan_reduction_data"
	strings:
		$1 = { 53 55 48 81 EC C8 02 00 00 33 DB C5 7C 11 BC 24 A0 02 00 00 C5 F1 EF C9 C5 7C 11 B4 24 80 02 00 00 C5 7C 11 AC 24 60 02 00 00 C5 7C 11 A4 24 40 02 00 00 C5 7C 11 9C 24 C0 01 00 00 C5 7C 11 94 24 80 01 00 00 C5 7C 11 8C 24 E0 01 00 00 C5 7C 11 84 24 00 02 00 00 C5 FC 11 BC 24 A0 01 00 00 C5 FC 11 B4 24 20 02 00 00 4C 89 AC 24 D8 00 00 00 4C 8D AC 24 1F 01 00 00 C5 FC 10 2D ?? ?? ?? ?? 49 83 E5 C0 C5 7C 54 C5 C5 BC C2 15 ?? ?? ?? ?? 1E C5 D4 55 E8 C4 E3 7D 19 D3 01 C5 E9 6B E3 C5 D9 63 D1 C5 F9 D7 C2 84 C0 0F 85 8A 01 00 00 C5 FC 10 3D ?? ?? ?? ?? C5 BC 59 35 ?? ?? ?? ?? C5 CC 58 E7 C5 5C 5C EF C5 14 59 0D ?? ?? ?? ?? C5 14 59 15 ?? ?? ?? ?? C5 14 59 25 ?? ?? ?? ?? C5 14 59 3D ?? ?? ?? ?? C4 41 3C 5C C1 C4 41 3C 5C DA C4 41 24 5C F4 C4 C1 0C 5C DF C5 E4 59 D3 C5 6C 59 15 ?? ?? ?? ?? C5 6C 59 0D ?? ?? ?? ?? C5 2C 58 25 ?? ?? ?? ?? C5 34 58 1D ?? ?? ?? ?? C5 9C 59 D2 C5 24 59 F3 C5 EC 58 15 ?? ?? ?? ?? C5 F1 72 F4 1F C4 C3 7D 19 E0 01 C4 C1 49 72 F0 1F C4 E3 75 18 FE 01 C5 C4 57 CD C5 D1 72 F4 1E C4 C1 59 72 F0 1E C5 C4 57 FF C4 E3 55 18 F4 01 C5 4C C2 FF 0C C4 C1 04 55 DE C5 04 54 EA C4 41 04 54 F6 C5 04 55 FA C4 C1 64 56 DD C4 C1 0C 56 E7 C5 E4 5E EC C5 D4 57 C9 84 DB 75 70 C5 FC 10 B4 24 20 02 00 00 C5 FC 10 BC 24 A0 01 00 00 C5 7C 10 84 24 00 02 00 00 C5 7C 10 8C 24 E0 01 00 00 C5 7C 10 94 24 80 01 00 00 C5 7C 10 9C 24 C0 01 00 00 C5 7C 10 A4 24 40 02 00 00 C5 7C 10 AC 24 60 02 00 00 C5 7C 10 B4 24 80 02 00 00 C5 7C 10 BC 24 A0 02 00 00 4C 8B AC 24 D8 00 00 00 C5 FC 28 C1 48 81 C4 C8 02 00 00 5D 5B C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 DB 74 80 33 ED 0F A3 EB 72 12 FF C5 83 FD 20 7C F4 C4 C1 7C 10 4D 40 E9 67 FF FF FF C5 F8 77 49 8D 4C AD 00 49 8D 54 AD 40 E8 ?? ?? ?? ?? EB DA 41 BB 00 00 80 7F C4 C1 7C 11 45 00 C4 41 79 6E CB C4 41 79 70 D1 00 C4 43 2D 18 F2 01 C4 C1 7C 54 EE C4 41 54 C2 FE 00 C5 29 DB E0 C4 E3 7D 19 C6 01 C4 C1 11 72 D4 17 C5 A9 DB E6 C4 C1 21 72 F5 01 C5 89 72 D4 17 C4 41 21 FE CD C4 C1 51 72 F6 01 C4 C1 61 72 F1 02 C4 C1 79 7E DA C5 F8 11 44 24 20 C5 F8 11 74 24 30 C4 C3 79 16 D9 01 C4 C3 79 16 D8 02 C4 E3 79 16 DD 03 C4 43 7D 19 F8 01 C4 C1 01 6B D0 C4 41 51 FE FE C4 C1 11 72 F7 02 C5 E9 63 C9 C5 79 7E E9 C5 F9 D7 D9 C4 63 79 16 EA 01 C4 63 79 16 E8 02 C4 43 79 16 EB 03 89 9C 24 D0 00 00 00 48 8D 1D ?? ?? ?? ?? C4 41 79 6E 04 1A C4 C1 79 6E 3C 19 C4 C1 79 6E 14 18 C5 F9 6E 4C 1D 00 C5 79 6E 0C 19 C5 79 6E 14 1A C5 F9 6E 2C 18 C4 41 79 6E 34 1B C5 39 6C E7 C5 E9 6C E1 C4 41 31 6C FA C4 C1 51 6C DE C4 41 79 6E 74 1B 04 C4 41 79 6E 44 1A 04 C4 C1 79 6E 7C 19 04 C4 C1 79 6E 54 18 04 C5 F9 6E 4C 1D 04 C5 79 6E 4C 19 04 C5 79 6E 54 1A 04 C5 F9 6E 6C 18 04 C5 18 C6 DC 88 C5 00 C6 E3 88 C5 B9 6C E7 C5 69 6C E9 C4 41 31 6C FA C4 C1 51 6C DE C4 41 58 C6 ED 88 C5 80 C6 E3 88 C5 79 6E 7C 18 08 B8 FF FF 7F 00 C5 79 6E 74 1A 08 BA 00 00 80 00 C5 F9 6E 6C 19 08 B9 FF FF 00 00 C4 41 79 6E 44 1A 08 41 BA FF 00 00 00 C4 C1 79 6E 7C 19 08 41 B9 00 00 40 47 C4 C1 79 6E 54 18 08 41 B8 00 00 80 3F C5 F9 6E 4C 1D 08 BD 00 00 00 80 C5 39 6C CF C5 69 6C D1 C5 F9 6E D0 C4 C1 30 C6 CA 88 C5 79 6E CA C5 79 70 D2 00 C5 F9 6E D1 C4 41 51 6C C6 C5 A9 DB C0 C4 C1 79 6E 5C 1B 08 48 8D 1D ?? ?? ?? ?? C5 A9 DB F6 C4 C1 79 70 E9 00 BA FF FF 03 00 C5 81 6C FB C5 79 FE F5 C5 79 70 FA 00 C5 C9 FE F5 C5 B8 C6 DF 88 C4 C1 21 DB FF C5 E9 72 D1 10 C4 C1 29 72 D6 10 C4 41 09 DB CF C4 C1 11 DB EF C5 78 11 5C 24 40 C4 C1 21 72 D5 10 C5 FA 7F 7C 24 60 C5 91 72 D6 10 C4 41 49 DB F7 C5 B9 72 D4 10 C4 E2 31 40 F7 C4 C1 59 DB C7 C4 E2 29 40 FA C4 C1 71 DB CF C4 E2 31 40 D2 C5 D9 72 D3 10 C5 78 11 64 24 50 C4 41 19 DB E7 C5 FA 7F B4 24 B0 00 00 00 C5 E9 72 D2 10 C4 E2 31 40 F5 C5 C1 FE FA C5 7A 7F 64 24 70 C4 C1 61 DB DF C4 42 09 40 E4 B8 00 00 80 28 C5 7A 7F 84 24 90 00 00 00 B9 00 00 00 34 C5 FA 7F 84 24 A0 00 00 00 41 BB 00 F0 FF FF C5 7A 7F A4 24 C0 00 00 00 C4 42 09 40 E0 C4 62 09 40 C0 C4 E2 29 40 C1 C4 C1 49 DB CF C5 F9 72 D0 10 C5 F1 FE D7 C5 F9 FE FA C4 C1 39 DB C7 C4 E2 11 40 D3 C5 C9 72 D6 10 C4 E2 11 40 DC C5 E9 72 D2 10 C4 E2 09 40 E4 C4 C1 39 72 D0 10 C5 F1 72 D4 10 C5 E1 FE E1 C5 F1 72 D7 10 C5 7A 7F 9C 24 80 00 00 00 C5 F9 FE C4 C4 42 31 40 DB C5 E9 FE E0 C4 E2 29 40 ED C4 C1 21 DB D7 C5 D1 FE DE C4 C1 19 DB C7 C5 E9 FE D3 C4 C1 21 72 D3 10 C5 F1 FE F2 C5 E9 72 D4 10 C4 E2 11 40 8C 24 A0 00 00 00 C4 C1 19 72 D4 10 C4 C1 71 FE C8 C5 FA 6F 9C 24 B0 00 00 00 C5 F9 FE E9 C4 62 29 40 84 24 80 00 00 00 C5 E9 FE D5 C4 C1 61 DB EF C4 C1 39 FE CB C5 F9 72 D6 10 C5 51 FE D9 C4 C1 79 FE EB C5 B9 72 D2 10 C5 7A 6F 9C 24 C0 00 00 00 C5 E9 72 F2 10 C4 E2 11 40 84 24 90 00 00 00 C4 C1 21 DB CF C4 C1 79 FE C4 C5 99 72 D5 10 C5 F1 FE C8 C4 C1 51 DB EF C5 B9 FE C1 C5 C9 72 F6 10 C5 78 10 44 24 40 C4 C1 71 72 D0 10 C4 62 31 40 C9 C4 62 29 40 54 24 60 C4 C1 31 DB CF C5 B1 72 D3 10 C4 41 29 FE D1 C5 B1 72 D0 10 C4 C1 71 FE CA C4 C1 79 DB C7 C5 78 10 44 24 50 C5 19 FE E1 C4 C1 61 72 F4 10 C4 C1 19 72 D0 10 C4 62 11 40 6C 24 70 C5 E1 FE CD C4 42 09 40 F4 C4 C1 19 72 D3 10 C4 41 09 DB D7 C4 41 11 FE DC C4 41 41 DB F7 C4 41 59 DB FF C4 41 29 FE EB C4 41 69 FE D7 C5 F9 6E D5 C4 41 31 FE CD C4 C1 49 FE FE C4 C1 79 6E E0 C5 F9 70 F2 00 C4 C1 51 72 F1 10 C5 49 DB 64 24 20 C5 D1 FE C0 C5 F9 70 D4 00 C5 E1 72 D1 09 C5 49 DB 7C 24 30 C5 19 EF C2 C4 41 79 6E C9 C5 D9 72 D0 09 C5 01 EF DA C4 C1 61 EB F0 C4 C1 79 70 E9 00 C4 41 59 EB EB BD FF 01 00 00 41 B8 DB 0F C9 40 C4 C1 79 6E E2 41 B9 00 10 C9 40 41 BA 7A 77 95 B7 C5 F9 70 E4 00 C4 C3 4D 18 DD 01 C5 79 6E E8 C4 63 55 18 F5 01 B8 FF FF FF 7F C5 0C 58 DB C4 C1 79 70 ED 00 C4 41 24 5C C6 C5 79 6E F2 C4 41 79 70 F6 00 C5 09 DB EF C5 C1 72 D7 12 C4 41 64 5C C8 C5 19 EF C5 C5 81 EF DD C4 C1 09 DB EA C4 C1 11 72 F5 05 C5 89 72 F5 05 C4 41 11 EB E8 C5 89 EB EB C4 C1 29 72 D2 12 BA 00 00 80 35 C4 63 15 18 ED 01 C5 F9 6E E9 C5 79 70 F5 00 B9 7F 00 00 00 C4 C1 19 EF EE C4 41 01 EF E6 C5 79 6E FD C4 E3 3D 18 DB 01 C4 41 79 70 C7 00 C5 B9 DB C9 C5 B9 DB C0 C5 F1 72 F1 0E C5 F9 72 F0 0E C5 F1 EB CF C4 C1 79 EB C2 C5 F1 EB CD C4 41 79 EB D4 C5 14 5C EB C4 C1 79 6E FA C5 79 70 C7 00 C4 C3 75 18 CA 01 C4 41 79 6E D1 C4 43 55 18 E4 01 C4 C1 74 5C CC C4 41 79 70 FA 00 C5 B4 58 D9 C5 B4 5C C3 C5 74 58 E0 C4 C1 79 6E CB C5 F9 70 C1 00 C4 C1 1C 58 ED C4 41 79 6E E8 C4 41 79 70 CD 00 C4 E3 7D 18 C8 01 C5 64 54 E1 C4 C1 64 5C DC C4 43 35 18 F1 01 C4 43 05 18 FF 01 C4 43 3D 18 D0 01 C5 79 6E C2 C4 41 04 59 CC C5 84 59 C3 C4 41 2C 59 E4 C5 8C 59 ED C5 2C 59 F3 C4 41 79 70 D0 00 C4 C1 7C 58 C4 C4 41 54 58 E6 C5 F9 6E E8 C5 F9 70 FD 00 C4 C1 7C 58 DC C4 C1 7C 10 45 00 C5 34 58 EB C4 41 34 5C CD C5 34 58 E3 C4 63 45 18 F7 01 C4 41 7C 54 FE C4 C3 2D 18 DA 01 C5 84 C2 FB 1E C5 04 C2 FB 12 C4 41 44 54 C4 C5 79 6E E1 C4 C1 79 70 DC 00 C5 84 54 E8 C4 41 44 54 ED C4 C1 54 56 ED C4 41 54 58 E0 C4 63 7D 19 DE 01 C5 21 DB DC C5 A1 DB FB C5 C9 DB E4 C5 D9 DB DB C5 C9 72 F7 02 C5 C9 FE EF C5 C9 72 F3 02 C5 C9 FE E3 C5 B9 72 F5 03 C5 E1 72 F4 03 C5 79 7E C0 C4 C1 79 7E D8 C4 63 79 16 C2 01 C4 63 79 16 C1 02 C4 63 79 16 C5 03 C4 C3 79 16 D9 01 C4 C3 79 16 DA 02 C4 C3 79 16 DB 03 C5 79 6E 8C 18 40 04 00 00 C5 79 6E 94 1A 40 04 00 00 C5 79 6E 9C 19 40 04 00 00 C5 79 6E AC 1D 40 04 00 00 C4 C1 79 6E A4 18 40 04 00 00 C4 C1 79 6E AC 19 40 04 00 00 C4 C1 79 6E B4 1A 40 04 00 00 C4 C1 79 6E BC 1B 40 04 00 00 C4 41 31 6C F2 C4 41 21 6C FD C5 59 6C CD C5 49 6C D7 C4 41 08 C6 C7 88 C4 41 30 C6 DA 88 C5 F9 6E A4 18 44 04 00 00 C5 F9 6E AC 1A 44 04 00 00 8B 9C 24 D0 00 00 00 C4 C3 3D 18 DB 01 89 9C 24 D0 00 00 00 48 8D 1D ?? ?? ?? ?? C5 D9 6C FD C4 C1 7C 11 45 00 C5 79 6E AC 19 44 04 00 00 C5 F9 6E B4 1D 44 04 00 00 C5 91 6C EE C4 41 79 6E AC 18 44 04 00 00 C4 41 79 6E 8C 19 44 04 00 00 C4 41 79 6E 94 1A 44 04 00 00 C4 41 79 6E 84 1B 44 04 00 00 C4 41 11 6C D9 C4 C1 29 6C F0 C5 C0 C6 C5 88 C5 A0 C6 FE 88 C5 F9 6E AC 18 48 04 00 00 C5 79 6E B4 1A 48 04 00 00 C5 79 6E BC 19 48 04 00 00 C5 F9 6E A4 1D 48 04 00 00 C4 41 79 6E 84 18 48 04 00 00 C4 41 79 6E 9C 19 48 04 00 00 C4 C1 79 6E B4 1A 48 04 00 00 C4 41 51 6C EE C5 01 6C CC C4 C1 39 6C EB C4 41 10 C6 D1 88 C5 F9 6E A4 18 4C 04 00 00 C5 79 6E AC 1A 4C 04 00 00 C5 79 6E 8C 19 4C 04 00 00 C4 41 59 6C C5 C4 C1 79 6E A4 1B 4C 04 00 00 C4 E3 7D 18 C7 01 C4 C1 79 6E BC 1B 48 04 00 00 C5 49 6C F7 C4 41 50 C6 FE 88 C4 C1 79 6E BC 18 4C 04 00 00 C4 41 79 6E B4 19 4C 04 00 00 C4 41 41 6C EE C5 F9 6E BC 19 50 04 00 00 C5 79 6E B4 1D 50 04 00 00 C4 C3 2D 18 EF 01 C5 79 6E 94 1D 4C 04 00 00 C4 41 79 6E BC 1A 4C 04 00 00 C4 41 31 6C DA C5 01 6C CC C4 C1 38 C6 F3 88 C4 41 10 C6 D1 88 C5 79 6E 84 18 50 04 00 00 C5 79 6E 9C 1A 50 04 00 00 C4 41 39 6C FB C4 41 79 6E 8C 18 50 04 00 00 C4 41 79 6E 84 1A 50 04 00 00 C4 41 79 6E 9C 1B 50 04 00 00 C4 C1 41 6C E6 C4 41 39 6C F3 C5 00 C6 EC 88 C5 F9 6E A4 18 54 04 00 00 C5 79 6E 84 1D 54 04 00 00 C4 C3 4D 18 F2 01 C4 41 79 6E 94 19 50 04 00 00 C4 C1 31 6C FA C4 41 40 C6 FE 88 C5 79 6E 8C 1A 54 04 00 00 C5 79 6E 94 19 54 04 00 00 C4 41 59 6C D9 C4 C1 29 6C F8 C4 C1 79 6E A4 19 54 04 00 00 C4 41 79 6E 8C 1A 54 04 00 00 C4 41 79 6E 94 1B 54 04 00 00 C5 20 C6 F7 88 C4 41 31 6C DA C5 79 6E 8C 19 58 04 00 00 C5 79 6E 94 1D 58 04 00 00 C4 43 15 18 EF 01 C4 41 79 6E BC 18 54 04 00 00 C5 01 6C C4 C4 C1 38 C6 FB 88 C5 79 6E BC 18 58 04 00 00 C5 F9 6E A4 1A 58 04 00 00 C5 01 6C C4 C4 41 31 6C DA C4 41 79 6E BC 19 58 04 00 00 C4 C1 79 6E A4 1A 58 04 00 00 C4 41 79 6E 8C 1B 58 04 00 00 C4 41 38 C6 C3 88 C4 41 59 6C D9 C5 F9 6E A4 1A 5C 04 00 00 C5 79 6E 8C 19 5C 04 00 00 C4 E3 0D 18 FF 01 C4 41 79 6E B4 18 58 04 00 00 C4 41 09 6C D7 C4 41 28 C6 F3 88 C5 79 6E BC 18 5C 04 00 00 C5 79 6E 94 1D 5C 04 00 00 C5 01 6C DC C4 41 79 6E BC 18 5C 04 00 00 C4 C1 79 6E A4 19 5C 04 00 00 C4 C1 44 59 FC C4 43 3D 18 C6 01 C4 41 31 6C F2 C4 41 79 6E 8C 1A 5C 04 00 00 C4 41 79 6E 94 1B 5C 04 00 00 C4 41 20 C6 DE 88 C5 01 6C F4 C4 41 31 6C FA C4 C1 08 C6 E7 88 C5 79 6E 8C 18 60 04 00 00 C5 79 6E 94 1A 60 04 00 00 C5 79 6E B4 19 60 04 00 00 C5 79 6E BC 1D 60 04 00 00 C4 63 25 18 DC 01 C4 C1 31 6C E2 C4 41 09 6C CF C4 41 58 C6 C9 88 C4 41 79 6E 94 18 60 04 00 00 C4 41 79 6E B4 19 60 04 00 00 C4 41 79 6E BC 1A 60 04 00 00 C4 C1 79 6E A4 1B 60 04 00 00 C4 41 29 6C D6 C5 01 6C F4 C4 41 28 C6 FE 88 C5 F9 6E A4 18 64 04 00 00 C5 79 6E 94 1A 64 04 00 00 C5 79 6E B4 19 64 04 00 00 C4 C1 59 6C E2 C4 41 24 59 DC C4 41 24 58 D8 C4 43 35 18 CF 01 C5 79 6E BC 1D 64 04 00 00 C4 41 09 6C D7 C4 41 79 6E B4 18 64 04 00 00 C4 41 79 6E BC 19 64 04 00 00 C4 C1 58 C6 E2 88 C4 41 09 6C D7 C4 41 79 6E B4 1A 64 04 00 00 C4 41 79 6E BC 1B 64 04 00 00 C4 41 09 6C F7 C4 41 64 5C FC C4 41 28 C6 D6 88 C4 C1 64 5C DF C4 41 64 5C F4 8B 9C 24 D0 00 00 00 C4 43 5D 18 D2 01 C5 84 54 E1 C5 04 5C FC C4 41 2C 59 D4 C5 84 58 D8 C5 FC 53 C4 C5 8C 58 DB C4 41 2C 58 C1 C4 41 1C 59 CC C5 FC 54 C9 C5 5C 59 F1 C4 41 34 59 C0 C4 E3 6D 18 D2 01 C4 41 6C 5C FE C4 C1 74 59 C7 C4 C1 04 59 E7 C5 7C 58 F1 C5 DC 58 D2 C5 F4 59 CD C5 0C 59 F2 C4 C1 64 59 C6 C5 FC 59 D8 C4 C1 7C 5C E7 C5 64 5C FC C5 CC 58 DF C4 C1 04 59 D6 C5 CC 5C F3 C5 EC 59 C5 C5 E4 58 D1 C5 CC 58 EF C5 F4 5C CA C5 D4 58 C0 C5 F4 58 CB C5 FC 58 E1 C4 C1 3C 58 C3 C5 14 58 EC C4 41 7C 59 E4 C4 C1 1C 58 C5 C5 EC 58 C8 C4 C1 7C 10 45 00 E9 1C F3 FF FF 0F 1F 00 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "__common_stanh_cout_rare"
		size = 80
		refs = "0003 _imlsTanhHATab"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 8A 41 03 24 80 C0 E8 07 44 0F B6 C8 44 0F B7 51 02 41 81 E2 80 7F 00 00 41 81 FA 80 7F 00 00 43 8B 04 88 74 05 89 02 33 C0 C3 F7 01 FF FF 7F 00 74 F3 F3 0F 10 01 F3 0F 58 C0 F3 0F 11 02 EB E7 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "__avx_expf8"
		size = 528
		refs = "002d __common_sexp_data 0200 __common_sexp_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 84 24 D0 01 00 00 C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 6F 01 00 00 C5 FC 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 FC 59 0D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 F8 10 35 ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 74 58 C4 C5 BC 5C CC C5 F8 54 E2 C4 E3 7D 19 C5 01 C5 D9 66 E6 C5 D0 54 EA C5 D1 66 D6 C5 D9 6B E2 C5 D1 EF ED C5 D9 63 F5 C5 F4 59 2D ?? ?? ?? ?? C5 F4 59 0D ?? ?? ?? ?? C5 F9 D7 D6 C5 FC 5C F5 C5 B9 FE D3 C4 63 7D 19 C4 01 C5 B9 72 F2 17 C5 CC 5C D1 C5 D9 FE DB C5 E1 72 F3 17 C5 EC 59 0D ?? ?? ?? ?? C5 F4 58 25 ?? ?? ?? ?? C5 DC 59 EA C5 D4 58 35 ?? ?? ?? ?? C4 E3 3D 18 DB 01 C5 4C 59 C2 C5 BC 58 0D ?? ?? ?? ?? C5 F4 59 E2 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 D2 C5 EC 58 0D ?? ?? ?? ?? C5 E4 59 C9 84 D2 75 26 C5 FC 10 B4 24 F0 01 00 00 C5 7C 10 84 24 D0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 CA 33 C0 C5 FC 11 BC 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 28 01 00 00 8B D8 48 89 B4 24 20 01 00 00 8B F2 0F A3 DE 72 61 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 28 01 00 00 48 8B B4 24 20 01 00 00 E9 0F FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 8B 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "__sse2_atan2f4"
		size = 1328
		refs = "0014 s_dwAbsMask 003d s_dwMaxNormal 0045 s_dwMinBound 0053 s_dwSignMask 0062 s_fOne 00ae s_fPi2 00be s_fPi 00d1 s_fA8 00db s_fA7 00e5 s_fA6 00ec s_fA5 00f9 s_fA4 0100 s_fA3 010d s_fA2 0114 s_fA1 0121 s_fA0 0155 INFP 015f INFN 016a NEGZERO 02b1 _2il0floatpacket_16 02db pi_or_zero 02f2 _2il0floatpacket_11 02fe _2il0floatpacket_10 0307 _2il0floatpacket_14 0317 _2il0floatpacket_9 032b _2il0floatpacket_8 033e _2il0floatpacket_7 034a _2il0floatpacket_15 035c _2il0floatpacket_13 0371 _2il0floatpacket_12 03f5 _2il0floatpacket_17 0400 _2il0floatpacket_18 041f _2il0floatpacket_20 0427 _2il0floatpacket_19 043b _2il0floatpacket_21 0449 _2il0floatpacket_22 047e _2il0floatpacket_23 048c _2il0floatpacket_24"
	strings:
		$1 = { 48 81 EC C8 00 00 00 0F 29 7C 24 60 0F 29 74 24 70 0F 28 15 ?? ?? ?? ?? 0F 28 EA 0F 11 84 24 80 00 00 00 66 0F DB E9 66 0F DB D0 0F 11 8C 24 90 00 00 00 0F 28 FD 0F 28 F2 66 0F 66 35 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F DF F7 0F 50 C6 0F 28 35 ?? ?? ?? ?? 66 0F DB C6 0F 28 FE 66 0F EB 05 ?? ?? ?? ?? 0F 28 DD 66 0F DB F9 0F 11 44 24 50 66 0F EB 3D ?? ?? ?? ?? 0F C2 DA 01 0F 28 E3 66 0F DB E5 0F 28 C3 66 0F DF C2 66 0F EB E0 66 0F DB D3 0F 28 C3 66 0F DF C5 66 0F EB D0 0F 5E E2 66 0F DB F3 66 0F EF ED 66 0F DB 1D ?? ?? ?? ?? 0F C2 CD 01 66 0F EB E6 66 0F DB 0D ?? ?? ?? ?? 0F 28 C4 0F 59 C4 0F 28 D0 0F 59 D0 0F 28 35 ?? ?? ?? ?? 0F 59 F2 0F 28 2D ?? ?? ?? ?? 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 F2 0F 59 C5 0F 58 35 ?? ?? ?? ?? 0F 58 C6 0F 59 C4 0F 28 6C 24 50 0F 58 C3 0F 59 C7 89 84 24 B0 00 00 00 0F 58 C1 0F 59 C5 83 BC 24 B0 00 00 00 0F 0F 84 8D 02 00 00 F3 0F 10 1D ?? ?? ?? ?? 33 C9 F3 0F 10 15 ?? ?? ?? ?? 0F 57 C0 F3 0F 10 0D ?? ?? ?? ?? 33 D2 44 0F 29 44 24 40 B8 00 00 80 3F 44 0F 29 4C 24 30 44 0F 29 54 24 20 44 8B 8C 8C 90 00 00 00 45 8B C1 44 8B 94 8C 80 00 00 00 45 8B DA 41 81 E3 00 00 00 80 44 89 8C 24 C4 00 00 00 41 81 E1 FF FF FF 7F 41 81 E0 00 00 00 80 F3 44 0F 10 8C 8C 80 00 00 00 41 81 F9 00 00 80 7F F3 0F 10 A4 8C 90 00 00 00 89 94 24 B4 00 00 00 89 94 24 B8 00 00 00 89 84 24 BC 00 00 00 44 89 94 24 C0 00 00 00 7F 10 41 81 E2 FF FF FF 7F 41 81 FA 00 00 80 7F 7E 0A F3 44 0F 58 CC E9 A0 01 00 00 44 0F 2E C8 7A 06 0F 84 A0 02 00 00 0F 2E E0 7A 06 0F 84 71 02 00 00 0F 2E E3 7A 06 0F 84 23 02 00 00 0F 2E E2 7A 06 0F 84 CC 01 00 00 44 0F 2E CB 7A 06 0F 84 B5 01 00 00 44 0F 2E CA 7A 06 0F 84 9E 01 00 00 44 8B 8C 24 C0 00 00 00 41 81 CB 00 00 80 3F 44 8B 94 24 C4 00 00 00 41 81 E1 FF FF FF 7F 41 81 E2 FF FF FF 7F 44 89 8C 24 B4 00 00 00 44 89 94 24 B8 00 00 00 F3 44 0F 10 84 24 B4 00 00 00 F3 0F 10 A4 24 B8 00 00 00 44 89 9C 24 BC 00 00 00 44 0F 2F C4 76 1E 44 0F 28 D0 F2 44 0F 10 0D ?? ?? ?? ?? F3 44 0F 5C D4 F3 45 0F 5E D0 F3 45 0F 5A C2 EB 0E F3 44 0F 5E C4 F3 45 0F 5A C0 45 0F 57 C9 41 0F 28 F0 4C 8D 0D ?? ?? ?? ?? F2 41 0F 59 F0 4D 8B D1 0F 28 FE F2 0F 59 FE F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? 41 C1 F8 1F F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? 4D 63 C0 F2 0F 58 EC F2 0F 59 EF F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 EC F2 0F 10 25 ?? ?? ?? ?? F2 0F 59 E7 F2 41 0F 58 E2 F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 59 E7 F2 41 0F 58 E2 F2 0F 59 E7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 58 E7 F2 0F 59 F4 F2 0F 58 EE F2 44 0F 59 C5 F2 45 0F 58 C8 F3 44 0F 5A 84 24 BC 00 00 00 F2 47 0F 59 4C C1 18 F2 47 0F 58 4C C2 08 F2 45 0F 59 C8 F2 45 0F 5A C9 F3 44 0F 11 8C 8C A0 00 00 00 48 FF C1 48 83 F9 04 0F 8C C3 FD FF FF 44 0F 28 44 24 40 44 0F 28 4C 24 30 44 0F 28 54 24 20 0F 28 84 24 A0 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 C8 00 00 00 C3 F3 44 0F 10 0D ?? ?? ?? ?? EB B2 F3 44 0F 10 0D ?? ?? ?? ?? EB A7 44 0F 2E CB 7A 02 74 36 44 0F 2E CA 7A 02 74 20 44 0F 2F C8 F3 44 0F 10 0D ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? 77 80 44 0F 28 CC E9 77 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 69 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 5B FF FF FF 44 0F 2E CB 7A 02 74 2D 44 0F 2E CA 7A 02 74 17 41 0F 2F C1 44 0F 28 C9 0F 87 3D FF FF FF 44 0F 28 C8 E9 34 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 26 FF FF FF F3 44 0F 10 0D ?? ?? ?? ?? E9 18 FF FF FF 44 0F 2F C8 F3 44 0F 10 0D ?? ?? ?? ?? F3 0F 10 25 ?? ?? ?? ?? 0F 87 FD FE FF FF 44 0F 28 CC E9 F4 FE FF FF 45 85 DB 74 36 0F 2F E0 0F 87 E6 FE FF FF 0F 2F C4 76 0E F3 44 0F 10 0D ?? ?? ?? ?? E9 D3 FE FF FF 45 85 C0 F3 0F 10 25 ?? ?? ?? ?? 0F 84 C2 FE FF FF 44 0F 28 CC E9 B9 FE FF FF 0F 2F E0 0F 87 B0 FE FF FF 0F 2F C4 76 0E F3 44 0F 10 0D ?? ?? ?? ?? E9 9D FE FF FF 45 85 C0 F3 0F 10 25 ?? ?? ?? ?? 0F 84 8C FE FF FF 44 0F 28 CC E9 83 FE FF FF 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__GSHandlerCheck_SEH_noexcept"
		size = 45
		refs = "000a __GSHandlerCheck_SEH 0028 terminate"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? F6 43 04 66 75 0D 81 3B 63 73 6D E0 75 05 83 F8 01 74 06 48 83 C4 20 5B C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_30_0_3 {
	meta:
		name = "__C_specific_handler_noexcept"
		size = 45
		refs = "000a __C_specific_handler 0028 terminate"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? F6 43 04 66 75 0D 81 3B 63 73 6D E0 75 05 83 F8 01 74 06 48 83 C4 20 5B C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__common_dlog10_cout_rare"
		size = 736
		refs = "003e _vmldLgHATab 006b _2il0floatpacket_78 0287 _2il0floatpacket_79"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 41 81 F8 F0 7F 00 00 0F 84 79 02 00 00 F2 0F 10 11 45 33 C0 48 8B 09 48 89 4C 24 30 48 C1 E9 30 F7 C1 F0 7F 00 00 75 18 F2 0F 10 05 ?? ?? ?? ?? 41 B8 C4 FF FF FF F2 0F 59 D0 F2 0F 11 54 24 30 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D0 0F 86 F9 01 00 00 0F 28 DA F2 0F 5C 1D ?? ?? ?? ?? F2 0F 11 5C 24 28 80 64 24 2F 7F F2 0F 10 44 24 28 66 0F 2F 05 ?? ?? ?? ?? 0F 86 56 01 00 00 F2 0F 11 54 24 28 44 0F B7 4C 24 2E 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 2E F2 0F 10 64 24 28 0F 28 D4 0F 28 DC 0F B7 4C 24 36 81 E1 F0 7F 00 00 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? C1 E9 04 F2 0F 11 54 24 20 44 8B 54 24 20 41 83 E2 7F F2 0F 11 5C 24 20 45 8D 84 08 01 FC FF FF F2 0F 10 5C 24 20 48 8D 0D ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 4C 8B C9 F2 0F 10 2D ?? ?? ?? ?? 47 8D 1C 52 F2 0F 10 15 ?? ?? ?? ?? F2 41 0F 2A C0 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 5C E3 F2 0F 59 C5 4C 8B C1 F2 42 0F 10 2C D9 F2 0F 59 DD F2 43 0F 58 44 D9 10 F2 43 0F 58 4C D8 08 F2 0F 59 EC F2 0F 5C 1D ?? ?? ?? ?? 0F 28 E3 F2 0F 58 CB F2 0F 58 E5 F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D4 0F 28 E5 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 E2 F2 0F 59 DA F2 0F 58 C4 F2 0F 58 E8 F2 0F 58 EB F2 0F 58 CD F2 0F 11 0A 48 83 C4 38 C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CB F2 0F 58 D9 F2 0F 11 1A 48 83 C4 38 C3 66 0F 2E D0 7A 02 74 12 F2 0F 5E C0 F2 0F 11 02 B8 01 00 00 00 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 11 0A 48 83 C4 38 C3 44 8A 41 07 41 80 E0 80 41 80 F8 80 74 11 F2 0F 10 01 F2 0F 59 C0 F2 0F 11 02 48 83 C4 38 C3 F7 41 04 FF FF 0F 00 75 E6 83 39 00 75 E1 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 11 02 48 83 C4 38 C3 90 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__avx_acosf8"
		size = 576
		refs = "0036 __common_sacos_data 022b __common_sacos_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 B0 01 00 00 C5 7C 11 B4 24 F0 01 00 00 C5 FC 11 B4 24 D0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 4F 01 00 00 C5 FC 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 FC 10 0D ?? ?? ?? ?? C5 DC 56 E8 C5 D4 59 D9 C5 54 59 FD C5 54 C2 35 ?? ?? ?? ?? 12 C5 E4 58 D1 C5 84 5D CA C4 41 01 EF FF C5 DC 54 E0 C4 63 7D 19 F3 01 C5 89 6B F3 C4 41 49 63 F7 C5 FC 52 F2 C5 F4 C2 DA 15 C5 EC 58 D2 C4 C1 79 D7 D6 C5 4C 59 FE C5 6C 59 F6 C4 C1 6C 59 D7 C5 6C 5C 3D ?? ?? ?? ?? C5 84 59 35 ?? ?? ?? ?? C5 CC 58 15 ?? ?? ?? ?? C4 C1 0C 59 F7 C5 6C 59 FE C4 C1 0C 5C D7 C5 74 59 35 ?? ?? ?? ?? C4 E3 55 4A EA 30 C5 0C 58 3D ?? ?? ?? ?? C5 74 59 35 ?? ?? ?? ?? C5 8C 58 35 ?? ?? ?? ?? C5 74 59 F1 C4 41 04 59 FE C5 84 58 F6 C5 4C 59 F9 C5 04 58 35 ?? ?? ?? ?? C5 7C C2 F9 11 C5 0C 59 F1 C5 E4 54 0D ?? ?? ?? ?? C4 C1 74 54 F7 C5 E4 55 0D ?? ?? ?? ?? C5 74 58 FE C5 D4 57 CC C5 0C 59 F1 C5 8C 58 D1 C5 84 58 CA 84 D2 75 2F C5 FC 10 B4 24 D0 01 00 00 C5 7C 10 B4 24 F0 01 00 00 C5 7C 10 BC 24 B0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 C1 33 C0 C5 FC 11 BC 24 E0 00 00 00 C5 7C 11 84 24 C0 00 00 00 C5 7C 11 8C 24 A0 00 00 00 C5 7C 11 94 24 80 00 00 00 C5 7C 11 5C 24 60 C5 7C 11 64 24 40 C5 7C 11 6C 24 20 48 89 9C 24 08 01 00 00 8B D8 48 89 B4 24 00 01 00 00 8B F2 0F A3 DE 72 58 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 E0 00 00 00 C5 7C 10 84 24 C0 00 00 00 C5 7C 10 8C 24 A0 00 00 00 C5 7C 10 94 24 80 00 00 00 C5 7C 10 5C 24 60 C5 7C 10 64 24 40 C5 7C 10 6C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 08 01 00 00 48 8B B4 24 00 01 00 00 E9 18 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 94 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "__vdecl_fmodf4"
		size = 107
		refs = "0011 fmodf"
	strings:
		$1 = { 48 83 EC 48 F3 0F 7F 44 24 20 F3 0F 7F 4C 24 30 E8 ?? ?? ?? ?? 66 0F 7E 44 24 20 66 0F 6E 44 24 24 66 0F 6E 4C 24 34 E8 ?? ?? ?? ?? 66 0F 7E 44 24 24 66 0F 6E 44 24 28 66 0F 6E 4C 24 38 E8 ?? ?? ?? ?? 66 0F 7E 44 24 28 66 0F 6E 44 24 2C 66 0F 6E 4C 24 3C E8 ?? ?? ?? ?? 66 0F 7E 44 24 2C F3 0F 6F 44 24 20 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__common_dpow_cout_rare"
		size = 2896
		refs = "01a0 _vmldPowHATab"
	strings:
		$1 = { 53 56 57 41 54 41 55 41 56 41 57 55 48 81 EC C8 00 00 00 33 C0 4C 8B 31 4D 8B EE 48 8B 1A 4D 8B E6 F2 0F 10 12 48 8B D3 48 89 5C 24 68 4D 8B CE 48 C1 EB 38 49 C1 ED 30 48 C1 EA 30 49 C1 EC 38 41 81 E5 F0 7F 00 00 49 C1 E9 20 81 E2 F0 7F 00 00 41 81 E4 80 00 00 00 80 E3 80 41 C1 ED 04 C1 EA 04 41 C1 EC 07 C0 EB 07 44 0F 29 BC 24 80 00 00 00 44 0F 29 74 24 70 44 0F 29 A4 24 90 00 00 00 44 0F 29 8C 24 A0 00 00 00 0F 29 BC 24 B0 00 00 00 F2 0F 10 09 41 8B CE 41 F7 C1 FF FF 0F 00 75 0F 85 C9 75 0B 41 BA 01 00 00 00 45 8B DA EB 09 45 33 D2 41 BB 01 00 00 00 8B 4C 24 6C 8B 7C 24 68 81 E1 FF FF 0F 00 75 09 85 FF 75 05 45 8B CB EB 03 45 33 C9 8B F2 33 ED 81 FA FF 07 00 00 41 0F 45 EB C1 E6 14 0B F1 8B CF 0B CE 74 6A 81 FA FF 03 00 00 8D 8A 01 FC FF FF 7C 18 85 ED 74 14 83 F9 14 7F 2A 44 8B FE 41 D3 E7 41 C1 E7 0C 44 0B FF 74 04 33 F6 EB 45 8D 8A 0C FC FF FF D3 E6 F7 D6 81 E6 00 00 00 80 C1 EE 1F FF C6 EB 2E 83 F9 35 7D 24 8D 8A 0C FC FF FF D3 E7 F7 C7 FF FF FF 7F 74 04 33 F6 EB 15 F7 D7 81 E7 00 00 00 80 C1 EF 1F 8D 77 01 EB 05 BE 02 00 00 00 45 85 E4 75 0D 41 81 FD FF 03 00 00 0F 84 CB 09 00 00 85 D2 75 09 45 85 C9 0F 85 DC 03 00 00 33 FF 41 81 FD FF 07 00 00 41 0F 45 FB 44 0B D7 0F 84 BD 03 00 00 44 0B CD 0F 84 B4 03 00 00 F2 0F 10 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 66 0F 2E C8 7A 06 0F 84 41 09 00 00 66 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 0D 09 00 00 85 FF 0F 84 2E 03 00 00 85 ED 0F 84 26 03 00 00 66 0F 2F C8 77 08 85 F6 0F 84 EF 02 00 00 41 23 F4 48 8D 0D ?? ?? ?? ?? 4C 89 74 24 30 49 C1 EE 38 41 83 E6 7F F2 0F 10 84 F1 A8 1A 00 00 33 C9 44 88 74 24 37 45 85 ED 75 1B F2 0F 10 4C 24 30 B9 38 FF FF FF F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 EB 06 F2 0F 10 4C 24 30 0F B7 6C 24 36 4C 8D 0D ?? ?? ?? ?? 81 E5 F0 7F 00 00 4D 8B D1 C1 ED 04 4D 8B E9 8B 7C 24 34 4D 8B F9 C1 E5 14 81 E7 FF FF 0F 00 F2 0F 11 4C 24 40 0B EF 0F B7 74 24 46 81 C5 00 40 18 C0 81 E6 0F 80 FF FF 4D 8B E1 81 CE F0 3F FF FF 49 8B F9 66 89 74 24 46 49 8B F1 C1 FD 14 03 E9 8B 4C 24 44 81 E1 00 C0 0F 00 81 C1 00 40 00 00 C1 E9 0F F2 0F 10 54 24 40 0F 28 DA F2 0F 2A FD F2 41 0F 10 2C C9 03 C9 44 0F 28 E5 49 8B E9 F2 44 0F 59 E2 F2 44 0F 11 64 24 48 44 8B 5C 24 4C 41 81 E3 00 FC 00 00 41 81 C3 00 04 00 00 41 C1 EB 0B F2 43 0F 10 8C DA 18 03 00 00 45 03 DB F2 44 0F 59 E1 F2 41 0F 58 BC CF 08 01 00 00 F2 0F 59 E9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 D9 F2 44 0F 11 64 24 50 44 8B 74 24 54 41 81 E6 F0 0F 00 00 F2 0F 11 5C 24 58 41 83 C6 10 F2 0F 10 64 24 58 41 C1 EE 05 F2 0F 5C 64 24 40 F2 0F 11 64 24 60 F2 0F 10 5C 24 58 F2 47 0F 10 BC F5 30 06 00 00 45 03 F6 F2 45 0F 59 E7 F2 41 0F 59 EF F2 42 0F 58 BC DD 20 04 00 00 F2 44 0F 10 7C 24 60 45 0F 28 F4 F2 41 0F 5C DF F2 44 0F 5C 35 ?? ?? ?? ?? F2 43 0F 58 BC F7 38 0A 00 00 F2 0F 11 5C 24 58 F2 0F 10 64 24 58 F2 47 0F 10 8C DC 28 04 00 00 F2 0F 5C D4 F2 46 0F 58 8C F6 40 0A 00 00 F2 0F 11 54 24 60 0F 28 D5 F2 0F 59 D1 F2 44 0F 58 8C CF 10 01 00 00 F2 0F 10 5C 24 58 F2 0F 10 64 24 60 F2 0F 11 54 24 58 F2 44 0F 10 7C 24 58 F2 44 0F 5C FD F2 44 0F 11 7C 24 60 F2 44 0F 10 7C 24 58 F2 0F 10 54 24 60 F2 44 0F 5C FA F2 44 0F 11 7C 24 58 F2 0F 10 54 24 58 F2 0F 5C EA 0F 28 D3 F2 0F 11 6C 24 60 F2 0F 10 6C 24 58 F2 0F 59 D5 F2 0F 59 EC F2 41 0F 5C D4 44 0F 28 E7 F2 0F 58 D5 F2 45 0F 58 E6 F2 44 0F 10 7C 24 60 F2 41 0F 59 DF F2 41 0F 59 E7 F2 0F 58 D3 F2 44 0F 11 64 24 58 F2 0F 58 D4 F2 0F 10 5C 24 58 F2 0F 5C FB F2 41 0F 58 FE F2 0F 11 7C 24 60 F2 0F 10 64 24 58 F2 0F 11 64 24 38 0F B7 4C 24 3E 81 E1 F0 7F 00 00 C1 E9 04 03 D1 F2 0F 10 5C 24 60 81 FA 09 08 00 00 0F 8D 0C 06 00 00 81 FA C0 07 00 00 0F 8F 30 01 00 00 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 4C 24 58 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 F2 0F 10 54 24 58 F2 0F 59 C2 E9 BF 00 00 00 48 89 4C 24 58 41 8B C3 F2 0F 10 4C 24 58 F2 0F 10 44 24 58 F2 0F 5E C8 F2 0F 11 4C 24 58 F2 0F 10 44 24 58 E9 96 00 00 00 41 81 FD FF 03 00 00 7D 11 84 DB 0F 84 85 00 00 00 0F 28 C2 F2 0F 59 C2 EB 7C 84 DB 74 15 41 23 F4 48 8D 15 ?? ?? ?? ?? F2 0F 59 84 F2 A8 1A 00 00 EB 63 F2 0F 59 C9 41 23 F4 F2 0F 59 D1 48 8D 15 ?? ?? ?? ?? 0F 28 C2 F2 0F 59 84 F2 A8 1A 00 00 EB 43 0F 28 C1 F2 0F 58 C2 EB 3A 48 8B 15 ?? ?? ?? ?? F2 0F 58 CA F2 0F 11 4C 24 58 48 89 54 24 60 8A 4C 24 5F 8A 5C 24 67 80 E1 80 80 E3 7F 0A D9 88 5C 24 67 F2 0F 10 44 24 60 F2 0F 10 4C 24 60 F2 0F 59 C1 0F 28 BC 24 B0 00 00 00 44 0F 28 8C 24 A0 00 00 00 44 0F 28 A4 24 90 00 00 00 44 0F 28 74 24 70 44 0F 28 BC 24 80 00 00 00 F2 41 0F 11 00 48 81 C4 C8 00 00 00 5D 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 F2 44 0F 10 25 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 44 0F 10 7C 24 38 48 8B D9 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 59 E6 F2 44 0F 58 CA F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 41 0F 28 F9 F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 F2 41 0F 58 E4 F2 0F 11 64 24 58 F2 44 0F 10 74 24 58 F2 45 0F 5C FE F2 45 0F 58 FC F2 44 0F 11 7C 24 60 F2 0F 10 5C 24 58 F2 0F 10 64 24 60 F2 0F 58 FB F2 0F 11 7C 24 58 F2 0F 10 54 24 58 F2 0F 5C DA F2 41 0F 58 D9 44 0F 28 C9 F2 0F 11 5C 24 60 F2 44 0F 10 64 24 58 F2 45 0F 59 CC F2 0F 10 7C 24 60 F2 44 0F 11 4C 24 58 F2 0F 58 FC F2 0F 10 54 24 58 F2 0F 59 7C 24 68 F2 41 0F 5C D4 F2 0F 11 54 24 60 F2 0F 10 64 24 58 F2 0F 10 5C 24 60 F2 0F 5C E3 F2 0F 11 64 24 58 F2 0F 10 6C 24 58 F2 44 0F 5C E5 F2 44 0F 11 64 24 60 F2 44 0F 10 64 24 68 45 0F 28 F4 F2 44 0F 59 35 ?? ?? ?? ?? F2 0F 10 64 24 58 F2 0F 10 6C 24 60 F2 44 0F 11 74 24 58 F2 44 0F 10 7C 24 58 F2 44 0F 5C 7C 24 68 F2 44 0F 11 7C 24 60 F2 0F 10 54 24 58 F2 44 0F 10 4C 24 60 F2 41 0F 5C D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 44 0F 5C E3 F2 44 0F 11 64 24 60 F2 44 0F 10 74 24 58 F2 44 0F 10 4C 24 60 41 0F 28 D6 41 0F 28 D9 F2 0F 59 DD F2 44 0F 59 F5 F2 0F 59 D4 F2 41 0F 59 E1 F2 41 0F 58 DE F2 0F 58 DC F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 E2 F2 0F 58 FB F2 0F 11 64 24 58 F2 0F 10 6C 24 58 8B 54 24 58 8B F2 83 E2 7F F2 0F 5C 2D ?? ?? ?? ?? F2 0F 11 6C 24 20 03 D2 F2 44 0F 10 7C 24 20 F2 41 0F 5C D7 F2 0F 11 54 24 28 F2 0F 10 54 24 28 F2 0F 10 A4 D1 48 12 00 00 F2 0F 58 FA F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D7 C1 FE 07 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 59 D4 F2 0F 58 94 D3 50 12 00 00 0F 28 DA F2 0F 58 DC F2 0F 11 5C 24 30 0F B7 54 24 36 8B EA 81 E5 F0 7F 00 00 C1 ED 04 8D 8C 2E 01 FC FF FF 81 F9 00 04 00 00 0F 8D 23 02 00 00 81 F9 02 FC FF FF 7C 31 81 C1 FF 03 00 00 81 E2 0F 80 FF FF 81 E1 FF 07 00 00 C1 E1 04 0B D1 66 89 54 24 36 F2 0F 10 4C 24 30 F2 0F 59 C1 F2 0F 11 44 24 30 E9 0F FD FF FF 81 F9 F8 FB FF FF 0F 8C 22 01 00 00 F2 0F 11 5C 24 58 81 C6 C8 00 00 00 F2 0F 10 5C 24 58 81 C6 FF 03 00 00 48 8B 15 ?? ?? ?? ?? 81 E6 FF 07 00 00 48 89 54 24 38 F2 0F 5C E3 48 C1 EA 30 F2 0F 58 E2 F2 0F 11 64 24 60 81 E2 0F 80 FF FF F2 44 0F 10 4C 24 58 F2 41 0F 59 C9 F2 0F 10 54 24 60 F2 0F 11 4C 24 58 F2 0F 10 4C 24 58 C1 E6 04 F2 41 0F 5C C9 F2 0F 11 4C 24 60 0B D6 F2 0F 10 6C 24 58 F2 0F 10 64 24 60 66 89 54 24 3E F2 0F 5C EC F2 0F 11 6C 24 58 F2 0F 10 7C 24 58 F2 44 0F 10 7C 24 38 F2 44 0F 5C CF F2 44 0F 11 4C 24 60 F2 0F 10 4C 24 58 F2 44 0F 10 64 24 60 F2 44 0F 10 35 ?? ?? ?? ?? F2 41 0F 58 D4 F2 41 0F 59 C6 F2 41 0F 59 CF F2 41 0F 59 D7 F2 0F 59 C8 F2 0F 59 C2 F2 0F 11 44 24 58 48 8B 0D ?? ?? ?? ?? F2 0F 10 44 24 58 48 89 4C 24 58 F2 0F 58 C8 F2 0F 10 54 24 58 F2 0F 10 44 24 58 F2 0F 59 D0 F2 0F 11 54 24 58 F2 44 0F 10 64 24 58 F2 41 0F 58 CC 0F 28 C1 F2 0F 11 44 24 30 E9 E1 FB FF FF 81 F9 C4 FB FF FF 7C 7D 48 8B 15 ?? ?? ?? ?? 81 C6 C7 04 00 00 48 89 54 24 38 81 E6 FF 07 00 00 48 C1 EA 30 C1 E6 04 81 E2 0F 80 FF FF 0B D6 66 89 54 24 3E F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 54 24 38 F2 0F 59 C1 F2 0F 59 DA 48 8B 0D ?? ?? ?? ?? 48 89 4C 24 58 F2 0F 59 C3 F2 0F 10 5C 24 58 F2 0F 10 64 24 58 F2 0F 59 E3 F2 0F 11 64 24 58 F2 0F 10 6C 24 58 F2 0F 58 C5 F2 0F 11 44 24 30 E9 5C FB FF FF 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 4C 24 58 F2 0F 10 54 24 58 F2 0F 59 D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 0F 59 C3 F2 0F 11 44 24 30 E9 25 FB FF FF 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 54 24 58 F2 0F 10 4C 24 58 F2 0F 59 D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 0F 59 C3 F2 0F 11 44 24 30 E9 EE FA FF FF 8A 54 24 3F 48 8D 0D ?? ?? ?? ?? 80 E2 80 C0 EA 07 32 DA 0F B6 DB F2 0F 10 8C D9 90 1A 00 00 F2 0F 59 C9 F2 0F 59 C8 0F 28 C1 E9 BF FA FF FF 85 F6 75 08 85 ED 0F 85 E7 F6 FF FF 83 E6 01 48 8D 15 ?? ?? ?? ?? F2 0F 10 84 F2 A8 1A 00 00 E9 9B FA FF FF F2 0F 59 C9 84 DB 74 1F 41 23 F4 48 8D 05 ?? ?? ?? ?? F2 0F 10 84 F0 A8 1A 00 00 41 8B C3 F2 0F 5E C1 E9 74 FA FF FF 41 23 F4 48 8D 15 ?? ?? ?? ?? F2 0F 10 84 F2 A8 1A 00 00 F2 0F 59 C1 E9 58 FA FF FF 45 85 D2 0F 84 2C F6 FF FF E9 10 FA FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__common_dasin_cout_rare"
		size = 2752
		refs = "0070 _vmldASinHATab"
	strings:
		$1 = { 56 48 81 EC D0 00 00 00 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 F2 0F 10 01 41 81 F8 F0 7F 00 00 48 8B 31 44 0F 29 BC 24 A0 00 00 00 44 0F 29 B4 24 B0 00 00 00 44 0F 29 5C 24 60 44 0F 29 54 24 70 44 0F 29 8C 24 80 00 00 00 44 0F 29 84 24 90 00 00 00 0F 29 BC 24 C0 00 00 00 0F 84 3E 0A 00 00 48 89 74 24 38 48 C1 EE 38 F2 44 0F 10 1D ?? ?? ?? ?? 83 E6 7F 40 88 74 24 3F F2 44 0F 10 4C 24 38 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F D9 0F 82 B9 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C1 0F 86 1A 04 00 00 66 44 0F 2F 0D ?? ?? ?? ?? 0F 86 7C 03 00 00 F2 44 0F 10 35 ?? ?? ?? ?? 41 0F 28 E1 F2 41 0F 59 E6 45 0F 28 C1 F2 0F 11 64 24 28 45 0F 28 D1 F2 44 0F 10 5C 24 28 41 0F 28 DE F2 44 0F 5C 5C 24 38 F2 44 0F 11 5C 24 20 F2 0F 10 7C 24 28 F2 0F 10 4C 24 20 F2 0F 5C F9 F2 0F 11 7C 24 28 F2 0F 10 54 24 28 F2 44 0F 5C C2 F2 44 0F 11 44 24 20 F2 0F 10 6C 24 28 0F 28 D5 F2 44 0F 58 D5 F2 0F 59 D5 F2 44 0F 10 7C 24 20 0F 28 C2 F2 45 0F 59 D7 F2 0F 59 DA F2 41 0F 58 C2 F2 44 0F 10 05 ?? ?? ?? ?? F2 44 0F 59 C0 F2 0F 11 5C 24 28 F2 0F 10 64 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 5C E2 F2 44 0F 59 C0 F2 0F 11 64 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 5C 24 20 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 5C CB F2 44 0F 59 C0 F2 0F 11 4C 24 28 F2 0F 10 7C 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 5C D7 F2 44 0F 59 C0 F2 0F 11 54 24 20 41 0F 28 F9 F2 0F 10 64 24 28 F2 0F 10 5C 24 20 F2 44 0F 59 FC F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 58 D3 F2 0F 59 EC F2 44 0F 59 C0 F2 41 0F 59 FA F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 58 FF F2 44 0F 59 C0 45 0F 28 FE F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 59 C0 F2 44 0F 11 7C 24 28 F2 44 0F 10 5C 24 28 F2 44 0F 5C DD F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 11 5C 24 20 44 0F 28 DD F2 0F 10 54 24 28 F2 0F 58 EF F2 44 0F 59 C0 F2 44 0F 59 D5 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 F2 44 0F 59 C0 F2 0F 5C D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 28 F2 44 0F 5C DB 0F 28 DC F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 11 5C 24 20 F2 0F 10 4C 24 28 F2 0F 10 54 24 20 44 0F 28 FA F2 0F 59 D9 F2 44 0F 58 FF F2 44 0F 59 C0 F2 41 0F 59 E7 F2 44 0F 59 F3 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 58 E2 F2 44 0F 59 C0 F2 44 0F 11 74 24 28 44 0F 28 DB F2 44 0F 10 54 24 28 F2 44 0F 5C D3 F2 0F 58 DC F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 44 0F 11 54 24 20 F2 44 0F 10 54 24 28 F2 44 0F 10 74 24 20 F2 44 0F 59 C0 F2 45 0F 5C D6 F2 44 0F 11 54 24 28 F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 59 D5 F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 44 0F 58 D0 F2 0F 59 CD F2 0F 59 FD F2 0F 59 D5 F2 45 0F 58 D0 F2 44 0F 10 74 24 28 41 0F 28 C1 F2 45 0F 5C DE F2 0F 58 C1 F2 44 0F 58 D7 F2 44 0F 11 5C 24 20 F2 44 0F 58 D2 F2 44 0F 10 74 24 28 F2 44 0F 10 5C 24 20 F2 0F 11 44 24 28 F2 0F 10 54 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 5C CA F2 0F 59 E0 F2 44 0F 59 F0 F2 41 0F 59 C3 F2 44 0F 58 C9 F2 44 0F 11 4C 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 4C 24 20 F2 45 0F 58 D1 F2 44 0F 58 D4 0F 28 E1 F2 41 0F 58 E6 F2 44 0F 58 D0 F2 0F 11 64 24 28 F2 44 0F 10 4C 24 28 F2 41 0F 5C C9 F2 41 0F 58 CE F2 0F 11 4C 24 20 F2 0F 10 5C 24 28 F2 0F 10 54 24 20 8A 49 07 F2 44 0F 58 D2 80 E1 80 F2 44 0F 58 D3 F2 44 0F 11 54 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 2C 06 00 00 66 44 0F 2F 0D ?? ?? ?? ?? 72 42 F2 45 0F 58 CB F2 44 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 0F 59 44 24 38 F2 0F 11 44 24 30 40 8A 74 24 37 8A 49 07 40 80 E6 7F 80 E1 80 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 DF 05 00 00 F2 45 0F 59 C9 F2 44 0F 11 4C 24 28 F2 0F 10 44 24 28 8A 49 07 80 E1 80 F2 0F 58 44 24 38 F2 0F 11 44 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 9D 05 00 00 4D 8B D1 F2 45 0F 5C D9 F2 41 0F 59 C3 F2 0F 11 44 24 38 44 0F B7 44 24 3E 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B F0 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4C 24 40 45 0B D3 66 44 89 54 24 46 83 E6 01 F2 0F 10 7C 24 40 44 8B DE F2 0F 59 C7 0F 28 E8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 E8 F2 44 0F 10 0D ?? ?? ?? ?? 75 03 0F 28 E8 F2 44 0F 59 CD F2 0F 58 C2 F2 0F 11 44 24 48 45 0F 28 C1 44 8B 54 24 48 44 2B C6 41 C1 E3 08 41 81 E2 FF 01 00 00 45 03 D3 F2 44 0F 5C C5 4C 8D 1D ?? ?? ?? ?? F2 44 0F 11 44 24 20 44 0F 28 C5 F2 0F 10 5C 24 20 F2 0F 10 3D ?? ?? ?? ?? F2 44 0F 5C CB F2 43 0F 10 04 D3 41 0F 28 C9 0F 28 E0 F2 45 0F 5C C1 F2 0F 59 E0 F2 44 0F 59 C8 F2 0F 59 CC F2 41 0F 59 E0 F2 0F 5C 0D ?? ?? ?? ?? 41 D1 E8 F2 0F 58 CC F2 0F 59 F9 41 81 C0 FF 03 00 00 4C 89 4C 24 50 41 81 E0 FF 07 00 00 49 C1 E9 30 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 41 81 E1 0F 80 FF FF 41 C1 E0 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 45 0B C8 66 44 89 4C 24 56 F2 0F 10 5C 24 50 F2 44 0F 59 CB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 44 0F 10 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 35 ?? ?? ?? ?? F2 0F 59 F9 F2 45 0F 59 F3 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 F8 F2 41 0F 59 C0 F2 0F 59 FD 44 0F 28 C1 F2 0F 58 F8 F2 45 0F 59 C1 F2 0F 59 FB F2 44 0F 11 44 24 28 F2 44 0F 10 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 10 54 24 28 F2 0F 10 1D ?? ?? ?? ?? F2 41 0F 5C D1 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 11 54 24 20 0F 28 D3 F2 0F 10 6C 24 28 F2 0F 10 64 24 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C EC F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 C3 F2 41 0F 58 D6 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 59 D3 F2 45 0F 59 C3 F2 0F 11 6C 24 28 0F 28 E9 F2 44 0F 10 54 24 28 0F 28 E0 F2 41 0F 59 EB F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 5C CA F2 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 58 E2 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 11 4C 24 20 F2 44 0F 10 4C 24 28 F2 44 0F 10 7C 24 20 F2 0F 11 6C 24 28 F2 41 0F 58 FF F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 10 54 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 5C D3 F2 45 0F 59 C3 F2 44 0F 11 54 24 20 44 0F 28 D1 F2 0F 10 54 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 5C D7 F2 45 0F 59 C3 F2 0F 11 54 24 28 F2 44 0F 10 74 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 45 0F 59 C3 F2 45 0F 59 C3 F2 41 0F 58 E0 F2 0F 59 FC 41 0F 28 E3 F2 41 0F 5C E6 F2 0F 11 64 24 20 F2 44 0F 10 74 24 28 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E3 F2 44 0F 59 F3 F2 44 0F 59 D5 F2 0F 10 54 24 20 F2 44 0F 11 54 24 28 F2 44 0F 10 7C 24 28 F2 0F 59 E2 F2 44 0F 5C FD F2 0F 59 DA F2 44 0F 11 7C 24 20 F2 44 0F 10 7C 24 28 F2 44 0F 10 54 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C FA F2 41 0F 59 D3 F2 44 0F 11 7C 24 28 45 0F 28 FE F2 44 0F 10 54 24 28 F2 41 0F 5C EA F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6C 24 20 F2 44 0F 10 54 24 28 F2 44 0F 59 15 ?? ?? ?? ?? F2 41 0F 59 D3 F2 45 0F 58 FA F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6C 24 20 F2 41 0F 58 D0 F2 0F 58 EC F2 41 0F 59 D1 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 28 F2 44 0F 11 54 24 48 F2 45 0F 5C F7 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 44 0F 28 F0 F2 44 0F 10 7C 24 28 F2 44 0F 10 54 24 20 F2 45 0F 58 F7 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 28 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 44 24 20 F2 44 0F 10 74 24 28 F2 41 0F 59 CE F2 44 0F 10 7C 24 20 F2 0F 11 4C 24 28 F2 0F 10 4C 24 28 F2 41 0F 5C CE F2 0F 11 4C 24 20 F2 0F 10 4C 24 28 F2 0F 10 44 24 20 F2 0F 5C C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 44 0F 5C F0 F2 44 0F 11 74 24 20 F2 0F 10 44 24 28 F2 44 0F 10 74 24 20 F2 45 0F 58 F2 F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F1 F2 44 0F 59 C8 F2 41 0F 58 FE F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 FA 44 0F 28 D8 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C D9 F2 0F 5C D7 F2 44 0F 11 5C 24 28 F2 44 0F 10 5C 24 28 F2 41 0F 5C C3 F2 41 0F 5C C1 F2 0F 11 44 24 20 F2 0F 10 5C 24 28 F2 0F 10 4C 24 20 8A 49 07 F2 0F 58 D1 80 E1 80 F2 0F 58 DA F2 0F 11 5C 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 48 8B 4C 24 30 48 89 0A EB 11 B8 01 00 00 00 F2 0F 5C C0 F2 0F 5E C0 F2 0F 11 02 0F 28 BC 24 C0 00 00 00 44 0F 28 84 24 90 00 00 00 44 0F 28 8C 24 80 00 00 00 44 0F 28 54 24 70 44 0F 28 5C 24 60 44 0F 28 B4 24 B0 00 00 00 44 0F 28 BC 24 A0 00 00 00 48 81 C4 D0 00 00 00 5E C3 F2 0F 5E C0 F2 0F 11 02 F7 41 04 FF FF 0F 00 75 AE BA 01 00 00 00 33 C0 83 39 00 0F 44 C2 EB 9F }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "__avx_asinf8"
		size = 544
		refs = "0036 __common_sasin_data 0214 __common_sasin_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 BC 24 F0 01 00 00 C5 7C 11 84 24 D0 01 00 00 C5 FC 11 B4 24 B0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 4F 01 00 00 C5 FC 10 15 ?? ?? ?? ?? 49 83 E5 C0 C5 FC 10 25 ?? ?? ?? ?? C5 EC 54 C8 C5 F4 59 DC C5 F4 59 E9 C5 74 C2 3D ?? ?? ?? ?? 1D C5 5C 5C C3 C5 F4 C2 E4 15 C4 C1 54 5D D8 C5 EC 55 D0 C4 63 7D 19 FD 01 C5 81 6B F5 C5 D1 EF ED C5 49 63 FD C4 C1 7C 52 F0 C4 41 3C 58 C0 C4 C1 79 D7 D7 C5 CC 59 EE C5 BC 59 F6 C5 3C 59 C5 C5 3C 5C 05 ?? ?? ?? ?? C5 3C 59 3D ?? ?? ?? ?? C5 84 58 2D ?? ?? ?? ?? C4 41 4C 59 F8 C4 41 54 59 C7 C5 E4 59 2D ?? ?? ?? ?? C5 3C 5C C6 C5 D4 58 2D ?? ?? ?? ?? C5 E4 59 35 ?? ?? ?? ?? C5 4C 58 3D ?? ?? ?? ?? C5 E4 59 F3 C5 04 59 FE C5 84 58 ED C5 D4 59 F3 C4 C3 75 4A E8 40 C5 4C 58 3D ?? ?? ?? ?? C5 84 59 DB C5 E4 59 CD C5 F4 58 CD C5 DC 54 1D ?? ?? ?? ?? C5 F4 58 E3 C5 DC 57 CA 84 D2 75 2F C5 FC 10 B4 24 B0 01 00 00 C5 7C 10 84 24 D0 01 00 00 C5 7C 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 C1 33 C0 C5 FC 11 BC 24 E0 00 00 00 C5 7C 11 8C 24 C0 00 00 00 C5 7C 11 94 24 A0 00 00 00 C5 7C 11 9C 24 80 00 00 00 C5 7C 11 64 24 60 C5 7C 11 6C 24 40 C5 7C 11 74 24 20 48 89 9C 24 08 01 00 00 8B D8 48 89 B4 24 00 01 00 00 8B F2 0F A3 DE 72 58 FF C3 83 FB 20 7C F4 C5 FC 10 BC 24 E0 00 00 00 C5 7C 10 8C 24 C0 00 00 00 C5 7C 10 94 24 A0 00 00 00 C5 7C 10 9C 24 80 00 00 00 C5 7C 10 64 24 60 C5 7C 10 6C 24 40 C5 7C 10 74 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 08 01 00 00 48 8B B4 24 00 01 00 00 E9 18 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 94 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "__sse4_exp2"
		size = 720
		refs = "0012 s_dwInvLn 001a s_dwNegRS 002b s_dwLnHi 0033 s_dwBias 0062 s_dwLnLo 0076 s_dwExp2 0094 s_dwA4 00b3 s_dwA5 00d6 s_dwA3 00de s_dwA2 00f6 s_dwOne 01a2 iAbsMask 01ae dbB1 01c7 dbB2 024a dbInf"
	strings:
		$1 = { 48 83 EC 48 0F 29 7C 24 20 0F 29 74 24 30 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D8 66 0F C5 C8 03 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 58 D3 66 0F 3A 09 DB 00 66 0F 28 E8 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 4C 8D 05 ?? ?? ?? ?? 0F 8D A0 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 81 F9 86 40 00 00 0F 8D 91 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 E8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 D0 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 C3 66 0F 59 D5 66 0F 58 C5 66 0F 58 15 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C2 66 0F 59 C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 66 66 66 0F 1F 84 00 00 00 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 0F 1F 00 4C 8D 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 41 0F 7E BC C0 00 02 00 00 66 41 0F 16 BC D0 00 02 00 00 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 41 0F 7E BC C0 10 02 00 00 66 41 0F 16 BC D0 10 02 00 00 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 41 0F 7E 8C C0 20 02 00 00 66 41 0F 16 8C D0 20 02 00 00 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 41 0F 7E BC C0 30 02 00 00 66 41 0F 16 BC D0 30 02 00 00 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "__sse2_expf4"
		size = 640
		refs = "0003 s_dwExp2_Table 000a s_dwInvLn 0011 s_dwNegRS 001b s_dwLnHi 0022 s_dwBias 0030 flAbsMask 003c flBound1 0060 s_dwLnLo 00ab flTwo 0172 flBound2 01ff flInf 0263 flOne"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 59 D0 0F 28 25 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 66 0F DB E8 66 0F 66 2D ?? ?? ?? ?? 0F 50 CD 23 C9 0F 85 85 00 00 00 0F 28 E8 0F 58 DA 66 0F 7E D0 0F 59 E3 66 0F C5 D2 02 0F 59 1D ?? ?? ?? ?? 83 E0 3F 83 E2 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C0 66 0F C5 C2 04 41 0F 16 24 D0 66 0F C5 D2 06 0F 5C C3 83 E0 3F 83 E2 3F 66 0F 72 D1 06 F3 41 0F 7E 14 C0 41 0F 16 14 D0 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 0F C6 E2 88 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C1 C3 66 66 66 66 66 0F 1F 84 00 00 00 00 00 0F 28 E8 0F 58 DA 66 0F 7E D1 0F 59 E3 66 44 0F C5 CA 02 0F 59 1D ?? ?? ?? ?? 83 E1 3F 41 83 E1 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C8 66 44 0F C5 D2 04 43 0F 16 24 C8 66 44 0F C5 DA 06 0F 5C C3 41 83 E2 3F 41 83 E3 3F 66 0F 72 D1 06 F3 43 0F 7E 1C D0 43 0F 16 1C D8 0F C6 E3 88 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C8 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF DA 66 0F DB C3 0F 50 D5 B8 03 00 00 00 23 C2 83 E2 0C 03 C0 0F 28 15 ?? ?? ?? ?? 0F 59 D5 0F 5C 15 ?? ?? ?? ?? 66 0F DB D3 66 0F DB E3 66 0F FE 15 ?? ?? ?? ?? 66 0F 72 D2 06 41 0F 28 9C C0 40 02 00 00 41 0F C6 9C 90 40 02 00 00 88 66 0F FE D3 66 0F 72 F2 17 66 0F EB D4 0F 59 C2 41 0F 28 9C C0 00 02 00 00 41 0F C6 9C 90 00 02 00 00 88 0F 59 C3 66 0F EB C1 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF D3 41 0F 28 8C C0 80 02 00 00 41 0F C6 8C 90 80 02 00 00 88 66 0F DB CA 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 00 41 0F 28 9C C0 C0 02 00 00 41 0F C6 9C 90 C0 02 00 00 88 66 0F DB D3 66 0F EB CA 0F 28 15 ?? ?? ?? ?? 0F C2 D5 03 66 0F DB EA 66 0F EB CD 0F 59 C9 66 0F EB C1 C3 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "?GetPdbDll@@YAPEAUHINSTANCE__@@XZ"
		size = 24
		refs = "0002 ?alreadyTried@?1??GetPdbDll@@YAPEAUHINSTANCE__@@XZ@4_NA 0014 ?GetPdbDllFromInstallPath@@YAPEAUHINSTANCE__@@XZ"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 03 33 C0 C3 C6 05 ?? ?? ?? ?? 01 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_237_1_0 {
	meta:
		name = "?GetPdbDllFromInstallPath@@YAPEAUHINSTANCE__@@XZ"
		size = 645
		refs = "0025 __security_cookie 003b ??_C@_1EI@MLPKHBGE@?$AAa?$AAp?$AAi?$AA?9?$AAm?$AAs?$AA?9?$AAw?$AAi?$AAn?$AA?9?$AAc?$AAo?$AAr?$AAe?$AA?9?$AAr?$AAe?$AAg?$AAi?$AAs?$AAt?$AAr?$AAy?$AA?9?$AAl?$AA1?$AA?9?$AA1?$AA?9?$AA0?$AA?4@ 0045 __vcrt_LoadLibraryExW 005a ??_C@_1BK@JHLNAEJL@?$AAa?$AAd?$AAv?$AAa?$AAp?$AAi?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 006f __imp_GetLastError 009b ??_C@_0O@COHOBMLB@RegOpenKeyExW?$AA@ 00a4 __imp_GetProcAddress 00b3 ??_C@_0BB@GLNAEDBD@RegQueryValueExW?$AA@ 00cb ??_C@_0M@HLOHPNFA@RegCloseKey?$AA@ 00e4 _guard_check_icall 00fe ??_C@_1HE@EBEAGLFB@?$AAS?$AAO?$AAF?$AAT?$AAW?$AAA?$AAR?$AAE?$AA?2?$AAW?$AAo?$AAw?$AA6?$AA4?$AA3?$AA2?$AAN?$AAo?$AAd?$AAe?$AA?2?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?2?$AAV@ 0114 __imp_FreeLibrary 014c ??_C@_1BG@EABPBLLF@?$AAP?$AAr?$AAo?$AAd?$AAu?$AAc?$AAt?$AAD?$AAi?$AAr?$AA?$AA@ 01e5 ?mspdbName@@3QB_WB 0264 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 55 41 56 41 57 48 8D A8 88 FE FF FF 48 81 EC 60 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 50 01 00 00 BB 00 08 00 00 48 8D 0D ?? ?? ?? ?? 44 8B C3 33 D2 E8 ?? ?? ?? ?? 45 33 FF 48 8B F8 48 85 C0 75 44 44 8B C3 48 8D 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 2B FF 15 ?? ?? ?? ?? 83 F8 57 75 19 45 33 C0 48 8D 0D ?? ?? ?? ?? 33 D2 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 07 33 C0 E9 C1 01 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 E1 48 8D 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 C9 48 8D 15 ?? ?? ?? ?? 48 8B CF FF 15 ?? ?? ?? ?? 4C 8B F0 48 85 C0 74 B1 48 8B CB E8 ?? ?? ?? ?? 48 8D 44 24 38 41 B9 01 00 00 00 45 33 C0 48 89 44 24 20 48 8D 15 ?? ?? ?? ?? 48 C7 C1 02 00 00 80 FF D3 85 C0 74 0E 48 8B CF FF 15 ?? ?? ?? ?? E9 74 FF FF FF 48 8B CE C7 44 24 30 08 02 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 38 48 8D 44 24 30 48 89 44 24 28 4C 8D 4C 24 34 48 8D 44 24 40 45 33 C0 48 8D 15 ?? ?? ?? ?? 48 89 44 24 20 FF D6 49 8B CE 8B D8 E8 ?? ?? ?? ?? 48 8B 4C 24 38 41 FF D6 48 8B CF FF 15 ?? ?? ?? ?? 85 DB 0F 85 17 FF FF FF 83 7C 24 34 01 0F 85 0C FF FF FF 8B 54 24 30 F6 C2 01 0F 85 FF FE FF FF D1 EA 44 8B CA 83 FA 02 0F 82 F1 FE FF FF FF CA 66 44 39 7C 54 40 0F 85 E3 FE FF FF 8D 4A FF 8D 43 5C 66 39 44 4C 40 74 08 66 89 44 54 40 41 8B D1 8B C2 F7 D0 83 F8 18 0F 82 C1 FE FF FF 8B CA 48 8D 41 17 48 3D 04 01 00 00 0F 87 AF FE FF FF 0F 10 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 33 D2 0F 10 0D ?? ?? ?? ?? 41 B8 00 09 00 00 0F 11 44 4C 40 F2 0F 10 05 ?? ?? ?? ?? 0F 11 4C 4C 50 F2 0F 11 44 4C 60 89 44 4C 68 0F B7 05 ?? ?? ?? ?? 66 89 44 4C 6C 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 75 1E FF 15 ?? ?? ?? ?? 83 F8 57 75 13 33 D2 44 8D 43 08 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8B D8 48 8B C3 48 8B 8D 50 01 00 00 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 60 02 00 00 49 8B 5B 20 49 8B 73 28 49 8B 7B 30 49 8B E3 41 5F 41 5E 5D C3 }
	condition:
		$1
}

rule file_237_2_0 {
	meta:
		name = "?_RTC_GetSrcLine@@YAHPEAEPEA_WKPEAH1K@Z"
		size = 1068
		refs = "0043 __imp_VirtualQuery 0060 __vcrt_GetModuleFileNameW 00d8 ?PDBOK@?1??_RTC_GetSrcLine@@YAHPEAEPEA_WKPEAH1K@Z@4_NA 00e1 ?mspdb@@3PEAUHINSTANCE__@@EA 00ee ?alreadyTried@?1??GetPdbDll@@YAPEAUHINSTANCE__@@XZ@4_NA 0108 ?GetPdbDllFromInstallPath@@YAPEAUHINSTANCE__@@XZ 012f ??_C@_0BB@KCIACLNC@PDBOpenValidate5?$AA@ 0138 __imp_GetProcAddress 014c _guard_check_icall 01c0 ??_C@_01KDCPPGHE@r?$AA@ 02d4 __imp_GetProcessHeap 02e2 __imp_HeapAlloc 03b0 __imp_HeapFree"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F1 48 81 EC B8 00 00 00 33 F6 48 8B D9 41 89 31 4D 8B E9 66 89 32 48 8D 55 CF 8D 7E 01 48 2B DF 44 8D 46 30 48 8B CB FF 15 ?? ?? ?? ?? 48 85 C0 75 07 33 C0 E9 C5 03 00 00 44 8B 45 7F 48 8B 55 77 48 8B 4D D7 E8 ?? ?? ?? ?? 85 C0 74 E4 48 8B 55 D7 B8 4D 5A 00 00 66 39 02 75 D6 39 72 3C 7E D1 48 63 4A 3C 48 03 CA 81 39 50 45 00 00 75 C2 44 0F B7 49 14 2B DA 44 0F B7 41 06 4C 03 C9 44 8B FE 44 8B F6 45 85 C0 74 25 41 8B C6 48 8D 0C 80 41 3B 5C C9 24 72 0F 44 8B FB 45 2B 7C C9 24 41 3B 5C C9 20 72 08 44 03 F7 45 3B F0 72 DB 45 3B F0 0F 84 7A FF FF FF 44 03 F7 40 38 35 ?? ?? ?? ?? 75 47 48 39 35 ?? ?? ?? ?? 0F 85 61 FF FF FF 40 38 35 ?? ?? ?? ?? 74 0C 48 89 35 ?? ?? ?? ?? E9 4C FF FF FF 40 88 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 85 C0 0F 84 30 FF FF FF 40 88 3D ?? ?? ?? ?? EB 07 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 0F 84 04 FF FF FF 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4D 77 48 8D 45 B7 48 89 44 24 38 45 33 C9 48 89 74 24 30 48 8D 45 C7 48 89 74 24 28 45 33 C0 33 D2 48 89 44 24 20 FF D3 85 C0 0F 84 CA FE FF FF 48 8B 7D B7 48 8B 07 48 8B 18 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 3D 41 91 32 01 0F 85 5A 02 00 00 48 8B 7D B7 48 8B 07 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 4C 8D 4D BF 33 D2 4C 8D 05 ?? ?? ?? ?? 48 8B CF FF D3 85 C0 0F 84 2D 02 00 00 48 8B 7D BF 48 8B 07 48 8B 58 40 48 8B CB E8 ?? ?? ?? ?? 48 89 74 24 30 4C 8D 4D AF 48 89 74 24 28 45 8B C7 41 0F B7 D6 48 89 74 24 20 48 8B CF FF D3 85 C0 0F 84 DB 01 00 00 48 8B 7D AF 48 89 75 97 48 8B 07 48 8B 98 D0 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8D 55 97 48 8B CF FF D3 84 C0 0F 84 95 01 00 00 48 8B 7D 97 48 85 FF 0F 84 88 01 00 00 4C 8B E6 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 85 C0 0F 84 3E 01 00 00 48 8B 7D 97 48 8B 07 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 48 8D 45 6F 48 89 74 24 30 48 89 44 24 28 4C 8D 4D 57 48 8D 45 A3 33 D2 4C 8D 45 9F 48 89 44 24 20 48 8B CF FF D3 84 C0 0F 84 11 01 00 00 0F B7 45 57 41 3B C6 75 10 8B 4D 9F 41 3B CF 77 08 03 4D A3 44 3B F9 72 06 48 8B 7D 97 EB 84 39 75 6F 0F 84 E9 00 00 00 8B 5D 6F 48 C1 E3 03 FF 15 ?? ?? ?? ?? 4C 8B C3 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 4C 8B E0 48 85 C0 0F 84 C2 00 00 00 48 8B 7D 97 48 8B 17 48 8B 5A 18 48 8B CB E8 ?? ?? ?? ?? 48 8D 45 6F 4C 89 64 24 30 48 89 44 24 28 48 8D 55 A7 45 33 C9 48 89 74 24 20 45 33 C0 48 8B CF FF D3 84 C0 74 75 44 2B 7D 9F 45 3B 3C 24 72 6B 41 BE 01 00 00 00 41 8B CE 44 39 75 6F 76 10 8B C1 45 3B 3C C4 72 08 41 03 CE 3B 4D 6F 72 F0 48 8B 7D AF 8D 41 FF 41 8B 44 C4 04 25 FF FF FF 00 41 89 45 00 48 8B 07 48 8B 98 E0 00 00 00 48 8B CB E8 ?? ?? ?? ?? 4C 8B 45 5F 4C 8D 4D 67 8B 55 A7 48 8B CF 48 89 74 24 30 48 89 74 24 28 48 89 74 24 20 FF D3 84 C0 41 0F 45 F6 FF 15 ?? ?? ?? ?? 4D 8B C4 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 7D 97 48 8B 07 48 8B 18 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B 7D AF 48 8B 07 48 8B 98 80 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B 7D BF 48 8B 07 48 8B 58 70 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B 7D B7 48 8B 17 48 8B 5A 58 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 8B C6 48 81 C4 B8 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "__sse2_exp2"
		size = 752
		refs = "0012 s_dwInvLn 001a s_dwNegRS 0026 s_dwLnHi 002e s_dwBias 0064 s_dwLnLo 0078 s_dwExp2 0096 s_dwA4 00b5 s_dwA5 00d8 s_dwA3 00e0 s_dwA2 00f8 s_dwOne 01c2 iAbsMask 01ce dbB1 01e7 dbB2 026a dbInf"
	strings:
		$1 = { 48 83 EC 68 0F 29 7C 24 40 0F 29 74 24 50 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 5C 15 ?? ?? ?? ?? 66 0F C5 C8 03 66 0F 28 E8 66 0F 58 DA 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 4C 8D 05 ?? ?? ?? ?? 0F 8D 9E 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 81 F9 86 40 00 00 0F 8D 8F 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 E8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 D0 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 C3 66 0F 59 D5 66 0F 58 C5 66 0F 58 15 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C2 66 0F 59 C1 0F 28 74 24 50 0F 28 7C 24 40 48 83 C4 68 C3 66 0F 1F 84 00 00 00 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 0F 1F 00 89 44 24 20 89 54 24 24 8B 44 24 20 8B 54 24 24 89 44 24 28 89 54 24 30 8B 44 24 28 8B 54 24 30 4C 8D 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 41 0F 7E BC C0 00 02 00 00 66 41 0F 16 BC D0 00 02 00 00 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 41 0F 7E BC C0 10 02 00 00 66 41 0F 16 BC D0 10 02 00 00 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 41 0F 7E 8C C0 20 02 00 00 66 41 0F 16 8C D0 20 02 00 00 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 41 0F 7E BC C0 30 02 00 00 66 41 0F 16 BC D0 30 02 00 00 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 0F 28 74 24 50 0F 28 7C 24 40 48 83 C4 68 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 187
		refs = "000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d __p__commode 0025 _get_startup_commit_mode 0031 __scrt_initialize_onexit_tables 003a _RTC_Initialize 0041 _RTC_Terminate 0046 atexit 004b _get_startup_argv_mode 0052 _configure_narrow_argv 005b ?__scrt_initialize_type_info@@YAXXZ 0060 __scrt_is_user_matherr_present 006b _matherr 0070 __setusermatherr 0075 _initialize_invalid_parameter_handler 007a _initialize_denormal_control 007f _get_startup_thread_locale_mode 0086 _configthreadlocale 008b _should_initialize_environment 0094 _initialize_narrow_environment 0099 __scrt_initialize_winrt 00ab __scrt_fastfail"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 01 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? B9 01 00 00 00 89 03 E8 ?? ?? ?? ?? 84 C0 74 6C E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 85 C0 75 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 B9 07 00 00 00 E8 ?? ?? ?? ?? CC B9 07 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "?pre_c_initialization@@YAHXZ"
		size = 187
		refs = "000c _set_app_type 0011 _get_startup_file_mode 0018 _set_fmode 001d __p__commode 0025 _get_startup_commit_mode 0031 __scrt_initialize_onexit_tables 003a _RTC_Initialize 0041 _RTC_Terminate 0046 atexit 004b _get_startup_argv_mode 0052 _configure_wide_argv 005b ?__scrt_initialize_type_info@@YAXXZ 0060 __scrt_is_user_matherr_present 006b _matherr 0070 __setusermatherr 0075 _initialize_invalid_parameter_handler 007a _initialize_denormal_control 007f _get_startup_thread_locale_mode 0086 _configthreadlocale 008b _should_initialize_environment 0094 _initialize_wide_environment 0099 __scrt_initialize_winrt 00ab __scrt_fastfail"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 01 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? B9 01 00 00 00 89 03 E8 ?? ?? ?? ?? 84 C0 74 6C E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 85 C0 75 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 B9 07 00 00 00 E8 ?? ?? ?? ?? CC B9 07 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_244_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 375
		refs = "0015 __scrt_initialize_crt 0023 __scrt_fastfail 0031 __scrt_acquire_startup_lock 0039 __scrt_current_native_startup_state 005d __xi_z 0064 __xi_a 0069 _initterm_e 007e __xc_z 0085 __xc_a 008a _initterm 00a5 __scrt_release_startup_lock 00aa __scrt_get_dyn_tls_init_callback 00bb __scrt_is_nonwritable_in_current_image 00ca _guard_check_icall 00da __scrt_get_dyn_tls_dtor_callback 00f7 _register_thread_local_exe_atexit_callback 00fc __p___argv 0104 __p___argc 010c _get_initial_narrow_environment 0119 main 0120 __scrt_is_managed_app 012b exit 0135 _cexit 013e __scrt_uninitialize_crt 0154 _exit 0161 _c_exit"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 B9 01 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 0B B9 07 00 00 00 E8 ?? ?? ?? ?? CC 40 32 F6 40 88 74 24 20 E8 ?? ?? ?? ?? 8A D8 8B 0D ?? ?? ?? ?? 83 F9 01 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? 85 C9 75 4A C7 05 ?? ?? ?? ?? 01 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B8 FF 00 00 00 E9 EC 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 08 40 B6 01 40 88 74 24 20 8A CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 22 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 16 48 8B 1B 48 8B CB E8 ?? ?? ?? ?? 45 33 C0 41 8D 50 02 33 C9 FF D3 E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 14 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 08 48 8B 0B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B F8 E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 17 8B 0B E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 84 C0 75 07 8B CB E8 ?? ?? ?? ?? 40 84 F6 75 05 E8 ?? ?? ?? ?? 33 D2 B1 01 E8 ?? ?? ?? ?? 8B C3 EB 21 8B D8 E8 ?? ?? ?? ?? 84 C0 75 08 8B CB E8 ?? ?? ?? ?? CC 80 7C 24 20 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_302_4_0 {
	meta:
		name = "?__scrt_common_main_seh@@YAHXZ"
		size = 375
		refs = "0015 __scrt_initialize_crt 0023 __scrt_fastfail 0031 __scrt_acquire_startup_lock 0039 __scrt_current_native_startup_state 005d __xi_z 0064 __xi_a 0069 _initterm_e 007e __xc_z 0085 __xc_a 008a _initterm 00a5 __scrt_release_startup_lock 00aa __scrt_get_dyn_tls_init_callback 00bb __scrt_is_nonwritable_in_current_image 00ca _guard_check_icall 00da __scrt_get_dyn_tls_dtor_callback 00f7 _register_thread_local_exe_atexit_callback 00fc __p___wargv 0104 __p___argc 010c _get_initial_wide_environment 0119 wmain 0120 __scrt_is_managed_app 012b exit 0135 _cexit 013e __scrt_uninitialize_crt 0154 _exit 0161 _c_exit"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 B9 01 00 00 00 E8 ?? ?? ?? ?? 84 C0 75 0B B9 07 00 00 00 E8 ?? ?? ?? ?? CC 40 32 F6 40 88 74 24 20 E8 ?? ?? ?? ?? 8A D8 8B 0D ?? ?? ?? ?? 83 F9 01 75 0A B9 07 00 00 00 E8 ?? ?? ?? ?? 85 C9 75 4A C7 05 ?? ?? ?? ?? 01 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A B8 FF 00 00 00 E9 EC 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 EB 08 40 B6 01 40 88 74 24 20 8A CB E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 22 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 16 48 8B 1B 48 8B CB E8 ?? ?? ?? ?? 45 33 C0 41 8D 50 02 33 C9 FF D3 E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 14 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 08 48 8B 0B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B F8 E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 17 8B 0B E8 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 84 C0 75 07 8B CB E8 ?? ?? ?? ?? 40 84 F6 75 05 E8 ?? ?? ?? ?? 33 D2 B1 01 E8 ?? ?? ?? ?? 8B C3 EB 21 8B D8 E8 ?? ?? ?? ?? 84 C0 75 08 8B CB E8 ?? ?? ?? ?? CC 80 7C 24 20 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_244_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 54
		refs = "000b __p___argv 0013 __p___argc 001b _get_initial_narrow_environment 0032 main"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 E8 ?? ?? ?? ?? 48 8B F8 E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 48 8B 17 4C 8B C0 8B 0B 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_302_9_0 {
	meta:
		name = "?invoke_main@@YAHXZ"
		size = 54
		refs = "000b __p___wargv 0013 __p___argc 001b _get_initial_wide_environment 0032 wmain"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 E8 ?? ?? ?? ?? 48 8B F8 E8 ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 48 8B 17 4C 8B C0 8B 0B 48 8B 5C 24 30 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "_RTC_GetErrDesc"
		size = 23
		refs = "000b ?_RTC_errlist@@3QBQEBDB"
	strings:
		$1 = { 83 F9 04 77 0F 48 63 C1 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_245_4_0 {
	meta:
		name = "_RTC_SetErrorFunc"
		size = 23
		refs = "0003 ?_RTC_ErrorReportFunc@@3P6AHHPEBDH00ZZEA 000a ?_RTC_ErrorReportFuncW@@3P6AHHPEB_WH00ZZEA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 48 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_245_5_0 {
	meta:
		name = "_RTC_SetErrorFuncW"
		size = 23
		refs = "0003 ?_RTC_ErrorReportFuncW@@3P6AHHPEB_WH00ZZEA 000a ?_RTC_ErrorReportFunc@@3P6AHHPEBDH00ZZEA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 83 25 ?? ?? ?? ?? 00 48 89 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_245_6_0 {
	meta:
		name = "_RTC_SetErrorType"
		size = 28
		refs = "000b ?_RTC_ErrorLevels@@3PAHA"
	strings:
		$1 = { 83 F9 04 77 13 48 63 C9 4C 8D 05 ?? ?? ?? ?? 41 8B 04 88 41 89 14 88 C3 83 C8 FF C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "??2@YAPEAX_KAEBUnothrow_t@std@@@Z"
		size = 29
		refs = "000e ??2@YAPEAX_K@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF E8 ?? ?? ?? ?? 90 EB 02 33 C0 48 83 C4 38 C3 CC }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "__sse2_tanf4"
		size = 2576
		refs = "001a MMSRSHIFT 002a MMSINVPI 0031 MMSPI1 0041 MMSPI2 0049 MMIABSMASK 0051 MMIHUGE 0063 MMSPI3 006a MMSPI4 0084 MMSP1 008e MMSQ2 00b9 MMSP0 00c0 MMSQ1 00cd MMSQ0 0117 MMISIGNMASK 0128 flAllOnes 014a flTwoPow30 01c0 dbInvPio4 01d5 dbiOne 01dd MSK_LOW_BIT 01e5 dbRS 0202 PI04C_0 020e PI04C_1 021e PI04C_2 024f PI04C_3 027b PI04C_4 07e5 __spec_table"
	strings:
		$1 = { 48 81 EC 28 01 00 00 0F 29 BC 24 00 01 00 00 0F 29 B4 24 10 01 00 00 0F 28 2D ?? ?? ?? ?? 0F 28 F8 0F 28 F0 0F 28 D0 0F 59 05 ?? ?? ?? ?? 0F 28 25 ?? ?? ?? ?? 0F 58 C5 0F 28 D8 0F 5C C5 0F 28 2D ?? ?? ?? ?? 66 0F DB 3D ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 0F 50 C7 0B C0 0F 85 B4 00 00 00 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 66 0F 6F C3 0F 5C D4 0F 28 25 ?? ?? ?? ?? 0F 5C D5 0F 28 2D ?? ?? ?? ?? 0F 5C D6 66 0F 72 F3 1E 66 0F EF C9 0F C2 D9 04 0F 28 CA 0F 5C CF 0F 59 D2 66 0F 72 F0 1F 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 66 0F DB CC 66 0F DF D5 66 0F EB CA 0F 28 F3 0F 28 FB 66 0F DF F4 66 0F DB FD 66 0F EB F7 0F 5E F1 66 0F EF C6 0F 28 B4 24 10 01 00 00 0F 28 BC 24 00 01 00 00 48 81 C4 28 01 00 00 C3 0F 28 0D ?? ?? ?? ?? 0F 29 7C 24 40 66 0F DB CE 66 0F EF 3D ?? ?? ?? ?? 0F 29 54 24 50 66 0F DB 35 ?? ?? ?? ?? 0F 29 7C 24 60 0F 28 FE 0F 29 74 24 70 66 0F 66 35 ?? ?? ?? ?? 66 0F DB 4C 24 40 0F 29 8C 24 80 00 00 00 0F 50 D6 85 D2 0F 85 70 05 00 00 83 F8 0F 0F 84 DA 02 00 00 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 5C D7 66 0F DB 5C 24 60 66 0F DB 54 24 60 0F 29 9C 24 90 00 00 00 0F 29 94 24 A0 00 00 00 0F 5A 44 24 70 0F 5A 4C 24 78 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D8 66 0F E6 DB 66 0F 70 DB DC 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 29 8C 24 B0 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 72 E3 01 66 0F 5C F0 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C CA 66 0F 28 EB 66 0F 28 9C 24 B0 00 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F E6 DB 66 0F 58 C8 66 0F 28 84 24 B0 00 00 00 66 0F 70 ED 88 66 0F 70 DB DC 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 29 8C 24 C0 00 00 00 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 AC 24 D0 00 00 00 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 72 E3 01 66 0F 5C F0 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C CA 66 0F 28 EB 66 0F 58 C1 66 0F 5A 94 24 C0 00 00 00 66 0F 70 ED 88 66 0F 5A D8 66 0F 14 D3 F3 0F 7E 9C 24 D0 00 00 00 66 0F 14 DD 66 0F DB 5C 24 40 66 0F DB 54 24 40 66 0F EB 9C 24 90 00 00 00 66 0F EB 94 24 A0 00 00 00 0F 28 C3 66 0F 72 F0 1F 66 0F EF 84 24 80 00 00 00 66 0F 72 F3 1E 66 0F EF C9 0F C2 D9 04 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 CA 0F 59 D2 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 66 0F DB CC 66 0F DF D5 66 0F EB CA 0F 28 F3 0F 28 FB 66 0F DF F4 66 0F DB FD 66 0F EB F7 0F 5E F1 66 0F EF C6 E9 7B 03 00 00 0F 5A C7 66 0F 70 FF EE 0F 5A FF 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 F7 66 0F E6 DB 66 0F E6 F6 66 0F 70 DB DC 66 0F 70 F6 DC 66 0F FE 1D ?? ?? ?? ?? 66 0F FE 35 ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F DB 35 ?? ?? ?? ?? 66 0F 29 B4 24 E0 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 72 E3 01 66 0F 5C F0 66 0F 29 BC 24 B0 00 00 00 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C CA 66 0F 28 EB 66 0F 58 C8 66 0F 28 84 24 B0 00 00 00 66 0F 70 ED 88 66 0F 6F 9C 24 E0 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 94 24 E0 00 00 00 66 0F 29 8C 24 C0 00 00 00 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F D6 AC 24 D0 00 00 00 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 72 E3 01 66 0F 5C F0 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C CA 66 0F 28 EB 66 0F 58 C1 66 0F 5A 94 24 C0 00 00 00 66 0F 70 ED 88 66 0F 5A D8 66 0F 14 D3 F3 0F 7E 9C 24 D0 00 00 00 66 0F 14 DD 0F 28 C3 66 0F 72 F0 1F 66 0F EF 84 24 80 00 00 00 66 0F 72 F3 1E 66 0F EF C9 0F C2 D9 04 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 CA 0F 59 D2 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 66 0F DB CC 66 0F DF D5 66 0F EB CA 0F 28 F3 0F 28 FB 66 0F DF F4 66 0F DB FD 66 0F EB F7 0F 5E F1 66 0F EF C6 E9 EE 00 00 00 83 F8 0F 0F 84 BB 00 00 00 0F 28 35 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 CA 0F 5C CF 66 0F EF FF 0F 59 D2 0F 29 8C 24 F0 00 00 00 0F 28 C3 66 0F 72 F0 1F 66 0F EF C7 66 0F 72 F3 1E 66 0F EF C9 0F C2 D9 04 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 8C 24 F0 00 00 00 0F 59 E2 0F 59 EA 0F 58 25 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 0F 59 E1 0F 59 EA 0F 58 2D ?? ?? ?? ?? 0F 28 CB 0F 28 D3 66 0F DB CC 66 0F DF D5 66 0F EB CA 0F 28 F3 0F 28 FB 66 0F DF F4 66 0F DB FD 66 0F EB F7 0F 5E F1 66 0F EF C6 0F 29 84 24 F0 00 00 00 89 44 24 20 8B 44 24 20 85 C0 74 16 45 33 C9 A8 01 75 2F 49 FF C1 D1 F8 89 44 24 20 49 83 F9 04 7C ED 0F 28 84 24 F0 00 00 00 0F 28 B4 24 10 01 00 00 0F 28 BC 24 00 01 00 00 48 81 C4 28 01 00 00 C3 42 8B 44 8C 50 48 8D 15 ?? ?? ?? ?? 89 44 24 28 48 89 54 24 30 F3 0F 10 44 24 28 4C 8B 44 24 30 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 0F 84 DF 01 00 00 0F C6 C8 00 66 0F 7E C1 0F 5A C9 0F 5A C8 81 E1 FF FF FF 7F 81 E9 00 00 80 39 C1 E9 17 83 E9 1B 81 E1 F8 FF 00 00 F2 41 0F 10 9C 48 00 09 00 00 F2 41 0F 10 AC 48 08 09 00 00 F2 41 0F 10 90 B0 0A 00 00 66 0F 57 E4 BA C8 43 00 00 66 0F C4 E2 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD 66 0F 28 C2 F2 0F 58 D3 66 0F 28 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 C3 F2 41 0F 10 B0 A0 0A 00 00 F2 0F 5C D4 F2 0F 58 C1 F2 0F 5C EA F2 0F 58 C5 F2 0F 59 C6 F2 0F 5A D0 F3 41 0F 10 88 60 0A 00 00 F3 0F 59 CA 41 0F 28 B8 F0 09 00 00 F3 0F 2D D1 66 0F DB FA F2 41 0F 10 A0 70 0A 00 00 F3 0F 58 E1 F3 41 0F 58 88 90 0A 00 00 F3 41 0F 5C A0 70 0A 00 00 F3 41 0F 5C 88 90 0A 00 00 66 0F 28 EF 66 0F 73 F7 20 66 0F 73 F5 1D 66 0F 57 FD 81 C2 00 76 1C 00 83 E2 1F F2 41 0F 10 A8 30 0A 00 00 66 0F 57 EF F2 41 0F 10 90 10 0A 00 00 66 0F 57 D7 F2 41 0F 10 B0 20 0A 00 00 66 0F 57 F7 F2 41 0F 10 98 00 0A 00 00 66 0F 57 DF 49 8D 00 C1 E2 03 48 03 C2 C1 E2 03 48 03 C2 66 0F 73 F4 1D 66 0F 73 F1 1D F2 0F 59 EC F2 0F 59 D1 F2 0F 59 F4 F2 0F 59 D9 F2 0F 58 E8 F2 0F 58 D0 F2 0F 58 EE F2 0F 58 D3 F2 41 0F 10 B8 40 0A 00 00 F2 0F 5E FD F2 0F 59 78 40 F2 0F 10 58 38 F2 0F 59 DA F2 0F 10 60 18 F2 0F 59 E2 F2 0F 10 68 28 F2 0F 59 EA F2 0F 10 70 08 F2 0F 59 F2 F2 0F 59 D2 F2 0F 58 58 30 F2 0F 58 60 10 F2 0F 58 68 20 F2 0F 58 30 F2 0F 59 DA F2 0F 59 E2 F2 0F 59 D2 F2 0F 58 DD F2 0F 58 E6 F2 0F 59 DA F2 0F 58 DC F2 0F 5C DF F2 0F 5A C3 EB 04 F3 0F 5C C0 F3 0F 11 44 24 24 8B 44 24 24 42 89 84 8C F0 00 00 00 8B 44 24 20 E9 9F FD FF FF 90 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__avx_log10f8"
		size = 576
		refs = "0024 __common_slog10_data 0236 __common_slog10_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 84 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 8F 01 00 00 C5 78 10 05 ?? ?? ?? ?? 49 83 E5 C0 C5 F8 10 2D ?? ?? ?? ?? C4 C1 79 FA C8 C4 E3 7D 19 C2 01 C4 C1 69 FA E0 C5 E9 72 E1 17 C5 E1 72 E4 17 C5 F1 DB CD C5 D9 DB E5 C5 FC C2 2D ?? ?? ?? ?? 11 C4 E3 6D 18 D3 01 C4 C1 71 FE D8 C4 C1 59 FE C8 C5 FC 5B D2 C4 E3 65 18 C9 01 C5 FC C2 1D ?? ?? ?? ?? 16 C5 F4 5C 0D ?? ?? ?? ?? C5 D4 56 E3 C5 E1 EF DB C4 C3 7D 19 E0 01 C4 C1 59 6B E8 C5 74 59 05 ?? ?? ?? ?? C5 D1 63 E3 C5 F4 59 D9 C5 F4 59 2D ?? ?? ?? ?? C5 3C 58 05 ?? ?? ?? ?? C5 F9 D7 D4 C5 D4 58 2D ?? ?? ?? ?? C5 3C 59 C3 C5 F4 59 25 ?? ?? ?? ?? C5 3C 58 C5 C5 DC 58 25 ?? ?? ?? ?? C5 F4 59 2D ?? ?? ?? ?? C5 3C 59 C3 C5 D4 58 2D ?? ?? ?? ?? C5 BC 58 E4 C5 6C 59 05 ?? ?? ?? ?? C5 EC 59 15 ?? ?? ?? ?? C5 DC 59 DB C5 E4 58 DD C5 E4 59 E1 C5 DC 58 2D ?? ?? ?? ?? C5 D4 59 C9 C4 C1 74 58 C8 C5 EC 58 C9 84 D2 75 1D C5 7C 10 84 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 D3 33 C0 C5 FC 11 B4 24 20 01 00 00 C5 FC 11 BC 24 00 01 00 00 C5 7C 11 8C 24 E0 00 00 00 C5 7C 11 94 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 48 01 00 00 8B D8 48 89 B4 24 40 01 00 00 8B F2 0F A3 DE 72 6A FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 20 01 00 00 C5 FC 10 BC 24 00 01 00 00 C5 7C 10 8C 24 E0 00 00 00 C5 7C 10 94 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 48 01 00 00 48 8B B4 24 40 01 00 00 E9 06 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 82 0F 1F 40 00 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "__sse2_tanh2"
		size = 640
		refs = "001b s_dwAbsMsk 0027 s_dwInvLn 0032 s_dwExp2 003a s_dwRS 004a s_dwLnHi 0056 s_dwLnLo 007d s_dwExpbOvfBoundHi 00aa s_dwBias 00f5 s_dwExpbMask 014b s_dwA5 0165 s_dwA4 0188 s_dwA3 0194 s_dwA2 01fa s_dwSignMask 0223 s_dwLoSpecMask 022d s_dwHiSpecMask 0253 s_dwOne"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C7 4C 8D 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 54 F9 66 0F 28 25 ?? ?? ?? ?? 66 0F 58 D3 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 29 4C 24 20 66 0F 5C D3 48 8D 44 24 20 66 0F 28 CE 66 0F 59 E2 66 0F 57 DB 66 0F C2 3D ?? ?? ?? ?? 05 66 0F 73 F6 04 66 0F 29 4C 24 30 66 0F 59 EA 66 0F FB D9 66 0F 5C C4 66 41 0F 7E F0 66 0F 5C C5 66 0F 50 CF 66 0F FE 0D ?? ?? ?? ?? 41 81 E0 F0 03 00 00 66 0F 15 F6 66 0F FE 1D ?? ?? ?? ?? 66 0F 73 F1 2E 66 0F 7E F2 66 43 0F 28 3C 10 81 E2 F0 03 00 00 66 0F 73 F3 2E 66 0F 29 44 24 40 41 F7 D8 66 42 0F 28 34 12 41 81 C0 00 04 00 00 66 0F DB 0D ?? ?? ?? ?? 66 0F 28 EF F7 DA 66 0F DB 1D ?? ?? ?? ?? 66 0F C6 EE 00 81 C2 00 04 00 00 66 43 0F 28 24 10 66 0F C6 FE 03 66 42 0F 28 14 12 66 0F 59 E9 66 0F 28 F4 66 0F 59 F9 66 0F C6 E2 00 66 0F 29 6C 24 50 66 0F 28 C8 66 0F C6 F2 03 66 0F 59 E3 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C0 66 0F 29 64 24 60 66 0F 59 F3 66 0F 58 EF 66 0F 28 1D ?? ?? ?? ?? 83 F9 03 66 0F 59 D0 66 0F 58 E6 0F 84 B9 00 00 00 66 0F 29 7C 24 70 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 28 FD 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 58 EC 66 0F 59 C3 66 0F 5C FC 66 0F 59 D1 66 0F 28 D8 66 0F 58 D1 66 0F 59 DD 66 0F 28 CA 66 0F 59 D7 66 0F 28 20 66 0F 59 C7 66 0F 58 DA 66 0F 59 CD 66 0F 28 7C 24 70 66 0F 58 DE 66 0F 28 6C 24 60 66 0F 58 DF 66 0F 5C F7 66 0F 28 54 24 50 66 0F 58 DD 66 0F 5C C6 66 0F 54 25 ?? ?? ?? ?? 66 0F 58 DA 66 0F 5C EA 66 0F 58 C1 66 0F 5C C5 66 0F 5E C3 83 F9 01 66 0F 56 C4 7D 02 EB 4B 7F 0A 66 0F 28 3D ?? ?? ?? ?? EB 0E 66 0F 28 3D ?? ?? ?? ?? EB 04 66 0F 57 FF 66 0F 28 08 66 0F 54 C7 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 DB 66 0F 54 D1 66 0F 55 3D ?? ?? ?? ?? 66 0F C2 D9 03 66 0F 56 C7 66 0F 56 C2 66 0F 56 C3 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "__common_dacos_cout_rare"
		size = 2720
		refs = "006b _vmldACosHATab 0a02 _2il0floatpacket_190"
	strings:
		$1 = { 55 48 81 EC D0 00 00 00 48 8D 6C 24 20 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 48 89 BD A0 00 00 00 41 81 F8 F0 7F 00 00 44 0F 29 7D 60 44 0F 29 75 70 44 0F 29 AD 80 00 00 00 44 0F 29 A5 90 00 00 00 44 0F 29 5D 30 44 0F 29 55 40 0F 29 75 50 F2 0F 10 01 48 8B 39 0F 84 1C 0A 00 00 48 89 7D 18 48 C1 EF 38 F2 44 0F 10 2D ?? ?? ?? ?? 83 E7 7F 40 88 7D 1F F2 44 0F 10 5D 18 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F EB 0F 86 67 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C3 0F 86 10 04 00 00 66 44 0F 2F 1D ?? ?? ?? ?? 0F 86 B4 03 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 41 0F 28 C3 F2 41 0F 59 C5 41 0F 28 D3 F2 0F 11 45 10 45 0F 28 FB F2 0F 10 65 10 41 0F 28 DD F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 5C 65 18 F2 0F 11 65 08 F2 0F 10 4D 10 F2 44 0F 10 65 08 F2 41 0F 5C CC F2 0F 11 4D 10 F2 0F 10 75 10 F2 0F 5C D6 F2 0F 11 55 08 F2 0F 10 6D 10 0F 28 D5 F2 44 0F 58 FD F2 0F 59 D5 F2 44 0F 10 75 08 0F 28 C2 F2 45 0F 59 FE F2 0F 59 DA F2 41 0F 58 C7 F2 44 0F 59 D0 F2 0F 11 5D 10 F2 0F 10 65 10 F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 5C E2 F2 44 0F 59 D0 F2 0F 11 65 08 F2 0F 10 4D 10 F2 44 0F 10 65 08 F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 5C CC F2 44 0F 59 D0 F2 0F 11 4D 10 F2 0F 10 75 10 F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 5C D6 F2 44 0F 59 D0 F2 0F 11 55 08 41 0F 28 F3 F2 0F 10 65 10 F2 0F 10 5D 08 F2 44 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 FB F2 0F 59 EC F2 44 0F 59 D0 F2 41 0F 59 F7 F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 58 F6 F2 44 0F 59 D0 45 0F 28 F5 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 59 F5 F2 44 0F 59 D0 F2 44 0F 11 75 10 F2 44 0F 10 65 10 F2 44 0F 5C E5 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 11 65 08 44 0F 28 E5 F2 0F 10 55 10 F2 0F 58 EE F2 44 0F 59 D0 F2 44 0F 59 FD F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 10 4D 08 F2 44 0F 59 D0 F2 0F 5C D1 F2 0F 11 55 10 F2 0F 10 5D 10 F2 44 0F 5C E3 0F 28 DC F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 11 65 08 F2 0F 10 4D 10 F2 0F 10 55 08 44 0F 28 F2 F2 0F 59 D9 F2 44 0F 58 F6 F2 44 0F 59 D0 F2 41 0F 59 E6 F2 44 0F 59 EB F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 58 E7 F2 44 0F 59 D0 F2 44 0F 11 6D 10 44 0F 28 F3 F2 44 0F 10 6D 10 F2 44 0F 5C EB F2 0F 58 DC F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 59 C3 F2 44 0F 59 D0 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 44 0F 11 6D 08 F2 0F 58 C5 F2 44 0F 10 6D 10 F2 41 0F 58 C2 F2 44 0F 10 15 ?? ?? ?? ?? F2 41 0F 59 F2 F2 41 0F 59 D2 F2 41 0F 59 CA F2 0F 58 C6 F2 44 0F 10 7D 08 F2 0F 58 C2 F2 45 0F 5C EF F2 44 0F 11 6D 10 41 0F 28 D3 F2 44 0F 10 65 10 F2 0F 58 D1 F2 45 0F 5C F4 F2 44 0F 11 75 08 F2 44 0F 10 6D 10 F2 44 0F 10 65 08 F2 0F 11 55 10 F2 0F 10 5D 10 F2 0F 11 4D 00 F2 44 0F 5C DB F2 44 0F 58 D9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 E1 F2 44 0F 59 E9 F2 41 0F 59 CC F2 44 0F 11 5D 08 F2 0F 10 55 10 F2 44 0F 10 5D 08 F2 41 0F 58 C3 F2 0F 58 C4 0F 28 E2 F2 41 0F 58 E5 F2 0F 58 C1 F2 0F 11 65 10 F2 44 0F 10 5D 10 F2 41 0F 5C D3 F2 41 0F 58 D5 F2 0F 11 55 08 F2 0F 10 65 10 F2 0F 10 29 F2 0F 10 5D 08 66 0F 2F 2D ?? ?? ?? ?? F2 0F 58 C3 76 42 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CB F2 0F 5C CC F2 0F 11 4D 10 F2 0F 10 55 10 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C DA F2 0F 5C C8 F2 0F 5C DC F2 0F 11 5D 08 F2 0F 10 55 10 F2 0F 10 65 08 F2 0F 58 CC EB 40 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CC F2 0F 58 CB F2 0F 11 4D 10 F2 0F 10 55 10 F2 0F 5C DA F2 0F 58 DC F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 5D 08 F2 0F 10 55 10 F2 0F 10 4D 08 F2 0F 58 C8 F2 0F 58 D1 F2 0F 11 12 E9 BC 05 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 45 0F 58 EB F2 44 0F 11 6D 10 F2 0F 10 45 10 F2 0F 59 45 18 F2 0F 11 45 00 40 8A 7D 07 8A 49 07 40 80 E7 7F 80 E1 80 40 0A F9 40 88 7D 07 F2 0F 5C 4D 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 0A E9 6F 05 00 00 4D 8B D1 F2 45 0F 5C EB F2 41 0F 59 C5 F2 0F 11 45 00 44 0F B7 45 06 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B F8 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4D 18 45 0B D3 66 44 89 55 1E 83 E7 01 F2 0F 10 75 18 44 8B DF F2 0F 59 C6 0F 28 E8 F2 44 0F 10 1D ?? ?? ?? ?? F2 0F 58 E8 75 03 0F 28 E8 F2 44 0F 59 DD 44 2B C7 F2 0F 10 1D ?? ?? ?? ?? 45 0F 28 D3 41 C1 E3 08 44 0F 28 E5 41 D1 E8 F2 0F 58 C3 F2 44 0F 5C D5 F2 0F 11 45 20 41 81 C0 FF 03 00 00 44 8B 55 20 41 81 E0 FF 07 00 00 41 81 E2 FF 01 00 00 F2 44 0F 11 55 08 45 03 D3 F2 0F 10 75 08 4C 8D 1D ?? ?? ?? ?? F2 44 0F 5C DE F2 47 0F 10 3C D3 41 0F 28 E3 4C 89 4D 28 41 0F 28 D7 49 C1 E9 30 F2 45 0F 5C E3 F2 45 0F 59 DF F2 41 0F 59 D7 41 C1 E0 04 41 81 E1 0F 80 FF FF 45 0B C8 66 44 89 4D 2E F2 44 0F 10 75 28 F2 45 0F 59 DE F2 0F 59 E2 F2 41 0F 59 D4 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 E2 0F 28 C1 F2 41 0F 59 C3 F2 0F 11 45 10 F2 44 0F 10 55 10 F2 0F 10 35 ?? ?? ?? ?? F2 45 0F 5C D3 F2 0F 59 F4 F2 44 0F 11 55 08 F2 44 0F 10 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 41 0F 59 F7 F2 45 0F 59 FC F2 44 0F 58 15 ?? ?? ?? ?? F2 0F 59 F5 F2 45 0F 59 D5 F2 41 0F 58 F7 F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 59 F6 F2 45 0F 59 D5 F2 0F 10 55 10 F2 0F 10 5D 08 F2 44 0F 10 25 ?? ?? ?? ?? F2 0F 5C D3 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 D5 F2 45 0F 59 E5 F2 44 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 D5 F2 0F 11 55 10 0F 28 D1 F2 0F 10 65 10 F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 5C DC F2 41 0F 59 D5 F2 44 0F 58 15 ?? ?? ?? ?? 44 0F 28 FB F2 44 0F 11 5D 08 F2 44 0F 10 5D 10 F2 0F 10 6D 08 F2 0F 11 55 10 F2 0F 58 F5 F2 45 0F 59 D5 F2 44 0F 58 3D ?? ?? ?? ?? F2 0F 10 65 10 F2 45 0F 58 FC F2 45 0F 59 D5 F2 41 0F 5C E5 F2 45 0F 59 FD F2 45 0F 59 D5 F2 0F 10 05 ?? ?? ?? ?? 45 0F 28 E5 44 0F 28 F0 F2 0F 11 65 08 F2 0F 10 6D 10 F2 0F 10 55 08 F2 44 0F 58 35 ?? ?? ?? ?? F2 0F 5C EA F2 45 0F 58 F7 F2 0F 11 6D 10 44 0F 28 F9 F2 0F 10 65 10 F2 45 0F 58 F2 F2 44 0F 5C E4 F2 41 0F 59 F6 F2 44 0F 11 65 08 F2 44 0F 10 75 10 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E5 F2 44 0F 59 F3 F2 44 0F 59 FD F2 0F 10 55 08 F2 44 0F 11 7D 10 F2 44 0F 10 65 10 F2 0F 59 E2 F2 44 0F 5C E5 F2 0F 59 DA F2 44 0F 11 65 08 F2 44 0F 10 65 10 F2 44 0F 10 7D 08 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C E7 F2 41 0F 59 D5 F2 44 0F 11 65 10 F2 44 0F 10 7D 10 F2 41 0F 5C EF 45 0F 28 FE F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6D 08 F2 44 0F 10 65 10 F2 44 0F 59 25 ?? ?? ?? ?? F2 41 0F 59 D5 F2 45 0F 58 FC F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6D 08 F2 41 0F 58 D2 F2 0F 58 EC F2 41 0F 59 D3 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7D 10 F2 44 0F 10 7D 10 F2 44 0F 11 65 20 F2 45 0F 5C F7 F2 45 0F 58 F4 F2 44 0F 11 75 08 44 0F 28 F0 F2 44 0F 10 7D 10 F2 44 0F 10 65 08 F2 45 0F 58 F7 F2 44 0F 11 75 10 F2 44 0F 10 75 10 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 45 08 F2 44 0F 10 75 10 F2 41 0F 59 CE F2 44 0F 10 7D 08 F2 0F 11 4D 10 F2 0F 10 4D 10 F2 41 0F 5C CE F2 0F 11 4D 08 F2 0F 10 4D 10 F2 0F 10 45 08 F2 0F 5C C8 F2 0F 11 4D 10 F2 0F 10 45 10 F2 44 0F 5C F0 F2 44 0F 11 75 08 F2 0F 10 45 10 F2 44 0F 10 75 08 F2 44 0F 10 29 F2 45 0F 58 F4 66 44 0F 2F 2D ?? ?? ?? ?? F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F3 F2 44 0F 59 D8 F2 41 0F 58 F6 F2 0F 58 F2 77 4C F2 0F 10 15 ?? ?? ?? ?? 0F 28 C2 F2 0F 10 25 ?? ?? ?? ?? F2 41 0F 5C C3 F2 0F 5C E6 F2 0F 11 45 10 F2 0F 10 4D 10 F2 44 0F 11 5D 00 F2 0F 5C D1 F2 41 0F 5C D3 F2 0F 11 55 08 F2 44 0F 10 5D 10 F2 0F 10 5D 08 0F 28 F3 F2 0F 58 F4 F2 44 0F 58 DE F2 44 0F 11 1A EB 2B 66 41 0F 2E C5 7A 02 74 70 44 0F 57 2D ?? ?? ?? ?? 66 41 0F 2E C5 7A 02 74 49 B8 01 00 00 00 F2 0F 5C C0 F2 0F 5E C0 F2 0F 11 02 0F 28 75 50 44 0F 28 55 40 44 0F 28 5D 30 44 0F 28 A5 90 00 00 00 44 0F 28 AD 80 00 00 00 44 0F 28 75 70 44 0F 28 7D 60 48 8B BD A0 00 00 00 48 8D A5 B0 00 00 00 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 02 EB B2 48 8B 0D ?? ?? ?? ?? 48 89 0A EB A6 F2 0F 5E C0 F2 0F 11 02 F7 41 04 FF FF 0F 00 75 95 BA 01 00 00 00 33 C0 83 39 00 0F 44 C2 EB 86 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "__common_dtanh_cout_rare"
		size = 128
		refs = "0003 _imldTanhHATab"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 8A 41 07 24 80 C0 E8 07 44 0F B6 C8 0F B7 41 06 25 F0 7F 00 00 C1 E8 04 4F 8B 04 C8 3D FF 07 00 00 74 27 3D FE 07 00 00 75 05 4C 89 02 EB 18 F2 0F 10 09 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 C1 F2 0F 59 C8 F2 0F 11 0A 33 C0 C3 F7 41 04 FF FF 0F 00 75 0A 83 39 00 75 05 4C 89 02 EB EA F2 0F 10 01 F2 0F 58 C0 F2 0F 11 02 EB DC 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "__avx_coshf8"
		size = 576
		refs = "0036 __common_scosh_data 0232 __common_scosh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 A4 24 D0 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 F0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 4F 01 00 00 C5 FC 10 0D ?? ?? ?? ?? 49 83 E5 C0 C5 FC 10 1D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 F8 10 35 ?? ?? ?? ?? C5 F4 55 E0 C5 5C 59 25 ?? ?? ?? ?? C5 9C 58 EB C5 59 66 E2 C4 E3 7D 19 E1 01 C5 D9 76 FA C5 99 EB FF C5 71 66 E2 C5 F1 76 D2 C5 99 EB CA C5 41 6B E1 C5 C1 EF FF C5 99 63 D7 C5 54 5C E3 C5 F9 D7 D2 C5 9C 59 1D ?? ?? ?? ?? C5 DC 5C FB C5 9C 59 25 ?? ?? ?? ?? C5 44 5C E4 C5 E9 72 F5 17 C4 E3 7D 19 EF 01 C5 C9 FE EA C5 E1 72 F7 17 C5 C9 FA CA C4 C1 1C 59 FC C5 C9 FE E3 C5 C9 FA F3 C5 C4 59 15 ?? ?? ?? ?? C5 EC 58 1D ?? ?? ?? ?? C4 E3 75 18 F6 01 C5 E4 59 CF C5 C4 59 1D ?? ?? ?? ?? C4 C1 74 59 D4 C4 41 6C 58 E4 C4 E3 55 18 E4 01 C5 DC 5C EE C5 DC 58 F6 C5 E4 58 25 ?? ?? ?? ?? C4 41 54 59 E4 C5 DC 59 CF C5 F4 58 15 ?? ?? ?? ?? C5 EC 59 FF C5 C4 59 CE C5 9C 58 D1 C5 EC 58 CE 84 D2 75 2F C5 FC 10 B4 24 F0 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 A4 24 D0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 C1 33 C0 C5 7C 11 84 24 E0 00 00 00 C5 7C 11 8C 24 C0 00 00 00 C5 7C 11 94 24 A0 00 00 00 C5 7C 11 9C 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 08 01 00 00 8B D8 48 89 B4 24 00 01 00 00 8B F2 0F A3 DE 72 58 FF C3 83 FB 20 7C F4 C5 7C 10 84 24 E0 00 00 00 C5 7C 10 8C 24 C0 00 00 00 C5 7C 10 94 24 A0 00 00 00 C5 7C 10 9C 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 08 01 00 00 48 8B B4 24 00 01 00 00 E9 18 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 94 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__avx_sin4"
		size = 2224
		refs = "000a __common_dsin_reduction_data 007f __common_dsin_data 0236 __common_dsin_cout_rare 0240 __common_dsin_data_ha 02a7 _2il0floatpacket_264 02fa _2il0floatpacket_265 0353 _2il0floatpacket_266 05b8 _2il0floatpacket_267 05de _2il0floatpacket_270 05f1 _2il0floatpacket_269 05fa _2il0floatpacket_268 0624 _2il0floatpacket_271 0681 _2il0floatpacket_272 0689 _2il0floatpacket_273 06e7 _2il0floatpacket_277 06fa _2il0floatpacket_274 0703 _2il0floatpacket_275 070c _2il0floatpacket_276 0767 _2il0floatpacket_278 0775 _2il0floatpacket_279"
	strings:
		$1 = { 48 81 EC B8 02 00 00 4C 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 70 01 00 00 45 33 DB C5 7C 11 B4 24 B0 01 00 00 C5 7C 11 AC 24 50 02 00 00 C5 7C 11 A4 24 90 01 00 00 C5 7C 11 9C 24 10 02 00 00 C5 7C 11 94 24 F0 01 00 00 C5 7C 11 8C 24 D0 01 00 00 C5 7C 11 84 24 90 02 00 00 C5 FC 11 BC 24 70 02 00 00 C5 FC 11 B4 24 30 02 00 00 4C 89 AC 24 B0 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 10 0D ?? ?? ?? ?? 49 83 E5 C0 C5 7D 54 E9 C5 95 C2 15 ?? ?? ?? ?? 1E C5 F5 55 E0 C4 E3 7D 19 D3 01 C5 E8 C6 EB DD C5 F8 50 C5 85 C0 0F 85 8D 01 00 00 C5 FD 10 35 ?? ?? ?? ?? C5 95 59 2D ?? ?? ?? ?? C5 D5 58 FE C5 C5 5C DE C5 65 59 1D ?? ?? ?? ?? C5 65 59 25 ?? ?? ?? ?? C5 65 59 3D ?? ?? ?? ?? C5 E5 59 15 ?? ?? ?? ?? C4 41 15 5C EB C4 41 15 5C F4 C4 C1 0D 5C CF C5 F5 5C DA C5 E5 59 D3 C5 ED 59 35 ?? ?? ?? ?? C5 B9 73 F7 3F C4 C3 7D 19 F9 01 C5 CD 58 3D ?? ?? ?? ?? C4 C1 29 73 F1 3F C4 C3 3D 18 EA 01 C5 45 59 C2 C5 3D 58 0D ?? ?? ?? ?? C5 35 59 D2 C5 2D 58 1D ?? ?? ?? ?? C5 25 59 E2 C5 1D 58 2D ?? ?? ?? ?? C5 15 59 F2 C5 0D 58 3D ?? ?? ?? ?? C5 E5 57 CD C5 85 59 DA C5 E5 58 2D ?? ?? ?? ?? C5 D5 59 D2 C5 ED 59 F1 C5 CD 58 C9 C5 F5 57 CC 45 85 DB 75 6E C5 FC 10 B4 24 30 02 00 00 C5 FC 10 BC 24 70 02 00 00 C5 7C 10 84 24 90 02 00 00 C5 7C 10 8C 24 D0 01 00 00 C5 7C 10 94 24 F0 01 00 00 C5 7C 10 9C 24 10 02 00 00 C5 7C 10 A4 24 90 01 00 00 C5 7C 10 AC 24 50 02 00 00 C5 7C 10 B4 24 B0 01 00 00 C5 7C 10 BC 24 70 01 00 00 4C 8B AC 24 B0 02 00 00 C5 FD 28 C1 48 81 C4 B8 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 84 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 41 8B F3 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 4D 40 E9 52 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 C5 7D 10 15 ?? ?? ?? ?? BA 00 00 F0 7F C4 41 7D 11 6D 00 C4 C1 7D 11 65 20 C4 C1 7D 11 45 40 C5 79 6E C2 C4 C1 79 70 E0 11 C4 41 2D 54 DD C4 C1 25 C2 D2 00 C4 C3 7D 19 D1 01 C4 41 68 C6 F9 DD C4 41 78 50 DF C4 C1 59 DB FD C4 43 7D 19 EF 01 C5 89 73 D7 34 C4 C1 59 DB CF C5 E1 73 D1 34 C5 79 7E F0 C5 F9 7E D9 C5 FA 6F 25 ?? ?? ?? ?? C5 78 11 6C 24 20 C4 41 59 DB ED C4 43 79 16 F0 02 44 8D 0C 40 C4 E3 79 16 DA 02 8D 0C 49 41 C1 E1 03 C1 E1 03 47 8D 04 40 41 C1 E0 03 8D 04 52 C1 E0 03 C5 78 11 7C 24 30 C4 41 59 DB FF C4 01 F9 6E 1C 11 C4 A1 F9 6E 7C 11 10 C5 7A 6F 35 ?? ?? ?? ?? C4 A1 F9 6E 04 11 C4 21 F9 6E 64 11 08 C4 81 F9 6E 74 11 08 C4 81 21 16 14 10 C4 A1 41 16 5C 10 10 C4 41 11 D4 DE C4 C1 01 D4 FE C4 21 79 16 14 10 C5 D9 73 D3 20 C4 21 19 16 4C 10 08 C4 01 49 16 44 10 08 C4 81 F9 6E 6C 11 10 C4 C1 19 73 D0 20 C5 7A 6F 2D ?? ?? ?? ?? C4 81 51 16 4C 10 10 4C 8D 15 ?? ?? ?? ?? C4 41 29 DB F5 C4 C1 51 73 D1 20 C4 C1 39 DB F5 C4 C1 31 DB C5 C4 C1 31 73 D3 20 C4 41 21 DB C5 C4 41 41 DB DD C5 79 11 54 24 50 C5 A9 73 D7 20 C4 C1 21 F4 FE C4 41 69 DB FD C5 F9 11 54 24 40 C5 E9 73 D1 20 C4 C1 71 DB CD C4 C1 61 DB DD C5 FA 7F 84 24 A0 00 00 00 41 B8 00 00 00 80 C5 FA 7F BC 24 C0 00 00 00 C5 7A 7F 74 24 70 C5 FA 7F AC 24 90 00 00 00 C5 A1 F4 F8 C5 B1 F4 C1 C5 B1 F4 CA C5 B9 F4 D2 C5 21 F4 F5 C5 B9 F4 EE C5 B1 F4 F6 C5 7A 7F 7C 24 60 C5 E9 73 D2 20 C4 41 39 F4 FF C5 F1 D4 CA C5 7A 7F BC 24 B0 00 00 00 C5 81 73 D0 20 C4 C1 51 DB C5 C5 D1 73 D5 20 C5 F9 D4 C1 C5 81 D4 D0 C5 29 F4 FB C5 A9 F4 DC C5 A1 F4 E4 C5 D9 73 D4 20 C4 C1 41 DB C5 C5 E1 D4 CC C5 7A 7F A4 24 80 00 00 00 C4 C1 01 73 D7 20 C4 41 39 F4 E4 C5 C1 73 D7 20 C5 F9 D4 D9 C5 81 D4 E3 C5 C9 D4 DD C4 41 19 DB FD C5 F1 73 D2 20 C5 01 D4 FB C4 41 71 D4 FF C5 A9 F4 8C 24 A0 00 00 00 C5 F1 D4 F7 C5 B1 F4 8C 24 80 00 00 00 C5 31 F4 4C 24 60 C4 C1 09 DB C5 C5 E1 73 D4 20 C5 F9 D4 EE C4 C1 19 73 D4 20 C4 C1 49 73 D7 20 C5 E1 D4 FD C4 C1 71 D4 CC C5 FA 6F 9C 24 B0 00 00 00 C4 C1 09 73 D6 20 C4 C1 61 DB C5 C5 D1 73 D7 20 C5 F9 D4 C1 C5 A9 F4 8C 24 90 00 00 00 C5 29 F4 54 24 70 C5 C9 D4 F0 C4 C1 71 D4 CE C5 FA 6F 84 24 C0 00 00 00 C5 E1 73 D3 20 C4 41 79 DB E5 C5 89 73 D6 20 C5 19 D4 E1 C5 31 D4 CB C4 C1 51 D4 CC C5 F9 10 6C 24 40 C4 C1 01 73 F7 20 C5 99 73 D5 20 C4 C1 69 DB D5 C4 41 39 F4 C4 C4 C1 49 DB F5 C4 41 39 DB C5 C5 C1 73 F7 20 C4 41 39 D4 C1 C5 F9 10 6C 24 50 C5 B1 73 D1 20 C4 41 09 D4 F0 C5 B9 73 D5 20 C4 C1 19 73 F6 20 C4 41 21 F4 D8 C5 B9 73 D0 20 C4 41 29 D4 D0 C5 99 D4 F6 C4 41 21 DB F5 C4 C1 71 DB CD C4 41 09 D4 DA C5 01 D4 D2 C4 41 31 D4 CB C4 C1 79 6E D0 C4 C1 61 73 F1 20 C5 79 70 CA 11 C4 41 59 DB ED C5 61 D4 C1 C4 C1 41 D4 E5 C5 B1 DB 7C 24 20 C5 91 73 D6 0C C5 7A 6F 1D ?? ?? ?? ?? C4 C1 61 73 D0 0C C5 31 DB 7C 24 30 C4 C1 41 EF CB C4 C1 01 EF C3 C5 11 EB F1 C5 61 EB E0 C5 7A 6F 1D ?? ?? ?? ?? C4 C3 0D 18 D4 01 C4 41 01 EF E3 C5 78 10 35 ?? ?? ?? ?? C4 E2 7D 1A 2D ?? ?? ?? ?? C5 55 58 EA C5 15 5C CD C4 C1 41 EF EB C4 C1 6D 5C D1 C4 63 7D 19 E9 01 C4 41 11 DB EE C4 41 70 54 CE C5 7A 6F 35 ?? ?? ?? ?? C4 C1 09 DB DA C5 09 DB DC C5 F9 73 F3 1C C4 C1 61 73 F3 1C C5 F9 EB CD C4 C1 61 EB C4 C5 D9 73 D4 18 C5 79 7E EA C4 41 79 7E C9 C1 E2 05 C4 63 79 16 E8 02 41 C1 E1 05 C4 63 79 16 C9 02 C1 E0 05 C1 E1 05 C4 E3 75 18 C8 01 C4 43 55 18 E4 01 C4 41 75 5C F4 C5 FA 6F 0D ?? ?? ?? ?? C5 FA 6F 05 ?? ?? ?? ?? C5 01 EF D9 C5 79 DB FE C5 C1 EF D9 C4 C1 41 73 F7 28 C4 C1 49 73 D2 18 C4 41 79 DB C0 C5 41 EB D6 C4 C1 41 73 F0 28 C5 29 EB FB C5 41 EB D4 C4 41 29 EB C3 C4 C3 05 18 F8 01 C4 C3 65 18 E3 01 C5 C5 5C CC C5 ED 58 E9 C5 ED 5C D5 C5 F5 58 C2 C4 41 7D 58 D6 C4 62 7D 1A 35 ?? ?? ?? ?? C4 41 55 54 DE C4 41 55 5C FB C4 62 7D 1A 25 ?? ?? ?? ?? C4 E2 7D 1A 35 ?? ?? ?? ?? C4 E2 7D 1A 15 ?? ?? ?? ?? C4 41 4D 59 C7 C4 C1 6D 59 FB C4 C1 1D 59 E2 C4 C1 6D 59 C7 C4 C1 4D 59 CB C4 C1 7D 10 55 00 C5 BD 58 DF C5 DD 58 E8 C5 E5 58 F5 C4 81 F9 6E 5C 11 10 C4 A1 61 16 6C 11 10 C5 75 58 FE C4 C1 75 5C CF C5 F5 58 C6 C4 A1 F9 6E 0C 12 C4 21 71 16 2C 10 C4 62 7D 1A 1D ?? ?? ?? ?? C4 41 6D 54 E3 C4 62 7D 1A 35 ?? ?? ?? ?? C4 41 1D C2 D6 12 C4 C1 1D C2 E6 1E C5 2D 54 C2 C4 01 F9 6E 14 11 C4 C1 5D 54 FF C4 21 29 16 0C 11 C4 21 F9 6E 54 12 08 C5 3D 56 FF C4 01 F9 6E 44 11 08 C5 DD 54 D0 C4 A1 F9 6E 44 12 10 C4 A1 79 16 4C 10 10 C4 C3 15 18 F9 01 C4 21 29 16 4C 10 08 C4 21 39 16 6C 11 08 C4 C3 35 18 E5 01 C5 05 59 DC C4 41 45 59 CF C4 63 75 18 C5 01 C4 41 3D 58 E3 C4 41 35 58 D4 C4 C1 3D 5C F4 C4 41 1D 5C F2 C4 C1 4D 58 C3 C4 41 0D 58 E9 C5 45 58 CC C5 15 58 D8 C4 41 05 59 EF C5 95 59 0D ?? ?? ?? ?? C5 95 59 3D ?? ?? ?? ?? C5 F5 58 1D ?? ?? ?? ?? C5 45 58 25 ?? ?? ?? ?? C4 C1 65 59 ED C4 41 1D 59 F5 C4 C1 55 59 F7 C4 41 05 59 F8 C5 8D 58 3D ?? ?? ?? ?? C4 C1 4D 59 E1 C4 41 45 59 ED C4 C1 5D 58 CB C4 C1 15 59 C0 C4 21 F9 6E 44 12 18 C5 FD 58 E1 C4 C1 35 5C CF C4 01 F9 6E 7C 11 18 C4 21 39 16 4C 10 18 C5 ED 59 D1 C4 A1 01 16 44 11 18 C4 E3 35 18 D8 01 C5 ED 58 C3 C5 DD 58 C8 C4 C1 7D 10 45 40 C5 AD 58 D1 C4 C1 6D 57 4D 20 E9 C7 F8 FF FF 66 90 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "__sse2_sinhf4"
		size = 432
		refs = "003f __common_ssinh_data 01a2 __common_ssinh_cout_rare"
	strings:
		$1 = { 48 81 EC 08 01 00 00 44 0F 29 AC 24 F0 00 00 00 44 0F 29 9C 24 C0 00 00 00 44 0F 29 94 24 D0 00 00 00 44 0F 29 8C 24 E0 00 00 00 44 0F 28 C8 4C 89 AC 24 00 01 00 00 4C 8D 6C 24 6F 0F 28 05 ?? ?? ?? ?? 49 83 E5 C0 41 0F 54 C1 44 0F 28 E8 0F 28 25 ?? ?? ?? ?? 66 45 0F EF E9 41 0F 59 E5 41 0F 28 CD 44 0F 28 15 ?? ?? ?? ?? 66 0F 66 0D ?? ?? ?? ?? 41 0F 58 E2 0F 50 D1 0F 28 CC 66 0F 72 F4 17 44 0F 28 1D ?? ?? ?? ?? 85 D2 0F 28 2D ?? ?? ?? ?? 41 0F 5C CA 44 0F 59 D9 44 0F 28 15 ?? ?? ?? ?? 45 0F 5C EB 44 0F 59 D1 0F 28 1D ?? ?? ?? ?? 45 0F 5C EA 41 0F 28 CD 41 0F 59 CD 0F 59 E9 0F 59 D9 0F 58 2D ?? ?? ?? ?? 0F 58 1D ?? ?? ?? ?? 0F 59 E9 0F 59 D9 41 0F 59 ED 0F 58 1D ?? ?? ?? ?? 41 0F 58 ED 0F 59 D9 66 0F 6F 15 ?? ?? ?? ?? 66 44 0F 6F D2 66 0F FA D4 66 44 0F FE D4 66 41 0F 6F E2 44 0F 5C D2 0F 58 E2 41 0F 59 DA 0F 59 E5 0F 58 E3 41 0F 58 E2 0F 56 C4 75 34 44 0F 28 8C 24 E0 00 00 00 44 0F 28 94 24 D0 00 00 00 44 0F 28 9C 24 C0 00 00 00 44 0F 28 AC 24 F0 00 00 00 4C 8B AC 24 00 01 00 00 48 81 C4 08 01 00 00 C3 45 0F 29 4D 00 41 0F 29 45 40 74 C0 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 EB 88 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "__GSHandlerCheck_SEH"
		size = 133
		refs = "003e __GSHandlerCheckCommon 0066 __C_specific_handler"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 4D 8B 51 38 48 8B F2 4D 8B F0 48 8B E9 49 8B D1 48 8B CE 49 8B F9 41 8B 1A 48 C1 E3 04 49 03 DA 4C 8D 43 04 E8 ?? ?? ?? ?? 8B 45 04 24 66 F6 D8 B8 01 00 00 00 1B D2 F7 DA 03 D0 85 53 04 74 11 4C 8B CF 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "__sse2_sinf4"
		size = 2240
		refs = "0023 MMIABSMASK 002e MMSINVPI 0035 MMIHUGE 003f MMSPI1 004a MMSPI2 0063 MMSPI4 006d MMSPI3 0085 MMSA9 0095 MMSA5 009c MMSA3 00af MMSA7 00e7 MMISIGNMASK 010c flTwoPow30 0132 flAllOnes 016f dbInvPio2 018a dbiOne 0195 MSK_LOW_BIT 01a0 dbRS 01b4 PI02C_0 01c9 PI02C_1 01e1 PI02C_2 0237 PI02C_3 0268 PI02C_4 0278 dbSignMask 0745 __spec_table"
	strings:
		$1 = { 48 81 EC 38 01 00 00 0F 29 BC 24 10 01 00 00 0F 29 B4 24 20 01 00 00 0F 28 F0 0F 28 D0 0F 28 F8 0F 28 0D ?? ?? ?? ?? 66 0F DB F9 0F 28 25 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 59 C4 0F 28 25 ?? ?? ?? ?? 66 0F 66 FD 0F 28 2D ?? ?? ?? ?? 0F 50 C7 0B C0 0F 85 8B 00 00 00 66 0F 5B C0 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 0F 28 B4 24 20 01 00 00 0F 28 BC 24 10 01 00 00 48 81 C4 38 01 00 00 C3 0F 28 1D ?? ?? ?? ?? 66 0F DB DE 0F 29 74 24 40 66 0F 5B C0 66 0F DB 35 ?? ?? ?? ?? 0F 28 CE 0F 29 74 24 50 66 0F 66 35 ?? ?? ?? ?? 0F 29 5C 24 60 0F 50 D6 85 D2 0F 85 4A 05 00 00 83 F8 0F 0F 84 E6 02 00 00 0F 29 7C 24 70 66 0F EF 3D ?? ?? ?? ?? 0F 28 D8 0F 29 BC 24 80 00 00 00 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 5C D4 0F 5A 64 24 50 0F 59 F0 0F 5C D5 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EC 66 0F E6 ED 66 0F 70 ED DC 0F 59 F8 0F 5C D6 66 0F FE 2D ?? ?? ?? ?? 0F 28 CA 66 0F DB 2D ?? ?? ?? ?? 0F 5C CF 66 0F 28 3D ?? ?? ?? ?? 66 0F 56 FD 66 0F 5C 3D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C7 66 0F DB 9C 24 80 00 00 00 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 F7 66 0F 5C E0 0F 29 9C 24 90 00 00 00 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DF 66 0F 28 C4 66 0F 5C E6 66 0F DB 8C 24 80 00 00 00 66 0F 5C C4 0F 29 8C 24 A0 00 00 00 0F 59 D2 66 0F 28 CC 66 0F 5C C6 66 0F 5C E3 66 0F DB 94 24 80 00 00 00 66 0F 73 F5 3E 66 0F 5C CC 0F 29 94 24 B0 00 00 00 66 0F 28 D4 66 0F 28 35 ?? ?? ?? ?? 66 0F 5C CB 66 0F 58 C1 0F 5A 4C 24 58 66 0F 58 E0 66 0F 59 F7 66 0F 5C D4 66 0F 28 DC 66 0F 5C E6 66 0F 58 C2 66 0F 5C DC 66 0F 59 3D ?? ?? ?? ?? 66 0F 5C DE 66 0F 58 C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C C7 66 0F DB DD 66 0F 28 E9 66 0F 59 2D ?? ?? ?? ?? 66 0F E6 ED 66 0F 58 C4 66 0F 28 E1 66 0F 70 DB DD 66 0F 70 ED DC 66 0F FE 2D ?? ?? ?? ?? 66 0F DB 2D ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 56 FD 66 0F 29 84 24 C0 00 00 00 66 0F 5C 3D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C7 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 F7 66 0F D6 9C 24 D0 00 00 00 66 0F 5C E0 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DF 66 0F 28 C4 66 0F 5C E6 66 0F 5C C4 66 0F 28 CC 66 0F 5C C6 66 0F 5C E3 66 0F 73 F5 3E 66 0F 5C CC 66 0F 28 D4 66 0F 28 35 ?? ?? ?? ?? 66 0F 5C CB 66 0F 58 C1 66 0F 58 E0 66 0F 59 F7 66 0F 5C D4 66 0F 28 DC 66 0F 5C E6 66 0F 58 C2 66 0F 5C DC 66 0F 59 3D ?? ?? ?? ?? 66 0F 5C DE 66 0F 58 C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C C7 66 0F 5A BC 24 C0 00 00 00 66 0F DB DD 66 0F 58 C4 66 0F 5A E8 66 0F 14 FD 0F 28 05 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 E7 0F 59 FF 66 0F DB 7C 24 70 66 0F EB BC 24 B0 00 00 00 0F 59 C7 66 0F 70 DB DD 0F 58 05 ?? ?? ?? ?? F3 0F 7E AC 24 D0 00 00 00 0F 59 C7 66 0F 14 EB 0F 58 05 ?? ?? ?? ?? 66 0F EF 6C 24 60 0F 59 C7 66 0F DB 64 24 70 0F 58 C1 66 0F EB A4 24 A0 00 00 00 0F 59 C7 66 0F DB 6C 24 70 0F 59 C4 66 0F EB AC 24 90 00 00 00 0F 58 C4 66 0F EF C5 E9 16 03 00 00 66 0F 70 C1 EE 0F 5A E1 0F 5A C0 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 EC 66 0F 59 F0 66 0F E6 ED 66 0F E6 F6 66 0F 70 ED DC 66 0F 70 F6 DC 66 0F FE 2D ?? ?? ?? ?? 66 0F FE 35 ?? ?? ?? ?? 66 0F DB 2D ?? ?? ?? ?? 66 0F DB 35 ?? ?? ?? ?? 66 0F 29 B4 24 E0 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 56 FD 66 0F 5C 3D ?? ?? ?? ?? 66 0F 29 84 24 F0 00 00 00 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C7 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 F7 66 0F 5C E0 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DF 66 0F 28 C4 66 0F 5C E6 66 0F 5C C4 66 0F 28 CC 66 0F 5C C6 66 0F 5C E3 66 0F 73 F5 3E 66 0F 5C CC 66 0F 28 D4 66 0F 28 35 ?? ?? ?? ?? 66 0F 5C CB 66 0F 58 C1 66 0F 58 E0 66 0F 59 F7 66 0F 5C D4 66 0F 28 DC 66 0F 5C E6 66 0F 58 C2 66 0F 5C DC 66 0F 59 3D ?? ?? ?? ?? 66 0F 5C DE 66 0F 58 C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C C7 66 0F DB DD 66 0F 58 C4 66 0F 28 A4 24 F0 00 00 00 66 0F 70 DB DD 66 0F 28 AC 24 E0 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 56 FD 66 0F 29 84 24 C0 00 00 00 66 0F 5C 3D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 59 C7 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 F7 66 0F D6 9C 24 D0 00 00 00 66 0F 5C E0 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DF 66 0F 28 C4 66 0F 5C E6 66 0F 5C C4 66 0F 28 CC 66 0F 5C C6 66 0F 5C E3 66 0F 73 F5 3E 66 0F 5C CC 66 0F 28 D4 66 0F 28 35 ?? ?? ?? ?? 66 0F 5C CB 66 0F 58 C1 66 0F 58 E0 66 0F 59 F7 66 0F 5C D4 66 0F 28 DC 66 0F 5C E6 66 0F 58 C2 66 0F 5C DC 66 0F 59 3D ?? ?? ?? ?? 66 0F 5C DE 66 0F 58 C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C C7 66 0F 5A BC 24 C0 00 00 00 66 0F DB DD 66 0F 58 C4 66 0F 5A E8 66 0F 14 FD 0F 28 05 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 0F 28 E7 0F 59 FF 0F 59 C7 0F 58 05 ?? ?? ?? ?? 0F 59 C7 0F 58 05 ?? ?? ?? ?? 0F 59 C7 66 0F 70 DB DD 0F 58 C1 F3 0F 7E AC 24 D0 00 00 00 0F 59 C7 66 0F 14 EB 0F 59 C4 66 0F EF 6C 24 60 0F 58 C4 66 0F EF C5 E9 BB 00 00 00 83 F8 0F 0F 84 8C 00 00 00 0F 28 D8 0F 28 3D ?? ?? ?? ?? 0F 5B C0 0F 28 35 ?? ?? ?? ?? 66 0F 72 F3 1F 0F 59 E0 0F 59 E8 0F 59 F0 0F 59 F8 0F 28 05 ?? ?? ?? ?? 0F 5C D4 0F 5C D5 0F 5C D6 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 28 CA 0F 5C CF 0F 59 D2 0F 28 05 ?? ?? ?? ?? 0F 28 2D ?? ?? ?? ?? 0F 28 35 ?? ?? ?? ?? 0F 59 C2 0F 58 05 ?? ?? ?? ?? 0F 59 C2 0F 58 C5 0F 59 C2 0F 58 C6 0F 59 C2 0F 59 C1 0F 58 C1 66 0F EF C3 0F 29 84 24 00 01 00 00 89 44 24 20 8B 44 24 20 45 33 C9 A8 01 75 2F 49 FF C1 D1 F8 89 44 24 20 49 83 F9 04 7C ED 0F 28 84 24 00 01 00 00 0F 28 B4 24 20 01 00 00 0F 28 BC 24 10 01 00 00 48 81 C4 38 01 00 00 C3 42 8B 44 8C 40 48 8D 15 ?? ?? ?? ?? 89 44 24 28 48 89 54 24 30 F3 0F 10 44 24 28 4C 8B 44 24 30 F3 0F 10 C8 66 0F 7E C1 0F 5A C8 F2 41 0F 10 90 10 05 00 00 81 E1 FF FF FF 7F 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 0F 84 0F 01 00 00 C1 E9 17 81 E9 8E 00 00 00 81 E1 F8 FF 00 00 F2 41 0F 10 9C 48 10 04 00 00 F2 41 0F 10 AC 48 18 04 00 00 F2 41 0F 10 90 50 05 00 00 66 0F 57 E4 B8 38 43 00 00 66 0F C4 E0 03 66 0F 54 D3 66 0F 73 F3 28 F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 CD 66 0F 28 C2 F2 0F 58 D3 66 0F 28 EA F2 0F 5C C2 F2 0F 58 D4 F2 0F 58 D8 66 0F 7E D1 F2 0F 5C D4 F2 0F 58 CB B8 80 01 00 00 F2 41 0F 10 A0 40 05 00 00 F2 0F 5C EA 03 C9 8B D1 C1 E1 18 C1 F9 1F 23 C2 03 D1 33 D1 F2 0F 58 CD 81 E2 FE 00 00 00 F2 41 0F 10 1C D0 F2 41 0F 10 80 48 05 00 00 66 0F 70 D1 44 F2 0F 59 C9 F2 41 0F 10 6C D0 08 8B C8 81 C1 80 00 00 00 81 E1 00 01 00 00 C1 E1 17 F2 0F 59 DA 66 0F 6E D1 F2 0F 5C C1 25 00 01 00 00 C1 E0 17 F2 0F 5C E1 66 0F 73 F2 20 66 0F 6E C8 66 0F 57 E2 F2 0F 59 C5 F2 0F 59 DC 66 0F 73 F1 20 66 0F 57 C1 F2 0F 58 C3 66 0F 5A C0 EB 04 F3 0F 5C C0 F3 0F 11 44 24 24 8B 44 24 24 42 89 84 8C 00 01 00 00 8B 44 24 20 E9 55 FE FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "__avx_sinh4"
		size = 672
		refs = "000a __common_dsinh_data 0292 __common_dsinh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 F0 01 00 00 C5 7C 11 B4 24 D0 01 00 00 C5 7C 11 AC 24 70 01 00 00 C5 7C 11 A4 24 50 01 00 00 C5 FC 11 BC 24 B0 01 00 00 C5 FC 11 B4 24 90 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 EF 00 00 00 C5 7D 54 35 ?? ?? ?? ?? 49 83 E5 C0 C5 8D 57 F0 C5 7D 10 2D ?? ?? ?? ?? C5 CD 59 15 ?? ?? ?? ?? C5 F9 10 1D ?? ?? ?? ?? C4 C1 6D 58 E5 C4 E3 7D 19 F1 01 C5 C8 C6 E9 DD C5 D1 66 15 ?? ?? ?? ?? C5 78 50 C2 C5 59 DB FB C4 C1 5D 5C CD C5 79 7E F9 C5 75 59 2D ?? ?? ?? ?? C5 F5 59 0D ?? ?? ?? ?? C4 C1 4D 5C D5 C4 E3 7D 19 E5 01 C4 C1 59 EF E7 C5 D0 54 DB C4 C1 79 7E D9 C5 ED 5C D1 C1 E1 04 C4 63 79 16 F8 02 C5 81 73 F4 2D 41 C1 E1 04 C4 C3 79 16 DA 02 C5 D0 57 DB C5 D1 73 F3 2D C1 E0 04 41 C1 E2 04 C5 ED 59 CA C4 61 F9 6E 64 11 08 C4 C1 F9 6E 7C 11 08 C4 E1 F9 6E 34 11 C5 19 16 6C 10 08 C4 41 41 16 64 12 08 C5 C9 16 3C 10 C4 C1 41 D4 FF C4 C1 11 D4 DF C4 41 11 FB EF C5 99 D4 E5 C5 19 FB E5 C5 75 59 3D ?? ?? ?? ?? C4 C1 F9 6E 34 11 C4 C1 49 16 34 12 C5 C9 D4 F5 C4 E3 45 18 F6 01 C4 E3 65 18 FC 01 C5 85 58 1D ?? ?? ?? ?? C5 E5 59 E1 C4 C3 15 18 EC 01 C5 45 58 ED C5 45 5C E5 C5 F5 59 3D ?? ?? ?? ?? C5 DD 59 EA C4 C1 4D 58 DC C5 45 58 3D ?? ?? ?? ?? C5 D5 58 D2 C4 C1 4D 58 F5 C5 85 59 C9 C5 ED 59 D6 C5 F5 59 CB C5 ED 58 D1 C5 ED 58 E3 C5 8D 56 CC 45 85 C0 75 4A C5 FC 10 B4 24 90 01 00 00 C5 FC 10 BC 24 B0 01 00 00 C5 7C 10 A4 24 50 01 00 00 C5 7C 10 AC 24 70 01 00 00 C5 7C 10 B4 24 D0 01 00 00 C5 7C 10 BC 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 A8 33 C0 C5 7C 11 84 24 80 00 00 00 C5 7C 11 4C 24 60 C5 7C 11 54 24 40 C5 7C 11 5C 24 20 48 89 9C 24 A8 00 00 00 8B D8 48 89 B4 24 A0 00 00 00 41 8B F0 0F A3 DE 72 3D FF C3 83 FB 20 7C F4 C5 7C 10 84 24 80 00 00 00 C5 7C 10 4C 24 60 C5 7C 10 54 24 40 C5 7C 10 5C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 A8 00 00 00 48 8B B4 24 A0 00 00 00 E9 34 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB AF 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__common_dtan_cout_rare"
		size = 128
		refs = "004e _vmldTanHATab"
	strings:
		$1 = { 48 83 EC 28 33 C0 4C 8B 01 4C 89 44 24 20 49 C1 E8 38 44 0F B7 49 06 41 81 E1 F0 7F 00 00 41 83 E0 7F F2 0F 10 09 41 81 F9 F0 7F 00 00 44 88 44 24 27 74 05 48 83 C4 28 C3 83 7C 24 20 00 75 24 81 7C 24 24 00 00 F0 7F 75 1A F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 59 C8 F2 0F 11 0A 48 83 C4 28 C3 F2 0F 59 C9 F2 0F 11 0A 48 83 C4 28 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__avx_cos4"
		size = 2192
		refs = "000a __common_dcos_reduction_data 007f __common_dcos_data 023a __common_dcos_cout_rare 0244 __common_dcos_data_ha 029b _2il0floatpacket_267 02db _2il0floatpacket_268 0331 _2il0floatpacket_269 05ac _2il0floatpacket_270 05ce _2il0floatpacket_272 05d6 _2il0floatpacket_273 05e5 _2il0floatpacket_271 0611 _2il0floatpacket_274 0636 _2il0floatpacket_276 066c _2il0floatpacket_275 06d3 _2il0floatpacket_280 06e6 _2il0floatpacket_277 06ef _2il0floatpacket_278 06f8 _2il0floatpacket_279 0755 _2il0floatpacket_281 0763 _2il0floatpacket_282"
	strings:
		$1 = { 48 81 EC B8 02 00 00 4C 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 90 02 00 00 45 33 DB C5 7C 11 B4 24 70 02 00 00 C5 7C 11 AC 24 50 02 00 00 C5 7C 11 A4 24 30 02 00 00 C5 7C 11 9C 24 10 02 00 00 C5 7C 11 94 24 F0 01 00 00 C5 7C 11 8C 24 D0 01 00 00 C5 7C 11 84 24 B0 01 00 00 C5 FC 11 BC 24 90 01 00 00 C5 FC 11 B4 24 70 01 00 00 4C 89 AC 24 B0 02 00 00 4C 8D AC 24 0F 01 00 00 C5 FD 58 25 ?? ?? ?? ?? 49 83 E5 C0 C5 DD 54 2D ?? ?? ?? ?? C5 D5 C2 0D ?? ?? ?? ?? 1E C4 E3 7D 19 CA 01 C5 F0 C6 DA DD C5 F8 50 C3 85 C0 0F 85 91 01 00 00 C5 FD 10 1D ?? ?? ?? ?? C5 DD 59 25 ?? ?? ?? ?? C5 DD 58 F3 C5 CD 5C EB C5 55 5C 3D ?? ?? ?? ?? C5 05 59 15 ?? ?? ?? ?? C5 05 59 25 ?? ?? ?? ?? C5 05 59 35 ?? ?? ?? ?? C5 85 59 1D ?? ?? ?? ?? C4 41 7D 5C DA C4 41 25 5C EC C4 C1 15 5C CE C5 F5 5C CB C5 F5 59 D9 C5 E5 59 25 ?? ?? ?? ?? C5 DD 58 2D ?? ?? ?? ?? C5 C1 73 F6 3F C4 C3 7D 19 F0 01 C5 D5 59 F3 C4 C1 31 73 F0 3F C4 C3 45 18 D1 01 C5 CD 58 3D ?? ?? ?? ?? C5 45 59 C3 C5 3D 58 0D ?? ?? ?? ?? C5 35 59 D3 C5 2D 58 1D ?? ?? ?? ?? C5 25 59 E3 C5 1D 58 2D ?? ?? ?? ?? C5 15 59 F3 C5 0D 58 3D ?? ?? ?? ?? C5 85 59 E3 C5 DD 59 E9 C5 D5 58 C9 C5 F5 57 CA 45 85 DB 75 6E C5 FC 10 B4 24 70 01 00 00 C5 FC 10 BC 24 90 01 00 00 C5 7C 10 84 24 B0 01 00 00 C5 7C 10 8C 24 D0 01 00 00 C5 7C 10 94 24 F0 01 00 00 C5 7C 10 9C 24 10 02 00 00 C5 7C 10 A4 24 30 02 00 00 C5 7C 10 AC 24 50 02 00 00 C5 7C 10 B4 24 70 02 00 00 C5 7C 10 BC 24 90 02 00 00 4C 8B AC 24 B0 02 00 00 C5 FD 28 C1 48 81 C4 B8 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 84 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 41 8B F3 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 4D 40 E9 52 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 C5 FD 10 25 ?? ?? ?? ?? BA 00 00 F0 7F C4 C1 7D 11 45 00 C5 F9 6E CA C5 79 70 C1 11 C5 5D 54 DD C5 25 C2 CC 00 C4 43 7D 19 CF 01 C4 41 30 C6 EF DD C4 41 78 50 DD C5 B9 DB F8 C4 C3 7D 19 C5 01 C5 A9 73 D7 34 C4 C1 39 DB D5 C5 E1 73 D2 34 C5 F9 7E D9 C5 79 7E D0 C5 7A 6F 05 ?? ?? ?? ?? C5 F8 11 44 24 20 C5 B9 DB C0 C4 E3 79 16 DA 02 8D 0C 49 C4 43 79 16 D0 02 44 8D 0C 40 C1 E1 03 41 C1 E1 03 8D 04 52 C1 E0 03 47 8D 04 40 41 C1 E0 03 C4 21 F9 6E 1C 11 C5 FA 6F 15 ?? ?? ?? ?? C4 21 21 16 14 10 C4 A1 F9 6E 7C 11 10 C5 79 D4 DA C4 C1 39 DB C5 C4 01 F9 6E 24 11 C4 81 F9 6E 74 11 08 C4 A1 41 16 5C 10 10 C5 F9 D4 FA C5 78 11 6C 24 30 C4 01 19 16 34 10 C4 01 49 16 4C 10 08 C4 01 F9 6E 7C 11 10 C4 C1 19 73 D1 20 C5 7A 6F 2D ?? ?? ?? ?? C4 A1 F9 6E 6C 11 08 C4 C1 31 DB F5 C5 79 11 74 24 40 C4 C1 31 73 D3 20 C4 81 01 16 4C 10 10 C4 41 09 DB FD C4 41 29 DB F5 C4 41 21 DB C5 C4 41 41 DB DD C5 E9 73 D1 20 C4 A1 51 16 64 10 08 4C 8D 15 ?? ?? ?? ?? C4 C1 71 DB CD C5 7A 7F 74 24 70 C4 C1 59 DB C5 C4 41 21 F4 F6 C5 D1 73 D4 20 C5 79 11 54 24 50 C5 A9 73 D7 20 C5 FA 7F 84 24 A0 00 00 00 C5 D9 73 D3 20 C5 A1 F4 F8 C4 C1 61 DB DD C5 B1 F4 C1 C5 B1 F4 CA C5 B9 F4 D2 C5 FA 7F AC 24 90 00 00 00 C5 E9 73 D2 20 C5 7A 7F B4 24 C0 00 00 00 41 B8 00 00 00 80 C5 7A 7F 7C 24 60 C5 F1 D4 CA C5 21 F4 F5 C5 B9 F4 EE C4 41 39 F4 FF C5 B1 F4 F6 C5 7A 7F BC 24 B0 00 00 00 C5 81 73 D0 20 C4 C1 51 DB C5 C5 D1 73 D5 20 C5 F9 D4 C1 C5 81 D4 D0 C5 A9 F4 C3 C5 81 73 D0 20 C4 C1 41 DB DD C5 A9 F4 C4 C5 C1 73 D7 20 C5 A1 F4 E4 C5 D9 73 D4 20 C5 7A 7F A4 24 80 00 00 00 C4 41 39 F4 E4 C5 F9 D4 C4 C5 E1 D4 C8 C5 C9 D4 C5 C5 81 D4 E1 C4 41 19 DB FD C5 F1 73 D2 20 C5 01 D4 F8 C4 41 71 D4 FF C5 A9 F4 8C 24 A0 00 00 00 C5 F1 D4 EF C5 B1 F4 8C 24 80 00 00 00 C5 31 F4 4C 24 60 C4 C1 09 DB F5 C5 E1 73 D4 20 C5 C9 D4 C5 C5 A9 F4 AC 24 90 00 00 00 C5 29 F4 54 24 70 C5 E1 D4 F8 C4 C1 19 73 D4 20 C4 C1 49 73 D7 20 C5 FA 6F 9C 24 B0 00 00 00 C4 C1 09 73 D6 20 C4 C1 71 D4 CC C4 41 51 D4 F6 C4 C1 61 DB C5 C5 E1 73 D3 20 C5 F9 D4 C1 C5 31 D4 CB C5 C9 D4 F0 C5 FA 6F 84 24 C0 00 00 00 C5 99 73 D7 20 C5 F9 10 6C 24 40 C4 C1 79 DB CD C4 C1 71 D4 CE C5 89 73 D5 20 C5 F9 73 D0 20 C4 41 39 F4 C6 C4 C1 01 73 F7 20 C5 99 D4 C9 C5 29 D4 D0 C4 41 39 DB C5 C5 99 73 D6 20 C4 41 39 D4 C1 C5 F9 10 6C 24 50 C5 B1 73 D1 20 C4 41 19 D4 E0 C5 B9 73 D5 20 C4 C1 09 73 F4 20 C4 41 21 F4 D8 C4 C1 79 6E C0 C4 41 21 DB C5 C4 C1 49 DB F5 C4 41 39 D4 E2 C5 89 D4 F6 C4 41 31 D4 CC C4 C1 61 73 F1 20 C4 C1 71 DB CD C4 C1 69 DB D5 C5 C1 73 F7 20 C4 41 59 DB ED C5 B1 73 D6 0C C5 F9 70 E0 11 C5 61 D4 C1 C5 01 D4 D2 C4 C1 41 D4 D5 C5 D9 DB 7C 24 20 C4 C1 61 73 D0 0C C5 7A 6F 25 ?? ?? ?? ?? C5 D9 DB 4C 24 30 C4 41 41 EF FC C4 41 71 EF F4 C4 41 31 EB EF C4 41 61 EB DE C5 F8 10 1D ?? ?? ?? ?? C5 7A 6F 35 ?? ?? ?? ?? C4 C3 15 18 C3 01 C4 E2 7D 1A 2D ?? ?? ?? ?? C5 55 58 C8 C5 B5 5C E5 C4 C1 71 EF EE C5 7D 5C FC C4 C1 41 EF E6 C5 31 DB EB C4 43 7D 19 CC 01 C5 18 54 CB C5 FA 6F 1D ?? ?? ?? ?? C4 41 61 DB DA C5 61 DB F2 C4 C1 79 73 F3 1C C4 C1 21 73 F6 1C C5 79 EB E4 C5 A1 EB C5 C5 7A 6F 1D ?? ?? ?? ?? C5 79 7E EA C4 41 79 7E C9 C1 E2 05 C4 63 79 16 E8 02 41 C1 E1 05 C4 63 79 16 C9 02 C1 E0 05 C1 E1 05 C4 E3 1D 18 D8 01 C4 E3 5D 18 ED 01 C5 FA 6F 05 ?? ?? ?? ?? C5 65 5C E5 C5 F1 EF D8 C5 A1 DB CE C5 41 EF F0 C5 C1 73 F1 28 C4 C1 49 73 D2 18 C4 C1 21 DB C8 C5 C1 EB C6 C5 C1 73 F1 28 C5 B9 73 D2 18 C4 C1 41 EB D0 C4 C1 79 EB E6 C5 69 EB D3 C4 C3 5D 18 EA 01 C4 E3 0D 18 DB 01 C5 D5 5C F3 C5 85 58 C6 C5 05 5C F8 C4 41 4D 58 DF C4 C1 25 58 FC C4 62 7D 1A 25 ?? ?? ?? ?? C4 41 7D 54 FC C4 C1 7D 5C D7 C4 E2 7D 1A 0D ?? ?? ?? ?? C4 E2 7D 1A 25 ?? ?? ?? ?? C4 62 7D 1A 05 ?? ?? ?? ?? C5 5D 59 D2 C4 C1 3D 59 DF C5 F5 59 EF C5 BD 59 F2 C4 C1 5D 59 C7 C5 2D 58 DB C5 55 58 E6 C4 C1 25 58 E4 C4 21 F9 6E 1C 12 C4 21 21 16 2C 10 C5 FD 58 D4 C5 7D 5C F2 C4 C1 7D 10 45 00 C5 8D 58 F4 C4 81 F9 6E 24 11 C4 21 59 16 0C 11 C4 A1 F9 6E 64 12 10 C4 62 7D 1A 3D ?? ?? ?? ?? C4 C1 7D 54 CF C4 E2 7D 1A 3D ?? ?? ?? ?? C5 F5 C2 EF 1E C5 75 C2 C7 12 C5 3D 54 D0 C5 D5 54 DA C4 21 F9 6E 44 12 08 C5 AD 56 CB C4 81 F9 6E 5C 11 08 C4 21 39 16 54 10 08 C5 55 54 FE C4 A1 61 16 6C 11 08 C4 63 2D 18 D5 01 C4 41 75 59 DA C4 C3 15 18 D1 01 C4 01 F9 6E 6C 11 10 C4 21 59 16 4C 10 10 C4 A1 11 16 7C 11 10 C4 E3 35 18 FF 01 C5 6D 59 C9 C4 41 45 58 E3 C4 C1 35 58 E4 C4 C1 45 5C F4 C5 1D 5C F4 C4 41 4D 58 C3 C4 41 0D 58 E9 C4 41 15 58 E0 C4 41 6D 58 EA C5 75 59 C1 C5 BD 59 1D ?? ?? ?? ?? C5 3D 59 0D ?? ?? ?? ?? C5 E5 58 2D ?? ?? ?? ?? C4 C1 55 59 F0 C5 4D 59 D9 C5 F5 59 CF C4 C1 25 59 D5 C4 41 6D 58 D4 C5 B5 58 15 ?? ?? ?? ?? C4 C1 6D 59 D8 C5 E5 58 2D ?? ?? ?? ?? C4 81 F9 6E 5C 11 18 C4 41 55 59 C0 C4 A1 61 16 6C 11 18 C5 BD 59 F7 C4 41 4D 58 CA C5 95 5C F1 C4 A1 F9 6E 4C 12 18 C4 A1 71 16 54 10 18 C5 05 59 FE C4 E3 6D 18 FD 01 C5 85 58 CF C5 B5 58 D1 C5 DD 58 CA E9 F4 F8 FF FF 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "__isa_available_init"
		size = 454
		refs = "001c __isa_enabled 002b __isa_available 005d __favor 009e __memcpy_nt_iters"
	strings:
		$1 = { 48 89 5C 24 10 48 89 7C 24 18 55 48 8B EC 48 83 EC 20 83 65 E8 00 33 C9 33 C0 C7 05 ?? ?? ?? ?? 02 00 00 00 0F A2 44 8B C1 C7 05 ?? ?? ?? ?? 01 00 00 00 81 F1 63 41 4D 44 44 8B CA 44 8B D2 41 81 F1 65 6E 74 69 41 81 F2 69 6E 65 49 41 81 F0 6E 74 65 6C 45 0B D0 44 8B DB 44 8B 05 ?? ?? ?? ?? 41 81 F3 41 75 74 68 45 0B D9 8B D3 44 0B D9 81 F2 47 65 6E 75 33 C9 8B F8 44 0B D2 B8 01 00 00 00 0F A2 89 45 F0 44 8B C9 44 89 4D F8 8B C8 89 5D F4 89 55 FC 45 85 D2 75 52 48 83 0D ?? ?? ?? ?? FF 41 83 C8 04 25 F0 3F FF 0F 44 89 05 ?? ?? ?? ?? 3D C0 06 01 00 74 28 3D 60 06 02 00 74 21 3D 70 06 02 00 74 1A 05 B0 F9 FC FF 83 F8 20 77 1B 48 BB 01 00 01 00 01 00 00 00 48 0F A3 C3 73 0B 41 83 C8 01 44 89 05 ?? ?? ?? ?? 45 85 DB 75 19 81 E1 00 0F F0 0F 81 F9 00 0F 60 00 72 0B 41 83 C8 04 44 89 05 ?? ?? ?? ?? B8 07 00 00 00 89 55 E0 44 89 4D E4 3B F8 7C 24 33 C9 0F A2 89 45 F0 89 5D F4 89 4D F8 89 55 FC 89 5D E8 0F BA E3 09 73 0B 41 83 C8 02 44 89 05 ?? ?? ?? ?? 41 0F BA E1 14 73 6E C7 05 ?? ?? ?? ?? 02 00 00 00 C7 05 ?? ?? ?? ?? 06 00 00 00 41 0F BA E1 1B 73 53 41 0F BA E1 1C 73 4C 33 C9 0F 01 D0 48 C1 E2 20 48 0B D0 48 89 55 10 48 8B 45 10 24 06 3C 06 75 32 8B 05 ?? ?? ?? ?? 83 C8 08 C7 05 ?? ?? ?? ?? 03 00 00 00 F6 45 E8 20 89 05 ?? ?? ?? ?? 74 13 83 C8 20 C7 05 ?? ?? ?? ?? 05 00 00 00 89 05 ?? ?? ?? ?? 48 8B 5C 24 38 33 C0 48 8B 7C 24 40 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "__common_trig_reduction"
		size = 1328
		refs = "003b _zero_none 006b _PI02_INV 0072 _PIO2_21x5 00c0 _PI04_INV 00c7 _PI04_21x5 017e _PIO2_25x2 0185 _DDP 01ad _PI04_25x2 01b4 _DP 02ba _2il0floatpacket_3 044b _TWO_26H 04ec _PI04 04f9 _PI02"
	strings:
		$1 = { 41 55 41 56 41 57 48 83 EC 50 4C 8B EA F2 0F 11 44 24 70 0F B7 44 24 76 8B C8 81 E1 F0 7F 00 00 C1 E9 04 44 0F 29 4C 24 30 81 F9 FF 07 00 00 44 0F 29 44 24 40 7C 19 F2 0F 10 0D ?? ?? ?? ?? 33 C0 F2 0F 59 C1 F2 41 0F 11 45 00 E9 BB 04 00 00 81 F9 1D 04 00 00 0F 8D 17 01 00 00 F2 0F 10 54 24 70 45 85 C0 75 25 F2 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 2C C0 FF C0 83 E0 FE F2 0F 2A C8 C1 E0 1E EB 52 41 83 F8 01 75 2A F2 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 2C C0 83 C8 01 F2 0F 2A C8 C1 E0 1E F7 D0 25 00 00 00 80 EB 22 F2 0F 10 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 0F 59 C2 F2 0F 2C C0 FF C0 83 E0 FE F2 0F 2A C8 D1 F8 F2 0F 10 19 F2 0F 59 D9 F2 0F 10 61 08 F2 0F 5C D3 F2 0F 59 E1 44 0F 28 C2 F2 0F 10 69 10 F2 44 0F 5C C4 F2 0F 59 E9 F2 41 0F 5C D0 41 0F 28 C0 F2 0F 5C D4 F2 0F 5C C5 44 0F 28 C8 F2 44 0F 5C C0 F2 44 0F 5C C5 F2 41 0F 58 D0 F2 44 0F 58 CA 41 0F 28 D9 F2 41 0F 5C C1 F2 0F 58 C2 F2 0F 10 51 18 F2 0F 59 D1 F2 0F 5C DA F2 44 0F 5C CB F2 44 0F 5C CA F2 0F 10 51 20 F2 0F 59 CA F2 41 0F 58 C1 F2 0F 5C C1 F2 0F 58 D8 F2 41 0F 11 5D 00 E9 98 03 00 00 45 85 C0 75 13 45 33 DB 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? EB 2D 41 83 F8 01 75 16 41 BB 01 00 00 00 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? EB 11 45 33 DB 4C 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 25 0F 80 FF FF 44 8D B1 38 FF FF FF 41 81 E6 FF 07 00 00 44 8D B9 E4 FB FF FF 41 C1 E6 04 41 0B C6 66 89 44 24 76 B8 1F 85 EB 51 41 F7 EF 41 C1 FF 1F C1 FA 03 41 2B D7 6B C2 E7 F2 44 0F 10 44 24 70 81 64 24 70 00 00 00 F8 8D 8C 01 E4 FB FF FF F2 0F 10 6C 24 70 83 F9 11 F2 44 0F 5C C5 7C 4B 48 63 D2 F2 45 0F 10 4C D1 08 F2 41 0F 10 04 D1 FF C2 F2 44 0F 59 CD F2 41 0F 59 C0 41 0F 28 D1 F2 0F 58 D0 F2 0F 5C C2 F2 44 0F 58 C8 41 0F 28 C9 F2 0F 58 CA F2 0F 11 4C 24 20 81 64 24 20 00 00 F0 FF F2 0F 5C 54 24 20 EB 0D F2 44 0F 10 0D ?? ?? ?? ?? 41 0F 28 D1 48 63 D2 0F 28 DA F2 41 0F 10 0C D1 F2 41 0F 59 C8 F2 0F 58 D9 0F 28 C3 F2 0F 5C D3 F2 0F 58 CA F2 41 0F 10 54 D1 08 F2 44 0F 58 C9 0F 28 CD F2 0F 59 CA F2 41 0F 59 D0 F2 0F 58 C1 0F 28 E0 F2 0F 5C E3 0F 28 DD 0F 57 25 ?? ?? ?? ?? F2 0F 58 CC F2 41 0F 10 64 D1 10 F2 0F 59 DC F2 41 0F 59 E0 F2 44 0F 58 C9 0F 28 C8 F2 41 0F 58 C9 F2 0F 58 CA F2 0F 58 CB F2 0F 11 4C 24 20 0F B7 44 24 26 25 F0 7F 00 00 C1 E8 04 F7 D8 66 49 0F 7E CF 41 0F 28 C9 8D 88 33 04 00 00 05 F4 03 00 00 C1 F8 1F 48 63 C0 4C 8B F0 49 F7 D6 4D 0B FE 49 D3 FF 45 8B F7 4C 23 F8 49 D3 E7 4C 89 7C 24 20 4C 8D 3D ?? ?? ?? ?? F2 0F 5C 44 24 20 F2 0F 58 C8 43 8D 0C 1E 83 E1 01 43 8D 44 1E 01 41 83 F8 01 F2 0F 5C C1 F2 44 0F 58 C8 F2 41 0F 10 04 CF F2 0F 58 C8 0F 28 C1 F2 0F 58 C2 F2 0F 5C C8 F2 0F 58 D1 0F 28 C8 F2 0F 58 CB F2 44 0F 58 CA F2 0F 5C C1 0F 28 D1 F2 0F 58 D8 F2 0F 58 D4 F2 44 0F 58 CB F2 0F 5C CA F2 41 0F 10 44 D1 18 0F 28 DD F2 0F 59 D8 F2 0F 58 E1 F2 41 0F 59 C0 F2 44 0F 58 CC 0F 28 E2 F2 0F 58 E3 0F 28 CC F2 0F 5C D4 F2 0F 58 C8 F2 0F 58 DA F2 0F 5C E1 F2 44 0F 58 CB F2 0F 58 C4 0F 28 D5 0F 28 E1 F2 44 0F 58 C8 F2 41 0F 10 44 D1 20 F2 0F 59 D0 F2 41 0F 59 C0 F2 0F 58 E2 0F 28 DC F2 0F 5C CC F2 0F 58 D1 0F 28 CD F2 44 0F 58 CA F2 41 0F 10 54 D1 28 F2 0F 59 CA F2 41 0F 59 D0 F2 0F 58 C1 F2 0F 58 D8 F2 0F 5C E3 F2 0F 58 C4 0F 28 E5 F2 44 0F 58 C8 F2 41 0F 10 44 D1 30 F2 0F 59 E0 F2 44 0F 59 C0 F2 0F 58 D4 0F 28 E3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 E2 F2 0F 5C DC F2 0F 58 D3 F2 44 0F 58 CA F2 41 0F 10 54 D1 38 F2 0F 59 EA F2 44 0F 58 C5 41 0F 28 E8 F2 0F 58 EC F2 0F 59 C5 F2 0F 58 E8 F2 0F 11 6C 24 28 F2 0F 10 4C 24 28 F2 0F 5C C8 F2 0F 5C E1 F2 44 0F 58 C4 F2 45 0F 58 C8 F2 45 0F 10 02 41 0F 28 C0 F2 41 0F 59 C1 F2 44 0F 58 C9 F2 41 0F 59 C8 F2 45 0F 59 4A 08 F2 41 0F 58 C1 0F 28 D0 F2 0F 58 D1 F2 0F 5C CA F2 0F 58 C8 F2 0F 58 D1 7F 10 C1 E0 1E F2 41 0F 11 55 00 25 00 00 00 80 EB 25 D1 F8 66 0F 2F 15 ?? ?? ?? ?? 76 13 83 C0 FD F2 0F 5C 15 ?? ?? ?? ?? F2 41 0F 11 55 00 EB 06 F2 41 0F 11 55 00 44 0F 28 44 24 40 44 0F 28 4C 24 30 48 83 C4 50 41 5F 41 5E 41 5D C3 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "_FindPESection"
		size = 68
	strings:
		$1 = { 4C 63 41 3C 45 33 C9 4C 03 C1 4C 8B D2 41 0F B7 40 14 45 0F B7 58 06 48 83 C0 18 49 03 C0 45 85 DB 74 1E 8B 50 0C 4C 3B D2 72 0A 8B 48 08 03 CA 4C 3B D1 72 0E 41 FF C1 48 83 C0 28 45 3B CB 72 E2 33 C0 C3 }
	condition:
		$1
}

rule file_300_1_0 {
	meta:
		name = "_IsNonwritableInCurrentImage"
		size = 77
		refs = "0010 __ImageBase 0018 _ValidateImageBase 002a _FindPESection"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B D9 48 8D 3D ?? ?? ?? ?? 48 8B CF E8 ?? ?? ?? ?? 85 C0 74 22 48 2B DF 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 48 85 C0 74 0F 8B 40 24 C1 E8 1F F7 D0 83 E0 01 EB 02 33 C0 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_300_2_0 {
	meta:
		name = "_IsNonwritableInCurrentImage$filt$0"
		size = 32
		altNames = "__RTCastToVoid$filt$0 __RTtypeid$filt$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 01 33 C9 81 38 05 00 00 C0 0F 94 C1 8B C1 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_300_3_0 {
	meta:
		name = "_ValidateImageBase"
		size = 46
	strings:
		$1 = { 48 8B C1 B9 4D 5A 00 00 66 39 08 74 03 33 C0 C3 48 63 48 3C 48 03 C8 33 C0 81 39 50 45 00 00 75 0C BA 0B 02 00 00 66 39 51 18 0F 94 C0 C3 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__GSHandlerCheck"
		size = 29
		refs = "000f __GSHandlerCheckCommon"
	strings:
		$1 = { 48 83 EC 28 4D 8B 41 38 48 8B CA 49 8B D1 E8 ?? ?? ?? ?? B8 01 00 00 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_313_1_0 {
	meta:
		name = "__GSHandlerCheckCommon"
		size = 89
		refs = "0055 __security_check_cookie"
	strings:
		$1 = { 40 53 45 8B 18 48 8B DA 41 83 E3 F8 4C 8B C9 41 F6 00 04 4C 8B D1 74 13 41 8B 40 08 4D 63 50 04 F7 D8 4C 03 D1 48 63 C8 4C 23 D1 49 63 C3 4A 8B 14 10 48 8B 43 10 8B 48 08 48 03 4B 08 F6 41 03 0F 74 0A 0F B6 41 03 83 E0 F0 4C 03 C8 4C 33 CA 49 8B C9 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "??__C@YAXPEAX0_K1P6AX00@ZP6AX0@Z@Z"
		size = 117
		refs = "0039 _guard_check_icall"
	strings:
		$1 = { 48 8B C4 4C 89 40 18 48 89 48 08 53 56 57 41 56 41 57 48 83 EC 30 4D 8B F9 4D 8B F0 48 8B F2 48 8B F9 33 DB 48 89 58 D0 88 58 C8 49 3B DF 74 34 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B D6 48 8B CF FF 94 24 80 00 00 00 49 03 FE 48 89 7C 24 60 49 03 F6 48 89 74 24 68 48 FF C3 48 89 5C 24 28 EB C7 C6 44 24 20 01 48 83 C4 30 41 5F 41 5E 5F 5E 5B C3 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "__sse2_floor2"
		size = 80
		refs = "0006 _2il0floatpacket_4 0010 _2il0floatpacket_5 0038 _2il0floatpacket_6"
	strings:
		$1 = { 0F 28 E0 0F 28 1D ?? ?? ?? ?? 0F 28 E8 0F 28 0D ?? ?? ?? ?? 0F 28 D3 0F 54 E1 0F 55 C8 66 0F C2 D1 01 66 0F 58 CB 66 0F 5C CB 0F 56 CC 0F 28 DA 66 0F C2 E9 01 0F 54 2D ?? ?? ?? ?? 0F 54 C2 66 0F 5C CD 0F 55 D9 0F 56 C3 C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "__common_sacos_cout_rare"
		size = 2672
		refs = "0072 _vmldACosHATab 09d7 _2il0floatpacket_192"
	strings:
		$1 = { 55 48 81 EC D0 00 00 00 48 8D 6C 24 20 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 F3 0F 10 09 41 81 F8 80 7F 00 00 44 0F 29 7D 60 44 0F 29 75 70 44 0F 29 A5 80 00 00 00 44 0F 29 95 90 00 00 00 44 0F 29 45 30 0F 29 7D 40 0F 29 75 50 48 89 9D A0 00 00 00 0F 84 FA 09 00 00 F3 0F 5A C1 F2 0F 11 45 18 80 65 1F 7F F2 44 0F 10 45 18 F2 44 0F 10 25 ?? ?? ?? ?? 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F E0 0F 86 42 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C0 0F 86 F7 03 00 00 66 44 0F 2F 05 ?? ?? ?? ?? 0F 86 9B 03 00 00 F2 44 0F 10 25 ?? ?? ?? ?? 41 0F 28 C0 F2 41 0F 59 C4 41 0F 28 D0 F2 0F 11 45 10 45 0F 28 F8 F2 0F 10 65 10 41 0F 28 DC F2 0F 10 3D ?? ?? ?? ?? F2 0F 5C 65 18 F2 0F 11 65 08 F2 0F 10 4D 10 F2 44 0F 10 55 08 F2 41 0F 5C CA F2 0F 11 4D 10 F2 0F 10 75 10 F2 0F 5C D6 F2 0F 11 55 08 F2 0F 10 6D 10 0F 28 D5 F2 44 0F 58 FD F2 0F 59 D5 F2 44 0F 10 75 08 0F 28 C2 F2 45 0F 59 FE F2 0F 59 DA F2 41 0F 58 C7 F2 0F 59 F8 F2 0F 11 5D 10 F2 0F 10 65 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C E2 F2 0F 59 F8 F2 0F 11 65 08 F2 0F 10 4D 10 F2 44 0F 10 55 08 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 5C CA F2 0F 59 F8 F2 0F 11 4D 10 F2 0F 10 75 10 F2 0F 58 3D ?? ?? ?? ?? F2 0F 5C D6 F2 0F 59 F8 F2 0F 11 55 08 41 0F 28 F0 F2 0F 10 65 10 F2 0F 10 5D 08 F2 44 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 FB F2 0F 59 EC F2 0F 59 F8 F2 41 0F 59 F7 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 58 F6 F2 0F 59 F8 45 0F 28 F4 F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F5 F2 0F 59 F8 F2 44 0F 11 75 10 F2 44 0F 10 55 10 F2 44 0F 5C D5 F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 11 55 08 44 0F 28 D5 F2 0F 10 55 10 F2 0F 58 EE F2 0F 59 F8 F2 44 0F 59 FD F2 0F 58 3D ?? ?? ?? ?? F2 0F 10 4D 08 F2 0F 59 F8 F2 0F 5C D1 F2 0F 11 55 10 F2 0F 10 5D 10 F2 44 0F 5C D3 0F 28 DC F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 11 55 08 F2 0F 10 4D 10 F2 0F 10 55 08 44 0F 28 F2 F2 0F 59 D9 F2 44 0F 58 F6 F2 0F 59 F8 F2 41 0F 59 E6 F2 44 0F 59 E3 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 58 E7 F2 0F 59 F8 F2 44 0F 11 65 10 44 0F 28 F3 F2 44 0F 10 65 10 F2 44 0F 5C E3 F2 0F 58 DC F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 C3 F2 0F 59 F8 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 C5 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 EB F2 44 0F 11 65 08 F2 0F 58 C5 F2 44 0F 10 65 10 F2 0F 58 C7 F2 0F 10 3D ?? ?? ?? ?? F2 0F 59 F7 F2 0F 59 D7 F2 0F 59 CF F2 0F 58 C6 F2 44 0F 10 7D 08 F2 0F 58 C2 F2 45 0F 5C E7 F2 44 0F 11 65 10 41 0F 28 D0 F2 44 0F 10 55 10 F2 0F 58 D1 F2 45 0F 5C F2 F2 44 0F 11 75 08 F2 44 0F 10 65 10 F2 44 0F 10 55 08 F2 0F 11 55 10 F2 0F 10 5D 10 F2 0F 11 4D 00 F2 44 0F 5C C3 F2 44 0F 58 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 E1 F2 44 0F 59 E1 F2 41 0F 59 CA F2 44 0F 11 45 08 F2 0F 10 55 10 F2 44 0F 10 45 08 F2 41 0F 58 C0 F2 0F 58 C4 0F 28 E2 F2 41 0F 58 E4 F2 0F 58 C1 F2 0F 11 65 10 F2 44 0F 10 45 10 F2 41 0F 5C D0 F2 41 0F 58 D4 F2 0F 11 55 08 F3 0F 5A 29 F2 0F 10 65 10 F2 0F 10 5D 08 66 0F 2F 2D ?? ?? ?? ?? F2 0F 58 C3 76 42 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CB F2 0F 5C CC F2 0F 11 4D 10 F2 0F 10 55 10 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C DA F2 0F 5C C8 F2 0F 5C DC F2 0F 11 5D 08 F2 0F 10 55 10 F2 0F 10 65 08 F2 0F 58 CC EB 40 F2 0F 10 1D ?? ?? ?? ?? 0F 28 CC F2 0F 58 CB F2 0F 11 4D 10 F2 0F 10 55 10 F2 0F 5C DA F2 0F 58 DC F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 C4 F2 0F 11 5D 08 F2 0F 10 55 10 F2 0F 10 4D 08 F2 0F 58 C8 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 E9 B0 05 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 45 0F 58 E0 F2 44 0F 11 65 10 F2 0F 10 45 10 F2 0F 59 45 18 F2 0F 11 45 00 8A 5D 07 8A 49 03 80 E3 7F 80 E1 80 0A D9 88 5D 07 F2 0F 5C 4D 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5A C9 F3 0F 11 0A E9 63 05 00 00 4D 8B D1 F2 45 0F 5C E0 F2 41 0F 59 C4 F2 0F 11 45 00 44 0F B7 45 06 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B D8 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4D 18 45 0B D3 66 44 89 55 1E 83 E3 01 F2 0F 10 75 18 44 8B DB F2 0F 59 C6 0F 28 E8 F2 44 0F 10 05 ?? ?? ?? ?? F2 0F 58 E8 75 03 0F 28 E8 F2 44 0F 59 C5 44 2B C3 F2 0F 10 1D ?? ?? ?? ?? 41 0F 28 F8 41 C1 E3 08 44 0F 28 D5 41 D1 E8 F2 0F 58 C3 F2 0F 5C FD F2 0F 11 45 20 41 81 C0 FF 03 00 00 44 8B 55 20 41 81 E0 FF 07 00 00 41 81 E2 FF 01 00 00 F2 0F 11 7D 08 45 03 D3 F2 0F 10 75 08 4C 8D 1D ?? ?? ?? ?? F2 44 0F 5C C6 F2 47 0F 10 3C D3 41 0F 28 E0 4C 89 4D 28 41 0F 28 D7 49 C1 E9 30 F2 45 0F 5C D0 F2 45 0F 59 C7 F2 41 0F 59 D7 41 C1 E0 04 41 81 E1 0F 80 FF FF 45 0B C8 66 44 89 4D 2E F2 44 0F 10 75 28 F2 45 0F 59 C6 F2 0F 59 E2 F2 41 0F 59 D2 F2 0F 5C 25 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 E2 0F 28 C1 F2 41 0F 59 C0 F2 0F 11 45 10 F2 0F 10 7D 10 F2 0F 10 35 ?? ?? ?? ?? F2 41 0F 5C F8 F2 0F 59 F4 F2 0F 11 7D 08 F2 0F 10 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 58 35 ?? ?? ?? ?? F2 0F 59 F4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 41 0F 59 F7 F2 45 0F 59 FA F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F5 F2 41 0F 59 FC F2 41 0F 58 F7 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 F6 F2 41 0F 59 FC F2 0F 10 55 10 F2 0F 10 5D 08 F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 5C D3 F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 15 ?? ?? ?? ?? F2 41 0F 59 FC F2 45 0F 59 D4 F2 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 FC F2 0F 11 55 10 0F 28 D1 F2 0F 10 65 10 F2 0F 10 1D ?? ?? ?? ?? F2 44 0F 5C C4 F2 41 0F 59 D4 F2 0F 58 3D ?? ?? ?? ?? 44 0F 28 FB F2 44 0F 11 45 08 F2 44 0F 10 45 10 F2 0F 10 6D 08 F2 0F 11 55 10 F2 0F 58 F5 F2 41 0F 59 FC F2 44 0F 58 3D ?? ?? ?? ?? F2 0F 10 65 10 F2 45 0F 58 FA F2 41 0F 59 FC F2 41 0F 5C E4 F2 45 0F 59 FC F2 41 0F 59 FC F2 0F 10 05 ?? ?? ?? ?? 45 0F 28 D4 44 0F 28 F0 F2 0F 11 65 08 F2 0F 10 6D 10 F2 0F 10 55 08 F2 44 0F 58 35 ?? ?? ?? ?? F2 0F 5C EA F2 45 0F 58 F7 F2 0F 11 6D 10 44 0F 28 F9 F2 0F 10 65 10 F2 44 0F 58 F7 F2 44 0F 5C D4 F2 41 0F 59 F6 F2 44 0F 11 55 08 F2 44 0F 10 75 10 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E4 F2 44 0F 59 F3 F2 44 0F 59 FD F2 0F 10 55 08 F2 44 0F 11 7D 10 F2 44 0F 10 55 10 F2 0F 59 E2 F2 44 0F 5C D5 F2 0F 59 DA F2 44 0F 11 55 08 F2 44 0F 10 55 10 F2 44 0F 10 7D 08 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C D7 F2 41 0F 59 D4 F2 44 0F 11 55 10 F2 44 0F 10 7D 10 F2 41 0F 5C EF 45 0F 28 FE F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6D 08 F2 44 0F 10 55 10 F2 44 0F 59 15 ?? ?? ?? ?? F2 41 0F 59 D4 F2 45 0F 58 FA F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6D 08 F2 0F 58 D7 F2 0F 58 EC F2 41 0F 59 D0 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7D 10 F2 44 0F 10 7D 10 F2 44 0F 11 55 20 F2 45 0F 5C F7 F2 45 0F 58 F2 F2 44 0F 11 75 08 44 0F 28 F0 F2 44 0F 10 7D 10 F2 44 0F 10 55 08 F2 45 0F 58 F7 F2 44 0F 11 75 10 F2 44 0F 10 75 10 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 45 08 F2 44 0F 10 75 10 F2 41 0F 59 CE F2 44 0F 10 7D 08 F2 0F 11 4D 10 F2 0F 10 4D 10 F2 41 0F 5C CE F2 0F 11 4D 08 F2 0F 10 4D 10 F2 0F 10 45 08 F2 0F 5C C8 F2 0F 11 4D 10 F2 0F 10 45 10 F2 44 0F 5C F0 F2 44 0F 11 75 08 F2 0F 10 45 10 F2 44 0F 10 75 08 F3 44 0F 5A 21 F2 45 0F 58 F2 66 44 0F 2F 25 ?? ?? ?? ?? F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F0 F2 44 0F 59 C0 F2 41 0F 58 F6 F2 0F 58 F2 77 4C F2 0F 10 15 ?? ?? ?? ?? 0F 28 C2 F2 0F 10 25 ?? ?? ?? ?? F2 41 0F 5C C0 F2 0F 5C E6 F2 0F 11 45 10 F2 0F 10 4D 10 F2 44 0F 11 45 00 F2 0F 5C D1 F2 41 0F 5C D0 F2 0F 11 55 08 F2 44 0F 10 45 10 F2 0F 10 5D 08 0F 28 F3 F2 0F 58 F4 F2 44 0F 58 C6 F2 45 0F 5A C0 F3 44 0F 11 02 EB 2B 66 41 0F 2E C4 7A 02 74 73 44 0F 57 25 ?? ?? ?? ?? 66 41 0F 2E C4 7A 02 74 48 B8 01 00 00 00 F3 0F 5C C9 F3 0F 5E C9 F3 0F 11 0A 0F 28 75 50 0F 28 7D 40 44 0F 28 45 30 44 0F 28 95 90 00 00 00 44 0F 28 A5 80 00 00 00 44 0F 28 75 70 44 0F 28 7D 60 48 8B 9D A0 00 00 00 48 8D A5 B0 00 00 00 5D C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 5A C0 F3 0F 11 02 EB AF F2 0F 5A 05 ?? ?? ?? ?? F3 0F 11 02 EB A1 F3 0F 5E C9 F3 0F 11 0A BA 01 00 00 00 33 C0 F7 01 FF FF 7F 00 0F 44 C2 EB 87 66 90 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "__common_satan2_cout_rare"
		size = 4656
		refs = "010c _vmldAtanHATab"
	strings:
		$1 = { 56 41 55 48 81 EC B8 00 00 00 F3 0F 10 19 F3 0F 10 12 F3 0F 5A C3 F3 0F 5A CA F2 0F 11 44 24 38 F2 0F 11 4C 24 40 0F B7 41 02 25 80 7F 00 00 44 8A 52 03 44 0F B7 4C 24 3E 41 80 E2 80 0F B7 74 24 46 41 81 E1 F0 7F 00 00 81 E6 F0 7F 00 00 C1 E8 07 44 8A 59 03 41 C0 EB 07 41 C0 EA 07 44 0F 29 BC 24 90 00 00 00 44 0F 29 B4 24 A0 00 00 00 44 0F 29 6C 24 70 44 0F 29 A4 24 80 00 00 00 41 C1 E9 04 C1 EE 04 3D FF 00 00 00 0F 84 65 10 00 00 44 0F B7 6A 02 41 81 E5 80 7F 00 00 41 81 FD 80 7F 00 00 0F 84 4C 10 00 00 45 85 C9 75 0C F7 01 FF FF 7F 00 0F 84 8F 0F 00 00 85 F6 75 0C F7 02 FF FF 7F 00 0F 84 3E 0F 00 00 F7 DE F2 0F 11 44 24 38 41 03 F1 F2 0F 11 4C 24 40 8A 54 24 3F 8A 44 24 47 80 E2 7F 24 7F 83 FE CA 0F 8E 42 0E 00 00 83 FE 36 0F 8D EB 0D 00 00 88 44 24 47 45 84 D2 88 54 24 3F 75 0D F2 0F 10 0D ?? ?? ?? ?? 0F 28 D1 EB 10 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 64 24 38 45 85 C9 F2 0F 10 44 24 40 0F 28 EC F2 0F 5E E8 48 8B 44 24 38 F2 0F 11 6C 24 58 0F 8E 8D 0F 00 00 41 81 F9 FE 07 00 00 7D 21 48 89 44 24 38 41 81 C1 01 FC FF FF 48 C1 E8 30 25 0F 80 FF FF 0D F0 3F FF FF 66 89 44 24 3E EB 18 F2 0F 10 1D ?? ?? ?? ?? 41 B9 FE 03 00 00 F2 0F 59 E3 F2 0F 11 64 24 38 41 F7 D9 48 8B 05 ?? ?? ?? ?? 41 81 C1 FF 03 00 00 48 89 44 24 40 41 81 E1 FF 07 00 00 48 C1 E8 30 41 C1 E1 04 25 0F 80 FF FF 41 0B C1 66 89 44 24 46 F2 0F 10 5C 24 40 F2 0F 59 C3 66 0F 2F 2D ?? ?? ?? ?? 0F 82 40 08 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 0F 28 D8 F2 41 0F 59 DD 44 0F 28 F0 F2 0F 11 5C 24 20 F2 44 0F 10 7C 24 20 F2 0F 11 6C 24 40 F2 44 0F 5C F8 F2 44 0F 11 7C 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 8B 4C 24 44 8B F1 81 E1 00 00 08 00 81 E6 00 00 F0 FF 81 C9 00 00 04 00 F2 0F 5C EC F2 0F 11 6C 24 20 0B F1 F2 0F 10 5C 24 20 C7 44 24 40 00 00 00 00 F2 44 0F 5C F3 89 74 24 44 F2 44 0F 11 74 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 40 F2 44 0F 10 74 24 28 F2 0F 59 EC F2 44 0F 59 F4 F2 44 0F 10 25 ?? ?? ?? ?? F2 41 0F 59 EC F2 45 0F 59 F4 44 0F 28 FD 0F B7 54 24 5E F2 45 0F 58 FE F2 44 0F 11 7C 24 20 81 E2 F0 7F 00 00 F2 0F 10 5C 24 20 C1 EA 04 F2 0F 5C EB F2 0F 10 5C 24 38 F2 41 0F 58 EE F2 0F 11 6C 24 28 44 0F 28 FB F2 44 0F 10 64 24 20 F2 44 0F 10 74 24 28 F2 45 0F 58 FC F2 44 0F 11 7C 24 20 44 0F 28 FB F2 0F 10 6C 24 20 8B 44 24 5C F2 44 0F 5C FD F2 44 0F 11 7C 24 28 25 FF FF 0F 00 F2 44 0F 10 7C 24 20 F2 0F 10 6C 24 28 C1 E2 14 F2 44 0F 58 FD F2 44 0F 11 7C 24 30 44 0F 28 FB F2 0F 10 6C 24 28 0B D0 81 C2 00 00 40 C0 B8 71 00 00 00 C1 FA 13 F2 44 0F 58 E5 F2 44 0F 11 64 24 28 83 FA 71 F2 44 0F 10 64 24 30 0F 4C C2 48 8D 15 ?? ?? ?? ?? 03 C0 48 8B CA 48 63 C0 F2 45 0F 5C FC F2 44 0F 11 7C 24 30 F2 0F 10 6C 24 28 F2 44 0F 10 64 24 30 F2 41 0F 58 EC F2 0F 11 6C 24 30 F2 0F 10 6C 24 20 F2 44 0F 10 64 24 30 F2 45 0F 58 E6 44 0F 28 F5 F2 45 0F 59 F5 F2 44 0F 11 74 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C FD F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 44 0F 28 FB F2 44 0F 10 74 24 20 F2 44 0F 59 3D ?? ?? ?? ?? F2 41 0F 5C EE F2 0F 11 6C 24 28 F2 0F 10 6C 24 20 F2 44 0F 10 74 24 28 F2 44 0F 11 7C 24 20 F2 45 0F 58 E6 F2 44 0F 10 74 24 20 F2 44 0F 5C 74 24 38 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 F2 45 0F 5C F7 F2 44 0F 11 74 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C DF F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 74 24 28 F2 0F 59 DC F2 44 0F 59 F4 0F 28 E3 F2 41 0F 58 E6 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 41 0F 5C DF F2 41 0F 58 DE F2 0F 11 5C 24 28 0F 28 D8 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 58 DE F2 0F 11 5C 24 20 0F 28 D8 F2 0F 10 64 24 20 F2 0F 5C DC F2 0F 11 5C 24 28 F2 0F 10 5C 24 20 F2 0F 10 64 24 28 F2 0F 58 DC F2 0F 11 5C 24 30 F2 0F 10 64 24 28 F2 44 0F 58 F4 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 30 F2 41 0F 5C C6 F2 0F 11 44 24 30 F2 0F 10 5C 24 28 F2 0F 10 44 24 30 F2 0F 58 D8 F2 0F 11 5C 24 30 F2 0F 10 5C 24 20 F2 0F 10 44 24 30 F2 41 0F 58 C7 44 0F 28 FB F2 45 0F 59 FD F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C E3 F2 0F 11 64 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 F2 44 0F 10 74 24 20 F2 41 0F 5C DE F2 44 0F 10 35 ?? ?? ?? ?? F2 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 0F 10 5C 24 28 F2 0F 58 C3 41 0F 28 DE F2 41 0F 5E DF 0F 28 E3 F2 41 0F 59 E5 F2 0F 11 64 24 28 F2 0F 10 64 24 28 F2 0F 5C E3 F2 0F 11 64 24 30 F2 0F 10 64 24 28 F2 0F 10 5C 24 30 F2 0F 5C E3 F2 0F 11 64 24 30 F2 0F 10 5C 24 30 F2 44 0F 59 FB F2 45 0F 5C F7 F2 44 0F 10 7C 24 30 F2 41 0F 59 C7 F2 0F 11 44 24 28 F2 0F 10 44 24 28 F2 44 0F 5C F0 F2 44 0F 11 74 24 28 F2 0F 10 64 24 28 4C 8B 4C 24 30 F2 0F 10 5C 24 28 F2 44 0F 10 74 24 30 4C 89 4C 24 48 F2 44 0F 10 7C 24 48 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 E3 41 0F 28 DF F2 0F 59 DD F2 41 0F 59 E6 44 0F 28 F4 F2 45 0F 59 F4 F2 0F 59 EC F2 45 0F 59 E7 F2 44 0F 58 F5 F2 44 0F 10 3D ?? ?? ?? ?? F2 45 0F 58 F4 F2 44 0F 11 74 24 20 44 0F 28 E3 F2 44 0F 10 74 24 20 F2 45 0F 58 E6 F2 44 0F 11 64 24 20 F2 0F 10 6C 24 20 F2 0F 5C DD F2 41 0F 58 DE F2 0F 11 5C 24 28 F2 0F 10 6C 24 20 0F 28 C5 0F 28 E5 F2 0F 59 C5 F2 41 0F 59 E5 F2 44 0F 59 F8 F2 0F 10 5C 24 28 F2 0F 11 64 24 20 F2 44 0F 10 74 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 5C F5 F2 44 0F 59 F8 F2 44 0F 11 74 24 28 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 41 0F 59 C7 F2 44 0F 10 7C 24 20 F2 44 0F 10 64 24 28 F2 44 0F 59 E8 F2 45 0F 5C FC F2 44 0F 11 7C 24 20 F2 44 0F 10 74 24 20 F2 41 0F 5C EE F2 0F 11 6C 24 28 F2 44 0F 10 64 24 20 F2 0F 10 6C 24 28 F2 44 0F 11 6C 24 20 F2 0F 58 DD F2 44 0F 10 6C 24 20 F2 44 0F 5C E8 F2 44 0F 11 6C 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C FE F2 44 0F 11 7C 24 20 F2 0F 10 64 24 20 F2 0F 5C C4 F2 0F 11 44 24 28 F2 0F 10 44 24 20 F2 0F 10 6C 24 28 44 0F 28 F0 44 0F 28 FD F2 44 0F 59 FB F2 0F 59 C3 F2 41 0F 59 EC F2 45 0F 59 F4 F2 44 0F 58 F8 41 0F 28 C6 41 0F 28 E6 F2 44 0F 58 FD F2 41 0F 58 C4 F2 44 0F 11 7C 24 20 F2 44 0F 10 7C 24 20 F2 0F 11 44 24 20 F2 44 0F 10 6C 24 20 F2 41 0F 5C E5 F2 0F 11 64 24 28 F2 0F 10 6C 24 20 F2 0F 10 44 24 28 F2 0F 58 E8 F2 0F 11 6C 24 30 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 44 0F 10 64 24 30 F2 45 0F 5C F4 F2 44 0F 11 74 24 30 F2 0F 10 44 24 28 F2 44 0F 10 74 24 30 F2 41 0F 58 C6 F2 0F 11 44 24 30 4C 8B 6C 24 20 4C 89 6C 24 48 F2 44 0F 10 74 24 48 41 0F 28 EE 45 0F 28 EE F2 0F 10 64 24 30 F2 0F 58 2C C2 F2 0F 58 DC F2 0F 11 6C 24 20 F2 41 0F 58 DF F2 44 0F 10 64 24 20 F2 0F 11 5C 24 50 F2 45 0F 5C EC F2 44 0F 11 6C 24 28 F2 0F 10 44 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 58 C7 F2 0F 11 44 24 30 F2 0F 10 64 24 28 F2 0F 58 24 C1 F2 0F 11 64 24 28 F2 0F 10 6C 24 30 F2 44 0F 5C F5 F2 44 0F 11 74 24 30 F2 44 0F 10 6C 24 28 F2 44 0F 10 64 24 30 F2 45 0F 58 EC F2 44 0F 11 6C 24 30 48 8B 4C 24 20 F2 0F 10 44 24 30 48 89 4C 24 48 48 8D 15 ?? ?? ?? ?? F2 0F 58 D8 41 C0 E3 07 0F 28 C1 F2 0F 58 5C C2 08 41 8A C2 C0 E0 07 F2 0F 11 5C 24 50 48 C1 E9 38 40 8A 74 24 57 44 8A CE 40 C0 EE 07 41 80 E1 7F 80 E1 7F 44 32 D6 0A C8 88 4C 24 4F F2 44 0F 10 74 24 48 41 0F 28 E6 F2 41 0F 58 C6 41 C0 E2 07 F2 0F 11 44 24 20 F2 0F 10 5C 24 20 F2 0F 5C E3 F2 0F 11 64 24 28 45 0A CA F2 44 0F 10 64 24 20 F2 0F 10 6C 24 28 44 88 4C 24 57 F2 44 0F 58 E5 F2 44 0F 11 64 24 30 F2 44 0F 10 6C 24 28 F2 41 0F 58 CD F2 0F 11 4C 24 28 F2 0F 10 4C 24 30 F2 44 0F 5C F1 F2 44 0F 11 74 24 30 F2 0F 10 44 24 28 F2 44 0F 10 7C 24 30 F2 41 0F 58 C7 F2 0F 11 44 24 30 4C 8B 54 24 20 F2 0F 10 4C 24 30 4C 89 54 24 48 F2 0F 58 4C 24 50 F2 0F 58 CA F2 0F 10 54 24 48 F2 0F 11 4C 24 50 F2 0F 58 D1 F2 0F 11 54 24 68 44 8A 6C 24 6F 41 80 E5 7F 45 0A EB 44 88 6C 24 6F F2 0F 5A 44 24 68 F3 41 0F 11 00 E9 93 06 00 00 F2 44 0F 10 6C 24 38 41 8A CA 41 0F 28 ED F2 0F 59 2D ?? ?? ?? ?? C0 E1 07 41 C0 E3 07 F2 0F 11 6C 24 20 F2 0F 10 64 24 20 F2 0F 10 2D ?? ?? ?? ?? F2 0F 5C 64 24 38 F2 0F 11 64 24 28 F2 0F 10 5C 24 20 F2 44 0F 10 7C 24 28 F2 41 0F 5C DF F2 0F 11 5C 24 20 F2 44 0F 10 64 24 20 F2 45 0F 5C EC 44 0F 28 E0 F2 44 0F 59 E5 F2 44 0F 11 6C 24 28 F2 0F 10 5C 24 20 F2 0F 10 64 24 28 F2 44 0F 11 64 24 20 F2 44 0F 10 7C 24 20 F2 44 0F 5C F8 F2 44 0F 11 7C 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 74 24 28 F2 45 0F 5C E6 F2 44 0F 11 64 24 20 F2 44 0F 10 6C 24 20 F2 41 0F 5C C5 F2 0F 11 44 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 10 74 24 20 44 0F 28 E8 F2 45 0F 5E EE 45 0F 28 FD F2 44 0F 59 FD F2 44 0F 10 64 24 28 F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 28 F2 45 0F 5C FD F2 44 0F 11 7C 24 30 F2 44 0F 10 7C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 5C FD F2 44 0F 11 7C 24 30 F2 44 0F 10 6C 24 30 F2 45 0F 59 F5 F2 41 0F 5C C6 F2 44 0F 10 74 24 30 F2 45 0F 59 E6 F2 44 0F 11 64 24 28 F2 44 0F 10 64 24 28 F2 41 0F 5C C4 F2 0F 11 44 24 28 F2 44 0F 10 64 24 28 48 8B 44 24 30 F2 0F 10 44 24 28 48 89 44 24 48 F2 44 0F 10 6C 24 48 F2 44 0F 58 25 ?? ?? ?? ?? F2 44 0F 59 E0 F2 0F 10 44 24 30 F2 44 0F 59 E0 41 0F 28 C5 F2 0F 59 C3 F2 44 0F 59 EC F2 41 0F 59 DC 45 0F 28 FC F2 44 0F 59 FC F2 44 0F 58 FB 0F 28 D8 F2 45 0F 58 FD F2 44 0F 11 7C 24 20 F2 44 0F 10 64 24 20 F2 44 0F 10 3D ?? ?? ?? ?? F2 41 0F 58 DC F2 0F 11 5C 24 20 F2 0F 10 64 24 20 F2 0F 5C C4 F2 41 0F 58 C4 F2 0F 11 44 24 28 F2 0F 10 44 24 58 F2 0F 59 C0 F2 44 0F 59 F8 F2 44 0F 10 74 24 20 45 0F 28 EE F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 ED F2 44 0F 59 F8 F2 0F 10 5C 24 28 F2 44 0F 11 6C 24 20 F2 0F 10 64 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 41 0F 5C E6 F2 44 0F 59 F8 F2 0F 11 64 24 28 F2 44 0F 10 64 24 20 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 44 0F 58 3D ?? ?? ?? ?? F2 44 0F 59 F8 F2 0F 10 44 24 28 F2 41 0F 59 EF F2 44 0F 5C E0 F2 44 0F 11 64 24 20 F2 44 0F 10 6C 24 20 F2 45 0F 5C F5 F2 44 0F 11 74 24 28 F2 44 0F 10 6C 24 20 F2 44 0F 10 74 24 28 F2 0F 11 6C 24 20 F2 41 0F 58 DE F2 0F 10 6C 24 20 F2 41 0F 5C EF F2 0F 11 6C 24 28 F2 44 0F 10 64 24 20 F2 0F 10 44 24 28 F2 44 0F 5C E0 F2 44 0F 11 64 24 20 F2 0F 10 64 24 20 F2 44 0F 5C FC F2 44 0F 11 7C 24 28 F2 44 0F 10 74 24 20 F2 44 0F 10 7C 24 28 45 0F 28 E6 41 0F 28 C7 F2 0F 59 C3 F2 44 0F 59 F3 F2 45 0F 59 FD F2 45 0F 59 E5 F2 41 0F 58 C6 41 0F 28 E4 45 0F 28 F4 F2 41 0F 58 C7 F2 41 0F 58 E5 F2 0F 11 44 24 20 F2 0F 10 44 24 20 F2 0F 11 64 24 20 F2 0F 10 6C 24 20 F2 44 0F 5C F5 F2 44 0F 11 74 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 F2 0F 58 EC F2 0F 11 6C 24 30 F2 44 0F 10 7C 24 28 F2 45 0F 58 EF F2 44 0F 11 6C 24 28 F2 44 0F 10 6C 24 30 F2 45 0F 5C E5 F2 44 0F 11 64 24 30 F2 0F 10 6C 24 28 F2 0F 10 64 24 30 F2 0F 58 EC F2 0F 11 6C 24 30 48 8B 54 24 20 F2 44 0F 10 64 24 30 48 89 54 24 48 F2 41 0F 58 DC 48 C1 EA 38 F2 0F 58 D8 80 E2 7F 0A D1 88 54 24 4F F2 0F 11 5C 24 50 0F 28 D9 F2 44 0F 10 6C 24 48 41 0F 28 C5 F2 41 0F 58 DD F2 0F 11 5C 24 20 F2 0F 10 5C 24 20 40 8A 74 24 57 44 8A CE 40 C0 EE 07 F2 0F 5C C3 F2 0F 11 44 24 28 F2 0F 10 6C 24 20 F2 0F 10 64 24 28 44 32 D6 41 80 E1 7F 41 C0 E2 07 F2 0F 58 EC F2 0F 11 6C 24 30 F2 44 0F 10 64 24 28 F2 41 0F 58 CC F2 0F 11 4C 24 28 45 0A CA F2 0F 10 4C 24 30 44 88 4C 24 57 F2 44 0F 5C E9 F2 44 0F 11 6C 24 30 F2 0F 10 5C 24 28 F2 0F 10 44 24 30 F2 0F 58 D8 F2 0F 11 5C 24 30 4C 8B 54 24 20 F2 0F 10 64 24 30 4C 89 54 24 48 F2 0F 58 64 24 50 F2 0F 58 E2 F2 0F 10 54 24 48 F2 0F 11 64 24 50 F2 0F 58 D4 F2 0F 11 54 24 68 44 8A 6C 24 6F 41 80 E5 7F 45 0A EB 44 88 6C 24 6F F2 0F 5A 44 24 68 F3 41 0F 11 00 E9 C5 01 00 00 83 FE 4A 0F 8D 27 01 00 00 88 54 24 3F F2 0F 5E 4C 24 38 F2 0F 10 05 ?? ?? ?? ?? 41 C0 E3 07 F2 0F 5C C1 F2 0F 58 05 ?? ?? ?? ?? F2 0F 11 44 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 4C 24 68 F3 41 0F 11 08 E9 77 01 00 00 45 84 D2 0F 85 3C 01 00 00 88 54 24 3F 88 44 24 47 F2 0F 10 54 24 38 F2 0F 5E 54 24 40 F2 0F 5A C2 F3 0F 11 44 24 60 0F B7 44 24 62 A9 80 7F 00 00 F2 0F 11 54 24 68 74 43 F2 0F 10 05 ?? ?? ?? ?? 41 C0 E3 07 F2 0F 58 C2 F2 0F 11 44 24 20 F2 0F 10 4C 24 20 F2 0F 59 D1 F2 0F 11 54 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 54 24 68 F3 41 0F 11 10 E9 FB 00 00 00 F2 0F 5A 44 24 68 41 C0 E3 07 F3 0F 11 44 24 60 F3 0F 10 54 24 60 F3 0F 10 4C 24 60 F3 0F 59 D1 F3 0F 11 54 24 60 F3 0F 10 5C 24 60 F3 0F 5A DB F2 0F 58 5C 24 68 F2 0F 11 5C 24 68 8A 44 24 6F 24 7F 41 0A C3 88 44 24 6F F2 0F 5A 64 24 68 F3 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "__avx_atan24"
		size = 768
		refs = "0063 __common_datan2_data 02f4 __common_datan2_cout_rare"
	strings:
		$1 = { 48 81 EC 58 02 00 00 C5 7C 11 AC 24 70 01 00 00 C5 7C 11 A4 24 D0 01 00 00 C5 7C 11 9C 24 B0 01 00 00 C5 7C 11 94 24 10 02 00 00 C5 7C 11 8C 24 F0 01 00 00 C5 7C 11 84 24 90 01 00 00 C5 FC 11 BC 24 50 01 00 00 C5 FC 11 B4 24 30 02 00 00 4C 89 AC 24 50 02 00 00 4C 8D AC 24 AF 00 00 00 C5 FD 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 7D 10 15 ?? ?? ?? ?? C5 F5 54 D4 C5 FD 54 EC C5 D5 C2 DA 15 C4 41 6D 56 EA C4 C3 55 4B E5 30 C4 63 6D 4B C5 30 C4 41 5D 5E E8 C5 F8 10 25 ?? ?? ?? ?? C5 65 54 25 ?? ?? ?? ?? C4 41 75 54 DA C4 41 7D 54 CA C5 78 10 15 ?? ?? ?? ?? C4 E3 7D 19 D6 01 C4 E3 7D 19 EF 01 C5 E8 C6 DE DD C5 D0 C6 EF DD C5 61 FA C4 C5 D1 FA FC C4 C1 39 66 D2 C5 F5 C2 25 ?? ?? ?? ?? 12 C4 C1 39 76 F2 C4 C1 41 66 EA C4 41 41 76 D2 C5 E9 EB DE C4 41 51 EB D2 C4 C1 61 EB EA C5 5D 54 15 ?? ?? ?? ?? C4 C1 15 59 E5 C5 F8 50 D5 C5 DD 59 EC C5 D5 59 DD C5 65 59 05 ?? ?? ?? ?? C5 E5 59 3D ?? ?? ?? ?? C5 E5 59 15 ?? ?? ?? ?? C5 BD 58 35 ?? ?? ?? ?? C5 45 58 05 ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 CD 59 F3 C5 E5 59 3D ?? ?? ?? ?? C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F3 C5 C5 59 FB C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F3 C5 C5 59 FB C5 ED 59 D3 C5 3D 59 C3 C5 CD 58 35 ?? ?? ?? ?? C5 C5 58 3D ?? ?? ?? ?? C5 ED 58 15 ?? ?? ?? ?? C5 3D 58 05 ?? ?? ?? ?? C5 CD 59 F4 C5 C5 59 DB C5 BD 59 E4 C5 CD 58 FA C5 E5 58 1D ?? ?? ?? ?? C5 C5 59 ED C5 DD 58 D3 C5 D5 58 DA C4 41 65 59 ED C4 41 15 58 E4 C4 41 1D 56 DB C4 C1 25 58 D2 C4 C1 6D 56 D1 85 D2 75 5C C5 FC 10 B4 24 30 02 00 00 C5 FC 10 BC 24 50 01 00 00 C5 7C 10 84 24 90 01 00 00 C5 7C 10 8C 24 F0 01 00 00 C5 7C 10 94 24 10 02 00 00 C5 7C 10 9C 24 B0 01 00 00 C5 7C 10 A4 24 D0 01 00 00 C5 7C 10 AC 24 70 01 00 00 4C 8B AC 24 50 02 00 00 C5 FD 28 C2 48 81 C4 58 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 C4 C1 7D 11 95 80 00 00 00 74 8D 33 C0 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 5C 24 68 8B D8 48 89 74 24 60 8B F2 0F A3 DE 72 2B FF C3 83 FB 20 7C F4 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 95 80 00 00 00 48 8B 5C 24 68 48 8B 74 24 60 E9 41 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 4D 8D 84 DD 80 00 00 00 E8 ?? ?? ?? ?? EB B9 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "__common_dcosh_cout_rare"
		size = 1056
		refs = "0030 _vmldCoshHATab"
	strings:
		$1 = { 48 81 EC 88 00 00 00 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 44 0F 29 74 24 70 41 81 F8 F0 7F 00 00 44 0F 29 5C 24 50 0F 29 7C 24 60 4C 8B 0D ?? ?? ?? ?? 0F 84 CE 03 00 00 48 8B 09 48 89 4C 24 40 48 C1 E9 38 83 E1 7F 88 4C 24 47 44 0F B7 44 24 46 41 81 E0 F0 7F 00 00 41 81 F8 90 3C 00 00 0F 8E 76 03 00 00 F2 44 0F 10 74 24 40 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C6 0F 86 45 03 00 00 F2 0F 10 15 ?? ?? ?? ?? 4C 89 4C 24 40 F2 41 0F 59 D6 66 44 0F 2F 35 ?? ?? ?? ?? 0F 82 4A 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 D0 F2 0F 11 54 24 20 F2 0F 10 4C 24 20 44 8B 44 24 20 41 8B C8 83 E1 3F F2 0F 5C 0D ?? ?? ?? ?? F2 0F 11 4C 24 28 44 8D 14 09 F2 0F 10 54 24 28 8D 4C 09 01 F2 0F 59 15 ?? ?? ?? ?? F2 0F 10 5C 24 28 F2 44 0F 5C F2 F2 0F 59 1D ?? ?? ?? ?? F2 44 0F 5C F3 F2 41 0F 59 E6 F2 43 0F 10 0C D3 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E6 41 C1 E8 06 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E6 41 81 C0 FF 03 00 00 41 FF C8 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E6 41 81 E0 FF 07 00 00 41 81 F8 FE 07 00 00 F2 0F 58 25 ?? ?? ?? ?? F2 41 0F 59 E6 F2 41 0F 59 E6 F2 41 0F 58 E6 F2 0F 59 E1 F2 41 0F 58 24 CB F2 0F 58 CC 77 2B 49 C1 E9 30 41 C1 E0 04 41 81 E1 0F 80 FF FF 45 0B C8 66 44 89 4C 24 46 F2 0F 10 44 24 40 F2 0F 59 C1 F2 0F 11 02 E9 3F 02 00 00 41 FF C8 41 81 E0 FF 07 00 00 0F B7 4C 24 46 41 C1 E0 04 81 E1 0F 80 FF FF 41 0B C8 66 89 4C 24 46 F2 0F 10 44 24 40 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 0A E9 03 02 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 44 0F B7 4C 24 46 F2 0F 58 D1 F2 0F 11 54 24 20 41 81 E1 0F 80 FF FF F2 0F 10 7C 24 20 44 8B 5C 24 20 45 8B D3 41 C1 EA 06 41 83 E3 3F 41 81 C2 FF 03 00 00 F2 0F 5C 3D ?? ?? ?? ?? F2 0F 11 7C 24 28 41 8D 4A FF F2 44 0F 10 5C 24 28 81 E1 FF 07 00 00 F2 44 0F 59 1D ?? ?? ?? ?? 41 F7 DA F2 0F 10 64 24 28 41 83 C2 FC F2 0F 59 25 ?? ?? ?? ?? F2 45 0F 5C F3 F2 44 0F 10 1D ?? ?? ?? ?? 41 81 E2 FF 07 00 00 C1 E1 04 F2 44 0F 5C F4 41 0F 28 EE 44 0B C9 F2 41 0F 59 EE 43 8D 0C 1B F2 44 0F 59 DD F2 44 0F 58 1D ?? ?? ?? ?? F2 41 0F 10 24 C8 F7 D9 F2 0F 10 3D ?? ?? ?? ?? 47 8D 44 1B 01 66 44 89 4C 24 46 41 81 E1 0F 80 FF FF 41 C1 E2 04 4C 8D 1D ?? ?? ?? ?? F2 0F 59 FD 45 0B CA F2 44 0F 59 DD F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 1D ?? ?? ?? ?? F2 0F 59 FD F2 44 0F 59 DD F2 41 0F 59 FE F2 0F 10 4C 24 40 4D 8B D3 66 44 89 4C 24 46 44 8D 89 80 00 00 00 81 C1 81 00 00 00 F2 0F 10 44 24 40 F2 43 0F 10 2C C3 4D 8B C3 F2 0F 59 E1 F2 0F 59 E9 F2 43 0F 10 14 CA 0F 28 CC F2 0F 59 D0 F2 41 0F 10 1C C8 F2 0F 58 CA F2 0F 59 D8 F2 0F 11 4C 24 30 0F 28 CC F2 0F 10 44 24 30 F2 0F 5C E2 F2 0F 5C C8 F2 0F 59 FC F2 0F 58 CA 0F 28 D5 F2 0F 11 4C 24 38 F2 0F 5C D3 F2 41 0F 59 D6 F2 44 0F 59 F4 F2 0F 58 D3 F2 0F 10 4C 24 30 F2 0F 58 D5 F2 44 0F 59 D9 F2 0F 10 44 24 38 F2 0F 58 D0 F2 0F 58 D7 F2 41 0F 58 D3 F2 41 0F 58 D6 F2 0F 11 54 24 30 F2 44 0F 10 74 24 30 F2 41 0F 58 CE F2 0F 11 0A EB 29 F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C0 F2 0F 11 02 EB 12 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 44 24 40 F2 0F 11 02 0F 28 7C 24 60 44 0F 28 5C 24 50 44 0F 28 74 24 70 48 81 C4 88 00 00 00 C3 F2 0F 10 01 F2 0F 59 C0 F2 0F 11 02 EB D9 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "??0bad_alloc@std@@AEAA@QEBD@Z"
		size = 24
		refs = "0009 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_17_0_3 {
	meta:
		name = "??0__non_rtti_object@std@@AEAA@QEBDH@Z"
		size = 24
		refs = "0009 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_17_2_3 {
	meta:
		name = "??0bad_cast@std@@AEAA@QEBDH@Z"
		size = 24
		refs = "0009 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_17_4_3 {
	meta:
		name = "??0bad_typeid@std@@AEAA@QEBDH@Z"
		size = 24
		refs = "0009 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_17_22_3 {
	meta:
		name = "?__construct_from_string_literal@__non_rtti_object@std@@SA?AV12@QEBD@Z"
		size = 24
		refs = "0009 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_17_23_3 {
	meta:
		name = "?__construct_from_string_literal@bad_cast@std@@SA?AV12@QEBD@Z"
		size = 24
		refs = "0009 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_17_24_3 {
	meta:
		name = "?__construct_from_string_literal@bad_typeid@std@@SA?AV12@QEBD@Z"
		size = 24
		refs = "0009 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_353_1_0 {
	meta:
		name = "??0bad_alloc@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_1_3 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_95_3_6 {
	meta:
		name = "??0bad_array_new_length@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_109_86_1 {
	meta:
		name = "??0bad_cast@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_3_1_3 {
	meta:
		name = "??0bad_exception@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_23_2_2 {
	meta:
		name = "??0bad_function_call@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_5_3 {
	meta:
		name = "??0bad_typeid@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_23_8_2 {
	meta:
		name = "??0invalid_argument@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_104_10_1 {
	meta:
		name = "??0length_error@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7length_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_32_5_1 {
	meta:
		name = "??0logic_error@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7logic_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_104_14_1 {
	meta:
		name = "??0out_of_range@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_104_16_1 {
	meta:
		name = "??0overflow_error@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_71_83_2 {
	meta:
		name = "??0runtime_error@std@@QEAA@AEBV01@@Z"
		size = 63
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy 002f ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_353_2_0 {
	meta:
		name = "??0bad_alloc@std@@QEAA@XZ"
		size = 31
		refs = "0009 ??_C@_0P@GHFPNOJB@bad?5allocation?$AA@ 0014 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 41 08 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_95_4_6 {
	meta:
		name = "??0bad_array_new_length@std@@QEAA@XZ"
		size = 31
		refs = "0009 ??_C@_0BF@KINCDENJ@bad?5array?5new?5length?$AA@ 0014 ??_7bad_array_new_length@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 41 08 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_108_67_2 {
	meta:
		name = "??0bad_cast@std@@QEAA@XZ"
		size = 31
		refs = "0009 ??_C@_08EPJLHIJG@bad?5cast?$AA@ 0014 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 41 08 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_99_49_1 {
	meta:
		name = "??0bad_exception@std@@QEAA@XZ"
		size = 31
		refs = "0009 ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 0014 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 33 C0 48 89 41 10 48 8D 05 ?? ?? ?? ?? 48 89 41 08 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_353_5_0 {
	meta:
		name = "??0exception@std@@QEAA@AEBV01@@Z"
		size = 53
		refs = "000f ??_7exception@std@@6B@ 0028 __std_exception_copy"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 48 08 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_353_6_0 {
	meta:
		name = "??0exception@std@@QEAA@QEBDH@Z"
		size = 24
		refs = "0003 ??_7exception@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 89 01 33 C0 48 89 41 10 48 8B C1 48 89 51 08 C3 }
	condition:
		$1
}

rule file_353_7_0 {
	meta:
		name = "??1bad_alloc@std@@UEAA@XZ"
		size = 19
		refs = "0003 ??_7exception@std@@6B@ 000f __std_exception_destroy"
		altNames = "??1_System_error@std@@UEAA@XZ ??1__non_rtti_object@std@@UEAA@XZ ??1bad_array_new_length@std@@UEAA@XZ ??1bad_cast@std@@UEAA@XZ ??1bad_exception@std@@UEAA@XZ ??1bad_function_call@std@@UEAA@XZ ??1bad_typeid@std@@UEAA@XZ ??1exception@std@@UEAA@XZ ??1failure@ios_base@std@@UEAA@XZ ??1future_error@std@@UEAA@XZ ??1invalid_argument@std@@UEAA@XZ ??1length_error@std@@UEAA@XZ ??1logic_error@std@@UEAA@XZ ??1out_of_range@std@@UEAA@XZ ??1overflow_error@std@@UEAA@XZ ??1regex_error@std@@UEAA@XZ ??1runtime_error@std@@UEAA@XZ ??1system_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 89 01 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_353_10_0 {
	meta:
		name = "??_Gbad_alloc@std@@UEAAPEAXI@Z"
		size = 66
		refs = "000d ??_7exception@std@@6B@ 001e __std_exception_destroy 0030 ??3@YAXPEAX_K@Z"
		altNames = "??_G__non_rtti_object@std@@UEAAPEAXI@Z ??_Gbad_array_new_length@std@@UEAAPEAXI@Z ??_Gbad_cast@std@@UEAAPEAXI@Z ??_Gbad_exception@std@@UEAAPEAXI@Z ??_Gbad_function_call@std@@UEAAPEAXI@Z ??_Gbad_typeid@std@@UEAAPEAXI@Z ??_Gexception@std@@UEAAPEAXI@Z ??_Ginvalid_argument@std@@UEAAPEAXI@Z ??_Glength_error@std@@UEAAPEAXI@Z ??_Glogic_error@std@@UEAAPEAXI@Z ??_Gout_of_range@std@@UEAAPEAXI@Z ??_Goverflow_error@std@@UEAAPEAXI@Z ??_Gruntime_error@std@@UEAAPEAXI@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B F9 48 89 01 8B DA 48 83 C1 08 E8 ?? ?? ?? ?? F6 C3 01 74 0D BA 18 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_353_13_0 {
	meta:
		name = "?__scrt_throw_std_bad_alloc@@YAXXZ"
		size = 32
		refs = "000a ??0bad_alloc@std@@QEAA@XZ 0011 _TI2?AVbad_alloc@std@@ 001b _CxxThrowException"
		altNames = "?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 48 83 EC 48 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_104_44_1 {
	meta:
		name = "?_Xbad_function_call@std@@YAXXZ"
		size = 32
		refs = "000a ??0bad_function_call@std@@QEAA@XZ 0011 _TI2?AVbad_function_call@std@@ 001b _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_353_14_0 {
	meta:
		name = "?__scrt_throw_std_bad_array_new_length@@YAXXZ"
		size = 32
		refs = "000a ??0bad_array_new_length@std@@QEAA@XZ 0011 _TI3?AVbad_array_new_length@std@@ 001b _CxxThrowException"
	strings:
		$1 = { 48 83 EC 48 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_353_15_0 {
	meta:
		name = "?what@exception@std@@UEBAPEBDXZ"
		size = 18
		refs = "0008 ??_C@_0BC@EOODALEL@Unknown?5exception?$AA@"
	strings:
		$1 = { 48 83 79 08 00 48 8D 05 ?? ?? ?? ?? 48 0F 45 41 08 C3 }
	condition:
		$1
}

rule file_9_0_3 {
	meta:
		name = "?get_unexpected_or_default@@YAP6AXXZQEBU__vcrt_ptd@@@Z"
		size = 18
		refs = "0008 terminate"
	strings:
		$1 = { 48 83 79 08 00 48 8D 05 ?? ?? ?? ?? 48 0F 45 41 08 C3 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "__static_scalar_tan"
		size = 1408
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 0E 05 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 40 01 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 40 01 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 00 0F 8C 16 03 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 3F 41 F7 C1 00 00 00 20 0F 85 20 03 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 89 02 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E A9 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 54 24 60 F3 41 0F 7E 7C 24 68 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1E F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F9 8B C7 F2 0F 58 FB F3 0F 7E D0 F2 0F 58 C7 F2 0F 5C D0 F2 0F 58 FA 66 41 0F 28 0C 24 F2 0F 12 C0 66 0F 59 C8 F2 0F 12 FF F2 0F 2D D1 66 41 0F 28 54 24 10 66 0F 58 CA 66 41 0F 28 5C 24 20 66 0F 5C CA F3 41 0F 7E AC 24 80 00 00 00 C1 E0 04 81 C2 00 29 07 00 66 41 0F 28 64 24 30 66 0F 59 D9 03 D0 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 41 0F 59 4C 24 40 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 F3 41 0F 7E B4 24 90 00 00 00 C1 E2 04 49 8D 84 24 F0 01 00 00 66 41 0F 54 6C 24 50 66 0F 28 D8 48 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 F2 0F 5C DD 66 0F 5C D1 66 0F 28 48 30 66 0F 58 D7 66 0F 28 78 10 66 0F 59 F8 66 0F 28 60 60 66 0F 59 C8 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F3 0F 7E D9 66 0F 58 FC F3 0F 7E E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F3 0F 7E E2 F3 0F 7E B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 F3 41 0F 7E BC 24 90 00 00 00 F2 0F 59 E6 F3 0F 7E 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F3 0F 7E E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 F2 0F 58 C3 E9 0B 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 5D FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 4A FD FF FF E9 73 FD FF FF 0F 84 6D FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 50 FD FF FF F7 D1 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 02 E9 EF FC FF FF 41 D3 E9 BB 00 00 00 40 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 40 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 AA FC FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 02 81 C7 00 00 00 40 E9 66 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 0F 1F 00 }
	condition:
		$1
}

rule file_356_1_0 {
	meta:
		name = "__sse2_tan2"
		size = 1712
		refs = "001b MMDRSHIFT 002b MMDPI1 0033 MMDPI2 003b MMIABSMASK 0043 MMDINVPI2 0057 MMDPI3 006b MMDHUGE 007f MMDPI4 00ba MMDP3 00c2 MMDQ3 00ca MMDP0 00d2 MMDQ0 00de MMDP2 00ea MMDQ2 00f6 MMDP1 0102 MMDQ1 016e MMISIGNMASK 0193 TWO_POW_30 01a5 flAllOnes 020f THE_PI04_INV 0224 MMI_ONE 022c MSK_LOW_BIT 0234 RS 0248 PI04C_0 0254 PI04C_1 0264 PI04C_2 0295 PI04C_3 02c1 PI04C_4"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 28 D0 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F 59 05 ?? ?? ?? ?? 66 0F 58 C6 66 0F 28 D8 66 0F 5C C6 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 E7 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 F8 66 0F 28 C3 66 0F 73 F3 3E 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F C2 D9 04 66 0F 73 F0 3F 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F DB CA 66 0F 29 54 24 30 66 0F 70 FF F5 66 0F DB 15 ?? ?? ?? ?? 66 0F 29 4C 24 40 66 0F 28 0D ?? ?? ?? ?? 66 0F 66 CA 66 0F 29 7C 24 50 66 0F 57 3D ?? ?? ?? ?? 66 0F 50 D1 66 0F 29 54 24 60 66 0F 29 7C 24 70 66 0F 28 3D ?? ?? ?? ?? 83 F2 03 0F 85 6C 03 00 00 83 F8 03 74 3C 66 0F 59 F8 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F 5C D7 66 0F 54 5C 24 70 66 0F 54 54 24 70 66 0F 29 9C 24 80 00 00 00 66 0F 29 94 24 90 00 00 00 66 0F 28 54 24 60 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 72 E3 01 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F 58 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 59 D2 83 F8 03 74 1E 66 0F 54 5C 24 50 66 0F 54 4C 24 50 66 0F 56 9C 24 80 00 00 00 66 0F 56 8C 24 90 00 00 00 66 0F 28 C3 66 0F 73 F3 3E 66 0F 73 F0 3F 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F EF 44 24 40 66 0F 59 E2 66 0F 59 EA 66 0F EF C9 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 59 EA 66 0F C2 D9 04 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E6 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 E9 A6 02 00 00 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 72 E3 01 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F 58 D1 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF 44 24 40 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 CA 66 0F 59 D2 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 E9 1E 01 00 00 89 44 24 20 83 F8 03 0F 84 F4 00 00 00 66 0F 28 54 24 30 66 0F 59 F8 66 0F 5C D4 66 0F EF E4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 29 8C 24 A0 00 00 00 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF C4 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 8C 24 A0 00 00 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4B D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 44 24 38 89 44 24 20 E8 05 F4 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB BB F2 0F 10 44 24 30 E8 EB F3 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 9B 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_357_0_0 {
	meta:
		name = "__common_slog10_cout_rare"
		size = 720
		refs = "003b _2il0floatpacket_77 005f _2il0floatpacket_93 0077 _2il0floatpacket_78 00b7 _vmldLgHATab 00d3 _2il0floatpacket_79 00db _2il0floatpacket_80 00e3 _2il0floatpacket_82 00ef _2il0floatpacket_81 0145 _2il0floatpacket_83 0158 _2il0floatpacket_84 0164 _2il0floatpacket_85 0170 _2il0floatpacket_86 017c _2il0floatpacket_87 0188 _2il0floatpacket_88 0194 _2il0floatpacket_89 01a0 _2il0floatpacket_90 01af _2il0floatpacket_91 026a _2il0floatpacket_92"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 41 81 F8 80 7F 00 00 0F 84 61 02 00 00 F3 0F 10 01 45 33 C0 8B 09 89 4C 24 28 C1 E9 10 F7 C1 80 7F 00 00 75 14 F3 0F 59 05 ?? ?? ?? ?? 41 B8 D8 FF FF FF F3 0F 11 44 24 28 66 0F EF C9 0F 2F C1 0F 86 F5 01 00 00 0F 28 D0 F3 0F 5C 15 ?? ?? ?? ?? F3 0F 11 54 24 24 80 64 24 27 7F F3 0F 10 4C 24 24 0F 2F 0D ?? ?? ?? ?? 0F 86 53 01 00 00 0F B7 4C 24 2A 81 E1 80 7F 00 00 C1 E9 07 F3 0F 11 44 24 24 44 0F B7 4C 24 26 41 81 E1 7F 80 FF FF 41 81 C9 80 3F FF FF 45 8D 44 08 81 66 44 89 4C 24 26 48 8D 0D ?? ?? ?? ?? F3 41 0F 2A D8 F3 0F 10 64 24 24 4C 8B C9 0F 28 C4 4C 8B C1 F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? F3 0F 10 2D ?? ?? ?? ?? F3 0F 59 D3 F3 0F 58 05 ?? ?? ?? ?? F3 0F 59 D9 0F 28 CC F3 0F 11 44 24 20 F3 0F 58 CD 44 8B 54 24 20 41 83 E2 7F F3 0F 11 4C 24 20 F3 0F 10 4C 24 20 F3 0F 5C CD 47 8D 1C 52 F3 0F 5C E1 F3 43 0F 58 5C 99 08 F3 43 0F 58 54 98 04 F3 42 0F 10 04 99 F3 0F 59 C8 F3 0F 59 C4 F3 0F 5C 0D ?? ?? ?? ?? 0F 28 E9 F3 0F 58 D1 F3 0F 58 E8 F3 0F 10 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 E5 0F 28 E8 F3 0F 58 25 ?? ?? ?? ?? F3 0F 59 EC F3 0F 59 CC F3 0F 58 DD F3 0F 58 C3 F3 0F 58 C1 F3 0F 58 D0 F3 0F 11 12 48 83 C4 38 C3 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 D0 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 CA F3 0F 58 D1 F3 0F 11 12 48 83 C4 38 C3 0F 2E C1 7A 02 74 12 F3 0F 5E C9 F3 0F 11 0A B8 01 00 00 00 48 83 C4 38 C3 F3 0F 10 05 ?? ?? ?? ?? B8 02 00 00 00 F3 0F 5E C1 F3 0F 11 02 48 83 C4 38 C3 44 8A 41 03 41 80 E0 80 41 80 F8 80 74 11 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 48 83 C4 38 C3 F7 01 FF FF 7F 00 75 E7 B8 01 00 00 00 66 0F EF C9 66 0F EF C0 F3 0F 5E C8 F3 0F 11 0A 48 83 C4 38 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_361_0_0 {
	meta:
		name = "__static_scalar_cos"
		size = 1280
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 82 04 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 D0 00 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 D0 00 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 01 0F 8C 8A 02 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 1F 41 F7 C1 00 00 00 10 0F 85 94 02 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 F5 01 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E 1D 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 94 24 C0 00 00 00 F3 41 0F 7E B4 24 C8 00 00 00 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1D F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F1 8B C7 F2 0F 58 F3 F3 0F 7E D0 F2 0F 58 C6 F2 0F 5C D0 F2 0F 58 F2 F3 41 0F 7E 4C 24 70 F2 0F 59 C8 F3 41 0F 7E 94 24 80 00 00 00 F2 48 0F 2D D1 F2 0F 58 CA F3 41 0F 7E 5C 24 50 F2 0F 5C CA 66 41 0F 28 54 24 40 F2 0F 59 D9 66 0F 14 C9 C1 E0 03 81 C2 10 76 1C 00 F3 0F 7E E0 03 D0 83 E2 3F 66 41 0F 28 6C 24 30 49 8D 84 24 80 01 00 00 C1 E2 05 48 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 41 0F 59 4C 24 60 F2 0F 5C E3 F3 0F 7E 78 08 66 0F 14 C0 F3 0F 7E DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F3 0F 7E 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 5C CE 66 41 0F 28 74 24 10 F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 41 0F 58 6C 24 20 F2 0F 59 20 66 41 0F 58 34 24 66 0F 59 E8 F3 0F 7E C3 F2 0F 58 58 08 66 0F 59 CF F3 0F 7E FC F2 0F 58 E3 66 0F 58 F5 F3 0F 7E 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F3 0F 7E C4 F2 0F 58 CE F2 0F 58 C1 E9 13 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 F1 FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 DE FD FF FF 66 0F 57 C0 66 0F 57 F6 E9 86 FE FF FF 0F 84 F9 FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 DC FD FF FF F7 D9 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 03 E9 7B FD FF FF 41 D3 E9 BB 00 00 00 20 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 20 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 36 FD FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 03 81 C7 00 00 00 20 E9 F2 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_361_1_0 {
	meta:
		name = "__sse2_cos2"
		size = 1184
		refs = "001b iABSMASK 0023 dbPio2 0033 dbNegRS 003b dbPi1 0043 dbInvPi 004b dbPi2 005f dbHUGE 0071 db05 008d dbPi3 00a1 dbPi4 00ad dbA8 00b5 dbA7 00dd dbA6 00e5 dbA5 00f5 dbA4 00fd dbA3 010d dbA2 0115 dbA1 0162 TWO_POW_30 0170 flAllOnes 01f1 THE_PI02_INV 0206 MMI_ONE 020e RS 0222 PI02C_0 022e PI02C_1 023e PI02C_2 026f PI02C_3 029b PI02C_4 02ab MMISIGNMASK"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 54 05 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 58 D0 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 0D ?? ?? ?? ?? 66 0F 5C D5 66 0F C2 0D ?? ?? ?? ?? 06 66 0F 58 EA 66 0F 73 F2 3F 66 0F 5C 2D ?? ?? ?? ?? 66 0F 50 C1 66 0F 59 E5 66 0F 59 DD 0B C0 0F 85 BC 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CD 66 0F 5C C4 66 0F 5C C3 66 0F 59 2D ?? ?? ?? ?? 66 0F 5C C1 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 58 E8 66 0F 59 C0 66 0F 57 EA 66 0F 28 E0 66 0F 59 C0 66 0F 59 E5 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 C3 66 0F 59 CC 66 0F 59 C5 66 0F 58 CD 66 0F 58 C1 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 70 C9 F5 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 F0 66 0F 28 3D ?? ?? ?? ?? 66 0F 29 4C 24 30 66 0F 57 0D ?? ?? ?? ?? 66 0F 66 FE 66 0F 29 74 24 40 66 0F 50 D7 66 0F 29 4C 24 50 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CD 83 F2 03 0F 85 D7 01 00 00 83 F8 03 74 47 66 0F 5C C4 66 0F 5C C3 66 0F 59 2D ?? ?? ?? ?? 66 0F 5C C1 66 0F 58 E8 66 0F 59 C0 66 0F EF EA 66 0F 54 54 24 50 66 0F 54 6C 24 50 66 0F 54 44 24 50 66 0F 29 54 24 60 66 0F 29 6C 24 70 66 0F 29 84 24 80 00 00 00 66 0F 28 C6 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DE 66 0F E6 DB 66 0F 70 DB DC 66 0F EB 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 56 D3 66 0F 5C 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 CA 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E2 66 0F 5C C1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EA 66 0F 28 C8 66 0F 5C C4 66 0F 5C C8 66 0F 28 F0 66 0F 5C CC 66 0F 5C C5 66 0F 73 F3 3E 66 0F 5C F0 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 C1 66 0F 59 E2 66 0F 5C F8 66 0F 28 E8 66 0F 5C C4 66 0F 58 CF 66 0F 5C E8 66 0F 59 15 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C CA 66 0F DB EB 66 0F 58 C1 66 0F EF 2D ?? ?? ?? ?? 66 0F EF E8 66 0F 59 C0 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 83 F8 03 74 27 66 0F 54 54 24 30 66 0F 54 6C 24 30 66 0F 54 44 24 30 66 0F 56 54 24 60 66 0F 56 6C 24 70 66 0F 56 84 24 80 00 00 00 66 0F 28 E0 66 0F 59 C0 66 0F 59 E5 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 C3 66 0F 59 CC 66 0F 59 C5 66 0F 58 CD 66 0F 58 C1 E9 D4 00 00 00 66 0F 29 84 24 90 00 00 00 89 44 24 20 83 F8 03 0F 84 A1 00 00 00 66 0F 5C C4 66 0F 5C C3 66 0F 59 2D ?? ?? ?? ?? 66 0F 5C C1 66 0F 58 E8 66 0F 59 C0 66 0F EF EA 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 E0 66 0F 59 C0 66 0F 59 E5 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 D8 66 0F 59 C8 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 59 C3 66 0F 59 CC 66 0F 59 C5 66 0F 58 CD 66 0F 58 C1 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4E D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 84 24 98 00 00 00 89 44 24 20 E8 8E F6 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB B8 F2 0F 10 84 24 90 00 00 00 E8 71 F6 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 95 66 90 }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "__sse2_atan2"
		size = 400
		refs = "000c iAbsMask 0014 dbOne 0039 iSignMask 0041 dbPio2hi 007f dbA19 0087 dbA17 008f dbA18 0097 dbA16 00af dbA15 00b7 dbA13 00bf dbA14 00c7 dbA12 00df dbA11 00e7 dbA09 00ef dbA10 00f7 dbA08 010f dbA07 0117 dbA05 011f dbA06 0127 dbA04 013f dbA03 0147 dbA01 014f dbA02 0163 dbA00"
	strings:
		$1 = { 48 83 EC 58 66 0F 28 E8 66 0F DB 05 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 5F D8 66 0F 28 E0 66 0F 5D 05 ?? ?? ?? ?? 66 0F 5E C3 66 0F C2 25 ?? ?? ?? ?? 06 66 0F DB 2D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F DB D4 66 0F DB 25 ?? ?? ?? ?? 66 0F EF D5 66 0F EF E5 66 0F EF E0 66 0F 59 C0 66 0F 29 44 24 20 66 0F 59 C0 66 0F 29 44 24 30 66 0F 59 C0 66 0F 29 64 24 40 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 E8 66 0F 59 E0 66 0F 59 D8 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 E8 66 0F 59 E0 66 0F 59 D8 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 E8 66 0F 59 E0 66 0F 59 D8 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 E8 66 0F 59 E0 66 0F 59 C3 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 4C 24 30 66 0F 59 6C 24 20 66 0F 58 05 ?? ?? ?? ?? 66 0F 59 4C 24 20 66 0F 59 64 24 30 66 0F 58 C5 66 0F 58 CC 66 0F 58 C1 66 0F 59 44 24 40 66 0F 58 C2 48 83 C4 58 C3 66 90 }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "__sse2_logf4"
		size = 672
		refs = "0012 flMantissaMask 001a s_dwPosInf 0022 s_dwSqrt2Addition 002d s_fOne 003d s_dwSqrt2Mask 0068 s_dwExpBias 009e s_fB2 00b0 s_fB1 00b7 s_fB0 00c4 s_fLn2 0112 s_dwAbsMask 011e s_dwPosZero 0126 s_dwNegInf 0146 s_dwSpecial1 014e s_dwSpecial2 0178 s_fDenoAdd"
	strings:
		$1 = { 48 83 EC 78 0F 29 7C 24 50 0F 29 74 24 60 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 2D ?? ?? ?? ?? 0F 58 EC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 66 0F FE C2 0F 28 D4 0F 5E E5 0F 29 4C 24 40 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 28 EC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 81 FA FF FF 00 00 75 3C 0F 59 DC 0F 59 25 ?? ?? ?? ?? 0F 58 1D ?? ?? ?? ?? 0F 5B C0 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DC 0F 5C DA 0F 59 DD 0F 58 DA 0F 58 C3 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 0F 28 54 24 40 0F 28 F2 66 0F EF FF 66 0F 6F C6 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 6F C6 66 0F DB 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F 76 05 ?? ?? ?? ?? 66 0F DB 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 66 0D ?? ?? ?? ?? 66 0F DB CE 66 0F EB F9 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F EB F8 66 0F 7F 7C 24 20 66 0F 6F C6 66 0F FE 05 ?? ?? ?? ?? 66 0F 66 05 ?? ?? ?? ?? 66 0F 6F C8 66 0F DB 0D ?? ?? ?? ?? 66 0F 7F 4C 24 30 66 0F 6F C8 66 0F 6F D6 66 0F EB 15 ?? ?? ?? ?? 0F 5C 15 ?? ?? ?? ?? 66 0F DB C2 66 0F 76 3D ?? ?? ?? ?? 66 0F DB F7 66 0F DF 3D ?? ?? ?? ?? 66 0F EB FE 66 0F DF CF 66 0F EB C1 66 0F 6F 25 ?? ?? ?? ?? 66 0F 6F 1D ?? ?? ?? ?? 66 0F 6F 15 ?? ?? ?? ?? 66 0F DB E0 0F 28 2D ?? ?? ?? ?? 66 0F FE D4 66 0F 6F C8 66 0F DB 15 ?? ?? ?? ?? 66 0F EF EA 66 0F 72 E2 17 66 0F EB E5 66 0F 72 E0 17 0F 28 3D ?? ?? ?? ?? 0F 58 FC 0F 5C 25 ?? ?? ?? ?? 66 0F FA 05 ?? ?? ?? ?? 0F 28 EC 0F 5E E7 66 0F FE C2 0F 28 D1 66 0F 66 D9 66 0F 66 0D ?? ?? ?? ?? 0F 28 FC 0F 59 E4 66 0F DB D9 0F 28 CC 0F 59 E4 66 0F D7 D3 0F 28 1D ?? ?? ?? ?? 0F 28 15 ?? ?? ?? ?? 0F 59 DC 0F 59 D4 0F 58 1D ?? ?? ?? ?? 0F 5B C0 0F 59 D9 0F 59 05 ?? ?? ?? ?? 0F 58 DA 0F 5C DD 0F 59 DF 0F 58 DD 0F 58 C3 66 0F EB 44 24 20 0F 58 44 24 30 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 78 C3 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "__avx_exp4"
		size = 560
		refs = "000a __common_dexp_data 0229 __common_dexp_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 05 ?? ?? ?? ?? C5 7C 11 94 24 F0 01 00 00 C5 7C 11 84 24 D0 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 6F 01 00 00 C5 FD 10 0D ?? ?? ?? ?? 49 83 E5 C0 C5 FD 59 15 ?? ?? ?? ?? C5 F9 10 25 ?? ?? ?? ?? C5 ED 58 D9 C5 E5 5C C9 C4 E3 7D 19 C5 01 C5 F8 C6 D5 DD C5 68 54 05 ?? ?? ?? ?? C5 39 66 15 ?? ?? ?? ?? C4 C1 78 50 D2 C5 E0 54 EC C4 E3 7D 19 DA 01 C5 D9 DF DB C5 F9 7E E9 C5 68 54 C4 C4 41 79 7E C1 C5 D9 DF E2 C5 E9 73 F4 2A C1 E1 03 C4 C3 79 16 E8 02 41 C1 E0 03 41 C1 E1 03 C4 43 79 16 C2 02 41 C1 E2 03 C4 61 F9 6E 14 01 C4 C1 29 16 2C 00 C4 41 F9 6E 14 01 C4 41 29 16 04 02 C4 43 55 18 C0 01 C5 F5 59 2D ?? ?? ?? ?? C5 F5 59 0D ?? ?? ?? ?? C5 7D 5C D5 C5 2D 5C D1 C5 AD 58 2D ?? ?? ?? ?? C4 C1 55 59 CA C5 F5 58 2D ?? ?? ?? ?? C5 F1 73 F3 2A C4 41 55 59 D2 C5 AD 58 2D ?? ?? ?? ?? C5 3D 59 C5 C4 63 7D 19 C5 01 C5 B9 D4 D9 C5 D1 D4 CA C4 E3 65 18 C9 01 85 D2 75 26 C5 7C 10 84 24 D0 01 00 00 C5 7C 10 94 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FD 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7D 11 45 00 C4 C1 7D 11 4D 40 74 CC 33 C0 C5 FC 11 B4 24 00 01 00 00 C5 FC 11 BC 24 E0 00 00 00 C5 7C 11 8C 24 C0 00 00 00 C5 7C 11 9C 24 A0 00 00 00 C5 7C 11 A4 24 80 00 00 00 C5 7C 11 6C 24 60 C5 7C 11 74 24 40 C5 7C 11 7C 24 20 48 89 9C 24 28 01 00 00 8B D8 48 89 B4 24 20 01 00 00 8B F2 0F A3 DE 72 61 FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 00 01 00 00 C5 FC 10 BC 24 E0 00 00 00 C5 7C 10 8C 24 C0 00 00 00 C5 7C 10 9C 24 A0 00 00 00 C5 7C 10 A4 24 80 00 00 00 C5 7C 10 6C 24 60 C5 7C 10 74 24 40 C5 7C 10 7C 24 20 C4 C1 7D 10 4D 40 48 8B 9C 24 28 01 00 00 48 8B B4 24 20 01 00 00 E9 11 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB 8B 90 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "__vdecl_fmodf8"
		size = 199
		refs = "0011 fmodf"
	strings:
		$1 = { 48 83 EC 68 C5 FE 7F 44 24 20 C5 FE 7F 4C 24 40 E8 ?? ?? ?? ?? 66 0F 7E 44 24 20 66 0F 6E 44 24 24 66 0F 6E 4C 24 44 E8 ?? ?? ?? ?? 66 0F 7E 44 24 24 66 0F 6E 44 24 28 66 0F 6E 4C 24 48 E8 ?? ?? ?? ?? 66 0F 7E 44 24 28 66 0F 6E 44 24 2C 66 0F 6E 4C 24 4C E8 ?? ?? ?? ?? 66 0F 7E 44 24 2C 66 0F 6E 44 24 30 66 0F 6E 4C 24 50 E8 ?? ?? ?? ?? 66 0F 7E 44 24 30 66 0F 6E 44 24 34 66 0F 6E 4C 24 54 E8 ?? ?? ?? ?? 66 0F 7E 44 24 34 66 0F 6E 44 24 38 66 0F 6E 4C 24 58 E8 ?? ?? ?? ?? 66 0F 7E 44 24 38 66 0F 6E 44 24 3C 66 0F 6E 4C 24 5C E8 ?? ?? ?? ?? 66 0F 7E 44 24 3C C5 FE 6F 44 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "?dllmain_crt_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z"
		size = 80
		refs = "0022 __scrt_dllmain_crt_thread_detach 0029 __scrt_dllmain_crt_thread_attach 003d ?dllmain_crt_process_attach@@YAHQEAUHINSTANCE__@@QEAX@Z 004c ?dllmain_crt_process_detach@@YAH_N@Z"
	strings:
		$1 = { 48 83 EC 28 85 D2 74 39 83 EA 01 74 28 83 EA 01 74 16 83 FA 01 74 0A B8 01 00 00 00 48 83 C4 28 C3 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 0F B6 C0 48 83 C4 28 C3 49 8B D0 48 83 C4 28 E9 ?? ?? ?? ?? 4D 85 C0 0F 95 C1 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_372_1_0 {
	meta:
		name = "?dllmain_crt_process_attach@@YAHQEAUHINSTANCE__@@QEAX@Z"
		size = 299
		refs = "001e __scrt_initialize_crt 002e __scrt_acquire_startup_lock 003d __scrt_current_native_startup_state 004a __scrt_fastfail 0059 __scrt_dllmain_before_initialize_c 0062 _RTC_Initialize 0069 _RTC_Terminate 006e atexit 0073 ?__scrt_initialize_type_info@@YAXXZ 007a ?__scrt_uninitialize_type_info@@YAXXZ 0084 __scrt_initialize_default_local_stdio_options 008b __xi_z 0092 __xi_a 0097 _initterm_e 00a0 __scrt_dllmain_after_initialize_c 00ab __xc_z 00b2 __xc_a 00b7 _initterm 00cb __scrt_release_startup_lock 00d9 __scrt_get_dyn_tls_init_callback 00ea __scrt_is_nonwritable_in_current_image 00f9 _guard_check_icall 010c ?__proc_attached@@3HA"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 20 41 56 48 83 EC 20 48 8B F2 4C 8B F1 33 C9 E8 ?? ?? ?? ?? 84 C0 75 07 33 C0 E9 E8 00 00 00 E8 ?? ?? ?? ?? 8A D8 88 44 24 40 40 B7 01 83 3D ?? ?? ?? ?? 00 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 84 C0 74 67 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 29 E8 ?? ?? ?? ?? 84 C0 74 20 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 02 00 00 00 40 32 FF 8A CB E8 ?? ?? ?? ?? 40 84 FF 0F 85 4E FF FF FF E8 ?? ?? ?? ?? 48 8B D8 48 83 38 00 74 24 48 8B C8 E8 ?? ?? ?? ?? 84 C0 74 18 48 8B 1B 48 8B CB E8 ?? ?? ?? ?? 4C 8B C6 BA 02 00 00 00 49 8B CE FF D3 FF 05 ?? ?? ?? ?? B8 01 00 00 00 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_372_2_0 {
	meta:
		name = "?fin$0@?0??dllmain_crt_process_attach@@YAHQEAUHINSTANCE__@@QEAX@Z@4HA"
		size = 23
		refs = "0012 __scrt_release_startup_lock"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8A 4D 40 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_372_3_0 {
	meta:
		name = "?dllmain_crt_process_detach@@YAH_N@Z"
		size = 130
		refs = "0014 ?__proc_attached@@3HA 002b __scrt_acquire_startup_lock 0038 __scrt_current_native_startup_state 0045 __scrt_fastfail 004a __scrt_dllmain_uninitialize_c 0055 __scrt_dllmain_uninitialize_critical 005d __scrt_release_startup_lock 0067 __scrt_uninitialize_crt"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 18 57 48 83 EC 20 40 8A F1 8B 05 ?? ?? ?? ?? 33 DB 85 C0 7F 04 33 C0 EB 50 FF C8 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 8A F8 88 44 24 38 83 3D ?? ?? ?? ?? 02 74 0A B9 07 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 40 8A CF E8 ?? ?? ?? ?? 33 D2 40 8A CE E8 ?? ?? ?? ?? 84 C0 0F 95 C3 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_372_4_0 {
	meta:
		name = "?fin$0@?0??dllmain_crt_process_detach@@YAH_N@Z@4HA"
		size = 28
		refs = "000a __scrt_dllmain_uninitialize_critical 0017 __scrt_release_startup_lock"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA E8 ?? ?? ?? ?? 8A 4D 38 48 83 C4 20 5D E9 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_372_5_0 {
	meta:
		name = "?dllmain_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z"
		size = 245
		refs = "0028 ?__proc_attached@@3HA 003e ?dllmain_raw@@YAHQEAUHINSTANCE__@@KQEAX@Z 0059 ?dllmain_crt_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z 0070 DllMain"
	strings:
		$1 = { 48 8B C4 48 89 58 20 4C 89 40 18 89 50 10 48 89 48 08 56 57 41 56 48 83 EC 40 49 8B F0 8B FA 4C 8B F1 85 D2 75 0F 39 15 ?? ?? ?? ?? 7F 07 33 C0 E9 B2 00 00 00 8D 42 FF 83 F8 01 77 2A E8 ?? ?? ?? ?? 8B D8 89 44 24 30 85 C0 0F 84 8D 00 00 00 4C 8B C6 8B D7 49 8B CE E8 ?? ?? ?? ?? 8B D8 89 44 24 30 85 C0 74 76 4C 8B C6 8B D7 49 8B CE E8 ?? ?? ?? ?? 8B D8 89 44 24 30 83 FF 01 75 2B 85 C0 75 27 4C 8B C6 33 D2 49 8B CE E8 ?? ?? ?? ?? 4C 8B C6 33 D2 49 8B CE E8 ?? ?? ?? ?? 4C 8B C6 33 D2 49 8B CE E8 ?? ?? ?? ?? 85 FF 74 05 83 FF 03 75 2A 4C 8B C6 8B D7 49 8B CE E8 ?? ?? ?? ?? 8B D8 89 44 24 30 85 C0 74 13 4C 8B C6 8B D7 49 8B CE E8 ?? ?? ?? ?? 8B D8 89 44 24 30 EB 06 33 DB 89 5C 24 30 8B C3 48 8B 5C 24 78 48 83 C4 40 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_372_6_0 {
	meta:
		name = "?filt$0@?0??dllmain_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z@4HA"
		size = 54
		refs = "001a ?dllmain_crt_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z 002a __scrt_dllmain_exception_filter"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 01 8B 10 48 89 4C 24 28 89 54 24 20 4C 8D 0D ?? ?? ?? ?? 4C 8B 45 70 8B 55 68 48 8B 4D 60 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_372_7_0 {
	meta:
		name = "?dllmain_raw@@YAHQEAUHINSTANCE__@@KQEAX@Z"
		size = 84
		refs = "0017 _pRawDllMain 0031 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 49 8B F8 8B F2 48 8B E9 48 85 DB 75 05 8D 43 01 EB 12 48 8B CB E8 ?? ?? ?? ?? 4C 8B C7 8B D6 48 8B CD FF D3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_372_9_0 {
	meta:
		name = "_DllMainCRTStartup"
		size = 61
		refs = "001d __security_init_cookie 0039 ?dllmain_dispatch@@YAHQEAUHINSTANCE__@@KQEAX@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B F8 8B DA 48 8B F1 83 FA 01 75 05 E8 ?? ?? ?? ?? 4C 8B C7 8B D3 48 8B CE 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "__sse2_coshf4"
		size = 416
		refs = "0032 __common_scosh_data 0193 __common_scosh_cout_rare"
	strings:
		$1 = { 48 81 EC F8 00 00 00 44 0F 29 AC 24 E0 00 00 00 44 0F 29 94 24 C0 00 00 00 44 0F 29 8C 24 D0 00 00 00 4C 89 AC 24 F0 00 00 00 4C 8D 6C 24 6F 0F 28 1D ?? ?? ?? ?? 49 83 E5 C0 0F 28 15 ?? ?? ?? ?? 0F 55 D8 0F 59 D3 44 0F 28 CB 44 0F 28 2D ?? ?? ?? ?? 66 0F 6F 0D ?? ?? ?? ?? 41 0F 58 D5 66 44 0F 66 C9 66 0F 76 CB 66 44 0F EB C9 0F 28 CA 41 0F 50 D1 66 0F 72 F2 17 44 0F 28 0D ?? ?? ?? ?? 41 0F 5C CD 44 0F 28 2D ?? ?? ?? ?? 85 D2 44 0F 59 E9 44 0F 59 C9 41 0F 5C DD 44 0F 28 15 ?? ?? ?? ?? 41 0F 5C D9 0F 28 CB 0F 59 CB 0F 28 2D ?? ?? ?? ?? 44 0F 59 D1 0F 59 E9 44 0F 58 15 ?? ?? ?? ?? 0F 58 2D ?? ?? ?? ?? 44 0F 59 D1 0F 59 E9 44 0F 59 D3 0F 58 2D ?? ?? ?? ?? 44 0F 58 D3 0F 59 E9 66 0F 6F 25 ?? ?? ?? ?? 66 44 0F 6F CC 66 0F FA E2 66 44 0F FE CA 66 41 0F 6F D1 44 0F 58 CC 0F 5C D4 41 0F 59 E9 41 0F 59 D2 0F 58 D5 41 0F 58 D1 75 2E 44 0F 28 8C 24 D0 00 00 00 0F 28 C2 44 0F 28 94 24 C0 00 00 00 44 0F 28 AC 24 E0 00 00 00 4C 8B AC 24 F0 00 00 00 48 81 C4 F8 00 00 00 C3 41 0F 29 45 00 41 0F 29 55 40 74 C6 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 55 40 EB 8E 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "__sse2_asin2"
		size = 656
		refs = "0049 __common_dasin_data 027c __common_dasin_cout_rare"
	strings:
		$1 = { 48 81 EC 18 01 00 00 44 0F 29 BC 24 E0 00 00 00 44 0F 29 B4 24 00 01 00 00 44 0F 29 9C 24 D0 00 00 00 44 0F 29 8C 24 C0 00 00 00 44 0F 29 84 24 F0 00 00 00 44 0F 28 C0 4C 89 AC 24 10 01 00 00 4C 8D 6C 24 6F 44 0F 28 1D ?? ?? ?? ?? 49 83 E5 C0 0F 28 0D ?? ?? ?? ?? 45 0F 28 F3 45 0F 54 F0 0F 28 E9 66 41 0F 59 EE 0F 28 E1 45 0F 28 FE 66 0F 5C E5 66 45 0F 59 FE 66 0F 5A D4 66 44 0F 5D FC 66 0F 58 E4 0F 16 D2 41 0F 28 EE 44 0F 52 CA 66 0F C2 E9 05 41 0F 5A D1 0F 28 1D ?? ?? ?? ?? 45 0F 55 D8 66 41 0F C2 DE 02 66 0F 50 D3 0F 28 DA 0F 28 05 ?? ?? ?? ?? 44 0F 28 0D ?? ?? ?? ?? 66 0F 59 DA 66 0F 59 D4 66 0F 59 E3 66 41 0F 59 C7 66 0F 5C 25 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 45 0F 59 CF 0F 28 1D ?? ?? ?? ?? 0F 28 CC 66 0F 59 DC 66 0F 59 CA 66 0F 58 1D ?? ?? ?? ?? 66 44 0F 58 0D ?? ?? ?? ?? 66 0F 59 DC 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 DC 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D9 41 0F 28 CF 85 D2 66 41 0F 59 CF 66 0F 5C DA 66 0F 59 C1 0F 28 25 ?? ?? ?? ?? 0F 54 DD 66 41 0F 59 E7 0F 28 15 ?? ?? ?? ?? 66 41 0F 59 D7 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 C4 66 0F 59 D1 0F 28 E1 66 0F 59 E1 66 41 0F 58 D1 66 0F 59 C4 44 0F 28 0D ?? ?? ?? ?? 66 45 0F 59 CF 66 0F 58 C2 66 44 0F 58 0D ?? ?? ?? ?? 66 0F 59 C1 0F 28 15 ?? ?? ?? ?? 66 41 0F 58 C1 66 41 0F 59 D7 66 0F 59 C1 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 C2 66 41 0F 59 C7 44 0F 28 FD 45 0F 55 FE 44 0F 56 FB 66 41 0F 59 C7 66 41 0F 58 C7 44 0F 28 35 ?? ?? ?? ?? 44 0F 54 F5 66 41 0F 58 C6 66 41 0F EF C3 75 3D 44 0F 28 84 24 F0 00 00 00 44 0F 28 8C 24 C0 00 00 00 44 0F 28 9C 24 D0 00 00 00 44 0F 28 B4 24 00 01 00 00 44 0F 28 BC 24 E0 00 00 00 4C 8B AC 24 10 01 00 00 48 81 C4 18 01 00 00 C3 45 0F 29 45 00 41 0F 29 45 40 74 B7 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 1B FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 E9 7C FF FF FF 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D4 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "__avx_floorf8"
		size = 16
	strings:
		$1 = { C4 E3 7D 08 C0 01 C3 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "__sse4_expf4"
		size = 624
		refs = "0003 s_dwExp2_Table 000a s_dwInvLn 0014 s_dwLnHi 001b s_dwBias 0026 flAbsMask 0032 flBound1 0059 s_dwLnLo 00a4 flTwo 0165 flBound2 018e s_dwNegRS 01f2 flInf 0256 flOne"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 59 D8 0F 28 25 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 66 0F 5B D3 0F 28 2D ?? ?? ?? ?? 66 0F DB E8 66 0F 66 2D ?? ?? ?? ?? 0F 50 CD 23 C9 0F 85 7F 00 00 00 0F 28 E8 66 0F 3A 08 DB 00 66 0F 7E D0 0F 59 E3 66 0F C5 D2 02 0F 59 1D ?? ?? ?? ?? 83 E0 3F 83 E2 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C0 66 0F C5 C2 04 41 0F 16 24 D0 66 0F C5 D2 06 0F 5C C3 83 E0 3F 83 E2 3F 66 0F 72 D1 06 F3 41 0F 7E 14 C0 41 0F 16 14 D0 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 0F C6 E2 88 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C1 C3 0F 1F 40 00 0F 28 E8 66 0F 3A 08 DB 00 66 0F 7E D1 0F 59 E3 66 44 0F C5 CA 02 0F 59 1D ?? ?? ?? ?? 83 E1 3F 41 83 E1 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C8 66 44 0F C5 D2 04 43 0F 16 24 C8 66 44 0F C5 DA 06 0F 5C C3 41 83 E2 3F 41 83 E3 3F 66 0F 72 D1 06 F3 43 0F 7E 1C D0 43 0F 16 1C D8 0F C6 E3 88 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C8 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF DA 66 0F DB C3 0F 50 D5 B8 03 00 00 00 23 C2 83 E2 0C 03 C0 0F 28 15 ?? ?? ?? ?? 0F 59 D5 0F 5C 15 ?? ?? ?? ?? 66 0F DB D3 66 0F DB E3 66 0F FE 15 ?? ?? ?? ?? 66 0F 72 D2 06 41 0F 28 9C C0 40 02 00 00 41 0F C6 9C 90 40 02 00 00 88 66 0F FE D3 66 0F 72 F2 17 66 0F EB D4 0F 59 C2 41 0F 28 9C C0 00 02 00 00 41 0F C6 9C 90 00 02 00 00 88 0F 59 C3 66 0F EB C1 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF D3 41 0F 28 8C C0 80 02 00 00 41 0F C6 8C 90 80 02 00 00 88 66 0F DB CA 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 00 41 0F 28 9C C0 C0 02 00 00 41 0F C6 9C 90 C0 02 00 00 88 66 0F DB D3 66 0F EB CA 0F 28 15 ?? ?? ?? ?? 0F C2 D5 03 66 0F DB EA 66 0F EB CD 0F 59 C9 66 0F EB C1 C3 66 90 }
	condition:
		$1
}

rule file_388_0_0 {
	meta:
		name = "__security_init_cookie"
		size = 172
		refs = "001f __security_cookie 002e __imp_GetSystemTimeAsFileTime 003c __imp_GetCurrentThreadId 0048 __imp_GetCurrentProcessId 0058 __imp_QueryPerformanceCounter 00a2 __security_cookie_complement"
	strings:
		$1 = { 48 89 5C 24 20 55 48 8B EC 48 83 EC 20 48 83 65 18 00 48 BB 32 A2 DF 2D 99 2B 00 00 48 8B 05 ?? ?? ?? ?? 48 3B C3 75 6F 48 8D 4D 18 FF 15 ?? ?? ?? ?? 48 8B 45 18 48 89 45 10 FF 15 ?? ?? ?? ?? 8B C0 48 31 45 10 FF 15 ?? ?? ?? ?? 8B C0 48 8D 4D 20 48 31 45 10 FF 15 ?? ?? ?? ?? 8B 45 20 48 8D 4D 10 48 C1 E0 20 48 33 45 20 48 33 45 10 48 33 C1 48 B9 FF FF FF FF FF FF 00 00 48 23 C1 48 B9 33 A2 DF 2D 99 2B 00 00 48 3B C3 48 0F 44 C1 48 89 05 ?? ?? ?? ?? 48 8B 5C 24 48 48 F7 D0 48 89 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "__common_slog_cout_rare"
		size = 720
		refs = "003d _imlsLnHATab 0063 _2il0floatpacket_72 026a _2il0floatpacket_73"
	strings:
		$1 = { 48 83 EC 38 33 C0 44 0F B7 41 02 41 81 E0 80 7F 00 00 41 81 F8 80 7F 00 00 0F 84 60 02 00 00 F3 0F 5A 19 F2 0F 11 5C 24 30 45 33 C0 0F B7 4C 24 36 F7 C1 F0 7F 00 00 75 14 F2 0F 59 1D ?? ?? ?? ?? 41 B8 C4 FF FF FF F2 0F 11 5C 24 30 F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F D8 0F 86 DD 01 00 00 F2 0F 10 05 ?? ?? ?? ?? 0F 28 D3 F2 0F 5C D0 F2 0F 11 54 24 28 80 64 24 2F 7F F2 0F 10 4C 24 28 66 0F 2F 0D ?? ?? ?? ?? 0F 86 43 01 00 00 F2 0F 11 5C 24 28 44 0F B7 4C 24 2E 41 81 E1 0F 80 FF FF 41 81 C9 F0 3F FF FF 66 44 89 4C 24 2E F2 0F 10 6C 24 28 0F 28 DD 0F B7 4C 24 36 81 E1 F0 7F 00 00 F2 0F 58 1D ?? ?? ?? ?? C1 E9 04 F2 0F 11 5C 24 20 0F 28 DD 44 8B 54 24 20 41 83 E2 7F F2 0F 58 1D ?? ?? ?? ?? F2 0F 11 5C 24 20 45 8D 84 08 01 FC FF FF F2 41 0F 2A C8 F2 0F 10 5C 24 20 47 8D 1C 52 48 8D 0D ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 4C 8B C9 F2 0F 10 25 ?? ?? ?? ?? 4C 8B C1 F2 0F 59 D1 F2 0F 5C 1D ?? ?? ?? ?? F2 0F 59 CC F2 0F 5C EB F2 43 0F 58 54 D8 08 F2 43 0F 58 4C D9 10 F2 42 0F 10 24 D9 F2 0F 59 DC F2 0F 59 E5 F2 0F 5C D8 0F 28 C3 F2 0F 58 DA F2 0F 58 C4 F2 0F 58 E1 F2 0F 10 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 59 C0 F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E8 F2 0F 58 E5 F2 0F 58 DC F2 0F 5A DB F3 0F 11 1A 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? 0F 28 C2 F2 0F 59 CA F2 0F 59 C2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 D1 F2 0F 5A D2 F3 0F 11 12 48 83 C4 38 C3 66 0F 2E D8 7A 02 74 16 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 B8 01 00 00 00 48 83 C4 38 C3 F2 0F 10 0D ?? ?? ?? ?? B8 02 00 00 00 0F 57 0D ?? ?? ?? ?? F2 0F 5E C8 F2 0F 5A C9 F3 0F 11 0A 48 83 C4 38 C3 44 8A 41 03 41 80 E0 80 41 80 F8 80 74 11 F3 0F 10 01 F3 0F 59 C0 F3 0F 11 02 48 83 C4 38 C3 F7 01 FF FF 7F 00 75 E7 F2 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F2 0F 5E C0 F2 0F 5A C0 F3 0F 11 02 48 83 C4 38 C3 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "__sse2_acosf4"
		size = 416
		refs = "0031 __common_sacos_data 019a __common_sacos_cout_rare"
	strings:
		$1 = { 48 81 EC F8 00 00 00 44 0F 29 84 24 C0 00 00 00 0F 29 BC 24 D0 00 00 00 0F 29 B4 24 E0 00 00 00 4C 89 AC 24 F0 00 00 00 4C 8D 6C 24 6F 44 0F 28 05 ?? ?? ?? ?? 49 83 E5 C0 41 0F 28 F8 44 0F 54 C0 0F 56 F8 0F 28 15 ?? ?? ?? ?? 0F 28 EF 0F 59 EA 0F 28 E7 0F 59 E7 0F 58 EA 0F 52 D5 0F 5D E5 0F 28 DF 0F 28 CA 0F C2 1D ?? ?? ?? ?? 02 0F 59 CA 0F 50 D3 0F 28 DC 0F 28 35 ?? ?? ?? ?? 0F C2 DD 05 0F 58 ED 0F 59 D5 85 D2 0F 59 E9 0F 28 0D ?? ?? ?? ?? 0F 59 CC 0F 5C 2D ?? ?? ?? ?? 0F 59 F5 0F 58 0D ?? ?? ?? ?? 0F 59 EA 0F 58 35 ?? ?? ?? ?? 0F 59 F5 0F 28 EC 0F 59 EC 0F 5C D6 0F 59 CD 0F 28 35 ?? ?? ?? ?? 0F 28 E8 0F 59 F4 0F 54 D3 0F C2 EC 01 0F 58 35 ?? ?? ?? ?? 0F 58 CE 0F 28 F3 0F 59 CC 0F 55 35 ?? ?? ?? ?? 0F 58 0D ?? ?? ?? ?? 0F 59 CC 0F 28 25 ?? ?? ?? ?? 0F 54 E3 0F 54 E5 0F 28 EB 0F 55 EF 0F 58 F4 0F 56 EA 66 41 0F EF E8 0F 59 CD 0F 58 CD 0F 58 F1 75 2C 0F 28 BC 24 D0 00 00 00 0F 28 C6 0F 28 B4 24 E0 00 00 00 44 0F 28 84 24 C0 00 00 00 4C 8B AC 24 F0 00 00 00 48 81 C4 F8 00 00 00 C3 41 0F 29 45 00 41 0F 29 75 40 74 C8 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 75 40 EB 90 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB D7 }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "_RTC_AllocaHelper"
		size = 53
	strings:
		$1 = { 48 89 7C 24 08 4C 8B C9 48 85 C9 74 22 48 85 D2 74 1D 4D 85 C0 74 18 48 8B F9 B0 CC 48 8B CA F3 AA 49 8B 00 49 89 41 04 49 89 51 0C 4D 89 08 48 8B 7C 24 08 C3 }
	condition:
		$1
}

rule file_398_1_0 {
	meta:
		name = "_RTC_CheckStackVars"
		size = 115
		refs = "0050 ?_RTC_StackFailure@@YAXPEAXPEBD@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 DB 48 8B F2 48 8B E9 39 1A 7E 3E 8B FB 48 8B 56 08 48 63 0C 17 81 7C 29 FC CC CC CC CC 75 11 48 63 44 17 04 48 03 C1 81 3C 28 CC CC CC CC 74 0F 48 8B 4C 24 28 48 8B 54 17 08 E8 ?? ?? ?? ?? FF C3 48 83 C7 10 3B 1E 7C C4 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_398_2_0 {
	meta:
		name = "_RTC_CheckStackVars2"
		size = 231
		refs = "005c ?_RTC_StackFailure@@YAXPEAXPEBD@Z 00a4 ?_RTC_AllocaFailure@@YAXPEAXPEAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 49 8B D8 48 8B F2 4C 8B F1 41 BF CC CC CC CC 48 85 D2 74 3E 33 ED 39 2A 7E 38 33 FF 48 8B 56 08 48 63 0C 17 46 39 7C 31 FC 75 0E 48 63 44 17 04 48 03 C1 46 39 3C 30 74 0F 48 8B 4C 24 38 48 8B 54 17 08 E8 ?? ?? ?? ?? FF C5 48 83 C7 10 3B 2E 7C CA 33 FF 48 8B C3 48 85 DB 74 5A 48 8B 40 04 FF C7 48 85 C0 75 F5 EB 48 44 39 3B 75 12 44 39 7B 14 75 0C 44 39 7B 18 75 06 44 39 7B 1C 74 10 48 8B 4C 24 38 44 8B C7 48 8B D3 E8 ?? ?? ?? ?? 48 8B 43 0C 44 39 7C 18 FC 74 10 48 8B 4C 24 38 44 8B C7 48 8B D3 E8 ?? ?? ?? ?? 48 8B 5B 04 FF CF 48 85 DB 75 B3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "__sse2_cosh2"
		size = 576
		refs = "000a __common_dcosh_data 022b __common_dcosh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 01 00 00 48 8D 05 ?? ?? ?? ?? 44 0F 29 9C 24 00 01 00 00 44 0F 29 94 24 E0 00 00 00 44 0F 29 84 24 C0 00 00 00 0F 29 BC 24 D0 00 00 00 0F 29 B4 24 F0 00 00 00 0F 28 F0 4C 89 AC 24 10 01 00 00 4C 8D 6C 24 6F 0F 28 15 ?? ?? ?? ?? 49 83 E5 C0 0F 28 CA 66 0F 73 D2 0B 0F 28 1D ?? ?? ?? ?? 0F 55 CE 66 0F 59 D9 0F 28 25 ?? ?? ?? ?? 66 0F 58 DC F3 44 0F 7E 05 ?? ?? ?? ?? 66 44 0F 70 D1 DD F3 0F 7E 3D ?? ?? ?? ?? 66 45 0F 66 D0 66 44 0F 70 C3 88 F3 44 0F 7E 1D ?? ?? ?? ?? 66 44 0F DB C7 66 45 0F FA D8 66 41 0F 6F F8 66 41 0F 72 F3 03 66 0F 72 F7 03 66 45 0F 7E D9 66 45 0F 70 DB 01 0F 28 05 ?? ?? ?? ?? 66 45 0F 7E DA 44 0F 28 DB 41 0F 50 D2 66 0F 73 F3 2C 66 44 0F 70 D7 01 0F 28 2D ?? ?? ?? ?? 66 44 0F 5C DC 66 0F 7E F9 66 45 0F 7E D0 0F 28 25 ?? ?? ?? ?? 0F 28 3D ?? ?? ?? ?? 66 41 0F 59 E3 66 41 0F 59 FB 66 0F 5C CC 66 0F 5C CF 44 0F 28 D9 83 E2 03 66 44 0F 59 D9 66 41 0F 59 EB 66 41 0F 59 C3 66 0F 59 E9 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 E9 66 41 0F 59 C3 4D 63 C9 48 63 C9 4D 63 D2 4D 63 C0 F2 45 0F 10 14 01 F2 44 0F 10 04 01 66 45 0F 16 14 02 66 0F DB 1D ?? ?? ?? ?? 66 45 0F 16 04 00 66 44 0F FB D3 66 44 0F D4 C3 66 44 0F FB D2 41 0F 28 D0 66 41 0F 5C D2 66 45 0F 58 C2 66 0F 59 EA 66 41 0F 59 C0 66 0F 58 C5 66 41 0F 58 C0 75 3B 0F 28 B4 24 F0 00 00 00 0F 28 BC 24 D0 00 00 00 44 0F 28 84 24 C0 00 00 00 44 0F 28 94 24 E0 00 00 00 44 0F 28 9C 24 00 01 00 00 4C 8B AC 24 10 01 00 00 48 81 C4 18 01 00 00 C3 41 0F 29 75 00 41 0F 29 45 40 74 B9 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 8B F2 8B CB 41 B8 01 00 00 00 41 D3 E0 41 85 F0 75 18 FF C3 83 FB 20 7C E9 48 8B 5C 24 28 48 8B 74 24 20 41 0F 28 45 40 EB 81 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D7 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "__sse2_log2"
		size = 1040
		refs = "0014 BT_Tbl 001c iExpMask 0061 dbOne 0069 dbLog2Hi 0071 iHi43Bits 008f iBias 00a7 dbLog2Lo 0107 dbZero 0138 dbP5 0140 dbP4 0150 dbP3 0158 dbP2 0168 dbP1 01b7 i00100000 01de i001fffff 0382 s_db1022xLn2Lo 038a s_db1022xLn2 03bc dwInf"
	strings:
		$1 = { 48 81 EC 88 00 00 00 0F 29 74 24 70 0F 29 7C 24 60 4C 8D 15 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 70 E8 B1 66 0F 28 C8 66 0F DB F8 66 0F 70 C0 5F 66 0F 7E E8 8B C8 66 0F 7E C2 25 00 F8 0F 00 81 E2 00 F8 0F 00 05 00 08 00 00 81 C2 00 08 00 00 25 00 F0 1F 00 81 E2 00 F0 1F 00 66 0F EB 3D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D C1 E8 07 C1 EA 07 66 0F 72 D1 14 81 E9 00 00 10 00 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F DB DF 66 0F 5C FB 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 41 0F 7E 24 02 66 41 0F 16 24 12 81 F9 00 00 E0 7F 66 0F 7E C1 0F 83 BE 00 00 00 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 AC 00 00 00 66 0F 59 DC 66 0F 59 FC 66 41 0F 28 44 02 10 66 0F 28 E8 66 41 0F 28 74 12 10 66 0F 14 C6 66 0F 15 EE 66 0F 58 C2 66 0F 28 E0 66 0F C2 05 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F DB C7 66 0F 58 E3 66 0F 58 E0 66 0F DF C7 66 0F 58 FB 66 0F 28 CF 66 0F 59 FF 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F7 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F1 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 F2 66 0F 59 FE 66 0F 58 FD 66 0F 58 C7 66 0F 58 C4 E9 73 02 00 00 66 0F 70 F5 B1 66 0F 6F EE 66 0F 73 F6 20 66 0F 6F CE 66 0F 72 F6 10 66 0F 6F DD 66 0F EB F1 66 0F 29 5C 24 20 66 0F 72 D6 10 66 0F EB EE 66 0F 6F 0D ?? ?? ?? ?? 66 0F 70 ED F5 66 0F FE CD 66 0F 6F E3 66 0F 6F C1 66 0F 66 0D ?? ?? ?? ?? 66 0F 7F 6C 24 30 66 0F 66 05 ?? ?? ?? ?? 66 0F 6F 35 ?? ?? ?? ?? 66 0F 7F 4C 24 40 66 0F EF C8 66 0F 54 E0 66 0F 55 C6 66 0F 7F 4C 24 50 66 0F 54 F1 66 0F 54 CB 66 0F 56 C1 66 0F 5C C6 66 0F 56 C4 66 0F 28 3D ?? ?? ?? ?? 66 0F 70 E8 B1 66 0F 28 C8 66 0F DB F8 66 0F 70 C0 5F 66 0F 7E E8 8B C8 66 0F 7E C2 25 00 F8 0F 00 81 E2 00 F8 0F 00 05 00 08 00 00 81 C2 00 08 00 00 25 00 F0 1F 00 81 E2 00 F0 1F 00 66 0F EB 3D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 C9 0D C1 E8 07 C1 EA 07 66 0F 72 D1 14 81 E9 00 00 10 00 66 0F FA 0D ?? ?? ?? ?? F3 0F E6 C9 66 0F DB DF 66 0F 5C FB 66 0F 59 D1 66 0F 59 0D ?? ?? ?? ?? F3 41 0F 7E 24 02 66 41 0F 16 24 12 81 F9 00 00 E0 7F 66 0F 7E C1 0F 83 C0 FE FF FF 81 E9 00 00 10 00 81 F9 00 00 E0 7F 0F 83 AE FE FF FF 66 0F 59 DC 66 0F 59 FC 66 41 0F 28 44 02 10 66 0F 28 E8 66 41 0F 28 74 12 10 66 0F 14 C6 66 0F 15 EE 66 0F 58 C2 66 0F 28 E0 66 0F C2 05 ?? ?? ?? ?? 00 66 0F 58 E9 66 0F 5C 1D ?? ?? ?? ?? 66 0F DB C7 66 0F 58 E3 66 0F 58 E0 66 0F DF C7 66 0F 58 FB 66 0F 28 CF 66 0F 59 FF 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F7 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 D7 66 0F 59 F1 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 F2 66 0F 59 FE 66 0F 58 FD 66 0F 58 C7 66 0F 58 C4 66 0F 28 3D ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 6F 54 24 40 66 0F 6F 5C 24 30 66 0F 6F 64 24 50 66 0F EF ED 66 0F 54 FC 66 0F 54 CC 66 0F 76 ED 66 0F 58 C7 66 0F 58 C1 66 0F 6F 25 ?? ?? ?? ?? 66 0F 54 C2 66 0F EF D5 66 0F 76 E3 66 0F EF C9 66 0F EF D4 66 0F 72 F3 01 66 0F DB 64 24 20 66 0F 76 D9 66 0F EF D3 66 0F 73 F3 34 66 0F EB D4 66 0F EB D3 66 0F 58 C2 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 88 00 00 00 C3 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_1_1_1 {
	meta:
		name = "_Stoldx"
		size = 600
		refs = "001a __security_cookie 003c _Stopfx 0075 _Stoflt 007d __real@41cdcd6500000000 0090 _LXp_setw 00af _LXp_setn 00d5 _LXp_mulx 00fb _LXp_addx 0113 _LDtento 013e _Stoxflt 0146 __real@41b0000000000000 01ec _LDscale 01fb _LInf 020e _LNan 0228 _LPmsw 0242 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 56 41 57 48 8D 6C 24 D9 48 81 EC 00 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 17 48 8B F1 48 89 4C 24 38 48 8D 4C 24 38 4D 8B F1 41 8B F8 48 8B DA E8 ?? ?? ?? ?? 44 8B E0 41 83 E4 08 4D 85 F6 74 04 41 83 26 00 83 E0 F7 83 F8 01 0F 85 C0 00 00 00 48 8B 54 24 38 4C 8D 4C 24 40 4C 8B C3 C7 44 24 20 03 00 00 00 48 8B CE E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 4D 97 BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 50 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 5B 44 8B 44 24 44 E8 ?? ?? ?? ?? 4C 8B FE BE 01 00 00 00 EB 42 48 8D 45 D7 44 8B CB 4C 8D 45 97 48 89 44 24 20 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 44 8B 44 B4 44 48 8D 4D B7 48 FF C6 8B D3 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 B7 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 49 3B F7 7C B9 03 7C 24 40 48 8D 4C 24 50 8B D7 4D 8B C6 E8 ?? ?? ?? ?? E9 FB 00 00 00 83 F8 02 0F 85 CD 00 00 00 48 8B 54 24 38 4C 8D 4C 24 40 4C 8B C3 C7 44 24 20 03 00 00 00 48 8B CE E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 4D B7 BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 50 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 5B 44 8B 44 24 44 E8 ?? ?? ?? ?? 4C 8B FE BE 01 00 00 00 EB 42 48 8D 45 D7 44 8B CB 4C 8D 45 B7 48 89 44 24 20 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 44 8B 44 B4 44 48 8D 4D 97 48 FF C6 8B D3 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 97 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 49 3B F7 7C B9 4D 8B C6 48 8D 4C 24 50 8B D7 E8 ?? ?? ?? ?? 8B 54 24 40 48 8D 4C 24 30 F2 0F 11 44 24 30 E8 ?? ?? ?? ?? EB 2B 83 F8 03 75 0A F2 0F 10 05 ?? ?? ?? ?? EB 16 BB 04 00 00 00 3B C3 75 0A F2 0F 10 05 ?? ?? ?? ?? EB 03 0F 57 C0 F2 0F 11 44 24 30 45 85 E4 74 12 48 8D 4C 24 30 E8 ?? ?? ?? ?? B9 00 80 00 00 66 31 08 F2 0F 10 44 24 30 48 8B 4D 17 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 00 01 00 00 41 5F 41 5E 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_66_1_1 {
	meta:
		name = "_Stodx"
		size = 600
		refs = "001a __security_cookie 003c _Stopfx 0075 _Stoflt 007d __real@41cdcd6500000000 0090 _Xp_setw 00af _Xp_setn 00d5 _Xp_mulx 00fb _Xp_addx 0113 _Dtento 013e _Stoxflt 0146 __real@41b0000000000000 01ec _Dscale 01fb _Inf 020e _Nan 0228 _Pmsw 0242 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 56 41 57 48 8D 6C 24 D9 48 81 EC 00 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 17 48 8B F1 48 89 4C 24 38 48 8D 4C 24 38 4D 8B F1 41 8B F8 48 8B DA E8 ?? ?? ?? ?? 44 8B E0 41 83 E4 08 4D 85 F6 74 04 41 83 26 00 83 E0 F7 83 F8 01 0F 85 C0 00 00 00 48 8B 54 24 38 4C 8D 4C 24 40 4C 8B C3 C7 44 24 20 03 00 00 00 48 8B CE E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 4D 97 BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 50 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 5B 44 8B 44 24 44 E8 ?? ?? ?? ?? 4C 8B FE BE 01 00 00 00 EB 42 48 8D 45 D7 44 8B CB 4C 8D 45 97 48 89 44 24 20 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 44 8B 44 B4 44 48 8D 4D B7 48 FF C6 8B D3 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 B7 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 49 3B F7 7C B9 03 7C 24 40 48 8D 4C 24 50 8B D7 4D 8B C6 E8 ?? ?? ?? ?? E9 FB 00 00 00 83 F8 02 0F 85 CD 00 00 00 48 8B 54 24 38 4C 8D 4C 24 40 4C 8B C3 C7 44 24 20 03 00 00 00 48 8B CE E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 4D B7 BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 50 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 5B 44 8B 44 24 44 E8 ?? ?? ?? ?? 4C 8B FE BE 01 00 00 00 EB 42 48 8D 45 D7 44 8B CB 4C 8D 45 B7 48 89 44 24 20 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 44 8B 44 B4 44 48 8D 4D 97 48 FF C6 8B D3 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 97 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 49 3B F7 7C B9 4D 8B C6 48 8D 4C 24 50 8B D7 E8 ?? ?? ?? ?? 8B 54 24 40 48 8D 4C 24 30 F2 0F 11 44 24 30 E8 ?? ?? ?? ?? EB 2B 83 F8 03 75 0A F2 0F 10 05 ?? ?? ?? ?? EB 16 BB 04 00 00 00 3B C3 75 0A F2 0F 10 05 ?? ?? ?? ?? EB 03 0F 57 C0 F2 0F 11 44 24 30 45 85 E4 74 12 48 8D 4C 24 30 E8 ?? ?? ?? ?? B9 00 80 00 00 66 31 08 F2 0F 10 44 24 30 48 8B 4D 17 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 00 01 00 00 41 5F 41 5E 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_101_1_1 {
	meta:
		name = "_WStodx"
		size = 600
		refs = "001a __security_cookie 003c _WStopfx 0075 _WStoflt 007d __real@41cdcd6500000000 0090 _Xp_setw 00af _Xp_setn 00d5 _Xp_mulx 00fb _Xp_addx 0113 _Dtento 013e _WStoxflt 0146 __real@41b0000000000000 01ec _Dscale 01fb _Inf 020e _Nan 0228 _Pmsw 0242 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 56 41 57 48 8D 6C 24 D9 48 81 EC 00 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 17 48 8B F1 48 89 4C 24 38 48 8D 4C 24 38 4D 8B F1 41 8B F8 48 8B DA E8 ?? ?? ?? ?? 44 8B E0 41 83 E4 08 4D 85 F6 74 04 41 83 26 00 83 E0 F7 83 F8 01 0F 85 C0 00 00 00 48 8B 54 24 38 4C 8D 4C 24 40 4C 8B C3 C7 44 24 20 03 00 00 00 48 8B CE E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 4D 97 BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 50 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 5B 44 8B 44 24 44 E8 ?? ?? ?? ?? 4C 8B FE BE 01 00 00 00 EB 42 48 8D 45 D7 44 8B CB 4C 8D 45 97 48 89 44 24 20 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 44 8B 44 B4 44 48 8D 4D B7 48 FF C6 8B D3 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 B7 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 49 3B F7 7C B9 03 7C 24 40 48 8D 4C 24 50 8B D7 4D 8B C6 E8 ?? ?? ?? ?? E9 FB 00 00 00 83 F8 02 0F 85 CD 00 00 00 48 8B 54 24 38 4C 8D 4C 24 40 4C 8B C3 C7 44 24 20 03 00 00 00 48 8B CE E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 4D B7 BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 50 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 5B 44 8B 44 24 44 E8 ?? ?? ?? ?? 4C 8B FE BE 01 00 00 00 EB 42 48 8D 45 D7 44 8B CB 4C 8D 45 B7 48 89 44 24 20 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 44 8B 44 B4 44 48 8D 4D 97 48 FF C6 8B D3 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 97 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 49 3B F7 7C B9 4D 8B C6 48 8D 4C 24 50 8B D7 E8 ?? ?? ?? ?? 8B 54 24 40 48 8D 4C 24 30 F2 0F 11 44 24 30 E8 ?? ?? ?? ?? EB 2B 83 F8 03 75 0A F2 0F 10 05 ?? ?? ?? ?? EB 16 BB 04 00 00 00 3B C3 75 0A F2 0F 10 05 ?? ?? ?? ?? EB 03 0F 57 C0 F2 0F 11 44 24 30 45 85 E4 74 12 48 8D 4C 24 30 E8 ?? ?? ?? ?? B9 00 80 00 00 66 31 08 F2 0F 10 44 24 30 48 8B 4D 17 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 00 01 00 00 41 5F 41 5E 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_79_1_1 {
	meta:
		name = "_WStoldx"
		size = 600
		refs = "001a __security_cookie 003c _WStopfx 0075 _WStoflt 007d __real@41cdcd6500000000 0090 _LXp_setw 00af _LXp_setn 00d5 _LXp_mulx 00fb _LXp_addx 0113 _LDtento 013e _WStoxflt 0146 __real@41b0000000000000 01ec _LDscale 01fb _LInf 020e _LNan 0228 _LPmsw 0242 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 56 41 57 48 8D 6C 24 D9 48 81 EC 00 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 17 48 8B F1 48 89 4C 24 38 48 8D 4C 24 38 4D 8B F1 41 8B F8 48 8B DA E8 ?? ?? ?? ?? 44 8B E0 41 83 E4 08 4D 85 F6 74 04 41 83 26 00 83 E0 F7 83 F8 01 0F 85 C0 00 00 00 48 8B 54 24 38 4C 8D 4C 24 40 4C 8B C3 C7 44 24 20 03 00 00 00 48 8B CE E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 4D 97 BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 50 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 5B 44 8B 44 24 44 E8 ?? ?? ?? ?? 4C 8B FE BE 01 00 00 00 EB 42 48 8D 45 D7 44 8B CB 4C 8D 45 97 48 89 44 24 20 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 44 8B 44 B4 44 48 8D 4D B7 48 FF C6 8B D3 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 B7 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 49 3B F7 7C B9 03 7C 24 40 48 8D 4C 24 50 8B D7 4D 8B C6 E8 ?? ?? ?? ?? E9 FB 00 00 00 83 F8 02 0F 85 CD 00 00 00 48 8B 54 24 38 4C 8D 4C 24 40 4C 8B C3 C7 44 24 20 03 00 00 00 48 8B CE E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 48 8D 4D B7 BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4C 24 50 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 5B 44 8B 44 24 44 E8 ?? ?? ?? ?? 4C 8B FE BE 01 00 00 00 EB 42 48 8D 45 D7 44 8B CB 4C 8D 45 B7 48 89 44 24 20 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 44 8B 44 B4 44 48 8D 4D 97 48 FF C6 8B D3 E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 97 8B D3 48 8D 4C 24 50 E8 ?? ?? ?? ?? 49 3B F7 7C B9 4D 8B C6 48 8D 4C 24 50 8B D7 E8 ?? ?? ?? ?? 8B 54 24 40 48 8D 4C 24 30 F2 0F 11 44 24 30 E8 ?? ?? ?? ?? EB 2B 83 F8 03 75 0A F2 0F 10 05 ?? ?? ?? ?? EB 16 BB 04 00 00 00 3B C3 75 0A F2 0F 10 05 ?? ?? ?? ?? EB 03 0F 57 C0 F2 0F 11 44 24 30 45 85 E4 74 12 48 8D 4C 24 30 E8 ?? ?? ?? ?? B9 00 80 00 00 66 31 08 F2 0F 10 44 24 30 48 8B 4D 17 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 00 01 00 00 41 5F 41 5E 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z"
		size = 17
		altNames = "??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z ??$?0$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@U_Zero_then_variadic_args_t@1@@Z ??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@D@std@@@std@@V?$_String_val@U?$_Simple_types@D@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z ??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@G@std@@@std@@V?$_String_val@U?$_Simple_types@G@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@$$V@?$_Compressed_pair@U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@V?$_String_val@U?$_Simple_types@_W@std@@@2@$00@std@@QEAA@U_One_then_variadic_args_t@1@$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z ??0?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ ??0?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ ??0?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 33 C0 48 89 01 48 89 41 18 48 89 41 20 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_4_1 {
	meta:
		name = "??$?0U?$_Wrap_alloc@V?$allocator@D@std@@@std@@X@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@D@std@@@1@@Z"
		size = 69
		refs = "0023 ?_Allocate@std@@YAPEAX_K0_N@Z"
		altNames = "??$?0U?$_Wrap_alloc@V?$allocator@G@std@@@std@@X@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@G@std@@@1@@Z ??$?0U?$_Wrap_alloc@V?$allocator@_W@std@@@std@@X@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@$$QEAU?$_Wrap_alloc@V?$allocator@_W@std@@@1@@Z ??0?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ ??0?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ ??0?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 21 00 BA 10 00 00 00 48 83 61 18 00 48 8B D9 48 83 61 20 00 41 B0 01 8D 4A F1 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 07 0F 57 C0 F3 0F 7F 00 48 8B 03 48 89 18 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_6_1 {
	meta:
		name = "??$_Fgetc@D@std@@YA_NAEADPEAU_iobuf@@@Z"
		size = 36
		refs = "000d fgetc"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B CA E8 ?? ?? ?? ?? 83 F8 FF 75 04 32 C0 EB 04 88 03 B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_7_1 {
	meta:
		name = "??$_Fputc@D@std@@YA_NDPEAU_iobuf@@@Z"
		size = 23
		refs = "0008 fputc"
	strings:
		$1 = { 48 83 EC 28 0F BE C9 E8 ?? ?? ?? ?? 83 F8 FF 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_8_1 {
	meta:
		name = "??$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ"
		size = 72
		refs = "0006 ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@51 0014 ??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@YAXXZ 0021 ??_7_Iostream_error_category@std@@6B@ 0028 ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 0038 atexit"
	strings:
		$1 = { 48 83 EC 28 8B 05 ?? ?? ?? ?? A8 01 75 2E 83 C8 01 48 8D 0D ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 05 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_12_1 {
	meta:
		name = "??$_Ungetc@D@std@@YA_NAEBDPEAU_iobuf@@@Z"
		size = 23
		refs = "0008 ungetc"
	strings:
		$1 = { 48 83 EC 28 0F B6 09 E8 ?? ?? ?? ?? 83 F8 FF 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_35_1 {
	meta:
		name = "??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@DDU_Mbstatet@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$codecvt@DDU_Mbstatet@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_139_1 {
	meta:
		name = "??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@GDU_Mbstatet@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$codecvt@GDU_Mbstatet@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$codecvt@GDU_Mbstatet@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_95_35_1 {
	meta:
		name = "??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@_WDU_Mbstatet@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$codecvt@_WDU_Mbstatet@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_68_60_1 {
	meta:
		name = "??$use_facet@V?$collate@D@std@@@std@@YAAEBV?$collate@D@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$collate@D@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$collate@D@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$collate@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_143_1 {
	meta:
		name = "??$use_facet@V?$collate@G@std@@@std@@YAAEBV?$collate@G@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$collate@G@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$collate@G@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$collate@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_127_2 {
	meta:
		name = "??$use_facet@V?$collate@_W@std@@@std@@YAAEBV?$collate@_W@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$collate@_W@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$collate@_W@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$collate@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_53_24_2 {
	meta:
		name = "??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$ctype@D@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$ctype@D@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_50_37_1 {
	meta:
		name = "??$use_facet@V?$ctype@G@std@@@std@@YAAEBV?$ctype@G@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$ctype@G@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$ctype@G@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$ctype@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_149_1 {
	meta:
		name = "??$use_facet@V?$ctype@_W@std@@@std@@YAAEBV?$ctype@_W@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$ctype@_W@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$ctype@_W@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$ctype@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_68_64_1 {
	meta:
		name = "??$use_facet@V?$messages@D@std@@@std@@YAAEBV?$messages@D@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$messages@D@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$messages@D@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$messages@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_133_2 {
	meta:
		name = "??$use_facet@V?$messages@G@std@@@std@@YAAEBV?$messages@G@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$messages@G@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$messages@G@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$messages@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_135_2 {
	meta:
		name = "??$use_facet@V?$messages@_W@std@@@std@@YAAEBV?$messages@_W@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$messages@_W@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$messages@_W@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$messages@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_11_54_2 {
	meta:
		name = "??$use_facet@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_155_1 {
	meta:
		name = "??$use_facet@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_139_2 {
	meta:
		name = "??$use_facet@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_68_68_1 {
	meta:
		name = "??$use_facet@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_141_2 {
	meta:
		name = "??$use_facet@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_161_1 {
	meta:
		name = "??$use_facet@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_68_70_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$00@std@@@std@@YAAEBV?$moneypunct@D$00@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$moneypunct@D$00@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$moneypunct@D$00@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$moneypunct@D$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_68_72_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@D$0A@@std@@@std@@YAAEBV?$moneypunct@D$0A@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$moneypunct@D$0A@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$moneypunct@D$0A@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$moneypunct@D$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_163_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$00@std@@@std@@YAAEBV?$moneypunct@G$00@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$moneypunct@G$00@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$moneypunct@G$00@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$moneypunct@G$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_147_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@G$0A@@std@@@std@@YAAEBV?$moneypunct@G$0A@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$moneypunct@G$0A@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$moneypunct@G$0A@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$moneypunct@G$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_149_2 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$00@std@@@std@@YAAEBV?$moneypunct@_W$00@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$moneypunct@_W$00@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$moneypunct@_W$00@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$moneypunct@_W$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_169_1 {
	meta:
		name = "??$use_facet@V?$moneypunct@_W$0A@@std@@@std@@YAAEBV?$moneypunct@_W$0A@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$moneypunct@_W$0A@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$moneypunct@_W$0A@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$moneypunct@_W$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_42_1 {
	meta:
		name = "??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_153_2 {
	meta:
		name = "??$use_facet@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_155_2 {
	meta:
		name = "??$use_facet@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_44_1 {
	meta:
		name = "??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_157_2 {
	meta:
		name = "??$use_facet@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_177_1 {
	meta:
		name = "??$use_facet@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_17_34_2 {
	meta:
		name = "??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$numpunct@D@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$numpunct@D@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$numpunct@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_179_1 {
	meta:
		name = "??$use_facet@V?$numpunct@G@std@@@std@@YAAEBV?$numpunct@G@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$numpunct@G@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$numpunct@G@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$numpunct@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_163_2 {
	meta:
		name = "??$use_facet@V?$numpunct@_W@std@@@std@@YAAEBV?$numpunct@_W@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$numpunct@_W@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$numpunct@_W@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$numpunct@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_68_74_1 {
	meta:
		name = "??$use_facet@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_183_1 {
	meta:
		name = "??$use_facet@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_185_1 {
	meta:
		name = "??$use_facet@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_68_76_1 {
	meta:
		name = "??$use_facet@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_169_2 {
	meta:
		name = "??$use_facet@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@YAAEBV?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_40_171_2 {
	meta:
		name = "??$use_facet@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@YAAEBV?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@0@AEBVlocale@0@@Z"
		size = 312
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 0029 ?_Psave@?$_Facetptr@V?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@@std@@2PEBVfacet@locale@2@EB 0035 ?id@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@2V0locale@2@A 0055 ?_Id_cnt@id@locale@std@@0HA 0070 ??1_Lockit@std@@QEAA@XZ 00a1 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 00cf ?_Getcat@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z 00df ??0bad_cast@std@@QEAA@XZ 00e6 _TI2?AVbad_cast@std@@ 00f0 _CxxThrowException 010c _guard_check_icall 0119 ?_Facet_Register@std@@YAXPEAV_Facet_base@1@@Z"
	strings:
		$1 = { 40 55 56 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 78 48 8B E9 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 90 48 8B 35 ?? ?? ?? ?? 48 89 74 24 70 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3D 33 D2 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B 4D 08 48 3B 59 18 73 0A 48 8B 41 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 0F 85 84 00 00 00 40 38 79 24 74 17 E8 ?? ?? ?? ?? 48 3B 58 18 73 0A 48 8B 40 10 48 8B 3C D8 EB 02 33 FF 48 85 FF 75 62 48 85 F6 74 05 48 8B FE EB 58 48 8B D5 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 F8 FF 75 1C 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B 7C 24 70 48 89 3D ?? ?? ?? ?? 48 8B 0F 48 8B 59 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B CF E8 ?? ?? ?? ?? 90 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 78 48 83 C4 40 5F 5E 5D C3 }
	condition:
		$1
}

rule file_2_39_1 {
	meta:
		name = "??0?$_Immortalizer@V_Iostream_error_category@std@@@std@@QEAA@XZ"
		size = 27
		refs = "0008 ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { 48 85 C9 74 12 48 8D 05 ?? ?? ?? ?? 48 C7 41 08 05 00 00 00 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_42_1 {
	meta:
		name = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEBDPEBU_Container_base12@1@@Z"
		size = 28
		altNames = "??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEBGPEBU_Container_base12@1@@Z ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEB_WPEBU_Container_base12@1@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@PEADPEBU_Container_base12@1@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@PEAGPEBU_Container_base12@1@@Z ??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@PEA_WPEBU_Container_base12@1@@Z"
	strings:
		$1 = { 48 83 21 00 48 83 61 08 00 48 89 51 10 4D 85 C0 74 06 49 8B 00 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_51_1 {
	meta:
		name = "??0?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAA@PEAU_iobuf@@@Z"
		size = 59
		refs = "0011 ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ 0018 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 0029 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 45 33 C0 48 8B D3 48 89 07 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C7 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_53_1 {
	meta:
		name = "??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z"
		size = 199
		refs = "002f ??_8?$basic_ostream@DU?$char_traits@D@std@@@std@@7B@ 0039 ??_7?$basic_ios@DU?$char_traits@D@std@@@std@@6B@ 0053 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0077 ?_Init@ios_base@std@@IEAAXXZ 008a ?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z 00a5 ?clear@ios_base@std@@QEAAXH_N@Z 00b2 ?_Addstd@ios_base@std@@SAXPEAV12@@Z"
	strings:
		$1 = { 48 8B C4 48 89 48 08 55 56 57 48 83 EC 30 48 C7 40 D8 FE FF FF FF 48 89 58 10 41 8A F0 48 8B EA 48 8B D9 83 60 18 00 45 85 C9 74 1D 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 05 ?? ?? ?? ?? 48 89 41 10 C7 44 24 60 01 00 00 00 48 8B 01 48 63 48 04 48 8D 05 ?? ?? ?? ?? 48 89 04 19 48 8B 03 48 63 48 04 8D 51 F0 89 54 19 FC 48 8B 03 48 63 78 04 48 03 FB 48 8B CF E8 ?? ?? ?? ?? 48 89 6F 48 48 83 67 50 00 B2 20 48 8B CF E8 ?? ?? ?? ?? 88 47 58 48 83 7F 48 00 75 11 8B 57 10 83 CA 04 45 33 C0 48 8B CF E8 ?? ?? ?? ?? 40 84 F6 74 09 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 58 48 83 C4 30 5F 5E 5D C3 }
	condition:
		$1
}

rule file_2_54_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z@4HA"
		size = 42
		refs = "0020 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 60 83 E0 01 85 C0 74 11 83 65 60 FE 48 8B 4D 50 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_2_55_1 {
	meta:
		name = "??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ"
		size = 174
		refs = "001a ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@ 0027 ??2@YAPEAX_K@Z 0036 ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0D B1 01 E8 ?? ?? ?? ?? 48 89 47 08 EB 02 33 FF 48 89 7B 60 48 8D 43 08 48 89 43 18 48 8D 4B 10 48 89 4B 20 48 8D 43 28 48 89 43 38 48 8D 43 30 48 89 43 40 48 8D 43 48 48 89 43 50 48 8D 43 4C 48 89 43 58 48 83 21 00 48 8B 43 40 48 83 20 00 48 8B 43 58 83 20 00 48 8B 43 18 48 83 20 00 48 8B 43 38 48 83 20 00 48 8B 43 50 83 20 00 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_14_55_1 {
	meta:
		name = "??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@XZ"
		size = 174
		refs = "001a ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@ 0027 ??2@YAPEAX_K@Z 0036 ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0D B1 01 E8 ?? ?? ?? ?? 48 89 47 08 EB 02 33 FF 48 89 7B 60 48 8D 43 08 48 89 43 18 48 8D 4B 10 48 89 4B 20 48 8D 43 28 48 89 43 38 48 8D 43 30 48 89 43 40 48 8D 43 48 48 89 43 50 48 8D 43 4C 48 89 43 58 48 83 21 00 48 8B 43 40 48 83 20 00 48 8B 43 58 83 20 00 48 8B 43 18 48 83 20 00 48 8B 43 38 48 83 20 00 48 8B 43 50 83 20 00 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_95_55_1 {
	meta:
		name = "??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@XZ"
		size = 174
		refs = "001a ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@ 0027 ??2@YAPEAX_K@Z 0036 ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 B9 10 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0D B1 01 E8 ?? ?? ?? ?? 48 89 47 08 EB 02 33 FF 48 89 7B 60 48 8D 43 08 48 89 43 18 48 8D 4B 10 48 89 4B 20 48 8D 43 28 48 89 43 38 48 8D 43 30 48 89 43 40 48 8D 43 48 48 89 43 50 48 8D 43 4C 48 89 43 58 48 83 21 00 48 8B 43 40 48 83 20 00 48 8B 43 58 83 20 00 48 8B 43 18 48 83 20 00 48 8B 43 38 48 83 20 00 48 8B 43 50 83 20 00 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_56_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@$$QEAV01@@Z"
		size = 137
		refs = "0034 ?_Allocate@std@@YAPEAX_K0_N@Z 0076 ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX$$QEAV12@@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B FA 48 8B D9 48 83 21 00 48 83 61 18 00 48 83 61 20 00 41 B0 01 BA 10 00 00 00 8D 4A F1 E8 ?? ?? ?? ?? 90 48 89 03 48 85 C0 74 07 0F 57 C0 F3 0F 7F 00 48 8B 03 48 89 18 48 C7 43 20 0F 00 00 00 48 83 63 18 00 48 83 7B 20 10 72 06 48 8B 43 08 EB 04 48 8D 43 08 C6 00 00 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_57_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z"
		size = 147
		refs = "0038 ?_Allocate@std@@YAPEAX_K0_N@Z 0080 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 48 48 8B FA 48 8B D9 48 83 21 00 48 83 61 18 00 48 83 61 20 00 41 B0 01 BA 10 00 00 00 8D 4A F1 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 07 0F 57 C0 F3 0F 7F 00 48 8B 03 48 89 18 48 C7 43 20 0F 00 00 00 48 83 63 18 00 48 83 7B 20 10 72 06 48 8B 43 08 EB 04 48 8D 43 08 C6 00 00 49 83 C9 FF 45 33 C0 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_59_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z"
		size = 169
		refs = "0039 ?_Allocate@std@@YAPEAX_K0_N@Z 0091 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
	strings:
		$1 = { 48 8B C4 48 89 48 08 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 48 8B F2 48 8B D9 33 FF 48 89 39 48 89 79 18 48 89 79 20 41 B0 01 8D 57 10 8D 4F 01 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 07 0F 57 C0 F3 0F 7F 00 48 8B 03 48 89 18 48 C7 43 20 0F 00 00 00 48 89 7B 18 48 83 7B 20 10 72 06 48 8B 43 08 EB 04 48 8D 43 08 40 88 38 40 38 3E 74 10 48 83 C8 FF 48 FF C0 40 38 3C 06 75 F7 48 8B F8 4C 8B C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_61_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		size = 112
		refs = "002c ?_Allocate@std@@YAPEAX_K0_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 83 21 00 48 83 61 18 00 48 83 61 20 00 41 B0 01 BA 10 00 00 00 8D 4A F1 E8 ?? ?? ?? ?? 90 48 89 03 48 85 C0 74 07 0F 57 C0 F3 0F 7F 00 48 8B 03 48 89 18 48 C7 43 20 0F 00 00 00 48 83 63 18 00 48 83 7B 20 10 72 06 48 8B 43 08 EB 04 48 8D 43 08 C6 00 00 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_62_1 {
	meta:
		name = "??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z"
		size = 155
		refs = "003f ?_Allocate@std@@YAPEAX_K0_N@Z 0083 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z"
	strings:
		$1 = { 48 8B C4 48 89 48 08 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 41 8A F8 48 8B F2 48 8B D9 48 83 21 00 48 83 61 18 00 48 83 61 20 00 41 B0 01 BA 10 00 00 00 8D 4A F1 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 07 0F 57 C0 F3 0F 7F 00 48 8B 03 48 89 18 48 C7 43 20 0F 00 00 00 48 83 63 18 00 48 83 7B 20 10 72 06 48 8B 43 08 EB 04 48 8D 43 08 C6 00 00 44 8A C7 48 8B D6 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_64_1 {
	meta:
		name = "??0?$codecvt@DDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_11_87_2 {
	meta:
		name = "??0?$messages@D@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$messages@D@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_41_265_1 {
	meta:
		name = "??0?$messages@G@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$messages@G@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_41_266_1 {
	meta:
		name = "??0?$messages@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$messages@_W@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_11_88_2 {
	meta:
		name = "??0?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_41_267_1 {
	meta:
		name = "??0?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_40_228_2 {
	meta:
		name = "??0?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_11_89_2 {
	meta:
		name = "??0?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_40_229_2 {
	meta:
		name = "??0?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_40_230_2 {
	meta:
		name = "??0?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_17_48_2 {
	meta:
		name = "??0?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_40_239_2 {
	meta:
		name = "??0?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_40_240_2 {
	meta:
		name = "??0?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_24_63_1 {
	meta:
		name = "??0?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_41_281_1 {
	meta:
		name = "??0?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_41_282_1 {
	meta:
		name = "??0?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 18
		refs = "0003 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_65_1 {
	meta:
		name = "??0?$ctype@D@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 57
		refs = "0009 ??_7?$ctype@D@std@@6B@ 001d _Getctype"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 48 8B C3 0F 11 4B 20 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_2_66_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QEAA@U_Mbstatet@@_J@Z"
		size = 16
	strings:
		$1 = { 48 83 21 00 48 8B C1 4C 89 41 08 48 89 51 10 C3 }
	condition:
		$1
}

rule file_2_67_1 {
	meta:
		name = "??0?$fpos@U_Mbstatet@@@std@@QEAA@_J@Z"
		size = 18
	strings:
		$1 = { 48 83 61 08 00 33 C0 48 89 11 48 89 41 10 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_72_1 {
	meta:
		name = "??0_Generic_error_category@std@@QEAA@XZ"
		size = 22
		refs = "0003 ??_7_Generic_error_category@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 C7 41 08 03 00 00 00 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_73_1 {
	meta:
		name = "??0_Init_cout@std@@QEAA@XZ"
		size = 107
		refs = "0003 ?_Ptr_cin@std@@3PEAV?$basic_istream@DU?$char_traits@D@std@@@1@EA 000a ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0011 ?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA 0033 ?_Ptr_cerr@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA 0052 ?_Ptr_clog@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"
	strings:
		$1 = { 4C 8B 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 4C 8B D1 4D 85 C9 74 13 49 8B 01 48 63 50 04 4E 89 44 0A 50 4C 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 13 48 8B 02 48 63 48 04 4C 89 44 11 50 4C 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 0C 48 8B 02 48 63 48 04 4C 89 44 11 50 49 8B C2 C3 }
	condition:
		$1
}

rule file_86_73_1 {
	meta:
		name = "??0_Init_ushcout@std@@QEAA@XZ"
		size = 107
		refs = "0003 ?_Ptr_wcin@std@@3PEAV?$basic_istream@GU?$char_traits@G@std@@@1@EA 000a ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0011 ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 0033 ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 0052 ?_Ptr_wclog@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"
	strings:
		$1 = { 4C 8B 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 4C 8B D1 4D 85 C9 74 13 49 8B 01 48 63 50 04 4E 89 44 0A 50 4C 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 13 48 8B 02 48 63 48 04 4C 89 44 11 50 4C 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 0C 48 8B 02 48 63 48 04 4C 89 44 11 50 49 8B C2 C3 }
	condition:
		$1
}

rule file_95_73_1 {
	meta:
		name = "??0_Init_wcout@std@@QEAA@XZ"
		size = 107
		refs = "0003 ?_Ptr_wcin@std@@3PEAV?$basic_istream@_WU?$char_traits@_W@std@@@1@EA 000a ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0011 ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 0033 ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 0052 ?_Ptr_wclog@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"
	strings:
		$1 = { 4C 8B 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 4C 8B D1 4D 85 C9 74 13 49 8B 01 48 63 50 04 4E 89 44 0A 50 4C 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 13 48 8B 02 48 63 48 04 4C 89 44 11 50 4C 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 85 D2 74 0C 48 8B 02 48 63 48 04 4C 89 44 11 50 49 8B C2 C3 }
	condition:
		$1
}

rule file_2_74_1 {
	meta:
		name = "??0_Iostream_error_category@std@@QEAA@XZ"
		size = 22
		refs = "0003 ??_7_Iostream_error_category@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 C7 41 08 05 00 00 00 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_76_1 {
	meta:
		name = "??0_Locinfo@std@@QEAA@PEBD@Z"
		size = 150
		refs = "0021 ??0_Lockit@std@@QEAA@H@Z 005c ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@ 0066 ??0runtime_error@std@@QEAA@PEBD@Z 006d _TI2?AVruntime_error@std@@ 0077 _CxxThrowException 0083 ?_Locinfo_ctor@_Locinfo@std@@SAXPEAV12@PEBD@Z"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 40 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 58 48 8B FA 48 8B D9 33 D2 E8 ?? ?? ?? ?? 90 33 C0 48 89 43 08 88 43 10 48 89 43 18 88 43 20 48 89 43 28 66 89 43 30 48 89 43 38 66 89 43 40 48 89 43 48 88 43 50 48 89 43 58 88 43 60 48 85 FF 75 23 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? CC 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_2_78_1 {
	meta:
		name = "?dtor$1@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 16
		refs = "000c ??1?$_Yarn@D@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_79_1 {
	meta:
		name = "?dtor$2@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 16
		refs = "000c ??1?$_Yarn@D@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_80_1 {
	meta:
		name = "?dtor$3@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 16
		refs = "000c ??1?$_Yarn@_W@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_81_1 {
	meta:
		name = "?dtor$4@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 16
		refs = "000c ??1?$_Yarn@_W@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 38 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_82_1 {
	meta:
		name = "?dtor$5@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 16
		refs = "000c ??1?$_Yarn@D@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 48 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_83_1 {
	meta:
		name = "?dtor$6@?0???0_Locinfo@std@@QEAA@PEBD@Z@4HA"
		size = 16
		refs = "000c ??1?$_Yarn@D@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B 8A 50 00 00 00 48 83 C1 58 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_84_1 {
	meta:
		name = "??0_System_error@std@@IEAA@Verror_code@1@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 235
		refs = "0010 __security_cookie 002e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z 0049 ?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z 006a ??_7exception@std@@6B@ 0085 __std_exception_copy 008c ??_7runtime_error@std@@6B@ 009e ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 00b1 ?_Deallocate@std@@YAXPEAX_K1@Z 00b8 ??_7_System_error@std@@6B@ 00d6 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 20 57 48 81 EC 90 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 80 00 00 00 48 8B FA 48 8B D9 49 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 0F 10 07 4C 8B C0 48 8D 54 24 20 48 8D 4C 24 58 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 48 83 78 20 10 72 06 48 8B 40 08 EB 04 48 83 C0 08 48 8D 53 08 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? C6 44 24 28 01 48 89 0B 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 45 33 C0 B2 01 48 89 03 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 4C 24 58 BA 01 00 00 00 44 8D 42 0F E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 0F 10 07 F3 0F 7F 43 18 48 8B 8C 24 80 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B8 00 00 00 48 81 C4 90 00 00 00 5F C3 }
	condition:
		$1
}

rule file_2_85_1 {
	meta:
		name = "??0_System_error@std@@QEAA@AEBV01@@Z"
		size = 81
		refs = "0010 ??_7exception@std@@6B@ 002c __std_exception_copy 0033 ??_7_System_error@std@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 51 08 33 C0 48 8B F9 48 89 02 48 8D 4B 08 48 89 42 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 8B C7 0F 10 43 18 48 8B 5C 24 30 F3 0F 7F 47 18 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_32_3_1 {
	meta:
		name = "??0future_error@std@@QEAA@AEBV01@@Z"
		size = 81
		refs = "0010 ??_7exception@std@@6B@ 002c __std_exception_copy 0033 ??_7future_error@std@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 51 08 33 C0 48 8B F9 48 89 02 48 8D 4B 08 48 89 42 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 8B C7 0F 10 43 18 48 8B 5C 24 30 F3 0F 7F 47 18 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_88_1 {
	meta:
		name = "??0codecvt_base@std@@QEAA@_K@Z"
		size = 17
		refs = "0003 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_111_89_1 {
	meta:
		name = "??0ctype_base@std@@QEAA@_K@Z"
		size = 17
		refs = "0003 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_108_76_2 {
	meta:
		name = "??0facet@locale@std@@IEAA@_K@Z"
		size = 17
		refs = "0003 ??_7facet@locale@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_40_276_2 {
	meta:
		name = "??0messages_base@std@@QEAA@_K@Z"
		size = 17
		refs = "0003 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_68_144_1 {
	meta:
		name = "??0money_base@std@@QEAA@_K@Z"
		size = 17
		refs = "0003 ??_7money_base@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_68_147_1 {
	meta:
		name = "??0time_base@std@@QEAA@_K@Z"
		size = 17
		refs = "0003 ??_7time_base@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_60_3_2 {
	meta:
		name = "?resetiosflags@std@@YA?AU?$_Smanip@H@1@H@Z"
		size = 17
		refs = "0003 ?rsfun@std@@YAXAEAVios_base@1@H@Z"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_60_6_2 {
	meta:
		name = "?setbase@std@@YA?AU?$_Smanip@H@1@H@Z"
		size = 17
		refs = "0003 ?sbfun@std@@YAXAEAVios_base@1@H@Z"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_60_8_2 {
	meta:
		name = "?setiosflags@std@@YA?AU?$_Smanip@H@1@H@Z"
		size = 17
		refs = "0003 ?sifun@std@@YAXAEAVios_base@1@H@Z"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 89 51 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_90_1 {
	meta:
		name = "??0error_category@std@@QEAA@XZ"
		size = 18
		refs = "0003 ??_7error_category@std@@6B@"
	strings:
		$1 = { 48 8D 05 ?? ?? ?? ?? 48 89 49 08 48 89 01 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_94_1 {
	meta:
		name = "??0exception@std@@QEAA@QEBD@Z"
		size = 64
		refs = "0014 ??_7exception@std@@6B@ 0033 __std_exception_copy"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B D9 C6 44 24 28 01 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 44 24 20 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_97_1 {
	meta:
		name = "??0failure@ios_base@std@@QEAA@AEBV012@@Z"
		size = 91
		refs = "0010 ??_7exception@std@@6B@ 002c __std_exception_copy 0033 ??_7_System_error@std@@6B@ 003d ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 51 08 33 C0 48 8B F9 48 89 02 48 8D 4B 08 48 89 42 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 8D 05 ?? ?? ?? ?? 0F 10 43 18 48 8B 5C 24 30 48 89 07 48 8B C7 F3 0F 7F 47 18 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_71_86_2 {
	meta:
		name = "??0system_error@std@@QEAA@AEBV01@@Z"
		size = 91
		refs = "0010 ??_7exception@std@@6B@ 002c __std_exception_copy 0033 ??_7_System_error@std@@6B@ 003d ??_7system_error@std@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 51 08 33 C0 48 8B F9 48 89 02 48 8D 4B 08 48 89 42 08 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 8D 05 ?? ?? ?? ?? 0F 10 43 18 48 8B 5C 24 30 48 89 07 48 8B C7 F3 0F 7F 47 18 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_98_1 {
	meta:
		name = "??0failure@ios_base@std@@QEAA@PEBDAEBVerror_code@2@@Z"
		size = 51
		refs = "001c ??0system_error@std@@QEAA@Verror_code@1@PEBD@Z 0023 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 30 41 0F 10 00 4C 8B C2 48 8B D9 48 8D 54 24 20 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_101_1 {
	meta:
		name = "??0locale@std@@QEAA@AEBV01@@Z"
		size = 77
		refs = "002f _guard_check_icall"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 89 74 24 48 48 8B F1 48 8B 7A 08 48 89 79 08 48 8B 07 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 90 48 8B CF FF D3 90 48 8B C6 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_102_1 {
	meta:
		name = "??0locale@std@@QEAA@XZ"
		size = 39
		refs = "0015 ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 B1 01 E8 ?? ?? ?? ?? 90 48 89 43 08 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_104_1 {
	meta:
		name = "??0runtime_error@std@@QEAA@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 88
		refs = "0026 ??_7exception@std@@6B@ 0041 __std_exception_copy 0048 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 30 48 83 7A 20 10 48 8B D9 72 06 48 8B 42 08 EB 04 48 8D 42 08 48 8D 53 08 48 89 44 24 20 48 8D 0D ?? ?? ?? ?? C6 44 24 28 01 48 89 0B 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_105_1 {
	meta:
		name = "??0runtime_error@std@@QEAA@PEBD@Z"
		size = 74
		refs = "0014 ??_7exception@std@@6B@ 0033 __std_exception_copy 003a ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B D9 C6 44 24 28 01 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 44 24 20 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_104_9_1 {
	meta:
		name = "??0invalid_argument@std@@QEAA@PEBD@Z"
		size = 74
		refs = "0014 ??_7exception@std@@6B@ 0033 __std_exception_copy 003a ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B D9 C6 44 24 28 01 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 44 24 20 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_104_11_1 {
	meta:
		name = "??0length_error@std@@QEAA@PEBD@Z"
		size = 74
		refs = "0014 ??_7exception@std@@6B@ 0033 __std_exception_copy 003a ??_7length_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B D9 C6 44 24 28 01 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 44 24 20 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_32_6_1 {
	meta:
		name = "??0logic_error@std@@QEAA@PEBD@Z"
		size = 74
		refs = "0014 ??_7exception@std@@6B@ 0033 __std_exception_copy 003a ??_7logic_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B D9 C6 44 24 28 01 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 44 24 20 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_104_15_1 {
	meta:
		name = "??0out_of_range@std@@QEAA@PEBD@Z"
		size = 74
		refs = "0014 ??_7exception@std@@6B@ 0033 __std_exception_copy 003a ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B D9 C6 44 24 28 01 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 44 24 20 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_104_17_1 {
	meta:
		name = "??0overflow_error@std@@QEAA@PEBD@Z"
		size = 74
		refs = "0014 ??_7exception@std@@6B@ 0033 __std_exception_copy 003a ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 30 48 8B D9 C6 44 24 28 01 48 8B C2 48 8D 0D ?? ?? ?? ?? 48 89 44 24 20 48 89 0B 48 8D 53 08 33 C9 48 89 0A 48 89 4A 08 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_107_1 {
	meta:
		name = "??0system_error@std@@QEAA@Verror_code@1@PEBD@Z"
		size = 156
		refs = "0017 __security_cookie 0031 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z 004d ??0_System_error@std@@IEAA@Verror_code@1@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 005d ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0070 ?_Deallocate@std@@YAXPEAX_K1@Z 0077 ??_7system_error@std@@6B@ 008a __security_check_cookie"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 70 49 C7 43 A8 FE FF FF FF 49 89 5B 20 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 68 48 8B DA 48 8B F9 49 8B D0 49 8D 4B C8 E8 ?? ?? ?? ?? 90 0F 10 03 F3 0F 7F 44 24 30 4C 8D 44 24 40 48 8D 54 24 30 48 8B CF E8 ?? ?? ?? ?? 90 45 33 C0 B2 01 48 8D 4C 24 40 E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 8B C7 48 8B 4C 24 68 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 98 00 00 00 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_2_112_1 {
	meta:
		name = "??1?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAA@XZ"
		size = 36
		refs = "0016 ?_Deallocate@std@@YAXPEAX_K1@Z"
		altNames = "??1?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAA@XZ ??1?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAA@XZ ?_Free_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAXXZ ?_Free_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAXXZ ?_Free_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 01 00 00 00 48 8B D9 48 8B 09 44 8D 42 0F E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_116_1 {
	meta:
		name = "??1?$_Yarn@D@std@@QEAA@XZ"
		size = 32
		refs = "0012 free"
		altNames = "??1?$_Yarn@_W@std@@QEAA@XZ ?_Tidy@?$_Yarn@D@std@@AEAAXXZ ?_Tidy@?$_Yarn@_W@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_118_1 {
	meta:
		name = "??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 172
		refs = "0015 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 0067 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ 0074 fclose 0083 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z 008b ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@ 00a1 ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 48 83 B9 80 00 00 00 00 74 2D 4C 8B 41 18 48 8D 41 70 49 39 00 75 20 48 8B 91 90 00 00 00 48 8B 89 88 00 00 00 49 89 08 48 8B 43 38 48 89 08 2B D1 48 8B 43 50 89 10 80 7B 7C 00 74 2F 48 83 BB 80 00 00 00 00 74 16 48 8B CB E8 ?? ?? ?? ?? 90 48 8B 8B 80 00 00 00 E8 ?? ?? ?? ?? 90 33 D2 44 8D 42 02 48 8B CB E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B 4B 60 48 85 C9 74 0B BA 01 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_119_1 {
	meta:
		name = "??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 34
		refs = "0010 ??_7ios_base@std@@6B@ 0018 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
		altNames = "??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ ??1ios_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_2_120_1 {
	meta:
		name = "??1?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 38
		refs = "000b ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@"
	strings:
		$1 = { 48 8B 41 F0 48 63 50 04 48 8D 05 ?? ?? ?? ?? 48 89 44 0A F0 48 8B 41 F0 48 63 50 04 44 8D 42 F0 44 89 44 0A EC C3 }
	condition:
		$1
}

rule file_14_119_1 {
	meta:
		name = "??1?$basic_ostream@GU?$char_traits@G@std@@@std@@UEAA@XZ"
		size = 38
		refs = "000b ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@"
	strings:
		$1 = { 48 8B 41 F0 48 63 50 04 48 8D 05 ?? ?? ?? ?? 48 89 44 0A F0 48 8B 41 F0 48 63 50 04 44 8D 42 F0 44 89 44 0A EC C3 }
	condition:
		$1
}

rule file_95_119_1 {
	meta:
		name = "??1?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
		size = 38
		refs = "000b ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@"
	strings:
		$1 = { 48 8B 41 F0 48 63 50 04 48 8D 05 ?? ?? ?? ?? 48 89 44 0A F0 48 8B 41 F0 48 63 50 04 44 8D 42 F0 44 89 44 0A EC C3 }
	condition:
		$1
}

rule file_2_121_1 {
	meta:
		name = "??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ"
		size = 38
		refs = "0007 ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@ 001d ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B 49 60 48 85 C9 74 0A BA 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_14_120_1 {
	meta:
		name = "??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
		size = 38
		refs = "0007 ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@ 001d ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B 49 60 48 85 C9 74 0A BA 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_95_120_1 {
	meta:
		name = "??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
		size = 38
		refs = "0007 ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@ 001d ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 83 EC 28 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B 49 60 48 85 C9 74 0A BA 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_122_1 {
	meta:
		name = "??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
		size = 46
		refs = "000f ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0020 ?_Deallocate@std@@YAXPEAX_K1@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 45 33 C0 B2 01 48 8B D9 E8 ?? ?? ?? ?? 48 8B 0B BA 01 00 00 00 44 8D 42 0F E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_345_1 {
	meta:
		name = "??1?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@XZ"
		size = 46
		refs = "000f ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 0020 ?_Deallocate@std@@YAXPEAX_K1@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 45 33 C0 B2 01 48 8B D9 E8 ?? ?? ?? ?? 48 8B 0B BA 01 00 00 00 44 8D 42 0F E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_346_1 {
	meta:
		name = "??1?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@XZ"
		size = 46
		refs = "000f ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 0020 ?_Deallocate@std@@YAXPEAX_K1@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 45 33 C0 B2 01 48 8B D9 E8 ?? ?? ?? ?? 48 8B 0B BA 01 00 00 00 44 8D 42 0F E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_124_1 {
	meta:
		name = "??1?$ctype@D@std@@MEAA@XZ"
		size = 73
		refs = "0009 ??_7?$ctype@D@std@@6B@ 001f free 002c ??_V@YAXPEAX@Z 003c ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 8B 41 20 85 C0 7E 0B 48 8B 49 18 E8 ?? ?? ?? ?? EB 0B 79 09 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_131_1 {
	meta:
		name = "??1_Locinfo@std@@QEAA@XZ"
		size = 157
		refs = "0013 ?_Locinfo_dtor@_Locinfo@std@@SAXPEAV12@@Z 0022 free 0099 ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 E8 ?? ?? ?? ?? 90 48 8B 4B 58 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 83 63 58 00 48 8B 4B 48 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 83 63 48 00 48 8B 4B 38 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 83 63 38 00 48 8B 4B 28 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 83 63 28 00 48 8B 4B 18 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 83 63 18 00 48 8B 4B 08 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 83 63 08 00 48 8B CB 48 83 C4 30 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_141_1 {
	meta:
		name = "??1locale@std@@QEAA@XZ"
		size = 96
		refs = "0028 _guard_check_icall"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B 79 08 48 85 FF 74 38 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 90 48 8B CF FF D3 90 48 8B F8 48 85 C0 74 1A 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? 90 BA 01 00 00 00 48 8B CF FF D3 90 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_146_1 {
	meta:
		name = "??8std@@YA_NAEBVerror_condition@0@0@Z"
		size = 33
	strings:
		$1 = { 48 8B 42 08 4C 8B 49 08 4C 8B 40 08 4D 39 41 08 75 0C 8B 02 39 01 75 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_2_148_1 {
	meta:
		name = "??Bid@locale@std@@QEAA_KXZ"
		size = 71
		refs = "0017 ??0_Lockit@std@@QEAA@H@Z 0023 ?_Id_cnt@id@locale@std@@0HA 003a ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 83 39 00 48 8B D9 75 2F 33 D2 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 3B 00 75 13 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 03 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_149_1 {
	meta:
		name = "??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEBDXZ"
		size = 86
		refs = "0045 _invalid_parameter_noinfo_noreturn"
		altNames = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEADXZ"
	strings:
		$1 = { 48 83 EC 28 48 8B 41 10 48 85 C0 74 37 48 8B 09 48 85 C9 74 3B 48 8B 09 48 85 C9 74 33 48 83 79 20 10 72 06 48 8B 51 08 EB 04 48 8D 51 08 48 3B D0 77 17 48 8B 49 18 48 03 D1 48 3B C2 73 0B 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_151_1 {
	meta:
		name = "??_D?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"
		size = 75
		refs = "001c ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0039 ??_7ios_base@std@@6B@ 0041 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 83 C1 10 48 8B 41 F0 48 63 50 04 48 8D 05 ?? ?? ?? ?? 48 89 44 0A F0 48 8B 41 F0 48 63 50 04 44 8D 42 F0 44 89 44 0A EC 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_14_150_1 {
	meta:
		name = "??_D?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
		size = 75
		refs = "001c ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0039 ??_7ios_base@std@@6B@ 0041 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 83 C1 10 48 8B 41 F0 48 63 50 04 48 8D 05 ?? ?? ?? ?? 48 89 44 0A F0 48 8B 41 F0 48 63 50 04 44 8D 42 F0 44 89 44 0A EC 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_95_150_1 {
	meta:
		name = "??_D?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
		size = 75
		refs = "001c ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0039 ??_7ios_base@std@@6B@ 0041 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 83 C1 10 48 8B 41 F0 48 63 50 04 48 8D 05 ?? ?? ?? ?? 48 89 44 0A F0 48 8B 41 F0 48 63 50 04 44 8D 42 F0 44 89 44 0A EC 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_2_153_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 52
		refs = "0010 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 0022 ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 0D BA 98 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_152_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 52
		refs = "0010 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 0022 ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 0D BA 98 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_95_152_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 52
		refs = "0010 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 0022 ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 E8 ?? ?? ?? ?? F6 C3 01 74 0D BA 98 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_154_1 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 74
		refs = "001c ??_7ios_base@std@@6B@ 0024 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0037 ??3@YAXPEAX_K@Z"
		altNames = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z ??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 8B DA 48 8B F9 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 F6 C3 01 74 0E BA 60 00 00 00 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C7 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_155_1 {
	meta:
		name = "??_G?$basic_ostream@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 110
		refs = "0024 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0048 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 005b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 8B DA 48 8D 79 F0 48 8B 07 4C 63 40 04 48 8D 05 ?? ?? ?? ?? 49 89 44 08 F0 48 8B 07 4C 63 40 04 45 8D 48 F0 45 89 4C 08 EC 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 F6 C3 01 74 0E BA 70 00 00 00 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C7 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_14_154_1 {
	meta:
		name = "??_G?$basic_ostream@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 110
		refs = "0024 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0048 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 005b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 8B DA 48 8D 79 F0 48 8B 07 4C 63 40 04 48 8D 05 ?? ?? ?? ?? 49 89 44 08 F0 48 8B 07 4C 63 40 04 45 8D 48 F0 45 89 4C 08 EC 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 F6 C3 01 74 0E BA 70 00 00 00 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C7 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_95_154_1 {
	meta:
		name = "??_G?$basic_ostream@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 110
		refs = "0024 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0048 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 005b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 8B DA 48 8D 79 F0 48 8B 07 4C 63 40 04 48 8D 05 ?? ?? ?? ?? 49 89 44 08 F0 48 8B 07 4C 63 40 04 45 8D 48 F0 45 89 4C 08 EC 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 F6 C3 01 74 0E BA 70 00 00 00 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C7 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_156_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 77
		refs = "000d ??_7?$basic_streambuf@DU?$char_traits@D@std@@@std@@6B@ 0028 ??_Glocale@std@@QEAAPEAXI@Z 003b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 8B FA 48 8B 49 60 48 85 C9 74 0A BA 01 00 00 00 E8 ?? ?? ?? ?? 40 F6 C7 01 74 0D BA 68 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_155_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 77
		refs = "000d ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@ 0028 ??_Glocale@std@@QEAAPEAXI@Z 003b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 8B FA 48 8B 49 60 48 85 C9 74 0A BA 01 00 00 00 E8 ?? ?? ?? ?? 40 F6 C7 01 74 0D BA 68 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_95_155_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 77
		refs = "000d ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@ 0028 ??_Glocale@std@@QEAAPEAXI@Z 003b ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 8B FA 48 8B 49 60 48 85 C9 74 0A BA 01 00 00 00 E8 ?? ?? ?? ?? 40 F6 C7 01 74 0D BA 68 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_157_1 {
	meta:
		name = "??_G?$codecvt@DDU_Mbstatet@@@std@@MEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7_Facet_base@std@@6B@ 001e ??3@YAXPEAX_K@Z"
		altNames = "??_G?$messages@D@std@@MEAAPEAXI@Z ??_G?$messages@G@std@@MEAAPEAXI@Z ??_G?$messages@_W@std@@MEAAPEAXI@Z ??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z ??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z ??_Gcodecvt_base@std@@UEAAPEAXI@Z ??_Gctype_base@std@@UEAAPEAXI@Z ??_Gfacet@locale@std@@MEAAPEAXI@Z ??_Gmessages_base@std@@UEAAPEAXI@Z ??_Gmoney_base@std@@UEAAPEAXI@Z ??_Gtime_base@std@@UEAAPEAXI@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 10 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_111_159_1 {
	meta:
		name = "??_G_Generic_error_category@std@@UEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7error_category@std@@6B@ 001e ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 10 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_24_135_2 {
	meta:
		name = "??_G_Iostream_error_category@std@@UEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7error_category@std@@6B@ 001e ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 10 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_69_2 {
	meta:
		name = "??_G_Ref_count_base@std@@UEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7_Ref_count_base@std@@6B@ 001e ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 10 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_92_98_1 {
	meta:
		name = "??_G_System_error_category@std@@UEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7error_category@std@@6B@ 001e ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 10 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_14_165_1 {
	meta:
		name = "??_Gerror_category@std@@UEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7error_category@std@@6B@ 001e ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 10 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_158_1 {
	meta:
		name = "??_G?$ctype@D@std@@MEAAPEAXI@Z"
		size = 106
		refs = "000d ??_7?$ctype@D@std@@6B@ 0025 free 0032 ??_V@YAXPEAX@Z 0042 ??_7_Facet_base@std@@6B@ 0058 ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 8B FA 48 89 01 48 8B D9 8B 41 20 85 C0 7E 0B 48 8B 49 18 E8 ?? ?? ?? ?? EB 0B 79 09 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 40 F6 C7 01 74 0D BA 30 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_159_1 {
	meta:
		name = "??_G_Facet_base@std@@UEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7_Facet_base@std@@6B@ 001e ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 08 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_162_1 {
	meta:
		name = "??_G_System_error@std@@UEAAPEAXI@Z"
		size = 66
		refs = "000d ??_7exception@std@@6B@ 001e __std_exception_destroy 0030 ??3@YAXPEAX_K@Z"
		altNames = "??_Gfailure@ios_base@std@@UEAAPEAXI@Z ??_Gfuture_error@std@@UEAAPEAXI@Z ??_Gsystem_error@std@@UEAAPEAXI@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B F9 48 89 01 8B DA 48 83 C1 08 E8 ?? ?? ?? ?? F6 C3 01 74 0D BA 28 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_170_1 {
	meta:
		name = "??_Gios_base@std@@UEAAPEAXI@Z"
		size = 74
		refs = "001c ??_7ios_base@std@@6B@ 0024 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z 0037 ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 8B DA 48 8B F9 48 8D 05 ?? ?? ?? ?? 48 89 01 E8 ?? ?? ?? ?? 90 F6 C3 01 74 0E BA 48 00 00 00 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C7 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_171_1 {
	meta:
		name = "??_Glocale@std@@QEAAPEAXI@Z"
		size = 142
		refs = "0035 _guard_check_icall 0071 ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 08 48 89 68 10 48 89 70 18 8B EA 48 8B F9 48 8B 71 08 48 85 F6 74 38 48 8B 06 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 90 48 8B CE FF D3 90 48 8B F0 48 85 C0 74 1A 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? 90 BA 01 00 00 00 48 8B CE FF D3 90 40 F6 C5 01 74 0E BA 10 00 00 00 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C7 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_174_1 {
	meta:
		name = "??__Ecout@std@@YAXXZ"
		size = 48
		refs = "000d ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0017 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 001c ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0023 ??__Fcout@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_174_1 {
	meta:
		name = "??__Ecerr@std@@YAXXZ"
		size = 48
		refs = "000d ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0017 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 001c ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0023 ??__Fcerr@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_149_2 {
	meta:
		name = "??__Ecin@std@@YAXXZ"
		size = 48
		refs = "000d ?fin@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0017 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 001c ??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0023 ??__Fcin@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_174_1 {
	meta:
		name = "??__Eclog@std@@YAXXZ"
		size = 48
		refs = "000d ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 0017 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 001c ??0?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z 0023 ??__Fclog@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_175_1 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 48
		refs = "000d ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcerr@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_108_150_2 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 48
		refs = "000d ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcerr@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_150_2 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 48
		refs = "000d ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcerr@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_175_1 {
	meta:
		name = "??__Ewcerr@std@@YAXXZ"
		size = 48
		refs = "000d ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcerr@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_175_1 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 48
		refs = "000d ?wfin@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_istream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcin@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_150_2 {
	meta:
		name = "??__Ewcin@std@@YAXXZ"
		size = 48
		refs = "000d ?wfin@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_istream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcin@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_175_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 48
		refs = "000d ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwclog@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_175_1 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 48
		refs = "000d ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwclog@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_150_2 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 48
		refs = "000d ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwclog@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_150_2 {
	meta:
		name = "??__Ewclog@std@@YAXXZ"
		size = 48
		refs = "000d ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwclog@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_150_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 48
		refs = "000d ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_150_2 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 48
		refs = "000d ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_175_1 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 48
		refs = "000d ?wfout@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 001c ??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_175_1 {
	meta:
		name = "??__Ewcout@std@@YAXXZ"
		size = 48
		refs = "000d ?wfout@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0017 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 001c ??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z 0023 ??__Fwcout@std@@YAXXZ 002c atexit"
	strings:
		$1 = { 48 83 EC 28 41 B9 01 00 00 00 48 8D 15 ?? ?? ?? ?? 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_175_1 {
	meta:
		name = "??__Efout@std@@YAXXZ"
		size = 80
		refs = "000c __acrt_iob_func 0013 ?fout@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 001b ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ 0022 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 003b ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z 0042 ??__Ffout@std@@YAXXZ 004c atexit"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 45 33 C0 48 8B D3 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_177_1 {
	meta:
		name = "??__Einitlocks@@YAXXZ"
		size = 32
		refs = "0007 ?initlocks@@3V_Init_locks@std@@A 000c ??0_Init_locks@std@@QEAA@XZ 0013 ??__Finitlocks@@YAXXZ 001c atexit"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_74_1 {
	meta:
		name = "??__E?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ"
		size = 32
		refs = "0007 ?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A 000c ?_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ 0013 ??__F?m_badAllocExceptionPtr@__ExceptionPtr@@0V?$shared_ptr@V__ExceptionPtr@@@std@@A@@YAXXZ 001c atexit"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_2_1 {
	meta:
		name = "??__Einitlocks@std@@YAXXZ"
		size = 32
		refs = "0007 ?initlocks@std@@3V_Init_locks@1@A 000c ??0_Init_locks@std@@QEAA@XZ 0013 ??__Finitlocks@std@@YAXXZ 001c atexit"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_179_1 {
	meta:
		name = "??__Fcout@std@@YAXXZ"
		size = 93
		refs = "0010 ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0022 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_81_179_1 {
	meta:
		name = "??__Fcerr@std@@YAXXZ"
		size = 93
		refs = "0010 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0022 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_11_179_1 {
	meta:
		name = "??__Fclog@std@@YAXXZ"
		size = 93
		refs = "0010 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0022 ??_7?$basic_ostream@DU?$char_traits@D@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_14_179_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 93
		refs = "0010 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0022 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_113_179_1 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 93
		refs = "0010 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0022 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_9_154_2 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 93
		refs = "0010 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0022 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_108_154_2 {
	meta:
		name = "??__Fwcerr@std@@YAXXZ"
		size = 93
		refs = "0010 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0022 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_114_179_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 93
		refs = "0010 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0022 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_118_179_1 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 93
		refs = "0010 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0022 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_22_154_2 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 93
		refs = "0010 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0022 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_98_154_2 {
	meta:
		name = "??__Fwclog@std@@YAXXZ"
		size = 93
		refs = "0010 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0022 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_179_1 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 93
		refs = "0010 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0022 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_95_179_1 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 93
		refs = "0010 ?wcout@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0022 ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_24_154_2 {
	meta:
		name = "??__Fwcout@std@@YAXXZ"
		size = 93
		refs = "0010 ?wcout@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0022 ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 0040 ??_7ios_base@std@@6B@ 0053 ?_Ios_base_dtor@ios_base@std@@CAXPEAV12@@Z"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 63 48 04 4C 8D 05 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 4A 89 04 01 48 8B 05 ?? ?? ?? ?? 48 63 48 04 8D 51 F0 42 89 54 01 FC 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_2_183_1 {
	meta:
		name = "?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAXXZ"
		size = 52
		refs = "0015 ?_Allocate@std@@YAPEAX_K0_N@Z"
		altNames = "?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAXXZ ?_Alloc_proxy@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 10 00 00 00 48 8B D9 41 B0 01 8D 4A F1 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 07 0F 57 C0 F3 0F 7F 00 48 8B 03 48 89 18 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_184_1 {
	meta:
		name = "?_Allocate@std@@YAPEAX_K0_N@Z"
		size = 126
		refs = "0040 ??2@YAPEAX_K@Z 0067 ?_Xbad_alloc@std@@YAXXZ 0073 _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 48 83 EC 28 4C 8B CA 48 85 C9 75 07 33 C0 48 83 C4 28 C3 33 D2 48 83 C8 FF 49 F7 F1 48 3B C1 72 45 49 0F AF C9 45 84 C0 74 30 48 81 F9 00 10 00 00 72 27 48 8D 41 27 48 3B C1 76 30 48 8B C8 E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 74 26 48 83 C0 27 48 83 E0 E0 48 89 48 F8 EB B4 E8 ?? ?? ?? ?? 48 85 C0 75 AA EB 12 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_185_1 {
	meta:
		name = "?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX$$QEAV12@@Z"
		size = 126
		refs = "002a memmove"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 83 7A 20 10 48 8B DA 48 8B F9 73 19 4C 8B 42 18 49 83 C0 01 74 21 48 83 C1 08 48 83 C2 08 E8 ?? ?? ?? ?? EB 12 48 83 C1 08 74 07 48 8B 42 08 48 89 01 48 83 62 08 00 48 8B 43 18 48 89 47 18 48 8B 43 20 48 89 47 20 48 C7 43 20 0F 00 00 00 48 83 63 18 00 48 83 7B 20 10 72 06 48 8B 5B 08 EB 04 48 83 C3 08 C6 03 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_187_1 {
	meta:
		name = "?_Chassign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0D@Z"
		size = 60
		refs = "0038 memset"
	strings:
		$1 = { 48 8B C2 49 83 F8 01 75 16 48 83 79 20 10 72 06 48 8B 49 08 EB 04 48 83 C1 08 44 88 0C 11 C3 48 83 79 20 10 72 06 48 8B 49 08 EB 04 48 83 C1 08 41 0F BE D1 48 03 C8 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_188_1 {
	meta:
		name = "?_Check_offset@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAX_K@Z"
		size = 21
		refs = "0010 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 39 51 18 72 05 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_41_510_1 {
	meta:
		name = "?_Check_offset@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAX_K@Z"
		size = 21
		refs = "0010 ?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 39 51 18 72 05 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_41_511_1 {
	meta:
		name = "?_Check_offset@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAX_K@Z"
		size = 21
		refs = "0010 ?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 39 51 18 72 05 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_190_1 {
	meta:
		name = "?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z"
		size = 248
		refs = "007c ?_Allocate@std@@YAPEAX_K0_N@Z 00bb memcpy 00c8 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z"
	strings:
		$1 = { 48 8B C4 4C 89 40 18 48 89 50 10 48 89 48 08 53 56 57 41 56 48 83 EC 38 48 C7 40 C8 FE FF FF FF 49 8B F0 48 8B F9 48 8B DA 48 83 CB 0F 49 C7 C1 FE FF FF FF 49 3B D9 76 05 48 8B DA EB 31 4C 8B 41 20 49 8B C8 48 D1 E9 48 B8 AB AA AA AA AA AA AA AA 48 F7 E3 48 D1 EA 48 3B CA 76 12 49 8B C1 48 2B C1 4C 3B C0 4A 8D 1C 01 76 03 49 8B D9 48 8D 4B 01 41 B0 01 BA 01 00 00 00 E8 ?? ?? ?? ?? 4C 8B F0 EB 14 48 8B 7C 24 60 48 8B 74 24 70 48 8B 5C 24 68 4C 8B 74 24 78 48 85 F6 74 21 48 83 7F 20 10 72 06 48 8B 57 08 EB 04 48 8D 57 08 48 85 F6 74 0B 4C 8B C6 49 8B CE E8 ?? ?? ?? ?? 45 33 C0 B2 01 48 8B CF E8 ?? ?? ?? ?? 48 8D 47 08 48 85 C0 74 03 4C 89 30 48 89 5F 20 48 89 77 18 48 83 7F 20 10 72 03 48 8B 00 C6 04 30 00 48 83 C4 38 41 5E 5F 5E 5B C3 }
	condition:
		$1
}

rule file_2_192_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z$0"
		size = 42
		refs = "0014 ?_Allocate@std@@YAPEAX_K0_N@Z 001f $LN19"
	strings:
		$1 = { 48 8B 4D 68 48 89 4D 68 48 FF C1 41 B0 01 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 89 45 78 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_2_194_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z$1"
		size = 24
		refs = "000a ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0013 _CxxThrowException"
	strings:
		$1 = { 45 33 C0 B2 01 48 8B 4D 60 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_41_526_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_K0@Z$1"
		size = 24
		refs = "000a ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 0013 _CxxThrowException"
	strings:
		$1 = { 45 33 C0 B2 01 48 8B 4D 60 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_41_531_1 {
	meta:
		name = "__catch$?_Copy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_K0@Z$1"
		size = 24
		refs = "000a ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 0013 _CxxThrowException"
	strings:
		$1 = { 45 33 C0 B2 01 48 8B 4D 60 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_2_195_1 {
	meta:
		name = "?_Deallocate@std@@YAXPEAX_K1@Z"
		size = 105
		refs = "0047 ??3@YAXPEAX@Z 004c _invalid_parameter_noinfo_noreturn"
	strings:
		$1 = { 48 83 EC 28 4C 8B CA 48 83 C8 FF 33 D2 49 F7 F0 4C 3B C8 77 36 4D 0F AF C8 49 81 F9 00 10 00 00 72 20 F6 C1 1F 75 2A 48 8B 41 F8 48 3B C1 73 27 48 2B C8 48 83 F9 08 72 24 48 83 F9 27 77 24 48 8B C8 48 83 C4 28 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_197_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ"
		size = 838
		refs = "002e __security_cookie 0065 _guard_check_icall 0089 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 0097 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0260 fwrite 0297 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 02a8 _invalid_parameter_noinfo_noreturn 02c6 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 02d8 ?_Deallocate@std@@YAXPEAX_K1@Z 0321 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC C0 00 00 00 48 C7 45 B7 FE FF FF FF 48 89 58 10 48 89 70 18 48 89 78 20 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 2F 4C 8B E1 45 33 FF 45 8B EF 44 89 7D A7 4C 39 79 68 0F 84 C7 02 00 00 44 38 79 71 0F 84 BD 02 00 00 48 8B 01 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 83 CA FF 49 8B CC FF D3 83 F8 FF 75 07 32 C0 E9 9C 02 00 00 45 33 C0 41 8D 50 08 48 8D 4D 07 E8 ?? ?? ?? ?? 90 48 8D 55 BF 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8B 58 10 48 85 DB 0F 84 69 02 00 00 48 8B 00 48 85 C0 0F 84 57 02 00 00 48 8B 00 48 85 C0 0F 84 4B 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CB 0F 87 2B 02 00 00 48 8B 40 18 48 03 C8 48 3B D9 0F 83 1B 02 00 00 48 8D 55 EF 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8B 50 10 48 89 55 A7 48 85 D2 0F 84 F7 01 00 00 48 8B 00 48 85 C0 0F 84 E5 01 00 00 48 8B 00 48 85 C0 0F 84 D9 01 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 B9 01 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 A9 01 00 00 4D 8B 74 24 68 49 8B 16 48 03 5D 1F 48 8B 72 40 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 AF 48 89 44 24 20 4C 8B CB 4C 8B 45 A7 49 8D 54 24 74 49 8B CE FF D6 8B C8 85 C0 74 0B 83 E9 01 0F 85 15 01 00 00 EB 05 45 88 7C 24 71 48 8D 55 D7 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 0F 84 41 01 00 00 48 8B 00 48 85 C0 0F 84 2F 01 00 00 48 8B 00 48 85 C0 0F 84 23 01 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 03 01 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 F3 00 00 00 48 8B 5D AF 48 2B DA 74 74 41 83 CD 01 48 8D 55 D7 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8B 48 10 48 85 C9 0F 84 9E 00 00 00 48 8B 00 48 85 C0 0F 84 8C 00 00 00 48 8B 00 48 85 C0 0F 84 80 00 00 00 48 83 78 20 10 72 06 48 8B 50 08 EB 04 48 8D 50 08 48 3B D1 77 64 48 8B 40 18 48 03 D0 48 3B CA 73 58 4D 8B 8C 24 80 00 00 00 4C 8B C3 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 3B D8 B0 01 75 03 41 8A C7 41 F6 C5 01 74 04 41 83 E5 FE 84 C0 75 40 45 38 7C 24 71 74 36 48 85 DB 0F 85 02 FE FF FF 45 33 C0 8D 53 08 48 8D 4D 07 E8 ?? ?? ?? ?? E9 EE FD FF FF 83 F9 02 75 17 EB 12 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 41 B7 01 45 33 C0 B2 01 48 8D 4D 07 E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D 07 E8 ?? ?? ?? ?? 41 8A C7 EB 38 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 B0 01 48 8B 4D 2F 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 C0 00 00 00 49 8B 5B 38 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_2_199_1 {
	meta:
		name = "?_Eos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
		size = 26
	strings:
		$1 = { 48 83 79 20 10 48 89 51 18 72 06 48 8B 49 08 EB 04 48 83 C1 08 C6 04 11 00 C3 }
	condition:
		$1
}

rule file_2_209_1 {
	meta:
		name = "?_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 193
		refs = "003c ??2@YAPEAX_K@Z 005c ??_C@_00CNPNBAHC@?$AA@ 0075 ??0_Locinfo@std@@QEAA@PEBD@Z 0085 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 009f ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC 90 00 00 00 48 C7 40 88 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 A0 00 00 00 48 85 C9 74 70 48 39 31 75 6B 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 A0 00 00 00 48 85 C0 74 3E 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 02 00 00 00 4C 8D 9C 24 90 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_2_210_1 {
	meta:
		name = "?dtor$0@?0??_Getcat@?$codecvt@DDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
		size = 32
		refs = "0016 ??3@YAXPEAX_K@Z"
		altNames = "?dtor$0@?0??_Getcat@?$messages@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$messages@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$messages@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA BA 10 00 00 00 48 8B 8D A0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_2_211_1 {
	meta:
		name = "?_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 227
		refs = "0045 ??2@YAPEAX_K@Z 0065 ??_C@_00CNPNBAHC@?$AA@ 007e ??0_Locinfo@std@@QEAA@PEBD@Z 008e ??_7?$ctype@D@std@@6B@ 009b _Getctype 00c1 ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC B0 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 C0 00 00 00 48 85 C9 0F 84 8D 00 00 00 48 39 31 0F 85 84 00 00 00 8D 4E 30 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 C0 00 00 00 48 85 C0 74 57 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 48 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8D 4C 24 28 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 48 E8 ?? ?? ?? ?? B8 02 00 00 00 4C 8D 9C 24 B0 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_2_212_1 {
	meta:
		name = "?dtor$0@?0??_Getcat@?$ctype@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
		size = 32
		refs = "0016 ??3@YAXPEAX_K@Z"
		altNames = "?dtor$0@?0??_Getcat@?$numpunct@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$numpunct@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$0@?0??_Getcat@?$numpunct@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA BA 30 00 00 00 48 8B 8D C0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_2_214_1 {
	meta:
		name = "?_Getctype@_Locinfo@std@@QEBA?AU_Ctypevec@@XZ"
		size = 42
		refs = "000f _Getctype"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8D 4C 24 20 48 8B DA E8 ?? ?? ?? ?? 0F 10 00 0F 10 48 10 48 8B C3 0F 11 03 0F 11 4B 10 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_2_215_1 {
	meta:
		name = "?_Getfacet@locale@std@@QEBAPEBVfacet@12@_K@Z"
		size = 81
		refs = "0031 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B FA 33 DB 48 8B 51 08 48 3B 7A 18 73 0A 48 8B 42 10 48 8B 04 F8 EB 03 48 8B C3 48 85 C0 75 1B 38 5A 24 74 16 E8 ?? ?? ?? ?? 48 3B 78 18 73 08 48 8B 40 10 48 8B 1C F8 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_216_1 {
	meta:
		name = "?_Gnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBA_JXZ"
		size = 21
		altNames = "?_Gnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBA_JXZ ?_Gnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBA_JXZ"
	strings:
		$1 = { 48 8B 41 38 33 D2 48 39 10 74 06 48 8B 41 50 8B 10 48 63 C2 C3 }
	condition:
		$1
}

rule file_2_217_1 {
	meta:
		name = "?_Gndec@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"
		size = 20
	strings:
		$1 = { 48 8B 41 50 FF 00 48 8B 51 38 48 8B 02 48 FF C8 48 89 02 C3 }
	condition:
		$1
}

rule file_2_218_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"
		size = 21
	strings:
		$1 = { 48 8B 41 50 FF 08 48 8B 51 38 48 8B 02 48 8D 48 01 48 89 0A C3 }
	condition:
		$1
}

rule file_2_219_1 {
	meta:
		name = "?_Grow@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_N_K_N@Z"
		size = 110
		refs = "001a ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 0039 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0069 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B DA 48 83 FA FE 77 59 48 39 51 20 73 0B 4C 8B 41 18 E8 ?? ?? ?? ?? EB 3C 45 84 C0 74 1A 48 83 FB 10 73 14 4C 8B 41 18 B2 01 49 3B D8 4C 0F 42 C3 E8 ?? ?? ?? ?? EB 1D 48 85 DB 75 1B 48 21 59 18 48 83 79 20 10 72 06 48 8B 49 08 EB 04 48 83 C1 08 C6 01 00 48 85 DB 0F 95 C0 48 83 C4 20 5B C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_221_1 {
	meta:
		name = "?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
		size = 235
		refs = "009e _get_stream_buffer_pointers 00d3 ?_Stinit@?1??_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 4C 8B DC 49 89 5B 18 57 48 83 EC 20 C6 41 71 00 41 83 F8 01 4C 8D 41 10 48 8B FA 0F 94 C0 4C 89 41 20 88 41 7C 48 8B D9 48 8D 41 08 48 89 41 18 48 8D 41 28 48 89 41 38 48 8D 41 30 48 89 41 40 48 8D 41 48 48 89 41 50 48 8D 41 4C 48 89 41 58 49 83 20 00 48 8B 41 40 48 83 20 00 48 8B 41 58 83 20 00 48 8B 41 18 48 83 20 00 48 8B 41 38 48 83 20 00 48 8B 41 50 83 20 00 48 85 D2 74 4A 49 83 63 08 00 4D 8D 4B 20 49 83 63 10 00 4D 8D 43 10 49 83 63 20 00 49 8D 53 08 48 8B CF E8 ?? ?? ?? ?? 48 8B 44 24 30 48 89 43 18 48 89 43 20 48 8B 44 24 38 48 89 43 38 48 89 43 40 48 8B 44 24 48 48 89 43 50 48 89 43 58 48 89 BB 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 83 63 68 00 48 89 43 74 48 8B 5C 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_222_1 {
	meta:
		name = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAPEAD0PEAH001@Z"
		size = 40
		altNames = "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAPEAG0PEAH001@Z ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAPEA_W0PEAH001@Z"
	strings:
		$1 = { 48 8B 44 24 28 48 89 41 20 48 8B 44 24 30 48 89 41 40 48 8B 44 24 38 48 89 41 58 48 89 51 18 4C 89 41 38 4C 89 49 50 C3 }
	condition:
		$1
}

rule file_2_223_1 {
	meta:
		name = "?_Init@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXXZ"
		size = 90
		altNames = "?_Init@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXXZ ?_Init@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 45 33 C0 48 8D 41 08 48 89 41 18 48 8D 51 10 48 89 51 20 48 8D 41 28 48 89 41 38 48 8D 41 30 48 89 41 40 48 8D 41 48 48 89 41 50 48 8D 41 4C 48 89 41 58 4C 89 02 48 8B 41 40 4C 89 00 48 8B 41 58 44 89 00 48 8B 41 18 4C 89 00 48 8B 41 38 4C 89 00 48 8B 41 50 44 89 00 C3 }
	condition:
		$1
}

rule file_2_225_1 {
	meta:
		name = "?_Init@?$ctype@D@std@@IEAAXAEBV_Locinfo@2@@Z"
		size = 40
		refs = "000f _Getctype"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_2_226_1 {
	meta:
		name = "?_Init@ios_base@std@@IEAAXXZ"
		size = 125
		refs = "0049 ?clear@ios_base@std@@QEAAXH_N@Z 0053 ??2@YAPEAX_K@Z 0062 ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B D9 48 83 61 40 00 48 83 61 08 00 83 61 14 00 C7 41 18 01 02 00 00 48 C7 41 20 06 00 00 00 48 83 61 28 00 48 83 61 30 00 48 83 61 38 00 45 33 C0 33 D2 E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0D B1 01 E8 ?? ?? ?? ?? 48 89 47 08 EB 02 33 FF 48 89 7B 40 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_228_1 {
	meta:
		name = "?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEBV?$codecvt@DDU_Mbstatet@@@2@@Z"
		size = 157
		refs = "0020 _guard_check_icall"
		altNames = "?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEBV?$codecvt@GDU_Mbstatet@@@2@@Z ?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 02 48 8B F9 48 8B F2 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 48 8B CE FF D3 33 D2 84 C0 74 06 48 89 57 68 EB 58 48 89 77 68 48 8D 47 08 48 89 47 18 48 8D 4F 10 48 89 4F 20 48 8D 47 28 48 89 47 38 48 8D 47 30 48 89 47 40 48 8D 47 48 48 89 47 50 48 8D 47 4C 48 89 47 58 48 89 11 48 8B 47 40 48 89 10 48 8B 47 58 89 10 48 8B 47 18 48 89 10 48 8B 47 38 48 89 10 48 8B 47 50 89 10 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_229_1 {
	meta:
		name = "?_Inside@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA_NPEBD@Z"
		size = 58
	strings:
		$1 = { 48 85 D2 74 32 48 83 79 20 10 4C 8D 41 08 72 05 49 8B 00 EB 03 49 8B C0 48 3B D0 72 1A 48 83 79 20 10 72 03 4D 8B 00 48 8B 41 18 49 8D 0C 00 48 3B CA 76 03 B0 01 C3 32 C0 C3 }
	condition:
		$1
}

rule file_2_230_1 {
	meta:
		name = "?_Lock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAXXZ"
		size = 26
		refs = "0011 _lock_file"
		altNames = "?_Lock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAXXZ ?_Lock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8B 89 80 00 00 00 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_11_253_1 {
	meta:
		name = "?_Unlock@?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAXXZ"
		size = 26
		refs = "0011 _unlock_file"
	strings:
		$1 = { 48 83 EC 28 48 8B 89 80 00 00 00 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_254_1 {
	meta:
		name = "?_Unlock@?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAXXZ"
		size = 26
		refs = "0011 _unlock_file"
	strings:
		$1 = { 48 83 EC 28 48 8B 89 80 00 00 00 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_73_223_2 {
	meta:
		name = "?_Unlock@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAXXZ"
		size = 26
		refs = "0011 _unlock_file"
	strings:
		$1 = { 48 83 EC 28 48 8B 89 80 00 00 00 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_232_1 {
	meta:
		name = "?_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z"
		size = 215
		refs = "0014 __security_cookie 0043 ??_C@_02LMMGGCAJ@?3?5?$AA@ 004b ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z 0058 ?message@error_code@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 006b ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z 007b ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0090 ?_Deallocate@std@@YAXPEAX_K1@Z 009b ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@$$QEAV01@@Z 00cb __security_check_cookie"
	strings:
		$1 = { 40 53 56 57 48 83 EC 70 48 C7 44 24 28 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 60 49 8B D8 48 8B F2 48 8B F9 48 89 5C 24 30 83 64 24 20 00 49 83 78 18 00 74 15 41 B8 02 00 00 00 48 8D 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8D 54 24 38 48 8B CE E8 ?? ?? ?? ?? 90 49 83 C9 FF 45 33 C0 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 90 45 33 C0 B2 01 48 8D 4C 24 38 E8 ?? ?? ?? ?? BE 10 00 00 00 44 8B C6 8D 56 F1 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 90 45 33 C0 B2 01 48 8B CB E8 ?? ?? ?? ?? 44 8B C6 8D 56 F1 48 8B 0B E8 ?? ?? ?? ?? 48 83 23 00 48 8B C7 48 8B 4C 24 60 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 70 5F 5E 5B C3 }
	condition:
		$1
}

rule file_2_236_1 {
	meta:
		name = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAPEADXZ"
		size = 17
		altNames = "?_Myptr@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEBAPEBDXZ ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEAAPEADXZ ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEBAPEBDXZ ?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ"
	strings:
		$1 = { 48 83 79 20 10 72 05 48 8B 41 08 C3 48 8D 41 08 C3 }
	condition:
		$1
}

rule file_2_245_1 {
	meta:
		name = "?_Pnavail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEBA_JXZ"
		size = 21
		altNames = "?_Pnavail@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBA_JXZ ?_Pnavail@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBA_JXZ"
	strings:
		$1 = { 48 8B 41 40 33 D2 48 39 10 74 06 48 8B 41 58 8B 10 48 63 C2 C3 }
	condition:
		$1
}

rule file_2_246_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAPEADXZ"
		size = 21
	strings:
		$1 = { 48 8B 41 58 FF 08 48 8B 51 40 48 8B 02 48 8D 48 01 48 89 0A C3 }
	condition:
		$1
}

rule file_2_247_1 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ"
		size = 48
	strings:
		$1 = { 4C 8B 49 18 48 8D 41 70 49 39 01 75 22 48 8B 91 88 00 00 00 4C 8B 81 90 00 00 00 49 89 11 44 2B C2 48 8B 41 38 48 89 10 48 8B 41 50 44 89 00 C3 }
	condition:
		$1
}

rule file_2_248_1 {
	meta:
		name = "?_Set_back@?$basic_filebuf@DU?$char_traits@D@std@@@std@@AEAAXXZ"
		size = 73
	strings:
		$1 = { 4C 8B C1 48 8B 49 18 48 8B 01 4D 8D 48 70 49 3B C1 74 1C 49 89 80 88 00 00 00 49 8B 40 50 48 63 10 49 8B 40 38 48 03 10 49 89 90 90 00 00 00 4C 89 09 41 8B C8 49 8B 40 38 41 2B C9 83 C1 71 4C 89 08 49 8B 40 50 89 08 C3 }
	condition:
		$1
}

rule file_2_251_1 {
	meta:
		name = "?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z"
		size = 122
		refs = "0030 memcpy 0045 ?_Deallocate@std@@YAXPEAX_K1@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B F8 48 8B D9 84 D2 74 30 48 83 79 20 10 72 29 48 83 C1 08 48 8B 31 4D 85 C0 74 08 48 8B D6 E8 ?? ?? ?? ?? 48 8B 53 20 41 B8 01 00 00 00 49 03 D0 48 8B CE E8 ?? ?? ?? ?? 48 C7 43 20 0F 00 00 00 48 83 7B 20 10 48 89 7B 18 72 06 48 8B 5B 08 EB 04 48 83 C3 08 48 8B 74 24 38 C6 04 3B 00 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_252_1 {
	meta:
		name = "?_Tidy@?$ctype@D@std@@IEAAXXZ"
		size = 52
		refs = "0015 free 0022 ??_V@YAXPEAX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 8B 41 20 48 8B D9 85 C0 7E 0B 48 8B 49 18 E8 ?? ?? ?? ?? EB 0B 79 09 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 28 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_255_1 {
	meta:
		name = "?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
		size = 17
		refs = "0007 ??_C@_0BA@JFNIOLAK@string?5too?5long?$AA@ 000c ?_Xlength_error@std@@YAXPEBD@Z"
		altNames = "?_Xlen@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAXXZ ?_Xlen@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_53_225_2 {
	meta:
		name = "?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
		size = 17
		refs = "0007 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 000c ?_Xout_of_range@std@@YAXPEBD@Z"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_40_817_2 {
	meta:
		name = "?_Xran@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAXXZ"
		size = 17
		refs = "0007 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 000c ?_Xout_of_range@std@@YAXPEBD@Z"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_40_818_2 {
	meta:
		name = "?_Xran@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAXXZ"
		size = 17
		refs = "0007 ??_C@_0BI@CFPLBAOH@invalid?5string?5position?$AA@ 000c ?_Xout_of_range@std@@YAXPEBD@Z"
	strings:
		$1 = { 48 83 EC 28 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_259_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAPEAD_K@Z"
		size = 16
		refs = "000c ?_Allocate@std@@YAPEAX_K0_N@Z"
		altNames = "?allocate@?$allocator@D@std@@QEAAPEAD_K@Z"
	strings:
		$1 = { 48 8B CA 41 B0 01 BA 01 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_260_1 {
	meta:
		name = "?allocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAAPEAU_Container_proxy@2@_K@Z"
		size = 16
		refs = "000c ?_Allocate@std@@YAPEAX_K0_N@Z"
		altNames = "?allocate@?$allocator@U_Container_proxy@std@@@std@@QEAAPEAU_Container_proxy@2@_K@Z"
	strings:
		$1 = { 48 8B CA 41 B0 01 BA 10 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_263_1 {
	meta:
		name = "?always_noconv@codecvt_base@std@@QEBA_NXZ"
		size = 47
		refs = "0018 _guard_check_icall"
		altNames = "?date_order@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ ?date_order@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QEBA?AW4dateorder@time_base@2@XZ ?decimal_point@?$_Mpunct@D@std@@QEBADXZ ?decimal_point@?$_Mpunct@G@std@@QEBAGXZ ?decimal_point@?$_Mpunct@_W@std@@QEBA_WXZ ?decimal_point@?$numpunct@D@std@@QEBADXZ ?decimal_point@?$numpunct@G@std@@QEBAGXZ ?decimal_point@?$numpunct@_W@std@@QEBA_WXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 01 48 8B F9 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 48 8B CF 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_2_265_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
		size = 278
		refs = "0070 ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 00cd memcpy 0105 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ 010b ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 48 8B 42 18 49 8B E9 4D 8B F0 48 8B FA 48 8B D9 49 3B C0 0F 82 CF 00 00 00 49 2B C0 4C 8B 41 18 4C 3B C8 48 0F 47 E8 49 8B C0 48 F7 D0 48 3B C5 0F 86 BB 00 00 00 49 8D 34 28 48 85 ED 0F 84 87 00 00 00 48 83 FE FE 0F 87 AA 00 00 00 48 39 71 20 73 0A 48 8B D6 E8 ?? ?? ?? ?? EB 1D 48 85 F6 75 1D 48 21 71 18 48 83 79 20 10 72 06 48 8B 41 08 EB 04 48 8D 41 08 C6 00 00 48 85 F6 74 4B 48 83 7F 20 10 72 06 48 8B 47 08 EB 04 48 8D 47 08 48 83 7B 20 10 48 8D 7B 08 72 05 48 8B 0F EB 03 48 8B CF 48 85 ED 74 10 48 03 4B 18 4A 8D 14 30 4C 8B C5 E8 ?? ?? ?? ?? 48 83 7B 20 10 48 89 73 18 72 03 48 8B 3F C6 04 37 00 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 48 8B CF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_266_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD@Z"
		size = 29
		refs = "0019 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
	strings:
		$1 = { 45 33 C0 44 38 02 74 10 48 83 C8 FF 48 FF C0 44 38 04 02 75 F7 4C 8B C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_137_2 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD@Z"
		size = 29
		refs = "0019 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
	strings:
		$1 = { 45 33 C0 44 38 02 74 10 48 83 C8 FF 48 FF C0 44 38 04 02 75 F7 4C 8B C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_267_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
		size = 318
		refs = "0071 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z 00ad ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 00f8 memcpy 0130 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 4D 8B F0 48 8B EA 48 8B D9 48 85 D2 74 53 48 83 79 20 10 4C 8D 49 08 72 05 49 8B 01 EB 03 49 8B C1 48 3B E8 72 3B 48 83 79 20 10 72 05 49 8B 09 EB 03 49 8B C9 48 03 4B 18 48 3B CD 76 23 48 83 7B 20 10 72 03 4D 8B 09 49 2B E9 48 8B D3 4C 8B C5 4D 8B CE 48 8B CB E8 ?? ?? ?? ?? E9 97 00 00 00 4C 8B 43 18 49 8B C0 48 F7 D0 49 3B C6 0F 86 9F 00 00 00 4B 8D 3C 30 4D 85 F6 74 78 48 83 FF FE 0F 87 95 00 00 00 48 39 7B 20 73 0D 48 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 1D 48 85 FF 75 1D 48 21 7B 18 48 83 7B 20 10 72 06 48 8B 43 08 EB 04 48 8D 43 08 C6 00 00 48 85 FF 74 39 48 83 7B 20 10 48 8D 73 08 72 05 48 8B 0E EB 03 48 8B CE 4D 85 F6 74 0F 48 03 4B 18 4D 8B C6 48 8B D5 E8 ?? ?? ?? ?? 48 83 7B 20 10 48 89 7B 18 72 03 48 8B 36 C6 04 3E 00 48 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 48 8B CB E8 ?? ?? ?? ?? CC 48 8B CB E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_268_1 {
	meta:
		name = "?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z"
		size = 251
		refs = "0056 ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 00bb memset 00f0 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 45 8A F0 48 8B EA 4C 8B 41 18 48 8B D9 49 8B C0 48 F7 D0 48 3B C2 0F 86 BA 00 00 00 49 8D 34 10 48 85 D2 0F 84 8F 00 00 00 48 83 FE FE 0F 87 A9 00 00 00 48 39 71 20 73 0A 48 8B D6 E8 ?? ?? ?? ?? EB 1D 48 85 F6 75 1D 48 21 71 18 48 83 79 20 10 72 06 48 8B 41 08 EB 04 48 8D 41 08 C6 00 00 48 85 F6 74 53 48 8B 4B 18 48 8D 7B 08 48 83 FD 01 75 15 48 83 7B 20 10 72 05 48 8B 07 EB 03 48 8B C7 44 88 34 08 EB 1E 48 83 7B 20 10 72 05 48 8B 07 EB 03 48 8B C7 41 0F BE D6 48 03 C8 4C 8B C5 E8 ?? ?? ?? ?? 48 83 7B 20 10 48 89 73 18 72 03 48 8B 3F C6 04 37 00 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_269_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
		size = 296
		refs = "006a ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z 008b ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 00e4 memcpy 0117 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ 0123 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 48 8B 42 18 49 8B F9 4D 8B F0 48 8B F2 48 8B D9 49 3B C0 0F 82 E5 00 00 00 49 2B C0 4C 3B C8 48 0F 47 F8 48 3B CA 75 36 49 8D 04 38 48 39 41 18 0F 82 D1 00 00 00 48 89 41 18 48 83 79 20 10 72 06 48 8B 49 08 EB 04 48 83 C1 08 C6 04 01 00 33 D2 48 8B CB E8 ?? ?? ?? ?? E9 87 00 00 00 48 83 FF FE 0F 87 A5 00 00 00 48 39 79 20 73 0E 4C 8B 41 18 48 8B D7 E8 ?? ?? ?? ?? EB 1D 48 85 FF 75 1D 48 21 79 18 48 83 79 20 10 72 06 48 8B 41 08 EB 04 48 8D 41 08 C6 00 00 48 85 FF 74 47 48 83 7E 20 10 72 06 48 8B 46 08 EB 04 48 8D 46 08 48 83 7B 20 10 48 8D 73 08 72 05 48 8B 0E EB 03 48 8B CE 48 85 FF 74 0C 4A 8D 14 30 4C 8B C7 E8 ?? ?? ?? ?? 48 83 7B 20 10 48 89 7B 18 72 03 48 8B 36 C6 04 3E 00 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 8B 7C 24 40 48 83 C4 20 41 5E C3 48 8B CE E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_271_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@PEBD_K@Z"
		size = 267
		refs = "006c ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z 008d ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 00d4 memcpy 0106 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B F8 48 8B EA 48 8B D9 48 85 D2 74 50 48 83 79 20 10 4C 8D 41 08 72 05 49 8B 00 EB 03 49 8B C0 48 3B E8 72 38 48 83 79 20 10 72 05 49 8B 08 EB 03 49 8B C8 48 03 4B 18 48 3B CD 76 20 48 83 7B 20 10 72 03 4D 8B 00 49 2B E8 4C 8B CF 4C 8B C5 48 8B D3 48 8B CB E8 ?? ?? ?? ?? EB 7B 48 83 FF FE 0F 87 86 00 00 00 48 39 7B 20 73 11 4C 8B 43 18 48 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 1D 48 85 FF 75 1D 48 21 7B 18 48 83 7B 20 10 72 06 48 8B 43 08 EB 04 48 8D 43 08 C6 00 00 48 85 FF 74 35 48 83 7B 20 10 48 8D 73 08 72 05 48 8B 0E EB 03 48 8B CE 48 85 FF 74 0B 4C 8B C7 48 8B D5 E8 ?? ?? ?? ?? 48 83 7B 20 10 48 89 7B 18 72 03 48 8B 36 C6 04 3E 00 48 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 48 8B CB E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_272_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z"
		size = 211
		refs = "003c ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 0099 memset 00c8 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 41 8A E8 48 8B FA 48 8B D9 48 83 FA FF 0F 84 A0 00 00 00 48 83 FA FE 0F 87 9C 00 00 00 48 39 51 20 73 0B 4C 8B 41 18 E8 ?? ?? ?? ?? EB 1D 48 85 FF 75 1D 48 21 79 18 48 83 79 20 10 72 06 48 8B 41 08 EB 04 48 8D 41 08 C6 00 00 48 85 FF 74 4B 48 8D 73 08 48 83 FF 01 75 14 48 83 7B 20 10 72 05 48 8B 06 EB 03 48 8B C6 40 88 28 EB 1B 48 83 7B 20 10 72 05 48 8B 0E EB 03 48 8B CE 40 0F BE D5 4C 8B C7 E8 ?? ?? ?? ?? 48 83 7B 20 10 48 89 7B 18 72 03 48 8B 36 C6 04 3E 00 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_273_1 {
	meta:
		name = "?assign@?$char_traits@D@std@@SAPEADPEAD_KD@Z"
		size = 33
		refs = "0014 memset"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C2 48 8B D9 41 0F BE D0 4C 8B C0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_275_1 {
	meta:
		name = "?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ"
		size = 36
	strings:
		$1 = { 48 83 79 20 10 72 06 48 8B 41 08 EB 04 48 8D 41 08 48 83 62 08 00 48 89 42 10 48 8B 01 48 89 02 48 8B C2 C3 }
	condition:
		$1
}

rule file_2_278_1 {
	meta:
		name = "?c_str@locale@std@@QEBAPEBDXZ"
		size = 31
		refs = "000c ??_C@_00CNPNBAHC@?$AA@"
	strings:
		$1 = { 48 8B 51 08 48 85 D2 75 08 48 8D 05 ?? ?? ?? ?? C3 48 8B 42 28 48 85 C0 75 04 48 8D 42 30 C3 }
	condition:
		$1
}

rule file_2_281_1 {
	meta:
		name = "?clear@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"
		size = 18
		refs = "000e ?clear@ios_base@std@@QEAAXH_N@Z"
		altNames = "?clear@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z ?clear@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"
	strings:
		$1 = { 8B C2 83 C8 04 48 83 79 48 00 0F 44 D0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_283_1 {
	meta:
		name = "?clear@ios_base@std@@QEAAXH_N@Z"
		size = 186
		refs = "0034 _CxxThrowException 003a ?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z 0044 ??_C@_0BF@PHHKMMFD@ios_base?3?3badbit?5set?$AA@ 004e ??0failure@ios_base@std@@QEAA@PEBDAEBVerror_code@2@@Z 0055 _TI5?AVfailure@ios_base@std@@ 006f ??_C@_0BG@FMKFHCIL@ios_base?3?3failbit?5set?$AA@ 009a ??_C@_0BF@OOHOMBOF@ios_base?3?3eofbit?5set?$AA@"
	strings:
		$1 = { 48 83 EC 68 8B 41 14 83 E2 17 89 51 10 23 C2 74 19 45 84 C0 75 19 48 8D 4C 24 20 BA 01 00 00 00 A8 04 75 15 A8 02 75 3C EB 65 48 83 C4 68 C3 33 D2 33 C9 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_284_1 {
	meta:
		name = "?close@?$basic_filebuf@DU?$char_traits@D@std@@@std@@QEAAPEAV12@XZ"
		size = 96
		refs = "001e ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ 0032 fclose 0049 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 8B F9 48 39 B1 80 00 00 00 74 22 E8 ?? ?? ?? ?? 48 8B 8F 80 00 00 00 F6 D8 48 1B DB 48 23 DF E8 ?? ?? ?? ?? 85 C0 48 0F 45 DE 48 8B F3 33 D2 48 8B CF 44 8D 42 02 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C6 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_285_1 {
	meta:
		name = "?copy@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z"
		size = 28
		refs = "000f memcpy"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 4D 85 C0 74 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_286_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAD_K@Z"
		size = 20
		refs = "0010 ?_Deallocate@std@@YAXPEAX_K1@Z"
		altNames = "?deallocate@?$allocator@D@std@@QEAAXPEAD_K@Z"
	strings:
		$1 = { 49 8B C0 48 8B CA 48 8B D0 41 B8 01 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_287_1 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAAXPEAU_Container_proxy@2@_K@Z"
		size = 20
		refs = "0010 ?_Deallocate@std@@YAXPEAX_K1@Z"
		altNames = "?deallocate@?$allocator@U_Container_proxy@std@@@std@@QEAAXPEAU_Container_proxy@2@_K@Z"
	strings:
		$1 = { 49 8B C0 48 8B CA 48 8B D0 41 B8 10 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_294_1 {
	meta:
		name = "?do_in@?$codecvt@DDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z"
		size = 27
		altNames = "?do_out@?$codecvt@DDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z"
	strings:
		$1 = { 48 8B 44 24 28 48 8B 4C 24 40 4C 89 00 48 8B 44 24 30 48 89 01 B8 03 00 00 00 C3 }
	condition:
		$1
}

rule file_2_295_1 {
	meta:
		name = "?do_length@?$codecvt@DDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1_K@Z"
		size = 18
	strings:
		$1 = { 4D 2B C8 4C 39 4C 24 28 4C 0F 42 4C 24 28 41 8B C1 C3 }
	condition:
		$1
}

rule file_2_298_1 {
	meta:
		name = "?do_narrow@?$ctype@D@std@@MEBAPEBDPEBD0DPEAD@Z"
		size = 31
		refs = "0012 memcpy"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 4C 24 50 49 8B D8 4C 2B C2 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_301_1 {
	meta:
		name = "?do_tolower@?$ctype@D@std@@MEBAPEBDPEADPEBD@Z"
		size = 95
		refs = "0036 _Tolower"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 FF 49 8B F0 48 2B F2 48 8B DA 49 3B D0 48 0F 47 F7 48 85 F6 74 1C 48 8D 69 10 0F B6 0B 48 8B D5 E8 ?? ?? ?? ?? 88 03 48 FF C7 48 FF C3 48 3B FE 75 E8 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_303_1 {
	meta:
		name = "?do_toupper@?$ctype@D@std@@MEBAPEBDPEADPEBD@Z"
		size = 95
		refs = "0036 _Toupper"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 FF 49 8B F0 48 2B F2 48 8B DA 49 3B D0 48 0F 47 F7 48 85 F6 74 1C 48 8D 69 10 0F B6 0B 48 8B D5 E8 ?? ?? ?? ?? 88 03 48 FF C7 48 FF C3 48 3B FE 75 E8 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_306_1 {
	meta:
		name = "?do_widen@?$ctype@D@std@@MEBAPEBDPEBD0PEAD@Z"
		size = 29
		refs = "0010 memcpy"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B D8 49 8B C9 4C 2B C2 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_313_1 {
	meta:
		name = "?equivalent@error_category@std@@UEBA_NAEBVerror_code@2@H@Z"
		size = 28
	strings:
		$1 = { 48 8B 42 08 4C 8B 48 08 4C 39 49 08 75 0B 44 39 02 75 06 B8 01 00 00 00 C3 33 C0 C3 }
	condition:
		$1
}

rule file_2_314_1 {
	meta:
		name = "?equivalent@error_category@std@@UEBA_NHAEBVerror_condition@2@@Z"
		size = 110
		refs = "0028 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 30 48 8B 01 48 8B F1 4D 8B F0 8B FA 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 44 8B C7 48 8D 54 24 20 48 8B CE FF D3 49 8B 4E 08 4C 8B 48 08 48 8B 51 08 49 39 51 08 75 0B 41 8B 0E 39 08 75 04 B0 01 EB 02 32 C0 48 8B 5C 24 40 48 8B 74 24 48 48 8B 7C 24 50 48 83 C4 30 41 5E C3 }
	condition:
		$1
}

rule file_2_315_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z"
		size = 159
		refs = "0070 memmove 009a ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 71 18 48 8B D9 48 3B F2 72 7E 48 8B C6 48 2B C2 49 3B C0 77 1B 48 89 51 18 48 83 79 20 10 72 06 48 8B 41 08 EB 04 48 8D 41 08 C6 04 10 00 EB 45 4D 85 C0 74 40 48 83 79 20 10 48 8D 79 08 72 05 48 8B 07 EB 03 48 8B C7 49 2B F0 48 8D 0C 10 48 8B C6 48 2B C2 74 0C 4A 8D 14 01 4C 8B C0 E8 ?? ?? ?? ?? 48 83 7B 20 10 48 89 73 18 72 03 48 8B 3F C6 04 37 00 48 8B 74 24 38 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_316_1 {
	meta:
		name = "?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K@Z"
		size = 49
		refs = "002c ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 83 EC 28 48 39 51 18 72 21 48 89 51 18 48 83 79 20 10 72 06 48 8B 41 08 EB 04 48 8D 41 08 C6 04 10 00 48 8B C1 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_2_317_1 {
	meta:
		name = "?gbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXH@Z"
		size = 17
	strings:
		$1 = { 48 8B 41 50 29 10 48 8B 49 38 48 63 C2 48 01 01 C3 }
	condition:
		$1
}

rule file_2_318_1 {
	meta:
		name = "?getloc@ios_base@std@@QEBA?AVlocale@2@XZ"
		size = 85
		refs = "0038 _guard_check_icall"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 28 FE FF FF FF 48 89 5C 24 40 48 89 74 24 48 48 8B F2 83 64 24 20 00 48 8B 41 40 48 8B 78 08 48 89 7A 08 48 8B 07 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 90 48 8B C6 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_320_1 {
	meta:
		name = "?imbue@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z"
		size = 33
		refs = "000d ??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@DDU_Mbstatet@@@0@AEBVlocale@0@@Z 001d ?_Initcvt@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEBV?$codecvt@DDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B CA E8 ?? ?? ?? ?? 48 8B D0 48 8B CB 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_328_1 {
	meta:
		name = "?imbue@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAXAEBVlocale@2@@Z"
		size = 33
		refs = "000d ??$use_facet@V?$codecvt@GDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@GDU_Mbstatet@@@0@AEBVlocale@0@@Z 001d ?_Initcvt@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEBV?$codecvt@GDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B CA E8 ?? ?? ?? ?? 48 8B D0 48 8B CB 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_95_328_1 {
	meta:
		name = "?imbue@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAXAEBVlocale@2@@Z"
		size = 33
		refs = "000d ??$use_facet@V?$codecvt@_WDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@_WDU_Mbstatet@@@0@AEBVlocale@0@@Z 001d ?_Initcvt@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEBV?$codecvt@_WDU_Mbstatet@@@2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B CA E8 ?? ?? ?? ?? 48 8B D0 48 8B CB 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_322_1 {
	meta:
		name = "?in@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z"
		size = 96
		refs = "0030 _guard_check_icall"
		altNames = "?in@?$codecvt@GDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAG3AEAPEAG@Z ?in@?$codecvt@_WDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEA_W3AEAPEA_W@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 40 48 8B 01 4C 8B F1 49 8B F9 49 8B F0 48 8B EA 48 8B 58 30 48 8B CB E8 ?? ?? ?? ?? 4C 8B CF 4C 8B C6 48 8B D5 49 8B CE 48 8B C3 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 40 41 5E 48 FF E0 }
	condition:
		$1
}

rule file_2_323_1 {
	meta:
		name = "?init@?$basic_ios@DU?$char_traits@D@std@@@std@@IEAAXPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@_N@Z"
		size = 104
		refs = "0019 ?_Init@ios_base@std@@IEAAXXZ 002c ?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z 0047 ?clear@ios_base@std@@QEAAXH_N@Z 0054 ?_Addstd@ios_base@std@@SAXPEAV12@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 41 8A F0 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 83 67 50 00 B2 20 48 8B CF 48 89 5F 48 E8 ?? ?? ?? ?? 48 83 7F 48 00 88 47 58 75 11 8B 57 10 45 33 C0 83 CA 04 48 8B CF E8 ?? ?? ?? ?? 40 84 F6 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_324_1 {
	meta:
		name = "?iostream_category@std@@YAAEBVerror_category@1@XZ"
		size = 72
		refs = "0006 ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@51 0014 ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 0025 ??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@YAXXZ 002c ??_7_Iostream_error_category@std@@6B@ 0038 atexit"
	strings:
		$1 = { 48 83 EC 28 8B 05 ?? ?? ?? ?? A8 01 75 2E 83 C8 01 48 C7 05 ?? ?? ?? ?? 05 00 00 00 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_325_1 {
	meta:
		name = "?length@?$char_traits@D@std@@SA_KPEBD@Z"
		size = 25
	strings:
		$1 = { 33 C0 48 8B D1 38 01 74 0F 48 83 C9 FF 48 FF C1 38 04 0A 75 F8 48 8B C1 C3 }
	condition:
		$1
}

rule file_2_326_1 {
	meta:
		name = "?make_error_code@std@@YA?AVerror_code@1@W4io_errc@1@@Z"
		size = 98
		refs = "000c ??_B?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@51 001f ?_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@1@XZ@4U?$_Immortalizer@V_Iostream_error_category@std@@@1@A 0030 ??__F_Static@?1???$_Immortalize@V_Iostream_error_category@std@@@std@@YAAEAV_Iostream_error_category@0@XZ@YAXXZ 0037 ??_7_Iostream_error_category@std@@6B@ 0043 atexit"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B 05 ?? ?? ?? ?? 8B FA 48 8B D9 A8 01 75 2E 83 C8 01 48 C7 05 ?? ?? ?? ?? 05 00 00 00 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 89 3B 48 89 43 08 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_331_1 {
	meta:
		name = "?message@_Generic_error_category@std@@UEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 42
		refs = "0012 ?_Syserror_map@std@@YAPEBDH@Z 001d ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 41 8B C8 48 8B DA E8 ?? ?? ?? ?? 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_332_1 {
	meta:
		name = "?message@_Iostream_error_category@std@@UEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
		size = 51
		refs = "0017 ??_C@_0BG@PADBLCHM@iostream?5stream?5error?$AA@ 001f ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z 0026 ?message@_Generic_error_category@std@@UEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@H@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 41 83 F8 01 75 11 48 8D 15 ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_2_333_1 {
	meta:
		name = "?message@error_code@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 85
		refs = "002e _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 30 48 8B 79 08 48 8B F1 83 64 24 20 00 48 8B EA 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 44 8B 06 48 8B D5 48 8B CF FF D3 48 8B 5C 24 40 48 8B C5 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_2_334_1 {
	meta:
		name = "?move@?$char_traits@D@std@@SAPEADPEADPEBD_K@Z"
		size = 25
		refs = "000a memmove"
	strings:
		$1 = { 48 83 EC 28 4D 85 C0 74 08 E8 ?? ?? ?? ?? 48 8B C8 48 8B C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_338_1 {
	meta:
		name = "?out@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAD3AEAPEAD@Z"
		size = 96
		refs = "0030 _guard_check_icall"
		altNames = "?out@?$codecvt@GDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEBG1AEAPEBGPEAD3AEAPEAD@Z ?out@?$codecvt@_WDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEB_W1AEAPEB_WPEAD3AEAPEAD@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 40 48 8B 01 4C 8B F1 49 8B F9 49 8B F0 48 8B EA 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 4C 8B CF 4C 8B C6 48 8B D5 49 8B CE 48 8B C3 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 40 41 5E 48 FF E0 }
	condition:
		$1
}

rule file_2_339_1 {
	meta:
		name = "?overflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"
		size = 1022
		refs = "0028 __security_cookie 00e4 fputc 0101 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 010f ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 01d5 _guard_check_icall 02f1 fwrite 033b ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 0345 _invalid_parameter_noinfo_noreturn 0398 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 03aa ?_Deallocate@std@@YAXPEAX_K1@Z 03df __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC F0 00 00 00 48 C7 45 9F FE FF FF FF 48 89 58 18 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 17 8B DA 89 54 24 48 4C 8B E9 45 33 FF 44 89 7C 24 44 41 83 CC FF 41 3B D4 75 0F 41 3B D4 44 0F 45 FA 41 8B C7 E9 7B 03 00 00 48 8B 41 40 4C 39 38 74 30 48 8B 51 58 4C 63 02 49 8B C8 48 03 08 48 39 08 73 1E 41 8D 48 FF 89 0A 49 8B 55 40 4C 8B 02 49 8D 48 01 48 89 0A 41 88 18 8B C3 E9 42 03 00 00 4D 39 BD 80 00 00 00 75 08 41 8B C4 E9 31 03 00 00 4D 8B 45 18 49 8D 45 70 49 39 00 75 20 49 8B 95 90 00 00 00 49 8B 8D 88 00 00 00 49 89 08 49 8B 45 38 48 89 08 2B D1 49 8B 45 50 89 10 4D 39 7D 68 75 18 0F BE CB 49 8B 95 80 00 00 00 E8 ?? ?? ?? ?? 41 3B C4 44 0F 45 E3 EB AD 88 5C 24 40 45 33 C0 41 8D 50 08 48 8D 4D EF E8 ?? ?? ?? ?? 90 48 8D 55 A7 48 8D 4D EF E8 ?? ?? ?? ?? 48 8B 58 10 48 85 DB 0F 84 B1 02 00 00 48 8B 00 48 85 C0 0F 84 9F 02 00 00 48 8B 00 48 85 C0 0F 84 93 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CB 0F 87 73 02 00 00 48 8B 40 18 48 03 C8 48 3B D9 0F 83 63 02 00 00 48 8D 55 D7 48 8D 4D EF E8 ?? ?? ?? ?? 48 8B 50 10 48 89 55 87 48 85 D2 0F 84 3F 02 00 00 48 8B 00 48 85 C0 0F 84 2D 02 00 00 48 8B 00 48 85 C0 0F 84 21 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 01 02 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 F1 01 00 00 4D 8B 75 68 4D 8B 06 48 03 5D 07 49 8B 70 38 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 8F 48 89 44 24 38 48 89 5C 24 30 48 8B 45 87 48 89 44 24 28 48 8D 45 97 48 89 44 24 20 4C 8D 4C 24 41 4C 8D 44 24 40 49 8D 55 74 49 8B CE FF D6 85 C0 0F 88 7A 01 00 00 83 F8 01 0F 8F 52 01 00 00 48 8D 55 BF 48 8D 4D EF E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 0F 84 32 01 00 00 48 8B 00 48 85 C0 0F 84 20 01 00 00 48 8B 00 48 85 C0 0F 84 14 01 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 F4 00 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 E4 00 00 00 48 8B 5D 8F 48 2B DA 8B 7C 24 44 74 76 83 CF 01 89 7C 24 44 48 8D 55 BF 48 8D 4D EF E8 ?? ?? ?? ?? 48 8B 48 10 48 85 C9 0F 84 A9 00 00 00 48 8B 00 48 85 C0 0F 84 97 00 00 00 48 8B 00 48 85 C0 0F 84 8B 00 00 00 48 83 78 20 10 72 06 48 8B 50 08 EB 04 48 8D 50 08 48 3B D1 77 6F 48 8B 40 18 48 03 D0 48 3B CA 73 63 4D 8B 8D 80 00 00 00 4C 8B C3 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 3B D8 B0 01 75 03 41 8A C7 40 F6 C7 01 74 07 83 E7 FE 89 7C 24 44 84 C0 75 7E 41 C6 45 71 01 48 8D 44 24 40 48 39 45 97 75 36 48 85 DB 0F 85 DD FD FF FF 48 83 7D 07 20 73 5E 45 33 C0 8D 53 08 48 8D 4D EF E8 ?? ?? ?? ?? E9 C2 FD FF FF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 44 8B 64 24 48 EB 31 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 83 F8 03 75 1A 0F BE 4C 24 40 49 8B 95 80 00 00 00 E8 ?? ?? ?? ?? 41 3B C4 44 0F 45 64 24 48 45 33 C0 B2 01 48 8D 4D EF E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D EF E8 ?? ?? ?? ?? E9 EB FC FF FF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 48 8B 4D 17 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 40 01 00 00 48 81 C4 F0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_2_342_1 {
	meta:
		name = "?pbackfail@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z"
		size = 206
		refs = "0066 ungetc"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 41 38 8B FA 48 8B D9 33 C9 48 8B 10 48 85 D2 74 2D 48 8B 43 18 48 39 10 73 24 83 FF FF 74 08 0F B6 42 FF 3B C7 75 17 48 8B 43 50 FF 00 48 8B 43 38 48 FF 08 83 FF FF 0F 45 CF 8B C1 EB 79 48 8B 93 80 00 00 00 48 85 D2 74 6A 83 FF FF 74 65 48 39 4B 68 75 12 40 0F B6 CF E8 ?? ?? ?? ?? 83 F8 FF 74 04 8B C7 EB 50 4C 8B 43 38 48 8D 53 70 49 39 10 74 40 4C 8B 4B 18 40 88 3A 49 8B 01 48 3B C2 74 18 48 89 83 88 00 00 00 48 8B 43 50 48 63 08 49 03 08 48 89 8B 90 00 00 00 49 89 11 8B CB 48 8B 43 38 2B CA 83 C1 71 48 89 10 48 8B 43 50 89 08 EB AF 83 C8 FF 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_344_1 {
	meta:
		name = "?pbump@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXH@Z"
		size = 17
	strings:
		$1 = { 48 8B 41 58 29 10 48 8B 49 40 48 63 C2 48 01 01 C3 }
	condition:
		$1
}

rule file_2_349_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 234
		refs = "0046 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ 0066 _fseeki64 007b fgetpos 00c2 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 56 48 83 EC 20 48 8B 41 38 4C 8D 71 70 41 8B E9 49 8B F0 48 8B FA 48 8B D9 4C 39 30 75 10 41 83 F9 01 75 0A 48 83 79 68 00 75 03 48 FF CE 48 83 B9 80 00 00 00 00 74 7A E8 ?? ?? ?? ?? 84 C0 74 71 48 85 F6 75 05 83 FD 01 74 16 48 8B 8B 80 00 00 00 44 8B C5 48 8B D6 E8 ?? ?? ?? ?? 85 C0 75 51 48 8B 8B 80 00 00 00 48 8D 54 24 40 E8 ?? ?? ?? ?? 85 C0 75 3C 48 8B 43 18 4C 39 30 75 20 48 8B 8B 88 00 00 00 48 8B 93 90 00 00 00 48 89 08 2B D1 48 8B 43 38 48 89 08 48 8B 43 50 89 10 48 8B 43 74 48 8B 4C 24 40 48 83 27 00 48 89 4F 08 EB 11 48 8B 05 ?? ?? ?? ?? 48 83 67 08 00 48 89 07 33 C0 48 8B 5C 24 48 48 8B 6C 24 50 48 89 47 10 48 8B C7 48 83 C4 20 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_2_350_1 {
	meta:
		name = "?seekoff@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 25
		refs = "0003 ?_BADOFF@std@@3_JB"
		altNames = "?seekoff@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z ?seekoff@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z ?seekpos@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z ?seekpos@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z ?seekpos@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 83 62 08 00 48 89 02 33 C0 48 89 42 10 48 8B C2 C3 }
	condition:
		$1
}

rule file_2_351_1 {
	meta:
		name = "?seekpos@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 256
		refs = "0038 ?_Endwrite@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAA_NXZ 0051 fsetpos 006d _fseeki64 0082 fgetpos 00d5 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 4C 8B DC 49 89 5B 10 49 89 73 18 49 89 7B 20 41 56 48 83 EC 20 48 83 B9 80 00 00 00 00 4D 8B F0 49 8B 40 08 48 8B FA 49 8B 30 48 8B D9 49 89 43 08 0F 84 9B 00 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 8E 00 00 00 48 8B 8B 80 00 00 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 79 48 85 F6 74 17 48 8B 8B 80 00 00 00 44 8D 40 01 48 8B D6 E8 ?? ?? ?? ?? 85 C0 75 5D 48 8B 8B 80 00 00 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 48 49 8B 46 10 4C 8B 43 18 48 89 43 74 48 8D 43 70 49 39 00 75 20 48 8B 8B 88 00 00 00 48 8B 93 90 00 00 00 49 89 08 2B D1 48 8B 43 38 48 89 08 48 8B 43 50 89 10 48 8B 43 74 48 8B 4C 24 30 48 83 27 00 48 89 4F 08 EB 11 48 8B 05 ?? ?? ?? ?? 48 83 67 08 00 48 89 07 33 C0 48 8B 5C 24 38 48 8B 74 24 40 48 89 47 10 48 8B C7 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_2_356_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAPEAV?$basic_streambuf@DU?$char_traits@D@std@@@2@PEAD_J@Z"
		size = 84
		refs = "002c setvbuf 0043 ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 4D 8B C8 48 8B 89 80 00 00 00 48 85 C9 74 34 48 85 D2 75 0B 4D 85 C0 75 06 45 8D 41 04 EB 03 45 33 C0 E8 ?? ?? ?? ?? 85 C0 75 18 48 8B 93 80 00 00 00 44 8D 40 01 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_2_358_1 {
	meta:
		name = "?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z"
		size = 25
	strings:
		$1 = { 48 8B 41 18 45 2B C8 48 89 10 48 8B 41 38 4C 89 00 48 8B 41 50 44 89 08 C3 }
	condition:
		$1
}

rule file_2_359_1 {
	meta:
		name = "?setp@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD0@Z"
		size = 25
	strings:
		$1 = { 48 8B 41 20 44 2B C2 48 89 10 48 8B 41 40 48 89 10 48 8B 41 58 44 89 00 C3 }
	condition:
		$1
}

rule file_2_360_1 {
	meta:
		name = "?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z"
		size = 38
		refs = "001d ?clear@ios_base@std@@QEAAXH_N@Z"
		altNames = "?setstate@?$basic_ios@GU?$char_traits@G@std@@@std@@QEAAXH_N@Z ?setstate@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEAAXH_N@Z"
	strings:
		$1 = { 48 83 EC 28 8B C2 85 D2 74 17 8B 51 10 0B D0 8B C2 83 C8 04 48 83 79 48 00 0F 44 D0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_364_1 {
	meta:
		name = "?sync@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"
		size = 93
		refs = "0027 _guard_check_icall 0041 fflush"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 83 B9 80 00 00 00 00 48 8B F9 74 2D 48 8B 01 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 83 CE FF 48 8B CF 8B D6 FF D3 3B C6 74 10 48 8B 8F 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 78 02 33 F6 48 8B 5C 24 30 8B C6 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_369_1 {
	meta:
		name = "?uflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"
		size = 1081
		refs = "002e __security_cookie 00c2 fgetc 00e1 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 010c ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 0119 ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 01db _guard_check_icall 02ad ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z 02d9 _invalid_parameter_noinfo_noreturn 03a3 ungetc 03f3 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0405 ?_Deallocate@std@@YAXPEAX_K1@Z 0414 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC E0 00 00 00 48 C7 45 AF FE FF FF FF 48 89 58 10 48 89 70 18 48 89 78 20 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 27 4C 8B F9 48 8B 41 38 48 8B 08 48 85 C9 74 2C 49 8B 57 50 4C 63 02 4A 8D 04 01 48 3B C8 73 1C 41 8D 40 FF 89 02 49 8B 4F 38 48 8B 11 48 8D 42 01 48 89 01 0F B6 02 E9 98 03 00 00 49 83 BF 80 00 00 00 00 75 08 83 C8 FF E9 86 03 00 00 4D 8B 47 18 49 8D 47 70 49 39 00 75 20 49 8B 97 90 00 00 00 49 8B 8F 88 00 00 00 49 89 08 49 8B 47 38 48 89 08 2B D1 49 8B 47 50 89 10 49 83 7F 68 00 75 22 49 8B 8F 80 00 00 00 E8 ?? ?? ?? ?? 41 83 CC FF 41 3B C4 0F 84 36 03 00 00 44 0F B6 E0 E9 2D 03 00 00 48 8D 4D FF E8 ?? ?? ?? ?? 90 49 8B 8F 80 00 00 00 E8 ?? ?? ?? ?? 41 83 CC FF 41 3B C4 0F 84 EA 02 00 00 44 8A C0 BA 01 00 00 00 48 8D 4D FF E8 ?? ?? ?? ?? 48 8D 55 CF 48 8D 4D FF E8 ?? ?? ?? ?? 48 8B 58 10 48 85 DB 0F 84 B9 02 00 00 48 8B 00 48 85 C0 0F 84 A7 02 00 00 48 8B 00 48 85 C0 0F 84 9B 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CB 0F 87 7B 02 00 00 48 8B 40 18 48 03 C8 48 3B D9 0F 83 6B 02 00 00 48 8D 55 E7 48 8D 4D FF E8 ?? ?? ?? ?? 4C 8B 68 10 4D 85 ED 0F 84 4B 02 00 00 48 8B 00 48 85 C0 0F 84 39 02 00 00 48 8B 00 48 85 C0 0F 84 2D 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 49 3B CD 0F 87 0D 02 00 00 48 8B 40 18 48 03 C8 4C 3B E9 0F 83 FD 01 00 00 4D 8B 77 68 49 8B 0E 48 03 5D 17 48 8B 71 30 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 A7 48 89 44 24 38 48 8D 45 98 48 89 44 24 30 48 8D 45 97 48 89 44 24 28 48 8D 45 9F 48 89 44 24 20 4C 8B CB 4D 8B C5 49 8D 57 74 49 8B CE FF D6 85 C0 0F 88 CF 01 00 00 83 F8 01 7E 16 83 F8 03 0F 85 C1 01 00 00 48 83 7D 17 01 0F 83 8F 00 00 00 EB 7C 48 8D 45 97 48 8D 55 B7 48 8D 4D FF 48 39 45 A7 0F 85 F1 00 00 00 E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 0F 84 D9 00 00 00 48 8B 00 48 85 C0 0F 84 C7 00 00 00 48 8B 00 48 85 C0 0F 84 BB 00 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 9B 00 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 8B 00 00 00 4C 8B 45 9F 4C 2B C2 33 D2 48 8D 4D FF E8 ?? ?? ?? ?? 49 8B 8F 80 00 00 00 E8 ?? ?? ?? ?? E9 34 FE FF FF 48 8D 55 B7 48 8D 4D FF E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 75 06 E8 ?? ?? ?? ?? CC 48 8B 00 48 85 C0 74 3E 48 8B 00 48 85 C0 74 36 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 77 1A 48 8B 40 18 48 03 C8 48 3B D1 73 0E 0F B6 02 88 45 97 44 8B E0 E9 CB 00 00 00 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 75 06 E8 ?? ?? ?? ?? CC 48 8B 00 48 85 C0 74 67 48 8B 00 48 85 C0 74 5F 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 77 43 48 8B 40 18 48 03 C8 48 3B D1 73 37 8B 45 17 48 8B 4D 9F 2B C1 03 C2 48 63 D8 85 C0 7E 1E 48 FF CB 0F BE 0C 0B 49 8B 97 80 00 00 00 E8 ?? ?? ?? ?? 48 85 DB 7E 06 48 8B 4D 9F EB E2 44 0F B6 65 97 EB 30 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 45 33 C0 B2 01 48 8D 4D FF E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D FF E8 ?? ?? ?? ?? 41 8B C4 48 8B 4D 27 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 E0 00 00 00 49 8B 5B 38 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_2_371_1 {
	meta:
		name = "?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"
		size = 76
		refs = "0018 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 01 48 8B F9 48 8B 58 30 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 83 CA FF 3B C2 74 17 48 8B 47 50 01 10 48 8B 4F 38 48 8B 11 48 8D 42 01 48 89 01 0F B6 12 8B C2 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_372_1 {
	meta:
		name = "?underflow@?$basic_filebuf@DU?$char_traits@D@std@@@std@@MEAAHXZ"
		size = 120
		refs = "003e _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 41 38 48 8B F9 4C 8B 00 4D 85 C0 74 15 48 8B 41 50 48 63 10 49 03 D0 4C 3B C2 73 06 41 0F B6 00 EB 35 48 8B 01 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 8B F0 83 C8 FF 3B F0 74 18 48 8B 07 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 8B D6 48 8B CF FF D3 8B C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_2_374_1 {
	meta:
		name = "?unshift@?$codecvt@DDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z"
		size = 96
		refs = "0030 _guard_check_icall"
		altNames = "?unshift@?$codecvt@GDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z ?unshift@?$codecvt@_WDU_Mbstatet@@@std@@QEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 30 48 8B 01 4C 8B F1 49 8B F9 49 8B F0 48 8B EA 48 8B 58 40 48 8B CB E8 ?? ?? ?? ?? 4C 8B CF 4C 8B C6 48 8B D5 49 8B CE 48 8B C3 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5E 48 FF E0 }
	condition:
		$1
}

rule file_2_378_1 {
	meta:
		name = "?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z"
		size = 159
		refs = "0024 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 002d ??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z 0049 _guard_check_icall"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 40 48 C7 40 D8 FE FF FF FF 48 89 58 08 48 89 68 10 48 89 70 18 40 8A EA 48 8D 50 E0 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 8B 7C 24 30 48 85 FF 74 35 48 8B 17 48 8B 5A 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8B 06 48 8B 58 40 48 8B CB E8 ?? ?? ?? ?? 40 8A D5 48 8B CE FF D3 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_2_380_1 {
	meta:
		name = "?widen@?$ctype@D@std@@QEBADD@Z"
		size = 63
		refs = "0020 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 01 48 8B F1 40 8A FA 48 8B 58 40 48 8B CB E8 ?? ?? ?? ?? 40 8A D7 48 8B CE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_2_381_1 {
	meta:
		name = "?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z"
		size = 191
		refs = "0059 memcpy 0083 _guard_check_icall"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 ED 49 8B F8 48 8B F2 4C 8B F1 4D 85 C0 7E 78 49 8B 46 38 48 8B 10 48 85 D2 74 08 49 8B 46 50 8B 08 EB 02 33 C9 48 63 D9 85 C9 7E 32 48 3B FB 48 0F 4C DF 48 85 DB 74 0B 4C 8B C3 48 8B CE E8 ?? ?? ?? ?? 49 8B 46 50 48 03 F3 48 03 EB 48 2B FB 29 18 49 8B 4E 38 48 63 C3 48 01 01 EB 24 49 8B 06 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 83 F8 FF 74 10 88 06 48 FF C5 48 FF C6 48 FF CF 48 85 FF 7F 88 48 8B 5C 24 30 48 8B C5 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_2_382_1 {
	meta:
		name = "?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z"
		size = 195
		refs = "005b memcpy 0089 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 33 ED 49 8B F0 4C 8B F2 4C 8B F9 4D 85 C0 7E 7F 49 8B 47 40 4C 8B 08 4D 85 C9 74 08 49 8B 47 58 8B 08 EB 02 33 C9 48 63 D9 85 C9 7E 35 48 3B F3 48 0F 4C DE 48 85 DB 74 0E 4C 8B C3 49 8B D6 49 8B C9 E8 ?? ?? ?? ?? 49 8B 47 58 4C 03 F3 48 03 EB 48 2B F3 29 18 49 8B 4F 40 48 63 C3 48 01 01 EB 28 49 8B 07 41 0F B6 1E 48 8B 78 18 48 8B CF E8 ?? ?? ?? ?? 8B D3 49 8B CF FF D7 83 F8 FF 74 0E 49 FF C6 48 FF C5 48 FF CE 48 85 F6 7F 81 48 8B 5C 24 40 48 8B C5 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_2_383_1 {
	meta:
		name = "memcpy_s"
		size = 135
		refs = "0027 _errno 0033 _invalid_parameter_noinfo 004c memcpy 0058 memset"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 49 8B D9 49 8B F0 48 8B FA 4D 85 C9 75 04 33 C0 EB 56 48 85 C9 75 15 E8 ?? ?? ?? ?? BB 16 00 00 00 89 18 E8 ?? ?? ?? ?? 8B C3 EB 3C 48 85 F6 74 12 48 3B FB 72 0D 4C 8B C3 48 8B D6 E8 ?? ?? ?? ?? EB CB 4C 8B C7 33 D2 E8 ?? ?? ?? ?? 48 85 F6 74 C5 48 3B FB 73 0C E8 ?? ?? ?? ?? BB 22 00 00 00 EB BE B8 16 00 00 00 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_4_0_1 {
	meta:
		name = "??1_Init_atexit@@QEAA@XZ"
		size = 84
		refs = "0014 ?atfuns_cdecl@@3PAP6AXXZA 0022 ?atcount_cdecl@@3_KA 0028 __imp_DecodePointer 0039 _guard_check_icall"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF EB 30 48 8D 0D ?? ?? ?? ?? 48 8B 0C C1 48 FF C0 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 90 48 8B D8 48 85 C0 74 0C 48 8B C8 E8 ?? ?? ?? ?? 90 FF D3 90 48 8B 05 ?? ?? ?? ?? 48 83 F8 0A 72 C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_4_3_1 {
	meta:
		name = "??__Finit_atexit@@YAXXZ"
		size = 81
		refs = "0014 ?atfuns_cdecl@@3PAP6AXXZA 0022 ?atcount_cdecl@@3_KA 0028 __imp_DecodePointer 0038 _guard_check_icall"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF EB 2D 48 8D 0D ?? ?? ?? ?? 48 8B 0C C1 48 FF C0 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0A 48 8B C8 E8 ?? ?? ?? ?? FF D3 48 8B 05 ?? ?? ?? ?? 48 83 F8 0A 72 C6 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_4_5_1 {
	meta:
		name = "?_Atexit@@YAXP6AXXZ@Z"
		size = 61
		refs = "0007 ?atcount_cdecl@@3_KA 001c __imp_EncodePointer 002a ?atfuns_cdecl@@3PAP6AXXZA 0038 abort"
	strings:
		$1 = { 48 83 EC 28 48 8B 05 ?? ?? ?? ?? 48 85 C0 74 27 48 FF C8 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 04 CA 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_6_1_1 {
	meta:
		name = "_Stoulx"
		size = 462
		refs = "003e isspace 00ce tolower 00d7 digits 00df memchr 0156 ndigs 018e _errno"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 53 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 38 4D 8B F9 41 8B F8 48 8B F2 4C 8B F1 4D 85 C9 74 04 41 83 21 00 0F B6 09 49 8B DE EB 06 48 FF C3 0F B6 0B E8 ?? ?? ?? ?? 85 C0 75 F1 44 8A 23 41 8D 44 24 D5 A8 FD 74 05 41 B4 2B EB 03 48 FF C3 85 FF 74 0C 8D 47 FE 83 F8 22 0F 87 DD 00 00 00 B1 30 85 FF 7E 14 83 FF 10 75 33 38 0B 75 2F 8A 43 01 2C 58 A8 DF 75 26 EB 20 38 0B 74 07 BF 0A 00 00 00 EB 19 8A 43 01 2C 58 A8 DF 74 07 BF 08 00 00 00 EB 09 BF 10 00 00 00 48 83 C3 02 48 89 9C 24 98 00 00 00 EB 03 48 FF C3 38 0B 74 F9 0F BE 0B 33 ED 21 AC 24 90 00 00 00 48 89 5C 24 20 4C 63 EF E8 ?? ?? ?? ?? 8B D0 48 8D 0D ?? ?? ?? ?? 4D 8B C5 E8 ?? ?? ?? ?? 48 85 C0 74 4D 4C 63 F7 48 8D 35 ?? ?? ?? ?? 89 AC 24 90 00 00 00 40 2A C6 44 0F BE E8 48 FF C3 0F AF EF 0F BE 0B 41 03 ED E8 ?? ?? ?? ?? 8B D0 4D 8B C6 48 8B CE E8 ?? ?? ?? ?? 48 85 C0 75 CF 48 8B B4 24 88 00 00 00 4C 8B B4 24 80 00 00 00 EB 08 44 8A AC 24 90 00 00 00 48 39 9C 24 98 00 00 00 75 0C 48 85 F6 74 03 4C 89 36 33 C0 EB 6A 48 8D 0D ?? ?? ?? ?? 48 63 C7 48 0F BE 04 08 48 8B CB 48 2B C8 48 2B 4C 24 20 78 3B 48 85 C9 7F 19 41 0F BE CD 8B C5 2B C1 3B E8 72 0D 33 D2 F7 F7 3B 84 24 90 00 00 00 74 1D E8 ?? ?? ?? ?? C7 00 22 00 00 00 4D 85 FF 74 07 41 C7 07 01 00 00 00 83 CD FF 41 B4 2B 8B C5 F7 D8 41 80 FC 2D 0F 45 C5 48 85 F6 74 03 48 89 1E 48 83 C4 38 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_7_2_1 {
	meta:
		name = "??1?$__crt_scoped_stack_ptr@_W@@QEAA@XZ"
		size = 34
		refs = "0019 _free_base"
	strings:
		$1 = { 48 83 EC 28 48 8B 09 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_7_6_1 {
	meta:
		name = "__crtCompareStringA"
		size = 864
		refs = "0017 __security_cookie 0044 __strncnt 00bf __imp_GetCPInfo 0146 __imp_MultiByteToWideChar 01a3 __chkstk 01ca _malloc_base 0309 __crtCompareStringEx 0325 _free_base 034d __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 48 83 EC 60 48 8D 6C 24 30 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 28 4C 8B AD 90 00 00 00 33 FF 49 63 D9 4D 8B F0 89 55 00 48 89 4D 08 45 85 C9 7E 29 48 8B D3 49 8B C8 E8 ?? ?? ?? ?? 48 8B D8 48 63 B5 98 00 00 00 85 F6 7E 1C 48 8B D6 49 8B CD E8 ?? ?? ?? ?? 48 8B F0 EB 11 83 FB FF 7D E0 33 C0 E9 D3 02 00 00 83 FE FF 7C F4 41 BC 01 00 00 00 85 DB 74 08 85 F6 0F 85 A1 00 00 00 3B DE 75 0A B8 02 00 00 00 E9 AE 02 00 00 41 3B F4 7E 08 41 8B C4 E9 A1 02 00 00 41 3B DC 7E 0A B8 03 00 00 00 E9 92 02 00 00 8B 8D A0 00 00 00 48 8D 55 10 FF 15 ?? ?? ?? ?? 85 C0 74 A4 85 DB 7E 2B 83 7D 10 02 72 D8 40 38 7D 16 48 8D 45 16 74 CE 40 38 78 01 74 C8 41 8A 0E 3A 08 72 05 3A 48 01 76 A0 48 83 C0 02 40 38 38 EB E3 85 F6 7E 30 83 7D 10 02 72 9C 40 38 7D 16 48 8D 45 16 74 92 40 38 78 01 74 8C 41 8A 4D 00 3A 08 72 09 3A 48 01 0F 86 6C FF FF FF 48 83 C0 02 40 38 38 EB DE 8B 8D A0 00 00 00 44 8B CB 89 7C 24 28 4D 8B C6 BA 09 00 00 00 48 89 7C 24 20 FF 15 ?? ?? ?? ?? 4C 63 E0 85 C0 0F 84 16 FF FF FF 49 8B CC 49 B8 F0 FF FF FF FF FF FF 0F 48 03 C9 48 8D 51 10 48 3B CA 48 1B C0 48 85 C2 74 6C 48 3B CA 48 1B C0 48 23 C2 48 3D 00 04 00 00 48 8D 41 10 77 37 48 3B C8 48 1B C9 48 23 C8 48 8D 41 0F 48 3B C1 77 03 49 8B C0 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 7C 24 30 48 85 FF 0F 84 73 01 00 00 C7 07 CC CC 00 00 EB 1C 48 3B C8 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0A C7 00 DD DD 00 00 48 83 C7 10 48 85 FF 0F 84 42 01 00 00 8B 8D A0 00 00 00 44 8B CB 44 89 64 24 28 4D 8B C6 BA 01 00 00 00 48 89 7C 24 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 19 01 00 00 83 64 24 28 00 44 8B CE 8B 8D A0 00 00 00 4D 8B C5 48 83 64 24 20 00 BA 09 00 00 00 FF 15 ?? ?? ?? ?? 4C 63 F0 85 C0 0F 84 EC 00 00 00 49 8B D6 48 03 D2 4C 8D 42 10 49 3B D0 48 1B C9 49 85 C8 74 71 49 3B D0 48 1B C0 49 23 C0 48 3D 00 04 00 00 48 8D 42 10 77 3A 48 3B D0 48 1B C9 48 23 C8 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 5C 24 30 48 85 DB 74 76 C7 03 CC CC 00 00 EB 1C 48 3B D0 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 48 8B D8 48 85 C0 74 0E C7 00 DD DD 00 00 48 83 C3 10 EB 02 33 DB 48 85 DB 74 45 8B 8D A0 00 00 00 44 8B CE 44 89 74 24 28 4D 8B C5 BA 01 00 00 00 48 89 5C 24 20 FF 15 ?? ?? ?? ?? 85 C0 74 20 8B 55 00 45 8B CC 48 8B 4D 08 4C 8B C7 44 89 74 24 28 48 89 5C 24 20 E8 ?? ?? ?? ?? 8B F0 EB 02 33 F6 48 85 DB 74 15 48 8D 4B F0 81 39 DD DD 00 00 75 09 E8 ?? ?? ?? ?? EB 02 33 F6 48 85 FF 74 11 48 8D 4F F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 8B C6 48 8B 4D 28 48 33 CD E8 ?? ?? ?? ?? 48 8D 65 30 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_7_7_1 {
	meta:
		name = "_freea_crt"
		size = 31
		refs = "0016 _free_base"
	strings:
		$1 = { 48 83 EC 28 48 85 C9 74 11 48 83 E9 10 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_7_1 {
	meta:
		name = "__crtLCMapStringA"
		size = 748
		refs = "0022 __security_cookie 0045 __strncnt 0072 __imp_MultiByteToWideChar 00cf __chkstk 00f6 _malloc_base 0157 __crtLCMapStringEx 028a __imp_WideCharToMultiByte 02a6 _free_base 02ce __security_check_cookie"
	strings:
		$1 = { 40 55 41 56 41 57 48 83 EC 50 48 8D 6C 24 40 48 89 5D 30 48 89 75 38 48 89 7D 40 4C 89 6D 48 48 8B 05 ?? ?? ?? ?? 48 33 C5 48 89 45 00 49 63 D9 49 8B F8 44 8B FA 4C 8B E9 45 85 C9 7E 14 48 8B D3 49 8B C8 E8 ?? ?? ?? ?? 3B C3 8D 58 01 7C 02 8B D8 F7 5D 68 44 8B CB 8B 4D 60 4C 8B C7 1B D2 83 64 24 28 00 48 83 64 24 20 00 83 E2 08 FF C2 FF 15 ?? ?? ?? ?? 4C 63 F0 85 C0 0F 84 45 02 00 00 49 8B CE 49 B8 F0 FF FF FF FF FF FF 0F 48 03 C9 48 8D 51 10 48 3B CA 48 1B C0 48 85 C2 74 6E 48 3B CA 48 1B C0 48 23 C2 48 3D 00 04 00 00 48 8D 41 10 77 37 48 3B C8 48 1B C9 48 23 C8 48 8D 41 0F 48 3B C1 77 03 49 8B C0 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 74 24 40 48 85 F6 0F 84 C8 01 00 00 C7 06 CC CC 00 00 EB 1C 48 3B C8 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 48 8B F0 48 85 C0 74 0E C7 00 DD DD 00 00 48 83 C6 10 EB 02 33 F6 48 85 F6 0F 84 93 01 00 00 8B 4D 60 44 8B CB 44 89 74 24 28 4C 8B C7 BA 01 00 00 00 48 89 74 24 20 FF 15 ?? ?? ?? ?? 85 C0 0F 84 6D 01 00 00 83 64 24 28 00 45 8B CE 48 83 64 24 20 00 4C 8B C6 41 8B D7 49 8B CD E8 ?? ?? ?? ?? 48 63 D8 85 C0 0F 84 46 01 00 00 41 B8 00 04 00 00 45 85 F8 74 36 8B 45 58 85 C0 0F 84 32 01 00 00 3B D8 0F 8F 2A 01 00 00 89 44 24 28 45 8B CE 48 8B 45 50 4C 8B C6 41 8B D7 48 89 44 24 20 49 8B CD E8 ?? ?? ?? ?? E9 07 01 00 00 48 8B CB 48 03 C9 48 8D 51 10 48 3B CA 48 1B C0 48 85 C2 74 72 48 3B CA 48 1B C0 48 23 C2 49 3B C0 48 8D 41 10 77 3E 48 3B C8 48 1B C9 48 23 C8 48 8D 41 0F 48 3B C1 77 0A 48 B8 F0 FF FF FF FF FF FF 0F 48 83 E0 F0 E8 ?? ?? ?? ?? 48 2B E0 48 8D 7C 24 40 48 85 FF 0F 84 AA 00 00 00 C7 07 CC CC 00 00 EB 1C 48 3B C8 48 1B C9 48 23 C8 E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 74 0E C7 00 DD DD 00 00 48 83 C7 10 EB 02 33 FF 48 85 FF 74 79 89 5C 24 28 45 8B CE 4C 8B C6 48 89 7C 24 20 41 8B D7 49 8B CD E8 ?? ?? ?? ?? 85 C0 74 41 48 83 64 24 38 00 33 D2 48 21 54 24 30 44 8B CB 8B 45 58 4C 8B C7 8B 4D 60 85 C0 75 0B 21 54 24 28 48 21 54 24 20 EB 0D 89 44 24 28 48 8B 45 50 48 89 44 24 20 FF 15 ?? ?? ?? ?? 8B D8 85 C0 75 05 48 85 FF 74 15 48 8D 4F F0 81 39 DD DD 00 00 75 09 E8 ?? ?? ?? ?? EB 02 33 DB 48 85 F6 74 11 48 8D 4E F0 81 39 DD DD 00 00 75 05 E8 ?? ?? ?? ?? 8B C3 48 8B 4D 00 48 33 CD E8 ?? ?? ?? ?? 48 8B 5D 30 48 8B 75 38 48 8B 7D 40 4C 8B 6D 48 48 8D 65 10 41 5F 41 5E 5D C3 }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "_Towlower"
		size = 115
		refs = "005a __crtLCMapStringW"
	strings:
		$1 = { 66 89 4C 24 08 48 83 EC 38 48 8B C2 66 89 4C 24 50 BA FF FF 00 00 66 3B CA 74 50 48 83 78 18 00 BA 00 01 00 00 75 14 66 3B CA 73 0F 8D 41 BF 66 83 F8 19 77 36 66 83 C1 20 EB 30 41 B9 01 00 00 00 48 8D 4C 24 50 44 89 4C 24 28 4C 8D 44 24 40 48 89 4C 24 20 48 8B 48 18 E8 ?? ?? ?? ?? 0F B7 4C 24 50 85 C0 66 0F 44 4C 24 40 0F B7 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_11_73_1 {
	meta:
		name = "??0_Init_clog@std@@QEAA@XZ"
		size = 41
		refs = "0003 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0011 ?_Ptr_clog@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA 001c ?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B C1 C3 }
	condition:
		$1
}

rule file_109_73_1 {
	meta:
		name = "??0_Init_cin@std@@QEAA@XZ"
		size = 41
		refs = "0003 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 0011 ?_Ptr_cin@std@@3PEAV?$basic_istream@DU?$char_traits@D@std@@@1@EA 001c ?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B C1 C3 }
	condition:
		$1
}

rule file_50_73_1 {
	meta:
		name = "??0_Init_ushcin@std@@QEAA@XZ"
		size = 41
		refs = "0003 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0011 ?_Ptr_wcin@std@@3PEAV?$basic_istream@GU?$char_traits@G@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B C1 C3 }
	condition:
		$1
}

rule file_118_73_1 {
	meta:
		name = "??0_Init_ushclog@std@@QEAA@XZ"
		size = 41
		refs = "0003 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0011 ?_Ptr_wclog@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B C1 C3 }
	condition:
		$1
}

rule file_111_73_1 {
	meta:
		name = "??0_Init_wcin@std@@QEAA@XZ"
		size = 41
		refs = "0003 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0011 ?_Ptr_wcin@std@@3PEAV?$basic_istream@_WU?$char_traits@_W@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B C1 C3 }
	condition:
		$1
}

rule file_114_73_1 {
	meta:
		name = "??0_Init_wclog@std@@QEAA@XZ"
		size = 41
		refs = "0003 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0011 ?_Ptr_wclog@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B C1 C3 }
	condition:
		$1
}

rule file_11_175_1 {
	meta:
		name = "??__Eflog@std@@YAXXZ"
		size = 80
		refs = "000c __acrt_iob_func 0013 ?flog@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 001b ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ 0022 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 003b ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z 0042 ??__Fflog@std@@YAXXZ 004c atexit"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 45 33 C0 48 8B D3 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_175_1 {
	meta:
		name = "??__Eferr@std@@YAXXZ"
		size = 80
		refs = "000c __acrt_iob_func 0013 ?ferr@std@@3V?$basic_filebuf@DU?$char_traits@D@std@@@1@A 001b ??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ 0022 ??_7?$basic_filebuf@DU?$char_traits@D@std@@@std@@6B@ 003b ?_Init@?$basic_filebuf@DU?$char_traits@D@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z 0042 ??__Fferr@std@@YAXXZ 004c atexit"
	strings:
		$1 = { 40 53 48 83 EC 20 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 8B D8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 45 33 C0 48 8B D3 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_176_1 {
	meta:
		name = "??__Einit_clog@std@@YAXXZ"
		size = 38
		refs = "0003 ?clog@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0011 ?_Ptr_clog@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA 001c ?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 C3 }
	condition:
		$1
}

rule file_109_176_1 {
	meta:
		name = "??__Einit_cin@std@@YAXXZ"
		size = 38
		refs = "0003 ?cin@std@@3V?$basic_istream@DU?$char_traits@D@std@@@1@A 0011 ?_Ptr_cin@std@@3PEAV?$basic_istream@DU?$char_traits@D@std@@@1@EA 001c ?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 C3 }
	condition:
		$1
}

rule file_50_173_1 {
	meta:
		name = "??__Einit_ushcin@std@@YAXXZ"
		size = 38
		refs = "0003 ?wcin@std@@3V?$basic_istream@GU?$char_traits@G@std@@@1@A 0011 ?_Ptr_wcin@std@@3PEAV?$basic_istream@GU?$char_traits@G@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 C3 }
	condition:
		$1
}

rule file_118_173_1 {
	meta:
		name = "??__Einit_ushclog@std@@YAXXZ"
		size = 38
		refs = "0003 ?wclog@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0011 ?_Ptr_wclog@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 C3 }
	condition:
		$1
}

rule file_111_173_1 {
	meta:
		name = "??__Einit_wcin@std@@YAXXZ"
		size = 38
		refs = "0003 ?wcin@std@@3V?$basic_istream@_WU?$char_traits@_W@std@@@1@A 0011 ?_Ptr_wcin@std@@3PEAV?$basic_istream@_WU?$char_traits@_W@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 C3 }
	condition:
		$1
}

rule file_114_173_1 {
	meta:
		name = "??__Einit_wclog@std@@YAXXZ"
		size = 38
		refs = "0003 ?wclog@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0011 ?_Ptr_wclog@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 C3 }
	condition:
		$1
}

rule file_12_0_1 {
	meta:
		name = "_Stoflt"
		size = 713
		refs = "0017 __security_cookie 0078 isdigit 00c3 localeconv 02ad __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 70 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 68 8B 84 24 D0 00 00 00 49 8B F1 48 89 4C 24 30 48 8B DA 33 C9 4C 89 44 24 28 49 89 09 8B E9 44 8D 2C C0 89 4C 24 24 44 8B F9 8D 41 2D 44 3B E8 44 8D 71 01 44 0F 4F E8 80 3A 30 44 89 6C 24 20 75 0B 45 8B FE 49 03 DE 80 3B 30 74 F8 8B F9 4D 63 E5 0F B6 0B E8 ?? ?? ?? ?? 85 C0 74 42 45 33 F6 45 8D 6E 01 45 8B FD 4D 3B F4 7D 11 8A 03 41 03 FD 2C 30 42 88 44 34 38 4D 03 F5 EB 0A 44 01 2E 80 3B 30 41 0F 45 ED 49 03 DD 0F B6 0B E8 ?? ?? ?? ?? 85 C0 75 D1 44 8B 6C 24 20 44 8D 70 01 E8 ?? ?? ?? ?? 48 8D 53 01 48 8B 08 8A 03 3A 01 48 0F 45 D3 48 8B DA 85 FF 75 12 80 3A 30 75 0D 45 8B FE FF 0E 49 03 DE 80 3B 30 74 F6 0F B6 0B E8 ?? ?? ?? ?? 85 C0 74 3F 41 BD 01 00 00 00 4C 63 F7 45 8B FD 4D 3B F4 7D 13 8A 03 41 03 FD 2C 30 42 88 44 34 38 4D 03 F5 FF 0E EB 07 80 3B 30 41 0F 45 ED 49 03 DD 0F B6 0B E8 ?? ?? ?? ?? 85 C0 75 D2 44 8B 6C 24 20 41 BE 01 00 00 00 85 ED 74 0C 41 8D 45 FF 48 63 C8 44 00 74 0C 38 48 63 C7 85 FF 7E 1E 48 8D 4C 24 38 49 2B CE 80 3C 01 00 75 0E 44 01 36 41 2B FE 49 2B C6 48 85 C0 7F EC 85 FF 75 08 41 8B FE C6 44 24 38 00 45 85 FF 0F 84 F4 00 00 00 BD 39 8E E3 38 4C 63 DF 45 33 ED 8B C5 F7 EF D1 FA 8B C2 FF C2 C1 E8 1F 03 C2 44 8D 14 C0 8B C5 44 2B D7 41 F7 EA D1 FA 8B C2 C1 E8 1F 03 D0 8D 04 D2 44 3B D0 41 0F 95 C5 85 FF 7E 49 45 33 C0 45 8B CD 8B C5 41 F7 EA D1 FA 8B C2 C1 E8 1F 03 D0 8D 0C D2 44 3B D1 75 0E 42 0F BE 44 04 38 45 03 EE 4D 03 CE EB 10 42 8B 04 8E 42 0F BE 54 04 38 8D 0C 80 8D 04 4A 45 03 D6 42 89 04 8E 4D 03 C6 4D 3B C3 7C BD 8A 03 2C 45 A8 DF 75 6B 4C 8B E3 40 B5 2B 49 03 DE 8A 03 40 2A C5 A8 FD 75 06 40 8A 2B 49 03 DE 0F B6 0B 45 33 F6 33 FF E8 ?? ?? ?? ?? 85 C0 74 27 44 8D 77 01 81 FF 00 E1 F5 05 7D 0C 0F B6 03 8D 3C BF 8D 7F E8 8D 3C 78 48 FF C3 0F B6 0B E8 ?? ?? ?? ?? 85 C0 75 DD 8B C7 F7 D8 40 80 FD 2D 0F 45 C7 01 06 45 85 F6 49 0F 44 DC EB 05 44 8B 6C 24 24 48 8B 54 24 28 41 8B C7 F7 D8 1B C0 41 23 C5 48 85 D2 74 0F 48 8B 4C 24 30 45 85 FF 48 0F 45 CB 48 89 0A 48 8B 4C 24 68 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B0 00 00 00 48 83 C4 70 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_13_0_1 {
	meta:
		name = "_WStopfx"
		size = 483
		refs = "0031 iswctype"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 20 48 8B 19 33 F6 4C 8B FA 4C 8B E1 0F B7 0B 8D 6E 08 8B D5 E8 ?? ?? ?? ?? 8D 7E 02 EB 0D 48 03 DF 8B D5 0F B7 0B E8 ?? ?? ?? ?? 85 C0 75 EF 66 83 3B 2D 75 04 8B F5 EB 06 66 83 3B 2B 75 03 48 03 DF 0F B7 03 66 41 B8 4E 00 66 41 2B C0 BA DF FF 00 00 66 85 C2 0F 84 E0 00 00 00 0F B7 03 66 83 E8 49 66 85 C2 74 4C 66 83 3B 30 75 3E 0F B7 43 02 66 83 E8 58 66 85 C2 75 31 48 8D 6B 04 BA 80 00 00 00 66 83 7D 00 2E 48 8D 45 02 48 0F 45 C5 0F B7 08 E8 ?? ?? ?? ?? 85 C0 75 05 8D 78 01 EB 03 48 8B DD 0B F7 E9 F6 00 00 00 83 CE 01 E9 EE 00 00 00 48 03 DF 0F B7 03 66 41 2B C0 66 85 C2 0F 85 CD 00 00 00 48 03 DF 0F B7 03 66 83 E8 46 66 85 C2 0F 85 BA 00 00 00 48 03 DF 83 CE 03 0F B7 03 66 83 E8 49 66 85 C2 0F 85 AA 00 00 00 48 8D 4B 02 0F B7 01 66 41 2B C0 66 85 C2 0F 85 96 00 00 00 48 03 CF 0F B7 01 66 83 E8 49 66 85 C2 0F 85 83 00 00 00 48 03 CF 0F B7 01 66 83 E8 54 66 85 C2 75 74 0F B7 04 39 66 83 E8 59 66 85 C2 75 67 48 8D 5F 02 48 03 D9 EB 5E 48 03 DF 0F B7 03 66 83 E8 41 66 85 C2 75 49 48 03 DF 0F B7 03 66 41 2B C0 66 85 C2 75 3A 48 03 DF BE 04 00 00 00 4C 8B F3 66 83 3B 28 75 2F 4C 03 F7 BA 07 01 00 00 41 0F B7 0E E8 ?? ?? ?? ?? 85 C0 75 EB 66 41 83 3E 5F 74 E4 66 41 83 3E 29 75 0C 49 8D 5E 02 EB 06 49 8B 1C 24 33 F6 4D 85 FF 74 03 49 89 1F 48 8B 6C 24 48 8B C6 48 8B 74 24 50 48 8B 7C 24 58 49 89 1C 24 48 8B 5C 24 40 48 83 C4 20 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_14_6_1 {
	meta:
		name = "??$_Fgetc@G@std@@YA_NAEAGPEAU_iobuf@@@Z"
		size = 42
		refs = "000d fgetwc"
		altNames = "??$_Fgetc@_W@std@@YA_NAEA_WPEAU_iobuf@@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B CA E8 ?? ?? ?? ?? B9 FF FF 00 00 66 3B C1 75 04 32 C0 EB 05 66 89 03 B0 01 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_14_7_1 {
	meta:
		name = "??$_Fputc@G@std@@YA_NGPEAU_iobuf@@@Z"
		size = 25
		refs = "0005 fputwc"
		altNames = "??$_Fputc@_W@std@@YA_N_WPEAU_iobuf@@@Z"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? BA FF FF 00 00 66 3B C2 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_14_12_1 {
	meta:
		name = "??$_Ungetc@G@std@@YA_NAEBGPEAU_iobuf@@@Z"
		size = 28
		refs = "0008 ungetwc"
		altNames = "??$_Ungetc@_W@std@@YA_NAEB_WPEAU_iobuf@@@Z"
	strings:
		$1 = { 48 83 EC 28 0F B7 09 E8 ?? ?? ?? ?? BA FF FF 00 00 66 3B C2 0F 95 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_14_51_1 {
	meta:
		name = "??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z"
		size = 159
		refs = "0011 ??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAA@XZ 001a ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 0085 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 33 C9 48 8D 05 ?? ?? ?? ?? 48 89 07 4C 8D 47 10 88 4F 7C 48 8D 47 08 48 89 47 18 48 8D 47 28 48 89 47 38 48 8D 47 30 48 89 47 40 48 8D 47 48 48 89 47 50 48 8D 47 4C 48 89 47 58 88 4F 72 4C 89 47 20 49 89 08 48 8B 47 40 48 89 08 48 8B 47 58 89 08 48 8B 47 18 48 89 08 48 8B 47 38 48 89 08 48 8B 47 50 89 08 48 89 9F 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 5C 24 30 48 89 47 74 48 8B C7 48 89 4F 68 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_95_51_1 {
	meta:
		name = "??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z"
		size = 159
		refs = "0011 ??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAA@XZ 001a ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 0085 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 33 C9 48 8D 05 ?? ?? ?? ?? 48 89 07 4C 8D 47 10 88 4F 7C 48 8D 47 08 48 89 47 18 48 8D 47 28 48 89 47 38 48 8D 47 30 48 89 47 40 48 8D 47 48 48 89 47 50 48 8D 47 4C 48 89 47 58 88 4F 72 4C 89 47 20 49 89 08 48 8B 47 40 48 89 08 48 8B 47 58 89 08 48 8B 47 18 48 89 08 48 8B 47 38 48 89 08 48 8B 47 50 89 08 48 89 9F 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 8B 5C 24 30 48 89 47 74 48 8B C7 48 89 4F 68 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_53_1 {
	meta:
		name = "??0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z"
		size = 124
		refs = "0026 ??_8?$basic_ostream@GU?$char_traits@G@std@@@std@@7B@ 0030 ??_7?$basic_ios@GU?$char_traits@G@std@@@std@@6B@ 004a ??_7?$basic_ostream@GU?$char_traits@G@std@@@std@@6B@ 006e ?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IEAAXPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 4C 8B D2 48 8B D9 83 64 24 58 00 45 85 C9 74 1D 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 05 ?? ?? ?? ?? 48 89 41 10 C7 44 24 58 01 00 00 00 48 8B 01 48 63 48 04 48 8D 05 ?? ?? ?? ?? 48 89 04 19 48 8B 03 48 63 48 04 8D 51 F0 89 54 19 FC 48 8B 03 48 63 48 04 48 03 CB 49 8B D2 E8 ?? ?? ?? ?? 90 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_95_53_1 {
	meta:
		name = "??0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z"
		size = 124
		refs = "0026 ??_8?$basic_ostream@_WU?$char_traits@_W@std@@@std@@7B@ 0030 ??_7?$basic_ios@_WU?$char_traits@_W@std@@@std@@6B@ 004a ??_7?$basic_ostream@_WU?$char_traits@_W@std@@@std@@6B@ 006e ?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAAXPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 4C 8B D2 48 8B D9 83 64 24 58 00 45 85 C9 74 1D 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8D 05 ?? ?? ?? ?? 48 89 41 10 C7 44 24 58 01 00 00 00 48 8B 01 48 63 48 04 48 8D 05 ?? ?? ?? ?? 48 89 04 19 48 8B 03 48 63 48 04 8D 51 F0 89 54 19 FC 48 8B 03 48 63 48 04 48 03 CB 49 8B D2 E8 ?? ?? ?? ?? 90 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_14_54_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@PEAV?$basic_streambuf@GU?$char_traits@G@std@@@1@_N@Z@4HA"
		size = 42
		refs = "0020 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 58 83 E0 01 85 C0 74 11 83 65 58 FE 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_95_54_1 {
	meta:
		name = "?dtor$0@?0???0?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@PEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@1@_N@Z@4HA"
		size = 42
		refs = "0020 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 58 83 E0 01 85 C0 74 11 83 65 58 FE 48 8B 4D 40 48 83 C1 10 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_14_64_1 {
	meta:
		name = "??0?$codecvt@GDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 73
		refs = "0009 ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 001d _Getcvt"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 F2 0F 10 40 20 F2 0F 11 43 30 8B 40 28 89 43 38 48 8B C3 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_41_260_1 {
	meta:
		name = "??0?$codecvt@_WDU_Mbstatet@@@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 73
		refs = "0009 ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 001d _Getcvt"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 F2 0F 10 40 20 F2 0F 11 43 30 8B 40 28 89 43 38 48 8B C3 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_14_65_1 {
	meta:
		name = "??0?$ctype@G@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 98
		refs = "0009 ??_7?$ctype@G@std@@6B@ 001d _Getctype 0036 _Getcvt"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 30 0F 10 48 10 0F 11 4B 40 F2 0F 10 40 20 F2 0F 11 43 50 8B 40 28 89 43 58 48 8B C3 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_41_264_1 {
	meta:
		name = "??0?$ctype@_W@std@@QEAA@AEBV_Locinfo@1@_K@Z"
		size = 98
		refs = "0009 ??_7?$ctype@_W@std@@6B@ 001d _Getctype 0036 _Getcvt"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8D 05 ?? ?? ?? ?? 44 89 41 08 48 89 01 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 30 0F 10 48 10 0F 11 4B 40 F2 0F 10 40 20 F2 0F 11 43 50 8B 40 28 89 43 58 48 8B C3 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_14_73_1 {
	meta:
		name = "??0_Init_ushcerr@std@@QEAA@XZ"
		size = 58
		refs = "0003 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0011 ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B 05 ?? ?? ?? ?? 48 63 50 04 48 8B C1 42 83 4C 02 18 02 C3 }
	condition:
		$1
}

rule file_81_73_1 {
	meta:
		name = "??0_Init_cerr@std@@QEAA@XZ"
		size = 58
		refs = "0003 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0011 ?_Ptr_cerr@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA 001c ?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B 05 ?? ?? ?? ?? 48 63 50 04 48 8B C1 42 83 4C 02 18 02 C3 }
	condition:
		$1
}

rule file_113_73_1 {
	meta:
		name = "??0_Init_wcerr@std@@QEAA@XZ"
		size = 58
		refs = "0003 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0011 ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 4C 89 05 ?? ?? ?? ?? 48 63 50 04 48 8B 05 ?? ?? ?? ?? 4A 89 44 02 50 48 8B 05 ?? ?? ?? ?? 48 63 50 04 48 8B C1 42 83 4C 02 18 02 C3 }
	condition:
		$1
}

rule file_14_117_1 {
	meta:
		name = "??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ"
		size = 139
		refs = "0015 ??_7?$basic_filebuf@GU?$char_traits@G@std@@@std@@6B@ 0062 ?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAAPEAV12@XZ 006a ??_7?$basic_streambuf@GU?$char_traits@G@std@@@std@@6B@ 0080 ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 48 83 B9 80 00 00 00 00 74 32 48 8B 49 18 48 8D 43 70 48 39 01 75 25 4C 8B 83 90 00 00 00 48 8B 93 88 00 00 00 48 89 11 48 8B 43 38 48 89 10 4C 2B C2 49 D1 F8 48 8B 43 50 44 89 00 80 7B 7C 00 74 09 48 8B CB E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B 4B 60 48 85 C9 74 0B BA 01 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_95_117_1 {
	meta:
		name = "??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ"
		size = 139
		refs = "0015 ??_7?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@6B@ 0062 ?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAAPEAV12@XZ 006a ??_7?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@6B@ 0080 ??_Glocale@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 48 8D 05 ?? ?? ?? ?? 48 89 01 48 83 B9 80 00 00 00 00 74 32 48 8B 49 18 48 8D 43 70 48 39 01 75 25 4C 8B 83 90 00 00 00 48 8B 93 88 00 00 00 48 89 11 48 8B 43 38 48 89 10 4C 2B C2 49 D1 F8 48 8B 43 50 44 89 00 80 7B 7C 00 74 09 48 8B CB E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8B 4B 60 48 85 C9 74 0B BA 01 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_14_123_1 {
	meta:
		name = "??1?$ctype@G@std@@MEAA@XZ"
		size = 59
		refs = "000d ??_7?$ctype@G@std@@6B@ 001e free 002e ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 83 79 20 00 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B D9 74 09 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_352_1 {
	meta:
		name = "??1?$ctype@_W@std@@MEAA@XZ"
		size = 59
		refs = "000d ??_7?$ctype@_W@std@@6B@ 001e free 002e ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 83 79 20 00 48 8D 05 ?? ?? ?? ?? 48 89 01 48 8B D9 74 09 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_14_156_1 {
	meta:
		name = "??_G?$codecvt@GDU_Mbstatet@@@std@@MEAAPEAXI@Z"
		size = 43
		refs = "0009 ??_7_Facet_base@std@@6B@ 001e ??3@YAXPEAX_K@Z"
		altNames = "??_G?$codecvt@_WDU_Mbstatet@@@std@@MEAAPEAXI@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 F6 C2 01 74 0A BA 40 00 00 00 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_14_157_1 {
	meta:
		name = "??_G?$ctype@G@std@@MEAAPEAXI@Z"
		size = 92
		refs = "0011 ??_7?$ctype@G@std@@6B@ 0024 free 0034 ??_7_Facet_base@std@@6B@ 004a ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 83 79 20 00 48 8D 05 ?? ?? ?? ?? 48 89 01 8B FA 48 8B D9 74 09 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 40 F6 C7 01 74 0D BA 60 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_41_461_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MEAAPEAXI@Z"
		size = 92
		refs = "0011 ??_7?$ctype@_W@std@@6B@ 0024 free 0034 ??_7_Facet_base@std@@6B@ 004a ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 83 79 20 00 48 8D 05 ?? ?? ?? ?? 48 89 01 8B FA 48 8B D9 74 09 48 8B 49 18 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 40 F6 C7 01 74 0D BA 60 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_173_1 {
	meta:
		name = "??__Einit_ushcerr@std@@YAXXZ"
		size = 54
		refs = "0003 ?wcerr@std@@3V?$basic_ostream@GU?$char_traits@G@std@@@1@A 0011 ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 48 8B 05 ?? ?? ?? ?? 48 63 48 04 83 4C 11 18 02 C3 }
	condition:
		$1
}

rule file_81_176_1 {
	meta:
		name = "??__Einit_cerr@std@@YAXXZ"
		size = 54
		refs = "0003 ?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A 0011 ?_Ptr_cerr@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA 001c ?_Ptr_cout@std@@3PEAV?$basic_ostream@DU?$char_traits@D@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 48 8B 05 ?? ?? ?? ?? 48 63 48 04 83 4C 11 18 02 C3 }
	condition:
		$1
}

rule file_113_173_1 {
	meta:
		name = "??__Einit_wcerr@std@@YAXXZ"
		size = 54
		refs = "0003 ?wcerr@std@@3V?$basic_ostream@_WU?$char_traits@_W@std@@@1@A 0011 ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 001c ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 15 ?? ?? ?? ?? 48 63 48 04 48 8B 05 ?? ?? ?? ?? 48 89 44 11 50 48 8B 05 ?? ?? ?? ?? 48 63 48 04 83 4C 11 18 02 C3 }
	condition:
		$1
}

rule file_14_176_1 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 45
		refs = "000a __acrt_iob_func 0014 ?wferr@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0019 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwferr@std@@YAXXZ 0029 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_176_1 {
	meta:
		name = "??__Ewferr@std@@YAXXZ"
		size = 45
		refs = "000a __acrt_iob_func 0014 ?wferr@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwferr@std@@YAXXZ 0029 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_176_1 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 45
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0029 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_176_1 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 45
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0019 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0029 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_151_2 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 45
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@_WU?$char_traits@_W@std@@@1@A 0019 ??0?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0029 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_151_2 {
	meta:
		name = "??__Ewflog@std@@YAXXZ"
		size = 45
		refs = "000a __acrt_iob_func 0014 ?wflog@std@@3V?$basic_filebuf@GU?$char_traits@G@std@@@1@A 0019 ??0?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAA@PEAU_iobuf@@@Z 0020 ??__Fwflog@std@@YAXXZ 0029 atexit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 83 C4 28 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_196_1 {
	meta:
		name = "?_Donarrow@?$ctype@G@std@@IEBADGD@Z"
		size = 83
		refs = "0009 __security_cookie 002f _Wcrtomb 0049 __security_check_cookie"
		altNames = "?_Donarrow@?$ctype@_W@std@@IEBAD_WD@Z ?do_narrow@?$ctype@G@std@@MEBADGD@Z ?do_narrow@?$ctype@_W@std@@MEBAD_WD@Z"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 41 0F B6 D8 4C 8D 49 30 33 C0 4C 8D 44 24 20 48 8D 4C 24 28 48 89 44 24 20 E8 ?? ?? ?? ?? 0F B6 54 24 28 83 F8 01 0F 45 D3 8A C2 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_14_197_1 {
	meta:
		name = "?_Dowiden@?$ctype@G@std@@IEBAGD@Z"
		size = 72
		refs = "002c _Mbrtowc"
		altNames = "?_Dowiden@?$ctype@_W@std@@IEBA_WD@Z"
	strings:
		$1 = { 88 54 24 10 4C 8B DC 48 83 EC 38 33 C0 4D 8D 4B 18 49 89 43 18 49 8D 53 10 48 8D 41 30 41 B8 01 00 00 00 49 8D 4B 08 49 89 43 E8 E8 ?? ?? ?? ?? 0F B7 4C 24 40 85 C0 BA FF FF 00 00 66 0F 48 CA 0F B7 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_14_198_1 {
	meta:
		name = "?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAA_NXZ"
		size = 843
		refs = "002e __security_cookie 006a _guard_check_icall 008e ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 009c ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 0265 fwrite 029c ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 02ad _invalid_parameter_noinfo_noreturn 02cb ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 02dd ?_Deallocate@std@@YAXPEAX_K1@Z 0326 __security_check_cookie"
		altNames = "?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAA_NXZ"
	strings:
		$1 = { 48 8B C4 55 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC C0 00 00 00 48 C7 45 B7 FE FF FF FF 48 89 58 10 48 89 70 18 48 89 78 20 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 2F 4C 8B E1 45 33 FF 45 8B EF 44 89 7D A7 4C 39 79 68 0F 84 CC 02 00 00 44 38 79 72 0F 84 C2 02 00 00 48 8B 01 BF FF FF 00 00 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 0F B7 D7 49 8B CC FF D3 66 3B F8 75 07 32 C0 E9 9C 02 00 00 45 33 C0 41 8D 50 08 48 8D 4D 07 E8 ?? ?? ?? ?? 90 48 8D 55 BF 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8B 58 10 48 85 DB 0F 84 69 02 00 00 48 8B 00 48 85 C0 0F 84 57 02 00 00 48 8B 00 48 85 C0 0F 84 4B 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CB 0F 87 2B 02 00 00 48 8B 40 18 48 03 C8 48 3B D9 0F 83 1B 02 00 00 48 8D 55 EF 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8B 50 10 48 89 55 A7 48 85 D2 0F 84 F7 01 00 00 48 8B 00 48 85 C0 0F 84 E5 01 00 00 48 8B 00 48 85 C0 0F 84 D9 01 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 B9 01 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 A9 01 00 00 4D 8B 74 24 68 49 8B 16 48 03 5D 1F 48 8B 72 40 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 AF 48 89 44 24 20 4C 8B CB 4C 8B 45 A7 49 8D 54 24 74 49 8B CE FF D6 8B C8 85 C0 74 0B 83 E9 01 0F 85 15 01 00 00 EB 05 45 88 7C 24 72 48 8D 55 D7 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 0F 84 41 01 00 00 48 8B 00 48 85 C0 0F 84 2F 01 00 00 48 8B 00 48 85 C0 0F 84 23 01 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 03 01 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 F3 00 00 00 48 8B 5D AF 48 2B DA 74 74 41 83 CD 01 48 8D 55 D7 48 8D 4D 07 E8 ?? ?? ?? ?? 48 8B 48 10 48 85 C9 0F 84 9E 00 00 00 48 8B 00 48 85 C0 0F 84 8C 00 00 00 48 8B 00 48 85 C0 0F 84 80 00 00 00 48 83 78 20 10 72 06 48 8B 50 08 EB 04 48 8D 50 08 48 3B D1 77 64 48 8B 40 18 48 03 D0 48 3B CA 73 58 4D 8B 8C 24 80 00 00 00 4C 8B C3 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 3B D8 B0 01 75 03 41 8A C7 41 F6 C5 01 74 04 41 83 E5 FE 84 C0 75 40 45 38 7C 24 72 74 36 48 85 DB 0F 85 02 FE FF FF 45 33 C0 8D 53 08 48 8D 4D 07 E8 ?? ?? ?? ?? E9 EE FD FF FF 83 F9 02 75 17 EB 12 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 41 B7 01 45 33 C0 B2 01 48 8D 4D 07 E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D 07 E8 ?? ?? ?? ?? 41 8A C7 EB 38 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 B0 01 48 8B 4D 2F 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 C0 00 00 00 49 8B 5B 38 49 8B 73 40 49 8B 7B 48 49 8B E3 41 5F 41 5E 41 5D 41 5C 5D C3 }
	condition:
		$1
}

rule file_14_210_1 {
	meta:
		name = "?_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 243
		refs = "0045 ??2@YAPEAX_K@Z 0065 ??_C@_00CNPNBAHC@?$AA@ 007e ??0_Locinfo@std@@QEAA@PEBD@Z 008e ??_7?$codecvt@GDU_Mbstatet@@@std@@6B@ 009b _Getcvt 00d1 ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC C0 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 D0 00 00 00 48 85 C9 0F 84 9D 00 00 00 48 39 31 0F 85 94 00 00 00 8D 4E 40 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 D0 00 00 00 48 85 C0 74 67 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 58 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8D 4C 24 28 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 F2 0F 10 40 20 F2 0F 11 43 30 8B 40 28 89 43 38 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 58 E8 ?? ?? ?? ?? B8 02 00 00 00 4C 8D 9C 24 C0 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_41_588_1 {
	meta:
		name = "?_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 243
		refs = "0045 ??2@YAPEAX_K@Z 0065 ??_C@_00CNPNBAHC@?$AA@ 007e ??0_Locinfo@std@@QEAA@PEBD@Z 008e ??_7?$codecvt@_WDU_Mbstatet@@@std@@6B@ 009b _Getcvt 00d1 ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC C0 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 D0 00 00 00 48 85 C9 0F 84 9D 00 00 00 48 39 31 0F 85 94 00 00 00 8D 4E 40 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 D0 00 00 00 48 85 C0 74 67 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 58 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8D 4C 24 28 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 F2 0F 10 40 20 F2 0F 11 43 30 8B 40 28 89 43 38 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 58 E8 ?? ?? ?? ?? B8 02 00 00 00 4C 8D 9C 24 C0 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_14_211_1 {
	meta:
		name = "?dtor$0@?0??_Getcat@?$codecvt@GDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
		size = 32
		refs = "0016 ??3@YAXPEAX_K@Z"
		altNames = "?dtor$0@?0??_Getcat@?$codecvt@_WDU_Mbstatet@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA BA 40 00 00 00 48 8B 8D D0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_14_212_1 {
	meta:
		name = "?_Getcat@?$ctype@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 272
		refs = "0045 ??2@YAPEAX_K@Z 0069 ??_C@_00CNPNBAHC@?$AA@ 0082 ??0_Locinfo@std@@QEAA@PEBD@Z 0092 ??_7?$ctype@G@std@@6B@ 009f _Getctype 00b8 _Getcvt 00ee ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC E0 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 F0 00 00 00 48 85 C9 0F 84 BA 00 00 00 48 39 31 0F 85 B1 00 00 00 8D 4E 60 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 F0 00 00 00 48 85 C0 0F 84 80 00 00 00 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 78 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8D 4C 24 28 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 48 8D 4C 24 48 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 30 0F 10 48 10 0F 11 4B 40 F2 0F 10 40 20 F2 0F 11 43 50 8B 40 28 89 43 58 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 78 E8 ?? ?? ?? ?? B8 02 00 00 00 4C 8D 9C 24 E0 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_41_598_1 {
	meta:
		name = "?_Getcat@?$ctype@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 272
		refs = "0045 ??2@YAPEAX_K@Z 0069 ??_C@_00CNPNBAHC@?$AA@ 0082 ??0_Locinfo@std@@QEAA@PEBD@Z 0092 ??_7?$ctype@_W@std@@6B@ 009f _Getctype 00b8 _Getcvt 00ee ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC E0 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 F0 00 00 00 48 85 C9 0F 84 BA 00 00 00 48 39 31 0F 85 B1 00 00 00 8D 4E 60 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 F0 00 00 00 48 85 C0 0F 84 80 00 00 00 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 78 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8D 4C 24 28 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 48 8D 4C 24 48 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 30 0F 10 48 10 0F 11 4B 40 F2 0F 10 40 20 F2 0F 11 43 50 8B 40 28 89 43 58 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 78 E8 ?? ?? ?? ?? B8 02 00 00 00 4C 8D 9C 24 E0 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_14_213_1 {
	meta:
		name = "?dtor$0@?0??_Getcat@?$ctype@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
		size = 32
		refs = "0016 ??3@YAXPEAX_K@Z"
		altNames = "?dtor$0@?0??_Getcat@?$ctype@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA BA 60 00 00 00 48 8B 8D F0 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_14_216_1 {
	meta:
		name = "?_Getcvt@_Locinfo@std@@QEBA?AU_Cvtvec@@XZ"
		size = 58
		refs = "000f _Getcvt"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8D 4C 24 20 48 8B DA E8 ?? ?? ?? ?? 0F 10 00 0F 10 48 10 0F 11 03 F2 0F 10 40 20 8B 40 28 0F 11 4B 10 F2 0F 11 43 20 89 43 28 48 8B C3 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_14_219_1 {
	meta:
		name = "?_Gndec@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"
		size = 21
		altNames = "?_Gndec@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"
	strings:
		$1 = { 48 8B 41 50 FF 00 48 8B 51 38 48 8B 02 48 83 C0 FE 48 89 02 C3 }
	condition:
		$1
}

rule file_14_220_1 {
	meta:
		name = "?_Gninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"
		size = 21
		altNames = "?_Gninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"
	strings:
		$1 = { 48 8B 41 50 FF 08 48 8B 51 38 48 8B 02 48 8D 48 02 48 89 0A C3 }
	condition:
		$1
}

rule file_14_223_1 {
	meta:
		name = "?_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
		size = 126
		refs = "0071 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 41 83 F8 01 4C 8D 41 10 4C 89 41 20 0F 94 C0 45 33 C9 88 41 7C 48 8D 41 08 48 89 41 18 48 8D 41 28 48 89 41 38 48 8D 41 30 48 89 41 40 48 8D 41 48 48 89 41 50 48 8D 41 4C 48 89 41 58 44 88 49 72 4D 89 08 48 8B 41 40 4C 89 08 48 8B 41 58 44 89 08 48 8B 41 18 4C 89 08 48 8B 41 38 4C 89 08 48 8B 41 50 44 89 08 48 89 91 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 41 74 4C 89 49 68 C3 }
	condition:
		$1
}

rule file_95_223_1 {
	meta:
		name = "?_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@12@@Z"
		size = 126
		refs = "0071 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 41 83 F8 01 4C 8D 41 10 4C 89 41 20 0F 94 C0 45 33 C9 88 41 7C 48 8D 41 08 48 89 41 18 48 8D 41 28 48 89 41 38 48 8D 41 30 48 89 41 40 48 8D 41 48 48 89 41 50 48 8D 41 4C 48 89 41 58 44 88 49 72 4D 89 08 48 8B 41 40 4C 89 08 48 8B 41 58 44 89 08 48 8B 41 18 4C 89 08 48 8B 41 38 4C 89 08 48 8B 41 50 44 89 08 48 89 91 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 41 74 4C 89 49 68 C3 }
	condition:
		$1
}

rule file_14_226_1 {
	meta:
		name = "?_Init@?$codecvt@GDU_Mbstatet@@@std@@IEAAXAEBV_Locinfo@2@@Z"
		size = 56
		refs = "000f _Getcvt"
		altNames = "?_Init@?$codecvt@_WDU_Mbstatet@@@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 F2 0F 10 40 20 F2 0F 11 43 30 8B 40 28 89 43 38 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_14_227_1 {
	meta:
		name = "?_Init@?$ctype@G@std@@IEAAXAEBV_Locinfo@2@@Z"
		size = 81
		refs = "000f _Getctype 0028 _Getcvt"
		altNames = "?_Init@?$ctype@_W@std@@IEAAXAEBV_Locinfo@2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 50 48 8B D9 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 4C 24 20 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 30 0F 10 48 10 0F 11 4B 40 F2 0F 10 40 20 F2 0F 11 43 50 8B 40 28 89 43 58 48 83 C4 50 5B C3 }
	condition:
		$1
}

rule file_14_248_1 {
	meta:
		name = "?_Pninc@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAPEAGXZ"
		size = 21
		altNames = "?_Pninc@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAPEA_WXZ"
	strings:
		$1 = { 48 8B 41 58 FF 08 48 8B 51 40 48 8B 02 48 8D 48 02 48 89 0A C3 }
	condition:
		$1
}

rule file_14_249_1 {
	meta:
		name = "?_Reset_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AEAAXXZ"
		size = 51
		altNames = "?_Reset_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 4C 8B 49 18 48 8D 41 70 49 39 01 75 25 48 8B 91 88 00 00 00 4C 8B 81 90 00 00 00 49 89 11 4C 2B C2 48 8B 41 38 49 D1 F8 48 89 10 48 8B 41 50 44 89 00 C3 }
	condition:
		$1
}

rule file_14_250_1 {
	meta:
		name = "?_Set_back@?$basic_filebuf@GU?$char_traits@G@std@@@std@@AEAAXXZ"
		size = 81
		altNames = "?_Set_back@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 4C 8B C9 48 8B 49 18 48 8B 01 4D 8D 51 70 49 3B C2 74 20 49 89 81 88 00 00 00 49 8B 41 50 4C 63 00 49 8B 41 38 48 8B 10 4A 8D 04 42 49 89 81 90 00 00 00 4C 89 11 49 8B C9 49 8B 41 38 49 2B CA 48 83 C1 72 48 D1 F9 4C 89 10 49 8B 41 50 89 08 C3 }
	condition:
		$1
}

rule file_14_285_1 {
	meta:
		name = "?close@?$basic_filebuf@GU?$char_traits@G@std@@@std@@QEAAPEAV12@XZ"
		size = 197
		refs = "0022 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAA_NXZ 0036 fclose 00a9 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 8B D9 48 39 B1 80 00 00 00 75 04 8B FE EB 1F E8 ?? ?? ?? ?? 48 8B 8B 80 00 00 00 F6 D8 48 1B FF 48 23 FB E8 ?? ?? ?? ?? 85 C0 48 0F 45 FE 40 88 73 7C 48 8D 4B 10 48 89 4B 20 48 8D 43 08 48 89 43 18 48 8D 43 28 48 89 43 38 48 8D 43 30 48 89 43 40 48 8D 43 48 48 89 43 50 48 8D 43 4C 48 89 43 58 48 8B C7 40 88 73 72 48 89 31 48 8B 4B 40 48 89 31 48 8B 4B 58 89 31 48 8B 4B 18 48 89 31 48 8B 4B 38 48 89 31 48 8B 4B 50 89 31 48 89 B3 80 00 00 00 48 8B 0D ?? ?? ?? ?? 48 89 73 68 48 8B 74 24 38 48 89 4B 74 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_95_285_1 {
	meta:
		name = "?close@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@QEAAPEAV12@XZ"
		size = 197
		refs = "0022 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAA_NXZ 0036 fclose 00a9 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 F6 48 8B D9 48 39 B1 80 00 00 00 75 04 8B FE EB 1F E8 ?? ?? ?? ?? 48 8B 8B 80 00 00 00 F6 D8 48 1B FF 48 23 FB E8 ?? ?? ?? ?? 85 C0 48 0F 45 FE 40 88 73 7C 48 8D 4B 10 48 89 4B 20 48 8D 43 08 48 89 43 18 48 8D 43 28 48 89 43 38 48 8D 43 30 48 89 43 40 48 8D 43 48 48 89 43 50 48 8D 43 4C 48 89 43 58 48 8B C7 40 88 73 72 48 89 31 48 8B 4B 40 48 89 31 48 8B 4B 58 89 31 48 8B 4B 18 48 89 31 48 8B 4B 38 48 89 31 48 8B 4B 50 89 31 48 89 B3 80 00 00 00 48 8B 0D ?? ?? ?? ?? 48 89 73 68 48 8B 74 24 38 48 89 4B 74 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_287_1 {
	meta:
		name = "?copy@?$char_traits@G@std@@SAPEAGPEAGPEBG_K@Z"
		size = 31
		refs = "0012 memcpy"
		altNames = "?copy@?$char_traits@_W@std@@SAPEA_WPEA_WPEB_W_K@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 4D 85 C0 74 08 4D 03 C0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_14_297_1 {
	meta:
		name = "?do_in@?$codecvt@GDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEAG3AEAPEAG@Z"
		size = 239
		refs = "007b _Mbrtowc"
		altNames = "?do_in@?$codecvt@_WDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1AEAPEBDPEA_W3AEAPEA_W@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 30 48 8B 9C 24 80 00 00 00 45 33 E4 48 8B B4 24 98 00 00 00 41 8B FC 48 8B 84 24 88 00 00 00 49 8B E9 4C 8B FA 4C 8B E9 4C 89 03 48 89 06 4C 39 0B 40 0F 95 C7 4C 39 0B 74 7B 4C 8B B4 24 90 00 00 00 4C 39 36 74 6E 48 8B 13 49 8D 45 10 48 8B 0E 4C 8B C5 4C 2B 03 4D 8B CF 48 89 44 24 20 E8 ?? ?? ?? ?? 8B C8 83 F8 FE 74 47 83 F8 FF 74 3B 85 C0 75 1B 48 8B 06 66 44 39 20 75 12 48 8B 03 48 83 C9 FF 48 FF C1 44 38 24 08 75 F7 FF C1 83 F9 FD 41 8B C4 41 8B FC 0F 45 C1 48 98 48 01 03 48 83 06 02 48 39 2B 75 99 EB 0A B8 02 00 00 00 EB 05 48 89 2B 8B C7 48 8B 5C 24 60 48 8B 6C 24 68 48 8B 74 24 70 48 83 C4 30 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_14_298_1 {
	meta:
		name = "?do_is@?$ctype@G@std@@MEBAPEBGPEBG0PEAF@Z"
		size = 27
		refs = "0017 _Getwctypes"
		altNames = "?do_is@?$ctype@_W@std@@MEBAPEB_WPEB_W0PEAF@Z"
	strings:
		$1 = { 49 8B C1 4D 8B D0 4C 8B DA 4C 8D 49 10 4C 8B C0 49 8B D2 49 8B CB E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_299_1 {
	meta:
		name = "?do_is@?$ctype@G@std@@MEBA_NFG@Z"
		size = 34
		refs = "0012 _Getwctype"
		altNames = "?do_is@?$ctype@_W@std@@MEBA_NF_W@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 0F B7 DA 48 8D 51 10 41 0F B7 C8 E8 ?? ?? ?? ?? 66 85 C3 0F 95 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_14_300_1 {
	meta:
		name = "?do_length@?$codecvt@GDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1_K@Z"
		size = 174
		refs = "0053 _Mbrtowc"
		altNames = "?do_length@?$codecvt@_WDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBD1_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 20 57 41 56 41 57 48 83 EC 30 48 8B 02 45 33 FF 49 8B F1 49 8B F8 4C 8B F1 48 89 44 24 60 41 8B DF 4C 39 7C 24 70 76 67 48 3B FE 74 62 49 8D 46 10 4C 8B C6 4C 2B C7 48 89 44 24 20 4C 8D 4C 24 60 48 8B D7 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B C8 83 F8 FE 74 3A 83 F8 FF 74 35 85 C0 75 17 66 44 39 7C 24 58 75 0F 48 83 C9 FF 48 FF C1 44 38 3C 0F 75 F7 FF C1 83 F9 FD 41 8B C7 0F 45 C1 FF C3 48 98 48 03 F8 48 63 C3 48 3B 44 24 70 72 99 48 8B 74 24 68 8B C3 48 8B 5C 24 50 48 83 C4 30 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_14_304_1 {
	meta:
		name = "?do_narrow@?$ctype@G@std@@MEBAPEBGPEBG0DPEAD@Z"
		size = 172
		refs = "0013 __security_cookie 0063 _Wcrtomb 0094 __security_check_cookie"
		altNames = "?do_narrow@?$ctype@_W@std@@MEBAPEB_WPEB_W0DPEAD@Z"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 56 41 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 4C 8B B4 24 90 00 00 00 33 F6 49 8B F8 45 8A F9 48 2B FA 48 8B DA 48 FF C7 48 D1 EF 49 3B D0 48 0F 47 FE 48 85 FF 74 41 48 8D 69 30 0F B7 13 4C 8D 44 24 20 33 C0 48 8D 4C 24 28 4C 8B CD 48 89 44 24 20 E8 ?? ?? ?? ?? 0F B6 54 24 28 83 F8 01 41 0F B6 CF 0F 45 D1 48 83 C3 02 41 88 16 48 FF C6 49 FF C6 48 3B F7 75 C3 48 8B C3 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 80 00 00 00 48 83 C4 40 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_14_305_1 {
	meta:
		name = "?do_out@?$codecvt@GDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEBG1AEAPEBGPEAD3AEAPEAD@Z"
		size = 272
		refs = "0017 __security_cookie 0081 _Wcrtomb 00c0 memcpy 00f4 __security_check_cookie"
		altNames = "?do_out@?$codecvt@_WDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEB_W1AEAPEB_WPEAD3AEAPEAD@Z"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 48 8B BC 24 A0 00 00 00 33 ED 48 8B B4 24 B8 00 00 00 4D 8B E1 48 8B 84 24 A8 00 00 00 4C 8B EA 48 89 4C 24 20 4C 89 07 48 89 06 4C 39 0F 0F 84 8B 00 00 00 4C 8B B4 24 B0 00 00 00 4C 39 36 74 7E 49 8B C6 4C 8D 49 10 48 2B 06 4D 8B C5 48 83 F8 05 48 8B 07 0F B7 10 7C 17 48 8B 0E E8 ?? ?? ?? ?? 85 C0 78 4E 48 83 07 02 48 98 48 01 06 EB 37 49 8B 5D 00 48 8D 4C 24 28 E8 ?? ?? ?? ?? 85 C0 78 31 4C 63 F8 49 8B C6 48 2B 06 49 3B C7 7C 2A 48 8B 0E 48 8D 54 24 28 4D 8B C7 E8 ?? ?? ?? ?? 48 83 07 02 4C 01 3E 4C 39 27 74 15 48 8B 4C 24 20 EB 88 B8 02 00 00 00 EB 0D 49 89 5D 00 4C 39 27 40 0F 95 C5 8B C5 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 90 00 00 00 48 83 C4 40 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_14_306_1 {
	meta:
		name = "?do_scan_is@?$ctype@G@std@@MEBAPEBGFPEBG0@Z"
		size = 114
		refs = "0038 _guard_check_icall"
		altNames = "?do_scan_is@?$ctype@_W@std@@MEBAPEB_WFPEB_W0@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 49 8B E9 49 8B F0 44 0F B7 FA 4C 8B F1 4D 3B C1 74 2C 49 8B 06 0F B7 1E 48 8B 78 20 48 8B CF E8 ?? ?? ?? ?? 44 0F B7 C3 41 0F B7 D7 49 8B CE FF D7 84 C0 75 09 48 83 C6 02 48 3B F5 75 D4 48 8B 5C 24 40 48 8B C6 48 8B 74 24 50 48 8B 6C 24 48 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_14_307_1 {
	meta:
		name = "?do_scan_not@?$ctype@G@std@@MEBAPEBGFPEBG0@Z"
		size = 114
		refs = "0038 _guard_check_icall"
		altNames = "?do_scan_not@?$ctype@_W@std@@MEBAPEB_WFPEB_W0@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 49 8B E9 49 8B F0 44 0F B7 FA 4C 8B F1 4D 3B C1 74 2C 49 8B 06 0F B7 1E 48 8B 78 20 48 8B CF E8 ?? ?? ?? ?? 44 0F B7 C3 41 0F B7 D7 49 8B CE FF D7 84 C0 74 09 48 83 C6 02 48 3B F5 75 D4 48 8B 5C 24 40 48 8B C6 48 8B 74 24 50 48 8B 6C 24 48 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_14_309_1 {
	meta:
		name = "?do_tolower@?$ctype@G@std@@MEBAPEBGPEAGPEBG@Z"
		size = 103
		refs = "003c _Towlower"
		altNames = "?do_tolower@?$ctype@_W@std@@MEBAPEB_WPEA_WPEB_W@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 F6 49 8B F8 48 2B FA 48 8B DA 48 FF C7 48 D1 EF 49 3B D0 48 0F 47 FE 48 85 FF 74 1E 48 8D 69 10 0F B7 0B 48 8B D5 E8 ?? ?? ?? ?? 66 89 03 48 FF C6 48 83 C3 02 48 3B F7 75 E6 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_41_1140_1 {
	meta:
		name = "?do_toupper@?$ctype@G@std@@MEBAPEBGPEAGPEBG@Z"
		size = 103
		refs = "003c _Towupper"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 F6 49 8B F8 48 2B FA 48 8B DA 48 FF C7 48 D1 EF 49 3B D0 48 0F 47 FE 48 85 FF 74 1E 48 8D 69 10 0F B7 0B 48 8B D5 E8 ?? ?? ?? ?? 66 89 03 48 FF C6 48 83 C3 02 48 3B F7 75 E6 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_108_274_2 {
	meta:
		name = "?do_toupper@?$ctype@_W@std@@MEBAPEB_WPEA_WPEB_W@Z"
		size = 103
		refs = "003c _Towupper"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 F6 49 8B F8 48 2B FA 48 8B DA 48 FF C7 48 D1 EF 49 3B D0 48 0F 47 FE 48 85 FF 74 1E 48 8D 69 10 0F B7 0B 48 8B D5 E8 ?? ?? ?? ?? 66 89 03 48 FF C6 48 83 C3 02 48 3B F7 75 E6 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_312_1 {
	meta:
		name = "?do_unshift@?$codecvt@GDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z"
		size = 161
		refs = "0013 __security_cookie 0044 _Wcrtomb 007a memcpy 008c __security_check_cookie"
		altNames = "?do_unshift@?$codecvt@_WDU_Mbstatet@@@std@@MEBAHAEAU_Mbstatet@@PEAD1AEAPEAD@Z"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 56 41 57 48 83 EC 30 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 28 4C 8B B4 24 80 00 00 00 4C 8B FA 49 8B E9 33 FF 4C 8D 49 10 48 8D 4C 24 20 4D 89 06 4D 8B C7 48 8B 1A 33 D2 E8 ?? ?? ?? ?? 85 C0 7F 07 BF 02 00 00 00 EB 2E 49 2B 2E FF C8 48 63 F0 48 3B EE 7D 0A 49 89 1F BF 01 00 00 00 EB 17 85 C0 7E 13 49 8B 0E 48 8D 54 24 20 4C 8B C6 E8 ?? ?? ?? ?? 49 01 36 8B C7 48 8B 4C 24 28 48 33 CC E8 ?? ?? ?? ?? 48 8B 5C 24 70 48 83 C4 30 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_14_313_1 {
	meta:
		name = "?do_widen@?$ctype@G@std@@MEBAGD@Z"
		size = 72
		refs = "002c _Mbrtowc"
		altNames = "?do_widen@?$ctype@_W@std@@MEBA_WD@Z"
	strings:
		$1 = { 4C 8B DC 48 83 EC 38 33 C0 88 54 24 48 49 89 43 18 4D 8D 4B 18 48 8D 41 30 41 B8 01 00 00 00 49 8D 4B 08 49 89 43 E8 49 8D 53 10 E8 ?? ?? ?? ?? 0F B7 4C 24 40 85 C0 BA FF FF 00 00 66 0F 48 CA 0F B7 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_14_314_1 {
	meta:
		name = "?do_widen@?$ctype@G@std@@MEBAPEBDPEBD0PEAG@Z"
		size = 153
		refs = "005b _Mbrtowc"
		altNames = "?do_widen@?$ctype@_W@std@@MEBAPEBDPEBD0PEA_W@Z"
	strings:
		$1 = { 48 89 5C 24 08 55 56 57 41 56 41 57 48 83 EC 40 45 33 FF 49 8B F8 48 2B FA 4D 8B F1 49 3B D0 48 8B DA 41 8B EF 49 0F 47 FF 48 85 FF 74 57 48 8D 71 30 8A 03 4C 8D 4C 24 30 88 44 24 78 48 8D 54 24 78 33 C0 48 89 74 24 20 48 8D 8C 24 80 00 00 00 48 89 44 24 30 44 8D 40 01 E8 ?? ?? ?? ?? 0F B7 8C 24 80 00 00 00 85 C0 BA FF FF 00 00 66 0F 48 CA 48 FF C3 48 FF C5 66 41 89 0E 4D 8D 76 02 48 3B EF 75 AD 48 8B C3 48 8B 5C 24 70 48 83 C4 40 41 5F 41 5E 5F 5E 5D C3 }
	condition:
		$1
}

rule file_14_316_1 {
	meta:
		name = "?egptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"
		size = 19
		altNames = "?egptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"
	strings:
		$1 = { 48 8B 41 50 48 63 10 48 8B 41 38 48 8B 08 48 8D 04 51 C3 }
	condition:
		$1
}

rule file_14_319_1 {
	meta:
		name = "?epptr@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEBAPEAGXZ"
		size = 19
		altNames = "?epptr@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEBAPEA_WXZ"
	strings:
		$1 = { 48 8B 41 58 48 63 10 48 8B 41 40 48 8B 08 48 8D 04 51 C3 }
	condition:
		$1
}

rule file_14_325_1 {
	meta:
		name = "?gbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXH@Z"
		size = 20
		altNames = "?gbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXH@Z"
	strings:
		$1 = { 48 8B 41 50 29 10 48 8B 49 38 48 63 C2 48 03 C0 48 01 01 C3 }
	condition:
		$1
}

rule file_14_331_1 {
	meta:
		name = "?init@?$basic_ios@GU?$char_traits@G@std@@@std@@IEAAXPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@_N@Z"
		size = 105
		refs = "0019 ?_Init@ios_base@std@@IEAAXXZ 002c ?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAGD@Z 0048 ?clear@ios_base@std@@QEAAXH_N@Z 0055 ?_Addstd@ios_base@std@@SAXPEAV12@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 41 8A F0 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 83 67 50 00 B2 20 48 8B CF 48 89 5F 48 E8 ?? ?? ?? ?? 48 83 7F 48 00 66 89 47 58 75 11 8B 57 10 45 33 C0 83 CA 04 48 8B CF E8 ?? ?? ?? ?? 40 84 F6 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_95_331_1 {
	meta:
		name = "?init@?$basic_ios@_WU?$char_traits@_W@std@@@std@@IEAAXPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@_N@Z"
		size = 105
		refs = "0019 ?_Init@ios_base@std@@IEAAXXZ 002c ?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBA_WD@Z 0048 ?clear@ios_base@std@@QEAAXH_N@Z 0055 ?_Addstd@ios_base@std@@SAXPEAV12@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 41 8A F0 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 83 67 50 00 B2 20 48 8B CF 48 89 5F 48 E8 ?? ?? ?? ?? 48 83 7F 48 00 66 89 47 58 75 11 8B 57 10 45 33 C0 83 CA 04 48 8B CF E8 ?? ?? ?? ?? 40 84 F6 74 08 48 8B CF E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_333_1 {
	meta:
		name = "?is@?$ctype@G@std@@QEBA_NFG@Z"
		size = 83
		refs = "002a _guard_check_icall"
		altNames = "?is@?$ctype@_W@std@@QEBA_NF_W@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 48 89 7C 24 18 41 56 48 83 EC 20 48 8B 01 4C 8B F1 41 0F B7 F8 0F B7 F2 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 44 0F B7 C7 0F B7 D6 49 8B CE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 8B 7C 24 40 48 83 C4 20 41 5E 48 FF E0 }
	condition:
		$1
}

rule file_14_346_1 {
	meta:
		name = "?not_eof@?$char_traits@G@std@@SAGAEBG@Z"
		size = 17
		altNames = "?not_eof@?$char_traits@_W@std@@SAGAEBG@Z"
	strings:
		$1 = { B8 FF FF 00 00 66 39 01 74 04 0F B7 01 C3 33 C0 C3 }
	condition:
		$1
}

rule file_14_348_1 {
	meta:
		name = "?overflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAGG@Z"
		size = 1028
		refs = "0028 __security_cookie 00ec fputwc 010d ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 011b ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 01e1 _guard_check_icall 02fb fwrite 0343 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 034d _invalid_parameter_noinfo_noreturn 039e ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 03b0 ?_Deallocate@std@@YAXPEAX_K1@Z 03e5 __security_check_cookie"
		altNames = "?overflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAGG@Z"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 A1 48 81 EC E0 00 00 00 48 C7 45 A7 FE FF FF FF 48 89 58 18 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 1F 44 0F B7 E2 4C 8B E9 33 F6 89 75 8B 41 BF FF FF 00 00 66 44 3B FA 75 12 66 41 3B D7 66 44 0F 44 E6 41 0F B7 C4 E9 80 03 00 00 48 8B 41 40 48 8B 10 48 85 D2 74 2E 4C 8B 41 58 4D 63 08 49 8B C1 4A 8D 0C 4A 48 3B D1 73 1B 41 8D 41 FF 41 89 00 49 8B 4D 40 48 8B 11 48 8D 42 02 48 89 01 66 44 89 22 EB BD 49 39 B5 80 00 00 00 75 09 41 0F B7 C7 E9 34 03 00 00 4D 8B 45 18 49 8D 45 70 49 39 00 75 24 49 8B 95 90 00 00 00 49 8B 8D 88 00 00 00 49 89 08 49 8B 45 38 48 89 08 48 2B D1 48 D1 FA 49 8B 45 50 89 10 49 39 75 68 75 1C 49 8B 95 80 00 00 00 41 0F B7 CC E8 ?? ?? ?? ?? 66 41 3B C7 74 AA 45 0F B7 FC EB A4 66 44 89 65 87 45 33 C0 41 8D 50 08 48 8D 4D F7 E8 ?? ?? ?? ?? 90 48 8D 55 AF 48 8D 4D F7 E8 ?? ?? ?? ?? 48 8B 58 10 48 85 DB 0F 84 AB 02 00 00 48 8B 00 48 85 C0 0F 84 99 02 00 00 48 8B 00 48 85 C0 0F 84 8D 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CB 0F 87 6D 02 00 00 48 8B 40 18 48 03 C8 48 3B D9 0F 83 5D 02 00 00 48 8D 55 DF 48 8D 4D F7 E8 ?? ?? ?? ?? 48 8B 50 10 48 89 55 8F 48 85 D2 0F 84 39 02 00 00 48 8B 00 48 85 C0 0F 84 27 02 00 00 48 8B 00 48 85 C0 0F 84 1B 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 FB 01 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 EB 01 00 00 4D 8B 75 68 4D 8B 06 48 03 5D 0F 49 8B 70 38 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 97 48 89 44 24 38 48 89 5C 24 30 48 8B 45 8F 48 89 44 24 28 48 8D 45 9F 48 89 44 24 20 4C 8D 4D 89 4C 8D 45 87 49 8D 55 74 49 8B CE FF D6 33 F6 85 C0 0F 88 74 01 00 00 83 F8 01 0F 8F 4C 01 00 00 48 8D 55 C7 48 8D 4D F7 E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 0F 84 2C 01 00 00 48 8B 00 48 85 C0 0F 84 1A 01 00 00 48 8B 00 48 85 C0 0F 84 0E 01 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 EE 00 00 00 48 8B 40 18 48 03 C8 48 3B D1 0F 83 DE 00 00 00 48 8B 5D 97 48 2B DA 8B 7D 8B 74 75 83 CF 01 89 7D 8B 48 8D 55 C7 48 8D 4D F7 E8 ?? ?? ?? ?? 48 8B 48 10 48 85 C9 0F 84 A7 00 00 00 48 8B 00 48 85 C0 0F 84 95 00 00 00 48 8B 00 48 85 C0 0F 84 89 00 00 00 48 83 78 20 10 72 06 48 8B 50 08 EB 04 48 8D 50 08 48 3B D1 77 6D 48 8B 40 18 48 03 D0 48 3B CA 73 61 4D 8B 8D 80 00 00 00 4C 8B C3 BA 01 00 00 00 E8 ?? ?? ?? ?? 48 3B D8 B0 01 75 03 40 8A C6 40 F6 C7 01 74 06 83 E7 FE 89 7D 8B 84 C0 75 45 41 C6 45 72 01 48 8D 45 87 48 39 45 9F 75 68 48 85 DB 0F 85 E1 FD FF FF 48 83 7D 0F 20 73 5C 45 33 C0 8D 53 08 48 8D 4D F7 E8 ?? ?? ?? ?? E9 C6 FD FF FF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 45 8B E7 EB 2D E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 83 F8 03 75 1A 49 8B 95 80 00 00 00 0F B7 4D 87 E8 ?? ?? ?? ?? 66 41 3B C7 74 04 45 0F B7 FC 45 33 C0 B2 01 48 8D 4D F7 E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D F7 E8 ?? ?? ?? ?? E9 E7 FC FF FF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 48 8B 4D 1F 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 30 01 00 00 48 81 C4 E0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_14_351_1 {
	meta:
		name = "?pbackfail@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAGG@Z"
		size = 230
		refs = "0073 ungetwc"
		altNames = "?pbackfail@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAGG@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 41 38 48 8B D9 45 33 C0 0F B7 FA BE FF FF 00 00 48 8B 08 48 85 C9 74 2F 48 8B 43 18 48 39 08 73 26 66 3B F2 74 06 66 39 51 FE 75 1B 48 8B 43 50 FF 00 48 8B 43 38 48 83 00 FE 66 3B FE 66 41 0F 44 F8 0F B7 C7 EB 7E 48 8B 93 80 00 00 00 48 85 D2 74 6F 66 3B F7 74 6A 4C 39 43 68 75 0D 0F B7 CF E8 ?? ?? ?? ?? 66 3B C6 75 D7 4C 8B 43 38 48 8D 53 70 49 39 10 74 4A 4C 8B 4B 18 66 89 3A 49 8B 01 48 3B C2 74 1C 48 89 83 88 00 00 00 48 8B 43 50 48 63 08 49 8B 00 48 8D 0C 48 48 89 8B 90 00 00 00 49 89 11 48 8B CB 48 8B 43 38 48 2B CA 48 83 C1 72 48 D1 F9 48 89 10 48 8B 43 50 89 08 EB 80 0F B7 C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_353_1 {
	meta:
		name = "?pbump@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXH@Z"
		size = 20
		altNames = "?pbump@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXH@Z"
	strings:
		$1 = { 48 8B 41 58 29 10 48 8B 49 40 48 63 C2 48 03 C0 48 01 01 C3 }
	condition:
		$1
}

rule file_14_358_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 239
		refs = "0047 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAA_NXZ 0067 _fseeki64 007c fgetpos 00c7 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 56 48 83 EC 20 48 8B 41 38 4C 8D 71 70 41 8B E9 49 8B F0 48 8B DA 48 8B F9 4C 39 30 75 11 41 83 F9 01 75 0B 48 83 79 68 00 75 04 48 83 EE 02 48 83 B9 80 00 00 00 00 74 7E E8 ?? ?? ?? ?? 84 C0 74 75 48 85 F6 75 05 83 FD 01 74 16 48 8B 8F 80 00 00 00 44 8B C5 48 8B D6 E8 ?? ?? ?? ?? 85 C0 75 55 48 8B 8F 80 00 00 00 48 8D 54 24 40 E8 ?? ?? ?? ?? 85 C0 75 40 48 8B 47 18 4C 39 30 75 24 48 8B 8F 88 00 00 00 48 8B 97 90 00 00 00 48 89 08 48 2B D1 48 8B 47 38 48 D1 FA 48 89 08 48 8B 47 50 89 10 48 8B 47 74 48 8B 4C 24 40 48 83 23 00 48 89 4B 08 EB 11 48 8B 05 ?? ?? ?? ?? 48 83 63 08 00 48 89 03 33 C0 48 8B 6C 24 50 48 89 43 10 48 8B C3 48 8B 5C 24 48 48 83 C4 20 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_95_358_1 {
	meta:
		name = "?seekoff@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@_JHH@Z"
		size = 239
		refs = "0047 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAA_NXZ 0067 _fseeki64 007c fgetpos 00c7 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 48 89 5C 24 10 48 89 6C 24 18 56 57 41 56 48 83 EC 20 48 8B 41 38 4C 8D 71 70 41 8B E9 49 8B F0 48 8B DA 48 8B F9 4C 39 30 75 11 41 83 F9 01 75 0B 48 83 79 68 00 75 04 48 83 EE 02 48 83 B9 80 00 00 00 00 74 7E E8 ?? ?? ?? ?? 84 C0 74 75 48 85 F6 75 05 83 FD 01 74 16 48 8B 8F 80 00 00 00 44 8B C5 48 8B D6 E8 ?? ?? ?? ?? 85 C0 75 55 48 8B 8F 80 00 00 00 48 8D 54 24 40 E8 ?? ?? ?? ?? 85 C0 75 40 48 8B 47 18 4C 39 30 75 24 48 8B 8F 88 00 00 00 48 8B 97 90 00 00 00 48 89 08 48 2B D1 48 8B 47 38 48 D1 FA 48 89 08 48 8B 47 50 89 10 48 8B 47 74 48 8B 4C 24 40 48 83 23 00 48 89 4B 08 EB 11 48 8B 05 ?? ?? ?? ?? 48 83 63 08 00 48 89 03 33 C0 48 8B 6C 24 50 48 89 43 10 48 8B C3 48 8B 5C 24 48 48 83 C4 20 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_14_360_1 {
	meta:
		name = "?seekpos@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 260
		refs = "0038 ?_Endwrite@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAA_NXZ 0051 fsetpos 006d _fseeki64 0082 fgetpos 00d9 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 4C 8B DC 49 89 5B 10 49 89 73 18 49 89 7B 20 41 56 48 83 EC 20 48 83 B9 80 00 00 00 00 4D 8B F0 49 8B 40 08 48 8B FA 49 8B 30 48 8B D9 49 89 43 08 0F 84 9F 00 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 92 00 00 00 48 8B 8B 80 00 00 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 7D 48 85 F6 74 17 48 8B 8B 80 00 00 00 44 8D 40 01 48 8B D6 E8 ?? ?? ?? ?? 85 C0 75 61 48 8B 8B 80 00 00 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 4C 49 8B 46 10 4C 8B 43 18 48 89 43 74 48 8D 43 70 49 39 00 75 24 48 8B 8B 88 00 00 00 48 8B 93 90 00 00 00 49 89 08 48 2B D1 48 8B 43 38 48 D1 FA 48 89 08 48 8B 43 50 89 10 48 8B 43 74 48 8B 4C 24 30 48 83 27 00 48 89 4F 08 EB 11 48 8B 05 ?? ?? ?? ?? 48 83 67 08 00 48 89 07 33 C0 48 8B 5C 24 38 48 8B 74 24 40 48 89 47 10 48 8B C7 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_95_360_1 {
	meta:
		name = "?seekpos@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAA?AV?$fpos@U_Mbstatet@@@2@V32@H@Z"
		size = 260
		refs = "0038 ?_Endwrite@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAA_NXZ 0051 fsetpos 006d _fseeki64 0082 fgetpos 00d9 ?_BADOFF@std@@3_JB"
	strings:
		$1 = { 4C 8B DC 49 89 5B 10 49 89 73 18 49 89 7B 20 41 56 48 83 EC 20 48 83 B9 80 00 00 00 00 4D 8B F0 49 8B 40 08 48 8B FA 49 8B 30 48 8B D9 49 89 43 08 0F 84 9F 00 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 92 00 00 00 48 8B 8B 80 00 00 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 7D 48 85 F6 74 17 48 8B 8B 80 00 00 00 44 8D 40 01 48 8B D6 E8 ?? ?? ?? ?? 85 C0 75 61 48 8B 8B 80 00 00 00 48 8D 54 24 30 E8 ?? ?? ?? ?? 85 C0 75 4C 49 8B 46 10 4C 8B 43 18 48 89 43 74 48 8D 43 70 49 39 00 75 24 48 8B 8B 88 00 00 00 48 8B 93 90 00 00 00 49 89 08 48 2B D1 48 8B 43 38 48 D1 FA 48 89 08 48 8B 43 50 89 10 48 8B 43 74 48 8B 4C 24 30 48 83 27 00 48 89 4F 08 EB 11 48 8B 05 ?? ?? ?? ?? 48 83 67 08 00 48 89 07 33 C0 48 8B 5C 24 38 48 8B 74 24 40 48 89 47 10 48 8B C7 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_14_365_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAPEAV?$basic_streambuf@GU?$char_traits@G@std@@@2@PEAG_J@Z"
		size = 203
		refs = "0033 setvbuf 00b1 ?_Stinit@?1??_Init@?$basic_filebuf@GU?$char_traits@G@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 4D 8B C8 48 8B 89 80 00 00 00 48 85 C9 0F 84 A7 00 00 00 48 85 D2 75 0B 4D 85 C0 75 06 45 8D 41 04 EB 03 45 33 C0 4D 03 C9 E8 ?? ?? ?? ?? 85 C0 0F 85 84 00 00 00 48 8B 93 80 00 00 00 48 8D 4B 10 88 43 72 48 8D 43 08 48 89 43 18 48 8D 43 28 48 89 43 38 48 8D 43 30 48 89 43 40 48 8D 43 48 48 89 43 50 48 8D 43 4C 48 89 43 58 C6 43 7C 01 48 89 4B 20 48 83 21 00 48 8B 43 40 48 83 20 00 48 8B 43 58 83 20 00 48 8B 43 18 48 83 20 00 48 8B 43 38 48 83 20 00 48 8B 43 50 83 20 00 48 89 93 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 83 63 68 00 48 89 43 74 48 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_95_365_1 {
	meta:
		name = "?setbuf@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAPEAV?$basic_streambuf@_WU?$char_traits@_W@std@@@2@PEA_W_J@Z"
		size = 203
		refs = "0033 setvbuf 00b1 ?_Stinit@?1??_Init@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEAU_iobuf@@W4_Initfl@23@@Z@4U_Mbstatet@@A"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 4D 8B C8 48 8B 89 80 00 00 00 48 85 C9 0F 84 A7 00 00 00 48 85 D2 75 0B 4D 85 C0 75 06 45 8D 41 04 EB 03 45 33 C0 4D 03 C9 E8 ?? ?? ?? ?? 85 C0 0F 85 84 00 00 00 48 8B 93 80 00 00 00 48 8D 4B 10 88 43 72 48 8D 43 08 48 89 43 18 48 8D 43 28 48 89 43 38 48 8D 43 30 48 89 43 40 48 8D 43 48 48 89 43 50 48 8D 43 4C 48 89 43 58 C6 43 7C 01 48 89 4B 20 48 83 21 00 48 8B 43 40 48 83 20 00 48 8B 43 58 83 20 00 48 8B 43 18 48 83 20 00 48 8B 43 38 48 83 20 00 48 8B 43 50 83 20 00 48 89 93 80 00 00 00 48 8B 05 ?? ?? ?? ?? 48 83 63 68 00 48 89 43 74 48 8B C3 EB 02 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_14_368_1 {
	meta:
		name = "?setg@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG00@Z"
		size = 28
		altNames = "?setg@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W00@Z"
	strings:
		$1 = { 48 8B 41 18 4D 2B C8 49 D1 F9 48 89 10 48 8B 41 38 4C 89 00 48 8B 41 50 44 89 08 C3 }
	condition:
		$1
}

rule file_14_369_1 {
	meta:
		name = "?setp@?$basic_streambuf@GU?$char_traits@G@std@@@std@@IEAAXPEAG0@Z"
		size = 28
		altNames = "?setp@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IEAAXPEA_W0@Z"
	strings:
		$1 = { 48 8B 41 20 4C 2B C2 49 D1 F8 48 89 10 48 8B 41 40 48 89 10 48 8B 41 58 44 89 00 C3 }
	condition:
		$1
}

rule file_14_374_1 {
	meta:
		name = "?sync@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAHXZ"
		size = 109
		refs = "0032 _guard_check_icall 004b fflush"
		altNames = "?sync@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAHXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 33 FF 48 8B F1 48 39 B9 80 00 00 00 74 34 48 8B 01 BD FF FF 00 00 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 0F B7 D5 48 8B CE FF D3 66 3B E8 74 13 48 8B 8E 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 79 03 83 CF FF 48 8B 5C 24 30 8B C7 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_379_1 {
	meta:
		name = "?uflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAGXZ"
		size = 1066
		refs = "0029 __security_cookie 00c7 fgetwc 00e6 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 00f3 fgetc 010d ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 011a ?begin@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA?AV?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@2@XZ 01dc _guard_check_icall 02ad ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z 02cd _invalid_parameter_noinfo_noreturn 0395 ungetc 03e9 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 03fb ?_Deallocate@std@@YAXPEAX_K1@Z 040a __security_check_cookie"
		altNames = "?uflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAGXZ"
	strings:
		$1 = { 48 8B C4 55 57 41 54 41 56 41 57 48 8D 68 A1 48 81 EC E0 00 00 00 48 C7 45 AF FE FF FF FF 48 89 58 10 48 89 70 18 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 27 4C 8B F9 48 8B 41 38 48 8B 10 48 85 D2 74 30 4C 8B 41 50 4D 63 08 49 8B C1 4A 8D 0C 4A 48 3B D1 73 1D 41 8D 41 FF 41 89 00 49 8B 57 38 48 8B 02 48 8D 48 02 48 89 0A 0F B7 00 E9 8F 03 00 00 49 83 BF 80 00 00 00 00 75 0A B8 FF FF 00 00 E9 7B 03 00 00 4D 8B 47 18 49 8D 47 70 49 39 00 75 24 49 8B 97 90 00 00 00 49 8B 8F 88 00 00 00 49 89 08 49 8B 47 38 48 89 08 48 2B D1 48 D1 FA 49 8B 47 50 89 10 49 83 7F 68 00 75 22 49 8B 8F 80 00 00 00 E8 ?? ?? ?? ?? BB FF FF 00 00 66 3B C3 0F 84 26 03 00 00 0F B7 D8 E9 1E 03 00 00 48 8D 4D FF E8 ?? ?? ?? ?? 90 49 8B 8F 80 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 DA 02 00 00 44 8A C0 BA 01 00 00 00 48 8D 4D FF E8 ?? ?? ?? ?? 48 8D 55 CF 48 8D 4D FF E8 ?? ?? ?? ?? 48 8B 58 10 48 85 DB 0F 84 A9 02 00 00 48 8B 00 48 85 C0 0F 84 97 02 00 00 48 8B 00 48 85 C0 0F 84 8B 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CB 0F 87 6B 02 00 00 48 8B 40 18 48 03 C8 48 3B D9 0F 83 5B 02 00 00 48 8D 55 E7 48 8D 4D FF E8 ?? ?? ?? ?? 4C 8B 60 10 4D 85 E4 0F 84 3B 02 00 00 48 8B 00 48 85 C0 0F 84 29 02 00 00 48 8B 00 48 85 C0 0F 84 1D 02 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 49 3B CC 0F 87 FD 01 00 00 48 8B 40 18 48 03 C8 4C 3B E1 0F 83 ED 01 00 00 4D 8B 77 68 49 8B 0E 48 03 5D 17 48 8B 71 30 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 A7 48 89 44 24 38 48 8D 45 99 48 89 44 24 30 48 8D 45 97 48 89 44 24 28 48 8D 45 9F 48 89 44 24 20 4C 8B CB 4D 8B C4 49 8D 57 74 49 8B CE FF D6 85 C0 0F 88 BF 01 00 00 83 F8 01 7E 19 83 F8 03 0F 85 B1 01 00 00 48 83 7D 17 02 0F 83 82 00 00 00 E9 B2 FE FF FF 48 8D 45 97 48 8D 55 B7 48 8D 4D FF 48 39 45 A7 0F 85 DF 00 00 00 E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 0F 84 C7 00 00 00 48 8B 00 48 85 C0 0F 84 B5 00 00 00 48 8B 00 48 85 C0 0F 84 A9 00 00 00 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 0F 87 89 00 00 00 48 8B 40 18 48 03 C8 48 3B D1 73 7D 4C 8B 45 9F 4C 2B C2 33 D2 48 8D 4D FF E8 ?? ?? ?? ?? E9 35 FE FF FF 48 8D 55 B7 48 8D 4D FF E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 75 06 E8 ?? ?? ?? ?? CC 48 8B 00 48 85 C0 74 3C 48 8B 00 48 85 C0 74 34 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 77 18 48 8B 40 18 48 03 C8 48 3B D1 73 0C 0F B7 1A 66 89 5D 97 E9 CF 00 00 00 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 48 8B 50 10 48 85 D2 75 06 E8 ?? ?? ?? ?? CC 48 8B 00 48 85 C0 74 66 48 8B 00 48 85 C0 74 5E 48 83 78 20 10 72 06 48 8B 48 08 EB 04 48 8D 48 08 48 3B CA 77 42 48 8B 40 18 48 03 C8 48 3B D1 73 36 8B 45 17 48 8B 4D 9F 2B C1 03 C2 48 63 D8 85 C0 7E 1E 48 FF CB 0F BE 0C 0B 49 8B 97 80 00 00 00 E8 ?? ?? ?? ?? 48 85 DB 7E 06 48 8B 4D 9F EB E2 0F B7 5D 97 EB 35 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC BB FF FF 00 00 45 33 C0 B2 01 48 8D 4D FF E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D FF E8 ?? ?? ?? ?? 0F B7 C3 48 8B 4D 27 48 33 CC E8 ?? ?? ?? ?? 4C 8D 9C 24 E0 00 00 00 49 8B 5B 38 49 8B 73 40 49 8B E3 41 5F 41 5E 41 5C 5F 5D C3 }
	condition:
		$1
}

rule file_14_381_1 {
	meta:
		name = "?uflow@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAAGXZ"
		size = 80
		refs = "0018 _guard_check_icall"
		altNames = "?uflow@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAAGXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 01 48 8B F9 48 8B 58 30 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 BA FF FF 00 00 66 3B D0 74 17 48 8B 47 50 FF 08 48 8B 4F 38 48 8B 11 48 8D 42 02 48 89 01 0F B7 12 0F B7 C2 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_382_1 {
	meta:
		name = "?underflow@?$basic_filebuf@GU?$char_traits@G@std@@@std@@MEAAGXZ"
		size = 127
		refs = "003f _guard_check_icall"
		altNames = "?underflow@?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@MEAAGXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 41 38 48 8B F9 4C 8B 08 4D 85 C9 74 16 48 8B 51 50 4C 63 02 4B 8D 14 41 4C 3B CA 73 06 41 0F B7 01 EB 3B 48 8B 01 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 0F B7 F0 B8 FF FF 00 00 66 3B C6 74 1A 48 8B 07 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 0F B7 D6 48 8B CF FF D3 0F B7 C6 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_14_388_1 {
	meta:
		name = "?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAGD@Z"
		size = 159
		refs = "0024 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 002d ??$use_facet@V?$ctype@G@std@@@std@@YAAEBV?$ctype@G@0@AEBVlocale@0@@Z 0049 _guard_check_icall"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 40 48 C7 40 D8 FE FF FF FF 48 89 58 08 48 89 68 10 48 89 70 18 40 8A EA 48 8D 50 E0 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 8B 7C 24 30 48 85 FF 74 35 48 8B 17 48 8B 5A 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8B 06 48 8B 58 60 48 8B CB E8 ?? ?? ?? ?? 40 8A D5 48 8B CE FF D3 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_95_387_1 {
	meta:
		name = "?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBA_WD@Z"
		size = 159
		refs = "0024 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 002d ??$use_facet@V?$ctype@_W@std@@@std@@YAAEBV?$ctype@_W@0@AEBVlocale@0@@Z 0049 _guard_check_icall"
	strings:
		$1 = { 48 8B C4 57 48 83 EC 40 48 C7 40 D8 FE FF FF FF 48 89 58 08 48 89 68 10 48 89 70 18 40 8A EA 48 8D 50 E0 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 8B 7C 24 30 48 85 FF 74 35 48 8B 17 48 8B 5A 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8B 06 48 8B 58 60 48 8B CB E8 ?? ?? ?? ?? 40 8A D5 48 8B CE FF D3 48 8B 5C 24 50 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_14_390_1 {
	meta:
		name = "?widen@?$ctype@G@std@@QEBAGD@Z"
		size = 63
		refs = "0020 _guard_check_icall"
		altNames = "?widen@?$ctype@_W@std@@QEBA_WD@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 01 48 8B F1 40 8A FA 48 8B 58 60 48 8B CB E8 ?? ?? ?? ?? 40 8A D7 48 8B CE 48 8B C3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_14_391_1 {
	meta:
		name = "?xsgetn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA_JPEAG_J@Z"
		size = 215
		refs = "005e memcpy 008b _guard_check_icall"
		altNames = "?xsgetn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA_JPEA_W_J@Z"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 10 48 89 78 18 4C 89 70 20 41 57 48 83 EC 20 33 F6 49 8B F8 4C 8B FA 4C 8B F1 4D 85 C0 0F 8E 8C 00 00 00 49 8B 46 38 48 8B 10 48 85 D2 74 08 49 8B 46 50 8B 08 EB 02 33 C9 48 63 D9 85 C9 7E 36 48 3B FB 48 0F 4C DF 48 85 DB 74 0C 4C 8D 04 1B 49 8B CF E8 ?? ?? ?? ?? 49 8B 46 50 48 03 F3 48 2B FB 29 18 49 8B 4E 38 48 63 C3 48 03 C0 48 01 01 48 03 DB EB 2D 49 8B 06 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 B9 FF FF 00 00 66 3B C8 74 1B 48 FF C6 66 41 89 07 48 FF CF BB 02 00 00 00 4C 03 FB 48 85 FF 0F 8F 74 FF FF FF 48 8B 5C 24 30 48 8B C6 48 8B 74 24 38 48 8B 7C 24 40 4C 8B 74 24 48 48 83 C4 20 41 5F C3 }
	condition:
		$1
}

rule file_14_392_1 {
	meta:
		name = "?xsputn@?$basic_streambuf@GU?$char_traits@G@std@@@std@@MEAA_JPEBG_J@Z"
		size = 218
		refs = "0060 memcpy 0091 _guard_check_icall"
		altNames = "?xsputn@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@MEAA_JPEB_W_J@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 33 ED 49 8B F0 4C 8B FA 4C 8B F1 4D 85 C0 0F 8E 92 00 00 00 49 8B 46 40 4C 8B 08 4D 85 C9 74 08 49 8B 46 58 8B 08 EB 02 33 C9 48 63 D9 85 C9 7E 39 48 3B F3 48 0F 4C DE 48 85 DB 74 0F 4C 8D 04 1B 49 8B D7 49 8B C9 E8 ?? ?? ?? ?? 49 8B 46 58 48 03 EB 48 2B F3 29 18 49 8B 4E 40 48 63 C3 48 03 C0 48 01 01 48 03 DB EB 30 49 8B 06 41 0F B7 1F 48 8B 78 18 48 8B CF E8 ?? ?? ?? ?? 0F B7 D3 49 8B CE FF D7 B9 FF FF 00 00 66 3B C8 74 17 48 FF C5 BB 02 00 00 00 48 FF CE 4C 03 FB 48 85 F6 0F 8F 6E FF FF FF 48 8B 5C 24 40 48 8B C5 48 8B 6C 24 48 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_14_394_1 {
	meta:
		name = "wmemcpy"
		size = 26
		refs = "000d memcpy"
	strings:
		$1 = { 40 53 48 83 EC 20 4D 03 C0 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_0_1 {
	meta:
		name = "_Xp_addh"
		size = 883
		refs = "003d _Dunscale 0051 _Dtest 0068 _Pmsw 0095 _Feraise 009d _Nan 0228 _Dint 0235 _Dscale"
	strings:
		$1 = { F2 0F 11 54 24 18 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 45 33 E4 F2 0F 11 55 60 0F 29 74 24 30 48 8B F9 4C 63 FA 85 D2 0F 84 26 03 00 00 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 66 44 3B E0 7D 7F 66 83 F8 02 74 6B 48 8B CF E8 ?? ?? ?? ?? 66 85 C0 7E 5E 66 83 F8 02 0F 84 F6 02 00 00 48 8B CF E8 ?? ?? ?? ?? BE 00 80 00 00 48 8D 4D 58 0F B7 18 66 23 DE E8 ?? ?? ?? ?? 0F B7 08 66 23 CE 66 3B CB 0F 84 CB 02 00 00 41 8D 4C 24 01 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 07 41 83 FF 01 0F 8E AB 02 00 00 4C 89 67 08 E9 A2 02 00 00 F2 0F 10 45 58 F2 0F 11 07 E9 94 02 00 00 66 85 C0 0F 89 8B 02 00 00 41 BD 00 08 00 00 45 8B F4 49 8B DF 45 85 FF 0F 8E 76 02 00 00 49 8B F4 0F 57 F6 4C 8D 67 F8 F2 0F 10 04 F7 48 8D 55 D8 48 8D 4D 50 F2 0F 11 45 D8 E8 ?? ?? ?? ?? 33 C9 66 3B C8 0F 8C 4A 02 00 00 66 85 C0 0F 84 25 02 00 00 0F BF 55 50 0F BF 45 48 8B CA F2 0F 10 4D 58 2B C8 83 F9 E6 7F 61 66 0F 2E CE 7A 02 74 59 41 8B CE 48 8B C6 8B D1 48 FF C0 FF C1 48 3B C3 7D 0D F2 0F 10 04 C7 66 0F 2E C6 7A E9 75 E7 41 8D 47 FF 3B C8 7D 04 FF C1 EB 06 41 3B CF 0F 44 CA 48 63 D1 48 3B F2 7D 11 48 8B 44 D7 F8 48 89 04 D7 48 FF CA 48 3B D6 7F EF F2 0F 11 0C F7 F2 0F 11 75 58 E9 A3 01 00 00 B8 1A 00 00 00 3B C8 7C 13 66 0F 2E CE 7A 02 74 0B 44 8B EA 41 FF C6 E9 80 01 00 00 F2 0F 58 0C F7 66 0F 2E CE F2 0F 11 0C F7 7A 3A 75 38 48 8B C6 48 FF C0 48 3B C3 7D 13 F2 0F 10 04 C7 66 0F 2E C6 F2 0F 11 44 C7 F8 7A E7 75 E5 48 83 64 DF F8 00 F2 0F 10 04 F7 66 0F 2E C6 0F 28 C8 7A 06 0F 84 64 01 00 00 48 8D 55 58 F2 0F 11 4D 58 48 8D 4D 48 49 63 DE E8 ?? ?? ?? ?? 0F BF 55 48 41 8D 4D E6 3B CA 0F 8D 96 00 00 00 66 41 2B D5 48 8D 4D 58 66 83 C2 1A E8 ?? ?? ?? ?? 0F BF 55 48 48 8D 4D 58 E8 ?? ?? ?? ?? F2 0F 10 04 F7 49 8B DF F2 0F 5C 45 58 66 0F 2E C6 F2 0F 11 04 F7 7A 26 75 24 48 8B C6 48 FF C0 48 3B C3 7D 13 F2 0F 10 04 C7 66 0F 2E C6 F2 0F 11 44 C7 F8 7A E7 75 E5 4A 83 64 FF F8 00 48 FF CE 49 83 EC 08 41 83 EE 01 75 0B 41 BD 00 08 00 00 E9 A4 00 00 00 F2 41 0F 10 04 24 48 8D 55 60 48 8D 4D 50 F2 0F 11 45 60 E8 ?? ?? ?? ?? 44 0F BF 6D 50 E9 82 00 00 00 41 FF C6 45 3B F7 0F 84 9D 00 00 00 F2 0F 10 04 F7 48 8D 1C DF 48 8B D3 F2 0F 11 45 58 48 8D 4D 50 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8B CB E8 ?? ?? ?? ?? 0F BF 55 50 48 8B CB E8 ?? ?? ?? ?? F2 0F 10 45 58 F2 0F 10 0C F7 44 0F BF 6D 50 F2 0F 5C C1 66 0F 2E C6 F2 0F 11 45 58 7A 09 75 07 F2 0F 11 4D 60 EB 05 F2 0F 11 45 60 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 49 8B DF 48 FF C6 49 83 C4 08 45 3B F7 0F 8C B2 FD FF FF EB 1C F2 0F 10 45 58 49 63 C6 41 FF C6 F2 0F 11 04 C7 45 3B F7 7D 07 49 63 C6 48 89 0C C7 48 8B C7 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_27_0_1 {
	meta:
		name = "_LXp_addh"
		size = 883
		refs = "003d _LDunscale 0051 _LDtest 0068 _LPmsw 0095 _Feraise 009d _LNan 0228 _LDint 0235 _LDscale"
	strings:
		$1 = { F2 0F 11 54 24 18 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 45 33 E4 F2 0F 11 55 60 0F 29 74 24 30 48 8B F9 4C 63 FA 85 D2 0F 84 26 03 00 00 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 66 44 3B E0 7D 7F 66 83 F8 02 74 6B 48 8B CF E8 ?? ?? ?? ?? 66 85 C0 7E 5E 66 83 F8 02 0F 84 F6 02 00 00 48 8B CF E8 ?? ?? ?? ?? BE 00 80 00 00 48 8D 4D 58 0F B7 18 66 23 DE E8 ?? ?? ?? ?? 0F B7 08 66 23 CE 66 3B CB 0F 84 CB 02 00 00 41 8D 4C 24 01 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 07 41 83 FF 01 0F 8E AB 02 00 00 4C 89 67 08 E9 A2 02 00 00 F2 0F 10 45 58 F2 0F 11 07 E9 94 02 00 00 66 85 C0 0F 89 8B 02 00 00 41 BD 00 08 00 00 45 8B F4 49 8B DF 45 85 FF 0F 8E 76 02 00 00 49 8B F4 0F 57 F6 4C 8D 67 F8 F2 0F 10 04 F7 48 8D 55 D8 48 8D 4D 50 F2 0F 11 45 D8 E8 ?? ?? ?? ?? 33 C9 66 3B C8 0F 8C 4A 02 00 00 66 85 C0 0F 84 25 02 00 00 0F BF 55 50 0F BF 45 48 8B CA F2 0F 10 4D 58 2B C8 83 F9 E6 7F 61 66 0F 2E CE 7A 02 74 59 41 8B CE 48 8B C6 8B D1 48 FF C0 FF C1 48 3B C3 7D 0D F2 0F 10 04 C7 66 0F 2E C6 7A E9 75 E7 41 8D 47 FF 3B C8 7D 04 FF C1 EB 06 41 3B CF 0F 44 CA 48 63 D1 48 3B F2 7D 11 48 8B 44 D7 F8 48 89 04 D7 48 FF CA 48 3B D6 7F EF F2 0F 11 0C F7 F2 0F 11 75 58 E9 A3 01 00 00 B8 1A 00 00 00 3B C8 7C 13 66 0F 2E CE 7A 02 74 0B 44 8B EA 41 FF C6 E9 80 01 00 00 F2 0F 58 0C F7 66 0F 2E CE F2 0F 11 0C F7 7A 3A 75 38 48 8B C6 48 FF C0 48 3B C3 7D 13 F2 0F 10 04 C7 66 0F 2E C6 F2 0F 11 44 C7 F8 7A E7 75 E5 48 83 64 DF F8 00 F2 0F 10 04 F7 66 0F 2E C6 0F 28 C8 7A 06 0F 84 64 01 00 00 48 8D 55 58 F2 0F 11 4D 58 48 8D 4D 48 49 63 DE E8 ?? ?? ?? ?? 0F BF 55 48 41 8D 4D E6 3B CA 0F 8D 96 00 00 00 66 41 2B D5 48 8D 4D 58 66 83 C2 1A E8 ?? ?? ?? ?? 0F BF 55 48 48 8D 4D 58 E8 ?? ?? ?? ?? F2 0F 10 04 F7 49 8B DF F2 0F 5C 45 58 66 0F 2E C6 F2 0F 11 04 F7 7A 26 75 24 48 8B C6 48 FF C0 48 3B C3 7D 13 F2 0F 10 04 C7 66 0F 2E C6 F2 0F 11 44 C7 F8 7A E7 75 E5 4A 83 64 FF F8 00 48 FF CE 49 83 EC 08 41 83 EE 01 75 0B 41 BD 00 08 00 00 E9 A4 00 00 00 F2 41 0F 10 04 24 48 8D 55 60 48 8D 4D 50 F2 0F 11 45 60 E8 ?? ?? ?? ?? 44 0F BF 6D 50 E9 82 00 00 00 41 FF C6 45 3B F7 0F 84 9D 00 00 00 F2 0F 10 04 F7 48 8D 1C DF 48 8B D3 F2 0F 11 45 58 48 8D 4D 50 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8B CB E8 ?? ?? ?? ?? 0F BF 55 50 48 8B CB E8 ?? ?? ?? ?? F2 0F 10 45 58 F2 0F 10 0C F7 44 0F BF 6D 50 F2 0F 5C C1 66 0F 2E C6 F2 0F 11 45 58 7A 09 75 07 F2 0F 11 4D 60 EB 05 F2 0F 11 45 60 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 49 8B DF 48 FF C6 49 83 C4 08 45 3B F7 0F 8C B2 FD FF FF EB 1C F2 0F 10 45 58 49 63 C6 41 FF C6 F2 0F 11 04 C7 45 3B F7 7D 07 49 63 C6 48 89 0C C7 48 8B C7 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_16_1_1 {
	meta:
		name = "_Xp_addx"
		size = 111
		refs = "0034 __real@0000000000000000 0043 _Xp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 25 F2 0F 10 16 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 15 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 08 3B FD 7C DB 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_27_1_1 {
	meta:
		name = "_LXp_addx"
		size = 111
		refs = "0034 __real@0000000000000000 0043 _LXp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 25 F2 0F 10 16 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 15 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 08 3B FD 7C DB 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_16_2_1 {
	meta:
		name = "_Xp_getw"
		size = 113
		altNames = "_LXp_getw"
	strings:
		$1 = { 85 D2 75 04 0F 57 C0 C3 83 FA 01 74 5F F2 0F 10 19 0F 57 C9 66 0F 2E D9 7A 02 74 50 F2 0F 10 41 08 66 0F 2E C1 7A 02 74 43 83 FA 02 74 39 F2 0F 10 51 10 66 0F 2E D1 7A 02 74 2C 0F 28 E0 F2 0F 58 E3 83 FA 04 7C 05 F2 0F 58 51 18 0F 28 CC F2 0F 5C CB 66 0F 2E C8 7A 0A 75 08 F2 0F 58 D4 0F 28 C2 C3 F2 0F 58 C2 F2 0F 58 C3 C3 F2 0F 10 01 C3 }
	condition:
		$1
}

rule file_16_3_1 {
	meta:
		name = "_Xp_invx"
		size = 330
		refs = "0035 _Dtest 005b _Inf 0085 memcpy 008d __real@bff0000000000000 0097 _Xp_mulh 00ad __real@3ff0000000000000 00bb _Xp_setw 00e2 _Xp_mulx 00f4 _Xp_addh 0119 _Xp_addx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 33 ED 0F 29 70 D8 48 63 FA 4D 8B F8 48 8B D9 85 D2 0F 84 EF 00 00 00 E8 ?? ?? ?? ?? 66 3B E8 7F 2A 8D 75 01 66 3B C6 75 08 48 89 2B E9 D5 00 00 00 66 85 C0 0F 85 CC 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 E9 BB 00 00 00 F2 0F 10 33 4C 8B F7 49 C1 E6 03 48 8B D3 4D 8B C6 4B 8D 2C 3E 48 8B CD 4D 8D 24 2E E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? BE 01 00 00 00 3B FE 7E 05 F2 0F 58 73 08 F2 0F 10 15 ?? ?? ?? ?? 8B D7 F2 0F 5E D6 48 8B CB E8 ?? ?? ?? ?? 3B FE 7E 60 4D 8B C6 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C5 8B D7 49 8B CF E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C3 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4D 8B C7 8B D7 48 8B CB E8 ?? ?? ?? ?? 03 F6 3B F7 7C A0 48 8B 6C 24 68 48 8B C3 48 8B 5C 24 60 48 8B 74 24 70 48 8B 7C 24 78 0F 28 74 24 30 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_27_3_1 {
	meta:
		name = "_LXp_invx"
		size = 330
		refs = "0035 _LDtest 005b _LInf 0085 memcpy 008d __real@bff0000000000000 0097 _LXp_mulh 00ad __real@3ff0000000000000 00bb _LXp_setw 00e2 _LXp_mulx 00f4 _LXp_addh 0119 _LXp_addx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 33 ED 0F 29 70 D8 48 63 FA 4D 8B F8 48 8B D9 85 D2 0F 84 EF 00 00 00 E8 ?? ?? ?? ?? 66 3B E8 7F 2A 8D 75 01 66 3B C6 75 08 48 89 2B E9 D5 00 00 00 66 85 C0 0F 85 CC 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 E9 BB 00 00 00 F2 0F 10 33 4C 8B F7 49 C1 E6 03 48 8B D3 4D 8B C6 4B 8D 2C 3E 48 8B CD 4D 8D 24 2E E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? BE 01 00 00 00 3B FE 7E 05 F2 0F 58 73 08 F2 0F 10 15 ?? ?? ?? ?? 8B D7 F2 0F 5E D6 48 8B CB E8 ?? ?? ?? ?? 3B FE 7E 60 4D 8B C6 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C5 8B D7 49 8B CF E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C3 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4D 8B C7 8B D7 48 8B CB E8 ?? ?? ?? ?? 03 F6 3B F7 7C A0 48 8B 6C 24 68 48 8B C3 48 8B 5C 24 60 48 8B 74 24 70 48 8B 7C 24 78 0F 28 74 24 30 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_16_4_1 {
	meta:
		name = "_Xp_ldexpx"
		size = 110
		refs = "0032 ldexp 003a __real@0000000000000000"
		altNames = "_LXp_ldexpx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 DB 45 8B F0 8B EA 48 8B F1 85 D2 7E 29 48 8B F9 F2 0F 10 07 41 8B D6 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? F2 0F 11 07 7A 02 74 0A FF C3 48 83 C7 08 3B DD 7C DA 48 8B 5C 24 30 48 8B C6 48 8B 74 24 40 48 8B 6C 24 38 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_16_5_1 {
	meta:
		name = "_Xp_movx"
		size = 36
		refs = "0017 memcpy"
		altNames = "_LXp_movx"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 48 8B D9 4C 63 C2 48 8B D0 49 C1 E0 03 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_6_1 {
	meta:
		name = "_Xp_mulh"
		size = 492
		refs = "0027 __security_cookie 0053 _Dtest 006e _Feraise 0132 _Dunscale 0140 _Dint 014d _Dscale 015d _Xp_addh 01c3 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 0F 29 74 24 70 0F 29 7C 24 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 D0 45 33 E4 4C 63 FA 0F 28 FA 48 8B F9 85 D2 7E 58 0F 28 C2 F2 0F 59 01 48 8D 4D B0 F2 0F 11 45 B0 E8 ?? ?? ?? ?? 0F B7 F0 66 44 3B E0 7F 37 41 8D 5C 24 01 66 83 F8 02 75 07 8B CB E8 ?? ?? ?? ?? F2 0F 10 45 B0 F2 0F 11 07 66 44 3B E6 0F 8D 33 01 00 00 44 3B FB 0F 8E 2A 01 00 00 4C 89 67 08 E9 21 01 00 00 4C 89 27 BB 01 00 00 00 41 8B C4 89 45 A4 44 8B F3 45 85 FF 0F 8E 07 01 00 00 4D 8B EC 8B F3 4C 8D 65 B0 0F 57 F6 4C 2B E7 48 83 FE 04 7D 4D 42 8D 14 30 4A 8D 04 2E 48 8D 0C C7 41 3B D7 7D 2E F2 0F 10 01 66 0F 2E C6 7A 02 74 22 48 83 21 00 44 03 F3 F2 0F 59 C7 03 D3 48 03 F3 F2 41 0F 11 04 0C 48 83 C1 08 48 83 FE 04 7C CF EB 0E 48 83 64 F5 B0 00 BE 08 00 00 00 44 8B F6 F2 0F 10 45 B0 66 0F 2E C6 7A 06 0F 84 94 00 00 00 48 8D 55 A8 F2 0F 11 45 A8 48 8D 4D A0 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8D 4D A8 E8 ?? ?? ?? ?? 0F BF 55 A0 48 8D 4D A8 E8 ?? ?? ?? ?? F2 0F 10 55 A8 41 8B D7 48 8B CF E8 ?? ?? ?? ?? F2 0F 10 55 B0 41 8B D7 F2 0F 5C 55 A8 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 3B DE 7D 1C F2 0F 10 44 C5 B0 66 0F 2E C6 F2 0F 11 44 C5 A8 7A 02 74 08 48 03 C3 48 3B C6 7C E4 8B 45 A4 4C 03 EB 03 C3 49 83 EC 08 44 2B F3 89 45 A4 48 2B F3 4D 3B EF 0F 8C 08 FF FF FF 48 8B C7 48 8B 4D D0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 D0 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 80 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_27_6_1 {
	meta:
		name = "_LXp_mulh"
		size = 492
		refs = "0027 __security_cookie 0053 _LDtest 006e _Feraise 0132 _LDunscale 0140 _LDint 014d _LDscale 015d _LXp_addh 01c3 __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 81 EC 80 00 00 00 0F 29 74 24 70 0F 29 7C 24 60 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 D0 45 33 E4 4C 63 FA 0F 28 FA 48 8B F9 85 D2 7E 58 0F 28 C2 F2 0F 59 01 48 8D 4D B0 F2 0F 11 45 B0 E8 ?? ?? ?? ?? 0F B7 F0 66 44 3B E0 7F 37 41 8D 5C 24 01 66 83 F8 02 75 07 8B CB E8 ?? ?? ?? ?? F2 0F 10 45 B0 F2 0F 11 07 66 44 3B E6 0F 8D 33 01 00 00 44 3B FB 0F 8E 2A 01 00 00 4C 89 67 08 E9 21 01 00 00 4C 89 27 BB 01 00 00 00 41 8B C4 89 45 A4 44 8B F3 45 85 FF 0F 8E 07 01 00 00 4D 8B EC 8B F3 4C 8D 65 B0 0F 57 F6 4C 2B E7 48 83 FE 04 7D 4D 42 8D 14 30 4A 8D 04 2E 48 8D 0C C7 41 3B D7 7D 2E F2 0F 10 01 66 0F 2E C6 7A 02 74 22 48 83 21 00 44 03 F3 F2 0F 59 C7 03 D3 48 03 F3 F2 41 0F 11 04 0C 48 83 C1 08 48 83 FE 04 7C CF EB 0E 48 83 64 F5 B0 00 BE 08 00 00 00 44 8B F6 F2 0F 10 45 B0 66 0F 2E C6 7A 06 0F 84 94 00 00 00 48 8D 55 A8 F2 0F 11 45 A8 48 8D 4D A0 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8D 4D A8 E8 ?? ?? ?? ?? 0F BF 55 A0 48 8D 4D A8 E8 ?? ?? ?? ?? F2 0F 10 55 A8 41 8B D7 48 8B CF E8 ?? ?? ?? ?? F2 0F 10 55 B0 41 8B D7 F2 0F 5C 55 A8 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 3B DE 7D 1C F2 0F 10 44 C5 B0 66 0F 2E C6 F2 0F 11 44 C5 A8 7A 02 74 08 48 03 C3 48 3B C6 7C E4 8B 45 A4 4C 03 EB 03 C3 49 83 EC 08 44 2B F3 89 45 A4 48 2B F3 4D 3B EF 0F 8C 08 FF FF FF 48 8B C7 48 8B 4D D0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 D0 00 00 00 0F 28 74 24 70 0F 28 7C 24 60 48 81 C4 80 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_16_7_1 {
	meta:
		name = "_Xp_mulx"
		size = 257
		refs = "0042 __real@0000000000000000 005f _Xp_mulh 007f memcpy 00d5 _Xp_addx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 63 E9 49 8B D8 48 63 FA 48 8B F1 85 D2 0F 84 B1 00 00 00 45 85 C9 0F 84 A8 00 00 00 F2 41 0F 10 10 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 12 F2 41 0F 10 40 08 66 0F 2E 05 ?? ?? ?? ?? 7A 0B 75 09 8B D7 E8 ?? ?? ?? ?? EB 7C 4C 8B 7C 24 70 4C 8B F7 49 C1 E6 03 48 8B D6 4D 8B C6 49 8B CF 4F 8D 24 3E E8 ?? ?? ?? ?? F2 0F 10 13 8B D7 48 8B CE E8 ?? ?? ?? ?? 4C 8B ED BD 01 00 00 00 EB 41 F2 0F 10 04 EB 66 0F 2E 05 ?? ?? ?? ?? 7A 02 74 35 4D 8B C6 49 8B D7 49 8B CC E8 ?? ?? ?? ?? F2 0F 10 14 EB 8B D7 49 8B CC E8 ?? ?? ?? ?? 44 8B CF 4D 8B C4 8B D7 48 8B CE E8 ?? ?? ?? ?? 48 FF C5 49 3B ED 7C BA 48 8B 5C 24 50 48 8B C6 48 8B 74 24 60 48 8B 6C 24 58 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_27_7_1 {
	meta:
		name = "_LXp_mulx"
		size = 257
		refs = "0042 __real@0000000000000000 005f _LXp_mulh 007f memcpy 00d5 _LXp_addx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 63 E9 49 8B D8 48 63 FA 48 8B F1 85 D2 0F 84 B1 00 00 00 45 85 C9 0F 84 A8 00 00 00 F2 41 0F 10 10 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 12 F2 41 0F 10 40 08 66 0F 2E 05 ?? ?? ?? ?? 7A 0B 75 09 8B D7 E8 ?? ?? ?? ?? EB 7C 4C 8B 7C 24 70 4C 8B F7 49 C1 E6 03 48 8B D6 4D 8B C6 49 8B CF 4F 8D 24 3E E8 ?? ?? ?? ?? F2 0F 10 13 8B D7 48 8B CE E8 ?? ?? ?? ?? 4C 8B ED BD 01 00 00 00 EB 41 F2 0F 10 04 EB 66 0F 2E 05 ?? ?? ?? ?? 7A 02 74 35 4D 8B C6 49 8B D7 49 8B CC E8 ?? ?? ?? ?? F2 0F 10 14 EB 8B D7 49 8B CC E8 ?? ?? ?? ?? 44 8B CF 4D 8B C4 8B D7 48 8B CE E8 ?? ?? ?? ?? 48 FF C5 49 3B ED 7C BA 48 8B 5C 24 50 48 8B C6 48 8B 74 24 60 48 8B 6C 24 58 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_16_8_1 {
	meta:
		name = "_Xp_setn"
		size = 32
		refs = "0013 _Xp_setw"
	strings:
		$1 = { 40 53 48 83 EC 20 66 41 0F 6E D0 48 8B D9 F3 0F E6 D2 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_27_8_1 {
	meta:
		name = "_LXp_setn"
		size = 32
		refs = "0013 _LXp_setw"
	strings:
		$1 = { 40 53 48 83 EC 20 66 41 0F 6E D0 48 8B D9 F3 0F E6 D2 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_16_9_1 {
	meta:
		name = "_Xp_setw"
		size = 273
		refs = "003b _Dunscale 006b _Dint 007a _Dscale 009d __real@0000000000000000"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 48 83 EC 30 33 ED 0F 29 70 D8 F2 0F 11 50 08 0F 28 F2 8B FA 48 8B D9 85 D2 0F 8E D3 00 00 00 83 FA 01 0F 84 C6 00 00 00 48 8D 50 08 48 8D 48 10 E8 ?? ?? ?? ?? 66 85 C0 0F 84 AA 00 00 00 66 3B E8 7D 13 F2 0F 10 44 24 50 F2 0F 11 03 48 89 6B 08 E9 9C 00 00 00 BA 1A 00 00 00 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F BF 54 24 58 48 8D 4C 24 50 E8 ?? ?? ?? ?? F2 0F 10 44 24 50 48 8D 73 08 F2 0F 11 03 F2 0F 5C F0 F2 0F 11 36 83 FF 02 7E 63 66 0F 2E 35 ?? ?? ?? ?? 7A 08 75 06 48 89 6B 10 EB 51 48 8B D6 48 8D 4C 24 58 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8B CE E8 ?? ?? ?? ?? 0F BF 54 24 58 48 8B CE E8 ?? ?? ?? ?? F2 0F 5C 36 F2 0F 11 73 10 83 FF 03 7E 1C 66 0F 2E 35 ?? ?? ?? ?? 7A 02 74 10 48 89 6B 18 EB 0A F2 0F 10 74 24 50 F2 0F 11 33 0F 28 74 24 20 48 8B C3 48 8B 5C 24 60 48 83 C4 30 5F 5E 5D C3 }
	condition:
		$1
}

rule file_27_9_1 {
	meta:
		name = "_LXp_setw"
		size = 273
		refs = "003b _LDunscale 006b _LDint 007a _LDscale 009d __real@0000000000000000"
	strings:
		$1 = { 48 8B C4 48 89 58 18 55 56 57 48 83 EC 30 33 ED 0F 29 70 D8 F2 0F 11 50 08 0F 28 F2 8B FA 48 8B D9 85 D2 0F 8E D3 00 00 00 83 FA 01 0F 84 C6 00 00 00 48 8D 50 08 48 8D 48 10 E8 ?? ?? ?? ?? 66 85 C0 0F 84 AA 00 00 00 66 3B E8 7D 13 F2 0F 10 44 24 50 F2 0F 11 03 48 89 6B 08 E9 9C 00 00 00 BA 1A 00 00 00 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F BF 54 24 58 48 8D 4C 24 50 E8 ?? ?? ?? ?? F2 0F 10 44 24 50 48 8D 73 08 F2 0F 11 03 F2 0F 5C F0 F2 0F 11 36 83 FF 02 7E 63 66 0F 2E 35 ?? ?? ?? ?? 7A 08 75 06 48 89 6B 10 EB 51 48 8B D6 48 8D 4C 24 58 E8 ?? ?? ?? ?? BA 1A 00 00 00 48 8B CE E8 ?? ?? ?? ?? 0F BF 54 24 58 48 8B CE E8 ?? ?? ?? ?? F2 0F 5C 36 F2 0F 11 73 10 83 FF 03 7E 1C 66 0F 2E 35 ?? ?? ?? ?? 7A 02 74 10 48 89 6B 18 EB 0A F2 0F 10 74 24 50 F2 0F 11 33 0F 28 74 24 20 48 8B C3 48 8B 5C 24 60 48 83 C4 30 5F 5E 5D C3 }
	condition:
		$1
}

rule file_16_10_1 {
	meta:
		name = "_Xp_sqrtx"
		size = 351
		refs = "0031 _Dtest 006c sqrt 0074 __real@3ff0000000000000 0082 _Xp_setw 009b memcpy 00a3 __real@bfe0000000000000 00ad _Xp_mulh 00c2 _Xp_mulx 00df __real@3ff8000000000000 00e9 _Xp_addh 012d _Feraise 0135 _Nan"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 33 F6 48 63 FA 49 8B E8 48 8B D9 85 D2 0F 84 0D 01 00 00 E8 ?? ?? ?? ?? 0F 57 C0 66 3B F0 0F 8E E0 00 00 00 F2 0F 10 0B 66 0F 2F C1 0F 87 D8 00 00 00 4C 8B F7 49 C1 E6 03 49 8D 34 2E 4D 8D 3C 36 83 FF 01 7E 05 F2 0F 58 4B 08 0F 28 C1 E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 F2 0F 5E D0 48 8B CE E8 ?? ?? ?? ?? 41 BC 02 00 00 00 41 3B FC 7E 79 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C3 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CD E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 45 03 E4 44 3B E7 7C 87 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 1C 66 0F 2F 03 76 16 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 48 8B 6C 24 58 48 8B C3 48 8B 5C 24 50 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_27_10_1 {
	meta:
		name = "_LXp_sqrtx"
		size = 351
		refs = "0031 _LDtest 006c sqrt 0074 __real@3ff0000000000000 0082 _LXp_setw 009b memcpy 00a3 __real@bfe0000000000000 00ad _LXp_mulh 00c2 _LXp_mulx 00df __real@3ff8000000000000 00e9 _LXp_addh 012d _Feraise 0135 _LNan"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 33 F6 48 63 FA 49 8B E8 48 8B D9 85 D2 0F 84 0D 01 00 00 E8 ?? ?? ?? ?? 0F 57 C0 66 3B F0 0F 8E E0 00 00 00 F2 0F 10 0B 66 0F 2F C1 0F 87 D8 00 00 00 4C 8B F7 49 C1 E6 03 49 8D 34 2E 4D 8D 3C 36 83 FF 01 7E 05 F2 0F 58 4B 08 0F 28 C1 E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 F2 0F 5E D0 48 8B CE E8 ?? ?? ?? ?? 41 BC 02 00 00 00 41 3B FC 7E 79 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C3 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CD E8 ?? ?? ?? ?? F2 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 45 03 E4 44 3B E7 7C 87 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 1C 66 0F 2F 03 76 16 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 03 48 8B 6C 24 58 48 8B C3 48 8B 5C 24 50 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_16_11_1 {
	meta:
		name = "_Xp_subx"
		size = 118
		refs = "0034 __real@0000000000000000 003f __xmm@80000000000000008000000000000000 004a _Xp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 2C F2 0F 10 16 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 1C 0F 57 15 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 08 3B FD 7C D4 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_27_11_1 {
	meta:
		name = "_LXp_subx"
		size = 118
		refs = "0034 __real@0000000000000000 003f __xmm@80000000000000008000000000000000 004a _LXp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 2C F2 0F 10 16 66 0F 2E 15 ?? ?? ?? ?? 7A 02 74 1C 0F 57 15 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 08 3B FD 7C D4 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_17_0_1 {
	meta:
		name = "_Query_perf_counter"
		size = 25
		refs = "000b __imp_QueryPerformanceCounter"
	strings:
		$1 = { 48 83 EC 28 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_17_1_1 {
	meta:
		name = "_Query_perf_frequency"
		size = 25
		refs = "000b __imp_QueryPerformanceFrequency"
	strings:
		$1 = { 48 83 EC 28 48 8D 4C 24 30 FF 15 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_17_2_1 {
	meta:
		name = "_Xtime_diff_to_millis"
		size = 71
		refs = "0009 __security_cookie 0023 xtime_get 0030 _Xtime_diff_to_millis2 003d __security_check_cookie"
	strings:
		$1 = { 40 53 48 83 EC 40 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 30 48 8B D9 BA 01 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 54 24 20 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 40 5B C3 }
	condition:
		$1
}

rule file_17_3_1 {
	meta:
		name = "_Xtime_diff_to_millis2"
		size = 203
	strings:
		$1 = { 48 83 EC 18 0F 10 01 4C 8B DA 0F 11 04 24 4C 8B 0C 24 66 0F 73 D8 08 66 41 0F 7E C0 45 85 C0 79 24 83 C9 FF B8 83 BE E0 12 41 2B C8 F7 E1 2B CA D1 E9 03 CA C1 E9 1D FF C1 69 C1 00 CA 9A 3B 44 03 C0 4C 2B C9 41 BA 00 CA 9A 3B 45 3B C2 7C 22 B8 83 BE E0 12 41 F7 E0 41 8B C0 2B C2 D1 E8 03 C2 C1 E8 1D 8B C8 69 C0 00 36 65 C4 44 03 C0 4C 03 C9 45 3B 43 08 7D 13 45 2B 53 08 48 83 C8 FF 49 2B 03 4C 03 C8 45 03 C2 EB 07 4D 2B 0B 45 2B 43 08 4D 85 C9 78 07 75 0B 45 85 C0 7F 06 45 33 C9 45 33 C0 41 8D 88 3F 42 0F 00 B8 83 DE 1B 43 F7 E9 49 69 C9 E8 03 00 00 C1 FA 12 8B C2 C1 E8 1F 03 C2 48 03 C1 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_17_4_1 {
	meta:
		name = "_Xtime_get_ticks"
		size = 47
		refs = "000a __crtGetSystemTimePreciseAsFileTime"
	strings:
		$1 = { 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 34 48 BA 00 80 C1 2A 21 4E 62 FE 8B 4C 24 30 48 C1 E0 20 48 03 C2 48 03 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_17_5_1 {
	meta:
		name = "sys_get_time"
		size = 59
		refs = "000a _Xtime_get_ticks"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 4C 8B C0 48 B8 BD 42 7A E5 D5 94 BF D6 49 F7 E0 48 C1 EA 17 48 89 13 69 D2 80 96 98 00 44 2B C2 41 6B C0 64 89 43 08 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_17_6_1 {
	meta:
		name = "xtime_diff"
		size = 132
	strings:
		$1 = { 0F 10 02 45 33 C9 41 BA 00 CA 9A 3B F3 0F 7F 01 8B 51 08 85 D2 79 11 48 8B 01 48 FF C8 41 03 D2 78 F8 89 51 08 48 89 01 8B 41 08 41 3B C2 7C 14 48 8B 11 48 FF C2 41 2B C2 41 3B C2 7D F5 89 41 08 48 89 11 8B 51 08 41 3B 50 08 7D 13 41 2B 50 08 48 83 C8 FF 49 2B 00 48 01 01 41 03 D2 EB 0A 49 8B 00 48 29 01 41 2B 50 08 89 51 08 4C 39 09 7C 07 75 0C 41 3B D1 7F 07 4C 89 09 44 89 49 08 48 8B C1 C3 }
	condition:
		$1
}

rule file_17_7_1 {
	meta:
		name = "xtime_get"
		size = 86
		refs = "001a _Xtime_get_ticks"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 8B DA 48 8B F9 83 FA 01 75 33 48 85 C9 74 2E E8 ?? ?? ?? ?? 4C 8B C0 48 B8 BD 42 7A E5 D5 94 BF D6 49 F7 E0 48 C1 EA 17 69 CA 80 96 98 00 48 89 17 44 2B C1 41 6B C0 64 89 47 08 EB 02 33 DB 8B C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_17_8_1 {
	meta:
		name = "xtime_normalize"
		size = 59
	strings:
		$1 = { 8B 41 08 41 B8 00 CA 9A 3B 85 C0 79 11 48 8B 11 48 FF CA 41 03 C0 78 F8 89 41 08 48 89 11 8B 41 08 41 3B C0 7C 14 48 8B 11 48 FF C2 41 2B C0 41 3B C0 7D F5 89 41 08 48 89 11 C3 }
	condition:
		$1
}

rule file_18_0_1 {
	meta:
		name = "_Stolx"
		size = 222
		refs = "003b isspace 0060 _Stoulx 0096 _errno"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 68 18 48 89 70 20 57 41 56 41 57 48 83 EC 20 48 85 D2 48 8D 70 08 48 8B E9 48 8B F9 0F B6 09 48 0F 45 F2 4D 8B F1 45 8B F8 EB 06 48 FF C7 0F B6 0F E8 ?? ?? ?? ?? 85 C0 75 F1 8A 1F 8D 43 D5 A8 FD 74 04 B3 2B EB 03 48 FF C7 4D 8B CE 45 8B C7 48 8B D6 48 8B CF E8 ?? ?? ?? ?? 8B C8 48 3B 3E 75 03 48 89 2E BF FF FF FF 7F 41 B7 2D 48 3B 2E 75 04 85 C9 75 16 80 FB 2B 75 04 3B CF 77 0D 41 3A DF 75 2E 81 F9 00 00 00 80 76 26 E8 ?? ?? ?? ?? C7 00 22 00 00 00 4D 85 F6 74 07 41 C7 06 01 00 00 00 B8 00 00 00 80 41 3A DF 0F 44 F8 8B C7 EB 0A F7 D8 41 3A DF 0F 44 C8 8B C1 48 8B 5C 24 48 48 8B 6C 24 50 48 8B 74 24 58 48 83 C4 20 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_20_0_1 {
	meta:
		name = "?_Release_chore@details@Concurrency@@YAXPEAU_Threadpool_chore@12@@Z"
		size = 48
		refs = "0014 __encodedKERNEL32Functions 001b __security_cookie 0022 __crtCloseThreadpoolWork"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 09 48 85 C9 74 19 48 8B 05 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 74 05 E8 ?? ?? ?? ?? 48 83 23 00 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_20_1_1 {
	meta:
		name = "?_Reschedule_chore@details@Concurrency@@YAHPEBU_Threadpool_chore@12@@Z"
		size = 19
		refs = "0008 __crtSubmitThreadpoolWork"
	strings:
		$1 = { 48 83 EC 28 48 8B 09 E8 ?? ?? ?? ?? 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_2_1 {
	meta:
		name = "?_Schedule_chore@details@Concurrency@@YAHPEAU_Threadpool_chore@12@@Z"
		size = 108
		refs = "0009 __encodedKERNEL32Functions 0013 __security_cookie 0022 ?task_scheduler_callback@?A0x979d740b@details@Concurrency@@YAXPEAU_TP_CALLBACK_INSTANCE@@PEAXPEAU_TP_WORK@@@Z 0027 __crtCreateThreadpoolWork 0037 __crtSubmitThreadpoolWork 004b __imp_GetLastError 0058 ?task_scheduler_callback_xp@?A0x979d740b@details@Concurrency@@YAKPEAX@Z 005e __imp_QueueUserWorkItem"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 05 ?? ?? ?? ?? 48 8B D9 48 33 05 ?? ?? ?? ?? 48 8B D1 74 33 45 33 C0 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 10 48 8B C8 E8 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 48 83 C4 20 5B 48 FF 25 ?? ?? ?? ?? 48 89 19 45 33 C0 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 D5 48 83 23 00 EB D7 }
	condition:
		$1
}

rule file_20_3_1 {
	meta:
		name = "?is_vista_threadpool_supported@?A0x979d740b@details@Concurrency@@YA_NXZ"
		size = 18
		refs = "0003 __encodedKERNEL32Functions 000a __security_cookie"
		altNames = "?are_vista_sync_apis_available@details@Concurrency@@YA_NXZ ?are_win7_sync_apis_available@details@Concurrency@@YA_NXZ"
	strings:
		$1 = { 48 8B 05 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 0F 95 C0 C3 }
	condition:
		$1
}

rule file_20_4_1 {
	meta:
		name = "?task_scheduler_callback@?A0x979d740b@details@Concurrency@@YAXPEAU_TP_CALLBACK_INSTANCE@@PEAXPEAU_TP_WORK@@@Z"
		size = 45
		refs = "0015 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 5A 08 48 8B FA 48 8B CB E8 ?? ?? ?? ?? 48 8B 4F 10 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_20_5_1 {
	meta:
		name = "?task_scheduler_callback_xp@?A0x979d740b@details@Concurrency@@YAKPEAX@Z"
		size = 44
		refs = "0015 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 59 08 48 8B F9 48 8B CB E8 ?? ?? ?? ?? 48 8B 4F 10 FF D3 48 8B 5C 24 30 33 C0 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_21_47_1 {
	meta:
		name = "??0_Sentry_base@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@AEAV12@@Z"
		size = 77
		refs = "0031 _guard_check_icall"
		altNames = "??0_Sentry_base@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@AEAV12@@Z ??0_Sentry_base@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@AEAV12@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 89 11 48 8B F9 48 8B 02 4C 63 40 04 49 8B 74 10 48 48 85 F6 74 14 48 8B 06 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CE FF D3 48 8B 5C 24 30 48 8B C7 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_21_50_1 {
	meta:
		name = "??0_Winit@std@@QEAA@XZ"
		size = 34
		refs = "0002 ?_Init_cnt@_Winit@std@@0HA"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 78 0A FF C0 89 05 ?? ?? ?? ?? EB 0A C7 05 ?? ?? ?? ?? 01 00 00 00 48 8B C1 C3 }
	condition:
		$1
}

rule file_33_50_1 {
	meta:
		name = "??0_UShinit@std@@QEAA@XZ"
		size = 34
		refs = "0002 ?_Init_cnt@_UShinit@std@@0HA"
	strings:
		$1 = { 8B 05 ?? ?? ?? ?? 85 C0 78 0A FF C0 89 05 ?? ?? ?? ?? EB 0A C7 05 ?? ?? ?? ?? 01 00 00 00 48 8B C1 C3 }
	condition:
		$1
}

rule file_21_60_1 {
	meta:
		name = "??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@AEAV12@@Z"
		size = 157
		refs = "0046 _guard_check_icall 006e ?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@XZ"
	strings:
		$1 = { 48 8B C4 48 89 48 08 41 56 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 48 89 78 20 48 8B FA 48 8B F1 48 89 11 48 8B 02 4C 63 40 04 4D 8B 74 10 48 4D 85 F6 74 15 49 8B 06 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 90 48 8B 07 48 63 48 04 83 7C 39 10 00 75 14 48 8B 4C 39 50 48 85 C9 74 0A 48 3B CF 74 05 E8 ?? ?? ?? ?? 48 8B 07 48 63 48 04 83 7C 39 10 00 0F 94 C0 88 46 08 48 8B C6 48 8B 5C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5E C3 }
	condition:
		$1
}

rule file_115_59_1 {
	meta:
		name = "??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@AEAV12@@Z"
		size = 157
		refs = "0046 _guard_check_icall 006e ?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ"
	strings:
		$1 = { 48 8B C4 48 89 48 08 41 56 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 48 89 78 20 48 8B FA 48 8B F1 48 89 11 48 8B 02 4C 63 40 04 4D 8B 74 10 48 4D 85 F6 74 15 49 8B 06 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 90 48 8B 07 48 63 48 04 83 7C 39 10 00 75 14 48 8B 4C 39 50 48 85 C9 74 0A 48 3B CF 74 05 E8 ?? ?? ?? ?? 48 8B 07 48 63 48 04 83 7C 39 10 00 0F 94 C0 88 46 08 48 8B C6 48 8B 5C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5E C3 }
	condition:
		$1
}

rule file_33_60_1 {
	meta:
		name = "??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@AEAV12@@Z"
		size = 157
		refs = "0046 _guard_check_icall 006e ?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@XZ"
	strings:
		$1 = { 48 8B C4 48 89 48 08 41 56 48 83 EC 30 48 C7 40 E8 FE FF FF FF 48 89 58 10 48 89 70 18 48 89 78 20 48 8B FA 48 8B F1 48 89 11 48 8B 02 4C 63 40 04 4D 8B 74 10 48 4D 85 F6 74 15 49 8B 06 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 90 48 8B 07 48 63 48 04 83 7C 39 10 00 75 14 48 8B 4C 39 50 48 85 C9 74 0A 48 3B CF 74 05 E8 ?? ?? ?? ?? 48 8B 07 48 63 48 04 83 7C 39 10 00 0F 94 C0 88 46 08 48 8B C6 48 8B 5C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5E C3 }
	condition:
		$1
}

rule file_21_74_1 {
	meta:
		name = "??1_Sentry_base@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@XZ"
		size = 73
		refs = "0033 _guard_check_icall"
		altNames = "??1_Sentry_base@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@XZ ??1_Sentry_base@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B 11 48 8B 02 48 63 48 04 48 8B 7C 11 48 48 85 FF 74 16 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 90 48 8B CF FF D3 90 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_21_76_1 {
	meta:
		name = "??1_Winit@std@@QEAA@XZ"
		size = 81
		refs = "000f ?_Init_cnt@_Winit@std@@0HA 0019 ?_Ptr_wcout@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 0023 ?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@XZ 002b ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA 003d ?_Ptr_wclog@std@@3PEAV?$basic_ostream@_WU?$char_traits@_W@std@@@1@EA"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 83 2D ?? ?? ?? ?? 01 75 36 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_33_76_1 {
	meta:
		name = "??1_UShinit@std@@QEAA@XZ"
		size = 81
		refs = "000f ?_Init_cnt@_UShinit@std@@0HA 0019 ?_Ptr_wcout@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 0023 ?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@XZ 002b ?_Ptr_wcerr@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA 003d ?_Ptr_wclog@std@@3PEAV?$basic_ostream@GU?$char_traits@G@std@@@1@EA"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 FE FF FF FF 83 2D ?? ?? ?? ?? 01 75 36 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 8B 0D ?? ?? ?? ?? 48 85 C9 74 06 E8 ?? ?? ?? ?? 90 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_21_81_1 {
	meta:
		name = "??1sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@XZ"
		size = 95
		refs = "0018 ?uncaught_exception@std@@YA_NXZ 0025 ?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ 0049 _guard_check_icall"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B D9 E8 ?? ?? ?? ?? 90 84 C0 75 09 48 8B 0B E8 ?? ?? ?? ?? 90 48 8B 13 48 8B 02 48 63 48 04 48 8B 7C 11 48 48 85 FF 74 16 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 90 48 8B CF FF D3 90 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_115_79_1 {
	meta:
		name = "??1sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@XZ"
		size = 95
		refs = "0018 ?uncaught_exception@std@@YA_NXZ 0025 ?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ 0049 _guard_check_icall"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B D9 E8 ?? ?? ?? ?? 90 84 C0 75 09 48 8B 0B E8 ?? ?? ?? ?? 90 48 8B 13 48 8B 02 48 63 48 04 48 8B 7C 11 48 48 85 FF 74 16 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 90 48 8B CF FF D3 90 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_33_81_1 {
	meta:
		name = "??1sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@XZ"
		size = 95
		refs = "0018 ?uncaught_exception@std@@YA_NXZ 0025 ?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ 0049 _guard_check_icall"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B D9 E8 ?? ?? ?? ?? 90 84 C0 75 09 48 8B 0B E8 ?? ?? ?? ?? 90 48 8B 13 48 8B 02 48 63 48 04 48 8B 7C 11 48 48 85 FF 74 16 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 90 48 8B CF FF D3 90 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_21_133_1 {
	meta:
		name = "?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
		size = 133
		refs = "0041 _guard_check_icall 0070 ?clear@ios_base@std@@QEAAXH_N@Z"
		altNames = "?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 89 74 24 48 48 8B F1 48 8B 01 48 63 78 04 83 7C 0F 10 00 75 4B F6 44 0F 18 02 74 44 48 8B 7C 0F 48 48 8B 07 48 8B 58 68 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 83 F8 FF 75 26 48 8B 06 48 63 48 04 48 03 CE 8B 51 10 8B C2 83 C8 04 48 83 79 48 00 0F 44 D0 83 CA 04 45 33 C0 E8 ?? ?? ?? ?? 90 48 8B 5C 24 40 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_21_169_1 {
	meta:
		name = "?flush@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAAEAV12@XZ"
		size = 223
		refs = "0036 ??0sentry@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAA@AEAV12@@Z 0059 _guard_check_icall 0088 ?clear@ios_base@std@@QEAAXH_N@Z 008e ?uncaught_exception@std@@YA_NXZ 009c ?_Osfx@?$basic_ostream@_WU?$char_traits@_W@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 40 49 C7 43 D8 FE FF FF FF 49 89 5B 08 49 89 73 10 48 8B F1 48 8B 01 48 63 50 04 48 83 7C 0A 48 00 0F 84 9E 00 00 00 48 8B D1 49 8D 4B E0 E8 ?? ?? ?? ?? 90 80 7C 24 30 00 74 4B 48 8B 06 48 63 48 04 48 8B 7C 31 48 48 8B 07 48 8B 58 68 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 83 F8 FF 75 26 48 8B 06 48 63 48 04 48 03 CE 8B 51 10 8B C2 83 C8 04 48 83 79 48 00 0F 44 D0 83 CA 04 45 33 C0 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 84 C0 75 0B 48 8B 4C 24 28 E8 ?? ?? ?? ?? 90 48 8B 54 24 28 48 8B 02 48 63 48 04 48 8B 7C 11 48 48 85 FF 74 15 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 90 48 8B C6 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_115_170_1 {
	meta:
		name = "?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ"
		size = 223
		refs = "0036 ??0sentry@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAA@AEAV12@@Z 0059 _guard_check_icall 0088 ?clear@ios_base@std@@QEAAXH_N@Z 008e ?uncaught_exception@std@@YA_NXZ 009c ?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 40 49 C7 43 D8 FE FF FF FF 49 89 5B 08 49 89 73 10 48 8B F1 48 8B 01 48 63 50 04 48 83 7C 0A 48 00 0F 84 9E 00 00 00 48 8B D1 49 8D 4B E0 E8 ?? ?? ?? ?? 90 80 7C 24 30 00 74 4B 48 8B 06 48 63 48 04 48 8B 7C 31 48 48 8B 07 48 8B 58 68 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 83 F8 FF 75 26 48 8B 06 48 63 48 04 48 03 CE 8B 51 10 8B C2 83 C8 04 48 83 79 48 00 0F 44 D0 83 CA 04 45 33 C0 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 84 C0 75 0B 48 8B 4C 24 28 E8 ?? ?? ?? ?? 90 48 8B 54 24 28 48 8B 02 48 63 48 04 48 8B 7C 11 48 48 85 FF 74 15 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 90 48 8B C6 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_33_169_1 {
	meta:
		name = "?flush@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAAEAV12@XZ"
		size = 223
		refs = "0036 ??0sentry@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAA@AEAV12@@Z 0059 _guard_check_icall 0088 ?clear@ios_base@std@@QEAAXH_N@Z 008e ?uncaught_exception@std@@YA_NXZ 009c ?_Osfx@?$basic_ostream@GU?$char_traits@G@std@@@std@@QEAAXXZ"
	strings:
		$1 = { 4C 8B DC 57 48 83 EC 40 49 C7 43 D8 FE FF FF FF 49 89 5B 08 49 89 73 10 48 8B F1 48 8B 01 48 63 50 04 48 83 7C 0A 48 00 0F 84 9E 00 00 00 48 8B D1 49 8D 4B E0 E8 ?? ?? ?? ?? 90 80 7C 24 30 00 74 4B 48 8B 06 48 63 48 04 48 8B 7C 31 48 48 8B 07 48 8B 58 68 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 83 F8 FF 75 26 48 8B 06 48 63 48 04 48 03 CE 8B 51 10 8B C2 83 C8 04 48 83 79 48 00 0F 44 D0 83 CA 04 45 33 C0 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 84 C0 75 0B 48 8B 4C 24 28 E8 ?? ?? ?? ?? 90 48 8B 54 24 28 48 8B 02 48 63 48 04 48 8B 7C 11 48 48 85 FF 74 15 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 90 48 8B C6 48 8B 5C 24 50 48 8B 74 24 58 48 83 C4 40 5F C3 }
	condition:
		$1
}

rule file_21_186_1 {
	meta:
		name = "?pubsync@?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@QEAAHXZ"
		size = 47
		refs = "0018 _guard_check_icall"
		altNames = "?pubsync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ ?pubsync@?$basic_streambuf@GU?$char_traits@G@std@@@std@@QEAAHXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 01 48 8B F9 48 8B 58 68 48 8B CB E8 ?? ?? ?? ?? 48 8B CF 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_22_0_1 {
	meta:
		name = "_FDunscale"
		size = 138
		refs = "004d _FDnorm"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 0F B7 42 02 48 8B F1 66 C1 E8 07 B9 FF 00 00 00 66 23 C1 33 DB 48 8B FA 66 3B C1 75 18 66 89 1E F6 42 02 7F 75 08 8D 43 01 66 39 1A 74 3D B8 02 00 00 00 EB 36 66 3B D8 72 15 48 8B CF E8 ?? ?? ?? ?? 66 85 C0 7E 08 66 89 1E 0F B7 C3 EB 1C B9 7F BF 00 00 66 83 E8 7E 66 21 4F 02 B9 00 3F 00 00 66 09 4F 02 66 89 06 83 C8 FF 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_4_1 {
	meta:
		name = "??$?8DU?$char_traits@D@std@@@std@@YA_NAEBV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 86
		refs = "001d ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ"
		altNames = "?equal@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QEBA_NAEBV12@@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 8B F1 38 59 08 75 05 E8 ?? ?? ?? ?? 38 5F 08 75 08 48 8B CF E8 ?? ?? ?? ?? 48 39 1E 75 07 48 39 1F 74 07 EB 0A 48 39 1F 74 05 BB 01 00 00 00 48 8B 74 24 38 8A C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_41_19_1 {
	meta:
		name = "??$?8GU?$char_traits@G@std@@@std@@YA_NAEBV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 86
		refs = "001d ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 8B F1 38 59 08 75 05 E8 ?? ?? ?? ?? 38 5F 08 75 08 48 8B CF E8 ?? ?? ?? ?? 48 39 1E 75 07 48 39 1F 74 07 EB 0A 48 39 1F 74 05 BB 01 00 00 00 48 8B 74 24 38 8A C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_41_22_1 {
	meta:
		name = "??$?8_WU?$char_traits@_W@std@@@std@@YA_NAEBV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 86
		refs = "001d ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 8B F1 38 59 08 75 05 E8 ?? ?? ?? ?? 38 5F 08 75 08 48 8B CF E8 ?? ?? ?? ?? 48 39 1E 75 07 48 39 1F 74 07 EB 0A 48 39 1F 74 05 BB 01 00 00 00 48 8B 74 24 38 8A C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_41_1163_1 {
	meta:
		name = "?equal@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QEBA_NAEBV12@@Z"
		size = 86
		refs = "001d ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 8B F1 38 59 08 75 05 E8 ?? ?? ?? ?? 38 5F 08 75 08 48 8B CF E8 ?? ?? ?? ?? 48 39 1E 75 07 48 39 1F 74 07 EB 0A 48 39 1F 74 05 BB 01 00 00 00 48 8B 74 24 38 8A C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_41_1164_1 {
	meta:
		name = "?equal@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QEBA_NAEBV12@@Z"
		size = 86
		refs = "001d ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 8B F1 38 59 08 75 05 E8 ?? ?? ?? ?? 38 5F 08 75 08 48 8B CF E8 ?? ?? ?? ?? 48 39 1E 75 07 48 39 1F 74 07 EB 0A 48 39 1F 74 05 BB 01 00 00 00 48 8B 74 24 38 8A C3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_7_1 {
	meta:
		name = "??$?9DU?$char_traits@D@std@@@std@@YA_NAEBV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0@Z"
		size = 91
		refs = "001d ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 8B F1 38 59 08 75 05 E8 ?? ?? ?? ?? 38 5F 08 75 08 48 8B CF E8 ?? ?? ?? ?? 48 39 1E 75 1C 48 39 1F 74 1C 8B C3 48 8B 5C 24 30 84 C0 48 8B 74 24 38 0F 94 C0 48 83 C4 20 5F C3 48 39 1F 74 E4 B8 01 00 00 00 EB DF }
	condition:
		$1
}

rule file_41_25_1 {
	meta:
		name = "??$?9GU?$char_traits@G@std@@@std@@YA_NAEBV?$istreambuf_iterator@GU?$char_traits@G@std@@@0@0@Z"
		size = 91
		refs = "001d ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 8B F1 38 59 08 75 05 E8 ?? ?? ?? ?? 38 5F 08 75 08 48 8B CF E8 ?? ?? ?? ?? 48 39 1E 75 1C 48 39 1F 74 1C 8B C3 48 8B 5C 24 30 84 C0 48 8B 74 24 38 0F 94 C0 48 83 C4 20 5F C3 48 39 1F 74 E4 B8 01 00 00 00 EB DF }
	condition:
		$1
}

rule file_41_28_1 {
	meta:
		name = "??$?9_WU?$char_traits@_W@std@@@std@@YA_NAEBV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@0@0@Z"
		size = 91
		refs = "001d ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 33 DB 48 8B FA 48 8B F1 38 59 08 75 05 E8 ?? ?? ?? ?? 38 5F 08 75 08 48 8B CF E8 ?? ?? ?? ?? 48 39 1E 75 1C 48 39 1F 74 1C 8B C3 48 8B 5C 24 30 84 C0 48 8B 74 24 38 0F 94 C0 48 83 C4 20 5F C3 48 39 1F 74 E4 B8 01 00 00 00 EB DF }
	condition:
		$1
}

rule file_24_9_1 {
	meta:
		name = "??$_Find_elem@D@std@@YA_KPEADD@Z"
		size = 28
	strings:
		$1 = { 44 8A 01 48 8B C1 EB 0B 44 3A C2 74 0B 48 FF C0 44 8A 00 45 84 C0 75 F0 48 2B C1 C3 }
	condition:
		$1
}

rule file_24_10_1 {
	meta:
		name = "??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0_KPEBD@Z"
		size = 525
		refs = "0024 __security_cookie 0069 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 00f2 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 01ad ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ 01bb _invalid_parameter_noinfo_noreturn 01d0 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 01e2 ?_Deallocate@std@@YAXPEAX_K1@Z 01f1 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 60 48 C7 45 C8 FE FF FF FF 48 89 58 20 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F8 4D 8B F9 4D 8B E8 4C 8B F2 48 8B D9 41 80 39 00 74 1D 41 8A 11 49 8B C9 49 8D 45 01 41 3A 11 49 0F 45 C5 4C 8B E8 48 FF C1 8A 11 84 D2 75 E9 45 33 C0 49 8B D5 48 8D 4D D0 E8 ?? ?? ?? ?? 90 C7 45 C4 FE FF FF FF 41 BC 01 00 00 00 32 C9 88 4D C0 33 F6 33 FF 4D 85 ED 0F 84 39 01 00 00 EB 08 41 3A 07 74 0B 48 FF C6 42 8A 04 3E 84 C0 75 F0 48 3B 7D E8 0F 87 17 01 00 00 48 8D 45 D8 48 83 7D F0 10 48 0F 43 45 D8 80 3C 38 00 74 1B 48 8D 45 D8 48 83 7D F0 10 48 0F 43 45 D8 48 0F BE 04 38 48 03 F0 E9 8A 00 00 00 49 03 F4 42 8A 04 3E 41 3A 07 74 5B 84 C0 74 57 80 7B 08 00 75 08 48 8B CB E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3B 00 75 08 49 83 3E 00 74 26 EB 06 49 83 3E 00 75 1E 80 7B 08 00 75 08 48 8B CB E8 ?? ?? ?? ?? 8A 43 09 42 38 04 3E 75 07 B1 01 88 4D C0 EB 2E 48 3B 7D E8 77 7D EB 03 89 7D C4 48 8D 55 D8 48 83 7D F0 10 48 0F 43 55 D8 B9 7F 00 00 00 4C 3B E1 41 0F B6 C4 0F 42 C8 88 0C 3A 8A 4D C0 48 FF C7 49 3B FD 0F 82 26 FF FF FF 84 C9 74 51 80 7B 08 00 75 08 48 8B CB E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3B 00 75 08 49 83 3E 00 74 28 EB 06 49 83 3E 00 75 20 49 FF C4 48 8B CB E8 ?? ?? ?? ?? 83 4D C4 FF E9 C1 FE FF FF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? 90 45 33 C0 B2 01 48 8D 4D D0 E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D D0 E8 ?? ?? ?? ?? 8B 45 C4 48 8B 4D F8 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 B8 00 00 00 48 83 C4 60 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_12_1 {
	meta:
		name = "??$_Getvals@D@?$numpunct@D@std@@IEAAXDPEBUlconv@@U_Cvtvec@@@Z"
		size = 18
	strings:
		$1 = { 49 8B 00 8A 10 88 51 18 49 8B 40 08 8A 10 88 51 19 C3 }
	condition:
		$1
}

rule file_24_14_1 {
	meta:
		name = "??$_Maklocstr@D@std@@YAPEADPEBDPEADAEBU_Cvtvec@@@Z"
		size = 95
		refs = "0026 calloc 005a ?_Xbad_alloc@std@@YAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B F9 48 83 CB FF 48 FF C3 80 3C 19 00 75 F7 48 FF C3 BA 01 00 00 00 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 48 85 C0 74 27 48 85 DB 74 14 48 8B C8 48 2B CF 8A 07 88 04 39 48 FF C7 48 83 EB 01 75 F2 48 8B C2 48 8B 5C 24 30 48 83 C4 20 5F C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_24_64_1 {
	meta:
		name = "??0?$numpunct@D@std@@QEAA@AEBV_Locinfo@1@_K_N@Z"
		size = 54
		refs = "001d ??_7?$numpunct@D@std@@6B@ 0028 ?_Init@?$numpunct@D@std@@IEAAXAEBV_Locinfo@2@_N@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 44 89 41 08 48 8D 05 ?? ?? ?? ?? 48 89 01 45 8A C1 E8 ?? ?? ?? ?? 90 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_283_1 {
	meta:
		name = "??0?$numpunct@G@std@@QEAA@AEBV_Locinfo@1@_K_N@Z"
		size = 54
		refs = "001d ??_7?$numpunct@G@std@@6B@ 0028 ?_Init@?$numpunct@G@std@@IEAAXAEBV_Locinfo@2@_N@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 44 89 41 08 48 8D 05 ?? ?? ?? ?? 48 89 01 45 8A C1 E8 ?? ?? ?? ?? 90 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_285_1 {
	meta:
		name = "??0?$numpunct@_W@std@@QEAA@AEBV_Locinfo@1@_K_N@Z"
		size = 54
		refs = "001d ??_7?$numpunct@_W@std@@6B@ 0028 ?_Init@?$numpunct@_W@std@@IEAAXAEBV_Locinfo@2@_N@Z"
	strings:
		$1 = { 48 89 4C 24 08 53 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 8B D9 44 89 41 08 48 8D 05 ?? ?? ?? ?? 48 89 01 45 8A C1 E8 ?? ?? ?? ?? 90 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_24_101_1 {
	meta:
		name = "??1?$numpunct@D@std@@MEAA@XZ"
		size = 62
		refs = "0009 ??_7?$numpunct@D@std@@6B@ 0018 free 0031 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 8B 49 10 E8 ?? ?? ?? ?? 48 8B 4B 20 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_367_1 {
	meta:
		name = "??1?$numpunct@G@std@@MEAA@XZ"
		size = 62
		refs = "0009 ??_7?$numpunct@G@std@@6B@ 0018 free 0031 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 8B 49 10 E8 ?? ?? ?? ?? 48 8B 4B 20 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_368_1 {
	meta:
		name = "??1?$numpunct@_W@std@@MEAA@XZ"
		size = 62
		refs = "0009 ??_7?$numpunct@_W@std@@6B@ 0018 free 0031 ??_7_Facet_base@std@@6B@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B D9 48 89 01 48 8B 49 10 E8 ?? ?? ?? ?? 48 8B 4B 20 E8 ?? ?? ?? ?? 48 8B 4B 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 03 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_24_114_1 {
	meta:
		name = "??4?$_Yarn@D@std@@QEAAAEAV01@PEBD@Z"
		size = 118
		refs = "0023 free 0048 malloc 005f memcpy"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B F1 48 8B FA 48 8B 09 48 3B CA 74 46 48 85 C9 74 05 E8 ?? ?? ?? ?? 48 83 26 00 48 85 FF 74 33 80 3F 00 48 8B DF 74 08 48 FF C3 80 3B 00 75 F8 48 2B DF 48 8D 4B 01 E8 ?? ?? ?? ?? 48 89 06 48 85 C0 74 0F 4C 8D 43 01 48 8B D7 48 8B C8 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C6 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_115_1 {
	meta:
		name = "??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z"
		size = 35
		refs = "0016 ?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 3B CA 74 0C 49 83 C9 FF 45 33 C0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_401_1 {
	meta:
		name = "??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV01@AEBV01@@Z"
		size = 35
		refs = "0016 ?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 3B CA 74 0C 49 83 C9 FF 45 33 C0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_403_1 {
	meta:
		name = "??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV01@AEBV01@@Z"
		size = 35
		refs = "0016 ?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@AEBV12@_K1@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 3B CA 74 0C 49 83 C9 FF 45 33 C0 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_24_116_1 {
	meta:
		name = "??4?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@QEAAAEAV01@D@Z"
		size = 40
		refs = "0013 ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 08 48 85 C9 74 0A E8 ?? ?? ?? ?? 83 F8 FF 75 03 C6 03 01 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_24_117_1 {
	meta:
		name = "??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAD_K@Z"
		size = 42
		refs = "0025 _invalid_parameter_noinfo_noreturn"
		altNames = "??A?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAAEBD_K@Z"
	strings:
		$1 = { 48 83 EC 28 48 3B 51 18 77 1A 48 83 79 20 10 72 06 48 8B 49 08 EB 04 48 83 C1 08 48 8D 04 11 48 83 C4 28 C3 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_24_120_1 {
	meta:
		name = "??D?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QEBADXZ"
		size = 29
		refs = "0010 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 80 79 08 00 48 8B D9 75 05 E8 ?? ?? ?? ?? 8A 43 09 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_24_122_1 {
	meta:
		name = "??E?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_32_2_1 {
	meta:
		name = "??0exception_ptr@std@@QEAA@AEBV01@@Z"
		size = 23
		refs = "000a ?__ExceptionPtrCopy@@YAXPEAXPEBX@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_429_1 {
	meta:
		name = "??E?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_430_1 {
	meta:
		name = "??E?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@QEAAAEAV01@XZ"
		size = 23
		refs = "000a ?_Inc@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_68_209_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_445_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_41_446_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 23
		refs = "000a ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_7_79_3 {
	meta:
		name = "?getECSUName@UnDecorator@@CA?AVDName@@XZ"
		size = 23
		refs = "000a ?getScopedName@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_7_100_3 {
	meta:
		name = "?getReferenceType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
		size = 23
		refs = "000a ?getPtrRefType@UnDecorator@@CA?AVDName@@AEBV2@0PEBD@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_7_124_3 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 23
		refs = "000a ?getVfTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_24_130_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MEAAPEAXI@Z"
		size = 94
		refs = "000d ??_7?$numpunct@D@std@@6B@ 001e free 0037 ??_7_Facet_base@std@@6B@ 004c ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B F9 48 89 01 8B DA 48 8B 49 10 E8 ?? ?? ?? ?? 48 8B 4F 20 E8 ?? ?? ?? ?? 48 8B 4F 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 F6 C3 01 74 0D BA 30 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_41_476_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MEAAPEAXI@Z"
		size = 94
		refs = "000d ??_7?$numpunct@G@std@@6B@ 001e free 0037 ??_7_Facet_base@std@@6B@ 004c ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B F9 48 89 01 8B DA 48 8B 49 10 E8 ?? ?? ?? ?? 48 8B 4F 20 E8 ?? ?? ?? ?? 48 8B 4F 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 F6 C3 01 74 0D BA 30 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_41_477_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MEAAPEAXI@Z"
		size = 94
		refs = "000d ??_7?$numpunct@_W@std@@6B@ 001e free 0037 ??_7_Facet_base@std@@6B@ 004c ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8D 05 ?? ?? ?? ?? 48 8B F9 48 89 01 8B DA 48 8B 49 10 E8 ?? ?? ?? ?? 48 8B 4F 20 E8 ?? ?? ?? ?? 48 8B 4F 28 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 F6 C3 01 74 0D BA 30 00 00 00 48 8B CF E8 ?? ?? ?? ?? 48 8B C7 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_152_1 {
	meta:
		name = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAXAEBU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z"
		size = 73
		refs = "0016 ?_Deallocate@std@@YAXPEAX_K1@Z 002a ?_Allocate@std@@YAPEAX_K0_N@Z"
		altNames = "?_Copy_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAXAEBU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z ?_Copy_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAXAEBU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z ?_Move_alloc@?$_String_alloc@U?$_String_base_types@DV?$allocator@D@std@@@std@@@std@@QEAAXAEAU?$_Wrap_alloc@V?$allocator@D@std@@@2@@Z ?_Move_alloc@?$_String_alloc@U?$_String_base_types@GV?$allocator@G@std@@@std@@@std@@QEAAXAEAU?$_Wrap_alloc@V?$allocator@G@std@@@2@@Z ?_Move_alloc@?$_String_alloc@U?$_String_base_types@_WV?$allocator@_W@std@@@std@@@std@@QEAAXAEAU?$_Wrap_alloc@V?$allocator@_W@std@@@2@@Z"
	strings:
		$1 = { 40 53 48 83 EC 20 BA 01 00 00 00 48 8B D9 48 8B 09 44 8D 42 0F E8 ?? ?? ?? ?? 48 83 23 00 BA 10 00 00 00 41 B0 01 8D 4A F1 E8 ?? ?? ?? ?? 48 89 03 48 85 C0 74 07 0F 57 C0 F3 0F 7F 00 48 8B 03 48 89 18 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_24_156_1 {
	meta:
		name = "?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADDH@Z"
		size = 156
		altNames = "?_Ffmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAPEADPEADDH@Z ?_Ffmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAPEADPEADDH@Z"
	strings:
		$1 = { C6 02 25 4C 8B DA 4C 8D 52 01 41 F6 C1 20 74 07 41 C6 02 2B 49 FF C2 41 F6 C1 10 74 07 41 C6 02 23 49 FF C2 66 41 C7 02 2E 2A 49 83 C2 02 45 84 C0 74 06 45 88 02 49 FF C2 41 8B D1 41 B8 00 30 00 00 41 23 D0 41 F6 C1 04 74 18 B8 47 00 00 00 81 FA 00 10 00 00 8D 48 FE 0F 44 C1 B9 41 00 00 00 EB 16 B8 67 00 00 00 81 FA 00 10 00 00 8D 48 FE 0F 44 C1 B9 61 00 00 00 41 3B D0 0F 44 C1 81 FA 00 20 00 00 0F B6 C8 B8 66 00 00 00 0F 44 C8 49 8B C3 41 88 0A 41 C6 42 01 00 C3 }
	condition:
		$1
}

rule file_24_157_1 {
	meta:
		name = "?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBD_K@Z"
		size = 1351
		refs = "0028 __security_cookie 0081 ??_C@_02MDKMJEGG@eE?$AA@ 008a ??_C@_02OOPEBDOJ@pP?$AA@ 00af strcspn 00c3 localeconv 00e8 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 00f1 ??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z 010e _guard_check_icall 0143 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 0191 ??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z 01de ?grouping@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0220 _invalid_parameter_noinfo_noreturn 027b ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0D@Z 02f2 ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z 04e4 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 04f5 ?_Deallocate@std@@YAXPEAX_K1@Z 0528 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 B9 48 81 EC E0 00 00 00 48 C7 45 A7 FE FF FF FF 48 89 58 08 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 FF 49 8B D9 48 89 5C 24 48 4D 8B E0 48 89 55 8F 8A 45 6F 88 44 24 20 4C 8B 6D 77 48 8B 7D 7F 48 89 7D 87 48 85 FF 74 12 41 8A 45 00 2C 2B A8 FD 75 08 41 BE 01 00 00 00 EB 03 45 33 F6 41 8B 41 18 B9 00 30 00 00 23 C1 3B C1 74 09 48 8D 15 ?? ?? ?? ?? EB 24 48 8D 15 ?? ?? ?? ?? 49 8D 4E 02 48 3B CF 77 14 43 80 3C 2E 30 75 0D 43 8A 44 2E 01 2C 58 A8 DF 4C 0F 44 F1 49 8B CD E8 ?? ?? ?? ?? 48 89 44 24 30 B8 2E 00 00 00 66 89 44 24 40 E8 ?? ?? ?? ?? 48 8B 08 8A 01 88 44 24 40 48 8D 54 24 40 49 8B CD E8 ?? ?? ?? ?? 4C 8B F8 48 8D 55 97 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 50 48 8B 75 9F 48 85 F6 74 35 48 8B 06 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CE FF D3 48 8B F0 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CE FF D3 90 45 33 C0 48 8B D7 48 8D 4D AF E8 ?? ?? ?? ?? 90 48 8D 75 B7 48 83 7D CF 10 48 0F 43 75 B7 48 8B 44 24 50 48 8B 00 4A 8D 1C 2F 48 8B 78 38 48 8B CF E8 ?? ?? ?? ?? 4C 8B CE 4C 8B C3 49 8B D5 48 8B 4C 24 50 FF D7 48 8D 55 97 48 8B 4C 24 48 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 8B 7D 9F 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 55 D7 48 8B CE E8 ?? ?? ?? ?? 90 48 8B 06 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 48 8B CE FF D3 44 8A E8 48 8B 7D 87 4C 3B FF 74 37 48 8B 06 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 48 8B CE FF D3 8A C8 4C 3B 7D C7 76 06 E8 ?? ?? ?? ?? CC 48 8D 45 B7 48 83 7D CF 10 48 0F 43 45 B7 42 88 0C 38 4C 3B FF 4C 0F 44 7C 24 30 48 8D 5D DF 48 83 7D F7 10 48 0F 43 5D DF 80 3B 7F 74 3F 80 3B 00 7E 3A 48 0F BE 0B 49 8B C7 49 2B C6 48 3B C8 73 2B 4C 2B F9 45 8A CD 41 B8 01 00 00 00 49 8B D7 48 8D 4D AF E8 ?? ?? ?? ?? 48 8D 43 01 80 38 00 48 0F 4E C3 48 8B D8 80 38 7F 75 C1 48 8B 75 C7 4C 8B 6C 24 48 49 8B 5D 28 48 85 DB 7E 0A 48 3B DE 76 05 48 2B DE EB 02 33 DB 41 8B 45 18 25 C0 01 00 00 41 0F 10 04 24 0F 29 44 24 30 83 F8 40 0F 84 1C 01 00 00 3D 00 01 00 00 0F 84 87 00 00 00 48 85 DB 74 2F 48 8B 7C 24 38 44 8A 7C 24 20 48 85 FF 74 10 41 8A D7 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 83 EB 01 75 E0 0F 28 44 24 30 F3 41 0F 7F 04 24 33 DB 0F 29 44 24 30 48 8D 7D B7 48 83 7D CF 10 48 0F 43 7D B7 4D 8B FE 4D 85 F6 0F 84 FD 00 00 00 4C 8B 6C 24 38 4D 85 ED 74 0F 8A 17 49 8B CD E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 FF C7 49 83 EF 01 75 DE E9 C7 00 00 00 48 8D 7D B7 48 83 7D CF 10 48 0F 43 7D B7 4D 8B FE 4D 85 F6 74 31 4C 8B 6C 24 38 4D 85 ED 74 0F 8A 17 49 8B CD E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 FF C7 49 83 EF 01 75 DE 0F 28 44 24 30 4C 8B 6C 24 48 F3 41 0F 7F 04 24 0F 29 44 24 30 48 85 DB 74 2F 48 8B 7C 24 38 44 8A 7C 24 20 48 85 FF 74 10 41 8A D7 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 83 EB 01 75 E0 0F 28 44 24 30 33 DB EB 47 48 8D 7D B7 48 83 7D CF 10 48 0F 43 7D B7 4D 8B FE 4D 85 F6 74 31 4C 8B 6C 24 38 4D 85 ED 74 0F 8A 17 49 8B CD E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 FF C7 49 83 EF 01 75 DE 0F 28 44 24 30 4C 8B 6C 24 48 F3 41 0F 7F 04 24 0F 29 44 24 30 4C 3B 75 C7 76 06 E8 ?? ?? ?? ?? CC 48 8D 7D B7 41 BF 10 00 00 00 4C 39 7D CF 48 0F 43 7D B7 49 03 FE 49 2B F6 74 2C 4C 8B 74 24 38 4D 85 F6 74 0F 8A 17 49 8B CE E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 FF C7 48 83 EE 01 75 DE 0F 28 44 24 30 F3 41 0F 7F 04 24 49 83 65 28 00 41 0F 10 04 24 0F 29 44 24 30 48 85 DB 74 2B 48 8B 7C 24 38 48 85 FF 74 11 8A 54 24 20 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 83 EB 01 75 DF 0F 28 44 24 30 48 8B 5D 8F F3 0F 7F 03 45 33 C0 B2 01 48 8D 4D D7 E8 ?? ?? ?? ?? 4D 8B C7 BA 01 00 00 00 48 8B 4D D7 E8 ?? ?? ?? ?? 48 83 65 D7 00 45 33 C0 B2 01 48 8D 4D AF E8 ?? ?? ?? ?? 4D 8B C7 BA 01 00 00 00 48 8B 4D AF E8 ?? ?? ?? ?? 48 8B C3 48 8B 4D FF 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 20 01 00 00 48 81 C4 E0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_175_1 {
	meta:
		name = "?_Getcat@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 193
		refs = "003c ??2@YAPEAX_K@Z 005c ??_C@_00CNPNBAHC@?$AA@ 0075 ??0_Locinfo@std@@QEAA@PEBD@Z 0085 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 009f ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC 90 00 00 00 48 C7 40 88 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 A0 00 00 00 48 85 C9 74 70 48 39 31 75 6B 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 A0 00 00 00 48 85 C0 74 3E 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 4C 8D 9C 24 90 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_41_628_1 {
	meta:
		name = "?_Getcat@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 193
		refs = "003c ??2@YAPEAX_K@Z 005c ??_C@_00CNPNBAHC@?$AA@ 0075 ??0_Locinfo@std@@QEAA@PEBD@Z 0085 ??_7?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 009f ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC 90 00 00 00 48 C7 40 88 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 A0 00 00 00 48 85 C9 74 70 48 39 31 75 6B 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 A0 00 00 00 48 85 C0 74 3E 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 4C 8D 9C 24 90 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_41_630_1 {
	meta:
		name = "?_Getcat@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 193
		refs = "003c ??2@YAPEAX_K@Z 005c ??_C@_00CNPNBAHC@?$AA@ 0075 ??0_Locinfo@std@@QEAA@PEBD@Z 0085 ??_7?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 009f ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC 90 00 00 00 48 C7 40 88 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 A0 00 00 00 48 85 C9 74 70 48 39 31 75 6B 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 A0 00 00 00 48 85 C0 74 3E 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 4C 8D 9C 24 90 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_24_177_1 {
	meta:
		name = "?_Getcat@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 193
		refs = "003c ??2@YAPEAX_K@Z 005c ??_C@_00CNPNBAHC@?$AA@ 0075 ??0_Locinfo@std@@QEAA@PEBD@Z 0085 ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 009f ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC 90 00 00 00 48 C7 40 88 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 A0 00 00 00 48 85 C9 74 70 48 39 31 75 6B 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 A0 00 00 00 48 85 C0 74 3E 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 4C 8D 9C 24 90 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_41_632_1 {
	meta:
		name = "?_Getcat@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 193
		refs = "003c ??2@YAPEAX_K@Z 005c ??_C@_00CNPNBAHC@?$AA@ 0075 ??0_Locinfo@std@@QEAA@PEBD@Z 0085 ??_7?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@6B@ 009f ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC 90 00 00 00 48 C7 40 88 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 A0 00 00 00 48 85 C9 74 70 48 39 31 75 6B 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 A0 00 00 00 48 85 C0 74 3E 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 4C 8D 9C 24 90 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_41_634_1 {
	meta:
		name = "?_Getcat@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 193
		refs = "003c ??2@YAPEAX_K@Z 005c ??_C@_00CNPNBAHC@?$AA@ 0075 ??0_Locinfo@std@@QEAA@PEBD@Z 0085 ??_7?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@6B@ 009f ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 48 81 EC 90 00 00 00 48 C7 40 88 FE FF FF FF 48 89 58 10 48 89 68 18 48 89 70 20 48 8B EA 48 8B F9 33 F6 89 B4 24 A0 00 00 00 48 85 C9 74 70 48 39 31 75 6B 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 A0 00 00 00 48 85 C0 74 3E 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? BE 01 00 00 00 83 63 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 4C 8D 9C 24 90 00 00 00 49 8B 5B 18 49 8B 6B 20 49 8B 73 28 49 8B E3 5F C3 }
	condition:
		$1
}

rule file_24_179_1 {
	meta:
		name = "?_Getcat@?$numpunct@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 209
		refs = "003b ??2@YAPEAX_K@Z 005b ??_C@_00CNPNBAHC@?$AA@ 0074 ??0_Locinfo@std@@QEAA@PEBD@Z 008c ??_7?$numpunct@D@std@@6B@ 009d ?_Init@?$numpunct@D@std@@IEAAXAEBV_Locinfo@2@_N@Z 00b5 ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 55 56 57 48 81 EC 90 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 8B EA 48 8B F9 33 F6 89 70 08 48 85 C9 0F 84 8B 00 00 00 48 39 31 0F 85 82 00 00 00 8D 4E 30 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 C0 00 00 00 48 85 C0 74 55 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 BE 01 00 00 00 89 B4 24 B0 00 00 00 83 63 08 00 48 8D 0D ?? ?? ?? ?? 48 89 0B 44 8A C6 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 90 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 48 8B 9C 24 B8 00 00 00 48 81 C4 90 00 00 00 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_636_1 {
	meta:
		name = "?_Getcat@?$numpunct@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 209
		refs = "003b ??2@YAPEAX_K@Z 005b ??_C@_00CNPNBAHC@?$AA@ 0074 ??0_Locinfo@std@@QEAA@PEBD@Z 008c ??_7?$numpunct@G@std@@6B@ 009d ?_Init@?$numpunct@G@std@@IEAAXAEBV_Locinfo@2@_N@Z 00b5 ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 55 56 57 48 81 EC 90 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 8B EA 48 8B F9 33 F6 89 70 08 48 85 C9 0F 84 8B 00 00 00 48 39 31 0F 85 82 00 00 00 8D 4E 30 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 C0 00 00 00 48 85 C0 74 55 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 BE 01 00 00 00 89 B4 24 B0 00 00 00 83 63 08 00 48 8D 0D ?? ?? ?? ?? 48 89 0B 44 8A C6 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 90 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 48 8B 9C 24 B8 00 00 00 48 81 C4 90 00 00 00 5F 5E 5D C3 }
	condition:
		$1
}

rule file_41_640_1 {
	meta:
		name = "?_Getcat@?$numpunct@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z"
		size = 209
		refs = "003b ??2@YAPEAX_K@Z 005b ??_C@_00CNPNBAHC@?$AA@ 0074 ??0_Locinfo@std@@QEAA@PEBD@Z 008c ??_7?$numpunct@_W@std@@6B@ 009d ?_Init@?$numpunct@_W@std@@IEAAXAEBV_Locinfo@2@_N@Z 00b5 ??1_Locinfo@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 55 56 57 48 81 EC 90 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 10 48 8B EA 48 8B F9 33 F6 89 70 08 48 85 C9 0F 84 8B 00 00 00 48 39 31 0F 85 82 00 00 00 8D 4E 30 E8 ?? ?? ?? ?? 48 8B D8 48 89 84 24 C0 00 00 00 48 85 C0 74 55 48 8B 45 08 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 0D 48 8B 50 28 48 85 D2 75 04 48 8D 50 30 48 8D 4C 24 28 E8 ?? ?? ?? ?? 90 BE 01 00 00 00 89 B4 24 B0 00 00 00 83 63 08 00 48 8D 0D ?? ?? ?? ?? 48 89 0B 44 8A C6 48 8B D0 48 8B CB E8 ?? ?? ?? ?? 90 EB 02 33 DB 48 89 1F 40 F6 C6 01 74 0A 48 8D 4C 24 28 E8 ?? ?? ?? ?? B8 04 00 00 00 48 8B 9C 24 B8 00 00 00 48 81 C4 90 00 00 00 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_181_1 {
	meta:
		name = "?dtor$1@?0??_Getcat@?$numpunct@D@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
		size = 44
		refs = "0022 ??1_Locinfo@std@@QEAA@XZ"
		altNames = "?dtor$1@?0??_Getcat@?$moneypunct@D$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@D$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@G$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@G$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@_W$00@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$moneypunct@_W$0A@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$numpunct@G@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$numpunct@_W@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA ?dtor$1@?0??_Getcat@?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@SA_KPEAPEBVfacet@locale@2@PEBV42@@Z@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 85 B0 00 00 00 83 E0 01 85 C0 74 10 83 A5 B0 00 00 00 FE 48 8D 4D 28 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_24_187_1 {
	meta:
		name = "?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z"
		size = 2429
		refs = "0028 __security_cookie 006f ?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z 0080 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0089 ??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z 00a9 _guard_check_icall 00db ?grouping@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0100 ??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z 015d ?_Src@?1??_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB 0178 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 01d9 ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ 0260 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 0395 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 03aa _invalid_parameter_noinfo_noreturn 0453 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0465 ?_Deallocate@std@@YAXPEAX_K1@Z 0591 localeconv 095e __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 B1 48 81 EC F0 00 00 00 48 C7 45 8F FE FF FF FF 48 89 58 08 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 07 4D 8B F1 49 8B F0 4C 8B EA 48 89 55 87 48 8B 7D 77 48 8B 55 7F 48 89 54 24 48 8B 47 18 41 B8 00 30 00 00 41 23 C0 41 3B C0 75 1A 48 89 54 24 28 48 89 7C 24 20 4C 8B C6 49 8B D5 E8 ?? ?? ?? ?? E9 DE 08 00 00 48 8D 55 97 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 4C 8B E0 48 89 44 24 40 4C 8B 7D 9F 4D 85 FF 74 35 49 8B 17 48 8B 5A 10 48 8B CB E8 ?? ?? ?? ?? 49 8B CF FF D3 4C 8B F8 48 85 C0 74 19 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 49 8B CF FF D3 90 48 8D 55 CF 49 8B CC E8 ?? ?? ?? ?? 90 4D 8B FD C6 44 24 31 00 32 C0 89 44 24 38 48 8D 54 24 50 48 8B CF E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 4C 8B E0 48 8B 7C 24 58 48 85 FF 74 35 48 8B 17 48 8B 5A 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 49 8B 04 24 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 4C 8D 4D F7 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 49 8B CC FF D3 33 DB 38 5E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 41 38 5E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 48 39 1E 75 07 49 39 1E 74 49 EB 05 49 39 1E 75 42 38 5E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 02 75 07 41 C6 45 00 2B EB 1A 38 5E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 01 75 11 41 C6 45 00 2D 4D 8D 7D 01 48 8B CE E8 ?? ?? ?? ?? 4C 89 7C 24 50 41 C6 07 30 BA 01 00 00 00 4C 03 FA 88 5C 24 30 44 8B EB 8B FB 89 5C 24 34 8D 5A 23 B9 00 03 00 00 48 8B 44 24 48 81 38 00 CA 9A 3B 0F 44 D9 89 5C 24 3C 4C 8D 65 D7 48 83 7D EF 10 4C 0F 43 65 D7 41 8A 04 24 2A C2 3C 7D 0F 87 40 02 00 00 48 39 7D E7 74 21 48 8B 7C 24 40 48 8B 07 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 40 8A F8 BA 01 00 00 00 45 33 C0 48 8D 4D A7 E8 ?? ?? ?? ?? 90 33 DB 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 0C 49 83 3E 00 0F 84 21 01 00 00 EB 0A 49 83 3E 00 0F 85 15 01 00 00 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 F7 8A 4D F7 EB 0A 3A 4E 09 74 09 48 FF C0 8A 08 84 C9 75 F2 48 8D 4D F7 48 2B C1 48 83 F8 0A 73 6F BA 01 00 00 00 88 54 24 30 44 39 6C 24 3C 7F 11 01 54 24 34 48 85 C0 74 25 8A C2 89 44 24 38 EB 1D 48 85 C0 75 05 45 85 ED 74 13 48 8D 0D ?? ?? ?? ?? 8A 04 08 41 88 07 4C 03 FA 44 03 EA 48 3B 5D BF 0F 87 8F 00 00 00 48 8D 45 AF 48 83 7D C7 10 48 0F 43 45 AF 80 3C 18 7F 74 6E 48 8D 45 AF 48 83 7D C7 10 48 0F 43 45 AF 00 14 18 EB 5B 48 8B 55 BF 48 3B DA 77 65 48 8D 45 AF 4C 8B 45 AF 4C 8B 4D C7 49 83 F9 10 49 0F 43 C0 80 3C 18 00 74 5D 40 84 FF 74 58 80 7E 08 00 75 14 48 8B CE E8 ?? ?? ?? ?? 4C 8B 4D C7 48 8B 55 BF 4C 8B 45 AF 40 38 7E 09 75 38 45 33 C0 41 8D 50 01 48 8D 4D A7 E8 ?? ?? ?? ?? 48 FF C3 48 8B CE E8 ?? ?? ?? ?? E9 BE FE FF FF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 4C 8B 4D C7 48 8B 55 BF 4C 8B 45 AF 48 85 DB 74 27 48 3B DA 76 06 E8 ?? ?? ?? ?? CC 48 8D 45 AF 49 83 F9 10 49 0F 43 C0 BF 01 00 00 00 80 3C 18 00 7E 5B 48 03 DF EB 05 BF 01 00 00 00 48 85 DB 74 51 41 8A 0C 24 80 F9 7F 74 48 48 2B DF 74 16 48 3B DA 77 33 48 8D 45 AF 49 83 F9 10 49 0F 43 C0 3A 0C 18 75 28 48 85 DB 75 10 48 8D 45 AF 49 83 F9 10 49 0F 43 C0 3A 08 7C 13 41 80 7C 24 01 00 7E BA 49 FF C4 EB B5 E8 ?? ?? ?? ?? CC 40 88 7C 24 31 45 33 C0 40 8A D7 48 8D 4D A7 E8 ?? ?? ?? ?? 41 B8 10 00 00 00 48 8B D7 48 8B 4D A7 E8 ?? ?? ?? ?? 45 33 E4 E9 C1 00 00 00 45 33 E4 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 66 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 26 75 0B 4D 39 26 0F 84 90 00 00 00 EB 09 4D 39 26 0F 85 85 00 00 00 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 4D F7 8A 45 F7 EB 0A 3A 46 09 74 09 48 FF C1 8A 01 84 C0 75 F2 48 8D 45 F7 48 2B C8 48 83 F9 0A 73 53 41 3B DD 7F 14 BA 01 00 00 00 03 FA 48 85 C9 74 31 8A C2 89 44 24 38 EB 29 48 85 C9 75 05 45 85 ED 74 1A 48 8D 05 ?? ?? ?? ?? 8A 04 01 41 88 07 BA 01 00 00 00 4C 03 FA 44 03 EA EB 05 BA 01 00 00 00 88 54 24 30 48 8B CE E8 ?? ?? ?? ?? E9 46 FF FF FF 89 7C 24 34 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 66 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 26 75 07 4D 39 26 74 5D EB 05 4D 39 26 75 56 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 40 8A 7E 09 4C 8B 64 24 40 49 8B 04 24 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 49 8B CC FF D3 40 3A F8 75 22 E8 ?? ?? ?? ?? 48 8B 08 8A 01 41 88 07 BF 01 00 00 00 4C 03 FF 48 8B CE E8 ?? ?? ?? ?? 45 33 E4 EB 08 45 33 E4 BF 01 00 00 00 48 8B 44 24 48 81 38 00 CA 9A 3B 74 72 45 85 ED 75 6D 8B 5C 24 34 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 66 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 26 75 07 4D 39 26 74 2E EB 05 4D 39 26 75 27 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 F7 75 11 2B DF 40 88 7C 24 30 48 8B CE E8 ?? ?? ?? ?? EB AC 89 5C 24 34 85 DB 79 0D 41 C6 07 30 4C 03 FF 03 DF 89 5C 24 34 40 8A 7C 24 30 BB 01 00 00 00 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 66 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 26 75 07 4D 39 26 74 76 EB 05 4D 39 26 75 6F 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 4D F7 8A 45 F7 EB 0A 3A 46 09 74 09 48 03 CB 8A 01 84 C0 75 F2 48 8D 45 F7 48 2B C8 48 83 F9 0A 73 3D 44 3B 6C 24 3C 7D 15 48 8D 05 ?? ?? ?? ?? 8A 04 01 41 88 07 4C 03 FB 44 03 EB EB 11 8B 44 24 38 0F B6 C0 48 85 C9 0F 45 C3 89 44 24 38 40 8A FB 48 8B CE E8 ?? ?? ?? ?? E9 64 FF FF FF 8B 44 24 38 45 33 ED 84 C0 74 51 49 8D 5F FF 4C 8B 64 24 50 49 3B DC 74 27 E8 ?? ?? ?? ?? 8A 0B 48 8B 00 3A 08 74 08 80 F9 39 75 08 C6 03 30 48 FF CB EB E0 B8 01 00 00 00 00 03 49 3B DC 75 17 C6 03 31 44 8B 64 24 34 BB 01 00 00 00 44 03 E3 44 89 64 24 34 EB 0A BB 01 00 00 00 44 8B 64 24 34 40 84 FF 0F 84 D6 01 00 00 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 2E 75 0B 4D 39 2E 0F 84 AC 01 00 00 EB 09 4D 39 2E 0F 85 A1 01 00 00 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 04 74 1A 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 03 0F 85 71 01 00 00 41 C6 07 65 4C 03 FB 48 8B CE E8 ?? ?? ?? ?? 41 8A FD 41 8B DD 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 2E 75 07 4D 39 2E 74 48 EB 05 4D 39 2E 75 41 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 02 75 06 41 C6 07 2B EB 1A 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 01 75 0F 41 C6 07 2D 49 FF C7 48 8B CE E8 ?? ?? ?? ?? 41 BC 01 00 00 00 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 2E 75 07 4D 39 2E 74 2A EB 05 4D 39 2E 75 23 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 F7 75 0D 41 8A FC 48 8B CE E8 ?? ?? ?? ?? EB B0 40 84 FF 74 07 41 C6 07 30 49 FF C7 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 2E 75 07 4D 39 2E 74 61 EB 05 4D 39 2E 75 5A 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 F7 8A 4D F7 EB 0A 3A 4E 09 74 09 49 03 C4 8A 08 84 C9 75 F2 48 8D 4D F7 48 2B C1 48 83 F8 0A 73 28 83 FB 08 7D 13 48 8D 0D ?? ?? ?? ?? 8A 04 08 41 88 07 4D 03 FC 41 03 DC 41 8A FC 48 8B CE E8 ?? ?? ?? ?? E9 79 FF FF FF 44 8B 64 24 34 44 38 6C 24 31 75 05 40 84 FF 75 04 4C 8B 7D 87 45 88 2F 45 33 C0 41 8D 58 01 8A D3 48 8D 4D CF E8 ?? ?? ?? ?? 44 8D 43 0F 8B D3 48 8B 4D CF E8 ?? ?? ?? ?? 41 8B C4 48 8B 4D 07 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 30 01 00 00 48 81 C4 F0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_192_1 {
	meta:
		name = "?_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z"
		size = 2395
		refs = "0029 __security_cookie 0058 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0061 ??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z 0082 _guard_check_icall 00b4 ?grouping@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00ca ??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z 0128 ?_Src@?1??_Getffldx@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1AEAVios_base@3@PEAH@Z@4QBDB 014a ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 01ad ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ 02ec ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 0412 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 0427 _invalid_parameter_noinfo_noreturn 04c6 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 04d8 ?_Deallocate@std@@YAXPEAX_K1@Z 05f9 localeconv 093c __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 B1 48 81 EC F0 00 00 00 48 C7 44 24 48 FE FF FF FF 48 89 58 08 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 07 4D 8B F1 49 8B F0 4C 8B EA 48 89 54 24 40 4C 8B 7D 77 48 8B 45 7F 48 89 44 24 38 48 8D 54 24 50 49 8B CF E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 4C 8B E0 48 89 44 24 30 48 8B 7C 24 58 48 85 FF 74 35 48 8B 0F 48 8B 59 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 55 BF 49 8B CC E8 ?? ?? ?? ?? 90 48 8D 55 87 49 8B CF E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 4C 8B F8 48 8B 7D 8F 45 33 E4 48 85 FF 74 35 48 8B 17 48 8B 5A 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? 41 8D 54 24 01 48 8B CF FF D3 90 49 8B 07 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 4C 8D 4D E7 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 49 8B CF FF D3 4D 8B FD 44 88 64 24 21 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 66 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 26 75 07 4D 39 26 74 4B EB 05 4D 39 26 75 44 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 FE 75 07 41 C6 45 00 2B EB 1B 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 FD 75 11 41 C6 45 00 2D 4D 8D 7D 01 48 8B CE E8 ?? ?? ?? ?? 66 41 C7 07 30 78 49 83 C7 02 44 88 64 24 20 45 8B EC 41 8B FC 44 89 64 24 24 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 66 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 26 75 0B 4D 39 26 0F 84 91 00 00 00 EB 09 4D 39 26 0F 85 86 00 00 00 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 E7 75 70 48 8B CE E8 ?? ?? ?? ?? 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 66 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 26 75 07 4D 39 26 74 3D EB 05 4D 39 26 75 36 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 00 74 16 44 38 66 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 FF 75 0A 48 8B CE E8 ?? ?? ?? ?? EB 05 C6 44 24 20 01 BB 24 00 00 00 B9 00 03 00 00 48 8B 44 24 38 81 38 00 CA 9A 3B 0F 44 D9 89 5C 24 28 4C 8D 65 C7 48 83 7D DF 10 4C 0F 43 65 C7 41 8A 04 24 FE C8 3C 7D 0F 87 23 02 00 00 48 39 7D D7 74 1C 48 8B 7C 24 30 48 8B 07 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 40 8A F8 45 33 C0 41 8D 50 01 48 8D 4D 97 E8 ?? ?? ?? ?? 90 33 DB 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 0C 49 83 3E 00 0F 84 12 01 00 00 EB 0A 49 83 3E 00 0F 85 06 01 00 00 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 E7 8A 4D E7 EB 0A 3A 4E 09 74 09 48 FF C0 8A 08 84 C9 75 F2 48 8D 4D E7 48 2B C1 48 83 F8 16 73 60 C6 44 24 20 01 44 39 6C 24 28 7F 06 FF 44 24 24 EB 1D 48 85 C0 75 05 45 85 ED 74 13 48 8D 0D ?? ?? ?? ?? 8A 04 08 41 88 07 49 FF C7 41 FF C5 48 3B 5D AF 0F 87 8F 00 00 00 48 8D 45 9F 48 83 7D B7 10 48 0F 43 45 9F 80 3C 18 7F 74 6E 48 8D 45 9F 48 83 7D B7 10 48 0F 43 45 9F FE 04 18 EB 5B 48 8B 55 AF 48 3B DA 77 65 48 8D 45 9F 4C 8B 45 9F 4C 8B 4D B7 49 83 F9 10 49 0F 43 C0 80 3C 18 00 74 5D 40 84 FF 74 58 80 7E 08 00 75 14 48 8B CE E8 ?? ?? ?? ?? 4C 8B 4D B7 48 8B 55 AF 4C 8B 45 9F 40 38 7E 09 75 38 45 33 C0 41 8D 50 01 48 8D 4D 97 E8 ?? ?? ?? ?? 48 FF C3 48 8B CE E8 ?? ?? ?? ?? E9 CD FE FF FF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 4C 8B 4D B7 48 8B 55 AF 4C 8B 45 9F 48 85 DB 74 79 48 3B DA 76 06 E8 ?? ?? ?? ?? CC 48 8D 45 9F 49 83 F9 10 49 0F 43 C0 80 3C 18 00 7E 57 48 FF C3 48 85 DB 74 54 41 8A 0C 24 80 F9 7F 74 4B 48 83 EB 01 74 16 48 3B DA 77 35 48 8D 45 9F 49 83 F9 10 49 0F 43 C0 3A 0C 18 75 2A 48 85 DB 75 10 48 8D 45 9F 49 83 F9 10 49 0F 43 C0 3A 08 7C 15 49 8D 44 24 01 80 38 00 7E B7 4C 8B E0 EB B2 E8 ?? ?? ?? ?? CC C6 44 24 21 01 45 33 C0 B2 01 48 8D 4D 97 E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D 97 E8 ?? ?? ?? ?? E9 9F 00 00 00 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 08 49 83 3E 00 74 72 EB 06 49 83 3E 00 75 6A 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 4D E7 8A 45 E7 EB 0A 3A 46 09 74 09 48 FF C1 8A 01 84 C0 75 F2 48 8D 45 E7 48 2B C8 48 83 F9 16 73 38 41 3B DD 7F 04 FF C7 EB 1D 48 85 C9 75 05 45 85 ED 74 13 48 8D 05 ?? ?? ?? ?? 8A 04 01 41 88 07 49 FF C7 41 FF C5 C6 44 24 20 01 48 8B CE E8 ?? ?? ?? ?? E9 65 FF FF FF 89 7C 24 24 40 8A 7C 24 20 40 84 FF 74 0C 45 85 ED 75 07 41 C6 07 30 49 FF C7 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 08 49 83 3E 00 74 56 EB 06 49 83 3E 00 75 4E 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 40 8A 7E 09 4C 8B 64 24 30 49 8B 04 24 48 8B 58 18 48 8B CB E8 ?? ?? ?? ?? 49 8B CC FF D3 40 3A F8 75 18 E8 ?? ?? ?? ?? 48 8B 08 8A 01 41 88 07 49 FF C7 48 8B CE E8 ?? ?? ?? ?? 40 8A 7C 24 20 45 85 ED 75 75 44 8B 64 24 24 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 08 49 83 3E 00 74 2E EB 06 49 83 3E 00 75 26 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 E7 75 10 41 FF CC 40 B7 01 48 8B CE E8 ?? ?? ?? ?? EB A9 44 89 64 24 24 45 85 E4 79 0F 41 C6 07 30 49 FF C7 41 FF C4 44 89 64 24 24 4C 8D 25 ?? ?? ?? ?? 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 08 49 83 3E 00 74 5E EB 06 49 83 3E 00 75 56 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 4D E7 8A 45 E7 EB 0A 3A 46 09 74 09 48 FF C1 8A 01 84 C0 75 F2 48 8D 45 E7 48 2B C8 48 83 F9 16 73 24 44 3B 6C 24 28 7D 0D 42 8A 04 21 41 88 07 49 FF C7 41 FF C5 40 B7 01 48 8B CE E8 ?? ?? ?? ?? E9 79 FF FF FF 40 84 FF 44 8B 64 24 24 0F 84 CA 01 00 00 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 0C 49 83 3E 00 0F 84 9D 01 00 00 EB 0A 49 83 3E 00 0F 85 91 01 00 00 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 02 74 1A 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 01 0F 85 61 01 00 00 41 C6 07 70 49 FF C7 48 8B CE E8 ?? ?? ?? ?? 45 33 ED 41 8A FD 41 8B DD 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 2E 75 07 4D 39 2E 74 48 EB 05 4D 39 2E 75 41 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 FE 75 06 41 C6 07 2B EB 1A 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 FD 75 0F 41 C6 07 2D 49 FF C7 48 8B CE E8 ?? ?? ?? ?? 38 5E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 41 38 5E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 48 39 1E 75 07 49 39 1E 74 21 EB 05 49 39 1E 75 1A 38 5E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 E7 75 05 40 B7 01 EB B2 40 84 FF 74 07 41 C6 07 30 49 FF C7 4C 8D 25 ?? ?? ?? ?? 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 2E 75 07 4D 39 2E 74 57 EB 05 4D 39 2E 75 50 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 E7 8A 4D E7 EB 0A 3A 4E 09 74 09 48 FF C0 8A 08 84 C9 75 F2 48 8D 4D E7 48 2B C1 48 83 F8 16 73 1E 83 FB 08 7D 0C 42 8A 04 20 41 88 07 49 FF C7 FF C3 40 B7 01 48 8B CE E8 ?? ?? ?? ?? EB 83 44 8B 64 24 24 80 7C 24 21 00 75 05 40 84 FF 75 05 4C 8B 7C 24 40 41 C6 07 00 48 8B 44 24 38 44 89 20 45 33 C0 B2 01 48 8D 4D BF E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D BF E8 ?? ?? ?? ?? 33 C0 48 8B 4D 07 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 30 01 00 00 48 81 C4 F0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_197_1 {
	meta:
		name = "?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z"
		size = 1258
		refs = "0028 __security_cookie 0048 ??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z 0057 ?grouping@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0077 _guard_check_icall 0088 ??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z 00a5 ?_Src@?1??_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@3@1HAEBVlocale@3@@Z@4QBDB 00c2 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 0126 ?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ 027c ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 03a6 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 03bb _invalid_parameter_noinfo_noreturn 0486 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0497 ?_Deallocate@std@@YAXPEAX_K1@Z 04cb __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 B1 48 81 EC C0 00 00 00 48 C7 45 8F FE FF FF FF 48 89 58 08 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 07 4D 8B F1 49 8B F0 4C 8B E2 48 89 55 87 4C 8B 7D 7F 49 8B CF E8 ?? ?? ?? ?? 48 8B F8 48 8D 55 BF 48 8B C8 E8 ?? ?? ?? ?? 90 45 33 ED 4C 39 6D D7 75 07 44 88 6C 24 20 EB 18 48 8B 07 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 88 44 24 20 49 8B CF E8 ?? ?? ?? ?? 48 8B F8 48 8B 08 48 8B 59 38 48 8B CB E8 ?? ?? ?? ?? 4C 8D 4D E7 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CF FF D3 49 8B FC 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4C 39 2E 75 07 4D 39 2E 74 4C EB 05 4D 39 2E 75 45 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 FE 75 07 41 C6 04 24 2B EB 1B 44 38 6E 08 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 FD 75 12 41 C6 04 24 2D 49 8D 7C 24 01 48 8B CE E8 ?? ?? ?? ?? 8B 4D 77 81 E1 00 0E 00 00 8B C1 F7 D8 45 1B FF BB 0A 00 00 00 48 89 5C 24 28 44 23 FB 8D 43 06 81 F9 00 08 00 00 44 0F 44 F8 8D 43 FE 81 F9 00 04 00 00 44 0F 44 F8 32 C0 88 44 24 21 38 46 08 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 0C 49 83 3E 00 0F 84 BC 00 00 00 EB 0A 49 83 3E 00 0F 85 B0 00 00 00 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 E7 0F 85 96 00 00 00 41 B5 01 48 8B CE E8 ?? ?? ?? ?? 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 08 49 83 3E 00 74 54 EB 06 49 83 3E 00 75 4C 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 00 74 16 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 8A 46 09 3A 45 FF 75 20 41 F7 C7 EF FF FF FF 75 17 41 BF 10 00 00 00 45 32 ED 48 8B CE E8 ?? ?? ?? ?? 41 8D 4F F8 EB 1D 45 85 FF B9 08 00 00 00 44 0F 44 F9 EB 05 B9 08 00 00 00 45 85 FF 74 16 44 3B FB 74 11 B8 16 00 00 00 44 3B F9 48 0F 44 C1 48 89 44 24 28 45 8A C5 BA 01 00 00 00 48 8D 4D 97 E8 ?? ?? ?? ?? 90 33 DB 49 83 C4 1F 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 41 80 7E 08 00 75 08 49 8B CE E8 ?? ?? ?? ?? 48 83 3E 00 75 0C 49 83 3E 00 0F 84 12 01 00 00 EB 0A 49 83 3E 00 0F 85 06 01 00 00 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 48 8D 45 E7 8A 4D E7 EB 0A 3A 4E 09 74 09 48 FF C0 8A 08 84 C9 75 F2 48 8D 4D E7 48 2B C1 48 3B 44 24 28 73 59 48 8D 0D ?? ?? ?? ?? 8A 0C 08 88 0F 80 7C 24 21 00 75 05 80 F9 30 74 0D 49 3B FC 73 08 48 FF C7 C6 44 24 21 01 41 B5 01 48 3B 5D AF 0F 87 95 00 00 00 48 8D 45 9F 48 83 7D B7 10 48 0F 43 45 9F 80 3C 18 7F 74 74 48 8D 45 9F 48 83 7D B7 10 48 0F 43 45 9F FE 04 18 EB 61 4C 8B 55 AF 49 3B DA 77 6B 48 8D 45 9F 4C 8B 45 9F 4C 8B 4D B7 49 83 F9 10 49 0F 43 C0 80 3C 18 00 74 63 8A 44 24 20 84 C0 74 5B 80 7E 08 00 75 18 48 8B CE E8 ?? ?? ?? ?? 4C 8B 4D B7 4C 8B 55 AF 4C 8B 45 9F 8A 44 24 20 38 46 09 75 38 45 33 C0 41 8D 50 01 48 8D 4D 97 E8 ?? ?? ?? ?? 48 FF C3 48 8B CE E8 ?? ?? ?? ?? E9 CD FE FF FF E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC 4C 8B 4D B7 4C 8B 55 AF 4C 8B 45 9F 48 85 DB 74 2B 49 3B DA 76 06 E8 ?? ?? ?? ?? CC 48 8D 45 9F BE 10 00 00 00 4C 3B CE 49 0F 43 C0 80 3C 18 00 7E 05 48 FF C3 EB 0A 45 32 ED EB 05 BE 10 00 00 00 48 8D 4D C7 48 39 75 DF 48 0F 43 4D C7 45 84 ED 74 5C 48 85 DB 74 47 8A 11 80 FA 7F 74 40 48 83 EB 01 74 15 49 3B DA 77 2F 48 8D 45 9F 4C 3B CE 49 0F 43 C0 3A 14 18 75 35 48 85 DB 75 0F 48 8D 45 9F 4C 3B CE 49 0F 43 C0 3A 10 7C 21 80 79 01 00 7E BF 48 FF C1 EB BA E8 ?? ?? ?? ?? CC 8A 44 24 21 84 C0 75 0C C6 07 30 48 FF C7 EB 04 48 8B 7D 87 C6 07 00 45 33 C0 B2 01 48 8D 4D 97 E8 ?? ?? ?? ?? 4C 8B C6 BA 01 00 00 00 48 8B 4D 97 E8 ?? ?? ?? ?? 45 33 ED 4C 89 6D 97 45 33 C0 B2 01 48 8D 4D BF E8 ?? ?? ?? ?? 4C 8B C6 41 8D 55 01 48 8B 4D BF E8 ?? ?? ?? ?? 41 8B C7 48 8B 4D 07 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 00 01 00 00 48 81 C4 C0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_206_1 {
	meta:
		name = "?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z"
		size = 118
		altNames = "?_Ifmt@?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z ?_Ifmt@?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z"
	strings:
		$1 = { C6 02 25 48 8D 42 01 41 F6 C1 20 74 06 C6 00 2B 48 FF C0 41 F6 C1 08 74 06 C6 00 23 48 FF C0 41 8A 08 80 F9 4C 74 04 88 08 EB 0C 66 C7 00 49 36 48 83 C0 02 C6 00 34 41 8B C9 81 E1 00 0E 00 00 81 F9 00 04 00 00 75 05 41 B1 6F EB 1D 81 F9 00 08 00 00 74 06 45 8A 48 01 EB 0F 41 C0 E1 03 41 F6 D1 41 80 E1 20 41 80 C9 58 44 88 48 01 C6 40 02 00 48 8B C2 C3 }
	condition:
		$1
}

rule file_24_207_1 {
	meta:
		name = "?_Inc@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEAAXXZ"
		size = 130
		refs = "0056 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 31 48 8B F9 48 85 F6 74 50 48 8B 46 38 48 83 38 00 74 08 48 8B 46 50 8B 08 EB 02 33 C9 85 C9 7E 19 48 8B 46 50 FF 08 48 8B 4E 38 48 8B 11 48 8D 42 01 48 89 01 0F B6 02 EB 14 48 8B 06 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 48 8B CE FF D3 83 F8 FF 74 06 C6 47 08 00 EB 08 48 83 27 00 C6 47 08 01 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_213_1 {
	meta:
		name = "?_Init@?$numpunct@D@std@@IEAAXAEBV_Locinfo@2@_N@Z"
		size = 349
		refs = "002c localeconv 0039 _Getcvt 0052 ??_C@_00CNPNBAHC@?$AA@ 0083 calloc 0090 ?_Xbad_alloc@std@@YAXXZ 00b3 ??_C@_05LAPONLG@false?$AA@ 00ed ??_C@_04LOAJBDKD@true?$AA@"
	strings:
		$1 = { 48 8B C4 48 89 48 08 41 55 41 56 41 57 48 83 EC 60 48 C7 40 A8 FE FF FF FF 48 89 58 10 48 89 70 18 48 89 78 20 45 8A F8 48 8B D9 E8 ?? ?? ?? ?? 4C 8B F0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 83 63 10 00 48 83 63 20 00 48 83 63 28 00 45 84 FF 48 8D 35 ?? ?? ?? ?? 75 04 49 8B 76 10 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 83 CF FF 48 FF C7 80 3C 3E 00 75 F7 41 BD 01 00 00 00 49 03 FD 41 8B D5 48 8B CF E8 ?? ?? ?? ?? 48 8B D0 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 85 FF 74 13 48 8B CA 48 2B CE 8A 06 88 04 31 49 03 F5 49 2B FD 75 F3 48 89 53 10 48 8D 3D ?? ?? ?? ?? BE 06 00 00 00 49 8B D5 8B CE E8 ?? ?? ?? ?? 48 8B D0 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 8B CA 48 2B CF 8A 07 88 04 39 49 03 FD 49 2B F5 75 F3 48 89 53 20 48 8D 3D ?? ?? ?? ?? BE 05 00 00 00 49 8B D5 8B CE E8 ?? ?? ?? ?? 48 8B D0 48 85 C0 75 05 E8 ?? ?? ?? ?? 48 8B CA 48 2B CF 8A 07 88 04 39 49 03 FD 49 2B F5 75 F3 48 89 53 28 45 84 FF 74 08 66 C7 43 18 2E 2C EB 11 49 8B 06 8A 08 88 4B 18 49 8B 46 08 8A 08 88 4B 19 4C 8D 5C 24 60 49 8B 5B 28 49 8B 73 30 49 8B 7B 38 49 8B E3 41 5F 41 5E 41 5D C3 }
	condition:
		$1
}

rule file_24_215_1 {
	meta:
		name = "__catch$?_Init@?$numpunct@D@std@@IEAAXAEBV_Locinfo@2@_N@Z$0"
		size = 22
		refs = "0008 ?_Tidy@?$numpunct@D@std@@AEAAXXZ 0011 _CxxThrowException"
	strings:
		$1 = { 48 8B 8D 80 00 00 00 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_24_218_1 {
	meta:
		name = "?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z"
		size = 1193
		refs = "0028 __security_cookie 009e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 00a7 ??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z 00c4 _guard_check_icall 00f6 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 0146 ??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z 0193 ?grouping@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 01f1 ?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0D@Z 0261 ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z 03a7 _invalid_parameter_noinfo_noreturn 0446 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0457 ?_Deallocate@std@@YAXPEAX_K1@Z 048a __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8D 68 B9 48 81 EC C0 00 00 00 48 C7 45 AF FE FF FF FF 48 89 58 08 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 07 4C 89 4D 8F 4D 8B F8 48 89 55 97 8A 45 6F 88 44 24 20 4C 8B 6D 77 4C 8B 65 7F BE 01 00 00 00 4D 85 E4 74 0F 41 8A 45 00 2C 2B A8 FD 75 05 44 8B F6 EB 03 45 33 F6 41 8B 41 18 25 00 0E 00 00 3D 00 08 00 00 75 1D 49 8D 4E 02 49 3B CC 77 14 43 80 3C 2E 30 75 0D 43 8A 44 2E 01 2C 58 A8 DF 4C 0F 44 F1 48 8D 55 9F 49 8B C9 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 7D A7 48 85 FF 74 32 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 16 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? 8B D6 48 8B CF FF D3 90 45 33 C0 49 8B D4 48 8D 4D B7 E8 ?? ?? ?? ?? 90 48 8D 75 BF 48 83 7D D7 10 48 0F 43 75 BF 48 8B 44 24 30 48 8B 00 4B 8D 1C 2C 48 8B 78 38 48 8B CF E8 ?? ?? ?? ?? 4C 8B CE 4C 8B C3 49 8B D5 48 8B 4C 24 30 FF D7 48 8D 55 9F 4C 8B 6D 8F 49 8B CD E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 8B 7D A7 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 55 DF 48 8B CE E8 ?? ?? ?? ?? 90 48 8D 7D E7 48 83 7D FF 10 48 0F 43 7D E7 8A 07 FE C8 3C 7D 77 5A 48 8B 06 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 48 8B CE FF D3 8A D8 80 3F 7F 74 3F 80 3F 00 7E 3A 48 0F BE 0F 49 8B C4 49 2B C6 48 3B C8 73 2B 4C 2B E1 44 8A CB 41 B8 01 00 00 00 49 8B D4 48 8D 4D B7 E8 ?? ?? ?? ?? 48 8D 47 01 80 38 00 48 0F 4E C7 48 8B F8 80 38 7F 75 C1 48 8B 75 CF 49 8B 5D 28 48 85 DB 7E 0A 48 3B DE 76 05 48 2B DE EB 02 33 DB 41 8B 45 18 25 C0 01 00 00 41 0F 10 07 0F 29 44 24 30 83 F8 40 0F 84 15 01 00 00 3D 00 01 00 00 0F 84 84 00 00 00 48 85 DB 74 2E 48 8B 7D 87 44 8A 64 24 20 48 85 FF 74 10 41 8A D4 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 83 EB 01 75 E0 0F 28 44 24 30 F3 41 0F 7F 07 33 DB 0F 29 44 24 30 48 8D 7D BF 48 83 7D D7 10 48 0F 43 7D BF 4D 8B E6 4D 85 F6 0F 84 F6 00 00 00 4C 8B 6D 87 4D 85 ED 74 0F 8A 17 49 8B CD E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 FF C7 49 83 EC 01 75 DE E9 C2 00 00 00 48 8D 7D BF 48 83 7D D7 10 48 0F 43 7D BF 4D 8B E6 4D 85 F6 74 2F 4C 8B 6D 87 4D 85 ED 74 0F 8A 17 49 8B CD E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 FF C7 49 83 EC 01 75 DE 0F 28 44 24 30 4C 8B 6D 8F F3 41 0F 7F 07 0F 29 44 24 30 48 85 DB 74 2E 48 8B 7D 87 44 8A 64 24 20 48 85 FF 74 10 41 8A D4 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 83 EB 01 75 E0 0F 28 44 24 30 33 DB EB 45 48 8D 7D BF 48 83 7D D7 10 48 0F 43 7D BF 4D 8B E6 4D 85 F6 74 2F 4C 8B 6D 87 4D 85 ED 74 0F 8A 17 49 8B CD E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 FF C7 49 83 EC 01 75 DE 0F 28 44 24 30 4C 8B 6D 8F F3 41 0F 7F 07 0F 29 44 24 30 4C 3B 75 CF 76 06 E8 ?? ?? ?? ?? CC 48 8D 7D BF 41 BC 10 00 00 00 4C 39 65 D7 48 0F 43 7D BF 49 03 FE 49 2B F6 74 2B 4C 8B 75 87 4D 85 F6 74 0F 8A 17 49 8B CE E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 FF C7 48 83 EE 01 75 DE 0F 28 44 24 30 F3 41 0F 7F 07 49 83 65 28 00 41 0F 10 07 0F 29 44 24 30 48 85 DB 74 2A 48 8B 7D 87 48 85 FF 74 11 8A 54 24 20 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 75 05 C6 44 24 30 01 48 83 EB 01 75 DF 0F 28 44 24 30 48 8B 5D 97 F3 0F 7F 03 45 33 C0 B2 01 48 8D 4D DF E8 ?? ?? ?? ?? 4D 8B C4 BA 01 00 00 00 48 8B 4D DF E8 ?? ?? ?? ?? 48 83 65 DF 00 45 33 C0 B2 01 48 8D 4D B7 E8 ?? ?? ?? ?? 4D 8B C4 BA 01 00 00 00 48 8B 4D B7 E8 ?? ?? ?? ?? 48 8B C3 48 8B 4D 07 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 00 01 00 00 48 81 C4 C0 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_223_1 {
	meta:
		name = "?_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV123@PEAVfacet@23@_K@Z"
		size = 250
		refs = "002c ??0_Lockit@std@@QEAA@H@Z 0053 _realloc_base 005d ?_Xbad_alloc@std@@YAXXZ 008a _guard_check_icall 00e2 ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 57 41 56 41 57 48 83 EC 30 48 C7 40 D8 FE FF FF FF 48 89 58 10 48 89 70 18 49 8B F0 4C 8B FA 48 8B F9 33 D2 48 8D 48 08 E8 ?? ?? ?? ?? 90 48 39 77 18 77 48 48 8D 5E 01 B8 28 00 00 00 48 3B D8 48 0F 42 D8 48 8B D3 48 C1 E2 03 48 8B 4F 10 E8 ?? ?? ?? ?? 48 85 C0 75 06 E8 ?? ?? ?? ?? CC 48 89 47 10 EB 11 48 8B 4F 18 48 8B 47 10 48 83 24 C8 00 48 FF 47 18 48 39 5F 18 72 E9 49 8B 07 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 49 8B CF FF D3 48 8B 47 10 4C 8B 34 F0 4D 85 F6 74 34 49 8B 06 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 4C 8B F0 48 85 C0 74 18 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 49 8B CE FF D3 48 8B 47 10 4C 89 3C F0 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8B 5C 24 58 48 8B 74 24 60 48 83 C4 30 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_24_225_1 {
	meta:
		name = "?_Locimp_ctor@_Locimp@locale@std@@CAXPEAV123@AEBV123@@Z"
		size = 238
		refs = "0028 ?_Clocptr@_Locimp@locale@std@@0PEAV123@EA 0031 ??_C@_01GFHCPBMG@C?$AA@ 003b ??0_Locinfo@std@@QEAA@PEBD@Z 0050 ?_Makeloc@_Locimp@locale@std@@CAPEAV123@AEBV_Locinfo@3@HPEAV123@PEBV23@@Z 005b ??1_Locinfo@std@@QEAA@XZ 006c ??0_Lockit@std@@QEAA@H@Z 007f _malloc_base 008d ?_Xbad_alloc@std@@YAXXZ 00bb _guard_check_icall 00d2 ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 56 57 41 56 48 81 EC A0 00 00 00 48 C7 44 24 20 FE FF FF FF 48 89 58 08 48 89 68 18 48 8B EA 48 8B F1 48 3B 15 ?? ?? ?? ?? 75 33 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 45 33 C9 4C 8B C6 41 8D 51 3F 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? EB 75 33 D2 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 4E 18 48 85 C9 74 4F 48 C1 E1 03 E8 ?? ?? ?? ?? 48 89 46 10 48 85 C0 75 06 E8 ?? ?? ?? ?? CC 48 8B 7E 18 EB 2C 48 FF CF 48 8B 45 10 4C 8B 34 F8 48 8B 46 10 4C 89 34 F8 4D 85 F6 74 14 49 8B 06 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 48 85 FF 75 CF 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 4C 8D 9C 24 A0 00 00 00 49 8B 5B 20 49 8B 6B 30 49 8B E3 41 5E 5F 5E C3 }
	condition:
		$1
}

rule file_24_228_1 {
	meta:
		name = "?_Locinfo_Addcats@_Locinfo@std@@SAAEAV12@PEAV12@HPEBD@Z"
		size = 202
		refs = "0054 setlocale 0074 ??_C@_01NBENCBCI@?$CK?$AA@ 00a1 ??4?$_Yarn@D@std@@QEAAAEAV01@PEBD@Z 00c0 ??_C@_0BA@ELKIONDK@bad?5locale?5name?$AA@ 00c5 ?_Xruntime_error@std@@YAXPEBD@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 49 8B D8 8B F2 48 8B E9 4D 85 C0 0F 84 98 00 00 00 41 80 38 2A 75 07 41 80 78 01 00 74 3F 85 F6 75 04 33 D2 EB 28 83 FE 3F 74 20 33 FF 8B CF B8 01 00 00 00 D3 E0 D1 F8 85 C6 74 08 48 8B D3 E8 ?? ?? ?? ?? FF C7 83 FF 05 7E E2 48 8B D3 33 C9 E8 ?? ?? ?? ?? 48 8B D0 48 85 C0 75 09 48 8D 15 ?? ?? ?? ?? EB 22 48 8B 4D 58 48 85 C9 75 04 48 8D 4D 60 8A 01 3A 05 ?? ?? ?? ?? 75 0B 8A 41 01 3A 05 ?? ?? ?? ?? 74 09 48 8D 4D 58 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C5 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_24_229_1 {
	meta:
		name = "?_Locinfo_ctor@_Locinfo@std@@SAXPEAV12@HPEBD@Z"
		size = 86
		refs = "001c setlocale 0026 ??_C@_00CNPNBAHC@?$AA@ 0036 ??4?$_Yarn@D@std@@QEAAAEAV01@PEBD@Z 0052 ?_Locinfo_Addcats@_Locinfo@std@@SAAEAV12@PEAV12@HPEBD@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 8B FA 48 8B F1 33 D2 33 C9 49 8B D8 E8 ?? ?? ?? ?? 48 85 C0 48 8D 0D ?? ?? ?? ?? 48 0F 44 C1 48 8D 4E 48 48 8B D0 E8 ?? ?? ?? ?? 4C 8B C3 8B D7 48 8B CE 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_230_1 {
	meta:
		name = "?_Makeloc@_Locimp@locale@std@@CAPEAV123@AEBV_Locinfo@3@HPEAV123@PEBV23@@Z"
		size = 1330
		refs = "004f ??2@YAPEAX_K@Z 0066 ??_7?$ctype@D@std@@6B@ 0072 _Getctype 008d ?id@?$ctype@D@std@@2V0locale@2@A 009d ??0_Lockit@std@@QEAA@H@Z 00ac ?_Id_cnt@id@locale@std@@0HA 00c6 ??1_Lockit@std@@QEAA@XZ 0121 ??$use_facet@V?$ctype@D@std@@@std@@YAAEBV?$ctype@D@0@AEBVlocale@0@@Z 012f ?_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV123@PEAVfacet@23@_K@Z 0163 ??_7?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 0171 ?id@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 01de ??_7?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@6B@ 01ec ?id@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@2V0locale@2@A 0284 ??$use_facet@V?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z 02e1 ??$use_facet@V?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@@std@@YAAEBV?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@0@AEBVlocale@0@@Z 0323 ??_7?$numpunct@D@std@@6B@ 0334 ?_Init@?$numpunct@D@std@@IEAAXAEBV_Locinfo@2@_N@Z 0341 ?id@?$numpunct@D@std@@2V0locale@2@A 03dd ??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z 0415 ??_7?$codecvt@DDU_Mbstatet@@@std@@6B@ 0424 ?id@?$codecvt@DDU_Mbstatet@@@std@@2V0locale@2@A 04b8 ??$use_facet@V?$codecvt@DDU_Mbstatet@@@std@@@std@@YAAEBV?$codecvt@DDU_Mbstatet@@@0@AEBVlocale@0@@Z 04d7 ?_Makexloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z 04e8 ?_Makewloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z 04f9 ?_Makeushloc@_Locimp@locale@std@@CAXAEBV_Locinfo@3@HPEAV123@PEBV23@@Z 0513 ??4?$_Yarn@D@std@@QEAAAEAV01@PEBD@Z"
	strings:
		$1 = { 48 8B C4 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 50 48 C7 45 D0 FE FF FF FF 48 89 58 18 49 8B F1 49 8B F8 44 8B E2 4C 8B E9 45 33 F6 44 89 75 48 44 8B FA 41 83 E7 02 0F 84 F2 00 00 00 4D 85 C9 0F 85 8C 00 00 00 41 8D 49 30 E8 ?? ?? ?? ?? 48 8B D8 48 89 45 40 48 85 C0 74 28 44 89 70 08 48 8D 05 ?? ?? ?? ?? 48 89 03 48 8D 4D D8 E8 ?? ?? ?? ?? 0F 10 00 0F 11 43 10 0F 10 48 10 0F 11 4B 20 EB 03 49 8B DE 4C 8B 05 ?? ?? ?? ?? 4D 85 C0 75 3B 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 39 35 ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8B D3 EB 55 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3B 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 39 35 ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 4C 8B C3 48 8B D0 48 8B CF E8 ?? ?? ?? ?? 45 8B F4 41 83 E6 08 0F 84 B3 01 00 00 48 85 F6 0F 85 F0 00 00 00 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 45 40 48 85 C0 74 0F 21 70 08 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 4C 8B 05 ?? ?? ?? ?? 4D 85 C0 75 3C 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8B D3 48 8B CF E8 ?? ?? ?? ?? B9 10 00 00 00 E8 ?? ?? ?? ?? 48 8B D8 48 89 45 40 48 85 C0 74 10 83 60 08 00 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 02 33 DB 4C 8B 05 ?? ?? ?? ?? 4D 85 C0 75 3C 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8B D3 E9 B2 00 00 00 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3B 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 4C 8B C3 48 8B D0 48 8B CF E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3B 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 48 39 1D ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 4C 8B C3 48 8B D0 48 8B CF E8 ?? ?? ?? ?? 45 85 F6 0F 84 ED 00 00 00 45 33 F6 48 85 F6 0F 85 8A 00 00 00 8D 4E 30 E8 ?? ?? ?? ?? 48 8B D8 48 89 45 40 48 85 C0 74 1F 44 89 70 08 48 8D 05 ?? ?? ?? ?? 48 89 03 45 33 C0 49 8B D5 48 8B CB E8 ?? ?? ?? ?? 90 EB 03 49 8B DE 4C 8B 05 ?? ?? ?? ?? 4D 85 C0 75 3B 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 39 35 ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8B D3 48 8B CF E8 ?? ?? ?? ?? EB 5A 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3B 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 39 35 ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 4C 8B C3 48 8B D0 EB 9F 45 33 F6 45 85 FF 0F 84 D5 00 00 00 48 85 F6 75 73 8D 4E 10 E8 ?? ?? ?? ?? 48 8B D8 48 89 45 40 48 85 C0 74 10 44 89 70 08 48 8D 05 ?? ?? ?? ?? 48 89 03 EB 03 49 8B DE 4C 8B 05 ?? ?? ?? ?? 4D 85 C0 75 3B 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 39 35 ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 8B 05 ?? ?? ?? ?? 48 8B D3 EB 55 48 8B 1D ?? ?? ?? ?? 48 85 DB 75 3B 33 D2 48 8D 4D 48 E8 ?? ?? ?? ?? 4C 39 35 ?? ?? ?? ?? 75 17 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 98 48 89 05 ?? ?? ?? ?? 48 8D 4D 48 E8 ?? ?? ?? ?? 48 8B 1D ?? ?? ?? ?? 48 8B CE E8 ?? ?? ?? ?? 4C 8B C3 48 8B D0 48 8B CF E8 ?? ?? ?? ?? 4C 8B CE 4C 8B C7 41 8B D4 49 8B CD E8 ?? ?? ?? ?? 4C 8B CE 4C 8B C7 41 8B D4 49 8B CD E8 ?? ?? ?? ?? 4C 8B CE 4C 8B C7 41 8B D4 49 8B CD E8 ?? ?? ?? ?? 44 09 67 20 49 8B 55 58 48 85 D2 75 04 49 8D 55 60 48 8D 4F 28 E8 ?? ?? ?? ?? 48 8B C7 48 8B 9C 24 A0 00 00 00 48 83 C4 50 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_24_231_1 {
	meta:
		name = "?dtor$3@?0??_Makeloc@_Locimp@locale@std@@CAPEAV123@AEBV_Locinfo@3@HPEAV123@PEBV23@@Z@4HA"
		size = 32
		refs = "0016 ??3@YAXPEAX_K@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA BA 30 00 00 00 48 8B 8D 90 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_24_243_1 {
	meta:
		name = "?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ"
		size = 114
		refs = "0044 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 31 48 8B F9 48 85 F6 74 3D 48 8B 46 38 48 8B 10 48 85 D2 74 08 48 8B 46 50 8B 08 EB 02 33 C9 85 C9 7E 05 0F B6 02 EB 14 48 8B 06 48 8B 58 30 48 8B CB E8 ?? ?? ?? ?? 48 8B CE FF D3 83 F8 FF 74 05 88 47 09 EB 04 48 83 27 00 8A 47 09 48 8B 5C 24 30 48 8B 74 24 38 C6 47 08 01 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_246_1 {
	meta:
		name = "?_Put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@PEBD_K@Z"
		size = 104
		refs = "0033 ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 5C 24 50 49 8B F1 49 8B F8 48 8B EA 48 85 DB 74 21 48 8B 4F 08 48 85 C9 74 0C 8A 16 E8 ?? ?? ?? ?? 83 F8 FF 75 03 C6 07 01 48 FF C6 48 83 EB 01 75 DF 0F 10 07 48 8B 5C 24 30 48 8B C5 48 8B 74 24 40 F3 0F 7F 45 00 48 8B 6C 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_247_1 {
	meta:
		name = "?_Rep@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@D_K@Z"
		size = 101
		refs = "0034 ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 7C 24 50 41 8A E9 49 8B D8 48 8B F2 48 85 FF 74 1F 48 8B 4B 08 48 85 C9 74 0D 40 8A D5 E8 ?? ?? ?? ?? 83 F8 FF 75 03 C6 03 01 48 83 EF 01 75 E1 0F 10 03 48 8B 5C 24 30 48 8B C6 48 8B 6C 24 38 F3 0F 7F 06 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_248_1 {
	meta:
		name = "?_Stodx_v2@std@@YANPEBDPEAPEADHPEAH@Z"
		size = 138
		refs = "0029 _errno 003c strtod 0054 __real@4024000000000000 0061 pow"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 41 56 41 57 48 83 EC 30 0F 29 70 D8 4D 8B F9 41 8B E8 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 8B D3 48 8B CF 4C 8B F0 8B 30 83 20 00 E8 ?? ?? ?? ?? 41 8B 0E 0F 28 F0 41 89 0F 41 89 36 85 ED 74 19 F2 0F 10 05 ?? ?? ?? ?? 66 0F 6E CD F3 0F E6 C9 E8 ?? ?? ?? ?? F2 0F 59 F0 48 8B 5C 24 50 0F 28 C6 0F 28 74 24 20 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 30 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_24_249_1 {
	meta:
		name = "?_Stofx_v2@std@@YAMPEBDPEAPEADHPEAH@Z"
		size = 137
		refs = "0029 _errno 003c strtof 0054 __real@41200000 0060 powf"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 57 41 56 41 57 48 83 EC 30 0F 29 70 D8 4D 8B F9 41 8B E8 48 8B DA 48 8B F9 E8 ?? ?? ?? ?? 48 8B D3 48 8B CF 4C 8B F0 8B 30 83 20 00 E8 ?? ?? ?? ?? 41 8B 0E 0F 28 F0 41 89 0F 41 89 36 85 ED 74 18 F3 0F 10 05 ?? ?? ?? ?? 66 0F 6E CD 0F 5B C9 E8 ?? ?? ?? ?? F3 0F 59 F0 48 8B 5C 24 50 0F 28 C6 0F 28 74 24 20 48 8B 6C 24 58 48 8B 74 24 60 48 83 C4 30 41 5F 41 5E 5F C3 }
	condition:
		$1
}

rule file_24_254_1 {
	meta:
		name = "?_Tidy@?$numpunct@D@std@@AEAAXXZ"
		size = 41
		refs = "000e free"
		altNames = "?_Tidy@?$numpunct@G@std@@AEAAXXZ ?_Tidy@?$numpunct@_W@std@@AEAAXXZ"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 48 8B 49 10 E8 ?? ?? ?? ?? 48 8B 4B 20 E8 ?? ?? ?? ?? 48 8B 4B 28 48 83 C4 20 5B E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_265_1 {
	meta:
		name = "?assign@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@$$QEAV12@@Z"
		size = 68
		refs = "0025 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0031 ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX$$QEAV12@@Z"
		altNames = "??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@$$QEAV01@@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B FA 48 8B D9 48 3B CA 74 17 45 33 C0 B2 01 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_41_400_1 {
	meta:
		name = "??4?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV01@$$QEAV01@@Z"
		size = 68
		refs = "0025 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 0031 ?_Assign_rv@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX$$QEAV12@@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B FA 48 8B D9 48 3B CA 74 17 45 33 C0 B2 01 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_41_402_1 {
	meta:
		name = "??4?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV01@$$QEAV01@@Z"
		size = 68
		refs = "0025 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 0031 ?_Assign_rv@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX$$QEAV12@@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B FA 48 8B D9 48 3B CA 74 17 45 33 C0 B2 01 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_41_912_1 {
	meta:
		name = "?assign@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAAEAV12@$$QEAV12@@Z"
		size = 68
		refs = "0025 ?_Tidy@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_N_K@Z 0031 ?_Assign_rv@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX$$QEAV12@@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B FA 48 8B D9 48 3B CA 74 17 45 33 C0 B2 01 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_41_918_1 {
	meta:
		name = "?assign@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAAEAV12@$$QEAV12@@Z"
		size = 68
		refs = "0025 ?_Tidy@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_N_K@Z 0031 ?_Assign_rv@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX$$QEAV12@@Z"
	strings:
		$1 = { 40 57 48 83 EC 30 48 C7 44 24 20 FE FF FF FF 48 89 5C 24 40 48 8B FA 48 8B D9 48 3B CA 74 17 45 33 C0 B2 01 E8 ?? ?? ?? ?? 90 48 8B D7 48 8B CB E8 ?? ?? ?? ?? 90 48 8B C3 48 8B 5C 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_24_286_1 {
	meta:
		name = "?do_falsename@?$numpunct@D@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z"
		altNames = "?do_curr_symbol@?$_Mpunct@D@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 20 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_963_1 {
	meta:
		name = "?do_curr_symbol@?$_Mpunct@G@std@@MEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 20 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_964_1 {
	meta:
		name = "?do_curr_symbol@?$_Mpunct@_W@std@@MEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 20 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_974_1 {
	meta:
		name = "?do_falsename@?$numpunct@G@std@@MEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 20 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_975_1 {
	meta:
		name = "?do_falsename@?$numpunct@_W@std@@MEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 20 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_24_287_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"
		size = 368
		refs = "0024 __security_cookie 0057 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0078 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z 0093 _guard_check_icall 00dc _Stoulx 00ef ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 0158 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F9 48 81 EC 98 00 00 00 48 C7 45 B7 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 EF 4D 8B F1 4D 8B F8 4C 8B E2 48 8B F9 48 8B 5D 6F 48 8B 75 77 48 8B 45 7F 48 89 45 AF 83 65 9F 00 48 8D 55 BF 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4D 8B CE 4D 8B C7 48 8D 55 CF 48 8B CF E8 ?? ?? ?? ?? 44 8B E8 48 8B 7D C7 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 7D D0 48 8D 45 CF 80 7D CF 2D 48 0F 45 F8 4C 8D 4D 9F 45 8B C5 48 8D 55 A7 48 8B CF E8 ?? ?? ?? ?? 8B D8 45 33 ED 45 38 6F 08 75 08 49 8B CF E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4D 39 2F 75 07 4D 39 2E 74 07 EB 08 4D 39 2E 74 03 83 0E 01 48 39 7D A7 74 25 44 39 6D 9F 75 1F 81 FB FF FF 00 00 77 17 0F B7 C3 66 F7 D8 80 7D CF 2D 66 0F 44 D8 48 8B 45 AF 66 89 18 EB 03 83 0E 02 41 0F 10 07 F3 41 0F 7F 04 24 49 8B C4 48 8B 4D EF 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_988_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"
		size = 368
		refs = "0024 __security_cookie 0057 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0078 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z 0093 _guard_check_icall 00dc _Stoulx 00ef ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 0158 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F9 48 81 EC 98 00 00 00 48 C7 45 B7 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 EF 4D 8B F1 4D 8B F8 4C 8B E2 48 8B F9 48 8B 5D 6F 48 8B 75 77 48 8B 45 7F 48 89 45 AF 83 65 9F 00 48 8D 55 BF 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4D 8B CE 4D 8B C7 48 8D 55 CF 48 8B CF E8 ?? ?? ?? ?? 44 8B E8 48 8B 7D C7 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 7D D0 48 8D 45 CF 80 7D CF 2D 48 0F 45 F8 4C 8D 4D 9F 45 8B C5 48 8D 55 A7 48 8B CF E8 ?? ?? ?? ?? 8B D8 45 33 ED 45 38 6F 08 75 08 49 8B CF E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4D 39 2F 75 07 4D 39 2E 74 07 EB 08 4D 39 2E 74 03 83 0E 01 48 39 7D A7 74 25 44 39 6D 9F 75 1F 81 FB FF FF 00 00 77 17 0F B7 C3 66 F7 D8 80 7D CF 2D 66 0F 44 D8 48 8B 45 AF 66 89 18 EB 03 83 0E 02 41 0F 10 07 F3 41 0F 7F 04 24 49 8B C4 48 8B 4D EF 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_1011_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAG@Z"
		size = 368
		refs = "0024 __security_cookie 0057 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0078 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z 0093 _guard_check_icall 00dc _Stoulx 00ef ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 0158 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F9 48 81 EC 98 00 00 00 48 C7 45 B7 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 EF 4D 8B F1 4D 8B F8 4C 8B E2 48 8B F9 48 8B 5D 6F 48 8B 75 77 48 8B 45 7F 48 89 45 AF 83 65 9F 00 48 8D 55 BF 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4D 8B CE 4D 8B C7 48 8D 55 CF 48 8B CF E8 ?? ?? ?? ?? 44 8B E8 48 8B 7D C7 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 7D D0 48 8D 45 CF 80 7D CF 2D 48 0F 45 F8 4C 8D 4D 9F 45 8B C5 48 8D 55 A7 48 8B CF E8 ?? ?? ?? ?? 8B D8 45 33 ED 45 38 6F 08 75 08 49 8B CF E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4D 39 2F 75 07 4D 39 2E 74 07 EB 08 4D 39 2E 74 03 83 0E 01 48 39 7D A7 74 25 44 39 6D 9F 75 1F 81 FB FF FF 00 00 77 17 0F B7 C3 66 F7 D8 80 7D CF 2D 66 0F 44 D8 48 8B 45 AF 66 89 18 EB 03 83 0E 02 41 0F 10 07 F3 41 0F 7F 04 24 49 8B C4 48 8B 4D EF 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_24_289_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"
		size = 356
		refs = "0024 __security_cookie 0057 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0078 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z 0093 _guard_check_icall 00dc _Stoulx 00ef ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 014c __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F9 48 81 EC 98 00 00 00 48 C7 45 B7 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 EF 4D 8B F1 4D 8B F8 4C 8B E2 48 8B F9 48 8B 5D 6F 48 8B 75 77 48 8B 45 7F 48 89 45 AF 83 65 9F 00 48 8D 55 BF 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4D 8B CE 4D 8B C7 48 8D 55 CF 48 8B CF E8 ?? ?? ?? ?? 44 8B E8 48 8B 7D C7 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 7D D0 48 8D 45 CF 80 7D CF 2D 48 0F 45 F8 4C 8D 4D 9F 45 8B C5 48 8D 55 A7 48 8B CF E8 ?? ?? ?? ?? 8B D8 45 33 ED 45 38 6F 08 75 08 49 8B CF E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4D 39 2F 75 07 4D 39 2E 74 07 EB 08 4D 39 2E 74 03 83 0E 01 48 39 7D A7 74 19 44 39 6D 9F 75 13 8B C3 F7 D8 80 7D CF 2D 0F 44 D8 48 8B 45 AF 89 18 EB 03 83 0E 02 41 0F 10 07 F3 41 0F 7F 04 24 49 8B C4 48 8B 4D EF 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_990_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"
		size = 356
		refs = "0024 __security_cookie 0057 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0078 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z 0093 _guard_check_icall 00dc _Stoulx 00ef ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 014c __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F9 48 81 EC 98 00 00 00 48 C7 45 B7 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 EF 4D 8B F1 4D 8B F8 4C 8B E2 48 8B F9 48 8B 5D 6F 48 8B 75 77 48 8B 45 7F 48 89 45 AF 83 65 9F 00 48 8D 55 BF 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4D 8B CE 4D 8B C7 48 8D 55 CF 48 8B CF E8 ?? ?? ?? ?? 44 8B E8 48 8B 7D C7 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 7D D0 48 8D 45 CF 80 7D CF 2D 48 0F 45 F8 4C 8D 4D 9F 45 8B C5 48 8D 55 A7 48 8B CF E8 ?? ?? ?? ?? 8B D8 45 33 ED 45 38 6F 08 75 08 49 8B CF E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4D 39 2F 75 07 4D 39 2E 74 07 EB 08 4D 39 2E 74 03 83 0E 01 48 39 7D A7 74 19 44 39 6D 9F 75 13 8B C3 F7 D8 80 7D CF 2D 0F 44 D8 48 8B 45 AF 89 18 EB 03 83 0E 02 41 0F 10 07 F3 41 0F 7F 04 24 49 8B C4 48 8B 4D EF 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_1013_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAI@Z"
		size = 356
		refs = "0024 __security_cookie 0057 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0078 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z 0093 _guard_check_icall 00dc _Stoulx 00ef ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 014c __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F9 48 81 EC 98 00 00 00 48 C7 45 B7 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 EF 4D 8B F1 4D 8B F8 4C 8B E2 48 8B F9 48 8B 5D 6F 48 8B 75 77 48 8B 45 7F 48 89 45 AF 83 65 9F 00 48 8D 55 BF 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4D 8B CE 4D 8B C7 48 8D 55 CF 48 8B CF E8 ?? ?? ?? ?? 44 8B E8 48 8B 7D C7 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 7D D0 48 8D 45 CF 80 7D CF 2D 48 0F 45 F8 4C 8D 4D 9F 45 8B C5 48 8D 55 A7 48 8B CF E8 ?? ?? ?? ?? 8B D8 45 33 ED 45 38 6F 08 75 08 49 8B CF E8 ?? ?? ?? ?? 45 38 6E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 4D 39 2F 75 07 4D 39 2E 74 07 EB 08 4D 39 2E 74 03 83 0E 01 48 39 7D A7 74 19 44 39 6D 9F 75 13 8B C3 F7 D8 80 7D CF 2D 0F 44 D8 48 8B 45 AF 89 18 EB 03 83 0E 02 41 0F 10 07 F3 41 0F 7F 04 24 49 8B C4 48 8B 4D EF 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_24_291_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z 0097 _Stolx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 44 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 45 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_24_293_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z 0097 _Stoulx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 44 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 45 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_992_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z 0097 _Stolx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 44 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 45 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_994_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z 0097 _Stoulx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 44 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 45 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_1015_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAJ@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z 0097 _Stolx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 44 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 45 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_1017_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAK@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z 0097 _Stoulx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 44 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 45 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_24_295_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"
		size = 308
		refs = "0020 __security_cookie 006e ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z 0085 ?_Stofx_v2@std@@YAMPEBDPEAPEADHPEAH@Z 00a7 ldexp 00bc ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 0118 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 41 57 48 8D A8 48 FD FF FF 48 81 EC 88 03 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 48 8B 85 E0 02 00 00 4C 8B F2 48 8B 9D E8 02 00 00 48 8D 54 24 30 4C 8B BD F0 02 00 00 49 8B F9 83 64 24 34 00 49 8B F0 48 89 54 24 28 48 8D 54 24 40 C7 44 24 30 00 CA 9A 3B 48 89 44 24 20 E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 34 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 30 0F 28 F0 81 FA 00 CA 9A 3B 74 1A 85 D2 74 16 0F 57 C0 C1 E2 02 F3 0F 5A C6 E8 ?? ?? ?? ?? 0F 57 F6 F2 0F 5A F0 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 80 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 48 83 3E 00 75 08 48 83 3F 00 74 08 EB 09 48 83 3F 00 74 03 83 0B 01 48 8D 44 24 40 48 39 44 24 38 74 0E 83 7C 24 34 00 75 07 F3 41 0F 11 37 EB 03 83 0B 02 0F 10 06 49 8B C6 F3 41 0F 7F 06 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 70 03 00 00 48 81 C4 88 03 00 00 41 5F 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_996_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"
		size = 308
		refs = "0020 __security_cookie 006e ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z 0085 ?_Stofx_v2@std@@YAMPEBDPEAPEADHPEAH@Z 00a7 ldexp 00bc ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 0118 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 41 57 48 8D A8 48 FD FF FF 48 81 EC 88 03 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 48 8B 85 E0 02 00 00 4C 8B F2 48 8B 9D E8 02 00 00 48 8D 54 24 30 4C 8B BD F0 02 00 00 49 8B F9 83 64 24 34 00 49 8B F0 48 89 54 24 28 48 8D 54 24 40 C7 44 24 30 00 CA 9A 3B 48 89 44 24 20 E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 34 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 30 0F 28 F0 81 FA 00 CA 9A 3B 74 1A 85 D2 74 16 0F 57 C0 C1 E2 02 F3 0F 5A C6 E8 ?? ?? ?? ?? 0F 57 F6 F2 0F 5A F0 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 80 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 48 83 3E 00 75 08 48 83 3F 00 74 08 EB 09 48 83 3F 00 74 03 83 0B 01 48 8D 44 24 40 48 39 44 24 38 74 0E 83 7C 24 34 00 75 07 F3 41 0F 11 37 EB 03 83 0B 02 0F 10 06 49 8B C6 F3 41 0F 7F 06 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 70 03 00 00 48 81 C4 88 03 00 00 41 5F 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_1019_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAM@Z"
		size = 308
		refs = "0020 __security_cookie 006e ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z 0085 ?_Stofx_v2@std@@YAMPEBDPEAPEADHPEAH@Z 00a7 ldexp 00bc ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 0118 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 41 57 48 8D A8 48 FD FF FF 48 81 EC 88 03 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 48 8B 85 E0 02 00 00 4C 8B F2 48 8B 9D E8 02 00 00 48 8D 54 24 30 4C 8B BD F0 02 00 00 49 8B F9 83 64 24 34 00 49 8B F0 48 89 54 24 28 48 8D 54 24 40 C7 44 24 30 00 CA 9A 3B 48 89 44 24 20 E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 34 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 30 0F 28 F0 81 FA 00 CA 9A 3B 74 1A 85 D2 74 16 0F 57 C0 C1 E2 02 F3 0F 5A C6 E8 ?? ?? ?? ?? 0F 57 F6 F2 0F 5A F0 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 80 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 48 83 3E 00 75 08 48 83 3F 00 74 08 EB 09 48 83 3F 00 74 03 83 0B 01 48 8D 44 24 40 48 39 44 24 38 74 0E 83 7C 24 34 00 75 07 F3 41 0F 11 37 EB 03 83 0B 02 0F 10 06 49 8B C6 F3 41 0F 7F 06 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 70 03 00 00 48 81 C4 88 03 00 00 41 5F 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_24_296_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"
		size = 297
		refs = "0020 __security_cookie 006e ?_Getffld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1AEAVios_base@2@PEAH@Z 0085 ?_Stodx_v2@std@@YANPEBDPEAPEADHPEAH@Z 00a0 ldexp 00b1 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 010d __security_check_cookie"
		altNames = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 41 57 48 8D A8 48 FD FF FF 48 81 EC 88 03 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 48 8B 85 E0 02 00 00 4C 8B F2 48 8B 9D E8 02 00 00 48 8D 54 24 30 4C 8B BD F0 02 00 00 49 8B F9 83 64 24 34 00 49 8B F0 48 89 54 24 28 48 8D 54 24 40 C7 44 24 30 00 CA 9A 3B 48 89 44 24 20 E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 34 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 30 0F 28 F0 81 FA 00 CA 9A 3B 74 0F 85 D2 74 0B C1 E2 02 E8 ?? ?? ?? ?? 0F 28 F0 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 80 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 48 83 3E 00 75 08 48 83 3F 00 74 08 EB 09 48 83 3F 00 74 03 83 0B 01 48 8D 44 24 40 48 39 44 24 38 74 0E 83 7C 24 34 00 75 07 F2 41 0F 11 37 EB 03 83 0B 02 0F 10 06 49 8B C6 F3 41 0F 7F 06 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 70 03 00 00 48 81 C4 88 03 00 00 41 5F 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_997_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"
		size = 297
		refs = "0020 __security_cookie 006e ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z 0085 ?_Stodx_v2@std@@YANPEBDPEAPEADHPEAH@Z 00a0 ldexp 00b1 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 010d __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 41 57 48 8D A8 48 FD FF FF 48 81 EC 88 03 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 48 8B 85 E0 02 00 00 4C 8B F2 48 8B 9D E8 02 00 00 48 8D 54 24 30 4C 8B BD F0 02 00 00 49 8B F9 83 64 24 34 00 49 8B F0 48 89 54 24 28 48 8D 54 24 40 C7 44 24 30 00 CA 9A 3B 48 89 44 24 20 E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 34 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 30 0F 28 F0 81 FA 00 CA 9A 3B 74 0F 85 D2 74 0B C1 E2 02 E8 ?? ?? ?? ?? 0F 28 F0 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 80 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 48 83 3E 00 75 08 48 83 3F 00 74 08 EB 09 48 83 3F 00 74 03 83 0B 01 48 8D 44 24 40 48 39 44 24 38 74 0E 83 7C 24 34 00 75 07 F2 41 0F 11 37 EB 03 83 0B 02 0F 10 06 49 8B C6 F3 41 0F 7F 06 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 70 03 00 00 48 81 C4 88 03 00 00 41 5F 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_998_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"
		size = 297
		refs = "0020 __security_cookie 006e ?_Getffld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1AEAVios_base@2@PEAH@Z 0085 ?_Stodx_v2@std@@YANPEBDPEAPEADHPEAH@Z 00a0 ldexp 00b1 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 010d __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 41 57 48 8D A8 48 FD FF FF 48 81 EC 88 03 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 48 8B 85 E0 02 00 00 4C 8B F2 48 8B 9D E8 02 00 00 48 8D 54 24 30 4C 8B BD F0 02 00 00 49 8B F9 83 64 24 34 00 49 8B F0 48 89 54 24 28 48 8D 54 24 40 C7 44 24 30 00 CA 9A 3B 48 89 44 24 20 E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 34 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 30 0F 28 F0 81 FA 00 CA 9A 3B 74 0F 85 D2 74 0B C1 E2 02 E8 ?? ?? ?? ?? 0F 28 F0 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 80 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 48 83 3E 00 75 08 48 83 3F 00 74 08 EB 09 48 83 3F 00 74 03 83 0B 01 48 8D 44 24 40 48 39 44 24 38 74 0E 83 7C 24 34 00 75 07 F2 41 0F 11 37 EB 03 83 0B 02 0F 10 06 49 8B C6 F3 41 0F 7F 06 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 70 03 00 00 48 81 C4 88 03 00 00 41 5F 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_1020_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAN@Z"
		size = 297
		refs = "0020 __security_cookie 006e ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z 0085 ?_Stodx_v2@std@@YANPEBDPEAPEADHPEAH@Z 00a0 ldexp 00b1 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 010d __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 41 57 48 8D A8 48 FD FF FF 48 81 EC 88 03 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 48 8B 85 E0 02 00 00 4C 8B F2 48 8B 9D E8 02 00 00 48 8D 54 24 30 4C 8B BD F0 02 00 00 49 8B F9 83 64 24 34 00 49 8B F0 48 89 54 24 28 48 8D 54 24 40 C7 44 24 30 00 CA 9A 3B 48 89 44 24 20 E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 34 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 30 0F 28 F0 81 FA 00 CA 9A 3B 74 0F 85 D2 74 0B C1 E2 02 E8 ?? ?? ?? ?? 0F 28 F0 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 80 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 48 83 3E 00 75 08 48 83 3F 00 74 08 EB 09 48 83 3F 00 74 03 83 0B 01 48 8D 44 24 40 48 39 44 24 38 74 0E 83 7C 24 34 00 75 07 F2 41 0F 11 37 EB 03 83 0B 02 0F 10 06 49 8B C6 F3 41 0F 7F 06 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 70 03 00 00 48 81 C4 88 03 00 00 41 5F 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_41_1021_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAO@Z"
		size = 297
		refs = "0020 __security_cookie 006e ?_Getffld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1AEAVios_base@2@PEAH@Z 0085 ?_Stodx_v2@std@@YANPEBDPEAPEADHPEAH@Z 00a0 ldexp 00b1 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 010d __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 56 41 57 48 8D A8 48 FD FF FF 48 81 EC 88 03 00 00 0F 29 70 B8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 85 60 02 00 00 48 8B 85 E0 02 00 00 4C 8B F2 48 8B 9D E8 02 00 00 48 8D 54 24 30 4C 8B BD F0 02 00 00 49 8B F9 83 64 24 34 00 49 8B F0 48 89 54 24 28 48 8D 54 24 40 C7 44 24 30 00 CA 9A 3B 48 89 44 24 20 E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 34 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 30 0F 28 F0 81 FA 00 CA 9A 3B 74 0F 85 D2 74 0B C1 E2 02 E8 ?? ?? ?? ?? 0F 28 F0 80 7E 08 00 75 08 48 8B CE E8 ?? ?? ?? ?? 80 7F 08 00 75 08 48 8B CF E8 ?? ?? ?? ?? 48 83 3E 00 75 08 48 83 3F 00 74 08 EB 09 48 83 3F 00 74 03 83 0B 01 48 8D 44 24 40 48 39 44 24 38 74 0E 83 7C 24 34 00 75 07 F2 41 0F 11 37 EB 03 83 0B 02 0F 10 06 49 8B C6 F3 41 0F 7F 06 48 8B 8D 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 70 03 00 00 48 81 C4 88 03 00 00 41 5F 41 5E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_24_298_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"
		size = 345
		refs = "0020 __security_cookie 005b ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 007c ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z 0098 _guard_check_icall 00d5 _Stoullx 00e9 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B F1 49 8B E8 4C 8B FA 48 8B D9 48 8B 8C 24 F0 00 00 00 48 8B BC 24 F8 00 00 00 4C 8B AC 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 E8 ?? ?? ?? ?? 90 48 89 44 24 28 C7 44 24 20 00 08 00 00 4C 8B CE 4C 8B C5 48 8D 54 24 58 48 8B CB E8 ?? ?? ?? ?? 44 8B E0 4C 8B 74 24 50 4D 85 F6 74 35 49 8B 06 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 4C 8B F0 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 49 8B CE FF D3 90 4C 8D 4C 24 30 45 8B C4 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B D8 45 33 F6 44 38 75 08 75 08 48 8B CD E8 ?? ?? ?? ?? 44 38 76 08 75 08 48 8B CE E8 ?? ?? ?? ?? 4C 39 75 00 75 07 4C 39 36 74 07 EB 08 4C 39 36 74 03 83 0F 01 48 8D 44 24 58 48 39 44 24 38 74 0D 44 39 74 24 30 75 06 49 89 5D 00 EB 03 83 0F 02 0F 10 45 00 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_999_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"
		size = 345
		refs = "0020 __security_cookie 005b ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 007c ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z 0098 _guard_check_icall 00d5 _Stoullx 00e9 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B F1 49 8B E8 4C 8B FA 48 8B D9 48 8B 8C 24 F0 00 00 00 48 8B BC 24 F8 00 00 00 4C 8B AC 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 E8 ?? ?? ?? ?? 90 48 89 44 24 28 C7 44 24 20 00 08 00 00 4C 8B CE 4C 8B C5 48 8D 54 24 58 48 8B CB E8 ?? ?? ?? ?? 44 8B E0 4C 8B 74 24 50 4D 85 F6 74 35 49 8B 06 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 4C 8B F0 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 49 8B CE FF D3 90 4C 8D 4C 24 30 45 8B C4 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B D8 45 33 F6 44 38 75 08 75 08 48 8B CD E8 ?? ?? ?? ?? 44 38 76 08 75 08 48 8B CE E8 ?? ?? ?? ?? 4C 39 75 00 75 07 4C 39 36 74 07 EB 08 4C 39 36 74 03 83 0F 01 48 8D 44 24 58 48 39 44 24 38 74 0D 44 39 74 24 30 75 06 49 89 5D 00 EB 03 83 0F 02 0F 10 45 00 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_1022_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEAPEAX@Z"
		size = 345
		refs = "0020 __security_cookie 005b ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 007c ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z 0098 _guard_check_icall 00d5 _Stoullx 00e9 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B F1 49 8B E8 4C 8B FA 48 8B D9 48 8B 8C 24 F0 00 00 00 48 8B BC 24 F8 00 00 00 4C 8B AC 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 E8 ?? ?? ?? ?? 90 48 89 44 24 28 C7 44 24 20 00 08 00 00 4C 8B CE 4C 8B C5 48 8D 54 24 58 48 8B CB E8 ?? ?? ?? ?? 44 8B E0 4C 8B 74 24 50 4D 85 F6 74 35 49 8B 06 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 49 8B CE FF D3 4C 8B F0 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 49 8B CE FF D3 90 4C 8D 4C 24 30 45 8B C4 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B D8 45 33 F6 44 38 75 08 75 08 48 8B CD E8 ?? ?? ?? ?? 44 38 76 08 75 08 48 8B CE E8 ?? ?? ?? ?? 4C 39 75 00 75 07 4C 39 36 74 07 EB 08 4C 39 36 74 03 83 0F 01 48 8D 44 24 58 48 39 44 24 38 74 0D 44 39 74 24 30 75 06 49 89 5D 00 EB 03 83 0F 02 0F 10 45 00 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_24_300_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z 0097 _Stollx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 4C 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 4D 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_24_302_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z 0097 _Stoullx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 4C 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 4D 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_1001_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z 0097 _Stollx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 4C 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 4D 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_1003_1 {
	meta:
		name = "?do_get@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@GU?$char_traits@G@std@@@2@1HAEBVlocale@2@@Z 0097 _Stoullx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@AEBAGXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 4C 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 4D 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_1024_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_J@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z 0097 _Stollx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 4C 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 4D 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_41_1026_1 {
	meta:
		name = "?do_get@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@V32@0AEAVios_base@2@AEAHAEA_K@Z"
		size = 345
		refs = "0020 __security_cookie 005e ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0080 ?_Getifld@?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@2@1HAEBVlocale@2@@Z 0097 _Stoullx 00b3 _guard_check_icall 00e9 ?_Peek@?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@AEBA_WXZ 0141 __security_check_cookie"
	strings:
		$1 = { 40 53 55 56 57 41 54 41 55 41 56 41 57 48 81 EC 88 00 00 00 48 C7 44 24 40 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 49 8B E9 4D 8B F0 4C 8B FA 48 8B F9 48 8B 9C 24 F0 00 00 00 48 8B B4 24 F8 00 00 00 4C 8B A4 24 00 01 00 00 83 64 24 30 00 48 8D 54 24 48 48 8B CB E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4C 8B CD 4D 8B C6 48 8D 54 24 58 48 8B CF E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 30 48 8D 54 24 38 48 8D 4C 24 58 E8 ?? ?? ?? ?? 4C 8B E8 48 8B 7C 24 50 48 85 FF 74 35 48 8B 07 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 33 FF 41 38 7E 08 75 08 49 8B CE E8 ?? ?? ?? ?? 40 38 7D 08 75 08 48 8B CD E8 ?? ?? ?? ?? 49 39 3E 75 08 48 39 7D 00 74 08 EB 09 48 39 7D 00 74 03 83 0E 01 48 8D 44 24 58 48 39 44 24 38 74 0C 39 7C 24 30 75 06 4D 89 2C 24 EB 03 83 0E 02 41 0F 10 06 F3 41 0F 7F 07 49 8B C7 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_24_304_1 {
	meta:
		name = "?do_get@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@V32@0AEAVios_base@2@AEAHAEA_N@Z"
		size = 722
		refs = "0023 __security_cookie 0067 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 0070 ??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z 0092 _guard_check_icall 00cb ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z 00da ?falsename@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 00ed ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@AEBV12@_K1@Z 00fd ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 010f ?_Deallocate@std@@YAXPEAX_K1@Z 011e ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 012c ?truename@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 017f ??$_Getloctxt@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@YAHAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@0@0_KPEBD@Z 01d4 ?_Getifld@?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAHPEADAEAV?$istreambuf_iterator@DU?$char_traits@D@std@@@2@1HAEBVlocale@2@@Z 01ea _Stoulx 0263 ?_Peek@?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@AEBADXZ 02bb __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 41 54 41 55 41 56 41 57 48 8D 6C 24 F1 48 81 EC 00 01 00 00 48 C7 45 87 FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 FF 4D 8B E1 4D 8B F8 48 89 54 24 60 4C 8B F1 48 8B 5D 6F 4C 8B 6D 77 48 8B 45 7F 48 89 44 24 58 48 83 CE FF 48 8B CB F7 43 18 00 40 00 00 0F 84 47 01 00 00 48 8D 54 24 40 E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 30 44 8D 76 02 48 8B 44 24 48 48 85 C0 74 39 48 8B 00 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 48 FF D3 48 89 44 24 38 48 85 C0 74 19 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? 41 8B D6 48 8B 4C 24 38 FF D3 90 45 33 C0 49 8B D6 48 8D 4D 8F E8 ?? ?? ?? ?? 90 48 8D 55 B7 48 8B 4C 24 30 E8 ?? ?? ?? ?? 90 4C 8B CE 45 33 C0 48 8B D0 48 8D 4D 8F E8 ?? ?? ?? ?? 90 45 33 C0 41 8A D6 48 8D 4D B7 E8 ?? ?? ?? ?? 41 B8 10 00 00 00 49 8B D6 48 8B 4D B7 E8 ?? ?? ?? ?? 45 33 C0 49 8B D6 48 8D 4D 8F E8 ?? ?? ?? ?? 48 8D 55 B7 48 8B 4C 24 30 E8 ?? ?? ?? ?? 90 4C 8B CE 45 33 C0 48 8B D0 48 8D 4D 8F E8 ?? ?? ?? ?? 90 45 33 C0 41 8A D6 48 8D 4D B7 E8 ?? ?? ?? ?? BB 10 00 00 00 44 8B C3 49 8B D6 48 8B 4D B7 E8 ?? ?? ?? ?? 4C 8D 4D 97 48 39 5D AF 4C 0F 43 4D 97 44 8D 43 F2 49 8B D4 49 8B CF E8 ?? ?? ?? ?? 8B F0 45 33 C0 41 8A D6 48 8D 4D 8F E8 ?? ?? ?? ?? 44 8B C3 49 8B D6 48 8B 4D 8F E8 ?? ?? ?? ?? E9 B0 00 00 00 83 64 24 38 00 48 8D 54 24 68 E8 ?? ?? ?? ?? 48 8B D0 8B 43 18 48 89 54 24 28 89 44 24 20 4D 8B CC 4D 8B C7 48 8D 55 DF 49 8B CE E8 ?? ?? ?? ?? 44 8B C0 4C 8D 4C 24 38 48 8D 54 24 40 48 8D 4D DF E8 ?? ?? ?? ?? 8B C8 89 44 24 30 41 BE 01 00 00 00 48 8B 44 24 70 48 85 C0 74 3C 48 8B 00 48 8B 58 10 48 8B CB E8 ?? ?? ?? ?? 48 8B 4C 24 70 FF D3 48 89 44 24 50 48 85 C0 74 18 48 8B 00 48 8B 18 48 8B CB E8 ?? ?? ?? ?? 41 8B D6 48 8B 4C 24 50 FF D3 8B 4C 24 30 48 8D 45 DF 48 39 44 24 40 74 0D 83 7C 24 38 00 75 06 41 3B CE 0F 46 F1 41 80 7F 08 00 75 08 49 8B CF E8 ?? ?? ?? ?? 41 80 7C 24 08 00 75 08 49 8B CC E8 ?? ?? ?? ?? 49 83 3F 00 75 09 49 83 3C 24 00 74 09 EB 0B 49 83 3C 24 00 74 04 45 09 75 00 85 F6 79 07 41 83 4D 00 02 EB 0A 0F 95 C1 48 8B 44 24 58 88 08 41 0F 10 07 48 8B 44 24 60 F3 0F 7F 00 48 8B 4D FF 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 00 01 00 00 41 5F 41 5E 41 5D 41 5C 5E 5B 5D C3 }
	condition:
		$1
}

rule file_24_310_1 {
	meta:
		name = "?do_grouping@?$numpunct@D@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z"
		altNames = "?do_grouping@?$_Mpunct@D@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$_Mpunct@G@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$_Mpunct@_W@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$numpunct@G@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?do_grouping@?$numpunct@_W@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 10 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_24_317_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DJ@Z"
		size = 173
		refs = "000e __security_cookie 0027 ??_C@_02EAOCLKAK@ld?$AA@ 0041 ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z 005b sprintf_s 008b ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z 009e __security_check_cookie"
	strings:
		$1 = { 40 53 56 57 48 81 EC B0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 A0 00 00 00 41 0F 10 00 49 8B F9 4C 8D 05 ?? ?? ?? ?? 45 8B 49 18 48 8B F2 48 8D 54 24 50 48 8B D9 F3 0F 7F 44 24 40 E8 ?? ?? ?? ?? 44 8B 8C 24 F8 00 00 00 48 8D 4C 24 60 4C 8B C0 BA 40 00 00 00 E8 ?? ?? ?? ?? 48 63 D0 4C 8D 44 24 40 48 89 54 24 30 48 8D 44 24 60 8A 94 24 F0 00 00 00 4C 8B CF 48 89 44 24 28 48 8B CB 88 54 24 20 48 8B D6 E8 ?? ?? ?? ?? 48 8B C6 48 8B 8C 24 A0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 B0 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_24_318_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DK@Z"
		size = 173
		refs = "000e __security_cookie 0027 ??_C@_02BDDLJJBK@lu?$AA@ 0041 ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z 005b sprintf_s 008b ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z 009e __security_check_cookie"
	strings:
		$1 = { 40 53 56 57 48 81 EC B0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 A0 00 00 00 41 0F 10 00 49 8B F9 4C 8D 05 ?? ?? ?? ?? 45 8B 49 18 48 8B F2 48 8D 54 24 50 48 8B D9 F3 0F 7F 44 24 40 E8 ?? ?? ?? ?? 44 8B 8C 24 F8 00 00 00 48 8D 4C 24 60 4C 8B C0 BA 40 00 00 00 E8 ?? ?? ?? ?? 48 63 D0 4C 8D 44 24 40 48 89 54 24 30 48 8D 44 24 60 8A 94 24 F0 00 00 00 4C 8B CF 48 89 44 24 28 48 8B CB 88 54 24 20 48 8B D6 E8 ?? ?? ?? ?? 48 8B C6 48 8B 8C 24 A0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 B0 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_24_319_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DN@Z"
		size = 434
		refs = "0029 __security_cookie 0045 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 007c __xmm@7fffffffffffffff7fffffffffffffff 0084 __real@4202a05f20000000 0092 frexp 00e9 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 010e ?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADDH@Z 0125 sprintf_s 0162 ?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBD_K@Z 0171 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0183 ?_Deallocate@std@@YAXPEAX_K1@Z 0192 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 68 B1 48 81 EC B8 00 00 00 48 C7 45 9F FE FF FF FF 0F 29 70 A8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 E7 4D 8B F1 4D 8B E8 4C 8B E2 4C 8B F9 48 8D 4D B7 E8 ?? ?? ?? ?? 90 41 8B 46 18 25 00 30 00 00 49 8B 76 20 B9 00 20 00 00 48 85 F6 7F 09 3B C1 74 05 BE 06 00 00 00 48 8B D6 F2 0F 10 75 7F 3B C1 75 45 0F 28 C6 0F 54 05 ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? 76 31 48 8D 55 97 0F 28 C6 E8 ?? ?? ?? ?? 8B 45 97 99 33 C2 2B C2 69 C8 97 75 00 00 B8 89 B5 F8 14 F7 E9 C1 FA 0D 8B C2 C1 E8 1F 03 D0 48 63 D2 48 03 D6 48 83 C2 32 48 3B 55 CF 77 18 48 89 55 CF 48 8D 45 BF 48 83 7D D7 10 48 0F 43 45 BF C6 04 10 00 EB 10 48 2B 55 CF 45 33 C0 48 8D 4D B7 E8 ?? ?? ?? ?? 48 8B 5D CF 48 8D 7D BF 48 83 7D D7 10 48 0F 43 7D BF 45 8B 4E 18 45 33 C0 48 8D 55 DF 49 8B CF E8 ?? ?? ?? ?? 4C 8B C0 F2 0F 11 74 24 20 44 8B CE 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 41 0F 10 45 00 F3 0F 7F 45 A7 48 8D 55 BF 48 83 7D D7 10 48 0F 43 55 BF 48 98 48 89 44 24 30 48 89 54 24 28 8A 45 77 88 44 24 20 4D 8B CE 4C 8D 45 A7 49 8B D4 49 8B CF E8 ?? ?? ?? ?? 90 45 33 C0 B2 01 48 8D 4D B7 E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D B7 E8 ?? ?? ?? ?? 49 8B C4 48 8B 4D E7 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 A0 00 00 00 48 81 C4 B8 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_24_321_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DO@Z"
		size = 434
		refs = "0029 __security_cookie 0045 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 007c __xmm@7fffffffffffffff7fffffffffffffff 0084 __real@4202a05f20000000 0092 frexp 00e9 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z 010e ?_Ffmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADDH@Z 0125 sprintf_s 0162 ?_Fput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBD_K@Z 0171 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 0183 ?_Deallocate@std@@YAXPEAX_K1@Z 0192 __security_check_cookie"
	strings:
		$1 = { 48 8B C4 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 68 B1 48 81 EC B8 00 00 00 48 C7 45 9F FE FF FF FF 0F 29 70 A8 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 E7 4D 8B F1 4D 8B E8 4C 8B E2 4C 8B F9 48 8D 4D B7 E8 ?? ?? ?? ?? 90 41 8B 46 18 25 00 30 00 00 49 8B 76 20 B9 00 20 00 00 48 85 F6 7F 09 3B C1 74 05 BE 06 00 00 00 48 8B D6 F2 0F 10 75 7F 3B C1 75 45 0F 28 C6 0F 54 05 ?? ?? ?? ?? 66 0F 2F 05 ?? ?? ?? ?? 76 31 48 8D 55 97 0F 28 C6 E8 ?? ?? ?? ?? 8B 45 97 99 33 C2 2B C2 69 C8 97 75 00 00 B8 89 B5 F8 14 F7 E9 C1 FA 0D 8B C2 C1 E8 1F 03 D0 48 63 D2 48 03 D6 48 83 C2 32 48 3B 55 CF 77 18 48 89 55 CF 48 8D 45 BF 48 83 7D D7 10 48 0F 43 45 BF C6 04 10 00 EB 10 48 2B 55 CF 45 33 C0 48 8D 4D B7 E8 ?? ?? ?? ?? 48 8B 5D CF 48 8D 7D BF 48 83 7D D7 10 48 0F 43 7D BF 45 8B 4E 18 41 B0 4C 48 8D 55 DF 49 8B CF E8 ?? ?? ?? ?? 4C 8B C0 F2 0F 11 74 24 20 44 8B CE 48 8B D3 48 8B CF E8 ?? ?? ?? ?? 41 0F 10 45 00 F3 0F 7F 45 A7 48 8D 55 BF 48 83 7D D7 10 48 0F 43 55 BF 48 98 48 89 44 24 30 48 89 54 24 28 8A 45 77 88 44 24 20 4D 8B CE 4C 8D 45 A7 49 8B D4 49 8B CF E8 ?? ?? ?? ?? 90 45 33 C0 B2 01 48 8D 4D B7 E8 ?? ?? ?? ?? BA 01 00 00 00 44 8D 42 0F 48 8B 4D B7 E8 ?? ?? ?? ?? 49 8B C4 48 8B 4D E7 48 33 CC E8 ?? ?? ?? ?? 0F 28 B4 24 A0 00 00 00 48 81 C4 B8 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_24_323_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEBX@Z"
		size = 156
		refs = "000e __security_cookie 0027 ??_C@_02BBAHNLBA@?$CFp?$AA@ 004a sprintf_s 007a ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z 008d __security_check_cookie"
	strings:
		$1 = { 40 53 56 57 48 81 EC A0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 90 00 00 00 41 0F 10 00 49 8B F9 4C 8D 05 ?? ?? ?? ?? 4C 8B 8C 24 E8 00 00 00 48 8B F2 48 8B D9 BA 40 00 00 00 48 8D 4C 24 50 F3 0F 7F 44 24 40 E8 ?? ?? ?? ?? 48 63 C8 4C 8D 44 24 40 48 89 4C 24 30 48 8D 44 24 50 8A 8C 24 E0 00 00 00 4C 8B CF 48 89 44 24 28 48 8B D6 88 4C 24 20 48 8B CB E8 ?? ?? ?? ?? 48 8B C6 48 8B 8C 24 90 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 A0 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_24_324_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_J@Z"
		size = 173
		refs = "000e __security_cookie 0027 ??_C@_02HIKPPMOK@Ld?$AA@ 0041 ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z 005b sprintf_s 008b ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z 009e __security_check_cookie"
	strings:
		$1 = { 40 53 56 57 48 81 EC B0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 A0 00 00 00 41 0F 10 00 49 8B F9 4C 8D 05 ?? ?? ?? ?? 45 8B 49 18 48 8B F2 48 8D 54 24 50 48 8B D9 F3 0F 7F 44 24 40 E8 ?? ?? ?? ?? 4C 8B 8C 24 F8 00 00 00 48 8D 4C 24 60 4C 8B C0 BA 40 00 00 00 E8 ?? ?? ?? ?? 48 63 D0 4C 8D 44 24 40 48 89 54 24 30 48 8D 44 24 60 8A 94 24 F0 00 00 00 4C 8B CF 48 89 44 24 28 48 8B CB 88 54 24 20 48 8B D6 E8 ?? ?? ?? ?? 48 8B C6 48 8B 8C 24 A0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 B0 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_24_325_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_K@Z"
		size = 173
		refs = "000e __security_cookie 0027 ??_C@_02CLHGNPPK@Lu?$AA@ 0041 ?_Ifmt@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBAPEADPEADPEBDH@Z 005b sprintf_s 008b ?_Iput@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@AEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@DPEAD_K@Z 009e __security_check_cookie"
	strings:
		$1 = { 40 53 56 57 48 81 EC B0 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 A0 00 00 00 41 0F 10 00 49 8B F9 4C 8D 05 ?? ?? ?? ?? 45 8B 49 18 48 8B F2 48 8D 54 24 50 48 8B D9 F3 0F 7F 44 24 40 E8 ?? ?? ?? ?? 4C 8B 8C 24 F8 00 00 00 48 8D 4C 24 60 4C 8B C0 BA 40 00 00 00 E8 ?? ?? ?? ?? 48 63 D0 4C 8D 44 24 40 48 89 54 24 30 48 8D 44 24 60 8A 94 24 F0 00 00 00 4C 8B CF 48 89 44 24 28 48 8B CB 88 54 24 20 48 8B D6 E8 ?? ?? ?? ?? 48 8B C6 48 8B 8C 24 A0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 B0 00 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule file_24_326_1 {
	meta:
		name = "?do_put@?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEBA?AV?$ostreambuf_iterator@DU?$char_traits@D@std@@@2@V32@AEAVios_base@2@D_N@Z"
		size = 699
		refs = "0024 __security_cookie 006a _guard_check_icall 0093 ?getloc@ios_base@std@@QEBA?AVlocale@2@XZ 009c ??$use_facet@V?$numpunct@D@std@@@std@@YAAEBV?$numpunct@D@0@AEBVlocale@0@@Z 00e6 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 00f9 ?truename@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0113 ?_Tidy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_N_K@Z 011f ?_Assign_rv@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX$$QEAV12@@Z 0127 ?falsename@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ 0172 ?_Deallocate@std@@YAXPEAX_K1@Z 01c0 ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z 02a3 __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 F1 48 81 EC C8 00 00 00 48 C7 45 9F FE FF FF FF 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 F7 4D 8B E9 4D 8B E0 4C 8B F2 48 89 55 97 48 8B F1 44 8A 7D 77 44 88 7C 24 30 41 F7 41 18 00 40 00 00 75 39 41 0F 10 00 F3 0F 7F 45 87 48 8B 11 0F B6 5D 7F 48 8B 7A 48 48 8B CF E8 ?? ?? ?? ?? 89 5C 24 28 44 88 7C 24 20 4D 8B CD 4C 8D 45 87 49 8B D6 48 8B CE FF D7 E9 0D 02 00 00 48 8D 55 87 49 8B CD E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 48 8B F0 48 8B 7D 8F 48 85 FF 74 35 48 8B 17 48 8B 5A 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 19 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 90 48 8D 4D A7 E8 ?? ?? ?? ?? 90 48 8D 55 CF 48 8B CE 80 7D 7F 00 74 2E E8 ?? ?? ?? ?? 48 8B D8 48 8D 45 A7 48 3B C3 74 1B 45 33 C0 B2 01 48 8D 4D A7 E8 ?? ?? ?? ?? 48 8B D3 48 8D 4D A7 E8 ?? ?? ?? ?? 90 EB 2C E8 ?? ?? ?? ?? 48 8B D8 48 8D 45 A7 48 3B C3 74 1B 45 33 C0 B2 01 48 8D 4D A7 E8 ?? ?? ?? ?? 48 8B D3 48 8D 4D A7 E8 ?? ?? ?? ?? 90 45 33 C0 B2 01 48 8D 4D CF E8 ?? ?? ?? ?? 41 BF 10 00 00 00 45 8B C7 41 8D 57 F1 48 8B 4D CF E8 ?? ?? ?? ?? 49 8B 5D 28 48 8B 7D BF 48 85 DB 7E 0A 48 3B DF 76 05 48 2B DF EB 02 33 DB 41 8B 45 18 25 C0 01 00 00 83 F8 40 74 46 41 0F 10 04 24 0F 29 45 87 48 85 DB 74 30 48 8B 7D 8F 40 8A 74 24 30 48 85 FF 74 10 40 8A D6 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 75 04 C6 45 87 01 48 83 EB 01 75 E1 48 8B 7D BF 0F 28 45 87 F3 41 0F 7F 04 24 33 DB 41 0F 10 04 24 0F 29 45 87 48 8D 75 AF 4C 39 7D C7 48 0F 43 75 AF 48 85 FF 74 2D 4C 8B 75 8F 4D 85 F6 74 0F 8A 16 49 8B CE E8 ?? ?? ?? ?? 83 F8 FF 75 04 C6 45 87 01 48 FF C6 48 83 EF 01 75 DF 0F 28 45 87 4C 8B 75 97 F3 41 0F 7F 04 24 49 83 65 28 00 41 0F 10 04 24 0F 29 45 87 48 85 DB 74 30 48 8B 7D 8F 44 8A 74 24 30 48 85 FF 74 10 41 8A D6 48 8B CF E8 ?? ?? ?? ?? 83 F8 FF 75 04 C6 45 87 01 48 83 EB 01 75 E1 0F 28 45 87 4C 8B 75 97 F3 41 0F 7F 06 45 33 C0 B2 01 48 8D 4D A7 E8 ?? ?? ?? ?? 4D 8B C7 BA 01 00 00 00 48 8B 4D A7 E8 ?? ?? ?? ?? 49 8B C6 48 8B 4D F7 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 C8 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_24_334_1 {
	meta:
		name = "?do_truename@?$numpunct@D@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z"
		altNames = "?do_positive_sign@?$_Mpunct@D@std@@MEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 28 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_1085_1 {
	meta:
		name = "?do_positive_sign@?$_Mpunct@G@std@@MEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 28 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_1086_1 {
	meta:
		name = "?do_positive_sign@?$_Mpunct@_W@std@@MEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 28 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_1147_1 {
	meta:
		name = "?do_truename@?$numpunct@G@std@@MEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAA@PEBG@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 28 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_41_1148_1 {
	meta:
		name = "?do_truename@?$numpunct@_W@std@@MEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
		size = 35
		refs = "0016 ??0?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAA@PEB_W@Z"
	strings:
		$1 = { 40 53 48 83 EC 30 83 64 24 20 00 48 8B DA 48 8B 51 28 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 30 5B C3 }
	condition:
		$1
}

rule file_24_343_1 {
	meta:
		name = "?falsename@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 68
		refs = "0025 _guard_check_icall"
		altNames = "?curr_symbol@?$_Mpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?curr_symbol@?$_Mpunct@G@std@@QEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?curr_symbol@?$_Mpunct@_W@std@@QEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ ?falsename@?$numpunct@G@std@@QEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?falsename@?$numpunct@_W@std@@QEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 48 8B 01 48 8B F9 83 64 24 20 00 48 8B F2 48 8B 58 30 48 8B CB E8 ?? ?? ?? ?? 48 8B D6 48 8B CF FF D3 48 8B 5C 24 40 48 8B C6 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_24_347_1 {
	meta:
		name = "?global@locale@std@@SA?AV12@AEBV12@@Z"
		size = 272
		refs = "0027 ?_Init@locale@std@@CAPEAV_Locimp@12@_N@Z 003f ??0_Lockit@std@@QEAA@H@Z 0045 ?_Getgloballocale@locale@std@@CAPEAV_Locimp@12@XZ 0061 _guard_check_icall 0092 ?_Setgloballocale@locale@std@@CAXPEAX@Z 00c5 setlocale 00fb ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 48 8B C4 48 89 48 08 55 56 57 48 83 EC 30 48 C7 40 E0 FE FF FF FF 48 89 58 18 48 8B F2 48 8B E9 83 60 D8 00 B1 01 E8 ?? ?? ?? ?? 48 89 45 08 C7 44 24 20 01 00 00 00 33 D2 48 8D 4C 24 58 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 48 8B F8 48 3B 46 08 0F 84 9F 00 00 00 48 8B 08 48 8B 59 10 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B F8 48 85 C0 74 18 48 8B 08 48 8B 19 48 8B CB E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B CF FF D3 48 8B 7E 08 48 8B CF E8 ?? ?? ?? ?? 48 8B 07 48 8B 58 08 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 8B 77 20 83 E6 3F 83 FE 3F 75 16 48 8B 57 28 48 85 D2 75 04 48 8D 57 30 33 C9 E8 ?? ?? ?? ?? EB 2A 33 DB 8B CB B8 01 00 00 00 D3 E0 D1 F8 85 C6 74 12 48 8B 57 28 48 85 D2 75 04 48 8D 57 30 E8 ?? ?? ?? ?? FF C3 83 FB 05 7E D8 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B C5 48 8B 5C 24 60 48 83 C4 30 5F 5E 5D C3 CC }
	condition:
		$1
}

rule file_24_348_1 {
	meta:
		name = "?dtor$0@?0??global@locale@std@@SA?AV12@AEBV12@@Z@4HA"
		size = 38
		refs = "001c ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 8B 45 20 83 E0 01 85 C0 74 0D 83 65 20 FE 48 8B 4D 50 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_24_351_1 {
	meta:
		name = "?grouping@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 68
		refs = "0025 _guard_check_icall"
		altNames = "?grouping@?$_Mpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$_Mpunct@G@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$_Mpunct@_W@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$numpunct@G@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?grouping@?$numpunct@_W@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 48 8B 01 48 8B F9 83 64 24 20 00 48 8B F2 48 8B 58 28 48 8B CB E8 ?? ?? ?? ?? 48 8B D6 48 8B CF FF D3 48 8B 5C 24 40 48 8B C6 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_24_352_1 {
	meta:
		name = "?insert@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0D@Z"
		size = 322
		refs = "0061 ?_Copy@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K0@Z 00c4 memmove 00fe memset 0131 ?_Xran@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ 0137 ?_Xlen@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 56 41 57 48 83 EC 20 49 8B E8 45 8A F9 4C 8B 41 18 4C 8B F2 48 8B D9 4C 3B C2 0F 82 FF 00 00 00 49 8B C0 48 F7 D0 48 3B C5 0F 86 F6 00 00 00 49 8D 34 28 48 85 ED 0F 84 C7 00 00 00 48 83 FE FE 0F 87 E5 00 00 00 48 39 71 20 73 0A 48 8B D6 E8 ?? ?? ?? ?? EB 1D 48 85 F6 75 21 48 21 71 18 48 83 79 20 10 72 06 48 8B 41 08 EB 04 48 8D 41 08 C6 00 00 48 85 F6 0F 84 87 00 00 00 48 83 7B 20 10 48 8D 7B 08 72 05 48 8B 0F EB 03 48 8B CF 48 83 7B 20 10 72 05 48 8B 07 EB 03 48 8B C7 4C 8B 43 18 4D 2B C6 74 10 4A 8D 14 31 4A 8D 0C 30 48 03 CD E8 ?? ?? ?? ?? 48 83 FD 01 75 15 48 83 7B 20 10 72 05 48 8B 07 EB 03 48 8B C7 46 88 3C 30 EB 1F 48 83 7B 20 10 72 05 48 8B 07 EB 03 48 8B C7 41 0F BE D7 4A 8D 0C 30 4C 8B C5 E8 ?? ?? ?? ?? 48 83 7B 20 10 48 89 73 18 72 03 48 8B 3F C6 04 37 00 48 8B 6C 24 48 48 8B C3 48 8B 5C 24 40 48 8B 74 24 50 48 83 C4 20 41 5F 41 5E 5F C3 E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_24_361_1 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
		size = 44
		refs = "0028 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z"
	strings:
		$1 = { 48 3B 51 18 77 1A 48 89 51 18 48 83 79 20 10 72 06 48 8B 49 08 EB 04 48 83 C1 08 C6 04 11 00 C3 48 2B 51 18 45 33 C0 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_362_1 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_KD@Z"
		size = 41
		refs = "0025 ?append@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_KD@Z"
	strings:
		$1 = { 48 3B 51 18 77 1A 48 89 51 18 48 83 79 20 10 72 06 48 8B 49 08 EB 04 48 83 C1 08 C6 04 11 00 C3 48 2B 51 18 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_363_1 {
	meta:
		name = "?sbumpc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"
		size = 93
		refs = "0049 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 41 38 48 8B F9 48 83 38 00 74 08 48 8B 41 50 8B 08 EB 02 33 C9 85 C9 7E 19 48 8B 47 50 FF 08 48 8B 4F 38 48 8B 11 48 8D 42 01 48 89 01 0F B6 02 EB 14 48 8B 07 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_364_1 {
	meta:
		name = "?sgetc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHXZ"
		size = 75
		refs = "0037 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 41 38 48 8B F9 48 8B 10 48 85 D2 74 08 48 8B 41 50 8B 08 EB 02 33 C9 85 C9 7E 05 0F B6 02 EB 14 48 8B 07 48 8B 58 30 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_366_1 {
	meta:
		name = "?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z"
		size = 116
		refs = "0059 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 41 40 44 8A C2 48 8B F1 48 83 38 00 74 08 48 8B 41 58 8B 08 EB 02 33 C9 85 C9 7E 1D 48 8B 46 58 FF 08 48 8B 4E 40 48 8B 11 48 8D 42 01 48 89 01 44 88 02 41 0F B6 C0 EB 1A 48 8B 06 41 0F B6 D8 48 8B 78 18 48 8B CF E8 ?? ?? ?? ?? 8B D3 48 8B CE FF D7 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_24_367_1 {
	meta:
		name = "?thousands_sep@?$numpunct@D@std@@QEBADXZ"
		size = 47
		refs = "0018 _guard_check_icall"
		altNames = "?thousands_sep@?$_Mpunct@D@std@@QEBADXZ ?thousands_sep@?$_Mpunct@G@std@@QEBAGXZ ?thousands_sep@?$_Mpunct@_W@std@@QEBA_WXZ ?thousands_sep@?$numpunct@G@std@@QEBAGXZ ?thousands_sep@?$numpunct@_W@std@@QEBA_WXZ _Cnd_destroy_in_situ"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 01 48 8B F9 48 8B 58 20 48 8B CB E8 ?? ?? ?? ?? 48 8B CF 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_24_370_1 {
	meta:
		name = "?truename@?$numpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ"
		size = 68
		refs = "0025 _guard_check_icall"
		altNames = "?positive_sign@?$_Mpunct@D@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ?positive_sign@?$_Mpunct@G@std@@QEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?positive_sign@?$_Mpunct@_W@std@@QEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ ?truename@?$numpunct@G@std@@QEBA?AV?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@2@XZ ?truename@?$numpunct@_W@std@@QEBA?AV?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@2@XZ"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 30 48 8B 01 48 8B F9 83 64 24 20 00 48 8B F2 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 48 8B D6 48 8B CF FF D3 48 8B 5C 24 40 48 8B C6 48 8B 74 24 48 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_24_372_1 {
	meta:
		name = "?widen@?$ctype@D@std@@QEBAPEBDPEBD0PEAD@Z"
		size = 96
		refs = "0030 _guard_check_icall"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 48 8B 01 4C 8B F1 49 8B F9 49 8B F0 48 8B EA 48 8B 58 38 48 8B CB E8 ?? ?? ?? ?? 4C 8B CF 4C 8B C6 48 8B D5 49 8B CE 48 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E 48 FF E0 }
	condition:
		$1
}

rule file_24_379_1 {
	meta:
		name = "ldexpf"
		size = 22
		refs = "0009 ldexp"
	strings:
		$1 = { 48 83 EC 28 F3 0F 5A C0 E8 ?? ?? ?? ?? F2 0F 5A C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_25_0_1 {
	meta:
		name = "_LSinh"
		size = 410
		refs = "0028 _LDtest 0074 __xmm@80000000000000008000000000000000 008b _LRteps 0099 __real@3ff0000000000000 00aa p 00bb _LPoly 00d6 _LXbig 00ec _LExp 00f9 __real@3fd0000000000000 012c _Feraise 0151 __real@0000000000000000"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 78 18 F2 0F 11 40 08 55 48 8B EC 48 83 EC 40 0F 29 70 E8 48 8D 4D 10 0F 29 78 D8 0F 28 F9 E8 ?? ?? ?? ?? 0F BF C8 33 FF 85 C9 0F 84 3E 01 00 00 83 E9 01 0F 84 0B 01 00 00 83 F9 01 0F 84 FB 00 00 00 0F 57 C0 66 0F 2E F8 7A 12 75 10 66 0F 2F 45 10 0F 86 11 01 00 00 E9 FE 00 00 00 F2 0F 10 4D 10 66 0F 2F C1 76 13 0F 57 0D ?? ?? ?? ?? BB 01 00 00 00 F2 0F 11 4D 10 EB 03 0F B7 DF F2 0F 10 05 ?? ?? ?? ?? 66 0F 2F C1 77 70 F2 0F 10 15 ?? ?? ?? ?? 66 0F 2F D1 76 2F F2 0F 59 C9 48 8D 15 ?? ?? ?? ?? 41 B8 07 00 00 00 0F 28 C1 0F 28 F1 E8 ?? ?? ?? ?? F2 0F 59 75 10 0F 28 C8 F2 0F 59 CE F2 0F 58 4D 10 EB 33 F2 0F 10 05 ?? ?? ?? ?? 48 8D 4D 10 41 83 C8 FF 66 0F 2F C1 76 23 0F 28 CA E8 ?? ?? ?? ?? F2 0F 10 4D 10 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E C1 F2 0F 5C C8 F2 0F 59 CF EB 2A 0F 28 CF E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0C 83 F9 01 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 4D 10 66 85 DB 74 07 0F 57 0D ?? ?? ?? ?? 0F 28 C1 EB 3A F2 0F 10 45 10 EB 33 66 0F 2E 3D ?? ?? ?? ?? 7A 16 75 14 B8 00 80 00 00 66 85 45 16 74 0E 0F 57 3D ?? ?? ?? ?? EB 05 F2 0F 10 7D 10 0F 28 C7 EB 09 F2 0F 10 45 10 F2 0F 59 C7 48 8B 5C 24 58 48 8B 7C 24 60 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 40 5D C3 }
	condition:
		$1
}

rule file_26_0_1 {
	meta:
		name = "?_Rng_abort@std@@YAXPEBD@Z"
		size = 59
		refs = "000f __acrt_iob_func 001a fputs 0031 fputc 0036 abort"
		altNames = "_Thrd_abort"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B D9 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8B CB E8 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 B9 0A 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_28_0_1 {
	meta:
		name = "_Dtest"
		size = 97
	strings:
		$1 = { 0F B7 51 06 B8 F0 7F 00 00 66 23 D0 66 3B D0 75 24 F6 41 06 0F 75 18 33 C0 66 39 41 04 75 10 66 39 41 02 75 0A 66 39 01 B8 01 00 00 00 74 31 B8 02 00 00 00 C3 0F B7 41 06 A9 FF 7F FF FF 75 13 33 C0 66 39 41 04 75 0B 66 39 41 02 75 05 66 39 01 74 0D 66 F7 DA 66 1B C0 66 F7 D8 66 83 C0 FE C3 }
	condition:
		$1
}

rule file_29_1_1 {
	meta:
		name = "_Stofx"
		size = 582
		refs = "001c __security_cookie 003c _Stopfx 0076 _Stoflt 007e __real@4e6e6b28 0090 _FXp_setw 00ad _FXp_setn 00d3 _FXp_mulx 00f8 _FXp_addx 010e _FDtento 0134 _Stoxflt 013c __real@4d800000 01db _FDscale 01ea _FInf 01fd _FNan 0215 _FPmsw 022e __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 E1 48 81 EC A8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 0F 48 8B F1 48 89 4D B7 48 8D 4D B7 4D 8B F1 41 8B F8 48 8B DA E8 ?? ?? ?? ?? 44 8B E0 41 83 E4 08 4D 85 F6 74 04 41 83 26 00 83 E0 F7 41 BD 01 00 00 00 41 3B C5 0F 85 B5 00 00 00 48 8B 55 B7 4C 8D 4D AF 4C 8B C3 44 89 6C 24 20 48 8B CE E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 41 8D 5D 03 8B D3 48 63 F0 48 8D 4D CF E8 ?? ?? ?? ?? 48 8D 4D BF 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 59 44 8B 45 B3 E8 ?? ?? ?? ?? 4C 8B FE 49 8B F5 4D 3B EF 7D 45 48 8D 45 EF 44 8B CB 4C 8D 45 CF 48 89 44 24 20 8B D3 48 8D 4D BF E8 ?? ?? ?? ?? 49 03 F5 48 8D 4D DF 8B D3 44 8B 44 B5 AF E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 DF 8B D3 48 8D 4D BF E8 ?? ?? ?? ?? 49 3B F7 7C BB 03 7D AF 48 8D 4D BF 8B D7 4D 8B C6 E8 ?? ?? ?? ?? E9 EF 00 00 00 83 F8 02 0F 85 C1 00 00 00 48 8B 55 B7 4C 8D 4D AF 4C 8B C3 44 89 6C 24 20 48 8B CE E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 48 8D 4D DF BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4D BF 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 59 44 8B 45 B3 E8 ?? ?? ?? ?? 4C 8B FE 49 8B F5 4D 3B EF 7D 45 48 8D 45 EF 44 8B CB 4C 8D 45 DF 48 89 44 24 20 8B D3 48 8D 4D BF E8 ?? ?? ?? ?? 49 03 F5 48 8D 4D CF 8B D3 44 8B 44 B5 AF E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 CF 8B D3 48 8D 4D BF E8 ?? ?? ?? ?? 49 3B F7 7C BB 4D 8B C6 48 8D 4D BF 8B D7 E8 ?? ?? ?? ?? 8B 55 AF 48 8D 4D A7 F3 0F 11 45 A7 E8 ?? ?? ?? ?? EB 2A 83 F8 03 75 0A F3 0F 10 05 ?? ?? ?? ?? EB 16 BB 04 00 00 00 3B C3 75 0A F3 0F 10 05 ?? ?? ?? ?? EB 03 0F 57 C0 F3 0F 11 45 A7 45 85 E4 74 11 48 8D 4D A7 E8 ?? ?? ?? ?? B9 00 80 00 00 66 31 08 F3 0F 10 45 A7 48 8B 4D 0F 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 A8 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_108_1_1 {
	meta:
		name = "_WStofx"
		size = 582
		refs = "001c __security_cookie 003c _WStopfx 0076 _WStoflt 007e __real@4e6e6b28 0090 _FXp_setw 00ad _FXp_setn 00d3 _FXp_mulx 00f8 _FXp_addx 010e _FDtento 0134 _WStoxflt 013c __real@4d800000 01db _FDscale 01ea _FInf 01fd _FNan 0215 _FPmsw 022e __security_check_cookie"
	strings:
		$1 = { 40 55 53 56 57 41 54 41 55 41 56 41 57 48 8D 6C 24 E1 48 81 EC A8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 0F 48 8B F1 48 89 4D B7 48 8D 4D B7 4D 8B F1 41 8B F8 48 8B DA E8 ?? ?? ?? ?? 44 8B E0 41 83 E4 08 4D 85 F6 74 04 41 83 26 00 83 E0 F7 41 BD 01 00 00 00 41 3B C5 0F 85 B5 00 00 00 48 8B 55 B7 4C 8D 4D AF 4C 8B C3 44 89 6C 24 20 48 8B CE E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 41 8D 5D 03 8B D3 48 63 F0 48 8D 4D CF E8 ?? ?? ?? ?? 48 8D 4D BF 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 59 44 8B 45 B3 E8 ?? ?? ?? ?? 4C 8B FE 49 8B F5 4D 3B EF 7D 45 48 8D 45 EF 44 8B CB 4C 8D 45 CF 48 89 44 24 20 8B D3 48 8D 4D BF E8 ?? ?? ?? ?? 49 03 F5 48 8D 4D DF 8B D3 44 8B 44 B5 AF E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 DF 8B D3 48 8D 4D BF E8 ?? ?? ?? ?? 49 3B F7 7C BB 03 7D AF 48 8D 4D BF 8B D7 4D 8B C6 E8 ?? ?? ?? ?? E9 EF 00 00 00 83 F8 02 0F 85 C1 00 00 00 48 8B 55 B7 4C 8D 4D AF 4C 8B C3 44 89 6C 24 20 48 8B CE E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 48 8D 4D DF BB 04 00 00 00 48 63 F0 8B D3 E8 ?? ?? ?? ?? 48 8D 4D BF 8B D3 85 F6 75 0A 0F 57 D2 E8 ?? ?? ?? ?? EB 59 44 8B 45 B3 E8 ?? ?? ?? ?? 4C 8B FE 49 8B F5 4D 3B EF 7D 45 48 8D 45 EF 44 8B CB 4C 8D 45 DF 48 89 44 24 20 8B D3 48 8D 4D BF E8 ?? ?? ?? ?? 49 03 F5 48 8D 4D CF 8B D3 44 8B 44 B5 AF E8 ?? ?? ?? ?? 44 8B CB 4C 8D 45 CF 8B D3 48 8D 4D BF E8 ?? ?? ?? ?? 49 3B F7 7C BB 4D 8B C6 48 8D 4D BF 8B D7 E8 ?? ?? ?? ?? 8B 55 AF 48 8D 4D A7 F3 0F 11 45 A7 E8 ?? ?? ?? ?? EB 2A 83 F8 03 75 0A F3 0F 10 05 ?? ?? ?? ?? EB 16 BB 04 00 00 00 3B C3 75 0A F3 0F 10 05 ?? ?? ?? ?? EB 03 0F 57 C0 F3 0F 11 45 A7 45 85 E4 74 11 48 8D 4D A7 E8 ?? ?? ?? ?? B9 00 80 00 00 66 31 08 F3 0F 10 45 A7 48 8B 4D 0F 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 A8 00 00 00 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_30_0_1 {
	meta:
		name = "_FXp_addh"
		size = 869
		refs = "003d _FDunscale 0051 _FDtest 0068 _FPmsw 0095 _Feraise 009d _FNan 021e _FDint 022b _FDscale"
	strings:
		$1 = { F3 0F 11 54 24 18 55 53 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 48 45 33 E4 F3 0F 11 55 60 0F 29 74 24 30 48 8B F9 4C 63 FA 85 D2 0F 84 18 03 00 00 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 66 44 3B E0 7D 7F 66 83 F8 02 74 6B 48 8B CF E8 ?? ?? ?? ?? 66 85 C0 7E 5E 66 83 F8 02 0F 84 E8 02 00 00 48 8B CF E8 ?? ?? ?? ?? BE 00 80 00 00 48 8D 4D 58 0F B7 18 66 23 DE E8 ?? ?? ?? ?? 0F B7 08 66 23 CE 66 3B CB 0F 84 BD 02 00 00 41 8D 4C 24 01 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 07 41 83 FF 01 0F 8E 9D 02 00 00 44 89 67 04 E9 94 02 00 00 F3 0F 10 45 58 F3 0F 11 07 E9 86 02 00 00 66 85 C0 0F 89 7D 02 00 00 41 BD 00 01 00 00 45 8B F4 49 8B DF 45 85 FF 0F 8E 68 02 00 00 49 8B F4 0F 57 F6 4C 8D 67 FC F3 0F 10 04 B7 48 8D 55 D8 48 8D 4D 50 F3 0F 11 45 D8 E8 ?? ?? ?? ?? 33 C9 66 3B C8 0F 8C 3C 02 00 00 66 85 C0 0F 84 18 02 00 00 0F BF 55 50 0F BF 45 48 8B CA F3 0F 10 4D 58 2B C8 83 F9 F4 7F 5C 0F 2E CE 7A 02 74 55 41 8B CE 48 8B C6 8B D1 48 FF C0 FF C1 48 3B C3 7D 0C F3 0F 10 04 87 0F 2E C6 7A EA 75 E8 41 8D 47 FF 3B C8 7D 04 FF C1 EB 06 41 3B CF 0F 44 CA 48 63 D1 48 3B F2 7D 0F 8B 44 97 FC 89 04 97 48 FF CA 48 3B D6 7F F1 83 65 58 00 F3 0F 11 0C B7 E9 9B 01 00 00 B8 0C 00 00 00 3B C8 7C 12 0F 2E CE 7A 02 74 0B 44 8B EA 41 FF C6 E9 79 01 00 00 F3 0F 58 0C B7 0F 2E CE F3 0F 11 0C B7 7A 37 75 35 48 8B C6 48 FF C0 48 3B C3 7D 12 F3 0F 10 04 87 0F 2E C6 F3 0F 11 44 87 FC 7A E8 75 E6 83 64 9F FC 00 F3 0F 10 04 B7 0F 2E C6 0F 28 C8 7A 06 0F 84 60 01 00 00 48 8D 55 58 F3 0F 11 4D 58 48 8D 4D 48 49 63 DE E8 ?? ?? ?? ?? 0F BF 55 48 41 8D 4D F4 3B CA 0F 8D 94 00 00 00 66 41 2B D5 48 8D 4D 58 66 83 C2 0C E8 ?? ?? ?? ?? 0F BF 55 48 48 8D 4D 58 E8 ?? ?? ?? ?? F3 0F 10 04 B7 49 8B DF F3 0F 5C 45 58 0F 2E C6 F3 0F 11 04 B7 7A 25 75 23 48 8B C6 48 FF C0 48 3B C3 7D 12 F3 0F 10 04 87 0F 2E C6 F3 0F 11 44 87 FC 7A E8 75 E6 42 83 64 BF FC 00 48 FF CE 49 83 EC 04 41 83 EE 01 75 0B 41 BD 00 01 00 00 E9 A3 00 00 00 F3 41 0F 10 04 24 48 8D 55 60 48 8D 4D 50 F3 0F 11 45 60 E8 ?? ?? ?? ?? 44 0F BF 6D 50 E9 81 00 00 00 41 FF C6 45 3B F7 0F 84 9B 00 00 00 F3 0F 10 04 B7 48 8D 1C 9F 48 8B D3 F3 0F 11 45 58 48 8D 4D 50 E8 ?? ?? ?? ?? BA 0C 00 00 00 48 8B CB E8 ?? ?? ?? ?? 0F BF 55 50 48 8B CB E8 ?? ?? ?? ?? F3 0F 10 45 58 F3 0F 10 0C B7 44 0F BF 6D 50 F3 0F 5C C1 0F 2E C6 F3 0F 11 45 58 7A 09 75 07 F3 0F 11 4D 60 EB 05 F3 0F 11 45 60 48 8D 55 60 48 8D 4D 48 E8 ?? ?? ?? ?? 49 8B DF 48 FF C6 49 83 C4 04 45 3B F7 0F 8C BF FD FF FF EB 1B F3 0F 10 45 58 49 63 C6 41 FF C6 F3 0F 11 04 87 45 3B F7 7D 06 49 63 C6 89 0C 87 48 8B C7 0F 28 74 24 30 48 83 C4 48 41 5F 41 5E 41 5D 41 5C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_30_1_1 {
	meta:
		name = "_FXp_addx"
		size = 110
		refs = "0033 __real@00000000 0042 _FXp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 24 F3 0F 10 16 0F 2E 15 ?? ?? ?? ?? 7A 02 74 15 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 04 3B FD 7C DC 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_30_2_1 {
	meta:
		name = "_FXp_getw"
		size = 109
	strings:
		$1 = { 85 D2 75 04 0F 57 C0 C3 83 FA 01 74 5B F3 0F 10 19 0F 57 C9 0F 2E D9 7A 02 74 4D F3 0F 10 41 04 0F 2E C1 7A 02 74 41 83 FA 02 74 37 F3 0F 10 51 08 0F 2E D1 7A 02 74 2B 0F 28 E0 F3 0F 58 E3 83 FA 04 7C 05 F3 0F 58 51 0C 0F 28 CC F3 0F 5C CB 0F 2E C8 7A 0A 75 08 F3 0F 58 D4 0F 28 C2 C3 F3 0F 58 C2 F3 0F 58 C3 C3 F3 0F 10 01 C3 }
	condition:
		$1
}

rule file_30_3_1 {
	meta:
		name = "_FXp_invx"
		size = 329
		refs = "0035 _FDtest 005a _FInf 0084 memcpy 008c __real@bf800000 0096 _FXp_mulh 00ac __real@3f800000 00ba _FXp_setw 00e1 _FXp_mulx 00f3 _FXp_addh 0118 _FXp_addx"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 40 33 ED 0F 29 70 D8 48 63 FA 4D 8B F8 48 8B D9 85 D2 0F 84 EE 00 00 00 E8 ?? ?? ?? ?? 66 3B E8 7F 29 8D 75 01 66 3B C6 75 07 89 2B E9 D5 00 00 00 66 85 C0 0F 85 CC 00 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 03 E9 BB 00 00 00 F3 0F 10 33 4C 8B F7 49 C1 E6 02 48 8B D3 4D 8B C6 4B 8D 2C 3E 48 8B CD 4D 8D 24 2E E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? BE 01 00 00 00 3B FE 7E 05 F3 0F 58 73 04 F3 0F 10 15 ?? ?? ?? ?? 8B D7 F3 0F 5E D6 48 8B CB E8 ?? ?? ?? ?? 3B FE 7E 60 4D 8B C6 48 8B D3 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C5 8B D7 49 8B CF E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4C 89 64 24 20 4C 8B C3 8B D7 49 8B CF E8 ?? ?? ?? ?? 44 8B CF 4D 8B C7 8B D7 48 8B CB E8 ?? ?? ?? ?? 03 F6 3B F7 7C A0 48 8B 6C 24 68 48 8B C3 48 8B 5C 24 60 48 8B 74 24 70 48 8B 7C 24 78 0F 28 74 24 30 48 83 C4 40 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_30_4_1 {
	meta:
		name = "_FXp_ldexpx"
		size = 119
		refs = "0035 ldexp 0043 __real@00000000"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 DB 45 8B F0 8B EA 48 8B F1 85 D2 7E 32 48 8B F9 F3 0F 10 07 41 8B D6 0F 5A C0 E8 ?? ?? ?? ?? 0F 57 C9 F2 0F 5A C8 0F 2E 0D ?? ?? ?? ?? F3 0F 11 0F 7A 02 74 0A FF C3 48 83 C7 04 3B DD 7C D1 48 8B 5C 24 30 48 8B C6 48 8B 74 24 40 48 8B 6C 24 38 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_30_5_1 {
	meta:
		name = "_FXp_movx"
		size = 36
		refs = "0017 memcpy"
	strings:
		$1 = { 40 53 48 83 EC 20 49 8B C0 48 8B D9 4C 63 C2 48 8B D0 49 C1 E0 02 E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_30_6_1 {
	meta:
		name = "_FXp_mulh"
		size = 481
		refs = "0024 __security_cookie 0050 _FDtest 006b _Feraise 012b _FDunscale 0139 _FDint 0146 _FDscale 0156 _FXp_addh 01bb __security_check_cookie"
	strings:
		$1 = { 48 89 5C 24 18 55 56 57 41 54 41 55 41 56 41 57 48 8B EC 48 83 EC 70 0F 29 74 24 60 0F 29 7C 24 50 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 45 D0 45 33 E4 4C 63 FA 0F 28 FA 48 8B F9 85 D2 7E 58 0F 28 C2 F3 0F 59 01 48 8D 4D C0 F3 0F 11 45 C0 E8 ?? ?? ?? ?? 0F B7 F0 66 44 3B E0 7F 37 41 8D 5C 24 01 66 83 F8 02 75 07 8B CB E8 ?? ?? ?? ?? F3 0F 10 45 C0 F3 0F 11 07 66 44 3B E6 0F 8D 2E 01 00 00 44 3B FB 0F 8E 25 01 00 00 44 89 67 04 E9 1C 01 00 00 44 89 27 BB 01 00 00 00 41 8B C4 89 45 B8 44 8B F3 45 85 FF 0F 8E 02 01 00 00 4D 8B EC 8B F3 4C 8D 65 C0 0F 57 F6 4C 2B E7 48 83 FE 04 7D 4A 42 8D 14 30 4A 8D 04 2E 48 8D 0C 87 41 3B D7 7D 2C F3 0F 10 01 0F 2E C6 7A 02 74 21 83 21 00 44 03 F3 F3 0F 59 C7 03 D3 48 03 F3 F3 41 0F 11 04 0C 48 83 C1 04 48 83 FE 04 7C D1 EB 0D 83 64 B5 C0 00 BE 08 00 00 00 44 8B F6 F3 0F 10 45 C0 0F 2E C6 7A 06 0F 84 93 00 00 00 48 8D 55 B0 F3 0F 11 45 B0 48 8D 4D B4 E8 ?? ?? ?? ?? BA 0C 00 00 00 48 8D 4D B0 E8 ?? ?? ?? ?? 0F BF 55 B4 48 8D 4D B0 E8 ?? ?? ?? ?? F3 0F 10 55 B0 41 8B D7 48 8B CF E8 ?? ?? ?? ?? F3 0F 10 55 C0 41 8B D7 F3 0F 5C 55 B0 48 8B CF E8 ?? ?? ?? ?? 48 8B C3 48 3B DE 7D 1B F3 0F 10 44 85 C0 0F 2E C6 F3 0F 11 44 85 BC 7A 02 74 08 48 03 C3 48 3B C6 7C E5 8B 45 B8 4C 03 EB 03 C3 49 83 EC 04 44 2B F3 89 45 B8 48 2B F3 4D 3B EF 0F 8C 0D FF FF FF 48 8B C7 48 8B 4D D0 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 24 C0 00 00 00 0F 28 74 24 60 0F 28 7C 24 50 48 83 C4 70 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_30_7_1 {
	meta:
		name = "_FXp_mulx"
		size = 254
		refs = "0041 __real@00000000 005d _FXp_mulh 007d memcpy 00d2 _FXp_addx"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 41 54 41 55 41 56 41 57 48 83 EC 20 49 63 E9 49 8B D8 48 63 FA 48 8B F1 85 D2 0F 84 AE 00 00 00 45 85 C9 0F 84 A5 00 00 00 F3 41 0F 10 10 0F 2E 15 ?? ?? ?? ?? 7A 02 74 11 F3 41 0F 10 40 04 0F 2E 05 ?? ?? ?? ?? 7A 0B 75 09 8B D7 E8 ?? ?? ?? ?? EB 7B 4C 8B 7C 24 70 4C 8B F7 49 C1 E6 02 48 8B D6 4D 8B C6 49 8B CF 4F 8D 24 3E E8 ?? ?? ?? ?? F3 0F 10 13 8B D7 48 8B CE E8 ?? ?? ?? ?? 4C 8B ED BD 01 00 00 00 EB 40 F3 0F 10 04 AB 0F 2E 05 ?? ?? ?? ?? 7A 02 74 35 4D 8B C6 49 8B D7 49 8B CC E8 ?? ?? ?? ?? F3 0F 10 14 AB 8B D7 49 8B CC E8 ?? ?? ?? ?? 44 8B CF 4D 8B C4 8B D7 48 8B CE E8 ?? ?? ?? ?? 48 FF C5 49 3B ED 7C BB 48 8B 5C 24 50 48 8B C6 48 8B 74 24 60 48 8B 6C 24 58 48 83 C4 20 41 5F 41 5E 41 5D 41 5C 5F C3 }
	condition:
		$1
}

rule file_30_8_1 {
	meta:
		name = "_FXp_setn"
		size = 129
		refs = "003a _FXp_setw 0042 __real@461c4000 004c _FXp_mulh 0065 _FXp_addh"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 8B F2 B8 AD 8B DB 68 41 F7 E8 41 8B F8 48 8B E9 8B DA 8B D6 C1 FB 0C 8B C3 C1 E8 1F 03 D8 66 0F 6E D3 0F 5B D2 E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D6 48 8B CD E8 ?? ?? ?? ?? 69 C3 10 27 00 00 8B D6 48 8B CD 2B F8 66 0F 6E D7 0F 5B D2 E8 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B C5 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_30_9_1 {
	meta:
		name = "_FXp_setw"
		size = 175
		refs = "0035 _FDunscale 005d _FDint 006c _FDscale"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 70 20 57 48 83 EC 30 0F 29 70 E8 33 F6 0F 28 F2 8B FA F3 0F 11 70 18 48 8B D9 85 D2 7E 70 83 FA 01 74 67 48 8D 50 18 48 8D 48 10 E8 ?? ?? ?? ?? 66 85 C0 74 4F 66 3B F0 7D 0F F3 0F 10 44 24 50 F3 0F 11 03 89 73 04 EB 45 BA 0C 00 00 00 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F BF 54 24 48 48 8D 4C 24 50 E8 ?? ?? ?? ?? F3 0F 10 44 24 50 F3 0F 11 03 F3 0F 5C F0 F3 0F 11 73 04 83 FF 02 7E 0F 89 73 08 EB 0A F3 0F 10 74 24 50 F3 0F 11 33 48 8B 74 24 58 48 8B C3 48 8B 5C 24 40 0F 28 74 24 20 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_30_10_1 {
	meta:
		name = "_FXp_sqrtx"
		size = 353
		refs = "0031 _FDtest 006b sqrt 0073 __real@3ff0000000000000 0085 _FXp_setw 009e memcpy 00a6 __real@bf000000 00b0 _FXp_mulh 00c5 _FXp_mulx 00e2 __real@3fc00000 00ec _FXp_addh 012f _Feraise 0137 _FNan"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 30 33 F6 48 63 FA 49 8B E8 48 8B D9 85 D2 0F 84 0F 01 00 00 E8 ?? ?? ?? ?? 0F 57 C0 66 3B F0 0F 8E E3 00 00 00 F3 0F 10 0B 0F 2F C1 0F 87 DB 00 00 00 4C 8B F7 49 C1 E6 02 49 8D 34 2E 4D 8D 3C 36 83 FF 01 7E 05 F3 0F 58 4B 04 0F 5A C1 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? 8B D7 F2 0F 5E C8 48 8B CE 66 0F 5A D1 E8 ?? ?? ?? ?? 41 BC 02 00 00 00 41 3B FC 7E 79 4D 8B C6 48 8B D6 48 8B CD E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C3 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CD E8 ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? 8B D7 48 8B CD E8 ?? ?? ?? ?? 44 8B CF 4C 89 7C 24 20 4C 8B C5 8B D7 48 8B CE E8 ?? ?? ?? ?? 45 03 E4 44 3B E7 7C 87 44 8B CF 4C 89 7C 24 20 4C 8B C6 8B D7 48 8B CB E8 ?? ?? ?? ?? EB 1B 0F 2F 03 76 16 B9 01 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 03 48 8B 6C 24 58 48 8B C3 48 8B 5C 24 50 48 8B 74 24 60 48 8B 7C 24 68 48 83 C4 30 41 5F 41 5E 41 5C C3 }
	condition:
		$1
}

rule file_30_11_1 {
	meta:
		name = "_FXp_subx"
		size = 117
		refs = "0033 __real@00000000 003e __xmm@80000000800000008000000080000000 0049 _FXp_addh"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 33 FF 41 8B E9 49 8B F0 44 8B F2 48 8B D9 45 85 C9 7E 2B F3 0F 10 16 0F 2E 15 ?? ?? ?? ?? 7A 02 74 1C 0F 57 15 ?? ?? ?? ?? 41 8B D6 48 8B CB E8 ?? ?? ?? ?? FF C7 48 83 C6 04 3B FD 7C D5 48 8B 6C 24 38 48 8B C3 48 8B 5C 24 30 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_31_0_1 {
	meta:
		name = "_Getwctype"
		size = 52
		refs = "001d __imp_GetStringTypeW"
	strings:
		$1 = { 66 89 4C 24 08 48 83 EC 28 B9 01 00 00 00 4C 8D 4C 24 40 44 8B C1 48 8D 54 24 30 FF 15 ?? ?? ?? ?? 0F BF 54 24 40 F7 D8 1B C9 23 CA 0F B7 C1 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_31_1_1 {
	meta:
		name = "_Getwctypes"
		size = 47
		refs = "0022 __imp_GetStringTypeW"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B C2 48 8B DA 48 2B C1 4D 8B C8 48 D1 F8 48 8B D1 44 8B C0 B9 01 00 00 00 FF 15 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_32_4_1 {
	meta:
		name = "??0future_error@std@@QEAA@Verror_code@1@@Z"
		size = 98
		refs = "000d ??_7exception@std@@6B@ 0034 ??_C@_00CNPNBAHC@?$AA@ 003e __std_exception_copy 0045 ??_7future_error@std@@6B@"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 30 48 8D 05 ?? ?? ?? ?? C6 44 24 28 01 48 89 01 48 8B DA 33 C0 48 8D 51 08 48 89 02 48 8B F9 48 89 42 08 48 8D 4C 24 20 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 07 48 8B C7 0F 10 03 48 8B 5C 24 40 F3 0F 7F 47 18 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_32_14_1 {
	meta:
		name = "?_Future_error_map@std@@YAPEBDH@Z"
		size = 55
		refs = "001a ??_C@_08CCNMMIE@no?5state?$AA@ 0022 ??_C@_0BK@JNDAEPJA@promise?5already?5satisfied?$AA@ 002a ??_C@_0BJ@JOKOCMFN@future?5already?5retrieved?$AA@ 0032 ??_C@_0P@JCDOJLHG@broken?5promise?$AA@"
	strings:
		$1 = { 83 E9 01 74 2A 83 E9 01 74 1D 83 E9 01 74 10 83 F9 01 74 03 33 C0 C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_32_16_1 {
	meta:
		name = "?_Rethrow_future_exception@std@@YAXVexception_ptr@1@@Z"
		size = 40
		refs = "001b ??0exception_ptr@std@@QEAA@AEBV01@@Z 0023 ?rethrow_exception@std@@YAXVexception_ptr@1@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 20 FE FF FF FF 48 8B D1 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_32_18_1 {
	meta:
		name = "?_Throw_future_error@std@@YAXAEBVerror_code@1@@Z"
		size = 46
		refs = "0018 ??0future_error@std@@QEAA@Verror_code@1@@Z 001f _TI3?AVfuture_error@std@@ 0029 _CxxThrowException"
	strings:
		$1 = { 48 83 EC 68 0F 10 01 48 8D 54 24 20 48 8D 4C 24 30 F3 0F 7F 44 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_32_19_1 {
	meta:
		name = "?rethrow_exception@std@@YAXVexception_ptr@1@@Z"
		size = 24
		refs = "0013 ?_RethrowException@exception_ptr@std@@QEBAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 FE FF FF FF E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_32_23_1 {
	meta:
		name = "?what@future_error@std@@UEBAPEBDXZ"
		size = 58
		refs = "001d ??_C@_08CCNMMIE@no?5state?$AA@ 0025 ??_C@_0BK@JNDAEPJA@promise?5already?5satisfied?$AA@ 002d ??_C@_0BJ@JOKOCMFN@future?5already?5retrieved?$AA@ 0035 ??_C@_0P@JCDOJLHG@broken?5promise?$AA@"
	strings:
		$1 = { 8B 51 18 83 EA 01 74 2A 83 EA 01 74 1D 83 EA 01 74 10 83 FA 01 74 03 33 C0 C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 48 8D 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_34_0_1 {
	meta:
		name = "_FExp"
		size = 269
		refs = "000b __real@c3650000 0029 __real@43650000 0033 _FInf 004c __real@3fb8aa3b 0059 __real@bf000000 0063 __real@3f000000 006b _FEps 0088 __real@35bfbe8e 0090 __real@3f317200 009e __xmm@80000000800000008000000080000000 00c7 __real@41403e28 00cf __real@42705d55 00d7 __real@42f05d55 0104 _FDscale"
	strings:
		$1 = { F3 0F 10 19 0F 28 E1 F3 0F 10 05 ?? ?? ?? ?? 0F 2F C3 0F 87 F0 00 00 00 0F 57 C9 0F 2E E1 7A 06 0F 84 E2 00 00 00 0F 2F 1D ?? ?? ?? ?? 76 16 F3 0F 10 05 ?? ?? ?? ?? B8 01 00 00 00 F3 0F 11 01 E9 C7 00 00 00 0F 28 C3 F3 0F 59 05 ?? ?? ?? ?? 0F 2F C8 76 0A F3 0F 10 0D ?? ?? ?? ?? EB 08 F3 0F 10 0D ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 C8 F3 0F 2C D1 0F BF C2 66 0F 6E C8 0F 5B C9 0F 28 C1 F3 0F 59 0D ?? ?? ?? ?? F3 0F 59 05 ?? ?? ?? ?? F3 0F 5C D8 0F 28 C2 0F 57 05 ?? ?? ?? ?? F3 0F 5C D9 0F 2F D8 76 0B 0F 2F D3 76 06 F3 0F 11 21 EB 44 0F 28 C3 66 FF CA F3 0F 59 C3 0F 28 D0 F3 0F 59 15 ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 58 15 ?? ?? ?? ?? F3 0F 59 D8 0F 28 CA F3 0F 58 CB F3 0F 5C D3 F3 0F 5E CA F3 0F 58 C9 F3 0F 59 CC F3 0F 11 09 0F BF D2 41 0F BF C0 03 D0 E9 ?? ?? ?? ?? 33 C0 89 01 C3 }
	condition:
		$1
}

rule file_35_0_1 {
	meta:
		name = "_FSinh"
		size = 399
		refs = "0024 _FDtest 006d __xmm@80000000800000008000000080000000 0084 _FRteps 0091 __real@3f800000 00a8 __real@3955e8d5 00b0 __real@3c0879d7 00bc __real@3e2aaada 00d5 _FXbig 00e7 _FExp 00f4 __real@3e800000 0127 _Feraise 014b __real@00000000"
	strings:
		$1 = { 48 8B C4 48 89 58 10 48 89 78 18 F3 0F 11 40 08 55 48 8B EC 48 83 EC 30 0F 29 70 E8 48 8D 4D 10 0F 28 F1 E8 ?? ?? ?? ?? 0F BF C8 33 FF 85 C9 0F 84 3C 01 00 00 83 E9 01 0F 84 0A 01 00 00 83 F9 01 0F 84 FA 00 00 00 0F 57 C0 0F 2E F0 7A 11 75 0F 0F 2F 45 10 0F 86 11 01 00 00 E9 FE 00 00 00 F3 0F 10 55 10 0F 2F C2 76 13 0F 57 15 ?? ?? ?? ?? BB 01 00 00 00 F3 0F 11 55 10 EB 03 0F B7 DF F3 0F 10 05 ?? ?? ?? ?? 0F 2F C2 77 73 F3 0F 10 0D ?? ?? ?? ?? 0F 2F CA 76 37 0F 28 C2 F3 0F 59 C2 0F 28 C8 F3 0F 59 0D ?? ?? ?? ?? F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 C8 F3 0F 58 0D ?? ?? ?? ?? F3 0F 59 C8 F3 0F 59 CA F3 0F 58 CA 0F 28 D1 EB 2F F3 0F 10 05 ?? ?? ?? ?? 48 8D 4D 10 41 83 C8 FF 0F 2F C2 76 20 E8 ?? ?? ?? ?? F3 0F 10 55 10 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5E C2 F3 0F 5C D0 F3 0F 59 D6 EB 2A 0F 28 CE E8 ?? ?? ?? ?? 0F BF C8 85 C9 74 0C 83 F9 01 75 11 B9 08 00 00 00 EB 05 B9 10 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 55 10 66 85 DB 74 07 0F 57 15 ?? ?? ?? ?? 0F 28 C2 EB 39 F3 0F 10 45 10 EB 32 0F 2E 35 ?? ?? ?? ?? 7A 16 75 14 B8 00 80 00 00 66 85 45 12 74 0E 0F 57 35 ?? ?? ?? ?? EB 05 F3 0F 10 75 10 0F 28 C6 EB 09 F3 0F 10 45 10 F3 0F 59 C6 48 8B 5C 24 48 48 8B 7C 24 50 0F 28 74 24 20 48 83 C4 30 5D C3 }
	condition:
		$1
}

rule file_36_0_1 {
	meta:
		name = "?initialize_pointers@@YAHXZ"
		size = 1230
		refs = "0009 ??_C@_1BK@MGMFAEKH@?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA3?$AA2?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 000f __imp_GetModuleHandleW 0019 ??_C@_08KNHFBNJ@FlsAlloc?$AA@ 0022 __imp_GetProcAddress 0029 __security_cookie 0030 ??_C@_07PEJMOBNF@FlsFree?$AA@ 003a __encodedKERNEL32Functions 004e ??_C@_0M@GDNOONDI@FlsGetValue?$AA@ 006c ??_C@_0M@JCPCPOEF@FlsSetValue?$AA@ 008a ??_C@_0BM@HCFOFFN@InitializeCriticalSectionEx?$AA@ 00a8 ??_C@_0BE@GPLMMCMH@InitOnceExecuteOnce?$AA@ 00c6 ??_C@_0P@DLHPPCNH@CreateEventExW?$AA@ 00e4 ??_C@_0BB@MEFPJLHN@CreateSemaphoreW?$AA@ 0102 ??_C@_0BD@KIEEOEEH@CreateSemaphoreExW?$AA@ 0120 ??_C@_0BG@OGFAJCKC@CreateThreadpoolTimer?$AA@ 013e ??_C@_0BD@LPLEMMDI@SetThreadpoolTimer?$AA@ 015c ??_C@_0CA@FMNJENH@WaitForThreadpoolTimerCallbacks?$AA@ 017a ??_C@_0BF@DCFCCNOC@CloseThreadpoolTimer?$AA@ 0198 ??_C@_0BF@FLABGKKM@CreateThreadpoolWait?$AA@ 01b6 ??_C@_0BC@MGCOHNA@SetThreadpoolWait?$AA@ 01d4 ??_C@_0BE@OCIOMIMP@CloseThreadpoolWait?$AA@ 01f2 ??_C@_0BJ@LKGHFHBO@FlushProcessWriteBuffers?$AA@ 0210 ??_C@_0BP@KALKKPMO@FreeLibraryWhenCallbackReturns?$AA@ 022e ??_C@_0BK@DFNBACLA@GetCurrentProcessorNumber?$AA@ 024c ??_C@_0BE@FKKLLFLM@CreateSymbolicLinkW?$AA@ 026a ??_C@_0BE@JOGNEJCI@GetCurrentPackageId?$AA@ 0288 ??_C@_0P@CDHHOHKP@GetTickCount64?$AA@ 02a6 ??_C@_0BN@NEEHBBPO@GetFileInformationByHandleEx?$AA@ 02c4 ??_C@_0BL@KBBHGKCM@SetFileInformationByHandle?$AA@ 02e2 ??_C@_0BP@FPNJPEJC@GetSystemTimePreciseAsFileTime?$AA@ 0300 ??_C@_0BM@HLJJNPAH@InitializeConditionVariable?$AA@ 031e ??_C@_0BG@BFNILBLN@WakeConditionVariable?$AA@ 033c ??_C@_0BJ@PGPPEPCC@WakeAllConditionVariable?$AA@ 035a ??_C@_0BJ@JEBJOJFJ@SleepConditionVariableCS?$AA@ 0378 ??_C@_0BC@MMLHEBPB@InitializeSRWLock?$AA@ 0396 ??_C@_0BI@OMNLIJDB@AcquireSRWLockExclusive?$AA@ 03b4 ??_C@_0BL@OGHFEMNA@TryAcquireSRWLockExclusive?$AA@ 03d2 ??_C@_0BI@HMIEPCNJ@ReleaseSRWLockExclusive?$AA@ 03f0 ??_C@_0BK@LGACAGIC@SleepConditionVariableSRW?$AA@ 040e ??_C@_0BF@GGPHFPJA@CreateThreadpoolWork?$AA@ 042c ??_C@_0BF@NHDAIMMO@SubmitThreadpoolWork?$AA@ 044a ??_C@_0BE@NPHIPNPD@CloseThreadpoolWork?$AA@ 0468 ??_C@_0BA@IHGNDAEB@CompareStringEx?$AA@ 0486 ??_C@_0BA@ONOKGCMP@GetLocaleInfoEx?$AA@ 04a4 ??_C@_0O@KKBNKAPF@LCMapStringEx?$AA@"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B C8 48 8D 15 ?? ?? ?? ?? 48 8B D8 FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B CB FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B CB 48 89 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 33 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_36_1_1 {
	meta:
		name = "__crtAcquireSRWLockExclusive"
		size = 54
		refs = "000d __encodedKERNEL32Functions 0017 __security_cookie 001f _guard_check_icall"
		altNames = "__crtCloseThreadpoolWork __crtInitializeConditionVariable __crtInitializeSRWLock __crtReleaseSRWLockExclusive __crtSubmitThreadpoolWork __crtTryAcquireSRWLockExclusive __crtWakeAllConditionVariable __crtWakeConditionVariable"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 8B F9 48 33 1D ?? ?? ?? ?? 48 8B CB E8 ?? ?? ?? ?? 48 8B CF 48 8B C3 48 8B 5C 24 30 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_36_2_1 {
	meta:
		name = "__crtCloseThreadpoolTimer"
		size = 53
		refs = "000d __encodedKERNEL32Functions 0017 __security_cookie 0021 _guard_check_icall"
		altNames = "__crtCloseThreadpoolWait"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 8B F9 48 33 1D ?? ?? ?? ?? 74 0D 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_5_1 {
	meta:
		name = "__crtCreateEventExW"
		size = 122
		refs = "001c __encodedKERNEL32Functions 0026 __security_cookie 0039 _guard_check_icall 005b __imp_CreateEventW"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 48 8B 3D ?? ?? ?? ?? 45 8B F1 48 33 3D ?? ?? ?? ?? 41 8B D8 48 8B F2 48 8B E9 74 18 48 8B CF E8 ?? ?? ?? ?? 45 8B CE 44 8B C3 48 8B D6 48 8B CD FF D7 EB 12 83 E3 01 41 83 E0 02 8B D3 4C 8B CE FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_36_6_1 {
	meta:
		name = "__crtCreateSemaphoreExW"
		size = 158
		refs = "001c __encodedKERNEL32Functions 0026 __security_cookie 003b _guard_check_icall"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 30 48 8B 1D ?? ?? ?? ?? 49 8B F9 48 8B 05 ?? ?? ?? ?? 41 8B F0 48 33 D8 8B EA 4C 8B F1 74 27 48 8B CB E8 ?? ?? ?? ?? 8B 44 24 68 4C 8B CF 89 44 24 28 44 8B C6 8B 44 24 60 8B D5 49 8B CE 89 44 24 20 FF D3 EB 25 48 8B 1D ?? ?? ?? ?? 48 33 D8 74 17 48 8B CB E8 ?? ?? ?? ?? 4C 8B CF 44 8B C6 8B D5 49 8B CE FF D3 EB 02 33 C0 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 30 41 5E C3 }
	condition:
		$1
}

rule file_36_7_1 {
	meta:
		name = "__crtCreateSymbolicLinkW"
		size = 100
		refs = "0017 __encodedKERNEL32Functions 0021 __security_cookie 0031 _guard_check_icall 0049 __imp_SetLastError"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 41 8B F8 48 33 1D ?? ?? ?? ?? 48 8B F2 48 8B E9 74 15 48 8B CB E8 ?? ?? ?? ?? 44 8B C7 48 8B D6 48 8B CD FF D3 EB 0D B9 78 00 00 00 FF 15 ?? ?? ?? ?? 32 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_8_1 {
	meta:
		name = "__crtCreateThreadpoolTimer"
		size = 89
		refs = "0017 __encodedKERNEL32Functions 0021 __security_cookie 0031 _guard_check_icall"
		altNames = "__crtCreateThreadpoolWait"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 49 8B F8 48 33 1D ?? ?? ?? ?? 48 8B F2 48 8B E9 74 15 48 8B CB E8 ?? ?? ?? ?? 4C 8B C7 48 8B D6 48 8B CD FF D3 EB 02 33 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_10_1 {
	meta:
		name = "__crtCreateThreadpoolWork"
		size = 86
		refs = "0017 __encodedKERNEL32Functions 0021 __security_cookie 002f _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 6C 24 10 48 89 74 24 18 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 8B E9 48 33 1D ?? ?? ?? ?? 49 8B F8 48 8B CB 48 8B F2 E8 ?? ?? ?? ?? 4C 8B C7 48 8B D6 48 8B CD 48 8B C3 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 83 C4 20 5F 48 FF E0 }
	condition:
		$1
}

rule file_36_11_1 {
	meta:
		name = "__crtFlsAlloc"
		size = 61
		refs = "000d __encodedKERNEL32Functions 0017 __security_cookie 0021 _guard_check_icall 002e __imp_TlsAlloc"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 8B F9 48 33 1D ?? ?? ?? ?? 74 0F 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 EB 06 FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_19_1 {
	meta:
		name = "__crtGetSystemTimePreciseAsFileTime"
		size = 61
		refs = "000d __encodedKERNEL32Functions 0017 __security_cookie 0021 _guard_check_icall 002e __imp_GetSystemTimeAsFileTime"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 8B F9 48 33 1D ?? ?? ?? ?? 74 0F 48 8B CB E8 ?? ?? ?? ?? 48 8B CF FF D3 EB 06 FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_12_1 {
	meta:
		name = "__crtFlsFree"
		size = 59
		refs = "000d __encodedKERNEL32Functions 0016 __security_cookie 0020 _guard_check_icall 002c __imp_TlsFree"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 8B F9 48 33 1D ?? ?? ?? ?? 74 0E 48 8B CB E8 ?? ?? ?? ?? 8B CF FF D3 EB 06 FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_13_1 {
	meta:
		name = "__crtFlsGetValue"
		size = 59
		refs = "000d __encodedKERNEL32Functions 0016 __security_cookie 0020 _guard_check_icall 002c __imp_TlsGetValue"
	strings:
		$1 = { 48 89 5C 24 08 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 8B F9 48 33 1D ?? ?? ?? ?? 74 0E 48 8B CB E8 ?? ?? ?? ?? 8B CF FF D3 EB 06 FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_14_1 {
	meta:
		name = "__crtFlsSetValue"
		size = 75
		refs = "0012 __encodedKERNEL32Functions 001c __security_cookie 0028 _guard_check_icall 0037 __imp_TlsSetValue"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 8B FA 48 33 1D ?? ?? ?? ?? 8B F1 74 11 48 8B CB E8 ?? ?? ?? ?? 48 8B D7 8B CE FF D3 EB 06 FF 15 ?? ?? ?? ?? 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_15_1 {
	meta:
		name = "__crtFlushProcessWriteBuffers"
		size = 38
		refs = "0009 __encodedKERNEL32Functions 0010 __security_cookie 001a _guard_check_icall"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 33 1D ?? ?? ?? ?? 74 0A 48 8B CB E8 ?? ?? ?? ?? FF D3 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_36_16_1 {
	meta:
		name = "__crtFreeLibraryWhenCallbackReturns"
		size = 69
		refs = "0012 __encodedKERNEL32Functions 001c __security_cookie 0029 _guard_check_icall"
	strings:
		$1 = { 48 89 5C 24 08 48 89 74 24 10 57 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 8B FA 48 33 1D ?? ?? ?? ?? 48 8B F1 74 10 48 8B CB E8 ?? ?? ?? ?? 48 8B D7 48 8B CE FF D3 48 8B 5C 24 30 48 8B 74 24 38 48 83 C4 20 5F C3 }
	condition:
		$1
}

rule file_36_17_1 {
	meta:
		name = "__crtGetCurrentProcessorNumber"
		size = 49
		refs = "0009 __encodedKERNEL32Functions 0010 __security_cookie 001a _guard_check_icall"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 33 1D ?? ?? ?? ?? 74 13 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B 48 FF E0 33 C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_36_18_1 {
	meta:
		name = "__crtGetFileInformationByHandleEx"
		size = 115
		refs = "001c __encodedKERNEL32Functions 0026 __security_cookie 0038 _guard_check_icall 0052 __imp_SetLastError"
		altNames = "__crtSetFileInformationByHandle"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 56 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 41 8B F9 48 33 1D ?? ?? ?? ?? 49 8B F0 8B EA 4C 8B F1 74 17 48 8B CB E8 ?? ?? ?? ?? 44 8B CF 4C 8B C6 8B D5 49 8B CE FF D3 EB 0D B9 78 00 00 00 FF 15 ?? ?? ?? ?? 33 C0 48 8B 5C 24 30 48 8B 6C 24 38 48 8B 74 24 40 48 8B 7C 24 48 48 83 C4 20 41 5E C3 }
	condition:
		$1
}

rule file_36_20_1 {
	meta:
		name = "__crtGetTickCount64"
		size = 55
		refs = "0009 __encodedKERNEL32Functions 0010 __security_cookie 001a _guard_check_icall 002b __imp_GetTickCount"
	strings:
		$1 = { 40 53 48 83 EC 20 48 8B 1D ?? ?? ?? ?? 48 33 1D ?? ?? ?? ?? 74 13 48 8B CB E8 ?? ?? ?? ?? 48 8B C3 48 83 C4 20 5B 48 FF E0 FF 15 ?? ?? ?? ?? 8B C0 48 83 C4 20 5B C3 }
	condition:
		$1
}

rule file_36_21_1 {
	meta:
		name = "__crtInitOnceExecuteOnce"
		size = 220
		refs = "0020 __encodedKERNEL32Functions 002a __security_cookie 003d _guard_check_icall 0071 __imp_Sleep 00d4 __imp_SetLastError"
	strings:
		$1 = { 48 8B C4 48 89 58 08 48 89 68 10 48 89 70 18 48 89 78 20 41 54 41 56 41 57 48 83 EC 20 48 8B 3D ?? ?? ?? ?? 4D 8B F1 48 33 3D ?? ?? ?? ?? 4D 8B F8 48 8B EA 48 8B D9 74 18 48 8B CF E8 ?? ?? ?? ?? 4D 8B CE 4D 8B C7 48 8B D5 48 8B CB FF D7 EB 33 33 C0 44 8D 60 01 F0 4C 0F B1 21 41 8D 7C 24 01 EB 19 48 85 C0 74 3B 49 3B C4 75 60 33 C9 FF 15 ?? ?? ?? ?? 33 C0 F0 4C 0F B1 23 48 3B C7 75 E2 41 8B C4 48 8B 5C 24 40 48 8B 6C 24 48 48 8B 74 24 50 48 8B 7C 24 58 48 83 C4 20 41 5F 41 5E 41 5C C3 48 8B CD 41 8B F4 E8 ?? ?? ?? ?? 4D 8B C6 49 8B D7 48 8B CB FF D5 85 C0 75 04 33 FF 33 F6 48 87 3B 49 3B FC 75 04 8B C6 EB B7 B9 0D 00 00 00 FF 15 ?? ?? ?? ?? 33 C0 EB A8 }
	condition:
		$1
}

rule file_36_23_1 {
	meta:
		name = "__crtI