# scp

> 보안 복사.
> SSH를 통한 보안 복사 프로토콜을 사용하여 호스트 간에 파일 복사.
> 더 많은 정보: <https://man.openbsd.org/scp>.

- 로컬 파일을 원격 호스트에 복사:

`scp {{경로/대상/로컬_파일}} {{원격_호스트}}:{{경로/대상/원격_파일}}`

- 원격 호스트에 연결할 때 특정 포트를 사용:

`scp -P {{포트}} {{경로/대상/로컬_파일}} {{원격_호스트}}:{{경로/대상/원격_파일}}`

- 원격 호스트의 파일을 로컬 폴더로 복사:

`scp {{원격_호스트}}:{{경로/대상/원격_파일}} {{경로/대상/로컬_폴더}}`

- 원격 호스트의 폴더 내용을 로컬 폴더로 반복적으로 복사:

`scp -r {{원격_호스트}}:{{경로/대상/원격_폴더}} {{경로/대상/로컬_폴더}}`

- 로컬 호스트를 통해 전송되는 두 원격 호스트 간에 파일 복사:

`scp -3 {{호스트1}}:{{경로/대상/원격_파일}} {{호스트2}}:{{경로/대상/원격_폴더}}`

- 원격 호스트에 연결할 때 특정 사용자 이름을 사용:

`scp {{경로/대상/로컬_파일}} {{원격_사용자명}}@{{원격_호스트}}:{{경로/대상/원격_폴더}}`

- 원격 호스트 인증을 위해 특정 SSH 개인 키를 사용:

`scp -i {{~/.ssh/개인_키}} {{경로/대상/로컬_파일}} {{원격_호스트}}:{{경로/대상/원격_파일}}`

- 원격 호스트에 연결할 때 특정 프록시 사용:

`scp -J {{프록시_사용자_이름}}@{{프록시_호스트}} {{경로/대상/로컬_파일}} {{원격_호스트}}:{{경로/대상/원격_파일}}`
