/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.unciv.UncivGame;
import com.unciv.app.desktop.CreateGameFromSettings;
import com.unciv.app.desktop.DesktopDisplay;
import com.unciv.app.desktop.DesktopFont;
import com.unciv.app.desktop.DesktopGame;
import com.unciv.app.desktop.DesktopLogBackend;
import com.unciv.app.desktop.DesktopSaverLoader;
import com.unciv.app.desktop.DesktopScreenMode;
import com.unciv.app.desktop.HardenGdxAudio;
import com.unciv.app.desktop.ImagePacker;
import com.unciv.app.desktop.LinuxX11SaverLoader;
import com.unciv.app.desktop.UiElementDocsWriter;
import com.unciv.app.desktop.UniqueDocsWriter;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.validation.RulesetError;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.ruleset.validation.UniqueAutoUpdater;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.Display;
import com.unciv.utils.Log;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.Configuration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/unciv/app/desktop/DesktopLauncher;", "", "<init>", "()V", "main", "", "arg", "", "", "([Ljava/lang/String;)V", "updateDockIconForMacOs", "fileName", "desktop"})
@SourceDebugExtension(value={"SMAP\nDesktopLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopLauncher.kt\ncom/unciv/app/desktop/DesktopLauncher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1#2:162\n1761#3,3:163\n*S KotlinDebug\n*F\n+ 1 DesktopLauncher.kt\ncom/unciv/app/desktop/DesktopLauncher\n*L\n72#1:163,3\n*E\n"})
public final class DesktopLauncher {
    @NotNull
    public static final DesktopLauncher INSTANCE = new DesktopLauncher();

    private DesktopLauncher() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] arg) {
        String string;
        String customDataDirPrefix;
        block16: {
            String createGameArg;
            block14: {
                String string2;
                Intrinsics.checkNotNullParameter(arg, "arg");
                for (String string3 : arg) {
                    String it = string3;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default(it, "--creategame=", false, 2, null)) continue;
                    string2 = string3;
                    break block14;
                }
                string2 = createGameArg = null;
            }
            if (createGameArg != null) {
                String settingsPath = StringsKt.substringAfter$default(createGameArg, "=", null, 2, null);
                UncivGame game = new UncivGame(true);
                UncivGame.Companion.setCurrent(game);
                UncivGame.Companion.getCurrent().setSettings(new GameSettings());
                RulesetCache.INSTANCE.loadRulesets(true, false);
                BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super String>, Object>(settingsPath, null){
                    int label;
                    final /* synthetic */ String $settingsPath;
                    {
                        this.$settingsPath = $settingsPath;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                String[] stringArray = new String[]{this.$settingsPath};
                                this.label = 1;
                                Object object2 = CreateGameFromSettings.INSTANCE.startGame(stringArray, this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure($result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            if (!(arg.length == 0) && Intrinsics.areEqual(arg[0], "mod-ci")) {
                boolean bl;
                block15: {
                    ImagePacker.packImagesPerMod$default(ImagePacker.INSTANCE, ".", ".", null, 4, null);
                    Ruleset ruleset = new Ruleset();
                    ruleset.setFolderLocation(new FileHandle("."));
                    FileHandle jsonsFolder = new FileHandle("jsons");
                    if (jsonsFolder.exists()) {
                        RulesetCache.INSTANCE.loadRulesets(true, true);
                        ruleset.load(jsonsFolder);
                    }
                    UniqueAutoUpdater.autoupdateUniques$default(UniqueAutoUpdater.INSTANCE, ruleset, null, 2, null);
                    RulesetErrorList errors = RulesetValidator.Companion.create(ruleset, true).getErrorList();
                    System.out.println((Object)errors.getErrorText(true));
                    Iterable $this$any$iv = errors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            RulesetError rulesetError = (RulesetError)element$iv;
                            boolean bl2 = false;
                            if (!(rulesetError.getErrorSeverityToReport() == RulesetErrorSeverity.Error)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                System.exit(bl ? 1 : 0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            if (!(arg.length == 0) && Intrinsics.areEqual(arg[0], "--version")) {
                System.out.println((Object)UncivGame.Companion.getVERSION().getText());
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            if (SharedLibraryLoader.os == Os.MacOsX) {
                Configuration.GLFW_LIBRARY_NAME.set("glfw_async");
                GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            customDataDirPrefix = "--data-dir=";
            String[] $i$f$any = arg;
            int element$iv = $i$f$any.length;
            for (int it = 0; it < element$iv; ++it) {
                String object2;
                String it2 = object2 = $i$f$any[it];
                boolean bl = false;
                if (!StringsKt.startsWith$default(it2, customDataDirPrefix, false, 2, null)) continue;
                string = object2;
                break block16;
            }
            string = null;
        }
        String customDataDir = string != null ? StringsKt.removePrefix(string, (CharSequence)customDataDirPrefix) : null;
        Log.INSTANCE.setBackend(new DesktopLogBackend());
        Display.INSTANCE.setPlatform(new DesktopDisplay());
        Fonts.INSTANCE.setFontImplementation(new DesktopFont());
        UncivFiles.Companion.setSaverLoader(LinuxX11SaverLoader.Companion.isRequired() ? (PlatformSaverLoader)new LinuxX11SaverLoader() : (PlatformSaverLoader)new DesktopSaverLoader());
        UncivFiles.Companion.setPreferExternalStorage(false);
        System.setProperty("org.lwjgl.opengl.Display.allowSoftwareOpenGL", "true");
        String string3 = customDataDir;
        if (string3 == null) {
            string3 = ".";
        }
        String dataDirectory = string3;
        boolean isRunFromJAR = INSTANCE.getClass().getPackage().getSpecificationVersion() != null;
        ImagePacker.INSTANCE.packImages(isRunFromJAR, dataDirectory);
        Lwjgl3ApplicationConfiguration config2 = new Lwjgl3ApplicationConfiguration();
        String[] it = new String[]{"ExtraImages/Icons/Unciv32.png", "ExtraImages/Icons/Unciv128.png"};
        config2.setWindowIcon(it);
        if (SharedLibraryLoader.os == Os.MacOsX) {
            INSTANCE.updateDockIconForMacOs("ExtraImages/Icons/Unciv128.png");
        }
        config2.setTitle("Unciv");
        config2.setHdpiMode(HdpiMode.Logical);
        config2.setWindowSizeLimits(120, 80, -1, -1);
        Rectangle maximumWindowBounds = DesktopScreenMode.Companion.getMaximumWindowBounds$desktop$default(DesktopScreenMode.Companion, null, 1, null);
        GameSettings settings = UncivFiles.Companion.getSettingsForPlatformLaunchers(dataDirectory);
        if (settings.isFreshlyCreated()) {
            settings.setScreenSize(GameSettings.ScreenSize.Large);
            settings.setWindowState(new GameSettings.WindowState(maximumWindowBounds));
            new FileHandle(dataDirectory + File.separator + "GameSettings.json").writeString(UncivJsonKt.json().toJson(settings), false, Charsets.UTF_8.name());
        }
        GameSettings.WindowState windowState = settings.getWindowState().coerceIn(maximumWindowBounds);
        int width = windowState.component1();
        int height = windowState.component2();
        config2.setWindowedMode(width, height);
        config2.setInitialBackgroundColor(BaseScreen.Companion.getClearColor());
        if (!isRunFromJAR) {
            new UniqueDocsWriter().write();
            new UiElementDocsWriter().write();
        }
        new HardenGdxAudio(new DesktopGame(config2, customDataDir), config2);
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void updateDockIconForMacOs(String fileName) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Intrinsics.checkNotNullExpressionValue(toolkit, "getDefaultToolkit(...)");
            Toolkit defaultToolkit = toolkit;
            URL uRL = new FileHandle(fileName).file().toURI().toURL();
            Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
            URL imageResource = uRL;
            Image image = defaultToolkit.getImage(imageResource);
            Intrinsics.checkNotNullExpressionValue(image, "getImage(...)");
            Image image2 = image;
            Taskbar taskbar = Taskbar.getTaskbar();
            taskbar.setIconImage(image2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

