/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0017\u001a\u00020\u0000J6\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2&\u0010\u0019\u001a\"\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001aj\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f`\u001bH\u0003J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dH\u0003J\u0018\u0010\u001e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001fH\u0007J\b\u0010 \u001a\u00020!H\u0003J\b\u0010\"\u001a\u00020\u0012H\u0007J\b\u0010#\u001a\u00020$H\u0007J\n\u0010%\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0007J\b\u0010+\u001a\u00020\u0012H\u0007R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006-"}, d2={"Lcom/unciv/logic/civilization/managers/VictoryManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "currentsSpaceshipParts", "Lcom/unciv/models/Counter;", "", "getCurrentsSpaceshipParts", "()Lcom/unciv/models/Counter;", "setCurrentsSpaceshipParts", "(Lcom/unciv/models/Counter;)V", "hasEverWonDiplomaticVote", "", "getHasEverWonDiplomaticVote", "()Z", "setHasEverWonDiplomaticVote", "(Z)V", "clone", "calculateDiplomaticVotingResults", "votesCast", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getVotingCivs", "Lkotlin/sequences/Sequence;", "getUNBuildingAndOwnerNames", "Lkotlin/Pair;", "votesNeededForDiplomaticVictory", "", "hasEnoughVotesForDiplomaticVictory", "getDiplomaticVictoryVoteBreakdown", "Lcom/unciv/logic/civilization/managers/VictoryManager$DiplomaticVictoryVoteBreakdown;", "getVictoryTypeAchieved", "getNextMilestone", "Lcom/unciv/models/ruleset/Milestone;", "victory", "Lcom/unciv/models/ruleset/Victory;", "amountMilestonesCompleted", "hasWon", "DiplomaticVictoryVoteBreakdown", "core"})
@SourceDebugExtension(value={"SMAP\nVictoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VictoryManager.kt\ncom/unciv/logic/civilization/managers/VictoryManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1#2:153\n630#3,3:154\n126#3:179\n153#3,3:180\n1011#4:157\n1045#4,3:158\n1048#4,3:168\n622#4:171\n382#5,7:161\n536#5:172\n521#5,6:173\n295#6,2:183\n*S KotlinDebug\n*F\n+ 1 VictoryManager.kt\ncom/unciv/logic/civilization/managers/VictoryManager\n*L\n87#1:154,3\n121#1:179\n121#1:180,3\n95#1:157\n95#1:158,3\n95#1:168,3\n96#1:171\n95#1:161,7\n120#1:172\n120#1:173,6\n122#1:183,2\n*E\n"})
public final class VictoryManager
implements IsPartOfGameInfoSerialization {
    public transient Civilization civInfo;
    @NotNull
    private Counter<String> currentsSpaceshipParts = new Counter(null, 1, null);
    private boolean hasEverWonDiplomaticVote;

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    @NotNull
    public final Counter<String> getCurrentsSpaceshipParts() {
        return this.currentsSpaceshipParts;
    }

    public final void setCurrentsSpaceshipParts(@NotNull Counter<String> counter) {
        Intrinsics.checkNotNullParameter(counter, "<set-?>");
        this.currentsSpaceshipParts = counter;
    }

    public final boolean getHasEverWonDiplomaticVote() {
        return this.hasEverWonDiplomaticVote;
    }

    public final void setHasEverWonDiplomaticVote(boolean bl) {
        this.hasEverWonDiplomaticVote = bl;
    }

    @NotNull
    public final VictoryManager clone() {
        VictoryManager toReturn = new VictoryManager();
        toReturn.currentsSpaceshipParts.putAll((Map)this.currentsSpaceshipParts);
        toReturn.hasEverWonDiplomaticVote = this.hasEverWonDiplomaticVote;
        return toReturn;
    }

    @Readonly
    private final Counter<String> calculateDiplomaticVotingResults(HashMap<String, String> votesCast) {
        Counter<String> results = new Counter<String>(null, 1, null);
        String civOwningUN = this.getUNBuildingAndOwnerNames().component2();
        for (Map.Entry entry : ((Map)votesCast).entrySet()) {
            String voter = (String)entry.getKey();
            String votedFor = (String)entry.getValue();
            if (votedFor == null) continue;
            results.add(votedFor, Intrinsics.areEqual(voter, civOwningUN) ? 2 : 1);
        }
        return results;
    }

    @Readonly
    private final Sequence<Civilization> getVotingCivs() {
        return SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)this.getCivInfo().getGameInfo().getCivilizations()), VictoryManager::getVotingCivs$lambda$0);
    }

    @Readonly
    @NotNull
    public final Pair<String, String> getUNBuildingAndOwnerNames() {
        Pair<Object, Object> pair = (Pair<Object, Object>)SequencesKt.firstOrNull(SequencesKt.flatMap(this.getVotingCivs(), VictoryManager::getUNBuildingAndOwnerNames$lambda$0));
        if (pair == null) {
            pair = TuplesKt.to(null, null);
        }
        return pair;
    }

    @Readonly
    private final int votesNeededForDiplomaticVictory() {
        String civOwningUN = this.getUNBuildingAndOwnerNames().component2();
        int voteCount = SequencesKt.count(this.getVotingCivs()) + (civOwningUN != null ? 1 : 0);
        if (voteCount > 28) {
            return voteCount * 35 / 100;
        }
        return voteCount * (67 - (int)(1.1 * (double)voteCount)) / 100 + 1;
    }

    @Readonly
    public final boolean hasEnoughVotesForDiplomaticVictory() {
        boolean bl;
        block11: {
            Object v0;
            Counter<String> results = this.calculateDiplomaticVotingResults(this.getCivInfo().getGameInfo().getDiplomaticVictoryVotesCast());
            Object object = ((Map)results).entrySet();
            Iterator iterator2 = object.iterator();
            if (!iterator2.hasNext()) {
                v0 = null;
            } else {
                Object t = iterator2.next();
                if (!iterator2.hasNext()) {
                    v0 = t;
                } else {
                    Map.Entry it22 = (Map.Entry)t;
                    boolean bl2 = false;
                    int it22 = ((Number)it22.getValue()).intValue();
                    do {
                        Object t2 = iterator2.next();
                        Map.Entry it = (Map.Entry)t2;
                        $i$a$-maxByOrNull-VictoryManager$hasEnoughVotesForDiplomaticVictory$bestCiv$1 = false;
                        int n = ((Number)it.getValue()).intValue();
                        if (it22 >= n) continue;
                        t = t2;
                        it22 = n;
                    } while (iterator2.hasNext());
                    v0 = t;
                }
            }
            Map.Entry entry = v0;
            if (entry == null) {
                return false;
            }
            Map.Entry bestCiv = entry;
            if (!Intrinsics.areEqual(bestCiv.getKey(), this.getCivInfo().getCivID())) {
                return false;
            }
            if (((Number)bestCiv.getValue()).intValue() < this.votesNeededForDiplomaticVictory()) {
                return false;
            }
            Map $this$none$iv = results;
            boolean $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                bl = true;
            } else {
                object = $this$none$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = (Map.Entry)object.next();
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual(it, bestCiv) && ((Number)it.getValue()).intValue() == ((Number)bestCiv.getValue()).intValue())) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @NotNull
    public final DiplomaticVictoryVoteBreakdown getDiplomaticVictoryVoteBreakdown() {
        void $this$sortedByDescending$iv;
        void $this$groupByTo$iv$iv;
        Sequence $this$groupBy$iv;
        Counter<String> results = this.calculateDiplomaticVotingResults(this.getCivInfo().getGameInfo().getDiplomaticVictoryVotesCast());
        Sequence sequence = MapsKt.asSequence((Map)results);
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv;
            boolean $i$a$-groupBy-VictoryManager$getDiplomaticVictoryVoteBreakdown$32 = false;
            Integer key$iv$iv = ((Number)it2.getValue()).intValue();
            Map map2 = destination$iv$iv;
            Integer key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Map.Entry $i$a$-groupBy-VictoryManager$getDiplomaticVictoryVoteBreakdown$32 = (Map.Entry)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl = false;
            list2.add((String)it.getKey());
        }
        $this$groupBy$iv = MapsKt.asSequence(destination$iv$iv);
        boolean $i$f$sortedByDescending = false;
        Map.Entry entry = (Map.Entry)SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getKey();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getKey()));
            }
        }));
        if (entry == null) {
            return new DiplomaticVictoryVoteBreakdown(results, "No valid votes were cast.");
        }
        Map.Entry entry2 = entry;
        int voteCount = ((Number)entry2.getKey()).intValue();
        List winnerList = (List)entry2.getValue();
        ArrayList lines2 = new ArrayList();
        int minVotes = this.votesNeededForDiplomaticVictory();
        if (voteCount < minVotes) {
            ((Collection)lines2).add("Minimum votes for electing a world leader: [" + minVotes + ']');
        }
        if (winnerList.size() > 1) {
            ((Collection)lines2).add("Tied in first position: [" + CollectionsKt.joinToString$default(winnerList, null, null, null, 0, null, VictoryManager::getDiplomaticVictoryVoteBreakdown$lambda$3, 31, null) + ']');
        }
        Civilization winnerCiv = this.getCivInfo().getGameInfo().getCivilization((String)CollectionsKt.first(winnerList));
        ((Collection)lines2).add(!((Collection)lines2).isEmpty() ? "No world leader was elected." : (Intrinsics.areEqual(winnerCiv, this.getCivInfo()) ? "You have been elected world leader!" : Nation.getLeaderDisplayName$default(winnerCiv.getNation(), null, 1, null) + " has been elected world leader!"));
        return new DiplomaticVictoryVoteBreakdown(results, CollectionsKt.joinToString$default(lines2, "\n", null, null, 0, null, VictoryManager::getDiplomaticVictoryVoteBreakdown$lambda$4, 30, null));
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    @Nullable
    public final String getVictoryTypeAchieved() {
        Victory victory;
        Object v0;
        block6: {
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Map $this$filterTo$iv$iv;
            if (!this.getCivInfo().isMajorCiv()) {
                return null;
            }
            ArrayList<String> enabledVictories = this.getCivInfo().getGameInfo().getGameParameters().getVictoryTypes();
            Map $this$filter$iv = this.getCivInfo().getGameInfo().getRuleset().getVictories();
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getKey(), "Neutral") && enabledVictories.contains(it.getKey()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add((Victory)it.getValue());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Victory it2 = (Victory)element$iv;
                boolean bl = false;
                if (!(this.getNextMilestone(it2) == null)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        Victory victory2 = victory = (Victory)v0;
        if (victory2 != null) {
            return victory2.getName();
        }
        if (Civilization.hasUnique$default(this.getCivInfo(), UniqueType.TriggersVictory, null, 2, null)) {
            return "Neutral";
        }
        return null;
    }

    @Readonly
    @Nullable
    public final Milestone getNextMilestone(@NotNull Victory victory) {
        Intrinsics.checkNotNullParameter(victory, "victory");
        for (Milestone milestone : victory.getMilestoneObjects()) {
            if (milestone.hasBeenCompletedBy(this.getCivInfo())) continue;
            return milestone;
        }
        return null;
    }

    @Readonly
    public final int amountMilestonesCompleted(@NotNull Victory victory) {
        Intrinsics.checkNotNullParameter(victory, "victory");
        int completed = 0;
        for (Milestone milestone : victory.getMilestoneObjects()) {
            if (!milestone.hasBeenCompletedBy(this.getCivInfo())) break;
            ++completed;
        }
        return completed;
    }

    @Readonly
    public final boolean hasWon() {
        return this.getVictoryTypeAchieved() != null;
    }

    private static final boolean getVotingCivs$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isBarbarian() || it.isSpectator() || it.isDefeated();
    }

    private static final Sequence getUNBuildingAndOwnerNames$lambda$0(Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        return SequencesKt.map(SequencesKt.filter(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)civ.getCities()), VictoryManager::getUNBuildingAndOwnerNames$lambda$0$0), VictoryManager::getUNBuildingAndOwnerNames$lambda$0$1), arg_0 -> VictoryManager.getUNBuildingAndOwnerNames$lambda$0$2(civ, arg_0));
    }

    private static final Sequence getUNBuildingAndOwnerNames$lambda$0$0(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCityConstructions().getBuiltBuildings();
    }

    private static final boolean getUNBuildingAndOwnerNames$lambda$0$1(Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.hasUnique(UniqueType.OneTimeTriggerVoting, GameContext.Companion.getIgnoreConditionals());
    }

    private static final Pair getUNBuildingAndOwnerNames$lambda$0$2(Civilization $civ, Building it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TuplesKt.to(it.getName(), $civ.getCivID());
    }

    private static final CharSequence getDiplomaticVictoryVoteBreakdown$lambda$3(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }

    private static final CharSequence getDiplomaticVictoryVoteBreakdown$lambda$4(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return '{' + it + '}';
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0004H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/civilization/managers/VictoryManager$DiplomaticVictoryVoteBreakdown;", "", "results", "Lcom/unciv/models/Counter;", "", "winnerText", "<init>", "(Lcom/unciv/models/Counter;Ljava/lang/String;)V", "getResults", "()Lcom/unciv/models/Counter;", "getWinnerText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class DiplomaticVictoryVoteBreakdown {
        @NotNull
        private final Counter<String> results;
        @NotNull
        private final String winnerText;

        public DiplomaticVictoryVoteBreakdown(@NotNull Counter<String> results, @NotNull String winnerText) {
            Intrinsics.checkNotNullParameter(results, "results");
            Intrinsics.checkNotNullParameter(winnerText, "winnerText");
            this.results = results;
            this.winnerText = winnerText;
        }

        @NotNull
        public final Counter<String> getResults() {
            return this.results;
        }

        @NotNull
        public final String getWinnerText() {
            return this.winnerText;
        }

        @NotNull
        public final Counter<String> component1() {
            return this.results;
        }

        @NotNull
        public final String component2() {
            return this.winnerText;
        }

        @NotNull
        public final DiplomaticVictoryVoteBreakdown copy(@NotNull Counter<String> results, @NotNull String winnerText) {
            Intrinsics.checkNotNullParameter(results, "results");
            Intrinsics.checkNotNullParameter(winnerText, "winnerText");
            return new DiplomaticVictoryVoteBreakdown(results, winnerText);
        }

        public static /* synthetic */ DiplomaticVictoryVoteBreakdown copy$default(DiplomaticVictoryVoteBreakdown diplomaticVictoryVoteBreakdown, Counter counter, String string, int n, Object object) {
            if ((n & 1) != 0) {
                counter = diplomaticVictoryVoteBreakdown.results;
            }
            if ((n & 2) != 0) {
                string = diplomaticVictoryVoteBreakdown.winnerText;
            }
            return diplomaticVictoryVoteBreakdown.copy(counter, string);
        }

        @NotNull
        public String toString() {
            return "DiplomaticVictoryVoteBreakdown(results=" + this.results + ", winnerText=" + this.winnerText + ')';
        }

        public int hashCode() {
            int result2 = this.results.hashCode();
            result2 = result2 * 31 + this.winnerText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiplomaticVictoryVoteBreakdown)) {
                return false;
            }
            DiplomaticVictoryVoteBreakdown diplomaticVictoryVoteBreakdown = (DiplomaticVictoryVoteBreakdown)other;
            if (!Intrinsics.areEqual(this.results, diplomaticVictoryVoteBreakdown.results)) {
                return false;
            }
            return Intrinsics.areEqual(this.winnerText, diplomaticVictoryVoteBreakdown.winnerText);
        }
    }
}

