/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0007J\u0018\u0010\n\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0007J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0007J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0007J\b\u0010\u0015\u001a\u00020\u0000H\u0007J\b\u0010\u0016\u001a\u00020\u0000H\u0007J\b\u0010\u0017\u001a\u00020\u0000H\u0007J\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006#"}, d2={"Lcom/unciv/logic/map/HexCoord;", "", "x", "", "y", "<init>", "(II)V", "getX", "()I", "getY", "plus", "hexCoord", "plusX", "plusY", "minus", "times", "int", "toVector2", "Lcom/badlogic/gdx/math/Vector2;", "eq", "", "cpy", "toHexCoord", "asSerializable", "toPrettyString", "", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "Companion", "Serializer", "core"})
public final class HexCoord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    @NotNull
    private static final HexCoord Zero = Companion.of(0, 0);

    public HexCoord(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public /* synthetic */ HexCoord(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @Pure
    @NotNull
    public final HexCoord plus(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return Companion.of(this.x + hexCoord.x, this.y + hexCoord.y);
    }

    @Pure
    @NotNull
    public final HexCoord plus(int plusX, int plusY) {
        return Companion.of(this.x + plusX, this.y + plusY);
    }

    @Pure
    @NotNull
    public final HexCoord minus(@NotNull HexCoord hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return Companion.of(this.x - hexCoord.x, this.y - hexCoord.y);
    }

    @Pure
    @NotNull
    public final HexCoord times(int n) {
        return Companion.of(this.x * n, this.y * n);
    }

    @Pure
    @NotNull
    public final Vector2 toVector2() {
        return new Vector2(this.x, this.y);
    }

    @Pure
    public final boolean eq(int x, int y) {
        return this.x == x && this.y == y;
    }

    @Pure
    @NotNull
    public final HexCoord cpy() {
        return this;
    }

    @Pure
    @NotNull
    public final HexCoord toHexCoord() {
        return this;
    }

    @Pure
    @NotNull
    public final HexCoord asSerializable() {
        return new HexCoord(this.x, this.y);
    }

    @NotNull
    public final String toPrettyString() {
        return "" + '(' + this.x + ',' + this.y + ')';
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    @NotNull
    public final HexCoord copy(int x, int y) {
        return new HexCoord(x, y);
    }

    public static /* synthetic */ HexCoord copy$default(HexCoord hexCoord, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = hexCoord.x;
        }
        if ((n3 & 2) != 0) {
            n2 = hexCoord.y;
        }
        return hexCoord.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "HexCoord(x=" + this.x + ", y=" + this.y + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.x);
        result2 = result2 * 31 + Integer.hashCode(this.y);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HexCoord)) {
            return false;
        }
        HexCoord hexCoord = (HexCoord)other;
        if (this.x != hexCoord.x) {
            return false;
        }
        return this.y == hexCoord.y;
    }

    public HexCoord() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/unciv/logic/map/HexCoord$Companion;", "", "<init>", "()V", "Zero", "Lcom/unciv/logic/map/HexCoord;", "getZero", "()Lcom/unciv/logic/map/HexCoord;", "of", "x", "", "y", "fromString", "string", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HexCoord getZero() {
            return Zero;
        }

        @Pure
        @NotNull
        public final HexCoord of(int x, int y) {
            return new HexCoord(x, y);
        }

        @NotNull
        public final HexCoord fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "string");
            int commaPos = StringsKt.indexOf$default((CharSequence)string, ',', 0, false, 6, null);
            if (commaPos < 1 || !StringsKt.startsWith$default((CharSequence)string, '(', false, 2, null) || !StringsKt.endsWith$default((CharSequence)string, ')', false, 2, null)) {
                throw new NumberFormatException('\"' + string + "\" is not a valid HexCoord representation");
            }
            String string2 = string.substring(1, commaPos);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            int x = Integer.parseInt(string2);
            String string3 = string.substring(commaPos + 1, string.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            int y = Integer.parseInt(string3);
            return new HexCoord(x, y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016J&\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/map/HexCoord$Serializer;", "Lcom/badlogic/gdx/utils/Json$Serializer;", "Lcom/unciv/logic/map/HexCoord;", "<init>", "()V", "write", "", "json", "Lcom/badlogic/gdx/utils/Json;", "coord", "knownType", "Ljava/lang/Class;", "read", "jsonData", "Lcom/badlogic/gdx/utils/JsonValue;", "type", "core"})
    public static final class Serializer
    implements Json.Serializer<HexCoord> {
        @Override
        public void write(@NotNull Json json, @NotNull HexCoord coord, @Nullable Class<?> knownType) {
            Intrinsics.checkNotNullParameter(json, "json");
            Intrinsics.checkNotNullParameter(coord, "coord");
            json.writeObjectStart();
            if (coord.getX() != 0) {
                json.writeValue("x", coord.getX());
            }
            if (coord.getY() != 0) {
                json.writeValue("y", coord.getY());
            }
            json.writeObjectEnd();
        }

        @Override
        @NotNull
        public HexCoord read(@NotNull Json json, @NotNull JsonValue jsonData, @Nullable Class<?> type) {
            Intrinsics.checkNotNullParameter(json, "json");
            Intrinsics.checkNotNullParameter(jsonData, "jsonData");
            Float x = json.readValue("x", Float.TYPE, Float.valueOf(0.0f), jsonData);
            Float y = json.readValue("y", Float.TYPE, Float.valueOf(0.0f), jsonData);
            return new HexCoord((int)x.floatValue(), (int)y.floatValue());
        }
    }
}

