/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.badlogic.gdx.math.Rectangle;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.mapregions.MapGenTileData;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegionsKt;
import com.unciv.logic.map.mapgenerator.mapregions.MinorCivPlacer;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapgenerator.mapregions.RegionStartFinder;
import com.unciv.logic.map.mapgenerator.mapregions.StartNormalizer;
import com.unciv.logic.map.mapgenerator.mapregions.TileDataMap;
import com.unciv.logic.map.mapgenerator.resourceplacement.LuxuryResourcePlacementLogic;
import com.unciv.logic.map.mapgenerator.resourceplacement.StrategicBonusResourcePlacementLogic;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.utils.Log;
import com.unciv.utils.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u0003012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J$\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u000fH\u0002J,\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010(\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\u001dH\u0002J\u001c\u0010-\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u0010\u0010/\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "<init>", "(Lcom/unciv/models/ruleset/Ruleset;)V", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "regions", "Ljava/util/ArrayList;", "Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "Lkotlin/collections/ArrayList;", "tileData", "Lcom/unciv/logic/map/mapgenerator/mapregions/TileDataMap;", "generateRegions", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "numRegions", "", "divideRegion", "region", "numDivisions", "splitRegion", "Lkotlin/Pair;", "regionToSplit", "firstPercent", "assignRegions", "civilizations", "", "Lcom/unciv/logic/civilization/Civilization;", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "assignRegionTypes", "logAssignRegion", "success", "", "startBiasType", "Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$BiasTypes;", "civ", "assignCivToRegion", "getFallbackRegion", "type", "", "candidates", "placeResourcesAndMinorCivs", "minorCivs", "placeNaturalWonderImpacts", "Companion", "BiasTypes", "ImpactType", "core"})
@SourceDebugExtension(value={"SMAP\nMapRegions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapRegions.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MapRegions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,521:1\n1999#2,14:522\n774#2:536\n865#2,2:537\n295#2,2:540\n1056#2:542\n1285#2,2:543\n1299#2,4:545\n1504#2:549\n1534#2,2:550\n1761#2,3:552\n1536#2:555\n1537#2,3:563\n1056#2:566\n1068#2:567\n774#2:568\n865#2,2:569\n1999#2,14:571\n774#2:585\n865#2:586\n866#2:589\n1999#2,14:590\n774#2:604\n865#2,2:605\n1999#2,14:607\n774#2:621\n865#2:622\n866#2:625\n1999#2,14:626\n774#2:640\n865#2,2:641\n1999#2,5:643\n2005#2,8:655\n3301#2,10:663\n1563#2:673\n1634#2,3:674\n827#2:677\n855#2,2:678\n2423#2,5:680\n2429#2,2:699\n2431#2,6:715\n774#2:721\n865#2,2:722\n1056#2:724\n1999#2,14:731\n774#2:745\n865#2,2:746\n1#3:539\n382#4,7:556\n488#4,7:648\n488#4,7:685\n488#4,7:692\n488#4,7:701\n488#4,7:708\n1255#5,2:587\n1255#5,2:623\n1255#5,2:725\n1255#5,2:727\n1255#5,2:729\n*S KotlinDebug\n*F\n+ 1 MapRegions.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MapRegions\n*L\n135#1:522,14\n144#1:536\n144#1:537,2\n238#1:540,2\n243#1:542\n249#1:543,2\n249#1:545,4\n251#1:549\n251#1:550,2\n256#1:552,3\n251#1:555\n251#1:563,3\n268#1:566\n271#1:567\n282#1:568\n282#1:569,2\n283#1:571,14\n291#1:585\n291#1:586\n291#1:589\n292#1:590,14\n300#1:604\n300#1:605,2\n301#1:607,14\n309#1:621\n309#1:622\n309#1:625\n310#1:626,14\n326#1:640\n326#1:641,2\n327#1:643,5\n327#1:655,8\n352#1:663,10\n353#1:673\n353#1:674,3\n356#1:677\n356#1:678,2\n357#1:680,5\n357#1:699,2\n357#1:715,6\n384#1:721\n384#1:722,2\n385#1:724\n436#1:731,14\n452#1:745\n452#1:746,2\n251#1:556,7\n327#1:648,7\n358#1:685,7\n359#1:692,7\n358#1:701,7\n359#1:708,7\n291#1:587,2\n309#1:623,2\n392#1:725,2\n398#1:727,2\n401#1:729,2\n*E\n"})
public final class MapRegions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final ArrayList<Region> regions;
    @NotNull
    private final TileDataMap tileData;
    @NotNull
    private static final Map<Integer, Integer> minimumFoodForRing;
    @NotNull
    private static final Map<Integer, Integer> minimumProdForRing;
    @NotNull
    private static final Map<Integer, Integer> minimumGoodForRing;
    public static final int maximumJunk = 9;
    @NotNull
    private static final List<Integer> firstRingFoodScores;
    @NotNull
    private static final List<Integer> firstRingProdScores;
    @NotNull
    private static final List<Integer> secondRingFoodScores;
    @NotNull
    private static final List<Integer> secondRingProdScores;
    @NotNull
    private static final Map<Integer, Integer> closeStartPenaltyForRing;
    @NotNull
    private static final Map<Integer, List<Float>> randomLuxuryRatios;
    public static final int baseMinorDepositFrequency = 30;

    public MapRegions(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.ruleset = ruleset;
        this.regions = new ArrayList();
        this.tileData = new TileDataMap();
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateRegions(@NotNull TileMap tileMap, int numRegions) {
        Object $i$f$maxByOrNull22;
        Iterator iterator2;
        Object object;
        Object object2;
        float f;
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        if (numRegions <= 0) {
            return;
        }
        if (tileMap.getContinentSizes().isEmpty()) {
            throw new Exception("No Continents on this map!");
        }
        if (Intrinsics.areEqual(tileMap.getMapParameters().getShape(), "Hexagonal") || Intrinsics.areEqual(tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal")) {
            f = tileMap.getMapParameters().getMapSize().getRadius();
        } else {
            int n = tileMap.getMapParameters().getMapSize().getWidth() / 2;
            int n2 = tileMap.getMapParameters().getMapSize().getHeight() / 2;
            f = Math.max(n, n2);
        }
        float radius = f;
        Rectangle mapRect = new Rectangle(-radius, -radius, radius * (float)2 + 1.0f, radius * (float)2 + 1.0f);
        if (tileMap.usingArchipelagoRegions()) {
            Region hugeRect = new Region(tileMap, mapRect, -1);
            hugeRect.setAffectedByWorldWrap(false);
            Region.updateTiles$default(hugeRect, false, 1, null);
            this.divideRegion(hugeRect, numRegions);
            return;
        }
        Set<Integer> set = tileMap.getContinentSizes().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        List continents = CollectionsKt.toMutableList((Collection)set);
        HashMap civsAddedToContinent = new HashMap();
        HashMap continentFertility = new HashMap();
        HashMap continentToColumnsItsIn = new HashMap();
        for (Tile tile : tileMap.getValues()) {
            int continent = tile.getContinent();
            if (continent == -1) continue;
            object2 = continentFertility;
            object = continent;
            Integer n = (Integer)continentFertility.get(continent);
            iterator2 = MapRegionsKt.getTileFertility(tile, true) + (n != null ? n : 0);
            object2.put(object, iterator2);
            if (continentToColumnsItsIn.get(continent) == null) {
                object2 = continentToColumnsItsIn;
                object = continent;
                iterator2 = new HashSet();
                object2.put(object, iterator2);
            }
            Object v = continentToColumnsItsIn.get(continent);
            Intrinsics.checkNotNull(v);
            ((HashSet)v).add(tile.getColumn());
        }
        for (int i = 0; i < numRegions; ++i) {
            Object v4;
            Map $this$maxByOrNull$iv;
            int it = i;
            boolean bl = false;
            object2 = continents;
            boolean $i$f$maxByOrNull22 = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v4 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v4 = maxElem$iv;
                } else {
                    Integer it2 = (Integer)maxElem$iv;
                    boolean bl2 = false;
                    Object v = continentFertility.get(it2);
                    Intrinsics.checkNotNull(v);
                    Integer n = (Integer)civsAddedToContinent.get(it2);
                    int maxValue$iv = ((Number)v).intValue() / (1 + (n != null ? n : 0));
                    do {
                        Object e$iv = iterator$iv.next();
                        Integer it3 = (Integer)e$iv;
                        $i$a$-maxByOrNull-MapRegions$generateRegions$1$bestContinent$1 = false;
                        Object v2 = continentFertility.get(it3);
                        Intrinsics.checkNotNull(v2);
                        Integer n3 = (Integer)civsAddedToContinent.get(it3);
                        int v$iv = ((Number)v2).intValue() / (1 + (n3 != null ? n3 : 0));
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v4 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v4);
            int bestContinent = ((Number)v4).intValue();
            $this$maxByOrNull$iv = civsAddedToContinent;
            $i$f$maxByOrNull22 = bestContinent;
            Integer n = (Integer)civsAddedToContinent.get(bestContinent);
            iterator$iv = (n != null ? n : 0) + 1;
            $this$maxByOrNull$iv.put($i$f$maxByOrNull22, iterator$iv);
        }
        for (Object k : civsAddedToContinent.keySet()) {
            int it;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullExpressionValue(k, "next(...)");
            int continent = ((Number)k).intValue();
            Region continentRegion = new Region(tileMap, new Rectangle(mapRect), continent);
            Object v = continentToColumnsItsIn.get(continent);
            Intrinsics.checkNotNull(v);
            HashSet cols = (HashSet)v;
            $i$f$maxByOrNull22 = cols;
            Rectangle rectangle = continentRegion.getRect();
            boolean $i$f$filter = false;
            void maxElem$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it4 = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(!cols.contains(it4 - 1))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
            iterator2 = object.iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            int it5 = ((Number)iterator2.next()).intValue();
            boolean bl = false;
            while (iterator2.hasNext()) {
                it = ((Number)iterator2.next()).intValue();
                $i$a$-maxOf-MapRegions$generateRegions$3 = false;
                if (it5 >= it) continue;
                it5 = it;
            }
            int n = it5;
            rectangle.x = n;
            continentRegion.getRect().width = cols.size();
            if (tileMap.getMapParameters().getWorldWrap()) {
                iterator2 = ((Iterable)cols).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                it5 = ((Number)iterator2.next()).intValue();
                boolean bl3 = false;
                int n4 = it5;
                while (iterator2.hasNext()) {
                    it = ((Number)iterator2.next()).intValue();
                    $i$a$-minOf-MapRegions$generateRegions$4 = false;
                    int n5 = it;
                    if (n4 <= n5) continue;
                    n4 = n5;
                }
                if ((float)n4 < continentRegion.getRect().x) {
                    continentRegion.setAffectedByWorldWrap(true);
                }
            }
            Region.updateTiles$default(continentRegion, false, 1, null);
            Object v3 = civsAddedToContinent.get(continent);
            Intrinsics.checkNotNull(v3);
            this.divideRegion(continentRegion, ((Number)v3).intValue());
        }
    }

    private final void divideRegion(Region region, int numDivisions) {
        if (numDivisions <= 1) {
            this.regions.add(region);
            return;
        }
        int firstDivisions = numDivisions / 2;
        Pair<Region, Region> splitRegions = this.splitRegion(region, 100 * firstDivisions / numDivisions);
        this.divideRegion(splitRegions.getFirst(), firstDivisions);
        this.divideRegion(splitRegions.getSecond(), numDivisions - firstDivisions);
    }

    private final Pair<Region, Region> splitRegion(Region regionToSplit, int firstPercent) {
        int n;
        int targetFertility = regionToSplit.getTotalFertility() * firstPercent / 100;
        Region splitOffRegion = new Region(regionToSplit.getTileMap(), new Rectangle(regionToSplit.getRect()), regionToSplit.getContinentID());
        boolean widerThanTall = regionToSplit.getRect().width > regionToSplit.getRect().height;
        int bestSplitPoint = 1;
        int closestFertility = 0;
        int cumulativeFertility = 0;
        int highestPointToTry = widerThanTall ? (int)regionToSplit.getRect().width : (int)regionToSplit.getRect().height;
        IntRange pointsToTry = new IntRange(1, highestPointToTry);
        int halfwayPoint = highestPointToTry / 2;
        int splitPoint = pointsToTry.getFirst();
        if (splitPoint <= (n = pointsToTry.getLast())) {
            while (true) {
                int n2;
                int n3;
                int n4;
                Tile it;
                int n5;
                Tile tile;
                Iterator<Tile> iterator2;
                int n6;
                int n7;
                Sequence<Tile> sequence;
                Sequence<Tile> nextRect;
                Sequence<Tile> sequence2 = nextRect = widerThanTall ? splitOffRegion.getTileMap().getTilesInRectangle(new Rectangle(splitOffRegion.getRect().x + (float)splitPoint - 1.0f, splitOffRegion.getRect().y, 1.0f, splitOffRegion.getRect().height)) : splitOffRegion.getTileMap().getTilesInRectangle(new Rectangle(splitOffRegion.getRect().x, splitOffRegion.getRect().y + (float)splitPoint - 1.0f, splitOffRegion.getRect().width, 1.0f));
                if (splitOffRegion.getContinentID() == -1) {
                    sequence = nextRect;
                    n7 = cumulativeFertility;
                    n6 = 0;
                    iterator2 = sequence.iterator();
                    while (iterator2.hasNext()) {
                        Tile tile2 = tile = iterator2.next();
                        n5 = n6;
                        boolean bl = false;
                        n4 = MapRegionsKt.getTileFertility(it, false);
                        n6 = n5 + n4;
                    }
                    n5 = n6;
                    n3 = n7;
                    n2 = n5;
                } else {
                    sequence = nextRect;
                    n6 = 0;
                    iterator2 = sequence.iterator();
                    while (iterator2.hasNext()) {
                        it = tile = iterator2.next();
                        n5 = n6;
                        boolean bl = false;
                        n4 = it.getContinent() == splitOffRegion.getContinentID() ? MapRegionsKt.getTileFertility(it, true) : 0;
                        n6 = n5 + n4;
                    }
                    n5 = n6;
                    n3 = n7;
                    n2 = n5;
                }
                cumulativeFertility = n3 + n2;
                int bestSplitPointFertilityDeltaFromTarget = Math.abs(closestFertility - targetFertility);
                int currentSplitPointFertilityDeltaFromTarget = Math.abs(cumulativeFertility - targetFertility);
                if (currentSplitPointFertilityDeltaFromTarget < bestSplitPointFertilityDeltaFromTarget || currentSplitPointFertilityDeltaFromTarget == bestSplitPointFertilityDeltaFromTarget && Math.abs(halfwayPoint - splitPoint) < Math.abs(halfwayPoint - bestSplitPoint)) {
                    bestSplitPoint = splitPoint;
                    closestFertility = cumulativeFertility;
                }
                if (splitPoint == n) break;
                ++splitPoint;
            }
        }
        if (widerThanTall) {
            splitOffRegion.getRect().width = bestSplitPoint;
            regionToSplit.getRect().x = splitOffRegion.getRect().x + splitOffRegion.getRect().width;
            regionToSplit.getRect().width -= (float)bestSplitPoint;
        } else {
            splitOffRegion.getRect().height = bestSplitPoint;
            regionToSplit.getRect().y = splitOffRegion.getRect().y + splitOffRegion.getRect().height;
            regionToSplit.getRect().height -= (float)bestSplitPoint;
        }
        Region.updateTiles$default(splitOffRegion, false, 1, null);
        Region.updateTiles$default(regionToSplit, false, 1, null);
        return new Pair<Region, Region>(splitOffRegion, regionToSplit);
    }

    /*
     * Could not resolve type clashes
     * Iterators could be improved
     * Unable to fully structure code
     */
    public final void assignRegions(@NotNull TileMap tileMap, @NotNull List<Civilization> civilizations, @NotNull GameParameters gameParameters) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(civilizations, "civilizations");
        Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
        if (civilizations.isEmpty()) {
            return;
        }
        this.assignRegionTypes();
        for (Tile tile : tileMap.getValues()) {
            block77: {
                var7_12 = this.regions;
                var39_11 = tile;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Region)element$iv;
                    $i$a$-firstOrNull-MapRegions$assignRegions$newData$1 = false;
                    if (!it.getTiles().contains(tile)) continue;
                    v0 = element$iv;
                    break block77;
                }
                v0 = null;
            }
            var40_15 = this.ruleset;
            var41_20 = v0;
            var42_22 = var39_11;
            newData = new MapGenTileData(var42_22, var41_20, var40_15);
            ((Map)this.tileData).put(tile.getPosition(), newData);
        }
        $this$sortedBy$iv = this.regions;
        $i$f$sortedBy = false;
        sortedRegions = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Region it = (Region)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTotalFertility());
                it = (Region)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTotalFertility());
            }
        });
        for (Region region : sortedRegions) {
            RegionStartFinder.INSTANCE.findStart$core(region, this.tileData);
        }
        v1 = this.regions.iterator();
        Intrinsics.checkNotNullExpressionValue(v1, "iterator(...)");
        $this$sortedBy$iv = v1;
        while ($this$sortedBy$iv.hasNext()) {
            Intrinsics.checkNotNullExpressionValue($this$sortedBy$iv.next(), "next(...)");
            v2 = region.getStartPosition();
            Intrinsics.checkNotNull(v2);
            StartNormalizer.INSTANCE.normalizeStart(tileMap.get(v2), tileMap, this.tileData, this.ruleset, false);
        }
        $this$associateWith$iv = civilizations;
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        var9_21 = $this$associateWith$iv;
        destination$iv$iv = result$iv;
        $i$f$associateWithTo = false;
        for (T element$iv$iv : $this$associateWithTo$iv$iv) {
            var14_40 = (Civilization)element$iv$iv;
            var38_36 = element$iv$iv;
            var37_35 = destination$iv$iv;
            $i$a$-associateWith-MapRegions$assignRegions$civBiases$1 = false;
            v3 = this.ruleset.getNations().get(it.getCivName());
            Intrinsics.checkNotNull(v3);
            var39_11 = v3.getStartBias();
            var37_35.put(var38_36, var39_11);
        }
        civBiases = destination$iv$iv;
        $this$groupBy$iv = civBiases.entrySet();
        $i$f$groupBy = false;
        $this$associateWithTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-groupBy-MapRegions$assignRegions$civsByBiasType$1 = false;
            startBias = (ArrayList)it.getValue();
            if (gameParameters.getNoStartBias()) {
                v4 = BiasTypes.Random;
            } else {
                block78: {
                    $this$any$iv = startBias;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v5 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            bias = (String)element$iv;
                            $i$a$-any-MapRegions$assignRegions$civsByBiasType$1$1 = false;
                            if (!TranslationsKt.equalsPlaceholderText(bias, "Avoid []")) continue;
                            v5 = true;
                            break block78;
                        }
                        v5 = false;
                    }
                }
                v4 = v5 ? BiasTypes.Negative : (startBias.contains("Coast") ? BiasTypes.Coastal : (((Collection)startBias).isEmpty() == false ? BiasTypes.Positive : BiasTypes.Random));
            }
            key$iv$iv = v4;
            var24_110 = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv /* !! */  = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv$iv);
            if (value$iv$iv$iv /* !! */  == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$2$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                v6 /* !! */  = answer$iv$iv$iv;
            } else {
                v6 /* !! */  = value$iv$iv$iv /* !! */ ;
            }
            list$iv$iv = (List)v6 /* !! */ ;
            it = (Map.Entry)element$iv$iv;
            var37_35 = list$iv$iv;
            $i$a$-groupBy-MapRegions$assignRegions$civsByBiasType$2 = false;
            civ = (Civilization)it.getKey();
            var37_35.add(civ);
        }
        civsByBiasType = destination$iv$iv;
        v7 = (List<T>)civsByBiasType.get((Object)BiasTypes.Coastal);
        if (v7 == null) {
            v7 = coastBiasCivs = CollectionsKt.emptyList();
        }
        if (($this$groupByTo$iv$iv = (List)civsByBiasType.get((Object)BiasTypes.Positive)) == null) ** GOTO lbl-1000
        $i$f$groupByTo = $this$groupByTo$iv$iv;
        $i$f$sortedBy = false;
        destination$iv$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(civBiases){
            final /* synthetic */ Map $civBiases$inlined;
            {
                this.$civBiases$inlined = map2;
            }

            public final int compare(T a, T b) {
                Civilization it = (Civilization)a;
                boolean bl = false;
                ArrayList arrayList = (ArrayList)this.$civBiases$inlined.get(it);
                it = (Civilization)b;
                Comparable comparable = arrayList != null ? Integer.valueOf(arrayList.size()) : null;
                bl = false;
                ArrayList arrayList2 = (ArrayList)this.$civBiases$inlined.get(it);
                return ComparisonsKt.compareValues(comparable, (Comparable)(arrayList2 != null ? Integer.valueOf(arrayList2.size()) : null));
            }
        });
        if (destination$iv$iv != null) {
            v8 = destination$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v8 = CollectionsKt.emptyList();
        }
        positiveBiasCivs = v8;
        destination$iv$iv = (List)civsByBiasType.get((Object)BiasTypes.Negative);
        if (destination$iv$iv == null) ** GOTO lbl-1000
        $i$f$sortedBy = destination$iv$iv;
        $i$f$sortedByDescending = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(civBiases){
            final /* synthetic */ Map $civBiases$inlined;
            {
                this.$civBiases$inlined = map2;
            }

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                ArrayList arrayList = (ArrayList)this.$civBiases$inlined.get(it);
                it = (Civilization)a;
                Comparable comparable = arrayList != null ? Integer.valueOf(arrayList.size()) : null;
                bl = false;
                ArrayList arrayList2 = (ArrayList)this.$civBiases$inlined.get(it);
                return ComparisonsKt.compareValues(comparable, (Comparable)(arrayList2 != null ? Integer.valueOf(arrayList2.size()) : null));
            }
        });
        if ($this$sortedBy$iv != null) {
            v9 = $this$sortedBy$iv;
        } else lbl-1000:
        // 2 sources

        {
            v9 = CollectionsKt.emptyList();
        }
        negativeBiasCivs = v9;
        $this$sortedBy$iv = (List)civsByBiasType.get((Object)BiasTypes.Random);
        randomCivs = $this$sortedBy$iv != null && ($this$sortedByDescending$iv = CollectionsKt.toMutableList($this$sortedBy$iv)) != null ? $this$sortedByDescending$iv : (List<T>)new ArrayList<E>();
        positiveBiasFallbackCivs = new ArrayList<E>();
        unpickedRegions = CollectionsKt.toMutableList((Collection)this.regions);
        for (Civilization civ : coastBiasCivs) {
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            $i$f$any = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                it = (Region)element$iv$iv;
                $i$a$-filter-MapRegions$assignRegions$startRegion$1 = false;
                v10 = it.getStartPosition();
                Intrinsics.checkNotNull(v10);
                if (!tileMap.get(v10).isCoastalTile()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v11 = null;
            } else {
                maxElem$iv /* !! */  = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v11 = maxElem$iv /* !! */ ;
                } else {
                    it = (Region)maxElem$iv /* !! */ ;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$startRegion$2 = false;
                    v12 = it.getTerrainCounts().get("Coastal");
                    maxValue$iv = v12 != null ? v12 : 0;
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (Region)e$iv /* !! */ ;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$startRegion$2 = false;
                        v13 = it.getTerrainCounts().get("Coastal");
                        v14 = v$iv = v13 != null ? v13 : 0;
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv /* !! */  = e$iv /* !! */ ;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v11 = maxElem$iv /* !! */ ;
                }
            }
            startRegion = (Region)v11;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Coastal, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                block79: {
                    it = (Region)element$iv$iv;
                    $i$a$-filter-MapRegions$assignRegions$1 = false;
                    v15 = it.getStartPosition();
                    Intrinsics.checkNotNull(v15);
                    $this$any$iv = tileMap.get(v15).getNeighbors();
                    $i$f$any = false;
                    value$iv$iv$iv /* !! */  = $this$any$iv.iterator();
                    while (value$iv$iv$iv /* !! */ .hasNext()) {
                        element$iv = value$iv$iv$iv /* !! */ .next();
                        neighbor = (Tile)element$iv;
                        $i$a$-any-MapRegions$assignRegions$1$1 = false;
                        if (!IHasUniques.hasUnique$default(neighbor.getBaseTerrain(), UniqueType.FreshWater, null, 2, null)) continue;
                        v16 = true;
                        break block79;
                    }
                    v16 = false;
                }
                if (!v16) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v17 = null;
            } else {
                maxElem$iv /* !! */  = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v17 = maxElem$iv /* !! */ ;
                } else {
                    it = (Region)maxElem$iv /* !! */ ;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$2 = false;
                    v18 = it.getTerrainCounts().get("Coastal");
                    maxValue$iv = v18 != null ? v18 : 0;
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (Region)e$iv /* !! */ ;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$2 = false;
                        v19 = it.getTerrainCounts().get("Coastal");
                        v20 = v$iv = v19 != null ? v19 : 0;
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv /* !! */  = e$iv /* !! */ ;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v17 = maxElem$iv /* !! */ ;
                }
            }
            startRegion = (Region)v17;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Coastal, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Region)element$iv$iv;
                $i$a$-filter-MapRegions$assignRegions$3 = false;
                v21 = it.getStartPosition();
                Intrinsics.checkNotNull(v21);
                if (!tileMap.get(v21).isAdjacentToRiver()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v22 = null;
            } else {
                maxElem$iv /* !! */  = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v22 = maxElem$iv /* !! */ ;
                } else {
                    it = (Region)maxElem$iv /* !! */ ;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$4 = false;
                    v23 = it.getTerrainCounts().get("Coastal");
                    maxValue$iv = v23 != null ? v23 : 0;
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (Region)e$iv /* !! */ ;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$4 = false;
                        v24 = it.getTerrainCounts().get("Coastal");
                        v25 = v$iv = v24 != null ? v24 : 0;
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv /* !! */  = e$iv /* !! */ ;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v22 = maxElem$iv /* !! */ ;
                }
            }
            startRegion = (Region)v22;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Coastal, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                block80: {
                    it = (Region)element$iv$iv;
                    $i$a$-filter-MapRegions$assignRegions$5 = false;
                    v26 = it.getStartPosition();
                    Intrinsics.checkNotNull(v26);
                    $this$any$iv = tileMap.get(v26).getNeighbors();
                    $i$f$any = false;
                    value$iv$iv$iv /* !! */  = $this$any$iv.iterator();
                    while (value$iv$iv$iv /* !! */ .hasNext()) {
                        element$iv = value$iv$iv$iv /* !! */ .next();
                        neighbor = (Tile)element$iv;
                        $i$a$-any-MapRegions$assignRegions$5$1 = false;
                        if (!neighbor.isAdjacentToRiver()) continue;
                        v27 = true;
                        break block80;
                    }
                    v27 = false;
                }
                if (!v27) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v28 /* !! */  = null;
            } else {
                maxElem$iv /* !! */  = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v28 /* !! */  = maxElem$iv /* !! */ ;
                } else {
                    it = (Region)maxElem$iv /* !! */ ;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$6 = false;
                    v29 = it.getTerrainCounts().get("Coastal");
                    maxValue$iv = v29 != null ? v29 : 0;
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (Region)e$iv /* !! */ ;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$6 = false;
                        v30 = it.getTerrainCounts().get("Coastal");
                        v31 = v$iv = v30 != null ? v30 : 0;
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv /* !! */  = e$iv /* !! */ ;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v28 /* !! */  = maxElem$iv /* !! */ ;
                }
            }
            startRegion = (Region)v28 /* !! */ ;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Coastal, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            MapRegions.logAssignRegion$default(this, false, BiasTypes.Coastal, civ, null, 8, null);
            randomCivs.add(civ);
        }
        for (Civilization civ : positiveBiasCivs) {
            v32 = civBiases.get(civ);
            Intrinsics.checkNotNull(v32);
            preferred = (ArrayList)v32;
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            maxElem$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Region)element$iv$iv;
                $i$a$-filter-MapRegions$assignRegions$startRegion$3 = false;
                if (!preferred.contains(it.getType())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v33 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v33 = maxElem$iv;
                } else {
                    it = (Region)maxElem$iv;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$startRegion$4 = false;
                    $this$filterKeys$iv = it.getTerrainCounts();
                    $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        terrain = (String)entry$iv.getKey();
                        $i$a$-filterKeys-MapRegions$assignRegions$startRegion$4$1 = false;
                        if (!preferred.contains(terrain)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    maxValue$iv = CollectionsKt.sumOfInt((Iterable<Integer>)((Map)result$iv).values());
                    do {
                        e$iv = iterator$iv.next();
                        it = (Region)e$iv;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$startRegion$4 = false;
                        $this$filterKeys$iv = it.getTerrainCounts();
                        $i$f$filterKeys = false;
                        result$iv = new LinkedHashMap<K, V>();
                        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                            terrain = (String)entry$iv.getKey();
                            $i$a$-filterKeys-MapRegions$assignRegions$startRegion$4$1 = false;
                            if (!preferred.contains(terrain)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        v$iv = CollectionsKt.sumOfInt((Iterable<Integer>)((Map)result$iv).values());
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v33 = maxElem$iv;
                }
            }
            startRegion = v33;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Positive, civ, (Region)startRegion);
                this.assignCivToRegion(civ, (Region)startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            if (preferred.size() == 1) {
                v34 = positiveBiasFallbackCivs.add(civ);
                continue;
            }
            MapRegions.logAssignRegion$default(this, false, BiasTypes.Positive, civ, null, 8, null);
            v34 = randomCivs.add(civ);
        }
        for (Object v35 : positiveBiasFallbackCivs) {
            Intrinsics.checkNotNullExpressionValue(v35, "next(...)");
            civ = (Civilization)v35;
            v36 = civBiases.get(civ);
            Intrinsics.checkNotNull(v36);
            startRegion = this.getFallbackRegion((String)CollectionsKt.first((List)v36), unpickedRegions);
            this.logAssignRegion(true, BiasTypes.PositiveFallback, civ, startRegion);
            this.assignCivToRegion(civ, startRegion);
            unpickedRegions.remove(startRegion);
        }
        for (Civilization civ : negativeBiasCivs) {
            v37 = civBiases.get(civ);
            Intrinsics.checkNotNull(v37);
            startRegion = (Iterable)v37;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                bias = (String)element$iv;
                $i$a$-partition-MapRegions$assignRegions$7 = false;
                v38 = TranslationsKt.equalsPlaceholderText(bias, "Avoid []") != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            startRegion = new Pair<ArrayList<E>, ArrayList<E>>(first$iv, second$iv);
            avoidBias = startRegion.component1();
            preferred = startRegion.component2();
            $this$map$iv = avoidBias;
            $i$f$map = false;
            element$iv = $this$map$iv;
            destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $i$f$filterKeys = (String)item$iv$iv;
                var37_35 = destination$iv$iv /* !! */ ;
                $i$a$-map-MapRegions$assignRegions$avoided$1 = false;
                var37_35.add(TranslationsKt.getPlaceholderParameters((String)it).get(0));
            }
            avoided = (List)destination$iv$iv /* !! */ ;
            $this$filterNot$iv = unpickedRegions;
            $i$f$filterNot = false;
            destination$iv$iv /* !! */  = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            item$iv$iv = $this$filterNotTo$iv$iv.iterator();
            while (item$iv$iv.hasNext()) {
                element$iv$iv = item$iv$iv.next();
                it = (Region)element$iv$iv;
                $i$a$-filterNot-MapRegions$assignRegions$startRegion$5 = false;
                if (avoided.contains(it.getType())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v39 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v39 = minElem$iv;
                } else {
                    it = (Region)minElem$iv;
                    $i$a$-minByOrNull-MapRegions$assignRegions$startRegion$6 = false;
                    element$iv$iv = it.getTerrainCounts();
                    it = 2;
                    $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        terrain = (String)entry$iv.getKey();
                        $i$a$-filterKeys-MapRegions$assignRegions$startRegion$6$1 = false;
                        if (!avoided.contains(terrain)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    var34_155 = result$iv;
                    it * CollectionsKt.sumOfInt((Iterable<Integer>)var34_155.values());
                    $this$filterKeys$iv = it.getTerrainCounts();
                    $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        terrain = (String)entry$iv.getKey();
                        $i$a$-filterKeys-MapRegions$assignRegions$startRegion$6$2 = false;
                        if (!preferred.contains(terrain)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    minValue$iv = -CollectionsKt.sumOfInt((Iterable<Integer>)((Map)result$iv).values());
                    do {
                        e$iv = iterator$iv.next();
                        it = (Region)e$iv;
                        $i$a$-minByOrNull-MapRegions$assignRegions$startRegion$6 = false;
                        $i$f$filterKeys = it.getTerrainCounts();
                        var29_142 = 2;
                        $i$f$filterKeys = false;
                        result$iv = new LinkedHashMap<K, V>();
                        for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                            terrain = (String)entry$iv.getKey();
                            $i$a$-filterKeys-MapRegions$assignRegions$startRegion$6$1 = false;
                            if (!avoided.contains(terrain)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        var36_157 = result$iv;
                        var29_142 * CollectionsKt.sumOfInt((Iterable<Integer>)var36_157.values());
                        $this$filterKeys$iv = it.getTerrainCounts();
                        $i$f$filterKeys = false;
                        result$iv = new LinkedHashMap<K, V>();
                        for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                            terrain = (String)entry$iv.getKey();
                            $i$a$-filterKeys-MapRegions$assignRegions$startRegion$6$2 = false;
                            if (!preferred.contains(terrain)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        v$iv = -CollectionsKt.sumOfInt((Iterable<Integer>)((Map)result$iv).values());
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v39 = minElem$iv;
                }
            }
            startRegion = v39;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Negative, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            MapRegions.logAssignRegion$default(this, false, BiasTypes.Negative, civ, null, 8, null);
            randomCivs.add(civ);
        }
        for (Object v40 : randomCivs) {
            Intrinsics.checkNotNullExpressionValue(v40, "next(...)");
            civ = (Civilization)v40;
            startRegion = (Region)CollectionsKt.random((Collection)unpickedRegions, Random.Default);
            this.logAssignRegion(true, BiasTypes.Random, civ, startRegion);
            this.assignCivToRegion(civ, startRegion);
            unpickedRegions.remove(startRegion);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assignRegionTypes() {
        void $this$filterTo$iv$iv;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Terrain it = (Terrain)element$iv$iv;
            boolean bl = false;
            if (!(MapRegionsKt.getRegionPriority(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List regionTypes = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Terrain it = (Terrain)a;
                boolean bl = false;
                Comparable comparable = MapRegionsKt.getRegionPriority(it);
                it = (Terrain)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)MapRegionsKt.getRegionPriority(it));
            }
        });
        Iterator<Region> iterator2 = this.regions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Region> iterator3 = iterator2;
        block1: while (iterator3.hasNext()) {
            Region region;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            region.countTerrains();
            for (Object e : regionTypes) {
                boolean bl;
                Unique it;
                Object element$iv;
                Iterator iterator4;
                boolean $i$f$any;
                Sequence $this$any$iv;
                Terrain type;
                block8: {
                    boolean bl2;
                    block7: {
                        Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                        type = (Terrain)e;
                        $this$any$iv = IHasUniques.getMatchingUniques$default(type, UniqueType.RegionRequireFirstLessThanSecond, null, 2, null);
                        $i$f$any = false;
                        iterator4 = $this$any$iv.iterator();
                        while (iterator4.hasNext()) {
                            element$iv = iterator4.next();
                            it = (Unique)element$iv;
                            boolean bl3 = false;
                            if (!(region.getTerrainAmount(it.getParams().get(0)) >= region.getTerrainAmount(it.getParams().get(1)))) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                    if (bl2) continue;
                    $this$any$iv = IHasUniques.getMatchingUniques$default(type, UniqueType.RegionRequirePercentSingleType, null, 2, null);
                    $i$f$any = false;
                    iterator4 = $this$any$iv.iterator();
                    while (iterator4.hasNext()) {
                        element$iv = iterator4.next();
                        it = (Unique)element$iv;
                        boolean bl4 = false;
                        if (!(region.getTerrainAmount(it.getParams().get(1)) >= Integer.parseInt(it.getParams().get(0)) * region.getTiles().size() / 100)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                if (!bl) {
                    boolean bl3;
                    block9: {
                        $this$any$iv = IHasUniques.getMatchingUniques$default(type, UniqueType.RegionRequirePercentTwoTypes, null, 2, null);
                        $i$f$any = false;
                        iterator4 = $this$any$iv.iterator();
                        while (iterator4.hasNext()) {
                            element$iv = iterator4.next();
                            it = (Unique)element$iv;
                            boolean bl6 = false;
                            if (!(region.getTerrainAmount(it.getParams().get(1)) + region.getTerrainAmount(it.getParams().get(2)) >= Integer.parseInt(it.getParams().get(0)) * region.getTiles().size() / 100)) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                    if (!bl3) continue;
                }
                region.setType(type.getName());
                continue block1;
            }
        }
    }

    private final void logAssignRegion(boolean success, BiasTypes startBiasType, Civilization civ, Region region) {
        if (Log.INSTANCE.getBackend().isRelease()) {
            return;
        }
        Function0<String> logCiv = () -> MapRegions.logAssignRegion$lambda$0(civ, this);
        String msg = success ? "(%s): %s to %s" : "no region (%s) found for %s";
        Object[] objectArray = new Object[]{startBiasType, logCiv, region};
        Log.INSTANCE.debug(new Tag("assignRegions"), msg, objectArray);
    }

    static /* synthetic */ void logAssignRegion$default(MapRegions mapRegions, boolean bl, BiasTypes biasTypes, Civilization civilization, Region region, int n, Object object) {
        if ((n & 8) != 0) {
            region = null;
        }
        mapRegions.logAssignRegion(bl, biasTypes, civilization, region);
    }

    private final void assignCivToRegion(Civilization civ, Region region) {
        TileMap tileMap = region.getTileMap();
        HexCoord hexCoord = region.getStartPosition();
        Intrinsics.checkNotNull(hexCoord);
        Tile tile = tileMap.get(hexCoord);
        TileMap.addStartingLocation$default(region.getTileMap(), civ.getCivID(), tile, null, 4, null);
        this.tileData.placeImpact(ImpactType.MinorCiv, tile, 6);
        this.tileData.placeImpact(ImpactType.Luxury, tile, 3);
        this.tileData.placeImpact(ImpactType.Strategic, tile, 0);
        this.tileData.placeImpact(ImpactType.Bonus, tile, 3);
    }

    private final Region getFallbackRegion(String type, List<Region> candidates) {
        Object v0;
        Iterable $this$maxByOrNull$iv = candidates;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Region it = (Region)maxElem$iv;
                boolean bl = false;
                Integer n = it.getTerrainCounts().get(type);
                int maxValue$iv = n != null ? n : 0;
                do {
                    int v$iv;
                    Object e$iv = iterator$iv.next();
                    Region it2 = (Region)e$iv;
                    $i$a$-maxByOrNull-MapRegions$getFallbackRegion$1 = false;
                    Integer n2 = it2.getTerrainCounts().get(type);
                    int n3 = v$iv = n2 != null ? n2 : 0;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    public final void placeResourcesAndMinorCivs(@NotNull TileMap tileMap, @NotNull List<Civilization> minorCivs) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(minorCivs, "minorCivs");
        this.placeNaturalWonderImpacts(tileMap);
        Pair<List<String>, List<String>> pair = LuxuryResourcePlacementLogic.INSTANCE.assignLuxuries(this.regions, this.tileData, this.ruleset);
        List<String> cityStateLuxuries = pair.component1();
        List<String> randomLuxuries = pair.component2();
        MinorCivPlacer.INSTANCE.placeMinorCivs((List<Region>)this.regions, tileMap, minorCivs, this.tileData, this.ruleset);
        LuxuryResourcePlacementLogic.INSTANCE.placeLuxuries(this.regions, tileMap, this.tileData, this.ruleset, cityStateLuxuries, randomLuxuries);
        StrategicBonusResourcePlacementLogic.INSTANCE.placeStrategicAndBonuses$core(tileMap, this.regions, this.tileData);
    }

    /*
     * WARNING - void declaration
     */
    private final void placeNaturalWonderImpacts(TileMap tileMap) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = tileMap.getValues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            if (!it.isNaturalWonder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Tile tile : (List)destination$iv$iv) {
            this.tileData.placeImpact(ImpactType.Bonus, tile, 1);
            this.tileData.placeImpact(ImpactType.Strategic, tile, 1);
            this.tileData.placeImpact(ImpactType.Luxury, tile, 1);
            this.tileData.placeImpact(ImpactType.MinorCiv, tile, 1);
        }
    }

    private static final String logAssignRegion$lambda$0(Civilization $civ, MapRegions this$0) {
        StringBuilder stringBuilder = new StringBuilder().append($civ.getCivName()).append(' ');
        Nation nation = this$0.ruleset.getNations().get($civ.getCivName());
        Intrinsics.checkNotNull(nation);
        return stringBuilder.append(CollectionsKt.joinToString$default(nation.getStartBias(), ",", "(", ")", 0, null, null, 56, null)).toString();
    }

    static {
        Serializable[] serializableArray = new Pair[]{TuplesKt.to(1, 1), TuplesKt.to(2, 4), TuplesKt.to(3, 4)};
        minimumFoodForRing = MapsKt.mapOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(1, 0), TuplesKt.to(2, 0), TuplesKt.to(3, 2)};
        minimumProdForRing = MapsKt.mapOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(1, 3), TuplesKt.to(2, 6), TuplesKt.to(3, 8)};
        minimumGoodForRing = MapsKt.mapOf(serializableArray);
        serializableArray = new Integer[]{0, 8, 14, 19, 22, 24, 25};
        firstRingFoodScores = CollectionsKt.listOf(serializableArray);
        serializableArray = new Integer[]{0, 10, 16, 20, 20, 12, 0};
        firstRingProdScores = CollectionsKt.listOf(serializableArray);
        serializableArray = new Integer[]{0, 2, 5, 10, 20, 25, 28, 30, 32, 34, 35};
        secondRingFoodScores = CollectionsKt.listOf(serializableArray);
        serializableArray = new Integer[]{0, 10, 20, 25, 30, 35};
        secondRingProdScores = CollectionsKt.listOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(0, 99), TuplesKt.to(1, 97), TuplesKt.to(2, 95), TuplesKt.to(3, 92), TuplesKt.to(4, 89), TuplesKt.to(5, 69), TuplesKt.to(6, 57), TuplesKt.to(7, 24), TuplesKt.to(8, 20), TuplesKt.to(9, 16), TuplesKt.to(10, 12), TuplesKt.to(11, 8), TuplesKt.to(12, 6), TuplesKt.to(13, 4)};
        closeStartPenaltyForRing = MapsKt.mapOf(serializableArray);
        serializableArray = new Pair[8];
        serializableArray[0] = TuplesKt.to(1, CollectionsKt.listOf(Float.valueOf(1.0f)));
        Float[] floatArray = new Float[]{Float.valueOf(0.55f), Float.valueOf(0.45f)};
        serializableArray[1] = TuplesKt.to(2, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.4f), Float.valueOf(0.33f), Float.valueOf(0.27f)};
        serializableArray[2] = TuplesKt.to(3, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.35f), Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(0.15f)};
        serializableArray[3] = TuplesKt.to(4, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(0.2f), Float.valueOf(0.15f), Float.valueOf(0.15f)};
        serializableArray[4] = TuplesKt.to(5, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.2f), Float.valueOf(0.2f), Float.valueOf(0.2f), Float.valueOf(0.15f), Float.valueOf(0.15f), Float.valueOf(0.1f)};
        serializableArray[5] = TuplesKt.to(6, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.2f), Float.valueOf(0.2f), Float.valueOf(0.15f), Float.valueOf(0.15f), Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(0.1f)};
        serializableArray[6] = TuplesKt.to(7, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.2f), Float.valueOf(0.15f), Float.valueOf(0.15f), Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(0.1f)};
        serializableArray[7] = TuplesKt.to(8, CollectionsKt.listOf(floatArray));
        randomLuxuryRatios = MapsKt.mapOf(serializableArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$BiasTypes;", "", "<init>", "(Ljava/lang/String;I)V", "Coastal", "Positive", "Negative", "Random", "PositiveFallback", "core"})
    private static final class BiasTypes
    extends Enum<BiasTypes> {
        public static final /* enum */ BiasTypes Coastal = new BiasTypes();
        public static final /* enum */ BiasTypes Positive = new BiasTypes();
        public static final /* enum */ BiasTypes Negative = new BiasTypes();
        public static final /* enum */ BiasTypes Random = new BiasTypes();
        public static final /* enum */ BiasTypes PositiveFallback = new BiasTypes();
        private static final /* synthetic */ BiasTypes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BiasTypes[] values() {
            return (BiasTypes[])$VALUES.clone();
        }

        public static BiasTypes valueOf(String value) {
            return Enum.valueOf(BiasTypes.class, value);
        }

        @NotNull
        public static EnumEntries<BiasTypes> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = biasTypesArray = new BiasTypes[]{BiasTypes.Coastal, BiasTypes.Positive, BiasTypes.Negative, BiasTypes.Random, BiasTypes.PositiveFallback};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR#\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\bR\u000e\u0010\u001d\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$Companion;", "", "<init>", "()V", "minimumFoodForRing", "", "", "getMinimumFoodForRing", "()Ljava/util/Map;", "minimumProdForRing", "getMinimumProdForRing", "minimumGoodForRing", "getMinimumGoodForRing", "maximumJunk", "firstRingFoodScores", "", "getFirstRingFoodScores", "()Ljava/util/List;", "firstRingProdScores", "getFirstRingProdScores", "secondRingFoodScores", "getSecondRingFoodScores", "secondRingProdScores", "getSecondRingProdScores", "closeStartPenaltyForRing", "getCloseStartPenaltyForRing", "randomLuxuryRatios", "", "getRandomLuxuryRatios", "baseMinorDepositFrequency", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Integer, Integer> getMinimumFoodForRing() {
            return minimumFoodForRing;
        }

        @NotNull
        public final Map<Integer, Integer> getMinimumProdForRing() {
            return minimumProdForRing;
        }

        @NotNull
        public final Map<Integer, Integer> getMinimumGoodForRing() {
            return minimumGoodForRing;
        }

        @NotNull
        public final List<Integer> getFirstRingFoodScores() {
            return firstRingFoodScores;
        }

        @NotNull
        public final List<Integer> getFirstRingProdScores() {
            return firstRingProdScores;
        }

        @NotNull
        public final List<Integer> getSecondRingFoodScores() {
            return secondRingFoodScores;
        }

        @NotNull
        public final List<Integer> getSecondRingProdScores() {
            return secondRingProdScores;
        }

        @NotNull
        public final Map<Integer, Integer> getCloseStartPenaltyForRing() {
            return closeStartPenaltyForRing;
        }

        @NotNull
        public final Map<Integer, List<Float>> getRandomLuxuryRatios() {
            return randomLuxuryRatios;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$ImpactType;", "", "<init>", "(Ljava/lang/String;I)V", "Strategic", "Luxury", "Bonus", "MinorCiv", "core"})
    public static final class ImpactType
    extends Enum<ImpactType> {
        public static final /* enum */ ImpactType Strategic = new ImpactType();
        public static final /* enum */ ImpactType Luxury = new ImpactType();
        public static final /* enum */ ImpactType Bonus = new ImpactType();
        public static final /* enum */ ImpactType MinorCiv = new ImpactType();
        private static final /* synthetic */ ImpactType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ImpactType[] values() {
            return (ImpactType[])$VALUES.clone();
        }

        public static ImpactType valueOf(String value) {
            return Enum.valueOf(ImpactType.class, value);
        }

        @NotNull
        public static EnumEntries<ImpactType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = impactTypeArray = new ImpactType[]{ImpactType.Strategic, ImpactType.Luxury, ImpactType.Bonus, ImpactType.MinorCiv};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

