/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique;

import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.logic.civilization.managers.ReligionManager;
import com.unciv.logic.civilization.managers.ReligionState;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.ModCompatibility;
import com.unciv.models.stats.Stat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0003J\"\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/unciv/models/ruleset/unique/Conditionals;", "", "<init>", "()V", "getStateBasedRandom", "", "state", "Lcom/unciv/models/ruleset/unique/GameContext;", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "conditionalApplies", "", "conditional", "core"})
@SourceDebugExtension(value={"SMAP\nConditionals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Conditionals.kt\ncom/unciv/models/ruleset/unique/Conditionals\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,391:1\n1255#2,2:392\n1255#2,2:394\n1255#2,2:396\n1255#2:398\n1255#2,2:399\n1256#2:401\n1276#2,3:402\n1255#2,2:430\n1255#2,2:432\n1255#2,2:440\n2275#2,2:442\n1761#3,3:405\n2746#3,3:408\n2746#3,3:411\n1761#3,3:414\n2746#3,3:417\n774#3:420\n865#3,2:421\n1740#3,3:423\n1788#3,4:426\n2746#3,3:434\n2746#3,3:437\n*S KotlinDebug\n*F\n+ 1 Conditionals.kt\ncom/unciv/models/ruleset/unique/Conditionals\n*L\n276#1:392,2\n278#1:394,2\n289#1:396,2\n307#1:398\n308#1:399,2\n307#1:401\n317#1:402,3\n218#1:430,2\n220#1:432,2\n380#1:440,2\n384#1:442,2\n173#1:405,3\n178#1:408,3\n182#1:411,3\n208#1:414,3\n210#1:417,3\n212#1:420\n212#1:421,2\n212#1:423,3\n215#1:426,4\n328#1:434,3\n336#1:437,3\n*E\n"})
public final class Conditionals {
    @NotNull
    public static final Conditionals INSTANCE = new Conditionals();

    private Conditionals() {
    }

    @Readonly
    private final float getStateBasedRandom(GameContext state, Unique unique) {
        GameInfo gameInfo = state.getGameInfo();
        int seed = gameInfo != null ? Integer.hashCode(gameInfo.getTurns()) : 0;
        Unique unique2 = unique;
        seed = seed * 31 + (unique2 != null ? unique2.hashCode() : 0);
        seed = seed * 31 + state.hashCode();
        return RandomKt.Random(seed).nextFloat();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    public final boolean conditionalApplies(@Nullable Unique unique, @NotNull Unique conditional, @NotNull GameContext state) {
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        Intrinsics.checkNotNullParameter(state, "state");
        if (conditional.isOtherModifierType()) {
            return true;
        }
        UniqueType uniqueType = conditional.getType();
        switch (uniqueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uniqueType.ordinal()]) {
            case 1: {
                if (!(this.getStateBasedRandom(state, unique) < Float.parseFloat(conditional.getParams().get(0)) / 100.0f)) return false;
                return true;
            }
            case 2: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$1(conditional, arg_0));
                return bl;
            }
            case 3: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$2(conditional, arg_0));
                return bl;
            }
            case 4: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$3(conditional, arg_0));
                return bl;
            }
            case 5: {
                boolean bl = UncivGame.Companion.getCurrent().getSettings().getShowTutorials();
                return bl;
            }
            case 6: {
                boolean bl = UncivGame.Companion.getCurrent().getSettings().getTutorialTasksCompleted().contains(conditional.getParams().get(0));
                return bl;
            }
            case 7: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$4(conditional, state, arg_0));
                return bl;
            }
            case 8: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$5);
                return bl;
            }
            case 9: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$6);
                return bl;
            }
            case 10: {
                if (state.getResourceAmount(conditional.getParams().get(0)) <= 0) return false;
                return true;
            }
            case 11: {
                if (state.getResourceAmount(conditional.getParams().get(0)) > 0) return false;
                return true;
            }
            case 12: {
                Unique unique2 = unique;
                boolean bl = Conditionals.conditionalApplies$checkResourceOrStatAmount(state, conditional.getParams().get(1), Float.parseFloat(conditional.getParams().get(0)), Float.MAX_VALUE, unique2 != null ? unique2.isModifiedByGameSpeed() : false, Conditionals::conditionalApplies$lambda$7);
                return bl;
            }
            case 13: {
                Unique unique3 = unique;
                boolean bl = Conditionals.conditionalApplies$checkResourceOrStatAmount(state, conditional.getParams().get(1), Float.MIN_VALUE, Float.parseFloat(conditional.getParams().get(0)), unique3 != null ? unique3.isModifiedByGameSpeed() : false, Conditionals::conditionalApplies$lambda$8);
                return bl;
            }
            case 14: {
                Unique unique4 = unique;
                boolean bl = Conditionals.conditionalApplies$checkResourceOrStatAmount(state, conditional.getParams().get(2), Float.parseFloat(conditional.getParams().get(0)), Float.parseFloat(conditional.getParams().get(1)), unique4 != null ? unique4.isModifiedByGameSpeed() : false, Conditionals::conditionalApplies$lambda$9);
                return bl;
            }
            case 15: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$10);
                return bl;
            }
            case 16: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$11);
                return bl;
            }
            case 17: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$12);
                return bl;
            }
            case 18: {
                boolean bl = Conditionals.conditionalApplies$compareEra(state, conditional.getParams().get(0), Conditionals::conditionalApplies$lambda$13);
                return bl;
            }
            case 19: {
                boolean bl = Conditionals.conditionalApplies$compareEra(state, conditional.getParams().get(0), Conditionals::conditionalApplies$lambda$14);
                return bl;
            }
            case 20: {
                boolean bl = Conditionals.conditionalApplies$compareEra(state, conditional.getParams().get(0), Conditionals::conditionalApplies$lambda$15);
                return bl;
            }
            case 21: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$16(conditional, arg_0));
                return bl;
            }
            case 22: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$17(conditional, arg_0));
                return bl;
            }
            case 23: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$18(conditional, arg_0));
                return bl;
            }
            case 24: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$19(conditional, arg_0));
                return bl;
            }
            case 25: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$20(conditional, arg_0));
                return bl;
            }
            case 26: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$21(conditional, arg_0));
                return bl;
            }
            case 27: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$22(conditional, arg_0));
                return bl;
            }
            case 28: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, Conditionals::conditionalApplies$lambda$23);
                return bl;
            }
            case 29: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, Conditionals::conditionalApplies$lambda$24);
                return bl;
            }
            case 30: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, Conditionals::conditionalApplies$lambda$25);
                return bl;
            }
            case 31: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, Conditionals::conditionalApplies$lambda$26);
                return bl;
            }
            case 32: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, Conditionals::conditionalApplies$lambda$27);
                return bl;
            }
            case 33: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, Conditionals::conditionalApplies$lambda$28);
                return bl;
            }
            case 34: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$29(conditional, arg_0));
                return bl;
            }
            case 35: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$30(conditional, arg_0));
                return bl;
            }
            case 36: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$31(conditional, arg_0));
                return bl;
            }
            case 37: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$32(conditional, arg_0));
                return bl;
            }
            case 38: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$33(conditional, arg_0));
                return bl;
            }
            case 39: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$34(conditional, arg_0));
                return bl;
            }
            case 40: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$35);
                return bl;
            }
            case 41: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$36);
                return bl;
            }
            case 42: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$37);
                return bl;
            }
            case 43: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$38);
                return bl;
            }
            case 44: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$39);
                return bl;
            }
            case 45: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$40);
                return bl;
            }
            case 46: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, Conditionals::conditionalApplies$lambda$41);
                return bl;
            }
            case 47: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$42(conditional, arg_0));
                return bl;
            }
            case 48: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$43(conditional, arg_0));
                return bl;
            }
            case 49: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$44(conditional, arg_0));
                return bl;
            }
            case 50: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$45(conditional, arg_0));
                return bl;
            }
            case 51: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$46(conditional, arg_0));
                return bl;
            }
            case 52: {
                if (Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$47(conditional, arg_0))) return false;
                return true;
            }
            case 53: {
                if (state.getRelevantCity() == null) return false;
                return true;
            }
            case 54: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$48(conditional, state, arg_0));
                return bl;
            }
            case 55: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, Conditionals::conditionalApplies$lambda$49);
                return bl;
            }
            case 56: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$50(conditional, state, arg_0));
                return bl;
            }
            case 57: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$51(conditional, state, arg_0));
                return bl;
            }
            case 58: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, Conditionals::conditionalApplies$lambda$52);
                return bl;
            }
            case 59: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, Conditionals::conditionalApplies$lambda$53);
                return bl;
            }
            case 60: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$54(state, arg_0));
                return bl;
            }
            case 61: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, Conditionals::conditionalApplies$lambda$55);
                return bl;
            }
            case 62: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$56(conditional, arg_0));
                return bl;
            }
            case 63: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$57(conditional, arg_0));
                return bl;
            }
            case 64: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$58(conditional, arg_0));
                return bl;
            }
            case 65: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$59(conditional, arg_0));
                return bl;
            }
            case 66: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$60(conditional, arg_0));
                return bl;
            }
            case 67: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, arg_0 -> Conditionals.conditionalApplies$lambda$61(conditional, arg_0));
                return bl;
            }
            case 68: {
                boolean bl = Conditionals.conditionalApplies$checkOnCity(state, Conditionals::conditionalApplies$lambda$62);
                return bl;
            }
            case 69: {
                ICombatant iCombatant = state.getTheirCombatant();
                if (iCombatant == null) return false;
                if (!iCombatant.matchesFilter("City", false)) return false;
                return true;
            }
            case 70: 
            case 71: {
                ICombatant iCombatant = state.getTheirCombatant();
                if (iCombatant == null) return false;
                if (!ICombatant.matchesFilter$default(iCombatant, conditional.getParams().get(0), false, 2, null)) return false;
                return true;
            }
            case 72: 
            case 73: {
                MapUnit mapUnit = state.getRelevantUnit();
                if (mapUnit == null) return false;
                if (!MapUnit.matchesFilter$default(mapUnit, conditional.getParams().get(0), false, 2, null)) return false;
                return true;
            }
            case 74: {
                if (state.getRelevantUnit() == null) return false;
                MapUnit mapUnit = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (mapUnit.getPromotions().getPromotions().contains(conditional.getParams().get(0))) return true;
                MapUnit mapUnit2 = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit2);
                if (!mapUnit2.hasStatus(conditional.getParams().get(0))) return false;
                return true;
            }
            case 75: {
                if (state.getRelevantUnit() == null) return false;
                MapUnit mapUnit = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (mapUnit.getPromotions().getPromotions().contains(conditional.getParams().get(0))) return false;
                MapUnit mapUnit3 = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit3);
                if (mapUnit3.hasStatus(conditional.getParams().get(0))) return false;
                return true;
            }
            case 76: {
                if (state.getCombatAction() != CombatAction.Attack) return false;
                return true;
            }
            case 77: {
                if (state.getCombatAction() != CombatAction.Defend) return false;
                return true;
            }
            case 78: {
                if (state.getRelevantUnit() != null) {
                    MapUnit mapUnit = state.getRelevantUnit();
                    Intrinsics.checkNotNull(mapUnit);
                    if (mapUnit.getHealth() > Integer.parseInt(conditional.getParams().get(0))) return true;
                }
                if (state.getOurCombatant() == null) return false;
                if (state.getOurCombatant().getHealth() <= Integer.parseInt(conditional.getParams().get(0))) return false;
                return true;
            }
            case 79: {
                if (state.getRelevantUnit() != null) {
                    MapUnit mapUnit = state.getRelevantUnit();
                    Intrinsics.checkNotNull(mapUnit);
                    if (mapUnit.getHealth() < Integer.parseInt(conditional.getParams().get(0))) return true;
                }
                if (state.getOurCombatant() == null) return false;
                if (state.getOurCombatant().getHealth() >= Integer.parseInt(conditional.getParams().get(0))) return false;
                return true;
            }
            case 80: {
                if (state.getUnit() == null) return true;
                if (!state.getUnit().getAbilityToTimesUsed().isEmpty()) return false;
                return true;
            }
            case 81: {
                boolean bl;
                if (state.getRelevantUnit() == null) return false;
                MapUnit mapUnit = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit);
                Sequence<MapUnit> $this$any$iv = mapUnit.getTile().getUnits();
                boolean $i$f$any = false;
                Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
                do {
                    MapUnit element$iv;
                    if (!iterator2.hasNext()) return false;
                    MapUnit it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it, state.getRelevantUnit()) && MapUnit.matchesFilter$default(it, conditional.getParams().get(0), false, 2, null)) {
                        return true;
                    }
                    bl = false;
                } while (!bl);
                return true;
            }
            case 82: {
                boolean bl;
                if (state.getRelevantUnit() == null) return true;
                MapUnit mapUnit = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit);
                Sequence<MapUnit> $this$any$iv = mapUnit.getTile().getUnits();
                boolean $i$f$any = false;
                Iterator<MapUnit> iterator3 = $this$any$iv.iterator();
                do {
                    MapUnit element$iv;
                    if (!iterator3.hasNext()) return true;
                    MapUnit it = element$iv = iterator3.next();
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it, state.getRelevantUnit()) && MapUnit.matchesFilter$default(it, conditional.getParams().get(0), false, 2, null)) {
                        return false;
                    }
                    bl = false;
                } while (!bl);
                return false;
            }
            case 83: {
                Tile tile = state.getRelevantTile();
                if (tile == null) return false;
                if (!tile.matchesFilter(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 84: {
                Tile tile = state.getRelevantTile();
                if (tile == null) return false;
                if (tile.matchesFilter(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 85: {
                Tile tile = state.getRelevantTile();
                if (tile == null) return false;
                if (!tile.isAdjacentTo(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 86: {
                Tile tile = state.getRelevantTile();
                if (tile == null) return false;
                if (tile.isAdjacentTo(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 87: {
                Tile tile = state.getAttackedTile();
                if (tile == null) return false;
                if (!tile.matchesFilter(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 88: {
                Tile it;
                if (state.getRelevantTile() == null) return false;
                Tile tile = state.getRelevantTile();
                Intrinsics.checkNotNull(tile);
                Sequence<Tile> $this$any$iv = tile.getTilesInDistance(Integer.parseInt(conditional.getParams().get(0)));
                boolean $i$f$any = false;
                Iterator<Tile> iterator4 = $this$any$iv.iterator();
                do {
                    Tile element$iv;
                    if (!iterator4.hasNext()) return false;
                    it = element$iv = iterator4.next();
                    boolean bl = false;
                } while (!it.matchesFilter(conditional.getParams().get(1), state.getRelevantCiv()));
                return true;
            }
            case 89: {
                Object object = state.getRelevantCiv();
                int yourCities = object != null && (object = ((Civilization)object).getCities()) != null ? object.size() : 1;
                Object object2 = state.getTheirCombatant();
                int theirCities = object2 != null && (object2 = object2.getCivInfo()) != null && (object2 = ((Civilization)object2).getCities()) != null ? object2.size() : 0;
                if (yourCities >= theirCities) return false;
                return true;
            }
            case 90: {
                boolean bl = Conditionals.conditionalApplies$checkOnCiv(state, arg_0 -> Conditionals.conditionalApplies$lambda$66(state, arg_0));
                return bl;
            }
            case 91: {
                boolean bl;
                if (state.getRelevantCiv() == null) return false;
                if (state.getRelevantUnit() == null) return false;
                Tile tile = state.getRelevantTile();
                Intrinsics.checkNotNull(tile);
                Sequence<Tile> $this$any$iv = tile.getNeighbors();
                boolean $i$f$any = false;
                Iterator<Tile> iterator5 = $this$any$iv.iterator();
                do {
                    Tile element$iv;
                    if (!iterator5.hasNext()) return false;
                    Tile it = element$iv = iterator5.next();
                    boolean bl4 = false;
                    Sequence<MapUnit> $this$any$iv2 = it.getUnits();
                    boolean $i$f$any2 = false;
                    Iterator<MapUnit> iterator6 = $this$any$iv2.iterator();
                    while (iterator6.hasNext()) {
                        MapUnit element$iv2;
                        MapUnit it2 = element$iv2 = iterator6.next();
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual(it2, state.getRelevantUnit()) && Intrinsics.areEqual(it2.getCiv(), state.getRelevantCiv()) && MapUnit.matchesFilter$default(it2, conditional.getParams().get(0), false, 2, null)) {
                            return true;
                        }
                        boolean bl6 = false;
                        if (!bl6) continue;
                        return true;
                    }
                    bl = false;
                } while (!bl);
                return true;
            }
            case 92: {
                if (state.getRelevantTile() == null) return false;
                int $this$any$iv = Integer.parseInt(conditional.getParams().get(0));
                int n = Integer.parseInt(conditional.getParams().get(1));
                Tile tile = state.getRelevantTile();
                Intrinsics.checkNotNull(tile);
                Sequence<Tile> $this$count$iv = tile.getNeighbors();
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Tile> iterator7 = $this$count$iv.iterator();
                while (iterator7.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator7.next();
                    boolean bl = false;
                    if (!it.matchesFilter(conditional.getParams().get(2), state.getRelevantCiv()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int n2 = count$iv;
                if ($this$any$iv > n2) return false;
                if (n2 > n) return false;
                return true;
            }
            case 93: {
                Region region = state.getRegion();
                if (region == null) return false;
                if (region.getContinentID() != -1) return false;
                return true;
            }
            case 94: {
                Region region = state.getRegion();
                boolean bl = Intrinsics.areEqual(region != null ? region.getType() : null, conditional.getParams().get(0));
                return bl;
            }
            case 95: {
                Region region = state.getRegion();
                if (Intrinsics.areEqual(region != null ? region.getType() : null, conditional.getParams().get(0))) return false;
                return true;
            }
            case 96: {
                if (unique == null) return false;
                if (unique.getSourceObjectType() != UniqueTarget.Tech) return false;
                if (!Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$69(state, unique, arg_0))) return false;
                return true;
            }
            case 97: {
                if (unique == null) return false;
                if (unique.getSourceObjectType() != UniqueTarget.Policy) return false;
                if (!Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$70(state, unique, arg_0))) return false;
                return true;
            }
            case 98: {
                boolean bl = Conditionals.conditionalApplies$compareCountables(state, conditional.getParams().get(0), conditional.getParams().get(1), Conditionals::conditionalApplies$lambda$71);
                return bl;
            }
            case 99: {
                boolean bl = Conditionals.conditionalApplies$compareCountables(state, conditional.getParams().get(0), conditional.getParams().get(1), Conditionals::conditionalApplies$lambda$72);
                return bl;
            }
            case 100: {
                boolean bl = Conditionals.conditionalApplies$compareCountables(state, conditional.getParams().get(0), conditional.getParams().get(1), Conditionals::conditionalApplies$lambda$73);
                return bl;
            }
            case 101: {
                boolean bl = Conditionals.conditionalApplies$compareCountables(state, conditional.getParams().get(0), conditional.getParams().get(1), Conditionals::conditionalApplies$lambda$74);
                return bl;
            }
            case 102: {
                boolean bl = Conditionals.conditionalApplies$compareCountables$0(state, conditional.getParams().get(0), conditional.getParams().get(1), conditional.getParams().get(2), Conditionals::conditionalApplies$lambda$75);
                return bl;
            }
            case 103: {
                if (state.getRelevantUnit() == null) return false;
                MapUnit mapUnit = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (!mapUnit.isTransported()) {
                    return false;
                }
                MapUnit mapUnit4 = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit4);
                MapUnit carrier = mapUnit4.getTile().getMilitaryUnit();
                if (carrier == null) return false;
                if (Intrinsics.areEqual(carrier, state.getRelevantUnit())) return false;
                if (!MapUnit.matchesFilter$default(carrier, conditional.getParams().get(0), false, 2, null)) return false;
                return true;
            }
            case 104: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$76(conditional, arg_0));
                return bl;
            }
            case 105: {
                boolean bl = Conditionals.conditionalApplies$checkOnGameInfo(state, arg_0 -> Conditionals.conditionalApplies$lambda$77(conditional, arg_0));
                return bl;
            }
            default: {
                return false;
            }
        }
    }

    @Readonly
    private static final boolean conditionalApplies$checkOnGameInfo(GameContext $state, @Readonly Function1<? super GameInfo, Boolean> predicate) {
        if ($state.getGameInfo() == null) {
            return false;
        }
        return predicate.invoke($state.getGameInfo());
    }

    @Readonly
    private static final boolean conditionalApplies$checkOnCiv(GameContext $state, @Readonly Function1<? super Civilization, Boolean> predicate) {
        if ($state.getRelevantCiv() == null) {
            return false;
        }
        Civilization civilization = $state.getRelevantCiv();
        Intrinsics.checkNotNull(civilization);
        return predicate.invoke(civilization);
    }

    @Readonly
    private static final boolean conditionalApplies$checkOnCity(GameContext $state, @Readonly Function1<? super City, Boolean> predicate) {
        if ($state.getRelevantCity() == null) {
            return false;
        }
        City city = $state.getRelevantCity();
        Intrinsics.checkNotNull(city);
        return predicate.invoke(city);
    }

    @Readonly
    private static final boolean conditionalApplies$compareEra(GameContext $state, String eraParam, @Readonly Function2<? super Integer, ? super Integer, Boolean> compare) {
        if ($state.getGameInfo() == null) {
            return false;
        }
        Era era = $state.getGameInfo().getRuleset().getEras().get(eraParam);
        if (era == null) {
            return false;
        }
        Era era2 = era;
        Civilization civilization = $state.getRelevantCiv();
        Intrinsics.checkNotNull(civilization);
        return compare.invoke((Integer)civilization.getEraNumber(), (Integer)era2.getEraNumber());
    }

    @Readonly
    private static final boolean conditionalApplies$checkResourceOrStatAmount(GameContext $state, String resourceOrStatName, float lowerLimit, float upperLimit, boolean modifyByGameSpeed, @Readonly Function3<? super Integer, ? super Float, ? super Float, Boolean> compare) {
        float f;
        float gameSpeedModifier;
        if ($state.getGameInfo() == null) {
            return false;
        }
        float f2 = gameSpeedModifier = modifyByGameSpeed ? $state.getGameInfo().getSpeed().getModifier() : 1.0f;
        if ($state.getGameInfo().getRuleset().getTileResources().containsKey(resourceOrStatName)) {
            return compare.invoke((Integer)$state.getResourceAmount(resourceOrStatName), Float.valueOf(lowerLimit * gameSpeedModifier), Float.valueOf(upperLimit * gameSpeedModifier));
        }
        Stat stat = Stat.Companion.safeValueOf(resourceOrStatName);
        if (stat == null) {
            return false;
        }
        Stat stat2 = stat;
        int statReserve = $state.getStatAmount(stat2);
        if (modifyByGameSpeed) {
            Float f3 = $state.getGameInfo().getSpeed().getStatCostModifiers().get(stat2);
            Intrinsics.checkNotNull(f3);
            f = ((Number)f3).floatValue();
        } else {
            f = 1.0f;
        }
        gameSpeedModifier = f;
        return compare.invoke((Integer)statReserve, Float.valueOf(lowerLimit * gameSpeedModifier), Float.valueOf(upperLimit * gameSpeedModifier));
    }

    static /* synthetic */ boolean conditionalApplies$checkResourceOrStatAmount$default(GameContext gameContext, String string, float f, float f2, boolean bl, Function3 function3, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return Conditionals.conditionalApplies$checkResourceOrStatAmount(gameContext, string, f, f2, bl, function3);
    }

    @Readonly
    private static final boolean conditionalApplies$compareCountables(GameContext $state, String first2, String second2, @Readonly Function2<? super Integer, ? super Integer, Boolean> compare) {
        Integer firstNumber = Countables.Companion.getCountableAmount(first2, $state);
        Integer secondNumber = Countables.Companion.getCountableAmount(second2, $state);
        return firstNumber != null && secondNumber != null ? compare.invoke(firstNumber, secondNumber) : false;
    }

    @Readonly
    private static final boolean conditionalApplies$compareCountables$0(GameContext $state, String first2, String second2, String third, @Readonly Function3<? super Integer, ? super Integer, ? super Integer, Boolean> compare) {
        Integer firstNumber = Countables.Companion.getCountableAmount(first2, $state);
        Integer secondNumber = Countables.Companion.getCountableAmount(second2, $state);
        Integer thirdNumber = Countables.Companion.getCountableAmount(third, $state);
        return firstNumber != null && secondNumber != null && thirdNumber != null ? compare.invoke(firstNumber, secondNumber, thirdNumber) : false;
    }

    private static final boolean conditionalApplies$lambda$1(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return $this$checkOnGameInfo.getTurns() % Integer.parseInt($conditional.getParams().get(0)) == 0;
    }

    private static final boolean conditionalApplies$lambda$2(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return $this$checkOnGameInfo.getTurns() < Integer.parseInt($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$3(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return $this$checkOnGameInfo.getTurns() >= Integer.parseInt($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$4(Unique $conditional, GameContext $state, Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return Civilization.matchesFilter$default($this$checkOnCiv, $conditional.getParams().get(0), $state, false, 4, null);
    }

    private static final boolean conditionalApplies$lambda$5(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.isAtWar();
    }

    private static final boolean conditionalApplies$lambda$6(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return !$this$checkOnCiv.isAtWar();
    }

    private static final boolean conditionalApplies$lambda$7(int current, float lowerLimit, float f) {
        return (float)current > lowerLimit;
    }

    private static final boolean conditionalApplies$lambda$8(int current, float f, float upperLimit) {
        return (float)current < upperLimit;
    }

    private static final boolean conditionalApplies$lambda$9(int current, float lowerLimit, float upperLimit) {
        return (float)current >= lowerLimit && (float)current <= upperLimit;
    }

    private static final boolean conditionalApplies$lambda$10(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getStats().getHappiness() >= 0;
    }

    private static final boolean conditionalApplies$lambda$11(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getGoldenAges().isGoldenAge();
    }

    private static final boolean conditionalApplies$lambda$12(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return !$this$checkOnCiv.getGoldenAges().isGoldenAge();
    }

    private static final boolean conditionalApplies$lambda$13(int current, int param) {
        return current < param;
    }

    private static final boolean conditionalApplies$lambda$14(int current, int param) {
        return current >= param;
    }

    private static final boolean conditionalApplies$lambda$15(int current, int param) {
        return current == param;
    }

    private static final boolean conditionalApplies$lambda$16(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return Intrinsics.areEqual($this$checkOnGameInfo.getGameParameters().getStartingEra(), $conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$17(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return Intrinsics.areEqual($this$checkOnGameInfo.getGameParameters().getSpeed(), $conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$18(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return Intrinsics.areEqual($this$checkOnGameInfo.getGameParameters().getDifficulty(), $conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$19(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        String difficulty = $conditional.getParams().get(0);
        if (((Map)$this$checkOnGameInfo.getRuleset().getDifficulties()).containsKey(difficulty)) {
            Set<String> set = $this$checkOnGameInfo.getRuleset().getDifficulties().keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            List difficulties = CollectionsKt.toList((Iterable)set);
            bl = difficulties.indexOf($this$checkOnGameInfo.getDifficulty().getName()) >= difficulties.indexOf(difficulty);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$20(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        String difficulty = $conditional.getParams().get(0);
        if (((Map)$this$checkOnGameInfo.getRuleset().getDifficulties()).containsKey(difficulty)) {
            Set<String> set = $this$checkOnGameInfo.getRuleset().getDifficulties().keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            List difficulties = CollectionsKt.toList((Iterable)set);
            bl = difficulties.indexOf($this$checkOnGameInfo.getDifficulty().getName()) <= difficulties.indexOf(difficulty);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$21(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return $this$checkOnGameInfo.getGameParameters().getVictoryTypes().contains($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$22(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return !$this$checkOnGameInfo.getGameParameters().getVictoryTypes().contains($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$23(GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return $this$checkOnGameInfo.isReligionEnabled();
    }

    private static final boolean conditionalApplies$lambda$24(GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return !$this$checkOnGameInfo.isReligionEnabled();
    }

    private static final boolean conditionalApplies$lambda$25(GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return $this$checkOnGameInfo.isEspionageEnabled();
    }

    private static final boolean conditionalApplies$lambda$26(GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return !$this$checkOnGameInfo.isEspionageEnabled();
    }

    private static final boolean conditionalApplies$lambda$27(GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return $this$checkOnGameInfo.getGameParameters().getNuclearWeaponsEnabled();
    }

    private static final boolean conditionalApplies$lambda$28(GameInfo $this$checkOnGameInfo) {
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        return !$this$checkOnGameInfo.getGameParameters().getNuclearWeaponsEnabled();
    }

    private static final boolean conditionalApplies$lambda$29(Unique $conditional, Civilization $this$checkOnCiv) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
            String filter2 = $conditional.getParams().get(0);
            if (((Map)$this$checkOnCiv.getGameInfo().getRuleset().getTechnologies()).containsKey(filter2)) {
                bl = $this$checkOnCiv.getTech().isResearched($conditional.getParams().get(0));
            } else {
                Iterable $this$any$iv = $this$checkOnCiv.getTech().getResearchedTechnologies();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Technology it = (Technology)element$iv;
                        boolean bl2 = false;
                        if (!Technology.matchesFilter$default(it, filter2, null, false, 6, null)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$30(Unique $conditional, Civilization $this$checkOnCiv) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
            String filter2 = $conditional.getParams().get(0);
            if (((Map)$this$checkOnCiv.getGameInfo().getRuleset().getTechnologies()).containsKey(filter2)) {
                bl = !$this$checkOnCiv.getTech().isResearched($conditional.getParams().get(0));
            } else {
                Iterable $this$none$iv = $this$checkOnCiv.getTech().getResearchedTechnologies();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Technology it = (Technology)element$iv;
                        boolean bl2 = false;
                        if (!Technology.matchesFilter$default(it, filter2, null, false, 6, null)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$31(Unique $conditional, Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        Technology technology = $this$checkOnCiv.getTech().currentTechnology();
        return technology != null ? Technology.matchesFilter$default(technology, $conditional.getParams().get(0), null, false, 6, null) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean conditionalApplies$lambda$32(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        Iterable $this$none$iv = $this$checkOnGameInfo.getCivilizations();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Civilization it = (Civilization)element$iv;
            boolean bl2 = false;
            if (it.isMajorCiv() && it.isAlive()) {
                boolean bl3;
                if (it.getPolicies().isAdopted($conditional.getParams().get(0))) return false;
                Religion religion = it.getReligionManager().getReligion();
                if (religion != null) {
                    if (religion.hasBelief($conditional.getParams().get(0))) {
                        return false;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean conditionalApplies$lambda$33(Unique $conditional, Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        if ($this$checkOnCiv.getPolicies().isAdopted($conditional.getParams().get(0))) return true;
        Religion religion = $this$checkOnCiv.getReligionManager().getReligion();
        if (religion == null) return false;
        if (!religion.hasBelief($conditional.getParams().get(0))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean conditionalApplies$lambda$34(Unique $conditional, Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        if ($this$checkOnCiv.getPolicies().isAdopted($conditional.getParams().get(0))) return false;
        Religion religion = $this$checkOnCiv.getReligionManager().getReligion();
        if (religion == null) return true;
        if (!religion.hasBelief($conditional.getParams().get(0))) return true;
        return false;
    }

    private static final boolean conditionalApplies$lambda$35(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getReligionManager().getReligionState() == ReligionState.None;
    }

    private static final boolean conditionalApplies$lambda$36(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getReligionManager().getReligionState() != ReligionState.None;
    }

    private static final boolean conditionalApplies$lambda$37(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getReligionManager().getReligionState().compareTo((Enum)ReligionState.Religion) < 0;
    }

    private static final boolean conditionalApplies$lambda$38(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getReligionManager().getReligionState().compareTo((Enum)ReligionState.Religion) >= 0;
    }

    private static final boolean conditionalApplies$lambda$39(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getReligionManager().getReligionState().compareTo((Enum)ReligionState.EnhancedReligion) < 0;
    }

    private static final boolean conditionalApplies$lambda$40(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getReligionManager().getReligionState().compareTo((Enum)ReligionState.EnhancedReligion) >= 0;
    }

    private static final boolean conditionalApplies$lambda$41(Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        return $this$checkOnCiv.getReligionManager().greatProphetsEarned() > 0;
    }

    private static final boolean conditionalApplies$lambda$42(Unique $conditional, Civilization $this$checkOnCiv) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
            Iterable $this$any$iv = $this$checkOnCiv.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!it.getCityConstructions().containsBuildingOrEquivalent($conditional.getParams().get(0))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$43(Unique $conditional, Civilization $this$checkOnCiv) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
            Iterable $this$none$iv = $this$checkOnCiv.getCities();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!it.getCityConstructions().containsBuildingOrEquivalent($conditional.getParams().get(0))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean conditionalApplies$lambda$44(Unique $conditional, Civilization $this$checkOnCiv) {
        boolean bl;
        block4: {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
            Iterable $this$filter$iv = $this$checkOnCiv.getCities();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                City it = (City)element$iv$iv;
                boolean bl2 = false;
                if (!City.matchesFilter$default(it, $conditional.getParams().get(1), null, false, 6, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    City it = (City)element$iv;
                    boolean bl3 = false;
                    if (it.getCityConstructions().containsBuildingOrEquivalent($conditional.getParams().get(0))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$45(Unique $conditional, Civilization $this$checkOnCiv) {
        int n;
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        Iterable $this$count$iv = $this$checkOnCiv.getCities();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                City it = (City)element$iv;
                boolean bl = false;
                if (!(it.getCityConstructions().containsBuildingOrEquivalent($conditional.getParams().get(0)) && City.matchesFilter$default(it, $conditional.getParams().get(2), null, false, 6, null)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n >= Integer.parseInt($conditional.getParams().get(1));
    }

    private static final boolean conditionalApplies$lambda$46(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
            Sequence<City> $this$any$iv = $this$checkOnGameInfo.getCities();
            boolean $i$f$any = false;
            Iterator<City> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                City element$iv;
                City it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!it.getCityConstructions().containsBuildingOrEquivalent($conditional.getParams().get(0))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$47(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
            Sequence<City> $this$any$iv = $this$checkOnGameInfo.getCities();
            boolean $i$f$any = false;
            Iterator<City> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                City element$iv;
                City it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!it.getCityConstructions().containsBuildingOrEquivalent($conditional.getParams().get(0))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$48(Unique $conditional, GameContext $state, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return City.matchesFilter$default($this$checkOnCity, $conditional.getParams().get(0), $state.getRelevantCiv(), false, 4, null);
    }

    private static final boolean conditionalApplies$lambda$49(City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return $this$checkOnCity.isConnectedToCapital();
    }

    private static final boolean conditionalApplies$lambda$50(Unique $conditional, GameContext $state, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        Religion religion = $this$checkOnCity.getReligion().getMajorityReligion();
        return religion != null ? religion.matchesFilter($conditional.getParams().get(0), $state, $state.getRelevantCiv()) : false;
    }

    private static final boolean conditionalApplies$lambda$51(Unique $conditional, GameContext $state, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        Religion religion = $this$checkOnCity.getReligion().getMajorityReligion();
        return !(religion != null ? religion.matchesFilter($conditional.getParams().get(0), $state, $state.getRelevantCiv()) : false);
    }

    private static final boolean conditionalApplies$lambda$52(City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        Religion religion = $this$checkOnCity.getReligion().getMajorityReligion();
        return religion != null ? religion.isMajorReligion() : false;
    }

    private static final boolean conditionalApplies$lambda$53(City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        Religion religion = $this$checkOnCity.getReligion().getMajorityReligion();
        return religion != null ? religion.isEnhancedReligion() : false;
    }

    private static final boolean conditionalApplies$lambda$54(GameContext $state, City $this$checkOnCity) {
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return Intrinsics.areEqual($this$checkOnCity.getReligion().getMajorityReligion(), (isPartOfGameInfoSerialization = $state.getRelevantCiv()) != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getReligionManager()) != null ? ((ReligionManager)isPartOfGameInfoSerialization).getReligion() : null);
    }

    private static final boolean conditionalApplies$lambda$55(City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return $this$checkOnCity.isWeLoveTheKingDayActive();
    }

    private static final boolean conditionalApplies$lambda$56(Unique $conditional, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return $this$checkOnCity.getCityConstructions().containsBuildingOrEquivalent($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$57(Unique $conditional, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return !$this$checkOnCity.getCityConstructions().containsBuildingOrEquivalent($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$58(Unique $conditional, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return $this$checkOnCity.getPopulation().getPopulationFilterAmount($conditional.getParams().get(1)) >= Integer.parseInt($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$59(Unique $conditional, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return $this$checkOnCity.getPopulation().getPopulationFilterAmount($conditional.getParams().get(1)) == Integer.parseInt($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$60(Unique $conditional, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        int n = Integer.parseInt($conditional.getParams().get(0));
        int n2 = Integer.parseInt($conditional.getParams().get(1));
        int n3 = $this$checkOnCity.getPopulation().getPopulationFilterAmount($conditional.getParams().get(2));
        return n <= n3 ? n3 <= n2 : false;
    }

    private static final boolean conditionalApplies$lambda$61(Unique $conditional, City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        return $this$checkOnCity.getPopulation().getPopulationFilterAmount($conditional.getParams().get(1)) < Integer.parseInt($conditional.getParams().get(0));
    }

    private static final boolean conditionalApplies$lambda$62(City $this$checkOnCity) {
        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
        MapUnit mapUnit = $this$checkOnCity.getCenterTile().getMilitaryUnit();
        return mapUnit != null ? mapUnit.canGarrison() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean conditionalApplies$lambda$66(GameContext $state, Civilization $this$checkOnCiv) {
        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
        if ($state.getRelevantTile() == null) return false;
        if ($this$checkOnCiv.getCities().isEmpty()) return true;
        if (Civilization.getCapital$default($this$checkOnCiv, false, 1, null) == null) return true;
        City city = Civilization.getCapital$default($this$checkOnCiv, false, 1, null);
        Intrinsics.checkNotNull(city);
        int n = city.getCenterTile().getContinent();
        Tile tile = $state.getRelevantTile();
        Intrinsics.checkNotNull(tile);
        if (n == tile.getContinent()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean conditionalApplies$lambda$69(GameContext $state, Unique $unique, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        Iterable $this$none$iv = $this$checkOnGameInfo.getCivilizations();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Civilization it = (Civilization)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual(it, $state.getRelevantCiv()) && it.isMajorCiv()) {
                TechManager techManager = it.getTech();
                String string = $unique.getSourceObjectName();
                Intrinsics.checkNotNull(string);
                if (techManager.isResearched(string)) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean conditionalApplies$lambda$70(GameContext $state, Unique $unique, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
        Iterable $this$none$iv = $this$checkOnGameInfo.getCivilizations();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            Civilization it = (Civilization)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual(it, $state.getRelevantCiv()) && it.isMajorCiv()) {
                PolicyManager policyManager = it.getPolicies();
                String string = $unique.getSourceObjectName();
                Intrinsics.checkNotNull(string);
                if (policyManager.isAdopted(string)) {
                    return false;
                }
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private static final boolean conditionalApplies$lambda$71(int first2, int second2) {
        return first2 == second2;
    }

    private static final boolean conditionalApplies$lambda$72(int first2, int second2) {
        return first2 != second2;
    }

    private static final boolean conditionalApplies$lambda$73(int first2, int second2) {
        return first2 > second2;
    }

    private static final boolean conditionalApplies$lambda$74(int first2, int second2) {
        return first2 < second2;
    }

    private static final boolean conditionalApplies$lambda$75(int first2, int second2, int third) {
        return second2 <= first2 ? first2 <= third : false;
    }

    private static final boolean conditionalApplies$lambda$76(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
            String filter2 = $conditional.getParams().get(0);
            Sequence<String> $this$any$iv = SequencesKt.plus(CollectionsKt.asSequence((Iterable)$this$checkOnGameInfo.getGameParameters().getMods()), $this$checkOnGameInfo.getGameParameters().getBaseRuleset());
            boolean $i$f$any = false;
            Iterator<String> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv;
                String it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!ModCompatibility.INSTANCE.modNameFilter(it, filter2)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean conditionalApplies$lambda$77(Unique $conditional, GameInfo $this$checkOnGameInfo) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
            String filter2 = $conditional.getParams().get(0);
            Sequence<String> $this$none$iv = SequencesKt.plus(CollectionsKt.asSequence((Iterable)$this$checkOnGameInfo.getGameParameters().getMods()), $this$checkOnGameInfo.getGameParameters().getBaseRuleset());
            boolean $i$f$none = false;
            Iterator<String> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                String element$iv;
                String it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!ModCompatibility.INSTANCE.modNameFilter(it, filter2)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UniqueType.values().length];
            try {
                nArray[UniqueType.ConditionalChance.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalEveryTurns.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforeTurns.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterTurns.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalTutorialsEnabled.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalTutorialCompleted.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCivFilter.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWar.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNotWar.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWithResource.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWithoutResource.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenAboveAmountStatResource.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenBelowAmountStatResource.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenBetweenStatResource.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalHappy.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalGoldenAge.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNotGoldenAge.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforeEra.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalStartingFromEra.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalDuringEra.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalIfStartingInEra.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalSpeed.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalDifficulty.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalDifficultyOrHigher.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalDifficultyOrLower.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVictoryEnabled.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVictoryDisabled.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalReligionEnabled.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalReligionDisabled.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalEspionageEnabled.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalEspionageDisabled.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNuclearWeaponsEnabled.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNuclearWeaponsDisabled.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalTech.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNoTech.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhileResearching.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNoCivAdopted.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterPolicyOrBelief.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforePolicyOrBelief.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforePantheon.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterPantheon.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforeReligion.ordinal()] = 42;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterReligion.ordinal()] = 43;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforeEnhancingReligion.ordinal()] = 44;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterEnhancingReligion.ordinal()] = 45;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterGeneratingGreatProphet.ordinal()] = 46;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingBuilt.ordinal()] = 47;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingNotBuilt.ordinal()] = 48;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingBuiltAll.ordinal()] = 49;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingBuiltAmount.ordinal()] = 50;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingBuiltByAnybody.ordinal()] = 51;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingNotBuiltByAnybody.ordinal()] = 52;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInThisCity.ordinal()] = 53;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityFilter.ordinal()] = 54;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityConnected.ordinal()] = 55;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityReligion.ordinal()] = 56;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityNotReligion.ordinal()] = 57;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityMajorReligion.ordinal()] = 58;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityEnhancedReligion.ordinal()] = 59;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityThisReligion.ordinal()] = 60;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWLTKD.ordinal()] = 61;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityWithBuilding.ordinal()] = 62;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityWithoutBuilding.ordinal()] = 63;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalPopulationFilter.ordinal()] = 64;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalExactPopulationFilter.ordinal()] = 65;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBetweenPopulationFilter.ordinal()] = 66;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBelowPopulationFilter.ordinal()] = 67;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenGarrisoned.ordinal()] = 68;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVsCity.ordinal()] = 69;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVsUnits.ordinal()] = 70;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVsCombatant.ordinal()] = 71;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalOurUnit.ordinal()] = 72;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalOurUnitOnUnit.ordinal()] = 73;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalUnitWithPromotion.ordinal()] = 74;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalUnitWithoutPromotion.ordinal()] = 75;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAttacking.ordinal()] = 76;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalDefending.ordinal()] = 77;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAboveHP.ordinal()] = 78;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBelowHP.ordinal()] = 79;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalHasNotUsedOtherActions.ordinal()] = 80;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalStackedWithUnit.ordinal()] = 81;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNotStackedWithUnit.ordinal()] = 82;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInTiles.ordinal()] = 83;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInTilesNot.ordinal()] = 84;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAdjacentTo.ordinal()] = 85;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNotAdjacentTo.ordinal()] = 86;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalFightingInTiles.ordinal()] = 87;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNearTiles.ordinal()] = 88;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVsLargerCiv.ordinal()] = 89;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalForeignContinent.ordinal()] = 90;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAdjacentUnit.ordinal()] = 91;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNeighborTiles.ordinal()] = 92;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalOnWaterMaps.ordinal()] = 93;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInRegionOfType.ordinal()] = 94;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInRegionExceptOfType.ordinal()] = 95;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalFirstCivToResearch.ordinal()] = 96;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalFirstCivToAdopt.ordinal()] = 97;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableEqualTo.ordinal()] = 98;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableDifferentThan.ordinal()] = 99;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableMoreThan.ordinal()] = 100;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableLessThan.ordinal()] = 101;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableBetween.ordinal()] = 102;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenCarriedBy.ordinal()] = 103;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalModEnabled.ordinal()] = 104;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalModNotEnabled.ordinal()] = 105;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

