/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0003J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0003J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0007J&\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0007\u00a8\u0006\u0019"}, d2={"Lcom/unciv/models/ruleset/validation/ModCompatibility;", "", "<init>", "()V", "isAudioVisualMod", "", "mod", "Lcom/unciv/models/ruleset/Ruleset;", "isAudioVisualDeclared", "(Lcom/unciv/models/ruleset/Ruleset;)Ljava/lang/Boolean;", "isAudioVisualGuessed", "isExtensionMod", "isConstantsOnly", "modNameFilter", "modName", "", "filter", "isIncompatibleWith", "otherMod", "isIncompatible", "meetsBaseRequirements", "baseRuleset", "meetsAllRequirements", "selectedExtensionMods", "", "core"})
@SourceDebugExtension(value={"SMAP\nModCompatibility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModCompatibility.kt\ncom/unciv/models/ruleset/validation/ModCompatibility\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n11561#2:141\n11896#2,3:142\n1255#3,2:145\n2746#4,3:147\n827#4:150\n855#4,2:151\n1761#4,3:153\n2746#4,3:156\n*S KotlinDebug\n*F\n+ 1 ModCompatibility.kt\ncom/unciv/models/ruleset/validation/ModCompatibility\n*L\n71#1:141\n71#1:142,3\n85#1:145,2\n111#1:147,3\n129#1:150\n129#1:151,2\n130#1:153,3\n135#1:156,3\n*E\n"})
public final class ModCompatibility {
    @NotNull
    public static final ModCompatibility INSTANCE = new ModCompatibility();

    private ModCompatibility() {
    }

    @Readonly
    public final boolean isAudioVisualMod(@NotNull Ruleset mod) {
        Intrinsics.checkNotNullParameter(mod, "mod");
        Boolean bl = this.isAudioVisualDeclared(mod);
        return bl != null ? bl.booleanValue() : this.isAudioVisualGuessed(mod);
    }

    @Readonly
    private final Boolean isAudioVisualDeclared(Ruleset mod) {
        if (IHasUniques.hasUnique$default(mod.getModOptions(), UniqueType.ModIsAudioVisualOnly, null, 2, null)) {
            return true;
        }
        if (IHasUniques.hasUnique$default(mod.getModOptions(), UniqueType.ModIsAudioVisual, null, 2, null)) {
            return true;
        }
        if (IHasUniques.hasUnique$default(mod.getModOptions(), UniqueType.ModIsNotAudioVisual, null, 2, null)) {
            return false;
        }
        return null;
    }

    @Readonly
    private final boolean isAudioVisualGuessed(Ruleset mod) {
        FileHandle fileHandle = mod.getFolderLocation();
        if (fileHandle == null) {
            return false;
        }
        FileHandle folder = fileHandle;
        if (ModCompatibility.isAudioVisualGuessed$isSubFolderNotEmpty(folder, "music")) {
            return true;
        }
        if (ModCompatibility.isAudioVisualGuessed$isSubFolderNotEmpty(folder, "sounds")) {
            return true;
        }
        if (ModCompatibility.isAudioVisualGuessed$isSubFolderNotEmpty(folder, "voices")) {
            return true;
        }
        FileHandle[] fileHandleArray = folder.list("atlas");
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        return !(((Object[])fileHandleArray).length == 0);
    }

    @Readonly
    public final boolean isExtensionMod(@NotNull Ruleset mod) {
        Intrinsics.checkNotNullParameter(mod, "mod");
        return !mod.getModOptions().isBaseRuleset() && !StringsKt.isBlank(mod.getName()) && !IHasUniques.hasUnique$default(mod.getModOptions(), UniqueType.ModIsAudioVisualOnly, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    public final boolean isConstantsOnly(@NotNull Ruleset mod) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(mod, "mod");
        FileHandle fileHandle = mod.getFolderLocation();
        if (fileHandle == null) {
            return false;
        }
        FileHandle folder = fileHandle;
        FileHandle[] fileHandleArray = folder.list("atlas");
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        if (!(((Object[])fileHandleArray).length == 0)) {
            return false;
        }
        FileHandle jsonFolder = folder.child("jsons");
        if (!jsonFolder.exists() || !jsonFolder.isDirectory()) {
            return false;
        }
        FileHandle[] fileHandleArray2 = jsonFolder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray2, "list(...)");
        Object[] $this$map$iv = fileHandleArray2;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileHandle fileHandle2 = (FileHandle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        return Intrinsics.areEqual((List)destination$iv$iv, CollectionsKt.listOf("ModOptions.json"));
    }

    @Pure
    public final boolean modNameFilter(@NotNull String modName, @NotNull String filter2) {
        Intrinsics.checkNotNullParameter(modName, "modName");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        if (Intrinsics.areEqual(modName, filter2)) {
            return true;
        }
        if (filter2.length() < 3 || !StringsKt.startsWith$default((CharSequence)filter2, '*', false, 2, null) || !StringsKt.endsWith$default((CharSequence)filter2, '*', false, 2, null)) {
            return false;
        }
        String string = filter2.substring(1, filter2.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String partialName = string2;
        String string3 = modName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        return StringsKt.contains$default((CharSequence)string3, partialName, false, 2, null);
    }

    @Readonly
    private final boolean isIncompatibleWith(Ruleset mod, Ruleset otherMod) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = IHasUniques.getMatchingUniques$default(mod.getModOptions(), UniqueType.ModIncompatibleWith, null, 2, null);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!INSTANCE.modNameFilter(otherMod.getName(), it.getParams().get(0))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Readonly
    private final boolean isIncompatible(Ruleset mod, Ruleset otherMod) {
        return this.isIncompatibleWith(mod, otherMod) || this.isIncompatibleWith(otherMod, mod);
    }

    @Readonly
    public final boolean meetsBaseRequirements(@NotNull Ruleset mod, @NotNull Ruleset baseRuleset) {
        Intrinsics.checkNotNullParameter(mod, "mod");
        Intrinsics.checkNotNullParameter(baseRuleset, "baseRuleset");
        if (this.isIncompatible(mod, baseRuleset)) {
            return false;
        }
        Collection<Ruleset> collection = RulesetCache.INSTANCE.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        List<String> allOtherExtensionModNames = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), arg_0 -> ModCompatibility.meetsBaseRequirements$lambda$0(mod, arg_0)), ModCompatibility::meetsBaseRequirements$lambda$1));
        Iterator iterator2 = IHasUniques.getMatchingUniques$default(mod.getModOptions(), UniqueType.ModRequires, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            block5: {
                Unique unique = (Unique)iterator2.next();
                String filter2 = unique.getParams().get(0);
                if (this.modNameFilter(baseRuleset.getName(), filter2)) continue;
                Iterable $this$none$iv = allOtherExtensionModNames;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.modNameFilter(it, filter2)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            return false;
        }
        return true;
    }

    @Readonly
    public final boolean meetsAllRequirements(@NotNull Ruleset mod, @NotNull Ruleset baseRuleset, @NotNull Iterable<Ruleset> selectedExtensionMods) {
        boolean bl;
        List otherSelectedExtensionMods;
        Ruleset it;
        block9: {
            Iterator $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(baseRuleset, "baseRuleset");
            Intrinsics.checkNotNullParameter(selectedExtensionMods, "selectedExtensionMods");
            Iterable<Ruleset> $this$filterNot$iv = selectedExtensionMods;
            boolean $i$f$filterNot = false;
            Iterable<Ruleset> iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                it = (Ruleset)element$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual(it, mod)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            otherSelectedExtensionMods = CollectionsKt.toList((List)destination$iv$iv);
            Iterable $this$any$iv = otherSelectedExtensionMods;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Ruleset it2 = (Ruleset)element$iv;
                    boolean bl3 = false;
                    if (!INSTANCE.isIncompatible(mod, it2)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Iterator iterator3 = IHasUniques.getMatchingUniques$default(mod.getModOptions(), UniqueType.ModRequires, null, 2, null).iterator();
        while (iterator3.hasNext()) {
            boolean bl4;
            block10: {
                Unique unique = (Unique)iterator3.next();
                String filter2 = unique.getParams().get(0);
                if (this.modNameFilter(baseRuleset.getName(), filter2)) continue;
                Iterable $this$none$iv = otherSelectedExtensionMods;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (Ruleset)element$iv;
                        boolean bl5 = false;
                        if (!INSTANCE.modNameFilter(it.getName(), filter2)) continue;
                        bl4 = false;
                        break block10;
                    }
                    bl4 = true;
                }
            }
            if (!bl4) continue;
            return false;
        }
        return true;
    }

    @Readonly
    private static final boolean isAudioVisualGuessed$isSubFolderNotEmpty(FileHandle modFolder, String name) {
        FileHandle file = modFolder.child(name);
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        FileHandle[] fileHandleArray = file.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        return !(((Object[])fileHandleArray).length == 0);
    }

    private static final boolean meetsBaseRequirements$lambda$0(Ruleset $mod, Ruleset it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !Intrinsics.areEqual(it, $mod) && !it.getModOptions().isBaseRuleset() && ((CharSequence)it.getName()).length() > 0;
    }

    private static final String meetsBaseRequirements$lambda$1(Ruleset it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName();
    }
}

