/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.tilesets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.tilesets.TileSet;
import com.unciv.models.tilesets.TileSetConfig;
import com.unciv.ui.images.ImageGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0003J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/unciv/models/tilesets/TileSetCache;", "Ljava/util/HashMap;", "", "Lcom/unciv/models/tilesets/TileSet;", "Lkotlin/collections/HashMap;", "<init>", "()V", "getCurrent", "assembleTileSetConfigs", "", "ruleSetMods", "", "loadTileSetConfigs", "consoleMode", "", "loadConfigFiles", "files", "", "Lcom/badlogic/gdx/files/FileHandle;", "configId", "core"})
@SourceDebugExtension(value={"SMAP\nTileSetCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileSetCache.kt\ncom/unciv/models/tilesets/TileSetCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1869#2,2:102\n1617#2,9:104\n1869#2:113\n1870#2:115\n1626#2:116\n1869#2,2:117\n1#3:114\n*S KotlinDebug\n*F\n+ 1 TileSetCache.kt\ncom/unciv/models/tilesets/TileSetCache\n*L\n32#1:102,2\n66#1:104,9\n66#1:113\n66#1:115\n66#1:116\n76#1:117,2\n66#1:114\n*E\n"})
public final class TileSetCache
extends HashMap<String, TileSet> {
    @NotNull
    public static final TileSetCache INSTANCE = new TileSetCache();

    private TileSetCache() {
    }

    @NotNull
    public final TileSet getCurrent() {
        Object object = this.get((Object)UncivGame.Companion.getCurrent().getSettings().getTileSet());
        Intrinsics.checkNotNull(object);
        return (TileSet)object;
    }

    public final void assembleTileSetConfigs(@NotNull Set<String> ruleSetMods) {
        Intrinsics.checkNotNullParameter(ruleSetMods, "ruleSetMods");
        ArrayList<String> mods = new ArrayList<String>();
        mods.add("INTERNAL");
        if (UncivGame.Companion.isCurrentInitialized()) {
            mods.addAll((Collection)UncivGame.Companion.getCurrent().getSettings().getVisualMods());
        }
        mods.addAll((Collection)ruleSetMods);
        Collection<TileSet> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TileSet it = (TileSet)element$iv;
            boolean bl = false;
            it.resetConfig();
        }
        for (String mod : CollectionsKt.distinct((Iterable)mods)) {
            for (Object object : this.values()) {
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                TileSet tileset = (TileSet)object;
                tileset.mergeModConfig(mod);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void loadTileSetConfigs(boolean consoleMode) {
        List list2;
        List<Object> list3;
        this.clear();
        if (consoleMode) {
            FileHandle[] fileHandleArray = new FileHandle("jsons/TileSets").list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
            list3 = ArraysKt.toList((Object[])fileHandleArray);
        } else {
            list3 = SequencesKt.toList(SequencesKt.filter(SequencesKt.map(ImageGetter.INSTANCE.getAvailableTilesets(), TileSetCache::loadTileSetConfigs$lambda$0), TileSetCache::loadTileSetConfigs$lambda$1));
        }
        List<FileHandle> internalFiles = list3;
        this.loadConfigFiles(internalFiles, "INTERNAL");
        if (consoleMode) {
            FileHandle[] fileHandleArray = new FileHandle("mods").list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
            list2 = ArraysKt.toList((Object[])fileHandleArray);
        } else {
            void $this$mapNotNullTo$iv$iv;
            Collection<Ruleset> collection = RulesetCache.INSTANCE.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$mapNotNull$iv = collection;
            boolean $i$f$mapNotNull = false;
            Object object = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FileHandle it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Ruleset it = (Ruleset)element$iv$iv;
                boolean bl2 = false;
                if (it.getFolderLocation() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List modsHandles = list2;
        for (FileHandle modFolder : modsHandles) {
            String modName = modFolder.name();
            if (!modFolder.isDirectory()) continue;
            Intrinsics.checkNotNull(modName);
            if (StringsKt.startsWith$default((CharSequence)modName, '.', false, 2, null)) continue;
            FileHandle[] fileHandleArray = modFolder.child("jsons/TileSets").list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
            List<Object> modFiles = ArraysKt.toList((Object[])fileHandleArray);
            this.loadConfigFiles(modFiles, modName);
        }
        Collection<TileSet> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TileSet it = (TileSet)element$iv;
            boolean bl = false;
            it.setFallback((TileSet)((Map)INSTANCE).get(it.getConfig().getFallbackTileSet()));
        }
        this.assembleTileSetConfigs(new HashSet());
    }

    public static /* synthetic */ void loadTileSetConfigs$default(TileSetCache tileSetCache, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        tileSetCache.loadTileSetConfigs(bl);
    }

    private final void loadConfigFiles(List<? extends FileHandle> files, String configId) {
        for (FileHandle fileHandle : files) {
            TileSetConfig tileSetConfig;
            if (fileHandle.isDirectory() || !Intrinsics.areEqual(fileHandle.extension(), "json")) continue;
            try {
                tileSetConfig = UncivJsonKt.fromJsonFile(UncivJsonKt.json(), TileSetConfig.class, fileHandle);
            }
            catch (Exception exception2) {
                continue;
            }
            TileSetConfig config2 = tileSetConfig;
            String string = fileHandle.nameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
            String name = StringsKt.removeSuffix(string, (CharSequence)"Config");
            TileSet tileSet = (TileSet)this.get((Object)name);
            if (tileSet == null) {
                tileSet = new TileSet(name);
            }
            TileSet tileset = tileSet;
            tileset.cacheConfigFromMod(configId, config2);
            ((Map)this).put(name, tileset);
        }
    }

    private static final FileHandle loadTileSetConfigs$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Gdx.files.internal("jsons/TileSets/" + it + ".json");
    }

    private static final boolean loadTileSetConfigs$lambda$1(FileHandle it) {
        return it.exists();
    }
}

