/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013J\u001a\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u000fH\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerResource;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "resourceName", "", "resourceAmount", "", "resourceIcon", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "updateResourceIcon", "", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "show", "", "reset", "dimResource", "dim", "doUpdate", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "determineVisibility", "core"})
public final class TileLayerResource
extends TileLayer {
    @Nullable
    private String resourceName;
    private int resourceAmount;
    @Nullable
    private Actor resourceIcon;

    public TileLayerResource(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size);
        this.resourceAmount = -1;
    }

    /*
     * Unable to fully structure code
     */
    private final void updateResourceIcon(Civilization viewingCiv, boolean show) {
        block8: {
            block9: {
                block7: {
                    if (!this.getTileGroup().isForceVisible()) break block7;
                    v0 = show;
                    break block8;
                }
                if (!show || viewingCiv != null) break block9;
                v0 = true;
                break block8;
            }
            if (!show) ** GOTO lbl-1000
            v1 = viewingCiv;
            v2 = v1 != null ? v1.canSeeResource(this.getTile().getTileResource()) : false;
            if (v2) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = effectiveVisible = false;
            }
        }
        if (!Intrinsics.areEqual(this.resourceName, this.getTile().getResource()) || this.resourceAmount != this.getTile().getResourceAmount()) {
            this.resourceName = this.getTile().getResource();
            this.resourceAmount = this.getTile().getResourceAmount();
            v3 = this.resourceIcon;
            if (v3 != null) {
                v3.remove();
            }
            this.resourceIcon = null;
        }
        if (this.resourceName != null && effectiveVisible && this.resourceIcon == null) {
            v4 = this.resourceName;
            Intrinsics.checkNotNull(v4);
            icon = ImageGetter.INSTANCE.getResourcePortrait(v4, 20.0f, this.resourceAmount);
            Scene2dExtensionsKt.center((Actor)icon, this.getTileGroup());
            icon.setX(icon.getX() - (float)22);
            icon.setY(icon.getY() + (float)10);
            this.addActor(icon);
            this.resourceIcon = icon;
        }
        v5 = this.resourceIcon;
        if (v5 != null) {
            v5.setVisible(effectiveVisible);
        }
        if (this.resourceIcon != null) {
            isViewable = viewingCiv == null || this.isViewable(viewingCiv) != false;
            this.dimResource(isViewable == false);
        }
    }

    public final void reset() {
        this.updateResourceIcon(null, false);
    }

    public final void dimResource(boolean dim) {
        block0: {
            Object object = this.resourceIcon;
            if (object == null || (object = ((Actor)object).getColor()) == null) break block0;
            ((Color)object).a = dim ? 0.5f : 1.0f;
        }
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        boolean showResourcesAndImprovements = this.getTileGroup() instanceof WorldTileGroup ? UncivGame.Companion.getCurrent().getSettings().getShowResourcesAndImprovements() : true;
        this.updateResourceIcon(viewingCiv, showResourcesAndImprovements);
    }

    @Override
    protected void determineVisibility() {
        Actor actor = this.resourceIcon;
        this.setVisible(actor != null ? actor.isVisible() : false);
    }
}

