/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.logic.files.IMediaFinder;
import com.unciv.logic.multiplayer.Multiplayer;
import com.unciv.logic.multiplayer.storage.AuthStatus;
import com.unciv.logic.multiplayer.storage.FileStorageRateLimitReached;
import com.unciv.logic.multiplayer.storage.MultiplayerAuthException;
import com.unciv.logic.multiplayer.storage.MultiplayerServer;
import com.unciv.models.UncivSound;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.AuthPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.options.MultiplayerSelectBoxHelpers;
import com.unciv.ui.popups.options.MultiplayerTab;
import com.unciv.ui.popups.options.MultiplayerTab$lateInitialize$soundsProvider$lambda$0$;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.popups.options.OptionsPopupHelpers;
import com.unciv.ui.popups.options.OptionsPopupTab;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002J$\u0010\u001d\u001a\u00020\u00172\u001a\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0004\u0012\u00020\u00170\u001fH\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J2\u0010$\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2 \u0010\u001e\u001a\u001c\u0012\u0004\u0012\u00020 \u0012\f\u0012\n\u0018\u00010%j\u0004\u0018\u0001`&\u0012\u0004\u0012\u00020\u00170\u001fH\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0002R!\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f*\u0004\b\t\u0010\nR!\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013*\u0004\b\u0011\u0010\n\u00a8\u0006*"}, d2={"Lcom/unciv/ui/popups/options/MultiplayerTab;", "Lcom/unciv/ui/popups/options/OptionsPopupTab;", "Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers;", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "<init>", "(Lcom/unciv/ui/popups/options/OptionsPopup;)V", "mpSettings", "Lcom/unciv/models/metadata/GameSettings$GameSettingsMultiplayer;", "getMpSettings$delegate", "(Lcom/unciv/ui/popups/options/MultiplayerTab;)Ljava/lang/Object;", "getMpSettings", "()Lcom/unciv/models/metadata/GameSettings$GameSettingsMultiplayer;", "mpSettings$receiver", "Lcom/unciv/models/metadata/GameSettings;", "mpServer", "Lcom/unciv/logic/multiplayer/storage/MultiplayerServer;", "getMpServer$delegate", "getMpServer", "()Lcom/unciv/logic/multiplayer/storage/MultiplayerServer;", "mpServer$receiver", "Lcom/unciv/logic/multiplayer/Multiplayer;", "lateInitialize", "", "addMultiplayerServerOptions", "toUpdate", "", "Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$RefreshSelectOptions;", "addTurnCheckerOptions", "successfullyConnectedToServer", "action", "Lkotlin/Function2;", "", "setPassword", "password", "", "successfullySetPassword", "Ljava/lang/Exception;", "Lkotlin/Exception;", "fixTextFieldUrlOnType", "textField", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField;", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerTab.kt\ncom/unciv/ui/popups/options/MultiplayerTab\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,342:1\n49#2:343\n51#2:347\n46#3:344\n51#3:346\n105#4:345\n*S KotlinDebug\n*F\n+ 1 MultiplayerTab.kt\ncom/unciv/ui/popups/options/MultiplayerTab\n*L\n66#1:343\n66#1:347\n66#1:344\n66#1:346\n66#1:345\n*E\n"})
public final class MultiplayerTab
extends OptionsPopupTab
implements MultiplayerSelectBoxHelpers {
    @NotNull
    private final GameSettings mpSettings$receiver;
    @NotNull
    private final Multiplayer mpServer$receiver;

    public MultiplayerTab(@NotNull OptionsPopup optionsPopup) {
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        super(optionsPopup);
        this.mpSettings$receiver = this.getSettings();
        this.mpServer$receiver = this.getGame().getOnlineMultiplayer();
    }

    private final GameSettings.GameSettingsMultiplayer getMpSettings() {
        return this.mpSettings$receiver.getMultiplayer();
    }

    private static Object getMpSettings$delegate(MultiplayerTab multiplayerTab) {
        return Reflection.mutableProperty0(new MutablePropertyReference0Impl((Object)multiplayerTab.mpSettings$receiver, GameSettings.class, "multiplayer", "getMultiplayer()Lcom/unciv/models/metadata/GameSettings$GameSettingsMultiplayer;", 0));
    }

    private final MultiplayerServer getMpServer() {
        return this.mpServer$receiver.getMultiplayerServer();
    }

    private static Object getMpServer$delegate(MultiplayerTab multiplayerTab) {
        return Reflection.property0(new PropertyReference0Impl((Object)multiplayerTab.mpServer$receiver, Multiplayer.class, "multiplayerServer", "getMultiplayerServer()Lcom/unciv/logic/multiplayer/storage/MultiplayerServer;", 0));
    }

    @Override
    public void lateInitialize() {
        OptionsPopupHelpers.addCheckbox$default(this, this, "Enable multiplayer status button in singleplayer games", new MutablePropertyReference0Impl(this.getMpSettings()){

            public Object get() {
                return ((GameSettings.GameSettingsMultiplayer)this.receiver).getStatusButtonInSinglePlayer();
            }

            public void set(Object value) {
                ((GameSettings.GameSettingsMultiplayer)this.receiver).setStatusButtonInSinglePlayer((Boolean)value);
            }
        }, true, null, 8, null);
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        long[] lArray = new long[]{3L, 5L};
        Iterable iterable = this.createRefreshOptions(ChronoUnit.SECONDS, lArray);
        lArray = new long[]{10L, 20L, 30L, 60L};
        MultiplayerSelectBoxHelpers.RefreshSelectOptions curRefreshSelect2 = new MultiplayerSelectBoxHelpers.RefreshSelectOptions(new MutablePropertyReference0Impl(this.getMpSettings()){

            public Object get() {
                return ((GameSettings.GameSettingsMultiplayer)this.receiver).getCurrentGameRefreshDelay();
            }

            public void set(Object value) {
                ((GameSettings.GameSettingsMultiplayer)this.receiver).setCurrentGameRefreshDelay((Duration)value);
            }
        }, iterable, (Iterable<MultiplayerSelectBoxHelpers.DurationItem>)this.createRefreshOptions(ChronoUnit.SECONDS, lArray));
        curRefreshSelect2.setSelectBox(OptionsPopupHelpers.addSelectBox$default(this, this, "Update status of currently played game every:", new MutablePropertyReference0Impl(curRefreshSelect2){

            public Object get() {
                return ((MultiplayerSelectBoxHelpers.RefreshSelectOptions)this.receiver).getValue();
            }

            public void set(Object value) {
                ((MultiplayerSelectBoxHelpers.RefreshSelectOptions)this.receiver).setValue((MultiplayerSelectBoxHelpers.DurationItem)value);
            }
        }, MultiplayerSelectBoxHelpers.RefreshSelectOptions.getItems$default(curRefreshSelect2, false, 1, null), null, 8, null));
        long[] lArray2 = new long[]{15L, 30L};
        Iterable iterable2 = this.createRefreshOptions(ChronoUnit.SECONDS, lArray2);
        lArray2 = new long[]{1L, 2L, 5L, 15L};
        MultiplayerSelectBoxHelpers.RefreshSelectOptions allRefreshSelect2 = new MultiplayerSelectBoxHelpers.RefreshSelectOptions(new MutablePropertyReference0Impl(this.getMpSettings()){

            public Object get() {
                return ((GameSettings.GameSettingsMultiplayer)this.receiver).getAllGameRefreshDelay();
            }

            public void set(Object value) {
                ((GameSettings.GameSettingsMultiplayer)this.receiver).setAllGameRefreshDelay((Duration)value);
            }
        }, iterable2, (Iterable<MultiplayerSelectBoxHelpers.DurationItem>)this.createRefreshOptions(ChronoUnit.MINUTES, lArray2));
        allRefreshSelect2.setSelectBox(OptionsPopupHelpers.addSelectBox$default(this, this, "In-game, update status of all games every:", new MutablePropertyReference0Impl(allRefreshSelect2){

            public Object get() {
                return ((MultiplayerSelectBoxHelpers.RefreshSelectOptions)this.receiver).getValue();
            }

            public void set(Object value) {
                ((MultiplayerSelectBoxHelpers.RefreshSelectOptions)this.receiver).setValue((MultiplayerSelectBoxHelpers.DurationItem)value);
            }
        }, MultiplayerSelectBoxHelpers.RefreshSelectOptions.getItems$default(allRefreshSelect2, false, 1, null), null, 8, null));
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        MultiplayerSelectBoxHelpers.RefreshSelectOptions turnCheckerSelect2 = this.addTurnCheckerOptions();
        IMediaFinder.LabeledSounds labeledSounds = new IMediaFinder.LabeledSounds();
        MultiplayerSelectBoxHelpers.UncivSoundProxy currentSoundProxy2 = new MultiplayerSelectBoxHelpers.UncivSoundProxy(new MutablePropertyReference0Impl(this.getMpSettings()){

            public Object get() {
                return ((GameSettings.GameSettingsMultiplayer)this.receiver).getCurrentGameTurnNotificationSound();
            }

            public void set(Object value) {
                ((GameSettings.GameSettingsMultiplayer)this.receiver).setCurrentGameTurnNotificationSound((UncivSound)value);
            }
        });
        MultiplayerSelectBoxHelpers.UncivSoundProxy otherSoundProxy2 = new MultiplayerSelectBoxHelpers.UncivSoundProxy(new MutablePropertyReference0Impl(this.getMpSettings()){

            public Object get() {
                return ((GameSettings.GameSettingsMultiplayer)this.receiver).getOtherGameTurnNotificationSound();
            }

            public void set(Object value) {
                ((GameSettings.GameSettingsMultiplayer)this.receiver).setOtherGameTurnNotificationSound((UncivSound)value);
            }
        });
        OptionsPopupHelpers.addAsyncSelectBox$default(this, this, "Sound notification for when it's your turn in your currently open game:", new MutablePropertyReference0Impl(currentSoundProxy2){

            public Object get() {
                return ((MultiplayerSelectBoxHelpers.UncivSoundProxy)this.receiver).getValue();
            }

            public void set(Object value) {
                ((MultiplayerSelectBoxHelpers.UncivSoundProxy)this.receiver).setValue((MultiplayerSelectBoxHelpers.UncivSoundLabeled)value);
            }
        }, new Function1<Continuation<? super Flow<? extends MultiplayerSelectBoxHelpers.UncivSoundLabeled>>, Object>(labeledSounds){
            final /* synthetic */ IMediaFinder.LabeledSounds $labeledSounds;
            {
                this.$labeledSounds = $labeledSounds;
                super(1, Intrinsics.Kotlin.class, "soundsProvider", "lateInitialize$soundsProvider(Lcom/unciv/logic/files/IMediaFinder$LabeledSounds;)Lkotlinx/coroutines/flow/Flow;", 4);
            }

            public final Object invoke(Continuation<? super Flow<MultiplayerSelectBoxHelpers.UncivSoundLabeled>> $completion) {
                return MultiplayerTab.access$lateInitialize$soundsProvider$1(this.$labeledSounds, $completion);
            }
        }, null, MultiplayerTab::lateInitialize$lambda$2, 8, null);
        OptionsPopupHelpers.addAsyncSelectBox$default(this, this, "Sound notification for when it's your turn in any other game:", new MutablePropertyReference0Impl(otherSoundProxy2){

            public Object get() {
                return ((MultiplayerSelectBoxHelpers.UncivSoundProxy)this.receiver).getValue();
            }

            public void set(Object value) {
                ((MultiplayerSelectBoxHelpers.UncivSoundProxy)this.receiver).setValue((MultiplayerSelectBoxHelpers.UncivSoundLabeled)value);
            }
        }, new Function1<Continuation<? super Flow<? extends MultiplayerSelectBoxHelpers.UncivSoundLabeled>>, Object>(labeledSounds){
            final /* synthetic */ IMediaFinder.LabeledSounds $labeledSounds;
            {
                this.$labeledSounds = $labeledSounds;
                super(1, Intrinsics.Kotlin.class, "soundsProvider", "lateInitialize$soundsProvider(Lcom/unciv/logic/files/IMediaFinder$LabeledSounds;)Lkotlinx/coroutines/flow/Flow;", 4);
            }

            public final Object invoke(Continuation<? super Flow<MultiplayerSelectBoxHelpers.UncivSoundLabeled>> $completion) {
                return MultiplayerTab.access$lateInitialize$soundsProvider$3(this.$labeledSounds, $completion);
            }
        }, null, MultiplayerTab::lateInitialize$lambda$4, 8, null);
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        MultiplayerSelectBoxHelpers.RefreshSelectOptions[] refreshSelectOptionsArray = new MultiplayerSelectBoxHelpers.RefreshSelectOptions[]{curRefreshSelect2, allRefreshSelect2, turnCheckerSelect2};
        this.addMultiplayerServerOptions((Iterable<MultiplayerSelectBoxHelpers.RefreshSelectOptions>)CollectionsKt.listOfNotNull(refreshSelectOptionsArray));
        super.lateInitialize();
    }

    private final void addMultiplayerServerOptions(Iterable<MultiplayerSelectBoxHelpers.RefreshSelectOptions> toUpdate) {
        TextButton connectionToServerButton = Scene2dExtensionsKt.toTextButton$default("Check connection", null, false, 3, null);
        String textToShowForOnlineMultiplayerAddress = Multiplayer.Companion.usesCustomServer() ? this.getMpSettings().getServer() : "https://";
        UncivTextField multiplayerServerTextField = new UncivTextField("Server address", textToShowForOnlineMultiplayerAddress, null, 4, null);
        multiplayerServerTextField.setTextFieldFilter(MultiplayerTab::addMultiplayerServerOptions$lambda$0);
        multiplayerServerTextField.setProgrammaticChangeEvents(true);
        Table serverIpTable = new Table();
        serverIpTable.add(ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toLabel("Server address"), () -> MultiplayerTab.addMultiplayerServerOptions$lambda$1(multiplayerServerTextField))).colspan(2).padBottom(9.0f).row();
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        Label errorTextField = Scene2dExtensionsKt.toLabel$default("", color, 0, 0, false, 14, null);
        errorTextField.setVisible(false);
        serverIpTable.add((Actor)errorTextField).colspan(2).row();
        ActivationExtensionsKt.onChange(multiplayerServerTextField, arg_0 -> MultiplayerTab.addMultiplayerServerOptions$lambda$2(this, multiplayerServerTextField, errorTextField, connectionToServerButton, toUpdate, arg_0));
        serverIpTable.add((Actor)multiplayerServerTextField).minWidth(this.getOptionsPopup$core().getStageToShowOn().getWidth() / (float)3).padRight(18.0f).growX();
        serverIpTable.add(ActivationExtensionsKt.onClick(connectionToServerButton, () -> MultiplayerTab.addMultiplayerServerOptions$lambda$3(this, multiplayerServerTextField))).row();
        if (this.getMpServer().getFeatureSet().getAuthVersion() > 0) {
            Table table2;
            String string = this.getMpSettings().getCurrentServerPassword();
            if (string == null) {
                string = "Password";
            }
            UncivTextField passwordTextField = new UncivTextField(string, null, null, 6, null);
            TextButton setPasswordButton = Scene2dExtensionsKt.toTextButton$default("Set password", null, false, 3, null);
            serverIpTable.add((Actor)Scene2dExtensionsKt.toLabel("Set password")).padTop(16.0f).colspan(2).row();
            serverIpTable.add((Actor)passwordTextField).colspan(2).growX().padBottom(8.0f).row();
            Label authStatusLabel = Scene2dExtensionsKt.toLabel("Set a password to secure your userId");
            String password = this.getMpSettings().getCurrentServerPassword();
            if (password != null) {
                authStatusLabel.setText("Validating your authentication status...");
                Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, password, authStatusLabel, null){
                    int label;
                    final /* synthetic */ MultiplayerTab this$0;
                    final /* synthetic */ String $password;
                    final /* synthetic */ Label $authStatusLabel;
                    {
                        this.this$0 = $receiver;
                        this.$password = $password;
                        this.$authStatusLabel = $authStatusLabel;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                String string;
                                ResultKt.throwOnFailure($result);
                                String userId = MultiplayerTab.access$getMpSettings(this.this$0).getUserId();
                                AuthStatus authStatus = MultiplayerTab.access$getMpServer(this.this$0).fileStorage().checkAuthStatus(userId, this.$password);
                                switch (addMultiplayerServerOptions.WhenMappings.$EnumSwitchMapping$0[authStatus.ordinal()]) {
                                    case 1: {
                                        string = "Your current password was rejected from the server";
                                        break;
                                    }
                                    case 2: {
                                        string = "You userId is unregistered! Set password to secure your userId";
                                        break;
                                    }
                                    case 3: {
                                        string = "Your current password has been succesfully verified";
                                        break;
                                    }
                                    case 4: {
                                        string = "Your authentication status could not be determined";
                                        break;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                String newAuthStatusText = string;
                                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$authStatusLabel, newAuthStatusText, null){
                                    int label;
                                    final /* synthetic */ Label $authStatusLabel;
                                    final /* synthetic */ String $newAuthStatusText;
                                    {
                                        this.$authStatusLabel = $authStatusLabel;
                                        this.$newAuthStatusText = $newAuthStatusText;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure($result);
                                                this.$authStatusLabel.setText(this.$newAuthStatusText);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            }
            Table $this$addMultiplayerServerOptions_u24lambda_u244 = table2 = new Table();
            boolean bl = false;
            $this$addMultiplayerServerOptions_u24lambda_u244.add((Actor)authStatusLabel);
            $this$addMultiplayerServerOptions_u24lambda_u244.add(ActivationExtensionsKt.onClick(setPasswordButton, () -> MultiplayerTab.addMultiplayerServerOptions$lambda$4$0(this, passwordTextField))).padLeft(16.0f);
            Table passwordStatusTable = table2;
            serverIpTable.add((Actor)passwordStatusTable).colspan(2).row();
        }
        this.add((Actor)serverIpTable).colspan(2).fillX().row();
    }

    private final MultiplayerSelectBoxHelpers.RefreshSelectOptions addTurnCheckerOptions() {
        if (Gdx.app.getType() != Application.ApplicationType.Android) {
            return null;
        }
        OptionsPopupHelpers.addCheckbox$default(this, this, "Enable out-of-game turn notifications", new MutablePropertyReference0Impl(this.getMpSettings()){

            public Object get() {
                return ((GameSettings.GameSettingsMultiplayer)this.receiver).getTurnCheckerEnabled();
            }

            public void set(Object value) {
                ((GameSettings.GameSettingsMultiplayer)this.receiver).setTurnCheckerEnabled((Boolean)value);
            }
        }, false, arg_0 -> MultiplayerTab.addTurnCheckerOptions$lambda$0(this, arg_0), 4, null);
        if (!this.getMpSettings().getTurnCheckerEnabled()) {
            return null;
        }
        long[] lArray = new long[]{30L};
        Iterable iterable = this.createRefreshOptions(ChronoUnit.SECONDS, lArray);
        lArray = new long[]{1L, 2L, 5L, 15L};
        MultiplayerSelectBoxHelpers.RefreshSelectOptions turnCheckerSelect2 = new MultiplayerSelectBoxHelpers.RefreshSelectOptions(new MutablePropertyReference0Impl(this.getMpSettings()){

            public Object get() {
                return ((GameSettings.GameSettingsMultiplayer)this.receiver).getTurnCheckerDelay();
            }

            public void set(Object value) {
                ((GameSettings.GameSettingsMultiplayer)this.receiver).setTurnCheckerDelay((Duration)value);
            }
        }, iterable, (Iterable<MultiplayerSelectBoxHelpers.DurationItem>)this.createRefreshOptions(ChronoUnit.MINUTES, lArray));
        turnCheckerSelect2.setSelectBox(OptionsPopupHelpers.addSelectBox$default(this, this, "Out-of-game, update status of all games every:", new MutablePropertyReference0Impl(turnCheckerSelect2){

            public Object get() {
                return ((MultiplayerSelectBoxHelpers.RefreshSelectOptions)this.receiver).getValue();
            }

            public void set(Object value) {
                ((MultiplayerSelectBoxHelpers.RefreshSelectOptions)this.receiver).setValue((MultiplayerSelectBoxHelpers.DurationItem)value);
            }
        }, MultiplayerSelectBoxHelpers.RefreshSelectOptions.getItems$default(turnCheckerSelect2, false, 1, null), null, 8, null));
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show persistent notification for turn notifier service", new MutablePropertyReference0Impl(this.getMpSettings()){

            public Object get() {
                return ((GameSettings.GameSettingsMultiplayer)this.receiver).getTurnCheckerPersistentNotificationEnabled();
            }

            public void set(Object value) {
                ((GameSettings.GameSettingsMultiplayer)this.receiver).setTurnCheckerPersistentNotificationEnabled((Boolean)value);
            }
        }, false, null, 12, null);
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        return turnCheckerSelect2;
    }

    private final void successfullyConnectedToServer(Function2<? super Boolean, ? super Boolean, Unit> action2) {
        Concurrency.run$default(Concurrency.INSTANCE, "TestIsAlive", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, action2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MultiplayerTab this$0;
            final /* synthetic */ Function2<Boolean, Boolean, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.L$0 = $this$run;
                        this.label = 1;
                        v0 = MultiplayerTab.access$getMpServer(this.this$0).checkServerStatus(this);
                        ** if (v0 != var6_3) goto lbl13
lbl12:
                        // 1 sources

                        return var6_3;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            connectionSuccess = (Boolean)v0;
                            authSuccess = new Ref.ObjectRef<Boolean>();
                            if (connectionSuccess) {
                                try {
                                    authSuccess.element = Boxing.boxBoolean(MultiplayerTab.access$getMpServer(this.this$0).authenticate(null));
                                }
                                catch (MultiplayerAuthException <unused var>) {
                                    authSuccess.element = Boxing.boxBoolean(false);
                                }
                                catch (Throwable var5_8) {
                                    // empty catch block
                                }
                            }
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$action, connectionSuccess != false, authSuccess, null){
                                int label;
                                final /* synthetic */ Function2<Boolean, Boolean, Unit> $action;
                                final /* synthetic */ boolean $connectionSuccess;
                                final /* synthetic */ Ref.ObjectRef<Boolean> $authSuccess;
                                {
                                    this.$action = $action;
                                    this.$connectionSuccess = $connectionSuccess;
                                    this.$authSuccess = $authSuccess;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$action.invoke(Boxing.boxBoolean(this.$connectionSuccess), (Boolean)this.$authSuccess.element);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Exception <unused var>) {
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$action, null){
                                int label;
                                final /* synthetic */ Function2<Boolean, Boolean, Unit> $action;
                                {
                                    this.$action = $action;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$action.invoke(Boxing.boxBoolean(false), Boxing.boxBoolean(false));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void setPassword(String password, OptionsPopup optionsPopup) {
        Popup popup2;
        if (StringsKt.isBlank(password)) {
            return;
        }
        Popup $this$setPassword_u24lambda_u240 = popup2 = new Popup(optionsPopup.getStageToShowOn(), null, 0.0f, 6, null);
        boolean bl = false;
        Popup.addGoodSizedLabel$default($this$setPassword_u24lambda_u240, "Awaiting response...", 0, false, null, 14, null).row();
        $this$setPassword_u24lambda_u240.open(true);
        Popup popup3 = popup2;
        if (password.length() < 6) {
            popup3.reuseWith("Password must be at least 6 characters long", true);
            return;
        }
        if (this.getMpServer().getFeatureSet().getAuthVersion() == 0) {
            popup3.reuseWith("This server does not support authentication", true);
            return;
        }
        this.successfullySetPassword(password, (arg_0, arg_1) -> MultiplayerTab.setPassword$lambda$1(popup3, this, optionsPopup, password, arg_0, arg_1));
    }

    private final void successfullySetPassword(String password, Function2<? super Boolean, ? super Exception, Unit> action2) {
        Concurrency.run$default(Concurrency.INSTANCE, "SetPassword", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, password, action2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MultiplayerTab this$0;
            final /* synthetic */ String $password;
            final /* synthetic */ Function2<Boolean, Exception, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$password = $password;
                this.$action = $action;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        try {
                            boolean setSuccess = MultiplayerTab.access$getMpServer(this.this$0).setPassword(this.$password);
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$action, setSuccess, null){
                                int label;
                                final /* synthetic */ Function2<Boolean, Exception, Unit> $action;
                                final /* synthetic */ boolean $setSuccess;
                                {
                                    this.$action = $action;
                                    this.$setSuccess = $setSuccess;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$action.invoke(Boxing.boxBoolean(this.$setSuccess), null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Exception ex) {
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$action, ex, null){
                                int label;
                                final /* synthetic */ Function2<Boolean, Exception, Unit> $action;
                                final /* synthetic */ Exception $ex;
                                {
                                    this.$action = $action;
                                    this.$ex = $ex;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            this.$action.invoke(Boxing.boxBoolean(false), this.$ex);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void fixTextFieldUrlOnType(TextField textField) {
        String string = textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String text2 = string;
        int cursor = Math.min(textField.getCursorPosition(), text2.length());
        String string2 = text2.substring(0, cursor);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String textBeforeCursor = string2;
        Regex multipleSlashes = new Regex("(?<!:)/{2,}");
        text2 = multipleSlashes.replace((CharSequence)text2, "/");
        cursor = multipleSlashes.replace((CharSequence)textBeforeCursor, "/").length();
        if (!Intrinsics.areEqual(text2, textField.getText())) {
            textField.setText(text2);
            textField.setCursorPosition(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Flow<MultiplayerSelectBoxHelpers.UncivSoundLabeled> lateInitialize$soundsProvider(IMediaFinder.LabeledSounds labeledSounds) {
        Flow flow;
        IMediaFinder.LabeledSounds labeledSounds2 = labeledSounds;
        synchronized (labeledSounds2) {
            boolean bl = false;
            Flow<Map.Entry<String, String>> $this$map$iv = FlowKt.asFlow(labeledSounds.getLabeledSounds());
            boolean $i$f$map = false;
            Flow<Map.Entry<String, String>> $this$unsafeTransform$iv$iv = $this$map$iv;
            boolean $i$f$unsafeTransform = false;
            boolean $i$f$unsafeFlow = false;
            flow = new Flow<MultiplayerSelectBoxHelpers.UncivSoundLabeled>($this$unsafeTransform$iv$iv){
                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                {
                    this.$this_unsafeTransform$inlined = flow;
                }

                public Object collect(FlowCollector collector2, Continuation $completion) {
                    Continuation continuation2 = $completion;
                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector2;
                    boolean bl = false;
                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                        {
                            this.$this_unsafeFlow = $receiver;
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object emit(Object value, Continuation $completion) {
                            if (!($completion instanceof lateInitialize$soundsProvider$lambda$0$$inlined$map$1$2$1)) ** GOTO lbl-1000
                            var3_3 = $completion;
                            if ((var3_3.label & -2147483648) != 0) {
                                var3_3.label -= -2147483648;
                            } else lbl-1000:
                            // 2 sources

                            {
                                $continuation = new ContinuationImpl(this, $completion){
                                    /* synthetic */ Object result;
                                    int label;
                                    Object L$0;
                                    final /* synthetic */ lateInitialize$soundsProvider$lambda$0$$inlined$map$1$2 this$0;
                                    Object L$1;
                                    Object L$2;
                                    Object L$3;
                                    int I$0;
                                    {
                                        this.this$0 = this$0;
                                        super($completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        this.result = $result;
                                        this.label |= Integer.MIN_VALUE;
                                        return this.this$0.emit((Object)null, (Continuation)this);
                                    }
                                };
                            }
                            $result = $continuation.result;
                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch ($continuation.label) {
                                case 0: {
                                    ResultKt.throwOnFailure($result);
                                    var6_6 = $continuation;
                                    var7_8 = value;
                                    $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                    var10_14 = $this$map_u24lambda_u245;
                                    var11_15 = $continuation;
                                    it = (Map.Entry)value;
                                    $i$a$-map-MultiplayerTab$lateInitialize$soundsProvider$1$1 = false;
                                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable(value);
                                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable($completion);
                                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable(value);
                                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable($this$map_u24lambda_u245);
                                    $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                    $continuation.label = 1;
                                    v0 = var10_14.emit(new MultiplayerSelectBoxHelpers.UncivSoundLabeled(it), $continuation);
                                    if (v0 == var5_5) {
                                        return var5_5;
                                    }
                                    ** GOTO lbl38
                                }
                                case 1: {
                                    $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                    $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                    value = $continuation.L$2;
                                    $completion = $continuation.L$1;
                                    value = $continuation.L$0;
                                    ResultKt.throwOnFailure($result);
                                    v0 = $result;
lbl38:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }, $completion);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Unit.INSTANCE;
                }
            };
        }
        return flow;
    }

    private static final Unit lateInitialize$lambda$2(MultiplayerSelectBoxHelpers.UncivSoundLabeled it) {
        Intrinsics.checkNotNullParameter(it, "it");
        SoundPlayer.INSTANCE.play((UncivSound)it.getValue());
        return Unit.INSTANCE;
    }

    private static final Unit lateInitialize$lambda$4(MultiplayerSelectBoxHelpers.UncivSoundLabeled it) {
        Intrinsics.checkNotNullParameter(it, "it");
        SoundPlayer.INSTANCE.play((UncivSound)it.getValue());
        return Unit.INSTANCE;
    }

    private static final boolean addMultiplayerServerOptions$lambda$0(TextField textField, char c) {
        return !StringsKt.contains$default((CharSequence)" \r\n\t\\", c, false, 2, null);
    }

    private static final Unit addMultiplayerServerOptions$lambda$1(UncivTextField $multiplayerServerTextField) {
        $multiplayerServerTextField.setText(Gdx.app.getClipboard().getContents());
        return Unit.INSTANCE;
    }

    private static final Unit addMultiplayerServerOptions$lambda$2(MultiplayerTab this$0, UncivTextField $multiplayerServerTextField, Label $errorTextField, TextButton $connectionToServerButton, Iterable $toUpdate, ChangeListener.ChangeEvent it) {
        Object object;
        this$0.fixTextFieldUrlOnType($multiplayerServerTextField);
        try {
            String string = $multiplayerServerTextField.getText();
            Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
            object = new char[]{'/'};
            URI uri = new URI(StringsKt.trimEnd(string, object));
            if (!Intrinsics.areEqual(uri.getScheme(), "http") && !Intrinsics.areEqual(uri.getScheme(), "https")) {
                throw new Error("URL must start with http:// or https://");
            }
            GameSettings.GameSettingsMultiplayer gameSettingsMultiplayer = this$0.getSettings().getMultiplayer();
            String string2 = uri.toURL().toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            gameSettingsMultiplayer.setServer(string2);
            $errorTextField.setVisible(false);
            $multiplayerServerTextField.setColor(Color.GREEN);
        }
        catch (Throwable ex) {
            $errorTextField.setText(ex.getMessage());
            $errorTextField.setVisible(true);
            $multiplayerServerTextField.setColor(Color.RED);
        }
        boolean isCustomServer = Multiplayer.Companion.usesCustomServer();
        Scene2dExtensionsKt.setEnabled($connectionToServerButton, isCustomServer);
        object = $toUpdate.iterator();
        while (object.hasNext()) {
            MultiplayerSelectBoxHelpers.RefreshSelectOptions refreshSelect = (MultiplayerSelectBoxHelpers.RefreshSelectOptions)object.next();
            refreshSelect.update(isCustomServer);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addMultiplayerServerOptions$lambda$3(MultiplayerTab this$0, UncivTextField $multiplayerServerTextField) {
        Popup popup2;
        Popup $this$addMultiplayerServerOptions_u24lambda_u243_u240 = popup2 = new Popup(this$0.getOptionsPopup$core().getStageToShowOn(), null, 0.0f, 6, null);
        boolean bl = false;
        Popup.addGoodSizedLabel$default($this$addMultiplayerServerOptions_u24lambda_u243_u240, "Awaiting response...", 0, false, null, 14, null).row();
        $this$addMultiplayerServerOptions_u24lambda_u243_u240.open(true);
        Popup popup3 = popup2;
        this$0.successfullyConnectedToServer((arg_0, arg_1) -> MultiplayerTab.addMultiplayerServerOptions$lambda$3$1(popup3, this$0, $multiplayerServerTextField, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit addMultiplayerServerOptions$lambda$3$1(Popup $popup, MultiplayerTab this$0, UncivTextField $multiplayerServerTextField, boolean connectionSuccess, Boolean authSuccess) {
        if (Intrinsics.areEqual(authSuccess, false)) {
            $popup.close();
            new AuthPopup(this$0.getOptionsPopup$core().getStageToShowOn(), arg_0 -> MultiplayerTab.addMultiplayerServerOptions$lambda$3$1$0($popup, arg_0)).open(true);
        } else if (connectionSuccess) {
            if (Intrinsics.areEqual(authSuccess, true)) {
                $popup.reuseWith("Success!", true);
            } else {
                $popup.reuseWith("Auth rejected for unknown reasons, please try again.", true);
            }
        } else {
            $popup.reuseWith("Failed!", true);
        }
        if (connectionSuccess) {
            $multiplayerServerTextField.setText(this$0.getSettings().getMultiplayer().getServer());
        }
        return Unit.INSTANCE;
    }

    private static final Unit addMultiplayerServerOptions$lambda$3$1$0(Popup $popup, boolean success) {
        Popup popup2;
        Popup $this$addMultiplayerServerOptions_u24lambda_u243_u241_u240_u240 = popup2 = $popup;
        boolean bl = false;
        $this$addMultiplayerServerOptions_u24lambda_u243_u241_u240_u240.reuseWith(success ? "Success!" : "Failed!", true);
        $this$addMultiplayerServerOptions_u24lambda_u243_u241_u240_u240.open(true);
        return Unit.INSTANCE;
    }

    private static final Unit addMultiplayerServerOptions$lambda$4$0(MultiplayerTab this$0, UncivTextField $passwordTextField) {
        String string = $passwordTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        this$0.setPassword(string, this$0.getOptionsPopup$core());
        return Unit.INSTANCE;
    }

    private static final Unit addTurnCheckerOptions$lambda$0(MultiplayerTab this$0, boolean it) {
        this$0.reopenOptions(true);
        return Unit.INSTANCE;
    }

    private static final Unit setPassword$lambda$1(Popup $popup, MultiplayerTab this$0, OptionsPopup $optionsPopup, String $password, boolean success, Exception ex) {
        if (success) {
            $popup.reuseWith("Password set successfully for server [" + this$0.getMpSettings().getServer() + ']', true);
        } else {
            if (ex instanceof MultiplayerAuthException) {
                new AuthPopup($optionsPopup.getStageToShowOn(), arg_0 -> MultiplayerTab.setPassword$lambda$1$0($popup, this$0, $password, $optionsPopup, arg_0)).open(true);
                return Unit.INSTANCE;
            }
            String message = ex instanceof FileStorageRateLimitReached ? "Server limit reached! Please wait for [" + ((FileStorageRateLimitReached)ex).getLimitRemainingSeconds() + "] seconds" : "Failed to set password!";
            $popup.reuseWith(message, true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setPassword$lambda$1$0(Popup $popup, MultiplayerTab this$0, String $password, OptionsPopup $optionsPopup, boolean authSuccess) {
        if (authSuccess) {
            $popup.close();
            this$0.setPassword($password, $optionsPopup);
        } else {
            $popup.reuseWith("Failed to set password!", true);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$lateInitialize$soundsProvider$1(IMediaFinder.LabeledSounds $labeledSounds, Continuation $completion) {
        return MultiplayerTab.lateInitialize$soundsProvider($labeledSounds);
    }

    public static final /* synthetic */ Object access$lateInitialize$soundsProvider$3(IMediaFinder.LabeledSounds $labeledSounds, Continuation $completion) {
        return MultiplayerTab.lateInitialize$soundsProvider($labeledSounds);
    }

    public static final /* synthetic */ GameSettings.GameSettingsMultiplayer access$getMpSettings(MultiplayerTab $this) {
        return $this.getMpSettings();
    }

    public static final /* synthetic */ MultiplayerServer access$getMpServer(MultiplayerTab $this) {
        return $this.getMpServer();
    }
}

