/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleCommand;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b`\u0018\u00002\u00020\u0001J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J \u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R.\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013\u00c0\u0006\u0003"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleCommandNode;", "Lcom/unciv/ui/screens/devconsole/ConsoleCommand;", "subcommands", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getSubcommands", "()Ljava/util/HashMap;", "handle", "Lcom/unciv/ui/screens/devconsole/DevConsoleResponse;", "console", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "params", "", "Lcom/unciv/ui/screens/devconsole/CliInput;", "autocomplete", "availableCommands", "invalid", "", "core"})
public interface ConsoleCommandNode
extends ConsoleCommand {
    @NotNull
    public HashMap<String, ConsoleCommand> getSubcommands();

    @Override
    @NotNull
    default public DevConsoleResponse handle(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        if (params.isEmpty()) {
            return DevConsoleResponse.Companion.hint(this.availableCommands(false));
        }
        ConsoleCommand consoleCommand = this.getSubcommands().get(params.get(0).toString());
        if (consoleCommand == null) {
            return DevConsoleResponse.Companion.error(this.availableCommands(true));
        }
        ConsoleCommand handler = consoleCommand;
        return handler.handle(console, CollectionsKt.drop((Iterable)params, 1));
    }

    @Override
    @Nullable
    default public String autocomplete(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
        Intrinsics.checkNotNullParameter(console, "console");
        Intrinsics.checkNotNullParameter(params, "params");
        CliInput firstParam = CliInput.Companion.orEmpty(CollectionsKt.firstOrNull(params));
        ConsoleCommand consoleCommand = this.getSubcommands().get(firstParam.toString());
        if (consoleCommand == null) {
            Set<String> set = this.getSubcommands().keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            return CliInput.Companion.getAutocompleteStringFromStrings(firstParam, (Iterable<String>)set, console);
        }
        ConsoleCommand handler = consoleCommand;
        return handler.autocomplete(console, CollectionsKt.drop((Iterable)params, 1));
    }

    private String availableCommands(boolean invalid) {
        String separator = invalid ? "\n- " : ", ";
        String available = "Available commands:";
        String prefix = invalid ? "Invalid command.\n" + available + "\n- " : available + ' ';
        Set<String> set = this.getSubcommands().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return CollectionsKt.joinToString$default(CollectionsKt.sorted((Iterable)set), separator, prefix, null, 0, null, null, 60, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static DevConsoleResponse handle(@NotNull ConsoleCommandNode $this, @NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
            Intrinsics.checkNotNullParameter(console, "console");
            Intrinsics.checkNotNullParameter(params, "params");
            return $this.handle(console, params);
        }

        @Deprecated
        @Nullable
        public static String autocomplete(@NotNull ConsoleCommandNode $this, @NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
            Intrinsics.checkNotNullParameter(console, "console");
            Intrinsics.checkNotNullParameter(params, "params");
            return $this.autocomplete(console, params);
        }
    }
}

