/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.managers.AssignedQuest;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/CityStateDiplomacyTable;", "", "diplomacyScreen", "Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;", "<init>", "(Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getCityStateDiplomacyTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "otherCiv", "getCityStateDiplomacyTableHeader", "getRevokeProtectionButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getPledgeToProtectButton", "getNegotiatePeaceCityStateButton", "otherCivDiplomacyManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "getImproveTilesButton", "getDiplomaticMarriageButton", "getGoldGiftTable", "getImprovableResourceTiles", "", "Lcom/unciv/logic/map/tile/Tile;", "getImprovementGiftTable", "getDemandTributeTable", "getQuestTable", "assignedQuest", "Lcom/unciv/logic/civilization/managers/AssignedQuest;", "getWarWithMajorTable", "target", "core"})
@SourceDebugExtension(value={"SMAP\nCityStateDiplomacyTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityStateDiplomacyTable.kt\ncom/unciv/ui/screens/diplomacyscreen/CityStateDiplomacyTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,494:1\n1761#2,3:495\n1387#2:507\n1475#2,5:508\n774#2:513\n865#2,2:514\n1255#3,2:498\n536#4:500\n521#4,6:501\n1#5:516\n*S KotlinDebug\n*F\n+ 1 CityStateDiplomacyTable.kt\ncom/unciv/ui/screens/diplomacyscreen/CityStateDiplomacyTable\n*L\n106#1:495,3\n356#1:507\n356#1:508,5\n356#1:513\n356#1:514,2\n268#1:498,2\n287#1:500\n287#1:501,6\n*E\n"})
public final class CityStateDiplomacyTable {
    @NotNull
    private final DiplomacyScreen diplomacyScreen;
    @NotNull
    private final Civilization viewingCiv;

    public CityStateDiplomacyTable(@NotNull DiplomacyScreen diplomacyScreen) {
        Intrinsics.checkNotNullParameter(diplomacyScreen, "diplomacyScreen");
        this.diplomacyScreen = diplomacyScreen;
        this.viewingCiv = this.diplomacyScreen.getViewingCiv$core();
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    @NotNull
    public final Table getCityStateDiplomacyTable(@NotNull Civilization otherCiv) {
        TextButton diplomaticMarriageButton;
        TextButton improveTileButton;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.viewingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager otherCivDiplomacyManager = diplomacyManager;
        Table diplomacyTable = this.getCityStateDiplomacyTableHeader(otherCiv);
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        TextButton giveGiftButton = Scene2dExtensionsKt.toTextButton$default("Give a Gift", null, false, 3, null);
        ActivationExtensionsKt.onClick(giveGiftButton, () -> CityStateDiplomacyTable.getCityStateDiplomacyTable$lambda$0(this, otherCiv));
        diplomacyTable.add((Actor)giveGiftButton).row();
        if (this.diplomacyScreen.isNotPlayersTurn$core() || this.viewingCiv.isAtWarWith(otherCiv)) {
            Scene2dExtensionsKt.disable(giveGiftButton);
        }
        if ((improveTileButton = this.getImproveTilesButton(otherCiv, otherCivDiplomacyManager)) != null) {
            diplomacyTable.add((Actor)improveTileButton).row();
        }
        if (otherCivDiplomacyManager.getDiplomaticStatus() != DiplomaticStatus.Protector) {
            diplomacyTable.add((Actor)this.getPledgeToProtectButton(otherCiv)).row();
        } else {
            diplomacyTable.add((Actor)this.getRevokeProtectionButton(otherCiv)).row();
        }
        TextButton demandTributeButton = Scene2dExtensionsKt.toTextButton$default("Demand Tribute", null, false, 3, null);
        ActivationExtensionsKt.onClick(demandTributeButton, () -> CityStateDiplomacyTable.getCityStateDiplomacyTable$lambda$1(this, otherCiv));
        diplomacyTable.add((Actor)demandTributeButton).row();
        if (this.diplomacyScreen.isNotPlayersTurn$core() || this.viewingCiv.isAtWarWith(otherCiv)) {
            Scene2dExtensionsKt.disable(demandTributeButton);
        }
        DiplomacyManager diplomacyManager2 = this.viewingCiv.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager2);
        DiplomacyManager diplomacyManager3 = diplomacyManager2;
        if (!IHasUniques.hasUnique$default(this.viewingCiv.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null)) {
            if (this.viewingCiv.isAtWarWith(otherCiv)) {
                diplomacyTable.add((Actor)this.getNegotiatePeaceCityStateButton(otherCiv, diplomacyManager3)).row();
            } else {
                diplomacyTable.add((Actor)this.diplomacyScreen.getDeclareWarButton$core(diplomacyManager3, otherCiv)).row();
            }
        }
        if (Civilization.getCapital$default(otherCiv, false, 1, null) != null) {
            City city = Civilization.getCapital$default(otherCiv, false, 1, null);
            Intrinsics.checkNotNull(city);
            if (this.viewingCiv.hasExplored(city.getCenterTile())) {
                diplomacyTable.add((Actor)this.diplomacyScreen.getGoToOnMapButton$core(otherCiv)).row();
            }
        }
        if ((diplomaticMarriageButton = this.getDiplomaticMarriageButton(otherCiv)) != null) {
            diplomacyTable.add((Actor)diplomaticMarriageButton).row();
        }
        Iterator<IsPartOfGameInfoSerialization> iterator2 = otherCiv.getQuestManager().getAssignedQuestsFor(this.viewingCiv).iterator();
        while (iterator2.hasNext()) {
            AssignedQuest assignedQuest = iterator2.next();
            Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
            diplomacyTable.add((Actor)this.getQuestTable(assignedQuest)).row();
        }
        iterator2 = SequencesKt.filter(otherCiv.getKnownCivs(), arg_0 -> CityStateDiplomacyTable.getCityStateDiplomacyTable$lambda$2(otherCiv, this, arg_0)).iterator();
        while (iterator2.hasNext()) {
            Civilization target = (Civilization)iterator2.next();
            Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
            diplomacyTable.add((Actor)this.getWarWithMajorTable(target, otherCiv)).row();
        }
        return diplomacyTable;
    }

    private final Table getCityStateDiplomacyTableHeader(Civilization otherCiv) {
        int turnsToRelationshipChange;
        List<Civilization> protectors;
        boolean bl;
        Table diplomacyTable;
        DiplomacyManager otherCivDiplomacyManager;
        block11: {
            DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.viewingCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            otherCivDiplomacyManager = diplomacyManager;
            diplomacyTable = new Table();
            diplomacyTable.defaults().pad(2.5f);
            diplomacyTable.add((Actor)new LeaderIntroTable(otherCiv, null, 2, null)).padBottom(15.0f).row();
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("{Type}:  {" + otherCiv.getCityStateType().getName() + '}')).row();
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("{Personality}:  {" + (Object)((Object)otherCiv.getCityStatePersonality()) + '}')).row();
            Iterable $this$any$iv = otherCiv.getDetailedCivResources();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ResourceSupplyList.ResourceSupply it = (ResourceSupplyList.ResourceSupply)element$iv;
                    boolean bl2 = false;
                    if (!(it.getResource().getResourceType() != ResourceType.Bonus)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            Table resourcesTable = new Table();
            resourcesTable.add((Actor)Scene2dExtensionsKt.toLabel("{Resources}:  ")).padRight(10.0f);
            ResourceSupplyList cityStateResources = otherCiv.getCityStateFunctions().getCityStateResourcesForAlly();
            Iterator iterator2 = cityStateResources.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<Object> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object object = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                ResourceSupplyList.ResourceSupply supplyList = (ResourceSupplyList.ResourceSupply)object;
                if (supplyList.getResource().getResourceType() == ResourceType.Bonus) continue;
                String name = supplyList.getResource().getName();
                Table wrapper = new Table();
                Group image = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, name, 30.0f, 0, 4, null);
                wrapper.add((Actor)image).padRight(5.0f);
                wrapper.add((Actor)Scene2dExtensionsKt.toLabel(supplyList.getAmount()));
                resourcesTable.add((Actor)wrapper).padRight(20.0f);
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, wrapper, name, 18.0f, false, 0, 0, false, null, 124, null);
                ActivationExtensionsKt.onClick(wrapper, () -> CityStateDiplomacyTable.getCityStateDiplomacyTableHeader$lambda$1(this, supplyList));
            }
            diplomacyTable.add((Actor)resourcesTable).row();
        }
        diplomacyTable.row().padTop(15.0f);
        otherCiv.getCityStateFunctions().updateAllyCivForCityState();
        Civilization ally = otherCiv.getAllyCiv();
        if (ally != null) {
            DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(ally);
            Intrinsics.checkNotNull(diplomacyManager);
            int allyInfluence = (int)diplomacyManager.getInfluence();
            String allyName = !this.viewingCiv.knows(ally) && !Intrinsics.areEqual(ally, this.viewingCiv) ? "Unknown civilization" : ally.getCivName();
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("Ally: [" + allyName + "] with [" + allyInfluence + "] Influence")).row();
        }
        if (!((Collection)(protectors = otherCiv.getCityStateFunctions().getProtectorCivs())).isEmpty()) {
            ArrayList<String> newProtectors = new ArrayList<String>();
            for (Civilization protector : protectors) {
                boolean bl3 = !this.viewingCiv.knows(protector) && !Intrinsics.areEqual(protector.getCivName(), this.viewingCiv.getCivName()) ? newProtectors.add(TranslationsKt.tr$default("Unknown civilization", false, false, 3, null)) : newProtectors.add(TranslationsKt.tr$default(protector.getCivName(), false, false, 3, null));
            }
            String protectorString = "{Protected by}: " + CollectionsKt.joinToString$default(newProtectors, ", ", null, null, 0, null, null, 62, null);
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel(protectorString)).row();
        }
        boolean atWar = otherCiv.isAtWarWith(this.viewingCiv);
        String nextLevelString = atWar ? "" : ((int)otherCivDiplomacyManager.getInfluence() < 30 ? "Reach 30 for friendship." : (Intrinsics.areEqual(ally, this.viewingCiv) ? "" : "Reach highest influence above 60 for alliance."));
        diplomacyTable.add((Actor)this.diplomacyScreen.getRelationshipTable$core(otherCivDiplomacyManager)).row();
        if (((CharSequence)nextLevelString).length() > 0) {
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel(nextLevelString)).row();
        }
        diplomacyTable.row().padTop(15.0f);
        RelationshipLevel relationLevel = otherCivDiplomacyManager.relationshipIgnoreAfraid();
        if (relationLevel.compareTo((Enum)RelationshipLevel.Friend) >= 0 && (turnsToRelationshipChange = otherCivDiplomacyManager.getTurnsToRelationshipChange()) != 0) {
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("Relationship changes in another [" + turnsToRelationshipChange + "] turns")).row();
        }
        CityStateDiplomacyTable.getCityStateDiplomacyTableHeader$addBonusLabels(otherCiv, diplomacyTable, this, "When Friends:", RelationshipLevel.Friend, relationLevel);
        CityStateDiplomacyTable.getCityStateDiplomacyTableHeader$addBonusLabels(otherCiv, diplomacyTable, this, "When Allies:", RelationshipLevel.Ally, relationLevel);
        if (otherCiv.getCityStateUniqueUnit() != null) {
            String unitName = otherCiv.getCityStateUniqueUnit();
            Object v = ((Map)this.viewingCiv.getGameInfo().getRuleset().getUnits()).get(otherCiv.getCityStateUniqueUnit());
            Intrinsics.checkNotNull(v);
            Sequence<String> techNames = ((BaseUnit)v).requiredTechs();
            String techAndTech = SequencesKt.joinToString$default(techNames, " and ", null, null, 0, null, null, 62, null);
            String isOrAre = SequencesKt.count(techNames) == 1 ? "is" : "are";
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel$default('[' + otherCiv.getCivName() + "] is able to provide [" + unitName + "] once [" + techAndTech + "] [" + isOrAre + "] researched.", null, 18, 0, false, 13, null)).row();
        }
        return diplomacyTable;
    }

    private final TextButton getRevokeProtectionButton(Civilization otherCiv) {
        TextButton revokeProtectionButton = Scene2dExtensionsKt.toTextButton$default("Revoke Protection", null, false, 3, null);
        ActivationExtensionsKt.onClick(revokeProtectionButton, () -> CityStateDiplomacyTable.getRevokeProtectionButton$lambda$0(this, otherCiv));
        if (this.diplomacyScreen.isNotPlayersTurn$core() || !otherCiv.getCityStateFunctions().otherCivCanWithdrawProtection(this.viewingCiv)) {
            Scene2dExtensionsKt.disable(revokeProtectionButton);
        }
        return revokeProtectionButton;
    }

    private final TextButton getPledgeToProtectButton(Civilization otherCiv) {
        TextButton protectionButton = Scene2dExtensionsKt.toTextButton$default("Pledge to protect", null, false, 3, null);
        ActivationExtensionsKt.onClick(protectionButton, () -> CityStateDiplomacyTable.getPledgeToProtectButton$lambda$0(this, otherCiv));
        if (this.diplomacyScreen.isNotPlayersTurn$core() || !otherCiv.getCityStateFunctions().otherCivCanPledgeProtection(this.viewingCiv)) {
            Scene2dExtensionsKt.disable(protectionButton);
        }
        return protectionButton;
    }

    /*
     * WARNING - void declaration
     */
    private final TextButton getNegotiatePeaceCityStateButton(Civilization otherCiv, DiplomacyManager otherCivDiplomacyManager) {
        boolean atWarWithItsAlly;
        TextButton peaceButton;
        block3: {
            boolean bl;
            void $this$any$iv;
            peaceButton = Scene2dExtensionsKt.toTextButton$default("Negotiate Peace", null, false, 3, null);
            ActivationExtensionsKt.onClick(peaceButton, () -> CityStateDiplomacyTable.getNegotiatePeaceCityStateButton$lambda$0(this, otherCiv));
            Civilization cityStatesAlly = otherCiv.getAllyCiv();
            Sequence<Civilization> sequence = this.viewingCiv.getKnownCivs();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual(it, cityStatesAlly) && it.isAtWarWith(this.viewingCiv))) continue;
                bl = true;
                break block3;
            }
            bl = atWarWithItsAlly = false;
        }
        if (this.diplomacyScreen.isNotPlayersTurn$core() || atWarWithItsAlly) {
            Scene2dExtensionsKt.disable(peaceButton);
        }
        if (otherCivDiplomacyManager.hasFlag(DiplomacyFlags.DeclaredWar)) {
            Scene2dExtensionsKt.disable(peaceButton);
            int turnsLeft = otherCivDiplomacyManager.getFlag(DiplomacyFlags.DeclaredWar);
            peaceButton.setText(peaceButton.getText() + '\n' + TranslationsKt.tr(turnsLeft) + '\u23f3');
        }
        return peaceButton;
    }

    /*
     * WARNING - void declaration
     */
    private final TextButton getImproveTilesButton(Civilization otherCiv, DiplomacyManager otherCivDiplomacyManager) {
        void $this$filterTo$iv$iv;
        if (otherCiv.getCities().isEmpty()) {
            return null;
        }
        List<Tile> improvableResourceTiles = this.getImprovableResourceTiles(otherCiv);
        Map $this$filter$iv = otherCiv.getGameInfo().getRuleset().getTileImprovements();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((TileImprovement)it.getValue()).getTurnsToBuild() != -1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map improvements = destination$iv$iv;
        boolean needsImprovements = false;
        for (Tile improvableTile : improvableResourceTiles) {
            for (Object v : improvements.values()) {
                Intrinsics.checkNotNullExpressionValue(v, "next(...)");
                TileImprovement tileImprovement = (TileImprovement)v;
                TileResource tileResource = improvableTile.getTileResource();
                Intrinsics.checkNotNull(tileResource);
                if (!tileResource.isImprovedBy(tileImprovement.getName()) || !improvableTile.getImprovementFunctions().canBuildImprovement(tileImprovement, otherCiv.getState())) continue;
                needsImprovements = true;
            }
        }
        if (!needsImprovements) {
            return null;
        }
        TextButton improveTileButton = Scene2dExtensionsKt.toTextButton$default("Gift Improvement", null, false, 3, null);
        ActivationExtensionsKt.onClick(improveTileButton, () -> CityStateDiplomacyTable.getImproveTilesButton$lambda$1(this, otherCiv));
        if (this.diplomacyScreen.isNotPlayersTurn$core() || otherCivDiplomacyManager.getInfluence() < 60.0f) {
            Scene2dExtensionsKt.disable(improveTileButton);
        }
        return improveTileButton;
    }

    private final TextButton getDiplomaticMarriageButton(Civilization otherCiv) {
        if (!Civilization.hasUnique$default(this.viewingCiv, UniqueType.CityStateCanBeBoughtForGold, null, 2, null)) {
            return null;
        }
        TextButton diplomaticMarriageButton = Scene2dExtensionsKt.toTextButton$default("Diplomatic Marriage ([" + otherCiv.getCityStateFunctions().getDiplomaticMarriageCost() + "] Gold)", null, false, 3, null);
        ActivationExtensionsKt.onClick(diplomaticMarriageButton, () -> CityStateDiplomacyTable.getDiplomaticMarriageButton$lambda$0(otherCiv, this));
        if (this.diplomacyScreen.isNotPlayersTurn$core() || !otherCiv.getCityStateFunctions().canBeMarriedBy(this.viewingCiv)) {
            Scene2dExtensionsKt.disable(diplomaticMarriageButton);
        }
        return diplomaticMarriageButton;
    }

    private final Table getGoldGiftTable(Civilization otherCiv) {
        Table diplomacyTable = this.getCityStateDiplomacyTableHeader(otherCiv);
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        Integer[] integerArray = new Integer[]{250, 500, 1000};
        Iterator<Integer> iterator2 = CollectionsKt.listOf(integerArray).iterator();
        while (iterator2.hasNext()) {
            int giftAmount = ((Number)iterator2.next()).intValue();
            int influenceAmount = otherCiv.getCityStateFunctions().influenceGainedByGift(this.viewingCiv, giftAmount);
            TextButton giftButton = Scene2dExtensionsKt.toTextButton$default("Gift [" + giftAmount + "] gold (+[" + influenceAmount + "] influence)", null, false, 3, null);
            ActivationExtensionsKt.onClick(giftButton, () -> CityStateDiplomacyTable.getGoldGiftTable$lambda$0(otherCiv, this, giftAmount));
            diplomacyTable.add((Actor)giftButton).row();
            if (this.viewingCiv.getGold() >= giftAmount && !this.diplomacyScreen.isNotPlayersTurn$core()) continue;
            Scene2dExtensionsKt.disable(giftButton);
        }
        TextButton backButton = Scene2dExtensionsKt.toTextButton$default("Back", null, false, 3, null);
        ActivationExtensionsKt.onClick(backButton, () -> CityStateDiplomacyTable.getGoldGiftTable$lambda$1(this, otherCiv));
        diplomacyTable.add((Actor)backButton);
        return diplomacyTable;
    }

    /*
     * Unable to fully structure code
     */
    private final List<Tile> getImprovableResourceTiles(Civilization otherCiv) {
        $this$flatMap$iv = otherCiv.getCities();
        $i$f$flatMapSequence = false;
        var4_4 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapSequenceTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (City)element$iv$iv;
            $i$a$-flatMapSequence-CityStateDiplomacyTable$getImprovableResourceTiles$1 = false;
            list$iv$iv = it.getTiles();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filter-CityStateDiplomacyTable$getImprovableResourceTiles$2 = false;
            resource = it.getTileResource();
            if (!otherCiv.canSeeResource(resource) || resource.getResourceType() == ResourceType.Bonus) ** GOTO lbl-1000
            if (it.getImprovement() == null) ** GOTO lbl-1000
            v0 = it.getImprovement();
            Intrinsics.checkNotNull(v0);
            if (!resource.isImprovedBy(v0)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Table getImprovementGiftTable(Civilization otherCiv) {
        Table improvementGiftTable = this.getCityStateDiplomacyTableHeader(otherCiv);
        Scene2dExtensionsKt.addSeparator$default(improvementGiftTable, null, 0, 0.0f, 7, null);
        List<Tile> improvableResourceTiles = this.getImprovableResourceTiles(otherCiv);
        LinkedHashMap<String, TileImprovement> tileImprovements = otherCiv.getGameInfo().getRuleset().getTileImprovements();
        for (Tile improvableTile : improvableResourceTiles) {
            Iterator<TileImprovement> iterator2 = tileImprovements.values().iterator();
            while (iterator2.hasNext()) {
                TileImprovement tileImprovement;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                TileResource tileResource = improvableTile.getTileResource();
                Intrinsics.checkNotNull(tileResource);
                if (!tileResource.isImprovedBy(tileImprovement.getName()) || !improvableTile.getImprovementFunctions().canBuildImprovement(tileImprovement, otherCiv.getState())) continue;
                TextButton improveTileButton = Scene2dExtensionsKt.toTextButton$default("Build [" + tileImprovement + "] on [" + improvableTile.getTileResource() + "] (200 Gold)", null, false, 3, null);
                ActivationExtensionsKt.onClick(improveTileButton, () -> CityStateDiplomacyTable.getImprovementGiftTable$lambda$0(this, improvableTile, tileImprovement, otherCiv));
                if (this.viewingCiv.getGold() < 200) {
                    Scene2dExtensionsKt.disable(improveTileButton);
                }
                improvementGiftTable.add((Actor)improveTileButton).row();
            }
        }
        TextButton backButton = Scene2dExtensionsKt.toTextButton$default("Back", null, false, 3, null);
        ActivationExtensionsKt.onClick(backButton, () -> CityStateDiplomacyTable.getImprovementGiftTable$lambda$1(this, otherCiv));
        improvementGiftTable.add((Actor)backButton);
        return improvementGiftTable;
    }

    private final Table getDemandTributeTable(Civilization otherCiv) {
        Table diplomacyTable = this.getCityStateDiplomacyTableHeader(otherCiv);
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("Tribute Willingness")).row();
        Table modifierTable = new Table();
        HashMap tributeModifiers = CityStateFunctions.getTributeModifiers$default(otherCiv.getCityStateFunctions(), this.viewingCiv, false, true, 2, null);
        for (Map.Entry item : ((Map)tributeModifiers).entrySet()) {
            Color color = ((Number)item.getValue()).intValue() >= 0 ? Color.GREEN : Color.RED;
            Object k = item.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
            String string = (String)k;
            Intrinsics.checkNotNull(color);
            modifierTable.add((Actor)Scene2dExtensionsKt.toLabel$default(string, color, 0, 0, false, 14, null));
            Object v = item.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            modifierTable.add((Actor)Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr((Number)v), color, 0, 0, false, 14, null)).row();
        }
        modifierTable.add((Actor)Scene2dExtensionsKt.toLabel("Sum:"));
        Collection collection = tributeModifiers.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        modifierTable.add((Actor)Scene2dExtensionsKt.toLabel(CollectionsKt.sumOfInt(collection))).row();
        diplomacyTable.add((Actor)modifierTable).row();
        diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("At least 0 to take gold, at least 30 and size 4 city for worker")).row();
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        TextButton demandGoldButton = Scene2dExtensionsKt.toTextButton$default("Take [" + otherCiv.getCityStateFunctions().goldGainedByTribute() + "] gold (-15 Influence)", null, false, 3, null);
        ActivationExtensionsKt.onClick(demandGoldButton, () -> CityStateDiplomacyTable.getDemandTributeTable$lambda$0(otherCiv, this));
        diplomacyTable.add((Actor)demandGoldButton).row();
        if (otherCiv.getCityStateFunctions().getTributeWillingness(this.viewingCiv, false) < 0) {
            Scene2dExtensionsKt.disable(demandGoldButton);
        }
        TextButton demandWorkerButton = Scene2dExtensionsKt.toTextButton$default("Take worker (-50 Influence)", null, false, 3, null);
        ActivationExtensionsKt.onClick(demandWorkerButton, () -> CityStateDiplomacyTable.getDemandTributeTable$lambda$1(otherCiv, this));
        diplomacyTable.add((Actor)demandWorkerButton).row();
        if (otherCiv.getCityStateFunctions().getTributeWillingness(this.viewingCiv, true) < 0) {
            Scene2dExtensionsKt.disable(demandWorkerButton);
        }
        TextButton backButton = Scene2dExtensionsKt.toTextButton$default("Back", null, false, 3, null);
        ActivationExtensionsKt.onClick(backButton, () -> CityStateDiplomacyTable.getDemandTributeTable$lambda$2(this, otherCiv));
        diplomacyTable.add((Actor)backButton);
        return diplomacyTable;
    }

    /*
     * WARNING - void declaration
     */
    private final Table getQuestTable(AssignedQuest assignedQuest) {
        String leaderString;
        void $this$getQuestTable_u24lambda_u240;
        Label label;
        Table questTable = new Table();
        questTable.defaults().pad(10.0f);
        Quest quest = assignedQuest.getQuest();
        int remainingTurns = assignedQuest.getRemainingTurns();
        String title = quest.getInfluence() > 0.0f ? '[' + quest.getName() + "] (+[" + (int)quest.getInfluence() + "] influence)" : quest.getName();
        String description = assignedQuest.getDescription();
        questTable.add((Actor)Scene2dExtensionsKt.toLabel$default(title, null, 24, 0, false, 13, null)).row();
        Label label2 = label = Scene2dExtensionsKt.toLabel(description);
        Table table2 = questTable;
        boolean bl = false;
        $this$getQuestTable_u24lambda_u240.setWrap(true);
        $this$getQuestTable_u24lambda_u240.setAlignment(1);
        table2.add((Actor)label).width(this.diplomacyScreen.getStage().getWidth() / (float)2).row();
        if (quest.getDuration() > 0) {
            questTable.add((Actor)Scene2dExtensionsKt.toLabel("" + '[' + remainingTurns + "] turns remaining")).row();
        }
        if (quest.isGlobal() && ((CharSequence)(leaderString = assignedQuest.getAssignerCiv().getQuestManager().getScoreStringForGlobalQuest(assignedQuest))).length() > 0) {
            questTable.add((Actor)Scene2dExtensionsKt.toLabel(leaderString)).row();
        }
        ActivationExtensionsKt.onClick(questTable, () -> CityStateDiplomacyTable.getQuestTable$lambda$1(assignedQuest));
        return questTable;
    }

    /*
     * WARNING - void declaration
     */
    private final Table getWarWithMajorTable(Civilization target, Civilization otherCiv) {
        void $this$getWarWithMajorTable_u24lambda_u241;
        Label $this$getWarWithMajorTable_u24lambda_u240;
        Label label;
        Table warTable = new Table();
        warTable.defaults().pad(10.0f);
        String title = "War against [" + target.getCivName() + ']';
        String description = "We need you to help us defend against [" + target.getCivName() + "]. Killing [" + otherCiv.getQuestManager().unitsToKill(target) + "] of their military units would slow their offensive.";
        String progress = this.viewingCiv.knows(target) ? "Currently you have killed [" + otherCiv.getQuestManager().unitsKilledSoFar(target, this.viewingCiv) + "] of their military units." : "You need to find them first!";
        warTable.add((Actor)Scene2dExtensionsKt.toLabel$default(title, null, 24, 0, false, 13, null)).row();
        Label label2 = label = Scene2dExtensionsKt.toLabel(description);
        Table table2 = warTable;
        boolean bl = false;
        $this$getWarWithMajorTable_u24lambda_u240.setWrap(true);
        $this$getWarWithMajorTable_u24lambda_u240.setAlignment(1);
        table2.add((Actor)label).width(this.diplomacyScreen.getStage().getWidth() / (float)2).row();
        $this$getWarWithMajorTable_u24lambda_u240 = label = Scene2dExtensionsKt.toLabel(progress);
        table2 = warTable;
        boolean bl2 = false;
        $this$getWarWithMajorTable_u24lambda_u241.setWrap(true);
        $this$getWarWithMajorTable_u24lambda_u241.setAlignment(1);
        table2.add((Actor)label).width(this.diplomacyScreen.getStage().getWidth() / (float)2).row();
        return warTable;
    }

    private static final Unit getCityStateDiplomacyTable$lambda$0(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getGoldGiftTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final Unit getCityStateDiplomacyTable$lambda$1(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getDemandTributeTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final boolean getCityStateDiplomacyTable$lambda$2(Civilization $otherCiv, CityStateDiplomacyTable this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $otherCiv.getQuestManager().isWarWithMajorActive(it) && !Intrinsics.areEqual(this$0.viewingCiv, it);
    }

    private static final Unit getCityStateDiplomacyTableHeader$lambda$1(CityStateDiplomacyTable this$0, ResourceSupplyList.ResourceSupply $supplyList) {
        this$0.diplomacyScreen.openCivilopedia($supplyList.getResource().makeLink());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getCityStateDiplomacyTableHeader$addBonusLabels(Civilization $otherCiv, Table diplomacyTable, CityStateDiplomacyTable this$0, String header, RelationshipLevel bonusLevel, RelationshipLevel currentRelationLevel) {
        void $this$getCityStateDiplomacyTableHeader_u24addBonusLabels_u24lambda_u243;
        Sequence<Unique> bonuses = SequencesKt.filterNot(CityStateFunctions.Companion.getCityStateBonuses$default(CityStateFunctions.Companion, $otherCiv.getCityStateType(), bonusLevel, null, 4, null), CityStateDiplomacyTable::getCityStateDiplomacyTableHeader$addBonusLabels$lambda$2);
        if (SequencesKt.none(bonuses)) {
            return;
        }
        Color headerColor = currentRelationLevel == bonusLevel ? Color.GREEN : Color.WHITE;
        Intrinsics.checkNotNull(headerColor);
        Label label = Scene2dExtensionsKt.toLabel$default(header, headerColor, 0, 0, false, 14, null);
        Object object = label;
        Table table2 = diplomacyTable;
        boolean bl = false;
        $this$getCityStateDiplomacyTableHeader_u24addBonusLabels_u24lambda_u243.setAlignment(1);
        table2.add((Actor)label).row();
        GameContext gameContext = new GameContext(this$0.viewingCiv, null, null, null, null, null, null, null, null, null, false, 2046, null);
        object = bonuses.iterator();
        while (object.hasNext()) {
            ColorMarkupLabel colorMarkupLabel;
            Unique bonus = (Unique)object.next();
            Color bonusLabelColor = currentRelationLevel == bonusLevel && bonus.conditionalsApply(gameContext) ? Color.GREEN : Color.GRAY;
            String string = bonus.getDisplayText();
            Intrinsics.checkNotNull(bonusLabelColor);
            ColorMarkupLabel $this$getCityStateDiplomacyTableHeader_u24addBonusLabels_u24lambda_u244 = colorMarkupLabel = new ColorMarkupLabel(string, bonusLabelColor, null, 0, 12, null);
            boolean bl2 = false;
            $this$getCityStateDiplomacyTableHeader_u24addBonusLabels_u24lambda_u244.setAlignment(1);
            ColorMarkupLabel bonusLabel = colorMarkupLabel;
            diplomacyTable.add((Actor)bonusLabel).row();
        }
    }

    private static final boolean getCityStateDiplomacyTableHeader$addBonusLabels$lambda$2(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isHiddenToUsers();
    }

    private static final Unit getRevokeProtectionButton$lambda$0(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        Popup.open$default(new ConfirmPopup(this$0.diplomacyScreen, "Revoke protection for [" + $otherCiv.getCivName() + "]?", "Revoke Protection", false, null, () -> CityStateDiplomacyTable.getRevokeProtectionButton$lambda$0$0($otherCiv, this$0), 24, null), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getRevokeProtectionButton$lambda$0$0(Civilization $otherCiv, CityStateDiplomacyTable this$0) {
        CityStateFunctions.removeProtectorCiv$default($otherCiv.getCityStateFunctions(), this$0.viewingCiv, false, 2, null);
        this$0.diplomacyScreen.updateLeftSideTable$core($otherCiv);
        this$0.diplomacyScreen.updateRightSide$core($otherCiv);
        return Unit.INSTANCE;
    }

    private static final Unit getPledgeToProtectButton$lambda$0(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        Popup.open$default(new ConfirmPopup(this$0.diplomacyScreen, "Declare Protection of [" + $otherCiv.getCivName() + "]?", "Pledge to protect", true, null, () -> CityStateDiplomacyTable.getPledgeToProtectButton$lambda$0$0($otherCiv, this$0), 16, null), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getPledgeToProtectButton$lambda$0$0(Civilization $otherCiv, CityStateDiplomacyTable this$0) {
        $otherCiv.getCityStateFunctions().addProtectorCiv(this$0.viewingCiv);
        this$0.diplomacyScreen.updateLeftSideTable$core($otherCiv);
        this$0.diplomacyScreen.updateRightSide$core($otherCiv);
        return Unit.INSTANCE;
    }

    private static final Unit getNegotiatePeaceCityStateButton$lambda$0(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        Popup.open$default(new ConfirmPopup(this$0.diplomacyScreen, "Peace with [" + $otherCiv.getCivName() + "]?", "Negotiate Peace", true, null, () -> CityStateDiplomacyTable.getNegotiatePeaceCityStateButton$lambda$0$0(this$0, $otherCiv), 16, null), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getNegotiatePeaceCityStateButton$lambda$0$0(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        TradeLogic tradeLogic = new TradeLogic(this$0.viewingCiv, $otherCiv);
        tradeLogic.getCurrentTrade().getOurOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, this$0.viewingCiv.getGameInfo().getSpeed(), 4, null));
        tradeLogic.getCurrentTrade().getTheirOffers().add(new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, this$0.viewingCiv.getGameInfo().getSpeed(), 4, null));
        TradeLogic.acceptTrade$default(tradeLogic, false, 1, null);
        this$0.diplomacyScreen.updateLeftSideTable$core($otherCiv);
        this$0.diplomacyScreen.updateRightSide$core($otherCiv);
        return Unit.INSTANCE;
    }

    private static final Unit getImproveTilesButton$lambda$1(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getImprovementGiftTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final Unit getDiplomaticMarriageButton$lambda$0(Civilization $otherCiv, CityStateDiplomacyTable this$0) {
        List<City> newCities = $otherCiv.getCities();
        $otherCiv.getCityStateFunctions().diplomaticMarriage(this$0.viewingCiv);
        UncivGame.popScreen$default(UncivGame.Companion.getCurrent(), false, 1, null);
        for (City city : newCities) {
            this$0.viewingCiv.getPopupAlerts().add(new PopupAlert(AlertType.DiplomaticMarriage, city.getId()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit getGoldGiftTable$lambda$0(Civilization $otherCiv, CityStateDiplomacyTable this$0, int $giftAmount) {
        $otherCiv.getCityStateFunctions().receiveGoldGift(this$0.viewingCiv, $giftAmount);
        this$0.diplomacyScreen.updateLeftSideTable$core($otherCiv);
        this$0.diplomacyScreen.updateRightSide$core($otherCiv);
        return Unit.INSTANCE;
    }

    private static final Unit getGoldGiftTable$lambda$1(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getCityStateDiplomacyTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final Unit getImprovementGiftTable$lambda$0(CityStateDiplomacyTable this$0, Tile $improvableTile, TileImprovement $tileImprovement, Civilization $otherCiv) {
        this$0.viewingCiv.addGold(-200);
        $improvableTile.stopWorkingOnImprovement();
        Tile.setImprovement$default($improvableTile, $tileImprovement.getName(), null, null, 6, null);
        $otherCiv.getCache().updateCivResources();
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getCityStateDiplomacyTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final Unit getImprovementGiftTable$lambda$1(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getCityStateDiplomacyTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final Unit getDemandTributeTable$lambda$0(Civilization $otherCiv, CityStateDiplomacyTable this$0) {
        $otherCiv.getCityStateFunctions().tributeGold(this$0.viewingCiv);
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getCityStateDiplomacyTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final Unit getDemandTributeTable$lambda$1(Civilization $otherCiv, CityStateDiplomacyTable this$0) {
        $otherCiv.getCityStateFunctions().tributeWorker(this$0.viewingCiv);
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getCityStateDiplomacyTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final Unit getDemandTributeTable$lambda$2(CityStateDiplomacyTable this$0, Civilization $otherCiv) {
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)new ScrollPane((Actor)this$0.getCityStateDiplomacyTable($otherCiv)));
        return Unit.INSTANCE;
    }

    private static final Unit getQuestTable$lambda$1(AssignedQuest $assignedQuest) {
        $assignedQuest.onClickAction();
        return Unit.INSTANCE;
    }
}

