# brltty.spec.  Generated from brltty.spec.in by configure.
###############################################################################
# BRLTTY - A background process providing access to the console screen (when in
#          text mode) for a blind person using a refreshable braille display.
#
# Copyright (C) 1995-2025 by The BRLTTY Developers.
#
# BRLTTY comes with ABSOLUTELY NO WARRANTY.
#
# This is free software, placed under the terms of the
# GNU Lesser General Public License, as published by the Free Software
# Foundation; either version 2.1 of the License, or (at your option) any
# later version. Please see the file LICENSE-LGPL for details.
#
# Web Page: http://brltty.app/
#
# This software is maintained by Dave Mielke <dave@mielke.cc>.
###############################################################################

Name: brltty
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

Vendor: The BRLTTY Developers
Packager: Dave Mielke <dave@mielke.cc>
URL: https://brltty.app/
Source: https://brltty.app//archive/%{name}-%{version}.tar.gz

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _pkglibdir %{_libdir}/%{name}
%define _pkglibexecdir %{_libexecdir}/%{name}

Requires: cldr-emoji-annotation
Requires: dbus-libs
Requires: expat
Requires: libcap
Requires: libicu
Requires: liblouis
Requires: pcre2-utf32
Requires: polkit-libs

BuildRequires: systemd-rpm-macros

BuildRequires: /bin/sh
BuildRequires: /usr/bin/env

BuildRequires: bash
BuildRequires: gawk
BuildRequires: coreutils
BuildRequires: binutils
BuildRequires: tcl

BuildRequires: autoconf >= 2.53
BuildRequires: automake
BuildRequires: make
BuildRequires: pkgconf-pkg-config
BuildRequires: gcc

BuildRequires: alsa-lib-devel
BuildRequires: bluez-libs-devel
BuildRequires: dbus-devel
BuildRequires: expat-devel
BuildRequires: glibc-devel
BuildRequires: glib2-devel
BuildRequires: gpm-devel
BuildRequires: libcap-devel
BuildRequires: libicu-devel
BuildRequires: liblouis-devel
BuildRequires: ncurses-devel
BuildRequires: pcre2-devel
BuildRequires: polkit-devel
BuildRequires: systemd-devel

BuildRequires: gettext
BuildRequires: groff
BuildRequires: doxygen
BuildRequires: linuxdoc-tools
BuildRequires: python3-docutils
BuildRequires: rst2txt

AutoProv: no
AutoReq: yes

Provides: brlapi-server
Provides: config(%{name}) = %{version}

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.


%package utils
Version: 6.8
Release: 1
Group: Development/Tools
License: LGPL

Requires: libicu
Requires: expat
Requires: cldr-emoji-annotation

BuildRequires: libicu-devel
BuildRequires: expat-devel
BuildRequires: ncurses-devel

AutoProv: no
AutoReq: yes

Summary: Commands for maintaining BRLTTY data files.
%description utils
This package provides a set of commands for maintaining BRLTTY's datafiles.


%package devel
Version: 6.8
Release: 1
Group: Development/Tools
License: LGPL

AutoProv: no
AutoReq: yes

Summary: Headers for BRLTTY.
%description devel
This package provides many of the header files for BRLTTY's core, as well as
header files which define the packets and keys for several braille devices.

Install this package if you're developing or maintaining an application which
needs to (or wishes to) use functionality provided by BRLTTY's core, which
needs to interpret and/or create raw braille device packets, or which needs to
interpret key codes as delivered by BrlAPI's raw mode.


%package braille-brlapi
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

AutoProv: no
AutoReq: yes

Summary: BrlAPI braille driver for BRLTTY.
%description braille-brlapi
This package provides the BrlAPI braille driver for BRLTTY.

Install this package if you need to communicate with
another instance of BRLTTY which is actually in control
of the braille device.


%package braille-xwindow
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: libX11

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXt-devel
BuildRequires: Xaw3d-devel

AutoProv: no
AutoReq: yes

Summary: XWindow braille driver for BRLTTY.
%description braille-xwindow
This package provides the XWindow braille driver for BRLTTY.
This driver presents a virtual braille device within a graphical
user interface. It is primarily intended for sighted developers
who don't have access to a real braille device but still wish to
assess the accessibility of their applications.

Install this package if you would like to see how usable an
application would be by a blind person using a braille device.


%package speech-espeak
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: espeak

BuildRequires: espeak-devel

AutoProv: no
AutoReq: yes

Summary: eSpeak speech driver for BRLTTY.
%description speech-espeak
This package provides the eSpeak speech driver for BRLTTY.

Install this package if you would like to be able to use the
eSpeak text-to-speech engine.


%package speech-espeak-ng
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: espeak-ng

BuildRequires: espeak-ng-devel

AutoProv: no
AutoReq: yes

Summary: eSpeak-NG speech driver for BRLTTY.
%description speech-espeak-ng
This package provides the eSpeak-NG speech driver for BRLTTY.

Install this package if you would like to be able to use the
eSpeak-NG text-to-speech engine.


%package speech-festival
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: festival

AutoProv: no
AutoReq: yes

Summary: Festival speech driver for BRLTTY.
%description speech-festival
This package provides the Festival speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival text-to-speech engine.


%package speech-flite
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: flite

BuildRequires: flite-devel

AutoProv: no
AutoReq: yes

Summary: Festival Lite speech driver for BRLTTY.
%description speech-flite
This package provides the Festival Lite speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival Lite text-to-speech engine.


%package speech-speechd
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: speech-dispatcher

BuildRequires: speech-dispatcher-devel

AutoProv: no
AutoReq: yes

Summary: Speech Dispatcher speech driver for BRLTTY.
%description speech-speechd
This package provides the Speech Dispatcher speech driver for BRLTTY.

Install this package if you would like to be able to use the
Speech Dispatcher text-to-speech server.


%package screen-atspi2
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

Requires: dbus-libs

BuildRequires: at-spi2-core-devel
BuildRequires: xorg-x11-proto-devel
BuildRequires: dbus-devel

AutoProv: no
AutoReq: yes

Summary: AT-SPI2 screen driver for BRLTTY.
%description screen-atspi2
This package provides the AT-SPI2 screen driver for BRLTTY.

Install this package if you would like to be able to
access graphical applications via the D-Bus port of
the Assistive Technology Service Provider Interface.


%package screen-screen
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL

AutoProv: no
AutoReq: yes
Requires: screen

Summary: Screen screen driver for BRLTTY.
%description screen-screen
This package provides the Screen screen driver for BRLTTY.

Install this package if you would like to be able to
directly access session windows maintained by the
screen program.


%package -n brlapi
Version: 0.8.7
Release: 1
Group: System Environment/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.


%package -n brlapi-utils
Version: 0.8.7
Release: 1
Group: Applications/System
License: LGPL

Requires: libX11

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXtst-devel

AutoProv: no
AutoReq: yes

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi-utils
This package provides a set of commands that use the BrlAPI interface.


%package -n brlapi-devel
Version: 0.8.7
Release: 1
Group: Development/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.


%package -n java-brlapi
Version: 0.8.7
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: java
BuildRequires: java-devel

AutoProv: no
AutoReq: yes

Summary: Java bindings for BrlAPI.
%description -n java-brlapi
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.


%package -n lua-brlapi
Version: 0.8.7
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: lua
BuildRequires: lua-devel

AutoProv: no
AutoReq: yes

Summary: Lua bindings for BrlAPI.
%description -n lua-brlapi
This package provides the Lua bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have an Lua application
which directly accesses a refreshable braille display.


%package -n ocaml-brlapi
Version: 0.8.7
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: ocaml
BuildRequires: ocaml-findlib

AutoProv: no
AutoReq: yes

Summary: OCaml bindings for BrlAPI.
%description -n ocaml-brlapi
This package provides the OCaml bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have an OCaml application
which directly accesses a refreshable braille display.


%package -n python-brlapi
Version: 0.8.7
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: python3
BuildRequires: python3-devel
BuildRequires: python3-Cython

AutoProv: no
AutoReq: yes

Summary: Python bindings for BrlAPI.
%description -n python-brlapi
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.


%package -n tcl-brlapi
Version: 0.8.7
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: tcl
BuildRequires: tcl-devel

AutoProv: no
AutoReq: yes

Summary: Tcl bindings for BrlAPI.
%description -n tcl-brlapi
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.


%package systemd
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL
BuildArch: noarch

AutoProv: no
AutoReq: yes
Requires: systemd

Summary: Systemd units and wrappers for BRLTTY.
%description systemd
This package provides the units and wrapper for managing BRLTTY via Systemd.

Install this package if you'd like to manage BRLTTY processes via Systemd.


%package udev
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL
BuildArch: noarch

AutoProv: no
AutoReq: yes
Requires: systemd-udev

Summary: BRLTTY Udev rules.
%description udev
This package provides the rules and the wrapper for managing BRLTTY via Udev.

Install this package if you'd like to manage BRLTTY processes via Udev.
It doesn't include the rules for braille devices that use generic USB to serial adapters.


%package udev-generic
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL
BuildArch: noarch

AutoProv: no
AutoReq: yes
Requires: systemd-udev

Summary: BRLTTY Udev rules for braille devices that use a generic USB to serial adapter.
%description udev-generic
This package provides additional rules for managing BRLTTY via Udev.

Install this package in order to support braille devices that use a generic USB to serial adapter.


%package dracut
Version: 6.8
Release: 1
Group: System Environment/Daemons
License: LGPL
BuildArch: noarch

AutoProv: no
AutoReq: yes
Requires: dracut
Requires: brltty-utils

Summary: Dracut module for BRLTTY.
%description dracut
This package provides the module for adding BRLTTY to an initial ramdisk image.

Install this package if you'd like to have braille accessibility BRLTTY processes via Udev.


%prep
# %setup -n %{name}-%{version}
%setup -n brltty-6.8

%build
export PYTHON=python3
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --with-braille-driver=-tt,-vr
make all

%install
make install
make install-messages
make install-appstream
make install-systemd
make install-udev UDEV_RULES_LOCATION=%{_udevrulesdir}
make install-polkit
make install-dracut
make install-documents
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"
%find_lang %{name}

%clean
rm -fr "${RPM_BUILD_ROOT}"


%files -f %{name}.lang
%defattr(-,root,root)
%{_bindir}/brltty
%{_pkglibdir}
%{_pkglibexecdir}/brltty-pty
%exclude %{_pkglibdir}/libbrlttybba.so
%exclude %{_pkglibdir}/libbrlttybxw.so
%exclude %{_pkglibdir}/libbrlttysen.so
%exclude %{_pkglibdir}/libbrlttyses.so
%exclude %{_pkglibdir}/libbrlttysfl.so
%exclude %{_pkglibdir}/libbrlttysfv.so
%exclude %{_pkglibdir}/libbrlttyssd.so
%exclude %{_pkglibdir}/libbrlttyxa2.so
%exclude %{_pkglibdir}/libbrlttyxsc.so
%exclude %{_unitdir}
%exclude %{_udevrulesdir}
%{_sysconfdir}/brltty
%exclude %{_sysconfdir}/brltty/Initramfs/dracut.conf
%exclude %{_sysconfdir}/brltty/Initramfs/cmdline
%{_datadir}/metainfo/org.a11y.brltty.metainfo.xml
%{_libdir}/pkgconfig/brltty.*
%doc %{_mandir}/man1/brltty.1.gz
%doc %{_docdir}/*/LICENSE*
%doc %{_docdir}/*/README*
%doc %{_docdir}/*/*.html
%doc %{_docdir}/*/BUGS
%doc %{_docdir}/*/ChangeLog
%doc %{_docdir}/*/CONTRIBUTORS
%doc %{_docdir}/*/HISTORY
%doc %{_docdir}/*/TODO
%doc %{_docdir}/*/*.csv
%doc %{_docdir}/*/brltty.conf
%doc %{_docdir}/*/KeyTables
%doc %{_docdir}/*/Manual-BRLTTY
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf

%files utils
%{_bindir}/brltty-*

%files devel
%{_includedir}/brltty

%files braille-brlapi
%{_pkglibdir}/libbrlttybba.so

%files braille-xwindow
%{_pkglibdir}/libbrlttybxw.so

%files speech-espeak
%{_pkglibdir}/libbrlttyses.so

%files speech-espeak-ng
%{_pkglibdir}/libbrlttysen.so

%files speech-festival
%{_pkglibdir}/libbrlttysfv.so

%files speech-flite
%{_pkglibdir}/libbrlttysfl.so

%files speech-speechd
%{_pkglibdir}/libbrlttyssd.so

%files screen-atspi2
%{_pkglibdir}/libbrlttyxa2.so

%files screen-screen
%{_pkglibdir}/libbrlttyxsc.so

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%{_datadir}/polkit-1/*/org.a11y.brlapi.*
%doc %{_docdir}/*/Manual-BrlAPI

%files -n brlapi-utils
%{_bindir}/xbrlapi
%doc %{_mandir}/man1/xbrlapi.1.gz
%{_datadir}/gdm/greeter/autostart/xbrlapi.desktop
%{_sysconfdir}/X11/Xsession.d/90xbrlapi
%{_bindir}/eutp
%doc %{_mandir}/man1/eutp.1.gz
%{_bindir}/vstp
%doc %{_mandir}/man1/vstp.1.gz

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%doc %{_mandir}/man3/*
%doc %{_docdir}/*/BrlAPIref

%files -n java-brlapi
/usr/share/java/*
/usr/lib/java/*

%files -n lua-brlapi
/usr/lib64/lua/5.4/

%files -n ocaml-brlapi
/usr/lib64/ocaml/brlapi

%files -n python-brlapi -f Bindings/Python/installed-files

%files -n tcl-brlapi
/usr/lib64/tcl8.6/brlapi-0.8.7/libbrlapi_tcl.so
/usr/lib64/tcl8.6/brlapi-0.8.7/pkgIndex.tcl

%files systemd
%{_unitdir}/*
%{_sysusersdir}/*
%{_tmpfilesdir}/*
%{_pkglibexecdir}/systemd-*

%files udev
%{_udevrulesdir}/*
%exclude %{_udevrulesdir}/*-generic*
%{_pkglibexecdir}/udev-*

%files udev-generic
%{_udevrulesdir}/*-generic*

%files dracut
/usr/lib/dracut/modules.d/99brltty
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty/Initramfs/dracut.conf
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty/Initramfs/cmdline


%changelog
* Sat Jul 5 2025 Dave Mielke <Dave@Mielke.cc> 6.8
General changes:
   The --helpers-directory (-H) command line option has been added.
   The Learn Mode prompt now includes the number of seconds before it times out.
Speech changes:
   The "most" punctuation level has been added (in between "some", and "all").
   The SPK_PUNCT_LEVEL command has been added (cycles through all four levels).
Message changes:
   Message content can now be copied to the clipboard.
   Messages are now rendered in contracted braille when that's being used.
   Messages now honour the Word Wrap setting (when using computer braille).
Pasting clipboard content:
   The PASTE_ALTMODE and PASTE_HISTORY_ALTMODE commands have been added.
   PASTE_ALTMODE has been bound to a long-press of the key combination for PASTE.
Preferences Menu changes:
   The preferences file can no longer be lost during a reboot or shutdown.
   Alternate Paste Mode Enabled has been added to the Input Options submenu.
   The Command Options (advanced) submenu has been added.
BrlAPI braille driver changes:
   The correct BrlAPI client priority is now being set.
DotPad braille driver changes:
   These driver properties have been defined (prefix is DP_PROP_):
      DISPLAY: can be set to TEXT or GRAPHIC (prefix is DP_DISPLAY_)
      STATUS_CELLS: can be set to 0 (no) or 1 (status cells in text area)
      HORIZONTAL_SPACING: number of dot columns between cells (default is 1)
      VERTICAL_SPACING: number of dot rows between lines (default is 2)
   These can be changed at run-time via BRLAPI_PARAM_DRIVER_PROPERTY_VALUE.
   The driver's README contains this list along with examples.
HandyTech braille driver changes:
   Input mode on an Activator Pro model can now be toggled with Space + dots 7-8.
ExternalSpeech speech driver changes:
   The Address= parameter has been added.
   The Autospawn= parameter has been added.
   The Port= parameter has been removed (use Address= instead).
   The current settings are now sent to the server on each connect or reconnect.
Linux screen driver changes:
   Automatically detect if a paste should be bracketed (starting with kernel 6.16).
   A screen with more than 255 columns and/or lines is now rendered properly
   (although, if the kernel is earlier than 6.16, the cursor isn't shown when
   its position is beyond column and/or line 255).
   The LargeScreenBug= parameter (defaults to No) has been added
   (might be needed if the kernel is earlier than 5.1).
   The handling of foreground console switching has been improved.
AtSpi2 screen driver changes:
   Widgets which don't have a text interface are now ignored.
   The handling of double-width and zero-width characters has been improved.
BrlAPI changes:
   The version is now 0.8.7 (it was 0.8.6).
   Driver properties are now changed on the core's (not the client's) thread.
   The handling of braille display size changes has been improved.
Text table changes:
   The he_IL (Hebrew, Israel) table has been added - it can be used to read
      Hebrew, Arabic, Russian, English, and some western european languages.
   The he (Hebrew, generic) table is now an alias for the (new) he_IL table.
   The older he (Hebrew, generic) table is still (for now) available as he-old.
   The pt (Portuguese) table has been improved.
   Support for Esperanto and Greek has been added to the pt (Portuguese) table.
Contraction table changes:
   The de-2015 (German) table has been improved.
   The de-1998 (German) table is deprecated and will be removed soon.
TCL build changes:
   The TCL-8.6.15 change to the format of TCL_PACKAGE_PATH is now supported.
   Building against TCL-9.0 is now supported.
Android build changes:
   The crash on startup when using Android 14 (or later) has been fixed.

