# antiX memory manager

antiX memory manager is a Control centre script allowing for checking and managing the way the Linux kernel handles memory usage, in particular activating and deactivating memory compression by zram and zswap.

## Installation

**A.) Apt package installation** (This is the preferred way of installation.)
- [ ] $ sudo apt-get update
- [ ] $ sudo apt-get install memory-manager-antix

**B.) Apt package installation out of tree** (In case there is no package available from the default apt repos.)
- [ ] Download deb-installer-package and checksum file from respective folder. It was tested on antiX 23, 32bit and 64bit both.
- [ ] Check shasum file using the command:
```
shasum -c './antix-memory-manager.sha512.sum'
```
It must show an _OK_.
- [ ] If check was OK, install the package by the commands 
```
sudo apt-get update && sudo apt-get install './antix-memory-manager.deb'
```
Check carefully console output for error messages during installation.

**C.) Manual installation** (not recommended):
- [ ] Put the script file _antiX-memory-manager_ from _bin_ directory into the antiX system folder _/usr/local/bin_ and make it executable (_sudo chmod 755 /usr/local/bin/antiX-memory-manager_)
- [ ] Put the localisation of its user interface for your language (_.mo_ type file) into the respective locale subflolder of your antiX system. ( _/usr/share/locale/‹your_language_ID›/LC_MESSAGES_ ).
- [ ] Put the file antiXmm.png from the resources subfolder to the system folder _/usr/share/icons/papirus-antix/48x48/apps_

## Usage
Simply click on its entry in _antiX Control Centre_, section _System_ to start it. Alternatively enter _sudo antiX-memory-manager_ in a command line window, e.g. in RoxTerm, or start it from within App-select in antiX main menu.

For further details read carefully the tooltips it provides on all of its GUI elements, and for more detailed insights about how it works click open the help window with the respective button.

You may close it after usage, the applied changes will stay active.

## Plans
There may get implemented some more sophisticated memory optimisation strategies in future.

## Support
For help, questions, suggestions and bug reporting please write to [antiXlinux forums](https://www.antixforum.com).

## Contributing
- If you find a translation of user interface or user manual being inadequat or misleading wrong, please edit it simply on [antix-development at transifex](https://app.transifex.com/anticapitalista/antix-development/antix-memory-manager/). On transifex you may edit the string translations used in user interface directly.
- If you happen to have knowledge and want to help improving this tool, please bark up in antiX forum (see Support link above).

## Authors and acknowledgment
This is an antiX community project. In particular many thanks to anticapitalX and anti-apXos !

## License
GPL Version 3 (GPLv3)

-----------
Written 2025 by Robin.antiX for antiX community.
