/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXGradientChooser;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.color.EyeDropperColorChooserPanel;

public class PaintPicker
extends JPanel {
    Component lastPickerUsed = null;
    Paint selectedPaint = Color.PINK;
    JXGradientChooser gradientPicker;
    private JSlider alphaSlider;
    public JColorChooser colorPicker;
    private JPanel colorPickerParent;
    private JLabel jLabel1;
    private JTabbedPane tabbedPane;

    public PaintPicker() {
        this.initComponents();
        this.lastPickerUsed = this.colorPicker;
        this.colorPicker.addChooserPanel((AbstractColorChooserPanel)new EyeDropperColorChooserPanel());
        ColorListener colorListener = new ColorListener();
        this.colorPicker.getSelectionModel().addChangeListener(colorListener);
        this.alphaSlider.addChangeListener(colorListener);
        this.gradientPicker = new JXGradientChooser();
        this.tabbedPane.addTab("Gradient", (Component)this.gradientPicker);
        this.gradientPicker.addPropertyChangeListener("gradient", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PaintPicker.this.lastPickerUsed = PaintPicker.this.gradientPicker;
                PaintPicker.this.setPaint(PaintPicker.this.gradientPicker.getGradient());
            }
        });
        this.tabbedPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PaintPicker.this.lastPickerUsed = PaintPicker.this.tabbedPane.getSelectedComponent();
                Paint old = PaintPicker.this.selectedPaint;
                if (PaintPicker.this.lastPickerUsed == PaintPicker.this.colorPickerParent) {
                    PaintPicker.this.selectedPaint = PaintPicker.this.colorPicker.getSelectionModel().getSelectedColor();
                }
                if (PaintPicker.this.lastPickerUsed == PaintPicker.this.gradientPicker) {
                    PaintPicker.this.selectedPaint = PaintPicker.this.gradientPicker.getGradient();
                }
                PaintPicker.this.firePropertyChange("paint", old, PaintPicker.this.selectedPaint);
            }
        });
    }

    public Paint getPaint() {
        return this.selectedPaint;
    }

    public void addPicker(JComponent comp, String title) {
        this.tabbedPane.addTab(title, comp);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.colorPickerParent = new JPanel();
        this.colorPicker = new JColorChooser();
        this.jLabel1 = new JLabel();
        this.alphaSlider = new JSlider();
        this.setLayout(new GridBagLayout());
        this.colorPickerParent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        this.colorPickerParent.add((Component)this.colorPicker, gridBagConstraints);
        this.jLabel1.setText("Alpha:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.colorPickerParent.add((Component)this.jLabel1, gridBagConstraints);
        this.alphaSlider.setMaximum(255);
        this.alphaSlider.setValue(255);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.colorPickerParent.add((Component)this.alphaSlider, gridBagConstraints);
        this.tabbedPane.addTab("Color", this.colorPickerParent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    public void setPaint(Paint paint) {
        if (paint == this.selectedPaint) {
            return;
        }
        Paint old = this.selectedPaint;
        this.selectedPaint = paint;
        if (paint instanceof Color) {
            this.tabbedPane.setSelectedComponent(this.colorPickerParent);
            this.colorPicker.setColor((Color)paint);
            this.alphaSlider.setValue(((Color)paint).getAlpha());
        }
        if (paint instanceof MultipleGradientPaint) {
            this.tabbedPane.setSelectedComponent((Component)this.gradientPicker);
            this.gradientPicker.setGradient((MultipleGradientPaint)paint);
        }
        this.firePropertyChange("paint", old, this.selectedPaint);
    }

    Paint getDisplayPaint(Rectangle box) {
        if (this.getPaint() instanceof MultipleGradientPaint) {
            return this.getFlatGradient(this.gradientPicker, box.getWidth());
        }
        return this.getPaint();
    }

    private MultipleGradientPaint getFlatGradient(JXGradientChooser chooser, double length) {
        MultipleGradientPaint gp = chooser.getGradient();
        float[] fractions = gp.getFractions();
        Color[] colors = gp.getColors();
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float((float)length, 0.0f);
        LinearGradientPaint paint = new LinearGradientPaint((float)((Point2D)start).getX(), (float)((Point2D)start).getY(), (float)((Point2D)end).getX(), (float)((Point2D)end).getY(), fractions, colors);
        return paint;
    }

    private class ColorListener
    implements ChangeListener {
        private ColorListener() {
        }

        public void stateChanged(ChangeEvent e) {
            PaintPicker.this.lastPickerUsed = PaintPicker.this.colorPicker;
            Paint old = PaintPicker.this.selectedPaint;
            PaintPicker.this.selectedPaint = ColorUtil.setAlpha((Color)PaintPicker.this.colorPicker.getSelectionModel().getSelectedColor(), (int)PaintPicker.this.alphaSlider.getValue());
            PaintPicker.this.firePropertyChange("paint", old, PaintPicker.this.selectedPaint);
        }
    }
}

