/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.popup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import org.oxbow.swingbits.popup.ResizablePopupMenu;

public abstract class PopupWindow {
    private final JPopupMenu menu;
    private Dimension defaultSize = new Dimension(100, 100);

    public PopupWindow(boolean bl) {
        this.menu = new ResizablePopupMenu(bl){
            private static final long serialVersionUID = 1L;

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                if (PopupWindow.this.menu.getComponentCount() == 0) {
                    JComponent jComponent = PopupWindow.this.buildContent();
                    PopupWindow.this.defaultSize = jComponent.getPreferredSize();
                    PopupWindow.this.menu.add(jComponent);
                }
                PopupWindow.this.beforeShow();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                PopupWindow.this.beforeHide();
            }
        };
    }

    public final Dimension getDefaultSize() {
        return this.defaultSize;
    }

    public final Dimension getPreferredSize() {
        return this.menu.getPreferredSize();
    }

    public final void setPreferredSize(Dimension dimension) {
        this.menu.setPreferredSize(dimension);
    }

    protected abstract JComponent buildContent();

    public void show(Component component, int n, int n2) {
        this.menu.show(component, n, n2);
    }

    public void show(Component component, Point point) {
        this.show(component, point.x, point.y);
    }

    public final void hide() {
        this.menu.setVisible(false);
    }

    protected void beforeShow() {
    }

    protected void beforeHide() {
    }

    public class CommandAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CommandAction(String string, Icon icon) {
            super(string, icon);
            if (icon != null) {
                this.putValue("ShortDescription", string);
                this.putValue("Name", null);
            }
        }

        public CommandAction(String string) {
            super(string);
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (this.perform()) {
                PopupWindow.this.hide();
            }
        }

        protected boolean perform() {
            return true;
        }
    }
}

