/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeOption;
import ancestris.modules.releve.merge.MergeOptionPanel;
import ancestris.modules.releve.merge.MergeQuery;
import ancestris.modules.releve.merge.MergeRecord;
import ancestris.modules.releve.merge.MergeTableAction;
import ancestris.util.Utilities;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceRole;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyLatitude;
import genj.gedcom.PropertyLongitude;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyQuality;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.util.ReferenceSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openide.util.NbBundle;

public class ProposalHelper {
    private final Entity m_selectedEntity;
    private final Gedcom m_gedcom;
    private final MergeTableAction.SourceRecordSelection m_sourceAction;
    private final List<MergeTableAction.WitnessRecordSelection> m_witnessActions;
    private final MergeRecord m_record;
    private final boolean showFrenchCalendarDate = true;
    private String m_eventSourceTitle = null;

    public ProposalHelper(MergeRecord record, Entity selectedEntity, Gedcom gedcom) {
        this.m_selectedEntity = selectedEntity;
        this.m_gedcom = gedcom;
        this.m_record = record;
        this.m_sourceAction = new MergeTableAction.SourceRecordSelection(this, this.findSourceInGedcom(null), this.m_gedcom);
        this.m_witnessActions = new ArrayList<MergeTableAction.WitnessRecordSelection>();
        List<MergeRecord.RecordWitness> witnessRecords = record.getWitnesses();
        for (MergeRecord.RecordWitness witness : witnessRecords) {
            Indi indi = ProposalHelper.findWitnessInGedcom(witness, this.m_gedcom);
            this.m_witnessActions.add(new MergeTableAction.WitnessRecordSelection(this, indi, this.m_gedcom, witness));
        }
    }

    Fam createFam() throws GedcomException {
        return (Fam)this.m_gedcom.createEntity("FAM");
    }

    Indi createIndi() throws GedcomException {
        return (Indi)this.m_gedcom.createEntity("INDI");
    }

    Source createSource() throws GedcomException {
        Source newSource = (Source)this.m_gedcom.createEntity("SOUR");
        return newSource;
    }

    String getTagName(PropertyEventDetails eventProperty) {
        return Gedcom.getName((String)eventProperty.getTag());
    }

    Gedcom getGedcom() {
        return this.m_gedcom;
    }

    public List<MergeRecord.RecordWitness> getRecordWitnesses() {
        return this.m_record.getWitnesses();
    }

    final Source findSourceInGedcom(PropertyEventDetails eventProperty) {
        Source result = null;
        String recordSourceTitle = this.getEventSourceTitle();
        if (recordSourceTitle != null && !recordSourceTitle.isEmpty()) {
            for (Entity source : this.m_gedcom.getEntities("SOUR")) {
                String title = ((Source)source).getTitle();
                if (title.equals(recordSourceTitle)) {
                    result = (Source)source;
                    break;
                }
                if (MergeOption.getSourceScopeCity()) {
                    if (title.contains(this.m_record.getEventPlaceCountyName()) && title.contains(this.m_record.getEventPlaceCityName())) {
                        result = (Source)source;
                        break;
                    }
                    if (title.contains(this.m_record.getEventPlaceCityName()) && title.contains(this.m_record.getNotary())) {
                        result = (Source)source;
                        break;
                    }
                } else if (title.contains(this.m_record.getTitle())) {
                    result = (Source)source;
                    break;
                }
                if (eventProperty == null) continue;
                for (Property prop : eventProperty.getProperties("SOUR")) {
                    PropertySource pSource;
                    Entity target;
                    if (!(prop instanceof PropertySource) || !(target = (Entity)(pSource = (PropertySource)prop).getTargetEntity().get()).equals(source)) continue;
                    result = (Source)source;
                    return result;
                }
            }
        }
        return result;
    }

    static final Indi findWitnessInGedcom(MergeRecord.RecordWitness witness, Gedcom gedcom) {
        Indi result = null;
        String wln = Utilities.removeDiacriticsLower((String)witness.getLastName());
        String wfn = Utilities.removeDiacriticsLower((String)witness.getFirstName());
        for (Indi indi : gedcom.getIndis()) {
            String ln = Utilities.removeDiacriticsLower((String)indi.getLastName());
            String fn = Utilities.removeDiacriticsLower((String)indi.getFirstName());
            if (!ln.contains(wln) || !fn.contains(wfn)) continue;
            result = indi;
            break;
        }
        return result;
    }

    public PropertyQuality searchReliabilityInSourceCitation(PropertySource sourceCitation) {
        PropertyQuality reliabilityProperty = null;
        if (sourceCitation != null) {
            reliabilityProperty = (PropertyQuality)sourceCitation.getProperty("QUAY");
        }
        return reliabilityProperty;
    }

    List<PropertySource> searchSourceCitationInEvent(PropertyEventDetails entityEventProperty) {
        String recordSourceTitle = this.getEventSourceTitle();
        ArrayList<PropertySource> sourceCitations = new ArrayList<PropertySource>();
        if (recordSourceTitle != null && !recordSourceTitle.isEmpty() && entityEventProperty != null) {
            for (Property sourceCitation : entityEventProperty.getProperties("SOUR", false)) {
                if (!(sourceCitation instanceof PropertySource)) continue;
                sourceCitations.add((PropertySource)sourceCitation);
            }
        }
        return sourceCitations;
    }

    PropertySource searchSourceCitationMostCompatible(String sourceTitle, List<PropertySource> compatibleSourceCitations) {
        PropertySource bestSourceCitation = null;
        int bestScore = 0;
        for (PropertySource sourceCitation : compatibleSourceCitations) {
            int score = 0;
            Source targetSource = (Source)sourceCitation.getTargetEntity().get();
            if (targetSource != null) {
                String targetSourceTitle = targetSource.getTitle().toLowerCase();
                if (sourceTitle != null && !sourceTitle.isEmpty()) {
                    if (targetSourceTitle.equals(sourceTitle.toLowerCase())) {
                        score += 100;
                    }
                } else {
                    String recordSourceTitle = this.getEventSourceTitle();
                    if (targetSourceTitle.equals(recordSourceTitle)) {
                        score += 100;
                    } else if (targetSourceTitle.contains(this.m_record.getEventPlaceCountyName().toLowerCase()) && targetSourceTitle.contains(this.m_record.getEventPlaceCityName().toLowerCase())) {
                        score += 50;
                    } else if (targetSourceTitle.contains(this.m_record.getEventPlaceCityName().toLowerCase()) && targetSourceTitle.contains(this.m_record.getNotary().toLowerCase())) {
                        score += 50;
                    } else if (targetSourceTitle.contains(this.m_record.getEventPlaceCityName().toLowerCase())) {
                        score += 20;
                    }
                }
            }
            if (score > 0) {
                String page;
                if (!this.m_record.getEventCote().isEmpty() && (page = sourceCitation.getPropertyValue("PAGE")).contains(this.m_record.getEventCote())) {
                    score = page.contains(this.m_record.getEventPage()) ? (score += 10) : (score += 5);
                }
                if (!this.m_record.getEventDeedText().isEmpty()) {
                    for (PropertyMultilineValue textProperty : this.searchTextInSourceCitation(sourceCitation)) {
                        if (!textProperty.getValue().contains(this.m_record.getEventDeedText())) continue;
                        ++score;
                        break;
                    }
                }
            }
            if (score <= bestScore && bestSourceCitation != null) continue;
            bestScore = score;
            bestSourceCitation = sourceCitation;
        }
        return bestSourceCitation;
    }

    public List<PropertyMultilineValue> searchTextInSourceCitation(PropertySource sourceCitationProperty) {
        ArrayList<PropertyMultilineValue> textProperties = new ArrayList<PropertyMultilineValue>();
        if (sourceCitationProperty != null) {
            if (MergeOption.getSourceScopeCity()) {
                for (Property textProperty : sourceCitationProperty.getProperties(new TagPath("SOUR:DATA:TEXT"))) {
                    if (textProperty == null || !(textProperty instanceof PropertyMultilineValue)) continue;
                    PropertyMultilineValue propertyMultiline = (PropertyMultilineValue)textProperty;
                    textProperties.add(propertyMultiline);
                }
            } else {
                Property textProperty = ((Entity)sourceCitationProperty.getTargetEntity().get()).getProperty("TEXT");
                if (textProperty != null && textProperty instanceof PropertyMultilineValue) {
                    PropertyMultilineValue propertyMultiline = (PropertyMultilineValue)textProperty;
                    textProperties.add(propertyMultiline);
                }
            }
        }
        return textProperties;
    }

    public PropertyMultilineValue searchTextWithSameValue(List<PropertyMultilineValue> textProperties, String value) {
        if (!value.isEmpty()) {
            for (PropertyMultilineValue textProperty : textProperties) {
                if (!textProperty.getValue().contains(value)) continue;
                return textProperty;
            }
        }
        if (!textProperties.isEmpty()) {
            return textProperties.get(0);
        }
        return null;
    }

    public List<PropertyMedia> searchMediaInSourceCitation(PropertySource sourceCitationProperty) {
        ArrayList<PropertyMedia> mediaProperties = new ArrayList<PropertyMedia>();
        if (sourceCitationProperty != null) {
            if (MergeOption.getSourceScopeCity()) {
                for (Property mediaProperty : sourceCitationProperty.getProperties(new TagPath("SOUR:OBJE"))) {
                    if (mediaProperty == null || !(mediaProperty instanceof PropertyMedia)) continue;
                    PropertyMedia propertyMedia = (PropertyMedia)mediaProperty;
                    mediaProperties.add(propertyMedia);
                }
            } else {
                Property mediaProperty = ((Entity)sourceCitationProperty.getTargetEntity().get()).getProperty("OBJE");
                if (mediaProperty != null && mediaProperty instanceof PropertyMedia) {
                    PropertyMedia propertyMedia = (PropertyMedia)mediaProperty;
                    mediaProperties.add(propertyMedia);
                }
            }
        }
        return mediaProperties;
    }

    public PropertyMedia searchMediaWithSameValue(List<PropertyMedia> mediaProperties, String value) {
        if (!value.isEmpty()) {
            for (PropertyMedia mediaProperty : mediaProperties) {
                if (!value.contains(ProposalHelper.getFileValue(mediaProperty))) continue;
                return mediaProperty;
            }
        }
        if (!mediaProperties.isEmpty()) {
            return mediaProperties.get(0);
        }
        return null;
    }

    public List<PropertyAssociation> searchWitnessAssociationInEvent(PropertyEventDetails entityEventProperty) {
        ArrayList<PropertyAssociation> assoProperties = new ArrayList<PropertyAssociation>();
        if (entityEventProperty != null) {
            for (Property asso : entityEventProperty.getProperties("ASSO", false)) {
                if (!(asso instanceof PropertyAssociation)) continue;
                PropertyAssociation pAsso = (PropertyAssociation)asso;
                assoProperties.add(pAsso);
            }
        }
        return assoProperties;
    }

    public PropertyAssociation searchWitnessAssociationMostCompatible(MergeRecord.RecordWitness recordWitness, List<PropertyAssociation> associations) {
        String wln = Utilities.removeDiacriticsLower((String)recordWitness.getLastName());
        String wfn = Utilities.removeDiacriticsLower((String)recordWitness.getFirstName());
        for (PropertyAssociation asso : associations) {
            Entity entity = asso.getWitness();
            if (!(entity instanceof Indi)) continue;
            Indi indi = (Indi)entity;
            String ln = Utilities.removeDiacriticsLower((String)indi.getLastName());
            String fn = Utilities.removeDiacriticsLower((String)indi.getFirstName());
            if (!ln.contains(wln) || !fn.contains(wfn)) continue;
            return asso;
        }
        return null;
    }

    public PropertyChoiceRole searchRoleInWitnessAssociation(PropertyAssociation witnessAssociation) {
        PropertyChoiceRole propertyRole = null;
        if (witnessAssociation != null) {
            propertyRole = (PropertyChoiceRole)witnessAssociation.getProperty("ROLE");
        }
        return propertyRole;
    }

    public static String getFileValue(PropertyMedia pMedia) {
        PropertyFile pFile = ProposalHelper.getFileProperty(pMedia);
        return pFile == null ? "" : pFile.getValue();
    }

    public static PropertyFile getFileProperty(PropertyMedia pMedia) {
        if (pMedia == null) {
            return null;
        }
        Media media = (Media)pMedia.getTargetEntity().get();
        return media != null ? (PropertyFile)media.getProperty("FILE", false) : null;
    }

    protected void copyPlace(MergeRecord.RecordResidence residence, Property eventProperty) {
        this.copyPlace(residence.getPlace(), residence.getAddress(), eventProperty);
    }

    protected void copyPlace(String place, String address, Property eventProperty) {
        PropertyPlace propertyPlace = (PropertyPlace)eventProperty.getProperty("PLAC");
        if (propertyPlace == null) {
            propertyPlace = (PropertyPlace)eventProperty.addProperty("PLAC", "");
        }
        propertyPlace.setValue(place);
        if (!place.isEmpty()) {
            ReferenceSet gedcomPlaces = this.m_gedcom.getReferenceSet("PLAC");
            Set similarPlaces = gedcomPlaces.getReferences((Object)place);
            for (Property similarPlace : similarPlaces) {
                if (((PropertyPlace)similarPlace).getMap() == null) continue;
                PropertyPlace similarPropertyPlace = (PropertyPlace)similarPlace;
                PropertyLatitude latitude = similarPropertyPlace.getLatitude(true);
                PropertyLongitude longitude = similarPropertyPlace.getLongitude(true);
                if (latitude == null || longitude == null) continue;
                propertyPlace.setCoordinates(latitude.getValue(), longitude.getValue());
                break;
            }
        }
        if (!address.isEmpty()) {
            Property propertyAddress = eventProperty.getProperty("ADDR");
            if (propertyAddress == null) {
                propertyAddress = eventProperty.addProperty("ADDR", "");
            }
            propertyAddress.setValue(address);
        }
    }

    void copyPlaceCoordinates(PropertyPlace propertyPlace) {
        String placeValue = propertyPlace.getValue();
        if (!placeValue.isEmpty()) {
            ReferenceSet gedcomPlaces = this.m_gedcom.getReferenceSet("PLAC");
            Set similarPlaces = gedcomPlaces.getReferences((Object)placeValue);
            for (Property similarPlace : similarPlaces) {
                if (((PropertyPlace)similarPlace).getMap() == null) continue;
                PropertyPlace similarPropertyPlace = (PropertyPlace)similarPlace;
                PropertyLatitude latitude = similarPropertyPlace.getLatitude(true);
                PropertyLongitude longitude = similarPropertyPlace.getLongitude(true);
                if (latitude == null || longitude == null) continue;
                propertyPlace.setCoordinates(latitude.getValue(), longitude.getValue());
                break;
            }
        }
    }

    protected void copyReferenceNote(Property eventProperty, String subTagName) {
        String noteText = this.getReferenceNote(eventProperty, subTagName);
        Property[] notes = eventProperty.getProperties("NOTE");
        boolean found = false;
        for (Property note : notes) {
            if (!note.getValue().contains(noteText)) continue;
            found = true;
            break;
        }
        if (!found) {
            Property propertyNote = eventProperty.getProperty("NOTE");
            if (propertyNote == null) {
                propertyNote = eventProperty.addProperty("NOTE", "");
            }
            Object value = propertyNote.getValue();
            if (!noteText.isEmpty()) {
                if (!((String)value).isEmpty()) {
                    value = (String)value + "\n";
                }
                value = (String)value + noteText;
                propertyNote.setValue((String)value);
            }
        }
    }

    protected String getReferenceNote(Property eventProperty, String subTageName) {
        String propertyValue;
        String eventTagName = eventProperty.getTag();
        if ("DATE".equals(subTageName)) {
            PropertyDate propertyDate = (PropertyDate)eventProperty.getProperty(subTageName, false);
            propertyValue = propertyDate.getDisplayValue();
            propertyValue = propertyDate.getReportValue(null, GedcomOptions.GedcomDateFormat.SHORT);
            if ("du".equals(propertyDate.getFormat().getPrefix1Name())) {
                propertyValue = propertyDate.getStart().isComplete() ? propertyValue.replace("du", "\u00e0 partir du") : propertyValue.replace("du", "\u00e0 partir de");
            }
            noteText = eventTagName.equals("BIRT") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.date.BIRT.derived") : (eventTagName.equals("DEAT") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.date.DEAT.derived") : (eventTagName.equals("MARR") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.date.MARR.derived") : (eventTagName.equals("OCCU") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.date.OCCU.derived") : (eventTagName.equals("RESI") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.date.RESI.derived") : NbBundle.getMessage(ProposalHelper.class, (String)"note.date.OTHER.derived")))));
        } else if ("PLAC".equals(subTageName)) {
            String place = eventProperty.getPropertyValue("PLAC");
            String address = eventProperty.getPropertyValue("ADDR");
            propertyValue = MergeRecord.appendValue(address, place);
            noteText = eventTagName.equals("BIRT") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.plac.BIRT.derived") : (eventTagName.equals("DEAT") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.plac.DEAT.derived") : (eventTagName.equals("MARR") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.plac.MARR.derived") : (eventTagName.equals("OCCU") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.plac.OCCU.derived") : (eventTagName.equals("RESI") ? NbBundle.getMessage(ProposalHelper.class, (String)"note.plac.RESI.derived") : NbBundle.getMessage(ProposalHelper.class, (String)"note.plac.OTHER.derived")))));
        } else {
            Property property = eventProperty.getProperty(subTageName);
            propertyValue = property.getValue();
            noteText = NbBundle.getMessage(ProposalHelper.class, (String)"note.other.derived", (Object)subTageName, (Object)"{0}");
        }
        String noteText = switch (this.m_record.getRecordType()) {
            case MergeRecord.RecordType.BIRTH -> MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.BIRT.of.on"), propertyValue, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName());
            case MergeRecord.RecordType.MARRIAGE -> MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.MARR.of.on"), propertyValue, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getWife().getFirstName(), this.m_record.getWife().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName());
            case MergeRecord.RecordType.DEATH -> MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.DEAT.of.on"), propertyValue, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName());
            default -> {
                String eventType = this.m_record.isInsinuation() ? this.m_record.getInsinuationType() : this.m_record.getEventTagName();
                switch (this.m_record.getEventTypeTag()) {
                    case "WILL": {
                        yield MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.WILL.of.on"), propertyValue, eventType, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName() + (String)(this.m_record.getNotary().isEmpty() ? "" : ", " + this.m_record.getNotary()));
                    }
                    case "MARB": {
                        yield MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.MARB.of.on"), propertyValue, eventType, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getWife().getFirstName(), this.m_record.getWife().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName() + (String)(this.m_record.getNotary().isEmpty() ? "" : ", " + this.m_record.getNotary()));
                    }
                    case "MARC": {
                        yield MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.MARC.of.on"), propertyValue, eventType, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getWife().getFirstName(), this.m_record.getWife().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName() + (String)(this.m_record.getNotary().isEmpty() ? "" : ", " + this.m_record.getNotary()));
                    }
                    case "MARL": {
                        yield MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.MARL.of.on"), propertyValue, eventType, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getWife().getFirstName(), this.m_record.getWife().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName() + (String)(this.m_record.getNotary().isEmpty() ? "" : ", " + this.m_record.getNotary()));
                    }
                    case "CHR": {
                        yield MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.CHR.of.on"), propertyValue, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName());
                    }
                    case "BURI": {
                        yield MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.BURI.of.on"), propertyValue, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName());
                    }
                    case "CREM": {
                        yield MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.CREM.of.on"), propertyValue, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName());
                    }
                    case "NATU": {
                        yield MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.NATU.of.on"), propertyValue, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName());
                    }
                }
                String wife = this.m_record.getWife().getFirstName() + this.m_record.getWife().getLastName();
                yield wife.isBlank() ? MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.OTHER.of2.on"), propertyValue, eventType, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName() + (String)(this.m_record.getNotary().isEmpty() ? "" : ", " + this.m_record.getNotary())) : MessageFormat.format(noteText + " " + NbBundle.getMessage(ProposalHelper.class, (String)"note.OTHER.of.on"), propertyValue, eventType, this.m_record.getIndi().getFirstName(), this.m_record.getIndi().getLastName(), this.m_record.getWife().getFirstName(), this.m_record.getWife().getLastName(), this.m_record.getEventDateDDMMYYYY(true), this.m_record.getEventPlaceCityName() + (String)(this.m_record.getNotary().isEmpty() ? "" : ", " + this.m_record.getNotary()));
            }
        };
        return noteText;
    }

    String getEventComment() {
        return this.m_record.getEventComment(true);
    }

    final String getEventSourceTitle() {
        if (this.m_eventSourceTitle == null) {
            this.m_eventSourceTitle = "";
            if (this.m_record.getFileName() != null && !this.m_record.getFileName().isEmpty()) {
                this.m_eventSourceTitle = MergeOptionPanel.SourceModel.getModel().getSource(this.m_record.getFileName());
            }
            if (this.m_eventSourceTitle.isEmpty()) {
                this.m_eventSourceTitle = MergeOption.getSourceScopeCity() ? ProposalHelper.appendValue(" ", this.m_record.getEventPlaceCountyName(), this.m_record.getEventPlaceCityName(), this.m_record.getNotary()) : ProposalHelper.appendValue(", ", this.m_record.getTitle(), this.m_record.getEventPlaceCityName());
            }
        }
        return this.m_eventSourceTitle;
    }

    protected static String appendValue(String separator, String ... otherValues) {
        StringBuilder sb = new StringBuilder();
        for (String otherValue : otherValues) {
            if (otherValue.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(otherValue.trim());
        }
        return sb.toString();
    }

    protected int getPropertyBestPosition(Entity entity, PropertyDate propertyDate) {
        int resultPosition = -1;
        if (entity != null && propertyDate != null) {
            int position = 0;
            for (Property child : entity.getProperties()) {
                Property[] childDates;
                if (child.getTag().equals("BIRT")) {
                    int birthPosition = position;
                    resultPosition = birthPosition + 1;
                } else if (!(child.getTag().equals("DEAT") || child.getTag().equals("CREA") || child.getTag().equals("CHAN") || (childDates = child.getProperties("DATE")).length <= 0)) {
                    try {
                        if (!MergeQuery.isRecordBeforeThanDate(propertyDate, (PropertyDate)childDates[0], 0, 0)) {
                            resultPosition = position + 1;
                        }
                    }
                    catch (GedcomException gedcomException) {
                        // empty catch block
                    }
                }
                ++position;
            }
        }
        return resultPosition;
    }

    MergeRecord getRecord() {
        return this.m_record;
    }

    Entity getSelectedEntity() {
        return this.m_selectedEntity;
    }

    public String getEventTag(String typeTag) {
        return typeTag;
    }

    MergeTableAction.SourceRecordSelection getSourceAction() {
        return this.m_sourceAction;
    }

    List<MergeTableAction.WitnessRecordSelection> getWitnessActions() {
        return this.m_witnessActions;
    }
}

