/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import ancestris.util.Utilities;
import genj.search.Matcher;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SimpleMatcher
extends Matcher {
    private String[] words;

    @Override
    public void init(String pattern, boolean case_sensitive) {
        this.case_sensitive = case_sensitive;
        String removedAccents = Utilities.removeDiacriticsLower((String)pattern);
        StringTokenizer tokens = new StringTokenizer(case_sensitive ? pattern : removedAccents);
        this.words = new String[tokens.countTokens()];
        for (int i = 0; i < this.words.length; ++i) {
            this.words[i] = tokens.nextToken();
        }
    }

    @Override
    protected void match(String input, List<Matcher.Match> result) {
        String removedAccents = Utilities.removeDiacriticsLower((String)input);
        ArrayList<Matcher.Match> matches = new ArrayList<Matcher.Match>(this.words.length);
        for (String word : this.words) {
            int start;
            int n = start = this.case_sensitive ? input.indexOf(word) : removedAccents.indexOf(word);
            if (start < 0) {
                return;
            }
            while (start >= 0) {
                int end = start + word.length();
                matches.add(new Matcher.Match(start, end - start));
                start = this.case_sensitive ? input.indexOf(word, start + 1) : removedAccents.indexOf(word, start + 1);
            }
        }
        result.addAll(matches);
    }
}

