/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.SubmitterMatcherOptions;
import ancestris.util.GedcomUtilities;
import genj.gedcom.Submitter;
import java.util.HashSet;

public class SubmitterMatcher
extends EntityMatcher<Submitter, SubmitterMatcherOptions> {
    private static final int[] points = new int[]{-100, -50, 0, 15, 60};

    public SubmitterMatcher() {
        this.options = new SubmitterMatcherOptions();
    }

    @Override
    public int compare(Submitter left, Submitter right) {
        int itemScore = 0;
        int score = 0;
        int sumOfWeights = 0;
        itemScore = COMPARE_UNKNOWN;
        String leftName = GedcomUtilities.normalizeString((String)left.getName());
        String rightName = GedcomUtilities.normalizeString((String)right.getName());
        if (!leftName.isBlank() && !rightName.isBlank()) {
            ++sumOfWeights;
            itemScore = leftName.equals(rightName) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftName, (String)rightName, (int)3));
        }
        score += points[itemScore];
        String leftCity = GedcomUtilities.normalizeString((String)left.getCity());
        String rightCity = GedcomUtilities.normalizeString((String)right.getCity());
        itemScore = COMPARE_UNKNOWN;
        if (!leftCity.isBlank() && !rightCity.isBlank()) {
            ++sumOfWeights;
            itemScore = leftCity.equals(rightCity) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftCity, (String)rightCity, (int)3));
        }
        return (score += points[itemScore]) / sumOfWeights;
    }

    @Override
    public String[] getKeys(Submitter entity) {
        String city;
        HashSet<String> keys = new HashSet<String>();
        String name = entity.getName();
        if (!name.isBlank()) {
            keys.addAll(SubmitterMatcher.getKeyWords(name, 3));
        }
        if (!(city = entity.getCity()).isBlank()) {
            keys.add(city);
        }
        return (String[])keys.toArray(String[]::new);
    }

    @Override
    public String getHexaKey(Submitter entity) {
        return "00";
    }

    @Override
    public void reset() {
    }
}

