/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.FamMatcher;
import ancestris.modules.gedcom.matchers.FamMatcherOptions;
import ancestris.modules.gedcom.matchers.IndiMatcher;
import ancestris.modules.gedcom.matchers.IndiMatcherOptions;
import ancestris.modules.gedcom.matchers.MatcherOptions;
import ancestris.modules.gedcom.matchers.MediaMatcher;
import ancestris.modules.gedcom.matchers.MediaMatcherOptions;
import ancestris.modules.gedcom.matchers.NoteMatcher;
import ancestris.modules.gedcom.matchers.NoteMatcherOptions;
import ancestris.modules.gedcom.matchers.RepositoryMatcher;
import ancestris.modules.gedcom.matchers.RepositoryMatcherOptions;
import ancestris.modules.gedcom.matchers.SourceMatcher;
import ancestris.modules.gedcom.matchers.SourceMatcherOptions;
import ancestris.modules.gedcom.matchers.SubmitterMatcher;
import ancestris.modules.gedcom.matchers.SubmitterMatcherOptions;
import ancestris.util.Utilities;
import ancestris.util.swing.PotentialMatch;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DuplicatesTaskMatchesForAllEntities {
    private final Gedcom gedcom;
    private final TreeMap<String, EntityMatcher> entitiesMatchers = new TreeMap<String, EntityMatcher>(){
        {
            this.put("INDI", new IndiMatcher());
            this.put("FAM", new FamMatcher());
            this.put("NOTE", new NoteMatcher());
            this.put("SNOTE", new NoteMatcher());
            this.put("SOUR", new SourceMatcher());
            this.put("REPO", new RepositoryMatcher());
            this.put("SUBM", new SubmitterMatcher());
            this.put("OBJE", new MediaMatcher());
        }
    };
    private final List<String> entities2Ckeck;
    private final Map<String, ? extends MatcherOptions> selectedOptions;
    private final boolean excludedNonDup;
    private final List<PotentialMatch<? extends Entity>> allEntitiesDuplicates = new LinkedList<PotentialMatch<? extends Entity>>();
    private int progress;
    private int progressMax;
    private boolean cancel;

    public DuplicatesTaskMatchesForAllEntities(Gedcom gedcom, List<String> entities2Ckeck, Map<String, MatcherOptions> selectedOptions, boolean excludedNonDup) {
        this.gedcom = gedcom;
        this.entities2Ckeck = entities2Ckeck;
        this.selectedOptions = selectedOptions;
        this.excludedNonDup = excludedNonDup;
    }

    public void run() {
        if (this.gedcom == null) {
            return;
        }
        this.cancel = false;
        this.progress = 1;
        this.progressMax = this.entities2Ckeck.size();
        for (String tag : this.entities2Ckeck) {
            EntityMatcher entityMatcher = this.entitiesMatchers.get(tag);
            ArrayList entities = new ArrayList(this.gedcom.getEntities(tag));
            switch (tag) {
                case "INDI": {
                    entityMatcher.setOptions((IndiMatcherOptions)this.selectedOptions.get("INDI"));
                    break;
                }
                case "FAM": {
                    entityMatcher.setOptions((FamMatcherOptions)this.selectedOptions.get("FAM"));
                    break;
                }
                case "NOTE": {
                    entityMatcher.setOptions((NoteMatcherOptions)this.selectedOptions.get("NOTE"));
                    break;
                }
                case "SNOTE": {
                    entityMatcher.setOptions((NoteMatcherOptions)this.selectedOptions.get("SNOTE"));
                    break;
                }
                case "REPO": {
                    entityMatcher.setOptions((RepositoryMatcherOptions)this.selectedOptions.get("REPO"));
                    break;
                }
                case "SOUR": {
                    entityMatcher.setOptions((SourceMatcherOptions)this.selectedOptions.get("SOUR"));
                    break;
                }
                case "SUBM": {
                    entityMatcher.setOptions((SubmitterMatcherOptions)this.selectedOptions.get("SUBM"));
                    break;
                }
                case "OBJE": {
                    entityMatcher.setOptions((MediaMatcherOptions)this.selectedOptions.get("OBJE"));
                    break;
                }
            }
            entityMatcher.setInputs(entities, this.excludedNonDup, this.progress, this.progressMax);
            entityMatcher.run();
            List<PotentialMatch<Entity>> entityTypeDuplicates = entityMatcher.getResult();
            for (PotentialMatch<Entity> e : entityTypeDuplicates) {
                if (((Entity)e.getLeft()).getNoOfProperties() >= ((Entity)e.getRight()).getNoOfProperties()) continue;
                e.swap();
            }
            this.allEntitiesDuplicates.addAll(entityTypeDuplicates);
            ++this.progress;
            if (!this.cancel) continue;
            break;
        }
        Collections.sort(this.allEntitiesDuplicates, (e1, e2) -> {
            if (e2.getCertainty() - e1.getCertainty() != 0) {
                return e2.getCertainty() - e1.getCertainty();
            }
            if (!((Entity)e1.getLeft()).getTag().equals(((Entity)e2.getLeft()).getTag())) {
                return this.entities2Ckeck.indexOf(((Entity)e1.getLeft()).getTag()) - this.entities2Ckeck.indexOf(((Entity)e2.getLeft()).getTag());
            }
            return this.normalizeString(((Entity)e1.getLeft()).toString(true)).compareTo(this.normalizeString(((Entity)e2.getLeft()).toString(true)));
        });
    }

    public List<PotentialMatch<? extends Entity>> getResult() {
        return this.allEntitiesDuplicates;
    }

    protected TreeMap<String, EntityMatcher> getEntityMatchers() {
        return this.entitiesMatchers;
    }

    private String normalizeString(String str) {
        String normalized = Utilities.removeDiacriticsLower((String)str);
        normalized = normalized.replaceAll("[^A-Za-z0-9]", " ").replaceAll(" +", " ").trim();
        return normalized;
    }
}

