/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookStarter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class Log {
    private InputOutput io;
    private PrintWriter outFile;
    public boolean NORMAL = true;
    public boolean ERROR = false;
    public boolean endSuccessful = true;

    public Log(String logname, String title) {
        this.io = IOProvider.getDefault().getIO(title, true);
        this.io.select();
        if (logname == null || logname.trim().isEmpty()) {
            this.io.getOut().println("Warning!!! No log file name provided, therefore writing to output window only.");
            return;
        }
        File logFile = new File(logname);
        if (logFile == null) {
            this.io.getErr().println(NbBundle.getMessage(WebBookStarter.class, (String)"LOG_ErrorLogFile"));
        } else {
            try {
                this.outFile = new PrintWriter(new FileWriter(logFile));
            }
            catch (IOException ioe) {
                this.io.getErr().println("IO Exception!");
                ioe.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.outFile != null) {
            this.outFile.flush();
            this.outFile.close();
        }
    }

    public void write(String text) {
        this.write(this.NORMAL, text);
    }

    public void write(boolean mode, String text) {
        if (mode) {
            this.io.getOut().println(text);
        } else {
            this.io.getErr().println(text);
            this.endSuccessful = false;
        }
        if (this.outFile != null) {
            this.outFile.println(text);
        }
    }

    public void timeStamp() {
        this.write(this.NORMAL, Calendar.getInstance().getTime().toString());
    }

    public void printStackTrace(Exception ex) {
        ex.printStackTrace(this.outFile);
        ex.printStackTrace((PrintWriter)this.io.getErr());
        this.endSuccessful = false;
    }

    public void write(int level, int indent, String str, int length, String text) {
        Object line = "";
        for (int i = 1; i <= length; ++i) {
            line = (String)line + str;
        }
        Object indentSpaces = "";
        for (int i = 1; i <= indent; ++i) {
            indentSpaces = (String)indentSpaces + " ";
        }
        if (level == 0) {
            this.write((String)indentSpaces + text);
        }
        if (level == 1) {
            this.write(" ");
            this.write((String)line);
            this.write((String)indentSpaces + text);
            this.write((String)line);
        }
        if (level == 2) {
            this.write((String)line);
            this.write((String)indentSpaces + text);
            this.write(" ");
        }
        if (level == 9) {
            this.write(" ");
            this.write((String)line);
            this.write((String)indentSpaces + "##### " + text + " #####");
            this.write((String)line);
            this.write(" ");
        }
    }

    public void timeStamp(int indent, String str) {
        this.write(0, indent, "", 0, str + Calendar.getInstance().getTime().toString());
    }

    public String trs(String string) {
        return NbBundle.getMessage(WebBook.class, (String)string);
    }

    public String trs(String string, Object param1) {
        return NbBundle.getMessage(WebBook.class, (String)string, (Object)param1);
    }

    public String trs(String string, Object param1, Object param2) {
        return NbBundle.getMessage(WebBook.class, (String)string, (Object)param1, (Object)param2);
    }

    public String trs(String string, Object param1, Object param2, Object param3) {
        return NbBundle.getMessage(WebBook.class, (String)string, (Object)param1, (Object)param2, (Object)param3);
    }

    public String trs(String string, Object param1, Object param2, Object param3, Object param4) {
        return NbBundle.getMessage(WebBook.class, (String)string, (Object)param1, (Object)param2, (Object)param3, (Object)param4, (Object[])new Object[0]);
    }

    public String trs(String string, Object[] arr) {
        return NbBundle.getMessage(WebBook.class, (String)string, (Object[])arr);
    }
}

